/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.common;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;

public abstract class ClassPathIntrospector {
    private final ClassLoader projectClassLoader;
    private final Reflections reflections;

    protected ClassPathIntrospector(URL ... projectClassesLocations) {
        this.projectClassLoader = new URLClassLoader(projectClassesLocations, null);
        this.reflections = new Reflections((Configuration)new ConfigurationBuilder().addClassLoader(this.projectClassLoader).addUrls(projectClassesLocations));
    }

    protected ClassPathIntrospector(ClassPathIntrospector otherIntrospector) {
        this.projectClassLoader = otherIntrospector.projectClassLoader;
        this.reflections = otherIntrospector.reflections;
    }

    protected Stream<Class<?>> getAnnotatedClasses(Class<? extends Annotation> annotationInProjectContext) {
        Set annotatedBySingleAnnotation = this.reflections.getTypesAnnotatedWith(annotationInProjectContext, true);
        Set<Class<?>> annotatedByRepeatedAnnotation = this.getAnnotatedByRepeatedAnnotation(annotationInProjectContext);
        return Stream.concat(annotatedBySingleAnnotation.stream(), annotatedByRepeatedAnnotation.stream());
    }

    protected <T> Class<T> loadClassInProjectClassLoader(String className) {
        try {
            return this.projectClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(String.format("Failed to load class '%s' in custom classloader", className), e);
        }
    }

    protected String invokeAnnotationMethod(Annotation target, String methodName) {
        return String.valueOf(this.doInvokeAnnotationMethod(target, methodName));
    }

    protected Object doInvokeAnnotationMethod(Annotation target, String methodName) {
        try {
            return target.getClass().getDeclaredMethod(methodName, new Class[0]).invoke((Object)target, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(String.format("Failed to access method '%s' in annotation interface '%s', should not be happening due to JLS definition of annotation interface", methodName, target), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(String.format("Got an exception by invoking method '%s' from annotation '%s'", methodName, target), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Annotation '%s' has no method named `%s", target, methodName), e);
        }
    }

    private Set<Class<?>> getAnnotatedByRepeatedAnnotation(AnnotatedElement annotationClass) {
        Repeatable repeatableAnnotation = annotationClass.getAnnotation(Repeatable.class);
        if (repeatableAnnotation != null) {
            return this.reflections.getTypesAnnotatedWith(repeatableAnnotation.value(), true);
        }
        return Collections.emptySet();
    }
}

