/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.common;

import com.github.eirslett.maven.plugins.frontend.lib.DefaultGulpRunnerLocal;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultYarnRunnerLocal;
import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.GulpRunner;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.NodeExecutorConfigLocal;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.github.eirslett.maven.plugins.frontend.lib.YarnConfigurationLocal;
import com.github.eirslett.maven.plugins.frontend.lib.YarnExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.YarnRunner;
import com.helger.commons.url.URLValidator;
import com.vaadin.flow.plugin.common.FrontendToolsLocator;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunnerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunnerManager.class);
    private final FrontendToolsLocator toolsLocator;
    private final YarnRunner yarnRunner;
    private final GulpRunner gulpRunner;

    private RunnerManager(Builder builder) {
        this.toolsLocator = builder.toolsLocator;
        Optional<File> localNodePath = this.getToolPath(builder.nodePath, builder.autodetectTools, "node");
        if (localNodePath.isPresent()) {
            this.gulpRunner = new DefaultGulpRunnerLocal(new NodeExecutorConfigLocal(localNodePath.get(), null, builder.workingDirectory, builder.workingDirectory)).getDefaultGulpRunner();
            this.yarnRunner = this.getToolPath(builder.yarnPath, builder.autodetectTools, "yarn").map(localYarnPath -> new YarnConfigurationLocal((File)localNodePath.get(), (File)localYarnPath, builder.workingDirectory)).map(config -> new DefaultYarnRunnerLocal((YarnExecutorConfig)config, builder.proxyConfig, this.validateUrl(builder.npmRegistryUrl))).map(DefaultYarnRunnerLocal::getDefaultYarnRunner).orElseGet(() -> this.downloadYarn(builder.workingDirectory, builder.proxyConfig, builder.npmRegistryUrl, builder.yarnVersion));
        } else {
            LOGGER.debug("Downloading the tools required into '{}' directory", (Object)builder.workingDirectory);
            this.gulpRunner = this.downloadNode(builder.workingDirectory, builder.proxyConfig, builder.nodeVersion);
            this.yarnRunner = this.downloadYarn(builder.workingDirectory, builder.proxyConfig, builder.npmRegistryUrl, builder.yarnVersion);
        }
    }

    private GulpRunner downloadNode(File workingDirectory, ProxyConfig proxyConfig, String nodeVersion) {
        FrontendPluginFactory factory = new FrontendPluginFactory(workingDirectory, workingDirectory);
        try {
            factory.getNodeInstaller(proxyConfig).setNodeVersion(nodeVersion).setNodeDownloadRoot("https://nodejs.org/dist/").install();
        }
        catch (InstallationException e) {
            throw new IllegalStateException("Failed to download node", e);
        }
        return factory.getGulpRunner();
    }

    private YarnRunner downloadYarn(File workingDirectory, ProxyConfig proxyConfig, String npmRegistryUrl, String yarnVersion) {
        FrontendPluginFactory factory = new FrontendPluginFactory(workingDirectory, workingDirectory);
        try {
            factory.getYarnInstaller(proxyConfig).setYarnVersion(yarnVersion).setYarnDownloadRoot("https://github.com/yarnpkg/yarn/releases/download/").install();
        }
        catch (InstallationException e) {
            throw new IllegalStateException("Failed to download yarn", e);
        }
        return factory.getYarnRunner(proxyConfig, this.validateUrl(npmRegistryUrl));
    }

    private Optional<File> getToolPath(File toolPath, boolean autodetect, String toolName) {
        if (toolPath != null && this.toolsLocator.verifyTool(toolPath)) {
            LOGGER.debug("Using {} at path '{}'", (Object)toolName, (Object)toolPath);
            return Optional.of(toolPath);
        }
        if (autodetect) {
            LOGGER.debug("Autodetect is enabled, attempting to locate {} installation", (Object)toolName);
            Optional<File> autodetectedPath = this.toolsLocator.tryLocateTool(toolName);
            autodetectedPath.ifPresent(path -> LOGGER.debug("Using automatically detected {} at path '{}'", (Object)toolName, path));
            return autodetectedPath;
        }
        LOGGER.debug("Found no local installation for {}", (Object)toolName);
        return Optional.empty();
    }

    public YarnRunner getYarnRunner() {
        return this.yarnRunner;
    }

    public GulpRunner getGulpRunner() {
        return this.gulpRunner;
    }

    private String validateUrl(String url) {
        if (URLValidator.isValid((String)url)) {
            return url;
        }
        if (url != null) {
            LOGGER.warn("Provided npmRegistryURL '{}' is not valid. Ignoring customized NPM registry URL. Default NPM registry URL will be used instead.", (Object)url);
        }
        return null;
    }

    public static class Builder {
        private String nodeVersion;
        private File nodePath;
        private String yarnVersion;
        private File yarnPath;
        private String npmRegistryUrl;
        private boolean autodetectTools;
        private FrontendToolsLocator toolsLocator = new FrontendToolsLocator();
        private final File workingDirectory;
        private final ProxyConfig proxyConfig;

        public Builder(File workingDirectory, ProxyConfig proxyConfig) {
            this.workingDirectory = workingDirectory;
            this.proxyConfig = proxyConfig;
        }

        public Builder versionsToDownload(String nodeVersion, String yarnVersion) {
            this.nodeVersion = nodeVersion;
            this.yarnVersion = yarnVersion;
            return this;
        }

        public Builder localInstallations(File nodePath, File yarnPath) {
            this.nodePath = nodePath;
            this.yarnPath = yarnPath;
            return this;
        }

        public Builder npmRegistryUrl(String npmRegistryUrl) {
            this.npmRegistryUrl = npmRegistryUrl;
            return this;
        }

        public Builder frontendToolsLocator(FrontendToolsLocator toolsLocator) {
            this.toolsLocator = Objects.requireNonNull(toolsLocator);
            return this;
        }

        public Builder autodetectTools(boolean autodetectTools) {
            this.autodetectTools = autodetectTools;
            return this;
        }

        public RunnerManager build() {
            if (this.nodePath == null && this.nodeVersion == null && !this.autodetectTools) {
                throw new IllegalStateException("There is no way to use node in the system: automatic detection is disabled, no path to a local installation or version to download is specified");
            }
            if (this.yarnPath == null && this.yarnVersion == null && !this.autodetectTools) {
                throw new IllegalStateException("There is no way to use yarn in the system: automatic detection is disabled, no path to a local installation or version to download is specified");
            }
            return new RunnerManager(this);
        }
    }
}

