/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.common;

import com.github.eirslett.maven.plugins.frontend.lib.TaskRunnerException;
import com.google.common.collect.ImmutableMap;
import com.vaadin.flow.plugin.common.FlowPluginFileUtils;
import com.vaadin.flow.plugin.common.FrontendDataProvider;
import com.vaadin.flow.plugin.common.RunnerManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontendToolsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrontendToolsManager.class);
    private final RunnerManager runnerManager;
    private final File workingDirectory;
    private final String es5OutputDirectoryName;
    private final String es6OutputDirectoryName;
    private final FrontendDataProvider frontendDataProvider;

    public FrontendToolsManager(File workingDirectory, String es5OutputDirectoryName, String es6OutputDirectoryName, FrontendDataProvider frontendDataProvider, RunnerManager runnerManager) {
        FlowPluginFileUtils.forceMkdir(Objects.requireNonNull(workingDirectory));
        this.runnerManager = Objects.requireNonNull(runnerManager);
        this.workingDirectory = workingDirectory;
        this.es5OutputDirectoryName = Objects.requireNonNull(es5OutputDirectoryName);
        this.es6OutputDirectoryName = Objects.requireNonNull(es6OutputDirectoryName);
        this.frontendDataProvider = Objects.requireNonNull(frontendDataProvider);
    }

    public void installFrontendTools(int networkConcurrency) {
        LOGGER.info("Installing required frontend tools to '{}'", (Object)this.workingDirectory);
        this.createFileFromTemplateResource("package.json", Collections.emptyMap());
        this.createFileFromTemplateResource("yarn.lock", Collections.emptyMap());
        try {
            StringBuilder args = new StringBuilder("install");
            if (networkConcurrency >= 0) {
                args.append(" --network-concurrency ");
                args.append(networkConcurrency);
            }
            this.runnerManager.getYarnRunner().execute(args.toString(), Collections.emptyMap());
        }
        catch (TaskRunnerException e) {
            throw new IllegalStateException("Failed to install required frontend dependencies", e);
        }
    }

    private void createFileFromTemplateResource(String templateResourceName, Map<String, String> replacements) {
        try (InputStream resource = this.getClass().getClassLoader().getResourceAsStream(templateResourceName);){
            if (resource == null) {
                throw new IllegalStateException(String.format("File '%s' is not found in application resources", templateResourceName));
            }
            String resourceContents = IOUtils.toString((InputStream)resource, (Charset)StandardCharsets.UTF_8);
            for (Map.Entry<String, String> replacement : replacements.entrySet()) {
                resourceContents = resourceContents.replaceFirst(Pattern.quote(replacement.getKey()), replacement.getValue().replace("\\", "/"));
            }
            FileUtils.write((File)new File(this.workingDirectory, templateResourceName), (CharSequence)resourceContents, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to create a file in '%s'", this.workingDirectory), e);
        }
    }

    public Map<String, File> transpileFiles(File es6SourceDirectory, File outputDirectory, boolean skipEs5) {
        LOGGER.info("Processing frontend files from '{}'", (Object)es6SourceDirectory);
        try {
            FileUtils.forceMkdir((File)Objects.requireNonNull(outputDirectory));
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to create output directory '%s'", outputDirectory), e);
        }
        if (!Objects.requireNonNull(es6SourceDirectory).isDirectory()) {
            throw new IllegalArgumentException(String.format("es6SourceDirectory '%s' is not a directory or does not exist", es6SourceDirectory));
        }
        ImmutableMap.Builder gulpFileParameters = new ImmutableMap.Builder().put((Object)"{es6_source_directory}", (Object)es6SourceDirectory.getAbsolutePath()).put((Object)"{target_directory}", (Object)outputDirectory.getAbsolutePath()).put((Object)"{es5_configuration_name}", (Object)this.es5OutputDirectoryName).put((Object)"{es6_configuration_name}", (Object)this.es6OutputDirectoryName).put((Object)"{bundle}", (Object)Boolean.toString(this.frontendDataProvider.shouldBundle())).put((Object)"{minify}", (Object)Boolean.toString(this.frontendDataProvider.shouldMinify())).put((Object)"{hash}", (Object)Boolean.toString(this.frontendDataProvider.shouldHash())).put((Object)"{shell_file}", (Object)this.frontendDataProvider.createShellFile(this.workingDirectory)).put((Object)"{fragment_files}", (Object)this.combineFilePathsIntoString(this.frontendDataProvider.createFragmentFiles(this.workingDirectory)));
        this.createFileFromTemplateResource("gulpfile.js", (Map<String, String>)gulpFileParameters.build());
        HashMap<String, File> transpilationResults = new HashMap<String, File>();
        try {
            this.runnerManager.getGulpRunner().execute("build_es6", Collections.emptyMap());
            this.addTranspilationResult(transpilationResults, outputDirectory, this.es6OutputDirectoryName);
            if (!skipEs5) {
                this.runnerManager.getGulpRunner().execute("build_es5", Collections.emptyMap());
                this.addTranspilationResult(transpilationResults, outputDirectory, this.es5OutputDirectoryName);
            }
        }
        catch (TaskRunnerException e) {
            throw new IllegalStateException("Transpilation with gulp has failed", e);
        }
        return transpilationResults;
    }

    private String combineFilePathsIntoString(Set<String> fragmentFiles) {
        return fragmentFiles.stream().map(fileName -> "'" + fileName + "'").collect(Collectors.joining(", "));
    }

    private void addTranspilationResult(Map<String, File> transpilationResults, File outputDirectory, String configurationName) {
        File configurationOutput = FileUtils.getFile((File)outputDirectory, (String[])new String[]{configurationName});
        if (!configurationOutput.isDirectory()) {
            throw new IllegalStateException(String.format("Unable to find transpilation result directory at '%s'", configurationOutput));
        }
        transpilationResults.put(configurationName, configurationOutput);
    }
}

