/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.production;

import com.vaadin.flow.plugin.common.ArtifactData;
import com.vaadin.flow.plugin.common.FlowPluginFileUtils;
import com.vaadin.flow.plugin.common.JarContentsManager;
import com.vaadin.flow.plugin.production.WebJarPackage;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductionModeCopyStep {
    public static final String NON_WEB_JAR_RESOURCE_PATH = "META-INF/resources/frontend";
    static final String WEB_JAR_FILES_BASE = "META-INF/resources/webjars/";
    private static final Logger LOGGER = LoggerFactory.getLogger(ProductionModeCopyStep.class);
    private static final String BOWER_JSON_FILE_NAME = "bower.json";
    private static final String PACKAGE_JSON_FILE_NAME = "package.json";
    private static final String BOWER_COMPONENTS_DIRECTORY_NAME = "bower_components";
    private final JarContentsManager jarContentsManager;
    private final Set<File> nonWebJars = new HashSet<File>();
    private final Map<String, WebJarPackage> webJarNameToPackage = new HashMap<String, WebJarPackage>();

    public ProductionModeCopyStep(Collection<ArtifactData> projectArtifacts) {
        this(new JarContentsManager(), projectArtifacts);
    }

    public ProductionModeCopyStep(JarContentsManager jarContentsManager, Collection<ArtifactData> projectArtifacts) {
        this.jarContentsManager = Objects.requireNonNull(jarContentsManager);
        for (ArtifactData artifact : projectArtifacts) {
            File artifactFile = artifact.getFileOrDirectory();
            if (artifactFile.isFile()) {
                if (jarContentsManager.containsPath(artifactFile, WEB_JAR_FILES_BASE)) {
                    this.storeWebJarData(artifact);
                    continue;
                }
                this.nonWebJars.add(artifactFile);
                continue;
            }
            LOGGER.debug("Skipping project artifact '{}' because it does not exist or not a file", (Object)artifact);
        }
    }

    private void storeWebJarData(ArtifactData webJar) {
        this.getWebJarFiles(webJar).stream().map(bowerJsonPath -> new WebJarPackage(webJar, this.getPackageName(webJar, (String)bowerJsonPath), this.getPackageDirectory((String)bowerJsonPath))).forEach(webJarPackage -> this.webJarNameToPackage.merge(webJarPackage.getPackageName(), (WebJarPackage)webJarPackage, WebJarPackage::selectCorrectPackage));
    }

    private List<String> getWebJarFiles(ArtifactData webJar) {
        List<String> bowerJsonFiles = this.jarContentsManager.findFiles(webJar.getFileOrDirectory(), WEB_JAR_FILES_BASE, BOWER_JSON_FILE_NAME);
        if (!bowerJsonFiles.isEmpty()) {
            return bowerJsonFiles;
        }
        List<String> packageJsonFallback = this.jarContentsManager.findFiles(webJar.getFileOrDirectory(), WEB_JAR_FILES_BASE, PACKAGE_JSON_FILE_NAME);
        if (packageJsonFallback.isEmpty()) {
            LOGGER.warn("Found no bower.json or package.json files inside {}. No files will be extracted.", (Object)webJar);
        }
        return packageJsonFallback;
    }

    private String getPackageDirectory(String bowerJsonPath) {
        return bowerJsonPath.substring(0, bowerJsonPath.lastIndexOf(47) + 1);
    }

    private String getPackageName(ArtifactData webJar, String nameSourceJarPath) {
        String fileContents;
        try {
            fileContents = IOUtils.toString((byte[])this.jarContentsManager.getFileContents(webJar.getFileOrDirectory(), nameSourceJarPath), (String)StandardCharsets.UTF_8.displayName());
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to read file '%s' from webJar '%s'", nameSourceJarPath, webJar.getFileOrDirectory()), e);
        }
        JsonObject jsonObject = Json.parse((String)fileContents);
        if (jsonObject.hasKey("name")) {
            String name = jsonObject.getString("name");
            return name.substring(name.lastIndexOf(47) + 1);
        }
        throw new IllegalStateException(String.format("Incorrect WebJar '%s': file '%s' inside it has no 'name' field", webJar, nameSourceJarPath));
    }

    public void copyWebApplicationFiles(File outputDirectory, File frontendWorkingDirectory, String commaSeparatedWildcardPathExclusions) {
        LOGGER.info("Copying web application files to '{}'", (Object)outputDirectory);
        FlowPluginFileUtils.forceMkdir(outputDirectory);
        String[] wildcardExclusions = this.getWildcardExclusions(commaSeparatedWildcardPathExclusions);
        if (frontendWorkingDirectory != null && frontendWorkingDirectory.isDirectory()) {
            try {
                FileUtils.copyDirectory((File)frontendWorkingDirectory, (File)outputDirectory, (FileFilter)this.generateFilterWithExclusions(wildcardExclusions));
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Failed to copy contents from `%s` to `%s`", frontendWorkingDirectory, outputDirectory), e);
            }
        }
        if (!this.webJarNameToPackage.isEmpty()) {
            File bowerComponents = new File(outputDirectory, BOWER_COMPONENTS_DIRECTORY_NAME);
            this.webJarNameToPackage.forEach((name, webJarPackage) -> {
                File webJarDirectory = new File(bowerComponents, (String)name);
                FlowPluginFileUtils.forceMkdir(webJarDirectory);
                this.jarContentsManager.copyFilesFromJarTrimmingBasePath(webJarPackage.getWebJar().getFileOrDirectory(), webJarPackage.getPathToPackage(), webJarDirectory, wildcardExclusions);
            });
        }
        for (File notWebJar : this.nonWebJars) {
            this.jarContentsManager.copyFilesFromJarTrimmingBasePath(notWebJar, NON_WEB_JAR_RESOURCE_PATH, outputDirectory, wildcardExclusions);
        }
    }

    private FileFilter generateFilterWithExclusions(String ... pathExclusions) {
        if (pathExclusions == null || pathExclusions.length == 0) {
            return null;
        }
        return pathname -> Stream.of(pathExclusions).noneMatch(exclusionRule -> FilenameUtils.wildcardMatch((String)pathname.getName(), (String)exclusionRule));
    }

    private String[] getWildcardExclusions(String commaSeparatedWildcardPathExclusions) {
        if (commaSeparatedWildcardPathExclusions == null || commaSeparatedWildcardPathExclusions.isEmpty()) {
            return new String[0];
        }
        return commaSeparatedWildcardPathExclusions.trim().replaceAll("[\\s]*,[\\s]*", ",").split(",");
    }
}

