/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontendToolsLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrontendToolsLocator.class);

    public Optional<File> tryLocateTool(String toolName) {
        return this.executeCommand(this.isWindows() ? "where" : "which", toolName).map(this::omitErrorResult).map(rec$ -> ((CommandResult)rec$).getStdout()).orElse(Collections.emptyList()).stream().map(File::new).filter(this::verifyTool).findFirst();
    }

    public boolean verifyTool(File toolPath) {
        return this.executeCommand(toolPath.getAbsolutePath(), "-v").map(this::omitErrorResult).isPresent();
    }

    boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.toLowerCase().startsWith("windows");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<CommandResult> executeCommand(String ... commandParts) {
        List stderr;
        List stdout;
        Process process;
        String commandString = Arrays.toString(commandParts);
        try {
            process = new ProcessBuilder(commandParts).start();
        }
        catch (IOException e) {
            LOGGER.error("Failed to execute the command '{}'", (Object)commandString, (Object)e);
            return Optional.empty();
        }
        boolean commandExited = false;
        try {
            commandExited = process.waitFor(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Unexpected interruption happened during '{}' command execution", (Object)commandString, (Object)e);
            Optional<CommandResult> optional = Optional.empty();
            return optional;
        }
        finally {
            if (!commandExited) {
                process.destroyForcibly();
            }
        }
        if (!commandExited) {
            LOGGER.error("Could not get a response from '{}' command in 3 seconds", (Object)commandString);
            return Optional.empty();
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
            stdout = br.lines().collect(Collectors.toList());
        }
        catch (IOException e) {
            LOGGER.error("Failed to read the command '{}' stdout", (Object)commandString, (Object)e);
            return Optional.empty();
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));){
            stderr = br.lines().collect(Collectors.toList());
        }
        catch (IOException e) {
            LOGGER.error("Failed to read the command '{}' stderr", (Object)commandString, (Object)e);
            return Optional.empty();
        }
        return Optional.of(new CommandResult(commandString, process.exitValue(), stdout, stderr));
    }

    private CommandResult omitErrorResult(CommandResult commandResult) {
        if (!commandResult.isSuccessful()) {
            LOGGER.error("Command '{}' exited with non-zero exit code: {}. stdout:\n'{}'\nstderr:\n'{}'", new Object[]{commandResult.command, commandResult.exitCode, commandResult.exitCode, String.join((CharSequence)"\n", commandResult.stderr)});
            return null;
        }
        if (commandResult.stdout.isEmpty()) {
            LOGGER.error("Command '{}' has no output, stderr:\n'{}'", (Object)commandResult.command, (Object)String.join((CharSequence)"\n", commandResult.stderr));
            return null;
        }
        if (!commandResult.stderr.isEmpty()) {
            LOGGER.error("Command '{}' has non-empty stderr:\n'{}'", (Object)commandResult.command, (Object)String.join((CharSequence)"\n", commandResult.stderr));
            return null;
        }
        return commandResult;
    }

    private static class CommandResult {
        private final String command;
        private final int exitCode;
        private final List<String> stdout;
        private final List<String> stderr;

        private CommandResult(String command, int exitCode, List<String> stdout, List<String> stderr) {
            this.command = command;
            this.exitCode = exitCode;
            this.stdout = stdout;
            this.stderr = stderr;
        }

        private List<String> getStdout() {
            return this.stdout;
        }

        private boolean isSuccessful() {
            return this.exitCode == 0;
        }
    }
}

