/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.common;

import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.plugin.common.ClassPathIntrospector;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.Theme;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemedURLTranslator
extends ClassPathIntrospector {
    static final String VALUE = "value";
    private final Class<? extends AbstractTheme> themeClass = this.findTheme();
    private final transient Function<String, File> fileFactory;
    private static final String TRANSLATE_URL_METHOD = "translateUrl";
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemedURLTranslator.class);
    private static final String ABSENT_METHOD_ERROR = String.format("There is no method '%s' in the class '%s', consider updating flow-server dependency", "translateUrl", AbstractTheme.class.getName());

    public ThemedURLTranslator(Function<String, File> fileFactory, ClassPathIntrospector otherIntrospector) {
        super(otherIntrospector);
        this.fileFactory = fileFactory;
    }

    public Set<String> applyTheme(Set<String> urls) {
        if (this.themeClass == null) {
            LOGGER.info("No Theme available");
            return urls;
        }
        HashSet<String> resultingUrls = new HashSet<String>();
        for (String url : urls) {
            String translatedUrl = this.translateUrl(url);
            if (this.sourceDirectoryHasFile(translatedUrl)) {
                LOGGER.debug("The URL '{}' has been translated to the url '{}' using theme '{}'", new Object[]{url, translatedUrl, this.themeClass.getSimpleName()});
                resultingUrls.add(translatedUrl);
                continue;
            }
            LOGGER.debug("The theme '{}' gives '{}' as a translation for url '{}' but the file is not found on the filesystem", new Object[]{this.themeClass.getSimpleName(), translatedUrl, url});
            resultingUrls.add(url);
        }
        return resultingUrls;
    }

    private String translateUrl(String url) {
        Object theme = ReflectTools.createInstance(this.themeClass);
        Method translateMethod = Stream.of(this.themeClass.getMethods()).filter(method -> method.getName().equals(TRANSLATE_URL_METHOD)).findFirst().orElseThrow(() -> new IllegalStateException(ABSENT_METHOD_ERROR));
        try {
            return (String)translateMethod.invoke(theme, url);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw new RuntimeException(String.format("Unable to invoke '%s' on the theme instance with type '%s' and the given URL '%s'", TRANSLATE_URL_METHOD, this.themeClass.getName(), url), exception);
        }
    }

    private boolean sourceDirectoryHasFile(String url) {
        File file = this.fileFactory.apply(url);
        if (!file.exists()) {
            LOGGER.warn("The translated URL '{}' has no corresponding file on the filesystem, the file is addressed by path='{}'", (Object)url, (Object)file.getPath());
            return false;
        }
        if (!file.isFile()) {
            LOGGER.warn("The translated URL '{}' corresponding path '{}' on the filesystem is not a file", (Object)url, (Object)file.getPath());
            return false;
        }
        return true;
    }

    private Class<? extends AbstractTheme> findTheme() {
        Class theme = this.loadClassInProjectClassLoader(Theme.class.getName());
        Map<Class, List> themedComponents = this.getAnnotatedClasses(theme).collect(Collectors.toMap(clazz -> this.getTheme((Class<?>)clazz, theme), Collections::singletonList, this::mergeLists));
        if (themedComponents.size() > 1) {
            throw new IllegalStateException("Multiple themes are not supported, " + themedComponents.entrySet().stream().map(this::printThemeAnnotatedClasses).collect(Collectors.joining(",\n")));
        }
        return themedComponents.size() == 1 ? themedComponents.keySet().iterator().next() : this.loadLumoThemeClassIfAvailable();
    }

    private Class<? extends AbstractTheme> loadLumoThemeClassIfAvailable() {
        try {
            return this.loadClassInProjectClassLoader("com.vaadin.flow.theme.lumo.Lumo");
        }
        catch (IllegalStateException e) {
            LOGGER.trace("Lumo class was not found in the project classpath", (Throwable)e);
            return null;
        }
    }

    private Class<? extends AbstractTheme> getTheme(Class<?> clazz, Class<? extends Annotation> themeClass) {
        Annotation annotation = clazz.getAnnotation(themeClass);
        if (annotation == null) {
            return null;
        }
        return (Class)this.doInvokeAnnotationMethod(annotation, VALUE);
    }

    private List<Class<?>> mergeLists(List<Class<?>> list1, List<Class<?>> list2) {
        if (list1 instanceof ArrayList) {
            list1.addAll(list2);
            return list1;
        }
        ArrayList list = new ArrayList();
        list.addAll(list1);
        list.addAll(list2);
        return list;
    }

    private String printThemeAnnotatedClasses(Map.Entry<Class<? extends AbstractTheme>, List<Class<?>>> entry) {
        StringBuilder builder;
        if (entry.getKey() == null) {
            builder = new StringBuilder("No theme ");
        } else {
            builder = new StringBuilder("Theme '");
            builder.append(entry.getKey()).append("'");
        }
        builder.append(" is discovered for classes which are navigation targets: ");
        builder.append(entry.getValue().stream().map(Class::getName).collect(Collectors.joining(", ")));
        return builder.toString();
    }

    static {
        assert (Stream.of(AbstractTheme.class.getMethods()).map(Method::getName).anyMatch(name -> name.equals(TRANSLATE_URL_METHOD))) : ABSENT_METHOD_ERROR;
    }
}

