/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.vaadin.flow.plugin.common.FlowPluginFrontendUtils;
import com.vaadin.flow.plugin.migration.CopyMigratedResourcesStep;
import com.vaadin.flow.plugin.migration.CopyResourcesStep;
import com.vaadin.flow.plugin.migration.CreateMigrationJsonsStep;
import com.vaadin.flow.plugin.migration.RewriteLegacyAnnotationsStep;
import com.vaadin.flow.server.frontend.FrontendUtils;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="migrate-to-p3", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class MigrateMojo
extends AbstractMojo {
    private static final String DEPENDENCIES = "dependencies";
    @Parameter
    private String[] resources;
    @Parameter(defaultValue="${project.build.directory}/migration")
    private File migrateFolder;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.basedir}/frontend")
    private File frontendDirectory;
    @Parameter(defaultValue="false")
    private boolean keepOriginal;
    @Parameter(defaultValue="true")
    private boolean ignoreModulizerErrors;
    @Parameter(defaultValue="ALWAYS")
    private AnnotationsRewriteStrategy annotationsRewrite;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set<String> externalComponents;
        Map<String, List<String>> paths;
        this.prepareMigrationDirectory();
        List bowerCommands = FrontendUtils.getBowerExecutable((String)this.migrateFolder.getPath());
        boolean needInstallBower = bowerCommands.isEmpty();
        if (!this.ensureTools(needInstallBower)) {
            throw new MojoExecutionException("Could not install tools required for migration (bower or modulizer)");
        }
        if (needInstallBower) {
            bowerCommands = FrontendUtils.getBowerExecutable((String)this.migrateFolder.getPath());
        }
        if (bowerCommands.isEmpty()) {
            throw new MojoExecutionException("Could not locate bower. Install it manually on your system and re-run migration goal.");
        }
        CopyResourcesStep copyStep = new CopyResourcesStep(this.migrateFolder, this.getResources());
        try {
            paths = copyStep.copyResources();
            externalComponents = copyStep.getBowerComponents();
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Couldn't copy resources from source directories " + Arrays.asList(this.getResources()) + " to the target directory " + this.migrateFolder, exception);
        }
        Set<String> migratedTopLevelDirs = Stream.of(this.migrateFolder.listFiles()).filter(file -> file.isDirectory()).map(File::getName).collect(Collectors.toSet());
        ArrayList<String> allPaths = new ArrayList<String>();
        paths.values().stream().forEach(allPaths::addAll);
        try {
            new CreateMigrationJsonsStep(this.migrateFolder).createJsons(allPaths);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Couldn't generate json files", exception);
        }
        if (!this.saveBowerComponents(bowerCommands, externalComponents)) {
            throw new MojoFailureException("Could not install bower components");
        }
        this.installNpmPackages();
        boolean modulizerHasErrors = false;
        if (!this.runModulizer()) {
            modulizerHasErrors = true;
            if (this.ignoreModulizerErrors) {
                this.getLog().info((CharSequence)"Modulizer has exited with error");
            } else {
                throw new MojoFailureException("Modulizer has exited with error. Unable to proceed.");
            }
        }
        if (!this.frontendDirectory.exists()) {
            try {
                FileUtils.forceMkdir((File)this.frontendDirectory);
            }
            catch (IOException exception) {
                throw new UncheckedIOException("Unable to create a target folder for migrated files: '" + this.frontendDirectory + "'", exception);
            }
        }
        CopyMigratedResourcesStep copyMigratedStep = new CopyMigratedResourcesStep(this.frontendDirectory, this.migrateFolder, migratedTopLevelDirs);
        try {
            copyMigratedStep.copyResources();
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Couldn't copy migrated resources  to the target directory " + this.frontendDirectory, exception);
        }
        try {
            this.cleanUp(this.migrateFolder);
        }
        catch (IOException exception) {
            this.getLog().debug((CharSequence)("Couldn't remove " + this.migrateFolder.getPath()), (Throwable)exception);
        }
        if (!modulizerHasErrors && !this.keepOriginal) {
            this.removeOriginalResources(paths);
        }
        switch (this.annotationsRewrite) {
            case SKIP: {
                break;
            }
            case ALWAYS: {
                this.rewrite();
                break;
            }
            case SKIP_ON_ERROR: {
                if (modulizerHasErrors) break;
                this.rewrite();
            }
        }
    }

    private void prepareMigrationDirectory() {
        if (this.migrateFolder.exists()) {
            try {
                this.cleanUp(this.migrateFolder);
            }
            catch (IOException exception) {
                throw new UncheckedIOException("Unable to clean up directory '" + this.migrateFolder + "'", exception);
            }
        }
        try {
            FileUtils.forceMkdir((File)this.migrateFolder);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Unable to create a folder for migration: '" + this.migrateFolder + "'", exception);
        }
    }

    private void removeOriginalResources(Map<String, List<String>> paths) {
        for (Map.Entry<String, List<String>> entry : paths.entrySet()) {
            File resourceFolder = new File(entry.getKey());
            entry.getValue().forEach(path -> new File(resourceFolder, (String)path).delete());
        }
    }

    private void installNpmPackages() throws MojoFailureException {
        List npmExec = FrontendUtils.getNpmExecutable((String)this.project.getBasedir().getPath());
        ArrayList<String> npmInstall = new ArrayList<String>(npmExec.size());
        npmInstall.addAll(npmExec);
        npmInstall.add("i");
        if (!this.executeProcess(npmInstall, "Couldn't install packages using npm", "Packages successfully installed", "Error when running `npm install`")) {
            throw new MojoFailureException("Error during package installation via npm");
        }
    }

    private boolean runModulizer() {
        Collection<String> depMapping = this.makeDependencyMapping();
        ArrayList<String> command = new ArrayList<String>();
        command.add(FrontendUtils.getNodeExecutable((String)this.project.getBasedir().getPath()));
        command.add("node_modules/polymer-modulizer/bin/modulizer.js");
        command.add("--force");
        command.add("--out");
        command.add(".");
        command.add("--import-style=name");
        if (!depMapping.isEmpty()) {
            command.add("--dependency-mapping");
            command.addAll(depMapping);
        }
        return this.executeProcess(command, "Migration has finished with errors", "Modulizer has completed successfully", "Error when running moulizer");
    }

    private Collection<String> makeDependencyMapping() {
        File bower = new File(this.migrateFolder, "bower.json");
        try {
            HashSet<String> result = new HashSet<String>();
            String content = Files.readAllLines(bower.toPath()).stream().collect(Collectors.joining("\n"));
            JsonObject object = Json.parse((String)content);
            if (object.hasKey(DEPENDENCIES)) {
                JsonObject deps = object.getObject(DEPENDENCIES);
                Stream.of(deps.keys()).filter(key -> key.startsWith("vaadin-")).forEach(key -> result.add(this.makeVaadinDependencyMapping(deps, (String)key)));
            }
            return result;
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Unable to read bower.json", exception);
        }
    }

    private String makeVaadinDependencyMapping(JsonObject deps, String key) {
        JsonValue version = deps.get(key);
        StringBuilder builder = new StringBuilder(key);
        builder.append(',');
        builder.append("@vaadin/");
        builder.append(key).append(',');
        builder.append(version.asString());
        return builder.toString();
    }

    private boolean saveBowerComponents(List<String> bowerCommands, Collection<String> components) {
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(bowerCommands);
        command.add("i");
        command.add("-F");
        command.add("--config.interactive=false");
        command.add("-S");
        command.add("polymer#2.8.0");
        components.stream().filter(component -> !component.equals("polymer")).forEach(command::add);
        return this.executeProcess(command, "Couldn't install and save bower components", "All components are installed and saved successfully", "Error when running `bower install`");
    }

    private boolean ensureTools(boolean needInstallBower) {
        List npmExecutable = FrontendUtils.getNpmExecutable((String)this.project.getBasedir().getPath());
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(npmExecutable);
        command.add("install");
        if (needInstallBower) {
            command.add("bower");
        }
        command.add("polymer-modulizer");
        return this.executeProcess(command, "Couldn't install migration tools", "Bower is installed successfully", "Error when running `npm install`");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeProcess(List<String> command, String errorMsg, String successMsg, String exceptionMsg) {
        ProcessBuilder builder = FrontendUtils.createProcessBuilder(command);
        builder.directory(this.migrateFolder);
        Process process = null;
        try {
            process = builder.inheritIO().start();
            int errorCode = process.waitFor();
            if (errorCode != 0) {
                this.getLog().error((CharSequence)errorMsg);
                boolean bl = false;
                return bl;
            }
            this.getLog().debug((CharSequence)successMsg);
        }
        catch (IOException | InterruptedException e) {
            this.getLog().error((CharSequence)exceptionMsg, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
        return true;
    }

    private void cleanUp(File dir) throws IOException {
        FileUtils.forceDelete((File)dir);
    }

    private String[] getResources() {
        if (this.resources == null) {
            File webApp = new File(this.project.getBasedir(), "src/main/webapp");
            this.resources = new String[]{webApp.getPath()};
        }
        return this.resources;
    }

    private void rewrite() {
        RewriteLegacyAnnotationsStep step = new RewriteLegacyAnnotationsStep(new File(this.project.getBuild().getOutputDirectory()), FlowPluginFrontendUtils.getClassFinder(this.project), this.project.getCompileSourceRoots().stream().map(File::new).collect(Collectors.toList()));
        step.rewrite();
    }

    public static enum AnnotationsRewriteStrategy {
        ALWAYS,
        SKIP,
        SKIP_ON_ERROR;

    }
}

