/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.migration;

import com.vaadin.flow.plugin.migration.AbstractCopyResourcesStep;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class CopyMigratedResourcesStep
extends AbstractCopyResourcesStep {
    public CopyMigratedResourcesStep(File target, File source, Set<String> allowedDirectoryNames) {
        super(target, new String[]{source.getPath()}, new CopyMigratedFiles(source.toPath(), allowedDirectoryNames));
    }

    private static class CopyMigratedFiles
    implements AbstractCopyResourcesStep.FileTreeHandler {
        private static final String NODE_MODULES = "/node_modules/";
        private static final String IMPORT = "import";
        private final Path sourceRoot;
        private final Set<String> allowedDirectoryNames;

        private CopyMigratedFiles(Path sourceRoot, Set<String> allowedDirectoryNames) {
            this.sourceRoot = sourceRoot;
            this.allowedDirectoryNames = allowedDirectoryNames;
        }

        @Override
        public boolean handle(Path source, Path target) throws IOException {
            if (!this.acceptPath(source)) {
                return false;
            }
            if (source.toFile().isDirectory()) {
                return true;
            }
            List<String> lines = Files.readAllLines(source);
            StringBuilder content = new StringBuilder();
            for (String line : lines) {
                content.append(this.rewriteImport(line)).append("\n");
            }
            Files.write(target, Collections.singletonList(content.toString()), new OpenOption[0]);
            return true;
        }

        private boolean acceptPath(Path path) {
            String name;
            if (this.sourceRoot.equals(path)) {
                return true;
            }
            Path relative = this.sourceRoot.relativize(path);
            String string = name = relative.getNameCount() <= 1 ? relative.toString() : relative.getName(0).toString();
            if ("bower_components".equals(name) || "node_modules".equals(name) || "bower.json".equals(name) || "package.json".equals(name) || "package-lock.json".equals(name)) {
                return false;
            }
            if (".gitignore".equals(name)) {
                return false;
            }
            return this.allowedDirectoryNames.contains(name) || !new File(this.sourceRoot.toFile(), name).isDirectory();
        }

        private String rewriteImport(String line) {
            String importLine = line.trim();
            if (!importLine.startsWith(IMPORT) || !importLine.endsWith(";")) {
                return line;
            }
            char quote = importLine.charAt(line.length() - 2);
            if (quote != '\'' && quote != '\"') {
                return line;
            }
            int index = importLine.substring(0, importLine.length() - 2).lastIndexOf(quote);
            String suffix = importLine.substring(index);
            if (suffix.startsWith(quote + NODE_MODULES)) {
                return importLine.substring(0, index) + quote + importLine.substring(index + NODE_MODULES.length() + 1);
            }
            return line;
        }
    }
}

