/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.migration;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class CreateMigrationJsonsStep {
    private File targetDir;

    public CreateMigrationJsonsStep(File target) {
        this.targetDir = target;
    }

    public void createJsons(List<String> paths) throws IOException {
        String bowerTemplate = this.readResource("/migration/bower.json");
        String filesList = paths.stream().collect(Collectors.joining("\", \""));
        filesList = "\"" + filesList + "\"";
        bowerTemplate = bowerTemplate.replace("%files_list%", filesList);
        String packageTemplate = this.readResource("/migration/package.json");
        packageTemplate = packageTemplate.replace("%files_list%", filesList);
        Files.write(new File(this.targetDir, "bower.json").toPath(), Collections.singleton(bowerTemplate), new OpenOption[0]);
        Files.write(new File(this.targetDir, "package.json").toPath(), Collections.singleton(packageTemplate), new OpenOption[0]);
    }

    private String readResource(String resourcePath) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(CreateMigrationJsonsStep.class.getResourceAsStream(resourcePath), StandardCharsets.UTF_8));){
            String string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }
}

