/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.vaadin.flow.plugin.common.FlowPluginFrontendUtils;
import com.vaadin.flow.plugin.maven.FlowModeAbstractMojo;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.NodeTasks;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="build-frontend", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class BuildFrontendMojo
extends FlowModeAbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.basedir}")
    private File npmFolder;
    @Parameter(defaultValue="${project.build.directory}/frontend/")
    private File generatedFolder;
    @Parameter(defaultValue="true")
    private boolean generateBundle;
    @Parameter(defaultValue="true")
    private boolean runNpmInstall;
    @Parameter(defaultValue="true")
    private boolean generateEmbeddableWebComponents;
    @Parameter(defaultValue="${project.basedir}/src/main/resources/META-INF/resources/frontend")
    protected File frontendResourcesDirectory;
    @Parameter(defaultValue="true")
    private boolean optimizeBundle;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (this.compatibility) {
            this.getLog().info((CharSequence)"Skipped 'build-frontend' goal because compatibility mode is set to true.");
            return;
        }
        this.updateBuildFile();
        long start = System.nanoTime();
        try {
            this.runNodeUpdater();
        }
        catch (ExecutionFailedException exception) {
            throw new MojoFailureException("Could not execute build-frontend goal", (Throwable)exception);
        }
        if (this.generateBundle) {
            try {
                this.runWebpack();
            }
            catch (IllegalStateException exception) {
                throw new MojoExecutionException(exception.getMessage(), (Exception)exception);
            }
        }
        long ms = (System.nanoTime() - start) / 1000000L;
        this.getLog().info((CharSequence)("update-frontend took " + ms + "ms."));
    }

    private void runNodeUpdater() throws ExecutionFailedException, MojoExecutionException {
        URI nodeDownloadRootURI;
        Set jarFiles = this.project.getArtifacts().stream().filter(artifact -> "jar".equals(artifact.getType())).map(Artifact::getFile).collect(Collectors.toSet());
        try {
            nodeDownloadRootURI = new URI(this.nodeDownloadRoot);
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException("Failed to parse " + this.nodeDownloadRoot, (Exception)e);
        }
        new NodeTasks.Builder(FlowPluginFrontendUtils.getClassFinder(this.project), this.npmFolder, this.generatedFolder, this.frontendDirectory).runNpmInstall(this.runNpmInstall).enablePackagesUpdate(true).useByteCodeScanner(this.optimizeBundle).copyResources(jarFiles).copyLocalResources(this.frontendResourcesDirectory).enableImportsUpdate(true).withEmbeddableWebComponents(this.generateEmbeddableWebComponents).withTokenFile(this.getTokenFile()).enablePnpm(this.pnpmEnable).withHomeNodeExecRequired(this.requireHomeNodeExec).withNodeVersion(this.nodeVersion).withNodeDownloadRoot(nodeDownloadRootURI).build().execute();
    }

    private void runWebpack() throws MojoExecutionException {
        URI nodeDownloadRootURI;
        String webpackCommand = "webpack/bin/webpack.js";
        File webpackExecutable = new File(this.npmFolder, "node_modules/" + webpackCommand);
        if (!webpackExecutable.isFile()) {
            throw new IllegalStateException(String.format("Unable to locate webpack executable by path '%s'. Double check that the plugin is executed correctly", webpackExecutable.getAbsolutePath()));
        }
        try {
            nodeDownloadRootURI = new URI(this.nodeDownloadRoot);
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException("Failed to parse " + this.nodeDownloadRoot, (Exception)e);
        }
        FrontendTools tools = new FrontendTools(this.npmFolder.getAbsolutePath(), () -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath(), this.nodeVersion, nodeDownloadRootURI);
        String nodePath = this.requireHomeNodeExec ? tools.forceAlternativeNodeExecutable() : tools.getNodeExecutable();
        List<String> command = Arrays.asList(nodePath, webpackExecutable.getAbsolutePath());
        ProcessBuilder builder = FrontendUtils.createProcessBuilder(command).directory(this.project.getBasedir()).inheritIO();
        this.getLog().info((CharSequence)"Running webpack ...");
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)FrontendUtils.commandToString((String)this.npmFolder.getAbsolutePath(), command));
        }
        Process webpackLaunch = null;
        try {
            webpackLaunch = builder.start();
            int errorCode = webpackLaunch.waitFor();
            if (errorCode != 0) {
                this.readDetailsAndThrowException(webpackLaunch);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException("Failed to run webpack due to an error", e);
        }
        finally {
            if (webpackLaunch != null) {
                webpackLaunch.destroyForcibly();
            }
        }
    }

    private void readDetailsAndThrowException(Process webpackLaunch) {
        String stderr = this.readFullyAndClose("Failed to read webpack process stderr", webpackLaunch.getErrorStream());
        throw new IllegalStateException(String.format("Webpack process exited with non-zero exit code.%nStderr: '%s'", stderr));
    }

    private String readFullyAndClose(String readErrorMessage, InputStream inputStreamSupplier) {
        try {
            return IOUtils.toString((InputStream)inputStreamSupplier, (Charset)StandardCharsets.UTF_8).replaceAll("\\R", System.lineSeparator());
        }
        catch (IOException e) {
            throw new UncheckedIOException(readErrorMessage, e);
        }
    }

    private void updateBuildFile() {
        File tokenFile = this.getTokenFile();
        if (!tokenFile.exists()) {
            this.getLog().warn((CharSequence)"Couldn't update devMode token due to missing token file.");
            return;
        }
        try {
            String json = FileUtils.readFileToString((File)tokenFile, (String)StandardCharsets.UTF_8.name());
            JsonObject buildInfo = (JsonObject)JsonUtil.parse((String)json);
            buildInfo.remove("npmFolder");
            buildInfo.remove("generatedFolder");
            buildInfo.remove("frontendFolder");
            buildInfo.remove("pnpm.enable");
            buildInfo.remove("require.home.node");
            buildInfo.put("enableDevServer", false);
            FileUtils.write((File)tokenFile, (CharSequence)(JsonUtil.stringify((JsonValue)buildInfo, (int)2) + "\n"), (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Unable to read token file", (Throwable)e);
        }
    }

    @Override
    boolean isDefaultCompatibility() {
        File tokenFile = this.getTokenFile();
        if (!tokenFile.exists()) {
            this.getLog().warn((CharSequence)"'build-frontend' goal was called without previously calling 'prepare-frontend'");
            return true;
        }
        try {
            String json = FileUtils.readFileToString((File)tokenFile, (String)StandardCharsets.UTF_8.name());
            JsonObject buildInfo = (JsonObject)JsonUtil.parse((String)json);
            return buildInfo.hasKey("compatibilityMode") ? buildInfo.getBoolean("compatibilityMode") : true;
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Unable to read token file", (Throwable)e);
            return true;
        }
    }

    private File getTokenFile() {
        return new File(this.webpackOutputDirectory, "config/flow-build-info.json");
    }
}

