/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.vaadin.flow.plugin.maven.FlowModeAbstractMojo;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="clean-frontend", defaultPhase=LifecyclePhase.CLEAN)
public class CleanFrontendMojo
extends FlowModeAbstractMojo {
    public static final String VAADIN = "vaadin";
    public static final String DEPENDENCIES = "dependencies";
    public static final String DEV_DEPENDENCIES = "devDependencies";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.basedir}")
    private File npmFolder;
    @Parameter(property="build.folder", defaultValue="${project.build.directory}")
    private String projectBuildDir;
    @Parameter(defaultValue="${project.basedir}")
    private File projectBasedir;

    @Override
    public void execute() throws MojoFailureException {
        File generatedFrontendFolder;
        this.removeNodeModules();
        File lockFile = new File(this.npmFolder, "pnpm-lock.yaml");
        if (!lockFile.exists()) {
            lockFile = new File(this.npmFolder, "package-lock.json");
        }
        if (lockFile.exists()) {
            lockFile.delete();
        }
        if ((generatedFrontendFolder = this.frontendDirectory.toPath().resolve("generated").toFile()).exists()) {
            try {
                FileUtils.deleteDirectory((File)generatedFrontendFolder);
            }
            catch (IOException exception) {
                throw new MojoFailureException("Failed to remove folder'" + generatedFrontendFolder.getAbsolutePath() + "'", (Throwable)exception);
            }
        }
        try {
            File packageJsonFile = new File(this.npmFolder, "package.json");
            if (packageJsonFile.exists()) {
                JsonObject packageJson = Json.parse((String)FileUtils.readFileToString((File)packageJsonFile, (String)StandardCharsets.UTF_8.name()));
                this.cleanupPackage(packageJson);
                FileUtils.write((File)packageJsonFile, (CharSequence)(JsonUtil.stringify((JsonValue)packageJson, (int)2) + "\n"), (String)StandardCharsets.UTF_8.name());
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to clean 'package.json' file", (Throwable)e);
        }
    }

    @Override
    boolean isDefaultCompatibility() {
        return false;
    }

    private void removeNodeModules() {
        File nodeModules = new File(this.npmFolder, "node_modules");
        if (nodeModules.exists()) {
            try {
                FileUtils.deleteDirectory((File)nodeModules);
            }
            catch (IOException exception) {
                this.getLog().debug((CharSequence)"Exception removing node_modules", (Throwable)exception);
                this.getLog().error((CharSequence)("Failed to remove '" + nodeModules.getAbsolutePath() + "'. Please remove it manually."));
            }
        }
    }

    private void cleanupPackage(JsonObject packageJson) {
        JsonObject dependencies = packageJson.getObject(DEPENDENCIES);
        JsonObject devDependencies = packageJson.getObject(DEV_DEPENDENCIES);
        if (packageJson.hasKey(VAADIN)) {
            JsonObject vaadin = packageJson.getObject(VAADIN);
            JsonObject vaadinDependencies = vaadin.getObject(DEPENDENCIES);
            JsonObject vaadinDevDependencies = vaadin.getObject(DEV_DEPENDENCIES);
            this.cleanObject(dependencies, vaadinDependencies);
            this.cleanObject(devDependencies, vaadinDevDependencies);
            packageJson.remove(VAADIN);
        }
        this.cleanFrameworkBuildDependenices(dependencies);
        this.cleanFrameworkBuildDependenices(devDependencies);
        packageJson.remove("hash");
    }

    private void cleanObject(JsonObject target, JsonObject reference) {
        if (target == null) {
            return;
        }
        HashSet<String> removeKeys = new HashSet<String>();
        for (String key : target.keys()) {
            if (!reference.hasKey(key) || !target.getString(key).equals(reference.getString(key))) continue;
            removeKeys.add(key);
        }
        for (String key : removeKeys) {
            target.remove(key);
        }
    }

    private void cleanFrameworkBuildDependenices(JsonObject dependencyObject) {
        if (dependencyObject == null) {
            return;
        }
        String buildFolder = this.projectBuildDir;
        if (this.projectBuildDir.startsWith(this.projectBasedir.toString())) {
            buildFolder = this.projectBasedir.toPath().relativize(Paths.get(this.projectBuildDir, new String[0])).toString();
        }
        String buildTargetFolder = "./" + buildFolder;
        HashSet<String> removeKeys = new HashSet<String>();
        for (String key : dependencyObject.keys()) {
            if (!dependencyObject.getString(key).startsWith(buildTargetFolder)) continue;
            removeKeys.add(key);
        }
        for (String key : removeKeys) {
            dependencyObject.remove(key);
        }
    }
}

