/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.vaadin.flow.plugin.common.FlowPluginFrontendUtils;
import com.vaadin.flow.plugin.maven.FlowModeAbstractMojo;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.NodeTasks;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="prepare-frontend", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class PrepareFrontendMojo
extends FlowModeAbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.basedir}")
    private File npmFolder;
    @Parameter(defaultValue="webpack.config.js")
    private String webpackTemplate;
    @Parameter(defaultValue="webpack.generated.js")
    private String webpackGeneratedTemplate;
    @Parameter(defaultValue="${project.build.directory}/frontend/")
    private File generatedFolder;
    @Component
    private BuildContext buildContext;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        URI nodeDownloadRootURI;
        super.execute();
        this.propagateBuildInfo();
        if (this.compatibility) {
            this.getLog().debug((CharSequence)"Skipped 'prepare-frontend' goal because compatibility mode is set.");
            return;
        }
        try {
            nodeDownloadRootURI = new URI(this.nodeDownloadRoot);
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException("Failed to parse " + this.nodeDownloadRoot, (Exception)e);
        }
        try {
            FrontendTools tools = new FrontendTools(this.npmFolder.getAbsolutePath(), () -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath(), this.nodeVersion, nodeDownloadRootURI);
            tools.validateNodeAndNpmVersion();
        }
        catch (IllegalStateException exception) {
            throw new MojoExecutionException(exception.getMessage(), (Exception)exception);
        }
        try {
            FileUtils.forceMkdir((File)this.generatedFolder);
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to create folder '" + this.generatedFolder + "'. Verify that you may write to path.", (Throwable)e);
        }
        try {
            NodeTasks.Builder builder = new NodeTasks.Builder(FlowPluginFrontendUtils.getClassFinder(this.project), this.npmFolder, this.generatedFolder, this.frontendDirectory).withWebpack(this.webpackOutputDirectory, this.webpackTemplate, this.webpackGeneratedTemplate).createMissingPackageJson(true).enableImportsUpdate(false).enablePackagesUpdate(false).runNpmInstall(false).withNodeVersion(this.nodeVersion).withNodeDownloadRoot(nodeDownloadRootURI).withHomeNodeExecRequired(this.requireHomeNodeExec);
            if ("jar".equals(this.project.getPackaging())) {
                Set jarFiles = this.project.getArtifacts().stream().filter(artifact -> "jar".equals(artifact.getType())).map(Artifact::getFile).collect(Collectors.toSet());
                builder.copyResources(jarFiles);
            }
            builder.build().execute();
        }
        catch (ExecutionFailedException exception) {
            throw new MojoFailureException("Could not execute prepare-frontend goal.", (Throwable)exception);
        }
    }

    private void propagateBuildInfo() {
        File token = new File(this.webpackOutputDirectory, "config/flow-build-info.json");
        JsonObject buildInfo = Json.createObject();
        buildInfo.put("compatibilityMode", this.compatibility);
        buildInfo.put("productionMode", this.productionMode);
        buildInfo.put("npmFolder", this.npmFolder.getAbsolutePath());
        buildInfo.put("generatedFolder", this.generatedFolder.getAbsolutePath());
        buildInfo.put("frontendFolder", this.frontendDirectory.getAbsolutePath());
        buildInfo.put("pnpm.enable", this.pnpmEnable);
        buildInfo.put("require.home.node", this.requireHomeNodeExec);
        try {
            FileUtils.forceMkdir((File)token.getParentFile());
            FileUtils.write((File)token, (CharSequence)(JsonUtil.stringify((JsonValue)buildInfo, (int)2) + "\n"), (String)StandardCharsets.UTF_8.name());
            if (this.buildContext != null) {
                this.buildContext.refresh(token.getParentFile());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)String.format("%n>>> Running prepare-frontend in %s project%nSystem.properties:%n productionMode: %s%n bowerMode: %s%n compatibilityMode: %s%n webpackPort: %s%n project.basedir: %s%nGoal parameters:%n productionMode: %s%n compatibilityMode: %s%n compatibility: %b%n npmFolder: %s%nToken file: %s%nToken content: %s%n", this.project.getName(), System.getProperty("vaadin.productionMode"), System.getProperty("vaadin.bowerMode"), System.getProperty("vaadin.compatibiityMode"), System.getProperty("vaadin.devmode.webpack.running-port"), System.getProperty("project.basedir"), this.productionMode, this.compatibilityMode, this.compatibility, this.npmFolder, token.getAbsolutePath(), buildInfo.toJson()));
        }
    }

    @Override
    boolean isDefaultCompatibility() {
        return false;
    }

    @Deprecated
    @Mojo(name="validate", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
    public static class VaildateMojo
    extends PrepareFrontendMojo {
        @Override
        public void execute() throws MojoExecutionException, MojoFailureException {
            this.getLog().warn((CharSequence)"\n\n   You are using the 'validate' goal which has been renamed to 'prepare-frontend', please update your 'pom.xml'.\n");
            super.execute();
        }
    }
}

