/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.vaadin.flow.plugin.common.FlowPluginFrontendUtils;
import com.vaadin.flow.plugin.maven.FlowModeAbstractMojo;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.NodeTasks;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="prepare-frontend", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class PrepareFrontendMojo
extends FlowModeAbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="webpack.config.js")
    private String webpackTemplate;
    @Parameter(defaultValue="webpack.generated.js")
    private String webpackGeneratedTemplate;
    @Component
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.propagateBuildInfo();
        try {
            FrontendUtils.validateNodeAndNpmVersion((String)this.npmFolder.getAbsolutePath());
        }
        catch (IllegalStateException exception) {
            throw new MojoExecutionException(exception.getMessage(), (Exception)exception);
        }
        try {
            FileUtils.forceMkdir((File)this.generatedFolder);
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to create folder '" + this.generatedFolder + "'. Verify that you may write to path.", (Throwable)e);
        }
        try {
            NodeTasks.Builder builder = new NodeTasks.Builder(FlowPluginFrontendUtils.getClassFinder(this.project), this.npmFolder, this.generatedFolder, this.frontendDirectory).withWebpack(this.webpackOutputDirectory, this.webpackTemplate, this.webpackGeneratedTemplate).useV14Bootstrap(this.useDeprecatedV14Bootstrapping()).withFlowResourcesFolder(this.flowResourcesFolder).createMissingPackageJson(true).enableImportsUpdate(false).enablePackagesUpdate(false).runNpmInstall(false);
            if ("jar".equals(this.project.getPackaging())) {
                Set jarFiles = this.project.getArtifacts().stream().filter(artifact -> "jar".equals(artifact.getType())).map(Artifact::getFile).collect(Collectors.toSet());
                builder.copyResources(jarFiles);
            }
            builder.build().execute();
        }
        catch (ExecutionFailedException exception) {
            throw new MojoFailureException("Could not execute prepare-frontend goal.", (Throwable)exception);
        }
    }

    private void propagateBuildInfo() {
        File token = new File(this.webpackOutputDirectory, "config/flow-build-info.json");
        JsonObject buildInfo = Json.createObject();
        buildInfo.put("productionMode", this.productionMode);
        buildInfo.put("useDeprecatedV14Bootstrapping", this.useDeprecatedV14Bootstrapping());
        buildInfo.put("eagerServerLoad", this.eagerServerLoad);
        buildInfo.put("npmFolder", this.npmFolder.getAbsolutePath());
        buildInfo.put("generatedFolder", this.generatedFolder.getAbsolutePath());
        buildInfo.put("frontendFolder", this.frontendDirectory.getAbsolutePath());
        buildInfo.put("connect.javaSourceFolder", this.javaSourceFolder.getAbsolutePath());
        buildInfo.put("connect.applicationProperties", this.applicationProperties.getAbsolutePath());
        buildInfo.put("connect.openApiFile", this.openApiJsonFile.getAbsolutePath());
        buildInfo.put("connect.generated", this.generatedTsFolder.getAbsolutePath());
        try {
            FileUtils.forceMkdir((File)token.getParentFile());
            FileUtils.write((File)token, (CharSequence)(JsonUtil.stringify((JsonValue)buildInfo, (int)2) + "\n"), (String)StandardCharsets.UTF_8.name());
            if (this.buildContext != null) {
                this.buildContext.refresh(token.getParentFile());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)String.format("%n>>> Running prepare-frontend in %s project%nSystem.properties:%n productionMode: %s%n webpackPort: %s%n project.basedir: %s%nGoal parameters:%n productionMode: %s%n npmFolder: %s%nToken file: %s%nToken content: %s%n", this.project.getName(), System.getProperty("vaadin.productionMode"), System.getProperty("vaadin.devmode.webpack.running-port"), System.getProperty("project.basedir"), this.productionMode, this.npmFolder, token.getAbsolutePath(), buildInfo.toJson()));
        }
    }
}

