/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.vaadin.flow.plugin.maven.FlowModeAbstractMojo;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendUtils;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="lock-dev-deps", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class LockDevDepVersionsMojo
extends FlowModeAbstractMojo {
    private static final String DEPENDENCIES = "dependencies";
    private static final String VERSION = "version";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}")
    public File generatedDependenciesFolder;
    @Parameter
    private String generatedDependencies;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File targetFile = new File(this.generatedDependenciesFolder, this.generatedDependencies);
        try {
            FileUtils.forceMkdirParent((File)targetFile);
        }
        catch (IOException exception) {
            throw new MojoExecutionException("Can't make directories for the generated file", (Exception)exception);
        }
        String content = this.listDevDependencies();
        JsonObject result = Json.createObject();
        JsonObject object = Json.parse((String)content);
        this.collectDeps(result, object);
        this.readVersionsFromPackageJson(result);
        try {
            FileUtils.write((File)targetFile, (CharSequence)(JsonUtil.stringify((JsonValue)result, (int)2) + "\n"), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new MojoFailureException("Couldn't write dependencies into the target file", (Throwable)e);
        }
    }

    private void readVersionsFromPackageJson(JsonObject versions) {
        File nodeModules = new File(this.npmFolder, "node_modules/");
        for (String key : versions.keys()) {
            File module = new File(nodeModules, key);
            File pkgJson = new File(module, "package.json");
            if (pkgJson.exists()) {
                this.setPackageVersion(versions, key, pkgJson);
                continue;
            }
            this.getLog().warn((CharSequence)("Couldn't find package.json for '" + key + "' module"));
        }
    }

    private void setPackageVersion(JsonObject versions, String key, File pkgJson) {
        try {
            JsonObject pkg = Json.parse((String)FileUtils.readFileToString((File)pkgJson, (Charset)StandardCharsets.UTF_8));
            if (pkg.hasKey(VERSION) && pkg.get(VERSION).getType().equals((Object)JsonType.STRING)) {
                versions.put(key, pkg.getString(VERSION));
            }
        }
        catch (IOException exception) {
            this.getLog().warn((CharSequence)("Couldn't read package.json for '" + key + "' module"), (Throwable)exception);
        }
    }

    private String listDevDependencies() throws MojoFailureException {
        FrontendTools tools = new FrontendTools(this.npmFolder.getAbsolutePath(), () -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath());
        List command = tools.getNpmExecutable();
        command.add("ls");
        command.add("-json");
        command.add("-dev");
        ProcessBuilder builder = FrontendUtils.createProcessBuilder((List)command);
        builder.environment().put("ADBLOCK", "1");
        builder.directory(this.npmFolder);
        builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        StringBuilder content = new StringBuilder();
        Process process = null;
        try {
            process = builder.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String stdoutLine;
                while ((stdoutLine = reader.readLine()) != null) {
                    content.append(stdoutLine);
                    content.append('\n');
                }
            }
            int errorCode = process.waitFor();
            Logger logger = LoggerFactory.getLogger(LockDevDepVersionsMojo.class);
            if (errorCode != 0) {
                logger.error("Couldn't run npm ls");
            } else {
                logger.debug("Dev dependencies are collected");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoFailureException("Couldn't collect dev dependencies from npm", (Throwable)e);
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
        return content.toString();
    }

    private void collectDeps(JsonObject target, JsonObject dep) {
        if (!dep.hasKey(DEPENDENCIES)) {
            return;
        }
        JsonObject deps = (JsonObject)dep.get(DEPENDENCIES);
        for (String key : deps.keys()) {
            JsonValue value = deps.get(key);
            if (!(value instanceof JsonObject)) continue;
            this.addDependency(target, key, (JsonObject)value);
            this.collectDeps(target, (JsonObject)value);
        }
    }

    private void addDependency(JsonObject target, String name, JsonObject dep) {
        if (dep.hasKey(VERSION)) {
            String version = dep.getString(VERSION);
            target.put(name, version);
        }
    }
}

