/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.utils;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class LookupImpl
implements Lookup {
    private ClassFinder classFinder;

    public LookupImpl(ClassFinder classFinder) {
        this.classFinder = classFinder;
    }

    public <T> T lookup(Class<T> serviceClass) {
        return this.lookupAll((Class)serviceClass).stream().findFirst().orElse(null);
    }

    public <T> List<T> lookupAll(Class<T> serviceClass) {
        Set subTypes = this.classFinder.getSubTypesOf(this.loadClassFromClassFindler(serviceClass));
        ArrayList<T> result = new ArrayList<T>(subTypes.size());
        try {
            for (Object clazz : subTypes) {
                if (!ReflectTools.isInstantiableService((Class)((Class)clazz))) continue;
                Class<?> serviceType = serviceClass.getClassLoader().loadClass(((Class)clazz).getName());
                result.add(serviceClass.cast(ReflectTools.createInstance(serviceType)));
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not find service class", e);
        }
        return result;
    }

    private Class<?> loadClassFromClassFindler(Class<?> clz) {
        try {
            return this.classFinder.loadClass(clz.getName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not load " + clz.getName() + " class", e);
        }
    }
}

