/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.vaadin.flow.plugin.base.BuildFrontendUtil;
import com.vaadin.flow.plugin.base.PluginAdapterBase;
import com.vaadin.flow.plugin.base.PluginAdapterBuild;
import com.vaadin.flow.plugin.maven.FlowModeAbstractMojo;
import com.vaadin.flow.server.ExecutionFailedException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.TimeoutException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="build-frontend", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class BuildFrontendMojo
extends FlowModeAbstractMojo
implements PluginAdapterBuild {
    @Parameter(defaultValue="true")
    private boolean generateBundle;
    @Parameter(defaultValue="true")
    private boolean runNpmInstall;
    @Parameter(defaultValue="true")
    private boolean generateEmbeddableWebComponents;
    @Parameter(defaultValue="${project.basedir}/src/main/resources/META-INF/resources/frontend")
    private File frontendResourcesDirectory;
    @Parameter(defaultValue="true")
    private boolean optimizeBundle;
    @Parameter(defaultValue="webpack.config.js")
    private String webpackTemplate;
    @Parameter(defaultValue="webpack.generated.js")
    private String webpackGeneratedTemplate;

    public void execute() throws MojoExecutionException, MojoFailureException {
        BuildFrontendUtil.updateBuildFile((PluginAdapterBuild)this);
        long start = System.nanoTime();
        try {
            BuildFrontendUtil.runNodeUpdater((PluginAdapterBuild)this);
        }
        catch (ExecutionFailedException | URISyntaxException exception) {
            throw new MojoFailureException("Could not execute build-frontend goal", exception);
        }
        if (this.generateBundle()) {
            try {
                BuildFrontendUtil.runWebpack((PluginAdapterBase)this);
            }
            catch (IOException | InterruptedException | URISyntaxException | TimeoutException exception) {
                throw new MojoExecutionException(exception.getMessage(), exception);
            }
        }
        long ms = (System.nanoTime() - start) / 1000000L;
        this.getLog().info((CharSequence)("update-frontend took " + ms + "ms."));
    }

    public File frontendResourcesDirectory() {
        return this.frontendResourcesDirectory;
    }

    public boolean generateBundle() {
        return this.generateBundle;
    }

    public boolean generateEmbeddableWebComponents() {
        return this.generateEmbeddableWebComponents;
    }

    public boolean optimizeBundle() {
        return this.optimizeBundle;
    }

    public boolean runNpmInstall() {
        return this.runNpmInstall;
    }

    public String webpackGeneratedTemplate() {
        return this.webpackGeneratedTemplate;
    }

    public String webpackTemplate() {
        return this.webpackTemplate;
    }
}

