/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.maven;

import com.vaadin.flow.plugin.maven.FlowModeAbstractMojo;
import com.vaadin.hilla.engine.EngineConfiguration;
import com.vaadin.hilla.engine.GeneratorConfiguration;
import com.vaadin.hilla.engine.ParserConfiguration;
import com.vaadin.hilla.maven.EngineConfigureMojoException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="configure", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public final class EngineConfigureMojo
extends AbstractMojo {
    @Parameter(readonly=true)
    private final GeneratorConfiguration generator = new GeneratorConfiguration();
    @Parameter(readonly=true)
    private final ParserConfiguration parser = new ParserConfiguration();
    @Parameter(defaultValue="${project.basedir}/./src/main/frontend/generated/")
    private File generatedTsFolder;
    private static final String LEGACY_PROJECT_FRONTEND_PATH = "./frontend";
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    public void execute() throws EngineConfigureMojoException {
        if (!FlowModeAbstractMojo.isHillaAvailable((MavenProject)this.project)) {
            this.getLog().warn((CharSequence)"The 'configure' goal is only meant to be used in Hilla projects with endpoints.".stripIndent());
            return;
        }
        try {
            File legacyFrontendFolder = this.project.getBasedir().toPath().resolve(LEGACY_PROJECT_FRONTEND_PATH).toFile();
            if (legacyFrontendFolder.exists()) {
                this.generatedTsFolder = legacyFrontendFolder.toPath().resolve("generated").toFile();
            }
            String buildDir = this.project.getBuild().getDirectory();
            LinkedHashSet cp = Stream.of(this.project.getCompileClasspathElements(), this.project.getRuntimeClasspathElements(), this.project.getSystemClasspathElements()).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
            EngineConfiguration conf = new EngineConfiguration.Builder(this.project.getBasedir().toPath()).classPath((Collection)cp).outputDir(this.generatedTsFolder.toPath()).generator(this.generator).parser(this.parser).buildDir(buildDir).classesDir(this.project.getBuild().getOutputDirectory()).create();
            Path configDir = this.project.getBasedir().toPath().resolve(buildDir);
            Files.createDirectories(configDir, new FileAttribute[0]);
            conf.store(configDir.resolve("hilla-engine-configuration.json").toFile());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new EngineConfigureMojoException("Configuration failed", e);
        }
        catch (IOException e) {
            throw new EngineConfigureMojoException("Maven configuration has not been saved to file", e);
        }
    }
}

