/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.menubar.testbench;

import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.List;
import java.util.stream.Collectors;

@Element(value="vaadin-menu-bar")
public class MenuBarElement
extends TestBenchElement {
    public List<TestBenchElement> getButtons() {
        return this.$("vaadin-menu-bar-button").all().stream().filter(element -> !this.isOverflowButton((TestBenchElement)element) && this.isVisible((TestBenchElement)element)).collect(Collectors.toList());
    }

    public TestBenchElement getOverflowButton() {
        TestBenchElement overflowButton = this.$("[part~=overflow-button]").first();
        if (overflowButton == null || overflowButton.hasAttribute("hidden")) {
            return null;
        }
        return overflowButton;
    }

    private boolean isOverflowButton(TestBenchElement element) {
        return element.getAttribute("part").contains("overflow-button");
    }

    private boolean isVisible(TestBenchElement element) {
        return (Boolean)this.executeScript("return arguments[0].style.visibility !== 'hidden'", new Object[]{element});
    }
}

