/*
 * Copyright 2000-2021 Vaadin Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

(function () {
    const tryCatchWrapper = function (callback) {
        return window.Vaadin.Flow.tryCatchWrapper(callback, 'Vaadin Message List');
    };

    window.Vaadin.Flow.messageListConnector = {
        setItems: (list, items, locale) => tryCatchWrapper(function (list, items, locale) {
            const formatter = new Intl.DateTimeFormat(locale, {
                year: 'numeric', month: 'short', day: 'numeric',
                hour: 'numeric', minute: 'numeric'
            });
            list.items = items.map(item => item.time ? Object.assign(item, {
                time: formatter.format(new Date(item.time))
            }) : item);
        })(list, items, locale)
    };
})();
