/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.messages;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.messages.MessageListItem;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.i18n.LocaleChangeEvent;
import com.vaadin.flow.i18n.LocaleChangeObserver;
import com.vaadin.flow.internal.JsonUtils;
import elemental.json.JsonArray;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Tag(value="vaadin-message-list")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.7.12"), @NpmPackage(value="@vaadin/message-list", version="24.7.12")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="./messageListConnector.js"), @JsModule(value="@vaadin/message-list/src/vaadin-message-list.js")})
public class MessageList
extends Component
implements HasStyle,
HasSize,
LocaleChangeObserver {
    private List<MessageListItem> items = Collections.emptyList();
    private boolean pendingUpdate = false;

    public MessageList() {
    }

    public MessageList(Collection<MessageListItem> items) {
        this.setItems(items);
    }

    public MessageList(MessageListItem ... items) {
        this.setItems(items);
    }

    public void setItems(Collection<MessageListItem> items) {
        Objects.requireNonNull(items, "Can't set null item collection to MessageList.");
        items.forEach(item -> Objects.requireNonNull(item, "Can't include null items in MessageList."));
        this.items.forEach(item -> item.setHost(null));
        this.items = new ArrayList<MessageListItem>(items);
        items.forEach(item -> item.setHost(this));
        this.scheduleItemsUpdate();
    }

    public void setItems(MessageListItem ... items) {
        this.setItems(Arrays.asList(items));
    }

    public List<MessageListItem> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    void scheduleItemsUpdate() {
        if (!this.pendingUpdate) {
            this.pendingUpdate = true;
            this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)ctx -> {
                JsonArray itemsJson = JsonUtils.listToJson(this.items);
                this.getElement().executeJs("window.Vaadin.Flow.messageListConnector.setItems(this, $0, $1)", new Serializable[]{itemsJson, ui.getLocale().toLanguageTag()});
                this.pendingUpdate = false;
            }));
        }
    }

    public void localeChange(LocaleChangeEvent event) {
        this.scheduleItemsUpdate();
    }
}

