/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.orderedlayout;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import java.util.Arrays;

@Tag(value="div")
public class FlexLayout
extends Component
implements FlexComponent<FlexLayout>,
ClickNotifier<FlexLayout> {
    public FlexLayout() {
        this.getStyle().set("display", "flex");
    }

    public FlexLayout(Component ... children) {
        this();
        this.add(children);
    }

    public void setWrapMode(WrapMode wrapMode) {
        if (wrapMode == null) {
            throw new IllegalArgumentException("The 'wrapMode' argument can not be null");
        }
        this.getElement().getStyle().set("flexWrap", wrapMode.getFlexValue());
    }

    public WrapMode getWrapMode() {
        return WrapMode.toWrapMode(this.getElement().getStyle().get("flexWrap"), WrapMode.NOWRAP);
    }

    public static enum WrapMode {
        NOWRAP("nowrap"),
        WRAP("wrap"),
        WRAP_REVERSE("wrap-reverse");

        private final String flexValue;

        private WrapMode(String flexValue) {
            this.flexValue = flexValue;
        }

        String getFlexValue() {
            return this.flexValue;
        }

        static WrapMode toWrapMode(String flexValue, WrapMode defaultValue) {
            return Arrays.stream(WrapMode.values()).filter(flexWrap -> flexWrap.getFlexValue().equals(flexValue)).findFirst().orElse(defaultValue);
        }
    }
}

