/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.orderedlayout;

import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.orderedlayout.BoxSizing;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.dom.ThemeList;

public interface ThemableLayout
extends HasElement {
    default public void setMargin(boolean margin) {
        this.getThemeList().set("margin", margin);
    }

    default public boolean isMargin() {
        return this.getThemeList().contains((Object)"margin");
    }

    default public void setPadding(boolean padding) {
        this.getThemeList().set("padding", padding);
    }

    default public boolean isPadding() {
        return this.getThemeList().contains((Object)"padding");
    }

    default public void setSpacing(boolean spacing) {
        if (!spacing) {
            this.getElement().getStyle().remove("gap");
        }
        this.getThemeList().set("spacing", spacing);
    }

    default public boolean isSpacing() {
        return this.getThemeList().contains((Object)"spacing") || this.getElement().getStyle().has("gap");
    }

    default public void setSpacing(String spacing) {
        this.getElement().getStyle().set("gap", spacing);
    }

    default public void setSpacing(float spacing, Unit unit) {
        if (spacing < 0.0f) {
            this.setSpacing(false);
        }
        this.setSpacing(spacing + unit.toString());
    }

    default public String getSpacing() {
        return this.getElement().getStyle().get("gap");
    }

    default public void setWrap(boolean wrap) {
        this.getThemeList().set("wrap", wrap);
    }

    default public boolean isWrap() {
        return this.getThemeList().contains((Object)"wrap");
    }

    default public ThemeList getThemeList() {
        return this.getElement().getThemeList();
    }

    default public void setBoxSizing(BoxSizing boxSizing) {
        Style style = this.getElement().getStyle();
        if (boxSizing == null || boxSizing == BoxSizing.UNDEFINED) {
            style.remove("boxSizing");
        } else {
            switch (boxSizing) {
                case CONTENT_BOX: {
                    style.set("boxSizing", "content-box");
                    break;
                }
                case BORDER_BOX: {
                    style.set("boxSizing", "border-box");
                }
            }
        }
    }

    default public BoxSizing getBoxSizing() {
        Style style = this.getElement().getStyle();
        String boxSizing = style.get("boxSizing");
        if (boxSizing == null) {
            return BoxSizing.UNDEFINED;
        }
        switch (boxSizing) {
            case "content-box": {
                return BoxSizing.CONTENT_BOX;
            }
            case "border-box": {
                return BoxSizing.BORDER_BOX;
            }
        }
        return BoxSizing.UNDEFINED;
    }
}

