import{a as requiredField,b as helper,F as FieldMixin,c as FocusMixin,D as DisabledMixin,E as ElementMixin,P as PolymerElement,h as html,d as FlattenedNodesObserver,T as TooltipController,f as Checkbox}from"./generated-flow-imports-69387ce6.js";import{i,r as registerStyles,T as ThemableMixin,s,x}from"./indexhtml-a61a175b.js";import"./vaadin-icon-aaa6cc40.js";import"./vaadin-chart-3e76efd1.js";const checkboxGroup=i`
  :host {
    color: var(--lumo-body-text-color);
    font-size: var(--lumo-font-size-m);
    font-family: var(--lumo-font-family);
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    -webkit-tap-highlight-color: transparent;
    padding: var(--lumo-space-xs) 0;
  }

  :host::before {
    /* Effective height of vaadin-checkbox */
    height: var(--lumo-size-s);
    box-sizing: border-box;
    display: inline-flex;
    align-items: center;
  }

  :host([theme~='vertical']) [part='group-field'] {
    display: flex;
    flex-direction: column;
  }

  :host([disabled]) [part='label'] {
    color: var(--lumo-disabled-text-color);
    -webkit-text-fill-color: var(--lumo-disabled-text-color);
  }

  :host([focused]:not([disabled])) [part='label'] {
    color: var(--lumo-primary-text-color);
  }

  :host(:hover:not([disabled]):not([focused])) [part='label'],
  :host(:hover:not([disabled]):not([focused])) [part='helper-text'] {
    color: var(--lumo-body-text-color);
  }

  /* Touch device adjustment */
  @media (pointer: coarse) {
    :host(:hover:not([disabled]):not([focused])) [part='label'] {
      color: var(--lumo-secondary-text-color);
    }
  }
`;registerStyles("vaadin-checkbox-group",[requiredField,helper,checkboxGroup],{moduleId:"lumo-checkbox-group"});/**
 * @license
 * Copyright (c) 2018 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class CheckboxGroup extends FieldMixin(FocusMixin(DisabledMixin(ElementMixin(ThemableMixin(PolymerElement))))){static get is(){return"vaadin-checkbox-group"}static get template(){return html`
      <style>
        :host {
          display: inline-flex;
        }

        :host::before {
          content: '\\2003';
          width: 0;
          display: inline-block;
        }

        :host([hidden]) {
          display: none !important;
        }

        .vaadin-group-field-container {
          display: flex;
          flex-direction: column;
          width: 100%;
        }

        :host(:not([has-label])) [part='label'] {
          display: none;
        }
      </style>

      <div class="vaadin-group-field-container">
        <div part="label">
          <slot name="label"></slot>
          <span part="required-indicator" aria-hidden="true"></span>
        </div>

        <div part="group-field">
          <slot></slot>
        </div>

        <div part="helper-text">
          <slot name="helper"></slot>
        </div>

        <div part="error-message">
          <slot name="error-message"></slot>
        </div>
      </div>

      <slot name="tooltip"></slot>
    `}static get properties(){return{value:{type:Array,value:()=>[],notify:!0,observer:"__valueChanged"}}}constructor(){super(),this.__registerCheckbox=this.__registerCheckbox.bind(this),this.__unregisterCheckbox=this.__unregisterCheckbox.bind(this),this.__onCheckboxCheckedChanged=this.__onCheckboxCheckedChanged.bind(this)}get __checkboxes(){return this.__filterCheckboxes([...this.children])}ready(){super.ready(),this.ariaTarget=this,this.setAttribute("role","group"),this._observer=new FlattenedNodesObserver(this,({addedNodes:ue,removedNodes:it})=>{const _t=this.__filterCheckboxes(ue),Yt=this.__filterCheckboxes(it);_t.forEach(this.__registerCheckbox),Yt.forEach(this.__unregisterCheckbox),this.__warnOfCheckboxesWithoutValue(_t)}),this._tooltipController=new TooltipController(this),this.addController(this._tooltipController)}checkValidity(){return!this.required||this.value.length>0}__filterCheckboxes(ue){return ue.filter(it=>it instanceof Checkbox)}__warnOfCheckboxesWithoutValue(ue){ue.some(_t=>{const{value:Yt}=_t;return!_t.hasAttribute("value")&&(!Yt||Yt==="on")})&&console.warn("Please provide the value attribute to all the checkboxes inside the checkbox group.")}__registerCheckbox(ue){ue.addEventListener("checked-changed",this.__onCheckboxCheckedChanged),this.disabled&&(ue.disabled=!0),ue.checked?this.__addCheckboxToValue(ue.value):this.value.includes(ue.value)&&(ue.checked=!0)}__unregisterCheckbox(ue){ue.removeEventListener("checked-changed",this.__onCheckboxCheckedChanged),ue.checked&&this.__removeCheckboxFromValue(ue.value)}_disabledChanged(ue,it){super._disabledChanged(ue,it),!(!ue&&it===void 0)&&it!==ue&&this.__checkboxes.forEach(_t=>{_t.disabled=ue})}__addCheckboxToValue(ue){this.value.includes(ue)||(this.value=[...this.value,ue])}__removeCheckboxFromValue(ue){this.value.includes(ue)&&(this.value=this.value.filter(it=>it!==ue))}__onCheckboxCheckedChanged(ue){const it=ue.target;it.checked?this.__addCheckboxToValue(it.value):this.__removeCheckboxFromValue(it.value)}__valueChanged(ue,it){ue.length===0&&it===void 0||(this.toggleAttribute("has-value",ue.length>0),this.__checkboxes.forEach(_t=>{_t.checked=ue.includes(_t.value)}),it!==void 0&&this.validate())}_shouldRemoveFocus(ue){return!this.contains(ue.relatedTarget)}_setFocused(ue){super._setFocused(ue),ue||this.validate()}}customElements.define(CheckboxGroup.is,CheckboxGroup);function SpreadsheetApi(){var Pb="",Qb=0,Rb="gwt.codesvr=",Sb="gwt.hosted=",Tb="gwt.hybrid",Ub="SpreadsheetApi",Vb="#",Wb="?",Xb="/",Yb=1,Zb="img",$b="clear.cache.gif",_b="baseUrl",ac="script",bc="SpreadsheetApi.nocache.js",cc="base",dc="//",ec="meta",fc="name",gc="gwt:property",hc="content",ic="=",jc="gwt:onPropertyErrorFn",kc='Bad handler "',lc='" for "gwt:onPropertyErrorFn"',mc="gwt:onLoadErrorFn",nc='" for "gwt:onLoadErrorFn"',oc="modernie",pc="MSIE",qc="Trident",rc="yes",sc="none",tc="user.agent",uc="webkit",vc="safari",wc="msie",xc=10,yc=11,zc="ie10",Ac=9,Bc="ie9",Cc=8,Dc="ie8",Ec="gecko",Fc="gecko1_8",Gc=2,Hc=3,Ic=4,Jc="Single-script hosted mode not yet implemented. See issue ",Kc="http://code.google.com/p/google-web-toolkit/issues/detail?id=2079",Lc="2789A30CF7418B8B982A7BFE746FC731",Mc=":1",Nc=":2",Oc=":",Pc="DOMContentLoaded",Qc=50,l=Pb,m=Qb,n=Rb,o=Sb,p=Tb,q=Ub,r=Vb,s=Wb,t=Xb,u=Yb,v=Zb,w=$b,A=_b,B=ac,C=bc,D=cc,F=dc,G=ec,H=fc,I=gc,J=hc,K=ic,L=jc,M=kc,N=lc,O=mc,P=nc,Q=oc,R=pc,S=qc,T=rc,U=sc,V=tc,W=uc,X=vc,Y=wc,Z=xc,$=yc,_=zc,ab=Ac,bb=Bc,cb=Cc,db=Dc,eb=Ec,fb=Fc,gb=Gc,hb=Hc,ib=Ic,jb=Jc,kb=Kc,lb=Lc,mb=Mc,nb=Nc,ob=Oc,pb=Pc,qb=Qc,rb=window,sb=document,tb,ub,vb=l,wb={},xb=[],yb=[],zb=[],Ab=m,Bb,Cb;rb.__gwt_stylesLoaded||(rb.__gwt_stylesLoaded={}),rb.__gwt_scriptsLoaded||(rb.__gwt_scriptsLoaded={});function Db(){var ae=!1;try{var ue=rb.location.search;return(ue.indexOf(n)!=-1||ue.indexOf(o)!=-1||rb.external&&rb.external.gwtOnLoad)&&ue.indexOf(p)==-1}catch{}return Db=function(){return ae},ae}function Eb(){tb&&ub&&tb(Bb,q,vb,Ab)}function Fb(){function ae(Kt){var yi=Kt.lastIndexOf(r);yi==-1&&(yi=Kt.length);var Vl=Kt.indexOf(s);Vl==-1&&(Vl=Kt.length);var xi=Kt.lastIndexOf(t,Math.min(Vl,yi));return xi>=m?Kt.substring(m,xi+u):l}function ue(Kt){if(!Kt.match(/^\w+:\/\//)){var yi=sb.createElement(v);yi.src=Kt+w,Kt=ae(yi.src)}return Kt}function it(){var Kt=Ib(A);return Kt??l}function _t(){for(var Kt=sb.getElementsByTagName(B),yi=m;yi<Kt.length;++yi)if(Kt[yi].src.indexOf(C)!=-1)return ae(Kt[yi].src);return l}function Yt(){var Kt=sb.getElementsByTagName(D);return Kt.length>m?Kt[Kt.length-u].href:l}function Me(){var Kt=sb.location;return Kt.href==Kt.protocol+F+Kt.host+Kt.pathname+Kt.search+Kt.hash}var ge=it();return ge==l&&(ge=_t()),ge==l&&(ge=Yt()),ge==l&&Me()&&(ge=ae(sb.location.href)),ge=ue(ge),ge}function Gb(){for(var b=document.getElementsByTagName(G),c=m,d=b.length;c<d;++c){var e=b[c],f=e.getAttribute(H),g;if(f){if(f==I){if(g=e.getAttribute(J),g){var h,i=g.indexOf(K);i>=m?(f=g.substring(m,i),h=g.substring(i+u)):(f=g,h=l),wb[f]=h}}else if(f==L){if(g=e.getAttribute(J),g)try{Cb=eval(g)}catch(ae){alert(M+g+N)}}else if(f==O&&(g=e.getAttribute(J),g))try{Bb=eval(g)}catch(ae){alert(M+g+P)}}}}var Ib=function(ae){var ue=wb[ae];return ue??null};function Jb(ae,ue){for(var it=zb,_t=m,Yt=ae.length-u;_t<Yt;++_t)it=it[ae[_t]]||(it[ae[_t]]=[]);it[ae[Yt]]=ue}function Kb(ae){var ue=yb[ae](),it=xb[ae];if(ue in it)return ue;var _t=[];for(var Yt in it)_t[it[Yt]]=Yt;throw Cb&&Cb(ae,_t,ue),null}if(yb[Q]=function(){{var ae=rb.navigator.userAgent;return ae.indexOf(R)==-1&&ae.indexOf(S)!=-1?T:U}},xb[Q]={none:m,yes:u},yb[V]=function(){var ae=navigator.userAgent.toLowerCase(),ue=sb.documentMode;return function(){return ae.indexOf(W)!=-1}()?X:function(){return ae.indexOf(Y)!=-1&&ue>=Z&&ue<$}()?_:function(){return ae.indexOf(Y)!=-1&&ue>=ab&&ue<$}()?bb:function(){return ae.indexOf(Y)!=-1&&ue>=cb&&ue<$}()?db:function(){return ae.indexOf(eb)!=-1||ue>=$}()?fb:X},xb[V]={gecko1_8:m,ie10:u,ie8:gb,ie9:hb,safari:ib},SpreadsheetApi.onScriptLoad=function(ae){SpreadsheetApi=null,tb=ae,Eb()},Db()){alert(jb+kb);return}Fb(),Gb();try{var Lb;Jb([U,fb],lb),Jb([T,fb],lb+mb),Jb([U,X],lb+nb),Lb=zb[Kb(Q)][Kb(V)];var Mb=Lb.indexOf(ob);Mb!=-1&&(Ab=Number(Lb.substring(Mb+u)))}catch(ae){return}var Nb;function Ob(){ub||(ub=!0,Eb(),sb.removeEventListener&&sb.removeEventListener(pb,Ob,!1),Nb&&clearInterval(Nb))}sb.addEventListener&&sb.addEventListener(pb,function(){Ob()},!1);var Nb=setInterval(function(){/loaded|complete/.test(sb.readyState)&&Ob()},qb)}SpreadsheetApi();(function(){var ae=window,ue=ae.document,it,_t;function Yt(){}function Me(){}function ge(){}function Kt(){}function yi(){}function Vl(){}function xi(){}function lK(){}function Zx(){}function e4(){}function t4(){}function n4(){}function i4(){}function r4(){}function o4(){}function s4(){}function c4(){}function u4(){}function l4(){}function f4(){}function h4(){}function d4(){}function fK(){}function hK(){}function a4(){}function b4(){}function p4(){}function g4(){}function w4(){}function v4(){}function m4(){}function y4(){}function x4(){}function C4(){}function Dp(){}function k4(){}function S4(){}function qp(){}function vs(){}function Fp(){}function I4(){}function A4(){}function T4(){}function V4(){}function Hp(){}function z4(){}function E4(){}function j4(){}function O4(){}function X4(){}function W4(){}function K4(){}function L4(){}function M4(){}function N4(){}function R4(){}function P4(){}function _4(){}function B4(){}function D4(){}function q4(){}function F4(){}function H4(){}function $4(){}function U4(){}function G4(){}function Q4(){}function J4(){}function Y4(){}function Z4(){}function e3(){}function t3(){}function n3(){}function i3(){}function r3(){}function o3(){}function s3(){}function $p(){}function zl(){}function c3(){}function u3(){}function Up(){}function Gp(){}function Qp(){}function El(){}function dK(){}function d1(){}function l3(){}function jl(){}function rh(){}function f3(){}function Ol(){}function h3(){}function d3(){}function Jp(){}function Yp(){}function Zp(){}function a3(){}function b3(){}function p3(){}function g3(){}function w3(){}function v3(){}function m3(){}function y3(){}function x3(){}function C3(){}function eg(){}function tg(){}function ng(){}function k3(){}function ig(){}function rg(){}function S3(){}function I3(){}function A3(){}function T3(){}function V3(){}function z3(){}function E3(){}function j3(){}function O3(){}function a1(){}function X3(){}function W3(){}function K3(){}function og(a){}function L3(){be()}function M3(){be()}function N3(){NC()}function R3(){Sf()}function P3(){kS()}function _3(){To()}function B3(){To()}function D3(){TC()}function sg(a){qA(a)}function q3(){AC()}function qo(){qo=ge}function aK(a,y){a.a=y}function F3(a,y){a.a=y}function bK(a,y){a.f=y}function H3(a,y){a.b=y}function $3(a,y){a.b=y}function U3(a,y){a.a=y}function pK(a,y){a.a=y}function gK(a,y){a.a=y}function wK(a,y){a.b=y}function vK(a,y){a.b=y}function G3(a,y){a.b=y}function mK(a,y){a.d=y}function cg(a,y){a.r=y}function yK(a,y){a.o=y}function xK(a,y){a.c=y}function CK(a,y){a.e=y}function kK(a,y){a.e=y}function SK(a,y){a.f=y}function IK(a,y){a.k=y}function AK(a,y){a.G=y}function TK(a,y){a.H=y}function VK(a,y){a.g=y}function zK(a,y){a.i=y}function EK(a,y){a.j=y}function jK(a,y){a.q=y}function OK(a,y){a.r=y}function XK(a,y){a.A=y}function WK(a,y){a.L=y}function KK(a,y){a.M=y}function LK(a,y){a.O=y}function MK(a,y){a.R=y}function NK(a,y){a.W=y}function RK(a,y){a.Z=y}function PK(a,y){a.$=y}function Q3(a,y){a.a=y}function bo(a,y){a.Xc=y}function ms(a,y){a.id=y}function J3(a){this.a=a}function Y3(a){this.a=a}function Qe(a){this.a=a}function Z3(a){this.a=a}function ug(a){this.a=a}function e5(a){this.a=a}function t5(a){this.a=a}function n5(a){this.a=a}function i5(a){this.a=a}function r5(a){this.a=a}function lg(a){this.a=a}function o5(a){this.a=a}function s5(a){this.a=a}function c5(a){this.a=a}function u5(a){this.a=a}function l5(a){this.a=a}function f5(a){this.a=a}function fg(a){this.a=a}function h5(a){this.a=a}function d5(a){this.a=a}function a5(a){this.a=a}function b5(a){this.a=a}function p5(a){this.a=a}function g5(a){this.a=a}function hg(a){this.a=a}function w5(a){this.a=a}function dg(a){this.a=a}function ag(a){this.a=a}function v5(a){this.a=a}function m5(a){this.a=a}function y5(a){this.a=a}function x5(a){this.a=a}function C5(a){this.a=a}function k5(a){this.a=a}function S5(a){this.a=a}function I5(a){this.a=a}function A5(a){this.a=a}function T5(a){this.a=a}function V5(a){this.a=a}function oh(a){this.a=a}function z5(a){this.a=a}function E5(a){this.a=a}function j5(a){this.a=a}function O5(a){this.a=a}function X5(a){this.a=a}function W5(a){this.a=a}function K5(a){this.a=a}function L5(a){this.a=a}function M5(a){this.a=a}function N5(a){this.a=a}function R5(a){this.b=a}function bg(a){this.c=a}function P5(a){this.a=a}function _5(a){this.a=a}function B5(a){this.a=a}function D5(a){this.a=a}function q5(a){this.a=a}function F5(a){this.a=a}function H5(a){this.a=a}function $5(a){this.a=a}function U5(a){this.a=a}function G5(a){this.a=a}function Q5(a){this.a=a}function J5(a){this.a=a}function Fo(a){this.a=a}function Y5(a){this.a=a}function Z5(a){this.a=a}function eC(){this.a={}}function tC(){this.a={}}function _K(a,y){a.a=y}function BK(a,y){a.b=y}function DK(a,y){a.c=y}function qK(a,y){a.e=y}function FK(a,y){a.f=y}function HK(a,y){a.g=y}function $K(a,y){a.i=y}function UK(a,y){a.j=y}function GK(a,y){a.k=y}function QK(a,y){a.n=y}function JK(a,y){a.o=y}function YK(a,y){a.p=y}function ZK(a,y){a.q=y}function eL(a,y){a.r=y}function tL(a,y){a.s=y}function nL(a,y){a.t=y}function iL(a,y){a.u=y}function rL(a,y){a.v=y}function oL(a,y){a.w=y}function sL(a,y){a.A=y}function cL(a,y){a.d=y}function uL(a,y){a.B=y}function lL(a,y){a.C=y}function fL(a,y){a.D=y}function hL(a,y){a.F=y}function dL(a,y){a.G=y}function aL(a,y){a.H=y}function bL(a,y){a.I=y}function pL(a,y){a.J=y}function gL(a,y){a.K=y}function wL(a,y){a.L=y}function vL(a,y){a.M=y}function mL(a,y){a.N=y}function yL(a,y){a.O=y}function xL(a,y){a.P=y}function CL(a,y){a.Q=y}function kL(a,y){a.R=y}function SL(a,y){a.S=y}function IL(a,y){a.T=y}function AL(a,y){a.U=y}function TL(a,y){a.V=y}function VL(a,y){a.a=y}function b1(a,y){a.b=y}function zL(a,y){a.c=y}function EL(a,y){a.d=y}function jL(a,y){a.e=y}function OL(a,y){a.f=y}function XL(a,y){a.g=y}function WL(a,y){a.i=y}function KL(a,y){a.j=y}function LL(a,y){a.k=y}function ML(a,y){a.b=y}function NL(a,y){a.lb=y}function RL(a,y){a.Qb=y}function PL(a,y){a.mb=y}function _L(a,y){a.ec=y}function BL(a,y){a.fc=y}function Fe(a){this.c=a}function p1(a){this.a=a}function Gr(a){this.a=a}function po(a){this.a=a}function di(a){this.a=a}function yr(a){this.a=a}function nC(a){this.a=a}function iC(a){this.a=a}function rC(a){this.a=a}function g1(a){this.a=a}function pg(a){this.a=a}function gg(a){this.a=a}function or(a){this.a=a}function wg(a){this.d=a}function w1(a){this.b=a}function v1(a){this.b=a}function oC(a){this.a=a}function vg(a){this.a=a}function sC(a){this.c=a}function cC(a){this.a=a}function uC(a){this.a=a}function lC(a){this.a=a}function fC(a){this.a=a}function hC(a){this.a=a}function dC(a){this.a=a}function aC(a){this.a=a}function bC(a){this.a=a}function mg(){this.a=jr()}function xr(){this.c=++AQ}function Ot(){Mt(this)}function st(){Qg(this)}function pC(){pk(this)}function gC(){gC=ge,oT()}function yg(){yg=ge,HU()}function DL(a){xp=a,NP()}function sh(a,y){sS(a.j,y)}function ch(a,y){Ii(a.j,y)}function qL(a,y){xo(a.a,y)}function wC(a,y){gD(a.g,y)}function vC(a,y){qn(y,a)}function m1(a,y){xe(y,a.k)}function y1(a,y){xe(y,a.B)}function FL(a,y){yG(a.V,y)}function HL(a,y){SG(a.V,y)}function $L(a,y){ch(a.u,y)}function mC(a,y){y_(a.W,y)}function yC(a,y){x_(a.W,y)}function UL(a,y){XP(a.W,y)}function GL(a,y){TP(a.V,y)}function QL(a,y){NF(a.V,y)}function JL(a,y){NL(a.V,y)}function YL(a,y){AK(a.V,y)}function ZL(a,y){TK(a.V,y)}function eM(a,y){fD(a.V,y)}function tM(a,y){gF(a.V,y)}function nM(a,y){EH(a.V,y)}function iM(a,y){RL(a.V,y)}function rM(a,y){IG(a.V,y)}function oM(a,y){sB(a.V,y)}function sM(a,y){KM(a.V,y)}function xC(a,y){FG(a.V,y)}function cM(a,y){PL(a.V,y)}function uM(a,y){_L(a.V,y)}function lM(a,y){BL(a.V,y)}function x1(a,y){el(a.V,y)}function fM(a,y){wN(a.V,y)}function hM(a,y){GH(a.U,y)}function dM(a,y){cD(a.U,y)}function aM(a,y){B$(a.u,y)}function bM(a,y){lP(a.V,y)}function pM(a,y){zP(a.V,y)}function gM(a,y){OU(a.V,y)}function wM(a,y){bP(a.V,y)}function CC(a,y){a.add(y)}function vM(a,y){a.src=y}function kC(a,y){a.value=y}function mM(a,y){a.value=y}function yM(a,y){a.length=y}function xg(a){a.s=new st}function xM(a){a.a=0,a.b=0}function CM(a){Ii(a.j,a.c)}function kM(a){hQ(a),lG(a)}function go(a,y){mT(a.yc,y)}function SM(a,y){BP(a.W,y)}function IM(a,y){K_(a.W,y)}function AM(a,y,k){a.a[y]=k}function SC(){xi.call(this)}function Cr(){Pw.call(this)}function Cg(){Pw.call(this)}function IC(a){uQ(this,a)}function AC(){AC=ge,il()}function be(){be=ge,Ie=ZP()}function fe(){fe=ge,an=YP()}function Ci(){Ci=ge,pW=JP()}function Qr(){Qr=ge,li=GP()}function TC(){TC=ge,Ip=J$()}function VC(){VC=ge,new OV}function zC(){zC=ge,new Ot}function EC(){EC=ge,ix=new Yt}function jC(){this.a=new Bi}function TM(a,y){a.a[NE]=y}function VM(a,y){UL(a.a.a,y)}function zM(a,y){O$(a,y,a.c)}function OC(a){aK(this,a.id)}function EM(a){return a.Jd()}function jM(a,y){return null}function XC(a,y){hF(a.md(),y)}function Pi(a,y){ah(a.md(),y)}function WC(a,y,k){a.add(y,k)}function KC(a,y){a.tabIndex=y}function LC(a){Yc(),vp.Ld(a)}function ut(){ut=ge,pt=new O4}function MC(){MC=ge,cW=new g4}function NC(){NC=ge,bx=new xr}function RC(){RC=ge,KW=new xr}function C1(){C1=ge,Vp=new xr}function k1(){k1=ge,Tc(),sv()}function Xl(){Jl.call(this)}function uh(){Jl.call(this)}function PC(){Jl.call(this)}function Ln(){Jl.call(this)}function Ku(){Jl.call(this)}function _C(){Jl.call(this)}function Ho(a){B8.call(this,a)}function kr(a){Z3.call(this,a)}function _i(a){Z3.call(this,a)}function OM(a,y){a.fillStyle=y}function XM(a,y){a[a.length]=y}function WM(a,y){a[a.length]=y}function wo(a,y){a.scrollTop=y}function KM(a,y){a.ub=y,KT(a)}function kg(a,y){S$(a,y,y,-1)}function BC(a,y){b9(a,y),Iv(a)}function ki(a){(be(),Ie).Vd(a)}function Dt(a){return be(),a|0}function DC(a,y){return a.a[y]}function S1(a){return a.g&&a.f}function Sg(){this.a=new st}function Si(){this.a=new Ot}function qC(){this.a=new Ot}function Ig(a){wm.call(this,a)}function I1(a){og.call(this,a)}function FC(a){Ig.call(this,a)}function LM(a,y){HL(pi(a.a),y)}function MM(a,y){bM(pi(a.a),y)}function NM(a,y){pM(pi(a.a),y)}function RM(a,y){gM(pi(a.a),y)}function PM(a,y){wM(pi(a.a),y)}function _M(a,y,k){DH(a.V,y,k)}function BM(a,y,k){wD(a.V,y,k)}function HC(a,y,k){oq(a.W,y,k)}function DM(a,y,k){LB(a.W,k,y)}function qM(a,y,k){BN(a.V,y,k)}function $C(a,y){a.p=y,Lr(a.Q)}function FM(a){d$(a.V),pu(a.U)}function A1(a){B8.call(this,a)}function vo(a){Ho.call(this,a)}function $o(a){Ho.call(this,a)}function mo(a){Ho.call(this,a)}function ys(a){Ho.call(this,a)}function UC(a){$a.call(this,a)}function Wl(a){Ho.call(this,a)}function GC(){Qe.call(this,vz)}function QC(){Qe.call(this,mz)}function JC(){Qe.call(this,G0)}function YC(){Qe.call(this,yz)}function ZC(){Qe.call(this,xz)}function ek(){Qe.call(this,Cz)}function tk(){Qe.call(this,kz)}function nk(){Qe.call(this,Id)}function ik(){Qe.call(this,Sz)}function rk(){Qe.call(this,Iz)}function ok(){Qe.call(this,Az)}function sk(){Qe.call(this,z2)}function ck(){Qe.call(this,Tz)}function uk(){Qe.call(this,Vz)}function lk(){Qe.call(this,zz)}function fk(){Qe.call(this,Ez)}function hk(){wp==null&&(wp=[])}function Qs(){Qs=ge,Yc()}function xs(a,y){bo(a,(fe(),y))}function HM(a,y){fP((fe(),a),y)}function $M(a,y,k){Te(a.c,y,k)}function UM(a,y,k){cB(a.W,y,k)}function GM(a,y){a.v=new ef(y)}function QM(a,y){a.w=new ef(y)}function dk(a,y){a.__listener=y}function ak(a,y){return y<=a.ob}function Ce(a,y){return PI(a,y)}function Re(a){return fe(),a.Xc}function Cs(a){return fe(),a.Xc}function bk(a){return fe(),a.Xc}function JM(a){return fe(),a.Xc}function pk(a){a.a=(ja(),Xu)}function gk(a){Ho.call(this,a)}function Jr(a){Ho.call(this,a)}function Ag(a){vo.call(this,a)}function Tg(a){vo.call(this,a)}function lh(a){ft(a),this.a=a}function Vg(a){return a=so(a),a}function zg(a,y){return mA(a,y)}function T1(a,y){aR(a.b,a.a,y)}function wk(a,y,k){y.Mf(a.a[k])}function YM(a,y,k){y.Mf(V7(k))}function vk(){vk=ge,tK=p$()}function ZM(){throw we(new Ku)}function mk(){this.a=Rz in ae}function yk(a){bo(this,(fe(),a))}function xk(a){bo(this,(fe(),a))}function eN(a){bo(this,(fe(),a))}function tN(a){!a.b&&(a.b=Yh(a))}function nN(a,y){fe(),an.He(a,y)}function Js(a,y){fe(),an.Ie(a,y)}function Uo(a,y){fe(),an.Ie(a,y)}function V1(a,y){Gw(a,y),Tf(a,1)}function Eg(a,y){U8(a,y),Tf(a,1)}function Kl(a,y){a.j=y,xe(a.d,y)}function Lu(a,y,k){a.sc=k,a.rc=y}function iN(a,y,k){AH(a).Ef(y,k)}function sr(a,y){WA(a.a,y,!1)}function Ck(a){bo(this,(fe(),a))}function rN(a){this.a=a}function yo(a){$o.call(this,a)}function kk(){g1.call(this,"")}function Bi(){g1.call(this,"")}function z1(){g1.call(this,"")}function jg(a){w1.call(this,a)}function Sk(a){jg.call(this,a)}function Ik(a){na.call(this,a)}function E1(){Pu.call(this,null)}function Ak(){Qr(),XI.call(this)}function fh(){fh=ge,yx=Q$(),y$()}function Ll(){Ll=ge,mp=new p3}function Tk(){throw we(new Ln)}function Og(){throw we(new Ln)}function Vk(a){return Object(a)}function Xg(a){return a.S[a.a-1]}function oN(a,y){return en(a,y)>0}function zk(a,y){return en(a,y)<0}function vt(a,y,k){Sn(a.md(),y,k)}function Wg(a,y,k){a.splice(y,k)}function Ek(a,y){for(;a.ig(y););}function jk(a,y){Jg(y,"role",a.a)}function Ml(a){return ht(a),a.k}function hh(a){return ht(a),a.i}function sN(a,y){return vN(a.a,y)}function Ok(a){return a.l|a.m<<22}function cN(a,y){return a.test(y)}function uN(a){fe(),ho=a,an.Ge(a)}function dh(a){fe(),ho=a,an.Ge(a)}function lN(a){(be(),a).opacity=0}function Xk(){Qe.call(this,"img")}function Wk(){Qe.call(this,"log")}function Kk(){Qe.call(this,"row")}function Lk(){Qe.call(this,"tab")}function Mk(){bh.call(this,X2,3)}function Nk(){X1.call(this,X2,1)}function Rk(){l6.call(this,X2,1)}function Pk(){SA.call(this,!1)}function fN(){Hd!=0&&(Hd=0),$d=-1}function hN(a,y){y<0&&(y=0),a.a=y}function dN(a,y){y<0&&(y=0),a.d=y}function aN(a,y){return E6(a.D,y)}function Kg(a,y){return Ft(a.a,y)}function Lg(a,y){return en(a,y)==0}function _k(a,y){return en(a,y)<=0}function j1(a,y){for(;a.lg(y););}function Bk(a,y){this.b=a,this.a=y}function si(a,y){this.b=a,this.c=y}function Mg(){this.o=new _8(this)}function Dk(){this.a=new Pu(null)}function xn(){xn=ge,fe(),Oe(ue)}function qk(){qk=ge,YW=new S3}function Fk(a,y){return a.a+=y,a}function Go(a,y){return a.a+=y,a}function ai(a,y){js((fe(),a.Xc),y)}function bN(a,y){nN((fe(),a.Xc),y)}function Ng(a,y){KC((fe(),a.Xc),y)}function Nl(a){return qt((be(),a))}function pN(a){return!!a.b||!!a.g}function Yr(a){return Ba((be(),a))}function gN(a,y){(be(),Ie).Pd(a,y)}function ah(a,y){a.className=y||""}function O1(a,y){a.innerHTML=y||""}function xo(a,y){(be(),Ie).de(a,y)}function Zr(a,y){(be(),Ie).ee(a,y)}function bh(a,y){si.call(this,a,y)}function Jn(a,y){si.call(this,a,y)}function X1(a,y){si.call(this,a,y)}function W1(a,y){si.call(this,a,y)}function K1(a,y){si.call(this,a,y)}function Hk(a,y){si.call(this,a,y)}function ks(a,y){si.call(this,a,y)}function $k(){ks.call(this,"PX",0)}function Uk(){ks.call(this,"EM",2)}function Gk(){ks.call(this,"EX",3)}function Qk(){ks.call(this,"PT",4)}function Jk(){ks.call(this,"PC",5)}function Yk(){ks.call(this,"IN",6)}function Zk(){ks.call(this,"CM",7)}function e6(){ks.call(this,"MM",8)}function t6(){Qe.call(this,"form")}function n6(){Qe.call(this,"grid")}function i6(){Qe.call(this,"main")}function r6(){Qe.call(this,"math")}function o6(){Qe.call(this,"menu")}function s6(){Qe.call(this,"list")}function c6(){Qe.call(this,"note")}function u6(){Qe.call(this,"tree")}function l6(a,y){si.call(this,a,y)}function ph(a,y){si.call(this,a,y)}function L1(a,y){si.call(this,a,y)}function M1(a,y){si.call(this,a,y)}function Rg(a,y){vV.call(this,a,y)}function f6(a,y){this.a=a,this.b=y}function h6(a,y){this.a=a,this.b=y}function d6(a,y){this.a=a,this.b=y}function a6(a,y){this.a=a,this.b=y}function b6(a,y){this.b=a,this.a=y}function p6(a,y){this.a=a,this.b=y}function gh(a,y){this.a=a,this.b=y}function g6(a,y){this.a=a,this.b=y}function w6(a,y){this.a=a,this.b=y}function v6(a,y){this.a=a,this.b=y}function Co(a,y){this.a=a,this.b=y}function m6(a,y){this.b=a,this.a=y}function y6(a,y){this.c=y,this.d=a}function x6(a,y){this.a=a,this.b=y}function C6(a,y){this.a=a,this.b=y}function k6(a,y){this.a=a,this.b=y}function S6(a,y){this.a=a,this.b=y}function Pg(a,y){vV.call(this,a,y)}function I6(a,y){this.a=a,this.b=y}function Ys(a,y){this.b=a,this.a=y}function A6(a,y){this.a=a,this.b=y}function Rl(a,y){this.b=a,this.a=y}function T6(a,y){this.a=a,this.b=y}function V6(a,y){this.a=a,this.b=y}function z6(a,y){this.a=a,this.b=y}function wN(a,y){a.Sc=y,hU(a.yc,y)}function E6(a,y){return Nt(a.c,y)}function vN(a,y){return rf(a.d,y)}function _g(a){return Hn((fe(),a))}function Mu(a){return a.a.c+a.b.c}function Sr(a){fB(a.a,a.d,a.c,a.b)}function Pl(a){Pn(a,!1),lt(a.i)}function N1(a,y){si.call(this,a,y)}function R1(a,y){Aa.call(this,a,y)}function j6(){Qe.call(this,"alert")}function O6(){Qe.call(this,"group")}function X6(){Qe.call(this,"radio")}function W6(){Qe.call(this,"timer")}function mN(a,y){a.selectedIndex=y}function Nu(a,y,k){a.splice(y,0,k)}function yN(a,y,k){_M(pi(a.a),y,k)}function K6(a,y){mN((fe(),a.Xc),y)}function L6(a,y){a.Vc&&Ws(a.Vc,y)}function Bg(a,y){this.a=a,this.b=y}function M6(a,y){this.a=a,this.b=y}function N6(a,y){this.b=a,this.a=y}function xN(a){ae.clearTimeout(a)}function CN(a){ae.clearTimeout(a)}function kN(a){return kw(),j_(hx,a)}function SN(a){return(be(),a).type}function Ru(a){return(be(),a)[Pt]}function R6(a){return(be(),a)[ot]}function IN(a){return(be(),a)[uo]}function AN(a){return(be(),a)[Bt]}function P6(a){n2(a),fm(a),a.v=!0}function _6(){Sp||(oG(),Sp=!0)}function TN(){ax||(Yq(),ax=!0)}function VN(){oQ(),MC(),LD(),new c8}function B6(){C1(),rN.call(this,{})}function zN(a){Tc(),yk.call(this,a)}function D6(){ks.call(this,"PCT",1)}function q6(){ph.call(this,"PRE",2)}function P1(a,y){si.call(this,a,y)}function _1(a,y){si.call(this,a,y)}function B1(a,y){si.call(this,a,y)}function _l(a,y){si.call(this,a,y)}function Dg(a,y){si.call(this,a,y)}function Bl(a,y){return rf(a.a,y)}function qg(a,y){return a.a.get(y)}function F6(a,y){return Lt(a)===Lt(y)}function wh(a){return typeof a===$0}function vh(a){return typeof a===Vf}function Qo(a){return typeof a===xd}function Lt(a){return a??null}function D1(a){return a.b.a+"."+a.a}function At(a){return typeof a===Vf}function Zs(a,y){return a.substr(y)}function H6(){return vk(),new tK}function EN(a){ae.clearInterval(a)}function jN(a){hP(a.e),Mo(a.e,null)}function $6(a,y){Qu(a.V)||a9(a.V,y)}function ON(a,y){$w.call(this,a,y)}function U6(){Qe.call(this,"banner")}function G6(){Qe.call(this,"slider")}function Q6(){Qe.call(this,"search")}function J6(){Qe.call(this,"status")}function Y6(){Qe.call(this,"dialog")}function Z6(){Qe.call(this,"region")}function eS(){bh.call(this,"NONE",0)}function tS(){Jn.call(this,"NONE",0)}function nS(){X1.call(this,"AUTO",3)}function iS(){K1.call(this,"LEFT",2)}function rS(){Hk.call(this,"CLIP",0)}function Pu(a){aw.call(this,a,!1)}function oS(a,y,k){Jg(y,a.a,FF(a,k))}function XN(a,y,k,z){mD(a.W,y,k,z)}function WN(a,y,k){a[y.a]=Vk(k.a)}function KN(a,y,k){a[y.a]=Vk(k.a)}function LN(a,y,k,z){a[y][k].type=z}function Ss(a,y){fe(),a.__listener=y}function sS(a,y){(fe(),a.Xc)[j2]=!y}function _u(a,y){Rh(a,y,(fe(),a.Xc))}function q1(a,y){Rh(a,y,(fe(),a.Xc))}function cS(a,y){Am.call(this,a.a,y)}function uS(){M1.call(this,"LEFT",2)}function lS(a){Uv.call(this),this.a=a}function Dl(a){this.a=R$(a),this.b=a}function fS(a){this.a=a,Uv.call(this)}function MN(a,y){$w.call(this,a,y)}function NN(a,y){$w.call(this,a,y)}function F1(a,y){return a.indexOf(y)}function mh(a){return a?a.dg():null}function H1(a){return a!=null?oo(a):0}function Fg(a){return!!qt((be(),a))}function Sc(a){return qo(),ft(a),a}function RN(a,y,k){return CC(y,k),y}function PN(a,y){return a.a+=""+y,a}function Hg(a,y){return a.a+=""+y,a}function rt(a,y){return a.a+=""+y,a}function _N(a,y,k,z){a.a=y,kU(a,k,z)}function BN(a,y,k){AA(Nt(a.Bc,y),k)}function hS(){Qe.call(this,"listbox")}function dS(){Qe.call(this,"textbox")}function aS(){Qe.call(this,"toolbar")}function bS(){Qe.call(this,"tooltip")}function pS(){Qe.call(this,"tablist")}function gS(){Qe.call(this,"article")}function wS(){Qe.call(this,"marquee")}function vS(){Qe.call(this,"menubar")}function mS(){Qe.call(this,"heading")}function bi(a){return(be(),Ie).Wd(a)}function Vn(a){return(be(),Ie).Xd(a)}function $g(a){return(be(),Ie)._d(a)}function dn(a){return(be(),Ie).ae(a)}function DN(a){return(be(),Ie).fe(a)}function yS(a){return(be(),Ie).Yd(a)}function xS(a){return(be(),Ie).Zd(a)}function qN(a){return(be(),Ie).Qd(a)}function FN(a){return(be(),Ie).Rd(a)}function HN(a){return(be(),Ie).Sd(a)}function CS(a){return(be(),Ie).Ud(a)}function ko(a){return JI((be(),Ie),a)}function So(a){return EA((be(),Ie),a)}function Tc(){Tc=ge,Fd=(To(),To(),OW)}function kS(){kS=ge,Sf(),wx[P2]=ji}function SS(a){(be(),Ie).Vd(a),Na(a)}function Ug(a){return fe(),an.Be(a,0)}function IS(a){return Zt(a.l,a.m,a.h)}function AS(a){return(be(),a).target}function Is(a){return aB((fe(),a.Xc))}function $N(a){return GD((fe(),a.Xc))}function yh(){yh=ge,r1=(To(),To(),Zf)}function TS(){Jn.call(this,"FLEX",17)}function VS(){Jn.call(this,"BLOCK",1)}function zS(){Jn.call(this,"TABLE",7)}function ES(){W1.call(this,"FIXED",3)}function jS(){K1.call(this,"RIGHT",3)}function OS(){M1.call(this,"RIGHT",3)}function XS(){bh.call(this,"SOLID",4)}function UN(a){return(be(),Ie).be(a)}function GN(a){return Gh(a,a.rc,a.sc)}function Ir(a,y,k){return fl(a.I,y,k)}function ql(a,y,k){return ed(a.I,y,k)}function QN(a,y,k){a.R&&qB(a.R,y,k)}function JN(a,y){Jh(a.f,y),KA(a.i,y)}function YN(a,y,k){a.R&&FB(a.R,y,k)}function Fl(a,y){a.o=y,y0(a),a.g=!0}function WS(a){this.a=a,xi.call(this)}function KS(a){this.a=a,xi.call(this)}function LS(a){this.a=a,xi.call(this)}function Gg(a){this.a=a,xi.call(this)}function MS(a){this.a=a,xi.call(this)}function NS(a){this.a=a,xi.call(this)}function RS(a){this.a=a,xi.call(this)}function PS(a){this.a=a,xi.call(this)}function _S(a){this.a=a,xi.call(this)}function BS(a){this.a=a,xi.call(this)}function DS(a){this.a=a,xi.call(this)}function qS(a){this.a=a,xi.call(this)}function FS(a){this.a=H6(),this.b=a}function HS(a){this.a=H6(),this.b=a}function ZN(a){du(a,a.b,!0),Ar(a.V)}function $1(a){a.i=Le(Px,ve,74,0,0,1)}function Qg(a){a.a=Le(Ke,ve,1,0,5,1)}function $S(){Qe.call(this,"checkbox")}function US(){Qe.call(this,"combobox")}function GS(){Qe.call(this,"document")}function QS(){Qe.call(this,"gridcell")}function JS(){Qe.call(this,"tabpanel")}function YS(){Qe.call(this,"treeitem")}function ZS(){Qe.call(this,"treegrid")}function e7(){Qe.call(this,"rowgroup")}function t7(){Qe.call(this,"listitem")}function n7(){Qe.call(this,"menuitem")}function i7(){bh.call(this,"DOTTED",1)}function r7(){bh.call(this,"DASHED",2)}function o7(){Jn.call(this,"INLINE",2)}function s7(){Jn.call(this,"RUN_IN",6)}function c7(){W1.call(this,"STATIC",0)}function u7(){K1.call(this,"CENTER",0)}function l7(){X1.call(this,"SCROLL",2)}function f7(){ph.call(this,"NORMAL",0)}function h7(){ph.call(this,"NOWRAP",1)}function d7(){M1.call(this,"CENTER",0)}function eR(a){return(be(),a).touches}function U1(a){return(be(),a).options}function a7(a,y){return MR((be(),a),y)}function tR(a,y){Qr(),yd(),D_($m(a),y)}function Jg(a,y,k){a.setAttribute(y,k)}function b7(a,y,k){ff.call(this,a,y,k)}function nR(a,y){a.d=da(a.d,[y,!1])}function iR(a,y,k,z){bq(pi(a.a),y,k,z)}function rR(a){WI(a),BV(a),LV(a),bV(a)}function oR(a){T0(a.V),i_(a.V),lT(a.V)}function sR(a){Ct((ut(),pt),new ag(a))}function Yg(a){Ct((ut(),pt),new hg(a))}function p7(a){Ct((ut(),pt),new fg(a))}function cR(a){Ct((ut(),pt),new T5(a))}function Ar(a){Ct((ut(),pt),new oh(a))}function uR(a,y){a.d=1,a_(new I6(a,y))}function Zg(a,y){oi||(a.b=y)}function lR(a,y){return a[a.length]=y}function fR(a,y){return a[a.length]=y}function g7(a){return a.a<a.c.a.length}function xh(a){return a<10?"0"+a:""+a}function hR(a,y){return a<y?-1:a>y?1:0}function dR(a,y,k){return RN(a.a,y,k)}function aR(a,y,k){Q3(a,dR(y,a.a,k))}function bR(a,y){(fe(),a).align=y.a}function w7(a){Xi(),Zq.call(this,a)}function v7(a){this.d=new Ot,this.c=a}function Ch(){Ch=ge,new lI,WW=new st}function ew(){ew=ge,DX=new rS,qX=new X7}function at(){at=ge,er=new m7,Zi=new Rk}function m7(){l6.call(this,"VISIBLE",0)}function y7(){X1.call(this,"VISIBLE",0)}function x7(){K1.call(this,"JUSTIFY",1)}function C7(){Qe.call(this,"directory")}function k7(){Qe.call(this,"separator")}function S7(){Qe.call(this,"rowheader")}function I7(){Qe.call(this,"scrollbar")}function A7(){M1.call(this,"JUSTIFY",1)}function G1(a){return fe(),qt((be(),a))}function T7(a){return fe(),Ba((be(),a))}function Zt(a,y,k){return{l:a,m:y,h:k}}function pR(a,y){return Bl(a.G,he(y))}function gR(a,y){return Bl(a.H,he(y))}function ze(a,y){return a!=null&&zH(a,y)}function xe(a,y){return a.appendChild(y)}function Jo(a,y){return a.removeChild(y)}function cr(a,y){return parseInt(a[y])|0}function we(a){return a.backingJsObject}function V7(a){return a.backingJsObject}function Hl(a){return qe+a.rc+Ye+a.sc}function kh(a){return(be(),a).keyCode|0}function wR(a){(be(),a).options.length=0}function $l(a){mW||(a.De(),mW=!0)}function tw(a){nw(a),rw(a),iw(a),a.df()}function Ul(a,y,k){a.f[new Ee(y).a]=k}function vR(a,y,k){fe(),an.Ee(a,Vr(y),k)}function Sh(a,y,k){return y.replace(a,k)}function Q1(a,y){Ca.call(this,null,a,y)}function z7(){ph.call(this,"PRE_WRAP",4)}function E7(){ph.call(this,"PRE_LINE",3)}function j7(){W1.call(this,"RELATIVE",1)}function O7(){W1.call(this,"ABSOLUTE",2)}function X7(){Hk.call(this,"ELLIPSIS",1)}function W7(){Jn.call(this,"INITIAL",16)}function mR(a){return Km(a,a.u.length-1)}function nw(a){a.a&&(lt(a.a),a.a=null)}function iw(a){a.e&&(lt(a.e),a.e=null)}function rw(a){a.j&&(lt(a.j),a.j=null)}function K7(a){Ii(a.a,a.b),Wh(a.a,!1)}function yR(a){Ii(a.j,""),Vc(a,""),Zl(a)}function Vc(a,y){a.b=y,Ii(a.a,y),$v(a,y)}function ow(a){a.v=!1,a.u=!1,Xh(a)}function sw(a){lt(a.B),Uo(a.B,-15736909)}function L7(a,y,k){Zr(a.zc,y),wo(a.zc,k)}function M7(a,y){return bn(Je(a.a).c,y)}function xR(a){return(!a.T||!a.D)&&!a.Z}function CR(a){return(!a.T||!a.F)&&!a.Z}function kR(a){return!!a&&!a.isEmpty()}function SR(a){return ye(Vf,typeof a)}function IR(a){return ye(xd,typeof a)}function cw(a,y){return a.lastIndexOf(y)}function N7(a,y,k){return a.indexOf(y,k)}function Xc(a){return qo(),!!a}function AR(a){oi||(a.e=!1)}function Gl(a){if(!a)throw we(new Ku)}function Ql(a){if(!a)throw we(new uh)}function J1(){J1=ge,xW=new m4,CW=new y4}function R7(){R7=ge,Jy=new Yt,qd=new Yt}function uw(a){w2(),os.call(this,a,0)}function Jl(){$1(this),Xa(this),this.Hd()}function P7(a,y){this.a=a,zn(),this.b=y}function lw(a,y){(fe(),a.Xc).style[Bt]=y}function Y1(a,y){(fe(),a.Xc).style[mt]=y}function Yo(a){(be(),a).stopPropagation()}function Yl(a){return!!(be(),a).shiftKey}function TR(a){return cr((fe(),a.Xc),pl)}function VR(a){return cr((fe(),a.Xc),Mf)}function zR(a){return cr((fe(),a.Xc),pl)}function Io(a,y){return(be(),Ie).ce(a,y)}function Z1(a){return a.$H||(a.$H=++dQ)}function ER(a){return a.l+a.m*ui+a.h*Rr}function jR(a){(fe(),a.Xc).multiple=!1}function OR(a){(fe(),a.Xc).style[uo]="1"}function XR(a){(fe(),a.Xc).style[uo]="0"}function ea(a){(fe(),a.Xc).style[uo]="2"}function ta(a){(fe(),a.Xc).style[uo]="2"}function _7(a){this.c=a,this.a=!!this.c.O}function B7(){Ov.call(this),this.a=new I4}function na(a){w1.call(this,a),this.a=a}function fw(a){v1.call(this,a),this.a=a}function Bu(a){g1.call(this,(ft(a),a))}function ia(){k1(),AD.call(this,yA(ue))}function D7(){Jn.call(this,"LIST_ITEM",5)}function Du(){Du=ge,xl=new ar(Mz,new t4)}function hw(){hw=ge,Zd=new ar(Td,new s4)}function dw(){dw=ge,t1=new ar(L2,new u4)}function qu(){qu=ge,Cl=new ar(Pz,new h4)}function WR(a){this.j=new J3(this),this.s=a}function aw(a,y){this.a=new v7(y),this.b=a}function KR(a,y){Mt(a.n),y&&nl(a.n,y)}function LR(a,y){return!!a.r&&bn(a.r,y)}function Zo(a,y,k){return a.substr(y,k-y)}function MR(a,y){return a.createElement(y)}function Ih(a,y){return $u(a.a,y)!=null}function bw(a,y,k){return y<=a.ob&&k<=a.Sc}function q7(a){return a.b!=null?a.b:""+a.c}function NR(a){Hw(a.a,a.db,a.zb,a.bb,a.xb)}function RR(a){a.b&&(Sr(a.b.a),a.b=null)}function F7(a){a.c&&(JN(a,a.c),a.c=null)}function PR(a){gf(a)||a.i&&pT(a)}function ht(a){a.k==null&&gU(a)}function ra(a,y){Ct((ut(),pt),new a6(a,y))}function pw(a,y){Ct((ut(),pt),new S6(a,y))}function _R(a,y){ls(a.V.Ec),y&&qU(a.V,y)}function BR(a,y,k){_B(a.W,k,y),gn(a.s,200)}function H7(a,y){y?Ue(a.j,Y2):zt(a.j,Y2)}function Fu(a,y){Zw.call(this,a),this.a=y}function DR(a,y){y.$modCount=a.$modCount}function gw(a,y){return ze(y,90)&&y.a==a.a}function ww(a,y){return a.createTextNode(y)}function qR(a,y){return a.getElementById(y)}function FR(a,y){yg(),a.__gwt_resolve=CD(y)}function $7(a){return Yc(),parseInt(a)||-1}function HR(a){gf(a)||!a.i&&pT(a)}function U7(a){return!a.C&&(a.C=dd(a)),a.C}function oa(a){return!a.v||a.v&&!a.u&&!a.f}function $R(a,y){return a.hasOwnProperty(y)}function G7(a){this.a=new ae.Date(hv(a))}function vw(a){a.d?a.d=!1:q0(a.V,!0)}function UR(a,y){a.Gb=y,a.Hb=Kr(y),Vs(a.Ib)}function Q7(a,y){oi||St(a.a,y)}function J7(a,y){Zw.call(this,a),this.a=y}function Y7(a,y){Zw.call(this,a),this.a=y}function Z7(){Jn.call(this,"TABLE_ROW",15)}function e8(){Jn.call(this,"TABLE_CELL",13)}function mw(){eN.call(this,(fe(),Oe(ue)))}function GR(a){return rt(a.a,mU("Fill")),a}function QR(a,y){a.b=da(a.b,[y,!1]),UA(a)}function JR(a,y){a.backingJsObject=y,pV(a,y)}function YR(a,y){return ae.setTimeout(a,y)}function yw(a,y){return a.a.ig(new aC(y))}function xw(a,y){return a.a.ig(new bC(y))}function t8(a,y,k){return a.apply(y,k)}function n8(a,y){return z$(a,y,a.b.a.length)}function i8(a,y){return a&&y&&a instanceof y}function Ah(a){return fe(),Hn((be(),a).type)}function Cw(){Yw.call(this,(ci(),ue.body))}function r8(){Jn.call(this,"INLINE_FLEX",18)}function o8(){Jn.call(this,"INLINE_BLOCK",3)}function s8(){Jn.call(this,"INLINE_TABLE",4)}function Th(){Th=ge,Gf=new ar("blur",new Zx)}function c8(){Ch(),new Ot,new Ot,new Ot}function kw(){kw=ge,new hA,hx=new Dk,dx=FA()}function Sw(a){a.k=0,a.n=0,Oo(a.M),a.N=!1}function Je(a){return!a.K&&(a.K=a.nf()),a.K}function pi(a){return!a.C&&(a.C=a.tf()),a.C}function ZR(a){a.N||(a.N=!0,Hv(a.M,50))}function eP(a,y){Ue(y,Ly),a.b&&Ut(a.a.p,y)}function tP(a,y){var k;k=a[gp],k.call(a,y)}function nP(a,y){var k;k=a[gp],k.call(a,y)}function iP(a,y){return ae.setInterval(a,y)}function rP(a,y,k){return a.lastIndexOf(y,k)}function u8(a,y){return a.a.containsValue(y)}function l8(a,y){return ft(a),Lt(a)===Lt(y)}function ye(a,y){return ft(a),Lt(a)===Lt(y)}function oP(a){return ye(a,Kd)||ye(a,Ld)}function f8(a,y,k){return a.insertBefore(y,k)}function sP(a,y){return a.getAttribute(y)||""}function As(a){return Dt((be(),a).clientX||0)}function Ts(a){return Dt((be(),a).clientY||0)}function h8(a){return(be(),a).changedTouches}function cP(a){return String.fromCharCode(a)}function Hu(a,y,k){return new r5(P$(a.a,y,k))}function uP(a){var y;Qf&&(y=new b4,Ws(a,y))}function d8(a){var y;fo&&(y=new a4,a.td(y))}function a8(a,y){y!=null?V1(a.e,y):V1(a.e,"")}function b8(a,y){y!=null?Eg(a.e,y):Eg(a.e,"")}function lP(a,y){a2(a,a.db,a.zb,1,a.ob,a.d,y)}function Iw(a,y){(fe(),a.Xc).style[uo]=y+""}function fP(a,y){a.style.verticalAlign=y.a}function Wc(a,y){this.a=a,this.b=eH(this.a,y)}function p8(a,y,k){this.a=a,this.b=y,this.c=k}function g8(a,y,k){this.a=a,this.b=y,this.c=k}function w8(a,y,k){this.a=a,this.b=y,this.c=k}function Aw(a,y,k){this.a=a,this.c=y,this.b=k}function $e(a,y,k,z){LN(a.c,(ht(y),y.k),k,z)}function hP(a){(To(),To(),Zf).Ze((fe(),a.Xc))}function dP(a,y){oi||y&&(a.d=y)}function aP(a,y){return qo(),a==y?0:a?1:-1}function v8(a,y){a.b=y,a.c=0,a.d=a.b+"."+a.c}function sa(a,y,k,z,E){a.i=y,a.f=k,a.g=z,a.e=E}function ca(a,y,k,z,E){a.t=y,a.r=k,a.s=z,a.q=E}function m8(a,y,k){return Nt(a.e,qe+y+Ye+k)}function ua(a,y){if(!a)throw we(new $o(y))}function Ii(a,y){(fe(),a.Xc)[Nf]=y??""}function bP(a,y){a2(a,1,a.Sc,a.bb,a.xb,a.Qc,y)}function Ee(a){Wc.call(this,(ht(a),a.k),null)}function y8(){Jn.call(this,"TABLE_COLUMN",14)}function x8(){Jn.call(this,"TABLE_CAPTION",8)}function Vh(a,y,k){si.call(this,a,y),this.a=k}function C8(a,y,k){this.a=a,this.b=y,this.c=k}function k8(a,y,k){this.d=a,this.b=k,this.a=y}function zh(a){this.b=(ft(a),a),this.a=16464}function S8(a){a.X=0,a.Y=0,Oo(a.mc),a.nc=!1}function pP(a){!a.o&&a.k!=-1&&a.n!=-1&&Vs(a.p)}function gP(a){ae.cancelAnimationFrame(a.id)}function la(a){return a==null?0:+a}function St(a,y){return a.a[a.a.length]=y,!0}function Tw(a,y,k){qT(k,0,a,y,k.length,!1)}function _n(a,y){return fr(ET(At(a)?Mn(a):a,y))}function Bn(a,y){return fr(Qm(At(a)?Mn(a):a,y))}function Yn(a,y){return fr(T$(At(a)?Mn(a):a,y))}function I8(a,y){!a.a&&(a.a=new st),St(a.a,y)}function wP(a){var y;Jf&&(y=new p4,Ws(a.a,y))}function vP(a){a.nc||(a.nc=!0,Hv(a.mc,50))}function Rc(a){Vs(a.lc),kf(a),C9(a),T0(a),lT(a)}function A8(a,y){this.e=y,R9(this,(ft(a),a))}function T8(){this.a=new st,this.b=new WS(this)}function Ao(){Ao=ge,ws=new ar("click",new e4)}function Vw(){Vw=ge,Gd=new ar("focus",new n4)}function zw(){zw=ge,Yd=new ar("keyup",new o4)}function Ew(){Ew=ge,Qd=new ar("keydown",new i4)}function jw(){jw=ge,Jd=new ar("keypress",new r4)}function Ow(){Ow=ge,n1=new ar("touchend",new l4)}function _c(){_c=ge,Wp=new X3,Qx=new W3}function V8(){V8=ge,Nx=Le(Yi,ve,90,256,0,1)}function mP(a){return qo(),ye($0,typeof a)}function _e(a){return At(a)?a|0:Ok(a)}function yP(a){return a.a.s?a.a.a:-1}function z8(a){RA(a,a.yc.e,a.yc.f,a.yc.K,a.yc.L)}function Xw(a,y){xM(a.Q),yR(a.u),DI(a),xG(a.V,y)}function Vs(a){!a.c&&(a.c=new BS(a)),gn(a.c,a.b)}function Zl(a){a.k=-1,a.n=-1,a.o=-1,a.p=-1,OT(a)}function fa(a){return At(a)?""+a:SV(a)}function E8(a,y){return mi(function(){a.jd(y)})}function xP(a,y){return!!a.tb&&a.tb.contains(y)}function Ww(a,y){return a[0]!==y[0]||a[2]!==y[2]}function Kw(a,y){return a[1]!==y[1]||a[3]!==y[3]}function Lw(a){return Array.isArray(a)&&a.og===Me}function CP(a){return(be(),a).createElement(Id)}function kP(a){return(be(),a).createElement(z2)}function SP(a,y){return a.getElementsByTagName(y)}function IP(a,y,k,z){var E;E=I9(a,y,k),E.add(z)}function ur(a,y){var k;return k=ga(a,y),k.f=2,k}function Ze(a,y){return pn(y,a.a.length),a.a[y]}function AP(a,y){KF(y,a.length),JD(a,0,y,null)}function Mw(a){var y;a.c=(y=Gt(a.j),y??"")}function TP(a,y){var k;k=Eo(a.Bc,y),k&&gd(a,k)}function VP(a){Nm(Re(a.vf()),!0),a.q&&Oo(a.q)}function zP(a,y){a2(a,a.db,a.zb,a.bb,a.xb,a.kc,y)}function EP(a,y){xt(a.a,Se(Ce(Ke,1),ve,1,5,[y]))}function jP(a,y){xt(a.b,Se(Ce(Ke,1),ve,1,5,[y]))}function OP(a,y){xt(a.c,Se(Ce(Ke,1),ve,1,5,[y]))}function XP(a,y){xt(a.B,Se(Ce(Ke,1),ve,1,5,[y]))}function j8(){j8=ge,Rx=Le($W,ve,103,256,0,1)}function Nw(){Nw=ge,e1=new ar("mousedown",new c4)}function Rw(){Rw=ge,i1=new ar("touchmove",new f4)}function Pw(){this.qb=new Ot,this.gb=(Xv(),Ax)}function O8(a,y){this.a=a,this.b=y,this.c="poll"}function X8(a,y){C1(),this.c=a,this.b=y}function WP(a,y){Te(a.a,(_h(),oi?null:y.c),y)}function _w(a,y){return ft(a),ZH(a,(ft(y),y))}function KP(a){return a.jb==null||a.jb.length==0}function LP(a){return a.nb==null||a.nb.length==0}function Bw(a){return!Array.isArray(a)&&a.og===Me}function W8(a){return(be(),a).createElement("td")}function Dw(a){return(be(),a).createElement("tr")}function MP(a){vt(a,Fi((fe(),a.Xc))+"-"+Z0,!1)}function NP(){Qs(),!uX&&(uX=!0,SU(!1))}function RP(a){return a.b?a.b:(Nn(),f1)}function qw(a,y,k){return k>a.Sc&&k<=a.zb&&y<=a.ob}function Fw(a,y,k){return y>a.ob&&y<=a.xb&&k<=a.Sc}function K8(a,y,k){a.n=k,a.d=y,cg(a.e,y),CK(a.g,y)}function Eh(a,y,k){jo(y,a.a.length),Nu(a.a,y,k)}function ha(a,y){return a.M.length>=y?a.M[y-1]:a.r}function da(a,y){return!a&&(a=[]),a[a.length]=y,a}function L8(a){I1.call(this,new og),this.a=a}function M8(){Jn.call(this,"TABLE_ROW_GROUP",12)}function N8(){Jn.call(this,"TABLE_COLUMN_GROUP",9)}function R8(a){zC(),FD.call(this,(Ta(),new Oa(a)))}function PP(a){ci();try{a.xd()}finally{Ih(Sl,a)}}function P8(){return ei(),ae.navigator.userAgent}function aa(a,y){return a.a.get(y)!==void 0}function $u(a,y){return Qo(y)?Eo(a,y):Jm(a.a,y)}function $c(a){return!ye((It(),tn),Ru(a.style))}function Hw(a,y,k,z,E){wq(a.W,y,z,k,E),gn(a.s,200)}function _P(a,y,k,z,E,j,te,ne){RU(a.Q,y,k,z,E,j,te,ne)}function BP(a,y){xt(a.R,Se(Ce(Ke,1),ve,1,5,[y]))}function _8(a){this.b=a,this.a=Le(cX,ve,13,4,0,1)}function B8(a){$1(this),this.f=a,Xa(this),this.Hd()}function ef(a){Qg(this),Tw(this.a,0,a.toArray())}function $w(a,y){this.d=a,this.c=y&64?y|bl:y}function Uw(a,y){if(a==null)throw we(new ys(y))}function DP(a,y){t2(y,Re(U7(a.c))),Fa(a.a,Bp).pg()}function qP(a){return(be(),a).createElement("img")}function Oe(a){return(be(),a).createElement("div")}function FP(a,y){return Zt(a.l&y.l,a.m&y.m,a.h&y.h)}function HP(a,y){return Zt(a.l|y.l,a.m|y.m,a.h|y.h)}function $P(a,y){return Zt(a.l^y.l,a.m^y.m,a.h^y.h)}function UP(a){var y;return a.d=2,y=a.a,a.a=null,y}function GP(){return Ff==2?new S4:new D3}function QP(){return Ff==2?new B3:new _3}function JP(){return Ff==2?new w4:new v4}function YP(){return Ff==2?new R3:new P3}function ZP(){return Ff==2?new M3:new L3}function e_(a){gf(a)||a.i&&gT(a)}function t_(a){gf(a)||a.i||gT(a)}function n_(a){fe(),ho&&a==ho&&(ho=null),an.Fe(a)}function tf(a){fe(),ho&&a==ho&&(ho=null),an.Fe(a)}function i_(a){a.k!=-1&&a.n!=-1&&a.j!=null&&pd(a.q)}function r_(a){a.a=jn(""),AR(a.a),Fq(a.a),H_(a.a)}function nf(){Mg.call(this),xs(this,a7(ue,"div"))}function D8(){ZT.call(this),this.u=!0,this.v=!0}function q8(){Jn.call(this,"TABLE_HEADER_GROUP",10)}function F8(){Jn.call(this,"TABLE_FOOTER_GROUP",11)}function H8(){H8=ge,xx=jn("spreadsheet RpcProxy")}function Uc(){Uc=ge,UW=new I1(null),new I1(null)}function ci(){ci=ge,TW=new C4,Eu=new Ot,Sl=new Si}function To(){To=ge,Zf=QP(),OW=ze(Zf,147)?new k4:Zf}function o_(a,y){return ka(a.e,y,fo||(fo=new xr))}function $8(a,y){return en(a,y)<0?-1:en(a,y)>0?1:0}function s_(a){return new Fu(null,h_(a,a.length))}function zs(a,y){return a[y]==null?null:String(a[y])}function ba(a){return(be(),a).createElement("span")}function eo(a){return(be(),a).getAttribute(Gi)||""}function rn(a){return(fe(),a.Xc).style.display!=tn}function c_(a){return Zt(~a.l&wn,~a.m&wn,~a.h&Li)}function Es(a){Ql(a.b!=-1),Or(a.c,a.a=a.b),a.b=-1}function u_(a,y){Jh(a.a,y),a.a.a.length==0&&Oo(a.b)}function Gw(a,y){a.w=y,Iv(a),y.length==0&&(a.w=null)}function U8(a,y){a.A=y,Iv(a),y.length==0&&(a.A=null)}function l_(a,y){(fe(),a.Xc).style[mt]=y+(tt(),ke)}function G8(a,y){a.H!=y&&(a.H=y,zn(),Ll())}function Q8(a,y){y.length==0?Ii(a.j,y):Ii(a.j,"="+y)}function J8(a,y){a.a.e=a.c+(a.b-a.c)*y,Zv(a.a,a.a.e)}function Y8(a,y,k,z){var E;E=new q9(k,z),t$(a.V,y,E)}function jh(a,y,k,z){a.b[D1(new Ys(new Ee(y),k))]=z}function Z8(a,y,k,z){a.e[D1(new Ys(new Ee(y),k))]=z}function Cn(a,y){return!!a.w&&et(a.w,he(y),0)!=-1}function Vo(a,y){return!!a.v&&et(a.v,he(y),0)!=-1}function f_(a){return a.a.t==5&&(a.a.u==3||a.a.u==4)}function rf(a,y){return Qo(y)?bn(a,y):!!Ph(a.a,y)}function h_(a,y){return wB(y,a.length),new mI(a,y)}function Uu(a){return(be(),a).createElement("style")}function eI(a){return(be(),a).createElement("tbody")}function tI(a){return(be(),a).createElement("table")}function d_(a){return(be(),Ie).Od(a,Td,!1,!1)}function nI(a,y){return Hu((!_o&&(_o=new E1),_o),a,y)}function a_(a){fQ(a),gq((!An&&(An=new Xs),An),a.a.c)}function Mt(a){a.a=new FS(a),a.b=new HS(a),Lh(a)}function Oh(a){this.a=new n9(a.size()),Ua(this,a)}function b_(a,y){var k;return k=a.slice(0,y),mA(k,a)}function to(a,y){var k,z;return z=YV(a,y),k=SD(z),k}function pa(a,y,k){var z,E;z=y+10,E=k-25,ll(a.Xb,z,E)}function p_(a,y){(fe(),a.Xc).style[Bt]=y+(tt(),"pt")}function g_(a){!ye(dt,R6((fe(),a.Xc).style))&&eu(a)}function Qw(a){return!ye(dt,R6((fe(),a.Xc).style))}function w_(a){ae.setTimeout(function(){throw a},0)}function iI(a){return a.bb?a.bb.ud():!1}function rI(a){var y;return y=[],Mv(a,new iC(y)),y}function oe(a,y,k){var z;return z=ga(a,y),MA(k,z),z}function ga(a,y){var k;return k=new Dv,k.g=a,k.d=y,k}function Ut(a,y){var k;return k=Zn(a.a,y,a),k==null}function kn(a,y,k){Xi(),this.e=a,this.d=y,this.a=k}function oI(){Qr(),D8.call(this),xg(this),Iw(this,Ap)}function wa(){Qr(),ZT.call(this),xg(this),Iw(this,Ap)}function sI(){Ra.call(this),WA(this.a,"▼",!0)}function cI(a){return!!a.qf().ob}function ft(a){if(a==null)throw we(new PC);return a}function zo(a,y,k){a.b[D1(new Ys(new Ee(y),"!new"))]=k}function v_(a,y){return rA(a,y),dF(U1((fe(),a.Xc))[y])}function m_(a,y){xt(a.p,Se(Ce(Ke,1),ve,1,5,[he(y)]))}function y_(a,y){xt(a.A,Se(Ce(Ke,1),ve,1,5,[he(y)]))}function x_(a,y){xt(a.D,Se(Ce(Ke,1),ve,1,5,[he(y)]))}function C_(a,y){xt(a.L,Se(Ce(Ke,1),ve,1,5,[he(y)]))}function k_(a,y,k,z,E,j,te,ne,ie){vU(a.Q,y,k,z,E,j,te,ne,ie)}function S_(a,y,k,z,E,j,te,ne){_P(pi(a.a),y,k,z,E,j,te,ne)}function I_(a,y){for(ft(y);a.c<a.d;)wk(a,y,a.c++)}function A_(a){a.C?Xw(a,!1):a.C=!0,Y9(a,a.a-1)}function Xh(a){a.f=!1,a.e=null,a.q=-1,a.s=-1,Zl(a)}function va(a){a.b?va(a.b):(Zh(a),a.c=!0)}function T_(a){var y;y=aA(a),d2(a,new st,a.bb,a.xb,y)}function V_(a){return(be(),a).createElement("canvas")}function z_(a){return(be(),a).createElement("iframe")}function E_(a){return(be(),a).createElement("select")}function j_(a,y){return Hu(a.a,(!Jf&&(Jf=new xr),Jf),y)}function es(a,y){return Lt(a)===Lt(y)||a!=null&&dr(a,y)}function Gu(a,y){return y>0&&a.g.length>=y?a.g[y-1]:a.q}function Qu(a){return!!a.T&&bn(a.T,qe+a.rc+Ye+a.sc)}function O_(a,y){return Object.hasOwnProperty.call(a,y)}function X_(){return ew(),Se(Ce(CQ,1),ve,93,0,[DX,qX])}function W_(){return at(),Se(Ce(SQ,1),ve,94,0,[er,Zi])}function K_(a,y){xt(a.Q,Se(Ce(Ke,1),ve,1,5,[rI(y)]))}function no(a,y){return Qo(y)?Nt(a,y):mh(Ph(a.a,y))}function Jw(a,y){return Lt(a)===Lt(y)||a!=null&&dr(a,y)}function uI(a){return Ci(),_6(),nI(fo||(fo=new xr),a)}function L_(a,y,k){a.e=y,iM((!a.C&&(a.C=new un),a.C),k)}function M_(a){bo(this,(fe(),a)),this.a=new _I(this.Xc)}function lI(){this.a=new a1,this.c=new a1,kI(this)}function fI(a){this.a=new st,this.c="__eager",this.b=a}function N_(a){var y;y=a.a.__eager,y.d==0&&uR(y,a.c)}function ma(a,y){var k;return k=ga("",a),k.j=y,k.f=1,k}function R_(a,y){ov();var k;return k=new aI,IF(k,a,y),k}function hI(a,y){return a.a+=String.fromCharCode(y),a}function P_(a){return String.fromCharCode.apply(null,a)}function dI(a){return(be(),a).createElement("textarea")}function Wh(a,y){y?Fd.Ze((fe(),a.Xc)):Fd.Xe((fe(),a.Xc))}function aI(){this.b=JH((ei(),!Ht&&(Ht=new co),ei(),Ht))}function bI(){U3(this,new ug(!0)),$3(this,(Nn(),f1))}function Yw(a){Mg.call(this),bo(this,(fe(),a)),ud(this)}function of(a,y,k){pk(this),this.c=a,this.b=y,this.a=k}function pI(a,y,k,z){this.a=a,this.d=y,this.b=k,this.c=z}function gI(a,y,k,z){this.a=a,this.d=y,this.b=k,this.c=z}function wI(a,y,k,z){this.a=a,this.d=y,this.c=k,this.b=z}function ya(a,y,k,z){this.d=a,this.a=y,this.c=k,this.b=z}function vI(a,y,k,z){this.a=a,this.b=y,this.c=k,this.d=z}function mI(a,y){this.c=0,this.d=y,this.b=17488,this.a=a}function Zw(a){a?this.b=a:(this.b=null,new st)}function yI(a){a.M&&(Zm(a.L,!1,!1),d8(a))}function __(a,y){return Zh(a),new Fu(a,new bA(y,a.a))}function B_(a,y){return Zh(a),new J7(a,new FI(y,a.a))}function ev(a,y){return Zh(a),new Y7(a,new HI(y,a.a))}function Zn(a,y,k){return Qo(y)?Te(a,y,k):_m(a.a,y,k)}function D_(a,y){oS((p2(),tO),a,Se(Ce(ct,1),Mi,2,6,[y]))}function xI(a,y){return Tt(y,a.length),a.charCodeAt(y)}function q_(a){var y;return y=a.a[0],a.e>0||y==xu?y:-y}function lt(a){var y;y=qt((be(),a)),y&&y.removeChild(a)}function tv(){var a;return a=null,a+=(Z9(),"?v="+Sx),a}function Yc(){Yc=ge;var a,y;y=!dH(),a=new yi,vp=y?new Kt:a}function zn(){zn=ge,Dd=new b3,Qj=new g3,Gy=new w3}function F_(){Yy==256&&(Jy=qd,qd=new Yt,Yy=0),++Yy}function H_(a){var y,k;y=new bI,Q7(a,y),k=new TI,Q7(a,k)}function $_(a){var y;y=(be(),Ie).Sd(a),y[Xd]=a.type,Na(a)}function U_(a,y,k){$M(a.e.D,k,sP((be(),y),"resource-"+k))}function G_(a,y,k,z,E,j,te,ne,ie){k_(pi(a.a),y,k,z,E,j,te,ne,ie)}function Eo(a,y){return y==null?Jm(a.a,null):e9(a.b,y)}function Q_(a,y){return y==a.c||y==a.Nc||y==a.Pc||y==a.zc}function J_(a){return ae.decodeURI(a.replace("%23","#"))}function CI(a){return a?Eq(a)+" ("+a.G+")":Ro}function nv(a){return a.a.b==8?a.a.c>=0:a.a.b>8}function kI(a){a.a.a=a.c,a.c.b=a.a,a.a.b=a.c.a=null,a.b=0}function SI(a,y,k){this.a=a,this.d=y,this.c=null,this.b=k}function II(a,y,k){this.a=a,this.d=y,this.c=null,this.b=k}function xa(a,y,k){this.a=C2,this.d=a,this.b=y,this.c=k}function AI(a,y,k){this.a=a,this.c=y,this.b=k,Uv.call(this)}function Y_(a,y){a.a.f||(el(a.b,!0),tH(a.b.a)),Yo(y.a)}function Ve(a,y){return fr(FP(At(a)?Mn(a):a,At(y)?Mn(y):y))}function Zc(a,y){return fr(HP(At(a)?Mn(a):a,At(y)?Mn(y):y))}function iv(a,y){return fr($P(At(a)?Mn(a):a,At(y)?Mn(y):y))}function TI(){U3(this,new ug(!1)),$3(this,(Nn(),f1))}function Z_(){return hf(),Se(Ce(TQ,1),ve,109,0,[cx,sx,Cp])}function eB(a,y){oS((p2(),eO),a,Se(Ce(pQ,1),ve,175,0,[y]))}function tB(a,y){a.b?(a.lf(0),a.f||a.jf(y)):a.lf(y)}function nB(a){return a.r?(vm(a.r),a.q):null}function rv(a){xn();var y,k;return y=Qa(a),k=Ja(a),e0(y,k)}function iB(){kw();var a;a=FA(),ye(a,dx)||(dx=a,wP(hx))}function rB(){ci();try{jm(Sl,TW)}finally{Mt(Sl.a),Mt(Eu)}}function ov(){ov=ge,vr=f_((ei(),!Ht&&(Ht=new co),ei(),Ht))}function ts(){ts=ge,WX=new y7,OX=new Nk,XX=new l7,jX=new nS}function Ju(){Ju=ge,NX=new c7,MX=new j7,KX=new O7,LX=new ES}function Kh(){Kh=ge,RX=new u7,PX=new x7,_X=new iS,BX=new jS}function sv(){sv=ge,VW=new d7,zW=new A7,EW=new uS,jW=new OS}function oB(a,y){var k;return k=a.Lf(),Object.assign(k,y),k}function Yu(a,y){var k;return k=Ml(a.mg),y==null?k:k+": "+y}function Lh(a){var y,k;k=a,y=k.$modCount|0,k.$modCount=y+1}function cv(a){a.d||(a.d=new Fe(a.b),a.c=a.b.a.length)}function Di(a,y){Np&&nd(a,(Nn(),ih),y,null)}function Tr(a,y){Rp&&nd(a,(Nn(),h1),y,null)}function Mh(a,y){Pp&&nd(a,(Nn(),Kp),y,null)}function bn(a,y){return y==null?!!Ph(a.a,null):aa(a.b,y)}function VI(a){return zn(),ze(a,180)?new Ik(a):new na(a)}function qi(a){return(be(),Ie).Wd(a)+((a.offsetWidth||0)|0)}function sB(a,y){OH(a,$T(a),y),m$(a,y),a.tb=bD(y,a.tb),KT(a)}function cB(a,y,k){xt(a.T,Se(Ce(Ke,1),ve,1,5,[he(y),k]))}function uB(a){a.a.C&&xt(a.a.a.W.n,Se(Ce(Ke,1),ve,1,5,[]))}function lB(){return ja(),Se(Ce(Xx,1),ve,142,0,[Xu,qW])}function fB(a,y,k,z){a.b>0?I8(a,new wI(a,y,k,z)):G9(a,y,k,z)}function zI(a,y,k,z){this.b=a,this.c=y,dN(this,k),hN(this,z)}function Ca(a,y,k){this.b=y,this.c=VI(new lh(k)),this.a=a}function uv(a,y){var k;return k=om(a,y),k&&jB((fe(),y.Xc)),k}function EI(a,y){var k;for(k=0;k<y;++k)a[k]=new vg(a[k])}function Nh(a,y){return a==null?y==null:ye(a,y)}function hB(a){if(a.Sf())return null;var y=a.j;return Bd[y]}function dB(a){function y(){}return y.prototype=a||{},new y}function gi(a){return(be(),Ie).Xd(a)+((a.offsetHeight||0)|0)}function bt(a){return Math.max(Math.min(a,Ki),-2147483648)|0}function jI(a,y){return y===a?"(this Map)":y==null?Ro:wi(y)}function OI(a,y,k){return y>=a.bb&&y<=a.xb&&k>=a.db&&k<=a.zb}function ka(a,y,k){return Hu(a.Vc?a.Vc:a.Vc=new Pu(a),k,y)}function Sa(a,y){var k;$s&&(k=new i5(y),a.Vc&&Ws(a.Vc,k))}function Ia(a){var y;return y=a.c?Yr(a.a):a.a,(be(),Ie)._d(y)}function ns(a){for(;a.lastChild;)a.removeChild(a.lastChild)}function XI(){D8.call(this),this.I=!1,xg(this),Iw(this,Ap)}function WI(a){ls(a.Dc),a.pb&&(ls(a.pb),lt(a.pb),a.pb=null)}function sf(a,y){a&&((be(),Ie).de(a,y),a.title=y||"")}function KI(a,y){return y?(Mt(y),a&&nl(y,a)):y=a,y}function lv(a){return a.b||(a.b=new eV,cg(a.b,pi(a.d))),a.b}function aB(a){try{return a.selectionStart}catch{return 0}}function bB(a,y,k){try{a.setSelectionRange(y,y+k)}catch{}}function pB(a,y,k){try{a.setSelectionRange(y,y+k)}catch{}}function LI(a,y,k,z){a.Zb=!1,Ct((ut(),pt),new gI(a,y,k,z))}function MI(a,y,k,z){a.Zb=!1,Ct((ut(),pt),new pI(a,y,k,z))}function gB(a,y){var k;return sq(a,new st,(k=new nC(y),k))}function wB(a,y){if(0>a||a>y)throw we(new Ag(gz+a+S2+y))}function jo(a,y){if(a<0||a>y)throw we(new vo(I2+a+A2+y))}function Aa(a,y){$1(this),this.e=y,this.f=a,Xa(this),this.Hd()}function Rh(a,y,k){br(y),zM(a.o,y),fe(),xe(k,Vr(y.Xc)),qn(y,a)}function vB(a,y){a.f?(Mt(a.f),y&&nl(a.f,y)):a.f=y}function mB(a,y){a.k?(Mt(a.k),y&&nl(a.k,y)):a.k=y}function yB(a,y){a.N?(Mt(a.N),y&&nl(a.N,y)):a.N=y}function io(a,y){return a.I?a.I[y]:(zn(),zn(),Dd)}function xB(){return ts(),Se(Ce(mQ,1),ve,62,0,[WX,OX,XX,jX])}function CB(){return Ju(),Se(Ce(yQ,1),ve,63,0,[NX,MX,KX,LX])}function kB(){return Kh(),Se(Ce(xQ,1),ve,64,0,[RX,PX,_X,BX])}function SB(){return sv(),Se(Ce(VQ,1),ve,65,0,[VW,zW,EW,jW])}function Vr(a){return fe(),a.__gwt_resolve?a.__gwt_resolve():a}function IB(){return Fv(),Se(Ce(Zj,1),ve,86,0,[Jj,Qy,Yj])}function Nt(a,y){return y==null?mh(Ph(a.a,null)):qg(a.b,y)}function NI(a,y){return ze(y,100)?fT(a.a,y):!1}function AB(a){return dD(a)?!!a&&a.nodeType==1:!1}function TB(a){return(!An&&(An=new Xs),An).c.d[new Ee(a).b]}function RI(a){return new RegExp("^([^A-z0-9:!])$").test(a)}function VB(a){a.t.Z?gn(new Gg(a),100):Ct((ut(),pt),new dg(a))}function zB(a,y){for(ft(y);a.a<a.c.a.length;)T1(y,He(a))}function EB(a,y){a.a=y,vr?(y+=a.n,Zv(a,-y)):Zv(a,-a.a)}function pn(a,y){if(a<0||a>=y)throw we(new vo(I2+a+A2+y))}function Tt(a,y){if(a<0||a>=y)throw we(new Tg(I2+a+A2+y))}function PI(a,y){var k=a.a=a.a||[];return k[y]||(k[y]=a.Nf(y))}function fv(a){var y=a.__listener;return!tl(y)&&ze(y,9)?y:null}function _I(a){this.a=a,this.c=!1,this.b=z9(a),this.d=this.b}function jB(a){a.style[vn]="",a.style[fn]="",a.style[as]=""}function Ta(){Ta=ge}function OB(a,y,k){xt(a.e,Se(Ce(Ke,1),ve,1,5,[he(y),he(k)]))}function XB(a,y,k){xt(a.o,Se(Ce(Ke,1),ve,1,5,[he(y),he(k)]))}function WB(a,y,k){xt(a.r,Se(Ce(Ke,1),ve,1,5,[he(y),he(k)]))}function KB(a,y,k){xt(a.s,Se(Ce(Ke,1),ve,1,5,[he(y),he(k)]))}function LB(a,y,k){xt(a.w,Se(Ce(Ke,1),ve,1,5,[he(y),he(k)]))}function MB(a,y,k){xt(a.H,Se(Ce(Ke,1),ve,1,5,[he(y),he(k)]))}function NB(a,y,k){xt(a.I,Se(Ce(Ke,1),ve,1,5,[he(y),he(k)]))}function RB(a,y,k){xt(a.K,Se(Ce(Ke,1),ve,1,5,[he(y),he(k)]))}function PB(a,y,k){xt(a.M,Se(Ce(Ke,1),ve,1,5,[he(y),he(k)]))}function _B(a,y,k){xt(a.O,Se(Ce(Ke,1),ve,1,5,[he(y),he(k)]))}function BB(){return pv(),Se(Ce(wQ,1),ve,54,0,[aX,hX,fX,dX,bX])}function DB(){return gv(),Se(Ce(IQ,1),ve,55,0,[eW,tW,nW,iW,rW])}function Te(a,y,k){return y==null?_m(a.a,null,k):em(a.b,y,k)}function qB(a,y,k){Je(a.a).u&&(a.a.g=y,a.a.f=null,m_(a.a.i,k))}function FB(a,y,k){Je(a.a).u&&(a.a.g=y,a.a.f=null,C_(a.a.i,k))}function Zu(a,y,k,z){ye(a.b,k)||(a.b=k,a.df()),a.f=z,Fl(a,y)}function cf(a,y,k){return a.a=Zo(a.a,0,y)+(""+k)+Zs(a.a,y),a}function uf(a,y){var k,z;return k=a>0?Rv(a):"",z=y>0?""+y:"",k+z}function HB(a,y){var k;return k=a.a.get(y),k??new Array}function $B(a,y){return a.e!=y?(a.e=y,!0):!1}function UB(a,y){return a.b!=y?(a.b=y,!0):!1}function GB(a,y){a.G?(Mt(a.G.a),y&&Ua(a.G,y)):a.G=y}function QB(a,y){a.H?(Mt(a.H.a),y&&Ua(a.H,y)):a.H=y}function JB(a,y){var k;!zp&&eR(y.a).length==1&&(k=y.a,cV(a,k))}function YB(a,y){for(var k in a)a.hasOwnProperty(k)&&y(k,a[k])}function Ai(a,y){return Cn(a.a,y)?0:y>=a.W.length?$i(a):a.W[y-1]}function En(a,y){return a&&a.equals?a.equals(y):Lt(a)===Lt(y)}function ZB(){return Xv(),Se(Ce(Tx,1),ve,111,0,[DW,Ax,BW])}function eD(){return Za(),Se(Ce(Ix,1),ve,116,0,[jp,PW,RW])}function tD(){return il(),Se(Ce(WQ,1),ve,120,0,[Ep,kx,Cx])}function nD(a,y,k){xt(a.S,Se(Ce(Ke,1),ve,1,5,[he(y),he(k)]))}function BI(a){var y;SM(a.t,Dn((y=Gt(a.a),y??"")," ",""))}function is(a){var y;y=Rt(a,a.rc,a.sc),a.nb=null,y&&zt(y.d,qs)}function iD(a){var y;return y=m8(a,a.rc,a.sc),!!y&&y.isPercentage}function hv(a){var y;return At(a)?(y=a,y==-0?0:y):jq(a)}function rD(a){return Ci(),_6(),TN(),nI((!Qf&&(Qf=new xr),Qf),a)}function oD(a){a.M||(a.Tc&&br(a),Zm(a.L,!0,!1))}function DI(a){if(a.J)for(;0<a.J.a.length;)ZG(a.V,Or(a.J,0))}function He(a){return Gl(a.a<a.c.a.length),a.b=a.a++,a.c.a[a.b]}function qI(a){EC(),$a.call(this,a),this.a="",this.b=a,this.a=""}function FI(a,y){MN.call(this,y.gg(),y.fg()&-6),ft(a),this.a=y}function HI(a,y){NN.call(this,y.gg(),y.fg()&-6),ft(a),this.a=y}function $I(a,y){this.a=a,this.d=y,this.c=(Uc(),lr(Date.now()))}function UI(a,y,k){B9(y,k,a.size()),this.c=a,this.a=y,this.b=k-y}function GI(a){Ql(a.c!=-1),a.d.removeAtIndex(a.c),a.b=a.c,a.c=-1}function dv(a){return Se(Ce(gt,1),yt,17,15,[a.db,a.bb,a.zb,a.xb])}function sD(a,y){a.t&&(a.c=!1,Ct((ut(),pt),new Aw(a,y,!1)))}function cD(a,y){a.j=y,a.a.style[Pt]=(y?(It(),$f):(It(),rx)).ie()}function uD(a,y){a.k.style[Bt]=y+(tt(),ke),a.u.style[Bt]=y+ke}function Ct(a,y){++a.a,a.b=da(a.b,[y,!1]),UA(a),QR(a,new P5(a))}function QI(a,y){if(y.$modCount!=a.$modCount)throw we(new _C)}function Dn(a,y,k){return k=vT(k),a.replace(new RegExp(y,"g"),k)}function JI(a,y){var k;return dn((k=a.$d(y),k||y.documentElement))}function YI(a,y){var k;return y=Vg(y),k=Dm(a.className||"",y),k!=-1}function We(a,y,k,z){var E;return E=ga(a,y),MA(k,E),E.f=z?8:0,E}function lD(a,y,k,z){var E;E=qe+k+Ye+z,Te(a.r,E,y),XN(a.a,y,k,z)}function Va(a){a.e||(a.e=Oe(ue),a.e.className=Ld,xe(a.d,a.e))}function za(a){a.a||(a.a=Oe(ue),a.a.className=Kd,xe(a.d,a.a))}function Ti(a){for(;a.d>0&&a.a[--a.d]==0;);a.a[a.d++]==0&&(a.e=0)}function fD(a,y){y?zt(a.Fc,"nogrid"):Ue(a.Fc,"nogrid"),a.Db&&_0(a)}function ZI(a,y){y?Ct((ut(),pt),new oh(a)):a.zc.focus()}function eu(a){mx=a,DU(a),a.F?Da(new fS(a),200,jr()):Tf(a,1),mx=null}function lf(a,y,k,z){xt(a.j,Se(Ce(Ke,1),ve,1,5,[he(y),he(k),z]))}function hD(){return Om(),Se(Ce(KQ,1),ve,98,0,[Kx,HW,FW,Wx])}function Ph(a,y){var k;return h9(y,HB(a,y==null?0:(k=oo(y),k|0)))}function dD(a){try{return!!a&&!!a.nodeType}catch{return!1}}function aD(a){if(!("stack"in a))try{throw a}catch{}return a}function bD(a,y){return y?(y.clear(),a&&y.addAll(a)):y=a,y}function pD(a,y){a.gb&&XR(a.gb),(fe(),y.Xc).style[uo]="1",a.gb=y}function eA(a,y){this.a=a,wg.call(this,a),jo(y,a.size()),this.b=y}function tA(a,y,k,z,E){this.g=a,this.b=y,this.c=z,this.d=E,this.a=k}function av(a){this.e=a,this.b=this.e.a.entries(),this.a=new Array}function bv(a,y){tU(a.a,y)?a.a.q=a.a.s.gd(a.a.j,a.a.n):a.a.q=null}function gD(a,y){(fe(),a.Xc).style[Pt]=(y?(It(),$f):(It(),Ud)).ie()}function wD(a,y,k){kH(a,$T(a),y),a$(a,y),a.r=KI(y,a.r),a.i=KI(k,a.i)}function vD(a,y,k,z){Je(a.a).u&&(a.a.f=y,a.a.g=null,KB(a.a.i,z,k))}function mD(a,y,k,z){xt(a.V,Se(Ce(Ke,1),ve,1,5,[y,he(k),he(z)]))}function yD(a,y){var k;if(k=PD(a,y),k==-1)throw we(new Ku);jF(a,k)}function Ea(a,y,k){var z;return z=Nt(a.e,qe+y+Ye+k),z?z.value:""}function _h(){_h=ge,oi=!1,Mp=!0,Np=!0,Pp=!0,Rp=!0}function ja(){ja=ge,Xu=new Dg("ALERT",0),qW=new Dg("STATUS",1)}function pv(){pv=ge,aX=new eS,hX=new i7,fX=new r7,dX=new Mk,bX=new XS}function gv(){gv=ge,eW=new f7,tW=new h7,nW=new q6,iW=new E7,rW=new z7}function nA(){nA=ge,AW=new o5(fn)}function Bh(a){a.v=!0,ra(a,a.w),rs(a,!0),Ct((ut(),pt),new hg(a))}function el(a,y){y?Sn((fe(),a.Xc),iy,!1):Sn((fe(),a.Xc),iy,!0)}function xD(a){a&&Sq((ut(),pt)),--Hd,a&&$d!=-1&&(CN($d),$d=-1)}function Oo(a){a.d&&(++a.b,a.c?EN(a.d.a):xN(a.d.a),a.d=null)}function Vi(a){return ye(a.compatMode,_s)?a.documentElement:a.body}function CD(a){return function(){return this.__gwt_resolve=kD,a.nd()}}function zr(a,y){return a.sheet.insertRule(y,a.sheet.cssRules.length)}function iA(a,y){this.a=a,this.f=new D5(this),this.c=y,this.b="click"}function wv(){Ov.call(this),this.a=null,new iA(this,this),this.b=null}function Oa(a){if(a==null)throw we(new ys("uri is null"));this.a=a}function vv(a){if(a==null)throw we(new ys("html is null"));this.a=a}function kD(){throw"A PotentialElement cannot be resolved twice."}function SD(a){var y=parseInt(a,10);return isNaN(y)?0:y}function mv(a){var y;return y=Nt(a.e,qe+a.rc+Ye+a.sc),y?y.value:""}function jn(a){return _h(),oi?new Ka(null):AT(oF(),a)}function Dh(a,y){var k;return k=y.length,ye(a.substr(a.length-k,k),y)}function ID(a){var y;M_.call(this,(y=a,cl("span",(be(),a).tagName),y))}function AD(a){kA.call(this,a),(fe(),this.Xc).className="gwt-TextBox"}function rA(a,y){if(y<0||y>=U1((fe(),a.Xc)).length)throw we(new Xl)}function TD(a,y){return a-(be(),Ie).Wd(y)+Ie.ae(y)+ko(y.ownerDocument)}function VD(){return lm(),Se(Ce(Op,1),ve,77,0,[Ex,Ox,zx,Vx,jx])}function Er(a,y,k){var z;z=k?(ht(k),k.k):null,yF(a.c,(ht(y),y.k),z)}function ff(a,y,k){this.n=a,this.c=y,this.k=k,this.d=Oe(ue),tw(this)}function yv(a){this.d=a,this.b=this.d.a.entries(),this.a=this.b.next()}function oA(a){a.e=!1,a.f=null,a.a=!1,a.b=!1,a.c=!0,a.d=null}function sA(a){a.a&&xe(a.d,a.a),a.e&&xe(a.d,a.e),a.j&&xe(a.d,a.j)}function cA(a,y,k,z){y>0&&(a.r=!0,a.i=new AI(a,k,z),Da(a.i,y,jr()))}function uA(a,y,k,z){var E;E=new a1,E.c=y,E.b=k,E.a=z,z.b=k.a=E,++a.b}function qh(a,y,k){var z;return k=vT(k),z=new RegExp(y),a.replace(z,k)}function zD(a,y,k){for(;k>=0;--k)if(es(y,a.a[k]))return k;return-1}function ED(a,y){var k;for(k=a.d-1;k>=0&&a.a[k]===y[k];k--);return k<0}function jD(a){var y,k;for(k=0,y=1;y<a.db-a.Sc;y++)k+=a.W[y-1];return k}function qt(a){var y=a.parentNode;return(!y||y.nodeType!=1)&&(y=null),y}function OD(){var a=ae.document.documentMode;return a||-1}function Xa(a){return a.k&&(a.backingJsObject!==dz&&a.Hd(),a.i=null),a}function jr(){return Date.now?Date.now():new Date().getTime()}function XD(a){return Qs(),function(){return w$(a,this,arguments)}}function lA(a){return!a.gwt_uid&&(a.gwt_uid=1),"gwt-uid-"+a.gwt_uid++}function fA(a,y){a.B&&!a.u.f&&(a.c=!1,Ct((ut(),pt),new Aw(a,y,!0)))}function xv(a,y,k,z){a.R&&((k!=a.V.rc||z!=a.V.sc)&&od(a),vD(a.R,y,k,z))}function WD(a){a.N&&Sw(a),e2(a.Q.a,a.Q.rc,a.U,a.Q.sc,a.V),a.o=!1,kT(a)}function KD(a){Lu(a.V,1,1),bd(a,a.i,a.O),e2(a,1,a.i,1,a.O),Ks(a,1,1,null)}function Cv(a,y){vt(a,Fi((Qr(),li).af((fe(),fe(),Yr(a.Xc))))+"-"+y,!1)}function hA(){var a;a=mi(iB),ae.addEventListener("hashchange",a,!1)}function LD(){var a;r_(cW),xp||(a=jn((ht(uW),uW.k)),DL(new e5(a)))}function dA(a){var y;return y=new st,St(y,a.sb),Os(y,$9(a)),new Fe(y)}function Wa(a){var y,k,z;return y=a&wn,k=a>>22&wn,z=a<0?Li:0,Zt(y,k,z)}function aA(a){var y,k;for(k=0,y=1;y<a.bb-a.ob;y++)k+=Gu(a.a,y);return k}function Or(a,y){var k;return k=(pn(y,a.a.length),a.a[y]),Wg(a.a,y,1),k}function bA(a,y){ON.call(this,y.gg(),y.fg()&-6),ft(a),this.a=a,this.b=y}function pA(){this.a={},this.f={},this.d={},this.e={},this.b={},this.c={}}function kv(a,y){this.b=", ",this.d=a,this.e=y,this.c=this.d+(""+this.e)}function Ka(a){_h(),!oi&&(this.c=a,this.e=!0,this.a=new st)}function Sv(a){Qg(this),ua(a>=0,"Initial capacity must not be negative")}function MD(a,y,k,z){return ft(a),ft(y),ft(k),ft(z),new P7(y,new v3)}function ND(a,y,k,z){xt(a.U,Se(Ce(Ke,1),ve,1,5,[he(y),he(k),he(z)]))}function La(a,y,k,z){var E;return E=Le(gt,yt,17,y,15,1),aT(E,a,y,k,z),E}function gA(a,y){return a.a?rt(a.a,a.b):a.a=new Bu(a.d),PN(a.a,y),a}function Xo(a,y){return y==0||a.e==0?a:y>0?U9(a,y):gV(a,-y)}function Ma(a,y){return y==0||a.e==0?a:y>0?gV(a,y):U9(a,-y)}function RD(a,y,k){if(a<0||y>k||y<a)throw we(new Tg(T2+a+wz+y+S2+k))}function PD(a,y){var k;for(k=0;k<a.c;++k)if(a.a[k]==y)return k;return-1}function _D(a,y,k){var z;return z=Nt(a.e,qe+y+Ye+k),z?z.formulaValue:""}function BD(a,y){lf(a.W,a.V.sc,a.V.rc,y),du(a,y,!0),Ar(a.V),vd(a.Q,!1)}function DD(a){var y,k;y=dn(a.V.zc),k=(a.V.zc.scrollTop||0)|0,nD(a.W,y,k)}function Na(a){var y;y=dq(a),y&&DA(a,y.nodeType!=1?null:y,fv(y))}function Iv(a){var y;y=a.O,y&&(a.w!=null&&y.od(a.w),a.A!=null&&y.qd(a.A))}function qD(a){return ye(Vf,typeof a)||i8(a,ae.java.lang.Number$impl)}function FD(a){pK(this,new hT(this,a)),(fe(),this.Xc).className="gwt-Image"}function Ra(){ID.call(this,Oe(ue)),(fe(),this.Xc).className="gwt-HTML"}function Av(a){Ia(a.a).length==0?js((fe(),a.Xc),!1):js((fe(),a.Xc),!0)}function HD(a,y){a.Uc==-1?Js((fe(),a.Xc),y|(a.Xc.__eventBits||0)):a.Uc|=y}function $D(a,y){return ft(y),a.c<a.d?(wk(a,y,a.c++),!0):!1}function UD(a){fe();try{return!!a&&!!a.__gwt_resolve}catch{return!1}}function GD(a){try{return a.selectionEnd-a.selectionStart}catch{return 0}}function wA(){xn(),ae.getSelection&&ae.getSelection().removeAllRanges()}function QD(){return tt(),Se(Ce(kQ,1),ve,34,0,[ZX,JX,HX,$X,YX,QX,UX,FX,GX])}function zi(a,y){Xi(),this.e=a,this.d=1,this.a=Se(Ce(gt,1),yt,17,15,[y])}function Le(a,y,k,z,E,j){var te;return te=NH(E,z),E!=10&&Se(Ce(a,j),y,k,E,te),te}function Pa(a,y,k,z){var E;return E=Le(gt,yt,17,y+1,15,1),wG(E,a,y,k,z),E}function JD(a,y,k,z){var E;z=(qk(),z||YW),E=a.slice(y,k),Lm(E,a,y,k,-y)}function YD(a,y,k){var z;return z=Nt(a.e,qe+y+Ye+k),z?z.originalValue:""}function vA(a,y,k){var z,E,j;for(j=0,E=y;E<=k;E++)z=Gu(a.a,E),j+=z;return j}function ZD(a,y){fe();var k;return k=fv(y),k?(DA(a,y,k),!0):!1}function mA(a,y){return XA(y)!=10&&Se(cu(y),y.ng,y.__elementTypeId$,XA(y),a),a}function yA(a){var y;return y=(be(),a).createElement("INPUT"),y.type="text",y}function xA(a){var y;y=pH(a),a.v=(be(),Ie).Wd(y),a.w=Ie.Xd(y),a.O=a.e,a.P=a.K}function tu(a){var y;return At(a)&&(y=0-a,!isNaN(y))?y:fr(ou(a))}function CA(a,y){var k;return k=(!a.K&&(a.K=On(a)),a.K).pb,!!k&&k.contains(y)}function kA(a){var y;zN.call(this,(y=a,y))}function SA(a){var y;this.b=new st,this.f=new st,kG(this,(y=a,D9(),gC(),y))}function IA(){Ov.call(this),this.a=new K5(this),this.j=new st,this.c=new Si}function eq(a){if(!a.bb)throw we(new mo("initWidget() is not called yet"))}function tq(a){if(!a.a||!a.c.O)throw we(new Ku);return a.a=!1,a.b=a.c.O}function Fh(a){var y;return a.e==0?-1:(y=Wv(a),(y<<5)+ro(a.a[y]))}function nq(a){var y;return y=Dn((ht(mn),mn.k),gr,"."),io(a.e,y).Ke().Ve()}function iq(a){var y;return Iq(),y=px.get(a),y?y.getAtIndex(y.size()-1):null}function rq(){Ci();var a;return Sp&&(a=new N3,_o&&Ws(_o,a)),null}function ei(){ei=ge;var a;a=BG((!Ht&&(Ht=new co),Ht)),ci(),vt(uu(),a,!0)}function Tv(a){Gh(a,a.rc,a.sc)||yu(a,a.rc,a.sc),Ct((ut(),pt),new gh(a,!0))}function AA(a,y){Gq(a,y.col,y.row),p_(a,y.height),l_(a,y.width),uq(a,y.dx,y.dy)}function oq(a,y,k){xt(a.v,Se(Ce(Ke,1),ve,1,5,[(qo(),!!y),he(k)]))}function TA(a,y,k,z){var E;E=new $I(y,k),E.e=z,ML(E,oi?null:a.c),K$(a,E)}function sq(a,y,k){var z;return va(a),z=new C3,z.a=y,a.a.hg(new N6(z,k)),z.a}function cq(a){if(a.b>=a.c.c)throw we(new Ku);return a.a=a.c.a[a.b],++a.b,a.a}function _a(a){return a.a.d!=a.c?qg(a.a,a.b.value[0]):a.b.value[1]}function et(a,y,k){for(;k<a.a.length;++k)if(es(y,a.a[k]))return k;return-1}function uq(a,y,k){(fe(),a.Xc).style[uE]=y+(tt(),ke),a.Xc.style[lE]=k+"pt"}function lq(a,y){a.F=y,a.F?Sn((fe(),a.Xc),EE,!0):Sn((fe(),a.Xc),EE,!1)}function rs(a,y){y?Ct((ut(),pt),new p5(a)):a.f&&(a.q=Is(a.e),Af(a))}function fq(a){a.t=!0,a.c=!0,a.B?a.B=!1:Qu(a.V)?a.b="":a.b=mv(a.V)}function Xr(a){var y;return QI(a.e,a),Gl(a.b),a.c=a.a,y=a.a.Ve(),a.b=_v(a),y}function hq(a){var y;return va(a),y=Le(_p,ve,17,0,15,1),j1(a.a,new hC(y)),y}function Vv(a){var y;return va(a),y=Le(gt,yt,17,0,15,1),j1(a.a,new dC(y)),y}function Ba(a){for(var y=a.firstChild;y&&y.nodeType!=1;)y=y.nextSibling;return y}function dq(a){var y;for(y=(be(),Ie).Sd(a);y&&!fv(y);)y=y.parentNode;return y}function VA(a){var y;return y=Oe(ue),sf(y,a),y.className="sheet-tabsheet-tab",y}function zA(){Tc(),yk.call(this,E_(ue)),(fe(),this.Xc).className="gwt-ListBox"}function aq(){try{return document.createEvent(Nz),!0}catch{return!1}}function zv(a,y,k,z,E){var j;return j=Ui(a,y),j?(Zu(j,k,z,E),!0):!1}function bq(a,y,k,z){a.V.rc==k&&a.V.sc==z&&(Ks(a,k,z,null),y!=null&&Vc(a.u,y))}function pq(a,y,k){lf(a.W,a.V.sc,a.V.rc,y),du(a,y,k),k&&(Ar(a.V),L0(a.Q,!1))}function Da(a,y,k){Nv(a),a.o=!0,a.p=!1,a.k=y,a.t=k,a.n=null,++a.r,bv(a.j,jr())}function EA(a,y){var k;return((k=a.$d(y),k||y.documentElement).scrollTop||0)|0}function gq(a,y){var k,z;for(z=UP(a.a[y]),k=new Fe(z);k.a<k.c.a.length;)He(k)}function os(a,y){this.e=y,this.a=m9(a),this.a<54?this.f=hv(a):this.c=Lo(a)}function jA(){this.c=new Ot,this.a=new tC,N_((!An&&(An=new Xs),An)),this.d=new wv}function hf(){hf=ge,cx=new L1("RTL",0),sx=new L1("LTR",1),Cp=new L1("DEFAULT",2)}function nu(){nu=ge,ux=Zt(wn,wn,524287),oW=Zt(0,0,Br),lx=Wa(1),Wa(2),fx=Wa(0)}function Hh(a,y,k,z,E){xt(a.g,Se(Ce(Ke,1),ve,1,5,[he(y),he(k),he(z),he(E)]))}function Ev(a,y,k,z,E){xt(a.k,Se(Ce(Ke,1),ve,1,5,[he(y),he(k),he(z),he(E)]))}function wq(a,y,k,z,E){xt(a.F,Se(Ce(Ke,1),ve,1,5,[he(y),he(k),he(z),he(E)]))}function vq(a,y,k,z,E){xt(a.P,Se(Ce(Ke,1),ve,1,5,[he(y),he(k),he(z),he(E)]))}function mq(a,y,k){var z;z=Dn((ht(mn),mn.k),gr,"."),yN(io(a.e,z).Ke().Ve(),y,k)}function OA(a,y){return y==(_c(),_c(),Qx)?a.toLocaleLowerCase():a.toLowerCase()}function yq(a,y){return y==(_c(),_c(),Qx)?a.toLocaleUpperCase():a.toUpperCase()}function xq(a,y){return a-(be(),Ie).Xd(y)+((y.scrollTop||0)|0)+So(y.ownerDocument)}function XA(a){return a.__elementTypeCategory$==null?10:a.__elementTypeCategory$}function tl(a){return a!=null&&(typeof a===F0||typeof a=="function")&&a.og!==Me}function Cq(a){return(ye(a.compatMode,_s)?a.documentElement:a.body).clientWidth|0}function kq(a){var y,k;if(a.c){k=null;do y=a.c,a.c=null,k=zm(y,k);while(a.c);a.c=k}}function Sq(a){var y,k;if(a.d){k=null;do y=a.d,a.d=null,k=zm(y,k);while(a.d);a.d=k}}function Iq(){var a;a=(Ci(),ae.location.search),(!px||!ye(vW,a))&&(px=AG(a),vW=a)}function Aq(a,y){Nm(Re(a.vf()),!0),a.q&&Oo(a.q),a.r&&(y.a&&ki(y.a),a.r=!1)}function WA(a,y,k){a.c=!1,k?O1(a.a,y):xo(a.a,y),a.d!=a.b&&(a.d=a.b,TH(a.a,a.b))}function $h(a,y){a.ef(!1),eu(a),y.Te(cr((fe(),a.Xc),pl),cr(a.Xc,Mf)),a.ef(!0)}function KA(a,y){var k,z;return z=G1((fe(),y.Xc)),k=om(a,y),k&&Jo(a.c,qt((be(),z))),k}function Tq(a,y){var k,z,E,j;for(ft(y),z=a.a,E=0,j=z.length;E<j;++E)k=z[E],y.Mf(k)}function Vq(a,y){var k=a.parentNode;k&&(k.insertBefore(y,a),k.removeChild(a))}function zq(a,y,k){var z;k.a?a.appendChild(y):(z=qt((be(),y)),z&&z.removeChild(y))}function LA(a,y,k){y&&!y.b||(Mo(a,y),k&&a.e&&a.Pe(),y&&a.c&&nm(a,y,!1))}function Wr(a,y){return y.e==0||a.e==0?Do:(No(),A0(a,y))}function Eq(a){var y;return a?(y=Ml(a.mg),Zs(y,cw(y,hs(46))+1)):"(null)"}function jq(a){return mm(a,(nu(),fx))<0?-ER(ou(a)):a.l+a.m*ui+a.h*Rr}function Uh(a,y,k){return y<0&&(y=0),(k<0||k>a.length)&&(k=a.length),a.substr(y,k-y)}function Gh(a,y,k){return(y<=a.ob||y>=cd(a)&&y<=xf(a))&&(k<=a.Sc||k<=id(a)&&k>=vf(a))}function Ft(a,y){return a.v&&et(a.v,he(y),0)!=-1?0:y>0&&a.g.length>=y?a.g[y-1]:a.q}function Oq(a){return(ye(a.compatMode,_s)?a.documentElement:a.body).clientHeight|0}function Xq(){hk();for(var a=wp,y=0;y<arguments.length;y++)a.push(arguments[y])}function Wq(a){if(a==null)throw we(new ys("encodedURLComponent cannot be null"))}function qa(a,y,k,z){xt(a.i,Se(Ce(Ke,1),ve,1,5,[he(y),he(k),(qo(),!!z)]))}function Kq(a,y){var k;for(ls(a),k=0;k<y.a.length;k++)zr(a,(pn(k,y.a.length),y.a[k]))}function Lq(a,y){var k;return k=y.c,y.a.b=y.b,y.b.a=y.a,y.a=y.b=null,y.c=null,--a.b,k}function Fa(a,y){var k;return k=(ht(y),y.k),O_(a.J,k)||(a.J[k]=CT(y)),a.J[k]}function Mq(a,y){var k;return k=(be(),Ie).Ud(y),AB(k)?Io((fe(),a.Xc),k):!1}function Nq(a,y,k){var z;return z=Nt(a.e,qe+y+Ye+k),z?z.locked:pR(a.a,y)&&gR(a.a,k)}function jv(a){return a.a<54?a.f<0?-1:a.f>0?1:0:(!a.c&&(a.c=ss(a.f)),a.c).e}function Rq(a){var y;a.b&&(y=a.b,a.b=null,!a.g&&(a.g=[]),zm(y,a.g)),a.g&&(a.g=_U(a.g))}function MA(a,y){if(a){y.j=a;var k=hB(y);if(!k){Bd[a]=[y];return}k.mg=y}}function ro(a){var y,k;if(a==0)return 32;for(k=0,y=1;!(y&a);y<<=1)++k;return k}function iu(a,y){var k,z,E;return E=a.u[y],z=im(E),k=new Dl(E),z+=um(k)[1],z+=um(k)[3],z}function nl(a,y){var k,z;for(ft(y),z=y.Wf().Ke();z.Ue();)k=z.Ve(),a.put(k.cg(),k.dg())}function NA(a,y,k,z,E){var j,te;for(n2(a),te=y;te<=k;te++)w0(a,te);for(j=z;j<=E;j++)g0(a,j)}function RA(a,y,k,z,E){var j;j=$V(a,y,k,!0),nz(a,z,E,!0)&&(j=!0),j&&(s2(a),kf(a))}function Pq(a,y,k,z,E,j){xt(a.N,Se(Ce(Ke,1),ve,1,5,[rI(y),he(k),he(z),he(E),he(j)]))}function PA(a,y){a.f=y,y?Sn((fe(),a.Xc),"inversed",!0):Sn((fe(),a.Xc),"inversed",!1)}function _q(a,y){a.k.style[Bt]=y+(tt(),ke),a.d.style[Bt]=y+ke,a.j.style[Bt]=y+ke}function Bq(a,y){typeof window===F0&&typeof window.$gwt===F0&&(window.$gwt[a]=y)}function Dq(a){var y=/function(?:\s+([\w$]+))?\s*\(/,k=y.exec(a);return k&&k[1]||H0}function Ha(a){var y;return y=qe+a.rc+Ye+a.sc,rd(a,y)?Ui(a,y):Rt(a,a.rc,a.sc)}function _A(a){var y;return y=Le(gt,yt,17,a.d,15,1),hl(a.a,0,y,0,a.d),new kn(a.e,a.d,y)}function Gt(a){var y,k;return k=zs((fe(),a.Xc),Nf),y=(ft(k),k),ye("",k)?null:y}function qq(a,y){var k;k=zs((fe(),y.Xc),Xd),ye(Td,k)&&(a.a=new h6(a,y),Ct((ut(),pt),a.a))}function Fq(a){var y,k;k=iq("logLevel"),y=k==null?null:$U(k),y?Zg(a,y):Zg(a,(Nn(),ih))}function Hq(a){var y=[];for(var k in a)Object.hasOwnProperty.call(a,k)&&y.push(k);return y}function Kr(a){return!a.target||a.target.shadowRoot?a.composedPath()[0]:a.target}function BA(a){return a.ownerDocument.defaultView.getComputedStyle(a,"").direction=="rtl"}function $q(a){return((ye(a.compatMode,_s)?a.documentElement:a.body).scrollWidth||0)|0}function Uq(a){return((ye(a.compatMode,_s)?a.documentElement:a.body).scrollHeight||0)|0}function js(a,y){a.style.display=y?"":tn,y?a.removeAttribute(E2):a.setAttribute(E2,"true")}function Gq(a,y,k){var z;a.a=y,a.b=k,(fe(),a.Xc).className=cE,z=qe+y+Ye+k,Sn(a.Xc,z,!0)}function Qq(a,y,k){var z,E,j;for(z=0,E=0;E<k;E++)j=y[E],a[E]=j<<1|z,z=j>>>31;z!=0&&(a[k]=z)}function DA(a,y,k){fe(),y==ho&&Hn((be(),a).type)==8192&&(ho=null),k.wd(a)}function qA(a){fe();var y;return y=f$(kp,a),!y&&a&&((be(),a).stopPropagation(),Ie.Vd(a)),y}function Jq(a){var y;return y=(fe(),a.Xc).selectedIndex,y==-1?null:(rA(a,y),U1(a.Xc)[y].value)}function FA(){var a;return a=(Ci(),pW).Je(),a==null||a.length==0?"":J_(a.substr(1))}function Yq(){var a=ae.onresize;ae.onresize=mi(function(y){try{TF()}finally{a&&a(y)}})}function $a(a){$1(this),Xa(this),this.backingJsObject=a,pV(this,a),this.f=a==null?Ro:wi(a)}function Ov(){this.J={},this.s=[],Hu((!this.F&&(this.F=new Pu(this)),this.F),(RC(),KW),this)}function il(){il=ge,Ep=new P1("LEFT",0),kx=new P1("RIGHT",1),Cx=new P1("MIDDLE",2)}function Xv(){Xv=ge,DW=new B1("TEXT",0),Ax=new B1("PREFORMATTED",1),BW=new B1("HTML",2)}function Zq(a){if(ft(a),a.length==0)throw we(new yo("Zero length BigInteger"));rG(this,a)}function Wv(a){var y;if(a.b==-2){if(a.e==0)y=-1;else for(y=0;a.a[y]==0;y++);a.b=y}return a.b}function Ua(a,y){var k,z,E;for(ft(y),k=!1,E=y.Ke();E.Ue();)z=E.Ve(),k=k|a.add(z);return k}function Fi(a){var y,k;return y=a.className||"",k=F1(y,hs(32)),k>=0?y.substr(0,k):y}function eF(a,y,k){return y<=a.ob?k<=a.Sc?a.Nc:a.c:k<=a.Sc?a.Pc:a.zc}function tF(a){return a==0?_x[0]:a>=0&&a<c1.length?c1[a]:new os(0,a)}function lr(a){return zf<a&&a<Rr?a<0?ae.Math.ceil(a):ae.Math.floor(a):fr(EU(a))}function fr(a){var y;return y=a.h,y==0?a.l+a.m*ui:y==Li?a.l+a.m*ui-Rr:a}function nF(a){return vr?a.q[Ky]?cr(a.q,Ky):0:(a.q.scrollTop||0)|0}function iF(a){a.w&&(Sr(a.w.a),a.w=null),a.v&&(Sr(a.v.a),a.v=null),a.u&&(Sr(a.u.a),a.u=null)}function Kv(a,y,k){lf(a.W,a.V.sc,a.V.rc,y),du(a,y,!0),Ar(a.V),k?u2(a.Q,!1):vd(a.Q,!1)}function Lv(a,y,k){lf(a.W,a.V.sc,a.V.rc,y),du(a,y,!0),Ar(a.V),k?l2(a.Q,!1):L0(a.Q,!1)}function HA(a,y,k,z){xt(a.u,Se(Ce(Ke,1),ve,1,5,[(qo(),!!y),he(k),!!z]))}function df(a,y){Im(new lh(Se(Ce(gt,2),ve,22,0,[a]))),Im(new lh(Se(Ce(gt,2),ve,22,0,[y])))}function Mv(a,y){var k,z;for(ft(y),z=new hr(new or(a).a);z.b;)k=Xr(z),y.zf(k.cg(),k.dg())}function rF(a,y){var k;t2(y.a,Re(a.vf())),y.a&&ki(y.a),Yo(y.a),(k=a,CS(y.a),k).pf(sK).pg(),wA()}function Ga(a){var y,k;for(k=new Fe(a);k.a<k.c.a.length;)y=He(k),lt(y.d);a.a=Le(Ke,ve,1,0,5,1)}function ru(){this.d=Le(gt,yt,17,4,15,1),this.a=Le(gt,yt,17,4,15,1),this.c=Le(gt,yt,17,4,15,1)}function oF(){var a;return Lp||(Lp=new qC,a=new Ka(""),Zg(a,(Nn(),ih)),WP(Lp,a)),Lp}function $A(a){Mp&&nd(a,(Nn(),Jx),"invalid column index, halting parse",null)}function Nv(a){a.o&&(a.u=a.p,a.n=null,a.o=!1,a.p=!1,a.q&&(a.q.hd(),a.q=null),a.bd())}function UA(a){a.j||(a.j=!0,!a.f&&(a.f=new t5(a)),Qh(a.f,1),!a.i&&(a.i=new n5(a)),Qh(a.i,50))}function sF(a){xn();var y,k;for(k=a.getElementsByTagName("img"),y=0;y<k.length;y++)Js(k[y],gl)}function Qa(a){return xn(),(be(),a).type.indexOf(Gn)!=-1?As(a.changedTouches[0]):Dt(a.clientX||0)}function Ja(a){return xn(),(be(),a).type.indexOf(Gn)!=-1?Ts(a.changedTouches[0]):Dt(a.clientY||0)}function GA(){return xn(),ae.document.activeElement?ae.document.activeElement:null}function QA(a){var y=a.ownerDocument.defaultView.getComputedStyle(a,null);return y.direction=="rtl"}function cF(){Tc();var a;return a=V_(ue),a.getContext?new xk(a):null}function uF(a){return a==bt(a)?tF(bt(a)):a>=0?new os(0,Ki):new os(0,xu)}function JA(a){return oi?Le(sW,Hj,110,0,0,1):td(a.a,Le(sW,Hj,110,a.a.a.length,0,1))}function lF(a){return a==null?!1:a.$implements__java_lang_Cloneable||Array.isArray(a)}function af(a,y){if(a.O)throw we(new mo("SimplePanel can only contain one child widget"));a.Oe(y)}function Qh(a,y){ut();function k(){var z=mi(EM)(a);z&&ae.setTimeout(k,y)}ae.setTimeout(k,y)}function Ei(a,y,k,z,E){var j;rd(a,qe+k+Ye+E)&&(j=ql(a.a,k,E),k=j.col2,E=j.row2),xV(a.yc,y,k,z,E)}function Mn(a){var y,k,z,E;return E=a,z=0,E<0&&(E+=Rr,z=Li),k=bt(E/ui),y=bt(E-k*ui),Zt(y,k,z)}function YA(a,y){var k,z;for(k=0,z=a.size();k<z;++k)if(es(y,a.getAtIndex(k)))return k;return-1}function ZA(a,y){var k,z;for(z=y.Ke();z.Ue();)if(k=z.Ve(),Jw(a,k.dg()))return!0;return!1}function Rv(a){var y;for(y="";a>0;)y=String.fromCharCode(65+(a-1)%26&Rs)+y,a=(a-1)/26|0;return y}function Xt(a){var y;return ze(a,20)?a:(y=a&&a.__java$exception,y||(y=new qI(a),LC(y)),y)}function e9(a,y){var k;return k=a.a.get(y),k===void 0?++a.d:(tP(a.a,y),--a.c,Lh(a.b)),k}function Pv(a){var y;y=Nl(a.j),y?$h(a.e,a.a):Ct((ut(),pt),new y5(a)),a.d&&qL(a.g,Ea(a.d,a.b,a.k))}function Hi(a){return(fe(),a.Xc).style.display!=tn||!!a.a&&rn(a.a)||!!a.X&&rn(a.X)||!!a.W&&rn(a.W)}function bf(a,y,k){return k<=a.Sc&&(y>=a.bb&&y<=a.xb||y<=a.ob)||y<=a.ob&&(k>=a.db&&k<=a.zb||k<=a.Sc)}function fF(a,y){var k,z,E;return k=a.l+y.l,z=a.m+y.m+(k>>22),E=a.h+y.h+(z>>22),Zt(k&wn,z&wn,E&Li)}function t9(a,y){var k,z,E;return k=a.l-y.l,z=a.m-y.m+(k>>22),E=a.h-y.h+(z>>22),Zt(k&wn,z&wn,E&Li)}function Wo(a,y,k){var z,E;if(a==null||a.length<k-1)return 0;for(E=0,z=y;z<k;z++)E+=a[z-1];return E}function Se(a,y,k,z,E){return E.mg=a,E.ng=y,E.og=Me,E.__elementTypeId$=k,E.__elementTypeCategory$=z,E}function Jh(a,y){var k;return k=et(a,y,0),k==-1?!1:(pn(k,a.a.length),Wg(a.a,k,1),!0)}function _v(a){return a.a.Ue()?!0:a.a!=a.d?!1:(a.a=new av(a.e.a),a.a.Ue())}function n9(a){ua(a>=0,"Negative initial capacity"),ua(!0,"Non-positive load factor"),Mt(this)}function i9(a){this.a=a,SA.call(this,!0),Xn(this,this,(hw(),hw(),Zd)),Xn(this,this,(zw(),zw(),Yd))}function r9(a){ov(),this.s=Le(gt,yt,17,3,15,1),this.b=Le(_p,ve,17,3,15,1),this.p=new Oh(new lh(a))}function hF(a,y){if(!a)throw we(new Ho(jz));if(y=so(y),y.length==0)throw we(new $o(Oz));uU(a,y)}function dF(a){var y;return y=a.text,(be(),a).hasAttribute(qz)&&y.length>1&&(y=Zo(y,1,y.length-1)),y}function o9(a){zn();var y,k,z;for(z=0,k=a.Ke();k.Ue();)y=k.Ve(),z=z+(y!=null?oo(y):0),z=z|0;return z}function aF(a,y){var k,z,E,j,te;for(E=y,j=0,te=E.length;j<te;++j)z=E[j],k=VA(z),xe(a.c,k),XM(a.u,k);pu(a)}function bF(a,y){var k,z,E,j,te,ne;for(ne=y.c,a.a[ne]=y,te=y.b,z=te,E=0,j=z.length;E<j;++E)k=z[E],a.d[k]=ne}function pF(a,y,k,z,E,j,te){xt(a.f,Se(Ce(Ke,1),ve,1,5,[he(y),he(k),he(z),he(E),he(j),he(te)]))}function gF(a,y){a.Z=y,y?zt(a.Fc,"noheaders"):Ue(a.Fc,"noheaders"),a.Db&&(kf(a),_0(a),E0(a),z0(a))}function s9(a){a.c==0?jP(a.b,a.a):a.c==1?OP(a.b,a.a):EP(a.b,a.a),Pn(lv(a.g.a.a.D),!1),ZI(a.d.V,!0)}function wF(a,y){var k,z;for(z=a.c.Ke();z.Ue();)k=z.Ve(),y.contains(k)||GL((!a.C&&(a.C=new un),a.C),k)}function vF(a){zn();var y,k,z;for(z=1,k=a.Ke();k.Ue();)y=k.Ve(),z=31*z+(y!=null?oo(y):0),z=z|0;return z}function ou(a){var y,k,z;return y=~a.l+1&wn,k=~a.m+(y==0?1:0)&wn,z=~a.h+(y==0&&k==0?1:0)&Li,Zt(y,k,z)}function Ya(a){var y,k,z;y=~a.l+1&wn,k=~a.m+(y==0?1:0)&wn,z=~a.h+(y==0&&k==0?1:0)&Li,a.l=y,a.m=k,a.h=z}function c9(a){var y,k;return k=wu(a.h),k==32?(y=wu(a.m),y==32?wu(a.l)+32:y+20-10):k-12}function Os(a,y){var k,z;return k=y.toArray(),z=k.length,z==0?!1:(Tw(a.a,a.a.length,k),!0)}function mF(a){return ye(typeof a,xd)?!0:a!=null&&a.$implements__java_lang_CharSequence}function ji(a){Sf();var y;y=!qA(a),!(y||!Yf)&&ZD(a,Yf)&&(be(),a).stopPropagation()}function rl(a,y){js((fe(),a.Xc),y),y?a.Xc.style[qr]="":a.Xc.style[qr]=(ts(),dt)}function su(a,y){a.i.style[Pt]=(y?(It(),$f):(It(),Ud)).ie(),a.g.style[Pt]=(y?(It(),$f):(It(),Ud)).ie()}function yF(a,y,k){var z=a[k];if(z!==void 0){var E=function(){};E.prototype=z,a[y]=new E}else a[y]={}}function pf(a,y,k){var z;for(z=k-1;z>=0&&a[z]===y[z];z--);return z<0?0:zk(Ve(a[z],Xe),Ve(y[z],Xe))?-1:1}function xF(a,y,k,z,E){var j;return j=Qm(a,y),k&&Ya(j),E&&(a=KH(a,y),z?wr=ou(a):wr=Zt(a.l,a.m,a.h)),j}function Bv(a,y){if(a.O!=y)return!1;try{qn(y,null)}finally{Jo(a.Ne(),(fe(),y.Xc)),a.O=null}return!0}function u9(a,y,k){var z;return xe(a.zc,a.hb),ah(a.hb,"cell "+y),xo(a.hb,k),z=a.hb.clientWidth|0,lt(a.hb),z}function CF(a,y){a.style[vn]=y.b+(tt(),ke),a.style[fn]=y.c+ke,a.style[mt]=y.d+ke,a.style[Bt]=y.a+ke}function Yh(a){return fe(),$l(an),!kl&&(kl=new xr),kp||(kp=new aw(null,!0),tr=new d4),Hu(kp,kl,a)}function Za(){Za=ge,jp=new _1("DISABLED",0),PW=new _1("MANUAL",1),RW=new _1("AUTOMATIC",2)}function l9(){l9=ge,new lg((Kh(),"center")),SW=new lg(vn),IW=SW,kW=IW}function Dv(){this.k=null,this.i=null,this.g=null,this.d=null,this.b=null,this.j=null,this.a=null}function hr(a){this.e=a,this.d=new yv(this.e.b),this.a=this.d,this.b=_v(this),this.$modCount=a.$modCount}function Xs(){this.a={},this.d={},this.c=new pA,this.b=new st,bF(this,new fI(Se(Ce(ct,1),Mi,2,6,[NE])))}function kF(){return function(a){var y=this.parentNode;y.onfocus&&ae.setTimeout(function(){y.focus()},0)}}function cu(a){return Qo(a)?ct:vh(a)?aQ:wh(a)?Hs:Bw(a)||Lw(a)?a.mg:a.mg||Array.isArray(a)&&Ce(yp,1)||yp}function qv(a,y){var k,z;for(yI(a),z=new Fe(a.s);z.a<z.c.a.length;)k=He(z),s9(k);a.s.a=Le(Ke,ve,1,0,5,1)}function SF(a){var y,k;if(a.a)try{for(k=new Fe(a.a);k.a<k.c.a.length;)y=He(k),y.Kd()}finally{a.a=null}}function IF(a,y,k){a.b?(a.a=new r9(Se(Ce(yp,1),ve,0,2,[])),Xn(y,a,(qu(),qu(),Cl))):a.a=null,D$(a,k)}function AF(){return It(),Se(Ce(vQ,1),ve,23,0,[$f,Ud,wX,rx,mX,yX,xX,CX,kX,AX,VX,TX,EX,SX,IX,zX,gX,pX,vX])}function Fv(){Fv=ge,Jj=new N1("CONCURRENT",0),Qy=new N1("IDENTITY_FINISH",1),Yj=new N1("UNORDERED",2)}function tt(){tt=ge,ZX=new $k,JX=new D6,HX=new Uk,$X=new Gk,YX=new Qk,QX=new Jk,UX=new Yk,FX=new Zk,GX=new e6}function TF(){Ci();var a,y;ax&&(y=Cq(ue),a=Oq(ue),(wW!=y||gW!=a)&&(wW=y,gW=a,uP((!_o&&(_o=new E1),_o))))}function en(a,y){var k;return At(a)&&At(y)&&(k=a-y,!isNaN(k))?k:mm(At(a)?Mn(a):a,At(y)?Mn(y):y)}function f9(a,y){var k,z;for(ft(y),z=y.Ke();z.Ue();)if(k=z.Ve(),!a.contains(k))return!1;return!0}function h9(a,y){var k,z,E,j;for(z=y,E=0,j=z.length;E<j;++E)if(k=z[E],Jw(a,k.cg()))return k;return null}function VF(a,y){var k,z;return a.S?(z=Kr(y),k=Re(a.S),(be(),Ie).ce(k,z)||!!qt(k)&&Io(qt(k),z)):!1}function d9(a,y){var k,z;a.u.f&&(ow(a.u),eT(a.V,!1)),k=dn(a.V.zc),z=(a.V.zc.scrollTop||0)|0,ND(a.W,y,k,z)}function zF(a){var y,k,z;for(z=1;z<=a.Sc;z++)for(k=1;k<=a.ob;k++)y=new ff(a,k,z),xe(a.Nc,y.d),St(a.Mc,y)}function EF(a,y){a.Tc&&(fe(),a.Xc.__listener=null),a.Xc&&Vq(a.Xc,y),a.Xc=y,a.Tc&&(fe(),dk(a.Xc,a))}function Hv(a,y){if(y<=0)throw we(new $o("must be positive"));a.d&&Oo(a),a.c=!0,a.d=he(iP(E8(a,a.b),y))}function jF(a,y){var k;if(y<0||y>=a.c)throw we(new Xl);for(--a.c,k=y;k<a.c;++k)a.a[k]=a.a[k+1];a.a[a.c]=null}function $v(a,y){var k,z;for(z=U1(JM(a.B)).length,k=0;k<z;k++)if(ye(v_(a.B,k),y)){K6(a.B,k);return}K6(a.B,0)}function a9(a,y){a.R||(Ii(a.sb,y),a._&&(Gh(a,a.rc,a.sc)||yu(a,a.rc,a.sc),Ct((ut(),pt),new gh(a,!1))))}function b9(a,y){y!=a.O&&(y&&br(y),a.O&&Bv(a,a.O),a.O=y,y&&(fe(),xe(a.Ne(),Vr(Re(a.O))),qn(y,a)))}function p9(a,y){a.b=y,a.a.style[ot]=(y?(at(),Zi):(at(),er)).ie(),a.d.style[ot]=(y?(at(),Zi):(at(),er)).ie()}function g9(a,y){a.n=y,a.k.style[ot]=(y?(at(),Zi):(at(),er)).ie(),a.p.style[ot]=(y?(at(),Zi):(at(),er)).ie()}function w9(a,y){a.v=y,a.u.style[ot]=(y?(at(),Zi):(at(),er)).ie(),a.A.style[ot]=(y?(at(),Zi):(at(),er)).ie()}function v9(a,y){a.H=y,a.G.style[ot]=(y?(at(),Zi):(at(),er)).ie(),a.J.style[ot]=(y?(at(),Zi):(at(),er)).ie()}function m9(a){var y;return en(a,0)<0&&(a=fr(c_(At(a)?Mn(a):a))),y=_e(Bn(a,32)),64-(y!=0?wu(y):wu(_e(a))+32)}function y9(a){var y;return a!=null&&(y=a.__java$exception,y)?y:i8(a,TypeError)?new UC(a):new $a(a)}function Uv(){WR.call(this,(!ex&&(ex=ae.requestAnimationFrame&&ae.cancelAnimationFrame?new Vl:new T8),ex))}function OF(a,y){var k=mi(function(){var E=jr();a.fd(E)}),z=ae.requestAnimationFrame(k,y);return{id:z}}function x9(a,y,k){var z,E,j,te;for(te=0,z=y;z<=k;z++)E=ha(a.a,z),j=Z$(Jv(E*a.Lb/72)),te+=j,a.W[z-1]=j;return te}function XF(a,y,k){var z;a.i?(z=(fe(),Dw(ue)),vR(a.d,z,y),xe(z,Vr(k))):(z=Ug(a.d),fe(),an.Ee(z,Vr(k),y))}function C9(a){var y,k;for(k=new hr(new or(a.Kb).a);k.b;)y=Xr(k),UT(a,y.cg(),y.dg()),LT(a,y.cg(),y.dg())}function WF(a){a.J&&(Sr(a.J.a),a.J=null),a.D&&(Sr(a.D.a),a.D=null),a.M&&(a.J=Yh(new u5(a)),a.D=kN(new l5(a)))}function KF(a,y){if(0>a)throw we(new $o("fromIndex: 0 > toIndex: "+a));if(a>y)throw we(new Ag(gz+a+S2+y))}function Sn(a,y,k){if(!a)throw we(new Ho(jz));if(y=so(y),y.length==0)throw we(new $o(Oz));k?Ue(a,y):zt(a,y)}function gn(a,y){if(y<0)throw we(new $o("must be non-negative"));a.d&&Oo(a),a.c=!1,a.d=he(YR(E8(a,a.b),y))}function Gv(a,y){var k,z;return z=Nt(Je(a.a).c,y),k=u0(z,zs(a.a.e,"appId")),new f0("custom-editor-"+z,k,a.a.e)}function Vt(a,y){var k;return At(a)&&At(y)&&(k=a+y,zf<k&&k<Rr)?k:fr(fF(At(a)?Mn(a):a,At(y)?Mn(y):y))}function Oi(a,y){var k;return At(a)&&At(y)&&(k=a*y,zf<k&&k<Rr)?k:fr(RG(At(a)?Mn(a):a,At(y)?Mn(y):y))}function cn(a,y){var k;return At(a)&&At(y)&&(k=a-y,zf<k&&k<Rr)?k:fr(t9(At(a)?Mn(a):a,At(y)?Mn(y):y))}function ss(a){return Xi(),a<0?a!=-1?new am(-1,-a):u1:a<=10?Ux[bt(a)]:new am(1,a)}function k9(a){var y;if(a.c!=0)return a.c;for(y=0;y<a.a.length;y++)a.c=a.c*33+(a.a[y]&-1);return a.c=a.c*a.e,a.c}function LF(a){var y,k,z,E;for(y=a.childNodes,E=new st,k=0;k<y.length;k++)z=y[k],z.nodeType==1&&St(E,z);return E}function Qv(a){var y,k;return y=jv(a),k=a.a-a.e/pp,k<-149||y==0?y*=0:k>129?y*=1/0:y=Cf(FV(a)),y}function S9(a){var y=[];for(var k in a)Object.prototype.hasOwnProperty.call(a,k)&&k!="$H"&&y.push(k);return y}function MF(a,y){var k,z;for(z=new Fe(a.f);z.a<z.c.a.length;)if(k=He(z),Io((fe(),k.Xc),y))return k;return null}function NF(a,y){var k,z;k=y.b,z=y.k,Eo(a.Cc,qe+k+Ye+z),gd(a,y),k>=a.bb&&k<=a.xb&&z>=a.db&&z<=a.zb&&rw(Rt(a,k,z))}function e0(a,y){xn();var k=ae.document.elementFromPoint(a,y);return k!=null&&k.nodeType==3&&(k=k.parentNode),k}function I9(a,y,k){var z,E;return E=no(a.d,y),E||(E=new Ot,Zn(a.d,y,E)),z=E.get(k),z||(z=new st,E.put(k,z)),z}function A9(a){var y,k;return y=IH(a),k=y.Ef(null,Se(Ce(Ke,1),ve,1,5,[])),ze(k,99)&&v$((!An&&(An=new Xs),An),a.a),k}function RF(a,y,k,z,E,j){var te;xt(a.q,Se(Ce(Ke,1),ve,1,5,[(te=[],Mv(y,new rC(te)),te),he(k),he(z),he(E),he(j)]))}function PF(a,y,k,z,E,j,te){var ne;for(ne=k;j<te;)ne>=z||y<k&&_w(a[y],a[ne])<=0?E[j++]=a[y++]:E[j++]=a[ne++]}function _F(a,y,k){var z,E,j;for(z=y+1;z<k;++z)for(E=z;E>y&&_w(a[E-1],a[E])>0;--E)j=a[E],a[E]=a[E-1],a[E-1]=j}function BF(a,y,k,z,E){y==0||z==0||(y==1?E[z]=l0(E,k,z,a[0]):z==1?E[y]=l0(E,a,y,k[0]):eU(a,k,E,y,z))}function T9(a,y){var k,z,E;z=(fe(),Dw(ue)),k=(E=W8(ue),bR(E,a.a),HM(E,a.b),E),xe(z,Vr(k)),xe(a.c,Vr(z)),Rh(a,y,k)}function DF(a){var y;!Qu(a.V)&&!a.e&&a.p&&M7(a.p,Hl(a.V))&&(y=Gv(a.p,Hl(a.V)),a.o=!0,sh(a.u,!1),Wm(a.V,y))}function dr(a,y){return Qo(a)?ye(a,y):vh(a)?l8(a,y):wh(a)?(ft(a),Lt(a)===Lt(y)):Bw(a)?a.Yc(y):Lw(a)?F6(a,y):En(a,y)}function qF(a,y){a.D=y,a.D?((fe(),a.Xc).className||"").indexOf(hy)!=-1||Sn(a.Xc,hy,!0):Sn((fe(),a.Xc),hy,!1)}function V9(a,y,k){var z,E;return E=no(a.d,y),!E||(z=E.get(k),!z)?(zn(),zn(),Dd):z}function z9(a){var y;return y=zs(a,"dir"),cl("rtl",y)?(hf(),cx):cl("ltr",y)?(hf(),sx):(hf(),Cp)}function E9(a){var y,k;return a==null||a.length==0||ye(Ro,a)?null:(k=dm(a),y=new Cg,Object.assign(y,k),y)}function he(a){var y,k;return a>-129&&a<128?(y=a+128,k=(V8(),Nx)[y],!k&&(k=Nx[y]=new p1(a)),k):new p1(a)}function Jv(a){if(w2(),!isNaN(a)&&!isFinite(a)||isNaN(a))throw we(new yo("Infinite or NaN"));return new IC(""+a)}function FF(a,y){var k,z,E,j,te;for(k=new Bi,E=y,j=0,te=E.length;j<te;++j)z=E[j],rt(rt(k,a.ld(z))," ");return so(k.a)}function HF(a){xn();var y,k;return k=H9(a),(ei(),!Ht&&(Ht=new co),ei(),Ht).a.j&&(y=AU(a),y>k&&y<=k+1)?y:k}function $F(a){xn();var y,k;return k=im(a),(ei(),!Ht&&(Ht=new co),ei(),Ht).a.j&&(y=IU(a),y>k&&y<=k+1)?y:k}function uu(){ci();var a;return a=no(Eu,null),a||(Mu(Eu)==0&&uI(new Dp),a=new Cw,Zn(Eu,null,a),Ut(Sl,a),a)}function Yv(a,y){return a<y?-1:a>y?1:a==y?a==0?Yv(1/a,1/y):0:isNaN(a)?isNaN(y)?0:1:-1}function Zh(a){if(a.b)Zh(a.b);else if(a.c)throw we(new mo("Stream already terminated, can't be modified or used"))}function UF(a){if(a<xu)throw we(new Jr("Overflow"));if(a>Ki)throw we(new Jr("Underflow"));return bt(a)}function GF(a){dU(a),Xw((!a.C&&(a.C=new un),a.C),!0),a.c&&a.c.clear(),a.j.a=Le(Ke,ve,1,0,5,1),a.b&&Sr(a.b.a)}function lu(a){var y;return y=ko(ue),xn(),(be(),a).type.indexOf(Gn)!=-1?As(a.changedTouches[0])+y:Dt(a.clientX||0)+y}function fu(a){var y;return y=So(ue),xn(),(be(),a).type.indexOf(Gn)!=-1?Ts(a.changedTouches[0])+y:Dt(a.clientY||0)+y}function j9(a,y,k){var z;a.H=y,a.N=k,y-=yS(ue),k-=xS(ue),z=(fe(),a.Xc),z.style[vn]=y+(tt(),ke),z.style[fn]=k+ke}function O9(a,y){y!=null&&y.length!=0?(fe(),a.Xc).style[Bt]=y:(fe(),a.Xc).style[Bt]="400.0px"}function X9(a,y){y!=null&&y.length!=0?(fe(),a.Xc).style[mt]=y:(fe(),a.Xc).style[mt]="500.0px"}function Zv(a,y){var k,z,E;for(z=new Fe(a.g);z.a<z.c.a.length;)k=He(z),E=k.style,E[$2]="translate3d(0px,"+y+"px,0px)"}function W9(a,y,k){var z;z=Dn((ht(y),y.k),gr,"."),!a.I&&(a.I={}),a.I[z]==null&&(a.I[z]=new st),a.I[z].add(k)}function QF(a,y,k,z,E){var j;j=ti(a.I,z,E,y,k),j.col1==y&&j.col2==k&&j.row1==z&&j.row2==E&&(vq(a.W,z,y,E,k),gn(a.s,200))}function K9(a,y,k,z){a.c=y,a.k=k,a.b=z?z.cellStyle:"cs0",a.o=z?z.value:null,a.f=!!z&&z.needsMeasure,y0(a),tw(a),a.g=!0}function em(a,y,k){var z;return z=a.a.get(y),a.a.set(y,k===void 0?null:k),z===void 0?(++a.c,Lh(a.b)):++a.d,z}function JF(a,y,k){var z,E;for(z=Ve(k,Xe),E=0;en(z,0)!=0&&E<y;E++)z=Vt(z,Ve(a[E],Xe)),a[E]=_e(z),z=Bn(z,32);return _e(z)}function YF(a,y,k){var z,E,j,te;for(j=0,z=y-1;z>=0;z--)te=Vt(_n(j,32),Ve(a[z],Xe)),E=wV(te,k),j=_e(Bn(E,32));return _e(j)}function t0(a,y){var k;return Lt(a)===Lt(y)?!0:ze(y,11)?(k=y,a.e==k.e&&a.d==k.d&&ED(a,k.a)):!1}function ol(a,y){var k;return At(a)&&At(y)&&(k=a%y,zf<k&&k<Rr)?k:fr((b2(At(a)?Mn(a):a,At(y)?Mn(y):y,!0),wr))}function wi(a){var y;return Array.isArray(a)&&a.og===Me?Ml(cu(a))+"@"+(y=oo(a)>>>0,y.toString(16)):a.toString()}function cs(a,y){var k;switch(fe(),Hn((be(),y).type)){case 16:case 32:if(k=Ie.Td(y),k&&Io(a.Xc,k))return}c$(y,a,a.Xc)}function ar(a,y){var k;xr.call(this),this.a=y,!Uf&&(Uf=new eC),k=DC(Uf,a),k||(k=new st,AM(Uf,a,k)),k.add(this),this.b=a}function L9(a){k1(),ia.call(this),this.a=a,this.Uc==-1?Js((fe(),this.Xc),Br|(this.Xc.__eventBits||0)):this.Uc|=Br}function tm(){this.b=(Za(),jp),this.c=new Ot,this.c.put("transport",(Om(),Kx).a),this.c.put("fallbackTransport",Wx.a)}function gf(a){var y,k;if(!a.g){for(k=new Fe(a.f);k.a<k.c.a.length;)if(y=He(k),y.b){Mo(a,y);break}return!0}return!1}function n0(a){var y,k;if(a.e){if(!a.K)return;k=new PS(a),gn(k,_r),a.K=!1,vm(a),y=CT(XW),xt(y.J,Se(Ce(Ke,1),ve,1,5,[]))}}function ZF(a,y,k,z){var E,j;E=u0(k,zs(a.e,"appId")),j=new f0("custom-component-"+k,E,a.e),z==null?_m(y.a,null,j):em(y.b,z,j)}function i0(a,y,k,z,E){var j,te,ne;for(te=y;te<=k;te++)for(ne=z;ne<=E;ne++)j=Rt(a.a,ne,te),j&&j.o!=null&&j.o.length!=0&&j.g&&yT(j)}function r0(a,y,k,z,E){var j,te,ne;for(te=y;te<=k;te++)for(ne=z;ne<=E;ne++)j=Rt(a.a,ne,te),j&&j.o!=null&&j.o.length!=0&&j.g&&eQ(j)}function M9(a,y,k){var z,E;for(E=a.Ke();E.Ue();)if(z=E.Ve(),Lt(y)===Lt(z)||y!=null&&dr(y,z))return k&&E.We(),!0;return!1}function N9(a){var y,k;if(a.b)return a.b;for(k=oi?null:a.d;k;){if(y=oi?null:k.b,y)return y;k=oi?null:k.d}return Nn(),ih}function us(a){for(var y=a.length,k=0,z=0,E=0;k<y;)z=a.charCodeAt(k),z>47&&z<58&&(E=E*10+z-48),k++;return E}function eH(a,y){var k,z;if(z=a,y!=null&&y.length!=0){for(z+="<",k=0;k<y.length;k++)k!=0&&(z+=","),z+=""+y[k];z+=">"}return z}function o0(a,y,k){var z;z=Ir(a.d,y,k),z?(a.a=y,a.b=k,y=z.col1,k=z.row1):(a.a=0,a.b=0),yu(a.c,y,k),oU(a,y,k,(Ea(a.c,y,k),z))}function R9(a,y){var k;a.c=y,a.a=nH(y),a.a<54&&(a.f=(k=y.d>1?Zc(_n(y.a[1],32),Ve(y.a[0],Xe)):Ve(y.a[0],Xe),hv(Oi(y.e,k))))}function nm(a,y,k){var z;y.b&&(Mo(a,y),k&&y.a&&(Mo(a,null),(yh(),r1).Xe((fe(),a.Xc)),z=y.a,nR((ut(),pt),new s5(z))))}function tH(a){var y;!a.B&&!a.u.f&&(a.B=!0,a.c=!0,a.t?a.t=!1:(ad(a.V,!1,(y=Gt(a.u.j),y??"")),Bh(a.u)))}function nH(a){var y,k,z;return a.e==0?0:(y=a.d<<5,k=a.a[a.d-1],a.e<0&&(z=Wv(a),z==a.d-1&&(--k,k=k|0)),y-=wu(k),y)}function iH(a){var y,k,z;return a<l1.length?l1[a]:(k=a>>5,y=a&31,z=Le(gt,yt,17,k+1,15,1),z[k]=1<<y,new kn(1,k+1,z))}function P9(a){var y,k,z;for(k=new Fe(a);k.a<k.c.a.length;)y=He(k),z=qt((be(),y)),z&&z.removeChild(y);a.a=Le(Ke,ve,1,0,5,1)}function rH(a){var y,k;for(k=Ft(a.F.q,a.e),y=a.e+1;y<=a.f;y++)k+=Ft(a.F.q,y);a.G.style[mt]=k+1+(tt(),ke),a.a.style[mt]=k+1+ke}function _9(a){a.i||(bm(a),a.c||uv((ci(),uu()),a.a)),(Qr(),li).bf(Re(a.a),"rect(auto, auto, auto, auto)"),Re(a.a).style[qr]=ni}function oH(a,y){return a.h==Br&&a.m==0&&a.l==0?(y&&(wr=Zt(0,0,0)),IS((nu(),lx))):(y&&(wr=Zt(a.l,a.m,a.h)),Zt(0,0,0))}function $i(a){return a.V==-1&&(a.Lb==0&&(Fg(a.Mb)&&(a.Lb=(a.Mb.offsetWidth||0)|0),a.Lb==0&&(a.Lb=96)),a.V=bt(a.a.r*a.Lb/72)),a.V}function sH(a,y){var k,z;a.a.f?(k=(xn(),Qa(a.a.f)),z=Ja(a.a.f)):(k=(xn(),Qa(a.a.g)),z=Ja(a.a.g)),_N(lv(a.a.D),new x6(a,y),k,z)}function B9(a,y,k){if(a<0||y>k)throw we(new vo(T2+a+wz+y+", size: "+k));if(a>y)throw we(new $o(T2+a+" > toIndex: "+y))}function cH(a,y){switch(fe(),Hn((be(),y).type)){case ui:case Au:m2(a.c,y);case 8:case 8192:RT(a.c,y);break;case 64:YG(a.c,y)}}function im(a){if(xn(),a.getBoundingClientRect){var y=a.getBoundingClientRect();return y.right-y.left}else return a.offsetWidth}function D9(){D9=ge,Ta(),new Oa("data:image/gif;base64,R0lGODlhBQAJAIAAAAAAAAAAACH5BAEAAAEALAAAAAAFAAkAAAIMRB5gp9v2YlJsJRQKADs=")}function Nn(){Nn=ge,f1=new K3,nK=new A3,Jx=new T3,iK=new V3,rK=new I3,ih=new z3,oK=new E3,h1=new j3,Kp=new O3}function q9(a,y){mw.call(this),a.qd("100%"),a.od("100%"),(fe(),this.Xc).style[F2]=tn,a.Xc.style[F2]="all",af(this,a),AA(this,y)}function wf(){Ra.call(this),(fe(),this.Xc).className="v-label",this.Uc==-1?Js(this.Xc,241|(this.Xc.__eventBits||0)):this.Uc|=241}function F9(a,y,k){return y>=a.bb&&y<=a.xb&&k>=a.db&&k<=a.zb||y<=a.ob&&k<=a.Sc||y>a.ob&&y<=a.xb&&k<=a.Sc||k>a.Sc&&k<=a.zb&&y<=a.ob}function rm(a){var y,k,z,E,j;if(a==null)return 0;for(j=1,k=a,z=0,E=k.length;z<E;++z)y=k[z],j=31*j+(y!=null?oo(y):0),j=j|0;return j}function om(a,y){var k;if(y.Wc!=a)return!1;try{qn(y,null)}finally{k=(fe(),y.Xc),Jo(qt((be(),k)),k),yD(a.o,y)}return!0}function ed(a,y,k){var z,E;if(a.a.J){for(E=new Fe(a.a.J);E.a<E.c.a.length;)if(z=He(E),z.col1==y&&z.row1==k)return z}return null}function sl(a,y){var k,z;if(y)for(sm(a.kc),sm(a.Qc),sm(a.d),z=new Fe(a.Mc);z.a<z.c.a.length;)k=He(z),k&&(k.g=!0);gn(a.Jb,20)}function sm(a){var y,k,z,E;for(E=new Fe(a);E.a<E.c.a.length;)for(z=He(E),k=new Fe(z);k.a<k.c.a.length;)y=He(k),y&&(y.g=!0)}function uH(a){for(var y=0,k=a;k.offsetParent;)y-=k.scrollTop,k=k.parentNode;for(;a;)y+=a.offsetTop,a=a.offsetParent;return y}function lH(a){for(var y=0,k=a;k.offsetParent;)y-=k.scrollLeft,k=k.parentNode;for(;a;)y+=a.offsetLeft,a=a.offsetParent;return y}function H9(a){var y;if(a.getBoundingClientRect!=null){var k=a.getBoundingClientRect();y=k.bottom-k.top}else y=a.offsetHeight;return y}function fH(a,y,k,z){var E;return E=new kk,Fk(E,ae.Math.abs(z-k)+1),E.a+="R",E.a+=" x ",Fk(E,ae.Math.abs(y-a)+1),E.a+="C",E.a}function $9(a){var y;return y=new st,a.S&&St(y,a.S),Os(y,new di(a.Bc)),a.T&&Os(y,new di(a.T)),a.Cc&&Os(y,new di(a.Cc)),y}function U9(a,y){var k,z,E,j;return k=y>>5,y&=31,E=a.d+k+(y==0?0:1),z=Le(gt,yt,17,E,15,1),Em(z,a.a,k,y),j=new kn(a.e,E,z),Ti(j),j}function Ko(a,y,k){var z,E,j,te;for(j=y+k,RD(y,j,a.length),te="",E=y;E<j;)z=ae.Math.min(E+1e4,j),te+=P_(a.slice(E,z)),E=z;return te}function G9(a,y,k,z){var E,j,te;E=V9(a,y,k),j=E.remove(z),j&&E.isEmpty()&&(te=no(a.d,y),te.remove(k),te.isEmpty()&&$u(a.d,y))}function hH(a,y,k){var z,E,j,te,ne;for(E=(a.i==null&&(a.i=(Yc(),ne=vp.Md(a),s$(ne))),a.i),j=0,te=E.length;j<te;++j)z=E[j],y.ze(k+"	at "+z)}function dH(){return Error.stackTraceLimit>0?(ae.Error.stackTraceLimit=Error.stackTraceLimit=64,!0):"stack"in new Error}function aH(){var a;return Hd!=0&&(a=jr(),a-lX>2e3&&(lX=a,$d=ae.setTimeout(fN,10))),Hd++==0?(kq((ut(),pt)),!0):!1}function bH(a){var y,k;return en(a,-129)>0&&en(a,128)<0?(y=_e(a)+128,k=(j8(),Rx)[y],!k&&(k=Rx[y]=new gg(a)),k):new gg(a)}function Lo(a){return Xi(),en(a,0)<0?en(a,-1)!=0?new ym(-1,tu(a)):u1:en(a,10)<=0?Ux[_e(a)]:new ym(1,a)}function s0(a,y){return a.e>y.e?1:a.e<y.e?-1:a.d>y.d?a.e:a.d<y.d?-y.e:a.e*pf(a.a,y.a,a.d)}function pH(a){return Fw(a.Q,a.e,a.K)?Re(a.X):qw(a.Q,a.e,a.K)?Re(a.a):bw(a.Q,a.e,a.K)?Re(a.W):Re(a.b)}function c0(a,y){for(var k=0;!y[k]||y[k]=="";)k++;for(var z=y[k++];k<y.length;k++)!y[k]||y[k]==""||(z+=a+y[k]);return z}function td(a,y){var k,z;for(z=a.a.length,y.length<z&&(y=zg(new Array(z),y)),k=0;k<z;++k)y[k]=a.a[k];return y.length>z&&(y[z]=null),y}function gH(a,y){var k,z;for(z=0,k=new Fe(y);k.a<k.c.a.length;){if(He(k),!Vo(a.a,z+1))return pn(z,y.a.length),y.a[z];++z}return null}function vf(a){var y,k,z;for(z=a.zb,y=gi(a.zc),k=a.kc.a.length-1;k>0;k--){if(gi(Ze(Ze(a.kc,k),0).d)<=y)return z;--z}return a.zb}function wH(a){var y,k,z,E;for(ls(a.Fb),z=(E=new di(a.Eb).a.Wf().Ke(),new yr(E));z.a.Ue();)k=(y=z.a.Ve(),y.dg()),lt(k.d);Mt(a.Eb)}function cm(a){var y;return y=Cf(a),y>34028234663852886e22?1/0:y<-34028234663852886e22?-1/0:y}function vH(a){return a>=48&&a<48+ae.Math.min(10,10)?a-48:a>=97&&a<97?a-97+10:a>=65&&a<65?a-65+10:-1}function nd(a,y,k,z){(Mp?y.Tf()>=N9(a).Tf():Np?y.Tf()>=(Nn(),800):Pp?y.Tf()>=(Nn(),900):Rp&&y.Tf()>=(Nn(),_r))&&TA(a,y,k,z)}function Q9(a,y,k){(Mp?y.Tf()>=N9(a).Tf():Np?y.Tf()>=(Nn(),800):Pp?y.Tf()>=(Nn(),900):Rp&&y.Tf()>=(Nn(),_r))&&TA(a,y,k,null)}function um(a){var y;return y=Se(Ce(gt,1),yt,17,15,[0,0,0,0]),y[0]=to(a,ps),y[1]=to(a,ey),y[2]=to(a,"marginBottom"),y[3]=to(a,ii),y}function J9(a,y){var k,z;for(z=a.a.length,y.length<z&&(y=zg(new Array(z),y)),k=0;k<z;++k)y[k]=a.a[k];return y.length>z&&(y[z]=null),y}function Y9(a,y){var k,z;a.A.length>y?k=a.A[y]:k=0,a.$.length>y?z=a.$[y]:z=0,XH(a.V,k,z),(k!=0||z!=0)&&Ct((ut(),pt),new g8(a,k,z))}function lm(){lm=ge,Ex=new _l("INFO",0),Ox=new _l(Ry,1),zx=new _l("ERROR",2),Vx=new _l("CRITICAL",3),jx=new _l("SYSTEM",4)}function mH(a){var y;return y=typeof a,ye(y,$0)||ye(y,Vf)||ye(y,xd)?!0:a!=null&&a.$implements__java_lang_Comparable}function cl(a,y){return ft(a),y==null?!1:ye(a,y)?!0:a.length==y.length&&ye(a.toLowerCase(),y.toLowerCase())}function u0(a,y){return ae.Vaadin&&ae.Vaadin.Flow&&ae.Vaadin.Flow.clients[y]&&ae.Vaadin.Flow.clients[y].getByNodeId(parseInt(a))}function yH(a,y,k){var z;z=a.e.r,z&&ze(z,158)&&TG(z,a,a.k,a.b,y,k),zt((fe(),a.Xc),"c"+a.b+"r"+a.k),a.b=k,a.k=y,Ue(a.Xc,"c"+a.b+"r"+a.k)}function xH(a,y,k){var z,E,j,te;te=e0(y,k),te&&(z=(be(),te).getAttribute(Gi)||"",Mr(a.Q.wb,z),E=a.Q.wb.a,j=a.Q.wb.b,E!=0&&j!=0&&DV(a,E,j))}function Z9(){Z9=ge;var a;Sx="8.20.2",a=Nr(Sx,"[-.]",4),Wi(a[0]),Wi(a[1]);try{Wi(a[2])}catch(y){if(y=Xt(y),!ze(y,46))throw we(y)}}function CH(a,y){var k,z;for(z=y.keySet().Ke();z.Ue();)k=z.Ve(),a.c.contains(k)?qM((!a.C&&(a.C=new un),a.C),k,y.get(k)):nU(a,k,y.get(k))}function kH(a,y,k){var z,E,j;for(E=new Fe(y);E.a<E.c.a.length;)z=He(E),j=qe+z.c+Ye+z.k,k&&aa(k.b,j)?za(z):a.r&&bn(a.r,j)&&nw(z)}function fm(a){var y,k,z,E;for(k=(E=new Gr(a.t.a).a.Wf().Ke(),new po(E));k.a.Ue();)y=(z=k.a.Ve(),z.cg()),zt(y.d,Ji);Mt(a.t.a),Mt(a.u.a)}function l0(a,y,k,z){No();var E,j;for(E=0,j=0;j<k;j++)E=Vt(Oi(Ve(y[j],Xe),Ve(z,Xe)),Ve(_e(E),Xe)),a[j]=_e(E),E=Yn(E,32);return _e(E)}function ul(a,y,k,z,E){a.G=y,a.I=z,a.H=k,a.J=E,P0(a.B,y,k,z,E),a.ab>0&a.r>0&&P0(a.D,y,k,z,E),a.ab>0&&P0(a.F,y,k,z,E),a.r>0&&P0(a.A,y,k,z,E)}function eT(a,y){a._=!1,a.ab=!1,dl(a.$,up,0),Wh(a.sb,!1),Ii(a.sb,""),Y1(a.sb,"0"),lw(a.sb,""),Pi(a.sb,""),y&&Ct((ut(),pt),new oh(a))}function SH(a,y,k,z,E){fe(),an.Ie(y,op),y.__listener=a,an.Ie(k,op),k.__listener=a,an.Ie(z,op),z.__listener=a,an.Ie(E,op),E.__listener=a}function hm(a,y){var k;return k=qt((be(),y))?bu(eo(qt(y))):0,a.a.bc||k==1?CR(a.a.a):a.a.ac||k==2?xR(a.a.a):!1}function IH(a){var y;if(y=(!An&&(An=new Xs),An).c.b[D1(new Ys(a,"!new"))],!y)throw we(new A1("There is no constructor for "+a.b));return y}function AH(a){var y;if(y=(!An&&(An=new Xs),An).c.b[a.b.a+"."+a.a],!y)throw we(new A1("There is no invoker for "+(a.b.b+"."+a.a)));return y}function tT(a){var y;if(y=(!An&&(An=new Xs),An).c.e[a.b.a+"."+a.a],!y)throw we(new A1("There is no return type for "+(a.b.b+"."+a.a)));return y}function dm(a){var y;try{return y=ae.JSON.parse(a),y}catch(k){throw k=Xt(k),ze(k,21)?we(new gk("Can't parse "+a)):we(k)}}function On(a){var y,k,z;try{return z=HH(a),k=A9(z),k}catch(E){throw E=Xt(E),ze(E,79)?(y=E,we(new R1(Zz+hh(a.mg)+eE,y))):we(E)}}function nT(a){Xi(),a.length==0?(this.e=0,this.d=1,this.a=Se(Ce(gt,1),yt,17,15,[0])):(this.e=1,this.d=a.length,this.a=a,Ti(this))}function am(a,y){this.e=a,y<Dy?(this.d=1,this.a=Se(Ce(gt,1),yt,17,15,[y|0])):(this.d=2,this.a=Se(Ce(gt,1),yt,17,15,[y%Dy|0,y/Dy|0]))}function iT(){mw.call(this),(fe(),this.Xc).tabIndex=-1,!this.b&&(this.b=R_(this,Se(Ce(yp,1),ve,0,2,[]))),eP(this.b,this.Xc)}function TH(a,y){switch(y.c){case 0:{a.dir="rtl";break}case 1:{a.dir="ltr";break}case 2:{z9(a)!=(hf(),Cp)&&(a.dir="");break}}}function bm(a){a.i?a.a.G&&(xe(ue.body,a.a.B),a.f=rD(a.a.C),oV(),a.b=!0):a.b&&(Jo(ue.body,a.a.B),Sr(a.f.a),a.f=null,a.b=!1)}function rT(a,y,k,z){a.C?a.a!=k?(sV(a.U,y,z),ST(a.U,k)):(a.S==null||!$$(a.S,y))&&sV(a.U,y,!1):(aF(a.U,y),ST(a.U,k)),a.S=y,a.a=k}function oT(){var a,y;oT=ge,Ta(),new Oa((Qs(),a="__gwtDevModeHook:"+it+":moduleBase",y=ae||self,(y[a]||_t)+"clear.cache.gif"))}function VH(a,y){var k,z,E,j,te;for(te=new st,z=Nr(y,"[^A-z0-9:!]+",0),E=0,j=z.length;E<j;++E)k=z[E],fV(a,k)&&(te.a[te.a.length]=k);return te}function oo(a){return Qo(a)?hu(a):vh(a)?bt((ft(a),a)):wh(a)?(ft(a),a?1231:1237):Bw(a)?a.$c():Lw(a)?Z1(a):a&&a.hashCode?a.hashCode():Z1(a)}function zH(a,y){return Qo(a)?!!Gj[y]:a.ng?!!a.ng[y]:vh(a)?!!Uj[y]:wh(a)?!!$j[y]:!1}function pm(a){for(var y=a.sheet.cssRules?a.sheet.cssRules:a.sheet.rules,k=[],z=0;z<y.length;z++)k.push(y[z].cssText);return k.join(" ")}function ls(a){for(var y=a.sheet.cssRules?a.sheet.cssRules:a.sheet.rules;y.length>0;)a.sheet.deleteRule?a.sheet.deleteRule(0):a.sheet.removeRule(0)}function EH(a,y){a.ob=y,fU(a.yc,y),y>0?dl(a.$,"."+a.Ac+" .top-left-pane .cell.col"+y+", ."+a.Ac+" .bottom-left-pane .cell.col"+y,1):dl(a.$,up,1)}function jH(a,y,k,z,E){var j,te,ne;y==16?(sr(a.rb,E),te=qe+k+Ye+z,ne=Ui(a,te),ne?j=ne.d:j=Rt(a,k,z).d,$h(a.qb,new p6(a,j))):Pn(a.qb,!1)}function OH(a,y,k){var z,E,j;for(E=new Fe(y);E.a<E.c.a.length;)z=He(E),j=qe+z.c+Ye+z.k,k&&bn(k.a,j)?Va(z):a.tb&&a.tb.contains(j)&&iw(z)}function hu(a){R7();var y,k,z;return k=":"+a,z=qd[k],z!=null?bt((ft(z),z)):(z=Jy[k],y=z==null?XU(a):bt((ft(z),z)),F_(),qd[k]=y,y)}function XH(a,y,k){a.Db=!1,Mt(a.e),Mt(a.qc),Fg(a.Mb)&&(a.Lb=(a.Mb.offsetWidth||0)|0),yf(a),xV(a.yc,1,1,1,1),a.V=-1,Ct((ut(),pt),new p8(a,y,k))}function gm(a,y){Qs();var k;if(k=xp,k){if(k==gQ)return;nd(k.a,(Nn(),h1),a.Gd(),a);return}y?w_(ze(a,81)?a.Id():a):(Uc(),x0(a,UW,"",""))}function wm(a){var y,k,z;for(Aa.call(this,W$(a),a.isEmpty()?null:a.Ke().Ve()),this.a=a,z=0,k=a.Ke();k.Ue();)y=k.Ve(),z++!=0&&g$(this,y)}function sT(a){var y,k,z,E;for(E=a.Sc>0?a.Sc+1:1;E<=a.zb;E++){for(z=new st,k=1;k<=a.ob;k++)y=new ff(a,k,E),xe(a.c,y.d),z.a[z.a.length]=y;St(a.d,z)}}function cT(a){var y,k,z,E;for(E=1;E<=a.Sc;E++){for(z=new st,k=a.ob>0?a.ob+1:1;k<=a.xb;k++)y=new ff(a,k,E),xe(a.Pc,y.d),z.a[z.a.length]=y;St(a.Qc,z)}}function uT(a,y){var k,z,E,j;for(j=a.size(),y.length<j&&(y=zg(new Array(j),y)),E=y,z=a.Ke(),k=0;k<j;++k)E[k]=z.Ve();return y.length>j&&(y[j]=null),y}function ll(a,y,k){var z;z=(fe(),a.Xc).style,z[ii]=(eh==-1&&(eh=m0(vn)),-eh+(tt(),ke)),z[ps]=(th==-1&&(th=m0(fn)),-th+ke),j9(a,y,k),Tf(a,a.F?0:1)}function WH(a,y,k){var z,E,j,te;te=e0(y,k),te&&(z=(be(),te).getAttribute(Gi)||"",Mr(a.wb,z),E=a.wb.a,j=a.wb.b,E!=0&&j!=0&&(bd(a.a,E,j),a.Jc=E,a.Kc=j))}function Xn(a,y,k){var z;return z=_g(k.b),z==-1?bN(a,k.b):a.Uc==-1?Js((fe(),a.Xc),z|(a.Xc.__eventBits||0)):a.Uc|=z,Hu(a.Vc?a.Vc:a.Vc=new Pu(a),k,y)}function KH(a,y){var k,z,E;return y<=22?(k=a.l&(1<<y)-1,z=E=0):y<=44?(k=a.l,z=a.m&(1<<y-22)-1,E=0):(k=a.l,z=a.m,E=a.h&(1<<y-44)-1),Zt(k,z,E)}function du(a,y,k){a.B=!1,ow(a.u),a.t=!1,Qu(a.V)||(y==null&&(y=""),a.P=ye(y.substr(0,1),"=")||ye(y.substr(0,1),"+"),eT(a.V,k),a.P||QH(a.V,y))}function LH(a){var y,k,z;for(y=hq(B_(new Fu(null,new zh(Wn(a,new rh))),new l3)),z=Le(LQ,ve,17,y.length,15,1),k=0;k<y.length;k++)z[k]=y[k];return z}function MH(a){var y,k;for(k=Ft(a.p.q,a.b),y=a.b+1;y<=a.c;y++)k+=Ft(a.p.q,y);a.k.style[mt]=k+1+(tt(),ke),a.q.style[mt]=k+1+ke,a.a.style[mt]=k+1+ke}function f0(a,y,k){var z;z=a7(ue,"slot"),z.setAttribute("name",a),bo(this,(fe(),z)),y.setAttribute("slot",a),ka(this,new m6(k,y),(!$s&&($s=new xr),$s))}function NH(a,y){var k=new Array(y),z;switch(a){case 14:case 15:z=0;break;case 16:z=!1;break;default:return k}for(var E=0;E<y;++E)k[E]=z;return k}function au(a,y,k){var z,E;return z=Dn(y,"([/\\\\\\.\\*\\+\\?\\|\\(\\)\\[\\]\\{\\}$^])","\\\\$1"),E=Dn(Dn(k,"\\\\","\\\\\\\\"),gr,"\\\\$"),Dn(a,z,E)}function RH(a){var y,k;k=G1(Re(a.sb)),a.sc<=a.Sc?a.rc<=a.ob?y=a.Nc:y=a.Pc:a.rc<=a.ob?y=a.c:y=a.zc,k!=y&&(Jo(k,Re(a.sb)),fe(),xe(y,Vr(Re(a.sb))))}function vm(a){var y,k,z,E;for(E=(Ch(),Ch(),WW),k=new Fe(E);k.a<k.c.a.length;)y=He(k),z=y.a,a&&jM(z,(fe(),a.Xc).tkPid);return null}function id(a){var y,k,z,E,j;for(z=a.db,y=Vn(a.zc),j=new Fe(a.kc);j.a<j.c.a.length;){if(E=He(j),k=gH(a,E),k&&Vn(k.d)>=y)return z;++z}return a.db}function fl(a,y,k){var z,E;if(a.a.J){for(E=new Fe(a.a.J);E.a<E.c.a.length;)if(z=He(E),z.col1<=y&&z.row1<=k&&z.col2>=y&&z.row2>=k)return z}return null}function PH(a){var y;return a==null?!1:(y=typeof a,ye(y,$0)||ye(y,Vf)||ye(y,xd)||a.$implements__java_io_Serializable||Array.isArray(a))}function _H(a){bm(a),a.i?(Re(a.a).style[as]=Su,a.a.N!=-1&&a.a.Se(a.a.H,a.a.N),q1((ci(),uu()),a.a)):a.c||uv((ci(),uu()),a.a),Re(a.a).style[qr]=ni}function BH(a,y){var k,z;y.indexOf("android")!=-1&&(k=Uh(y,y.indexOf("android ")+8,y.length),k=Uh(k,0,k.indexOf(";")),z=Nr(k,"\\.",0),CV(a,z))}function DH(a,y,k){var z;++y,++k,z=qe+y+Ye+k,bn(a.b,z)?(a.o=!0,a.Q=Nt(a.b,z),r2(a.Q,!0)):(a.o=!0,a.k=y,a.n=k,QT(a,y,k),a.Q=a.q,r2(a.q,!0))}function lT(a){var y,k,z,E;if(a.Cc)for(E=(k=new di(a.Cc).a.Wf().Ke(),new yr(k));E.a.Ue();)z=(y=E.a.Ve(),y.dg()),z.e.M&&z.d&&F9(z.d,z.b,z.k)&&Pv(z)}function Wn(a,y){var k,z,E,j,te;if(z=new st,a==null||a.length==0||ye(Ro,a))return z;for(E=dm(a),k=0;k<E.length;k++)j=(te=E[k],te),St(z,y.Kf(j));return z}function qH(a,y){var k,z,E;return E=a.h-y.h,E<0||(k=a.l-y.l,z=a.m-y.m+(k>>22),E+=z>>22,E<0)?!1:(a.l=k&wn,a.m=z&wn,a.h=E&Li,!0)}function Lr(a){var y;a.d.o&&(a.d.o=!1,yf(a.c)),!Qu(a.c)&&!a.d.e&&a.d.p&&M7(a.d.p,Hl(a.c))&&(y=Gv(a.d.p,Hl(a.c)),a.d.o=!0,sh(a.d.u,!1),Wm(a.c,y))}function bu(a){try{var y=a.charAt(0);if(y==="r"){if(y=a.charAt(1),y==="h")return 1}else if(y==="c"&&(y=a.charAt(1),y==="h"))return 2}catch{}return 0}function FH(a){ci();var y;return y=no(Eu,a),y&&(!a||(fe(),y.Xc==a))||(Mu(Eu)==0&&uI(new Dp),a?y=new Yw(a):y=new Cw,Zn(Eu,a,y),Ut(Sl,y)),y}function HH(a){var y;try{return tT(new Ys(new Ee(a.mg),"getState"))}catch(k){throw k=Xt(k),ze(k,79)?(y=k,we(new R1(Zz+hh(a.mg)+eE,y))):we(k)}}function h0(a,y){y!=(rn(a.B)||!!a.A&&rn(a.A)||!!a.F&&rn(a.F)||!!a.D&&rn(a.D))&&(rl(a.B,y),a.D&&rl(a.D,y),a.F&&rl(a.F,y),a.A&&rl(a.A,y),hd(a,!y))}function $H(a,y){for(var k=a.split(".");typeof y==F0;){var z=k.shift();if(z in y){if(k.length==0)return!0;y=y[z]}else return!1}return!1}function UH(a,y){var k,z;k=kh(y.a),a.b._&&(k==13?Kv(a.b.a,(z=Gt(a.b.sb),z??""),Yl(y.a)):(Tv(a.b),rs(a.a,!0),Bh(a.a),p7(a.a),Yg(a.a))),Yo(y.a)}function GH(a,y){y==null?(a.f.style[Pt]=(It(),tn),a.c.style[ey]=(tt(),Ni)):(a.c.style[ey]=(tt(),"206.0px"),a.f.style[Pt]=(It(),"inline"),xo(a.f,y))}function Ui(a,y){var k,z,E,j;for(z=(j=new di(a.Eb).a.Wf().Ke(),new yr(j));z.a.Ue();)if(k=(E=z.a.Ve(),E.dg()),ye(y,qe+k.c+Ye+k.k))return k;return null}function QH(a,y){var k,z,E;for(E=Ha(a),(OI(a,a.rc,a.sc)||bf(a,a.rc,a.sc))&&E&&Fl(E,y),z=a.Sc>0?0:a.bb;z<a.rc;z++)k=Rt(a,z,a.sc),k&&(k.g=!0);sl(a,!1)}function JH(a){return!(!a.b||a.a.t==5&&a.a.s&&yP(a)>=534||a.a.t==4&&a.a.s&&a.a.u>=6||a.a.j)}function fs(a,y){var k;return At(a)&&At(y)&&(k=a/y,zf<k&&k<Rr)?k<0?ae.Math.ceil(k):ae.Math.floor(k):fr(b2(At(a)?Mn(a):a,At(y)?Mn(y):y,!1))}function YH(a,y){var k,z;y.indexOf("os ")==-1||y.indexOf(" like mac")==-1||(k=Uh(y,y.indexOf("os ")+3,y.indexOf(" like mac")),z=Nr(k,"_",0),CV(a,z))}function mf(a,y,k,z){this.n=a,this.c=y,this.k=k,this.d=Oe(ue),z?(this.f=z.needsMeasure,this.o=z.value,this.b=z.cellStyle):this.o=null,tw(this),y0(this)}function ZH(a,y){var k,z;return qo(),Qo(a)?(k=(ft(a),a),z=(ft(y),y),k==z?0:k<z?-1:1):vh(a)?Yv((ft(a),a),(ft(y),y)):wh(a)?aP((ft(a),a),(ft(y),y)):a.he(y)}function yf(a){var y,k;a.R&&(a.R=!1,zt(Re(a.S),pE),qn(a.S,null),br(a.S),a.Db&&(k=Ha(a),k&&(y=Nt(a.e,qe+a.rc+Ye+a.sc),Fl(k,y?y.value:null))),a.S=null)}function d0(a){var y,k,z;z=new st,H$(a,a.w,z),k=jD(a),qV(a,z,a.db,a.zb,k),y=aA(a),d2(a,z,a.bb,a.xb,y),a.ob>0&&d2(a,z,1,a.ob,0),a.Sc>0&&qV(a,z,1,a.Sc,0),Kq(a.w,z)}function fT(a,y){var k,z,E;return k=y.cg(),E=y.dg(),z=a.get(k),!(!(Lt(E)===Lt(z)||E!=null&&dr(E,z))||z==null&&!a.containsKey(k))}function mm(a,y){var k,z,E,j,te,ne,ie,se;return ie=a.h>>19,se=y.h>>19,ie!=se?se-ie:(E=a.h,ne=y.h,E!=ne?E-ne:(z=a.m,te=y.m,z!=te?z-te:(k=a.l,j=y.l,k-j)))}function rd(a,y){var k,z,E,j;for(z=(j=new di(a.Eb).a.Wf().Ke(),new yr(j));z.a.Ue();)if(k=(E=z.a.Ve(),E.dg()),ye(y,qe+k.c+Ye+k.k))return!0;return!1}function a0(a,y,k,z,E,j){var te,ne,ie,se,ce;for(ce=E;ce<=j;ce++)for(te=k;te<=z;te++)se=qe+te+Ye+ce,aa(y.b,se)&&(rd(a,se)?ne=Ui(a,se):ne=Rt(a,te,ce),ie=qg(y.b,se),Cm(a,ne,ie))}function e$(a){a.b&&(Oo(a.b),a.b=null),(!a.K&&(a.K=On(a)),a.K).i>=0?(a.b=new qS(a),Hv(a.b,(!a.K&&(a.K=On(a)),a.K).i)):null.pg(new O8(a.G,(ht(Bp),Bp.k)))}function hT(a,y){EF(a,qP(ue)),Uo((fe(),a.Xc),gl),a.Uc==-1?Js(a.Xc,133398655|(a.Xc.__eventBits||0)):a.Uc|=133398655,a.a&&(a.Xc[Xd]=""),vM(a.Xc,y.a)}function t$(a,y,k){var z,E;E=a.Sc>=k.b,z=a.ob>=k.a,xe(E&&z?a.Nc:E?a.Pc:z?a.c:a.zc,(fe(),k.Xc)),qn(k,a),Te(a.Bc,y,k)}function br(a){if(!a.Wc)ci(),Bl(Sl,a)&&PP(a);else if(ze(a.Wc,31))a.Wc.Le(a);else if(a.Wc)throw we(new mo("This widget's parent does not implement HasWidgets"))}function n$(a,y){var k;Ah(y.d)==8&&(Sr(a.e.a),k=rv(y.d),a.d&&k==a.d?a.g=!0:Di(jn((ht(LW),LW.k)),"Ignoring mouseup from "+k+" when mousedown was on "+a.d))}function i$(a,y){var k,z,E,j;a.i&&(z=et(a.b,y,0),z!=-1&&(k=a.i?a.d:Ug(a.d),j=(fe(),an.Be(k,z)),E=an.Ce(j),E==2&&Jo(j,an.Be(j,1)),y.Xc.colSpan=2))}function dT(a,y,k){var z,E,j;E=350,E<=0&&(E=1),Di(jn((ht(fi),fi.k)),"Animate "+E+" "+k+" "+y),j=-y+a.n,z=-k+a.n,vr&&(z-=a.n,j-=a.n),cA(a,E,z,j)}function ym(a,y){this.e=a,Lg(Ve(y,-4294967296),0)?(this.d=1,this.a=Se(Ce(gt,1),yt,17,15,[_e(y)])):(this.d=2,this.a=Se(Ce(gt,1),yt,17,15,[_e(y),_e(Bn(y,32))]))}function r$(a){var y,k,z;return en(a,0)>=0?(k=fs(a,jd),z=ol(a,jd)):(y=Yn(a,1),k=fs(y,5e8),z=ol(y,5e8),z=Vt(_n(z,1),Ve(a,1))),Zc(_n(z,32),Ve(k,Xe))}function o$(a,y,k,z){hk();var E=wp;it=y,_t=k,Ff=z;function j(){for(var te=0;te<E.length;te++)E[te]()}if(a)try{mi(j)()}catch(te){a(y,te)}else mi(j)()}function s$(a){var y,k,z,E;for(y="Gg",k="Ff",E=ae.Math.min(a.length,5),z=E-1;z>=0;z--)if(ye(a[z].d,y)||ye(a[z].d,k)){a.length>=z+1&&a.splice(0,z+1);break}return a}function c$(a,y,k){var z,E,j,te,ne;if(Uf&&(ne=DC(Uf,(be(),a).type),ne))for(te=ne.Ke();te.Ue();)j=te.Ve(),z=j.a.a,E=j.a.b,F3(j.a,a),H3(j.a,k),L6(y,j.a),F3(j.a,z),H3(j.a,E)}function u$(a,y){if(a.u=-1,a.v=-1,y.length>2){try{a.u=Wi(y[1])}catch(k){if(k=Xt(k),!ze(k,21))throw we(k)}try{a.v=Wi(y[0])}catch(k){if(k=Xt(k),!ze(k,21))throw we(k)}}}function xm(a,y,k){var z,E,j;for(E=a.Wf().Ke();E.Ue();)if(z=E.Ve(),j=z.cg(),Lt(y)===Lt(j)||y!=null&&dr(y,j))return k&&(z=new Bg(z.cg(),z.dg()),E.We()),z;return null}function pu(a){var y;a.s==0?(Ue(a.p,dt),Ue(a.n,dt)):(zt(a.p,dt),zt(a.n,dt)),y=Km(a,a.u.length-1),a.s<y?(zt(a.q,dt),zt(a.o,dt)):(Ue(a.q,dt),Ue(a.o,dt))}function Cm(a,y,k){var z;!y||!k||(Fl(y,null),z=k.Wc,z?a==z?xe(y.d,(fe(),k.Xc)):(br(k),xe(y.d,(fe(),k.Xc)),qn(k,a)):(xe(y.d,(fe(),k.Xc)),qn(k,a)))}function l$(a){Yc();var y=a.backingJsObject;if(y&&y.stack){var k=y.stack,z=y+`
`;return k.substring(0,z.length)==z&&(k=k.substring(z.length)),k.split(`
`)}return[]}function od(a){var y,k;a.u.f||(a.B||a.t?(a.c=!0,y=(k=Gt(a.u.j),k??""),lf(a.W,a.V.sc,a.V.rc,y),du(a,y,!0)):a.o&&(a.o=!1,yf(a.V),sh(a.u,!0)))}function aT(a,y,k,z,E){var j,te;for(j=0,te=0;te<E;te++)j=Vt(j,cn(Ve(y[te],Xe),Ve(z[te],Xe))),a[te]=_e(j),j=Bn(j,32);for(;te<k;te++)j=Vt(j,Ve(y[te],Xe)),a[te]=_e(j),j=Bn(j,32)}function bT(){bT=ge,new vv(""),hW=new RegExp(`[&<>'"]`),lW=new RegExp("&","g"),fW=new RegExp(">","g"),dW=new RegExp("<","g"),bW=new RegExp("'","g"),aW=new RegExp('"',"g")}function hl(a,y,k,z,E){Uc();var j,te;if(Uw(a,"src"),Uw(k,"dest"),cu(a),cu(k),te=a.length,j=k.length,y<0||z<0||E<0||y+E>te||z+E>j)throw we(new Xl);E>0&&qT(a,y,k,z,E,!0)}function Ue(a,y){var k,z;return y=Vg(y),z=a.className||"",k=Dm(z,y),k==-1?(z.length>0?a.className=z+" "+y||"":a.className=y||"",!0):!1}function pT(a){var y,k,z;if(a.g){for(k=et(a.f,a.g,0),y=k;;)if(k=k+1,k==a.f.a.length&&(k=0),k==y){z=Ze(a.f,y);break}else if(z=Ze(a.f,k),z.b)break;Mo(a,z)}}function gT(a){var y,k,z;if(a.g){for(k=et(a.f,a.g,0),y=k;;)if(k=k-1,k<0&&(k=a.f.a.length-1),k==y){z=Ze(a.f,y);break}else if(z=Ze(a.f,k),z.b)break;Mo(a,z)}}function b0(a,y,k){var z;z=Ir(a.d,y,k),z?(a.a=y,a.b=k,y=z.col1,k=z.row1):(a.a=0,a.b=0),BU(a.c,y,k),yu(a.c,y,k),Ks(a.d,y,k,null),Lr(a),qa(a.d.W,k,y,!1),gn(a.d.s,200)}function wT(a){var y,k,z;for(z=SP(ue.getElementsByTagName(dp)[0],Id),y=0;y<z.length;y++)if(k=z[y],ye(ay,k.rel)&&ye(Fs,k.type)&&ye(a,k.href))return k;return null}function vT(a){var y;for(y=0;0<=(y=a.indexOf("\\",y));)Tt(y+1,a.length),a.charCodeAt(y+1)==36?a=a.substr(0,y)+"$"+Zs(a,++y):a=a.substr(0,y)+(""+Zs(a,++y));return a}function f$(a,y){var k,z,E,j,te;return kl&&a&&sN(a,kl)?(k=tr.a,z=tr.b,E=tr.c,j=tr.d,oA(tr),mK(tr,y),Ws(a,tr),te=!(tr.a&&!tr.b),tr.a=k,tr.b=z,tr.c=E,tr.d=j,te):!0}function mT(a,y){y!=((fe(),a.Xc).style.display!=tn||!!a.a&&rn(a.a)||!!a.X&&rn(a.X)||!!a.W&&rn(a.W))&&(js(a.Xc,y),a.W&&ai(a.W,y),a.X&&ai(a.X,y),a.a&&ai(a.a,y))}function km(a){var y,k,z;if(vr)a.q[Ky]=a.c;else{for(k=new Fe(a.g);k.a<k.c.a.length;)y=He(k),z=y.style,z[$2]="translate3d(0,0,0)";wo(a.q,a.c)}zp=null,Sr(a.d.a),a.d=null}function Sm(a,y,k,z){a.c=y,a.d=k,a.b=z,(fe(),a.Xc).style[ot]=dt,a.t&&(a.t.style[ot]=dt),a.i.style[ot]=(at(),dt),eu(a),a.k=cr(a.Xc,Mf),a.n=cr(a.Xc,pl),pd(a)}function h$(a,y){var k,z,E,j;return a.a.q?(j=h8(y.a)[0],z=Dt((be(),j).clientX||0)-a.a.A,E=Dt(j.clientY||0)-a.a.B,k=z*z+E*E,k>a.a.k*a.a.k):!1}function xf(a){var y,k,z,E;if(a.kc.a.length==0)return a.xb;for(z=a.xb,y=Ze(a.kc,0),E=y.size(),k=E-1;k>0;k--){if(qi(y.getAtIndex(k).d)<qi(a.zc))return z;--z}return a.xb}function d$(a){var y,k;a.Db&&(y=(a.zc.offsetHeight||0)|0,k=(a.zc.offsetWidth||0)|0,y>a.oc||k>a.pc?(a.oc=y,a.pc=k,a.Ob=-a.a.j,a.Pb=-a.a.L,Vs(a.lc)):(a.oc=y,a.pc=k),T0(a))}function Im(a){var y,k,z;for(z=new kv("[","]"),k=a.Ke();k.Ue();)y=k.Ve(),gA(z,y===a?"(this Collection)":y==null?Ro:wi(y));return z.a?z.e.length==0?z.a.a:z.a.a+(""+z.e):z.c}function yT(a){var y;return a.i&&(y0(a),a.j&&xe(a.d,a.j)),y=no(a.n.qc,new ya(a.o,a.b,a.k,a.c)),y||(y=he((a.d.scrollWidth||0)|0),Zn(a.n.qc,new ya(a.o,a.b,a.k,a.c),y)),y.a}function xT(){hn=mi(Na),yW=mi($_);var a=YB,y=gx;a(y,function(z,E){y[z]=mi(E)});var k=wx;a(k,function(z,E){k[z]=mi(E)}),a(k,function(z,E){ae.addEventListener(z,E,!0)})}function Am(a,y){bo(this,(fe(),W8(ue))),vt(this,Fi(this.Xc)+"-"+Z0,!1),O1(this.Xc,a),this.Xc.className="gwt-MenuItem",Jg(this.Xc,"id",lA(ue)),yd(),jk(nx,this.Xc),this.a=y}function a$(a,y){var k,z,E,j,te;for(j=(te=new di(a.Eb).a.Wf().Ke(),new yr(te));j.a.Ue();)E=(k=j.a.Ve(),k.dg()),z=qe+E.c+Ye+E.k,y&&aa(y.b,z)?za(E):a.r&&bn(a.r,z)&&nw(E)}function p0(a){var y,k;if(a.K.a.length==0)return 0;for(y=0;Vo(a.a,y+1);)++y;return k=new ru,a.ib&&a.ib.a.length>0&&y<=a.ib.a.length?Ms(k,Ze(a.ib,y)):Ms(k,Ze(a.K,y)),bt(k.b)}function Tm(a){var y,k;if(a.ic.a.length==0)return 0;for(y=0;Cn(a.a,y+1);)++y;return k=new ru,a.jb&&a.jb.a.length>0&&y<=a.jb.a.length?Ms(k,Ze(a.jb,y)):Ms(k,Ze(a.ic,y)),bt(k.e)}function g0(a,y){var k,z,E;a.ib&&a.ib.a.length>y-1?(Ut(a.uc,he(y)),z=Ze(a.ib,y-1),Ue(z,Pd)):(Ut(a.tc,he(y)),E=y-a.bb,E>=0&&a.K.a.length>E&&(k=Ze(a.K,E),Ue(k,Pd)))}function w0(a,y){var k,z;a.jb&&a.jb.a.length>y-1?(Ut(a.vc,he(y)),k=Ze(a.jb,y-1),Ue(k,Rd)):(Ut(a.wc,he(y)),z=y-a.db,z>=0&&a.ic.a.length>z&&(k=Ze(a.ic,z),Ue(k,Rd)))}function b$(a,y){No();var k,z;for(z=(Xi(),Al),k=a;y>1;y>>=1)y&1&&(z=Wr(z,k)),k.d==1?k=Wr(k,k):k=new nT(jV(k.a,k.d,Le(gt,yt,17,k.d<<1,15,1)));return z=Wr(z,k),z}function p$(){function a(){try{return new Map().entries().next().done}catch{return!1}}return typeof Map=="function"&&Map.prototype.entries&&a()?Map:iQ()}function Vm(a,y){if(a.s<y){do a.t-=iu(a,a.s),++a.s;while(a.s<y);a.c.style[ii]=a.t+(tt(),ke)}else if(a.s>y){do--a.s,a.t+=iu(a,a.s);while(a.s>y);a.c.style[ii]=a.t+(tt(),ke)}pu(a)}function CT(a){if(H8(),Di(xx,(ht(a),"asking for "+a.k)),XW==a)return Di(xx,(ht(NW),"Returning "+NW.k+" from fake RpcProxy")),new eg;throw we(new mo(""+a+" is not supported"))}function zm(a,y){var k,z,E,j;for(z=0,E=a.length;z<E;z++){j=a[z];try{j[1]?j[0].Jd()&&(y=da(y,j)):j[0].Kd()}catch(te){if(te=Xt(te),ze(te,20))k=te,Qs(),gm(k,!0);else throw we(te)}}return y}function kT(a){var y;a._&&(a.$&&Pn(a.$,!1),a.$=new oI,cg(a.$,a.Q.a),vt(a.$,rE,!0),y=new Pk,n8(y,new cS(new vv(GR(new jC).a.a),new x5(a))),af(a.$,y),Ct((ut(),pt),new C5(a)))}function v0(a,y){var k,z,E;if(E=a.e,!(y==0||a.e==0)){if(z=y>>5,a.d-=z,!Mm(a.a,a.d,a.a,z,y&31)&&E<0){for(k=0;k<a.d&&a.a[k]==-1;k++)a.a[k]=0;k==a.d&&++a.d,++a.a[k]}Ti(a),a.b=-2}}function Em(a,y,k,z){var E,j,te;if(z==0)hl(y,0,a,k,a.length-k);else for(te=32-z,a[a.length-1]=0,j=a.length-1;j>k;j--)a[j]|=y[j-k-1]>>>te,a[j-1]=y[j-k-1]<<z;for(E=0;E<k;E++)a[E]=0}function g$(a,y){Uw(y,"Cannot suppress a null exception."),ua(y!=a,"Exception can not suppress itself."),!a.g&&(a.j==null?a.j=Se(Ce(Zy,1),ve,20,0,[y]):a.j[a.j.length]=y)}function w$(a,y,k){var z,E;z=aH();try{if(xp)try{return t8(a,y,k)}catch(j){if(j=Xt(j),ze(j,20)){E=j,gm(E,!0);return}else throw we(j)}else return t8(a,y,k)}finally{xD(z)}}function ST(a,y){var k,z;a.r!=-1&&zt(a.u[a.r],fE),a.r=y-1,k=a.u[a.r],Ue(k,fE),a.s>a.r?Vm(a,a.r):qi(a.k)<(be(),Ie).Wd(k)+((k.offsetWidth||0)|0)&&!a.d&&(z=Km(a,a.r),Vm(a,z))}function v$(a,y){var k,z,E;if(a.b.a.length!=0){for(z=new Fe(a.b);z.a<z.c.a.length;)if(k=He(z),E=null.pg(),ye(y.substr(0,E.length),E)){HG(a,null.qg+" "+null.qg),Jh(a.b,k);return}}}function Ws(a,y){var k,z;!y.e||y.me(),z=y.f,bK(y,a.b);try{sG(a.a,y)}catch(E){throw E=Xt(E),ze(E,89)?(k=E,we(new Ig(k.a))):we(E)}finally{z==null?(y.e=!0,y.f=null):y.f=z}}function m0(a){try{var y=ae.document.body,k=y.currentStyle?y.currentStyle:getComputedStyle(y);if(k&&k.position=="relative")return y.getBoundingClientRect()[a]}catch{}return 0}function m$(a,y){var k,z,E,j,te;for(j=(te=new di(a.Eb).a.Wf().Ke(),new yr(te));j.a.Ue();)E=(k=j.a.Ve(),k.dg()),z=qe+E.c+Ye+E.k,y&&bn(y.a,z)?Va(E):a.tb&&a.tb.contains(z)&&iw(E)}function y$(){for(var a=document.createElement(LE),y=["animation","oAnimation","mozAnimation","webkitAnimation"],k=0;k<y.length;k++)if(a.style[y[k]]!==void 0)return y[k]}function hs(a){var y,k;return a>=jf?(y=55296+(a-jf>>10&1023)&Rs,k=56320+(a-jf&1023)&Rs,String.fromCharCode(y)+(""+String.fromCharCode(k))):String.fromCharCode(a&Rs)}function IT(a,y){this.c=new Ot,this.a=new Ot,this.b=new Ot,this.d=Le(ct,Mi,2,0,6,1),a&&(this.e=new IA,L_(this.e,a,y),uG(this.e,new jA),this.f=pi(this.e),q1(FH(y),this.f))}function AT(a,y){var k,z,E,j;return k=Nt(a.a,y),k||(z=new Ka(y),E=(_h(),oi?null:z.c),j=Zo(E,0,ae.Math.max(0,cw(E,hs(46)))),dP(z,AT(a,j)),Te(a.a,oi?null:z.c,z),z)}function TT(a,y){var k,z,E,j;E=qe+y.col1+Ye+y.row1,j=no(a.Eb,he(y.id)),$u(a.Kb,y),zV(a,y,j),z=j.d,bn(a.b,E)&&(k=Nt(a.b,E),ye(Ru(z.style),(It(),tn))?(Pn(k,!1),lt(k.i)):pd(k))}function x$(a,y,k){var z,E,j,te,ne;for(j=(lm(),Se(Ce(Op,1),ve,77,0,[Ex,Ox,zx,Vx,jx])),te=0,ne=j.length;te<ne;++te)E=j[te],z=y+"-"+OA(E.b!=null?E.b:""+E.c,(_c(),Wp)),k==E?Ue(a,z):zt(a,z)}function VT(){VT=ge,ZW=Se(Ce(ct,1),Mi,2,6,["Sun","Mon","Tue","Wed","Thu","Fri","Sat"]),eK=Se(Ce(ct,1),Mi,2,6,["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"])}function C$(){Bd={},!Array.isArray&&(Array.isArray=function(y){return Object.prototype.toString.call(y)==="[object Array]"});function a(){return new Date().getTime()}!Date.now&&(Date.now=a)}function so(a){var y,k,z;for(k=a.length,z=0;z<k&&(Tt(z,a.length),a.charCodeAt(z)<=32);)++z;for(y=k;y>z&&(Tt(y-1,a.length),a.charCodeAt(y-1)<=32);)--y;return z>0||y<k?a.substr(z,y-z):a}function zT(){Mg.call(this),this.d=(fe(),tI(ue)),this.c=eI(ue),xe(this.d,Vr(this.c)),xs(this,this.d),this.a=(l9(),kW),this.b=(nA(),AW),this.d.cellSpacing="0",this.d.cellPadding="0"}function co(){ei();var a;this.a=new hz(P8()),this.a.j&&(a=OD(),a!=-1&&v8(this.a,a)),this.a.e?this.b=Rz in window:this.a.j?this.b=!!navigator.msMaxTouchPoints:this.b=!this.a.p&&aq()}function k$(a){var y,k,z,E,j;return a.k<3?(Di(jn((ht(fi),fi.k)),"Not enough data for speed calculation"),0):(z=a.k%3,y=a.s[z],k=a.b[z],z+=3,--z,z=z%3,E=a.s[z],j=a.b[z],(y-E)/(j-k))}function jm(a,y){J1();var k,z,E,j;for(k=null,j=a.Ke();j.Ue();){E=j.Ve();try{y.Me(E)}catch(te){if(te=Xt(te),ze(te,20))z=te,!k&&(k=new Si),Zn(k.a,z,k);else throw we(te)}}if(k)throw we(new FC(k))}function sd(a,y,k){var z,E,j,te;for(z=(!An&&(An=new Xs),An).c.d[new Ee(y).b],z||(z={},a.d[new Ee(y).b]=z),j=new v1(k.c.b.Ke());j.b.Ue();)E=j.b.Ve(),te=z[E],te||(te=[],z[E]=te),te.push(k)}function Om(){Om=ge,Kx=new Vh("WEBSOCKET",0,"websocket"),HW=new Vh("WEBSOCKET_XHR",1,"websocket-xhr"),FW=new Vh("STREAMING",2,"streaming"),Wx=new Vh("LONG_POLLING",3,"long-polling")}function y0(a){a.d.style[qr]=(ts(),dt),a.o==null||a.o.length==0?(xo(a.d,""),a.d.style[uo]=""):(a.d.style[uo]="1",a.f&&a.cf()>0&&u9(a.n,a.b,a.o)>a.cf()?xo(a.d,"###"):xo(a.d,a.o)),sA(a)}function Xm(a,y,k,z){var E,j;ye(k.substr(0,1),"-")?(j=1,ye(y.substr(y.length-j,j),"-")&&qh(k,"-","")):(E=1,ye(y.substr(y.length-E,E),"-")||(y+="-")),a.vf().pd(y+(""+k),z)}function dl(a,y,k){if(!a.sheet.cssRules[k])return-1;var z=a.sheet.cssRules[k].selectorText,E=a.sheet.cssRules[k].cssText.replace(z,y);return a.sheet.deleteRule(k),a.sheet.insertRule(E,k)}function Cf(a){if(Uy==null&&(Uy=new RegExp("^\\s*[+-]?(NaN|Infinity|((\\d+\\.?\\d*)|(\\.\\d+))([eE][+-]?\\d+)?[dDfF]?)\\s*$")),!Uy.test(a))throw we(new yo(Ef+a+'"'));return parseFloat(a)}function ET(a,y){var k,z,E;return y&=63,y<22?(k=a.l<<y,z=a.m<<y|a.l>>22-y,E=a.h<<y|a.m>>22-y):y<44?(k=0,z=a.l<<y-22,E=a.m<<y-22|a.l>>44-y):(k=0,z=0,E=a.l<<y-44),Zt(k&wn,z&wn,E&Li)}function Mr(a,y){for(var k=y.length,z=0,E=0,j=0,te=0,ne=0;z<k&&(E=y.charCodeAt(z),E===32?j=j+1:E>47&&E<58&&(j===0?ne=ne*10+E-48:te=te*10+E-48),j!==2);)z++;a.b=te,a.a=ne}function Wm(a,y){var k,z,E;a.R=!0,dl(a.$,up,0),a.S=y,E=Ha(a),E&&(Fl(E,null),z=y.Wc,z&&a!=z&&br(y),k=E.d,Ue(k,pE),xe(k,(fe(),y.Xc)),(!z||z&&a!=z)&&qn(y,a),Ct((ut(),pt),new oh(a)))}function qn(a,y){var k;if(k=a.Wc,y){if(k)throw we(new mo("Cannot set a new parent without first clearing the old parent"));a.Wc=y,y.ud()&&a.vd()}else try{k&&k.ud()&&a.xd()}finally{a.Wc=null}}function S$(a,y,k,z){var E,j,te,ne;ne=(fe(),a.Xc),te=kP(ue),te.text=y,te.removeAttribute(qz),te.value=k,j=(be(),ne).options.length,(z<0||z>j)&&(z=j),z==j?WC(ne,te,null):(E=ne.options[z],WC(ne,te,E))}function jT(a,y){a.b!=y&&(y?(a.a.innerHTML="+",Sn((fe(),a.Xc),"minus",!1),Sn(a.Xc,"plus",!0)):(a.a.innerHTML="&#x2212;",Sn((fe(),a.Xc),"plus",!1),Sn(a.Xc,"minus",!0)),a.b=y)}function Km(a,y){var k;for(k=((a.k.offsetWidth||0)|0)-((a.i.offsetWidth||0)|0),ye(Ru(a.f.style),tn)||(k-=(a.f.offsetWidth||0)|0),k=bt(k-iu(a,y));y>0&&k-iu(a,y-1)>0;)--y,k=bt(k-iu(a,y));return y}function I$(a){var y,k,z,E;for(Pl(a.q),k=(E=new di(a.b).a.Wf().Ke(),new yr(E));k.a.Ue();)y=(z=k.a.Ve(),z.dg()),Pn(y,!1),lt(y.i);Mt(a.b),a.r&&Mt(a.r),a.i&&Mt(a.i),a.tb&&a.tb.clear()}function OT(a){var y,k,z,E;for(k=(E=new Gr(a.F.a).a.Wf().Ke(),new po(E));k.a.Ue();)y=(z=k.a.Ve(),z.cg()),y.d.style[ml]="",y.d.style[_f]="";Mt(a.F.a),a.i.a=Le(Ke,ve,1,0,5,1),Mt(a.D),ns(a.r)}function Lm(a,y,k,z,E){var j,te,ne,ie;if(j=z-k,j<7){_F(y,k,z);return}if(ne=k+E,te=z+E,ie=ne+(te-ne>>1),Lm(y,a,ne,ie,-E),Lm(y,a,ie,te,-E),_w(a[ie-1],a[ie])<=0){for(;k<z;)y[k++]=a[ne++];return}PF(a,ne,ie,te,y,k,z)}function A$(a){var y;a.c==null&&(y=Lt(a.b)===Lt(ix)?null:a.b,a.d=y==null?Ro:tl(y)?y==null?null:y.name:Qo(y)?"String":Ml(cu(y)),a.a=a.a+": "+(tl(y)?y==null?null:y.message:y+""),a.c="("+a.d+") "+a.a)}function Mm(a,y,k,z,E){var j,te,ne;for(j=!0,te=0;te<z;te++)j=j&k[te]==0;if(E==0)hl(k,z,a,0,y),te=y;else{for(ne=32-E,j=j&k[te]<<ne==0,te=0;te<y-1;te++)a[te]=k[te+z]>>>E|k[te+z+1]<<ne;a[te]=k[te+z]>>>E,++te}return j}function x0(a,y,k,z){var E,j,te,ne,ie;for(y.ze(z+k+a),hH(a,y,z),j=(a.j==null&&(a.j=Le(Zy,ve,20,0,0,1)),a.j),te=0,ne=j.length;te<ne;++te)E=j[te],x0(E,y,"Suppressed: ","	"+z);ie=a.e,ie&&x0(ie,y,"Caused by: ",z)}function T$(a,y){var k,z,E,j;return y&=63,k=a.h&Li,y<22?(j=k>>>y,E=a.m>>y|k<<22-y,z=a.l>>y|a.m<<22-y):y<44?(j=0,E=k>>>y-22,z=a.m>>y-22|a.h<<44-y):(j=0,E=0,z=k>>>y-44),Zt(z&wn,E&wn,j&Li)}function XT(a,y){var k,z,E,j,te,ne;switch(a.i||(y=1-y),te=0,E=0,j=0,k=0,z=bt(y*a.d),ne=bt(y*a.e),0){case 0:te=a.d-z>>1,E=a.e-ne>>1,j=E+ne,k=te+z}(Qr(),li).bf(Re(a.a),"rect("+te+"px, "+j+"px, "+k+"px, "+E+"px)")}function WT(a,y){var k,z,E,j,te,ne,ie,se,ce;if(a.sf(cI(a)),k=TB(a.mg),k){for(E=new Si,ce=Hq(k),z=0;z<ce.length;z++)if(se=ce[z],y.Df(se))for(ie=k[se],j=0;j<ie.length;j++)te=ie[j],ne=Zn(E.a,te,E),ne==null&&lU(te,y)}}function C0(a,y,k,z){var E,j;if(j=0,E=0,k<0)if(y>1){for(;y>1&&E>k;)--y,E-=a[y-1];z&&E<k&&++y,j=y}else j=1;else if(y<a.length){for(;y<=a.length&&E<k;)E+=a[y-1],++y;j=y}else j=a.length;return z?j:j-1}function V$(a){return a.a.t==5?"v-android":a.a.t==4?"v-ios v-ios"+a.a.u:a.a.t==1?"v-win":a.a.t==3?"v-lin":a.a.t==2?"v-mac":null}function z$(a,y,k){var z,E;if(k<0||k>a.b.a.length)throw we(new Xl);for(Eh(a.b,k,y),E=0,z=0;z<k;z++)ze(Ze(a.b,z),97)&&++E;return Eh(a.f,E,y),XF(a,k,(fe(),y.Xc)),vt(y,Fi(y.Xc)+"-"+Z0,!1),i$(a,y),y}function E$(a,y,k){var z;a.b=y,a.a=k,z=y.sb,Xn(z,a,(Vw(),Vw(),Gd)),Xn(z,a,(Th(),Th(),Gf)),Xn(z,a,(jw(),jw(),Jd)),Xn(z,a,(Ew(),Ew(),Qd)),Xn(z,a,(Ao(),Ao(),ws)),Xn(z,a,(Nw(),Nw(),e1)),Xn(z,a,(dw(),dw(),t1))}function ds(a,y,k){var z,E,j,te,ne,ie,se,ce;if(a==null||a.length==0||ye(Ro,a))return null;for(j=dm(a),z=new Ot,E=0;E<(ie=S9(j),ie).length;E++)te=(ne=S9(j),ne)[E],se=(ce=j[te],ce),Zn(z,y.Kf(te),k.Kf(se));return z}function kf(a){var y,k;y=-dn(a.zc),k=-((a.zc.scrollTop||0)|0),a.Pc.style[ii]=y+(tt(),ke),a.I.style[ii]=y+ke,a.c.style[ps]=k+ke,a.gc.style[ps]=k+ke,a.D.style[ii]=y-a.g+ke,a.cc.style[ps]=k-a.f+ke}function Nm(a,y){xn(),y?(a.ondrag=null,a.onselectstart=null,a.style.webkitUserSelect="text"):(a.ondrag=function(){return!1},a.onselectstart=function(){return!1},a.style.webkitUserSelect=tn)}function xt(a,y){if(a){for(var k=[],z=0;z<y.length;z++){var E=y[z],j=Object.getOwnPropertyNames(E).find(function(ne){return/^(a|value_0|value.*g\$)$/.test(ne)}),te=j?E[j]:E;k.push(te)}a(k)}}function KT(a){var y,k,z,E,j;if(a.tb){if(a.b)for(z=new hr(new or(a.b).a);z.b;)k=Xr(z),j=k.cg(),y=k.dg(),E=a.tb.contains(j)?a.ub:null,k0(y,E);a.q&&(E=a.tb.contains(a.j)?a.ub:null,k0(a.q,E))}}function LT(a,y,k){var z,E,j;y.col1<=a.ob&&y.col2>a.ob&&(z=a.a.g,j=Wo(z,y.col1,a.ob+1),E=Wo(z,a.ob+1,y.col2+1)-dn(a.zc)+1,E>0?(j+=E,k.d.style[G2]=""):k.d.style[G2]="0",k.d.style[mt]=j+(tt(),ke))}function MT(a){(!a.K&&(a.K=new Cr),a.K).c?(!a.C&&(a.C=new un),a.C).p?DF((!a.C&&(a.C=new un),a.C)):(!a.d&&(a.d=new M5(a)),$C((!a.C&&(a.C=new un),a.C),a.d)):$C((!a.C&&(a.C=new un),a.C),null)}function gu(a,y){var k,z;k=F1(y,hs(46)),k<0&&(k=y.length),a.b=Wi(Uh(y,0,k)),z=N7(y,hs(46),k+1),z<0&&(z=y.length);try{a.c=Wi(Dn(Uh(y,k+1,z),"[^0-9].*",""))}catch(E){if(E=Xt(E),!ze(E,46))throw we(E)}}function j$(a){var y,k,z;for(Mo(a,null),y=a.i?a.d:Ug(a.d);fe(),an.Ce(y)>0;)Jo(y,an.Be(y,0));for(z=new Fe(a.b);z.a<z.c.a.length;)k=He(z),k.Xc.colSpan=1;a.f.a=Le(Ke,ve,1,0,5,1),a.b.a=Le(Ke,ve,1,0,5,1)}function It(){It=ge,$f=new tS,Ud=new VS,wX=new o7,rx=new o8,mX=new s8,yX=new D7,xX=new s7,CX=new zS,kX=new x8,AX=new N8,VX=new q8,TX=new F8,EX=new M8,SX=new e8,IX=new y8,zX=new Z7,gX=new W7,pX=new TS,vX=new r8}function O$(a,y,k){var z,E,j;if(k<0||k>a.c)throw we(new Xl);if(a.c==a.a.length){for(j=Le(cX,ve,13,a.a.length*2,0,1),E=0;E<a.a.length;++E)j[E]=a.a[E];a.a=j}for(++a.c,z=a.c-1;z>k;--z)a.a[z]=a.a[z-1];a.a[k]=y}function Rm(a,y){if(fh(),a._vaadin_animationend_callbacks){for(var k=a._vaadin_animationend_callbacks,z=0;z<k.length;z++)if(k[z].listener==y)return a.removeEventListener(yx,k[z],!1),!0;return!1}}function X$(a){var y,k,z,E,j,te;for(y=Le(bQ,{734:1,3:1},177,a.a.a.length,0,1),y=td(a.a,y),k=new mg,E=y,j=0,te=E.length;j<te;++j)z=E[j],Jh(a.a,z),bv(z.a,k.a);a.a.a.length>0&&gn(a.b,ae.Math.max(5,16-(jr()-k.a)))}function W$(a){var y,k,z,E,j;if(k=a.size(),k==0)return null;for(y=new Bu(k==1?"Exception caught: ":k+" exceptions caught: "),z=!0,j=a.Ke();j.Ue();)E=j.Ve(),z?z=!1:y.a+="; ",rt(y,E.Gd());return y.a}function NT(a,y){k1(),kA.call(this,dI(ue)),(fe(),this.Xc).className="gwt-TextArea",this.c=a,this.a=y,this.Xc.style[as]=(Ju(),Su),this.Xc.style[uo]="1",this.Xc.style[vn]=(tt(),"-1000.0px"),lN(this.Xc.style)}function cd(a){var y,k,z,E,j,te;for(te=a.bb,y=bi(a.zc),E=new st,j=0,j=0;j<a.kc.a.length;j++)Cn(a.a,j+1)||(E=Ze(a.kc,j));for(z=new Fe(E);z.a<z.c.a.length;){if(k=He(z),bi(k.d)>=y)return te;++te}return a.bb}function RT(a,y){S8(a),tf(a.zc),(a.rc!=a.Jc||a.sc!=a.Kc)&&a.Jc!=-1&&a.Kc!=-1?e2(a.a,a.rc,a.Jc,a.sc,a.Kc):B0(a.a,a.Jc,a.Kc,($g(Kr(y)),!!(be(),y).shiftKey),!!y.metaKey||!!y.ctrlKey,!0),a.xc=!1,a.Jc=-1,a.Kc=-1}function K$(a,y){var k,z,E,j,te,ne,ie,se;for(E=JA(a),te=0,ie=E.length;te<ie;++te)k=E[te],k.ye(y);for(se=!oi&&a.e?oi?null:a.d:null;se;){for(z=JA(se),j=0,ne=z.length;j<ne;++j)k=z[j],k.ye(y);se=!oi&&se.e?oi?null:se.d:null}}function PT(a,y){sr(a.a,y),Av(a.a),rn(a.f)&&(rn(a.a)||rn(a.g)||ye((It(),vi),Ru(a.e.style)))?(Cs(a.f).className||"").indexOf(Ri)!=-1||vt(a.f,Ri,!0):(Cs(a.f).className||"").indexOf(Ri)!=-1&&vt(a.f,Ri,!1)}function _T(a,y){sr(a.g,y),Av(a.g),rn(a.f)&&(rn(a.a)||rn(a.g)||ye((It(),vi),Ru(a.e.style)))?(Cs(a.f).className||"").indexOf(Ri)!=-1||vt(a.f,Ri,!0):(Cs(a.f).className||"").indexOf(Ri)!=-1&&vt(a.f,Ri,!1)}function k0(a,y){sr(a.f,y),Av(a.f),rn(a.f)&&(rn(a.a)||rn(a.g)||ye((It(),vi),Ru(a.e.style)))?(Cs(a.f).className||"").indexOf(Ri)!=-1||vt(a.f,Ri,!0):(Cs(a.f).className||"").indexOf(Ri)!=-1&&vt(a.f,Ri,!1)}function L$(a,y){a.vf().pd("v-disabled",!y),ze(a.vf(),73)&&a.vf().Ad(y),ze(a,136)||Tr(jn((ht(ju),ju.k)),"Parent of connector "+CI(a)+" is null. This is typically an indication of a broken component hierarchy")}function BT(a,y,k,z,E){var j,te,ne,ie;for(fm(a),ie=z;ie<=E;ie++)for(j=y;j<=k;j++)(a.rc!=j||a.sc!=ie)&&(te=Rt(a,j,ie),Ut(a.u,new Co(j,ie)),te&&(Ut(a.t,te),Ue(te.d,Ji)),ne=Ui(a,qe+j+Ye+ie),ne&&(Ut(a.t,ne),Ue(ne.d,Ji)))}function DT(a,y){if(a.b)return!0;if(a.c)return $H(y,a.c);if(a.a)return $R(a.a,y);throw we(new mo("StateChangeEvent should have either stateJson, changedProperties or changePropertiesSet"))}function zt(a,y){var k,z,E,j,te;return y=Vg(y),te=a.className||"",E=Dm(te,y),E!=-1?(k=so(te.substr(0,E)),z=so(Zs(te,E+y.length)),k.length==0?j=z:z.length==0?j=k:j=k+" "+z,a.className=j||"",!0):!1}function Pm(a){var y,k,z;if(a.d=!1,lt(a.g),k=a.u[a.r],k.style[mt]="",z=a.g.value,iG(z)&&!ye(a.b,z)){for(y=0;y<a.u.length;y++)if(ye(z,$g(a.u[y]))){sf(k,a.b);return}UM(a.e,a.r,z),sf(k,z),pu(a)}else sf(k,a.b)}function M$(a,y){var k,z;tf((fe(),a.Xc)),a.Ub.className=lp,zt(a.Vb,qe+a.$b),Re(a.yc).style[ii]="",a.Zb&&(k=new Ot,z=y-a.Sb,z<0&&(z=0),z!=Ft(a.a,a.$b)&&Zn(k,he(a.$b),he(z)),k.a.c+k.b.c==0||YU(a.a,k)),a.$b=-1}function _m(a,y,k){var z,E,j,te,ne;if(ne=y==null?0:(te=oo(y),te|0),E=(z=a.a.get(ne),z??new Array),E.length==0)a.a.set(ne,E);else if(j=h9(y,E),j)return j.eg(k);return E[E.length]=new Bg(y,k),++a.c,Lh(a.b),null}function N$(a,y){var k,z,E;return k=new Bi,rt(k,(z=new G7(y.c),E=new Bi,rt(E,aV(z)),E.a+=" ",rt(E,y.b),E.a+=`
`,rt(E,y.a.Pf()),E.a+=": ",E.a)),rt(k,y.d),a.a&&y.e&&(k.a+=`
`,x0(y.e,new L8(k),"","")),k.a}function qT(a,y,k,z,E,j){var te,ne,ie,se,ce;for(Lt(a)===Lt(k)&&(a=a.slice(y,y+E),y=0),ie=k,ne=y,se=y+E;ne<se;)te=ae.Math.min(ne+1e4,se),E=te-ne,ce=a.slice(ne,te),ce.splice(0,0,z,j?E:0),Array.prototype.splice.apply(ie,ce),ne=te,z+=E}function S0(a){if(!a.ud())throw we(new mo("Should only call onDetach when the widget is attached to the browser's document"));try{a.zd(),Sa(a,!1)}finally{try{a.sd()}finally{fe(),a.Xc.__listener=null,a.Tc=!1}}}function FT(a){var y,k;if(a.ob<a.ib.a.length)for(;a.ib.a.length>a.ob;)lt(Or(a.ib,a.ib.a.length-1));else for(k=a.ib.a.length+1;k<=a.ob;k++)y=Oe(ue),O1(y,Rv(k)+fp),y.className=ty+k||"",St(a.ib,y),xe(a.Nc,y)}function R$(a){if(a.nodeType!=1)return{};if(ae.document.defaultView&&ae.document.defaultView.getComputedStyle)return ae.document.defaultView.getComputedStyle(a,null);if(a.currentStyle)return a.currentStyle}function P$(a,y,k){var z;if(!y)throw we(new ys("Cannot add a handler with a null type"));if(!k)throw we(new ys("Cannot add a null handler"));return a.b>0?I8(a,new II(a,y,k)):(z=I9(a,y,null),z.add(k)),new SI(a,y,k)}function Ks(a,y,k,z){var E;a.V._||(E=_D(a.V,y,k),E!=null&&E.length!=0?(Q8(a.u,E),a9(a.V,"="+E)):ch(a.u,YD(a.V,y,k))),a.e=Nq(a.V,y,k),a.o?Wm(a.V,Gv(a.p,Hl(a.V))):sh(a.u,!a.e),z!=null?Vc(a.u,z):Vc(a.u,uf(y,k))}function Bm(a){return fh(),a.webkitAnimationName?a.webkitAnimationName:a.animationName?a.animationName:a.mozAnimationName?a.mozAnimationName:a.oAnimationName?a.oAnimationName:""}function Dm(a,y){var k,z,E;for(k=a.indexOf(y);k!=-1&&!((k==0||(Tt(k-1,a.length),a.charCodeAt(k-1)==32))&&(z=k+y.length,E=a.length,z==E||z<E&&(Tt(z,a.length),a.charCodeAt(z)==32)));)k=a.indexOf(y,k+1);return k}function _$(a){var y;return!a.t&&(y=(ei(),!Ht&&(Ht=new co),ei(),Ht),y.a.j&&nv(y))&&(a.t=z_(ue),a.t.style[as]=(Ju(),Su),a.t.style.borderStyle=(pv(),tn),a.t.tabIndex=-1,a.t.frameBorder=0,a.t.marginHeight=0),a.t}function B$(a,y){var k,z,E;if(wR(Re(a.B)),kg(a.B,""),y&&y.a.length!=0){for(ai(a.B,!0),ai(a.C,!0),z=new Fe(y);z.a<z.c.a.length;)k=He(z),kg(a.B,k);$v(a,(E=Gt(a.a),E??""))}else ai(a.B,!1),ai(a.C,!1)}function HT(a,y){a.T!=y&&(a.T=y,y?Sn((fe(),a.Xc),"protected",!0):Sn((fe(),a.Xc),"protected",!1),a.C&&(y?a.o&&(a.o=!1,yf(a.V)):(a.e=!1,Lr(a.Q),a.o&&(qa(a.W,a.V.sc,a.V.rc,!1),gn(a.s,200)))))}function D$(a,y){var k,z,E,j,te,ne,ie;if(a.b){for(j=(ie=new Gr(a.a.p.a).a.Wf().Ke(),new po(ie));j.a.Ue();)k=(ne=j.a.Ve(),ne.cg()),zt(k,Ly);Mt(a.a.p.a)}for(z=y,E=0,te=z.length;E<te;++E)k=z[E],Ue(k,Ly),a.b&&Ut(a.a.p,k)}function qm(a){var y,k;return a>-0x800000000000&&a<0x800000000000?a==0?0:(y=a<0,y&&(a=-a),k=bt(ae.Math.floor(ae.Math.log(a)/.6931471805599453)),(!y||a!=ae.Math.pow(2,k))&&++k,k):m9(lr(a))}function q$(a,y){if(Element.prototype.getBoundingClientRect)return y.getBoundingClientRect().top+a.scrollTop|0;var k=y.ownerDocument;return k.getBoxObjectFor(y).screenY-k.getBoxObjectFor(k.documentElement).screenY}function F$(a,y){if(Element.prototype.getBoundingClientRect)return y.getBoundingClientRect().left+a.scrollLeft|0;var k=y.ownerDocument;return k.getBoxObjectFor(y).screenX-k.getBoxObjectFor(k.documentElement).screenX}function H$(a,y,k){var z,E,j,te,ne,ie,se;for(ne=new Si,E=new hr(new or(a.Bc).a);E.b;)z=Xr(E),te=z.dg(),Ut(ne,""+te.b);for(se=Le(ct,Mi,2,Mu(ne.a),6,1),uT(ne,se),ie=Y$(y,se),j=0;j<ie.length;j++)et(k,ie[j],0)!=-1||St(k,ie[j])}function Fm(a,y){fh();var k=mi(function(z){y.Af(z)});return k.listener=y,a.addEventListener(yx,k,!1),!a._vaadin_animationend_callbacks&&(a._vaadin_animationend_callbacks=[]),a._vaadin_animationend_callbacks.push(k),k}function Hm(a,y){switch(fe(),Hn((be(),y).type)){case Bs:if(y.touches.length>1)return;case 4:VG(a.F,y);break;case 8:case ui:case Au:n_(a.Xc);case 8192:xU(a.F);break;case 64:KV(a.F,y);break;case wl:KV(a.F,y),Ie.Vd(y)}}function $$(a,y){var k,z,E;if(Lt(a)===Lt(y))return!0;if(a==null||y==null||a.length!=y.length)return!1;for(k=0;k<a.length;++k)if(z=a[k],E=y[k],!(z==E||z!=null&&ye(z,E)))return!1;return!0}function $m(a){Qr();var y,k,z;return k=null.pg(),k+="-overlays",y=(fe(),qR(ue,k)),y||(y=Oe(ue),y.id=k,z=pi(a.d).Wc.md().className||"",z!=null&&z.length!=0&&Ue(y,z),Ue(y,"v-overlay-container"),xe(Re((ci(),uu())),y)),y}function I0(a,y,k,z,E){a.J.style[ot]=(y&&!a.H?(at(),er):(at(),Zi)).ie(),a.p.style[ot]=(E&&!a.n?(at(),er):(at(),Zi)).ie(),a.A.style[ot]=(k&&!a.v?(at(),er):(at(),Zi)).ie(),a.d.style[ot]=(z&&!a.b?(at(),er):(at(),Zi)).ie()}function U$(a){a.c<0?(dT(a,0,a.c),a.c=0):a.c>((a.q.scrollHeight||0)|0)-(a.q.clientHeight|0)?(dT(a,((a.q.scrollHeight||0)|0)-(a.q.clientHeight|0),a.c),a.c=((a.q.scrollHeight||0)|0)-(a.q.clientHeight|0)):km(a)}function G$(a,y){var k,z,E;z=Kr(y),E=(be(),z).getAttribute(Gi)||"",qt(z)&&eo(qt(z)).indexOf(yl)!=-1&&E!=null&&E.indexOf(rp)!=-1&&(k=a.c.wb,bu(E)==0&&(Mr(k,E),sU(a.c.a,k.a,k.b,Ie._d(z))),y.stopPropagation())}function $T(a){var y,k,z,E,j;for(y=new ef(a.Mc),E=new Fe(a.Qc);E.a<E.c.a.length;)k=He(E),Os(y,k);for(j=new Fe(a.d);j.a<j.c.a.length;)k=He(j),Os(y,k);for(z=new Fe(a.kc);z.a<z.c.a.length;)k=He(z),Os(y,k);return y}function Q$(){var a=document.createElement(LE),y={animationName:ME,OAnimationName:"oAnimationEnd",MozAnimation:ME,WebkitAnimation:"webkitAnimationEnd"};for(var k in y)if(a.style[k]!==void 0)return y[k]}function UT(a,y,k){var z,E,j;y.row1<=a.Sc&&y.row2>a.Sc&&(j=a.a.V.W,E=Wo(j,y.row1,a.Sc+1),z=Wo(j,a.Sc+1,y.row2+1)+1-((a.zc.scrollTop||0)|0),z>0?(E+=z,k.d.style[Q2]=""):k.d.style[Q2]="0",k.d.style[Bt]=E+(tt(),ke))}function J$(){function a(z){return parseInt(z[1])*_r+parseInt(z[2])}var y=navigator.userAgent;if(y.indexOf("Macintosh")!=-1){var k=/rv:([0-9]+)\.([0-9]+)/.exec(y);if(k&&k.length==3&&a(k)<=1008)return!0}return!1}function GT(a){var y,k;if(a.Sc<a.jb.a.length)for(;a.jb.a.length>a.Sc;)lt(Or(a.jb,a.jb.a.length-1));else for(y=a.jb.a.length+1;y<=a.Sc;y++)k=Oe(ue),k.innerHTML=""+y+fp||"",k.className=ny+y||"",St(a.jb,k),xe(a.Nc,k)}function QT(a,y,k){var z,E,j,te;z=qe+y+Ye+k,!bn(a.b,z)&&(te=Ui(a,z),te?E=te.d:(E=Rt(a,y,k).d,yK(a.q,qt((be(),E)))),PT(a.q,Nt(a.i,z)),_T(a.q,Nt(a.r,z)),j=a.tb.contains(z)?a.ub:null,k0(a.q,j),wU(a.q,E,k,y),a.j=z)}function Y$(a,y){for(var k=[],z=a.sheet.cssRules?a.sheet.cssRules:a.sheet.rules,E=0;E<z.length;E++)for(var j=z[E],te=0;te<y.length;te++)j.selectorText.indexOf(".row"+y[te]+",")!==-1&&k.push(j.cssText);return k}function Z$(a){return a.e<=-32||a.e>(a.d>0?a.d:ae.Math.floor((a.a-1)*pp)+1)?0:q_(a.e==0||a.a==0&&a.f!=-1?(!a.c&&(a.c=ss(a.f)),a.c):a.e<0?Wr((!a.c&&(a.c=ss(a.f)),a.c),O0(-a.e)):c2((!a.c&&(a.c=ss(a.f)),a.c),O0(a.e)))}function eU(a,y,k,z,E){var j,te,ne,ie;if(Lt(a)===Lt(y)&&z==E){jV(a,z,k);return}for(ne=0;ne<z;ne++){for(te=0,j=a[ne],ie=0;ie<E;ie++)te=Vt(Vt(Oi(Ve(j,Xe),Ve(y[ie],Xe)),Ve(k[ne+ie],Xe)),Ve(_e(te),Xe)),k[ne+ie]=_e(te),te=Yn(te,32);k[ne+E]=_e(te)}}function tU(a,y){var k,z,E;return k=a.r,z=y>=a.t+a.k,a.p&&!z?(E=(y-a.t)/a.k,a.ed(a.ad(E)),a.o&&a.r==k):!a.p&&y>=a.t&&(a.p=!0,a.dd(),!(a.o&&a.r==k))?!1:z?(a.o=!1,a.p=!1,a.cd(),!1):!0}function JT(a,y){var k,z,E,j;for(E=a.a.L,j=y-E,k=y+a.oc+E,j<0&&(j=0),z=a.a.O;a.Ab<k&&a.zb<z;)a.eb+Ai(a,a.db)<j&&(a.eb+=Ai(a,a.db),++a.db),++a.zb,a.Ab+=Ai(a,a.zb);for(;j>a.eb+Ai(a,a.db)&&a.db<z;)a.eb+=Ai(a,a.db),++a.db;W0(a)}function pr(a,y){var k=ae;if(a==="")return k;var z=a.split(".");if(!(z[0]in k)&&k.execScript&&k.execScript("var "+z[0]),y){var E=y.prototype.mg;E.e=y}for(var j;z.length&&(j=z.shift());)k=k[j]=k[j]||!z.length&&y||{};return k}function YT(){var a=/rv:([0-9]+)\.([0-9]+)(\.([0-9]+))?.*?/.exec(navigator.userAgent.toLowerCase());if(a&&a.length>=3){var y=parseInt(a[1])*1e6+parseInt(a[2])*_r+parseInt(a.length>=5&&!isNaN(a[4])?a[4]:0);return y}return-1}function Um(a,y){var k;if(a.bb)throw we(new mo("Composite.initWidget() may only be called once."));if(!y)throw we(new ys("widget cannot be null"));ze(y,179),br(y),k=(fe(),y.Xc),bo(a,k),yg(),UD(k)&&FR(k,a),a.bb=y,qn(y,a)}function nU(a,y,k){var z,E;switch(k.type){case"IMAGE":Y8((!a.C&&(a.C=new un),a.C),y,new R8(E6(a.D,y)),k);break;case"COMPONENT":z=u0(y,zs(a.e,"appId")),E=new f0("overlay-component-"+y,z,a.e),Y8((!a.C&&(a.C=new un),a.C),y,E,k)}}function wu(a){var y,k,z;return a<0?0:a==0?32:(z=-(a>>16),y=z>>16&16,k=16-y,a=a>>y,z=a-256,y=z>>16&8,k+=y,a<<=y,z=a-4096,y=z>>16&4,k+=y,a<<=y,z=a-bl,y=z>>16&2,k+=y,a<<=y,z=a>>14,y=z&~(z>>1),k+2-y)}function Gm(a,y){var k;a.a!=null&&((!a.C&&(a.C=dd(a)),a.C).Wc.pd(a.a,!1),zt($m(a.D),a.a)),a.a=y,y!=null&&((!a.C&&(a.C=dd(a)),a.C).Wc.pd(y,!0),Ue($m(a.D),a.a),GU(y)),null.pg(),k=new B6,a.F&&Ws(a.F,k),zn(),Ll(),null.pg()}function al(a,y){var k;if(y<0)throw we(new Jr("Negative exponent"));if(y==0)return Al;if(y==1||t0(a,Al)||t0(a,Do))return a;if(!rV(a,0)){for(k=1;!rV(a,k);)++k;return Wr(iH(k*y),al(Ma(a,k),y))}return b$(a,y)}function ZT(){mw.call(this),this.C=new x4,this.F=!1,this.H=-1,this.L=new lS(this),this.N=-1,xe((fe(),this.Xc),li.$e()),this.Se(0,0),li.af(Yr(this.Xc)).className="gwt-PopupPanel",li._e(T7(this.Xc)).className="popupContent"}function iU(a,y,k){var z;a.q&&a.q.d||(Nm((fe(),y.Xc),!1),(ei(),!Ht&&(Ht=new co),ei(),Ht).a.t!=5&&(t2(k.a,y.Xc),CS(k.a),a.q=new _S(a),z=h8(k.a)[0],a.A=Dt((be(),z).clientX||0),a.B=Dt(z.clientY||0),gn(a.q,500)))}function rU(a,y){var k,z,E,j,te;if(te=y.indexOf("; cros "),te!=-1&&(z=N7(y,hs(41),te),z!=-1)){for(k=z;k>=te&&(Tt(k,y.length),y.charCodeAt(k)!=32);)--k;k!=te&&(E=y.substr(k+1,z-(k+1)),j=Nr(E,"\\.",0),u$(a,j))}}function oU(a,y,k,z){od(a.d),a.c.C||(a.c.C=!0),Hi(a.c.yc)||(go(a.c,!0),is(a.c)),Lu(a.c,y,k),Ei(a.c,y,y,k,k),z?Fn(a.c,y,z.col2,k,z.row2,!0):Fn(a.c,y,y,k,k,!0),Lr(a),Ks(a.d,y,k,null),qa(a.d.W,k,y,!0),gn(a.d.s,200)}function sU(a,y,k,z){var E,j;a.V.sc!=k&&a.V.rc!=y?B0(a,y,k,!1,!1,!0):(E=Rt(a.V,y,k),z=E.o,a.b=z,Mw(a.u),z=(j=Gt(a.u.j),j??"")),a.t=!1,n0(a),a.e||!a.B&&!a.o&&(a.B=!0,ad(a.V,!0,z),a.u.u=!0,Bh(a.u))}function cU(a,y){var k,z,E,j,te;for(te=(be(),y).target,z=(j=new Gr(a.p.a).a.Wf().Ke(),new po(j));z.a.Ue();)if(k=(E=z.a.Ve(),E.cg()),Ie.ce(k,te)&&((k.scrollHeight||0)|0)>(k.clientHeight|0))return a.q=k,a.g=LF(a.q),!0;return!1}function re(a,y,k){var z=Bd,E,j=z[a],te=j instanceof Array?j[0]:null;j&&!te?ee=j:(ee=(E=y&&y.prototype,!E&&(E=Bd[y]),dB(E)),ee.ng=k,!y&&(ee.og=Me),z[a]=ee);for(var ne=3;ne<arguments.length;++ne)arguments[ne].prototype=ee;te&&(ee.mg=te)}function eV(){Qr(),XI.call(this),this.e=new i9(this),this.b=new Rl(100,new U5(this)),BC(this,this.e),li.af((fe(),fe(),Yr(this.Xc))).className=rE,ms(this.Xc,lA(ue)),ka(this,new $5(this),fo||(fo=new xr)),this.Xc.id="PID_VAADIN_CM"}function tV(a,y){var k,z,E,j;for(k=a.a.j,z=y-k,j=y+a.pc+k,z<0&&(z=0),E=a.a.i;a.yb<j&&a.xb<E;)a.cb+Ft(a.a,a.bb)<z&&(a.cb+=Ft(a.a,a.bb),++a.bb),++a.xb,a.yb+=Ft(a.a,a.xb);for(;z>a.cb+Ft(a.a,a.bb)&&a.bb<E;)a.cb+=Ft(a.a,a.bb),++a.bb;X0(a)}function uU(a,y){var k=(a.className||"").split(/\s+/);if(k){var z=k[0],E=z.length;k[0]=y;for(var j=1,te=k.length;j<te;j++){var ne=k[j];ne.length>E&&ne.charAt(E)=="-"&&ne.indexOf(z)==0&&(k[j]=y+ne.substring(E))}a.className=k.join(" ")}}function nV(a,y){var k;this.M=new MS(this),this.q=a,this.Q=y,this._=y.Rc,this.b=new ld(this),Um(this,this.b),ta(this.b),vt(this.b,oE,!0),mT(this,!1),this.B=new fd(this),vt(this.B,oE,!0),ea(this.B),k=y.zc,y1(this.b,k),m1(this.B,k)}function lU(a,y){var k,z,E,j;k=y.f,z=a.a,!z&&(z=cu(k)),E=new Ee(z);try{iN(new Ys(E,a.b),k,Se(Ce(Ke,1),ve,1,5,[]))}catch(te){throw te=Xt(te),ze(te,79)?(j=te,we(new Aa("Couldn't invoke @OnStateChange method "+E.b+"."+a.b,j))):we(te)}}function fU(a,y){a.r=y,y>0&&!a.a?(a.a=new ld(a),y1(a.a,a.Q.c),ai(a.a,!1),ta(a.a),vt(a.a,iE,!0),a.A=new fd(a),m1(a.A,a.Q.c),rl(a.A,!1),ea(a.A),vt(a.A,iE,!0)):y==0&&a.a&&(sw(a.a),a.a=null,lt(a.A.k),a.A=null),iV(a),kV(a)}function hU(a,y){a.ab=y,y>0&&!a.X?(a.X=new ld(a),y1(a.X,a.Q.Pc),ai(a.X,!1),ta(a.X),vt(a.X,"top-right",!0),a.F=new fd(a),m1(a.F,a.Q.Pc),rl(a.F,!1),ea(a.F),vt(a.F,Z2,!0)):y==0&&a.X&&(sw(a.X),a.X=null,lt(a.F.k),a.F=null),iV(a),kV(a)}function iV(a){a.ab>0&&a.r>0&&!a.W?(a.W=new ld(a),y1(a.W,a.Q.Nc),ai(a.W,!1),ta(a.W),vt(a.W,Z2,!0),a.D=new fd(a),m1(a.D,a.Q.Nc),rl(a.D,!1),ea(a.D),vt(a.D,Z2,!0)):a.W&&(a.ab==0||a.r==0)&&(sw(a.W),a.W=null,lt(a.D.k),a.D=null)}function rV(a,y){var k,z,E;if(y==0)return(a.a[0]&1)!=0;if(y<0)throw we(new Jr("Negative bit address"));if(E=y>>5,E>=a.d)return a.e<0;if(k=a.a[E],y=1<<(y&31),a.e<0){if(z=Wv(a),E<z)return!1;z==E?k=-k:k=~k}return(k&y)!=0}function dU(a){!a.C&&(a.C=new un),a.C&&iI((!a.C&&(a.C=new un),a.C))&&(br((!a.C&&(a.C=new un),a.C)),Tr(jn((ht(ju),ju.k)),"Widget is still attached to the DOM after the connector ("+CI(a)+") has been unregistered. Widget was removed."))}function Qm(a,y){var k,z,E,j,te;return y&=63,k=a.h,z=(k&Br)!=0,z&&(k|=-1048576),y<22?(te=k>>y,j=a.m>>y|k<<22-y,E=a.l>>y|a.m<<22-y):y<44?(te=z?Li:0,j=k>>y-22,E=a.m>>y-22|k<<44-y):(te=z?Li:0,j=z?wn:0,E=k>>y-44),Zt(E&wn,j&wn,te&Li)}function Jm(a,y){var k,z,E,j,te,ne;for(te=y==null?0:(j=oo(y),j|0),z=(k=a.a.get(te),k??new Array),ne=0;ne<z.length;ne++)if(E=z[ne],Jw(y,E.cg()))return z.length==1?(z.length=0,nP(a.a,te)):z.splice(ne,1),--a.c,Lh(a.b),E.dg();return null}function aU(a,y){var k,z,E;tf((fe(),a.Xc)),a.Ub.className=lp,Re(a.yc).style[ps]="",zt(a.Vb,"row"+a._b),a.Zb&&(k=new Ot,E=y-a.Sb,z=Qv(Jv(E/a.Lb*72)),z<0&&(z=0),z!=ha(a.a,a._b)&&Zn(k,he(a._b),new pg(z)),k.a.c+k.b.c==0||ZU(a.a,k)),a._b=-1}function oV(){var a,y,k,z;null.pg(),z=(Ci(),Vi(ue).clientWidth|0),k=Vi(ue).clientHeight|0,null.pg((It(),tn)),null.pg((tt(),Ni)),null.pg(Ni),y=$q(ue),a=Uq(ue),null.pg(ae.Math.max(y,z)+ke),null.pg(ae.Math.max(a,k)+ke),null.pg(vi)}function bU(a){var y,k,z,E,j,te;for(z=new st,te=pi(a.a.a),E=a.a.a.i,k=new Fe(a.b);k.a<k.c.a.length;)y=He(k),j=new tA(a,E,y.key,y.type,te),kK(j,y.caption),SK(j,aN(a.a.a,y.key)),z.a[z.a.length]=j;return td(z,Le(XQ,{720:1,3:1},125,z.a.length,0,1))}function pU(a,y,k,z,E){var j,te,ne;for(j=0,te=0,ne=0;ne<z;ne++)j=(No(),Vt(Oi(Ve(k[ne],Xe),Ve(E,Xe)),Ve(_e(j),Xe))),te=Vt(cn(Ve(a[y+ne],Xe),Ve(j,Xe)),te),a[y+ne]=_e(te),te=Bn(te,32),j=Yn(j,32);return te=Vt(cn(Ve(a[y+z],Xe),j),te),a[y+z]=_e(te),_e(Bn(te,32))}function sV(a,y,k){var z,E,j,te,ne;for(k&&(a.c.style[ii]="",a.s=0,a.t=0),E=y.length;E<a.u.length;E++)lt(a.u[E]);for(yM(a.u,y.length),z=0;z<y.length;z++)j=a.u[z],j?(ne=j,sf(ne,y[z])):(te=VA(y[z]),xe(a.c,te),a.u[z]=te);a.r>=a.u.length&&(a.r=-1),pu(a)}function gU(a){if(a.Rf()){var y=a.c;y.Sf()?a.k="["+y.j:y.Rf()?a.k="["+y.Pf():a.k="[L"+y.Pf()+";",a.b=y.Of()+"[]",a.i=y.Qf()+"[]";return}var k=a.g,z=a.d;z=z.split("/"),a.k=c0(".",[k,c0("$",z)]),a.b=c0(".",[k,c0(".",z)]),a.i=z[z.length-1]}function wU(a,y,k,z){a.c=y,a.d=k,a.b=z,(fe(),a.Xc).style[ot]=dt,a.t&&(a.t.style[ot]=dt),a.i.style[ot]=(at(),dt),eu(a),a.k=cr(a.Xc,Mf),a.n=cr(a.Xc,pl),tz(a),a.Xc.style[ot]=ni,a.t&&(a.t.style[ot]=ni),a.i.style[ot]=ni}function vU(a,y,k,z,E,j,te,ne,ie){var se,ce;Ks(a.d,k,z,y),a.c.C||(a.c.C=!0),Hi(a.c.yc)||(go(a.c,!0),is(a.c)),se=a.c.rc,ce=a.c.sc,(se!=k||ce!=z)&&(Lu(a.c,k,z),Lr(a)),Ei(a.c,E,j,te,ne),Fn(a.c,E,j,te,ne,!0),ie&&!CG(a.c,E,j,te,ne)&&RA(a.c,E,j,te,ne),Ar(a.c)}function mU(a){return bT(),cN(hW,a)&&(a.indexOf("&")!=-1&&(a=Sh(lW,a,"&amp;")),a.indexOf("<")!=-1&&(a=Sh(dW,a,"&lt;")),a.indexOf(">")!=-1&&(a=Sh(fW,a,"&gt;")),a.indexOf('"')!=-1&&(a=Sh(aW,a,"&quot;")),a.indexOf("'")!=-1&&(a=Sh(bW,a,"&#39;"))),a}function ud(a){var y;if(a.ud())throw we(new mo("Should only call onAttach when the widget is detached from the browser's document"));a.Tc=!0,fe(),dk(a.Xc,a),y=a.Uc,a.Uc=-1,y>0&&(a.Uc==-1?Js(a.Xc,y|(a.Xc.__eventBits||0)):a.Uc|=y),a.rd(),a.yd(),Sa(a,!0)}function yU(a,y,k){var z,E,j;E=1,ye(y.substr(y.length-E,E),"%")!=Dh(a.p,"%"),z=1,ye(k.substr(k.length-z,z),"%")!=Dh(a.o,"%"),a.p=y,a.o=k,j=a.vf(),j.pd("v-has-width",!LP(a.uf())),j.pd("v-has-height",!KP(a.uf())),a.vf().qd(y),a.vf().od(k)}function xU(a){var y,k,z,E;a.C=!1,h0(a,!1),a.N&&Sw(a),a.j?BR(a.q,a.G,a.I):a.s&&(y=ae.Math.min(a.e,a.G),k=ae.Math.max(a.f,a.H),z=ae.Math.min(a.K,a.I),E=ae.Math.max(a.L,a.J),y<=k&&z<=E&&QF(a.q,y,k,z,E)),zt(Re(a.Q),"selecting"),hd(a,!1)}function cV(a,y){var k;a.r&&Nv(a.i),k=(be(),y).touches[0],cU(a,k)&&(Di(jn((ht(fi),fi.k)),"TouchDelegate takes over"),y.stopPropagation(),a.d=Yh(a),zp=a,a.o=Dt(k.clientY||0),a.s[0]=a.o,a.b[0]=jr(),a.k=1,a.n=nF(a),Di(jn((ht(fi),fi.k)),"ST"+a.n),a.j=!1)}function CU(a,y){var k,z,E,j,te,ne;if(y.e==0)throw we(new Jr(By));return ne=a.d,k=y.d,(ne!=k?ne>k?1:-1:pf(a.a,y.a,ne))==-1?a:(j=k,E=Le(gt,yt,17,j,15,1),j==1?E[0]=YF(a.a,ne,y.a[0]):(z=ne-k+1,E=g2(null,z,a.a,ne,y.a,k)),te=new kn(a.e,j,E),Ti(te),te)}function uV(a,y,k){var z,E,j,te,ne,ie,se;y?(Mr(a.wb,k),se=a.wb.b,ie=a.wb.a,ne=Ui(a,k),z=ne||Rt(a,ie,se),E=new v2(a,Nl(z.d)),PT(E,Nt(a.i,k)),_T(E,Nt(a.r,k)),te=a.tb.contains(k)?a.ub:null,k0(E,te),Sm(E,z.d,se,ie),Te(a.b,k,E)):(j=Eo(a.b,k),j&&(Pn(j,!1),lt(j.i)))}function kU(a,y,k){var z,E,j,te,ne,ie;if(ne=bU(a.a),!(ne==null||ne.length==0)){for(a.d=y,a.f=k,j$(a.e),E=ne,j=0,te=E.length;j<te;++j)z=E[j],n8(a.e,new Am((ie=new Bi,ie.a+="<div>",rt(ie,z.e),ie.a+="</div>",ie.a),z));sF(Re(a.e)),a.c=GA(),Gw(a,""),Tf(a,1),$h(a,new G5(a))}}function lV(a,y){var k,z,E,j;for(E=a.a.L,j=y-E,k=y+a.oc+E,j<0&&(j=0),z=a.Sc+1;a.eb>j&&a.db>z;)a.Ab-Ai(a,a.zb)>k&&(a.Ab-=Ai(a,a.zb),--a.zb),--a.db,a.eb-=Ai(a,a.db);for((a.eb<=0||a.db<=1)&&(a.eb=0,a.db=z);k<a.Ab-Ai(a,a.zb)&&a.zb>1;)a.Ab-=Ai(a,a.zb),--a.zb;W0(a)}function SU(a){Qs();function y(z,E,j,te,ne){ne||(ne=z+" ("+E+":"+j,te&&(ne+=":"+te),ne+=")");var ie=y9(ne);gm(ie,!1)}function k(z){var E=z.onerror;E&&!a||(z.onerror=function(){return y.apply(this,arguments),E&&E.apply(this,arguments),!1})}k(ae),k(window)}function IU(a){var y=a.ownerDocument.defaultView.getComputedStyle(a),k=y.width;if(k==Tu)return im(a);var z=parseFloat(k),E=parseFloat(y.borderLeftWidth)+parseFloat(y.borderRightWidth),j=parseFloat(y.paddingLeft)+parseFloat(y.paddingRight);return z+E+j}function AU(a){var y=a.ownerDocument.defaultView.getComputedStyle(a),k=y.height;if(k==Tu)return H9(a);var z=parseFloat(k),E=parseFloat(y.borderTopWidth)+parseFloat(y.borderBottomWidth),j=parseFloat(y.paddingTop)+parseFloat(y.paddingBottom);return z+E+j}function TU(a){var y,k,z,E,j,te,ne;for(te=new Gr(a.a.f),y=new Ot,xe(a.zc,a.hb),xo(a.hb,yE),j=(ne=te.a.Wf().Ke(),new po(ne));j.a.Ue();)E=(z=j.a.Ve(),z.cg()),ah(a.hb,"cell cs"+E),k=a.hb.clientWidth|0,Zn(y,E,new pg(Qv(GG(new uw(k),new uw(10)))));lt(a.hb),IM(a.a,y)}function VU(a){var y,k,z;return k=a.l,k&k-1||(z=a.m,z&z-1)||(y=a.h,y&y-1)||y==0&&z==0&&k==0?-1:y==0&&z==0&&k!=0?ro(k):y==0&&z!=0&&k==0?ro(z)+22:y!=0&&z==0&&k==0?ro(y)+44:-1}function Rt(a,y,k){var z,E,j,te;return k<=a.Sc&&(y>=a.bb&&y<=a.xb||y<=a.ob)||y<=a.ob&&(k>=a.db&&k<=a.zb||k<=a.Sc)?XV(a,y,k):(E=y-a.bb,j=k-a.db,E<0||j<0?null:(te=a.kc.a.length>j,te&&(z=Ze(a.kc,j).a.length>E,z)?Ze(Ze(a.kc,j),E):null))}function Mo(a,y){var k,z;y!=a.g&&(a.g&&(MP(a.g),a.i&&(z=G1(Re(a.g)),fe(),an.Ce(z)==2&&(k=an.Be(z,1),Sn(k,Fz,!1)))),y&&(vt(y,Fi((fe(),y.Xc))+"-"+Z0,!0),a.i&&(z=G1(y.Xc),an.Ce(z)==2&&(k=an.Be(z,1),Sn(k,Fz,!0))),yd(),eB(a.Xc,new OC(y.Xc))),a.g=y)}function Ym(a,y,k){if(a.Tc){if(k<0)throw we(new vo("Length must be a positive integer. Length: "+k));if(y<0||k+y>zs((fe(),a.Xc),Nf).length)throw we(new vo("From Index: "+y+"  To Index: "+(y+k)+"  Text Length: "+zs((fe(),a.Xc),Nf).length));bB((fe(),a.Xc),y,k)}}function zU(a){var y,k,z,E,j,te,ne,ie,se;if(a.a.C){for(te=a.a.yc.f,ne=a.a.yc.e,se=a.a.yc.K,ie=a.a.yc.L,j=new Bi,E=se;E<=ie;E++){for(k=ne;k<=te;k++)y=Ea(a.a,k,E),y!=null&&(j.a+=""+y),k!=te&&(j.a+="	");E!=ie&&(j.a+=`
`)}return z=j.a,z}return"non-continous selection, can't copy"}function fV(a,y){var k,z,E,j,te,ne,ie;if(k=a.d,!k){for(ie="",j=a.t.S,te=0,ne=j.length;te<ne;++te)E=j[te],ie+=E+"|";ie=Zo(ie,0,ie.length-1),z="^(("+ie+")!){0,1}",z+="([A-Za-z]{1,3}[0-9]{1,7})",z+="(:([A-Za-z]{1,3}[0-9]{1,7})){0,1}",a.d=k=new RegExp(z),gn(new LS(a),2e3)}return k.test(y)}function hV(a,y){var k,z,E,j;for(k=a.a.j,z=y-k,j=y+a.pc+k,z<0&&(z=0),E=a.ob+1;a.cb>z&&a.bb>E;)a.yb-Ft(a.a,a.xb)>j&&(a.yb-=Ft(a.a,a.xb),--a.xb),--a.bb,a.cb-=Ft(a.a,a.bb);for((a.cb<=0||a.bb<=1)&&(a.cb=0,a.bb=E);j<a.yb-Ft(a.a,a.xb)&&a.xb>1;)a.yb-=Ft(a.a,a.xb),--a.xb;X0(a)}function EU(a){var y,k,z,E,j;return isNaN(a)?(nu(),fx):a<-9223372036854776e3?(nu(),oW):a>=9223372036854776e3?(nu(),ux):(E=!1,a<0&&(E=!0,a=-a),z=0,a>=Rr&&(z=bt(a/Rr),a-=z*Rr),k=0,a>=ui&&(k=bt(a/ui),a-=k*ui),y=bt(a),j=Zt(y,k,z),E&&Ya(j),j)}function vu(a,y,k,z,E){var j;a.f&&(a.k==-1&&(a.k=a.I.rc,a.n=a.I.sc),k?--a.n:z?++a.k:E?++a.n:--a.k,a.n==0&&(a.n=1),a.k==0&&(a.k=1),j=dv(a.I),a.n>j[2]-1&&(a.n=j[2]-1),a.k>j[3]-1&&(a.k=j[3]-1),y&&a.o!=-1||(a.o=a.k,a.p=a.n),If(a,a.o,a.p,a.k,a.n,!1),yu(a.I,a.k,a.n))}function jU(a,y){var k,z,E,j;if(a.T)for(j=(z=new di(a.T).a.Wf().Ke(),new yr(z));j.a.Ue();)E=(k=j.a.Ve(),k.dg()),u8(new di(y),E)||br(E);a.Sc>0&&a.ob>0&&a0(a,y,1,a.Sc,1,a.ob),a.Sc>0&&a0(a,y,1,a.Sc,a.bb,a.xb),a.ob>0&&a0(a,y,1,a.db,a.zb,a.ob),a0(a,y,a.bb,a.xb,a.db,a.zb),a.T=y}function OU(a,y){var k,z,E;if(a.Mc.a.length!=0)for(z=new Fe(y);z.a<z.c.a.length;)k=He(z),Zu(Ze(a.Mc,(k.row-1)*a.ob+k.col-1),k.value,k.cellStyle,k.needsMeasure),E=qe+k.col+Ye+k.row,zv(a,E,k.value,k.cellStyle,k.needsMeasure),k.value==null?Eo(a.e,E):Te(a.e,E,k);sl(a,!1)}function A0(a,y){No();var k,z,E,j,te,ne,ie,se,ce;return y.d>a.d&&(ne=a,a=y,y=ne),y.d<63?MU(a,y):(te=(a.d&-2)<<4,se=Ma(a,te),ce=Ma(y,te),z=j0(a,Xo(se,te)),E=j0(y,Xo(ce,te)),ie=A0(se,ce),k=A0(z,E),j=A0(j0(se,z),j0(E,ce)),j=N0(N0(j,ie),k),j=Xo(j,te),ie=Xo(ie,te<<1),N0(N0(ie,j),k))}function dV(a,y){a.p=y,y?(vt(a.b,zu,!0),su(a.b,y),a.W&&(su(a.W,y),vt(a.W,zu,!0)),a.X&&(su(a.X,y),vt(a.X,zu,!0)),a.a&&(su(a.a,y),vt(a.a,zu,!0)),hd(a,!0)):(vt(a.b,zu,!1),a.W&&vt(a.W,zu,!1),a.X&&vt(a.X,zu,!1),a.a&&vt(a.a,zu,!1),hd(a,!1))}function T0(a){var y,k,z,E,j,te;for(k=(j=new di(a.b).a.Wf().Ke(),new yr(j));k.a.Ue();)y=(E=k.a.Ve(),E.dg()),te=y.d,z=y.b,Vo(a.a,z)||Cn(a.a,te)||!(z>=a.bb&&z<=a.xb&&te>=a.db&&te<=a.zb||z<=a.ob&&te<=a.Sc||z>a.ob&&z<=a.xb&&te<=a.Sc||te>a.Sc&&te<=a.zb&&z<=a.ob)?(Pn(y,!1),lt(y.i)):pd(y)}function XU(a){var y,k,z,E;for(y=0,z=a.length,E=z-4,k=0;k<E;)y=(Tt(k+3,a.length),a.charCodeAt(k+3)+(Tt(k+2,a.length),31*(a.charCodeAt(k+2)+(Tt(k+1,a.length),31*(a.charCodeAt(k+1)+(Tt(k,a.length),31*(a.charCodeAt(k)+31*y))))))),y=y|0,k+=4;for(;k<z;)y=y*31+xI(a,k++);return y=y|0,y}function mu(a,y){var k,z,E;for(z=y,E=a.length;z<E&&(k=(Tt(z,a.length),a.charCodeAt(z)),Mx==null&&(Mx=new RegExp("[A-Z]","i")),!!(Mx.test(String.fromCharCode(k))||(Lx==null&&(Lx=new RegExp("\\d")),Lx.test(String.fromCharCode(k)))||k==95||k==46));)++z;return a.substr(y,z-y)}function WU(a){var y,k,z,E,j;for(E=(!a.K&&(a.K=new Cr),a.K).ab,j=(!a.C&&(a.C=new un),a.C),z=new Fe(a.j);z.a<z.c.a.length;)y=He(z),et(E,y,0)!=-1||uV(j.V,!1,y);if(E)for(k=new Fe(E);k.a<k.c.a.length;)y=He(k),et(a.j,y,0)!=-1||uV(j.V,!0,y);a.j.a=Le(Ke,ve,1,0,5,1),E&&Os(a.j,E)}function KU(a,y,k){var z,E;y=TR(a.e),z=a.d,E=a.f,y+z>(Ci(),Vi(ue).clientWidth|0)&&(z=z-y,z<0&&(z=0)),k+E>(Vi(ue).clientHeight|0)&&(E=ae.Math.max(0,(Vi(ue).clientHeight|0)-k)),E==0&&V1(a,(Vi(ue).clientHeight|0)+ke),ll(a,z,E),(fe(),a.Xc).style[as]=(Ju(),Q0),Ct((ut(),pt),new Q5(a))}function aV(a){var y,k,z;return z=-a.a.getTimezoneOffset(),y=(z>=0?"+":"")+(z/60|0),k=xh(ae.Math.abs(z)%60),(VT(),ZW)[a.a.getDay()]+" "+eK[a.a.getMonth()]+" "+xh(a.a.getDate())+" "+xh(a.a.getHours())+":"+xh(a.a.getMinutes())+":"+xh(a.a.getSeconds())+" GMT"+y+k+" "+a.a.getFullYear()}function LU(a){var y,k,z,E,j,te,ne,ie;if(a.A!=null){if(te=V0(a,a.A),!te)return;for(E=ae.Math.min(te.col1,te.col2),z=ae.Math.max(te.col1,te.col2),ie=ae.Math.min(te.row1,te.row2),ne=ae.Math.max(te.row1,te.row2),y=E;y<=z;y++)for(j=ie;j<=ne;j++)k=Rt(a.I,y,j),k&&(k.d.style[_f]="")}a.A=null}function MU(a,y){var k,z,E,j,te,ne,ie,se,ce,le,de;return z=a.d,j=y.d,ne=z+j,ie=a.e!=y.e?-1:1,ne==2?(ce=Oi(Ve(a.a[0],Xe),Ve(y.a[0],Xe)),de=_e(ce),le=_e(Yn(ce,32)),le==0?new zi(ie,de):new kn(ie,2,Se(Ce(gt,1),yt,17,15,[de,le]))):(k=a.a,E=y.a,te=Le(gt,yt,17,ne,15,1),BF(k,z,E,j,te),se=new kn(ie,ne,te),Ti(se),se)}function NU(a,y){No();var k,z,E,j,te,ne,ie,se,ce;return se=a.e,se==0?(Xi(),Do):(z=a.d,k=a.a,z==1?(E=Oi(Ve(k[0],Xe),Ve(y,Xe)),ie=_e(E),te=_e(Yn(E,32)),te==0?new zi(se,ie):new kn(se,2,Se(Ce(gt,1),yt,17,15,[ie,te]))):(ne=z+1,j=Le(gt,yt,17,ne,15,1),j[z]=l0(j,k,z,y),ce=new kn(se,ne,j),Ti(ce),ce))}function bV(a){var y,k,z,E,j,te;for(z=(te=new Gr(a.u.a).a.Wf().Ke(),new po(te));z.a.Ue();)k=(E=z.a.Ve(),E.cg()),(k.a!=a.rc||k.b!=a.sc)&&(y=Rt(a,k.a,k.b),y&&(Ue(y.d,Ji),Ut(a.t,y)),j=Ui(a,qe+k.a+Ye+k.b),j&&(Ut(a.t,j),Ue(j.d,Ji)));a.nb&&(y=Rt(a,a.nb.a,a.nb.b),y&&Ue(y.d,qs)),QU(a.a.u)}function pV(a,y){if(y instanceof Object)try{if(y.__java$exception=a,navigator.userAgent.toLowerCase().indexOf("msie")!=-1&&ue.documentMode<9)return;var k=a;Object.defineProperties(y,{cause:{get:function(){var z=k.Fd();return z&&z.Dd()}},suppressed:{get:function(){return k.Ed()}}})}catch{}}function Sf(){Sf=ge,gx={_default_:Na,dragenter:SS,dragover:SS},wx={click:ji,dblclick:ji,mousedown:ji,mouseup:ji,mousemove:ji,mouseover:ji,mouseout:ji,mousewheel:ji,keydown:sg,keyup:sg,keypress:sg,touchstart:ji,touchend:ji,touchmove:ji,touchcancel:ji,gesturestart:ji,gestureend:ji,gesturechange:ji}}function Zm(a,y,k){var z;a.c=k,Nv(a),a.g&&(Oo(a.g),a.g=null,_9(a)),a.a.M=y,WF(a.a),z=!k&&a.a.F,a.i=y,z?y?(bm(a),Re(a.a).style[as]=Su,a.a.N!=-1&&a.a.Se(a.a.H,a.a.N),(Qr(),li).bf(Re(a.a),"rect(0px, 0px, 0px, 0px)"),q1((ci(),uu()),a.a),a.g=new KS(a),gn(a.g,1)):Da(a,200,jr()):_H(a)}function RU(a,y,k,z,E,j,te,ne){a.d.o&&(a.d.o=!1,yf(a.c)),a.d.e=te,Lu(a.c,k,z),Lr(a),a.c.C||(a.c.C=!0),Hi(a.c.yc)||(go(a.c,!0),is(a.c)),Ei(a.c,k,k,z,z),Fn(a.c,k,k,z,z,!0),j?Q8(a.d.u,E):ch(a.d.u,E),sh(a.d.u,!te),y!=null?Vc(a.d.u,y):Vc(a.d.u,uf(k,z)),GN(a.c)||yu(a.c,k,z),ne||Ar(a.c)}function gV(a,y){var k,z,E,j,te;if(z=y>>5,y&=31,z>=a.d)return a.e<0?(Xi(),u1):(Xi(),Do);if(j=a.d-z,E=Le(gt,yt,17,j+1,15,1),Mm(E,j,a.a,z,y),a.e<0){for(k=0;k<z&&a.a[k]==0;k++);if(k<z||y>0&&a.a[k]<<32-y){for(k=0;k<j&&E[k]==-1;k++)E[k]=0;k==j&&++j,++E[k]}}return te=new kn(a.e,j,E),Ti(te),te}function wV(a,y){var k,z,E,j,te;return z=Ve(y,Xe),en(a,0)>=0?(j=fs(a,z),te=ol(a,z)):(k=Yn(a,1),E=y>>>1,j=fs(k,E),te=ol(k,E),te=Vt(_n(te,1),Ve(a,1)),y&1&&(en(j,te)<=0?te=cn(te,j):_k(cn(j,te),z)?(te=Vt(te,cn(z,j)),j=cn(j,1)):(te=Vt(te,cn(_n(z,1),j)),j=cn(j,2)))),Zc(_n(te,32),Ve(j,Xe))}function vV(a,y){nf.call(this),this.a=Oe(ue),this.b=!1,this.f=!1,this.k=-1,this.g=-1,this.i=-1,this.j=-1,this.n=-1,this.d=-1,this.e=a,this.c=y,(fe(),this.Xc).className="grouping",Sn(this.Xc,"minus",!0),this.a.innerHTML="&#x2212;",this.a.className="expand",xe(this.Xc,this.a),Uo(this.Xc,262145)}function mV(a){fh();var y=a.a;return y.getPropertyValue?y.getPropertyValue(OE)?y.getPropertyValue(OE):y.getPropertyValue(XE)?y.getPropertyValue(XE):y.getPropertyValue(WE)?y.getPropertyValue(WE):y.getPropertyValue(KE)?y.getPropertyValue(KE):"":""}function yV(){this.d=Oe(ue),this.b=Oe(ue),this.a=Oe(ue),this.d.className="v-spreadsheet-popupbutton-overlay-header",this.b.className="v-window-closebox",this.b.setAttribute("role",G0),this.a.className="header-caption",xe(this.d,this.b),xe(this.d,this.a),Uo(this.b,1),Ss(this.b,this),xs(this,this.d)}function xV(a,y,k,z,E){var j;a.e=y,a.K=z,a.f=k,a.L=E,a.Y=Wo(a.q.V.W,z,E+1),a.Z=Wo(a.q.g,y,k+1),j=a.Z==0||a.Y==0,R0(a.b,y,k,z,E),j&&su(a.b,!0),a.ab>0&a.r>0&&(R0(a.W,y,k,z,E),j&&su(a.W,!0)),a.ab>0&&(R0(a.X,y,k,z,E),j&&su(a.X,!0)),a.r>0&&(R0(a.a,y,k,z,E),j&&su(a.a,!0)),a.p&&dV(a,!1),a.o||kT(a)}function PU(a){var y=ue.createElement("div");y.tabIndex=0;var k=ue.createElement("input");k.type="text",k.tabIndex=-1,k.setAttribute(E2,"true");var z=k.style;return z.opacity=0,z.height="1px",z.width="1px",z.zIndex=-1,z.overflow=dt,z.position=Su,k.addEventListener("focus",a,!1),y.appendChild(k),y}function CV(a,y){if(a.u=-1,a.v=-1,y.length>=1)try{a.u=Wi(y[0])}catch(k){if(k=Xt(k),!ze(k,21))throw we(k)}if(y.length>=2){try{a.v=Wi(y[1])}catch(k){if(k=Xt(k),!ze(k,21))throw we(k)}if(a.v==-1&&y[1].indexOf("-")!=-1)try{a.v=Wi(Zo(y[1],0,F1(y[1],hs(45))))}catch(k){if(k=Xt(k),!ze(k,21))throw we(k)}}}function _U(a){var y,k,z,E,j,te,ne;if(j=a.length,j==0)return null;for(y=!1,k=new mg;jr()-k.a<16;){for(z=!1,E=0;E<j;E++)ne=a[E],ne&&(z=!0,ne[0].Jd()||(a[E]=null,y=!0));if(!z)break}if(y){for(te=[],E=0;E<j;E++)a[E]&&(te[te.length]=a[E]);return te.length==0?null:te}else return a}function BU(a,y,k){var z,E,j,te;E=Rt(a,y,k),z=Ui(a,qe+y+Ye+k),te=Rt(a,a.rc,a.sc),j=Ui(a,qe+a.rc+Ye+a.sc),Ut(a.u,new Co(a.rc,a.sc)),te&&(Ut(a.t,te),zt(te.d,qs),Ue(te.d,Ji)),j&&(Ut(a.t,j),zt(j.d,qs),Ue(j.d,Ji)),Ih(a.u,new Co(y,k)),E&&(Ih(a.t,E),zt(E.d,Ji)),z&&(Ih(a.t,z),zt(z.d,Ji)),a.sc=k,a.rc=y}function DU(a){var y,k,z;return z=a.Tc&&a.M,oD(a),z?!1:(a.ef(!1),vt(a,Fi(li.af((fe(),fe(),Yr(a.Xc))))+"-"+Vu,!0),k=new Dl(a.Xc),y=mV(k),y==null&&(y=""),a.ef(!0),y.indexOf(Vu)!=-1?(a.F=!1,Fm(a.Xc,new J5(a)),!0):(vt(a,Fi(li.af(Yr(a.Xc)))+"-"+Vu,!1),!1))}function qU(a,y){var k,z,E,j;if(y.a.length>0){for(z=new Bu(pm(a.Ec)),j=new Fe(y);j.a<j.c.a.length;){E=He(j);try{rt(z,au(E,sp,cp+a.Ac+" .cell.col"))}catch(te){if(te=Xt(te),ze(te,21))k=te,Q9(a.U,(Nn(),h1),"Invalid custom cell border style: "+E+", "+k.Gd());else throw we(te)}}ns(a.Ec),xe(a.Ec,ww(ue,z.a))}}function un(){this.n=new Ot,this.I=new N5(this),this.s=new SC,RK(this,(!ox&&(ox=new mk),ox.a)),this.V=new oz(this,this.Z),this.u=new iz(this,this.V),this.U=new rz(this),this.Q=new y6(this,this.V),xe(Re(this.V),Re(this.u)),xe(Re(this.V),Re(this.U)),Um(this,this.V),ka(this.V,new R5(this),(!$s&&($s=new xr),$s))}function V0(a,y){var k,z,E,j,te,ne;return j=new vs,y.indexOf("!")!=-1?(ne=Nr(y,"!",0)[0],ye(Xg(a.t),ne)?V0(a,Nr(y,"!",0)[1]):null):(y.indexOf(":")!=-1?(te=Nr(y,":",0),k=i2(te[0]),j.col1=k.a,j.row1=k.b,z=i2(te[1]),j.col2=z.a,j.row2=z.b):(E=i2(y),j.col1=E.a,j.row1=E.b,j.col2=j.col1,j.row2=j.row1),j)}function FU(a,y,k){VC(),a.onload=mi(function(){a.onload=null,a.onerror=null,a.onreadystatechange=null,y.Cf(k)}),a.onerror=mi(function(){a.onload=null,a.onerror=null,a.onreadystatechange=null,y.Bf(k)}),a.onreadystatechange=function(){(a.readyState==="loaded"||a.readyState==="complete")&&a.onload(arguments[0])}}function Xi(){Xi=ge;var a;for(Al=new zi(1,1),Xp=new zi(1,10),Do=new zi(0,0),u1=new zi(-1,1),Ux=Se(Ce(Wu,1),ve,11,0,[Do,Al,new zi(1,2),new zi(1,3),new zi(1,4),new zi(1,5),new zi(1,6),new zi(1,7),new zi(1,8),new zi(1,9),Xp]),l1=Le(Wu,ve,11,32,0,1),a=0;a<l1.length;a++)l1[a]=Lo(_n(1,a))}function HU(){var a=function(){};a.prototype={className:"",clientHeight:0,clientWidth:0,dir:"",getAttribute:function(y,k){return this[y]},href:"",id:"",lang:"",nodeType:1,removeAttribute:function(y,k){this[y]=void 0},setAttribute:function(y,k){this[y]=k},src:"",style:{},title:""},ae.GwtPotentialElementShim=a}function e2(a,y,k,z,E){var j,te,ne,ie;y==0||k==0||z==0||E==0||y==k&&z==E&&y==a.V.rc&&z==a.V.sc||(j=k,te=E,y>k&&(ie=y,y=k,k=ie),z>E&&(ie=z,z=E,E=ie),a.u.f?(If(a.u,a.X,a.Y,j,te,!1),Zl(a.u)):(ne=ti(a.I,z,E,y,k),pF(a.W,a.V.sc,a.V.rc,ne.row1,ne.col1,ne.row2,ne.col2),Vc(a.u,uf(a.V.rc,a.V.sc)),Lr(a.Q),gn(a.s,200)))}function kV(a){ca(a.b,a.ab==0?0:a.ab+1,0,a.r==0?0:a.r+1,0),a.a&&ca(a.a,a.ab==0?0:a.ab+1,0,0,a.r),a.X&&ca(a.X,0,a.ab,a.r==0?0:a.r+1,0),a.W&&ca(a.W,0,a.ab,0,a.r),sa(a.B,a.ab==0?0:a.ab+1,0,a.r==0?0:a.r+1,0),a.A&&sa(a.A,a.ab==0?0:a.ab+1,0,0,a.r),a.F&&sa(a.F,0,a.ab,a.r==0?0:a.r+1,0),a.D&&sa(a.D,0,a.ab,0,a.r)}function ld(a){this.F=a,this.B=Oe(ue),this.G=Oe(ue),this.k=Oe(ue),this.u=Oe(ue),this.a=Oe(ue),this.g=Oe(ue),this.i=Oe(ue),this.I=Oe(ue),this.o=Oe(ue),this.w=Oe(ue),this.c=Oe(ue),this.J=Oe(ue),this.p=Oe(ue),this.A=Oe(ue),this.d=Oe(ue),NG(this),Uo(this.B,15736908),Ss(this.B,new S5(this))}function $U(a){Nn();var y;switch(y=yq(a,(_c(),Wp)),y){case"ALL":return f1;case"CONFIG":return nK;case"FINE":return Jx;case"FINER":return iK;case"FINEST":return rK;case"INFO":return ih;case"OFF":return oK;case"SEVERE":return h1;case Ry:return Kp;default:throw we(new $o('Invalid level "'+a+'"'))}}function SV(a){var y,k,z,E,j;if(a.l==0&&a.m==0&&a.h==0)return"0";if(a.h==Br&&a.m==0&&a.l==0)return"-9223372036854775808";if(a.h>>19)return"-"+SV(ou(a));for(k=a,z="";!(k.l==0&&k.m==0&&k.h==0);){if(E=Wa(jd),k=b2(k,E,!0),y=""+Ok(wr),!(k.l==0&&k.m==0&&k.h==0))for(j=9-y.length;j>0;j--)y="0"+y;z=y+z}return z}function UU(){if(!Object.create||!Object.getOwnPropertyNames)return!1;var a="__proto__",y=Object.create(null);if(y[a]!==void 0)return!1;var k=Object.getOwnPropertyNames(y);return!(k.length!=0||(y[a]=42,y[a]!==42)||Object.getOwnPropertyNames(y).length==0)}function GU(a){var y,k,z,E,j;for(E=ue.querySelectorAll('link[rel~="icon"]'),k=0;k<E.length;k++)z=E[k],y=(be(),z).getAttribute("href")||"",y!=null&&y.indexOf("VAADIN/themes")!=-1&&(j=My.length,ye(y.substr(y.length-j,j),My))&&(y=qh(y,"VAADIN/themes/.+?/favicon.ico","VAADIN/themes/"+a+My),z.setAttribute("href",y))}function QU(a){var y,k,z,E,j,te,ne;for(k=(ne=new Gr(a.F.a).a.Wf().Ke(),new po(ne));k.a.Ue();)y=(te=k.a.Ve(),te.cg()),z=new Co(y.c,y.k),rf(a.D,z)||(y.d.style[ml]="",y.d.style[_f]="");for(Mt(a.F.a),a.f&&Af(a),j=new hr(new or(a.D).a);j.b;)E=Xr(j),y=Rt(a.I,E.cg().a,E.cg().b),y&&(y.d.style[ml]=E.dg(),Ut(a.F,y))}function Pn(a,y){var k,z;(li.af((fe(),fe(),Yr(a.Xc))).className||"").indexOf(Vu)!=-1?Fm(a.Xc,new T6(a,y)):(vt(a,Fi(li.af(Yr(a.Xc)))+"-"+Md,!0),z=new Dl(a.Xc),k=mV(z),k==null&&(k=""),k.indexOf(Md)!=-1?(a.F=!1,Fm(a.Xc,new V6(a,y)),a.K=!1):(vt(a,Fi(li.af(Yr(a.Xc)))+"-"+Md,!1),qv(a)))}function t2(a,y){var k;return k=new q3,LL(k,_g((be(),a).type)),zL(k,(xn(),Qa(a))),EL(k,Ja(a)),Ie.Qd(a)==1?b1(k,(il(),Ep)):Ie.Qd(a)==2?b1(k,(il(),kx)):Ie.Qd(a)==4?b1(k,(il(),Cx)):b1(k,(il(),Ep)),VL(k,!!a.altKey),jL(k,!!a.ctrlKey),OL(k,!!a.metaKey),KL(k,!!a.shiftKey),y&&(XL(k,TD(k.c,y)),WL(k,xq(k.d,y))),k}function n2(a){var y,k,z,E,j,te;for(te=new Fe(a.ic);te.a<te.c.a.length;)E=He(te),zt(E,Rd);for(z=new Fe(a.K);z.a<z.c.a.length;)y=He(z),zt(y,Pd);if(a.jb)for(j=new Fe(a.jb);j.a<j.c.a.length;)E=He(j),zt(E,Rd);if(a.ib)for(k=new Fe(a.ib);k.a<k.c.a.length;)y=He(k),zt(y,Pd);Mt(a.wc.a),Mt(a.tc.a),Mt(a.vc.a),Mt(a.uc.a)}function JU(a,y,k){var z,E,j,te,ne,ie,se,ce;if(te=ae.Math.min(y.col1,y.col2),j=ae.Math.max(y.col1,y.col2),ce=ae.Math.min(y.row1,y.row2),se=ae.Math.max(y.row1,y.row2),j>2e4){$A(jn((ht(Tp),Tp.i)));return}for(z=te;z<=j;z++)for(ie=ce;ie<=se;ie++)E=Rt(a.I,z,ie),E&&(ne=E.d,ne.style[ml]=k,Ut(a.F,E),Zn(a.D,new Co(z,ie),k));St(a.i,y)}function YU(a,y){var k,z,E,j,te,ne,ie;for(z=new hr(new or(y).a);z.b;)k=Xr(z),E=k.cg().a,ne=k.dg().a,ne==0&&(a.v?et(a.v,he(E),0)!=-1||St(a.v,he(E)):(a.v=new st,St(a.v,he(E)))),a.g[E-1]=ne;if(q0(a.V,!1),a.J)for(te=new Fe(a.J);te.a<te.c.a.length;)j=He(te),TT(a.V,j);a.d=!0,ie=dv(a.V),RF(a.W,y,ie[0],ie[1],ie[2],ie[3])}function ZU(a,y){var k,z,E,j,te,ne,ie;for(z=new hr(new or(y).a);z.b;)k=Xr(z),E=k.cg().a,ne=k.dg().a,ne==0&&(a.w?et(a.w,he(E),0)!=-1||St(a.w,he(E)):(a.w=new st,St(a.w,he(E)))),a.M[E-1]=ne;if(q0(a.V,!1),a.J)for(te=new Fe(a.J);te.a<te.c.a.length;)j=He(te),TT(a.V,j);a.d=!0,ie=dv(a.V),Pq(a.W,y,ie[0],ie[1],ie[2],ie[3])}function i2(a){var y,k,z,E,j,te,ne,ie,se;for(y="",te="",a!=null&&(se=Nr(a.toUpperCase(),"[0-9]",0),ie=Nr(a,"[A-z]",0),se.length>0&&(y=se[0]),ie.length>0&&(te=ie[ie.length-1])),ne=te.length>0?he(Wi(te)).a:0,z=0,j=0;j<y.length;j++)E=(Tt(j,y.length),y.charCodeAt(j)),k=0,E>=65&&E<=90?k=E-64:E>=97&&E<=122&&(k=E-96),z=z*26+k;return new Co(z,ne)}function No(){No=ge;var a,y;for($r=Le(Wu,ve,11,32,0,1),Tl=Le(Wu,ve,11,32,0,1),Gx=Se(Ce(gt,1),yt,17,15,[1,5,25,125,625,3125,15625,78125,390625,1953125,9765625,48828125,Py,_y]),a=1,y=0;y<=18;y++)$r[y]=Lo(a),Tl[y]=Lo(_n(a,y)),a=Oi(a,5);for(;y<Tl.length;y++)$r[y]=Wr($r[y-1],$r[1]),Tl[y]=Wr(Tl[y-1],(Xi(),Xp))}function IV(a){var y,k,z,E,j,te;for(E=a.g.value,E.length>31&&(E=E.substr(0,31),kC(a.g,E)),xo(a.v,E),j=(a.v.offsetWidth||0)|0,j<50&&(j=50),k=a.u[a.r],y=qi(a.k),z=(be(),Ie).Wd(k)+((k.offsetWidth||0)|0)+10;z>y&&a.s<a.u.length-1;)te=iu(a,a.s),z=bt(z-te),a.t-=te,++a.s;a.c.style[ii]=a.t+(tt(),ke),a.g.style[mt]=j+5+ke,k.style[mt]=j+ke}function eG(a){var y,k,z,E,j,te;for(te=a.uf(),j=Fi(a.vf().md()),a.vf().pd("v-widget",!0),Xm(a,j,"-error",te.ib!=null),y=0;y<a.s.length;y++)E=a.s[y],a.vf().pd(E,!1),Xm(a,j+"-",E,!1);if(a.s.length=0,kR(te.mb))for(z=te.mb.Ke();z.Ue();)k=z.Ve(),a.vf().pd(k,!0),Xm(a,j+"-",k,!0),WM(a.s,k);te.lb!=null&&!ye(te.lb,j)&&XC(a.vf(),te.lb)}function Fn(a,y,k,z,E,j){var te,ne,ie,se,ce,le;for(a.v=!1,j&&(fm(a),n2(a),ie=Rt(a,a.rc,a.sc),a.nb=null,ie&&zt(ie.d,qs)),le=z;le<=E;le++)for(ne=y;ne<=k;ne++)(ne!=a.rc||le!=a.sc)&&(ie=Rt(a,ne,le),Ut(a.u,new Co(ne,le)),ie&&(Ut(a.t,ie),Ue(ie.d,Ji)),se=Ui(a,qe+ne+Ye+le),se&&(Ut(a.t,se),Ue(se.d,Ji)));for(ce=z;ce<=E;ce++)w0(a,ce);for(te=y;te<=k;te++)g0(a,te)}function Ls(){Tc(),this.j=Oe(ue),this.a=new m5(this),this.f=new st,this.j.className=nE,this.j.setAttribute("role",G0),this.e=new Ak,Pi(this.e,"v-spreadsheet-popupbutton-overlay"),this.i=new zT,XC(this.i,"overlay-layout"),this.g=new yV,xK(this.g,this.e),T9(this.i,this.g),af(this.e,this.i),xs(this,this.j),Xn(this,this,(Ao(),Ao(),ws))}function fd(a){this.p=a,this.k=Oe(ue),this.q=Oe(ue),this.d=Oe(ue),this.j=Oe(ue),this.a=Oe(ue),this.k.className=sE,Ue(this.k,"paintmode"),this.q.className="s-top",this.d.className="s-left",this.j.className="s-right",this.a.className="s-bottom",xe(this.q,this.d),xe(this.q,this.j),xe(this.d,this.a),xe(this.k,this.q),xs(this,this.k)}function tG(a,y,k,z){var E,j,te,ne;for(ne=new Bu(cp),Hg(rt(rt(ne,a.Ac)," .sheet .cell.cs"),y),te=new hr(new or(k).a);te.b;)E=Xr(te),gw(E.dg(),y)&&rt(Hg(rt(rt((ne.a+=gE,ne),a.Ac),bE),E.cg()),".cell.cs0");for(j=new hr(new or(z).a);j.b;)E=Xr(j),gw(E.dg(),y)&&rt(Hg(rt(rt((ne.a+=gE,ne),a.Ac),dE),E.cg()),".cell.cs0");return ne.a}function z0(a){var y,k,z,E,j,te;if(sz(a,a.gc,a.dc,a.mb,a.jb,!1,a.fc),te=a.Z?a.fc+1:a.fc,a.hc.childNodes.length!=te){for(ns(a.hc),E=1;E<=te;E++)k=Oe(ue),xe(a.hc,k),(be(),Ie).de(k,""+E),k.className=kE,j=E,fe(),an.Ie(k,1),Ss(k,new v6(a,j));for(ns(a.cc),z=1;z<=te-1;z++)y=Oe(ue),xe(a.cc,y),y.className=_f,y.style[ii]=15*z+(tt(),ke)}}function nG(){ae.addEventListener("mouseout",mi(function(a){var y=(Sf(),Yf);if(y&&!a.relatedTarget&&a.target.tagName.toLowerCase()=="html"){var k=ue.createEvent("MouseEvents");k.initMouseEvent(L2,!0,!0,ae,0,a.screenX,a.screenY,a.clientX,a.clientY,a.ctrlKey,a.altKey,a.shiftKey,a.metaKey,a.button,null),y.dispatchEvent(k)}}),!0)}function AV(a,y){y.Df("id")&&(a.uf().kb!=null?ms(Re(a.vf()),a.uf().kb):y.b||Re(a.vf()).removeAttribute("id")),ze(a.uf(),126)?ze(a.vf(),60)&&a.vf().Bd((a.uf(),0)):ze(a.uf(),166)&&ze(a.vf(),60)&&a.vf().Bd(a.uf().n),WT(a,y),eG(a),yU(a,a.uf().nb==null?"":a.uf().nb,a.uf().jb==null?"":a.uf().jb),!a.t&&a.xf()&&(a.t=!0,null.pg(a.vf()))}function hd(a,y){var k,z,E,j;a._&&(k=!(a.a&&a.a.K>a.b.K)&&y,E=!(a.X&&a.X.j>a.b.j)&&y,I0(a.b,k,E,k,E),a.a&&(k=!(a.b&&a.b.K>=a.a.K)&&y,z=!(a.W&&a.W.j>a.a.j)&&y,I0(a.a,k,z,k,z)),a.X&&(j=!(a.W&&a.W.K>a.X.K)&&y,E=!(a.b&&a.b.j>=a.X.j)&&y,I0(a.X,j,E,j,E)),a.W&&(j=!(a.X&&a.X.K>=a.W.K)&&y,z=!(a.a&&a.a.j>=a.W.j)&&y,I0(a.W,j,z,j,z)))}function iG(a){var y,k,z;if(a==null||(z=a.length,z<1||z>31))return!1;for(k=0;k<z;k++)switch(y=(Tt(k,a.length),a.charCodeAt(k)),y){case 47:case 92:case 63:case 42:case 93:case 91:case 58:return!1;default:continue}return Tt(0,a.length),!(a.charCodeAt(0)==39||(Tt(z-1,a.length),a.charCodeAt(z-1)==39))}function rG(a,y){var k,z,E,j,te,ne,ie,se,ce,le,de,pe,me,je,wt;for(pe=y.length,ie=pe,Tt(0,y.length),y.charCodeAt(0)==45?(le=-1,de=1,--pe):(le=1,de=0),j=(M0(),JW)[10],E=pe/j|0,wt=pe%j,wt!=0&&++E,ne=Le(gt,yt,17,E,15,1),k=QW[8],te=0,me=de+(wt==0?j:wt),je=de;je<ie;je=me,me=je+j)z=Wi(y.substr(je,me-je)),se=(No(),l0(ne,ne,te,k)),se+=JF(ne,te,z),ne[te++]=se;ce=te,a.e=le,a.d=ce,a.a=ne,Ti(a)}function oG(){var a=ae.onbeforeunload,y=ae.onunload;ae.onbeforeunload=function(k){var z,E;try{z=mi(rq)()}finally{E=a&&a(k)}if(z!=null)return z;if(E!=null)return E},ae.onunload=mi(function(k){try{Ci(),Sp&&d8((!_o&&(_o=new E1),_o))}finally{y&&y(k),ae.onresize=null,ae.onscroll=null,ae.onbeforeunload=null,ae.onunload=null}})}function sG(a,y){var k,z,E,j,te,ne;if(!y)throw we(new ys("Cannot fire null event"));try{for(++a.b,te=(z=V9(a,y.le(),null),z),k=null,ne=a.c?te.Yf(te.size()):te.Xf();a.c?ne._f():ne.Ue();){j=a.c?ne.ag():ne.Ve();try{y.je(j)}catch(ie){if(ie=Xt(ie),ze(ie,20))E=ie,!k&&(k=new Si),Zn(k.a,E,k);else throw we(ie)}}if(k)throw we(new wm(k))}finally{--a.b,a.b==0&&SF(a)}}function cG(a,y,k,z){var E,j,te,ne,ie,se,ce,le,de,pe,me,je;ce=(z.offsetWidth||0)|0,se=y-ce,ie=(be(),Ie).Wd(z),se>0&&(me=(Ci(),(Vi(ue).clientWidth|0)+ko(ue)),pe=ko(ue),ne=me-ie,E=ie-pe,ne<y&&E>=se&&(ie-=se)),le=Ie.Xd(z),je=(Ci(),So(ue)),de=So(ue)+(Vi(ue).clientHeight|0),j=le-je,te=de-(le+((z.offsetHeight||0)|0)),te<k&&j>=k?le-=k:le+=(z.offsetHeight||0)|0,ll(a.qb,ie,le)}function uG(a,y){a.D=y,a.G="1",a&&(Re((!a.C&&(a.C=new un),a.C)).tkPid="1"),Hu((!a.F&&(a.F=new Pu(a)),a.F),(C1(),Vp),a),xC((!a.C&&(a.C=new un),a.C),a.G),W9(a,mn,a.a),!a.C&&(a.C=new un),a.i=new eg,NK((!a.C&&(a.C=new un),a.C),a.i),MK((!a.C&&(a.C=new un),a.C),new L5(a)),a.b=Xn(lv(a.D),new z4,(Du(),Du(),xl)),xt(a.i.d,Se(Ce(Ke,1),ve,1,5,[]))}function lG(a){var y={setter:function(k,z){k.b=z},getter:function(k){return k.b}};a.Gf(Il,"title",y);var y={setter:function(k,z){k.q=z},getter:function(k){return k.q}};a.Gf(Jt,Xy,y);var y={setter:function(k,z){k.n=Sc(z)},getter:function(k){return Xc(k.n)}};a.Gf(yn,wj,y);var y={setter:function(k,z){k.nb=z},getter:function(k){return k.nb}};a.Gf(In,mt,y)}function TV(a,y){var k;y.b=a.b,y.e=a.e,y.f=a.f,xo(y.a,$g(a.a)),k=(fe(),y.Xc).style,Pi(y,a.Xc.className||""),a.i>-1&&(k[ii]=a.i+(tt(),ke)),a.j>-1&&(k[ps]=a.j+(tt(),ke)),a.d>-1&&(k[Bt]=a.d+(tt(),ke)),a.n>-1&&(k[mt]=a.n+(tt(),ke)),a.k>-1&&(k[fn]=a.k+(tt(),ke)),a.g>-1&&(k[vn]=a.g+(tt(),ke))}function VV(a,y){var k,z,E,j,te,ne;j=(z=_e(a),z!=0?ro(z):ro(_e(Bn(a,32)))+32),te=(E=_e(y),E!=0?ro(E):ro(_e(Bn(y,32)))+32),ne=ae.Math.min(j,te),j!=0&&(a=Yn(a,j)),te!=0&&(y=Yn(y,te));do en(a,y)>=0?(a=cn(a,y),a=Yn(a,(k=_e(a),k!=0?ro(k):ro(_e(Bn(a,32)))+32))):(y=cn(y,a),y=Yn(y,(k=_e(y),k!=0?ro(k):ro(_e(Bn(y,32)))+32)));while(en(a,0)!=0);return _n(y,ne)}function zV(a,y,k){var z,E,j;j=0,E=0,z=k.d,a.ob>=y.col1&&y.col2>a.ob?(LT(a,y,k),Zn(a.Kb,y,k),j=1):(j=Wo(a.a.g,y.col1,y.col2+1),z.style[mt]=j+(tt(),ke)),a.Sc>=y.row1&&y.row2>a.Sc?(UT(a,y,k),Zn(a.Kb,y,k),E=1):(E=Wo(a.a.V.W,y.row1,y.row2+1),z.style[Bt]=E+(tt(),ke)),j==0||E==0?k.d.style[Pt]=(It(),tn):k.d.style[Pt]="flex"}function fG(a,y,k){var z,E,j,te,ne,ie,se,ce,le,de,pe,me,je;return pe=a.a,me=a.d,je=a.e,me==1?(z=Ve(pe[0],Xe),E=Ve(y,Xe),j=fs(z,E),se=ol(z,E),je!=k&&(j=tu(j)),je<0&&(se=tu(se)),Se(Ce(Wu,1),ve,11,0,[Lo(j),Lo(se)])):(ne=me,ie=je==k?1:-1,te=Le(gt,yt,17,ne,15,1),ce=Se(Ce(gt,1),yt,17,15,[EV(te,pe,me,y)]),le=new kn(ie,ne,te),de=new kn(je,1,ce),Ti(le),Ti(de),Se(Ce(Wu,1),ve,11,0,[le,de]))}function E0(a){var y,k,z,E,j,te,ne;if(sz(a,a.I,a.F,a.lb,a.ib,!0,a.H),te=a.Z?a.H+1:a.H,a.J.childNodes.length!=te){for(ns(a.J),E=1;E<=te;E++)ne=ba(ue),k=Oe(ue),xe(a.J,k),k.appendChild(ne),(be(),Ie).de(ne,""+E),k.className=kE,j=E,fe(),an.Ie(k,1),Ss(k,new w6(a,j));for(ns(a.D),z=1;z<=te-1;z++)y=Oe(ue),xe(a.D,y),y.className=_f,y.style[ps]=18*z+(tt(),ke)}}function EV(a,y,k,z){var E,j,te,ne,ie,se,ce;for(se=0,j=Ve(z,Xe),ne=k-1;ne>=0;ne--)ce=Zc(_n(se,32),Ve(y[ne],Xe)),en(ce,0)>=0?(ie=fs(ce,j),se=ol(ce,j)):(E=Yn(ce,1),te=z>>>1,ie=fs(E,te),se=ol(E,te),se=Vt(_n(se,1),Ve(ce,1)),z&1&&(en(ie,se)<=0?se=cn(se,ie):_k(cn(ie,se),j)?(se=Vt(se,cn(j,ie)),ie=cn(ie,1)):(se=Vt(se,cn(_n(j,1),ie)),ie=cn(ie,2)))),a[ne]=_e(Ve(ie,Xe));return _e(se)}function hG(a,y){var k,z;a.S=bw(a.Q,a.f,a.L),a.T=Fw(a.Q,a.f,a.L),a.R=qw(a.Q,a.f,a.L),a.g=!a.S&&!a.T,a.i=!a.S&&!a.R,a.t=dn(a.Q.zc),a.u=(a.Q.zc.scrollTop||0)|0,a.c=(k=ko(ue),xn(),(be(),y).type.indexOf(Gn)!=-1?As(y.changedTouches[0])+k:Dt(y.clientX||0)+k),a.d=(z=So(ue),y.type.indexOf(Gn)!=-1?Ts(y.changedTouches[0])+z:Dt(y.clientY||0)+z),a.U=a.f,a.V=a.L,xA(a)}function jV(a,y,k){var z,E,j,te,ne;for(j=0;j<y;j++){for(z=0,ne=j+1;ne<y;ne++)z=Vt(Vt(Oi(Ve(a[j],Xe),Ve(a[ne],Xe)),Ve(k[j+ne],Xe)),Ve(_e(z),Xe)),k[j+ne]=_e(z),z=Yn(z,32);k[j+y]=_e(z)}for(Qq(k,k,y<<1),z=0,E=0,te=0;E<y;++E,te++)z=Vt(Vt(Oi(Ve(a[E],Xe),Ve(a[E],Xe)),Ve(k[te],Xe)),Ve(_e(z),Xe)),k[te]=_e(z),z=Yn(z,32),++te,z=Vt(z,Ve(k[te],Xe)),k[te]=_e(z),z=Yn(z,32);return k}function dd(a){var y,k,z,E;z=new Ee(a.mg);try{return E=tT(new Ys(z,"getWidget")),k=A9(E),k}catch(j){throw j=Xt(j),ze(j,79)?(y=j,we(new R1("Default implementation of createWidget() does not work for "+hh(a.mg)+". This might be caused by explicitely using super.createWidget() or some unspecified problem with the widgetset compilation.",y))):we(j)}}function dG(a,y){var k,z,E,j,te,ne,ie,se,ce,le,de,pe,me,je;if(j=y.e,j==0)throw we(new Jr(By));return E=y.d,z=y.a,E==1?fG(a,z[0],j):(pe=a.a,me=a.d,k=me!=E?me>E?1:-1:pf(pe,z,me),k<0?Se(Ce(Wu,1),ve,11,0,[Do,a]):(je=a.e,ne=me-E+1,ce=E,ie=je==j?1:-1,te=Le(gt,yt,17,ne,15,1),se=g2(te,ne,pe,me,z,E),le=new kn(ie,ne,te),de=new kn(je,ce,se),Ti(le),Ti(de),Se(Ce(Wu,1),ve,11,0,[le,de])))}function aG(a,y){var k,z,E,j;return k=a.e<0?new kn(1,a.d,a.a):a,z=y.e<0?new kn(1,y.d,y.a):y,k.e==0?z:z.e==0?k:(k.d==1||k.d==2&&k.a[1]>0)&&(z.d==1||z.d==2&&z.a[1]>0)?Lo(VV((j=k.d>1?Zc(_n(k.a[1],32),Ve(k.a[0],Xe)):Ve(k.a[0],Xe),Oi(k.e,j)),(E=z.d>1?Zc(_n(z.a[1],32),Ve(z.a[0],Xe)):Ve(z.a[0],Xe),Oi(z.e,E)))):EG(_A(k),_A(z))}function r2(a,y){y?(mM(a.e,Ia(a.g.a)),ai(a.g,!1),a.e.style[Pt]=(It(),vi),a.e.focus(),a.e.select()):(sr(a.g,a.e.value),ai(a.g,!0),a.e.style[Pt]=(It(),tn),lD(a.r,Ia(a.g.a),a.b,a.d)),rn(a.f)&&(rn(a.a)||rn(a.g)||ye((It(),vi),Ru(a.e.style)))?(Cs(a.f).className||"").indexOf(Ri)!=-1||vt(a.f,Ri,!0):(Cs(a.f).className||"").indexOf(Ri)!=-1&&vt(a.f,Ri,!1)}function ad(a,y,k){var z,E;a._=!0,dl(a.$,"."+a.Ac+" .sheet div"+(sp+a.rc+".row"+a.sc),0),Pi(a.sb,qe+a.rc+Ye+a.sc+" cell "+(E=m8(a,a.rc,a.sc),E?E.cellStyle:"cs0")),rd(a,qe+a.rc+Ye+a.sc)&&(a.ab=!0,z=Ui(a,qe+a.rc+Ye+a.sc),z&&lw(a.sb,AN(z.d.style))),RH(a),y&&(Gh(a,a.rc,a.sc)||yu(a,a.rc,a.sc),Ct((ut(),pt),new gh(a,!1))),Ct((ut(),pt),new g6(a,k)),Ii(a.sb,k)}function Wi(a){var y,k,z,E,j;if(a==null)throw we(new yo(Ro));for(z=a.length,E=z>0&&(Tt(0,a.length),a.charCodeAt(0)==45||(Tt(0,a.length),a.charCodeAt(0)==43))?1:0,y=E;y<z;y++)if(vH((Tt(y,a.length),a.charCodeAt(y)))==-1)throw we(new yo(Ef+a+'"'));if(j=parseInt(a,10),k=j<xu,isNaN(j))throw we(new yo(Ef+a+'"'));if(k||j>Ki)throw we(new yo(Ef+a+'"'));return j}function bd(a,y,k){var z,E,j,te,ne,ie,se;y==0?y=1:y<0&&(y=xf(a.V)+1),y>a.i&&(y=a.i),k==0?k=1:k<0&&(k=vf(a.V)+1),k>a.O&&(k=a.O),ne=a.V.rc,ie=a.V.sc,y<=ne?(z=y,E=ne):(z=ne,E=y),k<=ie?(j=k,te=ie):(j=ie,te=k),a.u.f?If(a.u,a.X,a.Y,y,k,!1):(se=ti(a.I,j,te,z,E),Ei(a.V,se.col1,se.col2,se.row1,se.row2),Fn(a.V,se.col1,se.col2,se.row1,se.row2,!0),Vc(a.u,fH(se.col1,se.col2,se.row1,se.row2)))}function bG(a,y,k,z,E,j){var te,ne,ie,se,ce,le,de;for(se=c9(y)-c9(a),te=ET(y,se),ie=Zt(0,0,0);se>=0&&(ne=qH(a,te),!(ne&&(se<22?ie.l|=1<<se:se<44?ie.m|=1<<se-22:ie.h|=1<<se-44,a.l==0&&a.m==0&&a.h==0)));)ce=te.m,le=te.h,de=te.l,te.h=le>>>1,te.m=ce>>>1|(le&1)<<21,te.l=de>>>1|(ce&1)<<21,--se;return k&&Ya(ie),j&&(z?(wr=ou(a),E&&(wr=t9(wr,(nu(),lx)))):wr=Zt(a.l,a.m,a.h)),ie}function Nr(a,y,k){var z,E,j,te,ne,ie,se,ce;for(z=new RegExp(y,"g"),se=Le(ct,Mi,2,0,6,1),E=0,ce=a,te=null;;)if(ie=z.exec(ce),ie==null||ce==""||E==k-1&&k>0){se[E]=ce;break}else ne=ie.index,se[E]=ce.substr(0,ne),ce=Zo(ce,ne+ie[0].length,ce.length),z.lastIndex=0,te==ce&&(se[E]=ce.substr(0,1),ce=ce.substr(1)),te=ce,++E;if(k==0&&a.length>0){for(j=se.length;j>0&&se[j-1]=="";)--j;j<se.length&&(se.length=j)}return se}function pG(a,y){var k,z,E,j;z=!a.c.vb&&!!(be(),y).ctrlKey||!!(be(),y).metaKey,j=Kr(y),E=Q_(a.c,j),!(!z||!E)&&((((be(),y).keyCode|0)==67||(y.keyCode|0)==88)&&((Tc(),Fd).Ze((fe(),a.Xc)),Ii(a,zU(a.a)),k=zs(a.Xc,Nf).length,k>0&&Ym(a,0,k),a.Xc.style[vn]=(tt(),"100.0px"),Qh((ut(),new d6(a,y)),100)),(y.keyCode|0)==86&&((fe(),a.Xc)[Nf]="",(Tc(),Fd).Ze(a.Xc),Qh((ut(),new a5(a)),100)))}function OV(){var a,y,k,z,E,j,te,ne,ie,se;for(this.a=new Si,new Ot,a=ue,a.getElementsByTagName(dp)[0],ie=a.getElementsByTagName("script"),E=0;E<ie.length;E++)y=ie[E],se=y.src,se!=null&&se.length!=0&&Ut(this.a,se);for(te=a.getElementsByTagName(Id),z=0;z<te.length;z++)j=te[z],ne=j.rel,k=j.href,cl(ay,ne)&&k!=null&&k.length!=0&&Ut(this.a,k),cl("import",ne)&&k!=null&&k.length!=0&&Ut(this.a,k)}function gG(a,y){var k,z;if(!a.c._){if(!a.b)return;if(z=(be(),y).keyCode|0,k=Ie.Rd(y),(k==122||k==121)&&(y.ctrlKey||y.metaKey)){Ie.Vd(y),y.stopPropagation();return}if(k==0)switch(z){case 38:case 40:case 37:case 39:case 9:case 8:case 46:case 32:Ie.Vd(y),y.stopPropagation();break;case 13:D0(a.c.a,y,String.fromCharCode(k))}else!y.ctrlKey&&!y.metaKey&&D0(a.c.a,y,String.fromCharCode(k))}}function wG(a,y,k,z,E){var j,te;if(j=Vt(Ve(y[0],Xe),Ve(z[0],Xe)),a[0]=_e(j),j=Bn(j,32),k>=E){for(te=1;te<E;te++)j=Vt(j,Vt(Ve(y[te],Xe),Ve(z[te],Xe))),a[te]=_e(j),j=Bn(j,32);for(;te<k;te++)j=Vt(j,Ve(y[te],Xe)),a[te]=_e(j),j=Bn(j,32)}else{for(te=1;te<k;te++)j=Vt(j,Vt(Ve(y[te],Xe),Ve(z[te],Xe))),a[te]=_e(j),j=Bn(j,32);for(;te<E;te++)j=Vt(j,Ve(z[te],Xe)),a[te]=_e(j),j=Bn(j,32)}en(j,0)!=0&&(a[te]=_e(j))}function XV(a,y,k){var z,E,j,te,ne,ie,se,ce,le;if(j=y-1,se=k-1,se<0||j<0)return null;if(a.Sc<k){if(le=k>=a.db,ce=a.d.a.length>k-a.db,le&&ce&&(te=Ze(a.d,k-a.db).a.length>j,te))return Ze(Ze(a.d,k-a.db),j)}else if(a.ob<y){if(ne=y-a.bb,ce=a.Qc.a.length>se,ce&&(ie=y>=a.bb,te=Ze(a.Qc,se).a.length>ne,ie&&te))return Ze(Ze(a.Qc,se),ne)}else if(E=se*a.ob+j,z=a.Mc.a.length>E,E>=0&&z)return Ze(a.Mc,E);return null}function WV(a,y,k,z,E){var j,te;j=null,y!=null&&(j=wT(z),!j&&Mh(jn((ht(Qn),Qn.k)),"Did not find the link tag for the old theme ("+z+"), adding a new stylesheet for the new theme ("+E+")")),k!=null?(te=CP(ue),te.rel=ay,te.type=Fs,te.href=E,FU(te,new vI(a,k,E,j),null),j?f8(ue.getElementsByTagName(dp)[0],te,j):xe(ue.getElementsByTagName(dp)[0],te)):(j&&Jo(qt((be(),j)),j),Gm(a,null))}function vG(a,y){var k,z,E,j,te,ne,ie,se;a.o=!0,k=(te=ko(ue),xn(),(be(),y).type.indexOf(Gn)!=-1?As(y.changedTouches[0])+te:Dt(y.clientX||0)+te),z=(ne=So(ue),y.type.indexOf(Gn)!=-1?Ts(y.changedTouches[0])+ne:Dt(y.clientY||0)+ne),!UV(a,z,k)&&(ie=k-a.v+dn(a.Q.zc)-a.t,se=z-a.w+((a.Q.zc.scrollTop||0)|0)-a.u,ie-=70,se-=20,E=a.q.g,j=a.q.V.W,a.U=C0(E,a.O,ie,!0),a.V=C0(j,a.P,se,!0),bd(a.Q.a,a.U,a.V))}function KV(a,y){var k,z,E,j,te,ne,ie,se,ce,le;a.j=!1,a.s=!1,k=(ie=ko(ue),xn(),(be(),y).type.indexOf(Gn)!=-1?As(y.changedTouches[0])+ie:Dt(y.clientX||0)+ie),z=(se=So(ue),y.type.indexOf(Gn)!=-1?Ts(y.changedTouches[0])+se:Dt(y.clientY||0)+se),!UV(a,z,k)&&(ce=k-a.v+dn(a.Q.zc)-a.t,le=z-a.w+((a.Q.zc.scrollTop||0)|0)-a.u,j=a.q.g,ne=a.q.V.W,E=C0(j,a.e,ce,!1),te=C0(ne,a.K,le,!1),E>=0&&te>=0&&DV(a,E,te))}function LV(a){var y,k,z,E,j,te,ne,ie;ne=a.a.n;try{for(E=new ef(new Gr(ne)),zn(),AP(E.a,E.a.length),j=E.a.length,te=new Bu(pm(a.Dc)),k=0;k<j;k++)z=(pn(k,E.a.length),E.a[k]),ie=mh(Ph(ne.a,z)),rt(te,cp+a.Ac+" .sheet .cell.cf"+z+" {"+ie+"}");ns(a.Dc),xe(a.Dc,ww(ue,te.a))}catch(se){if(se=Xt(se),ze(se,21))y=se,Tr(a.U,"SheetWidget:updateConditionalFormattingStyles: "+Yu(y,y.Gd())+CE);else throw we(se)}}function MV(a,y){var k,z,E,j,te,ne;return E=jv(a),ne=jv(y),E==ne?a.e==y.e&&a.a<54&&y.a<54?a.f<y.f?-1:a.f>y.f?1:0:(z=a.e-y.e,k=(a.d>0?a.d:ae.Math.floor((a.a-1)*pp)+1)-(y.d>0?y.d:ae.Math.floor((y.a-1)*pp)+1),k>z+1?E:k<z-1?-E:(j=(!a.c&&(a.c=ss(a.f)),a.c),te=(!y.c&&(y.c=ss(y.f)),y.c),z<0?j=Wr(j,O0(-z)):z>0&&(te=Wr(te,O0(z))),s0(j,te))):E<ne?-1:1}function mG(a){var y,k,z,E,j,te,ne,ie;for(lt(a.fb),j=new Fe(a.K);j.a<j.c.a.length;)z=He(j),te=qt((be(),z)),te&&te.removeChild(z);for(a.K.a=Le(Ke,ve,1,0,5,1),E=new Fe(a.ic);E.a<E.c.a.length;)z=He(E),te=qt((be(),z)),te&&te.removeChild(z);for(a.ic.a=Le(Ke,ve,1,0,5,1),ie=new Fe(a.kc);ie.a<ie.c.a.length;){for(ne=He(ie),k=new Fe(ne);k.a<k.c.a.length;)y=He(k),lt(y.d);ne.a=Le(Ke,ve,1,0,5,1)}a.kc.a=Le(Ke,ve,1,0,5,1)}function yG(a,y){var k,z,E,j,te;if(!a.Cc&&(a.Cc=new Ot),z=y.b,te=y.k,E=qe+z+Ye+te,z!=0&&te!=0)Te(a.Cc,E,y),(z>=a.bb&&z<=a.xb&&te>=a.db&&te<=a.zb||z<=a.ob&&te<=a.Sc||z>a.ob&&z<=a.xb&&te<=a.Sc||te>a.Sc&&te<=a.zb&&z<=a.ob)&&(k=Rt(a,z,te),j=y.Wc,j?a==j?Kl(k,(fe(),y.Xc)):(br(y),Kl(k,(fe(),y.Xc)),qn(y,a)):(Kl(k,(fe(),y.Xc)),qn(y,a)));else{for(;bn(a.Cc,E);)G3(y,--z),E=qe+z+Ye+te;Te(a.Cc,E,y)}K8(y,a,a.zc)}function xG(a,y){var k,z,E,j,te,ne;for(a.Db=!1,E=new Fe($9(a));E.a<E.c.a.length;)z=He(E),gd(a,z);for(a.S=null,ne=(j=new di(a.Bc).a.Wf().Ke(),new yr(j));ne.a.Ue();)te=(k=ne.a.Ve(),k.dg()),gd(a,te);Mt(a.Bc),a.T&&(Mt(a.T),a.T=null),mG(a),Mt(a.e),Mt(a.qc),ls(a.w),P6(a),is(a),WI(a),wH(a),I$(a),y&&(ls(a.Ec),lt(a.w),lt(a.Dc),lt(a.Ec),lt(a.$),lt(a.Wb),lt(a.Fb),a.pb&&lt(a.pb),a.Nb&&(Sr(a.Nb.a),a.Nb=null))}function CG(a,y,k,z,E){return(y<=a.ob||y>=cd(a)&&y<=xf(a))&&(z<=a.Sc||z<=id(a)&&z>=vf(a))&&(y>=a.bb&&y<=a.xb&&E>=a.db&&E<=a.zb||y<=a.ob&&E<=a.Sc||y>a.ob&&y<=a.xb&&E<=a.Sc||E>a.Sc&&E<=a.zb&&y<=a.ob)&&(k>=a.bb&&k<=a.xb&&z>=a.db&&z<=a.zb||k<=a.ob&&z<=a.Sc||k>a.ob&&k<=a.xb&&z<=a.Sc||z>a.Sc&&z<=a.zb&&k<=a.ob)&&(k>=a.bb&&k<=a.xb&&E>=a.db&&E<=a.zb||k<=a.ob&&E<=a.Sc||k>a.ob&&k<=a.xb&&E<=a.Sc||E>a.Sc&&E<=a.zb&&k<=a.ob)}function If(a,y,k,z,E,j){var te,ne,ie,se,ce,le,de,pe,me,je;y==z&&k==E?te=uf(y,k):(y>z&&(me=y,y=z,z=me),k>E&&(me=k,k=E,E=me),te=uf(y,k)+":"+uf(z,E)),j&&a.s>=0&&(te=","+te,++a.q),ce=$N(a.e),ie=ce>0,ie?(le=Is(a.e),ne=le+ce,a.s=le,a.q=ne):j||a.s<0?(le=a.q,ne=a.q,a.s=a.q):(le=a.s,ne=a.q),je=(se=Gt(a.e),se??""),de=je.substr(0,le),pe=Zo(je,ne,je.length),je=de+te+pe,a.q=(de+te).length,Ii(a.e,je),a.e==a.w&&Ii(a.j,je),Ct((ut(),pt),new w5(a))}function kG(a,y){var k,z,E;z=(fe(),tI(ue)),a.d=eI(ue),xe(z,Vr(a.d)),y||(E=Dw(ue),xe(a.d,Vr(E))),a.i=y,k=(yh(),r1).Ye(),xe(k,Vr(z)),bo(a,k),yd(),jk(tx,a.Xc),a.Uc==-1?Js(a.Xc,2225|(a.Xc.__eventBits||0)):a.Uc|=2225,a.Xc.className="gwt-MenuBar",y?vt(a,Fi(a.Xc)+"-vertical",!0):vt(a,Fi(a.Xc)+"-horizontal",!0),a.Xc.style.outline="0px",a.Xc.setAttribute("hideFocus","true"),Xn(a,new c5(a),(Th(),Th(),Gf))}function pd(a){var y,k;a.c?(y=qi(a.c),k=Vn(a.c),y>=bi(a.o)&&y<qi(a.o)&&k>=Vn(a.o)&&k<=gi(a.o)?(tz(a),(fe(),a.Xc).style[ot]=ni,a.t&&(a.t.style[ot]=ni),a.i.style[ot]=(at(),ni),a.M||eu(a)):((fe(),a.Xc).style[ot]=dt,a.t&&(a.t.style[ot]=dt),a.i.style[ot]=(at(),dt))):((fe(),a.Xc).style[ot]=dt,a.t&&(a.t.style[ot]=dt),a.i.style[ot]=(at(),dt),Pn(a,!1),lt(a.i))}function o2(a,y){var k,z,E,j,te,ne,ie,se,ce,le;for(OT(a),ce=VH(a,y),Mt(a.G),E=0,z=0,se=new Fe(ce);se.a<se.c.a.length;)ie=He(se),ne=V0(a,ie),ne&&(bn(a.G,ie)?k=Nt(a.G,ie):(z=z%ri.a.length,k=Ze(ri,z),Te(a.G,ie,k),++z),k=au(k,"%s","0.25"),JU(a,ne,k),te=y.indexOf(ie,E),j=(fe(),ba(ue)),le=y.substr(E,te-E),le=Dn(le," ","&nbsp;"),j.innerHTML=le||"",xe(a.r,j),E=te+ie.length,j=ba(ue),(be(),Ie).de(j,ie),j.style[ml]=k,xe(a.r,j))}function gd(a,y){var k,z,E,j,te;try{return k=(fe(),y.Xc),j=qt((be(),k)),te=y.Wc,z=En(a.zc,j)||En(a.Nc,j)||En(a.Pc,j)||En(a.c,j),z||dr(y,a.S)||j&&j.parentNode&&Io(a.zc,j.parentNode)?(qn(y,null),E=qt(k),E&&E.removeChild(k),!0):dr(a,te)?(qn(y,null),!0):!1}catch(ne){if(ne=Xt(ne),ze(ne,21))Q9(a.U,(Nn(),Kp),"Exception while removing child widget from SheetWidget");else throw we(ne)}return!1}function SG(a,y){var k,z,E,j,te,ne;for(E=new Fe(y);E.a<E.c.a.length;)if(z=He(E),ne=qe+z.col+Ye+z.row,z.value==null?Eo(a.e,ne):Te(a.e,ne,z),!zv(a,ne,z.value,z.cellStyle,z.needsMeasure))for(j=null,OI(a,z.col,z.row)?j=Ze(Ze(a.kc,z.row-a.db),z.col-a.bb):bf(a,z.col,z.row)&&(j=XV(a,z.col,z.row)),j&&(Zu(j,z.value,z.cellStyle,z.needsMeasure),j.g=!0),te=a.Sc>0?0:a.bb;te<z.col;te++)k=Rt(a,te,z.row),k&&(k.g=!0);sl(a,!1)}function s2(a){var y,k,z,E,j;if(z=a.Lc+((a.zc.scrollTop||0)|0),k=dn(a.zc),j=z-a.Pb,y=k-a.Ob,!(ae.Math.abs(j)<(a.a.L/2|0)&&ae.Math.abs(y)<(a.a.j/2|0))){try{ae.Math.abs(y)>(a.a.j/2|0)&&(a.Ob=k,y>0?tV(a,k):y<0&&hV(a,k)),ae.Math.abs(j)>(a.a.L/2|0)&&(a.Pb=z,j>0?JT(a,z):j<0&&lV(a,z)),Vs(a.Rb)}catch(te){if(te=Xt(te),ze(te,20))E=te,Tr(a.U,"SheetWidget:updateSheetDisplay: "+Yu(E,E.Gd()));else throw we(te)}d0(a),wd(a,j,y),bV(a)}}function NV(){Pw.call(this),this.q=new rg,this.c=new ng,this.e=new Ot,this.e.put("error",new of("Error: "," - close with ESC-key",(ja(),Xu))),this.e.put("warning",new of("Warning: ",null,Xu)),this.e.put("humanized",new of("Info: ",null,Xu)),this.e.put("tray",new of("Status: ",null,Xu)),this.e.put("assistive",new of("Note: ",null,Xu)),this.g=new tg,this.d=new Sg,this.j=new tm,this.k=new ig,this.lb="v-ui",this.n=1}function j0(a,y){var k,z,E,j,te,ne,ie,se,ce,le;if(te=a.e,ie=y.e,ie==0)return a;if(te==0)return y.e==0?y:new kn(-y.e,y.d,y.a);if(j=a.d,ne=y.d,j+ne==2)return k=Ve(a.a[0],Xe),z=Ve(y.a[0],Xe),te<0&&(k=tu(k)),ie<0&&(z=tu(z)),Lo(cn(k,z));if(E=j!=ne?j>ne?1:-1:pf(a.a,y.a,j),E==-1)le=-ie,ce=te==ie?La(y.a,ne,a.a,j):Pa(y.a,ne,a.a,j);else if(le=te,te==ie){if(E==0)return Xi(),Do;ce=La(a.a,j,y.a,ne)}else ce=Pa(a.a,j,y.a,ne);return se=new kn(le,ce.length,ce),Ti(se),se}function IG(a,y){var k,z,E,j,te;if(a.s?(Mt(a.s),y&&nl(a.s,y)):a.s=y,y&&y.a.c+y.b.c!=0){for(te=new Bi,E=(j=new Gr(y).a.Wf().Ke(),new po(j));E.a.Ue();)k=au(au((z=E.a.Ve(),z.cg()),qe,sp)," r",".r"),te.a+=""+k,E.a.Ue()&&(te.a+=",");a.pb?dl(a.pb,te.a,0):(a.pb=Uu(ue),a.pb.type=Fs,ms(a.pb,a.Ac+"-hyperlinkstyle"),xe(a.w.parentNode,a.pb),te.a+="{ cursor: pointer !important; }",zr(a.pb,te.a))}else a.pb&&dl(a.pb,up,0)}function AG(a){var y,k,z,E,j,te,ne,ie,se,ce,le,de,pe;if(se=new Ot,a!=null&&a.length>1){for(ce=a.substr(1),te=Nr(ce,"&",0),ne=0,ie=te.length;ne<ie;++ne)if(j=te[ne],E=Nr(j,"=",2),z=E[0],z.length!=0){le=E.length>1?E[1]:"";try{le=(Wq(le),pe=/\+/g,decodeURIComponent(le.replace(pe,"%20")))}catch(me){if(me=Xt(me),!ze(me,81))throw we(me)}de=se.get(z),de||(de=new st,se.put(z,de)),de.add(le)}}for(k=se.Wf().Ke();k.Ue();)y=k.Ve(),y.eg(VI(y.dg()));return se=(zn(),new sC(se)),se}function wd(a,y,k){var z,E,j,te,ne,ie,se;E=Ze(Ze(a.kc,0),0),se=Ze(a.kc,a.kc.a.length-1),ne=Ze(se,se.a.length-1),j=E.k,ie=ne.k,z=E.c,te=ne.c,yf(a),j>a.zb||ie<a.db||z>a.xb||te<a.bb?(f2(a,a.db,a.zb,a.bb,a.xb,a.kc,a.zc),y!=0&&a.ob>0&&f2(a,a.db,a.zb,1,a.ob,a.d,a.c),k!=0&&a.Sc>0&&f2(a,1,a.Sc,a.bb,a.xb,a.Qc,a.Pc)):(y2(a,y,k,a.db,a.zb,a.bb,a.xb,a.kc,a.zc),y!=0&&a.ob>0&&y2(a,y,0,a.db,a.zb,1,a.ob,a.d,a.c),k!=0&&a.Sc>0&&y2(a,0,k,1,a.Sc,a.bb,a.xb,a.Qc,a.Pc))}function c2(a,y){var k,z,E,j,te,ne,ie,se,ce,le;if(y.e==0)throw we(new Jr(By));return E=y.e,y.d==1&&y.a[0]==1?y.e>0||a.e==0?a:new kn(-a.e,a.d,a.a):(ce=a.e,se=a.d,z=y.d,se+z==2?(le=fs(Ve(a.a[0],Xe),Ve(y.a[0],Xe)),ce!=E&&(le=tu(le)),Lo(le)):(k=se!=z?se>z?1:-1:pf(a.a,y.a,se),k==0?ce==E?Al:u1:k==-1?Do:(te=se-z+1,j=Le(gt,yt,17,te,15,1),ne=ce==E?1:-1,z==1?EV(j,a.a,se,y.a[0]):g2(j,te,a.a,se,y.a,z),ie=new kn(ne,te,j),Ti(ie),ie)))}function TG(a,y,k,z,E,j){var te,ne;Eo(a.Cc,qe+z+Ye+k),Te(a.Cc,qe+j+Ye+E,y),ne=y.Wc,j>=a.bb&&j<=a.xb&&E>=a.db&&E<=a.zb||j<=a.ob&&E<=a.Sc||j>a.ob&&j<=a.xb&&E<=a.Sc||E>a.Sc&&E<=a.zb&&j<=a.ob?(te=Rt(a,j,E),ne?dr(a,ne)?((z>=a.bb&&z<=a.xb&&k>=a.db&&k<=a.zb||z<=a.ob&&k<=a.Sc||z>a.ob&&z<=a.xb&&k<=a.Sc||k>a.Sc&&k<=a.zb&&z<=a.ob)&&rw(Rt(a,z,k)),Kl(te,(fe(),y.Xc))):(br(y),Kl(te,(fe(),y.Xc)),qn(y,a)):(Kl(te,(fe(),y.Xc)),qn(y,a))):ne&&br(y)}function VG(a,y){var k,z;a.S=bw(a.Q,a.f,a.L),a.T=Fw(a.Q,a.f,a.L),a.R=qw(a.Q,a.f,a.L),a.g=!a.S&&!a.T,a.i=!a.S&&!a.R,a.t=dn(a.Q.zc),a.u=(a.Q.zc.scrollTop||0)|0,a.c=(k=ko(ue),xn(),(be(),y).type.indexOf(Gn)!=-1?As(y.changedTouches[0])+k:Dt(y.clientX||0)+k),a.d=(z=So(ue),y.type.indexOf(Gn)!=-1?Ts(y.changedTouches[0])+z:Dt(y.clientY||0)+z),a.U=a.f,a.V=a.L,a.C=!0,a.j=!1,a.s=!1,xA(a),uN((fe(),a.Xc)),Ie.Vd(y),Ue(Re(a.Q),"selecting"),hd(a,!0)}function O0(a){No();var y,k,z,E;if(y=bt(a),a<Tl.length)return Tl[y];if(a<=50)return al((Xi(),Xp),y);if(a<=_r)return Xo(al($r[1],y),y);if(a>1e6)throw we(new Jr("power of ten too big"));if(a<=Ki)return Xo(al($r[1],y),y);for(z=al($r[1],Ki),E=z,k=lr(a-Ki),y=bt(a%Ki);en(k,Ki)>0;)E=Wr(E,z),k=cn(k,Ki);for(E=Wr(E,al($r[1],y)),E=Xo(E,Ki),k=lr(a-Ki);en(k,Ki)>0;)E=Xo(E,Ki),k=cn(k,Ki);return E=Xo(E,y),E}function zG(a){if(a.offsetTop==null)return 0;var y=0,k=a.ownerDocument,z=a.parentNode;if(z)for(;z.offsetParent;)y-=z.scrollTop,z=z.parentNode;for(;a;){if(y+=a.offsetTop,k.defaultView.getComputedStyle(a,"")[as]==Q0)return y+=k.body.scrollTop,y;var E=a.offsetParent;if(E&&ae.devicePixelRatio&&(y+=parseInt(k.defaultView.getComputedStyle(E,"").getPropertyValue("border-top-width"))),E&&E.tagName=="BODY"&&a.style.position==Su)break;a=E}return y}function RV(a){var y,k,z;a.W=Le(gt,yt,17,a.a.O,15,1),a.Lc=0,z=0,a.Sc>0&&(z=x9(a,1,a.Sc),a.Lc=bt(z+1)),y=x9(a,a.Sc+1,a.a.O),a.Bb=0,a.ob>0&&(a.Bb=vA(a,1,a.ob)),k=vA(a,a.ob+1,a.a.i),_0(a),z>0&&a.Bb>0?zt(a.Nc,qf):Ue(a.Nc,qf),z>0?zt(a.Pc,qf):Ue(a.Pc,qf),a.Bb>0?zt(a.c,qf):Ue(a.c,qf),a.Pc.style[ii]=(tt(),Ni),a.c.style[ps]=Ni,a.I.style[ii]=Ni,a.gc.style[ii]=Ni,kf(a),a.fb.style[Bt]=y+ke,a.fb.style[mt]=k+ke,a.c.style[Bt]=y+ke,a.Pc.style[mt]=k+ke}function X0(a){var y,k;for(a.ib?a.ob>0?FT(a):(P9(a.ib),a.ib=null):a.ob>0&&(a.ib=new st,FT(a)),k=a.bb;k<=a.xb;k++)k>a.ob?(k-a.bb<a.K.a.length?y=Ze(a.K,k-a.bb):(y=Oe(ue),xe(a.Pc,y),Eh(a.K,k-a.bb,y)),y.className=ty+k||"",O1(y,Rv(k)+fp),Bl(a.tc,he(k))&&Ue(y,Pd)):Tr(a.U,"Trying to add plain column header (index:"+k+") into frozen pane, horizontalSplitPosition: "+a.ob);for(;a.K.a.length>a.xb-a.bb+1;)lt(Or(a.K,a.K.a.length-1))}function W0(a){var y,k;for(a.jb?a.Sc>0?GT(a):(P9(a.jb),a.jb=null):a.Sc>0&&(a.jb=new st,GT(a)),y=a.db;y<=a.zb;y++)a.Sc<y?(y-a.db<a.ic.a.length?k=Ze(a.ic,y-a.db):(k=Oe(ue),xe(a.c,k),Eh(a.ic,y-a.db,k)),k.className=ny+y||"",k.innerHTML=""+y+fp||"",Bl(a.wc,he(y))&&Ue(k,Rd)):Tr(a.U,"Trying to add plain row header (index:"+y+") into frozen pane, verticalSplitPosition: "+a.Sc);for(;a.ic.a.length>a.zb-a.db+1;)lt(Or(a.ic,a.ic.a.length-1))}function K0(a,y,k,z){var E,j,te,ne,ie;if(j=Ui(a,qe+z.c+Ye+z.k),j)return j;if(ie=z.d,te=z.c,ne=z.k,E=!1,y<(be(),Ie).Wd(ie)&&z.c>a.bb){for(--te;Vo(a.a,te)&&te>a.bb;)--te;E=!0}else if(y>Ie.Wd(ie)+((ie.offsetWidth||0)|0)&&z.c<a.xb){for(++te;Vo(a.a,te)&&te<a.xb;)++te;E=!0}if(k<Ie.Xd(ie)&&z.k>a.db){for(--ne;Cn(a.a,ne)&&ne>a.db;)--ne;E=!0}else if(k>Ie.Xd(ie)+((ie.offsetHeight||0)|0)&&z.k<a.zb){for(++ne;Cn(a.a,ne)&&ne<a.zb;)++ne;E=!0}return E?K0(a,y,k,Rt(a,te,ne)):z}function u2(a,y){var k,z,E,j,te,ne,ie;for(E=a.c.yc.e,te=a.c.yc.f,ie=a.c.yc.K,k=a.c.yc.L,z=a.c.rc,ne=a.c.sc,j=Ir(a.d,z,ne),j&&a.a!=0&&(z=a.a,ne=j.row1),--ne;a.d.w&&et(a.d.w,he(ne),0)!=-1&&ne>1;)--ne;if(!y&&(E!=te||ie!=k)&&(!j||E!=j.col1||te!=j.col2||ie!=j.row1||k!=j.row2)){if(ne<ie){for(ne=k;a.d.w&&et(a.d.w,he(ne),0)!=-1&&ne>ie;)--ne;for(--z;a.d.v&&et(a.d.v,he(z),0)!=-1&&z>=E;)--z;for(z<E&&(z=te);a.d.v&&et(a.d.v,he(z),0)!=-1&&z>=E;)--z}b0(a,z,ne)}else ne>0&&o0(a,z,ne)}function vd(a,y){var k,z,E,j,te,ne,ie;for(E=a.c.yc.e,te=a.c.yc.f,ie=a.c.yc.K,k=a.c.yc.L,z=a.c.rc,ne=a.c.sc,j=Ir(a.d,z,ne),j&&a.a!=0&&(z=a.a,ne=j.row2),++ne;a.d.w&&et(a.d.w,he(ne),0)!=-1&&ne<a.d.O;)++ne;if(!y&&(E!=te||ie!=k)&&(!j||E!=j.col1||te!=j.col2||ie!=j.row1||k!=j.row2)){if(ne>k){for(ne=ie;a.d.w&&et(a.d.w,he(ne),0)!=-1&&ne<k;)++ne;for(++z;a.d.v&&et(a.d.v,he(z),0)!=-1&&z<=te;)++z;for(z>te&&(z=E);a.d.v&&et(a.d.v,he(z),0)!=-1&&z<=te;)++z}b0(a,z,ne)}else ne<=a.d.O&&o0(a,z,ne)}function L0(a,y){var k,z,E,j,te,ne,ie;for(E=a.c.yc.e,te=a.c.yc.f,ie=a.c.yc.K,k=a.c.yc.L,z=a.c.rc,ne=a.c.sc,j=Ir(a.d,z,ne),j&&a.b!=0&&(z=j.col2,ne=a.b),++z;a.d.v&&et(a.d.v,he(z),0)!=-1&&z<a.d.i;)++z;if(!y&&(E!=te||ie!=k)&&(!j||E!=j.col1||te!=j.col2||ie!=j.row1||k!=j.row2)){if(z>te){for(z=E;a.d.v&&et(a.d.v,new p1(z),0)!=-1&&z<=te;)++z;for(++ne;a.d.w&&et(a.d.w,he(ne),0)!=-1&&ne<=k;)++ne;for(ne>k&&(ne=ie);a.d.w&&et(a.d.w,he(ne),0)!=-1&&ne<=k;)++ne}b0(a,z,ne)}else z<=a.d.i&&o0(a,z,ne)}function l2(a,y){var k,z,E,j,te,ne,ie;for(E=a.c.yc.e,te=a.c.yc.f,ie=a.c.yc.K,k=a.c.yc.L,z=a.c.rc,ne=a.c.sc,j=Ir(a.d,z,ne),j&&a.b!=0&&(z=j.col1,ne=a.b),--z;a.d.v&&et(a.d.v,he(z),0)!=-1&&z>0;)--z;if(!y&&(E!=te||ie!=k)&&(!j||E!=j.col1||te!=j.col2||ie!=j.row1||k!=j.row2)){if(z<E){for(z=te;a.d.v&&et(a.d.v,he(z),0)!=-1&&z>=E;)--z;for(--ne;a.d.w&&et(a.d.w,he(ne),0)!=-1&&ne>=ie;)--ne;for(ne<ie&&(ne=k);a.d.w&&et(a.d.w,he(ne),0)!=-1&&ne>=ie;)--ne}b0(a,z,ne)}else z>0&&o0(a,z,ne)}function EG(a,y){var k,z,E,j,te,ne;k=Fh(a),z=Fh(y),E=ae.Math.min(k,z),v0(a,k),v0(y,z),s0(a,y)==1&&(j=a,a=y,y=j);do{if(y.d==1||y.d==2&&y.a[1]>0){y=Lo(VV((ne=a.d>1?Zc(_n(a.a[1],32),Ve(a.a[0],Xe)):Ve(a.a[0],Xe),Oi(a.e,ne)),(te=y.d>1?Zc(_n(y.a[1],32),Ve(y.a[0],Xe)):Ve(y.a[0],Xe),Oi(y.e,te))));break}if(y.d>a.d*1.2)y=CU(y,a),y.e!=0&&v0(y,Fh(y));else do aT(y.a,y.a,y.d,a.a,a.d),Ti(y),y.b=-2,v0(y,Fh(y));while(s0(y,a)>=0);j=y,y=a,a=j}while(a.e!=0);return Xo(y,E)}function jG(a,y){var k,z,E,j,te,ne;try{if(j=Ha(a),!j){Tr(a.U,"Selected cell is null");return}for(Fl(j,y),te=u9(a,j.b,y),k=j.c,a.ab?(E=ql(a.a,a.rc,a.sc),k=E.col2,ne=Wo(a.a.g,E.col1,E.col2+1)):ne=Ft(a.a,k);ne<te&&k<a.a.i;)ne+=Ft(a.a,++k);Y1(a.sb,ne+1+ke)}catch(ie){if(ie=Xt(ie),ze(ie,21))z=ie,Tr(a.U,"SheetWidget:recalculateInputElementWidth: "+Yu(z,z.Gd())+" while calculating input element width"),Gh(a,a.rc,a.sc)||yu(a,a.rc,a.sc),Ct((ut(),pt),new gh(a,!1));else throw we(ie)}}function M0(){M0=ge,QW=Se(Ce(gt,1),yt,17,15,[xu,1162261467,qy,_y,362797056,1977326743,qy,387420489,jd,214358881,429981696,815730721,1475789056,170859375,268435456,410338673,612220032,893871739,128e7,1801088541,113379904,148035889,191102976,Py,308915776,387420489,481890304,594823321,729e6,887503681,qy,1291467969,1544804416,1838265625,60466176]),JW=Se(Ce(gt,1),yt,17,15,[-1,-1,31,19,15,13,11,11,10,9,9,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5])}function Af(a){var y,k,z,E,j,te,ne,ie;for(ie=(j=Gt(a.e),j??""),k=Is(a.e),E=0;--k>0;)Tt(k,ie.length),ie.charCodeAt(k)==34&&(k==0||(Tt(k-1,ie.length),ie.charCodeAt(k-1)!=92))&&++E;if(E%2!=1){for(te=-1,z=-1,k=Is(a.e);k>0;){if(y=(Tt(k-1,ie.length),ie.charCodeAt(k-1)),RI(String.fromCharCode(y))){te=k;break}--k}for(k=Is(a.e);k<ie.length;){if(y=(Tt(k,ie.length),ie.charCodeAt(k)),RI(String.fromCharCode(y))){z=k;break}++k}ne=ie.substr(te,z-te),LU(a),fV(a,ne)&&(a.s=te,a.q=z,XG(a,ne))}}function PV(a){var y,k,z,E,j,te,ne;for(Ga(a.Mc),te=new Fe(a.Qc);te.a<te.c.a.length;)E=He(te),Ga(E);for(a.Qc.a=Le(Ke,ve,1,0,5,1),ne=new Fe(a.d);ne.a<ne.c.a.length;)E=He(ne),Ga(E);for(a.d.a=Le(Ke,ve,1,0,5,1),j=new Fe(a.kc);j.a<j.c.a.length;)E=He(j),Ga(E);for(a.kc.a=Le(Ke,ve,1,0,5,1),xe(a.zc,a.fb),a.Sc>0&&a.ob>0?(zF(a),cT(a),sT(a)):a.Sc>0?cT(a):a.ob>0&&sT(a),k=a.db;k<=a.zb;k++){for(E=new Sv(a.xb),z=a.bb;z<=a.xb;z++)y=new ff(a,z,k),xe(a.zc,y.d),E.a[E.a.length]=y;St(a.kc,E)}}function OG(a){var y,k,z,E,j;j=Oe(ue),Ue(j,"cell-range-bg-color"),j.style[mt]=(tt(),Ni),j.style[Bt]=Ni,xe(a.zc,j),E=new Dl(j),y=YV(E,ml),y=au(y,"!important",""),Jo(a.zc,j),y!=null&&so(y).length!=0?(z=cF(),(fe(),z.Xc).height=1,z.Xc.width=1,OM(z.Xc.getContext("2d"),y),z.Xc.getContext("2d").fillRect(0,0,1,1),k='url("'+z.Xc.toDataURL()+'")',zr(a.Dc,"."+a.Ac+hE+"background-image: "+k+" !important;}")):zr(a.Dc,"."+a.Ac+hE+"background-color: rgba(232, 242, 252, 0.8) !important;}")}function f2(a,y,k,z,E,j,te){var ne,ie,se,ce,le;for(ce=y;ce<=k;ce++){for(j.a.length>ce-y?le=(pn(ce-y,j.a.length),j.a[ce-y]):(le=new st,jo(ce-y,j.a.length),Nu(j.a,ce-y,le)),ne=z;ne<=E;ne++)le.a.length>ne-z?(ie=(pn(ne-z,le.a.length),le.a[ne-z]),K9(ie,ne,ce,Nt(a.e,qe+ne+Ye+ce))):(ie=new mf(a,ne,ce,Nt(a.e,qe+ne+Ye+ce)),xe(te,ie.d),jo(ne-z,le.a.length),Nu(le.a,ne-z,ie));for(;le.a.length>E-z+1;)lt(Or(le,le.a.length-1).d)}for(;j.a.length>k-y+1;)for(se=new Fe(Or(j,j.a.length-1));se.a<se.c.a.length;)ie=He(se),lt(ie.d);sl(a,!1)}function XG(a,y){var k,z,E,j,te,ne,ie,se,ce,le;if(bn(a.G,y)){if(se=V0(a,y),!se)return;if(j=ae.Math.min(se.col1,se.col2),E=ae.Math.max(se.col1,se.col2),le=ae.Math.min(se.row1,se.row2),ce=ae.Math.max(se.row1,se.row2),E>2e4){$A(jn((ht(Tp),Tp.i)));return}for(k=j;k<=E;k++)for(ie=le;ie<=ce;ie++)z=Rt(a.I,k,ie),z&&(ne=z.d,te=au(Nt(a.G,y),"%s","0.75"),k==j&&(ne.style.borderLeft=ep+te),k==E&&(ne.style[G2]=ep+te),ie==le&&(ne.style.borderTop=ep+te),ie==ce&&(ne.style[Q2]=ep+te));a.A=y}}function N0(a,y){var k,z,E,j,te,ne,ie,se,ce,le,de,pe,me;if(te=a.e,ie=y.e,te==0)return y;if(ie==0)return a;if(j=a.d,ne=y.d,j+ne==2)return k=Ve(a.a[0],Xe),z=Ve(y.a[0],Xe),te==ie?(ce=Vt(k,z),me=_e(ce),pe=_e(Yn(ce,32)),pe==0?new zi(te,me):new kn(te,2,Se(Ce(gt,1),yt,17,15,[me,pe]))):Lo(te<0?cn(z,k):cn(k,z));if(te==ie)de=te,le=j>=ne?Pa(a.a,j,y.a,ne):Pa(y.a,ne,a.a,j);else{if(E=j!=ne?j>ne?1:-1:pf(a.a,y.a,j),E==0)return Xi(),Do;E==1?(de=te,le=La(a.a,j,y.a,ne)):(de=ie,le=La(y.a,ne,a.a,j))}return se=new kn(de,le.length,le),Ti(se),se}function _V(a,y){var k,z,E,j,te;j=(!a.C&&(a.C=new un),a.C),E=(!a.K&&(a.K=new Cr),a.K),y.Df("componentIDtoCellKeysMap")&&(k=E.o,z=new Ot,k&&k.a.c+k.b.c!=0&&Mv(k,new k6(a,z)),jU(j.V,z)),y.Df("cellKeysToEditorIdMap")&&MT(a),(y.Df("cellComments")||y.Df("cellCommentAuthors"))&&BM(j,E.b,E.a),y.Df("visibleCellComments")&&WU(a),y.Df("invalidFormulaCells")&&oM(j,E.F),y.Df("overlays")&&(te=(!a.K&&(a.K=new Cr),a.K).N?(!a.K&&(a.K=new Cr),a.K).N:(zn(),zn(),Qj),wF(a,te.keySet()),CH(a,te),a.c=te.keySet()),_0(j.V)}function WG(a,y,k,z){var E,j,te,ne,ie;od(a),te=a.V.Sc>0?1:id(a.V),k||Ks(a,y,te,null),k?(ie=a.V.rc,E=ie>y?y:ie,j=ie>y?ie:y,ne=a.O,Hi(a.V.yc)?(Ei(a.V,E,j,1,ne),Fn(a.V,E,j,1,ne,!0)):Fn(a.V,E,j,1,ne,!1),Hi(a.V.yc)?Hh(a.W,1,E,ne,j):Ev(a.W,1,E,ne,j)):z?(a.V.C&&(a.V.C=!1),Hi(a.V.yc)&&go(a.V,!1),h2(a.V,y,te),Lr(a.Q),Fn(a.V,y,y,1,a.O,!1),XB(a.W,te,y)):(a.V.C||(a.V.C=!0),Hi(a.V.yc)||(go(a.V,!0),is(a.V)),Lu(a.V,y,te),Ei(a.V,y,y,1,a.O),Fn(a.V,y,y,1,a.O,!0),Lr(a.Q),WB(a.W,y,te)),gn(a.s,200)}function KG(a,y,k,z){var E,j,te,ne,ie;j=a.V.ob>0?1:cd(a.V),od(a),k||Ks(a,j,y,null),k?(E=a.i,ie=a.V.sc,te=ie>y?y:ie,ne=ie>y?ie:y,Hi(a.V.yc)?(Ei(a.V,1,E,te,ne),Fn(a.V,1,E,te,ne,!0)):Fn(a.V,1,E,te,ne,!1),Hi(a.V.yc)?Hh(a.W,te,1,ne,E):Ev(a.W,te,1,ne,E)):z?(a.V.C&&(a.V.C=!1),Hi(a.V.yc)&&go(a.V,!1),h2(a.V,j,y),Lr(a.Q),Fn(a.V,1,a.i,y,y,!1),RB(a.W,y,j)):(a.V.C||(a.V.C=!0),Hi(a.V.yc)||(go(a.V,!0),is(a.V)),Lu(a.V,j,y),Ei(a.V,1,a.i,y,y),Fn(a.V,1,a.i,y,y,!0),Lr(a.Q),PB(a.W,y,j)),gn(a.s,200)}function BV(a){var y,k,z,E,j,te,ne,ie,se,ce;if(te=(Ch(),!1),ce=a.a.f,se=0,te&&(se=(Uc(),lr(Date.now()))),ne=a.a.N,y=a.a.k,ce)try{for(ie=new Bu(pm(a.Dc)),j=new hr(new or(ce).a);j.b;)E=Xr(j),E.cg().a==0?rt(ie,cp+a.Ac+" .sheet .cell {"+E.dg()+"}"):rt(ie,tG(a,E.cg(),ne,y)+" {"+E.dg()+"}");ns(a.Dc),xe(a.Dc,ww(ue,ie.a))}catch(le){if(le=Xt(le),ze(le,21))k=le,Tr(a.U,"SheetWidget:updateStyles: "+Yu(k,k.Gd())+CE);else throw we(le)}te&&(z=(Uc(),lr(Date.now())),Di(a.U,"Style update took:"+fa(cn(z,se))+"ms")),TU(a),OG(a)}function DV(a,y,k){var z,E,j,te,ne,ie,se;if(y>=a.e&&y<=a.f&&k>=a.K&&k<=a.L){if(se=ae.Math.abs(a.L-k),ne=ae.Math.abs(a.f-y),a._||se==0&&ne==0){ul(a,0,0,0,0),h0(a,!1);return}h0(a,!0),a.j=!0,se>ne?(ie=ae.Math.max(a.K+1,a.L-se+1),ul(a,a.e,a.f,ie,a.L)):(ie=ae.Math.max(a.e+1,a.f-ne+1),ul(a,ie,a.f,a.K,a.L))}else(k<a.K||k>a.L||y<a.e||y>a.f)&&(h0(a,!0),a.s=!0,z=k-a.L,te=a.K-k,E=a.e-y,j=y-a.f,ae.Math.max(z,te)>ae.Math.max(E,j)?z>te?ul(a,a.e,a.f,a.L+1,k):ul(a,a.e,a.f,k+1,a.K-1):j>E?ul(a,a.f+1,y,a.K,a.L):ul(a,y+1,a.e-1,a.K,a.L))}function LG(a,y){var k;if(!a.c._){if(!a.b)return;switch(k=(be(),y).keyCode|0,k){case 8:case 113:case 38:case 40:case 37:case 39:case 9:case 46:case 32:Ie.Rd(y)==0&&(D0(a.c.a,y,""),Ie.Vd(y),y.stopPropagation());break;case 89:(!a.a&&y.ctrlKey||y.metaKey)&&(xt(a.c.a.W.C,Se(Ce(Ke,1),ve,1,5,[])),Ie.Vd(y),y.stopPropagation());break;case 90:(!a.a&&y.ctrlKey||y.metaKey)&&(xt(a.c.a.W.G,Se(Ce(Ke,1),ve,1,5,[])),Ie.Vd(y),y.stopPropagation());break;case 65:(!a.a&&y.ctrlKey||y.metaKey)&&(KD(a.c.a),Ie.Vd(y),y.stopPropagation())}}}function h2(a,y,k){var z,E,j,te,ne,ie;if(ne=Rt(a,a.rc,a.sc),te=Ui(a,qe+a.rc+Ye+a.sc),a.v)Ut(a.u,new Co(a.rc,a.sc)),ne&&(Ut(a.t,ne),Ue(ne.d,Ji)),te&&(Ut(a.t,te),Ue(te.d,Ji)),a.v=!1;else{if(Ut(a.u,new Co(a.rc,a.sc)),ne&&(Ut(a.t,ne),Ue(ne.d,Ji)),te&&(Ut(a.t,te),Ue(te.d,Ji)),ie=ql(a.a,y,k),w0(a,k),ie)for(z=ie.row1+1;z<=ie.row2;z++)w0(a,z);if(g0(a,y),ie)for(z=ie.col1+1;z<=ie.col2;z++)g0(a,z)}ne&&(a.nb=null,zt(ne.d,qs)),te&&zt(te.d,qs),j=Rt(a,y,k),j&&(a.nb=new Co(j.c,j.k),Ue(j.d,qs)),E=Ui(a,qe+y+Ye+k),E&&Ue(E.d,qs),a.sc=k,a.rc=y}function qV(a,y,k,z,E){var j,te,ne,ie,se,ce,le,de;for(le=E,de=new Ot,ne=k;ne<=z;ne++)ce=new Bi,se=a.W[ne-1],rt(Go(rt(Go(rt(rt(rt(Go(rt(rt(rt(Go(rt(rt((ce.a+=".",ce),a.Ac),bE),ne),", ."),a.Ac),">.resize-line.row"),ne)," { "),Cn(a.a,ne)?aE:"display: flex;"),"height: "),se),"px; top:"),le),`px; }
`),le+=se,Zn(de,he(ne),he(le)),St(y,ce.a);for(te=new hr(new or(a.Eb).a);te.b;)j=Xr(te),ie=j.dg().k-1,!(ie==z&&z==a.Sc)&&rf(de,he(ie))?j.dg().d.style[fn]=no(de,he(ie)).a+(tt(),ke):ie<k&&z!=a.Sc&&(j.dg().d.style[fn]=(tt(),Ni))}function d2(a,y,k,z,E){var j,te,ne,ie,se,ce,le,de,pe;for(le=E,de=new Ot,ce=k;ce<=z;ce++)pe=new Bi,ne=Gu(a.a,ce),rt(Go(rt(Go(rt(rt(rt(Go(rt(rt(rt(Go(rt(rt((pe.a+=".",pe),a.Ac),dE),ce),", ."),a.Ac),">.resize-line.col"),ce)," { "),Vo(a.a,ce)?aE:""),"width: "),ne),"px; left:"),le),`px; }
`),le+=ne,Zn(de,he(ce),he(le)),St(y,pe.a);for(j=qi((fe(),a.Xc)),se=new hr(new or(a.Eb).a);se.b;)ie=Xr(se),te=ie.dg().c-1,!(te==z&&z==a.ob)&&rf(de,he(te))?ie.dg().d.style[vn]=no(de,he(te)).a+(tt(),ke):te>z&&z!=a.ob&&(ie.dg().d.style[vn]=j+(tt(),ke))}function R0(a,y,k,z,E){var j;zt(a.B,qe+a.e+Ye+a.C),a.s>0&&y<a.s?(y=a.s,g9(a,!0)):g9(a,!1),a.t>0&&z<a.t?(z=a.t,v9(a,!0)):v9(a,!1),a.r>0&&E>a.r?(E=a.r,p9(a,!0),a.i.style[Pt]=(It(),tn),a.g.style[Pt]=tn):(p9(a,!1),a.i.style[Pt]=(It(),vi),a.g.style[Pt]=vi),a.q>0&&a.q<k?(k=a.q,w9(a,!0)):w9(a,!1),a.e=y,a.C=z,a.f=k,a.D=E,a.K=k-y,a.j=E-z,y<=k&&z<=E?(Ue(a.B,qe+a.e+Ye+a.C),js((fe(),a.Xc),!0),rH(a),j=a.F.q.V.W,j!=null&&j.length!=0&&uD(a,Wo(a.F.q.V.W,a.C,a.D+1))):js((fe(),a.Xc),!1)}function FV(a){var y,k,z,E,j;return a.g!=null?a.g:a.a<32?(a.g=rQ(lr(a.f),bt(a.e)),a.g):(E=uz((!a.c&&(a.c=ss(a.f)),a.c),0),a.e==0?E:(y=(!a.c&&(a.c=ss(a.f)),a.c).e<0?2:1,k=E.length,z=-a.e+k-y,j=new Bi,j.a+=""+E,a.e>0&&z>=-6?z>=0?cf(j,k-bt(a.e),String.fromCharCode(46)):(j.a=Zo(j.a,0,y-1)+"0."+Zs(j.a,y-1),cf(j,y+1,Ko(s1,0,-bt(z)-1))):(k-y>=1&&(cf(j,y,String.fromCharCode(46)),++k),cf(j,k,String.fromCharCode(69)),z>0&&cf(j,++k,String.fromCharCode(43)),cf(j,++k,""+fa(lr(z)))),a.g=j.a,a.g))}function MG(a,y){var k,z,E,j;if(y.a||!a.K&&y.b){a.I&&(y.a=!0);return}if(y.c,!y.a)switch(z=y.d,k=Mq(a,z),k&&(y.b=!0),a.I&&(y.a=!0),j=(fe(),Hn((be(),z).type)),j){case 512:case 256:case 128:{(z.keyCode|0)&Rs,(z.shiftKey?1:0)|(z.metaKey?8:0)|(z.ctrlKey?2:0)|(z.altKey?4:0);return}case 4:case Bs:if(ho){y.b=!0;return}if(!k&&a.u){a.Re(!0);return}break;case 8:case 64:case 1:case 2:case ui:{if(ho){y.b=!0;return}break}case 2048:{if(E=Ie.Ud(z),a.I&&!k&&E){E.blur&&E!=ue.body&&E.blur(),y.a=!0;return}break}}}function HV(){HV=ge,ri=new st,St(ri,"rgba(48, 144, 240, %s)"),St(ri,"rgba(236, 100, 100, %s)"),St(ri,"rgba(152, 223, 88, %s)"),St(ri,"rgba(249, 221, 81, %s)"),St(ri,"rgba(36, 220, 212, %s)"),St(ri,"rgba(236, 100, 165, %s)"),St(ri,"rgba(104, 92, 176, %s)"),St(ri,"rgba(255, 125, 66, %s)"),St(ri,"rgba(51, 97, 144, %s)"),St(ri,"rgba(170, 81, 77, %s)"),St(ri,"rgba(127, 176, 83, %s)"),St(ri,"rgba(187, 168, 91, %s)"),St(ri,"rgba(36, 121, 129, %s)"),St(ri,"rgba(150, 57, 112, %s)"),St(ri,"rgba(75, 86, 168, %s)"),St(ri,"rgba(154, 89, 61, %s)")}function $V(a,y,k,z){var E,j,te,ne,ie,se;if(se=!1,y<=a.ob&&(y=a.ob+1),j=cd(a),ne=xf(a),z){if(y<j){for(ie=0,E=j-1;E>=y-1&&E>0;E--)ie+=Ft(a.a,E);Zr(a.zc,dn(a.zc)-ie),(y<=a.bb||ie>(a.a.j/2|0))&&(se=!0)}else if(y>ne){for(ie=0,te=a.a.i,E=ne+1;E<=y+1&&E<=te;E++)ie+=Ft(a.a,E);Zr(a.zc,dn(a.zc)+ie),(y>=a.xb||ie>(a.a.j/2|0))&&(se=!0)}}else if(k>ne){for(ie=0,te=a.a.i,E=ne+1;E<=k+1&&E<=te;E++)ie+=Ft(a.a,E);Zr(a.zc,dn(a.zc)+ie),(k>=a.xb||ie>(a.a.j/2|0))&&(se=!0)}else if(k<j){for(ie=0,E=j-1;E>=k-1&&E>0;E--)ie+=Ft(a.a,E);Zr(a.zc,dn(a.zc)-ie),(k<=a.bb||ie>(a.a.j/2|0))&&(se=!0)}return se}function a2(a,y,k,z,E,j,te){var ne,ie,se,ce,le;if(j.a.length!=0){for(ie=new Fe(te),ce=null,le=-1;ie.a<ie.c.a.length;)ne=He(ie),ne.row>=y&&ne.row<=k&&ne.col>=z&&ne.col<=E&&(le!=ne.row&&((pn(0,j.a.length),j.a[0]).a.length>0&&Ze((pn(0,j.a.length),j.a[0]),0).k!=y&&(y=Ze((pn(0,j.a.length),j.a[0]),0).k),ce=Ze(j,ne.row-y),le=ne.row,(pn(0,ce.a.length),ce.a[0]).c!=z&&(z=(pn(0,ce.a.length),ce.a[0]).c)),Zu(Ze(ce,ne.col-z),ne.value,ne.cellStyle,ne.needsMeasure)),se=qe+ne.col+Ye+ne.row,zv(a,se,ne.value,ne.cellStyle,ne.needsMeasure),ne.value==null?Eo(a.e,se):Te(a.e,se,ne);sl(a,!1)}}function NG(a){a.B.className=sE,a.F._&&Ue(a.B,Gn),a.G.className="s-top",a.k.className="s-left",a.u.className="s-right",a.a.className="s-bottom",a.g.className="s-corner",a.i.className="s-corner-touch",a.I.className=np,a.o.className=np,a.w.className=np,a.c.className=np,a.J.className=ip,a.p.className=ip,a.A.className=ip,a.d.className=ip,a.F._?(xe(a.u,a.i),xe(a.i,a.g)):xe(a.u,a.g),xe(a.G,a.k),xe(a.G,a.u),xe(a.k,a.a),xe(a.B,a.G),a.F._&&(xe(a.G,a.J),xe(a.k,a.p),xe(a.u,a.A),xe(a.a,a.d),xe(a.J,a.I),xe(a.p,a.o),xe(a.A,a.w),xe(a.d,a.c)),xs(a,a.B)}function RG(a,y){var k,z,E,j,te,ne,ie,se,ce,le,de,pe,me,je,wt,jt,Wt,$t,De,Qt,sn,Tn,ir,rr,mr,Ur,hi;return k=a.l&8191,z=a.l>>13|(a.m&15)<<9,E=a.m>>4&8191,j=a.m>>17|(a.h&255)<<5,te=(a.h&1048320)>>8,ne=y.l&8191,ie=y.l>>13|(y.m&15)<<9,se=y.m>>4&8191,ce=y.m>>17|(y.h&255)<<5,le=(y.h&1048320)>>8,ir=k*ne,rr=z*ne,mr=E*ne,Ur=j*ne,hi=te*ne,ie!=0&&(rr+=k*ie,mr+=z*ie,Ur+=E*ie,hi+=j*ie),se!=0&&(mr+=k*se,Ur+=z*se,hi+=E*se),ce!=0&&(Ur+=k*ce,hi+=z*ce),le!=0&&(hi+=k*le),pe=ir&wn,me=(rr&511)<<13,de=pe+me,wt=ir>>22,jt=rr>>9,Wt=(mr&262143)<<4,$t=(Ur&31)<<17,je=wt+jt+Wt+$t,Qt=mr>>18,sn=Ur>>5,Tn=(hi&4095)<<8,De=Qt+sn+Tn,je+=de>>22,de&=wn,De+=je>>22,je&=wn,De&=Li,Zt(de,je,De)}function PG(a,y,k){var z,E,j,te,ne,ie,se;return ie=Vn(a.zc),te=bi(a.zc),j=gi(a.zc),ne=qi(a.zc),a.A=k,a.B=y,y<ie?(a.O||!a.Ic&&!a.Hc)&&(a.Y=y-ie):y>j?a.Y=y-j:a.Y=0,k<te?(a.P||!a.Gc&&!a.Hc)&&(a.X=k-te):k>ne?a.X=k-ne:a.X=0,se=!1,(a.zc.scrollTop||0)|0&&(E=y<ie,!a.O&&(a.Hc||a.Ic)&&bf(a,a.Jc,a.Kc)&&!E&&(a.zc.scrollTop=0,Rc(a),a.O=!0,se=!0)),dn(a.zc)!=0&&(z=k<te,!a.P&&(a.Hc||a.Gc)&&bf(a,a.Jc,a.Kc)&&!z&&(Zr(a.zc,0),Rc(a),a.P=!0,se=!0)),(a.Y<0&&(a.zc.scrollTop||0)|0||a.Y>0||a.X<0&&dn(a.zc)!=0||a.X>0)&&(vP(a),se=!0),se?!0:(S8(a),!1)}function UV(a,y,k){var z,E,j,te,ne,ie,se;return ie=Vn(a.Q.zc),te=bi(a.Q.zc),j=gi(a.Q.zc),ne=qi(a.Q.zc),a.c=k,a.d=y,y<ie?(a.g||!a.T&&!a.S)&&(a.n=y-ie):y>j?a.n=y-j:a.n=0,k<te?(a.i||!a.R&&!a.S)&&(a.k=k-te):k>ne?a.k=k-ne:a.k=0,se=!1,(a.Q.zc.scrollTop||0)|0&&(E=y<ie,!a.g&&(a.S||a.T)&&bf(a.Q,a.U,a.V)&&!E&&(a.Q.zc.scrollTop=0,Rc(a.Q),a.u=0,a.g=!0,se=!0)),dn(a.Q.zc)!=0&&(z=k<te,!a.i&&(a.S||a.R)&&bf(a.Q,a.U,a.V)&&!z&&(Zr(a.Q.zc,0),Rc(a.Q),a.t=0,a.i=!0,se=!0)),(a.n<0&&(a.Q.zc.scrollTop||0)|0||a.n>0||a.k<0&&dn(a.Q.zc)!=0||a.k>0)&&(ZR(a),se=!0),se?!0:(Sw(a),!1)}function _G(a,y){var k,z,E,j;return k=0,a.H>0&&(z=a.Z?a.H+1:a.H,k=3+z*18),j=0,a.fc>0&&(E=a.Z?a.fc+1:a.fc,j=1+E*15),j==0?(a.gc.style[Pt]=(It(),tn),a.hc.style[Pt]=tn):(a.gc.style[Pt]=(It(),vi),a.hc.style[Pt]=vi),a.Z||(a.hc.style[Pt]=(It(),tn)),a.jb&&a.fc>0?a.dc.style[Pt]=(It(),vi):a.dc.style[Pt]=(It(),tn),a.gc.style[mt]=j+(tt(),ke),a.gc.style[fn]=y+ke,a.dc.style[mt]=j+ke,a.dc.style[fn]=y+ke,a.hc.style[fn]=y+k+ke,a.Db&&(a.hc.style[Bt]=p0(a)+ke,a.hc.style[SE]=p0(a)+ke),a.hc.style[mt]=j+ke,j}function BG(a){var y,k,z,E,j;return Fr==null&&(k="",z="",E="",y="",a.a.g?(k="ff",z=k+a.a.b,E=z+a.a.c,y="gecko"):a.a.e?(k="sa",z="ch",y=hp):a.a.q||a.a.p?(k="sa",z=k+a.a.b,E=z+a.a.c,y=hp):a.a.j?(k="ie",z=k+a.a.b,E=z+a.a.c,y="trident"):a.a.f?(k="edge",z=k+a.a.b,E=z+a.a.c,y=""):a.a.o&&(k="op",z=k+a.a.b,E=z+a.a.c,y="presto"),Fr="v-"+k,z.length==0||(Fr=Fr+" v-"+z),E.length==0||(Fr=Fr+" v-"+E),y.length==0||(Fr=Fr+" v-"+y),j=V$(a),j!=null&&(Fr=Fr+" "+j),a.b&&(Fr=Fr+" v-"+Gn)),Fr}function DG(a){if(a.offsetLeft==null)return 0;var y=0,k=a.ownerDocument,z=a.parentNode;if(z)for(;z.offsetParent;)y-=z.scrollLeft,k.defaultView.getComputedStyle(z,"").getPropertyValue("direction")=="rtl"&&(y+=z.scrollWidth-z.clientWidth),z=z.parentNode;for(;a;){if(y+=a.offsetLeft,k.defaultView.getComputedStyle(a,"")[as]==Q0)return y+=k.body.scrollLeft,y;var E=a.offsetParent;if(E&&ae.devicePixelRatio&&(y+=parseInt(k.defaultView.getComputedStyle(E,"").getPropertyValue("border-left-width"))),E&&E.tagName=="BODY"&&a.style.position==Su)break;a=E}return y}function qG(a,y){var k,z,E,j,te,ne,ie,se,ce,le;for(le=new Bi,ce=y.row1;ce<=y.row2;ce++)for(k=y.col1;k<=y.col2;k++)le.a+=sp+k+".row"+ce,(ce!=y.row2||k!=y.col2)&&(le.a+=",");le.a.length!=0&&(le.a+="{ display: none; }",zr(a.Fb,le.a)),ie=qe+y.col1+Ye+y.row1,se=new b7(a,y.col1,y.row1),j="cs0",z=Rt(a,y.col1,y.row1),z&&(j=z.b),Zu(se,Ea(a,y.col1,y.row1),j,!1),ne=se.d,Ue(ne,gs),zV(a,y,se),xe(eF(a,y.col1,y.row1),ne),Zn(a.Eb,he(y.id),se),a.r&&bn(a.r,ie)&&za(se),a.tb&&a.tb.contains(ie)&&Va(se),bn(a.b,ie)&&(E=Nt(a.b,ie),Sm(E,ne,y.row1,y.col1)),a.T&&bn(a.T,ie)&&(te=Nt(a.T,ie),Cm(a,se,te))}function FG(a,y){a.Ac="spreadsheet-"+y,Ue(a.Fc,a.Ac),a.w.type=Fs,ms(a.w,a.Ac+"-dynamicStyle"),xe(a.Qb,a.w),a.Dc.type=Fs,ms(a.Dc,a.Ac+"-sheetStyle"),xe(a.Qb,a.Dc),a.Ec.type=Fs,ms(a.Ec,a.Ac+"-customCellSizeStyle"),xe(a.Qb,a.Ec),a.$.type=Fs,ms(a.$,a.Ac+"-editedCellStyle"),xe(a.Qb,a.$),zr(a.$,".notusedselector{ display: inline !important; outline: none !important; width: auto !important; z-index: -10; }"),zr(a.$,".notusedselector{ overflow: hidden; }"),a.Fb.type=Fs,ms(a.Fb,a.Ac+"-mergedRegionStyle"),xe(a.Qb,a.Fb),a.Wb.type=Fs,ms(a.Wb,a.Ac+"-resizeStyle"),xe(a.Qb,a.Wb)}function Tf(a,y){var k,z,E,j,te,ne,ie;if(a.Tc){te=-1;try{te=Wi(IN((fe(),a.Xc).style))}catch(se){if(se=Xt(se),ze(se,21))te=_r;else throw we(se)}te==-1&&(te=Ap),(ei(),!Ht&&(Ht=new co),ei(),Ht).a.j&&(cr((fe(),a.Xc),Mf),cr(a.Xc,pl)),E=(!Ht&&(Ht=new co),Ht),E.a.j&&nv(E)&&(j=new zI((ne=bi((fe(),a.Xc)),ne-=yS(ue),ne-=(eh==-1&&(eh=m0(vn)),eh),ne),(ie=Vn(a.Xc),ie-=xS(ue),ie-=(th==-1&&(th=m0(fn)),th),ie),cr(a.Xc,pl),cr(a.Xc,Mf)),j.b+=bt(j.d*(1-y)/2),j.c+=bt(j.a*(1-y)/2),j.d=bt(j.d*y),j.a=bt(j.a*y),k=Nl(a.Xc),z=(!Ht&&(Ht=new co),Ht),z.a.j&&nv(z)&&(CF(_$(a),j),!Nl(a.t)&&f8(k,a.t,a.Xc)))}}function b2(a,y,k){var z,E,j,te,ne,ie;if(y.l==0&&y.m==0&&y.h==0)throw we(new Jr("divide by zero"));if(a.l==0&&a.m==0&&a.h==0)return k&&(wr=Zt(0,0,0)),Zt(0,0,0);if(y.h==Br&&y.m==0&&y.l==0)return oH(a,k);if(ie=!1,y.h>>19&&(y=ou(y),ie=!ie),te=VU(y),j=!1,E=!1,z=!1,a.h==Br&&a.m==0&&a.l==0)if(E=!0,j=!0,te==-1)a=IS((nu(),ux)),z=!0,ie=!ie;else return ne=Qm(a,te),ie&&Ya(ne),k&&(wr=Zt(0,0,0)),ne;else a.h>>19&&(j=!0,a=ou(a),z=!0,ie=!ie);return te!=-1?xF(a,te,ie,j,k):mm(a,y)<0?(k&&(j?wr=ou(a):wr=Zt(a.l,a.m,a.h)),Zt(0,0,0)):bG(z?a:Zt(a.l,a.m,a.h),y,ie,j,E,k)}function GV(a,y,k){var z,E;if(Zr(a.zc,y),wo(a.zc,k),a.oc=(a.zc.offsetHeight||0)|0,a.pc=(a.zc.offsetWidth||0)|0,a.Ob=y,a.Pb=k,a.db=1,a.eb=0,a.Sc>0&&(a.db=a.Sc+1),a.bb=1,a.cb=0,a.ob>0&&(a.bb=a.ob+1),a.xb=0,is(a),P6(a),z=a.a.j,a.cb<y-z)do a.cb+=Ft(a.a,a.bb),++a.bb;while(a.cb<y-z);if(a.xb=a.bb,a.yb=a.cb+Ft(a.a,a.bb),E=a.a.L,a.eb<k-E)do a.db>=a.a.M.length?a.eb+=$i(a):a.eb+=Ai(a,a.db),++a.db;while(a.eb<k-E);for(a.zb=a.db,a.Ab=a.eb+Ai(a,a.zb);a.yb<y+a.pc+z&&a.xb<a.a.i;)++a.xb,a.yb+=Ft(a.a,a.xb);for(;a.Ab<k+a.oc+E&&a.zb<a.a.O;)++a.zb,a.zb>=a.a.M.length?a.Ab+=$i(a):a.Ab+=Ai(a,a.zb)}function QV(a,y){var k,z,E,j,te,ne,ie,se,ce;return se="",y.length==0?a.Nd(C2,H0,-1,-1):(ce=so(y),ye(ce.substr(0,3),"at ")&&(ce=ce.substr(3)),ce=ce.replace(/\[.*?\]/g,""),te=ce.indexOf("("),te==-1?(te=ce.indexOf("@"),te==-1?(se=ce,ce=""):(se=so(ce.substr(te+1)),ce=so(ce.substr(0,te)))):(k=ce.indexOf(")",te),se=ce.substr(te+1,k-(te+1)),ce=so(ce.substr(0,te))),te=F1(ce,hs(46)),te!=-1&&(ce=ce.substr(te+1)),(ce.length==0||ye(ce,"Anonymous function"))&&(ce=H0),ne=cw(se,hs(58)),E=rP(se,hs(58),ne-1),ie=-1,z=-1,j=C2,ne!=-1&&E!=-1&&(j=se.substr(0,E),ie=$7(se.substr(E+1,ne-(E+1))),z=$7(se.substr(ne+1))),a.Nd(j,ce,ie,z))}function P0(a,y,k,z,E){var j;zt(a.k,qe+a.b+Ye+a.n),a.g>0&&y<a.g?(y=a.g,a.d.style[ot]=(at(),dt)):a.d.style[ot]=(at(),ni),a.i>0&&z<a.i?(z=a.i,a.q.style[ot]=(at(),dt)):a.q.style[ot]=(at(),ni),a.f>0&&E>a.f?(E=a.f,a.a.style[ot]=(at(),dt)):a.a.style[ot]=(at(),ni),a.e>0&&a.e<k?(k=a.e,a.j.style[ot]=(at(),dt)):a.j.style[ot]=(at(),ni),a.b=y,a.n=z,a.c=k,a.o=E,y<=k&&z<=E?(Ue(a.k,qe+a.b+Ye+a.n),js((fe(),a.Xc),!0),a.Xc.style[qr]="",MH(a),j=a.p.q.V.W,j!=null&&j.length!=0&&_q(a,Wo(a.p.q.V.W,a.n,a.o+1))):(js((fe(),a.Xc),!1),a.Xc.style[qr]=(ts(),dt))}function JV(a,y,k){var z,E,j,te,ne,ie,se,ce;for(a.Zb=!0,z=y-a.Sb,z<0&&(z=0),ls(a.Wb),z>0?sr(a.Yb,"Width: "+z+ke):sr(a.Yb,wE),se="."+a.Ac+vE+a.$b+"{width:"+z+Df,zr(a.Wb,se),E=0,ce=qi(a.zc)-y,te=a.$b+1;te<=a.xb&&E<ce;te++)E+=Ft(a.a,te);for(ie=y-a.Tb,ie<a.Sb-a.Tb&&(ie=a.Sb-a.Tb),se="",ne=a.$b+1;ne<=a.xb;ne++)se+="."+a.Ac+vE+ne,a.xb!=ne&&(se+=",");if(a.ib&&a.$b>=a.ib.a.length)for(j=1;j<=a.ib.a.length;j++)ie+=Ft(a.a,j);ie=a.Cb+ie,(!a.ib||a.$b>a.ib.a.length)&&(ie-=dn(a.zc)),se.length!=0&&(se+="{margin-left:"+ie+Df,zr(a.Wb,se)),se="."+a.Ac+".col-resizing > div.resize-line.ch {margin-left:"+(ie-1)+Df,zr(a.Wb,se),pa(a,y,k)}function HG(a,y){var k,z;a.e||(a.e=new Ra,Xn(a.e,new _5(a),(Ao(),Ao(),ws)),Xn(a.e,new B5(a),(qu(),qu(),Cl))),k=so(Ia(a.e.a)),k+=k.length==0?"Using Evaluation License of: ":", ",sr(a.e,k+y),q1((ci(),uu()),a.e),Re(a.e).className="",z=Re(a.e).style,z[as]=(Ju(),Q0),z[J2]=(Kh(),"center"),z.right=(tt(),Ni),z[vn]=Ni,z.bottom=Ni,z.padding="0.5em 1em",z["font-family"]="sans-serif",z.fontSize="12.0px",z[SE]="1.1em",z.color="white",z[ml]="black",(be(),z).opacity=.7,z[uo]="2147483646",z[fn]=Tu,z[mt]=Tu,z[Pt]=(It(),vi),z.whiteSpace=(gv(),"normal"),z[ot]=(at(),ni),z.margin=Ni}function YV(a,y){var k=a.a,z=a.b;if(y.indexOf(_f)>-1&&y.indexOf("Width")>-1){var E=y.substring(0,y.length-5)+"Style";if(k.getPropertyValue)var j=k.getPropertyValue(E);else var j=k[E];if(j==tn)return"0px"}if(k.getPropertyValue){y=y.replace(/([A-Z])/g,"-$1").toLowerCase("en");var te=k.getPropertyValue(y)}else{var te=k[y],ne=z.style;if(!/^\d+(px)?$/i.test(te)&&/^\d/.test(te)){var ie=ne.left,se=z.runtimeStyle.left;z.runtimeStyle.left=k.left,ne.left=te||0,te=ne.pixelLeft+ke,ne.left=ie,z.runtimeStyle.left=se}}return y.indexOf("margin")>-1&&te==Tu?"0px":(y==mt&&te==Tu?te=z.clientWidth+ke:y==Bt&&te==Tu&&(te=z.clientHeight+ke),te)}function $G(a,y){var k,z,E,j,te,ne,ie;a.j||(j=jr()-a.b[0],Di(jn((ht(fi),fi.k)),j+" ms from start to move")),E=(ne=(be(),y).changedTouches[0],a.f=Dt(ne.clientY||0),ie=a.k++,ie=ie%3,a.b[ie]=jr(),a.s[ie]=a.f,a.j?a.j:ae.Math.abs(a.o-a.f)>=3),E&&(k=a.o-a.f,z=a.n+k,z>((a.q.scrollHeight||0)|0)-(a.q.clientHeight|0)?(te=k+a.n-(((a.q.scrollHeight||0)|0)-(a.q.clientHeight|0)),te=te/2|0,te>(vr?0:(a.q.clientHeight|0)/3|0)&&(te=vr?0:(a.q.clientHeight|0)/3|0),k=((a.q.scrollHeight||0)|0)-(a.q.clientHeight|0)+te-a.n):z<0&&(te=z/2|0,-te>(vr?0:(a.q.clientHeight|0)/3|0)&&(te=-(vr?0:(a.q.clientHeight|0)/3|0)),k=te-a.n),EB(a,k),a.j=!0,Ie.Vd(y),y.stopPropagation())}function p2(){p2=ge,eO=new kr("aria-activedescendant"),new _i("aria-atomic"),new kr("aria-autocomplete"),new kr("aria-controls"),new kr("aria-describedby"),new kr("aria-dropeffect"),new kr("aria-flowto"),new _i("aria-haspopup"),tO=new _i("aria-label"),new kr("aria-labelledby"),new _i("aria-level"),new kr("aria-live"),new _i("aria-multiline"),new _i("aria-multiselectable"),new kr("aria-orientation"),new kr("aria-owns"),new _i("aria-posinset"),new _i("aria-readonly"),new kr("aria-relevant"),new _i("aria-required"),new _i("aria-setsize"),new kr("aria-sort"),new _i("aria-valuemax"),new _i("aria-valuemin"),new _i("aria-valuenow"),new _i("aria-valuetext")}function ZV(a,y){var k,z,E,j;z=(!a.C&&(a.C=new un),a.C),k=(!a.K&&(a.K=new Cr),a.K),k.O||y.b?(k.O=!1,E=(!a.K&&(a.K=new Cr),a.K),j=(!a.C&&(a.C=new un),a.C),MT(a),rT(j,E.X,E.W,y.Df(zE)),HT(j,E.Y),j.C?Xw(j,!1):j.C=!0,Y9(j,j.a-1),pw(j,E.L),Ct((ut(),pt),new C6(a,y))):((y.Df("sheetNames")||y.Df("sheetIndex"))&&rT(z,k.X,k.W,y.Df(zE)),y.Df(cy)||y.Df(uy)||y.Df("colW")||y.Df("rowH")||y.Df("rows")||y.Df("cols")||y.Df(ly)||y.Df(fy)?(z.d?z.d=!1:q0(z.V,!0),pw((!a.C&&(a.C=new un),a.C),(!a.K&&(a.K=new Cr),a.K).L)):y.Df("mergedRegions")&&pw((!a.C&&(a.C=new un),a.C),(!a.K&&(a.K=new Cr),a.K).L),y.Df("sheetProtected")&&HT(z,k.Y),_V(a,y))}function yu(a,y,k){var z,E,j,te,ne,ie,se,ce,le,de;if(le=!1,j=cd(a),y<j&&y>a.ob){for(ce=0,E=j-1;E>=y-1&&E>0;E--)ce+=Ft(a.a,E);Zr(a.zc,dn(a.zc)-ce),(y<=a.bb||ce>(a.a.j/2|0))&&(le=!0)}else if(se=xf(a),y>se){for(ce=0,te=a.a.i,E=se+1;E<=y+1&&E<=te;E++)ce+=Ft(a.a,E);Zr(a.zc,dn(a.zc)+ce),(y>=a.xb||ce>(a.a.j/2|0))&&(le=!0)}if(de=id(a),k<de&&k>a.Sc){for(ce=0,E=de-1;E>=k-1&&E>0;E--)ce+=Cn(a.a,E)?0:E>=a.W.length?$i(a):a.W[E-1];ie=((a.zc.scrollTop||0)|0)-ce,wo(a.zc,ie>0?ie:0),(k<=a.db||ce>(a.a.L/2|0))&&(le=!0)}else if(z=vf(a),k>z){for(ce=0,ne=a.a.O,E=z+1;E<=k+1&&E<=ne;E++)ce+=Cn(a.a,E)?0:E>=a.W.length?$i(a):a.W[E-1];wo(a.zc,((a.zc.scrollTop||0)|0)+ce),(k>=a.zb||ce>(a.a.L/2|0))&&(le=!0)}le&&(s2(a),kf(a))}function Ms(a,y){var k,z,E,j,te,ne,ie,se,ce,le,de,pe;return E=!1,le=!1,z=new Dl(y),ie=(de=Se(Ce(gt,1),yt,17,15,[0,0,0,0]),de[0]=to(z,lE),de[1]=to(z,"paddingRight"),de[2]=to(z,"paddingBottom"),de[3]=to(z,uE),de),!E&&Ww(a.d,ie)&&(df(a.d,ie),E=!0),!le&&Kw(a.d,ie)&&(df(a.d,ie),le=!0),a.d=ie,j=um(z),!E&&Ww(a.c,j)&&(df(a.c,j),E=!0),!le&&Kw(a.c,j)&&(df(a.c,j),le=!0),a.c=j,k=(pe=Se(Ce(gt,1),yt,17,15,[0,0,0,0]),pe[0]=to(z,"borderTopWidth"),pe[1]=to(z,"borderRightWidth"),pe[2]=to(z,"borderBottomWidth"),pe[3]=to(z,"borderLeftWidth"),pe),!E&&Ww(a.a,k)&&(df(a.a,k),E=!0),!le&&Kw(a.a,k)&&(df(a.a,k),le=!0),a.a=k,se=HF(y),te=se+(j[0]+j[2]),UB(a,te)&&(E=!0),ce=$F(y),ne=ce+(j[1]+j[3]),$B(a,ne)&&(le=!0),new j4}function UG(a){a.U=jn("spreadsheet SheetWidget"),a.qc=new Ot,a.Fc=Oe(ue),a.zc=Oe(ue),a.N=Oe(ue),a.fb=Oe(ue),a.Ub=Oe(ue),a.Vb=Oe(ue),a.ic=new st,a.jb=new st,a.K=new st,a.ib=new st,a.kc=new st,a.Mc=new st,a.Qc=new st,a.d=new st,a.w=Uu(ue),a.Dc=Uu(ue),a.Ec=Uu(ue),a.$=Uu(ue),a.Wb=Uu(ue),a.Fb=Uu(ue),a.Mb=Oe(ue),a.Nc=Oe(ue),a.Pc=Oe(ue),a.c=Oe(ue),a.I=Oe(ue),a.gc=Oe(ue),a.F=Oe(ue),a.dc=Oe(ue),a.kb=Oe(ue),a.J=Oe(ue),a.hc=Oe(ue),a.D=Oe(ue),a.cc=Oe(ue),a.hb=ba(ue),a.wb=new V4,a.t=new Si,a.u=new Si,a.wc=new Si,a.tc=new Si,a.vc=new Si,a.uc=new Si,a.p=new Rl(300,new V5(a)),a.Ib=new Rl(100,new E5(a)),a.mc=new NS(a),a.Jb=new RS(a)}function GG(a,y){var k,z,E,j,te,ne,ie,se,ce,le;if(se=(!a.c&&(a.c=ss(a.f)),a.c),ce=(!y.c&&(y.c=ss(y.f)),y.c),k=a.e-y.e,te=0,E=1,ne=Hx.length-1,y.a==0&&y.f!=-1)throw we(new Jr("Division by zero"));if(se.e==0)return uF(k);z=aG(se,ce),se=c2(se,z),ce=c2(ce,z),j=Fh(ce),ce=Ma(ce,j);do if(le=dG(ce,Hx[E]),le[1].e==0)te+=E,E<ne&&++E,ce=le[0];else{if(E==1)break;E=1}while(!0);if(!t0(ce.e<0?new kn(1,ce.d,ce.a):ce,(Xi(),Al)))throw we(new Jr("Non-terminating decimal expansion; no exact representable decimal result"));return ce.e<0&&(se=se.e==0?se:new kn(-se.e,se.d,se.a)),ie=UF(k+ae.Math.max(j,te)),E=j-te,se=E>0?(No(),E<Gx.length?NU(se,Gx[E]):E<$r.length?Wr(se,$r[E]):Wr(se,al($r[1],E))):Xo(se,-E),new A8(se,ie)}function QG(a,y){var k,z,E;return a.kb.style[fn]=y+(tt(),ke),k=0,a.H>0&&(z=a.Z?a.H+1:a.H,k=3+z*18),E=0,a.fc>0&&(E=1+(a.fc+1)*15),k==0?(a.I.style[Pt]=(It(),tn),a.J.style[Pt]=tn):(a.I.style[Pt]=(It(),vi),a.J.style[Pt]=vi),a.Z||(a.J.style[Pt]=(It(),tn)),a.ib&&a.H>0?a.F.style[Pt]=(It(),vi):a.F.style[Pt]=(It(),tn),a.I.style[Bt]=k+ke,a.I.style[fn]=y+ke,a.F.style[Bt]=k+ke,a.F.style[fn]=y+ke,a.J.style[fn]=y+ke,a.J.style[Bt]=k+ke,a.Db&&(a.J.style[mt]=Tm(a)+ke),a.J.style[vn]=E+ke,a.D.style[fn]=y+ke,a.D.style[vn]=E+ke,a.D.style[Bt]=k+ke,a.cc.style[fn]=y+k+ke,a.cc.style[vn]=Ni,a.cc.style[mt]=E+ke,a.g=E,a.f=k,k}function JG(a,y){var k,z;switch((be(),y).keyCode|0){case 8:case 46:a.t.Z?gn(new Gg(a),100):Ct((ut(),pt),new dg(a)),Ct((ut(),pt),new ag(a));break;case 27:Ii(a.j,a.c),ZN(a.t),Xh(a),y.stopPropagation(),Ie.Vd(y);break;case 13:BD(a.t,(z=Gt(a.j),z??"")),Xh(a),y.stopPropagation(),Ie.Vd(y);break;case 9:pq(a.t,(k=Gt(a.j),k??""),!y.shiftKey),Xh(a),y.stopPropagation();break;case 38:a.g&&(vu(a,!!y.shiftKey,!0,!1,!1),Ie.Vd(y));break;case 39:a.g&&(vu(a,!!y.shiftKey,!1,!0,!1),Ie.Vd(y));break;case 40:a.g&&(vu(a,!!y.shiftKey,!1,!1,!0),Ie.Vd(y));break;case 37:a.g&&(vu(a,!!y.shiftKey,!1,!1,!1),Ie.Vd(y));break;default:ra(a,a.j)}a.e&&(rs(a,!1),Ct((ut(),pt),new fg(a)))}function ez(a,y,k){var z,E,j,te,ne,ie,se,ce;for(a.Zb=!0,z=k-a.Sb,z<0&&(z=0),ls(a.Wb),z>0?sr(a.Yb,"Height: "+z+"px ≈ "+Qv(Jv(z/a.Lb*72))+"pt"):sr(a.Yb,"Hide row"),se="."+a.Ac+mE+a._b+"{height:"+z+Df,zr(a.Wb,se),E=0,ce=gi(a.zc)-k,te=a._b+1;te<=a.zb&&E<ce;te++)E+=Cn(a.a,te)?0:te>=a.W.length?$i(a):a.W[te-1];for(ie=k-a.Tb,ie<a.Sb-a.Tb&&(ie=a.Sb-a.Tb),se="",ne=a._b+1;ne<=a.zb;ne++)se+="."+a.Ac+mE+ne,a.zb!=ne&&(se+=",");if(a.jb&&a._b>=a.jb.a.length)for(j=1;j<=a.jb.a.length;j++)ie+=Cn(a.a,j)?0:j>=a.W.length?$i(a):a.W[j-1];ie+=a.Oc,(!a.jb||a._b>a.jb.a.length)&&(ie-=(a.zc.scrollTop||0)|0),se.length!=0&&(se+="{margin-top:"+ie+Df,zr(a.Wb,se)),se="."+a.Ac+".row-resizing > div.resize-line.rh {margin-top:"+(ie-1)+Df,zr(a.Wb,se),pa(a,y,k)}function YG(a,y){var k,z,E,j,te,ne,ie,se,ce,le,de;(be(),y).changedTouches&&y.changedTouches.length>0?(ce=y.changedTouches,ie=AS(ce[ce.length-1])):y.touches&&y.touches.length>0?(ce=y.touches,ie=AS(ce[ce.length-1])):ie=Kr(y),de=(te=So(ue),xn(),y.type.indexOf(Gn)!=-1?Ts(y.changedTouches[0])+te:Dt(y.clientY||0)+te),le=(j=ko(ue),y.type.indexOf(Gn)!=-1?As(y.changedTouches[0])+j:Dt(y.clientX||0)+j),!PG(a,de,le)&&(z=0,E=0,k=null,ie&&(k=ie.getAttribute(Gi)||"",Mr(a.wb,k),z=a.wb.a,E=a.wb.b),!(E==0||z==0)&&(ne=gs.length,ye(k.substr(k.length-ne,ne),gs)||(se=K0(a,le,de,Rt(a,z,E)),z=se.c,E=se.k),(z!=a.Jc||E!=a.Kc)&&(z==0&&(le>qi(qt(ie))?z=xf(a)+1:z=a.Jc),E==0&&(de>gi(a.zc)?E=vf(a)+1:E=a.Kc),bd(a.a,z,E),a.Jc=z,a.Kc=E)))}function ZG(a,y){var k,z,E,j,te,ne,ie;if(te=qe+y.col1+Ye+y.row1,a.Fb.sheet.deleteRule(0),ne=no(a.Eb,he(y.id)),ie=Rt(a,y.col1,y.row1),ie&&Zu(ie,ne.o,ne.b,!1),lt($u(a.Eb,he(y.id)).d),$u(a.Kb,y),y.col1>=a.yc.e&&y.col2<=a.yc.f&&y.row1>=a.yc.K&&y.row2<=a.yc.L&&Fn(a,y.col1,y.col2,y.row1,y.row2,!1),E=null,a.r&&bn(a.r,te))try{k=Ze(Ze(a.kc,y.row1-a.db),y.col1-a.bb),za(k),E=k.d}catch(se){if(se=Xt(se),!ze(se,21))throw we(se)}if(a.tb&&a.tb.contains(te))try{k=Ze(Ze(a.kc,y.row1-a.db),y.col1-a.bb),Va(k),E=k.d}catch(se){if(se=Xt(se),!ze(se,21))throw we(se)}if(bn(a.b,te)&&E&&(z=Nt(a.b,te),Sm(z,E,y.row1,y.col1)),a.T&&bn(a.T,te))try{k=Ze(Ze(a.kc,y.row1-a.db),y.col1-a.bb),j=Nt(a.T,te),Cm(a,k,j)}catch(se){if(se=Xt(se),!ze(se,21))throw we(se)}}function Hn(a){switch(a){case"blur":return 4096;case"change":return 1024;case"click":return 1;case"dblclick":return 2;case"focus":return 2048;case"keydown":return 128;case"keypress":return 256;case"keyup":return 512;case Td:return gl;case"losecapture":return 8192;case"mousedown":return 4;case"mousemove":return 64;case"mouseout":return 32;case"mouseover":return 16;case L2:return 8;case"scroll":return bl;case"error":return jf;case P2:case"mousewheel":return Y0;case Mz:return 262144;case"paste":return Br;case Pz:return Bs;case"touchmove":return wl;case"touchend":return ui;case"touchcancel":return Au;case"gesturestart":return _2;case"gesturechange":return B2;case"gestureend":return D2;default:return-1}}function _0(a){var y,k,z,E,j,te,ne,ie;z=a.ob>0?1:0,eo(a.Fc).indexOf("report")!=-1&&(z=0),ie=0,a.ic.a.length==0||(ie=Tm(a)),j=0,a.K.a.length==0||(j=p0(a)),E=0,a.a.u&&(te=new ru,Ms(te,Re(a.a.u)),E=bt(te.b)),y=QG(a,E),k=_G(a,E),a.kb.style[fn]=E+(tt(),ke),k==0||y==0?a.kb.style[Pt]=(It(),tn):a.kb.style[Pt]=(It(),vi),a.kb.style[Bt]=y+ke,a.kb.style[mt]=k+ke,Ct((ut(),pt),new z5(a)),a.Z||(ie=0,j=0),a.Oc=j+E+y,a.Cb=ie+k,ne=a.Nc.style,ne[mt]=a.Bb+ie+1+ke,ne[Bt]=a.Lc+j+ke,ne[fn]=E+y+ke,ne[vn]=k+ke,ne=a.Pc.style,ne[vn]=a.Bb+a.Cb+z+ke,ne[Bt]=a.Lc+j+ke,ne[fn]=E+y+ke,ne=a.c.style,ne[mt]=a.Bb+ie+1+ke,ne[fn]=a.Lc+a.Oc+ke,ne[vn]=k+ke,ne=a.zc.style,ne[vn]=a.Bb+a.Cb+z+ke,ne[fn]=a.Lc+a.Oc+ke,ne=a.N.style,ne[fn]=E+y+ke,ne[vn]=k+ke}function eQ(a){var y,k,z,E,j,te,ne,ie,se,ce,le,de;if(ce=eo(a.d).indexOf(" r ")!=-1||Dh(eo(a.d)," r"),E=Gu(a.n.a,a.c),le=no(a.n.qc,new ya(a.o,a.b,a.k,a.c)),!le&&(le=he(yT(a))),se=le.a-E,!ce&&se>0){for(se+=2,k=a.c,de=0,z=a.n.a.g,te=ak(a.n,k);k<z.length&&de<se&&!(te&&!ak(a.n,k+1)||(ne=Rt(a.n,k+1,a.k),ne&&ne.o!=null&&ne.o.length!=0));)de+=z[k],++k;if(de+=E,ie=Oe(ue),ie.style[F2]=tn,ie.style[mt]=de+(tt(),ke),ie.style[qr]=(ts(),dt),ie.style.textOverflow=(ew(),"ellipsis"),y=a.d.childNodes,y)for(j=y.length-1;j>=0;j--)ie.appendChild(y[j]);a.d.innerHTML="",xe(a.d,ie),sA(a),a.i=!0}else a.i=!1;rd(a.n,qe+a.c+Ye+a.k)&&!ze(a,171)?a.d.style[qr]=(ts(),dt):se>0?a.d.style[qr]=(ts(),ni):a.d.style[qr]=(ts(),dt),a.g=!1}function g2(a,y,k,z,E,j){var te,ne,ie,se,ce,le,de,pe,me,je,wt,jt,Wt,$t,De,Qt,sn,Tn;for(wt=Le(gt,yt,17,z+1,15,1),jt=Le(gt,yt,17,j+1,15,1),Wt=j,ie=wu(E[j-1]),ie!=0?(Em(jt,E,0,ie),Em(wt,k,0,ie)):(hl(k,0,wt,0,z),hl(E,0,jt,0,j)),se=jt[Wt-1],le=y-1,de=z;le>=0;){if(ce=0,wt[de]==se)ce=-1;else if($t=Vt(_n(Ve(wt[de],Xe),32),Ve(wt[de-1],Xe)),sn=wV($t,se),ce=_e(sn),Qt=_e(Bn(sn,32)),ce!=0){me=0,Tn=0,De=!1,++ce;do{if(--ce,De)break;me=Oi(Ve(ce,Xe),Ve(jt[Wt-2],Xe)),Tn=Vt(_n(Qt,32),Ve(wt[de-2],Xe)),je=Vt(Ve(Qt,Xe),Ve(se,Xe)),wu(_e(Yn(je,32)))<32?De=!0:Qt=_e(je)}while(oN(iv(me,Fj),iv(Tn,Fj)))}if(ce!=0&&(te=pU(wt,de-Wt,jt,Wt,ce),te!=0))for(--ce,ne=0,pe=0;pe<Wt;pe++)ne=Vt(ne,Vt(Ve(wt[de-Wt+pe],Xe),Ve(jt[pe],Xe))),wt[de-Wt+pe]=_e(ne),ne=Yn(ne,32);a!=null&&(a[le]=ce),--de,--le}return ie!=0?(Mm(jt,Wt,wt,0,ie),jt):(hl(wt,0,jt,0,j),wt)}function tz(a){var y,k,z,E,j,te,ne,ie,se,ce,le,de,pe,me;ne=qi(a.c),E=(a.c.offsetLeft||0)|0,te=(a.c.offsetWidth||0)|0,j=(a.c.offsetTop||0)|0,ie=Vn(a.c),ce=ne+15,ce+a.n>qi(a.o)&&(me=bi(a.c)-15-a.n,bi(a.o)<me&&(ce=me)),le=ie-15,de=gi(a.o),le+a.k>de?(le-=le+a.k-de+5,pe=Vn(a.o),le<pe&&(le=pe)):le<Vn(a.o)&&(le+=Vn(a.o)-le),ll(a,ce,le),a.j!=null&&zt(a.i,a.j),a.j=qe+a.b+Ye+a.d,le+=2,ce+=2,k=ie-le,ce>ne?(y=ce-ne,k>0?se=-(ae.Math.atan(k/y)*Qz):(k=ae.Math.abs(k),se=0)):(ce-=2,y=ne-(ce+a.n),k>0?se=-180+ae.Math.atan(k/y)*Qz:(k=ae.Math.abs(k),se=-180)),z=ae.Math.sqrt(y*y+k*k)+1,a.i.style[mt]=z+(tt(),ke),a.i.style[fn]=j+ke,a.i.style[vn]=E+te+ke,a.i.style.transform=H2+se+"deg)",a.i.style.msTransform=H2+se+"deg)",a.i.style[$2]=H2+se+"deg)",Ue(a.i,a.j),xe(a.o,a.i)}function nz(a,y,k,z){var E,j,te,ne,ie,se,ce;if(se=!1,y<=a.Sc&&(y=a.Sc+1),ce=id(a),E=vf(a),z){if(y<ce){for(ie=0,j=ce-1;j>=y-1&&j>0;j--)ie+=Cn(a.a,j)?0:j>=a.W.length?$i(a):a.W[j-1];ne=((a.zc.scrollTop||0)|0)-ie,wo(a.zc,ne>0?ne:0),(y<=a.db||ie>(a.a.L/2|0))&&(se=!0)}else if(y>E){for(ie=0,te=a.a.O,j=E+1;j<=y+1&&j<=te;j++)ie+=Cn(a.a,j)?0:j>=a.W.length?$i(a):a.W[j-1];wo(a.zc,((a.zc.scrollTop||0)|0)+ie),(y>=a.zb||ie>(a.a.L/2|0))&&(se=!0)}}else if(k>E){for(ie=0,te=a.a.O,j=E+1;j<=k+1&&j<=te;j++)ie+=Cn(a.a,j)?0:j>=a.W.length?$i(a):a.W[j-1];wo(a.zc,((a.zc.scrollTop||0)|0)+ie),(k>=a.zb||ie>(a.a.L/2|0))&&(se=!0)}else if(k<ce){for(ie=0,j=ce-1;j>=k-1&&j>0;j--)ie+=Cn(a.a,j)?0:j>=a.W.length?$i(a):a.W[j-1];ne=((a.zc.scrollTop||0)|0)-ie,wo(a.zc,ne>0?ne:0),(k<=a.db||ie>(a.a.L/2|0))&&(se=!0)}return se}function tQ(a){var y,k,z,E,j,te,ne,ie,se;if(!a.j){zp=null,Sr(a.d.a),a.d=null;return}if(y=a.n+a.a,te=((a.q.scrollHeight||0)|0)-(a.q.clientHeight|0),k=-1,y>te?(ie=te-y,z=te):y<0?(ie=-y,z=0):(ne=k$(a),Di(jn((ht(fi),fi.k)),"pxPerMs"+ne),ie=bt(.5*ne*ne/.002),ne<0&&(ie=-ie),z=y+ie,z>te+(vr?0:(a.q.clientHeight|0)/3|0)?(z=((a.q.scrollHeight||0)|0)-(a.q.clientHeight|0)+(vr?0:(a.q.clientHeight|0)/3|0),E=z-y,ie=E):z<-(vr?0:(a.q.clientHeight|0)/3|0)?(z=-(vr?0:(a.q.clientHeight|0)/3|0),E=z-y,ie=E):k=bt(ae.Math.abs(ne/.002))),k==-1&&(k=350),k>1500&&(Di(jn((ht(fi),fi.k)),"Max animation time. "+k),k=1500),a.c=z,ae.Math.abs(ie)<3||k<20){Di(jn((ht(fi),fi.k)),"Small 'momentum' "+ie+" |  "+k+" Skipping animation,"),km(a);return}se=-z+a.n,j=-y+a.n,vr&&(j-=a.n,se-=a.n),cA(a,k,j,se)}function iz(a,y){HV();var k,z,E;this.r=(fe(),Oe(ue)),this.i=new st,this.F=new Si,this.D=new Ot,this.G=new Ot,this.t=a,this.I=y,this.w=y.sb,this.H=new T4,E$(this.H,y,this),this.j=new ia,Ng(this.j,2),this.a=new ia,Ng(this.a,1),Pi(this.j,"functionfield"),Pi(this.a,"addressfield"),this.B=new zA,Pi(this.B,"namedrangebox"),jR(this.B),kg(this.B,""),this.C=new sI,Pi(this.C,"arrow"),ai(this.B,!1),ai(this.C,!1),z=new nf,k=new nf,E=new nf,k.Xc.className="fixed-left-panel",E.Xc.className="adjusting-right-panel",_u(k,this.a),_u(k,this.C),_u(k,this.B),_u(E,this.j),Rh(z,k,z.Xc),Rh(z,E,z.Xc),Um(this,z),this.Xc.className="functionbar",Uo(Re(this.B),1024),Ss(Re(this.B),new b5(this)),Uo(Re(this.a),6656),Ss(Re(this.a),new f5(this)),Uo(Re(this.j),7048),Ss(Re(this.j),new g5(this)),this.r.className="formulaoverlay",xe(this.Xc,this.r)}function nQ(a,y,k){var z,E,j,te,ne,ie,se;if(j=(fe(),Hn((be(),y).type)),ie=k.getAttribute(Gi)||"",ye(ie,Kd)||ye(ie,Ld)){if(z=qt(k),E=z.getAttribute(Gi)||"",ne=gs.length,ye(E.substr(E.length-ne,ne),gs)&&(E=au(E,xE,"")),bn(a.b,E))return;j==16?Qw(a.q)&&ye(E,a.j)||(Mr(a.wb,E),a.k=a.wb.a,a.n=a.wb.b,Vs(a.p)):(se=Ie.Td(y),!a.o&&!(se&&se.equals?se.equals(z):se==z)&&(Pl(a.q),a.j=null,a.k=-1,a.n=-1))}else{if(ne=gs.length,ye(ie.substr(ie.length-ne,ne),gs)&&(ie=au(ie,xE,"")),bn(a.b,ie))return;if(j==16)Qw(a.q)&&ye(ie,a.j)||(dh(a.zc),Mr(a.wb,ie),a.k=a.wb.a,a.n=a.wb.b,Vs(a.p));else if(j==32&&(se=Ie.Td(y),!a.o&&se&&qt(se)))try{oP(se.getAttribute(Gi)||"")&&En(qt(se),k)||(Pl(a.q),a.j=null,a.n=-1,a.k=-1)}catch(ce){if(ce=Xt(ce),ze(ce,49))te=ce,Mh(a.U,"SheetWidget:updateCellCommentDisplay: NPE ONMOUSEOUT, "+te.f);else throw we(ce)}}}function w2(){w2=ge;var a,y,k;for(new os(1,0),new os(10,0),new os(0,0),_x=Le(GW,ve,36,11,0,1),s1=Le(Yx,ve,17,100,15,1),Bx=Se(Ce(_p,1),ve,17,15,[1,5,25,125,625,3125,15625,78125,390625,1953125,9765625,48828125,Py,_y,6103515625,30517578125,152587890625,762939453125,3814697265625,19073486328125,95367431640625,476837158203125,0x878678326eac9]),Dx=Le(gt,yt,17,Bx.length,15,1),qx=Se(Ce(_p,1),ve,17,15,[1,10,100,_r,1e4,1e5,1e6,1e7,1e8,jd,1e10,1e11,1e12,1e13,1e14,1e15,1e16]),Fx=Le(gt,yt,17,qx.length,15,1),c1=Le(GW,ve,36,11,0,1),a=0;a<c1.length;a++)_x[a]=new os(a,0),c1[a]=new os(0,a),s1[a]=48;for(;a<s1.length;a++)s1[a]=48;for(k=0;k<Dx.length;k++)Dx[k]=qm(Bx[k]);for(y=0;y<Fx.length;y++)Fx[y]=qm(qx[y]);No(),Hx=$r}function iQ(){function a(){this.obj=this.createObject()}return a.prototype.createObject=function(y){return Object.create(null)},a.prototype.get=function(y){return this.obj[y]},a.prototype.set=function(y,k){this.obj[y]=k},a.prototype[gp]=function(y){delete this.obj[y]},a.prototype.keys=function(){return Object.getOwnPropertyNames(this.obj)},a.prototype.entries=function(){var y=this.keys(),k=this,z=0;return{next:function(){if(z>=y.length)return{done:!0};var E=y[z++];return{value:[E,k.get(E)],done:!1}}}},UU()||(a.prototype.createObject=function(){return{}},a.prototype.get=function(y){return this.obj[":"+y]},a.prototype.set=function(y,k){this.obj[":"+y]=k},a.prototype[gp]=function(y){delete this.obj[":"+y]},a.prototype.keys=function(){var y=[];for(var k in this.obj)k.charCodeAt(0)==58&&y.push(k.substring(1));return y}),a}function rz(a){this.k=Oe(ue),this.c=Oe(ue),this.i=Oe(ue),this.n=Oe(ue),this.o=Oe(ue),this.p=Oe(ue),this.q=Oe(ue),this.a=Oe(ue),this.g=yA(ue),this.v=Oe(ue),this.u=[],this.f=Oe(ue),this.e=a,this.n.className="scroll-tabs-beginning",this.o.className="scroll-tabs-end",this.p.className="scroll-tabs-left",this.q.className="scroll-tabs-right",this.a.className="add-new-tab",this.i.className="sheet-tabsheet-options",xe(this.i,this.n),xe(this.i,this.p),xe(this.i,this.q),xe(this.i,this.o),xe(this.i,this.a),this.c.className="sheet-tabsheet-container",this.v.className="sheet-tabsheet-temp",xe(this.k,this.v),this.k.className="sheet-tabsheet",xe(this.k,this.i),xe(this.k,this.c),this.f.className="sheet-tabsheet-infolabel",xe(this.k,this.f),xs(this,this.k),Uo(this.k,3),Ss(this.k,new I5(this)),Uo(this.g,4736),Ss(this.g,new A5(this)),this.g.maxLength=31}function oz(a,y){var k,z;UG(this),k=P8().toLowerCase(),this.vb=k.indexOf("macintosh")!=-1||k.indexOf("mac osx")!=-1||k.indexOf("mac os x")!=-1,this.a=a,this.Rc=y,this.e=new Ot,this.b=new Ot,this.Bc=new Ot,this.Eb=new Ot,this.Kb=new Ot,this.rb=new wf,Pi(this.rb,"v-spreadsheet-hyperlink-tooltip-label"),this.qb=new wa,Pi(this.qb,"v-tooltip"),this.qb.r=this,af(this.qb,this.rb),this.Yb=new wf,Pi(this.Yb,"v-spreadsheet-resize-tooltip-label"),this.Xb=new wa,Pi(this.Xb,"v-tooltip"),this.Xb.r=this,af(this.Xb,this.Yb),this.q=new v2(this,this.zc),OR(this.q),cQ(this),Sn((fe(),this.Xc),iy,!0),this.yc=new nV(a,this),this.M=new NT(this,new d5(this)),xe(this.Xc,Re(this.M)),z=new A4,z.c=this,z.a=this.vb,SH(z,this.Nc,this.Pc,this.c,this.zc),this.Nb=Yh(new X5(this)),Xn(this,new W5(this),(Du(),Du(),xl)),this.lc=new Rl(20,new j5(this)),this.Rb=new Rl(100,new O5(this))}function v2(a,y){Qr();var k;wa.call(this),this.e=dI(ue),this.o=y,this.p=new nf,af(this,this.p),this.i=Oe(ue),this.i.className=Jz,this.a=new wf,ai(this.a,!1),Pi(this.a,"comment-overlay-author"),this.g=new wf,ai(this.g,!1),Pi(this.g,"comment-overlay-label"),li.af((fe(),fe(),Yr(this.Xc))).className="v-spreadsheet-comment-overlay",Sn(li.af(Yr(this.Xc)),"v-spreadsheet-comment-overlay-shadow",!0),this.r=a,this.F=!1,this.Xc.style[ot]=dt,this.t&&(this.t.style[ot]=dt),this.i.style[ot]=(at(),dt),this.Xc.style[uo]="0",this.f=new wf,ai(this.f,!1),Pi(this.f,"comment-overlay-invalidformula"),_u(this.p,this.f),_u(this.p,this.a),_u(this.p,this.g),Ue(this.e,"comment-overlay-input"),this.e.style[Pt]=(It(),tn),xe(this.Xc,this.e),this.e.rows=4,this.e.style[mt]=(tt(),"200.0px"),k=new f6(this,a),Xn(this.a,k,(Ao(),Ao(),ws)),Xn(this.g,k,ws)}function rQ(a,y){M0();var k,z,E,j,te,ne,ie,se,ce,le,de,pe,me,je;if(ie=en(a,0)<0,ie&&(a=tu(a)),en(a,0)==0)switch(y){case 0:return"0";case 1:return"0.0";case 2:return"0.00";case 3:return"0.000";case 4:return"0.0000";case 5:return"0.00000";case 6:return"0.000000";default:return pe=new Bi,y<0?pe.a+="0E+":pe.a+="0E",pe.a+=y==xu?"2147483648":""+-y,pe.a}ce=18,le=Le(Yx,ve,17,ce+1,15,1),k=ce,je=a;do se=je,je=fs(je,10),le[--k]=_e(Vt(48,cn(se,Oi(je,10))))&Rs;while(en(je,0)!=0);if(E=cn(cn(cn(ce,k),y),1),y==0)return ie&&(le[--k]=45),Ko(le,k,ce-k);if(y>0&&en(E,-6)>=0){if(en(E,0)>=0){for(j=k+_e(E),ne=ce-1;ne>=j;ne--)le[ne+1]=le[ne];return le[++j]=46,ie&&(le[--k]=45),Ko(le,k,ce-k+1)}for(te=2;zk(te,Vt(tu(E),1));te++)le[--k]=48;return le[--k]=46,le[--k]=48,ie&&(le[--k]=45),Ko(le,k,ce-k)}return me=k+1,z=ce,de=new z1,ie&&(de.a+="-"),z-me>=1?(hI(de,le[k]),de.a+=".",de.a+=Ko(le,k+1,ce-k-1)):de.a+=Ko(le,k,ce-k),de.a+="E",en(E,0)>0&&(de.a+="+"),de.a+=""+fa(E),de.a}function sz(a,y,k,z,E,j,te){var ne,ie,se,ce,le,de,pe,me,je,wt,jt,Wt;for(pe=dA(a);pe.a<pe.c.a.length;)wt=He(pe),ze(wt,96)&&qn(wt,null);if(ns(y),ns(k),ne=0,j&&!a.G?ne=5:!j&&!a.ec&&(ne=2),te>0)for(j?(Wt=a.gc.clientWidth|0,a.Z&&(Wt+=Tm(a))):(Wt=a.I.clientHeight|0,a.Z&&(Wt+=p0(a))),Wt+=ne,le=new Fe(z);le.a<le.c.a.length;){for(ce=He(le),j?(je=new Rg(ce.uniqueIndex,a.a),PA(je,a.G)):(je=new Pg(ce.uniqueIndex,a.a),PA(je,a.ec)),jt=Wt,de=0;de<ce.startIndex;de++)j?jt+=Ft(a.a,de+1):jt+=Cn(a.a,de+1)?0:de+1>=a.W.length?$i(a):a.W[de+1-1];for(je.f&&(j?jt-=Kg(a,ce.startIndex)/2|0:jt-=Ai(a,ce.startIndex)/2|0),je.kf(jt,ce.level-1),jT(je,ce.collapsed),xe(y,(fe(),je.Xc)),qn(je,a),me=0,se=ce.startIndex;se<=ce.endIndex;se++)j?me+=Ft(a.a,se+1):me+=Cn(a.a,se+1)?0:se+1>=a.W.length?$i(a):a.W[se+1-1];me-=ne,je.f?j?me+=Kg(a,ce.startIndex)/2:me+=Ai(a,ce.startIndex)/2:j?me+=Kg(a,ce.endIndex+2)/2:me+=Ai(a,ce.endIndex+2)/2,tB(je,me),E&&E.a.length>ce.startIndex&&(ie=je.gf(),xe(k,ie.Xc),qn(ie,a))}}function oQ(){var a,y,k;for(y=ue.compatMode,a=Se(Ce(ct,1),Mi,2,6,[_s]),k=0;k<a.length;k++)if(ye(a[k],y))return;a.length==1&&ye(_s,a[0])&&ye("BackCompat",y)?""+y:""+y}function cz(a,y){var k=(a.__eventBits||0)^y;a.__eventBits=y,k&&(k&1&&(a.onclick=y&1?hn:null),k&2&&(a.ondblclick=y&2?hn:null),k&4&&(a.onmousedown=y&4?hn:null),k&8&&(a.onmouseup=y&8?hn:null),k&16&&(a.onmouseover=y&16?hn:null),k&32&&(a.onmouseout=y&32?hn:null),k&64&&(a.onmousemove=y&64?hn:null),k&128&&(a.onkeydown=y&128?hn:null),k&256&&(a.onkeypress=y&256?hn:null),k&512&&(a.onkeyup=y&512?hn:null),k&1024&&(a.onchange=y&1024?hn:null),k&2048&&(a.onfocus=y&2048?hn:null),k&4096&&(a.onblur=y&4096?hn:null),k&8192&&(a.onlosecapture=y&8192?hn:null),k&bl&&(a.onscroll=y&bl?hn:null),k&gl&&(a.onload=y&gl?yW:null),k&jf&&(a.onerror=y&jf?hn:null),k&Y0&&(a.onmousewheel=y&Y0?hn:null),k&262144&&(a.oncontextmenu=y&262144?hn:null),k&Br&&(a.onpaste=y&Br?hn:null),k&Bs&&(a.ontouchstart=y&Bs?hn:null),k&wl&&(a.ontouchmove=y&wl?hn:null),k&ui&&(a.ontouchend=y&ui?hn:null),k&Au&&(a.ontouchcancel=y&Au?hn:null),k&_2&&(a.ongesturestart=y&_2?hn:null),k&B2&&(a.ongesturechange=y&B2?hn:null),k&D2&&(a.ongestureend=y&D2?hn:null))}function ti(a,y,k,z,E){var j,te,ne,ie,se,ce;if(y==k&&z==E)return ne=fl(a,z,y),ne||(ne=new vs,ne.col1=z,ne.col2=E,ne.row1=y,ne.row2=k),ne;if(te=ed(a,z,y),te&&te.col2>=E&&te.row2>=k)return te;for(ce=!1,j=z;j<=E;)ie=fl(a,j,y),ie?(j=ie.col2+1,z>ie.col1&&(z=ie.col1,ce=!0),E<ie.col2&&(E=ie.col2,ce=!0),y>ie.row1&&(y=ie.row1,ce=!0)):++j;for(y>k&&(y=k),j=y;j<=k;)ie=fl(a,E,j),ie?(j=ie.row2+1,E<ie.col2&&(E=ie.col2,ce=!0),y>ie.row1&&(y=ie.row1,ce=!0),k<ie.row2&&(k=ie.row2,ce=!0)):++j;for(E<z&&(E=z),j=z;j<=E;)ie=fl(a,j,k),ie?(j=ie.col2+1,z>ie.col1&&(z=ie.col1,ce=!0),E<ie.col2&&(E=ie.col2,ce=!0),k<ie.row2&&(k=ie.row2,ce=!0)):++j;for(k<y&&(k=y),j=y;j<=k;)ie=fl(a,z,j),ie?(j=ie.row2+1,z>ie.col1&&(z=ie.col1,ce=!0),y>ie.row1&&(y=ie.row1,ce=!0),k<ie.row2&&(k=ie.row2,ce=!0)):++j;return z>E&&(z=E),ce?ti(a,y,k,z,E):y==k&&z==E?(ne=fl(a,z,y),ne||(ne=new vs,ne.col1=z,ne.col2=E,ne.row1=y,ne.row2=k),ne):(te=ed(a,z,y),te&&te.col2>=E&&te.row2>=k?te:(se=new vs,se.col1=z,se.col2=E,se.row1=y,se.row2=k,se))}function sQ(a,y){var k,z,E,j,te,ne;if(E=kh(y.a),z=a.b.a,a.b._)switch(E){case 8:case 46:Tv(a.b),p7(a.a),rs(a.a,!0),Yg(a.a),sR(a.a);break;case 27:du(z,z.b,!0),CM(z.u),Ar(z.V),Zl(a.a);break;case 9:Lv(z,(ne=Gt(a.b.sb),ne??""),Yl(y.a)),Zl(a.a),y.a&&ki(y.a);break;case 38:oa(a.a)?(Kv(z,(te=Gt(a.b.sb),te??""),!0),y.a&&ki(y.a)):S1(a.a)&&(vu(a.a,Yl(y.a),!0,!1,!1),y.a&&ki(y.a));break;case 40:oa(a.a)?(Kv(z,(te=Gt(a.b.sb),te??""),!1),y.a&&ki(y.a)):S1(a.a)&&(vu(a.a,Yl(y.a),!1,!1,!0),y.a&&ki(y.a));break;case 37:oa(a.a)?(Lv(z,(te=Gt(a.b.sb),te??""),!0),y.a&&ki(y.a)):S1(a.a)?(vu(a.a,Yl(y.a),!1,!1,!1),y.a&&ki(y.a)):a.a.v&&(rs(a.a,!0),Is(a.b.sb)==0&&y.a&&ki(y.a));break;case 39:oa(a.a)?(Lv(z,(te=Gt(a.b.sb),te??""),!1),y.a&&ki(y.a)):S1(a.a)?(vu(a.a,Yl(y.a),!1,!0,!1),y.a&&ki(y.a)):a.a.v&&(rs(a.a,!0),k=Is(a.b.sb),j=(te=Gt(a.b.sb),te??"").length,k==j&&y.a&&ki(y.a))}else D0(z,y.a,cP(FN(y.a)));Yo(y.a)}function B0(a,y,k,z,E,j){var te,ne,ie,se,ce,le,de,pe,me;if(od(a),!(y==0||k==0))if(se=!1,j||(se=k!=a.V.sc||y!=a.V.rc),z)de=a.V.rc,pe=a.V.sc,te=de>y?y:de,ne=de>y?de:y,ce=pe>k?k:pe,le=pe>k?pe:k,me=ti(a.I,ce,le,te,ne),a.u.f||(Hi(a.V.yc)?(Ei(a.V,me.col1,me.col2,me.row1,me.row2),Fn(a.V,me.col1,me.col2,me.row1,me.row2,!0)):Fn(a.V,me.col1,me.col2,me.row1,me.row2,!1)),a.u.f?If(a.u,a.X,a.Y,y,k,!1):j&&(Hi(a.V.yc)?Hh(a.W,me.row1,me.col1,me.row2,me.col2):Ev(a.W,me.row1,me.col1,me.row2,me.col2),gn(a.s,200));else if(E){if(y==a.V.rc&&k==a.V.sc)return;a.u.f?If(a.u,y,k,y,k,!0):(a.V.C&&(a.V.C=!1),Hi(a.V.yc)&&go(a.V,!1),h2(a.V,y,k),Lr(a.Q),se&&Ks(a,y,k,null),j&&(OB(a.W,k,y),gn(a.s,200)))}else ie=ed(a.I,y,k),a.u.f?(a.X=y,a.Y=k,If(a.u,y,k,y,k,!1)):(a.V.C||(a.V.C=!0),Hi(a.V.yc)||(go(a.V,!0),is(a.V)),Lu(a.V,y,k),ie?(Ei(a.V,ie.col1,ie.col2,ie.row1,ie.row2),Fn(a.V,ie.col1,ie.col2,ie.row1,ie.row2,!0),gK(a.Q,ie.col1),wK(a.Q,ie.row1)):(Ei(a.V,y,y,k,k),Fn(a.V,y,y,k,k,!0)),se&&Ks(a,y,k,null),j&&(Lr(a.Q),qa(a.W,k,y,!0),gn(a.s,200)))}function cQ(a){xs(a,a.Fc),xe(a.Fc,a.zc),Ue(a.Fc,"v-spreadsheet"),a.zc.className="bottom-right-pane",Ue(a.zc,yl),a.zc.tabIndex=3,a.Pc.className="top-right-pane",Ue(a.Pc,yl),xe(a.Fc,a.Pc),a.c.className="bottom-left-pane",Ue(a.c,yl),xe(a.Fc,a.c),a.Nc.className="top-left-pane",Ue(a.Nc,yl),xe(a.Fc,a.Nc),a.I.className="col-group-pane",xe(a.Fc,a.I),a.gc.className="row-group-pane",xe(a.Fc,a.gc),a.F.className="col-group-freeze-pane",xe(a.Fc,a.F),a.dc.className="row-group-freeze-pane",xe(a.Fc,a.dc),a.hc.className="row-group-summary",xe(a.Fc,a.hc),a.J.className="col-group-summary",xe(a.Fc,a.J),a.D.className="col-group-border",xe(a.Fc,a.D),a.cc.className="row-group-border",xe(a.Fc,a.cc),a.kb.className="grouping-corner",xe(a.Fc,a.kb),a.Ub.className=lp,xe(a.Fc,a.Ub),a.Vb.className=lp,xe(a.zc,a.Vb),a.N.className="corner",xe(a.Fc,a.N),a.fb.className="floater",a.sb=new L9(a),Y1(a.sb,"0"),Ii(a.sb,"x"),Re(a.sb).id="cellinput",fe(),xe(a.zc,Vr(Re(a.sb))),vC(a,a.sb),a.Mb.style[mt]=(tt(),"1.0in"),a.Mb.style[as]=(Ju(),Su),a.Mb.style[ot]=(at(),dt),a.Mb.style.padding=Ni,xe(a.Fc,a.Mb),a.hb.style[ot]=dt,xo(a.hb,yE)}function uQ(a,y){var k,z,E,j,te,ne,ie,se;if(k=0,te=0,j=y.length,ne=null,se=new z1,te<j&&(Tt(te,y.length),y.charCodeAt(te)==43)&&(++te,++k,te<j&&(Tt(te,y.length),y.charCodeAt(te)==43||(Tt(te,y.length),y.charCodeAt(te)==45))))throw we(new yo(Ef+y+'"'));for(;te<j&&(Tt(te,y.length),y.charCodeAt(te)!=46)&&(Tt(te,y.length),y.charCodeAt(te)!=101)&&(Tt(te,y.length),y.charCodeAt(te)!=69);)++te;if(se.a+=""+y.substr(k,te-k),te<j&&(Tt(te,y.length),y.charCodeAt(te)==46)){for(++te,k=te;te<j&&(Tt(te,y.length),y.charCodeAt(te)!=101)&&(Tt(te,y.length),y.charCodeAt(te)!=69);)++te;a.e=te-k,se.a+=""+y.substr(k,te-k)}else a.e=0;if(te<j&&(Tt(te,y.length),y.charCodeAt(te)==101||(Tt(te,y.length),y.charCodeAt(te)==69))&&(++te,k=te,te<j&&(Tt(te,y.length),y.charCodeAt(te)==43)&&(++te,te<j&&(Tt(te,y.length),y.charCodeAt(te)!=45)&&++k),ne=y.substr(k,j-k),a.e=a.e-Wi(ne),a.e!=bt(a.e)))throw we(new yo("Scale out of range."));if(ie=se.a,ie.length<16){if(a.f=($x==null&&($x=new RegExp("^[+-]?\\d*$","i")),$x.test(ie)?parseInt(ie,10):NaN),isNaN(a.f))throw we(new yo(Ef+y+'"'));a.a=qm(a.f)}else R9(a,new w7(ie));for(a.d=se.a.length,E=0;E<se.a.length&&(z=xI(se.a,E),!(z!=45&&z!=48));++E)--a.d;a.d==0&&(a.d=1)}function lQ(a,y,k){var z,E,j,te,ne,ie;for(E=Se(Ce(ct,1),Mi,2,6,[mj,yj,"rows","cols",xj,Cj,kj,Sj,Ij,Aj,"defRowH","defColW","rowH","colW",Tj,Vj,zj,Ej,jj,Oj,Xj,cy,uy,Wj,Kj,Lj,Mj,Nj,Rj,ly,fy,Pj,_j,Bj,Dj,qj,Bt,mt,wy,vy,py,Ey,"id",Ay,ap,gy,jy,my]),j=0,te=E.length;j<te;++j)z=E[j],(k.b||DT(k,z))&&(ie=(!y.C&&(y.C=new un),y.C),ne=Je(a.e),ye(mj,z)&&WK(ie,ne.P),ye(yj,z)&&EK(ie,ne.k),ye("rows",z)&&LK(ie,ne.V),ye("cols",z)&&zK(ie,ne.j),ye(xj,z)&&JL(ie,ne.e),ye(Cj,z)&&cM(ie,ne.Q),ye(kj,z)&&ZL(ie,ne.g),ye(Sj,z)&&lM(ie,ne.S),ye(Ij,z)&&YL(ie,ne.f),ye(Aj,z)&&uM(ie,ne.R),ye("defRowH",z)&&OK(ie,ne.r),ye("defColW",z)&&jK(ie,ne.q),ye("rowH",z)&&KK(ie,ne.T),ye("colW",z)&&VK(ie,ne.i),ye(Tj,z)&&vB(ie,ne.d),ye(Vj,z)&&yB(ie,ne.U),ye(zj,z)&&mB(ie,ne.n),ye(Ej,z)&&GB(ie,ne.J),ye(jj,z)&&QB(ie,ne.K),ye(Oj,z)&&_R(ie,ne.Z),ye(Xj,z)&&KR(ie,ne.p),ye(cy,z)&&GM(ie,ne.v),ye(uy,z)&&QM(ie,ne.w),ye(Wj,z)&&PK(ie,ne.$),ye(Kj,z)&&XK(ie,ne.A),ye(Lj,z)&&dM(ie,ne.cb),ye(Mj,z)&&rM(ie,ne.C),ye(Nj,z)&&eM(ie,ne.s),ye(Rj,z)&&tM(ie,ne.t),ye(ly,z)&&fM(ie,ne._),ye(fy,z)&&nM(ie,ne.B),ye(Pj,z)&&hM(ie,ne.D),ye(_j,z)&&sM(ie,ne.G),ye(Bj,z)&&qF(ie,ne.H),ye(Dj,z)&&lq(ie,ne.I),ye(qj,z)&&aM(ie,ne.M),ye(Bt,z)&&O9(ie,ne.jb),ye(mt,z)&&X9(ie,ne.nb),ye("id",z)&&xC(ie,ne.kb))}function uz(a,y){M0();var k,z,E,j,te,ne,ie,se,ce,le,de,pe,me,je,wt,jt,Wt,$t,De,Qt,sn,Tn,ir,rr,mr,Ur,hi,ao;if(ir=a.e,me=a.d,E=a.a,ir==0)switch(y){case 0:return"0";case 1:return"0.0";case 2:return"0.00";case 3:return"0.000";case 4:return"0.0000";case 5:return"0.00000";case 6:return"0.000000";default:return sn=new Bi,y<0?sn.a+="0E+":sn.a+="0E",sn.a+=-y,sn.a}if($t=me*10+1+7,De=Le(Yx,ve,17,$t+1,15,1),k=$t,me==1)if(ne=E[0],ne<0){ao=Ve(ne,Xe);do je=ao,ao=fs(ao,10),De[--k]=48+_e(cn(je,Oi(ao,10)))&Rs;while(en(ao,0)!=0)}else{ao=ne;do je=ao,ao=ao/10|0,De[--k]=48+(je-ao*10)&Rs;while(ao!=0)}else{mr=Le(gt,yt,17,me,15,1),hi=me,hl(E,0,mr,0,hi);e:for(;;){for(Tn=0,se=hi-1;se>=0;se--)Ur=Vt(_n(Tn,32),Ve(mr[se],Xe)),jt=r$(Ur),mr[se]=_e(jt),Tn=_e(Bn(jt,32));Wt=_e(Tn),wt=k;do De[--k]=48+Wt%10&Rs;while((Wt=Wt/10|0)!=0&&k!=0);for(z=9-wt+k,ie=0;ie<z&&k>0;ie++)De[--k]=48;for(le=hi-1;mr[le]==0;le--)if(le==0)break e;hi=le+1}for(;De[k]==48;)++k}if(pe=ir<0,te=$t-k-y-1,y==0)return pe&&(De[--k]=45),Ko(De,k,$t-k);if(y>0&&te>=-6){if(te>=0){for(ce=k+te,de=$t-1;de>=ce;de--)De[de+1]=De[de];return De[++ce]=46,pe&&(De[--k]=45),Ko(De,k,$t-k+1)}for(le=2;le<-te+1;le++)De[--k]=48;return De[--k]=46,De[--k]=48,pe&&(De[--k]=45),Ko(De,k,$t-k)}return rr=k+1,j=$t,Qt=new z1,pe&&(Qt.a+="-"),j-rr>=1?(hI(Qt,De[k]),Qt.a+=".",Qt.a+=Ko(De,k+1,$t-k-1)):Qt.a+=Ko(De,k,$t-k),Qt.a+="E",te>0&&(Qt.a+="+"),Qt.a+=""+te,Qt.a}function D0(a,y,k){var z,E;if((be(),Ie).Rd(y)==0&&(y.keyCode|0)!=32||Ie.Rd(y)==13)switch(y.keyCode|0){case 8:case 46:n0(a),a.e||(xt(a.W.t,Se(Ce(Ke,1),ve,1,5,[])),ch(a.u,""));break;case 40:y.shiftKey?lz(a.Q,!0):vd(a.Q,!0);break;case 37:y.shiftKey?fz(a.Q,!1):l2(a.Q,!0);break;case 9:y.shiftKey?l2(a.Q,et(a.v,he(a.V.rc),0)!=-1||et(a.w,he(a.V.sc),0)!=-1):L0(a.Q,et(a.v,he(a.V.rc),0)!=-1||et(a.w,he(a.V.sc),0)!=-1);break;case 39:y.shiftKey?fz(a.Q,!0):L0(a.Q,!0);break;case 38:y.shiftKey?lz(a.Q,!1):u2(a.Q,!0);break;case 113:case 13:if((y.keyCode|0)==13){if(et(a.v,he(a.V.rc),0)!=-1||et(a.w,he(a.V.sc),0)!=-1){vd(a.Q,!0);break}else if(a.V.yc.e!=a.V.yc.f||a.V.yc.K!=a.V.yc.L){y.shiftKey?u2(a.Q,!1):vd(a.Q,!1);break}}n0(a),!Qu(a.V)&&!a.B&&!a.e&&!a.o&&(a.b=mv(a.V),Mw(a.u),a.t=!1,a.B=!0,ad(a.V,!0,(z=Gt(a.u.j),z??"")),a.u.u=!0,Bh(a.u))}else et(a.v,he(a.V.rc),0)!=-1||et(a.w,he(a.V.sc),0)!=-1||(n0(a),!Qu(a.V)&&!a.B&&!a.e&&!a.o&&(a.B=!0,a.b=mv(a.V),Bh(a.u),Dh(a.b,"%")||iD(a.V)?(E=new Si,Te(E.a,"0",E),Te(E.a,"1",E),Te(E.a,"2",E),Te(E.a,"3",E),Te(E.a,"4",E),Te(E.a,"5",E),Te(E.a,"6",E),Te(E.a,"7",E),Te(E.a,"8",E),Te(E.a,"9",E),Te(E.a,"-",E),Te(E.a,"+",E),bn(E.a,k)&&(k=k+"%"),ad(a.V,!0,k)):(ad(a.V,!0,k),Mw(a.u)),ch(a.u,k)))}function md(a,y,k,z,E){var j,te,ne,ie,se,ce,le,de;if(y==k&&z==E)return ne=Ir(a.d,z,y),ne||(ne=new vs,ne.col1=z,ne.col2=E,ne.row1=y,ne.row2=k),ne;if(te=ql(a.d,z,y),te&&te.col2>=E&&te.row2>=k)return te;if(ce=a.c.rc,le=a.c.sc,ce<z||ce>E||le<y||le>k)return Ir(a.d,ce,a.c.sc);for(de=!1,j=z;j<=E;)if(ie=Ir(a.d,j,y),ie){if(j=ie.col2+1,y>ie.row1)if(de=!0,y<k)ie.row2>k?y=ie.row2+1:y=k,j=z;else if(ce<ie.col1)E=ie.col1-1;else if(ce>ie.col2)z=ie.col2+1;else{z=ie.col1,E=ie.col2;break}}else++j;for(y>k&&(y=k),j=y;j<=k;)if(ie=Ir(a.d,E,j),ie){if(j=ie.row2+1,E<ie.col2)if(de=!0,E>z)ie.col1>z?E=ie.col1-1:E=z,j=y;else if(le<ie.row1)k=ie.row1-1;else if(le>ie.row2)y=ie.row2+1;else{y=ie.row1,k=ie.row2;break}}else++j;for(E<z&&(E=z),j=z;j<=E;)if(ie=Ir(a.d,j,k),ie){if(j=ie.col2+1,k<ie.row2)if(de=!0,k>y)y<ie.row1?k=ie.row1-1:k=y,j=z;else if(ce<ie.col1)E=ie.col1-1;else if(ce>ie.col2)z=ie.col2+1;else{E=ie.col1,z=ie.col2;break}}else++j;for(k<y&&(k=y),j=y;j<=k;)if(ie=Ir(a.d,z,j),ie){if(j=ie.row2+1,z>ie.col1)if(de=!0,z<E)E>ie.col2?z=ie.col2+1:z=E,j=y;else if(le<ie.row1)k=ie.row1-1;else if(le>ie.row2)y=ie.row2+1;else{y=ie.row1,k=ie.row2;break}}else++j;return z>E&&(z=E),de?md(a,y,k,z,E):y==k&&z==E?(ne=Ir(a.d,z,y),ne||(ne=new vs,ne.col1=z,ne.col2=E,ne.row1=y,ne.row2=k),ne):(te=ql(a.d,z,y),te&&te.col2>=E&&te.row2>=k?te:(se=new vs,se.col1=z,se.col2=E,se.row1=y,se.row2=k,se))}function q0(a,y){var k,z,E,j,te,ne,ie,se,ce,le,de,pe,me,je,wt,jt,Wt,$t,De,Qt,sn,Tn,ir,rr,mr,Ur;RV(a),rr=a.Lc+((a.zc.scrollTop||0)|0),ir=dn(a.zc),Ur=rr-a.Pb,ce=ir-a.Ob;try{if(a.zb>a.a.O)for(a.zb=a.a.O;a.zb-a.db+1<a.kc.a.length;){for(sn=Or(a.kc,a.kc.a.length-1),j=new Fe(sn);j.a<j.c.a.length;)E=He(j),lt(E.d);lt(Or(a.ic,a.ic.a.length-1))}if(a.xb>a.a.i){for(a.xb=a.a.i,Tn=new Fe(a.kc);Tn.a<Tn.c.a.length;)for(sn=He(Tn);a.xb-a.bb+1<sn.a.length;)lt(Or(sn,sn.a.length-1).d);for(;a.xb-a.bb+1<a.K.a.length;)lt(Or(a.K,a.K.a.length-1))}for(wt=1,de=1;de<a.db;de++)wt+=Cn(a.a,de)?0:de>=a.W.length?$i(a):a.W[de-1],de==a.Sc&&(a.Lc=wt);for(Wt=wt,pe=a.db;pe<=a.zb;pe++)Wt+=Cn(a.a,pe)?0:pe>=a.W.length?$i(a):a.W[pe-1];for(k=a.Lc+rr+a.oc+a.a.L,mr=wt-a.eb,z=Wt-a.Ab,a.eb=wt,a.Ab=Wt,je=0,me=1;me<a.bb;me++)je+=Ft(a.a,me),a.ob==me&&(a.Bb=je);for(jt=je,le=a.bb;le<=a.xb;le++)jt+=Ft(a.a,le);for(De=a.Bb+ir+a.pc+a.a.j,Qt=jt-a.yb,a.cb=je,a.yb=jt,hV(a,ir),wd(a,0,-1),(Qt<0||ce>0||a.xb<a.a.i&&a.yb<De)&&(tV(a,ir),wd(a,0,1)),(mr>0||Ur<0)&&(lV(a,rr),wd(a,-1,0)),(z!=0||Ur>0||a.zb<a.a.O&&a.Ab<k)&&(JT(a,rr),wd(a,1,0)),d0(a),a.Ob=ir,a.Pb=rr,y&&Vs(a.Rb),ne=($t=new di(a.b).a.Wf().Ke(),new yr($t));ne.a.Ue();)te=(se=ne.a.Ve(),se.dg()),Vo(a.a,te.b)||Cn(a.a,te.d)?(Pn(te,!1),lt(te.i)):pd(te);kf(a),Ei(a,a.yc.e,a.yc.f,a.yc.K,a.yc.L),E0(a),z0(a),sl(a,!0)}catch(hi){if(hi=Xt(hi),ze(hi,21))ie=hi,Tr(a.U,"SheetWidget:relayoutSheet: "+Yu(ie,ie.Gd())+" while relayouting spreadsheet"),GV(a,ir,rr),d0(a),Hw(a.a,a.db,a.zb,a.bb,a.xb),X0(a),W0(a),E0(a),z0(a),PV(a),T0(a),C9(a);else throw we(hi)}}function lz(a,y){var k,z,E,j,te,ne,ie,se,ce,le,de,pe,me;if(me=a.c.yc.K,ne=me,j=a.c.yc.e,z=a.c.yc.L,te=z,se=a.c.yc.f,de=a.c.sc,le=a.c.rc,ie=ql(a.d,le,de),k=!1,a.c.C){if(ie&&(y&&ie.row1!=me||!y&&ie.row2==z)&&(de=ie.row2),pe=null,de==me){if(y&&z+1<=a.d.O){for(++z;a.d.w&&et(a.d.w,he(z),0)!=-1&&z<a.d.O;)++z;pe=ti(a.d.I,me,z,j,se)}else if(!y){if(me!=z){for(--z;a.d.w&&et(a.d.w,he(z),0)!=-1&&z>me;)--z;pe=md(a,me,z,j,se)}else if(me-1>0){for(k=!0,--me;a.d.w&&et(a.d.w,he(me),0)!=-1&&me>1;)--me;pe=ti(a.d.I,me,z,j,se)}}}else if(de==z){if(y){if(me!=z){for(k=!0,++me;a.d.w&&et(a.d.w,he(me),0)!=-1&&me<z;)++me;pe=md(a,me,z,j,se)}else if(z+1<=a.d.O){for(++z;a.d.w&&et(a.d.w,he(z),0)!=-1&&z<a.d.O;)++z;pe=ti(a.d.I,me,z,j,se)}}else if(!y&&me-1>0){for(k=!0,--me;a.d.w&&et(a.d.w,he(me),0)!=-1&&me>1;)--me;pe=ti(a.d.I,me,z,j,se)}}else if(y){if(z+1<=a.d.O){for(++z;a.d.w&&et(a.d.w,he(z),0)!=-1&&z<a.d.O;)++z;pe=ti(a.d.I,me,z,j,se)}}else if(k=!0,me-1>0){for(--me;a.d.w&&et(a.d.w,he(me),0)!=-1&&me>1;)--me;pe=ti(a.d.I,me,z,j,se)}if(!pe)return;Ei(a.c,pe.col1,pe.col2,pe.row1,pe.row2),BT(a.c,pe.col1,pe.col2,pe.row1,pe.row2),NA(a.c,pe.row1,pe.row2,pe.col1,pe.col2),nz(a.c,pe.row1,pe.row2,k)}else{if(ie?(ce=ie.row2,E=ie.col2):(ce=de,E=le),y)for(++ce;a.d.w&&et(a.d.w,he(ce),0)!=-1&&ce<a.d.O;)++ce;else for(--de;a.d.w&&et(a.d.w,he(de),0)!=-1&&de>1;)--de;de>0&&ce<=a.d.O&&(pe=ti(a.d.I,de,ce,le,E),pe&&(a.c.C=!0,go(a.c,!0),is(a.c),Ei(a.c,pe.col1,pe.col2,pe.row1,pe.row2),Fn(a.c,pe.col1,pe.col2,pe.row1,pe.row2,!0))),z8(a.c)}(j!=a.c.yc.e||se!=a.c.yc.f||ne!=a.c.yc.K||te!=a.c.yc.L)&&(Hh(a.d.W,a.c.yc.K,a.c.yc.e,a.c.yc.L,a.c.yc.f),gn(a.d.s,200))}function fz(a,y){var k,z,E,j,te,ne,ie,se,ce,le,de,pe,me;if(me=a.c.yc.K,j=a.c.yc.e,te=j,se=a.c.yc.f,ne=se,z=a.c.yc.L,le=a.c.rc,de=a.c.sc,ie=ed(a.d.I,le,de),k=!1,a.c.C){if(ie&&(y&&ie.col1!=j||!y&&ie.col2==se)&&(le=ie.col2),pe=null,le==j){if(y&&se+1<=a.d.i){for(++se;a.d.v&&et(a.d.v,he(se),0)!=-1&&se<a.d.i;)++se;pe=ti(a.d.I,me,z,j,se)}else if(!y){if(se!=j){for(--se;a.d.v&&et(a.d.v,he(se),0)!=-1&&se>j;)--se;pe=md(a,me,z,j,se)}else if(j-1>0){for(k=!0,--j;a.d.v&&et(a.d.v,he(j),0)!=-1&&j>1;)--j;pe=ti(a.d.I,me,z,j,se)}}}else if(le==se){if(y){if(se!=j){for(k=!0,++j;a.d.v&&et(a.d.v,he(j),0)!=-1&&j<se;)++j;pe=md(a,me,z,j,se)}else if(se+1<=a.d.i){for(++se;a.d.v&&et(a.d.v,he(se),0)!=-1&&se<a.d.i;)++se;pe=ti(a.d.I,me,z,j,se)}}else if(!y&&j-1>0){for(k=!0,--j;a.d.v&&et(a.d.v,he(j),0)!=-1&&j>1;)--j;pe=ti(a.d.I,me,z,j,se)}}else if(y){if(se+1<=a.d.i){for(++se;a.d.v&&et(a.d.v,he(se),0)!=-1&&se<a.d.i;)++se;pe=ti(a.d.I,me,z,j,se)}}else if(k=!0,j-1>0){for(--j;a.d.v&&et(a.d.v,he(j),0)!=-1&&j>1;)--j;pe=ti(a.d.I,me,z,j,se)}if(!pe)return;Ei(a.c,pe.col1,pe.col2,pe.row1,pe.row2),BT(a.c,pe.col1,pe.col2,pe.row1,pe.row2),NA(a.c,pe.row1,pe.row2,pe.col1,pe.col2),$V(a.c,pe.col1,pe.col2,k)}else{if(ie?(ce=ie.row2,E=ie.col2):(ce=de,E=le),y)for(++E;a.d.v&&et(a.d.v,he(E),0)!=-1&&E<a.d.i;)++E;else for(--le;a.d.v&&et(a.d.v,he(le),0)!=-1&&le>1;)--le;le>0&&E<a.d.i&&(pe=ti(a.d.I,de,ce,le,E),pe&&(a.c.C=!0,go(a.c,!0),is(a.c),Ei(a.c,pe.col1,pe.col2,pe.row1,pe.row2),Fn(a.c,pe.col1,pe.col2,pe.row1,pe.row2,!0))),z8(a.c)}(te!=a.c.yc.e||ne!=a.c.yc.f||me!=a.c.yc.K||z!=a.c.yc.L)&&(Hh(a.d.W,a.c.yc.K,a.c.yc.e,a.c.yc.L,a.c.yc.f),gn(a.d.s,200))}function m2(a,y){var k,z,E,j,te,ne,ie,se,ce,le,de;if(se=Kr(y),k=(be(),se).getAttribute(Gi)||"",a.o&&k.indexOf("comment-overlay")==-1&&(a.o=!1,r2(a.Q,!1),dr(a.Q,a.q)&&(Pl(a.q),a.j=null,a.k=-1,a.n=-1)),!(k.indexOf(yl)!=-1||ye(se.tagName,"input")||ye(k,"floater"))){if(VF(a,y))Ie.Qd(y)==2?xv(a.a,y,a.rc,a.sc):a.xc&&RT(a,y);else if(k.indexOf(rp)!=-1){ye(k,Kd)||ye(k,Ld)?Mr(a.wb,eo(qt(se))):Mr(a.wb,k),le=a.wb.a,de=a.wb.b;try{ie=gs.length,ye(k.substr(k.length-ie,ie),gs)||(z=(te=ko(ue),xn(),y.type.indexOf(Gn)!=-1?As(y.changedTouches[0])+te:Dt(y.clientX||0)+te),E=(ne=So(ue),y.type.indexOf(Gn)!=-1?Ts(y.changedTouches[0])+ne:Dt(y.clientY||0)+ne),ce=K0(a,z,E,Rt(a,le,de)),se=ce.d,le=ce.c,de=ce.k)}catch(pe){if(pe=Xt(pe),ze(pe,81))Tr(a.U,"SheetWidget:onSheetMouseDown - JSE while trying to find real event target, className:"+k);else if(ze(pe,33))Tr(a.U,"SheetWidget:onSheetMouseDown - IOOBE while trying to find real event target, className:"+k);else throw we(pe)}y.stopPropagation(),Ie.Vd(y),Ie.Qd(y)==2?(tf(a.zc),xv(a.a,y,le,de)):(a.zc.focus(),a._&&!Io(Re(a.sb),se)&&fA(a.a,(j=Gt(a.sb),j??"")),y.ctrlKey||y.metaKey||y.shiftKey?(B0(a.a,le,de,(Ie._d(se),!!y.shiftKey),!!y.metaKey||!!y.ctrlKey,!0),a.Jc=-1,a.Kc=-1):a.s&&bn(a.s,qe+a.wb.a+Ye+a.wb.b)?DM(a.a,le,de):(B0(a.a,le,de,(Ie._d(se),!!y.shiftKey),!!y.metaKey||!!y.ctrlKey,!1),a.xc=!0,a.Jc=le,a.Kc=de,a.Hc=le<=a.ob&&de<=a.Sc,a.Ic=le>a.ob&&le<=a.xb&&de<=a.Sc,a.Gc=de>a.Sc&&de<=a.zb&&le<=a.ob,a.O=!a.Hc&&!a.Ic,a.P=!a.Hc&&!a.Gc,a.A=(te=ko(ue),xn(),y.type.indexOf(Gn)!=-1?As(y.changedTouches[0])+te:Dt(y.clientX||0)+te),a.B=(ne=So(ue),y.type.indexOf(Gn)!=-1?Ts(y.changedTouches[0])+ne:Dt(y.clientY||0)+ne),dh(a.zc)))}}}function y2(a,y,k,z,E,j,te,ne,ie){var se,ce,le,de,pe,me,je,wt,jt,Wt,$t,De,Qt,sn,Tn;for(me=Ze((pn(0,ne.a.length),ne.a[0]),0).k,Wt=Ze(Ze(ne,ne.a.length-1),0).k,pe=Ze((pn(0,ne.a.length),ne.a[0]),0).c,jt=Ze((pn(0,ne.a.length),ne.a[0]),(pn(0,ne.a.length),ne.a[0]).a.length-1).c,Tn=new st,wt=new Fe(ne);wt.a<wt.c.a.length;){if(De=He(wt),$t=(pn(0,De.a.length),De.a[0]).k,y>0){if($t<z)if(Wt<E)$t=++Wt,Es(wt),Tn.a[Tn.a.length]=De;else{for(le=new Fe(De);le.a<le.c.a.length;)ce=He(le),lt(ce.d);Es(wt);continue}}else if(y<0&&$t>E)if(me>z)$t=--me,Es(wt),Tn.a[Tn.a.length]=De;else{for(le=new Fe(De);le.a<le.c.a.length;)ce=He(le),lt(ce.d);Es(wt);continue}for(pe=(pn(0,De.a.length),De.a[0]).c,jt=Ze(De,De.a.length-1).c,sn=new st,de=new Fe(De);de.a<de.c.a.length;){if(ce=He(de),se=ce.c,k>0){if(se<j)if(jt<te)se=++jt,Es(de),sn.a[sn.a.length]=ce;else{lt(ce.d),Es(de);continue}}else if(k<0&&se>te)if(pe>j)se=--pe,Es(de),sn.a[sn.a.length]=ce;else{lt(ce.d),Es(de);continue}(se!=ce.c||$t!=ce.k)&&K9(ce,se,$t,Nt(a.e,qe+se+Ye+$t))}if(k>0){for(le=new Fe(sn);le.a<le.c.a.length;)ce=He(le),De.a[De.a.length]=ce;for(;jt<te;)++jt,ce=new mf(a,jt,$t,Nt(a.e,qe+jt+Ye+$t)),xe(ie,ce.d),De.a[De.a.length]=ce}else if(k<0){for(le=new Fe(sn);le.a<le.c.a.length;)ce=He(le),jo(0,De.a.length),Nu(De.a,0,ce);for(;pe>j;)--pe,ce=new mf(a,pe,$t,Nt(a.e,qe+pe+Ye+$t)),xe(ie,ce.d),jo(0,De.a.length),Nu(De.a,0,ce)}}if(y>0)for(Qt=new Fe(Tn);Qt.a<Qt.c.a.length;)De=He(Qt),ne.a[ne.a.length]=De;else for(Qt=new Fe(Tn);Qt.a<Qt.c.a.length;)De=He(Qt),jo(0,ne.a.length),Nu(ne.a,0,De);if(y>0)for(;Wt<E;){for(De=new Sv(te-j+1),++Wt,je=j;je<=te;je++)ce=new mf(a,je,Wt,Nt(a.e,qe+je+Ye+Wt)),De.a[De.a.length]=ce,xe(ie,ce.d);ne.a[ne.a.length]=De}else if(y<0)for(;me>z;){for(De=new st,--me,je=j;je<=te;je++)ce=new mf(a,je,me,Nt(a.e,qe+je+Ye+me)),De.a[De.a.length]=ce,xe(ie,ce.d);jo(0,ne.a.length),Nu(ne.a,0,De)}sl(a,!1)}function yd(){yd=ge,iO=new GC,nO=new j6,rO=new QC,oO=new gS,sO=new U6,cO=new JC,uO=new $S,lO=new YC,fO=new US,hO=new ZC,dO=new ek,aO=new tk,bO=new Y6,pO=new C7,gO=new GS,wO=new t6,mO=new QS,vO=new n6,yO=new O6,xO=new mS,CO=new Xk,kO=new nk,IO=new hS,AO=new t7,SO=new s6,TO=new Wk,VO=new i6,zO=new wS,EO=new r6,tx=new vS,OO=new ik,XO=new rk,nx=new n7,jO=new o6,WO=new ok,KO=new c6,LO=new sk,MO=new ck,NO=new uk,PO=new lk,RO=new X6,_O=new Z6,DO=new e7,qO=new S7,BO=new Kk,FO=new I7,HO=new Q6,$O=new k7,UO=new G6,GO=new fk,QO=new J6,YO=new pS,ZO=new JS,JO=new Lk,eX=new dS,tX=new W6,nX=new aS,iX=new bS,oX=new ZS,sX=new YS,rX=new u6,Ge=new Ot,Te(Ge,"region",_O),Te(Ge,"alert",nO),Te(Ge,"dialog",bO),Te(Ge,vz,iO),Te(Ge,mz,rO),Te(Ge,"document",gO),Te(Ge,"article",oO),Te(Ge,"banner",sO),Te(Ge,G0,cO),Te(Ge,"checkbox",uO),Te(Ge,"gridcell",mO),Te(Ge,yz,lO),Te(Ge,"group",yO),Te(Ge,"combobox",fO),Te(Ge,xz,hO),Te(Ge,Cz,dO),Te(Ge,kz,aO),Te(Ge,"list",SO),Te(Ge,"directory",pO),Te(Ge,"form",wO),Te(Ge,"grid",vO),Te(Ge,"heading",xO),Te(Ge,"img",CO),Te(Ge,Id,kO),Te(Ge,"listbox",IO),Te(Ge,"listitem",AO),Te(Ge,"log",TO),Te(Ge,"main",VO),Te(Ge,"marquee",zO),Te(Ge,"math",EO),Te(Ge,"menu",jO),Te(Ge,"menubar",tx),Te(Ge,"menuitem",nx),Te(Ge,Sz,OO),Te(Ge,z2,LO),Te(Ge,"radio",RO),Te(Ge,Iz,XO),Te(Ge,Az,WO),Te(Ge,"note",KO),Te(Ge,Tz,MO),Te(Ge,Vz,NO),Te(Ge,zz,PO),Te(Ge,"row",BO),Te(Ge,"rowgroup",DO),Te(Ge,"rowheader",qO),Te(Ge,"search",HO),Te(Ge,"separator",$O),Te(Ge,"scrollbar",FO),Te(Ge,"slider",UO),Te(Ge,Ez,GO),Te(Ge,"status",QO),Te(Ge,"tab",JO),Te(Ge,"tablist",YO),Te(Ge,"tabpanel",ZO),Te(Ge,"textbox",eX),Te(Ge,"timer",tX),Te(Ge,"toolbar",nX),Te(Ge,"tooltip",iX),Te(Ge,"tree",rX),Te(Ge,"treegrid",oX),Te(Ge,"treeitem",sX)}function hz(a){var y,k,z;a=OA(a,(_c(),Wp)),this.i=a.indexOf("gecko")!=-1&&a.indexOf(hp)==-1&&a.indexOf(Ny)==-1,a.indexOf(" presto/")!=-1,this.r=a.indexOf(Ny)!=-1,this.s=!this.r&&a.indexOf("applewebkit")!=-1,this.e=a.indexOf(" chrome/")!=-1||a.indexOf(" crios/")!=-1,this.o=a.indexOf("opera")!=-1,this.j=a.indexOf("msie")!=-1&&!this.o&&a.indexOf("webtv")==-1,this.j=this.j||this.r,this.p=a.indexOf("phantomjs/")!=-1,this.g=a.indexOf(" firefox/")!=-1||a.indexOf("fxios/")!=-1,this.q=!this.e&&!this.j&&!this.p&&!this.g&&a.indexOf("safari")!=-1,a.indexOf(" edge/")!=-1&&(this.f=!0,this.e=!1,this.o=!1,this.j=!1,this.q=!1,this.g=!1,this.s=!1,this.i=!1,this.p=!1),a.indexOf("chromeframe")!=-1;try{this.i?(k=a.indexOf("rv:"),k>=0&&(z=a.substr(k+3),z=qh(z,"(\\.[0-9]+).+","$1"),this.a=cm(z))):this.s?(z=Zs(a,a.indexOf("webkit/")+7),z=qh(z,"([0-9]+)[^0-9].+","$1"),this.a=cm(z)):this.r?(z=Zs(a,a.indexOf(Ny)+8),z=qh(z,"([0-9]+\\.[0-9]+).*","$1"),this.a=cm(z),this.a>7&&(this.a=7)):this.f&&(this.a=0)}catch(E){if(E=Xt(E),ze(E,21))Uc();else throw we(E)}try{this.j?a.indexOf("msie")==-1?(k=a.indexOf("rv:"),k>=0&&(y=k+3,this.d=mu(a,y),gu(this,this.d))):this.r?v8(this,bt(this.a)+4):(y=a.indexOf("msie ")+5,this.d=mu(a,y),gu(this,this.d)):this.g?(y=a.indexOf(" firefox/"),y!=-1?y+=9:y=a.indexOf(" fxios/")+7,this.d=mu(a,y),gu(this,this.d)):this.e?(y=a.indexOf(" chrome/"),y!=-1?y+=8:y=a.indexOf(" crios/")+7,this.d=mu(a,y),gu(this,this.d)):this.q?(y=a.indexOf(" version/")+9,this.d=mu(a,y),gu(this,this.d)):this.o?(y=a.indexOf(" version/"),y!=-1?y+=9:y=a.indexOf("opera/")+6,this.d=mu(a,y),gu(this,this.d)):this.f?(y=a.indexOf(" edge/")+6,this.d=mu(a,y),gu(this,this.d)):this.p&&(y=a.indexOf(" phantomjs/")+11,this.d=mu(a,y),gu(this,this.d))}catch(E){if(E=Xt(E),ze(E,21))Uc();else throw we(E)}a.indexOf("windows ")!=-1?(this.t=1,a.indexOf("windows phone")!=-1):a.indexOf("android")!=-1?(this.t=5,BH(this,a)):a.indexOf("linux")!=-1?this.t=3:a.indexOf("macintosh")!=-1||a.indexOf("mac osx")!=-1||a.indexOf("mac os x")!=-1?(this.k=a.indexOf("ipad")!=-1,this.n=a.indexOf("iphone")!=-1,this.k||a.indexOf("ipod")!=-1||this.n?(this.t=4,YH(this,a)):this.t=2):a.indexOf("; cros ")!=-1&&(this.t=6,rU(this,a))}function fQ(a){Er(a.b,Ke,null),Er(a.b,Il,Ke),Er(a.b,Ou,Ke),Er(a.b,Us,Ke),Er(a.b,yn,Ke),Er(a.b,o1,Ke),Er(a.b,Gs,Ke),Er(a.b,Bo,Ke),Er(a.b,nr,Ke),Er(a.b,Hr,Ke),Er(a.b,In,Ou),Er(a.b,_W,In),Er(a.b,Jt,_W),TM(a.b,Qn),zo(a.b,MW,new X4),zo(a.b,Qn,new $4),zo(a.b,Il,new e3),zo(a.b,Jt,new t3),zo(a.b,Us,new n3),zo(a.b,yn,new i3),zo(a.b,o1,new r3),zo(a.b,Gs,new o3),zo(a.b,Bo,new s3),zo(a.b,nr,new K4),zo(a.b,Hr,new L4),Z8(a.b,Qn,"getWidget",new Ee(MW)),Z8(a.b,Qn,"getState",new Ee(Jt)),jh(a.b,ju,RE,new M4),jh(a.b,ju,PE,new N4),jh(a.b,Qn,_E,new R4),jh(a.b,Qn,BE,new P4),jh(a.b,Qn,DE,new _4),kM(a.b),$e(a.b,Bo,qE,new Ee(Hs)),$e(a.b,yn,"am",new Ee(ct)),$e(a.b,In,py,new Ee(ct)),$e(a.b,In,gy,new Ee(Hs)),$e(a.b,Hr,FE,new Ee(Yi)),$e(a.b,yn,HE,new Ee(ct)),$e(a.b,yn,"dayNames",new Ee(Ce(ct,1))),$e(a.b,In,wy,new Ee(ct)),$e(a.b,In,vy,new Ee(Tx)),$e(a.b,nr,$E,new Ee(Yi)),$e(a.b,nr,UE,new Ee(Hs)),$e(a.b,nr,GE,new Ee(ct)),$e(a.b,nr,QE,new Ee(ct)),$e(a.b,Jt,JE,new Ee(Hs)),$e(a.b,Ou,my,new Ee(Hs)),$e(a.b,In,yy,new Ee(Op)),$e(a.b,In,ap,new Ee(ct)),$e(a.b,yn,YE,new Ee(Yi)),$e(a.b,Us,ZE,new Ee(Yi)),$e(a.b,Il,ej,new Ee(Hs)),$e(a.b,In,Bt,new Ee(ct)),$e(a.b,yn,tj,new Ee(ct)),$e(a.b,In,"id",new Ee(ct)),$e(a.b,Jt,xy,new Ee($W)),$e(a.b,Jt,Cy,new Ee(Us)),$e(a.b,o1,nj,new Wc(ij,Se(Ce(nh,1),ve,5,0,[new Ee(yn)]))),$e(a.b,Jt,rj,new Ee(o1)),$e(a.b,Hr,"maxWidth",new Ee(Yi)),$e(a.b,Bo,"mode",new Ee(Ix)),$e(a.b,yn,oj,new Ee(Ce(ct,1))),$e(a.b,yn,"name",new Ee(ct)),$e(a.b,Jt,sj,new Wc(ky,Se(Ce(nh,1),ve,5,0,[new Ee(ct),new Ee(Gs)]))),$e(a.b,Gs,cj,new Ee(Xx)),$e(a.b,Hr,"openDelay",new Ee(Yi)),$e(a.b,Jt,Sy,new Ee(ct)),$e(a.b,Jt,"pageState",new Ee(Il)),$e(a.b,Bo,uj,new Wc(ky,Se(Ce(nh,1),ve,5,0,[new Ee(ct),new Ee(ct)]))),$e(a.b,yn,"pm",new Ee(ct)),$e(a.b,Jt,Iy,new Ee(Yi)),$e(a.b,Gs,"postfix",new Ee(ct)),$e(a.b,Gs,"prefix",new Ee(ct)),$e(a.b,In,Ay,new Ee(ct)),$e(a.b,Jt,Ty,new Ee(Bo)),$e(a.b,Bo,"pushUrl",new Ee(ct)),$e(a.b,Hr,lj,new Ee(Yi)),$e(a.b,Hr,fj,new Ee(Yi)),$e(a.b,nr,hj,new Ee(Yi)),$e(a.b,Jt,Vy,new Ee(nr)),$e(a.b,nr,dj,new Ee(Yi)),$e(a.b,Ou,zy,new Wc("java.util.Set",Se(Ce(nh,1),ve,5,0,[new Ee(ct)]))),$e(a.b,Ou,"resources",new Wc(ky,Se(Ce(nh,1),ve,5,0,[new Ee(ct),new Ee(cK)]))),$e(a.b,Us,aj,new Ee(Yi)),$e(a.b,yn,bj,new Ee(Ce(ct,1))),$e(a.b,yn,pj,new Ee(Ce(ct,1))),$e(a.b,In,Ey,new Wc(ij,Se(Ce(nh,1),ve,5,0,[new Ee(ct)]))),$e(a.b,Jt,jy,new Ee(Yi)),$e(a.b,Jt,"theme",new Ee(ct)),$e(a.b,Us,gj,new Ee(Yi)),$e(a.b,Jt,Oy,new Ee(Hs)),$e(a.b,Il,"title",new Ee(ct)),$e(a.b,Jt,Xy,new Ee(Hr)),$e(a.b,yn,wj,new Ee(Hs)),$e(a.b,In,mt,new Ee(ct)),Ul(a.b,Ix,new B4),Ul(a.b,cK,new q4),Ul(a.b,Tx,new F4),Ul(a.b,Op,new U4),Ul(a.b,Xx,new Q4),Ul(a.b,Ce(ct,1),new Y4),sd(a.b,Qn,new Ca(ju,RE,Se(Ce(ct,1),Mi,2,6,[ap,yy]))),sd(a.b,Qn,new Ca(ju,PE,Se(Ce(ct,1),Mi,2,6,[zy]))),sd(a.b,Qn,new Q1(_E,Se(Ce(ct,1),Mi,2,6,["theme"]))),sd(a.b,Qn,new Q1(BE,Se(Ce(ct,1),Mi,2,6,[Oy]))),sd(a.b,Qn,new Q1(DE,Se(Ce(ct,1),Mi,2,6,[xy])))}function hQ(a){var y={setter:function(k,z){k.a=Sc(z)},getter:function(k){return Xc(k.a)}};a.Gf(Bo,qE,y);var y={setter:function(k,z){k.a=z},getter:function(k){return k.a}};a.Gf(yn,"am",y);var y={setter:function(k,z){k.db=z},getter:function(k){return k.db}};a.Gf(In,py,y);var y={setter:function(k,z){k.eb=Sc(z)},getter:function(k){return Xc(k.eb)}};a.Gf(In,gy,y);var y={setter:function(k,z){k.a=z.Tf()},getter:function(k){return he(k.a)}};a.Gf(Hr,FE,y);var y={setter:function(k,z){k.b=z},getter:function(k){return k.b}};a.Gf(yn,HE,y);var y={setter:function(k,z){k.c=z},getter:function(k){return k.c}};a.Gf(yn,"dayNames",y);var y={noLayout:1,setter:function(k,z){k.fb=z},getter:function(k){return k.fb}};a.Gf(In,wy,y);var y={noLayout:1,setter:function(k,z){k.gb=z},getter:function(k){return k.gb}};a.Gf(In,vy,y);var y={setter:function(k,z){k.a=z.Tf()},getter:function(k){return he(k.a)}};a.Gf(nr,$E,y);var y={setter:function(k,z){k.b=Sc(z)},getter:function(k){return Xc(k.b)}};a.Gf(nr,UE,y);var y={setter:function(k,z){k.c=z},getter:function(k){return k.c}};a.Gf(nr,GE,y);var y={setter:function(k,z){k.d=z},getter:function(k){return k.d}};a.Gf(nr,QE,y);var y={setter:function(k,z){k.a=Sc(z)},getter:function(k){return Xc(k.a)}};a.Gf(Jt,JE,y);var y={setter:function(k,z){k.ob=Sc(z)},getter:function(k){return Xc(k.ob)}};a.Gf(Ou,my,y);var y={setter:function(k,z){k.hb=z},getter:function(k){return k.hb}};a.Gf(In,yy,y);var y={setter:function(k,z){k.ib=z},getter:function(k){return k.ib}};a.Gf(In,ap,y);var y={setter:function(k,z){k.d=z.Tf()},getter:function(k){return he(k.d)}};a.Gf(yn,YE,y);var y={setter:function(k,z){k.a=z.Tf()},getter:function(k){return he(k.a)}};a.Gf(Us,ZE,y);var y={setter:function(k,z){k.a=Sc(z)},getter:function(k){return Xc(k.a)}};a.Gf(Il,ej,y);var y={setter:function(k,z){k.jb=z},getter:function(k){return k.jb}};a.Gf(In,Bt,y);var y={setter:function(k,z){k.e=z},getter:function(k){return k.e}};a.Gf(yn,tj,y);var y={setter:function(k,z){k.kb=z},getter:function(k){return k.kb}};a.Gf(In,"id",y);var y={setter:function(k,z){k.b=z.Uf()},getter:function(k){return bH(k.b)}};a.Gf(Jt,xy,y);var y={setter:function(k,z){k.c=z},getter:function(k){return k.c}};a.Gf(Jt,Cy,y);var y={setter:function(k,z){k.a=z},getter:function(k){return k.a}};a.Gf(o1,nj,y);var y={setter:function(k,z){k.d=z},getter:function(k){return k.d}};a.Gf(Jt,rj,y);var y={setter:function(k,z){k.b=z.Tf()},getter:function(k){return he(k.b)}};a.Gf(Hr,"maxWidth",y);var y={setter:function(k,z){k.b=z},getter:function(k){return k.b}};a.Gf(Bo,"mode",y);var y={setter:function(k,z){k.f=z},getter:function(k){return k.f}};a.Gf(yn,oj,y);var y={setter:function(k,z){k.g=z},getter:function(k){return k.g}};a.Gf(yn,"name",y);var y={setter:function(k,z){k.e=z},getter:function(k){return k.e}};a.Gf(Jt,sj,y);var y={setter:function(k,z){k.a=z},getter:function(k){return k.a}};a.Gf(Gs,cj,y);var y={setter:function(k,z){k.c=z.Tf()},getter:function(k){return he(k.c)}};a.Gf(Hr,"openDelay",y);var y={setter:function(k,z){k.f=z},getter:function(k){return k.f}};a.Gf(Jt,Sy,y);var y={setter:function(k,z){k.g=z},getter:function(k){return k.g}};a.Gf(Jt,"pageState",y);var y={setter:function(k,z){k.c=z},getter:function(k){return k.c}};a.Gf(Bo,uj,y);var y={setter:function(k,z){k.i=z},getter:function(k){return k.i}};a.Gf(yn,"pm",y);var y={setter:function(k,z){k.i=z.Tf()},getter:function(k){return he(k.i)}};a.Gf(Jt,Iy,y);var y={setter:function(k,z){k.b=z},getter:function(k){return k.b}};a.Gf(Gs,"postfix",y);var y={setter:function(k,z){k.c=z},getter:function(k){return k.c}};a.Gf(Gs,"prefix",y);var y={setter:function(k,z){k.lb=z},getter:function(k){return k.lb}};a.Gf(In,Ay,y);var y={setter:function(k,z){k.j=z},getter:function(k){return k.j}};a.Gf(Jt,Ty,y);var y={setter:function(k,z){k.d=z},getter:function(k){return k.d}};a.Gf(Bo,"pushUrl",y);var y={setter:function(k,z){k.d=z.Tf()},getter:function(k){return he(k.d)}};a.Gf(Hr,lj,y);var y={setter:function(k,z){k.e=z.Tf()},getter:function(k){return he(k.e)}};a.Gf(Hr,fj,y);var y={setter:function(k,z){k.e=z.Tf()},getter:function(k){return he(k.e)}};a.Gf(nr,hj,y);var y={setter:function(k,z){k.k=z},getter:function(k){return k.k}};a.Gf(Jt,Vy,y);var y={setter:function(k,z){k.f=z.Tf()},getter:function(k){return he(k.f)}};a.Gf(nr,dj,y);var y={noLayout:1,setter:function(k,z){k.pb=z},getter:function(k){return k.pb}};a.Gf(Ou,zy,y);var y={setter:function(k,z){k.qb=z},getter:function(k){return k.qb}};a.Gf(Ou,"resources",y);var y={setter:function(k,z){k.b=z.Tf()},getter:function(k){return he(k.b)}};a.Gf(Us,aj,y);var y={setter:function(k,z){k.j=z},getter:function(k){return k.j}};a.Gf(yn,bj,y);var y={setter:function(k,z){k.k=z},getter:function(k){return k.k}};a.Gf(yn,pj,y);var y={setter:function(k,z){k.mb=z},getter:function(k){return k.mb}};a.Gf(In,Ey,y);var y={noLayout:1,setter:function(k,z){k.n=z.Tf()},getter:function(k){return he(k.n)}};a.Gf(Jt,jy,y);var y={setter:function(k,z){k.o=z},getter:function(k){return k.o}};a.Gf(Jt,"theme",y);var y={setter:function(k,z){k.c=z.Tf()},getter:function(k){return he(k.c)}};a.Gf(Us,gj,y);var y={setter:function(k,z){k.p=Sc(z)},getter:function(k){return Xc(k.p)}};a.Gf(Jt,Oy,y)}var F0="object",H0="anonymous",x2="fnStack",ve={3:1},C2="Unknown",$0="boolean",Vf="number",xd="string",Ki=2147483647,zf=-17592186044416,Rr=17592186044416,ui=4194304,Li=1048575,dz="__noinit__",Ns={3:1,21:1,24:1,20:1},k2={3:1,21:1,33:1,24:1,20:1},Ef='For input string: "',Ro="null",xu=-2147483648,bl=16384,gr="\\$",Mi={3:1,41:1},jf=65536,Rs=65535,U0={38:1,80:1},Cd={38:1,101:1},kd={100:1},az={3:1,38:1,80:1,180:1},bz={3:1,149:1},pz={3:1,38:1,101:1},gz="fromIndex: 0, toIndex: ",S2=", length: ",I2="Index: ",A2=", Size: ",T2="fromIndex: ",wz=", toIndex: ",ln="java.lang",Sd="com.google.gwt.core.client",Cu="com.google.gwt.core.client.impl",Pe="java.util",$n="java.util.stream",V2=3.141592653589793,Ps="com.google.gwt.animation.client",Of="com.google.gwt.user.client",Be="com.google.gwt.aria.client",vz="alertdialog",mz="application",G0="button",yz="columnheader",xz="complementary",Cz="contentinfo",kz="definition",Id="link",Sz="menuitemcheckbox",Iz="menuitemradio",Az="navigation",z2="option",Tz="presentation",Vz="progressbar",zz="radiogroup",Ez="spinbutton",pl="offsetWidth",tn="none",Bt="height",mt="width",jz="Null widget handle. If you are creating a composite, ensure that initWidget() has been called.",Oz="Style names cannot be empty",E2="aria-hidden",nt="com.google.gwt.user.client.ui",Pr={18:1,14:1,9:1,16:1,19:1,12:1,13:1},j2="disabled",ku={18:1,14:1,9:1,60:1,73:1,16:1,19:1,12:1,13:1},O2="com.google.gwt.canvas.client",Gi="class",Ad={115:1},_s="CSS1Compat",Ne="com.google.gwt.dom.client",Xz="DOMImplStandard",_r=1e3,Wz="DOMImplMozilla",as="position",Q0="fixed",Su="absolute",Kz="DOMImplStandardBase",Lz="DOMImplWebkit",Td="load",Pt="display",ot="visibility",uo="zIndex",Xf={54:1,15:1,3:1,6:1,4:1},X2="HIDDEN",Un={23:1,15:1,3:1,6:1,4:1},vi="block",Vd={15:1,62:1,3:1,6:1,4:1},zd={15:1,63:1,3:1,6:1,4:1},Ed={15:1,64:1,3:1,6:1,4:1},W2={15:1,93:1,3:1,6:1,4:1},bs={34:1,3:1,6:1,4:1},K2={15:1,94:1,3:1,6:1,4:1},ni="visible",dt="hidden",Wf={15:1,55:1,3:1,6:1,4:1},Iu="com.google.web.bindery.event.shared",Kf="com.google.gwt.event.shared",Rn="com.google.gwt.event.dom.client",Mz="contextmenu",L2="mouseup",Nz="TouchEvent",Rz="ontouchstart",Pz="touchstart",J0="com.google.gwt.event.logical.shared",M2={89:1,3:1,21:1,24:1,20:1},_z="UmbrellaException",wn=4194303,Br=524288,jd=1e9,Qi="java.util.logging",Lf="com.google.gwt.logging.client",Bz="com.google.gwt.logging.impl",N2="java.io",R2="com.google.gwt.safehtml.shared",Dz="com.google.gwt.text.shared.testing",gl=32768,P2="DOMMouseScroll",Y0=131072,Bs=1048576,wl=2097152,Au=8388608,_2=16777216,B2=33554432,D2=67108864,Od={114:1},vl="com.google.gwt.user.client.impl",Xd="__gwtLastUnhandledEvent",Dr={18:1,14:1,9:1,16:1,31:1,19:1,12:1,13:1},vn="left",fn="top",q2={18:1,14:1,9:1,16:1,179:1,19:1,12:1,13:1},Et={25:1},qz="bidiwrapped",Z0="selected",Fz="subMenuIcon-selected",Mf="offsetHeight",ke="px",Ni="0.0px",Hb={27:1,182:1},qr="overflow",Hz={18:1,14:1,9:1,16:1,31:1,19:1,134:1,12:1,13:1},$z={665:1,27:1},Nf="value",Wd={65:1,3:1,6:1,4:1},Rf="com.google.gwt.user.client.ui.impl",Uz={145:1,147:1},Tu="auto",Kd="cell-comment-triangle",Ld="cell-invalidformula-triangle",F2="pointerEvents",qe="col",Ye=" row",Ae="com.vaadin.addon.spreadsheet.client",Vu="animate-in",Md="animate-out",ii="marginLeft",ps="marginTop",Pf="com.vaadin.client.widgets",nn="com.vaadin.client.ui",Gz="spreadsheet-overlays",Qz=57.29577951308232,H2="rotate(",$2="webkitTransform",Ri="comment-overlay-separator",Jz="comment-overlay-line",Yz={181:1,27:1},U2={18:1,14:1,9:1,16:1,31:1,19:1,12:1,13:1,96:1},ml="backgroundColor",_f="border",ep="2px solid ",G2="borderRight",Q2="borderBottom",Ds={9:1},J2="textAlign",gs="merged-cell",Bf="com.vaadin.shared",Zz="There is no information about the state for ",eE=". Did you remember to compile the right widgetset?",Nd={27:1,99:1,121:1,3:1},Y2="active",tp="com.vaadin.shared.communication",tE={67:1,75:1,3:1},nE="popupbutton",Gn="touch",zu="fill",iE="bottom-left",Z2="top-left",rE="v-contextmenu",oE="bottom-right",sE="sheet-selection",np="square",ip="fill-touch-square",yl="sheet",rp="cell",op=15759871,cE="sheet-image",uE="paddingLeft",lE="paddingTop",ey="marginRight",fE="selected-tab",sp=".col",cp=".v-spreadsheet.",Ji="cell-range",qs="selected-cell-highlight",Rd="selected-row-header",Pd="selected-column-header",hE=" .sheet .cell.cell-range {",dE=" .sheet .col",aE="display:none;",bE=" .sheet .row",up=".notusedselector",pE="custom-editor-cell",gE=", .v-spreadsheet.",yt={22:1,3:1},wE="Hide column",vE=" > div.ch.col",Df="px;}",mE=" > div.rh.row",lp="resize-line",yE="5555555555",Fs="text/css",ty="ch col",fp='<div class="header-resize-dnd-first" ></div><div class="header-resize-dnd-second" ></div>',ny="rh row",iy="notfocused",xE=" merged-cell",CE=" while creating the cell styles",kE="expandbutton",SE="lineHeight",qf="inactive",IE="row-resizing",AE="col-resizing",ry="header-resize-dnd-first",oy="header-resize-dnd-second",sy={148:1,27:1},TE={712:1,27:1},VE={25:1,715:1,125:1},zE="workbookChangeToggle",cy="hiddenColumnIndexes",uy="hiddenRowIndexes",ly="verticalSplitPosition",fy="horizontalSplitPosition",Po="com.vaadin.client",hy="lock-format-columns",EE="lock-format-rows",jE="com.vaadin.addon.spreadsheet.shared",_d="com.vaadin.shared.ui",OE="-webkit-animation-name",XE="animation-name",WE="-moz-animation-name",KE="-o-animation-name",LE="fakeelement",ME="animationend",hp="webkit",dy="com.vaadin.client.communication",dp="head",ay="stylesheet",kt="com.vaadin.client.metadata",by={664:1,27:1},NE="com.vaadin.ui.UI",RE="setErrorLevel",PE="handleContextClickListenerChange",_E="onThemeChange",BE="onThoroughSizeChckChange",DE="signalRoundTripCompleted",qE="alwaysUseXhrForServerRequests",py="caption",gy="captionAsHtml",FE="closeTimeout",HE="dateFormat",wy="description",vy="descriptionContentMode",$E="dialogGracePeriod",UE="dialogModal",GE="dialogText",QE="dialogTextGaveUp",JE="enableMobileHTML5DnD",my="enabled",yy="errorLevel",ap="errorMessage",YE="firstDayOfWeek",ZE="firstDelay",ej="hasResizeListeners",tj="hourMinuteDelimiter",xy="latestDelayedCallbackID",Cy="loadingIndicatorConfiguration",nj="localeData",ij="java.util.List",rj="localeServiceState",oj="monthNames",sj="notificationConfigurations",ky="java.util.Map",cj="notificationRole",Sy="overlayContainerLabel",uj="parameters",Iy="pollInterval",Ay="primaryStyleName",Ty="pushConfiguration",lj="quickOpenDelay",fj="quickOpenTimeout",hj="reconnectAttempts",Vy="reconnectDialogConfiguration",dj="reconnectInterval",zy="registeredEventListeners",aj="secondDelay",bj="shortDayNames",pj="shortMonthNames",Ey="styles",jy="tabIndex",gj="thirdDelay",Oy="thoroughSizeCheck",Xy="tooltipConfiguration",wj="twelveHourClock",Kn={32:1},Wy={148:1,245:1,246:1,27:1},Ky="_vScrollTop",Ly="v-scrollable",vj="v-label-undef-w",My="/favicon.ico",bp="com.vaadin.client.ui.ui",on="com.vaadin.component.spreadsheet.client.js",mj="rowBufferSize",yj="columnBufferSize",xj="colGroupingData",Cj="rowGroupingData",kj="colGroupingMax",Sj="rowGroupingMax",Ij="colGroupingInversed",Aj="rowGroupingInversed",Tj="cellStyleToCSSStyle",Vj="rowIndexToStyleIndex",zj="columnIndexToStyleIndex",Ej="lockedColumnIndexes",jj="lockedRowIndexes",Oj="shiftedCellBorderStyles",Xj="conditionalFormattingStyles",Wj="verticalScrollPositions",Kj="horizontalScrollPositions",Lj="workbookProtected",Mj="hyperlinksTooltips",Nj="displayGridlines",Rj="displayRowColHeadings",Pj="infoLabelValue",_j="invalidFormulaErrorMessage",Bj="lockFormatColumns",Dj="lockFormatRows",qj="namedRanges",Ny="trident/",Ry="WARNING",lo="com.vaadin.shared.ui.ui",Py=244140625,_y=1220703125,pp=.3010299956639812,Xe=4294967295,By="BigInteger divide by zero",Dy=4294967296,qy=1073741824,Fj={l:0,m:0,h:524288},gp="delete",Hj={3:1,716:1},Fy="locale",Hy="default",$y="user.agent",ee,Bd,wp,Ff=-1;ae.goog=ae.goog||{},ae.goog.global=ae.goog.global||ae,C$(),re(1,null,{},Yt),ee.Yc=function(y){return F6(this,y)},ee.Zc=function(){return this.mg},ee.$c=function(){return Z1(this)},ee._c=function(){var y;return Ml(cu(this))+"@"+(y=oo(this)>>>0,y.toString(16))},ee.equals=function(a){return this.Yc(a)},ee.hashCode=function(){return this.$c()},ee.toString=function(){return this._c()};var vp;re(684,1,{}),re(307,684,{},Kt),ee.Ld=function(y){var k={},z=[];y[x2]=z;for(var E=arguments.callee.caller;E;){var j=(Yc(),E.name||(E.name=Dq(E.toString())));z.push(j);var te=":"+j,ne=k[te];if(ne){var ie,se;for(ie=0,se=ne.length;ie<se;ie++)if(ne[ie]===E)return}(ne||(k[te]=[])).push(E),E=E.caller}},ee.Md=function(y){var k,z,E,j;for(E=(Yc(),y&&y[x2]?y[x2]:[]),z=E.length,j=Le(Px,ve,74,z,0,1),k=0;k<z;k++)j[k]=new xa(E[k],null,-1);return j},re(685,684,{}),ee.Ld=function(y){},ee.Nd=function(y,k,z,E){return new xa(k,y+"@"+E,z<0?-1:z)},ee.Md=function(y){var k,z,E,j,te,ne;if(j=l$(y),te=Le(Px,ve,74,0,0,1),k=0,E=j.length,E==0)return te;for(ne=QV(this,j[0]),ye(ne.d,H0)||(te[k++]=ne),z=1;z<E;z++)te[k++]=QV(this,j[z]);return te},re(308,685,{},yi),ee.Nd=function(y,k,z,E){return new xa(k,y,-1)};var $j,Uj,Gj;re(20,1,{3:1,20:1}),ee.Cd=function(y){return new Error(y)},ee.Dd=function(){return this.backingJsObject},ee.Ed=function(){var y;return y=gB(__(s_((this.j==null&&(this.j=Le(Zy,ve,20,0,0,1)),this.j)),new a3),MD(new y3,new m3,new x3,Se(Ce(Zj,1),ve,86,0,[(Fv(),Qy)]))),y.Vf(Le(Ke,ve,1,y.size(),5,1))},ee.Fd=function(){return this.e},ee.Gd=function(){return this.f},ee.Hd=function(){JR(this,aD(this.Cd(Yu(this,this.f)))),LC(this)},ee._c=function(){return Yu(this,this.Gd())},ee.backingJsObject=dz,ee.g=!1,ee.k=!0,re(21,20,{3:1,21:1,20:1}),re(24,21,Ns,Ho,Aa),re(33,24,k2,Xl,vo),re(185,33,k2,Ag),$j={3:1,305:1,6:1},re(183,1,{},Dv),ee.Nf=function(y){var k;return k=new Dv,k.f=4,y>1?k.c=PI(this,y-1):k.c=this,k},ee.Of=function(){return ht(this),this.b},ee.Pf=function(){return Ml(this)},ee.Qf=function(){return hh(this)},ee.Rf=function(){return(this.f&4)!=0},ee.Sf=function(){return(this.f&1)!=0},ee._c=function(){return(this.f&2?"interface ":this.f&1?"":"class ")+(ht(this),this.k)},ee.f=0,re(82,1,{3:1,82:1});var Uy;Uj={3:1,6:1,306:1,82:1},re(4,1,{3:1,6:1,4:1}),ee.he=function(y){return this.c-y.c},ee.compareTo=function(y){return this.c-y.c},ee.equals=function(y){return this===y},ee.Yc=function(a){return this.equals(a)},ee.hashCode=function(){return Z1(this)},ee.$c=function(){return this.hashCode()},ee.name=function(){return this.b!=null?this.b:""+this.c},ee.ordinal=function(){return this.c},ee.toString=function(){return q7(this)},ee._c=function(){return this.toString()},ee.c=0,re(68,24,Ns,$o),re(37,24,Ns,uh,mo,R1),re(90,82,{3:1,6:1,90:1,82:1},p1),ee.he=function(y){return hR(this.a,y.a)},ee.Yc=function(y){return gw(this,y)},ee.$c=function(){return this.a},ee.Tf=function(){return this.a},ee._c=function(){return""+this.a},ee.a=0,re(102,24,Ns,$a),re(814,1,{}),re(49,102,{3:1,21:1,49:1,24:1,20:1},PC,UC,ys),ee.Cd=function(y){return new TypeError(y)},Gj={3:1,184:1,6:1,2:1},re(214,33,k2,Tg),re(248,1,{},a3),ee.Kf=function(y){return V7(y)},re(29,24,Ns,Ln,Wl),re(686,1,{38:1}),ee.add=function(y){throw we(new Wl("Add not supported on this collection"))},ee.addAll=function(y){return Ua(this,y)},ee.clear=function(){var y;for(y=this.Ke();y.Ue();)y.Ve(),y.We()},ee.contains=function(y){return M9(this,y,!1)},ee.containsAll=function(y){return f9(this,y)},ee.isEmpty=function(){return this.size()==0},ee.remove=function(y){return M9(this,y,!0)},ee.removeAll=function(y){var k,z,E;for(ft(y),k=!1,z=this.Ke();z.Ue();)E=z.Ve(),y.contains(E)&&(z.We(),k=!0);return k},ee.retainAll=function(y){var k,z,E;for(ft(y),k=!1,z=this.Ke();z.Ue();)E=z.Ve(),y.contains(E)||(z.We(),k=!0);return k},ee.toArray=function(){return this.Vf(Le(Ke,ve,1,this.size(),5,1))},ee.Vf=function(y){return uT(this,y)},ee._c=function(){return Im(this)},re(687,686,U0),ee.addAtIndex=function(y,k){throw we(new Wl("Add not supported on this list"))},ee.add=function(y){return this.addAtIndex(this.size(),y),!0},ee.addAllAtIndex=function(y,k){var z,E,j;for(ft(k),z=!1,j=k.Ke();j.Ue();)E=j.Ve(),this.addAtIndex(y++,E),z=!0;return z},ee.clear=function(){this.Zf(0,this.size())},ee.Yc=function(y){var k,z,E,j,te;if(y===this)return!0;if(!ze(y,80)||(te=y,this.size()!=te.size()))return!1;for(j=te.Ke(),z=this.Ke();z.Ue();)if(k=z.Ve(),E=j.Ve(),!(Lt(k)===Lt(E)||k!=null&&dr(k,E)))return!1;return!0},ee.$c=function(){return vF(this)},ee.indexOf=function(y){return YA(this,y)},ee.Ke=function(){return new wg(this)},ee.lastIndexOf=function(y){var k;for(k=this.size()-1;k>-1;--k)if(es(y,this.getAtIndex(k)))return k;return-1},ee.Xf=function(){return this.Yf(0)},ee.Yf=function(y){return new eA(this,y)},ee.removeAtIndex=function(y){throw we(new Wl("Remove not supported on this list"))},ee.Zf=function(y,k){var z,E;for(E=this.Yf(y),z=y;z<k;++z)E.Ve(),E.We()},ee.setAtIndex=function(y,k){throw we(new Wl("Set not supported on this list"))},ee.subList=function(y,k){return new UI(this,y,k)},re(200,1,{},wg),ee.Ue=function(){return this.b<this.d.size()},ee.Ve=function(){return Gl(this.b<this.d.size()),this.d.getAtIndex(this.c=this.b++)},ee.We=function(){GI(this)},ee.b=0,ee.c=-1,re(309,200,{},eA),ee.We=function(){GI(this)},ee.$f=function(y){this.a.addAtIndex(this.b,y),++this.b,this.c=-1},ee._f=function(){return this.b>0},ee.ag=function(){return Gl(this.b>0),this.a.getAtIndex(this.c=--this.b)},ee.bg=function(y){Ql(this.c!=-1),this.a.setAtIndex(this.c,y)},re(310,687,U0,UI),ee.addAtIndex=function(y,k){jo(y,this.b),this.c.addAtIndex(this.a+y,k),++this.b},ee.getAtIndex=function(y){return pn(y,this.b),this.c.getAtIndex(this.a+y)},ee.removeAtIndex=function(y){var k;return pn(y,this.b),k=this.c.removeAtIndex(this.a+y),--this.b,k},ee.setAtIndex=function(y,k){return pn(y,this.b),this.c.setAtIndex(this.a+y,k)},ee.size=function(){return this.b},ee.a=0,ee.b=0,re(688,1,{149:1}),ee.getOrDefault=function(y,k){var z;return z=this.get(y),z==null&&!this.containsKey(y)?k:z},ee.putIfAbsent=function(y,k){var z;return z=this.get(y),z??this.put(y,k)},ee.replace=function(y,k){return this.containsKey(y)?this.put(y,k):null},ee.clear=function(){this.Wf().clear()},ee.containsKey=function(y){return!!xm(this,y,!1)},ee.containsValue=function(y){var k,z,E;for(z=this.Wf().Ke();z.Ue();)if(k=z.Ve(),E=k.dg(),Lt(y)===Lt(E)||y!=null&&dr(y,E))return!0;return!1},ee.Yc=function(y){var k,z,E;if(y===this)return!0;if(!ze(y,149)||(E=y,this.size()!=E.size()))return!1;for(z=E.Wf().Ke();z.Ue();)if(k=z.Ve(),!fT(this,k))return!1;return!0},ee.get=function(y){return mh(xm(this,y,!1))},ee.$c=function(){return o9(this.Wf())},ee.isEmpty=function(){return this.size()==0},ee.keySet=function(){return new Gr(this)},ee.put=function(y,k){throw we(new Wl("Put not supported on this map"))},ee.putAll=function(y){nl(this,y)},ee.remove=function(y){return mh(xm(this,y,!0))},ee.size=function(){return this.Wf().size()},ee._c=function(){var y,k,z;for(z=new kv("{","}"),k=this.Wf().Ke();k.Ue();)y=k.Ve(),gA(z,jI(this,y.cg())+"="+jI(this,y.dg()));return z.a?z.e.length==0?z.a.a:z.a.a+(""+z.e):z.c},ee.values=function(){return new di(this)},re(689,686,Cd),ee.Yc=function(y){var k;return y===this?!0:!ze(y,101)||(k=y,k.size()!=this.size())?!1:f9(this,k)},ee.$c=function(){return o9(this)},ee.removeAll=function(y){var k,z,E,j;if(ft(y),j=this.size(),j<y.size())for(k=this.Ke();k.Ue();)z=k.Ve(),y.contains(z)&&k.We();else for(E=y.Ke();E.Ue();)z=E.Ve(),this.remove(z);return j!=this.size()},re(57,689,Cd,Gr),ee.clear=function(){this.a.clear()},ee.contains=function(y){return this.a.containsKey(y)},ee.Ke=function(){var y;return y=this.a.Wf().Ke(),new po(y)},ee.remove=function(y){return this.a.containsKey(y)?(this.a.remove(y),!0):!1},ee.size=function(){return this.a.size()},re(61,1,{},po),ee.Ue=function(){return this.a.Ue()},ee.Ve=function(){var y;return y=this.a.Ve(),y.cg()},ee.We=function(){this.a.We()},re(39,686,{38:1},di),ee.clear=function(){this.a.clear()},ee.contains=function(y){return u8(this,y)},ee.Ke=function(){var y;return y=this.a.Wf().Ke(),new yr(y)},ee.size=function(){return this.a.size()},re(51,1,{},yr),ee.Ue=function(){return this.a.Ue()},ee.Ve=function(){var y;return y=this.a.Ve(),y.dg()},ee.We=function(){this.a.We()},re(317,1,kd),ee.Yc=function(y){var k;return ze(y,100)?(k=y,es(this.a,k.cg())&&es(this.b,k.dg())):!1},ee.cg=function(){return this.a},ee.dg=function(){return this.b},ee.$c=function(){return H1(this.a)^H1(this.b)},ee.eg=function(y){var k;return k=this.b,this.b=y,k},ee._c=function(){return this.a+"="+this.b},re(208,317,kd,Bg),re(10,687,{3:1,10:1,38:1,80:1,180:1},st,Sv,ef),ee.addAtIndex=function(y,k){Eh(this,y,k)},ee.add=function(y){return St(this,y)},ee.addAllAtIndex=function(y,k){var z,E;return jo(y,this.a.length),z=k.toArray(),E=z.length,E==0?!1:(Tw(this.a,y,z),!0)},ee.addAll=function(y){return Os(this,y)},ee.clear=function(){this.a=Le(Ke,ve,1,0,5,1)},ee.contains=function(y){return et(this,y,0)!=-1},ee.getAtIndex=function(y){return Ze(this,y)},ee.indexOf=function(y){return et(this,y,0)},ee.isEmpty=function(){return this.a.length==0},ee.Ke=function(){return new Fe(this)},ee.lastIndexOf=function(y){return zD(this,y,this.a.length-1)},ee.removeAtIndex=function(y){return Or(this,y)},ee.remove=function(y){return Jh(this,y)},ee.Zf=function(y,k){var z;B9(y,k,this.a.length),z=k-y,Wg(this.a,y,z)},ee.setAtIndex=function(y,k){var z;return z=(pn(y,this.a.length),this.a[y]),this.a[y]=k,z},ee.size=function(){return this.a.length},ee.toArray=function(){return b_(this.a,this.a.length)},ee.Vf=function(y){return td(this,y)},re(7,1,{},Fe),ee.Ue=function(){return g7(this)},ee.Ve=function(){return He(this)},ee.We=function(){Es(this)},ee.a=0,ee.b=-1;var Dd,Qj,Gy;re(384,687,az,b3),ee.contains=function(y){return!1},ee.getAtIndex=function(y){return pn(y,0),null},ee.Ke=function(){return zn(),Ll(),mp},ee.Xf=function(){return zn(),Ll(),mp},ee.size=function(){return 0},re(385,1,{},p3),ee.$f=function(y){throw we(new Ln)},ee.Ue=function(){return!1},ee._f=function(){return!1},ee.Ve=function(){return ZM()},ee.ag=function(){throw we(new Ku)},ee.We=function(){throw we(new uh)},ee.bg=function(y){throw we(new uh)};var mp;re(387,688,bz,g3),ee.containsKey=function(y){return!1},ee.containsValue=function(y){return!1},ee.Wf=function(){return zn(),Gy},ee.get=function(y){return null},ee.keySet=function(){return zn(),Gy},ee.size=function(){return 0},ee.values=function(){return zn(),Dd},re(386,689,pz,w3),ee.contains=function(y){return!1},ee.Ke=function(){return zn(),Ll(),mp},ee.size=function(){return 0},re(66,24,{3:1,21:1,24:1,20:1,66:1},Ku),re(152,1,{}),ee.hg=function(y){Ek(this,y)},ee.fg=function(){return this.c},ee.gg=function(){return this.d},ee.c=0,ee.d=0,re(253,152,{}),re(256,1,{}),ee.hg=function(y){Ek(this,y)},ee.fg=function(){return this.b},ee.gg=function(){return this.d-this.c},ee.b=0,ee.c=0,ee.d=0,re(257,256,{},mI),ee.hg=function(y){I_(this,y)},ee.ig=function(y){return $D(this,y)},re(252,1,{},v3),ee.Kf=function(y){return y},re(86,4,{3:1,6:1,4:1,86:1},N1);var Jj,Qy,Yj;re(655,1,{},P7),re(250,1,{},m3),ee.zf=function(y,k){CC(y,k)},re(249,1,{},y3),ee.Lf=function(){return new st},re(251,1,{},x3),re(169,1,{}),ee.c=!1,re(95,169,{},Fu),re(528,253,{},bA),ee.ig=function(y){return this.b.ig(new M6(this,y))},re(532,1,{},M6),ee.Mf=function(y){YM(this.a,this.b,y)},re(531,1,{},C3),ee.Mf=function(y){Q3(this,y)},re(535,1,{},nC),re(536,1,{},N6),ee.Mf=function(y){T1(this,y)},re(816,1,{}),re(812,1,{});var dQ=0,Jy,Yy=0,qd,Ke=oe(ln,"Object",1),yp=oe(Sd,"JavaScriptObject$",0);oe(Cu,"StackTraceCreator/Collector",684),oe(Cu,"StackTraceCreator/CollectorLegacy",307),oe(Cu,"StackTraceCreator/CollectorModern",685),oe(Cu,"StackTraceCreator/CollectorModernNoSourceMap",308);var Zy=oe(ln,"Throwable",20);oe(ln,"Exception",21),oe(ln,"RuntimeException",24),oe(ln,"IndexOutOfBoundsException",33),oe(ln,"ArrayIndexOutOfBoundsException",185);var Hs=oe(ln,"Boolean",305);oe(ln,"Class",183),oe(ln,"Number",82);var aQ=oe(ln,"Double",306);oe(ln,"Enum",4),oe(ln,"IllegalArgumentException",68),oe(ln,"IllegalStateException",37);var Yi=oe(ln,"Integer",90);oe(ln,"JsException",102),oe(ln,"NullPointerException",49);var ct=oe(ln,"String",2);oe(ln,"StringIndexOutOfBoundsException",214),oe(ln,"Throwable/lambda$0$Type",248),oe(ln,"UnsupportedOperationException",29),oe(Pe,"AbstractCollection",686),ur(Pe,"List"),oe(Pe,"AbstractList",687),oe(Pe,"AbstractList/IteratorImpl",200),oe(Pe,"AbstractList/ListIteratorImpl",309),oe(Pe,"AbstractList/SubList",310),ur(Pe,"Map"),oe(Pe,"AbstractMap",688),ur(Pe,"Set"),oe(Pe,"AbstractSet",689),oe(Pe,"AbstractMap/1",57),oe(Pe,"AbstractMap/1/1",61),oe(Pe,"AbstractMap/2",39),oe(Pe,"AbstractMap/2/1",51),oe(Pe,"AbstractMap/AbstractEntry",317),oe(Pe,"AbstractMap/SimpleEntry",208),oe(Pe,"ArrayList",10),oe(Pe,"ArrayList/1",7),oe(Pe,"Collections/EmptyList",384),oe(Pe,"Collections/EmptyListIterator",385),oe(Pe,"Collections/EmptyMap",387),oe(Pe,"Collections/EmptySet",386),oe(Pe,"NoSuchElementException",66),oe(Pe,"Spliterators/BaseSpliterator",152),oe(Pe,"Spliterators/AbstractSpliterator",253),oe(Pe,"Spliterators/BaseArraySpliterator",256),oe(Pe,"Spliterators/ArraySpliterator",257),oe("java.util.function","Function/lambda$0$Type",252);var Zj=We($n,"Collector/Characteristics",86,IB);oe($n,"CollectorImpl",655),oe($n,"Collectors/20methodref$add$Type",250),oe($n,"Collectors/21methodref$ctor$Type",249),oe($n,"Collectors/lambda$42$Type",251),oe($n,"TerminatableStream",169),oe($n,"StreamImpl",95),oe($n,"StreamImpl/MapToObjSpliterator",528),oe($n,"StreamImpl/MapToObjSpliterator/lambda$0$Type",532),oe($n,"StreamImpl/ValueConsumer",531),oe($n,"StreamImpl/lambda$4$Type",535),oe($n,"StreamImpl/lambda$5$Type",536),re(131,1,{}),ee.ad=function(y){return(1+ae.Math.cos(V2+y*V2))/2},ee.bd=function(){this.u&&this.cd()},ee.cd=function(){this.ed(this.ad(1))},ee.dd=function(){this.ed(this.ad(0))},ee.k=-1,ee.o=!1,ee.p=!1,ee.r=-1,ee.t=-1,ee.u=!1,oe(Ps,"Animation",131),re(326,1,{},J3),ee.fd=function(y){bv(this,y)},oe(Ps,"Animation/1",326),re(707,1,{});var ex;oe(Ps,"AnimationScheduler",707),re(176,1,{176:1}),oe(Ps,"AnimationScheduler/AnimationHandle",176),re(641,707,{},Vl),ee.gd=function(y,k){var z;return z=OF(y,k),new Y3(z)},oe(Ps,"AnimationSchedulerImplStandard",641),re(642,176,{176:1},Y3),ee.hd=function(){gP(this.a)},oe(Ps,"AnimationSchedulerImplStandard/1",642),re(643,707,{},T8),ee.gd=function(y,k){var z;return z=new Bk(this,y),St(this.a,z),this.a.a.length==1&&gn(this.b,16),z},oe(Ps,"AnimationSchedulerImplTimer",643),re(44,1,{}),ee.jd=function(y){y==this.b&&(this.c||(this.d=null),this.kd())},ee.b=0,ee.c=!1,ee.d=null,oe(Of,"Timer",44),re(644,44,{},WS),ee.kd=function(){X$(this.a)},oe(Ps,"AnimationSchedulerImplTimer/1",644),re(177,176,{176:1,177:1},Bk),ee.hd=function(){u_(this.b,this)};var bQ=oe(Ps,"AnimationSchedulerImplTimer/AnimationHandleImpl",177);re(8,1,{}),oe(Be,"RoleImpl",8),re(575,8,{},j6),oe(Be,"AlertRoleImpl",575),re(574,8,{},GC),oe(Be,"AlertdialogRoleImpl",574),re(576,8,{},QC),oe(Be,"ApplicationRoleImpl",576),re(244,1,{}),oe(Be,"Attribute",244),re(56,244,{},kr),ee.ld=function(y){return y.a},oe(Be,"AriaValueAttribute",56),re(577,8,{},gS),oe(Be,"ArticleRoleImpl",577),re(578,8,{},U6),oe(Be,"BannerRoleImpl",578),re(579,8,{},JC),oe(Be,"ButtonRoleImpl",579),re(580,8,{},$S),oe(Be,"CheckboxRoleImpl",580),re(581,8,{},YC),oe(Be,"ColumnheaderRoleImpl",581),re(582,8,{},US),oe(Be,"ComboboxRoleImpl",582),re(583,8,{},ZC),oe(Be,"ComplementaryRoleImpl",583),re(584,8,{},ek),oe(Be,"ContentinfoRoleImpl",584),re(585,8,{},tk),oe(Be,"DefinitionRoleImpl",585),re(586,8,{},Y6),oe(Be,"DialogRoleImpl",586),re(587,8,{},C7),oe(Be,"DirectoryRoleImpl",587),re(588,8,{},GS),oe(Be,"DocumentRoleImpl",588),re(589,8,{},t6),oe(Be,"FormRoleImpl",589),re(591,8,{},n6),oe(Be,"GridRoleImpl",591),re(590,8,{},QS),oe(Be,"GridcellRoleImpl",590),re(592,8,{},O6),oe(Be,"GroupRoleImpl",592),re(593,8,{},mS),oe(Be,"HeadingRoleImpl",593),re(175,1,{735:1,175:1},OC);var pQ=oe(Be,"Id",175);re(594,8,{},Xk),oe(Be,"ImgRoleImpl",594),re(595,8,{},nk),oe(Be,"LinkRoleImpl",595),re(598,8,{},s6),oe(Be,"ListRoleImpl",598),re(596,8,{},hS),oe(Be,"ListboxRoleImpl",596),re(597,8,{},t7),oe(Be,"ListitemRoleImpl",597),re(599,8,{},Wk),oe(Be,"LogRoleImpl",599),re(600,8,{},i6),oe(Be,"MainRoleImpl",600),re(601,8,{},wS),oe(Be,"MarqueeRoleImpl",601),re(602,8,{},r6),oe(Be,"MathRoleImpl",602),re(607,8,{},o6),oe(Be,"MenuRoleImpl",607),re(603,8,{},vS),oe(Be,"MenubarRoleImpl",603),re(606,8,{},n7),oe(Be,"MenuitemRoleImpl",606),re(604,8,{},ik),oe(Be,"MenuitemcheckboxRoleImpl",604),re(605,8,{},rk),oe(Be,"MenuitemradioRoleImpl",605),re(608,8,{},ok),oe(Be,"NavigationRoleImpl",608),re(609,8,{},c6),oe(Be,"NoteRoleImpl",609),re(610,8,{},sk),oe(Be,"OptionRoleImpl",610),re(611,8,{},ck),oe(Be,"PresentationRoleImpl",611),re(43,244,{},_i),ee.ld=function(y){return y==null?Ro:wi(y)},oe(Be,"PrimitiveValueAttribute",43),re(612,8,{},uk),oe(Be,"ProgressbarRoleImpl",612);var eO,tO;re(614,8,{},X6),oe(Be,"RadioRoleImpl",614),re(613,8,{},lk),oe(Be,"RadiogroupRoleImpl",613),re(615,8,{},Z6),oe(Be,"RegionRoleImpl",615);var nO,iO,rO,oO,sO,cO,uO,lO,fO,hO,dO,aO,bO,pO,gO,wO,vO,mO,yO,xO,CO,kO,SO,IO,AO,TO,VO,zO,EO,jO,tx,nx,OO,XO,WO,KO,LO,MO,NO,RO,PO,_O,Ge,BO,DO,qO,FO,HO,$O,UO,GO,QO,JO,YO,ZO,eX,tX,nX,iX,rX,oX,sX;re(618,8,{},Kk),oe(Be,"RowRoleImpl",618),re(616,8,{},e7),oe(Be,"RowgroupRoleImpl",616),re(617,8,{},S7),oe(Be,"RowheaderRoleImpl",617),re(619,8,{},I7),oe(Be,"ScrollbarRoleImpl",619),re(620,8,{},Q6),oe(Be,"SearchRoleImpl",620),re(621,8,{},k7),oe(Be,"SeparatorRoleImpl",621),re(622,8,{},G6),oe(Be,"SliderRoleImpl",622),re(623,8,{},fk),oe(Be,"SpinbuttonRoleImpl",623),re(624,8,{},J6),oe(Be,"StatusRoleImpl",624),re(627,8,{},Lk),oe(Be,"TabRoleImpl",627),re(625,8,{},pS),oe(Be,"TablistRoleImpl",625),re(626,8,{},JS),oe(Be,"TabpanelRoleImpl",626),re(628,8,{},dS),oe(Be,"TextboxRoleImpl",628),re(629,8,{},W6),oe(Be,"TimerRoleImpl",629),re(630,8,{},aS),oe(Be,"ToolbarRoleImpl",630),re(631,8,{},bS),oe(Be,"TooltipRoleImpl",631),re(634,8,{},u6),oe(Be,"TreeRoleImpl",634),re(632,8,{},ZS),oe(Be,"TreegridRoleImpl",632),re(633,8,{},YS),oe(Be,"TreeitemRoleImpl",633),re(12,1,{16:1,12:1}),ee.md=function(){return Cs(this)},ee.nd=function(){throw we(new Ln)},ee.od=function(y){lw(this,y)},ee.pd=function(y,k){vt(this,y,k)},ee.qd=function(y){Y1(this,y)},ee._c=function(){return this.Xc?DN((fe(),this.Xc)):"(null handle)"},oe(nt,"UIObject",12),re(13,12,Pr),ee.rd=function(){},ee.sd=function(){},ee.td=function(y){L6(this,y)},ee.ud=function(){return this.Tc},ee.vd=function(){ud(this)},ee.wd=function(y){cs(this,y)},ee.xd=function(){S0(this)},ee.yd=function(){},ee.zd=function(){},ee.Tc=!1,ee.Uc=0;var cX=oe(nt,"Widget",13);ur(nt,"Focusable"),re(209,13,ku),ee.vd=function(){var y;ud(this),y=UN((fe(),this.Xc)),y==-1&&(this.Xc.tabIndex=0)},ee.Ad=function(y){sS(this,y)},ee.Bd=function(y){Ng(this,y)};var Fd;oe(nt,"FocusWidget",209),re(652,209,ku,xk),oe(O2,"Canvas",652),re(711,1,{}),oe(O2,"Canvas/CanvasElementSupportDetector",711),re(653,711,{},lK),oe(O2,"Canvas/CanvasElementSupportDetectedMaybe",653),re(211,1,{},mg),ee.a=0,oe(Sd,"Duration",211);var xp=null;re(350,102,Ns),oe(Cu,"JavaScriptExceptionBase",350),re(81,350,{81:1,3:1,21:1,24:1,20:1},qI),ee.Gd=function(){return A$(this),this.c},ee.Id=function(){return Lt(this.b)===Lt(ix)?null:this.b};var ix;oe(Sd,"JavaScriptException",81),ur(Sd,"RunAsyncCallback"),re(666,1,{}),oe(Sd,"Scheduler",666);var Hd=0,uX=!1,gQ,lX=0,$d=-1;re(351,666,{}),ee.e=!1,ee.j=!1;var pt;oe(Cu,"SchedulerImpl",351),re(352,1,{},t5),ee.Jd=function(){return this.a.e=!0,Rq(this.a),this.a.e=!1,this.a.j=pN(this.a)},oe(Cu,"SchedulerImpl/Flusher",352),re(353,1,{},n5),ee.Jd=function(){return this.a.e&&Qh(this.a.f,1),this.a.j},oe(Cu,"SchedulerImpl/Rescuer",353),re(115,1,Ad),ee.Qd=function(y){return y.button|0},ee.Sd=function(y){return y.currentTarget},ee.Wd=function(y){return Dt(lH(y))},ee.Xd=function(y){return Dt(uH(y))},ee.Yd=function(y){return 0},ee.Zd=function(y){return 0},ee.$d=function(y){return ye(y.compatMode,_s)?y.documentElement:y.body},ee._d=function(y){for(var k="",z=y.firstChild;z;)z.nodeType==1?k+=this._d(z):z.nodeValue&&(k+=z.nodeValue),z=z.nextSibling;return k},ee.ae=function(y){return Dt(y.scrollLeft||0)},ee.be=function(y){return y.tabIndex},ee.de=function(y,k){for(;y.firstChild;)y.removeChild(y.firstChild);k!=null&&y.appendChild(y.ownerDocument.createTextNode(k))},ee.ee=function(y,k){y.scrollLeft=k},ee.fe=function(y){return y.outerHTML};var Ie;oe(Ne,"DOMImpl",115),re(697,115,Ad),ee.Od=function(y,k,z,E){var j=y.createEvent("HTMLEvents");return j.initEvent(k,z,E),j},ee.Pd=function(y,k){y.dispatchEvent(k)},ee.Qd=function(y){var k=y.button;return k==1?4:k==2?2:1},ee.Rd=function(y){return y.charCode||0},ee.Td=function(y){return y.relatedTarget},ee.Ud=function(y){return y.target},ee.Vd=function(y){y.preventDefault()},ee.$d=function(y){return y.scrollingElement?y.scrollingElement:this.ge(y)},ee._d=function(y){return y.textContent},ee.ge=function(y){return ye(y.compatMode,_s)?y.documentElement:y.body},ee.ce=function(y,k){return y.contains(k)},ee.de=function(y,k){y.textContent=k||""},oe(Ne,Xz,697),re(475,697,Ad,L3),ee.Td=function(y){var k=y.relatedTarget;if(!k)return null;try{var z=k.nodeName;return k}catch{return null}},ee.Wd=function(y){return F$(Vi(y.ownerDocument),y)},ee.Xd=function(y){return q$(Vi(y.ownerDocument),y)},ee.Yd=function(y){var k=ae.getComputedStyle(y.documentElement,null);return k==null?0:parseInt(k.marginLeft,10)+parseInt(k.borderLeftWidth,10)},ee.Zd=function(y){var k=ae.getComputedStyle(y.documentElement,null);return k==null?0:parseInt(k.marginTop,10)+parseInt(k.borderTopWidth,10)},ee.ae=function(y){var k;return k=(Hf==-2&&(Hf=YT()),Hf),!(k!=-1&&k>=1009e3)&&QA(y)?Dt(y.scrollLeft||0)-(((y.scrollWidth||0)|0)-(y.clientWidth|0)):Dt(y.scrollLeft||0)},ee.ce=function(y,k){return y===k||!!(y.compareDocumentPosition(k)&16)},ee.ee=function(y,k){var z;z=(Hf==-2&&(Hf=YT()),Hf),!(z!=-1&&z>=1009e3)&&QA(y)&&(k+=((y.scrollWidth||0)|0)-(y.clientWidth|0)),y.scrollLeft=k},ee.fe=function(y){var k=y.ownerDocument,z=y.cloneNode(!0),E=k.createElement("DIV");return E.appendChild(z),outer=E.innerHTML,z.innerHTML="",outer};var Hf=-2;oe(Ne,Wz,475),re(698,697,Ad),ee.Sd=function(y){return y.currentTarget||ae},ee.Wd=function(y){var k,z;return z=y.getBoundingClientRect&&y.getBoundingClientRect(),k=z?z.left+JI(this,y.ownerDocument):DG(y),be(),k|0},ee.Xd=function(y){var k,z;return k=y.getBoundingClientRect&&y.getBoundingClientRect(),z=k?k.top+EA(this,y.ownerDocument):zG(y),be(),z|0},ee.ae=function(y){return!cl("body",(be(),y).tagName)&&BA(y)?Dt(y.scrollLeft||0)-(((y.scrollWidth||0)|0)-(y.clientWidth|0)):Dt(y.scrollLeft||0)},ee.be=function(y){return typeof y.tabIndex<"u"?y.tabIndex:-1},ee.ee=function(y,k){!cl("body",(be(),y).tagName)&&BA(y)&&(k+=((y.scrollWidth||0)|0)-(y.clientWidth|0)),y.scrollLeft=k},oe(Ne,Kz,698),re(474,698,Ad,M3),ee.Ud=function(y){var k=y.target;return k&&k.nodeType==3&&(k=k.parentNode),k},ee.ge=function(y){return y.body},oe(Ne,Lz,474),re(54,4,Xf);var fX,hX,dX,aX,bX,wQ=We(Ne,"Style/BorderStyle",54,BB);re(427,54,Xf,eS),We(Ne,"Style/BorderStyle/1",427,null),re(428,54,Xf,i7),We(Ne,"Style/BorderStyle/2",428,null),re(429,54,Xf,r7),We(Ne,"Style/BorderStyle/3",429,null),re(430,54,Xf,Mk),We(Ne,"Style/BorderStyle/4",430,null),re(431,54,Xf,XS),We(Ne,"Style/BorderStyle/5",431,null),re(23,4,Un);var Ud,pX,gX,wX,rx,vX,mX,yX,$f,xX,CX,kX,SX,IX,AX,TX,VX,zX,EX,vQ=We(Ne,"Style/Display",23,AF);re(432,23,Un,tS),ee.ie=function(){return tn},We(Ne,"Style/Display/1",432,null),re(441,23,Un,N8),ee.ie=function(){return"table-column-group"},We(Ne,"Style/Display/10",441,null),re(442,23,Un,q8),ee.ie=function(){return"table-header-group"},We(Ne,"Style/Display/11",442,null),re(443,23,Un,F8),ee.ie=function(){return"table-footer-group"},We(Ne,"Style/Display/12",443,null),re(444,23,Un,M8),ee.ie=function(){return"table-row-group"},We(Ne,"Style/Display/13",444,null),re(445,23,Un,e8),ee.ie=function(){return"table-cell"},We(Ne,"Style/Display/14",445,null),re(446,23,Un,y8),ee.ie=function(){return"table-column"},We(Ne,"Style/Display/15",446,null),re(447,23,Un,Z7),ee.ie=function(){return"table-row"},We(Ne,"Style/Display/16",447,null),re(448,23,Un,W7),ee.ie=function(){return"initial"},We(Ne,"Style/Display/17",448,null),re(449,23,Un,TS),ee.ie=function(){return"flex"},We(Ne,"Style/Display/18",449,null),re(450,23,Un,r8),ee.ie=function(){return"inline-flex"},We(Ne,"Style/Display/19",450,null),re(433,23,Un,VS),ee.ie=function(){return vi},We(Ne,"Style/Display/2",433,null),re(434,23,Un,o7),ee.ie=function(){return"inline"},We(Ne,"Style/Display/3",434,null),re(435,23,Un,o8),ee.ie=function(){return"inline-block"},We(Ne,"Style/Display/4",435,null),re(436,23,Un,s8),ee.ie=function(){return"inline-table"},We(Ne,"Style/Display/5",436,null),re(437,23,Un,D7),ee.ie=function(){return"list-item"},We(Ne,"Style/Display/6",437,null),re(438,23,Un,s7),ee.ie=function(){return"run-in"},We(Ne,"Style/Display/7",438,null),re(439,23,Un,zS),ee.ie=function(){return"table"},We(Ne,"Style/Display/8",439,null),re(440,23,Un,x8),ee.ie=function(){return"table-caption"},We(Ne,"Style/Display/9",440,null),re(62,4,Vd);var jX,OX,XX,WX,mQ=We(Ne,"Style/Overflow",62,xB);re(451,62,Vd,y7),We(Ne,"Style/Overflow/1",451,null),re(452,62,Vd,Nk),We(Ne,"Style/Overflow/2",452,null),re(453,62,Vd,l7),We(Ne,"Style/Overflow/3",453,null),re(454,62,Vd,nS),We(Ne,"Style/Overflow/4",454,null),re(63,4,zd);var KX,LX,MX,NX,yQ=We(Ne,"Style/Position",63,CB);re(455,63,zd,c7),We(Ne,"Style/Position/1",455,null),re(456,63,zd,j7),We(Ne,"Style/Position/2",456,null),re(457,63,zd,O7),We(Ne,"Style/Position/3",457,null),re(458,63,zd,ES),We(Ne,"Style/Position/4",458,null),re(64,4,Ed);var RX,PX,_X,BX,xQ=We(Ne,"Style/TextAlign",64,kB);re(459,64,Ed,u7),We(Ne,"Style/TextAlign/1",459,null),re(460,64,Ed,x7),We(Ne,"Style/TextAlign/2",460,null),re(461,64,Ed,iS),We(Ne,"Style/TextAlign/3",461,null),re(462,64,Ed,jS),We(Ne,"Style/TextAlign/4",462,null),re(93,4,W2);var DX,qX,CQ=We(Ne,"Style/TextOverflow",93,X_);re(463,93,W2,rS),We(Ne,"Style/TextOverflow/1",463,null),re(464,93,W2,X7),We(Ne,"Style/TextOverflow/2",464,null),re(34,4,bs);var FX,HX,$X,UX,GX,QX,JX,YX,ZX,kQ=We(Ne,"Style/Unit",34,QD);re(418,34,bs,$k),We(Ne,"Style/Unit/1",418,null),re(419,34,bs,D6),We(Ne,"Style/Unit/2",419,null),re(420,34,bs,Uk),We(Ne,"Style/Unit/3",420,null),re(421,34,bs,Gk),We(Ne,"Style/Unit/4",421,null),re(422,34,bs,Qk),We(Ne,"Style/Unit/5",422,null),re(423,34,bs,Jk),We(Ne,"Style/Unit/6",423,null),re(424,34,bs,Yk),We(Ne,"Style/Unit/7",424,null),re(425,34,bs,Zk),We(Ne,"Style/Unit/8",425,null),re(426,34,bs,e6),We(Ne,"Style/Unit/9",426,null),re(94,4,K2);var Zi,er,SQ=We(Ne,"Style/Visibility",94,W_);re(465,94,K2,m7),ee.ie=function(){return ni},We(Ne,"Style/Visibility/1",465,null),re(466,94,K2,Rk),ee.ie=function(){return dt},We(Ne,"Style/Visibility/2",466,null),re(55,4,Wf);var eW,tW,nW,iW,rW,IQ=We(Ne,"Style/WhiteSpace",55,DB);re(467,55,Wf,f7),We(Ne,"Style/WhiteSpace/1",467,null),re(468,55,Wf,h7),We(Ne,"Style/WhiteSpace/2",468,null),re(469,55,Wf,q6),We(Ne,"Style/WhiteSpace/3",469,null),re(470,55,Wf,E7),We(Ne,"Style/WhiteSpace/4",470,null),re(471,55,Wf,z7),We(Ne,"Style/WhiteSpace/5",471,null),re(680,1,{}),ee._c=function(){return"An event type"},oe(Iu,"Event",680),re(681,680,{}),ee.le=function(){return this.ke()},ee.me=function(){this.e=!1,this.f=null},ee.e=!1,oe(Kf,"GwtEvent",681),re(692,681,{}),ee.ke=function(){return this.ne()},ee.le=function(){return this.ne()};var Uf;oe(Rn,"DomEvent",692),re(542,692,{},Zx),ee.je=function(y){y.oe(this)},ee.ke=function(){return Gf},ee.le=function(){return Gf},ee.ne=function(){return Gf};var Gf;oe(Rn,"BlurEvent",542),re(693,692,{}),oe(Rn,"HumanInputEvent",693),re(694,693,{}),oe(Rn,"MouseEvent",694),re(417,694,{},e4),ee.je=function(y){y.pe(this)},ee.ke=function(){return ws},ee.le=function(){return ws},ee.ne=function(){return ws};var ws;oe(Rn,"ClickEvent",417),re(481,692,{},t4),ee.je=function(y){y.qe(this)},ee.ke=function(){return xl},ee.le=function(){return xl},ee.ne=function(){return xl};var xl;oe(Rn,"ContextMenuEvent",481),re(293,1,{}),ee.$c=function(){return this.c},ee._c=function(){return"Event type"},ee.c=0;var AQ=0;oe(Iu,"Event/Type",293),re(50,293,{},xr),oe(Kf,"GwtEvent/Type",50),re(42,50,{42:1},ar),oe(Rn,"DomEvent/Type",42),re(541,692,{},n4),ee.je=function(y){Y_(y,this)},ee.ke=function(){return Gd},ee.le=function(){return Gd},ee.ne=function(){return Gd};var Gd;oe(Rn,"FocusEvent",541),re(703,692,{}),oe(Rn,"KeyEvent",703),re(704,703,{}),oe(Rn,"KeyCodeEvent",704),re(540,704,{},i4),ee.je=function(y){sQ(y,this)},ee.ke=function(){return Qd},ee.le=function(){return Qd},ee.ne=function(){return Qd};var Qd;oe(Rn,"KeyDownEvent",540),re(645,703,{},r4),ee.je=function(y){UH(y,this)},ee.ke=function(){return Jd},ee.le=function(){return Jd},ee.ne=function(){return Jd};var Jd;oe(Rn,"KeyPressEvent",645),re(649,704,{},o4),ee.je=function(y){y.re(this)},ee.ke=function(){return Yd},ee.le=function(){return Yd},ee.ne=function(){return Yd};var Yd;oe(Rn,"KeyUpEvent",649),re(648,692,{},s4),ee.je=function(y){Vs(y.a.b)},ee.ke=function(){return Zd},ee.le=function(){return Zd},ee.ne=function(){return Zd};var Zd;oe(Rn,"LoadEvent",648),re(539,694,{},c4),ee.je=function(y){y.se(this)},ee.ke=function(){return e1},ee.le=function(){return e1},ee.ne=function(){return e1};var e1;oe(Rn,"MouseDownEvent",539),re(646,694,{},u4),ee.je=function(y){y.te(this)},ee.ke=function(){return t1},ee.le=function(){return t1},ee.ne=function(){return t1};var t1;oe(Rn,"MouseUpEvent",646),re(553,1,{},eC),oe(Rn,"PrivateMap",553),re(708,693,{});var ox;oe(Rn,Nz,708),re(662,708,{},l4),ee.je=function(y){Aq(y.a,this)},ee.ke=function(){return n1},ee.le=function(){return n1},ee.ne=function(){return n1};var n1;oe(Rn,"TouchEndEvent",662),re(552,1,{},mk),ee.a=!1,oe(Rn,"TouchEvent/TouchSupportDetector",552),re(661,708,{},f4),ee.je=function(y){h$(y,this)&&VP(y.a)},ee.ke=function(){return i1},ee.le=function(){return i1},ee.ne=function(){return i1};var i1;oe(Rn,"TouchMoveEvent",661),re(647,708,{},h4),ee.je=function(y){y.ue(this)},ee.ke=function(){return Cl},ee.le=function(){return Cl},ee.ne=function(){return Cl};var Cl;oe(Rn,"TouchStartEvent",647),re(304,681,{},i5),ee.je=function(y){y.ve(this)},ee.le=function(){return $s},ee.ke=function(){return $s},ee.a=!1;var $s;oe(J0,"AttachEvent",304),re(543,681,{},a4),ee.je=function(y){y.we(this)},ee.le=function(){return fo},ee.ke=function(){return fo};var fo;oe(J0,"CloseEvent",543),re(556,681,{},b4),ee.je=function(y){y.xe(this)},ee.le=function(){return Qf},ee.ke=function(){return Qf};var Qf;oe(J0,"ResizeEvent",556),re(573,681,{},p4),ee.je=function(y){y.a.v&&y.a.Qe()},ee.le=function(){return Jf},ee.ke=function(){return Jf};var Jf;oe(J0,"ValueChangeEvent",573),re(76,1,{14:1},Pu,aw),ee.td=function(y){Ws(this,y)},oe(Kf,"HandlerManager",76),re(690,1,{}),oe(Iu,"EventBus",690),re(356,690,{}),ee.b=0,ee.c=!1,oe(Iu,"SimpleEventBus",356),re(357,356,{},v7),oe(Kf,"HandlerManager/Bus",357),re(549,1,{},r5),oe(Kf,"LegacyHandlerWrapper",549),re(89,24,M2,wm),oe(Iu,_z,89),re(196,89,M2,Ig),oe(Kf,_z,196),re(109,4,{109:1,3:1,6:1,4:1},L1);var Cp,sx,cx,TQ=We("com.google.gwt.i18n.client","HasDirection/Direction",109,Z_),wr,ux,oW,lx,fx;re(110,1,{110:1});var sW=oe(Qi,"Handler",110);re(264,110,{110:1},bI),ee.ye=function(y){var k,z;!window.console||(RP(this),xu>y.a.Tf())||(k=N$(this.a,y),z=y.a.Tf(),z>=(Nn(),_r)?window.console.error(k):z>=900?window.console.warn(k):z>=800?window.console.info(k):window.console.log(k))},oe(Lf,"ConsoleLogHandler",264),re(265,110,{110:1},TI),ee.ye=function(y){},oe(Lf,"DevelopmentModeLogHandler",265);var cW,uW=oe(Lf,"LogConfiguration",null);re(263,1,{},e5),oe(Lf,"LogConfiguration/1",263),re(262,1,{},g4),oe(Lf,"LogConfiguration/LogConfigurationImplRegular",262),re(705,1,{}),oe(Qi,"Formatter",705),re(706,705,{}),oe(Bz,"FormatterImpl",706),re(242,706,{},ug),ee.a=!1,oe(Lf,"TextLogFormatter",242),re(668,1,{}),oe(N2,"OutputStream",668),re(190,668,{},og),oe(N2,"FilterOutputStream",190),re(153,190,{},I1),ee.ze=function(y){},oe(N2,"PrintStream",153),re(637,153,{},L8),ee.ze=function(y){rt(this.a,y),rt(this.a,`
`)},oe(Bz,"StackTracePrintStream",637),re(562,1,{},jC),oe(R2,"SafeHtmlBuilder",562),re(146,1,{731:1,146:1,3:1},vv),ee.Yc=function(y){return ze(y,146)?ye(this.a,y.a):!1},ee.$c=function(){return hu(this.a)},ee._c=function(){return'safe: "'+this.a+'"'},oe(R2,"SafeHtmlString",146);var lW,fW,hW,dW,aW,bW;re(119,1,{733:1,119:1},Oa),ee.Yc=function(y){return ze(y,119)?ye(this.a,y.a):!1},ee.$c=function(){return hu(this.a)},ee._c=function(){return'safe: "'+this.a+'"'},oe(R2,"SafeUriString",119),re(710,1,{}),oe("com.google.gwt.text.shared","AbstractRenderer",710),re(651,1,{},fK),oe(Dz,"PassthroughParser",651),re(650,710,{},hK),oe(Dz,"PassthroughRenderer",650);var an,ho,kp;re(327,681,{},d4),ee.je=function(y){y.Ae(this),tr.c=!1},ee.le=function(){return kl},ee.ke=function(){return kl},ee.me=function(){oA(this)},ee.a=!1,ee.b=!1,ee.c=!1;var kl,tr;oe(Of,"Event/NativePreviewEvent",327);var hx,dx;re(547,1,{14:1},Dk),ee.td=function(y){Ws(this.a,y)},oe(Of,"History/HistoryEventSource",547),re(548,1,{},hA),oe(Of,"History/HistoryImpl",548);var Sp=!1,_o,pW,gW=0,wW=0,ax=!1;re(355,681,{},N3),ee.je=function(y){null.pg()},ee.le=function(){return bx},ee.ke=function(){return bx};var bx;oe(Of,"Window/ClosingEvent",355);var vW="",px;re(159,76,{14:1},E1),oe(Of,"Window/WindowHandlers",159),re(114,1,Od);var mW=!1;oe(vl,"DOMImpl",114),re(695,114,Od),ee.Be=function(y,k){for(var z=0,E=y.firstChild;E;){if(E.nodeType==1){if(k==z)return E;++z}E=E.nextSibling}return null},ee.Ce=function(y){for(var k=0,z=y.firstChild;z;)z.nodeType==1&&++k,z=z.nextSibling;return k},ee.De=function(){xT()},ee.Ee=function(y,k,z){for(var E=0,j=y.firstChild,te=null;j;){if(j.nodeType==1){if(E==z){te=j;break}++E}j=j.nextSibling}y.insertBefore(k,te)},ee.Fe=function(y){$l(this),Yf==y&&(Yf=null)},ee.Ge=function(y){$l(this),Yf=y},ee.He=function(y,k){var z,E;$l(this),z=gx,E=z[k]||z._default_,y.addEventListener(k,E,!1)},ee.Ie=function(y,k){$l(this),cz(y,k)};var gx,Yf,wx,hn,yW;oe(vl,Xz,695),re(472,695,Od,P3),ee.De=function(){xT(),nG()},ee.Ie=function(y,k){$l(this),cz(y,k),k&Y0&&y.addEventListener(P2,(Sf(),hn),!1)},oe(vl,Wz,472),re(696,695,Od),oe(vl,Kz,696),re(473,696,Od,R3),oe(vl,Lz,473),re(170,1,{170:1},w4),ee.Je=function(){return ae.location.hash},oe(vl,"WindowImpl",170),re(550,170,{170:1},v4),ee.Je=function(){var y=ae.location.href,k=y.indexOf("#");return k>0?y.substring(k):""},oe(vl,"WindowImplMozilla",550),re(679,13,Dr),ee.rd=function(){jm(this,(J1(),xW))},ee.sd=function(){jm(this,(J1(),CW))},oe(nt,"Panel",679),re(154,679,Dr),ee.Ke=function(){return new bg(this.o)},ee.Le=function(y){return om(this,y)},oe(nt,"ComplexPanel",154),re(348,154,Dr),ee.Le=function(y){return uv(this,y)},oe(nt,"AbsolutePanel",348),re(276,196,M2,FC);var xW,CW;oe(nt,"AttachDetachException",276),re(277,1,{},m4),ee.Me=function(y){y.vd()},oe(nt,"AttachDetachException/1",277),re(278,1,{},y4),ee.Me=function(y){y.xd()},oe(nt,"AttachDetachException/2",278),re(476,154,Dr),oe(nt,"CellPanel",476),re(683,13,q2),ee.ud=function(){return iI(this)},ee.vd=function(){eq(this),this.Uc!=-1&&(HD(this.bb,this.Uc),this.Uc=-1),this.bb.vd(),fe(),this.Xc.__listener=this,Sa(this,!0)},ee.wd=function(y){cs(this,y),this.bb.wd(y)},ee.xd=function(){try{Sa(this,!1)}finally{this.bb.xd()}},ee.nd=function(){return xs(this,this.bb.nd()),fe(),this.Xc},oe(nt,"Composite",683),re(636,1,{},_I),ee.c=!1,oe(nt,"DirectionalTextHelper",636),re(88,154,Dr,nf),oe(nt,"FlowPanel",88),re(130,679,Dr),ee.Ne=function(){return fe(),this.Xc},ee.Ke=function(){return new _7(this)},ee.Le=function(y){return Bv(this,y)},ee.Oe=function(y){b9(this,y)},oe(nt,"SimplePanel",130);var r1,kW,SW,IW;re(237,13,Pr),oe(nt,"LabelBase",237),re(551,237,Pr),oe(nt,"Label",551),re(144,551,Pr,Ra,sI),oe(nt,"HTML",144);var AW;re(699,1,{}),oe(nt,"HasHorizontalAlignment/AutoHorizontalAlignmentConstant",699),re(141,699,{},lg),oe(nt,"HasHorizontalAlignment/HorizontalAlignmentConstant",141),re(167,1,{},o5),oe(nt,"HasVerticalAlignment/VerticalAlignmentConstant",167),re(240,13,Pr,R8),ee.wd=function(y){fe(),Hn((be(),y).type)==gl&&this.a&&(this.Xc[Xd]=""),cs(this,y)},ee.yd=function(){qq(this.a,this)},oe(nt,"Image",240),re(571,1,{}),ee.a=null,oe(nt,"Image/State",571),re(572,1,Et,h6),ee.Kd=function(){var y;if(!(this.b.a!=this.a||this!=this.a.a)){if(this.a.a=null,!this.b.Tc){bk(this.b)[Xd]=Td;return}y=d_(ue),gN(bk(this.b),y)}},oe(nt,"Image/State/1",572),re(241,571,{},hT),oe(nt,"Image/UnclippedState",241),re(522,209,ku,zA),oe(nt,"ListBox",522),re(138,13,Pr,Pk),ee.Pe=function(){(yh(),r1).Ze((fe(),this.Xc))},ee.wd=function(y){var k,z;switch(k=MF(this,(fe(),(be(),Ie).Ud(y))),Hn(y.type)){case 1:{(yh(),r1).Ze(this.Xc),k&&nm(this,k,!0);break}case 16:{k&&LA(this,k,!0);break}case 32:{k&&LA(this,null,!1);break}case 2048:{gf(this);break}case 128:{switch(z=y.keyCode|0,z=z,z){case 37:t_(this),y.stopPropagation(),Ie.Vd(y);break;case 39:HR(this),y.stopPropagation(),Ie.Vd(y);break;case 38:e_(this),y.stopPropagation(),Ie.Vd(y);break;case 40:PR(this),y.stopPropagation(),Ie.Vd(y);break;case 27:Mo(this,null),y.stopPropagation(),Ie.Vd(y);break;case 9:Mo(this,null);break;case 13:gf(this)||(nm(this,this.g,!0),y.stopPropagation(),Ie.Vd(y))}break}}cs(this,y)},ee.xd=function(){S0(this)},ee.c=!1,ee.e=!0,ee.i=!1,oe(nt,"MenuBar",138),re(402,1,Et,s5),ee.Kd=function(){this.a.Kd()},oe(nt,"MenuBar/1",402),re(403,1,{717:1,27:1},c5),ee.oe=function(y){Mo(this.a,null)},oe(nt,"MenuBar/2",403),re(97,12,{16:1,97:1,12:1},cS,Am),ee.Ad=function(y){y?vt(this,Fi((fe(),this.Xc))+"-"+j2,!1):vt(this,Fi((fe(),this.Xc))+"-"+j2,!0),this.b=y},ee.b=!0,oe(nt,"MenuItem",97),re(108,130,Dr),ee.Ne=function(){return li._e(T7((fe(),this.Xc)))},ee.md=function(){return li.af((fe(),fe(),Yr(this.Xc)))},ee.Qe=function(){this.Re(!1)},ee.Re=function(y){yI(this)},ee.zd=function(){this.M&&Zm(this.L,!1,!0)},ee.od=function(y){Gw(this,y)},ee.Se=function(y,k){j9(this,y,k)},ee.Oe=function(y){BC(this,y)},ee.qd=function(y){U8(this,y)},ee.u=!1,ee.v=!1,ee.F=!1,ee.G=!1,ee.H=0,ee.I=!1,ee.K=!1,ee.M=!1,ee.N=0;var li;oe(nt,"PopupPanel",108),re(322,1,{713:1,27:1},x4),ee.xe=function(y){oV()},oe(nt,"PopupPanel/1",322),re(323,1,Hb,u5),ee.Ae=function(y){MG(this.a,y)},oe(nt,"PopupPanel/3",323),re(324,1,{725:1,27:1},l5),oe(nt,"PopupPanel/4",324),re(320,131,{},lS),ee.cd=function(){_9(this)},ee.dd=function(){this.d=VR(this.a),this.e=zR(this.a),Re(this.a).style[qr]=dt,XT(this,(1+ae.Math.cos(V2))/2)},ee.ed=function(y){XT(this,y)},ee.a=null,ee.b=!1,ee.c=!1,ee.d=0,ee.e=-1,ee.i=!1,oe(nt,"PopupPanel/ResizeAnimation",320),re(321,44,{},KS),ee.kd=function(){this.a.g=null,Da(this.a,200,jr())},oe(nt,"PopupPanel/ResizeAnimation/1",321),re(134,348,Hz,Yw);var TW,Eu,Sl;oe(nt,"RootPanel",134),re(349,1,{},C4),ee.Me=function(y){y.ud()&&y.xd()},oe(nt,"RootPanel/1",349),re(213,1,$z,Dp),ee.we=function(y){rB()},oe(nt,"RootPanel/2",213),re(212,134,Hz,Cw),oe(nt,"RootPanel/DefaultRootPanel",212),re(325,1,{},_7),ee.Ve=function(){return tq(this)},ee.Ue=function(){return this.a},ee.We=function(){this.b&&Bv(this.c,this.b)},ee.a=!1,ee.b=null,oe(nt,"SimplePanel/1",325),re(523,209,ku),ee.wd=function(y){var k;k=(fe(),Hn((be(),y).type)),k&896?cs(this,y):cs(this,y)},ee.yd=function(){},oe(nt,"ValueBoxBase",523),re(234,523,ku),oe(nt,"TextBoxBase",234),re(565,234,ku),oe(nt,"TextArea",565),re(143,234,ku,ia),oe(nt,"TextBox",143),re(65,4,Wd);var VW,zW,EW,jW,VQ=We(nt,"ValueBoxBase/TextAlignment",65,SB);re(524,65,Wd,d7),We(nt,"ValueBoxBase/TextAlignment/1",524,null),re(525,65,Wd,A7),We(nt,"ValueBoxBase/TextAlignment/2",525,null),re(526,65,Wd,uS),We(nt,"ValueBoxBase/TextAlignment/3",526,null),re(527,65,Wd,OS),We(nt,"ValueBoxBase/TextAlignment/4",527,null),re(477,476,Dr,zT),ee.Le=function(y){return KA(this,y)},oe(nt,"VerticalPanel",477),re(512,1,{},_8),ee.Ke=function(){return new bg(this)},ee.c=0,oe(nt,"WidgetCollection",512),re(233,1,{},bg),ee.Ve=function(){return cq(this)},ee.Ue=function(){return this.b<this.c.c},ee.We=function(){if(!this.a)throw we(new uh);this.c.b.Le(this.a),--this.b,this.a=null},ee.b=0,oe(nt,"WidgetCollection/WidgetIterator",233),re(145,1,{145:1},k4),ee.Xe=function(y){y.blur()},ee.Ye=function(){var y;return y=Oe(ue),y.tabIndex=0,y},ee.Ze=function(y){y.focus()};var Zf,OW;oe(Rf,"FocusImpl",145),re(147,145,Uz,_3),ee.Ye=function(){return PU(vx||(vx=kF()))};var vx;oe(Rf,"FocusImplStandard",147),re(638,147,Uz,B3),ee.Xe=function(y){ae.setTimeout(function(){y.blur()},0)},ee.Ze=function(y){ae.setTimeout(function(){y.focus()},0)},oe(Rf,"FocusImplSafari",638),re(172,1,{172:1},S4),ee.$e=function(){return Oe(ue)},ee._e=function(y){return y},ee.af=function(y){return qt((be(),y))},ee.bf=function(y,k){y.style.clip=k},oe(Rf,"PopupImpl",172),re(554,172,{172:1},D3),ee.$e=function(){var y;return y=(fe(),Oe(ue)),Ip&&(y.innerHTML="<div></div>",Ct((ut(),pt),new h5(y))),y},ee._e=function(y){return Ip?Ba((be(),y)):y},ee.af=function(y){return Ip?y:qt((be(),y))},ee.bf=function(y,k){y.style.clip=k,y.style[Pt]=(It(),tn),y.style[Pt]=""};var Ip=!1;oe(Rf,"PopupImplMozilla",554),re(555,1,Et,h5),ee.Kd=function(){this.a.style[qr]=(ts(),Tu)},oe(Rf,"PopupImplMozilla/1",555),re(358,1,{},SI),oe(Iu,"SimpleEventBus/1",358),re(359,1,{714:1},II),ee.Kd=function(){IP(this.a,this.d,this.c,this.b)},oe(Iu,"SimpleEventBus/2",359),re(360,1,{714:1},wI),ee.Kd=function(){G9(this.a,this.d,this.c,this.b)},oe(Iu,"SimpleEventBus/3",360),re(53,1,{53:1},ff,mf),ee.cf=function(){return Gu(this.n.a,this.c)},ee.df=function(){ah(this.d,qe+this.c+Ye+this.k+" cell "+this.b)},ee.b="cs0",ee.c=0,ee.f=!1,ee.g=!0,ee.i=!1,ee.k=0,oe(Ae,"Cell",53),re(112,1,{112:1},ya),ee.Yc=function(y){var k;return this===y?!0:y==null||!ze(y,112)?!1:(k=y,this.d==k.d&&this.a==k.a&&es(he(this.c),he(k.c))&&es(he(this.b),he(k.b)))},ee.$c=function(){return rm(Se(Ce(Ke,1),ve,1,5,[this.d,this.a,he(this.c),he(this.b)]))},ee.b=0,ee.c=0,oe(Ae,"Cell/CellValueStyleKey",112),re(160,108,Dr),ee.Qe=function(){Pn(this,!1)},ee.Re=function(y){Pn(this,y)},ee.vd=function(){var y,k;k=mx,k&&(y=k.ff(),xe(y,(fe(),this.Xc))),ud(this)},ee.xd=function(){S0(this),this.t&&lt(this.t)},ee.od=function(y){V1(this,y)},ee.Se=function(y,k){ll(this,y,k)},ee.ef=function(y){(fe(),this.Xc).style[ot]=y?ni:dt,this.t&&(this.t.style[ot]=y?ni:dt)},ee.qd=function(y){Eg(this,y)};var Ap=2e4,mx,eh=-1,th=-1;oe(Pf,"Overlay",160),re(135,160,Dr),ee.ff=function(){return nB(this),Mh(jn(hh(this.mg)),"Could not determine ApplicationConnection for Overlay. Overlay will be attached directly to the root panel"),Re((ci(),uu()))},oe(nn,"VOverlay",135),re(113,135,Dr,wa,oI,Ak),ee.ff=function(){var y;return y=(fe(),ue.getElementById(Gz)),y||(ci(),ue.body)},oe(Ae,"SpreadsheetOverlay",113),re(165,113,{18:1,14:1,9:1,16:1,31:1,19:1,12:1,13:1,165:1},v2),ee.Qe=function(){Pl(this)},ee.ef=function(y){(fe(),this.Xc).style[ot]=y?ni:dt,this.t&&(this.t.style[ot]=y?ni:dt),this.i.style[ot]=(y?(at(),er):(at(),Zi)).ie()},ee.b=0,ee.d=0,ee.k=0,ee.n=0,oe(Ae,"CellComment",165),re(394,1,Yz,f6),ee.pe=function(y){pD(this.b,this.a)},oe(Ae,"CellComment/1",394),re(191,1,{191:1,3:1},qp),ee.equals=function(y){var k;return this===y?!0:!(y==null||zQ!=cu(y)||(k=y,this.col!=k.col)||this.row!=k.row)},ee.Yc=function(a){return this.equals(a)},ee.hashCode=function(){var y;return y=this.row+((this.col+1)/2|0),31*(this.col+y*y)},ee.$c=function(){return this.hashCode()},ee.toString=function(){return rt(rt(rt(Go(rt(Go(rt(new Bi,"r"),this.row),"c"),this.col),this.cellStyle),"|"),this.value).a},ee._c=function(){return this.toString()},ee.cellStyle="cs0",ee.col=0,ee.isPercentage=!1,ee.locked=!1,ee.needsMeasure=!1,ee.row=0;var zQ=oe(Ae,"CellData",191);re(96,88,U2),ee.wd=function(y){(be(),Ie).Vd(y),y.stopPropagation(),Ie.Qd(y)==1&&(this.c.mf(this.hf(),this.e,!this.b),jT(this,!this.b))},ee.b=!1,ee.d=0,ee.e=0,ee.f=!1,ee.g=0,ee.i=0,ee.j=0,ee.k=0,ee.n=0,oe(Ae,"GroupingWidget",96),re(238,96,U2,Rg),ee.gf=function(){var y;return y=new Rg(this.e,this.c),TV(this,y),y},ee.hf=function(){return!0},ee.jf=function(y){(fe(),this.Xc).style[ii]=y+(tt(),ke),this.i=y},ee.kf=function(y,k){this.k=9+k*18,this.g=y,(fe(),this.Xc).style[fn]=this.k+(tt(),ke),this.Xc.style[vn]=y+ke},ee.lf=function(y){(fe(),this.Xc).style[mt]=y+(tt(),ke),this.n=y},oe(Ae,"ColumnGrouping",238),re(639,1,{},d5),oe(Ae,"CopyPasteHandlerImpl",639),re(566,565,{18:1,27:1,14:1,182:1,9:1,60:1,73:1,16:1,19:1,12:1,13:1},NT),ee.Ae=function(y){var k;k=y.d,_g((be(),k).type)==128&&pG(this,k)},oe(Ae,"CopyPasteTextBox",566),re(567,1,{},d6),ee.Jd=function(){return Ar(this.a.c),Re(this.a).style[vn]=(tt(),"-1000.0px"),kh(this.b)==67?this.a.a:kh(this.b)==88&&uB(this.a.a),!1},oe(Ae,"CopyPasteTextBox/1",567),re(568,1,{},a5),ee.Jd=function(){var y,k;return y=(k=Gt(this.a),k??""),VM(this.a.a,y),Ar(this.a.c),!1},oe(Ae,"CopyPasteTextBox/2",568),re(376,683,q2,iz),ee.f=!1,ee.g=!1,ee.k=-1,ee.n=-1,ee.o=-1,ee.p=-1,ee.q=-1,ee.s=-1,ee.u=!1,ee.v=!1,ee.A=null;var ri,Tp=oe(Ae,"FormulaBarWidget",376);re(377,1,Ds,b5),ee.wd=function(y){Ii(this.a.a,Jq(this.a.B)),BI(this.a)},oe(Ae,"FormulaBarWidget/1",377),re(382,1,Et,p5),ee.Kd=function(){this.a.f&&(this.a.s=-1,this.a.q=Is(this.a.e),Af(this.a))},oe(Ae,"FormulaBarWidget/10",382),re(383,44,{},LS),ee.kd=function(){this.a.d=null},oe(Ae,"FormulaBarWidget/11",383),re(220,1,Et,fg),ee.Kd=function(){var y;this.a.f&&(o2(this.a,(y=Gt(this.a.e),y??"")),Af(this.a))},oe(Ae,"FormulaBarWidget/12",220),re(378,1,Ds,f5),ee.wd=function(y){var k,z,E;E=(fe(),Hn((be(),y).type)),E==512?(k=y.keyCode|0,k==13?(BI(this.a),$v(this.a,(z=Gt(this.a.a),z??"")),Wh(this.a.a,!1)):k==27&&(K7(this.a),Ar(this.a.t.V))):E==2048?(x1(this.a.t,!0),Re(this.a.a).style[J2]=(Kh(),vn)):(x1(this.a.t,!1),Re(this.a.a).style[J2]="")},oe(Ae,"FormulaBarWidget/2",378),re(379,1,Ds,g5),ee.wd=function(y){var k;switch(fe(),Hn((be(),y).type)){case 2048:this.a.f&&this.a.e==this.a.w?(this.a.f=!1,ra(this.a,this.a.j)):(x1(this.a.t,!0),this.a.c=(k=Gt(this.a.j),k??""),fq(this.a.t),ra(this.a,this.a.j));break;case 4096:this.a.f||(x1(this.a.t,!1),sD(this.a.t,(k=Gt(this.a.j),k??"")));break;case 128:JG(this.a,y);break;case Br:case 256:Yg(this.a),rs(this.a,!0),VB(this.a);break;case 8:this.a.f&&rs(this.a,!0)}},oe(Ae,"FormulaBarWidget/3",379),re(216,1,Et,hg),ee.Kd=function(){var y,k,z,E;this.a.f&&(E=(z=Gt(this.a.e),z??""),k=Is(this.a.e),y=k>0?(Tt(k-1,E.length),E.charCodeAt(k-1)):0,this.a.g=!1,y==40||y==43||y==45||y==47||y==42?this.a.g=!0:y==61&&E.length==1&&(this.a.g=!0))},oe(Ae,"FormulaBarWidget/4",216),re(380,1,Et,w5),ee.Kd=function(){var y;Wh(this.a.e,!0),pB(Re(this.a.e),this.a.q,0),o2(this.a,(y=Gt(this.a.e),y??"")),Af(this.a)},oe(Ae,"FormulaBarWidget/5",380),re(217,44,{},Gg),ee.kd=function(){var y;$6(this.a.t,(y=Gt(this.a.j),y??""))},oe(Ae,"FormulaBarWidget/6",217),re(218,1,Et,dg),ee.Kd=function(){var y;$6(this.a.t,(y=Gt(this.a.j),y??""))},oe(Ae,"FormulaBarWidget/7",218),re(219,1,Et,ag),ee.Kd=function(){var y;this.a.e&&(y=Gt(this.a.e),y??"").length==0&&(this.a.e==this.a.w?ow(this.a):Xh(this.a))},oe(Ae,"FormulaBarWidget/8",219),re(381,1,Et,a6),ee.Kd=function(){var y,k;this.a.f||(k=(y=Gt(this.b),y??""),(ye(k.substr(0,1),"=")||ye(k.substr(0,1),"+"))&&(this.a.f=!0,this.a.e=this.b,o2(this.a,k),Af(this.a)))},oe(Ae,"FormulaBarWidget/9",381),re(171,53,{53:1,171:1},b7),ee.cf=function(){return this.d.clientWidth|0},ee.df=function(){ah(this.d,qe+this.c+Ye+this.k+" cell "+this.b+" "+gs)},oe(Ae,"MergedCell",171),re(71,1,{71:1,3:1},vs),ee.col1=0,ee.col2=0,ee.id=0,ee.row1=0,ee.row2=0,oe(Ae,"MergedRegion",71),re(192,1,{192:1,3:1},Fp),ee.col=0,ee.dx=0,ee.dy=0,ee.height=0,ee.row=0,ee.type="IMAGE",ee.width=0;var EQ="COMPONENT",jQ="IMAGE";oe(Ae,"OverlayInfo",192),re(563,143,ku,L9),ee.wd=function(y){var k;fe(),Hn((be(),y).type)==Br&&Ct((ut(),pt),new v5(this)),k=Hn(y.type),k&896?cs(this,y):cs(this,y)},oe(Ae,"PasteAwareTextBox",563),re(564,1,Et,v5),ee.Kd=function(){Tv(this.a.a)},oe(Ae,"PasteAwareTextBox/1",564);var OQ=ur(Ae,"PopupButtonClientRpc");ur(Bf,"Connector"),re(267,1,Nd),ee.nf=function(){return On(this)},ee.pf=function(y){return Fa(this,y)},ee.qf=function(){return Je(this)},ee.rf=function(y){WT(this,y)},ee.sf=function(y){G8(this,y)},ee.H=!0,oe(nn,"AbstractConnector",267),re(268,267,Nd),ee.qf=function(){return this.uf()},ee.tf=function(){return dd(this)},ee.uf=function(){return!this.K&&(this.K=this.nf()),this.K},ee.vf=function(){return pi(this)},ee.wf=function(){var y,k,z;!this.n&&(k=this.qf().pb,!!k&&k.contains("cClick"))?(this.n=Xn(this.vf(),new F5(this),(Du(),Du(),xl)),(ei(),!Ht&&(Ht=new co),ei(),Ht).b&&(z=this.vf(),this.w=Xn(z,new A6(this,z),(qu(),qu(),Cl)),this.v=Xn(z,new q5(this),(Rw(),Rw(),i1)),this.u=Xn(z,new H5(this),(Ow(),Ow(),n1)))):this.n&&(y=this.qf().pb,!(y&&y.contains("cClick")))&&(Sr(this.n.a),this.n=null,iF(this))},ee.xf=function(){var y;return y=this.uf(),y.fb!=null&&y.fb.length!=0?!0:y.ib!=null&&y.ib.length!=0},ee.rf=function(y){AV(this,y)},ee.yf=function(){var y;y=this.vf(),x$((fe(),y.Xc),Fi(y.md())+"-error",this.uf().hb)},ee.sf=function(y){G8(this,y),L$(this,cI(this))},ee.k=20,ee.n=null,ee.o="",ee.p="",ee.r=!1,ee.t=!1,ee.A=0,ee.B=0;var ju=oe(nn,"AbstractComponentConnector",268);re(155,268,Nd),oe(nn,"AbstractHasComponentsConnector",155),re(328,155,{181:1,665:1,27:1,99:1,121:1,3:1},B7),ee.uf=function(){return!this.K&&(this.K=On(this)),this.K},ee.qf=function(){return!this.K&&(this.K=On(this)),this.K},ee.vf=function(){return!this.C&&(this.C=new Ls),this.C},ee.tf=function(){return new Ls},ee.pf=function(y){return this.b},ee.pe=function(y){var k;k=(!this.C&&(this.C=new Ls),this.C),MB(this.b,k.k,k.b)},ee.we=function(y){var k;k=(!this.C&&(this.C=new Ls),this.C),k.Tc&&NB(this.b,k.k,k.b)},ee.rf=function(y){var k,z;z=(!this.C&&(this.C=new Ls),this.C),k=(!this.K&&(this.K=On(this)),this.K),(y.Df(qe)||y.Df("row"))&&Ct((ut(),pt),new b6(z,k)),y.Df(Y2)&&H7(z,k.active),y.Df("popupHeight")&&a8(z,k.popupHeight),y.Df("popupWidth")&&b8(z,k.popupWidth),y.Df("headerHidden")&&wC(z,k.headerHidden)},oe(Ae,"PopupButtonConnector",328),re(329,1,ve,I4),oe(Ae,"PopupButtonConnector/1",329),re(330,1,Et,b6),ee.Kd=function(){yH(this.b,this.a.row,this.a.col)},oe(Ae,"PopupButtonConnector/2",330),re(354,13,Pr,yV),ee.wd=function(y){En(Kr(y),this.b)?(Pn(this.c,!1),Ar(this.e)):cs(this,y)},oe(Ae,"PopupButtonHeader",354),ur(Ae,"PopupButtonServerRpc"),re(75,1,{75:1,3:1}),ee.ob=!0;var Ou=oe(tp,"SharedState",75);re(67,75,tE),ee.db=null,ee.eb=!1,ee.fb="",ee.hb=null,ee.ib=null,ee.jb="",ee.kb=null,ee.lb=null,ee.mb=null,ee.nb="";var In=oe(Bf,"AbstractComponentState",67);re(193,67,{193:1,67:1,75:1,3:1},Cg),ee.active=!1,ee.col=0,ee.headerHidden=!1,ee.popupHeight=null,ee.popupWidth=null,ee.row=0,oe(Ae,"PopupButtonState",193),re(70,209,{181:1,18:1,27:1,14:1,9:1,60:1,73:1,16:1,19:1,12:1,13:1,70:1},Ls),ee.pe=function(y){Pv(this),Yo(y.a)},ee.xd=function(){Pn(this.e,!1),F7(this),S0(this)},ee.pd=function(y,k){Sn((fe(),this.Xc),y,k),vt(this.e,y,k)},ee.b=0,ee.k=0,oe(Ae,"PopupButtonWidget",70),re(318,1,{},m5),ee.Te=function(y,k){var z,E,j,te,ne;te=Nl(this.a.j),z=(be(),Ie).Xd(te)+((te.offsetHeight||0)|0),E=Ie.Wd(te)+((te.offsetWidth||0)|0),j=E-y,j<bi(this.a.n)&&(j=E),ne=z,ne+k>gi(this.a.n)&&(ne=Ie.Xd(te)-k),ne<Vn(this.a.n)&&(ne=Vn(this.a.n)),ll(this.a.e,j,ne)},oe(Ae,"PopupButtonWidget/1",318),re(319,1,Et,y5),ee.Kd=function(){$h(this.a.e,this.a.a)},oe(Ae,"PopupButtonWidget/2",319),re(239,96,U2,Pg),ee.gf=function(){var y;return y=new Pg(this.e,this.c),TV(this,y),y},ee.hf=function(){return!1},ee.jf=function(y){(fe(),this.Xc).style[ps]=y+(tt(),ke),this.j=y},ee.kf=function(y,k){this.g=6+k*15,this.k=y,(fe(),this.Xc).style[vn]=this.g+(tt(),ke),this.Xc.style[fn]=y+ke},ee.lf=function(y){(fe(),this.Xc).style[Bt]=y+(tt(),ke),this.d=y},oe(Ae,"RowGrouping",239),re(393,1,{},y6),ee.a=0,ee.b=0,oe(Ae,"SelectionHandler",393),re(405,683,q2,nV),ee.od=function(y){},ee.qd=function(y){},ee.c=0,ee.d=0,ee.e=0,ee.f=0,ee.g=!1,ee.i=!1,ee.j=!1,ee.k=0,ee.n=0,ee.o=!1,ee.p=!1,ee.r=0,ee.s=!1,ee.t=0,ee.u=0,ee.v=0,ee.w=0,ee.C=!1,ee.G=0,ee.H=0,ee.I=0,ee.J=0,ee.K=0,ee.L=0,ee.N=!1,ee.O=0,ee.P=0,ee.R=!1,ee.S=!1,ee.T=!1,ee.U=0,ee.V=0,ee.Y=0,ee.Z=0,ee._=!1,ee.ab=0,oe(Ae,"SelectionWidget",405),re(407,44,{},MS),ee.kd=function(){var y,k,z,E,j,te,ne,ie,se;wo(this.a.Q.zc,((this.a.Q.zc.scrollTop||0)|0)+(this.a.n/2|0)),Zr(this.a.Q.zc,dn(this.a.Q.zc)+(this.a.k/2|0)),Rc(this.a.Q),ne=this.a.c,ie=this.a.d,this.a.k<0?ne=bi(this.a.Q.zc)+5:this.a.k>0&&(ne=qi(this.a.Q.zc)-25),this.a.n<0?ie=Vn(this.a.Q.zc)+5:this.a.n>0&&(ie=gi(this.a.Q.zc)-25),this.a.n!=0&&!((this.a.Q.zc.scrollTop||0)|0)&&(j=new ru,Ms(j,this.a.Q.Fc),E=Vn(this.a.Q.Fc)+j.d[0]+5,this.a.d>E?ie=this.a.d:ie=E),this.a.k!=0&&dn(this.a.Q.zc)==0&&(j=new ru,Ms(j,this.a.Q.Fc),z=bi(this.a.Q.Fc)+j.d[3]+5,this.a.c>z?ne=this.a.c:ne=z),this.a.C?xH(this.a,ne,ie):(se=e0(ne,ie),se&&(y=(be(),se).getAttribute(Gi)||"",Mr(this.a.Q.wb,y),k=this.a.Q.wb.a,te=this.a.Q.wb.b,k!=0&&te!=0&&bd(this.a.Q.a,k,te)))},oe(Ae,"SelectionWidget/1",407),re(408,1,Et,x5),ee.Kd=function(){dV(this.a,!0),Pn(this.a.$,!1)},oe(Ae,"SelectionWidget/2",408),re(409,1,Et,C5),ee.Kd=function(){$h(this.a.$,new k5(this)),eu(this.a.$)},oe(Ae,"SelectionWidget/3",409),re(410,1,{},k5),ee.Te=function(y,k){var z,E,j,te,ne;te=0,E=0,z=0,ne=0,j=0,this.a.a.X&&rn(this.a.a.X)?(te=Vn(this.a.a.X.G),E=bi(this.a.a.X.G),ne=this.a.a.X.G.clientWidth|0,z=gi(this.a.a.X.a)+5,rn(this.a.a.W)&&(ne+=this.a.a.W.G.clientWidth|0),rn(this.a.a.b)&&(z=gi(this.a.a.b.a)+5)):this.a.a.W&&rn(this.a.a.W)?(te=Vn(this.a.a.W.G),E=bi(this.a.a.W.G),ne=this.a.a.W.G.clientWidth|0,z=gi(this.a.a.W.a)+5,rn(this.a.a.a)&&(z=gi(this.a.a.a.a)+5)):this.a.a.a&&rn(this.a.a.a)?(te=Vn(this.a.a.a.G),E=bi(this.a.a.a.G),ne=this.a.a.a.G.clientWidth|0,z=gi(this.a.a.a.a)+5,rn(this.a.a.b)&&(ne+=this.a.a.b.G.clientWidth|0)):(te=Vn(this.a.a.b.G),E=bi(this.a.a.b.G),ne=this.a.a.b.G.clientWidth|0,z=gi(this.a.a.b.a)+5),ne>(Re(this.a.a.Q).clientWidth|0)&&(ne=Re(this.a.a.Q).clientWidth|0),this.a.a.Q.Sc>0?j=Vn(this.a.a.Q.Pc):j=Vn(this.a.a.Q.zc),te-=k+5,E+=(ne/2|0)-(y/2|0),j>te&&(te=z+5),ll(this.a.a.$,E,te)},oe(Ae,"SelectionWidget/3/1",410),re(140,13,Pr,fd),ee.b=0,ee.c=0,ee.e=0,ee.f=0,ee.g=0,ee.i=0,ee.n=0,ee.o=0,oe(Ae,"SelectionWidget/PaintOutlineWidget",140),re(139,13,Pr,ld),ee.b=!1,ee.e=0,ee.f=0,ee.j=0,ee.n=!1,ee.q=0,ee.r=0,ee.s=0,ee.t=0,ee.v=!1,ee.C=0,ee.D=0,ee.H=!1,ee.K=0,oe(Ae,"SelectionWidget/SelectionOutlineWidget",139),re(406,1,Ds,S5),ee.wd=function(y){var k,z,E;k=(fe(),(be(),Ie).Ud(y)),E=Hn(y.type),z=E==Bs||E==ui||E==wl||E==Au,this.a.F.C?(Hm(this.a,y),y.stopPropagation()):E==4?En(k,this.a.g)?(Hm(this.a,y),y.stopPropagation()):En(k,this.a.G)||En(k,this.a.k)||En(k,this.a.u)||En(k,this.a.a):z&&(E==ui||E==Au?(tf(this.a.B),WD(this.a.F)):En(k,this.a.g)||En(k,this.a.i)?E==Bs?(dh(this.a.B),hG(this.a.F,y)):vG(this.a.F,y):this.a.F.p&&Hm(this.a,y),Ie.Vd(y),y.stopPropagation())},oe(Ae,"SelectionWidget/SelectionOutlineWidget/1",406),re(640,1,Ds,A4),ee.wd=function(y){var k;if(eo(Kr(y)).indexOf(nE)!=-1){el(this.c,!0);return}if(k=(fe(),Hn((be(),y).type)),k==2048)el(this.c,!0),this.b=!0;else if(k==4096)el(this.c,!1),this.b=!1;else if(k==wl)y.stopPropagation();else if(this.c.xc)bl==k&&Rc(this.c),cH(this,y);else switch(k){case bl:Rc(this.c);break;case 256:gG(this,y);break;case 128:LG(this,y);break;case 4:Ie.Qd(y)!=2&&m2(this.c,y);break;case 8:Ie.Qd(y)==2&&m2(this.c,y);break;case 2:G$(this,y);break;case 32:case 16:UR(this.c,y);break;case 64:pP(this.c)}},ee.a=!1,ee.b=!1,oe(Ae,"SheetEventListener",640),re(569,1,{717:1,181:1,730:1,727:1,732:1,245:1,246:1,27:1},T4),ee.oe=function(y){var k;el(this.b,!1),this.a.f?rs(this.a,!1):this.b._&&(fA(this.b.a,(k=Gt(this.b.sb),k??"")),Zl(this.a)),Yo(y.a)},ee.pe=function(y){this.b._&&(this.a.v=!0),Yo(y.a)},ee.se=function(y){var k;qN(y.a)==2&&(k=this.b.wb,Mr(k,Hl(this.b)),xv(this.b.a,y.a,k.a,k.b)),Yo(y.a)},ee.te=function(y){rs(this.a,!1)},oe(Ae,"SheetInputEventListener",569),re(347,1,{},V4),ee.a=0,ee.b=0,oe(Ae,"SheetJsniUtil",347),re(235,130,{18:1,14:1,9:1,16:1,31:1,19:1,12:1,13:1,235:1},q9),ee.a=0,ee.b=0,oe(Ae,"SheetOverlay",235),re(300,13,Pr,rz),ee.b="",ee.d=!1,ee.j=!1,ee.r=-1,ee.s=0,ee.t=0,oe(Ae,"SheetTabSheet",300),re(301,1,Ds,I5),ee.wd=function(y){var k,z,E,j,te;if(E=Kr(y),te=(fe(),Hn((be(),y).type)),!En(E,this.a.g)){if(y.stopPropagation(),te==1){if(this.a.d&&!this.a.j&&Pm(this.a),ZI(this.a.e.V,!1),Io(this.a.i,E)&&!YI(E,dt))En(E,this.a.n)?(this.a.t=0,this.a.s=0,this.a.c.style[ii]=this.a.t+(tt(),ke),pu(this.a)):En(E,this.a.p)?(this.a.s>0&&(--this.a.s,this.a.s==0?this.a.t=0:this.a.t+=iu(this.a,this.a.s),this.a.c.style[ii]=this.a.t+(tt(),ke)),pu(this.a)):En(E,this.a.q)?this.a.s<this.a.u.length-1&&(this.a.t-=iu(this.a,this.a.s),this.a.c.style[ii]=this.a.t+(tt(),ke),++this.a.s,pu(this.a)):En(E,this.a.o)?(j=mR(this.a),Vm(this.a,j)):En(E,this.a.a)&&(this.a.j||DD(this.a.e));else if(Io(this.a.c,E))for(z=0;z<this.a.u.length;z++)En(this.a.u[z],E)&&z!=this.a.r&&d9(this.a.e,z)}else if(te==2&&!this.a.j)for(z=0;z<this.a.u.length;z++)En(this.a.u[z],E)&&(z!=this.a.r?d9(this.a.e,z):(this.a.d=!0,k=this.a.u[z],this.a.b=Ie._d(k),kC(this.a.g,this.a.b),Ie.de(k,""),xe(k,this.a.g),this.a.g.focus(),IV(this.a)))}},oe(Ae,"SheetTabSheet/1",301),re(302,1,Ds,A5),ee.wd=function(y){var k,z;if(z=(fe(),Hn((be(),y).type)),this.a.d)if(z==4096)Pm(this.a);else switch(y.keyCode|0){case 13:case 9:Pm(this.a);break;case 27:this.a.d=!1,lt(this.a.g),k=this.a.u[this.a.r],k.style[mt]="",sf(k,this.a.b),Ar(this.a.e.V);break;default:cR(this.a)}y.stopPropagation()},oe(Ae,"SheetTabSheet/2",302),re(303,1,Et,T5),ee.Kd=function(){IV(this.a)},oe(Ae,"SheetTabSheet/3",303),re(158,679,{18:1,14:1,9:1,16:1,31:1,19:1,12:1,13:1,158:1},oz),ee.Ke=function(){return dA(this)},ee.vd=function(){ud(this),tN(this.M),!this.M.Wc&&vC(this,this.M)},ee.zd=function(){Pn(this.qb,!1),Pn(this.Xb,!1),RR(this.M)},ee.Le=function(y){return gd(this,y)},ee.f=0,ee.g=0,ee.k=-1,ee.n=-1,ee.o=!1,ee.v=!0,ee.A=0,ee.B=0,ee.C=!0,ee.G=!1,ee.H=0,ee.L=!1,ee.O=!1,ee.P=!1,ee.R=!1,ee.V=-1,ee.X=0,ee.Y=0,ee.Z=!1,ee._=!1,ee.ab=!1,ee.bb=0,ee.cb=0,ee.db=0,ee.eb=0,ee.nb=null,ee.ob=0,ee.ub=null,ee.vb=!1,ee.xb=0,ee.yb=0,ee.zb=0,ee.Ab=0,ee.Bb=0,ee.Cb=0,ee.Db=!1,ee.Lb=0,ee.Ob=0,ee.Pb=0,ee.Sb=0,ee.Tb=0,ee.Zb=!1,ee.$b=-1,ee._b=-1,ee.ac=!1,ee.bc=!1,ee.ec=!1,ee.fc=0,ee.jc=!1,ee.nc=!1,ee.oc=0,ee.pc=0,ee.rc=0,ee.sc=0,ee.xc=!1,ee.Gc=!1,ee.Hc=!1,ee.Ic=!1,ee.Jc=0,ee.Kc=0,ee.Lc=0,ee.Oc=0,ee.Rc=!1,ee.Sc=0,oe(Ae,"SheetWidget",158),re(331,1,Et,V5),ee.Kd=function(){this.a.k!=-1&&this.a.n!=-1&&QT(this.a,this.a.k,this.a.n)},oe(Ae,"SheetWidget/1",331),re(340,1,Et,pI),ee.Kd=function(){var y,k;if(!this.a.jc){for(k=this.d;Cn(this.a.a,k);)--k;if(k!=0){for(dh(Re(this.a)),this.a.bc=!0,this.a._b=k,this.a.$b=-1,this.a._b<=this.a.Sc?y=Ze(this.a.jb,this.a._b-1):y=Ze(this.a.ic,k-this.a.db),this.a.Sb=(be(),Ie).Xd(y),this.a.Tb=Ie.Xd(y)+((y.offsetHeight||0)|0),ha(this.a.a,k)>0?sr(this.a.Yb,"Height: "+ha(this.a.a,k)+"pt"):sr(this.a.Yb,"Hide row"),pa(this.a,this.b,this.c),eu(this.a.Xb),Ue(this.a.Fc,IE),Ue(this.a.Vb,"row"+k),++k;this.d<this.a.a.O&&Cn(this.a.a,k);)++k;Ue(this.a.Ub,ny+k),ez(this.a,this.b,this.c)}}},ee.b=0,ee.c=0,ee.d=0,oe(Ae,"SheetWidget/10",340),re(341,1,Et,gI),ee.Kd=function(){var y,k;if(!this.a.L){for(k=this.d;Vo(this.a.a,k);)--k;if(!(k<1)){for(dh(Re(this.a)),this.a.ac=!0,this.a.$b=k,this.a._b=-1,this.a.$b<=this.a.ob?y=Ze(this.a.ib,this.a.$b-1):y=Ze(this.a.K,k-this.a.bb),this.a.Sb=(be(),Ie).Wd(y),this.a.Tb=Ie.Wd(y)+((y.offsetWidth||0)|0),Gu(this.a.a,k)>0?sr(this.a.Yb,"Width: "+Gu(this.a.a,k)+ke):sr(this.a.Yb,wE),pa(this.a,this.b,this.c),eu(this.a.Xb),Ue(this.a.Fc,AE),Ue(this.a.Vb,qe+k),++k;this.d<=this.a.a.i&&Vo(this.a.a,k);)++k;Ue(this.a.Ub,ty+k),JV(this.a,this.b,this.c)}}},ee.b=0,ee.c=0,ee.d=0,oe(Ae,"SheetWidget/11",341),re(342,1,{},p6),ee.Te=function(y,k){cG(this.a,y,k,this.b)},oe(Ae,"SheetWidget/12",342),re(132,1,Et,gh),ee.Kd=function(){var y,k;k=(y=Gt(this.a.sb),y??""),jG(this.a,k),this.b&&$L(this.a.a,k)},ee.b=!1,oe(Ae,"SheetWidget/13",132),re(343,1,Et,g6),ee.Kd=function(){Wh(this.a.sb,!0),Dh(this.b,"%")?Ym(this.a.sb,this.b.length-1,0):Ym(this.a.sb,this.b.length,0)},oe(Ae,"SheetWidget/14",343),re(133,1,Et,oh),ee.Kd=function(){this.a.zc.focus()},oe(Ae,"SheetWidget/15",133),re(344,1,Ds,w6),ee.wd=function(y){HC(this.a.a,!0,this.b)},ee.b=0,oe(Ae,"SheetWidget/16",344),re(345,1,Ds,v6),ee.wd=function(y){HC(this.a.a,!1,this.b)},ee.b=0,oe(Ae,"SheetWidget/17",345),re(346,1,Et,z5),ee.Kd=function(){var y,k,z,E,j,te,ne,ie,se,ce;ne=this.a.Nc.clientWidth|0,j=this.a.gc.clientWidth|0,ce=ne+j,j==0&&!$c(this.a.F)?ce-=1:j!=0&&!$c(this.a.F)||j!=0&&$c(this.a.F)&&(ce+=2),this.a.F.style[mt]=ce+(tt(),ke),te=this.a.Nc.clientHeight|0,k=this.a.I.clientHeight|0,z=te+k,k==0&&!$c(this.a.dc)||(k!=0&&!$c(this.a.dc)?z+=1:k!=0&&$c(this.a.dc)&&(z+=2)),this.a.dc.style[Bt]=z+ke,y=this.a.c.clientHeight|0,se=this.a.Pc.clientWidth|0,ie=se+ce,E=y+z,$c(this.a.F)&&(ie+=1),$c(this.a.dc)&&(E+=1),this.a.I.style[mt]=ie+ke,this.a.D.style[mt]=ie+ke,this.a.gc.style[Bt]=E+ke,this.a.cc.style[Bt]=E+ke},oe(Ae,"SheetWidget/18",346),re(332,1,Et,E5),ee.Kd=function(){var y,k,z,E,j;if(!this.a._&&(E=this.a.Hb,!!qt((be(),E))&&(j=eo(qt(E)).indexOf(yl)!=-1,y=E.getAttribute(Gi)||"",!ye(y.substr(0,20),Jz)))){if(y.indexOf(rp)!=-1&&(y=Zo(y,0,y.indexOf(" cell"))),ye(y,cE))E=HN(this.a.Gb),y=E.getAttribute(Gi)||"";else if(Ah(this.a.Gb)==16&&j){Mr(this.a.wb,y);try{if(k=this.a.wb.a,z=this.a.wb.b,k==0||z==0)return;E=K0(this.a,lu(this.a.Gb),fu(this.a.Gb),Rt(this.a,k,z)).d,y=E.getAttribute(Gi)||"",y.indexOf(rp)!=-1&&(y=Zo(y,0,y.indexOf(" cell")))}catch(te){if(te=Xt(te),ze(te,81))Tr(this.a.U,"SheetWidget:onSheetMouseOverOrOut: JSE while trying to find real event target, className:"+y);else if(ze(te,33))Mh(this.a.U,"SheetWidget:onSheetMouseOverOrOut: IOOBE while trying to find correct event target, className:"+y);else throw we(te)}}if(Mr(this.a.wb,y),ye(y,Kd)||ye(y,Ld)||ye(y,this.a.j)||LR(this.a,y)||xP(this.a,y)?nQ(this.a,this.a.Gb,E):!this.a.o&&this.a.q.M&&y.indexOf("comment")==-1&&(tf(this.a.zc),Pl(this.a.q),this.a.j=null,this.a.k=-1,this.a.n=-1),j&&this.a.s&&bn(this.a.s,y)){jH(this.a,Ah(this.a.Gb),this.a.wb.a,this.a.wb.b,Nt(this.a.s,y));return}else Qw(this.a.qb)&&Pn(this.a.qb,!1)}},oe(Ae,"SheetWidget/2",332),re(333,44,{},NS),ee.kd=function(){var y,k,z,E,j;wo(this.a.zc,((this.a.zc.scrollTop||0)|0)+(this.a.Y/2|0)),Zr(this.a.zc,dn(this.a.zc)+(this.a.X/2|0)),Rc(this.a),E=this.a.A,j=this.a.B,this.a.X<0?E=bi(this.a.zc)+5:this.a.X>0&&(E=qi(this.a.zc)-25),this.a.Y<0?j=Vn(this.a.zc)+5:this.a.Y>0&&(j=gi(this.a.zc)-25),this.a.Y!=0&&!((this.a.zc.scrollTop||0)|0)&&(z=new ru,Ms(z,this.a.Fc),k=Vn(this.a.Fc)+z.d[0]+5,this.a.B>k?j=this.a.B:j=k),this.a.X!=0&&dn(this.a.zc)==0&&(z=new ru,Ms(z,this.a.Fc),y=bi(this.a.Fc)+z.d[3]+5,this.a.A>y?E=this.a.A:E=y),WH(this.a,E,j)},oe(Ae,"SheetWidget/3",333),re(334,44,{},RS),ee.kd=function(){i0(this,this.a.db,this.a.zb,this.a.bb,this.a.xb),i0(this,0,this.a.Sc,0,this.a.ob),i0(this,0,this.a.Sc,this.a.bb,this.a.xb),i0(this,this.a.db,this.a.zb,0,this.a.ob),r0(this,this.a.db,this.a.zb,this.a.bb,this.a.xb),r0(this,0,this.a.Sc,0,this.a.ob),r0(this,0,this.a.Sc,this.a.bb,this.a.xb),r0(this,this.a.db,this.a.zb,0,this.a.ob)},oe(Ae,"SheetWidget/4",334),re(335,1,Et,j5),ee.Kd=function(){this.a.Db&&s2(this.a)},oe(Ae,"SheetWidget/5",335),re(336,1,Et,O5),ee.Kd=function(){NR(this.a)},oe(Ae,"SheetWidget/6",336),re(337,1,Et,p8),ee.Kd=function(){this.a.Lb==0&&Fg(this.a.Mb)&&(this.a.Lb=(this.a.Mb.offsetWidth||0)|0),RV(this.a),BV(this.a),LV(this.a),GV(this.a,this.b,this.c),d0(this.a),Hw(this.a.a,this.a.db,this.a.zb,this.a.bb,this.a.xb),X0(this.a),W0(this.a),E0(this.a),z0(this.a),PV(this.a),this.a.Db=!0},ee.b=0,ee.c=0,oe(Ae,"SheetWidget/7",337),re(338,1,Hb,X5),ee.Ae=function(y){var k,z,E,j,te,ne;if(z=Ah(y.d),te=y.d,ne=Kr(te),k="",ne&&ne.nodeType==1&&(k=(be(),ne).getAttribute(Gi)||""),Io(Re(this.a),Kr(te))&&(Bs==z||z==4||z==8||z==2||z==1)&&el(this.a,!0),(this.a.ac||this.a.bc)&&z==64)this.a.$b!=-1?JV(this.a,lu(te),fu(te)):this.a._b!=-1?ez(this.a,lu(te),fu(te)):(this.a.ac=!1,this.a.bc=!1),y.a=!0;else if(z==8&&hm(this,ne))(this.a.ac||this.a.bc||ye(k,ry)||ye(k,oy))&&(this.a.L=!0,this.a.jc=!0,this.a.ac=!1,this.a.bc=!1,ls(this.a.Wb),Pn(this.a.Xb,!1),y.a=!0,this.a.$b!=-1?(zt(this.a.Fc,AE),M$(this.a,lu(y.d))):this.a._b!=-1&&(zt(this.a.Fc,IE),aU(this.a,fu(y.d))));else if(Io(Re(this.a),ne)){if(z==1)E=bu(k),(E==1||E==2)&&(j=us(k),E==1?KG(this.a.a,j,!!(be(),te).shiftKey,!!te.metaKey||!!te.ctrlKey):WG(this.a.a,j,!!(be(),te).shiftKey,!!te.metaKey||!!te.ctrlKey),y.a=!0,this.a.zc.focus());else if(z==4&&hm(this,ne))ye(k,ry)?(k=eo(qt((be(),ne))),E=bu(k),E==1?(E=us(k),this.a.jc=!1,MI(this.a,E-1,lu(te),fu(te))):E==2&&(E=us(k),this.a.L=!1,LI(this.a,E-1,lu(te),fu(te))),y.a=!0):ye(k,oy)&&(k=eo(qt((be(),ne))),E=bu(k),E==1?(E=us(k),this.a.jc=!1,MI(this.a,E,lu(te),fu(te))):E==2&&(E=us(k),this.a.L=!1,LI(this.a,E,lu(te),fu(te))),y.a=!0);else if(z==2&&hm(this,ne)){if(ye(k,ry)){if(k=eo(qt((be(),ne))),E=bu(k),E==1){for(E=us(k)-1;Cn(this.a.a,E)&&E>0;)--E;E>0&&yC(this.a.a,E)}else if(E==2){for(E=us(k)-1;Vo(this.a.a,E)&&E>0;)--E;E>0&&mC(this.a.a,E)}y.a=!0}else if(ye(k,oy)){if(k=eo(qt((be(),ne))),E=bu(k),E==1){for(E=us(k);Cn(this.a.a,E)&&E>0;)--E;E>0&&yC(this.a.a,E)}else if(E==2){for(E=us(k);Vo(this.a.a,E)&&E>0;)--E;E>0&&mC(this.a.a,E)}y.a=!0}}}},oe(Ae,"SheetWidget/8",338),re(339,1,sy,W5),ee.qe=function(y){var k,z,E,j;this.a.a.R&&(j=Kr(y.a),k=(be(),j).getAttribute(Gi)||"",z=bu(k),(z==1||z==2)&&(E=us(k),z==1?YN(this.a.a,y.a,E):QN(this.a.a,y.a,E)),y.a&&ki(y.a),Yo(y.a))},oe(Ae,"SheetWidget/9",339),re(52,1,{52:1},Co),ee.Yc=function(y){return y==null||!ze(y,52)?!1:this.b==y.b&&this.a==y.a},ee.$c=function(){var y;return y=this.b+((this.a+1)/2|0),31*(this.a+y*y)},ee.a=0,ee.b=0,oe(Ae,"SheetWidget/CellCoord",52),re(174,13,Pr,f0),oe(Ae,"Slot",174),re(570,1,TE,m6),ee.ve=function(y){zq(this.b,this.a,y)},oe(Ae,"Slot/lambda$0$Type",570),re(125,1,VE),ee._c=function(){return"Action [owner="+this.g+", iconUrl="+this.f+", caption="+this.e+"]"},ee.e="",ee.f=null;var XQ=oe(nn,"Action",125);re(243,125,VE,tA),ee.Kd=function(){s9(this)},ee.a="",ee.c=0,oe(Ae,"SpreadsheetAction",243),re(194,1,{194:1,3:1},Hp),ee.type=0,oe(Ae,"SpreadsheetActionDetails",194);var mn=ur(Ae,"SpreadsheetClientRpc");re(279,155,Nd,IA),ee.uf=function(){return!this.K&&(this.K=new Cr),this.K},ee.qf=function(){return!this.K&&(this.K=new Cr),this.K},ee.vf=function(){return!this.C&&(this.C=new un),this.C},ee.nf=function(){return new Cr},ee.tf=function(){return new un},ee.pf=function(y){return this.i},ee.rf=function(y){ZV(this,y)},oe(Ae,"SpreadsheetConnector",279),re(280,1,{723:1,3:1},K5),oe(Ae,"SpreadsheetConnector/1",280),re(281,1,{},x6),oe(Ae,"SpreadsheetConnector/1/1",281),re(282,1,{},L5),oe(Ae,"SpreadsheetConnector/4",282),re(283,1,sy,z4),ee.qe=function(y){y.a&&ki(y.a),Yo(y.a)},oe(Ae,"SpreadsheetConnector/5",283),re(284,1,Et,C6),ee.Kd=function(){_V(this.a,this.b)},oe(Ae,"SpreadsheetConnector/6",284),re(286,1,{},M5),oe(Ae,"SpreadsheetConnector/7",286),re(285,1,{},k6),ee.zf=function(y,k){ZF(this.a,this.b,y,k)},oe(Ae,"SpreadsheetConnector/lambda$0$Type",285),re(395,135,Dr),ee.d=0,ee.f=0,oe(nn,"VContextMenu",395),re(396,395,Dr,eV),ee.ff=function(){var y;return y=(fe(),fe(),ue.getElementById(Gz)),y||(ci(),ue.body)},oe(Ae,"SpreadsheetOverlay/SpreadsheetContextMenu",396);var XW=ur(Ae,"SpreadsheetServerRpc");ur(Po,"Focusable"),re(28,683,{18:1,14:1,9:1,16:1,179:1,19:1,12:1,13:1,28:1},un),ee.mf=function(y,k,z){HA(this.W,y,k,z)},ee.od=function(y){O9(this,y)},ee.qd=function(y){X9(this,y)},ee.a=0,ee.c=!1,ee.d=!1,ee.e=!1,ee.i=0,ee.j=0,ee.o=!1,ee.q=0,ee.r=0,ee.t=!1,ee.B=!1,ee.C=!1,ee.D=!0,ee.F=!0,ee.K=!0,ee.L=0,ee.O=0,ee.P=!1,ee.T=!1,ee.X=0,ee.Y=0,ee.Z=!1,oe(Ae,"SpreadsheetWidget",28),re(294,1,ve,N5),oe(Ae,"SpreadsheetWidget/1",294),re(295,44,{},SC),ee.kd=function(){},oe(Ae,"SpreadsheetWidget/2",295),re(296,1,TE,R5),ee.ve=function(y){y.a?L7(this.b.V,this.a,this.c):(this.a=dn(this.b.V.zc),this.c=(this.b.V.zc.scrollTop||0)|0)},ee.a=0,ee.c=0,oe(Ae,"SpreadsheetWidget/3",296),re(297,1,Et,g8),ee.Kd=function(){L7(this.a.V,this.b,this.c)},ee.b=0,ee.c=0,oe(Ae,"SpreadsheetWidget/4",297),re(298,1,Et,S6),ee.Kd=function(){var y,k,z;if(DI(this.a),this.b){for(k=0;k<this.b.a.length;)z=Ze(this.b,k),qG(this.a.V,z),y=Rt(this.a.V,z.col1,z.row1),y&&Zu(y,y.o,y.b,!1),++k;T_(this.a.V)}this.b?this.a.J=new ef(this.b):this.a.J=null},oe(Ae,"SpreadsheetWidget/5",298),re(299,44,{},PS),ee.kd=function(){this.a.K=!0},oe(Ae,"SpreadsheetWidget/6",299),re(198,1,Et,Aw),ee.Kd=function(){this.a.c||(lf(this.a.W,this.a.V.sc,this.a.V.rc,this.c),du(this.a,this.c,this.b))},ee.b=!1,oe(Ae,"SpreadsheetWidget/7",198),re(236,1,{236:1,3:1},E4),ee.collapsed=!1,ee.endIndex=0,ee.level=0,ee.startIndex=0,ee.uniqueIndex=0,oe(jE,"GroupingData",236),re(126,67,{67:1,75:1,126:1,3:1}),oe(_d,"TabIndexState",126),re(45,126,{45:1,67:1,75:1,126:1,3:1},Cr),ee.d=null,ee.f=!1,ee.g=0,ee.j=0,ee.k=200,ee.n=null,ee.p=null,ee.q=0,ee.r=0,ee.s=!0,ee.t=!0,ee.u=!1,ee.v=null,ee.w=null,ee.B=0,ee.G="Invalid formula",ee.H=!0,ee.I=!0,ee.J=null,ee.K=null,ee.O=!1,ee.P=200,ee.R=!1,ee.S=0,ee.U=null,ee.V=0,ee.W=1,ee.X=null,ee.Y=!1,ee.Z=null,ee._=0,ee.bb=!1,ee.cb=!1,oe(jE,"SpreadsheetState",45);var yx;re(247,1,{},c8);var WW;oe(Po,"ApplicationConfiguration",247),re(210,1,{14:1,210:1},jA),ee.td=function(y){},ee.b=null,oe(Po,"ApplicationConnection",210),re(59,1,{},co),ee.b=!1;var Fr=null,Ht;oe(Po,"BrowserInfo",59),re(117,1,{},Dl),oe(Po,"ComputedStyle",117),re(682,681,{}),oe(dy,"AbstractServerConnectorEvent",682);var KW;re(482,1,{},tC),oe(Po,"ConnectorMap",482),re(84,1,{},ru),ee.b=-1,ee.e=-1,oe(Po,"MeasuredSize",84),re(544,1,{},j4),oe(Po,"MeasuredSize/MeasureResult",544),re(375,1,{},OV),oe(Po,"ResourceLoader",375),re(411,351,{},O4),ee.a=0,oe(Po,"VSchedulerImpl",411),re(412,1,Et,P5),ee.Kd=function(){this.a.a--},oe(Po,"VSchedulerImpl/lambda$0$Type",412);var xx;re(197,682,{},X8),ee.je=function(y){y.rf(this)},ee.le=function(){return Vp},ee.ke=function(){return Vp},ee.Df=function(y){return DT(this,y)},ee.b=!1;var Vp;oe(dy,"StateChangeEvent",197),re(656,1,{},W4),oe(dy,"URLReference_Serializer",656),re(168,1,{168:1}),ee.d=0,oe(kt,"AsyncBundleLoader",168),re(366,1,{});var An;oe(kt,"ConnectorBundleLoader",366),re(367,1,Yz,_5),ee.pe=function(y){br(this.a.e)},oe(kt,"ConnectorBundleLoader/lambda$0$Type",367),re(368,1,by,B5),ee.ue=function(y){br(this.a.e)},oe(kt,"ConnectorBundleLoader/lambda$1$Type",368),re(78,366,{},Xs),oe(kt,"ConnectorBundleLoaderXXImpl",78),re(483,168,{168:1},fI),oe(kt,"ConnectorBundleLoaderXXImpl/1",483),re(484,1,{},I6),oe(kt,"ConnectorBundleLoaderXXImpl/1/1",484),re(485,1,Kn,X4),ee.Ef=function(y,k){return new iT},oe(kt,"ConnectorBundleLoaderXXImpl/1/1/1",485),re(494,1,Kn,K4),ee.Ef=function(y,k){return new ig},oe(kt,"ConnectorBundleLoaderXXImpl/1/1/10",494),re(495,1,Kn,L4),ee.Ef=function(y,k){return new rg},oe(kt,"ConnectorBundleLoaderXXImpl/1/1/11",495),re(701,1,Kn),ee.Ef=function(y,k){var z,E,j,te,ne;for(z=[],j=k,te=0,ne=j.length;te<ne;++te)E=j[te],z.push(E);return this.Ff(y,z)},oe(kt,"JsniInvoker",701),re(496,701,Kn,M4),ee.Ff=function(y,k){return y.yf(),null},oe(kt,"ConnectorBundleLoaderXXImpl/1/1/12",496),re(497,701,Kn,N4),ee.Ff=function(y,k){return y.wf(),null},oe(kt,"ConnectorBundleLoaderXXImpl/1/1/13",497),re(498,701,Kn,R4),ee.Ff=function(y,k){return y.Hf(),null},oe(kt,"ConnectorBundleLoaderXXImpl/1/1/14",498),re(499,701,Kn,P4),ee.Ff=function(y,k){return y.If(),null},oe(kt,"ConnectorBundleLoaderXXImpl/1/1/15",499),re(500,701,Kn,_4),ee.Ff=function(y,k){return y.Jf(),null},oe(kt,"ConnectorBundleLoaderXXImpl/1/1/16",500),re(501,1,Kn,B4),ee.Ef=function(y,k){return new D4},oe(kt,"ConnectorBundleLoaderXXImpl/1/1/17",501),re(502,1,{},D4),oe(kt,"ConnectorBundleLoaderXXImpl/1/1/17/1",502),re(503,1,Kn,q4),ee.Ef=function(y,k){return new W4},oe(kt,"ConnectorBundleLoaderXXImpl/1/1/18",503),re(504,1,Kn,F4),ee.Ef=function(y,k){return new H4},oe(kt,"ConnectorBundleLoaderXXImpl/1/1/19",504),re(505,1,{},H4),oe(kt,"ConnectorBundleLoaderXXImpl/1/1/19/1",505),re(486,1,Kn,$4),ee.Ef=function(y,k){return new wv},oe(kt,"ConnectorBundleLoaderXXImpl/1/1/2",486),re(506,1,Kn,U4),ee.Ef=function(y,k){return new G4},oe(kt,"ConnectorBundleLoaderXXImpl/1/1/20",506),re(507,1,{},G4),oe(kt,"ConnectorBundleLoaderXXImpl/1/1/20/1",507),re(508,1,Kn,Q4),ee.Ef=function(y,k){return new J4},oe(kt,"ConnectorBundleLoaderXXImpl/1/1/21",508),re(509,1,{},J4),oe(kt,"ConnectorBundleLoaderXXImpl/1/1/21/1",509),re(510,1,Kn,Y4),ee.Ef=function(y,k){return new Z4},oe(kt,"ConnectorBundleLoaderXXImpl/1/1/22",510),re(511,1,{},Z4),oe(kt,"ConnectorBundleLoaderXXImpl/1/1/22/1",511),re(487,1,Kn,e3),ee.Ef=function(y,k){return new tg},oe(kt,"ConnectorBundleLoaderXXImpl/1/1/3",487),re(488,1,Kn,t3),ee.Ef=function(y,k){return new NV},oe(kt,"ConnectorBundleLoaderXXImpl/1/1/4",488),re(489,1,Kn,n3),ee.Ef=function(y,k){return new ng},oe(kt,"ConnectorBundleLoaderXXImpl/1/1/5",489),re(490,1,Kn,i3),ee.Ef=function(y,k){return new k3},oe(kt,"ConnectorBundleLoaderXXImpl/1/1/6",490),re(491,1,Kn,r3),ee.Ef=function(y,k){return new Sg},oe(kt,"ConnectorBundleLoaderXXImpl/1/1/7",491),re(492,1,Kn,o3),ee.Ef=function(y,k){return new pC},oe(kt,"ConnectorBundleLoaderXXImpl/1/1/8",492),re(493,1,Kn,s3),ee.Ef=function(y,k){return new tm},oe(kt,"ConnectorBundleLoaderXXImpl/1/1/9",493),re(72,1,{72:1},Ys),ee.Yc=function(y){var k;return y===this?!0:ze(y,72)?(k=y,ye(k.b.b+"."+k.a,this.b.b+"."+this.a)):!1},ee.$c=function(){return hu(this.b.b+"."+this.a)},ee._c=function(){return this.b.b+"."+this.a},oe(kt,"Method",72),re(79,21,{79:1,3:1,21:1,20:1},A1),oe(kt,"NoDataException",79),re(83,1,{83:1},Ca,Q1),oe(kt,"OnStateChangeMethod",83),re(5,1,{5:1},Ee,Wc),ee.Yc=function(y){var k;return y===this?!0:ze(y,5)?(k=y,ye(k.b,this.b)):!1},ee.$c=function(){return hu(this.b)},ee._c=function(){return this.b};var nh=oe(kt,"Type",5);re(414,1,{},pA),ee.Gf=function(y,k,z){this.c[ht(y),y.k][k]=z},oe(kt,"TypeDataStore",414),re(370,1,Wy),ee.qe=function(y){CA(this.c,this.b)&&y.a&&ki(y.a)},ee.se=function(y){this.d=rv(y.a),this.g=!1,this.e=Yh(this.f)},ee.te=function(y){CA(this.c,this.b)&&this.g&&this.d&&rv(y.a)==this.d&&DP(this,y.a),this.g=!1,this.d=null},ee.g=!1;var LW=oe(nn,"AbstractClickEventHandler",370);re(374,1,Hb,D5),ee.Ae=function(y){n$(this.a,y)},oe(nn,"AbstractClickEventHandler/lambda$0$Type",374),re(288,44,{},_S),ee.kd=function(){this.a.pf(sK).pg(),wA(),this.a.r=!0},oe(nn,"AbstractComponentConnector/2",288),re(290,1,{721:1,27:1},q5),oe(nn,"AbstractComponentConnector/3",290),re(287,1,sy,F5),ee.qe=function(y){rF(this.a,y)},oe(nn,"AbstractComponentConnector/lambda$0$Type",287),re(289,1,by,A6),ee.ue=function(y){iU(this.a,this.b,y)},oe(nn,"AbstractComponentConnector/lambda$1$Type",289),re(291,1,{722:1,27:1},H5),oe(nn,"AbstractComponentConnector/lambda$2$Type",291),re(292,197,{},B6),ee.Df=function(y){return!0},oe(nn,"AbstractConnector/FullStateChangeEvent",292),re(369,155,Nd),oe(nn,"AbstractSingleComponentContainerConnector",369),re(215,370,Wy),oe(nn,"ClickEventHandler",215),re(658,1,Hb,r9),ee.Ae=function(y){var k;if(k=Ah(y.d),this.r){y.a=!0,k==Bs&&cV(this,y.d);return}switch(k){case wl:y.a||($G(this,y.d),this.j&&(y.a=!0));break;case ui:case Au:y.a||(this.j&&(y.a=!0),tQ(this));break;case 64:this.j&&(y.a=!0);break;default:Di(jn((ht(fi),fi.k)),"Non touch event:"+SN(y.d)),y.a=!0}},ee.a=0,ee.c=0,ee.e=0,ee.f=0,ee.j=!1,ee.k=0,ee.n=0,ee.o=0,ee.r=!1;var vr=!1,zp,fi=oe(nn,"TouchScrollDelegate",658);re(660,131,{},AI),ee.ad=function(y){return 1+ae.Math.pow(y-1,3)},ee.bd=function(){var y;y=bt(this.b-this.a.e),this.a.c-=y,km(this.a),this.a.r=!1},ee.cd=function(){J8(this,1+ae.Math.pow(0,3)),this.a.r=!1,U$(this.a)},ee.ed=function(y){J8(this,y)},ee.b=0,ee.c=0,oe(nn,"TouchScrollDelegate/1",660),re(659,1,by,aI),ee.ue=function(y){JB(this.a,y)},ee.b=!1,oe(nn,"TouchScrollDelegate/TouchScrollHandler",659),re(399,1,$z,$5),ee.we=function(y){var k;k=GA(),this.a.c&&(!k||Io(Re(this.a.e),k)||En((ci(),ue.body),k))&&(this.a.c.focus(),this.a.c=null)},oe(nn,"VContextMenu/1",399),re(397,138,{729:1,728:1,18:1,27:1,14:1,9:1,16:1,19:1,12:1,13:1},i9),ee.Pe=function(){(To(),To(),Zf).Ze((fe(),this.Xc))},ee.re=function(y){kh(y.a)==27&&Pn(this.a,!1)},oe(nn,"VContextMenu/CMenuBar",397),re(398,1,Et,U5),ee.Kd=function(){g_(this.a)},oe(nn,"VContextMenu/lambda$0$Type",398),re(401,1,{},G5),ee.Te=function(y,k){KU(this.a,y,k)},oe(nn,"VContextMenu/lambda$1$Type",401),re(400,1,Et,Q5),ee.Kd=function(){jN(this.a)},oe(nn,"VContextMenu/lambda$2$Type",400),re(118,144,Pr,wf),ee.wd=function(y){if(cs(this,y),fe(),Hn((be(),y).type)==gl){vm(this),y.stopPropagation();return}},ee.qd=function(y){(fe(),this.Xc).style[mt]=y,y==null||y.length==0?Sn(this.Xc,vj,!0):Sn(this.Xc,vj,!1)},oe(nn,"VLabel",118),re(91,1,{},Rl),ee.b=0,oe(nn,"VLazyExecutor",91),re(404,44,{},BS),ee.kd=function(){this.a.c=null,this.a.a.Kd()},oe(nn,"VLazyExecutor/1",404),re(232,130,{18:1,713:1,27:1,14:1,9:1,726:1,60:1,16:1,31:1,19:1,12:1,13:1,232:1},iT),ee.yd=function(){((fe(),this.Xc).ownerDocument.body.className||"").indexOf("v-generated-body")==-1&&(this.a=new DS(this),gn(this.a,_r))},ee.xe=function(y){Ci(),Vi(ue).clientWidth|0,Vi(ue).clientHeight|0},ee.zd=function(){this.a&&(Oo(this.a),this.a=null)},ee.Bd=function(y){KC((fe(),this.Xc),y)};var MW=oe(nn,"VUI",232);re(546,44,{},DS),ee.kd=function(){Ci(),Vi(ue).clientWidth|0,Vi(ue).clientHeight|0,gn(this.a.a,_r)},oe(nn,"VUI/1",546),re(545,1,Et,dK),ee.Kd=function(){Ci(),Vi(ue).clientWidth|0,Vi(ue).clientHeight|0},oe(nn,"VUI/lambda$0$Type",545),re(136,369,{27:1,99:1,121:1,136:1,3:1},wv),ee.uf=function(){return!this.K&&(this.K=On(this)),this.K},ee.qf=function(){return!this.K&&(this.K=On(this)),this.K},ee.vf=function(){return U7(this)},ee.xf=function(){return!0},ee.rf=function(y){var k;AV(this,y),y.Df(Xy)&&(null.pg((!this.K&&(this.K=On(this)),this.K).q.a),null.pg((!this.K&&(this.K=On(this)),this.K).q.c),null.pg((!this.K&&(this.K=On(this)),this.K).q.d),null.pg((!this.K&&(this.K=On(this)),this.K).q.e),null.pg((!this.K&&(this.K=On(this)),this.K).q.b)),y.Df(Cy)&&(null.pg((!this.K&&(this.K=On(this)),this.K).c.a),null.pg((!this.K&&(this.K=On(this)),this.K).c.b),null.pg((!this.K&&(this.K=On(this)),this.K).c.c)),y.Df(Iy)&&e$(this),y.Df("pageState.title")&&(k=(!this.K&&(this.K=On(this)),this.K).g.b,k!=null&&(Ci(),ue.title=k)),y.Df(Ty)&&null.pg((!this.K&&(this.K=On(this)),this.K).j.b!=(Za(),jp)),y.Df(Vy)&&null.pg(),y.Df(Sy)&&tR(this.D,(!this.K&&(this.K=On(this)),this.K).f)},ee.Hf=function(){var y,k,z,E;if(z=this.a,y=(!this.K&&(this.K=On(this)),this.K).o,E=tv(),k=tv(),Nh(z,y)){if(y==null)return;wT(E)?YI(Re((!this.C&&(this.C=dd(this)),this.C).Wc),y)||Gm(this,y):WV(this,null,y,null,k);return}Di(jn((ht(Qn),Qn.k)),"Changing theme from "+z+" to "+y),WV(this,z,y,E,k)},ee.If=function(){null.pg((!this.K&&(this.K=On(this)),this.K).p)},ee.Jf=function(){Fa(this,MQ).pg((!this.K&&(this.K=On(this)),this.K).b)};var Qn=oe(bp,"UIConnector",136);re(371,215,Wy,iA),oe(bp,"UIConnector/1",371),re(372,44,{},qS),ee.kd=function(){if(Je(this.a).i<0){Oo(this.a.b),this.a.b=null;return}Fa(this.a,Bp).pg(),null.pg()},oe(bp,"UIConnector/10",372),re(373,1,{},vI),ee.Bf=function(y){Mh(jn((ht(Qn),Qn.k)),"Could not load theme from "+tv())},ee.Cf=function(y){Di(jn((ht(Qn),Qn.k)),"Loading of "+this.b+" from "+this.c+" completed"),this.d&&Jo(Nl(this.d),this.d),Gm(this.a,this.b)},oe(bp,"UIConnector/11",373),re(363,1,{},J5),ee.Af=function(y){var k;k=Bm(y),k.indexOf(Vu)!=-1&&(Rm(Re(this.a),this),Cv(this.a,Vu))},oe(Pf,"Overlay/1",363),re(364,1,{},T6),ee.Af=function(y){Bm(y).indexOf(Vu)!=-1&&(Rm(Re(this.a),this),qv(this.a,this.b))},ee.b=!1,oe(Pf,"Overlay/2",364),re(365,1,{},V6),ee.Af=function(y){var k;k=Bm(y),k.indexOf(Md)!=-1&&(Rm(Re(this.a),this),Cv(this.a,Vu),Cv(this.a,Md),qv(this.a,this.b))},ee.b=!1,oe(Pf,"Overlay/3",365),re(361,1,{},zI),ee.a=0,ee.b=0,ee.c=0,ee.d=0,oe(Pf,"Overlay/PositionAndSize",361),re(362,131,{},fS),ee.ed=function(y){Tf(this.a,y)},oe(Pf,"Overlay/ResizeAnimation",362),re(106,1,{},zl),ee.Kf=function(y){return wi(y)},oe(on,"Parser/10methodref$toString$Type",106),re(312,1,{},c3),ee.Kf=function(y){return wi(y)},oe(on,"Parser/11methodref$toString$Type",312),re(315,1,{},u3),ee.Kf=function(y){return wi(y)},oe(on,"Parser/12methodref$toString$Type",315),re(201,1,{},Up),ee.Lf=function(){return new E4},oe(on,"Parser/2methodref$ctor$Type",201),re(202,1,{},Gp),ee.Kf=function(y){return he(Wi(y))},oe(on,"Parser/3methodref$valueOf$Type",202),re(203,1,{},Qp),ee.Kf=function(y){return wi(y)},oe(on,"Parser/4methodref$toString$Type",203),re(204,1,{},$p),ee.Kf=function(y){return he(Wi(y))},oe(on,"Parser/5methodref$valueOf$Type",204),re(104,1,{},El),ee.Kf=function(y){return wi(y)},oe(on,"Parser/6methodref$toString$Type",104),re(156,1,{},d1),oe(on,"Parser/7methodref$intValue$Type",156),re(311,1,{},l3),oe(on,"Parser/8methodref$doubleValue$Type",311),re(105,1,{},jl),ee.Kf=function(y){return wi(y)},oe(on,"Parser/9methodref$toString$Type",105),re(129,1,{},rh),ee.Kf=function(y){return tl(y)?la(y):Cf(wi(y))},oe(on,"Parser/lambda$12$Type",129),re(313,1,{},f3),ee.Lf=function(){return new vs},oe(on,"Parser/lambda$17$Type",313),re(107,1,{},Ol),ee.Lf=function(){return new qp},oe(on,"Parser/lambda$18$Type",107),re(314,1,{},h3),ee.Lf=function(){return new Hp},oe(on,"Parser/lambda$19$Type",314),re(69,1,{},Fo),ee.Kf=function(y){return oB(this.a,y)},oe(on,"Parser/lambda$20$Type",69),re(316,1,{},d3),ee.Kf=function(y){var k;return k=new Fp,Object.assign(k,y),k},oe(on,"Parser/lambda$22$Type",316),re(205,1,{},Jp),ee.Kf=function(y){return he(bt(tl(y)?la(y):Cf(wi(y))))},oe(on,"Parser/lambda$6$Type",205),re(206,1,{},Yp),ee.Kf=function(y){return he(bt(tl(y)?la(y):Cf(wi(y))))},oe(on,"Parser/lambda$7$Type",206),re(207,1,{},Zp),ee.Kf=function(y){return he(bt(tl(y)?la(y):Cf(wi(y))))},oe(on,"Parser/lambda$9$Type",207),re(678,1,{},IT),ee.addPopupButton=function(y){var k,z,E,j;E=E9(y),z=E.sheet+"_"+E.row+"_"+E.col,bn(this.c,z)?j=Nt(this.c,z):(Te(this.a,z,k=new B7),Te(this.c,z,j=(!k.C&&(k.C=new Ls),k.C)),Te(this.b,z,E),vK(k,this.e.i),W9(k,OQ,k.a),Xn((!k.C&&(k.C=new Ls),k.C),k,(Ao(),Ao(),ws)),o_((!k.C&&(k.C=new Ls),k.C),k),G3(j,E.col),IK(j,E.row),wC(j,E.headerHidden),K8(j,this.f.V,Re(this.f.V)),b8(j,E.popupWidth),a8(j,E.popupHeight)),H7(j,E.active),FL(this.f,j)},ee.cellsUpdated=function(y){var k;k=Dn((ht(mn),mn.k),gr,"."),LM(io(this.e,k).Ke().Ve(),Wn(y,new Fo(new Ol)))},ee.closePopup=function(y,k){var z;z=Nt(this.c,Xg(this.f)+"_"+y+"_"+k),z&&(Pn(z.e,!1),F7(z))},ee.disconnected=function(){this.e&&GF(this.e)},ee.editCellComment=function(y,k){Ct((ut(),pt),new w8(this,y,k))},ee.invalidCellAddress=function(){var y;y=Dn((ht(mn),mn.k),gr,"."),K7(pi(io(this.e,y).Ke().Ve().a).u)},ee.layout=function(){vw(this.f),oR(pi(this.e))},ee.load=function(){A_(this.f)},ee.notifyStateChanges=function(y,k){var z,E,j,te,ne,ie;for(ie={},j=y,te=0,ne=j.length;te<ne;++te)E=j[te],ie[E]="";z=new X8(ie,k),lQ(this,this.e,z),ZV(this.e,z)},ee.onPopupButtonOpened=function(y,k,z,E){var j,te,ne;j=u0(z,E),j&&(te=new Ck(Ba((be(),j))),fe(),te.Xc&&(ne=Nt(this.c,Xg(this.f)+"_"+y+"_"+k),ne.e.M||ne.d&&F9(ne.d,ne.b,ne.k)&&Pv(ne),ne.c=te,St(ne.f,te),T9(ne.i,te)))},ee.refreshCellStyles=function(){Ct((ut(),pt),new Z5(this))},ee.relayout=function(){Ct((ut(),pt),new Y5(this))},ee.relayoutSheet=function(){vw(this.f)},ee.removePopupButton=function(y){var k,z,E;E=E9(y),k=E.sheet+"_"+E.row+"_"+E.col,z=Nt(this.c,k),z&&(QL(this.f,z),Eo(this.c,k),Eo(this.a,k),Eo(this.b,k))},ee.resize=function(){FM(this.f)},ee.setActionOnColumnHeaderCallback=function(y){_K(this.e.i,y)},ee.setActionOnCurrentSelectionCallback=function(y){BK(this.e.i,y)},ee.setActionOnRowHeaderCallback=function(y){DK(this.e.i,y)},ee.setCellAddedToSelectionAndSelectedCallback=function(y){qK(this.e.i,y)},ee.setCellCommentAuthors=function(y){Je(this.e).a=ds(y,new jl,new zl)},ee.setCellComments=function(y){Je(this.e).b=ds(y,new jl,new zl)},ee.setCellKeysToEditorIdMap=function(y){Je(this.e).c=ds(y,new jl,new zl)},ee.setCellRangePaintedCallback=function(y){FK(this.e.i,y)},ee.setCellRangeSelectedCallback=function(y){HK(this.e.i,y)},ee.setCellSelectedCallback=function(y){$K(this.e.i,y)},ee.setCellStyleToCSSStyle=function(y){Je(this.e).d=ds(y,new Gp,new Qp)},ee.setCellValueEditedCallback=function(y){UK(this.e.i,y)},ee.setCellsAddedToRangeSelectionCallback=function(y){GK(this.e.i,y)},ee.setClass=function(y){var k,z,E,j,te,ne,ie;for(E=this.d,te=0,ie=E.length;te<ie;++te)k=E[te],vt(this.f,k,!1);for(this.d=y.length==0?Le(ct,Mi,2,0,6,1):Nr(y," ",0),z=this.d,j=0,ne=z.length;j<ne;++j)k=z[j],vt(this.f,k,!0)},ee.setClearSelectedCellsOnCutCallback=function(y){QK(this.e.i,y)},ee.setColGroupingData=function(y){Je(this.e).e=Wn(y,new Fo(new Up))},ee.setColGroupingInversed=function(y){Je(this.e).f=y},ee.setColGroupingMax=function(y){Je(this.e).g=y},ee.setColW=function(y){Je(this.e).i=Vv(ev(new Fu(null,new zh(Wn(y,new rh))),new d1))},ee.setCols=function(y){Je(this.e).j=y},ee.setColumnAddedToSelectionCallback=function(y){JK(this.e.i,y)},ee.setColumnBufferSize=function(y){Je(this.e).k=y},ee.setColumnHeaderContextMenuOpenCallback=function(y){YK(this.e.i,y)},ee.setColumnIndexToStyleIndex=function(y){Je(this.e).n=ds(y,new $p,new Jp)},ee.setColumnResizedCallback=function(y){ZK(this.e.i,y)},ee.setColumnSelectedCallback=function(y){eL(this.e.i,y)},ee.setComponentIDtoCellKeysMap=function(y){Je(this.e).o=ds(y,new jl,new zl)},ee.setConditionalFormattingStyles=function(y){Je(this.e).p=ds(y,new Gp,new Qp)},ee.setContextMenuOpenOnSelectionCallback=function(y){tL(this.e.i,y)},ee.setDefColW=function(y){Je(this.e).q=y},ee.setDefRowH=function(y){Je(this.e).r=y},ee.setDeleteSelectedCellsCallback=function(y){nL(this.e.i,y)},ee.setDisplayGridlines=function(y){Je(this.e).s=y},ee.setDisplayRowColHeadings=function(y){Je(this.e).t=y},ee.setGroupingCollapsedCallback=function(y){iL(this.e.i,y)},ee.setHasActions=function(y){Je(this.e).u=y},ee.setHeight=function(y){Je(this.e).jb=y},ee.setHiddenColumnIndexes=function(y){Je(this.e).v=Wn(y,new Zp)},ee.setHiddenRowIndexes=function(y){Je(this.e).w=Wn(y,new Zp)},ee.setHorizontalScrollPositions=function(y){Je(this.e).A=Vv(ev(new Fu(null,new zh(Wn(y,new rh))),new d1))},ee.setHorizontalSplitPosition=function(y){Je(this.e).B=y},ee.setHyperlinksTooltips=function(y){Je(this.e).C=ds(y,new jl,new zl)},ee.setId=function(y){Je(this.e).kb=y},ee.setInfoLabelValue=function(y){Je(this.e).D=y},ee.setInvalidFormulaCells=function(y){Je(this.e).F=new Oh(Wn(y,new c3))},ee.setInvalidFormulaErrorMessage=function(y){Je(this.e).G=y},ee.setLevelHeaderClickedCallback=function(y){rL(this.e.i,y)},ee.setLinkCellClickedCallback=function(y){oL(this.e.i,y)},ee.setLockFormatColumns=function(y){Je(this.e).H=y},ee.setLockFormatRows=function(y){Je(this.e).I=y},ee.setLockedColumnIndexes=function(y){Je(this.e).J=new Oh(Wn(y,new Yp))},ee.setLockedRowIndexes=function(y){Je(this.e).K=new Oh(Wn(y,new Yp))},ee.setMergedRegions=function(y){Je(this.e).L=Wn(y,new Fo(new f3))},ee.setNamedRanges=function(y){Je(this.e).M=Wn(y,new El)},ee.setOnColumnAutofitCallback=function(y){sL(this.e.i,y)},ee.setOnConnectorInitCallback=function(y){cL(this.e.i,y)},ee.setOnPasteCallback=function(y){uL(this.e.i,y)},ee.setOnRedoCallback=function(y){lL(this.e.i,y)},ee.setOnRowAutofitCallback=function(y){fL(this.e.i,y)},ee.setOnSheetScrollCallback=function(y){hL(this.e.i,y)},ee.setOnUndoCallback=function(y){dL(this.e.i,y)},ee.setOverlays=function(y){Je(this.e).N=ds(y,new u3,new d3)},ee.setPopupButtonClickCallback=function(y){aL(this.e.i,y)},ee.setPopupCloseCallback=function(y){bL(this.e.i,y)},ee.setProtectedCellWriteAttemptedCallback=function(y){pL(this.e.i,y)},ee.setReload=function(y){Je(this.e).O=!0},ee.setResources=function(y,k){var z;z=Wn(k,new El),Tq(z,new z6(this,y))},ee.setRowAddedToRangeSelectionCallback=function(y){gL(this.e.i,y)},ee.setRowBufferSize=function(y){Je(this.e).P=y},ee.setRowGroupingData=function(y){Je(this.e).Q=Wn(y,new Fo(new Up))},ee.setRowGroupingInversed=function(y){Je(this.e).R=y},ee.setRowGroupingMax=function(y){Je(this.e).S=y},ee.setRowH=function(y){Je(this.e).T=LH(y)},ee.setRowHeaderContextMenuOpenCallback=function(y){wL(this.e.i,y)},ee.setRowIndexToStyleIndex=function(y){Je(this.e).U=ds(y,new $p,new Jp)},ee.setRowSelectedCallback=function(y){vL(this.e.i,y)},ee.setRows=function(y){Je(this.e).V=y},ee.setRowsResizedCallback=function(y){mL(this.e.i,y)},ee.setSelectedCellAndRange=function(y,k,z,E,j,te,ne,ie){var se;se=Dn((ht(mn),mn.k),gr,"."),G_(io(this.e,se).Ke().Ve(),y,k,z,E,j,te,ne,ie)},ee.setSelectionDecreasePaintedCallback=function(y){yL(this.e.i,y)},ee.setSelectionIncreasePaintedCallback=function(y){xL(this.e.i,y)},ee.setSetCellStyleWidthRatiosCallback=function(y){CL(this.e.i,y)},ee.setSheetAddressChangedCallback=function(y){kL(this.e.i,y)},ee.setSheetCreatedCallback=function(y){SL(this.e.i,y)},ee.setSheetIndex=function(y){Je(this.e).W=y},ee.setSheetNames=function(y){Je(this.e).X=td(Wn(y,new El),Le(ct,Mi,2,0,6,1))},ee.setSheetProtected=function(y){Je(this.e).Y=y},ee.setSheetRenamedCallback=function(y){IL(this.e.i,y)},ee.setSheetSelectedCallback=function(y){AL(this.e.i,y)},ee.setShiftedCellBorderStyles=function(y){Je(this.e).Z=Wn(y,new El)},ee.setUpdateCellCommentCallback=function(y){TL(this.e.i,y)},ee.setVerticalScrollPositions=function(y){Je(this.e).$=Vv(ev(new Fu(null,new zh(Wn(y,new rh))),new d1))},ee.setVerticalSplitPosition=function(y){Je(this.e)._=y},ee.setVisibleCellComments=function(y){Je(this.e).ab=Wn(y,new El)},ee.setWidth=function(y){Je(this.e).nb=y},ee.setWorkbookChangeToggle=function(y){Je(this.e).bb=y},ee.setWorkbookProtected=function(y){Je(this.e).cb=y},ee.showActions=function(y){var k;k=Dn((ht(mn),mn.k),gr,"."),sH(io(this.e,k).Ke().Ve(),Wn(y,new Fo(new h3)))},ee.showSelectedCell=function(y,k,z,E,j,te,ne){var ie;ie=Dn((ht(mn),mn.k),gr,"."),S_(io(this.e,ie).Ke().Ve(),y,k,z,E,j,te,ne)},ee.updateBottomLeftCellValues=function(y){var k;k=Dn((ht(mn),mn.k),gr,"."),MM(io(this.e,k).Ke().Ve(),Wn(y,new Fo(new Ol)))},ee.updateBottomRightCellValues=function(y){var k;k=Dn((ht(mn),mn.k),gr,"."),NM(io(this.e,k).Ke().Ve(),Wn(y,new Fo(new Ol)))},ee.updateCellsAndRefreshCellStyles=function(){},ee.updateFormulaBar=function(y,k,z){var E;E=Dn((ht(mn),mn.k),gr,"."),iR(io(this.e,E).Ke().Ve(),y,k,z)},ee.updateTopLeftCellValues=function(y){var k;k=Dn((ht(mn),mn.k),gr,"."),RM(io(this.e,k).Ke().Ve(),Wn(y,new Fo(new Ol)))},ee.updateTopRightCellValues=function(y){var k;k=Dn((ht(mn),mn.k),gr,"."),PM(io(this.e,k).Ke().Ve(),Wn(y,new Fo(new Ol)))},oe(on,"SpreadsheetJsApi",678),re(269,13,Pr,Ck),oe(on,"SpreadsheetJsApi/ContentWidget",269),re(270,1,Et,Y5),ee.Kd=function(){vw(this.a.f)},oe(on,"SpreadsheetJsApi/lambda$0$Type",270),re(271,1,{},z6),ee.Mf=function(y){U_(this.a,this.b,y)},oe(on,"SpreadsheetJsApi/lambda$1$Type",271),re(272,1,Et,Z5),ee.Kd=function(){rR(pi(nq(this.a).a).V)},oe(on,"SpreadsheetJsApi/lambda$2$Type",272),re(273,1,Et,w8),ee.Kd=function(){mq(this.a,this.b,this.c)},ee.b=0,ee.c=0,oe(on,"SpreadsheetJsApi/lambda$3$Type",273),re(195,1,{719:1,3:1},eg),ee.mf=function(y,k,z){HA(this,y,k,z)};var NW=oe(on,"SpreadsheetServerRpcImpl",195);re(274,1,{},iC),ee.zf=function(y,k){KN(this.a,y,k)},oe(on,"SpreadsheetServerRpcImpl/lambda$0$Type",274),re(275,1,{},rC),ee.zf=function(y,k){WN(this.a,y,k)},oe(on,"SpreadsheetServerRpcImpl/lambda$1$Type",275),re(663,1,ve,q3),ee._c=function(){return q7(this.b)+","+this.c+","+this.d+","+this.a+","+this.e+","+this.f+","+this.j+","+this.k+","+this.g+","+this.i},ee.a=!1,ee.c=0,ee.d=0,ee.e=!1,ee.f=!1,ee.g=-1,ee.i=-1,ee.j=!1,ee.k=0,oe(Bf,"MouseEventDetails",663),re(120,4,{120:1,3:1,6:1,4:1},P1);var Ep,Cx,kx,WQ=We(Bf,"MouseEventDetails/MouseButton",120,tD);re(557,1,ve,hz),ee.a=-1,ee.b=-1,ee.c=-1,ee.e=!1,ee.f=!1,ee.g=!1,ee.i=!1,ee.j=!1,ee.k=!1,ee.n=!1,ee.o=!1,ee.p=!1,ee.q=!1,ee.r=!1,ee.s=!1,ee.t=0,ee.u=-1,ee.v=-1,oe(Bf,"VBrowserDetails",557);var Sx;re(173,1,{173:1,3:1},O8),ee.Yc=function(y){var k;return!(!ze(y,173)||(k=y,!Nh(this.a,k.a))||!Nh(this.b,k.b)||!Nh(this.c,k.c)||!Nh(this.d,k.d))},ee.$c=function(){var y;return y=1,y=31*y+(this.a==null?0:hu(this.a)),y=31*y+(this.b==null?0:hu(this.b)),y=31*y+(this.c==null?0:hu(this.c)),y=31*y+rm(this.d),y},ee._c=function(){return this.a+":"+this.b+"."+this.c+"("+Ro+")"},oe(tp,"MethodInvocation",173),re(116,4,{116:1,3:1,6:1,4:1},_1);var RW,jp,PW,Ix=We(tp,"PushMode",116,eD);re(415,67,tE);var _W=oe(_d,"AbstractSingleComponentContainerState",415);re(111,4,{111:1,3:1,6:1,4:1},B1);var BW,Ax,DW,Tx=We(_d,"ContentMode",111,ZB);re(77,4,{77:1,3:1,6:1,4:1},_l);var Vx,zx,Ex,jx,Ox,Op=We(_d,"ErrorLevel",77,VD);re(142,4,{142:1,3:1,6:1,4:1},Dg);var Xu,qW,Xx=We(lo,"NotificationRole",142,lB);re(231,1,ve,tg),ee.a=!1,ee.b=null;var Il=oe(lo,"PageState",231);re(98,4,{98:1,3:1,6:1,4:1},Vh);var Wx,FW,Kx,HW,KQ=We(lo,"Transport",98,hD);re(166,415,{67:1,75:1,166:1,3:1},NV),ee.a=!1,ee.b=0,ee.f="This content is announced automatically and does not need to be navigated into.",ee.i=-1,ee.n=0,ee.p=!0;var Jt=oe(lo,"UIState",166);re(224,1,ve,ng),ee.a=300,ee.b=1500,ee.c=5e3;var Us=oe(lo,"UIState/LoadingIndicatorConfigurationState",224);re(416,1,ve,k3),ee.d=0,ee.n=!1;var yn=oe(lo,"UIState/LocaleData",416);re(228,1,ve,Sg);var o1=oe(lo,"UIState/LocaleServiceState",228);re(92,1,ve,pC,of);var Gs=oe(lo,"UIState/NotificationTypeConfiguration",92);re(226,1,ve,tm),ee.a=!1,ee.d=null;var Bo=oe(lo,"UIState/PushConfigurationState",226);re(227,1,ve,ig),ee.a=400,ee.b=!1,ee.c="Server connection lost, trying to reconnect...",ee.d="Server connection lost.",ee.e=1e4,ee.f=5e3;var nr=oe(lo,"UIState/ReconnectDialogConfigurationState",227);re(225,1,ve,rg),ee.a=300,ee.b=500,ee.c=750,ee.d=100,ee.e=_r;var Hr=oe(lo,"UIState/TooltipConfigurationState",225);re(413,24,Ns,gk),oe("elemental.json","JsonException",413),re(124,1,{184:1}),ee._c=function(){return this.a},oe(ln,"AbstractStringBuilder",124),re(58,24,Ns,Jr),oe(ln,"ArithmeticException",58);var Lx,Mx;re(127,82,{3:1,6:1,127:1,82:1},pg),ee.he=function(y){return Yv(this.a,y.a)},ee.Yc=function(y){return ze(y,127)&&l8(this.a,y.a)},ee.$c=function(){return bt(this.a)},ee._c=function(){return""+this.a},ee.a=0,oe(ln,"Float",127);var Nx;re(103,82,{3:1,6:1,103:1,82:1},gg),ee.he=function(y){return $8(this.a,y.a)},ee.Yc=function(y){return ze(y,103)&&Lg(y.a,this.a)},ee.$c=function(){return _e(this.a)},ee.Uf=function(){return this.a},ee._c=function(){return""+fa(this.a)},ee.a=0;var $W=oe(ln,"Long",103),Rx;re(46,68,{3:1,21:1,46:1,24:1,20:1},yo),oe(ln,"NumberFormatException",46),re(74,1,{3:1,74:1},xa),ee.Yc=function(y){var k;return ze(y,74)?(k=y,this.c==k.c&&this.d==k.d&&this.a==k.a&&this.b==k.b):!1},ee.$c=function(){return rm(Se(Ce(Ke,1),ve,1,5,[he(this.c),this.a,this.d,this.b]))},ee._c=function(){return this.a+"."+this.d+"("+(this.b!=null?this.b:"Unknown Source")+(this.c>=0?":"+this.c:"")+")"},ee.c=0;var Px=oe(ln,"StackTraceElement",74);re(259,124,{184:1},kk),oe(ln,"StringBuffer",259),re(30,124,{184:1},Bi,z1,Bu),oe(ln,"StringBuilder",30),re(822,1,{});var UW;re(36,82,{3:1,6:1,82:1,36:1},uw,os,IC,A8),ee.he=function(y){return MV(this,y)},ee.Yc=function(y){var k;return this===y?!0:ze(y,36)?(k=y,this.e==k.e&&MV(this,k)==0):!1},ee.$c=function(){var y;return this.b!=0?this.b:this.a<54?(y=lr(this.f),this.b=_e(Ve(y,-1)),this.b=33*this.b+_e(Ve(Bn(y,32),-1)),this.b=17*this.b+bt(this.e),this.b):(this.b=17*k9(this.c)+bt(this.e),this.b)},ee._c=function(){return FV(this)},ee.a=0,ee.b=0,ee.d=0,ee.e=0,ee.f=0;var _x,s1,Bx,Dx,qx,Fx,Hx,c1,$x,GW=oe("java.math","BigDecimal",36);re(11,82,{3:1,6:1,82:1,11:1},am,zi,kn,ym,nT,w7),ee.he=function(y){return s0(this,y)},ee.Yc=function(y){return t0(this,y)},ee.$c=function(){return k9(this)},ee._c=function(){return uz(this,0)},ee.b=-2,ee.c=0,ee.d=0,ee.e=0;var u1,Al,Ux,Xp,l1,Do,Wu=oe("java.math","BigInteger",11),QW,JW,$r,Tl,Gx;re(157,688,{149:1}),ee.clear=function(){Mt(this)},ee.containsKey=function(y){return rf(this,y)},ee.containsValue=function(y){return ZA(y,this.b)||ZA(y,this.a)},ee.Wf=function(){return new or(this)},ee.get=function(y){return no(this,y)},ee.put=function(y,k){return Zn(this,y,k)},ee.remove=function(y){return $u(this,y)},ee.size=function(){return Mu(this)},oe(Pe,"AbstractHashMap",157),re(47,689,Cd,or),ee.clear=function(){Mt(this.a)},ee.contains=function(y){return NI(this,y)},ee.Ke=function(){return new hr(this.a)},ee.remove=function(y){var k;return NI(this,y)?(k=y.cg(),$u(this.a,k),!0):!1},ee.size=function(){return Mu(this.a)},oe(Pe,"AbstractHashMap/EntrySet",47),re(48,1,{},hr),ee.Ve=function(){return Xr(this)},ee.Ue=function(){return this.b},ee.We=function(){Ql(!!this.c),QI(this.e,this),this.c.We(),this.c=null,this.b=_v(this),DR(this.e,this)},ee.b=!1,oe(Pe,"AbstractHashMap/EntrySetIterator",48),re(700,1,kd),ee.Yc=function(y){var k;return ze(y,100)?(k=y,es(this.b.value[0],k.cg())&&es(_a(this),k.dg())):!1},ee.$c=function(){return H1(this.b.value[0])^H1(_a(this))},ee._c=function(){return this.b.value[0]+"="+_a(this)},oe(Pe,"AbstractMapEntry",700),re(691,687,U0),ee.addAtIndex=function(y,k){var z;z=this.Yf(y),z.$f(k)},ee.addAllAtIndex=function(y,k){var z,E,j,te;for(ft(k),te=!1,j=this.Yf(y),E=k.Ke();E.Ue();)z=E.Ve(),j.$f(z),te=!0;return te},ee.getAtIndex=function(y){var k;k=this.Yf(y);try{return k.Ve()}catch(z){throw z=Xt(z),ze(z,66)?we(new vo("Can't get element "+y)):we(z)}},ee.Ke=function(){return this.Yf(0)},ee.removeAtIndex=function(y){var k,z;k=this.Yf(y);try{return z=k.Ve(),k.We(),z}catch(E){throw E=Xt(E),ze(E,66)?we(new vo("Can't remove element "+y)):we(E)}},ee.setAtIndex=function(y,k){var z,E;z=this.Yf(y);try{return E=z.Ve(),z.bg(k),E}catch(j){throw j=Xt(j),ze(j,66)?we(new vo("Can't set element "+y)):we(j)}},oe(Pe,"AbstractSequentialList",691),re(128,687,az,lh),ee.contains=function(y){return YA(this,y)!=-1},ee.getAtIndex=function(y){return pn(y,this.a.length),this.a[y]},ee.setAtIndex=function(y,k){var z;return z=(pn(y,this.a.length),this.a[y]),this.a[y]=k,z},ee.size=function(){return this.a.length},ee.toArray=function(){return J9(this,Le(Ke,ve,1,this.a.length,5,1))},ee.Vf=function(y){return J9(this,y)},oe(Pe,"Arrays/ArrayList",128),re(161,1,{38:1},w1),ee.add=function(y){throw we(new Ln)},ee.addAll=function(y){throw we(new Ln)},ee.clear=function(){throw we(new Ln)},ee.contains=function(y){return this.b.contains(y)},ee.containsAll=function(y){return this.b.containsAll(y)},ee.isEmpty=function(){return this.b.isEmpty()},ee.Ke=function(){return new v1(this.b.Ke())},ee.remove=function(y){throw we(new Ln)},ee.removeAll=function(y){throw we(new Ln)},ee.retainAll=function(y){throw we(new Ln)},ee.size=function(){return this.b.size()},ee.toArray=function(){return this.b.toArray()},ee.Vf=function(y){return this.b.Vf(y)},ee._c=function(){return wi(this.b)},oe(Pe,"Collections/UnmodifiableCollection",161),re(163,1,{},v1),ee.Ue=function(){return this.b.Ue()},ee.Ve=function(){return this.b.Ve()},ee.We=function(){Tk()},oe(Pe,"Collections/UnmodifiableCollectionIterator",163),re(162,161,U0,na),ee.addAtIndex=function(y,k){throw we(new Ln)},ee.addAllAtIndex=function(y,k){throw we(new Ln)},ee.Yc=function(y){return dr(this.a,y)},ee.getAtIndex=function(y){return this.a.getAtIndex(y)},ee.$c=function(){return oo(this.a)},ee.indexOf=function(y){return this.a.indexOf(y)},ee.isEmpty=function(){return this.a.isEmpty()},ee.lastIndexOf=function(y){return this.a.lastIndexOf(y)},ee.Xf=function(){return new fw(this.a.Yf(0))},ee.Yf=function(y){return new fw(this.a.Yf(y))},ee.removeAtIndex=function(y){throw we(new Ln)},ee.setAtIndex=function(y,k){throw we(new Ln)},ee.subList=function(y,k){return new na(this.a.subList(y,k))},oe(Pe,"Collections/UnmodifiableList",162),re(223,163,{},fw),ee.We=function(){Tk()},ee.$f=function(y){throw we(new Ln)},ee._f=function(){return this.a._f()},ee.ag=function(){return this.a.ag()},ee.bg=function(y){throw we(new Ln)},oe(Pe,"Collections/UnmodifiableListIterator",223),re(388,1,{149:1},sC),ee.getOrDefault=function(y,k){var z;return z=this.c.get(y),z==null&&!this.c.containsKey(y)?k:z},ee.putIfAbsent=function(y,k){var z;return z=this.c.get(y),z??Og()},ee.replace=function(y,k){return this.c.containsKey(y)?Og():null},ee.clear=function(){throw we(new Ln)},ee.containsKey=function(y){return this.c.containsKey(y)},ee.containsValue=function(y){return this.c.containsValue(y)},ee.Wf=function(){return!this.a&&(this.a=new Sk(this.c.Wf())),this.a},ee.Yc=function(y){return dr(this.c,y)},ee.get=function(y){return this.c.get(y)},ee.$c=function(){return oo(this.c)},ee.isEmpty=function(){return this.c.isEmpty()},ee.keySet=function(){return!this.b&&(this.b=new jg(this.c.keySet())),this.b},ee.put=function(y,k){return Og()},ee.putAll=function(y){throw we(new Ln)},ee.remove=function(y){throw we(new Ln)},ee.size=function(){return this.c.size()},ee._c=function(){return wi(this.c)},ee.values=function(){return!this.d&&(this.d=new w1(this.c.values())),this.d},oe(Pe,"Collections/UnmodifiableMap",388),re(221,161,Cd,jg),ee.Yc=function(y){return dr(this.b,y)},ee.$c=function(){return oo(this.b)},oe(Pe,"Collections/UnmodifiableSet",221),re(389,221,Cd,Sk),ee.contains=function(y){return this.b.contains(y)},ee.containsAll=function(y){return this.b.containsAll(y)},ee.Ke=function(){var y;return y=this.b.Ke(),new oC(y)},ee.toArray=function(){var y;return y=this.b.toArray(),EI(y,y.length),y},ee.Vf=function(y){var k;return k=this.b.Vf(y),EI(k,this.b.size()),k},oe(Pe,"Collections/UnmodifiableMap/UnmodifiableEntrySet",389),re(391,1,{},oC),ee.Ve=function(){return new vg(this.a.Ve())},ee.Ue=function(){return this.a.Ue()},ee.We=function(){throw we(new Ln)},oe(Pe,"Collections/UnmodifiableMap/UnmodifiableEntrySet/1",391),re(222,1,kd,vg),ee.Yc=function(y){return this.a.Yc(y)},ee.cg=function(){return this.a.cg()},ee.dg=function(){return this.a.dg()},ee.$c=function(){return this.a.$c()},ee.eg=function(y){throw we(new Ln)},ee._c=function(){return wi(this.a)},oe(Pe,"Collections/UnmodifiableMap/UnmodifiableEntrySet/UnmodifiableEntry",222),re(390,162,{38:1,80:1,180:1},Ik),oe(Pe,"Collections/UnmodifiableRandomAccessList",390);var YW;re(657,1,ve,S3),ee.Yc=function(y){return this===y},oe(Pe,"Comparators/NaturalOrderComparator",657),re(654,24,Ns,_C),oe(Pe,"ConcurrentModificationException",654),re(178,1,{3:1,6:1,178:1},G7),ee.he=function(y){return $8(lr(this.a.getTime()),lr(y.a.getTime()))},ee.Yc=function(y){return ze(y,178)&&Lg(lr(this.a.getTime()),lr(y.a.getTime()))},ee.$c=function(){var y;return y=lr(this.a.getTime()),_e(iv(y,Yn(y,32)))},ee._c=function(){return aV(this)},oe(Pe,"Date",178);var ZW,eK;re(26,157,bz,Ot,n9),oe(Pe,"HashMap",26),re(35,689,pz,Si,Oh),ee.add=function(y){return Ut(this,y)},ee.clear=function(){Mt(this.a)},ee.contains=function(y){return Bl(this,y)},ee.isEmpty=function(){return Mu(this.a)==0},ee.Ke=function(){var y;return y=new Gr(this.a).a.Wf().Ke(),new po(y)},ee.remove=function(y){return Ih(this,y)},ee.size=function(){return Mu(this.a)},oe(Pe,"HashSet",35),re(480,1,{},FS),ee.Ke=function(){return new av(this)},ee.c=0,oe(Pe,"InternalHashCodeMap",480),re(230,1,{},av),ee.Ve=function(){return this.d=this.a[this.c++],this.d},ee.Ue=function(){var y;return this.c<this.a.length?!0:(y=this.b.next(),y.done?!1:(this.a=y.value[1],this.c=0,!0))},ee.We=function(){Jm(this.e,this.d.cg()),this.c!=0&&--this.c},ee.c=0,ee.d=null,oe(Pe,"InternalHashCodeMap/1",230);var tK;re(478,1,{},HS),ee.Ke=function(){return new yv(this)},ee.c=0,ee.d=0,oe(Pe,"InternalStringMap",478),re(229,1,{},yv),ee.Ve=function(){return this.c=this.a,this.a=this.b.next(),new C8(this.d,this.c,this.d.d)},ee.Ue=function(){return!this.a.done},ee.We=function(){e9(this.d,this.c.value[0])},oe(Pe,"InternalStringMap/1",229),re(479,700,kd,C8),ee.cg=function(){return this.b.value[0]},ee.dg=function(){return _a(this)},ee.eg=function(y){return em(this.a,this.b.value[0],y)},ee.c=0,oe(Pe,"InternalStringMap/2",479),re(266,691,{3:1,38:1,80:1},lI),ee.add=function(y){return uA(this,y,this.c.b,this.c),!0},ee.clear=function(){kI(this)},ee.Yf=function(y){var k,z;if(jo(y,this.b),y>=this.b>>1)for(z=this.c,k=this.b;k>y;--k)z=z.b;else for(z=this.a.a,k=0;k<y;++k)z=z.a;return new k8(this,y,z)},ee.size=function(){return this.b},ee.b=0,oe(Pe,"LinkedList",266),re(392,1,{},k8),ee.$f=function(y){uA(this.d,y,this.b.b,this.b),++this.a,this.c=null},ee.Ue=function(){return this.b!=this.d.c},ee._f=function(){return this.b.b!=this.d.a},ee.Ve=function(){return Gl(this.b!=this.d.c),this.c=this.b,this.b=this.b.a,++this.a,this.c.c},ee.ag=function(){return Gl(this.b.b!=this.d.a),this.c=this.b=this.b.b,--this.a,this.c.c},ee.We=function(){var y;Ql(!!this.c),y=this.c.a,Lq(this.d,this.c),this.b==this.c?this.b=y:--this.a,this.c=null},ee.bg=function(y){Ql(!!this.c),this.c.c=y},ee.a=0,ee.c=null,oe(Pe,"LinkedList/ListIteratorImpl",392),re(164,1,{},a1),oe(Pe,"LinkedList/Node",164),re(667,1,{});var Wp,Qx;oe(Pe,"Locale",667),re(260,667,{},X3),ee._c=function(){return""},oe(Pe,"Locale/1",260),re(261,667,{},W3),ee._c=function(){return"unknown"},oe(Pe,"Locale/4",261),re(186,1,{150:1},cC),ee.jg=function(y){this.a.Mf(y)},oe(Pe,"Spliterator/OfDouble/0methodref$accept$Type",186),re(187,1,{150:1},uC),ee.jg=function(y){T1(this.a,y)},oe(Pe,"Spliterator/OfDouble/1methodref$accept$Type",187),re(188,1,{151:1},lC),ee.kg=function(y){this.a.Mf(he(y))},oe(Pe,"Spliterator/OfInt/2methodref$accept$Type",188),re(189,1,{151:1},fC),ee.kg=function(y){T1(this.a,he(y))},oe(Pe,"Spliterator/OfInt/3methodref$accept$Type",189),re(254,152,{}),ee.hg=function(y){j1(this,new uC(y))},ee.ig=function(y){return ze(y,150)?yw(this,y):yw(this,new cC(y))},oe(Pe,"Spliterators/AbstractDoubleSpliterator",254),re(255,152,{}),ee.hg=function(y){j1(this,new fC(y))},ee.ig=function(y){return ze(y,151)?xw(this,y):xw(this,new lC(y))},oe(Pe,"Spliterators/AbstractIntSpliterator",255),re(123,1,{},zh),ee.fg=function(){return this.a},ee.gg=function(){return cv(this),this.c},ee.hg=function(y){cv(this),zB(this.d,y)},ee.ig=function(y){return ft(y),cv(this),g7(this.d)?(y.Mf(He(this.d)),!0):!1},ee.a=0,ee.c=0,oe(Pe,"Spliterators/IteratorSpliterator",123),re(199,1,{},kv),ee._c=function(){return this.a?this.e.length==0?this.a.a:this.a.a+(""+this.e):this.c},oe(Pe,"StringJoiner",199),re(702,1,ve),ee.Pf=function(){return"DUMMY"},ee.Tf=function(){return-1},ee._c=function(){return this.Pf()};var f1,nK,Jx,iK,rK,ih,oK,h1,Kp;oe(Qi,"Level",702),re(513,702,ve,K3),ee.Pf=function(){return"ALL"},ee.Tf=function(){return xu},oe(Qi,"Level/LevelAll",513),re(514,702,ve,A3),ee.Pf=function(){return"CONFIG"},ee.Tf=function(){return 700},oe(Qi,"Level/LevelConfig",514),re(515,702,ve,T3),ee.Pf=function(){return"FINE"},ee.Tf=function(){return 500},oe(Qi,"Level/LevelFine",515),re(516,702,ve,V3),ee.Pf=function(){return"FINER"},ee.Tf=function(){return 400},oe(Qi,"Level/LevelFiner",516),re(517,702,ve,I3),ee.Pf=function(){return"FINEST"},ee.Tf=function(){return 300},oe(Qi,"Level/LevelFinest",517),re(518,702,ve,z3),ee.Pf=function(){return"INFO"},ee.Tf=function(){return 800},oe(Qi,"Level/LevelInfo",518),re(519,702,ve,E3),ee.Pf=function(){return"OFF"},ee.Tf=function(){return Ki},oe(Qi,"Level/LevelOff",519),re(520,702,ve,j3),ee.Pf=function(){return"SEVERE"},ee.Tf=function(){return _r},oe(Qi,"Level/LevelSevere",520),re(521,702,ve,O3),ee.Pf=function(){return Ry},ee.Tf=function(){return 900},oe(Qi,"Level/LevelWarning",521),re(538,1,{},qC);var Lp;oe(Qi,"LogManager",538),re(635,1,ve,$I),ee.b="",ee.c=0,ee.e=null,oe(Qi,"LogRecord",635),re(137,1,{137:1},Ka),ee.e=!1;var Mp=!1,Np=!1,oi=!1,Rp=!1,Pp=!1;oe(Qi,"Logger",137),re(560,169,{},J7),oe($n,"DoubleStreamImpl",560),re(561,1,{150:1},hC),ee.jg=function(y){lR(this.a,y)},oe($n,"DoubleStreamImpl/lambda$0$Type",561),re(558,169,{},Y7),oe($n,"IntStreamImpl",558),re(559,1,{151:1},dC),ee.kg=function(y){fR(this.a,y)},oe($n,"IntStreamImpl/lambda$6$Type",559),re(530,254,{},FI),ee.lg=function(y){return yw(this,y)},oe($n,"StreamImpl/MapToDoubleSpliterator",530),re(534,1,{},aC),ee.Mf=function(y){this.a.jg((ft(y),y))},oe($n,"StreamImpl/MapToDoubleSpliterator/lambda$0$Type",534),re(529,255,{},HI),ee.lg=function(y){return xw(this,y)},oe($n,"StreamImpl/MapToIntSpliterator",529),re(533,1,{},bC),ee.Mf=function(y){this.a.kg(bt((ft(y),y)))},oe($n,"StreamImpl/MapToIntSpliterator/lambda$0$Type",533),re(709,1,{}),oe("javaemul.internal","ConsoleLogger",709);var Yx=ma("char","C"),gt=ma("int","I"),sK=ur(Bf,"ContextClickRpc"),_p=ma("double","D"),LQ=ma("float","F"),Bp=ur(lo,"UIServerRpc"),MQ=ur(_d,"DelayedCallbackRpc"),cK=oe(tp,"URLReference",null);ee=pr("Vaadin.Spreadsheet.Api",IT),ee=pr("Vaadin.Spreadsheet.CellData",qp),ee=pr("Vaadin.Spreadsheet.OverlayInfo",Fp),ee.COMPONENT=EQ,ee.IMAGE=jQ,ee=pr("Vaadin.Spreadsheet.PopupButtonState",Cg),ee=pr("Vaadin.Spreadsheet.SpreadsheetActionDetails",Hp),ee=pr("java.io.Serializable"),ee.$isInstance=PH,qo(),ee=pr("java.lang.Boolean"),ee.$isInstance=mP,ee=pr("java.lang.CharSequence"),ee.$isInstance=mF,ee=pr("java.lang.Cloneable"),ee.$isInstance=lF,ee=pr("java.lang.Comparable"),ee.$isInstance=mH,ee=pr("java.lang.Double"),ee.$isInstance=SR,ee=pr("java.lang.Number"),ee.$isInstance=qD,ee=pr("java.lang.String"),ee.$isInstance=IR,ee=pr("java.lang.Throwable"),ee.of=y9;var mi=(Qs(),XD),uK=uK=o$;Xq(VN),Bq("permProps",[[[Fy,Hy],[$y,"gecko1_8"]],[[Fy,Hy],[$y,"gecko1_8"]],[[Fy,Hy],[$y,"safari"]]]),SpreadsheetApi&&SpreadsheetApi.onScriptLoad(uK)})();let Spreadsheet=Vaadin.Spreadsheet.Api;/**
 * @license
 * Copyright 2000-2023 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */const spreadsheetStyles=i`
  :host {
    display: block;
    width: 100%;
    height: 100%;
    flex: 1 1 auto;
    isolation: isolate;
    background-color: #fff;
  }

  .v-disabled {
    cursor: default !important;
  }

  .v-spreadsheet {
    box-sizing: border-box;
    min-height: 100px;
    overflow: hidden;
    position: relative;
    padding: 0px;
    /*
    padding-bottom: $spreadsheet-toolbar-height;
    padding-left: $spreadsheet-row-header-width;
    padding-top: $spreadsheet-toolbar-height + $spreadsheet-bottom-bar-height;
     */
    border: 1px solid #c7c7c7;
    font-family: Helvetica;
    font-size: 14px;
    color: #464646;
  }
  .v-spreadsheet.hidefunctionbar {
    padding-top: 28px;
  }
  .v-spreadsheet.hidefunctionbar .functionbar {
    height: 0;
    display: none;
  }
  .v-spreadsheet.hidefunctionbar .sheet.top-right-pane,
  .v-spreadsheet.hidefunctionbar .sheet.top-left-pane {
    top: 0px;
  }
  .v-spreadsheet.hidefunctionbar .corner {
    top: 0px;
  }
  .v-spreadsheet.hidetabsheet {
    padding-bottom: 0px;
  }
  .v-spreadsheet.hidetabsheet .sheet-tabsheet {
    height: 0;
    display: none;
  }
  .v-spreadsheet.hidetabsheet .sheet.bottom-right-pane {
    bottom: 0px;
  }
  .v-spreadsheet > div {
    outline: none;
  }
  .v-spreadsheet > div,
  .v-spreadsheet .sheet > div {
    -webkit-touch-callout: none;
    -webkit-user-select: none;
    user-select: none;
  }
  .v-spreadsheet.row-resizing,
  .v-spreadsheet.row-resizing div {
    cursor: row-resize;
  }
  .v-spreadsheet.col-resizing,
  .v-spreadsheet.col-resizing div {
    cursor: col-resize;
  }
  .v-spreadsheet.selecting {
    cursor: crosshair;
  }
  .v-spreadsheet .functionbar {
    background-color: white;
    border-bottom: 1px solid #c7c7c7;
    height: 29px;
    left: 0;
    position: absolute;
    top: 0;
    width: 100%;
    z-index: 0;
  }
  .v-spreadsheet .functionbar .functionfield,
  .v-spreadsheet .functionbar .addressfield {
    box-sizing: border-box;
    font-size: 14px;
    height: 100%;
    width: 100%;
    padding: 0;
    padding-left: 5px;
    border: none;
    color: #474747;
    outline: none;
    background-color: initial;
  }
  .v-spreadsheet .functionbar .arrow {
    position: absolute;
    left: 161px;
    top: 0;
    line-height: 33px;
    font-size: x-small;
  }
  .v-spreadsheet .functionbar .namedrangebox {
    position: absolute;
    left: 161px;
    width: 15px;
    height: 100%;
    opacity: 0;
  }
  .v-spreadsheet .functionbar .fixed-left-panel {
    box-sizing: border-box;
    float: left;
    width: 176px;
    height: 100%;
    border-right: 1px solid #c7c7c7;
    background: #fafafa;
  }
  .v-spreadsheet .functionbar .adjusting-right-panel {
    box-sizing: border-box;
    overflow: hidden;
    padding-right: 5px;
    height: 100%;
  }
  .v-spreadsheet .functionbar .addressfield {
    text-align: center;
    background: #fafafa;
  }
  .v-spreadsheet .functionbar .functionfield {
    font: 400 14px/1.55 Helvetica;
  }
  .v-spreadsheet .functionbar .formulaoverlay {
    font: 400 14px/1.55 Helvetica;
    position: absolute;
    top: 3px;
    left: 181px;
    pointer-events: none;
    color: rgba(0, 0, 0, 0);
  }
  .v-spreadsheet .functionbar .formulaoverlay span {
    border-radius: 2px;
  }
  .v-spreadsheet .sheet.bottom-right-pane {
    overflow: scroll;
    right: 0;
    bottom: 28px;
    position: absolute;
  }
  .v-spreadsheet .sheet .cell {
    box-sizing: border-box;
    background-color: white;
    border-right: 1px solid #c7c7c7;
    border-bottom: 1px solid #c7c7c7;
    overflow: visible;
    padding: 0 2px;
    position: absolute;
    white-space: nowrap;
    flex-direction: column;
    justify-content: flex-end;
    line-height: normal;
  }
  .v-spreadsheet .sheet .cell.selected-cell-highlight {
    outline: solid #222222 1px;
    outline-offset: -2px;
    z-index: 1;
  }
  .v-spreadsheet .sheet .cell > .v-button {
    overflow: hidden;
    text-overflow: ellipsis;
  }
  .v-spreadsheet .sheet div.cell.r {
    text-align: right;
  }
  .v-spreadsheet .sheet div.merged-cell {
    display: block;
    overflow: hidden;
    z-index: 1 !important;
  }
  .v-spreadsheet .sheet div.custom-editor-cell {
    padding: 2px;
  }
  .v-spreadsheet .sheet.bottom-right-pane div.merged-cell {
    z-index: 1 !important;
  }
  .v-spreadsheet .sheet > input[type='text'] {
    border: 0 !important;
    box-shadow: 0px 0px 10px 0px rgba(0, 0, 0, 0.75);
    cursor: text;
    display: block !important;
    outline: none !important;
    overflow: hidden;
    padding: 0 !important;
    position: absolute;
    z-index: 3 !important;
  }
  .v-spreadsheet .sheet .floater {
    border-right: 0;
    border-bottom: 0;
    z-index: -1;
    background-color: white;
  }
  .v-spreadsheet.nogrid .sheet .cell {
    border-right: 0px;
    border-bottom: 0px;
  }
  .v-spreadsheet .top-left-pane div.merged-cell {
    z-index: 1 !important;
  }
  .v-spreadsheet .top-right-pane div.merged-cell,
  .v-spreadsheet .bottom-left-pane div.merged-cell {
    z-index: 1 !important;
  }
  .v-spreadsheet .top-left-pane,
  .v-spreadsheet .top-right-pane,
  .v-spreadsheet .bottom-left-pane {
    box-sizing: border-box;
    border-right: 1px solid #6a6a6a;
    border-bottom: 1px solid #6a6a6a;
    overflow: visible;
    position: absolute;
  }
  .v-spreadsheet .top-left-pane.inactive,
  .v-spreadsheet .top-right-pane.inactive,
  .v-spreadsheet .bottom-left-pane.inactive {
    border-right: 0;
    border-bottom: 0;
  }
  .v-spreadsheet .bottom-left-pane {
    height: 100%;
    left: 0;
    padding-bottom: 28px;
    z-index: 0;
  }
  .v-spreadsheet .bottom-left-pane .rh {
    left: 0;
    margin-top: 0 !important;
  }
  .v-spreadsheet .bottom-left-pane .cell,
  .v-spreadsheet .bottom-left-pane .sheet-image {
    margin-left: 50px;
  }
  .v-spreadsheet .bottom-left-pane .sheet-selection {
    margin-left: 51px;
  }
  .v-spreadsheet .top-left-pane {
    left: 0;
    top: 30px;
    z-index: 0;
  }
  .v-spreadsheet .top-left-pane .ch {
    top: 0;
    margin-left: 50px;
  }
  .v-spreadsheet .top-left-pane .rh {
    left: 0;
    margin-top: 27px;
  }
  .v-spreadsheet .top-left-pane .cell,
  .v-spreadsheet .top-left-pane .sheet-image {
    margin-top: 27px;
    margin-left: 50px;
  }
  .v-spreadsheet .top-left-pane .sheet-selection {
    margin-top: 28px;
    margin-left: 51px;
  }
  .v-spreadsheet .top-right-pane {
    top: 30px;
    width: 100%;
    z-index: 0;
  }
  .v-spreadsheet .top-right-pane .ch {
    top: 0;
    margin-left: 0 !important;
  }
  .v-spreadsheet .top-right-pane .cell,
  .v-spreadsheet .top-right-pane .sheet-image {
    margin-top: 27px;
  }
  .v-spreadsheet .top-right-pane .sheet-selection {
    margin-top: 28px;
  }
  .v-spreadsheet.noheaders .top-left-pane .cell,
  .v-spreadsheet.noheaders .top-left-pane .sheet-image,
  .v-spreadsheet.noheaders .top-right-pane .cell,
  .v-spreadsheet.noheaders .top-right-pane .sheet-image {
    margin-top: 0;
  }
  .v-spreadsheet.noheaders .top-left-pane .sheet-selection,
  .v-spreadsheet.noheaders .top-right-pane .sheet-selection {
    margin-top: 1px;
  }
  .v-spreadsheet.noheaders .top-left-pane .cell,
  .v-spreadsheet.noheaders .top-left-pane .sheet-image,
  .v-spreadsheet.noheaders .bottom-left-pane .cell,
  .v-spreadsheet.noheaders .bottom-left-pane .sheet-image {
    margin-left: 0;
  }
  .v-spreadsheet.noheaders .top-left-pane .sheet-selection,
  .v-spreadsheet.noheaders .bottom-left-pane .sheet-selection {
    margin-left: 1px;
  }
  .v-spreadsheet .ch,
  .v-spreadsheet .rh,
  .v-spreadsheet .corner {
    background-color: #fafafa;
    font-family: Helvetica;
    font-size: 13px;
    overflow: hidden;
    position: absolute;
    text-align: center;
  }
  .v-spreadsheet .rh {
    box-sizing: border-box;
    -webkit-user-select: none;
    user-select: none;
    border-right: 1px solid #c7c7c7;
    cursor: e-resize;
    -webkit-touch-callout: none;
    width: 50px;
    z-index: 2;
    display: flex;
    justify-content: center;
    vertical-align: middle;
    flex-direction: column;
    line-height: 100%;
  }
  .v-spreadsheet .rh.selected-row-header {
    background: #e6edf4 !important;
    border-right: 2px solid #63b1ff;
  }
  .v-spreadsheet .rh .header-resize-dnd-first,
  .v-spreadsheet .rh .header-resize-dnd-second {
    background: transparent;
    cursor: row-resize;
    height: 3px;
    position: absolute;
    left: 0;
    width: 49px;
    z-index: 2;
  }
  .v-spreadsheet .rh .header-resize-dnd-first {
    top: 0;
  }
  .v-spreadsheet .rh .header-resize-dnd-second {
    border-bottom: 1px solid #c7c7c7;
    bottom: 0;
  }
  .v-spreadsheet .rh.resize-extra {
    border-bottom: 1px solid #c7c7c7;
  }
  .v-spreadsheet .ch {
    background-color: #fafafa;
    background-image: linear-gradient(to bottom, #fafafa 2%, #f0f0f0 98%);
    box-sizing: border-box;
    -webkit-user-select: none;
    user-select: none;
    border-bottom: 1px solid #c7c7c7;
    cursor: s-resize;
    height: 27px;
    line-height: 27px;
    -webkit-touch-callout: none;
    z-index: 2;
  }
  .v-spreadsheet .ch.selected-column-header {
    background: #e6edf4 !important;
    border-bottom: 2px solid #63b1ff;
  }
  .v-spreadsheet .ch .header-resize-dnd-first,
  .v-spreadsheet .ch .header-resize-dnd-second {
    background: transparent;
    cursor: col-resize;
    height: 27px;
    position: absolute;
    top: 0;
    width: 3px;
    z-index: 2;
  }
  .v-spreadsheet .ch .header-resize-dnd-first {
    left: 0;
  }
  .v-spreadsheet .ch .header-resize-dnd-second {
    border-right: 1px solid #c7c7c7;
    right: 0;
  }
  .v-spreadsheet .ch.resize-extra {
    border-right: 1px solid #c7c7c7;
  }
  .v-spreadsheet.protected.lock-format-columns .ch .header-resize-dnd-first,
  .v-spreadsheet.protected.lock-format-columns .ch .header-resize-dnd-second,
  .v-spreadsheet.protected.lock-format-rows .rh .header-resize-dnd-first,
  .v-spreadsheet.protected.lock-format-rows .rh .header-resize-dnd-second {
    cursor: default;
  }
  .v-spreadsheet.noheaders {
    padding-left: 0px;
    padding-top: 30px;
  }
  .v-spreadsheet.noheaders .ch,
  .v-spreadsheet.noheaders .rh,
  .v-spreadsheet.noheaders .corner {
    display: none;
  }
  .v-spreadsheet .ch.col1 .header-resize-dnd-first,
  .v-spreadsheet .rh.row1 .header-resize-dnd-first {
    display: none;
  }
  .v-spreadsheet > div.resize-line {
    background: #197de1;
  }
  .v-spreadsheet .resize-line,
  .v-spreadsheet .sheet > div.resize-line {
    border: none;
    height: 0;
    padding: 0;
    visibility: hidden;
    width: 0;
    z-index: 2;
    position: absolute;
  }
  .v-spreadsheet.col-resizing .resize-line,
  .v-spreadsheet.col-resizing .sheet > div.resize-line {
    height: 100%;
    visibility: visible;
    width: 1px;
  }
  .v-spreadsheet.col-resizing > .resize-line {
    margin-left: 49px;
    margin-top: -28px;
  }
  .v-spreadsheet.col-resizing .sheet > div.resize-line {
    margin-left: -1px;
  }
  .v-spreadsheet.row-resizing .resize-line,
  .v-spreadsheet.row-resizing .sheet > div.resize-line {
    height: 1px;
    visibility: visible;
    width: 100%;
  }
  .v-spreadsheet.row-resizing > .resize-line {
    margin-top: 56px;
    margin-left: -50px;
  }
  .v-spreadsheet.row-resizing .sheet > div.resize-line {
    margin-top: -1px;
  }
  .v-spreadsheet .corner {
    background-color: #fafafa;
    background-image: linear-gradient(to bottom, #fafafa 2%, #f0f0f0 98%);
    box-sizing: border-box;
    cursor: default;
    top: 30px;
    left: 0;
    width: 50px;
    height: 27px;
    border-bottom: 1px solid #c7c7c7;
    border-right: 1px solid #c7c7c7;
    z-index: 1;
  }
  .v-spreadsheet .sheet > div.sheet-image {
    background: transparent;
    border: none;
    cursor: default;
    height: auto;
    width: auto;
    position: absolute;
  }
  .v-spreadsheet .bottom-right-pane.sheet > div.sheet-image {
    z-index: 1;
  }
  .v-spreadsheet .top-left-pane > div.sheet-image {
    z-index: 1;
  }
  .v-spreadsheet .top-right-pane > div.sheet-image,
  .v-spreadsheet .bottom-left-pane > div.sheet-image {
    z-index: 1;
  }
  .v-spreadsheet .sheet .cell-comment-triangle {
    border-color: transparent #ffcf16 transparent transparent;
    border-style: solid;
    border-width: 0 9px 9px 0;
    height: 0;
    line-height: 0;
    margin: 0;
    padding: 0;
    position: absolute;
    right: 0;
    top: 0;
    width: 0;
    z-index: 1;
  }
  .v-spreadsheet .sheet .cell-invalidformula-triangle {
    border-color: transparent #ed473b transparent transparent;
    border-style: solid;
    border-width: 0 9px 9px 0;
    height: 0;
    line-height: 0;
    margin: 0;
    padding: 0;
    position: absolute;
    right: 0;
    top: 0;
    width: 0;
    z-index: 1;
  }
  .v-spreadsheet .sheet .comment-overlay-line {
    background-color: #a7a7a7 !important;
    border: none !important;
    display: block !important;
    height: 1px;
    padding: 0;
    position: absolute;
    transform-origin: 0% 50%;
    z-index: 1;
  }
  .v-spreadsheet div.sheet-selection {
    background-color: transparent !important;
    border: none !important;
    display: block;
    position: absolute;
    width: 0px;
    height: 0px;
    overflow: visible;
    pointer-events: none;
    margin-left: 1px;
    margin-top: 1px;
  }
  .v-spreadsheet div.sheet-selection.col0.row0 {
    display: none;
  }
  .v-spreadsheet.notfocused .sheet-selection {
    opacity: 0.6;
  }
  .v-spreadsheet .sheet-selection .s-top,
  .v-spreadsheet .sheet-selection .s-left,
  .v-spreadsheet .sheet-selection .s-bottom,
  .v-spreadsheet .sheet-selection .s-right {
    padding: 0;
    background-color: #197de1;
    position: absolute;
  }
  .v-spreadsheet .sheet-selection .s-top.extend,
  .v-spreadsheet .sheet-selection .s-left.extend,
  .v-spreadsheet .sheet-selection .s-bottom.extend,
  .v-spreadsheet .sheet-selection .s-right.extend {
    background-color: #40b527 !important;
  }
  .v-spreadsheet .sheet-selection .s-top {
    top: -2px;
    left: -2px;
    height: 2px;
    pointer-events: all;
  }
  .v-spreadsheet .sheet-selection .s-left {
    width: 2px;
    padding-bottom: 1px;
  }
  .v-spreadsheet .sheet-selection .s-bottom {
    height: 2px;
    bottom: 0;
  }
  .v-spreadsheet .sheet-selection .s-right {
    right: 0;
    width: 2px;
  }
  .v-spreadsheet .sheet-selection .s-corner {
    background-color: #40b527;
    position: absolute;
    bottom: -2px;
    left: -2px;
    height: 6px;
    width: 6px;
    outline: 2px solid white;
    cursor: crosshair;
  }
  .v-spreadsheet .sheet-selection.paintmode {
    background-color: rgba(235, 247, 233, 0.8) !important;
  }
  .v-spreadsheet .sheet-selection.paintmode .s-top,
  .v-spreadsheet .sheet-selection.paintmode .s-left,
  .v-spreadsheet .sheet-selection.paintmode .s-bottom,
  .v-spreadsheet .sheet-selection.paintmode .s-right {
    background-color: #40b527;
  }
  .v-spreadsheet .sheet-tabsheet {
    background: #fafafa;
    border-top: 1px solid #c7c7c7;
    height: 28px;
    width: 100%;
    cursor: default;
    position: absolute;
    bottom: 0;
    left: 0;
    overflow: hidden;
    z-index: 1;
  }
  .v-spreadsheet .sheet-tabsheet .sheet-tabsheet-options {
    background: #fafafa;
    cursor: pointer;
    display: inline-block;
    height: 28px;
    position: absolute;
    width: 130px;
    z-index: 3;
    left: 0;
    top: 0;
  }
  .v-spreadsheet .sheet-tabsheet .sheet-tabsheet-options div {
    line-height: 26px;
    width: 26px;
    cursor: pointer;
    display: inline-block;
    font-weight: bold;
    position: relative;
    text-align: center;
    z-index: inherit;
    color: #464646;
  }
  .v-spreadsheet .sheet-tabsheet .sheet-tabsheet-options div.scroll-tabs-beginning::before,
  .v-spreadsheet .sheet-tabsheet .sheet-tabsheet-options div.scroll-tabs-end::before,
  .v-spreadsheet .sheet-tabsheet .sheet-tabsheet-options div.scroll-tabs-left::before,
  .v-spreadsheet .sheet-tabsheet .sheet-tabsheet-options div.scroll-tabs-right::before,
  .v-spreadsheet .sheet-tabsheet .sheet-tabsheet-options div.add-new-tab::before {
    content: '';
    width: 20px;
    height: 20px;
    display: inline-block;
    vertical-align: middle;
    background: currentColor;
    -webkit-mask-image: var(--mask-image);
    mask-image: var(--mask-image);
    --mask-image: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M15.707 15.707a1 1 0 01-1.414 0l-5-5a1 1 0 010-1.414l5-5a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 010 1.414zm-6 0a1 1 0 01-1.414 0l-5-5a1 1 0 010-1.414l5-5a1 1 0 011.414 1.414L5.414 10l4.293 4.293a1 1 0 010 1.414z" clip-rule="evenodd" /></svg>');
  }
  .v-spreadsheet .sheet-tabsheet .sheet-tabsheet-options div.scroll-tabs-end::before {
    --mask-image: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M10.293 15.707a1 1 0 010-1.414L14.586 10l-4.293-4.293a1 1 0 111.414-1.414l5 5a1 1 0 010 1.414l-5 5a1 1 0 01-1.414 0z" clip-rule="evenodd" /><path fill-rule="evenodd" d="M4.293 15.707a1 1 0 010-1.414L8.586 10 4.293 5.707a1 1 0 011.414-1.414l5 5a1 1 0 010 1.414l-5 5a1 1 0 01-1.414 0z" clip-rule="evenodd" /></svg>');
  }
  .v-spreadsheet .sheet-tabsheet .sheet-tabsheet-options div.scroll-tabs-left::before {
    --mask-image: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M12.707 5.293a1 1 0 010 1.414L9.414 10l3.293 3.293a1 1 0 01-1.414 1.414l-4-4a1 1 0 010-1.414l4-4a1 1 0 011.414 0z" clip-rule="evenodd" /></svg>');
  }
  .v-spreadsheet .sheet-tabsheet .sheet-tabsheet-options div.scroll-tabs-right::before {
    --mask-image: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd" /></svg>');
  }
  .v-spreadsheet .sheet-tabsheet .sheet-tabsheet-options div.add-new-tab::before {
    --mask-image: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z" clip-rule="evenodd" /></svg>');
  }
  .v-spreadsheet .sheet-tabsheet .sheet-tabsheet-options div:hover {
    color: #197de1;
  }
  .v-spreadsheet .sheet-tabsheet .sheet-tabsheet-options div.hidden {
    color: #d6d6d6;
    cursor: default;
  }
  .v-spreadsheet .sheet-tabsheet .sheet-tabsheet-container {
    transition: margin-left 200ms;
    display: inline-block;
    left: 130px;
    position: absolute;
    z-index: inherit;
    margin-right: 206px;
    height: 25px;
    overflow: hidden;
    white-space: nowrap;
  }
  .v-spreadsheet .sheet-tabsheet .sheet-tabsheet-container .sheet-tabsheet-tab {
    font-family: Helvetica;
    font-size: 14px;
    font-weight: 300;
    background: #fafafa;
    color: #6a6a6a;
    border: 1px solid #c7c7c7;
    border-top: none;
    border-bottom-right-radius: 5px;
    border-bottom-left-radius: 5px;
    cursor: pointer;
    display: inline-block;
    height: 20px;
    margin-left: 5px;
    max-width: 200px;
    min-width: 50px;
    overflow: hidden;
    padding: 2px 6px;
    position: relative;
    text-align: center;
    text-overflow: ellipsis;
    top: -1px;
    z-index: inherit;
  }
  .v-spreadsheet .sheet-tabsheet .sheet-tabsheet-container .sheet-tabsheet-tab.selected-tab {
    background: #ffffff;
    cursor: default;
    color: #2584e2;
    max-width: none;
    position: relative;
  }
  .v-spreadsheet .sheet-tabsheet .sheet-tabsheet-container .sheet-tabsheet-tab.selected-tab input[type='text'] {
    font-family: Helvetica;
    font-size: 14px;
    color: #2584e2;
    border: none !important;
    font-weight: 300;
    height: 20px;
    outline: none !important;
    padding: 0 !important;
    position: relative;
    top: 0;
    left: 0;
    width: inherit;
  }
  .v-spreadsheet .sheet-tabsheet .sheet-tabsheet-temp {
    font-family: Helvetica;
    font-size: 14px;
    display: inline;
    left: -5000px;
    position: fixed;
    white-space-collapse: preserve;
  }
  .v-spreadsheet .sheet-tabsheet .sheet-tabsheet-infolabel {
    background: #fafafa;
    z-index: inherit;
    position: absolute;
    right: 0;
    font-weight: bold;
    font-size: 11px;
    border-left: 1px solid #c7c7c7;
    padding-left: 5px;
    padding-right: 5px;
    width: 200px;
    height: 100%;
    line-height: 29px;
    display: inline;
    text-overflow: ellipsis;
    overflow: hidden;
    white-space: nowrap;
  }
  .v-spreadsheet .sheet-tabsheet,
  .v-spreadsheet .sheet-tabsheet div {
    -webkit-touch-callout: none;
    -webkit-user-select: none;
    user-select: none;
  }
  .v-spreadsheet .sheet div div.popupbutton {
    padding: 0;
    color: #191919;
    font-weight: 400;
    white-space: nowrap;
    outline: none;
    position: absolute;
    bottom: 0px;
    right: 1px;
    cursor: pointer;
    height: 11px;
    width: 11px;
    border: solid 1px lightgrey;
    background: white;
    border-radius: 2px;
    display: flex;
    align-items: center;
    justify-content: center;
  }
  .v-spreadsheet .sheet div div.popupbutton:after {
    content: '▼';
    color: grey;
    font-size: 9px;
    vertical-align: top;
  }
  .v-spreadsheet .sheet div div.popupbutton.v-disabled {
    opacity: 0.5;
  }
  .popupbutton.active {
    box-shadow: rgb(0 171 238) 0 2px 0 0 inset;
  }
  .v-spreadsheet .sheet-selection.touch.fill .fill-touch-square {
    position: relative;
    width: 30px;
    height: 30px;
    margin-left: -15px;
    top: -15px;
  }
  .v-spreadsheet .sheet-selection.touch.fill .fill-touch-square > .square {
    position: absolute;
    background-color: #40b527;
    width: 6px;
    height: 6px;
    border: 2px solid white;
    top: -4px;
  }
  .v-spreadsheet .sheet-selection.touch.fill .s-right > .fill-touch-square,
  .v-spreadsheet .sheet-selection.touch.fill .s-left > .fill-touch-square {
    top: 50%;
    margin-top: -15px;
  }
  .v-spreadsheet .sheet-selection.touch.fill .s-right > .fill-touch-square > .square,
  .v-spreadsheet .sheet-selection.touch.fill .s-left > .fill-touch-square > .square {
    top: 11px;
    left: 11px;
  }
  .v-spreadsheet .sheet-selection.touch.fill .s-top > .fill-touch-square {
    top: -20px;
    left: 50%;
  }
  .v-spreadsheet .sheet-selection.touch.fill .s-top > .fill-touch-square > .square {
    left: 50%;
    margin-top: 20px;
    margin-left: -4px;
  }
  .v-spreadsheet .sheet-selection.touch.fill .s-bottom > .fill-touch-square {
    top: -8px;
    left: 50%;
  }
  .v-spreadsheet .sheet-selection.touch.fill .s-bottom > .fill-touch-square > .square {
    left: 50%;
    margin-top: 8px;
    margin-left: -4px;
  }
  .v-spreadsheet .sheet-selection.touch .s-corner {
    width: 7px;
    height: 7px;
    left: 7px;
    bottom: 7px;
    background-color: #197de1;
    border-radius: 5px;
  }
  .v-spreadsheet .sheet-selection.touch .s-corner-touch {
    width: 30px;
    height: 30px;
    position: absolute;
    left: -10px;
    bottom: -10px;
  }
  .v-spreadsheet .col-group-pane,
  .v-spreadsheet .col-group-freeze-pane {
    position: absolute;
    left: 0;
    width: 100%;
    z-index: 1;
    background-color: #fafafa;
    border-bottom: 1px solid #c7c7c7;
    box-sizing: border-box;
  }
  .v-spreadsheet .col-group-pane .grouping,
  .v-spreadsheet .col-group-freeze-pane .grouping {
    position: absolute;
    height: 7px;
    border-top: 2px solid #c7c7c7;
    border-left: 2px solid #c7c7c7;
    cursor: pointer;
  }
  .v-spreadsheet .col-group-pane .grouping .expand,
  .v-spreadsheet .col-group-freeze-pane .grouping .expand {
    position: relative;
    top: -7px;
    float: right;
    right: -4px;
    height: 12px;
    width: 12px;
    background-color: #c7c7c7;
    color: white;
    border: none;
    line-height: 11px;
    text-align: center;
    vertical-align: middle;
    border-radius: 50%;
    font-size: 12px;
  }
  .v-spreadsheet .col-group-pane .grouping.plus,
  .v-spreadsheet .col-group-freeze-pane .grouping.plus {
    border: none;
  }
  .v-spreadsheet .col-group-pane .grouping.plus .expand,
  .v-spreadsheet .col-group-freeze-pane .grouping.plus .expand {
    top: -5px;
  }
  .v-spreadsheet .col-group-pane .grouping.inversed,
  .v-spreadsheet .col-group-freeze-pane .grouping.inversed {
    border-right: 2px solid #c7c7c7;
    border-left: none;
  }
  .v-spreadsheet .col-group-pane .grouping.inversed .expand,
  .v-spreadsheet .col-group-freeze-pane .grouping.inversed .expand {
    right: initial;
    left: -4px;
    float: none;
  }
  .v-spreadsheet .col-group-freeze-pane {
    overflow: hidden;
    border-right: 1px solid #6a6a6a;
  }
  .v-spreadsheet .col-group-border {
    position: absolute;
  }
  .v-spreadsheet .col-group-border .border {
    position: absolute;
    width: 100%;
    z-index: 1;
    border-bottom: 1px dotted #c7c7c7;
    margin-top: 20px;
  }
  .v-spreadsheet .row-group-pane,
  .v-spreadsheet .row-group-freeze-pane {
    position: absolute;
    left: 0;
    height: 100%;
    z-index: 1;
    background-color: #fafafa;
    border-right: 1px solid #c7c7c7;
    box-sizing: border-box;
  }
  .v-spreadsheet .row-group-pane .grouping,
  .v-spreadsheet .row-group-freeze-pane .grouping {
    position: absolute;
    width: 8px;
    border-top: 2px solid #c7c7c7;
    border-left: 2px solid #c7c7c7;
    cursor: pointer;
  }
  .v-spreadsheet .row-group-pane .grouping.plus,
  .v-spreadsheet .row-group-freeze-pane .grouping.plus {
    border: none;
  }
  .v-spreadsheet .row-group-pane .grouping .expand,
  .v-spreadsheet .row-group-freeze-pane .grouping .expand {
    position: absolute;
    bottom: -4px;
    right: 2px;
    height: 12px;
    width: 12px;
    background-color: #c7c7c7;
    color: white;
    border: none;
    line-height: 11px;
    text-align: center;
    vertical-align: middle;
    border-radius: 50%;
    font-size: 12px;
  }
  .v-spreadsheet .row-group-pane .grouping.plus .expand,
  .v-spreadsheet .row-group-freeze-pane .grouping.plus .expand {
    right: 0;
  }
  .v-spreadsheet .row-group-pane .grouping.inversed,
  .v-spreadsheet .row-group-freeze-pane .grouping.inversed {
    border-top: none;
    border-bottom: 2px solid #c7c7c7;
  }
  .v-spreadsheet .row-group-pane .grouping.inversed .expand,
  .v-spreadsheet .row-group-freeze-pane .grouping.inversed .expand {
    bottom: initial;
    top: -5px;
  }
  .v-spreadsheet .row-group-freeze-pane {
    overflow: hidden;
    border-bottom: 1px solid #6a6a6a;
  }
  .v-spreadsheet .row-group-border {
    position: absolute;
  }
  .v-spreadsheet .row-group-border .border {
    position: absolute;
    height: 100%;
    z-index: 1;
    border-right: 1px dotted #c7c7c7;
    /*margin-top: 20px;*/
  }
  .v-spreadsheet .expandbutton {
    height: 18px;
    width: 11px;
    line-height: 18px;
    font-size: 11px;
    text-align: center;
    cursor: pointer;
    color: #484848;
  }
  .v-spreadsheet .expandbutton span {
    vertical-align: text-top;
  }
  .v-spreadsheet .expandbutton:active {
    border-color: gray;
  }
  .v-spreadsheet .col-group-summary .expandbutton {
    margin-left: auto;
    margin-right: 4px;
    /*margin-top: 7px;*/
  }
  .v-spreadsheet .row-group-summary .expandbutton {
    display: inline-block;
    margin-left: 4px;
  }
  .v-spreadsheet .grouping-corner {
    position: absolute;
    left: 0;
    z-index: 1;
    border-right: 1px solid #c7c7c7;
    border-bottom: 1px solid #c7c7c7;
    box-sizing: border-box;
    background-color: #fafafa;
  }
  .v-spreadsheet .col-group-summary {
    position: absolute;
    box-sizing: border-box;
    border-bottom: 1px solid #c7c7c7;
    border-right: 1px solid #c7c7c7;
    background-color: #fafafa;
    z-index: 1;
  }
  .v-spreadsheet .row-group-summary {
    position: absolute;
    box-sizing: border-box;
    border-bottom: 1px solid #c7c7c7;
    border-right: 1px solid #c7c7c7;
    background-color: #fafafa;
    left: 0;
    z-index: 1;
  }
  .v-spreadsheet .grouping .expand {
    line-height: 13px;
  }

  .cell-range-bg-color {
    background-color: rgba(232, 242, 252, 0.8);
  }
  span.code-snippet {
    font-family: 'Courier New', Courier, monospace;
  }
  .v-label-overlay-content {
    padding: 10px;
  }
  .sheet-image > .v-csslayout {
    overflow: visible;
    position: relative;
  }
  .sheet-image > .v-csslayout .v-button-minimize-button {
    top: -14px;
    position: absolute;
    height: auto;
    padding: 0;
  }
  .sheet-image > .v-csslayout .v-button-minimize-button::after {
    box-shadow: none;
  }
  .sheet-image > .v-csslayout .v-button-minimize-button .v-button-caption {
    display: none;
  }
  .clear-filters-button {
    width: 100%;
  }
`,spreadsheetOverlayStyles=i`
  @keyframes valo-animate-in-fade {
    0% {
      opacity: 0;
    }
  }

  @keyframes valo-animate-out-fade {
    100% {
      opacity: 0;
    }
  }

  @keyframes valo-overlay-animate-in {
    0% {
      transform: translateY(-4px);
      opacity: 0;
    }
  }

  #spreadsheet-overlays .v-tooltip {
    background-color: rgba(50, 50, 50, 0.9);
    box-shadow: 0 2px 12px rgba(0, 0, 0, 0.2);
    color: white;
    padding: 5px 9px;
    border-radius: 3px;
    max-width: 35em;
    overflow: hidden !important;
    font-size: 14px;
  }
  #spreadsheet-overlays .v-tooltip div[style*='width'] {
    width: auto !important;
  }
  #spreadsheet-overlays .v-tooltip .v-errormessage {
    background-color: white;
    background-color: #fff;
    color: #ed473b;
    margin: -5px -9px;
    padding: 5px 9px;
    max-height: 10em;
    overflow: auto;
    font-weight: 400;
  }
  #spreadsheet-overlays .v-tooltip .v-errormessage h2:only-child {
    font: inherit;
    line-height: inherit;
  }
  #spreadsheet-overlays .v-tooltip .v-errormessage-info {
    color: #00a7f5;
  }
  #spreadsheet-overlays .v-tooltip .v-errormessage-warning {
    color: #fc9c00;
  }
  #spreadsheet-overlays .v-tooltip .v-errormessage-error {
    color: #ed473b;
  }
  #spreadsheet-overlays .v-tooltip .v-errormessage-critical {
    color: #fa007d;
  }
  #spreadsheet-overlays .v-tooltip .v-errormessage-system {
    color: #bb00ff;
  }
  #spreadsheet-overlays .v-tooltip .v-tooltip-text {
    max-height: 10em;
    overflow: auto;
    margin-top: 10px;
  }
  #spreadsheet-overlays .v-tooltip .v-tooltip-text pre {
    margin: 0px;
  }
  #spreadsheet-overlays .v-tooltip .v-errormessage[aria-hidden='true'] .v-tooltip-text {
    margin-top: 0;
  }
  #spreadsheet-overlays .v-tooltip h1,
  #spreadsheet-overlays .v-tooltip h2,
  #spreadsheet-overlays .v-tooltip h3,
  #spreadsheet-overlays .v-tooltip h4 {
    color: inherit;
  }
  #spreadsheet-overlays .v-tooltip pre.v-tooltip-pre {
    font: inherit;
    white-space: pre-wrap;
  }
  #spreadsheet-overlays .v-contextmenu {
    padding: 4px 4px;
    border-radius: 4px;
    background-color: white;
    color: #474747;
    box-shadow: 0 4px 10px 0 rgba(0, 0, 0, 0.1), 0 3px 5px 0 rgba(0, 0, 0, 0.05), 0 0 0 1px rgba(0, 0, 0, 0.091);
    -webkit-backface-visibility: hidden;
    backface-visibility: hidden;
    padding: 4px 4px;
  }
  #spreadsheet-overlays .v-contextmenu[class*='animate-in'] {
    animation: valo-overlay-animate-in 120ms;
  }
  #spreadsheet-overlays .v-contextmenu[class*='animate-out'] {
    animation: valo-animate-out-fade 120ms;
  }
  #spreadsheet-overlays .v-contextmenu table {
    border-spacing: 0;
  }
  #spreadsheet-overlays .v-contextmenu .gwt-MenuItem {
    cursor: pointer;
    line-height: 27px;
    padding: 0 20px 0 10px;
    border-radius: 3px;
    font-weight: 400;
    white-space: nowrap;
    position: relative;
    display: block;
  }
  #spreadsheet-overlays .v-contextmenu .gwt-MenuItem:active:before {
    content: '';
    position: absolute;
    top: 0;
    right: 0;
    bottom: 0;
    left: 0;
    background: #0957a6;
    opacity: 0.15;
    filter: alpha(opacity=15);
    pointer-events: none;
    border-radius: inherit;
  }
  #spreadsheet-overlays .v-contextmenu .gwt-MenuItem .v-icon {
    max-height: 27px;
    margin-right: 5px;
    min-width: 1em;
  }
  #spreadsheet-overlays .v-contextmenu .gwt-MenuItem-selected {
    background-color: #197de1;
    background-image: linear-gradient(to bottom, #1b87e3 2%, #166ed6 98%);
    color: #ecf2f8;
    text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.05);
  }

  #spreadsheet-overlays .v-spreadsheet-comment-overlay {
    padding: 4px 4px;
    border-radius: 4px;
    background-color: white;
    color: #474747;
    box-shadow: 0 4px 10px 0 rgba(0, 0, 0, 0.1), 0 3px 5px 0 rgba(0, 0, 0, 0.05), 0 0 0 1px rgba(0, 0, 0, 0.091);
    -webkit-backface-visibility: hidden;
    backface-visibility: hidden;
    padding: 7px;
    overflow-y: auto !important;
    overflow-x: hidden !important;
    -webkit-user-select: text;
    user-select: text;
  }
  #spreadsheet-overlays .v-spreadsheet-comment-overlay[class*='animate-in'] {
    animation: valo-overlay-animate-in 120ms;
  }
  #spreadsheet-overlays .v-spreadsheet-comment-overlay[class*='animate-out'] {
    animation: valo-animate-out-fade 120ms;
  }
  #spreadsheet-overlays .v-spreadsheet-comment-overlay .popupContent {
    overflow: visible;
    z-index: 2;
  }
  #spreadsheet-overlays .v-spreadsheet-comment-overlay .comment-overlay-author {
    padding-bottom: 7px;
    font-size: 11px;
    font-weight: bold;
    white-space: nowrap;
  }
  #spreadsheet-overlays .v-spreadsheet-comment-overlay .comment-overlay-invalidformula {
    color: #ed473b;
    max-width: 168px;
    max-height: 140px;
    white-space: pre-wrap;
    word-wrap: break-word;
  }
  #spreadsheet-overlays .v-spreadsheet-comment-overlay .comment-overlay-label {
    max-width: 168px;
    max-height: 140px;
    white-space: pre-wrap;
    word-wrap: break-word;
  }
  #spreadsheet-overlays .v-spreadsheet-comment-overlay .comment-overlay-input {
    max-width: 168px;
    max-height: 140px;
    font-family: Helvetica;
    font-size: 14px;
    font-weight: 300;
    outline: none;
    border: none;
  }
  #spreadsheet-overlays .v-spreadsheet-comment-overlay .comment-overlay-separator {
    border-bottom: 1px solid #c7c7c7;
    margin-bottom: 7px;
  }
  #spreadsheet-overlays .v-spreadsheet-popupbutton-overlay {
    padding: 4px 4px;
    border-radius: 4px;
    background-color: var(--lumo-base-color, #fff);
    color: #474747;
    box-shadow: 0 4px 10px 0 rgba(0, 0, 0, 0.1), 0 3px 5px 0 rgba(0, 0, 0, 0.05), 0 0 0 1px rgba(0, 0, 0, 0.091);
    -webkit-backface-visibility: hidden;
    backface-visibility: hidden;
  }
  #spreadsheet-overlays .v-spreadsheet-popupbutton-overlay[class*='animate-in'] {
    animation: valo-overlay-animate-in 120ms;
  }
  #spreadsheet-overlays .v-spreadsheet-popupbutton-overlay[class*='animate-out'] {
    animation: valo-animate-out-fade 120ms;
  }
  #spreadsheet-overlays .v-spreadsheet-popupbutton-overlay .v-panel.spreadsheet-item-filter-layout {
    background-color: transparent;
    border: none;
    height: 275px;
  }
  #spreadsheet-overlays .v-spreadsheet-popupbutton-overlay .v-panel.spreadsheet-item-filter-layout .v-panel-captionwrap,
  #spreadsheet-overlays .v-spreadsheet-popupbutton-overlay .v-panel.spreadsheet-item-filter-layout .v-panel-content,
  #spreadsheet-overlays .v-spreadsheet-popupbutton-overlay .v-panel.spreadsheet-item-filter-layout .v-panel-deco {
    background-color: transparent;
    border: none;
  }
  #spreadsheet-overlays .spreadsheet-item-filter-layout {
    display: flex;
    flex-direction: column;
    gap: 4px;
    max-height: 275px;
    overflow-y: auto;
  }

  #spreadsheet-overlays .spreadsheet-filter-table-content {
    display: flex;
    flex-direction: column;
    gap: 4px;
  }
  #spreadsheet-overlays .v-spreadsheet-popupbutton-overlay-header {
    height: 18px;
    position: relative;
    width: 100%;
    padding-bottom: 7px;
  }
  #spreadsheet-overlays .v-spreadsheet-popupbutton-overlay-header .v-window-closebox {
    position: absolute;
    left: 0px;
    top: 0px;
    width: 18px;
    height: 18px;
    line-height: 18px;
    cursor: pointer;
    box-sizing: border-box;
    font-size: 21px;
    color: #999999;
    padding-right: 4px;
    border-radius: 0 4px 0 4px;
    text-align: center;
  }
  #spreadsheet-overlays .v-spreadsheet-popupbutton-overlay-header .v-window-closebox:hover {
    color: #197de1;
  }
  #spreadsheet-overlays .v-spreadsheet-popupbutton-overlay-header .v-window-closebox:before {
    content: '\\00d7';
  }
  #spreadsheet-overlays .v-spreadsheet-popupbutton-overlay-header .header-caption {
    margin: 0 18px;
    height: 18px;
    line-height: 18px;
    text-align: center;
    color: var(--lumo-body-text-color);
  }
`;/**
 * @license
 * Copyright 2000-2023 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */const spreadsheetResizeObserver=new ResizeObserver(ae=>{ae.forEach(ue=>ue.target.api.resize())}),overlayStyles=(()=>{const ae=document.createElement("template");return ae.innerHTML=`<style>${spreadsheetOverlayStyles.toString()}</style>`,ae.content})();class VaadinSpreadsheet extends s{static get styles(){return spreadsheetStyles}static get properties(){return{api:{type:Object},dirty:{type:Number},id:{type:String},class:{type:String},resources:{type:String},popupbuttons:{type:String},rowBufferSize:{type:Number},columnBufferSize:{type:Number},rows:{type:Number},cols:{type:Number},colGroupingData:{type:Object},rowGroupingData:{type:Object},colGroupingMax:{type:Number},rowGroupingMax:{type:Number},colGroupingInversed:{type:Boolean},rowGroupingInversed:{type:Boolean},defRowH:{type:Number},defColW:{type:Number},rowH:{type:Object},colW:{type:Object},reload:{type:Number},sheetIndex:{type:Number},sheetNames:{type:Object},cellStyleToCSSStyle:{type:Object},rowIndexToStyleIndex:{type:Object},columnIndexToStyleIndex:{type:Object},lockedColumnIndexes:{type:Object},lockedRowIndexes:{type:Object},shiftedCellBorderStyles:{type:Object},conditionalFormattingStyles:{type:Object},hiddenColumnIndexes:{type:Object},hiddenRowIndexes:{type:Object},verticalScrollPositions:{type:Object},horizontalScrollPositions:{type:Object},sheetProtected:{type:Boolean},workbookProtected:{type:Boolean},cellKeysToEditorIdMap:{type:Object},componentIDtoCellKeysMap:{type:Object},hyperlinksTooltips:{type:Object},cellComments:{type:Object},cellCommentAuthors:{type:Object},visibleCellComments:{type:Object},invalidFormulaCells:{type:Object},hasActions:{type:Boolean},overlays:{type:Object},mergedRegions:{type:Object},displayGridlines:{type:Boolean},displayRowColHeadings:{type:Boolean},verticalSplitPosition:{type:Number},horizontalSplitPosition:{type:Number},infoLabelValue:{type:String},workbookChangeToggle:{type:Boolean},invalidFormulaErrorMessage:{type:String},lockFormatColumns:{type:Boolean},lockFormatRows:{type:Boolean},namedRanges:{type:String}}}constructor(){super(),overlayStyles.parentElement||document.head.appendChild(overlayStyles)}render(){return x``}connectedCallback(){super.connectedCallback(),spreadsheetResizeObserver.observe(this)}disconnectedCallback(){super.disconnectedCallback(),spreadsheetResizeObserver.unobserve(this)}updated(ue){super.updated(ue);let it=!1;if(!this.api){let Yt=document.getElementById("spreadsheet-overlays");Yt||(Yt=document.createElement("div"),Yt.id="spreadsheet-overlays",document.body.appendChild(Yt)),this.api=new Spreadsheet(this,this.renderRoot),this.api.setHeight("100%"),this.api.setWidth("100%"),this.createCallbacks(),it=!0}let _t=[];ue.forEach((Yt,Me)=>{let ge=this[Me];Me=="dirty"||(Me=="rowBufferSize"?this.api.setRowBufferSize(ge):Me=="columnBufferSize"?this.api.setColumnBufferSize(ge):Me=="rows"?this.api.setRows(ge):Me=="cols"?this.api.setCols(ge):Me=="colGroupingData"?this.api.setColGroupingData(ge):Me=="rowGroupingData"?this.api.setRowGroupingData(ge):Me=="colGroupingMax"?this.api.setColGroupingMax(ge):Me=="rowGroupingMax"?this.api.setRowGroupingMax(ge):Me=="colGroupingInversed"?this.api.setColGroupingInversed(ge):Me=="rowGroupingInversed"?this.api.setRowGroupingInversed(ge):Me=="defRowH"?this.api.setDefRowH(ge):Me=="defColW"?this.api.setDefColW(ge):Me=="rowH"?this.api.setRowH(ge):Me=="colW"?this.api.setColW(ge):Me=="reload"?this.api.setReload(!0):Me=="sheetIndex"?this.api.setSheetIndex(ge):Me=="sheetNames"?this.api.setSheetNames(ge):Me=="cellStyleToCSSStyle"?this.api.setCellStyleToCSSStyle(ge):Me=="rowIndexToStyleIndex"?this.api.setRowIndexToStyleIndex(ge):Me=="columnIndexToStyleIndex"?this.api.setColumnIndexToStyleIndex(ge):Me=="lockedColumnIndexes"?this.api.setLockedColumnIndexes(ge):Me=="lockedRowIndexes"?this.api.setLockedRowIndexes(ge):Me=="shiftedCellBorderStyles"?this.api.setShiftedCellBorderStyles(ge):Me=="conditionalFormattingStyles"?this.api.setConditionalFormattingStyles(ge):Me=="hiddenColumnIndexes"?this.api.setHiddenColumnIndexes(ge):Me=="hiddenRowIndexes"?this.api.setHiddenRowIndexes(ge):Me=="verticalScrollPositions"?this.api.setVerticalScrollPositions(ge):Me=="horizontalScrollPositions"?this.api.setHorizontalScrollPositions(ge):Me=="sheetProtected"?this.api.setSheetProtected(ge):Me=="workbookProtected"?this.api.setWorkbookProtected(ge):Me=="cellKeysToEditorIdMap"?this.api.setCellKeysToEditorIdMap(ge):Me=="componentIDtoCellKeysMap"?this.api.setComponentIDtoCellKeysMap(ge):Me=="hyperlinksTooltips"?this.api.setHyperlinksTooltips(ge):Me=="cellComments"?this.api.setCellComments(ge):Me=="cellCommentAuthors"?this.api.setCellCommentAuthors(ge):Me=="visibleCellComments"?this.api.setVisibleCellComments(ge):Me=="invalidFormulaCells"?this.api.setInvalidFormulaCells(ge):Me=="hasActions"?this.api.setHasActions(ge):Me=="overlays"?this.api.setOverlays(ge):Me=="mergedRegions"?this.api.setMergedRegions(ge):Me=="displayGridlines"?this.api.setDisplayGridlines(ge):Me=="displayRowColHeadings"?this.api.setDisplayRowColHeadings(ge):Me=="verticalSplitPosition"?this.api.setVerticalSplitPosition(ge):Me=="horizontalSplitPosition"?this.api.setHorizontalSplitPosition(ge):Me=="infoLabelValue"?this.api.setInfoLabelValue(ge):Me=="workbookChangeToggle"?this.api.setWorkbookChangeToggle(ge):Me=="invalidFormulaErrorMessage"?this.api.setInvalidFormulaErrorMessage(ge):Me=="lockFormatColumns"?this.api.setLockFormatColumns(ge):Me=="lockFormatRows"?this.api.setLockFormatRows(ge):Me=="namedRanges"?this.api.setNamedRanges(ge):Me=="id"?this.api.setId(ge):Me=="class"?this.api.setClass(ge):Me=="resources"?this.api.setResources(this,ge):Me=="api"||console.error("<vaadin-spreadsheet> unsupported property received from server: property="+Me)),_t.push(Me)}),this.api.notifyStateChanges(_t,it),it&&this.api.relayout()}updateBottomRightCellValues(ue){this.api.updateBottomRightCellValues(ue)}updateTopLeftCellValues(ue){this.api.updateTopLeftCellValues(ue)}updateTopRightCellValues(ue){this.api.updateTopRightCellValues(ue)}updateBottomLeftCellValues(ue){this.api.updateBottomLeftCellValues(ue)}updateFormulaBar(ue,it,_t){this.api.updateFormulaBar(ue,it,_t)}invalidCellAddress(){this.api.invalidCellAddress()}showSelectedCell(ue,it,_t,Yt,Me,ge,Kt){this.api.showSelectedCell(ue,it,_t,Yt,Me,ge,Kt)}showActions(ue){this.api.showActions(ue)}setSelectedCellAndRange(ue,it,_t,Yt,Me,ge,Kt,yi){this.api.setSelectedCellAndRange(ue,it,_t,Yt,Me,ge,Kt,yi)}cellsUpdated(ue){this.api&&this.api.cellsUpdated(ue)}refreshCellStyles(){this.api&&this.api.refreshCellStyles()}editCellComment(ue,it){this.api.editCellComment(ue,it)}onPopupButtonOpen(ue,it,_t,Yt){this.api.onPopupButtonOpened(ue,it,_t,Yt)}closePopup(ue,it){this.api.closePopup(ue,it)}addPopupButton(ue){this.api.addPopupButton(ue)}removePopupButton(ue){this.api.removePopupButton(ue)}createCallbacks(){this.api.setGroupingCollapsedCallback(ue=>{this.dispatchEvent(this.createEvent("groupingCollapsed",ue))}),this.api.setLevelHeaderClickedCallback(ue=>{this.dispatchEvent(this.createEvent("levelHeaderClicked",ue))}),this.api.setOnSheetScrollCallback(ue=>{this.dispatchEvent(this.createEvent("onSheetScroll",ue))}),this.api.setSheetAddressChangedCallback(ue=>{this.dispatchEvent(this.createEvent("sheetAddressChanged",ue))}),this.api.setCellSelectedCallback(ue=>{this.dispatchEvent(this.createEvent("cellSelected",ue))}),this.api.setCellRangeSelectedCallback(ue=>{this.dispatchEvent(this.createEvent("cellRangeSelected",ue))}),this.api.setCellAddedToSelectionAndSelectedCallback(ue=>{this.dispatchEvent(this.createEvent("cellAddedToSelectionAndSelected",ue))}),this.api.setCellsAddedToRangeSelectionCallback(ue=>{this.dispatchEvent(this.createEvent("cellsAddedToRangeSelection",ue))}),this.api.setRowSelectedCallback(ue=>{this.dispatchEvent(this.createEvent("rowSelected",ue))}),this.api.setRowAddedToRangeSelectionCallback(ue=>{this.dispatchEvent(this.createEvent("rowAddedToRangeSelection",ue))}),this.api.setColumnSelectedCallback(ue=>{this.dispatchEvent(this.createEvent("columnSelected",ue))}),this.api.setColumnAddedToSelectionCallback(ue=>{this.dispatchEvent(this.createEvent("columnAddedToSelection",ue))}),this.api.setSelectionIncreasePaintedCallback(ue=>{this.dispatchEvent(this.createEvent("selectionIncreasePainted",ue))}),this.api.setSelectionDecreasePaintedCallback(ue=>{this.dispatchEvent(this.createEvent("selectionDecreasePainted",ue))}),this.api.setCellValueEditedCallback(ue=>{this.dispatchEvent(this.createEvent("cellValueEdited",ue))}),this.api.setSheetSelectedCallback(ue=>{this.dispatchEvent(this.createEvent("sheetSelected",ue))}),this.api.setSheetRenamedCallback(ue=>{this.dispatchEvent(this.createEvent("sheetRenamed",ue))}),this.api.setSheetCreatedCallback(ue=>{this.dispatchEvent(this.createEvent("sheetCreated",ue))}),this.api.setCellRangePaintedCallback(ue=>{this.dispatchEvent(this.createEvent("cellRangePainted",ue))}),this.api.setDeleteSelectedCellsCallback(ue=>{this.dispatchEvent(this.createEvent("deleteSelectedCells",ue))}),this.api.setLinkCellClickedCallback(ue=>{this.dispatchEvent(this.createEvent("linkCellClicked",ue))}),this.api.setRowsResizedCallback(ue=>{this.dispatchEvent(this.createEvent("rowsResized",ue))}),this.api.setColumnResizedCallback(ue=>{this.dispatchEvent(this.createEvent("columnResized",ue))}),this.api.setOnRowAutofitCallback(ue=>{this.dispatchEvent(this.createEvent("onRowAutofit",ue))}),this.api.setOnColumnAutofitCallback(ue=>{this.dispatchEvent(this.createEvent("onColumnAutofit",ue))}),this.api.setOnUndoCallback(ue=>{this.dispatchEvent(this.createEvent("onUndo",ue))}),this.api.setOnRedoCallback(ue=>{this.dispatchEvent(this.createEvent("onRedo",ue))}),this.api.setSetCellStyleWidthRatiosCallback(ue=>{this.dispatchEvent(this.createEvent("setCellStyleWidthRatios",ue))}),this.api.setProtectedCellWriteAttemptedCallback(ue=>{this.dispatchEvent(this.createEvent("protectedCellWriteAttempted",ue))}),this.api.setOnPasteCallback(ue=>{this.dispatchEvent(this.createEvent("onPaste",ue))}),this.api.setClearSelectedCellsOnCutCallback(ue=>{this.dispatchEvent(this.createEvent("clearSelectedCellsOnCut",ue))}),this.api.setUpdateCellCommentCallback(ue=>{this.dispatchEvent(this.createEvent("updateCellComment",ue))}),this.api.setOnConnectorInitCallback(ue=>{this.dispatchEvent(this.createEvent("onConnectorInit",ue))}),this.api.setContextMenuOpenOnSelectionCallback(ue=>{this.dispatchEvent(this.createEvent("contextMenuOpenOnSelection",ue))}),this.api.setActionOnCurrentSelectionCallback(ue=>{this.dispatchEvent(this.createEvent("actionOnCurrentSelection",ue))}),this.api.setRowHeaderContextMenuOpenCallback(ue=>{this.dispatchEvent(this.createEvent("rowHeaderContextMenuOpen",ue))}),this.api.setActionOnRowHeaderCallback(ue=>{this.dispatchEvent(this.createEvent("actionOnRowHeader",ue))}),this.api.setColumnHeaderContextMenuOpenCallback(ue=>{this.dispatchEvent(this.createEvent("columnHeaderContextMenuOpen",ue))}),this.api.setActionOnColumnHeaderCallback(ue=>{this.dispatchEvent(this.createEvent("actionOnColumnHeader",ue))}),this.api.setPopupButtonClickCallback(ue=>{this.dispatchEvent(this.createEvent("popupButtonClick",ue))}),this.api.setPopupCloseCallback(ue=>{this.dispatchEvent(this.createEvent("popupClose",ue))}),this.dispatchEvent(this.createEvent("onConnectorInit"),[])}createEvent(ue,it){return new CustomEvent("spreadsheet-event",{detail:{type:ue,data:it}})}}window.customElements.define("vaadin-spreadsheet",VaadinSpreadsheet);
