var pt=(n,r)=>()=>(r||n((r={exports:{}}).exports,r),r.exports);import{i,r as registerStyles,d as defineCustomElement,T as ThemableMixin}from"./indexhtml-44b7cce8.js";import{P as PolymerElement,R as ResizeMixin,E as ElementMixin,h as html,b as beforeNextRender,F as FlattenedNodesObserver}from"./generated-flow-imports-b0c9750a.js";var ft=pt(exports=>{/**
 * @license
 * Copyright (c) 2000 - 2023 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */const chartBaseTheme=i`
  :host {
    font-family: -apple-system, BlinkMacSystemFont, 'Roboto', 'Segoe UI', Helvetica, Arial, sans-serif,
      'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol';
    font-size: 12px;
    line-height: normal;
  }

  .highcharts-container {
    position: relative;
    overflow: hidden;
    width: 100%;
    height: 100%;
    text-align: left;
    z-index: 0;
    /* #1072 */
    -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
  }

  :where([styled-mode]) .highcharts-root {
    display: block;
  }

  :where([styled-mode]) .highcharts-root text {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-strong {
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-emphasized {
    font-style: italic;
  }

  :where([styled-mode]) .highcharts-anchor {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-background {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-plot-border,
  :where([styled-mode]) .highcharts-plot-background {
    fill: none;
  }

  :where([styled-mode]) .highcharts-label-box {
    fill: none;
  }

  :where([styled-mode]) .highcharts-button-box {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-tracker-line {
    stroke-linejoin: round;
    stroke: rgba(192, 192, 192, 0.0001);
    stroke-width: 22;
    fill: none;
  }

  :where([styled-mode]) .highcharts-tracker-area {
    fill: rgba(192, 192, 192, 0.0001);
    stroke-width: 0;
  }

  /* Titles */
  :where([styled-mode]) .highcharts-title {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
    font-size: 1.5em;
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-subtitle {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  /* Axes */
  :where([styled-mode]) .highcharts-axis-line {
    fill: none;
    stroke: var(--vaadin-charts-axis-line, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-axis-title {
    fill: var(--vaadin-charts-axis-title, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-axis-labels {
    fill: var(--vaadin-charts-axis-label, hsla(214, 42%, 18%, 0.72));
    cursor: default;
    font-size: 0.9em;
  }

  :where([styled-mode]) .highcharts-grid-line {
    fill: none;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-xaxis-grid .highcharts-grid-line {
    stroke-width: var(--vaadin-charts-xaxis-line-width, 0px);
  }

  :where([styled-mode]) .highcharts-tick {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-tick {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-minor-grid-line {
    stroke: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-crosshair-thin {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-crosshair-category {
    stroke: var(--vaadin-charts-color-0, #5ac2f7);
    stroke-opacity: 0.25;
  }

  /* Credits */
  :where([styled-mode]) .highcharts-credits {
    cursor: pointer;
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
    font-size: 0.7em;
    transition: fill 250ms, font-size 250ms;
  }

  :where([styled-mode]) .highcharts-credits:hover {
    fill: black;
    font-size: 1em;
  }

  /* Tooltip */
  :where([styled-mode]) .highcharts-tooltip {
    cursor: default;
    pointer-events: none;
    white-space: nowrap;
    transition: stroke 150ms;
  }

  :where([styled-mode]) .highcharts-tooltip {
    filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.05)) !important;
  }

  :where([styled-mode]) .highcharts-tooltip text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-tooltip .highcharts-header {
    font-size: 0.85em;
    color: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-tooltip-box {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-tooltip-border, inherit);
    fill: var(--vaadin-charts-tooltip-background, #fff);
    fill-opacity: var(--vaadin-charts-tooltip-background-opacity, 1);
  }

  :where([styled-mode]) .highcharts-tooltip-box .highcharts-label-box {
    fill: var(--vaadin-charts-tooltip-background, #fff);
    fill-opacity: var(--vaadin-charts-tooltip-background-opacity, 1);
  }

  :where([styled-mode]) .highcharts-tooltip-header {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) div.highcharts-tooltip {
    filter: none;
  }

  :where([styled-mode]) .highcharts-selection-marker {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    fill-opacity: 0.25;
  }

  :where([styled-mode]) .highcharts-graph {
    fill: none;
    stroke-width: 2px;
    stroke-linecap: round;
    stroke-linejoin: round;
  }

  :where([styled-mode]) .highcharts-state-hover .highcharts-graph {
    stroke-width: 3;
  }

  :where([styled-mode]) .highcharts-point-inactive {
    opacity: 0.2;
    transition: opacity 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-series-inactive {
    opacity: 0.2;
    transition: opacity 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-state-hover path {
    transition: stroke-width 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-state-normal path {
    transition: stroke-width 250ms;
    /* slow out */
  }

  /* Legend hover affects points and series */
  :where([styled-mode]) g.highcharts-series,
  :where([styled-mode]) .highcharts-point,
  :where([styled-mode]) .highcharts-markers,
  :where([styled-mode]) .highcharts-data-labels {
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-legend-series-active g.highcharts-series:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-point-active .highcharts-point:not(.highcharts-point-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-markers:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-data-labels:not(.highcharts-series-hover) {
    opacity: 0.2;
  }

  /* Series options */
  /* Default colors */
  /* vaadin-charts custom properties */
  /* Use of :where() function to avoid setting classes with high specificity */
  :where([styled-mode]) .highcharts-color-0 {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    stroke: var(--vaadin-charts-color-0, #5ac2f7);
  }

  :where([styled-mode]) .highcharts-color-1 {
    fill: var(--vaadin-charts-color-1, #1676f3);
    stroke: var(--vaadin-charts-color-1, #1676f3);
  }

  :where([styled-mode]) .highcharts-color-2 {
    fill: var(--vaadin-charts-color-2, #ff7d94);
    stroke: var(--vaadin-charts-color-2, #ff7d94);
  }

  :where([styled-mode]) .highcharts-color-3 {
    fill: var(--vaadin-charts-color-3, #c5164e);
    stroke: var(--vaadin-charts-color-3, #c5164e);
  }

  :where([styled-mode]) .highcharts-color-4 {
    fill: var(--vaadin-charts-color-4, #15c15d);
    stroke: var(--vaadin-charts-color-4, #15c15d);
  }

  :where([styled-mode]) .highcharts-color-5 {
    fill: var(--vaadin-charts-color-5, #0e8151);
    stroke: var(--vaadin-charts-color-5, #0e8151);
  }

  :where([styled-mode]) .highcharts-color-6 {
    fill: var(--vaadin-charts-color-6, #c18ed2);
    stroke: var(--vaadin-charts-color-6, #c18ed2);
  }

  :where([styled-mode]) .highcharts-color-7 {
    fill: var(--vaadin-charts-color-7, #9233b3);
    stroke: var(--vaadin-charts-color-7, #9233b3);
  }

  :where([styled-mode]) .highcharts-color-8 {
    fill: var(--vaadin-charts-color-8, #fda253);
    stroke: var(--vaadin-charts-color-8, #fda253);
  }

  :where([styled-mode]) .highcharts-color-9 {
    fill: var(--vaadin-charts-color-9, #e24932);
    stroke: var(--vaadin-charts-color-9, #e24932);
  }

  /* end of vaadin-charts custom properties */

  :where([styled-mode]) .highcharts-area {
    fill-opacity: 0.5;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-markers {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode])
    .highcharts-a11y-markers-hidden
    .highcharts-point:not(.highcharts-point-hover):not(.highcharts-a11y-marker-visible),
  :where([styled-mode]) .highcharts-a11y-marker-hidden {
    opacity: 0;
  }

  :where([styled-mode]) .highcharts-point {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-dense-data .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label {
    font-size: 0.9em;
    font-weight: normal;
  }

  :where([styled-mode]) .highcharts-data-label-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label text,
  :where([styled-mode]) text.highcharts-data-label {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-data-label-connector {
    fill: none;
  }

  :where([styled-mode]) .highcharts-data-label-hidden {
    pointer-events: none;
  }

  :where([styled-mode]) .highcharts-halo {
    fill-opacity: 0.25;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-series:not(.highcharts-pie-series) .highcharts-point-select,
  :where([styled-mode]) .highcharts-markers .highcharts-point-select {
    fill: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-column-series rect.highcharts-point {
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point {
    transition: fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-solidgauge-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point {
    stroke-width: 2px;
    stroke: var(--vaadin-charts-background, #fff);
    transition: stroke 250ms, fill 250ms, fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point-hover {
    stroke-width: 0px;
    stroke: var(--vaadin-charts-background, #fff);
    fill-opacity: 0.75;
    transition: stroke 25ms, fill 25ms, fill-opacity 25ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-above-level {
    display: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node {
    fill: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive {
    fill-opacity: 0.15;
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive:hover {
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-vector-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-windbarb-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-lollipop-stem {
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-focus-border {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-legend-item-hidden .highcharts-focus-border {
    fill: none !important;
  }

  /* Legend */
  :where([styled-mode]) .highcharts-legend-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    font-weight: normal;
    font-size: 1em;
    cursor: pointer;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > .highcharts-point {
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-legend-item:hover text {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-legend-item-hidden * {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26)) !important;
    stroke: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26)) !important;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-legend-nav-active {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-legend-nav-inactive {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
  }

  :where([styled-mode]) circle.highcharts-legend-nav-active,
  :where([styled-mode]) circle.highcharts-legend-nav-inactive {
    /* tracker */
    fill: rgba(192, 192, 192, 0.0001);
  }

  :where([styled-mode]) .highcharts-legend-title-box {
    fill: none;
    stroke-width: 0;
  }

  /* Bubble legend */
  :where([styled-mode]) .highcharts-bubble-legend-symbol {
    stroke-width: 2;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-bubble-legend-connectors {
    stroke-width: 1;
  }

  :where([styled-mode]) .highcharts-bubble-legend-labels {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  /* Loading */
  :where([styled-mode]) .highcharts-loading {
    position: absolute;
    background-color: var(--vaadin-charts-background, #fff);
    opacity: 0.5;
    text-align: center;
    z-index: 10;
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-loading-hidden {
    height: 0 !important;
    opacity: 0;
    overflow: hidden;
    transition: opacity 250ms, height 250ms step-end;
  }

  :where([styled-mode]) .highcharts-loading-inner {
    font-weight: normal;
    position: relative;
    top: 45%;
  }

  /* Plot bands and polar pane backgrounds */
  :where([styled-mode]) .highcharts-plot-band,
  :where([styled-mode]) .highcharts-pane {
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-plot-line {
    fill: none;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-plot-line-label {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  /* Highcharts More and modules */
  :where([styled-mode]) .highcharts-boxplot-box {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-boxplot-median {
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-bubble-series .highcharts-point {
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-errorbar-series .highcharts-point {
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-data-label-box {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-dial {
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-polygon-series .highcharts-graph {
    fill: inherit;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-waterfall-series .highcharts-graph {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-dasharray: 1, 3;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-link {
    transition: fill 250ms, fill-opacity 250ms;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point-hover.highcharts-link {
    transition: fill 50ms, fill-opacity 50ms;
    fill-opacity: 1;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point {
    fill-opacity: 0.75;
    stroke: var(--vaadin-charts-background, #fff);
    transition: stroke 250ms, fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point-hover {
    fill-opacity: 1;
    stroke: var(--vaadin-charts-background, #fff);
  }

  /* Highstock */
  :where([styled-mode]) .highcharts-navigator-mask-outside {
    fill-opacity: 0;
  }

  :where([styled-mode]) .highcharts-navigator-mask-inside {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    /* navigator.maskFill option */
    fill-opacity: 0.2;
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-outline {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    fill: none;
  }

  :where([styled-mode]) .highcharts-navigator-handle {
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
    fill: var(--vaadin-charts-background, #fff);
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-series {
    fill: var(--vaadin-charts-color-1, #1676f3);
    stroke: var(--vaadin-charts-color-1, #1676f3);
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-graph {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-area {
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-grid-line {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-navigator-xaxis.highcharts-axis-labels {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-navigator-yaxis .highcharts-grid-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-scrollbar-thumb {
    fill: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-scrollbar-button {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-scrollbar-arrow {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-scrollbar-rifles {
    stroke: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-scrollbar-track {
    fill: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-button {
    fill: var(--vaadin-charts-button-background, hsla(214, 61%, 25%, 0.05));
    cursor: default;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-button text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-button-hover {
    transition: fill 0ms;
    fill: var(--vaadin-charts-button-hover-background, hsla(214, 90%, 52%, 0.1));
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-button-hover text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-button-pressed {
    fill: var(--vaadin-charts-button-active-background, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-button-pressed text {
    fill: var(--vaadin-charts-button-active-label, #fff);
  }

  :where([styled-mode]) .highcharts-button-disabled text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-range-selector-buttons > text {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-range-selector-buttons .highcharts-button {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-range-label rect {
    fill: none;
  }

  :where([styled-mode]) .highcharts-range-label text {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-range-input rect {
    fill: var(--vaadin-charts-contrast-10pct, hsla(214, 57%, 24%, 0.1));
    rx: 2;
    ry: 2;
  }

  :where([styled-mode]) .highcharts-range-input:hover rect {
    fill: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-range-input text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) input.highcharts-range-selector {
    position: absolute;
    border: 0;
    width: 1px;
    /* Chrome needs a pixel to see it */
    height: 1px;
    padding: 0;
    text-align: center;
    left: -9em;
    /* #4798 */
  }

  :where([styled-mode]) .highcharts-crosshair-label text {
    fill: var(--vaadin-charts-background, #fff);
    font-size: 1.1em;
  }

  :where([styled-mode]) .highcharts-crosshair-label .highcharts-label-box {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-up {
    fill: var(--vaadin-charts-color-positive, #15c15d);
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-down {
    fill: var(--vaadin-charts-color-negative, #e24932);
  }

  :where([styled-mode]) .highcharts-ohlc-series .highcharts-point-hover {
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point .highcharts-label-box {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    fill: var(--vaadin-charts-background, #fff);
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover .highcharts-label-box {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    font-size: 0.9em;
    font-weight: normal;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover text {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
  }

  /* Highmaps */
  :where([styled-mode]) .highcharts-map-series .highcharts-point {
    transition: fill 500ms, fill-opacity 500ms, stroke-width 250ms;
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-map-series .highcharts-point-hover {
    transition: fill 0ms, fill-opacity 0ms;
    fill-opacity: 0.5;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-mapline-series .highcharts-point {
    fill: none;
  }

  :where([styled-mode]) .highcharts-heatmap-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-map-navigation {
    font-size: 1.3em;
    font-weight: normal;
    text-align: center;
  }

  :where([styled-mode]) .highcharts-coloraxis {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-coloraxis-grid .highcharts-grid-line {
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-coloraxis-marker {
    fill: var(--vaadin-charts-axis-label, hsla(214, 42%, 18%, 0.72));
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-null-point {
    fill: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  /* 3d charts */
  :where([styled-mode]) .highcharts-3d-frame {
    fill: transparent;
  }

  /* Exporting module */
  :where([styled-mode]) .highcharts-contextbutton {
    fill: #fff;
    /* needed to capture hover */
    stroke: none;
    stroke-linecap: round;
  }

  :where([styled-mode]) .highcharts-contextbutton:hover {
    fill: #e6e6e6;
    stroke: #e6e6e6;
  }

  :where([styled-mode]) .highcharts-button-symbol {
    stroke: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-menu {
    border: 1px solid #999;
    background: #fff;
    padding: 5px 0;
    box-shadow: 3px 3px 10px #888;
  }

  :where([styled-mode]) .highcharts-menu-item {
    padding: 0.5em 1em;
    background: none;
    color: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    cursor: pointer;
    transition: background 250ms, color 250ms;
  }

  :where([styled-mode]) .highcharts-menu-item:hover {
    background: #335cad;
    color: #fff;
  }

  /* Drilldown module */
  :where([styled-mode]) .highcharts-drilldown-point {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-drilldown-data-label text,
  :where([styled-mode]) text.highcharts-drilldown-data-label,
  :where([styled-mode]) .highcharts-drilldown-axis-label {
    cursor: pointer;
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    font-weight: normal;
    text-decoration: underline;
  }

  /* No-data module */
  :where([styled-mode]) .highcharts-no-data text {
    font-weight: normal;
    font-size: 1rem;
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  /* Drag-panes module */
  :where([styled-mode]) .highcharts-axis-resizer {
    cursor: ns-resize;
    stroke: black;
    stroke-width: 2px;
  }

  /* Bullet type series */
  :where([styled-mode]) .highcharts-bullet-target {
    stroke-width: 0;
  }

  /* Lineargauge type series */
  :where([styled-mode]) .highcharts-lineargauge-target {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  :where([styled-mode]) .highcharts-lineargauge-target-line {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  /* Annotations module */
  :where([styled-mode]) .highcharts-annotation-label-box {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-annotation-label text {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
  }

  /* Gantt */
  :where([styled-mode]) .highcharts-treegrid-node-collapsed,
  :where([styled-mode]) .highcharts-treegrid-node-expanded {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-point-connecting-path {
    fill: none;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-tick {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-axis-line {
    stroke-width: 1px;
  }

  /* RTL styles */
  :host([dir='rtl']) :where([styled-mode]) .highcharts-container {
    text-align: right;
  }

  :host([dir='rtl']) :where([styled-mode]) input.highcharts-range-selector {
    left: auto;
    right: -9em;
  }

  :host([dir='rtl']) :where([styled-mode]) .highcharts-menu {
    box-shadow: -3px 3px 10px #888;
  }

  /* https://github.com/highcharts/highcharts/issues/16282 */
  /* without this the resize callback always calls __reflow */
  ul[aria-hidden='false'] {
    margin: 0px;
  }
`;registerStyles("vaadin-chart",chartBaseTheme,{moduleId:"vaadin-chart-base-theme"});const chartColors=i`
  :host {
    --vaadin-charts-color-0: #5ac2f7;
    --vaadin-charts-color-1: #1676f3;
    --vaadin-charts-color-2: #ff7d94;
    --vaadin-charts-color-3: #c5164e;
    --vaadin-charts-color-4: #15c15d;
    --vaadin-charts-color-5: #0e8151;
    --vaadin-charts-color-6: #c18ed2;
    --vaadin-charts-color-7: #9233b3;
    --vaadin-charts-color-8: #fda253;
    --vaadin-charts-color-9: #e24932;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-4, #15c15d);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-9, #e24932);
  }

  :host([theme~='gradient']) {
    --vaadin-charts-color-0: #1676f3;
    --vaadin-charts-color-1: #13bbf0;
    --vaadin-charts-color-2: #1ee;
    --vaadin-charts-color-3: #0cd9bf;
    --vaadin-charts-color-4: #06be81;
    --vaadin-charts-color-5: #00a344;
    --vaadin-charts-color-6: #41c639;
    --vaadin-charts-color-7: #8aed2c;
    --vaadin-charts-color-8: #c0e632;
    --vaadin-charts-color-9: #f6db3a;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-6);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-1);
  }

  :host([theme~='monotone']) {
    --vaadin-charts-color-0: #1676f3;
    --vaadin-charts-color-1: #4795f5;
    --vaadin-charts-color-2: #71b0f7;
    --vaadin-charts-color-3: #a0cef9;
    --vaadin-charts-color-4: #bce0fa;
    --vaadin-charts-color-5: #a8d8ed;
    --vaadin-charts-color-6: #7fc3dd;
    --vaadin-charts-color-7: #54adcc;
    --vaadin-charts-color-8: #2b99bc;
    --vaadin-charts-color-9: #0284ac;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-3);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-9);
  }

  :host([theme~='classic']) {
    --vaadin-charts-color-0: #7cb5ec;
    --vaadin-charts-color-1: #434348;
    --vaadin-charts-color-2: #90ed7d;
    --vaadin-charts-color-3: #f7a35c;
    --vaadin-charts-color-4: #8085e9;
    --vaadin-charts-color-5: #f15c80;
    --vaadin-charts-color-6: #e4d354;
    --vaadin-charts-color-7: #2b908f;
    --vaadin-charts-color-8: #f45b5b;
    --vaadin-charts-color-9: #91e8e1;
  }
`,chartTheme=i`
  :host {
    --vaadin-charts-background: var(--lumo-base-color);
    --vaadin-charts-title-label: var(--lumo-header-text-color);
    --vaadin-charts-axis-title: var(--lumo-secondary-text-color);
    --vaadin-charts-axis-label: var(--lumo-secondary-text-color);
    --vaadin-charts-data-label: var(--lumo-body-text-color);
    --vaadin-charts-secondary-label: var(--lumo-secondary-text-color);
    --vaadin-charts-axis-line: var(--lumo-contrast-5pct);
    --vaadin-charts-grid-line: var(--lumo-contrast-20pct);
    --vaadin-charts-disabled-label: var(--lumo-disabled-text-color);
    --vaadin-charts-contrast: var(--lumo-contrast);
    --vaadin-charts-contrast-5pct: var(--lumo-contrast-5pct);
    --vaadin-charts-contrast-10pct: var(--lumo-contrast-10pct);
    --vaadin-charts-contrast-20pct: var(--lumo-contrast-20pct);
    --vaadin-charts-contrast-60pct: var(--lumo-contrast-60pct);
    --vaadin-charts-tooltip-background: var(--lumo-base-color);
    --vaadin-charts-tooltip-border-color: inherit;
    --vaadin-charts-button-label: var(--lumo-primary-text-color);
    --vaadin-charts-button-background: var(--lumo-contrast-5pct);
    --vaadin-charts-button-hover-background: var(--lumo-primary-color-10pct);
    --vaadin-charts-button-active-label: var(--lumo-primary-contrast-color);
    --vaadin-charts-button-active-background: var(--lumo-primary-color);
    --vaadin-charts-xaxis-line-width: 0;
    --vaadin-charts-tooltip-background-opacity: 1;
    font-family: var(--lumo-font-family);
  }
`;registerStyles("vaadin-chart",[chartColors,chartTheme],{moduleId:"lumo-chart"});var w=typeof win<"u"?win:typeof window<"u"?window:{},Globals;(function(n){n.SVG_NS="http://www.w3.org/2000/svg",n.product="Highcharts",n.version="9.2.2",n.win=w,n.doc=n.win.document,n.svg=n.doc&&n.doc.createElementNS&&!!n.doc.createElementNS(n.SVG_NS,"svg").createSVGRect,n.userAgent=n.win.navigator&&n.win.navigator.userAgent||"",n.isChrome=n.userAgent.indexOf("Chrome")!==-1,n.isFirefox=n.userAgent.indexOf("Firefox")!==-1,n.isMS=/(edge|msie|trident)/i.test(n.userAgent)&&!n.win.opera,n.isSafari=!n.isChrome&&n.userAgent.indexOf("Safari")!==-1,n.isTouchDevice=/(Mobile|Android|Windows Phone)/.test(n.userAgent),n.isWebKit=n.userAgent.indexOf("AppleWebKit")!==-1,n.deg2rad=Math.PI*2/360,n.hasBidiBug=n.isFirefox&&parseInt(n.userAgent.split("Firefox/")[1],10)<4,n.hasTouch=!!n.win.TouchEvent,n.marginNames=["plotTop","marginRight","marginBottom","plotLeft"],n.noop=function(){},n.supportsPassiveEvents=function(){var r=!1;if(!n.isMS){var t=Object.defineProperty({},"passive",{get:function(){r=!0}});n.win.addEventListener&&n.win.removeEventListener&&(n.win.addEventListener("testPassive",n.noop,t),n.win.removeEventListener("testPassive",n.noop,t))}return r}(),n.charts=[],n.dateFormats={},n.seriesTypes={},n.symbolSizes={},n.chartCount=0})(Globals||(Globals={}));const H=Globals;var charts$5=H.charts,doc$m=H.doc,win$g=H.win;function error$a(n,r,t,o){var s=r?"Highcharts error":"Highcharts warning";n===32&&(n=s+": Deprecated member");var a=isNumber$R(n),l=a?s+" #"+n+": www.highcharts.com/errors/"+n+"/":n.toString(),h=function(){if(r)throw new Error(l);win$g.console&&error$a.messages.indexOf(l)===-1&&console.warn(l)};if(typeof o<"u"){var c="";a&&(l+="?"),objectEach$B(o,function(d,p){c+=`
 - `+p+": "+d,a&&(l+=encodeURI(p)+"="+encodeURI(d))}),l+=c}fireEvent$B(H,"displayError",{chart:t,code:n,message:l,params:o},h),error$a.messages.push(l)}(function(n){n.messages=[]})(error$a||(error$a={}));function merge$1p(){var n,r=arguments,t={},o=function(a,l){return typeof a!="object"&&(a={}),objectEach$B(l,function(h,c){c==="__proto__"||c==="constructor"||(isObject$f(h,!0)&&!isClass(h)&&!isDOMElement(h)?a[c]=o(a[c]||{},h):a[c]=l[c])}),a};r[0]===!0&&(t=r[1],r=Array.prototype.slice.call(r,2));var s=r.length;for(n=0;n<s;n++)t=o(t,r[n]);return t}function clamp$j(n,r,t){return n>r?n<t?n:t:r}function cleanRecursively$2(n,r){var t={};return objectEach$B(n,function(o,s){var a;isObject$f(n[s],!0)&&!n.nodeType&&r[s]?(a=cleanRecursively$2(n[s],r[s]),Object.keys(a).length&&(t[s]=a)):(isObject$f(n[s])||n[s]!==r[s])&&(t[s]=n[s])}),t}function pInt$a(n,r){return parseInt(n,r||10)}function isString$c(n){return typeof n=="string"}function isArray$n(n){var r=Object.prototype.toString.call(n);return r==="[object Array]"||r==="[object Array Iterator]"}function isObject$f(n,r){return!!n&&typeof n=="object"&&(!r||!isArray$n(n))}function isDOMElement(n){return isObject$f(n)&&typeof n.nodeType=="number"}function isClass(n){var r=n&&n.constructor;return!!(isObject$f(n,!0)&&!isDOMElement(n)&&r&&r.name&&r.name!=="Object")}function isNumber$R(n){return typeof n=="number"&&!isNaN(n)&&n<1/0&&n>-1/0}function erase$9(n,r){for(var t=n.length;t--;)if(n[t]===r){n.splice(t,1);break}}function defined$W(n){return typeof n<"u"&&n!==null}function attr$8(n,r,t){var o;return isString$c(r)?defined$W(t)?n.setAttribute(r,t):n&&n.getAttribute&&(o=n.getAttribute(r),!o&&r==="class"&&(o=n.getAttribute(r+"Name"))):objectEach$B(r,function(s,a){n.setAttribute(a,s)}),o}function splat$j(n){return isArray$n(n)?n:[n]}function syncTimeout$9(n,r,t){return r>0?setTimeout(n,r,t):(n.call(0,t),-1)}function internalClearTimeout(n){defined$W(n)&&clearTimeout(n)}function extend$1q(n,r){var t;n||(n={});for(t in r)n[t]=r[t];return n}function pick$1B(){for(var n=arguments,r=n.length,t=0;t<r;t++){var o=n[t];if(typeof o<"u"&&o!==null)return o}}function css$d(n,r){H.isMS&&!H.svg&&r&&typeof r.opacity<"u"&&(r.filter="alpha(opacity="+r.opacity*100+")"),extend$1q(n.style,r)}function createElement$b(n,r,t,o,s){var a=doc$m.createElement(n);return r&&extend$1q(a,r),s&&css$d(a,{padding:"0",border:"none",margin:"0"}),t&&css$d(a,t),o&&o.appendChild(a),a}function extendClass$2(n,r){var t=function(){};return t.prototype=new n,extend$1q(t.prototype,r),t}function pad$2(n,r,t){return new Array((r||2)+1-String(n).replace("-","").length).join(t||"0")+n}function relativeLength$a(n,r,t){return/%$/.test(n)?r*parseFloat(n)/100+(t||0):parseFloat(n)}function wrap$d(n,r,t){var o=n[r];n[r]=function(){var s=Array.prototype.slice.call(arguments),a=arguments,l=this;l.proceed=function(){o.apply(l,arguments.length?arguments:a)},s.unshift(o);var h=t.apply(this,s);return l.proceed=null,h}}function getMagnitude$3(n){return Math.pow(10,Math.floor(Math.log(n)/Math.LN10))}function normalizeTickInterval$3(n,r,t,o,s){var a,l=n;t=pick$1B(t,1);var h=n/t;for(r||(r=s?[1,1.2,1.5,2,2.5,3,4,5,6,8,10]:[1,2,2.5,5,10],o===!1&&(t===1?r=r.filter(function(c){return c%1===0}):t<=.1&&(r=[1/t]))),a=0;a<r.length&&(l=r[a],!(s&&l*t>=n||!s&&h<=(r[a]+(r[a+1]||r[a]))/2));a++);return l=correctFloat$d(l*t,-Math.round(Math.log(.001)/Math.LN10)),l}function stableSort$7(n,r){var t=n.length,o,s;for(s=0;s<t;s++)n[s].safeI=s;for(n.sort(function(a,l){return o=r(a,l),o===0?a.safeI-l.safeI:o}),s=0;s<t;s++)delete n[s].safeI}function arrayMin$9(n){for(var r=n.length,t=n[0];r--;)n[r]<t&&(t=n[r]);return t}function arrayMax$a(n){for(var r=n.length,t=n[0];r--;)n[r]>t&&(t=n[r]);return t}function destroyObjectProperties$a(n,r){objectEach$B(n,function(t,o){t&&t!==r&&t.destroy&&t.destroy(),delete n[o]})}function discardElement$7(n){garbageBin||(garbageBin=createElement$b("div")),n&&garbageBin.appendChild(n),garbageBin.innerHTML=""}var garbageBin;function correctFloat$d(n,r){return parseFloat(n.toPrecision(r||14))}var timeUnits$3={millisecond:1,second:1e3,minute:6e4,hour:36e5,day:24*36e5,week:7*24*36e5,month:28*24*36e5,year:364*24*36e5};Math.easeInOutSine=function(n){return-.5*(Math.cos(Math.PI*n)-1)};function getNestedProperty$3(n,r){for(var t=n.split(".");t.length&&defined$W(r);){var o=t.shift();if(typeof o>"u"||o==="__proto__")return;var s=r[o];if(!defined$W(s)||typeof s=="function"||typeof s.nodeType=="number"||s===win$g)return;r=s}return r}function getStyle$2(n,r,t){var o=H.getStyle||getStyle$2,s;if(r==="width"){var a=Math.min(n.offsetWidth,n.scrollWidth),l=n.getBoundingClientRect&&n.getBoundingClientRect().width;return l<a&&l>=a-1&&(a=Math.floor(l)),Math.max(0,a-(o(n,"padding-left",!0)||0)-(o(n,"padding-right",!0)||0))}if(r==="height")return Math.max(0,Math.min(n.offsetHeight,n.scrollHeight)-(o(n,"padding-top",!0)||0)-(o(n,"padding-bottom",!0)||0));win$g.getComputedStyle||error$a(27,!0);var h=win$g.getComputedStyle(n,void 0);return h&&(s=h.getPropertyValue(r),pick$1B(t,r!=="opacity")&&(s=pInt$a(s))),s}function inArray(n,r,t){return error$a(32,!1,void 0,{"Highcharts.inArray":"use Array.indexOf"}),r.indexOf(n,t)}var find$j=Array.prototype.find?function(n,r){return n.find(r)}:function(n,r){var t,o=n.length;for(t=0;t<o;t++)if(r(n[t],t))return n[t]};function keys(n){return error$a(32,!1,void 0,{"Highcharts.keys":"use Object.keys"}),Object.keys(n)}function offset$1(n){var r=doc$m.documentElement,t=n.parentElement||n.parentNode?n.getBoundingClientRect():{top:0,left:0,width:0,height:0};return{top:t.top+(win$g.pageYOffset||r.scrollTop)-(r.clientTop||0),left:t.left+(win$g.pageXOffset||r.scrollLeft)-(r.clientLeft||0),width:t.width,height:t.height}}function objectEach$B(n,r,t){for(var o in n)Object.hasOwnProperty.call(n,o)&&r.call(t||n[o],n[o],o,n)}objectEach$B({map:"map",each:"forEach",grep:"filter",reduce:"reduce",some:"some"},function(n,r){H[r]=function(t){var o;return error$a(32,!1,void 0,(o={},o["Highcharts."+r]="use Array."+n,o)),Array.prototype[n].apply(t,[].slice.call(arguments,1))}});function addEvent$12(n,r,t,o){o===void 0&&(o={});var s=typeof n=="function"&&n.prototype||n;Object.hasOwnProperty.call(s,"hcEvents")||(s.hcEvents={});var a=s.hcEvents;H.Point&&n instanceof H.Point&&n.series&&n.series.chart&&(n.series.chart.runTrackerClick=!0);var l=n.addEventListener||H.addEventListenerPolyfill;l&&l.call(n,r,t,H.supportsPassiveEvents?{passive:o.passive===void 0?r.indexOf("touch")!==-1:o.passive,capture:!1}:!1),a[r]||(a[r]=[]);var h={fn:t,order:typeof o.order=="number"?o.order:1/0};return a[r].push(h),a[r].sort(function(c,d){return c.order-d.order}),function(){removeEvent$c(n,r,t)}}function removeEvent$c(n,r,t){function o(c,d){var p=n.removeEventListener||H.removeEventListenerPolyfill;p&&p.call(n,c,d,!1)}function s(c){var d,p;n.nodeName&&(r?(d={},d[r]=!0):d=c,objectEach$B(d,function(u,f){if(c[f])for(p=c[f].length;p--;)o(f,c[f][p].fn)}))}var a=typeof n=="function"&&n.prototype||n;if(Object.hasOwnProperty.call(a,"hcEvents")){var l=a.hcEvents;if(r){var h=l[r]||[];t?(l[r]=h.filter(function(c){return t!==c.fn}),o(r,t)):(s(l),l[r]=[])}else s(l),delete a.hcEvents}}function fireEvent$B(n,r,t,o){var s;if(t=t||{},doc$m.createEvent&&(n.dispatchEvent||n.fireEvent&&n!==H))s=doc$m.createEvent("Events"),s.initEvent(r,!0,!0),t=extend$1q(s,t),n.dispatchEvent?n.dispatchEvent(t):n.fireEvent(r,t);else if(n.hcEvents){t.target||extend$1q(t,{preventDefault:function(){t.defaultPrevented=!0},target:n,type:r});for(var a=[],l=n,h=!1;l.hcEvents;)Object.hasOwnProperty.call(l,"hcEvents")&&l.hcEvents[r]&&(a.length&&(h=!0),a.unshift.apply(a,l.hcEvents[r])),l=Object.getPrototypeOf(l);h&&a.sort(function(c,d){return c.order-d.order}),a.forEach(function(c){c.fn.call(n,t)===!1&&t.preventDefault()})}o&&!t.defaultPrevented&&o.call(n,t)}var serialMode,uniqueKey$8=function(){var n=Math.random().toString(36).substring(2,9)+"-",r=0;return function(){return"highcharts-"+(serialMode?"":n)+r++}}();function useSerialIds(n){return serialMode=pick$1B(n,serialMode)}function isFunction$5(n){return typeof n=="function"}win$g.jQuery&&(win$g.jQuery.fn.highcharts=function(){var n=[].slice.call(arguments);if(this[0])return n[0]?(new H[isString$c(n[0])?n.shift():"Chart"](this[0],n[0],n[1]),this):charts$5[attr$8(this[0],"data-highcharts-chart")]});var Utilities={addEvent:addEvent$12,arrayMax:arrayMax$a,arrayMin:arrayMin$9,attr:attr$8,clamp:clamp$j,cleanRecursively:cleanRecursively$2,clearTimeout:internalClearTimeout,correctFloat:correctFloat$d,createElement:createElement$b,css:css$d,defined:defined$W,destroyObjectProperties:destroyObjectProperties$a,discardElement:discardElement$7,erase:erase$9,error:error$a,extend:extend$1q,extendClass:extendClass$2,find:find$j,fireEvent:fireEvent$B,getMagnitude:getMagnitude$3,getNestedProperty:getNestedProperty$3,getStyle:getStyle$2,inArray,isArray:isArray$n,isClass,isDOMElement,isFunction:isFunction$5,isNumber:isNumber$R,isObject:isObject$f,isString:isString$c,keys,merge:merge$1p,normalizeTickInterval:normalizeTickInterval$3,objectEach:objectEach$B,offset:offset$1,pad:pad$2,pick:pick$1B,pInt:pInt$a,relativeLength:relativeLength$a,removeEvent:removeEvent$c,splat:splat$j,stableSort:stableSort$7,syncTimeout:syncTimeout$9,timeUnits:timeUnits$3,uniqueKey:uniqueKey$8,useSerialIds,wrap:wrap$d},palette={colors:["#7cb5ec","#434348","#90ed7d","#f7a35c","#8085e9","#f15c80","#e4d354","#2b908f","#f45b5b","#91e8e1"],backgroundColor:"#ffffff",neutralColor100:"#000000",neutralColor80:"#333333",neutralColor60:"#666666",neutralColor40:"#999999",neutralColor20:"#cccccc",neutralColor10:"#e6e6e6",neutralColor5:"#f2f2f2",neutralColor3:"#f7f7f7",highlightColor100:"#003399",highlightColor80:"#335cad",highlightColor60:"#6685c2",highlightColor20:"#ccd6eb",highlightColor10:"#e6ebf5",positiveColor:"#06b535",negativeColor:"#f21313"},ChartDefaults={panning:{enabled:!1,type:"x"},styledMode:!1,borderRadius:0,colorCount:10,defaultSeriesType:"line",ignoreHiddenSeries:!0,spacing:[10,10,15,10],resetZoomButton:{theme:{zIndex:6},position:{align:"right",x:-10,y:10}},zoomBySingleTouch:!1,width:null,height:null,borderColor:palette.highlightColor80,backgroundColor:palette.backgroundColor,plotBorderColor:palette.neutralColor20},isNumber$Q=Utilities.isNumber,merge$1o=Utilities.merge,pInt$9=Utilities.pInt,Color=function(){function n(r){this.rgba=[NaN,NaN,NaN,NaN],this.input=r;var t=H.Color;if(t&&t!==n)return new t(r);if(!(this instanceof n))return new n(r);this.init(r)}return n.parse=function(r){return r?new n(r):n.None},n.prototype.init=function(r){var t,o,s,a;if(typeof r=="object"&&typeof r.stops<"u")this.stops=r.stops.map(function(c){return new n(c[1])});else if(typeof r=="string"){if(this.input=r=n.names[r.toLowerCase()]||r,r.charAt(0)==="#"){var l=r.length,h=parseInt(r.substr(1),16);l===7?o=[(h&16711680)>>16,(h&65280)>>8,h&255,1]:l===4&&(o=[(h&3840)>>4|(h&3840)>>8,(h&240)>>4|h&240,(h&15)<<4|h&15,1])}if(!o)for(s=n.parsers.length;s--&&!o;)a=n.parsers[s],t=a.regex.exec(r),t&&(o=a.parse(t))}o&&(this.rgba=o)},n.prototype.get=function(r){var t=this.input,o=this.rgba;if(typeof t=="object"&&typeof this.stops<"u"){var s=merge$1o(t);return s.stops=[].slice.call(s.stops),this.stops.forEach(function(a,l){s.stops[l]=[s.stops[l][0],a.get(r)]}),s}return o&&isNumber$Q(o[0])?r==="rgb"||!r&&o[3]===1?"rgb("+o[0]+","+o[1]+","+o[2]+")":r==="a"?""+o[3]:"rgba("+o.join(",")+")":t},n.prototype.brighten=function(r){var t=this.rgba;if(this.stops)this.stops.forEach(function(s){s.brighten(r)});else if(isNumber$Q(r)&&r!==0)for(var o=0;o<3;o++)t[o]+=pInt$9(r*255),t[o]<0&&(t[o]=0),t[o]>255&&(t[o]=255);return this},n.prototype.setOpacity=function(r){return this.rgba[3]=r,this},n.prototype.tweenTo=function(r,t){var o=this.rgba,s=r.rgba;if(!isNumber$Q(o[0])||!isNumber$Q(s[0]))return r.input||"none";var a=s[3]!==1||o[3]!==1;return(a?"rgba(":"rgb(")+Math.round(s[0]+(o[0]-s[0])*(1-t))+","+Math.round(s[1]+(o[1]-s[1])*(1-t))+","+Math.round(s[2]+(o[2]-s[2])*(1-t))+(a?","+(s[3]+(o[3]-s[3])*(1-t)):"")+")"},n.names={white:"#ffffff",black:"#000000"},n.parsers=[{regex:/rgba\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]?(?:\.[0-9]+)?)\s*\)/,parse:function(r){return[pInt$9(r[1]),pInt$9(r[2]),pInt$9(r[3]),parseFloat(r[4],10)]}},{regex:/rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/,parse:function(r){return[pInt$9(r[1]),pInt$9(r[2]),pInt$9(r[3]),1]}}],n.None=new n(""),n}(),win$f=H.win,defined$V=Utilities.defined,error$9=Utilities.error,extend$1p=Utilities.extend,isObject$e=Utilities.isObject,merge$1n=Utilities.merge,objectEach$A=Utilities.objectEach,pad$1=Utilities.pad,pick$1A=Utilities.pick,splat$i=Utilities.splat,timeUnits$2=Utilities.timeUnits,hasNewSafariBug=H.isSafari&&win$f.Intl&&win$f.Intl.DateTimeFormat.prototype.formatRange,hasOldSafariBug=H.isSafari&&win$f.Intl&&!win$f.Intl.DateTimeFormat.prototype.formatRange,Time=function(){function n(r){this.options={},this.useUTC=!1,this.variableTimezone=!1,this.Date=win$f.Date,this.getTimezoneOffset=this.timezoneOffsetFunction(),this.update(r)}return n.prototype.get=function(r,t){if(this.variableTimezone||this.timezoneOffset){var o=t.getTime(),s=o-this.getTimezoneOffset(t);t.setTime(s);var a=t["getUTC"+r]();return t.setTime(o),a}return this.useUTC?t["getUTC"+r]():t["get"+r]()},n.prototype.set=function(r,t,o){if(this.variableTimezone||this.timezoneOffset){if(r==="Milliseconds"||r==="Seconds"||r==="Minutes"&&this.getTimezoneOffset(t)%36e5===0)return t["setUTC"+r](o);var s=this.getTimezoneOffset(t),a=t.getTime()-s;t.setTime(a),t["setUTC"+r](o);var l=this.getTimezoneOffset(t);return a=t.getTime()+l,t.setTime(a)}return this.useUTC||hasNewSafariBug&&r==="FullYear"?t["setUTC"+r](o):t["set"+r](o)},n.prototype.update=function(r){var t=pick$1A(r&&r.useUTC,!0);this.options=r=merge$1n(!0,this.options||{},r),this.Date=r.Date||win$f.Date||Date,this.useUTC=t,this.timezoneOffset=t&&r.timezoneOffset,this.getTimezoneOffset=this.timezoneOffsetFunction(),this.variableTimezone=t&&!!(r.getTimezoneOffset||r.timezone)},n.prototype.makeTime=function(r,t,o,s,a,l){var h,c,d;return this.useUTC?(h=this.Date.UTC.apply(0,arguments),c=this.getTimezoneOffset(h),h+=c,d=this.getTimezoneOffset(h),c!==d?h+=d-c:c-36e5===this.getTimezoneOffset(h-36e5)&&!hasOldSafariBug&&(h-=36e5)):h=new this.Date(r,t,pick$1A(o,1),pick$1A(s,0),pick$1A(a,0),pick$1A(l,0)).getTime(),h},n.prototype.timezoneOffsetFunction=function(){var r=this,t=this.options,o=t.moment||win$f.moment;if(!this.useUTC)return function(s){return new Date(s.toString()).getTimezoneOffset()*6e4};if(t.timezone)if(!o)error$9(25);else return function(s){return-o.tz(s,t.timezone).utcOffset()*6e4};return this.useUTC&&t.getTimezoneOffset?function(s){return t.getTimezoneOffset(s.valueOf())*6e4}:function(){return(r.timezoneOffset||0)*6e4}},n.prototype.dateFormat=function(r,t,o){if(!defined$V(t)||isNaN(t))return H.defaultOptions.lang&&H.defaultOptions.lang.invalidDate||"";r=pick$1A(r,"%Y-%m-%d %H:%M:%S");var s=this,a=new this.Date(t),l=this.get("Hours",a),h=this.get("Day",a),c=this.get("Date",a),d=this.get("Month",a),p=this.get("FullYear",a),u=H.defaultOptions.lang,f=u&&u.weekdays,g=u&&u.shortWeekdays,v=extend$1p({a:g?g[h]:f[h].substr(0,3),A:f[h],d:pad$1(c),e:pad$1(c,2," "),w:h,b:u.shortMonths[d],B:u.months[d],m:pad$1(d+1),o:d+1,y:p.toString().substr(2,2),Y:p,H:pad$1(l),k:l,I:pad$1(l%12||12),l:l%12||12,M:pad$1(this.get("Minutes",a)),p:l<12?"AM":"PM",P:l<12?"am":"pm",S:pad$1(a.getSeconds()),L:pad$1(Math.floor(t%1e3),3)},H.dateFormats);return objectEach$A(v,function(m,x){for(;r.indexOf("%"+x)!==-1;)r=r.replace("%"+x,typeof m=="function"?m.call(s,t):m)}),o?r.substr(0,1).toUpperCase()+r.substr(1):r},n.prototype.resolveDTLFormat=function(r){return isObject$e(r,!0)?r:(r=splat$i(r),{main:r[0],from:r[1],to:r[2]})},n.prototype.getTimeTicks=function(r,t,o,s){var a=this,l=a.Date,h=[],c={},d=new l(t),p=r.unitRange,u=r.count||1,f,g,v,m;if(s=pick$1A(s,1),defined$V(t)){a.set("Milliseconds",d,p>=timeUnits$2.second?0:u*Math.floor(a.get("Milliseconds",d)/u)),p>=timeUnits$2.second&&a.set("Seconds",d,p>=timeUnits$2.minute?0:u*Math.floor(a.get("Seconds",d)/u)),p>=timeUnits$2.minute&&a.set("Minutes",d,p>=timeUnits$2.hour?0:u*Math.floor(a.get("Minutes",d)/u)),p>=timeUnits$2.hour&&a.set("Hours",d,p>=timeUnits$2.day?0:u*Math.floor(a.get("Hours",d)/u)),p>=timeUnits$2.day&&a.set("Date",d,p>=timeUnits$2.month?1:Math.max(1,u*Math.floor(a.get("Date",d)/u))),p>=timeUnits$2.month&&(a.set("Month",d,p>=timeUnits$2.year?0:u*Math.floor(a.get("Month",d)/u)),g=a.get("FullYear",d)),p>=timeUnits$2.year&&(g-=g%u,a.set("FullYear",d,g)),p===timeUnits$2.week&&(m=a.get("Day",d),a.set("Date",d,a.get("Date",d)-m+s+(m<s?-7:0))),g=a.get("FullYear",d);var x=a.get("Month",d),y=a.get("Date",d),b=a.get("Hours",d);t=d.getTime(),(a.variableTimezone||!a.useUTC)&&defined$V(o)&&(v=o-t>4*timeUnits$2.month||a.getTimezoneOffset(t)!==a.getTimezoneOffset(o));var $=d.getTime();for(f=1;$<o;)h.push($),p===timeUnits$2.year?$=a.makeTime(g+f*u,0):p===timeUnits$2.month?$=a.makeTime(g,x+f*u):v&&(p===timeUnits$2.day||p===timeUnits$2.week)?$=a.makeTime(g,x,y+f*u*(p===timeUnits$2.day?1:7)):v&&p===timeUnits$2.hour&&u>1?$=a.makeTime(g,x,y,b+f*u):$+=p*u,f++;h.push($),p<=timeUnits$2.hour&&h.length<1e4&&h.forEach(function(S){S%18e5===0&&a.dateFormat("%H%M%S%L",S)==="000000000"&&(c[S]="day")})}return h.info=extend$1p(r,{higherRanks:c,totalRange:p*u}),h},n.prototype.getDateFormat=function(r,t,o,s){var a=this.dateFormat("%m-%d %H:%M:%S.%L",t),l="01-01 00:00:00.000",h={millisecond:15,second:12,minute:9,hour:6,day:3},c,d,p="millisecond";for(d in timeUnits$2){if(r===timeUnits$2.week&&+this.dateFormat("%w",t)===o&&a.substr(6)===l.substr(6)){d="week";break}if(timeUnits$2[d]>r){d=p;break}if(h[d]&&a.substr(h[d])!==l.substr(h[d]))break;d!=="week"&&(p=d)}return d&&(c=this.resolveDTLFormat(s[d]).main),c},n}(),color$g=Color.parse,isTouchDevice$4=H.isTouchDevice,svg$5=H.svg,merge$1m=Utilities.merge,defaultOptions$f={colors:palette.colors,symbols:["circle","diamond","square","triangle","triangle-down"],lang:{loading:"Loading...",months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],weekdays:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],decimalPoint:".",numericSymbols:["k","M","G","T","P","E"],resetZoom:"Reset zoom",resetZoomTitle:"Reset zoom level 1:1",thousandsSep:" "},global:{},time:{Date:void 0,getTimezoneOffset:void 0,timezone:void 0,timezoneOffset:0,useUTC:!0},chart:ChartDefaults,title:{text:"Chart title",align:"center",margin:15,widthAdjust:-44},subtitle:{text:"",align:"center",widthAdjust:-44},caption:{margin:15,text:"",align:"left",verticalAlign:"bottom"},plotOptions:{},labels:{style:{position:"absolute",color:palette.neutralColor80}},legend:{enabled:!0,align:"center",alignColumns:!0,className:"highcharts-no-tooltip",layout:"horizontal",labelFormatter:function(){return this.name},borderColor:palette.neutralColor40,borderRadius:0,navigation:{activeColor:palette.highlightColor100,inactiveColor:palette.neutralColor20},itemStyle:{color:palette.neutralColor80,cursor:"pointer",fontSize:"12px",fontWeight:"bold",textOverflow:"ellipsis"},itemHoverStyle:{color:palette.neutralColor100},itemHiddenStyle:{color:palette.neutralColor20},shadow:!1,itemCheckboxStyle:{position:"absolute",width:"13px",height:"13px"},squareSymbol:!0,symbolPadding:5,verticalAlign:"bottom",x:0,y:0,title:{style:{fontWeight:"bold"}}},loading:{labelStyle:{fontWeight:"bold",position:"relative",top:"45%"},style:{position:"absolute",backgroundColor:palette.backgroundColor,opacity:.5,textAlign:"center"}},tooltip:{enabled:!0,animation:svg$5,borderRadius:3,dateTimeLabelFormats:{millisecond:"%A, %b %e, %H:%M:%S.%L",second:"%A, %b %e, %H:%M:%S",minute:"%A, %b %e, %H:%M",hour:"%A, %b %e, %H:%M",day:"%A, %b %e, %Y",week:"Week from %A, %b %e, %Y",month:"%B %Y",year:"%Y"},footerFormat:"",headerShape:"callout",hideDelay:500,padding:8,shape:"callout",shared:!1,snap:isTouchDevice$4?25:10,headerFormat:'<span style="font-size: 10px">{point.key}</span><br/>',pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.y}</b><br/>',backgroundColor:color$g(palette.neutralColor3).setOpacity(.85).get(),borderWidth:1,shadow:!0,stickOnContact:!1,style:{color:palette.neutralColor80,cursor:"default",fontSize:"12px",whiteSpace:"nowrap"},useHTML:!1},credits:{enabled:!0,href:"https://www.highcharts.com?credits",position:{align:"right",x:-10,verticalAlign:"bottom",y:-5},style:{cursor:"pointer",color:palette.neutralColor40,fontSize:"9px"},text:"Highcharts.com"}};defaultOptions$f.chart.styledMode=!1;var defaultTime$2=new Time(merge$1m(defaultOptions$f.global,defaultOptions$f.time));function getOptions$3(){return defaultOptions$f}function setOptions$2(n){return merge$1m(!0,defaultOptions$f,n),(n.time||n.global)&&(H.time?H.time.update(merge$1m(defaultOptions$f.global,defaultOptions$f.time,n.global,n.time)):H.time=defaultTime$2),defaultOptions$f}var DefaultOptions={defaultOptions:defaultOptions$f,defaultTime:defaultTime$2,getOptions:getOptions$3,setOptions:setOptions$2},color$f=Color.parse,win$e=H.win,isNumber$P=Utilities.isNumber,objectEach$z=Utilities.objectEach,Fx=function(){function n(r,t,o){this.pos=NaN,this.options=t,this.elem=r,this.prop=o}return n.prototype.dSetter=function(){var r=this.paths,t=r&&r[0],o=r&&r[1],s=this.now||0,a=[];if(s===1||!t||!o)a=this.toD||[];else if(t.length===o.length&&s<1)for(var l=0;l<o.length;l++){for(var h=t[l],c=o[l],d=[],p=0;p<c.length;p++){var u=h[p],f=c[p];isNumber$P(u)&&isNumber$P(f)&&!(c[0]==="A"&&(p===4||p===5))?d[p]=u+s*(f-u):d[p]=f}a.push(d)}else a=o;this.elem.attr("d",a,void 0,!0)},n.prototype.update=function(){var r=this.elem,t=this.prop,o=this.now,s=this.options.step;this[t+"Setter"]?this[t+"Setter"]():r.attr?r.element&&r.attr(t,o,null,!0):r.style[t]=o+this.unit,s&&s.call(r,o,this)},n.prototype.run=function(r,t,o){var s=this,a=s.options,l=function(d){return l.stopped?!1:s.step(d)},h=win$e.requestAnimationFrame||function(d){setTimeout(d,13)},c=function(){for(var d=0;d<n.timers.length;d++)n.timers[d]()||n.timers.splice(d--,1);n.timers.length&&h(c)};r===t&&!this.elem["forceAnimate:"+this.prop]?(delete a.curAnim[this.prop],a.complete&&Object.keys(a.curAnim).length===0&&a.complete.call(this.elem)):(this.startTime=+new Date,this.start=r,this.end=t,this.unit=o,this.now=this.start,this.pos=0,l.elem=this.elem,l.prop=this.prop,l()&&n.timers.push(l)===1&&h(c))},n.prototype.step=function(r){var t=+new Date,o=this.options,s=this.elem,a=o.complete,l=o.duration,h=o.curAnim,c,d;return s.attr&&!s.element?c=!1:r||t>=l+this.startTime?(this.now=this.end,this.pos=1,this.update(),h[this.prop]=!0,d=!0,objectEach$z(h,function(p){p!==!0&&(d=!1)}),d&&a&&a.call(s),c=!1):(this.pos=o.easing((t-this.startTime)/l),this.now=this.start+(this.end-this.start)*this.pos,this.update(),c=!0),c},n.prototype.initPath=function(r,t,o){var s=r.startX,a=r.endX,l=o.slice(),h=r.isArea,c=h?2:1,d,p,u,f,g=t&&t.slice();if(!g)return[l,l];function v(x,y){for(;x.length<p;){var b=x[0],$=y[p-x.length];if($&&b[0]==="M"&&($[0]==="C"?x[0]=["C",b[1],b[2],b[1],b[2],b[1],b[2]]:x[0]=["L",b[1],b[2]]),x.unshift(b),h){var S=x.pop();x.push(x[x.length-1],S)}}}function m(x,y){for(;x.length<p;){var b=x[Math.floor(x.length/c)-1].slice();if(b[0]==="C"&&(b[1]=b[5],b[2]=b[6]),!h)x.push(b);else{var $=x[Math.floor(x.length/c)].slice();x.splice(x.length/2,0,b,$)}}}if(s&&a&&a.length){for(u=0;u<s.length;u++)if(s[u]===a[0]){d=u;break}else if(s[0]===a[a.length-s.length+u]){d=u,f=!0;break}else if(s[s.length-1]===a[a.length-s.length+u]){d=s.length-u;break}typeof d>"u"&&(g=[])}return g.length&&isNumber$P(d)&&(p=l.length+d*c,f?(v(g,l),m(l)):(v(l,g),m(g))),[g,l]},n.prototype.fillSetter=function(){n.prototype.strokeSetter.apply(this,arguments)},n.prototype.strokeSetter=function(){this.elem.attr(this.prop,color$f(this.start).tweenTo(color$f(this.end),this.pos),null,!0)},n.timers=[],n}(),defined$U=Utilities.defined,getStyle$1=Utilities.getStyle,isArray$m=Utilities.isArray,isNumber$O=Utilities.isNumber,isObject$d=Utilities.isObject,merge$1l=Utilities.merge,objectEach$y=Utilities.objectEach,pick$1z=Utilities.pick;function setAnimation$5(n,r){r.renderer.globalAnimation=pick$1z(n,r.options.chart.animation,!0)}function animObject$c(n){return isObject$d(n)?merge$1l({duration:500,defer:0},n):{duration:n?500:0,defer:0}}function getDeferredAnimation$3(n,r,t){var o=animObject$c(r),s=t?[t]:n.series,a=0,l=0;s.forEach(function(c){var d=animObject$c(c.options.animation);a=r&&defined$U(r.defer)?o.defer:Math.max(a,d.duration+d.defer),l=Math.min(o.duration,d.duration)}),n.renderer.forExport&&(a=0);var h={defer:Math.max(0,a-l),duration:Math.min(a,l)};return h}function animate$2(n,r,t){var o,s="",a,l,h;isObject$d(t)||(h=arguments,t={duration:h[2],easing:h[3],complete:h[4]}),isNumber$O(t.duration)||(t.duration=400),t.easing=typeof t.easing=="function"?t.easing:Math[t.easing]||Math.easeInOutSine,t.curAnim=merge$1l(r),objectEach$y(r,function(c,d){stop$2(n,d),l=new Fx(n,t,d),a=void 0,d==="d"&&isArray$m(r.d)?(l.paths=l.initPath(n,n.pathArray,r.d),l.toD=r.d,o=0,a=1):n.attr?o=n.attr(d):(o=parseFloat(getStyle$1(n,d))||0,d!=="opacity"&&(s="px")),a||(a=c),typeof a=="string"&&a.match("px")&&(a=a.replace(/px/g,"")),l.run(o,a,s)})}function stop$2(n,r){for(var t=Fx.timers.length;t--;)Fx.timers[t].elem===n&&(!r||r===Fx.timers[t].prop)&&(Fx.timers[t].stopped=!0)}var animationExports={animate:animate$2,animObject:animObject$c,getDeferredAnimation:getDeferredAnimation$3,setAnimation:setAnimation$5,stop:stop$2},SVG_NS$3=H.SVG_NS,attr$7=Utilities.attr,createElement$a=Utilities.createElement,discardElement$6=Utilities.discardElement,error$8=Utilities.error,isString$b=Utilities.isString,objectEach$x=Utilities.objectEach,splat$h=Utilities.splat,hasValidDOMParser=function(){try{return!!new DOMParser().parseFromString("","text/html")}catch{return!1}}(),AST=function(){function n(r){this.nodes=typeof r=="string"?this.parseMarkup(r):r}return n.filterUserAttributes=function(r){return objectEach$x(r,function(t,o){var s=!0;n.allowedAttributes.indexOf(o)===-1&&(s=!1),["background","dynsrc","href","lowsrc","src"].indexOf(o)!==-1&&(s=isString$b(t)&&n.allowedReferences.some(function(a){return t.indexOf(a)===0})),s||(error$8("Highcharts warning: Invalid attribute '"+o+"' in config"),delete r[o])}),r},n.setElementHTML=function(r,t){if(r.innerHTML="",t){var o=new n(t);o.addToDOM(r)}},n.prototype.addToDOM=function(r){function t(o,s){var a;return splat$h(o).forEach(function(l){var h=l.tagName,c=l.textContent?H.doc.createTextNode(l.textContent):void 0,d;if(h)if(h==="#text")d=c;else if(n.allowedTags.indexOf(h)!==-1){var p=h==="svg"?SVG_NS$3:s.namespaceURI||SVG_NS$3,u=H.doc.createElementNS(p,h),f=l.attributes||{};objectEach$x(l,function(g,v){v!=="tagName"&&v!=="attributes"&&v!=="children"&&v!=="textContent"&&(f[v]=g)}),attr$7(u,n.filterUserAttributes(f)),c&&u.appendChild(c),t(l.children||[],u),d=u}else error$8("Highcharts warning: Invalid tagName '"+h+"' in config");d&&s.appendChild(d),a=d}),a}return t(this.nodes,r)},n.prototype.parseMarkup=function(r){var t=[];r=r.trim();var o,s;hasValidDOMParser?o=new DOMParser().parseFromString(r,"text/html"):(s=createElement$a("div"),s.innerHTML=r,o={body:s});var a=function(l,h){var c=l.nodeName.toLowerCase(),d={tagName:c};c==="#text"&&(d.textContent=l.textContent||"");var p=l.attributes;if(p){var u={};[].forEach.call(p,function(g){u[g.name]=g.value}),d.attributes=u}if(l.childNodes.length){var f=[];[].forEach.call(l.childNodes,function(g){a(g,f)}),f.length&&(d.children=f)}h.push(d)};return[].forEach.call(o.body.childNodes,function(l){return a(l,t)}),s&&discardElement$6(s),t},n.allowedAttributes=["aria-controls","aria-describedby","aria-expanded","aria-haspopup","aria-hidden","aria-label","aria-labelledby","aria-live","aria-pressed","aria-readonly","aria-roledescription","aria-selected","class","clip-path","color","colspan","cx","cy","d","dx","dy","disabled","fill","height","href","id","in","markerHeight","markerWidth","offset","opacity","orient","padding","paddingLeft","paddingRight","patternUnits","r","refX","refY","role","scope","slope","src","startOffset","stdDeviation","stroke","stroke-linecap","stroke-width","style","tableValues","result","rowspan","summary","target","tabindex","text-align","textAnchor","textLength","type","valign","width","x","x1","x2","y","y1","y2","zIndex"],n.allowedReferences=["https://","http://","mailto:","/","../","./","#"],n.allowedTags=["a","b","br","button","caption","circle","clipPath","code","dd","defs","div","dl","dt","em","feComponentTransfer","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feOffset","feMerge","feMergeNode","filter","h1","h2","h3","h4","h5","h6","hr","i","img","li","linearGradient","marker","ol","p","path","pattern","pre","rect","small","span","stop","strong","style","sub","sup","svg","table","text","thead","tbody","tspan","td","th","tr","u","ul","#text"],n}(),defaultOptions$e=DefaultOptions.defaultOptions,defaultTime$1=DefaultOptions.defaultTime,getNestedProperty$2=Utilities.getNestedProperty,isNumber$N=Utilities.isNumber,pick$1y=Utilities.pick,pInt$8=Utilities.pInt;function dateFormat(n,r,t){return defaultTime$1.dateFormat(n,r,t)}function format$d(n,r,t){for(var o="{",s=!1,a,l,h,c,d=/f$/,p=/\.([0-9])/,u=defaultOptions$e.lang,f=t&&t.time||defaultTime$1,g=t&&t.numberFormatter||numberFormat$2,v=[];n&&(c=n.indexOf(o),c!==-1);){if(a=n.slice(0,c),s){if(l=a.split(":"),h=getNestedProperty$2(l.shift()||"",r),l.length&&typeof h=="number")if(a=l.join(":"),d.test(a)){var m=parseInt((a.match(p)||["","-1"])[1],10);h!==null&&(h=g(h,m,u.decimalPoint,a.indexOf(",")>-1?u.thousandsSep:""))}else h=f.dateFormat(a,h);v.push(h)}else v.push(a);n=n.slice(c+1),s=!s,o=s?"}":"{"}return v.push(n),v.join("")}function numberFormat$2(n,r,t,o){n=+n||0,r=+r;var s,a,l=defaultOptions$e.lang,h=(n.toString().split(".")[1]||"").split("e")[0].length,c=n.toString().split("e"),d=r;r===-1?r=Math.min(h,20):isNumber$N(r)?r&&c[1]&&c[1]<0&&(a=r+ +c[1],a>=0?(c[0]=(+c[0]).toExponential(a).split("e")[0],r=a):(c[0]=c[0].split(".")[0]||0,r<20?n=(c[0]*Math.pow(10,c[1])).toFixed(r):n=0,c[1]=0)):r=2;var p=(Math.abs(c[1]?c[0]:n)+Math.pow(10,-Math.max(r,h)-1)).toFixed(r),u=String(pInt$8(p)),f=u.length>3?u.length%3:0;return t=pick$1y(t,l.decimalPoint),o=pick$1y(o,l.thousandsSep),s=n<0?"-":"",s+=f?u.substr(0,f)+o:"",+c[1]<0&&!d?s="0":s+=u.substr(f).replace(/(\d{3})(?=\d)/g,"$1"+o),r&&(s+=t+p.slice(-r)),c[1]&&+s!=0&&(s+="e"+c[1]),s}var FormatUtilities={dateFormat,format:format$d,numberFormat:numberFormat$2},clamp$i=Utilities.clamp,pick$1x=Utilities.pick,stableSort$6=Utilities.stableSort,RendererUtilities;(function(n){function r(t,o,s){var a=t,l=a.reducedLen||o,h=function(m,x){return(x.rank||0)-(m.rank||0)},c=function(m,x){return m.target-x.target},d,p=!0,u=[],f,g,v=0;for(d=t.length;d--;)v+=t[d].size;if(v>l){for(stableSort$6(t,h),d=0,v=0;v<=l;)v+=t[d].size,d++;u=t.splice(d-1,t.length)}for(stableSort$6(t,c),t=t.map(function(m){return{size:m.size,targets:[m.target],align:pick$1x(m.align,.5)}});p;){for(d=t.length;d--;)f=t[d],g=(Math.min.apply(0,f.targets)+Math.max.apply(0,f.targets))/2,f.pos=clamp$i(g-f.size*f.align,0,o-f.size);for(d=t.length,p=!1;d--;)d>0&&t[d-1].pos+t[d-1].size>t[d].pos&&(t[d-1].size+=t[d].size,t[d-1].targets=t[d-1].targets.concat(t[d].targets),t[d-1].align=.5,t[d-1].pos+t[d-1].size>o&&(t[d-1].pos=o-t[d-1].size),t.splice(d,1),p=!0)}return a.push.apply(a,u),d=0,t.some(function(m){var x=0;return(m.targets||[]).some(function(){return a[d].pos=m.pos+x,typeof s<"u"&&Math.abs(a[d].pos-a[d].target)>s?(a.slice(0,d+1).forEach(function(y){return delete y.pos}),a.reducedLen=(a.reducedLen||o)-o*.1,a.reducedLen>o*.1&&r(a,o,s),!0):(x+=a[d].size,d++,!1)})}),stableSort$6(a,c),a}n.distribute=r})(RendererUtilities||(RendererUtilities={}));const R=RendererUtilities;var animate$1=animationExports.animate,animObject$b=animationExports.animObject,stop$1=animationExports.stop,deg2rad$8=H.deg2rad,doc$l=H.doc,noop$l=H.noop,svg$4=H.svg,SVG_NS$2=H.SVG_NS,win$d=H.win,addEvent$11=Utilities.addEvent,attr$6=Utilities.attr,createElement$9=Utilities.createElement,css$c=Utilities.css,defined$T=Utilities.defined,erase$8=Utilities.erase,extend$1o=Utilities.extend,fireEvent$A=Utilities.fireEvent,isArray$l=Utilities.isArray,isFunction$4=Utilities.isFunction,isNumber$M=Utilities.isNumber,isString$a=Utilities.isString,merge$1k=Utilities.merge,objectEach$w=Utilities.objectEach,pick$1w=Utilities.pick,pInt$7=Utilities.pInt,syncTimeout$8=Utilities.syncTimeout,uniqueKey$7=Utilities.uniqueKey,SVGElement=function(){function n(){this.element=void 0,this.onEvents={},this.opacity=1,this.renderer=void 0,this.SVG_NS=SVG_NS$2,this.symbolCustomAttribs=["x","y","width","height","r","start","end","innerR","anchorX","anchorY","rounded"]}return n.prototype._defaultGetter=function(r){var t=pick$1w(this[r+"Value"],this[r],this.element?this.element.getAttribute(r):null,0);return/^[\-0-9\.]+$/.test(t)&&(t=parseFloat(t)),t},n.prototype._defaultSetter=function(r,t,o){o.setAttribute(t,r)},n.prototype.add=function(r){var t=this.renderer,o=this.element,s;return r&&(this.parentGroup=r),this.parentInverted=r&&r.inverted,typeof this.textStr<"u"&&this.element.nodeName==="text"&&t.buildText(this),this.added=!0,(!r||r.handleZ||this.zIndex)&&(s=this.zIndexSetter()),s||(r?r.element:t.box).appendChild(o),this.onAdd&&this.onAdd(),this},n.prototype.addClass=function(r,t){var o=t?"":this.attr("class")||"";return r=(r||"").split(/ /g).reduce(function(s,a){return o.indexOf(a)===-1&&s.push(a),s},o?[o]:[]).join(" "),r!==o&&this.attr("class",r),this},n.prototype.afterSetters=function(){this.doTransform&&(this.updateTransform(),this.doTransform=!1)},n.prototype.align=function(r,t,o){var s={},a=this.renderer,l=a.alignedObjects,h,c,d,p,u;r?(this.alignOptions=r,this.alignByTranslate=t,(!o||isString$a(o))&&(this.alignTo=d=o||"renderer",erase$8(l,this),l.push(this),o=void 0)):(r=this.alignOptions,t=this.alignByTranslate,d=this.alignTo),o=pick$1w(o,a[d],d==="scrollablePlotBox"?a.plotBox:void 0,a);var f=r.align,g=r.verticalAlign;return h=(o.x||0)+(r.x||0),c=(o.y||0)+(r.y||0),f==="right"?p=1:f==="center"&&(p=2),p&&(h+=(o.width-(r.width||0))/p),s[t?"translateX":"x"]=Math.round(h),g==="bottom"?u=1:g==="middle"&&(u=2),u&&(c+=(o.height-(r.height||0))/u),s[t?"translateY":"y"]=Math.round(c),this[this.placed?"animate":"attr"](s),this.placed=!0,this.alignAttr=s,this},n.prototype.alignSetter=function(r){var t={left:"start",center:"middle",right:"end"};t[r]&&(this.alignValue=r,this.element.setAttribute("text-anchor",t[r]))},n.prototype.animate=function(r,t,o){var s=this,a=animObject$b(pick$1w(t,this.renderer.globalAnimation,!0)),l=a.defer;return pick$1w(doc$l.hidden,doc$l.msHidden,doc$l.webkitHidden,!1)&&(a.duration=0),a.duration!==0?(o&&(a.complete=o),syncTimeout$8(function(){s.element&&animate$1(s,r,a)},l)):(this.attr(r,void 0,o),objectEach$w(r,function(h,c){a.step&&a.step.call(this,h,{prop:c,pos:1,elem:this})},this)),this},n.prototype.applyTextOutline=function(r){var t=this.element,o=r.indexOf("contrast")!==-1;o&&(r=r.replace(/contrast/g,this.renderer.getContrast(t.style.fill)));var s=r.split(" "),a=s[s.length-1],l=s[0];if(l&&l!=="none"&&H.svg){this.fakeTS=!0,this.ySetter=this.xSetter,l=l.replace(/(^[\d\.]+)(.*?)$/g,function(d,p,u){return 2*Number(p)+u}),this.removeTextOutline();var h=doc$l.createElementNS(SVG_NS$2,"tspan");attr$6(h,{class:"highcharts-text-outline",fill:a,stroke:a,"stroke-width":l,"stroke-linejoin":"round"}),[].forEach.call(t.childNodes,function(d){var p=d.cloneNode(!0);p.removeAttribute&&["fill","stroke","stroke-width","stroke"].forEach(function(u){return p.removeAttribute(u)}),h.appendChild(p)});var c=doc$l.createElementNS(SVG_NS$2,"tspan");c.textContent="​",["x","y"].forEach(function(d){var p=t.getAttribute(d);p&&c.setAttribute(d,p)}),h.appendChild(c),t.insertBefore(h,t.firstChild)}},n.prototype.attr=function(r,t,o,s){var a=this.element,l=this.symbolCustomAttribs,h,c,d=this,p,u;return typeof r=="string"&&typeof t<"u"&&(h=r,r={},r[h]=t),typeof r=="string"?d=(this[r+"Getter"]||this._defaultGetter).call(this,r,a):(objectEach$w(r,function(g,v){p=!1,s||stop$1(this,v),this.symbolName&&l.indexOf(v)!==-1&&(c||(this.symbolAttr(r),c=!0),p=!0),this.rotation&&(v==="x"||v==="y")&&(this.doTransform=!0),p||(u=this[v+"Setter"]||this._defaultSetter,u.call(this,g,v,a),!this.styledMode&&this.shadows&&/^(width|height|visibility|x|y|d|transform|cx|cy|r)$/.test(v)&&this.updateShadows(v,g,u))},this),this.afterSetters()),o&&o.call(this),d},n.prototype.clip=function(r){return this.attr("clip-path",r?"url("+this.renderer.url+"#"+r.id+")":"none")},n.prototype.crisp=function(r,t){var o=this;t=t||r.strokeWidth||0;var s=Math.round(t)%2/2;return r.x=Math.floor(r.x||o.x||0)+s,r.y=Math.floor(r.y||o.y||0)+s,r.width=Math.floor((r.width||o.width||0)-2*s),r.height=Math.floor((r.height||o.height||0)-2*s),defined$T(r.strokeWidth)&&(r.strokeWidth=t),r},n.prototype.complexColor=function(r,t,o){var s=this.renderer,a,l,h,c,d,p,u,f,g,v,m=[],x;fireEvent$A(this.renderer,"complexColor",{args:arguments},function(){if(r.radialGradient?l="radialGradient":r.linearGradient&&(l="linearGradient"),l){if(h=r[l],d=s.gradients,p=r.stops,g=o.radialReference,isArray$l(h)&&(r[l]=h={x1:h[0],y1:h[1],x2:h[2],y2:h[3],gradientUnits:"userSpaceOnUse"}),l==="radialGradient"&&g&&!defined$T(h.gradientUnits)&&(c=h,h=merge$1k(h,s.getRadialAttr(g,c),{gradientUnits:"userSpaceOnUse"})),objectEach$w(h,function(b,$){$!=="id"&&m.push($,b)}),objectEach$w(p,function(b){m.push(b)}),m=m.join(","),d[m])v=d[m].attr("id");else{h.id=v=uniqueKey$7();var y=d[m]=s.createElement(l).attr(h).add(s.defs);y.radAttr=c,y.stops=[],p.forEach(function(b){b[1].indexOf("rgba")===0?(a=Color.parse(b[1]),u=a.get("rgb"),f=a.get("a")):(u=b[1],f=1);var $=s.createElement("stop").attr({offset:b[0],"stop-color":u,"stop-opacity":f}).add(y);y.stops.push($)})}x="url("+s.url+"#"+v+")",o.setAttribute(t,x),o.gradient=m,r.toString=function(){return x}}})},n.prototype.css=function(r){var t=this.styles,o={},s=this.element,a=["textOutline","textOverflow","width"],l,h="",c,d=!t;return r&&r.color&&(r.fill=r.color),t&&objectEach$w(r,function(p,u){t&&t[u]!==p&&(o[u]=p,d=!0)}),d&&(t&&(r=extend$1o(t,o)),r&&(r.width===null||r.width==="auto"?delete this.textWidth:s.nodeName.toLowerCase()==="text"&&r.width&&(l=this.textWidth=pInt$7(r.width))),this.styles=r,l&&!svg$4&&this.renderer.forExport&&delete r.width,s.namespaceURI===this.SVG_NS?(c=function(p,u){return"-"+u.toLowerCase()},objectEach$w(r,function(p,u){a.indexOf(u)===-1&&(h+=u.replace(/([A-Z])/g,c)+":"+p+";")}),h&&attr$6(s,"style",h)):css$c(s,r),this.added&&(this.element.nodeName==="text"&&this.renderer.buildText(this),r&&r.textOutline&&this.applyTextOutline(r.textOutline))),this},n.prototype.dashstyleSetter=function(r){var t,o=this["stroke-width"];if(o==="inherit"&&(o=1),r=r&&r.toLowerCase(),r){var s=r.replace("shortdashdotdot","3,1,1,1,1,1,").replace("shortdashdot","3,1,1,1").replace("shortdot","1,1,").replace("shortdash","3,1,").replace("longdash","8,3,").replace(/dot/g,"1,3,").replace("dash","4,3,").replace(/,$/,"").split(",");for(t=s.length;t--;)s[t]=""+pInt$7(s[t])*pick$1w(o,NaN);r=s.join(",").replace(/NaN/g,"none"),this.element.setAttribute("stroke-dasharray",r)}},n.prototype.destroy=function(){var r=this,t=r.element||{},o=r.renderer,s=t.ownerSVGElement,a=o.isSVG&&t.nodeName==="SPAN"&&r.parentGroup||void 0,l,h;if(t.onclick=t.onmouseout=t.onmouseover=t.onmousemove=t.point=null,stop$1(r),r.clipPath&&s){var c=r.clipPath;[].forEach.call(s.querySelectorAll("[clip-path],[CLIP-PATH]"),function(d){d.getAttribute("clip-path").indexOf(c.element.id)>-1&&d.removeAttribute("clip-path")}),r.clipPath=c.destroy()}if(r.stops){for(h=0;h<r.stops.length;h++)r.stops[h].destroy();r.stops.length=0,r.stops=void 0}for(r.safeRemoveChild(t),o.styledMode||r.destroyShadows();a&&a.div&&a.div.childNodes.length===0;)l=a.parentGroup,r.safeRemoveChild(a.div),delete a.div,a=l;r.alignTo&&erase$8(o.alignedObjects,r),objectEach$w(r,function(d,p){r[p]&&r[p].parentGroup===r&&r[p].destroy&&r[p].destroy(),delete r[p]})},n.prototype.destroyShadows=function(){(this.shadows||[]).forEach(function(r){this.safeRemoveChild(r)},this),this.shadows=void 0},n.prototype.destroyTextPath=function(r,t){var o=r.getElementsByTagName("text")[0],s;if(o){if(o.removeAttribute("dx"),o.removeAttribute("dy"),t.element.setAttribute("id",""),this.textPathWrapper&&o.getElementsByTagName("textPath").length){for(s=this.textPathWrapper.element.childNodes;s.length;)o.appendChild(s[0]);o.removeChild(this.textPathWrapper.element)}}else(r.getAttribute("dx")||r.getAttribute("dy"))&&(r.removeAttribute("dx"),r.removeAttribute("dy"));this.textPathWrapper&&(this.textPathWrapper=this.textPathWrapper.destroy())},n.prototype.dSetter=function(r,t,o){isArray$l(r)&&(typeof r[0]=="string"&&(r=this.renderer.pathToSegments(r)),this.pathArray=r,r=r.reduce(function(s,a,l){return!a||!a.join?(a||"").toString():(l?s+" ":"")+a.join(" ")},"")),/(NaN| {2}|^$)/.test(r)&&(r="M 0 0"),this[t]!==r&&(o.setAttribute(t,r),this[t]=r)},n.prototype.fadeOut=function(r){var t=this;t.animate({opacity:0},{duration:pick$1w(r,150),complete:function(){t.attr({y:-9999}).hide()}})},n.prototype.fillSetter=function(r,t,o){typeof r=="string"?o.setAttribute(t,r):r&&this.complexColor(r,t,o)},n.prototype.getBBox=function(r,t){var o=this,s=o.renderer,a=o.element,l=o.styles,h=o.textStr,c=s.cache,d=s.cacheKeys,p=a.namespaceURI===o.SVG_NS,u=pick$1w(t,o.rotation,0),f=s.styledMode?a&&n.prototype.getStyle.call(a,"font-size"):l&&l.fontSize,g,v,m,x,y;if(defined$T(h)&&(y=h.toString(),y.indexOf("<")===-1&&(y=y.replace(/[0-9]/g,"0")),y+=["",u,f,o.textWidth,l&&l.textOverflow,l&&l.fontWeight].join(",")),y&&!r&&(g=c[y]),!g){if(p||s.forExport){try{x=this.fakeTS&&function($){var S=a.querySelector(".highcharts-text-outline");S&&css$c(S,{display:$})},isFunction$4(x)&&x("none"),g=a.getBBox?extend$1o({},a.getBBox()):{width:a.offsetWidth,height:a.offsetHeight},isFunction$4(x)&&x("")}catch{}(!g||g.width<0)&&(g={width:0,height:0})}else g=o.htmlGetBBox();if(s.isSVG&&(v=g.width,m=g.height,p&&(g.height=m={"11px,17":14,"13px,20":16}[l&&l.fontSize+","+Math.round(m)]||m),u)){var b=u*deg2rad$8;g.width=Math.abs(m*Math.sin(b))+Math.abs(v*Math.cos(b)),g.height=Math.abs(m*Math.cos(b))+Math.abs(v*Math.sin(b))}if(y&&(h===""||g.height>0)){for(;d.length>250;)delete c[d.shift()];c[y]||d.push(y),c[y]=g}}return g},n.prototype.getStyle=function(r){return win$d.getComputedStyle(this.element||this,"").getPropertyValue(r)},n.prototype.hasClass=function(r){return(""+this.attr("class")).split(" ").indexOf(r)!==-1},n.prototype.hide=function(r){return r?this.attr({y:-9999}):this.attr({visibility:"hidden"}),this},n.prototype.htmlGetBBox=function(){return{height:0,width:0,x:0,y:0}},n.prototype.init=function(r,t){this.element=t==="span"?createElement$9(t):doc$l.createElementNS(this.SVG_NS,t),this.renderer=r,fireEvent$A(this,"afterInit")},n.prototype.invert=function(r){return this.inverted=r,this.updateTransform(),this},n.prototype.on=function(r,t){var o=this.onEvents;return o[r]&&o[r](),o[r]=addEvent$11(this.element,r,t),this},n.prototype.opacitySetter=function(r,t,o){var s=Number(Number(r).toFixed(3));this.opacity=s,o.setAttribute(t,s)},n.prototype.removeClass=function(r){return this.attr("class",(""+this.attr("class")).replace(isString$a(r)?new RegExp("(^| )"+r+"( |$)"):r," ").replace(/ +/g," ").trim())},n.prototype.removeTextOutline=function(){var r=this.element.querySelector("tspan.highcharts-text-outline");r&&this.safeRemoveChild(r)},n.prototype.safeRemoveChild=function(r){var t=r.parentNode;t&&t.removeChild(r)},n.prototype.setRadialReference=function(r){var t=this.element.gradient&&this.renderer.gradients[this.element.gradient];return this.element.radialReference=r,t&&t.radAttr&&t.animate(this.renderer.getRadialAttr(r,t.radAttr)),this},n.prototype.setTextPath=function(r,t){var o=this.element,s=this.text?this.text.element:o,a={textAnchor:"text-anchor"},l=!1,h,c,d=this.textPathWrapper,p=!d;t=merge$1k(!0,{enabled:!0,attributes:{dy:-5,startOffset:"50%",textAnchor:"middle"}},t);var u=AST.filterUserAttributes(t.attributes);if(r&&t&&t.enabled){if(d&&d.element.parentNode===null?(p=!0,d=d.destroy()):d&&this.removeTextOutline.call(d.parentGroup),this.options&&this.options.padding&&(u.dx=-this.options.padding),d||(this.textPathWrapper=d=this.renderer.createElement("textPath"),l=!0),h=d.element,c=r.element.getAttribute("id"),c||r.element.setAttribute("id",c=uniqueKey$7()),p){s.setAttribute("y",0),isNumber$M(u.dx)&&s.setAttribute("x",-u.dx);for(var f=[].slice.call(s.childNodes),g=0;g<f.length;g++){var v=f[g];(v.nodeType===Node.TEXT_NODE||v.nodeName==="tspan")&&h.appendChild(v)}}l&&d&&d.add({element:s}),h.setAttributeNS("http://www.w3.org/1999/xlink","href",this.renderer.url+"#"+c),defined$T(u.dy)&&(h.parentNode.setAttribute("dy",u.dy),delete u.dy),defined$T(u.dx)&&(h.parentNode.setAttribute("dx",u.dx),delete u.dx),objectEach$w(u,function(m,x){h.setAttribute(a[x]||x,m)}),o.removeAttribute("transform"),this.removeTextOutline.call(d),this.text&&!this.renderer.styledMode&&this.attr({fill:"none","stroke-width":0}),this.updateTransform=noop$l,this.applyTextOutline=noop$l}else d&&(delete this.updateTransform,delete this.applyTextOutline,this.destroyTextPath(o,r),this.updateTransform(),this.options&&this.options.rotation&&this.applyTextOutline(this.options.style.textOutline));return this},n.prototype.shadow=function(r,t,o){var s=[],a=this.element,l=this.oldShadowOptions,h={color:palette.neutralColor100,offsetX:this.parentInverted?-1:1,offsetY:this.parentInverted?-1:1,opacity:.15,width:3},c,d,p,u,f=!1,g,v;if(r===!0?v=h:typeof r=="object"&&(v=extend$1o(h,r)),v&&(v&&l&&objectEach$w(v,function(m,x){m!==l[x]&&(f=!0)}),f&&this.destroyShadows(),this.oldShadowOptions=v),!v)this.destroyShadows();else if(!this.shadows){for(u=v.opacity/v.width,g=this.parentInverted?"translate("+v.offsetY+", "+v.offsetX+")":"translate("+v.offsetX+", "+v.offsetY+")",c=1;c<=v.width;c++)d=a.cloneNode(!1),p=v.width*2+1-2*c,attr$6(d,{stroke:r.color||palette.neutralColor100,"stroke-opacity":u*c,"stroke-width":p,transform:g,fill:"none"}),d.setAttribute("class",(d.getAttribute("class")||"")+" highcharts-shadow"),o&&(attr$6(d,"height",Math.max(attr$6(d,"height")-p,0)),d.cutHeight=p),t?t.element.appendChild(d):a.parentNode&&a.parentNode.insertBefore(d,a),s.push(d);this.shadows=s}return this},n.prototype.show=function(r){return this.attr({visibility:r?"inherit":"visible"})},n.prototype.strokeSetter=function(r,t,o){this[t]=r,this.stroke&&this["stroke-width"]?(n.prototype.fillSetter.call(this,this.stroke,"stroke",o),o.setAttribute("stroke-width",this["stroke-width"]),this.hasStroke=!0):t==="stroke-width"&&r===0&&this.hasStroke?(o.removeAttribute("stroke"),this.hasStroke=!1):this.renderer.styledMode&&this["stroke-width"]&&(o.setAttribute("stroke-width",this["stroke-width"]),this.hasStroke=!0)},n.prototype.strokeWidth=function(){if(!this.renderer.styledMode)return this["stroke-width"]||0;var r=this.getStyle("stroke-width"),t=0,o;return r.indexOf("px")===r.length-2?t=pInt$7(r):r!==""&&(o=doc$l.createElementNS(SVG_NS$2,"rect"),attr$6(o,{width:r,"stroke-width":0}),this.element.parentNode.appendChild(o),t=o.getBBox().width,o.parentNode.removeChild(o)),t},n.prototype.symbolAttr=function(r){var t=this;["x","y","r","start","end","width","height","innerR","anchorX","anchorY","clockwise"].forEach(function(o){t[o]=pick$1w(r[o],t[o])}),t.attr({d:t.renderer.symbols[t.symbolName](t.x,t.y,t.width,t.height,t)})},n.prototype.textSetter=function(r){r!==this.textStr&&(delete this.textPxLength,this.textStr=r,this.added&&this.renderer.buildText(this))},n.prototype.titleSetter=function(r){var t=this.element,o=t.getElementsByTagName("title")[0]||doc$l.createElementNS(this.SVG_NS,"title");t.insertBefore?t.insertBefore(o,t.firstChild):t.appendChild(o),o.textContent=String(pick$1w(r,"")).replace(/<[^>]*>/g,"").replace(/&lt;/g,"<").replace(/&gt;/g,">")},n.prototype.toFront=function(){var r=this.element;return r.parentNode.appendChild(r),this},n.prototype.translate=function(r,t){return this.attr({translateX:r,translateY:t})},n.prototype.updateShadows=function(r,t,o){var s=this.shadows;if(s)for(var a=s.length;a--;)o.call(s[a],r==="height"?Math.max(t-(s[a].cutHeight||0),0):r==="d"?this.d:t,r,s[a])},n.prototype.updateTransform=function(){var r=this,t=r.scaleX,o=r.scaleY,s=r.inverted,a=r.rotation,l=r.matrix,h=r.element,c=r.translateX||0,d=r.translateY||0;s&&(c+=r.width,d+=r.height);var p=["translate("+c+","+d+")"];defined$T(l)&&p.push("matrix("+l.join(",")+")"),s?p.push("rotate(90) scale(-1,1)"):a&&p.push("rotate("+a+" "+pick$1w(this.rotationOriginX,h.getAttribute("x"),0)+" "+pick$1w(this.rotationOriginY,h.getAttribute("y")||0)+")"),(defined$T(t)||defined$T(o))&&p.push("scale("+pick$1w(t,1)+" "+pick$1w(o,1)+")"),p.length&&h.setAttribute("transform",p.join(" "))},n.prototype.visibilitySetter=function(r,t,o){r==="inherit"?o.removeAttribute(t):this[t]!==r&&o.setAttribute(t,r),this[t]=r},n.prototype.xGetter=function(r){return this.element.nodeName==="circle"&&(r==="x"?r="cx":r==="y"&&(r="cy")),this._defaultGetter(r)},n.prototype.zIndexSetter=function(r,t){var o=this.renderer,s=this.parentGroup,a=s||o,l=a.element||o.box,h=this.element,c=l===o.box,d,p,u,f=!1,g,v=this.added,m;if(defined$T(r)?(h.setAttribute("data-z-index",r),r=+r,this[t]===r&&(v=!1)):defined$T(this[t])&&h.removeAttribute("data-z-index"),this[t]=r,v){for(r=this.zIndex,r&&s&&(s.handleZ=!0),d=l.childNodes,m=d.length-1;m>=0&&!f;m--)p=d[m],u=p.getAttribute("data-z-index"),g=!defined$T(u),p!==h&&(r<0&&g&&!c&&!m?(l.insertBefore(h,d[m]),f=!0):(pInt$7(u)<=r||g&&(!defined$T(r)||r>=0))&&(l.insertBefore(h,d[m+1]||null),f=!0));f||(l.insertBefore(h,d[c?3:0]||null),f=!0)}return f},n}();SVGElement.prototype["stroke-widthSetter"]=SVGElement.prototype.strokeSetter;SVGElement.prototype.yGetter=SVGElement.prototype.xGetter;SVGElement.prototype.matrixSetter=SVGElement.prototype.rotationOriginXSetter=SVGElement.prototype.rotationOriginYSetter=SVGElement.prototype.rotationSetter=SVGElement.prototype.scaleXSetter=SVGElement.prototype.scaleYSetter=SVGElement.prototype.translateXSetter=SVGElement.prototype.translateYSetter=SVGElement.prototype.verticalAlignSetter=function(n,r){this[r]=n,this.doTransform=!0};var RendererRegistry;(function(n){n.rendererTypes={};var r;function t(s){return s===void 0&&(s=r),n.rendererTypes[s]||n.rendererTypes[r]}n.getRendererType=t;function o(s,a,l){n.rendererTypes[s]=a,(!r||l)&&(r=s,H.Renderer=a)}n.registerRendererType=o})(RendererRegistry||(RendererRegistry={}));const RendererRegistry$1=RendererRegistry;var __extends$Y=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),defined$S=Utilities.defined,extend$1n=Utilities.extend,isNumber$L=Utilities.isNumber,merge$1j=Utilities.merge,pick$1v=Utilities.pick,removeEvent$b=Utilities.removeEvent,SVGLabel=function(n){__extends$Y(r,n);function r(t,o,s,a,l,h,c,d,p,u){var f=n.call(this)||this;f.paddingLeftSetter=f.paddingSetter,f.paddingRightSetter=f.paddingSetter,f.init(t,"g"),f.textStr=o,f.x=s,f.y=a,f.anchorX=h,f.anchorY=c,f.baseline=p,f.className=u,f.addClass(u==="button"?"highcharts-no-tooltip":"highcharts-label"),u&&f.addClass("highcharts-"+u),f.text=t.text(void 0,0,0,d).attr({zIndex:1});var g;return typeof l=="string"&&(g=/^url\((.*?)\)$/.test(l),(g||f.renderer.symbols[l])&&(f.symbolKey=l)),f.bBox=r.emptyBBox,f.padding=3,f.baselineOffset=0,f.needsBox=t.styledMode||g,f.deferredAttr={},f.alignFactor=0,f}return r.prototype.alignSetter=function(t){var o={left:0,center:.5,right:1}[t];o!==this.alignFactor&&(this.alignFactor=o,this.bBox&&isNumber$L(this.xSetting)&&this.attr({x:this.xSetting}))},r.prototype.anchorXSetter=function(t,o){this.anchorX=t,this.boxAttr(o,Math.round(t)-this.getCrispAdjust()-this.xSetting)},r.prototype.anchorYSetter=function(t,o){this.anchorY=t,this.boxAttr(o,t-this.ySetting)},r.prototype.boxAttr=function(t,o){this.box?this.box.attr(t,o):this.deferredAttr[t]=o},r.prototype.css=function(t){if(t){var o={};t=merge$1j(t),r.textProps.forEach(function(l){typeof t[l]<"u"&&(o[l]=t[l],delete t[l])}),this.text.css(o);var s="width"in o,a="fontSize"in o||"fontWeight"in o;a?this.updateTextPadding():s&&this.updateBoxSize()}return SVGElement.prototype.css.call(this,t)},r.prototype.destroy=function(){removeEvent$b(this.element,"mouseenter"),removeEvent$b(this.element,"mouseleave"),this.text&&this.text.destroy(),this.box&&(this.box=this.box.destroy()),SVGElement.prototype.destroy.call(this)},r.prototype.fillSetter=function(t,o){t&&(this.needsBox=!0),this.fill=t,this.boxAttr(o,t)},r.prototype.getBBox=function(){this.textStr&&this.bBox.width===0&&this.bBox.height===0&&this.updateBoxSize();var t=this.padding,o=pick$1v(this.paddingLeft,t);return{width:this.width,height:this.height,x:this.bBox.x-o,y:this.bBox.y-t}},r.prototype.getCrispAdjust=function(){return this.renderer.styledMode&&this.box?this.box.strokeWidth()%2/2:(this["stroke-width"]?parseInt(this["stroke-width"],10):0)%2/2},r.prototype.heightSetter=function(t){this.heightSetting=t},r.prototype.onAdd=function(){var t=this.textStr;this.text.add(this),this.attr({text:defined$S(t)?t:"",x:this.x,y:this.y}),this.box&&defined$S(this.anchorX)&&this.attr({anchorX:this.anchorX,anchorY:this.anchorY})},r.prototype.paddingSetter=function(t,o){isNumber$L(t)?t!==this[o]&&(this[o]=t,this.updateTextPadding()):this[o]=void 0},r.prototype.rSetter=function(t,o){this.boxAttr(o,t)},r.prototype.shadow=function(t){return t&&!this.renderer.styledMode&&(this.updateBoxSize(),this.box&&this.box.shadow(t)),this},r.prototype.strokeSetter=function(t,o){this.stroke=t,this.boxAttr(o,t)},r.prototype["stroke-widthSetter"]=function(t,o){t&&(this.needsBox=!0),this["stroke-width"]=t,this.boxAttr(o,t)},r.prototype["text-alignSetter"]=function(t){this.textAlign=t},r.prototype.textSetter=function(t){typeof t<"u"&&this.text.attr({text:t}),this.updateTextPadding()},r.prototype.updateBoxSize=function(){var t=this.text.element.style,o={},s=this.padding,a=this.bBox=(!isNumber$L(this.widthSetting)||!isNumber$L(this.heightSetting)||this.textAlign)&&defined$S(this.text.textStr)?this.text.getBBox():r.emptyBBox,l;this.width=this.getPaddedWidth(),this.height=(this.heightSetting||a.height||0)+2*s;var h=this.renderer.fontMetrics(t&&t.fontSize,this.text);if(this.baselineOffset=s+Math.min((this.text.firstLineMetrics||h).b,a.height||1/0),this.heightSetting&&(this.baselineOffset+=(this.heightSetting-h.h)/2),this.needsBox){if(!this.box){var c=this.box=this.symbolKey?this.renderer.symbol(this.symbolKey):this.renderer.rect();c.addClass((this.className==="button"?"":"highcharts-label-box")+(this.className?" highcharts-"+this.className+"-box":"")),c.add(this)}l=this.getCrispAdjust(),o.x=l,o.y=(this.baseline?-this.baselineOffset:0)+l,o.width=Math.round(this.width),o.height=Math.round(this.height),this.box.attr(extend$1n(o,this.deferredAttr)),this.deferredAttr={}}},r.prototype.updateTextPadding=function(){var t=this.text;this.updateBoxSize();var o=this.baseline?0:this.baselineOffset,s=pick$1v(this.paddingLeft,this.padding);defined$S(this.widthSetting)&&this.bBox&&(this.textAlign==="center"||this.textAlign==="right")&&(s+={center:.5,right:1}[this.textAlign]*(this.widthSetting-this.bBox.width)),(s!==t.x||o!==t.y)&&(t.attr("x",s),t.hasBoxWidthChanged&&(this.bBox=t.getBBox(!0)),typeof o<"u"&&t.attr("y",o)),t.x=s,t.y=o},r.prototype.widthSetter=function(t){this.widthSetting=isNumber$L(t)?t:void 0},r.prototype.getPaddedWidth=function(){var t=this.padding,o=pick$1v(this.paddingLeft,t),s=pick$1v(this.paddingRight,t);return(this.widthSetting||this.bBox.width||0)+o+s},r.prototype.xSetter=function(t){this.x=t,this.alignFactor&&(t-=this.alignFactor*this.getPaddedWidth(),this["forceAnimate:x"]=!0),this.xSetting=Math.round(t),this.attr("translateX",this.xSetting)},r.prototype.ySetter=function(t){this.ySetting=this.y=Math.round(t),this.attr("translateY",this.ySetting)},r.emptyBBox={width:0,height:0,x:0,y:0},r.textProps=["color","direction","fontFamily","fontSize","fontStyle","fontWeight","lineHeight","textAlign","textDecoration","textOutline","textOverflow","width"],r}(SVGElement),defined$R=Utilities.defined,isNumber$K=Utilities.isNumber,pick$1u=Utilities.pick;function arc$1(n,r,t,o,s){var a=[];if(s){var l=s.start||0,h=pick$1u(s.r,t),c=pick$1u(s.r,o||t),d=.001,p=Math.abs((s.end||0)-l-2*Math.PI)<d,u=(s.end||0)-d,f=s.innerR,g=pick$1u(s.open,p),v=Math.cos(l),m=Math.sin(l),x=Math.cos(u),y=Math.sin(u),b=pick$1u(s.longArc,u-l-Math.PI<d?0:1);a.push(["M",n+h*v,r+c*m],["A",h,c,0,b,pick$1u(s.clockwise,1),n+h*x,r+c*y]),defined$R(f)&&a.push(g?["M",n+f*x,r+f*y]:["L",n+f*x,r+f*y],["A",f,f,0,b,defined$R(s.clockwise)?1-s.clockwise:0,n+f*v,r+f*m]),g||a.push(["Z"])}return a}function callout(n,r,t,o,s){var a=6,l=6,h=Math.min(s&&s.r||0,t,o),c=h+l,d=s&&s.anchorX,p=s&&s.anchorY||0,u=roundedRect(n,r,t,o,{r:h});return isNumber$K(d)&&(n+d>=t?p>r+c&&p<r+o-c?u.splice(3,1,["L",n+t,p-l],["L",n+t+a,p],["L",n+t,p+l],["L",n+t,r+o-h]):u.splice(3,1,["L",n+t,o/2],["L",d,p],["L",n+t,o/2],["L",n+t,r+o-h]):n+d<=0?p>r+c&&p<r+o-c?u.splice(7,1,["L",n,p+l],["L",n-a,p],["L",n,p-l],["L",n,r+h]):u.splice(7,1,["L",n,o/2],["L",d,p],["L",n,o/2],["L",n,r+h]):p&&p>o&&d>n+c&&d<n+t-c?u.splice(5,1,["L",d+l,r+o],["L",d,r+o+a],["L",d-l,r+o],["L",n+h,r+o]):p&&p<0&&d>n+c&&d<n+t-c&&u.splice(1,1,["L",d-l,r],["L",d,r-a],["L",d+l,r],["L",t-h,r])),u}function circle(n,r,t,o){return arc$1(n+t/2,r+o/2,t/2,o/2,{start:Math.PI*.5,end:Math.PI*2.5,open:!1})}function diamond(n,r,t,o){return[["M",n+t/2,r],["L",n+t,r+o/2],["L",n+t/2,r+o],["L",n,r+o/2],["Z"]]}function rect(n,r,t,o,s){return s&&s.r?roundedRect(n,r,t,o,s):[["M",n,r],["L",n+t,r],["L",n+t,r+o],["L",n,r+o],["Z"]]}function roundedRect(n,r,t,o,s){var a=s&&s.r||0;return[["M",n+a,r],["L",n+t-a,r],["C",n+t,r,n+t,r,n+t,r+a],["L",n+t,r+o-a],["C",n+t,r+o,n+t,r+o,n+t-a,r+o],["L",n+a,r+o],["C",n,r+o,n,r+o,n,r+o-a],["L",n,r+a],["C",n,r,n,r,n+a,r]]}function triangle(n,r,t,o){return[["M",n+t/2,r],["L",n+t,r+o],["L",n,r+o],["Z"]]}function triangleDown(n,r,t,o){return[["M",n,r],["L",n+t,r],["L",n+t/2,r+o],["Z"]]}var Symbols={arc:arc$1,callout,circle,diamond,rect,roundedRect,square:rect,triangle,"triangle-down":triangleDown},doc$k=H.doc,SVG_NS$1=H.SVG_NS,attr$5=Utilities.attr,isString$9=Utilities.isString,objectEach$v=Utilities.objectEach,pick$1t=Utilities.pick,TextBuilder=function(){function n(r){var t=r.styles;this.renderer=r.renderer,this.svgElement=r,this.width=r.textWidth,this.textLineHeight=t&&t.lineHeight,this.textOutline=t&&t.textOutline,this.ellipsis=!!(t&&t.textOverflow==="ellipsis"),this.noWrap=!!(t&&t.whiteSpace==="nowrap"),this.fontSize=t&&t.fontSize}return n.prototype.buildSVG=function(){var r=this.svgElement,t=r.element,o=r.renderer,s=pick$1t(r.textStr,"").toString(),a=s.indexOf("<")!==-1,l=t.childNodes,h=this.width&&!r.added&&o.box,c=/<br.*?>/g,d=[s,this.ellipsis,this.noWrap,this.textLineHeight,this.textOutline,this.fontSize,this.width].join(",");if(d!==r.textCache){r.textCache=d,delete r.actualWidth;for(var p=l.length;p--;)t.removeChild(l[p]);if(!a&&!this.ellipsis&&!this.width&&(s.indexOf(" ")===-1||this.noWrap&&!c.test(s)))t.appendChild(doc$k.createTextNode(this.unescapeEntities(s)));else if(s!==""){h&&h.appendChild(t);var u=new AST(s);this.modifyTree(u.nodes),u.addToDOM(r.element),this.modifyDOM(),this.ellipsis&&(t.textContent||"").indexOf("…")!==-1&&r.attr("title",this.unescapeEntities(r.textStr||"",["&lt;","&gt;"])),h&&h.removeChild(t)}isString$9(this.textOutline)&&r.applyTextOutline&&r.applyTextOutline(this.textOutline)}},n.prototype.modifyDOM=function(){var r=this,t=this.svgElement,o=attr$5(t.element,"x");t.firstLineMetrics=void 0;for(var s;(s=t.element.firstChild)&&/^[\s\u200B]*$/.test(s.textContent||" ");)t.element.removeChild(s);[].forEach.call(t.element.querySelectorAll("tspan.highcharts-br"),function(c,d){c.nextSibling&&c.previousSibling&&(d===0&&c.previousSibling.nodeType===1&&(t.firstLineMetrics=t.renderer.fontMetrics(void 0,c.previousSibling)),attr$5(c,{dy:r.getLineHeight(c.nextSibling),x:o}))});var a=this.width||0;if(a){var l=function(c,d){var p=c.textContent||"",u=p.replace(/([^\^])-/g,"$1- ").split(" "),f=!r.noWrap&&(u.length>1||t.element.childNodes.length>1),g=r.getLineHeight(d),v=0,m=t.actualWidth;if(r.ellipsis)p&&r.truncate(c,p,void 0,0,Math.max(0,a-parseInt(r.fontSize||12,10)),function(b,$){return b.substring(0,$)+"…"});else if(f){for(var x=[],y=[];d.firstChild&&d.firstChild!==c;)y.push(d.firstChild),d.removeChild(d.firstChild);for(;u.length;)u.length&&!r.noWrap&&v>0&&(x.push(c.textContent||""),c.textContent=u.join(" ").replace(/- /g,"-")),r.truncate(c,void 0,u,v===0&&m||0,a,function(b,$){return u.slice(0,$).join(" ").replace(/- /g,"-")}),m=t.actualWidth,v++;y.forEach(function(b){d.insertBefore(b,c)}),x.forEach(function(b){d.insertBefore(doc$k.createTextNode(b),c);var $=doc$k.createElementNS(SVG_NS$1,"tspan");$.textContent="​",attr$5($,{dy:g,x:o}),d.insertBefore($,c)})}},h=function(c){var d=[].slice.call(c.childNodes);d.forEach(function(p){p.nodeType===Node.TEXT_NODE?l(p,c):(p.className.baseVal.indexOf("highcharts-br")!==-1&&(t.actualWidth=0),h(p))})};h(t.element)}},n.prototype.getLineHeight=function(r){var t,o=r.nodeType===Node.TEXT_NODE?r.parentElement:r;return this.renderer.styledMode||(t=o&&/(px|em)$/.test(o.style.fontSize)?o.style.fontSize:this.fontSize||this.renderer.style.fontSize||12),this.textLineHeight?parseInt(this.textLineHeight.toString(),10):this.renderer.fontMetrics(t,o||this.svgElement.element).h},n.prototype.modifyTree=function(r){var t=this,o=function(s,a){var l=s.tagName,h=t.renderer.styledMode,c=s.attributes||{};if(l==="b"||l==="strong"?h?c.class="highcharts-strong":c.style="font-weight:bold;"+(c.style||""):(l==="i"||l==="em")&&(h?c.class="highcharts-emphasized":c.style="font-style:italic;"+(c.style||"")),isString$9(c.style)&&(c.style=c.style.replace(/(;| |^)color([ :])/,"$1fill$2")),l==="br"){c.class="highcharts-br",s.textContent="​";var d=r[a+1];d&&d.textContent&&(d.textContent=d.textContent.replace(/^ +/gm,""))}l!=="#text"&&l!=="a"&&(s.tagName="tspan"),s.attributes=c,s.children&&s.children.filter(function(p){return p.tagName!=="#text"}).forEach(o)};r.forEach(o)},n.prototype.truncate=function(r,t,o,s,a,l){var h=this.svgElement,c=h.renderer,d=h.rotation,p=[],u=o?1:0,f=(t||o||"").length,g=f,v,m,x=function(y,b){var $=b||y,S=r.parentNode;if(S&&typeof p[$]>"u")if(S.getSubStringLength)try{p[$]=s+S.getSubStringLength(0,o?$+1:$)}catch{}else c.getSpanWidth&&(r.textContent=l(t||o,y),p[$]=s+c.getSpanWidth(h,r));return p[$]};if(h.rotation=0,m=x(r.textContent.length),s+m>a){for(;u<=f;)g=Math.ceil((u+f)/2),o&&(v=l(o,g)),m=x(g,v&&v.length-1),u===f?u=f+1:m>a?f=g-1:u=g;f===0?r.textContent="":t&&f===t.length-1||(r.textContent=v||l(t||o,g))}o&&o.splice(0,g),h.actualWidth=m,h.rotation=d},n.prototype.unescapeEntities=function(r,t){return objectEach$v(this.renderer.escapes,function(o,s){(!t||t.indexOf(o)===-1)&&(r=r.toString().replace(new RegExp(o,"g"),s))}),r},n}(),charts$4=H.charts,deg2rad$7=H.deg2rad,doc$j=H.doc,isFirefox$3=H.isFirefox,isMS$2=H.isMS,isWebKit$1=H.isWebKit,noop$k=H.noop,SVG_NS=H.SVG_NS,symbolSizes=H.symbolSizes,win$c=H.win,addEvent$10=Utilities.addEvent,attr$4=Utilities.attr,createElement$8=Utilities.createElement,css$b=Utilities.css,defined$Q=Utilities.defined,destroyObjectProperties$9=Utilities.destroyObjectProperties,extend$1m=Utilities.extend,isArray$k=Utilities.isArray,isNumber$J=Utilities.isNumber,isObject$c=Utilities.isObject,isString$8=Utilities.isString,merge$1i=Utilities.merge,pick$1s=Utilities.pick,pInt$6=Utilities.pInt,uniqueKey$6=Utilities.uniqueKey,hasInternalReferenceBug,SVGRenderer=function(){function n(r,t,o,s,a,l,h){this.alignedObjects=void 0,this.box=void 0,this.boxWrapper=void 0,this.cache=void 0,this.cacheKeys=void 0,this.chartIndex=void 0,this.defs=void 0,this.globalAnimation=void 0,this.gradients=void 0,this.height=void 0,this.imgCount=void 0,this.isSVG=void 0,this.style=void 0,this.url=void 0,this.width=void 0,this.init(r,t,o,s,a,l,h)}return n.prototype.init=function(r,t,o,s,a,l,h){var c=this,d=c.createElement("svg").attr({version:"1.1",class:"highcharts-root"}),p=d.element;h||d.css(this.getStyle(s)),r.appendChild(p),attr$4(r,"dir","ltr"),r.innerHTML.indexOf("xmlns")===-1&&attr$4(p,"xmlns",this.SVG_NS),c.isSVG=!0,this.box=p,this.boxWrapper=d,c.alignedObjects=[],this.url=this.getReferenceURL();var u=this.createElement("desc").add();u.element.appendChild(doc$j.createTextNode("Created with Highcharts 9.2.2")),c.defs=this.createElement("defs").add(),c.allowHTML=l,c.forExport=a,c.styledMode=h,c.gradients={},c.cache={},c.cacheKeys=[],c.imgCount=0,c.setSize(t,o,!1);var f,g;isFirefox$3&&r.getBoundingClientRect&&(f=function(){css$b(r,{left:0,top:0}),g=r.getBoundingClientRect(),css$b(r,{left:Math.ceil(g.left)-g.left+"px",top:Math.ceil(g.top)-g.top+"px"})},f(),c.unSubPixelFix=addEvent$10(win$c,"resize",f))},n.prototype.definition=function(r){var t=new AST([r]);return t.addToDOM(this.defs.element)},n.prototype.getReferenceURL=function(){if((isFirefox$3||isWebKit$1)&&doc$j.getElementsByTagName("base").length){if(!defined$Q(hasInternalReferenceBug)){var r=uniqueKey$6(),t=new AST([{tagName:"svg",attributes:{width:8,height:8},children:[{tagName:"defs",children:[{tagName:"clipPath",attributes:{id:r},children:[{tagName:"rect",attributes:{width:4,height:4}}]}]},{tagName:"rect",attributes:{id:"hitme",width:8,height:8,"clip-path":"url(#"+r+")",fill:"rgba(0,0,0,0.001)"}}]}]),o=t.addToDOM(doc$j.body);css$b(o,{position:"fixed",top:0,left:0,zIndex:9e5});var s=doc$j.elementFromPoint(6,6);hasInternalReferenceBug=(s&&s.id)==="hitme",doc$j.body.removeChild(o)}if(hasInternalReferenceBug)return win$c.location.href.split("#")[0].replace(/<[^>]*>/g,"").replace(/([\('\)])/g,"\\$1").replace(/ /g,"%20")}return""},n.prototype.getStyle=function(r){return this.style=extend$1m({fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',fontSize:"12px"},r),this.style},n.prototype.setStyle=function(r){this.boxWrapper.css(this.getStyle(r))},n.prototype.isHidden=function(){return!this.boxWrapper.getBBox().width},n.prototype.destroy=function(){var r=this,t=r.defs;return r.box=null,r.boxWrapper=r.boxWrapper.destroy(),destroyObjectProperties$9(r.gradients||{}),r.gradients=null,t&&(r.defs=t.destroy()),r.unSubPixelFix&&r.unSubPixelFix(),r.alignedObjects=null,null},n.prototype.createElement=function(r){var t=new this.Element;return t.init(this,r),t},n.prototype.getRadialAttr=function(r,t){return{cx:r[0]-r[2]/2+(t.cx||0)*r[2],cy:r[1]-r[2]/2+(t.cy||0)*r[2],r:(t.r||0)*r[2]}},n.prototype.buildText=function(r){new TextBuilder(r).buildSVG()},n.prototype.getContrast=function(r){return r=Color.parse(r).rgba,r[0]*=1,r[1]*=1.2,r[2]*=.5,r[0]+r[1]+r[2]>1.8*255?"#000000":"#FFFFFF"},n.prototype.button=function(r,t,o,s,a,l,h,c,d,p){var u=this.label(r,t,o,d,void 0,void 0,p,void 0,"button"),f=this.styledMode,g=0,v=a?merge$1i(a):{},m=v&&v.style||{};v=AST.filterUserAttributes(v),u.attr(merge$1i({padding:8,r:2},v));var x,y,b,$;return f||(v=merge$1i({fill:palette.neutralColor3,stroke:palette.neutralColor20,"stroke-width":1,style:{color:palette.neutralColor80,cursor:"pointer",fontWeight:"normal"}},{style:m},v),x=v.style,delete v.style,l=merge$1i(v,{fill:palette.neutralColor10},AST.filterUserAttributes(l||{})),y=l.style,delete l.style,h=merge$1i(v,{fill:palette.highlightColor10,style:{color:palette.neutralColor100,fontWeight:"bold"}},AST.filterUserAttributes(h||{})),b=h.style,delete h.style,c=merge$1i(v,{style:{color:palette.neutralColor20}},AST.filterUserAttributes(c||{})),$=c.style,delete c.style),addEvent$10(u.element,isMS$2?"mouseover":"mouseenter",function(){g!==3&&u.setState(1)}),addEvent$10(u.element,isMS$2?"mouseout":"mouseleave",function(){g!==3&&u.setState(g)}),u.setState=function(S){S!==1&&(u.state=g=S),u.removeClass(/highcharts-button-(normal|hover|pressed|disabled)/).addClass("highcharts-button-"+["normal","hover","pressed","disabled"][S||0]),f||u.attr([v,l,h,c][S||0]).css([x,y,b,$][S||0])},f||u.attr(v).css(extend$1m({cursor:"default"},x)),u.on("touchstart",function(S){return S.stopPropagation()}).on("click",function(S){g!==3&&s.call(u,S)})},n.prototype.crispLine=function(r,t,o){o===void 0&&(o="round");var s=r[0],a=r[1];return defined$Q(s[1])&&s[1]===a[1]&&(s[1]=a[1]=Math[o](s[1])-t%2/2),defined$Q(s[2])&&s[2]===a[2]&&(s[2]=a[2]=Math[o](s[2])+t%2/2),r},n.prototype.path=function(r){var t=this.styledMode?{}:{fill:"none"};return isArray$k(r)?t.d=r:isObject$c(r)&&extend$1m(t,r),this.createElement("path").attr(t)},n.prototype.circle=function(r,t,o){var s=isObject$c(r)?r:typeof r>"u"?{}:{x:r,y:t,r:o},a=this.createElement("circle");return a.xSetter=a.ySetter=function(l,h,c){c.setAttribute("c"+h,l)},a.attr(s)},n.prototype.arc=function(r,t,o,s,a,l){var h;isObject$c(r)?(h=r,t=h.y,o=h.r,s=h.innerR,a=h.start,l=h.end,r=h.x):h={innerR:s,start:a,end:l};var c=this.symbol("arc",r,t,o,o,h);return c.r=o,c},n.prototype.rect=function(r,t,o,s,a,l){a=isObject$c(r)?r.r:a;var h=this.createElement("rect"),c=isObject$c(r)?r:typeof r>"u"?{}:{x:r,y:t,width:Math.max(o,0),height:Math.max(s,0)};return this.styledMode||(typeof l<"u"&&(c["stroke-width"]=l,c=h.crisp(c)),c.fill="none"),a&&(c.r=a),h.rSetter=function(d,p,u){h.r=d,attr$4(u,{rx:d,ry:d})},h.rGetter=function(){return h.r||0},h.attr(c)},n.prototype.setSize=function(r,t,o){var s=this;s.width=r,s.height=t,s.boxWrapper.animate({width:r,height:t},{step:function(){this.attr({viewBox:"0 0 "+this.attr("width")+" "+this.attr("height")})},duration:pick$1s(o,!0)?void 0:0}),s.alignElements()},n.prototype.g=function(r){var t=this.createElement("g");return r?t.attr({class:"highcharts-"+r}):t},n.prototype.image=function(r,t,o,s,a,l){var h={preserveAspectRatio:"none"},c=function(f,g){f.setAttributeNS?f.setAttributeNS("http://www.w3.org/1999/xlink","href",g):f.setAttribute("hc-svg-href",g)};arguments.length>1&&extend$1m(h,{x:t,y:o,width:s,height:a});var d=this.createElement("image").attr(h),p=function(f){c(d.element,r),l.call(d,f)};if(l){c(d.element,"data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==");var u=new win$c.Image;addEvent$10(u,"load",p),u.src=r,u.complete&&p({})}else c(d.element,r);return d},n.prototype.symbol=function(r,t,o,s,a,l){var h=this,c=/^url\((.*?)\)$/,d=c.test(r),p=!d&&(this.symbols[r]?r:"circle"),u=p&&this.symbols[p],f,g,v,m;if(u)typeof t=="number"&&(g=u.call(this.symbols,Math.round(t||0),Math.round(o||0),s||0,a||0,l)),f=this.path(g),h.styledMode||f.attr("fill","none"),extend$1m(f,{symbolName:p||void 0,x:t,y:o,width:s,height:a}),l&&extend$1m(f,l);else if(d){v=r.match(c)[1];var x=f=this.image(v);x.imgwidth=pick$1s(symbolSizes[v]&&symbolSizes[v].width,l&&l.width),x.imgheight=pick$1s(symbolSizes[v]&&symbolSizes[v].height,l&&l.height),m=function(y){return y.attr({width:y.width,height:y.height})},["width","height"].forEach(function(y){x[y+"Setter"]=function(b,$){var S=this["img"+$];if(this[$]=b,defined$Q(S)&&(l&&l.backgroundSize==="within"&&this.width&&this.height&&(S=Math.round(S*Math.min(this.width/this.imgwidth,this.height/this.imgheight))),this.element&&this.element.setAttribute($,S),!this.alignByTranslate)){var k=((this[$]||0)-S)/2,A=$==="width"?{translateX:k}:{translateY:k};this.attr(A)}}}),defined$Q(t)&&x.attr({x:t,y:o}),x.isImg=!0,defined$Q(x.imgwidth)&&defined$Q(x.imgheight)?m(x):(x.attr({width:0,height:0}),createElement$8("img",{onload:function(){var y=charts$4[h.chartIndex];this.width===0&&(css$b(this,{position:"absolute",top:"-999em"}),doc$j.body.appendChild(this)),symbolSizes[v]={width:this.width,height:this.height},x.imgwidth=this.width,x.imgheight=this.height,x.element&&m(x),this.parentNode&&this.parentNode.removeChild(this),h.imgCount--,!h.imgCount&&y&&!y.hasLoaded&&y.onload()},src:v}),this.imgCount++)}return f},n.prototype.clipRect=function(r,t,o,s){var a=uniqueKey$6()+"-",l=this.createElement("clipPath").attr({id:a}).add(this.defs),h=this.rect(r,t,o,s,0).add(l);return h.id=a,h.clipPath=l,h.count=0,h},n.prototype.text=function(r,t,o,s){var a=this,l={};if(s&&(a.allowHTML||!a.forExport))return a.html(r,t,o);l.x=Math.round(t||0),o&&(l.y=Math.round(o)),defined$Q(r)&&(l.text=r);var h=a.createElement("text").attr(l);return(!s||a.forExport&&!a.allowHTML)&&(h.xSetter=function(c,d,p){for(var u=p.getElementsByTagName("tspan"),f=p.getAttribute(d),g=0,v=void 0;g<u.length;g++)v=u[g],v.getAttribute(d)===f&&v.setAttribute(d,c);p.setAttribute(d,c)}),h},n.prototype.fontMetrics=function(r,t){(this.styledMode||!/px/.test(r))&&win$c.getComputedStyle?r=t&&SVGElement.prototype.getStyle.call(t,"font-size"):r=r||t&&t.style&&t.style.fontSize||this.style&&this.style.fontSize,/px/.test(r)?r=pInt$6(r):r=12;var o=r<24?r+3:Math.round(r*1.2),s=Math.round(o*.8);return{h:o,b:s,f:r}},n.prototype.rotCorr=function(r,t,o){var s=r;return t&&o&&(s=Math.max(s*Math.cos(t*deg2rad$7),4)),{x:-r/3*Math.sin(t*deg2rad$7),y:s}},n.prototype.pathToSegments=function(r){for(var t=[],o=[],s={A:8,C:7,H:2,L:3,M:3,Q:5,S:5,T:3,V:2},a=0;a<r.length;a++)isString$8(o[0])&&isNumber$J(r[a])&&o.length===s[o[0].toUpperCase()]&&r.splice(a,0,o[0].replace("M","L").replace("m","l")),typeof r[a]=="string"&&(o.length&&t.push(o.slice(0)),o.length=0),o.push(r[a]);return t.push(o.slice(0)),t},n.prototype.label=function(r,t,o,s,a,l,h,c,d){return new SVGLabel(this,r,t,o,s,a,l,h,c,d)},n.prototype.alignElements=function(){this.alignedObjects.forEach(function(r){return r.align()})},n}();extend$1m(SVGRenderer.prototype,{Element:SVGElement,SVG_NS,escapes:{"&":"&amp;","<":"&lt;",">":"&gt;","'":"&#39;",'"':"&quot;"},symbols:Symbols,draw:noop$k});RendererRegistry$1.registerRendererType("svg",SVGRenderer,!0);var __extends$X=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),isFirefox$2=H.isFirefox,isMS$1=H.isMS,isWebKit=H.isWebKit,win$b=H.win,css$a=Utilities.css,defined$P=Utilities.defined,extend$1l=Utilities.extend,pick$1r=Utilities.pick,pInt$5=Utilities.pInt,HTMLElement=function(n){__extends$X(r,n);function r(){return n!==null&&n.apply(this,arguments)||this}return r.compose=function(t){if(r.composedClasses.indexOf(t)===-1){r.composedClasses.push(t);var o=r.prototype,s=t.prototype;s.getSpanCorrection=o.getSpanCorrection,s.htmlCss=o.htmlCss,s.htmlGetBBox=o.htmlGetBBox,s.htmlUpdateTransform=o.htmlUpdateTransform,s.setSpanRotation=o.setSpanRotation}return t},r.prototype.getSpanCorrection=function(t,o,s){this.xCorr=-t*s,this.yCorr=-o},r.prototype.htmlCss=function(t){var o=this,s=o.element,a=s.tagName==="SPAN"&&t&&"width"in t,l=pick$1r(a&&t.width,void 0),h;return a&&(delete t.width,o.textWidth=l,h=!0),t&&t.textOverflow==="ellipsis"&&(t.whiteSpace="nowrap",t.overflow="hidden"),o.styles=extend$1l(o.styles,t),css$a(o.element,t),h&&o.htmlUpdateTransform(),o},r.prototype.htmlGetBBox=function(){var t=this,o=t.element;return{x:o.offsetLeft,y:o.offsetTop,width:o.offsetWidth,height:o.offsetHeight}},r.prototype.htmlUpdateTransform=function(){if(!this.added){this.alignOnAdd=!0;return}var t=this,o=t.renderer,s=t.element,a=t.translateX||0,l=t.translateY||0,h=t.x||0,c=t.y||0,d=t.textAlign||"left",p={left:0,center:.5,right:1}[d],u=t.styles,f=u&&u.whiteSpace;function g(){return css$a(s,{width:"",whiteSpace:f||"nowrap"}),s.offsetWidth}if(css$a(s,{marginLeft:a,marginTop:l}),!o.styledMode&&t.shadows&&t.shadows.forEach(function(b){css$a(b,{marginLeft:a+1,marginTop:l+1})}),t.inverted&&[].forEach.call(s.childNodes,function(b){o.invertChild(b,s)}),s.tagName==="SPAN"){var v=t.rotation,m=t.textWidth&&pInt$5(t.textWidth),x=[v,d,s.innerHTML,t.textWidth,t.textAlign].join(","),y=void 0;m!==t.oldTextWidth&&(m>t.oldTextWidth||(t.textPxLength||g())>m)&&(/[ \-]/.test(s.textContent||s.innerText)||s.style.textOverflow==="ellipsis")?(css$a(s,{width:m+"px",display:"block",whiteSpace:f||"normal"}),t.oldTextWidth=m,t.hasBoxWidthChanged=!0):t.hasBoxWidthChanged=!1,x!==t.cTT&&(y=o.fontMetrics(s.style.fontSize,s).b,defined$P(v)&&(v!==(t.oldRotation||0)||d!==t.oldAlign)&&t.setSpanRotation(v,p,y),t.getSpanCorrection(!defined$P(v)&&t.textPxLength||s.offsetWidth,y,p,v,d)),css$a(s,{left:h+(t.xCorr||0)+"px",top:c+(t.yCorr||0)+"px"}),t.cTT=x,t.oldRotation=v,t.oldAlign=d}},r.prototype.setSpanRotation=function(t,o,s){var a=function(){return isMS$1&&!/Edge/.test(win$b.navigator.userAgent)?"-ms-transform":isWebKit?"-webkit-transform":isFirefox$2?"MozTransform":win$b.opera?"-o-transform":void 0},l={},h=a();h&&(l[h]=l.transform="rotate("+t+"deg)",l[h+(isFirefox$2?"Origin":"-origin")]=l.transformOrigin=o*100+"% "+s+"px",css$a(this.element,l))},r.composedClasses=[],r}(SVGElement),__extends$W=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),attr$3=Utilities.attr,createElement$7=Utilities.createElement,extend$1k=Utilities.extend,pick$1q=Utilities.pick,HTMLRenderer=function(n){__extends$W(r,n);function r(){return n!==null&&n.apply(this,arguments)||this}return r.compose=function(t){if(r.composedClasses.indexOf(t)===-1){r.composedClasses.push(t);var o=r.prototype,s=t.prototype;s.html=o.html}return t},r.prototype.html=function(t,o,s){var a=this.createElement("span"),l=a.element,h=a.renderer,c=h.isSVG,d=function(p,u){["opacity","visibility"].forEach(function(f){p[f+"Setter"]=function(g,v,m){var x=p.div?p.div.style:u;SVGElement.prototype[f+"Setter"].call(this,g,v,m),x&&(x[v]=g)}}),p.addedSetters=!0};return a.textSetter=function(p){p!==this.textStr&&(delete this.bBox,delete this.oldTextWidth,AST.setElementHTML(this.element,pick$1q(p,"")),this.textStr=p,a.doTransform=!0)},c&&d(a,a.element.style),a.xSetter=a.ySetter=a.alignSetter=a.rotationSetter=function(p,u){u==="align"?a.alignValue=a.textAlign=p:a[u]=p,a.doTransform=!0},a.afterSetters=function(){this.doTransform&&(this.htmlUpdateTransform(),this.doTransform=!1)},a.attr({text:t,x:Math.round(o),y:Math.round(s)}).css({position:"absolute"}),h.styledMode||a.css({fontFamily:this.style.fontFamily,fontSize:this.style.fontSize}),l.style.whiteSpace="nowrap",a.css=a.htmlCss,c&&(a.add=function(p){var u=h.box.parentNode,f=[],g,v;if(this.parentGroup=p,p){if(g=p.div,!g){for(v=p;v;)f.push(v),v=v.parentGroup;f.reverse().forEach(function(m){var x=attr$3(m.element,"class");function y(S,k){m[k]=S,k==="translateX"?$.left=S+"px":$.top=S+"px",m.doTransform=!0}var b=m.styles||{};g=m.div=m.div||createElement$7("div",x?{className:x}:void 0,{position:"absolute",left:(m.translateX||0)+"px",top:(m.translateY||0)+"px",display:m.display,opacity:m.opacity,cursor:b.cursor,pointerEvents:b.pointerEvents,visibility:m.visibility},g||u);var $=g.style;extend$1k(m,{classSetter:function(S){return function(k){this.element.setAttribute("class",k),S.className=k}}(g),on:function(){return f[0].div&&a.on.apply({element:f[0].div,onEvents:m.onEvents},arguments),m},translateXSetter:y,translateYSetter:y}),m.addedSetters||d(m)})}}else g=u;return g.appendChild(l),a.added=!0,a.alignOnAdd&&a.htmlUpdateTransform(),a}),a},r.composedClasses=[],r}(SVGRenderer),AxisDefaults;(function(n){n.defaultXAxisOptions={alignTicks:!0,allowDecimals:void 0,panningEnabled:!0,zIndex:2,zoomEnabled:!0,dateTimeLabelFormats:{millisecond:{main:"%H:%M:%S.%L",range:!1},second:{main:"%H:%M:%S",range:!1},minute:{main:"%H:%M",range:!1},hour:{main:"%H:%M",range:!1},day:{main:"%e. %b"},week:{main:"%e. %b"},month:{main:"%b '%y"},year:{main:"%Y"}},endOnTick:!1,gridLineDashStyle:"Solid",gridZIndex:1,labels:{autoRotation:void 0,autoRotationLimit:80,distance:void 0,enabled:!0,indentation:10,overflow:"justify",padding:5,reserveSpace:void 0,rotation:void 0,staggerLines:0,step:0,useHTML:!1,x:0,zIndex:7,style:{color:palette.neutralColor60,cursor:"default",fontSize:"11px"}},maxPadding:.01,minorGridLineDashStyle:"Solid",minorTickLength:2,minorTickPosition:"outside",minPadding:.01,offset:void 0,opposite:!1,reversed:void 0,reversedStacks:!1,showEmpty:!0,showFirstLabel:!0,showLastLabel:!0,startOfWeek:1,startOnTick:!1,tickLength:10,tickPixelInterval:100,tickmarkPlacement:"between",tickPosition:"outside",title:{align:"middle",rotation:0,useHTML:!1,x:0,y:0,style:{color:palette.neutralColor60}},type:"linear",uniqueNames:!0,visible:!0,minorGridLineColor:palette.neutralColor5,minorGridLineWidth:1,minorTickColor:palette.neutralColor40,lineColor:palette.highlightColor20,lineWidth:1,gridLineColor:palette.neutralColor10,gridLineWidth:void 0,tickColor:palette.highlightColor20},n.defaultYAxisOptions={reversedStacks:!0,endOnTick:!0,maxPadding:.05,minPadding:.05,tickPixelInterval:72,showLastLabel:!0,labels:{x:-8},startOnTick:!0,title:{rotation:270,text:"Values"},stackLabels:{animation:{},allowOverlap:!1,enabled:!1,crop:!0,overflow:"justify",formatter:function(){var r=this.axis.chart.numberFormatter;return r(this.total,-1)},style:{color:palette.neutralColor100,fontSize:"11px",fontWeight:"bold",textOutline:"1px contrast"}},gridLineWidth:1,lineWidth:0},n.defaultLeftAxisOptions={labels:{x:-15},title:{rotation:270}},n.defaultRightAxisOptions={labels:{x:15},title:{rotation:90}},n.defaultBottomAxisOptions={labels:{autoRotation:[-45],x:0},margin:15,title:{rotation:0}},n.defaultTopAxisOptions={labels:{autoRotation:[-45],x:0},margin:15,title:{rotation:0}}})(AxisDefaults||(AxisDefaults={}));const AxisDefaults$1=AxisDefaults;var addEvent$$=Utilities.addEvent,isFunction$3=Utilities.isFunction,objectEach$u=Utilities.objectEach,removeEvent$a=Utilities.removeEvent,registerEventOptions$3=function(n,r){n.eventOptions=n.eventOptions||{},objectEach$u(r.events,function(t,o){n.eventOptions[o]!==t&&(n.eventOptions[o]&&(removeEvent$a(n,o,n.eventOptions[o]),delete n.eventOptions[o]),isFunction$3(t)&&(n.eventOptions[o]=t,addEvent$$(n,o,t)))})},exports$3={registerEventOptions:registerEventOptions$3},deg2rad$6=H.deg2rad,clamp$h=Utilities.clamp,correctFloat$c=Utilities.correctFloat,defined$O=Utilities.defined,destroyObjectProperties$8=Utilities.destroyObjectProperties,extend$1j=Utilities.extend,fireEvent$z=Utilities.fireEvent,isNumber$I=Utilities.isNumber,merge$1h=Utilities.merge,objectEach$t=Utilities.objectEach,pick$1p=Utilities.pick,Tick=function(){function n(r,t,o,s,a){this.isNew=!0,this.isNewLabel=!0,this.axis=r,this.pos=t,this.type=o||"",this.parameters=a||{},this.tickmarkOffset=this.parameters.tickmarkOffset,this.options=this.parameters.options,fireEvent$z(this,"init"),!o&&!s&&this.addLabel()}return n.prototype.addLabel=function(){var r=this,t=r.axis,o=t.options,s=t.chart,a=t.categories,l=t.logarithmic,h=t.names,c=r.pos,d=pick$1p(r.options&&r.options.labels,o.labels),p=t.tickPositions,u=c===p[0],f=c===p[p.length-1],g=(!d.step||d.step===1)&&t.tickInterval===1,v=p.info,m=r.label,x,y,b,$=this.parameters.category||(a?pick$1p(a[c],h[c],c):c);l&&isNumber$I($)&&($=correctFloat$c(l.lin2log($))),t.dateTime&&(v?(y=s.time.resolveDTLFormat(o.dateTimeLabelFormats[!o.grid&&v.higherRanks[c]||v.unitName]),x=y.main):isNumber$I($)&&(x=t.dateTime.getXDateFormat($,o.dateTimeLabelFormats||{}))),r.isFirst=u,r.isLast=f;var S={axis:t,chart:s,dateTimeLabelFormat:x,isFirst:u,isLast:f,pos:c,tick:r,tickPositionInfo:v,value:$};fireEvent$z(this,"labelFormat",S);var k=function(E){return d.formatter?d.formatter.call(E,E):d.format?(E.text=t.defaultLabelFormatter.call(E),FormatUtilities.format(d.format,E,s)):t.defaultLabelFormatter.call(E,E)},A=k.call(S,S),P=y&&y.list;P?r.shortenLabel=function(){for(b=0;b<P.length;b++)if(extend$1j(S,{dateTimeLabelFormat:P[b]}),m.attr({text:k.call(S,S)}),m.getBBox().width<t.getSlotWidth(r)-2*d.padding)return;m.attr({text:""})}:r.shortenLabel=void 0,g&&t._addedPlotLB&&r.moveLabel(A,d),!defined$O(m)&&!r.movedLabel?(r.label=m=r.createLabel({x:0,y:0},A,d),r.rotation=0):m&&m.textStr!==A&&!g&&(m.textWidth&&!d.style.width&&!m.styles.width&&m.css({width:null}),m.attr({text:A}),m.textPxLength=m.getBBox().width)},n.prototype.createLabel=function(r,t,o){var s=this.axis,a=s.chart,l=defined$O(t)&&o.enabled?a.renderer.text(t,r.x,r.y,o.useHTML).add(s.labelGroup):null;return l&&(a.styledMode||l.css(merge$1h(o.style)),l.textPxLength=l.getBBox().width),l},n.prototype.destroy=function(){destroyObjectProperties$8(this,this.axis)},n.prototype.getPosition=function(r,t,o,s){var a=this.axis,l=a.chart,h=s&&l.oldChartHeight||l.chartHeight,c={x:r?correctFloat$c(a.translate(t+o,null,null,s)+a.transB):a.left+a.offset+(a.opposite?(s&&l.oldChartWidth||l.chartWidth)-a.right-a.left:0),y:r?h-a.bottom+a.offset-(a.opposite?a.height:0):correctFloat$c(h-a.translate(t+o,null,null,s)-a.transB)};return c.y=clamp$h(c.y,-1e5,1e5),fireEvent$z(this,"afterGetPosition",{pos:c}),c},n.prototype.getLabelPosition=function(r,t,o,s,a,l,h,c){var d=this.axis,p=d.transA,u=d.isLinked&&d.linkedParent?d.linkedParent.reversed:d.reversed,f=d.staggerLines,g=d.tickRotCorr||{x:0,y:0},v=!s&&!d.reserveSpaceDefault?-d.labelOffset*(d.labelAlign==="center"?.5:1):0,m={},x=a.y,y;return defined$O(x)||(d.side===0?x=o.rotation?-8:-o.getBBox().height:d.side===2?x=g.y+8:x=Math.cos(o.rotation*deg2rad$6)*(g.y-o.getBBox(!1,0).height/2)),r=r+a.x+v+g.x-(l&&s?l*p*(u?-1:1):0),t=t+x-(l&&!s?l*p*(u?1:-1):0),f&&(y=h/(c||1)%f,d.opposite&&(y=f-y-1),t+=y*(d.labelOffset/f)),m.x=r,m.y=Math.round(t),fireEvent$z(this,"afterGetLabelPosition",{pos:m,tickmarkOffset:l,index:h}),m},n.prototype.getLabelSize=function(){return this.label?this.label.getBBox()[this.axis.horiz?"height":"width"]:0},n.prototype.getMarkPath=function(r,t,o,s,a,l){return l.crispLine([["M",r,t],["L",r+(a?0:-o),t+(a?o:0)]],s)},n.prototype.handleOverflow=function(r){var t=this,o=this.axis,s=o.options.labels,a=r.x,l=o.chart.chartWidth,h=o.chart.spacing,c=pick$1p(o.labelLeft,Math.min(o.pos,h[3])),d=pick$1p(o.labelRight,Math.max(o.isRadial?0:o.pos+o.len,l-h[1])),p=this.label,u=this.rotation,f={left:0,center:.5,right:1}[o.labelAlign||p.attr("align")],g=p.getBBox().width,v=o.getSlotWidth(t),m=f,x={},y=v,b=1,$,S,k;!u&&s.overflow==="justify"?($=a-f*g,S=a+(1-f)*g,$<c?y=r.x+y*(1-f)-c:S>d&&(y=d-r.x+y*f,b=-1),y=Math.min(v,y),y<v&&o.labelAlign==="center"&&(r.x+=b*(v-y-m*(v-Math.min(g,y)))),(g>y||o.autoRotation&&(p.styles||{}).width)&&(k=y)):u<0&&a-f*g<c?k=Math.round(a/Math.cos(u*deg2rad$6)-c):u>0&&a+f*g>d&&(k=Math.round((l-a)/Math.cos(u*deg2rad$6))),k&&(t.shortenLabel?t.shortenLabel():(x.width=Math.floor(k)+"px",(s.style||{}).textOverflow||(x.textOverflow="ellipsis"),p.css(x)))},n.prototype.moveLabel=function(r,t){var o=this,s=o.label,a=o.axis,l=a.reversed,h=!1,c,d,p;s&&s.textStr===r?(o.movedLabel=s,h=!0,delete o.label):objectEach$t(a.ticks,function(u){!h&&!u.isNew&&u!==o&&u.label&&u.label.textStr===r&&(o.movedLabel=u.label,h=!0,u.labelPos=o.movedLabel.xy,delete u.label)}),!h&&(o.labelPos||s)&&(c=o.labelPos||s.xy,d=a.horiz?l?0:a.width+a.left:c.x,p=a.horiz?c.y:l?a.width+a.left:0,o.movedLabel=o.createLabel({x:d,y:p},r,t),o.movedLabel&&o.movedLabel.attr({opacity:0}))},n.prototype.render=function(r,t,o){var s=this,a=s.axis,l=a.horiz,h=s.pos,c=pick$1p(s.tickmarkOffset,a.tickmarkOffset),d=s.getPosition(l,h,c,t),p=d.x,u=d.y,f=l&&p===a.pos+a.len||!l&&u===a.pos?-1:1,g=pick$1p(o,s.label&&s.label.newOpacity,1);o=pick$1p(o,1),this.isActive=!0,this.renderGridLine(t,o,f),this.renderMark(d,o,f),this.renderLabel(d,t,g,r),s.isNew=!1,fireEvent$z(this,"afterRender")},n.prototype.renderGridLine=function(r,t,o){var s=this,a=s.axis,l=a.options,h={},c=s.pos,d=s.type,p=pick$1p(s.tickmarkOffset,a.tickmarkOffset),u=a.chart.renderer,f=s.gridLine,g,v=l.gridLineWidth,m=l.gridLineColor,x=l.gridLineDashStyle;s.type==="minor"&&(v=l.minorGridLineWidth,m=l.minorGridLineColor,x=l.minorGridLineDashStyle),f||(a.chart.styledMode||(h.stroke=m,h["stroke-width"]=v||0,h.dashstyle=x),d||(h.zIndex=1),r&&(t=0),s.gridLine=f=u.path().attr(h).addClass("highcharts-"+(d?d+"-":"")+"grid-line").add(a.gridGroup)),f&&(g=a.getPlotLinePath({value:c+p,lineWidth:f.strokeWidth()*o,force:"pass",old:r}),g&&f[r||s.isNew?"attr":"animate"]({d:g,opacity:t}))},n.prototype.renderMark=function(r,t,o){var s=this,a=s.axis,l=a.options,h=a.chart.renderer,c=s.type,d=a.tickSize(c?c+"Tick":"tick"),p=r.x,u=r.y,f=pick$1p(l[c!=="minor"?"tickWidth":"minorTickWidth"],!c&&a.isXAxis?1:0),g=l[c!=="minor"?"tickColor":"minorTickColor"],v=s.mark,m=!v;d&&(a.opposite&&(d[0]=-d[0]),v||(s.mark=v=h.path().addClass("highcharts-"+(c?c+"-":"")+"tick").add(a.axisGroup),a.chart.styledMode||v.attr({stroke:g,"stroke-width":f})),v[m?"attr":"animate"]({d:s.getMarkPath(p,u,d[0],v.strokeWidth()*o,a.horiz,h),opacity:t}))},n.prototype.renderLabel=function(r,t,o,s){var a=this,l=a.axis,h=l.horiz,c=l.options,d=a.label,p=c.labels,u=p.step,f=pick$1p(a.tickmarkOffset,l.tickmarkOffset),g=r.x,v=r.y,m=!0;d&&isNumber$I(g)&&(d.xy=r=a.getLabelPosition(g,v,d,h,p,f,s,u),a.isFirst&&!a.isLast&&!c.showFirstLabel||a.isLast&&!a.isFirst&&!c.showLastLabel?m=!1:h&&!p.step&&!p.rotation&&!t&&o!==0&&a.handleOverflow(r),u&&s%u&&(m=!1),m&&isNumber$I(r.y)?(r.opacity=o,d[a.isNewLabel?"attr":"animate"](r),a.isNewLabel=!1):(d.attr("y",-9999),a.isNewLabel=!0))},n.prototype.replaceMovedLabel=function(){var r=this,t=r.label,o=r.axis,s=o.reversed,a,l;t&&!r.isNew&&(a=o.horiz?s?o.left:o.width+o.left:t.xy.x,l=o.horiz?t.xy.y:s?o.width+o.top:o.top,t.animate({x:a,y:l,opacity:0},void 0,t.destroy),delete r.label),o.isDirty=!0,r.label=r.movedLabel,delete r.movedLabel},n}(),animObject$a=animationExports.animObject,defaultOptions$d=DefaultOptions.defaultOptions,registerEventOptions$2=exports$3.registerEventOptions,deg2rad$5=H.deg2rad,arrayMax$9=Utilities.arrayMax,arrayMin$8=Utilities.arrayMin,clamp$g=Utilities.clamp,correctFloat$b=Utilities.correctFloat,defined$N=Utilities.defined,destroyObjectProperties$7=Utilities.destroyObjectProperties,erase$7=Utilities.erase,error$7=Utilities.error,extend$1i=Utilities.extend,fireEvent$y=Utilities.fireEvent,getMagnitude$2=Utilities.getMagnitude,isArray$j=Utilities.isArray,isNumber$H=Utilities.isNumber,isString$7=Utilities.isString,merge$1g=Utilities.merge,normalizeTickInterval$2=Utilities.normalizeTickInterval,objectEach$s=Utilities.objectEach,pick$1o=Utilities.pick,relativeLength$9=Utilities.relativeLength,removeEvent$9=Utilities.removeEvent,splat$g=Utilities.splat,syncTimeout$7=Utilities.syncTimeout,Axis=function(){function n(r,t){this.alternateBands=void 0,this.bottom=void 0,this.categories=void 0,this.chart=void 0,this.closestPointRange=void 0,this.coll=void 0,this.eventOptions=void 0,this.hasNames=void 0,this.hasVisibleSeries=void 0,this.height=void 0,this.isLinked=void 0,this.labelEdge=void 0,this.labelFormatter=void 0,this.left=void 0,this.len=void 0,this.max=void 0,this.maxLabelLength=void 0,this.min=void 0,this.minorTickInterval=void 0,this.minorTicks=void 0,this.minPixelPadding=void 0,this.names=void 0,this.offset=void 0,this.options=void 0,this.overlap=void 0,this.paddedTicks=void 0,this.plotLinesAndBands=void 0,this.plotLinesAndBandsGroups=void 0,this.pointRange=void 0,this.pointRangePadding=void 0,this.pos=void 0,this.positiveValuesOnly=void 0,this.right=void 0,this.series=void 0,this.side=void 0,this.tickAmount=void 0,this.tickInterval=void 0,this.tickmarkOffset=void 0,this.tickPositions=void 0,this.tickRotCorr=void 0,this.ticks=void 0,this.top=void 0,this.transA=void 0,this.transB=void 0,this.translationSlope=void 0,this.userOptions=void 0,this.visible=void 0,this.width=void 0,this.zoomEnabled=void 0,this.init(r,t)}return n.prototype.init=function(r,t){var o=t.isX,s=this;s.chart=r,s.horiz=r.inverted&&!s.isZAxis?!o:o,s.isXAxis=o,s.coll=s.coll||(o?"xAxis":"yAxis"),fireEvent$y(this,"init",{userOptions:t}),s.opposite=pick$1o(t.opposite,s.opposite),s.side=pick$1o(t.side,s.side,s.horiz?s.opposite?0:2:s.opposite?1:3),s.setOptions(t);var a=this.options,l=a.labels,h=a.type;s.userOptions=t,s.minPixelPadding=0,s.reversed=pick$1o(a.reversed,s.reversed),s.visible=a.visible,s.zoomEnabled=a.zoomEnabled,s.hasNames=h==="category"||a.categories===!0,s.categories=a.categories||s.hasNames,s.names||(s.names=[],s.names.keys={}),s.plotLinesAndBandsGroups={},s.positiveValuesOnly=!!s.logarithmic,s.isLinked=defined$N(a.linkedTo),s.ticks={},s.labelEdge=[],s.minorTicks={},s.plotLinesAndBands=[],s.alternateBands={},s.len=0,s.minRange=s.userMinRange=a.minRange||a.maxZoom,s.range=a.range,s.offset=a.offset||0,s.max=null,s.min=null;var c=pick$1o(a.crosshair,splat$g(r.options.tooltip.crosshairs)[o?0:1]);s.crosshair=c===!0?{}:c,r.axes.indexOf(s)===-1&&(o?r.axes.splice(r.xAxis.length,0,s):r.axes.push(s),r[s.coll].push(s)),s.series=s.series||[],r.inverted&&!s.isZAxis&&o&&typeof s.reversed>"u"&&(s.reversed=!0),s.labelRotation=isNumber$H(l.rotation)?l.rotation:void 0,registerEventOptions$2(s,a),fireEvent$y(this,"afterInit")},n.prototype.setOptions=function(r){this.options=merge$1g(AxisDefaults$1.defaultXAxisOptions,this.coll==="yAxis"&&AxisDefaults$1.defaultYAxisOptions,[AxisDefaults$1.defaultTopAxisOptions,AxisDefaults$1.defaultRightAxisOptions,AxisDefaults$1.defaultBottomAxisOptions,AxisDefaults$1.defaultLeftAxisOptions][this.side],merge$1g(defaultOptions$d[this.coll],r)),fireEvent$y(this,"afterSetOptions",{userOptions:r})},n.prototype.defaultLabelFormatter=function(r){var t=this.axis,o=this.chart,s=o.numberFormatter,a=isNumber$H(this.value)?this.value:NaN,l=t.chart.time,h=t.categories,c=this.dateTimeLabelFormat,d=defaultOptions$d.lang,p=d.numericSymbols,u=d.numericSymbolMagnitude||1e3,f=t.logarithmic?Math.abs(a):t.tickInterval,g=p&&p.length,v,m;if(h)m=""+this.value;else if(c)m=l.dateFormat(c,a);else if(g&&f>=1e3)for(;g--&&typeof m>"u";)v=Math.pow(u,g+1),f>=v&&a*10%v===0&&p[g]!==null&&a!==0&&(m=s(a/v,-1)+p[g]);return typeof m>"u"&&(Math.abs(a)>=1e4?m=s(a,-1):m=s(a,-1,void 0,"")),m},n.prototype.getSeriesExtremes=function(){var r=this,t=r.chart,o;fireEvent$y(this,"getSeriesExtremes",null,function(){r.hasVisibleSeries=!1,r.dataMin=r.dataMax=r.threshold=null,r.softThreshold=!r.isXAxis,r.stacking&&r.stacking.buildStacks(),r.series.forEach(function(s){if(s.visible||!t.options.chart.ignoreHiddenSeries){var a=s.options,l=void 0,h=a.threshold,c=void 0,d=void 0;if(r.hasVisibleSeries=!0,r.positiveValuesOnly&&h<=0&&(h=null),r.isXAxis)l=s.xData,l.length&&(l=r.logarithmic?l.filter(r.validatePositiveValue):l,o=s.getXExtremes(l),c=o.min,d=o.max,!isNumber$H(c)&&!(c instanceof Date)&&(l=l.filter(isNumber$H),o=s.getXExtremes(l),c=o.min,d=o.max),l.length&&(r.dataMin=Math.min(pick$1o(r.dataMin,c),c),r.dataMax=Math.max(pick$1o(r.dataMax,d),d)));else{var p=s.applyExtremes();isNumber$H(p.dataMin)&&(c=p.dataMin,r.dataMin=Math.min(pick$1o(r.dataMin,c),c)),isNumber$H(p.dataMax)&&(d=p.dataMax,r.dataMax=Math.max(pick$1o(r.dataMax,d),d)),defined$N(h)&&(r.threshold=h),(!a.softThreshold||r.positiveValuesOnly)&&(r.softThreshold=!1)}}})}),fireEvent$y(this,"afterGetSeriesExtremes")},n.prototype.translate=function(r,t,o,s,a,l){var h=this.linkedParent||this,c=s&&h.old?h.old.min:h.min,d=h.minPixelPadding,p=(h.isOrdinal||h.brokenAxis&&h.brokenAxis.hasBreaks||h.logarithmic&&a)&&h.lin2val,u=1,f=0,g=s&&h.old?h.old.transA:h.transA,v=0;return g||(g=h.transA),o&&(u*=-1,f=h.len),h.reversed&&(u*=-1,f-=u*(h.sector||h.len)),t?(r=r*u+f,r-=d,v=r/g+c,p&&(v=h.lin2val(v))):(p&&(r=h.val2lin(r)),v=isNumber$H(c)?u*(r-c)*g+f+u*d+(isNumber$H(l)?g*l:0):void 0),v},n.prototype.toPixels=function(r,t){return this.translate(r,!1,!this.horiz,null,!0)+(t?0:this.pos)},n.prototype.toValue=function(r,t){return this.translate(r-(t?0:this.pos),!0,!this.horiz,null,!0)},n.prototype.getPlotLinePath=function(r){var t=this,o=t.chart,s=t.left,a=t.top,l=r.old,h=r.value,c=r.lineWidth,d=l&&o.oldChartHeight||o.chartHeight,p=l&&o.oldChartWidth||o.chartWidth,u=t.transB,f=r.translatedValue,g=r.force,v,m,x,y,b;function $(k,A,P){return(g!=="pass"&&k<A||k>P)&&(g?k=clamp$g(k,A,P):b=!0),k}var S={value:h,lineWidth:c,old:l,force:g,acrossPanes:r.acrossPanes,translatedValue:f};return fireEvent$y(this,"getPlotLinePath",S,function(k){f=pick$1o(f,t.translate(h,null,null,l)),f=clamp$g(f,-1e5,1e5),v=x=Math.round(f+u),m=y=Math.round(d-f-u),isNumber$H(f)?t.horiz?(m=a,y=d-t.bottom,v=x=$(v,s,s+t.width)):(v=s,x=p-t.right,m=y=$(m,a,a+t.height)):(b=!0,g=!1),k.path=b&&!g?null:o.renderer.crispLine([["M",v,m],["L",x,y]],c||1)}),S.path},n.prototype.getLinearTickPositions=function(r,t,o){var s=correctFloat$b(Math.floor(t/r)*r),a=correctFloat$b(Math.ceil(o/r)*r),l=[],h,c,d;if(correctFloat$b(s+r)===s&&(d=20),this.single)return[t];for(h=s;h<=a&&(l.push(h),h=correctFloat$b(h+r,d),h!==c);)c=h;return l},n.prototype.getMinorTickInterval=function(){var r=this.options;return r.minorTicks===!0?pick$1o(r.minorTickInterval,"auto"):r.minorTicks===!1?null:r.minorTickInterval},n.prototype.getMinorTickPositions=function(){var r=this,t=r.options,o=r.tickPositions,s=r.minorTickInterval,a=r.pointRangePadding||0,l=r.min-a,h=r.max+a,c=h-l,d=[],p;if(c&&c/s<r.len/3){var u=r.logarithmic;if(u)this.paddedTicks.forEach(function(f,g,v){g&&d.push.apply(d,u.getLogTickPositions(s,v[g-1],v[g],!0))});else if(r.dateTime&&this.getMinorTickInterval()==="auto")d=d.concat(r.getTimeTicks(r.dateTime.normalizeTimeTickInterval(s),l,h,t.startOfWeek));else for(p=l+(o[0]-l)%s;p<=h&&p!==d[0];p+=s)d.push(p)}return d.length!==0&&r.trimTicks(d),d},n.prototype.adjustForMinRange=function(){var r=this,t=r.options,o=r.logarithmic,s=r.min,a=r.max,l,h,c=0,d,p,u,f,g,v,m;r.isXAxis&&typeof r.minRange>"u"&&!o&&(defined$N(t.min)||defined$N(t.max)?r.minRange=null:(r.series.forEach(function(x){if(u=x.xData,f=x.xIncrement?1:u.length-1,u.length>1)for(d=f;d>0;d--)p=u[d]-u[d-1],(!c||p<c)&&(c=p)}),r.minRange=Math.min(c*5,r.dataMax-r.dataMin))),a-s<r.minRange&&(h=r.dataMax-r.dataMin>=r.minRange,m=r.minRange,l=(m-a+s)/2,g=[s-l,pick$1o(t.min,s-l)],h&&(g[2]=r.logarithmic?r.logarithmic.log2lin(r.dataMin):r.dataMin),s=arrayMax$9(g),v=[s+m,pick$1o(t.max,s+m)],h&&(v[2]=o?o.log2lin(r.dataMax):r.dataMax),a=arrayMin$8(v),a-s<m&&(g[0]=a-m,g[1]=pick$1o(t.min,a-m),s=arrayMax$9(g))),r.min=s,r.max=a},n.prototype.getClosest=function(){var r;return this.categories?r=1:this.series.forEach(function(t){var o=t.closestPointRange,s=t.visible||!t.chart.options.chart.ignoreHiddenSeries;!t.noSharedTooltip&&defined$N(o)&&s&&(r=defined$N(r)?Math.min(r,o):o)}),r},n.prototype.nameToX=function(r){var t=isArray$j(this.categories),o=t?this.categories:this.names,s=r.options.x,a;return r.series.requireSorting=!1,defined$N(s)||(s=this.options.uniqueNames?t?o.indexOf(r.name):pick$1o(o.keys[r.name],-1):r.series.autoIncrement()),s===-1?t||(a=o.length):a=s,typeof a<"u"&&(this.names[a]=r.name,this.names.keys[r.name]=a),a},n.prototype.updateNames=function(){var r=this,t=this.names,o=t.length;o>0&&(Object.keys(t.keys).forEach(function(s){delete t.keys[s]}),t.length=0,this.minRange=this.userMinRange,(this.series||[]).forEach(function(s){s.xIncrement=null,(!s.points||s.isDirtyData)&&(r.max=Math.max(r.max,s.xData.length-1),s.processData(),s.generatePoints()),s.data.forEach(function(a,l){var h;a&&a.options&&typeof a.name<"u"&&(h=r.nameToX(a),typeof h<"u"&&h!==a.x&&(a.x=h,s.xData[l]=h))})}))},n.prototype.setAxisTranslation=function(){var r=this,t=r.max-r.min,o=r.linkedParent,s=!!r.categories,a=r.isXAxis,l=r.axisPointRange||0,h,c=0,d=0,p,u=r.transA;(a||s||l)&&(h=r.getClosest(),o?(c=o.minPointOffset,d=o.pointRangePadding):r.series.forEach(function(f){var g=s?1:a?pick$1o(f.options.pointRange,h,0):r.axisPointRange||0,v=f.options.pointPlacement;if(l=Math.max(l,g),!r.single||s){var m=f.is("xrange")?!a:a;c=Math.max(c,m&&isString$7(v)?0:g/2),d=Math.max(d,m&&v==="on"?0:g)}}),p=r.ordinal&&r.ordinal.slope&&h?r.ordinal.slope/h:1,r.minPointOffset=c=c*p,r.pointRangePadding=d=d*p,r.pointRange=Math.min(l,r.single&&s?1:t),a&&(r.closestPointRange=h)),r.translationSlope=r.transA=u=r.staticScale||r.len/(t+d||1),r.transB=r.horiz?r.left:r.bottom,r.minPixelPadding=u*c,fireEvent$y(this,"afterSetAxisTranslation")},n.prototype.minFromRange=function(){var r=this;return r.max-r.range},n.prototype.setTickInterval=function(r){var t=this,o=t.chart,s=t.logarithmic,a=t.options,l=t.isXAxis,h=t.isLinked,c=a.tickPixelInterval,d=t.categories,p=t.softThreshold,u=a.maxPadding,f=a.minPadding,g,v,m=a.tickInterval,x=isNumber$H(t.threshold)?t.threshold:null,y,b,$,S;!t.dateTime&&!d&&!h&&this.getTickAmount(),$=pick$1o(t.userMin,a.min),S=pick$1o(t.userMax,a.max),h?(t.linkedParent=o[t.coll][a.linkedTo],v=t.linkedParent.getExtremes(),t.min=pick$1o(v.min,v.dataMin),t.max=pick$1o(v.max,v.dataMax),a.type!==t.linkedParent.options.type&&error$7(11,1,o)):(p&&defined$N(x)&&(t.dataMin>=x?(y=x,f=0):t.dataMax<=x&&(b=x,u=0)),t.min=pick$1o($,y,t.dataMin),t.max=pick$1o(S,b,t.dataMax)),s&&(t.positiveValuesOnly&&!r&&Math.min(t.min,pick$1o(t.dataMin,t.min))<=0&&error$7(10,1,o),t.min=correctFloat$b(s.log2lin(t.min),16),t.max=correctFloat$b(s.log2lin(t.max),16)),t.range&&defined$N(t.max)&&(t.userMin=t.min=$=Math.max(t.dataMin,t.minFromRange()),t.userMax=S=t.max,t.range=null),fireEvent$y(t,"foundExtremes"),t.beforePadding&&t.beforePadding(),t.adjustForMinRange(),!d&&!t.axisPointRange&&!(t.stacking&&t.stacking.usePercentage)&&!h&&defined$N(t.min)&&defined$N(t.max)&&(g=t.max-t.min,g&&(!defined$N($)&&f&&(t.min-=g*f),!defined$N(S)&&u&&(t.max+=g*u))),isNumber$H(t.userMin)||(isNumber$H(a.softMin)&&a.softMin<t.min&&(t.min=$=a.softMin),isNumber$H(a.floor)&&(t.min=Math.max(t.min,a.floor))),isNumber$H(t.userMax)||(isNumber$H(a.softMax)&&a.softMax>t.max&&(t.max=S=a.softMax),isNumber$H(a.ceiling)&&(t.max=Math.min(t.max,a.ceiling))),p&&defined$N(t.dataMin)&&(x=x||0,!defined$N($)&&t.min<x&&t.dataMin>=x?t.min=t.options.minRange?Math.min(x,t.max-t.minRange):x:!defined$N(S)&&t.max>x&&t.dataMax<=x&&(t.max=t.options.minRange?Math.max(x,t.min+t.minRange):x)),isNumber$H(t.min)&&isNumber$H(t.max)&&!this.chart.polar&&t.min>t.max&&(defined$N(t.options.min)?t.max=t.min:defined$N(t.options.max)&&(t.min=t.max)),t.min===t.max||typeof t.min>"u"||typeof t.max>"u"?t.tickInterval=1:h&&t.linkedParent&&!m&&c===t.linkedParent.options.tickPixelInterval?t.tickInterval=m=t.linkedParent.tickInterval:t.tickInterval=pick$1o(m,this.tickAmount?(t.max-t.min)/Math.max(this.tickAmount-1,1):void 0,d?1:(t.max-t.min)*c/Math.max(t.len,c)),l&&!r&&(t.series.forEach(function(A){A.forceCrop=A.forceCropping&&A.forceCropping(),A.processData(t.min!==(t.old&&t.old.min)||t.max!==(t.old&&t.old.max))}),fireEvent$y(this,"postProcessData")),t.setAxisTranslation(),fireEvent$y(this,"initialAxisTranslation"),t.pointRange&&!m&&(t.tickInterval=Math.max(t.pointRange,t.tickInterval));var k=pick$1o(a.minTickInterval,t.dateTime&&!t.series.some(function(A){return A.noSharedTooltip})?t.closestPointRange:0);!m&&t.tickInterval<k&&(t.tickInterval=k),!t.dateTime&&!t.logarithmic&&!m&&(t.tickInterval=normalizeTickInterval$2(t.tickInterval,void 0,getMagnitude$2(t.tickInterval),pick$1o(a.allowDecimals,t.tickInterval<.5||this.tickAmount!==void 0),!!this.tickAmount)),this.tickAmount||(t.tickInterval=t.unsquish()),this.setTickPositions()},n.prototype.setTickPositions=function(){var r=this,t=this.options,o=t.tickPositions,s=this.getMinorTickInterval(),a=this.hasVerticalPanning(),l=this.coll==="colorAxis",h=(l||!a)&&t.startOnTick,c=(l||!a)&&t.endOnTick,d,p=t.tickPositioner;this.tickmarkOffset=this.categories&&t.tickmarkPlacement==="between"&&this.tickInterval===1?.5:0,this.minorTickInterval=s==="auto"&&this.tickInterval?this.tickInterval/5:s,this.single=this.min===this.max&&defined$N(this.min)&&!this.tickAmount&&(parseInt(this.min,10)===this.min||t.allowDecimals!==!1),this.tickPositions=d=o&&o.slice(),d||((!r.ordinal||!r.ordinal.positions)&&(this.max-this.min)/this.tickInterval>Math.max(2*this.len,200)?(d=[this.min,this.max],error$7(19,!1,this.chart)):r.dateTime?d=r.getTimeTicks(r.dateTime.normalizeTimeTickInterval(this.tickInterval,t.units),this.min,this.max,t.startOfWeek,r.ordinal&&r.ordinal.positions,this.closestPointRange,!0):r.logarithmic?d=r.logarithmic.getLogTickPositions(this.tickInterval,this.min,this.max):d=this.getLinearTickPositions(this.tickInterval,this.min,this.max),d.length>this.len&&(d=[d[0],d.pop()],d[0]===d[1]&&(d.length=1)),this.tickPositions=d,p&&(p=p.apply(r,[this.min,this.max]),p&&(this.tickPositions=d=p))),this.paddedTicks=d.slice(0),this.trimTicks(d,h,c),this.isLinked||(this.single&&d.length<2&&!this.categories&&!this.series.some(function(u){return u.is("heatmap")&&u.options.pointPlacement==="between"})&&(this.min-=.5,this.max+=.5),!o&&!p&&this.adjustTickAmount()),fireEvent$y(this,"afterSetTickPositions")},n.prototype.trimTicks=function(r,t,o){var s=r[0],a=r[r.length-1],l=!this.isOrdinal&&this.minPointOffset||0;if(fireEvent$y(this,"trimTicks"),!this.isLinked){if(t&&s!==-1/0)this.min=s;else for(;this.min-l>r[0];)r.shift();if(o)this.max=a;else for(;this.max+l<r[r.length-1];)r.pop();r.length===0&&defined$N(s)&&!this.options.tickPositions&&r.push((a+s)/2)}},n.prototype.alignToOthers=function(){var r=this,t={},o=r.options,s;return this.chart.options.chart.alignTicks!==!1&&o.alignTicks&&o.startOnTick!==!1&&o.endOnTick!==!1&&!r.logarithmic&&this.chart[this.coll].forEach(function(a){var l=a.options,h=a.horiz,c=[h?l.left:l.top,l.width,l.height,l.pane].join(",");a.series.length&&(t[c]?s=!0:t[c]=1)}),s},n.prototype.getTickAmount=function(){var r=this,t=this.options,o=t.tickPixelInterval,s=t.tickAmount;!defined$N(t.tickInterval)&&!s&&this.len<o&&!this.isRadial&&!r.logarithmic&&t.startOnTick&&t.endOnTick&&(s=2),!s&&this.alignToOthers()&&(s=Math.ceil(this.len/o)+1),s<4&&(this.finalTickAmt=s,s=5),this.tickAmount=s},n.prototype.adjustTickAmount=function(){var r=this,t=r.options,o=r.tickInterval,s=r.tickPositions,a=r.tickAmount,l=r.finalTickAmt,h=s&&s.length,c=pick$1o(r.threshold,r.softThreshold?0:null),d,p;if(r.hasData()&&isNumber$H(r.min)&&isNumber$H(r.max)){if(h<a){for(;s.length<a;)s.length%2||r.min===c?s.push(correctFloat$b(s[s.length-1]+o)):s.unshift(correctFloat$b(s[0]-o));r.transA*=(h-1)/(a-1),r.min=t.startOnTick?s[0]:Math.min(r.min,s[0]),r.max=t.endOnTick?s[s.length-1]:Math.max(r.max,s[s.length-1])}else h>a&&(r.tickInterval*=2,r.setTickPositions());if(defined$N(l)){for(p=d=s.length;p--;)(l===3&&p%2===1||l<=2&&p>0&&p<d-1)&&s.splice(p,1);r.finalTickAmt=void 0}}},n.prototype.setScale=function(){var r=this,t=!1,o=!1;r.series.forEach(function(a){t=t||a.isDirtyData||a.isDirty,o=o||a.xAxis&&a.xAxis.isDirty||!1}),r.setAxisSize();var s=r.len!==(r.old&&r.old.len);s||t||o||r.isLinked||r.forceRedraw||r.userMin!==(r.old&&r.old.userMin)||r.userMax!==(r.old&&r.old.userMax)||r.alignToOthers()?(r.stacking&&r.stacking.resetStacks(),r.forceRedraw=!1,r.getSeriesExtremes(),r.setTickInterval(),r.isDirty||(r.isDirty=s||r.min!==(r.old&&r.old.min)||r.max!==(r.old&&r.old.max))):r.stacking&&r.stacking.cleanStacks(),t&&r.panningState&&(r.panningState.isDirty=!0),fireEvent$y(this,"afterSetScale")},n.prototype.setExtremes=function(r,t,o,s,a){var l=this,h=l.chart;o=pick$1o(o,!0),l.series.forEach(function(c){delete c.kdTree}),a=extend$1i(a,{min:r,max:t}),fireEvent$y(l,"setExtremes",a,function(){l.userMin=r,l.userMax=t,l.eventArgs=a,o&&h.redraw(s)})},n.prototype.zoom=function(r,t){var o=this,s=this.dataMin,a=this.dataMax,l=this.options,h=Math.min(s,pick$1o(l.min,s)),c=Math.max(a,pick$1o(l.max,a)),d={newMin:r,newMax:t};return fireEvent$y(this,"zoom",d,function(p){var u=p.newMin,f=p.newMax;(u!==o.min||f!==o.max)&&(o.allowZoomOutside||(defined$N(s)&&(u<h&&(u=h),u>c&&(u=c)),defined$N(a)&&(f<h&&(f=h),f>c&&(f=c))),o.displayBtn=typeof u<"u"||typeof f<"u",o.setExtremes(u,f,!1,void 0,{trigger:"zoom"})),p.zoomed=!0}),d.zoomed},n.prototype.setAxisSize=function(){var r=this.chart,t=this.options,o=t.offsets||[0,0,0,0],s=this.horiz,a=this.width=Math.round(relativeLength$9(pick$1o(t.width,r.plotWidth-o[3]+o[1]),r.plotWidth)),l=this.height=Math.round(relativeLength$9(pick$1o(t.height,r.plotHeight-o[0]+o[2]),r.plotHeight)),h=this.top=Math.round(relativeLength$9(pick$1o(t.top,r.plotTop+o[0]),r.plotHeight,r.plotTop)),c=this.left=Math.round(relativeLength$9(pick$1o(t.left,r.plotLeft+o[3]),r.plotWidth,r.plotLeft));this.bottom=r.chartHeight-l-h,this.right=r.chartWidth-a-c,this.len=Math.max(s?a:l,0),this.pos=s?c:h},n.prototype.getExtremes=function(){var r=this,t=r.logarithmic;return{min:t?correctFloat$b(t.lin2log(r.min)):r.min,max:t?correctFloat$b(t.lin2log(r.max)):r.max,dataMin:r.dataMin,dataMax:r.dataMax,userMin:r.userMin,userMax:r.userMax}},n.prototype.getThreshold=function(r){var t=this,o=t.logarithmic,s=o?o.lin2log(t.min):t.min,a=o?o.lin2log(t.max):t.max;return r===null||r===-1/0?r=s:r===1/0?r=a:s>r?r=s:a<r&&(r=a),t.translate(r,0,1,0,1)},n.prototype.autoLabelAlign=function(r){var t=(pick$1o(r,0)-this.side*90+720)%360,o={align:"center"};return fireEvent$y(this,"autoLabelAlign",o,function(s){t>15&&t<165?s.align="right":t>195&&t<345&&(s.align="left")}),o.align},n.prototype.tickSize=function(r){var t=this.options,o=pick$1o(t[r==="tick"?"tickWidth":"minorTickWidth"],r==="tick"&&this.isXAxis&&!this.categories?1:0),s=t[r==="tick"?"tickLength":"minorTickLength"],a;o&&s&&(t[r+"Position"]==="inside"&&(s=-s),a=[s,o]);var l={tickSize:a};return fireEvent$y(this,"afterTickSize",l),l.tickSize},n.prototype.labelMetrics=function(){var r=this.tickPositions&&this.tickPositions[0]||0;return this.chart.renderer.fontMetrics(this.options.labels.style.fontSize,this.ticks[r]&&this.ticks[r].label)},n.prototype.unsquish=function(){var r=this.options.labels,t=this.horiz,o=this.tickInterval,s=this.len/(((this.categories?1:0)+this.max-this.min)/o),a=r.rotation,l=this.labelMetrics(),h=Math.max(this.max-this.min,0),c=function(v){var m=v/(s||1);return m=m>1?Math.ceil(m):1,m*o>h&&v!==1/0&&s!==1/0&&h&&(m=Math.ceil(h/o)),correctFloat$b(m*o)},d=o,p,u,f=Number.MAX_VALUE,g;return t?(!r.staggerLines&&!r.step&&(isNumber$H(a)?g=[a]:s<r.autoRotationLimit&&(g=r.autoRotation)),g&&g.forEach(function(v){var m;(v===a||v&&v>=-90&&v<=90)&&(u=c(Math.abs(l.h/Math.sin(deg2rad$5*v))),m=u+Math.abs(v/360),m<f&&(f=m,p=v,d=u))})):r.step||(d=c(l.h)),this.autoRotation=g,this.labelRotation=pick$1o(p,isNumber$H(a)?a:0),d},n.prototype.getSlotWidth=function(r){var t=this.chart,o=this.horiz,s=this.options.labels,a=Math.max(this.tickPositions.length-(this.categories?0:1),1),l=t.margin[3];if(r&&isNumber$H(r.slotWidth))return r.slotWidth;if(o&&s.step<2)return s.rotation?0:(this.staggerLines||1)*this.len/a;if(!o){var h=s.style.width;if(h!==void 0)return parseInt(String(h),10);if(l)return l-t.spacing[3]}return t.chartWidth*.33},n.prototype.renderUnsquish=function(){var r=this.chart,t=r.renderer,o=this.tickPositions,s=this.ticks,a=this.options.labels,l=a.style,h=this.horiz,c=this.getSlotWidth(),d=Math.max(1,Math.round(c-2*a.padding)),p={},u=this.labelMetrics(),f=l.textOverflow,g,v,m=0,x,y,b;if(isString$7(a.rotation)||(p.rotation=a.rotation||0),o.forEach(function($){var S=s[$];S.movedLabel&&S.replaceMovedLabel(),S&&S.label&&S.label.textPxLength>m&&(m=S.label.textPxLength)}),this.maxLabelLength=m,this.autoRotation)m>d&&m>u.h?p.rotation=this.labelRotation:this.labelRotation=0;else if(c&&(g=d,!f))for(v="clip",y=o.length;!h&&y--;)b=o[y],x=s[b].label,x&&(x.styles&&x.styles.textOverflow==="ellipsis"?x.css({textOverflow:"clip"}):x.textPxLength>c&&x.css({width:c+"px"}),x.getBBox().height>this.len/o.length-(u.h-u.f)&&(x.specificTextOverflow="ellipsis"));p.rotation&&(g=m>r.chartHeight*.5?r.chartHeight*.33:m,f||(v="ellipsis")),this.labelAlign=a.align||this.autoLabelAlign(this.labelRotation),this.labelAlign&&(p.align=this.labelAlign),o.forEach(function($){var S=s[$],k=S&&S.label,A=l.width,P={};k&&(k.attr(p),S.shortenLabel?S.shortenLabel():g&&!A&&l.whiteSpace!=="nowrap"&&(g<k.textPxLength||k.element.tagName==="SPAN")?(P.width=g+"px",f||(P.textOverflow=k.specificTextOverflow||v),k.css(P)):k.styles&&k.styles.width&&!P.width&&!A&&k.css({width:null}),delete k.specificTextOverflow,S.rotation=p.rotation)},this),this.tickRotCorr=t.rotCorr(u.b,this.labelRotation||0,this.side!==0)},n.prototype.hasData=function(){return this.series.some(function(r){return r.hasData()})||this.options.showEmpty&&defined$N(this.min)&&defined$N(this.max)},n.prototype.addTitle=function(r){var t=this,o=t.chart.renderer,s=t.horiz,a=t.opposite,l=t.options,h=l.title,c=t.chart.styledMode,d;t.axisTitle||(d=h.textAlign,d||(d=(s?{low:"left",middle:"center",high:"right"}:{low:a?"right":"left",middle:"center",high:a?"left":"right"})[h.align]),t.axisTitle=o.text(h.text||"",0,0,h.useHTML).attr({zIndex:7,rotation:h.rotation,align:d}).addClass("highcharts-axis-title"),c||t.axisTitle.css(merge$1g(h.style)),t.axisTitle.add(t.axisGroup),t.axisTitle.isNew=!0),!c&&!h.style.width&&!t.isRadial&&t.axisTitle.css({width:t.len+"px"}),t.axisTitle[r?"show":"hide"](r)},n.prototype.generateTick=function(r){var t=this,o=t.ticks;o[r]?o[r].addLabel():o[r]=new Tick(t,r)},n.prototype.getOffset=function(){var r=this,t=this,o=t.chart,s=o.renderer,a=t.options,l=t.tickPositions,h=t.ticks,c=t.horiz,d=t.side,p=o.inverted&&!t.isZAxis?[1,0,3,2][d]:d,u=t.hasData(),f=a.title,g=a.labels,v=o.axisOffset,m=o.clipOffset,x=[-1,1,1,-1][d],y=a.className,b=t.axisParent,$,S=0,k,A=0,P=0,E,M;if(t.showAxis=$=u||a.showEmpty,t.staggerLines=t.horiz&&g.staggerLines||void 0,!t.axisGroup){var T=function(C,U,D){return s.g(C).attr({zIndex:D}).addClass("highcharts-"+r.coll.toLowerCase()+U+" "+(r.isRadial?"highcharts-radial-axis"+U+" ":"")+(y||"")).add(b)};t.gridGroup=T("grid","-grid",a.gridZIndex),t.axisGroup=T("axis","",a.zIndex),t.labelGroup=T("axis-labels","-labels",g.zIndex)}u||t.isLinked?(l.forEach(function(C){t.generateTick(C)}),t.renderUnsquish(),t.reserveSpaceDefault=d===0||d===2||{1:"left",3:"right"}[d]===t.labelAlign,pick$1o(g.reserveSpace,t.labelAlign==="center"?!0:null,t.reserveSpaceDefault)&&l.forEach(function(C){P=Math.max(h[C].getLabelSize(),P)}),t.staggerLines&&(P*=t.staggerLines),t.labelOffset=P*(t.opposite?-1:1)):objectEach$s(h,function(C,U){C.destroy(),delete h[U]}),f&&f.text&&f.enabled!==!1&&(t.addTitle($),$&&f.reserveSpace!==!1&&(t.titleOffset=S=t.axisTitle.getBBox()[c?"height":"width"],k=f.offset,A=defined$N(k)?0:pick$1o(f.margin,c?5:10))),t.renderLine(),t.offset=x*pick$1o(a.offset,v[d]?v[d]+(a.margin||0):0),t.tickRotCorr=t.tickRotCorr||{x:0,y:0},d===0?M=-t.labelMetrics().h:d===2?M=t.tickRotCorr.y:M=0,E=Math.abs(P)+A,P&&(E-=M,E+=x*(c?pick$1o(g.y,t.tickRotCorr.y+x*8):g.x)),t.axisTitleMargin=pick$1o(k,E),t.getMaxLabelDimensions&&(t.maxLabelDimensions=t.getMaxLabelDimensions(h,l));var O=this.tickSize("tick");v[d]=Math.max(v[d],(t.axisTitleMargin||0)+S+x*t.offset,E,l&&l.length&&O?O[0]+x*t.offset:0);var L=a.offset?0:Math.floor(t.axisLine.strokeWidth()/2)*2;m[p]=Math.max(m[p],L),fireEvent$y(this,"afterGetOffset")},n.prototype.getLinePath=function(r){var t=this.chart,o=this.opposite,s=this.offset,a=this.horiz,l=this.left+(o?this.width:0)+s,h=t.chartHeight-this.bottom-(o?this.height:0)+s;return o&&(r*=-1),t.renderer.crispLine([["M",a?this.left:l,a?h:this.top],["L",a?t.chartWidth-this.right:l,a?h:t.chartHeight-this.bottom]],r)},n.prototype.renderLine=function(){this.axisLine||(this.axisLine=this.chart.renderer.path().addClass("highcharts-axis-line").add(this.axisGroup),this.chart.styledMode||this.axisLine.attr({stroke:this.options.lineColor,"stroke-width":this.options.lineWidth,zIndex:7}))},n.prototype.getTitlePosition=function(){var r=this.horiz,t=this.left,o=this.top,s=this.len,a=this.options.title,l=r?t:o,h=this.opposite,c=this.offset,d=a.x,p=a.y,u=this.axisTitle,f=this.chart.renderer.fontMetrics(a.style.fontSize,u),g=Math.max(u.getBBox(null,0).height-f.h-1,0),v={low:l+(r?0:s),middle:l+s/2,high:l+(r?s:0)}[a.align],m=(r?o+this.height:t)+(r?1:-1)*(h?-1:1)*this.axisTitleMargin+[-g,g,f.f,-g][this.side],x={x:r?v+d:m+(h?this.width:0)+c+d,y:r?m+p-(h?this.height:0)+c:v+p};return fireEvent$y(this,"afterGetTitlePosition",{titlePosition:x}),x},n.prototype.renderMinorTick=function(r,t){var o=this,s=o.minorTicks;s[r]||(s[r]=new Tick(o,r,"minor")),t&&s[r].isNew&&s[r].render(null,!0),s[r].render(null,!1,1)},n.prototype.renderTick=function(r,t,o){var s=this,a=s.isLinked,l=s.ticks;(!a||r>=s.min&&r<=s.max||s.grid&&s.grid.isColumn)&&(l[r]||(l[r]=new Tick(s,r)),o&&l[r].isNew&&l[r].render(t,!0,-1),l[r].render(t))},n.prototype.render=function(){var r=this,t=r.chart,o=r.logarithmic,s=t.renderer,a=r.options,l=r.isLinked,h=r.tickPositions,c=r.axisTitle,d=r.ticks,p=r.minorTicks,u=r.alternateBands,f=a.stackLabels,g=a.alternateGridColor,v=r.tickmarkOffset,m=r.axisLine,x=r.showAxis,y=animObject$a(s.globalAnimation),b,$;if(r.labelEdge.length=0,r.overlap=!1,[d,p,u].forEach(function(A){objectEach$s(A,function(P){P.isActive=!1})}),r.hasData()||l){var S=r.chart.hasRendered&&r.old&&isNumber$H(r.old.min);r.minorTickInterval&&!r.categories&&r.getMinorTickPositions().forEach(function(A){r.renderMinorTick(A,S)}),h.length&&(h.forEach(function(A,P){r.renderTick(A,P,S)}),v&&(r.min===0||r.single)&&(d[-1]||(d[-1]=new Tick(r,-1,null,!0)),d[-1].render(-1))),g&&h.forEach(function(A,P){$=typeof h[P+1]<"u"?h[P+1]+v:r.max-v,P%2===0&&A<r.max&&$<=r.max+(t.polar?-v:v)&&(u[A]||(u[A]=new H.PlotLineOrBand(r)),b=A+v,u[A].options={from:o?o.lin2log(b):b,to:o?o.lin2log($):$,color:g,className:"highcharts-alternate-grid"},u[A].render(),u[A].isActive=!0)}),r._addedPlotLB||(r._addedPlotLB=!0,(a.plotLines||[]).concat(a.plotBands||[]).forEach(function(A){r.addPlotBandOrLine(A)}))}if([d,p,u].forEach(function(A){var P=[],E=y.duration,M=function(){for(var T=P.length;T--;)A[P[T]]&&!A[P[T]].isActive&&(A[P[T]].destroy(),delete A[P[T]])};objectEach$s(A,function(T,O){T.isActive||(T.render(O,!1,0),T.isActive=!1,P.push(O))}),syncTimeout$7(M,A===u||!t.hasRendered||!E?0:E)}),m&&(m[m.isPlaced?"animate":"attr"]({d:this.getLinePath(m.strokeWidth())}),m.isPlaced=!0,m[x?"show":"hide"](x)),c&&x){var k=r.getTitlePosition();isNumber$H(k.y)?(c[c.isNew?"attr":"animate"](k),c.isNew=!1):(c.attr("y",-9999),c.isNew=!0)}f&&f.enabled&&r.stacking&&r.stacking.renderStackTotals(),r.old={len:r.len,max:r.max,min:r.min,transA:r.transA,userMax:r.userMax,userMin:r.userMin},r.isDirty=!1,fireEvent$y(this,"afterRender")},n.prototype.redraw=function(){this.visible&&(this.render(),this.plotLinesAndBands.forEach(function(r){r.render()})),this.series.forEach(function(r){r.isDirty=!0})},n.prototype.getKeepProps=function(){return this.keepProps||n.keepProps},n.prototype.destroy=function(r){var t=this,o=t.plotLinesAndBands,s=this.eventOptions;if(fireEvent$y(this,"destroy",{keepEvents:r}),r||removeEvent$9(t),[t.ticks,t.minorTicks,t.alternateBands].forEach(function(h){destroyObjectProperties$7(h)}),o)for(var a=o.length;a--;)o[a].destroy();["axisLine","axisTitle","axisGroup","gridGroup","labelGroup","cross","scrollbar"].forEach(function(h){t[h]&&(t[h]=t[h].destroy())});for(var l in t.plotLinesAndBandsGroups)t.plotLinesAndBandsGroups[l]=t.plotLinesAndBandsGroups[l].destroy();objectEach$s(t,function(h,c){t.getKeepProps().indexOf(c)===-1&&delete t[c]}),this.eventOptions=s},n.prototype.drawCrosshair=function(r,t){var o=this.crosshair,s=pick$1o(o&&o.snap,!0),a=this.chart,l,h,c,d=this.cross,p;if(fireEvent$y(this,"drawCrosshair",{e:r,point:t}),r||(r=this.cross&&this.cross.e),!o||(defined$N(t)||!s)===!1)this.hideCrosshair();else{if(s?defined$N(t)&&(h=pick$1o(this.coll!=="colorAxis"?t.crosshairPos:null,this.isXAxis?t.plotX:this.len-t.plotY)):h=r&&(this.horiz?r.chartX-this.pos:this.len-r.chartY+this.pos),defined$N(h)&&(p={value:t&&(this.isXAxis?t.x:pick$1o(t.stackY,t.y)),translatedValue:h},a.polar&&extend$1i(p,{isCrosshair:!0,chartX:r&&r.chartX,chartY:r&&r.chartY,point:t}),l=this.getPlotLinePath(p)||null),!defined$N(l)){this.hideCrosshair();return}c=this.categories&&!this.isRadial,d||(this.cross=d=a.renderer.path().addClass("highcharts-crosshair highcharts-crosshair-"+(c?"category ":"thin ")+(o.className||"")).attr({zIndex:pick$1o(o.zIndex,2)}).add(),a.styledMode||(d.attr({stroke:o.color||(c?Color.parse(palette.highlightColor20).setOpacity(.25).get():palette.neutralColor20),"stroke-width":pick$1o(o.width,1)}).css({"pointer-events":"none"}),o.dashStyle&&d.attr({dashstyle:o.dashStyle}))),d.show().attr({d:l}),c&&!o.width&&d.attr({"stroke-width":this.transA}),this.cross.e=r}fireEvent$y(this,"afterDrawCrosshair",{e:r,point:t})},n.prototype.hideCrosshair=function(){this.cross&&this.cross.hide(),fireEvent$y(this,"afterHideCrosshair")},n.prototype.hasVerticalPanning=function(){var r=this.chart.options.chart.panning;return!!(r&&r.enabled&&/y/.test(r.type))},n.prototype.validatePositiveValue=function(r){return isNumber$H(r)&&r>0},n.prototype.update=function(r,t){var o=this.chart;r=merge$1g(this.userOptions,r),this.destroy(!0),this.init(o,r),o.isDirtyBox=!0,pick$1o(t,!0)&&o.redraw()},n.prototype.remove=function(r){for(var t=this.chart,o=this.coll,s=this.series,a=s.length;a--;)s[a]&&s[a].remove(!1);erase$7(t.axes,this),erase$7(t[o],this),t[o].forEach(function(l,h){l.options.index=l.userOptions.index=h}),this.destroy(),t.isDirtyBox=!0,pick$1o(r,!0)&&t.redraw()},n.prototype.setTitle=function(r,t){this.update({title:r},t)},n.prototype.setCategories=function(r,t){this.update({categories:r},t)},n.defaultOptions=AxisDefaults$1.defaultXAxisOptions,n.keepProps=["extKey","hcEvents","names","series","userMax","userMin"],n}(),addEvent$_=Utilities.addEvent,getMagnitude$1=Utilities.getMagnitude,normalizeTickInterval$1=Utilities.normalizeTickInterval,timeUnits$1=Utilities.timeUnits,DateTimeAxis;(function(n){var r=[];function t(l){if(r.indexOf(l)===-1){r.push(l),l.keepProps.push("dateTime");var h=l.prototype;h.getTimeTicks=o,addEvent$_(l,"init",s)}return l}n.compose=t;function o(){return this.chart.time.getTimeTicks.apply(this.chart.time,arguments)}function s(l){var h=this,c=l.userOptions;if(c.type!=="datetime"){h.dateTime=void 0;return}h.dateTime||(h.dateTime=new a(h))}var a=function(){function l(h){this.axis=h}return l.prototype.normalizeTimeTickInterval=function(h,c){var d=c||[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2]],["week",[1,2]],["month",[1,2,3,4,6]],["year",null]],p=d[d.length-1],u=timeUnits$1[p[0]],f=p[1],g;for(g=0;g<d.length;g++)if(p=d[g],u=timeUnits$1[p[0]],f=p[1],d[g+1]){var v=(u*f[f.length-1]+timeUnits$1[d[g+1][0]])/2;if(h<=v)break}u===timeUnits$1.year&&h<5*u&&(f=[1,2,5]);var m=normalizeTickInterval$1(h/u,f,p[0]==="year"?Math.max(getMagnitude$1(h/u),1):1);return{unitRange:u,count:m,unitName:p[0]}},l.prototype.getXDateFormat=function(h,c){var d=this.axis;return d.closestPointRange?d.chart.time.getDateFormat(d.closestPointRange,h,d.options.startOfWeek,c)||c.year:c.day},l}();n.Additions=a})(DateTimeAxis||(DateTimeAxis={}));const DateTimeAxis$1=DateTimeAxis;var addEvent$Z=Utilities.addEvent,getMagnitude=Utilities.getMagnitude,normalizeTickInterval=Utilities.normalizeTickInterval,pick$1n=Utilities.pick,LogarithmicAxis;(function(n){var r=[];function t(l){return r.indexOf(l)===-1&&(r.push(l),l.keepProps.push("logarithmic"),addEvent$Z(l,"init",o),addEvent$Z(l,"afterInit",s)),l}n.compose=t;function o(l){var h=this,c=l.userOptions,d=h.logarithmic;c.type!=="logarithmic"?h.logarithmic=void 0:d||(d=h.logarithmic=new a(h))}function s(){var l=this,h=l.logarithmic;h&&(l.lin2val=function(c){return h.lin2log(c)},l.val2lin=function(c){return h.log2lin(c)})}var a=function(){function l(h){this.axis=h}return l.prototype.getLogTickPositions=function(h,c,d,p){var u=this,f=u.axis,g=f.len,v=f.options,m=[];if(p||(u.minorAutoInterval=void 0),h>=.5)h=Math.round(h),m=f.getLinearTickPositions(h,c,d);else if(h>=.08){var x=Math.floor(c),y=void 0,b=void 0,$=void 0,S=void 0,k=void 0,A=void 0,P=void 0;for(h>.3?y=[1,2,4]:h>.15?y=[1,2,4,6,8]:y=[1,2,3,4,5,6,7,8,9],b=x;b<d+1&&!P;b++)for(S=y.length,$=0;$<S&&!P;$++)k=u.log2lin(u.lin2log(b)*y[$]),k>c&&(!p||A<=d)&&typeof A<"u"&&m.push(A),A>d&&(P=!0),A=k}else{var E=u.lin2log(c),M=u.lin2log(d),T=p?f.getMinorTickInterval():v.tickInterval,O=T==="auto"?null:T,L=v.tickPixelInterval/(p?5:1),C=p?g/f.tickPositions.length:g;h=pick$1n(O,u.minorAutoInterval,(M-E)*L/(C||1)),h=normalizeTickInterval(h,void 0,getMagnitude(h)),m=f.getLinearTickPositions(h,E,M).map(u.log2lin),p||(u.minorAutoInterval=h/5)}return p||(f.tickInterval=h),m},l.prototype.lin2log=function(h){return Math.pow(10,h)},l.prototype.log2lin=function(h){return Math.log(h)/Math.LN10},l}();n.Additions=a})(LogarithmicAxis||(LogarithmicAxis={}));const LogarithmicAxis$1=LogarithmicAxis;var erase$6=Utilities.erase,extend$1h=Utilities.extend,isNumber$G=Utilities.isNumber,PlotLineOrBandAxis;(function(n){var r=[],t;function o(a,l){return t||(t=a),r.indexOf(l)===-1&&(r.push(l),extend$1h(l.prototype,s.prototype)),l}n.compose=o;var s=function(){function a(){}return a.prototype.getPlotBandPath=function(l,h,c){c===void 0&&(c=this.options);var d=this.getPlotLinePath({value:h,force:!0,acrossPanes:c.acrossPanes}),p=[],u=this.horiz,f=!isNumber$G(this.min)||!isNumber$G(this.max)||l<this.min&&h<this.min||l>this.max&&h>this.max,g=this.getPlotLinePath({value:l,force:!0,acrossPanes:c.acrossPanes}),v,m=1,x;if(g&&d)for(f&&(x=g.toString()===d.toString(),m=0),v=0;v<g.length;v+=2){var y=g[v],b=g[v+1],$=d[v],S=d[v+1];(y[0]==="M"||y[0]==="L")&&(b[0]==="M"||b[0]==="L")&&($[0]==="M"||$[0]==="L")&&(S[0]==="M"||S[0]==="L")&&(u&&$[1]===y[1]?($[1]+=m,S[1]+=m):!u&&$[2]===y[2]&&($[2]+=m,S[2]+=m),p.push(["M",y[1],y[2]],["L",b[1],b[2]],["L",S[1],S[2]],["L",$[1],$[2]],["Z"])),p.isFlat=x}else g=null;return p},a.prototype.addPlotBand=function(l){return this.addPlotBandOrLine(l,"plotBands")},a.prototype.addPlotLine=function(l){return this.addPlotBandOrLine(l,"plotLines")},a.prototype.addPlotBandOrLine=function(l,h){var c=this,d=this.userOptions,p=new t(this,l);if(this.visible&&(p=p.render()),p){if(this._addedPlotLB||(this._addedPlotLB=!0,(d.plotLines||[]).concat(d.plotBands||[]).forEach(function(f){c.addPlotBandOrLine(f)})),h){var u=d[h]||[];u.push(l),d[h]=u}this.plotLinesAndBands.push(p)}return p},a.prototype.removePlotBandOrLine=function(l){var h=this.plotLinesAndBands,c=this.options,d=this.userOptions;if(h){for(var p=h.length;p--;)h[p].id===l&&h[p].destroy();[c.plotLines||[],d.plotLines||[],c.plotBands||[],d.plotBands||[]].forEach(function(u){for(p=u.length;p--;)(u[p]||{}).id===l&&erase$6(u,u[p])})}},a.prototype.removePlotBand=function(l){this.removePlotBandOrLine(l)},a.prototype.removePlotLine=function(l){this.removePlotBandOrLine(l)},a}()})(PlotLineOrBandAxis||(PlotLineOrBandAxis={}));const PlotLineOrBandAxis$1=PlotLineOrBandAxis;var arrayMax$8=Utilities.arrayMax,arrayMin$7=Utilities.arrayMin,defined$M=Utilities.defined,destroyObjectProperties$6=Utilities.destroyObjectProperties,erase$5=Utilities.erase,fireEvent$x=Utilities.fireEvent,merge$1f=Utilities.merge,objectEach$r=Utilities.objectEach,pick$1m=Utilities.pick,PlotLineOrBand=function(){function n(r,t){this.axis=r,t&&(this.options=t,this.id=t.id)}return n.compose=function(r){return PlotLineOrBandAxis$1.compose(n,r)},n.prototype.render=function(){fireEvent$x(this,"render");var r=this,t=r.axis,o=t.horiz,s=t.logarithmic,a=r.options,l=a.color,h=pick$1m(a.zIndex,0),c=a.events,d={},p=t.chart.renderer,u=a.label,f=r.label,g=a.to,v=a.from,m=a.value,x=r.svgElem,y=[],b,$=defined$M(v)&&defined$M(g),S=defined$M(m),k=!x,A={class:"highcharts-plot-"+($?"band ":"line ")+(a.className||"")},P=$?"bands":"lines";if(s&&(v=s.log2lin(v),g=s.log2lin(g),m=s.log2lin(m)),t.chart.styledMode||(S?(A.stroke=l||palette.neutralColor40,A["stroke-width"]=pick$1m(a.width,1),a.dashStyle&&(A.dashstyle=a.dashStyle)):$&&(A.fill=l||palette.highlightColor10,a.borderWidth&&(A.stroke=a.borderColor,A["stroke-width"]=a.borderWidth))),d.zIndex=h,P+="-"+h,b=t.plotLinesAndBandsGroups[P],b||(t.plotLinesAndBandsGroups[P]=b=p.g("plot-"+P).attr(d).add()),k&&(r.svgElem=x=p.path().attr(A).add(b)),S)y=t.getPlotLinePath({value:m,lineWidth:x.strokeWidth(),acrossPanes:a.acrossPanes});else if($)y=t.getPlotBandPath(v,g,a);else return;return!r.eventsAdded&&c&&(objectEach$r(c,function(E,M){x.on(M,function(T){c[M].apply(r,[T])})}),r.eventsAdded=!0),(k||!x.d)&&y&&y.length?x.attr({d:y}):x&&(y?(x.show(!0),x.animate({d:y})):x.d&&(x.hide(),f&&(r.label=f=f.destroy()))),u&&(defined$M(u.text)||defined$M(u.formatter))&&y&&y.length&&t.width>0&&t.height>0&&!y.isFlat?(u=merge$1f({align:o&&$&&"center",x:o?!$&&4:10,verticalAlign:!o&&$&&"middle",y:o?$?16:10:$?6:-4,rotation:o&&!$&&90},u),this.renderLabel(u,y,$,h)):f&&f.hide(),r},n.prototype.renderLabel=function(r,t,o,s){var a=this,l=a.axis,h=l.chart.renderer,c=a.label;c||(a.label=c=h.text(this.getLabelText(r),0,0,r.useHTML).attr({align:r.textAlign||r.align,rotation:r.rotation,class:"highcharts-plot-"+(o?"band":"line")+"-label "+(r.className||""),zIndex:s}).add(),l.chart.styledMode||c.css(merge$1f({textOverflow:"ellipsis"},r.style)));var d=t.xBounds||[t[0][1],t[1][1],o?t[2][1]:t[0][1]],p=t.yBounds||[t[0][2],t[1][2],o?t[2][2]:t[0][2]],u=arrayMin$7(d),f=arrayMin$7(p);c.align(r,!1,{x:u,y:f,width:arrayMax$8(d)-u,height:arrayMax$8(p)-f}),(!c.alignValue||c.alignValue==="left")&&c.css({width:(c.rotation===90?l.height-(c.alignAttr.y-l.top):l.width-(c.alignAttr.x-l.left))+"px"}),c.show(!0)},n.prototype.getLabelText=function(r){return defined$M(r.formatter)?r.formatter.call(this):r.text},n.prototype.destroy=function(){erase$5(this.axis.plotLinesAndBands,this),delete this.axis,destroyObjectProperties$6(this)},n}(),format$c=FormatUtilities.format,doc$i=H.doc,distribute$3=R.distribute,addEvent$Y=Utilities.addEvent,clamp$f=Utilities.clamp,css$9=Utilities.css,defined$L=Utilities.defined,discardElement$5=Utilities.discardElement,extend$1g=Utilities.extend,fireEvent$w=Utilities.fireEvent,isArray$i=Utilities.isArray,isNumber$F=Utilities.isNumber,isString$6=Utilities.isString,merge$1e=Utilities.merge,pick$1l=Utilities.pick,splat$f=Utilities.splat,syncTimeout$6=Utilities.syncTimeout,Tooltip=function(){function n(r,t){this.container=void 0,this.crosshairs=[],this.distance=0,this.isHidden=!0,this.isSticky=!1,this.now={},this.options={},this.outside=!1,this.chart=r,this.init(r,t)}return n.prototype.applyFilter=function(){var r=this.chart;r.renderer.definition({tagName:"filter",attributes:{id:"drop-shadow-"+r.index,opacity:.5},children:[{tagName:"feGaussianBlur",attributes:{in:"SourceAlpha",stdDeviation:1}},{tagName:"feOffset",attributes:{dx:1,dy:1}},{tagName:"feComponentTransfer",children:[{tagName:"feFuncA",attributes:{type:"linear",slope:.3}}]},{tagName:"feMerge",children:[{tagName:"feMergeNode"},{tagName:"feMergeNode",attributes:{in:"SourceGraphic"}}]}]})},n.prototype.bodyFormatter=function(r){return r.map(function(t){var o=t.series.tooltipOptions;return(o[(t.point.formatPrefix||"point")+"Formatter"]||t.point.tooltipFormatter).call(t.point,o[(t.point.formatPrefix||"point")+"Format"]||"")})},n.prototype.cleanSplit=function(r){this.chart.series.forEach(function(t){var o=t&&t.tt;o&&(!o.isActive||r?t.tt=o.destroy():o.isActive=!1)})},n.prototype.defaultFormatter=function(r){var t=this.points||splat$f(this),o;return o=[r.tooltipFooterHeaderFormatter(t[0])],o=o.concat(r.bodyFormatter(t)),o.push(r.tooltipFooterHeaderFormatter(t[0],!0)),o},n.prototype.destroy=function(){this.label&&(this.label=this.label.destroy()),this.split&&this.tt&&(this.cleanSplit(this.chart,!0),this.tt=this.tt.destroy()),this.renderer&&(this.renderer=this.renderer.destroy(),discardElement$5(this.container)),Utilities.clearTimeout(this.hideTimer),Utilities.clearTimeout(this.tooltipTimeout)},n.prototype.getAnchor=function(r,t){var o=this.chart,s=o.pointer,a=o.inverted,l=o.plotTop,h=o.plotLeft,c,d,p,u=0,f=0;return r=splat$f(r),this.followPointer&&t?(typeof t.chartX>"u"&&(t=s.normalize(t)),c=[t.chartX-h,t.chartY-l]):r[0].tooltipPos?c=r[0].tooltipPos:(r.forEach(function(g){d=g.series.yAxis,p=g.series.xAxis,u+=g.plotX||0,f+=g.plotLow?(g.plotLow+(g.plotHigh||0))/2:g.plotY||0,p&&d&&(a?(u+=l+o.plotHeight-p.len-p.pos,f+=h+o.plotWidth-d.len-d.pos):(u+=p.pos-h,f+=d.pos-l))}),u/=r.length,f/=r.length,c=[a?o.plotWidth-f:u,a?o.plotHeight-u:f],this.shared&&r.length>1&&t&&(a?c[0]=t.chartX-h:c[1]=t.chartY-l)),c.map(Math.round)},n.prototype.getLabel=function(){var r=this,t=this.chart.styledMode,o=this.options,s="tooltip"+(defined$L(o.className)?" "+o.className:""),a=o.style.pointerEvents||(!this.followPointer&&o.stickOnContact?"auto":"none"),l=function(){r.inContact=!0},h=function(m){var x=r.chart.hoverSeries;r.inContact=r.shouldStickOnContact()&&r.chart.pointer.inClass(m.relatedTarget,"highcharts-tooltip"),!r.inContact&&x&&x.onMouseOut&&x.onMouseOut()},c,d=this.chart.renderer;if(!this.label){if(this.outside){var p=this.chart.options.chart.style,u=RendererRegistry$1.getRendererType();this.container=c=H.doc.createElement("div"),c.className="highcharts-tooltip-container",css$9(c,{position:"absolute",top:"1px",pointerEvents:a,zIndex:Math.max(this.options.style.zIndex||0,(p&&p.zIndex||0)+3)}),addEvent$Y(c,"mouseenter",l),addEvent$Y(c,"mouseleave",h),H.doc.body.appendChild(c),this.renderer=d=new u(c,0,0,p,void 0,void 0,d.styledMode)}if(this.split?this.label=d.g(s):(this.label=d.label("",0,0,o.shape,void 0,void 0,o.useHTML,void 0,s).attr({padding:o.padding,r:o.borderRadius}),t||this.label.attr({fill:o.backgroundColor,"stroke-width":o.borderWidth}).css(o.style).css({pointerEvents:a}).shadow(o.shadow)),t&&o.shadow&&(this.applyFilter(),this.label.attr({filter:"url(#drop-shadow-"+this.chart.index+")"})),r.outside&&!r.split){var f=this.label,g=f.xSetter,v=f.ySetter;f.xSetter=function(m){g.call(f,r.distance),c.style.left=m+"px"},f.ySetter=function(m){v.call(f,r.distance),c.style.top=m+"px"}}this.label.on("mouseenter",l).on("mouseleave",h).attr({zIndex:8}).add()}return this.label},n.prototype.getPosition=function(r,t,o){var s=this.chart,a=this.distance,l={},h=s.inverted&&o.h||0,c=this.outside,d=c?doc$i.documentElement.clientWidth-2*a:s.chartWidth,p=c?Math.max(doc$i.body.scrollHeight,doc$i.documentElement.scrollHeight,doc$i.body.offsetHeight,doc$i.documentElement.offsetHeight,doc$i.documentElement.clientHeight):s.chartHeight,u=s.pointer.getChartPosition(),f=function(P){return P*u.scaleX},g=function(P){return P*u.scaleY},v=function(P){var E=P==="x";return[P,E?d:p,E?r:t].concat(c?[E?f(r):g(t),E?u.left-a+f(o.plotX+s.plotLeft):u.top-a+g(o.plotY+s.plotTop),0,E?d:p]:[E?r:t,E?o.plotX+s.plotLeft:o.plotY+s.plotTop,E?s.plotLeft:s.plotTop,E?s.plotLeft+s.plotWidth:s.plotTop+s.plotHeight])},m=v("y"),x=v("x"),y,b=!this.followPointer&&pick$1l(o.ttBelow,!s.inverted==!!o.negative),$=function(P,E,M,T,O,L,C){var U=c?P==="y"?g(a):f(a):a,D=(M-T)/2,N=T<O-a,I=O+a+T<E,B=O-U-M+D,X=O+U-D;if(b&&I)l[P]=X;else if(!b&&N)l[P]=B;else if(N)l[P]=Math.min(C-T,B-h<0?B:B-h);else if(I)l[P]=Math.max(L,X+h+M>E?X:X+h);else return!1},S=function(P,E,M,T,O){var L;return O<a||O>E-a?L=!1:O<M/2?l[P]=1:O>E-T/2?l[P]=E-T-2:l[P]=O-M/2,L},k=function(P){var E=m;m=x,x=E,y=P},A=function(){$.apply(0,m)!==!1?S.apply(0,x)===!1&&!y&&(k(!0),A()):y?l.x=l.y=0:(k(!0),A())};return(s.inverted||this.len>1)&&k(),A(),l},n.prototype.hide=function(r){var t=this;Utilities.clearTimeout(this.hideTimer),r=pick$1l(r,this.options.hideDelay),this.isHidden||(this.hideTimer=syncTimeout$6(function(){t.getLabel().fadeOut(r&&void 0),t.isHidden=!0},r))},n.prototype.init=function(r,t){this.chart=r,this.options=t,this.crosshairs=[],this.now={x:0,y:0},this.isHidden=!0,this.split=t.split&&!r.inverted&&!r.polar,this.shared=t.shared||this.split,this.outside=pick$1l(t.outside,!!(r.scrollablePixelsX||r.scrollablePixelsY))},n.prototype.shouldStickOnContact=function(){return!!(!this.followPointer&&this.options.stickOnContact)},n.prototype.isStickyOnContact=function(){return!!(this.shouldStickOnContact()&&this.inContact)},n.prototype.move=function(r,t,o,s){var a=this,l=a.now,h=a.options.animation!==!1&&!a.isHidden&&(Math.abs(r-l.x)>1||Math.abs(t-l.y)>1),c=a.followPointer||a.len>1;extend$1g(l,{x:h?(2*l.x+r)/3:r,y:h?(l.y+t)/2:t,anchorX:c?void 0:h?(2*l.anchorX+o)/3:o,anchorY:c?void 0:h?(l.anchorY+s)/2:s}),a.getLabel().attr(l),a.drawTracker(),h&&(Utilities.clearTimeout(this.tooltipTimeout),this.tooltipTimeout=setTimeout(function(){a&&a.move(r,t,o,s)},32))},n.prototype.refresh=function(r,t){var o=this,s=this.chart,a=o.options,l=splat$f(r),h=l[0],c=[],d=a.formatter||o.defaultFormatter,p=o.shared,u=s.styledMode,f={};if(a.enabled){Utilities.clearTimeout(this.hideTimer),o.followPointer=!o.split&&h.series.tooltipOptions.followPointer;var g=o.getAnchor(r,t),v=g[0],m=g[1];p&&!(!isArray$i(r)&&r.series&&r.series.noSharedTooltip)?(s.pointer.applyInactiveState(l),l.forEach(function(k){k.setState("hover"),c.push(k.getLabelConfig())}),f={x:h.category,y:h.y},f.points=c):f=h.getLabelConfig(),this.len=c.length;var x=d.call(f,o),y=h.series;if(this.distance=pick$1l(y.tooltipOptions.distance,16),x===!1)this.hide();else{if(o.split)this.renderSplit(x,l);else{var b=v,$=m;if(t&&s.pointer.isDirectTouch&&(b=t.chartX-s.plotLeft,$=t.chartY-s.plotTop),s.polar||y.options.clip===!1||y.shouldShowTooltip(b,$)){var S=o.getLabel();(!a.style.width||u)&&S.css({width:this.chart.spacingBox.width+"px"}),S.attr({text:x&&x.join?x.join(""):x}),S.removeClass(/highcharts-color-[\d]+/g).addClass("highcharts-color-"+pick$1l(h.colorIndex,y.colorIndex)),u||S.attr({stroke:a.borderColor||h.color||y.color||palette.neutralColor60}),o.updatePosition({plotX:v,plotY:m,negative:h.negative,ttBelow:h.ttBelow,h:g[2]||0})}else{o.hide();return}}o.isHidden&&o.label&&o.label.attr({opacity:1}).show(),o.isHidden=!1}fireEvent$w(this,"refresh")}},n.prototype.renderSplit=function(r,t){var o=this,s=o.chart,a=o.chart,l=a.chartWidth,h=a.chartHeight,c=a.plotHeight,d=a.plotLeft,p=a.plotTop,u=a.pointer,f=a.scrollablePixelsY,g=f===void 0?0:f,v=a.scrollablePixelsX,m=a.scrollingContainer,x=m===void 0?{scrollLeft:0,scrollTop:0}:m,y=x.scrollLeft,b=x.scrollTop,$=a.styledMode,S=o.distance,k=o.options,A=o.options.positioner,P=o.outside&&typeof v!="number"?doc$i.documentElement.getBoundingClientRect():{left:y,right:y+l,top:b,bottom:b+h},E=o.getLabel(),M=this.renderer||s.renderer,T=!!(s.xAxis[0]&&s.xAxis[0].opposite),O=u.getChartPosition(),L=O.left,C=O.top,U=p+b,D=0,N=c-g;function I(Y){var Z=Y.isHeader,et=Y.plotX,Q=et===void 0?0:et,tt=Y.plotY,rt=tt===void 0?0:tt,it=Y.series,nt,st;if(Z)nt=d+Q,st=p+c/2;else{var at=it.xAxis,lt=it.yAxis;nt=at.pos+clamp$f(Q,-S,at.len+S),it.shouldShowTooltip(0,lt.pos-p+rt,{ignoreX:!0})&&(st=lt.pos+rt)}return nt=clamp$f(nt,P.left-S,P.right+S),{anchorX:nt,anchorY:st}}function B(Y,Z,et,Q,tt){tt===void 0&&(tt=!0);var rt,it;return et?(rt=T?0:N,it=clamp$f(Y-Q/2,P.left,P.right-Q-(o.outside?L:0))):(rt=Z-U,it=tt?Y-Q-S:Y+S,it=clamp$f(it,tt?it:P.left,P.right)),{x:it,y:rt}}function X(Y,Z,et){var Q=Y,tt=Z.isHeader,rt=Z.series,it="highcharts-color-"+pick$1l(Z.colorIndex,rt.colorIndex,"none");if(!Q){var nt={padding:k.padding,r:k.borderRadius};$||(nt.fill=k.backgroundColor,nt["stroke-width"]=k.borderWidth),Q=M.label("",0,0,k[tt?"headerShape":"shape"],void 0,void 0,k.useHTML).addClass((tt?"highcharts-tooltip-header ":"")+"highcharts-tooltip-box "+it).attr(nt).add(E)}return Q.isActive=!0,Q.attr({text:et}),$||Q.css(k.style).shadow(k.shadow).attr({stroke:k.borderColor||Z.color||rt.color||palette.neutralColor80}),Q}isString$6(r)&&(r=[!1,r]);var W=r.slice(0,t.length+1).reduce(function(Y,Z,et){if(Z!==!1&&Z!==""){var Q=t[et-1]||{isHeader:!0,plotX:t[0].plotX,plotY:c,series:{}},tt=Q.isHeader,rt=tt?o:Q.series,it=rt.tt=X(rt.tt,Q,Z.toString()),nt=it.getBBox(),st=nt.width+it.strokeWidth();tt&&(D=nt.height,N+=D,T&&(U-=D));var at=I(Q),lt=at.anchorX,ht=at.anchorY;if(typeof ht=="number"){var ct=nt.height+1,dt=A?A.call(o,st,ct,Q):B(lt,ht,tt,st);Y.push({align:A?0:void 0,anchorX:lt,anchorY:ht,boxWidth:st,point:Q,rank:pick$1l(dt.rank,tt?1:0),size:ct,target:dt.y,tt:it,x:dt.x})}else it.isActive=!1}return Y},[]);!A&&W.some(function(Y){var Z=o.outside,et=(Z?L:0)+Y.anchorX;return et<P.left&&et+Y.boxWidth<P.right?!0:et<L-P.left+Y.boxWidth&&P.right-et>et})&&(W=W.map(function(Y){var Z=B(Y.anchorX,Y.anchorY,Y.point.isHeader,Y.boxWidth,!1),et=Z.x,Q=Z.y;return extend$1g(Y,{target:Q,x:et})})),o.cleanSplit(),distribute$3(W,N);var F={left:L,right:L};W.forEach(function(Y){var Z=Y.x,et=Y.boxWidth,Q=Y.isHeader;Q||(o.outside&&L+Z<F.left&&(F.left=L+Z),!Q&&o.outside&&F.left+et>F.right&&(F.right=L+Z))}),W.forEach(function(Y){var Z=Y.x,et=Y.anchorX,Q=Y.anchorY,tt=Y.pos,rt=Y.point.isHeader,it={visibility:typeof tt>"u"?"hidden":"inherit",x:Z,y:tt+U,anchorX:et,anchorY:Q};if(o.outside&&Z<et){var nt=L-F.left;nt>0&&(rt||(it.x=Z+nt,it.anchorX=et+nt),rt&&(it.x=(F.right-F.left)/2,it.anchorX=et+nt))}Y.tt.attr(it)});var _=o.container,z=o.outside,V=o.renderer;if(z&&_&&V){var j=E.getBBox(),K=j.width,ot=j.height,q=j.x,J=j.y;V.setSize(K+q,ot+J,!1),_.style.left=F.left+"px",_.style.top=C+"px"}},n.prototype.drawTracker=function(){var r=this;if(r.followPointer||!r.options.stickOnContact){r.tracker&&r.tracker.destroy();return}var t=r.chart,o=r.label,s=r.shared?t.hoverPoints:t.hoverPoint;if(!(!o||!s)){var a={x:0,y:0,width:0,height:0},l=this.getAnchor(s),h=o.getBBox();l[0]+=t.plotLeft-o.translateX,l[1]+=t.plotTop-o.translateY,a.x=Math.min(0,l[0]),a.y=Math.min(0,l[1]),a.width=l[0]<0?Math.max(Math.abs(l[0]),h.width-l[0]):Math.max(Math.abs(l[0]),h.width),a.height=l[1]<0?Math.max(Math.abs(l[1]),h.height-Math.abs(l[1])):Math.max(Math.abs(l[1]),h.height),r.tracker?r.tracker.attr(a):(r.tracker=o.renderer.rect(a).addClass("highcharts-tracker").add(o),t.styledMode||r.tracker.attr({fill:"rgba(0,0,0,0)"}))}},n.prototype.styledModeFormat=function(r){return r.replace('style="font-size: 10px"','class="highcharts-header"').replace(/style="color:{(point|series)\.color}"/g,'class="highcharts-color-{$1.colorIndex}"')},n.prototype.tooltipFooterHeaderFormatter=function(r,t){var o=r.series,s=o.tooltipOptions,a=o.xAxis,l=a&&a.dateTime,h={isFooter:t,labelConfig:r},c=s.xDateFormat,d=s[t?"footerFormat":"headerFormat"];return fireEvent$w(this,"headerFormatter",h,function(p){l&&!c&&isNumber$F(r.key)&&(c=l.getXDateFormat(r.key,s.dateTimeLabelFormats)),l&&c&&(r.point&&r.point.tooltipDateKeys||["key"]).forEach(function(u){d=d.replace("{point."+u+"}","{point."+u+":"+c+"}")}),o.chart.styledMode&&(d=this.styledModeFormat(d)),p.text=format$c(d,{point:r,series:o},this.chart)}),h.text},n.prototype.update=function(r){this.destroy(),merge$1e(!0,this.chart.options.tooltip.userOptions,r),this.init(this.chart,merge$1e(!0,this.options,r))},n.prototype.updatePosition=function(r){var t=this.chart,o=this.options,s=t.pointer,a=this.getLabel(),l=s.getChartPosition(),h=(o.positioner||this.getPosition).call(this,a.width,a.height,r),c=r.plotX+t.plotLeft,d=r.plotY+t.plotTop,p;this.outside&&(p=o.borderWidth+2*this.distance,this.renderer.setSize(a.width+p,a.height+p,!1),(l.scaleX!==1||l.scaleY!==1)&&(css$9(this.container,{transform:"scale("+l.scaleX+", "+l.scaleY+")"}),c*=l.scaleX,d*=l.scaleY),c+=l.left-h.x,d+=l.top-h.y),this.move(Math.round(h.x),Math.round(h.y||0),c,d)},n}(),animObject$9=animationExports.animObject,defaultOptions$c=DefaultOptions.defaultOptions,format$b=FormatUtilities.format,addEvent$X=Utilities.addEvent,defined$K=Utilities.defined,erase$4=Utilities.erase,extend$1f=Utilities.extend,fireEvent$v=Utilities.fireEvent,getNestedProperty$1=Utilities.getNestedProperty,isArray$h=Utilities.isArray,isFunction$2=Utilities.isFunction,isNumber$E=Utilities.isNumber,isObject$b=Utilities.isObject,merge$1d=Utilities.merge,objectEach$q=Utilities.objectEach,pick$1k=Utilities.pick,syncTimeout$5=Utilities.syncTimeout,removeEvent$8=Utilities.removeEvent,uniqueKey$5=Utilities.uniqueKey,Point$2=function(){function n(){this.category=void 0,this.colorIndex=void 0,this.formatPrefix="point",this.id=void 0,this.isNull=!1,this.name=void 0,this.options=void 0,this.percentage=void 0,this.selected=!1,this.series=void 0,this.total=void 0,this.visible=!0,this.x=void 0}return n.prototype.animateBeforeDestroy=function(){var r=this,t={x:r.startXPos,opacity:0},o=r.getGraphicalProps();o.singular.forEach(function(s){var a=s==="dataLabel";r[s]=r[s].animate(a?{x:r[s].startXPos,y:r[s].startYPos,opacity:0}:t)}),o.plural.forEach(function(s){r[s].forEach(function(a){a.element&&a.animate(extend$1f({x:r.startXPos},a.startYPos?{x:a.startXPos,y:a.startYPos}:{}))})})},n.prototype.applyOptions=function(r,t){var o=this,s=o.series,a=s.options.pointValKey||s.pointValKey;return r=n.prototype.optionsToObject.call(this,r),extend$1f(o,r),o.options=o.options?extend$1f(o.options,r):r,r.group&&delete o.group,r.dataLabels&&delete o.dataLabels,a&&(o.y=n.prototype.getNestedProperty.call(o,a)),o.isNull=pick$1k(o.isValid&&!o.isValid(),o.x===null||!isNumber$E(o.y)),o.formatPrefix=o.isNull?"null":"point",o.selected&&(o.state="select"),"name"in o&&typeof t>"u"&&s.xAxis&&s.xAxis.hasNames&&(o.x=s.xAxis.nameToX(o)),typeof o.x>"u"&&s?typeof t>"u"?o.x=s.autoIncrement():o.x=t:isNumber$E(r.x)&&s.options.relativeXValue&&(o.x=s.autoIncrement(r.x)),o},n.prototype.destroy=function(){var r=this,t=r.series,o=t.chart,s=t.options.dataSorting,a=o.hoverPoints,l=r.series.chart.renderer.globalAnimation,h=animObject$9(l),c;function d(){(r.graphic||r.dataLabel||r.dataLabels)&&(removeEvent$8(r),r.destroyElements());for(c in r)r[c]=null}r.legendItem&&o.legend.destroyItem(r),a&&(r.setState(),erase$4(a,r),a.length||(o.hoverPoints=null)),r===o.hoverPoint&&r.onMouseOut(),!s||!s.enabled?d():(this.animateBeforeDestroy(),syncTimeout$5(d,h.duration)),o.pointCount--},n.prototype.destroyElements=function(r){var t=this,o=t.getGraphicalProps(r);o.singular.forEach(function(s){t[s]=t[s].destroy()}),o.plural.forEach(function(s){t[s].forEach(function(a){a.element&&a.destroy()}),delete t[s]})},n.prototype.firePointEvent=function(r,t,o){var s=this,a=this.series,l=a.options;(l.point.events[r]||s.options&&s.options.events&&s.options.events[r])&&s.importEvents(),r==="click"&&l.allowPointSelect&&(o=function(h){s.select&&s.select(null,h.ctrlKey||h.metaKey||h.shiftKey)}),fireEvent$v(s,r,t,o)},n.prototype.getClassName=function(){var r=this;return"highcharts-point"+(r.selected?" highcharts-point-select":"")+(r.negative?" highcharts-negative":"")+(r.isNull?" highcharts-null-point":"")+(typeof r.colorIndex<"u"?" highcharts-color-"+r.colorIndex:"")+(r.options.className?" "+r.options.className:"")+(r.zone&&r.zone.className?" "+r.zone.className.replace("highcharts-negative",""):"")},n.prototype.getGraphicalProps=function(r){var t=this,o=[],s={singular:[],plural:[]},a,l;for(r=r||{graphic:1,dataLabel:1},r.graphic&&o.push("graphic","upperGraphic","shadowGroup"),r.dataLabel&&o.push("dataLabel","dataLabelUpper","connector"),l=o.length;l--;)a=o[l],t[a]&&s.singular.push(a);return["dataLabel","connector"].forEach(function(h){var c=h+"s";r[h]&&t[c]&&s.plural.push(c)}),s},n.prototype.getLabelConfig=function(){return{x:this.category,y:this.y,color:this.color,colorIndex:this.colorIndex,key:this.name||this.category,series:this.series,point:this,percentage:this.percentage,total:this.total||this.stackTotal}},n.prototype.getNestedProperty=function(r){if(r)return r.indexOf("custom.")===0?getNestedProperty$1(r,this.options):this[r]},n.prototype.getZone=function(){var r=this.series,t=r.zones,o=r.zoneAxis||"y",s,a=0;for(s=t[a];this[o]>=s.value;)s=t[++a];return this.nonZonedColor||(this.nonZonedColor=this.color),s&&s.color&&!this.options.color?this.color=s.color:this.color=this.nonZonedColor,s},n.prototype.hasNewShapeType=function(){var r=this,t=r.graphic&&(r.graphic.symbolName||r.graphic.element.nodeName);return t!==this.shapeType},n.prototype.init=function(r,t,o){return this.series=r,this.applyOptions(t,o),this.id=defined$K(this.id)?this.id:uniqueKey$5(),this.resolveColor(),r.chart.pointCount++,fireEvent$v(this,"afterInit"),this},n.prototype.optionsToObject=function(r){var t=this.series,o=t.options.keys,s=o||t.pointArrayMap||["y"],a=s.length,l={},h,c=0,d=0;if(isNumber$E(r)||r===null)l[s[0]]=r;else if(isArray$h(r))for(!o&&r.length>a&&(h=typeof r[0],h==="string"?l.name=r[0]:h==="number"&&(l.x=r[0]),c++);d<a;)(!o||typeof r[c]<"u")&&(s[d].indexOf(".")>0?n.prototype.setNestedProperty(l,r[c],s[d]):l[s[d]]=r[c]),c++,d++;else typeof r=="object"&&(l=r,r.dataLabels&&(t._hasPointLabels=!0),r.marker&&(t._hasPointMarkers=!0));return l},n.prototype.resolveColor=function(){var r=this.series,t=r.chart.options.chart,o=r.chart.styledMode,s,a,l=t.colorCount,h;delete this.nonZonedColor,r.options.colorByPoint?(o||(a=r.options.colors||r.chart.options.colors,s=a[r.colorCounter],l=a.length),h=r.colorCounter,r.colorCounter++,r.colorCounter===l&&(r.colorCounter=0)):(o||(s=r.color),h=r.colorIndex),this.colorIndex=pick$1k(this.options.colorIndex,h),this.color=pick$1k(this.options.color,s)},n.prototype.setNestedProperty=function(r,t,o){var s=o.split(".");return s.reduce(function(a,l,h,c){var d=c.length-1===h;return a[l]=d?t:isObject$b(a[l],!0)?a[l]:{},a[l]},r),r},n.prototype.tooltipFormatter=function(r){var t=this.series,o=t.tooltipOptions,s=pick$1k(o.valueDecimals,""),a=o.valuePrefix||"",l=o.valueSuffix||"";return t.chart.styledMode&&(r=t.chart.tooltip.styledModeFormat(r)),(t.pointArrayMap||["y"]).forEach(function(h){h="{point."+h,(a||l)&&(r=r.replace(RegExp(h+"}","g"),a+h+"}"+l)),r=r.replace(RegExp(h+"}","g"),h+":,."+s+"f}")}),format$b(r,{point:this,series:this.series},t.chart)},n.prototype.update=function(r,t,o,s){var a=this,l=a.series,h=a.graphic,c=l.chart,d=l.options,p;t=pick$1k(t,!0);function u(){a.applyOptions(r);var f=h&&a.hasDummyGraphic,g=a.y===null?!f:f;h&&g&&(a.graphic=h.destroy(),delete a.hasDummyGraphic),isObject$b(r,!0)&&(h&&h.element&&r&&r.marker&&typeof r.marker.symbol<"u"&&(a.graphic=h.destroy()),r&&r.dataLabels&&a.dataLabel&&(a.dataLabel=a.dataLabel.destroy()),a.connector&&(a.connector=a.connector.destroy())),p=a.index,l.updateParallelArrays(a,p),d.data[p]=isObject$b(d.data[p],!0)||isObject$b(r,!0)?a.options:pick$1k(r,d.data[p]),l.isDirty=l.isDirtyData=!0,!l.fixedBox&&l.hasCartesianSeries&&(c.isDirtyBox=!0),d.legendType==="point"&&(c.isDirtyLegend=!0),t&&c.redraw(o)}s===!1?u():a.firePointEvent("update",{options:r},u)},n.prototype.remove=function(r,t){this.series.removePoint(this.series.data.indexOf(this),r,t)},n.prototype.select=function(r,t){var o=this,s=o.series,a=s.chart;r=pick$1k(r,!o.selected),this.selectedStaging=r,o.firePointEvent(r?"select":"unselect",{accumulate:t},function(){o.selected=o.options.selected=r,s.options.data[s.data.indexOf(o)]=o.options,o.setState(r&&"select"),t||a.getSelectedPoints().forEach(function(l){var h=l.series;l.selected&&l!==o&&(l.selected=l.options.selected=!1,h.options.data[h.data.indexOf(l)]=l.options,l.setState(a.hoverPoints&&h.options.inactiveOtherPoints?"inactive":""),l.firePointEvent("unselect"))})}),delete this.selectedStaging},n.prototype.onMouseOver=function(r){var t=this,o=t.series,s=o.chart,a=s.pointer;r=r?a.normalize(r):a.getChartCoordinatesFromPoint(t,s.inverted),a.runPointActions(r,t)},n.prototype.onMouseOut=function(){var r=this,t=r.series.chart;r.firePointEvent("mouseOut"),r.series.options.inactiveOtherPoints||(t.hoverPoints||[]).forEach(function(o){o.setState()}),t.hoverPoints=t.hoverPoint=null},n.prototype.importEvents=function(){if(!this.hasImportedEvents){var r=this,t=merge$1d(r.series.options.point,r.options),o=t.events;r.events=o,objectEach$q(o,function(s,a){isFunction$2(s)&&addEvent$X(r,a,s)}),this.hasImportedEvents=!0}},n.prototype.setState=function(r,t){var o=this,s=o.series,a=o.state,l=s.options.states[r||"normal"]||{},h=defaultOptions$c.plotOptions[s.type].marker&&s.options.marker,c=h&&h.enabled===!1,d=h&&h.states&&h.states[r||"normal"]||{},p=d.enabled===!1,u=o.marker||{},f=s.chart,g=h&&s.markerAttribs,v=s.halo,m,x,y,b=s.stateMarkerGraphic,$;if(r=r||"",!(r===o.state&&!t||o.selected&&r!=="select"||l.enabled===!1||r&&(p||c&&d.enabled===!1)||r&&u.states&&u.states[r]&&u.states[r].enabled===!1)){o.state=r,g&&(m=s.markerAttribs(o,r)),o.graphic&&!o.hasDummyGraphic?(a&&o.graphic.removeClass("highcharts-point-"+a),r&&o.graphic.addClass("highcharts-point-"+r),f.styledMode||(x=s.pointAttribs(o,r),y=pick$1k(f.options.chart.animation,l.animation),s.options.inactiveOtherPoints&&isNumber$E(x.opacity)&&((o.dataLabels||[]).forEach(function(P){P&&P.animate({opacity:x.opacity},y)}),o.connector&&o.connector.animate({opacity:x.opacity},y)),o.graphic.animate(x,y)),m&&o.graphic.animate(m,pick$1k(f.options.chart.animation,d.animation,h.animation)),b&&b.hide()):(r&&d&&($=u.symbol||s.symbol,b&&b.currentSymbol!==$&&(b=b.destroy()),m&&(b?b[t?"animate":"attr"]({x:m.x,y:m.y}):$&&(s.stateMarkerGraphic=b=f.renderer.symbol($,m.x,m.y,m.width,m.height).add(s.markerGroup),b.currentSymbol=$)),!f.styledMode&&b&&b.attr(s.pointAttribs(o,r))),b&&(b[r&&o.isInside?"show":"hide"](),b.element.point=o,b.addClass(o.getClassName(),!0)));var S=l.halo,k=o.graphic||b,A=k&&k.visibility||"inherit";S&&S.size&&k&&A!=="hidden"&&!o.isCluster?(v||(s.halo=v=f.renderer.path().add(k.parentGroup)),v.show()[t?"animate":"attr"]({d:o.haloPath(S.size)}),v.attr({class:"highcharts-halo highcharts-color-"+pick$1k(o.colorIndex,s.colorIndex)+(o.className?" "+o.className:""),visibility:A,zIndex:-1}),v.point=o,f.styledMode||v.attr(extend$1f({fill:o.color||s.color,"fill-opacity":S.opacity},AST.filterUserAttributes(S.attributes||{})))):v&&v.point&&v.point.haloPath&&v.animate({d:v.point.haloPath(0)},null,v.hide),fireEvent$v(o,"afterSetState",{state:r})}},n.prototype.haloPath=function(r){var t=this.series,o=t.chart;return o.renderer.symbols.circle(Math.floor(this.plotX)-r,this.plotY-r,r*2,r*2)},n}(),color$e=Color.parse,charts$3=H.charts,noop$j=H.noop,addEvent$W=Utilities.addEvent,attr$2=Utilities.attr,css$8=Utilities.css,defined$J=Utilities.defined,extend$1e=Utilities.extend,find$i=Utilities.find,fireEvent$u=Utilities.fireEvent,isNumber$D=Utilities.isNumber,isObject$a=Utilities.isObject,objectEach$p=Utilities.objectEach,offset=Utilities.offset,pick$1j=Utilities.pick,splat$e=Utilities.splat,Pointer=function(){function n(r,t){this.lastValidTouch={},this.pinchDown=[],this.runChartClick=!1,this.eventsToUnbind=[],this.chart=r,this.hasDragged=!1,this.options=t,this.init(r,t)}return n.prototype.applyInactiveState=function(r){var t=[],o;(r||[]).forEach(function(s){o=s.series,t.push(o),o.linkedParent&&t.push(o.linkedParent),o.linkedSeries&&(t=t.concat(o.linkedSeries)),o.navigatorSeries&&t.push(o.navigatorSeries)}),this.chart.series.forEach(function(s){t.indexOf(s)===-1?s.setState("inactive",!0):s.options.inactiveOtherPoints&&s.setAllPointsToState("inactive")})},n.prototype.destroy=function(){var r=this;this.eventsToUnbind.forEach(function(t){return t()}),this.eventsToUnbind=[],H.chartCount||(n.unbindDocumentMouseUp&&(n.unbindDocumentMouseUp=n.unbindDocumentMouseUp()),n.unbindDocumentTouchEnd&&(n.unbindDocumentTouchEnd=n.unbindDocumentTouchEnd())),clearInterval(r.tooltipTimeout),objectEach$p(r,function(t,o){r[o]=void 0})},n.prototype.drag=function(r){var t=this.chart,o=t.options.chart,s=this.zoomHor,a=this.zoomVert,l=t.plotLeft,h=t.plotTop,c=t.plotWidth,d=t.plotHeight,p=this.mouseDownX||0,u=this.mouseDownY||0,f=isObject$a(o.panning)?o.panning&&o.panning.enabled:o.panning,g=o.panKey&&r[o.panKey+"Key"],v=r.chartX,m=r.chartY,x,y,b=this.selectionMarker;b&&b.touch||(v<l?v=l:v>l+c&&(v=l+c),m<h?m=h:m>h+d&&(m=h+d),this.hasDragged=Math.sqrt(Math.pow(p-v,2)+Math.pow(u-m,2)),this.hasDragged>10&&(x=t.isInsidePlot(p-l,u-h,{visiblePlotOnly:!0}),t.hasCartesianSeries&&(this.zoomX||this.zoomY)&&x&&!g&&(b||(this.selectionMarker=b=t.renderer.rect(l,h,s?1:c,a?1:d,0).attr({class:"highcharts-selection-marker",zIndex:7}).add(),t.styledMode||b.attr({fill:o.selectionMarkerFill||color$e(palette.highlightColor80).setOpacity(.25).get()}))),b&&s&&(y=v-p,b.attr({width:Math.abs(y),x:(y>0?0:y)+p})),b&&a&&(y=m-u,b.attr({height:Math.abs(y),y:(y>0?0:y)+u})),x&&!b&&f&&t.pan(r,o.panning)))},n.prototype.dragStart=function(r){var t=this.chart;t.mouseIsDown=r.type,t.cancelClick=!1,t.mouseDownX=this.mouseDownX=r.chartX,t.mouseDownY=this.mouseDownY=r.chartY},n.prototype.drop=function(r){var t=this,o=this.chart,s=this.hasPinched;if(this.selectionMarker){var a={originalEvent:r,xAxis:[],yAxis:[]},l=this.selectionMarker,h=l.attr?l.attr("x"):l.x,c=l.attr?l.attr("y"):l.y,d=l.attr?l.attr("width"):l.width,p=l.attr?l.attr("height"):l.height,u;(this.hasDragged||s)&&(o.axes.forEach(function(f){if(f.zoomEnabled&&defined$J(f.min)&&(s||t[{xAxis:"zoomX",yAxis:"zoomY"}[f.coll]])&&isNumber$D(h)&&isNumber$D(c)){var g=f.horiz,v=r.type==="touchend"?f.minPixelPadding:0,m=f.toValue((g?h:c)+v),x=f.toValue((g?h+d:c+p)-v);a[f.coll].push({axis:f,min:Math.min(m,x),max:Math.max(m,x)}),u=!0}}),u&&fireEvent$u(o,"selection",a,function(f){o.zoom(extend$1e(f,s?{animation:!1}:null))})),isNumber$D(o.index)&&(this.selectionMarker=this.selectionMarker.destroy()),s&&this.scaleGroups()}o&&isNumber$D(o.index)&&(css$8(o.container,{cursor:o._cursor}),o.cancelClick=this.hasDragged>10,o.mouseIsDown=this.hasDragged=this.hasPinched=!1,this.pinchDown=[])},n.prototype.findNearestKDPoint=function(r,t,o){var s=this.chart,a=s.hoverPoint,l=s.tooltip;if(a&&l&&l.isStickyOnContact())return a;var h;function c(d,p){var u=d.distX-p.distX,f=d.dist-p.dist,g=(p.series.group&&p.series.group.zIndex)-(d.series.group&&d.series.group.zIndex),v;return u!==0&&t?v=u:f!==0?v=f:g!==0?v=g:v=d.series.index>p.series.index?-1:1,v}return r.forEach(function(d){var p=d.noSharedTooltip&&t,u=!p&&d.options.findNearestPointBy.indexOf("y")<0,f=d.searchPoint(o,u);isObject$a(f,!0)&&f.series&&(!isObject$a(h,!0)||c(h,f)>0)&&(h=f)}),h},n.prototype.getChartCoordinatesFromPoint=function(r,t){var o=r.series,s=o.xAxis,a=o.yAxis,l=r.shapeArgs;if(s&&a){var h=pick$1j(r.clientX,r.plotX),c=r.plotY||0;return r.isNode&&l&&isNumber$D(l.x)&&isNumber$D(l.y)&&(h=l.x,c=l.y),t?{chartX:a.len+a.pos-c,chartY:s.len+s.pos-h}:{chartX:h+s.pos,chartY:c+a.pos}}if(l&&l.x&&l.y)return{chartX:l.x,chartY:l.y}},n.prototype.getChartPosition=function(){if(this.chartPosition)return this.chartPosition;var r=this.chart.container,t=offset(r);this.chartPosition={left:t.left,top:t.top,scaleX:1,scaleY:1};var o=r.offsetWidth,s=r.offsetHeight;return o>2&&s>2&&(this.chartPosition.scaleX=t.width/o,this.chartPosition.scaleY=t.height/s),this.chartPosition},n.prototype.getCoordinates=function(r){var t={xAxis:[],yAxis:[]};return this.chart.axes.forEach(function(o){t[o.isXAxis?"xAxis":"yAxis"].push({axis:o,value:o.toValue(r[o.horiz?"chartX":"chartY"])})}),t},n.prototype.getHoverData=function(r,t,o,s,a,l){var h=[],c=!!(s&&r),d=function(m){return m.visible&&!(!a&&m.directTouch)&&pick$1j(m.options.enableMouseTracking,!0)},p=t,u,f={chartX:l?l.chartX:void 0,chartY:l?l.chartY:void 0,shared:a};fireEvent$u(this,"beforeGetHoverData",f);var g=p&&!p.stickyTracking;u=g?[p]:o.filter(function(m){return f.filter?f.filter(m):d(m)&&m.stickyTracking});var v=c||!l?r:this.findNearestKDPoint(u,a,l);return p=v&&v.series,v&&(a&&!p.noSharedTooltip?(u=o.filter(function(m){return f.filter?f.filter(m):d(m)&&!m.noSharedTooltip}),u.forEach(function(m){var x=find$i(m.points,function(y){return y.x===v.x&&!y.isNull});isObject$a(x)&&(m.chart.isBoosting&&(x=m.getPoint(x)),h.push(x))})):h.push(v)),f={hoverPoint:v},fireEvent$u(this,"afterGetHoverData",f),{hoverPoint:f.hoverPoint,hoverSeries:p,hoverPoints:h}},n.prototype.getPointFromEvent=function(r){for(var t=r.target,o;t&&!o;)o=t.point,t=t.parentNode;return o},n.prototype.onTrackerMouseOut=function(r){var t=this.chart,o=r.relatedTarget||r.toElement,s=t.hoverSeries;this.isDirectTouch=!1,s&&o&&!s.stickyTracking&&!this.inClass(o,"highcharts-tooltip")&&(!this.inClass(o,"highcharts-series-"+s.index)||!this.inClass(o,"highcharts-tracker"))&&s.onMouseOut()},n.prototype.inClass=function(r,t){for(var o;r;){if(o=attr$2(r,"class"),o){if(o.indexOf(t)!==-1)return!0;if(o.indexOf("highcharts-container")!==-1)return!1}r=r.parentNode}},n.prototype.init=function(r,t){this.options=t,this.chart=r,this.runChartClick=!!(t.chart.events&&t.chart.events.click),this.pinchDown=[],this.lastValidTouch={},Tooltip&&(r.tooltip=new Tooltip(r,t.tooltip),this.followTouchMove=pick$1j(t.tooltip.followTouchMove,!0)),this.setDOMEvents()},n.prototype.normalize=function(r,t){var o=r.touches,s=o?o.length?o.item(0):pick$1j(o.changedTouches,r.changedTouches)[0]:r;t||(t=this.getChartPosition());var a=s.pageX-t.left,l=s.pageY-t.top;return a/=t.scaleX,l/=t.scaleY,extend$1e(r,{chartX:Math.round(a),chartY:Math.round(l)})},n.prototype.onContainerClick=function(r){var t=this.chart,o=t.hoverPoint,s=this.normalize(r),a=t.plotLeft,l=t.plotTop;t.cancelClick||(o&&this.inClass(s.target,"highcharts-tracker")?(fireEvent$u(o.series,"click",extend$1e(s,{point:o})),t.hoverPoint&&o.firePointEvent("click",s)):(extend$1e(s,this.getCoordinates(s)),t.isInsidePlot(s.chartX-a,s.chartY-l,{visiblePlotOnly:!0})&&fireEvent$u(t,"click",s)))},n.prototype.onContainerMouseDown=function(r){var t=((r.buttons||r.button)&1)===1;r=this.normalize(r),H.isFirefox&&r.button!==0&&this.onContainerMouseMove(r),(typeof r.button>"u"||t)&&(this.zoomOption(r),t&&r.preventDefault&&r.preventDefault(),this.dragStart(r))},n.prototype.onContainerMouseLeave=function(r){var t=charts$3[pick$1j(n.hoverChartIndex,-1)],o=this.chart.tooltip;o&&o.shouldStickOnContact()&&this.inClass(r.relatedTarget,"highcharts-tooltip-container")||(r=this.normalize(r),t&&(r.relatedTarget||r.toElement)&&(t.pointer.reset(),t.pointer.chartPosition=void 0),o&&!o.isHidden&&this.reset())},n.prototype.onContainerMouseEnter=function(r){delete this.chartPosition},n.prototype.onContainerMouseMove=function(r){var t=this.chart,o=this.normalize(r);this.setHoverChartIndex(),o.preventDefault||(o.returnValue=!1),(t.mouseIsDown==="mousedown"||this.touchSelect(o))&&this.drag(o),!t.openMenu&&(this.inClass(o.target,"highcharts-tracker")||t.isInsidePlot(o.chartX-t.plotLeft,o.chartY-t.plotTop,{visiblePlotOnly:!0}))&&(this.inClass(o.target,"highcharts-no-tooltip")?this.reset(!1,0):this.runPointActions(o))},n.prototype.onDocumentTouchEnd=function(r){var t=charts$3[pick$1j(n.hoverChartIndex,-1)];t&&t.pointer.drop(r)},n.prototype.onContainerTouchMove=function(r){this.touchSelect(r)?this.onContainerMouseMove(r):this.touch(r)},n.prototype.onContainerTouchStart=function(r){this.touchSelect(r)?this.onContainerMouseDown(r):(this.zoomOption(r),this.touch(r,!0))},n.prototype.onDocumentMouseMove=function(r){var t=this.chart,o=this.chartPosition,s=this.normalize(r,o),a=t.tooltip;o&&(!a||!a.isStickyOnContact())&&!t.isInsidePlot(s.chartX-t.plotLeft,s.chartY-t.plotTop,{visiblePlotOnly:!0})&&!this.inClass(s.target,"highcharts-tracker")&&this.reset()},n.prototype.onDocumentMouseUp=function(r){var t=charts$3[pick$1j(n.hoverChartIndex,-1)];t&&t.pointer.drop(r)},n.prototype.pinch=function(r){var t=this,o=t.chart,s=t.pinchDown,a=r.touches||[],l=a.length,h=t.lastValidTouch,c=t.hasZoom,d={},p=l===1&&(t.inClass(r.target,"highcharts-tracker")&&o.runTrackerClick||t.runChartClick),u={},f=t.selectionMarker;l>1?t.initiated=!0:l===1&&this.followTouchMove&&(t.initiated=!1),c&&t.initiated&&!p&&r.cancelable!==!1&&r.preventDefault(),[].map.call(a,function(g){return t.normalize(g)}),r.type==="touchstart"?([].forEach.call(a,function(g,v){s[v]={chartX:g.chartX,chartY:g.chartY}}),h.x=[s[0].chartX,s[1]&&s[1].chartX],h.y=[s[0].chartY,s[1]&&s[1].chartY],o.axes.forEach(function(g){if(g.zoomEnabled){var v=o.bounds[g.horiz?"h":"v"],m=g.minPixelPadding,x=g.toPixels(Math.min(pick$1j(g.options.min,g.dataMin),g.dataMin)),y=g.toPixels(Math.max(pick$1j(g.options.max,g.dataMax),g.dataMax)),b=Math.min(x,y),$=Math.max(x,y);v.min=Math.min(g.pos,b-m),v.max=Math.max(g.pos+g.len,$+m)}}),t.res=!0):t.followTouchMove&&l===1?this.runPointActions(t.normalize(r)):s.length&&(f||(t.selectionMarker=f=extend$1e({destroy:noop$j,touch:!0},o.plotBox)),t.pinchTranslate(s,a,d,f,u,h),t.hasPinched=c,t.scaleGroups(d,u),t.res&&(t.res=!1,this.reset(!1,0)))},n.prototype.pinchTranslate=function(r,t,o,s,a,l){this.zoomHor&&this.pinchTranslateDirection(!0,r,t,o,s,a,l),this.zoomVert&&this.pinchTranslateDirection(!1,r,t,o,s,a,l)},n.prototype.pinchTranslateDirection=function(r,t,o,s,a,l,h,c){var d=this.chart,p=r?"x":"y",u=r?"X":"Y",f="chart"+u,g=r?"width":"height",v=d["plot"+(r?"Left":"Top")],m=d.inverted,x=d.bounds[r?"h":"v"],y=t.length===1,b=t[0][f],$=!y&&t[1][f],S=function(){typeof T=="number"&&Math.abs(b-$)>20&&(E=c||Math.abs(M-T)/Math.abs(b-$)),P=(v-M)/E+b,k=d["plot"+(r?"Width":"Height")]/E},k,A,P,E=c||1,M=o[0][f],T=!y&&o[1][f],O;S(),A=P,A<x.min?(A=x.min,O=!0):A+k>x.max&&(A=x.max-k,O=!0),O?(M-=.8*(M-h[p][0]),typeof T=="number"&&(T-=.8*(T-h[p][1])),S()):h[p]=[M,T],m||(l[p]=P-v,l[g]=k);var L=m?r?"scaleY":"scaleX":"scale"+u,C=m?1/E:E;a[g]=k,a[p]=A,s[L]=E,s["translate"+u]=C*v+(M-C*b)},n.prototype.reset=function(r,t){var o=this,s=o.chart,a=s.hoverSeries,l=s.hoverPoint,h=s.hoverPoints,c=s.tooltip,d=c&&c.shared?h:l;r&&d&&splat$e(d).forEach(function(p){p.series.isCartesian&&typeof p.plotX>"u"&&(r=!1)}),r?c&&d&&splat$e(d).length&&(c.refresh(d),c.shared&&h?h.forEach(function(p){p.setState(p.state,!0),p.series.isCartesian&&(p.series.xAxis.crosshair&&p.series.xAxis.drawCrosshair(null,p),p.series.yAxis.crosshair&&p.series.yAxis.drawCrosshair(null,p))}):l&&(l.setState(l.state,!0),s.axes.forEach(function(p){p.crosshair&&l.series[p.coll]===p&&p.drawCrosshair(null,l)}))):(l&&l.onMouseOut(),h&&h.forEach(function(p){p.setState()}),a&&a.onMouseOut(),c&&c.hide(t),o.unDocMouseMove&&(o.unDocMouseMove=o.unDocMouseMove()),s.axes.forEach(function(p){p.hideCrosshair()}),o.hoverX=s.hoverPoints=s.hoverPoint=null)},n.prototype.runPointActions=function(r,t){var o=this,s=o.chart,a=s.series,l=s.tooltip&&s.tooltip.options.enabled?s.tooltip:void 0,h=l?l.shared:!1,c=t||s.hoverPoint,d=c&&c.series||s.hoverSeries,p=(!r||r.type!=="touchmove")&&(!!t||d&&d.directTouch&&o.isDirectTouch),u=this.getHoverData(c,d,a,p,h,r);c=u.hoverPoint,d=u.hoverSeries;var f=u.hoverPoints,g=d&&d.tooltipOptions.followPointer&&!d.tooltipOptions.split,v=h&&d&&!d.noSharedTooltip;if(c&&(c!==s.hoverPoint||l&&l.isHidden)){if((s.hoverPoints||[]).forEach(function(x){f.indexOf(x)===-1&&x.setState()}),s.hoverSeries!==d&&d.onMouseOver(),o.applyInactiveState(f),(f||[]).forEach(function(x){x.setState("hover")}),s.hoverPoint&&s.hoverPoint.firePointEvent("mouseOut"),!c.series)return;s.hoverPoints=f,s.hoverPoint=c,c.firePointEvent("mouseOver"),l&&l.refresh(v?f:c,r)}else if(g&&l&&!l.isHidden){var m=l.getAnchor([{}],r);s.isInsidePlot(m[0],m[1],{visiblePlotOnly:!0})&&l.updatePosition({plotX:m[0],plotY:m[1]})}o.unDocMouseMove||(o.unDocMouseMove=addEvent$W(s.container.ownerDocument,"mousemove",function(x){var y=charts$3[n.hoverChartIndex];y&&y.pointer.onDocumentMouseMove(x)}),o.eventsToUnbind.push(o.unDocMouseMove)),s.axes.forEach(function(y){var b=pick$1j((y.crosshair||{}).snap,!0),$;b&&($=s.hoverPoint,(!$||$.series[y.coll]!==y)&&($=find$i(f,function(S){return S.series[y.coll]===y}))),$||!b?y.drawCrosshair(r,$):y.hideCrosshair()})},n.prototype.scaleGroups=function(r,t){var o=this.chart;o.series.forEach(function(s){var a=r||s.getPlotBox();s.xAxis&&s.xAxis.zoomEnabled&&s.group&&(s.group.attr(a),s.markerGroup&&(s.markerGroup.attr(a),s.markerGroup.clip(t?o.clipRect:null)),s.dataLabelsGroup&&s.dataLabelsGroup.attr(a))}),o.clipRect.attr(t||o.clipBox)},n.prototype.setDOMEvents=function(){var r=this,t=this.chart.container,o=t.ownerDocument;t.onmousedown=this.onContainerMouseDown.bind(this),t.onmousemove=this.onContainerMouseMove.bind(this),t.onclick=this.onContainerClick.bind(this),this.eventsToUnbind.push(addEvent$W(t,"mouseenter",this.onContainerMouseEnter.bind(this))),this.eventsToUnbind.push(addEvent$W(t,"mouseleave",this.onContainerMouseLeave.bind(this))),n.unbindDocumentMouseUp||(n.unbindDocumentMouseUp=addEvent$W(o,"mouseup",this.onDocumentMouseUp.bind(this)));for(var s=this.chart.renderTo.parentElement;s&&s.tagName!=="BODY";)this.eventsToUnbind.push(addEvent$W(s,"scroll",function(){delete r.chartPosition})),s=s.parentElement;H.hasTouch&&(this.eventsToUnbind.push(addEvent$W(t,"touchstart",this.onContainerTouchStart.bind(this),{passive:!1})),this.eventsToUnbind.push(addEvent$W(t,"touchmove",this.onContainerTouchMove.bind(this),{passive:!1})),n.unbindDocumentTouchEnd||(n.unbindDocumentTouchEnd=addEvent$W(o,"touchend",this.onDocumentTouchEnd.bind(this),{passive:!1})))},n.prototype.setHoverChartIndex=function(){var r=this.chart,t=H.charts[pick$1j(n.hoverChartIndex,-1)];t&&t!==r&&t.pointer.onContainerMouseLeave({relatedTarget:!0}),(!t||!t.mouseIsDown)&&(n.hoverChartIndex=r.index)},n.prototype.touch=function(r,t){var o=this.chart,s,a,l;this.setHoverChartIndex(),r.touches.length===1?(r=this.normalize(r),l=o.isInsidePlot(r.chartX-o.plotLeft,r.chartY-o.plotTop,{visiblePlotOnly:!0}),l&&!o.openMenu?(t&&this.runPointActions(r),r.type==="touchmove"&&(a=this.pinchDown,s=a[0]?Math.sqrt(Math.pow(a[0].chartX-r.chartX,2)+Math.pow(a[0].chartY-r.chartY,2))>=4:!1),pick$1j(s,!0)&&this.pinch(r)):t&&this.reset()):r.touches.length===2&&this.pinch(r)},n.prototype.touchSelect=function(r){return!!(this.chart.options.chart.zoomBySingleTouch&&r.touches&&r.touches.length===1)},n.prototype.zoomOption=function(r){var t=this.chart,o=t.options.chart,s=t.inverted,a=o.zoomType||"",l,h;/touch/.test(r.type)&&(a=pick$1j(o.pinchType,a)),this.zoomX=l=/x/.test(a),this.zoomY=h=/y/.test(a),this.zoomHor=l&&!s||h&&s,this.zoomVert=h&&!s||l&&s,this.hasZoom=l||h},n}(),__extends$V=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),charts$2=H.charts,doc$h=H.doc,noop$i=H.noop,win$a=H.win,addEvent$V=Utilities.addEvent,css$7=Utilities.css,objectEach$o=Utilities.objectEach,removeEvent$7=Utilities.removeEvent,touches={},hasPointerEvent=!!win$a.PointerEvent;function getWebkitTouches(){var n=[];return n.item=function(r){return this[r]},objectEach$o(touches,function(r){n.push({pageX:r.pageX,pageY:r.pageY,target:r.target})}),n}function translateMSPointer(n,r,t,o){var s=charts$2[Pointer.hoverChartIndex||NaN];if((n.pointerType==="touch"||n.pointerType===n.MSPOINTER_TYPE_TOUCH)&&s){var a=s.pointer;o(n),a[r]({type:t,target:n.currentTarget,preventDefault:noop$i,touches:getWebkitTouches()})}}var MSPointer=function(n){__extends$V(r,n);function r(){return n!==null&&n.apply(this,arguments)||this}return r.isRequired=function(){return!!(!H.hasTouch&&(win$a.PointerEvent||win$a.MSPointerEvent))},r.prototype.batchMSEvents=function(t){t(this.chart.container,hasPointerEvent?"pointerdown":"MSPointerDown",this.onContainerPointerDown),t(this.chart.container,hasPointerEvent?"pointermove":"MSPointerMove",this.onContainerPointerMove),t(doc$h,hasPointerEvent?"pointerup":"MSPointerUp",this.onDocumentPointerUp)},r.prototype.destroy=function(){this.batchMSEvents(removeEvent$7),n.prototype.destroy.call(this)},r.prototype.init=function(t,o){n.prototype.init.call(this,t,o),this.hasZoom&&css$7(t.container,{"-ms-touch-action":"none","touch-action":"none"})},r.prototype.onContainerPointerDown=function(t){translateMSPointer(t,"onContainerTouchStart","touchstart",function(o){touches[o.pointerId]={pageX:o.pageX,pageY:o.pageY,target:o.currentTarget}})},r.prototype.onContainerPointerMove=function(t){translateMSPointer(t,"onContainerTouchMove","touchmove",function(o){touches[o.pointerId]={pageX:o.pageX,pageY:o.pageY},touches[o.pointerId].target||(touches[o.pointerId].target=o.currentTarget)})},r.prototype.onDocumentPointerUp=function(t){translateMSPointer(t,"onDocumentTouchEnd","touchend",function(o){delete touches[o.pointerId]})},r.prototype.setDOMEvents=function(){n.prototype.setDOMEvents.call(this),(this.hasZoom||this.followTouchMove)&&this.batchMSEvents(addEvent$V)},r}(Pointer),animObject$8=animationExports.animObject,setAnimation$4=animationExports.setAnimation,format$a=FormatUtilities.format,isFirefox$1=H.isFirefox,marginNames$1=H.marginNames,win$9=H.win,distribute$2=R.distribute,addEvent$U=Utilities.addEvent,createElement$6=Utilities.createElement,css$6=Utilities.css,defined$I=Utilities.defined,discardElement$4=Utilities.discardElement,find$h=Utilities.find,fireEvent$t=Utilities.fireEvent,isNumber$C=Utilities.isNumber,merge$1c=Utilities.merge,pick$1i=Utilities.pick,relativeLength$8=Utilities.relativeLength,stableSort$5=Utilities.stableSort,syncTimeout$4=Utilities.syncTimeout,wrap$c=Utilities.wrap,Legend=function(){function n(r,t){this.allItems=[],this.box=void 0,this.contentGroup=void 0,this.display=!1,this.group=void 0,this.initialItemY=0,this.itemHeight=0,this.itemMarginBottom=0,this.itemMarginTop=0,this.itemX=0,this.itemY=0,this.lastItemY=0,this.lastLineHeight=0,this.legendHeight=0,this.legendWidth=0,this.maxItemWidth=0,this.maxLegendWidth=0,this.offsetWidth=0,this.options={},this.padding=0,this.pages=[],this.proximate=!1,this.scrollGroup=void 0,this.symbolHeight=0,this.symbolWidth=0,this.titleHeight=0,this.totalItemWidth=0,this.widthOption=0,this.chart=r,this.init(r,t)}return n.prototype.init=function(r,t){this.chart=r,this.setOptions(t),t.enabled&&(this.render(),addEvent$U(this.chart,"endResize",function(){this.legend.positionCheckboxes()}),this.proximate?this.unchartrender=addEvent$U(this.chart,"render",function(){this.legend.proximatePositions(),this.legend.positionItems()}):this.unchartrender&&this.unchartrender())},n.prototype.setOptions=function(r){var t=pick$1i(r.padding,8);this.options=r,this.chart.styledMode||(this.itemStyle=r.itemStyle,this.itemHiddenStyle=merge$1c(this.itemStyle,r.itemHiddenStyle)),this.itemMarginTop=r.itemMarginTop||0,this.itemMarginBottom=r.itemMarginBottom||0,this.padding=t,this.initialItemY=t-5,this.symbolWidth=pick$1i(r.symbolWidth,16),this.pages=[],this.proximate=r.layout==="proximate"&&!this.chart.inverted,this.baseline=void 0},n.prototype.update=function(r,t){var o=this.chart;this.setOptions(merge$1c(!0,this.options,r)),this.destroy(),o.isDirtyLegend=o.isDirtyBox=!0,pick$1i(t,!0)&&o.redraw(),fireEvent$t(this,"afterUpdate")},n.prototype.colorizeItem=function(r,t){if(r.legendGroup[t?"removeClass":"addClass"]("highcharts-legend-item-hidden"),!this.chart.styledMode){var o=this,s=o.options,a=r.legendItem,l=r.legendLine,h=r.legendSymbol,c=o.itemHiddenStyle.color,d=t?s.itemStyle.color:c,p=t&&r.color||c,u=r.options&&r.options.marker,f={fill:p};a&&a.css({fill:d,color:d}),l&&l.attr({stroke:p}),h&&(u&&h.isMarker&&(f=r.pointAttribs(),t||(f.stroke=f.fill=c)),h.attr(f))}fireEvent$t(this,"afterColorizeItem",{item:r,visible:t})},n.prototype.positionItems=function(){this.allItems.forEach(this.positionItem,this),this.chart.isResizing||this.positionCheckboxes()},n.prototype.positionItem=function(r){var t=this,o=this,s=o.options,a=s.symbolPadding,l=!s.rtl,h=r._legendItemPos,c=h[0],d=h[1],p=r.checkbox,u=r.legendGroup;if(u&&u.element){var f={translateX:l?c:o.legendWidth-c-2*a-4,translateY:d},g=function(){fireEvent$t(t,"afterPositionItem",{item:r})};defined$I(u.translateY)?u.animate(f,void 0,g):(u.attr(f),g())}p&&(p.x=c,p.y=d)},n.prototype.destroyItem=function(r){var t=r.checkbox;["legendItem","legendLine","legendSymbol","legendGroup"].forEach(function(o){r[o]&&(r[o]=r[o].destroy())}),t&&discardElement$4(r.checkbox)},n.prototype.destroy=function(){function r(t){this[t]&&(this[t]=this[t].destroy())}this.getAllItems().forEach(function(t){["legendItem","legendGroup"].forEach(r,t)}),["clipRect","up","down","pager","nav","box","title","group"].forEach(r,this),this.display=null},n.prototype.positionCheckboxes=function(){var r=this.group&&this.group.alignAttr,t=this.clipHeight||this.legendHeight,o=this.titleHeight,s;r&&(s=r.translateY,this.allItems.forEach(function(a){var l=a.checkbox,h;l&&(h=s+o+l.y+(this.scrollOffset||0)+3,css$6(l,{left:r.translateX+a.checkboxOffset+l.x-20+"px",top:h+"px",display:this.proximate||h>s-6&&h<s+t-6?"":"none"}))},this))},n.prototype.renderTitle=function(){var r=this.options,t=this.padding,o=r.title,s,a=0;o.text&&(this.title||(this.title=this.chart.renderer.label(o.text,t-3,t-4,null,null,null,r.useHTML,null,"legend-title").attr({zIndex:1}),this.chart.styledMode||this.title.css(o.style),this.title.add(this.group)),o.width||this.title.css({width:this.maxLegendWidth+"px"}),s=this.title.getBBox(),a=s.height,this.offsetWidth=s.width,this.contentGroup.attr({translateY:a})),this.titleHeight=a},n.prototype.setText=function(r){var t=this.options;r.legendItem.attr({text:t.labelFormat?format$a(t.labelFormat,r,this.chart):t.labelFormatter.call(r)})},n.prototype.renderItem=function(r){var t=this,o=t.chart,s=o.renderer,a=t.options,l=a.layout==="horizontal",h=t.symbolWidth,c=a.symbolPadding||0,d=t.itemStyle,p=t.itemHiddenStyle,u=l?pick$1i(a.itemDistance,20):0,f=!a.rtl,g=!r.series,v=!g&&r.series.drawLegendSymbol?r.series:r,m=v.options,x=t.createCheckboxForItem&&m&&m.showCheckbox,y=a.useHTML,b=r.options.className,$=r.legendItem,S=h+c+u+(x?20:0);$||(r.legendGroup=s.g("legend-item").addClass("highcharts-"+v.type+"-series highcharts-color-"+r.colorIndex+(b?" "+b:"")+(g?" highcharts-series-"+r.index:"")).attr({zIndex:1}).add(t.scrollGroup),r.legendItem=$=s.text("",f?h+c:-c,t.baseline||0,y),o.styledMode||$.css(merge$1c(r.visible?d:p)),$.attr({align:f?"left":"right",zIndex:2}).add(r.legendGroup),t.baseline||(t.fontMetrics=s.fontMetrics(o.styledMode?12:d.fontSize,$),t.baseline=t.fontMetrics.f+3+t.itemMarginTop,$.attr("y",t.baseline),t.symbolHeight=a.symbolHeight||t.fontMetrics.f,a.squareSymbol&&(t.symbolWidth=pick$1i(a.symbolWidth,Math.max(t.symbolHeight,16)),S=t.symbolWidth+c+u+(x?20:0),f&&$.attr("x",t.symbolWidth+c))),v.drawLegendSymbol(t,r),t.setItemEvents&&t.setItemEvents(r,$,y)),x&&!r.checkbox&&t.createCheckboxForItem&&t.createCheckboxForItem(r),t.colorizeItem(r,r.visible),(o.styledMode||!d.width)&&$.css({width:(a.itemWidth||t.widthOption||o.spacingBox.width)-S+"px"}),t.setText(r);var k=$.getBBox();r.itemWidth=r.checkboxOffset=a.itemWidth||r.legendItemWidth||k.width+S,t.maxItemWidth=Math.max(t.maxItemWidth,r.itemWidth),t.totalItemWidth+=r.itemWidth,t.itemHeight=r.itemHeight=Math.round(r.legendItemHeight||k.height||t.symbolHeight)},n.prototype.layoutItem=function(r){var t=this.options,o=this.padding,s=t.layout==="horizontal",a=r.itemHeight,l=this.itemMarginBottom,h=this.itemMarginTop,c=s?pick$1i(t.itemDistance,20):0,d=this.maxLegendWidth,p=t.alignColumns&&this.totalItemWidth>d?this.maxItemWidth:r.itemWidth;s&&this.itemX-o+p>d&&(this.itemX=o,this.lastLineHeight&&(this.itemY+=h+this.lastLineHeight+l),this.lastLineHeight=0),this.lastItemY=h+this.itemY+l,this.lastLineHeight=Math.max(a,this.lastLineHeight),r._legendItemPos=[this.itemX,this.itemY],s?this.itemX+=p:(this.itemY+=h+a+l,this.lastLineHeight=a),this.offsetWidth=this.widthOption||Math.max((s?this.itemX-o-(r.checkbox?0:c):p)+o,this.offsetWidth)},n.prototype.getAllItems=function(){var r=[];return this.chart.series.forEach(function(t){var o=t&&t.options;t&&pick$1i(o.showInLegend,defined$I(o.linkedTo)?!1:void 0,!0)&&(r=r.concat(t.legendItems||(o.legendType==="point"?t.data:t)))}),fireEvent$t(this,"afterGetAllItems",{allItems:r}),r},n.prototype.getAlignment=function(){var r=this.options;return this.proximate?r.align.charAt(0)+"tv":r.floating?"":r.align.charAt(0)+r.verticalAlign.charAt(0)+r.layout.charAt(0)},n.prototype.adjustMargins=function(r,t){var o=this.chart,s=this.options,a=this.getAlignment();a&&[/(lth|ct|rth)/,/(rtv|rm|rbv)/,/(rbh|cb|lbh)/,/(lbv|lm|ltv)/].forEach(function(l,h){l.test(a)&&!defined$I(r[h])&&(o[marginNames$1[h]]=Math.max(o[marginNames$1[h]],o.legend[(h+1)%2?"legendHeight":"legendWidth"]+[1,-1,-1,1][h]*s[h%2?"x":"y"]+pick$1i(s.margin,12)+t[h]+(o.titleOffset[h]||0)))})},n.prototype.proximatePositions=function(){var r=this.chart,t=[],o=this.options.align==="left";this.allItems.forEach(function(s){var a,l,h=o,c,d;s.yAxis&&(s.xAxis.options.reversed&&(h=!h),s.points&&(a=find$h(h?s.points:s.points.slice(0).reverse(),function(p){return isNumber$C(p.plotY)})),l=this.itemMarginTop+s.legendItem.getBBox().height+this.itemMarginBottom,d=s.yAxis.top-r.plotTop,s.visible?(c=a?a.plotY:s.yAxis.height,c+=d-.3*l):c=d+s.yAxis.height,t.push({target:c,size:l,item:s}))},this),distribute$2(t,r.plotHeight).forEach(function(s){s.item._legendItemPos&&(s.item._legendItemPos[1]=r.plotTop-r.spacing[0]+s.pos)})},n.prototype.render=function(){var r=this,t=r.chart,o=t.renderer,s=r.options,a=r.padding,l=r.getAllItems(),h,c,d,p=r.group,u,f=r.box;r.itemX=a,r.itemY=r.initialItemY,r.offsetWidth=0,r.lastItemY=0,r.widthOption=relativeLength$8(s.width,t.spacingBox.width-a),u=t.spacingBox.width-2*a-s.x,["rm","lm"].indexOf(r.getAlignment().substring(0,2))>-1&&(u/=2),r.maxLegendWidth=r.widthOption||u,p||(r.group=p=o.g("legend").addClass(s.className||"").attr({zIndex:7}).add(),r.contentGroup=o.g().attr({zIndex:1}).add(p),r.scrollGroup=o.g().add(r.contentGroup)),r.renderTitle(),stableSort$5(l,function(g,v){return(g.options&&g.options.legendIndex||0)-(v.options&&v.options.legendIndex||0)}),s.reversed&&l.reverse(),r.allItems=l,r.display=h=!!l.length,r.lastLineHeight=0,r.maxItemWidth=0,r.totalItemWidth=0,r.itemHeight=0,l.forEach(r.renderItem,r),l.forEach(r.layoutItem,r),c=(r.widthOption||r.offsetWidth)+a,d=r.lastItemY+r.lastLineHeight+r.titleHeight,d=r.handleOverflow(d),d+=a,f||(r.box=f=o.rect().addClass("highcharts-legend-box").attr({r:s.borderRadius}).add(p),f.isNew=!0),t.styledMode||f.attr({stroke:s.borderColor,"stroke-width":s.borderWidth||0,fill:s.backgroundColor||"none"}).shadow(s.shadow),c>0&&d>0&&(f[f.isNew?"attr":"animate"](f.crisp.call({},{x:0,y:0,width:c,height:d},f.strokeWidth())),f.isNew=!1),f[h?"show":"hide"](),t.styledMode&&p.getStyle("display")==="none"&&(c=d=0),r.legendWidth=c,r.legendHeight=d,h&&r.align(),this.proximate||this.positionItems(),fireEvent$t(this,"afterRender")},n.prototype.align=function(r){r===void 0&&(r=this.chart.spacingBox);var t=this.chart,o=this.options,s=r.y;/(lth|ct|rth)/.test(this.getAlignment())&&t.titleOffset[0]>0?s+=t.titleOffset[0]:/(lbh|cb|rbh)/.test(this.getAlignment())&&t.titleOffset[2]>0&&(s-=t.titleOffset[2]),s!==r.y&&(r=merge$1c(r,{y:s})),this.group.align(merge$1c(o,{width:this.legendWidth,height:this.legendHeight,verticalAlign:this.proximate?"top":o.verticalAlign}),!0,r)},n.prototype.handleOverflow=function(r){var t=this,o=this.chart,s=o.renderer,a=this.options,l=a.y,h=a.verticalAlign==="top",c=this.padding,d=a.maxHeight,p=a.navigation,u=pick$1i(p.animation,!0),f=p.arrowSize||12,g=this.pages,v=this.allItems,m=function(A){typeof A=="number"?k.attr({height:A}):k&&(t.clipRect=k.destroy(),t.contentGroup.clip()),t.contentGroup.div&&(t.contentGroup.div.style.clip=A?"rect("+c+"px,9999px,"+(c+A)+"px,0)":"auto")},x=function(A){return t[A]=s.circle(0,0,f*1.3).translate(f/2,f/2).add(S),o.styledMode||t[A].attr("fill","rgba(0,0,0,0.0001)"),t[A]},y,b,$=o.spacingBox.height+(h?-l:l)-c,S=this.nav,k=this.clipRect;return a.layout==="horizontal"&&a.verticalAlign!=="middle"&&!a.floating&&($/=2),d&&($=Math.min($,d)),g.length=0,r&&$>0&&r>$&&p.enabled!==!1?(this.clipHeight=y=Math.max($-20-this.titleHeight-c,0),this.currentPage=pick$1i(this.currentPage,1),this.fullHeight=r,v.forEach(function(A,P){var E=A._legendItemPos[1],M=Math.round(A.legendItem.getBBox().height),T=g.length;(!T||E-g[T-1]>y&&(b||E)!==g[T-1])&&(g.push(b||E),T++),A.pageIx=T-1,b&&(v[P-1].pageIx=T-1),P===v.length-1&&E+M-g[T-1]>y&&E!==b&&(g.push(E),A.pageIx=T),E!==b&&(b=E)}),k||(k=t.clipRect=s.clipRect(0,c,9999,0),t.contentGroup.clip(k)),m(y),S||(this.nav=S=s.g().attr({zIndex:1}).add(this.group),this.up=s.symbol("triangle",0,0,f,f).add(S),x("upTracker").on("click",function(){t.scroll(-1,u)}),this.pager=s.text("",15,10).addClass("highcharts-legend-navigation"),o.styledMode||this.pager.css(p.style),this.pager.add(S),this.down=s.symbol("triangle-down",0,0,f,f).add(S),x("downTracker").on("click",function(){t.scroll(1,u)})),t.scroll(0),r=$):S&&(m(),this.nav=S.destroy(),this.scrollGroup.attr({translateY:1}),this.clipHeight=0),r},n.prototype.scroll=function(r,t){var o=this,s=this.chart,a=this.pages,l=a.length,h=this.clipHeight,c=this.options.navigation,d=this.pager,p=this.padding,u=this.currentPage+r;if(u>l&&(u=l),u>0){typeof t<"u"&&setAnimation$4(t,s),this.nav.attr({translateX:p,translateY:h+this.padding+7+this.titleHeight,visibility:"visible"}),[this.up,this.upTracker].forEach(function(g){g.attr({class:u===1?"highcharts-legend-nav-inactive":"highcharts-legend-nav-active"})}),d.attr({text:u+"/"+l}),[this.down,this.downTracker].forEach(function(g){g.attr({x:18+this.pager.getBBox().width,class:u===l?"highcharts-legend-nav-inactive":"highcharts-legend-nav-active"})},this),s.styledMode||(this.up.attr({fill:u===1?c.inactiveColor:c.activeColor}),this.upTracker.css({cursor:u===1?"default":"pointer"}),this.down.attr({fill:u===l?c.inactiveColor:c.activeColor}),this.downTracker.css({cursor:u===l?"default":"pointer"})),this.scrollOffset=-a[u-1]+this.initialItemY,this.scrollGroup.animate({translateY:this.scrollOffset}),this.currentPage=u,this.positionCheckboxes();var f=animObject$8(pick$1i(t,s.renderer.globalAnimation,!0));syncTimeout$4(function(){fireEvent$t(o,"afterScroll",{currentPage:u})},f.duration)}},n.prototype.setItemEvents=function(r,t,o){var s=this,a=s.chart.renderer.boxWrapper,l=r instanceof Point$2,h="highcharts-legend-"+(l?"point":"series")+"-active",c=s.chart.styledMode,d=o?[t,r.legendSymbol]:[r.legendGroup],p=function(u){s.allItems.forEach(function(f){r!==f&&[f].concat(f.linkedSeries||[]).forEach(function(g){g.setState(u,!l)})})};d.forEach(function(u){u&&u.on("mouseover",function(){r.visible&&p("inactive"),r.setState("hover"),r.visible&&a.addClass(h),c||t.css(s.options.itemHoverStyle)}).on("mouseout",function(){s.chart.styledMode||t.css(merge$1c(r.visible?s.itemStyle:s.itemHiddenStyle)),p(""),a.removeClass(h),r.setState()}).on("click",function(f){var g="legendItemClick",v=function(){r.setVisible&&r.setVisible(),p(r.visible?"inactive":"")};a.removeClass(h),f={browserEvent:f},r.firePointEvent?r.firePointEvent(g,f,v):fireEvent$t(r,g,f,v)})})},n.prototype.createCheckboxForItem=function(r){var t=this;r.checkbox=createElement$6("input",{type:"checkbox",className:"highcharts-legend-checkbox",checked:r.selected,defaultChecked:r.selected},t.options.itemCheckboxStyle,t.chart.container),addEvent$U(r.checkbox,"click",function(o){var s=o.target;fireEvent$t(r.series||r,"checkboxClick",{checked:s.checked,item:r},function(){r.select()})})},n}();(/Trident\/7\.0/.test(win$9.navigator&&win$9.navigator.userAgent)||isFirefox$1)&&wrap$c(Legend.prototype,"positionItem",function(n,r){var t=this,o=function(){r._legendItemPos&&n.call(t,r)};o(),t.bubbleLegend||setTimeout(o)});var defaultOptions$b=DefaultOptions.defaultOptions,error$6=Utilities.error,extendClass$1=Utilities.extendClass,merge$1b=Utilities.merge,SeriesRegistry;(function(n){n.seriesTypes=H.seriesTypes;function r(s,a){a===void 0&&(a={});var l=s.options.chart,h=a.type||l.type||l.defaultSeriesType||"",c=n.seriesTypes[h];n||error$6(17,!0,s,{missingModuleFor:h});var d=new c;return typeof d.init=="function"&&d.init(s,a),d}n.getSeries=r;function t(s,a){var l=defaultOptions$b.plotOptions||{},h=a.defaultOptions;a.prototype.pointClass||(a.prototype.pointClass=Point$2),a.prototype.type=s,h&&(l[s]=h),n.seriesTypes[s]=a}n.registerSeriesType=t;function o(s,a,l,h,c){var d=defaultOptions$b.plotOptions||{};return a=a||"",d[s]=merge$1b(d[a],l),t(s,extendClass$1(n.seriesTypes[a]||function(){},h)),n.seriesTypes[s].prototype.type=s,c&&(n.seriesTypes[s].prototype.pointClass=extendClass$1(Point$2,c)),n.seriesTypes[s]}n.seriesType=o})(SeriesRegistry||(SeriesRegistry={}));const SeriesRegistry$1=SeriesRegistry;var animate=animationExports.animate,animObject$7=animationExports.animObject,setAnimation$3=animationExports.setAnimation,numberFormat$1=FormatUtilities.numberFormat,registerEventOptions$1=exports$3.registerEventOptions,charts$1=H.charts,doc$g=H.doc,marginNames=H.marginNames,svg$3=H.svg,win$8=H.win,defaultOptions$a=DefaultOptions.defaultOptions,defaultTime=DefaultOptions.defaultTime,seriesTypes$7=SeriesRegistry$1.seriesTypes,addEvent$T=Utilities.addEvent,attr$1=Utilities.attr,cleanRecursively$1=Utilities.cleanRecursively,createElement$5=Utilities.createElement,css$5=Utilities.css,defined$H=Utilities.defined,discardElement$3=Utilities.discardElement,erase$3=Utilities.erase,error$5=Utilities.error,extend$1d=Utilities.extend,find$g=Utilities.find,fireEvent$s=Utilities.fireEvent,getStyle=Utilities.getStyle,isArray$g=Utilities.isArray,isNumber$B=Utilities.isNumber,isObject$9=Utilities.isObject,isString$5=Utilities.isString,merge$1a=Utilities.merge,objectEach$n=Utilities.objectEach,pick$1h=Utilities.pick,pInt$4=Utilities.pInt,relativeLength$7=Utilities.relativeLength,removeEvent$6=Utilities.removeEvent,splat$d=Utilities.splat,syncTimeout$3=Utilities.syncTimeout,uniqueKey$4=Utilities.uniqueKey,Chart$1=function(){function n(r,t,o){this.axes=void 0,this.axisOffset=void 0,this.bounds=void 0,this.chartHeight=void 0,this.chartWidth=void 0,this.clipBox=void 0,this.colorCounter=void 0,this.container=void 0,this.eventOptions=void 0,this.index=void 0,this.isResizing=void 0,this.labelCollectors=void 0,this.legend=void 0,this.margin=void 0,this.numberFormatter=void 0,this.options=void 0,this.plotBox=void 0,this.plotHeight=void 0,this.plotLeft=void 0,this.plotTop=void 0,this.plotWidth=void 0,this.pointCount=void 0,this.pointer=void 0,this.renderer=void 0,this.renderTo=void 0,this.series=void 0,this.sharedClips={},this.spacing=void 0,this.spacingBox=void 0,this.symbolCounter=void 0,this.time=void 0,this.titleOffset=void 0,this.userOptions=void 0,this.xAxis=void 0,this.yAxis=void 0,this.getArgs(r,t,o)}return n.chart=function(r,t,o){return new n(r,t,o)},n.prototype.getArgs=function(r,t,o){isString$5(r)||r.nodeName?(this.renderTo=r,this.init(t,o)):this.init(r,t)},n.prototype.init=function(r,t){var o=r.plotOptions||{};fireEvent$s(this,"init",{args:arguments},function(){var s=merge$1a(defaultOptions$a,r),a=s.chart;objectEach$n(s.plotOptions,function(h,c){isObject$9(h)&&(h.tooltip=o[c]&&merge$1a(o[c].tooltip)||void 0)}),s.tooltip.userOptions=r.chart&&r.chart.forExport&&r.tooltip.userOptions||r.tooltip,this.userOptions=r,this.margin=[],this.spacing=[],this.bounds={h:{},v:{}},this.labelCollectors=[],this.callback=t,this.isResizing=0,this.options=s,this.axes=[],this.series=[],this.time=r.time&&Object.keys(r.time).length?new Time(r.time):H.time,this.numberFormatter=a.numberFormatter||numberFormat$1,this.styledMode=a.styledMode,this.hasCartesianSeries=a.showAxes;var l=this;l.index=charts$1.length,charts$1.push(l),H.chartCount++,registerEventOptions$1(this,a),l.xAxis=[],l.yAxis=[],l.pointCount=l.colorCounter=l.symbolCounter=0,fireEvent$s(l,"afterInit"),l.firstRender()})},n.prototype.initSeries=function(r){var t=this,o=t.options.chart,s=r.type||o.type||o.defaultSeriesType,a=seriesTypes$7[s];a||error$5(17,!0,t,{missingModuleFor:s});var l=new a;return typeof l.init=="function"&&l.init(t,r),l},n.prototype.setSeriesData=function(){this.getSeriesOrderByLinks().forEach(function(r){!r.points&&!r.data&&r.enabledDataSorting&&r.setData(r.options.data,!1)})},n.prototype.getSeriesOrderByLinks=function(){return this.series.concat().sort(function(r,t){return r.linkedSeries.length||t.linkedSeries.length?t.linkedSeries.length-r.linkedSeries.length:0})},n.prototype.orderSeries=function(r){for(var t=this.series,o=r||0,s=t.length;o<s;++o)t[o]&&(t[o].index=o,t[o].name=t[o].getName())},n.prototype.isInsidePlot=function(r,t,o){var s;o===void 0&&(o={});var a=this,l=a.inverted,h=a.plotBox,c=a.plotLeft,d=a.plotTop,p=a.scrollablePlotBox,u=0,f=0;o.visiblePlotOnly&&this.scrollingContainer&&(s=this.scrollingContainer,u=s.scrollLeft,f=s.scrollTop);var g=o.series,v=o.visiblePlotOnly&&p||h,m=o.inverted?t:r,x=o.inverted?r:t,y={x:m,y:x,isInsidePlot:!0};if(!o.ignoreX){var b=g&&(l?g.yAxis:g.xAxis)||{pos:c,len:1/0},$=o.paneCoordinates?b.pos+m:c+m;$>=Math.max(u+c,b.pos)&&$<=Math.min(u+c+v.width,b.pos+b.len)||(y.isInsidePlot=!1)}if(!o.ignoreY&&y.isInsidePlot){var S=g&&(l?g.xAxis:g.yAxis)||{pos:d,len:1/0},k=o.paneCoordinates?S.pos+x:d+x;k>=Math.max(f+d,S.pos)&&k<=Math.min(f+d+v.height,S.pos+S.len)||(y.isInsidePlot=!1)}return fireEvent$s(this,"afterIsInsidePlot",y),y.isInsidePlot},n.prototype.redraw=function(r){fireEvent$s(this,"beforeRedraw");var t=this,o=t.hasCartesianSeries?t.axes:t.colorAxis||[],s=t.series,a=t.pointer,l=t.legend,h=t.userOptions.legend,c=t.renderer,d=c.isHidden(),p=[],u,f,g,v=t.isDirtyBox,m=t.isDirtyLegend,x;for(t.setResponsive&&t.setResponsive(!1),setAnimation$3(t.hasRendered?r:!1,t),d&&t.temporaryDisplay(),t.layOutTitles(),g=s.length;g--;)if(x=s[g],(x.options.stacking||x.options.centerInCategory)&&(f=!0,x.isDirty)){u=!0;break}if(u)for(g=s.length;g--;)x=s[g],x.options.stacking&&(x.isDirty=!0);s.forEach(function(y){y.isDirty&&(y.options.legendType==="point"?(typeof y.updateTotals=="function"&&y.updateTotals(),m=!0):h&&(h.labelFormatter||h.labelFormat)&&(m=!0)),y.isDirtyData&&fireEvent$s(y,"updatedData")}),m&&l&&l.options.enabled&&(l.render(),t.isDirtyLegend=!1),f&&t.getStacks(),o.forEach(function(y){y.updateNames(),y.setScale()}),t.getMargins(),o.forEach(function(y){y.isDirty&&(v=!0)}),o.forEach(function(y){var b=y.min+","+y.max;y.extKey!==b&&(y.extKey=b,p.push(function(){fireEvent$s(y,"afterSetExtremes",extend$1d(y.eventArgs,y.getExtremes())),delete y.eventArgs})),(v||f)&&y.redraw()}),v&&t.drawChartBox(),fireEvent$s(t,"predraw"),s.forEach(function(y){(v||y.isDirty)&&y.visible&&y.redraw(),y.isDirtyData=!1}),a&&a.reset(!0),c.draw(),fireEvent$s(t,"redraw"),fireEvent$s(t,"render"),d&&t.temporaryDisplay(!0),p.forEach(function(y){y.call()})},n.prototype.get=function(r){var t=this.series;function o(l){return l.id===r||l.options&&l.options.id===r}for(var s=find$g(this.axes,o)||find$g(this.series,o),a=0;!s&&a<t.length;a++)s=find$g(t[a].points||[],o);return s},n.prototype.getAxes=function(){var r=this,t=this.options,o=t.xAxis=splat$d(t.xAxis||{}),s=t.yAxis=splat$d(t.yAxis||{});fireEvent$s(this,"getAxes"),o.forEach(function(l,h){l.index=h,l.isX=!0}),s.forEach(function(l,h){l.index=h});var a=o.concat(s);a.forEach(function(l){new Axis(r,l)}),fireEvent$s(this,"afterGetAxes")},n.prototype.getSelectedPoints=function(){return this.series.reduce(function(r,t){return t.getPointsCollection().forEach(function(o){pick$1h(o.selectedStaging,o.selected)&&r.push(o)}),r},[])},n.prototype.getSelectedSeries=function(){return this.series.filter(function(r){return r.selected})},n.prototype.setTitle=function(r,t,o){this.applyDescription("title",r),this.applyDescription("subtitle",t),this.applyDescription("caption",void 0),this.layOutTitles(o)},n.prototype.applyDescription=function(r,t){var o=this,s=r==="title"?{color:palette.neutralColor80,fontSize:this.options.isStock?"16px":"18px"}:{color:palette.neutralColor60},a=this.options[r]=merge$1a(!this.styledMode&&{style:s},this.options[r],t),l=this[r];l&&t&&(this[r]=l=l.destroy()),a&&!l&&(l=this.renderer.text(a.text,0,0,a.useHTML).attr({align:a.align,class:"highcharts-"+r,zIndex:a.zIndex||4}).add(),l.update=function(h){var c={title:"setTitle",subtitle:"setSubtitle",caption:"setCaption"}[r];o[c](h)},this.styledMode||l.css(a.style),this[r]=l)},n.prototype.layOutTitles=function(r){var t=[0,0,0],o=this.renderer,s=this.spacingBox;["title","subtitle","caption"].forEach(function(l){var h=this[l],c=this.options[l],d=c.verticalAlign||"top",p=l==="title"?d==="top"?-3:0:d==="top"?t[0]+2:0,u,f;h&&(this.styledMode||(u=c.style&&c.style.fontSize),u=o.fontMetrics(u,h).b,h.css({width:(c.width||s.width+(c.widthAdjust||0))+"px"}),f=Math.round(h.getBBox(c.useHTML).height),h.align(extend$1d({y:d==="bottom"?u:p+u,height:f},c),!1,"spacingBox"),c.floating||(d==="top"?t[0]=Math.ceil(t[0]+f):d==="bottom"&&(t[2]=Math.ceil(t[2]+f))))},this),t[0]&&(this.options.title.verticalAlign||"top")==="top"&&(t[0]+=this.options.title.margin),t[2]&&this.options.caption.verticalAlign==="bottom"&&(t[2]+=this.options.caption.margin);var a=!this.titleOffset||this.titleOffset.join(",")!==t.join(",");this.titleOffset=t,fireEvent$s(this,"afterLayOutTitles"),!this.isDirtyBox&&a&&(this.isDirtyBox=this.isDirtyLegend=a,this.hasRendered&&pick$1h(r,!0)&&this.isDirtyBox&&this.redraw())},n.prototype.getChartSize=function(){var r=this,t=r.options.chart,o=t.width,s=t.height,a=r.renderTo;defined$H(o)||(r.containerWidth=getStyle(a,"width")),defined$H(s)||(r.containerHeight=getStyle(a,"height")),r.chartWidth=Math.max(0,o||r.containerWidth||600),r.chartHeight=Math.max(0,relativeLength$7(s,r.chartWidth)||(r.containerHeight>1?r.containerHeight:400))},n.prototype.temporaryDisplay=function(r){var t=this.renderTo,o;if(r)for(;t&&t.style;)t.hcOrigStyle&&(css$5(t,t.hcOrigStyle),delete t.hcOrigStyle),t.hcOrigDetached&&(doc$g.body.removeChild(t),t.hcOrigDetached=!1),t=t.parentNode;else for(;t&&t.style&&(!doc$g.body.contains(t)&&!t.parentNode&&(t.hcOrigDetached=!0,doc$g.body.appendChild(t)),(getStyle(t,"display",!1)==="none"||t.hcOricDetached)&&(t.hcOrigStyle={display:t.style.display,height:t.style.height,overflow:t.style.overflow},o={display:"block",overflow:"hidden"},t!==this.renderTo&&(o.height=0),css$5(t,o),t.offsetWidth||t.style.setProperty("display","block","important")),t=t.parentNode,t!==doc$g.body););},n.prototype.setClassName=function(r){this.container.className="highcharts-container "+(r||"")},n.prototype.getContainer=function(){var r=this,t=r.options,o=t.chart,s="data-highcharts-chart",a=uniqueKey$4(),l,h=r.renderTo;h||(r.renderTo=h=o.renderTo),isString$5(h)&&(r.renderTo=h=doc$g.getElementById(h)),h||error$5(13,!0,r);var c=pInt$4(attr$1(h,s));isNumber$B(c)&&charts$1[c]&&charts$1[c].hasRendered&&charts$1[c].destroy(),attr$1(h,s,r.index),h.innerHTML="",!o.skipClone&&!h.offsetWidth&&r.temporaryDisplay(),r.getChartSize();var d=r.chartWidth,p=r.chartHeight;css$5(h,{overflow:"hidden"}),r.styledMode||(l=extend$1d({position:"relative",overflow:"hidden",width:d+"px",height:p+"px",textAlign:"left",lineHeight:"normal",zIndex:0,"-webkit-tap-highlight-color":"rgba(0,0,0,0)",userSelect:"none","touch-action":"manipulation",outline:"none"},o.style||{}));var u=createElement$5("div",{id:a},l,h);r.container=u,r._cursor=u.style.cursor;var f=o.renderer||!svg$3?RendererRegistry$1.getRendererType(o.renderer):SVGRenderer;if(r.renderer=new f(u,d,p,void 0,o.forExport,t.exporting&&t.exporting.allowHTML,r.styledMode),setAnimation$3(void 0,r),r.setClassName(o.className),!r.styledMode)r.renderer.setStyle(o.style);else for(var g in t.defs)this.renderer.definition(t.defs[g]);r.renderer.chartIndex=r.index,fireEvent$s(this,"afterGetContainer")},n.prototype.getMargins=function(r){var t=this,o=t.spacing,s=t.margin,a=t.titleOffset;this.resetMargins(),a[0]&&!defined$H(s[0])&&(this.plotTop=Math.max(this.plotTop,a[0]+o[0])),a[2]&&!defined$H(s[2])&&(this.marginBottom=Math.max(this.marginBottom,a[2]+o[2])),this.legend&&this.legend.display&&this.legend.adjustMargins(s,o),fireEvent$s(this,"getMargins"),r||this.getAxisMargins()},n.prototype.getAxisMargins=function(){var r=this,t=r.axisOffset=[0,0,0,0],o=r.colorAxis,s=r.margin,a=function(l){l.forEach(function(h){h.visible&&h.getOffset()})};r.hasCartesianSeries?a(r.axes):o&&o.length&&a(o),marginNames.forEach(function(l,h){defined$H(s[h])||(r[l]+=t[h])}),r.setChartSize()},n.prototype.reflow=function(r){var t=this,o=t.options.chart,s=t.renderTo,a=defined$H(o.width)&&defined$H(o.height),l=o.width||getStyle(s,"width"),h=o.height||getStyle(s,"height"),c=r?r.target:win$8;delete t.pointer.chartPosition,!a&&!t.isPrinting&&l&&h&&(c===win$8||c===doc$g)&&((l!==t.containerWidth||h!==t.containerHeight)&&(Utilities.clearTimeout(t.reflowTimeout),t.reflowTimeout=syncTimeout$3(function(){t.container&&t.setSize(void 0,void 0,!1)},r?100:0)),t.containerWidth=l,t.containerHeight=h)},n.prototype.setReflow=function(r){var t=this;r!==!1&&!this.unbindReflow?(this.unbindReflow=addEvent$T(win$8,"resize",function(o){t.options&&t.reflow(o)}),addEvent$T(this,"destroy",this.unbindReflow)):r===!1&&this.unbindReflow&&(this.unbindReflow=this.unbindReflow())},n.prototype.setSize=function(r,t,o){var s=this,a=s.renderer;s.isResizing+=1,setAnimation$3(o,s);var l=a.globalAnimation;s.oldChartHeight=s.chartHeight,s.oldChartWidth=s.chartWidth,typeof r<"u"&&(s.options.chart.width=r),typeof t<"u"&&(s.options.chart.height=t),s.getChartSize(),s.styledMode||(l?animate:css$5)(s.container,{width:s.chartWidth+"px",height:s.chartHeight+"px"},l),s.setChartSize(!0),a.setSize(s.chartWidth,s.chartHeight,l),s.axes.forEach(function(h){h.isDirty=!0,h.setScale()}),s.isDirtyLegend=!0,s.isDirtyBox=!0,s.layOutTitles(),s.getMargins(),s.redraw(l),s.oldChartHeight=null,fireEvent$s(s,"resize"),syncTimeout$3(function(){s&&fireEvent$s(s,"endResize",null,function(){s.isResizing-=1})},animObject$7(l).duration)},n.prototype.setChartSize=function(r){var t=this,o=t.inverted,s=t.renderer,a=t.chartWidth,l=t.chartHeight,h=t.options.chart,c=t.spacing,d=t.clipOffset,p,u,f,g;t.plotLeft=p=Math.round(t.plotLeft),t.plotTop=u=Math.round(t.plotTop),t.plotWidth=f=Math.max(0,Math.round(a-p-t.marginRight)),t.plotHeight=g=Math.max(0,Math.round(l-u-t.marginBottom)),t.plotSizeX=o?g:f,t.plotSizeY=o?f:g,t.plotBorderWidth=h.plotBorderWidth||0,t.spacingBox=s.spacingBox={x:c[3],y:c[0],width:a-c[3]-c[1],height:l-c[0]-c[2]},t.plotBox=s.plotBox={x:p,y:u,width:f,height:g};var v=2*Math.floor(t.plotBorderWidth/2),m=Math.ceil(Math.max(v,d[3])/2),x=Math.ceil(Math.max(v,d[0])/2);t.clipBox={x:m,y:x,width:Math.floor(t.plotSizeX-Math.max(v,d[1])/2-m),height:Math.max(0,Math.floor(t.plotSizeY-Math.max(v,d[2])/2-x))},r||(t.axes.forEach(function(y){y.setAxisSize(),y.setAxisTranslation()}),s.alignElements()),fireEvent$s(t,"afterSetChartSize",{skipAxes:r})},n.prototype.resetMargins=function(){fireEvent$s(this,"resetMargins");var r=this,t=r.options.chart;["margin","spacing"].forEach(function(s){var a=t[s],l=isObject$9(a)?a:[a,a,a,a];["Top","Right","Bottom","Left"].forEach(function(h,c){r[s][c]=pick$1h(t[s+h],l[c])})}),marginNames.forEach(function(o,s){r[o]=pick$1h(r.margin[s],r.spacing[s])}),r.axisOffset=[0,0,0,0],r.clipOffset=[0,0,0,0]},n.prototype.drawChartBox=function(){var r=this,t=r.options.chart,o=r.renderer,s=r.chartWidth,a=r.chartHeight,l=r.styledMode,h=r.plotBGImage,c=t.backgroundColor,d=t.plotBackgroundColor,p=t.plotBackgroundImage,u=r.plotLeft,f=r.plotTop,g=r.plotWidth,v=r.plotHeight,m=r.plotBox,x=r.clipRect,y=r.clipBox,b=r.chartBackground,$=r.plotBackground,S=r.plotBorder,k,A,P,E="animate";b||(r.chartBackground=b=o.rect().addClass("highcharts-background").add(),E="attr"),l?k=A=b.strokeWidth():(k=t.borderWidth||0,A=k+(t.shadow?8:0),P={fill:c||"none"},(k||b["stroke-width"])&&(P.stroke=t.borderColor,P["stroke-width"]=k),b.attr(P).shadow(t.shadow)),b[E]({x:A/2,y:A/2,width:s-A-k%2,height:a-A-k%2,r:t.borderRadius}),E="animate",$||(E="attr",r.plotBackground=$=o.rect().addClass("highcharts-plot-background").add()),$[E](m),l||($.attr({fill:d||"none"}).shadow(t.plotShadow),p&&(h?(p!==h.attr("href")&&h.attr("href",p),h.animate(m)):r.plotBGImage=o.image(p,u,f,g,v).add())),x?x.animate({width:y.width,height:y.height}):r.clipRect=o.clipRect(y),E="animate",S||(E="attr",r.plotBorder=S=o.rect().addClass("highcharts-plot-border").attr({zIndex:1}).add()),l||S.attr({stroke:t.plotBorderColor,"stroke-width":t.plotBorderWidth||0,fill:"none"}),S[E](S.crisp({x:u,y:f,width:g,height:v},-S.strokeWidth())),r.isDirtyBox=!1,fireEvent$s(this,"afterDrawChartBox")},n.prototype.propFromSeries=function(){var r=this,t=r.options.chart,o=r.options.series,s,a,l;["inverted","angular","polar"].forEach(function(h){for(a=seriesTypes$7[t.type||t.defaultSeriesType],l=t[h]||a&&a.prototype[h],s=o&&o.length;!l&&s--;)a=seriesTypes$7[o[s].type],a&&a.prototype[h]&&(l=!0);r[h]=l})},n.prototype.linkSeries=function(){var r=this,t=r.series;t.forEach(function(o){o.linkedSeries.length=0}),t.forEach(function(o){var s=o.options.linkedTo;isString$5(s)&&(s===":previous"?s=r.series[o.index-1]:s=r.get(s),s&&s.linkedParent!==o&&(s.linkedSeries.push(o),o.linkedParent=s,s.enabledDataSorting&&o.setDataSortingOptions(),o.visible=pick$1h(o.options.visible,s.options.visible,o.visible)))}),fireEvent$s(this,"afterLinkSeries")},n.prototype.renderSeries=function(){this.series.forEach(function(r){r.translate(),r.render()})},n.prototype.renderLabels=function(){var r=this,t=r.options.labels;t.items&&t.items.forEach(function(o){var s=extend$1d(t.style,o.style),a=pInt$4(s.left)+r.plotLeft,l=pInt$4(s.top)+r.plotTop+12;delete s.left,delete s.top,r.renderer.text(o.html,a,l).attr({zIndex:2}).css(s).add()})},n.prototype.render=function(){var r=this,t=r.axes,o=r.colorAxis,s=r.renderer,a=r.options,l=function(f){f.forEach(function(g){g.visible&&g.render()})},h=0;r.setTitle(),r.legend=new Legend(r,a.legend),r.getStacks&&r.getStacks(),r.getMargins(!0),r.setChartSize();var c=r.plotWidth;t.some(function(f){if(f.horiz&&f.visible&&f.options.labels.enabled&&f.series.length)return h=21,!0}),r.plotHeight=Math.max(r.plotHeight-h,0);var d=r.plotHeight;t.forEach(function(f){f.setScale()}),r.getAxisMargins();var p=c/r.plotWidth>1.1,u=d/r.plotHeight>1.05;(p||u)&&(t.forEach(function(f){(f.horiz&&p||!f.horiz&&u)&&f.setTickInterval(!0)}),r.getMargins()),r.drawChartBox(),r.hasCartesianSeries?l(t):o&&o.length&&l(o),r.seriesGroup||(r.seriesGroup=s.g("series-group").attr({zIndex:3}).add()),r.renderSeries(),r.renderLabels(),r.addCredits(),r.setResponsive&&r.setResponsive(),r.hasRendered=!0},n.prototype.addCredits=function(r){var t=this,o=merge$1a(!0,this.options.credits,r);o.enabled&&!this.credits&&(this.credits=this.renderer.text(o.text+(this.mapCredits||""),0,0).addClass("highcharts-credits").on("click",function(){o.href&&(win$8.location.href=o.href)}).attr({align:o.position.align,zIndex:8}),t.styledMode||this.credits.css(o.style),this.credits.add().align(o.position),this.credits.update=function(s){t.credits=t.credits.destroy(),t.addCredits(s)})},n.prototype.destroy=function(){var r=this,t=r.axes,o=r.series,s=r.container,a=s&&s.parentNode,l;for(fireEvent$s(r,"destroy"),r.renderer.forExport?erase$3(charts$1,r):charts$1[r.index]=void 0,H.chartCount--,r.renderTo.removeAttribute("data-highcharts-chart"),removeEvent$6(r),l=t.length;l--;)t[l]=t[l].destroy();for(this.scroller&&this.scroller.destroy&&this.scroller.destroy(),l=o.length;l--;)o[l]=o[l].destroy();["title","subtitle","chartBackground","plotBackground","plotBGImage","plotBorder","seriesGroup","clipRect","credits","pointer","rangeSelector","legend","resetZoomButton","tooltip","renderer"].forEach(function(h){var c=r[h];c&&c.destroy&&(r[h]=c.destroy())}),s&&(s.innerHTML="",removeEvent$6(s),a&&discardElement$3(s)),objectEach$n(r,function(h,c){delete r[c]})},n.prototype.firstRender=function(){var r=this,t=r.options;r.isReadyToRender&&!r.isReadyToRender()||(r.getContainer(),r.resetMargins(),r.setChartSize(),r.propFromSeries(),r.getAxes(),(isArray$g(t.series)?t.series:[]).forEach(function(o){r.initSeries(o)}),r.linkSeries(),r.setSeriesData(),fireEvent$s(r,"beforeRender"),Pointer&&(MSPointer.isRequired()?r.pointer=new MSPointer(r,t):r.pointer=new Pointer(r,t)),r.render(),r.pointer.getChartPosition(),!r.renderer.imgCount&&!r.hasLoaded&&r.onload(),r.temporaryDisplay(!0))},n.prototype.onload=function(){this.callbacks.concat([this.callback]).forEach(function(r){r&&typeof this.index<"u"&&r.apply(this,[this])},this),fireEvent$s(this,"load"),fireEvent$s(this,"render"),defined$H(this.index)&&this.setReflow(this.options.chart.reflow),this.hasLoaded=!0},n.prototype.addSeries=function(r,t,o){var s=this,a;return r&&(t=pick$1h(t,!0),fireEvent$s(s,"addSeries",{options:r},function(){a=s.initSeries(r),s.isDirtyLegend=!0,s.linkSeries(),a.enabledDataSorting&&a.setData(r.data,!1),fireEvent$s(s,"afterAddSeries",{series:a}),t&&s.redraw(o)})),a},n.prototype.addAxis=function(r,t,o,s){return this.createAxis(t?"xAxis":"yAxis",{axis:r,redraw:o,animation:s})},n.prototype.addColorAxis=function(r,t,o){return this.createAxis("colorAxis",{axis:r,redraw:t,animation:o})},n.prototype.createAxis=function(r,t){var o=new Axis(this,merge$1a(t.axis,{index:this[r].length,isX:r==="xAxis"}));return pick$1h(t.redraw,!0)&&this.redraw(t.animation),o},n.prototype.showLoading=function(r){var t=this,o=t.options,s=o.loading,a=function(){l&&css$5(l,{left:t.plotLeft+"px",top:t.plotTop+"px",width:t.plotWidth+"px",height:t.plotHeight+"px"})},l=t.loadingDiv,h=t.loadingSpan;l||(t.loadingDiv=l=createElement$5("div",{className:"highcharts-loading highcharts-loading-hidden"},null,t.container)),h||(t.loadingSpan=h=createElement$5("span",{className:"highcharts-loading-inner"},null,l),addEvent$T(t,"redraw",a)),l.className="highcharts-loading",AST.setElementHTML(h,pick$1h(r,o.lang.loading,"")),t.styledMode||(css$5(l,extend$1d(s.style,{zIndex:10})),css$5(h,s.labelStyle),t.loadingShown||(css$5(l,{opacity:0,display:""}),animate(l,{opacity:s.style.opacity||.5},{duration:s.showDuration||0}))),t.loadingShown=!0,a()},n.prototype.hideLoading=function(){var r=this.options,t=this.loadingDiv;t&&(t.className="highcharts-loading highcharts-loading-hidden",this.styledMode||animate(t,{opacity:0},{duration:r.loading.hideDuration||100,complete:function(){css$5(t,{display:"none"})}})),this.loadingShown=!1},n.prototype.update=function(r,t,o,s){var a=this,l={credits:"addCredits",title:"setTitle",subtitle:"setSubtitle",caption:"setCaption"},h=r.isResponsiveOptions,c=[],d,p,u;fireEvent$s(a,"update",{options:r}),h||a.setResponsive(!1,!0),r=cleanRecursively$1(r,a.options),a.userOptions=merge$1a(a.userOptions,r);var f=r.chart;f&&(merge$1a(!0,a.options.chart,f),"className"in f&&a.setClassName(f.className),"reflow"in f&&a.setReflow(f.reflow),("inverted"in f||"polar"in f||"type"in f)&&(a.propFromSeries(),d=!0),"alignTicks"in f&&(d=!0),"events"in f&&registerEventOptions$1(this,f),objectEach$n(f,function(m,x){a.propsRequireUpdateSeries.indexOf("chart."+x)!==-1&&(p=!0),a.propsRequireDirtyBox.indexOf(x)!==-1&&(a.isDirtyBox=!0),a.propsRequireReflow.indexOf(x)!==-1&&(h?a.isDirtyBox=!0:u=!0)}),!a.styledMode&&f.style&&a.renderer.setStyle(a.options.chart.style||{})),!a.styledMode&&r.colors&&(this.options.colors=r.colors),r.time&&(this.time===defaultTime&&(this.time=new Time(r.time)),merge$1a(!0,a.options.time,r.time)),objectEach$n(r,function(m,x){a[x]&&typeof a[x].update=="function"?a[x].update(m,!1):typeof a[l[x]]=="function"?a[l[x]](m):x!=="colors"&&a.collectionsWithUpdate.indexOf(x)===-1&&merge$1a(!0,a.options[x],r[x]),x!=="chart"&&a.propsRequireUpdateSeries.indexOf(x)!==-1&&(p=!0)}),this.collectionsWithUpdate.forEach(function(m){var x;r[m]&&(x=[],a[m].forEach(function(y,b){y.options.isInternal||x.push(pick$1h(y.options.index,b))}),splat$d(r[m]).forEach(function(y,b){var $=defined$H(y.id),S;$&&(S=a.get(y.id)),!S&&a[m]&&(S=a[m][x?x[b]:b],S&&$&&defined$H(S.options.id)&&(S=void 0)),S&&S.coll===m&&(S.update(y,!1),o&&(S.touched=!0)),!S&&o&&a.collectionsWithInit[m]&&(a.collectionsWithInit[m][0].apply(a,[y].concat(a.collectionsWithInit[m][1]||[]).concat([!1])).touched=!0)}),o&&a[m].forEach(function(y){!y.touched&&!y.options.isInternal?c.push(y):delete y.touched}))}),c.forEach(function(m){m.chart&&m.remove&&m.remove(!1)}),d&&a.axes.forEach(function(m){m.update({},!1)}),p&&a.getSeriesOrderByLinks().forEach(function(m){m.chart&&m.update({},!1)},this);var g=f&&f.width,v=f&&(isString$5(f.height)?relativeLength$7(f.height,g||a.chartWidth):f.height);u||isNumber$B(g)&&g!==a.chartWidth||isNumber$B(v)&&v!==a.chartHeight?a.setSize(g,v,s):pick$1h(t,!0)&&a.redraw(s),fireEvent$s(a,"afterUpdate",{options:r,redraw:t,animation:s})},n.prototype.setSubtitle=function(r,t){this.applyDescription("subtitle",r),this.layOutTitles(t)},n.prototype.setCaption=function(r,t){this.applyDescription("caption",r),this.layOutTitles(t)},n.prototype.showResetZoom=function(){var r=this,t=defaultOptions$a.lang,o=r.options.chart.resetZoomButton,s=o.theme,a=s.states,l=o.relativeTo==="chart"||o.relativeTo==="spacingBox"?null:"scrollablePlotBox";function h(){r.zoomOut()}fireEvent$s(this,"beforeShowResetZoom",null,function(){r.resetZoomButton=r.renderer.button(t.resetZoom,null,null,h,s,a&&a.hover).attr({align:o.position.align,title:t.resetZoomTitle}).addClass("highcharts-reset-zoom").add().align(o.position,!1,l)}),fireEvent$s(this,"afterShowResetZoom")},n.prototype.zoomOut=function(){fireEvent$s(this,"selection",{resetSelection:!0},this.zoom)},n.prototype.zoom=function(r){var t=this,o=t.pointer,s=t.inverted?o.mouseDownX:o.mouseDownY,a=!1,l;!r||r.resetSelection?(t.axes.forEach(function(c){l=c.zoom()}),o.initiated=!1):r.xAxis.concat(r.yAxis).forEach(function(c){var d=c.axis,p=t.inverted?d.left:d.top,u=t.inverted?p+d.width:p+d.height,f=d.isXAxis,g=!1;(!f&&s>=p&&s<=u||f||!defined$H(s))&&(g=!0),o[f?"zoomX":"zoomY"]&&g&&(l=d.zoom(c.min,c.max),d.displayBtn&&(a=!0))});var h=t.resetZoomButton;a&&!h?t.showResetZoom():!a&&isObject$9(h)&&(t.resetZoomButton=h.destroy()),l&&t.redraw(pick$1h(t.options.chart.animation,r&&r.animation,t.pointCount<100))},n.prototype.pan=function(r,t){var o=this,s=o.hoverPoints,a=typeof t=="object"?t:{enabled:t,type:"x"},l=o.options.chart,h=o.options.mapNavigation&&o.options.mapNavigation.enabled;l&&l.panning&&(l.panning=a);var c=a.type,d;fireEvent$s(this,"pan",{originalEvent:r},function(){s&&s.forEach(function(f){f.setState()});var p=o.xAxis;c==="xy"?p=p.concat(o.yAxis):c==="y"&&(p=o.yAxis);var u={};p.forEach(function(f){if(!(!f.options.panningEnabled||f.options.isInternal)){var g=f.horiz,v=r[g?"chartX":"chartY"],m=g?"mouseDownX":"mouseDownY",x=o[m],y=f.minPointOffset||0,b=f.reversed&&!o.inverted||!f.reversed&&o.inverted?-1:1,$=f.getExtremes(),S=f.toValue(x-v,!0)+y*b,k=f.toValue(x+f.len-v,!0)-(y*b||f.isXAxis&&f.pointRangePadding||0),A=k<S,P=f.hasVerticalPanning(),E=A?k:S,M=A?S:k,T=f.panningState,O;P&&!f.isXAxis&&(!T||T.isDirty)&&f.series.forEach(function(U){var D=U.getProcessedData(!0),N=U.getExtremes(D.yData,!0);T||(T={startMin:Number.MAX_VALUE,startMax:-Number.MAX_VALUE}),isNumber$B(N.dataMin)&&isNumber$B(N.dataMax)&&(T.startMin=Math.min(pick$1h(U.options.threshold,1/0),N.dataMin,T.startMin),T.startMax=Math.max(pick$1h(U.options.threshold,-1/0),N.dataMax,T.startMax))});var L=Math.min(pick$1h(T&&T.startMin,$.dataMin),y?$.min:f.toValue(f.toPixels($.min)-f.minPixelPadding)),C=Math.max(pick$1h(T&&T.startMax,$.dataMax),y?$.max:f.toValue(f.toPixels($.max)+f.minPixelPadding));f.panningState=T,f.isOrdinal||(O=L-E,O>0&&(M+=O,E=L),O=M-C,O>0&&(M=C,E-=O),f.series.length&&E!==$.min&&M!==$.max&&E>=L&&M<=C&&(f.setExtremes(E,M,!1,!1,{trigger:"pan"}),!o.resetZoomButton&&!h&&E!==L&&M!==C&&c.match("y")&&(o.showResetZoom(),f.displayBtn=!1),d=!0),u[m]=v)}}),objectEach$n(u,function(f,g){o[g]=f}),d&&o.redraw(!1),css$5(o.container,{cursor:"move"})})},n}();extend$1d(Chart$1.prototype,{callbacks:[],collectionsWithInit:{xAxis:[Chart$1.prototype.addAxis,[!0]],yAxis:[Chart$1.prototype.addAxis,[!1]],series:[Chart$1.prototype.addSeries]},collectionsWithUpdate:["xAxis","yAxis","series"],propsRequireDirtyBox:["backgroundColor","borderColor","borderWidth","borderRadius","plotBackgroundColor","plotBackgroundImage","plotBorderColor","plotBorderWidth","plotShadow","shadow"],propsRequireReflow:["margin","marginTop","marginRight","marginBottom","marginLeft","spacing","spacingTop","spacingRight","spacingBottom","spacingLeft"],propsRequireUpdateSeries:["chart.inverted","chart.polar","chart.ignoreHiddenSeries","chart.type","colors","plotOptions","time","tooltip"]});var merge$19=Utilities.merge,pick$1g=Utilities.pick,LegendSymbol;(function(n){function r(o){var s=this.options,a=o.symbolWidth,l=o.symbolHeight,h=l/2,c=this.chart.renderer,d=this.legendGroup,p=o.baseline-Math.round(o.fontMetrics.b*.3),u={},f,g=s.marker;if(this.chart.styledMode||(u={"stroke-width":s.lineWidth||0},s.dashStyle&&(u.dashstyle=s.dashStyle)),this.legendLine=c.path([["M",0,p],["L",a,p]]).addClass("highcharts-graph").attr(u).add(d),g&&g.enabled!==!1&&a){var v=Math.min(pick$1g(g.radius,h),h);this.symbol.indexOf("url")===0&&(g=merge$19(g,{width:l,height:l}),v=0),this.legendSymbol=f=c.symbol(this.symbol,a/2-v,p-v,2*v,2*v,g).addClass("highcharts-point").add(d),f.isMarker=!0}}n.drawLineMarker=r;function t(o,s){var a=o.options,l=o.symbolHeight,h=a.squareSymbol,c=h?l:o.symbolWidth;s.legendSymbol=this.chart.renderer.rect(h?(o.symbolWidth-l)/2:0,o.baseline-l+1,c,l,pick$1g(o.options.symbolRadius,l/2)).addClass("highcharts-point").attr({zIndex:3}).add(s.legendGroup)}n.drawRectangle=t})(LegendSymbol||(LegendSymbol={}));const LegendSymbol$1=LegendSymbol;var seriesDefaults={lineWidth:2,allowPointSelect:!1,crisp:!0,showCheckbox:!1,animation:{duration:1e3},events:{},marker:{enabledThreshold:2,lineColor:palette.backgroundColor,lineWidth:0,radius:4,states:{normal:{animation:!0},hover:{animation:{duration:50},enabled:!0,radiusPlus:2,lineWidthPlus:1},select:{fillColor:palette.neutralColor20,lineColor:palette.neutralColor100,lineWidth:2}}},point:{events:{}},dataLabels:{animation:{},align:"center",defer:!0,formatter:function(){var n=this.series.chart.numberFormatter;return typeof this.y!="number"?"":n(this.y,-1)},padding:5,style:{fontSize:"11px",fontWeight:"bold",color:"contrast",textOutline:"1px contrast"},verticalAlign:"bottom",x:0,y:0},cropThreshold:300,opacity:1,pointRange:0,softThreshold:!0,states:{normal:{animation:!0},hover:{animation:{duration:50},lineWidthPlus:1,marker:{},halo:{size:10,opacity:.25}},select:{animation:{duration:0}},inactive:{animation:{duration:50},opacity:.2}},stickyTracking:!0,turboThreshold:1e3,findNearestPointBy:"x"},animObject$6=animationExports.animObject,setAnimation$2=animationExports.setAnimation,defaultOptions$9=DefaultOptions.defaultOptions,registerEventOptions=exports$3.registerEventOptions,hasTouch$2=H.hasTouch,svg$2=H.svg,win$7=H.win,seriesTypes$6=SeriesRegistry$1.seriesTypes,addEvent$S=Utilities.addEvent,arrayMax$7=Utilities.arrayMax,arrayMin$6=Utilities.arrayMin,clamp$e=Utilities.clamp,cleanRecursively=Utilities.cleanRecursively,correctFloat$a=Utilities.correctFloat,defined$G=Utilities.defined,erase$2=Utilities.erase,error$4=Utilities.error,extend$1c=Utilities.extend,find$f=Utilities.find,fireEvent$r=Utilities.fireEvent,getNestedProperty=Utilities.getNestedProperty,isArray$f=Utilities.isArray,isNumber$A=Utilities.isNumber,isString$4=Utilities.isString,merge$18=Utilities.merge,objectEach$m=Utilities.objectEach,pick$1f=Utilities.pick,removeEvent$5=Utilities.removeEvent,splat$c=Utilities.splat,syncTimeout$2=Utilities.syncTimeout,Series$e=function(){function n(){this._i=void 0,this.chart=void 0,this.data=void 0,this.eventOptions=void 0,this.eventsToUnbind=void 0,this.index=void 0,this.linkedSeries=void 0,this.options=void 0,this.points=void 0,this.processedXData=void 0,this.processedYData=void 0,this.tooltipOptions=void 0,this.userOptions=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zones=void 0}return n.prototype.init=function(r,t){fireEvent$r(this,"init",{options:t});var o=this,s=r.series;this.eventsToUnbind=[],o.chart=r,o.options=o.setOptions(t);var a=o.options;o.linkedSeries=[],o.bindAxes(),extend$1c(o,{name:a.name,state:"",visible:a.visible!==!1,selected:a.selected===!0}),registerEventOptions(this,a);var l=a.events;(l&&l.click||a.point&&a.point.events&&a.point.events.click||a.allowPointSelect)&&(r.runTrackerClick=!0),o.getColor(),o.getSymbol(),o.parallelArrays.forEach(function(c){o[c+"Data"]||(o[c+"Data"]=[])}),o.isCartesian&&(r.hasCartesianSeries=!0);var h;s.length&&(h=s[s.length-1]),o._i=pick$1f(h&&h._i,-1)+1,o.opacity=o.options.opacity,r.orderSeries(this.insert(s)),a.dataSorting&&a.dataSorting.enabled?o.setDataSortingOptions():!o.points&&!o.data&&o.setData(a.data,!1),fireEvent$r(this,"afterInit")},n.prototype.is=function(r){return seriesTypes$6[r]&&this instanceof seriesTypes$6[r]},n.prototype.insert=function(r){var t=this.options.index,o;if(isNumber$A(t)){for(o=r.length;o--;)if(t>=pick$1f(r[o].options.index,r[o]._i)){r.splice(o+1,0,this);break}o===-1&&r.unshift(this),o=o+1}else r.push(this);return pick$1f(o,r.length-1)},n.prototype.bindAxes=function(){var r=this,t=r.options,o=r.chart,s;fireEvent$r(this,"bindAxes",null,function(){(r.axisTypes||[]).forEach(function(a){var l=0;o[a].forEach(function(h){s=h.options,(t[a]===l&&!s.isInternal||typeof t[a]<"u"&&t[a]===s.id||typeof t[a]>"u"&&s.index===0)&&(r.insert(h.series),r[a]=h,h.isDirty=!0),s.isInternal||l++}),!r[a]&&r.optionalAxis!==a&&error$4(18,!0,o)})}),fireEvent$r(this,"afterBindAxes")},n.prototype.updateParallelArrays=function(r,t){var o=r.series,s=arguments,a=isNumber$A(t)?function(l){var h=l==="y"&&o.toYData?o.toYData(r):r[l];o[l+"Data"][t]=h}:function(l){Array.prototype[t].apply(o[l+"Data"],Array.prototype.slice.call(s,2))};o.parallelArrays.forEach(a)},n.prototype.hasData=function(){return this.visible&&typeof this.dataMax<"u"&&typeof this.dataMin<"u"||this.visible&&this.yData&&this.yData.length>0},n.prototype.autoIncrement=function(r){var t=this.options,o=t.pointIntervalUnit,s=t.relativeXValue,a=this.chart.time,l=this.xIncrement,h,c;return l=pick$1f(l,t.pointStart,0),this.pointInterval=c=pick$1f(this.pointInterval,t.pointInterval,1),s&&isNumber$A(r)&&(c*=r),o&&(h=new a.Date(l),o==="day"?a.set("Date",h,a.get("Date",h)+c):o==="month"?a.set("Month",h,a.get("Month",h)+c):o==="year"&&a.set("FullYear",h,a.get("FullYear",h)+c),c=h.getTime()-l),s&&isNumber$A(r)?l+c:(this.xIncrement=l+c,l)},n.prototype.setDataSortingOptions=function(){var r=this.options;extend$1c(this,{requireSorting:!1,sorted:!1,enabledDataSorting:!0,allowDG:!1}),defined$G(r.pointRange)||(r.pointRange=1)},n.prototype.setOptions=function(r){var t=this.chart,o=t.options,s=o.plotOptions,a=t.userOptions||{},l=merge$18(r),h=t.styledMode,c={plotOptions:s,userOptions:l},d;fireEvent$r(this,"setOptions",c);var p=c.plotOptions[this.type],u=a.plotOptions||{};this.userOptions=c.userOptions;var f=merge$18(p,s.series,a.plotOptions&&a.plotOptions[this.type],l);this.tooltipOptions=merge$18(defaultOptions$9.tooltip,defaultOptions$9.plotOptions.series&&defaultOptions$9.plotOptions.series.tooltip,defaultOptions$9.plotOptions[this.type].tooltip,o.tooltip.userOptions,s.series&&s.series.tooltip,s[this.type].tooltip,l.tooltip),this.stickyTracking=pick$1f(l.stickyTracking,u[this.type]&&u[this.type].stickyTracking,u.series&&u.series.stickyTracking,this.tooltipOptions.shared&&!this.noSharedTooltip?!0:f.stickyTracking),p.marker===null&&delete f.marker,this.zoneAxis=f.zoneAxis;var g=this.zones=(f.zones||[]).slice();return(f.negativeColor||f.negativeFillColor)&&!f.zones&&(d={value:f[this.zoneAxis+"Threshold"]||f.threshold||0,className:"highcharts-negative"},h||(d.color=f.negativeColor,d.fillColor=f.negativeFillColor),g.push(d)),g.length&&defined$G(g[g.length-1].value)&&g.push(h?{}:{color:this.color,fillColor:this.fillColor}),fireEvent$r(this,"afterSetOptions",{options:f}),f},n.prototype.getName=function(){return pick$1f(this.options.name,"Series "+(this.index+1))},n.prototype.getCyclic=function(r,t,o){var s=this.chart,a=this.userOptions,l=r+"Index",h=r+"Counter",c=o?o.length:pick$1f(s.options.chart[r+"Count"],s[r+"Count"]),d,p;t||(p=pick$1f(a[l],a["_"+l]),defined$G(p)?d=p:(s.series.length||(s[h]=0),a["_"+l]=d=s[h]%c,s[h]+=1),o&&(t=o[d])),typeof d<"u"&&(this[l]=d),this[r]=t},n.prototype.getColor=function(){this.chart.styledMode?this.getCyclic("color"):this.options.colorByPoint?this.color=palette.neutralColor20:this.getCyclic("color",this.options.color||defaultOptions$9.plotOptions[this.type].color,this.chart.options.colors)},n.prototype.getPointsCollection=function(){return(this.hasGroupedData?this.points:this.data)||[]},n.prototype.getSymbol=function(){var r=this.options.marker;this.getCyclic("symbol",r.symbol,this.chart.options.symbols)},n.prototype.findPointIndex=function(r,t){var o=r.id,s=r.x,a=this.points,l=this.options.dataSorting,h,c,d;if(o){var p=this.chart.get(o);p instanceof Point$2&&(h=p)}else if(this.linkedParent||this.enabledDataSorting||this.options.relativeXValue){var u=function(f){return!f.touched&&f.index===r.index};if(l&&l.matchByName?u=function(f){return!f.touched&&f.name===r.name}:this.options.relativeXValue&&(u=function(f){return!f.touched&&f.options.x===r.x}),h=find$f(a,u),!h)return}return h&&(d=h&&h.index,typeof d<"u"&&(c=!0)),typeof d>"u"&&isNumber$A(s)&&(d=this.xData.indexOf(s,t)),d!==-1&&typeof d<"u"&&this.cropped&&(d=d>=this.cropStart?d-this.cropStart:d),!c&&isNumber$A(d)&&a[d]&&a[d].touched&&(d=void 0),d},n.prototype.updateData=function(r,t){var o=this.options,s=o.dataSorting,a=this.points,l=[],h=this.requireSorting,c=r.length===a.length,d,p,u,f,g=!0;if(this.xIncrement=null,r.forEach(function(v,m){var x=defined$G(v)&&this.pointClass.prototype.optionsToObject.call({series:this},v)||{},y,b=x.x,$=x.id;$||isNumber$A(b)?(y=this.findPointIndex(x,f),y===-1||typeof y>"u"?l.push(v):a[y]&&v!==o.data[y]?(a[y].update(v,!1,null,!1),a[y].touched=!0,h&&(f=y+1)):a[y]&&(a[y].touched=!0),(!c||m!==y||s&&s.enabled||this.hasDerivedData)&&(d=!0)):l.push(v)},this),d)for(p=a.length;p--;)u=a[p],u&&!u.touched&&u.remove&&u.remove(!1,t);else c&&(!s||!s.enabled)?(r.forEach(function(v,m){v!==a[m].y&&a[m].update&&a[m].update(v,!1,null,!1)}),l.length=0):g=!1;return a.forEach(function(v){v&&(v.touched=!1)}),g?(l.forEach(function(v){this.addPoint(v,!1,null,null,!1)},this),this.xIncrement===null&&this.xData&&this.xData.length&&(this.xIncrement=arrayMax$7(this.xData),this.autoIncrement()),!0):!1},n.prototype.setData=function(r,t,o,s){var a=this,l=a.points,h=l&&l.length||0,c=a.options,d=a.chart,p=c.dataSorting,u=a.xAxis,f=c.turboThreshold,g=this.xData,v=this.yData,m=a.pointArrayMap,x=m&&m.length,y=c.keys,b,$,S,k=0,A=1,P=null;r=r||[];var E=r.length;if(t=pick$1f(t,!0),p&&p.enabled&&(r=this.sortData(r)),s!==!1&&E&&h&&!a.cropped&&!a.hasGroupedData&&a.visible&&!a.isSeriesBoosting&&(S=this.updateData(r,o)),!S){if(a.xIncrement=null,a.colorCounter=0,this.parallelArrays.forEach(function(M){a[M+"Data"].length=0}),f&&E>f)if(P=a.getFirstValidPoint(r),isNumber$A(P))for(b=0;b<E;b++)g[b]=this.autoIncrement(),v[b]=r[b];else if(isArray$f(P))if(x)for(b=0;b<E;b++)$=r[b],g[b]=$[0],v[b]=$.slice(1,x+1);else for(y&&(k=y.indexOf("x"),A=y.indexOf("y"),k=k>=0?k:0,A=A>=0?A:1),b=0;b<E;b++)$=r[b],g[b]=$[k],v[b]=$[A];else error$4(12,!1,d);else for(b=0;b<E;b++)typeof r[b]<"u"&&($={series:a},a.pointClass.prototype.applyOptions.apply($,[r[b]]),a.updateParallelArrays($,b));for(v&&isString$4(v[0])&&error$4(14,!0,d),a.data=[],a.options.data=a.userOptions.data=r,b=h;b--;)l[b]&&l[b].destroy&&l[b].destroy();u&&(u.minRange=u.userMinRange),a.isDirty=d.isDirtyBox=!0,a.isDirtyData=!!l,o=!1}c.legendType==="point"&&(this.processData(),this.generatePoints()),t&&d.redraw(o)},n.prototype.sortData=function(r){var t=this,o=t.options,s=o.dataSorting,a=s.sortKey||"y",l=function(c,d){return defined$G(d)&&c.pointClass.prototype.optionsToObject.call({series:c},d)||{}};r.forEach(function(c,d){r[d]=l(t,c),r[d].index=d},this);var h=r.concat().sort(function(c,d){var p=getNestedProperty(a,c),u=getNestedProperty(a,d);return u<p?-1:u>p?1:0});return h.forEach(function(c,d){c.x=d},this),t.linkedSeries&&t.linkedSeries.forEach(function(c){var d=c.options,p=d.data;(!d.dataSorting||!d.dataSorting.enabled)&&p&&(p.forEach(function(u,f){p[f]=l(c,u),r[f]&&(p[f].x=r[f].x,p[f].index=f)}),c.setData(p,!1))}),r},n.prototype.getProcessedData=function(r){var t=this,o=t.xAxis,s=t.options,a=s.cropThreshold,l=r||t.getExtremesFromAll||s.getExtremesFromAll,h=t.isCartesian,c=o&&o.val2lin,d=!!(o&&o.logarithmic),p,u,f=0,g,v,m,x,y,b,$=t.xData,S=t.yData,k=t.requireSorting,A=!1,P=$.length;for(o&&(x=o.getExtremes(),y=x.min,b=x.max,A=o.categories&&!o.names.length),h&&t.sorted&&!l&&(!a||P>a||t.forceCrop)&&($[P-1]<y||$[0]>b?($=[],S=[]):t.yData&&($[0]<y||$[P-1]>b)&&(p=this.cropData(t.xData,t.yData,y,b),$=p.xData,S=p.yData,f=p.start,u=!0)),m=$.length||1;--m;)g=d?c($[m])-c($[m-1]):$[m]-$[m-1],g>0&&(typeof v>"u"||g<v)?v=g:g<0&&k&&!A&&(error$4(15,!1,t.chart),k=!1);return{xData:$,yData:S,cropped:u,cropStart:f,closestPointRange:v}},n.prototype.processData=function(r){var t=this,o=t.xAxis;if(t.isCartesian&&!t.isDirty&&!o.isDirty&&!t.yAxis.isDirty&&!r)return!1;var s=t.getProcessedData();t.cropped=s.cropped,t.cropStart=s.cropStart,t.processedXData=s.xData,t.processedYData=s.yData,t.closestPointRange=t.basePointRange=s.closestPointRange},n.prototype.cropData=function(r,t,o,s,a){var l=r.length,h,c,d=0,p=l;for(a=pick$1f(a,this.cropShoulder),h=0;h<l;h++)if(r[h]>=o){d=Math.max(0,h-a);break}for(c=h;c<l;c++)if(r[c]>s){p=c+a;break}return{xData:r.slice(d,p),yData:t.slice(d,p),start:d,end:p}},n.prototype.generatePoints=function(){var r=this,t=r.options,o=t.data,s=r.processedXData,a=r.processedYData,l=r.pointClass,h=s.length,c=r.cropStart||0,d=r.hasGroupedData,p=t.keys,u=[],f=t.dataGrouping&&t.dataGrouping.groupAll?c:0,g,v,m,x,y=r.data;if(!y&&!d){var b=[];b.length=o.length,y=r.data=b}for(p&&d&&(r.options.keys=!1),x=0;x<h;x++)v=c+x,d?(m=new l().init(r,[s[x]].concat(splat$c(a[x]))),m.dataGroup=r.groupMap[f+x],m.dataGroup.options&&(m.options=m.dataGroup.options,extend$1c(m,m.dataGroup.options),delete m.dataLabels)):(m=y[v],!m&&typeof o[v]<"u"&&(y[v]=m=new l().init(r,o[v],s[x]))),m&&(m.index=d?f+x:v,u[x]=m);if(r.options.keys=p,y&&(h!==(g=y.length)||d))for(x=0;x<g;x++)x===c&&!d&&(x+=h),y[x]&&(y[x].destroyElements(),y[x].plotX=void 0);r.data=y,r.points=u,fireEvent$r(this,"afterGeneratePoints")},n.prototype.getXExtremes=function(r){return{min:arrayMin$6(r),max:arrayMax$7(r)}},n.prototype.getExtremes=function(r,t){var o=this.xAxis,s=this.yAxis,a=this.processedXData||this.xData,l=[],h=this.requireSorting?this.cropShoulder:0,c=s?s.positiveValuesOnly:!1,d,p,u,f,g,v,m,x=0,y=0,b=0;r=r||this.stackedYData||this.processedYData||[];var $=r.length;for(o&&(d=o.getExtremes(),x=d.min,y=d.max),v=0;v<$;v++)if(f=a[v],g=r[v],p=(isNumber$A(g)||isArray$f(g))&&(g.length||g>0||!c),u=t||this.getExtremesFromAll||this.options.getExtremesFromAll||this.cropped||!o||(a[v+h]||f)>=x&&(a[v-h]||f)<=y,p&&u)if(m=g.length,m)for(;m--;)isNumber$A(g[m])&&(l[b++]=g[m]);else l[b++]=g;var S={dataMin:arrayMin$6(l),dataMax:arrayMax$7(l)};return fireEvent$r(this,"afterGetExtremes",{dataExtremes:S}),S},n.prototype.applyExtremes=function(){var r=this.getExtremes();return this.dataMin=r.dataMin,this.dataMax=r.dataMax,r},n.prototype.getFirstValidPoint=function(r){for(var t=r.length,o=0,s=null;s===null&&o<t;)s=r[o],o++;return s},n.prototype.translate=function(){this.processedXData||this.processData(),this.generatePoints();var r=this,t=r.options,o=t.stacking,s=r.xAxis,a=s.categories,l=r.enabledDataSorting,h=r.yAxis,c=r.points,d=c.length,p=!!r.modifyValue,u=r.pointPlacementToXValue(),f=!!u,g=t.threshold,v=t.startFromThreshold?g:0,m=this.zoneAxis||"y",x,y,b,$,S=Number.MAX_VALUE;function k(U){return clamp$e(U,-1e5,1e5)}for(x=0;x<d;x++){var A=c[x],P=A.x,E=void 0,M=void 0,T=A.y,O=A.low,L=o&&h.stacking&&h.stacking.stacks[(r.negStacks&&T<(v?0:g)?"-":"")+r.stackKey];if((h.positiveValuesOnly&&!h.validatePositiveValue(T)||s.positiveValuesOnly&&!s.validatePositiveValue(P))&&(A.isNull=!0),A.plotX=y=correctFloat$a(k(s.translate(P,0,0,0,1,u,this.type==="flags"))),o&&r.visible&&L&&L[P]&&($=r.getStackIndicator($,P,r.index),A.isNull||(E=L[P],M=E.points[$.key])),isArray$f(M)&&(O=M[0],T=M[1],O===v&&$.key===L[P].base&&(O=pick$1f(isNumber$A(g)&&g,h.min)),h.positiveValuesOnly&&O<=0&&(O=null),A.total=A.stackTotal=E.total,A.percentage=E.total&&A.y/E.total*100,A.stackY=T,r.irregularWidths||E.setOffset(r.pointXOffset||0,r.barW||0)),A.yBottom=defined$G(O)?k(h.translate(O,0,1,0,1)):null,p&&(T=r.modifyValue(T,A)),A.plotY=void 0,isNumber$A(T)){var C=h.translate(T,!1,!0,!1,!0);typeof C<"u"&&(A.plotY=k(C))}A.isInside=this.isPointInside(A),A.clientX=f?correctFloat$a(s.translate(P,0,0,0,1,u)):y,A.negative=A[m]<(t[m+"Threshold"]||g||0),A.category=a&&typeof a[A.x]<"u"?a[A.x]:A.x,!A.isNull&&A.visible!==!1&&(typeof b<"u"&&(S=Math.min(S,Math.abs(y-b))),b=y),A.zone=this.zones.length&&A.getZone(),!A.graphic&&r.group&&l&&(A.isNew=!0)}r.closestPointRangePx=S,fireEvent$r(this,"afterTranslate")},n.prototype.getValidPoints=function(r,t,o){var s=this.chart;return(r||this.points||[]).filter(function(a){return t&&!s.isInsidePlot(a.plotX,a.plotY,{inverted:s.inverted})?!1:a.visible!==!1&&(o||!a.isNull)})},n.prototype.getClipBox=function(r,t){var o=this,s=o.options,a=o.chart,l=a.inverted,h=o.xAxis,c=h&&o.yAxis,d=a.options.chart.scrollablePlotArea||{},p;return r&&s.clip===!1&&c?p=l?{y:-a.chartWidth+c.len+c.pos,height:a.chartWidth,width:a.chartHeight,x:-a.chartHeight+h.len+h.pos}:{y:-c.pos,height:a.chartHeight,width:a.chartWidth,x:-h.pos}:(p=o.clipBox||a.clipBox,t&&(p.width=a.plotSizeX,p.x=(a.scrollablePixelsX||0)*(d.scrollPositionX||0))),t?{width:p.width,x:p.x}:p},n.prototype.getSharedClipKey=function(r){if(this.sharedClipKey)return this.sharedClipKey;var t=[r&&r.duration,r&&r.easing,r&&r.defer,this.getClipBox(r).height,this.options.xAxis,this.options.yAxis].join(",");return(this.options.clip!==!1||r)&&(this.sharedClipKey=t),t},n.prototype.setClip=function(r){var t=this.chart,o=this.options,s=t.renderer,a=t.inverted,l=this.clipBox,h=this.getClipBox(r),c=this.getSharedClipKey(r),d=t.sharedClips[c],p=t.sharedClips[c+"m"];r&&(h.width=0,a&&(h.x=t.plotHeight+(o.clip!==!1?0:t.plotTop))),d?t.hasLoaded||d.attr(h):(r&&(t.sharedClips[c+"m"]=p=s.clipRect(a?(t.plotSizeX||0)+99:-99,a?-t.plotLeft:-t.plotTop,99,a?t.chartWidth:t.chartHeight)),t.sharedClips[c]=d=s.clipRect(h),d.count={length:0}),r&&(d.count[this.index]||(d.count[this.index]=!0,d.count.length+=1)),(o.clip!==!1||r)&&(this.group.clip(r||l?d:t.clipRect),this.markerGroup.clip(p)),r||(d.count[this.index]&&(delete d.count[this.index],d.count.length-=1),d.count.length===0&&(l||(t.sharedClips[c]=d.destroy()),p&&(t.sharedClips[c+"m"]=p.destroy())))},n.prototype.animate=function(r){var t=this,o=t.chart,s=animObject$6(t.options.animation),a=this.sharedClipKey;if(r)t.setClip(s);else if(a){var l=o.sharedClips[a],h=o.sharedClips[a+"m"],c=t.getClipBox(s,!0);l&&l.animate(c,s),h&&h.animate({width:c.width+99,x:c.x-(o.inverted?0:99)},s)}},n.prototype.afterAnimate=function(){this.setClip(),fireEvent$r(this,"afterAnimate"),this.finishedAnimating=!0},n.prototype.drawPoints=function(){var r=this,t=r.points,o=r.chart,s=r.options,a=s.marker,l=r[r.specialGroup]||r.markerGroup,h=r.xAxis,c=pick$1f(a.enabled,!h||h.isRadial?!0:null,r.closestPointRangePx>=a.enabledThreshold*a.radius),d,p,u,f,g,v,m;if(a.enabled!==!1||r._hasPointMarkers)for(d=0;d<t.length;d++){p=t[d],u=p.graphic,f=u?"animate":"attr",g=p.marker||{},v=!!p.marker;var x=(c&&typeof g.enabled>"u"||g.enabled)&&!p.isNull&&p.visible!==!1;if(x){var y=pick$1f(g.symbol,r.symbol,"rect");m=r.markerAttribs(p,p.selected&&"select"),r.enabledDataSorting&&(p.startXPos=h.reversed?-(m.width||0):h.width);var b=p.isInside!==!1;u?u[b?"show":"hide"](b).animate(m):b&&((m.width||0)>0||p.hasImage)&&(p.graphic=u=o.renderer.symbol(y,m.x,m.y,m.width,m.height,v?g:a).add(l),r.enabledDataSorting&&o.hasRendered&&(u.attr({x:p.startXPos}),f="animate")),u&&f==="animate"&&u[b?"show":"hide"](b).animate(m),u&&!o.styledMode&&u[f](r.pointAttribs(p,p.selected&&"select")),u&&u.addClass(p.getClassName(),!0)}else u&&(p.graphic=u.destroy())}},n.prototype.markerAttribs=function(r,t){var o=this.options,s=o.marker,a=r.marker||{},l=a.symbol||s.symbol,h,c,d=pick$1f(a.radius,s.radius);t&&(h=s.states[t],c=a.states&&a.states[t],d=pick$1f(c&&c.radius,h&&h.radius,d+(h&&h.radiusPlus||0))),r.hasImage=l&&l.indexOf("url")===0,r.hasImage&&(d=0);var p={x:o.crisp?Math.floor(r.plotX-d):r.plotX-d,y:r.plotY-d};return d&&(p.width=p.height=2*d),p},n.prototype.pointAttribs=function(r,t){var o=this.options.marker,s=r&&r.options,a=s&&s.marker||{},l=s&&s.color,h=r&&r.color,c=r&&r.zone&&r.zone.color,d,p,u=this.color,f,g,v=pick$1f(a.lineWidth,o.lineWidth),m=1;return u=l||c||h||u,f=a.fillColor||o.fillColor||u,g=a.lineColor||o.lineColor||u,t=t||"normal",t&&(d=o.states[t],p=a.states&&a.states[t]||{},v=pick$1f(p.lineWidth,d.lineWidth,v+pick$1f(p.lineWidthPlus,d.lineWidthPlus,0)),f=p.fillColor||d.fillColor||f,g=p.lineColor||d.lineColor||g,m=pick$1f(p.opacity,d.opacity,m)),{stroke:g,"stroke-width":v,fill:f,opacity:m}},n.prototype.destroy=function(r){var t=this,o=t.chart,s=/AppleWebKit\/533/.test(win$7.navigator.userAgent),a=t.data||[],l,h,c,d;for(fireEvent$r(t,"destroy"),this.removeEvents(r),(t.axisTypes||[]).forEach(function(p){d=t[p],d&&d.series&&(erase$2(d.series,t),d.isDirty=d.forceRedraw=!0)}),t.legendItem&&t.chart.legend.destroyItem(t),h=a.length;h--;)c=a[h],c&&c.destroy&&c.destroy();t.clips&&t.clips.forEach(function(p){return p.destroy()}),Utilities.clearTimeout(t.animationTimeout),objectEach$m(t,function(p,u){p instanceof SVGElement&&!p.survive&&(l=s&&u==="group"?"hide":"destroy",p[l]())}),o.hoverSeries===t&&(o.hoverSeries=void 0),erase$2(o.series,t),o.orderSeries(),objectEach$m(t,function(p,u){(!r||u!=="hcEvents")&&delete t[u]})},n.prototype.applyZones=function(){var r=this,t=this.chart,o=t.renderer,s=this.zones,a=this.clips||[],l=this.graph,h=this.area,c=Math.max(t.chartWidth,t.chartHeight),d=this[(this.zoneAxis||"y")+"Axis"],p=t.inverted,u,f,g,v,m,x,y,b,$,S,k,A=!1;s.length&&(l||h)&&d&&typeof d.min<"u"?(m=d.reversed,x=d.horiz,l&&!this.showLine&&l.hide(),h&&h.hide(),v=d.getExtremes(),s.forEach(function(P,E){u=m?x?t.plotWidth:0:x?0:d.toPixels(v.min)||0,u=clamp$e(pick$1f(f,u),0,c),f=clamp$e(Math.round(d.toPixels(pick$1f(P.value,v.max),!0)||0),0,c),A&&(u=f=d.toPixels(v.max)),y=Math.abs(u-f),b=Math.min(u,f),$=Math.max(u,f),d.isXAxis?(g={x:p?$:b,y:0,width:y,height:c},x||(g.x=t.plotHeight-g.x)):(g={x:0,y:p?$:b,width:c,height:y},x&&(g.y=t.plotWidth-g.y)),p&&o.isVML&&(d.isXAxis?g={x:0,y:m?b:$,height:g.width,width:t.chartWidth}:g={x:g.y-t.plotLeft-t.spacingBox.x,y:0,width:g.height,height:t.chartHeight}),a[E]?a[E].animate(g):a[E]=o.clipRect(g),S=r["zone-area-"+E],k=r["zone-graph-"+E],l&&k&&k.clip(a[E]),h&&S&&S.clip(a[E]),A=P.value>v.max,r.resetZones&&f===0&&(f=void 0)}),this.clips=a):r.visible&&(l&&l.show(!0),h&&h.show(!0))},n.prototype.invertGroups=function(r){var t=this,o=t.chart;function s(){["group","markerGroup"].forEach(function(a){t[a]&&(o.renderer.isVML&&t[a].attr({width:t.yAxis.len,height:t.xAxis.len}),t[a].width=t.yAxis.len,t[a].height=t.xAxis.len,t[a].invert(t.isRadialSeries?!1:r))})}t.xAxis&&(t.eventsToUnbind.push(addEvent$S(o,"resize",s)),s(),t.invertGroups=s)},n.prototype.plotGroup=function(r,t,o,s,a){var l=this[r],h=!l,c={visibility:o,zIndex:s||.1};return typeof this.opacity<"u"&&!this.chart.styledMode&&this.state!=="inactive"&&(c.opacity=this.opacity),h&&(this[r]=l=this.chart.renderer.g().add(a)),l.addClass("highcharts-"+t+" highcharts-series-"+this.index+" highcharts-"+this.type+"-series "+(defined$G(this.colorIndex)?"highcharts-color-"+this.colorIndex+" ":"")+(this.options.className||"")+(l.hasClass("highcharts-tracker")?" highcharts-tracker":""),!0),l.attr(c)[h?"attr":"animate"](this.getPlotBox()),l},n.prototype.getPlotBox=function(){var r=this.chart,t=this.xAxis,o=this.yAxis;return r.inverted&&(t=o,o=this.xAxis),{translateX:t?t.left:r.plotLeft,translateY:o?o.top:r.plotTop,scaleX:1,scaleY:1}},n.prototype.removeEvents=function(r){var t=this;r||removeEvent$5(t),t.eventsToUnbind.length&&(t.eventsToUnbind.forEach(function(o){o()}),t.eventsToUnbind.length=0)},n.prototype.render=function(){var r=this,t=r.chart,o=r.options,s=animObject$6(o.animation),a=r.visible?"inherit":"hidden",l=o.zIndex,h=r.hasRendered,c=t.seriesGroup,d=t.inverted,p=!r.finishedAnimating&&t.renderer.isSVG&&s.duration;fireEvent$r(this,"render");var u=r.plotGroup("group","series",a,l,c);r.markerGroup=r.plotGroup("markerGroup","markers",a,l,c),p&&r.animate&&r.animate(!0),u.inverted=pick$1f(r.invertible,r.isCartesian)?d:!1,r.drawGraph&&(r.drawGraph(),r.applyZones()),r.visible&&r.drawPoints(),r.drawDataLabels&&r.drawDataLabels(),r.redrawPoints&&r.redrawPoints(),r.drawTracker&&r.options.enableMouseTracking!==!1&&r.drawTracker(),r.invertGroups(d),o.clip!==!1&&!r.sharedClipKey&&!h&&u.clip(t.clipRect),p&&r.animate&&r.animate(),h||(p&&s.defer&&(p+=s.defer),r.animationTimeout=syncTimeout$2(function(){r.afterAnimate()},p||0)),r.isDirty=!1,r.hasRendered=!0,fireEvent$r(r,"afterRender")},n.prototype.redraw=function(){var r=this,t=r.chart,o=r.isDirty||r.isDirtyData,s=r.group,a=r.xAxis,l=r.yAxis;s&&(t.inverted&&s.attr({width:t.plotWidth,height:t.plotHeight}),s.animate({translateX:pick$1f(a&&a.left,t.plotLeft),translateY:pick$1f(l&&l.top,t.plotTop)})),r.translate(),r.render(),o&&delete this.kdTree},n.prototype.searchPoint=function(r,t){var o=this,s=o.xAxis,a=o.yAxis,l=o.chart.inverted;return this.searchKDTree({clientX:l?s.len-r.chartY+s.pos:r.chartX-s.pos,plotY:l?a.len-r.chartX+a.pos:r.chartY-a.pos},t,r)},n.prototype.buildKDTree=function(r){this.buildingKdTree=!0;var t=this,o=t.options.findNearestPointBy.indexOf("y")>-1?2:1;function s(l,h,c){var d=l&&l.length,p,u;if(d)return p=t.kdAxisArray[h%c],l.sort(function(f,g){return f[p]-g[p]}),u=Math.floor(d/2),{point:l[u],left:s(l.slice(0,u),h+1,c),right:s(l.slice(u+1),h+1,c)}}function a(){t.kdTree=s(t.getValidPoints(null,!t.directTouch),o,o),t.buildingKdTree=!1}delete t.kdTree,syncTimeout$2(a,t.options.kdNow||r&&r.type==="touchstart"?0:1)},n.prototype.searchKDTree=function(r,t,o){var s=this,a=this.kdAxisArray[0],l=this.kdAxisArray[1],h=t?"distX":"dist",c=s.options.findNearestPointBy.indexOf("y")>-1?2:1;function d(u,f){var g=defined$G(u[a])&&defined$G(f[a])?Math.pow(u[a]-f[a],2):null,v=defined$G(u[l])&&defined$G(f[l])?Math.pow(u[l]-f[l],2):null,m=(g||0)+(v||0);f.dist=defined$G(m)?Math.sqrt(m):Number.MAX_VALUE,f.distX=defined$G(g)?Math.sqrt(g):Number.MAX_VALUE}function p(u,f,g,v){var m=f.point,x=s.kdAxisArray[g%v],y,b,$=m;d(u,m);var S=u[x]-m[x],k=S<0?"left":"right",A=S<0?"right":"left";return f[k]&&(y=p(u,f[k],g+1,v),$=y[h]<$[h]?y:m),f[A]&&Math.sqrt(S*S)<$[h]&&(b=p(u,f[A],g+1,v),$=b[h]<$[h]?b:$),$}if(!this.kdTree&&!this.buildingKdTree&&this.buildKDTree(o),this.kdTree)return p(r,this.kdTree,c,c)},n.prototype.pointPlacementToXValue=function(){var r=this,t=r.options,o=t.pointPlacement,s=t.pointRange,a=r.xAxis,l=o;return l==="between"&&(l=a.reversed?-.5:.5),isNumber$A(l)?l*(s||a.pointRange):0},n.prototype.isPointInside=function(r){var t=typeof r.plotY<"u"&&typeof r.plotX<"u"&&r.plotY>=0&&r.plotY<=this.yAxis.len&&r.plotX>=0&&r.plotX<=this.xAxis.len;return t},n.prototype.drawTracker=function(){var r=this,t=r.options,o=t.trackByArea,s=[].concat(o?r.areaPath:r.graphPath),a=r.chart,l=a.pointer,h=a.renderer,c=a.options.tooltip.snap,d=r.tracker,p=function(f){a.hoverSeries!==r&&r.onMouseOver()},u="rgba(192,192,192,"+(svg$2?1e-4:.002)+")";d?d.attr({d:s}):r.graph&&(r.tracker=h.path(s).attr({visibility:r.visible?"visible":"hidden",zIndex:2}).addClass(o?"highcharts-tracker-area":"highcharts-tracker-line").add(r.group),a.styledMode||r.tracker.attr({"stroke-linecap":"round","stroke-linejoin":"round",stroke:u,fill:o?u:"none","stroke-width":r.graph.strokeWidth()+(o?0:2*c)}),[r.tracker,r.markerGroup,r.dataLabelsGroup].forEach(function(f){f&&(f.addClass("highcharts-tracker").on("mouseover",p).on("mouseout",function(g){l.onTrackerMouseOut(g)}),t.cursor&&!a.styledMode&&f.css({cursor:t.cursor}),hasTouch$2&&f.on("touchstart",p))})),fireEvent$r(this,"afterDrawTracker")},n.prototype.addPoint=function(r,t,o,s,a){var l=this,h=l.options,c=l.data,d=l.chart,p=l.xAxis,u=p&&p.hasNames&&p.names,f=h.data,g=l.xData,v,m;t=pick$1f(t,!0);var x={series:l};l.pointClass.prototype.applyOptions.apply(x,[r]);var y=x.x;if(m=g.length,l.requireSorting&&y<g[m-1])for(v=!0;m&&g[m-1]>y;)m--;l.updateParallelArrays(x,"splice",m,0,0),l.updateParallelArrays(x,m),u&&x.name&&(u[y]=x.name),f.splice(m,0,r),v&&(l.data.splice(m,0,null),l.processData()),h.legendType==="point"&&l.generatePoints(),o&&(c[0]&&c[0].remove?c[0].remove(!1):(c.shift(),l.updateParallelArrays(x,"shift"),f.shift())),a!==!1&&fireEvent$r(l,"addPoint",{point:x}),l.isDirty=!0,l.isDirtyData=!0,t&&d.redraw(s)},n.prototype.removePoint=function(r,t,o){var s=this,a=s.data,l=a[r],h=s.points,c=s.chart,d=function(){h&&h.length===a.length&&h.splice(r,1),a.splice(r,1),s.options.data.splice(r,1),s.updateParallelArrays(l||{series:s},"splice",r,1),l&&l.destroy(),s.isDirty=!0,s.isDirtyData=!0,t&&c.redraw()};setAnimation$2(o,c),t=pick$1f(t,!0),l?l.firePointEvent("remove",null,d):d()},n.prototype.remove=function(r,t,o,s){var a=this,l=a.chart;function h(){a.destroy(s),l.isDirtyLegend=l.isDirtyBox=!0,l.linkSeries(),pick$1f(r,!0)&&l.redraw(t)}o!==!1?fireEvent$r(a,"remove",null,h):h()},n.prototype.update=function(r,t){r=cleanRecursively(r,this.userOptions),fireEvent$r(this,"update",{options:r});var o=this,s=o.chart,a=o.userOptions,l=o.initialType||o.type,h=s.options.plotOptions,c=seriesTypes$6[l].prototype,d=["group","markerGroup","dataLabelsGroup","transformGroup"],p=o.finishedAnimating&&{animation:!1},u={},f,g,v=["eventOptions","navigatorSeries","baseSeries"],m=r.type||a.type||s.options.chart.type,x=!(this.hasDerivedData||m&&m!==this.type||typeof r.pointStart<"u"||typeof r.pointInterval<"u"||typeof r.relativeXValue<"u"||o.hasOptionChanged("dataGrouping")||o.hasOptionChanged("pointStart")||o.hasOptionChanged("pointInterval")||o.hasOptionChanged("pointIntervalUnit")||o.hasOptionChanged("keys"));m=m||l,x&&(v.push("data","isDirtyData","points","processedXData","processedYData","xIncrement","cropped","_hasPointMarkers","_hasPointLabels","clips","nodes","layout","mapMap","mapData","minY","maxY","minX","maxX"),r.visible!==!1&&v.push("area","graph"),o.parallelArrays.forEach(function(k){v.push(k+"Data")}),r.data&&(r.dataSorting&&extend$1c(o.options.dataSorting,r.dataSorting),this.setData(r.data,!1))),r=merge$18(a,p,{index:typeof a.index>"u"?o.index:a.index,pointStart:pick$1f(h&&h.series&&h.series.pointStart,a.pointStart,o.xData[0])},!x&&{data:o.options.data},r),x&&r.data&&(r.data=o.options.data),v=d.concat(v),v.forEach(function(k){v[k]=o[k],delete o[k]});var y=!1;if(seriesTypes$6[m]){if(y=m!==o.type,o.remove(!1,!1,!1,!0),y)if(Object.setPrototypeOf)Object.setPrototypeOf(o,seriesTypes$6[m].prototype);else{var b=Object.hasOwnProperty.call(o,"hcEvents")&&o.hcEvents;for(g in c)o[g]=void 0;extend$1c(o,seriesTypes$6[m].prototype),b?o.hcEvents=b:delete o.hcEvents}}else error$4(17,!0,s,{missingModuleFor:m});if(v.forEach(function(k){o[k]=v[k]}),o.init(s,r),x&&this.points){if(f=o.options,f.visible===!1)u.graphic=1,u.dataLabel=1;else if(!o._hasPointLabels){var $=f.marker,S=f.dataLabels;$&&($.enabled===!1||(a.marker&&a.marker.symbol)!==$.symbol)&&(u.graphic=1),S&&S.enabled===!1&&(u.dataLabel=1)}this.points.forEach(function(k){k&&k.series&&(k.resolveColor(),Object.keys(u).length&&k.destroyElements(u),f.showInLegend===!1&&k.legendItem&&s.legend.destroyItem(k))},this)}o.initialType=l,s.linkSeries(),y&&o.linkedSeries.length&&(o.isDirtyData=!0),fireEvent$r(this,"afterUpdate"),pick$1f(t,!0)&&s.redraw(x?void 0:!1)},n.prototype.setName=function(r){this.name=this.options.name=this.userOptions.name=r,this.chart.isDirtyLegend=!0},n.prototype.hasOptionChanged=function(r){var t=this.chart,o=this.options[r],s=t.options.plotOptions,a=this.userOptions[r];return a?o!==a:o!==pick$1f(s&&s[this.type]&&s[this.type][r],s&&s.series&&s.series[r],o)},n.prototype.onMouseOver=function(){var r=this,t=r.chart,o=t.hoverSeries,s=t.pointer;s.setHoverChartIndex(),o&&o!==r&&o.onMouseOut(),r.options.events.mouseOver&&fireEvent$r(r,"mouseOver"),r.setState("hover"),t.hoverSeries=r},n.prototype.onMouseOut=function(){var r=this,t=r.options,o=r.chart,s=o.tooltip,a=o.hoverPoint;o.hoverSeries=null,a&&a.onMouseOut(),r&&t.events.mouseOut&&fireEvent$r(r,"mouseOut"),s&&!r.stickyTracking&&(!s.shared||r.noSharedTooltip)&&s.hide(),o.series.forEach(function(l){l.setState("",!0)})},n.prototype.setState=function(r,t){var o=this,s=o.options,a=o.graph,l=s.inactiveOtherPoints,h=s.states,c=pick$1f(h[r||"normal"]&&h[r||"normal"].animation,o.chart.options.chart.animation),d,p=s.lineWidth,u=0,f=s.opacity;if(r=r||"",o.state!==r&&([o.group,o.markerGroup,o.dataLabelsGroup].forEach(function(g){g&&(o.state&&g.removeClass("highcharts-series-"+o.state),r&&g.addClass("highcharts-series-"+r))}),o.state=r,!o.chart.styledMode)){if(h[r]&&h[r].enabled===!1)return;if(r&&(p=h[r].lineWidth||p+(h[r].lineWidthPlus||0),f=pick$1f(h[r].opacity,f)),a&&!a.dashstyle)for(d={"stroke-width":p},a.animate(d,c);o["zone-graph-"+u];)o["zone-graph-"+u].animate(d,c),u=u+1;l||[o.group,o.markerGroup,o.dataLabelsGroup,o.labelBySeries].forEach(function(g){g&&g.animate({opacity:f},c)})}t&&l&&o.points&&o.setAllPointsToState(r||void 0)},n.prototype.setAllPointsToState=function(r){this.points.forEach(function(t){t.setState&&t.setState(r)})},n.prototype.setVisible=function(r,t){var o=this,s=o.chart,a=o.legendItem,l=s.options.chart.ignoreHiddenSeries,h=o.visible;o.visible=r=o.options.visible=o.userOptions.visible=typeof r>"u"?!h:r;var c=r?"show":"hide";["group","dataLabelsGroup","markerGroup","tracker","tt"].forEach(function(d){o[d]&&o[d][c]()}),(s.hoverSeries===o||(s.hoverPoint&&s.hoverPoint.series)===o)&&o.onMouseOut(),a&&s.legend.colorizeItem(o,r),o.isDirty=!0,o.options.stacking&&s.series.forEach(function(d){d.options.stacking&&d.visible&&(d.isDirty=!0)}),o.linkedSeries.forEach(function(d){d.setVisible(r,!1)}),l&&(s.isDirtyBox=!0),fireEvent$r(o,c),t!==!1&&s.redraw()},n.prototype.show=function(){this.setVisible(!0)},n.prototype.hide=function(){this.setVisible(!1)},n.prototype.select=function(r){var t=this;t.selected=r=this.options.selected=typeof r>"u"?!t.selected:r,t.checkbox&&(t.checkbox.checked=r),fireEvent$r(t,r?"select":"unselect")},n.prototype.shouldShowTooltip=function(r,t,o){return o===void 0&&(o={}),o.series=this,o.visiblePlotOnly=!0,this.chart.isInsidePlot(r,t,o)},n.defaultOptions=seriesDefaults,n}();extend$1c(Series$e.prototype,{axisTypes:["xAxis","yAxis"],coll:"series",colorCounter:0,cropShoulder:1,directTouch:!1,drawLegendSymbol:LegendSymbol$1.drawLineMarker,isCartesian:!0,kdAxisArray:["clientX","plotY"],parallelArrays:["x","y"],pointClass:Point$2,requireSorting:!0,sorted:!0});SeriesRegistry$1.series=Series$e;var stop=animationExports.stop,addEvent$R=Utilities.addEvent,createElement$4=Utilities.createElement,merge$17=Utilities.merge,pick$1e=Utilities.pick;addEvent$R(Chart$1,"afterSetChartSize",function(n){var r=this.options.chart.scrollablePlotArea,t=r&&r.minWidth,o=r&&r.minHeight,s,a,l;this.renderer.forExport||(t?(this.scrollablePixelsX=s=Math.max(0,t-this.chartWidth),s&&(this.scrollablePlotBox=this.renderer.scrollablePlotBox=merge$17(this.plotBox),this.plotBox.width=this.plotWidth+=s,this.inverted?this.clipBox.height+=s:this.clipBox.width+=s,l={1:{name:"right",value:s}})):o&&(this.scrollablePixelsY=a=Math.max(0,o-this.chartHeight),a&&(this.scrollablePlotBox=this.renderer.scrollablePlotBox=merge$17(this.plotBox),this.plotBox.height=this.plotHeight+=a,this.inverted?this.clipBox.width+=a:this.clipBox.height+=a,l={2:{name:"bottom",value:a}})),l&&!n.skipAxes&&this.axes.forEach(function(h){l[h.side]?h.getPlotLinePath=function(){var c=l[h.side].name,d=l[h.side].value,p=this[c],u;return this[c]=p-d,u=Axis.prototype.getPlotLinePath.apply(this,arguments),this[c]=p,u}:(h.setAxisSize(),h.setAxisTranslation())}))});addEvent$R(Chart$1,"render",function(){this.scrollablePixelsX||this.scrollablePixelsY?(this.setUpScrolling&&this.setUpScrolling(),this.applyFixed()):this.fixedDiv&&this.applyFixed()});Chart$1.prototype.setUpScrolling=function(){var n=this,r={WebkitOverflowScrolling:"touch",overflowX:"hidden",overflowY:"hidden"};this.scrollablePixelsX&&(r.overflowX="auto"),this.scrollablePixelsY&&(r.overflowY="auto"),this.scrollingParent=createElement$4("div",{className:"highcharts-scrolling-parent"},{position:"relative"},this.renderTo),this.scrollingContainer=createElement$4("div",{className:"highcharts-scrolling"},r,this.scrollingParent),addEvent$R(this.scrollingContainer,"scroll",function(){n.pointer&&delete n.pointer.chartPosition}),this.innerContainer=createElement$4("div",{className:"highcharts-inner-container"},null,this.scrollingContainer),this.innerContainer.appendChild(this.container),this.setUpScrolling=null};Chart$1.prototype.moveFixedElements=function(){var n=this.container,r=this.fixedRenderer,t=[".highcharts-contextbutton",".highcharts-credits",".highcharts-legend",".highcharts-legend-checkbox",".highcharts-navigator-series",".highcharts-navigator-xaxis",".highcharts-navigator-yaxis",".highcharts-navigator",".highcharts-reset-zoom",".highcharts-drillup-button",".highcharts-scrollbar",".highcharts-subtitle",".highcharts-title"],o;this.scrollablePixelsX&&!this.inverted?o=".highcharts-yaxis":this.scrollablePixelsX&&this.inverted||this.scrollablePixelsY&&!this.inverted?o=".highcharts-xaxis":this.scrollablePixelsY&&this.inverted&&(o=".highcharts-yaxis"),o&&t.push(o+":not(.highcharts-radial-axis)",o+"-labels:not(.highcharts-radial-axis-labels)"),t.forEach(function(s){[].forEach.call(n.querySelectorAll(s),function(a){(a.namespaceURI===r.SVG_NS?r.box:r.box.parentNode).appendChild(a),a.style.pointerEvents="auto"})})};Chart$1.prototype.applyFixed=function(){var n=!this.fixedDiv,r=this.options.chart,t=r.scrollablePlotArea,o=RendererRegistry$1.getRendererType(),s,a,l;n?(this.fixedDiv=createElement$4("div",{className:"highcharts-fixed"},{position:"absolute",overflow:"hidden",pointerEvents:"none",zIndex:(r.style&&r.style.zIndex||0)+2,top:0},null,!0),this.scrollingContainer&&this.scrollingContainer.parentNode.insertBefore(this.fixedDiv,this.scrollingContainer),this.renderTo.style.overflow="visible",this.fixedRenderer=s=new o(this.fixedDiv,this.chartWidth,this.chartHeight,this.options.chart.style),this.scrollableMask=s.path().attr({fill:this.options.chart.backgroundColor||"#fff","fill-opacity":pick$1e(t.opacity,.85),zIndex:-1}).addClass("highcharts-scrollable-mask").add(),addEvent$R(this,"afterShowResetZoom",this.moveFixedElements),addEvent$R(this,"afterDrilldown",this.moveFixedElements),addEvent$R(this,"afterLayOutTitles",this.moveFixedElements)):this.fixedRenderer.setSize(this.chartWidth,this.chartHeight),(this.scrollableDirty||n)&&(this.scrollableDirty=!1,this.moveFixedElements()),a=this.chartWidth+(this.scrollablePixelsX||0),l=this.chartHeight+(this.scrollablePixelsY||0),stop(this.container),this.container.style.width=a+"px",this.container.style.height=l+"px",this.renderer.boxWrapper.attr({width:a,height:l,viewBox:[0,0,a,l].join(" ")}),this.chartBackground.attr({width:a,height:l}),this.scrollingContainer.style.height=this.chartHeight+"px",n&&(t.scrollPositionX&&(this.scrollingContainer.scrollLeft=this.scrollablePixelsX*t.scrollPositionX),t.scrollPositionY&&(this.scrollingContainer.scrollTop=this.scrollablePixelsY*t.scrollPositionY));var h=this.axisOffset,c=this.plotTop-h[0]-1,d=this.plotLeft-h[3]-1,p=this.plotTop+this.plotHeight+h[2]+1,u=this.plotLeft+this.plotWidth+h[1]+1,f=this.plotLeft+this.plotWidth-(this.scrollablePixelsX||0),g=this.plotTop+this.plotHeight-(this.scrollablePixelsY||0),v;this.scrollablePixelsX?v=[["M",0,c],["L",this.plotLeft-1,c],["L",this.plotLeft-1,p],["L",0,p],["Z"],["M",f,c],["L",this.chartWidth,c],["L",this.chartWidth,p],["L",f,p],["Z"]]:this.scrollablePixelsY?v=[["M",d,0],["L",d,this.plotTop-1],["L",u,this.plotTop-1],["L",u,0],["Z"],["M",d,g],["L",d,this.chartHeight],["L",u,this.chartHeight],["L",u,g],["Z"]]:v=[["M",0,0]],this.redrawTrigger!=="adjustHeight"&&this.scrollableMask.attr({d:v})};addEvent$R(Axis,"afterInit",function(){this.chart.scrollableDirty=!0});addEvent$R(Series$e,"show",function(){this.chart.scrollableDirty=!0});var getDeferredAnimation$2=animationExports.getDeferredAnimation,addEvent$Q=Utilities.addEvent,destroyObjectProperties$5=Utilities.destroyObjectProperties,fireEvent$q=Utilities.fireEvent,isNumber$z=Utilities.isNumber,objectEach$l=Utilities.objectEach,StackingAxis;(function(n){var r=[];function t(l){return r.indexOf(l)===-1&&(r.push(l),addEvent$Q(l,"init",s),addEvent$Q(l,"destroy",o)),l}n.compose=t;function o(){var l=this.stacking;if(l){var h=l.stacks;objectEach$l(h,function(c,d){destroyObjectProperties$5(c),h[d]=null}),l&&l.stackTotalGroup&&l.stackTotalGroup.destroy()}}function s(){var l=this;l.stacking||(l.stacking=new a(l))}var a=function(){function l(h){this.oldStacks={},this.stacks={},this.stacksTouched=0,this.axis=h}return l.prototype.buildStacks=function(){var h=this,c=h.axis,d=c.series,p=c.options.reversedStacks,u=d.length,f,g;if(!c.isXAxis){for(h.usePercentage=!1,g=u;g--;)f=d[p?g:u-g-1],f.setStackedPoints(),f.setGroupedPoints();for(g=0;g<u;g++)d[g].modifyStacks();fireEvent$q(c,"afterBuildStacks")}},l.prototype.cleanStacks=function(){var h=this,c=h.axis,d;c.isXAxis||(h.oldStacks&&(d=h.stacks=h.oldStacks),objectEach$l(d,function(p){objectEach$l(p,function(u){u.cumulative=u.total})}))},l.prototype.resetStacks=function(){var h=this,c=h.axis,d=h.stacks;c.isXAxis||objectEach$l(d,function(p){objectEach$l(p,function(u,f){isNumber$z(u.touched)&&u.touched<h.stacksTouched?(u.destroy(),delete p[f]):(u.total=null,u.cumulative=null)})})},l.prototype.renderStackTotals=function(){var h=this,c=h.axis,d=c.chart,p=d.renderer,u=h.stacks,f=c.options.stackLabels&&c.options.stackLabels.animation,g=getDeferredAnimation$2(d,f||!1),v=h.stackTotalGroup=h.stackTotalGroup||p.g("stack-labels").attr({visibility:"visible",zIndex:6,opacity:0}).add();v.translate(d.plotLeft,d.plotTop),objectEach$l(u,function(m){objectEach$l(m,function(x){x.render(v)})}),v.animate({opacity:1},g)},l}();n.Additions=a})(StackingAxis||(StackingAxis={}));const StackingAxis$1=StackingAxis;var format$9=FormatUtilities.format,correctFloat$9=Utilities.correctFloat,defined$F=Utilities.defined,destroyObjectProperties$4=Utilities.destroyObjectProperties,isArray$e=Utilities.isArray,isNumber$y=Utilities.isNumber,objectEach$k=Utilities.objectEach,pick$1d=Utilities.pick,StackItem=function(){function n(r,t,o,s,a){var l=r.chart.inverted;this.axis=r,this.isNegative=o,this.options=t=t||{},this.x=s,this.total=null,this.points={},this.hasValidPoints=!1,this.stack=a,this.leftCliff=0,this.rightCliff=0,this.alignOptions={align:t.align||(l?o?"left":"right":"center"),verticalAlign:t.verticalAlign||(l?"middle":o?"bottom":"top"),y:t.y,x:t.x},this.textAlign=t.textAlign||(l?o?"right":"left":"center")}return n.prototype.destroy=function(){destroyObjectProperties$4(this,this.axis)},n.prototype.render=function(r){var t=this.axis.chart,o=this.options,s=o.format,a={},l=s?format$9(s,this,t):o.formatter.call(this);this.label?this.label.attr({text:l,visibility:"hidden"}):(this.label=t.renderer.label(l,null,null,o.shape,null,null,o.useHTML,!1,"stack-labels"),a={r:o.borderRadius||0,text:l,rotation:o.rotation,padding:pick$1d(o.padding,5),visibility:"hidden"},t.styledMode||(a.fill=o.backgroundColor,a.stroke=o.borderColor,a["stroke-width"]=o.borderWidth,this.label.css(o.style)),this.label.attr(a),this.label.added||this.label.add(r)),this.label.labelrank=t.plotSizeY},n.prototype.setOffset=function(r,t,o,s,a){var l=this,h=l.axis,c=h.chart,d=h.translate(h.stacking.usePercentage?100:s||l.total,0,0,0,1),p=h.translate(o||0),u=defined$F(d)&&Math.abs(d-p),f=pick$1d(a,c.xAxis[0].translate(l.x))+r,g=defined$F(d)&&l.getStackBox(c,l,f,d,t,u,h),v=l.label,m=l.isNegative,x=pick$1d(l.options.overflow,"justify")==="justify",y=l.textAlign,b;if(v&&g){var $=v.getBBox(),S=v.padding,k=void 0,A=void 0;y==="left"?k=c.inverted?-S:S:y==="right"?k=$.width:c.inverted&&y==="center"?k=$.width/2:k=c.inverted?m?$.width+S:-S:$.width/2,A=c.inverted?$.height/2:m?-S:$.height,l.alignOptions.x=pick$1d(l.options.x,0),l.alignOptions.y=pick$1d(l.options.y,0),g.x-=k,g.y-=A,v.align(l.alignOptions,null,g),c.isInsidePlot(v.alignAttr.x+k-l.alignOptions.x,v.alignAttr.y+A-l.alignOptions.y)?v.show():(v.alignAttr.y=-9999,x=!1),x&&Series$e.prototype.justifyDataLabel.call(this.axis,v,l.alignOptions,v.alignAttr,$,g),v.attr({x:v.alignAttr.x,y:v.alignAttr.y}),pick$1d(!x&&l.options.crop,!0)&&(b=isNumber$y(v.x)&&isNumber$y(v.y)&&c.isInsidePlot(v.x-S+v.width,v.y)&&c.isInsidePlot(v.x+S,v.y),b||v.hide())}},n.prototype.getStackBox=function(r,t,o,s,a,l,h){var c=t.axis.reversed,d=r.inverted,p=h.height+h.pos-(d?r.plotLeft:r.plotTop),u=t.isNegative&&!c||!t.isNegative&&c;return{x:d?u?s-h.right:s-l+h.pos-r.plotLeft:o+r.xAxis[0].transB-r.plotLeft,y:d?h.height-o-a:u?p-s-l:p-s,width:d?l:a,height:d?a:l}},n}();Chart$1.prototype.getStacks=function(){var n=this,r=n.inverted;n.yAxis.forEach(function(t){t.stacking&&t.stacking.stacks&&t.hasVisibleSeries&&(t.stacking.oldStacks=t.stacking.stacks)}),n.series.forEach(function(t){var o=t.xAxis&&t.xAxis.options||{};t.options.stacking&&(t.visible===!0||n.options.chart.ignoreHiddenSeries===!1)&&(t.stackKey=[t.type,pick$1d(t.options.stack,""),r?o.top:o.left,r?o.height:o.width].join(","))})};StackingAxis$1.compose(Axis);Series$e.prototype.setGroupedPoints=function(){var n=this.yAxis.stacking;this.options.centerInCategory&&(this.is("column")||this.is("columnrange"))&&!this.options.stacking&&this.chart.series.length>1?Series$e.prototype.setStackedPoints.call(this,"group"):n&&objectEach$k(n.stacks,function(r,t){t.slice(-5)==="group"&&(objectEach$k(r,function(o){return o.destroy()}),delete n.stacks[t])})};Series$e.prototype.setStackedPoints=function(n){var r=n||this.options.stacking;if(!(!r||this.visible!==!0&&this.chart.options.chart.ignoreHiddenSeries!==!1)){var t=this,o=t.processedXData,s=t.processedYData,a=[],l=s.length,h=t.options,c=h.threshold,d=pick$1d(h.startFromThreshold&&c,0),p=h.stack,u=n?t.type+","+r:t.stackKey,f="-"+u,g=t.negStacks,v=t.yAxis,m=v.stacking.stacks,x=v.stacking.oldStacks,y,b,$,S,k,A,P,E,M;for(v.stacking.stacksTouched+=1,P=0;P<l;P++)E=o[P],M=s[P],y=t.getStackIndicator(y,E,t.index),A=y.key,b=g&&M<(d?0:c),k=b?f:u,m[k]||(m[k]={}),m[k][E]||(x[k]&&x[k][E]?(m[k][E]=x[k][E],m[k][E].total=null):m[k][E]=new StackItem(v,v.options.stackLabels,b,E,p)),$=m[k][E],M!==null?($.points[A]=$.points[t.index]=[pick$1d($.cumulative,d)],defined$F($.cumulative)||($.base=A),$.touched=v.stacking.stacksTouched,y.index>0&&t.singleStacks===!1&&($.points[A][0]=$.points[t.index+","+E+",0"][0])):$.points[A]=$.points[t.index]=null,r==="percent"?(S=b?u:f,g&&m[S]&&m[S][E]?(S=m[S][E],$.total=S.total=Math.max(S.total,$.total)+Math.abs(M)||0):$.total=correctFloat$9($.total+(Math.abs(M)||0))):r==="group"?(isArray$e(M)&&(M=M[0]),M!==null&&($.total=($.total||0)+1)):$.total=correctFloat$9($.total+(M||0)),r==="group"?$.cumulative=($.total||1)-1:$.cumulative=pick$1d($.cumulative,d)+(M||0),M!==null&&($.points[A].push($.cumulative),a[P]=$.cumulative,$.hasValidPoints=!0);r==="percent"&&(v.stacking.usePercentage=!0),r!=="group"&&(this.stackedYData=a),v.stacking.oldStacks={}}};Series$e.prototype.modifyStacks=function(){var n=this,r=n.yAxis,t=n.stackKey,o=r.stacking.stacks,s=n.processedXData,a,l=n.options.stacking;n[l+"Stacker"]&&[t,"-"+t].forEach(function(h){for(var c=s.length,d,p,u;c--;)d=s[c],a=n.getStackIndicator(a,d,n.index,h),p=o[h]&&o[h][d],u=p&&p.points[a.key],u&&n[l+"Stacker"](u,p,c)})};Series$e.prototype.percentStacker=function(n,r,t){var o=r.total?100/r.total:0;n[0]=correctFloat$9(n[0]*o),n[1]=correctFloat$9(n[1]*o),this.stackedYData[t]=n[1]};Series$e.prototype.getStackIndicator=function(n,r,t,o){return!defined$F(n)||n.x!==r||o&&n.key!==o?n={x:r,index:0,key:o}:n.index++,n.key=[t,r,n.index].join(","),n};H.StackItem=StackItem;const StackItem$1=H.StackItem;var __extends$U=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),defined$E=Utilities.defined,merge$16=Utilities.merge,LineSeries$5=function(n){__extends$U(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.drawGraph=function(){var t=this,o=this.options,s=(this.gappedPath||this.getGraphPath).call(this),a=this.chart.styledMode,l=[["graph","highcharts-graph"]];a||l[0].push(o.lineColor||this.color||palette.neutralColor20,o.dashStyle),l=t.getZonesGraphs(l),l.forEach(function(h,c){var d=h[0],p,u=t[d],f=u?"animate":"attr";u?(u.endX=t.preventGraphAnimation?null:s.xMap,u.animate({d:s})):s.length&&(t[d]=u=t.chart.renderer.path(s).addClass(h[1]).attr({zIndex:1}).add(t.group)),u&&!a&&(p={stroke:h[2],"stroke-width":o.lineWidth,fill:t.fillGraph&&t.color||"none"},h[3]?p.dashstyle=h[3]:o.linecap!=="square"&&(p["stroke-linecap"]=p["stroke-linejoin"]="round"),u[f](p).shadow(c<2&&o.shadow)),u&&(u.startX=s.xMap,u.isArea=s.isArea)})},r.prototype.getGraphPath=function(t,o,s){var a=this,l=a.options,h=[],c=[],d,p=l.step;t=t||a.points;var u=t.reversed;return u&&t.reverse(),p={right:1,center:2}[p]||p&&3,p&&u&&(p=4-p),t=this.getValidPoints(t,!1,!(l.connectNulls&&!o&&!s)),t.forEach(function(f,g){var v=f.plotX,m=f.plotY,x=t[g-1],y;(f.leftCliff||x&&x.rightCliff)&&!s&&(d=!0),f.isNull&&!defined$E(o)&&g>0?d=!l.connectNulls:f.isNull&&!o?d=!0:(g===0||d?y=[["M",f.plotX,f.plotY]]:a.getPointSpline?y=[a.getPointSpline(t,f,g)]:p?(p===1?y=[["L",x.plotX,m]]:p===2?y=[["L",(x.plotX+v)/2,x.plotY],["L",(x.plotX+v)/2,m]]:y=[["L",v,x.plotY]],y.push(["L",v,m])):y=[["L",v,m]],c.push(f.x),p&&(c.push(f.x),p===2&&c.push(f.x)),h.push.apply(h,y),d=!1)}),h.xMap=c,a.graphPath=h,h},r.prototype.getZonesGraphs=function(t){return this.zones.forEach(function(o,s){var a=["zone-graph-"+s,"highcharts-graph highcharts-zone-graph-"+s+" "+(o.className||"")];this.chart.styledMode||a.push(o.color||this.color,o.dashStyle||this.options.dashStyle),t.push(a)},this),t},r.defaultOptions=merge$16(Series$e.defaultOptions,{}),r}(Series$e);SeriesRegistry$1.registerSeriesType("line",LineSeries$5);var __extends$T=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),color$d=Color.parse,LineSeries$4=SeriesRegistry$1.seriesTypes.line,extend$1b=Utilities.extend,merge$15=Utilities.merge,objectEach$j=Utilities.objectEach,pick$1c=Utilities.pick,AreaSeries$1=function(n){__extends$T(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.drawGraph=function(){this.areaPath=[],n.prototype.drawGraph.apply(this);var t=this,o=this.areaPath,s=this.options,a=this.zones,l=[["area","highcharts-area",this.color,s.fillColor]];a.forEach(function(h,c){l.push(["zone-area-"+c,"highcharts-area highcharts-zone-area-"+c+" "+h.className,h.color||t.color,h.fillColor||s.fillColor])}),l.forEach(function(h){var c=h[0],d=t[c],p=d?"animate":"attr",u={};d?(d.endX=t.preventGraphAnimation?null:o.xMap,d.animate({d:o})):(u.zIndex=0,d=t[c]=t.chart.renderer.path(o).addClass(h[1]).add(t.group),d.isArea=!0),t.chart.styledMode||(u.fill=pick$1c(h[3],color$d(h[2]).setOpacity(pick$1c(s.fillOpacity,.75)).get())),d[p](u),d.startX=o.xMap,d.shiftUnit=s.step?2:1})},r.prototype.getGraphPath=function(t){var o=LineSeries$4.prototype.getGraphPath,s,a=this.options,l=a.stacking,h=this.yAxis,c,d,p=[],u=[],f=this.index,g,v,m,x=h.stacking.stacks[this.stackKey],y=a.threshold,b=Math.round(h.getThreshold(a.threshold)),$,S,k=pick$1c(a.connectNulls,l==="percent"),A=function(E,M,T){var O=t[E],L=l&&x[O.x].points[f],C=O[T+"Null"]||0,U=O[T+"Cliff"]||0,D,N,I=!0;U||C?(D=(C?L[0]:L[1])+U,N=L[0]+U,I=!!C):!l&&t[M]&&t[M].isNull&&(D=N=y),typeof D<"u"&&(u.push({plotX:m,plotY:D===null?b:h.getThreshold(D),isNull:I,isCliff:!0}),p.push({plotX:m,plotY:N===null?b:h.getThreshold(N),doCurve:!1}))};for(t=t||this.points,l&&(t=this.getStackPoints(t)),g=0;g<t.length;g++)l||(t[g].leftCliff=t[g].rightCliff=t[g].leftNull=t[g].rightNull=void 0),$=t[g].isNull,m=pick$1c(t[g].rectPlotX,t[g].plotX),S=l?pick$1c(t[g].yBottom,b):b,(!$||k)&&(k||A(g,g-1,"left"),$&&!l&&k||(u.push(t[g]),p.push({x:g,plotX:m,plotY:S})),k||A(g,g+1,"right"));c=o.call(this,u,!0,!0),p.reversed=!0,d=o.call(this,p,!0,!0);var P=d[0];return P&&P[0]==="M"&&(d[0]=["L",P[1],P[2]]),v=c.concat(d),v.length&&v.push(["Z"]),s=o.call(this,u,!1,k),v.xMap=c.xMap,this.areaPath=v,s},r.prototype.getStackPoints=function(t){var o=this,s=[],a=[],l=this.xAxis,h=this.yAxis,c=h.stacking.stacks[this.stackKey],d={},p=h.series,u=p.length,f=h.options.reversedStacks?1:-1,g=p.indexOf(o);if(t=t||this.points,this.options.stacking){for(var v=0;v<t.length;v++)t[v].leftNull=t[v].rightNull=void 0,d[t[v].x]=t[v];objectEach$j(c,function(x,y){x.total!==null&&a.push(y)}),a.sort(function(x,y){return x-y});var m=p.map(function(x){return x.visible});a.forEach(function(x,y){var b=0,$,S;if(d[x]&&!d[x].isNull)s.push(d[x]),[-1,1].forEach(function(P){var E=P===1?"rightNull":"leftNull",M=P===1?"rightCliff":"leftCliff",T=0,O=c[a[y+P]];if(O)for(var L=g;L>=0&&L<u;){var C=p[L].index;$=O.points[C],$||(C===o.index?d[x][E]=!0:m[L]&&(S=c[x].points[C],S&&(T-=S[1]-S[0]))),L+=f}d[x][M]=T});else{for(var k=g;k>=0&&k<u;){var A=p[k].index;if($=c[x].points[A],$){b=$[1];break}k+=f}b=pick$1c(b,0),b=h.translate(b,0,1,0,1),s.push({isNull:!0,plotX:l.translate(x,0,0,0,1),x,plotY:b,yBottom:b})}})}return s},r.defaultOptions=merge$15(LineSeries$4.defaultOptions,{threshold:0}),r}(LineSeries$4);extend$1b(AreaSeries$1.prototype,{singleStacks:!1,drawLegendSymbol:LegendSymbol$1.drawRectangle});SeriesRegistry$1.registerSeriesType("area",AreaSeries$1);var __extends$S=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),LineSeries$3=SeriesRegistry$1.seriesTypes.line,merge$14=Utilities.merge,pick$1b=Utilities.pick,SplineSeries$1=function(n){__extends$S(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.getPointSpline=function(t,o,s){var a=1.5,l=a+1,h=o.plotX||0,c=o.plotY||0,d=t[s-1],p=t[s+1],u,f,g,v,m;function x(A){return A&&!A.isNull&&A.doCurve!==!1&&!o.isCliff}if(x(d)&&x(p)){var y=d.plotX||0,b=d.plotY||0,$=p.plotX||0,S=p.plotY||0,k=0;u=(a*h+y)/l,f=(a*c+b)/l,g=(a*h+$)/l,v=(a*c+S)/l,g!==u&&(k=(v-f)*(g-h)/(g-u)+c-v),f+=k,v+=k,f>b&&f>c?(f=Math.max(b,c),v=2*c-f):f<b&&f<c&&(f=Math.min(b,c),v=2*c-f),v>S&&v>c?(v=Math.max(S,c),f=2*c-v):v<S&&v<c&&(v=Math.min(S,c),f=2*c-v),o.rightContX=g,o.rightContY=v}return m=["C",pick$1b(d.rightContX,d.plotX,0),pick$1b(d.rightContY,d.plotY,0),pick$1b(u,h,0),pick$1b(f,c,0),h,c],d.rightContX=d.rightContY=void 0,m},r.defaultOptions=merge$14(LineSeries$3.defaultOptions),r}(LineSeries$3);SeriesRegistry$1.registerSeriesType("spline",SplineSeries$1);var __extends$R=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),areaProto$1=AreaSeries$1.prototype,extend$1a=Utilities.extend,merge$13=Utilities.merge,AreaSplineSeries=function(n){__extends$R(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.points=void 0,t.options=void 0,t}return r.defaultOptions=merge$13(SplineSeries$1.defaultOptions,AreaSeries$1.defaultOptions),r}(SplineSeries$1);extend$1a(AreaSplineSeries.prototype,{getGraphPath:areaProto$1.getGraphPath,getStackPoints:areaProto$1.getStackPoints,drawGraph:areaProto$1.drawGraph,drawLegendSymbol:LegendSymbol$1.drawRectangle});SeriesRegistry$1.registerSeriesType("areaspline",AreaSplineSeries);var __extends$Q=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),animObject$5=animationExports.animObject,color$c=Color.parse,hasTouch$1=H.hasTouch,noop$h=H.noop,clamp$d=Utilities.clamp,css$4=Utilities.css,defined$D=Utilities.defined,extend$19=Utilities.extend,fireEvent$p=Utilities.fireEvent,isArray$d=Utilities.isArray,isNumber$x=Utilities.isNumber,merge$12=Utilities.merge,pick$1a=Utilities.pick,objectEach$i=Utilities.objectEach,ColumnSeries$h=function(n){__extends$Q(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.borderWidth=void 0,t.data=void 0,t.group=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.animate=function(t){var o=this,s=this.yAxis,a=o.options,l=this.chart.inverted,h={},c=l?"translateX":"translateY",d,p;t?(h.scaleY=.001,p=clamp$d(s.toPixels(a.threshold),s.pos,s.pos+s.len),l?h.translateX=p-s.len:h.translateY=p,o.clipBox&&o.setClip(),o.group.attr(h)):(d=Number(o.group.attr(c)),o.group.animate({scaleY:1},extend$19(animObject$5(o.options.animation),{step:function(u,f){o.group&&(h[c]=d+f.pos*(s.pos-d),o.group.attr(h))}})))},r.prototype.init=function(t,o){n.prototype.init.apply(this,arguments);var s=this;t=s.chart,t.hasRendered&&t.series.forEach(function(a){a.type===s.type&&(a.isDirty=!0)})},r.prototype.getColumnMetrics=function(){var t=this,o=t.options,s=t.xAxis,a=t.yAxis,l=s.options.reversedStacks,h=s.reversed&&!l||!s.reversed&&l,c={},d,p=0;o.grouping===!1?p=1:t.chart.series.forEach(function($){var S=$.yAxis,k=$.options,A;$.type===t.type&&($.visible||!t.chart.options.chart.ignoreHiddenSeries)&&a.len===S.len&&a.pos===S.pos&&(k.stacking&&k.stacking!=="group"?(d=$.stackKey,typeof c[d]>"u"&&(c[d]=p++),A=c[d]):k.grouping!==!1&&(A=p++),$.columnIndex=A)});var u=Math.min(Math.abs(s.transA)*(s.ordinal&&s.ordinal.slope||o.pointRange||s.closestPointRange||s.tickInterval||1),s.len),f=u*o.groupPadding,g=u-2*f,v=g/(p||1),m=Math.min(o.maxPointWidth||s.len,pick$1a(o.pointWidth,v*(1-2*o.pointPadding))),x=(v-m)/2,y=(t.columnIndex||0)+(h?1:0),b=x+(f+y*v-u/2)*(h?-1:1);return t.columnMetrics={width:m,offset:b,paddedWidth:v,columnCount:p},t.columnMetrics},r.prototype.crispCol=function(t,o,s,a){var l=this.chart,h=this.borderWidth,c=-(h%2?.5:0),d,p=h%2?.5:1;l.inverted&&l.renderer.isVML&&(p+=1),this.options.crisp&&(d=Math.round(t+s)+c,t=Math.round(t)+c,s=d-t);var u=Math.round(o+a)+p,f=Math.abs(o)<=.5&&u>.5;return o=Math.round(o)+p,a=u-o,f&&a&&(o-=1,a+=1),{x:t,y:o,width:s,height:a}},r.prototype.adjustForMissingColumns=function(t,o,s,a){var l=this,h=this.options.stacking;if(!s.isNull&&a.columnCount>1){var c=0,d=0;objectEach$i(this.yAxis.stacking&&this.yAxis.stacking.stacks,function(u){if(typeof s.x=="number"){var f=u[s.x.toString()];if(f){var g=f.points[l.index],v=f.total;h?(g&&(c=d),f.hasValidPoints&&d++):isArray$d(g)&&(c=g[1],d=v||0)}}});var p=(d-1)*a.paddedWidth+o;t=(s.plotX||0)+p/2-o-c*a.paddedWidth}return t},r.prototype.translate=function(){var t=this,o=t.chart,s=t.options,a=t.dense=t.closestPointRange*t.xAxis.transA<2,l=t.borderWidth=pick$1a(s.borderWidth,a?0:1),h=t.xAxis,c=t.yAxis,d=s.threshold,p=t.translatedThreshold=c.getThreshold(d),u=pick$1a(s.minPointLength,5),f=t.getColumnMetrics(),g=f.width,v=t.pointXOffset=f.offset,m=t.dataMin,x=t.dataMax,y=t.barW=Math.max(g,1+2*l);o.inverted&&(p-=.5),s.pointPadding&&(y=Math.ceil(y)),Series$e.prototype.translate.apply(t),t.points.forEach(function(b){var $=pick$1a(b.yBottom,p),S=999+Math.abs($),k=b.plotX||0,A=clamp$d(b.plotY,-S,c.len+S),P,E=Math.min(A,$),M=Math.max(A,$)-E,T=g,O=k+v,L=y;u&&Math.abs(M)<u&&(M=u,P=!c.reversed&&!b.negative||c.reversed&&b.negative,isNumber$x(d)&&isNumber$x(x)&&b.y===d&&x<=d&&(c.min||0)<d&&(m!==x||(c.max||0)<=d)&&(P=!P),E=Math.abs(E-p)>u?$-u:p-(P?u:0)),defined$D(b.options.pointWidth)&&(T=L=Math.ceil(b.options.pointWidth),O-=Math.round((T-g)/2)),s.centerInCategory&&(O=t.adjustForMissingColumns(O,T,b,f)),b.barX=O,b.pointWidth=T,b.tooltipPos=o.inverted?[clamp$d(c.len+c.pos-o.plotLeft-A,c.pos-o.plotLeft,c.len+c.pos-o.plotLeft),h.len+h.pos-o.plotTop-O-L/2,M]:[h.left-o.plotLeft+O+L/2,clamp$d(A+c.pos-o.plotTop,c.pos-o.plotTop,c.len+c.pos-o.plotTop),M],b.shapeType=t.pointClass.prototype.shapeType||"rect",b.shapeArgs=t.crispCol.apply(t,b.isNull?[O,p,L,0]:[O,E,L,M])})},r.prototype.drawGraph=function(){this.group[this.dense?"addClass":"removeClass"]("highcharts-dense-data")},r.prototype.pointAttribs=function(t,o){var s=this.options,a=this.pointAttrToOptions||{},l=a.stroke||"borderColor",h=a["stroke-width"]||"borderWidth",c,d,p,u=t&&t.color||this.color,f=t&&t[l]||s[l]||u,g=t&&t.options.dashStyle||s.dashStyle,v=t&&t[h]||s[h]||this[h]||0,m=pick$1a(t&&t.opacity,s.opacity,1);t&&this.zones.length&&(d=t.getZone(),u=t.options.color||d&&(d.color||t.nonZonedColor)||this.color,d&&(f=d.borderColor||f,g=d.dashStyle||g,v=d.borderWidth||v)),o&&t&&(c=merge$12(s.states[o],t.options.states&&t.options.states[o]||{}),p=c.brightness,u=c.color||typeof p<"u"&&color$c(u).brighten(c.brightness).get()||u,f=c[l]||f,v=c[h]||v,g=c.dashStyle||g,m=pick$1a(c.opacity,m));var x={fill:u,stroke:f,"stroke-width":v,opacity:m};return g&&(x.dashstyle=g),x},r.prototype.drawPoints=function(){var t=this,o=this.chart,s=t.options,a=o.renderer,l=s.animationLimit||250,h;t.points.forEach(function(c){var d=c.plotY,p=c.graphic,u=!!p,f=p&&o.pointCount<l?"animate":"attr";isNumber$x(d)&&c.y!==null?(h=c.shapeArgs,p&&c.hasNewShapeType()&&(p=p.destroy()),t.enabledDataSorting&&(c.startXPos=t.xAxis.reversed?-(h&&h.width||0):t.xAxis.width),p||(c.graphic=p=a[c.shapeType](h).add(c.group||t.group),p&&t.enabledDataSorting&&o.hasRendered&&o.pointCount<l&&(p.attr({x:c.startXPos}),u=!0,f="animate")),p&&u&&p[f](merge$12(h)),s.borderRadius&&p[f]({r:s.borderRadius}),o.styledMode||p[f](t.pointAttribs(c,c.selected&&"select")).shadow(c.allowShadow!==!1&&s.shadow,null,s.stacking&&!s.borderRadius),p&&(p.addClass(c.getClassName(),!0),p.attr({visibility:c.visible?"inherit":"hidden"}))):p&&(c.graphic=p.destroy())})},r.prototype.drawTracker=function(){var t=this,o=t.chart,s=o.pointer,a=function(h){var c=s.getPointFromEvent(h);typeof c<"u"&&(s.isDirectTouch=!0,c.onMouseOver(h))},l;t.points.forEach(function(h){l=isArray$d(h.dataLabels)?h.dataLabels:h.dataLabel?[h.dataLabel]:[],h.graphic&&(h.graphic.element.point=h),l.forEach(function(c){c.div?c.div.point=h:c.element.point=h})}),t._hasTracking||(t.trackerGroups.forEach(function(h){t[h]&&(t[h].addClass("highcharts-tracker").on("mouseover",a).on("mouseout",function(c){s.onTrackerMouseOut(c)}),hasTouch$1&&t[h].on("touchstart",a),!o.styledMode&&t.options.cursor&&t[h].css(css$4).css({cursor:t.options.cursor}))}),t._hasTracking=!0),fireEvent$p(this,"afterDrawTracker")},r.prototype.remove=function(){var t=this,o=t.chart;o.hasRendered&&o.series.forEach(function(s){s.type===t.type&&(s.isDirty=!0)}),Series$e.prototype.remove.apply(t,arguments)},r.defaultOptions=merge$12(Series$e.defaultOptions,{borderRadius:0,centerInCategory:!1,groupPadding:.2,marker:null,pointPadding:.1,minPointLength:0,cropThreshold:50,pointRange:null,states:{hover:{halo:!1,brightness:.1},select:{color:palette.neutralColor20,borderColor:palette.neutralColor100}},dataLabels:{align:void 0,verticalAlign:void 0,y:void 0},startFromThreshold:!0,stickyTracking:!1,tooltip:{distance:6},threshold:0,borderColor:palette.backgroundColor}),r}(Series$e);extend$19(ColumnSeries$h.prototype,{cropShoulder:0,directTouch:!0,drawLegendSymbol:LegendSymbol$1.drawRectangle,getSymbol:noop$h,negStacks:!0,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("column",ColumnSeries$h);var getDeferredAnimation$1=animationExports.getDeferredAnimation,format$8=FormatUtilities.format,defined$C=Utilities.defined,extend$18=Utilities.extend,fireEvent$o=Utilities.fireEvent,isArray$c=Utilities.isArray,merge$11=Utilities.merge,objectEach$h=Utilities.objectEach,pick$19=Utilities.pick,splat$b=Utilities.splat,DataLabel;(function(n){var r=[];function t(d,p,u,f,g){var v=this,m=this.chart,x=this.isCartesian&&m.inverted,y=this.enabledDataSorting,b=pick$19(d.dlBox&&d.dlBox.centerX,d.plotX,-9999),$=pick$19(d.plotY,-9999),S=p.getBBox(),k=u.rotation,A=u.align,P=m.isInsidePlot(b,Math.round($),{inverted:x,paneCoordinates:!0,series:v}),E=function(N){y&&v.xAxis&&!U&&v.setDataLabelStartPos(d,p,g,P,N)},M,T,O,L,C,U=pick$19(u.overflow,y?"none":"justify")==="justify",D=this.visible&&d.visible!==!1&&(d.series.forceDL||y&&!U||P||pick$19(u.inside,!!this.options.stacking)&&f&&m.isInsidePlot(b,x?f.x+1:f.y+f.height-1,{inverted:x,paneCoordinates:!0,series:v}));D&&(M=m.renderer.fontMetrics(m.styledMode?void 0:u.style.fontSize,p).b,f=extend$18({x:x?this.yAxis.len-$:b,y:Math.round(x?this.xAxis.len-b:$),width:0,height:0},f),extend$18(u,{width:S.width,height:S.height}),k?(U=!1,L=m.renderer.rotCorr(M,k),C={x:f.x+(u.x||0)+f.width/2+L.x,y:f.y+(u.y||0)+{top:0,middle:.5,bottom:1}[u.verticalAlign]*f.height},E(C),p[g?"attr":"animate"](C).attr({align:A}),T=(k+720)%360,O=T>180&&T<360,A==="left"?C.y-=O?S.height:0:A==="center"?(C.x-=S.width/2,C.y-=S.height/2):A==="right"&&(C.x-=S.width,C.y-=O?0:S.height),p.placed=!0,p.alignAttr=C):(E(f),p.align(u,void 0,f),C=p.alignAttr),U&&f.height>=0?this.justifyDataLabel(p,u,C,S,f,g):pick$19(u.crop,!0)&&(D=m.isInsidePlot(C.x,C.y,{paneCoordinates:!0,series:v})&&m.isInsidePlot(C.x+S.width,C.y+S.height,{paneCoordinates:!0,series:v})),u.shape&&!k&&p[g?"attr":"animate"]({anchorX:x?m.plotWidth-d.plotY:d.plotX,anchorY:x?m.plotHeight-d.plotX:d.plotY})),g&&y&&(p.placed=!1),!D&&(!y||U)&&(p.hide(!0),p.placed=!1)}function o(d,p){var u=p.filter;if(u){var f=u.operator,g=d[u.property],v=u.value;return f===">"&&g>v||f==="<"&&g<v||f===">="&&g>=v||f==="<="&&g<=v||f==="=="&&g==v||f==="==="&&g===v}return!0}function s(d){if(r.indexOf(d)===-1){var p=d.prototype;r.push(d),p.alignDataLabel=t,p.drawDataLabels=a,p.justifyDataLabel=l,p.setDataLabelStartPos=c}}n.compose=s;function a(){var d=this,p=d.chart,u=d.options,f=d.points,g=d.hasRendered||0,v=p.renderer,m=u.dataLabels,x,y,b=m.animation,$=m.defer?getDeferredAnimation$1(p,b,d):{defer:0,duration:0};if(m=h(h(p.options.plotOptions&&p.options.plotOptions.series&&p.options.plotOptions.series.dataLabels,p.options.plotOptions&&p.options.plotOptions[d.type]&&p.options.plotOptions[d.type].dataLabels),m),fireEvent$o(this,"drawDataLabels"),isArray$c(m)||m.enabled||d._hasPointLabels){if(y=d.plotGroup("dataLabelsGroup","data-labels",g?"inherit":"hidden",m.zIndex||6),y.attr({opacity:+g}),!g){var S=d.dataLabelsGroup;S&&(d.visible&&y.show(!0),S[u.animation?"animate":"attr"]({opacity:1},$))}f.forEach(function(k){x=splat$b(h(m,k.dlOptions||k.options&&k.options.dataLabels)),x.forEach(function(A,P){var E=A.enabled&&(!k.isNull||k.dataLabelOnNull)&&o(k,A),M=k.connectors?k.connectors[P]:k.connector,T,O,L,C,U,D,N=k.dataLabels?k.dataLabels[P]:k.dataLabel,I=pick$19(A.distance,k.labelDistance),B=!N;E&&(T=k.getLabelConfig(),O=pick$19(A[k.formatPrefix+"Format"],A.format),L=defined$C(O)?format$8(O,T,p):(A[k.formatPrefix+"Formatter"]||A.formatter).call(T,A),C=A.style,U=A.rotation,p.styledMode||(C.color=pick$19(A.color,C.color,d.color,palette.neutralColor100),C.color==="contrast"?(k.contrastColor=v.getContrast(k.color||d.color),C.color=!defined$C(I)&&A.inside||I<0||u.stacking?k.contrastColor:palette.neutralColor100):delete k.contrastColor,u.cursor&&(C.cursor=u.cursor)),D={r:A.borderRadius||0,rotation:U,padding:A.padding,zIndex:1},p.styledMode||(D.fill=A.backgroundColor,D.stroke=A.borderColor,D["stroke-width"]=A.borderWidth),objectEach$h(D,function(X,W){typeof X>"u"&&delete D[W]})),N&&(!E||!defined$C(L))?(k.dataLabel=k.dataLabel&&k.dataLabel.destroy(),k.dataLabels&&(k.dataLabels.length===1?delete k.dataLabels:delete k.dataLabels[P]),P||delete k.dataLabel,M&&(k.connector=k.connector.destroy(),k.connectors&&(k.connectors.length===1?delete k.connectors:delete k.connectors[P]))):E&&defined$C(L)&&(N?D.text=L:(k.dataLabels=k.dataLabels||[],N=k.dataLabels[P]=U?v.text(L,0,-9999,A.useHTML).addClass("highcharts-data-label"):v.label(L,0,-9999,A.shape,null,null,A.useHTML,null,"data-label"),P||(k.dataLabel=N),N.addClass(" highcharts-data-label-color-"+k.colorIndex+" "+(A.className||"")+(A.useHTML?" highcharts-tracker":""))),N.options=A,N.attr(D),p.styledMode||N.css(C).shadow(A.shadow),N.added||N.add(y),A.textPath&&!A.useHTML&&(N.setTextPath(k.getDataLabelPath&&k.getDataLabelPath(N)||k.graphic,A.textPath),k.dataLabelPath&&!A.textPath.enabled&&(k.dataLabelPath=k.dataLabelPath.destroy())),d.alignDataLabel(k,N,A,null,B))})})}fireEvent$o(this,"afterDrawDataLabels")}function l(d,p,u,f,g,v){var m=this.chart,x=p.align,y=p.verticalAlign,b=d.box?0:d.padding||0,$=p.x,S=$===void 0?0:$,k=p.y,A=k===void 0?0:k,P,E;return P=(u.x||0)+b,P<0&&(x==="right"&&S>=0?(p.align="left",p.inside=!0):S-=P,E=!0),P=(u.x||0)+f.width-b,P>m.plotWidth&&(x==="left"&&S<=0?(p.align="right",p.inside=!0):S+=m.plotWidth-P,E=!0),P=u.y+b,P<0&&(y==="bottom"&&A>=0?(p.verticalAlign="top",p.inside=!0):A-=P,E=!0),P=(u.y||0)+f.height-b,P>m.plotHeight&&(y==="top"&&A<=0?(p.verticalAlign="bottom",p.inside=!0):A+=m.plotHeight-P,E=!0),E&&(p.x=S,p.y=A,d.placed=!v,d.align(p,void 0,g)),E}function h(d,p){var u=[],f;if(isArray$c(d)&&!isArray$c(p))u=d.map(function(g){return merge$11(g,p)});else if(isArray$c(p)&&!isArray$c(d))u=p.map(function(g){return merge$11(d,g)});else if(!isArray$c(d)&&!isArray$c(p))u=merge$11(d,p);else for(f=Math.max(d.length,p.length);f--;)u[f]=merge$11(d[f],p[f]);return u}function c(d,p,u,f,g){var v=this.chart,m=v.inverted,x=this.xAxis,y=x.reversed,b=m?p.height/2:p.width/2,$=d.pointWidth,S=$?$/2:0;p.startXPos=m?g.x:y?-b-S:x.width-b+S,p.startYPos=m?y?this.yAxis.height-b+S:-b-S:g.y,f?p.visibility==="hidden"&&(p.show(),p.attr({opacity:0}).animate({opacity:1})):p.attr({opacity:1}).animate({opacity:0},void 0,p.hide),v.hasRendered&&(u&&p.attr({x:p.startXPos,y:p.startYPos}),p.placed=!0)}})(DataLabel||(DataLabel={}));const DataLabel$1=DataLabel;var Series$d=SeriesRegistry$1.series,merge$10=Utilities.merge,pick$18=Utilities.pick,ColumnDataLabel$1;(function(n){var r=[];function t(s,a,l,h,c){var d=this.chart.inverted,p=s.series,u=s.dlBox||s.shapeArgs,f=pick$18(s.below,s.plotY>pick$18(this.translatedThreshold,p.yAxis.len)),g=pick$18(l.inside,!!this.options.stacking),v;u&&(h=merge$10(u),h.y<0&&(h.height+=h.y,h.y=0),v=h.y+h.height-p.yAxis.len,v>0&&v<h.height&&(h.height-=v),d&&(h={x:p.yAxis.len-h.y-h.height,y:p.xAxis.len-h.x-h.width,width:h.height,height:h.width}),g||(d?(h.x+=f?0:h.width,h.width=0):(h.y+=f?h.height:0,h.height=0))),l.align=pick$18(l.align,!d||g?"center":f?"right":"left"),l.verticalAlign=pick$18(l.verticalAlign,d||g?"middle":f?"top":"bottom"),Series$d.prototype.alignDataLabel.call(this,s,a,l,h,c),l.inside&&s.contrastColor&&a.css({color:s.contrastColor})}function o(s){DataLabel$1.compose(Series$d),r.indexOf(s)===-1&&(r.push(s),s.prototype.alignDataLabel=t)}n.compose=o})(ColumnDataLabel$1||(ColumnDataLabel$1={}));const ColumnDataLabel$2=ColumnDataLabel$1;var __extends$P=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),extend$17=Utilities.extend,merge$$=Utilities.merge,BarSeries=function(n){__extends$P(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.defaultOptions=merge$$(ColumnSeries$h.defaultOptions,{}),r}(ColumnSeries$h);extend$17(BarSeries.prototype,{inverted:!0});SeriesRegistry$1.registerSeriesType("bar",BarSeries);var __extends$O=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),addEvent$P=Utilities.addEvent,extend$16=Utilities.extend,merge$_=Utilities.merge,ScatterSeries$4=function(n){__extends$O(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.applyJitter=function(){var t=this,o=this.options.jitter,s=this.points.length;function a(l){var h=Math.sin(l)*1e4;return h-Math.floor(h)}o&&this.points.forEach(function(l,h){["x","y"].forEach(function(c,d){var p,u="plot"+c.toUpperCase(),f,g,v;o[c]&&!l.isNull&&(p=t[c+"Axis"],v=o[c]*p.transA,p&&!p.isLog&&(f=Math.max(0,l[u]-v),g=Math.min(p.len,l[u]+v),l[u]=f+(g-f)*a(h+d*s),c==="x"&&(l.clientX=l.plotX)))})})},r.prototype.drawGraph=function(){this.options.lineWidth?n.prototype.drawGraph.call(this):this.graph&&(this.graph=this.graph.destroy())},r.defaultOptions=merge$_(LineSeries$5.defaultOptions,{lineWidth:0,findNearestPointBy:"xy",jitter:{x:0,y:0},marker:{enabled:!0},tooltip:{headerFormat:'<span style="color:{point.color}">●</span> <span style="font-size: 10px"> {series.name}</span><br/>',pointFormat:"x: <b>{point.x}</b><br/>y: <b>{point.y}</b><br/>"}}),r}(LineSeries$5);extend$16(ScatterSeries$4.prototype,{drawTracker:ColumnSeries$h.prototype.drawTracker,sorted:!1,requireSorting:!1,noSharedTooltip:!0,trackerGroups:["group","markerGroup","dataLabelsGroup"],takeOrdinalPosition:!1});addEvent$P(ScatterSeries$4,"afterTranslate",function(){this.applyJitter()});SeriesRegistry$1.registerSeriesType("scatter",ScatterSeries$4);var isNumber$w=Utilities.isNumber,pick$17=Utilities.pick,relativeLength$6=Utilities.relativeLength,deg2rad$4=H.deg2rad,centeredSeriesMixin=H.CenteredSeriesMixin={getCenter:function(){var n=this.options,r=this.chart,t=2*(n.slicedOffset||0),o,s=r.plotWidth-2*t,a=r.plotHeight-2*t,l=n.center,h=Math.min(s,a),c=n.size,d=n.innerSize||0,p,u,f;for(typeof c=="string"&&(c=parseFloat(c)),typeof d=="string"&&(d=parseFloat(d)),p=[pick$17(l[0],"50%"),pick$17(l[1],"50%"),pick$17(c&&c<0?void 0:n.size,"100%"),pick$17(d&&d<0?void 0:n.innerSize||0,"0%")],r.angular&&!(this instanceof Series$e)&&(p[3]=0),u=0;u<4;++u)f=p[u],o=u<2||u===2&&/%$/.test(f),p[u]=relativeLength$6(f,[s,a,h,p[2]][u])+(o?t:0);return p[3]>p[2]&&(p[3]=p[2]),p},getStartAndEndRadians:function(n,r){var t=isNumber$w(n)?n:0,o=isNumber$w(r)&&r>t&&r-t<360?r:t+360,s=-90;return{start:deg2rad$4*(t+s),end:deg2rad$4*(o+s)}}},__extends$N=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),setAnimation$1=animationExports.setAnimation,addEvent$O=Utilities.addEvent,defined$B=Utilities.defined,extend$15=Utilities.extend,isNumber$v=Utilities.isNumber,pick$16=Utilities.pick,relativeLength$5=Utilities.relativeLength,PiePoint$3=function(n){__extends$N(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.labelDistance=void 0,t.options=void 0,t.series=void 0,t}return r.prototype.getConnectorPath=function(){var t=this.labelPosition,o=this.series.options.dataLabels,s=this.connectorShapes,a=o.connectorShape;return s[a]&&(a=s[a]),a.call(this,{x:t.final.x,y:t.final.y,alignment:t.alignment},t.connectorPosition,o)},r.prototype.getTranslate=function(){return this.sliced?this.slicedTranslation:{translateX:0,translateY:0}},r.prototype.haloPath=function(t){var o=this.shapeArgs;return this.sliced||!this.visible?[]:this.series.chart.renderer.symbols.arc(o.x,o.y,o.r+t,o.r+t,{innerR:o.r-1,start:o.start,end:o.end})},r.prototype.init=function(){var t=this;n.prototype.init.apply(this,arguments),this.name=pick$16(this.name,"Slice");var o=function(s){t.slice(s.type==="select")};return addEvent$O(this,"select",o),addEvent$O(this,"unselect",o),this},r.prototype.isValid=function(){return isNumber$v(this.y)&&this.y>=0},r.prototype.setVisible=function(t,o){var s=this,a=this.series,l=a.chart,h=a.options.ignoreHiddenPoint;o=pick$16(o,h),t!==this.visible&&(this.visible=this.options.visible=t=typeof t>"u"?!this.visible:t,a.options.data[a.data.indexOf(this)]=this.options,["graphic","dataLabel","connector","shadowGroup"].forEach(function(c){s[c]&&s[c][t?"show":"hide"](t)}),this.legendItem&&l.legend.colorizeItem(this,t),!t&&this.state==="hover"&&this.setState(""),h&&(a.isDirty=!0),o&&l.redraw())},r.prototype.slice=function(t,o,s){var a=this.series,l=a.chart;setAnimation$1(s,l),o=pick$16(o,!0),this.sliced=this.options.sliced=t=defined$B(t)?t:!this.sliced,a.options.data[a.data.indexOf(this)]=this.options,this.graphic&&this.graphic.animate(this.getTranslate()),this.shadowGroup&&this.shadowGroup.animate(this.getTranslate())},r}(Point$2);extend$15(PiePoint$3.prototype,{connectorShapes:{fixedOffset:function(n,r,t){var o=r.breakAt,s=r.touchingSliceAt,a=t.softConnector?["C",n.x+(n.alignment==="left"?-5:5),n.y,2*o.x-s.x,2*o.y-s.y,o.x,o.y]:["L",o.x,o.y];return[["M",n.x,n.y],a,["L",s.x,s.y]]},straight:function(n,r){var t=r.touchingSliceAt;return[["M",n.x,n.y],["L",t.x,t.y]]},crookedLine:function(n,r,t){var o=r.touchingSliceAt,s=this.series,a=s.center[0],l=s.chart.plotWidth,h=s.chart.plotLeft,c=n.alignment,d=this.shapeArgs.r,p=relativeLength$5(t.crookDistance,1),u=c==="left"?a+d+(l+h-a-d)*(1-p):h+(a-d)*p,f=["L",u,n.y],g=!0;(c==="left"?u>n.x||u<o.x:u<n.x||u>o.x)&&(g=!1);var v=[["M",n.x,n.y]];return g&&v.push(f),v.push(["L",o.x,o.y]),v}}});var __extends$M=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),getStartAndEndRadians=centeredSeriesMixin.getStartAndEndRadians,noop$g=H.noop,clamp$c=Utilities.clamp,extend$14=Utilities.extend,fireEvent$n=Utilities.fireEvent,merge$Z=Utilities.merge,pick$15=Utilities.pick,relativeLength$4=Utilities.relativeLength,PieSeries$3=function(n){__extends$M(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.center=void 0,t.data=void 0,t.maxLabelDistance=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.animate=function(t){var o=this,s=o.points,a=o.startAngleRad;t||s.forEach(function(l){var h=l.graphic,c=l.shapeArgs;h&&c&&(h.attr({r:pick$15(l.startR,o.center&&o.center[3]/2),start:a,end:a}),h.animate({r:c.r,start:c.start,end:c.end},o.options.animation))})},r.prototype.drawEmpty=function(){var t=this.startAngleRad,o=this.endAngleRad,s=this.options,a,l;this.total===0&&this.center?(a=this.center[0],l=this.center[1],this.graph||(this.graph=this.chart.renderer.arc(a,l,this.center[1]/2,0,t,o).addClass("highcharts-empty-series").add(this.group)),this.graph.attr({d:Symbols.arc(a,l,this.center[2]/2,0,{start:t,end:o,innerR:this.center[3]/2})}),this.chart.styledMode||this.graph.attr({"stroke-width":s.borderWidth,fill:s.fillColor||"none",stroke:s.color||palette.neutralColor20})):this.graph&&(this.graph=this.graph.destroy())},r.prototype.drawPoints=function(){var t=this.chart.renderer;this.points.forEach(function(o){o.graphic&&o.hasNewShapeType()&&(o.graphic=o.graphic.destroy()),o.graphic||(o.graphic=t[o.shapeType](o.shapeArgs).add(o.series.group),o.delayedRendering=!0)})},r.prototype.generatePoints=function(){n.prototype.generatePoints.call(this),this.updateTotals()},r.prototype.getX=function(t,o,s){var a=this.center,l=this.radii?this.radii[s.index]||0:a[2]/2,h=Math.asin(clamp$c((t-a[1])/(l+s.labelDistance),-1,1)),c=a[0]+(o?-1:1)*(Math.cos(h)*(l+s.labelDistance))+(s.labelDistance>0?(o?-1:1)*this.options.dataLabels.padding:0);return c},r.prototype.hasData=function(){return!!this.processedXData.length},r.prototype.redrawPoints=function(){var t=this,o=t.chart,s=o.renderer,a=t.options.shadow,l,h,c,d;this.drawEmpty(),a&&!t.shadowGroup&&!o.styledMode&&(t.shadowGroup=s.g("shadow").attr({zIndex:-1}).add(t.group)),t.points.forEach(function(p){var u={};if(h=p.graphic,!p.isNull&&h){var f=void 0;d=p.shapeArgs,l=p.getTranslate(),o.styledMode||(f=p.shadowGroup,a&&!f&&(f=p.shadowGroup=s.g("shadow").add(t.shadowGroup)),f&&f.attr(l),c=t.pointAttribs(p,p.selected&&"select")),p.delayedRendering?(h.setRadialReference(t.center).attr(d).attr(l),o.styledMode||h.attr(c).attr({"stroke-linejoin":"round"}).shadow(a,f),p.delayedRendering=!1):(h.setRadialReference(t.center),o.styledMode||merge$Z(!0,u,c),merge$Z(!0,u,d,l),h.animate(u)),h.attr({visibility:p.visible?"inherit":"hidden"}),h.addClass(p.getClassName(),!0)}else h&&(p.graphic=h.destroy())})},r.prototype.sortByAngle=function(t,o){t.sort(function(s,a){return typeof s.angle<"u"&&(a.angle-s.angle)*o})},r.prototype.translate=function(t){this.generatePoints();var o=this,s=1e3,a=o.options,l=a.slicedOffset,h=l+(a.borderWidth||0),c=getStartAndEndRadians(a.startAngle,a.endAngle),d=o.startAngleRad=c.start,p=o.endAngleRad=c.end,u=p-d,f=o.points,g=a.dataLabels.distance,v=a.ignoreHiddenPoint,m=f.length,x,y,b,$,S,k,A,P,E=0;for(t||(o.center=t=o.getCenter()),A=0;A<m;A++){P=f[A],y=d+E*u,P.isValid()&&(!v||P.visible)&&(E+=P.percentage/100),b=d+E*u;var M={x:t[0],y:t[1],r:t[2]/2,innerR:t[3]/2,start:Math.round(y*s)/s,end:Math.round(b*s)/s};P.shapeType="arc",P.shapeArgs=M,P.labelDistance=pick$15(P.options.dataLabels&&P.options.dataLabels.distance,g),P.labelDistance=relativeLength$4(P.labelDistance,M.r),o.maxLabelDistance=Math.max(o.maxLabelDistance||0,P.labelDistance),$=(b+y)/2,$>1.5*Math.PI?$-=2*Math.PI:$<-Math.PI/2&&($+=2*Math.PI),P.slicedTranslation={translateX:Math.round(Math.cos($)*l),translateY:Math.round(Math.sin($)*l)},S=Math.cos($)*t[2]/2,k=Math.sin($)*t[2]/2,P.tooltipPos=[t[0]+S*.7,t[1]+k*.7],P.half=$<-Math.PI/2||$>Math.PI/2?1:0,P.angle=$,x=Math.min(h,P.labelDistance/5),P.labelPosition={natural:{x:t[0]+S+Math.cos($)*P.labelDistance,y:t[1]+k+Math.sin($)*P.labelDistance},final:{},alignment:P.labelDistance<0?"center":P.half?"right":"left",connectorPosition:{breakAt:{x:t[0]+S+Math.cos($)*x,y:t[1]+k+Math.sin($)*x},touchingSliceAt:{x:t[0]+S,y:t[1]+k}}}}fireEvent$n(o,"afterTranslate")},r.prototype.updateTotals=function(){var t=this.points,o=t.length,s=this.options.ignoreHiddenPoint,a,l,h=0;for(a=0;a<o;a++)l=t[a],l.isValid()&&(!s||l.visible)&&(h+=l.y);for(this.total=h,a=0;a<o;a++)l=t[a],l.percentage=h>0&&(l.visible||!s)?l.y/h*100:0,l.total=h},r.defaultOptions=merge$Z(Series$e.defaultOptions,{center:[null,null],clip:!1,colorByPoint:!0,dataLabels:{allowOverlap:!0,connectorPadding:5,connectorShape:"fixedOffset",crookDistance:"70%",distance:30,enabled:!0,formatter:function(){return this.point.isNull?void 0:this.point.name},softConnector:!0,x:0},fillColor:void 0,ignoreHiddenPoint:!0,inactiveOtherPoints:!0,legendType:"point",marker:null,size:null,showInLegend:!1,slicedOffset:10,stickyTracking:!1,tooltip:{followPointer:!0},borderColor:palette.backgroundColor,borderWidth:1,lineWidth:void 0,states:{hover:{brightness:.1}}}),r}(Series$e);extend$14(PieSeries$3.prototype,{axisTypes:[],directTouch:!0,drawGraph:void 0,drawLegendSymbol:LegendSymbol$1.drawRectangle,drawTracker:ColumnSeries$h.prototype.drawTracker,getCenter:centeredSeriesMixin.getCenter,getSymbol:noop$g,isCartesian:!1,noSharedTooltip:!0,pointAttribs:ColumnSeries$h.prototype.pointAttribs,pointClass:PiePoint$3,requireSorting:!1,searchPoint:noop$g,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("pie",PieSeries$3);var noop$f=H.noop,distribute$1=R.distribute,Series$c=SeriesRegistry$1.series,arrayMax$6=Utilities.arrayMax,clamp$b=Utilities.clamp,defined$A=Utilities.defined,merge$Y=Utilities.merge,pick$14=Utilities.pick,relativeLength$3=Utilities.relativeLength,ColumnDataLabel;(function(n){var r=[],t={radialDistributionY:function(h){return h.top+h.distributeBox.pos},radialDistributionX:function(h,c,d,p){return h.getX(d<c.top+2||d>c.bottom-2?p:d,c.half,c)},justify:function(h,c,d){return d[0]+(h.half?-1:1)*(c+h.labelDistance)},alignToPlotEdges:function(h,c,d,p){var u=h.getBBox().width;return c?u+p:d-u-p},alignToConnectors:function(h,c,d,p){var u=0,f;return h.forEach(function(g){f=g.dataLabel.getBBox().width,f>u&&(u=f)}),c?u+p:d-u-p}};function o(h){if(DataLabel$1.compose(Series$c),r.indexOf(h)===-1){r.push(h);var c=h.prototype;c.dataLabelPositioners=t,c.alignDataLabel=noop$f,c.drawDataLabels=s,c.placeDataLabels=a,c.verifyDataLabelOverflow=l}}n.compose=o;function s(){var h=this,c=h.data,d=h.chart,p=h.options.dataLabels||{},u=p.connectorPadding,f=d.plotWidth,g=d.plotHeight,v=d.plotLeft,m=Math.round(d.chartWidth/3),x=h.center,y=x[2]/2,b=x[1],$=[[],[]],S=[0,0,0,0],k=h.dataLabelPositioners,A,P,E,M,T,O,L,C,U,D,N,I;!h.visible||!p.enabled&&!h._hasPointLabels||(c.forEach(function(B){B.dataLabel&&B.visible&&B.dataLabel.shortened&&(B.dataLabel.attr({width:"auto"}).css({width:"auto",textOverflow:"clip"}),B.dataLabel.shortened=!1)}),Series$c.prototype.drawDataLabels.apply(h),c.forEach(function(B){B.dataLabel&&(B.visible?($[B.half].push(B),B.dataLabel._pos=null,!defined$A(p.style.width)&&!defined$A(B.options.dataLabels&&B.options.dataLabels.style&&B.options.dataLabels.style.width)&&B.dataLabel.getBBox().width>m&&(B.dataLabel.css({width:Math.round(m*.7)+"px"}),B.dataLabel.shortened=!0)):(B.dataLabel=B.dataLabel.destroy(),B.dataLabels&&B.dataLabels.length===1&&delete B.dataLabels))}),$.forEach(function(B,X){var W=B.length,F=[],_,z,V,j,K,ot;if(W)for(h.sortByAngle(B,X-.5),h.maxLabelDistance>0&&(_=Math.max(0,b-y-h.maxLabelDistance),z=Math.min(b+y+h.maxLabelDistance,d.plotHeight),B.forEach(function(q){q.labelDistance>0&&q.dataLabel&&(q.top=Math.max(0,b-y-q.labelDistance),q.bottom=Math.min(b+y+q.labelDistance,d.plotHeight),K=q.dataLabel.getBBox().height||21,q.distributeBox={target:q.labelPosition.natural.y-q.top+K/2,size:K,rank:q.y},F.push(q.distributeBox))}),ot=z+K-_,distribute$1(F,ot,ot/5)),N=0;N<W;N++){if(A=B[N],O=A.labelPosition,M=A.dataLabel,D=A.visible===!1?"hidden":"inherit",V=O.natural.y,U=V,F&&defined$A(A.distributeBox)&&(typeof A.distributeBox.pos>"u"?D="hidden":(L=A.distributeBox.size,U=k.radialDistributionY(A))),delete A.positionIndex,p.justify)C=k.justify(A,y,x);else switch(p.alignTo){case"connectors":C=k.alignToConnectors(B,X,f,v);break;case"plotEdges":C=k.alignToPlotEdges(M,X,f,v);break;default:C=k.radialDistributionX(h,A,U,V)}M._attr={visibility:D,align:O.alignment},I=A.options.dataLabels||{},M._pos={x:C+pick$14(I.x,p.x)+({left:u,right:-u}[O.alignment]||0),y:U+pick$14(I.y,p.y)-10},O.final.x=C,O.final.y=U,pick$14(p.crop,!0)&&(T=M.getBBox().width,j=null,C-T<u&&X===1?(j=Math.round(T-C+u),S[3]=Math.max(j,S[3])):C+T>f-u&&X===0&&(j=Math.round(C+T-f+u),S[1]=Math.max(j,S[1])),U-L/2<0?S[0]=Math.max(Math.round(-U+L/2),S[0]):U+L/2>g&&(S[2]=Math.max(Math.round(U+L/2-g),S[2])),M.sideOverflow=j)}}),(arrayMax$6(S)===0||this.verifyDataLabelOverflow(S))&&(this.placeDataLabels(),this.points.forEach(function(B){if(I=merge$Y(p,B.options.dataLabels),P=pick$14(I.connectorWidth,1),P){var X=void 0;E=B.connector,M=B.dataLabel,M&&M._pos&&B.visible&&B.labelDistance>0?(D=M._attr.visibility,X=!E,X&&(B.connector=E=d.renderer.path().addClass("highcharts-data-label-connector  highcharts-color-"+B.colorIndex+(B.className?" "+B.className:"")).add(h.dataLabelsGroup),d.styledMode||E.attr({"stroke-width":P,stroke:I.connectorColor||B.color||palette.neutralColor60})),E[X?"attr":"animate"]({d:B.getConnectorPath()}),E.attr("visibility",D)):E&&(B.connector=E.destroy())}})))}function a(){this.points.forEach(function(h){var c=h.dataLabel,d;c&&h.visible&&(d=c._pos,d?(c.sideOverflow&&(c._attr.width=Math.max(c.getBBox().width-c.sideOverflow,0),c.css({width:c._attr.width+"px",textOverflow:(this.options.dataLabels.style||{}).textOverflow||"ellipsis"}),c.shortened=!0),c.attr(c._attr),c[c.moved?"animate":"attr"](d),c.moved=!0):c&&c.attr({y:-9999})),delete h.distributeBox},this)}function l(h){var c=this.center,d=this.options,p=d.center,u=d.minSize||80,f=u,g=d.size!==null;return g||(p[0]!==null?f=Math.max(c[2]-Math.max(h[1],h[3]),u):(f=Math.max(c[2]-h[1]-h[3],u),c[0]+=(h[3]-h[1])/2),p[1]!==null?f=clamp$b(f,u,c[2]-Math.max(h[0],h[2])):(f=clamp$b(f,u,c[2]-h[0]-h[2]),c[1]+=(h[0]-h[2])/2),f<c[2]?(c[2]=f,c[3]=Math.min(relativeLength$3(d.innerSize||0,f),f),this.translate(c),this.drawDataLabels&&this.drawDataLabels()):g=!0),g}})(ColumnDataLabel||(ColumnDataLabel={}));const PieDataLabel=ColumnDataLabel;var addEvent$N=Utilities.addEvent,fireEvent$m=Utilities.fireEvent,isArray$b=Utilities.isArray,isNumber$u=Utilities.isNumber,objectEach$g=Utilities.objectEach,pick$13=Utilities.pick;addEvent$N(Chart$1,"render",function(){var r=this,t=[];(this.labelCollectors||[]).forEach(function(o){t=t.concat(o())}),(this.yAxis||[]).forEach(function(o){o.stacking&&o.options.stackLabels&&!o.options.stackLabels.allowOverlap&&objectEach$g(o.stacking.stacks,function(s){objectEach$g(s,function(a){a.label&&a.label.visibility!=="hidden"&&t.push(a.label)})})}),(this.series||[]).forEach(function(o){var s=o.options.dataLabels;if(o.visible&&!(s.enabled===!1&&!o._hasPointLabels)){var a=function(l){return l.forEach(function(h){if(h.visible){var c=isArray$b(h.dataLabels)?h.dataLabels:h.dataLabel?[h.dataLabel]:[];c.forEach(function(d){var p=d.options;d.labelrank=pick$13(p.labelrank,h.labelrank,h.shapeArgs&&h.shapeArgs.height),p.allowOverlap?(d.oldOpacity=d.opacity,d.newOpacity=1,hideOrShow(d,r)):t.push(d)})}})};a(o.nodes||[]),a(o.points)}}),this.hideOverlappingLabels(t)});Chart$1.prototype.hideOverlappingLabels=function(n){var r=this,t=n.length,o=r.renderer,s,a,l,h,c,d,p,u=!1,f=function(v,m){return!(m.x>=v.x+v.width||m.x+m.width<=v.x||m.y>=v.y+v.height||m.y+m.height<=v.y)},g=function(v){var m,x,y,b=v.box?0:v.padding||0,$=0,S=0,k,A;if(v&&(!v.alignAttr||v.placed))return m=v.alignAttr||{x:v.attr("x"),y:v.attr("y")},x=v.parentGroup,v.width||(y=v.getBBox(),v.width=y.width,v.height=y.height,$=o.fontMetrics(null,v.element).h),k=v.width-2*b,A={left:"0",center:"0.5",right:"1"}[v.alignValue],A?S=+A*k:isNumber$u(v.x)&&Math.round(v.x)!==v.translateX&&(S=v.x-v.translateX),{x:m.x+(x.translateX||0)+b-(S||0),y:m.y+(x.translateY||0)+b-$,width:v.width-2*b,height:v.height-2*b}};for(a=0;a<t;a++)s=n[a],s&&(s.oldOpacity=s.opacity,s.newOpacity=1,s.absoluteBox=g(s));for(n.sort(function(v,m){return(m.labelrank||0)-(v.labelrank||0)}),a=0;a<t;a++)for(h=n[a],d=h&&h.absoluteBox,l=a+1;l<t;++l)c=n[l],p=c&&c.absoluteBox,d&&p&&h!==c&&h.newOpacity!==0&&c.newOpacity!==0&&f(d,p)&&((h.labelrank<c.labelrank?h:c).newOpacity=0);n.forEach(function(v){hideOrShow(v,r)&&(u=!0)}),u&&fireEvent$m(r,"afterHideAllOverlappingLabels")};function hideOrShow(n,r){var t,o,s=!1;return n&&(o=n.newOpacity,n.oldOpacity!==o&&(n.alignAttr&&n.placed?(n[o?"removeClass":"addClass"]("highcharts-data-label-hidden"),t=function(){r.styledMode||n.css({pointerEvents:o?"auto":"none"})},s=!0,n.alignAttr.opacity=o,n[n.isOld?"animate":"attr"](n.alignAttr,null,t),fireEvent$m(r,"afterHideOverlappingLabel")):n.attr({opacity:o})),n.isOld=!0),s}var extend$13=Utilities.extend,find$e=Utilities.find,isArray$a=Utilities.isArray,isObject$8=Utilities.isObject,merge$X=Utilities.merge,objectEach$f=Utilities.objectEach,pick$12=Utilities.pick,splat$a=Utilities.splat,uniqueKey$3=Utilities.uniqueKey,Responsive;(function(n){var r=[];function t(s){return r.indexOf(s)===-1&&(r.push(s),extend$13(s.prototype,o.prototype)),s}n.compose=t;var o=function(){function s(){}return s.prototype.currentOptions=function(a){var l=this,h={};function c(d,p,u,f){var g;objectEach$f(d,function(v,m){if(!f&&l.collectionsWithUpdate.indexOf(m)>-1&&p[m])for(v=splat$a(v),u[m]=[],g=0;g<Math.max(v.length,p[m].length);g++)p[m][g]&&(v[g]===void 0?u[m][g]=p[m][g]:(u[m][g]={},c(v[g],p[m][g],u[m][g],f+1)));else isObject$8(v)?(u[m]=isArray$a(v)?[]:{},c(v,p[m]||{},u[m],f+1)):typeof p[m]>"u"?u[m]=null:u[m]=p[m]})}return c(a,this.options,h,0),h},s.prototype.matchResponsiveRule=function(a,l){var h=a.condition,c=h.callback||function(){return this.chartWidth<=pick$12(h.maxWidth,Number.MAX_VALUE)&&this.chartHeight<=pick$12(h.maxHeight,Number.MAX_VALUE)&&this.chartWidth>=pick$12(h.minWidth,0)&&this.chartHeight>=pick$12(h.minHeight,0)};c.call(this)&&l.push(a._id)},s.prototype.setResponsive=function(a,l){var h=this,c=this.options.responsive,d=this.currentResponsive,p=[],u;!l&&c&&c.rules&&c.rules.forEach(function(v){typeof v._id>"u"&&(v._id=uniqueKey$3()),h.matchResponsiveRule(v,p)},this);var f=merge$X.apply(void 0,p.map(function(v){return find$e((c||{}).rules||[],function(m){return m._id===v})}).map(function(v){return v&&v.chartOptions}));f.isResponsiveOptions=!0,p=p.toString()||void 0;var g=d&&d.ruleIds;p!==g&&(d&&this.update(d.undoOptions,a,!0),p?(u=this.currentOptions(f),u.isResponsiveOptions=!0,this.currentResponsive={ruleIds:p,mergedOptions:f,undoOptions:u},this.update(f,a,!0)):this.currentResponsive=void 0)},s}()})(Responsive||(Responsive={}));const Responsive$1=Responsive;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$7=H;G$7.animate=animationExports.animate;G$7.animObject=animationExports.animObject;G$7.getDeferredAnimation=animationExports.getDeferredAnimation;G$7.setAnimation=animationExports.setAnimation;G$7.stop=animationExports.stop;G$7.timers=Fx.timers;G$7.AST=AST;G$7.Axis=Axis;G$7.Chart=Chart$1;G$7.chart=Chart$1.chart;G$7.Fx=Fx;G$7.Legend=Legend;G$7.PlotLineOrBand=PlotLineOrBand;G$7.Point=Point$2;G$7.Pointer=MSPointer.isRequired()?MSPointer:Pointer;G$7.Series=Series$e;G$7.SVGElement=SVGElement;G$7.SVGRenderer=SVGRenderer;G$7.Tick=Tick;G$7.Time=Time;G$7.Tooltip=Tooltip;G$7.Color=Color;G$7.color=Color.parse;HTMLRenderer.compose(SVGRenderer);HTMLElement.compose(SVGElement);G$7.defaultOptions=DefaultOptions.defaultOptions;G$7.getOptions=DefaultOptions.getOptions;G$7.time=DefaultOptions.defaultTime;G$7.setOptions=DefaultOptions.setOptions;G$7.dateFormat=FormatUtilities.dateFormat;G$7.format=FormatUtilities.format;G$7.numberFormat=FormatUtilities.numberFormat;G$7.addEvent=Utilities.addEvent;G$7.arrayMax=Utilities.arrayMax;G$7.arrayMin=Utilities.arrayMin;G$7.attr=Utilities.attr;G$7.clearTimeout=Utilities.clearTimeout;G$7.correctFloat=Utilities.correctFloat;G$7.createElement=Utilities.createElement;G$7.css=Utilities.css;G$7.defined=Utilities.defined;G$7.destroyObjectProperties=Utilities.destroyObjectProperties;G$7.discardElement=Utilities.discardElement;G$7.distribute=R.distribute;G$7.erase=Utilities.erase;G$7.error=Utilities.error;G$7.extend=Utilities.extend;G$7.extendClass=Utilities.extendClass;G$7.find=Utilities.find;G$7.fireEvent=Utilities.fireEvent;G$7.getMagnitude=Utilities.getMagnitude;G$7.getStyle=Utilities.getStyle;G$7.inArray=Utilities.inArray;G$7.isArray=Utilities.isArray;G$7.isClass=Utilities.isClass;G$7.isDOMElement=Utilities.isDOMElement;G$7.isFunction=Utilities.isFunction;G$7.isNumber=Utilities.isNumber;G$7.isObject=Utilities.isObject;G$7.isString=Utilities.isString;G$7.keys=Utilities.keys;G$7.merge=Utilities.merge;G$7.normalizeTickInterval=Utilities.normalizeTickInterval;G$7.objectEach=Utilities.objectEach;G$7.offset=Utilities.offset;G$7.pad=Utilities.pad;G$7.pick=Utilities.pick;G$7.pInt=Utilities.pInt;G$7.relativeLength=Utilities.relativeLength;G$7.removeEvent=Utilities.removeEvent;G$7.seriesType=SeriesRegistry$1.seriesType;G$7.splat=Utilities.splat;G$7.stableSort=Utilities.stableSort;G$7.syncTimeout=Utilities.syncTimeout;G$7.timeUnits=Utilities.timeUnits;G$7.uniqueKey=Utilities.uniqueKey;G$7.useSerialIds=Utilities.useSerialIds;G$7.wrap=Utilities.wrap;ColumnDataLabel$2.compose(ColumnSeries$h);DataLabel$1.compose(Series$e);DateTimeAxis$1.compose(Axis);LogarithmicAxis$1.compose(Axis);PieDataLabel.compose(PieSeries$3);PlotLineOrBand.compose(Axis);Responsive$1.compose(Chart$1);var addEvent$M=Utilities.addEvent,correctFloat$8=Utilities.correctFloat,css$3=Utilities.css,defined$z=Utilities.defined,error$3=Utilities.error,pick$11=Utilities.pick,timeUnits=Utilities.timeUnits,composedClasses=[],OrdinalAxis;(function(n){function r(v,m,x){if(composedClasses.indexOf(v)===-1){composedClasses.push(v);var y=v.prototype;y.getTimeTicks=t,y.index2val=o,y.lin2val=s,y.val2lin=f,y.ordinal2lin=y.val2lin,addEvent$M(v,"afterInit",l),addEvent$M(v,"foundExtremes",h),addEvent$M(v,"afterSetScale",c),addEvent$M(v,"initialAxisTranslation",d)}return composedClasses.indexOf(x)===-1&&(composedClasses.push(x),addEvent$M(x,"pan",p)),composedClasses.indexOf(m)===-1&&(composedClasses.push(m),addEvent$M(m,"updatedData",u)),v}n.compose=r;function t(v,m,x,y,b,$,S){b===void 0&&(b=[]),$===void 0&&($=0);var k={},A=this.options.tickPixelInterval,P=this.chart.time,E=[],M,T,O,L,C,U=0,D=[],N=-Number.MAX_VALUE;if(!this.options.ordinal&&!this.options.breaks||!b||b.length<3||typeof m>"u")return P.getTimeTicks.apply(P,arguments);var I=b.length;for(M=0;M<I;M++){if(C=M&&b[M-1]>x,b[M]<m&&(U=M),M===I-1||b[M+1]-b[M]>$*5||C){if(b[M]>N){for(T=P.getTimeTicks(v,b[U],b[M],y);T.length&&T[0]<=N;)T.shift();T.length&&(N=T[T.length-1]),E.push(D.length),D=D.concat(T)}U=M+1}if(C)break}if(T){if(L=T.info,S&&L.unitRange<=timeUnits.hour){for(M=D.length-1,U=1;U<M;U++)P.dateFormat("%d",D[U])!==P.dateFormat("%d",D[U-1])&&(k[D[U]]="day",O=!0);O&&(k[D[0]]="day"),L.higherRanks=k}L.segmentStarts=E,D.info=L}else error$3(12,!1,this.chart);if(S&&defined$z(A)){for(var B=D.length,X=[],W=[],F=void 0,_=void 0,z=void 0,V=void 0,j=void 0,K=B;K--;)_=this.translate(D[K]),z&&(W[K]=z-_),X[K]=z=_;for(W.sort(),V=W[Math.floor(W.length/2)],V<A*.6&&(V=null),K=D[B-1]>x?B-1:B,z=void 0;K--;)_=X[K],j=Math.abs(z-_),z&&j<A*.8&&(V===null||j<V*.8)?(k[D[K]]&&!k[D[K+1]]?(F=K+1,z=_):F=K,D.splice(F,1)):z=_}return D}function o(v){var m=this,x=m.ordinal,y=x.positions;if(!y)return v;var b=y.length-1,$;return v<0?v=y[0]:v>b?v=y[b]:(b=Math.floor(v),$=v-b),typeof $<"u"&&typeof y[b]<"u"?y[b]+($?$*(y[b+1]-y[b]):0):v}function s(v){var m=this,x=m.ordinal,y=m.old?m.old.min:m.min,b=m.old?m.old.transA:m.transA,$=x.positions;if(!$)return v;var S=(v-y)*b+m.minPixelPadding,k=S>0&&S<m.left+m.len;if(k||(x.extendedOrdinalPositions||(x.extendedOrdinalPositions=x.getExtendedPositions()),$=x.extendedOrdinalPositions),$&&$.length){var A=x.getIndexOfPoint(S,$),P=correctFloat$8(A%1);if(A>=0&&A<$.length){var E=$[Math.floor(A)],M=$[Math.ceil(A)],T=M-E;return $[Math.floor(A)]+P*T}var O=$.length,L=$[0],C=$[O-1],U=(C-L)/(O-1);return A<0?L+U*A:C+U*(A-O)}return v}function a(v,m){var x=n.Additions.findIndexOf(v,m,!0);if(v[x]===m)return x;var y=(m-v[x])/(v[x+1]-v[x]);return x+y}function l(){var v=this;v.ordinal||(v.ordinal=new n.Additions(v))}function h(){var v=this;v.isXAxis&&defined$z(v.options.overscroll)&&v.max===v.dataMax&&(!v.chart.mouseIsDown||v.isInternal)&&(!v.eventArgs||v.eventArgs&&v.eventArgs.trigger!=="navigator")&&(v.max+=v.options.overscroll,!v.isInternal&&defined$z(v.userMin)&&(v.min+=v.options.overscroll))}function c(){var v=this;v.horiz&&!v.isDirty&&(v.isDirty=v.isOrdinal&&v.chart.navigator&&!v.chart.navigator.adaptToUpdatedData)}function d(){var v=this;v.ordinal&&(v.ordinal.beforeSetTickPositions(),v.tickInterval=v.ordinal.postProcessTickInterval(v.tickInterval))}function p(v){var m=this,x=m.xAxis[0],y=x.options.overscroll,b=v.originalEvent.chartX,$=m.options.chart.panning,S=!1;if($&&$.type!=="y"&&x.options.ordinal&&x.series.length){var k=m.mouseDownX,A=x.getExtremes(),P=A.dataMax,E=A.min,M=A.max,T=m.hoverPoints,O=x.closestPointRange||x.ordinal&&x.ordinal.overscrollPointsRange,L=x.translationSlope*(x.ordinal.slope||O),C=(k-b)/L,U={ordinal:{positions:x.ordinal.getExtendedPositions()}},D=x.index2val,N=x.val2lin,I=void 0,B=void 0,X=void 0,W=void 0;U.ordinal.positions?Math.abs(C)>1&&(T&&T.forEach(function(F){F.setState()}),C<0?(X=U,W=x.ordinal.positions?x:U):(X=x.ordinal.positions?x:U,W=U),B=W.ordinal.positions,P>B[B.length-1]&&B.push(P),m.fixedRange=M-E,I=x.navigatorAxis.toFixedRange(null,null,D.apply(X,[N.apply(X,[E,!0])+C]),D.apply(W,[N.apply(W,[M,!0])+C])),I.min>=Math.min(A.dataMin,E)&&I.max<=Math.max(P,M)+y&&x.setExtremes(I.min,I.max,!0,!1,{trigger:"pan"}),m.mouseDownX=b,css$3(m.container,{cursor:"move"})):S=!0}else S=!0;S||$&&/y/.test($.type)?y&&(x.max=x.dataMax+y):v.preventDefault()}function u(){var v=this.xAxis;v&&v.options.ordinal&&(delete v.ordinal.index,delete v.ordinal.extendedOrdinalPositions)}function f(v,m){var x=this,y=x.ordinal,b=y.positions,$=y.slope,S=y.extendedOrdinalPositions;if(!b)return v;var k=b.length,A;if(b[0]<=v&&b[k-1]>=v)A=a(b,v);else{if(S||(S=y.getExtendedPositions&&y.getExtendedPositions(),y.extendedOrdinalPositions=S),!(S&&S.length))return v;var P=S.length;$||($=(S[P-1]-S[0])/P);var E=a(S,b[0]);if(v>=S[0]&&v<=S[P-1])A=a(S,v)-E;else if(v<S[0]){var M=S[0]-v,T=M/$;A=-E-T}else{var M=v-S[P-1],T=M/$;A=T+P-E}}return m?A:$*(A||0)+y.offset}var g=function(){function v(m){this.index={},this.axis=m}return v.prototype.beforeSetTickPositions=function(){var m=this.axis,x=m.ordinal,y=m.getExtremes(),b=y.min,$=y.max,S=m.isXAxis&&!!m.options.breaks,k=m.options.ordinal,A=m.chart.options.chart.ignoreHiddenSeries,P,E,M,T,O,L,C,U,D=[],N=Number.MAX_VALUE,I=!1;if(k||S){if(m.series.forEach(function(B,X){if(E=[],(!A||B.visible!==!1)&&(B.takeOrdinalPosition!==!1||S)&&(D=D.concat(B.processedXData),P=D.length,D.sort(function(W,F){return W-F}),N=Math.min(N,pick$11(B.closestPointRange,N)),P)){for(X=0;X<P-1;)D[X]!==D[X+1]&&E.push(D[X+1]),X++;E[0]!==D[0]&&E.unshift(D[0]),D=E}B.isSeriesBoosting&&(U=!0)}),U&&(D.length=0),P=D.length,P>2){for(M=D[1]-D[0],C=P-1;C--&&!I;)D[C+1]-D[C]!==M&&(I=!0);!m.options.keepOrdinalPadding&&(D[0]-b>M||$-D[D.length-1]>M)&&(I=!0)}else m.options.overscroll&&(P===2?N=D[1]-D[0]:P===1?(N=m.options.overscroll,D=[D[0],D[0]+N]):N=x.overscrollPointsRange);I||m.forceOrdinal?(m.options.overscroll&&(x.overscrollPointsRange=N,D=D.concat(x.getOverscrollPositions())),x.positions=D,T=m.ordinal2lin(Math.max(b,D[0]),!0),O=Math.max(m.ordinal2lin(Math.min($,D[D.length-1]),!0),1),x.slope=L=($-b)/(O-T),x.offset=b-T*L):(x.overscrollPointsRange=pick$11(m.closestPointRange,x.overscrollPointsRange),x.positions=m.ordinal.slope=x.offset=void 0)}m.isOrdinal=k&&I,x.groupIntervalFactor=null},v.findIndexOf=function(m,x,y){for(var b=0,$=m.length-1,S;b<$;)S=Math.ceil((b+$)/2),m[S]<=x?b=S:$=S-1;return m[b]===x||y?b:-1},v.prototype.getExtendedPositions=function(){var m=this,x=m.axis,y=x.constructor.prototype,b=x.chart,$=x.series[0].currentDataGrouping,S=$?$.count+$.unitName:"raw",k=x.options.overscroll,A=x.getExtremes(),P,E=void 0,M=m.index;return M||(M=m.index={}),M[S]||(P={series:[],chart:b,forceOrdinal:!1,getExtremes:function(){return{min:A.dataMin,max:A.dataMax+k}},getGroupPixelWidth:y.getGroupPixelWidth,getTimeTicks:y.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},ordinal2lin:y.ordinal2lin,getIndexOfPoint:y.getIndexOfPoint,val2lin:y.val2lin},P.ordinal.axis=P,x.series.forEach(function(T){E={xAxis:P,xData:T.xData.slice(),chart:b,destroyGroupedData:H.noop,getProcessedData:Series$e.prototype.getProcessedData,applyGrouping:Series$e.prototype.applyGrouping},E.xData=E.xData.concat(m.getOverscrollPositions()),E.options={dataGrouping:$?{firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",enabled:!0,forced:!0,approximation:"open",units:[[$.unitName,[$.count]]]}:{enabled:!1}},P.series.push(E),T.processData.apply(E)}),x.applyGrouping.call(P),E.closestPointRange!==E.basePointRange&&E.currentDataGrouping&&(P.forceOrdinal=!0),x.ordinal.beforeSetTickPositions.apply({axis:P}),M[S]=P.ordinal.positions),M[S]},v.prototype.getGroupIntervalFactor=function(m,x,y){var b=this;b.axis;var $=y.processedXData,S=$.length,k=[],A,P,E=b.groupIntervalFactor;if(!E){for(P=0;P<S-1;P++)k[P]=$[P+1]-$[P];k.sort(function(M,T){return M-T}),A=k[Math.floor(S/2)],m=Math.max(m,$[0]),x=Math.min(x,$[S-1]),b.groupIntervalFactor=E=S*A/(x-m)}return E},v.prototype.getIndexOfPoint=function(m,x){var y=this,b=y.axis,$=y.positions?y.positions[0]:0,S=b.series[0].points&&b.series[0].points[0]&&b.series[0].points[0].plotX||b.minPixelPadding;b.series.length>1&&b.series.forEach(function(P){defined$z(P.points[0])&&defined$z(P.points[0].plotX)&&P.points[0].plotX<S&&(S=P.points[0].plotX)});var k=b.translationSlope*(y.slope||b.closestPointRange||y.overscrollPointsRange),A=(m-S)/k;return v.findIndexOf(x,$)+A},v.prototype.getOverscrollPositions=function(){var m=this,x=m.axis,y=x.options.overscroll,b=m.overscrollPointsRange,$=[],S=x.dataMax;if(defined$z(b))for(;S<=x.dataMax+y;)S+=b,$.push(S);return $},v.prototype.postProcessTickInterval=function(m){var x=this,y=x.axis,b=x.slope,$;return b?y.options.breaks?$=y.closestPointRange||m:$=m/(b/y.closestPointRange):$=m,$},v}();n.Additions=g})(OrdinalAxis||(OrdinalAxis={}));const OrdinalAxis$1=OrdinalAxis;var addEvent$L=Utilities.addEvent,find$d=Utilities.find,fireEvent$l=Utilities.fireEvent,isArray$9=Utilities.isArray,isNumber$t=Utilities.isNumber,pick$10=Utilities.pick,BrokenAxis;(function(n){var r=[];function t(f,g){if(r.indexOf(f)===-1&&(r.push(f),f.keepProps.push("brokenAxis"),addEvent$L(f,"init",l),addEvent$L(f,"afterInit",o),addEvent$L(f,"afterSetTickPositions",a),addEvent$L(f,"afterSetOptions",s)),r.indexOf(g)===-1){r.push(g);var v=g.prototype;v.drawBreaks=d,v.gappedPath=p,addEvent$L(g,"afterGeneratePoints",h),addEvent$L(g,"afterRender",c)}return f}n.compose=t;function o(){typeof this.brokenAxis<"u"&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function s(){var f=this;f.brokenAxis&&f.brokenAxis.hasBreaks&&(f.options.ordinal=!1)}function a(){var f=this,g=f.brokenAxis;if(g&&g.hasBreaks){for(var v=f.tickPositions,m=f.tickPositions.info,x=[],y=0;y<v.length;y++)g.isInAnyBreak(v[y])||x.push(v[y]);f.tickPositions=x,f.tickPositions.info=m}}function l(){var f=this;f.brokenAxis||(f.brokenAxis=new u(f))}function h(){var f=this,g=f.isDirty,v=f.options.connectNulls,m=f.points,x=f.xAxis,y=f.yAxis;if(g)for(var b=m.length;b--;){var $=m[b],S=$.y===null&&v===!1,k=!S&&(x&&x.brokenAxis&&x.brokenAxis.isInAnyBreak($.x,!0)||y&&y.brokenAxis&&y.brokenAxis.isInAnyBreak($.y,!0));$.visible=k?!1:$.options.visible!==!1}}function c(){this.drawBreaks(this.xAxis,["x"]),this.drawBreaks(this.yAxis,pick$10(this.pointArrayMap,["y"]))}function d(f,g){var v=this,m=v.points,x,y,b,$;if(f&&f.brokenAxis&&f.brokenAxis.hasBreaks){var S=f.brokenAxis;g.forEach(function(k){x=S&&S.breakArray||[],y=f.isXAxis?f.min:pick$10(v.options.threshold,f.min),m.forEach(function(A){$=pick$10(A["stack"+k.toUpperCase()],A[k]),x.forEach(function(P){isNumber$t(y)&&isNumber$t($)&&(b=!1,y<P.from&&$>P.to||y>P.from&&$<P.from?b="pointBreak":(y<P.from&&$>P.from&&$<P.to||y>P.from&&$>P.to&&$<P.from)&&(b="pointInBreak"),b&&fireEvent$l(f,b,{point:A,brk:P}))})})})}}function p(){var f=this.currentDataGrouping,g=f&&f.gapSize,v=this.points.slice(),m=this.yAxis,x=this.options.gapSize,y=v.length-1,b;if(x&&y>0){this.options.gapUnit!=="value"&&(x*=this.basePointRange),g&&g>x&&g>=this.basePointRange&&(x=g);for(var $=void 0,S=void 0;y--;)if(S&&S.visible!==!1||(S=v[y+1]),$=v[y],!(S.visible===!1||$.visible===!1)){if(S.x-$.x>x){var k=($.x+S.x)/2;v.splice(y+1,0,{isNull:!0,x:k}),m.stacking&&this.options.stacking&&(b=m.stacking.stacks[this.stackKey][k]=new StackItem$1(m,m.options.stackLabels,!1,k,this.stack),b.total=0)}S=$}}return this.getGraphPath(v)}var u=function(){function f(g){this.hasBreaks=!1,this.axis=g}return f.isInBreak=function(g,v){var m=g.repeat||1/0,x=g.from,y=g.to-g.from,b=v>=x?(v-x)%m:m-(x-v)%m,$;return g.inclusive?$=b<=y:$=b<y&&b!==0,$},f.lin2Val=function(g){var v=this,m=v.brokenAxis,x=m&&m.breakArray;if(!x||!isNumber$t(g))return g;var y=g,b,$;for($=0;$<x.length&&(b=x[$],!(b.from>=y));$++)(b.to<y||f.isInBreak(b,y))&&(y+=b.len);return y},f.val2Lin=function(g){var v=this,m=v.brokenAxis,x=m&&m.breakArray;if(!x||!isNumber$t(g))return g;var y=g,b,$;for($=0;$<x.length;$++)if(b=x[$],b.to<=g)y-=b.len;else{if(b.from>=g)break;if(f.isInBreak(b,g)){y-=g-b.from;break}}return y},f.prototype.findBreakAt=function(g,v){return find$d(v,function(m){return m.from<g&&g<m.to})},f.prototype.isInAnyBreak=function(g,v){var m=this,x=m.axis,y=x.options.breaks||[],b=y.length,$,S,k;if(b&&isNumber$t(g)){for(;b--;)f.isInBreak(y[b],g)&&($=!0,S||(S=pick$10(y[b].showPoints,!x.isXAxis)));$&&v?k=$&&!S:k=$}return k},f.prototype.setBreaks=function(g,v){var m=this,x=m.axis,y=isArray$9(g)&&!!g.length;x.isDirty=m.hasBreaks!==y,m.hasBreaks=y,x.options.breaks=x.userOptions.breaks=g,x.forceRedraw=!0,x.series.forEach(function(b){b.isDirty=!0}),!y&&x.val2lin===f.val2Lin&&(delete x.val2lin,delete x.lin2val),y&&(x.userOptions.ordinal=!1,x.lin2val=f.lin2Val,x.val2lin=f.val2Lin,x.setExtremes=function(b,$,S,k,A){if(m.hasBreaks){for(var P=this.options.breaks||[],E=void 0;E=m.findBreakAt(b,P);)b=E.to;for(;E=m.findBreakAt($,P);)$=E.from;$<b&&($=b)}x.constructor.prototype.setExtremes.call(this,b,$,S,k,A)},x.setAxisTranslation=function(){if(x.constructor.prototype.setAxisTranslation.call(this),m.unitLength=void 0,m.hasBreaks){var b=x.options.breaks||[],$=[],S=[],k=pick$10(x.pointRangePadding,0),A=0,P,E,M=x.userMin||x.min,T=x.userMax||x.max,O,L;b.forEach(function(C){E=C.repeat||1/0,isNumber$t(M)&&isNumber$t(T)&&(f.isInBreak(C,M)&&(M+=C.to%E-M%E),f.isInBreak(C,T)&&(T-=T%E-C.from%E))}),b.forEach(function(C){if(O=C.from,E=C.repeat||1/0,isNumber$t(M)&&isNumber$t(T)){for(;O-E>M;)O-=E;for(;O<M;)O+=E;for(L=O;L<T;L+=E)$.push({value:L,move:"in"}),$.push({value:L+C.to-C.from,move:"out",size:C.breakSize})}}),$.sort(function(C,U){return C.value===U.value?(C.move==="in"?0:1)-(U.move==="in"?0:1):C.value-U.value}),P=0,O=M,$.forEach(function(C){P+=C.move==="in"?1:-1,P===1&&C.move==="in"&&(O=C.value),P===0&&isNumber$t(O)&&(S.push({from:O,to:C.value,len:C.value-O-(C.size||0)}),A+=C.value-O-(C.size||0))}),m.breakArray=S,isNumber$t(M)&&isNumber$t(T)&&isNumber$t(x.min)&&(m.unitLength=T-M-A+k,fireEvent$l(x,"afterBreaks"),x.staticScale?x.transA=x.staticScale:m.unitLength&&(x.transA*=(T-x.min+k)/m.unitLength),k&&(x.minPixelPadding=x.transA*(x.minPointOffset||0)),x.min=M,x.max=T)}}),pick$10(v,!0)&&x.chart.redraw()},f}();n.Additions=u})(BrokenAxis||(BrokenAxis={}));const BrokenAxis$1=BrokenAxis;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/broken-axis
 * @requires highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$6=H;BrokenAxis$1.compose(G$6.Axis,G$6.Series);var format$7=FormatUtilities.format,seriesProto$3=Series$e.prototype,addEvent$K=Utilities.addEvent,arrayMax$5=Utilities.arrayMax,arrayMin$5=Utilities.arrayMin,correctFloat$7=Utilities.correctFloat,defined$y=Utilities.defined,error$2=Utilities.error,extend$12=Utilities.extend,isNumber$s=Utilities.isNumber,merge$W=Utilities.merge,pick$$=Utilities.pick,approximations=H.approximations={sum:function(n){var r=n.length,t;if(!r&&n.hasNulls)t=null;else if(r)for(t=0;r--;)t+=n[r];return t},average:function(n){var r=n.length,t=approximations.sum(n);return isNumber$s(t)&&r&&(t=correctFloat$7(t/r)),t},averages:function(){var n=[];return[].forEach.call(arguments,function(r){n.push(approximations.average(r))}),typeof n[0]>"u"?void 0:n},open:function(n){return n.length?n[0]:n.hasNulls?null:void 0},high:function(n){return n.length?arrayMax$5(n):n.hasNulls?null:void 0},low:function(n){return n.length?arrayMin$5(n):n.hasNulls?null:void 0},close:function(n){return n.length?n[n.length-1]:n.hasNulls?null:void 0},ohlc:function(n,r,t,o){if(n=approximations.open(n),r=approximations.high(r),t=approximations.low(t),o=approximations.close(o),isNumber$s(n)||isNumber$s(r)||isNumber$s(t)||isNumber$s(o))return[n,r,t,o]},range:function(n,r){if(n=approximations.low(n),r=approximations.high(r),isNumber$s(n)||isNumber$s(r))return[n,r];if(n===null&&r===null)return null}},applyGrouping=function(){var n=this,r=n.chart,t=n.options,o=t.dataGrouping,s=n.allowDG!==!1&&o&&pick$$(o.enabled,r.options.isStock),a=n.visible||!r.options.chart.ignoreHiddenSeries,l,h,c=this.currentDataGrouping,d,p,u=!1;if(s&&!n.requireSorting&&(n.requireSorting=u=!0),h=skipDataGrouping(n)||!s,u&&(n.requireSorting=!1),!h){n.destroyGroupedData();var f=void 0,g=o.groupAll?n.xData:n.processedXData,v=o.groupAll?n.yData:n.processedYData,m=r.plotSizeX,x=n.xAxis,y=x.options.ordinal,b=n.groupPixelWidth;if(b&&g&&g.length){l=!0,n.isDirty=!0,n.points=null;var $=x.getExtremes(),S=$.min,k=$.max,A=y&&x.ordinal&&x.ordinal.getGroupIntervalFactor(S,k,n)||1,P=b*(k-S)/m*A,E=x.getTimeTicks(DateTimeAxis$1.Additions.prototype.normalizeTimeTickInterval(P,o.units||defaultDataGroupingUnits),Math.min(S,g[0]),Math.max(k,g[g.length-1]),x.options.startOfWeek,g,n.closestPointRange),M=seriesProto$3.groupData.apply(n,[g,v,E,o.approximation]),T=M.groupedXData,O=M.groupedYData,L=0;for(o&&o.smoothed&&T.length&&(o.firstAnchor="firstPoint",o.anchor="middle",o.lastAnchor="lastPoint",error$2(32,!1,r,{"dataGrouping.smoothed":"use dataGrouping.anchor"})),anchorPoints(n,T,k),f=1;f<E.length;f++)(!E.info.segmentStarts||E.info.segmentStarts.indexOf(f)===-1)&&(L=Math.max(E[f]-E[f-1],L));d=E.info,d.gapSize=L,n.closestPointRange=E.info.totalRange,n.groupMap=M.groupMap,a&&adjustExtremes(x,T),o.groupAll&&(n.allGroupedData=O,p=n.cropData(T,O,x.min,x.max,1),T=p.xData,O=p.yData,n.cropStart=p.start),n.processedXData=T,n.processedYData=O}else n.groupMap=null;n.hasGroupedData=l,n.currentDataGrouping=d,n.preventGraphAnimation=(c&&c.totalRange)!==(d&&d.totalRange)}},skipDataGrouping=function(n){if(n.isCartesian&&!n.isDirty&&!n.xAxis.isDirty&&!n.yAxis.isDirty)return!1},groupData=function(n,r,t,o){var s=this,a=s.data,l=s.options&&s.options.data,h=[],c=[],d=[],p=n.length,u,f,g,v=!!r,m=[],x,y=s.pointArrayMap,b=y&&y.length,$=["x"].concat(y||["y"]),S=this.options.dataGrouping&&this.options.dataGrouping.groupAll,k=0,A=0,P,E,M;function T(U){return typeof U=="function"?U:approximations[U]?approximations[U]:approximations[s.getDGApproximation&&s.getDGApproximation()||"average"]}for(x=T(o),b?y.forEach(function(){m.push([])}):m.push([]),P=b||1,E=0;E<=p&&!(n[E]>=t[0]);E++);for(E;E<=p;E++){for(;typeof t[k+1]<"u"&&n[E]>=t[k+1]||E===p;){for(u=t[k],s.dataGroupInfo={start:S?A:s.cropStart+A,length:m[0].length},g=x.apply(s,m),s.pointClass&&!defined$y(s.dataGroupInfo.options)&&(s.dataGroupInfo.options=merge$W(s.pointClass.prototype.optionsToObject.call({series:s},s.options.data[s.cropStart+A])),$.forEach(function(U){delete s.dataGroupInfo.options[U]})),typeof g<"u"&&(h.push(u),c.push(g),d.push(s.dataGroupInfo)),A=E,M=0;M<P;M++)m[M].length=0,m[M].hasNulls=!1;if(k+=1,E===p)break}if(E===p)break;if(y){var O=s.options.dataGrouping&&s.options.dataGrouping.groupAll?E:s.cropStart+E,L=a&&a[O]||s.pointClass.prototype.applyOptions.apply({series:s},[l[O]]),C=void 0;for(M=0;M<b;M++)C=L[y[M]],isNumber$s(C)?m[M].push(C):C===null&&(m[M].hasNulls=!0)}else f=v?r[E]:null,isNumber$s(f)?m[0].push(f):f===null&&(m[0].hasNulls=!0)}return{groupedXData:h,groupedYData:c,groupMap:d}},anchorPoints=function(n,r,t){var o=n.options,s=o.dataGrouping,a=n.currentDataGrouping&&n.currentDataGrouping.gapSize,l;if(s&&n.xData&&a&&n.groupMap){var h=r.length-1,c=s.anchor,d=pick$$(s.firstAnchor,c),p=pick$$(s.lastAnchor,c);if(c&&c!=="start"){var u=a*{middle:.5,end:1}[c];for(l=r.length-1;l--&&l>0;)r[l]+=u}if(d&&d!=="start"&&n.xData[0]>=r[0]){var f=n.groupMap[0].start,g=n.groupMap[0].length,v=void 0;isNumber$s(f)&&isNumber$s(g)&&(v=f+(g-1)),r[0]={middle:r[0]+.5*a,end:r[0]+a,firstPoint:n.xData[0],lastPoint:v&&n.xData[v]}[d]}if(p&&p!=="start"&&a&&r[h]>=t-a){var m=n.groupMap[n.groupMap.length-1].start;r[h]={middle:r[h]+.5*a,end:r[h]+a,firstPoint:m&&n.xData[m],lastPoint:n.xData[n.xData.length-1]}[p]}}},adjustExtremes=function(n,r){defined$y(r[0])&&isNumber$s(n.min)&&isNumber$s(n.dataMin)&&r[0]<n.min&&((!defined$y(n.options.min)&&n.min<=n.dataMin||n.min===n.dataMin)&&(n.min=Math.min(r[0],n.min)),n.dataMin=Math.min(r[0],n.dataMin)),defined$y(r[r.length-1])&&isNumber$s(n.max)&&isNumber$s(n.dataMax)&&r[r.length-1]>n.max&&((!defined$y(n.options.max)&&isNumber$s(n.dataMax)&&n.max>=n.dataMax||n.max===n.dataMax)&&(n.max=Math.max(r[r.length-1],n.max)),n.dataMax=Math.max(r[r.length-1],n.dataMax))},dataGrouping={approximations,groupData};seriesProto$3.processData;var baseGeneratePoints=seriesProto$3.generatePoints,commonOptions={groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S","%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},specificOptions={line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},defaultDataGroupingUnits=H.defaultDataGroupingUnits=[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]];seriesProto$3.getDGApproximation=function(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("column")?"sum":"average"};seriesProto$3.groupData=groupData;seriesProto$3.applyGrouping=applyGrouping;seriesProto$3.destroyGroupedData=function(){this.groupedData&&(this.groupedData.forEach(function(n,r){n&&(this.groupedData[r]=n.destroy?n.destroy():null)},this),this.groupedData.length=0)};seriesProto$3.generatePoints=function(){baseGeneratePoints.apply(this),this.destroyGroupedData(),this.groupedData=this.hasGroupedData?this.points:null};Axis.prototype.applyGrouping=function(){var n=this,r=n.series;r.forEach(function(t){t.groupPixelWidth=void 0,t.groupPixelWidth=n.getGroupPixelWidth&&n.getGroupPixelWidth(),t.groupPixelWidth&&(t.hasProcessed=!0),t.applyGrouping()})};Axis.prototype.getGroupPixelWidth=function(){var n=this.series,r=n.length,t,o=0,s=!1,a,l;for(t=r;t--;)l=n[t].options.dataGrouping,l&&(o=Math.max(o,pick$$(l.groupPixelWidth,commonOptions.groupPixelWidth)));for(t=r;t--;)l=n[t].options.dataGrouping,l&&(a=(n[t].processedXData||n[t].data).length,(n[t].groupPixelWidth||a>this.chart.plotSizeX/o||a&&l.forced)&&(s=!0));return s?o:0};Axis.prototype.setDataGrouping=function(n,r){var t=this,o;if(r=pick$$(r,!0),n||(n={forced:!1,units:null}),this instanceof Axis)for(o=this.series.length;o--;)this.series[o].update({dataGrouping:n},!1);else this.chart.options.series.forEach(function(s){s.dataGrouping=n},!1);t.ordinal&&(t.ordinal.slope=void 0),r&&this.chart.redraw()};addEvent$K(Axis,"postProcessData",Axis.prototype.applyGrouping);addEvent$K(Point$2,"update",function(){if(this.dataGroup)return error$2(24,!1,this.series.chart),!1});addEvent$K(Tooltip,"headerFormatter",function(n){var r=this.chart,t=r.time,o=n.labelConfig,s=o.series,a=s.options,l=s.tooltipOptions,h=a.dataGrouping,c=l.xDateFormat,d,p=s.xAxis,u,f,g,v,m=l[n.isFooter?"footerFormat":"headerFormat"];p&&p.options.type==="datetime"&&h&&isNumber$s(o.key)&&(u=s.currentDataGrouping,f=h.dateTimeLabelFormats||commonOptions.dateTimeLabelFormats,u?(g=f[u.unitName],u.count===1?c=g[0]:(c=g[1],d=g[2])):!c&&f&&p.dateTime&&(c=p.dateTime.getXDateFormat(o.x,l.dateTimeLabelFormats)),v=t.dateFormat(c,o.key),d&&(v+=t.dateFormat(d,o.key+u.totalRange-1)),s.chart.styledMode&&(m=this.styledModeFormat(m)),n.text=format$7(m,{point:extend$12(o.point,{key:v}),series:s},r),n.preventDefault())});addEvent$K(Series$e,"destroy",seriesProto$3.destroyGroupedData);addEvent$K(Series$e,"afterSetOptions",function(n){var r=n.options,t=this.type,o=this.chart.options.plotOptions,s=DefaultOptions.defaultOptions.plotOptions[t].dataGrouping,a=this.useCommonDataGrouping&&commonOptions;if(specificOptions[t]||a){s||(s=merge$W(commonOptions,specificOptions[t]));var l=this.chart.rangeSelector;r.dataGrouping=merge$W(a,s,o.series&&o.series.dataGrouping,o[t].dataGrouping,this.userOptions.dataGrouping,!r.isInternal&&l&&isNumber$s(l.selected)&&l.buttonOptions[l.selected].dataGrouping)}});addEvent$K(Axis,"afterSetScale",function(){this.series.forEach(function(n){n.hasProcessed=!1})});H.dataGrouping=dataGrouping;var __extends$L=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),ColumnSeries$g=SeriesRegistry$1.seriesTypes.column,OHLCPoint=function(n){__extends$L(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.close=void 0,t.high=void 0,t.low=void 0,t.open=void 0,t.options=void 0,t.plotClose=void 0,t.plotOpen=void 0,t.series=void 0,t}return r.prototype.getClassName=function(){return n.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")},r.prototype.resolveUpColor=function(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)},r.prototype.resolveColor=function(){n.prototype.resolveColor.call(this),this.resolveUpColor()},r.prototype.getZone=function(){var t=n.prototype.getZone.call(this);return this.resolveUpColor(),t},r.prototype.applyOptions=function(){return n.prototype.applyOptions.apply(this,arguments),this.resolveColor&&this.resolveColor(),this},r}(ColumnSeries$g.prototype.pointClass),__extends$K=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),ColumnSeries$f=SeriesRegistry$1.seriesTypes.column,extend$11=Utilities.extend,merge$V=Utilities.merge,OHLCSeries$1=function(n){__extends$K(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t.yData=void 0,t}return r.prototype.drawPoints=function(){var t=this,o=t.points,s=t.chart,a=function(l,h,c){var d=l[0],p=l[1];typeof d[2]=="number"&&(d[2]=Math.max(c+h,d[2])),typeof p[2]=="number"&&(p[2]=Math.min(c-h,p[2]))};o.forEach(function(l){var h,c,d,p,u,f=l.graphic,g,v=!f,m;typeof l.plotY<"u"&&(f||(l.graphic=f=s.renderer.path().add(t.group)),s.styledMode||f.attr(t.pointAttribs(l,l.selected&&"select")),m=f.strokeWidth(),d=m%2/2,g=Math.round(l.plotX)-d,p=Math.round(l.shapeArgs.width/2),u=[["M",g,Math.round(l.yBottom)],["L",g,Math.round(l.plotHigh)]],l.open!==null&&(h=Math.round(l.plotOpen)+d,u.push(["M",g,h],["L",g-p,h]),a(u,m/2,h)),l.close!==null&&(c=Math.round(l.plotClose)+d,u.push(["M",g,c],["L",g+p,c]),a(u,m/2,c)),f[v?"attr":"animate"]({d:u}).addClass(l.getClassName(),!0))})},r.prototype.init=function(){n.prototype.init.apply(this,arguments),this.options.stacking=void 0},r.prototype.pointAttribs=function(t,o){var s=n.prototype.pointAttribs.call(this,t,o),a=this.options;return delete s.fill,!t.options.color&&a.upColor&&t.open<t.close&&(s.stroke=a.upColor),s},r.prototype.toYData=function(t){return[t.open,t.high,t.low,t.close]},r.prototype.translate=function(){var t=this,o=t.yAxis,s=!!t.modifyValue,a=["plotOpen","plotHigh","plotLow","plotClose","yBottom"];n.prototype.translate.apply(t),t.points.forEach(function(l){[l.open,l.high,l.low,l.close,l.low].forEach(function(h,c){h!==null&&(s&&(h=t.modifyValue(h)),l[a[c]]=o.toPixels(h,!0))}),l.tooltipPos[1]=l.plotHigh+o.pos-t.chart.plotTop})},r.defaultOptions=merge$V(ColumnSeries$f.defaultOptions,{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0}),r}(ColumnSeries$f);extend$11(OHLCSeries$1.prototype,{animate:null,directTouch:!1,pointArrayMap:["open","high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"});OHLCSeries$1.prototype.pointClass=OHLCPoint;SeriesRegistry$1.registerSeriesType("ohlc",OHLCSeries$1);var __extends$J=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),defaultOptions$8=DefaultOptions.defaultOptions,_a$d=SeriesRegistry$1.seriesTypes,ColumnSeries$e=_a$d.column,OHLCSeries=_a$d.ohlc,merge$U=Utilities.merge,CandlestickSeries=function(n){__extends$J(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.pointAttribs=function(t,o){var s=ColumnSeries$e.prototype.pointAttribs.call(this,t,o),a=this.options,l=t.open<t.close,h=a.lineColor||this.color,c=t.color||this.color,d;return s["stroke-width"]=a.lineWidth,s.fill=t.options.color||l&&a.upColor||c,s.stroke=t.options.lineColor||l&&a.upLineColor||h,o&&(d=a.states[o],s.fill=d.color||s.fill,s.stroke=d.lineColor||s.stroke,s["stroke-width"]=d.lineWidth||s["stroke-width"]),s},r.prototype.drawPoints=function(){var t=this,o=t.points,s=t.chart,a=t.yAxis.reversed;o.forEach(function(l){var h=l.graphic,c,d,p,u,f,g,v,m,x,y,b=!h;typeof l.plotY<"u"&&(h||(l.graphic=h=s.renderer.path().add(t.group)),t.chart.styledMode||h.attr(t.pointAttribs(l,l.selected&&"select")).shadow(t.options.shadow),v=h.strokeWidth()%2/2,m=Math.round(l.plotX)-v,c=l.plotOpen,d=l.plotClose,p=Math.min(c,d),u=Math.max(c,d),y=Math.round(l.shapeArgs.width/2),f=a?u!==l.yBottom:Math.round(p)!==Math.round(l.plotHigh),g=a?Math.round(p)!==Math.round(l.plotHigh):u!==l.yBottom,p=Math.round(p)+v,u=Math.round(u)+v,x=[],x.push(["M",m-y,u],["L",m-y,p],["L",m+y,p],["L",m+y,u],["Z"],["M",m,p],["L",m,f?Math.round(a?l.yBottom:l.plotHigh):p],["M",m,u],["L",m,g?Math.round(a?l.plotHigh:l.yBottom):u]),h[b?"attr":"animate"]({d:x}).addClass(l.getClassName(),!0))})},r.defaultOptions=merge$U(OHLCSeries.defaultOptions,defaultOptions$8.plotOptions,{states:{hover:{lineWidth:2}},tooltip:defaultOptions$8.plotOptions.ohlc.tooltip,threshold:null,lineColor:palette.neutralColor100,lineWidth:1,upColor:palette.backgroundColor,stickyTracking:!0}),r}(OHLCSeries);SeriesRegistry$1.registerSeriesType("candlestick",CandlestickSeries);var __extends$I=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),ColumnSeries$d=SeriesRegistry$1.seriesTypes.column,isNumber$r=Utilities.isNumber,FlagsPoint=function(n){__extends$I(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return r.prototype.isValid=function(){return isNumber$r(this.y)||typeof this.y>"u"},r.prototype.hasNewShapeType=function(){var t=this.options.shape||this.series.options.shape;return this.graphic&&t&&t!==this.graphic.symbolKey},r}(ColumnSeries$d.prototype.pointClass),columnProto$5=ColumnSeries$h.prototype,seriesProto$2=Series$e.prototype,defined$x=Utilities.defined,stableSort$4=Utilities.stableSort,onSeriesMixin={getPlotBox:function(){return seriesProto$2.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this)},translate:function(){columnProto$5.translate.apply(this);var n=this,r=n.options,t=n.chart,o=n.points,s=o.length-1,a,l,h=r.onSeries,c=h&&t.get(h),d=r.onKey||"y",p=c&&c.options.step,u=c&&c.points,f=u&&u.length,g=t.inverted,v=n.xAxis,m=n.yAxis,x=0,y,b,$,S,k;if(c&&c.visible&&f)for(x=(c.pointXOffset||0)+(c.barW||0)/2,S=c.currentDataGrouping,b=u[f-1].x+(S?S.totalRange:0),stableSort$4(o,function(A,P){return A.x-P.x}),d="plot"+d[0].toUpperCase()+d.substr(1);f--&&o[s]&&(y=u[f],a=o[s],a.y=y.y,!(y.x<=a.x&&typeof y[d]<"u"&&(a.x<=b&&(a.plotY=y[d],y.x<a.x&&!p&&($=u[f+1],$&&typeof $[d]<"u"&&(k=(a.x-y.x)/($.x-y.x),a.plotY+=k*($[d]-y[d]),a.y+=k*($.y-y.y)))),s--,f++,s<0))););o.forEach(function(A,P){var E;A.plotX+=x,(typeof A.plotY>"u"||g)&&(A.plotX>=0&&A.plotX<=v.len?g?(A.plotY=v.translate(A.x,0,1,0,1),A.plotX=defined$x(A.y)?m.translate(A.y,0,0,0,1):0):A.plotY=(v.opposite?0:n.yAxis.len)+v.offset:A.shapeArgs={}),l=o[P-1],l&&l.plotX===A.plotX&&(typeof l.stackIndex>"u"&&(l.stackIndex=0),E=l.stackIndex+1),A.stackIndex=E}),this.onSeries=c}},symbols$3=SVGRenderer.prototype.symbols;symbols$3.flag=function(n,r,t,o,s){var a=s&&s.anchorX||n,l=s&&s.anchorY||r,h=symbols$3.circle(a-1,l-1,2,2);return h.push(["M",a,l],["L",n,r+o],["L",n,r],["L",n+t,r],["L",n+t,r+o],["L",n,r+o],["Z"]),h};function createPinSymbol(n){symbols$3[n+"pin"]=function(r,t,o,s,a){var l=a&&a.anchorX,h=a&&a.anchorY,c;if(n==="circle"&&s>o&&(r-=Math.round((s-o)/2),o=s),c=symbols$3[n](r,t,o,s),l&&h){var d=l;if(n==="circle")d=r+o/2;else{var p=c[0],u=c[1];p[0]==="M"&&u[0]==="L"&&(d=(p[1]+u[1])/2)}var f=t>h?t:t+s;c.push(["M",d,f],["L",l,h]),c=c.concat(symbols$3.circle(l-1,h-1,2,2))}return c}}createPinSymbol("circle");createPinSymbol("square");var Renderer=RendererRegistry$1.getRendererType();Renderer!==SVGRenderer&&(Renderer.prototype.symbols.circlepin=symbols$3.circlepin,Renderer.prototype.symbols.flag=symbols$3.flag,Renderer.prototype.symbols.squarepin=symbols$3.squarepin);var __extends$H=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),noop$e=H.noop,distribute=R.distribute,Series$b=SeriesRegistry$1.series,ColumnSeries$c=SeriesRegistry$1.seriesTypes.column,addEvent$J=Utilities.addEvent,defined$w=Utilities.defined,extend$10=Utilities.extend,merge$T=Utilities.merge,objectEach$e=Utilities.objectEach,wrap$b=Utilities.wrap,FlagsSeries=function(n){__extends$H(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.animate=function(t){t&&this.setClip()},r.prototype.drawPoints=function(){var t=this,o=t.points,s=t.chart,a=s.renderer,l,h,c=s.inverted,d=t.options,p=d.y,u,f,g,v,m,x,y,b,$=t.yAxis,S={},k=[],A;for(f=o.length;f--;)g=o[f],b=(c?g.plotY:g.plotX)>t.xAxis.len,l=g.plotX,m=g.stackIndex,u=g.options.shape||d.shape,h=g.plotY,typeof h<"u"&&(h=g.plotY+p-(typeof m<"u"&&m*d.stackDistance)),g.anchorX=m?void 0:g.plotX,x=m?void 0:g.plotY,A=u!=="flag",v=g.graphic,typeof h<"u"&&l>=0&&!b?(v&&g.hasNewShapeType()&&(v=v.destroy()),v||(v=g.graphic=a.label("",null,null,u,null,null,d.useHTML).addClass("highcharts-point").add(t.markerGroup),g.graphic.div&&(g.graphic.div.point=g),v.isNew=!0),v.attr({align:A?"center":"left",width:d.width,height:d.height,"text-align":d.textAlign}),s.styledMode||v.attr(t.pointAttribs(g)).css(merge$T(d.style,g.style)).shadow(d.shadow),l>0&&(l-=v.strokeWidth()%2),y={y:h,anchorY:x},d.allowOverlapX&&(y.x=l,y.anchorX=g.anchorX),v.attr({text:g.options.title||d.title||"A"})[v.isNew?"attr":"animate"](y),d.allowOverlapX||(S[g.plotX]?S[g.plotX].size=Math.max(S[g.plotX].size,v.width):S[g.plotX]={align:A?.5:0,size:v.width,target:l,anchorX:l}),g.tooltipPos=[l,h+$.pos-s.plotTop]):v&&(g.graphic=v.destroy());d.allowOverlapX||(objectEach$e(S,function(P){P.plotX=P.anchorX,k.push(P)}),distribute(k,c?$.len:this.xAxis.len,100),o.forEach(function(P){var E=P.graphic&&S[P.plotX];E&&(P.graphic[P.graphic.isNew?"attr":"animate"]({x:E.pos+E.align*E.size,anchorX:P.anchorX}),defined$w(E.pos)?P.graphic.isNew=!1:(P.graphic.attr({x:-9999,anchorX:-9999}),P.graphic.isNew=!0))})),d.useHTML&&wrap$b(t.markerGroup,"on",function(P){return SVGElement.prototype.on.apply(P.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})},r.prototype.drawTracker=function(){var t=this,o=t.points;n.prototype.drawTracker.call(this),o.forEach(function(s){var a=s.graphic;a&&(s.unbindMouseOver&&s.unbindMouseOver(),s.unbindMouseOver=addEvent$J(a.element,"mouseover",function(){s.stackIndex>0&&!s.raised&&(s._y=a.y,a.attr({y:s._y-8}),s.raised=!0),o.forEach(function(l){l!==s&&l.raised&&l.graphic&&(l.graphic.attr({y:l._y}),l.raised=!1)})}))})},r.prototype.pointAttribs=function(t,o){var s=this.options,a=t&&t.color||this.color,l=s.lineColor,h=t&&t.lineWidth,c=t&&t.fillColor||s.fillColor;return o&&(c=s.states[o].fillColor,l=s.states[o].lineColor,h=s.states[o].lineWidth),{fill:c||a,stroke:l||a,"stroke-width":h||s.lineWidth||0}},r.prototype.setClip=function(){Series$b.prototype.setClip.apply(this,arguments),this.options.clip!==!1&&this.sharedClipKey&&this.markerGroup&&this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])},r.defaultOptions=merge$T(ColumnSeries$c.defaultOptions,{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:palette.backgroundColor,lineWidth:1,states:{hover:{lineColor:palette.neutralColor100,fillColor:palette.highlightColor20}},style:{fontSize:"11px",fontWeight:"bold"}}),r}(ColumnSeries$c);extend$10(FlagsSeries.prototype,{allowDG:!1,buildKDTree:noop$e,forceCrop:!0,getPlotBox:onSeriesMixin.getPlotBox,init:Series$b.prototype.init,invertGroups:noop$e,invertible:!1,noSharedTooltip:!0,pointClass:FlagsPoint,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],translate:onSeriesMixin.translate});SeriesRegistry$1.registerSeriesType("flags",FlagsSeries);var addEvent$I=Utilities.addEvent,defined$v=Utilities.defined,pick$_=Utilities.pick,ScrollbarAxis=function(){function n(){}return n.compose=function(r,t){if(n.composed.indexOf(r)===-1)n.composed.push(r);else return r;var o=function(s){var a=pick$_(s.options&&s.options.min,s.min),l=pick$_(s.options&&s.options.max,s.max);return{axisMin:a,axisMax:l,scrollMin:defined$v(s.dataMin)?Math.min(a,s.min,s.dataMin,pick$_(s.threshold,1/0)):a,scrollMax:defined$v(s.dataMax)?Math.max(l,s.max,s.dataMax,pick$_(s.threshold,-1/0)):l}};return addEvent$I(r,"afterInit",function(){var s=this;s.options&&s.options.scrollbar&&s.options.scrollbar.enabled&&(s.options.scrollbar.vertical=!s.horiz,s.options.startOnTick=s.options.endOnTick=!1,s.scrollbar=new t(s.chart.renderer,s.options.scrollbar,s.chart),addEvent$I(s.scrollbar,"changed",function(a){var l=o(s),h=l.axisMin,c=l.axisMax,d=l.scrollMin,p=l.scrollMax,u=p-d,f,g;!defined$v(h)||!defined$v(c)||(s.horiz&&!s.reversed||!s.horiz&&s.reversed?(f=d+u*this.to,g=d+u*this.from):(f=d+u*(1-this.from),g=d+u*(1-this.to)),this.shouldUpdateExtremes(a.DOMType)?s.setExtremes(g,f,!0,a.DOMType!=="mousemove"&&a.DOMType!=="touchmove",a):this.setRange(this.from,this.to))}))}),addEvent$I(r,"afterRender",function(){var s=this,a=o(s),l=a.scrollMin,h=a.scrollMax,c=s.scrollbar,d=s.axisTitleMargin+(s.titleOffset||0),p=s.chart.scrollbarsOffsets,u=s.options.margin||0,f,g,v;c&&(s.horiz?(s.opposite||(p[1]+=d),c.position(s.left,s.top+s.height+2+p[1]-(s.opposite?u:0),s.width,s.height),s.opposite||(p[1]+=u),f=1):(s.opposite&&(p[0]+=d),c.position(s.left+s.width+2+p[0]-(s.opposite?0:u),s.top,s.width,s.height),s.opposite&&(p[0]+=u),f=0),p[f]+=c.size+c.options.margin,isNaN(l)||isNaN(h)||!defined$v(s.min)||!defined$v(s.max)||s.min===s.max?c.setRange(0,1):(g=(s.min-l)/(h-l),v=(s.max-l)/(h-l),s.horiz&&!s.reversed||!s.horiz&&s.reversed?c.setRange(g,v):c.setRange(1-v,1-g)))}),addEvent$I(r,"afterGetOffset",function(){var s=this,a=s.horiz?2:1,l=s.scrollbar;l&&(s.chart.scrollbarsOffsets=[0,0],s.chart.axisOffset[a]+=l.size+l.options.margin)}),r},n.composed=[],n}(),isTouchDevice$3=H.isTouchDevice,ScrollbarDefaults={height:isTouchDevice$3?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,margin:10,minWidth:6,step:.2,zIndex:3,barBackgroundColor:palette.neutralColor20,barBorderWidth:1,barBorderColor:palette.neutralColor20,buttonArrowColor:palette.neutralColor80,buttonBackgroundColor:palette.neutralColor10,buttonBorderColor:palette.neutralColor20,buttonBorderWidth:1,rifleColor:palette.neutralColor80,trackBackgroundColor:palette.neutralColor5,trackBorderColor:palette.neutralColor5,trackBorderWidth:1},defaultOptions$7=DefaultOptions.defaultOptions,addEvent$H=Utilities.addEvent,correctFloat$6=Utilities.correctFloat,defined$u=Utilities.defined,destroyObjectProperties$3=Utilities.destroyObjectProperties,fireEvent$k=Utilities.fireEvent,merge$S=Utilities.merge,pick$Z=Utilities.pick,removeEvent$4=Utilities.removeEvent,Scrollbar=function(){function n(r,t,o){this._events=[],this.chart=void 0,this.chartX=0,this.chartY=0,this.from=0,this.group=void 0,this.options=void 0,this.renderer=void 0,this.scrollbar=void 0,this.scrollbarButtons=[],this.scrollbarGroup=void 0,this.scrollbarLeft=0,this.scrollbarRifles=void 0,this.scrollbarStrokeWidth=1,this.scrollbarTop=0,this.size=0,this.to=0,this.track=void 0,this.trackBorderWidth=1,this.userOptions=void 0,this.x=0,this.y=0,this.init(r,t,o)}return n.compose=function(r){ScrollbarAxis.compose(r,n)},n.swapXY=function(r,t){return t&&r.forEach(function(o){for(var s=o.length,a,l=0;l<s;l+=2)a=o[l+1],typeof a=="number"&&(o[l+1]=o[l+2],o[l+2]=a)}),r},n.prototype.addEvents=function(){var r=this.options.inverted?[1,0]:[0,1],t=this.scrollbarButtons,o=this.scrollbarGroup.element,s=this.track.element,a=this.mouseDownHandler.bind(this),l=this.mouseMoveHandler.bind(this),h=this.mouseUpHandler.bind(this),c=[[t[r[0]].element,"click",this.buttonToMinClick.bind(this)],[t[r[1]].element,"click",this.buttonToMaxClick.bind(this)],[s,"click",this.trackClick.bind(this)],[o,"mousedown",a],[o.ownerDocument,"mousemove",l],[o.ownerDocument,"mouseup",h]];H.hasTouch&&c.push([o,"touchstart",a],[o.ownerDocument,"touchmove",l],[o.ownerDocument,"touchend",h]),c.forEach(function(d){addEvent$H.apply(null,d)}),this._events=c},n.prototype.buttonToMaxClick=function(r){var t=this,o=(t.to-t.from)*pick$Z(t.options.step,.2);t.updatePosition(t.from+o,t.to+o),fireEvent$k(t,"changed",{from:t.from,to:t.to,trigger:"scrollbar",DOMEvent:r})},n.prototype.buttonToMinClick=function(r){var t=this,o=correctFloat$6(t.to-t.from)*pick$Z(t.options.step,.2);t.updatePosition(correctFloat$6(t.from-o),correctFloat$6(t.to-o)),fireEvent$k(t,"changed",{from:t.from,to:t.to,trigger:"scrollbar",DOMEvent:r})},n.prototype.cursorToScrollbarPosition=function(r){var t=this,o=t.options,s=o.minWidth>t.calculatedWidth?o.minWidth:0;return{chartX:(r.chartX-t.x-t.xOffset)/(t.barWidth-s),chartY:(r.chartY-t.y-t.yOffset)/(t.barWidth-s)}},n.prototype.destroy=function(){var r=this,t=r.chart.scroller;r.removeEvents(),["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(o){r[o]&&r[o].destroy&&(r[o]=r[o].destroy())}),t&&r===t.scrollbar&&(t.scrollbar=null,destroyObjectProperties$3(t.scrollbarButtons))},n.prototype.drawScrollbarButton=function(r){var t=this,o=t.renderer,s=t.scrollbarButtons,a=t.options,l=t.size,h=o.g().add(t.group),c;s.push(h),c=o.rect().addClass("highcharts-scrollbar-button").add(h),t.chart.styledMode||c.attr({stroke:a.buttonBorderColor,"stroke-width":a.buttonBorderWidth,fill:a.buttonBackgroundColor}),c.attr(c.crisp({x:-.5,y:-.5,width:l+1,height:l+1,r:a.buttonBorderRadius},c.strokeWidth())),c=o.path(n.swapXY([["M",l/2+(r?-1:1),l/2-3],["L",l/2+(r?-1:1),l/2+3],["L",l/2+(r?2:-2),l/2]],a.vertical)).addClass("highcharts-scrollbar-arrow").add(s[r]),t.chart.styledMode||c.attr({fill:a.buttonArrowColor})},n.prototype.init=function(r,t,o){var s=this;s.scrollbarButtons=[],s.renderer=r,s.userOptions=t,s.options=merge$S(ScrollbarDefaults,defaultOptions$7.scrollbar,t),s.chart=o,s.size=pick$Z(s.options.size,s.options.height),t.enabled&&(s.render(),s.addEvents())},n.prototype.mouseDownHandler=function(r){var t=this,o=t.chart.pointer.normalize(r),s=t.cursorToScrollbarPosition(o);t.chartX=s.chartX,t.chartY=s.chartY,t.initPositions=[t.from,t.to],t.grabbedCenter=!0},n.prototype.mouseMoveHandler=function(r){var t=this,o=t.chart.pointer.normalize(r),s=t.options,a=s.vertical?"chartY":"chartX",l=t.initPositions||[],h,c,d;t.grabbedCenter&&(!r.touches||r.touches[0][a]!==0)&&(c=t.cursorToScrollbarPosition(o)[a],h=t[a],d=c-h,t.hasDragged=!0,t.updatePosition(l[0]+d,l[1]+d),t.hasDragged&&fireEvent$k(t,"changed",{from:t.from,to:t.to,trigger:"scrollbar",DOMType:r.type,DOMEvent:r}))},n.prototype.mouseUpHandler=function(r){var t=this;t.hasDragged&&fireEvent$k(t,"changed",{from:t.from,to:t.to,trigger:"scrollbar",DOMType:r.type,DOMEvent:r}),t.grabbedCenter=t.hasDragged=t.chartX=t.chartY=null},n.prototype.position=function(r,t,o,s){var a=this,l=a.options,h=l.vertical,c=a.rendered?"animate":"attr",d=s,p=0;a.x=r,a.y=t+this.trackBorderWidth,a.width=o,a.height=s,a.xOffset=d,a.yOffset=p,h?(a.width=a.yOffset=o=p=a.size,a.xOffset=d=0,a.barWidth=s-o*2,a.x=r=r+a.options.margin):(a.height=a.xOffset=s=d=a.size,a.barWidth=o-s*2,a.y=a.y+a.options.margin),a.group[c]({translateX:r,translateY:a.y}),a.track[c]({width:o,height:s}),a.scrollbarButtons[1][c]({translateX:h?0:o-d,translateY:h?s-p:0})},n.prototype.removeEvents=function(){this._events.forEach(function(r){removeEvent$4.apply(null,r)}),this._events.length=0},n.prototype.render=function(){var r=this,t=r.renderer,o=r.options,s=r.size,a=r.chart.styledMode,l=t.g("scrollbar").attr({zIndex:o.zIndex,translateY:-99999}).add();r.group=l,r.track=t.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:o.trackBorderRadius||0,height:s,width:s}).add(l),a||r.track.attr({fill:o.trackBackgroundColor,stroke:o.trackBorderColor,"stroke-width":o.trackBorderWidth}),r.trackBorderWidth=r.track.strokeWidth(),r.track.attr({y:-this.trackBorderWidth%2/2}),r.scrollbarGroup=t.g().add(l),r.scrollbar=t.rect().addClass("highcharts-scrollbar-thumb").attr({height:s,width:s,r:o.barBorderRadius||0}).add(r.scrollbarGroup),r.scrollbarRifles=t.path(n.swapXY([["M",-3,s/4],["L",-3,2*s/3],["M",0,s/4],["L",0,2*s/3],["M",3,s/4],["L",3,2*s/3]],o.vertical)).addClass("highcharts-scrollbar-rifles").add(r.scrollbarGroup),a||(r.scrollbar.attr({fill:o.barBackgroundColor,stroke:o.barBorderColor,"stroke-width":o.barBorderWidth}),r.scrollbarRifles.attr({stroke:o.rifleColor,"stroke-width":1})),r.scrollbarStrokeWidth=r.scrollbar.strokeWidth(),r.scrollbarGroup.translate(-r.scrollbarStrokeWidth%2/2,-r.scrollbarStrokeWidth%2/2),r.drawScrollbarButton(0),r.drawScrollbarButton(1)},n.prototype.setRange=function(r,t){var o=this,s=o.options,a=s.vertical,l=s.minWidth,h=o.barWidth,c=this.rendered&&!this.hasDragged&&!(this.chart.navigator&&this.chart.navigator.hasDragged)?"animate":"attr";if(defined$u(h)){var d=h*Math.min(t,1),p,u;r=Math.max(r,0),p=Math.ceil(h*r),o.calculatedWidth=u=correctFloat$6(d-p),u<l&&(p=(h-l+u)*r,u=l);var f=Math.floor(p+o.xOffset+o.yOffset),g=u/2-.5;o.from=r,o.to=t,a?(o.scrollbarGroup[c]({translateY:f}),o.scrollbar[c]({height:u}),o.scrollbarRifles[c]({translateY:g}),o.scrollbarTop=f,o.scrollbarLeft=0):(o.scrollbarGroup[c]({translateX:f}),o.scrollbar[c]({width:u}),o.scrollbarRifles[c]({translateX:g}),o.scrollbarLeft=f,o.scrollbarTop=0),u<=12?o.scrollbarRifles.hide():o.scrollbarRifles.show(!0),s.showFull===!1&&(r<=0&&t>=1?o.group.hide():o.group.show()),o.rendered=!0}},n.prototype.shouldUpdateExtremes=function(r){return pick$Z(this.options.liveRedraw,H.svg&&!H.isTouchDevice&&!this.chart.isBoosting)||r==="mouseup"||r==="touchend"||!defined$u(r)},n.prototype.trackClick=function(r){var t=this,o=t.chart.pointer.normalize(r),s=t.to-t.from,a=t.y+t.scrollbarTop,l=t.x+t.scrollbarLeft;t.options.vertical&&o.chartY>a||!t.options.vertical&&o.chartX>l?t.updatePosition(t.from+s,t.to+s):t.updatePosition(t.from-s,t.to-s),fireEvent$k(t,"changed",{from:t.from,to:t.to,trigger:"scrollbar",DOMEvent:r})},n.prototype.update=function(r){this.destroy(),this.init(this.chart.renderer,merge$S(!0,this.options,r),this.chart)},n.prototype.updatePosition=function(r,t){t>1&&(r=correctFloat$6(1-correctFloat$6(t-r)),t=1),r<0&&(t=correctFloat$6(t-r),r=0),this.from=r,this.to=t},n.defaultOptions=ScrollbarDefaults,n}();defaultOptions$7.scrollbar=merge$S(!0,Scrollbar.defaultOptions,defaultOptions$7.scrollbar);var isTouchDevice$2=H.isTouchDevice,addEvent$G=Utilities.addEvent,correctFloat$5=Utilities.correctFloat,defined$t=Utilities.defined,isNumber$q=Utilities.isNumber,pick$Y=Utilities.pick,NavigatorAxisAdditions=function(){function n(r){this.axis=r}return n.prototype.destroy=function(){this.axis=void 0},n.prototype.toFixedRange=function(r,t,o,s){var a=this,l=a.axis,h=l.chart,c=h&&h.fixedRange,d=(l.pointRange||0)/2,p=pick$Y(o,l.translate(r,!0,!l.horiz)),u=pick$Y(s,l.translate(t,!0,!l.horiz)),f=c&&(u-p)/c;return defined$t(o)||(p=correctFloat$5(p+d)),defined$t(s)||(u=correctFloat$5(u-d)),f>.7&&f<1.3&&(s?p=u-c:u=p+c),(!isNumber$q(p)||!isNumber$q(u))&&(p=u=void 0),{min:p,max:u}},n}(),NavigatorAxis=function(){function n(){}return n.compose=function(r){r.keepProps.push("navigatorAxis"),addEvent$G(r,"init",function(){var t=this;t.navigatorAxis||(t.navigatorAxis=new NavigatorAxisAdditions(t))}),addEvent$G(r,"zoom",function(t){var o=this,s=o.chart,a=s.options,l=a.navigator,h=o.navigatorAxis,c=a.chart.pinchType,d=a.rangeSelector,p=a.chart.zoomType,u;o.isXAxis&&(l&&l.enabled||d&&d.enabled)&&(p==="y"?t.zoomed=!1:(!isTouchDevice$2&&p==="xy"||isTouchDevice$2&&c==="xy")&&o.options.range&&(u=h.previousZoom,defined$t(t.newMin)?h.previousZoom=[o.min,o.max]:u&&(t.newMin=u[0],t.newMax=u[1],h.previousZoom=void 0))),typeof t.zoomed<"u"&&t.preventDefault()})},n.AdditionsClass=NavigatorAxisAdditions,n}(),color$b=Color.parse,hasTouch=H.hasTouch,isTouchDevice$1=H.isTouchDevice,defaultOptions$6=DefaultOptions.defaultOptions,seriesTypes$5=SeriesRegistry$1.seriesTypes,addEvent$F=Utilities.addEvent,clamp$a=Utilities.clamp,correctFloat$4=Utilities.correctFloat,defined$s=Utilities.defined,destroyObjectProperties$2=Utilities.destroyObjectProperties,erase$1=Utilities.erase,extend$$=Utilities.extend,find$c=Utilities.find,isArray$8=Utilities.isArray,isNumber$p=Utilities.isNumber,merge$R=Utilities.merge,pick$X=Utilities.pick,removeEvent$3=Utilities.removeEvent,splat$9=Utilities.splat,defaultSeriesType,numExt=function(n){for(var r=[],t=1;t<arguments.length;t++)r[t-1]=arguments[t];var o=[].filter.call(r,isNumber$p);if(o.length)return Math[n].apply(0,o)};defaultSeriesType=typeof seriesTypes$5.areaspline>"u"?"line":"areaspline";extend$$(defaultOptions$6,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:palette.neutralColor5,borderColor:palette.neutralColor40},maskFill:color$b(palette.highlightColor60).setOpacity(.3).get(),outlineColor:palette.neutralColor20,outlineWidth:1,series:{type:defaultSeriesType,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:palette.neutralColor10,gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:palette.neutralColor40},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});RendererRegistry$1.getRendererType().prototype.symbols["navigator-handle"]=function(n,r,t,o,s){var a=(s&&s.width||0)/2,l=Math.round(a/3)+.5,h=s&&s.height||0;return[["M",-a-1,.5],["L",a,.5],["L",a,h+.5],["L",-a-1,h+.5],["L",-a-1,.5],["M",-l,4],["L",-l,h-3],["M",l-1,4],["L",l-1,h-3]]};var Navigator=function(){function n(r){this.baseSeries=void 0,this.chart=void 0,this.handles=void 0,this.height=void 0,this.left=void 0,this.navigatorEnabled=void 0,this.navigatorGroup=void 0,this.navigatorOptions=void 0,this.navigatorSeries=void 0,this.navigatorSize=void 0,this.opposite=void 0,this.outline=void 0,this.outlineHeight=void 0,this.range=void 0,this.rendered=void 0,this.shades=void 0,this.size=void 0,this.top=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zoomedMax=void 0,this.zoomedMin=void 0,this.init(r)}return n.prototype.drawHandle=function(r,t,o,s){var a=this,l=a.navigatorOptions.handles.height;a.handles[t][s](o?{translateX:Math.round(a.left+a.height/2),translateY:Math.round(a.top+parseInt(r,10)+.5-l)}:{translateX:Math.round(a.left+parseInt(r,10)),translateY:Math.round(a.top+a.height/2-l/2-1)})},n.prototype.drawOutline=function(r,t,o,s){var a=this,l=a.navigatorOptions.maskInside,h=a.outline.strokeWidth(),c=h/2,d=h%2/2,p=a.outlineHeight,u=a.scrollbarHeight||0,f=a.size,g=a.left-u,v=a.top,m,x;o?(g-=c,m=v+t+d,t=v+r+d,x=[["M",g+p,v-u-d],["L",g+p,m],["L",g,m],["L",g,t],["L",g+p,t],["L",g+p,v+f+u]],l&&x.push(["M",g+p,m-c],["L",g+p,t+c])):(r+=g+u-d,t+=g+u-d,v+=c,x=[["M",g,v],["L",r,v],["L",r,v+p],["L",t,v+p],["L",t,v],["L",g+f+u*2,v]],l&&x.push(["M",r-c,v],["L",t+c,v])),a.outline[s]({d:x})},n.prototype.drawMasks=function(r,t,o,s){var a=this,l=a.left,h=a.top,c=a.height,d,p,u,f;o?(u=[l,l,l],f=[h,h+r,h+t],p=[c,c,c],d=[r,t-r,a.size-t]):(u=[l,l+r,l+t],f=[h,h,h],p=[r,t-r,a.size-t],d=[c,c,c]),a.shades.forEach(function(g,v){g[s]({x:u[v],y:f[v],width:p[v],height:d[v]})})},n.prototype.renderElements=function(){var r=this,t=r.navigatorOptions,o=t.maskInside,s=r.chart,a=s.inverted,l=s.renderer,h,c={cursor:a?"ns-resize":"ew-resize"};r.navigatorGroup=h=l.g("navigator").attr({zIndex:8,visibility:"hidden"}).add(),[!o,o,!o].forEach(function(d,p){r.shades[p]=l.rect().addClass("highcharts-navigator-mask"+(p===1?"-inside":"-outside")).add(h),s.styledMode||r.shades[p].attr({fill:d?t.maskFill:"rgba(0,0,0,0)"}).css(p===1&&c)}),r.outline=l.path().addClass("highcharts-navigator-outline").add(h),s.styledMode||r.outline.attr({"stroke-width":t.outlineWidth,stroke:t.outlineColor}),t.handles.enabled&&[0,1].forEach(function(d){if(t.handles.inverted=s.inverted,r.handles[d]=l.symbol(t.handles.symbols[d],-t.handles.width/2-1,0,t.handles.width,t.handles.height,t.handles),r.handles[d].attr({zIndex:7-d}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][d]).add(h),!s.styledMode){var p=t.handles;r.handles[d].attr({fill:p.backgroundColor,stroke:p.borderColor,"stroke-width":p.lineWidth}).css(c)}})},n.prototype.update=function(r){(this.series||[]).forEach(function(o){o.baseSeries&&delete o.baseSeries.navigatorSeries}),this.destroy();var t=this.chart.options;merge$R(!0,t.navigator,this.options,r),this.init(this.chart)},n.prototype.render=function(r,t,o,s){var a=this,l=a.chart,h,c,d,p=a.scrollbarHeight,u,f=a.xAxis,g=f.pointRange||0,v=f.navigatorAxis.fake?l.xAxis[0]:f,m=a.navigatorEnabled,x,y,b=a.rendered,$=l.inverted,S,k,A,P,E=l.xAxis[0].minRange,M=l.xAxis[0].options.maxRange;if(!(this.hasDragged&&!defined$s(o))){if(r=correctFloat$4(r-g/2),t=correctFloat$4(t+g/2),!isNumber$p(r)||!isNumber$p(t))if(b)o=0,s=pick$X(f.width,v.width);else return;a.left=pick$X(f.left,l.plotLeft+p+($?l.plotWidth:0)),a.size=y=u=pick$X(f.len,($?l.plotHeight:l.plotWidth)-2*p),$?h=p:h=u+2*p,o=pick$X(o,f.toPixels(r,!0)),s=pick$X(s,f.toPixels(t,!0)),(!isNumber$p(o)||Math.abs(o)===1/0)&&(o=0,s=h),k=f.toValue(o,!0),A=f.toValue(s,!0),P=Math.abs(correctFloat$4(A-k)),P<E?this.grabbedLeft?o=f.toPixels(A-E-g,!0):this.grabbedRight&&(s=f.toPixels(k+E+g,!0)):defined$s(M)&&correctFloat$4(P-g)>M&&(this.grabbedLeft?o=f.toPixels(A-M-g,!0):this.grabbedRight&&(s=f.toPixels(k+M+g,!0))),a.zoomedMax=clamp$a(Math.max(o,s),0,y),a.zoomedMin=clamp$a(a.fixedWidth?a.zoomedMax-a.fixedWidth:Math.min(o,s),0,y),a.range=a.zoomedMax-a.zoomedMin,y=Math.round(a.zoomedMax),x=Math.round(a.zoomedMin),m&&(a.navigatorGroup.attr({visibility:"visible"}),S=b&&!a.hasDragged?"animate":"attr",a.drawMasks(x,y,$,S),a.drawOutline(x,y,$,S),a.navigatorOptions.handles.enabled&&(a.drawHandle(x,0,$,S),a.drawHandle(y,1,$,S))),a.scrollbar&&($?(d=a.top-p,c=a.left-p+(m||!v.opposite?0:(v.titleOffset||0)+v.axisTitleMargin),p=u+2*p):(d=a.top+(m?a.height:-p),c=a.left-p),a.scrollbar.position(c,d,h,p),a.scrollbar.setRange(a.zoomedMin/(u||1),a.zoomedMax/(u||1))),a.rendered=!0}},n.prototype.addMouseEvents=function(){var r=this,t=r.chart,o=t.container,s=[],a,l;r.mouseMoveHandler=a=function(h){r.onMouseMove(h)},r.mouseUpHandler=l=function(h){r.onMouseUp(h)},s=r.getPartsEvents("mousedown"),s.push(addEvent$F(t.renderTo,"mousemove",a),addEvent$F(o.ownerDocument,"mouseup",l)),hasTouch&&(s.push(addEvent$F(t.renderTo,"touchmove",a),addEvent$F(o.ownerDocument,"touchend",l)),s.concat(r.getPartsEvents("touchstart"))),r.eventsToUnbind=s,r.series&&r.series[0]&&s.push(addEvent$F(r.series[0].xAxis,"foundExtremes",function(){t.navigator.modifyNavigatorAxisExtremes()}))},n.prototype.getPartsEvents=function(r){var t=this,o=[];return["shades","handles"].forEach(function(s){t[s].forEach(function(a,l){o.push(addEvent$F(a.element,r,function(h){t[s+"Mousedown"](h,l)}))})}),o},n.prototype.shadesMousedown=function(r,t){r=this.chart.pointer.normalize(r);var o=this,s=o.chart,a=o.xAxis,l=o.zoomedMin,h=o.left,c=o.size,d=o.range,p=r.chartX,u,f,g,v;s.inverted&&(p=r.chartY,h=o.top),t===1?(o.grabbedCenter=p,o.fixedWidth=d,o.dragOffset=p-l):(v=p-h-d/2,t===0?v=Math.max(0,v):t===2&&v+d>=c&&(v=c-d,o.reversedExtremes?(v-=d,f=o.getUnionExtremes().dataMin):u=o.getUnionExtremes().dataMax),v!==l&&(o.fixedWidth=d,g=a.navigatorAxis.toFixedRange(v,v+d,f,u),defined$s(g.min)&&s.xAxis[0].setExtremes(Math.min(g.min,g.max),Math.max(g.min,g.max),!0,null,{trigger:"navigator"})))},n.prototype.handlesMousedown=function(r,t){r=this.chart.pointer.normalize(r);var o=this,s=o.chart,a=s.xAxis[0],l=o.reversedExtremes;t===0?(o.grabbedLeft=!0,o.otherHandlePos=o.zoomedMax,o.fixedExtreme=l?a.min:a.max):(o.grabbedRight=!0,o.otherHandlePos=o.zoomedMin,o.fixedExtreme=l?a.max:a.min),s.fixedRange=null},n.prototype.onMouseMove=function(r){var t=this,o=t.chart,s=t.left,a=t.navigatorSize,l=t.range,h=t.dragOffset,c=o.inverted,d;(!r.touches||r.touches[0].pageX!==0)&&(r=o.pointer.normalize(r),d=r.chartX,c&&(s=t.top,d=r.chartY),t.grabbedLeft?(t.hasDragged=!0,t.render(0,0,d-s,t.otherHandlePos)):t.grabbedRight?(t.hasDragged=!0,t.render(0,0,t.otherHandlePos,d-s)):t.grabbedCenter&&(t.hasDragged=!0,d<h?d=h:d>a+h-l&&(d=a+h-l),t.render(0,0,d-h,d-h+l)),t.hasDragged&&t.scrollbar&&pick$X(t.scrollbar.options.liveRedraw,H.svg&&!isTouchDevice$1&&!this.chart.isBoosting)&&(r.DOMType=r.type,setTimeout(function(){t.onMouseUp(r)},0)))},n.prototype.onMouseUp=function(r){var t=this,o=t.chart,s=t.xAxis,a=t.scrollbar,l=r.DOMEvent||r,h=o.inverted,c=t.rendered&&!t.hasDragged?"animate":"attr",d,p,u,f,g,v;(t.hasDragged&&(!a||!a.hasDragged)||r.trigger==="scrollbar")&&(u=t.getUnionExtremes(),t.zoomedMin===t.otherHandlePos?f=t.fixedExtreme:t.zoomedMax===t.otherHandlePos&&(g=t.fixedExtreme),t.zoomedMax===t.size&&(g=t.reversedExtremes?u.dataMin:u.dataMax),t.zoomedMin===0&&(f=t.reversedExtremes?u.dataMax:u.dataMin),v=s.navigatorAxis.toFixedRange(t.zoomedMin,t.zoomedMax,f,g),defined$s(v.min)&&o.xAxis[0].setExtremes(Math.min(v.min,v.max),Math.max(v.min,v.max),!0,t.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:l})),r.DOMType!=="mousemove"&&r.DOMType!=="touchmove"&&(t.grabbedLeft=t.grabbedRight=t.grabbedCenter=t.fixedWidth=t.fixedExtreme=t.otherHandlePos=t.hasDragged=t.dragOffset=null),t.navigatorEnabled&&isNumber$p(t.zoomedMin)&&isNumber$p(t.zoomedMax)&&(p=Math.round(t.zoomedMin),d=Math.round(t.zoomedMax),t.shades&&t.drawMasks(p,d,h,c),t.outline&&t.drawOutline(p,d,h,c),t.navigatorOptions.handles.enabled&&Object.keys(t.handles).length===t.handles.length&&(t.drawHandle(p,0,h,c),t.drawHandle(d,1,h,c)))},n.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(r){r()}),this.eventsToUnbind=void 0),this.removeBaseSeriesEvents()},n.prototype.removeBaseSeriesEvents=function(){var r=this.baseSeries||[];this.navigatorEnabled&&r[0]&&(this.navigatorOptions.adaptToUpdatedData!==!1&&r.forEach(function(t){removeEvent$3(t,"updatedData",this.updatedDataHandler)},this),r[0].xAxis&&removeEvent$3(r[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},n.prototype.init=function(r){var t=r.options,o=t.navigator,s=o.enabled,a=t.scrollbar,l=a.enabled,h=s?o.height:0,c=l?a.height:0;this.handles=[],this.shades=[],this.chart=r,this.setBaseSeries(),this.height=h,this.scrollbarHeight=c,this.scrollbarEnabled=l,this.navigatorEnabled=s,this.navigatorOptions=o,this.scrollbarOptions=a,this.outlineHeight=h+c,this.opposite=pick$X(o.opposite,!!(!s&&r.inverted));var d=this,p=d.baseSeries,u=r.xAxis.length,f=r.yAxis.length,g=p&&p[0]&&p[0].xAxis||r.xAxis[0]||{options:{}};r.isDirtyBox=!0,d.navigatorEnabled?(d.xAxis=new Axis(r,merge$R({breaks:g.options.breaks,ordinal:g.options.ordinal},o.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:u,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},r.inverted?{offsets:[c,0,-c,0],width:h}:{offsets:[0,-c,0,c],height:h})),d.yAxis=new Axis(r,merge$R(o.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:f,isInternal:!0,reversed:pick$X(o.yAxis&&o.yAxis.reversed,r.yAxis[0]&&r.yAxis[0].reversed,!1),zoomEnabled:!1},r.inverted?{width:h}:{height:h})),p||o.series.data?d.updateNavigatorSeries(!1):r.series.length===0&&(d.unbindRedraw=addEvent$F(r,"beforeRedraw",function(){r.series.length>0&&!d.series&&(d.setBaseSeries(),d.unbindRedraw())})),d.reversedExtremes=r.inverted&&!d.xAxis.reversed||!r.inverted&&d.xAxis.reversed,d.renderElements(),d.addMouseEvents()):(d.xAxis={chart:r,navigatorAxis:{fake:!0},translate:function(v,m){var x=r.xAxis[0],y=x.getExtremes(),b=x.len-2*c,$=numExt("min",x.options.min,y.dataMin),S=numExt("max",x.options.max,y.dataMax)-$;return m?v*S/b+$:b*(v-$)/S},toPixels:function(v){return this.translate(v)},toValue:function(v){return this.translate(v,!0)}},d.xAxis.navigatorAxis.axis=d.xAxis,d.xAxis.navigatorAxis.toFixedRange=NavigatorAxis.AdditionsClass.prototype.toFixedRange.bind(d.xAxis.navigatorAxis)),r.options.scrollbar.enabled&&(r.scrollbar=d.scrollbar=new Scrollbar(r.renderer,merge$R(r.options.scrollbar,{margin:d.navigatorEnabled?0:10,vertical:r.inverted}),r),addEvent$F(d.scrollbar,"changed",function(v){var m=d.size,x=m*this.to,y=m*this.from;d.hasDragged=d.scrollbar.hasDragged,d.render(0,0,y,x),this.shouldUpdateExtremes(v.DOMType)&&setTimeout(function(){d.onMouseUp(v)})})),d.addBaseSeriesEvents(),d.addChartEvents()},n.prototype.getUnionExtremes=function(r){var t=this.chart.xAxis[0],o=this.xAxis,s=o.options,a=t.options,l;return(!r||t.dataMin!==null)&&(l={dataMin:pick$X(s&&s.min,numExt("min",a.min,t.dataMin,o.dataMin,o.min)),dataMax:pick$X(s&&s.max,numExt("max",a.max,t.dataMax,o.dataMax,o.max))}),l},n.prototype.setBaseSeries=function(r,t){var o=this.chart,s=this.baseSeries=[];r=r||o.options&&o.options.navigator.baseSeries||(o.series.length?find$c(o.series,function(a){return!a.options.isInternal}).index:0),(o.series||[]).forEach(function(a,l){!a.options.isInternal&&(a.options.showInNavigator||(l===r||a.options.id===r)&&a.options.showInNavigator!==!1)&&s.push(a)}),this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,t)},n.prototype.updateNavigatorSeries=function(r,t){var o=this,s=o.chart,a=o.baseSeries,l,h,c=o.navigatorOptions.series,d,p={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},u=o.series=(o.series||[]).filter(function(f){var g=f.baseSeries;return a.indexOf(g)<0?(g&&(removeEvent$3(g,"updatedData",o.updatedDataHandler),delete g.navigatorSeries),f.chart&&f.destroy(),!1):!0});a&&a.length&&a.forEach(function(g){var v=g.navigatorSeries,m=extend$$({color:g.color,visible:g.visible},isArray$8(c)?defaultOptions$6.navigator.series:c);if(!(v&&o.navigatorOptions.adaptToUpdatedData===!1)){p.name="Navigator "+a.length,l=g.options||{},d=l.navigatorOptions||{},m.dataLabels=splat$9(m.dataLabels),h=merge$R(l,p,m,d),h.pointRange=pick$X(m.pointRange,d.pointRange,defaultOptions$6.plotOptions[h.type||"line"].pointRange);var x=d.data||m.data;o.hasNavigatorData=o.hasNavigatorData||!!x,h.data=x||l.data&&l.data.slice(0),v&&v.options?v.update(h,t):(g.navigatorSeries=s.initSeries(h),g.navigatorSeries.baseSeries=g,u.push(g.navigatorSeries))}}),(c.data&&!(a&&a.length)||isArray$8(c))&&(o.hasNavigatorData=!1,c=splat$9(c),c.forEach(function(f,g){p.name="Navigator "+(u.length+1),h=merge$R(defaultOptions$6.navigator.series,{color:s.series[g]&&!s.series[g].options.isInternal&&s.series[g].color||s.options.colors[g]||s.options.colors[0]},p,f),h.data=f.data,h.data&&(o.hasNavigatorData=!0,u.push(s.initSeries(h)))})),r&&this.addBaseSeriesEvents()},n.prototype.addBaseSeriesEvents=function(){var r=this,t=r.baseSeries||[];t[0]&&t[0].xAxis&&t[0].eventsToUnbind.push(addEvent$F(t[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes)),t.forEach(function(o){o.eventsToUnbind.push(addEvent$F(o,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)})),o.eventsToUnbind.push(addEvent$F(o,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)})),this.navigatorOptions.adaptToUpdatedData!==!1&&o.xAxis&&o.eventsToUnbind.push(addEvent$F(o,"updatedData",this.updatedDataHandler)),o.eventsToUnbind.push(addEvent$F(o,"remove",function(){this.navigatorSeries&&(erase$1(r.series,this.navigatorSeries),defined$s(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))},this)},n.prototype.getBaseSeriesMin=function(r){return this.baseSeries.reduce(function(t,o){return Math.min(t,o.xData?o.xData[0]:t)},r)},n.prototype.modifyNavigatorAxisExtremes=function(){var r=this.xAxis,t;typeof r.getExtremes<"u"&&(t=this.getUnionExtremes(!0),t&&(t.dataMin!==r.min||t.dataMax!==r.max)&&(r.min=t.dataMin,r.max=t.dataMax))},n.prototype.modifyBaseAxisExtremes=function(){var r=this,t=r.chart.navigator,o=r.getExtremes(),s=o.min,a=o.max,l=o.dataMin,h=o.dataMax,c=a-s,d=t.stickToMin,p=t.stickToMax,u=pick$X(r.options.overscroll,0),f,g,v=t.series&&t.series[0],m=!!r.setExtremes,x=r.eventArgs&&r.eventArgs.trigger==="rangeSelectorButton";x||(d&&(g=l,f=g+c),p&&(f=h+u,d||(g=Math.max(l,f-c,t.getBaseSeriesMin(v&&v.xData?v.xData[0]:-Number.MAX_VALUE)))),m&&(d||p)&&isNumber$p(g)&&(r.min=r.userMin=g,r.max=r.userMax=f)),t.stickToMin=t.stickToMax=null},n.prototype.updatedDataHandler=function(){var r=this.chart.navigator,t=this,o=this.navigatorSeries;r.stickToMax=r.reversedExtremes?Math.round(r.zoomedMin)===0:Math.round(r.zoomedMax)>=Math.round(r.size),r.stickToMin=r.shouldStickToMin(t,r),o&&!r.hasNavigatorData&&(o.options.pointStart=t.xData[0],o.setData(t.options.data,!1,null,!1))},n.prototype.shouldStickToMin=function(r,t){var o=t.getBaseSeriesMin(r.xData[0]),s=r.xAxis,a=s.max,l=s.min,h=s.options.range,c=!0;return isNumber$p(a)&&isNumber$p(l)?h&&a-o>0?c=a-o<h&&!this.chart.fixedRange:c=l<=o:c=!1,c},n.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]),this.eventsToUnbind.push(addEvent$F(this.chart,"redraw",function(){var r=this.navigator,t=r&&(r.baseSeries&&r.baseSeries[0]&&r.baseSeries[0].xAxis||this.xAxis[0]);t&&r.render(t.min,t.max)}),addEvent$F(this.chart,"getMargins",function(){var r=this,t=r.navigator,o=t.opposite?"plotTop":"marginBottom";r.inverted&&(o=t.opposite?"marginRight":"plotLeft"),r[o]=(r[o]||0)+(t.navigatorEnabled||!r.inverted?t.outlineHeight:0)+t.navigatorOptions.margin}))},n.prototype.destroy=function(){this.removeEvents(),this.xAxis&&(erase$1(this.chart.xAxis,this.xAxis),erase$1(this.chart.axes,this.xAxis)),this.yAxis&&(erase$1(this.chart.yAxis,this.yAxis),erase$1(this.chart.axes,this.yAxis)),(this.series||[]).forEach(function(r){r.destroy&&r.destroy()}),["series","xAxis","yAxis","shades","outline","scrollbarTrack","scrollbarRifles","scrollbarGroup","scrollbar","navigatorGroup","rendered"].forEach(function(r){this[r]&&this[r].destroy&&this[r].destroy(),this[r]=null},this),[this.handles].forEach(function(r){destroyObjectProperties$2(r)},this)},n}();H.Navigator||(H.Navigator=Navigator,NavigatorAxis.compose(Axis),addEvent$F(Chart$1,"beforeShowResetZoom",function(){var n=this.options,r=n.navigator,t=n.rangeSelector;if((r&&r.enabled||t&&t.enabled)&&(!isTouchDevice$1&&n.chart.zoomType==="x"||isTouchDevice$1&&n.chart.pinchType==="x"))return!1}),addEvent$F(Chart$1,"beforeRender",function(){var n=this.options;(n.navigator.enabled||n.scrollbar.enabled)&&(this.scroller=this.navigator=new Navigator(this))}),addEvent$F(Chart$1,"afterSetChartSize",function(){var n=this.legend,r=this.navigator,t,o,s,a;r&&(o=n&&n.options,s=r.xAxis,a=r.yAxis,t=r.scrollbarHeight,this.inverted?(r.left=r.opposite?this.chartWidth-t-r.height:this.spacing[3]+t,r.top=this.plotTop+t):(r.left=pick$X(s.left,this.plotLeft+t),r.top=r.navigatorOptions.top||this.chartHeight-r.height-t-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(o&&o.verticalAlign==="bottom"&&o.layout!=="proximate"&&o.enabled&&!o.floating?n.legendHeight+pick$X(o.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0)),s&&a&&(this.inverted?s.options.left=a.options.left=r.left:s.options.top=a.options.top=r.top,s.setAxisSize(),a.setAxisSize()))}),addEvent$F(Chart$1,"update",function(n){var r=n.options.navigator||{},t=n.options.scrollbar||{};!this.navigator&&!this.scroller&&(r.enabled||t.enabled)&&(merge$R(!0,this.options.navigator,r),merge$R(!0,this.options.scrollbar,t),delete n.options.navigator,delete n.options.scrollbar)}),addEvent$F(Chart$1,"afterUpdate",function(n){!this.navigator&&!this.scroller&&(this.options.navigator.enabled||this.options.scrollbar.enabled)&&(this.scroller=this.navigator=new Navigator(this),pick$X(n.redraw,!0)&&this.redraw(n.animation))}),addEvent$F(Chart$1,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),addEvent$F(Series$e,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}),Chart$1.prototype.callbacks.push(function(n){var r,t=n.navigator;t&&n.xAxis[0]&&(r=n.xAxis[0].getExtremes(),t.render(r.min,r.max))}));H.Navigator=Navigator;H.Navigator;var defaultOptions$5=DefaultOptions.defaultOptions,addEvent$E=Utilities.addEvent,createElement$3=Utilities.createElement,css$2=Utilities.css,defined$r=Utilities.defined,destroyObjectProperties$1=Utilities.destroyObjectProperties,discardElement$2=Utilities.discardElement,extend$_=Utilities.extend,find$b=Utilities.find,fireEvent$j=Utilities.fireEvent,isNumber$o=Utilities.isNumber,merge$Q=Utilities.merge,objectEach$d=Utilities.objectEach,pad=Utilities.pad,pick$W=Utilities.pick,pInt$3=Utilities.pInt,splat$8=Utilities.splat;extend$_(defaultOptions$5,{rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%b %e, %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:palette.highlightColor80,cursor:"pointer"},labelStyle:{color:palette.neutralColor60}}});extend$_(defaultOptions$5.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"→"});var RangeSelector=function(){function n(r){this.buttons=void 0,this.buttonOptions=n.prototype.defaultButtons,this.initialButtonGroupWidth=0,this.options=void 0,this.chart=r,this.init(r)}return n.prototype.clickButton=function(r,t){var o=this,s=o.chart,a=o.buttonOptions[r],l=s.xAxis[0],h=s.scroller&&s.scroller.getUnionExtremes()||l||{},c=h.dataMin,d=h.dataMax,p,u=l&&Math.round(Math.min(l.max,pick$W(d,l.max))),f=a.type,g,v=a._range,m,x,y,b,$,S=a.dataGrouping;if(!(c===null||d===null)){if(s.fixedRange=v,o.setSelected(r),S&&(this.forcedDataGrouping=!0,Axis.prototype.setDataGrouping.call(l||{chart:this.chart},S,!1),this.frozenStates=a.preserveDataGrouping),f==="month"||f==="year")l?(b={range:a,max:u,chart:s,dataMin:c,dataMax:d},p=l.minFromRange.call(b),isNumber$o(b.newMax)&&(u=b.newMax)):v=a;else if(v)p=Math.max(u-v,c),u=Math.min(p+v,d);else if(f==="ytd")if(l)typeof d>"u"&&(c=Number.MAX_VALUE,d=Number.MIN_VALUE,s.series.forEach(function(k){var A=k.xData;c=Math.min(A[0],c),d=Math.max(A[A.length-1],d)}),t=!1),$=o.getYTDExtremes(d,c,s.time.useUTC),p=m=$.min,u=$.max;else{o.deferredYTDClick=r;return}else f==="all"&&l&&(s.navigator&&s.navigator.baseSeries[0]&&(s.navigator.baseSeries[0].xAxis.options.range=void 0),p=c,u=d);defined$r(p)&&(p+=a._offsetMin),defined$r(u)&&(u+=a._offsetMax),this.dropdown&&(this.dropdown.selectedIndex=r+1),l?l.setExtremes(p,u,pick$W(t,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:a}):(g=splat$8(s.options.xAxis)[0],y=g.range,g.range=v,x=g.min,g.min=m,addEvent$E(s,"load",function(){g.range=y,g.min=x})),fireEvent$j(this,"afterBtnClick")}},n.prototype.setSelected=function(r){this.selected=this.options.selected=r},n.prototype.init=function(r){var t=this,o=r.options.rangeSelector,s=o.buttons||t.defaultButtons.slice(),a=o.selected,l=function(){var h=t.minInput,c=t.maxInput;h&&h.blur&&fireEvent$j(h,"blur"),c&&c.blur&&fireEvent$j(c,"blur")};t.chart=r,t.options=o,t.buttons=[],t.buttonOptions=s,this.eventsToUnbind=[],this.eventsToUnbind.push(addEvent$E(r.container,"mousedown",l)),this.eventsToUnbind.push(addEvent$E(r,"resize",l)),s.forEach(t.computeButtonRange),typeof a<"u"&&s[a]&&this.clickButton(a,!1),this.eventsToUnbind.push(addEvent$E(r,"load",function(){r.xAxis&&r.xAxis[0]&&addEvent$E(r.xAxis[0],"setExtremes",function(h){this.max-this.min!==r.fixedRange&&h.trigger!=="rangeSelectorButton"&&h.trigger!=="updatedData"&&t.forcedDataGrouping&&!t.frozenStates&&this.setDataGrouping(!1,!1)})}))},n.prototype.updateButtonStates=function(){var r=this,t=this.chart,o=this.dropdown,s=t.xAxis[0],a=Math.round(s.max-s.min),l=!s.hasVisibleSeries,h=24*36e5,c=t.scroller&&t.scroller.getUnionExtremes()||s,d=c.dataMin,p=c.dataMax,u=r.getYTDExtremes(p,d,t.time.useUTC),f=u.min,g=u.max,v=r.selected,m=isNumber$o(v),x=r.options.allButtonsEnabled,y=r.buttons;r.buttonOptions.forEach(function(b,$){var S=b._range,k=b.type,A=b.count||1,P=y[$],E=0,M,T,O=b._offsetMax-b._offsetMin,L=$===v,C=S>p-d,U=S<s.minRange,D=!1,N=!1,I=S===a;(k==="month"||k==="year")&&a+36e5>={month:28,year:365}[k]*h*A-O&&a-36e5<={month:31,year:366}[k]*h*A+O?I=!0:k==="ytd"?(I=g-f+O===a,D=!L):k==="all"&&(I=s.max-s.min>=p-d,N=!L&&m&&I),M=!x&&(C||U||N||l),T=L&&I||I&&!m&&!D||L&&r.frozenStates,M?E=3:T&&(m=!0,E=2),P.state!==E&&(P.setState(E),o&&(o.options[$+1].disabled=M,E===2&&(o.selectedIndex=$+1)),E===0&&v===$&&r.setSelected())})},n.prototype.computeButtonRange=function(r){var t=r.type,o=r.count||1,s={millisecond:1,second:1e3,minute:60*1e3,hour:3600*1e3,day:24*3600*1e3,week:7*24*3600*1e3};s[t]?r._range=s[t]*o:(t==="month"||t==="year")&&(r._range={month:30,year:365}[t]*24*36e5*o),r._offsetMin=pick$W(r.offsetMin,0),r._offsetMax=pick$W(r.offsetMax,0),r._range+=r._offsetMax-r._offsetMin},n.prototype.getInputValue=function(r){var t=r==="min"?this.minInput:this.maxInput,o=this.chart.options.rangeSelector,s=this.chart.time;return t?(t.type==="text"&&o.inputDateParser||this.defaultInputDateParser)(t.value,s.useUTC,s):0},n.prototype.setInputValue=function(r,t){var o=this.options,s=this.chart.time,a=r==="min"?this.minInput:this.maxInput,l=r==="min"?this.minDateBox:this.maxDateBox;if(a){var h=a.getAttribute("data-hc-time"),c=defined$r(h)?Number(h):void 0;if(defined$r(t)){var d=c;defined$r(d)&&a.setAttribute("data-hc-time-previous",d),a.setAttribute("data-hc-time",t),c=t}a.value=s.dateFormat(this.inputTypeFormats[a.type]||o.inputEditDateFormat,c),l&&l.attr({text:s.dateFormat(o.inputDateFormat,c)})}},n.prototype.setInputExtremes=function(r,t,o){var s=r==="min"?this.minInput:this.maxInput;if(s){var a=this.inputTypeFormats[s.type],l=this.chart.time;if(a){var h=l.dateFormat(a,t);s.min!==h&&(s.min=h);var c=l.dateFormat(a,o);s.max!==c&&(s.max=c)}}},n.prototype.showInput=function(r){var t=r==="min"?this.minDateBox:this.maxDateBox,o=r==="min"?this.minInput:this.maxInput;if(o&&t&&this.inputGroup){var s=o.type==="text",a=this.inputGroup,l=a.translateX,h=a.translateY,c=this.options.inputBoxWidth;css$2(o,{width:s?t.width+(c?-2:20)+"px":"auto",height:s?t.height-2+"px":"auto",border:"2px solid silver"}),s&&c?css$2(o,{left:l+t.x+"px",top:h+"px"}):css$2(o,{left:Math.min(Math.round(t.x+l-(o.offsetWidth-t.width)/2),this.chart.chartWidth-o.offsetWidth)+"px",top:h-(o.offsetHeight-t.height)/2+"px"})}},n.prototype.hideInput=function(r){var t=r==="min"?this.minInput:this.maxInput;t&&css$2(t,{top:"-9999em",border:0,width:"1px",height:"1px"})},n.prototype.defaultInputDateParser=function(r,t,o){var s=function(d){return d.length>6&&(d.lastIndexOf("-")===d.length-6||d.lastIndexOf("+")===d.length-6)},a=r.split("/").join("-").split(" ").join("T");if(a.indexOf("T")===-1&&(a+="T00:00"),t)a+="Z";else if(H.isSafari&&!s(a)){var l=new Date(a).getTimezoneOffset()/60;a+=l<=0?"+"+pad(-l)+":00":"-"+pad(l)+":00"}var h=Date.parse(a);if(!isNumber$o(h)){var c=r.split("-");h=Date.UTC(pInt$3(c[0]),pInt$3(c[1])-1,pInt$3(c[2]))}return o&&t&&isNumber$o(h)&&(h+=o.getTimezoneOffset(h)),h},n.prototype.drawInput=function(r){var t=this,o=t.chart,s=t.div,a=t.inputGroup,l=this,h=o.renderer.style||{},c=o.renderer,d=o.options.rangeSelector,p=defaultOptions$5.lang,u=r==="min";function f(){var b=l.getInputValue(r),$=o.xAxis[0],S=o.scroller&&o.scroller.xAxis?o.scroller.xAxis:$,k=S.dataMin,A=S.dataMax,P=l.maxInput,E=l.minInput;b!==Number(x.getAttribute("data-hc-time-previous"))&&isNumber$o(b)&&(x.setAttribute("data-hc-time-previous",b),u&&P&&isNumber$o(k)?b>Number(P.getAttribute("data-hc-time"))?b=void 0:b<k&&(b=k):E&&isNumber$o(A)&&(b<Number(E.getAttribute("data-hc-time"))?b=void 0:b>A&&(b=A)),typeof b<"u"&&$.setExtremes(u?b:$.min,u?$.max:b,void 0,void 0,{trigger:"rangeSelectorInput"}))}var g=p[u?"rangeSelectorFrom":"rangeSelectorTo"]||"",v=c.label(g,0).addClass("highcharts-range-label").attr({padding:g?2:0,height:g?d.inputBoxHeight:0}).add(a),m=c.label("",0).addClass("highcharts-range-input").attr({padding:2,width:d.inputBoxWidth,height:d.inputBoxHeight,"text-align":"center"}).on("click",function(){l.showInput(r),l[r+"Input"].focus()});o.styledMode||m.attr({stroke:d.inputBoxBorderColor,"stroke-width":1}),m.add(a);var x=createElement$3("input",{name:r,className:"highcharts-range-selector"},void 0,s);x.setAttribute("type",preferredInputType(d.inputDateFormat||"%b %e, %Y")),o.styledMode||(v.css(merge$Q(h,d.labelStyle)),m.css(merge$Q({color:palette.neutralColor80},h,d.inputStyle)),css$2(x,extend$_({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:h.fontSize,fontFamily:h.fontFamily,top:"-9999em"},d.inputStyle))),x.onfocus=function(){l.showInput(r)},x.onblur=function(){x===H.doc.activeElement&&f(),l.hideInput(r),l.setInputValue(r),x.blur()};var y=!1;return x.onchange=function(){y||(f(),l.hideInput(r),x.blur())},x.onkeypress=function(b){b.keyCode===13&&f()},x.onkeydown=function(b){y=!0,(b.keyCode===38||b.keyCode===40)&&f()},x.onkeyup=function(){y=!1},{dateBox:m,input:x,label:v}},n.prototype.getPosition=function(){var r=this.chart,t=r.options.rangeSelector,o=t.verticalAlign==="top"?r.plotTop-r.axisOffset[0]:0;return{buttonTop:o+t.buttonPosition.y,inputTop:o+t.inputPosition.y-10}},n.prototype.getYTDExtremes=function(r,t,o){var s=this.chart.time,a,l=new s.Date(r),h=s.get("FullYear",l),c=o?s.Date.UTC(h,0,1):+new s.Date(h,0,1);a=Math.max(t,c);var d=l.getTime();return{max:Math.min(r||d,d),min:a}},n.prototype.render=function(r,t){var o=this.chart,s=o.renderer,a=o.container,l=o.options,h=l.rangeSelector,c=pick$W(l.chart.style&&l.chart.style.zIndex,0)+1,d=h.inputEnabled,p=this.rendered;if(h.enabled!==!1){if(!p&&(this.group=s.g("range-selector-group").attr({zIndex:7}).add(),this.div=createElement$3("div",void 0,{position:"relative",height:0,zIndex:c}),this.buttonOptions.length&&this.renderButtons(),a.parentNode&&a.parentNode.insertBefore(this.div,a),d)){this.inputGroup=s.g("input-group").add(this.group);var u=this.drawInput("min");this.minDateBox=u.dateBox,this.minLabel=u.label,this.minInput=u.input;var f=this.drawInput("max");this.maxDateBox=f.dateBox,this.maxLabel=f.label,this.maxInput=f.input}if(d){this.setInputValue("min",r),this.setInputValue("max",t);var g=o.scroller&&o.scroller.getUnionExtremes()||o.xAxis[0]||{};if(defined$r(g.dataMin)&&defined$r(g.dataMax)){var v=o.xAxis[0].minRange||0;this.setInputExtremes("min",g.dataMin,Math.min(g.dataMax,this.getInputValue("max"))-v),this.setInputExtremes("max",Math.max(g.dataMin,this.getInputValue("min"))+v,g.dataMax)}if(this.inputGroup){var m=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(x){if(x){var y=x.getBBox().width;y&&(x.attr({x:m}),m+=y+h.inputSpacing)}})}}this.alignElements(),this.rendered=!0}},n.prototype.renderButtons=function(){var r=this,t=this,o=t.buttons,s=t.chart,a=t.options,l=defaultOptions$5.lang,h=s.renderer,c=merge$Q(a.buttonTheme),d=c&&c.states,p=c.width||28;delete c.width,delete c.states,this.buttonGroup=h.g("range-selector-buttons").add(this.group);var u=this.dropdown=createElement$3("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:1e-4},this.div);addEvent$E(u,"touchstart",function(){u.style.fontSize="16px"}),[[H.isMS?"mouseover":"mouseenter"],[H.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(f){var g=f[0],v=f[1];addEvent$E(u,g,function(){var m=o[r.currentButtonIndex()];m&&fireEvent$j(m.element,v||g)})}),this.zoomText=h.label(l&&l.rangeSelectorZoom||"",0).attr({padding:a.buttonTheme.padding,height:a.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup),this.chart.styledMode||(this.zoomText.css(a.labelStyle),c["stroke-width"]=pick$W(c["stroke-width"],0)),createElement$3("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,u),this.buttonOptions.forEach(function(f,g){createElement$3("option",{textContent:f.title||f.text},void 0,u),o[g]=h.button(f.text,0,0,function(v){var m=f.events&&f.events.click,x;m&&(x=m.call(f,v)),x!==!1&&r.clickButton(g),r.isActive=!0},c,d&&d.hover,d&&d.select,d&&d.disabled).attr({"text-align":"center",width:p}).add(r.buttonGroup),f.title&&o[g].attr("title",f.title)})},n.prototype.alignElements=function(){var r=this,t=this,o=t.buttonGroup,s=t.buttons,a=t.chart,l=t.group,h=t.inputGroup,c=t.options,d=t.zoomText,p=a.options,u=p.exporting&&p.exporting.enabled!==!1&&p.navigation&&p.navigation.buttonOptions,f=c.buttonPosition,g=c.inputPosition,v=c.verticalAlign,m=function(U,D){return u&&r.titleCollision(a)&&v==="top"&&D.align==="right"&&D.y-U.getBBox().height-12<(u.y||0)+(u.height||0)+a.spacing[0]?-40:0},x=a.plotLeft;if(l&&f&&g){var y=f.x-a.spacing[3];if(o){if(this.positionButtons(),!this.initialButtonGroupWidth){var b=0;d&&(b+=d.getBBox().width+5),s.forEach(function(U,D){b+=U.width,D!==s.length-1&&(b+=c.buttonSpacing)}),this.initialButtonGroupWidth=b}x-=a.spacing[3],this.updateButtonStates();var $=m(o,f);this.alignButtonGroup($),l.placed=o.placed=a.hasLoaded}var S=0;h&&(S=m(h,g),g.align==="left"?y=x:g.align==="right"&&(y=-Math.max(a.axisOffset[1],-S)),h.align({y:g.y,width:h.getBBox().width,align:g.align,x:g.x+y-2},!0,a.spacingBox),h.placed=a.hasLoaded),this.handleCollision(S),l.align({verticalAlign:v},!0,a.spacingBox);var k=l.alignAttr.translateY,A=l.getBBox().height+20,P=0;if(v==="bottom"){var E=a.legend&&a.legend.options,M=E&&E.verticalAlign==="bottom"&&E.enabled&&!E.floating?a.legend.legendHeight+pick$W(E.margin,10):0;A=A+M-20,P=k-A-(c.floating?0:c.y)-(a.titleOffset?a.titleOffset[2]:0)-10}v==="top"?(c.floating&&(P=0),a.titleOffset&&a.titleOffset[0]&&(P=a.titleOffset[0]),P+=a.margin[0]-a.spacing[0]||0):v==="middle"&&(g.y===f.y?P=k:(g.y||f.y)&&(g.y<0||f.y<0?P-=Math.min(g.y,f.y):P=k-A)),l.translate(c.x,c.y+Math.floor(P));var T=this,O=T.minInput,L=T.maxInput,C=T.dropdown;c.inputEnabled&&O&&L&&(O.style.marginTop=l.translateY+"px",L.style.marginTop=l.translateY+"px"),C&&(C.style.marginTop=l.translateY+"px")}},n.prototype.alignButtonGroup=function(r,t){var o=this,s=o.chart,a=o.options,l=o.buttonGroup;o.buttons;var h=a.buttonPosition,c=s.plotLeft-s.spacing[3],d=h.x-s.spacing[3];h.align==="right"?d+=r-c:h.align==="center"&&(d-=c/2),l&&l.align({y:h.y,width:pick$W(t,this.initialButtonGroupWidth),align:h.align,x:d},!0,s.spacingBox)},n.prototype.positionButtons=function(){var r=this,t=r.buttons,o=r.chart,s=r.options,a=r.zoomText,l=o.hasLoaded?"animate":"attr",h=s.buttonPosition,c=o.plotLeft,d=c;a&&a.visibility!=="hidden"&&(a[l]({x:pick$W(c+h.x,c)}),d+=h.x+a.getBBox().width+5),this.buttonOptions.forEach(function(p,u){t[u].visibility!=="hidden"?(t[u][l]({x:d}),d+=t[u].width+s.buttonSpacing):t[u][l]({x:c})})},n.prototype.handleCollision=function(r){var t=this,o=this,s=o.chart,a=o.buttonGroup,l=o.inputGroup,h=this.options,c=h.buttonPosition,d=h.dropdown,p=h.inputPosition,u=function(){var v=0;return t.buttons.forEach(function(m){var x=m.getBBox();x.width>v&&(v=x.width)}),v},f=function(v){if(l&&a){var m=l.alignAttr.translateX+l.alignOptions.x-r+l.getBBox().x+2,x=l.alignOptions.width,y=a.alignAttr.translateX+a.getBBox().x;return y+v>m&&m+x>y&&c.y<p.y+l.getBBox().height}return!1},g=function(){l&&a&&l.attr({translateX:l.alignAttr.translateX+(s.axisOffset[1]>=-r?0:-r),translateY:l.alignAttr.translateY+a.getBBox().height+10})};if(a){if(d==="always"){this.collapseButtons(r),f(u())&&g();return}d==="never"&&this.expandButtons()}l&&a?p.align===c.align||f(this.initialButtonGroupWidth+20)?d==="responsive"?(this.collapseButtons(r),f(u())&&g()):g():d==="responsive"&&this.expandButtons():a&&d==="responsive"&&(this.initialButtonGroupWidth>s.plotWidth?this.collapseButtons(r):this.expandButtons())},n.prototype.collapseButtons=function(r){var t=this,o=t.buttons,s=t.buttonOptions,a=t.chart,l=t.dropdown,h=t.options,c=t.zoomText,d=a.userOptions.rangeSelector&&a.userOptions.rangeSelector.buttonTheme||{},p=function(g){return{text:g?g+" ▾":"▾",width:"auto",paddingLeft:pick$W(h.buttonTheme.paddingLeft,d.padding,8),paddingRight:pick$W(h.buttonTheme.paddingRight,d.padding,8)}};c&&c.hide();var u=!1;s.forEach(function(g,v){var m=o[v];m.state!==2?m.hide():(m.show(),m.attr(p(g.text)),u=!0)}),u||(l&&(l.selectedIndex=0),o[0].show(),o[0].attr(p(this.zoomText&&this.zoomText.textStr)));var f=h.buttonPosition.align;this.positionButtons(),(f==="right"||f==="center")&&this.alignButtonGroup(r,o[this.currentButtonIndex()].getBBox().width),this.showDropdown()},n.prototype.expandButtons=function(){var r=this,t=r.buttons,o=r.buttonOptions,s=r.options,a=r.zoomText;this.hideDropdown(),a&&a.show(),o.forEach(function(l,h){var c=t[h];c.show(),c.attr({text:l.text,width:s.buttonTheme.width||28,paddingLeft:pick$W(s.buttonTheme.paddingLeft,"unset"),paddingRight:pick$W(s.buttonTheme.paddingRight,"unset")}),c.state<2&&c.setState(0)}),this.positionButtons()},n.prototype.currentButtonIndex=function(){var r=this.dropdown;return r&&r.selectedIndex>0?r.selectedIndex-1:0},n.prototype.showDropdown=function(){var r=this,t=r.buttonGroup,o=r.buttons,s=r.chart,a=r.dropdown;if(t&&a){var l=t.translateX,h=t.translateY,c=o[this.currentButtonIndex()].getBBox();css$2(a,{left:s.plotLeft+l+"px",top:h+.5+"px",width:c.width+"px",height:c.height+"px"}),this.hasVisibleDropdown=!0}},n.prototype.hideDropdown=function(){var r=this.dropdown;r&&(css$2(r,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)},n.prototype.getHeight=function(){var r=this,t=r.options,o=r.group,s=t.inputPosition,a=t.buttonPosition,l=t.y,h=a.y,c=s.y,d=0,p;return t.height?t.height:(this.alignElements(),d=o?o.getBBox(!0).height+13+l:0,p=Math.min(c,h),(c<0&&h<0||c>0&&h>0)&&(d+=Math.abs(p)),d)},n.prototype.titleCollision=function(r){return!(r.options.title.text||r.options.subtitle.text)},n.prototype.update=function(r){var t=this.chart;merge$Q(!0,t.options.rangeSelector,r),this.destroy(),this.init(t),this.render()},n.prototype.destroy=function(){var r=this,t=r.minInput,o=r.maxInput;r.eventsToUnbind&&(r.eventsToUnbind.forEach(function(s){return s()}),r.eventsToUnbind=void 0),destroyObjectProperties$1(r.buttons),t&&(t.onfocus=t.onblur=t.onchange=null),o&&(o.onfocus=o.onblur=o.onchange=null),objectEach$d(r,function(s,a){s&&a!=="chart"&&(s instanceof SVGElement?s.destroy():s instanceof window.HTMLElement&&discardElement$2(s)),s!==n.prototype[a]&&(r[a]=null)},this)},n}();RangeSelector.prototype.defaultButtons=[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}];RangeSelector.prototype.inputTypeFormats={"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"};function preferredInputType(n){var r=n.indexOf("%L")!==-1;if(r)return"text";var t=["a","A","d","e","w","b","B","m","o","y","Y"].some(function(s){return n.indexOf("%"+s)!==-1}),o=["H","k","I","l","M","S"].some(function(s){return n.indexOf("%"+s)!==-1});return t&&o?"datetime-local":t?"date":o?"time":"text"}Axis.prototype.minFromRange=function(){var n=this.range,r=n.type,t,o=this.max,s,a,l=this.chart.time,h=function(c,d){var p=r==="year"?"FullYear":"Month",u=new l.Date(c),f=l.get(p,u);return l.set(p,u,f+d),f===l.get(p,u)&&l.set("Date",u,0),u.getTime()-c};return isNumber$o(n)?(t=o-n,a=n):(t=o+h(o,-n.count),this.chart&&(this.chart.fixedRange=o-t)),s=pick$W(this.dataMin,Number.MIN_VALUE),isNumber$o(t)||(t=s),t<=s&&(t=s,typeof a>"u"&&(a=h(t,n.count)),this.newMax=Math.min(t+a,this.dataMax)),isNumber$o(o)||(t=void 0),t};if(!H.RangeSelector){var chartDestroyEvents_1=[],initRangeSelector_1=function(n){var r,t=n.rangeSelector,o,s,a;function l(){t&&(r=n.xAxis[0].getExtremes(),o=n.legend,a=t&&t.options.verticalAlign,isNumber$o(r.min)&&t.render(r.min,r.max),o.display&&a==="top"&&a===o.options.verticalAlign&&(s=merge$Q(n.spacingBox),o.options.layout==="vertical"?s.y=n.plotTop:s.y+=t.getHeight(),o.group.placed=!1,o.align(s)))}if(t){var h=find$b(chartDestroyEvents_1,function(c){return c[0]===n});h||chartDestroyEvents_1.push([n,[addEvent$E(n.xAxis[0],"afterSetExtremes",function(c){t&&t.render(c.min,c.max)}),addEvent$E(n,"redraw",l)]]),l()}};addEvent$E(Chart$1,"afterGetContainer",function(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new RangeSelector(this))}),addEvent$E(Chart$1,"beforeRender",function(){var n=this,r=n.axes,t=n.rangeSelector,o;t&&(isNumber$o(t.deferredYTDClick)&&(t.clickButton(t.deferredYTDClick),delete t.deferredYTDClick),r.forEach(function(s){s.updateNames(),s.setScale()}),n.getAxisMargins(),t.render(),o=t.options.verticalAlign,t.options.floating||(o==="bottom"?this.extraBottomMargin=!0:o!=="middle"&&(this.extraTopMargin=!0)))}),addEvent$E(Chart$1,"update",function(n){var r=this,t=n.options,o=t.rangeSelector,s=r.rangeSelector,a,l=this.extraBottomMargin,h=this.extraTopMargin;o&&o.enabled&&!defined$r(s)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=s=new RangeSelector(this)),this.extraBottomMargin=!1,this.extraTopMargin=!1,s&&(initRangeSelector_1(this),a=o&&o.verticalAlign||s.options&&s.options.verticalAlign,s.options.floating||(a==="bottom"?this.extraBottomMargin=!0:a!=="middle"&&(this.extraTopMargin=!0)),(this.extraBottomMargin!==l||this.extraTopMargin!==h)&&(this.isDirtyBox=!0))}),addEvent$E(Chart$1,"render",function(){var n=this,r=n.rangeSelector,t;r&&!r.options.floating&&(r.render(),t=r.options.verticalAlign,t==="bottom"?this.extraBottomMargin=!0:t!=="middle"&&(this.extraTopMargin=!0))}),addEvent$E(Chart$1,"getMargins",function(){var n=this.rangeSelector,r;n&&(r=n.getHeight(),this.extraTopMargin&&(this.plotTop+=r),this.extraBottomMargin&&(this.marginBottom+=r))}),Chart$1.prototype.callbacks.push(initRangeSelector_1),addEvent$E(Chart$1,"destroy",function(){for(var r=0;r<chartDestroyEvents_1.length;r++){var t=chartDestroyEvents_1[r];if(t[0]===this){t[1].forEach(function(o){return o()}),chartDestroyEvents_1.splice(r,1);return}}}),H.RangeSelector=RangeSelector}var __extends$G=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),animObject$4=animationExports.animObject,format$6=FormatUtilities.format,getOptions$2=DefaultOptions.getOptions,pointTooltipFormatter=Point$2.prototype.tooltipFormatter,_a$c=Series$e.prototype,seriesInit=_a$c.init,seriesProcessData=_a$c.processData,addEvent$D=Utilities.addEvent,arrayMax$4=Utilities.arrayMax,arrayMin$4=Utilities.arrayMin,clamp$9=Utilities.clamp,defined$q=Utilities.defined,extend$Z=Utilities.extend,find$a=Utilities.find,isNumber$n=Utilities.isNumber,isString$3=Utilities.isString,merge$P=Utilities.merge,pick$V=Utilities.pick,splat$7=Utilities.splat,StockChart=function(n){__extends$G(r,n);function r(){return n!==null&&n.apply(this,arguments)||this}return r.prototype.init=function(t,o){var s=getOptions$2(),a=t.xAxis,l=t.yAxis,h=pick$V(t.navigator&&t.navigator.enabled,s.navigator.enabled,!0);t.xAxis=t.yAxis=void 0;var c=merge$P({chart:{panning:{enabled:!0,type:"x"},pinchType:"x"},navigator:{enabled:h},scrollbar:{enabled:pick$V(s.scrollbar&&s.scrollbar.enabled,!0)},rangeSelector:{enabled:pick$V(s.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:pick$V(s.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},t,{isStock:!0});t.xAxis=a,t.yAxis=l,c.xAxis=splat$7(t.xAxis||{}).map(function(d,p){return merge$P(getDefaultAxisOptions("xAxis",d),s.xAxis,s.xAxis&&s.xAxis[p],d,getForcedAxisOptions("xAxis",t))}),c.yAxis=splat$7(t.yAxis||{}).map(function(d,p){return merge$P(getDefaultAxisOptions("yAxis",d),s.yAxis,s.yAxis&&s.yAxis[p],d)}),n.prototype.init.call(this,c,o)},r.prototype.createAxis=function(t,o){return o.axis=merge$P(getDefaultAxisOptions(t,o.axis),o.axis,getForcedAxisOptions(t,this.userOptions)),n.prototype.createAxis.call(this,t,o)},r}(Chart$1);(function(n){function r(t,o,s){return new n(t,o,s)}n.stockChart=r})(StockChart||(StockChart={}));function getDefaultAxisOptions(n,r){return n==="xAxis"?{minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0}:n==="yAxis"?{labels:{y:-2},opposite:pick$V(r.opposite,!0),showLastLabel:!!(r.categories||r.type==="category"),title:{text:null}}:{}}function getForcedAxisOptions(n,r){if(n==="xAxis"){var t=getOptions$2(),o=pick$V(r.navigator&&r.navigator.enabled,t.navigator.enabled,!0),s={type:"datetime",categories:void 0};return o&&(s.startOnTick=!1,s.endOnTick=!1),s}return{}}addEvent$D(Series$e,"setOptions",function(n){var r;this.chart.options.isStock&&(this.is("column")||this.is("columnrange")?r={borderWidth:0,shadow:!1}:!this.is("scatter")&&!this.is("sma")&&(r={marker:{enabled:!1,radius:2}}),r&&(n.plotOptions[this.type]=merge$P(n.plotOptions[this.type],r)))});addEvent$D(Axis,"autoLabelAlign",function(n){var r=this.chart,t=this.options,o=r._labelPanes=r._labelPanes||{},s,a=this.options.labels;this.chart.options.isStock&&this.coll==="yAxis"&&(s=t.top+","+t.height,!o[s]&&a.enabled&&(a.x===15&&(a.x=0),typeof a.align>"u"&&(a.align="right"),o[s]=this,n.align="right",n.preventDefault()))});addEvent$D(Axis,"destroy",function(){var n=this.chart,r=this.options&&this.options.top+","+this.options.height;r&&n._labelPanes&&n._labelPanes[r]===this&&delete n._labelPanes[r]});addEvent$D(Axis,"getPlotLinePath",function(n){var r=this,t=this.isLinked&&!this.series?this.linkedParent.series:this.series,o=r.chart,s=o.renderer,a=r.left,l=r.top,h,c,d,p,u=[],f=[],g,v,m=n.translatedValue,x=n.value,y=n.force,b;function $(S){var k=S==="xAxis"?"yAxis":"xAxis",A=r.options[k];return isNumber$n(A)?[o[k][A]]:isString$3(A)?[o.get(A)]:t.map(function(P){return P[k]})}(o.options.isStock&&n.acrossPanes!==!1&&r.coll==="xAxis"||r.coll==="yAxis")&&(n.preventDefault(),f=$(r.coll),g=r.isXAxis?o.yAxis:o.xAxis,g.forEach(function(S){if(!defined$q(S.options.id)||S.options.id.indexOf("navigator")===-1){var k=S.isXAxis?"yAxis":"xAxis",A=defined$q(S.options[k])?o[k][S.options[k]]:o[k][0];r===A&&f.push(S)}}),v=f.length?[]:[r.isXAxis?o.yAxis[0]:o.xAxis[0]],f.forEach(function(S){v.indexOf(S)===-1&&!find$a(v,function(k){return k.pos===S.pos&&k.len===S.len})&&v.push(S)}),b=pick$V(m,r.translate(x,null,null,n.old)),isNumber$n(b)&&(r.horiz?v.forEach(function(S){var k;c=S.pos,p=c+S.len,h=d=Math.round(b+r.transB),y!=="pass"&&(h<a||h>a+r.width)&&(y?h=d=clamp$9(h,a,a+r.width):k=!0),k||u.push(["M",h,c],["L",d,p])}):v.forEach(function(S){var k;h=S.pos,d=h+S.len,c=p=Math.round(l+r.height-b),y!=="pass"&&(c<l||c>l+r.height)&&(y?c=p=clamp$9(c,l,l+r.height):k=!0),k||u.push(["M",h,c],["L",d,p])})),n.path=u.length>0?s.crispPolyLine(u,n.lineWidth||1):null)});SVGRenderer.prototype.crispPolyLine=function(n,r){for(var t=0;t<n.length;t=t+2){var o=n[t],s=n[t+1];o[1]===s[1]&&(o[1]=s[1]=Math.round(o[1])-r%2/2),o[2]===s[2]&&(o[2]=s[2]=Math.round(o[2])+r%2/2)}return n};addEvent$D(Axis,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});addEvent$D(Axis,"afterDrawCrosshair",function(n){if(!(!this.crosshair||!this.crosshair.label||!this.crosshair.label.enabled||!this.cross||!isNumber$n(this.min)||!isNumber$n(this.max))){var r=this.chart,t=this.logarithmic,o=this.crosshair.label,s=this.horiz,a=this.opposite,l=this.left,h=this.top,c=this.crossLabel,d,p,u,f=o.format,g="",v,m,x=this.options.tickPosition==="inside",y=this.crosshair.snap!==!1,b=0,$=n.e||this.cross&&this.cross.e,S=n.point,k=this.min,A=this.max;t&&(k=t.lin2log(k),A=t.lin2log(A)),m=s?"center":a?this.labelAlign==="right"?"right":"left":this.labelAlign==="left"?"left":"center",c||(c=this.crossLabel=r.renderer.label("",0,void 0,o.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+(S?S.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:o.align||m,padding:pick$V(o.padding,8),r:pick$V(o.borderRadius,3),zIndex:2}).add(this.labelGroup),r.styledMode||c.attr({fill:o.backgroundColor||S&&S.series&&S.series.color||palette.neutralColor60,stroke:o.borderColor||"","stroke-width":o.borderWidth||0}).css(extend$Z({color:palette.backgroundColor,fontWeight:"normal",fontSize:"11px",textAlign:"center"},o.style||{}))),s?(d=y?(S.plotX||0)+l:$.chartX,p=h+(a?0:this.height)):(d=a?this.width+l:0,p=y?(S.plotY||0)+h:$.chartY),!f&&!o.formatter&&(this.dateTime&&(g="%b %d, %Y"),f="{value"+(g?":"+g:"")+"}");var P=y?this.isXAxis?S.x:S.y:this.toValue(s?$.chartX:$.chartY),E=S?S.series.isPointInside(S):isNumber$n(P)&&P>k&&P<A,M="";f?M=format$6(f,{value:P},r):o.formatter&&isNumber$n(P)&&(M=o.formatter.call(this,P)),c.attr({text:M,x:d,y:p,visibility:E?"visible":"hidden"}),u=c.getBBox(),isNumber$n(c.y)&&(s?(x&&!a||!x&&a)&&(p=c.y-u.height):p=c.y-u.height/2),s?v={left:l-u.x,right:l+this.width-u.x}:v={left:this.labelAlign==="left"?l:0,right:this.labelAlign==="right"?l+this.width:r.chartWidth},c.translateX<v.left&&(b=v.left-c.translateX),c.translateX+u.width>=v.right&&(b=-(c.translateX+u.width-v.right)),c.attr({x:d+b,y:p,anchorX:s?d:this.opposite?0:r.chartWidth,anchorY:s?this.opposite?r.chartHeight:0:p+u.height/2})}});Series$e.prototype.init=function(){seriesInit.apply(this,arguments),this.initCompare(this.options.compare)};Series$e.prototype.setCompare=function(n){this.initCompare(n),this.userOptions.compare=n};Series$e.prototype.initCompare=function(n){this.modifyValue=n==="value"||n==="percent"?function(r,t){var o=this.compareValue;return typeof r<"u"&&typeof o<"u"?(n==="value"?r-=o:r=100*(r/o)-(this.options.compareBase===100?0:100),t&&(t.change=r),r):0}:null,this.chart.hasRendered&&(this.isDirty=!0)};Series$e.prototype.forceCropping=function(){var n=this.chart,r=this.options,t=r.dataGrouping,o=this.allowDG!==!1&&t&&pick$V(t.enabled,n.options.isStock);return o};Series$e.prototype.processData=function(n){var r=this,t,o=-1,s,a,l=r.options.compareStart===!0?0:1,h,c;if(seriesProcessData.apply(this,arguments),r.xAxis&&r.processedYData){for(s=r.processedXData,a=r.processedYData,h=a.length,r.pointArrayMap&&(o=r.pointArrayMap.indexOf(r.options.pointValKey||r.pointValKey||"y")),t=0;t<h-l;t++)if(c=a[t]&&o>-1?a[t][o]:a[t],isNumber$n(c)&&s[t+l]>=r.xAxis.min&&c!==0){r.compareValue=c;break}}};addEvent$D(Series$e,"afterGetExtremes",function(n){var r=n.dataExtremes;if(this.modifyValue&&r){var t=[this.modifyValue(r.dataMin),this.modifyValue(r.dataMax)];r.dataMin=arrayMin$4(t),r.dataMax=arrayMax$4(t)}});Axis.prototype.setCompare=function(n,r){this.isXAxis||(this.series.forEach(function(t){t.setCompare(n)}),pick$V(r,!0)&&this.chart.redraw())};Point$2.prototype.tooltipFormatter=function(n){var r=this,t=r.series.chart.numberFormatter;return n=n.replace("{point.change}",(r.change>0?"+":"")+t(r.change,pick$V(r.series.tooltipOptions.changeDecimals,2))),pointTooltipFormatter.apply(this,[n])};addEvent$D(Series$e,"render",function(){var n=this.chart,r;if(!(n.is3d&&n.is3d())&&!n.polar&&this.xAxis&&!this.xAxis.isRadial&&this.options.clip!==!1){if(r=this.yAxis.len,this.xAxis.axisLine){var t=n.plotTop+n.plotHeight-this.yAxis.pos-this.yAxis.len,o=Math.floor(this.xAxis.axisLine.strokeWidth()/2);t>=0&&(r-=Math.max(o-t,0))}if((!n.hasLoaded||!this.clipBox&&this.isDirty&&!this.isDirtyData)&&(this.clipBox=this.clipBox||merge$P(n.clipBox),this.clipBox.width=this.xAxis.len,this.clipBox.height=r),n.hasRendered){var s=animObject$4(this.options.animation),a=this.getSharedClipKey(s),l=n.sharedClips[a];if(l){l.animate({width:this.xAxis.len,height:r});var h=n.sharedClips[a+"m"];h&&h.animate({width:this.xAxis.len})}}}});addEvent$D(Chart$1,"update",function(n){var r=n.options;"scrollbar"in r&&this.navigator&&(merge$P(!0,this.options.scrollbar,r.scrollbar),this.navigator.update({},!1),delete r.scrollbar)});const StockChart$1=StockChart;/**
 * @license Highstock JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/stock
 * @requires highcharts
 *
 * Highcharts Stock as a plugin for Highcharts
 *
 * (c) 2010-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$5=H;G$5.Scrollbar=Scrollbar;G$5.StockChart=G$5.stockChart=StockChart$1.stockChart;Scrollbar.compose(G$5.Axis);OrdinalAxis$1.compose(G$5.Axis,G$5.Series,G$5.Chart);/**
 * @license Highstock JS v9.2.2 (2021-08-24)
 * @module highcharts/highstock
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */G$7.product="Highstock";var doc$f=H.doc,win$6=H.win,merge$O=Utilities.merge;function addClass$1(n,r){n.classList?n.classList.add(r):n.className.indexOf(r)<0&&(n.className+=r)}function escapeStringForHTML$1(n){return n.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#x27;").replace(/\//g,"&#x2F;")}function getElement$2(n){return doc$f.getElementById(n)}function getFakeMouseEvent$2(n){if(typeof win$6.MouseEvent=="function")return new win$6.MouseEvent(n);if(doc$f.createEvent){var r=doc$f.createEvent("MouseEvent");if(r.initMouseEvent)return r.initMouseEvent(n,!0,!0,win$6,n==="click"?1:0,0,0,0,0,!1,!1,!1,!1,0,null),r}return{type:n}}function getHeadingTagNameForElement$1(n){var r=function(a){var l=parseInt(a.slice(1),10),h=Math.min(6,l+1);return"h"+h},t=function(a){return/H[1-6]/.test(a)},o=function(a){for(var l=a;l=l.previousSibling;){var h=l.tagName||"";if(t(h))return h}return""},s=function(a){var l=o(a);if(l)return r(l);var h=a.parentElement;if(!h)return"p";var c=h.tagName;return t(c)?r(c):s(h)};return s(n)}function removeElement$5(n){n&&n.parentNode&&n.parentNode.removeChild(n)}function reverseChildNodes$1(n){for(var r=n.childNodes.length;r--;)n.appendChild(n.childNodes[r])}function setElAttrs$4(n,r){Object.keys(r).forEach(function(t){var o=r[t];o===null?n.removeAttribute(t):n.setAttribute(t,o)})}function stripHTMLTagsFromString$2(n){return typeof n=="string"?n.replace(/<\/?[^>]+(>|$)/g,""):n}function visuallyHideElement$2(n){var r={position:"absolute",width:"1px",height:"1px",overflow:"hidden",whiteSpace:"nowrap",clip:"rect(1px, 1px, 1px, 1px)",marginTop:"-3px","-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity=1)",filter:"alpha(opacity=1)",opacity:"0.01"};merge$O(!0,n.style,r)}var HTMLUtilities={addClass:addClass$1,escapeStringForHTML:escapeStringForHTML$1,getElement:getElement$2,getFakeMouseEvent:getFakeMouseEvent$2,getHeadingTagNameForElement:getHeadingTagNameForElement$1,removeElement:removeElement$5,reverseChildNodes:reverseChildNodes$1,setElAttrs:setElAttrs$4,stripHTMLTagsFromString:stripHTMLTagsFromString$2,visuallyHideElement:visuallyHideElement$2},stripHTMLTags$3=HTMLUtilities.stripHTMLTagsFromString,doc$e=H.doc,defined$p=Utilities.defined,find$9=Utilities.find,fireEvent$i=Utilities.fireEvent;function getChartTitle$5(n){return stripHTMLTags$3(n.options.title.text||n.langFormat("accessibility.defaultChartTitle",{chart:n}))}function getAxisDescription$2(n){return n&&(n.userOptions&&n.userOptions.accessibility&&n.userOptions.accessibility.description||n.axisTitle&&n.axisTitle.textStr||n.options.id||n.categories&&"categories"||n.dateTime&&"Time"||"values")}function getAxisRangeDescription$2(n){var r=n.options||{};return r.accessibility&&typeof r.accessibility.rangeDescription<"u"?r.accessibility.rangeDescription:n.categories?getCategoryAxisRangeDesc(n):n.dateTime&&(n.min===0||n.dataMin===0)?getAxisTimeLengthDesc(n):getAxisFromToDescription(n)}function getCategoryAxisRangeDesc(n){var r=n.chart;return n.dataMax&&n.dataMin?r.langFormat("accessibility.axis.rangeCategories",{chart:r,axis:n,numCategories:n.dataMax-n.dataMin+1}):""}function getAxisTimeLengthDesc(n){var r=n.chart,t={},o="Seconds";t.Seconds=((n.max||0)-(n.min||0))/1e3,t.Minutes=t.Seconds/60,t.Hours=t.Minutes/60,t.Days=t.Hours/24,["Minutes","Hours","Days"].forEach(function(a){t[a]>2&&(o=a)});var s=t[o].toFixed(o!=="Seconds"&&o!=="Minutes"?1:0);return r.langFormat("accessibility.axis.timeRange"+o,{chart:r,axis:n,range:s.replace(".0","")})}function getAxisFromToDescription(n){var r=n.chart,t=r.options&&r.options.accessibility&&r.options.accessibility.screenReaderSection.axisRangeDateFormat||"",o=function(s){return n.dateTime?r.time.dateFormat(t,n[s]):n[s]};return r.langFormat("accessibility.axis.rangeFromTo",{chart:r,axis:n,rangeFrom:o("min"),rangeTo:o("max")})}function getSeriesFirstPointElement$1(n){if(n.points&&n.points.length){var r=find$9(n.points,function(t){return!!t.graphic});return r&&r.graphic&&r.graphic.element}}function getSeriesA11yElement$1(n){var r=getSeriesFirstPointElement$1(n);return r&&r.parentNode||n.graph&&n.graph.element||n.group&&n.group.element}function unhideChartElementFromAT$7(n,r){r.setAttribute("aria-hidden",!1),!(r===n.renderTo||!r.parentNode||r.parentNode===doc$e.body)&&(Array.prototype.forEach.call(r.parentNode.childNodes,function(t){t.hasAttribute("aria-hidden")||t.setAttribute("aria-hidden",!0)}),unhideChartElementFromAT$7(n,r.parentNode))}function hideSeriesFromAT$1(n){var r=getSeriesA11yElement$1(n);r&&r.setAttribute("aria-hidden",!0)}function getSeriesFromName$1(n,r){return r?(n.series||[]).filter(function(t){return t.name===r}):n.series}function getPointFromXY$1(n,r,t){for(var o=n.length,s;o--;)if(s=find$9(n[o].points||[],function(a){return a.x===r&&a.y===t}),s)return s}function getRelativePointAxisPosition(n,r){if(!defined$p(n.dataMin)||!defined$p(n.dataMax))return 0;var t=n.toPixels(n.dataMin),o=n.toPixels(n.dataMax),s=n.coll==="xAxis"?"x":"y",a=n.toPixels(r[s]||0);return(a-t)/(o-t)}function scrollToPoint$1(n){var r=n.series.xAxis,t=n.series.yAxis,o=r&&r.scrollbar?r:t,s=o&&o.scrollbar;if(s&&defined$p(s.to)&&defined$p(s.from)){var a=s.to-s.from,l=getRelativePointAxisPosition(o,n);s.updatePosition(l-a/2,l+a/2),fireEvent$i(s,"changed",{from:s.from,to:s.to,trigger:"scrollbar",DOMEvent:null})}}var ChartUtilities={getChartTitle:getChartTitle$5,getAxisDescription:getAxisDescription$2,getAxisRangeDescription:getAxisRangeDescription$2,getPointFromXY:getPointFromXY$1,getSeriesFirstPointElement:getSeriesFirstPointElement$1,getSeriesFromName:getSeriesFromName$1,getSeriesA11yElement:getSeriesA11yElement$1,unhideChartElementFromAT:unhideChartElementFromAT$7,hideSeriesFromAT:hideSeriesFromAT$1,scrollToPoint:scrollToPoint$1},find$8=Utilities.find;function KeyboardNavigationHandler(n,r){this.chart=n,this.keyCodeMap=r.keyCodeMap||[],this.validate=r.validate,this.init=r.init,this.terminate=r.terminate,this.response={success:1,prev:2,next:3,noHandler:4,fail:5}}KeyboardNavigationHandler.prototype={run:function(n){var r=n.which||n.keyCode,t=this.response.noHandler,o=find$8(this.keyCodeMap,function(s){return s[0].indexOf(r)>-1});return o?t=o[1].call(this,r,n):r===9&&(t=this.response[n.shiftKey?"prev":"next"]),t}};var doc$d=H.doc,removeElement$4=HTMLUtilities.removeElement,extend$Y=Utilities.extend,DOMElementProvider=function(){this.elements=[]};extend$Y(DOMElementProvider.prototype,{createElement:function(){var n=doc$d.createElement.apply(doc$d,arguments);return this.elements.push(n),n},destroyCreatedElements:function(){this.elements.forEach(function(n){removeElement$4(n)}),this.elements=[]}});var addEvent$C=Utilities.addEvent,extend$X=Utilities.extend,EventProvider=function(){this.eventRemovers=[]};extend$X(EventProvider.prototype,{addEvent:function(){var n=addEvent$C.apply(H,arguments);return this.eventRemovers.push(n),n},removeAddedEvents:function(){this.eventRemovers.forEach(function(n){n()}),this.eventRemovers=[]}});var unhideChartElementFromAT$6=ChartUtilities.unhideChartElementFromAT,doc$c=H.doc,win$5=H.win,removeElement$3=HTMLUtilities.removeElement,getFakeMouseEvent$1=HTMLUtilities.getFakeMouseEvent,extend$W=Utilities.extend,fireEvent$h=Utilities.fireEvent,merge$N=Utilities.merge,functionsToOverrideByDerivedClasses={init:function(){},getKeyboardNavigation:function(){},onChartUpdate:function(){},onChartRender:function(){},destroy:function(){}};function AccessibilityComponent(){}AccessibilityComponent.prototype={initBase:function(n){this.chart=n,this.eventProvider=new EventProvider,this.domElementProvider=new DOMElementProvider,this.keyCodes={left:37,right:39,up:38,down:40,enter:13,space:32,esc:27,tab:9}},addEvent:function(){return this.eventProvider.addEvent.apply(this.eventProvider,arguments)},createElement:function(){return this.domElementProvider.createElement.apply(this.domElementProvider,arguments)},fireEventOnWrappedOrUnwrappedElement:function(n,r){var t=r.type;doc$c.createEvent&&(n.dispatchEvent||n.fireEvent)?n.dispatchEvent?n.dispatchEvent(r):n.fireEvent(t,r):fireEvent$h(n,t,r)},fakeClickEvent:function(n){if(n){var r=getFakeMouseEvent$1("click");this.fireEventOnWrappedOrUnwrappedElement(n,r)}},addProxyGroup:function(n){this.createOrUpdateProxyContainer();var r=this.createElement("div");return Object.keys(n||{}).forEach(function(t){n[t]!==null&&r.setAttribute(t,n[t])}),this.chart.a11yProxyContainer.appendChild(r),r},createOrUpdateProxyContainer:function(){var n=this.chart,r=n.renderer.box;n.a11yProxyContainer=n.a11yProxyContainer||this.createProxyContainerElement(),r.nextSibling!==n.a11yProxyContainer&&n.container.insertBefore(n.a11yProxyContainer,r.nextSibling)},createProxyContainerElement:function(){var n=doc$c.createElement("div");return n.className="highcharts-a11y-proxy-container",n},createProxyButton:function(n,r,t,o,s){var a=n.element,l=this.createElement("button"),h=merge$N({"aria-label":a.getAttribute("aria-label")},t);return Object.keys(h).forEach(function(c){h[c]!==null&&l.setAttribute(c,h[c])}),l.className="highcharts-a11y-proxy-button",n.hasClass("highcharts-no-tooltip")&&(l.className+=" highcharts-no-tooltip"),s&&this.addEvent(l,"click",s),this.setProxyButtonStyle(l),this.updateProxyButtonPosition(l,o||n),this.proxyMouseEventsForButton(a,l),r.appendChild(l),h["aria-hidden"]||unhideChartElementFromAT$6(this.chart,l),l},getElementPosition:function(n){var r=n.element,t=this.chart.renderTo;if(t&&r&&r.getBoundingClientRect){var o=r.getBoundingClientRect(),s=t.getBoundingClientRect();return{x:o.left-s.left,y:o.top-s.top,width:o.right-o.left,height:o.bottom-o.top}}return{x:0,y:0,width:1,height:1}},setProxyButtonStyle:function(n){merge$N(!0,n.style,{borderWidth:"0",backgroundColor:"transparent",cursor:"pointer",outline:"none",opacity:"0.001",filter:"alpha(opacity=1)",zIndex:"999",overflow:"hidden",padding:"0",margin:"0",display:"block",position:"absolute"}),n.style["-ms-filter"]="progid:DXImageTransform.Microsoft.Alpha(Opacity=1)"},updateProxyButtonPosition:function(n,r){var t=this.getElementPosition(r);merge$N(!0,n.style,{width:(t.width||1)+"px",height:(t.height||1)+"px",left:(Math.round(t.x)||0)+"px",top:(Math.round(t.y)||0)+"px"})},proxyMouseEventsForButton:function(n,r){var t=this;["click","touchstart","touchend","touchcancel","touchmove","mouseover","mouseenter","mouseleave","mouseout"].forEach(function(o){var s=o.indexOf("touch")===0;t.addEvent(r,o,function(a){var l=s?t.cloneTouchEvent(a):t.cloneMouseEvent(a);n&&t.fireEventOnWrappedOrUnwrappedElement(n,l),a.stopPropagation(),o!=="touchstart"&&o!=="touchmove"&&o!=="touchend"&&a.preventDefault()},{passive:!1})})},cloneMouseEvent:function(n){if(typeof win$5.MouseEvent=="function")return new win$5.MouseEvent(n.type,n);if(doc$c.createEvent){var r=doc$c.createEvent("MouseEvent");if(r.initMouseEvent)return r.initMouseEvent(n.type,n.bubbles,n.cancelable,n.view||win$5,n.detail,n.screenX,n.screenY,n.clientX,n.clientY,n.ctrlKey,n.altKey,n.shiftKey,n.metaKey,n.button,n.relatedTarget),r}return getFakeMouseEvent$1(n.type)},cloneTouchEvent:function(n){var r=function(s){for(var a=[],l=0;l<s.length;++l){var h=s.item(l);h&&a.push(h)}return a};if(typeof win$5.TouchEvent=="function"){var t=new win$5.TouchEvent(n.type,{touches:r(n.touches),targetTouches:r(n.targetTouches),changedTouches:r(n.changedTouches),ctrlKey:n.ctrlKey,shiftKey:n.shiftKey,altKey:n.altKey,metaKey:n.metaKey,bubbles:n.bubbles,cancelable:n.cancelable,composed:n.composed,detail:n.detail,view:n.view});return n.defaultPrevented&&t.preventDefault(),t}var o=this.cloneMouseEvent(n);return o.touches=n.touches,o.changedTouches=n.changedTouches,o.targetTouches=n.targetTouches,o},destroyBase:function(){removeElement$3(this.chart.a11yProxyContainer),this.domElementProvider.destroyCreatedElements(),this.eventProvider.removeAddedEvents()}};extend$W(AccessibilityComponent.prototype,functionsToOverrideByDerivedClasses);var doc$b=H.doc,win$4=H.win,addEvent$B=Utilities.addEvent,fireEvent$g=Utilities.fireEvent,getElement$1=HTMLUtilities.getElement;addEvent$B(doc$b,"keydown",function(n){var r=n.which||n.keyCode,t=27;r===t&&H.charts&&H.charts.forEach(function(o){o&&o.dismissPopupContent&&o.dismissPopupContent()})});Chart$1.prototype.dismissPopupContent=function(){var n=this;fireEvent$g(this,"dismissPopupContent",{},function(){n.tooltip&&n.tooltip.hide(0),n.hideExportMenu()})};function KeyboardNavigation(n,r){this.init(n,r)}KeyboardNavigation.prototype={init:function(n,r){var t=this,o=this.eventProvider=new EventProvider;this.chart=n,this.components=r,this.modules=[],this.currentModuleIx=0,this.update(),o.addEvent(this.tabindexContainer,"keydown",function(s){return t.onKeydown(s)}),o.addEvent(this.tabindexContainer,"focus",function(s){return t.onFocus(s)}),["mouseup","touchend"].forEach(function(s){return o.addEvent(doc$b,s,function(){return t.onMouseUp()})}),["mousedown","touchstart"].forEach(function(s){return o.addEvent(n.renderTo,s,function(){t.isClickingChart=!0})}),o.addEvent(n.renderTo,"mouseover",function(){t.pointerIsOverChart=!0}),o.addEvent(n.renderTo,"mouseout",function(){t.pointerIsOverChart=!1}),this.modules.length&&this.modules[0].init(1)},update:function(n){var r=this.chart.options.accessibility,t=r&&r.keyboardNavigation,o=this.components;this.updateContainerTabindex(),t&&t.enabled&&n&&n.length?(this.modules=n.reduce(function(s,a){var l=o[a].getKeyboardNavigation();return s.concat(l)},[]),this.updateExitAnchor()):(this.modules=[],this.currentModuleIx=0,this.removeExitAnchor())},onFocus:function(n){var r=this.chart,t=n.relatedTarget&&r.container.contains(n.relatedTarget);!this.exiting&&!this.tabbingInBackwards&&!this.isClickingChart&&!t&&this.modules[0]&&this.modules[0].init(1),this.exiting=!1},onMouseUp:function(){if(delete this.isClickingChart,!this.keyboardReset&&!this.pointerIsOverChart){var n=this.chart,r=this.modules&&this.modules[this.currentModuleIx||0];r&&r.terminate&&r.terminate(),n.focusElement&&n.focusElement.removeFocusBorder(),this.currentModuleIx=0,this.keyboardReset=!0}},onKeydown:function(n){var r=n||win$4.event,t,o=this.modules&&this.modules.length&&this.modules[this.currentModuleIx];if(this.keyboardReset=!1,this.exiting=!1,o){var s=o.run(r);s===o.response.success?t=!0:s===o.response.prev?t=this.prev():s===o.response.next&&(t=this.next()),t&&(r.preventDefault(),r.stopPropagation())}},prev:function(){return this.move(-1)},next:function(){return this.move(1)},move:function(n){var r=this.modules&&this.modules[this.currentModuleIx];r&&r.terminate&&r.terminate(n),this.chart.focusElement&&this.chart.focusElement.removeFocusBorder(),this.currentModuleIx+=n;var t=this.modules&&this.modules[this.currentModuleIx];if(t){if(t.validate&&!t.validate())return this.move(n);if(t.init)return t.init(n),!0}return this.currentModuleIx=0,this.exiting=!0,n>0?this.exitAnchor.focus():this.tabindexContainer.focus(),!1},updateExitAnchor:function(){var n="highcharts-end-of-chart-marker-"+this.chart.index,r=getElement$1(n);this.removeExitAnchor(),r?(this.makeElementAnExitAnchor(r),this.exitAnchor=r):this.createExitAnchor()},updateContainerTabindex:function(){var n=this.chart.options.accessibility,r=n&&n.keyboardNavigation,t=!(r&&r.enabled===!1),o=this.chart,s=o.container,a;o.renderTo.hasAttribute("tabindex")?(s.removeAttribute("tabindex"),a=o.renderTo):a=s,this.tabindexContainer=a;var l=a.getAttribute("tabindex");t&&!l?a.setAttribute("tabindex","0"):t||o.container.removeAttribute("tabindex")},makeElementAnExitAnchor:function(n){var r=this.tabindexContainer.getAttribute("tabindex")||0;n.setAttribute("class","highcharts-exit-anchor"),n.setAttribute("tabindex",r),n.setAttribute("aria-hidden",!1),this.addExitAnchorEventsToEl(n)},createExitAnchor:function(){var n=this.chart,r=this.exitAnchor=doc$b.createElement("div");n.renderTo.appendChild(r),this.makeElementAnExitAnchor(r)},removeExitAnchor:function(){this.exitAnchor&&this.exitAnchor.parentNode&&(this.exitAnchor.parentNode.removeChild(this.exitAnchor),delete this.exitAnchor)},addExitAnchorEventsToEl:function(n){var r=this.chart,t=this;this.eventProvider.addEvent(n,"focus",function(o){var s=o||win$4.event,a,l=s.relatedTarget&&r.container.contains(s.relatedTarget),h=!(l||t.exiting);h?(t.tabbingInBackwards=!0,t.tabindexContainer.focus(),delete t.tabbingInBackwards,s.preventDefault(),t.modules&&t.modules.length&&(t.currentModuleIx=t.modules.length-1,a=t.modules[t.currentModuleIx],a&&a.validate&&!a.validate()?t.prev():a&&a.init(-1))):t.exiting=!1})},destroy:function(){this.removeExitAnchor(),this.eventProvider.removeAddedEvents(),this.chart.container.removeAttribute("tabindex")}};var animObject$3=animationExports.animObject,addEvent$A=Utilities.addEvent,extend$V=Utilities.extend,find$7=Utilities.find,fireEvent$f=Utilities.fireEvent,isNumber$m=Utilities.isNumber,pick$U=Utilities.pick,syncTimeout$1=Utilities.syncTimeout,removeElement$2=HTMLUtilities.removeElement,stripHTMLTags$2=HTMLUtilities.stripHTMLTagsFromString,getChartTitle$4=ChartUtilities.getChartTitle;function scrollLegendToItem(n,r){var t=n.allItems[r].pageIx,o=n.currentPage;typeof t<"u"&&t+1!==o&&n.scroll(1+t-o)}function shouldDoLegendA11y(n){var r=n.legend&&n.legend.allItems,t=n.options.legend.accessibility||{};return!!(r&&r.length&&!(n.colorAxis&&n.colorAxis.length)&&t.enabled!==!1)}Chart$1.prototype.highlightLegendItem=function(n){var r=this.legend.allItems,t=this.accessibility&&this.accessibility.components.legend.highlightedLegendItemIx;return r[n]?(isNumber$m(t)&&r[t]&&fireEvent$f(r[t].legendGroup.element,"mouseout"),scrollLegendToItem(this.legend,n),this.setFocusToElement(r[n].legendItem,r[n].a11yProxyElement),fireEvent$f(r[n].legendGroup.element,"mouseover"),!0):!1};addEvent$A(Legend,"afterColorizeItem",function(n){var r=this.chart,t=r.options.accessibility,o=n.item;t.enabled&&o&&o.a11yProxyElement&&o.a11yProxyElement.setAttribute("aria-pressed",n.visible?"true":"false")});var LegendComponent=function(){};LegendComponent.prototype=new AccessibilityComponent;extend$V(LegendComponent.prototype,{init:function(){var n=this;this.proxyElementsList=[],this.recreateProxies(),this.addEvent(Legend,"afterScroll",function(){this.chart===n.chart&&(n.updateProxiesPositions(),n.updateLegendItemProxyVisibility(),this.chart.highlightLegendItem(n.highlightedLegendItemIx))}),this.addEvent(Legend,"afterPositionItem",function(r){this.chart===n.chart&&this.chart.renderer&&n.updateProxyPositionForItem(r.item)}),this.addEvent(Legend,"afterRender",function(){this.chart===n.chart&&this.chart.renderer&&n.recreateProxies()&&syncTimeout$1(function(){return n.updateProxiesPositions()},animObject$3(pick$U(this.chart.renderer.globalAnimation,!0)).duration)})},updateLegendItemProxyVisibility:function(){var n=this.chart.legend,r=n.allItems||[],t=n.currentPage||1,o=n.clipHeight||0;r.forEach(function(s){var a=s.pageIx||0,l=s._legendItemPos?s._legendItemPos[1]:0,h=s.legendItem?Math.round(s.legendItem.getBBox().height):0,c=l+h-n.pages[a]>o||a!==t-1;s.a11yProxyElement&&(s.a11yProxyElement.style.visibility=c?"hidden":"visible")})},onChartRender:function(){shouldDoLegendA11y(this.chart)||this.removeProxies()},onChartUpdate:function(){this.updateLegendTitle()},updateProxiesPositions:function(){for(var n=0,r=this.proxyElementsList;n<r.length;n++){var t=r[n],o=t.element,s=t.posElement;this.updateProxyButtonPosition(o,s)}},updateProxyPositionForItem:function(n){var r=find$7(this.proxyElementsList,function(t){return t.item===n});r&&this.updateProxyButtonPosition(r.element,r.posElement)},recreateProxies:function(){return this.removeProxies(),shouldDoLegendA11y(this.chart)?(this.addLegendProxyGroup(),this.addLegendListContainer(),this.proxyLegendItems(),this.updateLegendItemProxyVisibility(),!0):!1},removeProxies:function(){removeElement$2(this.legendProxyGroup),this.proxyElementsList=[]},updateLegendTitle:function(){var n=this.chart,r=stripHTMLTags$2((n.legend&&n.legend.options.title&&n.legend.options.title.text||"").replace(/<br ?\/?>/g," ")),t=n.langFormat("accessibility.legend.legendLabel"+(r?"":"NoTitle"),{chart:n,legendTitle:r,chartTitle:getChartTitle$4(n)});this.legendProxyGroup&&this.legendProxyGroup.setAttribute("aria-label",t)},addLegendProxyGroup:function(){var n=this.chart.options.accessibility,r=n.landmarkVerbosity==="all"?"region":null;this.legendProxyGroup=this.addProxyGroup({"aria-label":"_placeholder_",role:r})},addLegendListContainer:function(){if(this.legendProxyGroup){var n=this.legendListContainer=this.createElement("ul");n.style.listStyle="none",this.legendProxyGroup.appendChild(n)}},proxyLegendItems:function(){var n=this,r=this.chart.legend&&this.chart.legend.allItems||[];r.forEach(function(t){t.legendItem&&t.legendItem.element&&n.proxyLegendItem(t)})},proxyLegendItem:function(n){if(!(!n.legendItem||!n.legendGroup||!this.legendListContainer)){var r=this.chart.langFormat("accessibility.legend.legendItem",{chart:this.chart,itemName:stripHTMLTags$2(n.name),item:n}),t={tabindex:-1,"aria-pressed":n.visible,"aria-label":r},o=n.legendGroup.div?n.legendItem:n.legendGroup,s=this.createElement("li");this.legendListContainer.appendChild(s),n.a11yProxyElement=this.createProxyButton(n.legendItem,s,t,o),this.proxyElementsList.push({item:n,element:n.a11yProxyElement,posElement:o})}},getKeyboardNavigation:function(){var n=this.keyCodes,r=this,t=this.chart;return new KeyboardNavigationHandler(t,{keyCodeMap:[[[n.left,n.right,n.up,n.down],function(o){return r.onKbdArrowKey(this,o)}],[[n.enter,n.space],function(o){return H.isFirefox&&o===n.space?this.response.success:r.onKbdClick(this)}]],validate:function(){return r.shouldHaveLegendNavigation()},init:function(o){return r.onKbdNavigationInit(o)},terminate:function(){t.legend.allItems.forEach(function(o){return o.setState("",!0)})}})},onKbdArrowKey:function(n,r){var t=this.keyCodes,o=n.response,s=this.chart,a=s.options.accessibility,l=s.legend.allItems.length,h=r===t.left||r===t.up?-1:1,c=s.highlightLegendItem(this.highlightedLegendItemIx+h);return c?(this.highlightedLegendItemIx+=h,o.success):l>1&&a.keyboardNavigation.wrapAround?(n.init(h),o.success):o[h>0?"next":"prev"]},onKbdClick:function(n){var r=this.chart.legend.allItems[this.highlightedLegendItemIx];return r&&r.a11yProxyElement&&fireEvent$f(r.a11yProxyElement,"click"),n.response.success},shouldHaveLegendNavigation:function(){var n=this.chart,r=n.options.legend||{},t=n.legend&&n.legend.allItems,o=n.colorAxis&&n.colorAxis.length,s=r.accessibility||{};return!!(t&&n.legend.display&&!o&&s.enabled&&s.keyboardNavigation&&s.keyboardNavigation.enabled)},onKbdNavigationInit:function(n){var r=this.chart,t=r.legend.allItems.length-1,o=n>0?0:t;r.highlightLegendItem(o),this.highlightedLegendItemIx=o}});var extend$U=Utilities.extend,getChartTitle$3=ChartUtilities.getChartTitle,unhideChartElementFromAT$5=ChartUtilities.unhideChartElementFromAT,removeElement$1=HTMLUtilities.removeElement,getFakeMouseEvent=HTMLUtilities.getFakeMouseEvent;function getExportMenuButtonElement(n){return n.exportSVGElements&&n.exportSVGElements[0]}Chart$1.prototype.showExportMenu=function(){var n=getExportMenuButtonElement(this);if(n){var r=n.element;r.onclick&&r.onclick(getFakeMouseEvent("click"))}};Chart$1.prototype.hideExportMenu=function(){var n=this,r=n.exportDivElements;r&&n.exportContextMenu&&(r.forEach(function(t){t&&t.className==="highcharts-menu-item"&&t.onmouseout&&t.onmouseout(getFakeMouseEvent("mouseout"))}),n.highlightedExportItemIx=0,n.exportContextMenu.hideMenu(),n.container.focus())};Chart$1.prototype.highlightExportItem=function(n){var r=this.exportDivElements&&this.exportDivElements[n],t=this.exportDivElements&&this.exportDivElements[this.highlightedExportItemIx],o;return r&&r.tagName==="LI"&&!(r.children&&r.children.length)?(o=!!(this.renderTo.getElementsByTagName("g")[0]||{}).focus,r.focus&&o&&r.focus(),t&&t.onmouseout&&t.onmouseout(getFakeMouseEvent("mouseout")),r.onmouseover&&r.onmouseover(getFakeMouseEvent("mouseover")),this.highlightedExportItemIx=n,!0):!1};Chart$1.prototype.highlightLastExportItem=function(){var n=this,r;if(n.exportDivElements){for(r=n.exportDivElements.length;r--;)if(n.highlightExportItem(r))return!0}return!1};function exportingShouldHaveA11y(n){var r=n.options.exporting,t=getExportMenuButtonElement(n);return!!(r&&r.enabled!==!1&&r.accessibility&&r.accessibility.enabled&&t&&t.element)}var MenuComponent=function(){};MenuComponent.prototype=new AccessibilityComponent;extend$U(MenuComponent.prototype,{init:function(){var n=this.chart,r=this;this.addEvent(n,"exportMenuShown",function(){r.onMenuShown()}),this.addEvent(n,"exportMenuHidden",function(){r.onMenuHidden()})},onMenuHidden:function(){var n=this.chart.exportContextMenu;n&&n.setAttribute("aria-hidden","true"),this.isExportMenuShown=!1,this.setExportButtonExpandedState("false")},onMenuShown:function(){var n=this.chart,r=n.exportContextMenu;r&&(this.addAccessibleContextMenuAttribs(),unhideChartElementFromAT$5(n,r)),this.isExportMenuShown=!0,this.setExportButtonExpandedState("true")},setExportButtonExpandedState:function(n){var r=this.exportButtonProxy;r&&r.setAttribute("aria-expanded",n)},onChartRender:function(){var n=this.chart,r=n.options.accessibility;if(removeElement$1(this.exportProxyGroup),exportingShouldHaveA11y(n)){this.exportProxyGroup=this.addProxyGroup(r.landmarkVerbosity==="all"?{"aria-label":n.langFormat("accessibility.exporting.exportRegionLabel",{chart:n,chartTitle:getChartTitle$3(n)}),role:"region"}:{});var t=getExportMenuButtonElement(this.chart);this.exportButtonProxy=this.createProxyButton(t,this.exportProxyGroup,{"aria-label":n.langFormat("accessibility.exporting.menuButtonLabel",{chart:n}),"aria-expanded":!1})}},addAccessibleContextMenuAttribs:function(){var n=this.chart,r=n.exportDivElements;if(r&&r.length){r.forEach(function(o){o&&(o.tagName==="LI"&&!(o.children&&o.children.length)?o.setAttribute("tabindex",-1):o.setAttribute("aria-hidden","true"))});var t=r[0]&&r[0].parentNode;t&&(t.removeAttribute("aria-hidden"),t.setAttribute("aria-label",n.langFormat("accessibility.exporting.chartMenuLabel",{chart:n})))}},getKeyboardNavigation:function(){var n=this.keyCodes,r=this.chart,t=this;return new KeyboardNavigationHandler(r,{keyCodeMap:[[[n.left,n.up],function(){return t.onKbdPrevious(this)}],[[n.right,n.down],function(){return t.onKbdNext(this)}],[[n.enter,n.space],function(){return t.onKbdClick(this)}]],validate:function(){return!!r.exporting&&r.options.exporting.enabled!==!1&&r.options.exporting.accessibility.enabled!==!1},init:function(){var o=t.exportButtonProxy,s=r.exportingGroup;s&&o&&r.setFocusToElement(s,o)},terminate:function(){r.hideExportMenu()}})},onKbdPrevious:function(n){for(var r=this.chart,t=r.options.accessibility,o=n.response,s=r.highlightedExportItemIx||0;s--;)if(r.highlightExportItem(s))return o.success;return t.keyboardNavigation.wrapAround?(r.highlightLastExportItem(),o.success):o.prev},onKbdNext:function(n){for(var r=this.chart,t=r.options.accessibility,o=n.response,s=(r.highlightedExportItemIx||0)+1;s<r.exportDivElements.length;++s)if(r.highlightExportItem(s))return o.success;return t.keyboardNavigation.wrapAround?(r.highlightExportItem(0),o.success):o.next},onKbdClick:function(n){var r=this.chart,t=r.exportDivElements[r.highlightedExportItemIx],o=getExportMenuButtonElement(r).element;return this.isExportMenuShown?this.fakeClickEvent(t):(this.fakeClickEvent(o),r.highlightExportItem(0)),n.response.success}});var seriesTypes$4=SeriesRegistry$1.seriesTypes,doc$a=H.doc,defined$o=Utilities.defined,extend$T=Utilities.extend,fireEvent$e=Utilities.fireEvent,getPointFromXY=ChartUtilities.getPointFromXY,getSeriesFromName=ChartUtilities.getSeriesFromName,scrollToPoint=ChartUtilities.scrollToPoint;Series$e.prototype.keyboardMoveVertical=!0;["column","pie"].forEach(function(n){seriesTypes$4[n]&&(seriesTypes$4[n].prototype.keyboardMoveVertical=!1)});function getPointIndex(n){var r=n.index,t=n.series.points,o=t.length;if(t[r]!==n){for(;o--;)if(t[o]===n)return o}else return r}function isSkipSeries(n){var r=n.chart.options.accessibility,t=r.keyboardNavigation.seriesNavigation,o=n.options.accessibility||{},s=o.keyboardNavigation;return s&&s.enabled===!1||o.enabled===!1||n.options.enableMouseTracking===!1||!n.visible||t.pointNavigationEnabledThreshold&&t.pointNavigationEnabledThreshold<=n.points.length}function isSkipPoint(n){var r=n.series.chart.options.accessibility,t=n.options.accessibility&&n.options.accessibility.enabled===!1;return n.isNull&&r.keyboardNavigation.seriesNavigation.skipNullPoints||n.visible===!1||n.isInside===!1||t||isSkipSeries(n.series)}function getClosestPoint(n,r,t,o){var s=1/0,a,l,h,c=r.points.length,d=function(p){return!(defined$o(p.plotX)&&defined$o(p.plotY))};if(!d(n)){for(;c--;)a=r.points[c],!d(a)&&(h=(n.plotX-a.plotX)*(n.plotX-a.plotX)*(t||1)+(n.plotY-a.plotY)*(n.plotY-a.plotY)*(o||1),h<s&&(s=h,l=c));return defined$o(l)?r.points[l]:void 0}}Point$2.prototype.highlight=function(){var n=this.series.chart;return this.isNull?n.tooltip&&n.tooltip.hide(0):this.onMouseOver(),scrollToPoint(this),this.graphic&&n.setFocusToElement(this.graphic),n.highlightedPoint=this,this};Chart$1.prototype.highlightAdjacentPoint=function(n){var r=this,t=r.series,o=r.highlightedPoint,s=o&&getPointIndex(o)||0,a=o&&o.series.points,l=r.series&&r.series[r.series.length-1],h=l&&l.points&&l.points[l.points.length-1],c,d;if(!t[0]||!t[0].points)return!1;if(!o)d=n?t[0].points[0]:h;else if(c=t[o.series.index+(n?1:-1)],d=a[s+(n?1:-1)],!d&&c&&(d=c.points[n?0:c.points.length-1]),!d)return!1;return isSkipPoint(d)?(c=d.series,isSkipSeries(c)?r.highlightedPoint=n?c.points[c.points.length-1]:c.points[0]:r.highlightedPoint=d,r.highlightAdjacentPoint(n)):d.highlight()};Series$e.prototype.highlightFirstValidPoint=function(){var n=this.chart.highlightedPoint,r=(n&&n.series)===this?getPointIndex(n):0,t=this.points,o=t.length;if(t&&o){for(var s=r;s<o;++s)if(!isSkipPoint(t[s]))return t[s].highlight();for(var a=r;a>=0;--a)if(!isSkipPoint(t[a]))return t[a].highlight()}return!1};Chart$1.prototype.highlightAdjacentSeries=function(n){var r=this,t=r.highlightedPoint,o=r.series&&r.series[r.series.length-1],s=o&&o.points&&o.points[o.points.length-1],a,l,h;return r.highlightedPoint?(a=r.series[t.series.index+(n?-1:1)],!a||(l=getClosestPoint(t,a,4),!l)?!1:isSkipSeries(a)?(l.highlight(),h=r.highlightAdjacentSeries(n),h||(t.highlight(),!1)):(l.highlight(),l.series.highlightFirstValidPoint())):(a=n?r.series&&r.series[0]:o,l=n?a&&a.points&&a.points[0]:s,l?l.highlight():!1)};Chart$1.prototype.highlightAdjacentPointVertical=function(n){var r=this.highlightedPoint,t=1/0,o;return!defined$o(r.plotX)||!defined$o(r.plotY)?!1:(this.series.forEach(function(s){isSkipSeries(s)||s.points.forEach(function(a){if(!(!defined$o(a.plotY)||!defined$o(a.plotX)||a===r)){var l=a.plotY-r.plotY,h=Math.abs(a.plotX-r.plotX),c=Math.abs(l)*Math.abs(l)+h*h*4;s.yAxis&&s.yAxis.reversed&&(l*=-1),!(l<=0&&n||l>=0&&!n||c<5||isSkipPoint(a))&&c<t&&(t=c,o=a)}})}),o?o.highlight():!1)};function highlightFirstValidPointInChart(n){var r=!1;return delete n.highlightedPoint,r=n.series.reduce(function(t,o){return t||o.highlightFirstValidPoint()},!1),r}function highlightLastValidPointInChart(n){for(var r=n.series.length,t=r,o=!1;t--&&(n.highlightedPoint=n.series[t].points[n.series[t].points.length-1],o=n.series[t].highlightFirstValidPoint(),!o););return o}function updateChartFocusAfterDrilling(n){highlightFirstValidPointInChart(n),n.focusElement&&n.focusElement.removeFocusBorder()}function SeriesKeyboardNavigation(n,r){this.keyCodes=r,this.chart=n}extend$T(SeriesKeyboardNavigation.prototype,{init:function(){var n=this,r=this.chart,t=this.eventProvider=new EventProvider;t.addEvent(Series$e,"destroy",function(){return n.onSeriesDestroy(this)}),t.addEvent(r,"afterDrilldown",function(){updateChartFocusAfterDrilling(this)}),t.addEvent(r,"drilldown",function(o){var s=o.point,a=s.series;n.lastDrilledDownPoint={x:s.x,y:s.y,seriesName:a?a.name:""}}),t.addEvent(r,"drillupall",function(){setTimeout(function(){n.onDrillupAll()},10)}),t.addEvent(Point$2,"afterSetState",function(){var o=this,s=o.graphic&&o.graphic.element;r.highlightedPoint===o&&doc$a.activeElement!==s&&s&&s.focus&&s.focus()})},onDrillupAll:function(){var n=this.lastDrilledDownPoint,r=this.chart,t=n&&getSeriesFromName(r,n.seriesName),o;n&&t&&defined$o(n.x)&&defined$o(n.y)&&(o=getPointFromXY(t,n.x,n.y)),r.container&&r.container.focus(),o&&o.highlight&&o.highlight(),r.focusElement&&r.focusElement.removeFocusBorder()},getKeyboardNavigationHandler:function(){var n=this,r=this.keyCodes,t=this.chart,o=t.inverted;return new KeyboardNavigationHandler(t,{keyCodeMap:[[o?[r.up,r.down]:[r.left,r.right],function(s){return n.onKbdSideways(this,s)}],[o?[r.left,r.right]:[r.up,r.down],function(s){return n.onKbdVertical(this,s)}],[[r.enter,r.space],function(s,a){var l=t.highlightedPoint;return l&&(a.point=l,fireEvent$e(l.series,"click",a),l.firePointEvent("click")),this.response.success}]],init:function(s){return n.onHandlerInit(this,s)},terminate:function(){return n.onHandlerTerminate()}})},onKbdSideways:function(n,r){var t=this.keyCodes,o=r===t.right||r===t.down;return this.attemptHighlightAdjacentPoint(n,o)},onKbdVertical:function(n,r){var t=this.chart,o=this.keyCodes,s=r===o.down||r===o.right,a=t.options.accessibility.keyboardNavigation.seriesNavigation;if(a.mode&&a.mode==="serialize")return this.attemptHighlightAdjacentPoint(n,s);var l=t.highlightedPoint&&t.highlightedPoint.series.keyboardMoveVertical?"highlightAdjacentPointVertical":"highlightAdjacentSeries";return t[l](s),n.response.success},onHandlerInit:function(n,r){var t=this.chart;return r>0?highlightFirstValidPointInChart(t):highlightLastValidPointInChart(t),n.response.success},onHandlerTerminate:function(){var n=this.chart;n.tooltip&&n.tooltip.hide(0);var r=n.highlightedPoint&&n.highlightedPoint.series;r&&r.onMouseOut&&r.onMouseOut(),n.highlightedPoint&&n.highlightedPoint.onMouseOut&&n.highlightedPoint.onMouseOut(),delete n.highlightedPoint},attemptHighlightAdjacentPoint:function(n,r){var t=this.chart,o=t.options.accessibility.keyboardNavigation.wrapAround,s=t.highlightAdjacentPoint(r);return s?n.response.success:o?n.init(r?1:-1):n.response[r?"next":"prev"]},onSeriesDestroy:function(n){var r=this.chart,t=r.highlightedPoint&&r.highlightedPoint.series===n;t&&(delete r.highlightedPoint,r.focusElement&&r.focusElement.removeFocusBorder())},destroy:function(){this.eventProvider.removeAddedEvents()}});var escapeStringForHTML=HTMLUtilities.escapeStringForHTML,stripHTMLTagsFromString$1=HTMLUtilities.stripHTMLTagsFromString;function getChartAnnotationLabels(n){var r=n.annotations||[];return r.reduce(function(t,o){return o.options&&o.options.visible!==!1&&(t=t.concat(o.labels)),t},[])}function getLabelText(n){return n.options&&n.options.accessibility&&n.options.accessibility.description||n.graphic&&n.graphic.text&&n.graphic.text.textStr||""}function getAnnotationLabelDescription(n){var r=n.options&&n.options.accessibility&&n.options.accessibility.description;if(r)return r;var t=n.chart,o=getLabelText(n),s=n.points,a=function(f){return f.graphic&&f.graphic.element&&f.graphic.element.getAttribute("aria-label")||""},l=function(f){var g=f.accessibility&&f.accessibility.valueDescription||a(f),v=f&&f.series.name||"";return(v?v+", ":"")+"data point "+g},h=s.filter(function(f){return!!f.graphic}).map(l).filter(function(f){return!!f}),c=h.length,d=c>1?"MultiplePoints":c?"SinglePoint":"NoPoints",p="accessibility.screenReaderSection.annotations.description"+d,u={annotationText:o,annotation:n,numPoints:c,annotationPoint:h[0],additionalAnnotationPoints:h.slice(1)};return t.langFormat(p,u)}function getAnnotationListItems(n){var r=getChartAnnotationLabels(n);return r.map(function(t){var o=escapeStringForHTML(stripHTMLTagsFromString$1(getAnnotationLabelDescription(t)));return o?"<li>"+o+"</li>":""})}function getAnnotationsInfoHTML$1(n){var r=n.annotations;if(!(r&&r.length))return"";var t=getAnnotationListItems(n);return'<ul style="list-style-type: none">'+t.join(" ")+"</ul>"}function getPointAnnotationTexts$1(n){var r=getChartAnnotationLabels(n.series.chart),t=r.filter(function(o){return o.points.indexOf(n)>-1});return t.length?t.map(function(o){return""+getLabelText(o)}):[]}var AnnotationsA11y={getAnnotationsInfoHTML:getAnnotationsInfoHTML$1,getAnnotationLabelDescription,getAnnotationListItems,getPointAnnotationTexts:getPointAnnotationTexts$1},getPointAnnotationTexts=AnnotationsA11y.getPointAnnotationTexts,getAxisDescription$1=ChartUtilities.getAxisDescription,getSeriesFirstPointElement=ChartUtilities.getSeriesFirstPointElement,getSeriesA11yElement=ChartUtilities.getSeriesA11yElement,unhideChartElementFromAT$4=ChartUtilities.unhideChartElementFromAT,format$5=FormatUtilities.format,numberFormat=FormatUtilities.numberFormat,reverseChildNodes=HTMLUtilities.reverseChildNodes,stripHTMLTags$1=HTMLUtilities.stripHTMLTagsFromString,find$6=Utilities.find,isNumber$l=Utilities.isNumber,pick$T=Utilities.pick,defined$n=Utilities.defined;function findFirstPointWithGraphic(n){var r=n.index;return!n.series||!n.series.data||!defined$n(r)?null:find$6(n.series.data,function(t){return!!(t&&typeof t.index<"u"&&t.index>r&&t.graphic&&t.graphic.element)})||null}function shouldAddDummyPoint(n){var r=n.series&&n.series.is("sunburst"),t=n.isNull;return t&&!r}function makeDummyElement(n,r){var t=n.series.chart.renderer,o=t.rect(r.x,r.y,1,1);return o.attr({class:"highcharts-a11y-dummy-point",fill:"none",opacity:0,"fill-opacity":0,"stroke-opacity":0}),o}function addDummyPointElement(n){var r=n.series,t=findFirstPointWithGraphic(n),o=t&&t.graphic,s=o?o.parentGroup:r.graph||r.group,a=t?{x:pick$T(n.plotX,t.plotX,0),y:pick$T(n.plotY,t.plotY,0)}:{x:pick$T(n.plotX,0),y:pick$T(n.plotY,0)},l=makeDummyElement(n,a);if(s&&s.element)return n.graphic=l,n.hasDummyGraphic=!0,l.add(s),s.element.insertBefore(l.element,o?o.element:null),l.element}function hasMorePointsThanDescriptionThreshold(n){var r=n.chart.options.accessibility,t=r.series.pointDescriptionEnabledThreshold;return!!(t!==!1&&n.points&&n.points.length>=t)}function shouldSetScreenReaderPropsOnPoints(n){var r=n.options.accessibility||{};return!hasMorePointsThanDescriptionThreshold(n)&&!r.exposeAsGroupOnly}function shouldSetKeyboardNavPropsOnPoints(n){var r=n.chart.options.accessibility,t=r.keyboardNavigation.seriesNavigation;return!!(n.points&&(n.points.length<t.pointNavigationEnabledThreshold||t.pointNavigationEnabledThreshold===!1))}function shouldDescribeSeriesElement(n){var r=n.chart,t=r.options.chart,o=t.options3d&&t.options3d.enabled,s=r.series.length>1,a=r.options.accessibility.series.describeSingleSeries,l=(n.options.accessibility||{}).exposeAsGroupOnly,h=o&&s;return!h&&(s||a||l||hasMorePointsThanDescriptionThreshold(n))}function pointNumberToString(n,r){var t=n.series.chart,o=t.options.accessibility.point||{},s=n.series.tooltipOptions||{},a=t.options.lang;return isNumber$l(r)?numberFormat(r,o.valueDecimals||s.valueDecimals||-1,a.decimalPoint,a.accessibility.thousandsSep||a.thousandsSep):r}function getSeriesDescriptionText(n){var r=n.options.accessibility||{},t=r.description;return t&&n.chart.langFormat("accessibility.series.description",{description:t,series:n})||""}function getSeriesAxisDescriptionText(n,r){var t=n[r];return n.chart.langFormat("accessibility.series."+r+"Description",{name:getAxisDescription$1(t),series:n})}function getPointA11yTimeDescription(n){var r=n.series,t=r.chart,o=t.options.accessibility.point||{},s=r.xAxis&&r.xAxis.dateTime;if(s){var a=s.getXDateFormat(n.x||0,t.options.tooltip.dateTimeLabelFormats),l=o.dateFormatter&&o.dateFormatter(n)||o.dateFormat||a;return t.time.dateFormat(l,n.x||0,void 0)}}function getPointXDescription(n){var r=getPointA11yTimeDescription(n),t=n.series.xAxis||{},o=t.categories&&defined$n(n.category)&&(""+n.category).replace("<br/>"," "),s=n.id&&n.id.indexOf("highcharts-")<0,a="x, "+n.x;return n.name||r||o||(s?n.id:a)}function getPointArrayMapValueDescription(n,r,t){var o=r||"",s=t||"",a=function(h){var c=pointNumberToString(n,pick$T(n[h],n.options[h]));return h+": "+o+c+s},l=n.series.pointArrayMap;return l.reduce(function(h,c){return h+(h.length?", ":"")+a(c)},"")}function getPointValue(n){var r=n.series,t=r.chart.options.accessibility.point||{},o=r.tooltipOptions||{},s=t.valuePrefix||o.valuePrefix||"",a=t.valueSuffix||o.valueSuffix||"",l=typeof n.value<"u"?"value":"y",h=pointNumberToString(n,n[l]);return n.isNull?r.chart.langFormat("accessibility.series.nullPointValue",{point:n}):r.pointArrayMap?getPointArrayMapValueDescription(n,s,a):s+h+a}function getPointAnnotationDescription(n){var r=n.series.chart,t="accessibility.series.pointAnnotationsDescription",o=getPointAnnotationTexts(n),s={point:n,annotations:o};return o.length?r.langFormat(t,s):""}function getPointValueDescription(n){var r=n.series,t=r.chart,o=t.options.accessibility.point.valueDescriptionFormat,s=pick$T(r.xAxis&&r.xAxis.options.accessibility&&r.xAxis.options.accessibility.enabled,!t.angular),a=s?getPointXDescription(n):"",l={point:n,index:defined$n(n.index)?n.index+1:"",xDescription:a,value:getPointValue(n),separator:s?", ":""};return format$5(o,l,t)}function defaultPointDescriptionFormatter$1(n){var r=n.series,t=r.chart,o=getPointValueDescription(n),s=n.options&&n.options.accessibility&&n.options.accessibility.description,a=s?" "+s:"",l=t.series.length>1&&r.name?" "+r.name+".":"",h=getPointAnnotationDescription(n),c=h?" "+h:"";return n.accessibility=n.accessibility||{},n.accessibility.valueDescription=o,o+a+l+c}function setPointScreenReaderAttribs(n,r){var t=n.series,o=t.chart.options.accessibility.point||{},s=t.options.accessibility||{},a=stripHTMLTags$1(s.pointDescriptionFormatter&&s.pointDescriptionFormatter(n)||o.descriptionFormatter&&o.descriptionFormatter(n)||defaultPointDescriptionFormatter$1(n));r.setAttribute("role","img"),r.setAttribute("aria-label",a)}function describePointsInSeries(n){var r=shouldSetScreenReaderPropsOnPoints(n),t=shouldSetKeyboardNavPropsOnPoints(n);(r||t)&&n.points.forEach(function(o){var s=o.graphic&&o.graphic.element||shouldAddDummyPoint(o)&&addDummyPointElement(o),a=o.options&&o.options.accessibility&&o.options.accessibility.enabled===!1;s&&(s.setAttribute("tabindex","-1"),s.style.outline="0",r&&!a?setPointScreenReaderAttribs(o,s):s.setAttribute("aria-hidden",!0))})}function defaultSeriesDescriptionFormatter$1(n){var r=n.chart,t=r.types||[],o=getSeriesDescriptionText(n),s=function(p){return r[p]&&r[p].length>1&&n[p]},a=getSeriesAxisDescriptionText(n,"xAxis"),l=getSeriesAxisDescriptionText(n,"yAxis"),h={name:n.name||"",ix:n.index+1,numSeries:r.series&&r.series.length,numPoints:n.points&&n.points.length,series:n},c=t.length>1?"Combination":"",d=r.langFormat("accessibility.series.summary."+n.type+c,h)||r.langFormat("accessibility.series.summary.default"+c,h);return d+(o?" "+o:"")+(s("yAxis")?" "+l:"")+(s("xAxis")?" "+a:"")}function describeSeriesElement(n,r){var t=n.options.accessibility||{},o=n.chart.options.accessibility,s=o.landmarkVerbosity;t.exposeAsGroupOnly?r.setAttribute("role","img"):s==="all"&&r.setAttribute("role","region"),r.setAttribute("tabindex","-1"),r.style.outline="0",r.setAttribute("aria-label",stripHTMLTags$1(o.series.descriptionFormatter&&o.series.descriptionFormatter(n)||defaultSeriesDescriptionFormatter$1(n)))}function describeSeries$1(n){var r=n.chart,t=getSeriesFirstPointElement(n),o=getSeriesA11yElement(n),s=r.is3d&&r.is3d();o&&(o.lastChild===t&&!s&&reverseChildNodes(o),describePointsInSeries(n),unhideChartElementFromAT$4(r,o),shouldDescribeSeriesElement(n)?describeSeriesElement(n,o):o.setAttribute("aria-label",""))}var SeriesDescriber={describeSeries:describeSeries$1,defaultPointDescriptionFormatter:defaultPointDescriptionFormatter$1,defaultSeriesDescriptionFormatter:defaultSeriesDescriptionFormatter$1,getPointA11yTimeDescription,getPointXDescription,getPointValue,getPointValueDescription},doc$9=H.doc,setElAttrs$3=HTMLUtilities.setElAttrs,visuallyHideElement$1=HTMLUtilities.visuallyHideElement,Announcer=function(){function n(r,t){this.chart=r,this.domElementProvider=new DOMElementProvider,this.announceRegion=this.addAnnounceRegion(t)}return n.prototype.destroy=function(){this.domElementProvider.destroyCreatedElements()},n.prototype.announce=function(r){var t=this;AST.setElementHTML(this.announceRegion,r),this.clearAnnouncementRegionTimer&&clearTimeout(this.clearAnnouncementRegionTimer),this.clearAnnouncementRegionTimer=setTimeout(function(){t.announceRegion.innerHTML="",delete t.clearAnnouncementRegionTimer},1e3)},n.prototype.addAnnounceRegion=function(r){var t=this.chart.announcerContainer||this.createAnnouncerContainer(),o=this.domElementProvider.createElement("div");return setElAttrs$3(o,{"aria-hidden":!1,"aria-live":r}),visuallyHideElement$1(o),t.appendChild(o),o},n.prototype.createAnnouncerContainer=function(){var r=this.chart,t=doc$9.createElement("div");return setElAttrs$3(t,{"aria-hidden":!1,style:"position:relative",class:"highcharts-announcer-container"}),r.renderTo.insertBefore(t,r.renderTo.firstChild),r.announcerContainer=t,t},n}(),extend$S=Utilities.extend,defined$m=Utilities.defined,getChartTitle$2=ChartUtilities.getChartTitle,defaultPointDescriptionFormatter=SeriesDescriber.defaultPointDescriptionFormatter,defaultSeriesDescriptionFormatter=SeriesDescriber.defaultSeriesDescriptionFormatter;function chartHasAnnounceEnabled(n){return!!n.options.accessibility.announceNewData.enabled}function findPointInDataArray(n){var r=n.series.data.filter(function(t){return n.x===t.x&&n.y===t.y});return r.length===1?r[0]:n}function getUniqueSeries(n,r){var t=(n||[]).concat(r||[]).reduce(function(o,s){return o[s.name+s.index]=s,o},{});return Object.keys(t).map(function(o){return t[o]})}var NewDataAnnouncer=function(n){this.chart=n};extend$S(NewDataAnnouncer.prototype,{init:function(){var n=this.chart,r=n.options.accessibility.announceNewData,t=r.interruptUser?"assertive":"polite";this.lastAnnouncementTime=0,this.dirty={allSeries:{}},this.eventProvider=new EventProvider,this.announcer=new Announcer(n,t),this.addEventListeners()},destroy:function(){this.eventProvider.removeAddedEvents(),this.announcer.destroy()},addEventListeners:function(){var n=this,r=this.chart,t=this.eventProvider;t.addEvent(r,"afterDrilldown",function(){n.lastAnnouncementTime=0}),t.addEvent(Series$e,"updatedData",function(){n.onSeriesUpdatedData(this)}),t.addEvent(r,"afterAddSeries",function(o){n.onSeriesAdded(o.series)}),t.addEvent(Series$e,"addPoint",function(o){n.onPointAdded(o.point)}),t.addEvent(r,"redraw",function(){n.announceDirtyData()})},onSeriesUpdatedData:function(n){var r=this.chart;n.chart===r&&chartHasAnnounceEnabled(r)&&(this.dirty.hasDirty=!0,this.dirty.allSeries[n.name+n.index]=n)},onSeriesAdded:function(n){chartHasAnnounceEnabled(this.chart)&&(this.dirty.hasDirty=!0,this.dirty.allSeries[n.name+n.index]=n,this.dirty.newSeries=defined$m(this.dirty.newSeries)?void 0:n)},onPointAdded:function(n){var r=n.series.chart;this.chart===r&&chartHasAnnounceEnabled(r)&&(this.dirty.newPoint=defined$m(this.dirty.newPoint)?void 0:n)},announceDirtyData:function(){var n=this.chart,r=this;if(n.options.accessibility.announceNewData&&this.dirty.hasDirty){var t=this.dirty.newPoint;t&&(t=findPointInDataArray(t)),this.queueAnnouncement(Object.keys(this.dirty.allSeries).map(function(o){return r.dirty.allSeries[o]}),this.dirty.newSeries,t),this.dirty={allSeries:{}}}},queueAnnouncement:function(n,r,t){var o=this,s=this.chart,a=s.options.accessibility.announceNewData;if(a.enabled){var l=+new Date,h=l-this.lastAnnouncementTime,c=Math.max(0,a.minAnnounceInterval-h),d=getUniqueSeries(this.queuedAnnouncement&&this.queuedAnnouncement.series,n),p=this.buildAnnouncementMessage(d,r,t);p&&(this.queuedAnnouncement&&clearTimeout(this.queuedAnnouncementTimer),this.queuedAnnouncement={time:l,message:p,series:d},this.queuedAnnouncementTimer=setTimeout(function(){o&&o.announcer&&(o.lastAnnouncementTime=+new Date,o.announcer.announce(o.queuedAnnouncement.message),delete o.queuedAnnouncement,delete o.queuedAnnouncementTimer)},c))}},buildAnnouncementMessage:function(n,r,t){var o=this.chart,s=o.options.accessibility.announceNewData;if(s.announcementFormatter){var a=s.announcementFormatter(n,r,t);if(a!==!1)return a.length?a:null}var l=H.charts&&H.charts.length>1?"Multiple":"Single",h=r?"newSeriesAnnounce"+l:t?"newPointAnnounce"+l:"newDataAnnounce",c=getChartTitle$2(o);return o.langFormat("accessibility.announceNewData."+h,{chartTitle:c,seriesDesc:r?defaultSeriesDescriptionFormatter(r):null,pointDesc:t?defaultPointDescriptionFormatter(t):null,point:t,series:r})}});var addEvent$z=Utilities.addEvent,merge$M=Utilities.merge;function isWithinDescriptionThreshold(n){var r=n.chart.options.accessibility;return n.points.length<r.series.pointDescriptionEnabledThreshold||r.series.pointDescriptionEnabledThreshold===!1}function shouldForceMarkers(n){var r=n.chart,t=r.options.accessibility.enabled,o=(n.options.accessibility&&n.options.accessibility.enabled)!==!1;return t&&o&&isWithinDescriptionThreshold(n)}function hasIndividualPointMarkerOptions(n){return!!(n._hasPointMarkers&&n.points&&n.points.length)}function unforceSeriesMarkerOptions(n){var r=n.resetA11yMarkerOptions;r&&merge$M(!0,n.options,{marker:{enabled:r.enabled,states:{normal:{opacity:r.states&&r.states.normal&&r.states.normal.opacity}}}})}function forceZeroOpacityMarkerOptions(n){merge$M(!0,n,{marker:{enabled:!0,states:{normal:{opacity:0}}}})}function getPointMarkerOpacity(n){return n.marker.states&&n.marker.states.normal&&n.marker.states.normal.opacity||1}function unforcePointMarkerOptions(n){merge$M(!0,n.marker,{states:{normal:{opacity:getPointMarkerOpacity(n)}}})}function handleForcePointMarkers(n){for(var r=n.points.length;r--;){var t=n.points[r],o=t.options;delete t.hasForcedA11yMarker,o.marker&&(o.marker.enabled?(unforcePointMarkerOptions(o),t.hasForcedA11yMarker=!1):(forceZeroOpacityMarkerOptions(o),t.hasForcedA11yMarker=!0))}}function addForceMarkersEvents(){addEvent$z(Series$e,"render",function(){var n=this,r=n.options;shouldForceMarkers(n)?(r.marker&&r.marker.enabled===!1&&(n.a11yMarkersForced=!0,forceZeroOpacityMarkerOptions(n.options)),hasIndividualPointMarkerOptions(n)&&handleForcePointMarkers(n)):n.a11yMarkersForced&&(delete n.a11yMarkersForced,unforceSeriesMarkerOptions(n))}),addEvent$z(Series$e,"afterSetOptions",function(n){this.resetA11yMarkerOptions=merge$M(n.options.marker||{},this.userOptions.marker||{})}),addEvent$z(Series$e,"afterRender",function(){var n=this;n.chart.styledMode&&(n.markerGroup&&n.markerGroup[n.a11yMarkersForced?"addClass":"removeClass"]("highcharts-a11y-markers-hidden"),hasIndividualPointMarkerOptions(n)&&n.points.forEach(function(r){r.graphic&&(r.graphic[r.hasForcedA11yMarker?"addClass":"removeClass"]("highcharts-a11y-marker-hidden"),r.graphic[r.hasForcedA11yMarker===!1?"addClass":"removeClass"]("highcharts-a11y-marker-visible"))}))})}var extend$R=Utilities.extend,hideSeriesFromAT=ChartUtilities.hideSeriesFromAT,describeSeries=SeriesDescriber.describeSeries;H.SeriesAccessibilityDescriber=SeriesDescriber;addForceMarkersEvents();var SeriesComponent=function(){};SeriesComponent.prototype=new AccessibilityComponent;extend$R(SeriesComponent.prototype,{init:function(){this.newDataAnnouncer=new NewDataAnnouncer(this.chart),this.newDataAnnouncer.init(),this.keyboardNavigation=new SeriesKeyboardNavigation(this.chart,this.keyCodes),this.keyboardNavigation.init(),this.hideTooltipFromATWhenShown(),this.hideSeriesLabelsFromATWhenShown()},hideTooltipFromATWhenShown:function(){var n=this;this.addEvent(Tooltip,"refresh",function(){this.chart===n.chart&&this.label&&this.label.element&&this.label.element.setAttribute("aria-hidden",!0)})},hideSeriesLabelsFromATWhenShown:function(){this.addEvent(this.chart,"afterDrawSeriesLabels",function(){this.series.forEach(function(n){n.labelBySeries&&n.labelBySeries.attr("aria-hidden",!0)})})},onChartRender:function(){var n=this.chart;n.series.forEach(function(r){var t=(r.options.accessibility&&r.options.accessibility.enabled)!==!1&&r.visible;t?describeSeries(r):hideSeriesFromAT(r)})},getKeyboardNavigation:function(){return this.keyboardNavigation.getKeyboardNavigationHandler()},destroy:function(){this.newDataAnnouncer.destroy(),this.keyboardNavigation.destroy()}});var unhideChartElementFromAT$3=ChartUtilities.unhideChartElementFromAT,noop$d=H.noop,removeElement=HTMLUtilities.removeElement,setElAttrs$2=HTMLUtilities.setElAttrs,extend$Q=Utilities.extend,pick$S=Utilities.pick;function chartHasMapZoom(n){return!!(n.mapZoom&&n.mapNavButtons&&n.mapNavButtons.length)}H.Axis.prototype.panStep=function(n,r){var t=r||3,o=this.getExtremes(),s=(o.max-o.min)/t*n,a=o.max+s,l=o.min+s,h=a-l;n<0&&l<o.dataMin?(l=o.dataMin,a=l+h):n>0&&a>o.dataMax&&(a=o.dataMax,l=a-h),this.setExtremes(l,a)};var ZoomComponent=noop$d;ZoomComponent.prototype=new AccessibilityComponent;extend$Q(ZoomComponent.prototype,{init:function(){var n=this,r=this.chart;["afterShowResetZoom","afterDrilldown","drillupall"].forEach(function(t){n.addEvent(r,t,function(){n.updateProxyOverlays()})})},onChartUpdate:function(){var n=this.chart,r=this;n.mapNavButtons&&n.mapNavButtons.forEach(function(t,o){unhideChartElementFromAT$3(n,t.element),r.setMapNavButtonAttrs(t.element,"accessibility.zoom.mapZoom"+(o?"Out":"In"))})},setMapNavButtonAttrs:function(n,r){var t=this.chart,o=t.langFormat(r,{chart:t});setElAttrs$2(n,{tabindex:-1,role:"button","aria-label":o})},onChartRender:function(){this.updateProxyOverlays()},updateProxyOverlays:function(){var n=this.chart;removeElement(this.drillUpProxyGroup),removeElement(this.resetZoomProxyGroup),n.resetZoomButton&&this.recreateProxyButtonAndGroup(n.resetZoomButton,"resetZoomProxyButton","resetZoomProxyGroup",n.langFormat("accessibility.zoom.resetZoomButton",{chart:n})),n.drillUpButton&&this.recreateProxyButtonAndGroup(n.drillUpButton,"drillUpProxyButton","drillUpProxyGroup",n.langFormat("accessibility.drillUpButton",{chart:n,buttonText:n.getDrilldownBackText()}))},recreateProxyButtonAndGroup:function(n,r,t,o){removeElement(this[t]),this[t]=this.addProxyGroup(),this[r]=this.createProxyButton(n,this[t],{"aria-label":o,tabindex:-1})},getMapZoomNavigation:function(){var n=this.keyCodes,r=this.chart,t=this;return new KeyboardNavigationHandler(r,{keyCodeMap:[[[n.up,n.down,n.left,n.right],function(o){return t.onMapKbdArrow(this,o)}],[[n.tab],function(o,s){return t.onMapKbdTab(this,s)}],[[n.space,n.enter],function(){return t.onMapKbdClick(this)}]],validate:function(){return chartHasMapZoom(r)},init:function(o){return t.onMapNavInit(o)}})},onMapKbdArrow:function(n,r){var t=this.keyCodes,o=r===t.up||r===t.down?"yAxis":"xAxis",s=r===t.left||r===t.up?-1:1;return this.chart[o][0].panStep(s),n.response.success},onMapKbdTab:function(n,r){var t,o=this.chart,s=n.response,a=r.shiftKey,l=a&&!this.focusedMapNavButtonIx||!a&&this.focusedMapNavButtonIx;return o.mapNavButtons[this.focusedMapNavButtonIx].setState(0),l?(o.mapZoom(),s[a?"prev":"next"]):(this.focusedMapNavButtonIx+=a?-1:1,t=o.mapNavButtons[this.focusedMapNavButtonIx],o.setFocusToElement(t.box,t.element),t.setState(2),s.success)},onMapKbdClick:function(n){return this.fakeClickEvent(this.chart.mapNavButtons[this.focusedMapNavButtonIx].element),n.response.success},onMapNavInit:function(n){var r=this.chart,t=r.mapNavButtons[0],o=r.mapNavButtons[1],s=n>0?t:o;r.setFocusToElement(s.box,s.element),s.setState(2),this.focusedMapNavButtonIx=n>0?0:1},simpleButtonNavigation:function(n,r,t){var o=this.keyCodes,s=this,a=this.chart;return new KeyboardNavigationHandler(a,{keyCodeMap:[[[o.tab,o.up,o.down,o.left,o.right],function(l,h){var c=l===o.tab&&h.shiftKey||l===o.left||l===o.up;return this.response[c?"prev":"next"]}],[[o.space,o.enter],function(){var l=t(this,a);return pick$S(l,this.response.success)}]],validate:function(){var l=a[n]&&a[n].box&&s[r];return l},init:function(){a.setFocusToElement(a[n].box,s[r])}})},getKeyboardNavigation:function(){return[this.simpleButtonNavigation("resetZoomButton","resetZoomProxyButton",function(n,r){r.zoomOut()}),this.simpleButtonNavigation("drillUpButton","drillUpProxyButton",function(n,r){return r.drillUp(),n.response.prev}),this.getMapZoomNavigation()]}});var unhideChartElementFromAT$2=ChartUtilities.unhideChartElementFromAT,getAxisRangeDescription$1=ChartUtilities.getAxisRangeDescription,setElAttrs$1=HTMLUtilities.setElAttrs,addEvent$y=Utilities.addEvent,extend$P=Utilities.extend;function shouldRunInputNavigation(n){return!!(n.rangeSelector&&n.rangeSelector.inputGroup&&n.rangeSelector.inputGroup.element.getAttribute("visibility")!=="hidden"&&n.options.rangeSelector.inputEnabled!==!1&&n.rangeSelector.minInput&&n.rangeSelector.maxInput)}Chart$1.prototype.highlightRangeSelectorButton=function(n){var r=this.rangeSelector&&this.rangeSelector.buttons||[],t=this.highlightedRangeSelectorItemIx,o=this.rangeSelector&&this.rangeSelector.selected;return typeof t<"u"&&r[t]&&t!==o&&r[t].setState(this.oldRangeSelectorItemState||0),this.highlightedRangeSelectorItemIx=n,r[n]?(this.setFocusToElement(r[n].box,r[n].element),n!==o&&(this.oldRangeSelectorItemState=r[n].state,r[n].setState(1)),!0):!1};addEvent$y(RangeSelector,"afterBtnClick",function(){if(this.chart.accessibility&&this.chart.accessibility.components.rangeSelector)return this.chart.accessibility.components.rangeSelector.onAfterBtnClick()});var RangeSelectorComponent=function(){};RangeSelectorComponent.prototype=new AccessibilityComponent;extend$P(RangeSelectorComponent.prototype,{init:function(){var n=this.chart;this.announcer=new Announcer(n,"polite")},onChartUpdate:function(){var n=this.chart,r=this,t=n.rangeSelector;t&&(this.updateSelectorVisibility(),this.setDropdownAttrs(),t.buttons&&t.buttons.length&&t.buttons.forEach(function(o){r.setRangeButtonAttrs(o)}),t.maxInput&&t.minInput&&["minInput","maxInput"].forEach(function(o,s){var a=t[o];a&&(unhideChartElementFromAT$2(n,a),r.setRangeInputAttrs(a,"accessibility.rangeSelector."+(s?"max":"min")+"InputLabel"))}))},updateSelectorVisibility:function(){var n=this.chart,r=n.rangeSelector,t=r&&r.dropdown,o=r&&r.buttons||[],s=function(a){return a.setAttribute("aria-hidden",!0)};r&&r.hasVisibleDropdown&&t?(unhideChartElementFromAT$2(n,t),o.forEach(function(a){return s(a.element)})):(t&&s(t),o.forEach(function(a){return unhideChartElementFromAT$2(n,a.element)}))},setDropdownAttrs:function(){var n=this.chart,r=n.rangeSelector&&n.rangeSelector.dropdown;if(r){var t=n.langFormat("accessibility.rangeSelector.dropdownLabel",{rangeTitle:n.options.lang.rangeSelectorZoom});r.setAttribute("aria-label",t),r.setAttribute("tabindex",-1)}},setRangeButtonAttrs:function(n){setElAttrs$1(n.element,{tabindex:-1,role:"button"})},setRangeInputAttrs:function(n,r){var t=this.chart;setElAttrs$1(n,{tabindex:-1,"aria-label":t.langFormat(r,{chart:t})})},onButtonNavKbdArrowKey:function(n,r){var t=n.response,o=this.keyCodes,s=this.chart,a=s.options.accessibility.keyboardNavigation.wrapAround,l=r===o.left||r===o.up?-1:1,h=s.highlightRangeSelectorButton(s.highlightedRangeSelectorItemIx+l);return h?t.success:a?(n.init(l),t.success):t[l>0?"next":"prev"]},onButtonNavKbdClick:function(n){var r=n.response,t=this.chart,o=t.oldRangeSelectorItemState===3;return o||this.fakeClickEvent(t.rangeSelector.buttons[t.highlightedRangeSelectorItemIx].element),r.success},onAfterBtnClick:function(){var n=this.chart,r=getAxisRangeDescription$1(n.xAxis[0]),t=n.langFormat("accessibility.rangeSelector.clickButtonAnnouncement",{chart:n,axisRangeDescription:r});t&&this.announcer.announce(t)},onInputKbdMove:function(n){var r=this.chart,t=r.rangeSelector,o=r.highlightedInputRangeIx=(r.highlightedInputRangeIx||0)+n,s=o>1||o<0;if(s)r.accessibility&&(r.accessibility.keyboardNavigation.tabindexContainer.focus(),r.accessibility.keyboardNavigation[n<0?"prev":"next"]());else if(t){var a=t[o?"maxDateBox":"minDateBox"],l=t[o?"maxInput":"minInput"];a&&l&&r.setFocusToElement(a,l)}},onInputNavInit:function(n){var r=this,t=this,o=this.chart,s=n>0?0:1,a=o.rangeSelector,l=a&&a[s?"maxDateBox":"minDateBox"],h=a&&a.minInput,c=a&&a.maxInput,d=s?c:h;if(o.highlightedInputRangeIx=s,l&&h&&c){o.setFocusToElement(l,d),this.removeInputKeydownHandler&&this.removeInputKeydownHandler();var p=function(g){var v=(g.which||g.keyCode)===r.keyCodes.tab;v&&(g.preventDefault(),g.stopPropagation(),t.onInputKbdMove(g.shiftKey?-1:1))},u=addEvent$y(h,"keydown",p),f=addEvent$y(c,"keydown",p);this.removeInputKeydownHandler=function(){u(),f()}}},onInputNavTerminate:function(){var n=this.chart.rangeSelector||{};n.maxInput&&n.hideInput("max"),n.minInput&&n.hideInput("min"),this.removeInputKeydownHandler&&(this.removeInputKeydownHandler(),delete this.removeInputKeydownHandler)},initDropdownNav:function(){var n=this,r=this.chart,t=r.rangeSelector,o=t&&t.dropdown;t&&o&&(r.setFocusToElement(t.buttonGroup,o),this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeDropdownKeydownHandler=addEvent$y(o,"keydown",function(s){var a=(s.which||s.keyCode)===n.keyCodes.tab;a&&(s.preventDefault(),s.stopPropagation(),r.accessibility&&(r.accessibility.keyboardNavigation.tabindexContainer.focus(),r.accessibility.keyboardNavigation[s.shiftKey?"prev":"next"]()))}))},getRangeSelectorButtonNavigation:function(){var n=this.chart,r=this.keyCodes,t=this;return new KeyboardNavigationHandler(n,{keyCodeMap:[[[r.left,r.right,r.up,r.down],function(o){return t.onButtonNavKbdArrowKey(this,o)}],[[r.enter,r.space],function(){return t.onButtonNavKbdClick(this)}]],validate:function(){return!!(n.rangeSelector&&n.rangeSelector.buttons&&n.rangeSelector.buttons.length)},init:function(o){var s=n.rangeSelector;if(s&&s.hasVisibleDropdown)t.initDropdownNav();else if(s){var a=s.buttons.length-1;n.highlightRangeSelectorButton(o>0?0:a)}},terminate:function(){t.removeDropdownKeydownHandler&&(t.removeDropdownKeydownHandler(),delete t.removeDropdownKeydownHandler)}})},getRangeSelectorInputNavigation:function(){var n=this.chart,r=this;return new KeyboardNavigationHandler(n,{keyCodeMap:[],validate:function(){return shouldRunInputNavigation(n)},init:function(t){r.onInputNavInit(t)},terminate:function(){r.onInputNavTerminate()}})},getKeyboardNavigation:function(){return[this.getRangeSelectorButtonNavigation(),this.getRangeSelectorInputNavigation()]},destroy:function(){this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeInputKeydownHandler&&this.removeInputKeydownHandler(),this.announcer&&this.announcer.destroy()}});var format$4=FormatUtilities.format,doc$8=H.doc,extend$O=Utilities.extend,pick$R=Utilities.pick,getAnnotationsInfoHTML=AnnotationsA11y.getAnnotationsInfoHTML,getAxisDescription=ChartUtilities.getAxisDescription,getAxisRangeDescription=ChartUtilities.getAxisRangeDescription,getChartTitle$1=ChartUtilities.getChartTitle,unhideChartElementFromAT$1=ChartUtilities.unhideChartElementFromAT,addClass=HTMLUtilities.addClass,getElement=HTMLUtilities.getElement,getHeadingTagNameForElement=HTMLUtilities.getHeadingTagNameForElement,setElAttrs=HTMLUtilities.setElAttrs,stripHTMLTagsFromString=HTMLUtilities.stripHTMLTagsFromString,visuallyHideElement=HTMLUtilities.visuallyHideElement;function stripEmptyHTMLTags(n){return n.replace(/<(\w+)[^>]*?>\s*<\/\1>/g,"")}function getTypeDescForMapChart(n,r){return r.mapTitle?n.langFormat("accessibility.chartTypes.mapTypeDescription",r):n.langFormat("accessibility.chartTypes.unknownMap",r)}function getTypeDescForCombinationChart(n,r){return n.langFormat("accessibility.chartTypes.combinationChart",r)}function getTypeDescForEmptyChart(n,r){return n.langFormat("accessibility.chartTypes.emptyChart",r)}function buildTypeDescriptionFromSeries(n,r,t){var o=r[0],s=n.langFormat("accessibility.seriesTypeDescriptions."+o,t),a=n.series&&n.series.length<2?"Single":"Multiple";return(n.langFormat("accessibility.chartTypes."+o+a,t)||n.langFormat("accessibility.chartTypes.default"+a,t))+(s?" "+s:"")}function getTableSummary(n){return n.langFormat("accessibility.table.tableSummary",{chart:n})}Chart$1.prototype.getTypeDescription=function(n){var r=n[0],t=this.series&&this.series[0]||{},o={numSeries:this.series.length,numPoints:t.points&&t.points.length,chart:this,mapTitle:t.mapTitle};return r?r==="map"?getTypeDescForMapChart(this,o):this.types.length>1?getTypeDescForCombinationChart(this,o):buildTypeDescriptionFromSeries(this,n,o):getTypeDescForEmptyChart(this,o)};var InfoRegionsComponent=function(){};InfoRegionsComponent.prototype=new AccessibilityComponent;extend$O(InfoRegionsComponent.prototype,{init:function(){var n=this.chart,r=this;this.initRegionsDefinitions(),this.addEvent(n,"aftergetTableAST",function(t){r.onDataTableCreated(t)}),this.addEvent(n,"afterViewData",function(t){r.dataTableDiv=t,setTimeout(function(){r.focusDataTable()},300)}),this.announcer=new Announcer(n,"assertive")},initRegionsDefinitions:function(){var n=this;this.screenReaderSections={before:{element:null,buildContent:function(r){var t=r.options.accessibility.screenReaderSection.beforeChartFormatter;return t?t(r):n.defaultBeforeChartFormatter(r)},insertIntoDOM:function(r,t){t.renderTo.insertBefore(r,t.renderTo.firstChild)},afterInserted:function(){typeof n.sonifyButtonId<"u"&&n.initSonifyButton(n.sonifyButtonId),typeof n.dataTableButtonId<"u"&&n.initDataTableButton(n.dataTableButtonId)}},after:{element:null,buildContent:function(r){var t=r.options.accessibility.screenReaderSection.afterChartFormatter;return t?t(r):n.defaultAfterChartFormatter()},insertIntoDOM:function(r,t){t.renderTo.insertBefore(r,t.container.nextSibling)},afterInserted:function(){n.chart.accessibility&&n.chart.accessibility.keyboardNavigation.updateExitAnchor()}}}},onChartRender:function(){var n=this;this.linkedDescriptionElement=this.getLinkedDescriptionElement(),this.setLinkedDescriptionAttrs(),Object.keys(this.screenReaderSections).forEach(function(r){n.updateScreenReaderSection(r)})},getLinkedDescriptionElement:function(){var n=this.chart.options,r=n.accessibility.linkedDescription;if(r){if(typeof r!="string")return r;var t=format$4(r,this.chart),o=doc$8.querySelectorAll(t);if(o.length===1)return o[0]}},setLinkedDescriptionAttrs:function(){var n=this.linkedDescriptionElement;n&&(n.setAttribute("aria-hidden","true"),addClass(n,"highcharts-linked-description"))},updateScreenReaderSection:function(n){var r=this.chart,t=this.screenReaderSections[n],o=t.buildContent(r),s=t.element=t.element||this.createElement("div"),a=s.firstChild||this.createElement("div");this.setScreenReaderSectionAttribs(s,n),AST.setElementHTML(a,o),s.appendChild(a),t.insertIntoDOM(s,r),visuallyHideElement(a),unhideChartElementFromAT$1(r,a),t.afterInserted&&t.afterInserted()},setScreenReaderSectionAttribs:function(n,r){var t="accessibility.screenReaderSection."+r+"RegionLabel",o=this.chart,s=o.langFormat(t,{chart:o,chartTitle:getChartTitle$1(o)}),a="highcharts-screen-reader-region-"+r+"-"+o.index;setElAttrs(n,{id:a,"aria-label":s}),n.style.position="relative",o.options.accessibility.landmarkVerbosity==="all"&&s&&n.setAttribute("role","region")},defaultBeforeChartFormatter:function(){var n=this.chart,r=n.options.accessibility.screenReaderSection.beforeChartFormat,t=this.getAxesDescription(),o=n.sonify&&n.options.sonification&&n.options.sonification.enabled,s="highcharts-a11y-sonify-data-btn-"+n.index,a="hc-linkto-highcharts-data-table-"+n.index,l=getAnnotationsInfoHTML(n),h=n.langFormat("accessibility.screenReaderSection.annotations.heading",{chart:n}),c={headingTagName:getHeadingTagNameForElement(n.renderTo),chartTitle:getChartTitle$1(n),typeDescription:this.getTypeDescriptionText(),chartSubtitle:this.getSubtitleText(),chartLongdesc:this.getLongdescText(),xAxisDescription:t.xAxis,yAxisDescription:t.yAxis,playAsSoundButton:o?this.getSonifyButtonText(s):"",viewTableButton:n.getCSV?this.getDataTableButtonText(a):"",annotationsTitle:l?h:"",annotationsList:l},d=H.i18nFormat(r,c,n);return this.dataTableButtonId=a,this.sonifyButtonId=s,stripEmptyHTMLTags(d)},defaultAfterChartFormatter:function(){var n=this.chart,r=n.options.accessibility.screenReaderSection.afterChartFormat,t={endOfChartMarker:this.getEndOfChartMarkerText()},o=H.i18nFormat(r,t,n);return stripEmptyHTMLTags(o)},getLinkedDescription:function(){var n=this.linkedDescriptionElement,r=n&&n.innerHTML||"";return stripHTMLTagsFromString(r)},getLongdescText:function(){var n=this.chart.options,r=n.caption,t=r&&r.text,o=this.getLinkedDescription();return n.accessibility.description||o||t||""},getTypeDescriptionText:function(){var n=this.chart;return n.types?n.options.accessibility.typeDescription||n.getTypeDescription(n.types):""},getDataTableButtonText:function(n){var r=this.chart,t=r.langFormat("accessibility.table.viewAsDataTableButtonText",{chart:r,chartTitle:getChartTitle$1(r)});return'<button id="'+n+'">'+t+"</button>"},getSonifyButtonText:function(n){var r=this.chart;if(r.options.sonification&&r.options.sonification.enabled===!1)return"";var t=r.langFormat("accessibility.sonification.playAsSoundButtonText",{chart:r,chartTitle:getChartTitle$1(r)});return'<button id="'+n+'">'+t+"</button>"},getSubtitleText:function(){var n=this.chart.options.subtitle;return stripHTMLTagsFromString(n&&n.text||"")},getEndOfChartMarkerText:function(){var n=this.chart,r=n.langFormat("accessibility.screenReaderSection.endOfChartMarker",{chart:n}),t="highcharts-end-of-chart-marker-"+n.index;return'<div id="'+t+'">'+r+"</div>"},onDataTableCreated:function(n){var r=this.chart;if(r.options.accessibility.enabled){this.viewDataTableButton&&this.viewDataTableButton.setAttribute("aria-expanded","true");var t=n.tree.attributes||{};t.tabindex=-1,t.summary=getTableSummary(r),n.tree.attributes=t}},focusDataTable:function(){var n=this.dataTableDiv,r=n&&n.getElementsByTagName("table")[0];r&&r.focus&&r.focus()},initSonifyButton:function(n){var r=this,t=this.sonifyButton=getElement(n),o=this.chart,s=function(a){t&&(t.setAttribute("aria-hidden","true"),t.setAttribute("aria-label","")),a.preventDefault(),a.stopPropagation();var l=o.langFormat("accessibility.sonification.playAsSoundClickAnnouncement",{chart:o});r.announcer.announce(l),setTimeout(function(){t&&(t.removeAttribute("aria-hidden"),t.removeAttribute("aria-label")),o.sonify&&o.sonify()},1e3)};t&&o&&(setElAttrs(t,{tabindex:-1}),t.onclick=function(a){var l=o.options.accessibility&&o.options.accessibility.screenReaderSection.onPlayAsSoundClick;(l||s).call(this,a,o)})},initDataTableButton:function(n){var r=this.viewDataTableButton=getElement(n),t=this.chart,o=n.replace("hc-linkto-","");r&&(setElAttrs(r,{tabindex:-1,"aria-expanded":!!getElement(o)}),r.onclick=t.options.accessibility.screenReaderSection.onViewDataTableClick||function(){t.viewData()})},getAxesDescription:function(){var n=this.chart,r=function(h,c){var d=n[h];return d.length>1||d[0]&&pick$R(d[0].options.accessibility&&d[0].options.accessibility.enabled,c)},t=!!n.types&&n.types.indexOf("map")<0,o=!!n.hasCartesianSeries,s=r("xAxis",!n.angular&&o&&t),a=r("yAxis",o&&t),l={};return s&&(l.xAxis=this.getAxisDescriptionText("xAxis")),a&&(l.yAxis=this.getAxisDescriptionText("yAxis")),l},getAxisDescriptionText:function(n){var r=this.chart,t=r[n];return r.langFormat("accessibility.axis."+n+"Description"+(t.length>1?"Plural":"Singular"),{chart:r,names:t.map(function(o){return getAxisDescription(o)}),ranges:t.map(function(o){return getAxisRangeDescription(o)}),numAxes:t.length})},destroy:function(){this.announcer&&this.announcer.destroy()}});var unhideChartElementFromAT=ChartUtilities.unhideChartElementFromAT,getChartTitle=ChartUtilities.getChartTitle,doc$7=H.doc,stripHTMLTags=HTMLUtilities.stripHTMLTagsFromString,extend$N=Utilities.extend,ContainerComponent=function(){};ContainerComponent.prototype=new AccessibilityComponent;extend$N(ContainerComponent.prototype,{onChartUpdate:function(){this.handleSVGTitleElement(),this.setSVGContainerLabel(),this.setGraphicContainerAttrs(),this.setRenderToAttrs(),this.makeCreditsAccessible()},handleSVGTitleElement:function(){var n=this.chart,r="highcharts-title-"+n.index,t=stripHTMLTags(n.langFormat("accessibility.svgContainerTitle",{chartTitle:getChartTitle(n)}));if(t.length){var o=this.svgTitleElement=this.svgTitleElement||doc$7.createElementNS("http://www.w3.org/2000/svg","title");o.textContent=t,o.id=r,n.renderTo.insertBefore(o,n.renderTo.firstChild)}},setSVGContainerLabel:function(){var n=this.chart,r=n.langFormat("accessibility.svgContainerLabel",{chartTitle:getChartTitle(n)});n.renderer.box&&r.length&&n.renderer.box.setAttribute("aria-label",r)},setGraphicContainerAttrs:function(){var n=this.chart,r=n.langFormat("accessibility.graphicContainerLabel",{chartTitle:getChartTitle(n)});r.length&&n.container.setAttribute("aria-label",r)},setRenderToAttrs:function(){var n=this.chart;n.options.accessibility.landmarkVerbosity!=="disabled"?n.renderTo.setAttribute("role","region"):n.renderTo.removeAttribute("role"),n.renderTo.setAttribute("aria-label",n.langFormat("accessibility.chartContainerLabel",{title:getChartTitle(n),chart:n}))},makeCreditsAccessible:function(){var n=this.chart,r=n.credits;r&&(r.textStr&&r.element.setAttribute("aria-label",n.langFormat("accessibility.credits",{creditsStr:stripHTMLTags(r.textStr)})),unhideChartElementFromAT(n,r.element))},getKeyboardNavigation:function(){var n=this.chart;return new KeyboardNavigationHandler(n,{keyCodeMap:[],validate:function(){return!0},init:function(){var r=n.accessibility;r&&r.keyboardNavigation.tabindexContainer.focus()}})},destroy:function(){this.chart.renderTo.setAttribute("aria-hidden",!0)}});var doc$6=H.doc,isMS=H.isMS,win$3=H.win,whcm={isHighContrastModeActive:function(){var n=/(Edg)/.test(win$3.navigator.userAgent);if(win$3.matchMedia&&n)return win$3.matchMedia("(-ms-high-contrast: active)").matches;if(isMS&&win$3.getComputedStyle){var r=doc$6.createElement("div"),t="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==";r.style.backgroundImage="url("+t+")",doc$6.body.appendChild(r);var o=(r.currentStyle||win$3.getComputedStyle(r)).backgroundImage;return doc$6.body.removeChild(r),o==="none"}return!1},setHighContrastTheme:function(n){n.highContrastModeActive=!0;var r=n.options.accessibility.highContrastTheme;n.update(r,!1),n.series.forEach(function(t){var o=r.plotOptions[t.type]||{};t.update({color:o.color||"windowText",colors:[o.color||"windowText"],borderColor:o.borderColor||"window"}),t.points.forEach(function(s){s.options&&s.options.color&&s.update({color:o.color||"windowText",borderColor:o.borderColor||"window"},!1)})}),n.redraw()}},theme={chart:{backgroundColor:"window"},title:{style:{color:"windowText"}},subtitle:{style:{color:"windowText"}},colorAxis:{minColor:"windowText",maxColor:"windowText",stops:[]},colors:["windowText"],xAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},yAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},tooltip:{backgroundColor:"window",borderColor:"windowText",style:{color:"windowText"}},plotOptions:{series:{lineColor:"windowText",fillColor:"window",borderColor:"windowText",edgeColor:"windowText",borderWidth:1,dataLabels:{connectorColor:"windowText",color:"windowText",style:{color:"windowText",textOutline:"none"}},marker:{lineColor:"windowText",fillColor:"windowText"}},pie:{color:"window",colors:["window"],borderColor:"windowText",borderWidth:1},boxplot:{fillColor:"window"},candlestick:{lineColor:"windowText",fillColor:"window"},errorbar:{fillColor:"window"}},legend:{backgroundColor:"window",itemStyle:{color:"windowText"},itemHoverStyle:{color:"windowText"},itemHiddenStyle:{color:"#555"},title:{style:{color:"windowText"}}},credits:{style:{color:"windowText"}},labels:{style:{color:"windowText"}},drilldown:{activeAxisLabelStyle:{color:"windowText"},activeDataLabelStyle:{color:"windowText"}},navigation:{buttonOptions:{symbolStroke:"windowText",theme:{fill:"window"}}},rangeSelector:{buttonTheme:{fill:"window",stroke:"windowText",style:{color:"windowText"},states:{hover:{fill:"window",stroke:"windowText",style:{color:"windowText"}},select:{fill:"#444",stroke:"windowText",style:{color:"windowText"}}}},inputBoxBorderColor:"windowText",inputStyle:{backgroundColor:"window",color:"windowText"},labelStyle:{color:"windowText"}},navigator:{handles:{backgroundColor:"window",borderColor:"windowText"},outlineColor:"windowText",maskFill:"transparent",series:{color:"windowText",lineColor:"windowText"},xAxis:{gridLineColor:"windowText"}},scrollbar:{barBackgroundColor:"#444",barBorderColor:"windowText",buttonArrowColor:"windowText",buttonBackgroundColor:"window",buttonBorderColor:"windowText",rifleColor:"windowText",trackBackgroundColor:"window",trackBorderColor:"windowText"}},Options={accessibility:{enabled:!0,screenReaderSection:{beforeChartFormat:"<{headingTagName}>{chartTitle}</{headingTagName}><div>{typeDescription}</div><div>{chartSubtitle}</div><div>{chartLongdesc}</div><div>{playAsSoundButton}</div><div>{viewTableButton}</div><div>{xAxisDescription}</div><div>{yAxisDescription}</div><div>{annotationsTitle}{annotationsList}</div>",afterChartFormat:"{endOfChartMarker}",axisRangeDateFormat:"%Y-%m-%d %H:%M:%S"},series:{describeSingleSeries:!1,pointDescriptionEnabledThreshold:200},point:{valueDescriptionFormat:"{index}. {xDescription}{separator}{value}."},landmarkVerbosity:"all",linkedDescription:'*[data-highcharts-chart="{index}"] + .highcharts-description',keyboardNavigation:{enabled:!0,focusBorder:{enabled:!0,hideBrowserFocusOutline:!0,style:{color:palette.highlightColor80,lineWidth:2,borderRadius:3},margin:2},order:["series","zoom","rangeSelector","legend","chartMenu"],wrapAround:!0,seriesNavigation:{skipNullPoints:!0,pointNavigationEnabledThreshold:!1}},announceNewData:{enabled:!1,minAnnounceInterval:5e3,interruptUser:!1}},legend:{accessibility:{enabled:!0,keyboardNavigation:{enabled:!0}}},exporting:{accessibility:{enabled:!0}}},langOptions={accessibility:{defaultChartTitle:"Chart",chartContainerLabel:"{title}. Highcharts interactive chart.",svgContainerLabel:"Interactive chart",drillUpButton:"{buttonText}",credits:"Chart credits: {creditsStr}",thousandsSep:",",svgContainerTitle:"",graphicContainerLabel:"",screenReaderSection:{beforeRegionLabel:"Chart screen reader information, {chartTitle}.",afterRegionLabel:"",annotations:{heading:"Chart annotations summary",descriptionSinglePoint:"{annotationText}. Related to {annotationPoint}",descriptionMultiplePoints:"{annotationText}. Related to {annotationPoint}{ Also related to, #each(additionalAnnotationPoints)}",descriptionNoPoints:"{annotationText}"},endOfChartMarker:"End of interactive chart."},sonification:{playAsSoundButtonText:"Play as sound, {chartTitle}",playAsSoundClickAnnouncement:"Play"},legend:{legendLabelNoTitle:"Toggle series visibility, {chartTitle}",legendLabel:"Chart legend: {legendTitle}",legendItem:"Show {itemName}"},zoom:{mapZoomIn:"Zoom chart",mapZoomOut:"Zoom out chart",resetZoomButton:"Reset zoom"},rangeSelector:{dropdownLabel:"{rangeTitle}",minInputLabel:"Select start date.",maxInputLabel:"Select end date.",clickButtonAnnouncement:"Viewing {axisRangeDescription}"},table:{viewAsDataTableButtonText:"View as data table, {chartTitle}",tableSummary:"Table representation of chart."},announceNewData:{newDataAnnounce:"Updated data for chart {chartTitle}",newSeriesAnnounceSingle:"New data series: {seriesDesc}",newPointAnnounceSingle:"New data point: {pointDesc}",newSeriesAnnounceMultiple:"New data series in chart {chartTitle}: {seriesDesc}",newPointAnnounceMultiple:"New data point in chart {chartTitle}: {pointDesc}"},seriesTypeDescriptions:{boxplot:"Box plot charts are typically used to display groups of statistical data. Each data point in the chart can have up to 5 values: minimum, lower quartile, median, upper quartile, and maximum.",arearange:"Arearange charts are line charts displaying a range between a lower and higher value for each point.",areasplinerange:"These charts are line charts displaying a range between a lower and higher value for each point.",bubble:"Bubble charts are scatter charts where each data point also has a size value.",columnrange:"Columnrange charts are column charts displaying a range between a lower and higher value for each point.",errorbar:"Errorbar series are used to display the variability of the data.",funnel:"Funnel charts are used to display reduction of data in stages.",pyramid:"Pyramid charts consist of a single pyramid with item heights corresponding to each point value.",waterfall:"A waterfall chart is a column chart where each column contributes towards a total end value."},chartTypes:{emptyChart:"Empty chart",mapTypeDescription:"Map of {mapTitle} with {numSeries} data series.",unknownMap:"Map of unspecified region with {numSeries} data series.",combinationChart:"Combination chart with {numSeries} data series.",defaultSingle:"Chart with {numPoints} data {#plural(numPoints, points, point)}.",defaultMultiple:"Chart with {numSeries} data series.",splineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",splineMultiple:"Line chart with {numSeries} lines.",lineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",lineMultiple:"Line chart with {numSeries} lines.",columnSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",columnMultiple:"Bar chart with {numSeries} data series.",barSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",barMultiple:"Bar chart with {numSeries} data series.",pieSingle:"Pie chart with {numPoints} {#plural(numPoints, slices, slice)}.",pieMultiple:"Pie chart with {numSeries} pies.",scatterSingle:"Scatter chart with {numPoints} {#plural(numPoints, points, point)}.",scatterMultiple:"Scatter chart with {numSeries} data series.",boxplotSingle:"Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotMultiple:"Boxplot with {numSeries} data series.",bubbleSingle:"Bubble chart with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleMultiple:"Bubble chart with {numSeries} data series."},axis:{xAxisDescriptionSingular:"The chart has 1 X axis displaying {names[0]}. {ranges[0]}",xAxisDescriptionPlural:"The chart has {numAxes} X axes displaying {#each(names, -1) }and {names[-1]}.",yAxisDescriptionSingular:"The chart has 1 Y axis displaying {names[0]}. {ranges[0]}",yAxisDescriptionPlural:"The chart has {numAxes} Y axes displaying {#each(names, -1) }and {names[-1]}.",timeRangeDays:"Range: {range} days.",timeRangeHours:"Range: {range} hours.",timeRangeMinutes:"Range: {range} minutes.",timeRangeSeconds:"Range: {range} seconds.",rangeFromTo:"Range: {rangeFrom} to {rangeTo}.",rangeCategories:"Range: {numCategories} categories."},exporting:{chartMenuLabel:"Chart menu",menuButtonLabel:"View chart menu",exportRegionLabel:"Chart menu, {chartTitle}"},series:{summary:{default:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",defaultCombination:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",line:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",lineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",spline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",splineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",column:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",columnCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",bar:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",barCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",pie:"{name}, pie {ix} of {numSeries} with {numPoints} {#plural(numPoints, slices, slice)}.",pieCombination:"{name}, series {ix} of {numSeries}. Pie with {numPoints} {#plural(numPoints, slices, slice)}.",scatter:"{name}, scatter plot {ix} of {numSeries} with {numPoints} {#plural(numPoints, points, point)}.",scatterCombination:"{name}, series {ix} of {numSeries}, scatter plot with {numPoints} {#plural(numPoints, points, point)}.",boxplot:"{name}, boxplot {ix} of {numSeries} with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotCombination:"{name}, series {ix} of {numSeries}. Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",bubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}.",map:"{name}, map {ix} of {numSeries} with {numPoints} {#plural(numPoints, areas, area)}.",mapCombination:"{name}, series {ix} of {numSeries}. Map with {numPoints} {#plural(numPoints, areas, area)}.",mapline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",maplineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",mapbubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",mapbubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}."},description:"{description}",xAxisDescription:"X axis, {name}",yAxisDescription:"Y axis, {name}",nullPointValue:"No value",pointAnnotationsDescription:"{Annotation: #each(annotations). }"}}},error$1=Utilities.error,pick$Q=Utilities.pick;function traverseSetOption(n,r,t){for(var o=n,s,a=0;a<r.length-1;++a)s=r[a],o=o[s]=pick$Q(o[s],{});o[r[r.length-1]]=t}function deprecateFromOptionsMap(n,r,t,o){function s(h,c){return c.reduce(function(d,p){return d[p]},h)}var a=s(n.options,r),l=s(n.options,t);Object.keys(o).forEach(function(h){var c,d=a[h];typeof d<"u"&&(traverseSetOption(l,o[h],d),error$1(32,!1,n,(c={},c[r.join(".")+"."+h]=t.join(".")+"."+o[h].join("."),c)))})}function copyDeprecatedChartOptions(n){var r=n.options.chart,t=n.options.accessibility||{};["description","typeDescription"].forEach(function(o){var s;r[o]&&(t[o]=r[o],error$1(32,!1,n,(s={},s["chart."+o]="use accessibility."+o,s)))})}function copyDeprecatedAxisOptions(n){n.axes.forEach(function(r){var t=r.options;t&&t.description&&(t.accessibility=t.accessibility||{},t.accessibility.description=t.description,error$1(32,!1,n,{"axis.description":"use axis.accessibility.description"}))})}function copyDeprecatedSeriesOptions(n){var r={description:["accessibility","description"],exposeElementToA11y:["accessibility","exposeAsGroupOnly"],pointDescriptionFormatter:["accessibility","pointDescriptionFormatter"],skipKeyboardNavigation:["accessibility","keyboardNavigation","enabled"]};n.series.forEach(function(t){Object.keys(r).forEach(function(o){var s,a=t.options[o];typeof a<"u"&&(traverseSetOption(t.options,r[o],o==="skipKeyboardNavigation"?!a:a),error$1(32,!1,n,(s={},s["series."+o]="series."+r[o].join("."),s)))})})}function copyDeprecatedTopLevelAccessibilityOptions(n){deprecateFromOptionsMap(n,["accessibility"],["accessibility"],{pointDateFormat:["point","dateFormat"],pointDateFormatter:["point","dateFormatter"],pointDescriptionFormatter:["point","descriptionFormatter"],pointDescriptionThreshold:["series","pointDescriptionEnabledThreshold"],pointNavigationThreshold:["keyboardNavigation","seriesNavigation","pointNavigationEnabledThreshold"],pointValueDecimals:["point","valueDecimals"],pointValuePrefix:["point","valuePrefix"],pointValueSuffix:["point","valueSuffix"],screenReaderSectionFormatter:["screenReaderSection","beforeChartFormatter"],describeSingleSeries:["series","describeSingleSeries"],seriesDescriptionFormatter:["series","descriptionFormatter"],onTableAnchorClick:["screenReaderSection","onViewDataTableClick"],axisRangeDateFormat:["screenReaderSection","axisRangeDateFormat"]})}function copyDeprecatedKeyboardNavigationOptions(n){deprecateFromOptionsMap(n,["accessibility","keyboardNavigation"],["accessibility","keyboardNavigation","seriesNavigation"],{skipNullPoints:["skipNullPoints"],mode:["mode"]})}function copyDeprecatedLangOptions(n){deprecateFromOptionsMap(n,["lang","accessibility"],["lang","accessibility"],{legendItem:["legend","legendItem"],legendLabel:["legend","legendLabel"],mapZoomIn:["zoom","mapZoomIn"],mapZoomOut:["zoom","mapZoomOut"],resetZoomButton:["zoom","resetZoomButton"],screenReaderRegionLabel:["screenReaderSection","beforeRegionLabel"],rangeSelectorButton:["rangeSelector","buttonText"],rangeSelectorMaxInput:["rangeSelector","maxInputLabel"],rangeSelectorMinInput:["rangeSelector","minInputLabel"],svgContainerEnd:["screenReaderSection","endOfChartMarker"],viewAsDataTable:["table","viewAsDataTableButtonText"],tableSummary:["table","tableSummary"]})}function copyDeprecatedOptions(n){copyDeprecatedChartOptions(n),copyDeprecatedAxisOptions(n),n.series&&copyDeprecatedSeriesOptions(n),copyDeprecatedTopLevelAccessibilityOptions(n),copyDeprecatedKeyboardNavigationOptions(n),copyDeprecatedLangOptions(n)}var format$3=FormatUtilities.format,pick$P=Utilities.pick;function stringTrim(n){return n.trim&&n.trim()||n.replace(/^\s+|\s+$/g,"")}function formatExtendedStatement(n,r){var t=n.indexOf("#each("),o=n.indexOf("#plural("),s=n.indexOf("["),a=n.indexOf("]"),l,h;if(t>-1){var c=n.slice(t).indexOf(")")+t,d=n.substring(0,t),p=n.substring(c+1),u=n.substring(t+6,c),f=u.split(","),g=Number(f[1]),v=void 0;if(h="",l=r[f[0]],l){g=isNaN(g)?l.length:g,v=g<0?l.length+g:Math.min(g,l.length);for(var m=0;m<v;++m)h+=d+l[m]+p}return h.length?h:""}if(o>-1){var x=n.slice(o).indexOf(")")+o,y=n.substring(o+8,x),b=y.split(","),$=Number(r[b[0]]);switch($){case 0:h=pick$P(b[4],b[1]);break;case 1:h=pick$P(b[2],b[1]);break;case 2:h=pick$P(b[3],b[1]);break;default:h=b[1]}return h?stringTrim(h):""}if(s>-1){var S=n.substring(0,s),k=Number(n.substring(s+1,a)),A=void 0;return l=r[S],!isNaN(k)&&l&&(k<0?(A=l[l.length+k],typeof A>"u"&&(A=l[0])):(A=l[k],typeof A>"u"&&(A=l[l.length-1]))),typeof A<"u"?A:""}return"{"+n+"}"}H.i18nFormat=function(n,r,t){var o=function(c,d){var p=c.slice(d||0),u=p.indexOf("{"),f=p.indexOf("}");if(u>-1&&f>u)return{statement:p.substring(u+1,f),begin:d+u+1,end:d+f}},s=[],a,l,h=0;do a=o(n,h),l=n.substring(h,a&&a.begin-1),l.length&&s.push({value:l,type:"constant"}),a&&s.push({value:a.statement,type:"statement"}),h=a?a.end+1:h+1;while(a);return s.forEach(function(c){c.type==="statement"&&(c.value=formatExtendedStatement(c.value,r))}),format$3(s.reduce(function(c,d){return c+d.value},""),r,t)};Chart$1.prototype.langFormat=function(n,r){for(var t=n.split("."),o=this.options.lang,s=0;s<t.length;++s)o=o&&o[t[s]];return typeof o=="string"?H.i18nFormat(o,r,this):""};var addEvent$x=Utilities.addEvent,extend$M=Utilities.extend,pick$O=Utilities.pick,svgElementBorderUpdateTriggers=["x","y","transform","width","height","r","d","stroke-width"];function addDestroyFocusBorderHook(n){if(!n.focusBorderDestroyHook){var r=n.destroy;n.destroy=function(){return n.focusBorder&&n.focusBorder.destroy&&n.focusBorder.destroy(),r.apply(n,arguments)},n.focusBorderDestroyHook=r}}function removeDestroyFocusBorderHook(n){n.focusBorderDestroyHook&&(n.destroy=n.focusBorderDestroyHook,delete n.focusBorderDestroyHook)}function addUpdateFocusBorderHooks(n){for(var r=[],t=1;t<arguments.length;t++)r[t-1]=arguments[t];n.focusBorderUpdateHooks||(n.focusBorderUpdateHooks={},svgElementBorderUpdateTriggers.forEach(function(o){var s=o+"Setter",a=n[s]||n._defaultSetter;n.focusBorderUpdateHooks[s]=a,n[s]=function(){var l=a.apply(n,arguments);return n.addFocusBorder.apply(n,r),l}}))}function removeUpdateFocusBorderHooks(n){n.focusBorderUpdateHooks&&(Object.keys(n.focusBorderUpdateHooks).forEach(function(r){var t=n.focusBorderUpdateHooks[r];t===n._defaultSetter?delete n[r]:n[r]=t}),delete n.focusBorderUpdateHooks)}extend$M(SVGElement.prototype,{addFocusBorder:function(n,r){this.focusBorder&&this.removeFocusBorder();var t=this.getBBox(),o=pick$O(n,3);t.x+=this.translateX?this.translateX:0,t.y+=this.translateY?this.translateY:0;var s=t.x-o,a=t.y-o,l=t.width+2*o,h=t.height+2*o;function c(m){var x=0,y=0;return m.attr("text-anchor")==="middle"?x=y=.5:m.rotation?x=.25:y=.75,{x,y}}var d=this instanceof SVGLabel;if(this.element.nodeName==="text"||d){var p=!!this.rotation,u=d?{x:p?1:0,y:0}:c(this),f=+this.attr("x"),g=+this.attr("y");if(isNaN(f)||(s=f-t.width*u.x-o),isNaN(g)||(a=g-t.height*u.y-o),d&&p){var v=l;l=h,h=v,isNaN(f)||(s=f-t.height*u.x-o),isNaN(g)||(a=g-t.width*u.y-o)}}this.focusBorder=this.renderer.rect(s,a,l,h,parseInt((r&&r.r||0).toString(),10)).addClass("highcharts-focus-border").attr({zIndex:99}).add(this.parentGroup),this.renderer.styledMode||this.focusBorder.attr({stroke:r&&r.stroke,"stroke-width":r&&r.strokeWidth}),addUpdateFocusBorderHooks(this,n,r),addDestroyFocusBorderHook(this)},removeFocusBorder:function(){removeUpdateFocusBorderHooks(this),removeDestroyFocusBorderHook(this),this.focusBorder&&(this.focusBorder.destroy(),delete this.focusBorder)}});Chart$1.prototype.renderFocusBorder=function(){var n=this.focusElement,r=this.options.accessibility.keyboardNavigation.focusBorder;n&&(n.removeFocusBorder(),r.enabled&&n.addFocusBorder(r.margin,{stroke:r.style.color,strokeWidth:r.style.lineWidth,r:r.style.borderRadius}))};Chart$1.prototype.setFocusToElement=function(n,r){var t=this.options.accessibility.keyboardNavigation.focusBorder,o=r||n.element;o&&o.focus&&(o.hcEvents&&o.hcEvents.focusin||addEvent$x(o,"focusin",function(){}),o.focus(),t.hideBrowserFocusOutline&&(o.style.outline="none")),this.focusElement&&this.focusElement.removeFocusBorder(),this.focusElement=n,this.renderFocusBorder()};var doc$5=H.doc,defaultOptions$4=DefaultOptions.defaultOptions,addEvent$w=Utilities.addEvent,extend$L=Utilities.extend,fireEvent$d=Utilities.fireEvent,merge$L=Utilities.merge;merge$L(!0,defaultOptions$4,Options,{accessibility:{highContrastTheme:theme},lang:langOptions});H.A11yChartUtilities=ChartUtilities;H.A11yHTMLUtilities=HTMLUtilities;H.KeyboardNavigationHandler=KeyboardNavigationHandler;H.AccessibilityComponent=AccessibilityComponent;function Accessibility(n){this.init(n)}Accessibility.prototype={init:function(n){if(this.chart=n,!doc$5.addEventListener||!n.renderer.isSVG){n.renderTo.setAttribute("aria-hidden",!0);return}copyDeprecatedOptions(n),this.initComponents(),this.keyboardNavigation=new KeyboardNavigation(n,this.components),this.update()},initComponents:function(){var n=this.chart,r=n.options.accessibility;this.components={container:new ContainerComponent,infoRegions:new InfoRegionsComponent,legend:new LegendComponent,chartMenu:new MenuComponent,rangeSelector:new RangeSelectorComponent,series:new SeriesComponent,zoom:new ZoomComponent},r.customComponents&&extend$L(this.components,r.customComponents);var t=this.components;this.getComponentOrder().forEach(function(o){t[o].initBase(n),t[o].init()})},getComponentOrder:function(){if(!this.components)return[];if(!this.components.series)return Object.keys(this.components);var n=Object.keys(this.components).filter(function(r){return r!=="series"});return["series"].concat(n)},update:function(){var n=this.components,r=this.chart,t=r.options.accessibility;fireEvent$d(r,"beforeA11yUpdate"),r.types=this.getChartTypes(),this.getComponentOrder().forEach(function(o){n[o].onChartUpdate(),fireEvent$d(r,"afterA11yComponentUpdate",{name:o,component:n[o]})}),this.keyboardNavigation.update(t.keyboardNavigation.order),!r.highContrastModeActive&&whcm.isHighContrastModeActive()&&whcm.setHighContrastTheme(r),fireEvent$d(r,"afterA11yUpdate",{accessibility:this})},destroy:function(){var n=this.chart||{},r=this.components;Object.keys(r).forEach(function(t){r[t].destroy(),r[t].destroyBase()}),this.keyboardNavigation&&this.keyboardNavigation.destroy(),n.renderTo&&n.renderTo.setAttribute("aria-hidden",!0),n.focusElement&&n.focusElement.removeFocusBorder()},getChartTypes:function(){var n={};return this.chart.series.forEach(function(r){n[r.type]=1}),Object.keys(n)}};Chart$1.prototype.updateA11yEnabled=function(){var n=this.accessibility,r=this.options.accessibility;r&&r.enabled?n?n.update():this.accessibility=n=new Accessibility(this):n?(n.destroy&&n.destroy(),delete this.accessibility):this.renderTo.setAttribute("aria-hidden",!0)};addEvent$w(Chart$1,"render",function(n){this.a11yDirty&&this.renderTo&&(delete this.a11yDirty,this.updateA11yEnabled());var r=this.accessibility;r&&r.getComponentOrder().forEach(function(t){r.components[t].onChartRender()})});addEvent$w(Chart$1,"update",function(n){var r=n.options.accessibility;r&&(r.customComponents&&(this.options.accessibility.customComponents=r.customComponents,delete r.customComponents),merge$L(!0,this.options.accessibility,r),this.accessibility&&this.accessibility.destroy&&(this.accessibility.destroy(),delete this.accessibility)),this.a11yDirty=!0});addEvent$w(Point$2,"update",function(){this.series.chart.accessibility&&(this.series.chart.a11yDirty=!0)});["addSeries","init"].forEach(function(n){addEvent$w(Chart$1,n,function(){this.a11yDirty=!0})});["update","updatedData","remove"].forEach(function(n){addEvent$w(Series$e,n,function(){this.chart.accessibility&&(this.chart.a11yDirty=!0)})});["afterDrilldown","drillupall"].forEach(function(n){addEvent$w(Chart$1,n,function(){this.accessibility&&this.accessibility.update()})});addEvent$w(Chart$1,"destroy",function(){this.accessibility&&this.accessibility.destroy()});var addEvent$v=Utilities.addEvent,fireEvent$c=Utilities.fireEvent,objectEach$c=Utilities.objectEach,pick$N=Utilities.pick,removeEvent$2=Utilities.removeEvent,eventEmitterMixin={addEvents:function(){var n=this,r=function(o){addEvent$v(o,H.isTouchDevice?"touchstart":"mousedown",function(s){n.onMouseDown(s)},{passive:!1})};if(r(this.graphic.element),(n.labels||[]).forEach(function(o){o.options.useHTML&&o.graphic.text&&r(o.graphic.text.element)}),objectEach$c(n.options.events,function(o,s){var a=function(l){(s!=="click"||!n.cancelClick)&&o.call(n,n.chart.pointer.normalize(l),n.target)};(n.nonDOMEvents||[]).indexOf(s)===-1?n.graphic.on(s,a):addEvent$v(n,s,a,{passive:!1})}),n.options.draggable&&(addEvent$v(n,"drag",n.onDrag),!n.graphic.renderer.styledMode)){var t={cursor:{x:"ew-resize",y:"ns-resize",xy:"move"}[n.options.draggable]};n.graphic.css(t),(n.labels||[]).forEach(function(o){o.options.useHTML&&o.graphic.text&&o.graphic.text.css(t)})}n.isUpdating||fireEvent$c(n,"add")},removeDocEvents:function(){this.removeDrag&&(this.removeDrag=this.removeDrag()),this.removeMouseUp&&(this.removeMouseUp=this.removeMouseUp())},onMouseDown:function(n){var r=this,t=r.chart.pointer,o,s;n.preventDefault&&n.preventDefault(),n.button!==2&&(n=t.normalize(n),o=n.chartX,s=n.chartY,r.cancelClick=!1,r.chart.hasDraggedAnnotation=!0,r.removeDrag=addEvent$v(H.doc,H.isTouchDevice?"touchmove":"mousemove",function(a){r.hasDragged=!0,a=t.normalize(a),a.prevChartX=o,a.prevChartY=s,fireEvent$c(r,"drag",a),o=a.chartX,s=a.chartY},H.isTouchDevice?{passive:!1}:void 0),r.removeMouseUp=addEvent$v(H.doc,H.isTouchDevice?"touchend":"mouseup",function(a){var l=pick$N(r.target&&r.target.annotation,r.target);l&&(l.cancelClick=r.hasDragged),r.cancelClick=r.hasDragged,r.hasDragged=!1,r.chart.hasDraggedAnnotation=!1,fireEvent$c(pick$N(l,r),"afterUpdate"),r.onMouseUp(a)},H.isTouchDevice?{passive:!1}:void 0))},onMouseUp:function(n){var r=this.chart,t=this.target||this,o=r.options.annotations,s=r.annotations.indexOf(t);this.removeDocEvents(),o[s]=t.options},onDrag:function(n){if(this.chart.isInsidePlot(n.chartX-this.chart.plotLeft,n.chartY-this.chart.plotTop,{visiblePlotOnly:!0})){var r=this.mouseMoveToTranslation(n);this.options.draggable==="x"&&(r.y=0),this.options.draggable==="y"&&(r.x=0),this.points.length?this.translate(r.x,r.y):(this.shapes.forEach(function(t){t.translate(r.x,r.y)}),this.labels.forEach(function(t){t.translate(r.x,r.y)})),this.redraw(!1)}},mouseMoveToRadians:function(n,r,t){var o=n.prevChartY-t,s=n.prevChartX-r,a=n.chartY-t,l=n.chartX-r,h;return this.chart.inverted&&(h=s,s=o,o=h,h=l,l=a,a=h),Math.atan2(a,l)-Math.atan2(o,s)},mouseMoveToTranslation:function(n){var r=n.chartX-n.prevChartX,t=n.chartY-n.prevChartY,o;return this.chart.inverted&&(o=t,t=r,r=o),{x:r,y:t}},mouseMoveToScale:function(n,r,t){var o=n.prevChartX-r,s=n.prevChartY-t,a=n.chartX-r,l=n.chartY-t,h=(a||1)/(o||1),c=(l||1)/(s||1),d;return this.chart.inverted&&(d=c,c=h,h=d),{x:h,y:c}},destroy:function(){this.removeDocEvents(),removeEvent$2(this),this.hcEvents=null}},merge$K=Utilities.merge,pick$M=Utilities.pick,ControlPoint=function(){function n(r,t,o,s){this.addEvents=eventEmitterMixin.addEvents,this.graphic=void 0,this.mouseMoveToRadians=eventEmitterMixin.mouseMoveToRadians,this.mouseMoveToScale=eventEmitterMixin.mouseMoveToScale,this.mouseMoveToTranslation=eventEmitterMixin.mouseMoveToTranslation,this.onDrag=eventEmitterMixin.onDrag,this.onMouseDown=eventEmitterMixin.onMouseDown,this.onMouseUp=eventEmitterMixin.onMouseUp,this.removeDocEvents=eventEmitterMixin.removeDocEvents,this.nonDOMEvents=["drag"],this.chart=r,this.target=t,this.options=o,this.index=pick$M(o.index,s)}return n.prototype.setVisibility=function(r){this.graphic.attr("visibility",r?"visible":"hidden"),this.options.visible=r},n.prototype.render=function(){var r=this.chart,t=this.options;this.graphic=r.renderer.symbol(t.symbol,0,0,t.width,t.height).add(r.controlPointsGroup).css(t.style),this.setVisibility(t.visible),this.addEvents()},n.prototype.redraw=function(r){this.graphic[r?"animate":"attr"](this.options.positioner.call(this,this.target))},n.prototype.destroy=function(){eventEmitterMixin.destroy.call(this),this.graphic&&(this.graphic=this.graphic.destroy()),this.chart=null,this.target=null,this.options=null},n.prototype.update=function(r){var t=this.chart,o=this.target,s=this.index,a=merge$K(!0,this.options,r);this.destroy(),this.constructor(t,o,a,s),this.render(t.controlPointsGroup),this.redraw()},n}(),defined$l=Utilities.defined,fireEvent$b=Utilities.fireEvent,MockPoint=function(){function n(r,t,o){this.isInside=void 0,this.negative=void 0,this.plotX=void 0,this.plotY=void 0,this.ttBelow=void 0,this.x=void 0,this.y=void 0,this.mock=!0,this.series={visible:!0,chart:r,getPlotBox:Series$e.prototype.getPlotBox},this.target=t||null,this.options=o,this.applyOptions(this.getOptions())}return n.fromPoint=function(r){return new n(r.series.chart,null,{x:r.x,y:r.y,xAxis:r.series.xAxis,yAxis:r.series.yAxis})},n.pointToPixels=function(r,t){var o=r.series,s=o.chart,a=r.plotX,l=r.plotY,h;return s.inverted&&(r.mock?(a=r.plotY,l=r.plotX):(a=s.plotWidth-r.plotY,l=s.plotHeight-r.plotX)),o&&!t&&(h=o.getPlotBox(),a+=h.translateX,l+=h.translateY),{x:a,y:l}},n.pointToOptions=function(r){return{x:r.x,y:r.y,xAxis:r.series.xAxis,yAxis:r.series.yAxis}},n.prototype.hasDynamicOptions=function(){return typeof this.options=="function"},n.prototype.getOptions=function(){return this.hasDynamicOptions()?this.options(this.target):this.options},n.prototype.applyOptions=function(r){this.command=r.command,this.setAxis(r,"x"),this.setAxis(r,"y"),this.refresh()},n.prototype.setAxis=function(r,t){var o=t+"Axis",s=r[o],a=this.series.chart;this.series[o]=s instanceof Axis?s:defined$l(s)?a[o][s]||a.get(s):null},n.prototype.toAnchor=function(){var r=[this.plotX,this.plotY,0,0];return this.series.chart.inverted&&(r[0]=this.plotY,r[1]=this.plotX),r},n.prototype.getLabelConfig=function(){return{x:this.x,y:this.y,point:this}},n.prototype.isInsidePlot=function(){var r=this.plotX,t=this.plotY,o=this.series.xAxis,s=this.series.yAxis,a={x:r,y:t,isInsidePlot:!0};return o&&(a.isInsidePlot=defined$l(r)&&r>=0&&r<=o.len),s&&(a.isInsidePlot=a.isInsidePlot&&defined$l(t)&&t>=0&&t<=s.len),fireEvent$b(this.series.chart,"afterIsInsidePlot",a),a.isInsidePlot},n.prototype.refresh=function(){var r=this.series,t=r.xAxis,o=r.yAxis,s=this.getOptions();t?(this.x=s.x,this.plotX=t.toPixels(s.x,!0)):(this.x=null,this.plotX=s.x),o?(this.y=s.y,this.plotY=o.toPixels(s.y,!0)):(this.y=null,this.plotY=s.y),this.isInside=this.isInsidePlot()},n.prototype.translate=function(r,t,o,s){this.hasDynamicOptions()||(this.plotX+=o,this.plotY+=s,this.refreshOptions())},n.prototype.scale=function(r,t,o,s){if(!this.hasDynamicOptions()){var a=this.plotX*o,l=this.plotY*s,h=(1-o)*r,c=(1-s)*t;this.plotX=h+a,this.plotY=c+l,this.refreshOptions()}},n.prototype.rotate=function(r,t,o){if(!this.hasDynamicOptions()){var s=Math.cos(o),a=Math.sin(o),l=this.plotX,h=this.plotY,c=void 0,d=void 0;l-=r,h-=t,c=l*s-h*a,d=l*a+h*s,this.plotX=c+r,this.plotY=d+t,this.refreshOptions()}},n.prototype.refreshOptions=function(){var r=this.series,t=r.xAxis,o=r.yAxis;this.x=this.options.x=t?this.options.x=t.toValue(this.plotX,!0):this.plotX,this.y=this.options.y=o?o.toValue(this.plotY,!0):this.plotY},n}(),isObject$7=Utilities.isObject,isString$2=Utilities.isString,merge$J=Utilities.merge,splat$6=Utilities.splat,controllableMixin={init:function(n,r,t){this.annotation=n,this.chart=n.chart,this.options=r,this.points=[],this.controlPoints=[],this.index=t,this.linkPoints(),this.addControlPoints()},attr:function(){this.graphic.attr.apply(this.graphic,arguments)},getPointsOptions:function(){var n=this.options;return n.points||n.point&&splat$6(n.point)},attrsFromOptions:function(n){var r=this.constructor.attrsMap,t={},o,s,a=this.chart.styledMode;for(o in n)s=r[o],s&&(!a||["fill","stroke","stroke-width"].indexOf(s)===-1)&&(t[s]=n[o]);return t},anchor:function(n){var r=n.series.getPlotBox(),t=n.series.chart,o=n.mock?n.toAnchor():Tooltip.prototype.getAnchor.call({chart:n.series.chart},n),s={x:o[0]+(this.options.x||0),y:o[1]+(this.options.y||0),height:o[2]||0,width:o[3]||0};return{relativePosition:s,absolutePosition:merge$J(s,{x:s.x+(n.mock?r.translateX:t.plotLeft),y:s.y+(n.mock?r.translateY:t.plotTop)})}},point:function(n,r){if(n&&n.series)return n;if(!r||r.series===null){if(isObject$7(n))r=new MockPoint(this.chart,this,n);else if(isString$2(n))r=this.chart.get(n)||null;else if(typeof n=="function"){var t=n.call(r,this);r=t.series?t:new MockPoint(this.chart,this,n)}}return r},linkPoints:function(){var n=this.getPointsOptions(),r=this.points,t=n&&n.length||0,o,s;for(o=0;o<t;o++){if(s=this.point(n[o],r[o]),!s){r.length=0;return}s.mock&&s.refresh(),r[o]=s}return r},addControlPoints:function(){var n=this.options.controlPoints;(n||[]).forEach(function(r,t){var o=merge$J(this.options.controlPointOptions,r);o.index||(o.index=t),n[t]=o,this.controlPoints.push(new ControlPoint(this.chart,this,o))},this)},shouldBeDrawn:function(){return!!this.points.length},render:function(n){this.controlPoints.forEach(function(r){r.render()})},redraw:function(n){this.controlPoints.forEach(function(r){r.redraw(n)})},transform:function(n,r,t,o,s){if(this.chart.inverted){var a=r;r=t,t=a}this.points.forEach(function(l,h){this.transformPoint(n,r,t,o,s,h)},this)},transformPoint:function(n,r,t,o,s,a){var l=this.points[a];l.mock||(l=this.points[a]=MockPoint.fromPoint(l)),l[n](r,t,o,s)},translate:function(n,r){this.transform("translate",null,null,n,r)},translatePoint:function(n,r,t){this.transformPoint("translate",null,null,n,r,t)},translateShape:function(n,r){var t=this.annotation.chart,o=this.annotation.userOptions,s=t.annotations.indexOf(this.annotation),a=t.options.annotations[s];this.translatePoint(n,r,0),a[this.collection][this.index].point=this.options.point,o[this.collection][this.index].point=this.options.point},rotate:function(n,r,t){this.transform("rotate",n,r,t)},scale:function(n,r,t,o){this.transform("scale",n,r,t,o)},setControlPointsVisibility:function(n){this.controlPoints.forEach(function(r){r.setVisibility(n)})},destroy:function(){this.graphic&&(this.graphic=this.graphic.destroy()),this.tracker&&(this.tracker=this.tracker.destroy()),this.controlPoints.forEach(function(n){n.destroy()}),this.chart=null,this.points=null,this.controlPoints=null,this.options=null,this.annotation&&(this.annotation=null)},update:function(n){var r=this.annotation,t=merge$J(!0,this.options,n),o=this.graphic.parentGroup;this.destroy(),this.constructor(r,t,this.index),this.render(o),this.redraw()}},addEvent$u=Utilities.addEvent,defined$k=Utilities.defined,merge$I=Utilities.merge,uniqueKey$2=Utilities.uniqueKey,defaultMarkers={arrow:{tagName:"marker",attributes:{id:"arrow",refY:5,refX:9,markerWidth:10,markerHeight:10},children:[{tagName:"path",attributes:{d:"M 0 0 L 10 5 L 0 10 Z","stroke-width":0}}]},"reverse-arrow":{tagName:"marker",attributes:{id:"reverse-arrow",refY:5,refX:1,markerWidth:10,markerHeight:10},children:[{tagName:"path",attributes:{d:"M 0 5 L 10 0 L 10 10 Z","stroke-width":0}}]}};SVGRenderer.prototype.addMarker=function(n,r){var t={attributes:{id:n}},o={stroke:r.color||"none",fill:r.color||"rgba(0, 0, 0, 0.75)"};t.children=r.children&&r.children.map(function(l){return merge$I(o,l)});var s=merge$I(!0,{attributes:{markerWidth:20,markerHeight:20,refX:0,refY:0,orient:"auto"}},r,t),a=this.definition(s);return a.id=n,a};function createMarkerSetter(n){return function(r){this.attr(n,"url(#"+r+")")}}var markerMixin={markerEndSetter:createMarkerSetter("marker-end"),markerStartSetter:createMarkerSetter("marker-start"),setItemMarkers:function(n){var r=n.options,t=n.chart,o=t.options.defs,s=r.fill,a=defined$k(s)&&s!=="none"?s:r.stroke,l=function(h){var c=r[h],d,p,u,f;if(c){for(u in o)if(d=o[u],(c===(d.attributes&&d.attributes.id)||c===d.id)&&d.tagName==="marker"){p=d;break}p&&(f=n[h]=t.renderer.addMarker((r.id||uniqueKey$2())+"-"+c,merge$I(p,{color:a})),n.attr(h,f.getAttribute("id")))}};["markerStart","markerEnd"].forEach(l)}};addEvent$u(Chart$1,"afterGetContainer",function(){this.options.defs=merge$I(defaultMarkers,this.options.defs||{})});var extend$K=Utilities.extend,TRACKER_FILL="rgba(192,192,192,"+(H.svg?1e-4:.002)+")",ControllablePath=function(){function n(r,t,o){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.setMarkers=markerMixin.setItemMarkers,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translate=controllableMixin.translate,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="path",this.init(r,t,o),this.collection="shapes"}return n.prototype.toD=function(){var r=this.options.d;if(r)return typeof r=="function"?r.call(this):r;var t=this.points,o=t.length,s=o,a=t[0],l=s&&this.anchor(a).absolutePosition,h=0,c,d=[];if(l)for(d.push(["M",l.x,l.y]);++h<o&&s;)a=t[h],c=a.command||"L",l=this.anchor(a).absolutePosition,c==="M"?d.push([c,l.x,l.y]):c==="L"?d.push([c,l.x,l.y]):c==="Z"&&d.push([c]),s=a.series.visible;return s?this.chart.renderer.crispLine(d,this.graphic.strokeWidth()):null},n.prototype.shouldBeDrawn=function(){return controllableMixin.shouldBeDrawn.call(this)||!!this.options.d},n.prototype.render=function(r){var t=this.options,o=this.attrsFromOptions(t);this.graphic=this.annotation.chart.renderer.path([["M",0,0]]).attr(o).add(r),t.className&&this.graphic.addClass(t.className),this.tracker=this.annotation.chart.renderer.path([["M",0,0]]).addClass("highcharts-tracker-line").attr({zIndex:2}).add(r),this.annotation.chart.styledMode||this.tracker.attr({"stroke-linejoin":"round",stroke:TRACKER_FILL,fill:TRACKER_FILL,"stroke-width":this.graphic.strokeWidth()+t.snap*2}),controllableMixin.render.call(this),extend$K(this.graphic,{markerStartSetter:markerMixin.markerStartSetter,markerEndSetter:markerMixin.markerEndSetter}),this.setMarkers(this)},n.prototype.redraw=function(r){var t=this.toD(),o=r?"animate":"attr";t?(this.graphic[o]({d:t}),this.tracker[o]({d:t})):(this.graphic.attr({d:"M 0 "+-9e9}),this.tracker.attr({d:"M 0 "+-9e9})),this.graphic.placed=this.tracker.placed=!!t,controllableMixin.redraw.call(this,r)},n.attrsMap={dashStyle:"dashstyle",strokeWidth:"stroke-width",stroke:"stroke",fill:"fill",zIndex:"zIndex"},n}(),merge$H=Utilities.merge,ControllableRect=function(){function n(r,t,o){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="rect",this.translate=controllableMixin.translateShape,this.init(r,t,o),this.collection="shapes"}return n.prototype.render=function(r){var t=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.rect(0,-9e9,0,0).attr(t).add(r),controllableMixin.render.call(this)},n.prototype.redraw=function(r){var t=this.anchor(this.points[0]).absolutePosition;t?this.graphic[r?"animate":"attr"]({x:t.x,y:t.y,width:this.options.width,height:this.options.height}):this.attr({x:0,y:-9e9}),this.graphic.placed=!!t,controllableMixin.redraw.call(this,r)},n.attrsMap=merge$H(ControllablePath.attrsMap,{width:"width",height:"height"}),n}(),merge$G=Utilities.merge,ControllableCircle=function(){function n(r,t,o){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="circle",this.translate=controllableMixin.translateShape,this.init(r,t,o),this.collection="shapes"}return n.prototype.render=function(r){var t=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.circle(0,-9e9,0).attr(t).add(r),controllableMixin.render.call(this)},n.prototype.redraw=function(r){var t=this.anchor(this.points[0]).absolutePosition;t?this.graphic[r?"animate":"attr"]({x:t.x,y:t.y,r:this.options.r}):this.graphic.attr({x:0,y:-9e9}),this.graphic.placed=!!t,controllableMixin.redraw.call(this,r)},n.prototype.setRadius=function(r){this.options.r=r},n.attrsMap=merge$G(ControllablePath.attrsMap,{r:"r"}),n}(),format$2=FormatUtilities.format,symbols$2=SVGRenderer.prototype.symbols,extend$J=Utilities.extend,isNumber$k=Utilities.isNumber,pick$L=Utilities.pick,ControllableLabel=function(){function n(r,t,o){this.addControlPoints=controllableMixin.addControlPoints,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.init(r,t,o),this.collection="labels"}return n.alignedPosition=function(r,t){var o=r.align,s=r.verticalAlign,a=(t.x||0)+(r.x||0),l=(t.y||0)+(r.y||0),h,c;return o==="right"?h=1:o==="center"&&(h=2),h&&(a+=(t.width-(r.width||0))/h),s==="bottom"?c=1:s==="middle"&&(c=2),c&&(l+=(t.height-(r.height||0))/c),{x:Math.round(a),y:Math.round(l)}},n.justifiedOptions=function(r,t,o,s){var a=o.align,l=o.verticalAlign,h=t.box?0:t.padding||0,c=t.getBBox(),d={align:a,verticalAlign:l,x:o.x,y:o.y,width:t.width,height:t.height},p=(s.x||0)-r.plotLeft,u=(s.y||0)-r.plotTop,f;return f=p+h,f<0&&(a==="right"?d.align="left":d.x=(d.x||0)-f),f=p+c.width-h,f>r.plotWidth&&(a==="left"?d.align="right":d.x=(d.x||0)+r.plotWidth-f),f=u+h,f<0&&(l==="bottom"?d.verticalAlign="top":d.y=(d.y||0)-f),f=u+c.height-h,f>r.plotHeight&&(l==="top"?d.verticalAlign="bottom":d.y=(d.y||0)+r.plotHeight-f),d},n.prototype.translatePoint=function(r,t){controllableMixin.translatePoint.call(this,r,t,0)},n.prototype.translate=function(r,t){var o=this.annotation.chart,s=this.annotation.userOptions,a=o.annotations.indexOf(this.annotation),l=o.options.annotations,h=l[a];if(o.inverted){var c=r;r=t,t=c}this.options.x+=r,this.options.y+=t,h[this.collection][this.index].x=this.options.x,h[this.collection][this.index].y=this.options.y,s[this.collection][this.index].x=this.options.x,s[this.collection][this.index].y=this.options.y},n.prototype.render=function(r){var t=this.options,o=this.attrsFromOptions(t),s=t.style;this.graphic=this.annotation.chart.renderer.label("",0,-9999,t.shape,null,null,t.useHTML,null,"annotation-label").attr(o).add(r),this.annotation.chart.styledMode||(s.color==="contrast"&&(s.color=this.annotation.chart.renderer.getContrast(n.shapesWithoutBackground.indexOf(t.shape)>-1?"#FFFFFF":t.backgroundColor)),this.graphic.css(t.style).shadow(t.shadow)),t.className&&this.graphic.addClass(t.className),this.graphic.labelrank=t.labelrank,controllableMixin.render.call(this)},n.prototype.redraw=function(r){var t=this.options,o=this.text||t.format||t.text,s=this.graphic,a=this.points[0];s.attr({text:o?format$2(o,a.getLabelConfig(),this.annotation.chart):t.formatter.call(a,this)});var l=this.anchor(a),h=this.position(l);h?(s.alignAttr=h,h.anchorX=l.absolutePosition.x,h.anchorY=l.absolutePosition.y,s[r?"animate":"attr"](h)):s.attr({x:0,y:-9999}),s.placed=!!h,controllableMixin.redraw.call(this,r)},n.prototype.anchor=function(r){var t=controllableMixin.anchor.apply(this,arguments),o=this.options.x||0,s=this.options.y||0;return t.absolutePosition.x-=o,t.absolutePosition.y-=s,t.relativePosition.x-=o,t.relativePosition.y-=s,t},n.prototype.position=function(r){var t=this.graphic,o=this.annotation.chart,s=this.points[0],a=this.options,l=r.absolutePosition,h=r.relativePosition,c,d,p,u,f=s.series.visible&&MockPoint.prototype.isInsidePlot.call(s),g=t.width,v=g===void 0?0:g,m=t.height,x=m===void 0?0:m;return f&&(a.distance?c=Tooltip.prototype.getPosition.call({chart:o,distance:pick$L(a.distance,16)},v,x,{plotX:h.x,plotY:h.y,negative:s.negative,ttBelow:s.ttBelow,h:h.height||h.width}):a.positioner?c=a.positioner.call(this):(d={x:l.x,y:l.y,width:0,height:0},c=n.alignedPosition(extend$J(a,{width:v,height:x}),d),this.options.overflow==="justify"&&(c=n.alignedPosition(n.justifiedOptions(o,t,a,c),d))),a.crop&&(p=c.x-o.plotLeft,u=c.y-o.plotTop,f=o.isInsidePlot(p,u)&&o.isInsidePlot(p+v,u+x))),f?c:null},n.attrsMap={backgroundColor:"fill",borderColor:"stroke",borderWidth:"stroke-width",zIndex:"zIndex",borderRadius:"r",padding:"padding"},n.shapesWithoutBackground=["connector"],n}();symbols$2.connector=function(n,r,t,o,s){var a=s&&s.anchorX,l=s&&s.anchorY,h,c,d=t/2;return isNumber$k(a)&&isNumber$k(l)&&(h=[["M",a,l]],c=r-l,c<0&&(c=-o-c),c<t&&(d=a<n+t/2?c:t-c),l>r+o?h.push(["L",n+d,r+o]):l<r?h.push(["L",n+d,r]):a<n?h.push(["L",n,r+o/2]):a>n+t&&h.push(["L",n+t,r+o/2])),h||[]};var ControllableImage=function(){function n(r,t,o){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="image",this.translate=controllableMixin.translateShape,this.init(r,t,o),this.collection="shapes"}return n.prototype.render=function(r){var t=this.attrsFromOptions(this.options),o=this.options;this.graphic=this.annotation.chart.renderer.image(o.src,0,-9e9,o.width,o.height).attr(t).add(r),this.graphic.width=o.width,this.graphic.height=o.height,controllableMixin.render.call(this)},n.prototype.redraw=function(r){var t=this.anchor(this.points[0]),o=ControllableLabel.prototype.position.call(this,t);o?this.graphic[r?"animate":"attr"]({x:o.x,y:o.y}):this.graphic.attr({x:0,y:-9e9}),this.graphic.placed=!!o,controllableMixin.redraw.call(this,r)},n.attrsMap={width:"width",height:"height",zIndex:"zIndex"},n}(),getDeferredAnimation=animationExports.getDeferredAnimation,chartProto=Chart$1.prototype,addEvent$t=Utilities.addEvent,defined$j=Utilities.defined,destroyObjectProperties=Utilities.destroyObjectProperties,erase=Utilities.erase,extend$I=Utilities.extend,find$5=Utilities.find,fireEvent$a=Utilities.fireEvent,merge$F=Utilities.merge,pick$K=Utilities.pick,splat$5=Utilities.splat,wrap$a=Utilities.wrap,Annotation=function(){function n(r,t){this.annotation=void 0,this.coll="annotations",this.collection=void 0,this.animationConfig=void 0,this.graphic=void 0,this.group=void 0,this.labelCollector=void 0,this.labelsGroup=void 0,this.shapesGroup=void 0;var o;this.chart=r,this.points=[],this.controlPoints=[],this.coll="annotations",this.labels=[],this.shapes=[],this.options=merge$F(this.defaultOptions,t),this.userOptions=t,o=this.getLabelsAndShapesOptions(this.options,t),this.options.labels=o.labels,this.options.shapes=o.shapes,this.init(r,this.options)}return n.prototype.init=function(){var r=this.chart,t=this.options.animation;this.linkPoints(),this.addControlPoints(),this.addShapes(),this.addLabels(),this.setLabelCollector(),this.animationConfig=getDeferredAnimation(r,t)},n.prototype.getLabelsAndShapesOptions=function(r,t){var o={};return["labels","shapes"].forEach(function(s){r[s]&&(t[s]?o[s]=splat$5(t[s]).map(function(a,l){return merge$F(r[s][l],a)}):o[s]=r[s])}),o},n.prototype.addShapes=function(){(this.options.shapes||[]).forEach(function(r,t){var o=this.initShape(r,t);merge$F(!0,this.options.shapes[t],o.options)},this)},n.prototype.addLabels=function(){(this.options.labels||[]).forEach(function(r,t){var o=this.initLabel(r,t);merge$F(!0,this.options.labels[t],o.options)},this)},n.prototype.addClipPaths=function(){this.setClipAxes(),this.clipXAxis&&this.clipYAxis&&(this.clipRect=this.chart.renderer.clipRect(this.getClipBox()))},n.prototype.setClipAxes=function(){var r=this.chart.xAxis,t=this.chart.yAxis,o=(this.options.labels||[]).concat(this.options.shapes||[]).reduce(function(s,a){var l=a&&(a.point||a.points&&a.points[0]);return[r[l&&l.xAxis]||s[0],t[l&&l.yAxis]||s[1]]},[]);this.clipXAxis=o[0],this.clipYAxis=o[1]},n.prototype.getClipBox=function(){if(this.clipXAxis&&this.clipYAxis)return{x:this.clipXAxis.left,y:this.clipYAxis.top,width:this.clipXAxis.width,height:this.clipYAxis.height}},n.prototype.setLabelCollector=function(){var r=this;r.labelCollector=function(){return r.labels.reduce(function(t,o){return o.options.allowOverlap||t.push(o.graphic),t},[])},r.chart.labelCollectors.push(r.labelCollector)},n.prototype.setOptions=function(r){this.options=merge$F(this.defaultOptions,r)},n.prototype.redraw=function(r){this.linkPoints(),this.graphic||this.render(),this.clipRect&&this.clipRect.animate(this.getClipBox()),this.redrawItems(this.shapes,r),this.redrawItems(this.labels,r),controllableMixin.redraw.call(this,r)},n.prototype.redrawItems=function(r,t){for(var o=r.length;o--;)this.redrawItem(r[o],t)},n.prototype.renderItems=function(r){for(var t=r.length;t--;)this.renderItem(r[t])},n.prototype.render=function(){var r=this.chart.renderer;this.graphic=r.g("annotation").attr({opacity:0,zIndex:this.options.zIndex,visibility:this.options.visible?"visible":"hidden"}).add(),this.shapesGroup=r.g("annotation-shapes").add(this.graphic).clip(this.chart.plotBoxClip),this.labelsGroup=r.g("annotation-labels").attr({translateX:0,translateY:0}).add(this.graphic),this.addClipPaths(),this.clipRect&&this.graphic.clip(this.clipRect),this.renderItems(this.shapes),this.renderItems(this.labels),this.addEvents(),controllableMixin.render.call(this)},n.prototype.setVisibility=function(r){var t=this.options,o=this.chart.navigationBindings,s=pick$K(r,!t.visible);this.graphic.attr("visibility",s?"visible":"hidden"),s||(this.setControlPointsVisibility(!1),o.activeAnnotation===this&&o.popup&&o.popup.formType==="annotation-toolbar"&&fireEvent$a(o,"closePopup")),t.visible=s},n.prototype.setControlPointsVisibility=function(r){var t=function(o){o.setControlPointsVisibility(r)};controllableMixin.setControlPointsVisibility.call(this,r),this.shapes.forEach(t),this.labels.forEach(t)},n.prototype.destroy=function(){var r=this.chart,t=function(o){o.destroy()};this.labels.forEach(t),this.shapes.forEach(t),this.clipXAxis=null,this.clipYAxis=null,erase(r.labelCollectors,this.labelCollector),eventEmitterMixin.destroy.call(this),controllableMixin.destroy.call(this),destroyObjectProperties(this,r)},n.prototype.remove=function(){return this.chart.removeAnnotation(this)},n.prototype.update=function(r,t){var o=this.chart,s=this.getLabelsAndShapesOptions(this.userOptions,r),a=o.annotations.indexOf(this),l=merge$F(!0,this.userOptions,r);l.labels=s.labels,l.shapes=s.shapes,this.destroy(),this.constructor(o,l),o.options.annotations[a]=l,this.isUpdating=!0,pick$K(t,!0)&&o.redraw(),fireEvent$a(this,"afterUpdate"),this.isUpdating=!1},n.prototype.initShape=function(r,t){var o=merge$F(this.options.shapeOptions,{controlPointOptions:this.options.controlPointOptions},r),s=new n.shapesMap[o.type](this,o,t);return s.itemType="shape",this.shapes.push(s),s},n.prototype.initLabel=function(r,t){var o=merge$F(this.options.labelOptions,{controlPointOptions:this.options.controlPointOptions},r),s=new ControllableLabel(this,o,t);return s.itemType="label",this.labels.push(s),s},n.prototype.redrawItem=function(r,t){r.linkPoints(),r.shouldBeDrawn()?(r.graphic||this.renderItem(r),r.redraw(pick$K(t,!0)&&r.graphic.placed),r.points.length&&this.adjustVisibility(r)):this.destroyItem(r)},n.prototype.adjustVisibility=function(r){var t=!1,o=r.graphic;r.points.forEach(function(s){s.series.visible!==!1&&s.visible!==!1&&(t=!0)}),t?o.visibility==="hidden"&&o.show():o.hide()},n.prototype.destroyItem=function(r){erase(this[r.itemType+"s"],r),r.destroy()},n.prototype.renderItem=function(r){r.render(r.itemType==="label"?this.labelsGroup:this.shapesGroup)},n.ControlPoint=ControlPoint,n.MockPoint=MockPoint,n.shapesMap={rect:ControllableRect,circle:ControllableCircle,path:ControllablePath,image:ControllableImage},n.types={},n}();merge$F(!0,Annotation.prototype,controllableMixin,eventEmitterMixin,merge$F(Annotation.prototype,{nonDOMEvents:["add","afterUpdate","drag","remove"],defaultOptions:{visible:!0,animation:{},draggable:"xy",labelOptions:{align:"center",allowOverlap:!1,backgroundColor:"rgba(0, 0, 0, 0.75)",borderColor:palette.neutralColor100,borderRadius:3,borderWidth:1,className:"highcharts-no-tooltip",crop:!1,formatter:function(){return defined$j(this.y)?this.y:"Annotation label"},includeInDataExport:!0,overflow:"justify",padding:5,shadow:!1,shape:"callout",style:{fontSize:"11px",fontWeight:"normal",color:"contrast"},useHTML:!1,verticalAlign:"bottom",x:0,y:-16},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1,fill:"rgba(0, 0, 0, 0.75)",r:0,snap:2},controlPointOptions:{symbol:"circle",width:10,height:10,style:{stroke:palette.neutralColor100,"stroke-width":2,fill:palette.backgroundColor},visible:!1,events:{}},events:{},zIndex:6}}));H.extendAnnotation=function(n,r,t,o){r=r||Annotation,extend$I(n.prototype,merge$F(r.prototype,t)),n.prototype.defaultOptions=merge$F(n.prototype.defaultOptions,o||{})};extend$I(chartProto,{initAnnotation:function(n){var r=Annotation.types[n.type]||Annotation,t=new r(this,n);return this.annotations.push(t),t},addAnnotation:function(n,r){var t=this.initAnnotation(n);return this.options.annotations.push(t.options),pick$K(r,!0)&&(t.redraw(),t.graphic.attr({opacity:1})),t},removeAnnotation:function(n){var r=this.annotations,t=n.coll==="annotations"?n:find$5(r,function(o){return o.options.id===n});t&&(fireEvent$a(t,"remove"),erase(this.options.annotations,t.options),erase(r,t),t.destroy())},drawAnnotations:function(){this.plotBoxClip.attr(this.plotBox),this.annotations.forEach(function(n){n.redraw(),n.graphic.animate({opacity:1},n.animationConfig)})}});chartProto.collectionsWithUpdate.push("annotations");chartProto.collectionsWithInit.annotations=[chartProto.addAnnotation];addEvent$t(Chart$1,"afterInit",function(){this.annotations=[],this.options.annotations||(this.options.annotations=[])});chartProto.callbacks.push(function(n){n.plotBoxClip=this.renderer.clipRect(this.plotBox),n.controlPointsGroup=n.renderer.g("control-points").attr({zIndex:99}).clip(n.plotBoxClip).add(),n.options.annotations.forEach(function(r,t){if(!n.annotations.some(function(s){return s.options===r})){var o=n.initAnnotation(r);n.options.annotations[t]=o.options}}),n.drawAnnotations(),addEvent$t(n,"redraw",n.drawAnnotations),addEvent$t(n,"destroy",function(){n.plotBoxClip.destroy(),n.controlPointsGroup.destroy()}),addEvent$t(n,"exportData",function(r){var t=n.annotations,o=(this.options.exporting&&this.options.exporting.csv||{}).columnHeaderFormatter,s=!r.dataRows[1].xValues,a=n.options.lang&&n.options.lang.exportData&&n.options.lang.exportData.annotationHeader,l=function(v){var m;return o&&(m=o(v),m!==!1)?m:(m=a+" "+v,s?{columnTitle:m,topLevelColumnTitle:m}:m)},h=r.dataRows[0].length,c=n.options.exporting&&n.options.exporting.csv&&n.options.exporting.csv.annotations&&n.options.exporting.csv.annotations.itemDelimiter,d=n.options.exporting&&n.options.exporting.csv&&n.options.exporting.csv.annotations&&n.options.exporting.csv.annotations.join;t.forEach(function(v){v.options.labelOptions.includeInDataExport&&v.labels.forEach(function(m){if(m.options.text){var x=m.options.text;m.points.forEach(function(y){var b=y.x,$=y.series.xAxis?y.series.xAxis.options.index:-1,S=!1;if($===-1){for(var k=r.dataRows[0].length,A=new Array(k),P=0;P<k;++P)A[P]="";A.push(x),A.xValues=[],A.xValues[$]=b,r.dataRows.push(A),S=!0}if(S||r.dataRows.forEach(function(E,M){!S&&E.xValues&&$!==void 0&&b===E.xValues[$]&&(d&&E.length>h?E[E.length-1]+=c+x:E.push(x),S=!0)}),!S){for(var k=r.dataRows[0].length,A=new Array(k),P=0;P<k;++P)A[P]="";A[0]=b,A.push(x),A.xValues=[],$!==void 0&&(A.xValues[$]=b),r.dataRows.push(A)}})}})});var p=0;r.dataRows.forEach(function(v){p=Math.max(p,v.length)});for(var u=p-r.dataRows[0].length,f=0;f<u;f++){var g=l(f+1);s?(r.dataRows[0].push(g.topLevelColumnTitle),r.dataRows[1].push(g.columnTitle)):r.dataRows[0].push(g)}})});wrap$a(Pointer.prototype,"onContainerMouseDown",function(n){this.chart.hasDraggedAnnotation||n.apply(this,Array.prototype.slice.call(arguments,1))});H.Annotation=Annotation;var chartNavigation={initUpdate:function(n){n.navigation||(n.navigation={updates:[],update:function(r,t){this.updates.forEach(function(o){o.update.call(o.context,r,t)})}})},addUpdate:function(n,r){r.navigation||this.initUpdate(r),r.navigation.updates.push({update:n,context:r})}},format$1=FormatUtilities.format,setOptions$1=DefaultOptions.setOptions,addEvent$s=Utilities.addEvent,attr=Utilities.attr,fireEvent$9=Utilities.fireEvent,isArray$7=Utilities.isArray,isFunction$1=Utilities.isFunction,isNumber$j=Utilities.isNumber,isObject$6=Utilities.isObject,merge$E=Utilities.merge,objectEach$b=Utilities.objectEach,pick$J=Utilities.pick,doc$4=H.doc,win$2=H.win,PREFIX$1="highcharts-";function closestPolyfill(n,r){var t=win$2.Element.prototype,o=t.matches||t.msMatchesSelector||t.webkitMatchesSelector,s=null;if(t.closest)s=t.closest.call(n,r);else do{if(o.call(n,r))return n;n=n.parentElement||n.parentNode}while(n!==null&&n.nodeType===1);return s}var bindingsUtils={getFieldType:function(n){return{string:"text",number:"number",boolean:"checkbox"}[typeof n]},updateRectSize:function(n,r){var t=r.chart,o=r.options.typeOptions,s=isNumber$j(o.xAxis)&&t.xAxis[o.xAxis],a=isNumber$j(o.yAxis)&&t.yAxis[o.yAxis];if(s&&a){var l=s.toValue(n[s.horiz?"chartX":"chartY"]),h=a.toValue(n[a.horiz?"chartX":"chartY"]),c=l-o.point.x,d=o.point.y-h;r.update({typeOptions:{background:{width:t.inverted?d:c,height:t.inverted?c:d}}})}},getAssignedAxis:function(n){return n.filter(function(r){var t=r.axis.min,o=r.axis.max,s=pick$J(r.axis.minPointOffset,0);return isNumber$j(t)&&isNumber$j(o)&&r.value>=t-s&&r.value<=o+s&&!r.axis.options.isInternal})[0]}},NavigationBindings=function(){function n(r,t){this.boundClassNames=void 0,this.selectedButton=void 0,this.chart=r,this.options=t,this.eventsToUnbind=[],this.container=doc$4.getElementsByClassName(this.options.bindingsClassName||"")}return n.prototype.initEvents=function(){var r=this,t=r.chart,o=r.container,s=r.options;r.boundClassNames={},objectEach$b(s.bindings||{},function(a){r.boundClassNames[a.className]=a}),[].forEach.call(o,function(a){r.eventsToUnbind.push(addEvent$s(a,"click",function(l){var h=r.getButtonEvents(a,l);h&&h.button.className.indexOf("highcharts-disabled-btn")===-1&&r.bindingsButtonClick(h.button,h.events,l)}))}),objectEach$b(s.events||{},function(a,l){isFunction$1(a)&&r.eventsToUnbind.push(addEvent$s(r,l,a,{passive:!1}))}),r.eventsToUnbind.push(addEvent$s(t.container,"click",function(a){!t.cancelClick&&t.isInsidePlot(a.chartX-t.plotLeft,a.chartY-t.plotTop,{visiblePlotOnly:!0})&&r.bindingsChartClick(this,a)})),r.eventsToUnbind.push(addEvent$s(t.container,H.isTouchDevice?"touchmove":"mousemove",function(a){r.bindingsContainerMouseMove(this,a)},H.isTouchDevice?{passive:!1}:void 0))},n.prototype.initUpdate=function(){var r=this;chartNavigation.addUpdate(function(t){r.update(t)},this.chart)},n.prototype.bindingsButtonClick=function(r,t,o){var s=this,a=s.chart;s.selectedButtonElement&&(fireEvent$9(s,"deselectButton",{button:s.selectedButtonElement}),s.nextEvent&&(s.currentUserDetails&&s.currentUserDetails.coll==="annotations"&&a.removeAnnotation(s.currentUserDetails),s.mouseMoveEvent=s.nextEvent=!1)),s.selectedButton=t,s.selectedButtonElement=r,fireEvent$9(s,"selectButton",{button:r}),t.init&&t.init.call(s,r,o),(t.start||t.steps)&&a.renderer.boxWrapper.addClass(PREFIX$1+"draw-mode")},n.prototype.bindingsChartClick=function(r,t){r=this.chart;var o=this,s=o.activeAnnotation,a=o.selectedButton,l=r.renderer.boxWrapper;s&&(!s.cancelClick&&!t.activeAnnotation&&t.target.parentNode&&!closestPolyfill(t.target,"."+PREFIX$1+"popup")?fireEvent$9(o,"closePopup"):s.cancelClick&&setTimeout(function(){s.cancelClick=!1},0)),!(!a||!a.start)&&(o.nextEvent?(o.nextEvent(t,o.currentUserDetails),o.steps&&(o.stepIndex++,a.steps[o.stepIndex]?o.mouseMoveEvent=o.nextEvent=a.steps[o.stepIndex]:(fireEvent$9(o,"deselectButton",{button:o.selectedButtonElement}),l.removeClass(PREFIX$1+"draw-mode"),a.end&&a.end.call(o,t,o.currentUserDetails),o.nextEvent=!1,o.mouseMoveEvent=!1,o.selectedButton=null))):(o.currentUserDetails=a.start.call(o,t),o.currentUserDetails&&a.steps?(o.stepIndex=0,o.steps=!0,o.mouseMoveEvent=o.nextEvent=a.steps[o.stepIndex]):(fireEvent$9(o,"deselectButton",{button:o.selectedButtonElement}),l.removeClass(PREFIX$1+"draw-mode"),o.steps=!1,o.selectedButton=null,a.end&&a.end.call(o,t,o.currentUserDetails))))},n.prototype.bindingsContainerMouseMove=function(r,t){this.mouseMoveEvent&&this.mouseMoveEvent(t,this.currentUserDetails)},n.prototype.fieldsToOptions=function(r,t){return objectEach$b(r,function(o,s){var a=parseFloat(o),l=s.split("."),h=t,c=l.length-1;isNumber$j(a)&&!o.match(/px/g)&&!s.match(/format/g)&&(o=a),o!==""&&o!=="undefined"&&l.forEach(function(d,p){var u=pick$J(l[p+1],"");c===p?h[d]=o:(h[d]||(h[d]=u.match(/\d/g)?[]:{}),h=h[d])})}),t},n.prototype.deselectAnnotation=function(){this.activeAnnotation&&(this.activeAnnotation.setControlPointsVisibility(!1),this.activeAnnotation=!1)},n.prototype.annotationToFields=function(r){var t=r.options,o=n.annotationsEditable,s=o.nestedOptions,a=this.utils.getFieldType,l=pick$J(t.type,t.shapes&&t.shapes[0]&&t.shapes[0].type,t.labels&&t.labels[0]&&t.labels[0].itemType,"label"),h=n.annotationsNonEditable[t.langKey]||[],c={langKey:t.langKey,type:l};function d(p,u,f,g){var v;f&&p&&h.indexOf(u)===-1&&((f.indexOf&&f.indexOf(u))>=0||f[u]||f===!0)&&(isArray$7(p)?(g[u]=[],p.forEach(function(m,x){isObject$6(m)?(g[u][x]={},objectEach$b(m,function(y,b){d(y,b,s[u],g[u][x])})):d(m,0,s[u],g[u])})):isObject$6(p)?(v={},isArray$7(g)?(g.push(v),v[u]={},v=v[u]):g[u]=v,objectEach$b(p,function(m,x){d(m,x,u===0?f:s[u],v)})):u==="format"?g[u]=[format$1(p,r.labels[0].points[0]).toString(),"text"]:isArray$7(g)?g.push([p,a(p)]):g[u]=[p,a(p)])}return objectEach$b(t,function(p,u){u==="typeOptions"?(c[u]={},objectEach$b(t[u],function(f,g){d(f,g,s,c[u])})):d(p,u,o[l],c)}),c},n.prototype.getClickedClassNames=function(r,t){for(var o=t.target,s=[],a;o;)if(a=attr(o,"class"),a&&(s=s.concat(a.split(" ").map(function(l){return[l,o]}))),o=o.parentNode,o===r)return s;return s},n.prototype.getButtonEvents=function(r,t){var o=this,s=this.getClickedClassNames(r,t),a;return s.forEach(function(l){o.boundClassNames[l[0]]&&!a&&(a={events:o.boundClassNames[l[0]],button:l[1]})}),a},n.prototype.update=function(r){this.options=merge$E(!0,this.options,r),this.removeEvents(),this.initEvents()},n.prototype.removeEvents=function(){this.eventsToUnbind.forEach(function(r){r()})},n.prototype.destroy=function(){this.removeEvents()},n.annotationsEditable={nestedOptions:{labelOptions:["style","format","backgroundColor"],labels:["style"],label:["style"],style:["fontSize","color"],background:["fill","strokeWidth","stroke"],innerBackground:["fill","strokeWidth","stroke"],outerBackground:["fill","strokeWidth","stroke"],shapeOptions:["fill","strokeWidth","stroke"],shapes:["fill","strokeWidth","stroke"],line:["strokeWidth","stroke"],backgroundColors:[!0],connector:["fill","strokeWidth","stroke"],crosshairX:["strokeWidth","stroke"],crosshairY:["strokeWidth","stroke"]},circle:["shapes"],verticalLine:[],label:["labelOptions"],measure:["background","crosshairY","crosshairX"],fibonacci:[],tunnel:["background","line","height"],pitchfork:["innerBackground","outerBackground"],rect:["shapes"],crookedLine:[],basicAnnotation:["shapes","labelOptions"]},n.annotationsNonEditable={rectangle:["crosshairX","crosshairY","label"]},n}();NavigationBindings.prototype.utils=bindingsUtils;Chart$1.prototype.initNavigationBindings=function(){var n=this,r=n.options;r&&r.navigation&&r.navigation.bindings&&(n.navigationBindings=new NavigationBindings(n,r.navigation),n.navigationBindings.initEvents(),n.navigationBindings.initUpdate())};addEvent$s(Chart$1,"load",function(){this.initNavigationBindings()});addEvent$s(Chart$1,"destroy",function(){this.navigationBindings&&this.navigationBindings.destroy()});addEvent$s(NavigationBindings,"deselectButton",function(){this.selectedButtonElement=null});addEvent$s(Annotation,"remove",function(){this.chart.navigationBindings&&this.chart.navigationBindings.deselectAnnotation()});function selectableAnnotation(n){var r=n.prototype.defaultOptions.events&&n.prototype.defaultOptions.events.click;function t(o){var s=this,a=s.chart.navigationBindings,l=a.activeAnnotation;r&&r.call(s,o),l!==s?(a.deselectAnnotation(),a.activeAnnotation=s,s.setControlPointsVisibility(!0),fireEvent$9(a,"showPopup",{annotation:s,formType:"annotation-toolbar",options:a.annotationToFields(s),onSubmit:function(h){var c={},d;h.actionType==="remove"?(a.activeAnnotation=!1,a.chart.removeAnnotation(s)):(a.fieldsToOptions(h.fields,c),a.deselectAnnotation(),d=c.typeOptions,s.options.type==="measure"&&(d.crosshairY.enabled=d.crosshairY.strokeWidth!==0,d.crosshairX.enabled=d.crosshairX.strokeWidth!==0),s.update(c))}})):fireEvent$9(a,"closePopup"),o.activeAnnotation=!0}merge$E(!0,n.prototype.defaultOptions.events,{click:t})}H.Annotation&&(selectableAnnotation(Annotation),objectEach$b(Annotation.types,function(n){selectableAnnotation(n)}));setOptions$1({lang:{navigation:{popup:{simpleShapes:"Simple shapes",lines:"Lines",circle:"Circle",rectangle:"Rectangle",label:"Label",shapeOptions:"Shape options",typeOptions:"Details",fill:"Fill",format:"Text",strokeWidth:"Line width",stroke:"Line color",title:"Title",name:"Name",labelOptions:"Label options",labels:"Labels",backgroundColor:"Background color",backgroundColors:"Background colors",borderColor:"Border color",borderRadius:"Border radius",borderWidth:"Border width",style:"Style",padding:"Padding",fontSize:"Font size",color:"Color",height:"Height",shapes:"Shape options"}}},navigation:{bindingsClassName:"highcharts-bindings-container",bindings:{circleAnnotation:{className:"highcharts-circle-annotation",start:function(n){var r=this.chart.pointer.getCoordinates(n),t=this.utils.getAssignedAxis(r.xAxis),o=this.utils.getAssignedAxis(r.yAxis),s=this.chart.options.navigation;if(!(!t||!o))return this.chart.addAnnotation(merge$E({langKey:"circle",type:"basicAnnotation",shapes:[{type:"circle",point:{x:t.value,y:o.value,xAxis:t.axis.options.index,yAxis:o.axis.options.index},r:5}]},s.annotationsOptions,s.bindings.circleAnnotation.annotationsOptions))},steps:[function(n,r){var t=r.options.shapes[0].point,o=this.chart.inverted,s,a,l;isNumber$j(t.xAxis)&&isNumber$j(t.yAxis)&&(s=this.chart.xAxis[t.xAxis].toPixels(t.x),a=this.chart.yAxis[t.yAxis].toPixels(t.y),l=Math.max(Math.sqrt(Math.pow(o?a-n.chartX:s-n.chartX,2)+Math.pow(o?s-n.chartY:a-n.chartY,2)),5)),r.update({shapes:[{r:l}]})}]},rectangleAnnotation:{className:"highcharts-rectangle-annotation",start:function(n){var r=this.chart.pointer.getCoordinates(n),t=this.utils.getAssignedAxis(r.xAxis),o=this.utils.getAssignedAxis(r.yAxis);if(!(!t||!o)){var s=t.value,a=o.value,l=t.axis.options.index,h=o.axis.options.index,c=this.chart.options.navigation;return this.chart.addAnnotation(merge$E({langKey:"rectangle",type:"basicAnnotation",shapes:[{type:"path",points:[{xAxis:l,yAxis:h,x:s,y:a},{xAxis:l,yAxis:h,x:s,y:a},{xAxis:l,yAxis:h,x:s,y:a},{xAxis:l,yAxis:h,x:s,y:a}]}]},c.annotationsOptions,c.bindings.rectangleAnnotation.annotationsOptions))}},steps:[function(n,r){var t=r.options.shapes[0].points,o=this.chart.pointer.getCoordinates(n),s=this.utils.getAssignedAxis(o.xAxis),a=this.utils.getAssignedAxis(o.yAxis),l,h;s&&a&&(l=s.value,h=a.value,t[1].x=l,t[2].x=l,t[2].y=h,t[3].y=h,r.update({shapes:[{points:t}]}))}]},labelAnnotation:{className:"highcharts-label-annotation",start:function(n){var r=this.chart.pointer.getCoordinates(n),t=this.utils.getAssignedAxis(r.xAxis),o=this.utils.getAssignedAxis(r.yAxis),s=this.chart.options.navigation;if(!(!t||!o))return this.chart.addAnnotation(merge$E({langKey:"label",type:"basicAnnotation",labelOptions:{format:"{y:.2f}"},labels:[{point:{xAxis:t.axis.options.index,yAxis:o.axis.options.index,x:t.value,y:o.value},overflow:"none",crop:!0}]},s.annotationsOptions,s.bindings.labelAnnotation.annotationsOptions))}}},events:{},annotationsOptions:{animation:{defer:0}}}});addEvent$s(Chart$1,"render",function(){var n=this,r=n.navigationBindings,t="highcharts-disabled-btn";if(n&&r){var o=!1;n.series.forEach(function(s){!s.options.isInternal&&s.visible&&(o=!0)}),objectEach$b(r.boundClassNames,function(s,a){if(n.navigationBindings&&n.navigationBindings.container&&n.navigationBindings.container[0]){var l=n.navigationBindings.container[0].querySelectorAll("."+a);if(l)for(var h=0;h<l.length;h++){var c=l[h];s.noDataState==="normal"||o?c.className.indexOf(t)!==-1&&c.classList.remove(t):c.className.indexOf(t)===-1&&(c.className+=" "+t)}}})}});addEvent$s(NavigationBindings,"closePopup",function(){this.deselectAnnotation()});var doc$3=H.doc,isFirefox=H.isFirefox,getOptions$1=DefaultOptions.getOptions,addEvent$r=Utilities.addEvent,createElement$2=Utilities.createElement,defined$i=Utilities.defined,fireEvent$8=Utilities.fireEvent,isArray$6=Utilities.isArray,isObject$5=Utilities.isObject,isString$1=Utilities.isString,objectEach$a=Utilities.objectEach,pick$I=Utilities.pick,stableSort$3=Utilities.stableSort,wrap$9=Utilities.wrap,indexFilter=/\d/g,PREFIX="highcharts-",DIV="div",INPUT="input",LABEL="label",BUTTON="button",SELECT="select",OPTION="option",SPAN="span",UL="ul",LI="li",H3="h3";wrap$9(Pointer.prototype,"onContainerMouseDown",function(n,r){var t=r.target&&r.target.className;isString$1(t)&&t.indexOf(PREFIX+"popup-field")>=0||n.apply(this,Array.prototype.slice.call(arguments,1))});H.Popup=function(n,r,t){this.init(n,r,t)};H.Popup.prototype={init:function(n,r,t){this.chart=t,this.container=createElement$2(DIV,{className:PREFIX+"popup highcharts-no-tooltip"},null,n),this.lang=this.getLangpack(),this.iconsURL=r,this.addCloseBtn()},addCloseBtn:function(){var n=this,r,t=this.iconsURL;r=createElement$2(DIV,{className:PREFIX+"popup-close"},null,this.container),r.style["background-image"]="url("+(t.match(/png|svg|jpeg|jpg|gif/ig)?t:t+"close.svg")+")",["click","touchstart"].forEach(function(o){addEvent$r(r,o,function(){n.chart?fireEvent$8(n.chart.navigationBindings,"closePopup"):n.closePopup()})})},addColsContainer:function(n){var r,t;return t=createElement$2(DIV,{className:PREFIX+"popup-lhs-col"},null,n),r=createElement$2(DIV,{className:PREFIX+"popup-rhs-col"},null,n),createElement$2(DIV,{className:PREFIX+"popup-rhs-col-wrapper"},null,r),{lhsCol:t,rhsCol:r}},addInput:function(n,r,t,o){var s=n.split("."),a=s[s.length-1],l=this.lang,h=PREFIX+r+"-"+a;h.match(indexFilter)||createElement$2(LABEL,{htmlFor:h},void 0,t).appendChild(doc$3.createTextNode(l[a]||a)),o!==""&&createElement$2(INPUT,{name:h,value:o[0],type:o[1],className:PREFIX+"popup-field"},void 0,t).setAttribute(PREFIX+"data-name",n)},addButton:function(n,r,t,o,s){var a=this,l=this.closePopup,h=this.getFields,c;return c=createElement$2(BUTTON,void 0,void 0,n),c.appendChild(doc$3.createTextNode(r)),["click","touchstart"].forEach(function(d){addEvent$r(c,d,function(){return l.call(a),o(h(s,t))})}),c},getFields:function(n,r){var t=n.querySelectorAll("input"),o="#"+PREFIX+"select-series > option:checked",s="#"+PREFIX+"select-volume > option:checked",a=n.querySelectorAll(o)[0],l=n.querySelectorAll(s)[0],h,c,d;return d={actionType:r,linkedTo:a&&a.getAttribute("value"),fields:{}},[].forEach.call(t,function(p){c=p.getAttribute(PREFIX+"data-name"),h=p.getAttribute(PREFIX+"data-series-id"),h?d.seriesId=p.value:c?d.fields[c]=p.value:d.type=p.value}),l&&(d.fields["params.volumeSeriesID"]=l.getAttribute("value")),d},showPopup:function(){var n=this.container,r=PREFIX+"annotation-toolbar",t=n.querySelectorAll("."+PREFIX+"popup-close")[0];this.formType=void 0,n.innerHTML="",n.className.indexOf(r)>=0&&(n.classList.remove(r),n.removeAttribute("style")),n.appendChild(t),n.style.display="block",n.style.height=""},closePopup:function(){var n=pick$I(this.popup&&this.popup.container,this.container);n.style.display="none"},showForm:function(n,r,t,o){r&&(this.popup=r.navigationBindings.popup,this.showPopup(),n==="indicators"&&this.indicators.addForm.call(this,r,t,o),n==="annotation-toolbar"&&this.annotations.addToolbar.call(this,r,t,o),n==="annotation-edit"&&this.annotations.addForm.call(this,r,t,o),n==="flag"&&this.annotations.addForm.call(this,r,t,o,!0),this.formType=n,this.container.style.height=this.container.offsetHeight+"px")},getLangpack:function(){return getOptions$1().lang.navigation.popup},annotations:{addToolbar:function(n,r,t){var o=this,s=this.lang,a=this.popup.container,l=this.showForm,h=PREFIX+"annotation-toolbar",c;a.className.indexOf(h)===-1&&(a.className+=" "+h),n&&(a.style.top=n.plotTop+10+"px"),createElement$2(SPAN,void 0,void 0,a).appendChild(doc$3.createTextNode(pick$I(s[r.langKey]||r.langKey,r.shapes&&r.shapes[0].type))),c=this.addButton(a,s.removeButton||"remove","remove",t,a),c.className+=" "+PREFIX+"annotation-remove-button",c.style["background-image"]="url("+this.iconsURL+"destroy.svg)",c=this.addButton(a,s.editButton||"edit","edit",function(){l.call(o,"annotation-edit",n,r,t)},a),c.className+=" "+PREFIX+"annotation-edit-button",c.style["background-image"]="url("+this.iconsURL+"edit.svg)"},addForm:function(n,r,t,o){var s=this.popup.container,a=this.lang,l,h;n&&(h=createElement$2("h2",{className:PREFIX+"popup-main-title"},void 0,s),h.appendChild(doc$3.createTextNode(a[r.langKey]||r.langKey||"")),h=createElement$2(DIV,{className:PREFIX+"popup-lhs-col "+PREFIX+"popup-lhs-full"},null,s),l=createElement$2(DIV,{className:PREFIX+"popup-bottom-row"},null,s),this.annotations.addFormFields.call(this,h,n,"",r,[],!0),this.addButton(l,o?a.addButton||"add":a.saveButton||"save",o?"add":"save",t,s))},addFormFields:function(n,r,t,o,s,a){var l=this,h=this.annotations.addFormFields,c=this.addInput,d=this.lang,p,u;r&&(objectEach$a(o,function(f,g){p=t!==""?t+"."+g:g,isObject$5(f)&&(!isArray$6(f)||isArray$6(f)&&isObject$5(f[0])?(u=d[g]||g,u.match(indexFilter)||s.push([!0,u,n]),h.call(l,n,r,p,f,s,!1)):s.push([l,p,"annotation",n,f]))}),a&&(stableSort$3(s,function(f){return f[1].match(/format/g)?-1:1}),isFirefox&&s.reverse(),s.forEach(function(f){f[0]===!0?createElement$2(SPAN,{className:PREFIX+"annotation-title"},void 0,f[2]).appendChild(doc$3.createTextNode(f[1])):c.apply(f[0],f.splice(1))})))}},indicators:{addForm:function(n,r,t){var o,s=this.indicators,a=this.lang,l;n&&(this.tabs.init.call(this,n),o=this.popup.container.querySelectorAll("."+PREFIX+"tab-item-content"),this.addColsContainer(o[0]),s.addIndicatorList.call(this,n,o[0],"add"),l=o[0].querySelectorAll("."+PREFIX+"popup-rhs-col")[0],this.addButton(l,a.addButton||"add","add",t,l),this.addColsContainer(o[1]),s.addIndicatorList.call(this,n,o[1],"edit"),l=o[1].querySelectorAll("."+PREFIX+"popup-rhs-col")[0],this.addButton(l,a.saveButton||"save","edit",t,l),this.addButton(l,a.removeButton||"remove","remove",t,l))},addIndicatorList:function(n,r,t){var o=this,s=r.querySelectorAll("."+PREFIX+"popup-lhs-col")[0],a=r.querySelectorAll("."+PREFIX+"popup-rhs-col")[0],l=t==="edit",h=l?n.series:n.options.plotOptions,c=this.indicators.addFormFields,d,p,u;n&&(p=createElement$2(UL,{className:PREFIX+"indicator-list"},null,s),d=a.querySelectorAll("."+PREFIX+"popup-rhs-col-wrapper")[0],objectEach$a(h,function(f,g){var v=f.options;if(f.params||v&&v.params){var m=o.indicators.getNameType(f,g),x=m.type;u=createElement$2(LI,{className:PREFIX+"indicator-list"},void 0,p),u.appendChild(doc$3.createTextNode(m.name)),["click","touchstart"].forEach(function(y){addEvent$r(u,y,function(){c.call(o,n,l?f:h[x],m.type,d),l&&f.options&&createElement$2(INPUT,{type:"hidden",name:PREFIX+"id-"+x,value:f.options.id},null,d).setAttribute(PREFIX+"data-series-id",f.options.id)})})}}),p.childNodes.length>0&&p.childNodes[0].click())},getNameType:function(n,r){var t=n.options,o=H.seriesTypes,s=o[r]&&o[r].prototype.nameBase||r.toUpperCase(),a=r;return t&&t.type&&(a=n.options.type,s=n.name),{name:s,type:a}},listAllSeries:function(n,r,t,o,s){var a=PREFIX+r+"-type-"+n,l=this.lang,h,c;t&&(createElement$2(LABEL,{htmlFor:a},null,o).appendChild(doc$3.createTextNode(l[r]||r)),h=createElement$2(SELECT,{name:a,className:PREFIX+"popup-field"},null,o),h.setAttribute("id",PREFIX+"select-"+r),t.series.forEach(function(d){c=d.options,!c.params&&c.id&&c.id!==PREFIX+"navigator-series"&&createElement$2(OPTION,{value:c.id},null,h).appendChild(doc$3.createTextNode(c.name||c.id))}),defined$i(s)&&(h.value=s))},addFormFields:function(n,r,t,o){var s=r.params||r.options.params,a=this.indicators.getNameType;o.innerHTML="",createElement$2(H3,{className:PREFIX+"indicator-title"},void 0,o).appendChild(doc$3.createTextNode(a(r,t).name)),createElement$2(INPUT,{type:"hidden",name:PREFIX+"type-"+t,value:t},null,o),this.indicators.listAllSeries.call(this,t,"series",n,o,r.linkedParent&&s.volumeSeriesID),s.volumeSeriesID&&this.indicators.listAllSeries.call(this,t,"volume",n,o,r.linkedParent&&r.linkedParent.options.id),this.indicators.addParamInputs.call(this,n,"params",s,t,o)},addParamInputs:function(n,r,t,o,s){var a=this,l=this.indicators.addParamInputs,h=this.addInput,c;n&&objectEach$a(t,function(d,p){c=r+"."+p,d!==void 0&&(isObject$5(d)?(h.call(a,c,o,s,""),l.call(a,n,c,d,o,s)):c!=="params.volumeSeriesID"&&h.call(a,c,o,s,[d,"text"]))})},getAmount:function(){var n=this.series,r=0;return n.forEach(function(t){var o=t.options;(t.params||o&&o.params)&&r++}),r}},tabs:{init:function(n){var r=this.tabs,t=this.indicators.getAmount.call(n),o;n&&(o=r.addMenuItem.call(this,"add"),r.addMenuItem.call(this,"edit",t),r.addContentItem.call(this,"add"),r.addContentItem.call(this,"edit"),r.switchTabs.call(this,t),r.selectTab.call(this,o,0))},addMenuItem:function(n,r){var t=this.popup.container,o=PREFIX+"tab-item",s=this.lang,a;return r===0&&(o+=" "+PREFIX+"tab-disabled"),a=createElement$2(SPAN,{className:o},void 0,t),a.appendChild(doc$3.createTextNode(s[n+"Button"]||n)),a.setAttribute(PREFIX+"data-tab-type",n),a},addContentItem:function(){var n=this.popup.container;return createElement$2(DIV,{className:PREFIX+"tab-item-content "+PREFIX+"no-mousewheel"},null,n)},switchTabs:function(n){var r=this,t=this.popup.container,o=t.querySelectorAll("."+PREFIX+"tab-item"),s;o.forEach(function(a,l){s=a.getAttribute(PREFIX+"data-tab-type"),!(s==="edit"&&n===0)&&["click","touchstart"].forEach(function(h){addEvent$r(a,h,function(){r.tabs.deselectAll.call(r),r.tabs.selectTab.call(r,this,l)})})})},selectTab:function(n,r){var t=this.popup.container.querySelectorAll("."+PREFIX+"tab-item-content");n.className+=" "+PREFIX+"tab-item-active",t[r].className+=" "+PREFIX+"tab-item-show"},deselectAll:function(){var n=this.popup.container,r=n.querySelectorAll("."+PREFIX+"tab-item"),t=n.querySelectorAll("."+PREFIX+"tab-item-content"),o;for(o=0;o<r.length;o++)r[o].classList.remove(PREFIX+"tab-item-active"),t[o].classList.remove(PREFIX+"tab-item-show")}}};addEvent$r(NavigationBindings,"showPopup",function(n){this.popup||(this.popup=new H.Popup(this.chart.container,this.chart.options.navigation.iconsURL||this.chart.options.stockTools&&this.chart.options.stockTools.gui.iconsURL||"https://code.highcharts.com/9.2.2/gfx/stock-icons/",this.chart)),this.popup.showForm(n.formType,this.chart,n.options,n.onSubmit)});addEvent$r(NavigationBindings,"closePopup",function(){this.popup&&this.popup.closePopup()});H.Popup;var addEvent$q=Utilities.addEvent,extend$H=Utilities.extend,merge$D=Utilities.merge,pick$H=Utilities.pick,splat$4=Utilities.splat;Chart$1.prototype.collectionsWithUpdate.push("pane");var Pane=function(){function n(r,t){this.background=void 0,this.center=void 0,this.chart=void 0,this.options=void 0,this.coll="pane",this.defaultOptions={center:["50%","50%"],size:"85%",innerSize:"0%",startAngle:0},this.defaultBackgroundOptions={shape:"circle",borderWidth:1,borderColor:palette.neutralColor20,backgroundColor:{linearGradient:{x1:0,y1:0,x2:0,y2:1},stops:[[0,palette.backgroundColor],[1,palette.neutralColor10]]},from:-Number.MAX_VALUE,innerRadius:0,to:Number.MAX_VALUE,outerRadius:"105%"},this.init(r,t)}return n.prototype.init=function(r,t){this.chart=t,this.background=[],t.pane.push(this),this.setOptions(r)},n.prototype.setOptions=function(r){this.options=r=merge$D(this.defaultOptions,this.chart.angular?{background:{}}:void 0,r)},n.prototype.render=function(){var r=this.options,t=this.options.background,o=this.chart.renderer,s,a;if(this.group||(this.group=o.g("pane-group").attr({zIndex:r.zIndex||0}).add()),this.updateCenter(),t)for(t=splat$4(t),s=Math.max(t.length,this.background.length||0),a=0;a<s;a++)t[a]&&this.axis?this.renderBackground(merge$D(this.defaultBackgroundOptions,t[a]),a):this.background[a]&&(this.background[a]=this.background[a].destroy(),this.background.splice(a,1))},n.prototype.renderBackground=function(r,t){var o="animate",s={class:"highcharts-pane "+(r.className||"")};this.chart.styledMode||extend$H(s,{fill:r.backgroundColor,stroke:r.borderColor,"stroke-width":r.borderWidth}),this.background[t]||(this.background[t]=this.chart.renderer.path().add(this.group),o="attr"),this.background[t][o]({d:this.axis.getPlotBandPath(r.from,r.to,r)}).attr(s)},n.prototype.updateCenter=function(r){this.center=(r||this.axis||{}).center=centeredSeriesMixin.getCenter.call(this)},n.prototype.update=function(r,t){merge$D(!0,this.options,r),this.setOptions(this.options),this.render(),this.chart.axes.forEach(function(o){o.pane===this&&(o.pane=null,o.update({},t))},this)},n}();function isInsidePane(n,r,t){return Math.sqrt(Math.pow(n-t[0],2)+Math.pow(r-t[1],2))<=t[2]/2}Chart$1.prototype.getHoverPane=function(n){var r=this,t;return n&&r.pane.forEach(function(o){var s=n.chartX-r.plotLeft,a=n.chartY-r.plotTop,l=r.inverted?a:s,h=r.inverted?s:a;isInsidePane(l,h,o.center)&&(t=o)}),t};addEvent$q(Chart$1,"afterIsInsidePlot",function(n){var r=this;r.polar&&(n.isInsidePlot=r.pane.some(function(t){return isInsidePane(n.x,n.y,t.center)}))});addEvent$q(Pointer,"beforeGetHoverData",function(n){var r=this.chart;r.polar?(r.hoverPane=r.getHoverPane(n),n.filter=function(t){return t.visible&&!(!n.shared&&t.directTouch)&&pick$H(t.options.enableMouseTracking,!0)&&(!r.hoverPane||t.xAxis.pane===r.hoverPane)}):r.hoverPane=void 0});addEvent$q(Pointer,"afterGetHoverData",function(n){var r=this.chart;n.hoverPoint&&n.hoverPoint.plotX&&n.hoverPoint.plotY&&r.hoverPane&&!isInsidePane(n.hoverPoint.plotX,n.hoverPoint.plotY,r.hoverPane.center)&&(n.hoverPoint=void 0)});H.Pane=Pane;const Pane$1=H.Pane;var defaultOptions$3=DefaultOptions.defaultOptions,noop$c=H.noop,addEvent$p=Utilities.addEvent,correctFloat$3=Utilities.correctFloat,defined$h=Utilities.defined,extend$G=Utilities.extend,fireEvent$7=Utilities.fireEvent,merge$C=Utilities.merge,pick$G=Utilities.pick,relativeLength$2=Utilities.relativeLength,wrap$8=Utilities.wrap,RadialAxis;(function(n){var r=[],t={gridLineWidth:1,labels:{align:void 0,distance:15,x:0,y:void 0,style:{textOverflow:"none"}},maxPadding:0,minPadding:0,showLastLabel:!1,tickLength:0},o={labels:{align:"center",x:0,y:void 0},minorGridLineWidth:0,minorTickInterval:"auto",minorTickLength:10,minorTickPosition:"inside",minorTickWidth:1,tickLength:10,tickPosition:"inside",tickWidth:2,title:{rotation:0},zIndex:2},s={gridLineInterpolation:"circle",gridLineWidth:1,labels:{align:"right",x:-3,y:-2},showLastLabel:!1,title:{x:4,text:null,rotation:90}};function a(){this.autoConnect=this.isCircular&&typeof pick$G(this.userMax,this.options.max)>"u"&&correctFloat$3(this.endAngleRad-this.startAngleRad)===correctFloat$3(2*Math.PI),!this.isCircular&&this.chart.inverted&&this.max++,this.autoConnect&&(this.max+=this.categories&&1||this.pointRange||this.closestPointRange||0)}function l(D,N){return r.indexOf(D)===-1&&(r.push(D),addEvent$p(D,"afterInit",b),addEvent$p(D,"autoLabelAlign",$),addEvent$p(D,"destroy",S),addEvent$p(D,"init",k),addEvent$p(D,"initialAxisTranslation",A)),r.indexOf(N)===-1&&(r.push(N),addEvent$p(N,"afterGetLabelPosition",P),addEvent$p(N,"afterGetPosition",E),wrap$8(N.prototype,"getMarkPath",U)),D}n.compose=l;function h(){var D=this;return function(){if(D.isRadial&&D.tickPositions&&D.options.labels&&D.options.labels.allowOverlap!==!0)return D.tickPositions.map(function(N){return D.ticks[N]&&D.ticks[N].label}).filter(function(N){return!!N})}}function c(){return noop$c}function d(D,N,I){var B=this.pane.center,X=D.value,W,F,_,z;return this.isCircular?(defined$h(X)?D.point&&(W=D.point.shapeArgs||{},W.start&&(X=this.chart.inverted?this.translate(D.point.rectPlotY,!0):D.point.x)):(_=D.chartX||0,z=D.chartY||0,X=this.translate(Math.atan2(z-I,_-N)-this.startAngleRad,!0)),F=this.getPosition(X),_=F.x,z=F.y):(defined$h(X)||(_=D.chartX,z=D.chartY),defined$h(_)&&defined$h(z)&&(I=B[1]+this.chart.plotTop,X=this.translate(Math.min(Math.sqrt(Math.pow(_-N,2)+Math.pow(z-I,2)),B[2]/2)-B[3]/2,!0))),[X,_||0,z||0]}function p(D,N,I){var B=this.pane.center,X=this.chart,W=this.left||0,F=this.top||0,_,z=pick$G(N,B[2]/2-this.offset),V;return typeof I>"u"&&(I=this.horiz?0:this.center&&-this.center[3]/2),I&&(z+=I),this.isCircular||typeof N<"u"?(V=this.chart.renderer.symbols.arc(W+B[0],F+B[1],z,z,{start:this.startAngleRad,end:this.endAngleRad,open:!0,innerR:0}),V.xBounds=[W+B[0]],V.yBounds=[F+B[1]-z]):(_=this.postTranslate(this.angleRad,z),V=[["M",this.center[0]+X.plotLeft,this.center[1]+X.plotTop],["L",_.x,_.y]]),V}function u(){var D=this.constructor.prototype;D.getOffset.call(this),this.chart.axisOffset[this.side]=0}function f(D,N,I){var B=this.chart,X=function(at){if(typeof at=="string"){var lt=parseInt(at,10);return K.test(at)&&(lt=lt*_/100),lt}return at},W=this.center,F=this.startAngleRad,_=W[2]/2,z=Math.min(this.offset,0),V=this.left||0,j=this.top||0,K=/%$/,ot=this.isCircular,q,J,Y,Z,et,Q,tt=pick$G(X(I.outerRadius),_),rt=X(I.innerRadius),it=pick$G(X(I.thickness),10);if(this.options.gridLineInterpolation==="polygon")Q=this.getPlotLinePath({value:D}).concat(this.getPlotLinePath({value:N,reverse:!0}));else{D=Math.max(D,this.min),N=Math.min(N,this.max);var nt=this.translate(D),st=this.translate(N);ot||(tt=nt||0,rt=st||0),I.shape==="circle"||!ot?(q=-Math.PI/2,J=Math.PI*1.5,et=!0):(q=F+(nt||0),J=F+(st||0)),tt-=z,it-=z,Q=B.renderer.symbols.arc(V+W[0],j+W[1],tt,tt,{start:Math.min(q,J),end:Math.max(q,J),innerR:pick$G(rt,tt-it),open:et}),ot&&(Y=(J+q)/2,Z=V+W[0]+W[2]/2*Math.cos(Y),Q.xBounds=Y>-Math.PI/2&&Y<Math.PI/2?[Z,B.plotWidth]:[0,Z],Q.yBounds=[j+W[1]+W[2]/2*Math.sin(Y)],Q.yBounds[0]+=Y>-Math.PI&&Y<0||Y>Math.PI?-10:10)}return Q}function g(D){var N=this,I=this.pane.center,B=this.chart,X=B.inverted,W=D.reverse,F=this.pane.options.background?this.pane.options.background[0]||this.pane.options.background:{},_=F.innerRadius||"0%",z=F.outerRadius||"100%",V=I[0]+B.plotLeft,j=I[1]+B.plotTop,K=this.height,ot=D.isCrosshair,q=I[3]/2,J=D.value,Y,Z,et,Q,tt,rt,it,nt,st,at=this.getPosition(J),lt=at.x,ht=at.y;if(ot&&(nt=this.getCrosshairPosition(D,V,j),J=nt[0],lt=nt[1],ht=nt[2]),this.isCircular)Z=Math.sqrt(Math.pow(lt-V,2)+Math.pow(ht-j,2)),et=typeof _=="string"?relativeLength$2(_,1):_/Z,Q=typeof z=="string"?relativeLength$2(z,1):z/Z,I&&q&&(Y=q/Z,et<Y&&(et=Y),Q<Y&&(Q=Y)),st=[["M",V+et*(lt-V),j-et*(j-ht)],["L",lt-(1-Q)*(lt-V),ht+(1-Q)*(j-ht)]];else if(J=this.translate(J),J&&(J<0||J>K)&&(J=0),this.options.gridLineInterpolation==="circle")st=this.getLinePath(0,J,q);else if(st=[],B[X?"yAxis":"xAxis"].forEach(function(dt){dt.pane===N.pane&&(tt=dt)}),tt){it=tt.tickPositions,tt.autoConnect&&(it=it.concat([it[0]])),W&&(it=it.slice().reverse()),J&&(J+=q);for(var ct=0;ct<it.length;ct++)rt=tt.getPosition(it[ct],J),st.push(ct?["L",rt.x,rt.y]:["M",rt.x,rt.y])}return st}function v(D,N){var I=this.translate(D);return this.postTranslate(this.isCircular?I:this.angleRad,pick$G(this.isCircular?N:I<0?0:I,this.center[2]/2)-this.offset)}function m(){var D=this.center,N=this.chart,I=this.options.title;return{x:N.plotLeft+D[0]+(I.x||0),y:N.plotTop+D[1]-{high:.5,middle:.25,low:0}[I.align]*D[2]+(I.y||0)}}function x(D){D.beforeSetTickPositions=a,D.createLabelCollector=h,D.getCrosshairPosition=d,D.getLinePath=p,D.getOffset=u,D.getPlotBandPath=f,D.getPlotLinePath=g,D.getPosition=v,D.getTitlePosition=m,D.postTranslate=M,D.setAxisSize=O,D.setAxisTranslation=L,D.setOptions=C}function y(D){D.isHidden=!0,D.createLabelCollector=c,D.getOffset=noop$c,D.redraw=T,D.render=T,D.setScale=noop$c,D.setCategories=noop$c,D.setTitle=noop$c}function b(){var D=this.chart,N=this.options,I=D.angular&&this.isXAxis,B=this.pane,X=B&&B.options;!I&&B&&(D.angular||D.polar)&&(this.angleRad=(N.angle||0)*Math.PI/180,this.startAngleRad=(X.startAngle-90)*Math.PI/180,this.endAngleRad=(pick$G(X.endAngle,X.startAngle+360)-90)*Math.PI/180,this.offset=N.offset||0)}function $(D){this.isRadial&&(D.align=void 0,D.preventDefault())}function S(){if(this.chart&&this.chart.labelCollectors){var D=this.labelCollector?this.chart.labelCollectors.indexOf(this.labelCollector):-1;D>=0&&this.chart.labelCollectors.splice(D,1)}}function k(D){var N=this.chart,I=N.inverted,B=N.angular,X=N.polar,W=this.isXAxis,F=this.coll,_=B&&W,z=N.options,V=D.userOptions.pane||0,j=this.pane=N.pane&&N.pane[V],K;if(F==="colorAxis"){this.isRadial=!1;return}B?(_?y(this):x(this),K=!W,K&&(this.defaultPolarOptions=o)):X&&(x(this),K=this.horiz,this.defaultPolarOptions=K?t:merge$C(F==="xAxis"?AxisDefaults$1.defaultXAxisOptions:AxisDefaults$1.defaultYAxisOptions,s),I&&F==="yAxis"&&(this.defaultPolarOptions.stackLabels=AxisDefaults$1.defaultYAxisOptions.stackLabels,this.defaultPolarOptions.reversedStacks=!0)),B||X?(this.isRadial=!0,z.chart.zoomType=null,this.labelCollector||(this.labelCollector=this.createLabelCollector()),this.labelCollector&&N.labelCollectors.push(this.labelCollector)):this.isRadial=!1,j&&K&&(j.axis=this),this.isCircular=K}function A(){this.isRadial&&this.beforeSetTickPositions()}function P(D){var N=this.label;if(N){var I=this.axis,B=N.getBBox(),X=I.options.labels,W=(I.translate(this.pos)+I.startAngleRad+Math.PI/2)/Math.PI*180%360,F=Math.round(W),_=defined$h(X.y)?0:-B.height*.3,z=X.y,V,j=20,K=X.align,ot="end",q=F<0?F+360:F,J=q,Y=0,Z=0;I.isRadial&&(V=I.getPosition(this.pos,I.center[2]/2+relativeLength$2(pick$G(X.distance,-25),I.center[2]/2,-I.center[2]/2)),X.rotation==="auto"?N.attr({rotation:W}):defined$h(z)||(z=I.chart.renderer.fontMetrics(N.styles&&N.styles.fontSize).b-B.height/2),defined$h(K)||(I.isCircular?(B.width>I.len*I.tickInterval/(I.max-I.min)&&(j=0),W>j&&W<180-j?K="left":W>180+j&&W<360-j?K="right":K="center"):K="center",N.attr({align:K})),K==="auto"&&I.tickPositions.length===2&&I.isCircular&&(q>90&&q<180?q=180-q:q>270&&q<=360&&(q=540-q),J>180&&J<=360&&(J=360-J),(I.pane.options.startAngle===F||I.pane.options.startAngle===F+360||I.pane.options.startAngle===F-360)&&(ot="start"),F>=-90&&F<=90||F>=-360&&F<=-270||F>=270&&F<=360?K=ot==="start"?"right":"left":K=ot==="start"?"left":"right",J>70&&J<110&&(K="center"),q<15||q>=180&&q<195?Y=B.height*.3:q>=15&&q<=35?Y=ot==="start"?0:B.height*.75:q>=195&&q<=215?Y=ot==="start"?B.height*.75:0:q>35&&q<=90?Y=ot==="start"?-B.height*.25:B.height:q>215&&q<=270&&(Y=ot==="start"?B.height:-B.height*.25),J<15?Z=ot==="start"?-B.height*.15:B.height*.15:J>165&&J<=180&&(Z=ot==="start"?B.height*.15:-B.height*.15),N.attr({align:K}),N.translate(Z,Y+_)),D.pos.x=V.x+(X.x||0),D.pos.y=V.y+(z||0))}}function E(D){this.axis.getPosition&&extend$G(D.pos,this.axis.getPosition(this.pos))}function M(D,N){var I=this.chart,B=this.center;return D=this.startAngleRad+D,{x:I.plotLeft+B[0]+Math.cos(D)*N,y:I.plotTop+B[1]+Math.sin(D)*N}}function T(){this.isDirty=!1}function O(){var D=this.constructor.prototype,N,I;D.setAxisSize.call(this),this.isRadial&&(this.pane.updateCenter(this),N=this.center=this.pane.center.slice(),this.isCircular?this.sector=this.endAngleRad-this.startAngleRad:(I=this.postTranslate(this.angleRad,N[3]/2),N[0]=I.x-this.chart.plotLeft,N[1]=I.y-this.chart.plotTop),this.len=this.width=this.height=(N[2]-N[3])*pick$G(this.sector,1)/2)}function L(){var D=this.constructor.prototype;D.setAxisTranslation.call(this),this.center&&(this.isCircular?this.transA=(this.endAngleRad-this.startAngleRad)/(this.max-this.min||1):this.transA=(this.center[2]-this.center[3])/2/(this.max-this.min||1),this.isXAxis?this.minPixelPadding=this.transA*this.minPointOffset:this.minPixelPadding=0)}function C(D){var N=this.options=merge$C(this.constructor.defaultOptions,this.defaultPolarOptions,defaultOptions$3[this.coll],D);N.plotBands||(N.plotBands=[]),fireEvent$7(this,"afterSetOptions")}function U(D,N,I,B,X,W,F){var _=this.axis,z,V;return _.isRadial?(z=_.getPosition(this.pos,_.center[2]/2+B),V=["M",N,I,"L",z.x,z.y]):V=D.call(this,N,I,B,X,W,F),V}})(RadialAxis||(RadialAxis={}));const RadialAxis$1=RadialAxis;var __extends$F=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),pointProto=Point$2.prototype,defined$g=Utilities.defined,isNumber$i=Utilities.isNumber,AreaRangePoint$1=function(n){__extends$F(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.high=void 0,t.low=void 0,t.options=void 0,t.plotHigh=void 0,t.plotLow=void 0,t.plotHighX=void 0,t.plotLowX=void 0,t.plotX=void 0,t.series=void 0,t}return r.prototype.setState=function(){var t=this.state,o=this.series,s=o.chart.polar;defined$g(this.plotHigh)||(this.plotHigh=o.yAxis.toPixels(this.high,!0)),defined$g(this.plotLow)||(this.plotLow=this.plotY=o.yAxis.toPixels(this.low,!0)),o.stateMarkerGraphic&&(o.lowerStateMarkerGraphic=o.stateMarkerGraphic,o.stateMarkerGraphic=o.upperStateMarkerGraphic),this.graphic=this.upperGraphic,this.plotY=this.plotHigh,s&&(this.plotX=this.plotHighX),pointProto.setState.apply(this,arguments),this.state=t,this.plotY=this.plotLow,this.graphic=this.lowerGraphic,s&&(this.plotX=this.plotLowX),o.stateMarkerGraphic&&(o.upperStateMarkerGraphic=o.stateMarkerGraphic,o.stateMarkerGraphic=o.lowerStateMarkerGraphic,o.lowerStateMarkerGraphic=void 0),pointProto.setState.apply(this,arguments)},r.prototype.haloPath=function(){var t=this.series.chart.polar,o=[];return this.plotY=this.plotLow,t&&(this.plotX=this.plotLowX),this.isInside&&(o=pointProto.haloPath.apply(this,arguments)),this.plotY=this.plotHigh,t&&(this.plotX=this.plotHighX),this.isTopInside&&(o=o.concat(pointProto.haloPath.apply(this,arguments))),o},r.prototype.isValid=function(){return isNumber$i(this.low)&&isNumber$i(this.high)},r}(AreaSeries$1.prototype.pointClass),__extends$E=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),areaProto=AreaSeries$1.prototype,columnProto$4=ColumnSeries$h.prototype,noop$b=H.noop,seriesProto$1=Series$e.prototype,defined$f=Utilities.defined,extend$F=Utilities.extend,isArray$5=Utilities.isArray,pick$F=Utilities.pick,merge$B=Utilities.merge,AreaRangeSeries$2=function(n){__extends$E(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t.lowerStateMarkerGraphic=void 0,t.xAxis=void 0,t}return r.prototype.toYData=function(t){return[t.low,t.high]},r.prototype.highToXY=function(t){var o=this.chart,s=this.xAxis.postTranslate(t.rectPlotX||0,this.yAxis.len-t.plotHigh);t.plotHighX=s.x-o.plotLeft,t.plotHigh=s.y-o.plotTop,t.plotLowX=t.plotX},r.prototype.translate=function(){var t=this,o=t.yAxis,s=!!t.modifyValue;areaProto.translate.apply(t),t.points.forEach(function(a){var l=a.high,h=a.plotY;a.isNull?a.plotY=null:(a.plotLow=h,a.plotHigh=o.translate(s?t.modifyValue(l,a):l,0,1,0,1),s&&(a.yBottom=a.plotHigh))}),this.chart.polar&&this.points.forEach(function(a){t.highToXY(a),a.tooltipPos=[(a.plotHighX+a.plotLowX)/2,(a.plotHigh+a.plotLow)/2]})},r.prototype.getGraphPath=function(t){var o=[],s=[],a,l=areaProto.getGraphPath,h,c,d,p,u=this.options,f=this.chart.polar,g=f&&u.connectEnds!==!1,v=u.connectNulls,m=u.step,x,y;for(t=t||this.points,a=t.length;a--;){h=t[a];var b=f?{plotX:h.rectPlotX,plotY:h.yBottom,doCurve:!1}:{plotX:h.plotX,plotY:h.plotY,doCurve:!1};!h.isNull&&!g&&!v&&(!t[a+1]||t[a+1].isNull)&&s.push(b),c={polarPlotY:h.polarPlotY,rectPlotX:h.rectPlotX,yBottom:h.yBottom,plotX:pick$F(h.plotHighX,h.plotX),plotY:h.plotHigh,isNull:h.isNull},s.push(c),o.push(c),!h.isNull&&!g&&!v&&(!t[a-1]||t[a-1].isNull)&&s.push(b)}return p=l.call(this,t),m&&(m===!0&&(m="left"),u.step={left:"right",center:"center",right:"left"}[m]),x=l.call(this,o),y=l.call(this,s),u.step=m,d=[].concat(p,x),!this.chart.polar&&y[0]&&y[0][0]==="M"&&(y[0]=["L",y[0][1],y[0][2]]),this.graphPath=d,this.areaPath=p.concat(y),d.isArea=!0,d.xMap=p.xMap,this.areaPath.xMap=p.xMap,d},r.prototype.drawDataLabels=function(){var t=this.points,o=t.length,s,a=[],l=this.options.dataLabels,h,c,d=this.chart.inverted,p,u;if(l){if(isArray$5(l)?(p=l[0]||{enabled:!1},u=l[1]||{enabled:!1}):(p=extend$F({},l),p.x=l.xHigh,p.y=l.yHigh,u=extend$F({},l),u.x=l.xLow,u.y=l.yLow),p.enabled||this._hasPointLabels){for(s=o;s--;)h=t[s],h&&(c=p.inside?h.plotHigh<h.plotLow:h.plotHigh>h.plotLow,h.y=h.high,h._plotY=h.plotY,h.plotY=h.plotHigh,a[s]=h.dataLabel,h.dataLabel=h.dataLabelUpper,h.below=c,d?p.align||(p.align=c?"right":"left"):p.verticalAlign||(p.verticalAlign=c?"top":"bottom"));for(this.options.dataLabels=p,seriesProto$1.drawDataLabels&&seriesProto$1.drawDataLabels.apply(this,arguments),s=o;s--;)h=t[s],h&&(h.dataLabelUpper=h.dataLabel,h.dataLabel=a[s],delete h.dataLabels,h.y=h.low,h.plotY=h._plotY)}if(u.enabled||this._hasPointLabels){for(s=o;s--;)h=t[s],h&&(c=u.inside?h.plotHigh<h.plotLow:h.plotHigh>h.plotLow,h.below=!c,d?u.align||(u.align=c?"left":"right"):u.verticalAlign||(u.verticalAlign=c?"bottom":"top"));this.options.dataLabels=u,seriesProto$1.drawDataLabels&&seriesProto$1.drawDataLabels.apply(this,arguments)}if(p.enabled)for(s=o;s--;)h=t[s],h&&(h.dataLabels=[h.dataLabelUpper,h.dataLabel].filter(function(f){return!!f}));this.options.dataLabels=l}},r.prototype.alignDataLabel=function(){columnProto$4.alignDataLabel.apply(this,arguments)},r.prototype.drawPoints=function(){var t=this,o=t.points.length,s,a;for(seriesProto$1.drawPoints.apply(t,arguments),a=0;a<o;)s=t.points[a],s.origProps={plotY:s.plotY,plotX:s.plotX,isInside:s.isInside,negative:s.negative,zone:s.zone,y:s.y},s.lowerGraphic=s.graphic,s.graphic=s.upperGraphic,s.plotY=s.plotHigh,defined$f(s.plotHighX)&&(s.plotX=s.plotHighX),s.y=pick$F(s.high,s.origProps.y),s.negative=s.y<(t.options.threshold||0),t.zones.length&&(s.zone=s.getZone()),t.chart.polar||(s.isInside=s.isTopInside=typeof s.plotY<"u"&&s.plotY>=0&&s.plotY<=t.yAxis.len&&s.plotX>=0&&s.plotX<=t.xAxis.len),a++;for(seriesProto$1.drawPoints.apply(t,arguments),a=0;a<o;)s=t.points[a],s.upperGraphic=s.graphic,s.graphic=s.lowerGraphic,s.origProps&&(extend$F(s,s.origProps),delete s.origProps),a++},r.defaultOptions=merge$B(AreaSeries$1.defaultOptions,{lineWidth:1,threshold:null,tooltip:{pointFormat:'<span style="color:{series.color}">●</span> {series.name}: <b>{point.low}</b> - <b>{point.high}</b><br/>'},trackByArea:!0,dataLabels:{align:void 0,verticalAlign:void 0,xLow:0,xHigh:0,yLow:0,yHigh:0}}),r}(AreaSeries$1);extend$F(AreaRangeSeries$2.prototype,{pointArrayMap:["low","high"],pointValKey:"low",deferTranslatePolar:!0,pointClass:AreaRangePoint$1,setStackedPoints:noop$b});SeriesRegistry$1.registerSeriesType("arearange",AreaRangeSeries$2);var __extends$D=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),SplineSeries=SeriesRegistry$1.seriesTypes.spline,merge$A=Utilities.merge,extend$E=Utilities.extend,AreaSplineRangeSeries=function(n){__extends$D(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.options=void 0,t.data=void 0,t.points=void 0,t}return r.defaultOptions=merge$A(AreaRangeSeries$2.defaultOptions),r}(AreaRangeSeries$2);extend$E(AreaSplineRangeSeries.prototype,{getPointSpline:SplineSeries.prototype.getPointSpline});SeriesRegistry$1.registerSeriesType("areasplinerange",AreaSplineRangeSeries);var __extends$C=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),noop$a=H.noop,extend$D=Utilities.extend,merge$z=Utilities.merge,pick$E=Utilities.pick,BoxPlotSeries=function(n){__extends$C(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.pointAttribs=function(){return{}},r.prototype.translate=function(){var t=this,o=t.yAxis,s=t.pointArrayMap;n.prototype.translate.apply(t),t.points.forEach(function(a){s.forEach(function(l){a[l]!==null&&(a[l+"Plot"]=o.translate(a[l],0,1,0,1))}),a.plotHigh=a.highPlot})},r.prototype.drawPoints=function(){var t=this,o=t.points,s=t.options,a=t.chart,l=a.renderer,h,c,d,p,u,f,g,v=0,m,x,y,b,$,S=t.doQuartiles!==!1,k,A=t.options.whiskerLength;o.forEach(function(P){var E=P.graphic,M=E?"animate":"attr",T=P.shapeArgs,O={},L={},C={},U={},D=P.color||t.color;if(typeof P.plotY<"u"){x=Math.round(T.width),y=Math.floor(T.x),b=y+x,$=Math.round(x/2),h=Math.floor(S?P.q1Plot:P.lowPlot),c=Math.floor(S?P.q3Plot:P.lowPlot),d=Math.floor(P.highPlot),p=Math.floor(P.lowPlot),E||(P.graphic=E=l.g("point").add(t.group),P.stem=l.path().addClass("highcharts-boxplot-stem").add(E),A&&(P.whiskers=l.path().addClass("highcharts-boxplot-whisker").add(E)),S&&(P.box=l.path(m).addClass("highcharts-boxplot-box").add(E)),P.medianShape=l.path(f).addClass("highcharts-boxplot-median").add(E)),a.styledMode||(L.stroke=P.stemColor||s.stemColor||D,L["stroke-width"]=pick$E(P.stemWidth,s.stemWidth,s.lineWidth),L.dashstyle=P.stemDashStyle||s.stemDashStyle||s.dashStyle,P.stem.attr(L),A&&(C.stroke=P.whiskerColor||s.whiskerColor||D,C["stroke-width"]=pick$E(P.whiskerWidth,s.whiskerWidth,s.lineWidth),C.dashstyle=P.whiskerDashStyle||s.whiskerDashStyle||s.dashStyle,P.whiskers.attr(C)),S&&(O.fill=P.fillColor||s.fillColor||D,O.stroke=s.lineColor||D,O["stroke-width"]=s.lineWidth||0,O.dashstyle=P.boxDashStyle||s.boxDashStyle||s.dashStyle,P.box.attr(O)),U.stroke=P.medianColor||s.medianColor||D,U["stroke-width"]=pick$E(P.medianWidth,s.medianWidth,s.lineWidth),U.dashstyle=P.medianDashStyle||s.medianDashStyle||s.dashStyle,P.medianShape.attr(U));var N=void 0;g=P.stem.strokeWidth()%2/2,v=y+$+g,N=[["M",v,c],["L",v,d],["M",v,h],["L",v,p]],P.stem[M]({d:N}),S&&(g=P.box.strokeWidth()%2/2,h=Math.floor(h)+g,c=Math.floor(c)+g,y+=g,b+=g,N=[["M",y,c],["L",y,h],["L",b,h],["L",b,c],["L",y,c],["Z"]],P.box[M]({d:N})),A&&(g=P.whiskers.strokeWidth()%2/2,d=d+g,p=p+g,k=/%$/.test(A)?$*parseFloat(A)/100:A/2,N=[["M",v-k,d],["L",v+k,d],["M",v-k,p],["L",v+k,p]],P.whiskers[M]({d:N})),u=Math.round(P.medianPlot),g=P.medianShape.strokeWidth()%2/2,u=u+g,N=[["M",y,u],["L",b,u]],P.medianShape[M]({d:N})}})},r.prototype.toYData=function(t){return[t.low,t.q1,t.median,t.q3,t.high]},r.defaultOptions=merge$z(ColumnSeries$h.defaultOptions,{threshold:null,tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Maximum: {point.high}<br/>Upper quartile: {point.q3}<br/>Median: {point.median}<br/>Lower quartile: {point.q1}<br/>Minimum: {point.low}<br/>'},whiskerLength:"50%",fillColor:palette.backgroundColor,lineWidth:1,medianWidth:2,whiskerWidth:2}),r}(ColumnSeries$h);extend$D(BoxPlotSeries.prototype,{pointArrayMap:["low","q1","median","q3","high"],pointValKey:"high",drawDataLabels:noop$a,setStackedPoints:noop$a});SeriesRegistry$1.registerSeriesType("boxplot",BoxPlotSeries);var BubbleLegendDefaults={borderColor:void 0,borderWidth:2,className:void 0,color:void 0,connectorClassName:void 0,connectorColor:void 0,connectorDistance:60,connectorWidth:1,enabled:!1,labels:{className:void 0,allowOverlap:!1,format:"",formatter:void 0,align:"right",style:{fontSize:"10px",color:palette.neutralColor100},x:0,y:0},maxSize:60,minSize:10,legendIndex:0,ranges:{value:void 0,borderColor:void 0,color:void 0,connectorColor:void 0},sizeBy:"area",sizeByAbsoluteValue:!1,zIndex:1,zThreshold:0},color$a=Color.parse,noop$9=H.noop,arrayMax$3=Utilities.arrayMax,arrayMin$3=Utilities.arrayMin,isNumber$h=Utilities.isNumber,merge$y=Utilities.merge,pick$D=Utilities.pick,stableSort$2=Utilities.stableSort,BubbleLegendItem=function(){function n(r,t){this.chart=void 0,this.fontMetrics=void 0,this.legend=void 0,this.legendGroup=void 0,this.legendItem=void 0,this.legendItemHeight=void 0,this.legendItemWidth=void 0,this.legendSymbol=void 0,this.maxLabel=void 0,this.movementX=void 0,this.ranges=void 0,this.selected=void 0,this.visible=void 0,this.symbols=void 0,this.options=void 0,this.setState=noop$9,this.init(r,t)}return n.prototype.init=function(r,t){this.options=r,this.visible=!0,this.chart=t.chart,this.legend=t},n.prototype.addToLegend=function(r){r.splice(this.options.legendIndex,0,this)},n.prototype.drawLegendSymbol=function(r){var t=this.chart,o=this.options,s=pick$D(r.options.itemDistance,20),a=o.ranges,l=o.connectorDistance,h;if(this.fontMetrics=t.renderer.fontMetrics(o.labels.style.fontSize),!a||!a.length||!isNumber$h(a[0].value)){r.options.bubbleLegend.autoRanges=!0;return}stableSort$2(a,function(u,f){return f.value-u.value}),this.ranges=a,this.setOptions(),this.render();var c=this.getMaxLabelSize(),d=this.ranges[0].radius,p=d*2;h=l-d+c.width,h=h>0?h:0,this.maxLabel=c,this.movementX=o.labels.align==="left"?h:0,this.legendItemWidth=p+h+s,this.legendItemHeight=p+this.fontMetrics.h/2},n.prototype.setOptions=function(){var r=this.ranges,t=this.options,o=this.chart.series[t.seriesIndex],s=this.legend.baseline,a={zIndex:t.zIndex,"stroke-width":t.borderWidth},l={zIndex:t.zIndex,"stroke-width":t.connectorWidth},h={align:this.legend.options.rtl||t.labels.align==="left"?"right":"left",zIndex:t.zIndex},c=o.options.marker.fillOpacity,d=this.chart.styledMode;r.forEach(function(p,u){d||(a.stroke=pick$D(p.borderColor,t.borderColor,o.color),a.fill=pick$D(p.color,t.color,c!==1?color$a(o.color).setOpacity(c).get("rgba"):o.color),l.stroke=pick$D(p.connectorColor,t.connectorColor,o.color)),r[u].radius=this.getRangeRadius(p.value),r[u]=merge$y(r[u],{center:r[0].radius-r[u].radius+s}),d||merge$y(!0,r[u],{bubbleAttribs:merge$y(a),connectorAttribs:merge$y(l),labelAttribs:h})},this)},n.prototype.getRangeRadius=function(r){var t=this.options,o=this.options.seriesIndex,s=this.chart.series[o],a=t.ranges[0].value,l=t.ranges[t.ranges.length-1].value,h=t.minSize,c=t.maxSize;return s.getRadius.call(this,l,a,h,c,r)},n.prototype.render=function(){var r=this.chart.renderer,t=this.options.zThreshold;this.symbols||(this.symbols={connectors:[],bubbleItems:[],labels:[]}),this.legendSymbol=r.g("bubble-legend"),this.legendItem=r.g("bubble-legend-item"),this.legendSymbol.translateX=0,this.legendSymbol.translateY=0,this.ranges.forEach(function(o){o.value>=t&&this.renderRange(o)},this),this.legendSymbol.add(this.legendItem),this.legendItem.add(this.legendGroup),this.hideOverlappingLabels()},n.prototype.renderRange=function(r){var t=this.ranges[0],o=this.legend,s=this.options,a=s.labels,l=this.chart,h=l.series[s.seriesIndex],c=l.renderer,d=this.symbols,p=d.labels,u=r.center,f=Math.abs(r.radius),g=s.connectorDistance||0,v=a.align,m=o.options.rtl,x=s.borderWidth,y=s.connectorWidth,b=t.radius||0,$=u-f-x/2+y/2,S=this.fontMetrics,k=S.f/2-(S.h-S.f)/2,A=($%1?1:.5)-(y%2?0:.5),P=c.styledMode,E=m||v==="left"?-g:g;v==="center"&&(E=0,s.connectorDistance=0,r.labelAttribs.align="center");var M=$+s.labels.y,T=b+E+s.labels.x;d.bubbleItems.push(c.circle(b,u+A,f).attr(P?{}:r.bubbleAttribs).addClass((P?"highcharts-color-"+h.colorIndex+" ":"")+"highcharts-bubble-legend-symbol "+(s.className||"")).add(this.legendSymbol)),d.connectors.push(c.path(c.crispLine([["M",b,$],["L",b+E,$]],s.connectorWidth)).attr(P?{}:r.connectorAttribs).addClass((P?"highcharts-color-"+this.options.seriesIndex+" ":"")+"highcharts-bubble-legend-connectors "+(s.connectorClassName||"")).add(this.legendSymbol));var O=c.text(this.formatLabel(r),T,M+k).attr(P?{}:r.labelAttribs).css(P?{}:a.style).addClass("highcharts-bubble-legend-labels "+(s.labels.className||"")).add(this.legendSymbol);p.push(O),O.placed=!0,O.alignAttr={x:T,y:M+k}},n.prototype.getMaxLabelSize=function(){var r=this.symbols.labels,t,o;return r.forEach(function(s){o=s.getBBox(!0),t?t=o.width>t.width?o:t:t=o}),t||{}},n.prototype.formatLabel=function(r){var t=this.options,o=t.labels.formatter,s=t.labels.format,a=this.chart.numberFormatter;return s?FormatUtilities.format(s,r):o?o.call(r):a(r.value,1)},n.prototype.hideOverlappingLabels=function(){var r=this.chart,t=this.options.labels.allowOverlap,o=this.symbols;!t&&o&&(r.hideOverlappingLabels(o.labels),o.labels.forEach(function(s,a){s.newOpacity?s.newOpacity!==s.oldOpacity&&o.connectors[a].show():o.connectors[a].hide()}))},n.prototype.getRanges=function(){var r=this.legend.bubbleLegend,t=r.chart.series,o=r.options.ranges,s,a,l=Number.MAX_VALUE,h=-Number.MAX_VALUE;return t.forEach(function(c){c.isBubble&&!c.ignoreSeries&&(a=c.zData.filter(isNumber$h),a.length&&(l=pick$D(c.options.zMin,Math.min(l,Math.max(arrayMin$3(a),c.options.displayNegative===!1?c.options.zThreshold:-Number.MAX_VALUE))),h=pick$D(c.options.zMax,Math.max(h,arrayMax$3(a)))))}),l===h?s=[{value:h}]:s=[{value:l},{value:(l+h)/2},{value:h,autoRanges:!0}],o.length&&o[0].radius&&s.reverse(),s.forEach(function(c,d){o&&o[d]&&(s[d]=merge$y(o[d],c))}),s},n.prototype.predictBubbleSizes=function(){var r=this.chart,t=this.fontMetrics,o=r.legend.options,s=o.floating,a=o.layout==="horizontal",l=a?r.legend.lastLineHeight:0,h=r.plotSizeX,c=r.plotSizeY,d=r.series[this.options.seriesIndex],p=Math.ceil(d.minPxSize),u=Math.ceil(d.maxPxSize),f=Math.min(c,h),g,v=d.options.maxSize;return s||!/%$/.test(v)?g=u:(v=parseFloat(v),g=(f+l-t.h/2)*v/100/(v/100+1),(a&&c-g>=h||!a&&h-g>=c)&&(g=u)),[p,Math.ceil(g)]},n.prototype.updateRanges=function(r,t){var o=this.legend.options.bubbleLegend;o.minSize=r,o.maxSize=t,o.ranges=this.getRanges()},n.prototype.correctSizes=function(){var r=this.legend,t=this.chart,o=t.series[this.options.seriesIndex],s=o.maxPxSize,a=this.options.maxSize;Math.abs(Math.ceil(s)-a)>1&&(this.updateRanges(this.options.minSize,o.maxPxSize),r.render())},n}(),setOptions=DefaultOptions.setOptions,addEvent$o=Utilities.addEvent,objectEach$9=Utilities.objectEach,wrap$7=Utilities.wrap,BubbleLegendComposition;(function(n){var r=[];function t(d,p,u){var f=this,g=f.legend,v=s(f)>=0,m,x;g&&g.options.enabled&&g.bubbleLegend&&g.options.bubbleLegend.autoRanges&&v?(m=g.bubbleLegend.options,x=g.bubbleLegend.predictBubbleSizes(),g.bubbleLegend.updateRanges(x[0],x[1]),m.placed||(g.group.placed=!1,g.allItems.forEach(function(y){y.legendGroup.translateY=null})),g.render(),f.getMargins(),f.axes.forEach(function(y){y.visible&&y.render(),m.placed||(y.setScale(),y.updateNames(),objectEach$9(y.ticks,function(b){b.isNew=!0,b.isNewLabel=!0}))}),m.placed=!0,f.getMargins(),d.call(f,p,u),g.bubbleLegend.correctSizes(),c(g,a(g))):(d.call(f,p,u),g&&g.options.enabled&&g.bubbleLegend&&(g.render(),c(g,a(g))))}function o(d,p,u){r.indexOf(d)===-1&&(r.push(d),setOptions({legend:{bubbleLegend:BubbleLegendDefaults}}),wrap$7(d.prototype,"drawChartBox",t)),r.indexOf(p)===-1&&(r.push(p),addEvent$o(p,"afterGetAllItems",l)),r.indexOf(u)===-1&&(r.push(u),addEvent$o(u,"legendItemClick",h))}n.compose=o;function s(d){for(var p=d.series,u=0;u<p.length;){if(p[u]&&p[u].isBubble&&p[u].visible&&p[u].zData.length)return u;u++}return-1}function a(d){var p=d.allItems,u=[],f=p.length,g,v=0,m=0;for(v=0;v<f;v++)if(p[v].legendItemHeight&&(p[v].itemHeight=p[v].legendItemHeight),p[v]===p[f-1]||p[v+1]&&p[v]._legendItemPos[1]!==p[v+1]._legendItemPos[1]){for(u.push({height:0}),g=u[u.length-1],m;m<=v;m++)p[m].itemHeight>g.height&&(g.height=p[m].itemHeight);g.step=v}return u}function l(d){var p=this,u=p.bubbleLegend,f=p.options,g=f.bubbleLegend,v=s(p.chart);u&&u.ranges&&u.ranges.length&&(g.ranges.length&&(g.autoRanges=!!g.ranges[0].autoRanges),p.destroyItem(u)),v>=0&&f.enabled&&g.enabled&&(g.seriesIndex=v,p.bubbleLegend=new BubbleLegendItem(g,p),p.bubbleLegend.addToLegend(d.allItems))}function h(){var d=this,p=d.chart,u=d.visible,f=d.chart.legend,g;f&&f.bubbleLegend&&(d.visible=!u,d.ignoreSeries=u,g=s(p)>=0,f.bubbleLegend.visible!==g&&(f.update({bubbleLegend:{enabled:g}}),f.bubbleLegend.visible=g),d.visible=u)}function c(d,p){var u=d.allItems,f=d.options.rtl,g,v,m,x=0;u.forEach(function(y,b){g=y.legendGroup.translateX,v=y._legendItemPos[1],m=y.movementX,(m||f&&y.ranges)&&(m=f?g-y.options.maxSize/2:g+m,y.legendGroup.attr({translateX:m})),b>p[x].step&&x++,y.legendGroup.attr({translateY:Math.round(v+p[x].height/2)}),y._legendItemPos[1]=v+p[x].height/2})}})(BubbleLegendComposition||(BubbleLegendComposition={}));const BubbleLegendComposition$1=BubbleLegendComposition;var __extends$B=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),ScatterPoint$2=SeriesRegistry$1.seriesTypes.scatter.prototype.pointClass,extend$C=Utilities.extend,BubblePoint=function(n){__extends$B(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return r.prototype.haloPath=function(t){return Point$2.prototype.haloPath.call(this,t===0?0:(this.marker&&this.marker.radius||0)+t)},r}(ScatterPoint$2);extend$C(BubblePoint.prototype,{ttBelow:!1});var __extends$A=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),color$9=Color.parse,noop$8=H.noop,_a$b=SeriesRegistry$1.seriesTypes,ColumnSeries$b=_a$b.column,ScatterSeries$3=_a$b.scatter,arrayMax$2=Utilities.arrayMax,arrayMin$2=Utilities.arrayMin,clamp$8=Utilities.clamp,extend$B=Utilities.extend,isNumber$g=Utilities.isNumber,merge$x=Utilities.merge,pick$C=Utilities.pick,pInt$2=Utilities.pInt,BubbleSeries$2=function(n){__extends$A(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.maxPxSize=void 0,t.minPxSize=void 0,t.options=void 0,t.points=void 0,t.radii=void 0,t.yData=void 0,t.zData=void 0,t}return r.prototype.animate=function(t){!t&&this.points.length<this.options.animationLimit&&this.points.forEach(function(o){var s=o.graphic;s&&s.width&&(this.hasRendered||s.attr({x:o.plotX,y:o.plotY,width:1,height:1}),s.animate(this.markerAttribs(o),this.options.animation))},this)},r.prototype.getRadii=function(t,o,s){var a,l,h=this.zData,c=this.yData,d=s.minPxSize,p=s.maxPxSize,u=[],f;for(l=0,a=h.length;l<a;l++)f=h[l],u.push(this.getRadius(t,o,d,p,f,c[l]));this.radii=u},r.prototype.getRadius=function(t,o,s,a,l,h){var c=this.options,d=c.sizeBy!=="width",p=c.zThreshold,u=o-t,f=.5;if(h===null||l===null)return null;if(isNumber$g(l)){if(c.sizeByAbsoluteValue&&(l=Math.abs(l-p),o=u=Math.max(o-p,Math.abs(t-p)),t=0),l<t)return s/2-1;u>0&&(f=(l-t)/u)}return d&&f>=0&&(f=Math.sqrt(f)),Math.ceil(s+f*(a-s))/2},r.prototype.hasData=function(){return!!this.processedXData.length},r.prototype.pointAttribs=function(t,o){var s=this.options.marker,a=s.fillOpacity,l=Series$e.prototype.pointAttribs.call(this,t,o);return a!==1&&(l.fill=color$9(l.fill).setOpacity(a).get("rgba")),l},r.prototype.translate=function(){var t,o=this.data,s,a,l=this.radii;for(n.prototype.translate.call(this),t=o.length;t--;)s=o[t],a=l?l[t]:0,isNumber$g(a)&&a>=this.minPxSize/2?(s.marker=extend$B(s.marker,{radius:a,width:2*a,height:2*a}),s.dlBox={x:s.plotX-a,y:s.plotY-a,width:2*a,height:2*a}):s.shapeArgs=s.plotY=s.dlBox=void 0},r.compose=BubbleLegendComposition$1.compose,r.defaultOptions=merge$x(ScatterSeries$3.defaultOptions,{dataLabels:{formatter:function(){var t=this.series.chart.numberFormatter,o=this.point.z;return isNumber$g(o)?t(o,-1):""},inside:!0,verticalAlign:"middle"},animationLimit:250,marker:{lineColor:null,lineWidth:1,fillOpacity:.5,radius:null,states:{hover:{radiusPlus:0}},symbol:"circle"},minSize:8,maxSize:"20%",softThreshold:!1,states:{hover:{halo:{size:5}}},tooltip:{pointFormat:"({point.x}, {point.y}), Size: {point.z}"},turboThreshold:0,zThreshold:0,zoneAxis:"z"}),r}(ScatterSeries$3);extend$B(BubbleSeries$2.prototype,{alignDataLabel:ColumnSeries$b.prototype.alignDataLabel,applyZones:noop$8,bubblePadding:!0,buildKDTree:noop$8,directTouch:!0,isBubble:!0,pointArrayMap:["y","z"],pointClass:BubblePoint,parallelArrays:["x","y","z"],trackerGroups:["group","dataLabelsGroup"],specialGroup:"group",zoneAxis:"z"});Axis.prototype.beforePadding=function(){var n=this,r=this.len,t=this.chart,o=0,s=r,a=this.isXAxis,l=a?"xData":"yData",h=this.min,c={},d=Math.min(t.plotWidth,t.plotHeight),p=Number.MAX_VALUE,u=-Number.MAX_VALUE,f=this.max-h,g=r/f,v=[];this.series.forEach(function(m){var x=m.options,y;m.bubblePadding&&(m.visible||!t.options.chart.ignoreHiddenSeries)&&(n.allowZoomOutside=!0,v.push(m),a&&(["minSize","maxSize"].forEach(function(b){var $=x[b],S=/%$/.test($);$=pInt$2($),c[b]=S?d*$/100:$}),m.minPxSize=c.minSize,m.maxPxSize=Math.max(c.maxSize,c.minSize),y=m.zData.filter(isNumber$g),y.length&&(p=pick$C(x.zMin,clamp$8(arrayMin$2(y),x.displayNegative===!1?x.zThreshold:-Number.MAX_VALUE,p)),u=pick$C(x.zMax,Math.max(u,arrayMax$2(y))))))}),v.forEach(function(m){var x=m[l],y=x.length,b;if(a&&m.getRadii(p,u,m),f>0)for(;y--;)isNumber$g(x[y])&&n.dataMin<=x[y]&&x[y]<=n.max&&(b=m.radii?m.radii[y]:0,o=Math.min((x[y]-h)*g-b,o),s=Math.max((x[y]-h)*g+b,s))}),v.length&&f>0&&!this.logarithmic&&(s-=r,g*=(r+Math.max(0,o)-Math.min(s,r))/r,[["min","userMin",o],["max","userMax",s]].forEach(function(m){typeof pick$C(n.options[m[0]],n[m[1]])>"u"&&(n[m[0]]+=m[2]/g)}))};SeriesRegistry$1.registerSeriesType("bubble",BubbleSeries$2);var __extends$z=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),_a$a=SeriesRegistry$1.seriesTypes,ColumnPoint=_a$a.column.prototype.pointClass,AreaRangePoint=_a$a.arearange.prototype.pointClass,extend$A=Utilities.extend,isNumber$f=Utilities.isNumber,ColumnRangePoint=function(n){__extends$z(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.series=void 0,t.options=void 0,t.barX=void 0,t.pointWidth=void 0,t.shapeType=void 0,t}return r.prototype.isValid=function(){return isNumber$f(this.low)},r}(AreaRangePoint);extend$A(ColumnRangePoint.prototype,{setState:ColumnPoint.prototype.setState});var __extends$y=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),noop$7=H.noop,_a$9=SeriesRegistry$1.seriesTypes,AreaRangeSeries$1=_a$9.arearange,ColumnSeries$a=_a$9.column,columnProto$3=ColumnSeries$a.prototype,arearangeProto$1=AreaRangeSeries$1.prototype,clamp$7=Utilities.clamp,merge$w=Utilities.merge,pick$B=Utilities.pick,extend$z=Utilities.extend,columnRangeOptions={pointRange:null,marker:null,states:{hover:{halo:!1}}},ColumnRangeSeries=function(n){__extends$y(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.points=void 0,t.options=void 0,t}return r.prototype.setOptions=function(){return merge$w(!0,arguments[0],{stacking:void 0}),arearangeProto$1.setOptions.apply(this,arguments)},r.prototype.translate=function(){var t=this,o=t.yAxis,s=t.xAxis,a=s.startAngleRad,l,h=t.chart,c=t.xAxis.isRadial,d=Math.max(h.chartWidth,h.chartHeight)+999,p;function u(f){return clamp$7(f,-d,d)}columnProto$3.translate.apply(t),t.points.forEach(function(f){var g=f.shapeArgs||{},v=t.options.minPointLength,m,x,y;if(f.plotHigh=p=u(o.translate(f.high,0,1,0,1)),f.plotLow=u(f.plotY),y=p,x=pick$B(f.rectPlotY,f.plotY)-p,Math.abs(x)<v?(m=v-x,x+=m,y-=m/2):x<0&&(x*=-1,y-=x),c)l=f.barX+a,f.shapeType="arc",f.shapeArgs=t.polarArc(y+x,y,l,l+f.pointWidth);else{g.height=x,g.y=y;var b=g.x,$=b===void 0?0:b,S=g.width,k=S===void 0?0:S;f.tooltipPos=h.inverted?[o.len+o.pos-h.plotLeft-y-x/2,s.len+s.pos-h.plotTop-$-k/2,x]:[s.left-h.plotLeft+$+k/2,o.pos-h.plotTop+y+x/2,x]}})},r.prototype.crispCol=function(){return columnProto$3.crispCol.apply(this,arguments)},r.prototype.drawPoints=function(){return columnProto$3.drawPoints.apply(this,arguments)},r.prototype.drawTracker=function(){return columnProto$3.drawTracker.apply(this,arguments)},r.prototype.getColumnMetrics=function(){return columnProto$3.getColumnMetrics.apply(this,arguments)},r.prototype.pointAttribs=function(){return columnProto$3.pointAttribs.apply(this,arguments)},r.prototype.adjustForMissingColumns=function(){return columnProto$3.adjustForMissingColumns.apply(this,arguments)},r.prototype.animate=function(){return columnProto$3.animate.apply(this,arguments)},r.prototype.translate3dPoints=function(){return columnProto$3.translate3dPoints.apply(this,arguments)},r.prototype.translate3dShapes=function(){return columnProto$3.translate3dShapes.apply(this,arguments)},r.defaultOptions=merge$w(ColumnSeries$a.defaultOptions,AreaRangeSeries$1.defaultOptions,columnRangeOptions),r}(AreaRangeSeries$1);extend$z(ColumnRangeSeries.prototype,{directTouch:!0,trackerGroups:["group","dataLabelsGroup"],drawGraph:noop$7,getSymbol:noop$7,polarArc:function(){return columnProto$3.polarArc.apply(this,arguments)},pointClass:ColumnRangePoint});SeriesRegistry$1.registerSeriesType("columnrange",ColumnRangeSeries);var __extends$x=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),colProto=ColumnSeries$h.prototype,clamp$6=Utilities.clamp,merge$v=Utilities.merge,pick$A=Utilities.pick,ColumnPyramidSeries=function(n){__extends$x(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.translate=function(){var t=this,o=t.chart,s=t.options,a=t.dense=t.closestPointRange*t.xAxis.transA<2,l=t.borderWidth=pick$A(s.borderWidth,a?0:1),h=t.yAxis,c=s.threshold,d=t.translatedThreshold=h.getThreshold(c),p=pick$A(s.minPointLength,5),u=t.getColumnMetrics(),f=u.width,g=t.barW=Math.max(f,1+2*l),v=t.pointXOffset=u.offset;o.inverted&&(d-=.5),s.pointPadding&&(g=Math.ceil(g)),colProto.translate.apply(t),t.points.forEach(function(m){var x=pick$A(m.yBottom,d),y=999+Math.abs(x),b=clamp$6(m.plotY,-y,h.len+y),$=m.plotX+v,S=g/2,k=Math.min(b,x),A=Math.max(b,x)-k,P,E,M,T,O,L,C,U,D,N,I,B;m.barX=$,m.pointWidth=f,m.tooltipPos=o.inverted?[h.len+h.pos-o.plotLeft-b,t.xAxis.len-$-S,A]:[$+S,b+h.pos-o.plotTop,A],P=c+(m.total||m.y),s.stacking==="percent"&&(P=c+(m.y<0)?-100:100),M=h.toPixels(P,!0),E=o.plotHeight-M-(o.plotHeight-d),T=E?S*(k-M)/E:0,O=E?S*(k+A-M)/E:0,C=$-T+S,U=$+T+S,D=$+O+S,N=$-O+S,I=k-p,B=k+A,m.y<0&&(I=k,B=k+A+p),o.inverted&&(L=o.plotWidth-k,E=M-(o.plotWidth-d),T=S*(M-L)/E,O=S*(M-(L-A))/E,C=$+S+T,U=C-2*T,D=$-O+S,N=$+O+S,I=k,B=k+A-p,m.y<0&&(B=k+A+p)),m.shapeType="path",m.shapeArgs={x:C,y:I,width:U-C,height:A,d:[["M",C,I],["L",U,I],["L",D,B],["L",N,B],["Z"]]}})},r.defaultOptions=merge$v(ColumnSeries$h.defaultOptions,{}),r}(ColumnSeries$h);SeriesRegistry$1.registerSeriesType("columnpyramid",ColumnPyramidSeries);var __extends$w=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),AreaRangeSeries=SeriesRegistry$1.seriesTypes.arearange,merge$u=Utilities.merge,extend$y=Utilities.extend,ErrorBarSeries=function(n){__extends$w(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.getColumnMetrics=function(){return this.linkedParent&&this.linkedParent.columnMetrics||ColumnSeries$h.prototype.getColumnMetrics.call(this)},r.prototype.drawDataLabels=function(){var t=this.pointValKey;AreaRangeSeries&&(AreaRangeSeries.prototype.drawDataLabels.call(this),this.data.forEach(function(o){o.y=o[t]}))},r.prototype.toYData=function(t){return[t.low,t.high]},r.defaultOptions=merge$u(BoxPlotSeries.defaultOptions,{color:palette.neutralColor100,grouping:!1,linkedTo:":previous",tooltip:{pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.low}</b> - <b>{point.high}</b><br/>'},whiskerWidth:null}),r}(BoxPlotSeries);extend$y(ErrorBarSeries.prototype,{pointArrayMap:["low","high"],pointValKey:"high",doQuartiles:!1});SeriesRegistry$1.registerSeriesType("errorbar",ErrorBarSeries);var __extends$v=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),Point$1=SeriesRegistry$1.series.prototype.pointClass,GaugePoint=function(n){__extends$v(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t.shapeArgs=void 0,t}return r.prototype.setState=function(t){this.state=t},r}(Point$1),__extends$u=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),noop$6=H.noop,Series$a=SeriesRegistry$1.series,ColumnSeries$9=SeriesRegistry$1.seriesTypes.column,clamp$5=Utilities.clamp,isNumber$e=Utilities.isNumber,extend$x=Utilities.extend,merge$t=Utilities.merge,pick$z=Utilities.pick,pInt$1=Utilities.pInt,GaugeSeries$1=function(n){__extends$u(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.points=void 0,t.options=void 0,t.yAxis=void 0,t}return r.prototype.translate=function(){var t=this,o=t.yAxis,s=t.options,a=o.center;t.generatePoints(),t.points.forEach(function(l){var h=merge$t(s.dial,l.dial),c=pInt$1(pick$z(h.radius,"80%"))*a[2]/200,d=pInt$1(pick$z(h.baseLength,"70%"))*c/100,p=pInt$1(pick$z(h.rearLength,"10%"))*c/100,u=h.baseWidth||3,f=h.topWidth||1,g=s.overshoot,v=o.startAngleRad+o.translate(l.y,null,null,null,!0);(isNumber$e(g)||s.wrap===!1)&&(g=isNumber$e(g)?g/180*Math.PI:0,v=clamp$5(v,o.startAngleRad-g,o.endAngleRad+g)),v=v*180/Math.PI,l.shapeType="path";var m=h.path||[["M",-p,-u/2],["L",d,-u/2],["L",c,-f/2],["L",c,f/2],["L",d,u/2],["L",-p,u/2],["Z"]];l.shapeArgs={d:m,translateX:a[0],translateY:a[1],rotation:v},l.plotX=a[0],l.plotY=a[1]})},r.prototype.drawPoints=function(){var t=this,o=t.chart,s=t.yAxis.center,a=t.pivot,l=t.options,h=l.pivot,c=o.renderer;t.points.forEach(function(d){var p=d.graphic,u=d.shapeArgs,f=u.d,g=merge$t(l.dial,d.dial);p?(p.animate(u),u.d=f):d.graphic=c[d.shapeType](u).attr({rotation:u.rotation,zIndex:1}).addClass("highcharts-dial").add(t.group),o.styledMode||d.graphic[p?"animate":"attr"]({stroke:g.borderColor||"none","stroke-width":g.borderWidth||0,fill:g.backgroundColor||palette.neutralColor100})}),a?a.animate({translateX:s[0],translateY:s[1]}):(t.pivot=c.circle(0,0,pick$z(h.radius,5)).attr({zIndex:2}).addClass("highcharts-pivot").translate(s[0],s[1]).add(t.group),o.styledMode||t.pivot.attr({"stroke-width":h.borderWidth||0,stroke:h.borderColor||palette.neutralColor20,fill:h.backgroundColor||palette.neutralColor100}))},r.prototype.animate=function(t){var o=this;t||o.points.forEach(function(s){var a=s.graphic;a&&(a.attr({rotation:o.yAxis.startAngleRad*180/Math.PI}),a.animate({rotation:s.shapeArgs.rotation},o.options.animation))})},r.prototype.render=function(){this.group=this.plotGroup("group","series",this.visible?"visible":"hidden",this.options.zIndex,this.chart.seriesGroup),Series$a.prototype.render.call(this),this.group.clip(this.chart.clipRect)},r.prototype.setData=function(t,o){Series$a.prototype.setData.call(this,t,!1),this.processData(),this.generatePoints(),pick$z(o,!0)&&this.chart.redraw()},r.prototype.hasData=function(){return!!this.points.length},r.defaultOptions=merge$t(Series$a.defaultOptions,{dataLabels:{borderColor:palette.neutralColor20,borderRadius:3,borderWidth:1,crop:!1,defer:!1,enabled:!0,verticalAlign:"top",y:15,zIndex:2},dial:{},pivot:{},tooltip:{headerFormat:""},showInLegend:!1}),r}(Series$a);extend$x(GaugeSeries$1.prototype,{angular:!0,directTouch:!0,drawGraph:noop$6,drawTracker:ColumnSeries$9.prototype.drawTracker,fixedBox:!0,forceDL:!0,noSharedTooltip:!0,pointClass:GaugePoint,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("gauge",GaugeSeries$1);var __extends$t=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),BubbleSeries$1=SeriesRegistry$1.seriesTypes.bubble,PackedBubblePoint=function(n){__extends$t(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.degree=NaN,t.mass=NaN,t.radius=NaN,t.options=void 0,t.series=void 0,t.value=null,t}return r.prototype.destroy=function(){return this.series.layout&&this.series.layout.removeElementFromCollection(this,this.series.layout.nodes),Point$2.prototype.destroy.apply(this,arguments)},r.prototype.firePointEvent=function(){var t=this.series,o=t.options;if(this.isParentNode&&o.parentNode){var s=o.allowPointSelect;o.allowPointSelect=o.parentNode.allowPointSelect,Point$2.prototype.firePointEvent.apply(this,arguments),o.allowPointSelect=s}else Point$2.prototype.firePointEvent.apply(this,arguments)},r.prototype.select=function(){var t=this,o=this.series,s=o.chart;t.isParentNode?(s.getSelectedPoints=s.getSelectedParentNodes,Point$2.prototype.select.apply(this,arguments),s.getSelectedPoints=Chart$1.prototype.getSelectedPoints):Point$2.prototype.select.apply(this,arguments)},r}(BubbleSeries$1.prototype.pointClass),addEvent$n=Utilities.addEvent;H.dragNodesMixin={onMouseDown:function(n,r){var t=this.chart.pointer.normalize(r);n.fixedPosition={chartX:t.chartX,chartY:t.chartY,plotX:n.plotX,plotY:n.plotY},n.inDragMode=!0},onMouseMove:function(n,r){if(n.fixedPosition&&n.inDragMode){var t=this,o=t.chart,s=o.pointer.normalize(r),a=n.fixedPosition.chartX-s.chartX,l=n.fixedPosition.chartY-s.chartY,h=void 0,c=void 0,d=o.graphLayoutsLookup;(Math.abs(a)>5||Math.abs(l)>5)&&(h=n.fixedPosition.plotX-a,c=n.fixedPosition.plotY-l,o.isInsidePlot(h,c)&&(n.plotX=h,n.plotY=c,n.hasDragged=!0,this.redrawHalo(n),d.forEach(function(p){p.restartSimulation()})))}},onMouseUp:function(n,r){n.fixedPosition&&(n.hasDragged&&(this.layout.enableSimulation?this.layout.start():this.chart.redraw()),n.inDragMode=n.hasDragged=!1,this.options.fixedDraggable||delete n.fixedPosition)},redrawHalo:function(n){n&&this.halo&&this.halo.attr({d:n.haloPath(this.options.states.hover.halo.size)})}};addEvent$n(Chart$1,"load",function(){var n=this,r,t,o;n.container&&(r=addEvent$n(n.container,"mousedown",function(s){var a=n.hoverPoint;a&&a.series&&a.series.hasDraggableNodes&&a.series.options.draggable&&(a.series.onMouseDown(a,s),t=addEvent$n(n.container,"mousemove",function(l){return a&&a.series&&a.series.onMouseMove(a,l)}),o=addEvent$n(n.container.ownerDocument,"mouseup",function(l){return t(),o(),a&&a.series&&a.series.onMouseUp(a,l)}))})),addEvent$n(n,"destroy",function(){r()})});H.networkgraphIntegrations={verlet:{attractiveForceFunction:function(n,r){return(r-n)/n},repulsiveForceFunction:function(n,r){return(r-n)/n*(r>n?1:0)},barycenter:function(){var n=this.options.gravitationalConstant,r=this.barycenter.xFactor,t=this.barycenter.yFactor;r=(r-(this.box.left+this.box.width)/2)*n,t=(t-(this.box.top+this.box.height)/2)*n,this.nodes.forEach(function(o){o.fixedPosition||(o.plotX-=r/o.mass/o.degree,o.plotY-=t/o.mass/o.degree)})},repulsive:function(n,r,t){var o=r*this.diffTemperature/n.mass/n.degree;n.fixedPosition||(n.plotX+=t.x*o,n.plotY+=t.y*o)},attractive:function(n,r,t){var o=n.getMass(),s=-t.x*r*this.diffTemperature,a=-t.y*r*this.diffTemperature;n.fromNode.fixedPosition||(n.fromNode.plotX-=s*o.fromNode/n.fromNode.degree,n.fromNode.plotY-=a*o.fromNode/n.fromNode.degree),n.toNode.fixedPosition||(n.toNode.plotX+=s*o.toNode/n.toNode.degree,n.toNode.plotY+=a*o.toNode/n.toNode.degree)},integrate:function(n,r){var t=-n.options.friction,o=n.options.maxSpeed,s=r.prevX,a=r.prevY,l=(r.plotX+r.dispX-s)*t,h=(r.plotY+r.dispY-a)*t,c=Math.abs,d=c(l)/(l||1),p=c(h)/(h||1);l=d*Math.min(o,Math.abs(l)),h=p*Math.min(o,Math.abs(h)),r.prevX=r.plotX+r.dispX,r.prevY=r.plotY+r.dispY,r.plotX+=l,r.plotY+=h,r.temperature=n.vectorLength({x:l,y:h})},getK:function(n){return Math.pow(n.box.width*n.box.height/n.nodes.length,.5)}},euler:{attractiveForceFunction:function(n,r){return n*n/r},repulsiveForceFunction:function(n,r){return r*r/n},barycenter:function(){var n=this.options.gravitationalConstant,r=this.barycenter.xFactor,t=this.barycenter.yFactor;this.nodes.forEach(function(o){if(!o.fixedPosition){var s=o.getDegree(),a=s*(1+s/2);o.dispX+=(r-o.plotX)*n*a/o.degree,o.dispY+=(t-o.plotY)*n*a/o.degree}})},repulsive:function(n,r,t,o){n.dispX+=t.x/o*r/n.degree,n.dispY+=t.y/o*r/n.degree},attractive:function(n,r,t,o){var s=n.getMass(),a=t.x/o*r,l=t.y/o*r;n.fromNode.fixedPosition||(n.fromNode.dispX-=a*s.fromNode/n.fromNode.degree,n.fromNode.dispY-=l*s.fromNode/n.fromNode.degree),n.toNode.fixedPosition||(n.toNode.dispX+=a*s.toNode/n.toNode.degree,n.toNode.dispY+=l*s.toNode/n.toNode.degree)},integrate:function(n,r){var t;r.dispX+=r.dispX*n.options.friction,r.dispY+=r.dispY*n.options.friction,t=r.temperature=n.vectorLength({x:r.dispX,y:r.dispY}),t!==0&&(r.plotX+=r.dispX/t*Math.min(Math.abs(r.dispX),n.temperature),r.plotY+=r.dispY/t*Math.min(Math.abs(r.dispY),n.temperature))},getK:function(n){return Math.pow(n.box.width*n.box.height/n.nodes.length,.3)}}};var extend$w=Utilities.extend,QuadTreeNode=H.QuadTreeNode=function(n){this.box=n,this.boxSize=Math.min(n.width,n.height),this.nodes=[],this.isInternal=!1,this.body=!1,this.isEmpty=!0};extend$w(QuadTreeNode.prototype,{insert:function(n,r){var t;this.isInternal?this.nodes[this.getBoxPosition(n)].insert(n,r-1):(this.isEmpty=!1,this.body?r?(this.isInternal=!0,this.divideBox(),this.body!==!0&&(this.nodes[this.getBoxPosition(this.body)].insert(this.body,r-1),this.body=!0),this.nodes[this.getBoxPosition(n)].insert(n,r-1)):(t=new QuadTreeNode({top:n.plotX,left:n.plotY,width:.1,height:.1}),t.body=n,t.isInternal=!1,this.nodes.push(t)):(this.isInternal=!1,this.body=n))},updateMassAndCenter:function(){var n=0,r=0,t=0;this.isInternal?(this.nodes.forEach(function(o){o.isEmpty||(n+=o.mass,r+=o.plotX*o.mass,t+=o.plotY*o.mass)}),r/=n,t/=n):this.body&&(n=this.body.mass,r=this.body.plotX,t=this.body.plotY),this.mass=n,this.plotX=r,this.plotY=t},divideBox:function(){var n=this.box.width/2,r=this.box.height/2;this.nodes[0]=new QuadTreeNode({left:this.box.left,top:this.box.top,width:n,height:r}),this.nodes[1]=new QuadTreeNode({left:this.box.left+n,top:this.box.top,width:n,height:r}),this.nodes[2]=new QuadTreeNode({left:this.box.left+n,top:this.box.top+r,width:n,height:r}),this.nodes[3]=new QuadTreeNode({left:this.box.left,top:this.box.top+r,width:n,height:r})},getBoxPosition:function(n){var r=n.plotX<this.box.left+this.box.width/2,t=n.plotY<this.box.top+this.box.height/2,o;return r?t?o=0:o=3:t?o=1:o=2,o}});var QuadTree=H.QuadTree=function(n,r,t,o){this.box={left:n,top:r,width:t,height:o},this.maxDepth=25,this.root=new QuadTreeNode(this.box,"0"),this.root.isInternal=!0,this.root.isRoot=!0,this.root.divideBox()};extend$w(QuadTree.prototype,{insertNodes:function(n){n.forEach(function(r){this.root.insert(r,this.maxDepth)},this)},visitNodeRecursive:function(n,r,t){var o;n||(n=this.root),n===this.root&&r&&(o=r(n)),o!==!1&&(n.nodes.forEach(function(s){if(s.isInternal){if(r&&(o=r(s)),o===!1)return;this.visitNodeRecursive(s,r,t)}else s.body&&r&&r(s.body);t&&t(s)},this),n===this.root&&t&&t(n))},calculateMassAndCenter:function(){this.visitNodeRecursive(null,null,function(n){n.updateMassAndCenter()})}});var setAnimation=animationExports.setAnimation,addEvent$m=Utilities.addEvent,clamp$4=Utilities.clamp,defined$e=Utilities.defined,extend$v=Utilities.extend,isFunction=Utilities.isFunction,pick$y=Utilities.pick;H.layouts={"reingold-fruchterman":function(){}};extend$v(H.layouts["reingold-fruchterman"].prototype,{init:function(n){this.options=n,this.nodes=[],this.links=[],this.series=[],this.box={x:0,y:0,width:0,height:0},this.setInitialRendering(!0),this.integration=H.networkgraphIntegrations[n.integration],this.enableSimulation=n.enableSimulation,this.attractiveForce=pick$y(n.attractiveForce,this.integration.attractiveForceFunction),this.repulsiveForce=pick$y(n.repulsiveForce,this.integration.repulsiveForceFunction),this.approximation=n.approximation},updateSimulation:function(n){this.enableSimulation=pick$y(n,this.options.enableSimulation)},start:function(){var n=this,r=this.series,t=this.options;n.currentStep=0,n.forces=r[0]&&r[0].forces||[],n.chart=r[0]&&r[0].chart,n.initialRendering&&(n.initPositions(),r.forEach(function(o){o.finishedAnimating=!0,o.render()})),n.setK(),n.resetSimulation(t),n.enableSimulation&&n.step()},step:function(){var n=this,r=this.series;this.options,n.currentStep++,n.approximation==="barnes-hut"&&(n.createQuadTree(),n.quadTree.calculateMassAndCenter()),n.forces.forEach(function(t){n[t+"Forces"](n.temperature)}),n.applyLimits(n.temperature),n.temperature=n.coolDown(n.startTemperature,n.diffTemperature,n.currentStep),n.prevSystemTemperature=n.systemTemperature,n.systemTemperature=n.getSystemTemperature(),n.enableSimulation&&(r.forEach(function(t){t.chart&&t.render()}),n.maxIterations--&&isFinite(n.temperature)&&!n.isStable()?(n.simulation&&H.win.cancelAnimationFrame(n.simulation),n.simulation=H.win.requestAnimationFrame(function(){n.step()})):n.simulation=!1)},stop:function(){this.simulation&&H.win.cancelAnimationFrame(this.simulation)},setArea:function(n,r,t,o){this.box={left:n,top:r,width:t,height:o}},setK:function(){this.k=this.options.linkLength||this.integration.getK(this)},addElementsToCollection:function(n,r){n.forEach(function(t){r.indexOf(t)===-1&&r.push(t)})},removeElementFromCollection:function(n,r){var t=r.indexOf(n);t!==-1&&r.splice(t,1)},clear:function(){this.nodes.length=0,this.links.length=0,this.series.length=0,this.resetSimulation()},resetSimulation:function(){this.forcedStop=!1,this.systemTemperature=0,this.setMaxIterations(),this.setTemperature(),this.setDiffTemperature()},restartSimulation:function(){this.simulation?this.resetSimulation():(this.setInitialRendering(!1),this.enableSimulation?this.start():this.setMaxIterations(1),this.chart&&this.chart.redraw(),this.setInitialRendering(!0))},setMaxIterations:function(n){this.maxIterations=pick$y(n,this.options.maxIterations)},setTemperature:function(){this.temperature=this.startTemperature=Math.sqrt(this.nodes.length)},setDiffTemperature:function(){this.diffTemperature=this.startTemperature/(this.options.maxIterations+1)},setInitialRendering:function(n){this.initialRendering=n},createQuadTree:function(){this.quadTree=new H.QuadTree(this.box.left,this.box.top,this.box.width,this.box.height),this.quadTree.insertNodes(this.nodes)},initPositions:function(){var n=this.options.initialPositions;isFunction(n)?(n.call(this),this.nodes.forEach(function(r){defined$e(r.prevX)||(r.prevX=r.plotX),defined$e(r.prevY)||(r.prevY=r.plotY),r.dispX=0,r.dispY=0})):n==="circle"?this.setCircularPositions():this.setRandomPositions()},setCircularPositions:function(){var n=this.box,r=this.nodes,t=r.length+1,o=2*Math.PI/t,s=r.filter(function(d){return d.linksTo.length===0}),a=[],l={},h=this.options.initialPositionRadius;function c(d){d.linksFrom.forEach(function(p){l[p.toNode.id]||(l[p.toNode.id]=!0,a.push(p.toNode),c(p.toNode))})}s.forEach(function(d){a.push(d),c(d)}),a.length?r.forEach(function(d){a.indexOf(d)===-1&&a.push(d)}):a=r,a.forEach(function(d,p){d.plotX=d.prevX=pick$y(d.plotX,n.width/2+h*Math.cos(p*o)),d.plotY=d.prevY=pick$y(d.plotY,n.height/2+h*Math.sin(p*o)),d.dispX=0,d.dispY=0})},setRandomPositions:function(){var n=this.box,r=this.nodes,t=r.length+1;function o(s){var a=s*s/Math.PI;return a=a-Math.floor(a),a}r.forEach(function(s,a){s.plotX=s.prevX=pick$y(s.plotX,n.width*o(a)),s.plotY=s.prevY=pick$y(s.plotY,n.height*o(t+a)),s.dispX=0,s.dispY=0})},force:function(n){this.integration[n].apply(this,Array.prototype.slice.call(arguments,1))},barycenterForces:function(){this.getBarycenter(),this.force("barycenter")},getBarycenter:function(){var n=0,r=0,t=0;return this.nodes.forEach(function(o){r+=o.plotX*o.mass,t+=o.plotY*o.mass,n+=o.mass}),this.barycenter={x:r,y:t,xFactor:r/n,yFactor:t/n},this.barycenter},barnesHutApproximation:function(n,r){var t=this,o=t.getDistXY(n,r),s=t.vectorLength(o),a,l;return n!==r&&s!==0&&(r.isInternal?r.boxSize/s<t.options.theta&&s!==0?(l=t.repulsiveForce(s,t.k),t.force("repulsive",n,l*r.mass,o,s),a=!1):a=!0:(l=t.repulsiveForce(s,t.k),t.force("repulsive",n,l*r.mass,o,s))),a},repulsiveForces:function(){var n=this;n.approximation==="barnes-hut"?n.nodes.forEach(function(r){n.quadTree.visitNodeRecursive(null,function(t){return n.barnesHutApproximation(r,t)})}):n.nodes.forEach(function(r){n.nodes.forEach(function(t){var o,s,a;r!==t&&!r.fixedPosition&&(a=n.getDistXY(r,t),s=n.vectorLength(a),s!==0&&(o=n.repulsiveForce(s,n.k),n.force("repulsive",r,o*t.mass,a,s)))})})},attractiveForces:function(){var n=this,r,t,o;n.links.forEach(function(s){s.fromNode&&s.toNode&&(r=n.getDistXY(s.fromNode,s.toNode),t=n.vectorLength(r),t!==0&&(o=n.attractiveForce(t,n.k),n.force("attractive",s,o,r,t)))})},applyLimits:function(){var n=this,r=n.nodes;r.forEach(function(t){t.fixedPosition||(n.integration.integrate(n,t),n.applyLimitBox(t,n.box),t.dispX=0,t.dispY=0)})},applyLimitBox:function(n,r){var t=n.radius;n.plotX=clamp$4(n.plotX,r.left+t,r.width-t),n.plotY=clamp$4(n.plotY,r.top+t,r.height-t)},coolDown:function(n,r,t){return n-r*t},isStable:function(){return Math.abs(this.systemTemperature-this.prevSystemTemperature)<1e-5||this.temperature<=0},getSystemTemperature:function(){return this.nodes.reduce(function(n,r){return n+r.temperature},0)},vectorLength:function(n){return Math.sqrt(n.x*n.x+n.y*n.y)},getDistR:function(n,r){var t=this.getDistXY(n,r);return this.vectorLength(t)},getDistXY:function(n,r){var t=n.plotX-r.plotX,o=n.plotY-r.plotY;return{x:t,y:o,absX:Math.abs(t),absY:Math.abs(o)}}});addEvent$m(Chart$1,"predraw",function(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(n){n.stop()})});addEvent$m(Chart$1,"render",function(){var n,r=!1;function t(o){o.maxIterations--&&isFinite(o.temperature)&&!o.isStable()&&!o.enableSimulation&&(o.beforeStep&&o.beforeStep(),o.step(),n=!1,r=!0)}if(this.graphLayoutsLookup){for(setAnimation(!1,this),this.graphLayoutsLookup.forEach(function(o){o.start()});!n;)n=!0,this.graphLayoutsLookup.forEach(t);r&&this.series.forEach(function(o){o&&o.layout&&o.render()})}});addEvent$m(Chart$1,"beforePrint",function(){this.graphLayoutsLookup&&(this.graphLayoutsLookup.forEach(function(n){n.updateSimulation(!1)}),this.redraw())});addEvent$m(Chart$1,"afterPrint",function(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(n){n.updateSimulation()}),this.redraw()});var Reingold=H.layouts["reingold-fruchterman"],addEvent$l=Utilities.addEvent,extendClass=Utilities.extendClass,pick$x=Utilities.pick;Chart$1.prototype.getSelectedParentNodes=function(){var n=this,r=n.series,t=[];return r.forEach(function(o){o.parentNode&&o.parentNode.selected&&t.push(o.parentNode)}),t};H.networkgraphIntegrations.packedbubble={repulsiveForceFunction:function(n,r,t,o){return Math.min(n,(t.marker.radius+o.marker.radius)/2)},barycenter:function(){var n=this,r=n.options.gravitationalConstant,t=n.box,o=n.nodes,s,a;o.forEach(function(l){n.options.splitSeries&&!l.isParentNode?(s=l.series.parentNode.plotX,a=l.series.parentNode.plotY):(s=t.width/2,a=t.height/2),l.fixedPosition||(l.plotX-=(l.plotX-s)*r/(l.mass*Math.sqrt(o.length)),l.plotY-=(l.plotY-a)*r/(l.mass*Math.sqrt(o.length)))})},repulsive:function(n,r,t,o){var s=r*this.diffTemperature/n.mass/n.degree,a=t.x*s,l=t.y*s;n.fixedPosition||(n.plotX+=a,n.plotY+=l),o.fixedPosition||(o.plotX-=a,o.plotY-=l)},integrate:H.networkgraphIntegrations.verlet.integrate,getK:H.noop};H.layouts.packedbubble=extendClass(Reingold,{beforeStep:function(){this.options.marker&&this.series.forEach(function(n){n&&n.calculateParentRadius()})},isStable:function(){var n=Math.abs(this.prevSystemTemperature-this.systemTemperature),r=10*this.systemTemperature/Math.sqrt(this.nodes.length);return Math.abs(r)<1&&n<1e-5||this.temperature<=0},setCircularPositions:function(){var n=this,r=n.box,t=n.nodes,o=t.length+1,s=2*Math.PI/o,a,l,h=n.options.initialPositionRadius;t.forEach(function(c,d){n.options.splitSeries&&!c.isParentNode?(a=c.series.parentNode.plotX,l=c.series.parentNode.plotY):(a=r.width/2,l=r.height/2),c.plotX=c.prevX=pick$x(c.plotX,a+h*Math.cos(c.index||d*s)),c.plotY=c.prevY=pick$x(c.plotY,l+h*Math.sin(c.index||d*s)),c.dispX=0,c.dispY=0})},repulsiveForces:function(){var n=this,r,t,o,s=n.options.bubblePadding;n.nodes.forEach(function(a){a.degree=a.mass,a.neighbours=0,n.nodes.forEach(function(l){r=0,a!==l&&!a.fixedPosition&&(n.options.seriesInteraction||a.series===l.series)&&(o=n.getDistXY(a,l),t=n.vectorLength(o)-(a.marker.radius+l.marker.radius+s),t<0&&(a.degree+=.01,a.neighbours++,r=n.repulsiveForce(-t/Math.sqrt(a.neighbours),n.k,a,l)),n.force("repulsive",a,r*l.mass,o,l,t))})})},applyLimitBox:function(n){var r=this,t,o,s=.01;r.options.splitSeries&&!n.isParentNode&&r.options.parentNodeLimit&&(t=r.getDistXY(n,n.series.parentNode),o=n.series.parentNodeRadius-n.marker.radius-r.vectorLength(t),o<0&&o>-2*n.marker.radius&&(n.plotX-=t.x*s,n.plotY-=t.y*s)),Reingold.prototype.applyLimitBox.apply(this,arguments)}});addEvent$l(Chart$1,"beforeRedraw",function(){this.allDataPoints&&delete this.allDataPoints});var __extends$s=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),color$8=Color.parse,Series$9=SeriesRegistry$1.series,BubbleSeries=SeriesRegistry$1.seriesTypes.bubble,addEvent$k=Utilities.addEvent,clamp$3=Utilities.clamp,defined$d=Utilities.defined,extend$u=Utilities.extend,fireEvent$6=Utilities.fireEvent,isArray$4=Utilities.isArray,isNumber$d=Utilities.isNumber,merge$s=Utilities.merge,pick$w=Utilities.pick,dragNodesMixin=H.dragNodesMixin,PackedBubbleSeries=function(n){__extends$s(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.chart=void 0,t.data=void 0,t.layout=void 0,t.options=void 0,t.points=void 0,t.xData=void 0,t}return r.prototype.accumulateAllPoints=function(t){var o=t.chart,s=[],a,l;for(a=0;a<o.series.length;a++)if(t=o.series[a],t.is("packedbubble")&&t.visible||!o.options.chart.ignoreHiddenSeries)for(l=0;l<t.yData.length;l++)s.push([null,null,t.yData[l],t.index,l,{id:l,marker:{radius:0}}]);return s},r.prototype.addLayout=function(){var t=this,o=t.options.layoutAlgorithm,s=t.chart.graphLayoutsStorage,a=t.chart.graphLayoutsLookup,l=t.chart.options.chart,h;s||(t.chart.graphLayoutsStorage=s={},t.chart.graphLayoutsLookup=a=[]),h=s[o.type],h||(o.enableSimulation=defined$d(l.forExport)?!l.forExport:o.enableSimulation,s[o.type]=h=new H.layouts[o.type],h.init(o),a.splice(h.index,0,h)),t.layout=h,t.points.forEach(function(c){c.mass=2,c.degree=1,c.collisionNmb=1}),h.setArea(0,0,t.chart.plotWidth,t.chart.plotHeight),h.addElementsToCollection([t],h.series),h.addElementsToCollection(t.points,h.nodes)},r.prototype.addSeriesLayout=function(){var t=this,o=t.options.layoutAlgorithm,s=t.chart.graphLayoutsStorage,a=t.chart.graphLayoutsLookup,l=merge$s(o,o.parentNodeOptions,{enableSimulation:t.layout.options.enableSimulation}),h;h=s[o.type+"-series"],h||(s[o.type+"-series"]=h=new H.layouts[o.type],h.init(l),a.splice(h.index,0,h)),t.parentNodeLayout=h,this.createParentNodes()},r.prototype.calculateParentRadius=function(){var t=this,o,s=20,a=20;o=t.seriesBox(),t.parentNodeRadius=clamp$3(Math.sqrt(2*t.parentNodeMass/Math.PI)+s,a,o?Math.max(Math.sqrt(Math.pow(o.width,2)+Math.pow(o.height,2))/2+s,a):Math.sqrt(2*t.parentNodeMass/Math.PI)+s),t.parentNode&&(t.parentNode.marker.radius=t.parentNode.radius=t.parentNodeRadius)},r.prototype.calculateZExtremes=function(){var t=this.chart,o=this.options.zMin,s=this.options.zMax,a=1/0,l=-1/0;return o&&s?[o,s]:(t.series.forEach(function(h){h.yData.forEach(function(c){defined$d(c)&&(c>l&&(l=c),c<a&&(a=c))})}),o=pick$w(o,a),s=pick$w(s,l),[o,s])},r.prototype.checkOverlap=function(t,o){var s=t[0]-o[0],a=t[1]-o[1],l=t[2]+o[2];return Math.sqrt(s*s+a*a)-Math.abs(l)<-.001},r.prototype.createParentNodes=function(){var t=this,o=t.chart,s=t.parentNodeLayout,a,l=t.parentNode,h=t.pointClass;t.parentNodeMass=0,t.points.forEach(function(c){t.parentNodeMass+=Math.PI*Math.pow(c.marker.radius,2)}),t.calculateParentRadius(),s.nodes.forEach(function(c){c.seriesIndex===t.index&&(a=!0)}),s.setArea(0,0,o.plotWidth,o.plotHeight),a||(l||(l=new h().init(this,{mass:t.parentNodeRadius/2,marker:{radius:t.parentNodeRadius},dataLabels:{inside:!1},dataLabelOnNull:!0,degree:t.parentNodeRadius,isParentNode:!0,seriesIndex:t.index})),t.parentNode&&(l.plotX=t.parentNode.plotX,l.plotY=t.parentNode.plotY),t.parentNode=l,s.addElementsToCollection([t],s.series),s.addElementsToCollection([l],s.nodes))},r.prototype.deferLayout=function(){var t=this,o=t.options.layoutAlgorithm;t.visible&&(t.addLayout(),o.splitSeries&&t.addSeriesLayout())},r.prototype.destroy=function(){this.chart.graphLayoutsLookup&&this.chart.graphLayoutsLookup.forEach(function(t){t.removeElementFromCollection(this,t.series)},this),this.parentNode&&this.parentNodeLayout&&(this.parentNodeLayout.removeElementFromCollection(this.parentNode,this.parentNodeLayout.nodes),this.parentNode.dataLabel&&(this.parentNode.dataLabel=this.parentNode.dataLabel.destroy())),Series$9.prototype.destroy.apply(this,arguments)},r.prototype.drawDataLabels=function(){var t=this.options.dataLabels.textPath,o=this.points;Series$9.prototype.drawDataLabels.apply(this,arguments),this.parentNode&&(this.parentNode.formatPrefix="parentNode",this.points=[this.parentNode],this.options.dataLabels.textPath=this.options.dataLabels.parentNodeTextPath,Series$9.prototype.drawDataLabels.apply(this,arguments),this.points=o,this.options.dataLabels.textPath=t)},r.prototype.drawGraph=function(){if(!(!this.layout||!this.layout.options.splitSeries)){var t=this,o=t.chart,s={},a=this.layout.options.parentNodeOptions.marker,l={fill:a.fillColor||color$8(t.color).brighten(.4).get(),opacity:a.fillOpacity,stroke:a.lineColor||t.color,"stroke-width":a.lineWidth};this.parentNodesGroup||(t.parentNodesGroup=t.plotGroup("parentNodesGroup","parentNode",t.visible?"inherit":"hidden",.1,o.seriesGroup),t.group.attr({zIndex:2})),this.calculateParentRadius(),s=merge$s({x:t.parentNode.plotX-t.parentNodeRadius,y:t.parentNode.plotY-t.parentNodeRadius,width:t.parentNodeRadius*2,height:t.parentNodeRadius*2},l),t.parentNode.graphic||(t.graph=t.parentNode.graphic=o.renderer.symbol(l.symbol).add(t.parentNodesGroup)),t.parentNode.graphic.attr(s)}},r.prototype.drawTracker=function(){var t=this,o=t.parentNode,s;n.prototype.drawTracker.call(this),o&&(s=isArray$4(o.dataLabels)?o.dataLabels:o.dataLabel?[o.dataLabel]:[],o.graphic&&(o.graphic.element.point=o),s.forEach(function(a){a.div?a.div.point=o:a.element.point=o}))},r.prototype.getPointRadius=function(){var t=this,o=t.chart,s=o.plotWidth,a=o.plotHeight,l=t.options,h=l.useSimulation,c=Math.min(s,a),d={},p=[],u=o.allDataPoints,f,g,v,m,x;["minSize","maxSize"].forEach(function(y){var b=parseInt(l[y],10),$=/%$/.test(l[y]);d[y]=$?c*b/100:b*Math.sqrt(u.length)}),o.minRadius=f=d.minSize/Math.sqrt(u.length),o.maxRadius=g=d.maxSize/Math.sqrt(u.length),x=h?t.calculateZExtremes():[f,g],(u||[]).forEach(function(y,b){v=h?clamp$3(y[2],x[0],x[1]):y[2],m=t.getRadius(x[0],x[1],f,g,v),m===0&&(m=null),u[b][2]=m,p.push(m)}),t.radii=p},r.prototype.init=function(){return Series$9.prototype.init.apply(this,arguments),this.eventsToUnbind.push(addEvent$k(this,"updatedData",function(){this.chart.series.forEach(function(t){t.type===this.type&&(t.isDirty=!0)},this)})),this},r.prototype.onMouseUp=function(t){if(t.fixedPosition&&!t.removed){var o,s,a=this.layout,l=this.parentNodeLayout;l&&a.options.dragBetweenSeries&&l.nodes.forEach(function(h){t&&t.marker&&h!==t.series.parentNode&&(o=a.getDistXY(t,h),s=a.vectorLength(o)-h.marker.radius-t.marker.radius,s<0&&(h.series.addPoint(merge$s(t.options,{plotX:t.plotX,plotY:t.plotY}),!1),a.removeElementFromCollection(t,a.nodes),t.remove()))}),dragNodesMixin.onMouseUp.apply(this,arguments)}},r.prototype.placeBubbles=function(t){var o=this,s=o.checkOverlap,a=o.positionBubble,l=[],h=1,c=0,d=0,p,u,f=[],g;if(u=t.sort(function(v,m){return m[2]-v[2]}),u.length){if(l.push([[0,0,u[0][2],u[0][3],u[0][4]]]),u.length>1)for(l.push([[0,0-u[1][2]-u[0][2],u[1][2],u[1][3],u[1][4]]]),g=2;g<u.length;g++)u[g][2]=u[g][2]||1,p=a(l[h][c],l[h-1][d],u[g]),s(p,l[h][0])?(l.push([]),d=0,l[h+1].push(a(l[h][c],l[h][0],u[g])),h++,c=0):h>1&&l[h-1][d+1]&&s(p,l[h-1][d+1])?(d++,l[h].push(a(l[h][c],l[h-1][d],u[g])),c++):(c++,l[h].push(p));o.chart.stages=l,o.chart.rawPositions=[].concat.apply([],l),o.resizeRadius(),f=o.chart.rawPositions}return f},r.prototype.positionBubble=function(t,o,s){var a=Math.sqrt,l=Math.asin,h=Math.acos,c=Math.pow,d=Math.abs,p=a(c(t[0]-o[0],2)+c(t[1]-o[1],2)),u=h((c(p,2)+c(s[2]+o[2],2)-c(s[2]+t[2],2))/(2*(s[2]+o[2])*p)),f=l(d(t[0]-o[0])/p),g=t[1]-o[1]<0?0:Math.PI,v=(t[0]-o[0])*(t[1]-o[1])<0?1:-1,m=g+u+f*v,x=Math.cos(m),y=Math.sin(m),b=o[0]+(o[2]+s[2])*y,$=o[1]-(o[2]+s[2])*x;return[b,$,s[2],s[3],s[4]]},r.prototype.render=function(){var t=this,o=[];Series$9.prototype.render.apply(this,arguments),t.options.dataLabels.allowOverlap||(t.data.forEach(function(s){isArray$4(s.dataLabels)&&s.dataLabels.forEach(function(a){o.push(a)})}),t.options.useSimulation&&t.chart.hideOverlappingLabels(o))},r.prototype.resizeRadius=function(){var t=this.chart,o=t.rawPositions,s=Math.min,a=Math.max,l=t.plotLeft,h=t.plotTop,c=t.plotHeight,d=t.plotWidth,p,u,f,g,v,m,x,y,b;for(p=f=Number.POSITIVE_INFINITY,u=g=Number.NEGATIVE_INFINITY,b=0;b<o.length;b++)v=o[b][2],p=s(p,o[b][0]-v),u=a(u,o[b][0]+v),f=s(f,o[b][1]-v),g=a(g,o[b][1]+v);if(m=[u-p,g-f],x=[(d-l)/m[0],(c-h)/m[1]],y=s.apply([],x),Math.abs(y-1)>1e-10){for(b=0;b<o.length;b++)o[b][2]*=y;this.placeBubbles(o)}else t.diffY=c/2+h-f-(g-f)/2,t.diffX=d/2+l-p-(u-p)/2},r.prototype.seriesBox=function(){var t=this,o=t.chart,s=t.data,a=Math.max,l=Math.min,h,c=[o.plotLeft,o.plotLeft+o.plotWidth,o.plotTop,o.plotTop+o.plotHeight];return s.forEach(function(d){defined$d(d.plotX)&&defined$d(d.plotY)&&d.marker.radius&&(h=d.marker.radius,c[0]=l(c[0],d.plotX-h),c[1]=a(c[1],d.plotX+h),c[2]=l(c[2],d.plotY-h),c[3]=a(c[3],d.plotY+h))}),isNumber$d(c.width/c.height)?c:null},r.prototype.setVisible=function(){var t=this;Series$9.prototype.setVisible.apply(t,arguments),t.parentNodeLayout&&t.graph?t.visible?(t.graph.show(),t.parentNode.dataLabel&&t.parentNode.dataLabel.show()):(t.graph.hide(),t.parentNodeLayout.removeElementFromCollection(t.parentNode,t.parentNodeLayout.nodes),t.parentNode.dataLabel&&t.parentNode.dataLabel.hide()):t.layout&&(t.visible?t.layout.addElementsToCollection(t.points,t.layout.nodes):t.points.forEach(function(o){t.layout.removeElementFromCollection(o,t.layout.nodes)}))},r.prototype.translate=function(){var t=this,o=t.chart,s=t.data,a=t.index,l,h,c,d,p=t.options.useSimulation;for(t.processedXData=t.xData,t.generatePoints(),defined$d(o.allDataPoints)||(o.allDataPoints=t.accumulateAllPoints(t),t.getPointRadius()),p?c=o.allDataPoints:(c=t.placeBubbles(o.allDataPoints),t.options.draggable=!1),d=0;d<c.length;d++)c[d][3]===a&&(l=s[c[d][4]],h=pick$w(c[d][2],void 0),p||(l.plotX=c[d][0]-o.plotLeft+o.diffX,l.plotY=c[d][1]-o.plotTop+o.diffY),isNumber$d(h)&&(l.marker=extend$u(l.marker,{radius:h,width:2*h,height:2*h}),l.radius=h));p&&t.deferLayout(),fireEvent$6(t,"afterTranslate")},r.defaultOptions=merge$s(BubbleSeries.defaultOptions,{minSize:"10%",maxSize:"50%",sizeBy:"area",zoneAxis:"y",crisp:!1,tooltip:{pointFormat:"Value: {point.value}"},draggable:!0,useSimulation:!0,parentNode:{allowPointSelect:!1},dataLabels:{formatter:function(){var t=this.series.chart.numberFormatter,o=this.point.value;return isNumber$d(o)?t(o,-1):""},parentNodeFormatter:function(){return this.name},parentNodeTextPath:{enabled:!0},padding:0,style:{transition:"opacity 2000ms"}},layoutAlgorithm:{initialPositions:"circle",initialPositionRadius:20,bubblePadding:5,parentNodeLimit:!1,seriesInteraction:!0,dragBetweenSeries:!1,parentNodeOptions:{maxIterations:400,gravitationalConstant:.03,maxSpeed:50,initialPositionRadius:100,seriesInteraction:!0,marker:{fillColor:null,fillOpacity:1,lineWidth:1,lineColor:null,symbol:"circle"}},enableSimulation:!0,type:"packedbubble",integration:"packedbubble",maxIterations:1e3,splitSeries:!1,maxSpeed:5,gravitationalConstant:.01,friction:-.981}}),r}(BubbleSeries);extend$u(PackedBubbleSeries.prototype,{alignDataLabel:Series$9.prototype.alignDataLabel,axisTypes:[],directTouch:!0,forces:["barycenter","repulsive"],hasDraggableNodes:!0,isCartesian:!1,noSharedTooltip:!0,onMouseDown:dragNodesMixin.onMouseDown,onMouseMove:dragNodesMixin.onMouseMove,pointArrayMap:["value"],pointClass:PackedBubblePoint,pointValKey:"value",redrawHalo:dragNodesMixin.redrawHalo,requireSorting:!1,searchPoint:H.noop,trackerGroups:["group","dataLabelsGroup","parentNodesGroup"]});SeriesRegistry$1.registerSeriesType("packedbubble",PackedBubbleSeries);var __extends$r=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),noop$5=H.noop,Series$8=SeriesRegistry$1.series,_a$8=SeriesRegistry$1.seriesTypes,AreaSeries=_a$8.area,LineSeries$2=_a$8.line,ScatterSeries$2=_a$8.scatter,extend$t=Utilities.extend,merge$r=Utilities.merge,PolygonSeries=function(n){__extends$r(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.getGraphPath=function(){for(var t=LineSeries$2.prototype.getGraphPath.call(this),o=t.length+1;o--;)(o===t.length||t[o][0]==="M")&&o>0&&t.splice(o,0,["Z"]);return this.areaPath=t,t},r.prototype.drawGraph=function(){this.options.fillColor=this.color,AreaSeries.prototype.drawGraph.call(this)},r.defaultOptions=merge$r(ScatterSeries$2.defaultOptions,{marker:{enabled:!1,states:{hover:{enabled:!1}}},stickyTracking:!1,tooltip:{followPointer:!0,pointFormat:""},trackByArea:!0}),r}(ScatterSeries$2);extend$t(PolygonSeries.prototype,{type:"polygon",drawLegendSymbol:LegendSymbol$1.drawRectangle,drawTracker:Series$8.prototype.drawTracker,setStackedPoints:noop$5});SeriesRegistry$1.registerSeriesType("polygon",PolygonSeries);var addEvent$j=Utilities.addEvent,objectEach$8=Utilities.objectEach,WaterfallAxis;(function(n){var r=function(){function h(c){this.axis=c,this.stacks={changed:!1}}return h.prototype.renderStackTotals=function(){var c=this.axis,d=c.waterfall.stacks,p=c.stacking&&c.stacking.stackTotalGroup,u=new StackItem$1(c,c.options.stackLabels,!1,0,void 0);this.dummyStackItem=u,objectEach$8(d,function(f){objectEach$8(f,function(g){u.total=g.stackTotal,g.label&&(u.label=g.label),StackItem$1.prototype.render.call(u,p),g.label=u.label,delete u.label})}),u.total=null},h}();n.Composition=r;function t(h,c){addEvent$j(h,"init",l),addEvent$j(h,"afterBuildStacks",o),addEvent$j(h,"afterRender",s),addEvent$j(c,"beforeRedraw",a)}n.compose=t;function o(){var h=this,c=h.waterfall.stacks;c&&(c.changed=!1,delete c.alreadyChanged)}function s(){var h=this,c=h.options.stackLabels;c&&c.enabled&&h.waterfall.stacks&&h.waterfall.renderStackTotals()}function a(){for(var h=this.axes,c=this.series,d=c.length;d--;)c[d].options.stacking&&(h.forEach(function(p){p.isXAxis||(p.waterfall.stacks.changed=!0)}),d=0)}function l(){var h=this;h.waterfall||(h.waterfall=new r(h))}})(WaterfallAxis||(WaterfallAxis={}));const WaterfallAxis$1=WaterfallAxis;var __extends$q=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),isNumber$c=Utilities.isNumber,WaterfallPoint=function(n){__extends$q(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return r.prototype.getClassName=function(){var t=Point$2.prototype.getClassName.call(this);return this.isSum?t+=" highcharts-sum":this.isIntermediateSum&&(t+=" highcharts-intermediate-sum"),t},r.prototype.isValid=function(){return isNumber$c(this.y)||this.isSum||!!this.isIntermediateSum},r}(ColumnSeries$h.prototype.pointClass),__extends$p=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),_a$7=SeriesRegistry$1.seriesTypes,ColumnSeries$8=_a$7.column,LineSeries$1=_a$7.line,arrayMax$1=Utilities.arrayMax,arrayMin$1=Utilities.arrayMin,correctFloat$2=Utilities.correctFloat,extend$s=Utilities.extend,isNumber$b=Utilities.isNumber,merge$q=Utilities.merge,objectEach$7=Utilities.objectEach,pick$v=Utilities.pick;function ownProp(n,r){return Object.hasOwnProperty.call(n,r)}var WaterfallSeries=function(n){__extends$p(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.chart=void 0,t.data=void 0,t.options=void 0,t.points=void 0,t.stackedYNeg=void 0,t.stackedYPos=void 0,t.stackKey=void 0,t.xData=void 0,t.yAxis=void 0,t.yData=void 0,t}return r.prototype.generatePoints=function(){var t,o,s,a;for(ColumnSeries$8.prototype.generatePoints.apply(this),s=0,o=this.points.length;s<o;s++)t=this.points[s],a=this.processedYData[s],(t.isIntermediateSum||t.isSum)&&(t.y=correctFloat$2(a))},r.prototype.translate=function(){var t=this,o=t.options,s=t.yAxis,a,l=pick$v(o.minPointLength,5),h=l/2,c=o.threshold||0,d=c,p=c,u=o.stacking,f=s.waterfall.stacks[t.stackKey],g,v,m;ColumnSeries$8.prototype.translate.apply(t);for(var x=t.points,y=0;y<x.length;y++){var b=x[y],$=t.processedYData[y],S=b.shapeArgs;if(!(!S||!isNumber$b($))){var k=[0,$],A=b.y;if(u){if(f){var P=f[y];u==="overlap"?(g=P.stackState[P.stateIndex--],a=A>=0?g:g-A,ownProp(P,"absolutePos")&&delete P.absolutePos,ownProp(P,"absoluteNeg")&&delete P.absoluteNeg):(A>=0?(g=P.threshold+P.posTotal,P.posTotal-=A,a=g):(g=P.threshold+P.negTotal,P.negTotal-=A,a=g-A),P.posTotal||ownProp(P,"absolutePos")&&(P.posTotal=P.absolutePos,delete P.absolutePos),P.negTotal||ownProp(P,"absoluteNeg")&&(P.negTotal=P.absoluteNeg,delete P.absoluteNeg)),b.isSum||(P.connectorThreshold=P.threshold+P.stackTotal),s.reversed?(v=A>=0?a-A:a+A,m=a):(v=a,m=a-A),b.below=v<=c,S.y=s.translate(v,!1,!0,!1,!0)||0,S.height=Math.abs(S.y-(s.translate(m,!1,!0,!1,!0)||0));var E=s.waterfall.dummyStackItem;E&&(E.x=y,E.label=f[y].label,E.setOffset(t.pointXOffset||0,t.barW||0,t.stackedYNeg[y],t.stackedYPos[y]))}}else a=Math.max(d,d+A)+k[0],S.y=s.translate(a,!1,!0,!1,!0)||0,b.isSum?(S.y=s.translate(k[1],!1,!0,!1,!0)||0,S.height=Math.min(s.translate(k[0],!1,!0,!1,!0)||0,s.len)-S.y,b.below=k[1]<=c):b.isIntermediateSum?(A>=0?(v=k[1]+p,m=p):(v=p,m=k[1]+p),s.reversed&&(v^=m,m^=v,v^=m),S.y=s.translate(v,!1,!0,!1,!0)||0,S.height=Math.abs(S.y-Math.min(s.translate(m,!1,!0,!1,!0)||0,s.len)),p+=k[1],b.below=v<=c):(S.height=$>0?(s.translate(d,!1,!0,!1,!0)||0)-S.y:(s.translate(d,!1,!0,!1,!0)||0)-(s.translate(d-$,!1,!0,!1,!0)||0),d+=$,b.below=d<c),S.height<0&&(S.y+=S.height,S.height*=-1);b.plotY=S.y=Math.round(S.y||0)-t.borderWidth%2/2,S.height=Math.max(Math.round(S.height||0),.001),b.yBottom=S.y+S.height,S.height<=l&&!b.isNull?(S.height=l,S.y-=h,b.plotY=S.y,b.y<0?b.minPointLengthOffset=-h:b.minPointLengthOffset=h):(b.isNull&&(S.width=0),b.minPointLengthOffset=0);var M=b.plotY+(b.negative?S.height:0);b.below&&(b.plotY+=S.height),b.tooltipPos&&(t.chart.inverted?b.tooltipPos[0]=s.len-M:b.tooltipPos[1]=M)}}},r.prototype.processData=function(t){var o=this,s=o.options,a=o.yData,l=s.data,h,c=a.length,d=s.threshold||0,p,u,f,g,v,m;for(u=p=f=g=0,m=0;m<c;m++)v=a[m],h=l&&l[m]?l[m]:{},v==="sum"||h.isSum?a[m]=correctFloat$2(u):v==="intermediateSum"||h.isIntermediateSum?(a[m]=correctFloat$2(p),p=0):(u+=v,p+=v),f=Math.min(u,f),g=Math.max(u,g);n.prototype.processData.call(this,t),s.stacking||(o.dataMin=f+d,o.dataMax=g)},r.prototype.toYData=function(t){return t.isSum?"sum":t.isIntermediateSum?"intermediateSum":t.y},r.prototype.updateParallelArrays=function(t,o){n.prototype.updateParallelArrays.call(this,t,o),(this.yData[0]==="sum"||this.yData[0]==="intermediateSum")&&(this.yData[0]=null)},r.prototype.pointAttribs=function(t,o){var s=this.options.upColor,a;return s&&!t.options.color&&(t.color=t.y>0?s:null),a=ColumnSeries$8.prototype.pointAttribs.call(this,t,o),delete a.dashstyle,a},r.prototype.getGraphPath=function(){return[["M",0,0]]},r.prototype.getCrispPath=function(){var t=this.data,o=this.yAxis,s=t.length,a=Math.round(this.graph.strokeWidth())%2/2,l=Math.round(this.borderWidth)%2/2,h=this.xAxis.reversed,c=this.yAxis.reversed,d=this.options.stacking,p=[],u,f,g,v,m,x,y,b,$;for($=1;$<s;$++)if(b=t[$].shapeArgs,v=t[$-1],y=t[$-1].shapeArgs,f=o.waterfall.stacks[this.stackKey],x=v.y>0?-y.height:0,f&&y&&b&&(g=f[$-1],d?(u=g.connectorThreshold,m=Math.round(o.translate(u,0,1,0,1)+(c?x:0))-a):m=y.y+v.minPointLengthOffset+l-a,p.push(["M",(y.x||0)+(h?0:y.width||0),m],["L",(b.x||0)+(h&&b.width||0),m])),y&&p.length&&(!d&&v.y<0&&!c||v.y>0&&c)){var S=p[p.length-2];S&&typeof S[2]=="number"&&(S[2]+=y.height||0);var k=p[p.length-1];k&&typeof k[2]=="number"&&(k[2]+=y.height||0)}return p},r.prototype.drawGraph=function(){LineSeries$1.prototype.drawGraph.call(this),this.graph.attr({d:this.getCrispPath()})},r.prototype.setStackedPoints=function(){var t=this,o=t.options,s=t.yAxis.waterfall.stacks,a=o.threshold,l=a||0,h=l,c=t.stackKey,d=t.xData,p=d.length,u,f,g,v,m,x,y,b,$,S,k,A,P;function E(T,O,L,C){if(!x)f.stackState[0]=T,x=f.stackState.length;else for(L;L<x;L++)f.stackState[L]+=C;f.stackState.push(f.stackState[x-1]+O)}if(t.yAxis.stacking.usePercentage=!1,g=v=m=l,t.visible||!t.chart.options.chart.ignoreHiddenSeries){P=s.changed,A=s.alreadyChanged,A&&A.indexOf(c)<0&&(P=!0),s[c]||(s[c]={}),u=s[c];for(var M=0;M<p;M++)k=d[M],(!u[k]||P)&&(u[k]={negTotal:0,posTotal:0,stackTotal:0,threshold:0,stateIndex:0,stackState:[],label:P&&u[k]?u[k].label:void 0}),f=u[k],S=t.yData[M],S>=0?f.posTotal+=S:f.negTotal+=S,$=o.data[M],y=f.absolutePos=f.posTotal,b=f.absoluteNeg=f.negTotal,f.stackTotal=y+b,x=f.stackState.length,$&&$.isIntermediateSum?(E(m,v,0,m),m=v,v=a,l^=h,h^=l,l^=h):$&&$.isSum?(E(a,g,x),l=a):(E(l,S,0,g),$&&(g+=S,v+=S)),f.stateIndex++,f.threshold=l,l+=f.stackTotal;s.changed=!1,s.alreadyChanged||(s.alreadyChanged=[]),s.alreadyChanged.push(c)}},r.prototype.getExtremes=function(){var t=this.options.stacking,o,s,a,l;return t?(o=this.yAxis,s=o.waterfall.stacks,a=this.stackedYNeg=[],l=this.stackedYPos=[],t==="overlap"?objectEach$7(s[this.stackKey],function(h){a.push(arrayMin$1(h.stackState)),l.push(arrayMax$1(h.stackState))}):objectEach$7(s[this.stackKey],function(h){a.push(h.negTotal+h.threshold),l.push(h.posTotal+h.threshold)}),{dataMin:arrayMin$1(a),dataMax:arrayMax$1(l)}):{dataMin:this.dataMin,dataMax:this.dataMax}},r.defaultOptions=merge$q(ColumnSeries$8.defaultOptions,{dataLabels:{inside:!0},lineWidth:1,lineColor:palette.neutralColor80,dashStyle:"Dot",borderColor:palette.neutralColor80,states:{hover:{lineWidthPlus:0}}}),r}(ColumnSeries$8);extend$s(WaterfallSeries.prototype,{getZonesGraphs:LineSeries$1.prototype.getZonesGraphs,pointValKey:"y",showLine:!0,pointClass:WaterfallPoint});SeriesRegistry$1.registerSeriesType("waterfall",WaterfallSeries);WaterfallAxis$1.compose(Axis,Chart$1);var animObject$2=animationExports.animObject,seriesTypes$3=SeriesRegistry$1.seriesTypes,addEvent$i=Utilities.addEvent,defined$c=Utilities.defined,find$4=Utilities.find,isNumber$a=Utilities.isNumber,pick$u=Utilities.pick,splat$3=Utilities.splat,uniqueKey$1=Utilities.uniqueKey,wrap$6=Utilities.wrap,seriesProto=Series$e.prototype,pointerProto=Pointer.prototype,columnProto$2,arearangeProto;seriesProto.searchPointByAngle=function(n){var r=this,t=r.chart,o=r.xAxis,s=o.pane.center,a=n.chartX-s[0]-t.plotLeft,l=n.chartY-s[1]-t.plotTop;return this.searchKDTree({clientX:180+Math.atan2(a,l)*(-180/Math.PI)})};seriesProto.getConnectors=function(n,r,t,o){var s,a,l,h,c,d,p,u,f,g,v,m,x=1.5,y=x+1,b,$,S,k,A,P,E,M,T,O=o?1:0;return r>=0&&r<=n.length-1?s=r:r<0?s=n.length-1+r:s=0,a=s-1<0?n.length-(1+O):s-1,l=s+1>n.length-1?O:s+1,h=n[a],c=n[l],d=h.plotX,p=h.plotY,u=c.plotX,f=c.plotY,g=n[s].plotX,v=n[s].plotY,b=(x*g+d)/y,$=(x*v+p)/y,S=(x*g+u)/y,k=(x*v+f)/y,A=Math.sqrt(Math.pow(b-g,2)+Math.pow($-v,2)),P=Math.sqrt(Math.pow(S-g,2)+Math.pow(k-v,2)),E=Math.atan2($-v,b-g),M=Math.atan2(k-v,S-g),T=Math.PI/2+(E+M)/2,Math.abs(E-T)>Math.PI/2&&(T-=Math.PI),b=g+Math.cos(T)*A,$=v+Math.sin(T)*A,S=g+Math.cos(Math.PI+T)*P,k=v+Math.sin(Math.PI+T)*P,m={rightContX:S,rightContY:k,leftContX:b,leftContY:$,plotX:g,plotY:v},t&&(m.prevPointCont=this.getConnectors(n,a,!1,o)),m};seriesProto.toXY=function(n){var r=this.chart,t=this.xAxis,o=this.yAxis,s=n.plotX,a=n.plotY,l=n.series,h=r.inverted,c=n.y,d=h?s:o.len-a,p;if(h&&l&&!l.isRadialBar&&(n.plotY=a=typeof c=="number"&&o.translate(c)||0),n.rectPlotX=s,n.rectPlotY=a,o.center&&(d+=o.center[3]/2),isNumber$a(a)){var u=h?o.postTranslate(a,d):t.postTranslate(s,d);n.plotX=n.polarPlotX=u.x-r.plotLeft,n.plotY=n.polarPlotY=u.y-r.plotTop}this.kdByAngle?(p=(s/Math.PI*180+t.pane.options.startAngle)%360,p<0&&(p+=360),n.clientX=p):n.clientX=n.plotX};seriesTypes$3.spline&&(wrap$6(seriesTypes$3.spline.prototype,"getPointSpline",function(n,r,t,o){var s,a;if(this.chart.polar)if(!o)s=["M",t.plotX,t.plotY];else{a=this.getConnectors(r,o,!0,this.connectEnds);var l=a.prevPointCont&&a.prevPointCont.rightContX,h=a.prevPointCont&&a.prevPointCont.rightContY;s=["C",isNumber$a(l)?l:a.plotX,isNumber$a(h)?h:a.plotY,isNumber$a(a.leftContX)?a.leftContX:a.plotX,isNumber$a(a.leftContY)?a.leftContY:a.plotY,a.plotX,a.plotY]}else s=n.call(this,r,t,o);return s}),seriesTypes$3.areasplinerange&&(seriesTypes$3.areasplinerange.prototype.getPointSpline=seriesTypes$3.spline.prototype.getPointSpline));addEvent$i(Series$e,"afterTranslate",function(){var n=this,r=n.chart;if(r.polar&&n.xAxis){if(n.kdByAngle=r.tooltip&&r.tooltip.shared,n.kdByAngle?n.searchPoint=n.searchPointByAngle:n.options.findNearestPointBy="xy",!n.preventPostTranslate)for(var t=n.points,o=t.length;o--;)n.toXY(t[o]),!r.hasParallelCoordinates&&!n.yAxis.reversed&&t[o].y<n.yAxis.min&&(t[o].isNull=!0);this.hasClipCircleSetter||(this.hasClipCircleSetter=!!n.eventsToUnbind.push(addEvent$i(n,"afterRender",function(){var s;r.polar&&(s=this.yAxis.pane.center,this.clipCircle?this.clipCircle.animate({x:s[0],y:s[1],r:s[2]/2,innerR:s[3]/2}):this.clipCircle=r.renderer.clipCircle(s[0],s[1],s[2]/2,s[3]/2),this.group.clip(this.clipCircle),this.setClip=H.noop)})))}},{order:2});wrap$6(seriesTypes$3.line.prototype,"getGraphPath",function(n,r){var t=this,o,s,a;if(this.chart.polar){for(r=r||this.points,o=0;o<r.length;o++)if(!r[o].isNull){s=o;break}this.options.connectEnds!==!1&&typeof s<"u"&&(this.connectEnds=!0,r.splice(r.length,0,r[s]),a=!0),r.forEach(function(h){typeof h.polarPlotY>"u"&&t.toXY(h)})}var l=n.apply(this,[].slice.call(arguments,1));return a&&r.pop(),l});var polarAnimate=function(n,r){var t=this,o=this.chart,s=this.options.animation,a=this.group,l=this.markerGroup,h=this.xAxis.center,c=o.plotLeft,d=o.plotTop,p,u,f,g,v,m;o.polar?t.isRadialBar?r||(t.startAngleRad=pick$u(t.translatedThreshold,t.xAxis.startAngleRad),H.seriesTypes.pie.prototype.animate.call(t,r)):o.renderer.isSVG&&(s=animObject$2(s),t.is("column")?r||(u=h[3]/2,t.points.forEach(function(x){f=x.graphic,g=x.shapeArgs,v=g&&g.r,m=g&&g.innerR,f&&g&&(f.attr({r:u,innerR:u}),f.animate({r:v,innerR:m},t.options.animation))})):r?(p={translateX:h[0]+c,translateY:h[1]+d,scaleX:.001,scaleY:.001},a.attr(p),l&&l.attr(p)):(p={translateX:c,translateY:d,scaleX:1,scaleY:1},a.animate(p,s),l&&l.animate(p,s))):n.call(this,r)};wrap$6(seriesProto,"animate",polarAnimate);seriesTypes$3.column&&(arearangeProto=seriesTypes$3.arearange.prototype,columnProto$2=seriesTypes$3.column.prototype,columnProto$2.polarArc=function(n,r,t,o){var s=this.xAxis.center,a=this.yAxis.len,l=s[3]/2,h=a-r+l,c=a-pick$u(n,a)+l;return this.yAxis.reversed&&(h<0&&(h=l),c<0&&(c=l)),{x:s[0],y:s[1],r:h,innerR:c,start:t,end:o}},wrap$6(columnProto$2,"animate",polarAnimate),wrap$6(columnProto$2,"translate",function(n){var r=this,t=r.options,o=t.threshold,s=t.stacking,a=r.chart,l=r.xAxis,h=r.yAxis,c=h.reversed,d=h.center,p=l.startAngleRad,u=l.endAngleRad,f=u-p,g,v,m,x,y,b,$,S,k,A,P,E,M,T,O,L;if(r.preventPostTranslate=!0,n.call(r),l.isRadial)for(v=r.points,x=v.length,y=h.translate(h.min),b=h.translate(h.max),o=t.threshold||0,a.inverted&&isNumber$a(o)&&(g=h.translate(o),defined$c(g)&&(g<0?g=0:g>f&&(g=f),r.translatedThreshold=g+p));x--;)m=v[x],T=m.barX,A=m.x,P=m.y,m.shapeType="arc",a.inverted?(m.plotY=h.translate(P),s&&h.stacking?(M=h.stacking.stacks[(P<0?"-":"")+r.stackKey],r.visible&&M&&M[A]&&(m.isNull||(E=M[A].points[r.getStackIndicator(void 0,A,r.index).key],$=h.translate(E[0]),S=h.translate(E[1]),defined$c($)&&($=Utilities.clamp($,0,f))))):($=g,S=m.plotY),$>S&&(S=[$,$=S][0]),c?S>y?S=y:$<b?$=b:($>y||S<b)&&($=S=f):$<y?$=y:S>b?S=b:(S<y||$>b)&&($=S=0),h.min>h.max&&($=S=c?f:0),$+=p,S+=p,d&&(m.barX=T+=d[3]/2),O=Math.max(T,0),L=Math.max(T+m.pointWidth,0),m.shapeArgs={x:d&&d[0],y:d&&d[1],r:L,innerR:O,start:$,end:S},m.opacity=$===S?0:void 0,m.plotY=(defined$c(r.translatedThreshold)&&($<r.translatedThreshold?$:S))-p):($=T+p,m.shapeArgs=r.polarArc(m.yBottom,m.plotY,$,$+m.pointWidth)),r.toXY(m),a.inverted?(k=h.postTranslate(m.rectPlotY,T+m.pointWidth/2),m.tooltipPos=[k.x-a.plotLeft,k.y-a.plotTop]):m.tooltipPos=[m.plotX,m.plotY],d&&(m.ttBelow=m.plotY>d[1])}),columnProto$2.findAlignments=function(n,r){var t,o;return r.align===null&&(n>20&&n<160?t="left":n>200&&n<340?t="right":t="center",r.align=t),r.verticalAlign===null&&(n<45||n>315?o="bottom":n>135&&n<225?o="top":o="middle",r.verticalAlign=o),r},arearangeProto&&(arearangeProto.findAlignments=columnProto$2.findAlignments),wrap$6(columnProto$2,"alignDataLabel",function(n,r,t,o,s,a){var l=this.chart,h=pick$u(o.inside,!!this.options.stacking),c,d,p;l.polar?(c=r.rectPlotX/Math.PI*180,l.inverted?(this.forceDL=l.isInsidePlot(r.plotX,Math.round(r.plotY)),h&&r.shapeArgs?(d=r.shapeArgs,p=this.yAxis.postTranslate(((d.start||0)+(d.end||0))/2-this.xAxis.startAngleRad,r.barX+r.pointWidth/2),s={x:p.x-l.plotLeft,y:p.y-l.plotTop}):r.tooltipPos&&(s={x:r.tooltipPos[0],y:r.tooltipPos[1]}),o.align=pick$u(o.align,"center"),o.verticalAlign=pick$u(o.verticalAlign,"middle")):this.findAlignments&&(o=this.findAlignments(c,o)),seriesProto.alignDataLabel.call(this,r,t,o,s,a),this.isRadialBar&&r.shapeArgs&&r.shapeArgs.start===r.shapeArgs.end&&t.hide(!0)):n.call(this,r,t,o,s,a)}));wrap$6(pointerProto,"getCoordinates",function(n,r){var t=this.chart,o={xAxis:[],yAxis:[]};return t.polar?t.axes.forEach(function(s){var a=s.isXAxis,l=s.center,h,c;s.coll!=="colorAxis"&&(h=r.chartX-l[0]-t.plotLeft,c=r.chartY-l[1]-t.plotTop,o[a?"xAxis":"yAxis"].push({axis:s,value:s.translate(a?Math.PI-Math.atan2(h,c):Math.sqrt(Math.pow(h,2)+Math.pow(c,2)),!0)}))}):o=n.call(this,r),o});SVGRenderer.prototype.clipCircle=function(n,r,t,o){var s,a=uniqueKey$1(),l=this.createElement("clipPath").attr({id:a}).add(this.defs);return s=o?this.arc(n,r,t,o,0,2*Math.PI).add(l):this.circle(n,r,t).add(l),s.id=a,s.clipPath=l,s};addEvent$i(Chart$1,"getAxes",function(){this.pane||(this.pane=[]),this.options.pane=splat$3(this.options.pane),this.options.pane.forEach(function(n){new Pane$1(n,this)},this)});addEvent$i(Chart$1,"afterDrawChartBox",function(){this.pane.forEach(function(n){n.render()})});addEvent$i(Series$e,"afterInit",function(){var n=this.chart;n.inverted&&n.polar&&(this.isRadialSeries=!0,this.is("column")&&(this.isRadialBar=!0))});wrap$6(Chart$1.prototype,"get",function(n,r){return find$4(this.pane||[],function(t){return t.options.id===r})||n.call(this,r)});/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/highcharts-more
 * @requires highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$4=H;RadialAxis$1.compose(G$4.Axis,G$4.Tick);BubbleSeries$2.compose(G$4.Chart,G$4.Legend,G$4.Series);var pick$t=Utilities.pick,deg2rad$3=H.deg2rad;function rotate3D(n,r,t,o){return{x:o.cosB*n-o.sinB*t,y:-o.sinA*o.sinB*n+o.cosA*r-o.cosB*o.sinA*t,z:o.cosA*o.sinB*n+o.sinA*r+o.cosA*o.cosB*t}}function perspective3D$1(n,r,t){var o=t>0&&t<Number.POSITIVE_INFINITY?t/(n.z+r.z+t):1;return{x:n.x*o,y:n.y*o}}H.perspective3D=perspective3D$1;function perspective$6(n,r,t,o){var s=r.options.chart.options3d,a=pick$t(o,t?r.inverted:!1),l={x:r.plotWidth/2,y:r.plotHeight/2,z:s.depth/2,vd:pick$t(s.depth,1)*pick$t(s.viewDistance,0)},h=r.scale3d||1,c=deg2rad$3*s.beta*(a?-1:1),d=deg2rad$3*s.alpha*(a?-1:1),p={cosA:Math.cos(d),cosB:Math.cos(-c),sinA:Math.sin(d),sinB:Math.sin(-c)};return t||(l.x+=r.plotLeft,l.y+=r.plotTop),n.map(function(u){var f=rotate3D((a?u.y:u.x)-l.x,(a?u.x:u.y)-l.y,(u.z||0)-l.z,p),g=perspective3D$1(f,l,l.vd);return g.x=g.x*h+l.x,g.y=g.y*h+l.y,g.z=f.z*h+l.z,{x:a?g.y:g.x,y:a?g.x:g.y,z:g.z}})}H.perspective=perspective$6;function pointCameraDistance$1(n,r){var t=r.options.chart.options3d,o={x:r.plotWidth/2,y:r.plotHeight/2,z:pick$t(t.depth,1)*pick$t(t.viewDistance,0)+t.depth},s=Math.sqrt(Math.pow(o.x-pick$t(n.plotX,n.x),2)+Math.pow(o.y-pick$t(n.plotY,n.y),2)+Math.pow(o.z-pick$t(n.plotZ,n.z),2));return s}H.pointCameraDistance=pointCameraDistance$1;function shapeArea$2(n){var r=0,t,o;for(t=0;t<n.length;t++)o=(t+1)%n.length,r+=n[t].x*n[o].y-n[o].x*n[t].y;return r/2}H.shapeArea=shapeArea$2;function shapeArea3D$1(n,r,t){return shapeArea$2(perspective$6(n,r,t))}H.shapeArea3d=shapeArea3D$1;var mathModule={perspective:perspective$6,perspective3D:perspective3D$1,pointCameraDistance:pointCameraDistance$1,shapeArea:shapeArea$2,shapeArea3D:shapeArea3D$1},color$7=Color.parse,defined$b=Utilities.defined,merge$p=Utilities.merge,objectEach$6=Utilities.objectEach,pick$s=Utilities.pick,SVGElement3D={};SVGElement3D.base={initArgs:function(n){var r=this,t=r.renderer,o=t[r.pathType+"Path"](n),s=o.zIndexes;r.parts.forEach(function(a){r[a]=t.path(o[a]).attr({class:"highcharts-3d-"+a,zIndex:s[a]||0}).add(r)}),r.attr({"stroke-linejoin":"round",zIndex:s.group}),r.originalDestroy=r.destroy,r.destroy=r.destroyParts,r.forcedSides=o.forcedSides},singleSetterForParts:function(n,r,t,o,s,a){var l=this,h={},c=[null,null,o||"attr",s,a],d=t&&t.zIndexes;return t?(d&&d.group&&this.attr({zIndex:d.group}),objectEach$6(t,function(p,u){h[u]={},h[u][n]=p,d&&(h[u].zIndex=t.zIndexes[u]||0)}),c[1]=h):(h[n]=r,c[0]=h),l.processParts.apply(l,c)},processParts:function(n,r,t,o,s){var a=this;return a.parts.forEach(function(l){r&&(n=pick$s(r[l],!1)),n!==!1&&a[l][t](n,o,s)}),a},destroyParts:function(){return this.processParts(null,null,"destroy"),this.originalDestroy()}};SVGElement3D.cuboid=merge$p(SVGElement3D.base,{parts:["front","top","side"],pathType:"cuboid",attr:function(n,r,t,o){if(typeof n=="string"&&typeof r<"u"){var s=n;n={},n[s]=r}return n.shapeArgs||defined$b(n.x)?this.singleSetterForParts("d",null,this.renderer[this.pathType+"Path"](n.shapeArgs||n)):SVGElement.prototype.attr.call(this,n,void 0,t,o)},animate:function(n,r,t){if(defined$b(n.x)&&defined$b(n.y)){var o=this.renderer[this.pathType+"Path"](n),s=o.forcedSides;this.singleSetterForParts("d",null,o,"animate",r,t),this.attr({zIndex:o.zIndexes.group}),s!==this.forcedSides&&(this.forcedSides=s,SVGElement3D.cuboid.fillSetter.call(this,this.fill))}else SVGElement.prototype.animate.call(this,n,r,t);return this},fillSetter:function(n){var r=this;return r.forcedSides=r.forcedSides||[],r.singleSetterForParts("fill",null,{front:n,top:color$7(n).brighten(r.forcedSides.indexOf("top")>=0?0:.1).get(),side:color$7(n).brighten(r.forcedSides.indexOf("side")>=0?0:-.1).get()}),r.color=r.fill=n,r}});var __extends$o=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),animObject$1=animationExports.animObject,color$6=Color.parse,charts=H.charts,deg2rad$2=H.deg2rad,perspective$5=mathModule.perspective,shapeArea$1=mathModule.shapeArea,defined$a=Utilities.defined,extend$r=Utilities.extend,merge$o=Utilities.merge,pick$r=Utilities.pick,cos=Math.cos,sin=Math.sin,PI=Math.PI,dFactor=4*(Math.sqrt(2)-1)/3/(PI/2),SVGRenderer3D=function(n){__extends$o(r,n);function r(){return n!==null&&n.apply(this,arguments)||this}return r.compose=function(t){var o=t.prototype,s=r.prototype;o.elements3d=SVGElement3D,o.arc3d=s.arc3d,o.arc3dPath=s.arc3dPath,o.cuboid=s.cuboid,o.cuboidPath=s.cuboidPath,o.element3d=s.element3d,o.face3d=s.face3d,o.polyhedron=s.polyhedron,o.toLinePath=s.toLinePath,o.toLineSegments=s.toLineSegments},r.curveTo=function(t,o,s,a,l,h,c,d){var p=[],u=h-l;return h>l&&h-l>Math.PI/2+1e-4?(p=p.concat(this.curveTo(t,o,s,a,l,l+Math.PI/2,c,d)),p=p.concat(this.curveTo(t,o,s,a,l+Math.PI/2,h,c,d)),p):h<l&&l-h>Math.PI/2+1e-4?(p=p.concat(this.curveTo(t,o,s,a,l,l-Math.PI/2,c,d)),p=p.concat(this.curveTo(t,o,s,a,l-Math.PI/2,h,c,d)),p):[["C",t+s*Math.cos(l)-s*dFactor*u*Math.sin(l)+c,o+a*Math.sin(l)+a*dFactor*u*Math.cos(l)+d,t+s*Math.cos(h)+s*dFactor*u*Math.sin(h)+c,o+a*Math.sin(h)-a*dFactor*u*Math.cos(h)+d,t+s*Math.cos(h)+c,o+a*Math.sin(h)+d]]},r.prototype.toLinePath=function(t,o){var s=[];return t.forEach(function(a){s.push(["L",a.x,a.y])}),t.length&&(s[0][0]="M",o&&s.push(["Z"])),s},r.prototype.toLineSegments=function(t){var o=[],s=!0;return t.forEach(function(a){o.push(s?["M",a.x,a.y]:["L",a.x,a.y]),s=!s}),o},r.prototype.face3d=function(t){var o=this,s=this.createElement("path");return s.vertexes=[],s.insidePlotArea=!1,s.enabled=!0,s.attr=function(a){if(typeof a=="object"&&(defined$a(a.enabled)||defined$a(a.vertexes)||defined$a(a.insidePlotArea))){this.enabled=pick$r(a.enabled,this.enabled),this.vertexes=pick$r(a.vertexes,this.vertexes),this.insidePlotArea=pick$r(a.insidePlotArea,this.insidePlotArea),delete a.enabled,delete a.vertexes,delete a.insidePlotArea;var l=charts[o.chartIndex],h=perspective$5(this.vertexes,l,this.insidePlotArea),c=o.toLinePath(h,!0),d=shapeArea$1(h);a.d=c,a.visibility=this.enabled&&d>0?"visible":"hidden"}return SVGElement.prototype.attr.apply(this,arguments)},s.animate=function(a){if(typeof a=="object"&&(defined$a(a.enabled)||defined$a(a.vertexes)||defined$a(a.insidePlotArea))){this.enabled=pick$r(a.enabled,this.enabled),this.vertexes=pick$r(a.vertexes,this.vertexes),this.insidePlotArea=pick$r(a.insidePlotArea,this.insidePlotArea),delete a.enabled,delete a.vertexes,delete a.insidePlotArea;var l=charts[o.chartIndex],h=perspective$5(this.vertexes,l,this.insidePlotArea),c=o.toLinePath(h,!0),d=shapeArea$1(h),p=this.enabled&&d>0?"visible":"hidden";a.d=c,this.attr("visibility",p)}return SVGElement.prototype.animate.apply(this,arguments)},s.attr(t)},r.prototype.polyhedron=function(t){var o=this,s=this.g(),a=s.destroy;return this.styledMode||s.attr({"stroke-linejoin":"round"}),s.faces=[],s.destroy=function(){for(var l=0;l<s.faces.length;l++)s.faces[l].destroy();return a.call(this)},s.attr=function(l,h,c,d){if(typeof l=="object"&&defined$a(l.faces)){for(;s.faces.length>l.faces.length;)s.faces.pop().destroy();for(;s.faces.length<l.faces.length;)s.faces.push(o.face3d().add(s));for(var p=0;p<l.faces.length;p++)o.styledMode&&delete l.faces[p].fill,s.faces[p].attr(l.faces[p],null,c,d);delete l.faces}return SVGElement.prototype.attr.apply(this,arguments)},s.animate=function(l,h,c){if(l&&l.faces){for(;s.faces.length>l.faces.length;)s.faces.pop().destroy();for(;s.faces.length<l.faces.length;)s.faces.push(o.face3d().add(s));for(var d=0;d<l.faces.length;d++)s.faces[d].animate(l.faces[d],h,c);delete l.faces}return SVGElement.prototype.animate.apply(this,arguments)},s.attr(t)},r.prototype.element3d=function(t,o){var s=this.g();return extend$r(s,this.elements3d[t]),s.initArgs(o),s},r.prototype.cuboid=function(t){return this.element3d("cuboid",t)},r.prototype.cuboidPath=function(t){var o=t.x||0,s=t.y||0,a=t.z||0,l=t.height||0,h=t.width||0,c=t.depth||0,d=charts[this.chartIndex],p,u,f,g,v,m,x,y,b,$,S,k,A,P=d.options.chart.options3d,E=P.alpha,M=1e6,T=10,O=100,L=0,C=[{x:o,y:s,z:a},{x:o+h,y:s,z:a},{x:o+h,y:s+l,z:a},{x:o,y:s+l,z:a},{x:o,y:s+l,z:a+c},{x:o+h,y:s+l,z:a+c},{x:o+h,y:s,z:a+c},{x:o,y:s,z:a+c}],U=[],D;C=perspective$5(C,d,t.insidePlotArea);function N(B){return l===0&&B>1&&B<6?{x:C[B].x,y:C[B].y+10,z:C[B].z}:C[0].x===C[7].x&&B>=4?{x:C[B].x+10,y:C[B].y,z:C[B].z}:c===0&&B<2||B>5?{x:C[B].x,y:C[B].y,z:C[B].z+10}:C[B]}function I(B){return C[B]}return D=function(B,X,W){var F=[[],-1],_=B.map(I),z=X.map(I),V=B.map(N),j=X.map(N);return shapeArea$1(_)<0?F=[_,0]:shapeArea$1(z)<0?F=[z,1]:W&&(U.push(W),shapeArea$1(V)<0?F=[_,0]:shapeArea$1(j)<0?F=[z,1]:F=[_,0]),F},p=[3,2,1,0],u=[7,6,5,4],x=D(p,u,"front"),y=x[0],S=x[1],f=[1,6,7,0],g=[4,5,2,3],x=D(f,g,"top"),b=x[0],k=x[1],m=[1,2,5,6],v=[0,7,4,3],x=D(m,v,"side"),$=x[0],A=x[1],A===1?L+=M*(d.plotWidth-o):A||(L+=M*o),L+=T*(!k||E>=0&&E<=180||E<360&&E>357.5?d.plotHeight-s:10+s),S===1?L+=O*a:S||(L+=O*(1e3-a)),{front:this.toLinePath(y,!0),top:this.toLinePath(b,!0),side:this.toLinePath($,!0),zIndexes:{group:Math.round(L)},forcedSides:U,isFront:S,isTop:k}},r.prototype.arc3d=function(t){var o=this.g(),s=o.renderer,a=["x","y","r","innerR","start","end","depth"];function l(h){var c=!1,d={},p;h=merge$o(h);for(p in h)a.indexOf(p)!==-1&&(d[p]=h[p],delete h[p],c=!0);return c?[d,h]:!1}return t=merge$o(t),t.alpha=(t.alpha||0)*deg2rad$2,t.beta=(t.beta||0)*deg2rad$2,o.top=s.path(),o.side1=s.path(),o.side2=s.path(),o.inn=s.path(),o.out=s.path(),o.onAdd=function(){var h=o.parentGroup,c=o.attr("class");o.top.add(o),["out","inn","side1","side2"].forEach(function(d){o[d].attr({class:c+" highcharts-3d-side"}).add(h)})},["addClass","removeClass"].forEach(function(h){o[h]=function(){var c=arguments;["top","out","inn","side1","side2"].forEach(function(d){o[d][h].apply(o[d],c)})}}),o.setPaths=function(h){var c=o.renderer.arc3dPath(h),d=c.zTop*100;o.attribs=h,o.top.attr({d:c.top,zIndex:c.zTop}),o.inn.attr({d:c.inn,zIndex:c.zInn}),o.out.attr({d:c.out,zIndex:c.zOut}),o.side1.attr({d:c.side1,zIndex:c.zSide1}),o.side2.attr({d:c.side2,zIndex:c.zSide2}),o.zIndex=d,o.attr({zIndex:d}),h.center&&(o.top.setRadialReference(h.center),delete h.center)},o.setPaths(t),o.fillSetter=function(h){var c=color$6(h).brighten(-.1).get();return this.fill=h,this.side1.attr({fill:c}),this.side2.attr({fill:c}),this.inn.attr({fill:c}),this.out.attr({fill:c}),this.top.attr({fill:h}),this},["opacity","translateX","translateY","visibility"].forEach(function(h){o[h+"Setter"]=function(c,d){o[d]=c,["out","inn","side1","side2","top"].forEach(function(p){o[p].attr(d,c)})}}),o.attr=function(h){var c,d;return typeof h=="object"&&(d=l(h),d&&(c=d[0],arguments[0]=d[1],extend$r(o.attribs,c),o.setPaths(o.attribs))),SVGElement.prototype.attr.apply(o,arguments)},o.animate=function(h,c,d){var p,u=this.attribs,f,g,v="data-"+Math.random().toString(26).substring(2,9);return delete h.center,delete h.z,delete h.alpha,delete h.beta,g=animObject$1(pick$r(c,this.renderer.globalAnimation)),g.duration&&(p=l(h),o[v]=0,h[v]=1,o[v+"Setter"]=H.noop,p&&(f=p[0],g.step=function(m,x){function y(b){return u[b]+(pick$r(f[b],u[b])-u[b])*x.pos}x.prop===v&&x.elem.setPaths(merge$o(u,{x:y("x"),y:y("y"),r:y("r"),innerR:y("innerR"),start:y("start"),end:y("end"),depth:y("depth")}))}),c=g),SVGElement.prototype.animate.call(this,h,c,d)},o.destroy=function(){return this.top.destroy(),this.out.destroy(),this.inn.destroy(),this.side1.destroy(),this.side2.destroy(),SVGElement.prototype.destroy.call(this)},o.hide=function(){this.top.hide(),this.out.hide(),this.inn.hide(),this.side1.hide(),this.side2.hide()},o.show=function(h){this.top.show(h),this.out.show(h),this.inn.show(h),this.side1.show(h),this.side2.show(h)},o},r.prototype.arc3dPath=function(t){var o=t.x||0,s=t.y||0,a=t.start||0,l=(t.end||0)-1e-5,h=t.r||0,c=t.innerR||0,d=t.depth||0,p=t.alpha||0,u=t.beta||0,f=Math.cos(a),g=Math.sin(a),v=Math.cos(l),m=Math.sin(l),x=h*Math.cos(u),y=h*Math.cos(p),b=c*Math.cos(u),$=c*Math.cos(p),S=d*Math.sin(u),k=d*Math.sin(p),A=[["M",o+x*f,s+y*g]];A=A.concat(r.curveTo(o,s,x,y,a,l,0,0)),A.push(["L",o+b*v,s+$*m]),A=A.concat(r.curveTo(o,s,b,$,l,a,0,0)),A.push(["Z"]);var P=u>0?Math.PI/2:0,E=p>0?0:Math.PI/2,M=a>-P?a:l>-P?-P:a,T=l<PI-E?l:a<PI-E?PI-E:l,O=2*PI-E,L=[["M",o+x*cos(M),s+y*sin(M)]];L=L.concat(r.curveTo(o,s,x,y,M,T,0,0)),l>O&&a<O?(L.push(["L",o+x*cos(T)+S,s+y*sin(T)+k]),L=L.concat(r.curveTo(o,s,x,y,T,O,S,k)),L.push(["L",o+x*cos(O),s+y*sin(O)]),L=L.concat(r.curveTo(o,s,x,y,O,l,0,0)),L.push(["L",o+x*cos(l)+S,s+y*sin(l)+k]),L=L.concat(r.curveTo(o,s,x,y,l,O,S,k)),L.push(["L",o+x*cos(O),s+y*sin(O)]),L=L.concat(r.curveTo(o,s,x,y,O,T,0,0))):l>PI-E&&a<PI-E&&(L.push(["L",o+x*Math.cos(T)+S,s+y*Math.sin(T)+k]),L=L.concat(r.curveTo(o,s,x,y,T,l,S,k)),L.push(["L",o+x*Math.cos(l),s+y*Math.sin(l)]),L=L.concat(r.curveTo(o,s,x,y,l,T,0,0))),L.push(["L",o+x*Math.cos(T)+S,s+y*Math.sin(T)+k]),L=L.concat(r.curveTo(o,s,x,y,T,M,S,k)),L.push(["Z"]);var C=[["M",o+b*f,s+$*g]];C=C.concat(r.curveTo(o,s,b,$,a,l,0,0)),C.push(["L",o+b*Math.cos(l)+S,s+$*Math.sin(l)+k]),C=C.concat(r.curveTo(o,s,b,$,l,a,S,k)),C.push(["Z"]);var U=[["M",o+x*f,s+y*g],["L",o+x*f+S,s+y*g+k],["L",o+b*f+S,s+$*g+k],["L",o+b*f,s+$*g],["Z"]],D=[["M",o+x*v,s+y*m],["L",o+x*v+S,s+y*m+k],["L",o+b*v+S,s+$*m+k],["L",o+b*v,s+$*m],["Z"]],N=Math.atan2(k,-S),I=Math.abs(l+N),B=Math.abs(a+N),X=Math.abs((a+l)/2+N);function W(j){return j=j%(2*Math.PI),j>Math.PI&&(j=2*Math.PI-j),j}I=W(I),B=W(B),X=W(X);var F=1e5,_=X*F,z=B*F,V=I*F;return{top:A,zTop:Math.PI*F+1,out:L,zOut:Math.max(_,z,V),inn:C,zInn:Math.max(_,z,V),side1:U,zSide1:V*.99,side2:D,zSide2:z*.99}},r}(SVGRenderer),color$5=Color.parse,perspective$4=mathModule.perspective,shapeArea3D=mathModule.shapeArea3D,genericDefaultOptions=DefaultOptions.defaultOptions,addEvent$h=Utilities.addEvent,isArray$3=Utilities.isArray,merge$n=Utilities.merge,pick$q=Utilities.pick,wrap$5=Utilities.wrap,Chart3D;(function(n){var r=function(){function v(m){this.frame3d=void 0,this.chart=m}return v.prototype.get3dFrame=function(){var m=this.chart,x=m.options.chart.options3d,y=x.frame,b=m.plotLeft,$=m.plotLeft+m.plotWidth,S=m.plotTop,k=m.plotTop+m.plotHeight,A=0,P=x.depth,E=function(Y){var Z=shapeArea3D(Y,m);return Z>.5?1:Z<-.5?-1:0},M=E([{x:b,y:k,z:P},{x:$,y:k,z:P},{x:$,y:k,z:A},{x:b,y:k,z:A}]),T=E([{x:b,y:S,z:A},{x:$,y:S,z:A},{x:$,y:S,z:P},{x:b,y:S,z:P}]),O=E([{x:b,y:S,z:A},{x:b,y:S,z:P},{x:b,y:k,z:P},{x:b,y:k,z:A}]),L=E([{x:$,y:S,z:P},{x:$,y:S,z:A},{x:$,y:k,z:A},{x:$,y:k,z:P}]),C=E([{x:b,y:k,z:A},{x:$,y:k,z:A},{x:$,y:S,z:A},{x:b,y:S,z:A}]),U=E([{x:b,y:S,z:P},{x:$,y:S,z:P},{x:$,y:k,z:P},{x:b,y:k,z:P}]),D=!1,N=!0,I=!1,B=!1,X=!1,W=!1;[].concat(m.xAxis,m.yAxis,m.zAxis).forEach(function(Y){Y&&(Y.horiz?Y.opposite?B=!0:I=!0:Y.opposite?W=!0:X=!0)});var F=function(Y,Z,et){for(var Q=["size","color","visible"],tt={},rt=0;rt<Q.length;rt++)for(var it=Q[rt],nt=0;nt<Y.length;nt++)if(typeof Y[nt]=="object"){var st=Y[nt][it];if(typeof st<"u"&&st!==null){tt[it]=st;break}}var at=et;return tt.visible===!0||tt.visible===!1?at=tt.visible:tt.visible==="auto"&&(at=Z>0),{size:pick$q(tt.size,1),color:pick$q(tt.color,"none"),frontFacing:Z>0,visible:at}},_={axes:{},bottom:F([y.bottom,y.top,y],M,I),top:F([y.top,y.bottom,y],T,B),left:F([y.left,y.right,y.side,y],O,X),right:F([y.right,y.left,y.side,y],L,W),back:F([y.back,y.front,y],U,N),front:F([y.front,y.back,y],C,D)};if(x.axisLabelPosition==="auto"){var z=function(Y,Z){return Y.visible!==Z.visible||Y.visible&&Z.visible&&Y.frontFacing!==Z.frontFacing},V=[];z(_.left,_.front)&&V.push({y:(S+k)/2,x:b,z:A,xDir:{x:1,y:0,z:0}}),z(_.left,_.back)&&V.push({y:(S+k)/2,x:b,z:P,xDir:{x:0,y:0,z:-1}}),z(_.right,_.front)&&V.push({y:(S+k)/2,x:$,z:A,xDir:{x:0,y:0,z:1}}),z(_.right,_.back)&&V.push({y:(S+k)/2,x:$,z:P,xDir:{x:-1,y:0,z:0}});var j=[];z(_.bottom,_.front)&&j.push({x:(b+$)/2,y:k,z:A,xDir:{x:1,y:0,z:0}}),z(_.bottom,_.back)&&j.push({x:(b+$)/2,y:k,z:P,xDir:{x:-1,y:0,z:0}});var K=[];z(_.top,_.front)&&K.push({x:(b+$)/2,y:S,z:A,xDir:{x:1,y:0,z:0}}),z(_.top,_.back)&&K.push({x:(b+$)/2,y:S,z:P,xDir:{x:-1,y:0,z:0}});var ot=[];z(_.bottom,_.left)&&ot.push({z:(A+P)/2,y:k,x:b,xDir:{x:0,y:0,z:-1}}),z(_.bottom,_.right)&&ot.push({z:(A+P)/2,y:k,x:$,xDir:{x:0,y:0,z:1}});var q=[];z(_.top,_.left)&&q.push({z:(A+P)/2,y:S,x:b,xDir:{x:0,y:0,z:-1}}),z(_.top,_.right)&&q.push({z:(A+P)/2,y:S,x:$,xDir:{x:0,y:0,z:1}});var J=function(Y,Z,et){if(Y.length===0)return null;if(Y.length===1)return Y[0];for(var Q=perspective$4(Y,m,!1),tt=0,rt=1;rt<Q.length;rt++)(et*Q[rt][Z]>et*Q[tt][Z]||et*Q[rt][Z]===et*Q[tt][Z]&&Q[rt].z<Q[tt].z)&&(tt=rt);return Y[tt]};_.axes={y:{left:J(V,"x",-1),right:J(V,"x",1)},x:{top:J(K,"y",-1),bottom:J(j,"y",1)},z:{top:J(q,"y",-1),bottom:J(ot,"y",1)}}}else _.axes={y:{left:{x:b,z:A,xDir:{x:1,y:0,z:0}},right:{x:$,z:A,xDir:{x:0,y:0,z:1}}},x:{top:{y:S,z:A,xDir:{x:1,y:0,z:0}},bottom:{y:k,z:A,xDir:{x:1,y:0,z:0}}},z:{top:{x:X?$:b,y:S,xDir:X?{x:0,y:0,z:1}:{x:0,y:0,z:-1}},bottom:{x:X?$:b,y:k,xDir:X?{x:0,y:0,z:1}:{x:0,y:0,z:-1}}}};return _},v.prototype.getScale=function(m){var x=this.chart,y=x.plotLeft,b=x.plotWidth+y,$=x.plotTop,S=x.plotHeight+$,k=y+x.plotWidth/2,A=$+x.plotHeight/2,P={minX:Number.MAX_VALUE,maxX:-Number.MAX_VALUE,minY:Number.MAX_VALUE,maxY:-Number.MAX_VALUE},E,M=1;return E=[{x:y,y:$,z:0},{x:y,y:$,z:m}],[0,1].forEach(function(T){E.push({x:b,y:E[T].y,z:E[T].z})}),[0,1,2,3].forEach(function(T){E.push({x:E[T].x,y:S,z:E[T].z})}),E=perspective$4(E,x,!1),E.forEach(function(T){P.minX=Math.min(P.minX,T.x),P.maxX=Math.max(P.maxX,T.x),P.minY=Math.min(P.minY,T.y),P.maxY=Math.max(P.maxY,T.y)}),y>P.minX&&(M=Math.min(M,1-Math.abs((y+k)/(P.minX+k))%1)),b<P.maxX&&(M=Math.min(M,(b-k)/(P.maxX-k))),$>P.minY&&(P.minY<0?M=Math.min(M,($+A)/(-P.minY+$+A)):M=Math.min(M,1-($+A)/(P.minY+A)%1)),S<P.maxY&&(M=Math.min(M,Math.abs((S-A)/(P.maxY-A)))),M},v}();n.Composition=r,n.defaultOptions={chart:{options3d:{enabled:!1,alpha:0,beta:0,depth:100,fitToPlot:!0,viewDistance:25,axisLabelPosition:null,frame:{visible:"default",size:1,bottom:{},top:{},left:{},right:{},back:{},front:{}}}}};function t(v,m){var x=v.prototype,y=m.prototype;x.is3d=function(){return!!(this.options.chart.options3d&&this.options.chart.options3d.enabled)},x.propsRequireDirtyBox.push("chart.options3d"),x.propsRequireUpdateSeries.push("chart.options3d"),y.matrixSetter=function(){var b;if(this.pos<1&&(isArray$3(this.start)||isArray$3(this.end))){var $=this.start||[1,0,0,1,0,0],S=this.end||[1,0,0,1,0,0];b=[];for(var k=0;k<6;k++)b.push(this.pos*S[k]+(1-this.pos)*$[k])}else b=this.end;this.elem.attr(this.prop,b,null,!0)},merge$n(!0,genericDefaultOptions,n.defaultOptions),addEvent$h(v,"init",p),addEvent$h(v,"addSeries",o),addEvent$h(v,"afterDrawChartBox",s),addEvent$h(v,"afterGetContainer",a),addEvent$h(v,"afterInit",l),addEvent$h(v,"afterSetChartSize",h),addEvent$h(v,"beforeRedraw",c),addEvent$h(v,"beforeRender",d),wrap$5(x,"isInsidePlot",u),wrap$5(v,"renderSeries",f),wrap$5(v,"setClassName",g)}n.compose=t;function o(v){this.is3d()&&v.options.type==="scatter"&&(v.options.type="scatter3d")}function s(){if(this.chart3d&&this.is3d()){var v=this,m=v.renderer,x=v.options.chart.options3d,y=v.chart3d.get3dFrame(),b=v.plotLeft,$=v.plotLeft+v.plotWidth,S=v.plotTop,k=v.plotTop+v.plotHeight,A=0,P=x.depth,E=b-(y.left.visible?y.left.size:0),M=$+(y.right.visible?y.right.size:0),T=S-(y.top.visible?y.top.size:0),O=k+(y.bottom.visible?y.bottom.size:0),L=A-(y.front.visible?y.front.size:0),C=P+(y.back.visible?y.back.size:0),U=v.hasRendered?"animate":"attr";v.chart3d.frame3d=y,v.frameShapes||(v.frameShapes={bottom:m.polyhedron().add(),top:m.polyhedron().add(),left:m.polyhedron().add(),right:m.polyhedron().add(),back:m.polyhedron().add(),front:m.polyhedron().add()}),v.frameShapes.bottom[U]({class:"highcharts-3d-frame highcharts-3d-frame-bottom",zIndex:y.bottom.frontFacing?-1e3:1e3,faces:[{fill:color$5(y.bottom.color).brighten(.1).get(),vertexes:[{x:E,y:O,z:L},{x:M,y:O,z:L},{x:M,y:O,z:C},{x:E,y:O,z:C}],enabled:y.bottom.visible},{fill:color$5(y.bottom.color).brighten(.1).get(),vertexes:[{x:b,y:k,z:P},{x:$,y:k,z:P},{x:$,y:k,z:A},{x:b,y:k,z:A}],enabled:y.bottom.visible},{fill:color$5(y.bottom.color).brighten(-.1).get(),vertexes:[{x:E,y:O,z:L},{x:E,y:O,z:C},{x:b,y:k,z:P},{x:b,y:k,z:A}],enabled:y.bottom.visible&&!y.left.visible},{fill:color$5(y.bottom.color).brighten(-.1).get(),vertexes:[{x:M,y:O,z:C},{x:M,y:O,z:L},{x:$,y:k,z:A},{x:$,y:k,z:P}],enabled:y.bottom.visible&&!y.right.visible},{fill:color$5(y.bottom.color).get(),vertexes:[{x:M,y:O,z:L},{x:E,y:O,z:L},{x:b,y:k,z:A},{x:$,y:k,z:A}],enabled:y.bottom.visible&&!y.front.visible},{fill:color$5(y.bottom.color).get(),vertexes:[{x:E,y:O,z:C},{x:M,y:O,z:C},{x:$,y:k,z:P},{x:b,y:k,z:P}],enabled:y.bottom.visible&&!y.back.visible}]}),v.frameShapes.top[U]({class:"highcharts-3d-frame highcharts-3d-frame-top",zIndex:y.top.frontFacing?-1e3:1e3,faces:[{fill:color$5(y.top.color).brighten(.1).get(),vertexes:[{x:E,y:T,z:C},{x:M,y:T,z:C},{x:M,y:T,z:L},{x:E,y:T,z:L}],enabled:y.top.visible},{fill:color$5(y.top.color).brighten(.1).get(),vertexes:[{x:b,y:S,z:A},{x:$,y:S,z:A},{x:$,y:S,z:P},{x:b,y:S,z:P}],enabled:y.top.visible},{fill:color$5(y.top.color).brighten(-.1).get(),vertexes:[{x:E,y:T,z:C},{x:E,y:T,z:L},{x:b,y:S,z:A},{x:b,y:S,z:P}],enabled:y.top.visible&&!y.left.visible},{fill:color$5(y.top.color).brighten(-.1).get(),vertexes:[{x:M,y:T,z:L},{x:M,y:T,z:C},{x:$,y:S,z:P},{x:$,y:S,z:A}],enabled:y.top.visible&&!y.right.visible},{fill:color$5(y.top.color).get(),vertexes:[{x:E,y:T,z:L},{x:M,y:T,z:L},{x:$,y:S,z:A},{x:b,y:S,z:A}],enabled:y.top.visible&&!y.front.visible},{fill:color$5(y.top.color).get(),vertexes:[{x:M,y:T,z:C},{x:E,y:T,z:C},{x:b,y:S,z:P},{x:$,y:S,z:P}],enabled:y.top.visible&&!y.back.visible}]}),v.frameShapes.left[U]({class:"highcharts-3d-frame highcharts-3d-frame-left",zIndex:y.left.frontFacing?-1e3:1e3,faces:[{fill:color$5(y.left.color).brighten(.1).get(),vertexes:[{x:E,y:O,z:L},{x:b,y:k,z:A},{x:b,y:k,z:P},{x:E,y:O,z:C}],enabled:y.left.visible&&!y.bottom.visible},{fill:color$5(y.left.color).brighten(.1).get(),vertexes:[{x:E,y:T,z:C},{x:b,y:S,z:P},{x:b,y:S,z:A},{x:E,y:T,z:L}],enabled:y.left.visible&&!y.top.visible},{fill:color$5(y.left.color).brighten(-.1).get(),vertexes:[{x:E,y:O,z:C},{x:E,y:T,z:C},{x:E,y:T,z:L},{x:E,y:O,z:L}],enabled:y.left.visible},{fill:color$5(y.left.color).brighten(-.1).get(),vertexes:[{x:b,y:S,z:P},{x:b,y:k,z:P},{x:b,y:k,z:A},{x:b,y:S,z:A}],enabled:y.left.visible},{fill:color$5(y.left.color).get(),vertexes:[{x:E,y:O,z:L},{x:E,y:T,z:L},{x:b,y:S,z:A},{x:b,y:k,z:A}],enabled:y.left.visible&&!y.front.visible},{fill:color$5(y.left.color).get(),vertexes:[{x:E,y:T,z:C},{x:E,y:O,z:C},{x:b,y:k,z:P},{x:b,y:S,z:P}],enabled:y.left.visible&&!y.back.visible}]}),v.frameShapes.right[U]({class:"highcharts-3d-frame highcharts-3d-frame-right",zIndex:y.right.frontFacing?-1e3:1e3,faces:[{fill:color$5(y.right.color).brighten(.1).get(),vertexes:[{x:M,y:O,z:C},{x:$,y:k,z:P},{x:$,y:k,z:A},{x:M,y:O,z:L}],enabled:y.right.visible&&!y.bottom.visible},{fill:color$5(y.right.color).brighten(.1).get(),vertexes:[{x:M,y:T,z:L},{x:$,y:S,z:A},{x:$,y:S,z:P},{x:M,y:T,z:C}],enabled:y.right.visible&&!y.top.visible},{fill:color$5(y.right.color).brighten(-.1).get(),vertexes:[{x:$,y:S,z:A},{x:$,y:k,z:A},{x:$,y:k,z:P},{x:$,y:S,z:P}],enabled:y.right.visible},{fill:color$5(y.right.color).brighten(-.1).get(),vertexes:[{x:M,y:O,z:L},{x:M,y:T,z:L},{x:M,y:T,z:C},{x:M,y:O,z:C}],enabled:y.right.visible},{fill:color$5(y.right.color).get(),vertexes:[{x:M,y:T,z:L},{x:M,y:O,z:L},{x:$,y:k,z:A},{x:$,y:S,z:A}],enabled:y.right.visible&&!y.front.visible},{fill:color$5(y.right.color).get(),vertexes:[{x:M,y:O,z:C},{x:M,y:T,z:C},{x:$,y:S,z:P},{x:$,y:k,z:P}],enabled:y.right.visible&&!y.back.visible}]}),v.frameShapes.back[U]({class:"highcharts-3d-frame highcharts-3d-frame-back",zIndex:y.back.frontFacing?-1e3:1e3,faces:[{fill:color$5(y.back.color).brighten(.1).get(),vertexes:[{x:M,y:O,z:C},{x:E,y:O,z:C},{x:b,y:k,z:P},{x:$,y:k,z:P}],enabled:y.back.visible&&!y.bottom.visible},{fill:color$5(y.back.color).brighten(.1).get(),vertexes:[{x:E,y:T,z:C},{x:M,y:T,z:C},{x:$,y:S,z:P},{x:b,y:S,z:P}],enabled:y.back.visible&&!y.top.visible},{fill:color$5(y.back.color).brighten(-.1).get(),vertexes:[{x:E,y:O,z:C},{x:E,y:T,z:C},{x:b,y:S,z:P},{x:b,y:k,z:P}],enabled:y.back.visible&&!y.left.visible},{fill:color$5(y.back.color).brighten(-.1).get(),vertexes:[{x:M,y:T,z:C},{x:M,y:O,z:C},{x:$,y:k,z:P},{x:$,y:S,z:P}],enabled:y.back.visible&&!y.right.visible},{fill:color$5(y.back.color).get(),vertexes:[{x:b,y:S,z:P},{x:$,y:S,z:P},{x:$,y:k,z:P},{x:b,y:k,z:P}],enabled:y.back.visible},{fill:color$5(y.back.color).get(),vertexes:[{x:E,y:O,z:C},{x:M,y:O,z:C},{x:M,y:T,z:C},{x:E,y:T,z:C}],enabled:y.back.visible}]}),v.frameShapes.front[U]({class:"highcharts-3d-frame highcharts-3d-frame-front",zIndex:y.front.frontFacing?-1e3:1e3,faces:[{fill:color$5(y.front.color).brighten(.1).get(),vertexes:[{x:E,y:O,z:L},{x:M,y:O,z:L},{x:$,y:k,z:A},{x:b,y:k,z:A}],enabled:y.front.visible&&!y.bottom.visible},{fill:color$5(y.front.color).brighten(.1).get(),vertexes:[{x:M,y:T,z:L},{x:E,y:T,z:L},{x:b,y:S,z:A},{x:$,y:S,z:A}],enabled:y.front.visible&&!y.top.visible},{fill:color$5(y.front.color).brighten(-.1).get(),vertexes:[{x:E,y:T,z:L},{x:E,y:O,z:L},{x:b,y:k,z:A},{x:b,y:S,z:A}],enabled:y.front.visible&&!y.left.visible},{fill:color$5(y.front.color).brighten(-.1).get(),vertexes:[{x:M,y:O,z:L},{x:M,y:T,z:L},{x:$,y:S,z:A},{x:$,y:k,z:A}],enabled:y.front.visible&&!y.right.visible},{fill:color$5(y.front.color).get(),vertexes:[{x:$,y:S,z:A},{x:b,y:S,z:A},{x:b,y:k,z:A},{x:$,y:k,z:A}],enabled:y.front.visible},{fill:color$5(y.front.color).get(),vertexes:[{x:M,y:O,z:L},{x:E,y:O,z:L},{x:E,y:T,z:L},{x:M,y:T,z:L}],enabled:y.front.visible}]})}}function a(){this.styledMode&&(this.renderer.definition({tagName:"style",textContent:`.highcharts-3d-top{filter: url(#highcharts-brighter)}
.highcharts-3d-side{filter: url(#highcharts-darker)}
`}),[{name:"darker",slope:.6},{name:"brighter",slope:1.4}].forEach(function(v){this.renderer.definition({tagName:"filter",attributes:{id:"highcharts-"+v.name},children:[{tagName:"feComponentTransfer",children:[{tagName:"feFuncR",attributes:{type:"linear",slope:v.slope}},{tagName:"feFuncG",attributes:{type:"linear",slope:v.slope}},{tagName:"feFuncB",attributes:{type:"linear",slope:v.slope}}]}]})},this))}function l(){var v=this.options;this.is3d()&&(v.series||[]).forEach(function(m){var x=m.type||v.chart.type||v.chart.defaultSeriesType;x==="scatter"&&(m.type="scatter3d")})}function h(){var v=this,m=v.options.chart.options3d;if(v.chart3d&&v.is3d()){m&&(m.alpha=m.alpha%360+(m.alpha>=0?0:360),m.beta=m.beta%360+(m.beta>=0?0:360));var x=v.inverted,y=v.clipBox,b=v.margin,$=x?"y":"x",S=x?"x":"y",k=x?"height":"width",A=x?"width":"height";y[$]=-(b[3]||0),y[S]=-(b[0]||0),y[k]=v.chartWidth+(b[3]||0)+(b[1]||0),y[A]=v.chartHeight+(b[0]||0)+(b[2]||0),v.scale3d=1,m.fitToPlot===!0&&(v.scale3d=v.chart3d.getScale(m.depth)),v.chart3d.frame3d=v.chart3d.get3dFrame()}}function c(){this.is3d()&&(this.isDirtyBox=!0)}function d(){this.chart3d&&this.is3d()&&(this.chart3d.frame3d=this.chart3d.get3dFrame())}function p(){this.chart3d||(this.chart3d=new r(this))}function u(v){return this.is3d()||v.apply(this,[].slice.call(arguments,1))}function f(v){var m,x=this.series.length;if(this.is3d())for(;x--;)m=this.series[x],m.translate(),m.render();else v.call(this)}function g(v){v.apply(this,[].slice.call(arguments,1)),this.is3d()&&(this.container.className+=" highcharts-3d-chart")}})(Chart3D||(Chart3D={}));const Chart3D$1=Chart3D;var __extends$n=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),addEvent$g=Utilities.addEvent,merge$m=Utilities.merge,pick$p=Utilities.pick,splat$2=Utilities.splat,ZChart=function(){function n(){}return n.compose=function(r){addEvent$g(r,"afterGetAxes",n.onAfterGetAxes);var t=r.prototype;t.addZAxis=n.wrapAddZAxis,t.collectionsWithInit.zAxis=[t.addZAxis],t.collectionsWithUpdate.push("zAxis")},n.onAfterGetAxes=function(){var r=this,t=this.options,o=t.zAxis=splat$2(t.zAxis||{});r.is3d()&&(r.zAxis=[],o.forEach(function(s,a){s.index=a,s.isX=!0,r.addZAxis(s).setScale()}))},n.wrapAddZAxis=function(r){return new ZAxis(this,r)},n}(),ZAxis=function(n){__extends$n(r,n);function r(t,o){var s=n.call(this,t,o)||this;return s.isZAxis=!0,s}return r.prototype.getSeriesExtremes=function(){var t=this,o=t.chart;t.hasVisibleSeries=!1,t.dataMin=t.dataMax=t.ignoreMinPadding=t.ignoreMaxPadding=void 0,t.stacking&&t.stacking.buildStacks(),t.series.forEach(function(s){if(s.visible||!o.options.chart.ignoreHiddenSeries){var a=s.options,l=void 0,h=a.threshold;t.hasVisibleSeries=!0,t.positiveValuesOnly&&h<=0&&(h=void 0),l=s.zData,l.length&&(t.dataMin=Math.min(pick$p(t.dataMin,l[0]),Math.min.apply(null,l)),t.dataMax=Math.max(pick$p(t.dataMax,l[0]),Math.max.apply(null,l)))}})},r.prototype.setAxisSize=function(){var t=this,o=t.chart;n.prototype.setAxisSize.call(this),t.width=t.len=o.options.chart.options3d&&o.options.chart.options3d.depth||0,t.right=o.chartWidth-t.width-t.left},r.prototype.setOptions=function(t){t=merge$m({offset:0,lineWidth:0},t),this.isZAxis=!0,n.prototype.setOptions.call(this,t),this.coll="zAxis"},r.ZChartComposition=ZChart,r}(Axis),addEvent$f=Utilities.addEvent,extend$q=Utilities.extend,wrap$4=Utilities.wrap,Tick3D=function(){function n(){}return n.compose=function(r){addEvent$f(r,"afterGetLabelPosition",n.onAfterGetLabelPosition);var t=r.prototype;wrap$4(t,"getMarkPath",n.wrapGetMarkPath)},n.onAfterGetLabelPosition=function(r){var t=this.axis.axis3D;t&&extend$q(r.pos,t.fix3dPosition(r.pos))},n.wrapGetMarkPath=function(r){this.axis.chart;var t=this.axis.axis3D,o=r.apply(this,[].slice.call(arguments,1));if(t){var s=o[0],a=o[1];if(s[0]==="M"&&a[0]==="L"){var l=[t.fix3dPosition({x:s[1],y:s[2],z:0}),t.fix3dPosition({x:a[1],y:a[2],z:0})];return this.axis.chart.renderer.toLineSegments(l)}}return o},n}(),deg2rad$1=H.deg2rad,perspective$3=mathModule.perspective,perspective3D=mathModule.perspective3D,shapeArea=mathModule.shapeArea,addEvent$e=Utilities.addEvent,merge$l=Utilities.merge,pick$o=Utilities.pick,wrap$3=Utilities.wrap,Axis3DAdditions=function(){function n(r){this.axis=r}return n.prototype.fix3dPosition=function(r,t){var o=this,s=o.axis,a=s.chart;if(s.coll==="colorAxis"||!a.chart3d||!a.is3d())return r;var l=deg2rad$1*a.options.chart.options3d.alpha,h=deg2rad$1*a.options.chart.options3d.beta,c=pick$o(t&&s.options.title.position3d,s.options.labels.position3d),d=pick$o(t&&s.options.title.skew3d,s.options.labels.skew3d),p=a.chart3d.frame3d,u=a.plotLeft,f=a.plotWidth+u,g=a.plotTop,v=a.plotHeight+g,m=0,x=0,y,b={x:0,y:1,z:0},$=!1;if(r=s.axis3D.swapZ({x:r.x,y:r.y,z:0}),s.isZAxis)if(s.opposite){if(p.axes.z.top===null)return{};x=r.y-g,r.x=p.axes.z.top.x,r.y=p.axes.z.top.y,y=p.axes.z.top.xDir,$=!p.top.frontFacing}else{if(p.axes.z.bottom===null)return{};x=r.y-v,r.x=p.axes.z.bottom.x,r.y=p.axes.z.bottom.y,y=p.axes.z.bottom.xDir,$=!p.bottom.frontFacing}else if(s.horiz)if(s.opposite){if(p.axes.x.top===null)return{};x=r.y-g,r.y=p.axes.x.top.y,r.z=p.axes.x.top.z,y=p.axes.x.top.xDir,$=!p.top.frontFacing}else{if(p.axes.x.bottom===null)return{};x=r.y-v,r.y=p.axes.x.bottom.y,r.z=p.axes.x.bottom.z,y=p.axes.x.bottom.xDir,$=!p.bottom.frontFacing}else if(s.opposite){if(p.axes.y.right===null)return{};m=r.x-f,r.x=p.axes.y.right.x,r.z=p.axes.y.right.z,y=p.axes.y.right.xDir,y={x:y.z,y:y.y,z:-y.x}}else{if(p.axes.y.left===null)return{};m=r.x-u,r.x=p.axes.y.left.x,r.z=p.axes.y.left.z,y=p.axes.y.left.xDir}if(c!=="chart")if(c==="flap")if(!s.horiz)y={x:Math.cos(h),y:0,z:Math.sin(h)};else{var S=Math.sin(l),k=Math.cos(l);s.opposite&&(S=-S),$&&(S=-S),b={x:y.z*S,y:k,z:-y.x*S}}else if(c==="ortho")if(!s.horiz)y={x:Math.cos(h),y:0,z:Math.sin(h)};else{var A=Math.sin(l),P=Math.cos(l),E=Math.sin(h),M=Math.cos(h),T={x:E*P,y:-A,z:-P*M};b={x:y.y*T.z-y.z*T.y,y:y.z*T.x-y.x*T.z,z:y.x*T.y-y.y*T.x};var O=1/Math.sqrt(b.x*b.x+b.y*b.y+b.z*b.z);$&&(O=-O),b={x:O*b.x,y:O*b.y,z:O*b.z}}else s.horiz?b={x:Math.sin(h)*Math.sin(l),y:Math.cos(l),z:-Math.cos(h)*Math.sin(l)}:y={x:Math.cos(h),y:0,z:Math.sin(h)};r.x+=m*y.x+x*b.x,r.y+=m*y.y+x*b.y,r.z+=m*y.z+x*b.z;var L=perspective$3([r],s.chart)[0];if(d){var C=shapeArea(perspective$3([r,{x:r.x+y.x,y:r.y+y.y,z:r.z+y.z},{x:r.x+b.x,y:r.y+b.y,z:r.z+b.z}],s.chart))<0;C&&(y={x:-y.x,y:-y.y,z:-y.z});var U=perspective$3([{x:r.x,y:r.y,z:r.z},{x:r.x+y.x,y:r.y+y.y,z:r.z+y.z},{x:r.x+b.x,y:r.y+b.y,z:r.z+b.z}],s.chart);L.matrix=[U[1].x-U[0].x,U[1].y-U[0].y,U[2].x-U[0].x,U[2].y-U[0].y,L.x,L.y],L.matrix[4]-=L.x*L.matrix[0]+L.y*L.matrix[2],L.matrix[5]-=L.x*L.matrix[1]+L.y*L.matrix[3]}return L},n.prototype.swapZ=function(r,t){var o=this.axis;if(o.isZAxis){var s=t?0:o.chart.plotLeft;return{x:s+r.z,y:r.y,z:r.x-s}}return r},n}(),Axis3D=function(){function n(){}return n.compose=function(r){merge$l(!0,r.defaultOptions,n.defaultOptions),r.keepProps.push("axis3D"),addEvent$e(r,"init",n.onInit),addEvent$e(r,"afterSetOptions",n.onAfterSetOptions),addEvent$e(r,"drawCrosshair",n.onDrawCrosshair);var t=r.prototype;wrap$3(t,"getLinePath",n.wrapGetLinePath),wrap$3(t,"getPlotBandPath",n.wrapGetPlotBandPath),wrap$3(t,"getPlotLinePath",n.wrapGetPlotLinePath),wrap$3(t,"getSlotWidth",n.wrapGetSlotWidth),wrap$3(t,"getTitlePosition",n.wrapGetTitlePosition),Tick3D.compose(Tick)},n.onAfterSetOptions=function(){var r=this,t=r.chart,o=r.options;t.is3d&&t.is3d()&&r.coll!=="colorAxis"&&(o.tickWidth=pick$o(o.tickWidth,0),o.gridLineWidth=pick$o(o.gridLineWidth,1))},n.onDrawCrosshair=function(r){var t=this;t.chart.is3d()&&t.coll!=="colorAxis"&&r.point&&(r.point.crosshairPos=t.isXAxis?r.point.axisXpos:t.len-r.point.axisYpos)},n.onInit=function(){var r=this;r.axis3D||(r.axis3D=new Axis3DAdditions(r))},n.wrapGetLinePath=function(r){var t=this;return!t.chart.is3d()||t.coll==="colorAxis"?r.apply(t,[].slice.call(arguments,1)):[]},n.wrapGetPlotBandPath=function(r){if(!this.chart.is3d()||this.coll==="colorAxis")return r.apply(this,[].slice.call(arguments,1));var t=arguments,o=t[1],s=t[2],a=[],l=this.getPlotLinePath({value:o}),h=this.getPlotLinePath({value:s});if(l&&h)for(var c=0;c<l.length;c+=2){var d=l[c],p=l[c+1],u=h[c],f=h[c+1];d[0]==="M"&&p[0]==="L"&&u[0]==="M"&&f[0]==="L"&&a.push(d,p,f,["L",u[1],u[2]],["Z"])}return a},n.wrapGetPlotLinePath=function(r){var t=this,o=t.axis3D,s=t.chart,a=r.apply(t,[].slice.call(arguments,1));if(t.coll==="colorAxis"||!s.chart3d||!s.is3d()||a===null)return a;var l=s.options.chart.options3d,h=t.isZAxis?s.plotWidth:l.depth,c=s.chart3d.frame3d,d=a[0],p=a[1],u,f=[];return d[0]==="M"&&p[0]==="L"&&(u=[o.swapZ({x:d[1],y:d[2],z:0}),o.swapZ({x:d[1],y:d[2],z:h}),o.swapZ({x:p[1],y:p[2],z:0}),o.swapZ({x:p[1],y:p[2],z:h})],this.horiz?this.isZAxis?(c.left.visible&&f.push(u[0],u[2]),c.right.visible&&f.push(u[1],u[3]),c.top.visible&&f.push(u[0],u[1]),c.bottom.visible&&f.push(u[2],u[3])):(c.front.visible&&f.push(u[0],u[2]),c.back.visible&&f.push(u[1],u[3]),c.top.visible&&f.push(u[0],u[1]),c.bottom.visible&&f.push(u[2],u[3])):(c.front.visible&&f.push(u[0],u[2]),c.back.visible&&f.push(u[1],u[3]),c.left.visible&&f.push(u[0],u[1]),c.right.visible&&f.push(u[2],u[3])),f=perspective$3(f,this.chart,!1)),s.renderer.toLineSegments(f)},n.wrapGetSlotWidth=function(r,t){var o=this,s=o.chart,a=o.ticks,l=o.gridGroup;if(o.categories&&s.frameShapes&&s.is3d()&&l&&t&&t.label){var h=l.element.childNodes[0].getBBox(),c=s.frameShapes.left.getBBox(),d=s.options.chart.options3d,p={x:s.plotWidth/2,y:s.plotHeight/2,z:d.depth/2,vd:pick$o(d.depth,1)*pick$o(d.viewDistance,0)},u=t.pos,f=a[u-1],g=a[u+1],v=void 0,m=void 0,x=void 0;return u!==0&&f&&f.label&&f.label.xy&&(m=perspective3D({x:f.label.xy.x,y:f.label.xy.y,z:null},p,p.vd)),g&&g.label&&g.label.xy&&(x=perspective3D({x:g.label.xy.x,y:g.label.xy.y,z:null},p,p.vd)),v={x:t.label.xy.x,y:t.label.xy.y,z:null},v=perspective3D(v,p,p.vd),Math.abs(m?v.x-m.x:x?x.x-v.x:h.x-c.x)}return r.apply(o,[].slice.call(arguments,1))},n.wrapGetTitlePosition=function(r){var t=r.apply(this,[].slice.call(arguments,1));return this.axis3D?this.axis3D.fix3dPosition(t,!0):t},n.defaultOptions={labels:{position3d:"offset",skew3d:!1},title:{position3d:null,skew3d:null}},n}(),__extends$m=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),perspective$2=mathModule.perspective,addEvent$d=Utilities.addEvent,extend$p=Utilities.extend,merge$k=Utilities.merge,pick$n=Utilities.pick,isNumber$9=Utilities.isNumber,Series3D=function(n){__extends$m(r,n);function r(){return n!==null&&n.apply(this,arguments)||this}return r.prototype.translate=function(){n.prototype.translate.apply(this,arguments),this.chart.is3d()&&this.translate3dPoints()},r.prototype.translate3dPoints=function(){var t=this,o=t.options,s=t.chart,a=pick$n(t.zAxis,s.options.zAxis[0]),l=[],h,c,d,p,u,f=[],g=o.stacking?isNumber$9(o.stack)?o.stack:0:t.index||0;for(t.zPadding=g*(o.depth||0+(o.groupZPadding||1)),u=0;u<t.data.length;u++)h=t.data[u],a&&a.translate?(p=a.logarithmic&&a.val2lin?a.val2lin(h.z):h.z,h.plotZ=a.translate(p),h.isInside=h.isInside?p>=a.min&&p<=a.max:!1):h.plotZ=t.zPadding,h.axisXpos=h.plotX,h.axisYpos=h.plotY,h.axisZpos=h.plotZ,l.push({x:h.plotX,y:h.plotY,z:h.plotZ}),f.push(h.plotX||0);for(t.rawPointsX=f,c=perspective$2(l,s,!0),u=0;u<t.data.length;u++)h=t.data[u],d=c[u],h.plotX=d.x,h.plotY=d.y,h.plotZ=d.z},r.defaultOptions=merge$k(Series$e.defaultOptions),r}(Series$e);addEvent$d(Series$e,"afterTranslate",function(){this.chart.is3d()&&this.translate3dPoints()});extend$p(Series$e.prototype,{translate3dPoints:Series3D.prototype.translate3dPoints});var columnProto$1=ColumnSeries$h.prototype,svg$1=H.svg,perspective$1=mathModule.perspective,addEvent$c=Utilities.addEvent,pick$m=Utilities.pick,wrap$2=Utilities.wrap;function retrieveStacks(n,r){var t=n.series,o={totalStacks:0},s,a=1;return t.forEach(function(l){s=pick$m(l.options.stack,r?0:t.length-1-l.index),o[s]?o[s].series.push(l):(o[s]={series:[l],position:a},a++)}),o.totalStacks=a+1,o}wrap$2(columnProto$1,"translate",function(n){n.apply(this,[].slice.call(arguments,1)),this.chart.is3d()&&this.translate3dShapes()});wrap$2(Series$e.prototype,"justifyDataLabel",function(n){return arguments[2].outside3dPlot?!1:n.apply(this,[].slice.call(arguments,1))});columnProto$1.translate3dPoints=function(){};columnProto$1.translate3dShapes=function(){var n=this,r=n.chart,t=n.options,o=t.depth,s=t.stacking?t.stack||0:n.index,a=s*(o+(t.groupZPadding||1)),l=n.borderWidth%2?.5:0,h;r.inverted&&!n.yAxis.reversed&&(l*=-1),t.grouping!==!1&&(a=0),a+=t.groupZPadding||1,n.data.forEach(function(c){if(c.outside3dPlot=null,c.y!==null){var d=c.shapeArgs,p=c.tooltipPos,u=[["x","width"],["y","height"]],f;u.forEach(function(g){if(f=d[g[0]]-l,f<0&&(d[g[1]]+=d[g[0]]+l,d[g[0]]=-l,f=0),f+d[g[1]]>n[g[0]+"Axis"].len&&d[g[1]]!==0&&(d[g[1]]=n[g[0]+"Axis"].len-d[g[0]]),d[g[1]]!==0&&(d[g[0]]>=n[g[0]+"Axis"].len||d[g[0]]+d[g[1]]<=l)){for(var v in d)d[v]=v==="y"?-9999:0;c.outside3dPlot=!0}}),c.shapeType==="rect"&&(c.shapeType="cuboid"),d.z=a,d.depth=o,d.insidePlotArea=!0,h={x:d.x+d.width/2,y:d.y,z:a+o/2},r.inverted&&(h.x=d.height,h.y=c.clientX),c.plot3d=perspective$1([h],r,!0,!1)[0],p=perspective$1([{x:p[0],y:p[1],z:a+o/2}],r,!0,!1)[0],c.tooltipPos=[p.x,p.y]}}),n.z=a};wrap$2(columnProto$1,"animate",function(n){if(!this.chart.is3d())n.apply(this,[].slice.call(arguments,1));else{var r=arguments,t=r[1],o=this.yAxis,s=this,a=this.yAxis.reversed;svg$1&&(t?s.data.forEach(function(l){l.y!==null&&(l.height=l.shapeArgs.height,l.shapey=l.shapeArgs.y,l.shapeArgs.height=1,a||(l.stackY?l.shapeArgs.y=l.plotY+o.translate(l.stackY):l.shapeArgs.y=l.plotY+(l.negative?-l.height:l.height)))}):(s.data.forEach(function(l){l.y!==null&&(l.shapeArgs.height=l.height,l.shapeArgs.y=l.shapey,l.graphic&&l.graphic[l.outside3dPlot?"attr":"animate"](l.shapeArgs,s.options.animation))}),this.drawDataLabels()))}});wrap$2(columnProto$1,"plotGroup",function(n,r,t,o,s,a){return r!=="dataLabelsGroup"&&this.chart.is3d()&&(this[r]&&delete this[r],a&&(this.chart.columnGroup||(this.chart.columnGroup=this.chart.renderer.g("columnGroup").add(a)),this[r]=this.chart.columnGroup,this.chart.columnGroup.attr(this.getPlotBox()),this[r].survive=!0,(r==="group"||r==="markerGroup")&&(arguments[3]="visible"))),n.apply(this,Array.prototype.slice.call(arguments,1))});wrap$2(columnProto$1,"setVisible",function(n,r){var t=this;t.chart.is3d()&&t.data.forEach(function(o){o.visible=o.options.visible=r=typeof r>"u"?!pick$m(t.visible,o.visible):r,t.options.data[t.data.indexOf(o)]=o.options,o.graphic&&o.graphic.attr({visibility:r?"visible":"hidden"})}),n.apply(this,Array.prototype.slice.call(arguments,1))});addEvent$c(ColumnSeries$h,"afterInit",function(){if(this.chart.is3d()){var n=this,r=this.options,t=r.grouping,o=r.stacking,s=this.yAxis.options.reversedStacks,a=0;if(!(typeof t<"u"&&!t)){var l=retrieveStacks(this.chart,o),h=r.stack||0,c=void 0;for(c=0;c<l[h].series.length&&l[h].series[c]!==this;c++);a=10*(l.totalStacks-l[h].position)+(s?c:-c),this.xAxis.reversed||(a=l.totalStacks*10-a)}r.depth=r.depth||25,n.z=n.z||0,r.zIndex=a}});function pointAttribs(n){var r=n.apply(this,[].slice.call(arguments,1));return this.chart.is3d&&this.chart.is3d()&&(r.stroke=this.options.edgeColor||r.fill,r["stroke-width"]=pick$m(this.options.edgeWidth,1)),r}function setState(n,r,t){var o=this.chart.is3d&&this.chart.is3d();o&&(this.options.inactiveOtherPoints=!0),n.call(this,r,t),o&&(this.options.inactiveOtherPoints=!1)}function hasNewShapeType(n){for(var r=[],t=1;t<arguments.length;t++)r[t-1]=arguments[t];return this.series.chart.is3d()?this.graphic&&this.graphic.element.nodeName!=="g":n.apply(this,r)}wrap$2(columnProto$1,"pointAttribs",pointAttribs);wrap$2(columnProto$1,"setState",setState);wrap$2(columnProto$1.pointClass.prototype,"hasNewShapeType",hasNewShapeType);if(SeriesRegistry$1.seriesTypes.columnRange){var columnRangeProto=SeriesRegistry$1.seriesTypes.columnrange.prototype;wrap$2(columnRangeProto,"pointAttribs",pointAttribs),wrap$2(columnRangeProto,"setState",setState),wrap$2(columnRangeProto.pointClass.prototype,"hasNewShapeType",hasNewShapeType),columnRangeProto.plotGroup=columnProto$1.plotGroup,columnRangeProto.setVisible=columnProto$1.setVisible}wrap$2(Series$e.prototype,"alignDataLabel",function(n,r,t,o,s){var a=this.chart;if(o.outside3dPlot=r.outside3dPlot,a.is3d()&&this.is("column")){var l=this,h=l.options,c=pick$m(o.inside,!!l.options.stacking),d=a.options.chart.options3d,p=r.pointWidth/2||0,u={x:s.x+p,y:s.y,z:l.z+h.depth/2};a.inverted&&(c&&(s.width=0,u.x+=r.shapeArgs.height/2),d.alpha>=90&&d.alpha<=270&&(u.y+=r.shapeArgs.width)),u=perspective$1([u],a,!0,!1)[0],s.x=u.x-p,s.y=r.outside3dPlot?-9e9:u.y}n.apply(this,[].slice.call(arguments,1))});wrap$2(StackItem$1.prototype,"getStackBox",function(n,r,t,o,s,a,l,h){var c=n.apply(this,[].slice.call(arguments,1));if(r.is3d()&&t.base){var d=+t.base.split(",")[0],p=r.series[d],u=r.options.chart.options3d;if(p&&p instanceof SeriesRegistry$1.seriesTypes.column){var f={x:c.x+(r.inverted?l:a/2),y:c.y,z:p.options.depth/2};r.inverted&&(c.width=0,u.alpha>=90&&u.alpha<=270&&(f.y+=a)),f=perspective$1([f],r,!0,!1)[0],c.x=f.x-a/2,c.y=f.y}}return c});var __extends$l=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),PiePoint$2=SeriesRegistry$1.seriesTypes.pie.prototype.pointClass,superHaloPath=PiePoint$2.prototype.haloPath,Pie3DPoint=function(n){__extends$l(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.series=void 0,t}return r.prototype.haloPath=function(){return this.series.chart.is3d()?[]:superHaloPath.apply(this,arguments)},r}(PiePoint$2),__extends$k=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),deg2rad=H.deg2rad,svg=H.svg,PieSeries$2=SeriesRegistry$1.seriesTypes.pie,extend$o=Utilities.extend,pick$l=Utilities.pick,Pie3DSeries=function(n){__extends$k(r,n);function r(){return n!==null&&n.apply(this,arguments)||this}return r.prototype.addPoint=function(){n.prototype.addPoint.apply(this,arguments),this.chart.is3d()&&this.update(this.userOptions,!0)},r.prototype.animate=function(t){if(!this.chart.is3d())n.prototype.animate.apply(this,arguments);else{var o=this.options.animation,s=void 0,a=this.center,l=this.group,h=this.markerGroup;svg&&(o===!0&&(o={}),t?(l.oldtranslateX=pick$l(l.oldtranslateX,l.translateX),l.oldtranslateY=pick$l(l.oldtranslateY,l.translateY),s={translateX:a[0],translateY:a[1],scaleX:.001,scaleY:.001},l.attr(s),h&&(h.attrSetters=l.attrSetters,h.attr(s))):(s={translateX:l.oldtranslateX,translateY:l.oldtranslateY,scaleX:1,scaleY:1},l.animate(s,o),h&&h.animate(s,o)))}},r.prototype.drawDataLabels=function(){if(this.chart.is3d()){var t=this,o=t.chart,s=o.options.chart.options3d;t.data.forEach(function(a){var l=a.shapeArgs,h=l.r,c=(l.alpha||s.alpha)*deg2rad,d=(l.beta||s.beta)*deg2rad,p=(l.start+l.end)/2,u=a.labelPosition,f=u.connectorPosition,g=-h*(1-Math.cos(c))*Math.sin(p),v=h*(Math.cos(d)-1)*Math.cos(p);[u.natural,f.breakAt,f.touchingSliceAt].forEach(function(m){m.x+=v,m.y+=g})})}n.prototype.drawDataLabels.apply(this,arguments)},r.prototype.pointAttribs=function(t){var o=n.prototype.pointAttribs.apply(this,arguments),s=this.options;return this.chart.is3d()&&!this.chart.styledMode&&(o.stroke=s.edgeColor||t.color||this.color,o["stroke-width"]=pick$l(s.edgeWidth,1)),o},r.prototype.translate=function(){if(n.prototype.translate.apply(this,arguments),!!this.chart.is3d()){var t=this,o=t.options,s=o.depth||0,a=t.chart.options.chart.options3d,l=a.alpha,h=a.beta,c=o.stacking?(o.stack||0)*s:t._i*s;c+=s/2,o.grouping!==!1&&(c=0),t.data.forEach(function(d){var p=d.shapeArgs,u;d.shapeType="arc3d",p.z=c,p.depth=s*.75,p.alpha=l,p.beta=h,p.center=t.center,u=(p.end+p.start)/2,d.slicedTranslation={translateX:Math.round(Math.cos(u)*o.slicedOffset*Math.cos(l*deg2rad)),translateY:Math.round(Math.sin(u)*o.slicedOffset*Math.cos(l*deg2rad))}})}},r}(PieSeries$2);extend$o(Pie3DSeries.prototype,{pointClass:Pie3DPoint});SeriesRegistry$1.seriesTypes.pie.prototype.pointClass.prototype.haloPath=Pie3DPoint.prototype.haloPath;SeriesRegistry$1.seriesTypes.pie=Pie3DSeries;var __extends$j=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),defined$9=Utilities.defined,Scatter3DPoint=function(n){__extends$j(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return r.prototype.applyOptions=function(){return n.prototype.applyOptions.apply(this,arguments),defined$9(this.z)||(this.z=0),this},r}(ScatterSeries$4.prototype.pointClass),__extends$i=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),pointCameraDistance=mathModule.pointCameraDistance,extend$n=Utilities.extend,merge$j=Utilities.merge,Scatter3DSeries=function(n){__extends$i(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.pointAttribs=function(t){var o=n.prototype.pointAttribs.apply(this,arguments);return this.chart.is3d()&&t&&(o.zIndex=pointCameraDistance(t,this.chart)),o},r.defaultOptions=merge$j(ScatterSeries$4.defaultOptions,{tooltip:{pointFormat:"x: <b>{point.x}</b><br/>y: <b>{point.y}</b><br/>z: <b>{point.z}</b><br/>"}}),r}(ScatterSeries$4);extend$n(Scatter3DSeries.prototype,{axisTypes:["xAxis","yAxis","zAxis"],directTouch:!0,parallelArrays:["x","y","z"],pointArrayMap:["x","y","z"],pointClass:Scatter3DPoint});SeriesRegistry$1.registerSeriesType("scatter3d",Scatter3DSeries);var perspective=mathModule.perspective,_a$6=SeriesRegistry$1.seriesTypes,AreaSeriesClass=_a$6.area,LineSeriesClass=_a$6.line,pick$k=Utilities.pick,wrap$1=Utilities.wrap;wrap$1(AreaSeriesClass.prototype,"getGraphPath",function(n){var r=this,t=n.apply(r,[].slice.call(arguments,1));if(!r.chart.is3d())return t;var o=LineSeriesClass.prototype.getGraphPath,s=r.options,a=s.stacking,l,h=[],c=[],d,p=pick$k(s.connectNulls,a==="percent"),u=Math.round(r.yAxis.getThreshold(s.threshold)),f;if(r.rawPointsX)for(var g=0;g<r.points.length;g++)h.push({x:r.rawPointsX[g],y:s.stacking?r.points[g].yBottom:u,z:r.zPadding});return f=r.chart.options.chart.options3d,h=perspective(h,r.chart,!0).map(function(v){return{plotX:v.x,plotY:v.y,plotZ:v.z}}),r.group&&f&&f.depth&&f.beta&&(r.markerGroup&&(r.markerGroup.add(r.group),r.markerGroup.attr({translateX:0,translateY:0})),r.group.attr({zIndex:Math.max(1,f.beta>270||f.beta<90?f.depth-Math.round(r.zPadding||0):Math.round(r.zPadding||0))})),h.reversed=!0,l=o.call(r,h,!0,!0),l[0]&&l[0][0]==="M"&&(l[0]=["L",l[0][1],l[0][2]]),r.areaPath&&(d=r.areaPath.splice(0,r.areaPath.length/2).concat(l),d.xMap=r.areaPath.xMap,r.areaPath=d,o.call(r,c,!1,p)),t});/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/highcharts-3d
 * @requires highcharts
 *
 * 3D features for Highcharts JS
 *
 * License: www.highcharts.com/license
 */var G$3=H;SVGRenderer3D.compose(G$3.SVGRenderer);Chart3D$1.compose(G$3.Chart,G$3.Fx);ZAxis.ZChartComposition.compose(G$3.Chart);Axis3D.compose(G$3.Axis);var doc$2=H.doc,createElement$1=Utilities.createElement,discardElement$1=Utilities.discardElement,merge$i=Utilities.merge,objectEach$5=Utilities.objectEach;function ajax$1(n){var r=merge$i(!0,{url:!1,type:"get",dataType:"json",success:!1,error:!1,data:!1,headers:{}},n),t={json:"application/json",xml:"application/xml",text:"text/plain",octet:"application/octet-stream"},o=new XMLHttpRequest;function s(a,l){r.error&&r.error(a,l)}if(!r.url)return!1;o.open(r.type.toUpperCase(),r.url,!0),r.headers["Content-Type"]||o.setRequestHeader("Content-Type",t[r.dataType]||t.text),objectEach$5(r.headers,function(a,l){o.setRequestHeader(l,a)}),o.onreadystatechange=function(){var a;if(o.readyState===4){if(o.status===200){if(a=o.responseText,r.dataType==="json")try{a=JSON.parse(a)}catch(l){return s(o,l)}return r.success&&r.success(a)}s(o,o.responseText)}};try{r.data=JSON.stringify(r.data)}catch{}o.send(r.data||!0)}function getJSON(n,r){exports$2.ajax({url:n,success:r,dataType:"json",headers:{"Content-Type":"text/plain"}})}function post(n,r,t){var o=createElement$1("form",merge$i({method:"post",action:n,enctype:"multipart/form-data"},t),{display:"none"},doc$2.body);objectEach$5(r,function(s,a){createElement$1("input",{type:"hidden",name:a,value:s},null,o)}),o.submit(),discardElement$1(o)}var exports$2={ajax:ajax$1,getJSON,post},doc$1=H.doc,ajax=exports$2.ajax,seriesTypes$2=SeriesRegistry$1.seriesTypes,addEvent$b=Utilities.addEvent,defined$8=Utilities.defined,extend$m=Utilities.extend,fireEvent$5=Utilities.fireEvent,isNumber$8=Utilities.isNumber,merge$h=Utilities.merge,objectEach$4=Utilities.objectEach,pick$j=Utilities.pick,splat$1=Utilities.splat,Data=function(){function n(r,t,o){this.chart=void 0,this.chartOptions=void 0,this.firstRowAsNames=void 0,this.rawColumns=void 0,this.options=void 0,this.dateFormats={"YYYY/mm/dd":{regex:/^([0-9]{4})[\-\/\.]([0-9]{1,2})[\-\/\.]([0-9]{1,2})$/,parser:function(s){return s?Date.UTC(+s[1],s[2]-1,+s[3]):NaN}},"dd/mm/YYYY":{regex:/^([0-9]{1,2})[\-\/\.]([0-9]{1,2})[\-\/\.]([0-9]{4})$/,parser:function(s){return s?Date.UTC(+s[3],s[2]-1,+s[1]):NaN},alternative:"mm/dd/YYYY"},"mm/dd/YYYY":{regex:/^([0-9]{1,2})[\-\/\.]([0-9]{1,2})[\-\/\.]([0-9]{4})$/,parser:function(s){return s?Date.UTC(+s[3],s[1]-1,+s[2]):NaN}},"dd/mm/YY":{regex:/^([0-9]{1,2})[\-\/\.]([0-9]{1,2})[\-\/\.]([0-9]{2})$/,parser:function(s){if(!s)return NaN;var a=+s[3],l=new Date;return a>l.getFullYear()-2e3?a+=1900:a+=2e3,Date.UTC(a,s[2]-1,+s[1])},alternative:"mm/dd/YY"},"mm/dd/YY":{regex:/^([0-9]{1,2})[\-\/\.]([0-9]{1,2})[\-\/\.]([0-9]{2})$/,parser:function(s){return s?Date.UTC(+s[3]+2e3,s[1]-1,+s[2]):NaN}}},this.init(r,t,o)}return n.prototype.init=function(r,t,o){var s=r.decimalPoint,a;t&&(this.chartOptions=t),o&&(this.chart=o),s!=="."&&s!==","&&(s=void 0),this.options=r,this.columns=r.columns||this.rowsToColumns(r.rows)||[],this.firstRowAsNames=pick$j(r.firstRowAsNames,this.firstRowAsNames,!0),this.decimalRegex=s&&new RegExp("^(-?[0-9]+)"+s+"([0-9]+)$"),this.rawColumns=[],this.columns.length&&(this.dataFound(),a=!0),this.hasURLOption(r)&&(clearTimeout(this.liveDataTimeout),a=!1),a||(a=this.fetchLiveData()),a||(a=!!this.parseCSV().length),a||(a=!!this.parseTable().length),a||(a=this.parseGoogleSpreadsheet()),!a&&r.afterComplete&&r.afterComplete()},n.prototype.hasURLOption=function(r){return!!(r&&(r.rowsURL||r.csvURL||r.columnsURL))},n.prototype.getColumnDistribution=function(){var r=this.chartOptions,t=this.options,o=[],s=function(g){return(seriesTypes$2[g||"line"].prototype.pointArrayMap||[0]).length},a=function(g){return seriesTypes$2[g||"line"].prototype.pointArrayMap},l=r&&r.chart&&r.chart.type,h=[],c=[],d=0,p=t&&t.seriesMapping||r&&r.series&&r.series.map(function(){return{x:0}})||[],u;(r&&r.series||[]).forEach(function(g){h.push(s(g.type||l))}),p.forEach(function(g){o.push(g.x||0)}),o.length===0&&o.push(0),p.forEach(function(g){var v=new SeriesBuilder,m=h[d]||s(l),x=r&&r.series||[],y=x[d]||{},b=a(y.type||l),$=b||["y"];for((defined$8(g.x)||y.isCartesian||!b)&&v.addColumnReader(g.x,"x"),objectEach$4(g,function(S,k){k!=="x"&&v.addColumnReader(S,k)}),u=0;u<m;u++)v.hasReader($[u])||v.addColumnReader(void 0,$[u]);c.push(v),d++});var f=a(l);typeof f>"u"&&(f=["y"]),this.valueCount={global:s(l),xColumns:o,individual:h,seriesBuilders:c,globalPointArrayMap:f}},n.prototype.dataFound=function(){this.options.switchRowsAndColumns&&(this.columns=this.rowsToColumns(this.columns)),this.getColumnDistribution(),this.parseTypes(),this.parsed()!==!1&&this.complete()},n.prototype.parseCSV=function(r){var t=this,o=r||this.options,s=o.csv,a,l=typeof o.startRow<"u"&&o.startRow?o.startRow:0,h=o.endRow||Number.MAX_VALUE,c=typeof o.startColumn<"u"&&o.startColumn?o.startColumn:0,d=o.endColumn||Number.MAX_VALUE,p,u,f=0,g=[],v={",":0,";":0,"	":0};a=this.columns=[];function m($,S,k,A){var P=0,E="",M="",T="",O="",L=0,C=0;function U(I){E=$[I],M=$[I-1],T=$[I+1]}function D(I){g.length<C+1&&g.push([I]),g[C][g[C].length-1]!==I&&g[C].push(I)}function N(){if(c>L||L>d){++L,O="";return}!isNaN(parseFloat(O))&&isFinite(O)?(O=parseFloat(O),D("number")):isNaN(Date.parse(O))?D("string"):(O=O.replace(/\//g,"-"),D("date")),a.length<C+1&&a.push([]),k||(a[C][S]=O),O="",++C,++L}if($.trim().length&&$.trim()[0]!=="#"){for(;P<$.length;P++)if(U(P),E==='"')for(U(++P);P<$.length&&!(E==='"'&&M!=='"'&&T!=='"');)(E!=='"'||E==='"'&&M!=='"')&&(O+=E),U(++P);else A&&A[E]?A[E](E,O)&&N():E===p?N():O+=E;N()}}function x($){var S=0,k=0,A=!1;return $.some(function(P,E){var M=!1,T,O,L,C="";if(E>13)return!0;for(var U=0;U<P.length;U++){if(T=P[U],O=P[U+1],L=P[U-1],T==="#")return;if(T==='"')if(M){if(L!=='"'&&O!=='"'){for(;O===" "&&U<P.length;)O=P[++U];typeof v[O]<"u"&&v[O]++,M=!1}}else M=!0;else typeof v[T]<"u"?(C=C.trim(),isNaN(Date.parse(C))?(isNaN(C)||!isFinite(C))&&v[T]++:v[T]++,C=""):C+=T;T===","&&k++,T==="."&&S++}}),v[";"]>v[","]?A=";":(v[","]>v[";"],A=","),o.decimalPoint||(S>k?o.decimalPoint=".":o.decimalPoint=",",t.decimalRegex=new RegExp("^(-?[0-9]+)"+o.decimalPoint+"([0-9]+)$")),A}function y($,S){var k="YYYY/mm/dd",A,P=[],E,M=0,T=!1,O=[],L=[],C;for((!S||S>$.length)&&(S=$.length);M<S;M++)if(typeof $[M]<"u"&&$[M]&&$[M].length)for(A=$[M].trim().replace(/\//g," ").replace(/\-/g," ").replace(/\./g," ").split(" "),P=["","",""],C=0;C<A.length;C++)C<P.length&&(A[C]=parseInt(A[C],10),A[C]&&(L[C]=!L[C]||L[C]<A[C]?A[C]:L[C],typeof O[C]<"u"?O[C]!==A[C]&&(O[C]=!1):O[C]=A[C],A[C]>31?A[C]<100?P[C]="YY":P[C]="YYYY":A[C]>12&&A[C]<=31?(P[C]="dd",T=!0):P[C].length||(P[C]="mm")));if(T){for(C=0;C<O.length;C++)O[C]!==!1?L[C]>12&&P[C]!=="YY"&&P[C]!=="YYYY"&&(P[C]="YY"):L[C]>12&&P[C]==="mm"&&(P[C]="dd");return P.length===3&&P[1]==="dd"&&P[2]==="dd"&&(P[2]="YY"),E=P.join("/"),(o.dateFormats||t.dateFormats)[E]?E:(fireEvent$5("deduceDateFailed"),k)}return k}if(s&&o.beforeParse&&(s=o.beforeParse.call(this,s)),s){u=s.replace(/\r\n/g,`
`).replace(/\r/g,`
`).split(o.lineDelimiter||`
`),(!l||l<0)&&(l=0),(!h||h>=u.length)&&(h=u.length-1),o.itemDelimiter?p=o.itemDelimiter:(p=null,p=x(u));var b=0;for(f=l;f<=h;f++)u[f][0]==="#"?b++:m(u[f],f-l-b);(!o.columnTypes||o.columnTypes.length===0)&&g.length&&g[0].length&&g[0][1]==="date"&&!o.dateFormat&&(o.dateFormat=y(a[0])),this.dataFound()}return a},n.prototype.parseTable=function(){var r=this.options,t=r.table,o=this.columns||[],s=r.startRow||0,a=r.endRow||Number.MAX_VALUE,l=r.startColumn||0,h=r.endColumn||Number.MAX_VALUE;return t&&(typeof t=="string"&&(t=doc$1.getElementById(t)),[].forEach.call(t.getElementsByTagName("tr"),function(c,d){d>=s&&d<=a&&[].forEach.call(c.children,function(p,u){var f=o[u-l],g=1;if((p.tagName==="TD"||p.tagName==="TH")&&u>=l&&u<=h)for(o[u-l]||(o[u-l]=[]),o[u-l][d-s]=p.innerHTML;d-s>=g&&f[d-s-g]===void 0;)f[d-s-g]=null,g++})}),this.dataFound()),o},n.prototype.fetchLiveData=function(){var r=this,t=this.chart,o=this.options,s=3,a=0,l=o.enablePolling,h=(o.dataRefreshRate||2)*1e3,c=merge$h(o);if(!this.hasURLOption(o))return!1;h<1e3&&(h=1e3),delete o.csvURL,delete o.rowsURL,delete o.columnsURL;function d(p){function u(f,g,v){if(!f||!/^(http|\/|\.\/|\.\.\/)/.test(f))return f&&o.error&&o.error("Invalid URL"),!1;p&&(clearTimeout(r.liveDataTimeout),t.liveDataURL=f);function m(){l&&t.liveDataURL===f&&(r.liveDataTimeout=setTimeout(d,h))}return ajax({url:f,dataType:v||"json",success:function(x){t&&t.series&&g(x),m()},error:function(x,y){return++a<s&&m(),o.error&&o.error(y,x)}}),!0}u(c.csvURL,function(f){t.update({data:{csv:f}})},"text")||u(c.rowsURL,function(f){t.update({data:{rows:f}})})||u(c.columnsURL,function(f){t.update({data:{columns:f}})})}return d(!0),this.hasURLOption(o)},n.prototype.parseGoogleSpreadsheet=function(){var r=this,t=this.options,o=t.googleSpreadsheetKey,s=this.chart,a=Math.max((t.dataRefreshRate||2)*1e3,4e3),l=function(){if(t.googleSpreadsheetRange)return t.googleSpreadsheetRange;var c="ABCDEFGHIJKLMNOPQRSTUVWXYZ",d=(c.charAt(t.startColumn||0)||"A")+((t.startRow||0)+1),p=c.charAt(pick$j(t.endColumn,-1))||"ZZ";return defined$8(t.endRow)&&(p+=t.endRow+1),d+":"+p};function h(c){var d=["https://sheets.googleapis.com/v4/spreadsheets",o,"values",l(),"?alt=json&majorDimension=COLUMNS&valueRenderOption=UNFORMATTED_VALUE&dateTimeRenderOption=FORMATTED_STRING&key="+t.googleAPIKey].join("/");ajax({url:d,dataType:"json",success:function(p){c(p),t.enablePolling&&setTimeout(function(){h(c)},a)},error:function(p,u){return t.error&&t.error(u,p)}})}return o&&(delete t.googleSpreadsheetKey,h(function(c){var d=c.values;if(!d||d.length===0)return!1;var p=d.reduce(function(u,f){return Math.max(u,f.length)},0);d.forEach(function(u){for(var f=0;f<p;f++)typeof u[f]>"u"&&(u[f]=null)}),s&&s.series?s.update({data:{columns:d}}):(r.columns=d,r.dataFound())})),!1},n.prototype.trim=function(r,t){return typeof r=="string"&&(r=r.replace(/^\s+|\s+$/g,""),t&&/^[0-9\s]+$/.test(r)&&(r=r.replace(/\s/g,"")),this.decimalRegex&&(r=r.replace(this.decimalRegex,"$1.$2"))),r},n.prototype.parseTypes=function(){for(var r=this.columns,t=r.length;t--;)this.parseColumn(r[t],t)},n.prototype.parseColumn=function(r,t){var o=this.rawColumns,s=this.columns,a=r.length,l,h,c,d,p=this.firstRowAsNames,u=this.valueCount.xColumns.indexOf(t)!==-1,f,g=[],v,m=this.chartOptions,x,y=this.options.columnTypes||[],b=y[t],$=u&&(m&&m.xAxis&&splat$1(m.xAxis)[0].type==="category"||b==="string");for(o[t]||(o[t]=[]);a--;)l=g[a]||r[a],c=this.trim(l),d=this.trim(l,!0),h=parseFloat(d),typeof o[t][a]>"u"&&(o[t][a]=c),$||a===0&&p?r[a]=""+c:+d===h?(r[a]=h,h>365*24*3600*1e3&&b!=="float"?r.isDatetime=!0:r.isNumeric=!0,typeof r[a+1]<"u"&&(x=h>r[a+1])):(c&&c.length&&(f=this.parseDate(l)),u&&isNumber$8(f)&&b!=="float"?(g[a]=l,r[a]=f,r.isDatetime=!0,typeof r[a+1]<"u"&&(v=f>r[a+1],v!==x&&typeof x<"u"&&(this.alternativeFormat?(this.dateFormat=this.alternativeFormat,a=r.length,this.alternativeFormat=this.dateFormats[this.dateFormat].alternative):r.unsorted=!0),x=v)):(r[a]=c===""?null:c,a!==0&&(r.isDatetime||r.isNumeric)&&(r.mixed=!0)));if(u&&r.mixed&&(s[t]=o[t]),u&&x&&this.options.sort)for(t=0;t<s.length;t++)s[t].reverse(),p&&s[t].unshift(s[t].pop())},n.prototype.parseDate=function(r){var t=this.options.parseDate,o,s,a,l=this.options.dateFormat||this.dateFormat,h;if(t)o=t(r);else if(typeof r=="string"){if(l)a=this.dateFormats[l],a||(a=this.dateFormats["YYYY/mm/dd"]),h=r.match(a.regex),h&&(o=a.parser(h));else for(s in this.dateFormats)if(a=this.dateFormats[s],h=r.match(a.regex),h){this.dateFormat=l=s,this.alternativeFormat=a.alternative,o=a.parser(h);break}h||(r.match(/:.+(GMT|UTC|[Z+-])/)&&(r=r.replace(/\s*(?:GMT|UTC)?([+-])(\d\d)(\d\d)$/,"$1$2:$3").replace(/(?:\s+|GMT|UTC)([+-])/,"$1").replace(/(\d)\s*(?:GMT|UTC|Z)$/,"$1+00:00")),h=Date.parse(r),typeof h=="object"&&h!==null&&h.getTime?o=h.getTime()-h.getTimezoneOffset()*6e4:isNumber$8(h)&&(o=h-new Date(h).getTimezoneOffset()*6e4))}return o},n.prototype.rowsToColumns=function(r){var t,o,s,a,l;if(r)for(l=[],o=r.length,t=0;t<o;t++)for(a=r[t].length,s=0;s<a;s++)l[s]||(l[s]=[]),l[s][t]=r[t][s];return l},n.prototype.getData=function(){if(this.columns)return this.rowsToColumns(this.columns).slice(1)},n.prototype.parsed=function(){if(this.options.parsed)return this.options.parsed.call(this,this.columns)},n.prototype.getFreeIndexes=function(r,t){var o,s,a=[],l=[],h;for(s=0;s<r;s=s+1)a.push(!0);for(o=0;o<t.length;o=o+1)for(h=t[o].getReferencedColumnIndexes(),s=0;s<h.length;s=s+1)a[h[s]]=!1;for(s=0;s<a.length;s=s+1)a[s]&&l.push(s);return l},n.prototype.complete=function(){var r=this.columns,t,o=this.options,s,a,l,h,c,d,p,u=[],f,g,v,m;if(r.length,o.complete||o.afterComplete){if(this.firstRowAsNames)for(l=0;l<r.length;l++)r[l].name=r[l].shift();for(s=[],g=this.getFreeIndexes(r.length,this.valueCount.seriesBuilders),d=0;d<this.valueCount.seriesBuilders.length;d++)f=this.valueCount.seriesBuilders[d],f.populateColumns(g)&&u.push(f);for(;g.length>0;){for(f=new SeriesBuilder,f.addColumnReader(0,"x"),m=g.indexOf(0),m!==-1&&g.splice(m,1),l=0;l<this.valueCount.global;l++)f.addColumnReader(void 0,this.valueCount.globalPointArrayMap[l]);f.populateColumns(g)&&u.push(f)}if(u.length>0&&u[0].readers.length>0&&(v=r[u[0].readers[0].columnIndex],typeof v<"u"&&(v.isDatetime?t="datetime":v.isNumeric||(t="category"))),t==="category")for(d=0;d<u.length;d++)for(f=u[d],c=0;c<f.readers.length;c++)f.readers[c].configName==="x"&&(f.readers[c].configName="name");for(d=0;d<u.length;d++){for(f=u[d],a=[],h=0;h<r[0].length;h++)a[h]=f.read(r,h);s[d]={data:a},f.name&&(s[d].name=f.name),t==="category"&&(s[d].turboThreshold=0)}p={series:s},t&&(p.xAxis={type:t},t==="category"&&(p.xAxis.uniqueNames=!1)),o.complete&&o.complete(p),o.afterComplete&&o.afterComplete(p)}},n.prototype.update=function(r,t){var o=this.chart;r&&(r.afterComplete=function(s){s&&(s.xAxis&&o.xAxis[0]&&s.xAxis.type===o.xAxis[0].options.type&&delete s.xAxis,o.update(s,t,!0))},merge$h(!0,o.options.data,r),this.init(o.options.data))},n}();H.data=function(n,r,t){return new H.Data(n,r,t)};addEvent$b(Chart$1,"init",function(n){var r=this,t=n.args[0]||{},o=n.args[1];t&&t.data&&!r.hasDataDef&&(r.hasDataDef=!0,r.data=new H.Data(extend$m(t.data,{afterComplete:function(s){var a,l;if(Object.hasOwnProperty.call(t,"series"))if(typeof t.series=="object")for(a=Math.max(t.series.length,s&&s.series?s.series.length:0);a--;)l=t.series[a]||{},t.series[a]=merge$h(l,s&&s.series?s.series[a]:{});else delete t.series;t=merge$h(s,t),r.init(t,o)}}),t,r),n.preventDefault())});var SeriesBuilder=function(){function n(){this.readers=[],this.pointIsArray=!0,this.name=void 0}return n.prototype.populateColumns=function(r){var t=this,o=!0;return t.readers.forEach(function(s){typeof s.columnIndex>"u"&&(s.columnIndex=r.shift())}),t.readers.forEach(function(s){typeof s.columnIndex>"u"&&(o=!1)}),o},n.prototype.read=function(r,t){var o=this,s=o.pointIsArray,a=s?[]:{},l;return o.readers.forEach(function(h){var c=r[h.columnIndex][t];s?a.push(c):h.configName.indexOf(".")>0?Point$2.prototype.setNestedProperty(a,c,h.configName):a[h.configName]=c}),typeof this.name>"u"&&o.readers.length>=2&&(l=o.getReferencedColumnIndexes(),l.length>=2&&(l.shift(),l.sort(function(h,c){return h-c}),this.name=r[l.shift()].name)),a},n.prototype.addColumnReader=function(r,t){this.readers.push({columnIndex:r,configName:t}),t==="x"||t==="y"||typeof t>"u"||(this.pointIsArray=!1)},n.prototype.getReferencedColumnIndexes=function(){var r,t=[],o;for(r=0;r<this.readers.length;r=r+1)o=this.readers[r],typeof o.columnIndex<"u"&&t.push(o.columnIndex);return t},n.prototype.hasReader=function(r){var t,o;for(t=0;t<this.readers.length;t=t+1)if(o=this.readers[t],o.configName===r)return!0},n}();H.Data=Data;H.Data;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/data
 * @requires highcharts
 *
 * Data module
 *
 * (c) 2012-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$2=H;G$2.HttpUtilities=exports$2;G$2.ajax=exports$2.ajax;G$2.getJSON=exports$2.getJSON;G$2.post=exports$2.post;var animObject=animationExports.animObject,format=FormatUtilities.format,noop$4=H.noop,defaultOptions$2=DefaultOptions.defaultOptions,seriesTypes$1=SeriesRegistry$1.seriesTypes,addEvent$a=Utilities.addEvent,removeEvent$1=Utilities.removeEvent,extend$l=Utilities.extend,fireEvent$4=Utilities.fireEvent,merge$g=Utilities.merge,objectEach$3=Utilities.objectEach,pick$i=Utilities.pick,syncTimeout=Utilities.syncTimeout,PieSeries$1=seriesTypes$1.pie,ddSeriesId=1;extend$l(defaultOptions$2.lang,{drillUpText:"◁ Back to {series.name}"});defaultOptions$2.drilldown={activeAxisLabelStyle:{cursor:"pointer",color:palette.highlightColor100,fontWeight:"bold",textDecoration:"underline"},activeDataLabelStyle:{cursor:"pointer",color:palette.highlightColor100,fontWeight:"bold",textDecoration:"underline"},animation:{duration:500},drillUpButton:{position:{align:"right",x:-10,y:10}}};SVGRenderer.prototype.Element.prototype.fadeIn=function(n){this.attr({opacity:.1,visibility:"inherit"}).animate({opacity:pick$i(this.newOpacity,1)},n||{duration:250})};Chart$1.prototype.addSeriesAsDrilldown=function(n,r){this.addSingleSeriesAsDrilldown(n,r),this.applyDrilldown()};Chart$1.prototype.addSingleSeriesAsDrilldown=function(n,r){var t=n.series,o=t.xAxis,s=t.yAxis,a,l,h=[],c=[],d,p,u,f;f=this.styledMode?{colorIndex:pick$i(n.colorIndex,t.colorIndex)}:{color:n.color||t.color},this.drilldownLevels||(this.drilldownLevels=[]),p=t.options._levelNumber||0,u=this.drilldownLevels[this.drilldownLevels.length-1],u&&u.levelNumber!==p&&(u=void 0),r=extend$l(extend$l({_ddSeriesId:ddSeriesId++},f),r),l=t.points.indexOf(n),t.chart.series.forEach(function(g){g.xAxis===o&&!g.isDrilling&&(g.options._ddSeriesId=g.options._ddSeriesId||ddSeriesId++,g.options._colorIndex=g.userOptions._colorIndex,g.options._levelNumber=g.options._levelNumber||p,u?(h=u.levelSeries,c=u.levelSeriesOptions):(h.push(g),g.purgedOptions=merge$g({_ddSeriesId:g.options._ddSeriesId,_levelNumber:g.options._levelNumber,selected:g.options.selected},g.userOptions),c.push(g.purgedOptions)))}),d=extend$l({levelNumber:p,seriesOptions:t.options,seriesPurgedOptions:t.purgedOptions,levelSeriesOptions:c,levelSeries:h,shapeArgs:n.shapeArgs,bBox:n.graphic?n.graphic.getBBox():{},color:n.isNull?Color.parse(f.color).setOpacity(0).get():f.color,lowerSeriesOptions:r,pointOptions:t.options.data[l],pointIndex:l,oldExtremes:{xMin:o&&o.userMin,xMax:o&&o.userMax,yMin:s&&s.userMin,yMax:s&&s.userMax},resetZoomButton:this.resetZoomButton},f),this.drilldownLevels.push(d),o&&o.names&&(o.names.length=0),a=d.lowerSeries=this.addSeries(r,!1),a.options._levelNumber=p+1,o&&(o.oldPos=o.pos,o.userMin=o.userMax=null,s.userMin=s.userMax=null),t.type===a.type&&(a.animate=a.animateDrilldown||noop$4,a.options.animation=!0)};Chart$1.prototype.applyDrilldown=function(){var n=this.drilldownLevels,r;n&&n.length>0&&(r=n[n.length-1].levelNumber,this.drilldownLevels.forEach(function(t){t.levelNumber===r&&t.levelSeries.forEach(function(o){o.options&&o.options._levelNumber===r&&o.remove(!1)})})),this.resetZoomButton&&(this.resetZoomButton.hide(),delete this.resetZoomButton),this.pointer.reset(),this.redraw(),this.showDrillUpButton(),fireEvent$4(this,"afterDrilldown")};Chart$1.prototype.getDrilldownBackText=function(){var n=this.drilldownLevels,r;if(n&&n.length>0)return r=n[n.length-1],r.series=r.seriesOptions,format(this.options.lang.drillUpText||"",r)};Chart$1.prototype.showDrillUpButton=function(){var n=this,r=this.getDrilldownBackText(),t=n.options.drilldown.drillUpButton,o,s,a=t.relativeTo==="chart"||t.relativeTo==="spacingBox"?null:"scrollablePlotBox";this.drillUpButton?this.drillUpButton.attr({text:r}).align():(o=t.theme,s=o&&o.states,this.drillUpButton=this.renderer.button(r,null,null,function(){n.drillUp()},o,s&&s.hover,s&&s.select).addClass("highcharts-drillup-button").attr({align:t.position.align,zIndex:7}).add().align(t.position,!1,a))};Chart$1.prototype.drillUp=function(){if(!(!this.drilldownLevels||this.drilldownLevels.length===0)){for(var n=this,r=n.drilldownLevels,t=r[r.length-1].levelNumber,o=r.length,s=n.series,a,l,h,c,d,p=function(u){var f;s.forEach(function(g){g.options._ddSeriesId===u._ddSeriesId&&(f=g)}),f=f||n.addSeries(u,!1),f.type===h.type&&f.animateDrillupTo&&(f.animate=f.animateDrillupTo),u===l.seriesPurgedOptions&&(c=f)};o--;)if(l=r[o],l.levelNumber===t){if(r.pop(),h=l.lowerSeries,!h.chart){for(a=s.length;a--;)if(s[a].options.id===l.lowerSeriesOptions.id&&s[a].options._levelNumber===t+1){h=s[a];break}}h.xData=[],l.levelSeriesOptions.forEach(p),fireEvent$4(n,"drillup",{seriesOptions:l.seriesPurgedOptions||l.seriesOptions}),this.resetZoomButton&&this.resetZoomButton.destroy(),c.type===h.type&&(c.drilldownLevel=l,c.options.animation=n.options.drilldown.animation,h.animateDrillupFrom&&h.chart&&h.animateDrillupFrom(l)),c.options._levelNumber=t,h.remove(!1),c.xAxis&&(d=l.oldExtremes,c.xAxis.setExtremes(d.xMin,d.xMax,!1),c.yAxis.setExtremes(d.yMin,d.yMax,!1)),l.resetZoomButton&&(n.resetZoomButton=l.resetZoomButton,n.resetZoomButton.show())}this.redraw(),this.drilldownLevels.length===0?this.drillUpButton=this.drillUpButton.destroy():this.drillUpButton.attr({text:this.getDrilldownBackText()}).align(),this.ddDupes.length=[],fireEvent$4(n,"drillupall")}};addEvent$a(Chart$1,"afterInit",function(){var n=this;n.drilldown={update:function(r,t){merge$g(!0,n.options.drilldown,r),pick$i(t,!0)&&n.redraw()}}});addEvent$a(Chart$1,"afterShowResetZoom",function(){var n=this,r=n.resetZoomButton&&n.resetZoomButton.getBBox(),t=n.options.drilldown&&n.options.drilldown.drillUpButton;this.drillUpButton&&r&&t&&t.position&&t.position.x&&this.drillUpButton.align({x:t.position.x-r.width-10,y:t.position.y,align:t.position.align},!1,t.relativeTo||"plotBox")});addEvent$a(Chart$1,"render",function(){(this.xAxis||[]).forEach(function(n){n.ddPoints={},n.series.forEach(function(r){var t,o=r.xData||[],s=r.points,a;for(t=0;t<o.length;t++)if(a=r.options.data[t],typeof a!="number"&&(a=r.pointClass.prototype.optionsToObject.call({series:r},a),a.drilldown)){n.ddPoints[o[t]]||(n.ddPoints[o[t]]=[]);var l=t-(r.cropStart||0);n.ddPoints[o[t]].push(s&&l>=0&&l<s.length?s[l]:!0)}}),objectEach$3(n.ticks,Tick.prototype.drillable)})});ColumnSeries$h.prototype.animateDrillupTo=function(n){if(!n){var r=this,t=r.drilldownLevel;this.points.forEach(function(o){var s=o.dataLabel;o.graphic&&o.graphic.hide(),s&&(s.hidden=s.attr("visibility")==="hidden",s.hidden||(s.hide(),o.connector&&o.connector.hide()))}),syncTimeout(function(){if(r.points){var o=[];r.data.forEach(function(s){o.push(s)}),r.nodes&&(o=o.concat(r.nodes)),o.forEach(function(s,a){var l=a===(t&&t.pointIndex)?"show":"fadeIn",h=l==="show"?!0:void 0,c=s.dataLabel;s.graphic&&s.graphic[l](h),c&&!c.hidden&&(c.fadeIn(),s.connector&&s.connector.fadeIn())})}},Math.max(this.chart.options.drilldown.animation.duration-50,0)),delete this.animate}};ColumnSeries$h.prototype.animateDrilldown=function(n){var r=this,t=this.chart,o=t.drilldownLevels,s,a=animObject(t.options.drilldown.animation),l=this.xAxis,h=t.styledMode;n||(o.forEach(function(c){r.options._ddSeriesId===c.lowerSeriesOptions._ddSeriesId&&(s=c.shapeArgs,h||(s.fill=c.color))}),s.x+=pick$i(l.oldPos,l.pos)-l.pos,this.points.forEach(function(c){var d=c.shapeArgs;h||(d.fill=c.color),c.graphic&&c.graphic.attr(s).animate(extend$l(c.shapeArgs,{fill:c.color||r.color}),a),c.dataLabel&&c.dataLabel.fadeIn(a)}),delete this.animate)};ColumnSeries$h.prototype.animateDrillupFrom=function(n){var r=animObject(this.chart.options.drilldown.animation),t=this.group,o=t!==this.chart.columnGroup,s=this;s.trackerGroups.forEach(function(a){s[a]&&s[a].on("mouseover")}),o&&delete this.group,this.points.forEach(function(a){var l=a.graphic,h=n.shapeArgs,c=function(){l.destroy(),t&&o&&(t=t.destroy())};l&&h&&(delete a.graphic,s.chart.styledMode||(h.fill=n.color),r.duration?l.animate(h,merge$g(r,{complete:c})):(l.attr(h),c()))})};PieSeries$1&&extend$l(PieSeries$1.prototype,{animateDrillupTo:ColumnSeries$h.prototype.animateDrillupTo,animateDrillupFrom:ColumnSeries$h.prototype.animateDrillupFrom,animateDrilldown:function(n){var r=this.chart.drilldownLevels[this.chart.drilldownLevels.length-1],t=this.chart.options.drilldown.animation;if(this.is("item")&&(t.duration=0),this.center){var o=r.shapeArgs,s=o.start,a=o.end-s,l=a/this.points.length,h=this.chart.styledMode;n||(this.points.forEach(function(c,d){var p=c.shapeArgs;h||(o.fill=r.color,p.fill=c.color),c.graphic&&c.graphic.attr(merge$g(o,{start:s+d*l,end:s+(d+1)*l}))[t?"animate":"attr"](p,t)}),delete this.animate)}}});Point$2.prototype.doDrilldown=function(){this.runDrilldown()};Point$2.prototype.runDrilldown=function(n,r,t){var o=this.series,s=o.chart,a=s.options.drilldown,l=(a.series||[]).length,h;for(s.ddDupes||(s.ddDupes=[]);l--&&!h;)a.series[l].id===this.drilldown&&s.ddDupes.indexOf(this.drilldown)===-1&&(h=a.series[l],s.ddDupes.push(this.drilldown));fireEvent$4(s,"drilldown",{point:this,seriesOptions:h,category:r,originalEvent:t,points:typeof r<"u"&&this.series.xAxis.getDDPoints(r).slice(0)},function(c){var d=c.point.series&&c.point.series.chart,p=c.seriesOptions;d&&p&&(n?d.addSingleSeriesAsDrilldown(c.point,p):d.addSeriesAsDrilldown(c.point,p))})};Axis.prototype.drilldownCategory=function(n,r){this.getDDPoints(n).forEach(function(t){t&&t.series&&t.series.visible&&t.runDrilldown&&t.runDrilldown(!0,n,r)}),this.chart.applyDrilldown()};Axis.prototype.getDDPoints=function(n){return this.ddPoints&&this.ddPoints[n]||[]};Tick.prototype.drillable=function(){var n=this.pos,r=this.label,t=this.axis,o=t.coll==="xAxis"&&t.getDDPoints,s=o&&t.getDDPoints(n),a=t.chart.styledMode;o&&(r&&s&&s.length?(r.drillable=!0,!r.basicStyles&&!a&&(r.basicStyles=merge$g(r.styles)),r.addClass("highcharts-drilldown-axis-label"),r.removeOnDrillableClick&&removeEvent$1(r.element,"click"),r.removeOnDrillableClick=addEvent$a(r.element,"click",function(l){l.preventDefault(),t.drilldownCategory(n,l)}),a||r.css(t.chart.options.drilldown.activeAxisLabelStyle)):r&&r.drillable&&r.removeOnDrillableClick&&(a||(r.styles={},r.css(r.basicStyles)),r.removeOnDrillableClick(),r.removeClass("highcharts-drilldown-axis-label")))};addEvent$a(Point$2,"afterInit",function(){var n=this;return n.drilldown&&!n.unbindDrilldownClick&&(n.unbindDrilldownClick=addEvent$a(n,"click",handlePointClick)),n});addEvent$a(Point$2,"update",function(n){var r=this,t=n.options||{};t.drilldown&&!r.unbindDrilldownClick?r.unbindDrilldownClick=addEvent$a(r,"click",handlePointClick):!t.drilldown&&t.drilldown!==void 0&&r.unbindDrilldownClick&&(r.unbindDrilldownClick=r.unbindDrilldownClick())});var handlePointClick=function(n){var r=this,t=r.series;t.xAxis&&t.chart.options.drilldown.allowPointDrilldown===!1?t.xAxis.drilldownCategory(r.x,n):r.runDrilldown(void 0,void 0,n)};addEvent$a(Series$e,"afterDrawDataLabels",function(){var n=this.chart.options.drilldown.activeDataLabelStyle,r=this.chart.renderer,t=this.chart.styledMode;this.points.forEach(function(o){var s=o.options.dataLabels,a=pick$i(o.dlOptions,s&&s.style,{});o.drilldown&&o.dataLabel&&(n.color==="contrast"&&!t&&(a.color=r.getContrast(o.color||this.color)),s&&s.color&&(a.color=s.color),o.dataLabel.addClass("highcharts-drilldown-data-label"),t||o.dataLabel.css(n).css(a))},this)});var applyCursorCSS=function(n,r,t,o){n[t?"addClass":"removeClass"]("highcharts-drilldown-point"),o||n.css({cursor:r})};addEvent$a(Series$e,"afterDrawTracker",function(){var n=this.chart.styledMode;this.points.forEach(function(r){r.drilldown&&r.graphic&&applyCursorCSS(r.graphic,"pointer",!0,n)})});addEvent$a(Point$2,"afterSetState",function(){var n=this.series.chart.styledMode;this.drilldown&&this.series.halo&&this.state==="hover"?applyCursorCSS(this.series.halo,"pointer",!0,n):this.series.halo&&applyCursorCSS(this.series.halo,"auto",!1,n)});addEvent$a(Chart$1,"selection",function(n){if(n.resetSelection===!0&&this.drillUpButton){var r=this.options.drilldown&&this.options.drilldown.drillUpButton;r&&r.position&&this.drillUpButton.align({x:r.position.x,y:r.position.y,align:r.position.align},!1,r.relativeTo||"plotBox")}});addEvent$a(Chart$1,"drillup",function(){this.resetZoomButton&&(this.resetZoomButton=this.resetZoomButton.destroy())});H.doc;var addEvent$9=Utilities.addEvent,Fullscreen=function(){function n(r){this.chart=r,this.isOpen=!1;var t=r.renderTo;this.browserProps||(typeof t.requestFullscreen=="function"?this.browserProps={fullscreenChange:"fullscreenchange",requestFullscreen:"requestFullscreen",exitFullscreen:"exitFullscreen"}:t.mozRequestFullScreen?this.browserProps={fullscreenChange:"mozfullscreenchange",requestFullscreen:"mozRequestFullScreen",exitFullscreen:"mozCancelFullScreen"}:t.webkitRequestFullScreen?this.browserProps={fullscreenChange:"webkitfullscreenchange",requestFullscreen:"webkitRequestFullScreen",exitFullscreen:"webkitExitFullscreen"}:t.msRequestFullscreen&&(this.browserProps={fullscreenChange:"MSFullscreenChange",requestFullscreen:"msRequestFullscreen",exitFullscreen:"msExitFullscreen"}))}return n.prototype.close=function(){var r=this,t=r.chart,o=t.options.chart;r.isOpen&&r.browserProps&&t.container.ownerDocument instanceof Document&&t.container.ownerDocument[r.browserProps.exitFullscreen](),r.unbindFullscreenEvent&&(r.unbindFullscreenEvent=r.unbindFullscreenEvent()),t.setSize(r.origWidth,r.origHeight,!1),r.origWidth=void 0,r.origHeight=void 0,o.width=r.origWidthOption,o.height=r.origHeightOption,r.origWidthOption=void 0,r.origHeightOption=void 0,r.isOpen=!1,r.setButtonText()},n.prototype.open=function(){var r=this,t=r.chart,o=t.options.chart;if(o&&(r.origWidthOption=o.width,r.origHeightOption=o.height),r.origWidth=t.chartWidth,r.origHeight=t.chartHeight,r.browserProps){var s=addEvent$9(t.container.ownerDocument,r.browserProps.fullscreenChange,function(){r.isOpen?(r.isOpen=!1,r.close()):(t.setSize(null,null,!1),r.isOpen=!0,r.setButtonText())}),a=addEvent$9(t,"destroy",s);r.unbindFullscreenEvent=function(){s(),a()};var l=t.renderTo[r.browserProps.requestFullscreen]();l&&l.catch(function(){alert("Full screen is not supported inside a frame.")})}},n.prototype.setButtonText=function(){var r=this.chart,t=r.exportDivElements,o=r.options.exporting,s=o&&o.buttons&&o.buttons.contextButton.menuItems,a=r.options.lang;if(o&&o.menuItemDefinitions&&a&&a.exitFullscreen&&a.viewFullscreen&&s&&t){var l=t[s.indexOf("viewFullscreen")];l&&AST.setElementHTML(l,this.isOpen?a.exitFullscreen:o.menuItemDefinitions.viewFullscreen.text||a.viewFullscreen)}},n.prototype.toggle=function(){var r=this;r.isOpen?r.close():r.open()},n}();H.Fullscreen=Fullscreen;H.Fullscreen;addEvent$9(Chart$1,"beforeRender",function(){this.fullscreen=new H.Fullscreen(this)});var isTouchDevice=H.isTouchDevice,exporting={type:"image/png",url:"https://export.highcharts.com/",printMaxWidth:780,scale:2,buttons:{contextButton:{className:"highcharts-contextbutton",menuClassName:"highcharts-contextmenu",symbol:"menu",titleKey:"contextButtonTitle",menuItems:["viewFullscreen","printChart","separator","downloadPNG","downloadJPEG","downloadPDF","downloadSVG"]}},menuItemDefinitions:{viewFullscreen:{textKey:"viewFullscreen",onclick:function(){this.fullscreen.toggle()}},printChart:{textKey:"printChart",onclick:function(){this.print()}},separator:{separator:!0},downloadPNG:{textKey:"downloadPNG",onclick:function(){this.exportChart()}},downloadJPEG:{textKey:"downloadJPEG",onclick:function(){this.exportChart({type:"image/jpeg"})}},downloadPDF:{textKey:"downloadPDF",onclick:function(){this.exportChart({type:"application/pdf"})}},downloadSVG:{textKey:"downloadSVG",onclick:function(){this.exportChart({type:"image/svg+xml"})}}}},lang={viewFullscreen:"View in full screen",exitFullscreen:"Exit from full screen",printChart:"Print chart",downloadPNG:"Download PNG image",downloadJPEG:"Download JPEG image",downloadPDF:"Download PDF document",downloadSVG:"Download SVG vector image",contextButtonTitle:"Chart context menu"},navigation={buttonOptions:{symbolSize:14,symbolX:12.5,symbolY:10.5,align:"right",buttonSpacing:3,height:22,verticalAlign:"top",width:24,symbolFill:palette.neutralColor60,symbolStroke:palette.neutralColor60,symbolStrokeWidth:3,theme:{padding:5}},menuStyle:{border:"1px solid "+palette.neutralColor40,background:palette.backgroundColor,padding:"5px 0"},menuItemStyle:{padding:"0.5em 1em",color:palette.neutralColor80,background:"none",fontSize:isTouchDevice?"14px":"11px",transition:"background 250ms, color 250ms"},menuItemHoverStyle:{background:palette.highlightColor80,color:palette.backgroundColor}},ExportingDefaults={exporting,lang,navigation},ExportingSymbols;(function(n){var r=[];function t(a){if(r.indexOf(a)===-1){r.push(a);var l=a.prototype.symbols;l.menu=o,l.menuball=s.bind(l)}}n.compose=t;function o(a,l,h,c){var d=[["M",a,l+2.5],["L",a+h,l+2.5],["M",a,l+c/2+.5],["L",a+h,l+c/2+.5],["M",a,l+c-1.5],["L",a+h,l+c-1.5]];return d}function s(a,l,h,c){var d=c/3-2,p=[];return p=p.concat(this.circle(h-d,l,d,d),this.circle(h-d,l+d+4,d,d),this.circle(h-d,l+2*(d+4),d,d)),p}})(ExportingSymbols||(ExportingSymbols={}));const ExportingSymbols$1=ExportingSymbols;var defaultOptions$1=DefaultOptions.defaultOptions,doc=H.doc,win$1=H.win,addEvent$8=Utilities.addEvent,css$1=Utilities.css,createElement=Utilities.createElement,discardElement=Utilities.discardElement,extend$k=Utilities.extend,find$3=Utilities.find,fireEvent$3=Utilities.fireEvent,isObject$4=Utilities.isObject,merge$f=Utilities.merge,objectEach$2=Utilities.objectEach,pick$h=Utilities.pick,removeEvent=Utilities.removeEvent,uniqueKey=Utilities.uniqueKey,Exporting;(function(n){var r=[],t=[/-/,/^(clipPath|cssText|d|height|width)$/,/^font$/,/[lL]ogical(Width|Height)$/,/perspective/,/TapHighlightColor/,/^transition/,/^length$/],o=["fill","stroke","strokeLinecap","strokeLinejoin","strokeWidth","textAnchor","x","y"];n.inlineWhitelist=[];var s=["clipPath","defs","desc"],a;function l(M){var T=this,O=T.renderer,L=merge$f(T.options.navigation.buttonOptions,M),C=L.onclick,U=L.menuItems,D=L.symbolSize||12,N;if(T.btnCount||(T.btnCount=0),T.exportDivElements||(T.exportDivElements=[],T.exportSVGElements=[]),!(L.enabled===!1||!L.theme)){var I=L.theme,B=I.states,X=B&&B.hover,W=B&&B.select,F;T.styledMode||(I.fill=pick$h(I.fill,palette.backgroundColor),I.stroke=pick$h(I.stroke,"none")),delete I.states,C?F=function(z){z&&z.stopPropagation(),C.call(T,z)}:U&&(F=function(z){z&&z.stopPropagation(),T.contextMenu(_.menuClassName,U,_.translateX,_.translateY,_.width,_.height,_),_.setState(2)}),L.text&&L.symbol?I.paddingLeft=pick$h(I.paddingLeft,30):L.text||extend$k(I,{width:L.width,height:L.height,padding:0}),T.styledMode||(I["stroke-linecap"]="round",I.fill=pick$h(I.fill,palette.backgroundColor),I.stroke=pick$h(I.stroke,"none"));var _=O.button(L.text,0,0,F,I,X,W).addClass(M.className).attr({title:pick$h(T.options.lang[L._titleKey||L.titleKey],"")});_.menuClassName=M.menuClassName||"highcharts-menu-"+T.btnCount++,L.symbol&&(N=O.symbol(L.symbol,L.symbolX-D/2,L.symbolY-D/2,D,D,{width:D,height:D}).addClass("highcharts-button-symbol").attr({zIndex:1}).add(_),T.styledMode||N.attr({stroke:L.symbolStroke,fill:L.symbolFill,"stroke-width":L.symbolStrokeWidth||1})),_.add(T.exportingGroup).align(extend$k(L,{width:_.width,x:pick$h(L.x,T.buttonOffset)}),!0,"spacingBox"),T.buttonOffset+=(_.width+L.buttonSpacing)*(L.align==="right"?-1:1),T.exportSVGElements.push(_,N)}}function h(){var M=this;if(M.printReverseInfo){var T=M.printReverseInfo,O=T.childNodes,L=T.origDisplay,C=T.resetParams;M.moveContainers(M.renderTo),[].forEach.call(O,function(U,D){U.nodeType===1&&(U.style.display=L[D]||"")}),M.isPrinting=!1,C&&M.setSize.apply(M,C),delete M.printReverseInfo,a=void 0,fireEvent$3(M,"afterPrint")}}function c(){var M=this,T=doc.body,O=M.options.exporting.printMaxWidth,L={childNodes:T.childNodes,origDisplay:[],resetParams:void 0};M.isPrinting=!0,M.pointer.reset(null,0),fireEvent$3(M,"beforePrint");var C=O&&M.chartWidth>O;C&&(L.resetParams=[M.options.chart.width,void 0,!1],M.setSize(O,void 0,!1)),[].forEach.call(L.childNodes,function(U,D){U.nodeType===1&&(L.origDisplay[D]=U.style.display,U.style.display="none")}),M.moveContainers(T),M.printReverseInfo=L}function d(M){var T=M;T.renderExporting(),addEvent$8(M,"redraw",T.renderExporting),addEvent$8(M,"destroy",T.destroyExport)}function p(M,T){if(ExportingSymbols$1.compose(T),r.indexOf(M)===-1){r.push(M);var O=M.prototype;O.afterPrint=h,O.exportChart=g,O.inlineStyles=$,O.print=A,O.sanitizeSVG=E,O.getChartHTML=v,O.getSVG=x,O.getSVGForExport=y,O.getFilename=m,O.moveContainers=S,O.beforePrint=c,O.contextMenu=u,O.addButton=l,O.destroyExport=f,O.renderExporting=P,O.callbacks.push(d),addEvent$8(M,"init",k),H.isSafari&&H.win.matchMedia("print").addListener(function(L){a&&(L.matches?a.beforePrint():a.afterPrint())})}}n.compose=p;function u(M,T,O,L,C,U,D){var N=this,I=N.options.navigation,B=N.chartWidth,X=N.chartHeight,W="cache-"+M,F=Math.max(C,U),_,z=N[W];z||(N.exportContextMenu=N[W]=z=createElement("div",{className:M},{position:"absolute",zIndex:1e3,padding:F+"px",pointerEvents:"auto"},N.fixedDiv||N.container),_=createElement("ul",{className:"highcharts-menu"},{listStyle:"none",margin:0,padding:0},z),N.styledMode||css$1(_,extend$k({MozBoxShadow:"3px 3px 10px #888",WebkitBoxShadow:"3px 3px 10px #888",boxShadow:"3px 3px 10px #888"},I.menuStyle)),z.hideMenu=function(){css$1(z,{display:"none"}),D&&D.setState(0),N.openMenu=!1,css$1(N.renderTo,{overflow:"hidden"}),css$1(N.container,{overflow:"hidden"}),Utilities.clearTimeout(z.hideTimer),fireEvent$3(N,"exportMenuHidden")},N.exportEvents.push(addEvent$8(z,"mouseleave",function(){z.hideTimer=win$1.setTimeout(z.hideMenu,500)}),addEvent$8(z,"mouseenter",function(){Utilities.clearTimeout(z.hideTimer)}),addEvent$8(doc,"mouseup",function(j){N.pointer.inClass(j.target,M)||z.hideMenu()}),addEvent$8(z,"click",function(){N.openMenu&&z.hideMenu()})),T.forEach(function(j){if(typeof j=="string"&&(j=N.options.exporting.menuItemDefinitions[j]),isObject$4(j,!0)){var K=void 0;j.separator?K=createElement("hr",void 0,void 0,_):(j.textKey==="viewData"&&N.isDataTableVisible&&(j.textKey="hideData"),K=createElement("li",{className:"highcharts-menu-item",onclick:function(ot){ot&&ot.stopPropagation(),z.hideMenu(),j.onclick&&j.onclick.apply(N,arguments)}},void 0,_),AST.setElementHTML(K,j.text||N.options.lang[j.textKey]),N.styledMode||(K.onmouseover=function(){css$1(this,I.menuItemHoverStyle)},K.onmouseout=function(){css$1(this,I.menuItemStyle)},css$1(K,extend$k({cursor:"pointer"},I.menuItemStyle)))),N.exportDivElements.push(K)}}),N.exportDivElements.push(_,z),N.exportMenuWidth=z.offsetWidth,N.exportMenuHeight=z.offsetHeight);var V={display:"block"};O+N.exportMenuWidth>B?V.right=B-O-C-F+"px":V.left=O-F+"px",L+U+N.exportMenuHeight>X&&D.alignOptions.verticalAlign!=="top"?V.bottom=X-L-F+"px":V.top=L+U-F+"px",css$1(z,V),css$1(N.renderTo,{overflow:""}),css$1(N.container,{overflow:""}),N.openMenu=!0,fireEvent$3(N,"exportMenuShown")}function f(M){var T=M?M.target:this,O=T.exportSVGElements,L=T.exportDivElements,C=T.exportEvents,U;O&&(O.forEach(function(D,N){D&&(D.onclick=D.ontouchstart=null,U="cache-"+D.menuClassName,T[U]&&delete T[U],O[N]=D.destroy())}),O.length=0),T.exportingGroup&&(T.exportingGroup.destroy(),delete T.exportingGroup),L&&(L.forEach(function(D,N){D&&(Utilities.clearTimeout(D.hideTimer),removeEvent(D,"mouseleave"),L[N]=D.onmouseout=D.onmouseover=D.ontouchstart=D.onclick=null,discardElement(D))}),L.length=0),C&&(C.forEach(function(D){D()}),C.length=0)}function g(M,T){var O=this.getSVGForExport(M,T);M=merge$f(this.options.exporting,M),exports$2.post(M.url,{filename:M.filename?M.filename.replace(/\//g,"-"):this.getFilename(),type:M.type,width:M.width||0,scale:M.scale,svg:O},M.formAttributes)}function v(){return this.styledMode&&this.inlineStyles(),this.container.innerHTML}function m(){var M=this.userOptions.title&&this.userOptions.title.text,T=this.options.exporting.filename;return T?T.replace(/\//g,"-"):(typeof M=="string"&&(T=M.toLowerCase().replace(/<\/?[^>]+(>|$)/g,"").replace(/[\s_]+/g,"-").replace(/[^a-z0-9\-]/g,"").replace(/^[\-]+/g,"").replace(/[\-]+/g,"-").substr(0,24).replace(/[\-]+$/g,"")),(!T||T.length<5)&&(T="chart"),T)}function x(M){var T=this,O,L,C=merge$f(T.options,M);C.plotOptions=merge$f(T.userOptions.plotOptions,M&&M.plotOptions),C.time=merge$f(T.userOptions.time,M&&M.time);var U=createElement("div",null,{position:"absolute",top:"-9999em",width:T.chartWidth+"px",height:T.chartHeight+"px"},doc.body),D=T.renderTo.style.width,N=T.renderTo.style.height,I=C.exporting.sourceWidth||C.chart.width||/px$/.test(D)&&parseInt(D,10)||(C.isGantt?800:600),B=C.exporting.sourceHeight||C.chart.height||/px$/.test(N)&&parseInt(N,10)||400;extend$k(C.chart,{animation:!1,renderTo:U,forExport:!0,renderer:"SVGRenderer",width:I,height:B}),C.exporting.enabled=!1,delete C.data,C.series=[],T.series.forEach(function(F){L=merge$f(F.userOptions,{animation:!1,enableMouseTracking:!1,showCheckbox:!1,visible:F.visible}),L.isInternal||C.series.push(L)});var X={};T.axes.forEach(function(F){F.userOptions.internalKey||(F.userOptions.internalKey=uniqueKey()),F.options.isInternal||(X[F.coll]||(X[F.coll]=!0,C[F.coll]=[]),C[F.coll].push(merge$f(F.userOptions,{visible:F.visible})))});var W=new Chart$1(C,T.callback);return M&&["xAxis","yAxis","series"].forEach(function(F){var _={};M[F]&&(_[F]=M[F],W.update(_))}),T.axes.forEach(function(F){var _=find$3(W.axes,function(K){return K.options.internalKey===F.userOptions.internalKey}),z=F.getExtremes(),V=z.userMin,j=z.userMax;_&&(typeof V<"u"&&V!==_.min||typeof j<"u"&&j!==_.max)&&_.setExtremes(V,j,!0,!1)}),O=W.getChartHTML(),fireEvent$3(this,"getSVG",{chartCopy:W}),O=T.sanitizeSVG(O,C),C=null,W.destroy(),discardElement(U),O}function y(M,T){var O=this.options.exporting;return this.getSVG(merge$f({chart:{borderRadius:0}},O.chartOptions,T,{exporting:{sourceWidth:M&&M.sourceWidth||O.sourceWidth,sourceHeight:M&&M.sourceHeight||O.sourceHeight}}))}function b(M){return M.replace(/([A-Z])/g,function(T,O){return"-"+O.toLowerCase()})}function $(){var M=t,T=n.inlineWhitelist,O={},L,C=doc.createElement("iframe");css$1(C,{width:"1px",height:"1px",visibility:"hidden"}),doc.body.appendChild(C);var U=C.contentWindow.document;U.open(),U.write('<svg xmlns="http://www.w3.org/2000/svg"></svg>'),U.close();function D(I){var B,X,W="",F,_,z,V,j;function K(q,J){if(z=V=!1,T.length){for(j=T.length;j--&&!V;)V=T[j].test(J);z=!V}for(J==="transform"&&q==="none"&&(z=!0),j=M.length;j--&&!z;)z=M[j].test(J)||typeof q=="function";z||(X[J]!==q||I.nodeName==="svg")&&O[I.nodeName][J]!==q&&(!o||o.indexOf(J)!==-1?q&&I.setAttribute(b(J),q):W+=b(J)+":"+q+";")}if(I.nodeType===1&&s.indexOf(I.nodeName)===-1){if(B=win$1.getComputedStyle(I,null),X=I.nodeName==="svg"?{}:win$1.getComputedStyle(I.parentNode,null),O[I.nodeName]||(L=U.getElementsByTagName("svg")[0],F=U.createElementNS(I.namespaceURI,I.nodeName),L.appendChild(F),O[I.nodeName]=merge$f(win$1.getComputedStyle(F,null)),I.nodeName==="text"&&delete O.text.fill,L.removeChild(F)),H.isFirefox||H.isMS)for(var ot in B)K(B[ot],ot);else objectEach$2(B,K);if(W&&(_=I.getAttribute("style"),I.setAttribute("style",(_?_+";":"")+W)),I.nodeName==="svg"&&I.setAttribute("stroke-width","1px"),I.nodeName==="text")return;[].forEach.call(I.children||I.childNodes,D)}}function N(){L.parentNode.removeChild(L),C.parentNode.removeChild(C)}D(this.container.querySelector("svg")),N()}function S(M){var T=this;(T.fixedDiv?[T.fixedDiv,T.scrollingContainer]:[T.container]).forEach(function(O){M.appendChild(O)})}function k(){var M=this,T=function(O,L,C){M.isDirtyExporting=!0,merge$f(!0,M.options[O],L),pick$h(C,!0)&&M.redraw()};M.exporting={update:function(O,L){T("exporting",O,L)}},chartNavigation.addUpdate(function(O,L){T("navigation",O,L)},M)}function A(){var M=this;M.isPrinting||(a=M,H.isSafari||M.beforePrint(),setTimeout(function(){win$1.focus(),win$1.print(),H.isSafari||setTimeout(function(){M.afterPrint()},1e3)},1))}function P(){var M=this,T=M.options.exporting,O=T.buttons,L=M.isDirtyExporting||!M.exportSVGElements;M.buttonOffset=0,M.isDirtyExporting&&M.destroyExport(),L&&T.enabled!==!1&&(M.exportEvents=[],M.exportingGroup=M.exportingGroup||M.renderer.g("exporting-group").attr({zIndex:3}).add(),objectEach$2(O,function(C){M.addButton(C)}),M.isDirtyExporting=!1)}function E(M,T){var O=M.indexOf("</svg>")+6,L=M.substr(O);return M=M.substr(0,O),T&&T.exporting&&T.exporting.allowHTML&&L&&(L='<foreignObject x="0" y="0" width="'+T.chart.width+'" height="'+T.chart.height+'"><body xmlns="http://www.w3.org/1999/xhtml">'+L.replace(/(<(?:img|br).*?(?=\>))>/g,"$1 />")+"</body></foreignObject>",M=M.replace("</svg>",L+"</svg>")),M=M.replace(/zIndex="[^"]+"/g,"").replace(/symbolName="[^"]+"/g,"").replace(/jQuery[0-9]+="[^"]+"/g,"").replace(/url\(("|&quot;)(.*?)("|&quot;)\;?\)/g,"url($2)").replace(/url\([^#]+#/g,"url(#").replace(/<svg /,'<svg xmlns:xlink="http://www.w3.org/1999/xlink" ').replace(/ (|NS[0-9]+\:)href=/g," xlink:href=").replace(/\n/," ").replace(/(fill|stroke)="rgba\(([ 0-9]+,[ 0-9]+,[ 0-9]+),([ 0-9\.]+)\)"/g,'$1="rgb($2)" $1-opacity="$3"').replace(/&nbsp;/g," ").replace(/&shy;/g,"­"),this.ieSanitizeSVG&&(M=this.ieSanitizeSVG(M)),M}})(Exporting||(Exporting={}));defaultOptions$1.exporting=merge$f(ExportingDefaults.exporting,defaultOptions$1.exporting);defaultOptions$1.lang=merge$f(ExportingDefaults.lang,defaultOptions$1.lang);defaultOptions$1.navigation=merge$f(ExportingDefaults.navigation,defaultOptions$1.navigation);const Exporting$1=Exporting;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/exporting
 * @requires highcharts
 *
 * Exporting module
 *
 * (c) 2010-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$1=H;G$1.HttpUtilities=exports$2;G$1.ajax=exports$2.ajax;G$1.getJSON=exports$2.getJSON;G$1.post=exports$2.post;Exporting$1.compose(G$1.Chart,G$1.Renderer);var __extends$h=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),noop$3=H.noop,Series$7=SeriesRegistry$1.series,PieSeries=SeriesRegistry$1.seriesTypes.pie,addEvent$7=Utilities.addEvent,extend$j=Utilities.extend,fireEvent$2=Utilities.fireEvent,isArray$2=Utilities.isArray,merge$e=Utilities.merge,pick$g=Utilities.pick,FunnelSeries=function(n){__extends$h(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.alignDataLabel=function(t,o,s,a,l){var h=t.series,c=h.options.reversed,d=t.dlBox||t.shapeArgs,p=s.align,u=s.verticalAlign,f=((h.options||{}).dataLabels||{}).inside,g=h.center[1],v=c?2*g-t.plotY:t.plotY,m=h.getWidthAt(v-d.height/2+o.height),x=u==="middle"?(d.topWidth-d.bottomWidth)/4:(m-d.bottomWidth)/2,y=d.y,b=d.x;u==="middle"?y=d.y-d.height/2+o.height/2:u==="top"&&(y=d.y-d.height+o.height+s.padding),(u==="top"&&!c||u==="bottom"&&c||u==="middle")&&(p==="right"?b=d.x-s.padding+x:p==="left"&&(b=d.x+s.padding-x)),a={x:b,y:c?y-d.height:y,width:d.bottomWidth,height:d.height},s.verticalAlign="bottom",(!f||t.visible)&&Series$7.prototype.alignDataLabel.call(this,t,o,s,a,l),f&&(!t.visible&&t.dataLabel&&(t.dataLabel.placed=!1),t.contrastColor&&o.css({color:t.contrastColor}))},r.prototype.drawDataLabels=function(){var t=this,o=t.data,s=t.options.dataLabels.distance,a,l,h,c=o.length,d,p;for(t.center[2]-=2*s;c--;)h=o[c],a=h.half,l=a?1:-1,p=h.plotY,h.labelDistance=pick$g(h.options.dataLabels&&h.options.dataLabels.distance,s),t.maxLabelDistance=Math.max(h.labelDistance,t.maxLabelDistance||0),d=t.getX(p,a,h),h.labelPosition={natural:{x:0,y:p},final:{},alignment:a?"right":"left",connectorPosition:{breakAt:{x:d+(h.labelDistance-5)*l,y:p},touchingSliceAt:{x:d+h.labelDistance*l,y:p}}};SeriesRegistry$1.seriesTypes[t.options.dataLabels.inside?"column":"pie"].prototype.drawDataLabels.call(this)},r.prototype.translate=function(){var t=0,o=this,s=o.chart,a=o.options,l=a.reversed,h=a.ignoreHiddenPoint,c=s.plotWidth,d=s.plotHeight,p=0,u=a.center,f=D(u[0],c),g=D(u[1],d),v=D(a.width,c),m,x=D(a.height,d),y=D(a.neckWidth,c),b=D(a.neckHeight,d),$=g-x/2+x-b,S=o.data,k,A,P=a.dataLabels.position==="left"?1:0,E,M,T,O,L,C,U;function D(N,I){return/%$/.test(N)?I*parseInt(N,10)/100:parseInt(N,10)}o.getWidthAt=function(N){var I=g-x/2;return N>$||x===b?y:y+(v-y)*(1-(N-I)/(x-b))},o.getX=function(N,I,B){return f+(I?-1:1)*(o.getWidthAt(l?2*g-N:N)/2+B.labelDistance)},o.center=[f,g,x],o.centerX=f,S.forEach(function(N){(!h||N.visible!==!1)&&(t+=N.y)}),S.forEach(function(N){U=null,A=t?N.y/t:0,M=g-x/2+p*x,L=M+A*x,m=o.getWidthAt(M),E=f-m/2,T=E+m,m=o.getWidthAt(L),O=f-m/2,C=O+m,M>$?(E=O=f-y/2,T=C=f+y/2):L>$&&(U=L,m=o.getWidthAt($),O=f-m/2,C=O+m,L=$),l&&(M=2*g-M,L=2*g-L,U!==null&&(U=2*g-U)),k=[["M",E,M],["L",T,M],["L",C,L]],U!==null&&k.push(["L",C,U],["L",O,U]),k.push(["L",O,L],["Z"]),N.shapeType="path",N.shapeArgs={d:k},N.percentage=A*100,N.plotX=f,N.plotY=(M+(U||L))/2,N.tooltipPos=[f,N.plotY],N.dlBox={x:O,y:M,topWidth:T-E,bottomWidth:C-O,height:Math.abs(pick$g(U,L)-M),width:NaN},N.slice=noop$3,N.half=P,(!h||N.visible!==!1)&&(p+=A)}),fireEvent$2(o,"afterTranslate")},r.prototype.sortByAngle=function(t){t.sort(function(o,s){return o.plotY-s.plotY})},r.defaultOptions=merge$e(PieSeries.defaultOptions,{animation:!1,center:["50%","50%"],width:"90%",neckWidth:"30%",height:"100%",neckHeight:"25%",reversed:!1,size:!0,dataLabels:{connectorWidth:1,verticalAlign:"middle"},states:{select:{color:palette.neutralColor20,borderColor:palette.neutralColor100}}}),r}(PieSeries);extend$j(FunnelSeries.prototype,{animate:noop$3});addEvent$7(Chart$1,"afterHideAllOverlappingLabels",function(){this.series.forEach(function(n){var r=n.options&&n.options.dataLabels;isArray$2(r)&&(r=r[0]),n.is("pie")&&n.placeDataLabels&&r&&!r.inside&&n.placeDataLabels()})});SeriesRegistry$1.registerSeriesType("funnel",FunnelSeries);var __extends$g=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),merge$d=Utilities.merge,PyramidSeries=function(n){__extends$g(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.defaultOptions=merge$d(FunnelSeries.defaultOptions,{neckWidth:"0%",neckHeight:"0%",reversed:!0}),r}(FunnelSeries);SeriesRegistry$1.registerSeriesType("pyramid",PyramidSeries);var colorPointMixin$1={setVisible:function(n){var r=this,t=n?"show":"hide";r.visible=r.options.visible=!!n,["graphic","dataLabel"].forEach(function(o){r[o]&&r[o][t]()}),this.series.buildKDTree()}},colorSeriesMixin$1={optionalAxis:"colorAxis",translateColors:function(){var n=this,r=this.data.length?this.data:this.points,t=this.options.nullColor,o=this.colorAxis,s=this.colorKey;r.forEach(function(a){var l=a.getNestedProperty(s),h;h=a.options.color||(a.isNull||a.value===null?t:o&&typeof l<"u"?o.toColor(l,a):a.color||n.color),h&&a.color!==h&&(a.color=h,n.options.legendType==="point"&&a.legendItem&&n.chart.legend.colorizeItem(a,a.visible))})}},exports$1={colorPointMixin:colorPointMixin$1,colorSeriesMixin:colorSeriesMixin$1},color$4=Color.parse,colorPointMixin=exports$1.colorPointMixin,colorSeriesMixin=exports$1.colorSeriesMixin,addEvent$6=Utilities.addEvent,extend$i=Utilities.extend,merge$c=Utilities.merge,pick$f=Utilities.pick,splat=Utilities.splat,ColorAxisComposition;(function(n){var r=[],t;function o(g,v,m,x,y){if(t||(t=g),r.indexOf(v)===-1){r.push(v);var b=v.prototype;b.collectionsWithUpdate.push("colorAxis"),b.collectionsWithInit.colorAxis=[b.addColorAxis],addEvent$6(v,"afterGetAxes",s),p(v)}if(r.indexOf(m)===-1){r.push(m);var $=m.prototype;$.fillSetter=u,$.strokeSetter=f}r.indexOf(x)===-1&&(r.push(x),addEvent$6(x,"afterGetAllItems",a),addEvent$6(x,"afterColorizeItem",l),addEvent$6(x,"afterUpdate",h)),r.indexOf(y)===-1&&(r.push(y),extend$i(y.prototype,colorSeriesMixin),extend$i(y.prototype.pointClass.prototype,colorPointMixin),addEvent$6(y,"afterTranslate",c),addEvent$6(y,"bindAxes",d))}n.compose=o;function s(){var g=this,v=this.options;this.colorAxis=[],v.colorAxis&&(v.colorAxis=splat(v.colorAxis),v.colorAxis.forEach(function(m,x){m.index=x,new t(g,m)}))}function a(g){var v=this,m=this.chart.colorAxis||[],x=function(S){var k=g.allItems.indexOf(S);k!==-1&&(v.destroyItem(g.allItems[k]),g.allItems.splice(k,1))},y=[],b,$;for(m.forEach(function(S){b=S.options,b&&b.showInLegend&&(b.dataClasses&&b.visible?y=y.concat(S.getDataClassLegendSymbols()):b.visible&&y.push(S),S.series.forEach(function(k){(!k.options.showInLegend||b.dataClasses)&&(k.options.legendType==="point"?k.points.forEach(function(A){x(A)}):x(k))}))}),$=y.length;$--;)g.allItems.unshift(y[$])}function l(g){g.visible&&g.item.legendColor&&g.item.legendSymbol.attr({fill:g.item.legendColor})}function h(){var g=this.chart.colorAxis;g&&g.forEach(function(v){v.update({},arguments[2])})}function c(){(this.chart.colorAxis&&this.chart.colorAxis.length||this.colorAttribs)&&this.translateColors()}function d(){var g=this.axisTypes;g?g.indexOf("colorAxis")===-1&&g.push("colorAxis"):this.axisTypes=["colorAxis"]}function p(g){var v=g.prototype.createAxis;g.prototype.createAxis=function(m,x){if(m!=="colorAxis")return v.apply(this,arguments);var y=new t(this,merge$c(x.axis,{index:this[m].length,isX:!1}));return this.isDirtyLegend=!0,this.axes.forEach(function(b){b.series=[]}),this.series.forEach(function(b){b.bindAxes(),b.isDirtyData=!0}),pick$f(x.redraw,!0)&&this.redraw(x.animation),y}}function u(){this.elem.attr("fill",color$4(this.start).tweenTo(color$4(this.end),this.pos),void 0,!0)}function f(){this.elem.attr("stroke",color$4(this.start).tweenTo(color$4(this.end),this.pos),void 0,!0)}})(ColorAxisComposition||(ColorAxisComposition={}));const ColorAxisComposition$1=ColorAxisComposition;var colorAxisDefaults={lineWidth:0,minPadding:0,maxPadding:0,gridLineWidth:1,tickPixelInterval:72,startOnTick:!0,endOnTick:!0,offset:0,marker:{animation:{duration:50},width:.01,color:palette.neutralColor40},labels:{overflow:"justify",rotation:0},minColor:palette.highlightColor10,maxColor:palette.highlightColor100,tickLength:5,showInLegend:!0},__extends$f=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),color$3=Color.parse,noop$2=H.noop,Series$6=SeriesRegistry$1.series,extend$h=Utilities.extend,isNumber$7=Utilities.isNumber,merge$b=Utilities.merge,pick$e=Utilities.pick,ColorAxis=function(n){__extends$f(r,n);function r(t,o){var s=n.call(this,t,o)||this;return s.beforePadding=!1,s.chart=void 0,s.coll="colorAxis",s.dataClasses=void 0,s.legendItem=void 0,s.legendItems=void 0,s.name="",s.options=void 0,s.stops=void 0,s.visible=!0,s.init(t,o),s}return r.compose=function(t,o,s,a){ColorAxisComposition$1.compose(r,t,o,s,a)},r.prototype.init=function(t,o){var s=this,a=t.options.legend||{},l=o.layout?o.layout!=="vertical":a.layout!=="vertical",h=o.visible,c=merge$b(r.defaultColorAxisOptions,o,{showEmpty:!1,title:null,visible:a.enabled&&h!==!1});s.coll="colorAxis",s.side=o.side||l?2:1,s.reversed=o.reversed||!l,s.opposite=!l,n.prototype.init.call(this,t,c),s.userOptions.visible=h,o.dataClasses&&s.initDataClasses(o),s.initStops(),s.horiz=l,s.zoomEnabled=!1},r.prototype.initDataClasses=function(t){var o=this,s=o.chart,a=o.options,l=t.dataClasses.length,h,c=0,d=s.options.chart.colorCount;o.dataClasses=h=[],o.legendItems=[],(t.dataClasses||[]).forEach(function(p,u){var f;p=merge$b(p),h.push(p),!(!s.styledMode&&p.color)&&(a.dataClassColor==="category"?(s.styledMode||(f=s.options.colors,d=f.length,p.color=f[c]),p.colorIndex=c,c++,c===d&&(c=0)):p.color=color$3(a.minColor).tweenTo(color$3(a.maxColor),l<2?.5:u/(l-1)))})},r.prototype.hasData=function(){return!!(this.tickPositions||[]).length},r.prototype.setTickPositions=function(){if(!this.dataClasses)return n.prototype.setTickPositions.call(this)},r.prototype.initStops=function(){var t=this;t.stops=t.options.stops||[[0,t.options.minColor],[1,t.options.maxColor]],t.stops.forEach(function(o){o.color=color$3(o[1])})},r.prototype.setOptions=function(t){var o=this;n.prototype.setOptions.call(this,t),o.options.crosshair=o.options.marker},r.prototype.setAxisSize=function(){var t=this,o=t.legendSymbol,s=t.chart,a=s.options.legend||{},l,h,c,d;o?(this.left=l=o.attr("x"),this.top=h=o.attr("y"),this.width=c=o.attr("width"),this.height=d=o.attr("height"),this.right=s.chartWidth-l-c,this.bottom=s.chartHeight-h-d,this.len=this.horiz?c:d,this.pos=this.horiz?l:h):this.len=(this.horiz?a.symbolWidth:a.symbolHeight)||r.defaultLegendLength},r.prototype.normalizedValue=function(t){var o=this;return o.logarithmic&&(t=o.logarithmic.log2lin(t)),1-(o.max-t)/(o.max-o.min||1)},r.prototype.toColor=function(t,o){var s=this,a=s.dataClasses,l=s.stops,h,c,d,p,u,f;if(a){for(f=a.length;f--;)if(u=a[f],c=u.from,d=u.to,(typeof c>"u"||t>=c)&&(typeof d>"u"||t<=d)){p=u.color,o&&(o.dataClass=f,o.colorIndex=u.colorIndex);break}}else{for(h=s.normalizedValue(t),f=l.length;f--&&!(h>l[f][0]););c=l[f]||l[f+1],d=l[f+1]||c,h=1-(d[0]-h)/(d[0]-c[0]||1),p=c.color.tweenTo(d.color,h)}return p},r.prototype.getOffset=function(){var t=this,o=t.legendGroup,s=t.chart.axisOffset[t.side];o&&(t.axisParent=o,n.prototype.getOffset.call(this),t.added||(t.added=!0,t.labelLeft=0,t.labelRight=t.width),t.chart.axisOffset[t.side]=s)},r.prototype.setLegendColor=function(){var t=this,o=t.horiz,s=t.reversed,a=s?1:0,l=s?0:1,h=o?[a,0,l,0]:[0,l,0,a];t.legendColor={linearGradient:{x1:h[0],y1:h[1],x2:h[2],y2:h[3]},stops:t.stops}},r.prototype.drawLegendSymbol=function(t,o){var s=this,a=t.padding,l=t.options,h=s.horiz,c=pick$e(l.symbolWidth,h?r.defaultLegendLength:12),d=pick$e(l.symbolHeight,h?12:r.defaultLegendLength),p=pick$e(l.labelPadding,h?16:30),u=pick$e(l.itemDistance,10);this.setLegendColor(),o.legendSymbol=this.chart.renderer.rect(0,t.baseline-11,c,d).attr({zIndex:1}).add(o.legendGroup),s.legendItemWidth=c+a+(h?u:p),s.legendItemHeight=d+a+(h?p:0)},r.prototype.setState=function(t){this.series.forEach(function(o){o.setState(t)})},r.prototype.setVisible=function(){},r.prototype.getSeriesExtremes=function(){var t=this,o=t.series,s,a,l,h,c,d,p=o.length,u,f;for(this.dataMin=1/0,this.dataMax=-1/0;p--;){if(d=o[p],a=d.colorKey=pick$e(d.options.colorKey,d.colorKey,d.pointValKey,d.zoneAxis,"y"),h=d.pointArrayMap,c=d[a+"Min"]&&d[a+"Max"],d[a+"Data"])s=d[a+"Data"];else if(!h)s=d.yData;else if(s=[],l=h.indexOf(a),u=d.yData,l>=0&&u)for(f=0;f<u.length;f++)s.push(pick$e(u[f][l],u[f]));if(c)d.minColorValue=d[a+"Min"],d.maxColorValue=d[a+"Max"];else{var g=Series$6.prototype.getExtremes.call(d,s);d.minColorValue=g.dataMin,d.maxColorValue=g.dataMax}typeof d.minColorValue<"u"&&(this.dataMin=Math.min(this.dataMin,d.minColorValue),this.dataMax=Math.max(this.dataMax,d.maxColorValue)),c||Series$6.prototype.applyExtremes.call(d)}},r.prototype.drawCrosshair=function(t,o){var s=this,a=o&&o.plotX,l=o&&o.plotY,h=s.pos,c=s.len,d;o&&(d=s.toPixels(o.getNestedProperty(o.series.colorKey)),d<h?d=h-2:d>h+c&&(d=h+c+2),o.plotX=d,o.plotY=s.len-d,n.prototype.drawCrosshair.call(this,t,o),o.plotX=a,o.plotY=l,s.cross&&!s.cross.addedToColorAxis&&s.legendGroup&&(s.cross.addClass("highcharts-coloraxis-marker").add(s.legendGroup),s.cross.addedToColorAxis=!0,!s.chart.styledMode&&typeof s.crosshair=="object"&&s.cross.attr({fill:s.crosshair.color})))},r.prototype.getPlotLinePath=function(t){var o=this,s=o.left,a=t.translatedValue,l=o.top;return isNumber$7(a)?o.horiz?[["M",a-4,l-6],["L",a+4,l-6],["L",a,l],["Z"]]:[["M",s,a],["L",s-6,a+6],["L",s-6,a-6],["Z"]]:n.prototype.getPlotLinePath.call(this,t)},r.prototype.update=function(t,o){var s=this,a=s.chart,l=a.legend;this.series.forEach(function(h){h.isDirtyData=!0}),(t.dataClasses&&l.allItems||s.dataClasses)&&s.destroyItems(),n.prototype.update.call(this,t,o),s.legendItem&&(s.setLegendColor(),l.colorizeItem(this,!0))},r.prototype.destroyItems=function(){var t=this,o=t.chart;t.legendItem?o.legend.destroyItem(t):t.legendItems&&t.legendItems.forEach(function(s){o.legend.destroyItem(s)}),o.isDirtyLegend=!0},r.prototype.destroy=function(){this.chart.isDirtyLegend=!0,this.destroyItems(),n.prototype.destroy.apply(this,[].slice.call(arguments))},r.prototype.remove=function(t){this.destroyItems(),n.prototype.remove.call(this,t)},r.prototype.getDataClassLegendSymbols=function(){var t=this,o=t.chart,s=t.legendItems,a=o.options.legend,l=a.valueDecimals,h=a.valueSuffix||"",c;return s.length||t.dataClasses.forEach(function(d,p){var u=d.from,f=d.to,g=o.numberFormatter,v=!0;c="",typeof u>"u"?c="< ":typeof f>"u"&&(c="> "),typeof u<"u"&&(c+=g(u,l)+h),typeof u<"u"&&typeof f<"u"&&(c+=" - "),typeof f<"u"&&(c+=g(f,l)+h),s.push(extend$h({chart:o,name:c,options:{},drawLegendSymbol:LegendSymbol$1.drawRectangle,visible:!0,setState:noop$2,isDataClass:!0,setVisible:function(){v=t.visible=!v,t.series.forEach(function(m){m.points.forEach(function(x){x.dataClass===p&&x.setVisible(v)})}),o.legend.colorizeItem(this,v)}},d))}),s},r.defaultColorAxisOptions=colorAxisDefaults,r.defaultLegendLength=200,r.keepProps=["legendGroup","legendItemHeight","legendItemWidth","legendItem","legendSymbol"],r}(Axis);Array.prototype.push.apply(Axis.keepProps,ColorAxis.keepProps);var defined$7=Utilities.defined,addEvent$5=Utilities.addEvent,noop$1=H.noop,seriesTypes=H.seriesTypes;addEvent$5(Point$2,"afterSetState",function(n){var r=this;r.moveToTopOnHover&&r.graphic&&r.graphic.attr({zIndex:n&&n.state==="hover"?1:0})});var colorMapPointMixin$1={dataLabelOnNull:!0,moveToTopOnHover:!0,isValid:function(){return this.value!==null&&this.value!==1/0&&this.value!==-1/0}},colorMapSeriesMixin$2={pointArrayMap:["value"],axisTypes:["xAxis","yAxis","colorAxis"],trackerGroups:["group","markerGroup","dataLabelsGroup"],getSymbol:noop$1,parallelArrays:["x","y","value"],colorKey:"value",pointAttribs:seriesTypes.column.prototype.pointAttribs,colorAttribs:function(n){var r={};return defined$7(n.color)&&(!n.state||n.state==="normal")&&(r[this.colorProp||"fill"]=n.color),r}},exports={colorMapPointMixin:colorMapPointMixin$1,colorMapSeriesMixin:colorMapSeriesMixin$2},__extends$e=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),colorMapPointMixin=exports.colorMapPointMixin,ScatterPoint$1=SeriesRegistry$1.seriesTypes.scatter.prototype.pointClass,clamp$2=Utilities.clamp,extend$g=Utilities.extend,pick$d=Utilities.pick,HeatmapPoint=function(n){__extends$e(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t.value=void 0,t.x=void 0,t.y=void 0,t}return r.prototype.applyOptions=function(t,o){var s=n.prototype.applyOptions.call(this,t,o);return s.formatPrefix=s.isNull||s.value===null?"null":"point",s},r.prototype.getCellAttributes=function(){var t=this,o=t.series,s=o.options,a=(s.colsize||1)/2,l=(s.rowsize||1)/2,h=o.xAxis,c=o.yAxis,d=t.options.marker||o.options.marker,p=o.pointPlacementToXValue(),u=pick$d(t.pointPadding,s.pointPadding,0),f={x1:clamp$2(Math.round(h.len-(h.translate(t.x-a,!1,!0,!1,!0,-p)||0)),-h.len,2*h.len),x2:clamp$2(Math.round(h.len-(h.translate(t.x+a,!1,!0,!1,!0,-p)||0)),-h.len,2*h.len),y1:clamp$2(Math.round(c.translate(t.y-l,!1,!0,!1,!0)||0),-c.len,2*c.len),y2:clamp$2(Math.round(c.translate(t.y+l,!1,!0,!1,!0)||0),-c.len,2*c.len)};return[["width","x"],["height","y"]].forEach(function(g){var v=g[0],m=g[1],x=m+"1",y=m+"2",b=Math.abs(f[x]-f[y]),$=d&&d.lineWidth||0,S=Math.abs(f[x]+f[y])/2;d[v]&&d[v]<b&&(f[x]=S-d[v]/2-$/2,f[y]=S+d[v]/2+$/2),u&&(m==="y"&&(x=y,y=m+"1"),f[x]+=u,f[y]-=u)}),f},r.prototype.haloPath=function(t){if(!t)return[];var o=this.shapeArgs;return["M",o.x-t,o.y-t,"L",o.x-t,o.y+o.height+t,o.x+o.width+t,o.y+o.height+t,o.x+o.width+t,o.y-t,"Z"]},r.prototype.isValid=function(){return this.value!==1/0&&this.value!==-1/0},r}(ScatterPoint$1);extend$g(HeatmapPoint.prototype,{dataLabelOnNull:colorMapPointMixin.dataLabelOnNull,moveToTopOnHover:colorMapPointMixin.moveToTopOnHover});var __extends$d=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),colorMapSeriesMixin$1=exports.colorMapSeriesMixin,Series$5=SeriesRegistry$1.series,_a$5=SeriesRegistry$1.seriesTypes,ColumnSeries$7=_a$5.column,ScatterSeries$1=_a$5.scatter,symbols$1=SVGRenderer.prototype.symbols,extend$f=Utilities.extend,fireEvent$1=Utilities.fireEvent,isNumber$6=Utilities.isNumber,merge$a=Utilities.merge,pick$c=Utilities.pick,HeatmapSeries$1=function(n){__extends$d(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.colorAxis=void 0,t.data=void 0,t.options=void 0,t.points=void 0,t.valueMax=NaN,t.valueMin=NaN,t}return r.prototype.drawPoints=function(){var t=this,o=this.options.marker||{};(o.enabled||this._hasPointMarkers)&&(Series$5.prototype.drawPoints.call(this),this.points.forEach(function(s){s.graphic&&(s.graphic[t.chart.styledMode?"css":"animate"](t.colorAttribs(s)),t.options.borderRadius&&s.graphic.attr({r:t.options.borderRadius}),s.value===null&&s.graphic.addClass("highcharts-null-point"))}))},r.prototype.getExtremes=function(){var t=Series$5.prototype.getExtremes.call(this,this.valueData),o=t.dataMin,s=t.dataMax;return isNumber$6(o)&&(this.valueMin=o),isNumber$6(s)&&(this.valueMax=s),Series$5.prototype.getExtremes.call(this)},r.prototype.getValidPoints=function(t,o){return Series$5.prototype.getValidPoints.call(this,t,o,!0)},r.prototype.hasData=function(){return!!this.processedXData.length},r.prototype.init=function(){var t;Series$5.prototype.init.apply(this,arguments),t=this.options,t.pointRange=pick$c(t.pointRange,t.colsize||1),this.yAxis.axisPointRange=t.rowsize||1,symbols$1.ellipse=symbols$1.circle},r.prototype.markerAttribs=function(t,o){var s=t.marker||{},a=this.options.marker||{},l,h,c=t.shapeArgs||{},d=t.hasImage,p={};return d?{x:t.plotX,y:t.plotY}:(o&&(l=a.states[o]||{},h=s.states&&s.states[o]||{},[["width","x"],["height","y"]].forEach(function(u){p[u[0]]=(h[u[0]]||l[u[0]]||c[u[0]])+(h[u[0]+"Plus"]||l[u[0]+"Plus"]||0),p[u[1]]=c[u[1]]+(c[u[0]]-p[u[0]])/2})),o?p:c)},r.prototype.pointAttribs=function(t,o){var s=this,a=Series$5.prototype.pointAttribs.call(s,t,o),l=s.options||{},h=s.chart.options.plotOptions||{},c=h.series||{},d=h.heatmap||{},p,u,f=t&&t.options.borderColor||l.borderColor||d.borderColor||c.borderColor,g=t&&t.options.borderWidth||l.borderWidth||d.borderWidth||c.borderWidth||a["stroke-width"];return a.stroke=t&&t.marker&&t.marker.lineColor||l.marker&&l.marker.lineColor||f||this.color,a["stroke-width"]=g,o&&(p=merge$a(l.states[o],l.marker&&l.marker.states[o],t&&t.options.states&&t.options.states[o]||{}),u=p.brightness,a.fill=p.color||Color.parse(a.fill).brighten(u||0).get(),a.stroke=p.lineColor),a},r.prototype.setClip=function(t){var o=this,s=o.chart;Series$5.prototype.setClip.apply(o,arguments),(o.options.clip!==!1||t)&&o.markerGroup.clip((t||o.clipBox)&&o.sharedClipKey?s.sharedClips[o.sharedClipKey]:s.clipRect)},r.prototype.translate=function(){var t=this,o=t.options,s=o.marker&&o.marker.symbol||"rect",a=symbols$1[s]?s:"rect",l=["circle","square"].indexOf(a)!==-1;t.generatePoints(),t.points.forEach(function(h){var c,d,p,u=h.getCellAttributes(),f={};f.x=Math.min(u.x1,u.x2),f.y=Math.min(u.y1,u.y2),f.width=Math.max(Math.abs(u.x2-u.x1),0),f.height=Math.max(Math.abs(u.y2-u.y1),0),p=h.hasImage=(h.marker&&h.marker.symbol||s||"").indexOf("url")===0,l&&(d=Math.abs(f.width-f.height),f.x=Math.min(u.x1,u.x2)+(f.width<f.height?0:d/2),f.y=Math.min(u.y1,u.y2)+(f.width<f.height?d/2:0),f.width=f.height=Math.min(f.width,f.height)),c={plotX:(u.x1+u.x2)/2,plotY:(u.y1+u.y2)/2,clientX:(u.x1+u.x2)/2,shapeType:"path",shapeArgs:merge$a(!0,f,{d:symbols$1[a](f.x,f.y,f.width,f.height)})},p&&(h.marker={width:f.width,height:f.height}),extend$f(h,c)}),fireEvent$1(t,"afterTranslate")},r.defaultOptions=merge$a(ScatterSeries$1.defaultOptions,{animation:!1,borderRadius:0,borderWidth:0,nullColor:palette.neutralColor3,dataLabels:{formatter:function(){var t=this.series.chart.numberFormatter,o=this.point.value;return isNumber$6(o)?t(o,-1):""},inside:!0,verticalAlign:"middle",crop:!1,overflow:!1,padding:0},marker:{symbol:"rect",radius:0,lineColor:void 0,states:{hover:{lineWidthPlus:0},select:{}}},clip:!0,pointRange:null,tooltip:{pointFormat:"{point.x}, {point.y}: {point.value}<br/>"},states:{hover:{halo:!1,brightness:.2}}}),r}(ScatterSeries$1);extend$f(HeatmapSeries$1.prototype,{alignDataLabel:ColumnSeries$7.prototype.alignDataLabel,axisTypes:colorMapSeriesMixin$1.axisTypes,colorAttribs:colorMapSeriesMixin$1.colorAttribs,colorKey:colorMapSeriesMixin$1.colorKey,directTouch:!0,drawLegendSymbol:LegendSymbol$1.drawRectangle,getExtremesFromAll:!0,getSymbol:Series$5.prototype.getSymbol,parallelArrays:colorMapSeriesMixin$1.parallelArrays,pointArrayMap:["y","value"],pointClass:HeatmapPoint,trackerGroups:colorMapSeriesMixin$1.trackerGroups});SeriesRegistry$1.registerSeriesType("heatmap",HeatmapSeries$1);/**
 * @license Highmaps JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/heatmap
 * @requires highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G=H;G.ColorAxis=ColorAxis;ColorAxis.compose(G.Chart,G.Fx,G.Legend,G.Series);var color$2=Color.parse,extend$e=Utilities.extend,merge$9=Utilities.merge,SolidGaugeAxis;(function(n){var r={initDataClasses:function(o){var s=this.chart,a,l=0,h=this.options;this.dataClasses=a=[],o.dataClasses.forEach(function(c,d){var p;c=merge$9(c),a.push(c),c.color||(h.dataClassColor==="category"?(p=s.options.colors,c.color=p[l++],l===p.length&&(l=0)):c.color=color$2(h.minColor).tweenTo(color$2(h.maxColor),d/(o.dataClasses.length-1)))})},initStops:function(o){this.stops=o.stops||[[0,this.options.minColor],[1,this.options.maxColor]],this.stops.forEach(function(s){s.color=color$2(s[1])})},toColor:function(o,s){var a,l=this.stops,h,c,d,p=this.dataClasses,u,f;if(p){for(f=p.length;f--;)if(u=p[f],h=u.from,c=u.to,(typeof h>"u"||o>=h)&&(typeof c>"u"||o<=c)){d=u.color,s&&(s.dataClass=f);break}}else{for(this.logarithmic&&(o=this.val2lin(o)),a=1-(this.max-o)/(this.max-this.min),f=l.length;f--&&!(a>l[f][0]););h=l[f]||l[f+1],c=l[f+1]||h,a=1-(c[0]-a)/(c[0]-h[0]||1),d=h.color.tweenTo(c.color,a)}return d}};function t(o){extend$e(o,r)}n.init=t})(SolidGaugeAxis||(SolidGaugeAxis={}));const SolidGaugeAxis$1=SolidGaugeAxis;var _a$4=SVGRenderer.prototype,symbols=_a$4.symbols,arc=_a$4.symbols.arc;symbols.arc=function(n,r,t,o,s){var a=arc(n,r,t,o,s);if(s&&s.rounded){var l=s.r||t,h=(l-(s.innerR||0))/2,c=a[0],d=a[2];if(c[0]==="M"&&d[0]==="L"){var p=c[1],u=c[2],f=d[1],g=d[2],v=["A",h,h,0,1,1,p,u],m=["A",h,h,0,1,1,f,g];a[2]=m,a[4]=v}}return a};var __extends$c=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),_a$3=SeriesRegistry$1.seriesTypes,GaugeSeries=_a$3.gauge,pieProto=_a$3.pie.prototype,clamp$1=Utilities.clamp,extend$d=Utilities.extend,isNumber$5=Utilities.isNumber,merge$8=Utilities.merge,pick$b=Utilities.pick,pInt=Utilities.pInt,solidGaugeOptions={colorByPoint:!0,dataLabels:{y:0}},SolidGaugeSeries=function(n){__extends$c(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.points=void 0,t.options=void 0,t.axis=void 0,t.yAxis=void 0,t.startAngleRad=void 0,t.thresholdAngleRad=void 0,t}return r.prototype.translate=function(){var t=this.yAxis;SolidGaugeAxis$1.init(t),!t.dataClasses&&t.options.dataClasses&&t.initDataClasses(t.options),t.initStops(t.options),GaugeSeries.prototype.translate.call(this)},r.prototype.drawPoints=function(){var t=this,o=t.yAxis,s=o.center,a=t.options,l=t.chart.renderer,h=a.overshoot,c=isNumber$5(h)?h/180*Math.PI:0,d;isNumber$5(a.threshold)&&(d=o.startAngleRad+o.translate(a.threshold,null,null,null,!0)),this.thresholdAngleRad=pick$b(d,o.startAngleRad),t.points.forEach(function(p){if(!p.isNull){var u=p.graphic,f=o.startAngleRad+o.translate(p.y,null,null,null,!0),g=pInt(pick$b(p.options.radius,a.radius,100))*s[2]/200,v=pInt(pick$b(p.options.innerRadius,a.innerRadius,60))*s[2]/200,m=void 0,x=void 0,y=o.toColor(p.y,p),b=Math.min(o.startAngleRad,o.endAngleRad),$=Math.max(o.startAngleRad,o.endAngleRad),S=void 0,k=void 0;y==="none"&&(y=p.color||t.color||"none"),y!=="none"&&(p.color=y),f=clamp$1(f,b-c,$+c),a.wrap===!1&&(f=clamp$1(f,b,$)),S=Math.min(f,t.thresholdAngleRad),k=Math.max(f,t.thresholdAngleRad),k-S>2*Math.PI&&(k=S+2*Math.PI),p.shapeArgs=m={x:s[0],y:s[1],r:g,innerR:v,start:S,end:k,rounded:a.rounded},p.startR=g,u?(x=m.d,u.animate(extend$d({fill:y},m)),x&&(m.d=x)):p.graphic=u=l.arc(m).attr({fill:y,"sweep-flag":0}).add(t.group),t.chart.styledMode||(a.linecap!=="square"&&u.attr({"stroke-linecap":"round","stroke-linejoin":"round"}),u.attr({stroke:a.borderColor||"none","stroke-width":a.borderWidth||0})),u&&u.addClass(p.getClassName(),!0)}})},r.prototype.animate=function(t){t||(this.startAngleRad=this.thresholdAngleRad,pieProto.animate.call(this,t))},r.defaultOptions=merge$8(GaugeSeries.defaultOptions,solidGaugeOptions),r}(GaugeSeries);extend$d(SolidGaugeSeries.prototype,{drawLegendSymbol:LegendSymbol$1.drawRectangle});SeriesRegistry$1.registerSeriesType("solidgauge",SolidGaugeSeries);var TreemapAlgorithmGroup=function(){function n(r,t,o,s){this.height=r,this.width=t,this.plot=s,this.direction=o,this.startDirection=o,this.total=0,this.nW=0,this.lW=0,this.nH=0,this.lH=0,this.elArr=[],this.lP={total:0,lH:0,nH:0,lW:0,nW:0,nR:0,lR:0,aspectRatio:function(a,l){return Math.max(a/l,l/a)}}}return n.prototype.addElement=function(r){this.lP.total=this.elArr[this.elArr.length-1],this.total=this.total+r,this.direction===0?(this.lW=this.nW,this.lP.lH=this.lP.total/this.lW,this.lP.lR=this.lP.aspectRatio(this.lW,this.lP.lH),this.nW=this.total/this.height,this.lP.nH=this.lP.total/this.nW,this.lP.nR=this.lP.aspectRatio(this.nW,this.lP.nH)):(this.lH=this.nH,this.lP.lW=this.lP.total/this.lH,this.lP.lR=this.lP.aspectRatio(this.lP.lW,this.lH),this.nH=this.total/this.width,this.lP.nW=this.lP.total/this.nH,this.lP.nR=this.lP.aspectRatio(this.lP.nW,this.nH)),this.elArr.push(r)},n.prototype.reset=function(){this.nW=0,this.lW=0,this.elArr=[],this.total=0},n}(),isFn$1=function(n){return typeof n=="function"},draw=function(r){var t=this,o=r.animatableAttribs,s=r.onComplete,a=r.css,l=r.renderer,h=this.series&&this.series.chart.hasRendered?void 0:this.series&&this.series.options.animation,c=this.graphic;if(this.shouldDraw())c||(this.graphic=c=l[r.shapeType](r.shapeArgs).add(r.group)),c.css(a).attr(r.attribs).animate(o,r.isNew?!1:h,s);else if(c){var d=function(){t.graphic=c=c&&c.destroy(),isFn$1(s)&&s()};Object.keys(o).length?c.animate(o,void 0,function(){d()}):d()}},drawPoint=function(r){var t=this,o=r.attribs=r.attribs||{};o.class=t.getClassName(),draw.call(t,r)},drawPointModule={draw,drawPoint,isFn:isFn$1},__extends$b=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),Point=SeriesRegistry$1.series.prototype.pointClass,_a$2=SeriesRegistry$1.seriesTypes,PiePoint$1=_a$2.pie.prototype.pointClass,ScatterPoint=_a$2.scatter.prototype.pointClass,extend$c=Utilities.extend,isNumber$4=Utilities.isNumber,pick$a=Utilities.pick,TreemapPoint=function(n){__extends$b(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.name=void 0,t.node=void 0,t.options=void 0,t.series=void 0,t.value=void 0,t}return r.prototype.getClassName=function(){var t=Point.prototype.getClassName.call(this),o=this.series,s=o.options;return this.node.level<=o.nodeMap[o.rootNode].level?t+=" highcharts-above-level":!this.node.isLeaf&&!pick$a(s.interactByLeaf,!s.allowTraversingTree)?t+=" highcharts-internal-node-interactive":this.node.isLeaf||(t+=" highcharts-internal-node"),t},r.prototype.isValid=function(){return!!(this.id||isNumber$4(this.value))},r.prototype.setState=function(t){Point.prototype.setState.call(this,t),this.graphic&&this.graphic.attr({zIndex:t==="hover"?1:0})},r.prototype.shouldDraw=function(){return isNumber$4(this.plotY)&&this.y!==null},r}(ScatterPoint);extend$c(TreemapPoint.prototype,{draw:drawPointModule.drawPoint,setVisible:PiePoint$1.prototype.setVisible});var objectEach$1=Utilities.objectEach,TreemapUtilities;(function(n){n.AXIS_MAX=100;function r(s){return typeof s=="boolean"}n.isBoolean=r;function t(s,a,l){l=l||this,objectEach$1(s,function(h,c){a.call(l,h,c,s)})}n.eachObject=t;function o(s,a,l){l===void 0&&(l=this);var h;h=a.call(l,s),h!==!1&&o(h,a,l)}n.recursive=o})(TreemapUtilities||(TreemapUtilities={}));const TreemapUtilities$1=TreemapUtilities;var extend$b=Utilities.extend,isArray$1=Utilities.isArray,isNumber$3=Utilities.isNumber,isObject$3=Utilities.isObject,merge$7=Utilities.merge,pick$9=Utilities.pick,isBoolean=function(n){return typeof n=="boolean"},isFn=function(n){return typeof n=="function"},setTreeValues=function n(r,t){var o=t.before,s=t.idRoot,a=t.mapIdToNode,l=a[s],h=isBoolean(t.levelIsConstant)?t.levelIsConstant:!0,c=t.points,d=c[r.i],p=d&&d.options||{},u=0,f=[],g;return r.levelDynamic=r.level-(h?0:l.level),r.name=pick$9(d&&d.name,""),r.visible=s===r.id||(isBoolean(t.visible)?t.visible:!1),isFn(o)&&(r=o(r,t)),r.children.forEach(function(v,m){var x=extend$b({},t);extend$b(x,{index:m,siblings:r.children.length,visible:r.visible}),v=n(v,x),f.push(v),v.visible&&(u+=v.val)}),g=pick$9(p.value,u),r.visible=g>=0&&(u>0||r.visible),r.children=f,r.childrenTotal=u,r.isLeaf=r.visible&&!u,r.val=g,r},getColor$1=function(r,t){var o=t.index,s=t.mapOptionsToLevel,a=t.parentColor,l=t.parentColorIndex,h=t.series,c=t.colors,d=t.siblings,p=h.points,u,f=h.chart.options.chart,g,v,m,x,y,b;function $(S){var k=v&&v.colorVariation;return k&&k.key==="brightness"?Color.parse(S).brighten(k.to*(o/d)).get():S}return r&&(g=p[r.i],v=s[r.level]||{},u=g&&v.colorByPoint,u&&(x=g.index%(c?c.length:f.colorCount),m=c&&c[x]),h.chart.styledMode||(y=pick$9(g&&g.options.color,v&&v.color,m,a&&$(a),h.color)),b=pick$9(g&&g.options.colorIndex,v&&v.colorIndex,x,l,t.colorIndex)),{color:y,colorIndex:b}},getLevelOptions$2=function(r){var t=null,o,s,a,l,h,c;if(isObject$3(r))for(t={},l=isNumber$3(r.from)?r.from:1,c=r.levels,s={},o=isObject$3(r.defaults)?r.defaults:{},isArray$1(c)&&(s=c.reduce(function(d,p){var u,f,g;return isObject$3(p)&&isNumber$3(p.level)&&(g=merge$7({},p),f=isBoolean(g.levelIsConstant)?g.levelIsConstant:o.levelIsConstant,delete g.levelIsConstant,delete g.level,u=p.level+(f?0:l-1),isObject$3(d[u])?extend$b(d[u],g):d[u]=g),d},{})),h=isNumber$3(r.to)?r.to:1,a=0;a<=h;a++)t[a]=merge$7({},o,isObject$3(s[a])?s[a]:{});return t},updateRootId$1=function(n){var r,t;return isObject$3(n)&&(t=isObject$3(n.options)?n.options:{},r=pick$9(n.rootNode,t.rootId,""),isObject$3(n.userOptions)&&(n.userOptions.rootId=r),n.rootNode=r),r},result={getColor:getColor$1,getLevelOptions:getLevelOptions$2,setTreeValues,updateRootId:updateRootId$1},Series$4=SeriesRegistry$1.series,addEvent$4=Utilities.addEvent,extend$a=Utilities.extend,treemapAxisDefaultValues=!1;addEvent$4(Series$4,"afterBindAxes",function(){var n=this,r=n.xAxis,t=n.yAxis,o;r&&t&&(n.is("treemap")?(o={endOnTick:!1,gridLineWidth:0,lineWidth:0,min:0,minPadding:0,max:TreemapUtilities$1.AXIS_MAX,maxPadding:0,startOnTick:!1,title:void 0,tickPositions:[]},extend$a(t.options,o),extend$a(r.options,o),treemapAxisDefaultValues=!0):treemapAxisDefaultValues&&(t.setOptions(t.userOptions),r.setOptions(r.userOptions),treemapAxisDefaultValues=!1))});var __extends$a=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),color$1=Color.parse,colorMapSeriesMixin=exports.colorMapSeriesMixin,noop=H.noop,Series$3=SeriesRegistry$1.series,_a$1=SeriesRegistry$1.seriesTypes,ColumnSeries$6=_a$1.column,HeatmapSeries=_a$1.heatmap,ScatterSeries=_a$1.scatter,getColor=result.getColor,getLevelOptions$1=result.getLevelOptions,updateRootId=result.updateRootId,addEvent$3=Utilities.addEvent,correctFloat$1=Utilities.correctFloat,defined$6=Utilities.defined,error=Utilities.error,extend$9=Utilities.extend,fireEvent=Utilities.fireEvent,isArray=Utilities.isArray,isObject$2=Utilities.isObject,isString=Utilities.isString,merge$6=Utilities.merge,pick$8=Utilities.pick,stableSort$1=Utilities.stableSort,TreemapSeries=function(n){__extends$a(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.axisRatio=void 0,t.data=void 0,t.mapOptionsToLevel=void 0,t.nodeMap=void 0,t.options=void 0,t.points=void 0,t.rootNode=void 0,t.tree=void 0,t}return r.prototype.algorithmCalcPoints=function(t,o,s,a){var l,h,c,d,p=s.lW,u=s.lH,f=s.plot,g,v=0,m=s.elArr.length-1;o?(p=s.nW,u=s.nH):g=s.elArr[s.elArr.length-1],s.elArr.forEach(function(x){(o||v<m)&&(s.direction===0?(l=f.x,h=f.y,c=p,d=x/c):(l=f.x,h=f.y,d=u,c=x/d),a.push({x:l,y:h,width:c,height:correctFloat$1(d)}),s.direction===0?f.y=f.y+d:f.x=f.x+c),v=v+1}),s.reset(),s.direction===0?s.width=s.width-p:s.height=s.height-u,f.y=f.parent.y+(f.parent.height-s.height),f.x=f.parent.x+(f.parent.width-s.width),t&&(s.direction=1-s.direction),o||s.addElement(g)},r.prototype.algorithmFill=function(t,o,s){var a=[],l,h=o.direction,c=o.x,d=o.y,p=o.width,u=o.height,f,g,v,m;return s.forEach(function(x){l=o.width*o.height*(x.val/o.val),f=c,g=d,h===0?(m=u,v=l/m,p=p-v,c=c+v):(v=p,m=l/v,u=u-m,d=d+m),a.push({x:f,y:g,width:v,height:m}),t&&(h=1-h)}),a},r.prototype.algorithmLowAspectRatio=function(t,o,s){var a=[],l=this,h,c={x:o.x,y:o.y,parent:o},d=o.direction,p=0,u=s.length-1,f=new TreemapAlgorithmGroup(o.height,o.width,d,c);return s.forEach(function(g){h=o.width*o.height*(g.val/o.val),f.addElement(h),f.lP.nR>f.lP.lR&&l.algorithmCalcPoints(t,!1,f,a,c),p===u&&l.algorithmCalcPoints(t,!0,f,a,c),p=p+1}),a},r.prototype.alignDataLabel=function(t,o,s){var a=s.style;a&&!defined$6(a.textOverflow)&&o.text&&o.getBBox().width>o.text.textWidth&&o.css({textOverflow:"ellipsis",width:a.width+="px"}),ColumnSeries$6.prototype.alignDataLabel.apply(this,arguments),t.dataLabel&&t.dataLabel.attr({zIndex:(t.node.zIndex||0)+1})},r.prototype.buildNode=function(t,o,s,a,l){var h=this,c=[],d=h.points[o],p=0,u,f;return(a[t]||[]).forEach(function(g){f=h.buildNode(h.points[g].id,g,s+1,a,t),p=Math.max(f.height+1,p),c.push(f)}),u={id:t,i:o,children:c,height:p,level:s,parent:l,visible:!1},h.nodeMap[u.id]=u,d&&(d.node=u),u},r.prototype.calculateChildrenAreas=function(t,o){var s=this,a=s.options,l=s.mapOptionsToLevel,h=l[t.level+1],c=pick$8(s[h&&h.layoutAlgorithm]&&h.layoutAlgorithm,a.layoutAlgorithm),d=a.alternateStartingDirection,p=[],u;u=t.children.filter(function(f){return!f.ignore}),h&&h.layoutStartingDirection&&(o.direction=h.layoutStartingDirection==="vertical"?0:1),p=s[c](o,u),u.forEach(function(f,g){var v=p[g];f.values=merge$6(v,{val:f.childrenTotal,direction:d?1-o.direction:o.direction}),f.pointValues=merge$6(v,{x:v.x/s.axisRatio,y:TreemapUtilities$1.AXIS_MAX-v.y-v.height,width:v.width/s.axisRatio}),f.children.length&&s.calculateChildrenAreas(f,f.values)})},r.prototype.drawDataLabels=function(){var t=this,o=t.mapOptionsToLevel,s=t.points.filter(function(h){return h.node.visible}),a,l;s.forEach(function(h){l=o[h.node.level],a={style:{}},h.node.isLeaf||(a.enabled=!1),l&&l.dataLabels&&(a=merge$6(a,l.dataLabels),t._hasPointLabels=!0),h.shapeArgs&&(a.style.width=h.shapeArgs.width,h.dataLabel&&h.dataLabel.css({width:h.shapeArgs.width+"px"})),h.dlOptions=merge$6(a,h.options.dataLabels)}),Series$3.prototype.drawDataLabels.call(this)},r.prototype.drawPoints=function(){var t=this,o=t.chart,s=o.renderer,a=t.points,l=o.styledMode,h=t.options,c=l?{}:h.shadow,d=h.borderRadius,p=o.pointCount<h.animationLimit,u=h.allowTraversingTree;a.forEach(function(f){var g=f.node.levelDynamic,v={},m={},x={},y="level-group-"+f.node.level,b=!!f.graphic,$=p&&b,S=f.shapeArgs;f.shouldDraw()&&(f.isInside=!0,d&&(m.r=d),merge$6(!0,$?v:m,b?S:{},l?{}:t.pointAttribs(f,f.selected?"select":void 0)),t.colorAttribs&&l&&extend$9(x,t.colorAttribs(f)),t[y]||(t[y]=s.g(y).attr({zIndex:1e3-(g||0)}).add(t.group),t[y].survive=!0)),f.draw({animatableAttribs:v,attribs:m,css:x,group:t[y],renderer:s,shadow:c,shapeArgs:S,shapeType:"rect"}),u&&f.graphic&&(f.drillId=h.interactByLeaf?t.drillToByLeaf(f):t.drillToByGroup(f))})},r.prototype.drillToByGroup=function(t){var o=this,s=!1;return t.node.level-o.nodeMap[o.rootNode].level===1&&!t.node.isLeaf&&(s=t.id),s},r.prototype.drillToByLeaf=function(t){var o=this,s=!1,a;if(t.node.parent!==o.rootNode&&t.node.isLeaf)for(a=t.node;!s;)a=o.nodeMap[a.parent],a.parent===o.rootNode&&(s=a.id);return s},r.prototype.drillToNode=function(t,o){error(32,!1,void 0,{"treemap.drillToNode":"use treemap.setRootNode"}),this.setRootNode(t,o)},r.prototype.drillUp=function(){var t=this,o=t.nodeMap[t.rootNode];o&&isString(o.parent)&&t.setRootNode(o.parent,!0,{trigger:"traverseUpButton"})},r.prototype.getExtremes=function(){var t=Series$3.prototype.getExtremes.call(this,this.colorValueData),o=t.dataMin,s=t.dataMax;return this.valueMin=o,this.valueMax=s,Series$3.prototype.getExtremes.call(this)},r.prototype.getListOfParents=function(t,o){var s=isArray(t)?t:[],a=isArray(o)?o:[],l=s.reduce(function(h,c,d){var p=pick$8(c.parent,"");return typeof h[p]>"u"&&(h[p]=[]),h[p].push(d),h},{"":[]});return TreemapUtilities$1.eachObject(l,function(h,c,d){c!==""&&a.indexOf(c)===-1&&(h.forEach(function(p){d[""].push(p)}),delete d[c])}),l},r.prototype.getTree=function(){var t=this,o=this.data.map(function(a){return a.id}),s=t.getListOfParents(this.data,o);return t.nodeMap={},t.buildNode("",-1,0,s)},r.prototype.hasData=function(){return!!this.processedXData.length},r.prototype.init=function(t,o){var s=this,a;colorMapSeriesMixin&&(this.colorAttribs=colorMapSeriesMixin.colorAttribs),a=addEvent$3(s,"setOptions",function(l){var h=l.userOptions;defined$6(h.allowDrillToNode)&&!defined$6(h.allowTraversingTree)&&(h.allowTraversingTree=h.allowDrillToNode,delete h.allowDrillToNode),defined$6(h.drillUpButton)&&!defined$6(h.traverseUpButton)&&(h.traverseUpButton=h.drillUpButton,delete h.drillUpButton)}),Series$3.prototype.init.call(s,t,o),delete s.opacity,s.eventsToUnbind.push(a),s.options.allowTraversingTree&&s.eventsToUnbind.push(addEvent$3(s,"click",s.onClickDrillToNode))},r.prototype.onClickDrillToNode=function(t){var o=this,s=t.point,a=s&&s.drillId;isString(a)&&(s.setState(""),o.setRootNode(a,!0,{trigger:"click"}))},r.prototype.pointAttribs=function(t,o){var s=this,a=isObject$2(s.mapOptionsToLevel)?s.mapOptionsToLevel:{},l=t&&a[t.node.level]||{},h=this.options,c,d=o&&h.states[o]||{},p=t&&t.getClassName()||"",u;return c={stroke:t&&t.borderColor||l.borderColor||d.borderColor||h.borderColor,"stroke-width":pick$8(t&&t.borderWidth,l.borderWidth,d.borderWidth,h.borderWidth),dashstyle:t&&t.borderDashStyle||l.borderDashStyle||d.borderDashStyle||h.borderDashStyle,fill:t&&t.color||this.color},p.indexOf("highcharts-above-level")!==-1?(c.fill="none",c["stroke-width"]=0):p.indexOf("highcharts-internal-node-interactive")!==-1?(u=pick$8(d.opacity,h.opacity),c.fill=color$1(c.fill).setOpacity(u).get(),c.cursor="pointer"):p.indexOf("highcharts-internal-node")!==-1?c.fill="none":o&&(c.fill=color$1(c.fill).brighten(d.brightness).get()),c},r.prototype.renderTraverseUpButton=function(t){var o=this,s=o.nodeMap,a=s[t],l=a.name,h=o.options.traverseUpButton,c=pick$8(h.text,l,"◁ Back"),d,p;t===""||o.is("sunburst")&&o.tree.children.length===1&&t===o.tree.children[0].id?o.drillUpButton&&(o.drillUpButton=o.drillUpButton.destroy()):this.drillUpButton?(this.drillUpButton.placed=!1,this.drillUpButton.attr({text:c}).align()):(d=h.theme,p=d&&d.states,this.drillUpButton=this.chart.renderer.button(c,0,0,function(){o.drillUp()},d,p&&p.hover,p&&p.select).addClass("highcharts-drillup-button").attr({align:h.position.align,zIndex:7}).add().align(h.position,!1,h.relativeTo||"plotBox"))},r.prototype.setColorRecursive=function(t,o,s,a,l){var h=this,c=h&&h.chart,d=c&&c.options&&c.options.colors,p,u;t&&(p=getColor(t,{colors:d,index:a,mapOptionsToLevel:h.mapOptionsToLevel,parentColor:o,parentColorIndex:s,series:h,siblings:l}),u=h.points[t.i],u&&(u.color=p.color,u.colorIndex=p.colorIndex),(t.children||[]).forEach(function(f,g){h.setColorRecursive(f,p.color,p.colorIndex,g,t.children.length)}))},r.prototype.setPointValues=function(){var t=this,o=t.points,s=t.xAxis,a=t.yAxis,l=t.chart.styledMode,h=function(c){return l?0:(t.pointAttribs(c)["stroke-width"]||0)%2/2};o.forEach(function(c){var d=c.node,p=d.pointValues,u=d.visible;if(p&&u){var f=p.height,g=p.width,v=p.x,m=p.y,x=h(c),y=Math.round(s.toPixels(v,!0))-x,b=Math.round(s.toPixels(v+g,!0))-x,$=Math.round(a.toPixels(m,!0))-x,S=Math.round(a.toPixels(m+f,!0))-x,k={x:Math.min(y,b),y:Math.min($,S),width:Math.abs(b-y),height:Math.abs(S-$)};c.plotX=k.x+k.width/2,c.plotY=k.y+k.height/2,c.shapeArgs=k}else delete c.plotX,delete c.plotY})},r.prototype.setRootNode=function(t,o,s){var a=this,l=extend$9({newRootId:t,previousRootId:a.rootNode,redraw:pick$8(o,!0),series:a},s),h=function(c){var d=c.series;d.idPreviousRoot=c.previousRootId,d.rootNode=c.newRootId,d.isDirty=!0,c.redraw&&d.chart.redraw()};fireEvent(a,"setRootNode",l,h)},r.prototype.setState=function(t){this.options.inactiveOtherPoints=!0,Series$3.prototype.setState.call(this,t,!1),this.options.inactiveOtherPoints=!1},r.prototype.setTreeValues=function(t){var o=this,s=o.options,a=o.rootNode,l=o.nodeMap,h=l[a],c=TreemapUtilities$1.isBoolean(s.levelIsConstant)?s.levelIsConstant:!0,d=0,p=[],u,f=o.points[t.i];return t.children.forEach(function(g){g=o.setTreeValues(g),p.push(g),g.ignore||(d+=g.val)}),stableSort$1(p,function(g,v){return(g.sortIndex||0)-(v.sortIndex||0)}),u=pick$8(f&&f.options.value,d),f&&(f.value=u),extend$9(t,{children:p,childrenTotal:d,ignore:!(pick$8(f&&f.visible,!0)&&u>0),isLeaf:t.visible&&!d,levelDynamic:t.level-(c?0:h.level),name:pick$8(f&&f.name,""),sortIndex:pick$8(f&&f.sortIndex,-u),val:u}),t},r.prototype.sliceAndDice=function(t,o){return this.algorithmFill(!0,t,o)},r.prototype.squarified=function(t,o){return this.algorithmLowAspectRatio(!0,t,o)},r.prototype.strip=function(t,o){return this.algorithmLowAspectRatio(!1,t,o)},r.prototype.stripes=function(t,o){return this.algorithmFill(!1,t,o)},r.prototype.translate=function(){var t=this,o=t.options,s=updateRootId(t),a,l,h,c,d;Series$3.prototype.translate.call(t),c=t.tree=t.getTree(),a=t.nodeMap[s],s!==""&&(!a||!a.children.length)&&(t.setRootNode("",!1),s=t.rootNode,a=t.nodeMap[s]),t.renderTraverseUpButton(s),t.mapOptionsToLevel=getLevelOptions$1({from:a.level+1,levels:o.levels,to:c.height,defaults:{levelIsConstant:t.options.levelIsConstant,colorByPoint:o.colorByPoint}}),TreemapUtilities$1.recursive(t.nodeMap[t.rootNode],function(p){var u=!1,f=p.parent;return p.visible=!0,(f||f==="")&&(u=t.nodeMap[f]),u}),TreemapUtilities$1.recursive(t.nodeMap[t.rootNode].children,function(p){var u=!1;return p.forEach(function(f){f.visible=!0,f.children.length&&(u=(u||[]).concat(f.children))}),u}),t.setTreeValues(c),t.axisRatio=t.xAxis.len/t.yAxis.len,t.nodeMap[""].pointValues=l={x:0,y:0,width:TreemapUtilities$1.AXIS_MAX,height:TreemapUtilities$1.AXIS_MAX},t.nodeMap[""].values=h=merge$6(l,{width:l.width*t.axisRatio,direction:o.layoutStartingDirection==="vertical"?0:1,val:c.val}),t.calculateChildrenAreas(c,h),!t.colorAxis&&!o.colorByPoint&&t.setColorRecursive(t.tree),o.allowTraversingTree&&(d=a.pointValues,t.xAxis.setExtremes(d.x,d.x+d.width,!1),t.yAxis.setExtremes(d.y,d.y+d.height,!1),t.xAxis.setScale(),t.yAxis.setScale()),t.setPointValues()},r.defaultOptions=merge$6(ScatterSeries.defaultOptions,{allowTraversingTree:!1,animationLimit:250,borderRadius:0,showInLegend:!1,marker:void 0,colorByPoint:!1,dataLabels:{defer:!1,enabled:!0,formatter:function(){var t=this&&this.point?this.point:{},o=isString(t.name)?t.name:"";return o},inside:!0,verticalAlign:"middle"},tooltip:{headerFormat:"",pointFormat:"<b>{point.name}</b>: {point.value}<br/>"},ignoreHiddenPoint:!0,layoutAlgorithm:"sliceAndDice",layoutStartingDirection:"vertical",alternateStartingDirection:!1,levelIsConstant:!0,drillUpButton:{position:{align:"right",x:-10,y:10}},traverseUpButton:{position:{align:"right",x:-10,y:10}},borderColor:palette.neutralColor10,borderWidth:1,colorKey:"colorValue",opacity:.15,states:{hover:{borderColor:palette.neutralColor40,brightness:HeatmapSeries?0:.1,halo:!1,opacity:.75,shadow:!1}}}),r}(ScatterSeries);extend$9(TreemapSeries.prototype,{buildKDTree:noop,colorKey:"colorValue",directTouch:!0,drawLegendSymbol:LegendSymbol$1.drawRectangle,getExtremesFromAll:!0,getSymbol:noop,optionalAxis:"colorAxis",parallelArrays:["x","y","value","colorValue"],pointArrayMap:["value"],pointClass:TreemapPoint,trackerGroups:["group","dataLabelsGroup"],utils:{recursive:TreemapUtilities$1.recursive}});SeriesRegistry$1.registerSeriesType("treemap",TreemapSeries);var getOptions=DefaultOptions.getOptions,addEvent$2=Utilities.addEvent,extend$8=Utilities.extend,chartPrototype=Chart$1.prototype,defaultOptions=getOptions();extend$8(defaultOptions.lang,{noData:"No data to display"});defaultOptions.noData={attr:{zIndex:1},position:{x:0,y:0,align:"center",verticalAlign:"middle"},style:{fontWeight:"bold",fontSize:"12px",color:palette.neutralColor60}};chartPrototype.showNoData=function(n){var r=this,t=r.options,o=n||t&&t.lang.noData||"",s=t&&(t.noData||{});r.renderer&&(r.noDataLabel||(r.noDataLabel=r.renderer.label(o,0,0,void 0,void 0,void 0,s.useHTML,void 0,"no-data").add()),r.styledMode||r.noDataLabel.attr(AST.filterUserAttributes(s.attr||{})).css(s.style||{}),r.noDataLabel.align(extend$8(r.noDataLabel.getBBox(),s.position||{}),!1,"plotBox"))};chartPrototype.hideNoData=function(){var n=this;n.noDataLabel&&(n.noDataLabel=n.noDataLabel.destroy())};chartPrototype.hasData=function(){for(var n=this,r=n.series||[],t=r.length;t--;)if(r[t].hasData()&&!r[t].options.isInternal)return!0;return n.loadingShown};addEvent$2(Chart$1,"render",function(){this.hasData()?this.hideNoData():this.showNoData()});var defined$5=Utilities.defined,extend$7=Utilities.extend,find$2=Utilities.find,pick$7=Utilities.pick,NodesMixin=H.NodesMixin={createNode:function(n){function r(a,l){return find$2(a,function(h){return h.id===l})}var t=r(this.nodes,n),o=this.pointClass,s;return t||(s=this.options.nodes&&r(this.options.nodes,n),t=new o().init(this,extend$7({className:"highcharts-node",isNode:!0,id:n,y:1},s)),t.linksTo=[],t.linksFrom=[],t.formatPrefix="node",t.name=t.name||t.options.id||"",t.mass=pick$7(t.options.mass,t.options.marker&&t.options.marker.radius,this.options.marker&&this.options.marker.radius,4),t.getSum=function(){var a=0,l=0;return t.linksTo.forEach(function(h){a+=h.weight}),t.linksFrom.forEach(function(h){l+=h.weight}),Math.max(a,l)},t.offset=function(a,l){for(var h=0,c=0;c<t[l].length;c++){if(t[l][c]===a)return h;h+=t[l][c].weight}},t.hasShape=function(){var a=0;return t.linksTo.forEach(function(l){l.outgoing&&a++}),!t.linksTo.length||a!==t.linksTo.length},this.nodes.push(t)),t},generatePoints:function(){var n=this.chart,r={};Series$e.prototype.generatePoints.call(this),this.nodes||(this.nodes=[]),this.colorCounter=0,this.nodes.forEach(function(t){t.linksFrom.length=0,t.linksTo.length=0,t.level=t.options.level}),this.points.forEach(function(t){defined$5(t.from)&&(r[t.from]||(r[t.from]=this.createNode(t.from)),r[t.from].linksFrom.push(t),t.fromNode=r[t.from],n.styledMode?t.colorIndex=pick$7(t.options.colorIndex,r[t.from].colorIndex):t.color=t.options.color||r[t.from].color),defined$5(t.to)&&(r[t.to]||(r[t.to]=this.createNode(t.to)),r[t.to].linksTo.push(t),t.toNode=r[t.to]),t.name=t.name||t.id},this),this.nodeLookup=r},setData:function(){this.nodes&&(this.nodes.forEach(function(n){n.destroy()}),this.nodes.length=0),Series$e.prototype.setData.apply(this,arguments)},destroy:function(){return this.data=[].concat(this.points||[],this.nodes),Series$e.prototype.destroy.apply(this,arguments)},setNodeState:function(n){var r=arguments,t=this.isNode?this.linksTo.concat(this.linksFrom):[this.fromNode,this.toNode];n!=="select"&&t.forEach(function(o){o&&o.series&&(Point$2.prototype.setState.apply(o,r),o.isNode||(o.fromNode.graphic&&Point$2.prototype.setState.apply(o.fromNode,r),o.toNode&&o.toNode.graphic&&Point$2.prototype.setState.apply(o.toNode,r)))}),Point$2.prototype.setState.apply(this,r)}},__extends$9=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),ColumnSeries$5=SeriesRegistry$1.seriesTypes.column,defined$4=Utilities.defined,extend$6=Utilities.extend,SankeyPoint$1=function(n){__extends$9(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.className=void 0,t.fromNode=void 0,t.level=void 0,t.linkBase=void 0,t.linksFrom=void 0,t.linksTo=void 0,t.mass=void 0,t.nodeX=void 0,t.nodeY=void 0,t.options=void 0,t.series=void 0,t.toNode=void 0,t}return r.prototype.applyOptions=function(t,o){return Point$2.prototype.applyOptions.call(this,t,o),defined$4(this.options.level)&&(this.options.column=this.column=this.options.level),this},r.prototype.getClassName=function(){return(this.isNode?"highcharts-node ":"highcharts-link ")+Point$2.prototype.getClassName.call(this)},r.prototype.isValid=function(){return this.isNode||typeof this.weight=="number"},r}(ColumnSeries$5.prototype.pointClass);extend$6(SankeyPoint$1.prototype,{setState:NodesMixin.setNodeState});var __extends$8=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),Series$2=SeriesRegistry$1.series,ColumnSeries$4=SeriesRegistry$1.seriesTypes.column,getLevelOptions=result.getLevelOptions,defined$3=Utilities.defined,extend$5=Utilities.extend,find$1=Utilities.find,isObject$1=Utilities.isObject,merge$5=Utilities.merge,pick$6=Utilities.pick,relativeLength$1=Utilities.relativeLength,stableSort=Utilities.stableSort,SankeySeries$1=function(n){__extends$8(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.colDistance=void 0,t.data=void 0,t.group=void 0,t.nodeLookup=void 0,t.nodePadding=void 0,t.nodes=void 0,t.nodeWidth=void 0,t.options=void 0,t.points=void 0,t.translationFactor=void 0,t}return r.getDLOptions=function(t){var o=isObject$1(t.optionsPoint)?t.optionsPoint.dataLabels:{},s=isObject$1(t.level)?t.level.dataLabels:{},a=merge$5({style:{}},s,o);return a},r.prototype.createNodeColumn=function(){var t=this,o=this.chart,s=[];return s.sum=function(){return this.reduce(function(a,l){return a+l.getSum()},0)},s.offset=function(a,l){for(var h=0,c,d=t.nodePadding,p=0;p<s.length;p++){var u=s[p].getSum(),f=Math.max(u*l,t.options.minLinkWidth);if(u?c=f+d:c=0,s[p]===a)return{relativeTop:h+relativeLength$1(a.options.offset||0,c)};h+=c}},s.top=function(a){var l=t.nodePadding,h=this.reduce(function(c,d){c>0&&(c+=l);var p=Math.max(d.getSum()*a,t.options.minLinkWidth);return c+=p,c},0);return(o.plotSizeY-h)/2},s},r.prototype.createNodeColumns=function(){var t=[];this.nodes.forEach(function(s){var a=-1,l;if(!defined$3(s.options.column))if(s.linksTo.length===0)s.column=0;else{for(var h=0;h<s.linksTo.length;h++){var c=s.linksTo[h];c.fromNode.column>a&&c.fromNode!==s&&(l=c.fromNode,a=l.column)}if(s.column=a+1,l&&l.options.layout==="hanging"){s.hangsFrom=l;var d=-1;find$1(l.linksFrom,function(p,u){var f=p.toNode===s;return f&&(d=u),f}),s.column+=d}}t[s.column]||(t[s.column]=this.createNodeColumn()),t[s.column].push(s)},this);for(var o=0;o<t.length;o++)typeof t[o]>"u"&&(t[o]=this.createNodeColumn());return t},r.prototype.generatePoints=function(){NodesMixin.generatePoints.apply(this,arguments);function t(o,s){typeof o.level>"u"&&(o.level=s,o.linksFrom.forEach(function(a){a.toNode&&t(a.toNode,s+1)}))}this.orderNodes&&(this.nodes.filter(function(o){return o.linksTo.length===0}).forEach(function(o){t(o,0)}),stableSort(this.nodes,function(o,s){return o.level-s.level}))},r.prototype.getNodePadding=function(){var t=this.options.nodePadding||0;if(this.nodeColumns){var o=this.nodeColumns.reduce(function(s,a){return Math.max(s,a.length)},0);o*t>this.chart.plotSizeY&&(t=this.chart.plotSizeY/o)}return t},r.prototype.hasData=function(){return!!this.processedXData.length},r.prototype.pointAttribs=function(t,o){if(!t)return{};var s=this,a=t.isNode?t.level:t.fromNode.level,l=s.mapOptionsToLevel[a||0]||{},h=t.options,c=l.states&&l.states[o||""]||{},d=["colorByPoint","borderColor","borderWidth","linkOpacity"].reduce(function(u,f){return u[f]=pick$6(c[f],h[f],l[f],s.options[f]),u},{}),p=pick$6(c.color,h.color,d.colorByPoint?t.color:l.color);return t.isNode?{fill:p,stroke:d.borderColor,"stroke-width":d.borderWidth}:{fill:Color.parse(p).setOpacity(d.linkOpacity).get()}},r.prototype.render=function(){var t=this.points;this.points=this.points.concat(this.nodes||[]),ColumnSeries$4.prototype.render.call(this),this.points=t},r.prototype.translate=function(){var t=this,o=function(d){for(var p=d.slice(),u=t.options.minLinkWidth||0,f,g=0,v,m=a.plotSizeY-l.borderWidth-(d.length-1)*s.nodePadding;d.length;){for(g=m/d.sum(),f=!1,v=d.length;v--;)d[v].getSum()*g<u&&(d.splice(v,1),m-=u,f=!0);if(!f)break}return d.length=0,p.forEach(function(x){return d.push(x)}),g};this.processedXData||this.processData(),this.generatePoints(),this.nodeColumns=this.createNodeColumns(),this.nodeWidth=relativeLength$1(this.options.nodeWidth,this.chart.plotSizeX);var s=this,a=this.chart,l=this.options,h=this.nodeWidth,c=this.nodeColumns;this.nodePadding=this.getNodePadding(),this.translationFactor=c.reduce(function(d,p){return Math.min(d,o(p))},1/0),this.colDistance=(a.plotSizeX-h-l.borderWidth)/Math.max(1,c.length-1),s.mapOptionsToLevel=getLevelOptions({from:1,levels:l.levels,to:c.length-1,defaults:{borderColor:l.borderColor,borderRadius:l.borderRadius,borderWidth:l.borderWidth,color:s.color,colorByPoint:l.colorByPoint,levelIsConstant:!0,linkColor:l.linkColor,linkLineWidth:l.linkLineWidth,linkOpacity:l.linkOpacity,states:l.states}}),c.forEach(function(d){d.forEach(function(p){s.translateNode(p,d)})},this),this.nodes.forEach(function(d){d.linksFrom.forEach(function(p){(p.weight||p.isNull)&&p.to&&(s.translateLink(p),p.allowShadow=!1)})})},r.prototype.translateLink=function(t){var o=function(V,j){var K=V.offset(t,j)*h,ot=Math.min(V.nodeY+K,V.nodeY+(V.shapeArgs&&V.shapeArgs.height||0)-c);return ot},s=t.fromNode,a=t.toNode,l=this.chart,h=this.translationFactor,c=Math.max(t.weight*h,this.options.minLinkWidth),d=this.options,p=(l.inverted?-this.colDistance:this.colDistance)*d.curveFactor,u=o(s,"linksFrom"),f=o(a,"linksTo"),g=s.nodeX,v=this.nodeWidth,m=a.column*this.colDistance,x=t.outgoing,y=m>g+v;if(l.inverted&&(u=l.plotSizeY-u,f=(l.plotSizeY||0)-f,m=l.plotSizeX-m,v=-v,c=-c,y=g>m),t.shapeType="path",t.linkBase=[u,u+c,f,f+c],y&&typeof f=="number")t.shapeArgs={d:[["M",g+v,u],["C",g+v+p,u,m-p,f,m,f],["L",m+(x?v:0),f+c/2],["L",m,f+c],["C",m-p,f+c,g+v+p,u+c,g+v,u+c],["Z"]]};else if(typeof f=="number"){var b=20,$=l.plotHeight-u-c,S=m-b-c,k=m-b,A=m,P=g+v,E=P+b,M=E+c,T=u,O=u+c,L=O+b,C=L+$,U=C+b,D=U+c,N=f,I=N+c,B=I+b,X=O-c*.7,W=U+c*.7,F=I-c*.7,_=A-c*.7,z=P+c*.7;t.shapeArgs={d:[["M",P,T],["C",z,T,M,X,M,L],["L",M,C],["C",M,W,z,D,P,D],["L",A,D],["C",_,D,S,W,S,C],["L",S,B],["C",S,F,_,N,A,N],["L",A,I],["C",k,I,k,I,k,B],["L",k,C],["C",k,U,k,U,A,U],["L",P,U],["C",E,U,E,U,E,C],["L",E,L],["C",E,O,E,O,P,O],["Z"]]}}t.dlBox={x:g+(m-g+v)/2,y:u+(f-u)/2,height:c,width:0},t.tooltipPos=l.inverted?[l.plotSizeY-t.dlBox.y-c/2,l.plotSizeX-t.dlBox.x]:[t.dlBox.x,t.dlBox.y+c/2],t.y=t.plotY=1,t.color||(t.color=s.color)},r.prototype.translateNode=function(t,o){var s=this.translationFactor,a=this.chart,l=this.options,h=t.getSum(),c=Math.max(Math.round(h*s),this.options.minLinkWidth),d=Math.round(l.borderWidth)%2/2,p=o.offset(t,s),u=Math.floor(pick$6(p.absoluteTop,o.top(s)+p.relativeTop))+d,f=Math.floor(this.colDistance*t.column+l.borderWidth/2)+d,g=a.inverted?a.plotSizeX-f:f,v=Math.round(this.nodeWidth);if(t.sum=h,h){t.shapeType="rect",t.nodeX=g,t.nodeY=u;var m=g,x=u,y=t.options.width||l.width||v,b=t.options.height||l.height||c;a.inverted&&(m=g-v,x=a.plotSizeY-u-c,y=t.options.height||l.height||v,b=t.options.width||l.width||c),t.dlOptions=r.getDLOptions({level:this.mapOptionsToLevel[t.level],optionsPoint:t.options}),t.plotX=1,t.plotY=1,t.tooltipPos=a.inverted?[a.plotSizeY-x-b/2,a.plotSizeX-m-y/2]:[m+y/2,x+b/2],t.shapeArgs={x:m,y:x,width:y,height:b,display:t.hasShape()?"":"none"}}else t.dlOptions={enabled:!1}},r.defaultOptions=merge$5(ColumnSeries$4.defaultOptions,{borderWidth:0,colorByPoint:!0,curveFactor:.33,dataLabels:{enabled:!0,backgroundColor:"none",crop:!1,nodeFormat:void 0,nodeFormatter:function(){return this.point.name},format:void 0,formatter:function(){},inside:!0},inactiveOtherPoints:!0,linkOpacity:.5,minLinkWidth:0,nodeWidth:20,nodePadding:10,showInLegend:!1,states:{hover:{linkOpacity:1},inactive:{linkOpacity:.1,opacity:.1,animation:{duration:50}}},tooltip:{followPointer:!0,headerFormat:'<span style="font-size: 10px">{series.name}</span><br/>',pointFormat:"{point.fromNode.name} → {point.toNode.name}: <b>{point.weight}</b><br/>",nodeFormat:"{point.name}: <b>{point.sum}</b><br/>"}}),r}(ColumnSeries$4);extend$5(SankeySeries$1.prototype,{animate:Series$2.prototype.animate,createNode:NodesMixin.createNode,destroy:NodesMixin.destroy,forceDL:!0,invertible:!0,isCartesian:!1,orderNodes:!0,pointArrayMap:["from","to"],pointClass:SankeyPoint$1,searchPoint:H.noop,setData:NodesMixin.setData});SeriesRegistry$1.registerSeriesType("sankey",SankeySeries$1);var __extends$7=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),Series$1=SeriesRegistry$1.series,PiePoint=SeriesRegistry$1.seriesTypes.pie.prototype.pointClass,defined$2=Utilities.defined,isNumber$2=Utilities.isNumber,merge$4=Utilities.merge,objectEach=Utilities.objectEach,pick$5=Utilities.pick,TimelinePoint=function(n){__extends$7(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return r.prototype.alignConnector=function(){var t=this,o=t.series,s=t.connector,a=t.dataLabel,l=t.dataLabel.options=merge$4(o.options.dataLabels,t.options.dataLabels),h=t.series.chart,c=s.getBBox(),d={x:c.x+a.translateX,y:c.y+a.translateY},p;h.inverted?d.y-=a.options.connectorWidth/2:d.x+=a.options.connectorWidth/2,p=h.isInsidePlot(d.x,d.y),s[p?"animate":"attr"]({d:t.getConnectorPath()}),o.chart.styledMode||s.attr({stroke:l.connectorColor||t.color,"stroke-width":l.connectorWidth,opacity:a[defined$2(a.newOpacity)?"newOpacity":"opacity"]})},r.prototype.drawConnector=function(){var t=this,o=t.series;t.connector||(t.connector=o.chart.renderer.path(t.getConnectorPath()).attr({zIndex:-1}).add(t.dataLabel)),t.series.chart.isInsidePlot(t.dataLabel.x,t.dataLabel.y)&&t.alignConnector()},r.prototype.getConnectorPath=function(){var t=this,o=t.series.chart,s=t.series.xAxis.len,a=o.inverted,l=a?"x2":"y2",h=t.dataLabel,c=h.targetPosition,d={x1:t.plotX,y1:t.plotY,x2:t.plotX,y2:isNumber$2(c.y)?c.y:h.y},p=(h.alignAttr||h)[l[0]]<t.series.yAxis.len/2,u;return a&&(d={x1:t.plotY,y1:s-t.plotX,x2:c.x||h.x,y2:s-t.plotX}),p&&(d[l]+=h[a?"width":"height"]),objectEach(d,function(f,g){d[g]-=(h.alignAttr||h)[g[0]]}),u=o.renderer.crispLine([["M",d.x1,d.y1],["L",d.x2,d.y2]],h.options.connectorWidth),u},r.prototype.init=function(){var t=n.prototype.init.apply(this,arguments);return t.name=pick$5(t.name,"Event"),t.y=1,t},r.prototype.isValid=function(){return this.options.y!==null},r.prototype.setState=function(){var t=n.prototype.setState;this.isNull||t.apply(this,arguments)},r.prototype.setVisible=function(t,o){var s=this,a=s.series;o=pick$5(o,a.options.ignoreHiddenPoint),PiePoint.prototype.setVisible.call(s,t,!1),a.processData(),o&&a.chart.redraw()},r.prototype.applyOptions=function(t,o){return t=Point$2.prototype.optionsToObject.call(this,t),this.userDLOptions=merge$4(this.userDLOptions,t.dataLabels),n.prototype.applyOptions.call(this,t,o)},r}(Series$1.prototype.pointClass),__extends$6=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),_a=SeriesRegistry$1.seriesTypes,ColumnSeries$3=_a.column,LineSeries=_a.line,addEvent$1=Utilities.addEvent,arrayMax=Utilities.arrayMax,arrayMin=Utilities.arrayMin,defined$1=Utilities.defined,extend$4=Utilities.extend,merge$3=Utilities.merge,pick$4=Utilities.pick,TimelineSeries=function(n){__extends$6(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t.userOptions=void 0,t.visibilityMap=void 0,t}return r.prototype.alignDataLabel=function(t,o,s,a){var l=this,h=l.chart.inverted,c=l.visibilityMap.filter(function(S){return S}),d=l.visiblePointsCount,p=c.indexOf(t),u=!p||p===d-1,f=l.options.dataLabels,g=t.userDLOptions||{},v=f.alternate?u?1.5:2:1,m,x=Math.floor(l.xAxis.len/d),y=o.padding,b,$;t.visible&&(m=Math.abs(g.x||t.options.dataLabels.x),h?(b=(m-y)*2-t.itemHeight/2,$={width:b+"px",textOverflow:o.width/b*o.height/2>x*v?"ellipsis":"none"}):$={width:(g.width||f.width||x*v-y*2)+"px"},o.css($),l.chart.styledMode||o.shadow(f.shadow)),n.prototype.alignDataLabel.apply(l,arguments)},r.prototype.bindAxes=function(){var t=this;n.prototype.bindAxes.call(t),["xAxis","yAxis"].forEach(function(o){o==="xAxis"&&!t[o].userOptions.type&&(t[o].categories=t[o].hasNames=!0)})},r.prototype.distributeDL=function(){var t=this,o=t.options.dataLabels,s=1;if(o){var a=o.distance||0;t.points.forEach(function(l){var h;l.options.dataLabels=merge$3((h={},h[t.chart.inverted?"x":"y"]=o.alternate&&s%2?-a:a,h),l.userDLOptions),s++})}},r.prototype.generatePoints=function(){var t=this;n.prototype.generatePoints.apply(t),t.points.forEach(function(o,s){o.applyOptions({x:t.xData[s]},t.xData[s])})},r.prototype.getVisibilityMap=function(){var t=this,o=(t.data.length?t.data:t.userOptions.data).map(function(s){return s&&s.visible!==!1&&!s.isNull?s:!1});return o},r.prototype.getXExtremes=function(t){var o=this,s=t.filter(function(a,l){return o.points[l].isValid()&&o.points[l].visible});return{min:arrayMin(s),max:arrayMax(s)}},r.prototype.init=function(){var t=this;n.prototype.init.apply(t,arguments),t.eventsToUnbind.push(addEvent$1(t,"afterTranslate",function(){var o,s=Number.MAX_VALUE;t.points.forEach(function(a){a.isInside=a.isInside&&a.visible,a.visible&&!a.isNull&&(defined$1(o)&&(s=Math.min(s,Math.abs(a.plotX-o))),o=a.plotX)}),t.closestPointRangePx=s})),t.eventsToUnbind.push(addEvent$1(t,"drawDataLabels",function(){t.distributeDL()})),t.eventsToUnbind.push(addEvent$1(t,"afterDrawDataLabels",function(){var o;t.points.forEach(function(s){if(o=s.dataLabel,o)return o.animate=function(a){return this.targetPosition&&(this.targetPosition=a),SVGElement.prototype.animate.apply(this,arguments)},o.targetPosition||(o.targetPosition={}),s.drawConnector()})})),t.eventsToUnbind.push(addEvent$1(t.chart,"afterHideOverlappingLabel",function(){t.points.forEach(function(o){o.connector&&o.dataLabel&&o.dataLabel.oldOpacity!==o.dataLabel.newOpacity&&o.alignConnector()})}))},r.prototype.markerAttribs=function(t,o){var s=this,a=s.options.marker,l,h=t.marker||{},c=h.symbol||a.symbol,d,p=pick$4(h.width,a.width,s.closestPointRangePx),u=pick$4(h.height,a.height),f=0,g;return s.xAxis.dateTime?n.prototype.markerAttribs.call(this,t,o):(o&&(l=a.states[o]||{},d=h.states&&h.states[o]||{},f=pick$4(d.radius,l.radius,f+(l.radiusPlus||0))),t.hasImage=c&&c.indexOf("url")===0,g={x:Math.floor(t.plotX)-p/2-f/2,y:t.plotY-u/2-f/2,width:p+f,height:u+f},g)},r.prototype.processData=function(){var t=this,o=0,s;for(t.visibilityMap=t.getVisibilityMap(),t.visibilityMap.forEach(function(a){a&&o++}),t.visiblePointsCount=o,s=0;s<t.xData.length;s++)t.yData[s]=1;n.prototype.processData.call(this,arguments)},r.defaultOptions=merge$3(LineSeries.defaultOptions,{colorByPoint:!0,stickyTracking:!1,ignoreHiddenPoint:!0,legendType:"point",lineWidth:4,tooltip:{headerFormat:'<span style="color:{point.color}">●</span> <span style="font-size: 10px"> {point.key}</span><br/>',pointFormat:"{point.description}"},states:{hover:{lineWidthPlus:0}},dataLabels:{enabled:!0,allowOverlap:!0,alternate:!0,backgroundColor:palette.backgroundColor,borderWidth:1,borderColor:palette.neutralColor40,borderRadius:3,color:palette.neutralColor80,connectorWidth:1,distance:100,formatter:function(){var t;return this.series.chart.styledMode?t="<span>● </span>":t='<span style="color:'+this.point.color+'">● </span>',t+='<span class="highcharts-strong">'+(this.key||"")+"</span><br/>"+(this.point.label||""),t},style:{textOutline:"none",fontWeight:"normal",fontSize:"12px"},shadow:!1,verticalAlign:"middle"},marker:{enabledThreshold:0,symbol:"square",radius:6,lineWidth:2,height:15},showInLegend:!1,colorKey:"x"}),r}(LineSeries);extend$4(TimelineSeries.prototype,{drawLegendSymbol:LegendSymbol$1.drawRectangle,drawTracker:ColumnSeries$3.prototype.drawTracker,pointClass:TimelinePoint,trackerGroups:["markerGroup","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("timeline",TimelineSeries);var __extends$5=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),SankeyPoint=SeriesRegistry$1.seriesTypes.sankey.prototype.pointClass,OrganizationPoint=function(n){__extends$5(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.fromNode=void 0,t.linksFrom=void 0,t.linksTo=void 0,t.options=void 0,t.series=void 0,t.toNode=void 0,t}return r.prototype.getSum=function(){return 1},r}(SankeyPoint),__extends$4=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),SankeySeries=SeriesRegistry$1.seriesTypes.sankey,css=Utilities.css,extend$3=Utilities.extend,merge$2=Utilities.merge,pick$3=Utilities.pick,wrap=Utilities.wrap,OrganizationSeries=function(n){__extends$4(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.curvedPath=function(t,o){for(var s=[],a=0;a<t.length;a++){var l=t[a][1],h=t[a][2];if(typeof l=="number"&&typeof h=="number")if(a===0)s.push(["M",l,h]);else if(a===t.length-1)s.push(["L",l,h]);else if(o){var c=t[a-1],d=t[a+1];if(c&&d){var p=c[1],u=c[2],f=d[1],g=d[2];if(typeof p=="number"&&typeof f=="number"&&typeof u=="number"&&typeof g=="number"&&p!==f&&u!==g){var v=p<f?1:-1,m=u<g?1:-1;s.push(["L",l-v*Math.min(Math.abs(l-p),o),h-m*Math.min(Math.abs(h-u),o)],["C",l,h,l,h,l+v*Math.min(Math.abs(l-f),o),h+m*Math.min(Math.abs(h-g),o)])}}}else s.push(["L",l,h])}return s},r.prototype.alignDataLabel=function(t,o,s){if(s.useHTML){var a=t.shapeArgs.width,l=t.shapeArgs.height,h=this.options.borderWidth+2*this.options.dataLabels.padding;this.chart.inverted&&(a=l,l=t.shapeArgs.width),l-=h,a-=h;var c=o.text;c&&(css(c.element.parentNode,{width:a+"px",height:l+"px"}),css(c.element,{left:0,top:0,width:"100%",height:"100%",overflow:"hidden"})),o.getBBox=function(){return{width:a,height:l}},o.width=a,o.height=l}n.prototype.alignDataLabel.apply(this,arguments)},r.prototype.createNode=function(t){var o=n.prototype.createNode.call(this,t);return o.getSum=function(){return 1},o},r.prototype.createNodeColumn=function(){var t=n.prototype.createNodeColumn.call(this);return wrap(t,"offset",function(o,s,a){var l=o.call(this,s,a);return s.hangsFrom?{absoluteTop:s.hangsFrom.nodeY}:l}),t},r.prototype.pointAttribs=function(t,o){var s=this,a=SankeySeries.prototype.pointAttribs.call(s,t,o),l=t.isNode?t.level:t.fromNode.level,h=s.mapOptionsToLevel[l||0]||{},c=t.options,d=h.states&&h.states[o]||{},p=["borderRadius","linkColor","linkLineWidth"].reduce(function(u,f){return u[f]=pick$3(d[f],c[f],h[f],s.options[f]),u},{});return t.isNode?p.borderRadius&&(a.r=p.borderRadius):(a.stroke=p.linkColor,a["stroke-width"]=p.linkLineWidth,delete a.fill),a},r.prototype.translateLink=function(t){var o=t.fromNode,s=t.toNode,a=Math.round(this.options.linkLineWidth)%2/2,l=Math.floor(o.shapeArgs.x+o.shapeArgs.width)+a,h=Math.floor(o.shapeArgs.y+o.shapeArgs.height/2)+a,c=Math.floor(s.shapeArgs.x)+a,d=Math.floor(s.shapeArgs.y+s.shapeArgs.height/2)+a,p,u=this.options.hangingIndent,f=s.options.offset,g=/%$/.test(f)&&parseInt(f,10),v=this.chart.inverted;v&&(l-=o.shapeArgs.width,c+=s.shapeArgs.width),p=Math.floor(c+(v?1:-1)*(this.colDistance-this.nodeWidth)/2)+a,g&&(g>=50||g<=-50)&&(p=c=Math.floor(c+(v?-.5:.5)*s.shapeArgs.width)+a,d=s.shapeArgs.y,g>0&&(d+=s.shapeArgs.height)),s.hangsFrom===o&&(this.chart.inverted?(h=Math.floor(o.shapeArgs.y+o.shapeArgs.height-u/2)+a,d=s.shapeArgs.y+s.shapeArgs.height):h=Math.floor(o.shapeArgs.y+u/2)+a,p=c=Math.floor(s.shapeArgs.x+s.shapeArgs.width/2)+a),t.plotY=1,t.shapeType="path",t.shapeArgs={d:r.curvedPath([["M",l,h],["L",p,h],["L",p,d],["L",c,d]],this.options.linkRadius)}},r.prototype.translateNode=function(t,o){SankeySeries.prototype.translateNode.call(this,t,o),t.hangsFrom&&(t.shapeArgs.height-=this.options.hangingIndent,this.chart.inverted||(t.shapeArgs.y+=this.options.hangingIndent)),t.nodeHeight=this.chart.inverted?t.shapeArgs.width:t.shapeArgs.height},r.defaultOptions=merge$2(SankeySeries.defaultOptions,{borderColor:palette.neutralColor60,borderRadius:3,linkRadius:10,borderWidth:1,dataLabels:{nodeFormatter:function(){var t={width:"100%",height:"100%",display:"flex","flex-direction":"row","align-items":"center","justify-content":"center"},o={"max-height":"100%","border-radius":"50%"},s={width:"100%",padding:0,"text-align":"center","white-space":"normal"},a={margin:0},l={margin:0},h={opacity:.75,margin:"5px"};function c(p){return Object.keys(p).reduce(function(u,f){return u+f+":"+p[f]+";"},'style="')+'"'}this.point.image&&(o["max-width"]="30%",s.width="70%"),this.series.chart.renderer.forExport&&(t.display="block",s.position="absolute",s.left=this.point.image?"30%":0,s.top=0);var d="<div "+c(t)+">";return this.point.image&&(d+='<img src="'+this.point.image+'" '+c(o)+">"),d+="<div "+c(s)+">",this.point.name&&(d+="<h4 "+c(a)+">"+this.point.name+"</h4>"),this.point.title&&(d+="<p "+c(l)+">"+(this.point.title||"")+"</p>"),this.point.description&&(d+="<p "+c(h)+">"+this.point.description+"</p>"),d+="</div></div>",d},style:{fontWeight:"normal",fontSize:"13px"},useHTML:!0},hangingIndent:20,linkColor:palette.neutralColor60,linkLineWidth:1,nodeWidth:50,tooltip:{nodeFormat:"{point.name}<br>{point.title}<br>{point.description}"}}),r}(SankeySeries);extend$3(OrganizationSeries.prototype,{pointClass:OrganizationPoint});SeriesRegistry$1.registerSeriesType("organization",OrganizationSeries);var __extends$3=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),ColumnSeries$2=SeriesRegistry$1.seriesTypes.column,extend$2=Utilities.extend,XRangePoint=function(n){__extends$3(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return r.getColorByCategory=function(t,o){var s=t.options.colors||t.chart.options.colors,a=s?s.length:t.chart.options.chart.colorCount,l=o.y%a,h=s&&s[l];return{colorIndex:l,color:h}},r.prototype.resolveColor=function(){var t=this.series,o;t.options.colorByPoint&&!this.options.color?(o=r.getColorByCategory(t,this),t.chart.styledMode||(this.color=o.color),this.options.colorIndex||(this.colorIndex=o.colorIndex)):this.color||(this.color=t.color)},r.prototype.init=function(){return Point$2.prototype.init.apply(this,arguments),this.y||(this.y=0),this},r.prototype.setState=function(){Point$2.prototype.setState.apply(this,arguments),this.series.drawPoint(this,this.series.getAnimationVerb())},r.prototype.getLabelConfig=function(){var t=this,o=Point$2.prototype.getLabelConfig.call(t),s=t.series.yAxis.categories;return o.x2=t.x2,o.yCategory=t.yCategory=s&&s[t.y],o},r.prototype.isValid=function(){return typeof this.x=="number"&&typeof this.x2=="number"},r}(ColumnSeries$2.prototype.pointClass);extend$2(XRangePoint.prototype,{tooltipDateKeys:["x","x2"]});var addEvent=Utilities.addEvent,pick$2=Utilities.pick;addEvent(Axis,"afterGetSeriesExtremes",function(){var n=this,r=n.series,t,o;n.isXAxis&&(t=pick$2(n.dataMax,-Number.MAX_VALUE),r.forEach(function(s){s.x2Data&&s.x2Data.forEach(function(a){a>t&&(t=a,o=!0)})}),o&&(n.dataMax=t))});var __extends$2=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),color=Color.parse,Series=SeriesRegistry$1.series,ColumnSeries$1=SeriesRegistry$1.seriesTypes.column,columnProto=ColumnSeries$1.prototype,clamp=Utilities.clamp,correctFloat=Utilities.correctFloat,defined=Utilities.defined,extend$1=Utilities.extend,find=Utilities.find,isNumber$1=Utilities.isNumber,isObject=Utilities.isObject,merge$1=Utilities.merge,pick$1=Utilities.pick,XRangeSeries=function(n){__extends$2(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.init=function(){ColumnSeries$1.prototype.init.apply(this,arguments),this.options.stacking=void 0},r.prototype.getColumnMetrics=function(){var t,o=this.chart;function s(){o.series.forEach(function(a){var l=a.xAxis;a.xAxis=a.yAxis,a.yAxis=l})}return s(),t=columnProto.getColumnMetrics.call(this),s(),t},r.prototype.cropData=function(t,o,s,a){var l=Series.prototype.cropData,h=l.call(this,this.x2Data,o,s,a);return h.xData=t.slice(h.start,h.end),h},r.prototype.findPointIndex=function(t){var o=this,s=o.cropped,a=o.cropStart,l=o.points,h=t.id,c;if(h){var d=find(l,function(p){return p.id===h});c=d?d.index:void 0}if(typeof c>"u"){var d=find(l,function(u){return u.x===t.x&&u.x2===t.x2&&!u.touched});c=d?d.index:void 0}return s&&isNumber$1(c)&&isNumber$1(a)&&c>=a&&(c-=a),c},r.prototype.translatePoint=function(t){var o=this,s=o.xAxis,a=o.yAxis,l=o.columnMetrics,h=o.options,c=h.minPointLength||0,d=(t.shapeArgs&&t.shapeArgs.width||0)/2,p=o.pointXOffset=l.offset,u=t.plotX,f=pick$1(t.x2,t.x+(t.len||0)),g=s.translate(f,0,0,0,1),v=Math.abs(g-u),m,x,y=this.chart.inverted,b=pick$1(h.borderWidth,1),$=b%2/2,S=l.offset,k=Math.round(l.width),A,P,E,M,T;c&&(m=c-v,m<0&&(m=0),u-=m/2,g+=m/2),u=Math.max(u,-10),g=clamp(g,-10,s.len+10),defined(t.options.pointWidth)&&(S-=(Math.ceil(t.options.pointWidth)-k)/2,k=Math.ceil(t.options.pointWidth)),h.pointPlacement&&isNumber$1(t.plotY)&&a.categories&&(t.plotY=a.translate(t.y,0,1,0,1,h.pointPlacement));var O=Math.floor(Math.min(u,g))+$,L=Math.floor(Math.max(u,g))+$,C={x:O,y:Math.floor(t.plotY+S)+$,width:L-O,height:k,r:o.options.borderRadius};t.shapeArgs=C,y?t.tooltipPos[1]+=p+d:t.tooltipPos[0]-=d+p-C.width/2,A=C.x,P=A+C.width,A<0||P>s.len?(A=clamp(A,0,s.len),P=clamp(P,0,s.len),E=P-A,t.dlBox=merge$1(C,{x:A,width:P-A,centerX:E?E/2:null})):t.dlBox=null;var U=t.tooltipPos,D=y?1:0,N=y?0:1;T=o.columnMetrics?o.columnMetrics.offset:-l.width/2,y?U[D]+=C.width/2:U[D]+=(s.reversed?-1:0)*C.width,U[N]=clamp(U[N]+(y?-1:1)*T,0,a.len-1),x=t.partialFill,x&&(isObject(x)&&(x=x.amount),isNumber$1(x)||(x=0),t.partShapeArgs=merge$1(C,{r:o.options.borderRadius}),M=Math.max(Math.round(v*x+t.plotX-u),0),t.clipRectArgs={x:s.reversed?C.x+v-M:C.x,y:C.y,width:M,height:C.height})},r.prototype.translate=function(){columnProto.translate.apply(this,arguments),this.points.forEach(function(t){this.translatePoint(t)},this)},r.prototype.drawPoint=function(t,o){var s=this,a=s.options,l=s.chart.renderer,h=t.graphic,c=t.shapeType,d=t.shapeArgs,p=t.partShapeArgs,u=t.clipRectArgs,f=t.partialFill,g=a.stacking&&!a.borderRadius,v=t.state,m=a.states[v||"normal"]||{},x=typeof v>"u"?"attr":o,y=s.pointAttribs(t,v),b=pick$1(s.chart.options.chart.animation,m.animation),$;!t.isNull&&t.visible!==!1?(h?h.rect[o](d):(t.graphic=h=l.g("point").addClass(t.getClassName()).add(t.group||s.group),h.rect=l[c](merge$1(d)).addClass(t.getClassName()).addClass("highcharts-partfill-original").add(h)),p&&(h.partRect?(h.partRect[o](merge$1(p)),h.partialClipRect[o](merge$1(u))):(h.partialClipRect=l.clipRect(u.x,u.y,u.width,u.height),h.partRect=l[c](p).addClass("highcharts-partfill-overlay").add(h).clip(h.partialClipRect))),s.chart.styledMode||(h.rect[o](y,b).shadow(a.shadow,null,g),p&&(isObject(f)||(f={}),isObject(a.partialFill)&&(f=merge$1(a.partialFill,f)),$=f.fill||color(y.fill).brighten(-.3).get()||color(t.color||s.color).brighten(-.3).get(),y.fill=$,h.partRect[x](y,b).shadow(a.shadow,null,g)))):h&&(t.graphic=h.destroy())},r.prototype.drawPoints=function(){var t=this,o=t.getAnimationVerb();t.points.forEach(function(s){t.drawPoint(s,o)})},r.prototype.getAnimationVerb=function(){return this.chart.pointCount<(this.options.animationLimit||250)?"animate":"attr"},r.prototype.isPointInside=function(t){var o=t.shapeArgs,s=t.plotX,a=t.plotY;if(!o)return n.prototype.isPointInside.apply(this,arguments);var l=typeof s<"u"&&typeof a<"u"&&a>=0&&a<=this.yAxis.len&&(o.x||0)+(o.width||0)>=0&&s<=this.xAxis.len;return l},r.defaultOptions=merge$1(ColumnSeries$1.defaultOptions,{colorByPoint:!0,dataLabels:{formatter:function(){var t=this.point,o=t.partialFill;if(isObject(o)&&(o=o.amount),isNumber$1(o)&&o>0)return correctFloat(o*100)+"%"},inside:!0,verticalAlign:"middle"},tooltip:{headerFormat:'<span style="font-size: 10px">{point.x} - {point.x2}</span><br/>',pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.yCategory}</b><br/>'},borderRadius:3,pointRange:0}),r}(ColumnSeries$1);extend$1(XRangeSeries.prototype,{type:"xrange",parallelArrays:["x","x2","y"],requireSorting:!1,animate:Series.prototype.animate,cropShoulder:1,getExtremesFromAll:!0,autoIncrement:H.noop,buildKDTree:H.noop,pointClass:XRangePoint});SeriesRegistry$1.registerSeriesType("xrange",XRangeSeries);var __extends$1=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),BulletPoint=function(n){__extends$1(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return r.prototype.destroy=function(){this.targetGraphic&&(this.targetGraphic=this.targetGraphic.destroy()),n.prototype.destroy.apply(this,arguments)},r}(ColumnSeries$h.prototype.pointClass),__extends=globalThis&&globalThis.__extends||function(){var n=function(r,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(o,s){o.__proto__=s}||function(o,s){for(var a in s)s.hasOwnProperty(a)&&(o[a]=s[a])},n(r,t)};return function(r,t){n(r,t);function o(){this.constructor=r}r.prototype=t===null?Object.create(t):(o.prototype=t.prototype,new o)}}(),ColumnSeries=SeriesRegistry$1.seriesTypes.column,extend=Utilities.extend,isNumber=Utilities.isNumber,merge=Utilities.merge,pick=Utilities.pick,relativeLength=Utilities.relativeLength,BulletSeries=function(n){__extends(r,n);function r(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t.targetData=void 0,t}return r.prototype.drawPoints=function(){var t=this,o=t.chart,s=t.options,a=s.animationLimit||250;n.prototype.drawPoints.apply(this,arguments),t.points.forEach(function(l){var h=l.options,c=l.target,d=l.y,p,u=l.targetGraphic,f,g,v,m;if(isNumber(c)&&c!==null){v=merge(s.targetOptions,h.targetOptions),g=v.height;var x=l.shapeArgs;l.dlBox&&x&&!isNumber(x.width)&&(x=l.dlBox),f=relativeLength(v.width,x.width),m=t.yAxis.translate(c,!1,!0,!1,!0)-v.height/2-.5,p=t.crispCol.apply({chart:o,borderWidth:v.borderWidth,options:{crisp:s.crisp}},[x.x+x.width/2-f/2,m,f,g]),u?(u[o.pointCount<a?"animate":"attr"](p),isNumber(d)&&d!==null?u.element.point=l:u.element.point=void 0):l.targetGraphic=u=o.renderer.rect().attr(p).add(t.group),o.styledMode||u.attr({fill:pick(v.color,h.color,t.zones.length&&(l.getZone.call({series:t,x:l.x,y:c,options:{}}).color||t.color)||void 0,l.color,t.color),stroke:pick(v.borderColor,l.borderColor,t.options.borderColor),"stroke-width":v.borderWidth,r:v.borderRadius}),isNumber(d)&&d!==null&&(u.element.point=l),u.addClass(l.getClassName()+" highcharts-bullet-target",!0)}else u&&(l.targetGraphic=u.destroy())})},r.prototype.getExtremes=function(t){var o=n.prototype.getExtremes.call(this,t),s=this,a=s.targetData;if(a&&a.length){var l=n.prototype.getExtremes.call(this,a);isNumber(l.dataMin)&&(o.dataMin=Math.min(pick(o.dataMin,1/0),l.dataMin)),isNumber(l.dataMax)&&(o.dataMax=Math.max(pick(o.dataMax,-1/0),l.dataMax))}return o},r.defaultOptions=merge(ColumnSeries.defaultOptions,{targetOptions:{width:"140%",height:3,borderWidth:0,borderRadius:0},tooltip:{pointFormat:'<span style="color:{series.color}">●</span> {series.name}: <b>{point.y}</b>. Target: <b>{point.target}</b><br/>'}}),r}(ColumnSeries);extend(BulletSeries.prototype,{parallelArrays:["x","y","target"],pointArrayMap:["y","target"]});BulletSeries.prototype.pointClass=BulletPoint;SeriesRegistry$1.registerSeriesType("bullet",BulletSeries);function inflateFunctions(config){if(Array.isArray(config)){config.forEach(inflateFunctions);return}!(config instanceof Object)||config.constructor!==Object||Object.entries(config).forEach(([attr,targetProperty])=>{if(attr.startsWith("_fn_")&&(typeof targetProperty=="string"||targetProperty instanceof String)){try{config[attr.substr(4)]=eval(`(${targetProperty})`)}catch(e){config[attr.substr(4)]=eval(`(function(){${targetProperty}})`)}delete config[attr]}else targetProperty instanceof Object&&inflateFunctions(targetProperty)})}/**
 * @license
 * Copyright (c) 2000 - 2023 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */class ChartSeries extends PolymerElement{static get is(){return"vaadin-chart-series"}static get properties(){return{values:{type:Array,value:()=>[]},valueMin:{type:Number,reflectToAttribute:!0},valueMax:{type:Number,reflectToAttribute:!0},type:{type:String,reflectToAttribute:!0},title:{type:String,reflectToAttribute:!0},markers:{type:String,reflectToAttribute:!0},unit:{type:String,reflectToAttribute:!0},stack:{type:String,reflectToAttribute:!0},neckPosition:{type:String,reflectToAttribute:!0},neckWidth:{type:String,reflectToAttribute:!0},options:{type:Object},additionalOptions:{type:Object,reflectToAttribute:!0},_series:{type:Object}}}static get observers(){return["__additionalOptionsObserver(additionalOptions.*, _series)","__markersObserver(markers, _series)","__neckPositionObserver(neckPosition, _series)","__neckWidthObserver(neckWidth, _series)","__stackObserver(stack, _series)","__titleObserver(title, _series)","__typeObserver(type, _series)","__unitObserver(unit, valueMin, valueMax, _series)","__valueMinObserver(valueMin, _series)","__valueMaxObserver(valueMax, _series)","__valuesObserver(values.splices, _series)"]}get options(){const r=deepMerge({},this.additionalOptions);return this.type&&(r.type=this.type),this.title&&(r.name=this.title),this.values&&(r.data=this.values),this.markers&&(this.__isMarkersValid()||(this.markers="auto"),r.marker=this.__markersConfiguration),this.unit&&(r.yAxis=this.unit),this.stack&&(r.stack=this.stack),isFinite(this.valueMin)&&(r.yAxisValueMin=this.valueMin),isFinite(this.valueMax)&&(r.yAxisValueMax=this.valueMax),this.neckWidth&&(r.neckWidth=this.neckWidth),this.neckPosition&&(r.neckHeight=this.neckPosition),r}get __markersConfiguration(){const r={};switch(this.markers){case"shown":r.enabled=!0;break;case"hidden":r.enabled=!1;break;case"auto":default:r.enabled=null;break}return r}setSeries(r){this._series=r}__valuesObserver(r,t){t&&t.setData(this.values)}__additionalOptionsObserver(r,t){t&&r.base&&t.update(r.base)}__updateAxis(r,t,o){if(!isFinite(t)){this.__showWarn(`value-${o}`,"Numbers or null");return}r&&r.yAxis&&r.yAxis.update({[o]:t})}__valueMinObserver(r,t){r===void 0||t===void 0||this.__updateAxis(t,r,"min")}__valueMaxObserver(r,t){r===void 0||t===void 0||this.__updateAxis(t,r,"max")}__typeObserver(r,t){r&&t&&t.update({type:r})}__titleObserver(r,t){r===void 0||t===void 0||t.update({name:r})}__stackObserver(r,t){r===void 0||t===void 0||t.update({stack:r})}__neckPositionObserver(r,t){r===void 0||t===void 0||t.update({neckHeight:r})}__neckWidthObserver(r,t){r===void 0||t===void 0||t.update({neckWidth:r})}__unitObserver(r,t,o,s){if(s&&r!==this.__oldUnit){this.__oldUnit=r;const a=this.parentNode instanceof Chart&&this.parentNode;if(a&&a instanceof Chart){if(r&&!a.__getAxis(r)){const l={title:{text:r}};a.__addAxis({id:r,axisGenerated:!0,...l})}s.update({yAxis:r||0}),t!==void 0&&this.__updateAxis(s,t,"min"),o!==void 0&&this.__updateAxis(s,o,"max"),a.__removeAxisIfEmpty()}}}__isMarkersValid(){return["shown","hidden","auto"].indexOf(this.markers)===-1?(this.__showWarn("markers",'"shown", "hidden" or "auto"'),!1):!0}__markersObserver(r,t){if(!(r===void 0||t===void 0)){if(!this.__isMarkersValid()){this.markers="auto";return}t.update({marker:this.__markersConfiguration})}}__showWarn(r,t){console.warn(`<vaadin-chart-series> Acceptable values for "${r}" are ${t}`)}}defineCustomElement(ChartSeries);/**
 * @license
 * Copyright (c) 2000 - 2023 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */function deepMerge(n,r){const t=o=>o&&typeof o=="object"&&!Array.isArray(o);return t(r)&&t(n)&&Object.keys(r).forEach(o=>{t(r[o])?(n[o]||Object.assign(n,{[o]:{}}),deepMerge(n[o],r[o])):Object.assign(n,{[o]:r[o]})}),n}["exportChart","exportChartLocal","getSVG"].forEach(n=>{G$7.wrap(G$7.Chart.prototype,n,function(r,...t){G$7.fireEvent(this,"beforeExport");const o=r.apply(this,t);return G$7.fireEvent(this,"afterExport"),o})});G$7.setOptions({lang:{noData:""}});class Chart extends ResizeMixin(ElementMixin(ThemableMixin(PolymerElement))){static get template(){return html`
      <style>
        :host {
          display: block;
          width: 100%;
          overflow: hidden;
        }

        :host([hidden]) {
          display: none !important;
        }
      </style>
      <div id="chart"></div>
      <slot id="slot"></slot>
    `}static get is(){return"vaadin-chart"}static get cvdlName(){return"vaadin-chart"}static get properties(){return{configuration:Object,categories:{type:Object,reflectToAttribute:!0},categoryMax:{type:Number,reflectToAttribute:!0},categoryMin:{type:Number,reflectToAttribute:!0},categoryPosition:{type:String,reflectToAttribute:!0},noLegend:{type:Boolean,reflectToAttribute:!0},stacking:{type:String,reflectToAttribute:!0},timeline:{type:Boolean,reflectToAttribute:!0},title:{type:String,reflectToAttribute:!0},tooltip:{type:Boolean,reflectToAttribute:!0},type:{type:String,reflectToAttribute:!0},subtitle:{type:String,reflectToAttribute:!0},chart3d:{type:Boolean,reflectToAttribute:!0},emptyText:{type:String,reflectToAttribute:!0},additionalOptions:{type:Object,reflectToAttribute:!0},polar:{type:Boolean,reflectToAttribute:!0}}}static get observers(){return["__chart3dObserver(chart3d, configuration)","__emptyTextObserver(emptyText, configuration)","__hideLegend(noLegend, configuration)","__polarObserver(polar, configuration)","__stackingObserver(stacking, configuration)","__tooltipObserver(tooltip, configuration)","__updateCategories(categories, configuration)","__updateCategoryMax(categoryMax, configuration)","__updateCategoryMin(categoryMin, configuration)","__updateCategoryPosition(categoryPosition, configuration)","__updateSubtitle(subtitle, configuration)","__updateTitle(title, configuration)","__updateType(type, configuration)","__updateAdditionalOptions(additionalOptions.*)"]}static __callHighchartsFunction(r,t,...o){const s=G$7[r];s&&typeof s=="function"&&(o.forEach(a=>inflateFunctions(a)),s.apply(this.configuration,o),t&&G$7.charts.forEach(a=>a.redraw()))}constructor(){super(),this._baseConfig={annotations:[],chart:{styledMode:!0},credits:{enabled:!1},exporting:{enabled:!1},title:{text:null},series:[],xAxis:{},yAxis:{axisGenerated:!0}},this._baseChart3d={enabled:!0,alpha:15,beta:15,depth:50}}get options(){const r={...this._baseConfig};return deepMerge(r,this.additionalOptions),this.type&&(r.chart.type=this.type),this.polar&&(r.chart.polar=!0),this.title&&(r.title={text:this.title}),r.tooltip||(r.tooltip={},this.tooltip||(r.tooltip.enabled=!1)),this.subtitle&&(r.subtitle={text:this.subtitle}),this.categories&&(Array.isArray(r.xAxis)?r.xAxis[0].categories=this.categories:r.xAxis.categories=this.categories),isFinite(this.categoryMin)&&(Array.isArray(r.xAxis)?r.xAxis[0].min=this.categoryMin:r.xAxis.min=this.categoryMin),isFinite(this.categoryMax)&&(Array.isArray(r.xAxis)?r.xAxis[0].max=this.categoryMax:r.xAxis.max=this.categoryMax),this.noLegend&&(r.legend={enabled:!1}),this.emptyText&&(r.lang||(r.lang={}),r.lang.noData=this.emptyText),this.categoryPosition&&(r.chart.inverted=this.__shouldInvert(),Array.isArray(r.xAxis)?r.xAxis.forEach(t=>{t.opposite=this.__shouldFlipOpposite()}):r.xAxis&&(r.xAxis.opposite=this.__shouldFlipOpposite())),this.stacking&&(r.plotOptions||(r.plotOptions={}),r.plotOptions.series||(r.plotOptions.series={}),r.plotOptions.series.stacking=this.stacking),this.chart3d&&(r.chart.options3d={...this._baseChart3d,...r.chart.options3d}),r}get __chartEventNames(){return{addSeries:"chart-add-series",afterExport:"chart-after-export",afterPrint:"chart-after-print",beforeExport:"chart-before-export",beforePrint:"chart-before-print",click:"chart-click",drilldown:"chart-drilldown",drillup:"chart-drillup",drillupall:"chart-drillupall",load:"chart-load",redraw:"chart-redraw",selection:"chart-selection"}}get __seriesEventNames(){return{afterAnimate:"series-after-animate",checkboxClick:"series-checkbox-click",click:"series-click",hide:"series-hide",legendItemClick:"series-legend-item-click",mouseOut:"series-mouse-out",mouseOver:"series-mouse-over",show:"series-show"}}get __pointEventNames(){return{click:"point-click",legendItemClick:"point-legend-item-click",mouseOut:"point-mouse-out",mouseOver:"point-mouse-over",remove:"point-remove",select:"point-select",unselect:"point-unselect",update:"point-update"}}get __xAxesEventNames(){return{afterSetExtremes:"xaxes-extremes-set"}}get __yAxesEventNames(){return{afterSetExtremes:"yaxes-extremes-set"}}connectedCallback(){super.connectedCallback(),this.__updateStyles(),beforeNextRender(this,()=>{if(this.configuration){this.__reflow();return}const r={...this.options,...this._jsonConfigurationBuffer};this._jsonConfigurationBuffer=null,this.__initChart(r),this.__addChildObserver(),this.__checkTurboMode()})}ready(){super.ready(),this.addEventListener("chart-redraw",this.__onRedraw.bind(this))}_onResize(r){if(!this.configuration)return;const{height:t,width:o}=r,{chartHeight:s,chartWidth:a}=this.configuration;(t!==s||o!==a)&&this.__reflow()}__reflow(){this.configuration&&this.configuration.reflow()}__addChildObserver(){this._childObserver=new FlattenedNodesObserver(this.$.slot,r=>{this.__addSeries(r.addedNodes.filter(this.__filterSeriesNodes)),this.__removeSeries(r.removedNodes.filter(this.__filterSeriesNodes)),this.__cleanupAfterSeriesRemoved(r.removedNodes.filter(this.__filterSeriesNodes))})}__filterSeriesNodes(r){return r.nodeType===Node.ELEMENT_NODE&&r instanceof ChartSeries}__addSeries(r){if(this.__isSeriesEmpty(r))return;const t=Array.from(this.childNodes).filter(this.__filterSeriesNodes),o=this.configuration.yAxis.reduce((s,a,l)=>(s[a.options.id||l]=a,s),{});for(let s=0,a=r.length;s<a;s++){const l=r[s],{yAxis:h,yAxisValueMin:c,yAxisValueMax:d}=l.options,p=t.indexOf(l);!h&&!this.configuration.yAxis.some(f=>f.userOptions.id===void 0)?o[h]=this.__addAxis({axisGenerated:!0}):h&&!o[h]&&(o[h]=this.__addAxis({id:h,title:{text:h},axisGenerated:!0})),isFinite(c)&&this.__setYAxisProps(o,h,{min:c}),isFinite(d)&&this.__setYAxisProps(o,h,{max:d});const u=this.__updateOrAddSeriesInstance(l.options,p,!1);l.setSeries(u)}this.__removeAxisIfEmpty(),this.configuration.redraw()}__removeSeries(r){this.__isSeriesEmpty(r)||r.forEach(t=>{t instanceof ChartSeries&&t._series.remove()})}__setYAxisProps(r,t,o){t?r[t].update(o):this.configuration.yAxis[0].update(o)}__isSeriesEmpty(r){return r===null||r.length===0}__cleanupAfterSeriesRemoved(r){this.__isSeriesEmpty(r)||(this.__removeAxisIfEmpty(),this.__updateNoDataElement(this.configuration))}__initChart(r){this.__initEventsListeners(r),this.__updateStyledMode(r),this.timeline?this.configuration=G$7.stockChart(this.$.chart,r):this.configuration=G$7.chart(this.$.chart,r)}__updateStyledMode(r){const t=r.chart.styledMode;this.$.chart.toggleAttribute("styled-mode",!!t)}disconnectedCallback(){super.disconnectedCallback(),this._childObserver&&this._childObserver.disconnect()}__getAxis(r,t){if(r=Number.parseInt(r)||r,this.configuration)return(t?this.configuration.xAxis:this.configuration.yAxis).find(o=>o.options.id===r)}__addAxis(r,t){if(this.configuration)return this.__createEventListeners(t?this.__xAxesEventNames:this.__yAxesEventNames,r,"events","axis"),this.configuration.addAxis(r,t)}__removeAxisIfEmpty(r){this.configuration&&(r?this.configuration.xAxis:this.configuration.yAxis).forEach(t=>{t.userOptions.axisGenerated&&t.series.length===0&&t.remove()})}updateConfiguration(r,t){(t||!this._jsonConfigurationBuffer)&&(this._jsonConfigurationBuffer={});const o=deepMerge({},r);inflateFunctions(o),this._jsonConfigurationBuffer=this.__makeConfigurationBuffer(this._jsonConfigurationBuffer,o),beforeNextRender(this,()=>{if(!(!this.configuration||!this._jsonConfigurationBuffer)){if(t){const s={...this.options,...this._jsonConfigurationBuffer};this.__initChart(s),this._jsonConfigurationBuffer=null;return}this.configuration.update(this._jsonConfigurationBuffer,!1),this._jsonConfigurationBuffer.credits&&this.__updateOrAddCredits(this._jsonConfigurationBuffer.credits),this._jsonConfigurationBuffer.xAxis&&this.__updateOrAddAxes(this._jsonConfigurationBuffer.xAxis,!0,!1),this._jsonConfigurationBuffer.yAxis&&this.__updateOrAddAxes(this._jsonConfigurationBuffer.yAxis,!1,!1),this._jsonConfigurationBuffer.series&&this.__updateOrAddSeries(this._jsonConfigurationBuffer.series,!1),this._jsonConfigurationBuffer=null,this.configuration.redraw()}})}__makeConfigurationBuffer(r,t){const o=G$7.merge(t),s=G$7.merge(r);return this.__mergeConfigurationArray(s,o,"series"),this.__mergeConfigurationArray(s,o,"xAxis"),this.__mergeConfigurationArray(s,o,"yAxis"),G$7.merge(s,o)}__mergeConfigurationArray(r,t,o){if(!t||!t[o]||!Array.isArray(t[o]))return;if(!r[o]){r[o]=Array.from(t[o]);return}const s=Math.max(r[o].length,t[o].length);for(let a=0;a<s;a++)r[o][a]=G$7.merge(r[o][a],t[o][a]);delete t[o]}__initEventsListeners(r){this.__initChartEventsListeners(r),this.__initSeriesEventsListeners(r),this.__initPointsEventsListeners(r),this.__initAxisEventsListeners(r,!0),this.__initAxisEventsListeners(r,!1)}__initChartEventsListeners(r){this.__createEventListeners(this.__chartEventNames,r,"chart.events","chart")}__initSeriesEventsListeners(r){this.__createEventListeners(this.__seriesEventNames,r,"plotOptions.series.events","series")}__initPointsEventsListeners(r){this.__createEventListeners(this.__pointEventNames,r,"plotOptions.series.point.events","point")}__initAxisEventsListeners(r,t){let o,s;t?(o=this.__xAxesEventNames,s=r.xAxis):(o=this.__yAxesEventNames,s=r.yAxis),Array.isArray(s)?s.forEach(a=>this.__createEventListeners(o,a,"events","axis")):this.__createEventListeners(o,s,"events","axis")}__createEventListeners(r,t,o,s){const a=this.__ensureObjectPath(t,o);for(let l=Object.keys(r),h=0;h<l.length;h++){const c=l[h];a[c]||(a[c]=d=>{const p={bubbles:!1,composed:!0,detail:{originalEvent:d,[s]:d.target}};if(!(d.type==="afterSetExtremes"&&(d.min==null||d.max==null))){if(d.type==="selection"&&(d.xAxis&&d.xAxis[0]&&(p.detail.xAxisMin=d.xAxis[0].min,p.detail.xAxisMax=d.xAxis[0].max),d.yAxis&&d.yAxis[0]&&(p.detail.yAxisMin=d.yAxis[0].min,p.detail.yAxisMax=d.yAxis[0].max)),d.type==="click"&&(d.xAxis&&d.xAxis[0]&&(p.detail.xValue=d.xAxis[0].value),d.yAxis&&d.yAxis[0]&&(p.detail.yValue=d.yAxis[0].value)),["beforePrint","beforeExport"].indexOf(d.type)>=0&&!this.tempBodyStyle){let u="";[...this.shadowRoot.querySelectorAll("style")].forEach(f=>{u+=f.textContent}),u=u.replace(/:host\(.+?\)/gu,f=>{const g=f.substr(6,f.length-7);return this.matches(g)?"":f}),u=`${u}body {    -moz-transform: scale(0.9, 0.9);    zoom: 0.9;    zoom: 90%;}`,this.tempBodyStyle=document.createElement("style"),this.tempBodyStyle.textContent=u,document.body.appendChild(this.tempBodyStyle),this.options.chart.styledMode&&document.body.setAttribute("styled-mode","")}if(["afterPrint","afterExport"].indexOf(d.type)>=0&&this.tempBodyStyle&&(document.body.removeChild(this.tempBodyStyle),delete this.tempBodyStyle,this.options.chart.styledMode&&document.body.removeAttribute("styled-mode")),this.dispatchEvent(new CustomEvent(r[c],p)),d.type==="legendItemClick"&&this._visibilityTogglingDisabled)return!1}})}}__ensureObjectPath(r,t){if(typeof t=="string")return t=t.split("."),t.reduce((o,s)=>(o[s]||(o[s]={}),o[s]),r)}__updateOrAddCredits(r){this.configuration.credits?this.configuration.credits.update(r):this.configuration.addCredits(r)}__updateOrAddAxes(r,t,o){Array.isArray(r)||(r=[r]);const s=t?this.configuration.xAxis:this.configuration.yAxis;for(let a=0;a<r.length;a++){const l=r[a];s[a]?s[a].update(l,o):this.configuration.addAxis(l,t,o)}}__updateOrAddSeries(r,t){if(!Array.isArray(r))throw new Error("The type of jsonConfiguration.series should be Object[]");for(let o=0;o<r.length;o++){const s=r[o];this.__updateOrAddSeriesInstance(s,o,t)}}__updateOrAddSeriesInstance(r,t,o){return this.configuration.series[t]?this.configuration.series[t].update(r,o):this.configuration.addSeries(r,o),this.configuration.series[t]}__updateCategories(r,t){r===void 0||!t||this.__updateOrAddAxes([{categories:r}],!0)}__updateCategoryMax(r,t){if(!(r===void 0||!t)){if(!isFinite(r)){console.warn('<vaadin-chart> Acceptable value for "category-max" are Numbers or null');return}this.__updateOrAddAxes([{max:r}],!0)}}__updateCategoryMin(r,t){if(!(r===void 0||!t)){if(!isFinite(r)){console.warn('<vaadin-chart> Acceptable value for "category-min" are Numbers or null');return}this.__updateOrAddAxes([{min:r}],!0)}}__shouldInvert(){if(this.type==="bar"&&["top","bottom"].indexOf(this.categoryPosition)>=0){console.warn(`<vaadin-chart> Acceptable "category-position" values for bar charts are
          "left" and "right". For "top" and "bottom" positions please consider using a column chart.`);return}return["left","right"].indexOf(this.categoryPosition)>=0}__shouldFlipOpposite(){const r=["top","right"],t=["right"];return(this.type==="bar"?t:r).indexOf(this.categoryPosition)>=0}__updateCategoryPosition(r,t){if(r===void 0||!t)return;const o=["left","right","top","bottom"];if(o.indexOf(r)<0){console.warn(`<vaadin-chart> Acceptable "category-position" values are ${o}`);return}t.update({chart:{inverted:this.__shouldInvert()}}),t.xAxis.forEach(s=>s.update({opposite:this.__shouldFlipOpposite()}))}__hideLegend(r,t){r===void 0||!t||(t.legend?t.legend.update({enabled:!r}):t.legend={enabled:!r})}__updateTitle(r,t){r===void 0||!t||r&&r.length>0&&t.title.update({text:r})}__tooltipObserver(r,t){r===void 0||!t||t.tooltip.update({enabled:r})}__updateType(r,t){r===void 0||!t||r&&r.length>0&&t.update({chart:{type:r}})}__updateSubtitle(r,t){r===void 0||!t||r&&r.length>0&&(t.subtitle?t.subtitle.update({text:r}):t.setSubtitle({text:r}))}__updateAdditionalOptions(r){this.configuration&&r.base&&this.updateConfiguration(r.base)}__isStackingValid(){return["normal","percent",null].indexOf(this.stacking)===-1?(this.__showWarn("stacking",'"normal", "percent" or null'),!1):!0}__stackingObserver(r,t){if(!(r===void 0||!t)){if(!this.__isStackingValid()){this.stacking=null;return}t.update({plotOptions:{series:{stacking:r}}})}}__chart3dObserver(r,t){r===void 0||!t||(r?t.update({chart:{options3d:{...this._baseChart3d,...this.additionalOptions&&this.additionalOptions.chart&&this.additionalOptions.chart.options3d,enabled:!0}}}):t.update({chart:{options3d:{enabled:!1}}}))}__polarObserver(r,t){r===void 0||!t||t.update({chart:{polar:r}})}__emptyTextObserver(r,t){r===void 0||!t||(t.update({lang:{noData:r}}),this.__updateNoDataElement(t))}__updateNoDataElement(r){r.series.every(o=>o.data.length===0)&&(r.hideNoData(),r.showNoData(this.emptyText))}__callChartFunction(r,...t){if(this.configuration){const o=this.configuration[r];o&&typeof o=="function"&&(t.forEach(s=>inflateFunctions(s)),o.apply(this.configuration,t))}}__callSeriesFunction(r,t,...o){if(this.configuration&&this.configuration.series[t]){const s=this.configuration.series[t],a=s[r];a&&typeof a=="function"&&(o.forEach(l=>inflateFunctions(l)),a.apply(s,o))}}__callAxisFunction(r,t,o,...s){if(this.configuration){let a;switch(t){case 0:a=this.configuration.xAxis;break;case 1:a=this.configuration.yAxis;break;case 2:a=this.configuration.zAxis;break;case 3:a=this.configuration.colorAxis;break}if(a&&a[o]){const l=a[o],h=l[r];h&&typeof h=="function"&&(s.forEach(c=>inflateFunctions(c)),h.apply(l,s))}}}__callPointFunction(r,t,o,...s){if(this.configuration&&this.configuration.series[t]&&this.configuration.series[t].data[o]){const a=this.configuration.series[t].data[o],l=a[r];l&&typeof l=="function"&&l.apply(a,s)}}__updateStyles(){if(getComputedStyle(this).flex!=="0 1 auto"){this.$.chart.setAttribute("style","flex: 1; ");let t="";this.hasAttribute("style")&&(t=this.getAttribute("style"),t.endsWith(";")||(t+=";")),t+="display: flex;",this.setAttribute("style",t)}else this.$.chart.setAttribute("style","height:100%; width:100%;")}__showWarn(r,t){console.warn(`<vaadin-chart> Acceptable values for "${r}" are ${t}`)}__onRedraw(){this.__checkTurboMode()}__checkTurboMode(){const r=!!window.Vaadin.developmentMode;if(!this.configuration||!r||this.__turboModeWarningAlreadyLogged)return;this.configuration.series.some(o=>{const s=o.options&&o.options.turboThreshold||0,a=o.data.length;return s>0&&a>s})&&(this.__turboModeWarningAlreadyLogged=!0,console.warn("<vaadin-chart> Turbo mode has been enabled for one or more series, because the number of data items exceeds the configured threshold. Turbo mode improves the performance of charts with lots of data, but is not compatible with every type of series. Please consult the documentation on compatibility, or how to disable turbo mode."))}}defineCustomElement(Chart)});export default ft();
