var ft=(o,r)=>()=>(r||o((r={exports:{}}).exports,r),r.exports);import{w as wrap$e,m as microTask,c as calculateSplices,P as PolymerElement,R as ResizeMixin,E as ElementMixin,h as html,b as beforeNextRender,g as get}from"./generated-flow-imports-9NHy_Tjj.js";import{i,a as registerStyles,d as defineCustomElement,T as ThemableMixin}from"./indexhtml-J05yU9YY.js";var pt=ft(exports=>{/**
 * @license
 * Copyright (c) 2000 - 2024 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */const chartBaseTheme=i`
  :host {
    font-family: -apple-system, BlinkMacSystemFont, 'Roboto', 'Segoe UI', Helvetica, Arial, sans-serif,
      'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol';
    font-size: 12px;
    line-height: normal;
  }

  .highcharts-container {
    position: relative;
    overflow: hidden;
    width: 100%;
    height: 100%;
    text-align: left;
    z-index: 0;
    /* #1072 */
    -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
  }

  :where([styled-mode]) .highcharts-root {
    display: block;
  }

  :where([styled-mode]) .highcharts-root text {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-strong {
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-emphasized {
    font-style: italic;
  }

  :where([styled-mode]) .highcharts-anchor {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-background {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-plot-border,
  :where([styled-mode]) .highcharts-plot-background {
    fill: none;
  }

  :where([styled-mode]) .highcharts-label-box {
    fill: none;
  }

  :where([styled-mode]) .highcharts-button-box {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-tracker-line {
    stroke-linejoin: round;
    stroke: rgba(192, 192, 192, 0.0001);
    stroke-width: 22;
    fill: none;
  }

  :where([styled-mode]) .highcharts-tracker-area {
    fill: rgba(192, 192, 192, 0.0001);
    stroke-width: 0;
  }

  /* Titles */
  :where([styled-mode]) .highcharts-title {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
    font-size: 1.5em;
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-subtitle {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  /* Axes */
  :where([styled-mode]) .highcharts-axis-line {
    fill: none;
    stroke: var(--vaadin-charts-axis-line, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-axis-title {
    fill: var(--vaadin-charts-axis-title, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-axis-labels {
    fill: var(--vaadin-charts-axis-label, hsla(214, 42%, 18%, 0.72));
    cursor: default;
    font-size: 0.9em;
  }

  :where([styled-mode]) .highcharts-grid-line {
    fill: none;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-xaxis-grid .highcharts-grid-line {
    stroke-width: var(--vaadin-charts-xaxis-line-width, 0px);
  }

  :where([styled-mode]) .highcharts-tick {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-tick {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-minor-grid-line {
    stroke: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-crosshair-thin {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-crosshair-category {
    stroke: var(--vaadin-charts-color-0, #5ac2f7);
    stroke-opacity: 0.25;
  }

  /* Credits */
  :where([styled-mode]) .highcharts-credits {
    cursor: pointer;
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
    font-size: 0.7em;
    transition: fill 250ms, font-size 250ms;
  }

  :where([styled-mode]) .highcharts-credits:hover {
    fill: black;
    font-size: 1em;
  }

  /* Tooltip */
  :where([styled-mode]) .highcharts-tooltip {
    cursor: default;
    pointer-events: none;
    white-space: nowrap;
    transition: stroke 150ms;
  }

  :where([styled-mode]) .highcharts-tooltip {
    filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.05)) !important;
  }

  :where([styled-mode]) .highcharts-tooltip text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-tooltip .highcharts-header {
    font-size: 0.85em;
    color: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-tooltip-box {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-tooltip-border, inherit);
    fill: var(--vaadin-charts-tooltip-background, #fff);
    fill-opacity: var(--vaadin-charts-tooltip-background-opacity, 1);
  }

  :where([styled-mode]) .highcharts-tooltip-box .highcharts-label-box {
    fill: var(--vaadin-charts-tooltip-background, #fff);
    fill-opacity: var(--vaadin-charts-tooltip-background-opacity, 1);
  }

  :where([styled-mode]) .highcharts-tooltip-header {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) div.highcharts-tooltip {
    filter: none;
  }

  :where([styled-mode]) .highcharts-selection-marker {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    fill-opacity: 0.25;
  }

  :where([styled-mode]) .highcharts-graph {
    fill: none;
    stroke-width: 2px;
    stroke-linecap: round;
    stroke-linejoin: round;
  }

  :where([styled-mode]) .highcharts-state-hover .highcharts-graph {
    stroke-width: 3;
  }

  :where([styled-mode]) .highcharts-point-inactive {
    opacity: 0.2;
    transition: opacity 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-series-inactive {
    opacity: 0.2;
    transition: opacity 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-state-hover path {
    transition: stroke-width 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-state-normal path {
    transition: stroke-width 250ms;
    /* slow out */
  }

  /* Legend hover affects points and series */
  :where([styled-mode]) g.highcharts-series,
  :where([styled-mode]) .highcharts-point,
  :where([styled-mode]) .highcharts-markers,
  :where([styled-mode]) .highcharts-data-labels {
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-legend-series-active g.highcharts-series:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-point-active .highcharts-point:not(.highcharts-point-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-markers:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-data-labels:not(.highcharts-series-hover) {
    opacity: 0.2;
  }

  /* Series options */
  /* Default colors */
  /* vaadin-charts custom properties */
  /* Use of :where() function to avoid setting classes with high specificity */
  :where([styled-mode]) .highcharts-color-0 {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    stroke: var(--vaadin-charts-color-0, #5ac2f7);
  }

  :where([styled-mode]) .highcharts-color-1 {
    fill: var(--vaadin-charts-color-1, #1676f3);
    stroke: var(--vaadin-charts-color-1, #1676f3);
  }

  :where([styled-mode]) .highcharts-color-2 {
    fill: var(--vaadin-charts-color-2, #ff7d94);
    stroke: var(--vaadin-charts-color-2, #ff7d94);
  }

  :where([styled-mode]) .highcharts-color-3 {
    fill: var(--vaadin-charts-color-3, #c5164e);
    stroke: var(--vaadin-charts-color-3, #c5164e);
  }

  :where([styled-mode]) .highcharts-color-4 {
    fill: var(--vaadin-charts-color-4, #15c15d);
    stroke: var(--vaadin-charts-color-4, #15c15d);
  }

  :where([styled-mode]) .highcharts-color-5 {
    fill: var(--vaadin-charts-color-5, #0e8151);
    stroke: var(--vaadin-charts-color-5, #0e8151);
  }

  :where([styled-mode]) .highcharts-color-6 {
    fill: var(--vaadin-charts-color-6, #c18ed2);
    stroke: var(--vaadin-charts-color-6, #c18ed2);
  }

  :where([styled-mode]) .highcharts-color-7 {
    fill: var(--vaadin-charts-color-7, #9233b3);
    stroke: var(--vaadin-charts-color-7, #9233b3);
  }

  :where([styled-mode]) .highcharts-color-8 {
    fill: var(--vaadin-charts-color-8, #fda253);
    stroke: var(--vaadin-charts-color-8, #fda253);
  }

  :where([styled-mode]) .highcharts-color-9 {
    fill: var(--vaadin-charts-color-9, #e24932);
    stroke: var(--vaadin-charts-color-9, #e24932);
  }

  /* end of vaadin-charts custom properties */

  :where([styled-mode]) .highcharts-area {
    fill-opacity: 0.5;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-markers {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode])
    .highcharts-a11y-markers-hidden
    .highcharts-point:not(.highcharts-point-hover):not(.highcharts-a11y-marker-visible),
  :where([styled-mode]) .highcharts-a11y-marker-hidden {
    opacity: 0;
  }

  :where([styled-mode]) .highcharts-point {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-dense-data .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label {
    font-size: 0.9em;
    font-weight: normal;
  }

  :where([styled-mode]) .highcharts-data-label-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label text,
  :where([styled-mode]) text.highcharts-data-label {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-data-label-connector {
    fill: none;
  }

  :where([styled-mode]) .highcharts-data-label-hidden {
    pointer-events: none;
  }

  :where([styled-mode]) .highcharts-halo {
    fill-opacity: 0.25;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-series:not(.highcharts-pie-series) .highcharts-point-select,
  :where([styled-mode]) .highcharts-markers .highcharts-point-select {
    fill: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-column-series rect.highcharts-point {
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point {
    transition: fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-solidgauge-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point {
    stroke-width: 2px;
    stroke: var(--vaadin-charts-background, #fff);
    transition: stroke 250ms, fill 250ms, fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point-hover {
    stroke-width: 0px;
    stroke: var(--vaadin-charts-background, #fff);
    fill-opacity: 0.75;
    transition: stroke 25ms, fill 25ms, fill-opacity 25ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-above-level {
    display: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node {
    fill: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive {
    fill-opacity: 0.15;
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive:hover {
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-vector-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-windbarb-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-lollipop-stem {
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-focus-border {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-legend-item-hidden .highcharts-focus-border {
    fill: none !important;
  }

  /* Legend */
  :where([styled-mode]) .highcharts-legend-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    font-weight: normal;
    font-size: 1em;
    cursor: pointer;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > .highcharts-point {
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-legend-item:hover text {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-legend-item-hidden * {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26)) !important;
    stroke: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26)) !important;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-legend-nav-active {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-legend-nav-inactive {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
  }

  :where([styled-mode]) circle.highcharts-legend-nav-active,
  :where([styled-mode]) circle.highcharts-legend-nav-inactive {
    /* tracker */
    fill: rgba(192, 192, 192, 0.0001);
  }

  :where([styled-mode]) .highcharts-legend-title-box {
    fill: none;
    stroke-width: 0;
  }

  /* Bubble legend */
  :where([styled-mode]) .highcharts-bubble-legend-symbol {
    stroke-width: 2;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-bubble-legend-connectors {
    stroke-width: 1;
  }

  :where([styled-mode]) .highcharts-bubble-legend-labels {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  /* Loading */
  :where([styled-mode]) .highcharts-loading {
    position: absolute;
    background-color: var(--vaadin-charts-background, #fff);
    opacity: 0.5;
    text-align: center;
    z-index: 10;
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-loading-hidden {
    height: 0 !important;
    opacity: 0;
    overflow: hidden;
    transition: opacity 250ms, height 250ms step-end;
  }

  :where([styled-mode]) .highcharts-loading-inner {
    font-weight: normal;
    position: relative;
    top: 45%;
  }

  /* Plot bands and polar pane backgrounds */
  :where([styled-mode]) .highcharts-plot-band,
  :where([styled-mode]) .highcharts-pane {
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-plot-line {
    fill: none;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-plot-line-label {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  /* Highcharts More and modules */
  :where([styled-mode]) .highcharts-boxplot-box {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-boxplot-median {
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-bubble-series .highcharts-point {
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-errorbar-series .highcharts-point {
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-data-label-box {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-dial {
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-polygon-series .highcharts-graph {
    fill: inherit;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-waterfall-series .highcharts-graph {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-dasharray: 1, 3;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-link {
    transition: fill 250ms, fill-opacity 250ms;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point-hover.highcharts-link {
    transition: fill 50ms, fill-opacity 50ms;
    fill-opacity: 1;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point {
    fill-opacity: 0.75;
    stroke: var(--vaadin-charts-background, #fff);
    transition: stroke 250ms, fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point-hover {
    fill-opacity: 1;
    stroke: var(--vaadin-charts-background, #fff);
  }

  /* Highstock */
  :where([styled-mode]) .highcharts-navigator-mask-outside {
    fill-opacity: 0;
  }

  :where([styled-mode]) .highcharts-navigator-mask-inside {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    /* navigator.maskFill option */
    fill-opacity: 0.2;
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-outline {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    fill: none;
  }

  :where([styled-mode]) .highcharts-navigator-handle {
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
    fill: var(--vaadin-charts-background, #fff);
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-series {
    fill: var(--vaadin-charts-color-1, #1676f3);
    stroke: var(--vaadin-charts-color-1, #1676f3);
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-graph {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-area {
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-grid-line {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-navigator-xaxis.highcharts-axis-labels {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-navigator-yaxis .highcharts-grid-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-scrollbar-thumb {
    fill: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-scrollbar-button {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-scrollbar-arrow {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-scrollbar-rifles {
    stroke: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-scrollbar-track {
    fill: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-button {
    fill: var(--vaadin-charts-button-background, hsla(214, 61%, 25%, 0.05));
    cursor: default;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-button text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-button-hover {
    transition: fill 0ms;
    fill: var(--vaadin-charts-button-hover-background, hsla(214, 90%, 52%, 0.1));
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-button-hover text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-button-pressed {
    fill: var(--vaadin-charts-button-active-background, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-button-pressed text {
    fill: var(--vaadin-charts-button-active-label, #fff);
  }

  :where([styled-mode]) .highcharts-button-disabled text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-range-selector-buttons > text {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-range-selector-buttons .highcharts-button {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-range-label rect {
    fill: none;
  }

  :where([styled-mode]) .highcharts-range-label text {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-range-input rect {
    fill: var(--vaadin-charts-contrast-10pct, hsla(214, 57%, 24%, 0.1));
    rx: 2;
    ry: 2;
  }

  :where([styled-mode]) .highcharts-range-input:hover rect {
    fill: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-range-input text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) input.highcharts-range-selector {
    position: absolute;
    border: 0;
    width: 1px;
    /* Chrome needs a pixel to see it */
    height: 1px;
    padding: 0;
    text-align: center;
    left: -9em;
    /* #4798 */
  }

  :where([styled-mode]) .highcharts-crosshair-label text {
    fill: var(--vaadin-charts-background, #fff);
    font-size: 1.1em;
  }

  :where([styled-mode]) .highcharts-crosshair-label .highcharts-label-box {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-up {
    fill: var(--vaadin-charts-color-positive, #15c15d);
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-down {
    fill: var(--vaadin-charts-color-negative, #e24932);
  }

  :where([styled-mode]) .highcharts-ohlc-series .highcharts-point-hover {
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point .highcharts-label-box {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    fill: var(--vaadin-charts-background, #fff);
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover .highcharts-label-box {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    font-size: 0.9em;
    font-weight: normal;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover text {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
  }

  /* Highmaps */
  :where([styled-mode]) .highcharts-map-series .highcharts-point {
    transition: fill 500ms, fill-opacity 500ms, stroke-width 250ms;
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-map-series .highcharts-point-hover {
    transition: fill 0ms, fill-opacity 0ms;
    fill-opacity: 0.5;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-mapline-series .highcharts-point {
    fill: none;
  }

  :where([styled-mode]) .highcharts-heatmap-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-map-navigation {
    font-size: 1.3em;
    font-weight: normal;
    text-align: center;
  }

  :where([styled-mode]) .highcharts-coloraxis {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-coloraxis-grid .highcharts-grid-line {
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-coloraxis-marker {
    fill: var(--vaadin-charts-axis-label, hsla(214, 42%, 18%, 0.72));
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-null-point {
    fill: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  /* 3d charts */
  :where([styled-mode]) .highcharts-3d-frame {
    fill: transparent;
  }

  /* Exporting module */
  :where([styled-mode]) .highcharts-contextbutton {
    fill: #fff;
    /* needed to capture hover */
    stroke: none;
    stroke-linecap: round;
  }

  :where([styled-mode]) .highcharts-contextbutton:hover {
    fill: #e6e6e6;
    stroke: #e6e6e6;
  }

  :where([styled-mode]) .highcharts-button-symbol {
    stroke: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-menu {
    border: 1px solid #999;
    background: #fff;
    padding: 5px 0;
    box-shadow: 3px 3px 10px #888;
  }

  :where([styled-mode]) .highcharts-menu-item {
    padding: 0.5em 1em;
    background: none;
    color: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    cursor: pointer;
    transition: background 250ms, color 250ms;
  }

  :where([styled-mode]) .highcharts-menu-item:hover {
    background: #335cad;
    color: #fff;
  }

  /* Drilldown module */
  :where([styled-mode]) .highcharts-drilldown-point {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-drilldown-data-label text,
  :where([styled-mode]) text.highcharts-drilldown-data-label,
  :where([styled-mode]) .highcharts-drilldown-axis-label {
    cursor: pointer;
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    font-weight: normal;
    text-decoration: underline;
  }

  /* No-data module */
  :where([styled-mode]) .highcharts-no-data text {
    font-weight: normal;
    font-size: 1rem;
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  /* Drag-panes module */
  :where([styled-mode]) .highcharts-axis-resizer {
    cursor: ns-resize;
    stroke: black;
    stroke-width: 2px;
  }

  /* Bullet type series */
  :where([styled-mode]) .highcharts-bullet-target {
    stroke-width: 0;
  }

  /* Lineargauge type series */
  :where([styled-mode]) .highcharts-lineargauge-target {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  :where([styled-mode]) .highcharts-lineargauge-target-line {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  /* Annotations module */
  :where([styled-mode]) .highcharts-annotation-label-box {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-annotation-label text {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
  }

  /* Gantt */
  :where([styled-mode]) .highcharts-treegrid-node-collapsed,
  :where([styled-mode]) .highcharts-treegrid-node-expanded {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-point-connecting-path {
    fill: none;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-tick {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-axis-line {
    stroke-width: 1px;
  }

  /* RTL styles */
  :host([dir='rtl']) :where([styled-mode]) .highcharts-container {
    text-align: right;
  }

  :host([dir='rtl']) :where([styled-mode]) input.highcharts-range-selector {
    left: auto;
    right: -9em;
  }

  :host([dir='rtl']) :where([styled-mode]) .highcharts-menu {
    box-shadow: -3px 3px 10px #888;
  }

  /* https://github.com/highcharts/highcharts/issues/16282 */
  /* without this the resize callback always calls __reflow */
  ul[aria-hidden='false'] {
    margin: 0px;
  }
`;registerStyles("vaadin-chart",chartBaseTheme,{moduleId:"vaadin-chart-base-theme"});const chartColors=i`
  :host {
    --vaadin-charts-color-0: #5ac2f7;
    --vaadin-charts-color-1: #1676f3;
    --vaadin-charts-color-2: #ff7d94;
    --vaadin-charts-color-3: #c5164e;
    --vaadin-charts-color-4: #15c15d;
    --vaadin-charts-color-5: #0e8151;
    --vaadin-charts-color-6: #c18ed2;
    --vaadin-charts-color-7: #9233b3;
    --vaadin-charts-color-8: #fda253;
    --vaadin-charts-color-9: #e24932;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-4, #15c15d);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-9, #e24932);
  }

  :host([theme~='gradient']) {
    --vaadin-charts-color-0: #1676f3;
    --vaadin-charts-color-1: #13bbf0;
    --vaadin-charts-color-2: #1ee;
    --vaadin-charts-color-3: #0cd9bf;
    --vaadin-charts-color-4: #06be81;
    --vaadin-charts-color-5: #00a344;
    --vaadin-charts-color-6: #41c639;
    --vaadin-charts-color-7: #8aed2c;
    --vaadin-charts-color-8: #c0e632;
    --vaadin-charts-color-9: #f6db3a;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-6);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-1);
  }

  :host([theme~='monotone']) {
    --vaadin-charts-color-0: #1676f3;
    --vaadin-charts-color-1: #4795f5;
    --vaadin-charts-color-2: #71b0f7;
    --vaadin-charts-color-3: #a0cef9;
    --vaadin-charts-color-4: #bce0fa;
    --vaadin-charts-color-5: #a8d8ed;
    --vaadin-charts-color-6: #7fc3dd;
    --vaadin-charts-color-7: #54adcc;
    --vaadin-charts-color-8: #2b99bc;
    --vaadin-charts-color-9: #0284ac;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-3);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-9);
  }

  :host([theme~='classic']) {
    --vaadin-charts-color-0: #7cb5ec;
    --vaadin-charts-color-1: #434348;
    --vaadin-charts-color-2: #90ed7d;
    --vaadin-charts-color-3: #f7a35c;
    --vaadin-charts-color-4: #8085e9;
    --vaadin-charts-color-5: #f15c80;
    --vaadin-charts-color-6: #e4d354;
    --vaadin-charts-color-7: #2b908f;
    --vaadin-charts-color-8: #f45b5b;
    --vaadin-charts-color-9: #91e8e1;
  }
`,chartTheme=i`
  :host {
    --vaadin-charts-background: var(--lumo-base-color);
    --vaadin-charts-title-label: var(--lumo-header-text-color);
    --vaadin-charts-axis-title: var(--lumo-secondary-text-color);
    --vaadin-charts-axis-label: var(--lumo-secondary-text-color);
    --vaadin-charts-data-label: var(--lumo-body-text-color);
    --vaadin-charts-secondary-label: var(--lumo-secondary-text-color);
    --vaadin-charts-axis-line: var(--lumo-contrast-5pct);
    --vaadin-charts-grid-line: var(--lumo-contrast-20pct);
    --vaadin-charts-disabled-label: var(--lumo-disabled-text-color);
    --vaadin-charts-contrast: var(--lumo-contrast);
    --vaadin-charts-contrast-5pct: var(--lumo-contrast-5pct);
    --vaadin-charts-contrast-10pct: var(--lumo-contrast-10pct);
    --vaadin-charts-contrast-20pct: var(--lumo-contrast-20pct);
    --vaadin-charts-contrast-60pct: var(--lumo-contrast-60pct);
    --vaadin-charts-tooltip-background: var(--lumo-base-color);
    --vaadin-charts-tooltip-border-color: inherit;
    --vaadin-charts-button-label: var(--lumo-primary-text-color);
    --vaadin-charts-button-background: var(--lumo-contrast-5pct);
    --vaadin-charts-button-hover-background: var(--lumo-primary-color-10pct);
    --vaadin-charts-button-active-label: var(--lumo-primary-contrast-color);
    --vaadin-charts-button-active-background: var(--lumo-primary-color);
    --vaadin-charts-xaxis-line-width: 0;
    --vaadin-charts-tooltip-background-opacity: 1;
    font-family: var(--lumo-font-family);
  }
`;registerStyles("vaadin-chart",[chartColors,chartTheme],{moduleId:"lumo-chart"});var w=typeof win<"u"?win:typeof window<"u"?window:{},Globals;(function(o){o.SVG_NS="http://www.w3.org/2000/svg",o.product="Highcharts",o.version="9.2.2",o.win=w,o.doc=o.win.document,o.svg=o.doc&&o.doc.createElementNS&&!!o.doc.createElementNS(o.SVG_NS,"svg").createSVGRect,o.userAgent=o.win.navigator&&o.win.navigator.userAgent||"",o.isChrome=o.userAgent.indexOf("Chrome")!==-1,o.isFirefox=o.userAgent.indexOf("Firefox")!==-1,o.isMS=/(edge|msie|trident)/i.test(o.userAgent)&&!o.win.opera,o.isSafari=!o.isChrome&&o.userAgent.indexOf("Safari")!==-1,o.isTouchDevice=/(Mobile|Android|Windows Phone)/.test(o.userAgent),o.isWebKit=o.userAgent.indexOf("AppleWebKit")!==-1,o.deg2rad=Math.PI*2/360,o.hasBidiBug=o.isFirefox&&parseInt(o.userAgent.split("Firefox/")[1],10)<4,o.hasTouch=!!o.win.TouchEvent,o.marginNames=["plotTop","marginRight","marginBottom","plotLeft"],o.noop=function(){},o.supportsPassiveEvents=function(){var r=!1;if(!o.isMS){var t=Object.defineProperty({},"passive",{get:function(){r=!0}});o.win.addEventListener&&o.win.removeEventListener&&(o.win.addEventListener("testPassive",o.noop,t),o.win.removeEventListener("testPassive",o.noop,t))}return r}(),o.charts=[],o.dateFormats={},o.seriesTypes={},o.symbolSizes={},o.chartCount=0})(Globals||(Globals={}));const H=Globals;var charts$5=H.charts,doc$m=H.doc,win$g=H.win;function error$a(o,r,t,n){var s=r?"Highcharts error":"Highcharts warning";o===32&&(o=s+": Deprecated member");var a=isNumber$R(o),l=a?s+" #"+o+": www.highcharts.com/errors/"+o+"/":o.toString(),h=function(){if(r)throw new Error(l);win$g.console&&error$a.messages.indexOf(l)===-1&&console.warn(l)};if(typeof n<"u"){var d="";a&&(l+="?"),objectEach$B(n,function(c,f){d+=`
 - `+f+": "+c,a&&(l+=encodeURI(f)+"="+encodeURI(c))}),l+=d}fireEvent$B(H,"displayError",{chart:t,code:o,message:l,params:n},h),error$a.messages.push(l)}(function(o){o.messages=[]})(error$a);function merge$1p(){var o,r=arguments,t={},n=function(a,l){return typeof a!="object"&&(a={}),objectEach$B(l,function(h,d){d==="__proto__"||d==="constructor"||(isObject$f(h,!0)&&!isClass(h)&&!isDOMElement(h)?a[d]=n(a[d]||{},h):a[d]=l[d])}),a};r[0]===!0&&(t=r[1],r=Array.prototype.slice.call(r,2));var s=r.length;for(o=0;o<s;o++)t=n(t,r[o]);return t}function clamp$j(o,r,t){return o>r?o<t?o:t:r}function cleanRecursively$2(o,r){var t={};return objectEach$B(o,function(n,s){var a;isObject$f(o[s],!0)&&!o.nodeType&&r[s]?(a=cleanRecursively$2(o[s],r[s]),Object.keys(a).length&&(t[s]=a)):(isObject$f(o[s])||o[s]!==r[s])&&(t[s]=o[s])}),t}function pInt$a(o,r){return parseInt(o,r||10)}function isString$c(o){return typeof o=="string"}function isArray$n(o){var r=Object.prototype.toString.call(o);return r==="[object Array]"||r==="[object Array Iterator]"}function isObject$f(o,r){return!!o&&typeof o=="object"&&(!r||!isArray$n(o))}function isDOMElement(o){return isObject$f(o)&&typeof o.nodeType=="number"}function isClass(o){var r=o&&o.constructor;return!!(isObject$f(o,!0)&&!isDOMElement(o)&&r&&r.name&&r.name!=="Object")}function isNumber$R(o){return typeof o=="number"&&!isNaN(o)&&o<1/0&&o>-1/0}function erase$9(o,r){for(var t=o.length;t--;)if(o[t]===r){o.splice(t,1);break}}function defined$W(o){return typeof o<"u"&&o!==null}function attr$8(o,r,t){var n;return isString$c(r)?defined$W(t)?o.setAttribute(r,t):o&&o.getAttribute&&(n=o.getAttribute(r),!n&&r==="class"&&(n=o.getAttribute(r+"Name"))):objectEach$B(r,function(s,a){o.setAttribute(a,s)}),n}function splat$j(o){return isArray$n(o)?o:[o]}function syncTimeout$9(o,r,t){return r>0?setTimeout(o,r,t):(o.call(0,t),-1)}function internalClearTimeout(o){defined$W(o)&&clearTimeout(o)}function extend$1q(o,r){var t;o||(o={});for(t in r)o[t]=r[t];return o}function pick$1B(){for(var o=arguments,r=o.length,t=0;t<r;t++){var n=o[t];if(typeof n<"u"&&n!==null)return n}}function css$d(o,r){H.isMS&&!H.svg&&r&&typeof r.opacity<"u"&&(r.filter="alpha(opacity="+r.opacity*100+")"),extend$1q(o.style,r)}function createElement$b(o,r,t,n,s){var a=doc$m.createElement(o);return r&&extend$1q(a,r),s&&css$d(a,{padding:"0",border:"none",margin:"0"}),t&&css$d(a,t),n&&n.appendChild(a),a}function extendClass$2(o,r){var t=function(){};return t.prototype=new o,extend$1q(t.prototype,r),t}function pad$2(o,r,t){return new Array((r||2)+1-String(o).replace("-","").length).join(t||"0")+o}function relativeLength$a(o,r,t){return/%$/.test(o)?r*parseFloat(o)/100+(t||0):parseFloat(o)}function wrap$d(o,r,t){var n=o[r];o[r]=function(){var s=Array.prototype.slice.call(arguments),a=arguments,l=this;l.proceed=function(){n.apply(l,arguments.length?arguments:a)},s.unshift(n);var h=t.apply(this,s);return l.proceed=null,h}}function getMagnitude$3(o){return Math.pow(10,Math.floor(Math.log(o)/Math.LN10))}function normalizeTickInterval$3(o,r,t,n,s){var a,l=o;t=pick$1B(t,1);var h=o/t;for(r||(r=s?[1,1.2,1.5,2,2.5,3,4,5,6,8,10]:[1,2,2.5,5,10],n===!1&&(t===1?r=r.filter(function(d){return d%1===0}):t<=.1&&(r=[1/t]))),a=0;a<r.length&&(l=r[a],!(s&&l*t>=o||!s&&h<=(r[a]+(r[a+1]||r[a]))/2));a++);return l=correctFloat$d(l*t,-Math.round(Math.log(.001)/Math.LN10)),l}function stableSort$7(o,r){var t=o.length,n,s;for(s=0;s<t;s++)o[s].safeI=s;for(o.sort(function(a,l){return n=r(a,l),n===0?a.safeI-l.safeI:n}),s=0;s<t;s++)delete o[s].safeI}function arrayMin$9(o){for(var r=o.length,t=o[0];r--;)o[r]<t&&(t=o[r]);return t}function arrayMax$a(o){for(var r=o.length,t=o[0];r--;)o[r]>t&&(t=o[r]);return t}function destroyObjectProperties$a(o,r){objectEach$B(o,function(t,n){t&&t!==r&&t.destroy&&t.destroy(),delete o[n]})}function discardElement$7(o){garbageBin||(garbageBin=createElement$b("div")),o&&garbageBin.appendChild(o),garbageBin.innerHTML=""}var garbageBin;function correctFloat$d(o,r){return parseFloat(o.toPrecision(r||14))}var timeUnits$3={millisecond:1,second:1e3,minute:6e4,hour:36e5,day:24*36e5,week:7*24*36e5,month:28*24*36e5,year:364*24*36e5};Math.easeInOutSine=function(o){return-.5*(Math.cos(Math.PI*o)-1)};function getNestedProperty$3(o,r){for(var t=o.split(".");t.length&&defined$W(r);){var n=t.shift();if(typeof n>"u"||n==="__proto__")return;var s=r[n];if(!defined$W(s)||typeof s=="function"||typeof s.nodeType=="number"||s===win$g)return;r=s}return r}function getStyle$2(o,r,t){var n=H.getStyle||getStyle$2,s;if(r==="width"){var a=Math.min(o.offsetWidth,o.scrollWidth),l=o.getBoundingClientRect&&o.getBoundingClientRect().width;return l<a&&l>=a-1&&(a=Math.floor(l)),Math.max(0,a-(n(o,"padding-left",!0)||0)-(n(o,"padding-right",!0)||0))}if(r==="height")return Math.max(0,Math.min(o.offsetHeight,o.scrollHeight)-(n(o,"padding-top",!0)||0)-(n(o,"padding-bottom",!0)||0));win$g.getComputedStyle||error$a(27,!0);var h=win$g.getComputedStyle(o,void 0);return h&&(s=h.getPropertyValue(r),pick$1B(t,r!=="opacity")&&(s=pInt$a(s))),s}function inArray(o,r,t){return error$a(32,!1,void 0,{"Highcharts.inArray":"use Array.indexOf"}),r.indexOf(o,t)}var find$j=Array.prototype.find?function(o,r){return o.find(r)}:function(o,r){var t,n=o.length;for(t=0;t<n;t++)if(r(o[t],t))return o[t]};function keys(o){return error$a(32,!1,void 0,{"Highcharts.keys":"use Object.keys"}),Object.keys(o)}function offset$1(o){var r=doc$m.documentElement,t=o.parentElement||o.parentNode?o.getBoundingClientRect():{top:0,left:0,width:0,height:0};return{top:t.top+(win$g.pageYOffset||r.scrollTop)-(r.clientTop||0),left:t.left+(win$g.pageXOffset||r.scrollLeft)-(r.clientLeft||0),width:t.width,height:t.height}}function objectEach$B(o,r,t){for(var n in o)Object.hasOwnProperty.call(o,n)&&r.call(t||o[n],o[n],n,o)}objectEach$B({map:"map",each:"forEach",grep:"filter",reduce:"reduce",some:"some"},function(o,r){H[r]=function(t){var n;return error$a(32,!1,void 0,(n={},n["Highcharts."+r]="use Array."+o,n)),Array.prototype[o].apply(t,[].slice.call(arguments,1))}});function addEvent$12(o,r,t,n){n===void 0&&(n={});var s=typeof o=="function"&&o.prototype||o;Object.hasOwnProperty.call(s,"hcEvents")||(s.hcEvents={});var a=s.hcEvents;H.Point&&o instanceof H.Point&&o.series&&o.series.chart&&(o.series.chart.runTrackerClick=!0);var l=o.addEventListener||H.addEventListenerPolyfill;l&&l.call(o,r,t,H.supportsPassiveEvents?{passive:n.passive===void 0?r.indexOf("touch")!==-1:n.passive,capture:!1}:!1),a[r]||(a[r]=[]);var h={fn:t,order:typeof n.order=="number"?n.order:1/0};return a[r].push(h),a[r].sort(function(d,c){return d.order-c.order}),function(){removeEvent$c(o,r,t)}}function removeEvent$c(o,r,t){function n(d,c){var f=o.removeEventListener||H.removeEventListenerPolyfill;f&&f.call(o,d,c,!1)}function s(d){var c,f;o.nodeName&&(r?(c={},c[r]=!0):c=d,objectEach$B(c,function(u,p){if(d[p])for(f=d[p].length;f--;)n(p,d[p][f].fn)}))}var a=typeof o=="function"&&o.prototype||o;if(Object.hasOwnProperty.call(a,"hcEvents")){var l=a.hcEvents;if(r){var h=l[r]||[];t?(l[r]=h.filter(function(d){return t!==d.fn}),n(r,t)):(s(l),l[r]=[])}else s(l),delete a.hcEvents}}function fireEvent$B(o,r,t,n){var s;if(t=t||{},doc$m.createEvent&&(o.dispatchEvent||o.fireEvent&&o!==H))s=doc$m.createEvent("Events"),s.initEvent(r,!0,!0),t=extend$1q(s,t),o.dispatchEvent?o.dispatchEvent(t):o.fireEvent(r,t);else if(o.hcEvents){t.target||extend$1q(t,{preventDefault:function(){t.defaultPrevented=!0},target:o,type:r});for(var a=[],l=o,h=!1;l.hcEvents;)Object.hasOwnProperty.call(l,"hcEvents")&&l.hcEvents[r]&&(a.length&&(h=!0),a.unshift.apply(a,l.hcEvents[r])),l=Object.getPrototypeOf(l);h&&a.sort(function(d,c){return d.order-c.order}),a.forEach(function(d){d.fn.call(o,t)===!1&&t.preventDefault()})}n&&!t.defaultPrevented&&n.call(o,t)}var serialMode,uniqueKey$8=function(){var o=Math.random().toString(36).substring(2,9)+"-",r=0;return function(){return"highcharts-"+(serialMode?"":o)+r++}}();function useSerialIds(o){return serialMode=pick$1B(o,serialMode)}function isFunction$5(o){return typeof o=="function"}win$g.jQuery&&(win$g.jQuery.fn.highcharts=function(){var o=[].slice.call(arguments);if(this[0])return o[0]?(new H[isString$c(o[0])?o.shift():"Chart"](this[0],o[0],o[1]),this):charts$5[attr$8(this[0],"data-highcharts-chart")]});var Utilities={addEvent:addEvent$12,arrayMax:arrayMax$a,arrayMin:arrayMin$9,attr:attr$8,clamp:clamp$j,cleanRecursively:cleanRecursively$2,clearTimeout:internalClearTimeout,correctFloat:correctFloat$d,createElement:createElement$b,css:css$d,defined:defined$W,destroyObjectProperties:destroyObjectProperties$a,discardElement:discardElement$7,erase:erase$9,error:error$a,extend:extend$1q,extendClass:extendClass$2,find:find$j,fireEvent:fireEvent$B,getMagnitude:getMagnitude$3,getNestedProperty:getNestedProperty$3,getStyle:getStyle$2,inArray,isArray:isArray$n,isClass,isDOMElement,isFunction:isFunction$5,isNumber:isNumber$R,isObject:isObject$f,isString:isString$c,keys,merge:merge$1p,normalizeTickInterval:normalizeTickInterval$3,objectEach:objectEach$B,offset:offset$1,pad:pad$2,pick:pick$1B,pInt:pInt$a,relativeLength:relativeLength$a,removeEvent:removeEvent$c,splat:splat$j,stableSort:stableSort$7,syncTimeout:syncTimeout$9,timeUnits:timeUnits$3,uniqueKey:uniqueKey$8,useSerialIds,wrap:wrap$d},palette={colors:["#7cb5ec","#434348","#90ed7d","#f7a35c","#8085e9","#f15c80","#e4d354","#2b908f","#f45b5b","#91e8e1"],backgroundColor:"#ffffff",neutralColor100:"#000000",neutralColor80:"#333333",neutralColor60:"#666666",neutralColor40:"#999999",neutralColor20:"#cccccc",neutralColor10:"#e6e6e6",neutralColor5:"#f2f2f2",neutralColor3:"#f7f7f7",highlightColor100:"#003399",highlightColor80:"#335cad",highlightColor60:"#6685c2",highlightColor20:"#ccd6eb",highlightColor10:"#e6ebf5",positiveColor:"#06b535",negativeColor:"#f21313"},ChartDefaults={panning:{enabled:!1,type:"x"},styledMode:!1,borderRadius:0,colorCount:10,defaultSeriesType:"line",ignoreHiddenSeries:!0,spacing:[10,10,15,10],resetZoomButton:{theme:{zIndex:6},position:{align:"right",x:-10,y:10}},zoomBySingleTouch:!1,width:null,height:null,borderColor:palette.highlightColor80,backgroundColor:palette.backgroundColor,plotBorderColor:palette.neutralColor20},isNumber$Q=Utilities.isNumber,merge$1o=Utilities.merge,pInt$9=Utilities.pInt,Color=function(){function o(r){this.rgba=[NaN,NaN,NaN,NaN],this.input=r;var t=H.Color;if(t&&t!==o)return new t(r);if(!(this instanceof o))return new o(r);this.init(r)}return o.parse=function(r){return r?new o(r):o.None},o.prototype.init=function(r){var t,n,s,a;if(typeof r=="object"&&typeof r.stops<"u")this.stops=r.stops.map(function(d){return new o(d[1])});else if(typeof r=="string"){if(this.input=r=o.names[r.toLowerCase()]||r,r.charAt(0)==="#"){var l=r.length,h=parseInt(r.substr(1),16);l===7?n=[(h&16711680)>>16,(h&65280)>>8,h&255,1]:l===4&&(n=[(h&3840)>>4|(h&3840)>>8,(h&240)>>4|h&240,(h&15)<<4|h&15,1])}if(!n)for(s=o.parsers.length;s--&&!n;)a=o.parsers[s],t=a.regex.exec(r),t&&(n=a.parse(t))}n&&(this.rgba=n)},o.prototype.get=function(r){var t=this.input,n=this.rgba;if(typeof t=="object"&&typeof this.stops<"u"){var s=merge$1o(t);return s.stops=[].slice.call(s.stops),this.stops.forEach(function(a,l){s.stops[l]=[s.stops[l][0],a.get(r)]}),s}return n&&isNumber$Q(n[0])?r==="rgb"||!r&&n[3]===1?"rgb("+n[0]+","+n[1]+","+n[2]+")":r==="a"?""+n[3]:"rgba("+n.join(",")+")":t},o.prototype.brighten=function(r){var t=this.rgba;if(this.stops)this.stops.forEach(function(s){s.brighten(r)});else if(isNumber$Q(r)&&r!==0)for(var n=0;n<3;n++)t[n]+=pInt$9(r*255),t[n]<0&&(t[n]=0),t[n]>255&&(t[n]=255);return this},o.prototype.setOpacity=function(r){return this.rgba[3]=r,this},o.prototype.tweenTo=function(r,t){var n=this.rgba,s=r.rgba;if(!isNumber$Q(n[0])||!isNumber$Q(s[0]))return r.input||"none";var a=s[3]!==1||n[3]!==1;return(a?"rgba(":"rgb(")+Math.round(s[0]+(n[0]-s[0])*(1-t))+","+Math.round(s[1]+(n[1]-s[1])*(1-t))+","+Math.round(s[2]+(n[2]-s[2])*(1-t))+(a?","+(s[3]+(n[3]-s[3])*(1-t)):"")+")"},o.names={white:"#ffffff",black:"#000000"},o.parsers=[{regex:/rgba\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]?(?:\.[0-9]+)?)\s*\)/,parse:function(r){return[pInt$9(r[1]),pInt$9(r[2]),pInt$9(r[3]),parseFloat(r[4],10)]}},{regex:/rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/,parse:function(r){return[pInt$9(r[1]),pInt$9(r[2]),pInt$9(r[3]),1]}}],o.None=new o(""),o}(),win$f=H.win,defined$V=Utilities.defined,error$9=Utilities.error,extend$1p=Utilities.extend,isObject$e=Utilities.isObject,merge$1n=Utilities.merge,objectEach$A=Utilities.objectEach,pad$1=Utilities.pad,pick$1A=Utilities.pick,splat$i=Utilities.splat,timeUnits$2=Utilities.timeUnits,hasNewSafariBug=H.isSafari&&win$f.Intl&&win$f.Intl.DateTimeFormat.prototype.formatRange,hasOldSafariBug=H.isSafari&&win$f.Intl&&!win$f.Intl.DateTimeFormat.prototype.formatRange,Time=function(){function o(r){this.options={},this.useUTC=!1,this.variableTimezone=!1,this.Date=win$f.Date,this.getTimezoneOffset=this.timezoneOffsetFunction(),this.update(r)}return o.prototype.get=function(r,t){if(this.variableTimezone||this.timezoneOffset){var n=t.getTime(),s=n-this.getTimezoneOffset(t);t.setTime(s);var a=t["getUTC"+r]();return t.setTime(n),a}return this.useUTC?t["getUTC"+r]():t["get"+r]()},o.prototype.set=function(r,t,n){if(this.variableTimezone||this.timezoneOffset){if(r==="Milliseconds"||r==="Seconds"||r==="Minutes"&&this.getTimezoneOffset(t)%36e5===0)return t["setUTC"+r](n);var s=this.getTimezoneOffset(t),a=t.getTime()-s;t.setTime(a),t["setUTC"+r](n);var l=this.getTimezoneOffset(t);return a=t.getTime()+l,t.setTime(a)}return this.useUTC||hasNewSafariBug&&r==="FullYear"?t["setUTC"+r](n):t["set"+r](n)},o.prototype.update=function(r){var t=pick$1A(r&&r.useUTC,!0);this.options=r=merge$1n(!0,this.options||{},r),this.Date=r.Date||win$f.Date||Date,this.useUTC=t,this.timezoneOffset=t&&r.timezoneOffset,this.getTimezoneOffset=this.timezoneOffsetFunction(),this.variableTimezone=t&&!!(r.getTimezoneOffset||r.timezone)},o.prototype.makeTime=function(r,t,n,s,a,l){var h,d,c;return this.useUTC?(h=this.Date.UTC.apply(0,arguments),d=this.getTimezoneOffset(h),h+=d,c=this.getTimezoneOffset(h),d!==c?h+=c-d:d-36e5===this.getTimezoneOffset(h-36e5)&&!hasOldSafariBug&&(h-=36e5)):h=new this.Date(r,t,pick$1A(n,1),pick$1A(s,0),pick$1A(a,0),pick$1A(l,0)).getTime(),h},o.prototype.timezoneOffsetFunction=function(){var r=this,t=this.options,n=t.moment||win$f.moment;if(!this.useUTC)return function(s){return new Date(s.toString()).getTimezoneOffset()*6e4};if(t.timezone)if(!n)error$9(25);else return function(s){return-n.tz(s,t.timezone).utcOffset()*6e4};return this.useUTC&&t.getTimezoneOffset?function(s){return t.getTimezoneOffset(s.valueOf())*6e4}:function(){return(r.timezoneOffset||0)*6e4}},o.prototype.dateFormat=function(r,t,n){if(!defined$V(t)||isNaN(t))return H.defaultOptions.lang&&H.defaultOptions.lang.invalidDate||"";r=pick$1A(r,"%Y-%m-%d %H:%M:%S");var s=this,a=new this.Date(t),l=this.get("Hours",a),h=this.get("Day",a),d=this.get("Date",a),c=this.get("Month",a),f=this.get("FullYear",a),u=H.defaultOptions.lang,p=u&&u.weekdays,g=u&&u.shortWeekdays,m=extend$1p({a:g?g[h]:p[h].substr(0,3),A:p[h],d:pad$1(d),e:pad$1(d,2," "),w:h,b:u.shortMonths[c],B:u.months[c],m:pad$1(c+1),o:c+1,y:f.toString().substr(2,2),Y:f,H:pad$1(l),k:l,I:pad$1(l%12||12),l:l%12||12,M:pad$1(this.get("Minutes",a)),p:l<12?"AM":"PM",P:l<12?"am":"pm",S:pad$1(a.getSeconds()),L:pad$1(Math.floor(t%1e3),3)},H.dateFormats);return objectEach$A(m,function(v,x){for(;r.indexOf("%"+x)!==-1;)r=r.replace("%"+x,typeof v=="function"?v.call(s,t):v)}),n?r.substr(0,1).toUpperCase()+r.substr(1):r},o.prototype.resolveDTLFormat=function(r){return isObject$e(r,!0)?r:(r=splat$i(r),{main:r[0],from:r[1],to:r[2]})},o.prototype.getTimeTicks=function(r,t,n,s){var a=this,l=a.Date,h=[],d={},c=new l(t),f=r.unitRange,u=r.count||1,p,g,m,v;if(s=pick$1A(s,1),defined$V(t)){a.set("Milliseconds",c,f>=timeUnits$2.second?0:u*Math.floor(a.get("Milliseconds",c)/u)),f>=timeUnits$2.second&&a.set("Seconds",c,f>=timeUnits$2.minute?0:u*Math.floor(a.get("Seconds",c)/u)),f>=timeUnits$2.minute&&a.set("Minutes",c,f>=timeUnits$2.hour?0:u*Math.floor(a.get("Minutes",c)/u)),f>=timeUnits$2.hour&&a.set("Hours",c,f>=timeUnits$2.day?0:u*Math.floor(a.get("Hours",c)/u)),f>=timeUnits$2.day&&a.set("Date",c,f>=timeUnits$2.month?1:Math.max(1,u*Math.floor(a.get("Date",c)/u))),f>=timeUnits$2.month&&(a.set("Month",c,f>=timeUnits$2.year?0:u*Math.floor(a.get("Month",c)/u)),g=a.get("FullYear",c)),f>=timeUnits$2.year&&(g-=g%u,a.set("FullYear",c,g)),f===timeUnits$2.week&&(v=a.get("Day",c),a.set("Date",c,a.get("Date",c)-v+s+(v<s?-7:0))),g=a.get("FullYear",c);var x=a.get("Month",c),y=a.get("Date",c),b=a.get("Hours",c);t=c.getTime(),(a.variableTimezone||!a.useUTC)&&defined$V(n)&&(m=n-t>4*timeUnits$2.month||a.getTimezoneOffset(t)!==a.getTimezoneOffset(n));var $=c.getTime();for(p=1;$<n;)h.push($),f===timeUnits$2.year?$=a.makeTime(g+p*u,0):f===timeUnits$2.month?$=a.makeTime(g,x+p*u):m&&(f===timeUnits$2.day||f===timeUnits$2.week)?$=a.makeTime(g,x,y+p*u*(f===timeUnits$2.day?1:7)):m&&f===timeUnits$2.hour&&u>1?$=a.makeTime(g,x,y,b+p*u):$+=f*u,p++;h.push($),f<=timeUnits$2.hour&&h.length<1e4&&h.forEach(function(S){S%18e5===0&&a.dateFormat("%H%M%S%L",S)==="000000000"&&(d[S]="day")})}return h.info=extend$1p(r,{higherRanks:d,totalRange:f*u}),h},o.prototype.getDateFormat=function(r,t,n,s){var a=this.dateFormat("%m-%d %H:%M:%S.%L",t),l="01-01 00:00:00.000",h={millisecond:15,second:12,minute:9,hour:6,day:3},d,c,f="millisecond";for(c in timeUnits$2){if(r===timeUnits$2.week&&+this.dateFormat("%w",t)===n&&a.substr(6)===l.substr(6)){c="week";break}if(timeUnits$2[c]>r){c=f;break}if(h[c]&&a.substr(h[c])!==l.substr(h[c]))break;c!=="week"&&(f=c)}return c&&(d=this.resolveDTLFormat(s[c]).main),d},o}(),color$g=Color.parse,isTouchDevice$4=H.isTouchDevice,svg$5=H.svg,merge$1m=Utilities.merge,defaultOptions$f={colors:palette.colors,symbols:["circle","diamond","square","triangle","triangle-down"],lang:{loading:"Loading...",months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],weekdays:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],decimalPoint:".",numericSymbols:["k","M","G","T","P","E"],resetZoom:"Reset zoom",resetZoomTitle:"Reset zoom level 1:1",thousandsSep:" "},global:{},time:{Date:void 0,getTimezoneOffset:void 0,timezone:void 0,timezoneOffset:0,useUTC:!0},chart:ChartDefaults,title:{text:"Chart title",align:"center",margin:15,widthAdjust:-44},subtitle:{text:"",align:"center",widthAdjust:-44},caption:{margin:15,text:"",align:"left",verticalAlign:"bottom"},plotOptions:{},labels:{style:{position:"absolute",color:palette.neutralColor80}},legend:{enabled:!0,align:"center",alignColumns:!0,className:"highcharts-no-tooltip",layout:"horizontal",labelFormatter:function(){return this.name},borderColor:palette.neutralColor40,borderRadius:0,navigation:{activeColor:palette.highlightColor100,inactiveColor:palette.neutralColor20},itemStyle:{color:palette.neutralColor80,cursor:"pointer",fontSize:"12px",fontWeight:"bold",textOverflow:"ellipsis"},itemHoverStyle:{color:palette.neutralColor100},itemHiddenStyle:{color:palette.neutralColor20},shadow:!1,itemCheckboxStyle:{position:"absolute",width:"13px",height:"13px"},squareSymbol:!0,symbolPadding:5,verticalAlign:"bottom",x:0,y:0,title:{style:{fontWeight:"bold"}}},loading:{labelStyle:{fontWeight:"bold",position:"relative",top:"45%"},style:{position:"absolute",backgroundColor:palette.backgroundColor,opacity:.5,textAlign:"center"}},tooltip:{enabled:!0,animation:svg$5,borderRadius:3,dateTimeLabelFormats:{millisecond:"%A, %b %e, %H:%M:%S.%L",second:"%A, %b %e, %H:%M:%S",minute:"%A, %b %e, %H:%M",hour:"%A, %b %e, %H:%M",day:"%A, %b %e, %Y",week:"Week from %A, %b %e, %Y",month:"%B %Y",year:"%Y"},footerFormat:"",headerShape:"callout",hideDelay:500,padding:8,shape:"callout",shared:!1,snap:isTouchDevice$4?25:10,headerFormat:'<span style="font-size: 10px">{point.key}</span><br/>',pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.y}</b><br/>',backgroundColor:color$g(palette.neutralColor3).setOpacity(.85).get(),borderWidth:1,shadow:!0,stickOnContact:!1,style:{color:palette.neutralColor80,cursor:"default",fontSize:"12px",whiteSpace:"nowrap"},useHTML:!1},credits:{enabled:!0,href:"https://www.highcharts.com?credits",position:{align:"right",x:-10,verticalAlign:"bottom",y:-5},style:{cursor:"pointer",color:palette.neutralColor40,fontSize:"9px"},text:"Highcharts.com"}};defaultOptions$f.chart.styledMode=!1;var defaultTime$2=new Time(merge$1m(defaultOptions$f.global,defaultOptions$f.time));function getOptions$3(){return defaultOptions$f}function setOptions$2(o){return merge$1m(!0,defaultOptions$f,o),(o.time||o.global)&&(H.time?H.time.update(merge$1m(defaultOptions$f.global,defaultOptions$f.time,o.global,o.time)):H.time=defaultTime$2),defaultOptions$f}var DefaultOptions={defaultOptions:defaultOptions$f,defaultTime:defaultTime$2,getOptions:getOptions$3,setOptions:setOptions$2},color$f=Color.parse,win$e=H.win,isNumber$P=Utilities.isNumber,objectEach$z=Utilities.objectEach,Fx=function(){function o(r,t,n){this.pos=NaN,this.options=t,this.elem=r,this.prop=n}return o.prototype.dSetter=function(){var r=this.paths,t=r&&r[0],n=r&&r[1],s=this.now||0,a=[];if(s===1||!t||!n)a=this.toD||[];else if(t.length===n.length&&s<1)for(var l=0;l<n.length;l++){for(var h=t[l],d=n[l],c=[],f=0;f<d.length;f++){var u=h[f],p=d[f];isNumber$P(u)&&isNumber$P(p)&&!(d[0]==="A"&&(f===4||f===5))?c[f]=u+s*(p-u):c[f]=p}a.push(c)}else a=n;this.elem.attr("d",a,void 0,!0)},o.prototype.update=function(){var r=this.elem,t=this.prop,n=this.now,s=this.options.step;this[t+"Setter"]?this[t+"Setter"]():r.attr?r.element&&r.attr(t,n,null,!0):r.style[t]=n+this.unit,s&&s.call(r,n,this)},o.prototype.run=function(r,t,n){var s=this,a=s.options,l=function(c){return l.stopped?!1:s.step(c)},h=win$e.requestAnimationFrame||function(c){setTimeout(c,13)},d=function(){for(var c=0;c<o.timers.length;c++)o.timers[c]()||o.timers.splice(c--,1);o.timers.length&&h(d)};r===t&&!this.elem["forceAnimate:"+this.prop]?(delete a.curAnim[this.prop],a.complete&&Object.keys(a.curAnim).length===0&&a.complete.call(this.elem)):(this.startTime=+new Date,this.start=r,this.end=t,this.unit=n,this.now=this.start,this.pos=0,l.elem=this.elem,l.prop=this.prop,l()&&o.timers.push(l)===1&&h(d))},o.prototype.step=function(r){var t=+new Date,n=this.options,s=this.elem,a=n.complete,l=n.duration,h=n.curAnim,d,c;return s.attr&&!s.element?d=!1:r||t>=l+this.startTime?(this.now=this.end,this.pos=1,this.update(),h[this.prop]=!0,c=!0,objectEach$z(h,function(f){f!==!0&&(c=!1)}),c&&a&&a.call(s),d=!1):(this.pos=n.easing((t-this.startTime)/l),this.now=this.start+(this.end-this.start)*this.pos,this.update(),d=!0),d},o.prototype.initPath=function(r,t,n){var s=r.startX,a=r.endX,l=n.slice(),h=r.isArea,d=h?2:1,c,f,u,p,g=t&&t.slice();if(!g)return[l,l];function m(x,y){for(;x.length<f;){var b=x[0],$=y[f-x.length];if($&&b[0]==="M"&&($[0]==="C"?x[0]=["C",b[1],b[2],b[1],b[2],b[1],b[2]]:x[0]=["L",b[1],b[2]]),x.unshift(b),h){var S=x.pop();x.push(x[x.length-1],S)}}}function v(x,y){for(;x.length<f;){var b=x[Math.floor(x.length/d)-1].slice();if(b[0]==="C"&&(b[1]=b[5],b[2]=b[6]),!h)x.push(b);else{var $=x[Math.floor(x.length/d)].slice();x.splice(x.length/2,0,b,$)}}}if(s&&a&&a.length){for(u=0;u<s.length;u++)if(s[u]===a[0]){c=u;break}else if(s[0]===a[a.length-s.length+u]){c=u,p=!0;break}else if(s[s.length-1]===a[a.length-s.length+u]){c=s.length-u;break}typeof c>"u"&&(g=[])}return g.length&&isNumber$P(c)&&(f=l.length+c*d,p?(m(g,l),v(l)):(m(l,g),v(g))),[g,l]},o.prototype.fillSetter=function(){o.prototype.strokeSetter.apply(this,arguments)},o.prototype.strokeSetter=function(){this.elem.attr(this.prop,color$f(this.start).tweenTo(color$f(this.end),this.pos),null,!0)},o.timers=[],o}(),defined$U=Utilities.defined,getStyle$1=Utilities.getStyle,isArray$m=Utilities.isArray,isNumber$O=Utilities.isNumber,isObject$d=Utilities.isObject,merge$1l=Utilities.merge,objectEach$y=Utilities.objectEach,pick$1z=Utilities.pick;function setAnimation$5(o,r){r.renderer.globalAnimation=pick$1z(o,r.options.chart.animation,!0)}function animObject$c(o){return isObject$d(o)?merge$1l({duration:500,defer:0},o):{duration:o?500:0,defer:0}}function getDeferredAnimation$3(o,r,t){var n=animObject$c(r),s=t?[t]:o.series,a=0,l=0;s.forEach(function(d){var c=animObject$c(d.options.animation);a=r&&defined$U(r.defer)?n.defer:Math.max(a,c.duration+c.defer),l=Math.min(n.duration,c.duration)}),o.renderer.forExport&&(a=0);var h={defer:Math.max(0,a-l),duration:Math.min(a,l)};return h}function animate$2(o,r,t){var n,s="",a,l,h;isObject$d(t)||(h=arguments,t={duration:h[2],easing:h[3],complete:h[4]}),isNumber$O(t.duration)||(t.duration=400),t.easing=typeof t.easing=="function"?t.easing:Math[t.easing]||Math.easeInOutSine,t.curAnim=merge$1l(r),objectEach$y(r,function(d,c){stop$2(o,c),l=new Fx(o,t,c),a=void 0,c==="d"&&isArray$m(r.d)?(l.paths=l.initPath(o,o.pathArray,r.d),l.toD=r.d,n=0,a=1):o.attr?n=o.attr(c):(n=parseFloat(getStyle$1(o,c))||0,c!=="opacity"&&(s="px")),a||(a=d),typeof a=="string"&&a.match("px")&&(a=a.replace(/px/g,"")),l.run(n,a,s)})}function stop$2(o,r){for(var t=Fx.timers.length;t--;)Fx.timers[t].elem===o&&(!r||r===Fx.timers[t].prop)&&(Fx.timers[t].stopped=!0)}var animationExports={animate:animate$2,animObject:animObject$c,getDeferredAnimation:getDeferredAnimation$3,setAnimation:setAnimation$5,stop:stop$2},SVG_NS$3=H.SVG_NS,attr$7=Utilities.attr,createElement$a=Utilities.createElement,discardElement$6=Utilities.discardElement,error$8=Utilities.error,isString$b=Utilities.isString,objectEach$x=Utilities.objectEach,splat$h=Utilities.splat,hasValidDOMParser=function(){try{return!!new DOMParser().parseFromString("","text/html")}catch{return!1}}(),AST=function(){function o(r){this.nodes=typeof r=="string"?this.parseMarkup(r):r}return o.filterUserAttributes=function(r){return objectEach$x(r,function(t,n){var s=!0;o.allowedAttributes.indexOf(n)===-1&&(s=!1),["background","dynsrc","href","lowsrc","src"].indexOf(n)!==-1&&(s=isString$b(t)&&o.allowedReferences.some(function(a){return t.indexOf(a)===0})),s||(error$8("Highcharts warning: Invalid attribute '"+n+"' in config"),delete r[n])}),r},o.setElementHTML=function(r,t){if(r.innerHTML="",t){var n=new o(t);n.addToDOM(r)}},o.prototype.addToDOM=function(r){function t(n,s){var a;return splat$h(n).forEach(function(l){var h=l.tagName,d=l.textContent?H.doc.createTextNode(l.textContent):void 0,c;if(h)if(h==="#text")c=d;else if(o.allowedTags.indexOf(h)!==-1){var f=h==="svg"?SVG_NS$3:s.namespaceURI||SVG_NS$3,u=H.doc.createElementNS(f,h),p=l.attributes||{};objectEach$x(l,function(g,m){m!=="tagName"&&m!=="attributes"&&m!=="children"&&m!=="textContent"&&(p[m]=g)}),attr$7(u,o.filterUserAttributes(p)),d&&u.appendChild(d),t(l.children||[],u),c=u}else error$8("Highcharts warning: Invalid tagName '"+h+"' in config");c&&s.appendChild(c),a=c}),a}return t(this.nodes,r)},o.prototype.parseMarkup=function(r){var t=[];r=r.trim();var n,s;hasValidDOMParser?n=new DOMParser().parseFromString(r,"text/html"):(s=createElement$a("div"),s.innerHTML=r,n={body:s});var a=function(l,h){var d=l.nodeName.toLowerCase(),c={tagName:d};d==="#text"&&(c.textContent=l.textContent||"");var f=l.attributes;if(f){var u={};[].forEach.call(f,function(g){u[g.name]=g.value}),c.attributes=u}if(l.childNodes.length){var p=[];[].forEach.call(l.childNodes,function(g){a(g,p)}),p.length&&(c.children=p)}h.push(c)};return[].forEach.call(n.body.childNodes,function(l){return a(l,t)}),s&&discardElement$6(s),t},o.allowedAttributes=["aria-controls","aria-describedby","aria-expanded","aria-haspopup","aria-hidden","aria-label","aria-labelledby","aria-live","aria-pressed","aria-readonly","aria-roledescription","aria-selected","class","clip-path","color","colspan","cx","cy","d","dx","dy","disabled","fill","height","href","id","in","markerHeight","markerWidth","offset","opacity","orient","padding","paddingLeft","paddingRight","patternUnits","r","refX","refY","role","scope","slope","src","startOffset","stdDeviation","stroke","stroke-linecap","stroke-width","style","tableValues","result","rowspan","summary","target","tabindex","text-align","textAnchor","textLength","type","valign","width","x","x1","x2","y","y1","y2","zIndex"],o.allowedReferences=["https://","http://","mailto:","/","../","./","#"],o.allowedTags=["a","b","br","button","caption","circle","clipPath","code","dd","defs","div","dl","dt","em","feComponentTransfer","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feOffset","feMerge","feMergeNode","filter","h1","h2","h3","h4","h5","h6","hr","i","img","li","linearGradient","marker","ol","p","path","pattern","pre","rect","small","span","stop","strong","style","sub","sup","svg","table","text","thead","tbody","tspan","td","th","tr","u","ul","#text"],o}(),defaultOptions$e=DefaultOptions.defaultOptions,defaultTime$1=DefaultOptions.defaultTime,getNestedProperty$2=Utilities.getNestedProperty,isNumber$N=Utilities.isNumber,pick$1y=Utilities.pick,pInt$8=Utilities.pInt;function dateFormat(o,r,t){return defaultTime$1.dateFormat(o,r,t)}function format$d(o,r,t){for(var n="{",s=!1,a,l,h,d,c=/f$/,f=/\.([0-9])/,u=defaultOptions$e.lang,p=t&&t.time||defaultTime$1,g=t&&t.numberFormatter||numberFormat$2,m=[];o&&(d=o.indexOf(n),d!==-1);){if(a=o.slice(0,d),s){if(l=a.split(":"),h=getNestedProperty$2(l.shift()||"",r),l.length&&typeof h=="number")if(a=l.join(":"),c.test(a)){var v=parseInt((a.match(f)||["","-1"])[1],10);h!==null&&(h=g(h,v,u.decimalPoint,a.indexOf(",")>-1?u.thousandsSep:""))}else h=p.dateFormat(a,h);m.push(h)}else m.push(a);o=o.slice(d+1),s=!s,n=s?"}":"{"}return m.push(o),m.join("")}function numberFormat$2(o,r,t,n){o=+o||0,r=+r;var s,a,l=defaultOptions$e.lang,h=(o.toString().split(".")[1]||"").split("e")[0].length,d=o.toString().split("e"),c=r;r===-1?r=Math.min(h,20):isNumber$N(r)?r&&d[1]&&d[1]<0&&(a=r+ +d[1],a>=0?(d[0]=(+d[0]).toExponential(a).split("e")[0],r=a):(d[0]=d[0].split(".")[0]||0,r<20?o=(d[0]*Math.pow(10,d[1])).toFixed(r):o=0,d[1]=0)):r=2;var f=(Math.abs(d[1]?d[0]:o)+Math.pow(10,-Math.max(r,h)-1)).toFixed(r),u=String(pInt$8(f)),p=u.length>3?u.length%3:0;return t=pick$1y(t,l.decimalPoint),n=pick$1y(n,l.thousandsSep),s=o<0?"-":"",s+=p?u.substr(0,p)+n:"",+d[1]<0&&!c?s="0":s+=u.substr(p).replace(/(\d{3})(?=\d)/g,"$1"+n),r&&(s+=t+f.slice(-r)),d[1]&&+s!=0&&(s+="e"+d[1]),s}var FormatUtilities={dateFormat,format:format$d,numberFormat:numberFormat$2},clamp$i=Utilities.clamp,pick$1x=Utilities.pick,stableSort$6=Utilities.stableSort,RendererUtilities;(function(o){function r(t,n,s){var a=t,l=a.reducedLen||n,h=function(v,x){return(x.rank||0)-(v.rank||0)},d=function(v,x){return v.target-x.target},c,f=!0,u=[],p,g,m=0;for(c=t.length;c--;)m+=t[c].size;if(m>l){for(stableSort$6(t,h),c=0,m=0;m<=l;)m+=t[c].size,c++;u=t.splice(c-1,t.length)}for(stableSort$6(t,d),t=t.map(function(v){return{size:v.size,targets:[v.target],align:pick$1x(v.align,.5)}});f;){for(c=t.length;c--;)p=t[c],g=(Math.min.apply(0,p.targets)+Math.max.apply(0,p.targets))/2,p.pos=clamp$i(g-p.size*p.align,0,n-p.size);for(c=t.length,f=!1;c--;)c>0&&t[c-1].pos+t[c-1].size>t[c].pos&&(t[c-1].size+=t[c].size,t[c-1].targets=t[c-1].targets.concat(t[c].targets),t[c-1].align=.5,t[c-1].pos+t[c-1].size>n&&(t[c-1].pos=n-t[c-1].size),t.splice(c,1),f=!0)}return a.push.apply(a,u),c=0,t.some(function(v){var x=0;return(v.targets||[]).some(function(){return a[c].pos=v.pos+x,typeof s<"u"&&Math.abs(a[c].pos-a[c].target)>s?(a.slice(0,c+1).forEach(function(y){return delete y.pos}),a.reducedLen=(a.reducedLen||n)-n*.1,a.reducedLen>n*.1&&r(a,n,s),!0):(x+=a[c].size,c++,!1)})}),stableSort$6(a,d),a}o.distribute=r})(RendererUtilities||(RendererUtilities={}));const R=RendererUtilities;var animate$1=animationExports.animate,animObject$b=animationExports.animObject,stop$1=animationExports.stop,deg2rad$8=H.deg2rad,doc$l=H.doc,noop$l=H.noop,svg$4=H.svg,SVG_NS$2=H.SVG_NS,win$d=H.win,addEvent$11=Utilities.addEvent,attr$6=Utilities.attr,createElement$9=Utilities.createElement,css$c=Utilities.css,defined$T=Utilities.defined,erase$8=Utilities.erase,extend$1o=Utilities.extend,fireEvent$A=Utilities.fireEvent,isArray$l=Utilities.isArray,isFunction$4=Utilities.isFunction,isNumber$M=Utilities.isNumber,isString$a=Utilities.isString,merge$1k=Utilities.merge,objectEach$w=Utilities.objectEach,pick$1w=Utilities.pick,pInt$7=Utilities.pInt,syncTimeout$8=Utilities.syncTimeout,uniqueKey$7=Utilities.uniqueKey,SVGElement=function(){function o(){this.element=void 0,this.onEvents={},this.opacity=1,this.renderer=void 0,this.SVG_NS=SVG_NS$2,this.symbolCustomAttribs=["x","y","width","height","r","start","end","innerR","anchorX","anchorY","rounded"]}return o.prototype._defaultGetter=function(r){var t=pick$1w(this[r+"Value"],this[r],this.element?this.element.getAttribute(r):null,0);return/^[\-0-9\.]+$/.test(t)&&(t=parseFloat(t)),t},o.prototype._defaultSetter=function(r,t,n){n.setAttribute(t,r)},o.prototype.add=function(r){var t=this.renderer,n=this.element,s;return r&&(this.parentGroup=r),this.parentInverted=r&&r.inverted,typeof this.textStr<"u"&&this.element.nodeName==="text"&&t.buildText(this),this.added=!0,(!r||r.handleZ||this.zIndex)&&(s=this.zIndexSetter()),s||(r?r.element:t.box).appendChild(n),this.onAdd&&this.onAdd(),this},o.prototype.addClass=function(r,t){var n=t?"":this.attr("class")||"";return r=(r||"").split(/ /g).reduce(function(s,a){return n.indexOf(a)===-1&&s.push(a),s},n?[n]:[]).join(" "),r!==n&&this.attr("class",r),this},o.prototype.afterSetters=function(){this.doTransform&&(this.updateTransform(),this.doTransform=!1)},o.prototype.align=function(r,t,n){var s={},a=this.renderer,l=a.alignedObjects,h,d,c,f,u;r?(this.alignOptions=r,this.alignByTranslate=t,(!n||isString$a(n))&&(this.alignTo=c=n||"renderer",erase$8(l,this),l.push(this),n=void 0)):(r=this.alignOptions,t=this.alignByTranslate,c=this.alignTo),n=pick$1w(n,a[c],c==="scrollablePlotBox"?a.plotBox:void 0,a);var p=r.align,g=r.verticalAlign;return h=(n.x||0)+(r.x||0),d=(n.y||0)+(r.y||0),p==="right"?f=1:p==="center"&&(f=2),f&&(h+=(n.width-(r.width||0))/f),s[t?"translateX":"x"]=Math.round(h),g==="bottom"?u=1:g==="middle"&&(u=2),u&&(d+=(n.height-(r.height||0))/u),s[t?"translateY":"y"]=Math.round(d),this[this.placed?"animate":"attr"](s),this.placed=!0,this.alignAttr=s,this},o.prototype.alignSetter=function(r){var t={left:"start",center:"middle",right:"end"};t[r]&&(this.alignValue=r,this.element.setAttribute("text-anchor",t[r]))},o.prototype.animate=function(r,t,n){var s=this,a=animObject$b(pick$1w(t,this.renderer.globalAnimation,!0)),l=a.defer;return pick$1w(doc$l.hidden,doc$l.msHidden,doc$l.webkitHidden,!1)&&(a.duration=0),a.duration!==0?(n&&(a.complete=n),syncTimeout$8(function(){s.element&&animate$1(s,r,a)},l)):(this.attr(r,void 0,n),objectEach$w(r,function(h,d){a.step&&a.step.call(this,h,{prop:d,pos:1,elem:this})},this)),this},o.prototype.applyTextOutline=function(r){var t=this.element,n=r.indexOf("contrast")!==-1;n&&(r=r.replace(/contrast/g,this.renderer.getContrast(t.style.fill)));var s=r.split(" "),a=s[s.length-1],l=s[0];if(l&&l!=="none"&&H.svg){this.fakeTS=!0,this.ySetter=this.xSetter,l=l.replace(/(^[\d\.]+)(.*?)$/g,function(c,f,u){return 2*Number(f)+u}),this.removeTextOutline();var h=doc$l.createElementNS(SVG_NS$2,"tspan");attr$6(h,{class:"highcharts-text-outline",fill:a,stroke:a,"stroke-width":l,"stroke-linejoin":"round"}),[].forEach.call(t.childNodes,function(c){var f=c.cloneNode(!0);f.removeAttribute&&["fill","stroke","stroke-width","stroke"].forEach(function(u){return f.removeAttribute(u)}),h.appendChild(f)});var d=doc$l.createElementNS(SVG_NS$2,"tspan");d.textContent="​",["x","y"].forEach(function(c){var f=t.getAttribute(c);f&&d.setAttribute(c,f)}),h.appendChild(d),t.insertBefore(h,t.firstChild)}},o.prototype.attr=function(r,t,n,s){var a=this.element,l=this.symbolCustomAttribs,h,d,c=this,f,u;return typeof r=="string"&&typeof t<"u"&&(h=r,r={},r[h]=t),typeof r=="string"?c=(this[r+"Getter"]||this._defaultGetter).call(this,r,a):(objectEach$w(r,function(g,m){f=!1,s||stop$1(this,m),this.symbolName&&l.indexOf(m)!==-1&&(d||(this.symbolAttr(r),d=!0),f=!0),this.rotation&&(m==="x"||m==="y")&&(this.doTransform=!0),f||(u=this[m+"Setter"]||this._defaultSetter,u.call(this,g,m,a),!this.styledMode&&this.shadows&&/^(width|height|visibility|x|y|d|transform|cx|cy|r)$/.test(m)&&this.updateShadows(m,g,u))},this),this.afterSetters()),n&&n.call(this),c},o.prototype.clip=function(r){return this.attr("clip-path",r?"url("+this.renderer.url+"#"+r.id+")":"none")},o.prototype.crisp=function(r,t){var n=this;t=t||r.strokeWidth||0;var s=Math.round(t)%2/2;return r.x=Math.floor(r.x||n.x||0)+s,r.y=Math.floor(r.y||n.y||0)+s,r.width=Math.floor((r.width||n.width||0)-2*s),r.height=Math.floor((r.height||n.height||0)-2*s),defined$T(r.strokeWidth)&&(r.strokeWidth=t),r},o.prototype.complexColor=function(r,t,n){var s=this.renderer,a,l,h,d,c,f,u,p,g,m,v=[],x;fireEvent$A(this.renderer,"complexColor",{args:arguments},function(){if(r.radialGradient?l="radialGradient":r.linearGradient&&(l="linearGradient"),l){if(h=r[l],c=s.gradients,f=r.stops,g=n.radialReference,isArray$l(h)&&(r[l]=h={x1:h[0],y1:h[1],x2:h[2],y2:h[3],gradientUnits:"userSpaceOnUse"}),l==="radialGradient"&&g&&!defined$T(h.gradientUnits)&&(d=h,h=merge$1k(h,s.getRadialAttr(g,d),{gradientUnits:"userSpaceOnUse"})),objectEach$w(h,function(b,$){$!=="id"&&v.push($,b)}),objectEach$w(f,function(b){v.push(b)}),v=v.join(","),c[v])m=c[v].attr("id");else{h.id=m=uniqueKey$7();var y=c[v]=s.createElement(l).attr(h).add(s.defs);y.radAttr=d,y.stops=[],f.forEach(function(b){b[1].indexOf("rgba")===0?(a=Color.parse(b[1]),u=a.get("rgb"),p=a.get("a")):(u=b[1],p=1);var $=s.createElement("stop").attr({offset:b[0],"stop-color":u,"stop-opacity":p}).add(y);y.stops.push($)})}x="url("+s.url+"#"+m+")",n.setAttribute(t,x),n.gradient=v,r.toString=function(){return x}}})},o.prototype.css=function(r){var t=this.styles,n={},s=this.element,a=["textOutline","textOverflow","width"],l,h="",d,c=!t;return r&&r.color&&(r.fill=r.color),t&&objectEach$w(r,function(f,u){t&&t[u]!==f&&(n[u]=f,c=!0)}),c&&(t&&(r=extend$1o(t,n)),r&&(r.width===null||r.width==="auto"?delete this.textWidth:s.nodeName.toLowerCase()==="text"&&r.width&&(l=this.textWidth=pInt$7(r.width))),this.styles=r,l&&!svg$4&&this.renderer.forExport&&delete r.width,s.namespaceURI===this.SVG_NS?(d=function(f,u){return"-"+u.toLowerCase()},objectEach$w(r,function(f,u){a.indexOf(u)===-1&&(h+=u.replace(/([A-Z])/g,d)+":"+f+";")}),h&&attr$6(s,"style",h)):css$c(s,r),this.added&&(this.element.nodeName==="text"&&this.renderer.buildText(this),r&&r.textOutline&&this.applyTextOutline(r.textOutline))),this},o.prototype.dashstyleSetter=function(r){var t,n=this["stroke-width"];if(n==="inherit"&&(n=1),r=r&&r.toLowerCase(),r){var s=r.replace("shortdashdotdot","3,1,1,1,1,1,").replace("shortdashdot","3,1,1,1").replace("shortdot","1,1,").replace("shortdash","3,1,").replace("longdash","8,3,").replace(/dot/g,"1,3,").replace("dash","4,3,").replace(/,$/,"").split(",");for(t=s.length;t--;)s[t]=""+pInt$7(s[t])*pick$1w(n,NaN);r=s.join(",").replace(/NaN/g,"none"),this.element.setAttribute("stroke-dasharray",r)}},o.prototype.destroy=function(){var r=this,t=r.element||{},n=r.renderer,s=t.ownerSVGElement,a=n.isSVG&&t.nodeName==="SPAN"&&r.parentGroup||void 0,l,h;if(t.onclick=t.onmouseout=t.onmouseover=t.onmousemove=t.point=null,stop$1(r),r.clipPath&&s){var d=r.clipPath;[].forEach.call(s.querySelectorAll("[clip-path],[CLIP-PATH]"),function(c){c.getAttribute("clip-path").indexOf(d.element.id)>-1&&c.removeAttribute("clip-path")}),r.clipPath=d.destroy()}if(r.stops){for(h=0;h<r.stops.length;h++)r.stops[h].destroy();r.stops.length=0,r.stops=void 0}for(r.safeRemoveChild(t),n.styledMode||r.destroyShadows();a&&a.div&&a.div.childNodes.length===0;)l=a.parentGroup,r.safeRemoveChild(a.div),delete a.div,a=l;r.alignTo&&erase$8(n.alignedObjects,r),objectEach$w(r,function(c,f){r[f]&&r[f].parentGroup===r&&r[f].destroy&&r[f].destroy(),delete r[f]})},o.prototype.destroyShadows=function(){(this.shadows||[]).forEach(function(r){this.safeRemoveChild(r)},this),this.shadows=void 0},o.prototype.destroyTextPath=function(r,t){var n=r.getElementsByTagName("text")[0],s;if(n){if(n.removeAttribute("dx"),n.removeAttribute("dy"),t.element.setAttribute("id",""),this.textPathWrapper&&n.getElementsByTagName("textPath").length){for(s=this.textPathWrapper.element.childNodes;s.length;)n.appendChild(s[0]);n.removeChild(this.textPathWrapper.element)}}else(r.getAttribute("dx")||r.getAttribute("dy"))&&(r.removeAttribute("dx"),r.removeAttribute("dy"));this.textPathWrapper&&(this.textPathWrapper=this.textPathWrapper.destroy())},o.prototype.dSetter=function(r,t,n){isArray$l(r)&&(typeof r[0]=="string"&&(r=this.renderer.pathToSegments(r)),this.pathArray=r,r=r.reduce(function(s,a,l){return!a||!a.join?(a||"").toString():(l?s+" ":"")+a.join(" ")},"")),/(NaN| {2}|^$)/.test(r)&&(r="M 0 0"),this[t]!==r&&(n.setAttribute(t,r),this[t]=r)},o.prototype.fadeOut=function(r){var t=this;t.animate({opacity:0},{duration:pick$1w(r,150),complete:function(){t.attr({y:-9999}).hide()}})},o.prototype.fillSetter=function(r,t,n){typeof r=="string"?n.setAttribute(t,r):r&&this.complexColor(r,t,n)},o.prototype.getBBox=function(r,t){var n=this,s=n.renderer,a=n.element,l=n.styles,h=n.textStr,d=s.cache,c=s.cacheKeys,f=a.namespaceURI===n.SVG_NS,u=pick$1w(t,n.rotation,0),p=s.styledMode?a&&o.prototype.getStyle.call(a,"font-size"):l&&l.fontSize,g,m,v,x,y;if(defined$T(h)&&(y=h.toString(),y.indexOf("<")===-1&&(y=y.replace(/[0-9]/g,"0")),y+=["",u,p,n.textWidth,l&&l.textOverflow,l&&l.fontWeight].join(",")),y&&!r&&(g=d[y]),!g){if(f||s.forExport){try{x=this.fakeTS&&function($){var S=a.querySelector(".highcharts-text-outline");S&&css$c(S,{display:$})},isFunction$4(x)&&x("none"),g=a.getBBox?extend$1o({},a.getBBox()):{width:a.offsetWidth,height:a.offsetHeight},isFunction$4(x)&&x("")}catch{}(!g||g.width<0)&&(g={width:0,height:0})}else g=n.htmlGetBBox();if(s.isSVG&&(m=g.width,v=g.height,f&&(g.height=v={"11px,17":14,"13px,20":16}[l&&l.fontSize+","+Math.round(v)]||v),u)){var b=u*deg2rad$8;g.width=Math.abs(v*Math.sin(b))+Math.abs(m*Math.cos(b)),g.height=Math.abs(v*Math.cos(b))+Math.abs(m*Math.sin(b))}if(y&&(h===""||g.height>0)){for(;c.length>250;)delete d[c.shift()];d[y]||c.push(y),d[y]=g}}return g},o.prototype.getStyle=function(r){return win$d.getComputedStyle(this.element||this,"").getPropertyValue(r)},o.prototype.hasClass=function(r){return(""+this.attr("class")).split(" ").indexOf(r)!==-1},o.prototype.hide=function(r){return r?this.attr({y:-9999}):this.attr({visibility:"hidden"}),this},o.prototype.htmlGetBBox=function(){return{height:0,width:0,x:0,y:0}},o.prototype.init=function(r,t){this.element=t==="span"?createElement$9(t):doc$l.createElementNS(this.SVG_NS,t),this.renderer=r,fireEvent$A(this,"afterInit")},o.prototype.invert=function(r){return this.inverted=r,this.updateTransform(),this},o.prototype.on=function(r,t){var n=this.onEvents;return n[r]&&n[r](),n[r]=addEvent$11(this.element,r,t),this},o.prototype.opacitySetter=function(r,t,n){var s=Number(Number(r).toFixed(3));this.opacity=s,n.setAttribute(t,s)},o.prototype.removeClass=function(r){return this.attr("class",(""+this.attr("class")).replace(isString$a(r)?new RegExp("(^| )"+r+"( |$)"):r," ").replace(/ +/g," ").trim())},o.prototype.removeTextOutline=function(){var r=this.element.querySelector("tspan.highcharts-text-outline");r&&this.safeRemoveChild(r)},o.prototype.safeRemoveChild=function(r){var t=r.parentNode;t&&t.removeChild(r)},o.prototype.setRadialReference=function(r){var t=this.element.gradient&&this.renderer.gradients[this.element.gradient];return this.element.radialReference=r,t&&t.radAttr&&t.animate(this.renderer.getRadialAttr(r,t.radAttr)),this},o.prototype.setTextPath=function(r,t){var n=this.element,s=this.text?this.text.element:n,a={textAnchor:"text-anchor"},l=!1,h,d,c=this.textPathWrapper,f=!c;t=merge$1k(!0,{enabled:!0,attributes:{dy:-5,startOffset:"50%",textAnchor:"middle"}},t);var u=AST.filterUserAttributes(t.attributes);if(r&&t&&t.enabled){if(c&&c.element.parentNode===null?(f=!0,c=c.destroy()):c&&this.removeTextOutline.call(c.parentGroup),this.options&&this.options.padding&&(u.dx=-this.options.padding),c||(this.textPathWrapper=c=this.renderer.createElement("textPath"),l=!0),h=c.element,d=r.element.getAttribute("id"),d||r.element.setAttribute("id",d=uniqueKey$7()),f){s.setAttribute("y",0),isNumber$M(u.dx)&&s.setAttribute("x",-u.dx);for(var p=[].slice.call(s.childNodes),g=0;g<p.length;g++){var m=p[g];(m.nodeType===Node.TEXT_NODE||m.nodeName==="tspan")&&h.appendChild(m)}}l&&c&&c.add({element:s}),h.setAttributeNS("http://www.w3.org/1999/xlink","href",this.renderer.url+"#"+d),defined$T(u.dy)&&(h.parentNode.setAttribute("dy",u.dy),delete u.dy),defined$T(u.dx)&&(h.parentNode.setAttribute("dx",u.dx),delete u.dx),objectEach$w(u,function(v,x){h.setAttribute(a[x]||x,v)}),n.removeAttribute("transform"),this.removeTextOutline.call(c),this.text&&!this.renderer.styledMode&&this.attr({fill:"none","stroke-width":0}),this.updateTransform=noop$l,this.applyTextOutline=noop$l}else c&&(delete this.updateTransform,delete this.applyTextOutline,this.destroyTextPath(n,r),this.updateTransform(),this.options&&this.options.rotation&&this.applyTextOutline(this.options.style.textOutline));return this},o.prototype.shadow=function(r,t,n){var s=[],a=this.element,l=this.oldShadowOptions,h={color:palette.neutralColor100,offsetX:this.parentInverted?-1:1,offsetY:this.parentInverted?-1:1,opacity:.15,width:3},d,c,f,u,p=!1,g,m;if(r===!0?m=h:typeof r=="object"&&(m=extend$1o(h,r)),m&&(m&&l&&objectEach$w(m,function(v,x){v!==l[x]&&(p=!0)}),p&&this.destroyShadows(),this.oldShadowOptions=m),!m)this.destroyShadows();else if(!this.shadows){for(u=m.opacity/m.width,g=this.parentInverted?"translate("+m.offsetY+", "+m.offsetX+")":"translate("+m.offsetX+", "+m.offsetY+")",d=1;d<=m.width;d++)c=a.cloneNode(!1),f=m.width*2+1-2*d,attr$6(c,{stroke:r.color||palette.neutralColor100,"stroke-opacity":u*d,"stroke-width":f,transform:g,fill:"none"}),c.setAttribute("class",(c.getAttribute("class")||"")+" highcharts-shadow"),n&&(attr$6(c,"height",Math.max(attr$6(c,"height")-f,0)),c.cutHeight=f),t?t.element.appendChild(c):a.parentNode&&a.parentNode.insertBefore(c,a),s.push(c);this.shadows=s}return this},o.prototype.show=function(r){return this.attr({visibility:r?"inherit":"visible"})},o.prototype.strokeSetter=function(r,t,n){this[t]=r,this.stroke&&this["stroke-width"]?(o.prototype.fillSetter.call(this,this.stroke,"stroke",n),n.setAttribute("stroke-width",this["stroke-width"]),this.hasStroke=!0):t==="stroke-width"&&r===0&&this.hasStroke?(n.removeAttribute("stroke"),this.hasStroke=!1):this.renderer.styledMode&&this["stroke-width"]&&(n.setAttribute("stroke-width",this["stroke-width"]),this.hasStroke=!0)},o.prototype.strokeWidth=function(){if(!this.renderer.styledMode)return this["stroke-width"]||0;var r=this.getStyle("stroke-width"),t=0,n;return r.indexOf("px")===r.length-2?t=pInt$7(r):r!==""&&(n=doc$l.createElementNS(SVG_NS$2,"rect"),attr$6(n,{width:r,"stroke-width":0}),this.element.parentNode.appendChild(n),t=n.getBBox().width,n.parentNode.removeChild(n)),t},o.prototype.symbolAttr=function(r){var t=this;["x","y","r","start","end","width","height","innerR","anchorX","anchorY","clockwise"].forEach(function(n){t[n]=pick$1w(r[n],t[n])}),t.attr({d:t.renderer.symbols[t.symbolName](t.x,t.y,t.width,t.height,t)})},o.prototype.textSetter=function(r){r!==this.textStr&&(delete this.textPxLength,this.textStr=r,this.added&&this.renderer.buildText(this))},o.prototype.titleSetter=function(r){var t=this.element,n=t.getElementsByTagName("title")[0]||doc$l.createElementNS(this.SVG_NS,"title");t.insertBefore?t.insertBefore(n,t.firstChild):t.appendChild(n),n.textContent=String(pick$1w(r,"")).replace(/<[^>]*>/g,"").replace(/&lt;/g,"<").replace(/&gt;/g,">")},o.prototype.toFront=function(){var r=this.element;return r.parentNode.appendChild(r),this},o.prototype.translate=function(r,t){return this.attr({translateX:r,translateY:t})},o.prototype.updateShadows=function(r,t,n){var s=this.shadows;if(s)for(var a=s.length;a--;)n.call(s[a],r==="height"?Math.max(t-(s[a].cutHeight||0),0):r==="d"?this.d:t,r,s[a])},o.prototype.updateTransform=function(){var r=this,t=r.scaleX,n=r.scaleY,s=r.inverted,a=r.rotation,l=r.matrix,h=r.element,d=r.translateX||0,c=r.translateY||0;s&&(d+=r.width,c+=r.height);var f=["translate("+d+","+c+")"];defined$T(l)&&f.push("matrix("+l.join(",")+")"),s?f.push("rotate(90) scale(-1,1)"):a&&f.push("rotate("+a+" "+pick$1w(this.rotationOriginX,h.getAttribute("x"),0)+" "+pick$1w(this.rotationOriginY,h.getAttribute("y")||0)+")"),(defined$T(t)||defined$T(n))&&f.push("scale("+pick$1w(t,1)+" "+pick$1w(n,1)+")"),f.length&&h.setAttribute("transform",f.join(" "))},o.prototype.visibilitySetter=function(r,t,n){r==="inherit"?n.removeAttribute(t):this[t]!==r&&n.setAttribute(t,r),this[t]=r},o.prototype.xGetter=function(r){return this.element.nodeName==="circle"&&(r==="x"?r="cx":r==="y"&&(r="cy")),this._defaultGetter(r)},o.prototype.zIndexSetter=function(r,t){var n=this.renderer,s=this.parentGroup,a=s||n,l=a.element||n.box,h=this.element,d=l===n.box,c,f,u,p=!1,g,m=this.added,v;if(defined$T(r)?(h.setAttribute("data-z-index",r),r=+r,this[t]===r&&(m=!1)):defined$T(this[t])&&h.removeAttribute("data-z-index"),this[t]=r,m){for(r=this.zIndex,r&&s&&(s.handleZ=!0),c=l.childNodes,v=c.length-1;v>=0&&!p;v--)f=c[v],u=f.getAttribute("data-z-index"),g=!defined$T(u),f!==h&&(r<0&&g&&!d&&!v?(l.insertBefore(h,c[v]),p=!0):(pInt$7(u)<=r||g&&(!defined$T(r)||r>=0))&&(l.insertBefore(h,c[v+1]||null),p=!0));p||(l.insertBefore(h,c[d?3:0]||null),p=!0)}return p},o}();SVGElement.prototype["stroke-widthSetter"]=SVGElement.prototype.strokeSetter;SVGElement.prototype.yGetter=SVGElement.prototype.xGetter;SVGElement.prototype.matrixSetter=SVGElement.prototype.rotationOriginXSetter=SVGElement.prototype.rotationOriginYSetter=SVGElement.prototype.rotationSetter=SVGElement.prototype.scaleXSetter=SVGElement.prototype.scaleYSetter=SVGElement.prototype.translateXSetter=SVGElement.prototype.translateYSetter=SVGElement.prototype.verticalAlignSetter=function(o,r){this[r]=o,this.doTransform=!0};var RendererRegistry;(function(o){o.rendererTypes={};var r;function t(s){return s===void 0&&(s=r),o.rendererTypes[s]||o.rendererTypes[r]}o.getRendererType=t;function n(s,a,l){o.rendererTypes[s]=a,(!r||l)&&(r=s,H.Renderer=a)}o.registerRendererType=n})(RendererRegistry||(RendererRegistry={}));const RendererRegistry$1=RendererRegistry;var __extends$Y=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),defined$S=Utilities.defined,extend$1n=Utilities.extend,isNumber$L=Utilities.isNumber,merge$1j=Utilities.merge,pick$1v=Utilities.pick,removeEvent$b=Utilities.removeEvent,SVGLabel=function(o){__extends$Y(r,o);function r(t,n,s,a,l,h,d,c,f,u){var p=o.call(this)||this;p.paddingLeftSetter=p.paddingSetter,p.paddingRightSetter=p.paddingSetter,p.init(t,"g"),p.textStr=n,p.x=s,p.y=a,p.anchorX=h,p.anchorY=d,p.baseline=f,p.className=u,p.addClass(u==="button"?"highcharts-no-tooltip":"highcharts-label"),u&&p.addClass("highcharts-"+u),p.text=t.text(void 0,0,0,c).attr({zIndex:1});var g;return typeof l=="string"&&(g=/^url\((.*?)\)$/.test(l),(g||p.renderer.symbols[l])&&(p.symbolKey=l)),p.bBox=r.emptyBBox,p.padding=3,p.baselineOffset=0,p.needsBox=t.styledMode||g,p.deferredAttr={},p.alignFactor=0,p}return r.prototype.alignSetter=function(t){var n={left:0,center:.5,right:1}[t];n!==this.alignFactor&&(this.alignFactor=n,this.bBox&&isNumber$L(this.xSetting)&&this.attr({x:this.xSetting}))},r.prototype.anchorXSetter=function(t,n){this.anchorX=t,this.boxAttr(n,Math.round(t)-this.getCrispAdjust()-this.xSetting)},r.prototype.anchorYSetter=function(t,n){this.anchorY=t,this.boxAttr(n,t-this.ySetting)},r.prototype.boxAttr=function(t,n){this.box?this.box.attr(t,n):this.deferredAttr[t]=n},r.prototype.css=function(t){if(t){var n={};t=merge$1j(t),r.textProps.forEach(function(l){typeof t[l]<"u"&&(n[l]=t[l],delete t[l])}),this.text.css(n);var s="width"in n,a="fontSize"in n||"fontWeight"in n;a?this.updateTextPadding():s&&this.updateBoxSize()}return SVGElement.prototype.css.call(this,t)},r.prototype.destroy=function(){removeEvent$b(this.element,"mouseenter"),removeEvent$b(this.element,"mouseleave"),this.text&&this.text.destroy(),this.box&&(this.box=this.box.destroy()),SVGElement.prototype.destroy.call(this)},r.prototype.fillSetter=function(t,n){t&&(this.needsBox=!0),this.fill=t,this.boxAttr(n,t)},r.prototype.getBBox=function(){this.textStr&&this.bBox.width===0&&this.bBox.height===0&&this.updateBoxSize();var t=this.padding,n=pick$1v(this.paddingLeft,t);return{width:this.width,height:this.height,x:this.bBox.x-n,y:this.bBox.y-t}},r.prototype.getCrispAdjust=function(){return this.renderer.styledMode&&this.box?this.box.strokeWidth()%2/2:(this["stroke-width"]?parseInt(this["stroke-width"],10):0)%2/2},r.prototype.heightSetter=function(t){this.heightSetting=t},r.prototype.onAdd=function(){var t=this.textStr;this.text.add(this),this.attr({text:defined$S(t)?t:"",x:this.x,y:this.y}),this.box&&defined$S(this.anchorX)&&this.attr({anchorX:this.anchorX,anchorY:this.anchorY})},r.prototype.paddingSetter=function(t,n){isNumber$L(t)?t!==this[n]&&(this[n]=t,this.updateTextPadding()):this[n]=void 0},r.prototype.rSetter=function(t,n){this.boxAttr(n,t)},r.prototype.shadow=function(t){return t&&!this.renderer.styledMode&&(this.updateBoxSize(),this.box&&this.box.shadow(t)),this},r.prototype.strokeSetter=function(t,n){this.stroke=t,this.boxAttr(n,t)},r.prototype["stroke-widthSetter"]=function(t,n){t&&(this.needsBox=!0),this["stroke-width"]=t,this.boxAttr(n,t)},r.prototype["text-alignSetter"]=function(t){this.textAlign=t},r.prototype.textSetter=function(t){typeof t<"u"&&this.text.attr({text:t}),this.updateTextPadding()},r.prototype.updateBoxSize=function(){var t=this.text.element.style,n={},s=this.padding,a=this.bBox=(!isNumber$L(this.widthSetting)||!isNumber$L(this.heightSetting)||this.textAlign)&&defined$S(this.text.textStr)?this.text.getBBox():r.emptyBBox,l;this.width=this.getPaddedWidth(),this.height=(this.heightSetting||a.height||0)+2*s;var h=this.renderer.fontMetrics(t&&t.fontSize,this.text);if(this.baselineOffset=s+Math.min((this.text.firstLineMetrics||h).b,a.height||1/0),this.heightSetting&&(this.baselineOffset+=(this.heightSetting-h.h)/2),this.needsBox){if(!this.box){var d=this.box=this.symbolKey?this.renderer.symbol(this.symbolKey):this.renderer.rect();d.addClass((this.className==="button"?"":"highcharts-label-box")+(this.className?" highcharts-"+this.className+"-box":"")),d.add(this)}l=this.getCrispAdjust(),n.x=l,n.y=(this.baseline?-this.baselineOffset:0)+l,n.width=Math.round(this.width),n.height=Math.round(this.height),this.box.attr(extend$1n(n,this.deferredAttr)),this.deferredAttr={}}},r.prototype.updateTextPadding=function(){var t=this.text;this.updateBoxSize();var n=this.baseline?0:this.baselineOffset,s=pick$1v(this.paddingLeft,this.padding);defined$S(this.widthSetting)&&this.bBox&&(this.textAlign==="center"||this.textAlign==="right")&&(s+={center:.5,right:1}[this.textAlign]*(this.widthSetting-this.bBox.width)),(s!==t.x||n!==t.y)&&(t.attr("x",s),t.hasBoxWidthChanged&&(this.bBox=t.getBBox(!0)),typeof n<"u"&&t.attr("y",n)),t.x=s,t.y=n},r.prototype.widthSetter=function(t){this.widthSetting=isNumber$L(t)?t:void 0},r.prototype.getPaddedWidth=function(){var t=this.padding,n=pick$1v(this.paddingLeft,t),s=pick$1v(this.paddingRight,t);return(this.widthSetting||this.bBox.width||0)+n+s},r.prototype.xSetter=function(t){this.x=t,this.alignFactor&&(t-=this.alignFactor*this.getPaddedWidth(),this["forceAnimate:x"]=!0),this.xSetting=Math.round(t),this.attr("translateX",this.xSetting)},r.prototype.ySetter=function(t){this.ySetting=this.y=Math.round(t),this.attr("translateY",this.ySetting)},r.emptyBBox={width:0,height:0,x:0,y:0},r.textProps=["color","direction","fontFamily","fontSize","fontStyle","fontWeight","lineHeight","textAlign","textDecoration","textOutline","textOverflow","width"],r}(SVGElement),defined$R=Utilities.defined,isNumber$K=Utilities.isNumber,pick$1u=Utilities.pick;function arc$1(o,r,t,n,s){var a=[];if(s){var l=s.start||0,h=pick$1u(s.r,t),d=pick$1u(s.r,n||t),c=.001,f=Math.abs((s.end||0)-l-2*Math.PI)<c,u=(s.end||0)-c,p=s.innerR,g=pick$1u(s.open,f),m=Math.cos(l),v=Math.sin(l),x=Math.cos(u),y=Math.sin(u),b=pick$1u(s.longArc,u-l-Math.PI<c?0:1);a.push(["M",o+h*m,r+d*v],["A",h,d,0,b,pick$1u(s.clockwise,1),o+h*x,r+d*y]),defined$R(p)&&a.push(g?["M",o+p*x,r+p*y]:["L",o+p*x,r+p*y],["A",p,p,0,b,defined$R(s.clockwise)?1-s.clockwise:0,o+p*m,r+p*v]),g||a.push(["Z"])}return a}function callout(o,r,t,n,s){var a=6,l=6,h=Math.min(s&&s.r||0,t,n),d=h+l,c=s&&s.anchorX,f=s&&s.anchorY||0,u=roundedRect(o,r,t,n,{r:h});return isNumber$K(c)&&(o+c>=t?f>r+d&&f<r+n-d?u.splice(3,1,["L",o+t,f-l],["L",o+t+a,f],["L",o+t,f+l],["L",o+t,r+n-h]):u.splice(3,1,["L",o+t,n/2],["L",c,f],["L",o+t,n/2],["L",o+t,r+n-h]):o+c<=0?f>r+d&&f<r+n-d?u.splice(7,1,["L",o,f+l],["L",o-a,f],["L",o,f-l],["L",o,r+h]):u.splice(7,1,["L",o,n/2],["L",c,f],["L",o,n/2],["L",o,r+h]):f&&f>n&&c>o+d&&c<o+t-d?u.splice(5,1,["L",c+l,r+n],["L",c,r+n+a],["L",c-l,r+n],["L",o+h,r+n]):f&&f<0&&c>o+d&&c<o+t-d&&u.splice(1,1,["L",c-l,r],["L",c,r-a],["L",c+l,r],["L",t-h,r])),u}function circle(o,r,t,n){return arc$1(o+t/2,r+n/2,t/2,n/2,{start:Math.PI*.5,end:Math.PI*2.5,open:!1})}function diamond(o,r,t,n){return[["M",o+t/2,r],["L",o+t,r+n/2],["L",o+t/2,r+n],["L",o,r+n/2],["Z"]]}function rect(o,r,t,n,s){return s&&s.r?roundedRect(o,r,t,n,s):[["M",o,r],["L",o+t,r],["L",o+t,r+n],["L",o,r+n],["Z"]]}function roundedRect(o,r,t,n,s){var a=s&&s.r||0;return[["M",o+a,r],["L",o+t-a,r],["C",o+t,r,o+t,r,o+t,r+a],["L",o+t,r+n-a],["C",o+t,r+n,o+t,r+n,o+t-a,r+n],["L",o+a,r+n],["C",o,r+n,o,r+n,o,r+n-a],["L",o,r+a],["C",o,r,o,r,o+a,r]]}function triangle(o,r,t,n){return[["M",o+t/2,r],["L",o+t,r+n],["L",o,r+n],["Z"]]}function triangleDown(o,r,t,n){return[["M",o,r],["L",o+t,r],["L",o+t/2,r+n],["Z"]]}var Symbols={arc:arc$1,callout,circle,diamond,rect,roundedRect,square:rect,triangle,"triangle-down":triangleDown},doc$k=H.doc,SVG_NS$1=H.SVG_NS,attr$5=Utilities.attr,isString$9=Utilities.isString,objectEach$v=Utilities.objectEach,pick$1t=Utilities.pick,TextBuilder=function(){function o(r){var t=r.styles;this.renderer=r.renderer,this.svgElement=r,this.width=r.textWidth,this.textLineHeight=t&&t.lineHeight,this.textOutline=t&&t.textOutline,this.ellipsis=!!(t&&t.textOverflow==="ellipsis"),this.noWrap=!!(t&&t.whiteSpace==="nowrap"),this.fontSize=t&&t.fontSize}return o.prototype.buildSVG=function(){var r=this.svgElement,t=r.element,n=r.renderer,s=pick$1t(r.textStr,"").toString(),a=s.indexOf("<")!==-1,l=t.childNodes,h=this.width&&!r.added&&n.box,d=/<br.*?>/g,c=[s,this.ellipsis,this.noWrap,this.textLineHeight,this.textOutline,this.fontSize,this.width].join(",");if(c!==r.textCache){r.textCache=c,delete r.actualWidth;for(var f=l.length;f--;)t.removeChild(l[f]);if(!a&&!this.ellipsis&&!this.width&&(s.indexOf(" ")===-1||this.noWrap&&!d.test(s)))t.appendChild(doc$k.createTextNode(this.unescapeEntities(s)));else if(s!==""){h&&h.appendChild(t);var u=new AST(s);this.modifyTree(u.nodes),u.addToDOM(r.element),this.modifyDOM(),this.ellipsis&&(t.textContent||"").indexOf("…")!==-1&&r.attr("title",this.unescapeEntities(r.textStr||"",["&lt;","&gt;"])),h&&h.removeChild(t)}isString$9(this.textOutline)&&r.applyTextOutline&&r.applyTextOutline(this.textOutline)}},o.prototype.modifyDOM=function(){var r=this,t=this.svgElement,n=attr$5(t.element,"x");t.firstLineMetrics=void 0;for(var s;(s=t.element.firstChild)&&/^[\s\u200B]*$/.test(s.textContent||" ");)t.element.removeChild(s);[].forEach.call(t.element.querySelectorAll("tspan.highcharts-br"),function(d,c){d.nextSibling&&d.previousSibling&&(c===0&&d.previousSibling.nodeType===1&&(t.firstLineMetrics=t.renderer.fontMetrics(void 0,d.previousSibling)),attr$5(d,{dy:r.getLineHeight(d.nextSibling),x:n}))});var a=this.width||0;if(a){var l=function(d,c){var f=d.textContent||"",u=f.replace(/([^\^])-/g,"$1- ").split(" "),p=!r.noWrap&&(u.length>1||t.element.childNodes.length>1),g=r.getLineHeight(c),m=0,v=t.actualWidth;if(r.ellipsis)f&&r.truncate(d,f,void 0,0,Math.max(0,a-parseInt(r.fontSize||12,10)),function(b,$){return b.substring(0,$)+"…"});else if(p){for(var x=[],y=[];c.firstChild&&c.firstChild!==d;)y.push(c.firstChild),c.removeChild(c.firstChild);for(;u.length;)u.length&&!r.noWrap&&m>0&&(x.push(d.textContent||""),d.textContent=u.join(" ").replace(/- /g,"-")),r.truncate(d,void 0,u,m===0&&v||0,a,function(b,$){return u.slice(0,$).join(" ").replace(/- /g,"-")}),v=t.actualWidth,m++;y.forEach(function(b){c.insertBefore(b,d)}),x.forEach(function(b){c.insertBefore(doc$k.createTextNode(b),d);var $=doc$k.createElementNS(SVG_NS$1,"tspan");$.textContent="​",attr$5($,{dy:g,x:n}),c.insertBefore($,d)})}},h=function(d){var c=[].slice.call(d.childNodes);c.forEach(function(f){f.nodeType===Node.TEXT_NODE?l(f,d):(f.className.baseVal.indexOf("highcharts-br")!==-1&&(t.actualWidth=0),h(f))})};h(t.element)}},o.prototype.getLineHeight=function(r){var t,n=r.nodeType===Node.TEXT_NODE?r.parentElement:r;return this.renderer.styledMode||(t=n&&/(px|em)$/.test(n.style.fontSize)?n.style.fontSize:this.fontSize||this.renderer.style.fontSize||12),this.textLineHeight?parseInt(this.textLineHeight.toString(),10):this.renderer.fontMetrics(t,n||this.svgElement.element).h},o.prototype.modifyTree=function(r){var t=this,n=function(s,a){var l=s.tagName,h=t.renderer.styledMode,d=s.attributes||{};if(l==="b"||l==="strong"?h?d.class="highcharts-strong":d.style="font-weight:bold;"+(d.style||""):(l==="i"||l==="em")&&(h?d.class="highcharts-emphasized":d.style="font-style:italic;"+(d.style||"")),isString$9(d.style)&&(d.style=d.style.replace(/(;| |^)color([ :])/,"$1fill$2")),l==="br"){d.class="highcharts-br",s.textContent="​";var c=r[a+1];c&&c.textContent&&(c.textContent=c.textContent.replace(/^ +/gm,""))}l!=="#text"&&l!=="a"&&(s.tagName="tspan"),s.attributes=d,s.children&&s.children.filter(function(f){return f.tagName!=="#text"}).forEach(n)};r.forEach(n)},o.prototype.truncate=function(r,t,n,s,a,l){var h=this.svgElement,d=h.renderer,c=h.rotation,f=[],u=n?1:0,p=(t||n||"").length,g=p,m,v,x=function(y,b){var $=b||y,S=r.parentNode;if(S&&typeof f[$]>"u")if(S.getSubStringLength)try{f[$]=s+S.getSubStringLength(0,n?$+1:$)}catch{}else d.getSpanWidth&&(r.textContent=l(t||n,y),f[$]=s+d.getSpanWidth(h,r));return f[$]};if(h.rotation=0,v=x(r.textContent.length),s+v>a){for(;u<=p;)g=Math.ceil((u+p)/2),n&&(m=l(n,g)),v=x(g,m&&m.length-1),u===p?u=p+1:v>a?p=g-1:u=g;p===0?r.textContent="":t&&p===t.length-1||(r.textContent=m||l(t||n,g))}n&&n.splice(0,g),h.actualWidth=v,h.rotation=c},o.prototype.unescapeEntities=function(r,t){return objectEach$v(this.renderer.escapes,function(n,s){(!t||t.indexOf(n)===-1)&&(r=r.toString().replace(new RegExp(n,"g"),s))}),r},o}(),charts$4=H.charts,deg2rad$7=H.deg2rad,doc$j=H.doc,isFirefox$3=H.isFirefox,isMS$2=H.isMS,isWebKit$1=H.isWebKit,noop$k=H.noop,SVG_NS=H.SVG_NS,symbolSizes=H.symbolSizes,win$c=H.win,addEvent$10=Utilities.addEvent,attr$4=Utilities.attr,createElement$8=Utilities.createElement,css$b=Utilities.css,defined$Q=Utilities.defined,destroyObjectProperties$9=Utilities.destroyObjectProperties,extend$1m=Utilities.extend,isArray$k=Utilities.isArray,isNumber$J=Utilities.isNumber,isObject$c=Utilities.isObject,isString$8=Utilities.isString,merge$1i=Utilities.merge,pick$1s=Utilities.pick,pInt$6=Utilities.pInt,uniqueKey$6=Utilities.uniqueKey,hasInternalReferenceBug,SVGRenderer=function(){function o(r,t,n,s,a,l,h){this.alignedObjects=void 0,this.box=void 0,this.boxWrapper=void 0,this.cache=void 0,this.cacheKeys=void 0,this.chartIndex=void 0,this.defs=void 0,this.globalAnimation=void 0,this.gradients=void 0,this.height=void 0,this.imgCount=void 0,this.isSVG=void 0,this.style=void 0,this.url=void 0,this.width=void 0,this.init(r,t,n,s,a,l,h)}return o.prototype.init=function(r,t,n,s,a,l,h){var d=this,c=d.createElement("svg").attr({version:"1.1",class:"highcharts-root"}),f=c.element;h||c.css(this.getStyle(s)),r.appendChild(f),attr$4(r,"dir","ltr"),r.innerHTML.indexOf("xmlns")===-1&&attr$4(f,"xmlns",this.SVG_NS),d.isSVG=!0,this.box=f,this.boxWrapper=c,d.alignedObjects=[],this.url=this.getReferenceURL();var u=this.createElement("desc").add();u.element.appendChild(doc$j.createTextNode("Created with Highcharts 9.2.2")),d.defs=this.createElement("defs").add(),d.allowHTML=l,d.forExport=a,d.styledMode=h,d.gradients={},d.cache={},d.cacheKeys=[],d.imgCount=0,d.setSize(t,n,!1);var p,g;isFirefox$3&&r.getBoundingClientRect&&(p=function(){css$b(r,{left:0,top:0}),g=r.getBoundingClientRect(),css$b(r,{left:Math.ceil(g.left)-g.left+"px",top:Math.ceil(g.top)-g.top+"px"})},p(),d.unSubPixelFix=addEvent$10(win$c,"resize",p))},o.prototype.definition=function(r){var t=new AST([r]);return t.addToDOM(this.defs.element)},o.prototype.getReferenceURL=function(){if((isFirefox$3||isWebKit$1)&&doc$j.getElementsByTagName("base").length){if(!defined$Q(hasInternalReferenceBug)){var r=uniqueKey$6(),t=new AST([{tagName:"svg",attributes:{width:8,height:8},children:[{tagName:"defs",children:[{tagName:"clipPath",attributes:{id:r},children:[{tagName:"rect",attributes:{width:4,height:4}}]}]},{tagName:"rect",attributes:{id:"hitme",width:8,height:8,"clip-path":"url(#"+r+")",fill:"rgba(0,0,0,0.001)"}}]}]),n=t.addToDOM(doc$j.body);css$b(n,{position:"fixed",top:0,left:0,zIndex:9e5});var s=doc$j.elementFromPoint(6,6);hasInternalReferenceBug=(s&&s.id)==="hitme",doc$j.body.removeChild(n)}if(hasInternalReferenceBug)return win$c.location.href.split("#")[0].replace(/<[^>]*>/g,"").replace(/([\('\)])/g,"\\$1").replace(/ /g,"%20")}return""},o.prototype.getStyle=function(r){return this.style=extend$1m({fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',fontSize:"12px"},r),this.style},o.prototype.setStyle=function(r){this.boxWrapper.css(this.getStyle(r))},o.prototype.isHidden=function(){return!this.boxWrapper.getBBox().width},o.prototype.destroy=function(){var r=this,t=r.defs;return r.box=null,r.boxWrapper=r.boxWrapper.destroy(),destroyObjectProperties$9(r.gradients||{}),r.gradients=null,t&&(r.defs=t.destroy()),r.unSubPixelFix&&r.unSubPixelFix(),r.alignedObjects=null,null},o.prototype.createElement=function(r){var t=new this.Element;return t.init(this,r),t},o.prototype.getRadialAttr=function(r,t){return{cx:r[0]-r[2]/2+(t.cx||0)*r[2],cy:r[1]-r[2]/2+(t.cy||0)*r[2],r:(t.r||0)*r[2]}},o.prototype.buildText=function(r){new TextBuilder(r).buildSVG()},o.prototype.getContrast=function(r){return r=Color.parse(r).rgba,r[0]*=1,r[1]*=1.2,r[2]*=.5,r[0]+r[1]+r[2]>1.8*255?"#000000":"#FFFFFF"},o.prototype.button=function(r,t,n,s,a,l,h,d,c,f){var u=this.label(r,t,n,c,void 0,void 0,f,void 0,"button"),p=this.styledMode,g=0,m=a?merge$1i(a):{},v=m&&m.style||{};m=AST.filterUserAttributes(m),u.attr(merge$1i({padding:8,r:2},m));var x,y,b,$;return p||(m=merge$1i({fill:palette.neutralColor3,stroke:palette.neutralColor20,"stroke-width":1,style:{color:palette.neutralColor80,cursor:"pointer",fontWeight:"normal"}},{style:v},m),x=m.style,delete m.style,l=merge$1i(m,{fill:palette.neutralColor10},AST.filterUserAttributes(l||{})),y=l.style,delete l.style,h=merge$1i(m,{fill:palette.highlightColor10,style:{color:palette.neutralColor100,fontWeight:"bold"}},AST.filterUserAttributes(h||{})),b=h.style,delete h.style,d=merge$1i(m,{style:{color:palette.neutralColor20}},AST.filterUserAttributes(d||{})),$=d.style,delete d.style),addEvent$10(u.element,isMS$2?"mouseover":"mouseenter",function(){g!==3&&u.setState(1)}),addEvent$10(u.element,isMS$2?"mouseout":"mouseleave",function(){g!==3&&u.setState(g)}),u.setState=function(S){S!==1&&(u.state=g=S),u.removeClass(/highcharts-button-(normal|hover|pressed|disabled)/).addClass("highcharts-button-"+["normal","hover","pressed","disabled"][S||0]),p||u.attr([m,l,h,d][S||0]).css([x,y,b,$][S||0])},p||u.attr(m).css(extend$1m({cursor:"default"},x)),u.on("touchstart",function(S){return S.stopPropagation()}).on("click",function(S){g!==3&&s.call(u,S)})},o.prototype.crispLine=function(r,t,n){n===void 0&&(n="round");var s=r[0],a=r[1];return defined$Q(s[1])&&s[1]===a[1]&&(s[1]=a[1]=Math[n](s[1])-t%2/2),defined$Q(s[2])&&s[2]===a[2]&&(s[2]=a[2]=Math[n](s[2])+t%2/2),r},o.prototype.path=function(r){var t=this.styledMode?{}:{fill:"none"};return isArray$k(r)?t.d=r:isObject$c(r)&&extend$1m(t,r),this.createElement("path").attr(t)},o.prototype.circle=function(r,t,n){var s=isObject$c(r)?r:typeof r>"u"?{}:{x:r,y:t,r:n},a=this.createElement("circle");return a.xSetter=a.ySetter=function(l,h,d){d.setAttribute("c"+h,l)},a.attr(s)},o.prototype.arc=function(r,t,n,s,a,l){var h;isObject$c(r)?(h=r,t=h.y,n=h.r,s=h.innerR,a=h.start,l=h.end,r=h.x):h={innerR:s,start:a,end:l};var d=this.symbol("arc",r,t,n,n,h);return d.r=n,d},o.prototype.rect=function(r,t,n,s,a,l){a=isObject$c(r)?r.r:a;var h=this.createElement("rect"),d=isObject$c(r)?r:typeof r>"u"?{}:{x:r,y:t,width:Math.max(n,0),height:Math.max(s,0)};return this.styledMode||(typeof l<"u"&&(d["stroke-width"]=l,d=h.crisp(d)),d.fill="none"),a&&(d.r=a),h.rSetter=function(c,f,u){h.r=c,attr$4(u,{rx:c,ry:c})},h.rGetter=function(){return h.r||0},h.attr(d)},o.prototype.setSize=function(r,t,n){var s=this;s.width=r,s.height=t,s.boxWrapper.animate({width:r,height:t},{step:function(){this.attr({viewBox:"0 0 "+this.attr("width")+" "+this.attr("height")})},duration:pick$1s(n,!0)?void 0:0}),s.alignElements()},o.prototype.g=function(r){var t=this.createElement("g");return r?t.attr({class:"highcharts-"+r}):t},o.prototype.image=function(r,t,n,s,a,l){var h={preserveAspectRatio:"none"},d=function(p,g){p.setAttributeNS?p.setAttributeNS("http://www.w3.org/1999/xlink","href",g):p.setAttribute("hc-svg-href",g)};arguments.length>1&&extend$1m(h,{x:t,y:n,width:s,height:a});var c=this.createElement("image").attr(h),f=function(p){d(c.element,r),l.call(c,p)};if(l){d(c.element,"data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==");var u=new win$c.Image;addEvent$10(u,"load",f),u.src=r,u.complete&&f({})}else d(c.element,r);return c},o.prototype.symbol=function(r,t,n,s,a,l){var h=this,d=/^url\((.*?)\)$/,c=d.test(r),f=!c&&(this.symbols[r]?r:"circle"),u=f&&this.symbols[f],p,g,m,v;if(u)typeof t=="number"&&(g=u.call(this.symbols,Math.round(t||0),Math.round(n||0),s||0,a||0,l)),p=this.path(g),h.styledMode||p.attr("fill","none"),extend$1m(p,{symbolName:f||void 0,x:t,y:n,width:s,height:a}),l&&extend$1m(p,l);else if(c){m=r.match(d)[1];var x=p=this.image(m);x.imgwidth=pick$1s(symbolSizes[m]&&symbolSizes[m].width,l&&l.width),x.imgheight=pick$1s(symbolSizes[m]&&symbolSizes[m].height,l&&l.height),v=function(y){return y.attr({width:y.width,height:y.height})},["width","height"].forEach(function(y){x[y+"Setter"]=function(b,$){var S=this["img"+$];if(this[$]=b,defined$Q(S)&&(l&&l.backgroundSize==="within"&&this.width&&this.height&&(S=Math.round(S*Math.min(this.width/this.imgwidth,this.height/this.imgheight))),this.element&&this.element.setAttribute($,S),!this.alignByTranslate)){var k=((this[$]||0)-S)/2,A=$==="width"?{translateX:k}:{translateY:k};this.attr(A)}}}),defined$Q(t)&&x.attr({x:t,y:n}),x.isImg=!0,defined$Q(x.imgwidth)&&defined$Q(x.imgheight)?v(x):(x.attr({width:0,height:0}),createElement$8("img",{onload:function(){var y=charts$4[h.chartIndex];this.width===0&&(css$b(this,{position:"absolute",top:"-999em"}),doc$j.body.appendChild(this)),symbolSizes[m]={width:this.width,height:this.height},x.imgwidth=this.width,x.imgheight=this.height,x.element&&v(x),this.parentNode&&this.parentNode.removeChild(this),h.imgCount--,!h.imgCount&&y&&!y.hasLoaded&&y.onload()},src:m}),this.imgCount++)}return p},o.prototype.clipRect=function(r,t,n,s){var a=uniqueKey$6()+"-",l=this.createElement("clipPath").attr({id:a}).add(this.defs),h=this.rect(r,t,n,s,0).add(l);return h.id=a,h.clipPath=l,h.count=0,h},o.prototype.text=function(r,t,n,s){var a=this,l={};if(s&&(a.allowHTML||!a.forExport))return a.html(r,t,n);l.x=Math.round(t||0),n&&(l.y=Math.round(n)),defined$Q(r)&&(l.text=r);var h=a.createElement("text").attr(l);return(!s||a.forExport&&!a.allowHTML)&&(h.xSetter=function(d,c,f){for(var u=f.getElementsByTagName("tspan"),p=f.getAttribute(c),g=0,m=void 0;g<u.length;g++)m=u[g],m.getAttribute(c)===p&&m.setAttribute(c,d);f.setAttribute(c,d)}),h},o.prototype.fontMetrics=function(r,t){(this.styledMode||!/px/.test(r))&&win$c.getComputedStyle?r=t&&SVGElement.prototype.getStyle.call(t,"font-size"):r=r||t&&t.style&&t.style.fontSize||this.style&&this.style.fontSize,/px/.test(r)?r=pInt$6(r):r=12;var n=r<24?r+3:Math.round(r*1.2),s=Math.round(n*.8);return{h:n,b:s,f:r}},o.prototype.rotCorr=function(r,t,n){var s=r;return t&&n&&(s=Math.max(s*Math.cos(t*deg2rad$7),4)),{x:-r/3*Math.sin(t*deg2rad$7),y:s}},o.prototype.pathToSegments=function(r){for(var t=[],n=[],s={A:8,C:7,H:2,L:3,M:3,Q:5,S:5,T:3,V:2},a=0;a<r.length;a++)isString$8(n[0])&&isNumber$J(r[a])&&n.length===s[n[0].toUpperCase()]&&r.splice(a,0,n[0].replace("M","L").replace("m","l")),typeof r[a]=="string"&&(n.length&&t.push(n.slice(0)),n.length=0),n.push(r[a]);return t.push(n.slice(0)),t},o.prototype.label=function(r,t,n,s,a,l,h,d,c){return new SVGLabel(this,r,t,n,s,a,l,h,d,c)},o.prototype.alignElements=function(){this.alignedObjects.forEach(function(r){return r.align()})},o}();extend$1m(SVGRenderer.prototype,{Element:SVGElement,SVG_NS,escapes:{"&":"&amp;","<":"&lt;",">":"&gt;","'":"&#39;",'"':"&quot;"},symbols:Symbols,draw:noop$k});RendererRegistry$1.registerRendererType("svg",SVGRenderer,!0);var __extends$X=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),isFirefox$2=H.isFirefox,isMS$1=H.isMS,isWebKit=H.isWebKit,win$b=H.win,css$a=Utilities.css,defined$P=Utilities.defined,extend$1l=Utilities.extend,pick$1r=Utilities.pick,pInt$5=Utilities.pInt,HTMLElement=function(o){__extends$X(r,o);function r(){return o!==null&&o.apply(this,arguments)||this}return r.compose=function(t){if(r.composedClasses.indexOf(t)===-1){r.composedClasses.push(t);var n=r.prototype,s=t.prototype;s.getSpanCorrection=n.getSpanCorrection,s.htmlCss=n.htmlCss,s.htmlGetBBox=n.htmlGetBBox,s.htmlUpdateTransform=n.htmlUpdateTransform,s.setSpanRotation=n.setSpanRotation}return t},r.prototype.getSpanCorrection=function(t,n,s){this.xCorr=-t*s,this.yCorr=-n},r.prototype.htmlCss=function(t){var n=this,s=n.element,a=s.tagName==="SPAN"&&t&&"width"in t,l=pick$1r(a&&t.width,void 0),h;return a&&(delete t.width,n.textWidth=l,h=!0),t&&t.textOverflow==="ellipsis"&&(t.whiteSpace="nowrap",t.overflow="hidden"),n.styles=extend$1l(n.styles,t),css$a(n.element,t),h&&n.htmlUpdateTransform(),n},r.prototype.htmlGetBBox=function(){var t=this,n=t.element;return{x:n.offsetLeft,y:n.offsetTop,width:n.offsetWidth,height:n.offsetHeight}},r.prototype.htmlUpdateTransform=function(){if(!this.added){this.alignOnAdd=!0;return}var t=this,n=t.renderer,s=t.element,a=t.translateX||0,l=t.translateY||0,h=t.x||0,d=t.y||0,c=t.textAlign||"left",f={left:0,center:.5,right:1}[c],u=t.styles,p=u&&u.whiteSpace;function g(){return css$a(s,{width:"",whiteSpace:p||"nowrap"}),s.offsetWidth}if(css$a(s,{marginLeft:a,marginTop:l}),!n.styledMode&&t.shadows&&t.shadows.forEach(function(b){css$a(b,{marginLeft:a+1,marginTop:l+1})}),t.inverted&&[].forEach.call(s.childNodes,function(b){n.invertChild(b,s)}),s.tagName==="SPAN"){var m=t.rotation,v=t.textWidth&&pInt$5(t.textWidth),x=[m,c,s.innerHTML,t.textWidth,t.textAlign].join(","),y=void 0;v!==t.oldTextWidth&&(v>t.oldTextWidth||(t.textPxLength||g())>v)&&(/[ \-]/.test(s.textContent||s.innerText)||s.style.textOverflow==="ellipsis")?(css$a(s,{width:v+"px",display:"block",whiteSpace:p||"normal"}),t.oldTextWidth=v,t.hasBoxWidthChanged=!0):t.hasBoxWidthChanged=!1,x!==t.cTT&&(y=n.fontMetrics(s.style.fontSize,s).b,defined$P(m)&&(m!==(t.oldRotation||0)||c!==t.oldAlign)&&t.setSpanRotation(m,f,y),t.getSpanCorrection(!defined$P(m)&&t.textPxLength||s.offsetWidth,y,f,m,c)),css$a(s,{left:h+(t.xCorr||0)+"px",top:d+(t.yCorr||0)+"px"}),t.cTT=x,t.oldRotation=m,t.oldAlign=c}},r.prototype.setSpanRotation=function(t,n,s){var a=function(){return isMS$1&&!/Edge/.test(win$b.navigator.userAgent)?"-ms-transform":isWebKit?"-webkit-transform":isFirefox$2?"MozTransform":win$b.opera?"-o-transform":void 0},l={},h=a();h&&(l[h]=l.transform="rotate("+t+"deg)",l[h+(isFirefox$2?"Origin":"-origin")]=l.transformOrigin=n*100+"% "+s+"px",css$a(this.element,l))},r.composedClasses=[],r}(SVGElement),__extends$W=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),attr$3=Utilities.attr,createElement$7=Utilities.createElement,extend$1k=Utilities.extend,pick$1q=Utilities.pick,HTMLRenderer=function(o){__extends$W(r,o);function r(){return o!==null&&o.apply(this,arguments)||this}return r.compose=function(t){if(r.composedClasses.indexOf(t)===-1){r.composedClasses.push(t);var n=r.prototype,s=t.prototype;s.html=n.html}return t},r.prototype.html=function(t,n,s){var a=this.createElement("span"),l=a.element,h=a.renderer,d=h.isSVG,c=function(f,u){["opacity","visibility"].forEach(function(p){f[p+"Setter"]=function(g,m,v){var x=f.div?f.div.style:u;SVGElement.prototype[p+"Setter"].call(this,g,m,v),x&&(x[m]=g)}}),f.addedSetters=!0};return a.textSetter=function(f){f!==this.textStr&&(delete this.bBox,delete this.oldTextWidth,AST.setElementHTML(this.element,pick$1q(f,"")),this.textStr=f,a.doTransform=!0)},d&&c(a,a.element.style),a.xSetter=a.ySetter=a.alignSetter=a.rotationSetter=function(f,u){u==="align"?a.alignValue=a.textAlign=f:a[u]=f,a.doTransform=!0},a.afterSetters=function(){this.doTransform&&(this.htmlUpdateTransform(),this.doTransform=!1)},a.attr({text:t,x:Math.round(n),y:Math.round(s)}).css({position:"absolute"}),h.styledMode||a.css({fontFamily:this.style.fontFamily,fontSize:this.style.fontSize}),l.style.whiteSpace="nowrap",a.css=a.htmlCss,d&&(a.add=function(f){var u=h.box.parentNode,p=[],g,m;if(this.parentGroup=f,f){if(g=f.div,!g){for(m=f;m;)p.push(m),m=m.parentGroup;p.reverse().forEach(function(v){var x=attr$3(v.element,"class");function y(S,k){v[k]=S,k==="translateX"?$.left=S+"px":$.top=S+"px",v.doTransform=!0}var b=v.styles||{};g=v.div=v.div||createElement$7("div",x?{className:x}:void 0,{position:"absolute",left:(v.translateX||0)+"px",top:(v.translateY||0)+"px",display:v.display,opacity:v.opacity,cursor:b.cursor,pointerEvents:b.pointerEvents,visibility:v.visibility},g||u);var $=g.style;extend$1k(v,{classSetter:function(S){return function(k){this.element.setAttribute("class",k),S.className=k}}(g),on:function(){return p[0].div&&a.on.apply({element:p[0].div,onEvents:v.onEvents},arguments),v},translateXSetter:y,translateYSetter:y}),v.addedSetters||c(v)})}}else g=u;return g.appendChild(l),a.added=!0,a.alignOnAdd&&a.htmlUpdateTransform(),a}),a},r.composedClasses=[],r}(SVGRenderer),AxisDefaults;(function(o){o.defaultXAxisOptions={alignTicks:!0,allowDecimals:void 0,panningEnabled:!0,zIndex:2,zoomEnabled:!0,dateTimeLabelFormats:{millisecond:{main:"%H:%M:%S.%L",range:!1},second:{main:"%H:%M:%S",range:!1},minute:{main:"%H:%M",range:!1},hour:{main:"%H:%M",range:!1},day:{main:"%e. %b"},week:{main:"%e. %b"},month:{main:"%b '%y"},year:{main:"%Y"}},endOnTick:!1,gridLineDashStyle:"Solid",gridZIndex:1,labels:{autoRotation:void 0,autoRotationLimit:80,distance:void 0,enabled:!0,indentation:10,overflow:"justify",padding:5,reserveSpace:void 0,rotation:void 0,staggerLines:0,step:0,useHTML:!1,x:0,zIndex:7,style:{color:palette.neutralColor60,cursor:"default",fontSize:"11px"}},maxPadding:.01,minorGridLineDashStyle:"Solid",minorTickLength:2,minorTickPosition:"outside",minPadding:.01,offset:void 0,opposite:!1,reversed:void 0,reversedStacks:!1,showEmpty:!0,showFirstLabel:!0,showLastLabel:!0,startOfWeek:1,startOnTick:!1,tickLength:10,tickPixelInterval:100,tickmarkPlacement:"between",tickPosition:"outside",title:{align:"middle",rotation:0,useHTML:!1,x:0,y:0,style:{color:palette.neutralColor60}},type:"linear",uniqueNames:!0,visible:!0,minorGridLineColor:palette.neutralColor5,minorGridLineWidth:1,minorTickColor:palette.neutralColor40,lineColor:palette.highlightColor20,lineWidth:1,gridLineColor:palette.neutralColor10,gridLineWidth:void 0,tickColor:palette.highlightColor20},o.defaultYAxisOptions={reversedStacks:!0,endOnTick:!0,maxPadding:.05,minPadding:.05,tickPixelInterval:72,showLastLabel:!0,labels:{x:-8},startOnTick:!0,title:{rotation:270,text:"Values"},stackLabels:{animation:{},allowOverlap:!1,enabled:!1,crop:!0,overflow:"justify",formatter:function(){var r=this.axis.chart.numberFormatter;return r(this.total,-1)},style:{color:palette.neutralColor100,fontSize:"11px",fontWeight:"bold",textOutline:"1px contrast"}},gridLineWidth:1,lineWidth:0},o.defaultLeftAxisOptions={labels:{x:-15},title:{rotation:270}},o.defaultRightAxisOptions={labels:{x:15},title:{rotation:90}},o.defaultBottomAxisOptions={labels:{autoRotation:[-45],x:0},margin:15,title:{rotation:0}},o.defaultTopAxisOptions={labels:{autoRotation:[-45],x:0},margin:15,title:{rotation:0}}})(AxisDefaults||(AxisDefaults={}));const AxisDefaults$1=AxisDefaults;var addEvent$$=Utilities.addEvent,isFunction$3=Utilities.isFunction,objectEach$u=Utilities.objectEach,removeEvent$a=Utilities.removeEvent,registerEventOptions$3=function(o,r){o.eventOptions=o.eventOptions||{},objectEach$u(r.events,function(t,n){o.eventOptions[n]!==t&&(o.eventOptions[n]&&(removeEvent$a(o,n,o.eventOptions[n]),delete o.eventOptions[n]),isFunction$3(t)&&(o.eventOptions[n]=t,addEvent$$(o,n,t)))})},exports$3={registerEventOptions:registerEventOptions$3},deg2rad$6=H.deg2rad,clamp$h=Utilities.clamp,correctFloat$c=Utilities.correctFloat,defined$O=Utilities.defined,destroyObjectProperties$8=Utilities.destroyObjectProperties,extend$1j=Utilities.extend,fireEvent$z=Utilities.fireEvent,isNumber$I=Utilities.isNumber,merge$1h=Utilities.merge,objectEach$t=Utilities.objectEach,pick$1p=Utilities.pick,Tick=function(){function o(r,t,n,s,a){this.isNew=!0,this.isNewLabel=!0,this.axis=r,this.pos=t,this.type=n||"",this.parameters=a||{},this.tickmarkOffset=this.parameters.tickmarkOffset,this.options=this.parameters.options,fireEvent$z(this,"init"),!n&&!s&&this.addLabel()}return o.prototype.addLabel=function(){var r=this,t=r.axis,n=t.options,s=t.chart,a=t.categories,l=t.logarithmic,h=t.names,d=r.pos,c=pick$1p(r.options&&r.options.labels,n.labels),f=t.tickPositions,u=d===f[0],p=d===f[f.length-1],g=(!c.step||c.step===1)&&t.tickInterval===1,m=f.info,v=r.label,x,y,b,$=this.parameters.category||(a?pick$1p(a[d],h[d],d):d);l&&isNumber$I($)&&($=correctFloat$c(l.lin2log($))),t.dateTime&&(m?(y=s.time.resolveDTLFormat(n.dateTimeLabelFormats[!n.grid&&m.higherRanks[d]||m.unitName]),x=y.main):isNumber$I($)&&(x=t.dateTime.getXDateFormat($,n.dateTimeLabelFormats||{}))),r.isFirst=u,r.isLast=p;var S={axis:t,chart:s,dateTimeLabelFormat:x,isFirst:u,isLast:p,pos:d,tick:r,tickPositionInfo:m,value:$};fireEvent$z(this,"labelFormat",S);var k=function(E){return c.formatter?c.formatter.call(E,E):c.format?(E.text=t.defaultLabelFormatter.call(E),FormatUtilities.format(c.format,E,s)):t.defaultLabelFormatter.call(E,E)},A=k.call(S,S),P=y&&y.list;P?r.shortenLabel=function(){for(b=0;b<P.length;b++)if(extend$1j(S,{dateTimeLabelFormat:P[b]}),v.attr({text:k.call(S,S)}),v.getBBox().width<t.getSlotWidth(r)-2*c.padding)return;v.attr({text:""})}:r.shortenLabel=void 0,g&&t._addedPlotLB&&r.moveLabel(A,c),!defined$O(v)&&!r.movedLabel?(r.label=v=r.createLabel({x:0,y:0},A,c),r.rotation=0):v&&v.textStr!==A&&!g&&(v.textWidth&&!c.style.width&&!v.styles.width&&v.css({width:null}),v.attr({text:A}),v.textPxLength=v.getBBox().width)},o.prototype.createLabel=function(r,t,n){var s=this.axis,a=s.chart,l=defined$O(t)&&n.enabled?a.renderer.text(t,r.x,r.y,n.useHTML).add(s.labelGroup):null;return l&&(a.styledMode||l.css(merge$1h(n.style)),l.textPxLength=l.getBBox().width),l},o.prototype.destroy=function(){destroyObjectProperties$8(this,this.axis)},o.prototype.getPosition=function(r,t,n,s){var a=this.axis,l=a.chart,h=s&&l.oldChartHeight||l.chartHeight,d={x:r?correctFloat$c(a.translate(t+n,null,null,s)+a.transB):a.left+a.offset+(a.opposite?(s&&l.oldChartWidth||l.chartWidth)-a.right-a.left:0),y:r?h-a.bottom+a.offset-(a.opposite?a.height:0):correctFloat$c(h-a.translate(t+n,null,null,s)-a.transB)};return d.y=clamp$h(d.y,-1e5,1e5),fireEvent$z(this,"afterGetPosition",{pos:d}),d},o.prototype.getLabelPosition=function(r,t,n,s,a,l,h,d){var c=this.axis,f=c.transA,u=c.isLinked&&c.linkedParent?c.linkedParent.reversed:c.reversed,p=c.staggerLines,g=c.tickRotCorr||{x:0,y:0},m=!s&&!c.reserveSpaceDefault?-c.labelOffset*(c.labelAlign==="center"?.5:1):0,v={},x=a.y,y;return defined$O(x)||(c.side===0?x=n.rotation?-8:-n.getBBox().height:c.side===2?x=g.y+8:x=Math.cos(n.rotation*deg2rad$6)*(g.y-n.getBBox(!1,0).height/2)),r=r+a.x+m+g.x-(l&&s?l*f*(u?-1:1):0),t=t+x-(l&&!s?l*f*(u?1:-1):0),p&&(y=h/(d||1)%p,c.opposite&&(y=p-y-1),t+=y*(c.labelOffset/p)),v.x=r,v.y=Math.round(t),fireEvent$z(this,"afterGetLabelPosition",{pos:v,tickmarkOffset:l,index:h}),v},o.prototype.getLabelSize=function(){return this.label?this.label.getBBox()[this.axis.horiz?"height":"width"]:0},o.prototype.getMarkPath=function(r,t,n,s,a,l){return l.crispLine([["M",r,t],["L",r+(a?0:-n),t+(a?n:0)]],s)},o.prototype.handleOverflow=function(r){var t=this,n=this.axis,s=n.options.labels,a=r.x,l=n.chart.chartWidth,h=n.chart.spacing,d=pick$1p(n.labelLeft,Math.min(n.pos,h[3])),c=pick$1p(n.labelRight,Math.max(n.isRadial?0:n.pos+n.len,l-h[1])),f=this.label,u=this.rotation,p={left:0,center:.5,right:1}[n.labelAlign||f.attr("align")],g=f.getBBox().width,m=n.getSlotWidth(t),v=p,x={},y=m,b=1,$,S,k;!u&&s.overflow==="justify"?($=a-p*g,S=a+(1-p)*g,$<d?y=r.x+y*(1-p)-d:S>c&&(y=c-r.x+y*p,b=-1),y=Math.min(m,y),y<m&&n.labelAlign==="center"&&(r.x+=b*(m-y-v*(m-Math.min(g,y)))),(g>y||n.autoRotation&&(f.styles||{}).width)&&(k=y)):u<0&&a-p*g<d?k=Math.round(a/Math.cos(u*deg2rad$6)-d):u>0&&a+p*g>c&&(k=Math.round((l-a)/Math.cos(u*deg2rad$6))),k&&(t.shortenLabel?t.shortenLabel():(x.width=Math.floor(k)+"px",(s.style||{}).textOverflow||(x.textOverflow="ellipsis"),f.css(x)))},o.prototype.moveLabel=function(r,t){var n=this,s=n.label,a=n.axis,l=a.reversed,h=!1,d,c,f;s&&s.textStr===r?(n.movedLabel=s,h=!0,delete n.label):objectEach$t(a.ticks,function(u){!h&&!u.isNew&&u!==n&&u.label&&u.label.textStr===r&&(n.movedLabel=u.label,h=!0,u.labelPos=n.movedLabel.xy,delete u.label)}),!h&&(n.labelPos||s)&&(d=n.labelPos||s.xy,c=a.horiz?l?0:a.width+a.left:d.x,f=a.horiz?d.y:l?a.width+a.left:0,n.movedLabel=n.createLabel({x:c,y:f},r,t),n.movedLabel&&n.movedLabel.attr({opacity:0}))},o.prototype.render=function(r,t,n){var s=this,a=s.axis,l=a.horiz,h=s.pos,d=pick$1p(s.tickmarkOffset,a.tickmarkOffset),c=s.getPosition(l,h,d,t),f=c.x,u=c.y,p=l&&f===a.pos+a.len||!l&&u===a.pos?-1:1,g=pick$1p(n,s.label&&s.label.newOpacity,1);n=pick$1p(n,1),this.isActive=!0,this.renderGridLine(t,n,p),this.renderMark(c,n,p),this.renderLabel(c,t,g,r),s.isNew=!1,fireEvent$z(this,"afterRender")},o.prototype.renderGridLine=function(r,t,n){var s=this,a=s.axis,l=a.options,h={},d=s.pos,c=s.type,f=pick$1p(s.tickmarkOffset,a.tickmarkOffset),u=a.chart.renderer,p=s.gridLine,g,m=l.gridLineWidth,v=l.gridLineColor,x=l.gridLineDashStyle;s.type==="minor"&&(m=l.minorGridLineWidth,v=l.minorGridLineColor,x=l.minorGridLineDashStyle),p||(a.chart.styledMode||(h.stroke=v,h["stroke-width"]=m||0,h.dashstyle=x),c||(h.zIndex=1),r&&(t=0),s.gridLine=p=u.path().attr(h).addClass("highcharts-"+(c?c+"-":"")+"grid-line").add(a.gridGroup)),p&&(g=a.getPlotLinePath({value:d+f,lineWidth:p.strokeWidth()*n,force:"pass",old:r}),g&&p[r||s.isNew?"attr":"animate"]({d:g,opacity:t}))},o.prototype.renderMark=function(r,t,n){var s=this,a=s.axis,l=a.options,h=a.chart.renderer,d=s.type,c=a.tickSize(d?d+"Tick":"tick"),f=r.x,u=r.y,p=pick$1p(l[d!=="minor"?"tickWidth":"minorTickWidth"],!d&&a.isXAxis?1:0),g=l[d!=="minor"?"tickColor":"minorTickColor"],m=s.mark,v=!m;c&&(a.opposite&&(c[0]=-c[0]),m||(s.mark=m=h.path().addClass("highcharts-"+(d?d+"-":"")+"tick").add(a.axisGroup),a.chart.styledMode||m.attr({stroke:g,"stroke-width":p})),m[v?"attr":"animate"]({d:s.getMarkPath(f,u,c[0],m.strokeWidth()*n,a.horiz,h),opacity:t}))},o.prototype.renderLabel=function(r,t,n,s){var a=this,l=a.axis,h=l.horiz,d=l.options,c=a.label,f=d.labels,u=f.step,p=pick$1p(a.tickmarkOffset,l.tickmarkOffset),g=r.x,m=r.y,v=!0;c&&isNumber$I(g)&&(c.xy=r=a.getLabelPosition(g,m,c,h,f,p,s,u),a.isFirst&&!a.isLast&&!d.showFirstLabel||a.isLast&&!a.isFirst&&!d.showLastLabel?v=!1:h&&!f.step&&!f.rotation&&!t&&n!==0&&a.handleOverflow(r),u&&s%u&&(v=!1),v&&isNumber$I(r.y)?(r.opacity=n,c[a.isNewLabel?"attr":"animate"](r),a.isNewLabel=!1):(c.attr("y",-9999),a.isNewLabel=!0))},o.prototype.replaceMovedLabel=function(){var r=this,t=r.label,n=r.axis,s=n.reversed,a,l;t&&!r.isNew&&(a=n.horiz?s?n.left:n.width+n.left:t.xy.x,l=n.horiz?t.xy.y:s?n.width+n.top:n.top,t.animate({x:a,y:l,opacity:0},void 0,t.destroy),delete r.label),n.isDirty=!0,r.label=r.movedLabel,delete r.movedLabel},o}(),animObject$a=animationExports.animObject,defaultOptions$d=DefaultOptions.defaultOptions,registerEventOptions$2=exports$3.registerEventOptions,deg2rad$5=H.deg2rad,arrayMax$9=Utilities.arrayMax,arrayMin$8=Utilities.arrayMin,clamp$g=Utilities.clamp,correctFloat$b=Utilities.correctFloat,defined$N=Utilities.defined,destroyObjectProperties$7=Utilities.destroyObjectProperties,erase$7=Utilities.erase,error$7=Utilities.error,extend$1i=Utilities.extend,fireEvent$y=Utilities.fireEvent,getMagnitude$2=Utilities.getMagnitude,isArray$j=Utilities.isArray,isNumber$H=Utilities.isNumber,isString$7=Utilities.isString,merge$1g=Utilities.merge,normalizeTickInterval$2=Utilities.normalizeTickInterval,objectEach$s=Utilities.objectEach,pick$1o=Utilities.pick,relativeLength$9=Utilities.relativeLength,removeEvent$9=Utilities.removeEvent,splat$g=Utilities.splat,syncTimeout$7=Utilities.syncTimeout,Axis=function(){function o(r,t){this.alternateBands=void 0,this.bottom=void 0,this.categories=void 0,this.chart=void 0,this.closestPointRange=void 0,this.coll=void 0,this.eventOptions=void 0,this.hasNames=void 0,this.hasVisibleSeries=void 0,this.height=void 0,this.isLinked=void 0,this.labelEdge=void 0,this.labelFormatter=void 0,this.left=void 0,this.len=void 0,this.max=void 0,this.maxLabelLength=void 0,this.min=void 0,this.minorTickInterval=void 0,this.minorTicks=void 0,this.minPixelPadding=void 0,this.names=void 0,this.offset=void 0,this.options=void 0,this.overlap=void 0,this.paddedTicks=void 0,this.plotLinesAndBands=void 0,this.plotLinesAndBandsGroups=void 0,this.pointRange=void 0,this.pointRangePadding=void 0,this.pos=void 0,this.positiveValuesOnly=void 0,this.right=void 0,this.series=void 0,this.side=void 0,this.tickAmount=void 0,this.tickInterval=void 0,this.tickmarkOffset=void 0,this.tickPositions=void 0,this.tickRotCorr=void 0,this.ticks=void 0,this.top=void 0,this.transA=void 0,this.transB=void 0,this.translationSlope=void 0,this.userOptions=void 0,this.visible=void 0,this.width=void 0,this.zoomEnabled=void 0,this.init(r,t)}return o.prototype.init=function(r,t){var n=t.isX,s=this;s.chart=r,s.horiz=r.inverted&&!s.isZAxis?!n:n,s.isXAxis=n,s.coll=s.coll||(n?"xAxis":"yAxis"),fireEvent$y(this,"init",{userOptions:t}),s.opposite=pick$1o(t.opposite,s.opposite),s.side=pick$1o(t.side,s.side,s.horiz?s.opposite?0:2:s.opposite?1:3),s.setOptions(t);var a=this.options,l=a.labels,h=a.type;s.userOptions=t,s.minPixelPadding=0,s.reversed=pick$1o(a.reversed,s.reversed),s.visible=a.visible,s.zoomEnabled=a.zoomEnabled,s.hasNames=h==="category"||a.categories===!0,s.categories=a.categories||s.hasNames,s.names||(s.names=[],s.names.keys={}),s.plotLinesAndBandsGroups={},s.positiveValuesOnly=!!s.logarithmic,s.isLinked=defined$N(a.linkedTo),s.ticks={},s.labelEdge=[],s.minorTicks={},s.plotLinesAndBands=[],s.alternateBands={},s.len=0,s.minRange=s.userMinRange=a.minRange||a.maxZoom,s.range=a.range,s.offset=a.offset||0,s.max=null,s.min=null;var d=pick$1o(a.crosshair,splat$g(r.options.tooltip.crosshairs)[n?0:1]);s.crosshair=d===!0?{}:d,r.axes.indexOf(s)===-1&&(n?r.axes.splice(r.xAxis.length,0,s):r.axes.push(s),r[s.coll].push(s)),s.series=s.series||[],r.inverted&&!s.isZAxis&&n&&typeof s.reversed>"u"&&(s.reversed=!0),s.labelRotation=isNumber$H(l.rotation)?l.rotation:void 0,registerEventOptions$2(s,a),fireEvent$y(this,"afterInit")},o.prototype.setOptions=function(r){this.options=merge$1g(AxisDefaults$1.defaultXAxisOptions,this.coll==="yAxis"&&AxisDefaults$1.defaultYAxisOptions,[AxisDefaults$1.defaultTopAxisOptions,AxisDefaults$1.defaultRightAxisOptions,AxisDefaults$1.defaultBottomAxisOptions,AxisDefaults$1.defaultLeftAxisOptions][this.side],merge$1g(defaultOptions$d[this.coll],r)),fireEvent$y(this,"afterSetOptions",{userOptions:r})},o.prototype.defaultLabelFormatter=function(r){var t=this.axis,n=this.chart,s=n.numberFormatter,a=isNumber$H(this.value)?this.value:NaN,l=t.chart.time,h=t.categories,d=this.dateTimeLabelFormat,c=defaultOptions$d.lang,f=c.numericSymbols,u=c.numericSymbolMagnitude||1e3,p=t.logarithmic?Math.abs(a):t.tickInterval,g=f&&f.length,m,v;if(h)v=""+this.value;else if(d)v=l.dateFormat(d,a);else if(g&&p>=1e3)for(;g--&&typeof v>"u";)m=Math.pow(u,g+1),p>=m&&a*10%m===0&&f[g]!==null&&a!==0&&(v=s(a/m,-1)+f[g]);return typeof v>"u"&&(Math.abs(a)>=1e4?v=s(a,-1):v=s(a,-1,void 0,"")),v},o.prototype.getSeriesExtremes=function(){var r=this,t=r.chart,n;fireEvent$y(this,"getSeriesExtremes",null,function(){r.hasVisibleSeries=!1,r.dataMin=r.dataMax=r.threshold=null,r.softThreshold=!r.isXAxis,r.stacking&&r.stacking.buildStacks(),r.series.forEach(function(s){if(s.visible||!t.options.chart.ignoreHiddenSeries){var a=s.options,l=void 0,h=a.threshold,d=void 0,c=void 0;if(r.hasVisibleSeries=!0,r.positiveValuesOnly&&h<=0&&(h=null),r.isXAxis)l=s.xData,l.length&&(l=r.logarithmic?l.filter(r.validatePositiveValue):l,n=s.getXExtremes(l),d=n.min,c=n.max,!isNumber$H(d)&&!(d instanceof Date)&&(l=l.filter(isNumber$H),n=s.getXExtremes(l),d=n.min,c=n.max),l.length&&(r.dataMin=Math.min(pick$1o(r.dataMin,d),d),r.dataMax=Math.max(pick$1o(r.dataMax,c),c)));else{var f=s.applyExtremes();isNumber$H(f.dataMin)&&(d=f.dataMin,r.dataMin=Math.min(pick$1o(r.dataMin,d),d)),isNumber$H(f.dataMax)&&(c=f.dataMax,r.dataMax=Math.max(pick$1o(r.dataMax,c),c)),defined$N(h)&&(r.threshold=h),(!a.softThreshold||r.positiveValuesOnly)&&(r.softThreshold=!1)}}})}),fireEvent$y(this,"afterGetSeriesExtremes")},o.prototype.translate=function(r,t,n,s,a,l){var h=this.linkedParent||this,d=s&&h.old?h.old.min:h.min,c=h.minPixelPadding,f=(h.isOrdinal||h.brokenAxis&&h.brokenAxis.hasBreaks||h.logarithmic&&a)&&h.lin2val,u=1,p=0,g=s&&h.old?h.old.transA:h.transA,m=0;return g||(g=h.transA),n&&(u*=-1,p=h.len),h.reversed&&(u*=-1,p-=u*(h.sector||h.len)),t?(r=r*u+p,r-=c,m=r/g+d,f&&(m=h.lin2val(m))):(f&&(r=h.val2lin(r)),m=isNumber$H(d)?u*(r-d)*g+p+u*c+(isNumber$H(l)?g*l:0):void 0),m},o.prototype.toPixels=function(r,t){return this.translate(r,!1,!this.horiz,null,!0)+(t?0:this.pos)},o.prototype.toValue=function(r,t){return this.translate(r-(t?0:this.pos),!0,!this.horiz,null,!0)},o.prototype.getPlotLinePath=function(r){var t=this,n=t.chart,s=t.left,a=t.top,l=r.old,h=r.value,d=r.lineWidth,c=l&&n.oldChartHeight||n.chartHeight,f=l&&n.oldChartWidth||n.chartWidth,u=t.transB,p=r.translatedValue,g=r.force,m,v,x,y,b;function $(k,A,P){return(g!=="pass"&&k<A||k>P)&&(g?k=clamp$g(k,A,P):b=!0),k}var S={value:h,lineWidth:d,old:l,force:g,acrossPanes:r.acrossPanes,translatedValue:p};return fireEvent$y(this,"getPlotLinePath",S,function(k){p=pick$1o(p,t.translate(h,null,null,l)),p=clamp$g(p,-1e5,1e5),m=x=Math.round(p+u),v=y=Math.round(c-p-u),isNumber$H(p)?t.horiz?(v=a,y=c-t.bottom,m=x=$(m,s,s+t.width)):(m=s,x=f-t.right,v=y=$(v,a,a+t.height)):(b=!0,g=!1),k.path=b&&!g?null:n.renderer.crispLine([["M",m,v],["L",x,y]],d||1)}),S.path},o.prototype.getLinearTickPositions=function(r,t,n){var s=correctFloat$b(Math.floor(t/r)*r),a=correctFloat$b(Math.ceil(n/r)*r),l=[],h,d,c;if(correctFloat$b(s+r)===s&&(c=20),this.single)return[t];for(h=s;h<=a&&(l.push(h),h=correctFloat$b(h+r,c),h!==d);)d=h;return l},o.prototype.getMinorTickInterval=function(){var r=this.options;return r.minorTicks===!0?pick$1o(r.minorTickInterval,"auto"):r.minorTicks===!1?null:r.minorTickInterval},o.prototype.getMinorTickPositions=function(){var r=this,t=r.options,n=r.tickPositions,s=r.minorTickInterval,a=r.pointRangePadding||0,l=r.min-a,h=r.max+a,d=h-l,c=[],f;if(d&&d/s<r.len/3){var u=r.logarithmic;if(u)this.paddedTicks.forEach(function(p,g,m){g&&c.push.apply(c,u.getLogTickPositions(s,m[g-1],m[g],!0))});else if(r.dateTime&&this.getMinorTickInterval()==="auto")c=c.concat(r.getTimeTicks(r.dateTime.normalizeTimeTickInterval(s),l,h,t.startOfWeek));else for(f=l+(n[0]-l)%s;f<=h&&f!==c[0];f+=s)c.push(f)}return c.length!==0&&r.trimTicks(c),c},o.prototype.adjustForMinRange=function(){var r=this,t=r.options,n=r.logarithmic,s=r.min,a=r.max,l,h,d=0,c,f,u,p,g,m,v;r.isXAxis&&typeof r.minRange>"u"&&!n&&(defined$N(t.min)||defined$N(t.max)?r.minRange=null:(r.series.forEach(function(x){if(u=x.xData,p=x.xIncrement?1:u.length-1,u.length>1)for(c=p;c>0;c--)f=u[c]-u[c-1],(!d||f<d)&&(d=f)}),r.minRange=Math.min(d*5,r.dataMax-r.dataMin))),a-s<r.minRange&&(h=r.dataMax-r.dataMin>=r.minRange,v=r.minRange,l=(v-a+s)/2,g=[s-l,pick$1o(t.min,s-l)],h&&(g[2]=r.logarithmic?r.logarithmic.log2lin(r.dataMin):r.dataMin),s=arrayMax$9(g),m=[s+v,pick$1o(t.max,s+v)],h&&(m[2]=n?n.log2lin(r.dataMax):r.dataMax),a=arrayMin$8(m),a-s<v&&(g[0]=a-v,g[1]=pick$1o(t.min,a-v),s=arrayMax$9(g))),r.min=s,r.max=a},o.prototype.getClosest=function(){var r;return this.categories?r=1:this.series.forEach(function(t){var n=t.closestPointRange,s=t.visible||!t.chart.options.chart.ignoreHiddenSeries;!t.noSharedTooltip&&defined$N(n)&&s&&(r=defined$N(r)?Math.min(r,n):n)}),r},o.prototype.nameToX=function(r){var t=isArray$j(this.categories),n=t?this.categories:this.names,s=r.options.x,a;return r.series.requireSorting=!1,defined$N(s)||(s=this.options.uniqueNames?t?n.indexOf(r.name):pick$1o(n.keys[r.name],-1):r.series.autoIncrement()),s===-1?t||(a=n.length):a=s,typeof a<"u"&&(this.names[a]=r.name,this.names.keys[r.name]=a),a},o.prototype.updateNames=function(){var r=this,t=this.names,n=t.length;n>0&&(Object.keys(t.keys).forEach(function(s){delete t.keys[s]}),t.length=0,this.minRange=this.userMinRange,(this.series||[]).forEach(function(s){s.xIncrement=null,(!s.points||s.isDirtyData)&&(r.max=Math.max(r.max,s.xData.length-1),s.processData(),s.generatePoints()),s.data.forEach(function(a,l){var h;a&&a.options&&typeof a.name<"u"&&(h=r.nameToX(a),typeof h<"u"&&h!==a.x&&(a.x=h,s.xData[l]=h))})}))},o.prototype.setAxisTranslation=function(){var r=this,t=r.max-r.min,n=r.linkedParent,s=!!r.categories,a=r.isXAxis,l=r.axisPointRange||0,h,d=0,c=0,f,u=r.transA;(a||s||l)&&(h=r.getClosest(),n?(d=n.minPointOffset,c=n.pointRangePadding):r.series.forEach(function(p){var g=s?1:a?pick$1o(p.options.pointRange,h,0):r.axisPointRange||0,m=p.options.pointPlacement;if(l=Math.max(l,g),!r.single||s){var v=p.is("xrange")?!a:a;d=Math.max(d,v&&isString$7(m)?0:g/2),c=Math.max(c,v&&m==="on"?0:g)}}),f=r.ordinal&&r.ordinal.slope&&h?r.ordinal.slope/h:1,r.minPointOffset=d=d*f,r.pointRangePadding=c=c*f,r.pointRange=Math.min(l,r.single&&s?1:t),a&&(r.closestPointRange=h)),r.translationSlope=r.transA=u=r.staticScale||r.len/(t+c||1),r.transB=r.horiz?r.left:r.bottom,r.minPixelPadding=u*d,fireEvent$y(this,"afterSetAxisTranslation")},o.prototype.minFromRange=function(){var r=this;return r.max-r.range},o.prototype.setTickInterval=function(r){var t=this,n=t.chart,s=t.logarithmic,a=t.options,l=t.isXAxis,h=t.isLinked,d=a.tickPixelInterval,c=t.categories,f=t.softThreshold,u=a.maxPadding,p=a.minPadding,g,m,v=a.tickInterval,x=isNumber$H(t.threshold)?t.threshold:null,y,b,$,S;!t.dateTime&&!c&&!h&&this.getTickAmount(),$=pick$1o(t.userMin,a.min),S=pick$1o(t.userMax,a.max),h?(t.linkedParent=n[t.coll][a.linkedTo],m=t.linkedParent.getExtremes(),t.min=pick$1o(m.min,m.dataMin),t.max=pick$1o(m.max,m.dataMax),a.type!==t.linkedParent.options.type&&error$7(11,1,n)):(f&&defined$N(x)&&(t.dataMin>=x?(y=x,p=0):t.dataMax<=x&&(b=x,u=0)),t.min=pick$1o($,y,t.dataMin),t.max=pick$1o(S,b,t.dataMax)),s&&(t.positiveValuesOnly&&!r&&Math.min(t.min,pick$1o(t.dataMin,t.min))<=0&&error$7(10,1,n),t.min=correctFloat$b(s.log2lin(t.min),16),t.max=correctFloat$b(s.log2lin(t.max),16)),t.range&&defined$N(t.max)&&(t.userMin=t.min=$=Math.max(t.dataMin,t.minFromRange()),t.userMax=S=t.max,t.range=null),fireEvent$y(t,"foundExtremes"),t.beforePadding&&t.beforePadding(),t.adjustForMinRange(),!c&&!t.axisPointRange&&!(t.stacking&&t.stacking.usePercentage)&&!h&&defined$N(t.min)&&defined$N(t.max)&&(g=t.max-t.min,g&&(!defined$N($)&&p&&(t.min-=g*p),!defined$N(S)&&u&&(t.max+=g*u))),isNumber$H(t.userMin)||(isNumber$H(a.softMin)&&a.softMin<t.min&&(t.min=$=a.softMin),isNumber$H(a.floor)&&(t.min=Math.max(t.min,a.floor))),isNumber$H(t.userMax)||(isNumber$H(a.softMax)&&a.softMax>t.max&&(t.max=S=a.softMax),isNumber$H(a.ceiling)&&(t.max=Math.min(t.max,a.ceiling))),f&&defined$N(t.dataMin)&&(x=x||0,!defined$N($)&&t.min<x&&t.dataMin>=x?t.min=t.options.minRange?Math.min(x,t.max-t.minRange):x:!defined$N(S)&&t.max>x&&t.dataMax<=x&&(t.max=t.options.minRange?Math.max(x,t.min+t.minRange):x)),isNumber$H(t.min)&&isNumber$H(t.max)&&!this.chart.polar&&t.min>t.max&&(defined$N(t.options.min)?t.max=t.min:defined$N(t.options.max)&&(t.min=t.max)),t.min===t.max||typeof t.min>"u"||typeof t.max>"u"?t.tickInterval=1:h&&t.linkedParent&&!v&&d===t.linkedParent.options.tickPixelInterval?t.tickInterval=v=t.linkedParent.tickInterval:t.tickInterval=pick$1o(v,this.tickAmount?(t.max-t.min)/Math.max(this.tickAmount-1,1):void 0,c?1:(t.max-t.min)*d/Math.max(t.len,d)),l&&!r&&(t.series.forEach(function(A){A.forceCrop=A.forceCropping&&A.forceCropping(),A.processData(t.min!==(t.old&&t.old.min)||t.max!==(t.old&&t.old.max))}),fireEvent$y(this,"postProcessData")),t.setAxisTranslation(),fireEvent$y(this,"initialAxisTranslation"),t.pointRange&&!v&&(t.tickInterval=Math.max(t.pointRange,t.tickInterval));var k=pick$1o(a.minTickInterval,t.dateTime&&!t.series.some(function(A){return A.noSharedTooltip})?t.closestPointRange:0);!v&&t.tickInterval<k&&(t.tickInterval=k),!t.dateTime&&!t.logarithmic&&!v&&(t.tickInterval=normalizeTickInterval$2(t.tickInterval,void 0,getMagnitude$2(t.tickInterval),pick$1o(a.allowDecimals,t.tickInterval<.5||this.tickAmount!==void 0),!!this.tickAmount)),this.tickAmount||(t.tickInterval=t.unsquish()),this.setTickPositions()},o.prototype.setTickPositions=function(){var r=this,t=this.options,n=t.tickPositions,s=this.getMinorTickInterval(),a=this.hasVerticalPanning(),l=this.coll==="colorAxis",h=(l||!a)&&t.startOnTick,d=(l||!a)&&t.endOnTick,c,f=t.tickPositioner;this.tickmarkOffset=this.categories&&t.tickmarkPlacement==="between"&&this.tickInterval===1?.5:0,this.minorTickInterval=s==="auto"&&this.tickInterval?this.tickInterval/5:s,this.single=this.min===this.max&&defined$N(this.min)&&!this.tickAmount&&(parseInt(this.min,10)===this.min||t.allowDecimals!==!1),this.tickPositions=c=n&&n.slice(),c||((!r.ordinal||!r.ordinal.positions)&&(this.max-this.min)/this.tickInterval>Math.max(2*this.len,200)?(c=[this.min,this.max],error$7(19,!1,this.chart)):r.dateTime?c=r.getTimeTicks(r.dateTime.normalizeTimeTickInterval(this.tickInterval,t.units),this.min,this.max,t.startOfWeek,r.ordinal&&r.ordinal.positions,this.closestPointRange,!0):r.logarithmic?c=r.logarithmic.getLogTickPositions(this.tickInterval,this.min,this.max):c=this.getLinearTickPositions(this.tickInterval,this.min,this.max),c.length>this.len&&(c=[c[0],c.pop()],c[0]===c[1]&&(c.length=1)),this.tickPositions=c,f&&(f=f.apply(r,[this.min,this.max]),f&&(this.tickPositions=c=f))),this.paddedTicks=c.slice(0),this.trimTicks(c,h,d),this.isLinked||(this.single&&c.length<2&&!this.categories&&!this.series.some(function(u){return u.is("heatmap")&&u.options.pointPlacement==="between"})&&(this.min-=.5,this.max+=.5),!n&&!f&&this.adjustTickAmount()),fireEvent$y(this,"afterSetTickPositions")},o.prototype.trimTicks=function(r,t,n){var s=r[0],a=r[r.length-1],l=!this.isOrdinal&&this.minPointOffset||0;if(fireEvent$y(this,"trimTicks"),!this.isLinked){if(t&&s!==-1/0)this.min=s;else for(;this.min-l>r[0];)r.shift();if(n)this.max=a;else for(;this.max+l<r[r.length-1];)r.pop();r.length===0&&defined$N(s)&&!this.options.tickPositions&&r.push((a+s)/2)}},o.prototype.alignToOthers=function(){var r=this,t={},n=r.options,s;return this.chart.options.chart.alignTicks!==!1&&n.alignTicks&&n.startOnTick!==!1&&n.endOnTick!==!1&&!r.logarithmic&&this.chart[this.coll].forEach(function(a){var l=a.options,h=a.horiz,d=[h?l.left:l.top,l.width,l.height,l.pane].join(",");a.series.length&&(t[d]?s=!0:t[d]=1)}),s},o.prototype.getTickAmount=function(){var r=this,t=this.options,n=t.tickPixelInterval,s=t.tickAmount;!defined$N(t.tickInterval)&&!s&&this.len<n&&!this.isRadial&&!r.logarithmic&&t.startOnTick&&t.endOnTick&&(s=2),!s&&this.alignToOthers()&&(s=Math.ceil(this.len/n)+1),s<4&&(this.finalTickAmt=s,s=5),this.tickAmount=s},o.prototype.adjustTickAmount=function(){var r=this,t=r.options,n=r.tickInterval,s=r.tickPositions,a=r.tickAmount,l=r.finalTickAmt,h=s&&s.length,d=pick$1o(r.threshold,r.softThreshold?0:null),c,f;if(r.hasData()&&isNumber$H(r.min)&&isNumber$H(r.max)){if(h<a){for(;s.length<a;)s.length%2||r.min===d?s.push(correctFloat$b(s[s.length-1]+n)):s.unshift(correctFloat$b(s[0]-n));r.transA*=(h-1)/(a-1),r.min=t.startOnTick?s[0]:Math.min(r.min,s[0]),r.max=t.endOnTick?s[s.length-1]:Math.max(r.max,s[s.length-1])}else h>a&&(r.tickInterval*=2,r.setTickPositions());if(defined$N(l)){for(f=c=s.length;f--;)(l===3&&f%2===1||l<=2&&f>0&&f<c-1)&&s.splice(f,1);r.finalTickAmt=void 0}}},o.prototype.setScale=function(){var r=this,t=!1,n=!1;r.series.forEach(function(a){t=t||a.isDirtyData||a.isDirty,n=n||a.xAxis&&a.xAxis.isDirty||!1}),r.setAxisSize();var s=r.len!==(r.old&&r.old.len);s||t||n||r.isLinked||r.forceRedraw||r.userMin!==(r.old&&r.old.userMin)||r.userMax!==(r.old&&r.old.userMax)||r.alignToOthers()?(r.stacking&&r.stacking.resetStacks(),r.forceRedraw=!1,r.getSeriesExtremes(),r.setTickInterval(),r.isDirty||(r.isDirty=s||r.min!==(r.old&&r.old.min)||r.max!==(r.old&&r.old.max))):r.stacking&&r.stacking.cleanStacks(),t&&r.panningState&&(r.panningState.isDirty=!0),fireEvent$y(this,"afterSetScale")},o.prototype.setExtremes=function(r,t,n,s,a){var l=this,h=l.chart;n=pick$1o(n,!0),l.series.forEach(function(d){delete d.kdTree}),a=extend$1i(a,{min:r,max:t}),fireEvent$y(l,"setExtremes",a,function(){l.userMin=r,l.userMax=t,l.eventArgs=a,n&&h.redraw(s)})},o.prototype.zoom=function(r,t){var n=this,s=this.dataMin,a=this.dataMax,l=this.options,h=Math.min(s,pick$1o(l.min,s)),d=Math.max(a,pick$1o(l.max,a)),c={newMin:r,newMax:t};return fireEvent$y(this,"zoom",c,function(f){var u=f.newMin,p=f.newMax;(u!==n.min||p!==n.max)&&(n.allowZoomOutside||(defined$N(s)&&(u<h&&(u=h),u>d&&(u=d)),defined$N(a)&&(p<h&&(p=h),p>d&&(p=d))),n.displayBtn=typeof u<"u"||typeof p<"u",n.setExtremes(u,p,!1,void 0,{trigger:"zoom"})),f.zoomed=!0}),c.zoomed},o.prototype.setAxisSize=function(){var r=this.chart,t=this.options,n=t.offsets||[0,0,0,0],s=this.horiz,a=this.width=Math.round(relativeLength$9(pick$1o(t.width,r.plotWidth-n[3]+n[1]),r.plotWidth)),l=this.height=Math.round(relativeLength$9(pick$1o(t.height,r.plotHeight-n[0]+n[2]),r.plotHeight)),h=this.top=Math.round(relativeLength$9(pick$1o(t.top,r.plotTop+n[0]),r.plotHeight,r.plotTop)),d=this.left=Math.round(relativeLength$9(pick$1o(t.left,r.plotLeft+n[3]),r.plotWidth,r.plotLeft));this.bottom=r.chartHeight-l-h,this.right=r.chartWidth-a-d,this.len=Math.max(s?a:l,0),this.pos=s?d:h},o.prototype.getExtremes=function(){var r=this,t=r.logarithmic;return{min:t?correctFloat$b(t.lin2log(r.min)):r.min,max:t?correctFloat$b(t.lin2log(r.max)):r.max,dataMin:r.dataMin,dataMax:r.dataMax,userMin:r.userMin,userMax:r.userMax}},o.prototype.getThreshold=function(r){var t=this,n=t.logarithmic,s=n?n.lin2log(t.min):t.min,a=n?n.lin2log(t.max):t.max;return r===null||r===-1/0?r=s:r===1/0?r=a:s>r?r=s:a<r&&(r=a),t.translate(r,0,1,0,1)},o.prototype.autoLabelAlign=function(r){var t=(pick$1o(r,0)-this.side*90+720)%360,n={align:"center"};return fireEvent$y(this,"autoLabelAlign",n,function(s){t>15&&t<165?s.align="right":t>195&&t<345&&(s.align="left")}),n.align},o.prototype.tickSize=function(r){var t=this.options,n=pick$1o(t[r==="tick"?"tickWidth":"minorTickWidth"],r==="tick"&&this.isXAxis&&!this.categories?1:0),s=t[r==="tick"?"tickLength":"minorTickLength"],a;n&&s&&(t[r+"Position"]==="inside"&&(s=-s),a=[s,n]);var l={tickSize:a};return fireEvent$y(this,"afterTickSize",l),l.tickSize},o.prototype.labelMetrics=function(){var r=this.tickPositions&&this.tickPositions[0]||0;return this.chart.renderer.fontMetrics(this.options.labels.style.fontSize,this.ticks[r]&&this.ticks[r].label)},o.prototype.unsquish=function(){var r=this.options.labels,t=this.horiz,n=this.tickInterval,s=this.len/(((this.categories?1:0)+this.max-this.min)/n),a=r.rotation,l=this.labelMetrics(),h=Math.max(this.max-this.min,0),d=function(m){var v=m/(s||1);return v=v>1?Math.ceil(v):1,v*n>h&&m!==1/0&&s!==1/0&&h&&(v=Math.ceil(h/n)),correctFloat$b(v*n)},c=n,f,u,p=Number.MAX_VALUE,g;return t?(!r.staggerLines&&!r.step&&(isNumber$H(a)?g=[a]:s<r.autoRotationLimit&&(g=r.autoRotation)),g&&g.forEach(function(m){var v;(m===a||m&&m>=-90&&m<=90)&&(u=d(Math.abs(l.h/Math.sin(deg2rad$5*m))),v=u+Math.abs(m/360),v<p&&(p=v,f=m,c=u))})):r.step||(c=d(l.h)),this.autoRotation=g,this.labelRotation=pick$1o(f,isNumber$H(a)?a:0),c},o.prototype.getSlotWidth=function(r){var t=this.chart,n=this.horiz,s=this.options.labels,a=Math.max(this.tickPositions.length-(this.categories?0:1),1),l=t.margin[3];if(r&&isNumber$H(r.slotWidth))return r.slotWidth;if(n&&s.step<2)return s.rotation?0:(this.staggerLines||1)*this.len/a;if(!n){var h=s.style.width;if(h!==void 0)return parseInt(String(h),10);if(l)return l-t.spacing[3]}return t.chartWidth*.33},o.prototype.renderUnsquish=function(){var r=this.chart,t=r.renderer,n=this.tickPositions,s=this.ticks,a=this.options.labels,l=a.style,h=this.horiz,d=this.getSlotWidth(),c=Math.max(1,Math.round(d-2*a.padding)),f={},u=this.labelMetrics(),p=l.textOverflow,g,m,v=0,x,y,b;if(isString$7(a.rotation)||(f.rotation=a.rotation||0),n.forEach(function($){var S=s[$];S.movedLabel&&S.replaceMovedLabel(),S&&S.label&&S.label.textPxLength>v&&(v=S.label.textPxLength)}),this.maxLabelLength=v,this.autoRotation)v>c&&v>u.h?f.rotation=this.labelRotation:this.labelRotation=0;else if(d&&(g=c,!p))for(m="clip",y=n.length;!h&&y--;)b=n[y],x=s[b].label,x&&(x.styles&&x.styles.textOverflow==="ellipsis"?x.css({textOverflow:"clip"}):x.textPxLength>d&&x.css({width:d+"px"}),x.getBBox().height>this.len/n.length-(u.h-u.f)&&(x.specificTextOverflow="ellipsis"));f.rotation&&(g=v>r.chartHeight*.5?r.chartHeight*.33:v,p||(m="ellipsis")),this.labelAlign=a.align||this.autoLabelAlign(this.labelRotation),this.labelAlign&&(f.align=this.labelAlign),n.forEach(function($){var S=s[$],k=S&&S.label,A=l.width,P={};k&&(k.attr(f),S.shortenLabel?S.shortenLabel():g&&!A&&l.whiteSpace!=="nowrap"&&(g<k.textPxLength||k.element.tagName==="SPAN")?(P.width=g+"px",p||(P.textOverflow=k.specificTextOverflow||m),k.css(P)):k.styles&&k.styles.width&&!P.width&&!A&&k.css({width:null}),delete k.specificTextOverflow,S.rotation=f.rotation)},this),this.tickRotCorr=t.rotCorr(u.b,this.labelRotation||0,this.side!==0)},o.prototype.hasData=function(){return this.series.some(function(r){return r.hasData()})||this.options.showEmpty&&defined$N(this.min)&&defined$N(this.max)},o.prototype.addTitle=function(r){var t=this,n=t.chart.renderer,s=t.horiz,a=t.opposite,l=t.options,h=l.title,d=t.chart.styledMode,c;t.axisTitle||(c=h.textAlign,c||(c=(s?{low:"left",middle:"center",high:"right"}:{low:a?"right":"left",middle:"center",high:a?"left":"right"})[h.align]),t.axisTitle=n.text(h.text||"",0,0,h.useHTML).attr({zIndex:7,rotation:h.rotation,align:c}).addClass("highcharts-axis-title"),d||t.axisTitle.css(merge$1g(h.style)),t.axisTitle.add(t.axisGroup),t.axisTitle.isNew=!0),!d&&!h.style.width&&!t.isRadial&&t.axisTitle.css({width:t.len+"px"}),t.axisTitle[r?"show":"hide"](r)},o.prototype.generateTick=function(r){var t=this,n=t.ticks;n[r]?n[r].addLabel():n[r]=new Tick(t,r)},o.prototype.getOffset=function(){var r=this,t=this,n=t.chart,s=n.renderer,a=t.options,l=t.tickPositions,h=t.ticks,d=t.horiz,c=t.side,f=n.inverted&&!t.isZAxis?[1,0,3,2][c]:c,u=t.hasData(),p=a.title,g=a.labels,m=n.axisOffset,v=n.clipOffset,x=[-1,1,1,-1][c],y=a.className,b=t.axisParent,$,S=0,k,A=0,P=0,E,M;if(t.showAxis=$=u||a.showEmpty,t.staggerLines=t.horiz&&g.staggerLines||void 0,!t.axisGroup){var C=function(T,_,D){return s.g(T).attr({zIndex:D}).addClass("highcharts-"+r.coll.toLowerCase()+_+" "+(r.isRadial?"highcharts-radial-axis"+_+" ":"")+(y||"")).add(b)};t.gridGroup=C("grid","-grid",a.gridZIndex),t.axisGroup=C("axis","",a.zIndex),t.labelGroup=C("axis-labels","-labels",g.zIndex)}u||t.isLinked?(l.forEach(function(T){t.generateTick(T)}),t.renderUnsquish(),t.reserveSpaceDefault=c===0||c===2||{1:"left",3:"right"}[c]===t.labelAlign,pick$1o(g.reserveSpace,t.labelAlign==="center"?!0:null,t.reserveSpaceDefault)&&l.forEach(function(T){P=Math.max(h[T].getLabelSize(),P)}),t.staggerLines&&(P*=t.staggerLines),t.labelOffset=P*(t.opposite?-1:1)):objectEach$s(h,function(T,_){T.destroy(),delete h[_]}),p&&p.text&&p.enabled!==!1&&(t.addTitle($),$&&p.reserveSpace!==!1&&(t.titleOffset=S=t.axisTitle.getBBox()[d?"height":"width"],k=p.offset,A=defined$N(k)?0:pick$1o(p.margin,d?5:10))),t.renderLine(),t.offset=x*pick$1o(a.offset,m[c]?m[c]+(a.margin||0):0),t.tickRotCorr=t.tickRotCorr||{x:0,y:0},c===0?M=-t.labelMetrics().h:c===2?M=t.tickRotCorr.y:M=0,E=Math.abs(P)+A,P&&(E-=M,E+=x*(d?pick$1o(g.y,t.tickRotCorr.y+x*8):g.x)),t.axisTitleMargin=pick$1o(k,E),t.getMaxLabelDimensions&&(t.maxLabelDimensions=t.getMaxLabelDimensions(h,l));var O=this.tickSize("tick");m[c]=Math.max(m[c],(t.axisTitleMargin||0)+S+x*t.offset,E,l&&l.length&&O?O[0]+x*t.offset:0);var L=a.offset?0:Math.floor(t.axisLine.strokeWidth()/2)*2;v[f]=Math.max(v[f],L),fireEvent$y(this,"afterGetOffset")},o.prototype.getLinePath=function(r){var t=this.chart,n=this.opposite,s=this.offset,a=this.horiz,l=this.left+(n?this.width:0)+s,h=t.chartHeight-this.bottom-(n?this.height:0)+s;return n&&(r*=-1),t.renderer.crispLine([["M",a?this.left:l,a?h:this.top],["L",a?t.chartWidth-this.right:l,a?h:t.chartHeight-this.bottom]],r)},o.prototype.renderLine=function(){this.axisLine||(this.axisLine=this.chart.renderer.path().addClass("highcharts-axis-line").add(this.axisGroup),this.chart.styledMode||this.axisLine.attr({stroke:this.options.lineColor,"stroke-width":this.options.lineWidth,zIndex:7}))},o.prototype.getTitlePosition=function(){var r=this.horiz,t=this.left,n=this.top,s=this.len,a=this.options.title,l=r?t:n,h=this.opposite,d=this.offset,c=a.x,f=a.y,u=this.axisTitle,p=this.chart.renderer.fontMetrics(a.style.fontSize,u),g=Math.max(u.getBBox(null,0).height-p.h-1,0),m={low:l+(r?0:s),middle:l+s/2,high:l+(r?s:0)}[a.align],v=(r?n+this.height:t)+(r?1:-1)*(h?-1:1)*this.axisTitleMargin+[-g,g,p.f,-g][this.side],x={x:r?m+c:v+(h?this.width:0)+d+c,y:r?v+f-(h?this.height:0)+d:m+f};return fireEvent$y(this,"afterGetTitlePosition",{titlePosition:x}),x},o.prototype.renderMinorTick=function(r,t){var n=this,s=n.minorTicks;s[r]||(s[r]=new Tick(n,r,"minor")),t&&s[r].isNew&&s[r].render(null,!0),s[r].render(null,!1,1)},o.prototype.renderTick=function(r,t,n){var s=this,a=s.isLinked,l=s.ticks;(!a||r>=s.min&&r<=s.max||s.grid&&s.grid.isColumn)&&(l[r]||(l[r]=new Tick(s,r)),n&&l[r].isNew&&l[r].render(t,!0,-1),l[r].render(t))},o.prototype.render=function(){var r=this,t=r.chart,n=r.logarithmic,s=t.renderer,a=r.options,l=r.isLinked,h=r.tickPositions,d=r.axisTitle,c=r.ticks,f=r.minorTicks,u=r.alternateBands,p=a.stackLabels,g=a.alternateGridColor,m=r.tickmarkOffset,v=r.axisLine,x=r.showAxis,y=animObject$a(s.globalAnimation),b,$;if(r.labelEdge.length=0,r.overlap=!1,[c,f,u].forEach(function(A){objectEach$s(A,function(P){P.isActive=!1})}),r.hasData()||l){var S=r.chart.hasRendered&&r.old&&isNumber$H(r.old.min);r.minorTickInterval&&!r.categories&&r.getMinorTickPositions().forEach(function(A){r.renderMinorTick(A,S)}),h.length&&(h.forEach(function(A,P){r.renderTick(A,P,S)}),m&&(r.min===0||r.single)&&(c[-1]||(c[-1]=new Tick(r,-1,null,!0)),c[-1].render(-1))),g&&h.forEach(function(A,P){$=typeof h[P+1]<"u"?h[P+1]+m:r.max-m,P%2===0&&A<r.max&&$<=r.max+(t.polar?-m:m)&&(u[A]||(u[A]=new H.PlotLineOrBand(r)),b=A+m,u[A].options={from:n?n.lin2log(b):b,to:n?n.lin2log($):$,color:g,className:"highcharts-alternate-grid"},u[A].render(),u[A].isActive=!0)}),r._addedPlotLB||(r._addedPlotLB=!0,(a.plotLines||[]).concat(a.plotBands||[]).forEach(function(A){r.addPlotBandOrLine(A)}))}if([c,f,u].forEach(function(A){var P=[],E=y.duration,M=function(){for(var C=P.length;C--;)A[P[C]]&&!A[P[C]].isActive&&(A[P[C]].destroy(),delete A[P[C]])};objectEach$s(A,function(C,O){C.isActive||(C.render(O,!1,0),C.isActive=!1,P.push(O))}),syncTimeout$7(M,A===u||!t.hasRendered||!E?0:E)}),v&&(v[v.isPlaced?"animate":"attr"]({d:this.getLinePath(v.strokeWidth())}),v.isPlaced=!0,v[x?"show":"hide"](x)),d&&x){var k=r.getTitlePosition();isNumber$H(k.y)?(d[d.isNew?"attr":"animate"](k),d.isNew=!1):(d.attr("y",-9999),d.isNew=!0)}p&&p.enabled&&r.stacking&&r.stacking.renderStackTotals(),r.old={len:r.len,max:r.max,min:r.min,transA:r.transA,userMax:r.userMax,userMin:r.userMin},r.isDirty=!1,fireEvent$y(this,"afterRender")},o.prototype.redraw=function(){this.visible&&(this.render(),this.plotLinesAndBands.forEach(function(r){r.render()})),this.series.forEach(function(r){r.isDirty=!0})},o.prototype.getKeepProps=function(){return this.keepProps||o.keepProps},o.prototype.destroy=function(r){var t=this,n=t.plotLinesAndBands,s=this.eventOptions;if(fireEvent$y(this,"destroy",{keepEvents:r}),r||removeEvent$9(t),[t.ticks,t.minorTicks,t.alternateBands].forEach(function(h){destroyObjectProperties$7(h)}),n)for(var a=n.length;a--;)n[a].destroy();["axisLine","axisTitle","axisGroup","gridGroup","labelGroup","cross","scrollbar"].forEach(function(h){t[h]&&(t[h]=t[h].destroy())});for(var l in t.plotLinesAndBandsGroups)t.plotLinesAndBandsGroups[l]=t.plotLinesAndBandsGroups[l].destroy();objectEach$s(t,function(h,d){t.getKeepProps().indexOf(d)===-1&&delete t[d]}),this.eventOptions=s},o.prototype.drawCrosshair=function(r,t){var n=this.crosshair,s=pick$1o(n&&n.snap,!0),a=this.chart,l,h,d,c=this.cross,f;if(fireEvent$y(this,"drawCrosshair",{e:r,point:t}),r||(r=this.cross&&this.cross.e),!n||(defined$N(t)||!s)===!1)this.hideCrosshair();else{if(s?defined$N(t)&&(h=pick$1o(this.coll!=="colorAxis"?t.crosshairPos:null,this.isXAxis?t.plotX:this.len-t.plotY)):h=r&&(this.horiz?r.chartX-this.pos:this.len-r.chartY+this.pos),defined$N(h)&&(f={value:t&&(this.isXAxis?t.x:pick$1o(t.stackY,t.y)),translatedValue:h},a.polar&&extend$1i(f,{isCrosshair:!0,chartX:r&&r.chartX,chartY:r&&r.chartY,point:t}),l=this.getPlotLinePath(f)||null),!defined$N(l)){this.hideCrosshair();return}d=this.categories&&!this.isRadial,c||(this.cross=c=a.renderer.path().addClass("highcharts-crosshair highcharts-crosshair-"+(d?"category ":"thin ")+(n.className||"")).attr({zIndex:pick$1o(n.zIndex,2)}).add(),a.styledMode||(c.attr({stroke:n.color||(d?Color.parse(palette.highlightColor20).setOpacity(.25).get():palette.neutralColor20),"stroke-width":pick$1o(n.width,1)}).css({"pointer-events":"none"}),n.dashStyle&&c.attr({dashstyle:n.dashStyle}))),c.show().attr({d:l}),d&&!n.width&&c.attr({"stroke-width":this.transA}),this.cross.e=r}fireEvent$y(this,"afterDrawCrosshair",{e:r,point:t})},o.prototype.hideCrosshair=function(){this.cross&&this.cross.hide(),fireEvent$y(this,"afterHideCrosshair")},o.prototype.hasVerticalPanning=function(){var r=this.chart.options.chart.panning;return!!(r&&r.enabled&&/y/.test(r.type))},o.prototype.validatePositiveValue=function(r){return isNumber$H(r)&&r>0},o.prototype.update=function(r,t){var n=this.chart;r=merge$1g(this.userOptions,r),this.destroy(!0),this.init(n,r),n.isDirtyBox=!0,pick$1o(t,!0)&&n.redraw()},o.prototype.remove=function(r){for(var t=this.chart,n=this.coll,s=this.series,a=s.length;a--;)s[a]&&s[a].remove(!1);erase$7(t.axes,this),erase$7(t[n],this),t[n].forEach(function(l,h){l.options.index=l.userOptions.index=h}),this.destroy(),t.isDirtyBox=!0,pick$1o(r,!0)&&t.redraw()},o.prototype.setTitle=function(r,t){this.update({title:r},t)},o.prototype.setCategories=function(r,t){this.update({categories:r},t)},o.defaultOptions=AxisDefaults$1.defaultXAxisOptions,o.keepProps=["extKey","hcEvents","names","series","userMax","userMin"],o}(),addEvent$_=Utilities.addEvent,getMagnitude$1=Utilities.getMagnitude,normalizeTickInterval$1=Utilities.normalizeTickInterval,timeUnits$1=Utilities.timeUnits,DateTimeAxis;(function(o){var r=[];function t(l){if(r.indexOf(l)===-1){r.push(l),l.keepProps.push("dateTime");var h=l.prototype;h.getTimeTicks=n,addEvent$_(l,"init",s)}return l}o.compose=t;function n(){return this.chart.time.getTimeTicks.apply(this.chart.time,arguments)}function s(l){var h=this,d=l.userOptions;if(d.type!=="datetime"){h.dateTime=void 0;return}h.dateTime||(h.dateTime=new a(h))}var a=function(){function l(h){this.axis=h}return l.prototype.normalizeTimeTickInterval=function(h,d){var c=d||[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2]],["week",[1,2]],["month",[1,2,3,4,6]],["year",null]],f=c[c.length-1],u=timeUnits$1[f[0]],p=f[1],g;for(g=0;g<c.length;g++)if(f=c[g],u=timeUnits$1[f[0]],p=f[1],c[g+1]){var m=(u*p[p.length-1]+timeUnits$1[c[g+1][0]])/2;if(h<=m)break}u===timeUnits$1.year&&h<5*u&&(p=[1,2,5]);var v=normalizeTickInterval$1(h/u,p,f[0]==="year"?Math.max(getMagnitude$1(h/u),1):1);return{unitRange:u,count:v,unitName:f[0]}},l.prototype.getXDateFormat=function(h,d){var c=this.axis;return c.closestPointRange?c.chart.time.getDateFormat(c.closestPointRange,h,c.options.startOfWeek,d)||d.year:d.day},l}();o.Additions=a})(DateTimeAxis||(DateTimeAxis={}));const DateTimeAxis$1=DateTimeAxis;var addEvent$Z=Utilities.addEvent,getMagnitude=Utilities.getMagnitude,normalizeTickInterval=Utilities.normalizeTickInterval,pick$1n=Utilities.pick,LogarithmicAxis;(function(o){var r=[];function t(l){return r.indexOf(l)===-1&&(r.push(l),l.keepProps.push("logarithmic"),addEvent$Z(l,"init",n),addEvent$Z(l,"afterInit",s)),l}o.compose=t;function n(l){var h=this,d=l.userOptions,c=h.logarithmic;d.type!=="logarithmic"?h.logarithmic=void 0:c||(c=h.logarithmic=new a(h))}function s(){var l=this,h=l.logarithmic;h&&(l.lin2val=function(d){return h.lin2log(d)},l.val2lin=function(d){return h.log2lin(d)})}var a=function(){function l(h){this.axis=h}return l.prototype.getLogTickPositions=function(h,d,c,f){var u=this,p=u.axis,g=p.len,m=p.options,v=[];if(f||(u.minorAutoInterval=void 0),h>=.5)h=Math.round(h),v=p.getLinearTickPositions(h,d,c);else if(h>=.08){var x=Math.floor(d),y=void 0,b=void 0,$=void 0,S=void 0,k=void 0,A=void 0,P=void 0;for(h>.3?y=[1,2,4]:h>.15?y=[1,2,4,6,8]:y=[1,2,3,4,5,6,7,8,9],b=x;b<c+1&&!P;b++)for(S=y.length,$=0;$<S&&!P;$++)k=u.log2lin(u.lin2log(b)*y[$]),k>d&&(!f||A<=c)&&typeof A<"u"&&v.push(A),A>c&&(P=!0),A=k}else{var E=u.lin2log(d),M=u.lin2log(c),C=f?p.getMinorTickInterval():m.tickInterval,O=C==="auto"?null:C,L=m.tickPixelInterval/(f?5:1),T=f?g/p.tickPositions.length:g;h=pick$1n(O,u.minorAutoInterval,(M-E)*L/(T||1)),h=normalizeTickInterval(h,void 0,getMagnitude(h)),v=p.getLinearTickPositions(h,E,M).map(u.log2lin),f||(u.minorAutoInterval=h/5)}return f||(p.tickInterval=h),v},l.prototype.lin2log=function(h){return Math.pow(10,h)},l.prototype.log2lin=function(h){return Math.log(h)/Math.LN10},l}();o.Additions=a})(LogarithmicAxis||(LogarithmicAxis={}));const LogarithmicAxis$1=LogarithmicAxis;var erase$6=Utilities.erase,extend$1h=Utilities.extend,isNumber$G=Utilities.isNumber,PlotLineOrBandAxis;(function(o){var r=[],t;function n(a,l){return t||(t=a),r.indexOf(l)===-1&&(r.push(l),extend$1h(l.prototype,s.prototype)),l}o.compose=n;var s=function(){function a(){}return a.prototype.getPlotBandPath=function(l,h,d){d===void 0&&(d=this.options);var c=this.getPlotLinePath({value:h,force:!0,acrossPanes:d.acrossPanes}),f=[],u=this.horiz,p=!isNumber$G(this.min)||!isNumber$G(this.max)||l<this.min&&h<this.min||l>this.max&&h>this.max,g=this.getPlotLinePath({value:l,force:!0,acrossPanes:d.acrossPanes}),m,v=1,x;if(g&&c)for(p&&(x=g.toString()===c.toString(),v=0),m=0;m<g.length;m+=2){var y=g[m],b=g[m+1],$=c[m],S=c[m+1];(y[0]==="M"||y[0]==="L")&&(b[0]==="M"||b[0]==="L")&&($[0]==="M"||$[0]==="L")&&(S[0]==="M"||S[0]==="L")&&(u&&$[1]===y[1]?($[1]+=v,S[1]+=v):!u&&$[2]===y[2]&&($[2]+=v,S[2]+=v),f.push(["M",y[1],y[2]],["L",b[1],b[2]],["L",S[1],S[2]],["L",$[1],$[2]],["Z"])),f.isFlat=x}else g=null;return f},a.prototype.addPlotBand=function(l){return this.addPlotBandOrLine(l,"plotBands")},a.prototype.addPlotLine=function(l){return this.addPlotBandOrLine(l,"plotLines")},a.prototype.addPlotBandOrLine=function(l,h){var d=this,c=this.userOptions,f=new t(this,l);if(this.visible&&(f=f.render()),f){if(this._addedPlotLB||(this._addedPlotLB=!0,(c.plotLines||[]).concat(c.plotBands||[]).forEach(function(p){d.addPlotBandOrLine(p)})),h){var u=c[h]||[];u.push(l),c[h]=u}this.plotLinesAndBands.push(f)}return f},a.prototype.removePlotBandOrLine=function(l){var h=this.plotLinesAndBands,d=this.options,c=this.userOptions;if(h){for(var f=h.length;f--;)h[f].id===l&&h[f].destroy();[d.plotLines||[],c.plotLines||[],d.plotBands||[],c.plotBands||[]].forEach(function(u){for(f=u.length;f--;)(u[f]||{}).id===l&&erase$6(u,u[f])})}},a.prototype.removePlotBand=function(l){this.removePlotBandOrLine(l)},a.prototype.removePlotLine=function(l){this.removePlotBandOrLine(l)},a}()})(PlotLineOrBandAxis||(PlotLineOrBandAxis={}));const PlotLineOrBandAxis$1=PlotLineOrBandAxis;var arrayMax$8=Utilities.arrayMax,arrayMin$7=Utilities.arrayMin,defined$M=Utilities.defined,destroyObjectProperties$6=Utilities.destroyObjectProperties,erase$5=Utilities.erase,fireEvent$x=Utilities.fireEvent,merge$1f=Utilities.merge,objectEach$r=Utilities.objectEach,pick$1m=Utilities.pick,PlotLineOrBand=function(){function o(r,t){this.axis=r,t&&(this.options=t,this.id=t.id)}return o.compose=function(r){return PlotLineOrBandAxis$1.compose(o,r)},o.prototype.render=function(){fireEvent$x(this,"render");var r=this,t=r.axis,n=t.horiz,s=t.logarithmic,a=r.options,l=a.color,h=pick$1m(a.zIndex,0),d=a.events,c={},f=t.chart.renderer,u=a.label,p=r.label,g=a.to,m=a.from,v=a.value,x=r.svgElem,y=[],b,$=defined$M(m)&&defined$M(g),S=defined$M(v),k=!x,A={class:"highcharts-plot-"+($?"band ":"line ")+(a.className||"")},P=$?"bands":"lines";if(s&&(m=s.log2lin(m),g=s.log2lin(g),v=s.log2lin(v)),t.chart.styledMode||(S?(A.stroke=l||palette.neutralColor40,A["stroke-width"]=pick$1m(a.width,1),a.dashStyle&&(A.dashstyle=a.dashStyle)):$&&(A.fill=l||palette.highlightColor10,a.borderWidth&&(A.stroke=a.borderColor,A["stroke-width"]=a.borderWidth))),c.zIndex=h,P+="-"+h,b=t.plotLinesAndBandsGroups[P],b||(t.plotLinesAndBandsGroups[P]=b=f.g("plot-"+P).attr(c).add()),k&&(r.svgElem=x=f.path().attr(A).add(b)),S)y=t.getPlotLinePath({value:v,lineWidth:x.strokeWidth(),acrossPanes:a.acrossPanes});else if($)y=t.getPlotBandPath(m,g,a);else return;return!r.eventsAdded&&d&&(objectEach$r(d,function(E,M){x.on(M,function(C){d[M].apply(r,[C])})}),r.eventsAdded=!0),(k||!x.d)&&y&&y.length?x.attr({d:y}):x&&(y?(x.show(!0),x.animate({d:y})):x.d&&(x.hide(),p&&(r.label=p=p.destroy()))),u&&(defined$M(u.text)||defined$M(u.formatter))&&y&&y.length&&t.width>0&&t.height>0&&!y.isFlat?(u=merge$1f({align:n&&$&&"center",x:n?!$&&4:10,verticalAlign:!n&&$&&"middle",y:n?$?16:10:$?6:-4,rotation:n&&!$&&90},u),this.renderLabel(u,y,$,h)):p&&p.hide(),r},o.prototype.renderLabel=function(r,t,n,s){var a=this,l=a.axis,h=l.chart.renderer,d=a.label;d||(a.label=d=h.text(this.getLabelText(r),0,0,r.useHTML).attr({align:r.textAlign||r.align,rotation:r.rotation,class:"highcharts-plot-"+(n?"band":"line")+"-label "+(r.className||""),zIndex:s}).add(),l.chart.styledMode||d.css(merge$1f({textOverflow:"ellipsis"},r.style)));var c=t.xBounds||[t[0][1],t[1][1],n?t[2][1]:t[0][1]],f=t.yBounds||[t[0][2],t[1][2],n?t[2][2]:t[0][2]],u=arrayMin$7(c),p=arrayMin$7(f);d.align(r,!1,{x:u,y:p,width:arrayMax$8(c)-u,height:arrayMax$8(f)-p}),(!d.alignValue||d.alignValue==="left")&&d.css({width:(d.rotation===90?l.height-(d.alignAttr.y-l.top):l.width-(d.alignAttr.x-l.left))+"px"}),d.show(!0)},o.prototype.getLabelText=function(r){return defined$M(r.formatter)?r.formatter.call(this):r.text},o.prototype.destroy=function(){erase$5(this.axis.plotLinesAndBands,this),delete this.axis,destroyObjectProperties$6(this)},o}(),format$c=FormatUtilities.format,doc$i=H.doc,distribute$3=R.distribute,addEvent$Y=Utilities.addEvent,clamp$f=Utilities.clamp,css$9=Utilities.css,defined$L=Utilities.defined,discardElement$5=Utilities.discardElement,extend$1g=Utilities.extend,fireEvent$w=Utilities.fireEvent,isArray$i=Utilities.isArray,isNumber$F=Utilities.isNumber,isString$6=Utilities.isString,merge$1e=Utilities.merge,pick$1l=Utilities.pick,splat$f=Utilities.splat,syncTimeout$6=Utilities.syncTimeout,Tooltip=function(){function o(r,t){this.container=void 0,this.crosshairs=[],this.distance=0,this.isHidden=!0,this.isSticky=!1,this.now={},this.options={},this.outside=!1,this.chart=r,this.init(r,t)}return o.prototype.applyFilter=function(){var r=this.chart;r.renderer.definition({tagName:"filter",attributes:{id:"drop-shadow-"+r.index,opacity:.5},children:[{tagName:"feGaussianBlur",attributes:{in:"SourceAlpha",stdDeviation:1}},{tagName:"feOffset",attributes:{dx:1,dy:1}},{tagName:"feComponentTransfer",children:[{tagName:"feFuncA",attributes:{type:"linear",slope:.3}}]},{tagName:"feMerge",children:[{tagName:"feMergeNode"},{tagName:"feMergeNode",attributes:{in:"SourceGraphic"}}]}]})},o.prototype.bodyFormatter=function(r){return r.map(function(t){var n=t.series.tooltipOptions;return(n[(t.point.formatPrefix||"point")+"Formatter"]||t.point.tooltipFormatter).call(t.point,n[(t.point.formatPrefix||"point")+"Format"]||"")})},o.prototype.cleanSplit=function(r){this.chart.series.forEach(function(t){var n=t&&t.tt;n&&(!n.isActive||r?t.tt=n.destroy():n.isActive=!1)})},o.prototype.defaultFormatter=function(r){var t=this.points||splat$f(this),n;return n=[r.tooltipFooterHeaderFormatter(t[0])],n=n.concat(r.bodyFormatter(t)),n.push(r.tooltipFooterHeaderFormatter(t[0],!0)),n},o.prototype.destroy=function(){this.label&&(this.label=this.label.destroy()),this.split&&this.tt&&(this.cleanSplit(this.chart,!0),this.tt=this.tt.destroy()),this.renderer&&(this.renderer=this.renderer.destroy(),discardElement$5(this.container)),Utilities.clearTimeout(this.hideTimer),Utilities.clearTimeout(this.tooltipTimeout)},o.prototype.getAnchor=function(r,t){var n=this.chart,s=n.pointer,a=n.inverted,l=n.plotTop,h=n.plotLeft,d,c,f,u=0,p=0;return r=splat$f(r),this.followPointer&&t?(typeof t.chartX>"u"&&(t=s.normalize(t)),d=[t.chartX-h,t.chartY-l]):r[0].tooltipPos?d=r[0].tooltipPos:(r.forEach(function(g){c=g.series.yAxis,f=g.series.xAxis,u+=g.plotX||0,p+=g.plotLow?(g.plotLow+(g.plotHigh||0))/2:g.plotY||0,f&&c&&(a?(u+=l+n.plotHeight-f.len-f.pos,p+=h+n.plotWidth-c.len-c.pos):(u+=f.pos-h,p+=c.pos-l))}),u/=r.length,p/=r.length,d=[a?n.plotWidth-p:u,a?n.plotHeight-u:p],this.shared&&r.length>1&&t&&(a?d[0]=t.chartX-h:d[1]=t.chartY-l)),d.map(Math.round)},o.prototype.getLabel=function(){var r=this,t=this.chart.styledMode,n=this.options,s="tooltip"+(defined$L(n.className)?" "+n.className:""),a=n.style.pointerEvents||(!this.followPointer&&n.stickOnContact?"auto":"none"),l=function(){r.inContact=!0},h=function(v){var x=r.chart.hoverSeries;r.inContact=r.shouldStickOnContact()&&r.chart.pointer.inClass(v.relatedTarget,"highcharts-tooltip"),!r.inContact&&x&&x.onMouseOut&&x.onMouseOut()},d,c=this.chart.renderer;if(!this.label){if(this.outside){var f=this.chart.options.chart.style,u=RendererRegistry$1.getRendererType();this.container=d=H.doc.createElement("div"),d.className="highcharts-tooltip-container",css$9(d,{position:"absolute",top:"1px",pointerEvents:a,zIndex:Math.max(this.options.style.zIndex||0,(f&&f.zIndex||0)+3)}),addEvent$Y(d,"mouseenter",l),addEvent$Y(d,"mouseleave",h),H.doc.body.appendChild(d),this.renderer=c=new u(d,0,0,f,void 0,void 0,c.styledMode)}if(this.split?this.label=c.g(s):(this.label=c.label("",0,0,n.shape,void 0,void 0,n.useHTML,void 0,s).attr({padding:n.padding,r:n.borderRadius}),t||this.label.attr({fill:n.backgroundColor,"stroke-width":n.borderWidth}).css(n.style).css({pointerEvents:a}).shadow(n.shadow)),t&&n.shadow&&(this.applyFilter(),this.label.attr({filter:"url(#drop-shadow-"+this.chart.index+")"})),r.outside&&!r.split){var p=this.label,g=p.xSetter,m=p.ySetter;p.xSetter=function(v){g.call(p,r.distance),d.style.left=v+"px"},p.ySetter=function(v){m.call(p,r.distance),d.style.top=v+"px"}}this.label.on("mouseenter",l).on("mouseleave",h).attr({zIndex:8}).add()}return this.label},o.prototype.getPosition=function(r,t,n){var s=this.chart,a=this.distance,l={},h=s.inverted&&n.h||0,d=this.outside,c=d?doc$i.documentElement.clientWidth-2*a:s.chartWidth,f=d?Math.max(doc$i.body.scrollHeight,doc$i.documentElement.scrollHeight,doc$i.body.offsetHeight,doc$i.documentElement.offsetHeight,doc$i.documentElement.clientHeight):s.chartHeight,u=s.pointer.getChartPosition(),p=function(P){return P*u.scaleX},g=function(P){return P*u.scaleY},m=function(P){var E=P==="x";return[P,E?c:f,E?r:t].concat(d?[E?p(r):g(t),E?u.left-a+p(n.plotX+s.plotLeft):u.top-a+g(n.plotY+s.plotTop),0,E?c:f]:[E?r:t,E?n.plotX+s.plotLeft:n.plotY+s.plotTop,E?s.plotLeft:s.plotTop,E?s.plotLeft+s.plotWidth:s.plotTop+s.plotHeight])},v=m("y"),x=m("x"),y,b=!this.followPointer&&pick$1l(n.ttBelow,!s.inverted==!!n.negative),$=function(P,E,M,C,O,L,T){var _=d?P==="y"?g(a):p(a):a,D=(M-C)/2,N=C<O-a,I=O+a+C<E,B=O-_-M+D,X=O+_-D;if(b&&I)l[P]=X;else if(!b&&N)l[P]=B;else if(N)l[P]=Math.min(T-C,B-h<0?B:B-h);else if(I)l[P]=Math.max(L,X+h+M>E?X:X+h);else return!1},S=function(P,E,M,C,O){var L;return O<a||O>E-a?L=!1:O<M/2?l[P]=1:O>E-C/2?l[P]=E-C-2:l[P]=O-M/2,L},k=function(P){var E=v;v=x,x=E,y=P},A=function(){$.apply(0,v)!==!1?S.apply(0,x)===!1&&!y&&(k(!0),A()):y?l.x=l.y=0:(k(!0),A())};return(s.inverted||this.len>1)&&k(),A(),l},o.prototype.hide=function(r){var t=this;Utilities.clearTimeout(this.hideTimer),r=pick$1l(r,this.options.hideDelay),this.isHidden||(this.hideTimer=syncTimeout$6(function(){t.getLabel().fadeOut(r&&void 0),t.isHidden=!0},r))},o.prototype.init=function(r,t){this.chart=r,this.options=t,this.crosshairs=[],this.now={x:0,y:0},this.isHidden=!0,this.split=t.split&&!r.inverted&&!r.polar,this.shared=t.shared||this.split,this.outside=pick$1l(t.outside,!!(r.scrollablePixelsX||r.scrollablePixelsY))},o.prototype.shouldStickOnContact=function(){return!!(!this.followPointer&&this.options.stickOnContact)},o.prototype.isStickyOnContact=function(){return!!(this.shouldStickOnContact()&&this.inContact)},o.prototype.move=function(r,t,n,s){var a=this,l=a.now,h=a.options.animation!==!1&&!a.isHidden&&(Math.abs(r-l.x)>1||Math.abs(t-l.y)>1),d=a.followPointer||a.len>1;extend$1g(l,{x:h?(2*l.x+r)/3:r,y:h?(l.y+t)/2:t,anchorX:d?void 0:h?(2*l.anchorX+n)/3:n,anchorY:d?void 0:h?(l.anchorY+s)/2:s}),a.getLabel().attr(l),a.drawTracker(),h&&(Utilities.clearTimeout(this.tooltipTimeout),this.tooltipTimeout=setTimeout(function(){a&&a.move(r,t,n,s)},32))},o.prototype.refresh=function(r,t){var n=this,s=this.chart,a=n.options,l=splat$f(r),h=l[0],d=[],c=a.formatter||n.defaultFormatter,f=n.shared,u=s.styledMode,p={};if(a.enabled){Utilities.clearTimeout(this.hideTimer),n.followPointer=!n.split&&h.series.tooltipOptions.followPointer;var g=n.getAnchor(r,t),m=g[0],v=g[1];f&&!(!isArray$i(r)&&r.series&&r.series.noSharedTooltip)?(s.pointer.applyInactiveState(l),l.forEach(function(k){k.setState("hover"),d.push(k.getLabelConfig())}),p={x:h.category,y:h.y},p.points=d):p=h.getLabelConfig(),this.len=d.length;var x=c.call(p,n),y=h.series;if(this.distance=pick$1l(y.tooltipOptions.distance,16),x===!1)this.hide();else{if(n.split)this.renderSplit(x,l);else{var b=m,$=v;if(t&&s.pointer.isDirectTouch&&(b=t.chartX-s.plotLeft,$=t.chartY-s.plotTop),s.polar||y.options.clip===!1||y.shouldShowTooltip(b,$)){var S=n.getLabel();(!a.style.width||u)&&S.css({width:this.chart.spacingBox.width+"px"}),S.attr({text:x&&x.join?x.join(""):x}),S.removeClass(/highcharts-color-[\d]+/g).addClass("highcharts-color-"+pick$1l(h.colorIndex,y.colorIndex)),u||S.attr({stroke:a.borderColor||h.color||y.color||palette.neutralColor60}),n.updatePosition({plotX:m,plotY:v,negative:h.negative,ttBelow:h.ttBelow,h:g[2]||0})}else{n.hide();return}}n.isHidden&&n.label&&n.label.attr({opacity:1}).show(),n.isHidden=!1}fireEvent$w(this,"refresh")}},o.prototype.renderSplit=function(r,t){var n=this,s=n.chart,a=n.chart,l=a.chartWidth,h=a.chartHeight,d=a.plotHeight,c=a.plotLeft,f=a.plotTop,u=a.pointer,p=a.scrollablePixelsY,g=p===void 0?0:p,m=a.scrollablePixelsX,v=a.scrollingContainer,x=v===void 0?{scrollLeft:0,scrollTop:0}:v,y=x.scrollLeft,b=x.scrollTop,$=a.styledMode,S=n.distance,k=n.options,A=n.options.positioner,P=n.outside&&typeof m!="number"?doc$i.documentElement.getBoundingClientRect():{left:y,right:y+l,top:b,bottom:b+h},E=n.getLabel(),M=this.renderer||s.renderer,C=!!(s.xAxis[0]&&s.xAxis[0].opposite),O=u.getChartPosition(),L=O.left,T=O.top,_=f+b,D=0,N=d-g;function I(Y){var Z=Y.isHeader,et=Y.plotX,Q=et===void 0?0:et,tt=Y.plotY,rt=tt===void 0?0:tt,it=Y.series,ot,st;if(Z)ot=c+Q,st=f+d/2;else{var at=it.xAxis,lt=it.yAxis;ot=at.pos+clamp$f(Q,-S,at.len+S),it.shouldShowTooltip(0,lt.pos-f+rt,{ignoreX:!0})&&(st=lt.pos+rt)}return ot=clamp$f(ot,P.left-S,P.right+S),{anchorX:ot,anchorY:st}}function B(Y,Z,et,Q,tt){tt===void 0&&(tt=!0);var rt,it;return et?(rt=C?0:N,it=clamp$f(Y-Q/2,P.left,P.right-Q-(n.outside?L:0))):(rt=Z-_,it=tt?Y-Q-S:Y+S,it=clamp$f(it,tt?it:P.left,P.right)),{x:it,y:rt}}function X(Y,Z,et){var Q=Y,tt=Z.isHeader,rt=Z.series,it="highcharts-color-"+pick$1l(Z.colorIndex,rt.colorIndex,"none");if(!Q){var ot={padding:k.padding,r:k.borderRadius};$||(ot.fill=k.backgroundColor,ot["stroke-width"]=k.borderWidth),Q=M.label("",0,0,k[tt?"headerShape":"shape"],void 0,void 0,k.useHTML).addClass((tt?"highcharts-tooltip-header ":"")+"highcharts-tooltip-box "+it).attr(ot).add(E)}return Q.isActive=!0,Q.attr({text:et}),$||Q.css(k.style).shadow(k.shadow).attr({stroke:k.borderColor||Z.color||rt.color||palette.neutralColor80}),Q}isString$6(r)&&(r=[!1,r]);var W=r.slice(0,t.length+1).reduce(function(Y,Z,et){if(Z!==!1&&Z!==""){var Q=t[et-1]||{isHeader:!0,plotX:t[0].plotX,plotY:d,series:{}},tt=Q.isHeader,rt=tt?n:Q.series,it=rt.tt=X(rt.tt,Q,Z.toString()),ot=it.getBBox(),st=ot.width+it.strokeWidth();tt&&(D=ot.height,N+=D,C&&(_-=D));var at=I(Q),lt=at.anchorX,ht=at.anchorY;if(typeof ht=="number"){var dt=ot.height+1,ct=A?A.call(n,st,dt,Q):B(lt,ht,tt,st);Y.push({align:A?0:void 0,anchorX:lt,anchorY:ht,boxWidth:st,point:Q,rank:pick$1l(ct.rank,tt?1:0),size:dt,target:ct.y,tt:it,x:ct.x})}else it.isActive=!1}return Y},[]);!A&&W.some(function(Y){var Z=n.outside,et=(Z?L:0)+Y.anchorX;return et<P.left&&et+Y.boxWidth<P.right?!0:et<L-P.left+Y.boxWidth&&P.right-et>et})&&(W=W.map(function(Y){var Z=B(Y.anchorX,Y.anchorY,Y.point.isHeader,Y.boxWidth,!1),et=Z.x,Q=Z.y;return extend$1g(Y,{target:Q,x:et})})),n.cleanSplit(),distribute$3(W,N);var F={left:L,right:L};W.forEach(function(Y){var Z=Y.x,et=Y.boxWidth,Q=Y.isHeader;Q||(n.outside&&L+Z<F.left&&(F.left=L+Z),!Q&&n.outside&&F.left+et>F.right&&(F.right=L+Z))}),W.forEach(function(Y){var Z=Y.x,et=Y.anchorX,Q=Y.anchorY,tt=Y.pos,rt=Y.point.isHeader,it={visibility:typeof tt>"u"?"hidden":"inherit",x:Z,y:tt+_,anchorX:et,anchorY:Q};if(n.outside&&Z<et){var ot=L-F.left;ot>0&&(rt||(it.x=Z+ot,it.anchorX=et+ot),rt&&(it.x=(F.right-F.left)/2,it.anchorX=et+ot))}Y.tt.attr(it)});var U=n.container,z=n.outside,V=n.renderer;if(z&&U&&V){var j=E.getBBox(),K=j.width,nt=j.height,q=j.x,J=j.y;V.setSize(K+q,nt+J,!1),U.style.left=F.left+"px",U.style.top=T+"px"}},o.prototype.drawTracker=function(){var r=this;if(r.followPointer||!r.options.stickOnContact){r.tracker&&r.tracker.destroy();return}var t=r.chart,n=r.label,s=r.shared?t.hoverPoints:t.hoverPoint;if(!(!n||!s)){var a={x:0,y:0,width:0,height:0},l=this.getAnchor(s),h=n.getBBox();l[0]+=t.plotLeft-n.translateX,l[1]+=t.plotTop-n.translateY,a.x=Math.min(0,l[0]),a.y=Math.min(0,l[1]),a.width=l[0]<0?Math.max(Math.abs(l[0]),h.width-l[0]):Math.max(Math.abs(l[0]),h.width),a.height=l[1]<0?Math.max(Math.abs(l[1]),h.height-Math.abs(l[1])):Math.max(Math.abs(l[1]),h.height),r.tracker?r.tracker.attr(a):(r.tracker=n.renderer.rect(a).addClass("highcharts-tracker").add(n),t.styledMode||r.tracker.attr({fill:"rgba(0,0,0,0)"}))}},o.prototype.styledModeFormat=function(r){return r.replace('style="font-size: 10px"','class="highcharts-header"').replace(/style="color:{(point|series)\.color}"/g,'class="highcharts-color-{$1.colorIndex}"')},o.prototype.tooltipFooterHeaderFormatter=function(r,t){var n=r.series,s=n.tooltipOptions,a=n.xAxis,l=a&&a.dateTime,h={isFooter:t,labelConfig:r},d=s.xDateFormat,c=s[t?"footerFormat":"headerFormat"];return fireEvent$w(this,"headerFormatter",h,function(f){l&&!d&&isNumber$F(r.key)&&(d=l.getXDateFormat(r.key,s.dateTimeLabelFormats)),l&&d&&(r.point&&r.point.tooltipDateKeys||["key"]).forEach(function(u){c=c.replace("{point."+u+"}","{point."+u+":"+d+"}")}),n.chart.styledMode&&(c=this.styledModeFormat(c)),f.text=format$c(c,{point:r,series:n},this.chart)}),h.text},o.prototype.update=function(r){this.destroy(),merge$1e(!0,this.chart.options.tooltip.userOptions,r),this.init(this.chart,merge$1e(!0,this.options,r))},o.prototype.updatePosition=function(r){var t=this.chart,n=this.options,s=t.pointer,a=this.getLabel(),l=s.getChartPosition(),h=(n.positioner||this.getPosition).call(this,a.width,a.height,r),d=r.plotX+t.plotLeft,c=r.plotY+t.plotTop,f;this.outside&&(f=n.borderWidth+2*this.distance,this.renderer.setSize(a.width+f,a.height+f,!1),(l.scaleX!==1||l.scaleY!==1)&&(css$9(this.container,{transform:"scale("+l.scaleX+", "+l.scaleY+")"}),d*=l.scaleX,c*=l.scaleY),d+=l.left-h.x,c+=l.top-h.y),this.move(Math.round(h.x),Math.round(h.y||0),d,c)},o}(),animObject$9=animationExports.animObject,defaultOptions$c=DefaultOptions.defaultOptions,format$b=FormatUtilities.format,addEvent$X=Utilities.addEvent,defined$K=Utilities.defined,erase$4=Utilities.erase,extend$1f=Utilities.extend,fireEvent$v=Utilities.fireEvent,getNestedProperty$1=Utilities.getNestedProperty,isArray$h=Utilities.isArray,isFunction$2=Utilities.isFunction,isNumber$E=Utilities.isNumber,isObject$b=Utilities.isObject,merge$1d=Utilities.merge,objectEach$q=Utilities.objectEach,pick$1k=Utilities.pick,syncTimeout$5=Utilities.syncTimeout,removeEvent$8=Utilities.removeEvent,uniqueKey$5=Utilities.uniqueKey,Point$2=function(){function o(){this.category=void 0,this.colorIndex=void 0,this.formatPrefix="point",this.id=void 0,this.isNull=!1,this.name=void 0,this.options=void 0,this.percentage=void 0,this.selected=!1,this.series=void 0,this.total=void 0,this.visible=!0,this.x=void 0}return o.prototype.animateBeforeDestroy=function(){var r=this,t={x:r.startXPos,opacity:0},n=r.getGraphicalProps();n.singular.forEach(function(s){var a=s==="dataLabel";r[s]=r[s].animate(a?{x:r[s].startXPos,y:r[s].startYPos,opacity:0}:t)}),n.plural.forEach(function(s){r[s].forEach(function(a){a.element&&a.animate(extend$1f({x:r.startXPos},a.startYPos?{x:a.startXPos,y:a.startYPos}:{}))})})},o.prototype.applyOptions=function(r,t){var n=this,s=n.series,a=s.options.pointValKey||s.pointValKey;return r=o.prototype.optionsToObject.call(this,r),extend$1f(n,r),n.options=n.options?extend$1f(n.options,r):r,r.group&&delete n.group,r.dataLabels&&delete n.dataLabels,a&&(n.y=o.prototype.getNestedProperty.call(n,a)),n.isNull=pick$1k(n.isValid&&!n.isValid(),n.x===null||!isNumber$E(n.y)),n.formatPrefix=n.isNull?"null":"point",n.selected&&(n.state="select"),"name"in n&&typeof t>"u"&&s.xAxis&&s.xAxis.hasNames&&(n.x=s.xAxis.nameToX(n)),typeof n.x>"u"&&s?typeof t>"u"?n.x=s.autoIncrement():n.x=t:isNumber$E(r.x)&&s.options.relativeXValue&&(n.x=s.autoIncrement(r.x)),n},o.prototype.destroy=function(){var r=this,t=r.series,n=t.chart,s=t.options.dataSorting,a=n.hoverPoints,l=r.series.chart.renderer.globalAnimation,h=animObject$9(l),d;function c(){(r.graphic||r.dataLabel||r.dataLabels)&&(removeEvent$8(r),r.destroyElements());for(d in r)r[d]=null}r.legendItem&&n.legend.destroyItem(r),a&&(r.setState(),erase$4(a,r),a.length||(n.hoverPoints=null)),r===n.hoverPoint&&r.onMouseOut(),!s||!s.enabled?c():(this.animateBeforeDestroy(),syncTimeout$5(c,h.duration)),n.pointCount--},o.prototype.destroyElements=function(r){var t=this,n=t.getGraphicalProps(r);n.singular.forEach(function(s){t[s]=t[s].destroy()}),n.plural.forEach(function(s){t[s].forEach(function(a){a.element&&a.destroy()}),delete t[s]})},o.prototype.firePointEvent=function(r,t,n){var s=this,a=this.series,l=a.options;(l.point.events[r]||s.options&&s.options.events&&s.options.events[r])&&s.importEvents(),r==="click"&&l.allowPointSelect&&(n=function(h){s.select&&s.select(null,h.ctrlKey||h.metaKey||h.shiftKey)}),fireEvent$v(s,r,t,n)},o.prototype.getClassName=function(){var r=this;return"highcharts-point"+(r.selected?" highcharts-point-select":"")+(r.negative?" highcharts-negative":"")+(r.isNull?" highcharts-null-point":"")+(typeof r.colorIndex<"u"?" highcharts-color-"+r.colorIndex:"")+(r.options.className?" "+r.options.className:"")+(r.zone&&r.zone.className?" "+r.zone.className.replace("highcharts-negative",""):"")},o.prototype.getGraphicalProps=function(r){var t=this,n=[],s={singular:[],plural:[]},a,l;for(r=r||{graphic:1,dataLabel:1},r.graphic&&n.push("graphic","upperGraphic","shadowGroup"),r.dataLabel&&n.push("dataLabel","dataLabelUpper","connector"),l=n.length;l--;)a=n[l],t[a]&&s.singular.push(a);return["dataLabel","connector"].forEach(function(h){var d=h+"s";r[h]&&t[d]&&s.plural.push(d)}),s},o.prototype.getLabelConfig=function(){return{x:this.category,y:this.y,color:this.color,colorIndex:this.colorIndex,key:this.name||this.category,series:this.series,point:this,percentage:this.percentage,total:this.total||this.stackTotal}},o.prototype.getNestedProperty=function(r){if(r)return r.indexOf("custom.")===0?getNestedProperty$1(r,this.options):this[r]},o.prototype.getZone=function(){var r=this.series,t=r.zones,n=r.zoneAxis||"y",s,a=0;for(s=t[a];this[n]>=s.value;)s=t[++a];return this.nonZonedColor||(this.nonZonedColor=this.color),s&&s.color&&!this.options.color?this.color=s.color:this.color=this.nonZonedColor,s},o.prototype.hasNewShapeType=function(){var r=this,t=r.graphic&&(r.graphic.symbolName||r.graphic.element.nodeName);return t!==this.shapeType},o.prototype.init=function(r,t,n){return this.series=r,this.applyOptions(t,n),this.id=defined$K(this.id)?this.id:uniqueKey$5(),this.resolveColor(),r.chart.pointCount++,fireEvent$v(this,"afterInit"),this},o.prototype.optionsToObject=function(r){var t=this.series,n=t.options.keys,s=n||t.pointArrayMap||["y"],a=s.length,l={},h,d=0,c=0;if(isNumber$E(r)||r===null)l[s[0]]=r;else if(isArray$h(r))for(!n&&r.length>a&&(h=typeof r[0],h==="string"?l.name=r[0]:h==="number"&&(l.x=r[0]),d++);c<a;)(!n||typeof r[d]<"u")&&(s[c].indexOf(".")>0?o.prototype.setNestedProperty(l,r[d],s[c]):l[s[c]]=r[d]),d++,c++;else typeof r=="object"&&(l=r,r.dataLabels&&(t._hasPointLabels=!0),r.marker&&(t._hasPointMarkers=!0));return l},o.prototype.resolveColor=function(){var r=this.series,t=r.chart.options.chart,n=r.chart.styledMode,s,a,l=t.colorCount,h;delete this.nonZonedColor,r.options.colorByPoint?(n||(a=r.options.colors||r.chart.options.colors,s=a[r.colorCounter],l=a.length),h=r.colorCounter,r.colorCounter++,r.colorCounter===l&&(r.colorCounter=0)):(n||(s=r.color),h=r.colorIndex),this.colorIndex=pick$1k(this.options.colorIndex,h),this.color=pick$1k(this.options.color,s)},o.prototype.setNestedProperty=function(r,t,n){var s=n.split(".");return s.reduce(function(a,l,h,d){var c=d.length-1===h;return a[l]=c?t:isObject$b(a[l],!0)?a[l]:{},a[l]},r),r},o.prototype.tooltipFormatter=function(r){var t=this.series,n=t.tooltipOptions,s=pick$1k(n.valueDecimals,""),a=n.valuePrefix||"",l=n.valueSuffix||"";return t.chart.styledMode&&(r=t.chart.tooltip.styledModeFormat(r)),(t.pointArrayMap||["y"]).forEach(function(h){h="{point."+h,(a||l)&&(r=r.replace(RegExp(h+"}","g"),a+h+"}"+l)),r=r.replace(RegExp(h+"}","g"),h+":,."+s+"f}")}),format$b(r,{point:this,series:this.series},t.chart)},o.prototype.update=function(r,t,n,s){var a=this,l=a.series,h=a.graphic,d=l.chart,c=l.options,f;t=pick$1k(t,!0);function u(){a.applyOptions(r);var p=h&&a.hasDummyGraphic,g=a.y===null?!p:p;h&&g&&(a.graphic=h.destroy(),delete a.hasDummyGraphic),isObject$b(r,!0)&&(h&&h.element&&r&&r.marker&&typeof r.marker.symbol<"u"&&(a.graphic=h.destroy()),r&&r.dataLabels&&a.dataLabel&&(a.dataLabel=a.dataLabel.destroy()),a.connector&&(a.connector=a.connector.destroy())),f=a.index,l.updateParallelArrays(a,f),c.data[f]=isObject$b(c.data[f],!0)||isObject$b(r,!0)?a.options:pick$1k(r,c.data[f]),l.isDirty=l.isDirtyData=!0,!l.fixedBox&&l.hasCartesianSeries&&(d.isDirtyBox=!0),c.legendType==="point"&&(d.isDirtyLegend=!0),t&&d.redraw(n)}s===!1?u():a.firePointEvent("update",{options:r},u)},o.prototype.remove=function(r,t){this.series.removePoint(this.series.data.indexOf(this),r,t)},o.prototype.select=function(r,t){var n=this,s=n.series,a=s.chart;r=pick$1k(r,!n.selected),this.selectedStaging=r,n.firePointEvent(r?"select":"unselect",{accumulate:t},function(){n.selected=n.options.selected=r,s.options.data[s.data.indexOf(n)]=n.options,n.setState(r&&"select"),t||a.getSelectedPoints().forEach(function(l){var h=l.series;l.selected&&l!==n&&(l.selected=l.options.selected=!1,h.options.data[h.data.indexOf(l)]=l.options,l.setState(a.hoverPoints&&h.options.inactiveOtherPoints?"inactive":""),l.firePointEvent("unselect"))})}),delete this.selectedStaging},o.prototype.onMouseOver=function(r){var t=this,n=t.series,s=n.chart,a=s.pointer;r=r?a.normalize(r):a.getChartCoordinatesFromPoint(t,s.inverted),a.runPointActions(r,t)},o.prototype.onMouseOut=function(){var r=this,t=r.series.chart;r.firePointEvent("mouseOut"),r.series.options.inactiveOtherPoints||(t.hoverPoints||[]).forEach(function(n){n.setState()}),t.hoverPoints=t.hoverPoint=null},o.prototype.importEvents=function(){if(!this.hasImportedEvents){var r=this,t=merge$1d(r.series.options.point,r.options),n=t.events;r.events=n,objectEach$q(n,function(s,a){isFunction$2(s)&&addEvent$X(r,a,s)}),this.hasImportedEvents=!0}},o.prototype.setState=function(r,t){var n=this,s=n.series,a=n.state,l=s.options.states[r||"normal"]||{},h=defaultOptions$c.plotOptions[s.type].marker&&s.options.marker,d=h&&h.enabled===!1,c=h&&h.states&&h.states[r||"normal"]||{},f=c.enabled===!1,u=n.marker||{},p=s.chart,g=h&&s.markerAttribs,m=s.halo,v,x,y,b=s.stateMarkerGraphic,$;if(r=r||"",!(r===n.state&&!t||n.selected&&r!=="select"||l.enabled===!1||r&&(f||d&&c.enabled===!1)||r&&u.states&&u.states[r]&&u.states[r].enabled===!1)){n.state=r,g&&(v=s.markerAttribs(n,r)),n.graphic&&!n.hasDummyGraphic?(a&&n.graphic.removeClass("highcharts-point-"+a),r&&n.graphic.addClass("highcharts-point-"+r),p.styledMode||(x=s.pointAttribs(n,r),y=pick$1k(p.options.chart.animation,l.animation),s.options.inactiveOtherPoints&&isNumber$E(x.opacity)&&((n.dataLabels||[]).forEach(function(P){P&&P.animate({opacity:x.opacity},y)}),n.connector&&n.connector.animate({opacity:x.opacity},y)),n.graphic.animate(x,y)),v&&n.graphic.animate(v,pick$1k(p.options.chart.animation,c.animation,h.animation)),b&&b.hide()):(r&&c&&($=u.symbol||s.symbol,b&&b.currentSymbol!==$&&(b=b.destroy()),v&&(b?b[t?"animate":"attr"]({x:v.x,y:v.y}):$&&(s.stateMarkerGraphic=b=p.renderer.symbol($,v.x,v.y,v.width,v.height).add(s.markerGroup),b.currentSymbol=$)),!p.styledMode&&b&&b.attr(s.pointAttribs(n,r))),b&&(b[r&&n.isInside?"show":"hide"](),b.element.point=n,b.addClass(n.getClassName(),!0)));var S=l.halo,k=n.graphic||b,A=k&&k.visibility||"inherit";S&&S.size&&k&&A!=="hidden"&&!n.isCluster?(m||(s.halo=m=p.renderer.path().add(k.parentGroup)),m.show()[t?"animate":"attr"]({d:n.haloPath(S.size)}),m.attr({class:"highcharts-halo highcharts-color-"+pick$1k(n.colorIndex,s.colorIndex)+(n.className?" "+n.className:""),visibility:A,zIndex:-1}),m.point=n,p.styledMode||m.attr(extend$1f({fill:n.color||s.color,"fill-opacity":S.opacity},AST.filterUserAttributes(S.attributes||{})))):m&&m.point&&m.point.haloPath&&m.animate({d:m.point.haloPath(0)},null,m.hide),fireEvent$v(n,"afterSetState",{state:r})}},o.prototype.haloPath=function(r){var t=this.series,n=t.chart;return n.renderer.symbols.circle(Math.floor(this.plotX)-r,this.plotY-r,r*2,r*2)},o}(),color$e=Color.parse,charts$3=H.charts,noop$j=H.noop,addEvent$W=Utilities.addEvent,attr$2=Utilities.attr,css$8=Utilities.css,defined$J=Utilities.defined,extend$1e=Utilities.extend,find$i=Utilities.find,fireEvent$u=Utilities.fireEvent,isNumber$D=Utilities.isNumber,isObject$a=Utilities.isObject,objectEach$p=Utilities.objectEach,offset=Utilities.offset,pick$1j=Utilities.pick,splat$e=Utilities.splat,Pointer=function(){function o(r,t){this.lastValidTouch={},this.pinchDown=[],this.runChartClick=!1,this.eventsToUnbind=[],this.chart=r,this.hasDragged=!1,this.options=t,this.init(r,t)}return o.prototype.applyInactiveState=function(r){var t=[],n;(r||[]).forEach(function(s){n=s.series,t.push(n),n.linkedParent&&t.push(n.linkedParent),n.linkedSeries&&(t=t.concat(n.linkedSeries)),n.navigatorSeries&&t.push(n.navigatorSeries)}),this.chart.series.forEach(function(s){t.indexOf(s)===-1?s.setState("inactive",!0):s.options.inactiveOtherPoints&&s.setAllPointsToState("inactive")})},o.prototype.destroy=function(){var r=this;this.eventsToUnbind.forEach(function(t){return t()}),this.eventsToUnbind=[],H.chartCount||(o.unbindDocumentMouseUp&&(o.unbindDocumentMouseUp=o.unbindDocumentMouseUp()),o.unbindDocumentTouchEnd&&(o.unbindDocumentTouchEnd=o.unbindDocumentTouchEnd())),clearInterval(r.tooltipTimeout),objectEach$p(r,function(t,n){r[n]=void 0})},o.prototype.drag=function(r){var t=this.chart,n=t.options.chart,s=this.zoomHor,a=this.zoomVert,l=t.plotLeft,h=t.plotTop,d=t.plotWidth,c=t.plotHeight,f=this.mouseDownX||0,u=this.mouseDownY||0,p=isObject$a(n.panning)?n.panning&&n.panning.enabled:n.panning,g=n.panKey&&r[n.panKey+"Key"],m=r.chartX,v=r.chartY,x,y,b=this.selectionMarker;b&&b.touch||(m<l?m=l:m>l+d&&(m=l+d),v<h?v=h:v>h+c&&(v=h+c),this.hasDragged=Math.sqrt(Math.pow(f-m,2)+Math.pow(u-v,2)),this.hasDragged>10&&(x=t.isInsidePlot(f-l,u-h,{visiblePlotOnly:!0}),t.hasCartesianSeries&&(this.zoomX||this.zoomY)&&x&&!g&&(b||(this.selectionMarker=b=t.renderer.rect(l,h,s?1:d,a?1:c,0).attr({class:"highcharts-selection-marker",zIndex:7}).add(),t.styledMode||b.attr({fill:n.selectionMarkerFill||color$e(palette.highlightColor80).setOpacity(.25).get()}))),b&&s&&(y=m-f,b.attr({width:Math.abs(y),x:(y>0?0:y)+f})),b&&a&&(y=v-u,b.attr({height:Math.abs(y),y:(y>0?0:y)+u})),x&&!b&&p&&t.pan(r,n.panning)))},o.prototype.dragStart=function(r){var t=this.chart;t.mouseIsDown=r.type,t.cancelClick=!1,t.mouseDownX=this.mouseDownX=r.chartX,t.mouseDownY=this.mouseDownY=r.chartY},o.prototype.drop=function(r){var t=this,n=this.chart,s=this.hasPinched;if(this.selectionMarker){var a={originalEvent:r,xAxis:[],yAxis:[]},l=this.selectionMarker,h=l.attr?l.attr("x"):l.x,d=l.attr?l.attr("y"):l.y,c=l.attr?l.attr("width"):l.width,f=l.attr?l.attr("height"):l.height,u;(this.hasDragged||s)&&(n.axes.forEach(function(p){if(p.zoomEnabled&&defined$J(p.min)&&(s||t[{xAxis:"zoomX",yAxis:"zoomY"}[p.coll]])&&isNumber$D(h)&&isNumber$D(d)){var g=p.horiz,m=r.type==="touchend"?p.minPixelPadding:0,v=p.toValue((g?h:d)+m),x=p.toValue((g?h+c:d+f)-m);a[p.coll].push({axis:p,min:Math.min(v,x),max:Math.max(v,x)}),u=!0}}),u&&fireEvent$u(n,"selection",a,function(p){n.zoom(extend$1e(p,s?{animation:!1}:null))})),isNumber$D(n.index)&&(this.selectionMarker=this.selectionMarker.destroy()),s&&this.scaleGroups()}n&&isNumber$D(n.index)&&(css$8(n.container,{cursor:n._cursor}),n.cancelClick=this.hasDragged>10,n.mouseIsDown=this.hasDragged=this.hasPinched=!1,this.pinchDown=[])},o.prototype.findNearestKDPoint=function(r,t,n){var s=this.chart,a=s.hoverPoint,l=s.tooltip;if(a&&l&&l.isStickyOnContact())return a;var h;function d(c,f){var u=c.distX-f.distX,p=c.dist-f.dist,g=(f.series.group&&f.series.group.zIndex)-(c.series.group&&c.series.group.zIndex),m;return u!==0&&t?m=u:p!==0?m=p:g!==0?m=g:m=c.series.index>f.series.index?-1:1,m}return r.forEach(function(c){var f=c.noSharedTooltip&&t,u=!f&&c.options.findNearestPointBy.indexOf("y")<0,p=c.searchPoint(n,u);isObject$a(p,!0)&&p.series&&(!isObject$a(h,!0)||d(h,p)>0)&&(h=p)}),h},o.prototype.getChartCoordinatesFromPoint=function(r,t){var n=r.series,s=n.xAxis,a=n.yAxis,l=r.shapeArgs;if(s&&a){var h=pick$1j(r.clientX,r.plotX),d=r.plotY||0;return r.isNode&&l&&isNumber$D(l.x)&&isNumber$D(l.y)&&(h=l.x,d=l.y),t?{chartX:a.len+a.pos-d,chartY:s.len+s.pos-h}:{chartX:h+s.pos,chartY:d+a.pos}}if(l&&l.x&&l.y)return{chartX:l.x,chartY:l.y}},o.prototype.getChartPosition=function(){if(this.chartPosition)return this.chartPosition;var r=this.chart.container,t=offset(r);this.chartPosition={left:t.left,top:t.top,scaleX:1,scaleY:1};var n=r.offsetWidth,s=r.offsetHeight;return n>2&&s>2&&(this.chartPosition.scaleX=t.width/n,this.chartPosition.scaleY=t.height/s),this.chartPosition},o.prototype.getCoordinates=function(r){var t={xAxis:[],yAxis:[]};return this.chart.axes.forEach(function(n){t[n.isXAxis?"xAxis":"yAxis"].push({axis:n,value:n.toValue(r[n.horiz?"chartX":"chartY"])})}),t},o.prototype.getHoverData=function(r,t,n,s,a,l){var h=[],d=!!(s&&r),c=function(v){return v.visible&&!(!a&&v.directTouch)&&pick$1j(v.options.enableMouseTracking,!0)},f=t,u,p={chartX:l?l.chartX:void 0,chartY:l?l.chartY:void 0,shared:a};fireEvent$u(this,"beforeGetHoverData",p);var g=f&&!f.stickyTracking;u=g?[f]:n.filter(function(v){return p.filter?p.filter(v):c(v)&&v.stickyTracking});var m=d||!l?r:this.findNearestKDPoint(u,a,l);return f=m&&m.series,m&&(a&&!f.noSharedTooltip?(u=n.filter(function(v){return p.filter?p.filter(v):c(v)&&!v.noSharedTooltip}),u.forEach(function(v){var x=find$i(v.points,function(y){return y.x===m.x&&!y.isNull});isObject$a(x)&&(v.chart.isBoosting&&(x=v.getPoint(x)),h.push(x))})):h.push(m)),p={hoverPoint:m},fireEvent$u(this,"afterGetHoverData",p),{hoverPoint:p.hoverPoint,hoverSeries:f,hoverPoints:h}},o.prototype.getPointFromEvent=function(r){for(var t=r.target,n;t&&!n;)n=t.point,t=t.parentNode;return n},o.prototype.onTrackerMouseOut=function(r){var t=this.chart,n=r.relatedTarget||r.toElement,s=t.hoverSeries;this.isDirectTouch=!1,s&&n&&!s.stickyTracking&&!this.inClass(n,"highcharts-tooltip")&&(!this.inClass(n,"highcharts-series-"+s.index)||!this.inClass(n,"highcharts-tracker"))&&s.onMouseOut()},o.prototype.inClass=function(r,t){for(var n;r;){if(n=attr$2(r,"class"),n){if(n.indexOf(t)!==-1)return!0;if(n.indexOf("highcharts-container")!==-1)return!1}r=r.parentNode}},o.prototype.init=function(r,t){this.options=t,this.chart=r,this.runChartClick=!!(t.chart.events&&t.chart.events.click),this.pinchDown=[],this.lastValidTouch={},r.tooltip=new Tooltip(r,t.tooltip),this.followTouchMove=pick$1j(t.tooltip.followTouchMove,!0),this.setDOMEvents()},o.prototype.normalize=function(r,t){var n=r.touches,s=n?n.length?n.item(0):pick$1j(n.changedTouches,r.changedTouches)[0]:r;t||(t=this.getChartPosition());var a=s.pageX-t.left,l=s.pageY-t.top;return a/=t.scaleX,l/=t.scaleY,extend$1e(r,{chartX:Math.round(a),chartY:Math.round(l)})},o.prototype.onContainerClick=function(r){var t=this.chart,n=t.hoverPoint,s=this.normalize(r),a=t.plotLeft,l=t.plotTop;t.cancelClick||(n&&this.inClass(s.target,"highcharts-tracker")?(fireEvent$u(n.series,"click",extend$1e(s,{point:n})),t.hoverPoint&&n.firePointEvent("click",s)):(extend$1e(s,this.getCoordinates(s)),t.isInsidePlot(s.chartX-a,s.chartY-l,{visiblePlotOnly:!0})&&fireEvent$u(t,"click",s)))},o.prototype.onContainerMouseDown=function(r){var t=((r.buttons||r.button)&1)===1;r=this.normalize(r),H.isFirefox&&r.button!==0&&this.onContainerMouseMove(r),(typeof r.button>"u"||t)&&(this.zoomOption(r),t&&r.preventDefault&&r.preventDefault(),this.dragStart(r))},o.prototype.onContainerMouseLeave=function(r){var t=charts$3[pick$1j(o.hoverChartIndex,-1)],n=this.chart.tooltip;n&&n.shouldStickOnContact()&&this.inClass(r.relatedTarget,"highcharts-tooltip-container")||(r=this.normalize(r),t&&(r.relatedTarget||r.toElement)&&(t.pointer.reset(),t.pointer.chartPosition=void 0),n&&!n.isHidden&&this.reset())},o.prototype.onContainerMouseEnter=function(r){delete this.chartPosition},o.prototype.onContainerMouseMove=function(r){var t=this.chart,n=this.normalize(r);this.setHoverChartIndex(),n.preventDefault||(n.returnValue=!1),(t.mouseIsDown==="mousedown"||this.touchSelect(n))&&this.drag(n),!t.openMenu&&(this.inClass(n.target,"highcharts-tracker")||t.isInsidePlot(n.chartX-t.plotLeft,n.chartY-t.plotTop,{visiblePlotOnly:!0}))&&(this.inClass(n.target,"highcharts-no-tooltip")?this.reset(!1,0):this.runPointActions(n))},o.prototype.onDocumentTouchEnd=function(r){var t=charts$3[pick$1j(o.hoverChartIndex,-1)];t&&t.pointer.drop(r)},o.prototype.onContainerTouchMove=function(r){this.touchSelect(r)?this.onContainerMouseMove(r):this.touch(r)},o.prototype.onContainerTouchStart=function(r){this.touchSelect(r)?this.onContainerMouseDown(r):(this.zoomOption(r),this.touch(r,!0))},o.prototype.onDocumentMouseMove=function(r){var t=this.chart,n=this.chartPosition,s=this.normalize(r,n),a=t.tooltip;n&&(!a||!a.isStickyOnContact())&&!t.isInsidePlot(s.chartX-t.plotLeft,s.chartY-t.plotTop,{visiblePlotOnly:!0})&&!this.inClass(s.target,"highcharts-tracker")&&this.reset()},o.prototype.onDocumentMouseUp=function(r){var t=charts$3[pick$1j(o.hoverChartIndex,-1)];t&&t.pointer.drop(r)},o.prototype.pinch=function(r){var t=this,n=t.chart,s=t.pinchDown,a=r.touches||[],l=a.length,h=t.lastValidTouch,d=t.hasZoom,c={},f=l===1&&(t.inClass(r.target,"highcharts-tracker")&&n.runTrackerClick||t.runChartClick),u={},p=t.selectionMarker;l>1?t.initiated=!0:l===1&&this.followTouchMove&&(t.initiated=!1),d&&t.initiated&&!f&&r.cancelable!==!1&&r.preventDefault(),[].map.call(a,function(g){return t.normalize(g)}),r.type==="touchstart"?([].forEach.call(a,function(g,m){s[m]={chartX:g.chartX,chartY:g.chartY}}),h.x=[s[0].chartX,s[1]&&s[1].chartX],h.y=[s[0].chartY,s[1]&&s[1].chartY],n.axes.forEach(function(g){if(g.zoomEnabled){var m=n.bounds[g.horiz?"h":"v"],v=g.minPixelPadding,x=g.toPixels(Math.min(pick$1j(g.options.min,g.dataMin),g.dataMin)),y=g.toPixels(Math.max(pick$1j(g.options.max,g.dataMax),g.dataMax)),b=Math.min(x,y),$=Math.max(x,y);m.min=Math.min(g.pos,b-v),m.max=Math.max(g.pos+g.len,$+v)}}),t.res=!0):t.followTouchMove&&l===1?this.runPointActions(t.normalize(r)):s.length&&(p||(t.selectionMarker=p=extend$1e({destroy:noop$j,touch:!0},n.plotBox)),t.pinchTranslate(s,a,c,p,u,h),t.hasPinched=d,t.scaleGroups(c,u),t.res&&(t.res=!1,this.reset(!1,0)))},o.prototype.pinchTranslate=function(r,t,n,s,a,l){this.zoomHor&&this.pinchTranslateDirection(!0,r,t,n,s,a,l),this.zoomVert&&this.pinchTranslateDirection(!1,r,t,n,s,a,l)},o.prototype.pinchTranslateDirection=function(r,t,n,s,a,l,h,d){var c=this.chart,f=r?"x":"y",u=r?"X":"Y",p="chart"+u,g=r?"width":"height",m=c["plot"+(r?"Left":"Top")],v=c.inverted,x=c.bounds[r?"h":"v"],y=t.length===1,b=t[0][p],$=!y&&t[1][p],S=function(){typeof C=="number"&&Math.abs(b-$)>20&&(E=d||Math.abs(M-C)/Math.abs(b-$)),P=(m-M)/E+b,k=c["plot"+(r?"Width":"Height")]/E},k,A,P,E=d||1,M=n[0][p],C=!y&&n[1][p],O;S(),A=P,A<x.min?(A=x.min,O=!0):A+k>x.max&&(A=x.max-k,O=!0),O?(M-=.8*(M-h[f][0]),typeof C=="number"&&(C-=.8*(C-h[f][1])),S()):h[f]=[M,C],v||(l[f]=P-m,l[g]=k);var L=v?r?"scaleY":"scaleX":"scale"+u,T=v?1/E:E;a[g]=k,a[f]=A,s[L]=E,s["translate"+u]=T*m+(M-T*b)},o.prototype.reset=function(r,t){var n=this,s=n.chart,a=s.hoverSeries,l=s.hoverPoint,h=s.hoverPoints,d=s.tooltip,c=d&&d.shared?h:l;r&&c&&splat$e(c).forEach(function(f){f.series.isCartesian&&typeof f.plotX>"u"&&(r=!1)}),r?d&&c&&splat$e(c).length&&(d.refresh(c),d.shared&&h?h.forEach(function(f){f.setState(f.state,!0),f.series.isCartesian&&(f.series.xAxis.crosshair&&f.series.xAxis.drawCrosshair(null,f),f.series.yAxis.crosshair&&f.series.yAxis.drawCrosshair(null,f))}):l&&(l.setState(l.state,!0),s.axes.forEach(function(f){f.crosshair&&l.series[f.coll]===f&&f.drawCrosshair(null,l)}))):(l&&l.onMouseOut(),h&&h.forEach(function(f){f.setState()}),a&&a.onMouseOut(),d&&d.hide(t),n.unDocMouseMove&&(n.unDocMouseMove=n.unDocMouseMove()),s.axes.forEach(function(f){f.hideCrosshair()}),n.hoverX=s.hoverPoints=s.hoverPoint=null)},o.prototype.runPointActions=function(r,t){var n=this,s=n.chart,a=s.series,l=s.tooltip&&s.tooltip.options.enabled?s.tooltip:void 0,h=l?l.shared:!1,d=t||s.hoverPoint,c=d&&d.series||s.hoverSeries,f=(!r||r.type!=="touchmove")&&(!!t||c&&c.directTouch&&n.isDirectTouch),u=this.getHoverData(d,c,a,f,h,r);d=u.hoverPoint,c=u.hoverSeries;var p=u.hoverPoints,g=c&&c.tooltipOptions.followPointer&&!c.tooltipOptions.split,m=h&&c&&!c.noSharedTooltip;if(d&&(d!==s.hoverPoint||l&&l.isHidden)){if((s.hoverPoints||[]).forEach(function(x){p.indexOf(x)===-1&&x.setState()}),s.hoverSeries!==c&&c.onMouseOver(),n.applyInactiveState(p),(p||[]).forEach(function(x){x.setState("hover")}),s.hoverPoint&&s.hoverPoint.firePointEvent("mouseOut"),!d.series)return;s.hoverPoints=p,s.hoverPoint=d,d.firePointEvent("mouseOver"),l&&l.refresh(m?p:d,r)}else if(g&&l&&!l.isHidden){var v=l.getAnchor([{}],r);s.isInsidePlot(v[0],v[1],{visiblePlotOnly:!0})&&l.updatePosition({plotX:v[0],plotY:v[1]})}n.unDocMouseMove||(n.unDocMouseMove=addEvent$W(s.container.ownerDocument,"mousemove",function(x){var y=charts$3[o.hoverChartIndex];y&&y.pointer.onDocumentMouseMove(x)}),n.eventsToUnbind.push(n.unDocMouseMove)),s.axes.forEach(function(y){var b=pick$1j((y.crosshair||{}).snap,!0),$;b&&($=s.hoverPoint,(!$||$.series[y.coll]!==y)&&($=find$i(p,function(S){return S.series[y.coll]===y}))),$||!b?y.drawCrosshair(r,$):y.hideCrosshair()})},o.prototype.scaleGroups=function(r,t){var n=this.chart;n.series.forEach(function(s){var a=r||s.getPlotBox();s.xAxis&&s.xAxis.zoomEnabled&&s.group&&(s.group.attr(a),s.markerGroup&&(s.markerGroup.attr(a),s.markerGroup.clip(t?n.clipRect:null)),s.dataLabelsGroup&&s.dataLabelsGroup.attr(a))}),n.clipRect.attr(t||n.clipBox)},o.prototype.setDOMEvents=function(){var r=this,t=this.chart.container,n=t.ownerDocument;t.onmousedown=this.onContainerMouseDown.bind(this),t.onmousemove=this.onContainerMouseMove.bind(this),t.onclick=this.onContainerClick.bind(this),this.eventsToUnbind.push(addEvent$W(t,"mouseenter",this.onContainerMouseEnter.bind(this))),this.eventsToUnbind.push(addEvent$W(t,"mouseleave",this.onContainerMouseLeave.bind(this))),o.unbindDocumentMouseUp||(o.unbindDocumentMouseUp=addEvent$W(n,"mouseup",this.onDocumentMouseUp.bind(this)));for(var s=this.chart.renderTo.parentElement;s&&s.tagName!=="BODY";)this.eventsToUnbind.push(addEvent$W(s,"scroll",function(){delete r.chartPosition})),s=s.parentElement;H.hasTouch&&(this.eventsToUnbind.push(addEvent$W(t,"touchstart",this.onContainerTouchStart.bind(this),{passive:!1})),this.eventsToUnbind.push(addEvent$W(t,"touchmove",this.onContainerTouchMove.bind(this),{passive:!1})),o.unbindDocumentTouchEnd||(o.unbindDocumentTouchEnd=addEvent$W(n,"touchend",this.onDocumentTouchEnd.bind(this),{passive:!1})))},o.prototype.setHoverChartIndex=function(){var r=this.chart,t=H.charts[pick$1j(o.hoverChartIndex,-1)];t&&t!==r&&t.pointer.onContainerMouseLeave({relatedTarget:!0}),(!t||!t.mouseIsDown)&&(o.hoverChartIndex=r.index)},o.prototype.touch=function(r,t){var n=this.chart,s,a,l;this.setHoverChartIndex(),r.touches.length===1?(r=this.normalize(r),l=n.isInsidePlot(r.chartX-n.plotLeft,r.chartY-n.plotTop,{visiblePlotOnly:!0}),l&&!n.openMenu?(t&&this.runPointActions(r),r.type==="touchmove"&&(a=this.pinchDown,s=a[0]?Math.sqrt(Math.pow(a[0].chartX-r.chartX,2)+Math.pow(a[0].chartY-r.chartY,2))>=4:!1),pick$1j(s,!0)&&this.pinch(r)):t&&this.reset()):r.touches.length===2&&this.pinch(r)},o.prototype.touchSelect=function(r){return!!(this.chart.options.chart.zoomBySingleTouch&&r.touches&&r.touches.length===1)},o.prototype.zoomOption=function(r){var t=this.chart,n=t.options.chart,s=t.inverted,a=n.zoomType||"",l,h;/touch/.test(r.type)&&(a=pick$1j(n.pinchType,a)),this.zoomX=l=/x/.test(a),this.zoomY=h=/y/.test(a),this.zoomHor=l&&!s||h&&s,this.zoomVert=h&&!s||l&&s,this.hasZoom=l||h},o}(),__extends$V=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),charts$2=H.charts,doc$h=H.doc,noop$i=H.noop,win$a=H.win,addEvent$V=Utilities.addEvent,css$7=Utilities.css,objectEach$o=Utilities.objectEach,removeEvent$7=Utilities.removeEvent,touches={},hasPointerEvent=!!win$a.PointerEvent;function getWebkitTouches(){var o=[];return o.item=function(r){return this[r]},objectEach$o(touches,function(r){o.push({pageX:r.pageX,pageY:r.pageY,target:r.target})}),o}function translateMSPointer(o,r,t,n){var s=charts$2[Pointer.hoverChartIndex||NaN];if((o.pointerType==="touch"||o.pointerType===o.MSPOINTER_TYPE_TOUCH)&&s){var a=s.pointer;n(o),a[r]({type:t,target:o.currentTarget,preventDefault:noop$i,touches:getWebkitTouches()})}}var MSPointer=function(o){__extends$V(r,o);function r(){return o!==null&&o.apply(this,arguments)||this}return r.isRequired=function(){return!!(!H.hasTouch&&(win$a.PointerEvent||win$a.MSPointerEvent))},r.prototype.batchMSEvents=function(t){t(this.chart.container,hasPointerEvent?"pointerdown":"MSPointerDown",this.onContainerPointerDown),t(this.chart.container,hasPointerEvent?"pointermove":"MSPointerMove",this.onContainerPointerMove),t(doc$h,hasPointerEvent?"pointerup":"MSPointerUp",this.onDocumentPointerUp)},r.prototype.destroy=function(){this.batchMSEvents(removeEvent$7),o.prototype.destroy.call(this)},r.prototype.init=function(t,n){o.prototype.init.call(this,t,n),this.hasZoom&&css$7(t.container,{"-ms-touch-action":"none","touch-action":"none"})},r.prototype.onContainerPointerDown=function(t){translateMSPointer(t,"onContainerTouchStart","touchstart",function(n){touches[n.pointerId]={pageX:n.pageX,pageY:n.pageY,target:n.currentTarget}})},r.prototype.onContainerPointerMove=function(t){translateMSPointer(t,"onContainerTouchMove","touchmove",function(n){touches[n.pointerId]={pageX:n.pageX,pageY:n.pageY},touches[n.pointerId].target||(touches[n.pointerId].target=n.currentTarget)})},r.prototype.onDocumentPointerUp=function(t){translateMSPointer(t,"onDocumentTouchEnd","touchend",function(n){delete touches[n.pointerId]})},r.prototype.setDOMEvents=function(){o.prototype.setDOMEvents.call(this),(this.hasZoom||this.followTouchMove)&&this.batchMSEvents(addEvent$V)},r}(Pointer),animObject$8=animationExports.animObject,setAnimation$4=animationExports.setAnimation,format$a=FormatUtilities.format,isFirefox$1=H.isFirefox,marginNames$1=H.marginNames,win$9=H.win,distribute$2=R.distribute,addEvent$U=Utilities.addEvent,createElement$6=Utilities.createElement,css$6=Utilities.css,defined$I=Utilities.defined,discardElement$4=Utilities.discardElement,find$h=Utilities.find,fireEvent$t=Utilities.fireEvent,isNumber$C=Utilities.isNumber,merge$1c=Utilities.merge,pick$1i=Utilities.pick,relativeLength$8=Utilities.relativeLength,stableSort$5=Utilities.stableSort,syncTimeout$4=Utilities.syncTimeout,wrap$c=Utilities.wrap,Legend=function(){function o(r,t){this.allItems=[],this.box=void 0,this.contentGroup=void 0,this.display=!1,this.group=void 0,this.initialItemY=0,this.itemHeight=0,this.itemMarginBottom=0,this.itemMarginTop=0,this.itemX=0,this.itemY=0,this.lastItemY=0,this.lastLineHeight=0,this.legendHeight=0,this.legendWidth=0,this.maxItemWidth=0,this.maxLegendWidth=0,this.offsetWidth=0,this.options={},this.padding=0,this.pages=[],this.proximate=!1,this.scrollGroup=void 0,this.symbolHeight=0,this.symbolWidth=0,this.titleHeight=0,this.totalItemWidth=0,this.widthOption=0,this.chart=r,this.init(r,t)}return o.prototype.init=function(r,t){this.chart=r,this.setOptions(t),t.enabled&&(this.render(),addEvent$U(this.chart,"endResize",function(){this.legend.positionCheckboxes()}),this.proximate?this.unchartrender=addEvent$U(this.chart,"render",function(){this.legend.proximatePositions(),this.legend.positionItems()}):this.unchartrender&&this.unchartrender())},o.prototype.setOptions=function(r){var t=pick$1i(r.padding,8);this.options=r,this.chart.styledMode||(this.itemStyle=r.itemStyle,this.itemHiddenStyle=merge$1c(this.itemStyle,r.itemHiddenStyle)),this.itemMarginTop=r.itemMarginTop||0,this.itemMarginBottom=r.itemMarginBottom||0,this.padding=t,this.initialItemY=t-5,this.symbolWidth=pick$1i(r.symbolWidth,16),this.pages=[],this.proximate=r.layout==="proximate"&&!this.chart.inverted,this.baseline=void 0},o.prototype.update=function(r,t){var n=this.chart;this.setOptions(merge$1c(!0,this.options,r)),this.destroy(),n.isDirtyLegend=n.isDirtyBox=!0,pick$1i(t,!0)&&n.redraw(),fireEvent$t(this,"afterUpdate")},o.prototype.colorizeItem=function(r,t){if(r.legendGroup[t?"removeClass":"addClass"]("highcharts-legend-item-hidden"),!this.chart.styledMode){var n=this,s=n.options,a=r.legendItem,l=r.legendLine,h=r.legendSymbol,d=n.itemHiddenStyle.color,c=t?s.itemStyle.color:d,f=t&&r.color||d,u=r.options&&r.options.marker,p={fill:f};a&&a.css({fill:c,color:c}),l&&l.attr({stroke:f}),h&&(u&&h.isMarker&&(p=r.pointAttribs(),t||(p.stroke=p.fill=d)),h.attr(p))}fireEvent$t(this,"afterColorizeItem",{item:r,visible:t})},o.prototype.positionItems=function(){this.allItems.forEach(this.positionItem,this),this.chart.isResizing||this.positionCheckboxes()},o.prototype.positionItem=function(r){var t=this,n=this,s=n.options,a=s.symbolPadding,l=!s.rtl,h=r._legendItemPos,d=h[0],c=h[1],f=r.checkbox,u=r.legendGroup;if(u&&u.element){var p={translateX:l?d:n.legendWidth-d-2*a-4,translateY:c},g=function(){fireEvent$t(t,"afterPositionItem",{item:r})};defined$I(u.translateY)?u.animate(p,void 0,g):(u.attr(p),g())}f&&(f.x=d,f.y=c)},o.prototype.destroyItem=function(r){var t=r.checkbox;["legendItem","legendLine","legendSymbol","legendGroup"].forEach(function(n){r[n]&&(r[n]=r[n].destroy())}),t&&discardElement$4(r.checkbox)},o.prototype.destroy=function(){function r(t){this[t]&&(this[t]=this[t].destroy())}this.getAllItems().forEach(function(t){["legendItem","legendGroup"].forEach(r,t)}),["clipRect","up","down","pager","nav","box","title","group"].forEach(r,this),this.display=null},o.prototype.positionCheckboxes=function(){var r=this.group&&this.group.alignAttr,t=this.clipHeight||this.legendHeight,n=this.titleHeight,s;r&&(s=r.translateY,this.allItems.forEach(function(a){var l=a.checkbox,h;l&&(h=s+n+l.y+(this.scrollOffset||0)+3,css$6(l,{left:r.translateX+a.checkboxOffset+l.x-20+"px",top:h+"px",display:this.proximate||h>s-6&&h<s+t-6?"":"none"}))},this))},o.prototype.renderTitle=function(){var r=this.options,t=this.padding,n=r.title,s,a=0;n.text&&(this.title||(this.title=this.chart.renderer.label(n.text,t-3,t-4,null,null,null,r.useHTML,null,"legend-title").attr({zIndex:1}),this.chart.styledMode||this.title.css(n.style),this.title.add(this.group)),n.width||this.title.css({width:this.maxLegendWidth+"px"}),s=this.title.getBBox(),a=s.height,this.offsetWidth=s.width,this.contentGroup.attr({translateY:a})),this.titleHeight=a},o.prototype.setText=function(r){var t=this.options;r.legendItem.attr({text:t.labelFormat?format$a(t.labelFormat,r,this.chart):t.labelFormatter.call(r)})},o.prototype.renderItem=function(r){var t=this,n=t.chart,s=n.renderer,a=t.options,l=a.layout==="horizontal",h=t.symbolWidth,d=a.symbolPadding||0,c=t.itemStyle,f=t.itemHiddenStyle,u=l?pick$1i(a.itemDistance,20):0,p=!a.rtl,g=!r.series,m=!g&&r.series.drawLegendSymbol?r.series:r,v=m.options,x=t.createCheckboxForItem&&v&&v.showCheckbox,y=a.useHTML,b=r.options.className,$=r.legendItem,S=h+d+u+(x?20:0);$||(r.legendGroup=s.g("legend-item").addClass("highcharts-"+m.type+"-series highcharts-color-"+r.colorIndex+(b?" "+b:"")+(g?" highcharts-series-"+r.index:"")).attr({zIndex:1}).add(t.scrollGroup),r.legendItem=$=s.text("",p?h+d:-d,t.baseline||0,y),n.styledMode||$.css(merge$1c(r.visible?c:f)),$.attr({align:p?"left":"right",zIndex:2}).add(r.legendGroup),t.baseline||(t.fontMetrics=s.fontMetrics(n.styledMode?12:c.fontSize,$),t.baseline=t.fontMetrics.f+3+t.itemMarginTop,$.attr("y",t.baseline),t.symbolHeight=a.symbolHeight||t.fontMetrics.f,a.squareSymbol&&(t.symbolWidth=pick$1i(a.symbolWidth,Math.max(t.symbolHeight,16)),S=t.symbolWidth+d+u+(x?20:0),p&&$.attr("x",t.symbolWidth+d))),m.drawLegendSymbol(t,r),t.setItemEvents&&t.setItemEvents(r,$,y)),x&&!r.checkbox&&t.createCheckboxForItem&&t.createCheckboxForItem(r),t.colorizeItem(r,r.visible),(n.styledMode||!c.width)&&$.css({width:(a.itemWidth||t.widthOption||n.spacingBox.width)-S+"px"}),t.setText(r);var k=$.getBBox();r.itemWidth=r.checkboxOffset=a.itemWidth||r.legendItemWidth||k.width+S,t.maxItemWidth=Math.max(t.maxItemWidth,r.itemWidth),t.totalItemWidth+=r.itemWidth,t.itemHeight=r.itemHeight=Math.round(r.legendItemHeight||k.height||t.symbolHeight)},o.prototype.layoutItem=function(r){var t=this.options,n=this.padding,s=t.layout==="horizontal",a=r.itemHeight,l=this.itemMarginBottom,h=this.itemMarginTop,d=s?pick$1i(t.itemDistance,20):0,c=this.maxLegendWidth,f=t.alignColumns&&this.totalItemWidth>c?this.maxItemWidth:r.itemWidth;s&&this.itemX-n+f>c&&(this.itemX=n,this.lastLineHeight&&(this.itemY+=h+this.lastLineHeight+l),this.lastLineHeight=0),this.lastItemY=h+this.itemY+l,this.lastLineHeight=Math.max(a,this.lastLineHeight),r._legendItemPos=[this.itemX,this.itemY],s?this.itemX+=f:(this.itemY+=h+a+l,this.lastLineHeight=a),this.offsetWidth=this.widthOption||Math.max((s?this.itemX-n-(r.checkbox?0:d):f)+n,this.offsetWidth)},o.prototype.getAllItems=function(){var r=[];return this.chart.series.forEach(function(t){var n=t&&t.options;t&&pick$1i(n.showInLegend,defined$I(n.linkedTo)?!1:void 0,!0)&&(r=r.concat(t.legendItems||(n.legendType==="point"?t.data:t)))}),fireEvent$t(this,"afterGetAllItems",{allItems:r}),r},o.prototype.getAlignment=function(){var r=this.options;return this.proximate?r.align.charAt(0)+"tv":r.floating?"":r.align.charAt(0)+r.verticalAlign.charAt(0)+r.layout.charAt(0)},o.prototype.adjustMargins=function(r,t){var n=this.chart,s=this.options,a=this.getAlignment();a&&[/(lth|ct|rth)/,/(rtv|rm|rbv)/,/(rbh|cb|lbh)/,/(lbv|lm|ltv)/].forEach(function(l,h){l.test(a)&&!defined$I(r[h])&&(n[marginNames$1[h]]=Math.max(n[marginNames$1[h]],n.legend[(h+1)%2?"legendHeight":"legendWidth"]+[1,-1,-1,1][h]*s[h%2?"x":"y"]+pick$1i(s.margin,12)+t[h]+(n.titleOffset[h]||0)))})},o.prototype.proximatePositions=function(){var r=this.chart,t=[],n=this.options.align==="left";this.allItems.forEach(function(s){var a,l,h=n,d,c;s.yAxis&&(s.xAxis.options.reversed&&(h=!h),s.points&&(a=find$h(h?s.points:s.points.slice(0).reverse(),function(f){return isNumber$C(f.plotY)})),l=this.itemMarginTop+s.legendItem.getBBox().height+this.itemMarginBottom,c=s.yAxis.top-r.plotTop,s.visible?(d=a?a.plotY:s.yAxis.height,d+=c-.3*l):d=c+s.yAxis.height,t.push({target:d,size:l,item:s}))},this),distribute$2(t,r.plotHeight).forEach(function(s){s.item._legendItemPos&&(s.item._legendItemPos[1]=r.plotTop-r.spacing[0]+s.pos)})},o.prototype.render=function(){var r=this,t=r.chart,n=t.renderer,s=r.options,a=r.padding,l=r.getAllItems(),h,d,c,f=r.group,u,p=r.box;r.itemX=a,r.itemY=r.initialItemY,r.offsetWidth=0,r.lastItemY=0,r.widthOption=relativeLength$8(s.width,t.spacingBox.width-a),u=t.spacingBox.width-2*a-s.x,["rm","lm"].indexOf(r.getAlignment().substring(0,2))>-1&&(u/=2),r.maxLegendWidth=r.widthOption||u,f||(r.group=f=n.g("legend").addClass(s.className||"").attr({zIndex:7}).add(),r.contentGroup=n.g().attr({zIndex:1}).add(f),r.scrollGroup=n.g().add(r.contentGroup)),r.renderTitle(),stableSort$5(l,function(g,m){return(g.options&&g.options.legendIndex||0)-(m.options&&m.options.legendIndex||0)}),s.reversed&&l.reverse(),r.allItems=l,r.display=h=!!l.length,r.lastLineHeight=0,r.maxItemWidth=0,r.totalItemWidth=0,r.itemHeight=0,l.forEach(r.renderItem,r),l.forEach(r.layoutItem,r),d=(r.widthOption||r.offsetWidth)+a,c=r.lastItemY+r.lastLineHeight+r.titleHeight,c=r.handleOverflow(c),c+=a,p||(r.box=p=n.rect().addClass("highcharts-legend-box").attr({r:s.borderRadius}).add(f),p.isNew=!0),t.styledMode||p.attr({stroke:s.borderColor,"stroke-width":s.borderWidth||0,fill:s.backgroundColor||"none"}).shadow(s.shadow),d>0&&c>0&&(p[p.isNew?"attr":"animate"](p.crisp.call({},{x:0,y:0,width:d,height:c},p.strokeWidth())),p.isNew=!1),p[h?"show":"hide"](),t.styledMode&&f.getStyle("display")==="none"&&(d=c=0),r.legendWidth=d,r.legendHeight=c,h&&r.align(),this.proximate||this.positionItems(),fireEvent$t(this,"afterRender")},o.prototype.align=function(r){r===void 0&&(r=this.chart.spacingBox);var t=this.chart,n=this.options,s=r.y;/(lth|ct|rth)/.test(this.getAlignment())&&t.titleOffset[0]>0?s+=t.titleOffset[0]:/(lbh|cb|rbh)/.test(this.getAlignment())&&t.titleOffset[2]>0&&(s-=t.titleOffset[2]),s!==r.y&&(r=merge$1c(r,{y:s})),this.group.align(merge$1c(n,{width:this.legendWidth,height:this.legendHeight,verticalAlign:this.proximate?"top":n.verticalAlign}),!0,r)},o.prototype.handleOverflow=function(r){var t=this,n=this.chart,s=n.renderer,a=this.options,l=a.y,h=a.verticalAlign==="top",d=this.padding,c=a.maxHeight,f=a.navigation,u=pick$1i(f.animation,!0),p=f.arrowSize||12,g=this.pages,m=this.allItems,v=function(A){typeof A=="number"?k.attr({height:A}):k&&(t.clipRect=k.destroy(),t.contentGroup.clip()),t.contentGroup.div&&(t.contentGroup.div.style.clip=A?"rect("+d+"px,9999px,"+(d+A)+"px,0)":"auto")},x=function(A){return t[A]=s.circle(0,0,p*1.3).translate(p/2,p/2).add(S),n.styledMode||t[A].attr("fill","rgba(0,0,0,0.0001)"),t[A]},y,b,$=n.spacingBox.height+(h?-l:l)-d,S=this.nav,k=this.clipRect;return a.layout==="horizontal"&&a.verticalAlign!=="middle"&&!a.floating&&($/=2),c&&($=Math.min($,c)),g.length=0,r&&$>0&&r>$&&f.enabled!==!1?(this.clipHeight=y=Math.max($-20-this.titleHeight-d,0),this.currentPage=pick$1i(this.currentPage,1),this.fullHeight=r,m.forEach(function(A,P){var E=A._legendItemPos[1],M=Math.round(A.legendItem.getBBox().height),C=g.length;(!C||E-g[C-1]>y&&(b||E)!==g[C-1])&&(g.push(b||E),C++),A.pageIx=C-1,b&&(m[P-1].pageIx=C-1),P===m.length-1&&E+M-g[C-1]>y&&E!==b&&(g.push(E),A.pageIx=C),E!==b&&(b=E)}),k||(k=t.clipRect=s.clipRect(0,d,9999,0),t.contentGroup.clip(k)),v(y),S||(this.nav=S=s.g().attr({zIndex:1}).add(this.group),this.up=s.symbol("triangle",0,0,p,p).add(S),x("upTracker").on("click",function(){t.scroll(-1,u)}),this.pager=s.text("",15,10).addClass("highcharts-legend-navigation"),n.styledMode||this.pager.css(f.style),this.pager.add(S),this.down=s.symbol("triangle-down",0,0,p,p).add(S),x("downTracker").on("click",function(){t.scroll(1,u)})),t.scroll(0),r=$):S&&(v(),this.nav=S.destroy(),this.scrollGroup.attr({translateY:1}),this.clipHeight=0),r},o.prototype.scroll=function(r,t){var n=this,s=this.chart,a=this.pages,l=a.length,h=this.clipHeight,d=this.options.navigation,c=this.pager,f=this.padding,u=this.currentPage+r;if(u>l&&(u=l),u>0){typeof t<"u"&&setAnimation$4(t,s),this.nav.attr({translateX:f,translateY:h+this.padding+7+this.titleHeight,visibility:"visible"}),[this.up,this.upTracker].forEach(function(g){g.attr({class:u===1?"highcharts-legend-nav-inactive":"highcharts-legend-nav-active"})}),c.attr({text:u+"/"+l}),[this.down,this.downTracker].forEach(function(g){g.attr({x:18+this.pager.getBBox().width,class:u===l?"highcharts-legend-nav-inactive":"highcharts-legend-nav-active"})},this),s.styledMode||(this.up.attr({fill:u===1?d.inactiveColor:d.activeColor}),this.upTracker.css({cursor:u===1?"default":"pointer"}),this.down.attr({fill:u===l?d.inactiveColor:d.activeColor}),this.downTracker.css({cursor:u===l?"default":"pointer"})),this.scrollOffset=-a[u-1]+this.initialItemY,this.scrollGroup.animate({translateY:this.scrollOffset}),this.currentPage=u,this.positionCheckboxes();var p=animObject$8(pick$1i(t,s.renderer.globalAnimation,!0));syncTimeout$4(function(){fireEvent$t(n,"afterScroll",{currentPage:u})},p.duration)}},o.prototype.setItemEvents=function(r,t,n){var s=this,a=s.chart.renderer.boxWrapper,l=r instanceof Point$2,h="highcharts-legend-"+(l?"point":"series")+"-active",d=s.chart.styledMode,c=n?[t,r.legendSymbol]:[r.legendGroup],f=function(u){s.allItems.forEach(function(p){r!==p&&[p].concat(p.linkedSeries||[]).forEach(function(g){g.setState(u,!l)})})};c.forEach(function(u){u&&u.on("mouseover",function(){r.visible&&f("inactive"),r.setState("hover"),r.visible&&a.addClass(h),d||t.css(s.options.itemHoverStyle)}).on("mouseout",function(){s.chart.styledMode||t.css(merge$1c(r.visible?s.itemStyle:s.itemHiddenStyle)),f(""),a.removeClass(h),r.setState()}).on("click",function(p){var g="legendItemClick",m=function(){r.setVisible&&r.setVisible(),f(r.visible?"inactive":"")};a.removeClass(h),p={browserEvent:p},r.firePointEvent?r.firePointEvent(g,p,m):fireEvent$t(r,g,p,m)})})},o.prototype.createCheckboxForItem=function(r){var t=this;r.checkbox=createElement$6("input",{type:"checkbox",className:"highcharts-legend-checkbox",checked:r.selected,defaultChecked:r.selected},t.options.itemCheckboxStyle,t.chart.container),addEvent$U(r.checkbox,"click",function(n){var s=n.target;fireEvent$t(r.series||r,"checkboxClick",{checked:s.checked,item:r},function(){r.select()})})},o}();(/Trident\/7\.0/.test(win$9.navigator&&win$9.navigator.userAgent)||isFirefox$1)&&wrap$c(Legend.prototype,"positionItem",function(o,r){var t=this,n=function(){r._legendItemPos&&o.call(t,r)};n(),t.bubbleLegend||setTimeout(n)});var defaultOptions$b=DefaultOptions.defaultOptions,error$6=Utilities.error,extendClass$1=Utilities.extendClass,merge$1b=Utilities.merge,SeriesRegistry;(function(o){o.seriesTypes=H.seriesTypes;function r(s,a){a===void 0&&(a={});var l=s.options.chart,h=a.type||l.type||l.defaultSeriesType||"",d=o.seriesTypes[h];o||error$6(17,!0,s,{missingModuleFor:h});var c=new d;return typeof c.init=="function"&&c.init(s,a),c}o.getSeries=r;function t(s,a){var l=defaultOptions$b.plotOptions||{},h=a.defaultOptions;a.prototype.pointClass||(a.prototype.pointClass=Point$2),a.prototype.type=s,h&&(l[s]=h),o.seriesTypes[s]=a}o.registerSeriesType=t;function n(s,a,l,h,d){var c=defaultOptions$b.plotOptions||{};return a=a||"",c[s]=merge$1b(c[a],l),t(s,extendClass$1(o.seriesTypes[a]||function(){},h)),o.seriesTypes[s].prototype.type=s,d&&(o.seriesTypes[s].prototype.pointClass=extendClass$1(Point$2,d)),o.seriesTypes[s]}o.seriesType=n})(SeriesRegistry||(SeriesRegistry={}));const SeriesRegistry$1=SeriesRegistry;var animate=animationExports.animate,animObject$7=animationExports.animObject,setAnimation$3=animationExports.setAnimation,numberFormat$1=FormatUtilities.numberFormat,registerEventOptions$1=exports$3.registerEventOptions,charts$1=H.charts,doc$g=H.doc,marginNames=H.marginNames,svg$3=H.svg,win$8=H.win,defaultOptions$a=DefaultOptions.defaultOptions,defaultTime=DefaultOptions.defaultTime,seriesTypes$7=SeriesRegistry$1.seriesTypes,addEvent$T=Utilities.addEvent,attr$1=Utilities.attr,cleanRecursively$1=Utilities.cleanRecursively,createElement$5=Utilities.createElement,css$5=Utilities.css,defined$H=Utilities.defined,discardElement$3=Utilities.discardElement,erase$3=Utilities.erase,error$5=Utilities.error,extend$1d=Utilities.extend,find$g=Utilities.find,fireEvent$s=Utilities.fireEvent,getStyle=Utilities.getStyle,isArray$g=Utilities.isArray,isNumber$B=Utilities.isNumber,isObject$9=Utilities.isObject,isString$5=Utilities.isString,merge$1a=Utilities.merge,objectEach$n=Utilities.objectEach,pick$1h=Utilities.pick,pInt$4=Utilities.pInt,relativeLength$7=Utilities.relativeLength,removeEvent$6=Utilities.removeEvent,splat$d=Utilities.splat,syncTimeout$3=Utilities.syncTimeout,uniqueKey$4=Utilities.uniqueKey,Chart$1=function(){function o(r,t,n){this.axes=void 0,this.axisOffset=void 0,this.bounds=void 0,this.chartHeight=void 0,this.chartWidth=void 0,this.clipBox=void 0,this.colorCounter=void 0,this.container=void 0,this.eventOptions=void 0,this.index=void 0,this.isResizing=void 0,this.labelCollectors=void 0,this.legend=void 0,this.margin=void 0,this.numberFormatter=void 0,this.options=void 0,this.plotBox=void 0,this.plotHeight=void 0,this.plotLeft=void 0,this.plotTop=void 0,this.plotWidth=void 0,this.pointCount=void 0,this.pointer=void 0,this.renderer=void 0,this.renderTo=void 0,this.series=void 0,this.sharedClips={},this.spacing=void 0,this.spacingBox=void 0,this.symbolCounter=void 0,this.time=void 0,this.titleOffset=void 0,this.userOptions=void 0,this.xAxis=void 0,this.yAxis=void 0,this.getArgs(r,t,n)}return o.chart=function(r,t,n){return new o(r,t,n)},o.prototype.getArgs=function(r,t,n){isString$5(r)||r.nodeName?(this.renderTo=r,this.init(t,n)):this.init(r,t)},o.prototype.init=function(r,t){var n=r.plotOptions||{};fireEvent$s(this,"init",{args:arguments},function(){var s=merge$1a(defaultOptions$a,r),a=s.chart;objectEach$n(s.plotOptions,function(h,d){isObject$9(h)&&(h.tooltip=n[d]&&merge$1a(n[d].tooltip)||void 0)}),s.tooltip.userOptions=r.chart&&r.chart.forExport&&r.tooltip.userOptions||r.tooltip,this.userOptions=r,this.margin=[],this.spacing=[],this.bounds={h:{},v:{}},this.labelCollectors=[],this.callback=t,this.isResizing=0,this.options=s,this.axes=[],this.series=[],this.time=r.time&&Object.keys(r.time).length?new Time(r.time):H.time,this.numberFormatter=a.numberFormatter||numberFormat$1,this.styledMode=a.styledMode,this.hasCartesianSeries=a.showAxes;var l=this;l.index=charts$1.length,charts$1.push(l),H.chartCount++,registerEventOptions$1(this,a),l.xAxis=[],l.yAxis=[],l.pointCount=l.colorCounter=l.symbolCounter=0,fireEvent$s(l,"afterInit"),l.firstRender()})},o.prototype.initSeries=function(r){var t=this,n=t.options.chart,s=r.type||n.type||n.defaultSeriesType,a=seriesTypes$7[s];a||error$5(17,!0,t,{missingModuleFor:s});var l=new a;return typeof l.init=="function"&&l.init(t,r),l},o.prototype.setSeriesData=function(){this.getSeriesOrderByLinks().forEach(function(r){!r.points&&!r.data&&r.enabledDataSorting&&r.setData(r.options.data,!1)})},o.prototype.getSeriesOrderByLinks=function(){return this.series.concat().sort(function(r,t){return r.linkedSeries.length||t.linkedSeries.length?t.linkedSeries.length-r.linkedSeries.length:0})},o.prototype.orderSeries=function(r){for(var t=this.series,n=r||0,s=t.length;n<s;++n)t[n]&&(t[n].index=n,t[n].name=t[n].getName())},o.prototype.isInsidePlot=function(r,t,n){var s;n===void 0&&(n={});var a=this,l=a.inverted,h=a.plotBox,d=a.plotLeft,c=a.plotTop,f=a.scrollablePlotBox,u=0,p=0;n.visiblePlotOnly&&this.scrollingContainer&&(s=this.scrollingContainer,u=s.scrollLeft,p=s.scrollTop);var g=n.series,m=n.visiblePlotOnly&&f||h,v=n.inverted?t:r,x=n.inverted?r:t,y={x:v,y:x,isInsidePlot:!0};if(!n.ignoreX){var b=g&&(l?g.yAxis:g.xAxis)||{pos:d,len:1/0},$=n.paneCoordinates?b.pos+v:d+v;$>=Math.max(u+d,b.pos)&&$<=Math.min(u+d+m.width,b.pos+b.len)||(y.isInsidePlot=!1)}if(!n.ignoreY&&y.isInsidePlot){var S=g&&(l?g.xAxis:g.yAxis)||{pos:c,len:1/0},k=n.paneCoordinates?S.pos+x:c+x;k>=Math.max(p+c,S.pos)&&k<=Math.min(p+c+m.height,S.pos+S.len)||(y.isInsidePlot=!1)}return fireEvent$s(this,"afterIsInsidePlot",y),y.isInsidePlot},o.prototype.redraw=function(r){fireEvent$s(this,"beforeRedraw");var t=this,n=t.hasCartesianSeries?t.axes:t.colorAxis||[],s=t.series,a=t.pointer,l=t.legend,h=t.userOptions.legend,d=t.renderer,c=d.isHidden(),f=[],u,p,g,m=t.isDirtyBox,v=t.isDirtyLegend,x;for(t.setResponsive&&t.setResponsive(!1),setAnimation$3(t.hasRendered?r:!1,t),c&&t.temporaryDisplay(),t.layOutTitles(),g=s.length;g--;)if(x=s[g],(x.options.stacking||x.options.centerInCategory)&&(p=!0,x.isDirty)){u=!0;break}if(u)for(g=s.length;g--;)x=s[g],x.options.stacking&&(x.isDirty=!0);s.forEach(function(y){y.isDirty&&(y.options.legendType==="point"?(typeof y.updateTotals=="function"&&y.updateTotals(),v=!0):h&&(h.labelFormatter||h.labelFormat)&&(v=!0)),y.isDirtyData&&fireEvent$s(y,"updatedData")}),v&&l&&l.options.enabled&&(l.render(),t.isDirtyLegend=!1),p&&t.getStacks(),n.forEach(function(y){y.updateNames(),y.setScale()}),t.getMargins(),n.forEach(function(y){y.isDirty&&(m=!0)}),n.forEach(function(y){var b=y.min+","+y.max;y.extKey!==b&&(y.extKey=b,f.push(function(){fireEvent$s(y,"afterSetExtremes",extend$1d(y.eventArgs,y.getExtremes())),delete y.eventArgs})),(m||p)&&y.redraw()}),m&&t.drawChartBox(),fireEvent$s(t,"predraw"),s.forEach(function(y){(m||y.isDirty)&&y.visible&&y.redraw(),y.isDirtyData=!1}),a&&a.reset(!0),d.draw(),fireEvent$s(t,"redraw"),fireEvent$s(t,"render"),c&&t.temporaryDisplay(!0),f.forEach(function(y){y.call()})},o.prototype.get=function(r){var t=this.series;function n(l){return l.id===r||l.options&&l.options.id===r}for(var s=find$g(this.axes,n)||find$g(this.series,n),a=0;!s&&a<t.length;a++)s=find$g(t[a].points||[],n);return s},o.prototype.getAxes=function(){var r=this,t=this.options,n=t.xAxis=splat$d(t.xAxis||{}),s=t.yAxis=splat$d(t.yAxis||{});fireEvent$s(this,"getAxes"),n.forEach(function(l,h){l.index=h,l.isX=!0}),s.forEach(function(l,h){l.index=h});var a=n.concat(s);a.forEach(function(l){new Axis(r,l)}),fireEvent$s(this,"afterGetAxes")},o.prototype.getSelectedPoints=function(){return this.series.reduce(function(r,t){return t.getPointsCollection().forEach(function(n){pick$1h(n.selectedStaging,n.selected)&&r.push(n)}),r},[])},o.prototype.getSelectedSeries=function(){return this.series.filter(function(r){return r.selected})},o.prototype.setTitle=function(r,t,n){this.applyDescription("title",r),this.applyDescription("subtitle",t),this.applyDescription("caption",void 0),this.layOutTitles(n)},o.prototype.applyDescription=function(r,t){var n=this,s=r==="title"?{color:palette.neutralColor80,fontSize:this.options.isStock?"16px":"18px"}:{color:palette.neutralColor60},a=this.options[r]=merge$1a(!this.styledMode&&{style:s},this.options[r],t),l=this[r];l&&t&&(this[r]=l=l.destroy()),a&&!l&&(l=this.renderer.text(a.text,0,0,a.useHTML).attr({align:a.align,class:"highcharts-"+r,zIndex:a.zIndex||4}).add(),l.update=function(h){var d={title:"setTitle",subtitle:"setSubtitle",caption:"setCaption"}[r];n[d](h)},this.styledMode||l.css(a.style),this[r]=l)},o.prototype.layOutTitles=function(r){var t=[0,0,0],n=this.renderer,s=this.spacingBox;["title","subtitle","caption"].forEach(function(l){var h=this[l],d=this.options[l],c=d.verticalAlign||"top",f=l==="title"?c==="top"?-3:0:c==="top"?t[0]+2:0,u,p;h&&(this.styledMode||(u=d.style&&d.style.fontSize),u=n.fontMetrics(u,h).b,h.css({width:(d.width||s.width+(d.widthAdjust||0))+"px"}),p=Math.round(h.getBBox(d.useHTML).height),h.align(extend$1d({y:c==="bottom"?u:f+u,height:p},d),!1,"spacingBox"),d.floating||(c==="top"?t[0]=Math.ceil(t[0]+p):c==="bottom"&&(t[2]=Math.ceil(t[2]+p))))},this),t[0]&&(this.options.title.verticalAlign||"top")==="top"&&(t[0]+=this.options.title.margin),t[2]&&this.options.caption.verticalAlign==="bottom"&&(t[2]+=this.options.caption.margin);var a=!this.titleOffset||this.titleOffset.join(",")!==t.join(",");this.titleOffset=t,fireEvent$s(this,"afterLayOutTitles"),!this.isDirtyBox&&a&&(this.isDirtyBox=this.isDirtyLegend=a,this.hasRendered&&pick$1h(r,!0)&&this.isDirtyBox&&this.redraw())},o.prototype.getChartSize=function(){var r=this,t=r.options.chart,n=t.width,s=t.height,a=r.renderTo;defined$H(n)||(r.containerWidth=getStyle(a,"width")),defined$H(s)||(r.containerHeight=getStyle(a,"height")),r.chartWidth=Math.max(0,n||r.containerWidth||600),r.chartHeight=Math.max(0,relativeLength$7(s,r.chartWidth)||(r.containerHeight>1?r.containerHeight:400))},o.prototype.temporaryDisplay=function(r){var t=this.renderTo,n;if(r)for(;t&&t.style;)t.hcOrigStyle&&(css$5(t,t.hcOrigStyle),delete t.hcOrigStyle),t.hcOrigDetached&&(doc$g.body.removeChild(t),t.hcOrigDetached=!1),t=t.parentNode;else for(;t&&t.style&&(!doc$g.body.contains(t)&&!t.parentNode&&(t.hcOrigDetached=!0,doc$g.body.appendChild(t)),(getStyle(t,"display",!1)==="none"||t.hcOricDetached)&&(t.hcOrigStyle={display:t.style.display,height:t.style.height,overflow:t.style.overflow},n={display:"block",overflow:"hidden"},t!==this.renderTo&&(n.height=0),css$5(t,n),t.offsetWidth||t.style.setProperty("display","block","important")),t=t.parentNode,t!==doc$g.body););},o.prototype.setClassName=function(r){this.container.className="highcharts-container "+(r||"")},o.prototype.getContainer=function(){var r=this,t=r.options,n=t.chart,s="data-highcharts-chart",a=uniqueKey$4(),l,h=r.renderTo;h||(r.renderTo=h=n.renderTo),isString$5(h)&&(r.renderTo=h=doc$g.getElementById(h)),h||error$5(13,!0,r);var d=pInt$4(attr$1(h,s));isNumber$B(d)&&charts$1[d]&&charts$1[d].hasRendered&&charts$1[d].destroy(),attr$1(h,s,r.index),h.innerHTML="",!n.skipClone&&!h.offsetWidth&&r.temporaryDisplay(),r.getChartSize();var c=r.chartWidth,f=r.chartHeight;css$5(h,{overflow:"hidden"}),r.styledMode||(l=extend$1d({position:"relative",overflow:"hidden",width:c+"px",height:f+"px",textAlign:"left",lineHeight:"normal",zIndex:0,"-webkit-tap-highlight-color":"rgba(0,0,0,0)",userSelect:"none","touch-action":"manipulation",outline:"none"},n.style||{}));var u=createElement$5("div",{id:a},l,h);r.container=u,r._cursor=u.style.cursor;var p=n.renderer||!svg$3?RendererRegistry$1.getRendererType(n.renderer):SVGRenderer;if(r.renderer=new p(u,c,f,void 0,n.forExport,t.exporting&&t.exporting.allowHTML,r.styledMode),setAnimation$3(void 0,r),r.setClassName(n.className),!r.styledMode)r.renderer.setStyle(n.style);else for(var g in t.defs)this.renderer.definition(t.defs[g]);r.renderer.chartIndex=r.index,fireEvent$s(this,"afterGetContainer")},o.prototype.getMargins=function(r){var t=this,n=t.spacing,s=t.margin,a=t.titleOffset;this.resetMargins(),a[0]&&!defined$H(s[0])&&(this.plotTop=Math.max(this.plotTop,a[0]+n[0])),a[2]&&!defined$H(s[2])&&(this.marginBottom=Math.max(this.marginBottom,a[2]+n[2])),this.legend&&this.legend.display&&this.legend.adjustMargins(s,n),fireEvent$s(this,"getMargins"),r||this.getAxisMargins()},o.prototype.getAxisMargins=function(){var r=this,t=r.axisOffset=[0,0,0,0],n=r.colorAxis,s=r.margin,a=function(l){l.forEach(function(h){h.visible&&h.getOffset()})};r.hasCartesianSeries?a(r.axes):n&&n.length&&a(n),marginNames.forEach(function(l,h){defined$H(s[h])||(r[l]+=t[h])}),r.setChartSize()},o.prototype.reflow=function(r){var t=this,n=t.options.chart,s=t.renderTo,a=defined$H(n.width)&&defined$H(n.height),l=n.width||getStyle(s,"width"),h=n.height||getStyle(s,"height"),d=r?r.target:win$8;delete t.pointer.chartPosition,!a&&!t.isPrinting&&l&&h&&(d===win$8||d===doc$g)&&((l!==t.containerWidth||h!==t.containerHeight)&&(Utilities.clearTimeout(t.reflowTimeout),t.reflowTimeout=syncTimeout$3(function(){t.container&&t.setSize(void 0,void 0,!1)},r?100:0)),t.containerWidth=l,t.containerHeight=h)},o.prototype.setReflow=function(r){var t=this;r!==!1&&!this.unbindReflow?(this.unbindReflow=addEvent$T(win$8,"resize",function(n){t.options&&t.reflow(n)}),addEvent$T(this,"destroy",this.unbindReflow)):r===!1&&this.unbindReflow&&(this.unbindReflow=this.unbindReflow())},o.prototype.setSize=function(r,t,n){var s=this,a=s.renderer;s.isResizing+=1,setAnimation$3(n,s);var l=a.globalAnimation;s.oldChartHeight=s.chartHeight,s.oldChartWidth=s.chartWidth,typeof r<"u"&&(s.options.chart.width=r),typeof t<"u"&&(s.options.chart.height=t),s.getChartSize(),s.styledMode||(l?animate:css$5)(s.container,{width:s.chartWidth+"px",height:s.chartHeight+"px"},l),s.setChartSize(!0),a.setSize(s.chartWidth,s.chartHeight,l),s.axes.forEach(function(h){h.isDirty=!0,h.setScale()}),s.isDirtyLegend=!0,s.isDirtyBox=!0,s.layOutTitles(),s.getMargins(),s.redraw(l),s.oldChartHeight=null,fireEvent$s(s,"resize"),syncTimeout$3(function(){s&&fireEvent$s(s,"endResize",null,function(){s.isResizing-=1})},animObject$7(l).duration)},o.prototype.setChartSize=function(r){var t=this,n=t.inverted,s=t.renderer,a=t.chartWidth,l=t.chartHeight,h=t.options.chart,d=t.spacing,c=t.clipOffset,f,u,p,g;t.plotLeft=f=Math.round(t.plotLeft),t.plotTop=u=Math.round(t.plotTop),t.plotWidth=p=Math.max(0,Math.round(a-f-t.marginRight)),t.plotHeight=g=Math.max(0,Math.round(l-u-t.marginBottom)),t.plotSizeX=n?g:p,t.plotSizeY=n?p:g,t.plotBorderWidth=h.plotBorderWidth||0,t.spacingBox=s.spacingBox={x:d[3],y:d[0],width:a-d[3]-d[1],height:l-d[0]-d[2]},t.plotBox=s.plotBox={x:f,y:u,width:p,height:g};var m=2*Math.floor(t.plotBorderWidth/2),v=Math.ceil(Math.max(m,c[3])/2),x=Math.ceil(Math.max(m,c[0])/2);t.clipBox={x:v,y:x,width:Math.floor(t.plotSizeX-Math.max(m,c[1])/2-v),height:Math.max(0,Math.floor(t.plotSizeY-Math.max(m,c[2])/2-x))},r||(t.axes.forEach(function(y){y.setAxisSize(),y.setAxisTranslation()}),s.alignElements()),fireEvent$s(t,"afterSetChartSize",{skipAxes:r})},o.prototype.resetMargins=function(){fireEvent$s(this,"resetMargins");var r=this,t=r.options.chart;["margin","spacing"].forEach(function(s){var a=t[s],l=isObject$9(a)?a:[a,a,a,a];["Top","Right","Bottom","Left"].forEach(function(h,d){r[s][d]=pick$1h(t[s+h],l[d])})}),marginNames.forEach(function(n,s){r[n]=pick$1h(r.margin[s],r.spacing[s])}),r.axisOffset=[0,0,0,0],r.clipOffset=[0,0,0,0]},o.prototype.drawChartBox=function(){var r=this,t=r.options.chart,n=r.renderer,s=r.chartWidth,a=r.chartHeight,l=r.styledMode,h=r.plotBGImage,d=t.backgroundColor,c=t.plotBackgroundColor,f=t.plotBackgroundImage,u=r.plotLeft,p=r.plotTop,g=r.plotWidth,m=r.plotHeight,v=r.plotBox,x=r.clipRect,y=r.clipBox,b=r.chartBackground,$=r.plotBackground,S=r.plotBorder,k,A,P,E="animate";b||(r.chartBackground=b=n.rect().addClass("highcharts-background").add(),E="attr"),l?k=A=b.strokeWidth():(k=t.borderWidth||0,A=k+(t.shadow?8:0),P={fill:d||"none"},(k||b["stroke-width"])&&(P.stroke=t.borderColor,P["stroke-width"]=k),b.attr(P).shadow(t.shadow)),b[E]({x:A/2,y:A/2,width:s-A-k%2,height:a-A-k%2,r:t.borderRadius}),E="animate",$||(E="attr",r.plotBackground=$=n.rect().addClass("highcharts-plot-background").add()),$[E](v),l||($.attr({fill:c||"none"}).shadow(t.plotShadow),f&&(h?(f!==h.attr("href")&&h.attr("href",f),h.animate(v)):r.plotBGImage=n.image(f,u,p,g,m).add())),x?x.animate({width:y.width,height:y.height}):r.clipRect=n.clipRect(y),E="animate",S||(E="attr",r.plotBorder=S=n.rect().addClass("highcharts-plot-border").attr({zIndex:1}).add()),l||S.attr({stroke:t.plotBorderColor,"stroke-width":t.plotBorderWidth||0,fill:"none"}),S[E](S.crisp({x:u,y:p,width:g,height:m},-S.strokeWidth())),r.isDirtyBox=!1,fireEvent$s(this,"afterDrawChartBox")},o.prototype.propFromSeries=function(){var r=this,t=r.options.chart,n=r.options.series,s,a,l;["inverted","angular","polar"].forEach(function(h){for(a=seriesTypes$7[t.type||t.defaultSeriesType],l=t[h]||a&&a.prototype[h],s=n&&n.length;!l&&s--;)a=seriesTypes$7[n[s].type],a&&a.prototype[h]&&(l=!0);r[h]=l})},o.prototype.linkSeries=function(){var r=this,t=r.series;t.forEach(function(n){n.linkedSeries.length=0}),t.forEach(function(n){var s=n.options.linkedTo;isString$5(s)&&(s===":previous"?s=r.series[n.index-1]:s=r.get(s),s&&s.linkedParent!==n&&(s.linkedSeries.push(n),n.linkedParent=s,s.enabledDataSorting&&n.setDataSortingOptions(),n.visible=pick$1h(n.options.visible,s.options.visible,n.visible)))}),fireEvent$s(this,"afterLinkSeries")},o.prototype.renderSeries=function(){this.series.forEach(function(r){r.translate(),r.render()})},o.prototype.renderLabels=function(){var r=this,t=r.options.labels;t.items&&t.items.forEach(function(n){var s=extend$1d(t.style,n.style),a=pInt$4(s.left)+r.plotLeft,l=pInt$4(s.top)+r.plotTop+12;delete s.left,delete s.top,r.renderer.text(n.html,a,l).attr({zIndex:2}).css(s).add()})},o.prototype.render=function(){var r=this,t=r.axes,n=r.colorAxis,s=r.renderer,a=r.options,l=function(p){p.forEach(function(g){g.visible&&g.render()})},h=0;r.setTitle(),r.legend=new Legend(r,a.legend),r.getStacks&&r.getStacks(),r.getMargins(!0),r.setChartSize();var d=r.plotWidth;t.some(function(p){if(p.horiz&&p.visible&&p.options.labels.enabled&&p.series.length)return h=21,!0}),r.plotHeight=Math.max(r.plotHeight-h,0);var c=r.plotHeight;t.forEach(function(p){p.setScale()}),r.getAxisMargins();var f=d/r.plotWidth>1.1,u=c/r.plotHeight>1.05;(f||u)&&(t.forEach(function(p){(p.horiz&&f||!p.horiz&&u)&&p.setTickInterval(!0)}),r.getMargins()),r.drawChartBox(),r.hasCartesianSeries?l(t):n&&n.length&&l(n),r.seriesGroup||(r.seriesGroup=s.g("series-group").attr({zIndex:3}).add()),r.renderSeries(),r.renderLabels(),r.addCredits(),r.setResponsive&&r.setResponsive(),r.hasRendered=!0},o.prototype.addCredits=function(r){var t=this,n=merge$1a(!0,this.options.credits,r);n.enabled&&!this.credits&&(this.credits=this.renderer.text(n.text+(this.mapCredits||""),0,0).addClass("highcharts-credits").on("click",function(){n.href&&(win$8.location.href=n.href)}).attr({align:n.position.align,zIndex:8}),t.styledMode||this.credits.css(n.style),this.credits.add().align(n.position),this.credits.update=function(s){t.credits=t.credits.destroy(),t.addCredits(s)})},o.prototype.destroy=function(){var r=this,t=r.axes,n=r.series,s=r.container,a=s&&s.parentNode,l;for(fireEvent$s(r,"destroy"),r.renderer.forExport?erase$3(charts$1,r):charts$1[r.index]=void 0,H.chartCount--,r.renderTo.removeAttribute("data-highcharts-chart"),removeEvent$6(r),l=t.length;l--;)t[l]=t[l].destroy();for(this.scroller&&this.scroller.destroy&&this.scroller.destroy(),l=n.length;l--;)n[l]=n[l].destroy();["title","subtitle","chartBackground","plotBackground","plotBGImage","plotBorder","seriesGroup","clipRect","credits","pointer","rangeSelector","legend","resetZoomButton","tooltip","renderer"].forEach(function(h){var d=r[h];d&&d.destroy&&(r[h]=d.destroy())}),s&&(s.innerHTML="",removeEvent$6(s),a&&discardElement$3(s)),objectEach$n(r,function(h,d){delete r[d]})},o.prototype.firstRender=function(){var r=this,t=r.options;r.isReadyToRender&&!r.isReadyToRender()||(r.getContainer(),r.resetMargins(),r.setChartSize(),r.propFromSeries(),r.getAxes(),(isArray$g(t.series)?t.series:[]).forEach(function(n){r.initSeries(n)}),r.linkSeries(),r.setSeriesData(),fireEvent$s(r,"beforeRender"),MSPointer.isRequired()?r.pointer=new MSPointer(r,t):r.pointer=new Pointer(r,t),r.render(),r.pointer.getChartPosition(),!r.renderer.imgCount&&!r.hasLoaded&&r.onload(),r.temporaryDisplay(!0))},o.prototype.onload=function(){this.callbacks.concat([this.callback]).forEach(function(r){r&&typeof this.index<"u"&&r.apply(this,[this])},this),fireEvent$s(this,"load"),fireEvent$s(this,"render"),defined$H(this.index)&&this.setReflow(this.options.chart.reflow),this.hasLoaded=!0},o.prototype.addSeries=function(r,t,n){var s=this,a;return r&&(t=pick$1h(t,!0),fireEvent$s(s,"addSeries",{options:r},function(){a=s.initSeries(r),s.isDirtyLegend=!0,s.linkSeries(),a.enabledDataSorting&&a.setData(r.data,!1),fireEvent$s(s,"afterAddSeries",{series:a}),t&&s.redraw(n)})),a},o.prototype.addAxis=function(r,t,n,s){return this.createAxis(t?"xAxis":"yAxis",{axis:r,redraw:n,animation:s})},o.prototype.addColorAxis=function(r,t,n){return this.createAxis("colorAxis",{axis:r,redraw:t,animation:n})},o.prototype.createAxis=function(r,t){var n=new Axis(this,merge$1a(t.axis,{index:this[r].length,isX:r==="xAxis"}));return pick$1h(t.redraw,!0)&&this.redraw(t.animation),n},o.prototype.showLoading=function(r){var t=this,n=t.options,s=n.loading,a=function(){l&&css$5(l,{left:t.plotLeft+"px",top:t.plotTop+"px",width:t.plotWidth+"px",height:t.plotHeight+"px"})},l=t.loadingDiv,h=t.loadingSpan;l||(t.loadingDiv=l=createElement$5("div",{className:"highcharts-loading highcharts-loading-hidden"},null,t.container)),h||(t.loadingSpan=h=createElement$5("span",{className:"highcharts-loading-inner"},null,l),addEvent$T(t,"redraw",a)),l.className="highcharts-loading",AST.setElementHTML(h,pick$1h(r,n.lang.loading,"")),t.styledMode||(css$5(l,extend$1d(s.style,{zIndex:10})),css$5(h,s.labelStyle),t.loadingShown||(css$5(l,{opacity:0,display:""}),animate(l,{opacity:s.style.opacity||.5},{duration:s.showDuration||0}))),t.loadingShown=!0,a()},o.prototype.hideLoading=function(){var r=this.options,t=this.loadingDiv;t&&(t.className="highcharts-loading highcharts-loading-hidden",this.styledMode||animate(t,{opacity:0},{duration:r.loading.hideDuration||100,complete:function(){css$5(t,{display:"none"})}})),this.loadingShown=!1},o.prototype.update=function(r,t,n,s){var a=this,l={credits:"addCredits",title:"setTitle",subtitle:"setSubtitle",caption:"setCaption"},h=r.isResponsiveOptions,d=[],c,f,u;fireEvent$s(a,"update",{options:r}),h||a.setResponsive(!1,!0),r=cleanRecursively$1(r,a.options),a.userOptions=merge$1a(a.userOptions,r);var p=r.chart;p&&(merge$1a(!0,a.options.chart,p),"className"in p&&a.setClassName(p.className),"reflow"in p&&a.setReflow(p.reflow),("inverted"in p||"polar"in p||"type"in p)&&(a.propFromSeries(),c=!0),"alignTicks"in p&&(c=!0),"events"in p&&registerEventOptions$1(this,p),objectEach$n(p,function(v,x){a.propsRequireUpdateSeries.indexOf("chart."+x)!==-1&&(f=!0),a.propsRequireDirtyBox.indexOf(x)!==-1&&(a.isDirtyBox=!0),a.propsRequireReflow.indexOf(x)!==-1&&(h?a.isDirtyBox=!0:u=!0)}),!a.styledMode&&p.style&&a.renderer.setStyle(a.options.chart.style||{})),!a.styledMode&&r.colors&&(this.options.colors=r.colors),r.time&&(this.time===defaultTime&&(this.time=new Time(r.time)),merge$1a(!0,a.options.time,r.time)),objectEach$n(r,function(v,x){a[x]&&typeof a[x].update=="function"?a[x].update(v,!1):typeof a[l[x]]=="function"?a[l[x]](v):x!=="colors"&&a.collectionsWithUpdate.indexOf(x)===-1&&merge$1a(!0,a.options[x],r[x]),x!=="chart"&&a.propsRequireUpdateSeries.indexOf(x)!==-1&&(f=!0)}),this.collectionsWithUpdate.forEach(function(v){var x;r[v]&&(x=[],a[v].forEach(function(y,b){y.options.isInternal||x.push(pick$1h(y.options.index,b))}),splat$d(r[v]).forEach(function(y,b){var $=defined$H(y.id),S;$&&(S=a.get(y.id)),!S&&a[v]&&(S=a[v][x?x[b]:b],S&&$&&defined$H(S.options.id)&&(S=void 0)),S&&S.coll===v&&(S.update(y,!1),n&&(S.touched=!0)),!S&&n&&a.collectionsWithInit[v]&&(a.collectionsWithInit[v][0].apply(a,[y].concat(a.collectionsWithInit[v][1]||[]).concat([!1])).touched=!0)}),n&&a[v].forEach(function(y){!y.touched&&!y.options.isInternal?d.push(y):delete y.touched}))}),d.forEach(function(v){v.chart&&v.remove&&v.remove(!1)}),c&&a.axes.forEach(function(v){v.update({},!1)}),f&&a.getSeriesOrderByLinks().forEach(function(v){v.chart&&v.update({},!1)},this);var g=p&&p.width,m=p&&(isString$5(p.height)?relativeLength$7(p.height,g||a.chartWidth):p.height);u||isNumber$B(g)&&g!==a.chartWidth||isNumber$B(m)&&m!==a.chartHeight?a.setSize(g,m,s):pick$1h(t,!0)&&a.redraw(s),fireEvent$s(a,"afterUpdate",{options:r,redraw:t,animation:s})},o.prototype.setSubtitle=function(r,t){this.applyDescription("subtitle",r),this.layOutTitles(t)},o.prototype.setCaption=function(r,t){this.applyDescription("caption",r),this.layOutTitles(t)},o.prototype.showResetZoom=function(){var r=this,t=defaultOptions$a.lang,n=r.options.chart.resetZoomButton,s=n.theme,a=s.states,l=n.relativeTo==="chart"||n.relativeTo==="spacingBox"?null:"scrollablePlotBox";function h(){r.zoomOut()}fireEvent$s(this,"beforeShowResetZoom",null,function(){r.resetZoomButton=r.renderer.button(t.resetZoom,null,null,h,s,a&&a.hover).attr({align:n.position.align,title:t.resetZoomTitle}).addClass("highcharts-reset-zoom").add().align(n.position,!1,l)}),fireEvent$s(this,"afterShowResetZoom")},o.prototype.zoomOut=function(){fireEvent$s(this,"selection",{resetSelection:!0},this.zoom)},o.prototype.zoom=function(r){var t=this,n=t.pointer,s=t.inverted?n.mouseDownX:n.mouseDownY,a=!1,l;!r||r.resetSelection?(t.axes.forEach(function(d){l=d.zoom()}),n.initiated=!1):r.xAxis.concat(r.yAxis).forEach(function(d){var c=d.axis,f=t.inverted?c.left:c.top,u=t.inverted?f+c.width:f+c.height,p=c.isXAxis,g=!1;(!p&&s>=f&&s<=u||p||!defined$H(s))&&(g=!0),n[p?"zoomX":"zoomY"]&&g&&(l=c.zoom(d.min,d.max),c.displayBtn&&(a=!0))});var h=t.resetZoomButton;a&&!h?t.showResetZoom():!a&&isObject$9(h)&&(t.resetZoomButton=h.destroy()),l&&t.redraw(pick$1h(t.options.chart.animation,r&&r.animation,t.pointCount<100))},o.prototype.pan=function(r,t){var n=this,s=n.hoverPoints,a=typeof t=="object"?t:{enabled:t,type:"x"},l=n.options.chart,h=n.options.mapNavigation&&n.options.mapNavigation.enabled;l&&l.panning&&(l.panning=a);var d=a.type,c;fireEvent$s(this,"pan",{originalEvent:r},function(){s&&s.forEach(function(p){p.setState()});var f=n.xAxis;d==="xy"?f=f.concat(n.yAxis):d==="y"&&(f=n.yAxis);var u={};f.forEach(function(p){if(!(!p.options.panningEnabled||p.options.isInternal)){var g=p.horiz,m=r[g?"chartX":"chartY"],v=g?"mouseDownX":"mouseDownY",x=n[v],y=p.minPointOffset||0,b=p.reversed&&!n.inverted||!p.reversed&&n.inverted?-1:1,$=p.getExtremes(),S=p.toValue(x-m,!0)+y*b,k=p.toValue(x+p.len-m,!0)-(y*b||p.isXAxis&&p.pointRangePadding||0),A=k<S,P=p.hasVerticalPanning(),E=A?k:S,M=A?S:k,C=p.panningState,O;P&&!p.isXAxis&&(!C||C.isDirty)&&p.series.forEach(function(_){var D=_.getProcessedData(!0),N=_.getExtremes(D.yData,!0);C||(C={startMin:Number.MAX_VALUE,startMax:-Number.MAX_VALUE}),isNumber$B(N.dataMin)&&isNumber$B(N.dataMax)&&(C.startMin=Math.min(pick$1h(_.options.threshold,1/0),N.dataMin,C.startMin),C.startMax=Math.max(pick$1h(_.options.threshold,-1/0),N.dataMax,C.startMax))});var L=Math.min(pick$1h(C&&C.startMin,$.dataMin),y?$.min:p.toValue(p.toPixels($.min)-p.minPixelPadding)),T=Math.max(pick$1h(C&&C.startMax,$.dataMax),y?$.max:p.toValue(p.toPixels($.max)+p.minPixelPadding));p.panningState=C,p.isOrdinal||(O=L-E,O>0&&(M+=O,E=L),O=M-T,O>0&&(M=T,E-=O),p.series.length&&E!==$.min&&M!==$.max&&E>=L&&M<=T&&(p.setExtremes(E,M,!1,!1,{trigger:"pan"}),!n.resetZoomButton&&!h&&E!==L&&M!==T&&d.match("y")&&(n.showResetZoom(),p.displayBtn=!1),c=!0),u[v]=m)}}),objectEach$n(u,function(p,g){n[g]=p}),c&&n.redraw(!1),css$5(n.container,{cursor:"move"})})},o}();extend$1d(Chart$1.prototype,{callbacks:[],collectionsWithInit:{xAxis:[Chart$1.prototype.addAxis,[!0]],yAxis:[Chart$1.prototype.addAxis,[!1]],series:[Chart$1.prototype.addSeries]},collectionsWithUpdate:["xAxis","yAxis","series"],propsRequireDirtyBox:["backgroundColor","borderColor","borderWidth","borderRadius","plotBackgroundColor","plotBackgroundImage","plotBorderColor","plotBorderWidth","plotShadow","shadow"],propsRequireReflow:["margin","marginTop","marginRight","marginBottom","marginLeft","spacing","spacingTop","spacingRight","spacingBottom","spacingLeft"],propsRequireUpdateSeries:["chart.inverted","chart.polar","chart.ignoreHiddenSeries","chart.type","colors","plotOptions","time","tooltip"]});var merge$19=Utilities.merge,pick$1g=Utilities.pick,LegendSymbol;(function(o){function r(n){var s=this.options,a=n.symbolWidth,l=n.symbolHeight,h=l/2,d=this.chart.renderer,c=this.legendGroup,f=n.baseline-Math.round(n.fontMetrics.b*.3),u={},p,g=s.marker;if(this.chart.styledMode||(u={"stroke-width":s.lineWidth||0},s.dashStyle&&(u.dashstyle=s.dashStyle)),this.legendLine=d.path([["M",0,f],["L",a,f]]).addClass("highcharts-graph").attr(u).add(c),g&&g.enabled!==!1&&a){var m=Math.min(pick$1g(g.radius,h),h);this.symbol.indexOf("url")===0&&(g=merge$19(g,{width:l,height:l}),m=0),this.legendSymbol=p=d.symbol(this.symbol,a/2-m,f-m,2*m,2*m,g).addClass("highcharts-point").add(c),p.isMarker=!0}}o.drawLineMarker=r;function t(n,s){var a=n.options,l=n.symbolHeight,h=a.squareSymbol,d=h?l:n.symbolWidth;s.legendSymbol=this.chart.renderer.rect(h?(n.symbolWidth-l)/2:0,n.baseline-l+1,d,l,pick$1g(n.options.symbolRadius,l/2)).addClass("highcharts-point").attr({zIndex:3}).add(s.legendGroup)}o.drawRectangle=t})(LegendSymbol||(LegendSymbol={}));const LegendSymbol$1=LegendSymbol;var seriesDefaults={lineWidth:2,allowPointSelect:!1,crisp:!0,showCheckbox:!1,animation:{duration:1e3},events:{},marker:{enabledThreshold:2,lineColor:palette.backgroundColor,lineWidth:0,radius:4,states:{normal:{animation:!0},hover:{animation:{duration:50},enabled:!0,radiusPlus:2,lineWidthPlus:1},select:{fillColor:palette.neutralColor20,lineColor:palette.neutralColor100,lineWidth:2}}},point:{events:{}},dataLabels:{animation:{},align:"center",defer:!0,formatter:function(){var o=this.series.chart.numberFormatter;return typeof this.y!="number"?"":o(this.y,-1)},padding:5,style:{fontSize:"11px",fontWeight:"bold",color:"contrast",textOutline:"1px contrast"},verticalAlign:"bottom",x:0,y:0},cropThreshold:300,opacity:1,pointRange:0,softThreshold:!0,states:{normal:{animation:!0},hover:{animation:{duration:50},lineWidthPlus:1,marker:{},halo:{size:10,opacity:.25}},select:{animation:{duration:0}},inactive:{animation:{duration:50},opacity:.2}},stickyTracking:!0,turboThreshold:1e3,findNearestPointBy:"x"},animObject$6=animationExports.animObject,setAnimation$2=animationExports.setAnimation,defaultOptions$9=DefaultOptions.defaultOptions,registerEventOptions=exports$3.registerEventOptions,hasTouch$2=H.hasTouch,svg$2=H.svg,win$7=H.win,seriesTypes$6=SeriesRegistry$1.seriesTypes,addEvent$S=Utilities.addEvent,arrayMax$7=Utilities.arrayMax,arrayMin$6=Utilities.arrayMin,clamp$e=Utilities.clamp,cleanRecursively=Utilities.cleanRecursively,correctFloat$a=Utilities.correctFloat,defined$G=Utilities.defined,erase$2=Utilities.erase,error$4=Utilities.error,extend$1c=Utilities.extend,find$f=Utilities.find,fireEvent$r=Utilities.fireEvent,getNestedProperty=Utilities.getNestedProperty,isArray$f=Utilities.isArray,isNumber$A=Utilities.isNumber,isString$4=Utilities.isString,merge$18=Utilities.merge,objectEach$m=Utilities.objectEach,pick$1f=Utilities.pick,removeEvent$5=Utilities.removeEvent,splat$c=Utilities.splat,syncTimeout$2=Utilities.syncTimeout,Series$e=function(){function o(){this._i=void 0,this.chart=void 0,this.data=void 0,this.eventOptions=void 0,this.eventsToUnbind=void 0,this.index=void 0,this.linkedSeries=void 0,this.options=void 0,this.points=void 0,this.processedXData=void 0,this.processedYData=void 0,this.tooltipOptions=void 0,this.userOptions=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zones=void 0}return o.prototype.init=function(r,t){fireEvent$r(this,"init",{options:t});var n=this,s=r.series;this.eventsToUnbind=[],n.chart=r,n.options=n.setOptions(t);var a=n.options;n.linkedSeries=[],n.bindAxes(),extend$1c(n,{name:a.name,state:"",visible:a.visible!==!1,selected:a.selected===!0}),registerEventOptions(this,a);var l=a.events;(l&&l.click||a.point&&a.point.events&&a.point.events.click||a.allowPointSelect)&&(r.runTrackerClick=!0),n.getColor(),n.getSymbol(),n.parallelArrays.forEach(function(d){n[d+"Data"]||(n[d+"Data"]=[])}),n.isCartesian&&(r.hasCartesianSeries=!0);var h;s.length&&(h=s[s.length-1]),n._i=pick$1f(h&&h._i,-1)+1,n.opacity=n.options.opacity,r.orderSeries(this.insert(s)),a.dataSorting&&a.dataSorting.enabled?n.setDataSortingOptions():!n.points&&!n.data&&n.setData(a.data,!1),fireEvent$r(this,"afterInit")},o.prototype.is=function(r){return seriesTypes$6[r]&&this instanceof seriesTypes$6[r]},o.prototype.insert=function(r){var t=this.options.index,n;if(isNumber$A(t)){for(n=r.length;n--;)if(t>=pick$1f(r[n].options.index,r[n]._i)){r.splice(n+1,0,this);break}n===-1&&r.unshift(this),n=n+1}else r.push(this);return pick$1f(n,r.length-1)},o.prototype.bindAxes=function(){var r=this,t=r.options,n=r.chart,s;fireEvent$r(this,"bindAxes",null,function(){(r.axisTypes||[]).forEach(function(a){var l=0;n[a].forEach(function(h){s=h.options,(t[a]===l&&!s.isInternal||typeof t[a]<"u"&&t[a]===s.id||typeof t[a]>"u"&&s.index===0)&&(r.insert(h.series),r[a]=h,h.isDirty=!0),s.isInternal||l++}),!r[a]&&r.optionalAxis!==a&&error$4(18,!0,n)})}),fireEvent$r(this,"afterBindAxes")},o.prototype.updateParallelArrays=function(r,t){var n=r.series,s=arguments,a=isNumber$A(t)?function(l){var h=l==="y"&&n.toYData?n.toYData(r):r[l];n[l+"Data"][t]=h}:function(l){Array.prototype[t].apply(n[l+"Data"],Array.prototype.slice.call(s,2))};n.parallelArrays.forEach(a)},o.prototype.hasData=function(){return this.visible&&typeof this.dataMax<"u"&&typeof this.dataMin<"u"||this.visible&&this.yData&&this.yData.length>0},o.prototype.autoIncrement=function(r){var t=this.options,n=t.pointIntervalUnit,s=t.relativeXValue,a=this.chart.time,l=this.xIncrement,h,d;return l=pick$1f(l,t.pointStart,0),this.pointInterval=d=pick$1f(this.pointInterval,t.pointInterval,1),s&&isNumber$A(r)&&(d*=r),n&&(h=new a.Date(l),n==="day"?a.set("Date",h,a.get("Date",h)+d):n==="month"?a.set("Month",h,a.get("Month",h)+d):n==="year"&&a.set("FullYear",h,a.get("FullYear",h)+d),d=h.getTime()-l),s&&isNumber$A(r)?l+d:(this.xIncrement=l+d,l)},o.prototype.setDataSortingOptions=function(){var r=this.options;extend$1c(this,{requireSorting:!1,sorted:!1,enabledDataSorting:!0,allowDG:!1}),defined$G(r.pointRange)||(r.pointRange=1)},o.prototype.setOptions=function(r){var t=this.chart,n=t.options,s=n.plotOptions,a=t.userOptions||{},l=merge$18(r),h=t.styledMode,d={plotOptions:s,userOptions:l},c;fireEvent$r(this,"setOptions",d);var f=d.plotOptions[this.type],u=a.plotOptions||{};this.userOptions=d.userOptions;var p=merge$18(f,s.series,a.plotOptions&&a.plotOptions[this.type],l);this.tooltipOptions=merge$18(defaultOptions$9.tooltip,defaultOptions$9.plotOptions.series&&defaultOptions$9.plotOptions.series.tooltip,defaultOptions$9.plotOptions[this.type].tooltip,n.tooltip.userOptions,s.series&&s.series.tooltip,s[this.type].tooltip,l.tooltip),this.stickyTracking=pick$1f(l.stickyTracking,u[this.type]&&u[this.type].stickyTracking,u.series&&u.series.stickyTracking,this.tooltipOptions.shared&&!this.noSharedTooltip?!0:p.stickyTracking),f.marker===null&&delete p.marker,this.zoneAxis=p.zoneAxis;var g=this.zones=(p.zones||[]).slice();return(p.negativeColor||p.negativeFillColor)&&!p.zones&&(c={value:p[this.zoneAxis+"Threshold"]||p.threshold||0,className:"highcharts-negative"},h||(c.color=p.negativeColor,c.fillColor=p.negativeFillColor),g.push(c)),g.length&&defined$G(g[g.length-1].value)&&g.push(h?{}:{color:this.color,fillColor:this.fillColor}),fireEvent$r(this,"afterSetOptions",{options:p}),p},o.prototype.getName=function(){return pick$1f(this.options.name,"Series "+(this.index+1))},o.prototype.getCyclic=function(r,t,n){var s=this.chart,a=this.userOptions,l=r+"Index",h=r+"Counter",d=n?n.length:pick$1f(s.options.chart[r+"Count"],s[r+"Count"]),c,f;t||(f=pick$1f(a[l],a["_"+l]),defined$G(f)?c=f:(s.series.length||(s[h]=0),a["_"+l]=c=s[h]%d,s[h]+=1),n&&(t=n[c])),typeof c<"u"&&(this[l]=c),this[r]=t},o.prototype.getColor=function(){this.chart.styledMode?this.getCyclic("color"):this.options.colorByPoint?this.color=palette.neutralColor20:this.getCyclic("color",this.options.color||defaultOptions$9.plotOptions[this.type].color,this.chart.options.colors)},o.prototype.getPointsCollection=function(){return(this.hasGroupedData?this.points:this.data)||[]},o.prototype.getSymbol=function(){var r=this.options.marker;this.getCyclic("symbol",r.symbol,this.chart.options.symbols)},o.prototype.findPointIndex=function(r,t){var n=r.id,s=r.x,a=this.points,l=this.options.dataSorting,h,d,c;if(n){var f=this.chart.get(n);f instanceof Point$2&&(h=f)}else if(this.linkedParent||this.enabledDataSorting||this.options.relativeXValue){var u=function(p){return!p.touched&&p.index===r.index};if(l&&l.matchByName?u=function(p){return!p.touched&&p.name===r.name}:this.options.relativeXValue&&(u=function(p){return!p.touched&&p.options.x===r.x}),h=find$f(a,u),!h)return}return h&&(c=h&&h.index,typeof c<"u"&&(d=!0)),typeof c>"u"&&isNumber$A(s)&&(c=this.xData.indexOf(s,t)),c!==-1&&typeof c<"u"&&this.cropped&&(c=c>=this.cropStart?c-this.cropStart:c),!d&&isNumber$A(c)&&a[c]&&a[c].touched&&(c=void 0),c},o.prototype.updateData=function(r,t){var n=this.options,s=n.dataSorting,a=this.points,l=[],h=this.requireSorting,d=r.length===a.length,c,f,u,p,g=!0;if(this.xIncrement=null,r.forEach(function(m,v){var x=defined$G(m)&&this.pointClass.prototype.optionsToObject.call({series:this},m)||{},y,b=x.x,$=x.id;$||isNumber$A(b)?(y=this.findPointIndex(x,p),y===-1||typeof y>"u"?l.push(m):a[y]&&m!==n.data[y]?(a[y].update(m,!1,null,!1),a[y].touched=!0,h&&(p=y+1)):a[y]&&(a[y].touched=!0),(!d||v!==y||s&&s.enabled||this.hasDerivedData)&&(c=!0)):l.push(m)},this),c)for(f=a.length;f--;)u=a[f],u&&!u.touched&&u.remove&&u.remove(!1,t);else d&&(!s||!s.enabled)?(r.forEach(function(m,v){m!==a[v].y&&a[v].update&&a[v].update(m,!1,null,!1)}),l.length=0):g=!1;return a.forEach(function(m){m&&(m.touched=!1)}),g?(l.forEach(function(m){this.addPoint(m,!1,null,null,!1)},this),this.xIncrement===null&&this.xData&&this.xData.length&&(this.xIncrement=arrayMax$7(this.xData),this.autoIncrement()),!0):!1},o.prototype.setData=function(r,t,n,s){var a=this,l=a.points,h=l&&l.length||0,d=a.options,c=a.chart,f=d.dataSorting,u=a.xAxis,p=d.turboThreshold,g=this.xData,m=this.yData,v=a.pointArrayMap,x=v&&v.length,y=d.keys,b,$,S,k=0,A=1,P=null;r=r||[];var E=r.length;if(t=pick$1f(t,!0),f&&f.enabled&&(r=this.sortData(r)),s!==!1&&E&&h&&!a.cropped&&!a.hasGroupedData&&a.visible&&!a.isSeriesBoosting&&(S=this.updateData(r,n)),!S){if(a.xIncrement=null,a.colorCounter=0,this.parallelArrays.forEach(function(M){a[M+"Data"].length=0}),p&&E>p)if(P=a.getFirstValidPoint(r),isNumber$A(P))for(b=0;b<E;b++)g[b]=this.autoIncrement(),m[b]=r[b];else if(isArray$f(P))if(x)for(b=0;b<E;b++)$=r[b],g[b]=$[0],m[b]=$.slice(1,x+1);else for(y&&(k=y.indexOf("x"),A=y.indexOf("y"),k=k>=0?k:0,A=A>=0?A:1),b=0;b<E;b++)$=r[b],g[b]=$[k],m[b]=$[A];else error$4(12,!1,c);else for(b=0;b<E;b++)typeof r[b]<"u"&&($={series:a},a.pointClass.prototype.applyOptions.apply($,[r[b]]),a.updateParallelArrays($,b));for(m&&isString$4(m[0])&&error$4(14,!0,c),a.data=[],a.options.data=a.userOptions.data=r,b=h;b--;)l[b]&&l[b].destroy&&l[b].destroy();u&&(u.minRange=u.userMinRange),a.isDirty=c.isDirtyBox=!0,a.isDirtyData=!!l,n=!1}d.legendType==="point"&&(this.processData(),this.generatePoints()),t&&c.redraw(n)},o.prototype.sortData=function(r){var t=this,n=t.options,s=n.dataSorting,a=s.sortKey||"y",l=function(d,c){return defined$G(c)&&d.pointClass.prototype.optionsToObject.call({series:d},c)||{}};r.forEach(function(d,c){r[c]=l(t,d),r[c].index=c},this);var h=r.concat().sort(function(d,c){var f=getNestedProperty(a,d),u=getNestedProperty(a,c);return u<f?-1:u>f?1:0});return h.forEach(function(d,c){d.x=c},this),t.linkedSeries&&t.linkedSeries.forEach(function(d){var c=d.options,f=c.data;(!c.dataSorting||!c.dataSorting.enabled)&&f&&(f.forEach(function(u,p){f[p]=l(d,u),r[p]&&(f[p].x=r[p].x,f[p].index=p)}),d.setData(f,!1))}),r},o.prototype.getProcessedData=function(r){var t=this,n=t.xAxis,s=t.options,a=s.cropThreshold,l=r||t.getExtremesFromAll||s.getExtremesFromAll,h=t.isCartesian,d=n&&n.val2lin,c=!!(n&&n.logarithmic),f,u,p=0,g,m,v,x,y,b,$=t.xData,S=t.yData,k=t.requireSorting,A=!1,P=$.length;for(n&&(x=n.getExtremes(),y=x.min,b=x.max,A=n.categories&&!n.names.length),h&&t.sorted&&!l&&(!a||P>a||t.forceCrop)&&($[P-1]<y||$[0]>b?($=[],S=[]):t.yData&&($[0]<y||$[P-1]>b)&&(f=this.cropData(t.xData,t.yData,y,b),$=f.xData,S=f.yData,p=f.start,u=!0)),v=$.length||1;--v;)g=c?d($[v])-d($[v-1]):$[v]-$[v-1],g>0&&(typeof m>"u"||g<m)?m=g:g<0&&k&&!A&&(error$4(15,!1,t.chart),k=!1);return{xData:$,yData:S,cropped:u,cropStart:p,closestPointRange:m}},o.prototype.processData=function(r){var t=this,n=t.xAxis;if(t.isCartesian&&!t.isDirty&&!n.isDirty&&!t.yAxis.isDirty&&!r)return!1;var s=t.getProcessedData();t.cropped=s.cropped,t.cropStart=s.cropStart,t.processedXData=s.xData,t.processedYData=s.yData,t.closestPointRange=t.basePointRange=s.closestPointRange},o.prototype.cropData=function(r,t,n,s,a){var l=r.length,h,d,c=0,f=l;for(a=pick$1f(a,this.cropShoulder),h=0;h<l;h++)if(r[h]>=n){c=Math.max(0,h-a);break}for(d=h;d<l;d++)if(r[d]>s){f=d+a;break}return{xData:r.slice(c,f),yData:t.slice(c,f),start:c,end:f}},o.prototype.generatePoints=function(){var r=this,t=r.options,n=t.data,s=r.processedXData,a=r.processedYData,l=r.pointClass,h=s.length,d=r.cropStart||0,c=r.hasGroupedData,f=t.keys,u=[],p=t.dataGrouping&&t.dataGrouping.groupAll?d:0,g,m,v,x,y=r.data;if(!y&&!c){var b=[];b.length=n.length,y=r.data=b}for(f&&c&&(r.options.keys=!1),x=0;x<h;x++)m=d+x,c?(v=new l().init(r,[s[x]].concat(splat$c(a[x]))),v.dataGroup=r.groupMap[p+x],v.dataGroup.options&&(v.options=v.dataGroup.options,extend$1c(v,v.dataGroup.options),delete v.dataLabels)):(v=y[m],!v&&typeof n[m]<"u"&&(y[m]=v=new l().init(r,n[m],s[x]))),v&&(v.index=c?p+x:m,u[x]=v);if(r.options.keys=f,y&&(h!==(g=y.length)||c))for(x=0;x<g;x++)x===d&&!c&&(x+=h),y[x]&&(y[x].destroyElements(),y[x].plotX=void 0);r.data=y,r.points=u,fireEvent$r(this,"afterGeneratePoints")},o.prototype.getXExtremes=function(r){return{min:arrayMin$6(r),max:arrayMax$7(r)}},o.prototype.getExtremes=function(r,t){var n=this.xAxis,s=this.yAxis,a=this.processedXData||this.xData,l=[],h=this.requireSorting?this.cropShoulder:0,d=s?s.positiveValuesOnly:!1,c,f,u,p,g,m,v,x=0,y=0,b=0;r=r||this.stackedYData||this.processedYData||[];var $=r.length;for(n&&(c=n.getExtremes(),x=c.min,y=c.max),m=0;m<$;m++)if(p=a[m],g=r[m],f=(isNumber$A(g)||isArray$f(g))&&(g.length||g>0||!d),u=t||this.getExtremesFromAll||this.options.getExtremesFromAll||this.cropped||!n||(a[m+h]||p)>=x&&(a[m-h]||p)<=y,f&&u)if(v=g.length,v)for(;v--;)isNumber$A(g[v])&&(l[b++]=g[v]);else l[b++]=g;var S={dataMin:arrayMin$6(l),dataMax:arrayMax$7(l)};return fireEvent$r(this,"afterGetExtremes",{dataExtremes:S}),S},o.prototype.applyExtremes=function(){var r=this.getExtremes();return this.dataMin=r.dataMin,this.dataMax=r.dataMax,r},o.prototype.getFirstValidPoint=function(r){for(var t=r.length,n=0,s=null;s===null&&n<t;)s=r[n],n++;return s},o.prototype.translate=function(){this.processedXData||this.processData(),this.generatePoints();var r=this,t=r.options,n=t.stacking,s=r.xAxis,a=s.categories,l=r.enabledDataSorting,h=r.yAxis,d=r.points,c=d.length,f=!!r.modifyValue,u=r.pointPlacementToXValue(),p=!!u,g=t.threshold,m=t.startFromThreshold?g:0,v=this.zoneAxis||"y",x,y,b,$,S=Number.MAX_VALUE;function k(_){return clamp$e(_,-1e5,1e5)}for(x=0;x<c;x++){var A=d[x],P=A.x,E=void 0,M=void 0,C=A.y,O=A.low,L=n&&h.stacking&&h.stacking.stacks[(r.negStacks&&C<(m?0:g)?"-":"")+r.stackKey];if((h.positiveValuesOnly&&!h.validatePositiveValue(C)||s.positiveValuesOnly&&!s.validatePositiveValue(P))&&(A.isNull=!0),A.plotX=y=correctFloat$a(k(s.translate(P,0,0,0,1,u,this.type==="flags"))),n&&r.visible&&L&&L[P]&&($=r.getStackIndicator($,P,r.index),A.isNull||(E=L[P],M=E.points[$.key])),isArray$f(M)&&(O=M[0],C=M[1],O===m&&$.key===L[P].base&&(O=pick$1f(isNumber$A(g)&&g,h.min)),h.positiveValuesOnly&&O<=0&&(O=null),A.total=A.stackTotal=E.total,A.percentage=E.total&&A.y/E.total*100,A.stackY=C,r.irregularWidths||E.setOffset(r.pointXOffset||0,r.barW||0)),A.yBottom=defined$G(O)?k(h.translate(O,0,1,0,1)):null,f&&(C=r.modifyValue(C,A)),A.plotY=void 0,isNumber$A(C)){var T=h.translate(C,!1,!0,!1,!0);typeof T<"u"&&(A.plotY=k(T))}A.isInside=this.isPointInside(A),A.clientX=p?correctFloat$a(s.translate(P,0,0,0,1,u)):y,A.negative=A[v]<(t[v+"Threshold"]||g||0),A.category=a&&typeof a[A.x]<"u"?a[A.x]:A.x,!A.isNull&&A.visible!==!1&&(typeof b<"u"&&(S=Math.min(S,Math.abs(y-b))),b=y),A.zone=this.zones.length&&A.getZone(),!A.graphic&&r.group&&l&&(A.isNew=!0)}r.closestPointRangePx=S,fireEvent$r(this,"afterTranslate")},o.prototype.getValidPoints=function(r,t,n){var s=this.chart;return(r||this.points||[]).filter(function(a){return t&&!s.isInsidePlot(a.plotX,a.plotY,{inverted:s.inverted})?!1:a.visible!==!1&&(n||!a.isNull)})},o.prototype.getClipBox=function(r,t){var n=this,s=n.options,a=n.chart,l=a.inverted,h=n.xAxis,d=h&&n.yAxis,c=a.options.chart.scrollablePlotArea||{},f;return r&&s.clip===!1&&d?f=l?{y:-a.chartWidth+d.len+d.pos,height:a.chartWidth,width:a.chartHeight,x:-a.chartHeight+h.len+h.pos}:{y:-d.pos,height:a.chartHeight,width:a.chartWidth,x:-h.pos}:(f=n.clipBox||a.clipBox,t&&(f.width=a.plotSizeX,f.x=(a.scrollablePixelsX||0)*(c.scrollPositionX||0))),t?{width:f.width,x:f.x}:f},o.prototype.getSharedClipKey=function(r){if(this.sharedClipKey)return this.sharedClipKey;var t=[r&&r.duration,r&&r.easing,r&&r.defer,this.getClipBox(r).height,this.options.xAxis,this.options.yAxis].join(",");return(this.options.clip!==!1||r)&&(this.sharedClipKey=t),t},o.prototype.setClip=function(r){var t=this.chart,n=this.options,s=t.renderer,a=t.inverted,l=this.clipBox,h=this.getClipBox(r),d=this.getSharedClipKey(r),c=t.sharedClips[d],f=t.sharedClips[d+"m"];r&&(h.width=0,a&&(h.x=t.plotHeight+(n.clip!==!1?0:t.plotTop))),c?t.hasLoaded||c.attr(h):(r&&(t.sharedClips[d+"m"]=f=s.clipRect(a?(t.plotSizeX||0)+99:-99,a?-t.plotLeft:-t.plotTop,99,a?t.chartWidth:t.chartHeight)),t.sharedClips[d]=c=s.clipRect(h),c.count={length:0}),r&&(c.count[this.index]||(c.count[this.index]=!0,c.count.length+=1)),(n.clip!==!1||r)&&(this.group.clip(r||l?c:t.clipRect),this.markerGroup.clip(f)),r||(c.count[this.index]&&(delete c.count[this.index],c.count.length-=1),c.count.length===0&&(l||(t.sharedClips[d]=c.destroy()),f&&(t.sharedClips[d+"m"]=f.destroy())))},o.prototype.animate=function(r){var t=this,n=t.chart,s=animObject$6(t.options.animation),a=this.sharedClipKey;if(r)t.setClip(s);else if(a){var l=n.sharedClips[a],h=n.sharedClips[a+"m"],d=t.getClipBox(s,!0);l&&l.animate(d,s),h&&h.animate({width:d.width+99,x:d.x-(n.inverted?0:99)},s)}},o.prototype.afterAnimate=function(){this.setClip(),fireEvent$r(this,"afterAnimate"),this.finishedAnimating=!0},o.prototype.drawPoints=function(){var r=this,t=r.points,n=r.chart,s=r.options,a=s.marker,l=r[r.specialGroup]||r.markerGroup,h=r.xAxis,d=pick$1f(a.enabled,!h||h.isRadial?!0:null,r.closestPointRangePx>=a.enabledThreshold*a.radius),c,f,u,p,g,m,v;if(a.enabled!==!1||r._hasPointMarkers)for(c=0;c<t.length;c++){f=t[c],u=f.graphic,p=u?"animate":"attr",g=f.marker||{},m=!!f.marker;var x=(d&&typeof g.enabled>"u"||g.enabled)&&!f.isNull&&f.visible!==!1;if(x){var y=pick$1f(g.symbol,r.symbol,"rect");v=r.markerAttribs(f,f.selected&&"select"),r.enabledDataSorting&&(f.startXPos=h.reversed?-(v.width||0):h.width);var b=f.isInside!==!1;u?u[b?"show":"hide"](b).animate(v):b&&((v.width||0)>0||f.hasImage)&&(f.graphic=u=n.renderer.symbol(y,v.x,v.y,v.width,v.height,m?g:a).add(l),r.enabledDataSorting&&n.hasRendered&&(u.attr({x:f.startXPos}),p="animate")),u&&p==="animate"&&u[b?"show":"hide"](b).animate(v),u&&!n.styledMode&&u[p](r.pointAttribs(f,f.selected&&"select")),u&&u.addClass(f.getClassName(),!0)}else u&&(f.graphic=u.destroy())}},o.prototype.markerAttribs=function(r,t){var n=this.options,s=n.marker,a=r.marker||{},l=a.symbol||s.symbol,h,d,c=pick$1f(a.radius,s.radius);t&&(h=s.states[t],d=a.states&&a.states[t],c=pick$1f(d&&d.radius,h&&h.radius,c+(h&&h.radiusPlus||0))),r.hasImage=l&&l.indexOf("url")===0,r.hasImage&&(c=0);var f={x:n.crisp?Math.floor(r.plotX-c):r.plotX-c,y:r.plotY-c};return c&&(f.width=f.height=2*c),f},o.prototype.pointAttribs=function(r,t){var n=this.options.marker,s=r&&r.options,a=s&&s.marker||{},l=s&&s.color,h=r&&r.color,d=r&&r.zone&&r.zone.color,c,f,u=this.color,p,g,m=pick$1f(a.lineWidth,n.lineWidth),v=1;return u=l||d||h||u,p=a.fillColor||n.fillColor||u,g=a.lineColor||n.lineColor||u,t=t||"normal",t&&(c=n.states[t],f=a.states&&a.states[t]||{},m=pick$1f(f.lineWidth,c.lineWidth,m+pick$1f(f.lineWidthPlus,c.lineWidthPlus,0)),p=f.fillColor||c.fillColor||p,g=f.lineColor||c.lineColor||g,v=pick$1f(f.opacity,c.opacity,v)),{stroke:g,"stroke-width":m,fill:p,opacity:v}},o.prototype.destroy=function(r){var t=this,n=t.chart,s=/AppleWebKit\/533/.test(win$7.navigator.userAgent),a=t.data||[],l,h,d,c;for(fireEvent$r(t,"destroy"),this.removeEvents(r),(t.axisTypes||[]).forEach(function(f){c=t[f],c&&c.series&&(erase$2(c.series,t),c.isDirty=c.forceRedraw=!0)}),t.legendItem&&t.chart.legend.destroyItem(t),h=a.length;h--;)d=a[h],d&&d.destroy&&d.destroy();t.clips&&t.clips.forEach(function(f){return f.destroy()}),Utilities.clearTimeout(t.animationTimeout),objectEach$m(t,function(f,u){f instanceof SVGElement&&!f.survive&&(l=s&&u==="group"?"hide":"destroy",f[l]())}),n.hoverSeries===t&&(n.hoverSeries=void 0),erase$2(n.series,t),n.orderSeries(),objectEach$m(t,function(f,u){(!r||u!=="hcEvents")&&delete t[u]})},o.prototype.applyZones=function(){var r=this,t=this.chart,n=t.renderer,s=this.zones,a=this.clips||[],l=this.graph,h=this.area,d=Math.max(t.chartWidth,t.chartHeight),c=this[(this.zoneAxis||"y")+"Axis"],f=t.inverted,u,p,g,m,v,x,y,b,$,S,k,A=!1;s.length&&(l||h)&&c&&typeof c.min<"u"?(v=c.reversed,x=c.horiz,l&&!this.showLine&&l.hide(),h&&h.hide(),m=c.getExtremes(),s.forEach(function(P,E){u=v?x?t.plotWidth:0:x?0:c.toPixels(m.min)||0,u=clamp$e(pick$1f(p,u),0,d),p=clamp$e(Math.round(c.toPixels(pick$1f(P.value,m.max),!0)||0),0,d),A&&(u=p=c.toPixels(m.max)),y=Math.abs(u-p),b=Math.min(u,p),$=Math.max(u,p),c.isXAxis?(g={x:f?$:b,y:0,width:y,height:d},x||(g.x=t.plotHeight-g.x)):(g={x:0,y:f?$:b,width:d,height:y},x&&(g.y=t.plotWidth-g.y)),f&&n.isVML&&(c.isXAxis?g={x:0,y:v?b:$,height:g.width,width:t.chartWidth}:g={x:g.y-t.plotLeft-t.spacingBox.x,y:0,width:g.height,height:t.chartHeight}),a[E]?a[E].animate(g):a[E]=n.clipRect(g),S=r["zone-area-"+E],k=r["zone-graph-"+E],l&&k&&k.clip(a[E]),h&&S&&S.clip(a[E]),A=P.value>m.max,r.resetZones&&p===0&&(p=void 0)}),this.clips=a):r.visible&&(l&&l.show(!0),h&&h.show(!0))},o.prototype.invertGroups=function(r){var t=this,n=t.chart;function s(){["group","markerGroup"].forEach(function(a){t[a]&&(n.renderer.isVML&&t[a].attr({width:t.yAxis.len,height:t.xAxis.len}),t[a].width=t.yAxis.len,t[a].height=t.xAxis.len,t[a].invert(t.isRadialSeries?!1:r))})}t.xAxis&&(t.eventsToUnbind.push(addEvent$S(n,"resize",s)),s(),t.invertGroups=s)},o.prototype.plotGroup=function(r,t,n,s,a){var l=this[r],h=!l,d={visibility:n,zIndex:s||.1};return typeof this.opacity<"u"&&!this.chart.styledMode&&this.state!=="inactive"&&(d.opacity=this.opacity),h&&(this[r]=l=this.chart.renderer.g().add(a)),l.addClass("highcharts-"+t+" highcharts-series-"+this.index+" highcharts-"+this.type+"-series "+(defined$G(this.colorIndex)?"highcharts-color-"+this.colorIndex+" ":"")+(this.options.className||"")+(l.hasClass("highcharts-tracker")?" highcharts-tracker":""),!0),l.attr(d)[h?"attr":"animate"](this.getPlotBox()),l},o.prototype.getPlotBox=function(){var r=this.chart,t=this.xAxis,n=this.yAxis;return r.inverted&&(t=n,n=this.xAxis),{translateX:t?t.left:r.plotLeft,translateY:n?n.top:r.plotTop,scaleX:1,scaleY:1}},o.prototype.removeEvents=function(r){var t=this;r||removeEvent$5(t),t.eventsToUnbind.length&&(t.eventsToUnbind.forEach(function(n){n()}),t.eventsToUnbind.length=0)},o.prototype.render=function(){var r=this,t=r.chart,n=r.options,s=animObject$6(n.animation),a=r.visible?"inherit":"hidden",l=n.zIndex,h=r.hasRendered,d=t.seriesGroup,c=t.inverted,f=!r.finishedAnimating&&t.renderer.isSVG&&s.duration;fireEvent$r(this,"render");var u=r.plotGroup("group","series",a,l,d);r.markerGroup=r.plotGroup("markerGroup","markers",a,l,d),f&&r.animate&&r.animate(!0),u.inverted=pick$1f(r.invertible,r.isCartesian)?c:!1,r.drawGraph&&(r.drawGraph(),r.applyZones()),r.visible&&r.drawPoints(),r.drawDataLabels&&r.drawDataLabels(),r.redrawPoints&&r.redrawPoints(),r.drawTracker&&r.options.enableMouseTracking!==!1&&r.drawTracker(),r.invertGroups(c),n.clip!==!1&&!r.sharedClipKey&&!h&&u.clip(t.clipRect),f&&r.animate&&r.animate(),h||(f&&s.defer&&(f+=s.defer),r.animationTimeout=syncTimeout$2(function(){r.afterAnimate()},f||0)),r.isDirty=!1,r.hasRendered=!0,fireEvent$r(r,"afterRender")},o.prototype.redraw=function(){var r=this,t=r.chart,n=r.isDirty||r.isDirtyData,s=r.group,a=r.xAxis,l=r.yAxis;s&&(t.inverted&&s.attr({width:t.plotWidth,height:t.plotHeight}),s.animate({translateX:pick$1f(a&&a.left,t.plotLeft),translateY:pick$1f(l&&l.top,t.plotTop)})),r.translate(),r.render(),n&&delete this.kdTree},o.prototype.searchPoint=function(r,t){var n=this,s=n.xAxis,a=n.yAxis,l=n.chart.inverted;return this.searchKDTree({clientX:l?s.len-r.chartY+s.pos:r.chartX-s.pos,plotY:l?a.len-r.chartX+a.pos:r.chartY-a.pos},t,r)},o.prototype.buildKDTree=function(r){this.buildingKdTree=!0;var t=this,n=t.options.findNearestPointBy.indexOf("y")>-1?2:1;function s(l,h,d){var c=l&&l.length,f,u;if(c)return f=t.kdAxisArray[h%d],l.sort(function(p,g){return p[f]-g[f]}),u=Math.floor(c/2),{point:l[u],left:s(l.slice(0,u),h+1,d),right:s(l.slice(u+1),h+1,d)}}function a(){t.kdTree=s(t.getValidPoints(null,!t.directTouch),n,n),t.buildingKdTree=!1}delete t.kdTree,syncTimeout$2(a,t.options.kdNow||r&&r.type==="touchstart"?0:1)},o.prototype.searchKDTree=function(r,t,n){var s=this,a=this.kdAxisArray[0],l=this.kdAxisArray[1],h=t?"distX":"dist",d=s.options.findNearestPointBy.indexOf("y")>-1?2:1;function c(u,p){var g=defined$G(u[a])&&defined$G(p[a])?Math.pow(u[a]-p[a],2):null,m=defined$G(u[l])&&defined$G(p[l])?Math.pow(u[l]-p[l],2):null,v=(g||0)+(m||0);p.dist=defined$G(v)?Math.sqrt(v):Number.MAX_VALUE,p.distX=defined$G(g)?Math.sqrt(g):Number.MAX_VALUE}function f(u,p,g,m){var v=p.point,x=s.kdAxisArray[g%m],y,b,$=v;c(u,v);var S=u[x]-v[x],k=S<0?"left":"right",A=S<0?"right":"left";return p[k]&&(y=f(u,p[k],g+1,m),$=y[h]<$[h]?y:v),p[A]&&Math.sqrt(S*S)<$[h]&&(b=f(u,p[A],g+1,m),$=b[h]<$[h]?b:$),$}if(!this.kdTree&&!this.buildingKdTree&&this.buildKDTree(n),this.kdTree)return f(r,this.kdTree,d,d)},o.prototype.pointPlacementToXValue=function(){var r=this,t=r.options,n=t.pointPlacement,s=t.pointRange,a=r.xAxis,l=n;return l==="between"&&(l=a.reversed?-.5:.5),isNumber$A(l)?l*(s||a.pointRange):0},o.prototype.isPointInside=function(r){var t=typeof r.plotY<"u"&&typeof r.plotX<"u"&&r.plotY>=0&&r.plotY<=this.yAxis.len&&r.plotX>=0&&r.plotX<=this.xAxis.len;return t},o.prototype.drawTracker=function(){var r=this,t=r.options,n=t.trackByArea,s=[].concat(n?r.areaPath:r.graphPath),a=r.chart,l=a.pointer,h=a.renderer,d=a.options.tooltip.snap,c=r.tracker,f=function(p){a.hoverSeries!==r&&r.onMouseOver()},u="rgba(192,192,192,"+(svg$2?1e-4:.002)+")";c?c.attr({d:s}):r.graph&&(r.tracker=h.path(s).attr({visibility:r.visible?"visible":"hidden",zIndex:2}).addClass(n?"highcharts-tracker-area":"highcharts-tracker-line").add(r.group),a.styledMode||r.tracker.attr({"stroke-linecap":"round","stroke-linejoin":"round",stroke:u,fill:n?u:"none","stroke-width":r.graph.strokeWidth()+(n?0:2*d)}),[r.tracker,r.markerGroup,r.dataLabelsGroup].forEach(function(p){p&&(p.addClass("highcharts-tracker").on("mouseover",f).on("mouseout",function(g){l.onTrackerMouseOut(g)}),t.cursor&&!a.styledMode&&p.css({cursor:t.cursor}),hasTouch$2&&p.on("touchstart",f))})),fireEvent$r(this,"afterDrawTracker")},o.prototype.addPoint=function(r,t,n,s,a){var l=this,h=l.options,d=l.data,c=l.chart,f=l.xAxis,u=f&&f.hasNames&&f.names,p=h.data,g=l.xData,m,v;t=pick$1f(t,!0);var x={series:l};l.pointClass.prototype.applyOptions.apply(x,[r]);var y=x.x;if(v=g.length,l.requireSorting&&y<g[v-1])for(m=!0;v&&g[v-1]>y;)v--;l.updateParallelArrays(x,"splice",v,0,0),l.updateParallelArrays(x,v),u&&x.name&&(u[y]=x.name),p.splice(v,0,r),m&&(l.data.splice(v,0,null),l.processData()),h.legendType==="point"&&l.generatePoints(),n&&(d[0]&&d[0].remove?d[0].remove(!1):(d.shift(),l.updateParallelArrays(x,"shift"),p.shift())),a!==!1&&fireEvent$r(l,"addPoint",{point:x}),l.isDirty=!0,l.isDirtyData=!0,t&&c.redraw(s)},o.prototype.removePoint=function(r,t,n){var s=this,a=s.data,l=a[r],h=s.points,d=s.chart,c=function(){h&&h.length===a.length&&h.splice(r,1),a.splice(r,1),s.options.data.splice(r,1),s.updateParallelArrays(l||{series:s},"splice",r,1),l&&l.destroy(),s.isDirty=!0,s.isDirtyData=!0,t&&d.redraw()};setAnimation$2(n,d),t=pick$1f(t,!0),l?l.firePointEvent("remove",null,c):c()},o.prototype.remove=function(r,t,n,s){var a=this,l=a.chart;function h(){a.destroy(s),l.isDirtyLegend=l.isDirtyBox=!0,l.linkSeries(),pick$1f(r,!0)&&l.redraw(t)}n!==!1?fireEvent$r(a,"remove",null,h):h()},o.prototype.update=function(r,t){r=cleanRecursively(r,this.userOptions),fireEvent$r(this,"update",{options:r});var n=this,s=n.chart,a=n.userOptions,l=n.initialType||n.type,h=s.options.plotOptions,d=seriesTypes$6[l].prototype,c=["group","markerGroup","dataLabelsGroup","transformGroup"],f=n.finishedAnimating&&{animation:!1},u={},p,g,m=["eventOptions","navigatorSeries","baseSeries"],v=r.type||a.type||s.options.chart.type,x=!(this.hasDerivedData||v&&v!==this.type||typeof r.pointStart<"u"||typeof r.pointInterval<"u"||typeof r.relativeXValue<"u"||n.hasOptionChanged("dataGrouping")||n.hasOptionChanged("pointStart")||n.hasOptionChanged("pointInterval")||n.hasOptionChanged("pointIntervalUnit")||n.hasOptionChanged("keys"));v=v||l,x&&(m.push("data","isDirtyData","points","processedXData","processedYData","xIncrement","cropped","_hasPointMarkers","_hasPointLabels","clips","nodes","layout","mapMap","mapData","minY","maxY","minX","maxX"),r.visible!==!1&&m.push("area","graph"),n.parallelArrays.forEach(function(k){m.push(k+"Data")}),r.data&&(r.dataSorting&&extend$1c(n.options.dataSorting,r.dataSorting),this.setData(r.data,!1))),r=merge$18(a,f,{index:typeof a.index>"u"?n.index:a.index,pointStart:pick$1f(h&&h.series&&h.series.pointStart,a.pointStart,n.xData[0])},!x&&{data:n.options.data},r),x&&r.data&&(r.data=n.options.data),m=c.concat(m),m.forEach(function(k){m[k]=n[k],delete n[k]});var y=!1;if(seriesTypes$6[v]){if(y=v!==n.type,n.remove(!1,!1,!1,!0),y)if(Object.setPrototypeOf)Object.setPrototypeOf(n,seriesTypes$6[v].prototype);else{var b=Object.hasOwnProperty.call(n,"hcEvents")&&n.hcEvents;for(g in d)n[g]=void 0;extend$1c(n,seriesTypes$6[v].prototype),b?n.hcEvents=b:delete n.hcEvents}}else error$4(17,!0,s,{missingModuleFor:v});if(m.forEach(function(k){n[k]=m[k]}),n.init(s,r),x&&this.points){if(p=n.options,p.visible===!1)u.graphic=1,u.dataLabel=1;else if(!n._hasPointLabels){var $=p.marker,S=p.dataLabels;$&&($.enabled===!1||(a.marker&&a.marker.symbol)!==$.symbol)&&(u.graphic=1),S&&S.enabled===!1&&(u.dataLabel=1)}this.points.forEach(function(k){k&&k.series&&(k.resolveColor(),Object.keys(u).length&&k.destroyElements(u),p.showInLegend===!1&&k.legendItem&&s.legend.destroyItem(k))},this)}n.initialType=l,s.linkSeries(),y&&n.linkedSeries.length&&(n.isDirtyData=!0),fireEvent$r(this,"afterUpdate"),pick$1f(t,!0)&&s.redraw(x?void 0:!1)},o.prototype.setName=function(r){this.name=this.options.name=this.userOptions.name=r,this.chart.isDirtyLegend=!0},o.prototype.hasOptionChanged=function(r){var t=this.chart,n=this.options[r],s=t.options.plotOptions,a=this.userOptions[r];return a?n!==a:n!==pick$1f(s&&s[this.type]&&s[this.type][r],s&&s.series&&s.series[r],n)},o.prototype.onMouseOver=function(){var r=this,t=r.chart,n=t.hoverSeries,s=t.pointer;s.setHoverChartIndex(),n&&n!==r&&n.onMouseOut(),r.options.events.mouseOver&&fireEvent$r(r,"mouseOver"),r.setState("hover"),t.hoverSeries=r},o.prototype.onMouseOut=function(){var r=this,t=r.options,n=r.chart,s=n.tooltip,a=n.hoverPoint;n.hoverSeries=null,a&&a.onMouseOut(),r&&t.events.mouseOut&&fireEvent$r(r,"mouseOut"),s&&!r.stickyTracking&&(!s.shared||r.noSharedTooltip)&&s.hide(),n.series.forEach(function(l){l.setState("",!0)})},o.prototype.setState=function(r,t){var n=this,s=n.options,a=n.graph,l=s.inactiveOtherPoints,h=s.states,d=pick$1f(h[r||"normal"]&&h[r||"normal"].animation,n.chart.options.chart.animation),c,f=s.lineWidth,u=0,p=s.opacity;if(r=r||"",n.state!==r&&([n.group,n.markerGroup,n.dataLabelsGroup].forEach(function(g){g&&(n.state&&g.removeClass("highcharts-series-"+n.state),r&&g.addClass("highcharts-series-"+r))}),n.state=r,!n.chart.styledMode)){if(h[r]&&h[r].enabled===!1)return;if(r&&(f=h[r].lineWidth||f+(h[r].lineWidthPlus||0),p=pick$1f(h[r].opacity,p)),a&&!a.dashstyle)for(c={"stroke-width":f},a.animate(c,d);n["zone-graph-"+u];)n["zone-graph-"+u].animate(c,d),u=u+1;l||[n.group,n.markerGroup,n.dataLabelsGroup,n.labelBySeries].forEach(function(g){g&&g.animate({opacity:p},d)})}t&&l&&n.points&&n.setAllPointsToState(r||void 0)},o.prototype.setAllPointsToState=function(r){this.points.forEach(function(t){t.setState&&t.setState(r)})},o.prototype.setVisible=function(r,t){var n=this,s=n.chart,a=n.legendItem,l=s.options.chart.ignoreHiddenSeries,h=n.visible;n.visible=r=n.options.visible=n.userOptions.visible=typeof r>"u"?!h:r;var d=r?"show":"hide";["group","dataLabelsGroup","markerGroup","tracker","tt"].forEach(function(c){n[c]&&n[c][d]()}),(s.hoverSeries===n||(s.hoverPoint&&s.hoverPoint.series)===n)&&n.onMouseOut(),a&&s.legend.colorizeItem(n,r),n.isDirty=!0,n.options.stacking&&s.series.forEach(function(c){c.options.stacking&&c.visible&&(c.isDirty=!0)}),n.linkedSeries.forEach(function(c){c.setVisible(r,!1)}),l&&(s.isDirtyBox=!0),fireEvent$r(n,d),t!==!1&&s.redraw()},o.prototype.show=function(){this.setVisible(!0)},o.prototype.hide=function(){this.setVisible(!1)},o.prototype.select=function(r){var t=this;t.selected=r=this.options.selected=typeof r>"u"?!t.selected:r,t.checkbox&&(t.checkbox.checked=r),fireEvent$r(t,r?"select":"unselect")},o.prototype.shouldShowTooltip=function(r,t,n){return n===void 0&&(n={}),n.series=this,n.visiblePlotOnly=!0,this.chart.isInsidePlot(r,t,n)},o.defaultOptions=seriesDefaults,o}();extend$1c(Series$e.prototype,{axisTypes:["xAxis","yAxis"],coll:"series",colorCounter:0,cropShoulder:1,directTouch:!1,drawLegendSymbol:LegendSymbol$1.drawLineMarker,isCartesian:!0,kdAxisArray:["clientX","plotY"],parallelArrays:["x","y"],pointClass:Point$2,requireSorting:!0,sorted:!0});SeriesRegistry$1.series=Series$e;var stop=animationExports.stop,addEvent$R=Utilities.addEvent,createElement$4=Utilities.createElement,merge$17=Utilities.merge,pick$1e=Utilities.pick;addEvent$R(Chart$1,"afterSetChartSize",function(o){var r=this.options.chart.scrollablePlotArea,t=r&&r.minWidth,n=r&&r.minHeight,s,a,l;this.renderer.forExport||(t?(this.scrollablePixelsX=s=Math.max(0,t-this.chartWidth),s&&(this.scrollablePlotBox=this.renderer.scrollablePlotBox=merge$17(this.plotBox),this.plotBox.width=this.plotWidth+=s,this.inverted?this.clipBox.height+=s:this.clipBox.width+=s,l={1:{name:"right",value:s}})):n&&(this.scrollablePixelsY=a=Math.max(0,n-this.chartHeight),a&&(this.scrollablePlotBox=this.renderer.scrollablePlotBox=merge$17(this.plotBox),this.plotBox.height=this.plotHeight+=a,this.inverted?this.clipBox.width+=a:this.clipBox.height+=a,l={2:{name:"bottom",value:a}})),l&&!o.skipAxes&&this.axes.forEach(function(h){l[h.side]?h.getPlotLinePath=function(){var d=l[h.side].name,c=l[h.side].value,f=this[d],u;return this[d]=f-c,u=Axis.prototype.getPlotLinePath.apply(this,arguments),this[d]=f,u}:(h.setAxisSize(),h.setAxisTranslation())}))});addEvent$R(Chart$1,"render",function(){this.scrollablePixelsX||this.scrollablePixelsY?(this.setUpScrolling&&this.setUpScrolling(),this.applyFixed()):this.fixedDiv&&this.applyFixed()});Chart$1.prototype.setUpScrolling=function(){var o=this,r={WebkitOverflowScrolling:"touch",overflowX:"hidden",overflowY:"hidden"};this.scrollablePixelsX&&(r.overflowX="auto"),this.scrollablePixelsY&&(r.overflowY="auto"),this.scrollingParent=createElement$4("div",{className:"highcharts-scrolling-parent"},{position:"relative"},this.renderTo),this.scrollingContainer=createElement$4("div",{className:"highcharts-scrolling"},r,this.scrollingParent),addEvent$R(this.scrollingContainer,"scroll",function(){o.pointer&&delete o.pointer.chartPosition}),this.innerContainer=createElement$4("div",{className:"highcharts-inner-container"},null,this.scrollingContainer),this.innerContainer.appendChild(this.container),this.setUpScrolling=null};Chart$1.prototype.moveFixedElements=function(){var o=this.container,r=this.fixedRenderer,t=[".highcharts-contextbutton",".highcharts-credits",".highcharts-legend",".highcharts-legend-checkbox",".highcharts-navigator-series",".highcharts-navigator-xaxis",".highcharts-navigator-yaxis",".highcharts-navigator",".highcharts-reset-zoom",".highcharts-drillup-button",".highcharts-scrollbar",".highcharts-subtitle",".highcharts-title"],n;this.scrollablePixelsX&&!this.inverted?n=".highcharts-yaxis":this.scrollablePixelsX&&this.inverted||this.scrollablePixelsY&&!this.inverted?n=".highcharts-xaxis":this.scrollablePixelsY&&this.inverted&&(n=".highcharts-yaxis"),n&&t.push(n+":not(.highcharts-radial-axis)",n+"-labels:not(.highcharts-radial-axis-labels)"),t.forEach(function(s){[].forEach.call(o.querySelectorAll(s),function(a){(a.namespaceURI===r.SVG_NS?r.box:r.box.parentNode).appendChild(a),a.style.pointerEvents="auto"})})};Chart$1.prototype.applyFixed=function(){var o=!this.fixedDiv,r=this.options.chart,t=r.scrollablePlotArea,n=RendererRegistry$1.getRendererType(),s,a,l;o?(this.fixedDiv=createElement$4("div",{className:"highcharts-fixed"},{position:"absolute",overflow:"hidden",pointerEvents:"none",zIndex:(r.style&&r.style.zIndex||0)+2,top:0},null,!0),this.scrollingContainer&&this.scrollingContainer.parentNode.insertBefore(this.fixedDiv,this.scrollingContainer),this.renderTo.style.overflow="visible",this.fixedRenderer=s=new n(this.fixedDiv,this.chartWidth,this.chartHeight,this.options.chart.style),this.scrollableMask=s.path().attr({fill:this.options.chart.backgroundColor||"#fff","fill-opacity":pick$1e(t.opacity,.85),zIndex:-1}).addClass("highcharts-scrollable-mask").add(),addEvent$R(this,"afterShowResetZoom",this.moveFixedElements),addEvent$R(this,"afterDrilldown",this.moveFixedElements),addEvent$R(this,"afterLayOutTitles",this.moveFixedElements)):this.fixedRenderer.setSize(this.chartWidth,this.chartHeight),(this.scrollableDirty||o)&&(this.scrollableDirty=!1,this.moveFixedElements()),a=this.chartWidth+(this.scrollablePixelsX||0),l=this.chartHeight+(this.scrollablePixelsY||0),stop(this.container),this.container.style.width=a+"px",this.container.style.height=l+"px",this.renderer.boxWrapper.attr({width:a,height:l,viewBox:[0,0,a,l].join(" ")}),this.chartBackground.attr({width:a,height:l}),this.scrollingContainer.style.height=this.chartHeight+"px",o&&(t.scrollPositionX&&(this.scrollingContainer.scrollLeft=this.scrollablePixelsX*t.scrollPositionX),t.scrollPositionY&&(this.scrollingContainer.scrollTop=this.scrollablePixelsY*t.scrollPositionY));var h=this.axisOffset,d=this.plotTop-h[0]-1,c=this.plotLeft-h[3]-1,f=this.plotTop+this.plotHeight+h[2]+1,u=this.plotLeft+this.plotWidth+h[1]+1,p=this.plotLeft+this.plotWidth-(this.scrollablePixelsX||0),g=this.plotTop+this.plotHeight-(this.scrollablePixelsY||0),m;this.scrollablePixelsX?m=[["M",0,d],["L",this.plotLeft-1,d],["L",this.plotLeft-1,f],["L",0,f],["Z"],["M",p,d],["L",this.chartWidth,d],["L",this.chartWidth,f],["L",p,f],["Z"]]:this.scrollablePixelsY?m=[["M",c,0],["L",c,this.plotTop-1],["L",u,this.plotTop-1],["L",u,0],["Z"],["M",c,g],["L",c,this.chartHeight],["L",u,this.chartHeight],["L",u,g],["Z"]]:m=[["M",0,0]],this.redrawTrigger!=="adjustHeight"&&this.scrollableMask.attr({d:m})};addEvent$R(Axis,"afterInit",function(){this.chart.scrollableDirty=!0});addEvent$R(Series$e,"show",function(){this.chart.scrollableDirty=!0});var getDeferredAnimation$2=animationExports.getDeferredAnimation,addEvent$Q=Utilities.addEvent,destroyObjectProperties$5=Utilities.destroyObjectProperties,fireEvent$q=Utilities.fireEvent,isNumber$z=Utilities.isNumber,objectEach$l=Utilities.objectEach,StackingAxis;(function(o){var r=[];function t(l){return r.indexOf(l)===-1&&(r.push(l),addEvent$Q(l,"init",s),addEvent$Q(l,"destroy",n)),l}o.compose=t;function n(){var l=this.stacking;if(l){var h=l.stacks;objectEach$l(h,function(d,c){destroyObjectProperties$5(d),h[c]=null}),l&&l.stackTotalGroup&&l.stackTotalGroup.destroy()}}function s(){var l=this;l.stacking||(l.stacking=new a(l))}var a=function(){function l(h){this.oldStacks={},this.stacks={},this.stacksTouched=0,this.axis=h}return l.prototype.buildStacks=function(){var h=this,d=h.axis,c=d.series,f=d.options.reversedStacks,u=c.length,p,g;if(!d.isXAxis){for(h.usePercentage=!1,g=u;g--;)p=c[f?g:u-g-1],p.setStackedPoints(),p.setGroupedPoints();for(g=0;g<u;g++)c[g].modifyStacks();fireEvent$q(d,"afterBuildStacks")}},l.prototype.cleanStacks=function(){var h=this,d=h.axis,c;d.isXAxis||(h.oldStacks&&(c=h.stacks=h.oldStacks),objectEach$l(c,function(f){objectEach$l(f,function(u){u.cumulative=u.total})}))},l.prototype.resetStacks=function(){var h=this,d=h.axis,c=h.stacks;d.isXAxis||objectEach$l(c,function(f){objectEach$l(f,function(u,p){isNumber$z(u.touched)&&u.touched<h.stacksTouched?(u.destroy(),delete f[p]):(u.total=null,u.cumulative=null)})})},l.prototype.renderStackTotals=function(){var h=this,d=h.axis,c=d.chart,f=c.renderer,u=h.stacks,p=d.options.stackLabels&&d.options.stackLabels.animation,g=getDeferredAnimation$2(c,p||!1),m=h.stackTotalGroup=h.stackTotalGroup||f.g("stack-labels").attr({visibility:"visible",zIndex:6,opacity:0}).add();m.translate(c.plotLeft,c.plotTop),objectEach$l(u,function(v){objectEach$l(v,function(x){x.render(m)})}),m.animate({opacity:1},g)},l}();o.Additions=a})(StackingAxis||(StackingAxis={}));const StackingAxis$1=StackingAxis;var format$9=FormatUtilities.format,correctFloat$9=Utilities.correctFloat,defined$F=Utilities.defined,destroyObjectProperties$4=Utilities.destroyObjectProperties,isArray$e=Utilities.isArray,isNumber$y=Utilities.isNumber,objectEach$k=Utilities.objectEach,pick$1d=Utilities.pick,StackItem=function(){function o(r,t,n,s,a){var l=r.chart.inverted;this.axis=r,this.isNegative=n,this.options=t=t||{},this.x=s,this.total=null,this.points={},this.hasValidPoints=!1,this.stack=a,this.leftCliff=0,this.rightCliff=0,this.alignOptions={align:t.align||(l?n?"left":"right":"center"),verticalAlign:t.verticalAlign||(l?"middle":n?"bottom":"top"),y:t.y,x:t.x},this.textAlign=t.textAlign||(l?n?"right":"left":"center")}return o.prototype.destroy=function(){destroyObjectProperties$4(this,this.axis)},o.prototype.render=function(r){var t=this.axis.chart,n=this.options,s=n.format,a={},l=s?format$9(s,this,t):n.formatter.call(this);this.label?this.label.attr({text:l,visibility:"hidden"}):(this.label=t.renderer.label(l,null,null,n.shape,null,null,n.useHTML,!1,"stack-labels"),a={r:n.borderRadius||0,text:l,rotation:n.rotation,padding:pick$1d(n.padding,5),visibility:"hidden"},t.styledMode||(a.fill=n.backgroundColor,a.stroke=n.borderColor,a["stroke-width"]=n.borderWidth,this.label.css(n.style)),this.label.attr(a),this.label.added||this.label.add(r)),this.label.labelrank=t.plotSizeY},o.prototype.setOffset=function(r,t,n,s,a){var l=this,h=l.axis,d=h.chart,c=h.translate(h.stacking.usePercentage?100:s||l.total,0,0,0,1),f=h.translate(n||0),u=defined$F(c)&&Math.abs(c-f),p=pick$1d(a,d.xAxis[0].translate(l.x))+r,g=defined$F(c)&&l.getStackBox(d,l,p,c,t,u,h),m=l.label,v=l.isNegative,x=pick$1d(l.options.overflow,"justify")==="justify",y=l.textAlign,b;if(m&&g){var $=m.getBBox(),S=m.padding,k=void 0,A=void 0;y==="left"?k=d.inverted?-S:S:y==="right"?k=$.width:d.inverted&&y==="center"?k=$.width/2:k=d.inverted?v?$.width+S:-S:$.width/2,A=d.inverted?$.height/2:v?-S:$.height,l.alignOptions.x=pick$1d(l.options.x,0),l.alignOptions.y=pick$1d(l.options.y,0),g.x-=k,g.y-=A,m.align(l.alignOptions,null,g),d.isInsidePlot(m.alignAttr.x+k-l.alignOptions.x,m.alignAttr.y+A-l.alignOptions.y)?m.show():(m.alignAttr.y=-9999,x=!1),x&&Series$e.prototype.justifyDataLabel.call(this.axis,m,l.alignOptions,m.alignAttr,$,g),m.attr({x:m.alignAttr.x,y:m.alignAttr.y}),pick$1d(!x&&l.options.crop,!0)&&(b=isNumber$y(m.x)&&isNumber$y(m.y)&&d.isInsidePlot(m.x-S+m.width,m.y)&&d.isInsidePlot(m.x+S,m.y),b||m.hide())}},o.prototype.getStackBox=function(r,t,n,s,a,l,h){var d=t.axis.reversed,c=r.inverted,f=h.height+h.pos-(c?r.plotLeft:r.plotTop),u=t.isNegative&&!d||!t.isNegative&&d;return{x:c?u?s-h.right:s-l+h.pos-r.plotLeft:n+r.xAxis[0].transB-r.plotLeft,y:c?h.height-n-a:u?f-s-l:f-s,width:c?l:a,height:c?a:l}},o}();Chart$1.prototype.getStacks=function(){var o=this,r=o.inverted;o.yAxis.forEach(function(t){t.stacking&&t.stacking.stacks&&t.hasVisibleSeries&&(t.stacking.oldStacks=t.stacking.stacks)}),o.series.forEach(function(t){var n=t.xAxis&&t.xAxis.options||{};t.options.stacking&&(t.visible===!0||o.options.chart.ignoreHiddenSeries===!1)&&(t.stackKey=[t.type,pick$1d(t.options.stack,""),r?n.top:n.left,r?n.height:n.width].join(","))})};StackingAxis$1.compose(Axis);Series$e.prototype.setGroupedPoints=function(){var o=this.yAxis.stacking;this.options.centerInCategory&&(this.is("column")||this.is("columnrange"))&&!this.options.stacking&&this.chart.series.length>1?Series$e.prototype.setStackedPoints.call(this,"group"):o&&objectEach$k(o.stacks,function(r,t){t.slice(-5)==="group"&&(objectEach$k(r,function(n){return n.destroy()}),delete o.stacks[t])})};Series$e.prototype.setStackedPoints=function(o){var r=o||this.options.stacking;if(!(!r||this.visible!==!0&&this.chart.options.chart.ignoreHiddenSeries!==!1)){var t=this,n=t.processedXData,s=t.processedYData,a=[],l=s.length,h=t.options,d=h.threshold,c=pick$1d(h.startFromThreshold&&d,0),f=h.stack,u=o?t.type+","+r:t.stackKey,p="-"+u,g=t.negStacks,m=t.yAxis,v=m.stacking.stacks,x=m.stacking.oldStacks,y,b,$,S,k,A,P,E,M;for(m.stacking.stacksTouched+=1,P=0;P<l;P++)E=n[P],M=s[P],y=t.getStackIndicator(y,E,t.index),A=y.key,b=g&&M<(c?0:d),k=b?p:u,v[k]||(v[k]={}),v[k][E]||(x[k]&&x[k][E]?(v[k][E]=x[k][E],v[k][E].total=null):v[k][E]=new StackItem(m,m.options.stackLabels,b,E,f)),$=v[k][E],M!==null?($.points[A]=$.points[t.index]=[pick$1d($.cumulative,c)],defined$F($.cumulative)||($.base=A),$.touched=m.stacking.stacksTouched,y.index>0&&t.singleStacks===!1&&($.points[A][0]=$.points[t.index+","+E+",0"][0])):$.points[A]=$.points[t.index]=null,r==="percent"?(S=b?u:p,g&&v[S]&&v[S][E]?(S=v[S][E],$.total=S.total=Math.max(S.total,$.total)+Math.abs(M)||0):$.total=correctFloat$9($.total+(Math.abs(M)||0))):r==="group"?(isArray$e(M)&&(M=M[0]),M!==null&&($.total=($.total||0)+1)):$.total=correctFloat$9($.total+(M||0)),r==="group"?$.cumulative=($.total||1)-1:$.cumulative=pick$1d($.cumulative,c)+(M||0),M!==null&&($.points[A].push($.cumulative),a[P]=$.cumulative,$.hasValidPoints=!0);r==="percent"&&(m.stacking.usePercentage=!0),r!=="group"&&(this.stackedYData=a),m.stacking.oldStacks={}}};Series$e.prototype.modifyStacks=function(){var o=this,r=o.yAxis,t=o.stackKey,n=r.stacking.stacks,s=o.processedXData,a,l=o.options.stacking;o[l+"Stacker"]&&[t,"-"+t].forEach(function(h){for(var d=s.length,c,f,u;d--;)c=s[d],a=o.getStackIndicator(a,c,o.index,h),f=n[h]&&n[h][c],u=f&&f.points[a.key],u&&o[l+"Stacker"](u,f,d)})};Series$e.prototype.percentStacker=function(o,r,t){var n=r.total?100/r.total:0;o[0]=correctFloat$9(o[0]*n),o[1]=correctFloat$9(o[1]*n),this.stackedYData[t]=o[1]};Series$e.prototype.getStackIndicator=function(o,r,t,n){return!defined$F(o)||o.x!==r||n&&o.key!==n?o={x:r,index:0,key:n}:o.index++,o.key=[t,r,o.index].join(","),o};H.StackItem=StackItem;const StackItem$1=H.StackItem;var __extends$U=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),defined$E=Utilities.defined,merge$16=Utilities.merge,LineSeries$5=function(o){__extends$U(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.drawGraph=function(){var t=this,n=this.options,s=(this.gappedPath||this.getGraphPath).call(this),a=this.chart.styledMode,l=[["graph","highcharts-graph"]];a||l[0].push(n.lineColor||this.color||palette.neutralColor20,n.dashStyle),l=t.getZonesGraphs(l),l.forEach(function(h,d){var c=h[0],f,u=t[c],p=u?"animate":"attr";u?(u.endX=t.preventGraphAnimation?null:s.xMap,u.animate({d:s})):s.length&&(t[c]=u=t.chart.renderer.path(s).addClass(h[1]).attr({zIndex:1}).add(t.group)),u&&!a&&(f={stroke:h[2],"stroke-width":n.lineWidth,fill:t.fillGraph&&t.color||"none"},h[3]?f.dashstyle=h[3]:n.linecap!=="square"&&(f["stroke-linecap"]=f["stroke-linejoin"]="round"),u[p](f).shadow(d<2&&n.shadow)),u&&(u.startX=s.xMap,u.isArea=s.isArea)})},r.prototype.getGraphPath=function(t,n,s){var a=this,l=a.options,h=[],d=[],c,f=l.step;t=t||a.points;var u=t.reversed;return u&&t.reverse(),f={right:1,center:2}[f]||f&&3,f&&u&&(f=4-f),t=this.getValidPoints(t,!1,!(l.connectNulls&&!n&&!s)),t.forEach(function(p,g){var m=p.plotX,v=p.plotY,x=t[g-1],y;(p.leftCliff||x&&x.rightCliff)&&!s&&(c=!0),p.isNull&&!defined$E(n)&&g>0?c=!l.connectNulls:p.isNull&&!n?c=!0:(g===0||c?y=[["M",p.plotX,p.plotY]]:a.getPointSpline?y=[a.getPointSpline(t,p,g)]:f?(f===1?y=[["L",x.plotX,v]]:f===2?y=[["L",(x.plotX+m)/2,x.plotY],["L",(x.plotX+m)/2,v]]:y=[["L",m,x.plotY]],y.push(["L",m,v])):y=[["L",m,v]],d.push(p.x),f&&(d.push(p.x),f===2&&d.push(p.x)),h.push.apply(h,y),c=!1)}),h.xMap=d,a.graphPath=h,h},r.prototype.getZonesGraphs=function(t){return this.zones.forEach(function(n,s){var a=["zone-graph-"+s,"highcharts-graph highcharts-zone-graph-"+s+" "+(n.className||"")];this.chart.styledMode||a.push(n.color||this.color,n.dashStyle||this.options.dashStyle),t.push(a)},this),t},r.defaultOptions=merge$16(Series$e.defaultOptions,{}),r}(Series$e);SeriesRegistry$1.registerSeriesType("line",LineSeries$5);var __extends$T=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),color$d=Color.parse,LineSeries$4=SeriesRegistry$1.seriesTypes.line,extend$1b=Utilities.extend,merge$15=Utilities.merge,objectEach$j=Utilities.objectEach,pick$1c=Utilities.pick,AreaSeries$1=function(o){__extends$T(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.drawGraph=function(){this.areaPath=[],o.prototype.drawGraph.apply(this);var t=this,n=this.areaPath,s=this.options,a=this.zones,l=[["area","highcharts-area",this.color,s.fillColor]];a.forEach(function(h,d){l.push(["zone-area-"+d,"highcharts-area highcharts-zone-area-"+d+" "+h.className,h.color||t.color,h.fillColor||s.fillColor])}),l.forEach(function(h){var d=h[0],c=t[d],f=c?"animate":"attr",u={};c?(c.endX=t.preventGraphAnimation?null:n.xMap,c.animate({d:n})):(u.zIndex=0,c=t[d]=t.chart.renderer.path(n).addClass(h[1]).add(t.group),c.isArea=!0),t.chart.styledMode||(u.fill=pick$1c(h[3],color$d(h[2]).setOpacity(pick$1c(s.fillOpacity,.75)).get())),c[f](u),c.startX=n.xMap,c.shiftUnit=s.step?2:1})},r.prototype.getGraphPath=function(t){var n=LineSeries$4.prototype.getGraphPath,s,a=this.options,l=a.stacking,h=this.yAxis,d,c,f=[],u=[],p=this.index,g,m,v,x=h.stacking.stacks[this.stackKey],y=a.threshold,b=Math.round(h.getThreshold(a.threshold)),$,S,k=pick$1c(a.connectNulls,l==="percent"),A=function(E,M,C){var O=t[E],L=l&&x[O.x].points[p],T=O[C+"Null"]||0,_=O[C+"Cliff"]||0,D,N,I=!0;_||T?(D=(T?L[0]:L[1])+_,N=L[0]+_,I=!!T):!l&&t[M]&&t[M].isNull&&(D=N=y),typeof D<"u"&&(u.push({plotX:v,plotY:D===null?b:h.getThreshold(D),isNull:I,isCliff:!0}),f.push({plotX:v,plotY:N===null?b:h.getThreshold(N),doCurve:!1}))};for(t=t||this.points,l&&(t=this.getStackPoints(t)),g=0;g<t.length;g++)l||(t[g].leftCliff=t[g].rightCliff=t[g].leftNull=t[g].rightNull=void 0),$=t[g].isNull,v=pick$1c(t[g].rectPlotX,t[g].plotX),S=l?pick$1c(t[g].yBottom,b):b,(!$||k)&&(k||A(g,g-1,"left"),$&&!l&&k||(u.push(t[g]),f.push({x:g,plotX:v,plotY:S})),k||A(g,g+1,"right"));d=n.call(this,u,!0,!0),f.reversed=!0,c=n.call(this,f,!0,!0);var P=c[0];return P&&P[0]==="M"&&(c[0]=["L",P[1],P[2]]),m=d.concat(c),m.length&&m.push(["Z"]),s=n.call(this,u,!1,k),m.xMap=d.xMap,this.areaPath=m,s},r.prototype.getStackPoints=function(t){var n=this,s=[],a=[],l=this.xAxis,h=this.yAxis,d=h.stacking.stacks[this.stackKey],c={},f=h.series,u=f.length,p=h.options.reversedStacks?1:-1,g=f.indexOf(n);if(t=t||this.points,this.options.stacking){for(var m=0;m<t.length;m++)t[m].leftNull=t[m].rightNull=void 0,c[t[m].x]=t[m];objectEach$j(d,function(x,y){x.total!==null&&a.push(y)}),a.sort(function(x,y){return x-y});var v=f.map(function(x){return x.visible});a.forEach(function(x,y){var b=0,$,S;if(c[x]&&!c[x].isNull)s.push(c[x]),[-1,1].forEach(function(P){var E=P===1?"rightNull":"leftNull",M=P===1?"rightCliff":"leftCliff",C=0,O=d[a[y+P]];if(O)for(var L=g;L>=0&&L<u;){var T=f[L].index;$=O.points[T],$||(T===n.index?c[x][E]=!0:v[L]&&(S=d[x].points[T],S&&(C-=S[1]-S[0]))),L+=p}c[x][M]=C});else{for(var k=g;k>=0&&k<u;){var A=f[k].index;if($=d[x].points[A],$){b=$[1];break}k+=p}b=pick$1c(b,0),b=h.translate(b,0,1,0,1),s.push({isNull:!0,plotX:l.translate(x,0,0,0,1),x,plotY:b,yBottom:b})}})}return s},r.defaultOptions=merge$15(LineSeries$4.defaultOptions,{threshold:0}),r}(LineSeries$4);extend$1b(AreaSeries$1.prototype,{singleStacks:!1,drawLegendSymbol:LegendSymbol$1.drawRectangle});SeriesRegistry$1.registerSeriesType("area",AreaSeries$1);var __extends$S=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),LineSeries$3=SeriesRegistry$1.seriesTypes.line,merge$14=Utilities.merge,pick$1b=Utilities.pick,SplineSeries$1=function(o){__extends$S(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.getPointSpline=function(t,n,s){var a=1.5,l=a+1,h=n.plotX||0,d=n.plotY||0,c=t[s-1],f=t[s+1],u,p,g,m,v;function x(A){return A&&!A.isNull&&A.doCurve!==!1&&!n.isCliff}if(x(c)&&x(f)){var y=c.plotX||0,b=c.plotY||0,$=f.plotX||0,S=f.plotY||0,k=0;u=(a*h+y)/l,p=(a*d+b)/l,g=(a*h+$)/l,m=(a*d+S)/l,g!==u&&(k=(m-p)*(g-h)/(g-u)+d-m),p+=k,m+=k,p>b&&p>d?(p=Math.max(b,d),m=2*d-p):p<b&&p<d&&(p=Math.min(b,d),m=2*d-p),m>S&&m>d?(m=Math.max(S,d),p=2*d-m):m<S&&m<d&&(m=Math.min(S,d),p=2*d-m),n.rightContX=g,n.rightContY=m}return v=["C",pick$1b(c.rightContX,c.plotX,0),pick$1b(c.rightContY,c.plotY,0),pick$1b(u,h,0),pick$1b(p,d,0),h,d],c.rightContX=c.rightContY=void 0,v},r.defaultOptions=merge$14(LineSeries$3.defaultOptions),r}(LineSeries$3);SeriesRegistry$1.registerSeriesType("spline",SplineSeries$1);var __extends$R=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),areaProto$1=AreaSeries$1.prototype,extend$1a=Utilities.extend,merge$13=Utilities.merge,AreaSplineSeries=function(o){__extends$R(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.points=void 0,t.options=void 0,t}return r.defaultOptions=merge$13(SplineSeries$1.defaultOptions,AreaSeries$1.defaultOptions),r}(SplineSeries$1);extend$1a(AreaSplineSeries.prototype,{getGraphPath:areaProto$1.getGraphPath,getStackPoints:areaProto$1.getStackPoints,drawGraph:areaProto$1.drawGraph,drawLegendSymbol:LegendSymbol$1.drawRectangle});SeriesRegistry$1.registerSeriesType("areaspline",AreaSplineSeries);var __extends$Q=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),animObject$5=animationExports.animObject,color$c=Color.parse,hasTouch$1=H.hasTouch,noop$h=H.noop,clamp$d=Utilities.clamp,css$4=Utilities.css,defined$D=Utilities.defined,extend$19=Utilities.extend,fireEvent$p=Utilities.fireEvent,isArray$d=Utilities.isArray,isNumber$x=Utilities.isNumber,merge$12=Utilities.merge,pick$1a=Utilities.pick,objectEach$i=Utilities.objectEach,ColumnSeries$h=function(o){__extends$Q(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.borderWidth=void 0,t.data=void 0,t.group=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.animate=function(t){var n=this,s=this.yAxis,a=n.options,l=this.chart.inverted,h={},d=l?"translateX":"translateY",c,f;t?(h.scaleY=.001,f=clamp$d(s.toPixels(a.threshold),s.pos,s.pos+s.len),l?h.translateX=f-s.len:h.translateY=f,n.clipBox&&n.setClip(),n.group.attr(h)):(c=Number(n.group.attr(d)),n.group.animate({scaleY:1},extend$19(animObject$5(n.options.animation),{step:function(u,p){n.group&&(h[d]=c+p.pos*(s.pos-c),n.group.attr(h))}})))},r.prototype.init=function(t,n){o.prototype.init.apply(this,arguments);var s=this;t=s.chart,t.hasRendered&&t.series.forEach(function(a){a.type===s.type&&(a.isDirty=!0)})},r.prototype.getColumnMetrics=function(){var t=this,n=t.options,s=t.xAxis,a=t.yAxis,l=s.options.reversedStacks,h=s.reversed&&!l||!s.reversed&&l,d={},c,f=0;n.grouping===!1?f=1:t.chart.series.forEach(function($){var S=$.yAxis,k=$.options,A;$.type===t.type&&($.visible||!t.chart.options.chart.ignoreHiddenSeries)&&a.len===S.len&&a.pos===S.pos&&(k.stacking&&k.stacking!=="group"?(c=$.stackKey,typeof d[c]>"u"&&(d[c]=f++),A=d[c]):k.grouping!==!1&&(A=f++),$.columnIndex=A)});var u=Math.min(Math.abs(s.transA)*(s.ordinal&&s.ordinal.slope||n.pointRange||s.closestPointRange||s.tickInterval||1),s.len),p=u*n.groupPadding,g=u-2*p,m=g/(f||1),v=Math.min(n.maxPointWidth||s.len,pick$1a(n.pointWidth,m*(1-2*n.pointPadding))),x=(m-v)/2,y=(t.columnIndex||0)+(h?1:0),b=x+(p+y*m-u/2)*(h?-1:1);return t.columnMetrics={width:v,offset:b,paddedWidth:m,columnCount:f},t.columnMetrics},r.prototype.crispCol=function(t,n,s,a){var l=this.chart,h=this.borderWidth,d=-(h%2?.5:0),c,f=h%2?.5:1;l.inverted&&l.renderer.isVML&&(f+=1),this.options.crisp&&(c=Math.round(t+s)+d,t=Math.round(t)+d,s=c-t);var u=Math.round(n+a)+f,p=Math.abs(n)<=.5&&u>.5;return n=Math.round(n)+f,a=u-n,p&&a&&(n-=1,a+=1),{x:t,y:n,width:s,height:a}},r.prototype.adjustForMissingColumns=function(t,n,s,a){var l=this,h=this.options.stacking;if(!s.isNull&&a.columnCount>1){var d=0,c=0;objectEach$i(this.yAxis.stacking&&this.yAxis.stacking.stacks,function(u){if(typeof s.x=="number"){var p=u[s.x.toString()];if(p){var g=p.points[l.index],m=p.total;h?(g&&(d=c),p.hasValidPoints&&c++):isArray$d(g)&&(d=g[1],c=m||0)}}});var f=(c-1)*a.paddedWidth+n;t=(s.plotX||0)+f/2-n-d*a.paddedWidth}return t},r.prototype.translate=function(){var t=this,n=t.chart,s=t.options,a=t.dense=t.closestPointRange*t.xAxis.transA<2,l=t.borderWidth=pick$1a(s.borderWidth,a?0:1),h=t.xAxis,d=t.yAxis,c=s.threshold,f=t.translatedThreshold=d.getThreshold(c),u=pick$1a(s.minPointLength,5),p=t.getColumnMetrics(),g=p.width,m=t.pointXOffset=p.offset,v=t.dataMin,x=t.dataMax,y=t.barW=Math.max(g,1+2*l);n.inverted&&(f-=.5),s.pointPadding&&(y=Math.ceil(y)),Series$e.prototype.translate.apply(t),t.points.forEach(function(b){var $=pick$1a(b.yBottom,f),S=999+Math.abs($),k=b.plotX||0,A=clamp$d(b.plotY,-S,d.len+S),P,E=Math.min(A,$),M=Math.max(A,$)-E,C=g,O=k+m,L=y;u&&Math.abs(M)<u&&(M=u,P=!d.reversed&&!b.negative||d.reversed&&b.negative,isNumber$x(c)&&isNumber$x(x)&&b.y===c&&x<=c&&(d.min||0)<c&&(v!==x||(d.max||0)<=c)&&(P=!P),E=Math.abs(E-f)>u?$-u:f-(P?u:0)),defined$D(b.options.pointWidth)&&(C=L=Math.ceil(b.options.pointWidth),O-=Math.round((C-g)/2)),s.centerInCategory&&(O=t.adjustForMissingColumns(O,C,b,p)),b.barX=O,b.pointWidth=C,b.tooltipPos=n.inverted?[clamp$d(d.len+d.pos-n.plotLeft-A,d.pos-n.plotLeft,d.len+d.pos-n.plotLeft),h.len+h.pos-n.plotTop-O-L/2,M]:[h.left-n.plotLeft+O+L/2,clamp$d(A+d.pos-n.plotTop,d.pos-n.plotTop,d.len+d.pos-n.plotTop),M],b.shapeType=t.pointClass.prototype.shapeType||"rect",b.shapeArgs=t.crispCol.apply(t,b.isNull?[O,f,L,0]:[O,E,L,M])})},r.prototype.drawGraph=function(){this.group[this.dense?"addClass":"removeClass"]("highcharts-dense-data")},r.prototype.pointAttribs=function(t,n){var s=this.options,a=this.pointAttrToOptions||{},l=a.stroke||"borderColor",h=a["stroke-width"]||"borderWidth",d,c,f,u=t&&t.color||this.color,p=t&&t[l]||s[l]||u,g=t&&t.options.dashStyle||s.dashStyle,m=t&&t[h]||s[h]||this[h]||0,v=pick$1a(t&&t.opacity,s.opacity,1);t&&this.zones.length&&(c=t.getZone(),u=t.options.color||c&&(c.color||t.nonZonedColor)||this.color,c&&(p=c.borderColor||p,g=c.dashStyle||g,m=c.borderWidth||m)),n&&t&&(d=merge$12(s.states[n],t.options.states&&t.options.states[n]||{}),f=d.brightness,u=d.color||typeof f<"u"&&color$c(u).brighten(d.brightness).get()||u,p=d[l]||p,m=d[h]||m,g=d.dashStyle||g,v=pick$1a(d.opacity,v));var x={fill:u,stroke:p,"stroke-width":m,opacity:v};return g&&(x.dashstyle=g),x},r.prototype.drawPoints=function(){var t=this,n=this.chart,s=t.options,a=n.renderer,l=s.animationLimit||250,h;t.points.forEach(function(d){var c=d.plotY,f=d.graphic,u=!!f,p=f&&n.pointCount<l?"animate":"attr";isNumber$x(c)&&d.y!==null?(h=d.shapeArgs,f&&d.hasNewShapeType()&&(f=f.destroy()),t.enabledDataSorting&&(d.startXPos=t.xAxis.reversed?-(h&&h.width||0):t.xAxis.width),f||(d.graphic=f=a[d.shapeType](h).add(d.group||t.group),f&&t.enabledDataSorting&&n.hasRendered&&n.pointCount<l&&(f.attr({x:d.startXPos}),u=!0,p="animate")),f&&u&&f[p](merge$12(h)),s.borderRadius&&f[p]({r:s.borderRadius}),n.styledMode||f[p](t.pointAttribs(d,d.selected&&"select")).shadow(d.allowShadow!==!1&&s.shadow,null,s.stacking&&!s.borderRadius),f&&(f.addClass(d.getClassName(),!0),f.attr({visibility:d.visible?"inherit":"hidden"}))):f&&(d.graphic=f.destroy())})},r.prototype.drawTracker=function(){var t=this,n=t.chart,s=n.pointer,a=function(h){var d=s.getPointFromEvent(h);typeof d<"u"&&(s.isDirectTouch=!0,d.onMouseOver(h))},l;t.points.forEach(function(h){l=isArray$d(h.dataLabels)?h.dataLabels:h.dataLabel?[h.dataLabel]:[],h.graphic&&(h.graphic.element.point=h),l.forEach(function(d){d.div?d.div.point=h:d.element.point=h})}),t._hasTracking||(t.trackerGroups.forEach(function(h){t[h]&&(t[h].addClass("highcharts-tracker").on("mouseover",a).on("mouseout",function(d){s.onTrackerMouseOut(d)}),hasTouch$1&&t[h].on("touchstart",a),!n.styledMode&&t.options.cursor&&t[h].css(css$4).css({cursor:t.options.cursor}))}),t._hasTracking=!0),fireEvent$p(this,"afterDrawTracker")},r.prototype.remove=function(){var t=this,n=t.chart;n.hasRendered&&n.series.forEach(function(s){s.type===t.type&&(s.isDirty=!0)}),Series$e.prototype.remove.apply(t,arguments)},r.defaultOptions=merge$12(Series$e.defaultOptions,{borderRadius:0,centerInCategory:!1,groupPadding:.2,marker:null,pointPadding:.1,minPointLength:0,cropThreshold:50,pointRange:null,states:{hover:{halo:!1,brightness:.1},select:{color:palette.neutralColor20,borderColor:palette.neutralColor100}},dataLabels:{align:void 0,verticalAlign:void 0,y:void 0},startFromThreshold:!0,stickyTracking:!1,tooltip:{distance:6},threshold:0,borderColor:palette.backgroundColor}),r}(Series$e);extend$19(ColumnSeries$h.prototype,{cropShoulder:0,directTouch:!0,drawLegendSymbol:LegendSymbol$1.drawRectangle,getSymbol:noop$h,negStacks:!0,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("column",ColumnSeries$h);var getDeferredAnimation$1=animationExports.getDeferredAnimation,format$8=FormatUtilities.format,defined$C=Utilities.defined,extend$18=Utilities.extend,fireEvent$o=Utilities.fireEvent,isArray$c=Utilities.isArray,merge$11=Utilities.merge,objectEach$h=Utilities.objectEach,pick$19=Utilities.pick,splat$b=Utilities.splat,DataLabel;(function(o){var r=[];function t(c,f,u,p,g){var m=this,v=this.chart,x=this.isCartesian&&v.inverted,y=this.enabledDataSorting,b=pick$19(c.dlBox&&c.dlBox.centerX,c.plotX,-9999),$=pick$19(c.plotY,-9999),S=f.getBBox(),k=u.rotation,A=u.align,P=v.isInsidePlot(b,Math.round($),{inverted:x,paneCoordinates:!0,series:m}),E=function(N){y&&m.xAxis&&!_&&m.setDataLabelStartPos(c,f,g,P,N)},M,C,O,L,T,_=pick$19(u.overflow,y?"none":"justify")==="justify",D=this.visible&&c.visible!==!1&&(c.series.forceDL||y&&!_||P||pick$19(u.inside,!!this.options.stacking)&&p&&v.isInsidePlot(b,x?p.x+1:p.y+p.height-1,{inverted:x,paneCoordinates:!0,series:m}));D&&(M=v.renderer.fontMetrics(v.styledMode?void 0:u.style.fontSize,f).b,p=extend$18({x:x?this.yAxis.len-$:b,y:Math.round(x?this.xAxis.len-b:$),width:0,height:0},p),extend$18(u,{width:S.width,height:S.height}),k?(_=!1,L=v.renderer.rotCorr(M,k),T={x:p.x+(u.x||0)+p.width/2+L.x,y:p.y+(u.y||0)+{top:0,middle:.5,bottom:1}[u.verticalAlign]*p.height},E(T),f[g?"attr":"animate"](T).attr({align:A}),C=(k+720)%360,O=C>180&&C<360,A==="left"?T.y-=O?S.height:0:A==="center"?(T.x-=S.width/2,T.y-=S.height/2):A==="right"&&(T.x-=S.width,T.y-=O?0:S.height),f.placed=!0,f.alignAttr=T):(E(p),f.align(u,void 0,p),T=f.alignAttr),_&&p.height>=0?this.justifyDataLabel(f,u,T,S,p,g):pick$19(u.crop,!0)&&(D=v.isInsidePlot(T.x,T.y,{paneCoordinates:!0,series:m})&&v.isInsidePlot(T.x+S.width,T.y+S.height,{paneCoordinates:!0,series:m})),u.shape&&!k&&f[g?"attr":"animate"]({anchorX:x?v.plotWidth-c.plotY:c.plotX,anchorY:x?v.plotHeight-c.plotX:c.plotY})),g&&y&&(f.placed=!1),!D&&(!y||_)&&(f.hide(!0),f.placed=!1)}function n(c,f){var u=f.filter;if(u){var p=u.operator,g=c[u.property],m=u.value;return p===">"&&g>m||p==="<"&&g<m||p===">="&&g>=m||p==="<="&&g<=m||p==="=="&&g==m||p==="==="&&g===m}return!0}function s(c){if(r.indexOf(c)===-1){var f=c.prototype;r.push(c),f.alignDataLabel=t,f.drawDataLabels=a,f.justifyDataLabel=l,f.setDataLabelStartPos=d}}o.compose=s;function a(){var c=this,f=c.chart,u=c.options,p=c.points,g=c.hasRendered||0,m=f.renderer,v=u.dataLabels,x,y,b=v.animation,$=v.defer?getDeferredAnimation$1(f,b,c):{defer:0,duration:0};if(v=h(h(f.options.plotOptions&&f.options.plotOptions.series&&f.options.plotOptions.series.dataLabels,f.options.plotOptions&&f.options.plotOptions[c.type]&&f.options.plotOptions[c.type].dataLabels),v),fireEvent$o(this,"drawDataLabels"),isArray$c(v)||v.enabled||c._hasPointLabels){if(y=c.plotGroup("dataLabelsGroup","data-labels",g?"inherit":"hidden",v.zIndex||6),y.attr({opacity:+g}),!g){var S=c.dataLabelsGroup;S&&(c.visible&&y.show(!0),S[u.animation?"animate":"attr"]({opacity:1},$))}p.forEach(function(k){x=splat$b(h(v,k.dlOptions||k.options&&k.options.dataLabels)),x.forEach(function(A,P){var E=A.enabled&&(!k.isNull||k.dataLabelOnNull)&&n(k,A),M=k.connectors?k.connectors[P]:k.connector,C,O,L,T,_,D,N=k.dataLabels?k.dataLabels[P]:k.dataLabel,I=pick$19(A.distance,k.labelDistance),B=!N;E&&(C=k.getLabelConfig(),O=pick$19(A[k.formatPrefix+"Format"],A.format),L=defined$C(O)?format$8(O,C,f):(A[k.formatPrefix+"Formatter"]||A.formatter).call(C,A),T=A.style,_=A.rotation,f.styledMode||(T.color=pick$19(A.color,T.color,c.color,palette.neutralColor100),T.color==="contrast"?(k.contrastColor=m.getContrast(k.color||c.color),T.color=!defined$C(I)&&A.inside||I<0||u.stacking?k.contrastColor:palette.neutralColor100):delete k.contrastColor,u.cursor&&(T.cursor=u.cursor)),D={r:A.borderRadius||0,rotation:_,padding:A.padding,zIndex:1},f.styledMode||(D.fill=A.backgroundColor,D.stroke=A.borderColor,D["stroke-width"]=A.borderWidth),objectEach$h(D,function(X,W){typeof X>"u"&&delete D[W]})),N&&(!E||!defined$C(L))?(k.dataLabel=k.dataLabel&&k.dataLabel.destroy(),k.dataLabels&&(k.dataLabels.length===1?delete k.dataLabels:delete k.dataLabels[P]),P||delete k.dataLabel,M&&(k.connector=k.connector.destroy(),k.connectors&&(k.connectors.length===1?delete k.connectors:delete k.connectors[P]))):E&&defined$C(L)&&(N?D.text=L:(k.dataLabels=k.dataLabels||[],N=k.dataLabels[P]=_?m.text(L,0,-9999,A.useHTML).addClass("highcharts-data-label"):m.label(L,0,-9999,A.shape,null,null,A.useHTML,null,"data-label"),P||(k.dataLabel=N),N.addClass(" highcharts-data-label-color-"+k.colorIndex+" "+(A.className||"")+(A.useHTML?" highcharts-tracker":""))),N.options=A,N.attr(D),f.styledMode||N.css(T).shadow(A.shadow),N.added||N.add(y),A.textPath&&!A.useHTML&&(N.setTextPath(k.getDataLabelPath&&k.getDataLabelPath(N)||k.graphic,A.textPath),k.dataLabelPath&&!A.textPath.enabled&&(k.dataLabelPath=k.dataLabelPath.destroy())),c.alignDataLabel(k,N,A,null,B))})})}fireEvent$o(this,"afterDrawDataLabels")}function l(c,f,u,p,g,m){var v=this.chart,x=f.align,y=f.verticalAlign,b=c.box?0:c.padding||0,$=f.x,S=$===void 0?0:$,k=f.y,A=k===void 0?0:k,P,E;return P=(u.x||0)+b,P<0&&(x==="right"&&S>=0?(f.align="left",f.inside=!0):S-=P,E=!0),P=(u.x||0)+p.width-b,P>v.plotWidth&&(x==="left"&&S<=0?(f.align="right",f.inside=!0):S+=v.plotWidth-P,E=!0),P=u.y+b,P<0&&(y==="bottom"&&A>=0?(f.verticalAlign="top",f.inside=!0):A-=P,E=!0),P=(u.y||0)+p.height-b,P>v.plotHeight&&(y==="top"&&A<=0?(f.verticalAlign="bottom",f.inside=!0):A+=v.plotHeight-P,E=!0),E&&(f.x=S,f.y=A,c.placed=!m,c.align(f,void 0,g)),E}function h(c,f){var u=[],p;if(isArray$c(c)&&!isArray$c(f))u=c.map(function(g){return merge$11(g,f)});else if(isArray$c(f)&&!isArray$c(c))u=f.map(function(g){return merge$11(c,g)});else if(!isArray$c(c)&&!isArray$c(f))u=merge$11(c,f);else for(p=Math.max(c.length,f.length);p--;)u[p]=merge$11(c[p],f[p]);return u}function d(c,f,u,p,g){var m=this.chart,v=m.inverted,x=this.xAxis,y=x.reversed,b=v?f.height/2:f.width/2,$=c.pointWidth,S=$?$/2:0;f.startXPos=v?g.x:y?-b-S:x.width-b+S,f.startYPos=v?y?this.yAxis.height-b+S:-b-S:g.y,p?f.visibility==="hidden"&&(f.show(),f.attr({opacity:0}).animate({opacity:1})):f.attr({opacity:1}).animate({opacity:0},void 0,f.hide),m.hasRendered&&(u&&f.attr({x:f.startXPos,y:f.startYPos}),f.placed=!0)}})(DataLabel||(DataLabel={}));const DataLabel$1=DataLabel;var Series$d=SeriesRegistry$1.series,merge$10=Utilities.merge,pick$18=Utilities.pick,ColumnDataLabel$1;(function(o){var r=[];function t(s,a,l,h,d){var c=this.chart.inverted,f=s.series,u=s.dlBox||s.shapeArgs,p=pick$18(s.below,s.plotY>pick$18(this.translatedThreshold,f.yAxis.len)),g=pick$18(l.inside,!!this.options.stacking),m;u&&(h=merge$10(u),h.y<0&&(h.height+=h.y,h.y=0),m=h.y+h.height-f.yAxis.len,m>0&&m<h.height&&(h.height-=m),c&&(h={x:f.yAxis.len-h.y-h.height,y:f.xAxis.len-h.x-h.width,width:h.height,height:h.width}),g||(c?(h.x+=p?0:h.width,h.width=0):(h.y+=p?h.height:0,h.height=0))),l.align=pick$18(l.align,!c||g?"center":p?"right":"left"),l.verticalAlign=pick$18(l.verticalAlign,c||g?"middle":p?"top":"bottom"),Series$d.prototype.alignDataLabel.call(this,s,a,l,h,d),l.inside&&s.contrastColor&&a.css({color:s.contrastColor})}function n(s){DataLabel$1.compose(Series$d),r.indexOf(s)===-1&&(r.push(s),s.prototype.alignDataLabel=t)}o.compose=n})(ColumnDataLabel$1||(ColumnDataLabel$1={}));const ColumnDataLabel$2=ColumnDataLabel$1;var __extends$P=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),extend$17=Utilities.extend,merge$$=Utilities.merge,BarSeries=function(o){__extends$P(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.defaultOptions=merge$$(ColumnSeries$h.defaultOptions,{}),r}(ColumnSeries$h);extend$17(BarSeries.prototype,{inverted:!0});SeriesRegistry$1.registerSeriesType("bar",BarSeries);var __extends$O=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),addEvent$P=Utilities.addEvent,extend$16=Utilities.extend,merge$_=Utilities.merge,ScatterSeries$4=function(o){__extends$O(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.applyJitter=function(){var t=this,n=this.options.jitter,s=this.points.length;function a(l){var h=Math.sin(l)*1e4;return h-Math.floor(h)}n&&this.points.forEach(function(l,h){["x","y"].forEach(function(d,c){var f,u="plot"+d.toUpperCase(),p,g,m;n[d]&&!l.isNull&&(f=t[d+"Axis"],m=n[d]*f.transA,f&&!f.isLog&&(p=Math.max(0,l[u]-m),g=Math.min(f.len,l[u]+m),l[u]=p+(g-p)*a(h+c*s),d==="x"&&(l.clientX=l.plotX)))})})},r.prototype.drawGraph=function(){this.options.lineWidth?o.prototype.drawGraph.call(this):this.graph&&(this.graph=this.graph.destroy())},r.defaultOptions=merge$_(LineSeries$5.defaultOptions,{lineWidth:0,findNearestPointBy:"xy",jitter:{x:0,y:0},marker:{enabled:!0},tooltip:{headerFormat:'<span style="color:{point.color}">●</span> <span style="font-size: 10px"> {series.name}</span><br/>',pointFormat:"x: <b>{point.x}</b><br/>y: <b>{point.y}</b><br/>"}}),r}(LineSeries$5);extend$16(ScatterSeries$4.prototype,{drawTracker:ColumnSeries$h.prototype.drawTracker,sorted:!1,requireSorting:!1,noSharedTooltip:!0,trackerGroups:["group","markerGroup","dataLabelsGroup"],takeOrdinalPosition:!1});addEvent$P(ScatterSeries$4,"afterTranslate",function(){this.applyJitter()});SeriesRegistry$1.registerSeriesType("scatter",ScatterSeries$4);var isNumber$w=Utilities.isNumber,pick$17=Utilities.pick,relativeLength$6=Utilities.relativeLength,deg2rad$4=H.deg2rad,centeredSeriesMixin=H.CenteredSeriesMixin={getCenter:function(){var o=this.options,r=this.chart,t=2*(o.slicedOffset||0),n,s=r.plotWidth-2*t,a=r.plotHeight-2*t,l=o.center,h=Math.min(s,a),d=o.size,c=o.innerSize||0,f,u,p;for(typeof d=="string"&&(d=parseFloat(d)),typeof c=="string"&&(c=parseFloat(c)),f=[pick$17(l[0],"50%"),pick$17(l[1],"50%"),pick$17(d&&d<0?void 0:o.size,"100%"),pick$17(c&&c<0?void 0:o.innerSize||0,"0%")],r.angular&&!(this instanceof Series$e)&&(f[3]=0),u=0;u<4;++u)p=f[u],n=u<2||u===2&&/%$/.test(p),f[u]=relativeLength$6(p,[s,a,h,f[2]][u])+(n?t:0);return f[3]>f[2]&&(f[3]=f[2]),f},getStartAndEndRadians:function(o,r){var t=isNumber$w(o)?o:0,n=isNumber$w(r)&&r>t&&r-t<360?r:t+360,s=-90;return{start:deg2rad$4*(t+s),end:deg2rad$4*(n+s)}}},__extends$N=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),setAnimation$1=animationExports.setAnimation,addEvent$O=Utilities.addEvent,defined$B=Utilities.defined,extend$15=Utilities.extend,isNumber$v=Utilities.isNumber,pick$16=Utilities.pick,relativeLength$5=Utilities.relativeLength,PiePoint$3=function(o){__extends$N(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.labelDistance=void 0,t.options=void 0,t.series=void 0,t}return r.prototype.getConnectorPath=function(){var t=this.labelPosition,n=this.series.options.dataLabels,s=this.connectorShapes,a=n.connectorShape;return s[a]&&(a=s[a]),a.call(this,{x:t.final.x,y:t.final.y,alignment:t.alignment},t.connectorPosition,n)},r.prototype.getTranslate=function(){return this.sliced?this.slicedTranslation:{translateX:0,translateY:0}},r.prototype.haloPath=function(t){var n=this.shapeArgs;return this.sliced||!this.visible?[]:this.series.chart.renderer.symbols.arc(n.x,n.y,n.r+t,n.r+t,{innerR:n.r-1,start:n.start,end:n.end})},r.prototype.init=function(){var t=this;o.prototype.init.apply(this,arguments),this.name=pick$16(this.name,"Slice");var n=function(s){t.slice(s.type==="select")};return addEvent$O(this,"select",n),addEvent$O(this,"unselect",n),this},r.prototype.isValid=function(){return isNumber$v(this.y)&&this.y>=0},r.prototype.setVisible=function(t,n){var s=this,a=this.series,l=a.chart,h=a.options.ignoreHiddenPoint;n=pick$16(n,h),t!==this.visible&&(this.visible=this.options.visible=t=typeof t>"u"?!this.visible:t,a.options.data[a.data.indexOf(this)]=this.options,["graphic","dataLabel","connector","shadowGroup"].forEach(function(d){s[d]&&s[d][t?"show":"hide"](t)}),this.legendItem&&l.legend.colorizeItem(this,t),!t&&this.state==="hover"&&this.setState(""),h&&(a.isDirty=!0),n&&l.redraw())},r.prototype.slice=function(t,n,s){var a=this.series,l=a.chart;setAnimation$1(s,l),n=pick$16(n,!0),this.sliced=this.options.sliced=t=defined$B(t)?t:!this.sliced,a.options.data[a.data.indexOf(this)]=this.options,this.graphic&&this.graphic.animate(this.getTranslate()),this.shadowGroup&&this.shadowGroup.animate(this.getTranslate())},r}(Point$2);extend$15(PiePoint$3.prototype,{connectorShapes:{fixedOffset:function(o,r,t){var n=r.breakAt,s=r.touchingSliceAt,a=t.softConnector?["C",o.x+(o.alignment==="left"?-5:5),o.y,2*n.x-s.x,2*n.y-s.y,n.x,n.y]:["L",n.x,n.y];return[["M",o.x,o.y],a,["L",s.x,s.y]]},straight:function(o,r){var t=r.touchingSliceAt;return[["M",o.x,o.y],["L",t.x,t.y]]},crookedLine:function(o,r,t){var n=r.touchingSliceAt,s=this.series,a=s.center[0],l=s.chart.plotWidth,h=s.chart.plotLeft,d=o.alignment,c=this.shapeArgs.r,f=relativeLength$5(t.crookDistance,1),u=d==="left"?a+c+(l+h-a-c)*(1-f):h+(a-c)*f,p=["L",u,o.y],g=!0;(d==="left"?u>o.x||u<n.x:u<o.x||u>n.x)&&(g=!1);var m=[["M",o.x,o.y]];return g&&m.push(p),m.push(["L",n.x,n.y]),m}}});var __extends$M=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),getStartAndEndRadians=centeredSeriesMixin.getStartAndEndRadians,noop$g=H.noop,clamp$c=Utilities.clamp,extend$14=Utilities.extend,fireEvent$n=Utilities.fireEvent,merge$Z=Utilities.merge,pick$15=Utilities.pick,relativeLength$4=Utilities.relativeLength,PieSeries$3=function(o){__extends$M(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.center=void 0,t.data=void 0,t.maxLabelDistance=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.animate=function(t){var n=this,s=n.points,a=n.startAngleRad;t||s.forEach(function(l){var h=l.graphic,d=l.shapeArgs;h&&d&&(h.attr({r:pick$15(l.startR,n.center&&n.center[3]/2),start:a,end:a}),h.animate({r:d.r,start:d.start,end:d.end},n.options.animation))})},r.prototype.drawEmpty=function(){var t=this.startAngleRad,n=this.endAngleRad,s=this.options,a,l;this.total===0&&this.center?(a=this.center[0],l=this.center[1],this.graph||(this.graph=this.chart.renderer.arc(a,l,this.center[1]/2,0,t,n).addClass("highcharts-empty-series").add(this.group)),this.graph.attr({d:Symbols.arc(a,l,this.center[2]/2,0,{start:t,end:n,innerR:this.center[3]/2})}),this.chart.styledMode||this.graph.attr({"stroke-width":s.borderWidth,fill:s.fillColor||"none",stroke:s.color||palette.neutralColor20})):this.graph&&(this.graph=this.graph.destroy())},r.prototype.drawPoints=function(){var t=this.chart.renderer;this.points.forEach(function(n){n.graphic&&n.hasNewShapeType()&&(n.graphic=n.graphic.destroy()),n.graphic||(n.graphic=t[n.shapeType](n.shapeArgs).add(n.series.group),n.delayedRendering=!0)})},r.prototype.generatePoints=function(){o.prototype.generatePoints.call(this),this.updateTotals()},r.prototype.getX=function(t,n,s){var a=this.center,l=this.radii?this.radii[s.index]||0:a[2]/2,h=Math.asin(clamp$c((t-a[1])/(l+s.labelDistance),-1,1)),d=a[0]+(n?-1:1)*(Math.cos(h)*(l+s.labelDistance))+(s.labelDistance>0?(n?-1:1)*this.options.dataLabels.padding:0);return d},r.prototype.hasData=function(){return!!this.processedXData.length},r.prototype.redrawPoints=function(){var t=this,n=t.chart,s=n.renderer,a=t.options.shadow,l,h,d,c;this.drawEmpty(),a&&!t.shadowGroup&&!n.styledMode&&(t.shadowGroup=s.g("shadow").attr({zIndex:-1}).add(t.group)),t.points.forEach(function(f){var u={};if(h=f.graphic,!f.isNull&&h){var p=void 0;c=f.shapeArgs,l=f.getTranslate(),n.styledMode||(p=f.shadowGroup,a&&!p&&(p=f.shadowGroup=s.g("shadow").add(t.shadowGroup)),p&&p.attr(l),d=t.pointAttribs(f,f.selected&&"select")),f.delayedRendering?(h.setRadialReference(t.center).attr(c).attr(l),n.styledMode||h.attr(d).attr({"stroke-linejoin":"round"}).shadow(a,p),f.delayedRendering=!1):(h.setRadialReference(t.center),n.styledMode||merge$Z(!0,u,d),merge$Z(!0,u,c,l),h.animate(u)),h.attr({visibility:f.visible?"inherit":"hidden"}),h.addClass(f.getClassName(),!0)}else h&&(f.graphic=h.destroy())})},r.prototype.sortByAngle=function(t,n){t.sort(function(s,a){return typeof s.angle<"u"&&(a.angle-s.angle)*n})},r.prototype.translate=function(t){this.generatePoints();var n=this,s=1e3,a=n.options,l=a.slicedOffset,h=l+(a.borderWidth||0),d=getStartAndEndRadians(a.startAngle,a.endAngle),c=n.startAngleRad=d.start,f=n.endAngleRad=d.end,u=f-c,p=n.points,g=a.dataLabels.distance,m=a.ignoreHiddenPoint,v=p.length,x,y,b,$,S,k,A,P,E=0;for(t||(n.center=t=n.getCenter()),A=0;A<v;A++){P=p[A],y=c+E*u,P.isValid()&&(!m||P.visible)&&(E+=P.percentage/100),b=c+E*u;var M={x:t[0],y:t[1],r:t[2]/2,innerR:t[3]/2,start:Math.round(y*s)/s,end:Math.round(b*s)/s};P.shapeType="arc",P.shapeArgs=M,P.labelDistance=pick$15(P.options.dataLabels&&P.options.dataLabels.distance,g),P.labelDistance=relativeLength$4(P.labelDistance,M.r),n.maxLabelDistance=Math.max(n.maxLabelDistance||0,P.labelDistance),$=(b+y)/2,$>1.5*Math.PI?$-=2*Math.PI:$<-Math.PI/2&&($+=2*Math.PI),P.slicedTranslation={translateX:Math.round(Math.cos($)*l),translateY:Math.round(Math.sin($)*l)},S=Math.cos($)*t[2]/2,k=Math.sin($)*t[2]/2,P.tooltipPos=[t[0]+S*.7,t[1]+k*.7],P.half=$<-Math.PI/2||$>Math.PI/2?1:0,P.angle=$,x=Math.min(h,P.labelDistance/5),P.labelPosition={natural:{x:t[0]+S+Math.cos($)*P.labelDistance,y:t[1]+k+Math.sin($)*P.labelDistance},final:{},alignment:P.labelDistance<0?"center":P.half?"right":"left",connectorPosition:{breakAt:{x:t[0]+S+Math.cos($)*x,y:t[1]+k+Math.sin($)*x},touchingSliceAt:{x:t[0]+S,y:t[1]+k}}}}fireEvent$n(n,"afterTranslate")},r.prototype.updateTotals=function(){var t=this.points,n=t.length,s=this.options.ignoreHiddenPoint,a,l,h=0;for(a=0;a<n;a++)l=t[a],l.isValid()&&(!s||l.visible)&&(h+=l.y);for(this.total=h,a=0;a<n;a++)l=t[a],l.percentage=h>0&&(l.visible||!s)?l.y/h*100:0,l.total=h},r.defaultOptions=merge$Z(Series$e.defaultOptions,{center:[null,null],clip:!1,colorByPoint:!0,dataLabels:{allowOverlap:!0,connectorPadding:5,connectorShape:"fixedOffset",crookDistance:"70%",distance:30,enabled:!0,formatter:function(){return this.point.isNull?void 0:this.point.name},softConnector:!0,x:0},fillColor:void 0,ignoreHiddenPoint:!0,inactiveOtherPoints:!0,legendType:"point",marker:null,size:null,showInLegend:!1,slicedOffset:10,stickyTracking:!1,tooltip:{followPointer:!0},borderColor:palette.backgroundColor,borderWidth:1,lineWidth:void 0,states:{hover:{brightness:.1}}}),r}(Series$e);extend$14(PieSeries$3.prototype,{axisTypes:[],directTouch:!0,drawGraph:void 0,drawLegendSymbol:LegendSymbol$1.drawRectangle,drawTracker:ColumnSeries$h.prototype.drawTracker,getCenter:centeredSeriesMixin.getCenter,getSymbol:noop$g,isCartesian:!1,noSharedTooltip:!0,pointAttribs:ColumnSeries$h.prototype.pointAttribs,pointClass:PiePoint$3,requireSorting:!1,searchPoint:noop$g,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("pie",PieSeries$3);var noop$f=H.noop,distribute$1=R.distribute,Series$c=SeriesRegistry$1.series,arrayMax$6=Utilities.arrayMax,clamp$b=Utilities.clamp,defined$A=Utilities.defined,merge$Y=Utilities.merge,pick$14=Utilities.pick,relativeLength$3=Utilities.relativeLength,ColumnDataLabel;(function(o){var r=[],t={radialDistributionY:function(h){return h.top+h.distributeBox.pos},radialDistributionX:function(h,d,c,f){return h.getX(c<d.top+2||c>d.bottom-2?f:c,d.half,d)},justify:function(h,d,c){return c[0]+(h.half?-1:1)*(d+h.labelDistance)},alignToPlotEdges:function(h,d,c,f){var u=h.getBBox().width;return d?u+f:c-u-f},alignToConnectors:function(h,d,c,f){var u=0,p;return h.forEach(function(g){p=g.dataLabel.getBBox().width,p>u&&(u=p)}),d?u+f:c-u-f}};function n(h){if(DataLabel$1.compose(Series$c),r.indexOf(h)===-1){r.push(h);var d=h.prototype;d.dataLabelPositioners=t,d.alignDataLabel=noop$f,d.drawDataLabels=s,d.placeDataLabels=a,d.verifyDataLabelOverflow=l}}o.compose=n;function s(){var h=this,d=h.data,c=h.chart,f=h.options.dataLabels||{},u=f.connectorPadding,p=c.plotWidth,g=c.plotHeight,m=c.plotLeft,v=Math.round(c.chartWidth/3),x=h.center,y=x[2]/2,b=x[1],$=[[],[]],S=[0,0,0,0],k=h.dataLabelPositioners,A,P,E,M,C,O,L,T,_,D,N,I;!h.visible||!f.enabled&&!h._hasPointLabels||(d.forEach(function(B){B.dataLabel&&B.visible&&B.dataLabel.shortened&&(B.dataLabel.attr({width:"auto"}).css({width:"auto",textOverflow:"clip"}),B.dataLabel.shortened=!1)}),Series$c.prototype.drawDataLabels.apply(h),d.forEach(function(B){B.dataLabel&&(B.visible?($[B.half].push(B),B.dataLabel._pos=null,!defined$A(f.style.width)&&!defined$A(B.options.dataLabels&&B.options.dataLabels.style&&B.options.dataLabels.style.width)&&B.dataLabel.getBBox().width>v&&(B.dataLabel.css({width:Math.round(v*.7)+"px"}),B.dataLabel.shortened=!0)):(B.dataLabel=B.dataLabel.destroy(),B.dataLabels&&B.dataLabels.length===1&&delete B.dataLabels))}),$.forEach(function(B,X){var W=B.length,F=[],U,z,V,j,K,nt;if(W)for(h.sortByAngle(B,X-.5),h.maxLabelDistance>0&&(U=Math.max(0,b-y-h.maxLabelDistance),z=Math.min(b+y+h.maxLabelDistance,c.plotHeight),B.forEach(function(q){q.labelDistance>0&&q.dataLabel&&(q.top=Math.max(0,b-y-q.labelDistance),q.bottom=Math.min(b+y+q.labelDistance,c.plotHeight),K=q.dataLabel.getBBox().height||21,q.distributeBox={target:q.labelPosition.natural.y-q.top+K/2,size:K,rank:q.y},F.push(q.distributeBox))}),nt=z+K-U,distribute$1(F,nt,nt/5)),N=0;N<W;N++){if(A=B[N],O=A.labelPosition,M=A.dataLabel,D=A.visible===!1?"hidden":"inherit",V=O.natural.y,_=V,defined$A(A.distributeBox)&&(typeof A.distributeBox.pos>"u"?D="hidden":(L=A.distributeBox.size,_=k.radialDistributionY(A))),delete A.positionIndex,f.justify)T=k.justify(A,y,x);else switch(f.alignTo){case"connectors":T=k.alignToConnectors(B,X,p,m);break;case"plotEdges":T=k.alignToPlotEdges(M,X,p,m);break;default:T=k.radialDistributionX(h,A,_,V)}M._attr={visibility:D,align:O.alignment},I=A.options.dataLabels||{},M._pos={x:T+pick$14(I.x,f.x)+({left:u,right:-u}[O.alignment]||0),y:_+pick$14(I.y,f.y)-10},O.final.x=T,O.final.y=_,pick$14(f.crop,!0)&&(C=M.getBBox().width,j=null,T-C<u&&X===1?(j=Math.round(C-T+u),S[3]=Math.max(j,S[3])):T+C>p-u&&X===0&&(j=Math.round(T+C-p+u),S[1]=Math.max(j,S[1])),_-L/2<0?S[0]=Math.max(Math.round(-_+L/2),S[0]):_+L/2>g&&(S[2]=Math.max(Math.round(_+L/2-g),S[2])),M.sideOverflow=j)}}),(arrayMax$6(S)===0||this.verifyDataLabelOverflow(S))&&(this.placeDataLabels(),this.points.forEach(function(B){if(I=merge$Y(f,B.options.dataLabels),P=pick$14(I.connectorWidth,1),P){var X=void 0;E=B.connector,M=B.dataLabel,M&&M._pos&&B.visible&&B.labelDistance>0?(D=M._attr.visibility,X=!E,X&&(B.connector=E=c.renderer.path().addClass("highcharts-data-label-connector  highcharts-color-"+B.colorIndex+(B.className?" "+B.className:"")).add(h.dataLabelsGroup),c.styledMode||E.attr({"stroke-width":P,stroke:I.connectorColor||B.color||palette.neutralColor60})),E[X?"attr":"animate"]({d:B.getConnectorPath()}),E.attr("visibility",D)):E&&(B.connector=E.destroy())}})))}function a(){this.points.forEach(function(h){var d=h.dataLabel,c;d&&h.visible&&(c=d._pos,c?(d.sideOverflow&&(d._attr.width=Math.max(d.getBBox().width-d.sideOverflow,0),d.css({width:d._attr.width+"px",textOverflow:(this.options.dataLabels.style||{}).textOverflow||"ellipsis"}),d.shortened=!0),d.attr(d._attr),d[d.moved?"animate":"attr"](c),d.moved=!0):d&&d.attr({y:-9999})),delete h.distributeBox},this)}function l(h){var d=this.center,c=this.options,f=c.center,u=c.minSize||80,p=u,g=c.size!==null;return g||(f[0]!==null?p=Math.max(d[2]-Math.max(h[1],h[3]),u):(p=Math.max(d[2]-h[1]-h[3],u),d[0]+=(h[3]-h[1])/2),f[1]!==null?p=clamp$b(p,u,d[2]-Math.max(h[0],h[2])):(p=clamp$b(p,u,d[2]-h[0]-h[2]),d[1]+=(h[0]-h[2])/2),p<d[2]?(d[2]=p,d[3]=Math.min(relativeLength$3(c.innerSize||0,p),p),this.translate(d),this.drawDataLabels&&this.drawDataLabels()):g=!0),g}})(ColumnDataLabel||(ColumnDataLabel={}));const PieDataLabel=ColumnDataLabel;var addEvent$N=Utilities.addEvent,fireEvent$m=Utilities.fireEvent,isArray$b=Utilities.isArray,isNumber$u=Utilities.isNumber,objectEach$g=Utilities.objectEach,pick$13=Utilities.pick;addEvent$N(Chart$1,"render",function(){var r=this,t=[];(this.labelCollectors||[]).forEach(function(n){t=t.concat(n())}),(this.yAxis||[]).forEach(function(n){n.stacking&&n.options.stackLabels&&!n.options.stackLabels.allowOverlap&&objectEach$g(n.stacking.stacks,function(s){objectEach$g(s,function(a){a.label&&a.label.visibility!=="hidden"&&t.push(a.label)})})}),(this.series||[]).forEach(function(n){var s=n.options.dataLabels;if(n.visible&&!(s.enabled===!1&&!n._hasPointLabels)){var a=function(l){return l.forEach(function(h){if(h.visible){var d=isArray$b(h.dataLabels)?h.dataLabels:h.dataLabel?[h.dataLabel]:[];d.forEach(function(c){var f=c.options;c.labelrank=pick$13(f.labelrank,h.labelrank,h.shapeArgs&&h.shapeArgs.height),f.allowOverlap?(c.oldOpacity=c.opacity,c.newOpacity=1,hideOrShow(c,r)):t.push(c)})}})};a(n.nodes||[]),a(n.points)}}),this.hideOverlappingLabels(t)});Chart$1.prototype.hideOverlappingLabels=function(o){var r=this,t=o.length,n=r.renderer,s,a,l,h,d,c,f,u=!1,p=function(m,v){return!(v.x>=m.x+m.width||v.x+v.width<=m.x||v.y>=m.y+m.height||v.y+v.height<=m.y)},g=function(m){var v,x,y,b=m.box?0:m.padding||0,$=0,S=0,k,A;if(m&&(!m.alignAttr||m.placed))return v=m.alignAttr||{x:m.attr("x"),y:m.attr("y")},x=m.parentGroup,m.width||(y=m.getBBox(),m.width=y.width,m.height=y.height,$=n.fontMetrics(null,m.element).h),k=m.width-2*b,A={left:"0",center:"0.5",right:"1"}[m.alignValue],A?S=+A*k:isNumber$u(m.x)&&Math.round(m.x)!==m.translateX&&(S=m.x-m.translateX),{x:v.x+(x.translateX||0)+b-(S||0),y:v.y+(x.translateY||0)+b-$,width:m.width-2*b,height:m.height-2*b}};for(a=0;a<t;a++)s=o[a],s&&(s.oldOpacity=s.opacity,s.newOpacity=1,s.absoluteBox=g(s));for(o.sort(function(m,v){return(v.labelrank||0)-(m.labelrank||0)}),a=0;a<t;a++)for(h=o[a],c=h&&h.absoluteBox,l=a+1;l<t;++l)d=o[l],f=d&&d.absoluteBox,c&&f&&h!==d&&h.newOpacity!==0&&d.newOpacity!==0&&p(c,f)&&((h.labelrank<d.labelrank?h:d).newOpacity=0);o.forEach(function(m){hideOrShow(m,r)&&(u=!0)}),u&&fireEvent$m(r,"afterHideAllOverlappingLabels")};function hideOrShow(o,r){var t,n,s=!1;return o&&(n=o.newOpacity,o.oldOpacity!==n&&(o.alignAttr&&o.placed?(o[n?"removeClass":"addClass"]("highcharts-data-label-hidden"),t=function(){r.styledMode||o.css({pointerEvents:n?"auto":"none"})},s=!0,o.alignAttr.opacity=n,o[o.isOld?"animate":"attr"](o.alignAttr,null,t),fireEvent$m(r,"afterHideOverlappingLabel")):o.attr({opacity:n})),o.isOld=!0),s}var extend$13=Utilities.extend,find$e=Utilities.find,isArray$a=Utilities.isArray,isObject$8=Utilities.isObject,merge$X=Utilities.merge,objectEach$f=Utilities.objectEach,pick$12=Utilities.pick,splat$a=Utilities.splat,uniqueKey$3=Utilities.uniqueKey,Responsive;(function(o){var r=[];function t(s){return r.indexOf(s)===-1&&(r.push(s),extend$13(s.prototype,n.prototype)),s}o.compose=t;var n=function(){function s(){}return s.prototype.currentOptions=function(a){var l=this,h={};function d(c,f,u,p){var g;objectEach$f(c,function(m,v){if(!p&&l.collectionsWithUpdate.indexOf(v)>-1&&f[v])for(m=splat$a(m),u[v]=[],g=0;g<Math.max(m.length,f[v].length);g++)f[v][g]&&(m[g]===void 0?u[v][g]=f[v][g]:(u[v][g]={},d(m[g],f[v][g],u[v][g],p+1)));else isObject$8(m)?(u[v]=isArray$a(m)?[]:{},d(m,f[v]||{},u[v],p+1)):typeof f[v]>"u"?u[v]=null:u[v]=f[v]})}return d(a,this.options,h,0),h},s.prototype.matchResponsiveRule=function(a,l){var h=a.condition,d=h.callback||function(){return this.chartWidth<=pick$12(h.maxWidth,Number.MAX_VALUE)&&this.chartHeight<=pick$12(h.maxHeight,Number.MAX_VALUE)&&this.chartWidth>=pick$12(h.minWidth,0)&&this.chartHeight>=pick$12(h.minHeight,0)};d.call(this)&&l.push(a._id)},s.prototype.setResponsive=function(a,l){var h=this,d=this.options.responsive,c=this.currentResponsive,f=[],u;!l&&d&&d.rules&&d.rules.forEach(function(m){typeof m._id>"u"&&(m._id=uniqueKey$3()),h.matchResponsiveRule(m,f)},this);var p=merge$X.apply(void 0,f.map(function(m){return find$e((d||{}).rules||[],function(v){return v._id===m})}).map(function(m){return m&&m.chartOptions}));p.isResponsiveOptions=!0,f=f.toString()||void 0;var g=c&&c.ruleIds;f!==g&&(c&&this.update(c.undoOptions,a,!0),f?(u=this.currentOptions(p),u.isResponsiveOptions=!0,this.currentResponsive={ruleIds:f,mergedOptions:p,undoOptions:u},this.update(p,a,!0)):this.currentResponsive=void 0)},s}()})(Responsive||(Responsive={}));const Responsive$1=Responsive;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$7=H;G$7.animate=animationExports.animate;G$7.animObject=animationExports.animObject;G$7.getDeferredAnimation=animationExports.getDeferredAnimation;G$7.setAnimation=animationExports.setAnimation;G$7.stop=animationExports.stop;G$7.timers=Fx.timers;G$7.AST=AST;G$7.Axis=Axis;G$7.Chart=Chart$1;G$7.chart=Chart$1.chart;G$7.Fx=Fx;G$7.Legend=Legend;G$7.PlotLineOrBand=PlotLineOrBand;G$7.Point=Point$2;G$7.Pointer=MSPointer.isRequired()?MSPointer:Pointer;G$7.Series=Series$e;G$7.SVGElement=SVGElement;G$7.SVGRenderer=SVGRenderer;G$7.Tick=Tick;G$7.Time=Time;G$7.Tooltip=Tooltip;G$7.Color=Color;G$7.color=Color.parse;HTMLRenderer.compose(SVGRenderer);HTMLElement.compose(SVGElement);G$7.defaultOptions=DefaultOptions.defaultOptions;G$7.getOptions=DefaultOptions.getOptions;G$7.time=DefaultOptions.defaultTime;G$7.setOptions=DefaultOptions.setOptions;G$7.dateFormat=FormatUtilities.dateFormat;G$7.format=FormatUtilities.format;G$7.numberFormat=FormatUtilities.numberFormat;G$7.addEvent=Utilities.addEvent;G$7.arrayMax=Utilities.arrayMax;G$7.arrayMin=Utilities.arrayMin;G$7.attr=Utilities.attr;G$7.clearTimeout=Utilities.clearTimeout;G$7.correctFloat=Utilities.correctFloat;G$7.createElement=Utilities.createElement;G$7.css=Utilities.css;G$7.defined=Utilities.defined;G$7.destroyObjectProperties=Utilities.destroyObjectProperties;G$7.discardElement=Utilities.discardElement;G$7.distribute=R.distribute;G$7.erase=Utilities.erase;G$7.error=Utilities.error;G$7.extend=Utilities.extend;G$7.extendClass=Utilities.extendClass;G$7.find=Utilities.find;G$7.fireEvent=Utilities.fireEvent;G$7.getMagnitude=Utilities.getMagnitude;G$7.getStyle=Utilities.getStyle;G$7.inArray=Utilities.inArray;G$7.isArray=Utilities.isArray;G$7.isClass=Utilities.isClass;G$7.isDOMElement=Utilities.isDOMElement;G$7.isFunction=Utilities.isFunction;G$7.isNumber=Utilities.isNumber;G$7.isObject=Utilities.isObject;G$7.isString=Utilities.isString;G$7.keys=Utilities.keys;G$7.merge=Utilities.merge;G$7.normalizeTickInterval=Utilities.normalizeTickInterval;G$7.objectEach=Utilities.objectEach;G$7.offset=Utilities.offset;G$7.pad=Utilities.pad;G$7.pick=Utilities.pick;G$7.pInt=Utilities.pInt;G$7.relativeLength=Utilities.relativeLength;G$7.removeEvent=Utilities.removeEvent;G$7.seriesType=SeriesRegistry$1.seriesType;G$7.splat=Utilities.splat;G$7.stableSort=Utilities.stableSort;G$7.syncTimeout=Utilities.syncTimeout;G$7.timeUnits=Utilities.timeUnits;G$7.uniqueKey=Utilities.uniqueKey;G$7.useSerialIds=Utilities.useSerialIds;G$7.wrap=Utilities.wrap;ColumnDataLabel$2.compose(ColumnSeries$h);DataLabel$1.compose(Series$e);DateTimeAxis$1.compose(Axis);LogarithmicAxis$1.compose(Axis);PieDataLabel.compose(PieSeries$3);PlotLineOrBand.compose(Axis);Responsive$1.compose(Chart$1);var addEvent$M=Utilities.addEvent,correctFloat$8=Utilities.correctFloat,css$3=Utilities.css,defined$z=Utilities.defined,error$3=Utilities.error,pick$11=Utilities.pick,timeUnits=Utilities.timeUnits,composedClasses=[],OrdinalAxis;(function(o){function r(m,v,x){if(composedClasses.indexOf(m)===-1){composedClasses.push(m);var y=m.prototype;y.getTimeTicks=t,y.index2val=n,y.lin2val=s,y.val2lin=p,y.ordinal2lin=y.val2lin,addEvent$M(m,"afterInit",l),addEvent$M(m,"foundExtremes",h),addEvent$M(m,"afterSetScale",d),addEvent$M(m,"initialAxisTranslation",c)}return composedClasses.indexOf(x)===-1&&(composedClasses.push(x),addEvent$M(x,"pan",f)),composedClasses.indexOf(v)===-1&&(composedClasses.push(v),addEvent$M(v,"updatedData",u)),m}o.compose=r;function t(m,v,x,y,b,$,S){b===void 0&&(b=[]),$===void 0&&($=0);var k={},A=this.options.tickPixelInterval,P=this.chart.time,E=[],M,C,O,L,T,_=0,D=[],N=-Number.MAX_VALUE;if(!this.options.ordinal&&!this.options.breaks||!b||b.length<3||typeof v>"u")return P.getTimeTicks.apply(P,arguments);var I=b.length;for(M=0;M<I;M++){if(T=M&&b[M-1]>x,b[M]<v&&(_=M),M===I-1||b[M+1]-b[M]>$*5||T){if(b[M]>N){for(C=P.getTimeTicks(m,b[_],b[M],y);C.length&&C[0]<=N;)C.shift();C.length&&(N=C[C.length-1]),E.push(D.length),D=D.concat(C)}_=M+1}if(T)break}if(C){if(L=C.info,S&&L.unitRange<=timeUnits.hour){for(M=D.length-1,_=1;_<M;_++)P.dateFormat("%d",D[_])!==P.dateFormat("%d",D[_-1])&&(k[D[_]]="day",O=!0);O&&(k[D[0]]="day"),L.higherRanks=k}L.segmentStarts=E,D.info=L}else error$3(12,!1,this.chart);if(S&&defined$z(A)){for(var B=D.length,X=[],W=[],F=void 0,U=void 0,z=void 0,V=void 0,j=void 0,K=B;K--;)U=this.translate(D[K]),z&&(W[K]=z-U),X[K]=z=U;for(W.sort(),V=W[Math.floor(W.length/2)],V<A*.6&&(V=null),K=D[B-1]>x?B-1:B,z=void 0;K--;)U=X[K],j=Math.abs(z-U),z&&j<A*.8&&(V===null||j<V*.8)?(k[D[K]]&&!k[D[K+1]]?(F=K+1,z=U):F=K,D.splice(F,1)):z=U}return D}function n(m){var v=this,x=v.ordinal,y=x.positions;if(!y)return m;var b=y.length-1,$;return m<0?m=y[0]:m>b?m=y[b]:(b=Math.floor(m),$=m-b),typeof $<"u"&&typeof y[b]<"u"?y[b]+($?$*(y[b+1]-y[b]):0):m}function s(m){var v=this,x=v.ordinal,y=v.old?v.old.min:v.min,b=v.old?v.old.transA:v.transA,$=x.positions;if(!$)return m;var S=(m-y)*b+v.minPixelPadding,k=S>0&&S<v.left+v.len;if(k||(x.extendedOrdinalPositions||(x.extendedOrdinalPositions=x.getExtendedPositions()),$=x.extendedOrdinalPositions),$&&$.length){var A=x.getIndexOfPoint(S,$),P=correctFloat$8(A%1);if(A>=0&&A<$.length){var E=$[Math.floor(A)],M=$[Math.ceil(A)],C=M-E;return $[Math.floor(A)]+P*C}var O=$.length,L=$[0],T=$[O-1],_=(T-L)/(O-1);return A<0?L+_*A:T+_*(A-O)}return m}function a(m,v){var x=o.Additions.findIndexOf(m,v,!0);if(m[x]===v)return x;var y=(v-m[x])/(m[x+1]-m[x]);return x+y}function l(){var m=this;m.ordinal||(m.ordinal=new o.Additions(m))}function h(){var m=this;m.isXAxis&&defined$z(m.options.overscroll)&&m.max===m.dataMax&&(!m.chart.mouseIsDown||m.isInternal)&&(!m.eventArgs||m.eventArgs&&m.eventArgs.trigger!=="navigator")&&(m.max+=m.options.overscroll,!m.isInternal&&defined$z(m.userMin)&&(m.min+=m.options.overscroll))}function d(){var m=this;m.horiz&&!m.isDirty&&(m.isDirty=m.isOrdinal&&m.chart.navigator&&!m.chart.navigator.adaptToUpdatedData)}function c(){var m=this;m.ordinal&&(m.ordinal.beforeSetTickPositions(),m.tickInterval=m.ordinal.postProcessTickInterval(m.tickInterval))}function f(m){var v=this,x=v.xAxis[0],y=x.options.overscroll,b=m.originalEvent.chartX,$=v.options.chart.panning,S=!1;if($&&$.type!=="y"&&x.options.ordinal&&x.series.length){var k=v.mouseDownX,A=x.getExtremes(),P=A.dataMax,E=A.min,M=A.max,C=v.hoverPoints,O=x.closestPointRange||x.ordinal&&x.ordinal.overscrollPointsRange,L=x.translationSlope*(x.ordinal.slope||O),T=(k-b)/L,_={ordinal:{positions:x.ordinal.getExtendedPositions()}},D=x.index2val,N=x.val2lin,I=void 0,B=void 0,X=void 0,W=void 0;_.ordinal.positions?Math.abs(T)>1&&(C&&C.forEach(function(F){F.setState()}),T<0?(X=_,W=x.ordinal.positions?x:_):(X=x.ordinal.positions?x:_,W=_),B=W.ordinal.positions,P>B[B.length-1]&&B.push(P),v.fixedRange=M-E,I=x.navigatorAxis.toFixedRange(null,null,D.apply(X,[N.apply(X,[E,!0])+T]),D.apply(W,[N.apply(W,[M,!0])+T])),I.min>=Math.min(A.dataMin,E)&&I.max<=Math.max(P,M)+y&&x.setExtremes(I.min,I.max,!0,!1,{trigger:"pan"}),v.mouseDownX=b,css$3(v.container,{cursor:"move"})):S=!0}else S=!0;S||$&&/y/.test($.type)?y&&(x.max=x.dataMax+y):m.preventDefault()}function u(){var m=this.xAxis;m&&m.options.ordinal&&(delete m.ordinal.index,delete m.ordinal.extendedOrdinalPositions)}function p(m,v){var x=this,y=x.ordinal,b=y.positions,$=y.slope,S=y.extendedOrdinalPositions;if(!b)return m;var k=b.length,A;if(b[0]<=m&&b[k-1]>=m)A=a(b,m);else{if(S||(S=y.getExtendedPositions&&y.getExtendedPositions(),y.extendedOrdinalPositions=S),!(S&&S.length))return m;var P=S.length;$||($=(S[P-1]-S[0])/P);var E=a(S,b[0]);if(m>=S[0]&&m<=S[P-1])A=a(S,m)-E;else if(m<S[0]){var M=S[0]-m,C=M/$;A=-E-C}else{var M=m-S[P-1],C=M/$;A=C+P-E}}return v?A:$*(A||0)+y.offset}var g=function(){function m(v){this.index={},this.axis=v}return m.prototype.beforeSetTickPositions=function(){var v=this.axis,x=v.ordinal,y=v.getExtremes(),b=y.min,$=y.max,S=v.isXAxis&&!!v.options.breaks,k=v.options.ordinal,A=v.chart.options.chart.ignoreHiddenSeries,P,E,M,C,O,L,T,_,D=[],N=Number.MAX_VALUE,I=!1;if(k||S){if(v.series.forEach(function(B,X){if(E=[],(!A||B.visible!==!1)&&(B.takeOrdinalPosition!==!1||S)&&(D=D.concat(B.processedXData),P=D.length,D.sort(function(W,F){return W-F}),N=Math.min(N,pick$11(B.closestPointRange,N)),P)){for(X=0;X<P-1;)D[X]!==D[X+1]&&E.push(D[X+1]),X++;E[0]!==D[0]&&E.unshift(D[0]),D=E}B.isSeriesBoosting&&(_=!0)}),_&&(D.length=0),P=D.length,P>2){for(M=D[1]-D[0],T=P-1;T--&&!I;)D[T+1]-D[T]!==M&&(I=!0);!v.options.keepOrdinalPadding&&(D[0]-b>M||$-D[D.length-1]>M)&&(I=!0)}else v.options.overscroll&&(P===2?N=D[1]-D[0]:P===1?(N=v.options.overscroll,D=[D[0],D[0]+N]):N=x.overscrollPointsRange);I||v.forceOrdinal?(v.options.overscroll&&(x.overscrollPointsRange=N,D=D.concat(x.getOverscrollPositions())),x.positions=D,C=v.ordinal2lin(Math.max(b,D[0]),!0),O=Math.max(v.ordinal2lin(Math.min($,D[D.length-1]),!0),1),x.slope=L=($-b)/(O-C),x.offset=b-C*L):(x.overscrollPointsRange=pick$11(v.closestPointRange,x.overscrollPointsRange),x.positions=v.ordinal.slope=x.offset=void 0)}v.isOrdinal=k&&I,x.groupIntervalFactor=null},m.findIndexOf=function(v,x,y){for(var b=0,$=v.length-1,S;b<$;)S=Math.ceil((b+$)/2),v[S]<=x?b=S:$=S-1;return v[b]===x||y?b:-1},m.prototype.getExtendedPositions=function(){var v=this,x=v.axis,y=x.constructor.prototype,b=x.chart,$=x.series[0].currentDataGrouping,S=$?$.count+$.unitName:"raw",k=x.options.overscroll,A=x.getExtremes(),P,E=void 0,M=v.index;return M||(M=v.index={}),M[S]||(P={series:[],chart:b,forceOrdinal:!1,getExtremes:function(){return{min:A.dataMin,max:A.dataMax+k}},getGroupPixelWidth:y.getGroupPixelWidth,getTimeTicks:y.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},ordinal2lin:y.ordinal2lin,getIndexOfPoint:y.getIndexOfPoint,val2lin:y.val2lin},P.ordinal.axis=P,x.series.forEach(function(C){E={xAxis:P,xData:C.xData.slice(),chart:b,destroyGroupedData:H.noop,getProcessedData:Series$e.prototype.getProcessedData,applyGrouping:Series$e.prototype.applyGrouping},E.xData=E.xData.concat(v.getOverscrollPositions()),E.options={dataGrouping:$?{firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",enabled:!0,forced:!0,approximation:"open",units:[[$.unitName,[$.count]]]}:{enabled:!1}},P.series.push(E),C.processData.apply(E)}),x.applyGrouping.call(P),E.closestPointRange!==E.basePointRange&&E.currentDataGrouping&&(P.forceOrdinal=!0),x.ordinal.beforeSetTickPositions.apply({axis:P}),M[S]=P.ordinal.positions),M[S]},m.prototype.getGroupIntervalFactor=function(v,x,y){var b=this;b.axis;var $=y.processedXData,S=$.length,k=[],A,P,E=b.groupIntervalFactor;if(!E){for(P=0;P<S-1;P++)k[P]=$[P+1]-$[P];k.sort(function(M,C){return M-C}),A=k[Math.floor(S/2)],v=Math.max(v,$[0]),x=Math.min(x,$[S-1]),b.groupIntervalFactor=E=S*A/(x-v)}return E},m.prototype.getIndexOfPoint=function(v,x){var y=this,b=y.axis,$=y.positions?y.positions[0]:0,S=b.series[0].points&&b.series[0].points[0]&&b.series[0].points[0].plotX||b.minPixelPadding;b.series.length>1&&b.series.forEach(function(P){defined$z(P.points[0])&&defined$z(P.points[0].plotX)&&P.points[0].plotX<S&&(S=P.points[0].plotX)});var k=b.translationSlope*(y.slope||b.closestPointRange||y.overscrollPointsRange),A=(v-S)/k;return m.findIndexOf(x,$)+A},m.prototype.getOverscrollPositions=function(){var v=this,x=v.axis,y=x.options.overscroll,b=v.overscrollPointsRange,$=[],S=x.dataMax;if(defined$z(b))for(;S<=x.dataMax+y;)S+=b,$.push(S);return $},m.prototype.postProcessTickInterval=function(v){var x=this,y=x.axis,b=x.slope,$;return b?y.options.breaks?$=y.closestPointRange||v:$=v/(b/y.closestPointRange):$=v,$},m}();o.Additions=g})(OrdinalAxis||(OrdinalAxis={}));const OrdinalAxis$1=OrdinalAxis;var addEvent$L=Utilities.addEvent,find$d=Utilities.find,fireEvent$l=Utilities.fireEvent,isArray$9=Utilities.isArray,isNumber$t=Utilities.isNumber,pick$10=Utilities.pick,BrokenAxis;(function(o){var r=[];function t(p,g){if(r.indexOf(p)===-1&&(r.push(p),p.keepProps.push("brokenAxis"),addEvent$L(p,"init",l),addEvent$L(p,"afterInit",n),addEvent$L(p,"afterSetTickPositions",a),addEvent$L(p,"afterSetOptions",s)),r.indexOf(g)===-1){r.push(g);var m=g.prototype;m.drawBreaks=c,m.gappedPath=f,addEvent$L(g,"afterGeneratePoints",h),addEvent$L(g,"afterRender",d)}return p}o.compose=t;function n(){typeof this.brokenAxis<"u"&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function s(){var p=this;p.brokenAxis&&p.brokenAxis.hasBreaks&&(p.options.ordinal=!1)}function a(){var p=this,g=p.brokenAxis;if(g&&g.hasBreaks){for(var m=p.tickPositions,v=p.tickPositions.info,x=[],y=0;y<m.length;y++)g.isInAnyBreak(m[y])||x.push(m[y]);p.tickPositions=x,p.tickPositions.info=v}}function l(){var p=this;p.brokenAxis||(p.brokenAxis=new u(p))}function h(){var p=this,g=p.isDirty,m=p.options.connectNulls,v=p.points,x=p.xAxis,y=p.yAxis;if(g)for(var b=v.length;b--;){var $=v[b],S=$.y===null&&m===!1,k=!S&&(x&&x.brokenAxis&&x.brokenAxis.isInAnyBreak($.x,!0)||y&&y.brokenAxis&&y.brokenAxis.isInAnyBreak($.y,!0));$.visible=k?!1:$.options.visible!==!1}}function d(){this.drawBreaks(this.xAxis,["x"]),this.drawBreaks(this.yAxis,pick$10(this.pointArrayMap,["y"]))}function c(p,g){var m=this,v=m.points,x,y,b,$;if(p&&p.brokenAxis&&p.brokenAxis.hasBreaks){var S=p.brokenAxis;g.forEach(function(k){x=S&&S.breakArray||[],y=p.isXAxis?p.min:pick$10(m.options.threshold,p.min),v.forEach(function(A){$=pick$10(A["stack"+k.toUpperCase()],A[k]),x.forEach(function(P){isNumber$t(y)&&isNumber$t($)&&(b=!1,y<P.from&&$>P.to||y>P.from&&$<P.from?b="pointBreak":(y<P.from&&$>P.from&&$<P.to||y>P.from&&$>P.to&&$<P.from)&&(b="pointInBreak"),b&&fireEvent$l(p,b,{point:A,brk:P}))})})})}}function f(){var p=this.currentDataGrouping,g=p&&p.gapSize,m=this.points.slice(),v=this.yAxis,x=this.options.gapSize,y=m.length-1,b;if(x&&y>0){this.options.gapUnit!=="value"&&(x*=this.basePointRange),g&&g>x&&g>=this.basePointRange&&(x=g);for(var $=void 0,S=void 0;y--;)if(S&&S.visible!==!1||(S=m[y+1]),$=m[y],!(S.visible===!1||$.visible===!1)){if(S.x-$.x>x){var k=($.x+S.x)/2;m.splice(y+1,0,{isNull:!0,x:k}),v.stacking&&this.options.stacking&&(b=v.stacking.stacks[this.stackKey][k]=new StackItem$1(v,v.options.stackLabels,!1,k,this.stack),b.total=0)}S=$}}return this.getGraphPath(m)}var u=function(){function p(g){this.hasBreaks=!1,this.axis=g}return p.isInBreak=function(g,m){var v=g.repeat||1/0,x=g.from,y=g.to-g.from,b=m>=x?(m-x)%v:v-(x-m)%v,$;return g.inclusive?$=b<=y:$=b<y&&b!==0,$},p.lin2Val=function(g){var m=this,v=m.brokenAxis,x=v&&v.breakArray;if(!x||!isNumber$t(g))return g;var y=g,b,$;for($=0;$<x.length&&(b=x[$],!(b.from>=y));$++)(b.to<y||p.isInBreak(b,y))&&(y+=b.len);return y},p.val2Lin=function(g){var m=this,v=m.brokenAxis,x=v&&v.breakArray;if(!x||!isNumber$t(g))return g;var y=g,b,$;for($=0;$<x.length;$++)if(b=x[$],b.to<=g)y-=b.len;else{if(b.from>=g)break;if(p.isInBreak(b,g)){y-=g-b.from;break}}return y},p.prototype.findBreakAt=function(g,m){return find$d(m,function(v){return v.from<g&&g<v.to})},p.prototype.isInAnyBreak=function(g,m){var v=this,x=v.axis,y=x.options.breaks||[],b=y.length,$,S,k;if(b&&isNumber$t(g)){for(;b--;)p.isInBreak(y[b],g)&&($=!0,S||(S=pick$10(y[b].showPoints,!x.isXAxis)));$&&m?k=$&&!S:k=$}return k},p.prototype.setBreaks=function(g,m){var v=this,x=v.axis,y=isArray$9(g)&&!!g.length;x.isDirty=v.hasBreaks!==y,v.hasBreaks=y,x.options.breaks=x.userOptions.breaks=g,x.forceRedraw=!0,x.series.forEach(function(b){b.isDirty=!0}),!y&&x.val2lin===p.val2Lin&&(delete x.val2lin,delete x.lin2val),y&&(x.userOptions.ordinal=!1,x.lin2val=p.lin2Val,x.val2lin=p.val2Lin,x.setExtremes=function(b,$,S,k,A){if(v.hasBreaks){for(var P=this.options.breaks||[],E=void 0;E=v.findBreakAt(b,P);)b=E.to;for(;E=v.findBreakAt($,P);)$=E.from;$<b&&($=b)}x.constructor.prototype.setExtremes.call(this,b,$,S,k,A)},x.setAxisTranslation=function(){if(x.constructor.prototype.setAxisTranslation.call(this),v.unitLength=void 0,v.hasBreaks){var b=x.options.breaks||[],$=[],S=[],k=pick$10(x.pointRangePadding,0),A=0,P,E,M=x.userMin||x.min,C=x.userMax||x.max,O,L;b.forEach(function(T){E=T.repeat||1/0,isNumber$t(M)&&isNumber$t(C)&&(p.isInBreak(T,M)&&(M+=T.to%E-M%E),p.isInBreak(T,C)&&(C-=C%E-T.from%E))}),b.forEach(function(T){if(O=T.from,E=T.repeat||1/0,isNumber$t(M)&&isNumber$t(C)){for(;O-E>M;)O-=E;for(;O<M;)O+=E;for(L=O;L<C;L+=E)$.push({value:L,move:"in"}),$.push({value:L+T.to-T.from,move:"out",size:T.breakSize})}}),$.sort(function(T,_){return T.value===_.value?(T.move==="in"?0:1)-(_.move==="in"?0:1):T.value-_.value}),P=0,O=M,$.forEach(function(T){P+=T.move==="in"?1:-1,P===1&&T.move==="in"&&(O=T.value),P===0&&isNumber$t(O)&&(S.push({from:O,to:T.value,len:T.value-O-(T.size||0)}),A+=T.value-O-(T.size||0))}),v.breakArray=S,isNumber$t(M)&&isNumber$t(C)&&isNumber$t(x.min)&&(v.unitLength=C-M-A+k,fireEvent$l(x,"afterBreaks"),x.staticScale?x.transA=x.staticScale:v.unitLength&&(x.transA*=(C-x.min+k)/v.unitLength),k&&(x.minPixelPadding=x.transA*(x.minPointOffset||0)),x.min=M,x.max=C)}}),pick$10(m,!0)&&x.chart.redraw()},p}();o.Additions=u})(BrokenAxis||(BrokenAxis={}));const BrokenAxis$1=BrokenAxis;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/broken-axis
 * @requires highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$6=H;BrokenAxis$1.compose(G$6.Axis,G$6.Series);var format$7=FormatUtilities.format,seriesProto$3=Series$e.prototype,addEvent$K=Utilities.addEvent,arrayMax$5=Utilities.arrayMax,arrayMin$5=Utilities.arrayMin,correctFloat$7=Utilities.correctFloat,defined$y=Utilities.defined,error$2=Utilities.error,extend$12=Utilities.extend,isNumber$s=Utilities.isNumber,merge$W=Utilities.merge,pick$$=Utilities.pick,approximations=H.approximations={sum:function(o){var r=o.length,t;if(!r&&o.hasNulls)t=null;else if(r)for(t=0;r--;)t+=o[r];return t},average:function(o){var r=o.length,t=approximations.sum(o);return isNumber$s(t)&&r&&(t=correctFloat$7(t/r)),t},averages:function(){var o=[];return[].forEach.call(arguments,function(r){o.push(approximations.average(r))}),typeof o[0]>"u"?void 0:o},open:function(o){return o.length?o[0]:o.hasNulls?null:void 0},high:function(o){return o.length?arrayMax$5(o):o.hasNulls?null:void 0},low:function(o){return o.length?arrayMin$5(o):o.hasNulls?null:void 0},close:function(o){return o.length?o[o.length-1]:o.hasNulls?null:void 0},ohlc:function(o,r,t,n){if(o=approximations.open(o),r=approximations.high(r),t=approximations.low(t),n=approximations.close(n),isNumber$s(o)||isNumber$s(r)||isNumber$s(t)||isNumber$s(n))return[o,r,t,n]},range:function(o,r){if(o=approximations.low(o),r=approximations.high(r),isNumber$s(o)||isNumber$s(r))return[o,r];if(o===null&&r===null)return null}},applyGrouping=function(){var o=this,r=o.chart,t=o.options,n=t.dataGrouping,s=o.allowDG!==!1&&n&&pick$$(n.enabled,r.options.isStock),a=o.visible||!r.options.chart.ignoreHiddenSeries,l,h,d=this.currentDataGrouping,c,f,u=!1;if(s&&!o.requireSorting&&(o.requireSorting=u=!0),h=skipDataGrouping(o)||!s,u&&(o.requireSorting=!1),!h){o.destroyGroupedData();var p=void 0,g=n.groupAll?o.xData:o.processedXData,m=n.groupAll?o.yData:o.processedYData,v=r.plotSizeX,x=o.xAxis,y=x.options.ordinal,b=o.groupPixelWidth;if(b&&g&&g.length){l=!0,o.isDirty=!0,o.points=null;var $=x.getExtremes(),S=$.min,k=$.max,A=y&&x.ordinal&&x.ordinal.getGroupIntervalFactor(S,k,o)||1,P=b*(k-S)/v*A,E=x.getTimeTicks(DateTimeAxis$1.Additions.prototype.normalizeTimeTickInterval(P,n.units||defaultDataGroupingUnits),Math.min(S,g[0]),Math.max(k,g[g.length-1]),x.options.startOfWeek,g,o.closestPointRange),M=seriesProto$3.groupData.apply(o,[g,m,E,n.approximation]),C=M.groupedXData,O=M.groupedYData,L=0;for(n&&n.smoothed&&C.length&&(n.firstAnchor="firstPoint",n.anchor="middle",n.lastAnchor="lastPoint",error$2(32,!1,r,{"dataGrouping.smoothed":"use dataGrouping.anchor"})),anchorPoints(o,C,k),p=1;p<E.length;p++)(!E.info.segmentStarts||E.info.segmentStarts.indexOf(p)===-1)&&(L=Math.max(E[p]-E[p-1],L));c=E.info,c.gapSize=L,o.closestPointRange=E.info.totalRange,o.groupMap=M.groupMap,a&&adjustExtremes(x,C),n.groupAll&&(o.allGroupedData=O,f=o.cropData(C,O,x.min,x.max,1),C=f.xData,O=f.yData,o.cropStart=f.start),o.processedXData=C,o.processedYData=O}else o.groupMap=null;o.hasGroupedData=l,o.currentDataGrouping=c,o.preventGraphAnimation=(d&&d.totalRange)!==(c&&c.totalRange)}},skipDataGrouping=function(o){if(o.isCartesian&&!o.isDirty&&!o.xAxis.isDirty&&!o.yAxis.isDirty)return!1},groupData=function(o,r,t,n){var s=this,a=s.data,l=s.options&&s.options.data,h=[],d=[],c=[],f=o.length,u,p,g,m=!!r,v=[],x,y=s.pointArrayMap,b=y&&y.length,$=["x"].concat(y||["y"]),S=this.options.dataGrouping&&this.options.dataGrouping.groupAll,k=0,A=0,P,E,M;function C(_){return typeof _=="function"?_:approximations[_]?approximations[_]:approximations[s.getDGApproximation&&s.getDGApproximation()||"average"]}for(x=C(n),b?y.forEach(function(){v.push([])}):v.push([]),P=b||1,E=0;E<=f&&!(o[E]>=t[0]);E++);for(E;E<=f;E++){for(;typeof t[k+1]<"u"&&o[E]>=t[k+1]||E===f;){for(u=t[k],s.dataGroupInfo={start:S?A:s.cropStart+A,length:v[0].length},g=x.apply(s,v),s.pointClass&&!defined$y(s.dataGroupInfo.options)&&(s.dataGroupInfo.options=merge$W(s.pointClass.prototype.optionsToObject.call({series:s},s.options.data[s.cropStart+A])),$.forEach(function(_){delete s.dataGroupInfo.options[_]})),typeof g<"u"&&(h.push(u),d.push(g),c.push(s.dataGroupInfo)),A=E,M=0;M<P;M++)v[M].length=0,v[M].hasNulls=!1;if(k+=1,E===f)break}if(E===f)break;if(y){var O=s.options.dataGrouping&&s.options.dataGrouping.groupAll?E:s.cropStart+E,L=a&&a[O]||s.pointClass.prototype.applyOptions.apply({series:s},[l[O]]),T=void 0;for(M=0;M<b;M++)T=L[y[M]],isNumber$s(T)?v[M].push(T):T===null&&(v[M].hasNulls=!0)}else p=m?r[E]:null,isNumber$s(p)?v[0].push(p):p===null&&(v[0].hasNulls=!0)}return{groupedXData:h,groupedYData:d,groupMap:c}},anchorPoints=function(o,r,t){var n=o.options,s=n.dataGrouping,a=o.currentDataGrouping&&o.currentDataGrouping.gapSize,l;if(s&&o.xData&&a&&o.groupMap){var h=r.length-1,d=s.anchor,c=pick$$(s.firstAnchor,d),f=pick$$(s.lastAnchor,d);if(d&&d!=="start"){var u=a*{middle:.5,end:1}[d];for(l=r.length-1;l--&&l>0;)r[l]+=u}if(c&&c!=="start"&&o.xData[0]>=r[0]){var p=o.groupMap[0].start,g=o.groupMap[0].length,m=void 0;isNumber$s(p)&&isNumber$s(g)&&(m=p+(g-1)),r[0]={middle:r[0]+.5*a,end:r[0]+a,firstPoint:o.xData[0],lastPoint:m&&o.xData[m]}[c]}if(f&&f!=="start"&&a&&r[h]>=t-a){var v=o.groupMap[o.groupMap.length-1].start;r[h]={middle:r[h]+.5*a,end:r[h]+a,firstPoint:v&&o.xData[v],lastPoint:o.xData[o.xData.length-1]}[f]}}},adjustExtremes=function(o,r){defined$y(r[0])&&isNumber$s(o.min)&&isNumber$s(o.dataMin)&&r[0]<o.min&&((!defined$y(o.options.min)&&o.min<=o.dataMin||o.min===o.dataMin)&&(o.min=Math.min(r[0],o.min)),o.dataMin=Math.min(r[0],o.dataMin)),defined$y(r[r.length-1])&&isNumber$s(o.max)&&isNumber$s(o.dataMax)&&r[r.length-1]>o.max&&((!defined$y(o.options.max)&&isNumber$s(o.dataMax)&&o.max>=o.dataMax||o.max===o.dataMax)&&(o.max=Math.max(r[r.length-1],o.max)),o.dataMax=Math.max(r[r.length-1],o.dataMax))},dataGrouping={approximations,groupData};seriesProto$3.processData;var baseGeneratePoints=seriesProto$3.generatePoints,commonOptions={groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S","%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},specificOptions={line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},defaultDataGroupingUnits=H.defaultDataGroupingUnits=[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]];seriesProto$3.getDGApproximation=function(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("column")?"sum":"average"};seriesProto$3.groupData=groupData;seriesProto$3.applyGrouping=applyGrouping;seriesProto$3.destroyGroupedData=function(){this.groupedData&&(this.groupedData.forEach(function(o,r){o&&(this.groupedData[r]=o.destroy?o.destroy():null)},this),this.groupedData.length=0)};seriesProto$3.generatePoints=function(){baseGeneratePoints.apply(this),this.destroyGroupedData(),this.groupedData=this.hasGroupedData?this.points:null};Axis.prototype.applyGrouping=function(){var o=this,r=o.series;r.forEach(function(t){t.groupPixelWidth=void 0,t.groupPixelWidth=o.getGroupPixelWidth&&o.getGroupPixelWidth(),t.groupPixelWidth&&(t.hasProcessed=!0),t.applyGrouping()})};Axis.prototype.getGroupPixelWidth=function(){var o=this.series,r=o.length,t,n=0,s=!1,a,l;for(t=r;t--;)l=o[t].options.dataGrouping,l&&(n=Math.max(n,pick$$(l.groupPixelWidth,commonOptions.groupPixelWidth)));for(t=r;t--;)l=o[t].options.dataGrouping,l&&(a=(o[t].processedXData||o[t].data).length,(o[t].groupPixelWidth||a>this.chart.plotSizeX/n||a&&l.forced)&&(s=!0));return s?n:0};Axis.prototype.setDataGrouping=function(o,r){var t=this,n;if(r=pick$$(r,!0),o||(o={forced:!1,units:null}),this instanceof Axis)for(n=this.series.length;n--;)this.series[n].update({dataGrouping:o},!1);else this.chart.options.series.forEach(function(s){s.dataGrouping=o},!1);t.ordinal&&(t.ordinal.slope=void 0),r&&this.chart.redraw()};addEvent$K(Axis,"postProcessData",Axis.prototype.applyGrouping);addEvent$K(Point$2,"update",function(){if(this.dataGroup)return error$2(24,!1,this.series.chart),!1});addEvent$K(Tooltip,"headerFormatter",function(o){var r=this.chart,t=r.time,n=o.labelConfig,s=n.series,a=s.options,l=s.tooltipOptions,h=a.dataGrouping,d=l.xDateFormat,c,f=s.xAxis,u,p,g,m,v=l[o.isFooter?"footerFormat":"headerFormat"];f&&f.options.type==="datetime"&&h&&isNumber$s(n.key)&&(u=s.currentDataGrouping,p=h.dateTimeLabelFormats||commonOptions.dateTimeLabelFormats,u?(g=p[u.unitName],u.count===1?d=g[0]:(d=g[1],c=g[2])):!d&&p&&f.dateTime&&(d=f.dateTime.getXDateFormat(n.x,l.dateTimeLabelFormats)),m=t.dateFormat(d,n.key),c&&(m+=t.dateFormat(c,n.key+u.totalRange-1)),s.chart.styledMode&&(v=this.styledModeFormat(v)),o.text=format$7(v,{point:extend$12(n.point,{key:m}),series:s},r),o.preventDefault())});addEvent$K(Series$e,"destroy",seriesProto$3.destroyGroupedData);addEvent$K(Series$e,"afterSetOptions",function(o){var r=o.options,t=this.type,n=this.chart.options.plotOptions,s=DefaultOptions.defaultOptions.plotOptions[t].dataGrouping,a=this.useCommonDataGrouping&&commonOptions;if(specificOptions[t]||a){s||(s=merge$W(commonOptions,specificOptions[t]));var l=this.chart.rangeSelector;r.dataGrouping=merge$W(a,s,n.series&&n.series.dataGrouping,n[t].dataGrouping,this.userOptions.dataGrouping,!r.isInternal&&l&&isNumber$s(l.selected)&&l.buttonOptions[l.selected].dataGrouping)}});addEvent$K(Axis,"afterSetScale",function(){this.series.forEach(function(o){o.hasProcessed=!1})});H.dataGrouping=dataGrouping;var __extends$L=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),ColumnSeries$g=SeriesRegistry$1.seriesTypes.column,OHLCPoint=function(o){__extends$L(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.close=void 0,t.high=void 0,t.low=void 0,t.open=void 0,t.options=void 0,t.plotClose=void 0,t.plotOpen=void 0,t.series=void 0,t}return r.prototype.getClassName=function(){return o.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")},r.prototype.resolveUpColor=function(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)},r.prototype.resolveColor=function(){o.prototype.resolveColor.call(this),this.resolveUpColor()},r.prototype.getZone=function(){var t=o.prototype.getZone.call(this);return this.resolveUpColor(),t},r.prototype.applyOptions=function(){return o.prototype.applyOptions.apply(this,arguments),this.resolveColor&&this.resolveColor(),this},r}(ColumnSeries$g.prototype.pointClass),__extends$K=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),ColumnSeries$f=SeriesRegistry$1.seriesTypes.column,extend$11=Utilities.extend,merge$V=Utilities.merge,OHLCSeries$1=function(o){__extends$K(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t.yData=void 0,t}return r.prototype.drawPoints=function(){var t=this,n=t.points,s=t.chart,a=function(l,h,d){var c=l[0],f=l[1];typeof c[2]=="number"&&(c[2]=Math.max(d+h,c[2])),typeof f[2]=="number"&&(f[2]=Math.min(d-h,f[2]))};n.forEach(function(l){var h,d,c,f,u,p=l.graphic,g,m=!p,v;typeof l.plotY<"u"&&(p||(l.graphic=p=s.renderer.path().add(t.group)),s.styledMode||p.attr(t.pointAttribs(l,l.selected&&"select")),v=p.strokeWidth(),c=v%2/2,g=Math.round(l.plotX)-c,f=Math.round(l.shapeArgs.width/2),u=[["M",g,Math.round(l.yBottom)],["L",g,Math.round(l.plotHigh)]],l.open!==null&&(h=Math.round(l.plotOpen)+c,u.push(["M",g,h],["L",g-f,h]),a(u,v/2,h)),l.close!==null&&(d=Math.round(l.plotClose)+c,u.push(["M",g,d],["L",g+f,d]),a(u,v/2,d)),p[m?"attr":"animate"]({d:u}).addClass(l.getClassName(),!0))})},r.prototype.init=function(){o.prototype.init.apply(this,arguments),this.options.stacking=void 0},r.prototype.pointAttribs=function(t,n){var s=o.prototype.pointAttribs.call(this,t,n),a=this.options;return delete s.fill,!t.options.color&&a.upColor&&t.open<t.close&&(s.stroke=a.upColor),s},r.prototype.toYData=function(t){return[t.open,t.high,t.low,t.close]},r.prototype.translate=function(){var t=this,n=t.yAxis,s=!!t.modifyValue,a=["plotOpen","plotHigh","plotLow","plotClose","yBottom"];o.prototype.translate.apply(t),t.points.forEach(function(l){[l.open,l.high,l.low,l.close,l.low].forEach(function(h,d){h!==null&&(s&&(h=t.modifyValue(h)),l[a[d]]=n.toPixels(h,!0))}),l.tooltipPos[1]=l.plotHigh+n.pos-t.chart.plotTop})},r.defaultOptions=merge$V(ColumnSeries$f.defaultOptions,{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0}),r}(ColumnSeries$f);extend$11(OHLCSeries$1.prototype,{animate:null,directTouch:!1,pointArrayMap:["open","high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"});OHLCSeries$1.prototype.pointClass=OHLCPoint;SeriesRegistry$1.registerSeriesType("ohlc",OHLCSeries$1);var __extends$J=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),defaultOptions$8=DefaultOptions.defaultOptions,_a$d=SeriesRegistry$1.seriesTypes,ColumnSeries$e=_a$d.column,OHLCSeries=_a$d.ohlc,merge$U=Utilities.merge,CandlestickSeries=function(o){__extends$J(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.pointAttribs=function(t,n){var s=ColumnSeries$e.prototype.pointAttribs.call(this,t,n),a=this.options,l=t.open<t.close,h=a.lineColor||this.color,d=t.color||this.color,c;return s["stroke-width"]=a.lineWidth,s.fill=t.options.color||l&&a.upColor||d,s.stroke=t.options.lineColor||l&&a.upLineColor||h,n&&(c=a.states[n],s.fill=c.color||s.fill,s.stroke=c.lineColor||s.stroke,s["stroke-width"]=c.lineWidth||s["stroke-width"]),s},r.prototype.drawPoints=function(){var t=this,n=t.points,s=t.chart,a=t.yAxis.reversed;n.forEach(function(l){var h=l.graphic,d,c,f,u,p,g,m,v,x,y,b=!h;typeof l.plotY<"u"&&(h||(l.graphic=h=s.renderer.path().add(t.group)),t.chart.styledMode||h.attr(t.pointAttribs(l,l.selected&&"select")).shadow(t.options.shadow),m=h.strokeWidth()%2/2,v=Math.round(l.plotX)-m,d=l.plotOpen,c=l.plotClose,f=Math.min(d,c),u=Math.max(d,c),y=Math.round(l.shapeArgs.width/2),p=a?u!==l.yBottom:Math.round(f)!==Math.round(l.plotHigh),g=a?Math.round(f)!==Math.round(l.plotHigh):u!==l.yBottom,f=Math.round(f)+m,u=Math.round(u)+m,x=[],x.push(["M",v-y,u],["L",v-y,f],["L",v+y,f],["L",v+y,u],["Z"],["M",v,f],["L",v,p?Math.round(a?l.yBottom:l.plotHigh):f],["M",v,u],["L",v,g?Math.round(a?l.plotHigh:l.yBottom):u]),h[b?"attr":"animate"]({d:x}).addClass(l.getClassName(),!0))})},r.defaultOptions=merge$U(OHLCSeries.defaultOptions,defaultOptions$8.plotOptions,{states:{hover:{lineWidth:2}},tooltip:defaultOptions$8.plotOptions.ohlc.tooltip,threshold:null,lineColor:palette.neutralColor100,lineWidth:1,upColor:palette.backgroundColor,stickyTracking:!0}),r}(OHLCSeries);SeriesRegistry$1.registerSeriesType("candlestick",CandlestickSeries);var __extends$I=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),ColumnSeries$d=SeriesRegistry$1.seriesTypes.column,isNumber$r=Utilities.isNumber,FlagsPoint=function(o){__extends$I(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return r.prototype.isValid=function(){return isNumber$r(this.y)||typeof this.y>"u"},r.prototype.hasNewShapeType=function(){var t=this.options.shape||this.series.options.shape;return this.graphic&&t&&t!==this.graphic.symbolKey},r}(ColumnSeries$d.prototype.pointClass),columnProto$5=ColumnSeries$h.prototype,seriesProto$2=Series$e.prototype,defined$x=Utilities.defined,stableSort$4=Utilities.stableSort,onSeriesMixin={getPlotBox:function(){return seriesProto$2.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this)},translate:function(){columnProto$5.translate.apply(this);var o=this,r=o.options,t=o.chart,n=o.points,s=n.length-1,a,l,h=r.onSeries,d=h&&t.get(h),c=r.onKey||"y",f=d&&d.options.step,u=d&&d.points,p=u&&u.length,g=t.inverted,m=o.xAxis,v=o.yAxis,x=0,y,b,$,S,k;if(d&&d.visible&&p)for(x=(d.pointXOffset||0)+(d.barW||0)/2,S=d.currentDataGrouping,b=u[p-1].x+(S?S.totalRange:0),stableSort$4(n,function(A,P){return A.x-P.x}),c="plot"+c[0].toUpperCase()+c.substr(1);p--&&n[s]&&(y=u[p],a=n[s],a.y=y.y,!(y.x<=a.x&&typeof y[c]<"u"&&(a.x<=b&&(a.plotY=y[c],y.x<a.x&&!f&&($=u[p+1],$&&typeof $[c]<"u"&&(k=(a.x-y.x)/($.x-y.x),a.plotY+=k*($[c]-y[c]),a.y+=k*($.y-y.y)))),s--,p++,s<0))););n.forEach(function(A,P){var E;A.plotX+=x,(typeof A.plotY>"u"||g)&&(A.plotX>=0&&A.plotX<=m.len?g?(A.plotY=m.translate(A.x,0,1,0,1),A.plotX=defined$x(A.y)?v.translate(A.y,0,0,0,1):0):A.plotY=(m.opposite?0:o.yAxis.len)+m.offset:A.shapeArgs={}),l=n[P-1],l&&l.plotX===A.plotX&&(typeof l.stackIndex>"u"&&(l.stackIndex=0),E=l.stackIndex+1),A.stackIndex=E}),this.onSeries=d}},symbols$3=SVGRenderer.prototype.symbols;symbols$3.flag=function(o,r,t,n,s){var a=s&&s.anchorX||o,l=s&&s.anchorY||r,h=symbols$3.circle(a-1,l-1,2,2);return h.push(["M",a,l],["L",o,r+n],["L",o,r],["L",o+t,r],["L",o+t,r+n],["L",o,r+n],["Z"]),h};function createPinSymbol(o){symbols$3[o+"pin"]=function(r,t,n,s,a){var l=a&&a.anchorX,h=a&&a.anchorY,d;if(o==="circle"&&s>n&&(r-=Math.round((s-n)/2),n=s),d=symbols$3[o](r,t,n,s),l&&h){var c=l;if(o==="circle")c=r+n/2;else{var f=d[0],u=d[1];f[0]==="M"&&u[0]==="L"&&(c=(f[1]+u[1])/2)}var p=t>h?t:t+s;d.push(["M",c,p],["L",l,h]),d=d.concat(symbols$3.circle(l-1,h-1,2,2))}return d}}createPinSymbol("circle");createPinSymbol("square");var Renderer=RendererRegistry$1.getRendererType();Renderer!==SVGRenderer&&(Renderer.prototype.symbols.circlepin=symbols$3.circlepin,Renderer.prototype.symbols.flag=symbols$3.flag,Renderer.prototype.symbols.squarepin=symbols$3.squarepin);var __extends$H=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),noop$e=H.noop,distribute=R.distribute,Series$b=SeriesRegistry$1.series,ColumnSeries$c=SeriesRegistry$1.seriesTypes.column,addEvent$J=Utilities.addEvent,defined$w=Utilities.defined,extend$10=Utilities.extend,merge$T=Utilities.merge,objectEach$e=Utilities.objectEach,wrap$b=Utilities.wrap,FlagsSeries=function(o){__extends$H(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.animate=function(t){t&&this.setClip()},r.prototype.drawPoints=function(){var t=this,n=t.points,s=t.chart,a=s.renderer,l,h,d=s.inverted,c=t.options,f=c.y,u,p,g,m,v,x,y,b,$=t.yAxis,S={},k=[],A;for(p=n.length;p--;)g=n[p],b=(d?g.plotY:g.plotX)>t.xAxis.len,l=g.plotX,v=g.stackIndex,u=g.options.shape||c.shape,h=g.plotY,typeof h<"u"&&(h=g.plotY+f-(typeof v<"u"&&v*c.stackDistance)),g.anchorX=v?void 0:g.plotX,x=v?void 0:g.plotY,A=u!=="flag",m=g.graphic,typeof h<"u"&&l>=0&&!b?(m&&g.hasNewShapeType()&&(m=m.destroy()),m||(m=g.graphic=a.label("",null,null,u,null,null,c.useHTML).addClass("highcharts-point").add(t.markerGroup),g.graphic.div&&(g.graphic.div.point=g),m.isNew=!0),m.attr({align:A?"center":"left",width:c.width,height:c.height,"text-align":c.textAlign}),s.styledMode||m.attr(t.pointAttribs(g)).css(merge$T(c.style,g.style)).shadow(c.shadow),l>0&&(l-=m.strokeWidth()%2),y={y:h,anchorY:x},c.allowOverlapX&&(y.x=l,y.anchorX=g.anchorX),m.attr({text:g.options.title||c.title||"A"})[m.isNew?"attr":"animate"](y),c.allowOverlapX||(S[g.plotX]?S[g.plotX].size=Math.max(S[g.plotX].size,m.width):S[g.plotX]={align:A?.5:0,size:m.width,target:l,anchorX:l}),g.tooltipPos=[l,h+$.pos-s.plotTop]):m&&(g.graphic=m.destroy());c.allowOverlapX||(objectEach$e(S,function(P){P.plotX=P.anchorX,k.push(P)}),distribute(k,d?$.len:this.xAxis.len,100),n.forEach(function(P){var E=P.graphic&&S[P.plotX];E&&(P.graphic[P.graphic.isNew?"attr":"animate"]({x:E.pos+E.align*E.size,anchorX:P.anchorX}),defined$w(E.pos)?P.graphic.isNew=!1:(P.graphic.attr({x:-9999,anchorX:-9999}),P.graphic.isNew=!0))})),c.useHTML&&wrap$b(t.markerGroup,"on",function(P){return SVGElement.prototype.on.apply(P.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})},r.prototype.drawTracker=function(){var t=this,n=t.points;o.prototype.drawTracker.call(this),n.forEach(function(s){var a=s.graphic;a&&(s.unbindMouseOver&&s.unbindMouseOver(),s.unbindMouseOver=addEvent$J(a.element,"mouseover",function(){s.stackIndex>0&&!s.raised&&(s._y=a.y,a.attr({y:s._y-8}),s.raised=!0),n.forEach(function(l){l!==s&&l.raised&&l.graphic&&(l.graphic.attr({y:l._y}),l.raised=!1)})}))})},r.prototype.pointAttribs=function(t,n){var s=this.options,a=t&&t.color||this.color,l=s.lineColor,h=t&&t.lineWidth,d=t&&t.fillColor||s.fillColor;return n&&(d=s.states[n].fillColor,l=s.states[n].lineColor,h=s.states[n].lineWidth),{fill:d||a,stroke:l||a,"stroke-width":h||s.lineWidth||0}},r.prototype.setClip=function(){Series$b.prototype.setClip.apply(this,arguments),this.options.clip!==!1&&this.sharedClipKey&&this.markerGroup&&this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])},r.defaultOptions=merge$T(ColumnSeries$c.defaultOptions,{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:palette.backgroundColor,lineWidth:1,states:{hover:{lineColor:palette.neutralColor100,fillColor:palette.highlightColor20}},style:{fontSize:"11px",fontWeight:"bold"}}),r}(ColumnSeries$c);extend$10(FlagsSeries.prototype,{allowDG:!1,buildKDTree:noop$e,forceCrop:!0,getPlotBox:onSeriesMixin.getPlotBox,init:Series$b.prototype.init,invertGroups:noop$e,invertible:!1,noSharedTooltip:!0,pointClass:FlagsPoint,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],translate:onSeriesMixin.translate});SeriesRegistry$1.registerSeriesType("flags",FlagsSeries);var addEvent$I=Utilities.addEvent,defined$v=Utilities.defined,pick$_=Utilities.pick,ScrollbarAxis=function(){function o(){}return o.compose=function(r,t){if(o.composed.indexOf(r)===-1)o.composed.push(r);else return r;var n=function(s){var a=pick$_(s.options&&s.options.min,s.min),l=pick$_(s.options&&s.options.max,s.max);return{axisMin:a,axisMax:l,scrollMin:defined$v(s.dataMin)?Math.min(a,s.min,s.dataMin,pick$_(s.threshold,1/0)):a,scrollMax:defined$v(s.dataMax)?Math.max(l,s.max,s.dataMax,pick$_(s.threshold,-1/0)):l}};return addEvent$I(r,"afterInit",function(){var s=this;s.options&&s.options.scrollbar&&s.options.scrollbar.enabled&&(s.options.scrollbar.vertical=!s.horiz,s.options.startOnTick=s.options.endOnTick=!1,s.scrollbar=new t(s.chart.renderer,s.options.scrollbar,s.chart),addEvent$I(s.scrollbar,"changed",function(a){var l=n(s),h=l.axisMin,d=l.axisMax,c=l.scrollMin,f=l.scrollMax,u=f-c,p,g;!defined$v(h)||!defined$v(d)||(s.horiz&&!s.reversed||!s.horiz&&s.reversed?(p=c+u*this.to,g=c+u*this.from):(p=c+u*(1-this.from),g=c+u*(1-this.to)),this.shouldUpdateExtremes(a.DOMType)?s.setExtremes(g,p,!0,a.DOMType!=="mousemove"&&a.DOMType!=="touchmove",a):this.setRange(this.from,this.to))}))}),addEvent$I(r,"afterRender",function(){var s=this,a=n(s),l=a.scrollMin,h=a.scrollMax,d=s.scrollbar,c=s.axisTitleMargin+(s.titleOffset||0),f=s.chart.scrollbarsOffsets,u=s.options.margin||0,p,g,m;d&&(s.horiz?(s.opposite||(f[1]+=c),d.position(s.left,s.top+s.height+2+f[1]-(s.opposite?u:0),s.width,s.height),s.opposite||(f[1]+=u),p=1):(s.opposite&&(f[0]+=c),d.position(s.left+s.width+2+f[0]-(s.opposite?0:u),s.top,s.width,s.height),s.opposite&&(f[0]+=u),p=0),f[p]+=d.size+d.options.margin,isNaN(l)||isNaN(h)||!defined$v(s.min)||!defined$v(s.max)||s.min===s.max?d.setRange(0,1):(g=(s.min-l)/(h-l),m=(s.max-l)/(h-l),s.horiz&&!s.reversed||!s.horiz&&s.reversed?d.setRange(g,m):d.setRange(1-m,1-g)))}),addEvent$I(r,"afterGetOffset",function(){var s=this,a=s.horiz?2:1,l=s.scrollbar;l&&(s.chart.scrollbarsOffsets=[0,0],s.chart.axisOffset[a]+=l.size+l.options.margin)}),r},o.composed=[],o}(),isTouchDevice$3=H.isTouchDevice,ScrollbarDefaults={height:isTouchDevice$3?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,margin:10,minWidth:6,step:.2,zIndex:3,barBackgroundColor:palette.neutralColor20,barBorderWidth:1,barBorderColor:palette.neutralColor20,buttonArrowColor:palette.neutralColor80,buttonBackgroundColor:palette.neutralColor10,buttonBorderColor:palette.neutralColor20,buttonBorderWidth:1,rifleColor:palette.neutralColor80,trackBackgroundColor:palette.neutralColor5,trackBorderColor:palette.neutralColor5,trackBorderWidth:1},defaultOptions$7=DefaultOptions.defaultOptions,addEvent$H=Utilities.addEvent,correctFloat$6=Utilities.correctFloat,defined$u=Utilities.defined,destroyObjectProperties$3=Utilities.destroyObjectProperties,fireEvent$k=Utilities.fireEvent,merge$S=Utilities.merge,pick$Z=Utilities.pick,removeEvent$4=Utilities.removeEvent,Scrollbar=function(){function o(r,t,n){this._events=[],this.chart=void 0,this.chartX=0,this.chartY=0,this.from=0,this.group=void 0,this.options=void 0,this.renderer=void 0,this.scrollbar=void 0,this.scrollbarButtons=[],this.scrollbarGroup=void 0,this.scrollbarLeft=0,this.scrollbarRifles=void 0,this.scrollbarStrokeWidth=1,this.scrollbarTop=0,this.size=0,this.to=0,this.track=void 0,this.trackBorderWidth=1,this.userOptions=void 0,this.x=0,this.y=0,this.init(r,t,n)}return o.compose=function(r){ScrollbarAxis.compose(r,o)},o.swapXY=function(r,t){return t&&r.forEach(function(n){for(var s=n.length,a,l=0;l<s;l+=2)a=n[l+1],typeof a=="number"&&(n[l+1]=n[l+2],n[l+2]=a)}),r},o.prototype.addEvents=function(){var r=this.options.inverted?[1,0]:[0,1],t=this.scrollbarButtons,n=this.scrollbarGroup.element,s=this.track.element,a=this.mouseDownHandler.bind(this),l=this.mouseMoveHandler.bind(this),h=this.mouseUpHandler.bind(this),d=[[t[r[0]].element,"click",this.buttonToMinClick.bind(this)],[t[r[1]].element,"click",this.buttonToMaxClick.bind(this)],[s,"click",this.trackClick.bind(this)],[n,"mousedown",a],[n.ownerDocument,"mousemove",l],[n.ownerDocument,"mouseup",h]];H.hasTouch&&d.push([n,"touchstart",a],[n.ownerDocument,"touchmove",l],[n.ownerDocument,"touchend",h]),d.forEach(function(c){addEvent$H.apply(null,c)}),this._events=d},o.prototype.buttonToMaxClick=function(r){var t=this,n=(t.to-t.from)*pick$Z(t.options.step,.2);t.updatePosition(t.from+n,t.to+n),fireEvent$k(t,"changed",{from:t.from,to:t.to,trigger:"scrollbar",DOMEvent:r})},o.prototype.buttonToMinClick=function(r){var t=this,n=correctFloat$6(t.to-t.from)*pick$Z(t.options.step,.2);t.updatePosition(correctFloat$6(t.from-n),correctFloat$6(t.to-n)),fireEvent$k(t,"changed",{from:t.from,to:t.to,trigger:"scrollbar",DOMEvent:r})},o.prototype.cursorToScrollbarPosition=function(r){var t=this,n=t.options,s=n.minWidth>t.calculatedWidth?n.minWidth:0;return{chartX:(r.chartX-t.x-t.xOffset)/(t.barWidth-s),chartY:(r.chartY-t.y-t.yOffset)/(t.barWidth-s)}},o.prototype.destroy=function(){var r=this,t=r.chart.scroller;r.removeEvents(),["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(n){r[n]&&r[n].destroy&&(r[n]=r[n].destroy())}),t&&r===t.scrollbar&&(t.scrollbar=null,destroyObjectProperties$3(t.scrollbarButtons))},o.prototype.drawScrollbarButton=function(r){var t=this,n=t.renderer,s=t.scrollbarButtons,a=t.options,l=t.size,h=n.g().add(t.group),d;s.push(h),d=n.rect().addClass("highcharts-scrollbar-button").add(h),t.chart.styledMode||d.attr({stroke:a.buttonBorderColor,"stroke-width":a.buttonBorderWidth,fill:a.buttonBackgroundColor}),d.attr(d.crisp({x:-.5,y:-.5,width:l+1,height:l+1,r:a.buttonBorderRadius},d.strokeWidth())),d=n.path(o.swapXY([["M",l/2+(r?-1:1),l/2-3],["L",l/2+(r?-1:1),l/2+3],["L",l/2+(r?2:-2),l/2]],a.vertical)).addClass("highcharts-scrollbar-arrow").add(s[r]),t.chart.styledMode||d.attr({fill:a.buttonArrowColor})},o.prototype.init=function(r,t,n){var s=this;s.scrollbarButtons=[],s.renderer=r,s.userOptions=t,s.options=merge$S(ScrollbarDefaults,defaultOptions$7.scrollbar,t),s.chart=n,s.size=pick$Z(s.options.size,s.options.height),t.enabled&&(s.render(),s.addEvents())},o.prototype.mouseDownHandler=function(r){var t=this,n=t.chart.pointer.normalize(r),s=t.cursorToScrollbarPosition(n);t.chartX=s.chartX,t.chartY=s.chartY,t.initPositions=[t.from,t.to],t.grabbedCenter=!0},o.prototype.mouseMoveHandler=function(r){var t=this,n=t.chart.pointer.normalize(r),s=t.options,a=s.vertical?"chartY":"chartX",l=t.initPositions||[],h,d,c;t.grabbedCenter&&(!r.touches||r.touches[0][a]!==0)&&(d=t.cursorToScrollbarPosition(n)[a],h=t[a],c=d-h,t.hasDragged=!0,t.updatePosition(l[0]+c,l[1]+c),t.hasDragged&&fireEvent$k(t,"changed",{from:t.from,to:t.to,trigger:"scrollbar",DOMType:r.type,DOMEvent:r}))},o.prototype.mouseUpHandler=function(r){var t=this;t.hasDragged&&fireEvent$k(t,"changed",{from:t.from,to:t.to,trigger:"scrollbar",DOMType:r.type,DOMEvent:r}),t.grabbedCenter=t.hasDragged=t.chartX=t.chartY=null},o.prototype.position=function(r,t,n,s){var a=this,l=a.options,h=l.vertical,d=a.rendered?"animate":"attr",c=s,f=0;a.x=r,a.y=t+this.trackBorderWidth,a.width=n,a.height=s,a.xOffset=c,a.yOffset=f,h?(a.width=a.yOffset=n=f=a.size,a.xOffset=c=0,a.barWidth=s-n*2,a.x=r=r+a.options.margin):(a.height=a.xOffset=s=c=a.size,a.barWidth=n-s*2,a.y=a.y+a.options.margin),a.group[d]({translateX:r,translateY:a.y}),a.track[d]({width:n,height:s}),a.scrollbarButtons[1][d]({translateX:h?0:n-c,translateY:h?s-f:0})},o.prototype.removeEvents=function(){this._events.forEach(function(r){removeEvent$4.apply(null,r)}),this._events.length=0},o.prototype.render=function(){var r=this,t=r.renderer,n=r.options,s=r.size,a=r.chart.styledMode,l=t.g("scrollbar").attr({zIndex:n.zIndex,translateY:-99999}).add();r.group=l,r.track=t.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:n.trackBorderRadius||0,height:s,width:s}).add(l),a||r.track.attr({fill:n.trackBackgroundColor,stroke:n.trackBorderColor,"stroke-width":n.trackBorderWidth}),r.trackBorderWidth=r.track.strokeWidth(),r.track.attr({y:-this.trackBorderWidth%2/2}),r.scrollbarGroup=t.g().add(l),r.scrollbar=t.rect().addClass("highcharts-scrollbar-thumb").attr({height:s,width:s,r:n.barBorderRadius||0}).add(r.scrollbarGroup),r.scrollbarRifles=t.path(o.swapXY([["M",-3,s/4],["L",-3,2*s/3],["M",0,s/4],["L",0,2*s/3],["M",3,s/4],["L",3,2*s/3]],n.vertical)).addClass("highcharts-scrollbar-rifles").add(r.scrollbarGroup),a||(r.scrollbar.attr({fill:n.barBackgroundColor,stroke:n.barBorderColor,"stroke-width":n.barBorderWidth}),r.scrollbarRifles.attr({stroke:n.rifleColor,"stroke-width":1})),r.scrollbarStrokeWidth=r.scrollbar.strokeWidth(),r.scrollbarGroup.translate(-r.scrollbarStrokeWidth%2/2,-r.scrollbarStrokeWidth%2/2),r.drawScrollbarButton(0),r.drawScrollbarButton(1)},o.prototype.setRange=function(r,t){var n=this,s=n.options,a=s.vertical,l=s.minWidth,h=n.barWidth,d=this.rendered&&!this.hasDragged&&!(this.chart.navigator&&this.chart.navigator.hasDragged)?"animate":"attr";if(defined$u(h)){var c=h*Math.min(t,1),f,u;r=Math.max(r,0),f=Math.ceil(h*r),n.calculatedWidth=u=correctFloat$6(c-f),u<l&&(f=(h-l+u)*r,u=l);var p=Math.floor(f+n.xOffset+n.yOffset),g=u/2-.5;n.from=r,n.to=t,a?(n.scrollbarGroup[d]({translateY:p}),n.scrollbar[d]({height:u}),n.scrollbarRifles[d]({translateY:g}),n.scrollbarTop=p,n.scrollbarLeft=0):(n.scrollbarGroup[d]({translateX:p}),n.scrollbar[d]({width:u}),n.scrollbarRifles[d]({translateX:g}),n.scrollbarLeft=p,n.scrollbarTop=0),u<=12?n.scrollbarRifles.hide():n.scrollbarRifles.show(!0),s.showFull===!1&&(r<=0&&t>=1?n.group.hide():n.group.show()),n.rendered=!0}},o.prototype.shouldUpdateExtremes=function(r){return pick$Z(this.options.liveRedraw,H.svg&&!H.isTouchDevice&&!this.chart.isBoosting)||r==="mouseup"||r==="touchend"||!defined$u(r)},o.prototype.trackClick=function(r){var t=this,n=t.chart.pointer.normalize(r),s=t.to-t.from,a=t.y+t.scrollbarTop,l=t.x+t.scrollbarLeft;t.options.vertical&&n.chartY>a||!t.options.vertical&&n.chartX>l?t.updatePosition(t.from+s,t.to+s):t.updatePosition(t.from-s,t.to-s),fireEvent$k(t,"changed",{from:t.from,to:t.to,trigger:"scrollbar",DOMEvent:r})},o.prototype.update=function(r){this.destroy(),this.init(this.chart.renderer,merge$S(!0,this.options,r),this.chart)},o.prototype.updatePosition=function(r,t){t>1&&(r=correctFloat$6(1-correctFloat$6(t-r)),t=1),r<0&&(t=correctFloat$6(t-r),r=0),this.from=r,this.to=t},o.defaultOptions=ScrollbarDefaults,o}();defaultOptions$7.scrollbar=merge$S(!0,Scrollbar.defaultOptions,defaultOptions$7.scrollbar);var isTouchDevice$2=H.isTouchDevice,addEvent$G=Utilities.addEvent,correctFloat$5=Utilities.correctFloat,defined$t=Utilities.defined,isNumber$q=Utilities.isNumber,pick$Y=Utilities.pick,NavigatorAxisAdditions=function(){function o(r){this.axis=r}return o.prototype.destroy=function(){this.axis=void 0},o.prototype.toFixedRange=function(r,t,n,s){var a=this,l=a.axis,h=l.chart,d=h&&h.fixedRange,c=(l.pointRange||0)/2,f=pick$Y(n,l.translate(r,!0,!l.horiz)),u=pick$Y(s,l.translate(t,!0,!l.horiz)),p=d&&(u-f)/d;return defined$t(n)||(f=correctFloat$5(f+c)),defined$t(s)||(u=correctFloat$5(u-c)),p>.7&&p<1.3&&(s?f=u-d:u=f+d),(!isNumber$q(f)||!isNumber$q(u))&&(f=u=void 0),{min:f,max:u}},o}(),NavigatorAxis=function(){function o(){}return o.compose=function(r){r.keepProps.push("navigatorAxis"),addEvent$G(r,"init",function(){var t=this;t.navigatorAxis||(t.navigatorAxis=new NavigatorAxisAdditions(t))}),addEvent$G(r,"zoom",function(t){var n=this,s=n.chart,a=s.options,l=a.navigator,h=n.navigatorAxis,d=a.chart.pinchType,c=a.rangeSelector,f=a.chart.zoomType,u;n.isXAxis&&(l&&l.enabled||c&&c.enabled)&&(f==="y"?t.zoomed=!1:(!isTouchDevice$2&&f==="xy"||isTouchDevice$2&&d==="xy")&&n.options.range&&(u=h.previousZoom,defined$t(t.newMin)?h.previousZoom=[n.min,n.max]:u&&(t.newMin=u[0],t.newMax=u[1],h.previousZoom=void 0))),typeof t.zoomed<"u"&&t.preventDefault()})},o.AdditionsClass=NavigatorAxisAdditions,o}(),color$b=Color.parse,hasTouch=H.hasTouch,isTouchDevice$1=H.isTouchDevice,defaultOptions$6=DefaultOptions.defaultOptions,seriesTypes$5=SeriesRegistry$1.seriesTypes,addEvent$F=Utilities.addEvent,clamp$a=Utilities.clamp,correctFloat$4=Utilities.correctFloat,defined$s=Utilities.defined,destroyObjectProperties$2=Utilities.destroyObjectProperties,erase$1=Utilities.erase,extend$$=Utilities.extend,find$c=Utilities.find,isArray$8=Utilities.isArray,isNumber$p=Utilities.isNumber,merge$R=Utilities.merge,pick$X=Utilities.pick,removeEvent$3=Utilities.removeEvent,splat$9=Utilities.splat,defaultSeriesType,numExt=function(o){for(var r=[],t=1;t<arguments.length;t++)r[t-1]=arguments[t];var n=[].filter.call(r,isNumber$p);if(n.length)return Math[o].apply(0,n)};defaultSeriesType=typeof seriesTypes$5.areaspline>"u"?"line":"areaspline";extend$$(defaultOptions$6,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:palette.neutralColor5,borderColor:palette.neutralColor40},maskFill:color$b(palette.highlightColor60).setOpacity(.3).get(),outlineColor:palette.neutralColor20,outlineWidth:1,series:{type:defaultSeriesType,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:palette.neutralColor10,gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:palette.neutralColor40},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});RendererRegistry$1.getRendererType().prototype.symbols["navigator-handle"]=function(o,r,t,n,s){var a=(s&&s.width||0)/2,l=Math.round(a/3)+.5,h=s&&s.height||0;return[["M",-a-1,.5],["L",a,.5],["L",a,h+.5],["L",-a-1,h+.5],["L",-a-1,.5],["M",-l,4],["L",-l,h-3],["M",l-1,4],["L",l-1,h-3]]};var Navigator=function(){function o(r){this.baseSeries=void 0,this.chart=void 0,this.handles=void 0,this.height=void 0,this.left=void 0,this.navigatorEnabled=void 0,this.navigatorGroup=void 0,this.navigatorOptions=void 0,this.navigatorSeries=void 0,this.navigatorSize=void 0,this.opposite=void 0,this.outline=void 0,this.outlineHeight=void 0,this.range=void 0,this.rendered=void 0,this.shades=void 0,this.size=void 0,this.top=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zoomedMax=void 0,this.zoomedMin=void 0,this.init(r)}return o.prototype.drawHandle=function(r,t,n,s){var a=this,l=a.navigatorOptions.handles.height;a.handles[t][s](n?{translateX:Math.round(a.left+a.height/2),translateY:Math.round(a.top+parseInt(r,10)+.5-l)}:{translateX:Math.round(a.left+parseInt(r,10)),translateY:Math.round(a.top+a.height/2-l/2-1)})},o.prototype.drawOutline=function(r,t,n,s){var a=this,l=a.navigatorOptions.maskInside,h=a.outline.strokeWidth(),d=h/2,c=h%2/2,f=a.outlineHeight,u=a.scrollbarHeight||0,p=a.size,g=a.left-u,m=a.top,v,x;n?(g-=d,v=m+t+c,t=m+r+c,x=[["M",g+f,m-u-c],["L",g+f,v],["L",g,v],["L",g,t],["L",g+f,t],["L",g+f,m+p+u]],l&&x.push(["M",g+f,v-d],["L",g+f,t+d])):(r+=g+u-c,t+=g+u-c,m+=d,x=[["M",g,m],["L",r,m],["L",r,m+f],["L",t,m+f],["L",t,m],["L",g+p+u*2,m]],l&&x.push(["M",r-d,m],["L",t+d,m])),a.outline[s]({d:x})},o.prototype.drawMasks=function(r,t,n,s){var a=this,l=a.left,h=a.top,d=a.height,c,f,u,p;n?(u=[l,l,l],p=[h,h+r,h+t],f=[d,d,d],c=[r,t-r,a.size-t]):(u=[l,l+r,l+t],p=[h,h,h],f=[r,t-r,a.size-t],c=[d,d,d]),a.shades.forEach(function(g,m){g[s]({x:u[m],y:p[m],width:f[m],height:c[m]})})},o.prototype.renderElements=function(){var r=this,t=r.navigatorOptions,n=t.maskInside,s=r.chart,a=s.inverted,l=s.renderer,h,d={cursor:a?"ns-resize":"ew-resize"};r.navigatorGroup=h=l.g("navigator").attr({zIndex:8,visibility:"hidden"}).add(),[!n,n,!n].forEach(function(c,f){r.shades[f]=l.rect().addClass("highcharts-navigator-mask"+(f===1?"-inside":"-outside")).add(h),s.styledMode||r.shades[f].attr({fill:c?t.maskFill:"rgba(0,0,0,0)"}).css(f===1&&d)}),r.outline=l.path().addClass("highcharts-navigator-outline").add(h),s.styledMode||r.outline.attr({"stroke-width":t.outlineWidth,stroke:t.outlineColor}),t.handles.enabled&&[0,1].forEach(function(c){if(t.handles.inverted=s.inverted,r.handles[c]=l.symbol(t.handles.symbols[c],-t.handles.width/2-1,0,t.handles.width,t.handles.height,t.handles),r.handles[c].attr({zIndex:7-c}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][c]).add(h),!s.styledMode){var f=t.handles;r.handles[c].attr({fill:f.backgroundColor,stroke:f.borderColor,"stroke-width":f.lineWidth}).css(d)}})},o.prototype.update=function(r){(this.series||[]).forEach(function(n){n.baseSeries&&delete n.baseSeries.navigatorSeries}),this.destroy();var t=this.chart.options;merge$R(!0,t.navigator,this.options,r),this.init(this.chart)},o.prototype.render=function(r,t,n,s){var a=this,l=a.chart,h,d,c,f=a.scrollbarHeight,u,p=a.xAxis,g=p.pointRange||0,m=p.navigatorAxis.fake?l.xAxis[0]:p,v=a.navigatorEnabled,x,y,b=a.rendered,$=l.inverted,S,k,A,P,E=l.xAxis[0].minRange,M=l.xAxis[0].options.maxRange;if(!(this.hasDragged&&!defined$s(n))){if(r=correctFloat$4(r-g/2),t=correctFloat$4(t+g/2),!isNumber$p(r)||!isNumber$p(t))if(b)n=0,s=pick$X(p.width,m.width);else return;a.left=pick$X(p.left,l.plotLeft+f+($?l.plotWidth:0)),a.size=y=u=pick$X(p.len,($?l.plotHeight:l.plotWidth)-2*f),$?h=f:h=u+2*f,n=pick$X(n,p.toPixels(r,!0)),s=pick$X(s,p.toPixels(t,!0)),(!isNumber$p(n)||Math.abs(n)===1/0)&&(n=0,s=h),k=p.toValue(n,!0),A=p.toValue(s,!0),P=Math.abs(correctFloat$4(A-k)),P<E?this.grabbedLeft?n=p.toPixels(A-E-g,!0):this.grabbedRight&&(s=p.toPixels(k+E+g,!0)):defined$s(M)&&correctFloat$4(P-g)>M&&(this.grabbedLeft?n=p.toPixels(A-M-g,!0):this.grabbedRight&&(s=p.toPixels(k+M+g,!0))),a.zoomedMax=clamp$a(Math.max(n,s),0,y),a.zoomedMin=clamp$a(a.fixedWidth?a.zoomedMax-a.fixedWidth:Math.min(n,s),0,y),a.range=a.zoomedMax-a.zoomedMin,y=Math.round(a.zoomedMax),x=Math.round(a.zoomedMin),v&&(a.navigatorGroup.attr({visibility:"visible"}),S=b&&!a.hasDragged?"animate":"attr",a.drawMasks(x,y,$,S),a.drawOutline(x,y,$,S),a.navigatorOptions.handles.enabled&&(a.drawHandle(x,0,$,S),a.drawHandle(y,1,$,S))),a.scrollbar&&($?(c=a.top-f,d=a.left-f+(v||!m.opposite?0:(m.titleOffset||0)+m.axisTitleMargin),f=u+2*f):(c=a.top+(v?a.height:-f),d=a.left-f),a.scrollbar.position(d,c,h,f),a.scrollbar.setRange(a.zoomedMin/(u||1),a.zoomedMax/(u||1))),a.rendered=!0}},o.prototype.addMouseEvents=function(){var r=this,t=r.chart,n=t.container,s=[],a,l;r.mouseMoveHandler=a=function(h){r.onMouseMove(h)},r.mouseUpHandler=l=function(h){r.onMouseUp(h)},s=r.getPartsEvents("mousedown"),s.push(addEvent$F(t.renderTo,"mousemove",a),addEvent$F(n.ownerDocument,"mouseup",l)),hasTouch&&(s.push(addEvent$F(t.renderTo,"touchmove",a),addEvent$F(n.ownerDocument,"touchend",l)),s.concat(r.getPartsEvents("touchstart"))),r.eventsToUnbind=s,r.series&&r.series[0]&&s.push(addEvent$F(r.series[0].xAxis,"foundExtremes",function(){t.navigator.modifyNavigatorAxisExtremes()}))},o.prototype.getPartsEvents=function(r){var t=this,n=[];return["shades","handles"].forEach(function(s){t[s].forEach(function(a,l){n.push(addEvent$F(a.element,r,function(h){t[s+"Mousedown"](h,l)}))})}),n},o.prototype.shadesMousedown=function(r,t){r=this.chart.pointer.normalize(r);var n=this,s=n.chart,a=n.xAxis,l=n.zoomedMin,h=n.left,d=n.size,c=n.range,f=r.chartX,u,p,g,m;s.inverted&&(f=r.chartY,h=n.top),t===1?(n.grabbedCenter=f,n.fixedWidth=c,n.dragOffset=f-l):(m=f-h-c/2,t===0?m=Math.max(0,m):t===2&&m+c>=d&&(m=d-c,n.reversedExtremes?(m-=c,p=n.getUnionExtremes().dataMin):u=n.getUnionExtremes().dataMax),m!==l&&(n.fixedWidth=c,g=a.navigatorAxis.toFixedRange(m,m+c,p,u),defined$s(g.min)&&s.xAxis[0].setExtremes(Math.min(g.min,g.max),Math.max(g.min,g.max),!0,null,{trigger:"navigator"})))},o.prototype.handlesMousedown=function(r,t){r=this.chart.pointer.normalize(r);var n=this,s=n.chart,a=s.xAxis[0],l=n.reversedExtremes;t===0?(n.grabbedLeft=!0,n.otherHandlePos=n.zoomedMax,n.fixedExtreme=l?a.min:a.max):(n.grabbedRight=!0,n.otherHandlePos=n.zoomedMin,n.fixedExtreme=l?a.max:a.min),s.fixedRange=null},o.prototype.onMouseMove=function(r){var t=this,n=t.chart,s=t.left,a=t.navigatorSize,l=t.range,h=t.dragOffset,d=n.inverted,c;(!r.touches||r.touches[0].pageX!==0)&&(r=n.pointer.normalize(r),c=r.chartX,d&&(s=t.top,c=r.chartY),t.grabbedLeft?(t.hasDragged=!0,t.render(0,0,c-s,t.otherHandlePos)):t.grabbedRight?(t.hasDragged=!0,t.render(0,0,t.otherHandlePos,c-s)):t.grabbedCenter&&(t.hasDragged=!0,c<h?c=h:c>a+h-l&&(c=a+h-l),t.render(0,0,c-h,c-h+l)),t.hasDragged&&t.scrollbar&&pick$X(t.scrollbar.options.liveRedraw,H.svg&&!isTouchDevice$1&&!this.chart.isBoosting)&&(r.DOMType=r.type,setTimeout(function(){t.onMouseUp(r)},0)))},o.prototype.onMouseUp=function(r){var t=this,n=t.chart,s=t.xAxis,a=t.scrollbar,l=r.DOMEvent||r,h=n.inverted,d=t.rendered&&!t.hasDragged?"animate":"attr",c,f,u,p,g,m;(t.hasDragged&&(!a||!a.hasDragged)||r.trigger==="scrollbar")&&(u=t.getUnionExtremes(),t.zoomedMin===t.otherHandlePos?p=t.fixedExtreme:t.zoomedMax===t.otherHandlePos&&(g=t.fixedExtreme),t.zoomedMax===t.size&&(g=t.reversedExtremes?u.dataMin:u.dataMax),t.zoomedMin===0&&(p=t.reversedExtremes?u.dataMax:u.dataMin),m=s.navigatorAxis.toFixedRange(t.zoomedMin,t.zoomedMax,p,g),defined$s(m.min)&&n.xAxis[0].setExtremes(Math.min(m.min,m.max),Math.max(m.min,m.max),!0,t.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:l})),r.DOMType!=="mousemove"&&r.DOMType!=="touchmove"&&(t.grabbedLeft=t.grabbedRight=t.grabbedCenter=t.fixedWidth=t.fixedExtreme=t.otherHandlePos=t.hasDragged=t.dragOffset=null),t.navigatorEnabled&&isNumber$p(t.zoomedMin)&&isNumber$p(t.zoomedMax)&&(f=Math.round(t.zoomedMin),c=Math.round(t.zoomedMax),t.shades&&t.drawMasks(f,c,h,d),t.outline&&t.drawOutline(f,c,h,d),t.navigatorOptions.handles.enabled&&Object.keys(t.handles).length===t.handles.length&&(t.drawHandle(f,0,h,d),t.drawHandle(c,1,h,d)))},o.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(r){r()}),this.eventsToUnbind=void 0),this.removeBaseSeriesEvents()},o.prototype.removeBaseSeriesEvents=function(){var r=this.baseSeries||[];this.navigatorEnabled&&r[0]&&(this.navigatorOptions.adaptToUpdatedData!==!1&&r.forEach(function(t){removeEvent$3(t,"updatedData",this.updatedDataHandler)},this),r[0].xAxis&&removeEvent$3(r[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},o.prototype.init=function(r){var t=r.options,n=t.navigator,s=n.enabled,a=t.scrollbar,l=a.enabled,h=s?n.height:0,d=l?a.height:0;this.handles=[],this.shades=[],this.chart=r,this.setBaseSeries(),this.height=h,this.scrollbarHeight=d,this.scrollbarEnabled=l,this.navigatorEnabled=s,this.navigatorOptions=n,this.scrollbarOptions=a,this.outlineHeight=h+d,this.opposite=pick$X(n.opposite,!!(!s&&r.inverted));var c=this,f=c.baseSeries,u=r.xAxis.length,p=r.yAxis.length,g=f&&f[0]&&f[0].xAxis||r.xAxis[0]||{options:{}};r.isDirtyBox=!0,c.navigatorEnabled?(c.xAxis=new Axis(r,merge$R({breaks:g.options.breaks,ordinal:g.options.ordinal},n.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:u,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},r.inverted?{offsets:[d,0,-d,0],width:h}:{offsets:[0,-d,0,d],height:h})),c.yAxis=new Axis(r,merge$R(n.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:p,isInternal:!0,reversed:pick$X(n.yAxis&&n.yAxis.reversed,r.yAxis[0]&&r.yAxis[0].reversed,!1),zoomEnabled:!1},r.inverted?{width:h}:{height:h})),f||n.series.data?c.updateNavigatorSeries(!1):r.series.length===0&&(c.unbindRedraw=addEvent$F(r,"beforeRedraw",function(){r.series.length>0&&!c.series&&(c.setBaseSeries(),c.unbindRedraw())})),c.reversedExtremes=r.inverted&&!c.xAxis.reversed||!r.inverted&&c.xAxis.reversed,c.renderElements(),c.addMouseEvents()):(c.xAxis={chart:r,navigatorAxis:{fake:!0},translate:function(m,v){var x=r.xAxis[0],y=x.getExtremes(),b=x.len-2*d,$=numExt("min",x.options.min,y.dataMin),S=numExt("max",x.options.max,y.dataMax)-$;return v?m*S/b+$:b*(m-$)/S},toPixels:function(m){return this.translate(m)},toValue:function(m){return this.translate(m,!0)}},c.xAxis.navigatorAxis.axis=c.xAxis,c.xAxis.navigatorAxis.toFixedRange=NavigatorAxis.AdditionsClass.prototype.toFixedRange.bind(c.xAxis.navigatorAxis)),r.options.scrollbar.enabled&&(r.scrollbar=c.scrollbar=new Scrollbar(r.renderer,merge$R(r.options.scrollbar,{margin:c.navigatorEnabled?0:10,vertical:r.inverted}),r),addEvent$F(c.scrollbar,"changed",function(m){var v=c.size,x=v*this.to,y=v*this.from;c.hasDragged=c.scrollbar.hasDragged,c.render(0,0,y,x),this.shouldUpdateExtremes(m.DOMType)&&setTimeout(function(){c.onMouseUp(m)})})),c.addBaseSeriesEvents(),c.addChartEvents()},o.prototype.getUnionExtremes=function(r){var t=this.chart.xAxis[0],n=this.xAxis,s=n.options,a=t.options,l;return(!r||t.dataMin!==null)&&(l={dataMin:pick$X(s&&s.min,numExt("min",a.min,t.dataMin,n.dataMin,n.min)),dataMax:pick$X(s&&s.max,numExt("max",a.max,t.dataMax,n.dataMax,n.max))}),l},o.prototype.setBaseSeries=function(r,t){var n=this.chart,s=this.baseSeries=[];r=r||n.options&&n.options.navigator.baseSeries||(n.series.length?find$c(n.series,function(a){return!a.options.isInternal}).index:0),(n.series||[]).forEach(function(a,l){!a.options.isInternal&&(a.options.showInNavigator||(l===r||a.options.id===r)&&a.options.showInNavigator!==!1)&&s.push(a)}),this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,t)},o.prototype.updateNavigatorSeries=function(r,t){var n=this,s=n.chart,a=n.baseSeries,l,h,d=n.navigatorOptions.series,c,f={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},u=n.series=(n.series||[]).filter(function(p){var g=p.baseSeries;return a.indexOf(g)<0?(g&&(removeEvent$3(g,"updatedData",n.updatedDataHandler),delete g.navigatorSeries),p.chart&&p.destroy(),!1):!0});a&&a.length&&a.forEach(function(g){var m=g.navigatorSeries,v=extend$$({color:g.color,visible:g.visible},isArray$8(d)?defaultOptions$6.navigator.series:d);if(!(m&&n.navigatorOptions.adaptToUpdatedData===!1)){f.name="Navigator "+a.length,l=g.options||{},c=l.navigatorOptions||{},v.dataLabels=splat$9(v.dataLabels),h=merge$R(l,f,v,c),h.pointRange=pick$X(v.pointRange,c.pointRange,defaultOptions$6.plotOptions[h.type||"line"].pointRange);var x=c.data||v.data;n.hasNavigatorData=n.hasNavigatorData||!!x,h.data=x||l.data&&l.data.slice(0),m&&m.options?m.update(h,t):(g.navigatorSeries=s.initSeries(h),g.navigatorSeries.baseSeries=g,u.push(g.navigatorSeries))}}),(d.data&&!(a&&a.length)||isArray$8(d))&&(n.hasNavigatorData=!1,d=splat$9(d),d.forEach(function(p,g){f.name="Navigator "+(u.length+1),h=merge$R(defaultOptions$6.navigator.series,{color:s.series[g]&&!s.series[g].options.isInternal&&s.series[g].color||s.options.colors[g]||s.options.colors[0]},f,p),h.data=p.data,h.data&&(n.hasNavigatorData=!0,u.push(s.initSeries(h)))})),r&&this.addBaseSeriesEvents()},o.prototype.addBaseSeriesEvents=function(){var r=this,t=r.baseSeries||[];t[0]&&t[0].xAxis&&t[0].eventsToUnbind.push(addEvent$F(t[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes)),t.forEach(function(n){n.eventsToUnbind.push(addEvent$F(n,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)})),n.eventsToUnbind.push(addEvent$F(n,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)})),this.navigatorOptions.adaptToUpdatedData!==!1&&n.xAxis&&n.eventsToUnbind.push(addEvent$F(n,"updatedData",this.updatedDataHandler)),n.eventsToUnbind.push(addEvent$F(n,"remove",function(){this.navigatorSeries&&(erase$1(r.series,this.navigatorSeries),defined$s(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))},this)},o.prototype.getBaseSeriesMin=function(r){return this.baseSeries.reduce(function(t,n){return Math.min(t,n.xData?n.xData[0]:t)},r)},o.prototype.modifyNavigatorAxisExtremes=function(){var r=this.xAxis,t;typeof r.getExtremes<"u"&&(t=this.getUnionExtremes(!0),t&&(t.dataMin!==r.min||t.dataMax!==r.max)&&(r.min=t.dataMin,r.max=t.dataMax))},o.prototype.modifyBaseAxisExtremes=function(){var r=this,t=r.chart.navigator,n=r.getExtremes(),s=n.min,a=n.max,l=n.dataMin,h=n.dataMax,d=a-s,c=t.stickToMin,f=t.stickToMax,u=pick$X(r.options.overscroll,0),p,g,m=t.series&&t.series[0],v=!!r.setExtremes,x=r.eventArgs&&r.eventArgs.trigger==="rangeSelectorButton";x||(c&&(g=l,p=g+d),f&&(p=h+u,c||(g=Math.max(l,p-d,t.getBaseSeriesMin(m&&m.xData?m.xData[0]:-Number.MAX_VALUE)))),v&&(c||f)&&isNumber$p(g)&&(r.min=r.userMin=g,r.max=r.userMax=p)),t.stickToMin=t.stickToMax=null},o.prototype.updatedDataHandler=function(){var r=this.chart.navigator,t=this,n=this.navigatorSeries;r.stickToMax=r.reversedExtremes?Math.round(r.zoomedMin)===0:Math.round(r.zoomedMax)>=Math.round(r.size),r.stickToMin=r.shouldStickToMin(t,r),n&&!r.hasNavigatorData&&(n.options.pointStart=t.xData[0],n.setData(t.options.data,!1,null,!1))},o.prototype.shouldStickToMin=function(r,t){var n=t.getBaseSeriesMin(r.xData[0]),s=r.xAxis,a=s.max,l=s.min,h=s.options.range,d=!0;return isNumber$p(a)&&isNumber$p(l)?h&&a-n>0?d=a-n<h&&!this.chart.fixedRange:d=l<=n:d=!1,d},o.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]),this.eventsToUnbind.push(addEvent$F(this.chart,"redraw",function(){var r=this.navigator,t=r&&(r.baseSeries&&r.baseSeries[0]&&r.baseSeries[0].xAxis||this.xAxis[0]);t&&r.render(t.min,t.max)}),addEvent$F(this.chart,"getMargins",function(){var r=this,t=r.navigator,n=t.opposite?"plotTop":"marginBottom";r.inverted&&(n=t.opposite?"marginRight":"plotLeft"),r[n]=(r[n]||0)+(t.navigatorEnabled||!r.inverted?t.outlineHeight:0)+t.navigatorOptions.margin}))},o.prototype.destroy=function(){this.removeEvents(),this.xAxis&&(erase$1(this.chart.xAxis,this.xAxis),erase$1(this.chart.axes,this.xAxis)),this.yAxis&&(erase$1(this.chart.yAxis,this.yAxis),erase$1(this.chart.axes,this.yAxis)),(this.series||[]).forEach(function(r){r.destroy&&r.destroy()}),["series","xAxis","yAxis","shades","outline","scrollbarTrack","scrollbarRifles","scrollbarGroup","scrollbar","navigatorGroup","rendered"].forEach(function(r){this[r]&&this[r].destroy&&this[r].destroy(),this[r]=null},this),[this.handles].forEach(function(r){destroyObjectProperties$2(r)},this)},o}();H.Navigator||(H.Navigator=Navigator,NavigatorAxis.compose(Axis),addEvent$F(Chart$1,"beforeShowResetZoom",function(){var o=this.options,r=o.navigator,t=o.rangeSelector;if((r&&r.enabled||t&&t.enabled)&&(!isTouchDevice$1&&o.chart.zoomType==="x"||isTouchDevice$1&&o.chart.pinchType==="x"))return!1}),addEvent$F(Chart$1,"beforeRender",function(){var o=this.options;(o.navigator.enabled||o.scrollbar.enabled)&&(this.scroller=this.navigator=new Navigator(this))}),addEvent$F(Chart$1,"afterSetChartSize",function(){var o=this.legend,r=this.navigator,t,n,s,a;r&&(n=o&&o.options,s=r.xAxis,a=r.yAxis,t=r.scrollbarHeight,this.inverted?(r.left=r.opposite?this.chartWidth-t-r.height:this.spacing[3]+t,r.top=this.plotTop+t):(r.left=pick$X(s.left,this.plotLeft+t),r.top=r.navigatorOptions.top||this.chartHeight-r.height-t-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(n&&n.verticalAlign==="bottom"&&n.layout!=="proximate"&&n.enabled&&!n.floating?o.legendHeight+pick$X(n.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0)),s&&a&&(this.inverted?s.options.left=a.options.left=r.left:s.options.top=a.options.top=r.top,s.setAxisSize(),a.setAxisSize()))}),addEvent$F(Chart$1,"update",function(o){var r=o.options.navigator||{},t=o.options.scrollbar||{};!this.navigator&&!this.scroller&&(r.enabled||t.enabled)&&(merge$R(!0,this.options.navigator,r),merge$R(!0,this.options.scrollbar,t),delete o.options.navigator,delete o.options.scrollbar)}),addEvent$F(Chart$1,"afterUpdate",function(o){!this.navigator&&!this.scroller&&(this.options.navigator.enabled||this.options.scrollbar.enabled)&&(this.scroller=this.navigator=new Navigator(this),pick$X(o.redraw,!0)&&this.redraw(o.animation))}),addEvent$F(Chart$1,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),addEvent$F(Series$e,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}),Chart$1.prototype.callbacks.push(function(o){var r,t=o.navigator;t&&o.xAxis[0]&&(r=o.xAxis[0].getExtremes(),t.render(r.min,r.max))}));H.Navigator=Navigator;H.Navigator;var defaultOptions$5=DefaultOptions.defaultOptions,addEvent$E=Utilities.addEvent,createElement$3=Utilities.createElement,css$2=Utilities.css,defined$r=Utilities.defined,destroyObjectProperties$1=Utilities.destroyObjectProperties,discardElement$2=Utilities.discardElement,extend$_=Utilities.extend,find$b=Utilities.find,fireEvent$j=Utilities.fireEvent,isNumber$o=Utilities.isNumber,merge$Q=Utilities.merge,objectEach$d=Utilities.objectEach,pad=Utilities.pad,pick$W=Utilities.pick,pInt$3=Utilities.pInt,splat$8=Utilities.splat;extend$_(defaultOptions$5,{rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%b %e, %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:palette.highlightColor80,cursor:"pointer"},labelStyle:{color:palette.neutralColor60}}});extend$_(defaultOptions$5.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"→"});var RangeSelector=function(){function o(r){this.buttons=void 0,this.buttonOptions=o.prototype.defaultButtons,this.initialButtonGroupWidth=0,this.options=void 0,this.chart=r,this.init(r)}return o.prototype.clickButton=function(r,t){var n=this,s=n.chart,a=n.buttonOptions[r],l=s.xAxis[0],h=s.scroller&&s.scroller.getUnionExtremes()||l||{},d=h.dataMin,c=h.dataMax,f,u=l&&Math.round(Math.min(l.max,pick$W(c,l.max))),p=a.type,g,m=a._range,v,x,y,b,$,S=a.dataGrouping;if(!(d===null||c===null)){if(s.fixedRange=m,n.setSelected(r),S&&(this.forcedDataGrouping=!0,Axis.prototype.setDataGrouping.call(l||{chart:this.chart},S,!1),this.frozenStates=a.preserveDataGrouping),p==="month"||p==="year")l?(b={range:a,max:u,chart:s,dataMin:d,dataMax:c},f=l.minFromRange.call(b),isNumber$o(b.newMax)&&(u=b.newMax)):m=a;else if(m)f=Math.max(u-m,d),u=Math.min(f+m,c);else if(p==="ytd")if(l)typeof c>"u"&&(d=Number.MAX_VALUE,c=Number.MIN_VALUE,s.series.forEach(function(k){var A=k.xData;d=Math.min(A[0],d),c=Math.max(A[A.length-1],c)}),t=!1),$=n.getYTDExtremes(c,d,s.time.useUTC),f=v=$.min,u=$.max;else{n.deferredYTDClick=r;return}else p==="all"&&l&&(s.navigator&&s.navigator.baseSeries[0]&&(s.navigator.baseSeries[0].xAxis.options.range=void 0),f=d,u=c);defined$r(f)&&(f+=a._offsetMin),defined$r(u)&&(u+=a._offsetMax),this.dropdown&&(this.dropdown.selectedIndex=r+1),l?l.setExtremes(f,u,pick$W(t,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:a}):(g=splat$8(s.options.xAxis)[0],y=g.range,g.range=m,x=g.min,g.min=v,addEvent$E(s,"load",function(){g.range=y,g.min=x})),fireEvent$j(this,"afterBtnClick")}},o.prototype.setSelected=function(r){this.selected=this.options.selected=r},o.prototype.init=function(r){var t=this,n=r.options.rangeSelector,s=n.buttons||t.defaultButtons.slice(),a=n.selected,l=function(){var h=t.minInput,d=t.maxInput;h&&h.blur&&fireEvent$j(h,"blur"),d&&d.blur&&fireEvent$j(d,"blur")};t.chart=r,t.options=n,t.buttons=[],t.buttonOptions=s,this.eventsToUnbind=[],this.eventsToUnbind.push(addEvent$E(r.container,"mousedown",l)),this.eventsToUnbind.push(addEvent$E(r,"resize",l)),s.forEach(t.computeButtonRange),typeof a<"u"&&s[a]&&this.clickButton(a,!1),this.eventsToUnbind.push(addEvent$E(r,"load",function(){r.xAxis&&r.xAxis[0]&&addEvent$E(r.xAxis[0],"setExtremes",function(h){this.max-this.min!==r.fixedRange&&h.trigger!=="rangeSelectorButton"&&h.trigger!=="updatedData"&&t.forcedDataGrouping&&!t.frozenStates&&this.setDataGrouping(!1,!1)})}))},o.prototype.updateButtonStates=function(){var r=this,t=this.chart,n=this.dropdown,s=t.xAxis[0],a=Math.round(s.max-s.min),l=!s.hasVisibleSeries,h=24*36e5,d=t.scroller&&t.scroller.getUnionExtremes()||s,c=d.dataMin,f=d.dataMax,u=r.getYTDExtremes(f,c,t.time.useUTC),p=u.min,g=u.max,m=r.selected,v=isNumber$o(m),x=r.options.allButtonsEnabled,y=r.buttons;r.buttonOptions.forEach(function(b,$){var S=b._range,k=b.type,A=b.count||1,P=y[$],E=0,M,C,O=b._offsetMax-b._offsetMin,L=$===m,T=S>f-c,_=S<s.minRange,D=!1,N=!1,I=S===a;(k==="month"||k==="year")&&a+36e5>={month:28,year:365}[k]*h*A-O&&a-36e5<={month:31,year:366}[k]*h*A+O?I=!0:k==="ytd"?(I=g-p+O===a,D=!L):k==="all"&&(I=s.max-s.min>=f-c,N=!L&&v&&I),M=!x&&(T||_||N||l),C=L&&I||I&&!v&&!D||L&&r.frozenStates,M?E=3:C&&(v=!0,E=2),P.state!==E&&(P.setState(E),n&&(n.options[$+1].disabled=M,E===2&&(n.selectedIndex=$+1)),E===0&&m===$&&r.setSelected())})},o.prototype.computeButtonRange=function(r){var t=r.type,n=r.count||1,s={millisecond:1,second:1e3,minute:60*1e3,hour:3600*1e3,day:24*3600*1e3,week:7*24*3600*1e3};s[t]?r._range=s[t]*n:(t==="month"||t==="year")&&(r._range={month:30,year:365}[t]*24*36e5*n),r._offsetMin=pick$W(r.offsetMin,0),r._offsetMax=pick$W(r.offsetMax,0),r._range+=r._offsetMax-r._offsetMin},o.prototype.getInputValue=function(r){var t=r==="min"?this.minInput:this.maxInput,n=this.chart.options.rangeSelector,s=this.chart.time;return t?(t.type==="text"&&n.inputDateParser||this.defaultInputDateParser)(t.value,s.useUTC,s):0},o.prototype.setInputValue=function(r,t){var n=this.options,s=this.chart.time,a=r==="min"?this.minInput:this.maxInput,l=r==="min"?this.minDateBox:this.maxDateBox;if(a){var h=a.getAttribute("data-hc-time"),d=defined$r(h)?Number(h):void 0;if(defined$r(t)){var c=d;defined$r(c)&&a.setAttribute("data-hc-time-previous",c),a.setAttribute("data-hc-time",t),d=t}a.value=s.dateFormat(this.inputTypeFormats[a.type]||n.inputEditDateFormat,d),l&&l.attr({text:s.dateFormat(n.inputDateFormat,d)})}},o.prototype.setInputExtremes=function(r,t,n){var s=r==="min"?this.minInput:this.maxInput;if(s){var a=this.inputTypeFormats[s.type],l=this.chart.time;if(a){var h=l.dateFormat(a,t);s.min!==h&&(s.min=h);var d=l.dateFormat(a,n);s.max!==d&&(s.max=d)}}},o.prototype.showInput=function(r){var t=r==="min"?this.minDateBox:this.maxDateBox,n=r==="min"?this.minInput:this.maxInput;if(n&&t&&this.inputGroup){var s=n.type==="text",a=this.inputGroup,l=a.translateX,h=a.translateY,d=this.options.inputBoxWidth;css$2(n,{width:s?t.width+(d?-2:20)+"px":"auto",height:s?t.height-2+"px":"auto",border:"2px solid silver"}),s&&d?css$2(n,{left:l+t.x+"px",top:h+"px"}):css$2(n,{left:Math.min(Math.round(t.x+l-(n.offsetWidth-t.width)/2),this.chart.chartWidth-n.offsetWidth)+"px",top:h-(n.offsetHeight-t.height)/2+"px"})}},o.prototype.hideInput=function(r){var t=r==="min"?this.minInput:this.maxInput;t&&css$2(t,{top:"-9999em",border:0,width:"1px",height:"1px"})},o.prototype.defaultInputDateParser=function(r,t,n){var s=function(c){return c.length>6&&(c.lastIndexOf("-")===c.length-6||c.lastIndexOf("+")===c.length-6)},a=r.split("/").join("-").split(" ").join("T");if(a.indexOf("T")===-1&&(a+="T00:00"),t)a+="Z";else if(H.isSafari&&!s(a)){var l=new Date(a).getTimezoneOffset()/60;a+=l<=0?"+"+pad(-l)+":00":"-"+pad(l)+":00"}var h=Date.parse(a);if(!isNumber$o(h)){var d=r.split("-");h=Date.UTC(pInt$3(d[0]),pInt$3(d[1])-1,pInt$3(d[2]))}return n&&t&&isNumber$o(h)&&(h+=n.getTimezoneOffset(h)),h},o.prototype.drawInput=function(r){var t=this,n=t.chart,s=t.div,a=t.inputGroup,l=this,h=n.renderer.style||{},d=n.renderer,c=n.options.rangeSelector,f=defaultOptions$5.lang,u=r==="min";function p(){var b=l.getInputValue(r),$=n.xAxis[0],S=n.scroller&&n.scroller.xAxis?n.scroller.xAxis:$,k=S.dataMin,A=S.dataMax,P=l.maxInput,E=l.minInput;b!==Number(x.getAttribute("data-hc-time-previous"))&&isNumber$o(b)&&(x.setAttribute("data-hc-time-previous",b),u&&P&&isNumber$o(k)?b>Number(P.getAttribute("data-hc-time"))?b=void 0:b<k&&(b=k):E&&isNumber$o(A)&&(b<Number(E.getAttribute("data-hc-time"))?b=void 0:b>A&&(b=A)),typeof b<"u"&&$.setExtremes(u?b:$.min,u?$.max:b,void 0,void 0,{trigger:"rangeSelectorInput"}))}var g=f[u?"rangeSelectorFrom":"rangeSelectorTo"]||"",m=d.label(g,0).addClass("highcharts-range-label").attr({padding:g?2:0,height:g?c.inputBoxHeight:0}).add(a),v=d.label("",0).addClass("highcharts-range-input").attr({padding:2,width:c.inputBoxWidth,height:c.inputBoxHeight,"text-align":"center"}).on("click",function(){l.showInput(r),l[r+"Input"].focus()});n.styledMode||v.attr({stroke:c.inputBoxBorderColor,"stroke-width":1}),v.add(a);var x=createElement$3("input",{name:r,className:"highcharts-range-selector"},void 0,s);x.setAttribute("type",preferredInputType(c.inputDateFormat||"%b %e, %Y")),n.styledMode||(m.css(merge$Q(h,c.labelStyle)),v.css(merge$Q({color:palette.neutralColor80},h,c.inputStyle)),css$2(x,extend$_({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:h.fontSize,fontFamily:h.fontFamily,top:"-9999em"},c.inputStyle))),x.onfocus=function(){l.showInput(r)},x.onblur=function(){x===H.doc.activeElement&&p(),l.hideInput(r),l.setInputValue(r),x.blur()};var y=!1;return x.onchange=function(){y||(p(),l.hideInput(r),x.blur())},x.onkeypress=function(b){b.keyCode===13&&p()},x.onkeydown=function(b){y=!0,(b.keyCode===38||b.keyCode===40)&&p()},x.onkeyup=function(){y=!1},{dateBox:v,input:x,label:m}},o.prototype.getPosition=function(){var r=this.chart,t=r.options.rangeSelector,n=t.verticalAlign==="top"?r.plotTop-r.axisOffset[0]:0;return{buttonTop:n+t.buttonPosition.y,inputTop:n+t.inputPosition.y-10}},o.prototype.getYTDExtremes=function(r,t,n){var s=this.chart.time,a,l=new s.Date(r),h=s.get("FullYear",l),d=n?s.Date.UTC(h,0,1):+new s.Date(h,0,1);a=Math.max(t,d);var c=l.getTime();return{max:Math.min(r||c,c),min:a}},o.prototype.render=function(r,t){var n=this.chart,s=n.renderer,a=n.container,l=n.options,h=l.rangeSelector,d=pick$W(l.chart.style&&l.chart.style.zIndex,0)+1,c=h.inputEnabled,f=this.rendered;if(h.enabled!==!1){if(!f&&(this.group=s.g("range-selector-group").attr({zIndex:7}).add(),this.div=createElement$3("div",void 0,{position:"relative",height:0,zIndex:d}),this.buttonOptions.length&&this.renderButtons(),a.parentNode&&a.parentNode.insertBefore(this.div,a),c)){this.inputGroup=s.g("input-group").add(this.group);var u=this.drawInput("min");this.minDateBox=u.dateBox,this.minLabel=u.label,this.minInput=u.input;var p=this.drawInput("max");this.maxDateBox=p.dateBox,this.maxLabel=p.label,this.maxInput=p.input}if(c){this.setInputValue("min",r),this.setInputValue("max",t);var g=n.scroller&&n.scroller.getUnionExtremes()||n.xAxis[0]||{};if(defined$r(g.dataMin)&&defined$r(g.dataMax)){var m=n.xAxis[0].minRange||0;this.setInputExtremes("min",g.dataMin,Math.min(g.dataMax,this.getInputValue("max"))-m),this.setInputExtremes("max",Math.max(g.dataMin,this.getInputValue("min"))+m,g.dataMax)}if(this.inputGroup){var v=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(x){if(x){var y=x.getBBox().width;y&&(x.attr({x:v}),v+=y+h.inputSpacing)}})}}this.alignElements(),this.rendered=!0}},o.prototype.renderButtons=function(){var r=this,t=this,n=t.buttons,s=t.chart,a=t.options,l=defaultOptions$5.lang,h=s.renderer,d=merge$Q(a.buttonTheme),c=d&&d.states,f=d.width||28;delete d.width,delete d.states,this.buttonGroup=h.g("range-selector-buttons").add(this.group);var u=this.dropdown=createElement$3("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:1e-4},this.div);addEvent$E(u,"touchstart",function(){u.style.fontSize="16px"}),[[H.isMS?"mouseover":"mouseenter"],[H.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(p){var g=p[0],m=p[1];addEvent$E(u,g,function(){var v=n[r.currentButtonIndex()];v&&fireEvent$j(v.element,m||g)})}),this.zoomText=h.label(l&&l.rangeSelectorZoom||"",0).attr({padding:a.buttonTheme.padding,height:a.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup),this.chart.styledMode||(this.zoomText.css(a.labelStyle),d["stroke-width"]=pick$W(d["stroke-width"],0)),createElement$3("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,u),this.buttonOptions.forEach(function(p,g){createElement$3("option",{textContent:p.title||p.text},void 0,u),n[g]=h.button(p.text,0,0,function(m){var v=p.events&&p.events.click,x;v&&(x=v.call(p,m)),x!==!1&&r.clickButton(g),r.isActive=!0},d,c&&c.hover,c&&c.select,c&&c.disabled).attr({"text-align":"center",width:f}).add(r.buttonGroup),p.title&&n[g].attr("title",p.title)})},o.prototype.alignElements=function(){var r=this,t=this,n=t.buttonGroup,s=t.buttons,a=t.chart,l=t.group,h=t.inputGroup,d=t.options,c=t.zoomText,f=a.options,u=f.exporting&&f.exporting.enabled!==!1&&f.navigation&&f.navigation.buttonOptions,p=d.buttonPosition,g=d.inputPosition,m=d.verticalAlign,v=function(_,D){return u&&r.titleCollision(a)&&m==="top"&&D.align==="right"&&D.y-_.getBBox().height-12<(u.y||0)+(u.height||0)+a.spacing[0]?-40:0},x=a.plotLeft;if(l&&p&&g){var y=p.x-a.spacing[3];if(n){if(this.positionButtons(),!this.initialButtonGroupWidth){var b=0;c&&(b+=c.getBBox().width+5),s.forEach(function(_,D){b+=_.width,D!==s.length-1&&(b+=d.buttonSpacing)}),this.initialButtonGroupWidth=b}x-=a.spacing[3],this.updateButtonStates();var $=v(n,p);this.alignButtonGroup($),l.placed=n.placed=a.hasLoaded}var S=0;h&&(S=v(h,g),g.align==="left"?y=x:g.align==="right"&&(y=-Math.max(a.axisOffset[1],-S)),h.align({y:g.y,width:h.getBBox().width,align:g.align,x:g.x+y-2},!0,a.spacingBox),h.placed=a.hasLoaded),this.handleCollision(S),l.align({verticalAlign:m},!0,a.spacingBox);var k=l.alignAttr.translateY,A=l.getBBox().height+20,P=0;if(m==="bottom"){var E=a.legend&&a.legend.options,M=E&&E.verticalAlign==="bottom"&&E.enabled&&!E.floating?a.legend.legendHeight+pick$W(E.margin,10):0;A=A+M-20,P=k-A-(d.floating?0:d.y)-(a.titleOffset?a.titleOffset[2]:0)-10}m==="top"?(d.floating&&(P=0),a.titleOffset&&a.titleOffset[0]&&(P=a.titleOffset[0]),P+=a.margin[0]-a.spacing[0]||0):m==="middle"&&(g.y===p.y?P=k:(g.y||p.y)&&(g.y<0||p.y<0?P-=Math.min(g.y,p.y):P=k-A)),l.translate(d.x,d.y+Math.floor(P));var C=this,O=C.minInput,L=C.maxInput,T=C.dropdown;d.inputEnabled&&O&&L&&(O.style.marginTop=l.translateY+"px",L.style.marginTop=l.translateY+"px"),T&&(T.style.marginTop=l.translateY+"px")}},o.prototype.alignButtonGroup=function(r,t){var n=this,s=n.chart,a=n.options,l=n.buttonGroup;n.buttons;var h=a.buttonPosition,d=s.plotLeft-s.spacing[3],c=h.x-s.spacing[3];h.align==="right"?c+=r-d:h.align==="center"&&(c-=d/2),l&&l.align({y:h.y,width:pick$W(t,this.initialButtonGroupWidth),align:h.align,x:c},!0,s.spacingBox)},o.prototype.positionButtons=function(){var r=this,t=r.buttons,n=r.chart,s=r.options,a=r.zoomText,l=n.hasLoaded?"animate":"attr",h=s.buttonPosition,d=n.plotLeft,c=d;a&&a.visibility!=="hidden"&&(a[l]({x:pick$W(d+h.x,d)}),c+=h.x+a.getBBox().width+5),this.buttonOptions.forEach(function(f,u){t[u].visibility!=="hidden"?(t[u][l]({x:c}),c+=t[u].width+s.buttonSpacing):t[u][l]({x:d})})},o.prototype.handleCollision=function(r){var t=this,n=this,s=n.chart,a=n.buttonGroup,l=n.inputGroup,h=this.options,d=h.buttonPosition,c=h.dropdown,f=h.inputPosition,u=function(){var m=0;return t.buttons.forEach(function(v){var x=v.getBBox();x.width>m&&(m=x.width)}),m},p=function(m){if(l&&a){var v=l.alignAttr.translateX+l.alignOptions.x-r+l.getBBox().x+2,x=l.alignOptions.width,y=a.alignAttr.translateX+a.getBBox().x;return y+m>v&&v+x>y&&d.y<f.y+l.getBBox().height}return!1},g=function(){l&&a&&l.attr({translateX:l.alignAttr.translateX+(s.axisOffset[1]>=-r?0:-r),translateY:l.alignAttr.translateY+a.getBBox().height+10})};if(a){if(c==="always"){this.collapseButtons(r),p(u())&&g();return}c==="never"&&this.expandButtons()}l&&a?f.align===d.align||p(this.initialButtonGroupWidth+20)?c==="responsive"?(this.collapseButtons(r),p(u())&&g()):g():c==="responsive"&&this.expandButtons():a&&c==="responsive"&&(this.initialButtonGroupWidth>s.plotWidth?this.collapseButtons(r):this.expandButtons())},o.prototype.collapseButtons=function(r){var t=this,n=t.buttons,s=t.buttonOptions,a=t.chart,l=t.dropdown,h=t.options,d=t.zoomText,c=a.userOptions.rangeSelector&&a.userOptions.rangeSelector.buttonTheme||{},f=function(g){return{text:g?g+" ▾":"▾",width:"auto",paddingLeft:pick$W(h.buttonTheme.paddingLeft,c.padding,8),paddingRight:pick$W(h.buttonTheme.paddingRight,c.padding,8)}};d&&d.hide();var u=!1;s.forEach(function(g,m){var v=n[m];v.state!==2?v.hide():(v.show(),v.attr(f(g.text)),u=!0)}),u||(l&&(l.selectedIndex=0),n[0].show(),n[0].attr(f(this.zoomText&&this.zoomText.textStr)));var p=h.buttonPosition.align;this.positionButtons(),(p==="right"||p==="center")&&this.alignButtonGroup(r,n[this.currentButtonIndex()].getBBox().width),this.showDropdown()},o.prototype.expandButtons=function(){var r=this,t=r.buttons,n=r.buttonOptions,s=r.options,a=r.zoomText;this.hideDropdown(),a&&a.show(),n.forEach(function(l,h){var d=t[h];d.show(),d.attr({text:l.text,width:s.buttonTheme.width||28,paddingLeft:pick$W(s.buttonTheme.paddingLeft,"unset"),paddingRight:pick$W(s.buttonTheme.paddingRight,"unset")}),d.state<2&&d.setState(0)}),this.positionButtons()},o.prototype.currentButtonIndex=function(){var r=this.dropdown;return r&&r.selectedIndex>0?r.selectedIndex-1:0},o.prototype.showDropdown=function(){var r=this,t=r.buttonGroup,n=r.buttons,s=r.chart,a=r.dropdown;if(t&&a){var l=t.translateX,h=t.translateY,d=n[this.currentButtonIndex()].getBBox();css$2(a,{left:s.plotLeft+l+"px",top:h+.5+"px",width:d.width+"px",height:d.height+"px"}),this.hasVisibleDropdown=!0}},o.prototype.hideDropdown=function(){var r=this.dropdown;r&&(css$2(r,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)},o.prototype.getHeight=function(){var r=this,t=r.options,n=r.group,s=t.inputPosition,a=t.buttonPosition,l=t.y,h=a.y,d=s.y,c=0,f;return t.height?t.height:(this.alignElements(),c=n?n.getBBox(!0).height+13+l:0,f=Math.min(d,h),(d<0&&h<0||d>0&&h>0)&&(c+=Math.abs(f)),c)},o.prototype.titleCollision=function(r){return!(r.options.title.text||r.options.subtitle.text)},o.prototype.update=function(r){var t=this.chart;merge$Q(!0,t.options.rangeSelector,r),this.destroy(),this.init(t),this.render()},o.prototype.destroy=function(){var r=this,t=r.minInput,n=r.maxInput;r.eventsToUnbind&&(r.eventsToUnbind.forEach(function(s){return s()}),r.eventsToUnbind=void 0),destroyObjectProperties$1(r.buttons),t&&(t.onfocus=t.onblur=t.onchange=null),n&&(n.onfocus=n.onblur=n.onchange=null),objectEach$d(r,function(s,a){s&&a!=="chart"&&(s instanceof SVGElement?s.destroy():s instanceof window.HTMLElement&&discardElement$2(s)),s!==o.prototype[a]&&(r[a]=null)},this)},o}();RangeSelector.prototype.defaultButtons=[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}];RangeSelector.prototype.inputTypeFormats={"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"};function preferredInputType(o){var r=o.indexOf("%L")!==-1;if(r)return"text";var t=["a","A","d","e","w","b","B","m","o","y","Y"].some(function(s){return o.indexOf("%"+s)!==-1}),n=["H","k","I","l","M","S"].some(function(s){return o.indexOf("%"+s)!==-1});return t&&n?"datetime-local":t?"date":n?"time":"text"}Axis.prototype.minFromRange=function(){var o=this.range,r=o.type,t,n=this.max,s,a,l=this.chart.time,h=function(d,c){var f=r==="year"?"FullYear":"Month",u=new l.Date(d),p=l.get(f,u);return l.set(f,u,p+c),p===l.get(f,u)&&l.set("Date",u,0),u.getTime()-d};return isNumber$o(o)?(t=n-o,a=o):(t=n+h(n,-o.count),this.chart&&(this.chart.fixedRange=n-t)),s=pick$W(this.dataMin,Number.MIN_VALUE),isNumber$o(t)||(t=s),t<=s&&(t=s,typeof a>"u"&&(a=h(t,o.count)),this.newMax=Math.min(t+a,this.dataMax)),isNumber$o(n)||(t=void 0),t};if(!H.RangeSelector){var chartDestroyEvents_1=[],initRangeSelector_1=function(o){var r,t=o.rangeSelector,n,s,a;function l(){t&&(r=o.xAxis[0].getExtremes(),n=o.legend,a=t&&t.options.verticalAlign,isNumber$o(r.min)&&t.render(r.min,r.max),n.display&&a==="top"&&a===n.options.verticalAlign&&(s=merge$Q(o.spacingBox),n.options.layout==="vertical"?s.y=o.plotTop:s.y+=t.getHeight(),n.group.placed=!1,n.align(s)))}if(t){var h=find$b(chartDestroyEvents_1,function(d){return d[0]===o});h||chartDestroyEvents_1.push([o,[addEvent$E(o.xAxis[0],"afterSetExtremes",function(d){t&&t.render(d.min,d.max)}),addEvent$E(o,"redraw",l)]]),l()}};addEvent$E(Chart$1,"afterGetContainer",function(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new RangeSelector(this))}),addEvent$E(Chart$1,"beforeRender",function(){var o=this,r=o.axes,t=o.rangeSelector,n;t&&(isNumber$o(t.deferredYTDClick)&&(t.clickButton(t.deferredYTDClick),delete t.deferredYTDClick),r.forEach(function(s){s.updateNames(),s.setScale()}),o.getAxisMargins(),t.render(),n=t.options.verticalAlign,t.options.floating||(n==="bottom"?this.extraBottomMargin=!0:n!=="middle"&&(this.extraTopMargin=!0)))}),addEvent$E(Chart$1,"update",function(o){var r=this,t=o.options,n=t.rangeSelector,s=r.rangeSelector,a,l=this.extraBottomMargin,h=this.extraTopMargin;n&&n.enabled&&!defined$r(s)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=s=new RangeSelector(this)),this.extraBottomMargin=!1,this.extraTopMargin=!1,s&&(initRangeSelector_1(this),a=n&&n.verticalAlign||s.options&&s.options.verticalAlign,s.options.floating||(a==="bottom"?this.extraBottomMargin=!0:a!=="middle"&&(this.extraTopMargin=!0)),(this.extraBottomMargin!==l||this.extraTopMargin!==h)&&(this.isDirtyBox=!0))}),addEvent$E(Chart$1,"render",function(){var o=this,r=o.rangeSelector,t;r&&!r.options.floating&&(r.render(),t=r.options.verticalAlign,t==="bottom"?this.extraBottomMargin=!0:t!=="middle"&&(this.extraTopMargin=!0))}),addEvent$E(Chart$1,"getMargins",function(){var o=this.rangeSelector,r;o&&(r=o.getHeight(),this.extraTopMargin&&(this.plotTop+=r),this.extraBottomMargin&&(this.marginBottom+=r))}),Chart$1.prototype.callbacks.push(initRangeSelector_1),addEvent$E(Chart$1,"destroy",function(){for(var r=0;r<chartDestroyEvents_1.length;r++){var t=chartDestroyEvents_1[r];if(t[0]===this){t[1].forEach(function(n){return n()}),chartDestroyEvents_1.splice(r,1);return}}}),H.RangeSelector=RangeSelector}var __extends$G=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),animObject$4=animationExports.animObject,format$6=FormatUtilities.format,getOptions$2=DefaultOptions.getOptions,pointTooltipFormatter=Point$2.prototype.tooltipFormatter,_a$c=Series$e.prototype,seriesInit=_a$c.init,seriesProcessData=_a$c.processData,addEvent$D=Utilities.addEvent,arrayMax$4=Utilities.arrayMax,arrayMin$4=Utilities.arrayMin,clamp$9=Utilities.clamp,defined$q=Utilities.defined,extend$Z=Utilities.extend,find$a=Utilities.find,isNumber$n=Utilities.isNumber,isString$3=Utilities.isString,merge$P=Utilities.merge,pick$V=Utilities.pick,splat$7=Utilities.splat,StockChart=function(o){__extends$G(r,o);function r(){return o!==null&&o.apply(this,arguments)||this}return r.prototype.init=function(t,n){var s=getOptions$2(),a=t.xAxis,l=t.yAxis,h=pick$V(t.navigator&&t.navigator.enabled,s.navigator.enabled,!0);t.xAxis=t.yAxis=void 0;var d=merge$P({chart:{panning:{enabled:!0,type:"x"},pinchType:"x"},navigator:{enabled:h},scrollbar:{enabled:pick$V(s.scrollbar&&s.scrollbar.enabled,!0)},rangeSelector:{enabled:pick$V(s.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:pick$V(s.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},t,{isStock:!0});t.xAxis=a,t.yAxis=l,d.xAxis=splat$7(t.xAxis||{}).map(function(c,f){return merge$P(getDefaultAxisOptions("xAxis",c),s.xAxis,s.xAxis&&s.xAxis[f],c,getForcedAxisOptions("xAxis",t))}),d.yAxis=splat$7(t.yAxis||{}).map(function(c,f){return merge$P(getDefaultAxisOptions("yAxis",c),s.yAxis,s.yAxis&&s.yAxis[f],c)}),o.prototype.init.call(this,d,n)},r.prototype.createAxis=function(t,n){return n.axis=merge$P(getDefaultAxisOptions(t,n.axis),n.axis,getForcedAxisOptions(t,this.userOptions)),o.prototype.createAxis.call(this,t,n)},r}(Chart$1);(function(o){function r(t,n,s){return new o(t,n,s)}o.stockChart=r})(StockChart);function getDefaultAxisOptions(o,r){return o==="xAxis"?{minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0}:o==="yAxis"?{labels:{y:-2},opposite:pick$V(r.opposite,!0),showLastLabel:!!(r.categories||r.type==="category"),title:{text:null}}:{}}function getForcedAxisOptions(o,r){if(o==="xAxis"){var t=getOptions$2(),n=pick$V(r.navigator&&r.navigator.enabled,t.navigator.enabled,!0),s={type:"datetime",categories:void 0};return n&&(s.startOnTick=!1,s.endOnTick=!1),s}return{}}addEvent$D(Series$e,"setOptions",function(o){var r;this.chart.options.isStock&&(this.is("column")||this.is("columnrange")?r={borderWidth:0,shadow:!1}:!this.is("scatter")&&!this.is("sma")&&(r={marker:{enabled:!1,radius:2}}),r&&(o.plotOptions[this.type]=merge$P(o.plotOptions[this.type],r)))});addEvent$D(Axis,"autoLabelAlign",function(o){var r=this.chart,t=this.options,n=r._labelPanes=r._labelPanes||{},s,a=this.options.labels;this.chart.options.isStock&&this.coll==="yAxis"&&(s=t.top+","+t.height,!n[s]&&a.enabled&&(a.x===15&&(a.x=0),typeof a.align>"u"&&(a.align="right"),n[s]=this,o.align="right",o.preventDefault()))});addEvent$D(Axis,"destroy",function(){var o=this.chart,r=this.options&&this.options.top+","+this.options.height;r&&o._labelPanes&&o._labelPanes[r]===this&&delete o._labelPanes[r]});addEvent$D(Axis,"getPlotLinePath",function(o){var r=this,t=this.isLinked&&!this.series?this.linkedParent.series:this.series,n=r.chart,s=n.renderer,a=r.left,l=r.top,h,d,c,f,u=[],p=[],g,m,v=o.translatedValue,x=o.value,y=o.force,b;function $(S){var k=S==="xAxis"?"yAxis":"xAxis",A=r.options[k];return isNumber$n(A)?[n[k][A]]:isString$3(A)?[n.get(A)]:t.map(function(P){return P[k]})}(n.options.isStock&&o.acrossPanes!==!1&&r.coll==="xAxis"||r.coll==="yAxis")&&(o.preventDefault(),p=$(r.coll),g=r.isXAxis?n.yAxis:n.xAxis,g.forEach(function(S){if(!defined$q(S.options.id)||S.options.id.indexOf("navigator")===-1){var k=S.isXAxis?"yAxis":"xAxis",A=defined$q(S.options[k])?n[k][S.options[k]]:n[k][0];r===A&&p.push(S)}}),m=p.length?[]:[r.isXAxis?n.yAxis[0]:n.xAxis[0]],p.forEach(function(S){m.indexOf(S)===-1&&!find$a(m,function(k){return k.pos===S.pos&&k.len===S.len})&&m.push(S)}),b=pick$V(v,r.translate(x,null,null,o.old)),isNumber$n(b)&&(r.horiz?m.forEach(function(S){var k;d=S.pos,f=d+S.len,h=c=Math.round(b+r.transB),y!=="pass"&&(h<a||h>a+r.width)&&(y?h=c=clamp$9(h,a,a+r.width):k=!0),k||u.push(["M",h,d],["L",c,f])}):m.forEach(function(S){var k;h=S.pos,c=h+S.len,d=f=Math.round(l+r.height-b),y!=="pass"&&(d<l||d>l+r.height)&&(y?d=f=clamp$9(d,l,l+r.height):k=!0),k||u.push(["M",h,d],["L",c,f])})),o.path=u.length>0?s.crispPolyLine(u,o.lineWidth||1):null)});SVGRenderer.prototype.crispPolyLine=function(o,r){for(var t=0;t<o.length;t=t+2){var n=o[t],s=o[t+1];n[1]===s[1]&&(n[1]=s[1]=Math.round(n[1])-r%2/2),n[2]===s[2]&&(n[2]=s[2]=Math.round(n[2])+r%2/2)}return o};addEvent$D(Axis,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});addEvent$D(Axis,"afterDrawCrosshair",function(o){if(!(!this.crosshair||!this.crosshair.label||!this.crosshair.label.enabled||!this.cross||!isNumber$n(this.min)||!isNumber$n(this.max))){var r=this.chart,t=this.logarithmic,n=this.crosshair.label,s=this.horiz,a=this.opposite,l=this.left,h=this.top,d=this.crossLabel,c,f,u,p=n.format,g="",m,v,x=this.options.tickPosition==="inside",y=this.crosshair.snap!==!1,b=0,$=o.e||this.cross&&this.cross.e,S=o.point,k=this.min,A=this.max;t&&(k=t.lin2log(k),A=t.lin2log(A)),v=s?"center":a?this.labelAlign==="right"?"right":"left":this.labelAlign==="left"?"left":"center",d||(d=this.crossLabel=r.renderer.label("",0,void 0,n.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+(S?S.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:n.align||v,padding:pick$V(n.padding,8),r:pick$V(n.borderRadius,3),zIndex:2}).add(this.labelGroup),r.styledMode||d.attr({fill:n.backgroundColor||S&&S.series&&S.series.color||palette.neutralColor60,stroke:n.borderColor||"","stroke-width":n.borderWidth||0}).css(extend$Z({color:palette.backgroundColor,fontWeight:"normal",fontSize:"11px",textAlign:"center"},n.style||{}))),s?(c=y?(S.plotX||0)+l:$.chartX,f=h+(a?0:this.height)):(c=a?this.width+l:0,f=y?(S.plotY||0)+h:$.chartY),!p&&!n.formatter&&(this.dateTime&&(g="%b %d, %Y"),p="{value"+(g?":"+g:"")+"}");var P=y?this.isXAxis?S.x:S.y:this.toValue(s?$.chartX:$.chartY),E=S?S.series.isPointInside(S):isNumber$n(P)&&P>k&&P<A,M="";p?M=format$6(p,{value:P},r):n.formatter&&isNumber$n(P)&&(M=n.formatter.call(this,P)),d.attr({text:M,x:c,y:f,visibility:E?"visible":"hidden"}),u=d.getBBox(),isNumber$n(d.y)&&(s?(x&&!a||!x&&a)&&(f=d.y-u.height):f=d.y-u.height/2),s?m={left:l-u.x,right:l+this.width-u.x}:m={left:this.labelAlign==="left"?l:0,right:this.labelAlign==="right"?l+this.width:r.chartWidth},d.translateX<m.left&&(b=m.left-d.translateX),d.translateX+u.width>=m.right&&(b=-(d.translateX+u.width-m.right)),d.attr({x:c+b,y:f,anchorX:s?c:this.opposite?0:r.chartWidth,anchorY:s?this.opposite?r.chartHeight:0:f+u.height/2})}});Series$e.prototype.init=function(){seriesInit.apply(this,arguments),this.initCompare(this.options.compare)};Series$e.prototype.setCompare=function(o){this.initCompare(o),this.userOptions.compare=o};Series$e.prototype.initCompare=function(o){this.modifyValue=o==="value"||o==="percent"?function(r,t){var n=this.compareValue;return typeof r<"u"&&typeof n<"u"?(o==="value"?r-=n:r=100*(r/n)-(this.options.compareBase===100?0:100),t&&(t.change=r),r):0}:null,this.chart.hasRendered&&(this.isDirty=!0)};Series$e.prototype.forceCropping=function(){var o=this.chart,r=this.options,t=r.dataGrouping,n=this.allowDG!==!1&&t&&pick$V(t.enabled,o.options.isStock);return n};Series$e.prototype.processData=function(o){var r=this,t,n=-1,s,a,l=r.options.compareStart===!0?0:1,h,d;if(seriesProcessData.apply(this,arguments),r.xAxis&&r.processedYData){for(s=r.processedXData,a=r.processedYData,h=a.length,r.pointArrayMap&&(n=r.pointArrayMap.indexOf(r.options.pointValKey||r.pointValKey||"y")),t=0;t<h-l;t++)if(d=a[t]&&n>-1?a[t][n]:a[t],isNumber$n(d)&&s[t+l]>=r.xAxis.min&&d!==0){r.compareValue=d;break}}};addEvent$D(Series$e,"afterGetExtremes",function(o){var r=o.dataExtremes;if(this.modifyValue&&r){var t=[this.modifyValue(r.dataMin),this.modifyValue(r.dataMax)];r.dataMin=arrayMin$4(t),r.dataMax=arrayMax$4(t)}});Axis.prototype.setCompare=function(o,r){this.isXAxis||(this.series.forEach(function(t){t.setCompare(o)}),pick$V(r,!0)&&this.chart.redraw())};Point$2.prototype.tooltipFormatter=function(o){var r=this,t=r.series.chart.numberFormatter;return o=o.replace("{point.change}",(r.change>0?"+":"")+t(r.change,pick$V(r.series.tooltipOptions.changeDecimals,2))),pointTooltipFormatter.apply(this,[o])};addEvent$D(Series$e,"render",function(){var o=this.chart,r;if(!(o.is3d&&o.is3d())&&!o.polar&&this.xAxis&&!this.xAxis.isRadial&&this.options.clip!==!1){if(r=this.yAxis.len,this.xAxis.axisLine){var t=o.plotTop+o.plotHeight-this.yAxis.pos-this.yAxis.len,n=Math.floor(this.xAxis.axisLine.strokeWidth()/2);t>=0&&(r-=Math.max(n-t,0))}if((!o.hasLoaded||!this.clipBox&&this.isDirty&&!this.isDirtyData)&&(this.clipBox=this.clipBox||merge$P(o.clipBox),this.clipBox.width=this.xAxis.len,this.clipBox.height=r),o.hasRendered){var s=animObject$4(this.options.animation),a=this.getSharedClipKey(s),l=o.sharedClips[a];if(l){l.animate({width:this.xAxis.len,height:r});var h=o.sharedClips[a+"m"];h&&h.animate({width:this.xAxis.len})}}}});addEvent$D(Chart$1,"update",function(o){var r=o.options;"scrollbar"in r&&this.navigator&&(merge$P(!0,this.options.scrollbar,r.scrollbar),this.navigator.update({},!1),delete r.scrollbar)});/**
 * @license Highstock JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/stock
 * @requires highcharts
 *
 * Highcharts Stock as a plugin for Highcharts
 *
 * (c) 2010-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$5=H;G$5.Scrollbar=Scrollbar;G$5.StockChart=G$5.stockChart=StockChart.stockChart;Scrollbar.compose(G$5.Axis);OrdinalAxis$1.compose(G$5.Axis,G$5.Series,G$5.Chart);/**
 * @license Highstock JS v9.2.2 (2021-08-24)
 * @module highcharts/highstock
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */G$7.product="Highstock";var doc$f=H.doc,win$6=H.win,merge$O=Utilities.merge;function addClass$1(o,r){o.classList?o.classList.add(r):o.className.indexOf(r)<0&&(o.className+=r)}function escapeStringForHTML$1(o){return o.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#x27;").replace(/\//g,"&#x2F;")}function getElement$2(o){return doc$f.getElementById(o)}function getFakeMouseEvent$2(o){if(typeof win$6.MouseEvent=="function")return new win$6.MouseEvent(o);if(doc$f.createEvent){var r=doc$f.createEvent("MouseEvent");if(r.initMouseEvent)return r.initMouseEvent(o,!0,!0,win$6,o==="click"?1:0,0,0,0,0,!1,!1,!1,!1,0,null),r}return{type:o}}function getHeadingTagNameForElement$1(o){var r=function(a){var l=parseInt(a.slice(1),10),h=Math.min(6,l+1);return"h"+h},t=function(a){return/H[1-6]/.test(a)},n=function(a){for(var l=a;l=l.previousSibling;){var h=l.tagName||"";if(t(h))return h}return""},s=function(a){var l=n(a);if(l)return r(l);var h=a.parentElement;if(!h)return"p";var d=h.tagName;return t(d)?r(d):s(h)};return s(o)}function removeElement$5(o){o&&o.parentNode&&o.parentNode.removeChild(o)}function reverseChildNodes$1(o){for(var r=o.childNodes.length;r--;)o.appendChild(o.childNodes[r])}function setElAttrs$4(o,r){Object.keys(r).forEach(function(t){var n=r[t];n===null?o.removeAttribute(t):o.setAttribute(t,n)})}function stripHTMLTagsFromString$2(o){return typeof o=="string"?o.replace(/<\/?[^>]+(>|$)/g,""):o}function visuallyHideElement$2(o){var r={position:"absolute",width:"1px",height:"1px",overflow:"hidden",whiteSpace:"nowrap",clip:"rect(1px, 1px, 1px, 1px)",marginTop:"-3px","-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity=1)",filter:"alpha(opacity=1)",opacity:"0.01"};merge$O(!0,o.style,r)}var HTMLUtilities={addClass:addClass$1,escapeStringForHTML:escapeStringForHTML$1,getElement:getElement$2,getFakeMouseEvent:getFakeMouseEvent$2,getHeadingTagNameForElement:getHeadingTagNameForElement$1,removeElement:removeElement$5,reverseChildNodes:reverseChildNodes$1,setElAttrs:setElAttrs$4,stripHTMLTagsFromString:stripHTMLTagsFromString$2,visuallyHideElement:visuallyHideElement$2},stripHTMLTags$3=HTMLUtilities.stripHTMLTagsFromString,doc$e=H.doc,defined$p=Utilities.defined,find$9=Utilities.find,fireEvent$i=Utilities.fireEvent;function getChartTitle$5(o){return stripHTMLTags$3(o.options.title.text||o.langFormat("accessibility.defaultChartTitle",{chart:o}))}function getAxisDescription$2(o){return o&&(o.userOptions&&o.userOptions.accessibility&&o.userOptions.accessibility.description||o.axisTitle&&o.axisTitle.textStr||o.options.id||o.categories&&"categories"||o.dateTime&&"Time"||"values")}function getAxisRangeDescription$2(o){var r=o.options||{};return r.accessibility&&typeof r.accessibility.rangeDescription<"u"?r.accessibility.rangeDescription:o.categories?getCategoryAxisRangeDesc(o):o.dateTime&&(o.min===0||o.dataMin===0)?getAxisTimeLengthDesc(o):getAxisFromToDescription(o)}function getCategoryAxisRangeDesc(o){var r=o.chart;return o.dataMax&&o.dataMin?r.langFormat("accessibility.axis.rangeCategories",{chart:r,axis:o,numCategories:o.dataMax-o.dataMin+1}):""}function getAxisTimeLengthDesc(o){var r=o.chart,t={},n="Seconds";t.Seconds=((o.max||0)-(o.min||0))/1e3,t.Minutes=t.Seconds/60,t.Hours=t.Minutes/60,t.Days=t.Hours/24,["Minutes","Hours","Days"].forEach(function(a){t[a]>2&&(n=a)});var s=t[n].toFixed(n!=="Seconds"&&n!=="Minutes"?1:0);return r.langFormat("accessibility.axis.timeRange"+n,{chart:r,axis:o,range:s.replace(".0","")})}function getAxisFromToDescription(o){var r=o.chart,t=r.options&&r.options.accessibility&&r.options.accessibility.screenReaderSection.axisRangeDateFormat||"",n=function(s){return o.dateTime?r.time.dateFormat(t,o[s]):o[s]};return r.langFormat("accessibility.axis.rangeFromTo",{chart:r,axis:o,rangeFrom:n("min"),rangeTo:n("max")})}function getSeriesFirstPointElement$1(o){if(o.points&&o.points.length){var r=find$9(o.points,function(t){return!!t.graphic});return r&&r.graphic&&r.graphic.element}}function getSeriesA11yElement$1(o){var r=getSeriesFirstPointElement$1(o);return r&&r.parentNode||o.graph&&o.graph.element||o.group&&o.group.element}function unhideChartElementFromAT$7(o,r){r.setAttribute("aria-hidden",!1),!(r===o.renderTo||!r.parentNode||r.parentNode===doc$e.body)&&(Array.prototype.forEach.call(r.parentNode.childNodes,function(t){t.hasAttribute("aria-hidden")||t.setAttribute("aria-hidden",!0)}),unhideChartElementFromAT$7(o,r.parentNode))}function hideSeriesFromAT$1(o){var r=getSeriesA11yElement$1(o);r&&r.setAttribute("aria-hidden",!0)}function getSeriesFromName$1(o,r){return r?(o.series||[]).filter(function(t){return t.name===r}):o.series}function getPointFromXY$1(o,r,t){for(var n=o.length,s;n--;)if(s=find$9(o[n].points||[],function(a){return a.x===r&&a.y===t}),s)return s}function getRelativePointAxisPosition(o,r){if(!defined$p(o.dataMin)||!defined$p(o.dataMax))return 0;var t=o.toPixels(o.dataMin),n=o.toPixels(o.dataMax),s=o.coll==="xAxis"?"x":"y",a=o.toPixels(r[s]||0);return(a-t)/(n-t)}function scrollToPoint$1(o){var r=o.series.xAxis,t=o.series.yAxis,n=r&&r.scrollbar?r:t,s=n&&n.scrollbar;if(s&&defined$p(s.to)&&defined$p(s.from)){var a=s.to-s.from,l=getRelativePointAxisPosition(n,o);s.updatePosition(l-a/2,l+a/2),fireEvent$i(s,"changed",{from:s.from,to:s.to,trigger:"scrollbar",DOMEvent:null})}}var ChartUtilities={getChartTitle:getChartTitle$5,getAxisDescription:getAxisDescription$2,getAxisRangeDescription:getAxisRangeDescription$2,getPointFromXY:getPointFromXY$1,getSeriesFirstPointElement:getSeriesFirstPointElement$1,getSeriesFromName:getSeriesFromName$1,getSeriesA11yElement:getSeriesA11yElement$1,unhideChartElementFromAT:unhideChartElementFromAT$7,hideSeriesFromAT:hideSeriesFromAT$1,scrollToPoint:scrollToPoint$1},find$8=Utilities.find;function KeyboardNavigationHandler(o,r){this.chart=o,this.keyCodeMap=r.keyCodeMap||[],this.validate=r.validate,this.init=r.init,this.terminate=r.terminate,this.response={success:1,prev:2,next:3,noHandler:4,fail:5}}KeyboardNavigationHandler.prototype={run:function(o){var r=o.which||o.keyCode,t=this.response.noHandler,n=find$8(this.keyCodeMap,function(s){return s[0].indexOf(r)>-1});return n?t=n[1].call(this,r,o):r===9&&(t=this.response[o.shiftKey?"prev":"next"]),t}};var doc$d=H.doc,removeElement$4=HTMLUtilities.removeElement,extend$Y=Utilities.extend,DOMElementProvider=function(){this.elements=[]};extend$Y(DOMElementProvider.prototype,{createElement:function(){var o=doc$d.createElement.apply(doc$d,arguments);return this.elements.push(o),o},destroyCreatedElements:function(){this.elements.forEach(function(o){removeElement$4(o)}),this.elements=[]}});var addEvent$C=Utilities.addEvent,extend$X=Utilities.extend,EventProvider=function(){this.eventRemovers=[]};extend$X(EventProvider.prototype,{addEvent:function(){var o=addEvent$C.apply(H,arguments);return this.eventRemovers.push(o),o},removeAddedEvents:function(){this.eventRemovers.forEach(function(o){o()}),this.eventRemovers=[]}});var unhideChartElementFromAT$6=ChartUtilities.unhideChartElementFromAT,doc$c=H.doc,win$5=H.win,removeElement$3=HTMLUtilities.removeElement,getFakeMouseEvent$1=HTMLUtilities.getFakeMouseEvent,extend$W=Utilities.extend,fireEvent$h=Utilities.fireEvent,merge$N=Utilities.merge,functionsToOverrideByDerivedClasses={init:function(){},getKeyboardNavigation:function(){},onChartUpdate:function(){},onChartRender:function(){},destroy:function(){}};function AccessibilityComponent(){}AccessibilityComponent.prototype={initBase:function(o){this.chart=o,this.eventProvider=new EventProvider,this.domElementProvider=new DOMElementProvider,this.keyCodes={left:37,right:39,up:38,down:40,enter:13,space:32,esc:27,tab:9}},addEvent:function(){return this.eventProvider.addEvent.apply(this.eventProvider,arguments)},createElement:function(){return this.domElementProvider.createElement.apply(this.domElementProvider,arguments)},fireEventOnWrappedOrUnwrappedElement:function(o,r){var t=r.type;doc$c.createEvent&&(o.dispatchEvent||o.fireEvent)?o.dispatchEvent?o.dispatchEvent(r):o.fireEvent(t,r):fireEvent$h(o,t,r)},fakeClickEvent:function(o){if(o){var r=getFakeMouseEvent$1("click");this.fireEventOnWrappedOrUnwrappedElement(o,r)}},addProxyGroup:function(o){this.createOrUpdateProxyContainer();var r=this.createElement("div");return Object.keys(o||{}).forEach(function(t){o[t]!==null&&r.setAttribute(t,o[t])}),this.chart.a11yProxyContainer.appendChild(r),r},createOrUpdateProxyContainer:function(){var o=this.chart,r=o.renderer.box;o.a11yProxyContainer=o.a11yProxyContainer||this.createProxyContainerElement(),r.nextSibling!==o.a11yProxyContainer&&o.container.insertBefore(o.a11yProxyContainer,r.nextSibling)},createProxyContainerElement:function(){var o=doc$c.createElement("div");return o.className="highcharts-a11y-proxy-container",o},createProxyButton:function(o,r,t,n,s){var a=o.element,l=this.createElement("button"),h=merge$N({"aria-label":a.getAttribute("aria-label")},t);return Object.keys(h).forEach(function(d){h[d]!==null&&l.setAttribute(d,h[d])}),l.className="highcharts-a11y-proxy-button",o.hasClass("highcharts-no-tooltip")&&(l.className+=" highcharts-no-tooltip"),s&&this.addEvent(l,"click",s),this.setProxyButtonStyle(l),this.updateProxyButtonPosition(l,n||o),this.proxyMouseEventsForButton(a,l),r.appendChild(l),h["aria-hidden"]||unhideChartElementFromAT$6(this.chart,l),l},getElementPosition:function(o){var r=o.element,t=this.chart.renderTo;if(t&&r&&r.getBoundingClientRect){var n=r.getBoundingClientRect(),s=t.getBoundingClientRect();return{x:n.left-s.left,y:n.top-s.top,width:n.right-n.left,height:n.bottom-n.top}}return{x:0,y:0,width:1,height:1}},setProxyButtonStyle:function(o){merge$N(!0,o.style,{borderWidth:"0",backgroundColor:"transparent",cursor:"pointer",outline:"none",opacity:"0.001",filter:"alpha(opacity=1)",zIndex:"999",overflow:"hidden",padding:"0",margin:"0",display:"block",position:"absolute"}),o.style["-ms-filter"]="progid:DXImageTransform.Microsoft.Alpha(Opacity=1)"},updateProxyButtonPosition:function(o,r){var t=this.getElementPosition(r);merge$N(!0,o.style,{width:(t.width||1)+"px",height:(t.height||1)+"px",left:(Math.round(t.x)||0)+"px",top:(Math.round(t.y)||0)+"px"})},proxyMouseEventsForButton:function(o,r){var t=this;["click","touchstart","touchend","touchcancel","touchmove","mouseover","mouseenter","mouseleave","mouseout"].forEach(function(n){var s=n.indexOf("touch")===0;t.addEvent(r,n,function(a){var l=s?t.cloneTouchEvent(a):t.cloneMouseEvent(a);o&&t.fireEventOnWrappedOrUnwrappedElement(o,l),a.stopPropagation(),n!=="touchstart"&&n!=="touchmove"&&n!=="touchend"&&a.preventDefault()},{passive:!1})})},cloneMouseEvent:function(o){if(typeof win$5.MouseEvent=="function")return new win$5.MouseEvent(o.type,o);if(doc$c.createEvent){var r=doc$c.createEvent("MouseEvent");if(r.initMouseEvent)return r.initMouseEvent(o.type,o.bubbles,o.cancelable,o.view||win$5,o.detail,o.screenX,o.screenY,o.clientX,o.clientY,o.ctrlKey,o.altKey,o.shiftKey,o.metaKey,o.button,o.relatedTarget),r}return getFakeMouseEvent$1(o.type)},cloneTouchEvent:function(o){var r=function(s){for(var a=[],l=0;l<s.length;++l){var h=s.item(l);h&&a.push(h)}return a};if(typeof win$5.TouchEvent=="function"){var t=new win$5.TouchEvent(o.type,{touches:r(o.touches),targetTouches:r(o.targetTouches),changedTouches:r(o.changedTouches),ctrlKey:o.ctrlKey,shiftKey:o.shiftKey,altKey:o.altKey,metaKey:o.metaKey,bubbles:o.bubbles,cancelable:o.cancelable,composed:o.composed,detail:o.detail,view:o.view});return o.defaultPrevented&&t.preventDefault(),t}var n=this.cloneMouseEvent(o);return n.touches=o.touches,n.changedTouches=o.changedTouches,n.targetTouches=o.targetTouches,n},destroyBase:function(){removeElement$3(this.chart.a11yProxyContainer),this.domElementProvider.destroyCreatedElements(),this.eventProvider.removeAddedEvents()}};extend$W(AccessibilityComponent.prototype,functionsToOverrideByDerivedClasses);var doc$b=H.doc,win$4=H.win,addEvent$B=Utilities.addEvent,fireEvent$g=Utilities.fireEvent,getElement$1=HTMLUtilities.getElement;addEvent$B(doc$b,"keydown",function(o){var r=o.which||o.keyCode,t=27;r===t&&H.charts&&H.charts.forEach(function(n){n&&n.dismissPopupContent&&n.dismissPopupContent()})});Chart$1.prototype.dismissPopupContent=function(){var o=this;fireEvent$g(this,"dismissPopupContent",{},function(){o.tooltip&&o.tooltip.hide(0),o.hideExportMenu()})};function KeyboardNavigation(o,r){this.init(o,r)}KeyboardNavigation.prototype={init:function(o,r){var t=this,n=this.eventProvider=new EventProvider;this.chart=o,this.components=r,this.modules=[],this.currentModuleIx=0,this.update(),n.addEvent(this.tabindexContainer,"keydown",function(s){return t.onKeydown(s)}),n.addEvent(this.tabindexContainer,"focus",function(s){return t.onFocus(s)}),["mouseup","touchend"].forEach(function(s){return n.addEvent(doc$b,s,function(){return t.onMouseUp()})}),["mousedown","touchstart"].forEach(function(s){return n.addEvent(o.renderTo,s,function(){t.isClickingChart=!0})}),n.addEvent(o.renderTo,"mouseover",function(){t.pointerIsOverChart=!0}),n.addEvent(o.renderTo,"mouseout",function(){t.pointerIsOverChart=!1}),this.modules.length&&this.modules[0].init(1)},update:function(o){var r=this.chart.options.accessibility,t=r&&r.keyboardNavigation,n=this.components;this.updateContainerTabindex(),t&&t.enabled&&o&&o.length?(this.modules=o.reduce(function(s,a){var l=n[a].getKeyboardNavigation();return s.concat(l)},[]),this.updateExitAnchor()):(this.modules=[],this.currentModuleIx=0,this.removeExitAnchor())},onFocus:function(o){var r=this.chart,t=o.relatedTarget&&r.container.contains(o.relatedTarget);!this.exiting&&!this.tabbingInBackwards&&!this.isClickingChart&&!t&&this.modules[0]&&this.modules[0].init(1),this.exiting=!1},onMouseUp:function(){if(delete this.isClickingChart,!this.keyboardReset&&!this.pointerIsOverChart){var o=this.chart,r=this.modules&&this.modules[this.currentModuleIx||0];r&&r.terminate&&r.terminate(),o.focusElement&&o.focusElement.removeFocusBorder(),this.currentModuleIx=0,this.keyboardReset=!0}},onKeydown:function(o){var r=o||win$4.event,t,n=this.modules&&this.modules.length&&this.modules[this.currentModuleIx];if(this.keyboardReset=!1,this.exiting=!1,n){var s=n.run(r);s===n.response.success?t=!0:s===n.response.prev?t=this.prev():s===n.response.next&&(t=this.next()),t&&(r.preventDefault(),r.stopPropagation())}},prev:function(){return this.move(-1)},next:function(){return this.move(1)},move:function(o){var r=this.modules&&this.modules[this.currentModuleIx];r&&r.terminate&&r.terminate(o),this.chart.focusElement&&this.chart.focusElement.removeFocusBorder(),this.currentModuleIx+=o;var t=this.modules&&this.modules[this.currentModuleIx];if(t){if(t.validate&&!t.validate())return this.move(o);if(t.init)return t.init(o),!0}return this.currentModuleIx=0,this.exiting=!0,o>0?this.exitAnchor.focus():this.tabindexContainer.focus(),!1},updateExitAnchor:function(){var o="highcharts-end-of-chart-marker-"+this.chart.index,r=getElement$1(o);this.removeExitAnchor(),r?(this.makeElementAnExitAnchor(r),this.exitAnchor=r):this.createExitAnchor()},updateContainerTabindex:function(){var o=this.chart.options.accessibility,r=o&&o.keyboardNavigation,t=!(r&&r.enabled===!1),n=this.chart,s=n.container,a;n.renderTo.hasAttribute("tabindex")?(s.removeAttribute("tabindex"),a=n.renderTo):a=s,this.tabindexContainer=a;var l=a.getAttribute("tabindex");t&&!l?a.setAttribute("tabindex","0"):t||n.container.removeAttribute("tabindex")},makeElementAnExitAnchor:function(o){var r=this.tabindexContainer.getAttribute("tabindex")||0;o.setAttribute("class","highcharts-exit-anchor"),o.setAttribute("tabindex",r),o.setAttribute("aria-hidden",!1),this.addExitAnchorEventsToEl(o)},createExitAnchor:function(){var o=this.chart,r=this.exitAnchor=doc$b.createElement("div");o.renderTo.appendChild(r),this.makeElementAnExitAnchor(r)},removeExitAnchor:function(){this.exitAnchor&&this.exitAnchor.parentNode&&(this.exitAnchor.parentNode.removeChild(this.exitAnchor),delete this.exitAnchor)},addExitAnchorEventsToEl:function(o){var r=this.chart,t=this;this.eventProvider.addEvent(o,"focus",function(n){var s=n||win$4.event,a,l=s.relatedTarget&&r.container.contains(s.relatedTarget),h=!(l||t.exiting);h?(t.tabbingInBackwards=!0,t.tabindexContainer.focus(),delete t.tabbingInBackwards,s.preventDefault(),t.modules&&t.modules.length&&(t.currentModuleIx=t.modules.length-1,a=t.modules[t.currentModuleIx],a&&a.validate&&!a.validate()?t.prev():a&&a.init(-1))):t.exiting=!1})},destroy:function(){this.removeExitAnchor(),this.eventProvider.removeAddedEvents(),this.chart.container.removeAttribute("tabindex")}};var animObject$3=animationExports.animObject,addEvent$A=Utilities.addEvent,extend$V=Utilities.extend,find$7=Utilities.find,fireEvent$f=Utilities.fireEvent,isNumber$m=Utilities.isNumber,pick$U=Utilities.pick,syncTimeout$1=Utilities.syncTimeout,removeElement$2=HTMLUtilities.removeElement,stripHTMLTags$2=HTMLUtilities.stripHTMLTagsFromString,getChartTitle$4=ChartUtilities.getChartTitle;function scrollLegendToItem(o,r){var t=o.allItems[r].pageIx,n=o.currentPage;typeof t<"u"&&t+1!==n&&o.scroll(1+t-n)}function shouldDoLegendA11y(o){var r=o.legend&&o.legend.allItems,t=o.options.legend.accessibility||{};return!!(r&&r.length&&!(o.colorAxis&&o.colorAxis.length)&&t.enabled!==!1)}Chart$1.prototype.highlightLegendItem=function(o){var r=this.legend.allItems,t=this.accessibility&&this.accessibility.components.legend.highlightedLegendItemIx;return r[o]?(isNumber$m(t)&&r[t]&&fireEvent$f(r[t].legendGroup.element,"mouseout"),scrollLegendToItem(this.legend,o),this.setFocusToElement(r[o].legendItem,r[o].a11yProxyElement),fireEvent$f(r[o].legendGroup.element,"mouseover"),!0):!1};addEvent$A(Legend,"afterColorizeItem",function(o){var r=this.chart,t=r.options.accessibility,n=o.item;t.enabled&&n&&n.a11yProxyElement&&n.a11yProxyElement.setAttribute("aria-pressed",o.visible?"true":"false")});var LegendComponent=function(){};LegendComponent.prototype=new AccessibilityComponent;extend$V(LegendComponent.prototype,{init:function(){var o=this;this.proxyElementsList=[],this.recreateProxies(),this.addEvent(Legend,"afterScroll",function(){this.chart===o.chart&&(o.updateProxiesPositions(),o.updateLegendItemProxyVisibility(),this.chart.highlightLegendItem(o.highlightedLegendItemIx))}),this.addEvent(Legend,"afterPositionItem",function(r){this.chart===o.chart&&this.chart.renderer&&o.updateProxyPositionForItem(r.item)}),this.addEvent(Legend,"afterRender",function(){this.chart===o.chart&&this.chart.renderer&&o.recreateProxies()&&syncTimeout$1(function(){return o.updateProxiesPositions()},animObject$3(pick$U(this.chart.renderer.globalAnimation,!0)).duration)})},updateLegendItemProxyVisibility:function(){var o=this.chart.legend,r=o.allItems||[],t=o.currentPage||1,n=o.clipHeight||0;r.forEach(function(s){var a=s.pageIx||0,l=s._legendItemPos?s._legendItemPos[1]:0,h=s.legendItem?Math.round(s.legendItem.getBBox().height):0,d=l+h-o.pages[a]>n||a!==t-1;s.a11yProxyElement&&(s.a11yProxyElement.style.visibility=d?"hidden":"visible")})},onChartRender:function(){shouldDoLegendA11y(this.chart)||this.removeProxies()},onChartUpdate:function(){this.updateLegendTitle()},updateProxiesPositions:function(){for(var o=0,r=this.proxyElementsList;o<r.length;o++){var t=r[o],n=t.element,s=t.posElement;this.updateProxyButtonPosition(n,s)}},updateProxyPositionForItem:function(o){var r=find$7(this.proxyElementsList,function(t){return t.item===o});r&&this.updateProxyButtonPosition(r.element,r.posElement)},recreateProxies:function(){return this.removeProxies(),shouldDoLegendA11y(this.chart)?(this.addLegendProxyGroup(),this.addLegendListContainer(),this.proxyLegendItems(),this.updateLegendItemProxyVisibility(),!0):!1},removeProxies:function(){removeElement$2(this.legendProxyGroup),this.proxyElementsList=[]},updateLegendTitle:function(){var o=this.chart,r=stripHTMLTags$2((o.legend&&o.legend.options.title&&o.legend.options.title.text||"").replace(/<br ?\/?>/g," ")),t=o.langFormat("accessibility.legend.legendLabel"+(r?"":"NoTitle"),{chart:o,legendTitle:r,chartTitle:getChartTitle$4(o)});this.legendProxyGroup&&this.legendProxyGroup.setAttribute("aria-label",t)},addLegendProxyGroup:function(){var o=this.chart.options.accessibility,r=o.landmarkVerbosity==="all"?"region":null;this.legendProxyGroup=this.addProxyGroup({"aria-label":"_placeholder_",role:r})},addLegendListContainer:function(){if(this.legendProxyGroup){var o=this.legendListContainer=this.createElement("ul");o.style.listStyle="none",this.legendProxyGroup.appendChild(o)}},proxyLegendItems:function(){var o=this,r=this.chart.legend&&this.chart.legend.allItems||[];r.forEach(function(t){t.legendItem&&t.legendItem.element&&o.proxyLegendItem(t)})},proxyLegendItem:function(o){if(!(!o.legendItem||!o.legendGroup||!this.legendListContainer)){var r=this.chart.langFormat("accessibility.legend.legendItem",{chart:this.chart,itemName:stripHTMLTags$2(o.name),item:o}),t={tabindex:-1,"aria-pressed":o.visible,"aria-label":r},n=o.legendGroup.div?o.legendItem:o.legendGroup,s=this.createElement("li");this.legendListContainer.appendChild(s),o.a11yProxyElement=this.createProxyButton(o.legendItem,s,t,n),this.proxyElementsList.push({item:o,element:o.a11yProxyElement,posElement:n})}},getKeyboardNavigation:function(){var o=this.keyCodes,r=this,t=this.chart;return new KeyboardNavigationHandler(t,{keyCodeMap:[[[o.left,o.right,o.up,o.down],function(n){return r.onKbdArrowKey(this,n)}],[[o.enter,o.space],function(n){return H.isFirefox&&n===o.space?this.response.success:r.onKbdClick(this)}]],validate:function(){return r.shouldHaveLegendNavigation()},init:function(n){return r.onKbdNavigationInit(n)},terminate:function(){t.legend.allItems.forEach(function(n){return n.setState("",!0)})}})},onKbdArrowKey:function(o,r){var t=this.keyCodes,n=o.response,s=this.chart,a=s.options.accessibility,l=s.legend.allItems.length,h=r===t.left||r===t.up?-1:1,d=s.highlightLegendItem(this.highlightedLegendItemIx+h);return d?(this.highlightedLegendItemIx+=h,n.success):l>1&&a.keyboardNavigation.wrapAround?(o.init(h),n.success):n[h>0?"next":"prev"]},onKbdClick:function(o){var r=this.chart.legend.allItems[this.highlightedLegendItemIx];return r&&r.a11yProxyElement&&fireEvent$f(r.a11yProxyElement,"click"),o.response.success},shouldHaveLegendNavigation:function(){var o=this.chart,r=o.options.legend||{},t=o.legend&&o.legend.allItems,n=o.colorAxis&&o.colorAxis.length,s=r.accessibility||{};return!!(t&&o.legend.display&&!n&&s.enabled&&s.keyboardNavigation&&s.keyboardNavigation.enabled)},onKbdNavigationInit:function(o){var r=this.chart,t=r.legend.allItems.length-1,n=o>0?0:t;r.highlightLegendItem(n),this.highlightedLegendItemIx=n}});var extend$U=Utilities.extend,getChartTitle$3=ChartUtilities.getChartTitle,unhideChartElementFromAT$5=ChartUtilities.unhideChartElementFromAT,removeElement$1=HTMLUtilities.removeElement,getFakeMouseEvent=HTMLUtilities.getFakeMouseEvent;function getExportMenuButtonElement(o){return o.exportSVGElements&&o.exportSVGElements[0]}Chart$1.prototype.showExportMenu=function(){var o=getExportMenuButtonElement(this);if(o){var r=o.element;r.onclick&&r.onclick(getFakeMouseEvent("click"))}};Chart$1.prototype.hideExportMenu=function(){var o=this,r=o.exportDivElements;r&&o.exportContextMenu&&(r.forEach(function(t){t&&t.className==="highcharts-menu-item"&&t.onmouseout&&t.onmouseout(getFakeMouseEvent("mouseout"))}),o.highlightedExportItemIx=0,o.exportContextMenu.hideMenu(),o.container.focus())};Chart$1.prototype.highlightExportItem=function(o){var r=this.exportDivElements&&this.exportDivElements[o],t=this.exportDivElements&&this.exportDivElements[this.highlightedExportItemIx],n;return r&&r.tagName==="LI"&&!(r.children&&r.children.length)?(n=!!(this.renderTo.getElementsByTagName("g")[0]||{}).focus,r.focus&&n&&r.focus(),t&&t.onmouseout&&t.onmouseout(getFakeMouseEvent("mouseout")),r.onmouseover&&r.onmouseover(getFakeMouseEvent("mouseover")),this.highlightedExportItemIx=o,!0):!1};Chart$1.prototype.highlightLastExportItem=function(){var o=this,r;if(o.exportDivElements){for(r=o.exportDivElements.length;r--;)if(o.highlightExportItem(r))return!0}return!1};function exportingShouldHaveA11y(o){var r=o.options.exporting,t=getExportMenuButtonElement(o);return!!(r&&r.enabled!==!1&&r.accessibility&&r.accessibility.enabled&&t&&t.element)}var MenuComponent=function(){};MenuComponent.prototype=new AccessibilityComponent;extend$U(MenuComponent.prototype,{init:function(){var o=this.chart,r=this;this.addEvent(o,"exportMenuShown",function(){r.onMenuShown()}),this.addEvent(o,"exportMenuHidden",function(){r.onMenuHidden()})},onMenuHidden:function(){var o=this.chart.exportContextMenu;o&&o.setAttribute("aria-hidden","true"),this.isExportMenuShown=!1,this.setExportButtonExpandedState("false")},onMenuShown:function(){var o=this.chart,r=o.exportContextMenu;r&&(this.addAccessibleContextMenuAttribs(),unhideChartElementFromAT$5(o,r)),this.isExportMenuShown=!0,this.setExportButtonExpandedState("true")},setExportButtonExpandedState:function(o){var r=this.exportButtonProxy;r&&r.setAttribute("aria-expanded",o)},onChartRender:function(){var o=this.chart,r=o.options.accessibility;if(removeElement$1(this.exportProxyGroup),exportingShouldHaveA11y(o)){this.exportProxyGroup=this.addProxyGroup(r.landmarkVerbosity==="all"?{"aria-label":o.langFormat("accessibility.exporting.exportRegionLabel",{chart:o,chartTitle:getChartTitle$3(o)}),role:"region"}:{});var t=getExportMenuButtonElement(this.chart);this.exportButtonProxy=this.createProxyButton(t,this.exportProxyGroup,{"aria-label":o.langFormat("accessibility.exporting.menuButtonLabel",{chart:o}),"aria-expanded":!1})}},addAccessibleContextMenuAttribs:function(){var o=this.chart,r=o.exportDivElements;if(r&&r.length){r.forEach(function(n){n&&(n.tagName==="LI"&&!(n.children&&n.children.length)?n.setAttribute("tabindex",-1):n.setAttribute("aria-hidden","true"))});var t=r[0]&&r[0].parentNode;t&&(t.removeAttribute("aria-hidden"),t.setAttribute("aria-label",o.langFormat("accessibility.exporting.chartMenuLabel",{chart:o})))}},getKeyboardNavigation:function(){var o=this.keyCodes,r=this.chart,t=this;return new KeyboardNavigationHandler(r,{keyCodeMap:[[[o.left,o.up],function(){return t.onKbdPrevious(this)}],[[o.right,o.down],function(){return t.onKbdNext(this)}],[[o.enter,o.space],function(){return t.onKbdClick(this)}]],validate:function(){return!!r.exporting&&r.options.exporting.enabled!==!1&&r.options.exporting.accessibility.enabled!==!1},init:function(){var n=t.exportButtonProxy,s=r.exportingGroup;s&&n&&r.setFocusToElement(s,n)},terminate:function(){r.hideExportMenu()}})},onKbdPrevious:function(o){for(var r=this.chart,t=r.options.accessibility,n=o.response,s=r.highlightedExportItemIx||0;s--;)if(r.highlightExportItem(s))return n.success;return t.keyboardNavigation.wrapAround?(r.highlightLastExportItem(),n.success):n.prev},onKbdNext:function(o){for(var r=this.chart,t=r.options.accessibility,n=o.response,s=(r.highlightedExportItemIx||0)+1;s<r.exportDivElements.length;++s)if(r.highlightExportItem(s))return n.success;return t.keyboardNavigation.wrapAround?(r.highlightExportItem(0),n.success):n.next},onKbdClick:function(o){var r=this.chart,t=r.exportDivElements[r.highlightedExportItemIx],n=getExportMenuButtonElement(r).element;return this.isExportMenuShown?this.fakeClickEvent(t):(this.fakeClickEvent(n),r.highlightExportItem(0)),o.response.success}});var seriesTypes$4=SeriesRegistry$1.seriesTypes,doc$a=H.doc,defined$o=Utilities.defined,extend$T=Utilities.extend,fireEvent$e=Utilities.fireEvent,getPointFromXY=ChartUtilities.getPointFromXY,getSeriesFromName=ChartUtilities.getSeriesFromName,scrollToPoint=ChartUtilities.scrollToPoint;Series$e.prototype.keyboardMoveVertical=!0;["column","pie"].forEach(function(o){seriesTypes$4[o]&&(seriesTypes$4[o].prototype.keyboardMoveVertical=!1)});function getPointIndex(o){var r=o.index,t=o.series.points,n=t.length;if(t[r]!==o){for(;n--;)if(t[n]===o)return n}else return r}function isSkipSeries(o){var r=o.chart.options.accessibility,t=r.keyboardNavigation.seriesNavigation,n=o.options.accessibility||{},s=n.keyboardNavigation;return s&&s.enabled===!1||n.enabled===!1||o.options.enableMouseTracking===!1||!o.visible||t.pointNavigationEnabledThreshold&&t.pointNavigationEnabledThreshold<=o.points.length}function isSkipPoint(o){var r=o.series.chart.options.accessibility,t=o.options.accessibility&&o.options.accessibility.enabled===!1;return o.isNull&&r.keyboardNavigation.seriesNavigation.skipNullPoints||o.visible===!1||o.isInside===!1||t||isSkipSeries(o.series)}function getClosestPoint(o,r,t,n){var s=1/0,a,l,h,d=r.points.length,c=function(f){return!(defined$o(f.plotX)&&defined$o(f.plotY))};if(!c(o)){for(;d--;)a=r.points[d],!c(a)&&(h=(o.plotX-a.plotX)*(o.plotX-a.plotX)*t+(o.plotY-a.plotY)*(o.plotY-a.plotY)*1,h<s&&(s=h,l=d));return defined$o(l)?r.points[l]:void 0}}Point$2.prototype.highlight=function(){var o=this.series.chart;return this.isNull?o.tooltip&&o.tooltip.hide(0):this.onMouseOver(),scrollToPoint(this),this.graphic&&o.setFocusToElement(this.graphic),o.highlightedPoint=this,this};Chart$1.prototype.highlightAdjacentPoint=function(o){var r=this,t=r.series,n=r.highlightedPoint,s=n&&getPointIndex(n)||0,a=n&&n.series.points,l=r.series&&r.series[r.series.length-1],h=l&&l.points&&l.points[l.points.length-1],d,c;if(!t[0]||!t[0].points)return!1;if(!n)c=o?t[0].points[0]:h;else if(d=t[n.series.index+(o?1:-1)],c=a[s+(o?1:-1)],!c&&d&&(c=d.points[o?0:d.points.length-1]),!c)return!1;return isSkipPoint(c)?(d=c.series,isSkipSeries(d)?r.highlightedPoint=o?d.points[d.points.length-1]:d.points[0]:r.highlightedPoint=c,r.highlightAdjacentPoint(o)):c.highlight()};Series$e.prototype.highlightFirstValidPoint=function(){var o=this.chart.highlightedPoint,r=(o&&o.series)===this?getPointIndex(o):0,t=this.points,n=t.length;if(t&&n){for(var s=r;s<n;++s)if(!isSkipPoint(t[s]))return t[s].highlight();for(var a=r;a>=0;--a)if(!isSkipPoint(t[a]))return t[a].highlight()}return!1};Chart$1.prototype.highlightAdjacentSeries=function(o){var r=this,t=r.highlightedPoint,n=r.series&&r.series[r.series.length-1],s=n&&n.points&&n.points[n.points.length-1],a,l,h;return r.highlightedPoint?(a=r.series[t.series.index+(o?-1:1)],!a||(l=getClosestPoint(t,a,4),!l)?!1:isSkipSeries(a)?(l.highlight(),h=r.highlightAdjacentSeries(o),h||(t.highlight(),!1)):(l.highlight(),l.series.highlightFirstValidPoint())):(a=o?r.series&&r.series[0]:n,l=o?a&&a.points&&a.points[0]:s,l?l.highlight():!1)};Chart$1.prototype.highlightAdjacentPointVertical=function(o){var r=this.highlightedPoint,t=1/0,n;return!defined$o(r.plotX)||!defined$o(r.plotY)?!1:(this.series.forEach(function(s){isSkipSeries(s)||s.points.forEach(function(a){if(!(!defined$o(a.plotY)||!defined$o(a.plotX)||a===r)){var l=a.plotY-r.plotY,h=Math.abs(a.plotX-r.plotX),d=Math.abs(l)*Math.abs(l)+h*h*4;s.yAxis&&s.yAxis.reversed&&(l*=-1),!(l<=0&&o||l>=0&&!o||d<5||isSkipPoint(a))&&d<t&&(t=d,n=a)}})}),n?n.highlight():!1)};function highlightFirstValidPointInChart(o){var r=!1;return delete o.highlightedPoint,r=o.series.reduce(function(t,n){return t||n.highlightFirstValidPoint()},!1),r}function highlightLastValidPointInChart(o){for(var r=o.series.length,t=r,n=!1;t--&&(o.highlightedPoint=o.series[t].points[o.series[t].points.length-1],n=o.series[t].highlightFirstValidPoint(),!n););return n}function updateChartFocusAfterDrilling(o){highlightFirstValidPointInChart(o),o.focusElement&&o.focusElement.removeFocusBorder()}function SeriesKeyboardNavigation(o,r){this.keyCodes=r,this.chart=o}extend$T(SeriesKeyboardNavigation.prototype,{init:function(){var o=this,r=this.chart,t=this.eventProvider=new EventProvider;t.addEvent(Series$e,"destroy",function(){return o.onSeriesDestroy(this)}),t.addEvent(r,"afterDrilldown",function(){updateChartFocusAfterDrilling(this)}),t.addEvent(r,"drilldown",function(n){var s=n.point,a=s.series;o.lastDrilledDownPoint={x:s.x,y:s.y,seriesName:a?a.name:""}}),t.addEvent(r,"drillupall",function(){setTimeout(function(){o.onDrillupAll()},10)}),t.addEvent(Point$2,"afterSetState",function(){var n=this,s=n.graphic&&n.graphic.element;r.highlightedPoint===n&&doc$a.activeElement!==s&&s&&s.focus&&s.focus()})},onDrillupAll:function(){var o=this.lastDrilledDownPoint,r=this.chart,t=o&&getSeriesFromName(r,o.seriesName),n;o&&t&&defined$o(o.x)&&defined$o(o.y)&&(n=getPointFromXY(t,o.x,o.y)),r.container&&r.container.focus(),n&&n.highlight&&n.highlight(),r.focusElement&&r.focusElement.removeFocusBorder()},getKeyboardNavigationHandler:function(){var o=this,r=this.keyCodes,t=this.chart,n=t.inverted;return new KeyboardNavigationHandler(t,{keyCodeMap:[[n?[r.up,r.down]:[r.left,r.right],function(s){return o.onKbdSideways(this,s)}],[n?[r.left,r.right]:[r.up,r.down],function(s){return o.onKbdVertical(this,s)}],[[r.enter,r.space],function(s,a){var l=t.highlightedPoint;return l&&(a.point=l,fireEvent$e(l.series,"click",a),l.firePointEvent("click")),this.response.success}]],init:function(s){return o.onHandlerInit(this,s)},terminate:function(){return o.onHandlerTerminate()}})},onKbdSideways:function(o,r){var t=this.keyCodes,n=r===t.right||r===t.down;return this.attemptHighlightAdjacentPoint(o,n)},onKbdVertical:function(o,r){var t=this.chart,n=this.keyCodes,s=r===n.down||r===n.right,a=t.options.accessibility.keyboardNavigation.seriesNavigation;if(a.mode&&a.mode==="serialize")return this.attemptHighlightAdjacentPoint(o,s);var l=t.highlightedPoint&&t.highlightedPoint.series.keyboardMoveVertical?"highlightAdjacentPointVertical":"highlightAdjacentSeries";return t[l](s),o.response.success},onHandlerInit:function(o,r){var t=this.chart;return r>0?highlightFirstValidPointInChart(t):highlightLastValidPointInChart(t),o.response.success},onHandlerTerminate:function(){var o=this.chart;o.tooltip&&o.tooltip.hide(0);var r=o.highlightedPoint&&o.highlightedPoint.series;r&&r.onMouseOut&&r.onMouseOut(),o.highlightedPoint&&o.highlightedPoint.onMouseOut&&o.highlightedPoint.onMouseOut(),delete o.highlightedPoint},attemptHighlightAdjacentPoint:function(o,r){var t=this.chart,n=t.options.accessibility.keyboardNavigation.wrapAround,s=t.highlightAdjacentPoint(r);return s?o.response.success:n?o.init(r?1:-1):o.response[r?"next":"prev"]},onSeriesDestroy:function(o){var r=this.chart,t=r.highlightedPoint&&r.highlightedPoint.series===o;t&&(delete r.highlightedPoint,r.focusElement&&r.focusElement.removeFocusBorder())},destroy:function(){this.eventProvider.removeAddedEvents()}});var escapeStringForHTML=HTMLUtilities.escapeStringForHTML,stripHTMLTagsFromString$1=HTMLUtilities.stripHTMLTagsFromString;function getChartAnnotationLabels(o){var r=o.annotations||[];return r.reduce(function(t,n){return n.options&&n.options.visible!==!1&&(t=t.concat(n.labels)),t},[])}function getLabelText(o){return o.options&&o.options.accessibility&&o.options.accessibility.description||o.graphic&&o.graphic.text&&o.graphic.text.textStr||""}function getAnnotationLabelDescription(o){var r=o.options&&o.options.accessibility&&o.options.accessibility.description;if(r)return r;var t=o.chart,n=getLabelText(o),s=o.points,a=function(p){return p.graphic&&p.graphic.element&&p.graphic.element.getAttribute("aria-label")||""},l=function(p){var g=p.accessibility&&p.accessibility.valueDescription||a(p),m=p&&p.series.name||"";return(m?m+", ":"")+"data point "+g},h=s.filter(function(p){return!!p.graphic}).map(l).filter(function(p){return!!p}),d=h.length,c=d>1?"MultiplePoints":d?"SinglePoint":"NoPoints",f="accessibility.screenReaderSection.annotations.description"+c,u={annotationText:n,annotation:o,numPoints:d,annotationPoint:h[0],additionalAnnotationPoints:h.slice(1)};return t.langFormat(f,u)}function getAnnotationListItems(o){var r=getChartAnnotationLabels(o);return r.map(function(t){var n=escapeStringForHTML(stripHTMLTagsFromString$1(getAnnotationLabelDescription(t)));return n?"<li>"+n+"</li>":""})}function getAnnotationsInfoHTML$1(o){var r=o.annotations;if(!(r&&r.length))return"";var t=getAnnotationListItems(o);return'<ul style="list-style-type: none">'+t.join(" ")+"</ul>"}function getPointAnnotationTexts$1(o){var r=getChartAnnotationLabels(o.series.chart),t=r.filter(function(n){return n.points.indexOf(o)>-1});return t.length?t.map(function(n){return""+getLabelText(n)}):[]}var AnnotationsA11y={getAnnotationsInfoHTML:getAnnotationsInfoHTML$1,getAnnotationLabelDescription,getAnnotationListItems,getPointAnnotationTexts:getPointAnnotationTexts$1},getPointAnnotationTexts=AnnotationsA11y.getPointAnnotationTexts,getAxisDescription$1=ChartUtilities.getAxisDescription,getSeriesFirstPointElement=ChartUtilities.getSeriesFirstPointElement,getSeriesA11yElement=ChartUtilities.getSeriesA11yElement,unhideChartElementFromAT$4=ChartUtilities.unhideChartElementFromAT,format$5=FormatUtilities.format,numberFormat=FormatUtilities.numberFormat,reverseChildNodes=HTMLUtilities.reverseChildNodes,stripHTMLTags$1=HTMLUtilities.stripHTMLTagsFromString,find$6=Utilities.find,isNumber$l=Utilities.isNumber,pick$T=Utilities.pick,defined$n=Utilities.defined;function findFirstPointWithGraphic(o){var r=o.index;return!o.series||!o.series.data||!defined$n(r)?null:find$6(o.series.data,function(t){return!!(t&&typeof t.index<"u"&&t.index>r&&t.graphic&&t.graphic.element)})||null}function shouldAddDummyPoint(o){var r=o.series&&o.series.is("sunburst"),t=o.isNull;return t&&!r}function makeDummyElement(o,r){var t=o.series.chart.renderer,n=t.rect(r.x,r.y,1,1);return n.attr({class:"highcharts-a11y-dummy-point",fill:"none",opacity:0,"fill-opacity":0,"stroke-opacity":0}),n}function addDummyPointElement(o){var r=o.series,t=findFirstPointWithGraphic(o),n=t&&t.graphic,s=n?n.parentGroup:r.graph||r.group,a=t?{x:pick$T(o.plotX,t.plotX,0),y:pick$T(o.plotY,t.plotY,0)}:{x:pick$T(o.plotX,0),y:pick$T(o.plotY,0)},l=makeDummyElement(o,a);if(s&&s.element)return o.graphic=l,o.hasDummyGraphic=!0,l.add(s),s.element.insertBefore(l.element,n?n.element:null),l.element}function hasMorePointsThanDescriptionThreshold(o){var r=o.chart.options.accessibility,t=r.series.pointDescriptionEnabledThreshold;return!!(t!==!1&&o.points&&o.points.length>=t)}function shouldSetScreenReaderPropsOnPoints(o){var r=o.options.accessibility||{};return!hasMorePointsThanDescriptionThreshold(o)&&!r.exposeAsGroupOnly}function shouldSetKeyboardNavPropsOnPoints(o){var r=o.chart.options.accessibility,t=r.keyboardNavigation.seriesNavigation;return!!(o.points&&(o.points.length<t.pointNavigationEnabledThreshold||t.pointNavigationEnabledThreshold===!1))}function shouldDescribeSeriesElement(o){var r=o.chart,t=r.options.chart,n=t.options3d&&t.options3d.enabled,s=r.series.length>1,a=r.options.accessibility.series.describeSingleSeries,l=(o.options.accessibility||{}).exposeAsGroupOnly,h=n&&s;return!h&&(s||a||l||hasMorePointsThanDescriptionThreshold(o))}function pointNumberToString(o,r){var t=o.series.chart,n=t.options.accessibility.point||{},s=o.series.tooltipOptions||{},a=t.options.lang;return isNumber$l(r)?numberFormat(r,n.valueDecimals||s.valueDecimals||-1,a.decimalPoint,a.accessibility.thousandsSep||a.thousandsSep):r}function getSeriesDescriptionText(o){var r=o.options.accessibility||{},t=r.description;return t&&o.chart.langFormat("accessibility.series.description",{description:t,series:o})||""}function getSeriesAxisDescriptionText(o,r){var t=o[r];return o.chart.langFormat("accessibility.series."+r+"Description",{name:getAxisDescription$1(t),series:o})}function getPointA11yTimeDescription(o){var r=o.series,t=r.chart,n=t.options.accessibility.point||{},s=r.xAxis&&r.xAxis.dateTime;if(s){var a=s.getXDateFormat(o.x||0,t.options.tooltip.dateTimeLabelFormats),l=n.dateFormatter&&n.dateFormatter(o)||n.dateFormat||a;return t.time.dateFormat(l,o.x||0,void 0)}}function getPointXDescription(o){var r=getPointA11yTimeDescription(o),t=o.series.xAxis||{},n=t.categories&&defined$n(o.category)&&(""+o.category).replace("<br/>"," "),s=o.id&&o.id.indexOf("highcharts-")<0,a="x, "+o.x;return o.name||r||n||(s?o.id:a)}function getPointArrayMapValueDescription(o,r,t){var n=r||"",s=t||"",a=function(h){var d=pointNumberToString(o,pick$T(o[h],o.options[h]));return h+": "+n+d+s},l=o.series.pointArrayMap;return l.reduce(function(h,d){return h+(h.length?", ":"")+a(d)},"")}function getPointValue(o){var r=o.series,t=r.chart.options.accessibility.point||{},n=r.tooltipOptions||{},s=t.valuePrefix||n.valuePrefix||"",a=t.valueSuffix||n.valueSuffix||"",l=typeof o.value<"u"?"value":"y",h=pointNumberToString(o,o[l]);return o.isNull?r.chart.langFormat("accessibility.series.nullPointValue",{point:o}):r.pointArrayMap?getPointArrayMapValueDescription(o,s,a):s+h+a}function getPointAnnotationDescription(o){var r=o.series.chart,t="accessibility.series.pointAnnotationsDescription",n=getPointAnnotationTexts(o),s={point:o,annotations:n};return n.length?r.langFormat(t,s):""}function getPointValueDescription(o){var r=o.series,t=r.chart,n=t.options.accessibility.point.valueDescriptionFormat,s=pick$T(r.xAxis&&r.xAxis.options.accessibility&&r.xAxis.options.accessibility.enabled,!t.angular),a=s?getPointXDescription(o):"",l={point:o,index:defined$n(o.index)?o.index+1:"",xDescription:a,value:getPointValue(o),separator:s?", ":""};return format$5(n,l,t)}function defaultPointDescriptionFormatter$1(o){var r=o.series,t=r.chart,n=getPointValueDescription(o),s=o.options&&o.options.accessibility&&o.options.accessibility.description,a=s?" "+s:"",l=t.series.length>1&&r.name?" "+r.name+".":"",h=getPointAnnotationDescription(o),d=h?" "+h:"";return o.accessibility=o.accessibility||{},o.accessibility.valueDescription=n,n+a+l+d}function setPointScreenReaderAttribs(o,r){var t=o.series,n=t.chart.options.accessibility.point||{},s=t.options.accessibility||{},a=stripHTMLTags$1(s.pointDescriptionFormatter&&s.pointDescriptionFormatter(o)||n.descriptionFormatter&&n.descriptionFormatter(o)||defaultPointDescriptionFormatter$1(o));r.setAttribute("role","img"),r.setAttribute("aria-label",a)}function describePointsInSeries(o){var r=shouldSetScreenReaderPropsOnPoints(o),t=shouldSetKeyboardNavPropsOnPoints(o);(r||t)&&o.points.forEach(function(n){var s=n.graphic&&n.graphic.element||shouldAddDummyPoint(n)&&addDummyPointElement(n),a=n.options&&n.options.accessibility&&n.options.accessibility.enabled===!1;s&&(s.setAttribute("tabindex","-1"),s.style.outline="0",r&&!a?setPointScreenReaderAttribs(n,s):s.setAttribute("aria-hidden",!0))})}function defaultSeriesDescriptionFormatter$1(o){var r=o.chart,t=r.types||[],n=getSeriesDescriptionText(o),s=function(f){return r[f]&&r[f].length>1&&o[f]},a=getSeriesAxisDescriptionText(o,"xAxis"),l=getSeriesAxisDescriptionText(o,"yAxis"),h={name:o.name||"",ix:o.index+1,numSeries:r.series&&r.series.length,numPoints:o.points&&o.points.length,series:o},d=t.length>1?"Combination":"",c=r.langFormat("accessibility.series.summary."+o.type+d,h)||r.langFormat("accessibility.series.summary.default"+d,h);return c+(n?" "+n:"")+(s("yAxis")?" "+l:"")+(s("xAxis")?" "+a:"")}function describeSeriesElement(o,r){var t=o.options.accessibility||{},n=o.chart.options.accessibility,s=n.landmarkVerbosity;t.exposeAsGroupOnly?r.setAttribute("role","img"):s==="all"&&r.setAttribute("role","region"),r.setAttribute("tabindex","-1"),r.style.outline="0",r.setAttribute("aria-label",stripHTMLTags$1(n.series.descriptionFormatter&&n.series.descriptionFormatter(o)||defaultSeriesDescriptionFormatter$1(o)))}function describeSeries$1(o){var r=o.chart,t=getSeriesFirstPointElement(o),n=getSeriesA11yElement(o),s=r.is3d&&r.is3d();n&&(n.lastChild===t&&!s&&reverseChildNodes(n),describePointsInSeries(o),unhideChartElementFromAT$4(r,n),shouldDescribeSeriesElement(o)?describeSeriesElement(o,n):n.setAttribute("aria-label",""))}var SeriesDescriber={describeSeries:describeSeries$1,defaultPointDescriptionFormatter:defaultPointDescriptionFormatter$1,defaultSeriesDescriptionFormatter:defaultSeriesDescriptionFormatter$1,getPointA11yTimeDescription,getPointXDescription,getPointValue,getPointValueDescription},doc$9=H.doc,setElAttrs$3=HTMLUtilities.setElAttrs,visuallyHideElement$1=HTMLUtilities.visuallyHideElement,Announcer=function(){function o(r,t){this.chart=r,this.domElementProvider=new DOMElementProvider,this.announceRegion=this.addAnnounceRegion(t)}return o.prototype.destroy=function(){this.domElementProvider.destroyCreatedElements()},o.prototype.announce=function(r){var t=this;AST.setElementHTML(this.announceRegion,r),this.clearAnnouncementRegionTimer&&clearTimeout(this.clearAnnouncementRegionTimer),this.clearAnnouncementRegionTimer=setTimeout(function(){t.announceRegion.innerHTML="",delete t.clearAnnouncementRegionTimer},1e3)},o.prototype.addAnnounceRegion=function(r){var t=this.chart.announcerContainer||this.createAnnouncerContainer(),n=this.domElementProvider.createElement("div");return setElAttrs$3(n,{"aria-hidden":!1,"aria-live":r}),visuallyHideElement$1(n),t.appendChild(n),n},o.prototype.createAnnouncerContainer=function(){var r=this.chart,t=doc$9.createElement("div");return setElAttrs$3(t,{"aria-hidden":!1,style:"position:relative",class:"highcharts-announcer-container"}),r.renderTo.insertBefore(t,r.renderTo.firstChild),r.announcerContainer=t,t},o}(),extend$S=Utilities.extend,defined$m=Utilities.defined,getChartTitle$2=ChartUtilities.getChartTitle,defaultPointDescriptionFormatter=SeriesDescriber.defaultPointDescriptionFormatter,defaultSeriesDescriptionFormatter=SeriesDescriber.defaultSeriesDescriptionFormatter;function chartHasAnnounceEnabled(o){return!!o.options.accessibility.announceNewData.enabled}function findPointInDataArray(o){var r=o.series.data.filter(function(t){return o.x===t.x&&o.y===t.y});return r.length===1?r[0]:o}function getUniqueSeries(o,r){var t=(o||[]).concat(r||[]).reduce(function(n,s){return n[s.name+s.index]=s,n},{});return Object.keys(t).map(function(n){return t[n]})}var NewDataAnnouncer=function(o){this.chart=o};extend$S(NewDataAnnouncer.prototype,{init:function(){var o=this.chart,r=o.options.accessibility.announceNewData,t=r.interruptUser?"assertive":"polite";this.lastAnnouncementTime=0,this.dirty={allSeries:{}},this.eventProvider=new EventProvider,this.announcer=new Announcer(o,t),this.addEventListeners()},destroy:function(){this.eventProvider.removeAddedEvents(),this.announcer.destroy()},addEventListeners:function(){var o=this,r=this.chart,t=this.eventProvider;t.addEvent(r,"afterDrilldown",function(){o.lastAnnouncementTime=0}),t.addEvent(Series$e,"updatedData",function(){o.onSeriesUpdatedData(this)}),t.addEvent(r,"afterAddSeries",function(n){o.onSeriesAdded(n.series)}),t.addEvent(Series$e,"addPoint",function(n){o.onPointAdded(n.point)}),t.addEvent(r,"redraw",function(){o.announceDirtyData()})},onSeriesUpdatedData:function(o){var r=this.chart;o.chart===r&&chartHasAnnounceEnabled(r)&&(this.dirty.hasDirty=!0,this.dirty.allSeries[o.name+o.index]=o)},onSeriesAdded:function(o){chartHasAnnounceEnabled(this.chart)&&(this.dirty.hasDirty=!0,this.dirty.allSeries[o.name+o.index]=o,this.dirty.newSeries=defined$m(this.dirty.newSeries)?void 0:o)},onPointAdded:function(o){var r=o.series.chart;this.chart===r&&chartHasAnnounceEnabled(r)&&(this.dirty.newPoint=defined$m(this.dirty.newPoint)?void 0:o)},announceDirtyData:function(){var o=this.chart,r=this;if(o.options.accessibility.announceNewData&&this.dirty.hasDirty){var t=this.dirty.newPoint;t&&(t=findPointInDataArray(t)),this.queueAnnouncement(Object.keys(this.dirty.allSeries).map(function(n){return r.dirty.allSeries[n]}),this.dirty.newSeries,t),this.dirty={allSeries:{}}}},queueAnnouncement:function(o,r,t){var n=this,s=this.chart,a=s.options.accessibility.announceNewData;if(a.enabled){var l=+new Date,h=l-this.lastAnnouncementTime,d=Math.max(0,a.minAnnounceInterval-h),c=getUniqueSeries(this.queuedAnnouncement&&this.queuedAnnouncement.series,o),f=this.buildAnnouncementMessage(c,r,t);f&&(this.queuedAnnouncement&&clearTimeout(this.queuedAnnouncementTimer),this.queuedAnnouncement={time:l,message:f,series:c},this.queuedAnnouncementTimer=setTimeout(function(){n&&n.announcer&&(n.lastAnnouncementTime=+new Date,n.announcer.announce(n.queuedAnnouncement.message),delete n.queuedAnnouncement,delete n.queuedAnnouncementTimer)},d))}},buildAnnouncementMessage:function(o,r,t){var n=this.chart,s=n.options.accessibility.announceNewData;if(s.announcementFormatter){var a=s.announcementFormatter(o,r,t);if(a!==!1)return a.length?a:null}var l=H.charts&&H.charts.length>1?"Multiple":"Single",h=r?"newSeriesAnnounce"+l:t?"newPointAnnounce"+l:"newDataAnnounce",d=getChartTitle$2(n);return n.langFormat("accessibility.announceNewData."+h,{chartTitle:d,seriesDesc:r?defaultSeriesDescriptionFormatter(r):null,pointDesc:t?defaultPointDescriptionFormatter(t):null,point:t,series:r})}});var addEvent$z=Utilities.addEvent,merge$M=Utilities.merge;function isWithinDescriptionThreshold(o){var r=o.chart.options.accessibility;return o.points.length<r.series.pointDescriptionEnabledThreshold||r.series.pointDescriptionEnabledThreshold===!1}function shouldForceMarkers(o){var r=o.chart,t=r.options.accessibility.enabled,n=(o.options.accessibility&&o.options.accessibility.enabled)!==!1;return t&&n&&isWithinDescriptionThreshold(o)}function hasIndividualPointMarkerOptions(o){return!!(o._hasPointMarkers&&o.points&&o.points.length)}function unforceSeriesMarkerOptions(o){var r=o.resetA11yMarkerOptions;r&&merge$M(!0,o.options,{marker:{enabled:r.enabled,states:{normal:{opacity:r.states&&r.states.normal&&r.states.normal.opacity}}}})}function forceZeroOpacityMarkerOptions(o){merge$M(!0,o,{marker:{enabled:!0,states:{normal:{opacity:0}}}})}function getPointMarkerOpacity(o){return o.marker.states&&o.marker.states.normal&&o.marker.states.normal.opacity||1}function unforcePointMarkerOptions(o){merge$M(!0,o.marker,{states:{normal:{opacity:getPointMarkerOpacity(o)}}})}function handleForcePointMarkers(o){for(var r=o.points.length;r--;){var t=o.points[r],n=t.options;delete t.hasForcedA11yMarker,n.marker&&(n.marker.enabled?(unforcePointMarkerOptions(n),t.hasForcedA11yMarker=!1):(forceZeroOpacityMarkerOptions(n),t.hasForcedA11yMarker=!0))}}function addForceMarkersEvents(){addEvent$z(Series$e,"render",function(){var o=this,r=o.options;shouldForceMarkers(o)?(r.marker&&r.marker.enabled===!1&&(o.a11yMarkersForced=!0,forceZeroOpacityMarkerOptions(o.options)),hasIndividualPointMarkerOptions(o)&&handleForcePointMarkers(o)):o.a11yMarkersForced&&(delete o.a11yMarkersForced,unforceSeriesMarkerOptions(o))}),addEvent$z(Series$e,"afterSetOptions",function(o){this.resetA11yMarkerOptions=merge$M(o.options.marker||{},this.userOptions.marker||{})}),addEvent$z(Series$e,"afterRender",function(){var o=this;o.chart.styledMode&&(o.markerGroup&&o.markerGroup[o.a11yMarkersForced?"addClass":"removeClass"]("highcharts-a11y-markers-hidden"),hasIndividualPointMarkerOptions(o)&&o.points.forEach(function(r){r.graphic&&(r.graphic[r.hasForcedA11yMarker?"addClass":"removeClass"]("highcharts-a11y-marker-hidden"),r.graphic[r.hasForcedA11yMarker===!1?"addClass":"removeClass"]("highcharts-a11y-marker-visible"))}))})}var extend$R=Utilities.extend,hideSeriesFromAT=ChartUtilities.hideSeriesFromAT,describeSeries=SeriesDescriber.describeSeries;H.SeriesAccessibilityDescriber=SeriesDescriber;addForceMarkersEvents();var SeriesComponent=function(){};SeriesComponent.prototype=new AccessibilityComponent;extend$R(SeriesComponent.prototype,{init:function(){this.newDataAnnouncer=new NewDataAnnouncer(this.chart),this.newDataAnnouncer.init(),this.keyboardNavigation=new SeriesKeyboardNavigation(this.chart,this.keyCodes),this.keyboardNavigation.init(),this.hideTooltipFromATWhenShown(),this.hideSeriesLabelsFromATWhenShown()},hideTooltipFromATWhenShown:function(){var o=this;this.addEvent(Tooltip,"refresh",function(){this.chart===o.chart&&this.label&&this.label.element&&this.label.element.setAttribute("aria-hidden",!0)})},hideSeriesLabelsFromATWhenShown:function(){this.addEvent(this.chart,"afterDrawSeriesLabels",function(){this.series.forEach(function(o){o.labelBySeries&&o.labelBySeries.attr("aria-hidden",!0)})})},onChartRender:function(){var o=this.chart;o.series.forEach(function(r){var t=(r.options.accessibility&&r.options.accessibility.enabled)!==!1&&r.visible;t?describeSeries(r):hideSeriesFromAT(r)})},getKeyboardNavigation:function(){return this.keyboardNavigation.getKeyboardNavigationHandler()},destroy:function(){this.newDataAnnouncer.destroy(),this.keyboardNavigation.destroy()}});var unhideChartElementFromAT$3=ChartUtilities.unhideChartElementFromAT,noop$d=H.noop,removeElement=HTMLUtilities.removeElement,setElAttrs$2=HTMLUtilities.setElAttrs,extend$Q=Utilities.extend,pick$S=Utilities.pick;function chartHasMapZoom(o){return!!(o.mapZoom&&o.mapNavButtons&&o.mapNavButtons.length)}H.Axis.prototype.panStep=function(o,r){var t=r||3,n=this.getExtremes(),s=(n.max-n.min)/t*o,a=n.max+s,l=n.min+s,h=a-l;o<0&&l<n.dataMin?(l=n.dataMin,a=l+h):o>0&&a>n.dataMax&&(a=n.dataMax,l=a-h),this.setExtremes(l,a)};var ZoomComponent=noop$d;ZoomComponent.prototype=new AccessibilityComponent;extend$Q(ZoomComponent.prototype,{init:function(){var o=this,r=this.chart;["afterShowResetZoom","afterDrilldown","drillupall"].forEach(function(t){o.addEvent(r,t,function(){o.updateProxyOverlays()})})},onChartUpdate:function(){var o=this.chart,r=this;o.mapNavButtons&&o.mapNavButtons.forEach(function(t,n){unhideChartElementFromAT$3(o,t.element),r.setMapNavButtonAttrs(t.element,"accessibility.zoom.mapZoom"+(n?"Out":"In"))})},setMapNavButtonAttrs:function(o,r){var t=this.chart,n=t.langFormat(r,{chart:t});setElAttrs$2(o,{tabindex:-1,role:"button","aria-label":n})},onChartRender:function(){this.updateProxyOverlays()},updateProxyOverlays:function(){var o=this.chart;removeElement(this.drillUpProxyGroup),removeElement(this.resetZoomProxyGroup),o.resetZoomButton&&this.recreateProxyButtonAndGroup(o.resetZoomButton,"resetZoomProxyButton","resetZoomProxyGroup",o.langFormat("accessibility.zoom.resetZoomButton",{chart:o})),o.drillUpButton&&this.recreateProxyButtonAndGroup(o.drillUpButton,"drillUpProxyButton","drillUpProxyGroup",o.langFormat("accessibility.drillUpButton",{chart:o,buttonText:o.getDrilldownBackText()}))},recreateProxyButtonAndGroup:function(o,r,t,n){removeElement(this[t]),this[t]=this.addProxyGroup(),this[r]=this.createProxyButton(o,this[t],{"aria-label":n,tabindex:-1})},getMapZoomNavigation:function(){var o=this.keyCodes,r=this.chart,t=this;return new KeyboardNavigationHandler(r,{keyCodeMap:[[[o.up,o.down,o.left,o.right],function(n){return t.onMapKbdArrow(this,n)}],[[o.tab],function(n,s){return t.onMapKbdTab(this,s)}],[[o.space,o.enter],function(){return t.onMapKbdClick(this)}]],validate:function(){return chartHasMapZoom(r)},init:function(n){return t.onMapNavInit(n)}})},onMapKbdArrow:function(o,r){var t=this.keyCodes,n=r===t.up||r===t.down?"yAxis":"xAxis",s=r===t.left||r===t.up?-1:1;return this.chart[n][0].panStep(s),o.response.success},onMapKbdTab:function(o,r){var t,n=this.chart,s=o.response,a=r.shiftKey,l=a&&!this.focusedMapNavButtonIx||!a&&this.focusedMapNavButtonIx;return n.mapNavButtons[this.focusedMapNavButtonIx].setState(0),l?(n.mapZoom(),s[a?"prev":"next"]):(this.focusedMapNavButtonIx+=a?-1:1,t=n.mapNavButtons[this.focusedMapNavButtonIx],n.setFocusToElement(t.box,t.element),t.setState(2),s.success)},onMapKbdClick:function(o){return this.fakeClickEvent(this.chart.mapNavButtons[this.focusedMapNavButtonIx].element),o.response.success},onMapNavInit:function(o){var r=this.chart,t=r.mapNavButtons[0],n=r.mapNavButtons[1],s=o>0?t:n;r.setFocusToElement(s.box,s.element),s.setState(2),this.focusedMapNavButtonIx=o>0?0:1},simpleButtonNavigation:function(o,r,t){var n=this.keyCodes,s=this,a=this.chart;return new KeyboardNavigationHandler(a,{keyCodeMap:[[[n.tab,n.up,n.down,n.left,n.right],function(l,h){var d=l===n.tab&&h.shiftKey||l===n.left||l===n.up;return this.response[d?"prev":"next"]}],[[n.space,n.enter],function(){var l=t(this,a);return pick$S(l,this.response.success)}]],validate:function(){var l=a[o]&&a[o].box&&s[r];return l},init:function(){a.setFocusToElement(a[o].box,s[r])}})},getKeyboardNavigation:function(){return[this.simpleButtonNavigation("resetZoomButton","resetZoomProxyButton",function(o,r){r.zoomOut()}),this.simpleButtonNavigation("drillUpButton","drillUpProxyButton",function(o,r){return r.drillUp(),o.response.prev}),this.getMapZoomNavigation()]}});var unhideChartElementFromAT$2=ChartUtilities.unhideChartElementFromAT,getAxisRangeDescription$1=ChartUtilities.getAxisRangeDescription,setElAttrs$1=HTMLUtilities.setElAttrs,addEvent$y=Utilities.addEvent,extend$P=Utilities.extend;function shouldRunInputNavigation(o){return!!(o.rangeSelector&&o.rangeSelector.inputGroup&&o.rangeSelector.inputGroup.element.getAttribute("visibility")!=="hidden"&&o.options.rangeSelector.inputEnabled!==!1&&o.rangeSelector.minInput&&o.rangeSelector.maxInput)}Chart$1.prototype.highlightRangeSelectorButton=function(o){var r=this.rangeSelector&&this.rangeSelector.buttons||[],t=this.highlightedRangeSelectorItemIx,n=this.rangeSelector&&this.rangeSelector.selected;return typeof t<"u"&&r[t]&&t!==n&&r[t].setState(this.oldRangeSelectorItemState||0),this.highlightedRangeSelectorItemIx=o,r[o]?(this.setFocusToElement(r[o].box,r[o].element),o!==n&&(this.oldRangeSelectorItemState=r[o].state,r[o].setState(1)),!0):!1};addEvent$y(RangeSelector,"afterBtnClick",function(){if(this.chart.accessibility&&this.chart.accessibility.components.rangeSelector)return this.chart.accessibility.components.rangeSelector.onAfterBtnClick()});var RangeSelectorComponent=function(){};RangeSelectorComponent.prototype=new AccessibilityComponent;extend$P(RangeSelectorComponent.prototype,{init:function(){var o=this.chart;this.announcer=new Announcer(o,"polite")},onChartUpdate:function(){var o=this.chart,r=this,t=o.rangeSelector;t&&(this.updateSelectorVisibility(),this.setDropdownAttrs(),t.buttons&&t.buttons.length&&t.buttons.forEach(function(n){r.setRangeButtonAttrs(n)}),t.maxInput&&t.minInput&&["minInput","maxInput"].forEach(function(n,s){var a=t[n];a&&(unhideChartElementFromAT$2(o,a),r.setRangeInputAttrs(a,"accessibility.rangeSelector."+(s?"max":"min")+"InputLabel"))}))},updateSelectorVisibility:function(){var o=this.chart,r=o.rangeSelector,t=r&&r.dropdown,n=r&&r.buttons||[],s=function(a){return a.setAttribute("aria-hidden",!0)};r&&r.hasVisibleDropdown&&t?(unhideChartElementFromAT$2(o,t),n.forEach(function(a){return s(a.element)})):(t&&s(t),n.forEach(function(a){return unhideChartElementFromAT$2(o,a.element)}))},setDropdownAttrs:function(){var o=this.chart,r=o.rangeSelector&&o.rangeSelector.dropdown;if(r){var t=o.langFormat("accessibility.rangeSelector.dropdownLabel",{rangeTitle:o.options.lang.rangeSelectorZoom});r.setAttribute("aria-label",t),r.setAttribute("tabindex",-1)}},setRangeButtonAttrs:function(o){setElAttrs$1(o.element,{tabindex:-1,role:"button"})},setRangeInputAttrs:function(o,r){var t=this.chart;setElAttrs$1(o,{tabindex:-1,"aria-label":t.langFormat(r,{chart:t})})},onButtonNavKbdArrowKey:function(o,r){var t=o.response,n=this.keyCodes,s=this.chart,a=s.options.accessibility.keyboardNavigation.wrapAround,l=r===n.left||r===n.up?-1:1,h=s.highlightRangeSelectorButton(s.highlightedRangeSelectorItemIx+l);return h?t.success:a?(o.init(l),t.success):t[l>0?"next":"prev"]},onButtonNavKbdClick:function(o){var r=o.response,t=this.chart,n=t.oldRangeSelectorItemState===3;return n||this.fakeClickEvent(t.rangeSelector.buttons[t.highlightedRangeSelectorItemIx].element),r.success},onAfterBtnClick:function(){var o=this.chart,r=getAxisRangeDescription$1(o.xAxis[0]),t=o.langFormat("accessibility.rangeSelector.clickButtonAnnouncement",{chart:o,axisRangeDescription:r});t&&this.announcer.announce(t)},onInputKbdMove:function(o){var r=this.chart,t=r.rangeSelector,n=r.highlightedInputRangeIx=(r.highlightedInputRangeIx||0)+o,s=n>1||n<0;if(s)r.accessibility&&(r.accessibility.keyboardNavigation.tabindexContainer.focus(),r.accessibility.keyboardNavigation[o<0?"prev":"next"]());else if(t){var a=t[n?"maxDateBox":"minDateBox"],l=t[n?"maxInput":"minInput"];a&&l&&r.setFocusToElement(a,l)}},onInputNavInit:function(o){var r=this,t=this,n=this.chart,s=o>0?0:1,a=n.rangeSelector,l=a&&a[s?"maxDateBox":"minDateBox"],h=a&&a.minInput,d=a&&a.maxInput,c=s?d:h;if(n.highlightedInputRangeIx=s,l&&h&&d){n.setFocusToElement(l,c),this.removeInputKeydownHandler&&this.removeInputKeydownHandler();var f=function(g){var m=(g.which||g.keyCode)===r.keyCodes.tab;m&&(g.preventDefault(),g.stopPropagation(),t.onInputKbdMove(g.shiftKey?-1:1))},u=addEvent$y(h,"keydown",f),p=addEvent$y(d,"keydown",f);this.removeInputKeydownHandler=function(){u(),p()}}},onInputNavTerminate:function(){var o=this.chart.rangeSelector||{};o.maxInput&&o.hideInput("max"),o.minInput&&o.hideInput("min"),this.removeInputKeydownHandler&&(this.removeInputKeydownHandler(),delete this.removeInputKeydownHandler)},initDropdownNav:function(){var o=this,r=this.chart,t=r.rangeSelector,n=t&&t.dropdown;t&&n&&(r.setFocusToElement(t.buttonGroup,n),this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeDropdownKeydownHandler=addEvent$y(n,"keydown",function(s){var a=(s.which||s.keyCode)===o.keyCodes.tab;a&&(s.preventDefault(),s.stopPropagation(),r.accessibility&&(r.accessibility.keyboardNavigation.tabindexContainer.focus(),r.accessibility.keyboardNavigation[s.shiftKey?"prev":"next"]()))}))},getRangeSelectorButtonNavigation:function(){var o=this.chart,r=this.keyCodes,t=this;return new KeyboardNavigationHandler(o,{keyCodeMap:[[[r.left,r.right,r.up,r.down],function(n){return t.onButtonNavKbdArrowKey(this,n)}],[[r.enter,r.space],function(){return t.onButtonNavKbdClick(this)}]],validate:function(){return!!(o.rangeSelector&&o.rangeSelector.buttons&&o.rangeSelector.buttons.length)},init:function(n){var s=o.rangeSelector;if(s&&s.hasVisibleDropdown)t.initDropdownNav();else if(s){var a=s.buttons.length-1;o.highlightRangeSelectorButton(n>0?0:a)}},terminate:function(){t.removeDropdownKeydownHandler&&(t.removeDropdownKeydownHandler(),delete t.removeDropdownKeydownHandler)}})},getRangeSelectorInputNavigation:function(){var o=this.chart,r=this;return new KeyboardNavigationHandler(o,{keyCodeMap:[],validate:function(){return shouldRunInputNavigation(o)},init:function(t){r.onInputNavInit(t)},terminate:function(){r.onInputNavTerminate()}})},getKeyboardNavigation:function(){return[this.getRangeSelectorButtonNavigation(),this.getRangeSelectorInputNavigation()]},destroy:function(){this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeInputKeydownHandler&&this.removeInputKeydownHandler(),this.announcer&&this.announcer.destroy()}});var format$4=FormatUtilities.format,doc$8=H.doc,extend$O=Utilities.extend,pick$R=Utilities.pick,getAnnotationsInfoHTML=AnnotationsA11y.getAnnotationsInfoHTML,getAxisDescription=ChartUtilities.getAxisDescription,getAxisRangeDescription=ChartUtilities.getAxisRangeDescription,getChartTitle$1=ChartUtilities.getChartTitle,unhideChartElementFromAT$1=ChartUtilities.unhideChartElementFromAT,addClass=HTMLUtilities.addClass,getElement=HTMLUtilities.getElement,getHeadingTagNameForElement=HTMLUtilities.getHeadingTagNameForElement,setElAttrs=HTMLUtilities.setElAttrs,stripHTMLTagsFromString=HTMLUtilities.stripHTMLTagsFromString,visuallyHideElement=HTMLUtilities.visuallyHideElement;function stripEmptyHTMLTags(o){return o.replace(/<(\w+)[^>]*?>\s*<\/\1>/g,"")}function getTypeDescForMapChart(o,r){return r.mapTitle?o.langFormat("accessibility.chartTypes.mapTypeDescription",r):o.langFormat("accessibility.chartTypes.unknownMap",r)}function getTypeDescForCombinationChart(o,r){return o.langFormat("accessibility.chartTypes.combinationChart",r)}function getTypeDescForEmptyChart(o,r){return o.langFormat("accessibility.chartTypes.emptyChart",r)}function buildTypeDescriptionFromSeries(o,r,t){var n=r[0],s=o.langFormat("accessibility.seriesTypeDescriptions."+n,t),a=o.series&&o.series.length<2?"Single":"Multiple";return(o.langFormat("accessibility.chartTypes."+n+a,t)||o.langFormat("accessibility.chartTypes.default"+a,t))+(s?" "+s:"")}function getTableSummary(o){return o.langFormat("accessibility.table.tableSummary",{chart:o})}Chart$1.prototype.getTypeDescription=function(o){var r=o[0],t=this.series&&this.series[0]||{},n={numSeries:this.series.length,numPoints:t.points&&t.points.length,chart:this,mapTitle:t.mapTitle};return r?r==="map"?getTypeDescForMapChart(this,n):this.types.length>1?getTypeDescForCombinationChart(this,n):buildTypeDescriptionFromSeries(this,o,n):getTypeDescForEmptyChart(this,n)};var InfoRegionsComponent=function(){};InfoRegionsComponent.prototype=new AccessibilityComponent;extend$O(InfoRegionsComponent.prototype,{init:function(){var o=this.chart,r=this;this.initRegionsDefinitions(),this.addEvent(o,"aftergetTableAST",function(t){r.onDataTableCreated(t)}),this.addEvent(o,"afterViewData",function(t){r.dataTableDiv=t,setTimeout(function(){r.focusDataTable()},300)}),this.announcer=new Announcer(o,"assertive")},initRegionsDefinitions:function(){var o=this;this.screenReaderSections={before:{element:null,buildContent:function(r){var t=r.options.accessibility.screenReaderSection.beforeChartFormatter;return t?t(r):o.defaultBeforeChartFormatter(r)},insertIntoDOM:function(r,t){t.renderTo.insertBefore(r,t.renderTo.firstChild)},afterInserted:function(){typeof o.sonifyButtonId<"u"&&o.initSonifyButton(o.sonifyButtonId),typeof o.dataTableButtonId<"u"&&o.initDataTableButton(o.dataTableButtonId)}},after:{element:null,buildContent:function(r){var t=r.options.accessibility.screenReaderSection.afterChartFormatter;return t?t(r):o.defaultAfterChartFormatter()},insertIntoDOM:function(r,t){t.renderTo.insertBefore(r,t.container.nextSibling)},afterInserted:function(){o.chart.accessibility&&o.chart.accessibility.keyboardNavigation.updateExitAnchor()}}}},onChartRender:function(){var o=this;this.linkedDescriptionElement=this.getLinkedDescriptionElement(),this.setLinkedDescriptionAttrs(),Object.keys(this.screenReaderSections).forEach(function(r){o.updateScreenReaderSection(r)})},getLinkedDescriptionElement:function(){var o=this.chart.options,r=o.accessibility.linkedDescription;if(r){if(typeof r!="string")return r;var t=format$4(r,this.chart),n=doc$8.querySelectorAll(t);if(n.length===1)return n[0]}},setLinkedDescriptionAttrs:function(){var o=this.linkedDescriptionElement;o&&(o.setAttribute("aria-hidden","true"),addClass(o,"highcharts-linked-description"))},updateScreenReaderSection:function(o){var r=this.chart,t=this.screenReaderSections[o],n=t.buildContent(r),s=t.element=t.element||this.createElement("div"),a=s.firstChild||this.createElement("div");this.setScreenReaderSectionAttribs(s,o),AST.setElementHTML(a,n),s.appendChild(a),t.insertIntoDOM(s,r),visuallyHideElement(a),unhideChartElementFromAT$1(r,a),t.afterInserted&&t.afterInserted()},setScreenReaderSectionAttribs:function(o,r){var t="accessibility.screenReaderSection."+r+"RegionLabel",n=this.chart,s=n.langFormat(t,{chart:n,chartTitle:getChartTitle$1(n)}),a="highcharts-screen-reader-region-"+r+"-"+n.index;setElAttrs(o,{id:a,"aria-label":s}),o.style.position="relative",n.options.accessibility.landmarkVerbosity==="all"&&s&&o.setAttribute("role","region")},defaultBeforeChartFormatter:function(){var o=this.chart,r=o.options.accessibility.screenReaderSection.beforeChartFormat,t=this.getAxesDescription(),n=o.sonify&&o.options.sonification&&o.options.sonification.enabled,s="highcharts-a11y-sonify-data-btn-"+o.index,a="hc-linkto-highcharts-data-table-"+o.index,l=getAnnotationsInfoHTML(o),h=o.langFormat("accessibility.screenReaderSection.annotations.heading",{chart:o}),d={headingTagName:getHeadingTagNameForElement(o.renderTo),chartTitle:getChartTitle$1(o),typeDescription:this.getTypeDescriptionText(),chartSubtitle:this.getSubtitleText(),chartLongdesc:this.getLongdescText(),xAxisDescription:t.xAxis,yAxisDescription:t.yAxis,playAsSoundButton:n?this.getSonifyButtonText(s):"",viewTableButton:o.getCSV?this.getDataTableButtonText(a):"",annotationsTitle:l?h:"",annotationsList:l},c=H.i18nFormat(r,d,o);return this.dataTableButtonId=a,this.sonifyButtonId=s,stripEmptyHTMLTags(c)},defaultAfterChartFormatter:function(){var o=this.chart,r=o.options.accessibility.screenReaderSection.afterChartFormat,t={endOfChartMarker:this.getEndOfChartMarkerText()},n=H.i18nFormat(r,t,o);return stripEmptyHTMLTags(n)},getLinkedDescription:function(){var o=this.linkedDescriptionElement,r=o&&o.innerHTML||"";return stripHTMLTagsFromString(r)},getLongdescText:function(){var o=this.chart.options,r=o.caption,t=r&&r.text,n=this.getLinkedDescription();return o.accessibility.description||n||t||""},getTypeDescriptionText:function(){var o=this.chart;return o.types?o.options.accessibility.typeDescription||o.getTypeDescription(o.types):""},getDataTableButtonText:function(o){var r=this.chart,t=r.langFormat("accessibility.table.viewAsDataTableButtonText",{chart:r,chartTitle:getChartTitle$1(r)});return'<button id="'+o+'">'+t+"</button>"},getSonifyButtonText:function(o){var r=this.chart;if(r.options.sonification&&r.options.sonification.enabled===!1)return"";var t=r.langFormat("accessibility.sonification.playAsSoundButtonText",{chart:r,chartTitle:getChartTitle$1(r)});return'<button id="'+o+'">'+t+"</button>"},getSubtitleText:function(){var o=this.chart.options.subtitle;return stripHTMLTagsFromString(o&&o.text||"")},getEndOfChartMarkerText:function(){var o=this.chart,r=o.langFormat("accessibility.screenReaderSection.endOfChartMarker",{chart:o}),t="highcharts-end-of-chart-marker-"+o.index;return'<div id="'+t+'">'+r+"</div>"},onDataTableCreated:function(o){var r=this.chart;if(r.options.accessibility.enabled){this.viewDataTableButton&&this.viewDataTableButton.setAttribute("aria-expanded","true");var t=o.tree.attributes||{};t.tabindex=-1,t.summary=getTableSummary(r),o.tree.attributes=t}},focusDataTable:function(){var o=this.dataTableDiv,r=o&&o.getElementsByTagName("table")[0];r&&r.focus&&r.focus()},initSonifyButton:function(o){var r=this,t=this.sonifyButton=getElement(o),n=this.chart,s=function(a){t&&(t.setAttribute("aria-hidden","true"),t.setAttribute("aria-label","")),a.preventDefault(),a.stopPropagation();var l=n.langFormat("accessibility.sonification.playAsSoundClickAnnouncement",{chart:n});r.announcer.announce(l),setTimeout(function(){t&&(t.removeAttribute("aria-hidden"),t.removeAttribute("aria-label")),n.sonify&&n.sonify()},1e3)};t&&n&&(setElAttrs(t,{tabindex:-1}),t.onclick=function(a){var l=n.options.accessibility&&n.options.accessibility.screenReaderSection.onPlayAsSoundClick;(l||s).call(this,a,n)})},initDataTableButton:function(o){var r=this.viewDataTableButton=getElement(o),t=this.chart,n=o.replace("hc-linkto-","");r&&(setElAttrs(r,{tabindex:-1,"aria-expanded":!!getElement(n)}),r.onclick=t.options.accessibility.screenReaderSection.onViewDataTableClick||function(){t.viewData()})},getAxesDescription:function(){var o=this.chart,r=function(h,d){var c=o[h];return c.length>1||c[0]&&pick$R(c[0].options.accessibility&&c[0].options.accessibility.enabled,d)},t=!!o.types&&o.types.indexOf("map")<0,n=!!o.hasCartesianSeries,s=r("xAxis",!o.angular&&n&&t),a=r("yAxis",n&&t),l={};return s&&(l.xAxis=this.getAxisDescriptionText("xAxis")),a&&(l.yAxis=this.getAxisDescriptionText("yAxis")),l},getAxisDescriptionText:function(o){var r=this.chart,t=r[o];return r.langFormat("accessibility.axis."+o+"Description"+(t.length>1?"Plural":"Singular"),{chart:r,names:t.map(function(n){return getAxisDescription(n)}),ranges:t.map(function(n){return getAxisRangeDescription(n)}),numAxes:t.length})},destroy:function(){this.announcer&&this.announcer.destroy()}});var unhideChartElementFromAT=ChartUtilities.unhideChartElementFromAT,getChartTitle=ChartUtilities.getChartTitle,doc$7=H.doc,stripHTMLTags=HTMLUtilities.stripHTMLTagsFromString,extend$N=Utilities.extend,ContainerComponent=function(){};ContainerComponent.prototype=new AccessibilityComponent;extend$N(ContainerComponent.prototype,{onChartUpdate:function(){this.handleSVGTitleElement(),this.setSVGContainerLabel(),this.setGraphicContainerAttrs(),this.setRenderToAttrs(),this.makeCreditsAccessible()},handleSVGTitleElement:function(){var o=this.chart,r="highcharts-title-"+o.index,t=stripHTMLTags(o.langFormat("accessibility.svgContainerTitle",{chartTitle:getChartTitle(o)}));if(t.length){var n=this.svgTitleElement=this.svgTitleElement||doc$7.createElementNS("http://www.w3.org/2000/svg","title");n.textContent=t,n.id=r,o.renderTo.insertBefore(n,o.renderTo.firstChild)}},setSVGContainerLabel:function(){var o=this.chart,r=o.langFormat("accessibility.svgContainerLabel",{chartTitle:getChartTitle(o)});o.renderer.box&&r.length&&o.renderer.box.setAttribute("aria-label",r)},setGraphicContainerAttrs:function(){var o=this.chart,r=o.langFormat("accessibility.graphicContainerLabel",{chartTitle:getChartTitle(o)});r.length&&o.container.setAttribute("aria-label",r)},setRenderToAttrs:function(){var o=this.chart;o.options.accessibility.landmarkVerbosity!=="disabled"?o.renderTo.setAttribute("role","region"):o.renderTo.removeAttribute("role"),o.renderTo.setAttribute("aria-label",o.langFormat("accessibility.chartContainerLabel",{title:getChartTitle(o),chart:o}))},makeCreditsAccessible:function(){var o=this.chart,r=o.credits;r&&(r.textStr&&r.element.setAttribute("aria-label",o.langFormat("accessibility.credits",{creditsStr:stripHTMLTags(r.textStr)})),unhideChartElementFromAT(o,r.element))},getKeyboardNavigation:function(){var o=this.chart;return new KeyboardNavigationHandler(o,{keyCodeMap:[],validate:function(){return!0},init:function(){var r=o.accessibility;r&&r.keyboardNavigation.tabindexContainer.focus()}})},destroy:function(){this.chart.renderTo.setAttribute("aria-hidden",!0)}});var doc$6=H.doc,isMS=H.isMS,win$3=H.win,whcm={isHighContrastModeActive:function(){var o=/(Edg)/.test(win$3.navigator.userAgent);if(win$3.matchMedia&&o)return win$3.matchMedia("(-ms-high-contrast: active)").matches;if(isMS&&win$3.getComputedStyle){var r=doc$6.createElement("div"),t="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==";r.style.backgroundImage="url("+t+")",doc$6.body.appendChild(r);var n=(r.currentStyle||win$3.getComputedStyle(r)).backgroundImage;return doc$6.body.removeChild(r),n==="none"}return!1},setHighContrastTheme:function(o){o.highContrastModeActive=!0;var r=o.options.accessibility.highContrastTheme;o.update(r,!1),o.series.forEach(function(t){var n=r.plotOptions[t.type]||{};t.update({color:n.color||"windowText",colors:[n.color||"windowText"],borderColor:n.borderColor||"window"}),t.points.forEach(function(s){s.options&&s.options.color&&s.update({color:n.color||"windowText",borderColor:n.borderColor||"window"},!1)})}),o.redraw()}},theme={chart:{backgroundColor:"window"},title:{style:{color:"windowText"}},subtitle:{style:{color:"windowText"}},colorAxis:{minColor:"windowText",maxColor:"windowText",stops:[]},colors:["windowText"],xAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},yAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},tooltip:{backgroundColor:"window",borderColor:"windowText",style:{color:"windowText"}},plotOptions:{series:{lineColor:"windowText",fillColor:"window",borderColor:"windowText",edgeColor:"windowText",borderWidth:1,dataLabels:{connectorColor:"windowText",color:"windowText",style:{color:"windowText",textOutline:"none"}},marker:{lineColor:"windowText",fillColor:"windowText"}},pie:{color:"window",colors:["window"],borderColor:"windowText",borderWidth:1},boxplot:{fillColor:"window"},candlestick:{lineColor:"windowText",fillColor:"window"},errorbar:{fillColor:"window"}},legend:{backgroundColor:"window",itemStyle:{color:"windowText"},itemHoverStyle:{color:"windowText"},itemHiddenStyle:{color:"#555"},title:{style:{color:"windowText"}}},credits:{style:{color:"windowText"}},labels:{style:{color:"windowText"}},drilldown:{activeAxisLabelStyle:{color:"windowText"},activeDataLabelStyle:{color:"windowText"}},navigation:{buttonOptions:{symbolStroke:"windowText",theme:{fill:"window"}}},rangeSelector:{buttonTheme:{fill:"window",stroke:"windowText",style:{color:"windowText"},states:{hover:{fill:"window",stroke:"windowText",style:{color:"windowText"}},select:{fill:"#444",stroke:"windowText",style:{color:"windowText"}}}},inputBoxBorderColor:"windowText",inputStyle:{backgroundColor:"window",color:"windowText"},labelStyle:{color:"windowText"}},navigator:{handles:{backgroundColor:"window",borderColor:"windowText"},outlineColor:"windowText",maskFill:"transparent",series:{color:"windowText",lineColor:"windowText"},xAxis:{gridLineColor:"windowText"}},scrollbar:{barBackgroundColor:"#444",barBorderColor:"windowText",buttonArrowColor:"windowText",buttonBackgroundColor:"window",buttonBorderColor:"windowText",rifleColor:"windowText",trackBackgroundColor:"window",trackBorderColor:"windowText"}},Options={accessibility:{enabled:!0,screenReaderSection:{beforeChartFormat:"<{headingTagName}>{chartTitle}</{headingTagName}><div>{typeDescription}</div><div>{chartSubtitle}</div><div>{chartLongdesc}</div><div>{playAsSoundButton}</div><div>{viewTableButton}</div><div>{xAxisDescription}</div><div>{yAxisDescription}</div><div>{annotationsTitle}{annotationsList}</div>",afterChartFormat:"{endOfChartMarker}",axisRangeDateFormat:"%Y-%m-%d %H:%M:%S"},series:{describeSingleSeries:!1,pointDescriptionEnabledThreshold:200},point:{valueDescriptionFormat:"{index}. {xDescription}{separator}{value}."},landmarkVerbosity:"all",linkedDescription:'*[data-highcharts-chart="{index}"] + .highcharts-description',keyboardNavigation:{enabled:!0,focusBorder:{enabled:!0,hideBrowserFocusOutline:!0,style:{color:palette.highlightColor80,lineWidth:2,borderRadius:3},margin:2},order:["series","zoom","rangeSelector","legend","chartMenu"],wrapAround:!0,seriesNavigation:{skipNullPoints:!0,pointNavigationEnabledThreshold:!1}},announceNewData:{enabled:!1,minAnnounceInterval:5e3,interruptUser:!1}},legend:{accessibility:{enabled:!0,keyboardNavigation:{enabled:!0}}},exporting:{accessibility:{enabled:!0}}},langOptions={accessibility:{defaultChartTitle:"Chart",chartContainerLabel:"{title}. Highcharts interactive chart.",svgContainerLabel:"Interactive chart",drillUpButton:"{buttonText}",credits:"Chart credits: {creditsStr}",thousandsSep:",",svgContainerTitle:"",graphicContainerLabel:"",screenReaderSection:{beforeRegionLabel:"Chart screen reader information, {chartTitle}.",afterRegionLabel:"",annotations:{heading:"Chart annotations summary",descriptionSinglePoint:"{annotationText}. Related to {annotationPoint}",descriptionMultiplePoints:"{annotationText}. Related to {annotationPoint}{ Also related to, #each(additionalAnnotationPoints)}",descriptionNoPoints:"{annotationText}"},endOfChartMarker:"End of interactive chart."},sonification:{playAsSoundButtonText:"Play as sound, {chartTitle}",playAsSoundClickAnnouncement:"Play"},legend:{legendLabelNoTitle:"Toggle series visibility, {chartTitle}",legendLabel:"Chart legend: {legendTitle}",legendItem:"Show {itemName}"},zoom:{mapZoomIn:"Zoom chart",mapZoomOut:"Zoom out chart",resetZoomButton:"Reset zoom"},rangeSelector:{dropdownLabel:"{rangeTitle}",minInputLabel:"Select start date.",maxInputLabel:"Select end date.",clickButtonAnnouncement:"Viewing {axisRangeDescription}"},table:{viewAsDataTableButtonText:"View as data table, {chartTitle}",tableSummary:"Table representation of chart."},announceNewData:{newDataAnnounce:"Updated data for chart {chartTitle}",newSeriesAnnounceSingle:"New data series: {seriesDesc}",newPointAnnounceSingle:"New data point: {pointDesc}",newSeriesAnnounceMultiple:"New data series in chart {chartTitle}: {seriesDesc}",newPointAnnounceMultiple:"New data point in chart {chartTitle}: {pointDesc}"},seriesTypeDescriptions:{boxplot:"Box plot charts are typically used to display groups of statistical data. Each data point in the chart can have up to 5 values: minimum, lower quartile, median, upper quartile, and maximum.",arearange:"Arearange charts are line charts displaying a range between a lower and higher value for each point.",areasplinerange:"These charts are line charts displaying a range between a lower and higher value for each point.",bubble:"Bubble charts are scatter charts where each data point also has a size value.",columnrange:"Columnrange charts are column charts displaying a range between a lower and higher value for each point.",errorbar:"Errorbar series are used to display the variability of the data.",funnel:"Funnel charts are used to display reduction of data in stages.",pyramid:"Pyramid charts consist of a single pyramid with item heights corresponding to each point value.",waterfall:"A waterfall chart is a column chart where each column contributes towards a total end value."},chartTypes:{emptyChart:"Empty chart",mapTypeDescription:"Map of {mapTitle} with {numSeries} data series.",unknownMap:"Map of unspecified region with {numSeries} data series.",combinationChart:"Combination chart with {numSeries} data series.",defaultSingle:"Chart with {numPoints} data {#plural(numPoints, points, point)}.",defaultMultiple:"Chart with {numSeries} data series.",splineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",splineMultiple:"Line chart with {numSeries} lines.",lineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",lineMultiple:"Line chart with {numSeries} lines.",columnSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",columnMultiple:"Bar chart with {numSeries} data series.",barSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",barMultiple:"Bar chart with {numSeries} data series.",pieSingle:"Pie chart with {numPoints} {#plural(numPoints, slices, slice)}.",pieMultiple:"Pie chart with {numSeries} pies.",scatterSingle:"Scatter chart with {numPoints} {#plural(numPoints, points, point)}.",scatterMultiple:"Scatter chart with {numSeries} data series.",boxplotSingle:"Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotMultiple:"Boxplot with {numSeries} data series.",bubbleSingle:"Bubble chart with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleMultiple:"Bubble chart with {numSeries} data series."},axis:{xAxisDescriptionSingular:"The chart has 1 X axis displaying {names[0]}. {ranges[0]}",xAxisDescriptionPlural:"The chart has {numAxes} X axes displaying {#each(names, -1) }and {names[-1]}.",yAxisDescriptionSingular:"The chart has 1 Y axis displaying {names[0]}. {ranges[0]}",yAxisDescriptionPlural:"The chart has {numAxes} Y axes displaying {#each(names, -1) }and {names[-1]}.",timeRangeDays:"Range: {range} days.",timeRangeHours:"Range: {range} hours.",timeRangeMinutes:"Range: {range} minutes.",timeRangeSeconds:"Range: {range} seconds.",rangeFromTo:"Range: {rangeFrom} to {rangeTo}.",rangeCategories:"Range: {numCategories} categories."},exporting:{chartMenuLabel:"Chart menu",menuButtonLabel:"View chart menu",exportRegionLabel:"Chart menu, {chartTitle}"},series:{summary:{default:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",defaultCombination:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",line:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",lineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",spline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",splineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",column:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",columnCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",bar:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",barCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",pie:"{name}, pie {ix} of {numSeries} with {numPoints} {#plural(numPoints, slices, slice)}.",pieCombination:"{name}, series {ix} of {numSeries}. Pie with {numPoints} {#plural(numPoints, slices, slice)}.",scatter:"{name}, scatter plot {ix} of {numSeries} with {numPoints} {#plural(numPoints, points, point)}.",scatterCombination:"{name}, series {ix} of {numSeries}, scatter plot with {numPoints} {#plural(numPoints, points, point)}.",boxplot:"{name}, boxplot {ix} of {numSeries} with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotCombination:"{name}, series {ix} of {numSeries}. Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",bubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}.",map:"{name}, map {ix} of {numSeries} with {numPoints} {#plural(numPoints, areas, area)}.",mapCombination:"{name}, series {ix} of {numSeries}. Map with {numPoints} {#plural(numPoints, areas, area)}.",mapline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",maplineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",mapbubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",mapbubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}."},description:"{description}",xAxisDescription:"X axis, {name}",yAxisDescription:"Y axis, {name}",nullPointValue:"No value",pointAnnotationsDescription:"{Annotation: #each(annotations). }"}}},error$1=Utilities.error,pick$Q=Utilities.pick;function traverseSetOption(o,r,t){for(var n=o,s,a=0;a<r.length-1;++a)s=r[a],n=n[s]=pick$Q(n[s],{});n[r[r.length-1]]=t}function deprecateFromOptionsMap(o,r,t,n){function s(h,d){return d.reduce(function(c,f){return c[f]},h)}var a=s(o.options,r),l=s(o.options,t);Object.keys(n).forEach(function(h){var d,c=a[h];typeof c<"u"&&(traverseSetOption(l,n[h],c),error$1(32,!1,o,(d={},d[r.join(".")+"."+h]=t.join(".")+"."+n[h].join("."),d)))})}function copyDeprecatedChartOptions(o){var r=o.options.chart,t=o.options.accessibility||{};["description","typeDescription"].forEach(function(n){var s;r[n]&&(t[n]=r[n],error$1(32,!1,o,(s={},s["chart."+n]="use accessibility."+n,s)))})}function copyDeprecatedAxisOptions(o){o.axes.forEach(function(r){var t=r.options;t&&t.description&&(t.accessibility=t.accessibility||{},t.accessibility.description=t.description,error$1(32,!1,o,{"axis.description":"use axis.accessibility.description"}))})}function copyDeprecatedSeriesOptions(o){var r={description:["accessibility","description"],exposeElementToA11y:["accessibility","exposeAsGroupOnly"],pointDescriptionFormatter:["accessibility","pointDescriptionFormatter"],skipKeyboardNavigation:["accessibility","keyboardNavigation","enabled"]};o.series.forEach(function(t){Object.keys(r).forEach(function(n){var s,a=t.options[n];typeof a<"u"&&(traverseSetOption(t.options,r[n],n==="skipKeyboardNavigation"?!a:a),error$1(32,!1,o,(s={},s["series."+n]="series."+r[n].join("."),s)))})})}function copyDeprecatedTopLevelAccessibilityOptions(o){deprecateFromOptionsMap(o,["accessibility"],["accessibility"],{pointDateFormat:["point","dateFormat"],pointDateFormatter:["point","dateFormatter"],pointDescriptionFormatter:["point","descriptionFormatter"],pointDescriptionThreshold:["series","pointDescriptionEnabledThreshold"],pointNavigationThreshold:["keyboardNavigation","seriesNavigation","pointNavigationEnabledThreshold"],pointValueDecimals:["point","valueDecimals"],pointValuePrefix:["point","valuePrefix"],pointValueSuffix:["point","valueSuffix"],screenReaderSectionFormatter:["screenReaderSection","beforeChartFormatter"],describeSingleSeries:["series","describeSingleSeries"],seriesDescriptionFormatter:["series","descriptionFormatter"],onTableAnchorClick:["screenReaderSection","onViewDataTableClick"],axisRangeDateFormat:["screenReaderSection","axisRangeDateFormat"]})}function copyDeprecatedKeyboardNavigationOptions(o){deprecateFromOptionsMap(o,["accessibility","keyboardNavigation"],["accessibility","keyboardNavigation","seriesNavigation"],{skipNullPoints:["skipNullPoints"],mode:["mode"]})}function copyDeprecatedLangOptions(o){deprecateFromOptionsMap(o,["lang","accessibility"],["lang","accessibility"],{legendItem:["legend","legendItem"],legendLabel:["legend","legendLabel"],mapZoomIn:["zoom","mapZoomIn"],mapZoomOut:["zoom","mapZoomOut"],resetZoomButton:["zoom","resetZoomButton"],screenReaderRegionLabel:["screenReaderSection","beforeRegionLabel"],rangeSelectorButton:["rangeSelector","buttonText"],rangeSelectorMaxInput:["rangeSelector","maxInputLabel"],rangeSelectorMinInput:["rangeSelector","minInputLabel"],svgContainerEnd:["screenReaderSection","endOfChartMarker"],viewAsDataTable:["table","viewAsDataTableButtonText"],tableSummary:["table","tableSummary"]})}function copyDeprecatedOptions(o){copyDeprecatedChartOptions(o),copyDeprecatedAxisOptions(o),o.series&&copyDeprecatedSeriesOptions(o),copyDeprecatedTopLevelAccessibilityOptions(o),copyDeprecatedKeyboardNavigationOptions(o),copyDeprecatedLangOptions(o)}var format$3=FormatUtilities.format,pick$P=Utilities.pick;function stringTrim(o){return o.trim&&o.trim()||o.replace(/^\s+|\s+$/g,"")}function formatExtendedStatement(o,r){var t=o.indexOf("#each("),n=o.indexOf("#plural("),s=o.indexOf("["),a=o.indexOf("]"),l,h;if(t>-1){var d=o.slice(t).indexOf(")")+t,c=o.substring(0,t),f=o.substring(d+1),u=o.substring(t+6,d),p=u.split(","),g=Number(p[1]),m=void 0;if(h="",l=r[p[0]],l){g=isNaN(g)?l.length:g,m=g<0?l.length+g:Math.min(g,l.length);for(var v=0;v<m;++v)h+=c+l[v]+f}return h.length?h:""}if(n>-1){var x=o.slice(n).indexOf(")")+n,y=o.substring(n+8,x),b=y.split(","),$=Number(r[b[0]]);switch($){case 0:h=pick$P(b[4],b[1]);break;case 1:h=pick$P(b[2],b[1]);break;case 2:h=pick$P(b[3],b[1]);break;default:h=b[1]}return h?stringTrim(h):""}if(s>-1){var S=o.substring(0,s),k=Number(o.substring(s+1,a)),A=void 0;return l=r[S],!isNaN(k)&&l&&(k<0?(A=l[l.length+k],typeof A>"u"&&(A=l[0])):(A=l[k],typeof A>"u"&&(A=l[l.length-1]))),typeof A<"u"?A:""}return"{"+o+"}"}H.i18nFormat=function(o,r,t){var n=function(d,c){var f=d.slice(c||0),u=f.indexOf("{"),p=f.indexOf("}");if(u>-1&&p>u)return{statement:f.substring(u+1,p),begin:c+u+1,end:c+p}},s=[],a,l,h=0;do a=n(o,h),l=o.substring(h,a&&a.begin-1),l.length&&s.push({value:l,type:"constant"}),a&&s.push({value:a.statement,type:"statement"}),h=a?a.end+1:h+1;while(a);return s.forEach(function(d){d.type==="statement"&&(d.value=formatExtendedStatement(d.value,r))}),format$3(s.reduce(function(d,c){return d+c.value},""),r,t)};Chart$1.prototype.langFormat=function(o,r){for(var t=o.split("."),n=this.options.lang,s=0;s<t.length;++s)n=n&&n[t[s]];return typeof n=="string"?H.i18nFormat(n,r,this):""};var addEvent$x=Utilities.addEvent,extend$M=Utilities.extend,pick$O=Utilities.pick,svgElementBorderUpdateTriggers=["x","y","transform","width","height","r","d","stroke-width"];function addDestroyFocusBorderHook(o){if(!o.focusBorderDestroyHook){var r=o.destroy;o.destroy=function(){return o.focusBorder&&o.focusBorder.destroy&&o.focusBorder.destroy(),r.apply(o,arguments)},o.focusBorderDestroyHook=r}}function removeDestroyFocusBorderHook(o){o.focusBorderDestroyHook&&(o.destroy=o.focusBorderDestroyHook,delete o.focusBorderDestroyHook)}function addUpdateFocusBorderHooks(o){for(var r=[],t=1;t<arguments.length;t++)r[t-1]=arguments[t];o.focusBorderUpdateHooks||(o.focusBorderUpdateHooks={},svgElementBorderUpdateTriggers.forEach(function(n){var s=n+"Setter",a=o[s]||o._defaultSetter;o.focusBorderUpdateHooks[s]=a,o[s]=function(){var l=a.apply(o,arguments);return o.addFocusBorder.apply(o,r),l}}))}function removeUpdateFocusBorderHooks(o){o.focusBorderUpdateHooks&&(Object.keys(o.focusBorderUpdateHooks).forEach(function(r){var t=o.focusBorderUpdateHooks[r];t===o._defaultSetter?delete o[r]:o[r]=t}),delete o.focusBorderUpdateHooks)}extend$M(SVGElement.prototype,{addFocusBorder:function(o,r){this.focusBorder&&this.removeFocusBorder();var t=this.getBBox(),n=pick$O(o,3);t.x+=this.translateX?this.translateX:0,t.y+=this.translateY?this.translateY:0;var s=t.x-n,a=t.y-n,l=t.width+2*n,h=t.height+2*n;function d(v){var x=0,y=0;return v.attr("text-anchor")==="middle"?x=y=.5:v.rotation?x=.25:y=.75,{x,y}}var c=this instanceof SVGLabel;if(this.element.nodeName==="text"||c){var f=!!this.rotation,u=c?{x:f?1:0,y:0}:d(this),p=+this.attr("x"),g=+this.attr("y");if(isNaN(p)||(s=p-t.width*u.x-n),isNaN(g)||(a=g-t.height*u.y-n),c&&f){var m=l;l=h,h=m,isNaN(p)||(s=p-t.height*u.x-n),isNaN(g)||(a=g-t.width*u.y-n)}}this.focusBorder=this.renderer.rect(s,a,l,h,parseInt((r&&r.r||0).toString(),10)).addClass("highcharts-focus-border").attr({zIndex:99}).add(this.parentGroup),this.renderer.styledMode||this.focusBorder.attr({stroke:r&&r.stroke,"stroke-width":r&&r.strokeWidth}),addUpdateFocusBorderHooks(this,o,r),addDestroyFocusBorderHook(this)},removeFocusBorder:function(){removeUpdateFocusBorderHooks(this),removeDestroyFocusBorderHook(this),this.focusBorder&&(this.focusBorder.destroy(),delete this.focusBorder)}});Chart$1.prototype.renderFocusBorder=function(){var o=this.focusElement,r=this.options.accessibility.keyboardNavigation.focusBorder;o&&(o.removeFocusBorder(),r.enabled&&o.addFocusBorder(r.margin,{stroke:r.style.color,strokeWidth:r.style.lineWidth,r:r.style.borderRadius}))};Chart$1.prototype.setFocusToElement=function(o,r){var t=this.options.accessibility.keyboardNavigation.focusBorder,n=r||o.element;n&&n.focus&&(n.hcEvents&&n.hcEvents.focusin||addEvent$x(n,"focusin",function(){}),n.focus(),t.hideBrowserFocusOutline&&(n.style.outline="none")),this.focusElement&&this.focusElement.removeFocusBorder(),this.focusElement=o,this.renderFocusBorder()};var doc$5=H.doc,defaultOptions$4=DefaultOptions.defaultOptions,addEvent$w=Utilities.addEvent,extend$L=Utilities.extend,fireEvent$d=Utilities.fireEvent,merge$L=Utilities.merge;merge$L(!0,defaultOptions$4,Options,{accessibility:{highContrastTheme:theme},lang:langOptions});H.A11yChartUtilities=ChartUtilities;H.A11yHTMLUtilities=HTMLUtilities;H.KeyboardNavigationHandler=KeyboardNavigationHandler;H.AccessibilityComponent=AccessibilityComponent;function Accessibility(o){this.init(o)}Accessibility.prototype={init:function(o){if(this.chart=o,!doc$5.addEventListener||!o.renderer.isSVG){o.renderTo.setAttribute("aria-hidden",!0);return}copyDeprecatedOptions(o),this.initComponents(),this.keyboardNavigation=new KeyboardNavigation(o,this.components),this.update()},initComponents:function(){var o=this.chart,r=o.options.accessibility;this.components={container:new ContainerComponent,infoRegions:new InfoRegionsComponent,legend:new LegendComponent,chartMenu:new MenuComponent,rangeSelector:new RangeSelectorComponent,series:new SeriesComponent,zoom:new ZoomComponent},r.customComponents&&extend$L(this.components,r.customComponents);var t=this.components;this.getComponentOrder().forEach(function(n){t[n].initBase(o),t[n].init()})},getComponentOrder:function(){if(!this.components)return[];if(!this.components.series)return Object.keys(this.components);var o=Object.keys(this.components).filter(function(r){return r!=="series"});return["series"].concat(o)},update:function(){var o=this.components,r=this.chart,t=r.options.accessibility;fireEvent$d(r,"beforeA11yUpdate"),r.types=this.getChartTypes(),this.getComponentOrder().forEach(function(n){o[n].onChartUpdate(),fireEvent$d(r,"afterA11yComponentUpdate",{name:n,component:o[n]})}),this.keyboardNavigation.update(t.keyboardNavigation.order),!r.highContrastModeActive&&whcm.isHighContrastModeActive()&&whcm.setHighContrastTheme(r),fireEvent$d(r,"afterA11yUpdate",{accessibility:this})},destroy:function(){var o=this.chart||{},r=this.components;Object.keys(r).forEach(function(t){r[t].destroy(),r[t].destroyBase()}),this.keyboardNavigation&&this.keyboardNavigation.destroy(),o.renderTo&&o.renderTo.setAttribute("aria-hidden",!0),o.focusElement&&o.focusElement.removeFocusBorder()},getChartTypes:function(){var o={};return this.chart.series.forEach(function(r){o[r.type]=1}),Object.keys(o)}};Chart$1.prototype.updateA11yEnabled=function(){var o=this.accessibility,r=this.options.accessibility;r&&r.enabled?o?o.update():this.accessibility=o=new Accessibility(this):o?(o.destroy&&o.destroy(),delete this.accessibility):this.renderTo.setAttribute("aria-hidden",!0)};addEvent$w(Chart$1,"render",function(o){this.a11yDirty&&this.renderTo&&(delete this.a11yDirty,this.updateA11yEnabled());var r=this.accessibility;r&&r.getComponentOrder().forEach(function(t){r.components[t].onChartRender()})});addEvent$w(Chart$1,"update",function(o){var r=o.options.accessibility;r&&(r.customComponents&&(this.options.accessibility.customComponents=r.customComponents,delete r.customComponents),merge$L(!0,this.options.accessibility,r),this.accessibility&&this.accessibility.destroy&&(this.accessibility.destroy(),delete this.accessibility)),this.a11yDirty=!0});addEvent$w(Point$2,"update",function(){this.series.chart.accessibility&&(this.series.chart.a11yDirty=!0)});["addSeries","init"].forEach(function(o){addEvent$w(Chart$1,o,function(){this.a11yDirty=!0})});["update","updatedData","remove"].forEach(function(o){addEvent$w(Series$e,o,function(){this.chart.accessibility&&(this.chart.a11yDirty=!0)})});["afterDrilldown","drillupall"].forEach(function(o){addEvent$w(Chart$1,o,function(){this.accessibility&&this.accessibility.update()})});addEvent$w(Chart$1,"destroy",function(){this.accessibility&&this.accessibility.destroy()});var addEvent$v=Utilities.addEvent,fireEvent$c=Utilities.fireEvent,objectEach$c=Utilities.objectEach,pick$N=Utilities.pick,removeEvent$2=Utilities.removeEvent,eventEmitterMixin={addEvents:function(){var o=this,r=function(n){addEvent$v(n,H.isTouchDevice?"touchstart":"mousedown",function(s){o.onMouseDown(s)},{passive:!1})};if(r(this.graphic.element),(o.labels||[]).forEach(function(n){n.options.useHTML&&n.graphic.text&&r(n.graphic.text.element)}),objectEach$c(o.options.events,function(n,s){var a=function(l){(s!=="click"||!o.cancelClick)&&n.call(o,o.chart.pointer.normalize(l),o.target)};(o.nonDOMEvents||[]).indexOf(s)===-1?o.graphic.on(s,a):addEvent$v(o,s,a,{passive:!1})}),o.options.draggable&&(addEvent$v(o,"drag",o.onDrag),!o.graphic.renderer.styledMode)){var t={cursor:{x:"ew-resize",y:"ns-resize",xy:"move"}[o.options.draggable]};o.graphic.css(t),(o.labels||[]).forEach(function(n){n.options.useHTML&&n.graphic.text&&n.graphic.text.css(t)})}o.isUpdating||fireEvent$c(o,"add")},removeDocEvents:function(){this.removeDrag&&(this.removeDrag=this.removeDrag()),this.removeMouseUp&&(this.removeMouseUp=this.removeMouseUp())},onMouseDown:function(o){var r=this,t=r.chart.pointer,n,s;o.preventDefault&&o.preventDefault(),o.button!==2&&(o=t.normalize(o),n=o.chartX,s=o.chartY,r.cancelClick=!1,r.chart.hasDraggedAnnotation=!0,r.removeDrag=addEvent$v(H.doc,H.isTouchDevice?"touchmove":"mousemove",function(a){r.hasDragged=!0,a=t.normalize(a),a.prevChartX=n,a.prevChartY=s,fireEvent$c(r,"drag",a),n=a.chartX,s=a.chartY},H.isTouchDevice?{passive:!1}:void 0),r.removeMouseUp=addEvent$v(H.doc,H.isTouchDevice?"touchend":"mouseup",function(a){var l=pick$N(r.target&&r.target.annotation,r.target);l&&(l.cancelClick=r.hasDragged),r.cancelClick=r.hasDragged,r.hasDragged=!1,r.chart.hasDraggedAnnotation=!1,fireEvent$c(pick$N(l,r),"afterUpdate"),r.onMouseUp(a)},H.isTouchDevice?{passive:!1}:void 0))},onMouseUp:function(o){var r=this.chart,t=this.target||this,n=r.options.annotations,s=r.annotations.indexOf(t);this.removeDocEvents(),n[s]=t.options},onDrag:function(o){if(this.chart.isInsidePlot(o.chartX-this.chart.plotLeft,o.chartY-this.chart.plotTop,{visiblePlotOnly:!0})){var r=this.mouseMoveToTranslation(o);this.options.draggable==="x"&&(r.y=0),this.options.draggable==="y"&&(r.x=0),this.points.length?this.translate(r.x,r.y):(this.shapes.forEach(function(t){t.translate(r.x,r.y)}),this.labels.forEach(function(t){t.translate(r.x,r.y)})),this.redraw(!1)}},mouseMoveToRadians:function(o,r,t){var n=o.prevChartY-t,s=o.prevChartX-r,a=o.chartY-t,l=o.chartX-r,h;return this.chart.inverted&&(h=s,s=n,n=h,h=l,l=a,a=h),Math.atan2(a,l)-Math.atan2(n,s)},mouseMoveToTranslation:function(o){var r=o.chartX-o.prevChartX,t=o.chartY-o.prevChartY,n;return this.chart.inverted&&(n=t,t=r,r=n),{x:r,y:t}},mouseMoveToScale:function(o,r,t){var n=o.prevChartX-r,s=o.prevChartY-t,a=o.chartX-r,l=o.chartY-t,h=(a||1)/(n||1),d=(l||1)/(s||1),c;return this.chart.inverted&&(c=d,d=h,h=c),{x:h,y:d}},destroy:function(){this.removeDocEvents(),removeEvent$2(this),this.hcEvents=null}},merge$K=Utilities.merge,pick$M=Utilities.pick,ControlPoint=function(){function o(r,t,n,s){this.addEvents=eventEmitterMixin.addEvents,this.graphic=void 0,this.mouseMoveToRadians=eventEmitterMixin.mouseMoveToRadians,this.mouseMoveToScale=eventEmitterMixin.mouseMoveToScale,this.mouseMoveToTranslation=eventEmitterMixin.mouseMoveToTranslation,this.onDrag=eventEmitterMixin.onDrag,this.onMouseDown=eventEmitterMixin.onMouseDown,this.onMouseUp=eventEmitterMixin.onMouseUp,this.removeDocEvents=eventEmitterMixin.removeDocEvents,this.nonDOMEvents=["drag"],this.chart=r,this.target=t,this.options=n,this.index=pick$M(n.index,s)}return o.prototype.setVisibility=function(r){this.graphic.attr("visibility",r?"visible":"hidden"),this.options.visible=r},o.prototype.render=function(){var r=this.chart,t=this.options;this.graphic=r.renderer.symbol(t.symbol,0,0,t.width,t.height).add(r.controlPointsGroup).css(t.style),this.setVisibility(t.visible),this.addEvents()},o.prototype.redraw=function(r){this.graphic[r?"animate":"attr"](this.options.positioner.call(this,this.target))},o.prototype.destroy=function(){eventEmitterMixin.destroy.call(this),this.graphic&&(this.graphic=this.graphic.destroy()),this.chart=null,this.target=null,this.options=null},o.prototype.update=function(r){var t=this.chart,n=this.target,s=this.index,a=merge$K(!0,this.options,r);this.destroy(),this.constructor(t,n,a,s),this.render(t.controlPointsGroup),this.redraw()},o}(),defined$l=Utilities.defined,fireEvent$b=Utilities.fireEvent,MockPoint=function(){function o(r,t,n){this.isInside=void 0,this.negative=void 0,this.plotX=void 0,this.plotY=void 0,this.ttBelow=void 0,this.x=void 0,this.y=void 0,this.mock=!0,this.series={visible:!0,chart:r,getPlotBox:Series$e.prototype.getPlotBox},this.target=t||null,this.options=n,this.applyOptions(this.getOptions())}return o.fromPoint=function(r){return new o(r.series.chart,null,{x:r.x,y:r.y,xAxis:r.series.xAxis,yAxis:r.series.yAxis})},o.pointToPixels=function(r,t){var n=r.series,s=n.chart,a=r.plotX,l=r.plotY,h;return s.inverted&&(r.mock?(a=r.plotY,l=r.plotX):(a=s.plotWidth-r.plotY,l=s.plotHeight-r.plotX)),n&&!t&&(h=n.getPlotBox(),a+=h.translateX,l+=h.translateY),{x:a,y:l}},o.pointToOptions=function(r){return{x:r.x,y:r.y,xAxis:r.series.xAxis,yAxis:r.series.yAxis}},o.prototype.hasDynamicOptions=function(){return typeof this.options=="function"},o.prototype.getOptions=function(){return this.hasDynamicOptions()?this.options(this.target):this.options},o.prototype.applyOptions=function(r){this.command=r.command,this.setAxis(r,"x"),this.setAxis(r,"y"),this.refresh()},o.prototype.setAxis=function(r,t){var n=t+"Axis",s=r[n],a=this.series.chart;this.series[n]=s instanceof Axis?s:defined$l(s)?a[n][s]||a.get(s):null},o.prototype.toAnchor=function(){var r=[this.plotX,this.plotY,0,0];return this.series.chart.inverted&&(r[0]=this.plotY,r[1]=this.plotX),r},o.prototype.getLabelConfig=function(){return{x:this.x,y:this.y,point:this}},o.prototype.isInsidePlot=function(){var r=this.plotX,t=this.plotY,n=this.series.xAxis,s=this.series.yAxis,a={x:r,y:t,isInsidePlot:!0};return n&&(a.isInsidePlot=defined$l(r)&&r>=0&&r<=n.len),s&&(a.isInsidePlot=a.isInsidePlot&&defined$l(t)&&t>=0&&t<=s.len),fireEvent$b(this.series.chart,"afterIsInsidePlot",a),a.isInsidePlot},o.prototype.refresh=function(){var r=this.series,t=r.xAxis,n=r.yAxis,s=this.getOptions();t?(this.x=s.x,this.plotX=t.toPixels(s.x,!0)):(this.x=null,this.plotX=s.x),n?(this.y=s.y,this.plotY=n.toPixels(s.y,!0)):(this.y=null,this.plotY=s.y),this.isInside=this.isInsidePlot()},o.prototype.translate=function(r,t,n,s){this.hasDynamicOptions()||(this.plotX+=n,this.plotY+=s,this.refreshOptions())},o.prototype.scale=function(r,t,n,s){if(!this.hasDynamicOptions()){var a=this.plotX*n,l=this.plotY*s,h=(1-n)*r,d=(1-s)*t;this.plotX=h+a,this.plotY=d+l,this.refreshOptions()}},o.prototype.rotate=function(r,t,n){if(!this.hasDynamicOptions()){var s=Math.cos(n),a=Math.sin(n),l=this.plotX,h=this.plotY,d=void 0,c=void 0;l-=r,h-=t,d=l*s-h*a,c=l*a+h*s,this.plotX=d+r,this.plotY=c+t,this.refreshOptions()}},o.prototype.refreshOptions=function(){var r=this.series,t=r.xAxis,n=r.yAxis;this.x=this.options.x=t?this.options.x=t.toValue(this.plotX,!0):this.plotX,this.y=this.options.y=n?n.toValue(this.plotY,!0):this.plotY},o}(),isObject$7=Utilities.isObject,isString$2=Utilities.isString,merge$J=Utilities.merge,splat$6=Utilities.splat,controllableMixin={init:function(o,r,t){this.annotation=o,this.chart=o.chart,this.options=r,this.points=[],this.controlPoints=[],this.index=t,this.linkPoints(),this.addControlPoints()},attr:function(){this.graphic.attr.apply(this.graphic,arguments)},getPointsOptions:function(){var o=this.options;return o.points||o.point&&splat$6(o.point)},attrsFromOptions:function(o){var r=this.constructor.attrsMap,t={},n,s,a=this.chart.styledMode;for(n in o)s=r[n],s&&(!a||["fill","stroke","stroke-width"].indexOf(s)===-1)&&(t[s]=o[n]);return t},anchor:function(o){var r=o.series.getPlotBox(),t=o.series.chart,n=o.mock?o.toAnchor():Tooltip.prototype.getAnchor.call({chart:o.series.chart},o),s={x:n[0]+(this.options.x||0),y:n[1]+(this.options.y||0),height:n[2]||0,width:n[3]||0};return{relativePosition:s,absolutePosition:merge$J(s,{x:s.x+(o.mock?r.translateX:t.plotLeft),y:s.y+(o.mock?r.translateY:t.plotTop)})}},point:function(o,r){if(o&&o.series)return o;if(!r||r.series===null){if(isObject$7(o))r=new MockPoint(this.chart,this,o);else if(isString$2(o))r=this.chart.get(o)||null;else if(typeof o=="function"){var t=o.call(r,this);r=t.series?t:new MockPoint(this.chart,this,o)}}return r},linkPoints:function(){var o=this.getPointsOptions(),r=this.points,t=o&&o.length||0,n,s;for(n=0;n<t;n++){if(s=this.point(o[n],r[n]),!s){r.length=0;return}s.mock&&s.refresh(),r[n]=s}return r},addControlPoints:function(){var o=this.options.controlPoints;(o||[]).forEach(function(r,t){var n=merge$J(this.options.controlPointOptions,r);n.index||(n.index=t),o[t]=n,this.controlPoints.push(new ControlPoint(this.chart,this,n))},this)},shouldBeDrawn:function(){return!!this.points.length},render:function(o){this.controlPoints.forEach(function(r){r.render()})},redraw:function(o){this.controlPoints.forEach(function(r){r.redraw(o)})},transform:function(o,r,t,n,s){if(this.chart.inverted){var a=r;r=t,t=a}this.points.forEach(function(l,h){this.transformPoint(o,r,t,n,s,h)},this)},transformPoint:function(o,r,t,n,s,a){var l=this.points[a];l.mock||(l=this.points[a]=MockPoint.fromPoint(l)),l[o](r,t,n,s)},translate:function(o,r){this.transform("translate",null,null,o,r)},translatePoint:function(o,r,t){this.transformPoint("translate",null,null,o,r,t)},translateShape:function(o,r){var t=this.annotation.chart,n=this.annotation.userOptions,s=t.annotations.indexOf(this.annotation),a=t.options.annotations[s];this.translatePoint(o,r,0),a[this.collection][this.index].point=this.options.point,n[this.collection][this.index].point=this.options.point},rotate:function(o,r,t){this.transform("rotate",o,r,t)},scale:function(o,r,t,n){this.transform("scale",o,r,t,n)},setControlPointsVisibility:function(o){this.controlPoints.forEach(function(r){r.setVisibility(o)})},destroy:function(){this.graphic&&(this.graphic=this.graphic.destroy()),this.tracker&&(this.tracker=this.tracker.destroy()),this.controlPoints.forEach(function(o){o.destroy()}),this.chart=null,this.points=null,this.controlPoints=null,this.options=null,this.annotation&&(this.annotation=null)},update:function(o){var r=this.annotation,t=merge$J(!0,this.options,o),n=this.graphic.parentGroup;this.destroy(),this.constructor(r,t,this.index),this.render(n),this.redraw()}},addEvent$u=Utilities.addEvent,defined$k=Utilities.defined,merge$I=Utilities.merge,uniqueKey$2=Utilities.uniqueKey,defaultMarkers={arrow:{tagName:"marker",attributes:{id:"arrow",refY:5,refX:9,markerWidth:10,markerHeight:10},children:[{tagName:"path",attributes:{d:"M 0 0 L 10 5 L 0 10 Z","stroke-width":0}}]},"reverse-arrow":{tagName:"marker",attributes:{id:"reverse-arrow",refY:5,refX:1,markerWidth:10,markerHeight:10},children:[{tagName:"path",attributes:{d:"M 0 5 L 10 0 L 10 10 Z","stroke-width":0}}]}};SVGRenderer.prototype.addMarker=function(o,r){var t={attributes:{id:o}},n={stroke:r.color||"none",fill:r.color||"rgba(0, 0, 0, 0.75)"};t.children=r.children&&r.children.map(function(l){return merge$I(n,l)});var s=merge$I(!0,{attributes:{markerWidth:20,markerHeight:20,refX:0,refY:0,orient:"auto"}},r,t),a=this.definition(s);return a.id=o,a};function createMarkerSetter(o){return function(r){this.attr(o,"url(#"+r+")")}}var markerMixin={markerEndSetter:createMarkerSetter("marker-end"),markerStartSetter:createMarkerSetter("marker-start"),setItemMarkers:function(o){var r=o.options,t=o.chart,n=t.options.defs,s=r.fill,a=defined$k(s)&&s!=="none"?s:r.stroke,l=function(h){var d=r[h],c,f,u,p;if(d){for(u in n)if(c=n[u],(d===(c.attributes&&c.attributes.id)||d===c.id)&&c.tagName==="marker"){f=c;break}f&&(p=o[h]=t.renderer.addMarker((r.id||uniqueKey$2())+"-"+d,merge$I(f,{color:a})),o.attr(h,p.getAttribute("id")))}};["markerStart","markerEnd"].forEach(l)}};addEvent$u(Chart$1,"afterGetContainer",function(){this.options.defs=merge$I(defaultMarkers,this.options.defs||{})});var extend$K=Utilities.extend,TRACKER_FILL="rgba(192,192,192,"+(H.svg?1e-4:.002)+")",ControllablePath=function(){function o(r,t,n){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.setMarkers=markerMixin.setItemMarkers,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translate=controllableMixin.translate,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="path",this.init(r,t,n),this.collection="shapes"}return o.prototype.toD=function(){var r=this.options.d;if(r)return typeof r=="function"?r.call(this):r;var t=this.points,n=t.length,s=n,a=t[0],l=s&&this.anchor(a).absolutePosition,h=0,d,c=[];if(l)for(c.push(["M",l.x,l.y]);++h<n&&s;)a=t[h],d=a.command||"L",l=this.anchor(a).absolutePosition,d==="M"?c.push([d,l.x,l.y]):d==="L"?c.push([d,l.x,l.y]):d==="Z"&&c.push([d]),s=a.series.visible;return s?this.chart.renderer.crispLine(c,this.graphic.strokeWidth()):null},o.prototype.shouldBeDrawn=function(){return controllableMixin.shouldBeDrawn.call(this)||!!this.options.d},o.prototype.render=function(r){var t=this.options,n=this.attrsFromOptions(t);this.graphic=this.annotation.chart.renderer.path([["M",0,0]]).attr(n).add(r),t.className&&this.graphic.addClass(t.className),this.tracker=this.annotation.chart.renderer.path([["M",0,0]]).addClass("highcharts-tracker-line").attr({zIndex:2}).add(r),this.annotation.chart.styledMode||this.tracker.attr({"stroke-linejoin":"round",stroke:TRACKER_FILL,fill:TRACKER_FILL,"stroke-width":this.graphic.strokeWidth()+t.snap*2}),controllableMixin.render.call(this),extend$K(this.graphic,{markerStartSetter:markerMixin.markerStartSetter,markerEndSetter:markerMixin.markerEndSetter}),this.setMarkers(this)},o.prototype.redraw=function(r){var t=this.toD(),n=r?"animate":"attr";t?(this.graphic[n]({d:t}),this.tracker[n]({d:t})):(this.graphic.attr({d:"M 0 "+-9e9}),this.tracker.attr({d:"M 0 "+-9e9})),this.graphic.placed=this.tracker.placed=!!t,controllableMixin.redraw.call(this,r)},o.attrsMap={dashStyle:"dashstyle",strokeWidth:"stroke-width",stroke:"stroke",fill:"fill",zIndex:"zIndex"},o}(),merge$H=Utilities.merge,ControllableRect=function(){function o(r,t,n){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="rect",this.translate=controllableMixin.translateShape,this.init(r,t,n),this.collection="shapes"}return o.prototype.render=function(r){var t=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.rect(0,-9e9,0,0).attr(t).add(r),controllableMixin.render.call(this)},o.prototype.redraw=function(r){var t=this.anchor(this.points[0]).absolutePosition;t?this.graphic[r?"animate":"attr"]({x:t.x,y:t.y,width:this.options.width,height:this.options.height}):this.attr({x:0,y:-9e9}),this.graphic.placed=!!t,controllableMixin.redraw.call(this,r)},o.attrsMap=merge$H(ControllablePath.attrsMap,{width:"width",height:"height"}),o}(),merge$G=Utilities.merge,ControllableCircle=function(){function o(r,t,n){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="circle",this.translate=controllableMixin.translateShape,this.init(r,t,n),this.collection="shapes"}return o.prototype.render=function(r){var t=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.circle(0,-9e9,0).attr(t).add(r),controllableMixin.render.call(this)},o.prototype.redraw=function(r){var t=this.anchor(this.points[0]).absolutePosition;t?this.graphic[r?"animate":"attr"]({x:t.x,y:t.y,r:this.options.r}):this.graphic.attr({x:0,y:-9e9}),this.graphic.placed=!!t,controllableMixin.redraw.call(this,r)},o.prototype.setRadius=function(r){this.options.r=r},o.attrsMap=merge$G(ControllablePath.attrsMap,{r:"r"}),o}(),format$2=FormatUtilities.format,symbols$2=SVGRenderer.prototype.symbols,extend$J=Utilities.extend,isNumber$k=Utilities.isNumber,pick$L=Utilities.pick,ControllableLabel=function(){function o(r,t,n){this.addControlPoints=controllableMixin.addControlPoints,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.init(r,t,n),this.collection="labels"}return o.alignedPosition=function(r,t){var n=r.align,s=r.verticalAlign,a=(t.x||0)+(r.x||0),l=(t.y||0)+(r.y||0),h,d;return n==="right"?h=1:n==="center"&&(h=2),h&&(a+=(t.width-(r.width||0))/h),s==="bottom"?d=1:s==="middle"&&(d=2),d&&(l+=(t.height-(r.height||0))/d),{x:Math.round(a),y:Math.round(l)}},o.justifiedOptions=function(r,t,n,s){var a=n.align,l=n.verticalAlign,h=t.box?0:t.padding||0,d=t.getBBox(),c={align:a,verticalAlign:l,x:n.x,y:n.y,width:t.width,height:t.height},f=(s.x||0)-r.plotLeft,u=(s.y||0)-r.plotTop,p;return p=f+h,p<0&&(a==="right"?c.align="left":c.x=(c.x||0)-p),p=f+d.width-h,p>r.plotWidth&&(a==="left"?c.align="right":c.x=(c.x||0)+r.plotWidth-p),p=u+h,p<0&&(l==="bottom"?c.verticalAlign="top":c.y=(c.y||0)-p),p=u+d.height-h,p>r.plotHeight&&(l==="top"?c.verticalAlign="bottom":c.y=(c.y||0)+r.plotHeight-p),c},o.prototype.translatePoint=function(r,t){controllableMixin.translatePoint.call(this,r,t,0)},o.prototype.translate=function(r,t){var n=this.annotation.chart,s=this.annotation.userOptions,a=n.annotations.indexOf(this.annotation),l=n.options.annotations,h=l[a];if(n.inverted){var d=r;r=t,t=d}this.options.x+=r,this.options.y+=t,h[this.collection][this.index].x=this.options.x,h[this.collection][this.index].y=this.options.y,s[this.collection][this.index].x=this.options.x,s[this.collection][this.index].y=this.options.y},o.prototype.render=function(r){var t=this.options,n=this.attrsFromOptions(t),s=t.style;this.graphic=this.annotation.chart.renderer.label("",0,-9999,t.shape,null,null,t.useHTML,null,"annotation-label").attr(n).add(r),this.annotation.chart.styledMode||(s.color==="contrast"&&(s.color=this.annotation.chart.renderer.getContrast(o.shapesWithoutBackground.indexOf(t.shape)>-1?"#FFFFFF":t.backgroundColor)),this.graphic.css(t.style).shadow(t.shadow)),t.className&&this.graphic.addClass(t.className),this.graphic.labelrank=t.labelrank,controllableMixin.render.call(this)},o.prototype.redraw=function(r){var t=this.options,n=this.text||t.format||t.text,s=this.graphic,a=this.points[0];s.attr({text:n?format$2(n,a.getLabelConfig(),this.annotation.chart):t.formatter.call(a,this)});var l=this.anchor(a),h=this.position(l);h?(s.alignAttr=h,h.anchorX=l.absolutePosition.x,h.anchorY=l.absolutePosition.y,s[r?"animate":"attr"](h)):s.attr({x:0,y:-9999}),s.placed=!!h,controllableMixin.redraw.call(this,r)},o.prototype.anchor=function(r){var t=controllableMixin.anchor.apply(this,arguments),n=this.options.x||0,s=this.options.y||0;return t.absolutePosition.x-=n,t.absolutePosition.y-=s,t.relativePosition.x-=n,t.relativePosition.y-=s,t},o.prototype.position=function(r){var t=this.graphic,n=this.annotation.chart,s=this.points[0],a=this.options,l=r.absolutePosition,h=r.relativePosition,d,c,f,u,p=s.series.visible&&MockPoint.prototype.isInsidePlot.call(s),g=t.width,m=g===void 0?0:g,v=t.height,x=v===void 0?0:v;return p&&(a.distance?d=Tooltip.prototype.getPosition.call({chart:n,distance:pick$L(a.distance,16)},m,x,{plotX:h.x,plotY:h.y,negative:s.negative,ttBelow:s.ttBelow,h:h.height||h.width}):a.positioner?d=a.positioner.call(this):(c={x:l.x,y:l.y,width:0,height:0},d=o.alignedPosition(extend$J(a,{width:m,height:x}),c),this.options.overflow==="justify"&&(d=o.alignedPosition(o.justifiedOptions(n,t,a,d),c))),a.crop&&(f=d.x-n.plotLeft,u=d.y-n.plotTop,p=n.isInsidePlot(f,u)&&n.isInsidePlot(f+m,u+x))),p?d:null},o.attrsMap={backgroundColor:"fill",borderColor:"stroke",borderWidth:"stroke-width",zIndex:"zIndex",borderRadius:"r",padding:"padding"},o.shapesWithoutBackground=["connector"],o}();symbols$2.connector=function(o,r,t,n,s){var a=s&&s.anchorX,l=s&&s.anchorY,h,d,c=t/2;return isNumber$k(a)&&isNumber$k(l)&&(h=[["M",a,l]],d=r-l,d<0&&(d=-n-d),d<t&&(c=a<o+t/2?d:t-d),l>r+n?h.push(["L",o+c,r+n]):l<r?h.push(["L",o+c,r]):a<o?h.push(["L",o,r+n/2]):a>o+t&&h.push(["L",o+t,r+n/2])),h||[]};var ControllableImage=function(){function o(r,t,n){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="image",this.translate=controllableMixin.translateShape,this.init(r,t,n),this.collection="shapes"}return o.prototype.render=function(r){var t=this.attrsFromOptions(this.options),n=this.options;this.graphic=this.annotation.chart.renderer.image(n.src,0,-9e9,n.width,n.height).attr(t).add(r),this.graphic.width=n.width,this.graphic.height=n.height,controllableMixin.render.call(this)},o.prototype.redraw=function(r){var t=this.anchor(this.points[0]),n=ControllableLabel.prototype.position.call(this,t);n?this.graphic[r?"animate":"attr"]({x:n.x,y:n.y}):this.graphic.attr({x:0,y:-9e9}),this.graphic.placed=!!n,controllableMixin.redraw.call(this,r)},o.attrsMap={width:"width",height:"height",zIndex:"zIndex"},o}(),getDeferredAnimation=animationExports.getDeferredAnimation,chartProto=Chart$1.prototype,addEvent$t=Utilities.addEvent,defined$j=Utilities.defined,destroyObjectProperties=Utilities.destroyObjectProperties,erase=Utilities.erase,extend$I=Utilities.extend,find$5=Utilities.find,fireEvent$a=Utilities.fireEvent,merge$F=Utilities.merge,pick$K=Utilities.pick,splat$5=Utilities.splat,wrap$a=Utilities.wrap,Annotation=function(){function o(r,t){this.annotation=void 0,this.coll="annotations",this.collection=void 0,this.animationConfig=void 0,this.graphic=void 0,this.group=void 0,this.labelCollector=void 0,this.labelsGroup=void 0,this.shapesGroup=void 0;var n;this.chart=r,this.points=[],this.controlPoints=[],this.coll="annotations",this.labels=[],this.shapes=[],this.options=merge$F(this.defaultOptions,t),this.userOptions=t,n=this.getLabelsAndShapesOptions(this.options,t),this.options.labels=n.labels,this.options.shapes=n.shapes,this.init(r,this.options)}return o.prototype.init=function(){var r=this.chart,t=this.options.animation;this.linkPoints(),this.addControlPoints(),this.addShapes(),this.addLabels(),this.setLabelCollector(),this.animationConfig=getDeferredAnimation(r,t)},o.prototype.getLabelsAndShapesOptions=function(r,t){var n={};return["labels","shapes"].forEach(function(s){r[s]&&(t[s]?n[s]=splat$5(t[s]).map(function(a,l){return merge$F(r[s][l],a)}):n[s]=r[s])}),n},o.prototype.addShapes=function(){(this.options.shapes||[]).forEach(function(r,t){var n=this.initShape(r,t);merge$F(!0,this.options.shapes[t],n.options)},this)},o.prototype.addLabels=function(){(this.options.labels||[]).forEach(function(r,t){var n=this.initLabel(r,t);merge$F(!0,this.options.labels[t],n.options)},this)},o.prototype.addClipPaths=function(){this.setClipAxes(),this.clipXAxis&&this.clipYAxis&&(this.clipRect=this.chart.renderer.clipRect(this.getClipBox()))},o.prototype.setClipAxes=function(){var r=this.chart.xAxis,t=this.chart.yAxis,n=(this.options.labels||[]).concat(this.options.shapes||[]).reduce(function(s,a){var l=a&&(a.point||a.points&&a.points[0]);return[r[l&&l.xAxis]||s[0],t[l&&l.yAxis]||s[1]]},[]);this.clipXAxis=n[0],this.clipYAxis=n[1]},o.prototype.getClipBox=function(){if(this.clipXAxis&&this.clipYAxis)return{x:this.clipXAxis.left,y:this.clipYAxis.top,width:this.clipXAxis.width,height:this.clipYAxis.height}},o.prototype.setLabelCollector=function(){var r=this;r.labelCollector=function(){return r.labels.reduce(function(t,n){return n.options.allowOverlap||t.push(n.graphic),t},[])},r.chart.labelCollectors.push(r.labelCollector)},o.prototype.setOptions=function(r){this.options=merge$F(this.defaultOptions,r)},o.prototype.redraw=function(r){this.linkPoints(),this.graphic||this.render(),this.clipRect&&this.clipRect.animate(this.getClipBox()),this.redrawItems(this.shapes,r),this.redrawItems(this.labels,r),controllableMixin.redraw.call(this,r)},o.prototype.redrawItems=function(r,t){for(var n=r.length;n--;)this.redrawItem(r[n],t)},o.prototype.renderItems=function(r){for(var t=r.length;t--;)this.renderItem(r[t])},o.prototype.render=function(){var r=this.chart.renderer;this.graphic=r.g("annotation").attr({opacity:0,zIndex:this.options.zIndex,visibility:this.options.visible?"visible":"hidden"}).add(),this.shapesGroup=r.g("annotation-shapes").add(this.graphic).clip(this.chart.plotBoxClip),this.labelsGroup=r.g("annotation-labels").attr({translateX:0,translateY:0}).add(this.graphic),this.addClipPaths(),this.clipRect&&this.graphic.clip(this.clipRect),this.renderItems(this.shapes),this.renderItems(this.labels),this.addEvents(),controllableMixin.render.call(this)},o.prototype.setVisibility=function(r){var t=this.options,n=this.chart.navigationBindings,s=pick$K(r,!t.visible);this.graphic.attr("visibility",s?"visible":"hidden"),s||(this.setControlPointsVisibility(!1),n.activeAnnotation===this&&n.popup&&n.popup.formType==="annotation-toolbar"&&fireEvent$a(n,"closePopup")),t.visible=s},o.prototype.setControlPointsVisibility=function(r){var t=function(n){n.setControlPointsVisibility(r)};controllableMixin.setControlPointsVisibility.call(this,r),this.shapes.forEach(t),this.labels.forEach(t)},o.prototype.destroy=function(){var r=this.chart,t=function(n){n.destroy()};this.labels.forEach(t),this.shapes.forEach(t),this.clipXAxis=null,this.clipYAxis=null,erase(r.labelCollectors,this.labelCollector),eventEmitterMixin.destroy.call(this),controllableMixin.destroy.call(this),destroyObjectProperties(this,r)},o.prototype.remove=function(){return this.chart.removeAnnotation(this)},o.prototype.update=function(r,t){var n=this.chart,s=this.getLabelsAndShapesOptions(this.userOptions,r),a=n.annotations.indexOf(this),l=merge$F(!0,this.userOptions,r);l.labels=s.labels,l.shapes=s.shapes,this.destroy(),this.constructor(n,l),n.options.annotations[a]=l,this.isUpdating=!0,pick$K(t,!0)&&n.redraw(),fireEvent$a(this,"afterUpdate"),this.isUpdating=!1},o.prototype.initShape=function(r,t){var n=merge$F(this.options.shapeOptions,{controlPointOptions:this.options.controlPointOptions},r),s=new o.shapesMap[n.type](this,n,t);return s.itemType="shape",this.shapes.push(s),s},o.prototype.initLabel=function(r,t){var n=merge$F(this.options.labelOptions,{controlPointOptions:this.options.controlPointOptions},r),s=new ControllableLabel(this,n,t);return s.itemType="label",this.labels.push(s),s},o.prototype.redrawItem=function(r,t){r.linkPoints(),r.shouldBeDrawn()?(r.graphic||this.renderItem(r),r.redraw(pick$K(t,!0)&&r.graphic.placed),r.points.length&&this.adjustVisibility(r)):this.destroyItem(r)},o.prototype.adjustVisibility=function(r){var t=!1,n=r.graphic;r.points.forEach(function(s){s.series.visible!==!1&&s.visible!==!1&&(t=!0)}),t?n.visibility==="hidden"&&n.show():n.hide()},o.prototype.destroyItem=function(r){erase(this[r.itemType+"s"],r),r.destroy()},o.prototype.renderItem=function(r){r.render(r.itemType==="label"?this.labelsGroup:this.shapesGroup)},o.ControlPoint=ControlPoint,o.MockPoint=MockPoint,o.shapesMap={rect:ControllableRect,circle:ControllableCircle,path:ControllablePath,image:ControllableImage},o.types={},o}();merge$F(!0,Annotation.prototype,controllableMixin,eventEmitterMixin,merge$F(Annotation.prototype,{nonDOMEvents:["add","afterUpdate","drag","remove"],defaultOptions:{visible:!0,animation:{},draggable:"xy",labelOptions:{align:"center",allowOverlap:!1,backgroundColor:"rgba(0, 0, 0, 0.75)",borderColor:palette.neutralColor100,borderRadius:3,borderWidth:1,className:"highcharts-no-tooltip",crop:!1,formatter:function(){return defined$j(this.y)?this.y:"Annotation label"},includeInDataExport:!0,overflow:"justify",padding:5,shadow:!1,shape:"callout",style:{fontSize:"11px",fontWeight:"normal",color:"contrast"},useHTML:!1,verticalAlign:"bottom",x:0,y:-16},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1,fill:"rgba(0, 0, 0, 0.75)",r:0,snap:2},controlPointOptions:{symbol:"circle",width:10,height:10,style:{stroke:palette.neutralColor100,"stroke-width":2,fill:palette.backgroundColor},visible:!1,events:{}},events:{},zIndex:6}}));H.extendAnnotation=function(o,r,t,n){r=r||Annotation,extend$I(o.prototype,merge$F(r.prototype,t)),o.prototype.defaultOptions=merge$F(o.prototype.defaultOptions,n||{})};extend$I(chartProto,{initAnnotation:function(o){var r=Annotation.types[o.type]||Annotation,t=new r(this,o);return this.annotations.push(t),t},addAnnotation:function(o,r){var t=this.initAnnotation(o);return this.options.annotations.push(t.options),pick$K(r,!0)&&(t.redraw(),t.graphic.attr({opacity:1})),t},removeAnnotation:function(o){var r=this.annotations,t=o.coll==="annotations"?o:find$5(r,function(n){return n.options.id===o});t&&(fireEvent$a(t,"remove"),erase(this.options.annotations,t.options),erase(r,t),t.destroy())},drawAnnotations:function(){this.plotBoxClip.attr(this.plotBox),this.annotations.forEach(function(o){o.redraw(),o.graphic.animate({opacity:1},o.animationConfig)})}});chartProto.collectionsWithUpdate.push("annotations");chartProto.collectionsWithInit.annotations=[chartProto.addAnnotation];addEvent$t(Chart$1,"afterInit",function(){this.annotations=[],this.options.annotations||(this.options.annotations=[])});chartProto.callbacks.push(function(o){o.plotBoxClip=this.renderer.clipRect(this.plotBox),o.controlPointsGroup=o.renderer.g("control-points").attr({zIndex:99}).clip(o.plotBoxClip).add(),o.options.annotations.forEach(function(r,t){if(!o.annotations.some(function(s){return s.options===r})){var n=o.initAnnotation(r);o.options.annotations[t]=n.options}}),o.drawAnnotations(),addEvent$t(o,"redraw",o.drawAnnotations),addEvent$t(o,"destroy",function(){o.plotBoxClip.destroy(),o.controlPointsGroup.destroy()}),addEvent$t(o,"exportData",function(r){var t=o.annotations,n=(this.options.exporting&&this.options.exporting.csv||{}).columnHeaderFormatter,s=!r.dataRows[1].xValues,a=o.options.lang&&o.options.lang.exportData&&o.options.lang.exportData.annotationHeader,l=function(m){var v;return n&&(v=n(m),v!==!1)?v:(v=a+" "+m,s?{columnTitle:v,topLevelColumnTitle:v}:v)},h=r.dataRows[0].length,d=o.options.exporting&&o.options.exporting.csv&&o.options.exporting.csv.annotations&&o.options.exporting.csv.annotations.itemDelimiter,c=o.options.exporting&&o.options.exporting.csv&&o.options.exporting.csv.annotations&&o.options.exporting.csv.annotations.join;t.forEach(function(m){m.options.labelOptions.includeInDataExport&&m.labels.forEach(function(v){if(v.options.text){var x=v.options.text;v.points.forEach(function(y){var b=y.x,$=y.series.xAxis?y.series.xAxis.options.index:-1,S=!1;if($===-1){for(var k=r.dataRows[0].length,A=new Array(k),P=0;P<k;++P)A[P]="";A.push(x),A.xValues=[],A.xValues[$]=b,r.dataRows.push(A),S=!0}if(S||r.dataRows.forEach(function(E,M){!S&&E.xValues&&$!==void 0&&b===E.xValues[$]&&(c&&E.length>h?E[E.length-1]+=d+x:E.push(x),S=!0)}),!S){for(var k=r.dataRows[0].length,A=new Array(k),P=0;P<k;++P)A[P]="";A[0]=b,A.push(x),A.xValues=[],$!==void 0&&(A.xValues[$]=b),r.dataRows.push(A)}})}})});var f=0;r.dataRows.forEach(function(m){f=Math.max(f,m.length)});for(var u=f-r.dataRows[0].length,p=0;p<u;p++){var g=l(p+1);s?(r.dataRows[0].push(g.topLevelColumnTitle),r.dataRows[1].push(g.columnTitle)):r.dataRows[0].push(g)}})});wrap$a(Pointer.prototype,"onContainerMouseDown",function(o){this.chart.hasDraggedAnnotation||o.apply(this,Array.prototype.slice.call(arguments,1))});H.Annotation=Annotation;var chartNavigation={initUpdate:function(o){o.navigation||(o.navigation={updates:[],update:function(r,t){this.updates.forEach(function(n){n.update.call(n.context,r,t)})}})},addUpdate:function(o,r){r.navigation||this.initUpdate(r),r.navigation.updates.push({update:o,context:r})}},format$1=FormatUtilities.format,setOptions$1=DefaultOptions.setOptions,addEvent$s=Utilities.addEvent,attr=Utilities.attr,fireEvent$9=Utilities.fireEvent,isArray$7=Utilities.isArray,isFunction$1=Utilities.isFunction,isNumber$j=Utilities.isNumber,isObject$6=Utilities.isObject,merge$E=Utilities.merge,objectEach$b=Utilities.objectEach,pick$J=Utilities.pick,doc$4=H.doc,win$2=H.win,PREFIX$1="highcharts-";function closestPolyfill(o,r){var t=win$2.Element.prototype,n=t.matches||t.msMatchesSelector||t.webkitMatchesSelector,s=null;if(t.closest)s=t.closest.call(o,r);else do{if(n.call(o,r))return o;o=o.parentElement||o.parentNode}while(o!==null&&o.nodeType===1);return s}var bindingsUtils={getFieldType:function(o){return{string:"text",number:"number",boolean:"checkbox"}[typeof o]},updateRectSize:function(o,r){var t=r.chart,n=r.options.typeOptions,s=isNumber$j(n.xAxis)&&t.xAxis[n.xAxis],a=isNumber$j(n.yAxis)&&t.yAxis[n.yAxis];if(s&&a){var l=s.toValue(o[s.horiz?"chartX":"chartY"]),h=a.toValue(o[a.horiz?"chartX":"chartY"]),d=l-n.point.x,c=n.point.y-h;r.update({typeOptions:{background:{width:t.inverted?c:d,height:t.inverted?d:c}}})}},getAssignedAxis:function(o){return o.filter(function(r){var t=r.axis.min,n=r.axis.max,s=pick$J(r.axis.minPointOffset,0);return isNumber$j(t)&&isNumber$j(n)&&r.value>=t-s&&r.value<=n+s&&!r.axis.options.isInternal})[0]}},NavigationBindings=function(){function o(r,t){this.boundClassNames=void 0,this.selectedButton=void 0,this.chart=r,this.options=t,this.eventsToUnbind=[],this.container=doc$4.getElementsByClassName(this.options.bindingsClassName||"")}return o.prototype.initEvents=function(){var r=this,t=r.chart,n=r.container,s=r.options;r.boundClassNames={},objectEach$b(s.bindings||{},function(a){r.boundClassNames[a.className]=a}),[].forEach.call(n,function(a){r.eventsToUnbind.push(addEvent$s(a,"click",function(l){var h=r.getButtonEvents(a,l);h&&h.button.className.indexOf("highcharts-disabled-btn")===-1&&r.bindingsButtonClick(h.button,h.events,l)}))}),objectEach$b(s.events||{},function(a,l){isFunction$1(a)&&r.eventsToUnbind.push(addEvent$s(r,l,a,{passive:!1}))}),r.eventsToUnbind.push(addEvent$s(t.container,"click",function(a){!t.cancelClick&&t.isInsidePlot(a.chartX-t.plotLeft,a.chartY-t.plotTop,{visiblePlotOnly:!0})&&r.bindingsChartClick(this,a)})),r.eventsToUnbind.push(addEvent$s(t.container,H.isTouchDevice?"touchmove":"mousemove",function(a){r.bindingsContainerMouseMove(this,a)},H.isTouchDevice?{passive:!1}:void 0))},o.prototype.initUpdate=function(){var r=this;chartNavigation.addUpdate(function(t){r.update(t)},this.chart)},o.prototype.bindingsButtonClick=function(r,t,n){var s=this,a=s.chart;s.selectedButtonElement&&(fireEvent$9(s,"deselectButton",{button:s.selectedButtonElement}),s.nextEvent&&(s.currentUserDetails&&s.currentUserDetails.coll==="annotations"&&a.removeAnnotation(s.currentUserDetails),s.mouseMoveEvent=s.nextEvent=!1)),s.selectedButton=t,s.selectedButtonElement=r,fireEvent$9(s,"selectButton",{button:r}),t.init&&t.init.call(s,r,n),(t.start||t.steps)&&a.renderer.boxWrapper.addClass(PREFIX$1+"draw-mode")},o.prototype.bindingsChartClick=function(r,t){r=this.chart;var n=this,s=n.activeAnnotation,a=n.selectedButton,l=r.renderer.boxWrapper;s&&(!s.cancelClick&&!t.activeAnnotation&&t.target.parentNode&&!closestPolyfill(t.target,"."+PREFIX$1+"popup")?fireEvent$9(n,"closePopup"):s.cancelClick&&setTimeout(function(){s.cancelClick=!1},0)),!(!a||!a.start)&&(n.nextEvent?(n.nextEvent(t,n.currentUserDetails),n.steps&&(n.stepIndex++,a.steps[n.stepIndex]?n.mouseMoveEvent=n.nextEvent=a.steps[n.stepIndex]:(fireEvent$9(n,"deselectButton",{button:n.selectedButtonElement}),l.removeClass(PREFIX$1+"draw-mode"),a.end&&a.end.call(n,t,n.currentUserDetails),n.nextEvent=!1,n.mouseMoveEvent=!1,n.selectedButton=null))):(n.currentUserDetails=a.start.call(n,t),n.currentUserDetails&&a.steps?(n.stepIndex=0,n.steps=!0,n.mouseMoveEvent=n.nextEvent=a.steps[n.stepIndex]):(fireEvent$9(n,"deselectButton",{button:n.selectedButtonElement}),l.removeClass(PREFIX$1+"draw-mode"),n.steps=!1,n.selectedButton=null,a.end&&a.end.call(n,t,n.currentUserDetails))))},o.prototype.bindingsContainerMouseMove=function(r,t){this.mouseMoveEvent&&this.mouseMoveEvent(t,this.currentUserDetails)},o.prototype.fieldsToOptions=function(r,t){return objectEach$b(r,function(n,s){var a=parseFloat(n),l=s.split("."),h=t,d=l.length-1;isNumber$j(a)&&!n.match(/px/g)&&!s.match(/format/g)&&(n=a),n!==""&&n!=="undefined"&&l.forEach(function(c,f){var u=pick$J(l[f+1],"");d===f?h[c]=n:(h[c]||(h[c]=u.match(/\d/g)?[]:{}),h=h[c])})}),t},o.prototype.deselectAnnotation=function(){this.activeAnnotation&&(this.activeAnnotation.setControlPointsVisibility(!1),this.activeAnnotation=!1)},o.prototype.annotationToFields=function(r){var t=r.options,n=o.annotationsEditable,s=n.nestedOptions,a=this.utils.getFieldType,l=pick$J(t.type,t.shapes&&t.shapes[0]&&t.shapes[0].type,t.labels&&t.labels[0]&&t.labels[0].itemType,"label"),h=o.annotationsNonEditable[t.langKey]||[],d={langKey:t.langKey,type:l};function c(f,u,p,g){var m;p&&f&&h.indexOf(u)===-1&&((p.indexOf&&p.indexOf(u))>=0||p[u]||p===!0)&&(isArray$7(f)?(g[u]=[],f.forEach(function(v,x){isObject$6(v)?(g[u][x]={},objectEach$b(v,function(y,b){c(y,b,s[u],g[u][x])})):c(v,0,s[u],g[u])})):isObject$6(f)?(m={},isArray$7(g)?(g.push(m),m[u]={},m=m[u]):g[u]=m,objectEach$b(f,function(v,x){c(v,x,u===0?p:s[u],m)})):u==="format"?g[u]=[format$1(f,r.labels[0].points[0]).toString(),"text"]:isArray$7(g)?g.push([f,a(f)]):g[u]=[f,a(f)])}return objectEach$b(t,function(f,u){u==="typeOptions"?(d[u]={},objectEach$b(t[u],function(p,g){c(p,g,s,d[u])})):c(f,u,n[l],d)}),d},o.prototype.getClickedClassNames=function(r,t){for(var n=t.target,s=[],a;n;)if(a=attr(n,"class"),a&&(s=s.concat(a.split(" ").map(function(l){return[l,n]}))),n=n.parentNode,n===r)return s;return s},o.prototype.getButtonEvents=function(r,t){var n=this,s=this.getClickedClassNames(r,t),a;return s.forEach(function(l){n.boundClassNames[l[0]]&&!a&&(a={events:n.boundClassNames[l[0]],button:l[1]})}),a},o.prototype.update=function(r){this.options=merge$E(!0,this.options,r),this.removeEvents(),this.initEvents()},o.prototype.removeEvents=function(){this.eventsToUnbind.forEach(function(r){r()})},o.prototype.destroy=function(){this.removeEvents()},o.annotationsEditable={nestedOptions:{labelOptions:["style","format","backgroundColor"],labels:["style"],label:["style"],style:["fontSize","color"],background:["fill","strokeWidth","stroke"],innerBackground:["fill","strokeWidth","stroke"],outerBackground:["fill","strokeWidth","stroke"],shapeOptions:["fill","strokeWidth","stroke"],shapes:["fill","strokeWidth","stroke"],line:["strokeWidth","stroke"],backgroundColors:[!0],connector:["fill","strokeWidth","stroke"],crosshairX:["strokeWidth","stroke"],crosshairY:["strokeWidth","stroke"]},circle:["shapes"],verticalLine:[],label:["labelOptions"],measure:["background","crosshairY","crosshairX"],fibonacci:[],tunnel:["background","line","height"],pitchfork:["innerBackground","outerBackground"],rect:["shapes"],crookedLine:[],basicAnnotation:["shapes","labelOptions"]},o.annotationsNonEditable={rectangle:["crosshairX","crosshairY","label"]},o}();NavigationBindings.prototype.utils=bindingsUtils;Chart$1.prototype.initNavigationBindings=function(){var o=this,r=o.options;r&&r.navigation&&r.navigation.bindings&&(o.navigationBindings=new NavigationBindings(o,r.navigation),o.navigationBindings.initEvents(),o.navigationBindings.initUpdate())};addEvent$s(Chart$1,"load",function(){this.initNavigationBindings()});addEvent$s(Chart$1,"destroy",function(){this.navigationBindings&&this.navigationBindings.destroy()});addEvent$s(NavigationBindings,"deselectButton",function(){this.selectedButtonElement=null});addEvent$s(Annotation,"remove",function(){this.chart.navigationBindings&&this.chart.navigationBindings.deselectAnnotation()});function selectableAnnotation(o){var r=o.prototype.defaultOptions.events&&o.prototype.defaultOptions.events.click;function t(n){var s=this,a=s.chart.navigationBindings,l=a.activeAnnotation;r&&r.call(s,n),l!==s?(a.deselectAnnotation(),a.activeAnnotation=s,s.setControlPointsVisibility(!0),fireEvent$9(a,"showPopup",{annotation:s,formType:"annotation-toolbar",options:a.annotationToFields(s),onSubmit:function(h){var d={},c;h.actionType==="remove"?(a.activeAnnotation=!1,a.chart.removeAnnotation(s)):(a.fieldsToOptions(h.fields,d),a.deselectAnnotation(),c=d.typeOptions,s.options.type==="measure"&&(c.crosshairY.enabled=c.crosshairY.strokeWidth!==0,c.crosshairX.enabled=c.crosshairX.strokeWidth!==0),s.update(d))}})):fireEvent$9(a,"closePopup"),n.activeAnnotation=!0}merge$E(!0,o.prototype.defaultOptions.events,{click:t})}H.Annotation&&(selectableAnnotation(Annotation),objectEach$b(Annotation.types,function(o){selectableAnnotation(o)}));setOptions$1({lang:{navigation:{popup:{simpleShapes:"Simple shapes",lines:"Lines",circle:"Circle",rectangle:"Rectangle",label:"Label",shapeOptions:"Shape options",typeOptions:"Details",fill:"Fill",format:"Text",strokeWidth:"Line width",stroke:"Line color",title:"Title",name:"Name",labelOptions:"Label options",labels:"Labels",backgroundColor:"Background color",backgroundColors:"Background colors",borderColor:"Border color",borderRadius:"Border radius",borderWidth:"Border width",style:"Style",padding:"Padding",fontSize:"Font size",color:"Color",height:"Height",shapes:"Shape options"}}},navigation:{bindingsClassName:"highcharts-bindings-container",bindings:{circleAnnotation:{className:"highcharts-circle-annotation",start:function(o){var r=this.chart.pointer.getCoordinates(o),t=this.utils.getAssignedAxis(r.xAxis),n=this.utils.getAssignedAxis(r.yAxis),s=this.chart.options.navigation;if(!(!t||!n))return this.chart.addAnnotation(merge$E({langKey:"circle",type:"basicAnnotation",shapes:[{type:"circle",point:{x:t.value,y:n.value,xAxis:t.axis.options.index,yAxis:n.axis.options.index},r:5}]},s.annotationsOptions,s.bindings.circleAnnotation.annotationsOptions))},steps:[function(o,r){var t=r.options.shapes[0].point,n=this.chart.inverted,s,a,l;isNumber$j(t.xAxis)&&isNumber$j(t.yAxis)&&(s=this.chart.xAxis[t.xAxis].toPixels(t.x),a=this.chart.yAxis[t.yAxis].toPixels(t.y),l=Math.max(Math.sqrt(Math.pow(n?a-o.chartX:s-o.chartX,2)+Math.pow(n?s-o.chartY:a-o.chartY,2)),5)),r.update({shapes:[{r:l}]})}]},rectangleAnnotation:{className:"highcharts-rectangle-annotation",start:function(o){var r=this.chart.pointer.getCoordinates(o),t=this.utils.getAssignedAxis(r.xAxis),n=this.utils.getAssignedAxis(r.yAxis);if(!(!t||!n)){var s=t.value,a=n.value,l=t.axis.options.index,h=n.axis.options.index,d=this.chart.options.navigation;return this.chart.addAnnotation(merge$E({langKey:"rectangle",type:"basicAnnotation",shapes:[{type:"path",points:[{xAxis:l,yAxis:h,x:s,y:a},{xAxis:l,yAxis:h,x:s,y:a},{xAxis:l,yAxis:h,x:s,y:a},{xAxis:l,yAxis:h,x:s,y:a}]}]},d.annotationsOptions,d.bindings.rectangleAnnotation.annotationsOptions))}},steps:[function(o,r){var t=r.options.shapes[0].points,n=this.chart.pointer.getCoordinates(o),s=this.utils.getAssignedAxis(n.xAxis),a=this.utils.getAssignedAxis(n.yAxis),l,h;s&&a&&(l=s.value,h=a.value,t[1].x=l,t[2].x=l,t[2].y=h,t[3].y=h,r.update({shapes:[{points:t}]}))}]},labelAnnotation:{className:"highcharts-label-annotation",start:function(o){var r=this.chart.pointer.getCoordinates(o),t=this.utils.getAssignedAxis(r.xAxis),n=this.utils.getAssignedAxis(r.yAxis),s=this.chart.options.navigation;if(!(!t||!n))return this.chart.addAnnotation(merge$E({langKey:"label",type:"basicAnnotation",labelOptions:{format:"{y:.2f}"},labels:[{point:{xAxis:t.axis.options.index,yAxis:n.axis.options.index,x:t.value,y:n.value},overflow:"none",crop:!0}]},s.annotationsOptions,s.bindings.labelAnnotation.annotationsOptions))}}},events:{},annotationsOptions:{animation:{defer:0}}}});addEvent$s(Chart$1,"render",function(){var o=this,r=o.navigationBindings,t="highcharts-disabled-btn";if(o&&r){var n=!1;o.series.forEach(function(s){!s.options.isInternal&&s.visible&&(n=!0)}),objectEach$b(r.boundClassNames,function(s,a){if(o.navigationBindings&&o.navigationBindings.container&&o.navigationBindings.container[0]){var l=o.navigationBindings.container[0].querySelectorAll("."+a);if(l)for(var h=0;h<l.length;h++){var d=l[h];s.noDataState==="normal"||n?d.className.indexOf(t)!==-1&&d.classList.remove(t):d.className.indexOf(t)===-1&&(d.className+=" "+t)}}})}});addEvent$s(NavigationBindings,"closePopup",function(){this.deselectAnnotation()});var doc$3=H.doc,isFirefox=H.isFirefox,getOptions$1=DefaultOptions.getOptions,addEvent$r=Utilities.addEvent,createElement$2=Utilities.createElement,defined$i=Utilities.defined,fireEvent$8=Utilities.fireEvent,isArray$6=Utilities.isArray,isObject$5=Utilities.isObject,isString$1=Utilities.isString,objectEach$a=Utilities.objectEach,pick$I=Utilities.pick,stableSort$3=Utilities.stableSort,wrap$9=Utilities.wrap,indexFilter=/\d/g,PREFIX="highcharts-",DIV="div",INPUT="input",LABEL="label",BUTTON="button",SELECT="select",OPTION="option",SPAN="span",UL="ul",LI="li",H3="h3";wrap$9(Pointer.prototype,"onContainerMouseDown",function(o,r){var t=r.target&&r.target.className;isString$1(t)&&t.indexOf(PREFIX+"popup-field")>=0||o.apply(this,Array.prototype.slice.call(arguments,1))});H.Popup=function(o,r,t){this.init(o,r,t)};H.Popup.prototype={init:function(o,r,t){this.chart=t,this.container=createElement$2(DIV,{className:PREFIX+"popup highcharts-no-tooltip"},null,o),this.lang=this.getLangpack(),this.iconsURL=r,this.addCloseBtn()},addCloseBtn:function(){var o=this,r,t=this.iconsURL;r=createElement$2(DIV,{className:PREFIX+"popup-close"},null,this.container),r.style["background-image"]="url("+(t.match(/png|svg|jpeg|jpg|gif/ig)?t:t+"close.svg")+")",["click","touchstart"].forEach(function(n){addEvent$r(r,n,function(){o.chart?fireEvent$8(o.chart.navigationBindings,"closePopup"):o.closePopup()})})},addColsContainer:function(o){var r,t;return t=createElement$2(DIV,{className:PREFIX+"popup-lhs-col"},null,o),r=createElement$2(DIV,{className:PREFIX+"popup-rhs-col"},null,o),createElement$2(DIV,{className:PREFIX+"popup-rhs-col-wrapper"},null,r),{lhsCol:t,rhsCol:r}},addInput:function(o,r,t,n){var s=o.split("."),a=s[s.length-1],l=this.lang,h=PREFIX+r+"-"+a;h.match(indexFilter)||createElement$2(LABEL,{htmlFor:h},void 0,t).appendChild(doc$3.createTextNode(l[a]||a)),n!==""&&createElement$2(INPUT,{name:h,value:n[0],type:n[1],className:PREFIX+"popup-field"},void 0,t).setAttribute(PREFIX+"data-name",o)},addButton:function(o,r,t,n,s){var a=this,l=this.closePopup,h=this.getFields,d;return d=createElement$2(BUTTON,void 0,void 0,o),d.appendChild(doc$3.createTextNode(r)),["click","touchstart"].forEach(function(c){addEvent$r(d,c,function(){return l.call(a),n(h(s,t))})}),d},getFields:function(o,r){var t=o.querySelectorAll("input"),n="#"+PREFIX+"select-series > option:checked",s="#"+PREFIX+"select-volume > option:checked",a=o.querySelectorAll(n)[0],l=o.querySelectorAll(s)[0],h,d,c;return c={actionType:r,linkedTo:a&&a.getAttribute("value"),fields:{}},[].forEach.call(t,function(f){d=f.getAttribute(PREFIX+"data-name"),h=f.getAttribute(PREFIX+"data-series-id"),h?c.seriesId=f.value:d?c.fields[d]=f.value:c.type=f.value}),l&&(c.fields["params.volumeSeriesID"]=l.getAttribute("value")),c},showPopup:function(){var o=this.container,r=PREFIX+"annotation-toolbar",t=o.querySelectorAll("."+PREFIX+"popup-close")[0];this.formType=void 0,o.innerHTML="",o.className.indexOf(r)>=0&&(o.classList.remove(r),o.removeAttribute("style")),o.appendChild(t),o.style.display="block",o.style.height=""},closePopup:function(){var o=pick$I(this.popup&&this.popup.container,this.container);o.style.display="none"},showForm:function(o,r,t,n){r&&(this.popup=r.navigationBindings.popup,this.showPopup(),o==="indicators"&&this.indicators.addForm.call(this,r,t,n),o==="annotation-toolbar"&&this.annotations.addToolbar.call(this,r,t,n),o==="annotation-edit"&&this.annotations.addForm.call(this,r,t,n),o==="flag"&&this.annotations.addForm.call(this,r,t,n,!0),this.formType=o,this.container.style.height=this.container.offsetHeight+"px")},getLangpack:function(){return getOptions$1().lang.navigation.popup},annotations:{addToolbar:function(o,r,t){var n=this,s=this.lang,a=this.popup.container,l=this.showForm,h=PREFIX+"annotation-toolbar",d;a.className.indexOf(h)===-1&&(a.className+=" "+h),o&&(a.style.top=o.plotTop+10+"px"),createElement$2(SPAN,void 0,void 0,a).appendChild(doc$3.createTextNode(pick$I(s[r.langKey]||r.langKey,r.shapes&&r.shapes[0].type))),d=this.addButton(a,s.removeButton||"remove","remove",t,a),d.className+=" "+PREFIX+"annotation-remove-button",d.style["background-image"]="url("+this.iconsURL+"destroy.svg)",d=this.addButton(a,s.editButton||"edit","edit",function(){l.call(n,"annotation-edit",o,r,t)},a),d.className+=" "+PREFIX+"annotation-edit-button",d.style["background-image"]="url("+this.iconsURL+"edit.svg)"},addForm:function(o,r,t,n){var s=this.popup.container,a=this.lang,l,h;o&&(h=createElement$2("h2",{className:PREFIX+"popup-main-title"},void 0,s),h.appendChild(doc$3.createTextNode(a[r.langKey]||r.langKey||"")),h=createElement$2(DIV,{className:PREFIX+"popup-lhs-col "+PREFIX+"popup-lhs-full"},null,s),l=createElement$2(DIV,{className:PREFIX+"popup-bottom-row"},null,s),this.annotations.addFormFields.call(this,h,o,"",r,[],!0),this.addButton(l,n?a.addButton||"add":a.saveButton||"save",n?"add":"save",t,s))},addFormFields:function(o,r,t,n,s,a){var l=this,h=this.annotations.addFormFields,d=this.addInput,c=this.lang,f,u;r&&(objectEach$a(n,function(p,g){f=t!==""?t+"."+g:g,isObject$5(p)&&(!isArray$6(p)||isArray$6(p)&&isObject$5(p[0])?(u=c[g]||g,u.match(indexFilter)||s.push([!0,u,o]),h.call(l,o,r,f,p,s,!1)):s.push([l,f,"annotation",o,p]))}),a&&(stableSort$3(s,function(p){return p[1].match(/format/g)?-1:1}),isFirefox&&s.reverse(),s.forEach(function(p){p[0]===!0?createElement$2(SPAN,{className:PREFIX+"annotation-title"},void 0,p[2]).appendChild(doc$3.createTextNode(p[1])):d.apply(p[0],p.splice(1))})))}},indicators:{addForm:function(o,r,t){var n,s=this.indicators,a=this.lang,l;o&&(this.tabs.init.call(this,o),n=this.popup.container.querySelectorAll("."+PREFIX+"tab-item-content"),this.addColsContainer(n[0]),s.addIndicatorList.call(this,o,n[0],"add"),l=n[0].querySelectorAll("."+PREFIX+"popup-rhs-col")[0],this.addButton(l,a.addButton||"add","add",t,l),this.addColsContainer(n[1]),s.addIndicatorList.call(this,o,n[1],"edit"),l=n[1].querySelectorAll("."+PREFIX+"popup-rhs-col")[0],this.addButton(l,a.saveButton||"save","edit",t,l),this.addButton(l,a.removeButton||"remove","remove",t,l))},addIndicatorList:function(o,r,t){var n=this,s=r.querySelectorAll("."+PREFIX+"popup-lhs-col")[0],a=r.querySelectorAll("."+PREFIX+"popup-rhs-col")[0],l=t==="edit",h=l?o.series:o.options.plotOptions,d=this.indicators.addFormFields,c,f,u;o&&(f=createElement$2(UL,{className:PREFIX+"indicator-list"},null,s),c=a.querySelectorAll("."+PREFIX+"popup-rhs-col-wrapper")[0],objectEach$a(h,function(p,g){var m=p.options;if(p.params||m&&m.params){var v=n.indicators.getNameType(p,g),x=v.type;u=createElement$2(LI,{className:PREFIX+"indicator-list"},void 0,f),u.appendChild(doc$3.createTextNode(v.name)),["click","touchstart"].forEach(function(y){addEvent$r(u,y,function(){d.call(n,o,l?p:h[x],v.type,c),l&&p.options&&createElement$2(INPUT,{type:"hidden",name:PREFIX+"id-"+x,value:p.options.id},null,c).setAttribute(PREFIX+"data-series-id",p.options.id)})})}}),f.childNodes.length>0&&f.childNodes[0].click())},getNameType:function(o,r){var t=o.options,n=H.seriesTypes,s=n[r]&&n[r].prototype.nameBase||r.toUpperCase(),a=r;return t&&t.type&&(a=o.options.type,s=o.name),{name:s,type:a}},listAllSeries:function(o,r,t,n,s){var a=PREFIX+r+"-type-"+o,l=this.lang,h,d;t&&(createElement$2(LABEL,{htmlFor:a},null,n).appendChild(doc$3.createTextNode(l[r]||r)),h=createElement$2(SELECT,{name:a,className:PREFIX+"popup-field"},null,n),h.setAttribute("id",PREFIX+"select-"+r),t.series.forEach(function(c){d=c.options,!d.params&&d.id&&d.id!==PREFIX+"navigator-series"&&createElement$2(OPTION,{value:d.id},null,h).appendChild(doc$3.createTextNode(d.name||d.id))}),defined$i(s)&&(h.value=s))},addFormFields:function(o,r,t,n){var s=r.params||r.options.params,a=this.indicators.getNameType;n.innerHTML="",createElement$2(H3,{className:PREFIX+"indicator-title"},void 0,n).appendChild(doc$3.createTextNode(a(r,t).name)),createElement$2(INPUT,{type:"hidden",name:PREFIX+"type-"+t,value:t},null,n),this.indicators.listAllSeries.call(this,t,"series",o,n,r.linkedParent&&s.volumeSeriesID),s.volumeSeriesID&&this.indicators.listAllSeries.call(this,t,"volume",o,n,r.linkedParent&&r.linkedParent.options.id),this.indicators.addParamInputs.call(this,o,"params",s,t,n)},addParamInputs:function(o,r,t,n,s){var a=this,l=this.indicators.addParamInputs,h=this.addInput,d;o&&objectEach$a(t,function(c,f){d=r+"."+f,c!==void 0&&(isObject$5(c)?(h.call(a,d,n,s,""),l.call(a,o,d,c,n,s)):d!=="params.volumeSeriesID"&&h.call(a,d,n,s,[c,"text"]))})},getAmount:function(){var o=this.series,r=0;return o.forEach(function(t){var n=t.options;(t.params||n&&n.params)&&r++}),r}},tabs:{init:function(o){var r=this.tabs,t=this.indicators.getAmount.call(o),n;o&&(n=r.addMenuItem.call(this,"add"),r.addMenuItem.call(this,"edit",t),r.addContentItem.call(this,"add"),r.addContentItem.call(this,"edit"),r.switchTabs.call(this,t),r.selectTab.call(this,n,0))},addMenuItem:function(o,r){var t=this.popup.container,n=PREFIX+"tab-item",s=this.lang,a;return r===0&&(n+=" "+PREFIX+"tab-disabled"),a=createElement$2(SPAN,{className:n},void 0,t),a.appendChild(doc$3.createTextNode(s[o+"Button"]||o)),a.setAttribute(PREFIX+"data-tab-type",o),a},addContentItem:function(){var o=this.popup.container;return createElement$2(DIV,{className:PREFIX+"tab-item-content "+PREFIX+"no-mousewheel"},null,o)},switchTabs:function(o){var r=this,t=this.popup.container,n=t.querySelectorAll("."+PREFIX+"tab-item"),s;n.forEach(function(a,l){s=a.getAttribute(PREFIX+"data-tab-type"),!(s==="edit"&&o===0)&&["click","touchstart"].forEach(function(h){addEvent$r(a,h,function(){r.tabs.deselectAll.call(r),r.tabs.selectTab.call(r,this,l)})})})},selectTab:function(o,r){var t=this.popup.container.querySelectorAll("."+PREFIX+"tab-item-content");o.className+=" "+PREFIX+"tab-item-active",t[r].className+=" "+PREFIX+"tab-item-show"},deselectAll:function(){var o=this.popup.container,r=o.querySelectorAll("."+PREFIX+"tab-item"),t=o.querySelectorAll("."+PREFIX+"tab-item-content"),n;for(n=0;n<r.length;n++)r[n].classList.remove(PREFIX+"tab-item-active"),t[n].classList.remove(PREFIX+"tab-item-show")}}};addEvent$r(NavigationBindings,"showPopup",function(o){this.popup||(this.popup=new H.Popup(this.chart.container,this.chart.options.navigation.iconsURL||this.chart.options.stockTools&&this.chart.options.stockTools.gui.iconsURL||"https://code.highcharts.com/9.2.2/gfx/stock-icons/",this.chart)),this.popup.showForm(o.formType,this.chart,o.options,o.onSubmit)});addEvent$r(NavigationBindings,"closePopup",function(){this.popup&&this.popup.closePopup()});H.Popup;var addEvent$q=Utilities.addEvent,extend$H=Utilities.extend,merge$D=Utilities.merge,pick$H=Utilities.pick,splat$4=Utilities.splat;Chart$1.prototype.collectionsWithUpdate.push("pane");var Pane=function(){function o(r,t){this.background=void 0,this.center=void 0,this.chart=void 0,this.options=void 0,this.coll="pane",this.defaultOptions={center:["50%","50%"],size:"85%",innerSize:"0%",startAngle:0},this.defaultBackgroundOptions={shape:"circle",borderWidth:1,borderColor:palette.neutralColor20,backgroundColor:{linearGradient:{x1:0,y1:0,x2:0,y2:1},stops:[[0,palette.backgroundColor],[1,palette.neutralColor10]]},from:-Number.MAX_VALUE,innerRadius:0,to:Number.MAX_VALUE,outerRadius:"105%"},this.init(r,t)}return o.prototype.init=function(r,t){this.chart=t,this.background=[],t.pane.push(this),this.setOptions(r)},o.prototype.setOptions=function(r){this.options=r=merge$D(this.defaultOptions,this.chart.angular?{background:{}}:void 0,r)},o.prototype.render=function(){var r=this.options,t=this.options.background,n=this.chart.renderer,s,a;if(this.group||(this.group=n.g("pane-group").attr({zIndex:r.zIndex||0}).add()),this.updateCenter(),t)for(t=splat$4(t),s=Math.max(t.length,this.background.length||0),a=0;a<s;a++)t[a]&&this.axis?this.renderBackground(merge$D(this.defaultBackgroundOptions,t[a]),a):this.background[a]&&(this.background[a]=this.background[a].destroy(),this.background.splice(a,1))},o.prototype.renderBackground=function(r,t){var n="animate",s={class:"highcharts-pane "+(r.className||"")};this.chart.styledMode||extend$H(s,{fill:r.backgroundColor,stroke:r.borderColor,"stroke-width":r.borderWidth}),this.background[t]||(this.background[t]=this.chart.renderer.path().add(this.group),n="attr"),this.background[t][n]({d:this.axis.getPlotBandPath(r.from,r.to,r)}).attr(s)},o.prototype.updateCenter=function(r){this.center=(r||this.axis||{}).center=centeredSeriesMixin.getCenter.call(this)},o.prototype.update=function(r,t){merge$D(!0,this.options,r),this.setOptions(this.options),this.render(),this.chart.axes.forEach(function(n){n.pane===this&&(n.pane=null,n.update({},t))},this)},o}();function isInsidePane(o,r,t){return Math.sqrt(Math.pow(o-t[0],2)+Math.pow(r-t[1],2))<=t[2]/2}Chart$1.prototype.getHoverPane=function(o){var r=this,t;return o&&r.pane.forEach(function(n){var s=o.chartX-r.plotLeft,a=o.chartY-r.plotTop,l=r.inverted?a:s,h=r.inverted?s:a;isInsidePane(l,h,n.center)&&(t=n)}),t};addEvent$q(Chart$1,"afterIsInsidePlot",function(o){var r=this;r.polar&&(o.isInsidePlot=r.pane.some(function(t){return isInsidePane(o.x,o.y,t.center)}))});addEvent$q(Pointer,"beforeGetHoverData",function(o){var r=this.chart;r.polar?(r.hoverPane=r.getHoverPane(o),o.filter=function(t){return t.visible&&!(!o.shared&&t.directTouch)&&pick$H(t.options.enableMouseTracking,!0)&&(!r.hoverPane||t.xAxis.pane===r.hoverPane)}):r.hoverPane=void 0});addEvent$q(Pointer,"afterGetHoverData",function(o){var r=this.chart;o.hoverPoint&&o.hoverPoint.plotX&&o.hoverPoint.plotY&&r.hoverPane&&!isInsidePane(o.hoverPoint.plotX,o.hoverPoint.plotY,r.hoverPane.center)&&(o.hoverPoint=void 0)});H.Pane=Pane;const Pane$1=H.Pane;var defaultOptions$3=DefaultOptions.defaultOptions,noop$c=H.noop,addEvent$p=Utilities.addEvent,correctFloat$3=Utilities.correctFloat,defined$h=Utilities.defined,extend$G=Utilities.extend,fireEvent$7=Utilities.fireEvent,merge$C=Utilities.merge,pick$G=Utilities.pick,relativeLength$2=Utilities.relativeLength,wrap$8=Utilities.wrap,RadialAxis;(function(o){var r=[],t={gridLineWidth:1,labels:{align:void 0,distance:15,x:0,y:void 0,style:{textOverflow:"none"}},maxPadding:0,minPadding:0,showLastLabel:!1,tickLength:0},n={labels:{align:"center",x:0,y:void 0},minorGridLineWidth:0,minorTickInterval:"auto",minorTickLength:10,minorTickPosition:"inside",minorTickWidth:1,tickLength:10,tickPosition:"inside",tickWidth:2,title:{rotation:0},zIndex:2},s={gridLineInterpolation:"circle",gridLineWidth:1,labels:{align:"right",x:-3,y:-2},showLastLabel:!1,title:{x:4,text:null,rotation:90}};function a(){this.autoConnect=this.isCircular&&typeof pick$G(this.userMax,this.options.max)>"u"&&correctFloat$3(this.endAngleRad-this.startAngleRad)===correctFloat$3(2*Math.PI),!this.isCircular&&this.chart.inverted&&this.max++,this.autoConnect&&(this.max+=this.categories&&1||this.pointRange||this.closestPointRange||0)}function l(D,N){return r.indexOf(D)===-1&&(r.push(D),addEvent$p(D,"afterInit",b),addEvent$p(D,"autoLabelAlign",$),addEvent$p(D,"destroy",S),addEvent$p(D,"init",k),addEvent$p(D,"initialAxisTranslation",A)),r.indexOf(N)===-1&&(r.push(N),addEvent$p(N,"afterGetLabelPosition",P),addEvent$p(N,"afterGetPosition",E),wrap$8(N.prototype,"getMarkPath",_)),D}o.compose=l;function h(){var D=this;return function(){if(D.isRadial&&D.tickPositions&&D.options.labels&&D.options.labels.allowOverlap!==!0)return D.tickPositions.map(function(N){return D.ticks[N]&&D.ticks[N].label}).filter(function(N){return!!N})}}function d(){return noop$c}function c(D,N,I){var B=this.pane.center,X=D.value,W,F,U,z;return this.isCircular?(defined$h(X)?D.point&&(W=D.point.shapeArgs||{},W.start&&(X=this.chart.inverted?this.translate(D.point.rectPlotY,!0):D.point.x)):(U=D.chartX||0,z=D.chartY||0,X=this.translate(Math.atan2(z-I,U-N)-this.startAngleRad,!0)),F=this.getPosition(X),U=F.x,z=F.y):(defined$h(X)||(U=D.chartX,z=D.chartY),defined$h(U)&&defined$h(z)&&(I=B[1]+this.chart.plotTop,X=this.translate(Math.min(Math.sqrt(Math.pow(U-N,2)+Math.pow(z-I,2)),B[2]/2)-B[3]/2,!0))),[X,U||0,z||0]}function f(D,N,I){var B=this.pane.center,X=this.chart,W=this.left||0,F=this.top||0,U,z=pick$G(N,B[2]/2-this.offset),V;return typeof I>"u"&&(I=this.horiz?0:this.center&&-this.center[3]/2),I&&(z+=I),this.isCircular||typeof N<"u"?(V=this.chart.renderer.symbols.arc(W+B[0],F+B[1],z,z,{start:this.startAngleRad,end:this.endAngleRad,open:!0,innerR:0}),V.xBounds=[W+B[0]],V.yBounds=[F+B[1]-z]):(U=this.postTranslate(this.angleRad,z),V=[["M",this.center[0]+X.plotLeft,this.center[1]+X.plotTop],["L",U.x,U.y]]),V}function u(){var D=this.constructor.prototype;D.getOffset.call(this),this.chart.axisOffset[this.side]=0}function p(D,N,I){var B=this.chart,X=function(at){if(typeof at=="string"){var lt=parseInt(at,10);return K.test(at)&&(lt=lt*U/100),lt}return at},W=this.center,F=this.startAngleRad,U=W[2]/2,z=Math.min(this.offset,0),V=this.left||0,j=this.top||0,K=/%$/,nt=this.isCircular,q,J,Y,Z,et,Q,tt=pick$G(X(I.outerRadius),U),rt=X(I.innerRadius),it=pick$G(X(I.thickness),10);if(this.options.gridLineInterpolation==="polygon")Q=this.getPlotLinePath({value:D}).concat(this.getPlotLinePath({value:N,reverse:!0}));else{D=Math.max(D,this.min),N=Math.min(N,this.max);var ot=this.translate(D),st=this.translate(N);nt||(tt=ot||0,rt=st||0),I.shape==="circle"||!nt?(q=-Math.PI/2,J=Math.PI*1.5,et=!0):(q=F+(ot||0),J=F+(st||0)),tt-=z,it-=z,Q=B.renderer.symbols.arc(V+W[0],j+W[1],tt,tt,{start:Math.min(q,J),end:Math.max(q,J),innerR:pick$G(rt,tt-it),open:et}),nt&&(Y=(J+q)/2,Z=V+W[0]+W[2]/2*Math.cos(Y),Q.xBounds=Y>-Math.PI/2&&Y<Math.PI/2?[Z,B.plotWidth]:[0,Z],Q.yBounds=[j+W[1]+W[2]/2*Math.sin(Y)],Q.yBounds[0]+=Y>-Math.PI&&Y<0||Y>Math.PI?-10:10)}return Q}function g(D){var N=this,I=this.pane.center,B=this.chart,X=B.inverted,W=D.reverse,F=this.pane.options.background?this.pane.options.background[0]||this.pane.options.background:{},U=F.innerRadius||"0%",z=F.outerRadius||"100%",V=I[0]+B.plotLeft,j=I[1]+B.plotTop,K=this.height,nt=D.isCrosshair,q=I[3]/2,J=D.value,Y,Z,et,Q,tt,rt,it,ot,st,at=this.getPosition(J),lt=at.x,ht=at.y;if(nt&&(ot=this.getCrosshairPosition(D,V,j),J=ot[0],lt=ot[1],ht=ot[2]),this.isCircular)Z=Math.sqrt(Math.pow(lt-V,2)+Math.pow(ht-j,2)),et=typeof U=="string"?relativeLength$2(U,1):U/Z,Q=typeof z=="string"?relativeLength$2(z,1):z/Z,I&&q&&(Y=q/Z,et<Y&&(et=Y),Q<Y&&(Q=Y)),st=[["M",V+et*(lt-V),j-et*(j-ht)],["L",lt-(1-Q)*(lt-V),ht+(1-Q)*(j-ht)]];else if(J=this.translate(J),J&&(J<0||J>K)&&(J=0),this.options.gridLineInterpolation==="circle")st=this.getLinePath(0,J,q);else if(st=[],B[X?"yAxis":"xAxis"].forEach(function(ct){ct.pane===N.pane&&(tt=ct)}),tt){it=tt.tickPositions,tt.autoConnect&&(it=it.concat([it[0]])),W&&(it=it.slice().reverse()),J&&(J+=q);for(var dt=0;dt<it.length;dt++)rt=tt.getPosition(it[dt],J),st.push(dt?["L",rt.x,rt.y]:["M",rt.x,rt.y])}return st}function m(D,N){var I=this.translate(D);return this.postTranslate(this.isCircular?I:this.angleRad,pick$G(this.isCircular?N:I<0?0:I,this.center[2]/2)-this.offset)}function v(){var D=this.center,N=this.chart,I=this.options.title;return{x:N.plotLeft+D[0]+(I.x||0),y:N.plotTop+D[1]-{high:.5,middle:.25,low:0}[I.align]*D[2]+(I.y||0)}}function x(D){D.beforeSetTickPositions=a,D.createLabelCollector=h,D.getCrosshairPosition=c,D.getLinePath=f,D.getOffset=u,D.getPlotBandPath=p,D.getPlotLinePath=g,D.getPosition=m,D.getTitlePosition=v,D.postTranslate=M,D.setAxisSize=O,D.setAxisTranslation=L,D.setOptions=T}function y(D){D.isHidden=!0,D.createLabelCollector=d,D.getOffset=noop$c,D.redraw=C,D.render=C,D.setScale=noop$c,D.setCategories=noop$c,D.setTitle=noop$c}function b(){var D=this.chart,N=this.options,I=D.angular&&this.isXAxis,B=this.pane,X=B&&B.options;!I&&B&&(D.angular||D.polar)&&(this.angleRad=(N.angle||0)*Math.PI/180,this.startAngleRad=(X.startAngle-90)*Math.PI/180,this.endAngleRad=(pick$G(X.endAngle,X.startAngle+360)-90)*Math.PI/180,this.offset=N.offset||0)}function $(D){this.isRadial&&(D.align=void 0,D.preventDefault())}function S(){if(this.chart&&this.chart.labelCollectors){var D=this.labelCollector?this.chart.labelCollectors.indexOf(this.labelCollector):-1;D>=0&&this.chart.labelCollectors.splice(D,1)}}function k(D){var N=this.chart,I=N.inverted,B=N.angular,X=N.polar,W=this.isXAxis,F=this.coll,U=B&&W,z=N.options,V=D.userOptions.pane||0,j=this.pane=N.pane&&N.pane[V],K;if(F==="colorAxis"){this.isRadial=!1;return}B?(U?y(this):x(this),K=!W,K&&(this.defaultPolarOptions=n)):X&&(x(this),K=this.horiz,this.defaultPolarOptions=K?t:merge$C(F==="xAxis"?AxisDefaults$1.defaultXAxisOptions:AxisDefaults$1.defaultYAxisOptions,s),I&&F==="yAxis"&&(this.defaultPolarOptions.stackLabels=AxisDefaults$1.defaultYAxisOptions.stackLabels,this.defaultPolarOptions.reversedStacks=!0)),B||X?(this.isRadial=!0,z.chart.zoomType=null,this.labelCollector||(this.labelCollector=this.createLabelCollector()),this.labelCollector&&N.labelCollectors.push(this.labelCollector)):this.isRadial=!1,j&&K&&(j.axis=this),this.isCircular=K}function A(){this.isRadial&&this.beforeSetTickPositions()}function P(D){var N=this.label;if(N){var I=this.axis,B=N.getBBox(),X=I.options.labels,W=(I.translate(this.pos)+I.startAngleRad+Math.PI/2)/Math.PI*180%360,F=Math.round(W),U=defined$h(X.y)?0:-B.height*.3,z=X.y,V,j=20,K=X.align,nt="end",q=F<0?F+360:F,J=q,Y=0,Z=0;I.isRadial&&(V=I.getPosition(this.pos,I.center[2]/2+relativeLength$2(pick$G(X.distance,-25),I.center[2]/2,-I.center[2]/2)),X.rotation==="auto"?N.attr({rotation:W}):defined$h(z)||(z=I.chart.renderer.fontMetrics(N.styles&&N.styles.fontSize).b-B.height/2),defined$h(K)||(I.isCircular?(B.width>I.len*I.tickInterval/(I.max-I.min)&&(j=0),W>j&&W<180-j?K="left":W>180+j&&W<360-j?K="right":K="center"):K="center",N.attr({align:K})),K==="auto"&&I.tickPositions.length===2&&I.isCircular&&(q>90&&q<180?q=180-q:q>270&&q<=360&&(q=540-q),J>180&&J<=360&&(J=360-J),(I.pane.options.startAngle===F||I.pane.options.startAngle===F+360||I.pane.options.startAngle===F-360)&&(nt="start"),F>=-90&&F<=90||F>=-360&&F<=-270||F>=270&&F<=360?K=nt==="start"?"right":"left":K=nt==="start"?"left":"right",J>70&&J<110&&(K="center"),q<15||q>=180&&q<195?Y=B.height*.3:q>=15&&q<=35?Y=nt==="start"?0:B.height*.75:q>=195&&q<=215?Y=nt==="start"?B.height*.75:0:q>35&&q<=90?Y=nt==="start"?-B.height*.25:B.height:q>215&&q<=270&&(Y=nt==="start"?B.height:-B.height*.25),J<15?Z=nt==="start"?-B.height*.15:B.height*.15:J>165&&J<=180&&(Z=nt==="start"?B.height*.15:-B.height*.15),N.attr({align:K}),N.translate(Z,Y+U)),D.pos.x=V.x+(X.x||0),D.pos.y=V.y+(z||0))}}function E(D){this.axis.getPosition&&extend$G(D.pos,this.axis.getPosition(this.pos))}function M(D,N){var I=this.chart,B=this.center;return D=this.startAngleRad+D,{x:I.plotLeft+B[0]+Math.cos(D)*N,y:I.plotTop+B[1]+Math.sin(D)*N}}function C(){this.isDirty=!1}function O(){var D=this.constructor.prototype,N,I;D.setAxisSize.call(this),this.isRadial&&(this.pane.updateCenter(this),N=this.center=this.pane.center.slice(),this.isCircular?this.sector=this.endAngleRad-this.startAngleRad:(I=this.postTranslate(this.angleRad,N[3]/2),N[0]=I.x-this.chart.plotLeft,N[1]=I.y-this.chart.plotTop),this.len=this.width=this.height=(N[2]-N[3])*pick$G(this.sector,1)/2)}function L(){var D=this.constructor.prototype;D.setAxisTranslation.call(this),this.center&&(this.isCircular?this.transA=(this.endAngleRad-this.startAngleRad)/(this.max-this.min||1):this.transA=(this.center[2]-this.center[3])/2/(this.max-this.min||1),this.isXAxis?this.minPixelPadding=this.transA*this.minPointOffset:this.minPixelPadding=0)}function T(D){var N=this.options=merge$C(this.constructor.defaultOptions,this.defaultPolarOptions,defaultOptions$3[this.coll],D);N.plotBands||(N.plotBands=[]),fireEvent$7(this,"afterSetOptions")}function _(D,N,I,B,X,W,F){var U=this.axis,z,V;return U.isRadial?(z=U.getPosition(this.pos,U.center[2]/2+B),V=["M",N,I,"L",z.x,z.y]):V=D.call(this,N,I,B,X,W,F),V}})(RadialAxis||(RadialAxis={}));const RadialAxis$1=RadialAxis;var __extends$F=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),pointProto=Point$2.prototype,defined$g=Utilities.defined,isNumber$i=Utilities.isNumber,AreaRangePoint$1=function(o){__extends$F(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.high=void 0,t.low=void 0,t.options=void 0,t.plotHigh=void 0,t.plotLow=void 0,t.plotHighX=void 0,t.plotLowX=void 0,t.plotX=void 0,t.series=void 0,t}return r.prototype.setState=function(){var t=this.state,n=this.series,s=n.chart.polar;defined$g(this.plotHigh)||(this.plotHigh=n.yAxis.toPixels(this.high,!0)),defined$g(this.plotLow)||(this.plotLow=this.plotY=n.yAxis.toPixels(this.low,!0)),n.stateMarkerGraphic&&(n.lowerStateMarkerGraphic=n.stateMarkerGraphic,n.stateMarkerGraphic=n.upperStateMarkerGraphic),this.graphic=this.upperGraphic,this.plotY=this.plotHigh,s&&(this.plotX=this.plotHighX),pointProto.setState.apply(this,arguments),this.state=t,this.plotY=this.plotLow,this.graphic=this.lowerGraphic,s&&(this.plotX=this.plotLowX),n.stateMarkerGraphic&&(n.upperStateMarkerGraphic=n.stateMarkerGraphic,n.stateMarkerGraphic=n.lowerStateMarkerGraphic,n.lowerStateMarkerGraphic=void 0),pointProto.setState.apply(this,arguments)},r.prototype.haloPath=function(){var t=this.series.chart.polar,n=[];return this.plotY=this.plotLow,t&&(this.plotX=this.plotLowX),this.isInside&&(n=pointProto.haloPath.apply(this,arguments)),this.plotY=this.plotHigh,t&&(this.plotX=this.plotHighX),this.isTopInside&&(n=n.concat(pointProto.haloPath.apply(this,arguments))),n},r.prototype.isValid=function(){return isNumber$i(this.low)&&isNumber$i(this.high)},r}(AreaSeries$1.prototype.pointClass),__extends$E=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),areaProto=AreaSeries$1.prototype,columnProto$4=ColumnSeries$h.prototype,noop$b=H.noop,seriesProto$1=Series$e.prototype,defined$f=Utilities.defined,extend$F=Utilities.extend,isArray$5=Utilities.isArray,pick$F=Utilities.pick,merge$B=Utilities.merge,AreaRangeSeries$2=function(o){__extends$E(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t.lowerStateMarkerGraphic=void 0,t.xAxis=void 0,t}return r.prototype.toYData=function(t){return[t.low,t.high]},r.prototype.highToXY=function(t){var n=this.chart,s=this.xAxis.postTranslate(t.rectPlotX||0,this.yAxis.len-t.plotHigh);t.plotHighX=s.x-n.plotLeft,t.plotHigh=s.y-n.plotTop,t.plotLowX=t.plotX},r.prototype.translate=function(){var t=this,n=t.yAxis,s=!!t.modifyValue;areaProto.translate.apply(t),t.points.forEach(function(a){var l=a.high,h=a.plotY;a.isNull?a.plotY=null:(a.plotLow=h,a.plotHigh=n.translate(s?t.modifyValue(l,a):l,0,1,0,1),s&&(a.yBottom=a.plotHigh))}),this.chart.polar&&this.points.forEach(function(a){t.highToXY(a),a.tooltipPos=[(a.plotHighX+a.plotLowX)/2,(a.plotHigh+a.plotLow)/2]})},r.prototype.getGraphPath=function(t){var n=[],s=[],a,l=areaProto.getGraphPath,h,d,c,f,u=this.options,p=this.chart.polar,g=p&&u.connectEnds!==!1,m=u.connectNulls,v=u.step,x,y;for(t=t||this.points,a=t.length;a--;){h=t[a];var b=p?{plotX:h.rectPlotX,plotY:h.yBottom,doCurve:!1}:{plotX:h.plotX,plotY:h.plotY,doCurve:!1};!h.isNull&&!g&&!m&&(!t[a+1]||t[a+1].isNull)&&s.push(b),d={polarPlotY:h.polarPlotY,rectPlotX:h.rectPlotX,yBottom:h.yBottom,plotX:pick$F(h.plotHighX,h.plotX),plotY:h.plotHigh,isNull:h.isNull},s.push(d),n.push(d),!h.isNull&&!g&&!m&&(!t[a-1]||t[a-1].isNull)&&s.push(b)}return f=l.call(this,t),v&&(v===!0&&(v="left"),u.step={left:"right",center:"center",right:"left"}[v]),x=l.call(this,n),y=l.call(this,s),u.step=v,c=[].concat(f,x),!this.chart.polar&&y[0]&&y[0][0]==="M"&&(y[0]=["L",y[0][1],y[0][2]]),this.graphPath=c,this.areaPath=f.concat(y),c.isArea=!0,c.xMap=f.xMap,this.areaPath.xMap=f.xMap,c},r.prototype.drawDataLabels=function(){var t=this.points,n=t.length,s,a=[],l=this.options.dataLabels,h,d,c=this.chart.inverted,f,u;if(l){if(isArray$5(l)?(f=l[0]||{enabled:!1},u=l[1]||{enabled:!1}):(f=extend$F({},l),f.x=l.xHigh,f.y=l.yHigh,u=extend$F({},l),u.x=l.xLow,u.y=l.yLow),f.enabled||this._hasPointLabels){for(s=n;s--;)h=t[s],h&&(d=f.inside?h.plotHigh<h.plotLow:h.plotHigh>h.plotLow,h.y=h.high,h._plotY=h.plotY,h.plotY=h.plotHigh,a[s]=h.dataLabel,h.dataLabel=h.dataLabelUpper,h.below=d,c?f.align||(f.align=d?"right":"left"):f.verticalAlign||(f.verticalAlign=d?"top":"bottom"));for(this.options.dataLabels=f,seriesProto$1.drawDataLabels&&seriesProto$1.drawDataLabels.apply(this,arguments),s=n;s--;)h=t[s],h&&(h.dataLabelUpper=h.dataLabel,h.dataLabel=a[s],delete h.dataLabels,h.y=h.low,h.plotY=h._plotY)}if(u.enabled||this._hasPointLabels){for(s=n;s--;)h=t[s],h&&(d=u.inside?h.plotHigh<h.plotLow:h.plotHigh>h.plotLow,h.below=!d,c?u.align||(u.align=d?"left":"right"):u.verticalAlign||(u.verticalAlign=d?"bottom":"top"));this.options.dataLabels=u,seriesProto$1.drawDataLabels&&seriesProto$1.drawDataLabels.apply(this,arguments)}if(f.enabled)for(s=n;s--;)h=t[s],h&&(h.dataLabels=[h.dataLabelUpper,h.dataLabel].filter(function(p){return!!p}));this.options.dataLabels=l}},r.prototype.alignDataLabel=function(){columnProto$4.alignDataLabel.apply(this,arguments)},r.prototype.drawPoints=function(){var t=this,n=t.points.length,s,a;for(seriesProto$1.drawPoints.apply(t,arguments),a=0;a<n;)s=t.points[a],s.origProps={plotY:s.plotY,plotX:s.plotX,isInside:s.isInside,negative:s.negative,zone:s.zone,y:s.y},s.lowerGraphic=s.graphic,s.graphic=s.upperGraphic,s.plotY=s.plotHigh,defined$f(s.plotHighX)&&(s.plotX=s.plotHighX),s.y=pick$F(s.high,s.origProps.y),s.negative=s.y<(t.options.threshold||0),t.zones.length&&(s.zone=s.getZone()),t.chart.polar||(s.isInside=s.isTopInside=typeof s.plotY<"u"&&s.plotY>=0&&s.plotY<=t.yAxis.len&&s.plotX>=0&&s.plotX<=t.xAxis.len),a++;for(seriesProto$1.drawPoints.apply(t,arguments),a=0;a<n;)s=t.points[a],s.upperGraphic=s.graphic,s.graphic=s.lowerGraphic,s.origProps&&(extend$F(s,s.origProps),delete s.origProps),a++},r.defaultOptions=merge$B(AreaSeries$1.defaultOptions,{lineWidth:1,threshold:null,tooltip:{pointFormat:'<span style="color:{series.color}">●</span> {series.name}: <b>{point.low}</b> - <b>{point.high}</b><br/>'},trackByArea:!0,dataLabels:{align:void 0,verticalAlign:void 0,xLow:0,xHigh:0,yLow:0,yHigh:0}}),r}(AreaSeries$1);extend$F(AreaRangeSeries$2.prototype,{pointArrayMap:["low","high"],pointValKey:"low",deferTranslatePolar:!0,pointClass:AreaRangePoint$1,setStackedPoints:noop$b});SeriesRegistry$1.registerSeriesType("arearange",AreaRangeSeries$2);var __extends$D=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),SplineSeries=SeriesRegistry$1.seriesTypes.spline,merge$A=Utilities.merge,extend$E=Utilities.extend,AreaSplineRangeSeries=function(o){__extends$D(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.options=void 0,t.data=void 0,t.points=void 0,t}return r.defaultOptions=merge$A(AreaRangeSeries$2.defaultOptions),r}(AreaRangeSeries$2);extend$E(AreaSplineRangeSeries.prototype,{getPointSpline:SplineSeries.prototype.getPointSpline});SeriesRegistry$1.registerSeriesType("areasplinerange",AreaSplineRangeSeries);var __extends$C=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),noop$a=H.noop,extend$D=Utilities.extend,merge$z=Utilities.merge,pick$E=Utilities.pick,BoxPlotSeries=function(o){__extends$C(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.pointAttribs=function(){return{}},r.prototype.translate=function(){var t=this,n=t.yAxis,s=t.pointArrayMap;o.prototype.translate.apply(t),t.points.forEach(function(a){s.forEach(function(l){a[l]!==null&&(a[l+"Plot"]=n.translate(a[l],0,1,0,1))}),a.plotHigh=a.highPlot})},r.prototype.drawPoints=function(){var t=this,n=t.points,s=t.options,a=t.chart,l=a.renderer,h,d,c,f,u,p,g,m=0,v,x,y,b,$,S=t.doQuartiles!==!1,k,A=t.options.whiskerLength;n.forEach(function(P){var E=P.graphic,M=E?"animate":"attr",C=P.shapeArgs,O={},L={},T={},_={},D=P.color||t.color;if(typeof P.plotY<"u"){x=Math.round(C.width),y=Math.floor(C.x),b=y+x,$=Math.round(x/2),h=Math.floor(S?P.q1Plot:P.lowPlot),d=Math.floor(S?P.q3Plot:P.lowPlot),c=Math.floor(P.highPlot),f=Math.floor(P.lowPlot),E||(P.graphic=E=l.g("point").add(t.group),P.stem=l.path().addClass("highcharts-boxplot-stem").add(E),A&&(P.whiskers=l.path().addClass("highcharts-boxplot-whisker").add(E)),S&&(P.box=l.path(v).addClass("highcharts-boxplot-box").add(E)),P.medianShape=l.path(p).addClass("highcharts-boxplot-median").add(E)),a.styledMode||(L.stroke=P.stemColor||s.stemColor||D,L["stroke-width"]=pick$E(P.stemWidth,s.stemWidth,s.lineWidth),L.dashstyle=P.stemDashStyle||s.stemDashStyle||s.dashStyle,P.stem.attr(L),A&&(T.stroke=P.whiskerColor||s.whiskerColor||D,T["stroke-width"]=pick$E(P.whiskerWidth,s.whiskerWidth,s.lineWidth),T.dashstyle=P.whiskerDashStyle||s.whiskerDashStyle||s.dashStyle,P.whiskers.attr(T)),S&&(O.fill=P.fillColor||s.fillColor||D,O.stroke=s.lineColor||D,O["stroke-width"]=s.lineWidth||0,O.dashstyle=P.boxDashStyle||s.boxDashStyle||s.dashStyle,P.box.attr(O)),_.stroke=P.medianColor||s.medianColor||D,_["stroke-width"]=pick$E(P.medianWidth,s.medianWidth,s.lineWidth),_.dashstyle=P.medianDashStyle||s.medianDashStyle||s.dashStyle,P.medianShape.attr(_));var N=void 0;g=P.stem.strokeWidth()%2/2,m=y+$+g,N=[["M",m,d],["L",m,c],["M",m,h],["L",m,f]],P.stem[M]({d:N}),S&&(g=P.box.strokeWidth()%2/2,h=Math.floor(h)+g,d=Math.floor(d)+g,y+=g,b+=g,N=[["M",y,d],["L",y,h],["L",b,h],["L",b,d],["L",y,d],["Z"]],P.box[M]({d:N})),A&&(g=P.whiskers.strokeWidth()%2/2,c=c+g,f=f+g,k=/%$/.test(A)?$*parseFloat(A)/100:A/2,N=[["M",m-k,c],["L",m+k,c],["M",m-k,f],["L",m+k,f]],P.whiskers[M]({d:N})),u=Math.round(P.medianPlot),g=P.medianShape.strokeWidth()%2/2,u=u+g,N=[["M",y,u],["L",b,u]],P.medianShape[M]({d:N})}})},r.prototype.toYData=function(t){return[t.low,t.q1,t.median,t.q3,t.high]},r.defaultOptions=merge$z(ColumnSeries$h.defaultOptions,{threshold:null,tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Maximum: {point.high}<br/>Upper quartile: {point.q3}<br/>Median: {point.median}<br/>Lower quartile: {point.q1}<br/>Minimum: {point.low}<br/>'},whiskerLength:"50%",fillColor:palette.backgroundColor,lineWidth:1,medianWidth:2,whiskerWidth:2}),r}(ColumnSeries$h);extend$D(BoxPlotSeries.prototype,{pointArrayMap:["low","q1","median","q3","high"],pointValKey:"high",drawDataLabels:noop$a,setStackedPoints:noop$a});SeriesRegistry$1.registerSeriesType("boxplot",BoxPlotSeries);var BubbleLegendDefaults={borderColor:void 0,borderWidth:2,className:void 0,color:void 0,connectorClassName:void 0,connectorColor:void 0,connectorDistance:60,connectorWidth:1,enabled:!1,labels:{className:void 0,allowOverlap:!1,format:"",formatter:void 0,align:"right",style:{fontSize:"10px",color:palette.neutralColor100},x:0,y:0},maxSize:60,minSize:10,legendIndex:0,ranges:{value:void 0,borderColor:void 0,color:void 0,connectorColor:void 0},sizeBy:"area",sizeByAbsoluteValue:!1,zIndex:1,zThreshold:0},color$a=Color.parse,noop$9=H.noop,arrayMax$3=Utilities.arrayMax,arrayMin$3=Utilities.arrayMin,isNumber$h=Utilities.isNumber,merge$y=Utilities.merge,pick$D=Utilities.pick,stableSort$2=Utilities.stableSort,BubbleLegendItem=function(){function o(r,t){this.chart=void 0,this.fontMetrics=void 0,this.legend=void 0,this.legendGroup=void 0,this.legendItem=void 0,this.legendItemHeight=void 0,this.legendItemWidth=void 0,this.legendSymbol=void 0,this.maxLabel=void 0,this.movementX=void 0,this.ranges=void 0,this.selected=void 0,this.visible=void 0,this.symbols=void 0,this.options=void 0,this.setState=noop$9,this.init(r,t)}return o.prototype.init=function(r,t){this.options=r,this.visible=!0,this.chart=t.chart,this.legend=t},o.prototype.addToLegend=function(r){r.splice(this.options.legendIndex,0,this)},o.prototype.drawLegendSymbol=function(r){var t=this.chart,n=this.options,s=pick$D(r.options.itemDistance,20),a=n.ranges,l=n.connectorDistance,h;if(this.fontMetrics=t.renderer.fontMetrics(n.labels.style.fontSize),!a||!a.length||!isNumber$h(a[0].value)){r.options.bubbleLegend.autoRanges=!0;return}stableSort$2(a,function(u,p){return p.value-u.value}),this.ranges=a,this.setOptions(),this.render();var d=this.getMaxLabelSize(),c=this.ranges[0].radius,f=c*2;h=l-c+d.width,h=h>0?h:0,this.maxLabel=d,this.movementX=n.labels.align==="left"?h:0,this.legendItemWidth=f+h+s,this.legendItemHeight=f+this.fontMetrics.h/2},o.prototype.setOptions=function(){var r=this.ranges,t=this.options,n=this.chart.series[t.seriesIndex],s=this.legend.baseline,a={zIndex:t.zIndex,"stroke-width":t.borderWidth},l={zIndex:t.zIndex,"stroke-width":t.connectorWidth},h={align:this.legend.options.rtl||t.labels.align==="left"?"right":"left",zIndex:t.zIndex},d=n.options.marker.fillOpacity,c=this.chart.styledMode;r.forEach(function(f,u){c||(a.stroke=pick$D(f.borderColor,t.borderColor,n.color),a.fill=pick$D(f.color,t.color,d!==1?color$a(n.color).setOpacity(d).get("rgba"):n.color),l.stroke=pick$D(f.connectorColor,t.connectorColor,n.color)),r[u].radius=this.getRangeRadius(f.value),r[u]=merge$y(r[u],{center:r[0].radius-r[u].radius+s}),c||merge$y(!0,r[u],{bubbleAttribs:merge$y(a),connectorAttribs:merge$y(l),labelAttribs:h})},this)},o.prototype.getRangeRadius=function(r){var t=this.options,n=this.options.seriesIndex,s=this.chart.series[n],a=t.ranges[0].value,l=t.ranges[t.ranges.length-1].value,h=t.minSize,d=t.maxSize;return s.getRadius.call(this,l,a,h,d,r)},o.prototype.render=function(){var r=this.chart.renderer,t=this.options.zThreshold;this.symbols||(this.symbols={connectors:[],bubbleItems:[],labels:[]}),this.legendSymbol=r.g("bubble-legend"),this.legendItem=r.g("bubble-legend-item"),this.legendSymbol.translateX=0,this.legendSymbol.translateY=0,this.ranges.forEach(function(n){n.value>=t&&this.renderRange(n)},this),this.legendSymbol.add(this.legendItem),this.legendItem.add(this.legendGroup),this.hideOverlappingLabels()},o.prototype.renderRange=function(r){var t=this.ranges[0],n=this.legend,s=this.options,a=s.labels,l=this.chart,h=l.series[s.seriesIndex],d=l.renderer,c=this.symbols,f=c.labels,u=r.center,p=Math.abs(r.radius),g=s.connectorDistance||0,m=a.align,v=n.options.rtl,x=s.borderWidth,y=s.connectorWidth,b=t.radius||0,$=u-p-x/2+y/2,S=this.fontMetrics,k=S.f/2-(S.h-S.f)/2,A=($%1?1:.5)-(y%2?0:.5),P=d.styledMode,E=v||m==="left"?-g:g;m==="center"&&(E=0,s.connectorDistance=0,r.labelAttribs.align="center");var M=$+s.labels.y,C=b+E+s.labels.x;c.bubbleItems.push(d.circle(b,u+A,p).attr(P?{}:r.bubbleAttribs).addClass((P?"highcharts-color-"+h.colorIndex+" ":"")+"highcharts-bubble-legend-symbol "+(s.className||"")).add(this.legendSymbol)),c.connectors.push(d.path(d.crispLine([["M",b,$],["L",b+E,$]],s.connectorWidth)).attr(P?{}:r.connectorAttribs).addClass((P?"highcharts-color-"+this.options.seriesIndex+" ":"")+"highcharts-bubble-legend-connectors "+(s.connectorClassName||"")).add(this.legendSymbol));var O=d.text(this.formatLabel(r),C,M+k).attr(P?{}:r.labelAttribs).css(P?{}:a.style).addClass("highcharts-bubble-legend-labels "+(s.labels.className||"")).add(this.legendSymbol);f.push(O),O.placed=!0,O.alignAttr={x:C,y:M+k}},o.prototype.getMaxLabelSize=function(){var r=this.symbols.labels,t,n;return r.forEach(function(s){n=s.getBBox(!0),t?t=n.width>t.width?n:t:t=n}),t||{}},o.prototype.formatLabel=function(r){var t=this.options,n=t.labels.formatter,s=t.labels.format,a=this.chart.numberFormatter;return s?FormatUtilities.format(s,r):n?n.call(r):a(r.value,1)},o.prototype.hideOverlappingLabels=function(){var r=this.chart,t=this.options.labels.allowOverlap,n=this.symbols;!t&&n&&(r.hideOverlappingLabels(n.labels),n.labels.forEach(function(s,a){s.newOpacity?s.newOpacity!==s.oldOpacity&&n.connectors[a].show():n.connectors[a].hide()}))},o.prototype.getRanges=function(){var r=this.legend.bubbleLegend,t=r.chart.series,n=r.options.ranges,s,a,l=Number.MAX_VALUE,h=-Number.MAX_VALUE;return t.forEach(function(d){d.isBubble&&!d.ignoreSeries&&(a=d.zData.filter(isNumber$h),a.length&&(l=pick$D(d.options.zMin,Math.min(l,Math.max(arrayMin$3(a),d.options.displayNegative===!1?d.options.zThreshold:-Number.MAX_VALUE))),h=pick$D(d.options.zMax,Math.max(h,arrayMax$3(a)))))}),l===h?s=[{value:h}]:s=[{value:l},{value:(l+h)/2},{value:h,autoRanges:!0}],n.length&&n[0].radius&&s.reverse(),s.forEach(function(d,c){n&&n[c]&&(s[c]=merge$y(n[c],d))}),s},o.prototype.predictBubbleSizes=function(){var r=this.chart,t=this.fontMetrics,n=r.legend.options,s=n.floating,a=n.layout==="horizontal",l=a?r.legend.lastLineHeight:0,h=r.plotSizeX,d=r.plotSizeY,c=r.series[this.options.seriesIndex],f=Math.ceil(c.minPxSize),u=Math.ceil(c.maxPxSize),p=Math.min(d,h),g,m=c.options.maxSize;return s||!/%$/.test(m)?g=u:(m=parseFloat(m),g=(p+l-t.h/2)*m/100/(m/100+1),(a&&d-g>=h||!a&&h-g>=d)&&(g=u)),[f,Math.ceil(g)]},o.prototype.updateRanges=function(r,t){var n=this.legend.options.bubbleLegend;n.minSize=r,n.maxSize=t,n.ranges=this.getRanges()},o.prototype.correctSizes=function(){var r=this.legend,t=this.chart,n=t.series[this.options.seriesIndex],s=n.maxPxSize,a=this.options.maxSize;Math.abs(Math.ceil(s)-a)>1&&(this.updateRanges(this.options.minSize,n.maxPxSize),r.render())},o}(),setOptions=DefaultOptions.setOptions,addEvent$o=Utilities.addEvent,objectEach$9=Utilities.objectEach,wrap$7=Utilities.wrap,BubbleLegendComposition;(function(o){var r=[];function t(c,f,u){var p=this,g=p.legend,m=s(p)>=0,v,x;g&&g.options.enabled&&g.bubbleLegend&&g.options.bubbleLegend.autoRanges&&m?(v=g.bubbleLegend.options,x=g.bubbleLegend.predictBubbleSizes(),g.bubbleLegend.updateRanges(x[0],x[1]),v.placed||(g.group.placed=!1,g.allItems.forEach(function(y){y.legendGroup.translateY=null})),g.render(),p.getMargins(),p.axes.forEach(function(y){y.visible&&y.render(),v.placed||(y.setScale(),y.updateNames(),objectEach$9(y.ticks,function(b){b.isNew=!0,b.isNewLabel=!0}))}),v.placed=!0,p.getMargins(),c.call(p,f,u),g.bubbleLegend.correctSizes(),d(g,a(g))):(c.call(p,f,u),g&&g.options.enabled&&g.bubbleLegend&&(g.render(),d(g,a(g))))}function n(c,f,u){r.indexOf(c)===-1&&(r.push(c),setOptions({legend:{bubbleLegend:BubbleLegendDefaults}}),wrap$7(c.prototype,"drawChartBox",t)),r.indexOf(f)===-1&&(r.push(f),addEvent$o(f,"afterGetAllItems",l)),r.indexOf(u)===-1&&(r.push(u),addEvent$o(u,"legendItemClick",h))}o.compose=n;function s(c){for(var f=c.series,u=0;u<f.length;){if(f[u]&&f[u].isBubble&&f[u].visible&&f[u].zData.length)return u;u++}return-1}function a(c){var f=c.allItems,u=[],p=f.length,g,m=0,v=0;for(m=0;m<p;m++)if(f[m].legendItemHeight&&(f[m].itemHeight=f[m].legendItemHeight),f[m]===f[p-1]||f[m+1]&&f[m]._legendItemPos[1]!==f[m+1]._legendItemPos[1]){for(u.push({height:0}),g=u[u.length-1],v;v<=m;v++)f[v].itemHeight>g.height&&(g.height=f[v].itemHeight);g.step=m}return u}function l(c){var f=this,u=f.bubbleLegend,p=f.options,g=p.bubbleLegend,m=s(f.chart);u&&u.ranges&&u.ranges.length&&(g.ranges.length&&(g.autoRanges=!!g.ranges[0].autoRanges),f.destroyItem(u)),m>=0&&p.enabled&&g.enabled&&(g.seriesIndex=m,f.bubbleLegend=new BubbleLegendItem(g,f),f.bubbleLegend.addToLegend(c.allItems))}function h(){var c=this,f=c.chart,u=c.visible,p=c.chart.legend,g;p&&p.bubbleLegend&&(c.visible=!u,c.ignoreSeries=u,g=s(f)>=0,p.bubbleLegend.visible!==g&&(p.update({bubbleLegend:{enabled:g}}),p.bubbleLegend.visible=g),c.visible=u)}function d(c,f){var u=c.allItems,p=c.options.rtl,g,m,v,x=0;u.forEach(function(y,b){g=y.legendGroup.translateX,m=y._legendItemPos[1],v=y.movementX,(v||p&&y.ranges)&&(v=p?g-y.options.maxSize/2:g+v,y.legendGroup.attr({translateX:v})),b>f[x].step&&x++,y.legendGroup.attr({translateY:Math.round(m+f[x].height/2)}),y._legendItemPos[1]=m+f[x].height/2})}})(BubbleLegendComposition||(BubbleLegendComposition={}));const BubbleLegendComposition$1=BubbleLegendComposition;var __extends$B=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),ScatterPoint$2=SeriesRegistry$1.seriesTypes.scatter.prototype.pointClass,extend$C=Utilities.extend,BubblePoint=function(o){__extends$B(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return r.prototype.haloPath=function(t){return Point$2.prototype.haloPath.call(this,t===0?0:(this.marker&&this.marker.radius||0)+t)},r}(ScatterPoint$2);extend$C(BubblePoint.prototype,{ttBelow:!1});var __extends$A=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),color$9=Color.parse,noop$8=H.noop,_a$b=SeriesRegistry$1.seriesTypes,ColumnSeries$b=_a$b.column,ScatterSeries$3=_a$b.scatter,arrayMax$2=Utilities.arrayMax,arrayMin$2=Utilities.arrayMin,clamp$8=Utilities.clamp,extend$B=Utilities.extend,isNumber$g=Utilities.isNumber,merge$x=Utilities.merge,pick$C=Utilities.pick,pInt$2=Utilities.pInt,BubbleSeries$2=function(o){__extends$A(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.maxPxSize=void 0,t.minPxSize=void 0,t.options=void 0,t.points=void 0,t.radii=void 0,t.yData=void 0,t.zData=void 0,t}return r.prototype.animate=function(t){!t&&this.points.length<this.options.animationLimit&&this.points.forEach(function(n){var s=n.graphic;s&&s.width&&(this.hasRendered||s.attr({x:n.plotX,y:n.plotY,width:1,height:1}),s.animate(this.markerAttribs(n),this.options.animation))},this)},r.prototype.getRadii=function(t,n,s){var a,l,h=this.zData,d=this.yData,c=s.minPxSize,f=s.maxPxSize,u=[],p;for(l=0,a=h.length;l<a;l++)p=h[l],u.push(this.getRadius(t,n,c,f,p,d[l]));this.radii=u},r.prototype.getRadius=function(t,n,s,a,l,h){var d=this.options,c=d.sizeBy!=="width",f=d.zThreshold,u=n-t,p=.5;if(h===null||l===null)return null;if(isNumber$g(l)){if(d.sizeByAbsoluteValue&&(l=Math.abs(l-f),n=u=Math.max(n-f,Math.abs(t-f)),t=0),l<t)return s/2-1;u>0&&(p=(l-t)/u)}return c&&p>=0&&(p=Math.sqrt(p)),Math.ceil(s+p*(a-s))/2},r.prototype.hasData=function(){return!!this.processedXData.length},r.prototype.pointAttribs=function(t,n){var s=this.options.marker,a=s.fillOpacity,l=Series$e.prototype.pointAttribs.call(this,t,n);return a!==1&&(l.fill=color$9(l.fill).setOpacity(a).get("rgba")),l},r.prototype.translate=function(){var t,n=this.data,s,a,l=this.radii;for(o.prototype.translate.call(this),t=n.length;t--;)s=n[t],a=l?l[t]:0,isNumber$g(a)&&a>=this.minPxSize/2?(s.marker=extend$B(s.marker,{radius:a,width:2*a,height:2*a}),s.dlBox={x:s.plotX-a,y:s.plotY-a,width:2*a,height:2*a}):s.shapeArgs=s.plotY=s.dlBox=void 0},r.compose=BubbleLegendComposition$1.compose,r.defaultOptions=merge$x(ScatterSeries$3.defaultOptions,{dataLabels:{formatter:function(){var t=this.series.chart.numberFormatter,n=this.point.z;return isNumber$g(n)?t(n,-1):""},inside:!0,verticalAlign:"middle"},animationLimit:250,marker:{lineColor:null,lineWidth:1,fillOpacity:.5,radius:null,states:{hover:{radiusPlus:0}},symbol:"circle"},minSize:8,maxSize:"20%",softThreshold:!1,states:{hover:{halo:{size:5}}},tooltip:{pointFormat:"({point.x}, {point.y}), Size: {point.z}"},turboThreshold:0,zThreshold:0,zoneAxis:"z"}),r}(ScatterSeries$3);extend$B(BubbleSeries$2.prototype,{alignDataLabel:ColumnSeries$b.prototype.alignDataLabel,applyZones:noop$8,bubblePadding:!0,buildKDTree:noop$8,directTouch:!0,isBubble:!0,pointArrayMap:["y","z"],pointClass:BubblePoint,parallelArrays:["x","y","z"],trackerGroups:["group","dataLabelsGroup"],specialGroup:"group",zoneAxis:"z"});Axis.prototype.beforePadding=function(){var o=this,r=this.len,t=this.chart,n=0,s=r,a=this.isXAxis,l=a?"xData":"yData",h=this.min,d={},c=Math.min(t.plotWidth,t.plotHeight),f=Number.MAX_VALUE,u=-Number.MAX_VALUE,p=this.max-h,g=r/p,m=[];this.series.forEach(function(v){var x=v.options,y;v.bubblePadding&&(v.visible||!t.options.chart.ignoreHiddenSeries)&&(o.allowZoomOutside=!0,m.push(v),a&&(["minSize","maxSize"].forEach(function(b){var $=x[b],S=/%$/.test($);$=pInt$2($),d[b]=S?c*$/100:$}),v.minPxSize=d.minSize,v.maxPxSize=Math.max(d.maxSize,d.minSize),y=v.zData.filter(isNumber$g),y.length&&(f=pick$C(x.zMin,clamp$8(arrayMin$2(y),x.displayNegative===!1?x.zThreshold:-Number.MAX_VALUE,f)),u=pick$C(x.zMax,Math.max(u,arrayMax$2(y))))))}),m.forEach(function(v){var x=v[l],y=x.length,b;if(a&&v.getRadii(f,u,v),p>0)for(;y--;)isNumber$g(x[y])&&o.dataMin<=x[y]&&x[y]<=o.max&&(b=v.radii?v.radii[y]:0,n=Math.min((x[y]-h)*g-b,n),s=Math.max((x[y]-h)*g+b,s))}),m.length&&p>0&&!this.logarithmic&&(s-=r,g*=(r+Math.max(0,n)-Math.min(s,r))/r,[["min","userMin",n],["max","userMax",s]].forEach(function(v){typeof pick$C(o.options[v[0]],o[v[1]])>"u"&&(o[v[0]]+=v[2]/g)}))};SeriesRegistry$1.registerSeriesType("bubble",BubbleSeries$2);var __extends$z=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),_a$a=SeriesRegistry$1.seriesTypes,ColumnPoint=_a$a.column.prototype.pointClass,AreaRangePoint=_a$a.arearange.prototype.pointClass,extend$A=Utilities.extend,isNumber$f=Utilities.isNumber,ColumnRangePoint=function(o){__extends$z(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.series=void 0,t.options=void 0,t.barX=void 0,t.pointWidth=void 0,t.shapeType=void 0,t}return r.prototype.isValid=function(){return isNumber$f(this.low)},r}(AreaRangePoint);extend$A(ColumnRangePoint.prototype,{setState:ColumnPoint.prototype.setState});var __extends$y=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),noop$7=H.noop,_a$9=SeriesRegistry$1.seriesTypes,AreaRangeSeries$1=_a$9.arearange,ColumnSeries$a=_a$9.column,columnProto$3=ColumnSeries$a.prototype,arearangeProto$1=AreaRangeSeries$1.prototype,clamp$7=Utilities.clamp,merge$w=Utilities.merge,pick$B=Utilities.pick,extend$z=Utilities.extend,columnRangeOptions={pointRange:null,marker:null,states:{hover:{halo:!1}}},ColumnRangeSeries=function(o){__extends$y(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.points=void 0,t.options=void 0,t}return r.prototype.setOptions=function(){return merge$w(!0,arguments[0],{stacking:void 0}),arearangeProto$1.setOptions.apply(this,arguments)},r.prototype.translate=function(){var t=this,n=t.yAxis,s=t.xAxis,a=s.startAngleRad,l,h=t.chart,d=t.xAxis.isRadial,c=Math.max(h.chartWidth,h.chartHeight)+999,f;function u(p){return clamp$7(p,-c,c)}columnProto$3.translate.apply(t),t.points.forEach(function(p){var g=p.shapeArgs||{},m=t.options.minPointLength,v,x,y;if(p.plotHigh=f=u(n.translate(p.high,0,1,0,1)),p.plotLow=u(p.plotY),y=f,x=pick$B(p.rectPlotY,p.plotY)-f,Math.abs(x)<m?(v=m-x,x+=v,y-=v/2):x<0&&(x*=-1,y-=x),d)l=p.barX+a,p.shapeType="arc",p.shapeArgs=t.polarArc(y+x,y,l,l+p.pointWidth);else{g.height=x,g.y=y;var b=g.x,$=b===void 0?0:b,S=g.width,k=S===void 0?0:S;p.tooltipPos=h.inverted?[n.len+n.pos-h.plotLeft-y-x/2,s.len+s.pos-h.plotTop-$-k/2,x]:[s.left-h.plotLeft+$+k/2,n.pos-h.plotTop+y+x/2,x]}})},r.prototype.crispCol=function(){return columnProto$3.crispCol.apply(this,arguments)},r.prototype.drawPoints=function(){return columnProto$3.drawPoints.apply(this,arguments)},r.prototype.drawTracker=function(){return columnProto$3.drawTracker.apply(this,arguments)},r.prototype.getColumnMetrics=function(){return columnProto$3.getColumnMetrics.apply(this,arguments)},r.prototype.pointAttribs=function(){return columnProto$3.pointAttribs.apply(this,arguments)},r.prototype.adjustForMissingColumns=function(){return columnProto$3.adjustForMissingColumns.apply(this,arguments)},r.prototype.animate=function(){return columnProto$3.animate.apply(this,arguments)},r.prototype.translate3dPoints=function(){return columnProto$3.translate3dPoints.apply(this,arguments)},r.prototype.translate3dShapes=function(){return columnProto$3.translate3dShapes.apply(this,arguments)},r.defaultOptions=merge$w(ColumnSeries$a.defaultOptions,AreaRangeSeries$1.defaultOptions,columnRangeOptions),r}(AreaRangeSeries$1);extend$z(ColumnRangeSeries.prototype,{directTouch:!0,trackerGroups:["group","dataLabelsGroup"],drawGraph:noop$7,getSymbol:noop$7,polarArc:function(){return columnProto$3.polarArc.apply(this,arguments)},pointClass:ColumnRangePoint});SeriesRegistry$1.registerSeriesType("columnrange",ColumnRangeSeries);var __extends$x=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),colProto=ColumnSeries$h.prototype,clamp$6=Utilities.clamp,merge$v=Utilities.merge,pick$A=Utilities.pick,ColumnPyramidSeries=function(o){__extends$x(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.translate=function(){var t=this,n=t.chart,s=t.options,a=t.dense=t.closestPointRange*t.xAxis.transA<2,l=t.borderWidth=pick$A(s.borderWidth,a?0:1),h=t.yAxis,d=s.threshold,c=t.translatedThreshold=h.getThreshold(d),f=pick$A(s.minPointLength,5),u=t.getColumnMetrics(),p=u.width,g=t.barW=Math.max(p,1+2*l),m=t.pointXOffset=u.offset;n.inverted&&(c-=.5),s.pointPadding&&(g=Math.ceil(g)),colProto.translate.apply(t),t.points.forEach(function(v){var x=pick$A(v.yBottom,c),y=999+Math.abs(x),b=clamp$6(v.plotY,-y,h.len+y),$=v.plotX+m,S=g/2,k=Math.min(b,x),A=Math.max(b,x)-k,P,E,M,C,O,L,T,_,D,N,I,B;v.barX=$,v.pointWidth=p,v.tooltipPos=n.inverted?[h.len+h.pos-n.plotLeft-b,t.xAxis.len-$-S,A]:[$+S,b+h.pos-n.plotTop,A],P=d+(v.total||v.y),s.stacking==="percent"&&(P=d+(v.y<0)?-100:100),M=h.toPixels(P,!0),E=n.plotHeight-M-(n.plotHeight-c),C=E?S*(k-M)/E:0,O=E?S*(k+A-M)/E:0,T=$-C+S,_=$+C+S,D=$+O+S,N=$-O+S,I=k-f,B=k+A,v.y<0&&(I=k,B=k+A+f),n.inverted&&(L=n.plotWidth-k,E=M-(n.plotWidth-c),C=S*(M-L)/E,O=S*(M-(L-A))/E,T=$+S+C,_=T-2*C,D=$-O+S,N=$+O+S,I=k,B=k+A-f,v.y<0&&(B=k+A+f)),v.shapeType="path",v.shapeArgs={x:T,y:I,width:_-T,height:A,d:[["M",T,I],["L",_,I],["L",D,B],["L",N,B],["Z"]]}})},r.defaultOptions=merge$v(ColumnSeries$h.defaultOptions,{}),r}(ColumnSeries$h);SeriesRegistry$1.registerSeriesType("columnpyramid",ColumnPyramidSeries);var __extends$w=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),AreaRangeSeries=SeriesRegistry$1.seriesTypes.arearange,merge$u=Utilities.merge,extend$y=Utilities.extend,ErrorBarSeries=function(o){__extends$w(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.getColumnMetrics=function(){return this.linkedParent&&this.linkedParent.columnMetrics||ColumnSeries$h.prototype.getColumnMetrics.call(this)},r.prototype.drawDataLabels=function(){var t=this.pointValKey;AreaRangeSeries&&(AreaRangeSeries.prototype.drawDataLabels.call(this),this.data.forEach(function(n){n.y=n[t]}))},r.prototype.toYData=function(t){return[t.low,t.high]},r.defaultOptions=merge$u(BoxPlotSeries.defaultOptions,{color:palette.neutralColor100,grouping:!1,linkedTo:":previous",tooltip:{pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.low}</b> - <b>{point.high}</b><br/>'},whiskerWidth:null}),r}(BoxPlotSeries);extend$y(ErrorBarSeries.prototype,{pointArrayMap:["low","high"],pointValKey:"high",doQuartiles:!1});SeriesRegistry$1.registerSeriesType("errorbar",ErrorBarSeries);var __extends$v=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),Point$1=SeriesRegistry$1.series.prototype.pointClass,GaugePoint=function(o){__extends$v(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t.shapeArgs=void 0,t}return r.prototype.setState=function(t){this.state=t},r}(Point$1),__extends$u=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),noop$6=H.noop,Series$a=SeriesRegistry$1.series,ColumnSeries$9=SeriesRegistry$1.seriesTypes.column,clamp$5=Utilities.clamp,isNumber$e=Utilities.isNumber,extend$x=Utilities.extend,merge$t=Utilities.merge,pick$z=Utilities.pick,pInt$1=Utilities.pInt,GaugeSeries$1=function(o){__extends$u(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.points=void 0,t.options=void 0,t.yAxis=void 0,t}return r.prototype.translate=function(){var t=this,n=t.yAxis,s=t.options,a=n.center;t.generatePoints(),t.points.forEach(function(l){var h=merge$t(s.dial,l.dial),d=pInt$1(pick$z(h.radius,"80%"))*a[2]/200,c=pInt$1(pick$z(h.baseLength,"70%"))*d/100,f=pInt$1(pick$z(h.rearLength,"10%"))*d/100,u=h.baseWidth||3,p=h.topWidth||1,g=s.overshoot,m=n.startAngleRad+n.translate(l.y,null,null,null,!0);(isNumber$e(g)||s.wrap===!1)&&(g=isNumber$e(g)?g/180*Math.PI:0,m=clamp$5(m,n.startAngleRad-g,n.endAngleRad+g)),m=m*180/Math.PI,l.shapeType="path";var v=h.path||[["M",-f,-u/2],["L",c,-u/2],["L",d,-p/2],["L",d,p/2],["L",c,u/2],["L",-f,u/2],["Z"]];l.shapeArgs={d:v,translateX:a[0],translateY:a[1],rotation:m},l.plotX=a[0],l.plotY=a[1]})},r.prototype.drawPoints=function(){var t=this,n=t.chart,s=t.yAxis.center,a=t.pivot,l=t.options,h=l.pivot,d=n.renderer;t.points.forEach(function(c){var f=c.graphic,u=c.shapeArgs,p=u.d,g=merge$t(l.dial,c.dial);f?(f.animate(u),u.d=p):c.graphic=d[c.shapeType](u).attr({rotation:u.rotation,zIndex:1}).addClass("highcharts-dial").add(t.group),n.styledMode||c.graphic[f?"animate":"attr"]({stroke:g.borderColor||"none","stroke-width":g.borderWidth||0,fill:g.backgroundColor||palette.neutralColor100})}),a?a.animate({translateX:s[0],translateY:s[1]}):(t.pivot=d.circle(0,0,pick$z(h.radius,5)).attr({zIndex:2}).addClass("highcharts-pivot").translate(s[0],s[1]).add(t.group),n.styledMode||t.pivot.attr({"stroke-width":h.borderWidth||0,stroke:h.borderColor||palette.neutralColor20,fill:h.backgroundColor||palette.neutralColor100}))},r.prototype.animate=function(t){var n=this;t||n.points.forEach(function(s){var a=s.graphic;a&&(a.attr({rotation:n.yAxis.startAngleRad*180/Math.PI}),a.animate({rotation:s.shapeArgs.rotation},n.options.animation))})},r.prototype.render=function(){this.group=this.plotGroup("group","series",this.visible?"visible":"hidden",this.options.zIndex,this.chart.seriesGroup),Series$a.prototype.render.call(this),this.group.clip(this.chart.clipRect)},r.prototype.setData=function(t,n){Series$a.prototype.setData.call(this,t,!1),this.processData(),this.generatePoints(),pick$z(n,!0)&&this.chart.redraw()},r.prototype.hasData=function(){return!!this.points.length},r.defaultOptions=merge$t(Series$a.defaultOptions,{dataLabels:{borderColor:palette.neutralColor20,borderRadius:3,borderWidth:1,crop:!1,defer:!1,enabled:!0,verticalAlign:"top",y:15,zIndex:2},dial:{},pivot:{},tooltip:{headerFormat:""},showInLegend:!1}),r}(Series$a);extend$x(GaugeSeries$1.prototype,{angular:!0,directTouch:!0,drawGraph:noop$6,drawTracker:ColumnSeries$9.prototype.drawTracker,fixedBox:!0,forceDL:!0,noSharedTooltip:!0,pointClass:GaugePoint,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("gauge",GaugeSeries$1);var __extends$t=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),BubbleSeries$1=SeriesRegistry$1.seriesTypes.bubble,PackedBubblePoint=function(o){__extends$t(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.degree=NaN,t.mass=NaN,t.radius=NaN,t.options=void 0,t.series=void 0,t.value=null,t}return r.prototype.destroy=function(){return this.series.layout&&this.series.layout.removeElementFromCollection(this,this.series.layout.nodes),Point$2.prototype.destroy.apply(this,arguments)},r.prototype.firePointEvent=function(){var t=this.series,n=t.options;if(this.isParentNode&&n.parentNode){var s=n.allowPointSelect;n.allowPointSelect=n.parentNode.allowPointSelect,Point$2.prototype.firePointEvent.apply(this,arguments),n.allowPointSelect=s}else Point$2.prototype.firePointEvent.apply(this,arguments)},r.prototype.select=function(){var t=this,n=this.series,s=n.chart;t.isParentNode?(s.getSelectedPoints=s.getSelectedParentNodes,Point$2.prototype.select.apply(this,arguments),s.getSelectedPoints=Chart$1.prototype.getSelectedPoints):Point$2.prototype.select.apply(this,arguments)},r}(BubbleSeries$1.prototype.pointClass),addEvent$n=Utilities.addEvent;H.dragNodesMixin={onMouseDown:function(o,r){var t=this.chart.pointer.normalize(r);o.fixedPosition={chartX:t.chartX,chartY:t.chartY,plotX:o.plotX,plotY:o.plotY},o.inDragMode=!0},onMouseMove:function(o,r){if(o.fixedPosition&&o.inDragMode){var t=this,n=t.chart,s=n.pointer.normalize(r),a=o.fixedPosition.chartX-s.chartX,l=o.fixedPosition.chartY-s.chartY,h=void 0,d=void 0,c=n.graphLayoutsLookup;(Math.abs(a)>5||Math.abs(l)>5)&&(h=o.fixedPosition.plotX-a,d=o.fixedPosition.plotY-l,n.isInsidePlot(h,d)&&(o.plotX=h,o.plotY=d,o.hasDragged=!0,this.redrawHalo(o),c.forEach(function(f){f.restartSimulation()})))}},onMouseUp:function(o,r){o.fixedPosition&&(o.hasDragged&&(this.layout.enableSimulation?this.layout.start():this.chart.redraw()),o.inDragMode=o.hasDragged=!1,this.options.fixedDraggable||delete o.fixedPosition)},redrawHalo:function(o){o&&this.halo&&this.halo.attr({d:o.haloPath(this.options.states.hover.halo.size)})}};addEvent$n(Chart$1,"load",function(){var o=this,r,t,n;o.container&&(r=addEvent$n(o.container,"mousedown",function(s){var a=o.hoverPoint;a&&a.series&&a.series.hasDraggableNodes&&a.series.options.draggable&&(a.series.onMouseDown(a,s),t=addEvent$n(o.container,"mousemove",function(l){return a&&a.series&&a.series.onMouseMove(a,l)}),n=addEvent$n(o.container.ownerDocument,"mouseup",function(l){return t(),n(),a&&a.series&&a.series.onMouseUp(a,l)}))})),addEvent$n(o,"destroy",function(){r()})});H.networkgraphIntegrations={verlet:{attractiveForceFunction:function(o,r){return(r-o)/o},repulsiveForceFunction:function(o,r){return(r-o)/o*(r>o?1:0)},barycenter:function(){var o=this.options.gravitationalConstant,r=this.barycenter.xFactor,t=this.barycenter.yFactor;r=(r-(this.box.left+this.box.width)/2)*o,t=(t-(this.box.top+this.box.height)/2)*o,this.nodes.forEach(function(n){n.fixedPosition||(n.plotX-=r/n.mass/n.degree,n.plotY-=t/n.mass/n.degree)})},repulsive:function(o,r,t){var n=r*this.diffTemperature/o.mass/o.degree;o.fixedPosition||(o.plotX+=t.x*n,o.plotY+=t.y*n)},attractive:function(o,r,t){var n=o.getMass(),s=-t.x*r*this.diffTemperature,a=-t.y*r*this.diffTemperature;o.fromNode.fixedPosition||(o.fromNode.plotX-=s*n.fromNode/o.fromNode.degree,o.fromNode.plotY-=a*n.fromNode/o.fromNode.degree),o.toNode.fixedPosition||(o.toNode.plotX+=s*n.toNode/o.toNode.degree,o.toNode.plotY+=a*n.toNode/o.toNode.degree)},integrate:function(o,r){var t=-o.options.friction,n=o.options.maxSpeed,s=r.prevX,a=r.prevY,l=(r.plotX+r.dispX-s)*t,h=(r.plotY+r.dispY-a)*t,d=Math.abs,c=d(l)/(l||1),f=d(h)/(h||1);l=c*Math.min(n,Math.abs(l)),h=f*Math.min(n,Math.abs(h)),r.prevX=r.plotX+r.dispX,r.prevY=r.plotY+r.dispY,r.plotX+=l,r.plotY+=h,r.temperature=o.vectorLength({x:l,y:h})},getK:function(o){return Math.pow(o.box.width*o.box.height/o.nodes.length,.5)}},euler:{attractiveForceFunction:function(o,r){return o*o/r},repulsiveForceFunction:function(o,r){return r*r/o},barycenter:function(){var o=this.options.gravitationalConstant,r=this.barycenter.xFactor,t=this.barycenter.yFactor;this.nodes.forEach(function(n){if(!n.fixedPosition){var s=n.getDegree(),a=s*(1+s/2);n.dispX+=(r-n.plotX)*o*a/n.degree,n.dispY+=(t-n.plotY)*o*a/n.degree}})},repulsive:function(o,r,t,n){o.dispX+=t.x/n*r/o.degree,o.dispY+=t.y/n*r/o.degree},attractive:function(o,r,t,n){var s=o.getMass(),a=t.x/n*r,l=t.y/n*r;o.fromNode.fixedPosition||(o.fromNode.dispX-=a*s.fromNode/o.fromNode.degree,o.fromNode.dispY-=l*s.fromNode/o.fromNode.degree),o.toNode.fixedPosition||(o.toNode.dispX+=a*s.toNode/o.toNode.degree,o.toNode.dispY+=l*s.toNode/o.toNode.degree)},integrate:function(o,r){var t;r.dispX+=r.dispX*o.options.friction,r.dispY+=r.dispY*o.options.friction,t=r.temperature=o.vectorLength({x:r.dispX,y:r.dispY}),t!==0&&(r.plotX+=r.dispX/t*Math.min(Math.abs(r.dispX),o.temperature),r.plotY+=r.dispY/t*Math.min(Math.abs(r.dispY),o.temperature))},getK:function(o){return Math.pow(o.box.width*o.box.height/o.nodes.length,.3)}}};var extend$w=Utilities.extend,QuadTreeNode=H.QuadTreeNode=function(o){this.box=o,this.boxSize=Math.min(o.width,o.height),this.nodes=[],this.isInternal=!1,this.body=!1,this.isEmpty=!0};extend$w(QuadTreeNode.prototype,{insert:function(o,r){var t;this.isInternal?this.nodes[this.getBoxPosition(o)].insert(o,r-1):(this.isEmpty=!1,this.body?r?(this.isInternal=!0,this.divideBox(),this.body!==!0&&(this.nodes[this.getBoxPosition(this.body)].insert(this.body,r-1),this.body=!0),this.nodes[this.getBoxPosition(o)].insert(o,r-1)):(t=new QuadTreeNode({top:o.plotX,left:o.plotY,width:.1,height:.1}),t.body=o,t.isInternal=!1,this.nodes.push(t)):(this.isInternal=!1,this.body=o))},updateMassAndCenter:function(){var o=0,r=0,t=0;this.isInternal?(this.nodes.forEach(function(n){n.isEmpty||(o+=n.mass,r+=n.plotX*n.mass,t+=n.plotY*n.mass)}),r/=o,t/=o):this.body&&(o=this.body.mass,r=this.body.plotX,t=this.body.plotY),this.mass=o,this.plotX=r,this.plotY=t},divideBox:function(){var o=this.box.width/2,r=this.box.height/2;this.nodes[0]=new QuadTreeNode({left:this.box.left,top:this.box.top,width:o,height:r}),this.nodes[1]=new QuadTreeNode({left:this.box.left+o,top:this.box.top,width:o,height:r}),this.nodes[2]=new QuadTreeNode({left:this.box.left+o,top:this.box.top+r,width:o,height:r}),this.nodes[3]=new QuadTreeNode({left:this.box.left,top:this.box.top+r,width:o,height:r})},getBoxPosition:function(o){var r=o.plotX<this.box.left+this.box.width/2,t=o.plotY<this.box.top+this.box.height/2,n;return r?t?n=0:n=3:t?n=1:n=2,n}});var QuadTree=H.QuadTree=function(o,r,t,n){this.box={left:o,top:r,width:t,height:n},this.maxDepth=25,this.root=new QuadTreeNode(this.box,"0"),this.root.isInternal=!0,this.root.isRoot=!0,this.root.divideBox()};extend$w(QuadTree.prototype,{insertNodes:function(o){o.forEach(function(r){this.root.insert(r,this.maxDepth)},this)},visitNodeRecursive:function(o,r,t){var n;o||(o=this.root),o===this.root&&r&&(n=r(o)),n!==!1&&(o.nodes.forEach(function(s){if(s.isInternal){if(r&&(n=r(s)),n===!1)return;this.visitNodeRecursive(s,r,t)}else s.body&&r&&r(s.body);t&&t(s)},this),o===this.root&&t&&t(o))},calculateMassAndCenter:function(){this.visitNodeRecursive(null,null,function(o){o.updateMassAndCenter()})}});var setAnimation=animationExports.setAnimation,addEvent$m=Utilities.addEvent,clamp$4=Utilities.clamp,defined$e=Utilities.defined,extend$v=Utilities.extend,isFunction=Utilities.isFunction,pick$y=Utilities.pick;H.layouts={"reingold-fruchterman":function(){}};extend$v(H.layouts["reingold-fruchterman"].prototype,{init:function(o){this.options=o,this.nodes=[],this.links=[],this.series=[],this.box={x:0,y:0,width:0,height:0},this.setInitialRendering(!0),this.integration=H.networkgraphIntegrations[o.integration],this.enableSimulation=o.enableSimulation,this.attractiveForce=pick$y(o.attractiveForce,this.integration.attractiveForceFunction),this.repulsiveForce=pick$y(o.repulsiveForce,this.integration.repulsiveForceFunction),this.approximation=o.approximation},updateSimulation:function(o){this.enableSimulation=pick$y(o,this.options.enableSimulation)},start:function(){var o=this,r=this.series,t=this.options;o.currentStep=0,o.forces=r[0]&&r[0].forces||[],o.chart=r[0]&&r[0].chart,o.initialRendering&&(o.initPositions(),r.forEach(function(n){n.finishedAnimating=!0,n.render()})),o.setK(),o.resetSimulation(t),o.enableSimulation&&o.step()},step:function(){var o=this,r=this.series;this.options,o.currentStep++,o.approximation==="barnes-hut"&&(o.createQuadTree(),o.quadTree.calculateMassAndCenter()),o.forces.forEach(function(t){o[t+"Forces"](o.temperature)}),o.applyLimits(o.temperature),o.temperature=o.coolDown(o.startTemperature,o.diffTemperature,o.currentStep),o.prevSystemTemperature=o.systemTemperature,o.systemTemperature=o.getSystemTemperature(),o.enableSimulation&&(r.forEach(function(t){t.chart&&t.render()}),o.maxIterations--&&isFinite(o.temperature)&&!o.isStable()?(o.simulation&&H.win.cancelAnimationFrame(o.simulation),o.simulation=H.win.requestAnimationFrame(function(){o.step()})):o.simulation=!1)},stop:function(){this.simulation&&H.win.cancelAnimationFrame(this.simulation)},setArea:function(o,r,t,n){this.box={left:o,top:r,width:t,height:n}},setK:function(){this.k=this.options.linkLength||this.integration.getK(this)},addElementsToCollection:function(o,r){o.forEach(function(t){r.indexOf(t)===-1&&r.push(t)})},removeElementFromCollection:function(o,r){var t=r.indexOf(o);t!==-1&&r.splice(t,1)},clear:function(){this.nodes.length=0,this.links.length=0,this.series.length=0,this.resetSimulation()},resetSimulation:function(){this.forcedStop=!1,this.systemTemperature=0,this.setMaxIterations(),this.setTemperature(),this.setDiffTemperature()},restartSimulation:function(){this.simulation?this.resetSimulation():(this.setInitialRendering(!1),this.enableSimulation?this.start():this.setMaxIterations(1),this.chart&&this.chart.redraw(),this.setInitialRendering(!0))},setMaxIterations:function(o){this.maxIterations=pick$y(o,this.options.maxIterations)},setTemperature:function(){this.temperature=this.startTemperature=Math.sqrt(this.nodes.length)},setDiffTemperature:function(){this.diffTemperature=this.startTemperature/(this.options.maxIterations+1)},setInitialRendering:function(o){this.initialRendering=o},createQuadTree:function(){this.quadTree=new H.QuadTree(this.box.left,this.box.top,this.box.width,this.box.height),this.quadTree.insertNodes(this.nodes)},initPositions:function(){var o=this.options.initialPositions;isFunction(o)?(o.call(this),this.nodes.forEach(function(r){defined$e(r.prevX)||(r.prevX=r.plotX),defined$e(r.prevY)||(r.prevY=r.plotY),r.dispX=0,r.dispY=0})):o==="circle"?this.setCircularPositions():this.setRandomPositions()},setCircularPositions:function(){var o=this.box,r=this.nodes,t=r.length+1,n=2*Math.PI/t,s=r.filter(function(c){return c.linksTo.length===0}),a=[],l={},h=this.options.initialPositionRadius;function d(c){c.linksFrom.forEach(function(f){l[f.toNode.id]||(l[f.toNode.id]=!0,a.push(f.toNode),d(f.toNode))})}s.forEach(function(c){a.push(c),d(c)}),a.length?r.forEach(function(c){a.indexOf(c)===-1&&a.push(c)}):a=r,a.forEach(function(c,f){c.plotX=c.prevX=pick$y(c.plotX,o.width/2+h*Math.cos(f*n)),c.plotY=c.prevY=pick$y(c.plotY,o.height/2+h*Math.sin(f*n)),c.dispX=0,c.dispY=0})},setRandomPositions:function(){var o=this.box,r=this.nodes,t=r.length+1;function n(s){var a=s*s/Math.PI;return a=a-Math.floor(a),a}r.forEach(function(s,a){s.plotX=s.prevX=pick$y(s.plotX,o.width*n(a)),s.plotY=s.prevY=pick$y(s.plotY,o.height*n(t+a)),s.dispX=0,s.dispY=0})},force:function(o){this.integration[o].apply(this,Array.prototype.slice.call(arguments,1))},barycenterForces:function(){this.getBarycenter(),this.force("barycenter")},getBarycenter:function(){var o=0,r=0,t=0;return this.nodes.forEach(function(n){r+=n.plotX*n.mass,t+=n.plotY*n.mass,o+=n.mass}),this.barycenter={x:r,y:t,xFactor:r/o,yFactor:t/o},this.barycenter},barnesHutApproximation:function(o,r){var t=this,n=t.getDistXY(o,r),s=t.vectorLength(n),a,l;return o!==r&&s!==0&&(r.isInternal?r.boxSize/s<t.options.theta&&s!==0?(l=t.repulsiveForce(s,t.k),t.force("repulsive",o,l*r.mass,n,s),a=!1):a=!0:(l=t.repulsiveForce(s,t.k),t.force("repulsive",o,l*r.mass,n,s))),a},repulsiveForces:function(){var o=this;o.approximation==="barnes-hut"?o.nodes.forEach(function(r){o.quadTree.visitNodeRecursive(null,function(t){return o.barnesHutApproximation(r,t)})}):o.nodes.forEach(function(r){o.nodes.forEach(function(t){var n,s,a;r!==t&&!r.fixedPosition&&(a=o.getDistXY(r,t),s=o.vectorLength(a),s!==0&&(n=o.repulsiveForce(s,o.k),o.force("repulsive",r,n*t.mass,a,s)))})})},attractiveForces:function(){var o=this,r,t,n;o.links.forEach(function(s){s.fromNode&&s.toNode&&(r=o.getDistXY(s.fromNode,s.toNode),t=o.vectorLength(r),t!==0&&(n=o.attractiveForce(t,o.k),o.force("attractive",s,n,r,t)))})},applyLimits:function(){var o=this,r=o.nodes;r.forEach(function(t){t.fixedPosition||(o.integration.integrate(o,t),o.applyLimitBox(t,o.box),t.dispX=0,t.dispY=0)})},applyLimitBox:function(o,r){var t=o.radius;o.plotX=clamp$4(o.plotX,r.left+t,r.width-t),o.plotY=clamp$4(o.plotY,r.top+t,r.height-t)},coolDown:function(o,r,t){return o-r*t},isStable:function(){return Math.abs(this.systemTemperature-this.prevSystemTemperature)<1e-5||this.temperature<=0},getSystemTemperature:function(){return this.nodes.reduce(function(o,r){return o+r.temperature},0)},vectorLength:function(o){return Math.sqrt(o.x*o.x+o.y*o.y)},getDistR:function(o,r){var t=this.getDistXY(o,r);return this.vectorLength(t)},getDistXY:function(o,r){var t=o.plotX-r.plotX,n=o.plotY-r.plotY;return{x:t,y:n,absX:Math.abs(t),absY:Math.abs(n)}}});addEvent$m(Chart$1,"predraw",function(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(o){o.stop()})});addEvent$m(Chart$1,"render",function(){var o,r=!1;function t(n){n.maxIterations--&&isFinite(n.temperature)&&!n.isStable()&&!n.enableSimulation&&(n.beforeStep&&n.beforeStep(),n.step(),o=!1,r=!0)}if(this.graphLayoutsLookup){for(setAnimation(!1,this),this.graphLayoutsLookup.forEach(function(n){n.start()});!o;)o=!0,this.graphLayoutsLookup.forEach(t);r&&this.series.forEach(function(n){n&&n.layout&&n.render()})}});addEvent$m(Chart$1,"beforePrint",function(){this.graphLayoutsLookup&&(this.graphLayoutsLookup.forEach(function(o){o.updateSimulation(!1)}),this.redraw())});addEvent$m(Chart$1,"afterPrint",function(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(o){o.updateSimulation()}),this.redraw()});var Reingold=H.layouts["reingold-fruchterman"],addEvent$l=Utilities.addEvent,extendClass=Utilities.extendClass,pick$x=Utilities.pick;Chart$1.prototype.getSelectedParentNodes=function(){var o=this,r=o.series,t=[];return r.forEach(function(n){n.parentNode&&n.parentNode.selected&&t.push(n.parentNode)}),t};H.networkgraphIntegrations.packedbubble={repulsiveForceFunction:function(o,r,t,n){return Math.min(o,(t.marker.radius+n.marker.radius)/2)},barycenter:function(){var o=this,r=o.options.gravitationalConstant,t=o.box,n=o.nodes,s,a;n.forEach(function(l){o.options.splitSeries&&!l.isParentNode?(s=l.series.parentNode.plotX,a=l.series.parentNode.plotY):(s=t.width/2,a=t.height/2),l.fixedPosition||(l.plotX-=(l.plotX-s)*r/(l.mass*Math.sqrt(n.length)),l.plotY-=(l.plotY-a)*r/(l.mass*Math.sqrt(n.length)))})},repulsive:function(o,r,t,n){var s=r*this.diffTemperature/o.mass/o.degree,a=t.x*s,l=t.y*s;o.fixedPosition||(o.plotX+=a,o.plotY+=l),n.fixedPosition||(n.plotX-=a,n.plotY-=l)},integrate:H.networkgraphIntegrations.verlet.integrate,getK:H.noop};H.layouts.packedbubble=extendClass(Reingold,{beforeStep:function(){this.options.marker&&this.series.forEach(function(o){o&&o.calculateParentRadius()})},isStable:function(){var o=Math.abs(this.prevSystemTemperature-this.systemTemperature),r=10*this.systemTemperature/Math.sqrt(this.nodes.length);return Math.abs(r)<1&&o<1e-5||this.temperature<=0},setCircularPositions:function(){var o=this,r=o.box,t=o.nodes,n=t.length+1,s=2*Math.PI/n,a,l,h=o.options.initialPositionRadius;t.forEach(function(d,c){o.options.splitSeries&&!d.isParentNode?(a=d.series.parentNode.plotX,l=d.series.parentNode.plotY):(a=r.width/2,l=r.height/2),d.plotX=d.prevX=pick$x(d.plotX,a+h*Math.cos(d.index||c*s)),d.plotY=d.prevY=pick$x(d.plotY,l+h*Math.sin(d.index||c*s)),d.dispX=0,d.dispY=0})},repulsiveForces:function(){var o=this,r,t,n,s=o.options.bubblePadding;o.nodes.forEach(function(a){a.degree=a.mass,a.neighbours=0,o.nodes.forEach(function(l){r=0,a!==l&&!a.fixedPosition&&(o.options.seriesInteraction||a.series===l.series)&&(n=o.getDistXY(a,l),t=o.vectorLength(n)-(a.marker.radius+l.marker.radius+s),t<0&&(a.degree+=.01,a.neighbours++,r=o.repulsiveForce(-t/Math.sqrt(a.neighbours),o.k,a,l)),o.force("repulsive",a,r*l.mass,n,l,t))})})},applyLimitBox:function(o){var r=this,t,n,s=.01;r.options.splitSeries&&!o.isParentNode&&r.options.parentNodeLimit&&(t=r.getDistXY(o,o.series.parentNode),n=o.series.parentNodeRadius-o.marker.radius-r.vectorLength(t),n<0&&n>-2*o.marker.radius&&(o.plotX-=t.x*s,o.plotY-=t.y*s)),Reingold.prototype.applyLimitBox.apply(this,arguments)}});addEvent$l(Chart$1,"beforeRedraw",function(){this.allDataPoints&&delete this.allDataPoints});var __extends$s=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),color$8=Color.parse,Series$9=SeriesRegistry$1.series,BubbleSeries=SeriesRegistry$1.seriesTypes.bubble,addEvent$k=Utilities.addEvent,clamp$3=Utilities.clamp,defined$d=Utilities.defined,extend$u=Utilities.extend,fireEvent$6=Utilities.fireEvent,isArray$4=Utilities.isArray,isNumber$d=Utilities.isNumber,merge$s=Utilities.merge,pick$w=Utilities.pick,dragNodesMixin=H.dragNodesMixin,PackedBubbleSeries=function(o){__extends$s(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.chart=void 0,t.data=void 0,t.layout=void 0,t.options=void 0,t.points=void 0,t.xData=void 0,t}return r.prototype.accumulateAllPoints=function(t){var n=t.chart,s=[],a,l;for(a=0;a<n.series.length;a++)if(t=n.series[a],t.is("packedbubble")&&t.visible||!n.options.chart.ignoreHiddenSeries)for(l=0;l<t.yData.length;l++)s.push([null,null,t.yData[l],t.index,l,{id:l,marker:{radius:0}}]);return s},r.prototype.addLayout=function(){var t=this,n=t.options.layoutAlgorithm,s=t.chart.graphLayoutsStorage,a=t.chart.graphLayoutsLookup,l=t.chart.options.chart,h;s||(t.chart.graphLayoutsStorage=s={},t.chart.graphLayoutsLookup=a=[]),h=s[n.type],h||(n.enableSimulation=defined$d(l.forExport)?!l.forExport:n.enableSimulation,s[n.type]=h=new H.layouts[n.type],h.init(n),a.splice(h.index,0,h)),t.layout=h,t.points.forEach(function(d){d.mass=2,d.degree=1,d.collisionNmb=1}),h.setArea(0,0,t.chart.plotWidth,t.chart.plotHeight),h.addElementsToCollection([t],h.series),h.addElementsToCollection(t.points,h.nodes)},r.prototype.addSeriesLayout=function(){var t=this,n=t.options.layoutAlgorithm,s=t.chart.graphLayoutsStorage,a=t.chart.graphLayoutsLookup,l=merge$s(n,n.parentNodeOptions,{enableSimulation:t.layout.options.enableSimulation}),h;h=s[n.type+"-series"],h||(s[n.type+"-series"]=h=new H.layouts[n.type],h.init(l),a.splice(h.index,0,h)),t.parentNodeLayout=h,this.createParentNodes()},r.prototype.calculateParentRadius=function(){var t=this,n,s=20,a=20;n=t.seriesBox(),t.parentNodeRadius=clamp$3(Math.sqrt(2*t.parentNodeMass/Math.PI)+s,a,n?Math.max(Math.sqrt(Math.pow(n.width,2)+Math.pow(n.height,2))/2+s,a):Math.sqrt(2*t.parentNodeMass/Math.PI)+s),t.parentNode&&(t.parentNode.marker.radius=t.parentNode.radius=t.parentNodeRadius)},r.prototype.calculateZExtremes=function(){var t=this.chart,n=this.options.zMin,s=this.options.zMax,a=1/0,l=-1/0;return n&&s?[n,s]:(t.series.forEach(function(h){h.yData.forEach(function(d){defined$d(d)&&(d>l&&(l=d),d<a&&(a=d))})}),n=pick$w(n,a),s=pick$w(s,l),[n,s])},r.prototype.checkOverlap=function(t,n){var s=t[0]-n[0],a=t[1]-n[1],l=t[2]+n[2];return Math.sqrt(s*s+a*a)-Math.abs(l)<-.001},r.prototype.createParentNodes=function(){var t=this,n=t.chart,s=t.parentNodeLayout,a,l=t.parentNode,h=t.pointClass;t.parentNodeMass=0,t.points.forEach(function(d){t.parentNodeMass+=Math.PI*Math.pow(d.marker.radius,2)}),t.calculateParentRadius(),s.nodes.forEach(function(d){d.seriesIndex===t.index&&(a=!0)}),s.setArea(0,0,n.plotWidth,n.plotHeight),a||(l||(l=new h().init(this,{mass:t.parentNodeRadius/2,marker:{radius:t.parentNodeRadius},dataLabels:{inside:!1},dataLabelOnNull:!0,degree:t.parentNodeRadius,isParentNode:!0,seriesIndex:t.index})),t.parentNode&&(l.plotX=t.parentNode.plotX,l.plotY=t.parentNode.plotY),t.parentNode=l,s.addElementsToCollection([t],s.series),s.addElementsToCollection([l],s.nodes))},r.prototype.deferLayout=function(){var t=this,n=t.options.layoutAlgorithm;t.visible&&(t.addLayout(),n.splitSeries&&t.addSeriesLayout())},r.prototype.destroy=function(){this.chart.graphLayoutsLookup&&this.chart.graphLayoutsLookup.forEach(function(t){t.removeElementFromCollection(this,t.series)},this),this.parentNode&&this.parentNodeLayout&&(this.parentNodeLayout.removeElementFromCollection(this.parentNode,this.parentNodeLayout.nodes),this.parentNode.dataLabel&&(this.parentNode.dataLabel=this.parentNode.dataLabel.destroy())),Series$9.prototype.destroy.apply(this,arguments)},r.prototype.drawDataLabels=function(){var t=this.options.dataLabels.textPath,n=this.points;Series$9.prototype.drawDataLabels.apply(this,arguments),this.parentNode&&(this.parentNode.formatPrefix="parentNode",this.points=[this.parentNode],this.options.dataLabels.textPath=this.options.dataLabels.parentNodeTextPath,Series$9.prototype.drawDataLabels.apply(this,arguments),this.points=n,this.options.dataLabels.textPath=t)},r.prototype.drawGraph=function(){if(!(!this.layout||!this.layout.options.splitSeries)){var t=this,n=t.chart,s={},a=this.layout.options.parentNodeOptions.marker,l={fill:a.fillColor||color$8(t.color).brighten(.4).get(),opacity:a.fillOpacity,stroke:a.lineColor||t.color,"stroke-width":a.lineWidth};this.parentNodesGroup||(t.parentNodesGroup=t.plotGroup("parentNodesGroup","parentNode",t.visible?"inherit":"hidden",.1,n.seriesGroup),t.group.attr({zIndex:2})),this.calculateParentRadius(),s=merge$s({x:t.parentNode.plotX-t.parentNodeRadius,y:t.parentNode.plotY-t.parentNodeRadius,width:t.parentNodeRadius*2,height:t.parentNodeRadius*2},l),t.parentNode.graphic||(t.graph=t.parentNode.graphic=n.renderer.symbol(l.symbol).add(t.parentNodesGroup)),t.parentNode.graphic.attr(s)}},r.prototype.drawTracker=function(){var t=this,n=t.parentNode,s;o.prototype.drawTracker.call(this),n&&(s=isArray$4(n.dataLabels)?n.dataLabels:n.dataLabel?[n.dataLabel]:[],n.graphic&&(n.graphic.element.point=n),s.forEach(function(a){a.div?a.div.point=n:a.element.point=n}))},r.prototype.getPointRadius=function(){var t=this,n=t.chart,s=n.plotWidth,a=n.plotHeight,l=t.options,h=l.useSimulation,d=Math.min(s,a),c={},f=[],u=n.allDataPoints,p,g,m,v,x;["minSize","maxSize"].forEach(function(y){var b=parseInt(l[y],10),$=/%$/.test(l[y]);c[y]=$?d*b/100:b*Math.sqrt(u.length)}),n.minRadius=p=c.minSize/Math.sqrt(u.length),n.maxRadius=g=c.maxSize/Math.sqrt(u.length),x=h?t.calculateZExtremes():[p,g],(u||[]).forEach(function(y,b){m=h?clamp$3(y[2],x[0],x[1]):y[2],v=t.getRadius(x[0],x[1],p,g,m),v===0&&(v=null),u[b][2]=v,f.push(v)}),t.radii=f},r.prototype.init=function(){return Series$9.prototype.init.apply(this,arguments),this.eventsToUnbind.push(addEvent$k(this,"updatedData",function(){this.chart.series.forEach(function(t){t.type===this.type&&(t.isDirty=!0)},this)})),this},r.prototype.onMouseUp=function(t){if(t.fixedPosition&&!t.removed){var n,s,a=this.layout,l=this.parentNodeLayout;l&&a.options.dragBetweenSeries&&l.nodes.forEach(function(h){t&&t.marker&&h!==t.series.parentNode&&(n=a.getDistXY(t,h),s=a.vectorLength(n)-h.marker.radius-t.marker.radius,s<0&&(h.series.addPoint(merge$s(t.options,{plotX:t.plotX,plotY:t.plotY}),!1),a.removeElementFromCollection(t,a.nodes),t.remove()))}),dragNodesMixin.onMouseUp.apply(this,arguments)}},r.prototype.placeBubbles=function(t){var n=this,s=n.checkOverlap,a=n.positionBubble,l=[],h=1,d=0,c=0,f,u,p=[],g;if(u=t.sort(function(m,v){return v[2]-m[2]}),u.length){if(l.push([[0,0,u[0][2],u[0][3],u[0][4]]]),u.length>1)for(l.push([[0,0-u[1][2]-u[0][2],u[1][2],u[1][3],u[1][4]]]),g=2;g<u.length;g++)u[g][2]=u[g][2]||1,f=a(l[h][d],l[h-1][c],u[g]),s(f,l[h][0])?(l.push([]),c=0,l[h+1].push(a(l[h][d],l[h][0],u[g])),h++,d=0):h>1&&l[h-1][c+1]&&s(f,l[h-1][c+1])?(c++,l[h].push(a(l[h][d],l[h-1][c],u[g])),d++):(d++,l[h].push(f));n.chart.stages=l,n.chart.rawPositions=[].concat.apply([],l),n.resizeRadius(),p=n.chart.rawPositions}return p},r.prototype.positionBubble=function(t,n,s){var a=Math.sqrt,l=Math.asin,h=Math.acos,d=Math.pow,c=Math.abs,f=a(d(t[0]-n[0],2)+d(t[1]-n[1],2)),u=h((d(f,2)+d(s[2]+n[2],2)-d(s[2]+t[2],2))/(2*(s[2]+n[2])*f)),p=l(c(t[0]-n[0])/f),g=t[1]-n[1]<0?0:Math.PI,m=(t[0]-n[0])*(t[1]-n[1])<0?1:-1,v=g+u+p*m,x=Math.cos(v),y=Math.sin(v),b=n[0]+(n[2]+s[2])*y,$=n[1]-(n[2]+s[2])*x;return[b,$,s[2],s[3],s[4]]},r.prototype.render=function(){var t=this,n=[];Series$9.prototype.render.apply(this,arguments),t.options.dataLabels.allowOverlap||(t.data.forEach(function(s){isArray$4(s.dataLabels)&&s.dataLabels.forEach(function(a){n.push(a)})}),t.options.useSimulation&&t.chart.hideOverlappingLabels(n))},r.prototype.resizeRadius=function(){var t=this.chart,n=t.rawPositions,s=Math.min,a=Math.max,l=t.plotLeft,h=t.plotTop,d=t.plotHeight,c=t.plotWidth,f,u,p,g,m,v,x,y,b;for(f=p=Number.POSITIVE_INFINITY,u=g=Number.NEGATIVE_INFINITY,b=0;b<n.length;b++)m=n[b][2],f=s(f,n[b][0]-m),u=a(u,n[b][0]+m),p=s(p,n[b][1]-m),g=a(g,n[b][1]+m);if(v=[u-f,g-p],x=[(c-l)/v[0],(d-h)/v[1]],y=s.apply([],x),Math.abs(y-1)>1e-10){for(b=0;b<n.length;b++)n[b][2]*=y;this.placeBubbles(n)}else t.diffY=d/2+h-p-(g-p)/2,t.diffX=c/2+l-f-(u-f)/2},r.prototype.seriesBox=function(){var t=this,n=t.chart,s=t.data,a=Math.max,l=Math.min,h,d=[n.plotLeft,n.plotLeft+n.plotWidth,n.plotTop,n.plotTop+n.plotHeight];return s.forEach(function(c){defined$d(c.plotX)&&defined$d(c.plotY)&&c.marker.radius&&(h=c.marker.radius,d[0]=l(d[0],c.plotX-h),d[1]=a(d[1],c.plotX+h),d[2]=l(d[2],c.plotY-h),d[3]=a(d[3],c.plotY+h))}),isNumber$d(d.width/d.height)?d:null},r.prototype.setVisible=function(){var t=this;Series$9.prototype.setVisible.apply(t,arguments),t.parentNodeLayout&&t.graph?t.visible?(t.graph.show(),t.parentNode.dataLabel&&t.parentNode.dataLabel.show()):(t.graph.hide(),t.parentNodeLayout.removeElementFromCollection(t.parentNode,t.parentNodeLayout.nodes),t.parentNode.dataLabel&&t.parentNode.dataLabel.hide()):t.layout&&(t.visible?t.layout.addElementsToCollection(t.points,t.layout.nodes):t.points.forEach(function(n){t.layout.removeElementFromCollection(n,t.layout.nodes)}))},r.prototype.translate=function(){var t=this,n=t.chart,s=t.data,a=t.index,l,h,d,c,f=t.options.useSimulation;for(t.processedXData=t.xData,t.generatePoints(),defined$d(n.allDataPoints)||(n.allDataPoints=t.accumulateAllPoints(t),t.getPointRadius()),f?d=n.allDataPoints:(d=t.placeBubbles(n.allDataPoints),t.options.draggable=!1),c=0;c<d.length;c++)d[c][3]===a&&(l=s[d[c][4]],h=pick$w(d[c][2],void 0),f||(l.plotX=d[c][0]-n.plotLeft+n.diffX,l.plotY=d[c][1]-n.plotTop+n.diffY),isNumber$d(h)&&(l.marker=extend$u(l.marker,{radius:h,width:2*h,height:2*h}),l.radius=h));f&&t.deferLayout(),fireEvent$6(t,"afterTranslate")},r.defaultOptions=merge$s(BubbleSeries.defaultOptions,{minSize:"10%",maxSize:"50%",sizeBy:"area",zoneAxis:"y",crisp:!1,tooltip:{pointFormat:"Value: {point.value}"},draggable:!0,useSimulation:!0,parentNode:{allowPointSelect:!1},dataLabels:{formatter:function(){var t=this.series.chart.numberFormatter,n=this.point.value;return isNumber$d(n)?t(n,-1):""},parentNodeFormatter:function(){return this.name},parentNodeTextPath:{enabled:!0},padding:0,style:{transition:"opacity 2000ms"}},layoutAlgorithm:{initialPositions:"circle",initialPositionRadius:20,bubblePadding:5,parentNodeLimit:!1,seriesInteraction:!0,dragBetweenSeries:!1,parentNodeOptions:{maxIterations:400,gravitationalConstant:.03,maxSpeed:50,initialPositionRadius:100,seriesInteraction:!0,marker:{fillColor:null,fillOpacity:1,lineWidth:1,lineColor:null,symbol:"circle"}},enableSimulation:!0,type:"packedbubble",integration:"packedbubble",maxIterations:1e3,splitSeries:!1,maxSpeed:5,gravitationalConstant:.01,friction:-.981}}),r}(BubbleSeries);extend$u(PackedBubbleSeries.prototype,{alignDataLabel:Series$9.prototype.alignDataLabel,axisTypes:[],directTouch:!0,forces:["barycenter","repulsive"],hasDraggableNodes:!0,isCartesian:!1,noSharedTooltip:!0,onMouseDown:dragNodesMixin.onMouseDown,onMouseMove:dragNodesMixin.onMouseMove,pointArrayMap:["value"],pointClass:PackedBubblePoint,pointValKey:"value",redrawHalo:dragNodesMixin.redrawHalo,requireSorting:!1,searchPoint:H.noop,trackerGroups:["group","dataLabelsGroup","parentNodesGroup"]});SeriesRegistry$1.registerSeriesType("packedbubble",PackedBubbleSeries);var __extends$r=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),noop$5=H.noop,Series$8=SeriesRegistry$1.series,_a$8=SeriesRegistry$1.seriesTypes,AreaSeries=_a$8.area,LineSeries$2=_a$8.line,ScatterSeries$2=_a$8.scatter,extend$t=Utilities.extend,merge$r=Utilities.merge,PolygonSeries=function(o){__extends$r(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.getGraphPath=function(){for(var t=LineSeries$2.prototype.getGraphPath.call(this),n=t.length+1;n--;)(n===t.length||t[n][0]==="M")&&n>0&&t.splice(n,0,["Z"]);return this.areaPath=t,t},r.prototype.drawGraph=function(){this.options.fillColor=this.color,AreaSeries.prototype.drawGraph.call(this)},r.defaultOptions=merge$r(ScatterSeries$2.defaultOptions,{marker:{enabled:!1,states:{hover:{enabled:!1}}},stickyTracking:!1,tooltip:{followPointer:!0,pointFormat:""},trackByArea:!0}),r}(ScatterSeries$2);extend$t(PolygonSeries.prototype,{type:"polygon",drawLegendSymbol:LegendSymbol$1.drawRectangle,drawTracker:Series$8.prototype.drawTracker,setStackedPoints:noop$5});SeriesRegistry$1.registerSeriesType("polygon",PolygonSeries);var addEvent$j=Utilities.addEvent,objectEach$8=Utilities.objectEach,WaterfallAxis;(function(o){var r=function(){function h(d){this.axis=d,this.stacks={changed:!1}}return h.prototype.renderStackTotals=function(){var d=this.axis,c=d.waterfall.stacks,f=d.stacking&&d.stacking.stackTotalGroup,u=new StackItem$1(d,d.options.stackLabels,!1,0,void 0);this.dummyStackItem=u,objectEach$8(c,function(p){objectEach$8(p,function(g){u.total=g.stackTotal,g.label&&(u.label=g.label),StackItem$1.prototype.render.call(u,f),g.label=u.label,delete u.label})}),u.total=null},h}();o.Composition=r;function t(h,d){addEvent$j(h,"init",l),addEvent$j(h,"afterBuildStacks",n),addEvent$j(h,"afterRender",s),addEvent$j(d,"beforeRedraw",a)}o.compose=t;function n(){var h=this,d=h.waterfall.stacks;d&&(d.changed=!1,delete d.alreadyChanged)}function s(){var h=this,d=h.options.stackLabels;d&&d.enabled&&h.waterfall.stacks&&h.waterfall.renderStackTotals()}function a(){for(var h=this.axes,d=this.series,c=d.length;c--;)d[c].options.stacking&&(h.forEach(function(f){f.isXAxis||(f.waterfall.stacks.changed=!0)}),c=0)}function l(){var h=this;h.waterfall||(h.waterfall=new r(h))}})(WaterfallAxis||(WaterfallAxis={}));const WaterfallAxis$1=WaterfallAxis;var __extends$q=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),isNumber$c=Utilities.isNumber,WaterfallPoint=function(o){__extends$q(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return r.prototype.getClassName=function(){var t=Point$2.prototype.getClassName.call(this);return this.isSum?t+=" highcharts-sum":this.isIntermediateSum&&(t+=" highcharts-intermediate-sum"),t},r.prototype.isValid=function(){return isNumber$c(this.y)||this.isSum||!!this.isIntermediateSum},r}(ColumnSeries$h.prototype.pointClass),__extends$p=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),_a$7=SeriesRegistry$1.seriesTypes,ColumnSeries$8=_a$7.column,LineSeries$1=_a$7.line,arrayMax$1=Utilities.arrayMax,arrayMin$1=Utilities.arrayMin,correctFloat$2=Utilities.correctFloat,extend$s=Utilities.extend,isNumber$b=Utilities.isNumber,merge$q=Utilities.merge,objectEach$7=Utilities.objectEach,pick$v=Utilities.pick;function ownProp(o,r){return Object.hasOwnProperty.call(o,r)}var WaterfallSeries=function(o){__extends$p(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.chart=void 0,t.data=void 0,t.options=void 0,t.points=void 0,t.stackedYNeg=void 0,t.stackedYPos=void 0,t.stackKey=void 0,t.xData=void 0,t.yAxis=void 0,t.yData=void 0,t}return r.prototype.generatePoints=function(){var t,n,s,a;for(ColumnSeries$8.prototype.generatePoints.apply(this),s=0,n=this.points.length;s<n;s++)t=this.points[s],a=this.processedYData[s],(t.isIntermediateSum||t.isSum)&&(t.y=correctFloat$2(a))},r.prototype.translate=function(){var t=this,n=t.options,s=t.yAxis,a,l=pick$v(n.minPointLength,5),h=l/2,d=n.threshold||0,c=d,f=d,u=n.stacking,p=s.waterfall.stacks[t.stackKey],g,m,v;ColumnSeries$8.prototype.translate.apply(t);for(var x=t.points,y=0;y<x.length;y++){var b=x[y],$=t.processedYData[y],S=b.shapeArgs;if(!(!S||!isNumber$b($))){var k=[0,$],A=b.y;if(u){if(p){var P=p[y];u==="overlap"?(g=P.stackState[P.stateIndex--],a=A>=0?g:g-A,ownProp(P,"absolutePos")&&delete P.absolutePos,ownProp(P,"absoluteNeg")&&delete P.absoluteNeg):(A>=0?(g=P.threshold+P.posTotal,P.posTotal-=A,a=g):(g=P.threshold+P.negTotal,P.negTotal-=A,a=g-A),P.posTotal||ownProp(P,"absolutePos")&&(P.posTotal=P.absolutePos,delete P.absolutePos),P.negTotal||ownProp(P,"absoluteNeg")&&(P.negTotal=P.absoluteNeg,delete P.absoluteNeg)),b.isSum||(P.connectorThreshold=P.threshold+P.stackTotal),s.reversed?(m=A>=0?a-A:a+A,v=a):(m=a,v=a-A),b.below=m<=d,S.y=s.translate(m,!1,!0,!1,!0)||0,S.height=Math.abs(S.y-(s.translate(v,!1,!0,!1,!0)||0));var E=s.waterfall.dummyStackItem;E&&(E.x=y,E.label=p[y].label,E.setOffset(t.pointXOffset||0,t.barW||0,t.stackedYNeg[y],t.stackedYPos[y]))}}else a=Math.max(c,c+A)+k[0],S.y=s.translate(a,!1,!0,!1,!0)||0,b.isSum?(S.y=s.translate(k[1],!1,!0,!1,!0)||0,S.height=Math.min(s.translate(k[0],!1,!0,!1,!0)||0,s.len)-S.y,b.below=k[1]<=d):b.isIntermediateSum?(A>=0?(m=k[1]+f,v=f):(m=f,v=k[1]+f),s.reversed&&(m^=v,v^=m,m^=v),S.y=s.translate(m,!1,!0,!1,!0)||0,S.height=Math.abs(S.y-Math.min(s.translate(v,!1,!0,!1,!0)||0,s.len)),f+=k[1],b.below=m<=d):(S.height=$>0?(s.translate(c,!1,!0,!1,!0)||0)-S.y:(s.translate(c,!1,!0,!1,!0)||0)-(s.translate(c-$,!1,!0,!1,!0)||0),c+=$,b.below=c<d),S.height<0&&(S.y+=S.height,S.height*=-1);b.plotY=S.y=Math.round(S.y||0)-t.borderWidth%2/2,S.height=Math.max(Math.round(S.height||0),.001),b.yBottom=S.y+S.height,S.height<=l&&!b.isNull?(S.height=l,S.y-=h,b.plotY=S.y,b.y<0?b.minPointLengthOffset=-h:b.minPointLengthOffset=h):(b.isNull&&(S.width=0),b.minPointLengthOffset=0);var M=b.plotY+(b.negative?S.height:0);b.below&&(b.plotY+=S.height),b.tooltipPos&&(t.chart.inverted?b.tooltipPos[0]=s.len-M:b.tooltipPos[1]=M)}}},r.prototype.processData=function(t){var n=this,s=n.options,a=n.yData,l=s.data,h,d=a.length,c=s.threshold||0,f,u,p,g,m,v;for(u=f=p=g=0,v=0;v<d;v++)m=a[v],h=l&&l[v]?l[v]:{},m==="sum"||h.isSum?a[v]=correctFloat$2(u):m==="intermediateSum"||h.isIntermediateSum?(a[v]=correctFloat$2(f),f=0):(u+=m,f+=m),p=Math.min(u,p),g=Math.max(u,g);o.prototype.processData.call(this,t),s.stacking||(n.dataMin=p+c,n.dataMax=g)},r.prototype.toYData=function(t){return t.isSum?"sum":t.isIntermediateSum?"intermediateSum":t.y},r.prototype.updateParallelArrays=function(t,n){o.prototype.updateParallelArrays.call(this,t,n),(this.yData[0]==="sum"||this.yData[0]==="intermediateSum")&&(this.yData[0]=null)},r.prototype.pointAttribs=function(t,n){var s=this.options.upColor,a;return s&&!t.options.color&&(t.color=t.y>0?s:null),a=ColumnSeries$8.prototype.pointAttribs.call(this,t,n),delete a.dashstyle,a},r.prototype.getGraphPath=function(){return[["M",0,0]]},r.prototype.getCrispPath=function(){var t=this.data,n=this.yAxis,s=t.length,a=Math.round(this.graph.strokeWidth())%2/2,l=Math.round(this.borderWidth)%2/2,h=this.xAxis.reversed,d=this.yAxis.reversed,c=this.options.stacking,f=[],u,p,g,m,v,x,y,b,$;for($=1;$<s;$++)if(b=t[$].shapeArgs,m=t[$-1],y=t[$-1].shapeArgs,p=n.waterfall.stacks[this.stackKey],x=m.y>0?-y.height:0,p&&y&&b&&(g=p[$-1],c?(u=g.connectorThreshold,v=Math.round(n.translate(u,0,1,0,1)+(d?x:0))-a):v=y.y+m.minPointLengthOffset+l-a,f.push(["M",(y.x||0)+(h?0:y.width||0),v],["L",(b.x||0)+(h&&b.width||0),v])),y&&f.length&&(!c&&m.y<0&&!d||m.y>0&&d)){var S=f[f.length-2];S&&typeof S[2]=="number"&&(S[2]+=y.height||0);var k=f[f.length-1];k&&typeof k[2]=="number"&&(k[2]+=y.height||0)}return f},r.prototype.drawGraph=function(){LineSeries$1.prototype.drawGraph.call(this),this.graph.attr({d:this.getCrispPath()})},r.prototype.setStackedPoints=function(){var t=this,n=t.options,s=t.yAxis.waterfall.stacks,a=n.threshold,l=a||0,h=l,d=t.stackKey,c=t.xData,f=c.length,u,p,g,m,v,x,y,b,$,S,k,A,P;function E(C,O,L,T){if(!x)p.stackState[0]=C,x=p.stackState.length;else for(L;L<x;L++)p.stackState[L]+=T;p.stackState.push(p.stackState[x-1]+O)}if(t.yAxis.stacking.usePercentage=!1,g=m=v=l,t.visible||!t.chart.options.chart.ignoreHiddenSeries){P=s.changed,A=s.alreadyChanged,A&&A.indexOf(d)<0&&(P=!0),s[d]||(s[d]={}),u=s[d];for(var M=0;M<f;M++)k=c[M],(!u[k]||P)&&(u[k]={negTotal:0,posTotal:0,stackTotal:0,threshold:0,stateIndex:0,stackState:[],label:P&&u[k]?u[k].label:void 0}),p=u[k],S=t.yData[M],S>=0?p.posTotal+=S:p.negTotal+=S,$=n.data[M],y=p.absolutePos=p.posTotal,b=p.absoluteNeg=p.negTotal,p.stackTotal=y+b,x=p.stackState.length,$&&$.isIntermediateSum?(E(v,m,0,v),v=m,m=a,l^=h,h^=l,l^=h):$&&$.isSum?(E(a,g,x),l=a):(E(l,S,0,g),$&&(g+=S,m+=S)),p.stateIndex++,p.threshold=l,l+=p.stackTotal;s.changed=!1,s.alreadyChanged||(s.alreadyChanged=[]),s.alreadyChanged.push(d)}},r.prototype.getExtremes=function(){var t=this.options.stacking,n,s,a,l;return t?(n=this.yAxis,s=n.waterfall.stacks,a=this.stackedYNeg=[],l=this.stackedYPos=[],t==="overlap"?objectEach$7(s[this.stackKey],function(h){a.push(arrayMin$1(h.stackState)),l.push(arrayMax$1(h.stackState))}):objectEach$7(s[this.stackKey],function(h){a.push(h.negTotal+h.threshold),l.push(h.posTotal+h.threshold)}),{dataMin:arrayMin$1(a),dataMax:arrayMax$1(l)}):{dataMin:this.dataMin,dataMax:this.dataMax}},r.defaultOptions=merge$q(ColumnSeries$8.defaultOptions,{dataLabels:{inside:!0},lineWidth:1,lineColor:palette.neutralColor80,dashStyle:"Dot",borderColor:palette.neutralColor80,states:{hover:{lineWidthPlus:0}}}),r}(ColumnSeries$8);extend$s(WaterfallSeries.prototype,{getZonesGraphs:LineSeries$1.prototype.getZonesGraphs,pointValKey:"y",showLine:!0,pointClass:WaterfallPoint});SeriesRegistry$1.registerSeriesType("waterfall",WaterfallSeries);WaterfallAxis$1.compose(Axis,Chart$1);var animObject$2=animationExports.animObject,seriesTypes$3=SeriesRegistry$1.seriesTypes,addEvent$i=Utilities.addEvent,defined$c=Utilities.defined,find$4=Utilities.find,isNumber$a=Utilities.isNumber,pick$u=Utilities.pick,splat$3=Utilities.splat,uniqueKey$1=Utilities.uniqueKey,wrap$6=Utilities.wrap,seriesProto=Series$e.prototype,pointerProto=Pointer.prototype,columnProto$2,arearangeProto;seriesProto.searchPointByAngle=function(o){var r=this,t=r.chart,n=r.xAxis,s=n.pane.center,a=o.chartX-s[0]-t.plotLeft,l=o.chartY-s[1]-t.plotTop;return this.searchKDTree({clientX:180+Math.atan2(a,l)*(-180/Math.PI)})};seriesProto.getConnectors=function(o,r,t,n){var s,a,l,h,d,c,f,u,p,g,m,v,x=1.5,y=x+1,b,$,S,k,A,P,E,M,C,O=n?1:0;return r>=0&&r<=o.length-1?s=r:r<0?s=o.length-1+r:s=0,a=s-1<0?o.length-(1+O):s-1,l=s+1>o.length-1?O:s+1,h=o[a],d=o[l],c=h.plotX,f=h.plotY,u=d.plotX,p=d.plotY,g=o[s].plotX,m=o[s].plotY,b=(x*g+c)/y,$=(x*m+f)/y,S=(x*g+u)/y,k=(x*m+p)/y,A=Math.sqrt(Math.pow(b-g,2)+Math.pow($-m,2)),P=Math.sqrt(Math.pow(S-g,2)+Math.pow(k-m,2)),E=Math.atan2($-m,b-g),M=Math.atan2(k-m,S-g),C=Math.PI/2+(E+M)/2,Math.abs(E-C)>Math.PI/2&&(C-=Math.PI),b=g+Math.cos(C)*A,$=m+Math.sin(C)*A,S=g+Math.cos(Math.PI+C)*P,k=m+Math.sin(Math.PI+C)*P,v={rightContX:S,rightContY:k,leftContX:b,leftContY:$,plotX:g,plotY:m},t&&(v.prevPointCont=this.getConnectors(o,a,!1,n)),v};seriesProto.toXY=function(o){var r=this.chart,t=this.xAxis,n=this.yAxis,s=o.plotX,a=o.plotY,l=o.series,h=r.inverted,d=o.y,c=h?s:n.len-a,f;if(h&&l&&!l.isRadialBar&&(o.plotY=a=typeof d=="number"&&n.translate(d)||0),o.rectPlotX=s,o.rectPlotY=a,n.center&&(c+=n.center[3]/2),isNumber$a(a)){var u=h?n.postTranslate(a,c):t.postTranslate(s,c);o.plotX=o.polarPlotX=u.x-r.plotLeft,o.plotY=o.polarPlotY=u.y-r.plotTop}this.kdByAngle?(f=(s/Math.PI*180+t.pane.options.startAngle)%360,f<0&&(f+=360),o.clientX=f):o.clientX=o.plotX};seriesTypes$3.spline&&(wrap$6(seriesTypes$3.spline.prototype,"getPointSpline",function(o,r,t,n){var s,a;if(this.chart.polar)if(!n)s=["M",t.plotX,t.plotY];else{a=this.getConnectors(r,n,!0,this.connectEnds);var l=a.prevPointCont&&a.prevPointCont.rightContX,h=a.prevPointCont&&a.prevPointCont.rightContY;s=["C",isNumber$a(l)?l:a.plotX,isNumber$a(h)?h:a.plotY,isNumber$a(a.leftContX)?a.leftContX:a.plotX,isNumber$a(a.leftContY)?a.leftContY:a.plotY,a.plotX,a.plotY]}else s=o.call(this,r,t,n);return s}),seriesTypes$3.areasplinerange&&(seriesTypes$3.areasplinerange.prototype.getPointSpline=seriesTypes$3.spline.prototype.getPointSpline));addEvent$i(Series$e,"afterTranslate",function(){var o=this,r=o.chart;if(r.polar&&o.xAxis){if(o.kdByAngle=r.tooltip&&r.tooltip.shared,o.kdByAngle?o.searchPoint=o.searchPointByAngle:o.options.findNearestPointBy="xy",!o.preventPostTranslate)for(var t=o.points,n=t.length;n--;)o.toXY(t[n]),!r.hasParallelCoordinates&&!o.yAxis.reversed&&t[n].y<o.yAxis.min&&(t[n].isNull=!0);this.hasClipCircleSetter||(this.hasClipCircleSetter=!!o.eventsToUnbind.push(addEvent$i(o,"afterRender",function(){var s;r.polar&&(s=this.yAxis.pane.center,this.clipCircle?this.clipCircle.animate({x:s[0],y:s[1],r:s[2]/2,innerR:s[3]/2}):this.clipCircle=r.renderer.clipCircle(s[0],s[1],s[2]/2,s[3]/2),this.group.clip(this.clipCircle),this.setClip=H.noop)})))}},{order:2});wrap$6(seriesTypes$3.line.prototype,"getGraphPath",function(o,r){var t=this,n,s,a;if(this.chart.polar){for(r=r||this.points,n=0;n<r.length;n++)if(!r[n].isNull){s=n;break}this.options.connectEnds!==!1&&typeof s<"u"&&(this.connectEnds=!0,r.splice(r.length,0,r[s]),a=!0),r.forEach(function(h){typeof h.polarPlotY>"u"&&t.toXY(h)})}var l=o.apply(this,[].slice.call(arguments,1));return a&&r.pop(),l});var polarAnimate=function(o,r){var t=this,n=this.chart,s=this.options.animation,a=this.group,l=this.markerGroup,h=this.xAxis.center,d=n.plotLeft,c=n.plotTop,f,u,p,g,m,v;n.polar?t.isRadialBar?r||(t.startAngleRad=pick$u(t.translatedThreshold,t.xAxis.startAngleRad),H.seriesTypes.pie.prototype.animate.call(t,r)):n.renderer.isSVG&&(s=animObject$2(s),t.is("column")?r||(u=h[3]/2,t.points.forEach(function(x){p=x.graphic,g=x.shapeArgs,m=g&&g.r,v=g&&g.innerR,p&&g&&(p.attr({r:u,innerR:u}),p.animate({r:m,innerR:v},t.options.animation))})):r?(f={translateX:h[0]+d,translateY:h[1]+c,scaleX:.001,scaleY:.001},a.attr(f),l&&l.attr(f)):(f={translateX:d,translateY:c,scaleX:1,scaleY:1},a.animate(f,s),l&&l.animate(f,s))):o.call(this,r)};wrap$6(seriesProto,"animate",polarAnimate);seriesTypes$3.column&&(arearangeProto=seriesTypes$3.arearange.prototype,columnProto$2=seriesTypes$3.column.prototype,columnProto$2.polarArc=function(o,r,t,n){var s=this.xAxis.center,a=this.yAxis.len,l=s[3]/2,h=a-r+l,d=a-pick$u(o,a)+l;return this.yAxis.reversed&&(h<0&&(h=l),d<0&&(d=l)),{x:s[0],y:s[1],r:h,innerR:d,start:t,end:n}},wrap$6(columnProto$2,"animate",polarAnimate),wrap$6(columnProto$2,"translate",function(o){var r=this,t=r.options,n=t.threshold,s=t.stacking,a=r.chart,l=r.xAxis,h=r.yAxis,d=h.reversed,c=h.center,f=l.startAngleRad,u=l.endAngleRad,p=u-f,g,m,v,x,y,b,$,S,k,A,P,E,M,C,O,L;if(r.preventPostTranslate=!0,o.call(r),l.isRadial)for(m=r.points,x=m.length,y=h.translate(h.min),b=h.translate(h.max),n=t.threshold||0,a.inverted&&isNumber$a(n)&&(g=h.translate(n),defined$c(g)&&(g<0?g=0:g>p&&(g=p),r.translatedThreshold=g+f));x--;)v=m[x],C=v.barX,A=v.x,P=v.y,v.shapeType="arc",a.inverted?(v.plotY=h.translate(P),s&&h.stacking?(M=h.stacking.stacks[(P<0?"-":"")+r.stackKey],r.visible&&M&&M[A]&&(v.isNull||(E=M[A].points[r.getStackIndicator(void 0,A,r.index).key],$=h.translate(E[0]),S=h.translate(E[1]),defined$c($)&&($=Utilities.clamp($,0,p))))):($=g,S=v.plotY),$>S&&(S=[$,$=S][0]),d?S>y?S=y:$<b?$=b:($>y||S<b)&&($=S=p):$<y?$=y:S>b?S=b:(S<y||$>b)&&($=S=0),h.min>h.max&&($=S=d?p:0),$+=f,S+=f,c&&(v.barX=C+=c[3]/2),O=Math.max(C,0),L=Math.max(C+v.pointWidth,0),v.shapeArgs={x:c&&c[0],y:c&&c[1],r:L,innerR:O,start:$,end:S},v.opacity=$===S?0:void 0,v.plotY=(defined$c(r.translatedThreshold)&&($<r.translatedThreshold?$:S))-f):($=C+f,v.shapeArgs=r.polarArc(v.yBottom,v.plotY,$,$+v.pointWidth)),r.toXY(v),a.inverted?(k=h.postTranslate(v.rectPlotY,C+v.pointWidth/2),v.tooltipPos=[k.x-a.plotLeft,k.y-a.plotTop]):v.tooltipPos=[v.plotX,v.plotY],c&&(v.ttBelow=v.plotY>c[1])}),columnProto$2.findAlignments=function(o,r){var t,n;return r.align===null&&(o>20&&o<160?t="left":o>200&&o<340?t="right":t="center",r.align=t),r.verticalAlign===null&&(o<45||o>315?n="bottom":o>135&&o<225?n="top":n="middle",r.verticalAlign=n),r},arearangeProto&&(arearangeProto.findAlignments=columnProto$2.findAlignments),wrap$6(columnProto$2,"alignDataLabel",function(o,r,t,n,s,a){var l=this.chart,h=pick$u(n.inside,!!this.options.stacking),d,c,f;l.polar?(d=r.rectPlotX/Math.PI*180,l.inverted?(this.forceDL=l.isInsidePlot(r.plotX,Math.round(r.plotY)),h&&r.shapeArgs?(c=r.shapeArgs,f=this.yAxis.postTranslate(((c.start||0)+(c.end||0))/2-this.xAxis.startAngleRad,r.barX+r.pointWidth/2),s={x:f.x-l.plotLeft,y:f.y-l.plotTop}):r.tooltipPos&&(s={x:r.tooltipPos[0],y:r.tooltipPos[1]}),n.align=pick$u(n.align,"center"),n.verticalAlign=pick$u(n.verticalAlign,"middle")):this.findAlignments&&(n=this.findAlignments(d,n)),seriesProto.alignDataLabel.call(this,r,t,n,s,a),this.isRadialBar&&r.shapeArgs&&r.shapeArgs.start===r.shapeArgs.end&&t.hide(!0)):o.call(this,r,t,n,s,a)}));wrap$6(pointerProto,"getCoordinates",function(o,r){var t=this.chart,n={xAxis:[],yAxis:[]};return t.polar?t.axes.forEach(function(s){var a=s.isXAxis,l=s.center,h,d;s.coll!=="colorAxis"&&(h=r.chartX-l[0]-t.plotLeft,d=r.chartY-l[1]-t.plotTop,n[a?"xAxis":"yAxis"].push({axis:s,value:s.translate(a?Math.PI-Math.atan2(h,d):Math.sqrt(Math.pow(h,2)+Math.pow(d,2)),!0)}))}):n=o.call(this,r),n});SVGRenderer.prototype.clipCircle=function(o,r,t,n){var s,a=uniqueKey$1(),l=this.createElement("clipPath").attr({id:a}).add(this.defs);return s=n?this.arc(o,r,t,n,0,2*Math.PI).add(l):this.circle(o,r,t).add(l),s.id=a,s.clipPath=l,s};addEvent$i(Chart$1,"getAxes",function(){this.pane||(this.pane=[]),this.options.pane=splat$3(this.options.pane),this.options.pane.forEach(function(o){new Pane$1(o,this)},this)});addEvent$i(Chart$1,"afterDrawChartBox",function(){this.pane.forEach(function(o){o.render()})});addEvent$i(Series$e,"afterInit",function(){var o=this.chart;o.inverted&&o.polar&&(this.isRadialSeries=!0,this.is("column")&&(this.isRadialBar=!0))});wrap$6(Chart$1.prototype,"get",function(o,r){return find$4(this.pane||[],function(t){return t.options.id===r})||o.call(this,r)});/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/highcharts-more
 * @requires highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$4=H;RadialAxis$1.compose(G$4.Axis,G$4.Tick);BubbleSeries$2.compose(G$4.Chart,G$4.Legend,G$4.Series);var pick$t=Utilities.pick,deg2rad$3=H.deg2rad;function rotate3D(o,r,t,n){return{x:n.cosB*o-n.sinB*t,y:-n.sinA*n.sinB*o+n.cosA*r-n.cosB*n.sinA*t,z:n.cosA*n.sinB*o+n.sinA*r+n.cosA*n.cosB*t}}function perspective3D$1(o,r,t){var n=t>0&&t<Number.POSITIVE_INFINITY?t/(o.z+r.z+t):1;return{x:o.x*n,y:o.y*n}}H.perspective3D=perspective3D$1;function perspective$6(o,r,t,n){var s=r.options.chart.options3d,a=pick$t(n,t?r.inverted:!1),l={x:r.plotWidth/2,y:r.plotHeight/2,z:s.depth/2,vd:pick$t(s.depth,1)*pick$t(s.viewDistance,0)},h=r.scale3d||1,d=deg2rad$3*s.beta*(a?-1:1),c=deg2rad$3*s.alpha*(a?-1:1),f={cosA:Math.cos(c),cosB:Math.cos(-d),sinA:Math.sin(c),sinB:Math.sin(-d)};return t||(l.x+=r.plotLeft,l.y+=r.plotTop),o.map(function(u){var p=rotate3D((a?u.y:u.x)-l.x,(a?u.x:u.y)-l.y,(u.z||0)-l.z,f),g=perspective3D$1(p,l,l.vd);return g.x=g.x*h+l.x,g.y=g.y*h+l.y,g.z=p.z*h+l.z,{x:a?g.y:g.x,y:a?g.x:g.y,z:g.z}})}H.perspective=perspective$6;function pointCameraDistance$1(o,r){var t=r.options.chart.options3d,n={x:r.plotWidth/2,y:r.plotHeight/2,z:pick$t(t.depth,1)*pick$t(t.viewDistance,0)+t.depth},s=Math.sqrt(Math.pow(n.x-pick$t(o.plotX,o.x),2)+Math.pow(n.y-pick$t(o.plotY,o.y),2)+Math.pow(n.z-pick$t(o.plotZ,o.z),2));return s}H.pointCameraDistance=pointCameraDistance$1;function shapeArea$2(o){var r=0,t,n;for(t=0;t<o.length;t++)n=(t+1)%o.length,r+=o[t].x*o[n].y-o[n].x*o[t].y;return r/2}H.shapeArea=shapeArea$2;function shapeArea3D$1(o,r,t){return shapeArea$2(perspective$6(o,r,t))}H.shapeArea3d=shapeArea3D$1;var mathModule={perspective:perspective$6,perspective3D:perspective3D$1,pointCameraDistance:pointCameraDistance$1,shapeArea:shapeArea$2,shapeArea3D:shapeArea3D$1},color$7=Color.parse,defined$b=Utilities.defined,merge$p=Utilities.merge,objectEach$6=Utilities.objectEach,pick$s=Utilities.pick,SVGElement3D={};SVGElement3D.base={initArgs:function(o){var r=this,t=r.renderer,n=t[r.pathType+"Path"](o),s=n.zIndexes;r.parts.forEach(function(a){r[a]=t.path(n[a]).attr({class:"highcharts-3d-"+a,zIndex:s[a]||0}).add(r)}),r.attr({"stroke-linejoin":"round",zIndex:s.group}),r.originalDestroy=r.destroy,r.destroy=r.destroyParts,r.forcedSides=n.forcedSides},singleSetterForParts:function(o,r,t,n,s,a){var l=this,h={},d=[null,null,n||"attr",s,a],c=t&&t.zIndexes;return t?(c&&c.group&&this.attr({zIndex:c.group}),objectEach$6(t,function(f,u){h[u]={},h[u][o]=f,c&&(h[u].zIndex=t.zIndexes[u]||0)}),d[1]=h):(h[o]=r,d[0]=h),l.processParts.apply(l,d)},processParts:function(o,r,t,n,s){var a=this;return a.parts.forEach(function(l){r&&(o=pick$s(r[l],!1)),o!==!1&&a[l][t](o,n,s)}),a},destroyParts:function(){return this.processParts(null,null,"destroy"),this.originalDestroy()}};SVGElement3D.cuboid=merge$p(SVGElement3D.base,{parts:["front","top","side"],pathType:"cuboid",attr:function(o,r,t,n){if(typeof o=="string"&&typeof r<"u"){var s=o;o={},o[s]=r}return o.shapeArgs||defined$b(o.x)?this.singleSetterForParts("d",null,this.renderer[this.pathType+"Path"](o.shapeArgs||o)):SVGElement.prototype.attr.call(this,o,void 0,t,n)},animate:function(o,r,t){if(defined$b(o.x)&&defined$b(o.y)){var n=this.renderer[this.pathType+"Path"](o),s=n.forcedSides;this.singleSetterForParts("d",null,n,"animate",r,t),this.attr({zIndex:n.zIndexes.group}),s!==this.forcedSides&&(this.forcedSides=s,SVGElement3D.cuboid.fillSetter.call(this,this.fill))}else SVGElement.prototype.animate.call(this,o,r,t);return this},fillSetter:function(o){var r=this;return r.forcedSides=r.forcedSides||[],r.singleSetterForParts("fill",null,{front:o,top:color$7(o).brighten(r.forcedSides.indexOf("top")>=0?0:.1).get(),side:color$7(o).brighten(r.forcedSides.indexOf("side")>=0?0:-.1).get()}),r.color=r.fill=o,r}});var __extends$o=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),animObject$1=animationExports.animObject,color$6=Color.parse,charts=H.charts,deg2rad$2=H.deg2rad,perspective$5=mathModule.perspective,shapeArea$1=mathModule.shapeArea,defined$a=Utilities.defined,extend$r=Utilities.extend,merge$o=Utilities.merge,pick$r=Utilities.pick,cos=Math.cos,sin=Math.sin,PI=Math.PI,dFactor=4*(Math.sqrt(2)-1)/3/(PI/2),SVGRenderer3D=function(o){__extends$o(r,o);function r(){return o!==null&&o.apply(this,arguments)||this}return r.compose=function(t){var n=t.prototype,s=r.prototype;n.elements3d=SVGElement3D,n.arc3d=s.arc3d,n.arc3dPath=s.arc3dPath,n.cuboid=s.cuboid,n.cuboidPath=s.cuboidPath,n.element3d=s.element3d,n.face3d=s.face3d,n.polyhedron=s.polyhedron,n.toLinePath=s.toLinePath,n.toLineSegments=s.toLineSegments},r.curveTo=function(t,n,s,a,l,h,d,c){var f=[],u=h-l;return h>l&&h-l>Math.PI/2+1e-4?(f=f.concat(this.curveTo(t,n,s,a,l,l+Math.PI/2,d,c)),f=f.concat(this.curveTo(t,n,s,a,l+Math.PI/2,h,d,c)),f):h<l&&l-h>Math.PI/2+1e-4?(f=f.concat(this.curveTo(t,n,s,a,l,l-Math.PI/2,d,c)),f=f.concat(this.curveTo(t,n,s,a,l-Math.PI/2,h,d,c)),f):[["C",t+s*Math.cos(l)-s*dFactor*u*Math.sin(l)+d,n+a*Math.sin(l)+a*dFactor*u*Math.cos(l)+c,t+s*Math.cos(h)+s*dFactor*u*Math.sin(h)+d,n+a*Math.sin(h)-a*dFactor*u*Math.cos(h)+c,t+s*Math.cos(h)+d,n+a*Math.sin(h)+c]]},r.prototype.toLinePath=function(t,n){var s=[];return t.forEach(function(a){s.push(["L",a.x,a.y])}),t.length&&(s[0][0]="M",n&&s.push(["Z"])),s},r.prototype.toLineSegments=function(t){var n=[],s=!0;return t.forEach(function(a){n.push(s?["M",a.x,a.y]:["L",a.x,a.y]),s=!s}),n},r.prototype.face3d=function(t){var n=this,s=this.createElement("path");return s.vertexes=[],s.insidePlotArea=!1,s.enabled=!0,s.attr=function(a){if(typeof a=="object"&&(defined$a(a.enabled)||defined$a(a.vertexes)||defined$a(a.insidePlotArea))){this.enabled=pick$r(a.enabled,this.enabled),this.vertexes=pick$r(a.vertexes,this.vertexes),this.insidePlotArea=pick$r(a.insidePlotArea,this.insidePlotArea),delete a.enabled,delete a.vertexes,delete a.insidePlotArea;var l=charts[n.chartIndex],h=perspective$5(this.vertexes,l,this.insidePlotArea),d=n.toLinePath(h,!0),c=shapeArea$1(h);a.d=d,a.visibility=this.enabled&&c>0?"visible":"hidden"}return SVGElement.prototype.attr.apply(this,arguments)},s.animate=function(a){if(typeof a=="object"&&(defined$a(a.enabled)||defined$a(a.vertexes)||defined$a(a.insidePlotArea))){this.enabled=pick$r(a.enabled,this.enabled),this.vertexes=pick$r(a.vertexes,this.vertexes),this.insidePlotArea=pick$r(a.insidePlotArea,this.insidePlotArea),delete a.enabled,delete a.vertexes,delete a.insidePlotArea;var l=charts[n.chartIndex],h=perspective$5(this.vertexes,l,this.insidePlotArea),d=n.toLinePath(h,!0),c=shapeArea$1(h),f=this.enabled&&c>0?"visible":"hidden";a.d=d,this.attr("visibility",f)}return SVGElement.prototype.animate.apply(this,arguments)},s.attr(t)},r.prototype.polyhedron=function(t){var n=this,s=this.g(),a=s.destroy;return this.styledMode||s.attr({"stroke-linejoin":"round"}),s.faces=[],s.destroy=function(){for(var l=0;l<s.faces.length;l++)s.faces[l].destroy();return a.call(this)},s.attr=function(l,h,d,c){if(typeof l=="object"&&defined$a(l.faces)){for(;s.faces.length>l.faces.length;)s.faces.pop().destroy();for(;s.faces.length<l.faces.length;)s.faces.push(n.face3d().add(s));for(var f=0;f<l.faces.length;f++)n.styledMode&&delete l.faces[f].fill,s.faces[f].attr(l.faces[f],null,d,c);delete l.faces}return SVGElement.prototype.attr.apply(this,arguments)},s.animate=function(l,h,d){if(l&&l.faces){for(;s.faces.length>l.faces.length;)s.faces.pop().destroy();for(;s.faces.length<l.faces.length;)s.faces.push(n.face3d().add(s));for(var c=0;c<l.faces.length;c++)s.faces[c].animate(l.faces[c],h,d);delete l.faces}return SVGElement.prototype.animate.apply(this,arguments)},s.attr(t)},r.prototype.element3d=function(t,n){var s=this.g();return extend$r(s,this.elements3d[t]),s.initArgs(n),s},r.prototype.cuboid=function(t){return this.element3d("cuboid",t)},r.prototype.cuboidPath=function(t){var n=t.x||0,s=t.y||0,a=t.z||0,l=t.height||0,h=t.width||0,d=t.depth||0,c=charts[this.chartIndex],f,u,p,g,m,v,x,y,b,$,S,k,A,P=c.options.chart.options3d,E=P.alpha,M=1e6,C=10,O=100,L=0,T=[{x:n,y:s,z:a},{x:n+h,y:s,z:a},{x:n+h,y:s+l,z:a},{x:n,y:s+l,z:a},{x:n,y:s+l,z:a+d},{x:n+h,y:s+l,z:a+d},{x:n+h,y:s,z:a+d},{x:n,y:s,z:a+d}],_=[],D;T=perspective$5(T,c,t.insidePlotArea);function N(B){return l===0&&B>1&&B<6?{x:T[B].x,y:T[B].y+10,z:T[B].z}:T[0].x===T[7].x&&B>=4?{x:T[B].x+10,y:T[B].y,z:T[B].z}:d===0&&B<2||B>5?{x:T[B].x,y:T[B].y,z:T[B].z+10}:T[B]}function I(B){return T[B]}return D=function(B,X,W){var F=[[],-1],U=B.map(I),z=X.map(I),V=B.map(N),j=X.map(N);return shapeArea$1(U)<0?F=[U,0]:shapeArea$1(z)<0?F=[z,1]:W&&(_.push(W),shapeArea$1(V)<0?F=[U,0]:shapeArea$1(j)<0?F=[z,1]:F=[U,0]),F},f=[3,2,1,0],u=[7,6,5,4],x=D(f,u,"front"),y=x[0],S=x[1],p=[1,6,7,0],g=[4,5,2,3],x=D(p,g,"top"),b=x[0],k=x[1],v=[1,2,5,6],m=[0,7,4,3],x=D(v,m,"side"),$=x[0],A=x[1],A===1?L+=M*(c.plotWidth-n):A||(L+=M*n),L+=C*(!k||E>=0&&E<=180||E<360&&E>357.5?c.plotHeight-s:10+s),S===1?L+=O*a:S||(L+=O*(1e3-a)),{front:this.toLinePath(y,!0),top:this.toLinePath(b,!0),side:this.toLinePath($,!0),zIndexes:{group:Math.round(L)},forcedSides:_,isFront:S,isTop:k}},r.prototype.arc3d=function(t){var n=this.g(),s=n.renderer,a=["x","y","r","innerR","start","end","depth"];function l(h){var d=!1,c={},f;h=merge$o(h);for(f in h)a.indexOf(f)!==-1&&(c[f]=h[f],delete h[f],d=!0);return d?[c,h]:!1}return t=merge$o(t),t.alpha=(t.alpha||0)*deg2rad$2,t.beta=(t.beta||0)*deg2rad$2,n.top=s.path(),n.side1=s.path(),n.side2=s.path(),n.inn=s.path(),n.out=s.path(),n.onAdd=function(){var h=n.parentGroup,d=n.attr("class");n.top.add(n),["out","inn","side1","side2"].forEach(function(c){n[c].attr({class:d+" highcharts-3d-side"}).add(h)})},["addClass","removeClass"].forEach(function(h){n[h]=function(){var d=arguments;["top","out","inn","side1","side2"].forEach(function(c){n[c][h].apply(n[c],d)})}}),n.setPaths=function(h){var d=n.renderer.arc3dPath(h),c=d.zTop*100;n.attribs=h,n.top.attr({d:d.top,zIndex:d.zTop}),n.inn.attr({d:d.inn,zIndex:d.zInn}),n.out.attr({d:d.out,zIndex:d.zOut}),n.side1.attr({d:d.side1,zIndex:d.zSide1}),n.side2.attr({d:d.side2,zIndex:d.zSide2}),n.zIndex=c,n.attr({zIndex:c}),h.center&&(n.top.setRadialReference(h.center),delete h.center)},n.setPaths(t),n.fillSetter=function(h){var d=color$6(h).brighten(-.1).get();return this.fill=h,this.side1.attr({fill:d}),this.side2.attr({fill:d}),this.inn.attr({fill:d}),this.out.attr({fill:d}),this.top.attr({fill:h}),this},["opacity","translateX","translateY","visibility"].forEach(function(h){n[h+"Setter"]=function(d,c){n[c]=d,["out","inn","side1","side2","top"].forEach(function(f){n[f].attr(c,d)})}}),n.attr=function(h){var d,c;return typeof h=="object"&&(c=l(h),c&&(d=c[0],arguments[0]=c[1],extend$r(n.attribs,d),n.setPaths(n.attribs))),SVGElement.prototype.attr.apply(n,arguments)},n.animate=function(h,d,c){var f,u=this.attribs,p,g,m="data-"+Math.random().toString(26).substring(2,9);return delete h.center,delete h.z,delete h.alpha,delete h.beta,g=animObject$1(pick$r(d,this.renderer.globalAnimation)),g.duration&&(f=l(h),n[m]=0,h[m]=1,n[m+"Setter"]=H.noop,f&&(p=f[0],g.step=function(v,x){function y(b){return u[b]+(pick$r(p[b],u[b])-u[b])*x.pos}x.prop===m&&x.elem.setPaths(merge$o(u,{x:y("x"),y:y("y"),r:y("r"),innerR:y("innerR"),start:y("start"),end:y("end"),depth:y("depth")}))}),d=g),SVGElement.prototype.animate.call(this,h,d,c)},n.destroy=function(){return this.top.destroy(),this.out.destroy(),this.inn.destroy(),this.side1.destroy(),this.side2.destroy(),SVGElement.prototype.destroy.call(this)},n.hide=function(){this.top.hide(),this.out.hide(),this.inn.hide(),this.side1.hide(),this.side2.hide()},n.show=function(h){this.top.show(h),this.out.show(h),this.inn.show(h),this.side1.show(h),this.side2.show(h)},n},r.prototype.arc3dPath=function(t){var n=t.x||0,s=t.y||0,a=t.start||0,l=(t.end||0)-1e-5,h=t.r||0,d=t.innerR||0,c=t.depth||0,f=t.alpha||0,u=t.beta||0,p=Math.cos(a),g=Math.sin(a),m=Math.cos(l),v=Math.sin(l),x=h*Math.cos(u),y=h*Math.cos(f),b=d*Math.cos(u),$=d*Math.cos(f),S=c*Math.sin(u),k=c*Math.sin(f),A=[["M",n+x*p,s+y*g]];A=A.concat(r.curveTo(n,s,x,y,a,l,0,0)),A.push(["L",n+b*m,s+$*v]),A=A.concat(r.curveTo(n,s,b,$,l,a,0,0)),A.push(["Z"]);var P=u>0?Math.PI/2:0,E=f>0?0:Math.PI/2,M=a>-P?a:l>-P?-P:a,C=l<PI-E?l:a<PI-E?PI-E:l,O=2*PI-E,L=[["M",n+x*cos(M),s+y*sin(M)]];L=L.concat(r.curveTo(n,s,x,y,M,C,0,0)),l>O&&a<O?(L.push(["L",n+x*cos(C)+S,s+y*sin(C)+k]),L=L.concat(r.curveTo(n,s,x,y,C,O,S,k)),L.push(["L",n+x*cos(O),s+y*sin(O)]),L=L.concat(r.curveTo(n,s,x,y,O,l,0,0)),L.push(["L",n+x*cos(l)+S,s+y*sin(l)+k]),L=L.concat(r.curveTo(n,s,x,y,l,O,S,k)),L.push(["L",n+x*cos(O),s+y*sin(O)]),L=L.concat(r.curveTo(n,s,x,y,O,C,0,0))):l>PI-E&&a<PI-E&&(L.push(["L",n+x*Math.cos(C)+S,s+y*Math.sin(C)+k]),L=L.concat(r.curveTo(n,s,x,y,C,l,S,k)),L.push(["L",n+x*Math.cos(l),s+y*Math.sin(l)]),L=L.concat(r.curveTo(n,s,x,y,l,C,0,0))),L.push(["L",n+x*Math.cos(C)+S,s+y*Math.sin(C)+k]),L=L.concat(r.curveTo(n,s,x,y,C,M,S,k)),L.push(["Z"]);var T=[["M",n+b*p,s+$*g]];T=T.concat(r.curveTo(n,s,b,$,a,l,0,0)),T.push(["L",n+b*Math.cos(l)+S,s+$*Math.sin(l)+k]),T=T.concat(r.curveTo(n,s,b,$,l,a,S,k)),T.push(["Z"]);var _=[["M",n+x*p,s+y*g],["L",n+x*p+S,s+y*g+k],["L",n+b*p+S,s+$*g+k],["L",n+b*p,s+$*g],["Z"]],D=[["M",n+x*m,s+y*v],["L",n+x*m+S,s+y*v+k],["L",n+b*m+S,s+$*v+k],["L",n+b*m,s+$*v],["Z"]],N=Math.atan2(k,-S),I=Math.abs(l+N),B=Math.abs(a+N),X=Math.abs((a+l)/2+N);function W(j){return j=j%(2*Math.PI),j>Math.PI&&(j=2*Math.PI-j),j}I=W(I),B=W(B),X=W(X);var F=1e5,U=X*F,z=B*F,V=I*F;return{top:A,zTop:Math.PI*F+1,out:L,zOut:Math.max(U,z,V),inn:T,zInn:Math.max(U,z,V),side1:_,zSide1:V*.99,side2:D,zSide2:z*.99}},r}(SVGRenderer),color$5=Color.parse,perspective$4=mathModule.perspective,shapeArea3D=mathModule.shapeArea3D,genericDefaultOptions=DefaultOptions.defaultOptions,addEvent$h=Utilities.addEvent,isArray$3=Utilities.isArray,merge$n=Utilities.merge,pick$q=Utilities.pick,wrap$5=Utilities.wrap,Chart3D;(function(o){var r=function(){function m(v){this.frame3d=void 0,this.chart=v}return m.prototype.get3dFrame=function(){var v=this.chart,x=v.options.chart.options3d,y=x.frame,b=v.plotLeft,$=v.plotLeft+v.plotWidth,S=v.plotTop,k=v.plotTop+v.plotHeight,A=0,P=x.depth,E=function(Y){var Z=shapeArea3D(Y,v);return Z>.5?1:Z<-.5?-1:0},M=E([{x:b,y:k,z:P},{x:$,y:k,z:P},{x:$,y:k,z:A},{x:b,y:k,z:A}]),C=E([{x:b,y:S,z:A},{x:$,y:S,z:A},{x:$,y:S,z:P},{x:b,y:S,z:P}]),O=E([{x:b,y:S,z:A},{x:b,y:S,z:P},{x:b,y:k,z:P},{x:b,y:k,z:A}]),L=E([{x:$,y:S,z:P},{x:$,y:S,z:A},{x:$,y:k,z:A},{x:$,y:k,z:P}]),T=E([{x:b,y:k,z:A},{x:$,y:k,z:A},{x:$,y:S,z:A},{x:b,y:S,z:A}]),_=E([{x:b,y:S,z:P},{x:$,y:S,z:P},{x:$,y:k,z:P},{x:b,y:k,z:P}]),D=!1,N=!0,I=!1,B=!1,X=!1,W=!1;[].concat(v.xAxis,v.yAxis,v.zAxis).forEach(function(Y){Y&&(Y.horiz?Y.opposite?B=!0:I=!0:Y.opposite?W=!0:X=!0)});var F=function(Y,Z,et){for(var Q=["size","color","visible"],tt={},rt=0;rt<Q.length;rt++)for(var it=Q[rt],ot=0;ot<Y.length;ot++)if(typeof Y[ot]=="object"){var st=Y[ot][it];if(typeof st<"u"&&st!==null){tt[it]=st;break}}var at=et;return tt.visible===!0||tt.visible===!1?at=tt.visible:tt.visible==="auto"&&(at=Z>0),{size:pick$q(tt.size,1),color:pick$q(tt.color,"none"),frontFacing:Z>0,visible:at}},U={axes:{},bottom:F([y.bottom,y.top,y],M,I),top:F([y.top,y.bottom,y],C,B),left:F([y.left,y.right,y.side,y],O,X),right:F([y.right,y.left,y.side,y],L,W),back:F([y.back,y.front,y],_,N),front:F([y.front,y.back,y],T,D)};if(x.axisLabelPosition==="auto"){var z=function(Y,Z){return Y.visible!==Z.visible||Y.visible&&Z.visible&&Y.frontFacing!==Z.frontFacing},V=[];z(U.left,U.front)&&V.push({y:(S+k)/2,x:b,z:A,xDir:{x:1,y:0,z:0}}),z(U.left,U.back)&&V.push({y:(S+k)/2,x:b,z:P,xDir:{x:0,y:0,z:-1}}),z(U.right,U.front)&&V.push({y:(S+k)/2,x:$,z:A,xDir:{x:0,y:0,z:1}}),z(U.right,U.back)&&V.push({y:(S+k)/2,x:$,z:P,xDir:{x:-1,y:0,z:0}});var j=[];z(U.bottom,U.front)&&j.push({x:(b+$)/2,y:k,z:A,xDir:{x:1,y:0,z:0}}),z(U.bottom,U.back)&&j.push({x:(b+$)/2,y:k,z:P,xDir:{x:-1,y:0,z:0}});var K=[];z(U.top,U.front)&&K.push({x:(b+$)/2,y:S,z:A,xDir:{x:1,y:0,z:0}}),z(U.top,U.back)&&K.push({x:(b+$)/2,y:S,z:P,xDir:{x:-1,y:0,z:0}});var nt=[];z(U.bottom,U.left)&&nt.push({z:(A+P)/2,y:k,x:b,xDir:{x:0,y:0,z:-1}}),z(U.bottom,U.right)&&nt.push({z:(A+P)/2,y:k,x:$,xDir:{x:0,y:0,z:1}});var q=[];z(U.top,U.left)&&q.push({z:(A+P)/2,y:S,x:b,xDir:{x:0,y:0,z:-1}}),z(U.top,U.right)&&q.push({z:(A+P)/2,y:S,x:$,xDir:{x:0,y:0,z:1}});var J=function(Y,Z,et){if(Y.length===0)return null;if(Y.length===1)return Y[0];for(var Q=perspective$4(Y,v,!1),tt=0,rt=1;rt<Q.length;rt++)(et*Q[rt][Z]>et*Q[tt][Z]||et*Q[rt][Z]===et*Q[tt][Z]&&Q[rt].z<Q[tt].z)&&(tt=rt);return Y[tt]};U.axes={y:{left:J(V,"x",-1),right:J(V,"x",1)},x:{top:J(K,"y",-1),bottom:J(j,"y",1)},z:{top:J(q,"y",-1),bottom:J(nt,"y",1)}}}else U.axes={y:{left:{x:b,z:A,xDir:{x:1,y:0,z:0}},right:{x:$,z:A,xDir:{x:0,y:0,z:1}}},x:{top:{y:S,z:A,xDir:{x:1,y:0,z:0}},bottom:{y:k,z:A,xDir:{x:1,y:0,z:0}}},z:{top:{x:X?$:b,y:S,xDir:X?{x:0,y:0,z:1}:{x:0,y:0,z:-1}},bottom:{x:X?$:b,y:k,xDir:X?{x:0,y:0,z:1}:{x:0,y:0,z:-1}}}};return U},m.prototype.getScale=function(v){var x=this.chart,y=x.plotLeft,b=x.plotWidth+y,$=x.plotTop,S=x.plotHeight+$,k=y+x.plotWidth/2,A=$+x.plotHeight/2,P={minX:Number.MAX_VALUE,maxX:-Number.MAX_VALUE,minY:Number.MAX_VALUE,maxY:-Number.MAX_VALUE},E,M=1;return E=[{x:y,y:$,z:0},{x:y,y:$,z:v}],[0,1].forEach(function(C){E.push({x:b,y:E[C].y,z:E[C].z})}),[0,1,2,3].forEach(function(C){E.push({x:E[C].x,y:S,z:E[C].z})}),E=perspective$4(E,x,!1),E.forEach(function(C){P.minX=Math.min(P.minX,C.x),P.maxX=Math.max(P.maxX,C.x),P.minY=Math.min(P.minY,C.y),P.maxY=Math.max(P.maxY,C.y)}),y>P.minX&&(M=Math.min(M,1-Math.abs((y+k)/(P.minX+k))%1)),b<P.maxX&&(M=Math.min(M,(b-k)/(P.maxX-k))),$>P.minY&&(P.minY<0?M=Math.min(M,($+A)/(-P.minY+$+A)):M=Math.min(M,1-($+A)/(P.minY+A)%1)),S<P.maxY&&(M=Math.min(M,Math.abs((S-A)/(P.maxY-A)))),M},m}();o.Composition=r,o.defaultOptions={chart:{options3d:{enabled:!1,alpha:0,beta:0,depth:100,fitToPlot:!0,viewDistance:25,axisLabelPosition:null,frame:{visible:"default",size:1,bottom:{},top:{},left:{},right:{},back:{},front:{}}}}};function t(m,v){var x=m.prototype,y=v.prototype;x.is3d=function(){return!!(this.options.chart.options3d&&this.options.chart.options3d.enabled)},x.propsRequireDirtyBox.push("chart.options3d"),x.propsRequireUpdateSeries.push("chart.options3d"),y.matrixSetter=function(){var b;if(this.pos<1&&(isArray$3(this.start)||isArray$3(this.end))){var $=this.start||[1,0,0,1,0,0],S=this.end||[1,0,0,1,0,0];b=[];for(var k=0;k<6;k++)b.push(this.pos*S[k]+(1-this.pos)*$[k])}else b=this.end;this.elem.attr(this.prop,b,null,!0)},merge$n(!0,genericDefaultOptions,o.defaultOptions),addEvent$h(m,"init",f),addEvent$h(m,"addSeries",n),addEvent$h(m,"afterDrawChartBox",s),addEvent$h(m,"afterGetContainer",a),addEvent$h(m,"afterInit",l),addEvent$h(m,"afterSetChartSize",h),addEvent$h(m,"beforeRedraw",d),addEvent$h(m,"beforeRender",c),wrap$5(x,"isInsidePlot",u),wrap$5(m,"renderSeries",p),wrap$5(m,"setClassName",g)}o.compose=t;function n(m){this.is3d()&&m.options.type==="scatter"&&(m.options.type="scatter3d")}function s(){if(this.chart3d&&this.is3d()){var m=this,v=m.renderer,x=m.options.chart.options3d,y=m.chart3d.get3dFrame(),b=m.plotLeft,$=m.plotLeft+m.plotWidth,S=m.plotTop,k=m.plotTop+m.plotHeight,A=0,P=x.depth,E=b-(y.left.visible?y.left.size:0),M=$+(y.right.visible?y.right.size:0),C=S-(y.top.visible?y.top.size:0),O=k+(y.bottom.visible?y.bottom.size:0),L=A-(y.front.visible?y.front.size:0),T=P+(y.back.visible?y.back.size:0),_=m.hasRendered?"animate":"attr";m.chart3d.frame3d=y,m.frameShapes||(m.frameShapes={bottom:v.polyhedron().add(),top:v.polyhedron().add(),left:v.polyhedron().add(),right:v.polyhedron().add(),back:v.polyhedron().add(),front:v.polyhedron().add()}),m.frameShapes.bottom[_]({class:"highcharts-3d-frame highcharts-3d-frame-bottom",zIndex:y.bottom.frontFacing?-1e3:1e3,faces:[{fill:color$5(y.bottom.color).brighten(.1).get(),vertexes:[{x:E,y:O,z:L},{x:M,y:O,z:L},{x:M,y:O,z:T},{x:E,y:O,z:T}],enabled:y.bottom.visible},{fill:color$5(y.bottom.color).brighten(.1).get(),vertexes:[{x:b,y:k,z:P},{x:$,y:k,z:P},{x:$,y:k,z:A},{x:b,y:k,z:A}],enabled:y.bottom.visible},{fill:color$5(y.bottom.color).brighten(-.1).get(),vertexes:[{x:E,y:O,z:L},{x:E,y:O,z:T},{x:b,y:k,z:P},{x:b,y:k,z:A}],enabled:y.bottom.visible&&!y.left.visible},{fill:color$5(y.bottom.color).brighten(-.1).get(),vertexes:[{x:M,y:O,z:T},{x:M,y:O,z:L},{x:$,y:k,z:A},{x:$,y:k,z:P}],enabled:y.bottom.visible&&!y.right.visible},{fill:color$5(y.bottom.color).get(),vertexes:[{x:M,y:O,z:L},{x:E,y:O,z:L},{x:b,y:k,z:A},{x:$,y:k,z:A}],enabled:y.bottom.visible&&!y.front.visible},{fill:color$5(y.bottom.color).get(),vertexes:[{x:E,y:O,z:T},{x:M,y:O,z:T},{x:$,y:k,z:P},{x:b,y:k,z:P}],enabled:y.bottom.visible&&!y.back.visible}]}),m.frameShapes.top[_]({class:"highcharts-3d-frame highcharts-3d-frame-top",zIndex:y.top.frontFacing?-1e3:1e3,faces:[{fill:color$5(y.top.color).brighten(.1).get(),vertexes:[{x:E,y:C,z:T},{x:M,y:C,z:T},{x:M,y:C,z:L},{x:E,y:C,z:L}],enabled:y.top.visible},{fill:color$5(y.top.color).brighten(.1).get(),vertexes:[{x:b,y:S,z:A},{x:$,y:S,z:A},{x:$,y:S,z:P},{x:b,y:S,z:P}],enabled:y.top.visible},{fill:color$5(y.top.color).brighten(-.1).get(),vertexes:[{x:E,y:C,z:T},{x:E,y:C,z:L},{x:b,y:S,z:A},{x:b,y:S,z:P}],enabled:y.top.visible&&!y.left.visible},{fill:color$5(y.top.color).brighten(-.1).get(),vertexes:[{x:M,y:C,z:L},{x:M,y:C,z:T},{x:$,y:S,z:P},{x:$,y:S,z:A}],enabled:y.top.visible&&!y.right.visible},{fill:color$5(y.top.color).get(),vertexes:[{x:E,y:C,z:L},{x:M,y:C,z:L},{x:$,y:S,z:A},{x:b,y:S,z:A}],enabled:y.top.visible&&!y.front.visible},{fill:color$5(y.top.color).get(),vertexes:[{x:M,y:C,z:T},{x:E,y:C,z:T},{x:b,y:S,z:P},{x:$,y:S,z:P}],enabled:y.top.visible&&!y.back.visible}]}),m.frameShapes.left[_]({class:"highcharts-3d-frame highcharts-3d-frame-left",zIndex:y.left.frontFacing?-1e3:1e3,faces:[{fill:color$5(y.left.color).brighten(.1).get(),vertexes:[{x:E,y:O,z:L},{x:b,y:k,z:A},{x:b,y:k,z:P},{x:E,y:O,z:T}],enabled:y.left.visible&&!y.bottom.visible},{fill:color$5(y.left.color).brighten(.1).get(),vertexes:[{x:E,y:C,z:T},{x:b,y:S,z:P},{x:b,y:S,z:A},{x:E,y:C,z:L}],enabled:y.left.visible&&!y.top.visible},{fill:color$5(y.left.color).brighten(-.1).get(),vertexes:[{x:E,y:O,z:T},{x:E,y:C,z:T},{x:E,y:C,z:L},{x:E,y:O,z:L}],enabled:y.left.visible},{fill:color$5(y.left.color).brighten(-.1).get(),vertexes:[{x:b,y:S,z:P},{x:b,y:k,z:P},{x:b,y:k,z:A},{x:b,y:S,z:A}],enabled:y.left.visible},{fill:color$5(y.left.color).get(),vertexes:[{x:E,y:O,z:L},{x:E,y:C,z:L},{x:b,y:S,z:A},{x:b,y:k,z:A}],enabled:y.left.visible&&!y.front.visible},{fill:color$5(y.left.color).get(),vertexes:[{x:E,y:C,z:T},{x:E,y:O,z:T},{x:b,y:k,z:P},{x:b,y:S,z:P}],enabled:y.left.visible&&!y.back.visible}]}),m.frameShapes.right[_]({class:"highcharts-3d-frame highcharts-3d-frame-right",zIndex:y.right.frontFacing?-1e3:1e3,faces:[{fill:color$5(y.right.color).brighten(.1).get(),vertexes:[{x:M,y:O,z:T},{x:$,y:k,z:P},{x:$,y:k,z:A},{x:M,y:O,z:L}],enabled:y.right.visible&&!y.bottom.visible},{fill:color$5(y.right.color).brighten(.1).get(),vertexes:[{x:M,y:C,z:L},{x:$,y:S,z:A},{x:$,y:S,z:P},{x:M,y:C,z:T}],enabled:y.right.visible&&!y.top.visible},{fill:color$5(y.right.color).brighten(-.1).get(),vertexes:[{x:$,y:S,z:A},{x:$,y:k,z:A},{x:$,y:k,z:P},{x:$,y:S,z:P}],enabled:y.right.visible},{fill:color$5(y.right.color).brighten(-.1).get(),vertexes:[{x:M,y:O,z:L},{x:M,y:C,z:L},{x:M,y:C,z:T},{x:M,y:O,z:T}],enabled:y.right.visible},{fill:color$5(y.right.color).get(),vertexes:[{x:M,y:C,z:L},{x:M,y:O,z:L},{x:$,y:k,z:A},{x:$,y:S,z:A}],enabled:y.right.visible&&!y.front.visible},{fill:color$5(y.right.color).get(),vertexes:[{x:M,y:O,z:T},{x:M,y:C,z:T},{x:$,y:S,z:P},{x:$,y:k,z:P}],enabled:y.right.visible&&!y.back.visible}]}),m.frameShapes.back[_]({class:"highcharts-3d-frame highcharts-3d-frame-back",zIndex:y.back.frontFacing?-1e3:1e3,faces:[{fill:color$5(y.back.color).brighten(.1).get(),vertexes:[{x:M,y:O,z:T},{x:E,y:O,z:T},{x:b,y:k,z:P},{x:$,y:k,z:P}],enabled:y.back.visible&&!y.bottom.visible},{fill:color$5(y.back.color).brighten(.1).get(),vertexes:[{x:E,y:C,z:T},{x:M,y:C,z:T},{x:$,y:S,z:P},{x:b,y:S,z:P}],enabled:y.back.visible&&!y.top.visible},{fill:color$5(y.back.color).brighten(-.1).get(),vertexes:[{x:E,y:O,z:T},{x:E,y:C,z:T},{x:b,y:S,z:P},{x:b,y:k,z:P}],enabled:y.back.visible&&!y.left.visible},{fill:color$5(y.back.color).brighten(-.1).get(),vertexes:[{x:M,y:C,z:T},{x:M,y:O,z:T},{x:$,y:k,z:P},{x:$,y:S,z:P}],enabled:y.back.visible&&!y.right.visible},{fill:color$5(y.back.color).get(),vertexes:[{x:b,y:S,z:P},{x:$,y:S,z:P},{x:$,y:k,z:P},{x:b,y:k,z:P}],enabled:y.back.visible},{fill:color$5(y.back.color).get(),vertexes:[{x:E,y:O,z:T},{x:M,y:O,z:T},{x:M,y:C,z:T},{x:E,y:C,z:T}],enabled:y.back.visible}]}),m.frameShapes.front[_]({class:"highcharts-3d-frame highcharts-3d-frame-front",zIndex:y.front.frontFacing?-1e3:1e3,faces:[{fill:color$5(y.front.color).brighten(.1).get(),vertexes:[{x:E,y:O,z:L},{x:M,y:O,z:L},{x:$,y:k,z:A},{x:b,y:k,z:A}],enabled:y.front.visible&&!y.bottom.visible},{fill:color$5(y.front.color).brighten(.1).get(),vertexes:[{x:M,y:C,z:L},{x:E,y:C,z:L},{x:b,y:S,z:A},{x:$,y:S,z:A}],enabled:y.front.visible&&!y.top.visible},{fill:color$5(y.front.color).brighten(-.1).get(),vertexes:[{x:E,y:C,z:L},{x:E,y:O,z:L},{x:b,y:k,z:A},{x:b,y:S,z:A}],enabled:y.front.visible&&!y.left.visible},{fill:color$5(y.front.color).brighten(-.1).get(),vertexes:[{x:M,y:O,z:L},{x:M,y:C,z:L},{x:$,y:S,z:A},{x:$,y:k,z:A}],enabled:y.front.visible&&!y.right.visible},{fill:color$5(y.front.color).get(),vertexes:[{x:$,y:S,z:A},{x:b,y:S,z:A},{x:b,y:k,z:A},{x:$,y:k,z:A}],enabled:y.front.visible},{fill:color$5(y.front.color).get(),vertexes:[{x:M,y:O,z:L},{x:E,y:O,z:L},{x:E,y:C,z:L},{x:M,y:C,z:L}],enabled:y.front.visible}]})}}function a(){this.styledMode&&(this.renderer.definition({tagName:"style",textContent:`.highcharts-3d-top{filter: url(#highcharts-brighter)}
.highcharts-3d-side{filter: url(#highcharts-darker)}
`}),[{name:"darker",slope:.6},{name:"brighter",slope:1.4}].forEach(function(m){this.renderer.definition({tagName:"filter",attributes:{id:"highcharts-"+m.name},children:[{tagName:"feComponentTransfer",children:[{tagName:"feFuncR",attributes:{type:"linear",slope:m.slope}},{tagName:"feFuncG",attributes:{type:"linear",slope:m.slope}},{tagName:"feFuncB",attributes:{type:"linear",slope:m.slope}}]}]})},this))}function l(){var m=this.options;this.is3d()&&(m.series||[]).forEach(function(v){var x=v.type||m.chart.type||m.chart.defaultSeriesType;x==="scatter"&&(v.type="scatter3d")})}function h(){var m=this,v=m.options.chart.options3d;if(m.chart3d&&m.is3d()){v&&(v.alpha=v.alpha%360+(v.alpha>=0?0:360),v.beta=v.beta%360+(v.beta>=0?0:360));var x=m.inverted,y=m.clipBox,b=m.margin,$=x?"y":"x",S=x?"x":"y",k=x?"height":"width",A=x?"width":"height";y[$]=-(b[3]||0),y[S]=-(b[0]||0),y[k]=m.chartWidth+(b[3]||0)+(b[1]||0),y[A]=m.chartHeight+(b[0]||0)+(b[2]||0),m.scale3d=1,v.fitToPlot===!0&&(m.scale3d=m.chart3d.getScale(v.depth)),m.chart3d.frame3d=m.chart3d.get3dFrame()}}function d(){this.is3d()&&(this.isDirtyBox=!0)}function c(){this.chart3d&&this.is3d()&&(this.chart3d.frame3d=this.chart3d.get3dFrame())}function f(){this.chart3d||(this.chart3d=new r(this))}function u(m){return this.is3d()||m.apply(this,[].slice.call(arguments,1))}function p(m){var v,x=this.series.length;if(this.is3d())for(;x--;)v=this.series[x],v.translate(),v.render();else m.call(this)}function g(m){m.apply(this,[].slice.call(arguments,1)),this.is3d()&&(this.container.className+=" highcharts-3d-chart")}})(Chart3D||(Chart3D={}));const Chart3D$1=Chart3D;var __extends$n=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),addEvent$g=Utilities.addEvent,merge$m=Utilities.merge,pick$p=Utilities.pick,splat$2=Utilities.splat,ZChart=function(){function o(){}return o.compose=function(r){addEvent$g(r,"afterGetAxes",o.onAfterGetAxes);var t=r.prototype;t.addZAxis=o.wrapAddZAxis,t.collectionsWithInit.zAxis=[t.addZAxis],t.collectionsWithUpdate.push("zAxis")},o.onAfterGetAxes=function(){var r=this,t=this.options,n=t.zAxis=splat$2(t.zAxis||{});r.is3d()&&(r.zAxis=[],n.forEach(function(s,a){s.index=a,s.isX=!0,r.addZAxis(s).setScale()}))},o.wrapAddZAxis=function(r){return new ZAxis(this,r)},o}(),ZAxis=function(o){__extends$n(r,o);function r(t,n){var s=o.call(this,t,n)||this;return s.isZAxis=!0,s}return r.prototype.getSeriesExtremes=function(){var t=this,n=t.chart;t.hasVisibleSeries=!1,t.dataMin=t.dataMax=t.ignoreMinPadding=t.ignoreMaxPadding=void 0,t.stacking&&t.stacking.buildStacks(),t.series.forEach(function(s){if(s.visible||!n.options.chart.ignoreHiddenSeries){var a=s.options,l=void 0,h=a.threshold;t.hasVisibleSeries=!0,t.positiveValuesOnly&&h<=0&&(h=void 0),l=s.zData,l.length&&(t.dataMin=Math.min(pick$p(t.dataMin,l[0]),Math.min.apply(null,l)),t.dataMax=Math.max(pick$p(t.dataMax,l[0]),Math.max.apply(null,l)))}})},r.prototype.setAxisSize=function(){var t=this,n=t.chart;o.prototype.setAxisSize.call(this),t.width=t.len=n.options.chart.options3d&&n.options.chart.options3d.depth||0,t.right=n.chartWidth-t.width-t.left},r.prototype.setOptions=function(t){t=merge$m({offset:0,lineWidth:0},t),this.isZAxis=!0,o.prototype.setOptions.call(this,t),this.coll="zAxis"},r.ZChartComposition=ZChart,r}(Axis),addEvent$f=Utilities.addEvent,extend$q=Utilities.extend,wrap$4=Utilities.wrap,Tick3D=function(){function o(){}return o.compose=function(r){addEvent$f(r,"afterGetLabelPosition",o.onAfterGetLabelPosition);var t=r.prototype;wrap$4(t,"getMarkPath",o.wrapGetMarkPath)},o.onAfterGetLabelPosition=function(r){var t=this.axis.axis3D;t&&extend$q(r.pos,t.fix3dPosition(r.pos))},o.wrapGetMarkPath=function(r){this.axis.chart;var t=this.axis.axis3D,n=r.apply(this,[].slice.call(arguments,1));if(t){var s=n[0],a=n[1];if(s[0]==="M"&&a[0]==="L"){var l=[t.fix3dPosition({x:s[1],y:s[2],z:0}),t.fix3dPosition({x:a[1],y:a[2],z:0})];return this.axis.chart.renderer.toLineSegments(l)}}return n},o}(),deg2rad$1=H.deg2rad,perspective$3=mathModule.perspective,perspective3D=mathModule.perspective3D,shapeArea=mathModule.shapeArea,addEvent$e=Utilities.addEvent,merge$l=Utilities.merge,pick$o=Utilities.pick,wrap$3=Utilities.wrap,Axis3DAdditions=function(){function o(r){this.axis=r}return o.prototype.fix3dPosition=function(r,t){var n=this,s=n.axis,a=s.chart;if(s.coll==="colorAxis"||!a.chart3d||!a.is3d())return r;var l=deg2rad$1*a.options.chart.options3d.alpha,h=deg2rad$1*a.options.chart.options3d.beta,d=pick$o(t&&s.options.title.position3d,s.options.labels.position3d),c=pick$o(t&&s.options.title.skew3d,s.options.labels.skew3d),f=a.chart3d.frame3d,u=a.plotLeft,p=a.plotWidth+u,g=a.plotTop,m=a.plotHeight+g,v=0,x=0,y,b={x:0,y:1,z:0},$=!1;if(r=s.axis3D.swapZ({x:r.x,y:r.y,z:0}),s.isZAxis)if(s.opposite){if(f.axes.z.top===null)return{};x=r.y-g,r.x=f.axes.z.top.x,r.y=f.axes.z.top.y,y=f.axes.z.top.xDir,$=!f.top.frontFacing}else{if(f.axes.z.bottom===null)return{};x=r.y-m,r.x=f.axes.z.bottom.x,r.y=f.axes.z.bottom.y,y=f.axes.z.bottom.xDir,$=!f.bottom.frontFacing}else if(s.horiz)if(s.opposite){if(f.axes.x.top===null)return{};x=r.y-g,r.y=f.axes.x.top.y,r.z=f.axes.x.top.z,y=f.axes.x.top.xDir,$=!f.top.frontFacing}else{if(f.axes.x.bottom===null)return{};x=r.y-m,r.y=f.axes.x.bottom.y,r.z=f.axes.x.bottom.z,y=f.axes.x.bottom.xDir,$=!f.bottom.frontFacing}else if(s.opposite){if(f.axes.y.right===null)return{};v=r.x-p,r.x=f.axes.y.right.x,r.z=f.axes.y.right.z,y=f.axes.y.right.xDir,y={x:y.z,y:y.y,z:-y.x}}else{if(f.axes.y.left===null)return{};v=r.x-u,r.x=f.axes.y.left.x,r.z=f.axes.y.left.z,y=f.axes.y.left.xDir}if(d!=="chart")if(d==="flap")if(!s.horiz)y={x:Math.cos(h),y:0,z:Math.sin(h)};else{var S=Math.sin(l),k=Math.cos(l);s.opposite&&(S=-S),$&&(S=-S),b={x:y.z*S,y:k,z:-y.x*S}}else if(d==="ortho")if(!s.horiz)y={x:Math.cos(h),y:0,z:Math.sin(h)};else{var A=Math.sin(l),P=Math.cos(l),E=Math.sin(h),M=Math.cos(h),C={x:E*P,y:-A,z:-P*M};b={x:y.y*C.z-y.z*C.y,y:y.z*C.x-y.x*C.z,z:y.x*C.y-y.y*C.x};var O=1/Math.sqrt(b.x*b.x+b.y*b.y+b.z*b.z);$&&(O=-O),b={x:O*b.x,y:O*b.y,z:O*b.z}}else s.horiz?b={x:Math.sin(h)*Math.sin(l),y:Math.cos(l),z:-Math.cos(h)*Math.sin(l)}:y={x:Math.cos(h),y:0,z:Math.sin(h)};r.x+=v*y.x+x*b.x,r.y+=v*y.y+x*b.y,r.z+=v*y.z+x*b.z;var L=perspective$3([r],s.chart)[0];if(c){var T=shapeArea(perspective$3([r,{x:r.x+y.x,y:r.y+y.y,z:r.z+y.z},{x:r.x+b.x,y:r.y+b.y,z:r.z+b.z}],s.chart))<0;T&&(y={x:-y.x,y:-y.y,z:-y.z});var _=perspective$3([{x:r.x,y:r.y,z:r.z},{x:r.x+y.x,y:r.y+y.y,z:r.z+y.z},{x:r.x+b.x,y:r.y+b.y,z:r.z+b.z}],s.chart);L.matrix=[_[1].x-_[0].x,_[1].y-_[0].y,_[2].x-_[0].x,_[2].y-_[0].y,L.x,L.y],L.matrix[4]-=L.x*L.matrix[0]+L.y*L.matrix[2],L.matrix[5]-=L.x*L.matrix[1]+L.y*L.matrix[3]}return L},o.prototype.swapZ=function(r,t){var n=this.axis;if(n.isZAxis){var s=t?0:n.chart.plotLeft;return{x:s+r.z,y:r.y,z:r.x-s}}return r},o}(),Axis3D=function(){function o(){}return o.compose=function(r){merge$l(!0,r.defaultOptions,o.defaultOptions),r.keepProps.push("axis3D"),addEvent$e(r,"init",o.onInit),addEvent$e(r,"afterSetOptions",o.onAfterSetOptions),addEvent$e(r,"drawCrosshair",o.onDrawCrosshair);var t=r.prototype;wrap$3(t,"getLinePath",o.wrapGetLinePath),wrap$3(t,"getPlotBandPath",o.wrapGetPlotBandPath),wrap$3(t,"getPlotLinePath",o.wrapGetPlotLinePath),wrap$3(t,"getSlotWidth",o.wrapGetSlotWidth),wrap$3(t,"getTitlePosition",o.wrapGetTitlePosition),Tick3D.compose(Tick)},o.onAfterSetOptions=function(){var r=this,t=r.chart,n=r.options;t.is3d&&t.is3d()&&r.coll!=="colorAxis"&&(n.tickWidth=pick$o(n.tickWidth,0),n.gridLineWidth=pick$o(n.gridLineWidth,1))},o.onDrawCrosshair=function(r){var t=this;t.chart.is3d()&&t.coll!=="colorAxis"&&r.point&&(r.point.crosshairPos=t.isXAxis?r.point.axisXpos:t.len-r.point.axisYpos)},o.onInit=function(){var r=this;r.axis3D||(r.axis3D=new Axis3DAdditions(r))},o.wrapGetLinePath=function(r){var t=this;return!t.chart.is3d()||t.coll==="colorAxis"?r.apply(t,[].slice.call(arguments,1)):[]},o.wrapGetPlotBandPath=function(r){if(!this.chart.is3d()||this.coll==="colorAxis")return r.apply(this,[].slice.call(arguments,1));var t=arguments,n=t[1],s=t[2],a=[],l=this.getPlotLinePath({value:n}),h=this.getPlotLinePath({value:s});if(l&&h)for(var d=0;d<l.length;d+=2){var c=l[d],f=l[d+1],u=h[d],p=h[d+1];c[0]==="M"&&f[0]==="L"&&u[0]==="M"&&p[0]==="L"&&a.push(c,f,p,["L",u[1],u[2]],["Z"])}return a},o.wrapGetPlotLinePath=function(r){var t=this,n=t.axis3D,s=t.chart,a=r.apply(t,[].slice.call(arguments,1));if(t.coll==="colorAxis"||!s.chart3d||!s.is3d()||a===null)return a;var l=s.options.chart.options3d,h=t.isZAxis?s.plotWidth:l.depth,d=s.chart3d.frame3d,c=a[0],f=a[1],u,p=[];return c[0]==="M"&&f[0]==="L"&&(u=[n.swapZ({x:c[1],y:c[2],z:0}),n.swapZ({x:c[1],y:c[2],z:h}),n.swapZ({x:f[1],y:f[2],z:0}),n.swapZ({x:f[1],y:f[2],z:h})],this.horiz?this.isZAxis?(d.left.visible&&p.push(u[0],u[2]),d.right.visible&&p.push(u[1],u[3]),d.top.visible&&p.push(u[0],u[1]),d.bottom.visible&&p.push(u[2],u[3])):(d.front.visible&&p.push(u[0],u[2]),d.back.visible&&p.push(u[1],u[3]),d.top.visible&&p.push(u[0],u[1]),d.bottom.visible&&p.push(u[2],u[3])):(d.front.visible&&p.push(u[0],u[2]),d.back.visible&&p.push(u[1],u[3]),d.left.visible&&p.push(u[0],u[1]),d.right.visible&&p.push(u[2],u[3])),p=perspective$3(p,this.chart,!1)),s.renderer.toLineSegments(p)},o.wrapGetSlotWidth=function(r,t){var n=this,s=n.chart,a=n.ticks,l=n.gridGroup;if(n.categories&&s.frameShapes&&s.is3d()&&l&&t&&t.label){var h=l.element.childNodes[0].getBBox(),d=s.frameShapes.left.getBBox(),c=s.options.chart.options3d,f={x:s.plotWidth/2,y:s.plotHeight/2,z:c.depth/2,vd:pick$o(c.depth,1)*pick$o(c.viewDistance,0)},u=t.pos,p=a[u-1],g=a[u+1],m=void 0,v=void 0,x=void 0;return u!==0&&p&&p.label&&p.label.xy&&(v=perspective3D({x:p.label.xy.x,y:p.label.xy.y,z:null},f,f.vd)),g&&g.label&&g.label.xy&&(x=perspective3D({x:g.label.xy.x,y:g.label.xy.y,z:null},f,f.vd)),m={x:t.label.xy.x,y:t.label.xy.y,z:null},m=perspective3D(m,f,f.vd),Math.abs(v?m.x-v.x:x?x.x-m.x:h.x-d.x)}return r.apply(n,[].slice.call(arguments,1))},o.wrapGetTitlePosition=function(r){var t=r.apply(this,[].slice.call(arguments,1));return this.axis3D?this.axis3D.fix3dPosition(t,!0):t},o.defaultOptions={labels:{position3d:"offset",skew3d:!1},title:{position3d:null,skew3d:null}},o}(),__extends$m=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),perspective$2=mathModule.perspective,addEvent$d=Utilities.addEvent,extend$p=Utilities.extend,merge$k=Utilities.merge,pick$n=Utilities.pick,isNumber$9=Utilities.isNumber,Series3D=function(o){__extends$m(r,o);function r(){return o!==null&&o.apply(this,arguments)||this}return r.prototype.translate=function(){o.prototype.translate.apply(this,arguments),this.chart.is3d()&&this.translate3dPoints()},r.prototype.translate3dPoints=function(){var t=this,n=t.options,s=t.chart,a=pick$n(t.zAxis,s.options.zAxis[0]),l=[],h,d,c,f,u,p=[],g=n.stacking?isNumber$9(n.stack)?n.stack:0:t.index||0;for(t.zPadding=g*(n.depth||0+(n.groupZPadding||1)),u=0;u<t.data.length;u++)h=t.data[u],a&&a.translate?(f=a.logarithmic&&a.val2lin?a.val2lin(h.z):h.z,h.plotZ=a.translate(f),h.isInside=h.isInside?f>=a.min&&f<=a.max:!1):h.plotZ=t.zPadding,h.axisXpos=h.plotX,h.axisYpos=h.plotY,h.axisZpos=h.plotZ,l.push({x:h.plotX,y:h.plotY,z:h.plotZ}),p.push(h.plotX||0);for(t.rawPointsX=p,d=perspective$2(l,s,!0),u=0;u<t.data.length;u++)h=t.data[u],c=d[u],h.plotX=c.x,h.plotY=c.y,h.plotZ=c.z},r.defaultOptions=merge$k(Series$e.defaultOptions),r}(Series$e);addEvent$d(Series$e,"afterTranslate",function(){this.chart.is3d()&&this.translate3dPoints()});extend$p(Series$e.prototype,{translate3dPoints:Series3D.prototype.translate3dPoints});var columnProto$1=ColumnSeries$h.prototype,svg$1=H.svg,perspective$1=mathModule.perspective,addEvent$c=Utilities.addEvent,pick$m=Utilities.pick,wrap$2=Utilities.wrap;function retrieveStacks(o,r){var t=o.series,n={totalStacks:0},s,a=1;return t.forEach(function(l){s=pick$m(l.options.stack,r?0:t.length-1-l.index),n[s]?n[s].series.push(l):(n[s]={series:[l],position:a},a++)}),n.totalStacks=a+1,n}wrap$2(columnProto$1,"translate",function(o){o.apply(this,[].slice.call(arguments,1)),this.chart.is3d()&&this.translate3dShapes()});wrap$2(Series$e.prototype,"justifyDataLabel",function(o){return arguments[2].outside3dPlot?!1:o.apply(this,[].slice.call(arguments,1))});columnProto$1.translate3dPoints=function(){};columnProto$1.translate3dShapes=function(){var o=this,r=o.chart,t=o.options,n=t.depth,s=t.stacking?t.stack||0:o.index,a=s*(n+(t.groupZPadding||1)),l=o.borderWidth%2?.5:0,h;r.inverted&&!o.yAxis.reversed&&(l*=-1),t.grouping!==!1&&(a=0),a+=t.groupZPadding||1,o.data.forEach(function(d){if(d.outside3dPlot=null,d.y!==null){var c=d.shapeArgs,f=d.tooltipPos,u=[["x","width"],["y","height"]],p;u.forEach(function(g){if(p=c[g[0]]-l,p<0&&(c[g[1]]+=c[g[0]]+l,c[g[0]]=-l,p=0),p+c[g[1]]>o[g[0]+"Axis"].len&&c[g[1]]!==0&&(c[g[1]]=o[g[0]+"Axis"].len-c[g[0]]),c[g[1]]!==0&&(c[g[0]]>=o[g[0]+"Axis"].len||c[g[0]]+c[g[1]]<=l)){for(var m in c)c[m]=m==="y"?-9999:0;d.outside3dPlot=!0}}),d.shapeType==="rect"&&(d.shapeType="cuboid"),c.z=a,c.depth=n,c.insidePlotArea=!0,h={x:c.x+c.width/2,y:c.y,z:a+n/2},r.inverted&&(h.x=c.height,h.y=d.clientX),d.plot3d=perspective$1([h],r,!0,!1)[0],f=perspective$1([{x:f[0],y:f[1],z:a+n/2}],r,!0,!1)[0],d.tooltipPos=[f.x,f.y]}}),o.z=a};wrap$2(columnProto$1,"animate",function(o){if(!this.chart.is3d())o.apply(this,[].slice.call(arguments,1));else{var r=arguments,t=r[1],n=this.yAxis,s=this,a=this.yAxis.reversed;svg$1&&(t?s.data.forEach(function(l){l.y!==null&&(l.height=l.shapeArgs.height,l.shapey=l.shapeArgs.y,l.shapeArgs.height=1,a||(l.stackY?l.shapeArgs.y=l.plotY+n.translate(l.stackY):l.shapeArgs.y=l.plotY+(l.negative?-l.height:l.height)))}):(s.data.forEach(function(l){l.y!==null&&(l.shapeArgs.height=l.height,l.shapeArgs.y=l.shapey,l.graphic&&l.graphic[l.outside3dPlot?"attr":"animate"](l.shapeArgs,s.options.animation))}),this.drawDataLabels()))}});wrap$2(columnProto$1,"plotGroup",function(o,r,t,n,s,a){return r!=="dataLabelsGroup"&&this.chart.is3d()&&(this[r]&&delete this[r],a&&(this.chart.columnGroup||(this.chart.columnGroup=this.chart.renderer.g("columnGroup").add(a)),this[r]=this.chart.columnGroup,this.chart.columnGroup.attr(this.getPlotBox()),this[r].survive=!0,(r==="group"||r==="markerGroup")&&(arguments[3]="visible"))),o.apply(this,Array.prototype.slice.call(arguments,1))});wrap$2(columnProto$1,"setVisible",function(o,r){var t=this;t.chart.is3d()&&t.data.forEach(function(n){n.visible=n.options.visible=r=typeof r>"u"?!pick$m(t.visible,n.visible):r,t.options.data[t.data.indexOf(n)]=n.options,n.graphic&&n.graphic.attr({visibility:r?"visible":"hidden"})}),o.apply(this,Array.prototype.slice.call(arguments,1))});addEvent$c(ColumnSeries$h,"afterInit",function(){if(this.chart.is3d()){var o=this,r=this.options,t=r.grouping,n=r.stacking,s=this.yAxis.options.reversedStacks,a=0;if(!(typeof t<"u"&&!t)){var l=retrieveStacks(this.chart,n),h=r.stack||0,d=void 0;for(d=0;d<l[h].series.length&&l[h].series[d]!==this;d++);a=10*(l.totalStacks-l[h].position)+(s?d:-d),this.xAxis.reversed||(a=l.totalStacks*10-a)}r.depth=r.depth||25,o.z=o.z||0,r.zIndex=a}});function pointAttribs(o){var r=o.apply(this,[].slice.call(arguments,1));return this.chart.is3d&&this.chart.is3d()&&(r.stroke=this.options.edgeColor||r.fill,r["stroke-width"]=pick$m(this.options.edgeWidth,1)),r}function setState(o,r,t){var n=this.chart.is3d&&this.chart.is3d();n&&(this.options.inactiveOtherPoints=!0),o.call(this,r,t),n&&(this.options.inactiveOtherPoints=!1)}function hasNewShapeType(o){for(var r=[],t=1;t<arguments.length;t++)r[t-1]=arguments[t];return this.series.chart.is3d()?this.graphic&&this.graphic.element.nodeName!=="g":o.apply(this,r)}wrap$2(columnProto$1,"pointAttribs",pointAttribs);wrap$2(columnProto$1,"setState",setState);wrap$2(columnProto$1.pointClass.prototype,"hasNewShapeType",hasNewShapeType);if(SeriesRegistry$1.seriesTypes.columnRange){var columnRangeProto=SeriesRegistry$1.seriesTypes.columnrange.prototype;wrap$2(columnRangeProto,"pointAttribs",pointAttribs),wrap$2(columnRangeProto,"setState",setState),wrap$2(columnRangeProto.pointClass.prototype,"hasNewShapeType",hasNewShapeType),columnRangeProto.plotGroup=columnProto$1.plotGroup,columnRangeProto.setVisible=columnProto$1.setVisible}wrap$2(Series$e.prototype,"alignDataLabel",function(o,r,t,n,s){var a=this.chart;if(n.outside3dPlot=r.outside3dPlot,a.is3d()&&this.is("column")){var l=this,h=l.options,d=pick$m(n.inside,!!l.options.stacking),c=a.options.chart.options3d,f=r.pointWidth/2||0,u={x:s.x+f,y:s.y,z:l.z+h.depth/2};a.inverted&&(d&&(s.width=0,u.x+=r.shapeArgs.height/2),c.alpha>=90&&c.alpha<=270&&(u.y+=r.shapeArgs.width)),u=perspective$1([u],a,!0,!1)[0],s.x=u.x-f,s.y=r.outside3dPlot?-9e9:u.y}o.apply(this,[].slice.call(arguments,1))});wrap$2(StackItem$1.prototype,"getStackBox",function(o,r,t,n,s,a,l,h){var d=o.apply(this,[].slice.call(arguments,1));if(r.is3d()&&t.base){var c=+t.base.split(",")[0],f=r.series[c],u=r.options.chart.options3d;if(f&&f instanceof SeriesRegistry$1.seriesTypes.column){var p={x:d.x+(r.inverted?l:a/2),y:d.y,z:f.options.depth/2};r.inverted&&(d.width=0,u.alpha>=90&&u.alpha<=270&&(p.y+=a)),p=perspective$1([p],r,!0,!1)[0],d.x=p.x-a/2,d.y=p.y}}return d});var __extends$l=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),PiePoint$2=SeriesRegistry$1.seriesTypes.pie.prototype.pointClass,superHaloPath=PiePoint$2.prototype.haloPath,Pie3DPoint=function(o){__extends$l(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.series=void 0,t}return r.prototype.haloPath=function(){return this.series.chart.is3d()?[]:superHaloPath.apply(this,arguments)},r}(PiePoint$2),__extends$k=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),deg2rad=H.deg2rad,svg=H.svg,PieSeries$2=SeriesRegistry$1.seriesTypes.pie,extend$o=Utilities.extend,pick$l=Utilities.pick,Pie3DSeries=function(o){__extends$k(r,o);function r(){return o!==null&&o.apply(this,arguments)||this}return r.prototype.addPoint=function(){o.prototype.addPoint.apply(this,arguments),this.chart.is3d()&&this.update(this.userOptions,!0)},r.prototype.animate=function(t){if(!this.chart.is3d())o.prototype.animate.apply(this,arguments);else{var n=this.options.animation,s=void 0,a=this.center,l=this.group,h=this.markerGroup;svg&&(n===!0&&(n={}),t?(l.oldtranslateX=pick$l(l.oldtranslateX,l.translateX),l.oldtranslateY=pick$l(l.oldtranslateY,l.translateY),s={translateX:a[0],translateY:a[1],scaleX:.001,scaleY:.001},l.attr(s),h&&(h.attrSetters=l.attrSetters,h.attr(s))):(s={translateX:l.oldtranslateX,translateY:l.oldtranslateY,scaleX:1,scaleY:1},l.animate(s,n),h&&h.animate(s,n)))}},r.prototype.drawDataLabels=function(){if(this.chart.is3d()){var t=this,n=t.chart,s=n.options.chart.options3d;t.data.forEach(function(a){var l=a.shapeArgs,h=l.r,d=(l.alpha||s.alpha)*deg2rad,c=(l.beta||s.beta)*deg2rad,f=(l.start+l.end)/2,u=a.labelPosition,p=u.connectorPosition,g=-h*(1-Math.cos(d))*Math.sin(f),m=h*(Math.cos(c)-1)*Math.cos(f);[u.natural,p.breakAt,p.touchingSliceAt].forEach(function(v){v.x+=m,v.y+=g})})}o.prototype.drawDataLabels.apply(this,arguments)},r.prototype.pointAttribs=function(t){var n=o.prototype.pointAttribs.apply(this,arguments),s=this.options;return this.chart.is3d()&&!this.chart.styledMode&&(n.stroke=s.edgeColor||t.color||this.color,n["stroke-width"]=pick$l(s.edgeWidth,1)),n},r.prototype.translate=function(){if(o.prototype.translate.apply(this,arguments),!!this.chart.is3d()){var t=this,n=t.options,s=n.depth||0,a=t.chart.options.chart.options3d,l=a.alpha,h=a.beta,d=n.stacking?(n.stack||0)*s:t._i*s;d+=s/2,n.grouping!==!1&&(d=0),t.data.forEach(function(c){var f=c.shapeArgs,u;c.shapeType="arc3d",f.z=d,f.depth=s*.75,f.alpha=l,f.beta=h,f.center=t.center,u=(f.end+f.start)/2,c.slicedTranslation={translateX:Math.round(Math.cos(u)*n.slicedOffset*Math.cos(l*deg2rad)),translateY:Math.round(Math.sin(u)*n.slicedOffset*Math.cos(l*deg2rad))}})}},r}(PieSeries$2);extend$o(Pie3DSeries.prototype,{pointClass:Pie3DPoint});SeriesRegistry$1.seriesTypes.pie.prototype.pointClass.prototype.haloPath=Pie3DPoint.prototype.haloPath;SeriesRegistry$1.seriesTypes.pie=Pie3DSeries;var __extends$j=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),defined$9=Utilities.defined,Scatter3DPoint=function(o){__extends$j(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return r.prototype.applyOptions=function(){return o.prototype.applyOptions.apply(this,arguments),defined$9(this.z)||(this.z=0),this},r}(ScatterSeries$4.prototype.pointClass),__extends$i=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),pointCameraDistance=mathModule.pointCameraDistance,extend$n=Utilities.extend,merge$j=Utilities.merge,Scatter3DSeries=function(o){__extends$i(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.pointAttribs=function(t){var n=o.prototype.pointAttribs.apply(this,arguments);return this.chart.is3d()&&t&&(n.zIndex=pointCameraDistance(t,this.chart)),n},r.defaultOptions=merge$j(ScatterSeries$4.defaultOptions,{tooltip:{pointFormat:"x: <b>{point.x}</b><br/>y: <b>{point.y}</b><br/>z: <b>{point.z}</b><br/>"}}),r}(ScatterSeries$4);extend$n(Scatter3DSeries.prototype,{axisTypes:["xAxis","yAxis","zAxis"],directTouch:!0,parallelArrays:["x","y","z"],pointArrayMap:["x","y","z"],pointClass:Scatter3DPoint});SeriesRegistry$1.registerSeriesType("scatter3d",Scatter3DSeries);var perspective=mathModule.perspective,_a$6=SeriesRegistry$1.seriesTypes,AreaSeriesClass=_a$6.area,LineSeriesClass=_a$6.line,pick$k=Utilities.pick,wrap$1=Utilities.wrap;wrap$1(AreaSeriesClass.prototype,"getGraphPath",function(o){var r=this,t=o.apply(r,[].slice.call(arguments,1));if(!r.chart.is3d())return t;var n=LineSeriesClass.prototype.getGraphPath,s=r.options,a=s.stacking,l,h=[],d=[],c,f=pick$k(s.connectNulls,a==="percent"),u=Math.round(r.yAxis.getThreshold(s.threshold)),p;if(r.rawPointsX)for(var g=0;g<r.points.length;g++)h.push({x:r.rawPointsX[g],y:s.stacking?r.points[g].yBottom:u,z:r.zPadding});return p=r.chart.options.chart.options3d,h=perspective(h,r.chart,!0).map(function(m){return{plotX:m.x,plotY:m.y,plotZ:m.z}}),r.group&&p&&p.depth&&p.beta&&(r.markerGroup&&(r.markerGroup.add(r.group),r.markerGroup.attr({translateX:0,translateY:0})),r.group.attr({zIndex:Math.max(1,p.beta>270||p.beta<90?p.depth-Math.round(r.zPadding||0):Math.round(r.zPadding||0))})),h.reversed=!0,l=n.call(r,h,!0,!0),l[0]&&l[0][0]==="M"&&(l[0]=["L",l[0][1],l[0][2]]),r.areaPath&&(c=r.areaPath.splice(0,r.areaPath.length/2).concat(l),c.xMap=r.areaPath.xMap,r.areaPath=c,n.call(r,d,!1,f)),t});/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/highcharts-3d
 * @requires highcharts
 *
 * 3D features for Highcharts JS
 *
 * License: www.highcharts.com/license
 */var G$3=H;SVGRenderer3D.compose(G$3.SVGRenderer);Chart3D$1.compose(G$3.Chart,G$3.Fx);ZAxis.ZChartComposition.compose(G$3.Chart);Axis3D.compose(G$3.Axis);var doc$2=H.doc,createElement$1=Utilities.createElement,discardElement$1=Utilities.discardElement,merge$i=Utilities.merge,objectEach$5=Utilities.objectEach;function ajax$1(o){var r=merge$i(!0,{url:!1,type:"get",dataType:"json",success:!1,error:!1,data:!1,headers:{}},o),t={json:"application/json",xml:"application/xml",text:"text/plain",octet:"application/octet-stream"},n=new XMLHttpRequest;function s(a,l){r.error&&r.error(a,l)}if(!r.url)return!1;n.open(r.type.toUpperCase(),r.url,!0),r.headers["Content-Type"]||n.setRequestHeader("Content-Type",t[r.dataType]||t.text),objectEach$5(r.headers,function(a,l){n.setRequestHeader(l,a)}),n.onreadystatechange=function(){var a;if(n.readyState===4){if(n.status===200){if(a=n.responseText,r.dataType==="json")try{a=JSON.parse(a)}catch(l){return s(n,l)}return r.success&&r.success(a)}s(n,n.responseText)}};try{r.data=JSON.stringify(r.data)}catch{}n.send(r.data||!0)}function getJSON(o,r){exports$2.ajax({url:o,success:r,dataType:"json",headers:{"Content-Type":"text/plain"}})}function post(o,r,t){var n=createElement$1("form",merge$i({method:"post",action:o,enctype:"multipart/form-data"},t),{display:"none"},doc$2.body);objectEach$5(r,function(s,a){createElement$1("input",{type:"hidden",name:a,value:s},null,n)}),n.submit(),discardElement$1(n)}var exports$2={ajax:ajax$1,getJSON,post},doc$1=H.doc,ajax=exports$2.ajax,seriesTypes$2=SeriesRegistry$1.seriesTypes,addEvent$b=Utilities.addEvent,defined$8=Utilities.defined,extend$m=Utilities.extend,fireEvent$5=Utilities.fireEvent,isNumber$8=Utilities.isNumber,merge$h=Utilities.merge,objectEach$4=Utilities.objectEach,pick$j=Utilities.pick,splat$1=Utilities.splat,Data=function(){function o(r,t,n){this.chart=void 0,this.chartOptions=void 0,this.firstRowAsNames=void 0,this.rawColumns=void 0,this.options=void 0,this.dateFormats={"YYYY/mm/dd":{regex:/^([0-9]{4})[\-\/\.]([0-9]{1,2})[\-\/\.]([0-9]{1,2})$/,parser:function(s){return s?Date.UTC(+s[1],s[2]-1,+s[3]):NaN}},"dd/mm/YYYY":{regex:/^([0-9]{1,2})[\-\/\.]([0-9]{1,2})[\-\/\.]([0-9]{4})$/,parser:function(s){return s?Date.UTC(+s[3],s[2]-1,+s[1]):NaN},alternative:"mm/dd/YYYY"},"mm/dd/YYYY":{regex:/^([0-9]{1,2})[\-\/\.]([0-9]{1,2})[\-\/\.]([0-9]{4})$/,parser:function(s){return s?Date.UTC(+s[3],s[1]-1,+s[2]):NaN}},"dd/mm/YY":{regex:/^([0-9]{1,2})[\-\/\.]([0-9]{1,2})[\-\/\.]([0-9]{2})$/,parser:function(s){if(!s)return NaN;var a=+s[3],l=new Date;return a>l.getFullYear()-2e3?a+=1900:a+=2e3,Date.UTC(a,s[2]-1,+s[1])},alternative:"mm/dd/YY"},"mm/dd/YY":{regex:/^([0-9]{1,2})[\-\/\.]([0-9]{1,2})[\-\/\.]([0-9]{2})$/,parser:function(s){return s?Date.UTC(+s[3]+2e3,s[1]-1,+s[2]):NaN}}},this.init(r,t,n)}return o.prototype.init=function(r,t,n){var s=r.decimalPoint,a;t&&(this.chartOptions=t),n&&(this.chart=n),s!=="."&&s!==","&&(s=void 0),this.options=r,this.columns=r.columns||this.rowsToColumns(r.rows)||[],this.firstRowAsNames=pick$j(r.firstRowAsNames,this.firstRowAsNames,!0),this.decimalRegex=s&&new RegExp("^(-?[0-9]+)"+s+"([0-9]+)$"),this.rawColumns=[],this.columns.length&&(this.dataFound(),a=!0),this.hasURLOption(r)&&(clearTimeout(this.liveDataTimeout),a=!1),a||(a=this.fetchLiveData()),a||(a=!!this.parseCSV().length),a||(a=!!this.parseTable().length),a||(a=this.parseGoogleSpreadsheet()),!a&&r.afterComplete&&r.afterComplete()},o.prototype.hasURLOption=function(r){return!!(r&&(r.rowsURL||r.csvURL||r.columnsURL))},o.prototype.getColumnDistribution=function(){var r=this.chartOptions,t=this.options,n=[],s=function(g){return(seriesTypes$2[g||"line"].prototype.pointArrayMap||[0]).length},a=function(g){return seriesTypes$2[g||"line"].prototype.pointArrayMap},l=r&&r.chart&&r.chart.type,h=[],d=[],c=0,f=t&&t.seriesMapping||r&&r.series&&r.series.map(function(){return{x:0}})||[],u;(r&&r.series||[]).forEach(function(g){h.push(s(g.type||l))}),f.forEach(function(g){n.push(g.x||0)}),n.length===0&&n.push(0),f.forEach(function(g){var m=new SeriesBuilder,v=h[c]||s(l),x=r&&r.series||[],y=x[c]||{},b=a(y.type||l),$=b||["y"];for((defined$8(g.x)||y.isCartesian||!b)&&m.addColumnReader(g.x,"x"),objectEach$4(g,function(S,k){k!=="x"&&m.addColumnReader(S,k)}),u=0;u<v;u++)m.hasReader($[u])||m.addColumnReader(void 0,$[u]);d.push(m),c++});var p=a(l);typeof p>"u"&&(p=["y"]),this.valueCount={global:s(l),xColumns:n,individual:h,seriesBuilders:d,globalPointArrayMap:p}},o.prototype.dataFound=function(){this.options.switchRowsAndColumns&&(this.columns=this.rowsToColumns(this.columns)),this.getColumnDistribution(),this.parseTypes(),this.parsed()!==!1&&this.complete()},o.prototype.parseCSV=function(r){var t=this,n=r||this.options,s=n.csv,a,l=typeof n.startRow<"u"&&n.startRow?n.startRow:0,h=n.endRow||Number.MAX_VALUE,d=typeof n.startColumn<"u"&&n.startColumn?n.startColumn:0,c=n.endColumn||Number.MAX_VALUE,f,u,p=0,g=[],m={",":0,";":0,"	":0};a=this.columns=[];function v($,S,k,A){var P=0,E="",M="",C="",O="",L=0,T=0;function _(I){E=$[I],M=$[I-1],C=$[I+1]}function D(I){g.length<T+1&&g.push([I]),g[T][g[T].length-1]!==I&&g[T].push(I)}function N(){if(d>L||L>c){++L,O="";return}!isNaN(parseFloat(O))&&isFinite(O)?(O=parseFloat(O),D("number")):isNaN(Date.parse(O))?D("string"):(O=O.replace(/\//g,"-"),D("date")),a.length<T+1&&a.push([]),a[T][S]=O,O="",++T,++L}if($.trim().length&&$.trim()[0]!=="#"){for(;P<$.length;P++)if(_(P),E==='"')for(_(++P);P<$.length&&!(E==='"'&&M!=='"'&&C!=='"');)(E!=='"'||E==='"'&&M!=='"')&&(O+=E),_(++P);else E===f?N():O+=E;N()}}function x($){var S=0,k=0,A=!1;return $.some(function(P,E){var M=!1,C,O,L,T="";if(E>13)return!0;for(var _=0;_<P.length;_++){if(C=P[_],O=P[_+1],L=P[_-1],C==="#")return;if(C==='"')if(M){if(L!=='"'&&O!=='"'){for(;O===" "&&_<P.length;)O=P[++_];typeof m[O]<"u"&&m[O]++,M=!1}}else M=!0;else typeof m[C]<"u"?(T=T.trim(),isNaN(Date.parse(T))?(isNaN(T)||!isFinite(T))&&m[C]++:m[C]++,T=""):T+=C;C===","&&k++,C==="."&&S++}}),m[";"]>m[","]?A=";":(m[","]>m[";"],A=","),n.decimalPoint||(S>k?n.decimalPoint=".":n.decimalPoint=",",t.decimalRegex=new RegExp("^(-?[0-9]+)"+n.decimalPoint+"([0-9]+)$")),A}function y($,S){var k="YYYY/mm/dd",A,P=[],E,M=0,C=!1,O=[],L=[],T;for((!S||S>$.length)&&(S=$.length);M<S;M++)if(typeof $[M]<"u"&&$[M]&&$[M].length)for(A=$[M].trim().replace(/\//g," ").replace(/\-/g," ").replace(/\./g," ").split(" "),P=["","",""],T=0;T<A.length;T++)T<P.length&&(A[T]=parseInt(A[T],10),A[T]&&(L[T]=!L[T]||L[T]<A[T]?A[T]:L[T],typeof O[T]<"u"?O[T]!==A[T]&&(O[T]=!1):O[T]=A[T],A[T]>31?A[T]<100?P[T]="YY":P[T]="YYYY":A[T]>12&&A[T]<=31?(P[T]="dd",C=!0):P[T].length||(P[T]="mm")));if(C){for(T=0;T<O.length;T++)O[T]!==!1?L[T]>12&&P[T]!=="YY"&&P[T]!=="YYYY"&&(P[T]="YY"):L[T]>12&&P[T]==="mm"&&(P[T]="dd");return P.length===3&&P[1]==="dd"&&P[2]==="dd"&&(P[2]="YY"),E=P.join("/"),(n.dateFormats||t.dateFormats)[E]?E:(fireEvent$5("deduceDateFailed"),k)}return k}if(s&&n.beforeParse&&(s=n.beforeParse.call(this,s)),s){u=s.replace(/\r\n/g,`
`).replace(/\r/g,`
`).split(n.lineDelimiter||`
`),(!l||l<0)&&(l=0),(!h||h>=u.length)&&(h=u.length-1),n.itemDelimiter?f=n.itemDelimiter:(f=null,f=x(u));var b=0;for(p=l;p<=h;p++)u[p][0]==="#"?b++:v(u[p],p-l-b);(!n.columnTypes||n.columnTypes.length===0)&&g.length&&g[0].length&&g[0][1]==="date"&&!n.dateFormat&&(n.dateFormat=y(a[0])),this.dataFound()}return a},o.prototype.parseTable=function(){var r=this.options,t=r.table,n=this.columns||[],s=r.startRow||0,a=r.endRow||Number.MAX_VALUE,l=r.startColumn||0,h=r.endColumn||Number.MAX_VALUE;return t&&(typeof t=="string"&&(t=doc$1.getElementById(t)),[].forEach.call(t.getElementsByTagName("tr"),function(d,c){c>=s&&c<=a&&[].forEach.call(d.children,function(f,u){var p=n[u-l],g=1;if((f.tagName==="TD"||f.tagName==="TH")&&u>=l&&u<=h)for(n[u-l]||(n[u-l]=[]),n[u-l][c-s]=f.innerHTML;c-s>=g&&p[c-s-g]===void 0;)p[c-s-g]=null,g++})}),this.dataFound()),n},o.prototype.fetchLiveData=function(){var r=this,t=this.chart,n=this.options,s=3,a=0,l=n.enablePolling,h=(n.dataRefreshRate||2)*1e3,d=merge$h(n);if(!this.hasURLOption(n))return!1;h<1e3&&(h=1e3),delete n.csvURL,delete n.rowsURL,delete n.columnsURL;function c(f){function u(p,g,m){if(!p||!/^(http|\/|\.\/|\.\.\/)/.test(p))return p&&n.error&&n.error("Invalid URL"),!1;f&&(clearTimeout(r.liveDataTimeout),t.liveDataURL=p);function v(){l&&t.liveDataURL===p&&(r.liveDataTimeout=setTimeout(c,h))}return ajax({url:p,dataType:m||"json",success:function(x){t&&t.series&&g(x),v()},error:function(x,y){return++a<s&&v(),n.error&&n.error(y,x)}}),!0}u(d.csvURL,function(p){t.update({data:{csv:p}})},"text")||u(d.rowsURL,function(p){t.update({data:{rows:p}})})||u(d.columnsURL,function(p){t.update({data:{columns:p}})})}return c(!0),this.hasURLOption(n)},o.prototype.parseGoogleSpreadsheet=function(){var r=this,t=this.options,n=t.googleSpreadsheetKey,s=this.chart,a=Math.max((t.dataRefreshRate||2)*1e3,4e3),l=function(){if(t.googleSpreadsheetRange)return t.googleSpreadsheetRange;var d="ABCDEFGHIJKLMNOPQRSTUVWXYZ",c=(d.charAt(t.startColumn||0)||"A")+((t.startRow||0)+1),f=d.charAt(pick$j(t.endColumn,-1))||"ZZ";return defined$8(t.endRow)&&(f+=t.endRow+1),c+":"+f};function h(d){var c=["https://sheets.googleapis.com/v4/spreadsheets",n,"values",l(),"?alt=json&majorDimension=COLUMNS&valueRenderOption=UNFORMATTED_VALUE&dateTimeRenderOption=FORMATTED_STRING&key="+t.googleAPIKey].join("/");ajax({url:c,dataType:"json",success:function(f){d(f),t.enablePolling&&setTimeout(function(){h(d)},a)},error:function(f,u){return t.error&&t.error(u,f)}})}return n&&(delete t.googleSpreadsheetKey,h(function(d){var c=d.values;if(!c||c.length===0)return!1;var f=c.reduce(function(u,p){return Math.max(u,p.length)},0);c.forEach(function(u){for(var p=0;p<f;p++)typeof u[p]>"u"&&(u[p]=null)}),s&&s.series?s.update({data:{columns:c}}):(r.columns=c,r.dataFound())})),!1},o.prototype.trim=function(r,t){return typeof r=="string"&&(r=r.replace(/^\s+|\s+$/g,""),t&&/^[0-9\s]+$/.test(r)&&(r=r.replace(/\s/g,"")),this.decimalRegex&&(r=r.replace(this.decimalRegex,"$1.$2"))),r},o.prototype.parseTypes=function(){for(var r=this.columns,t=r.length;t--;)this.parseColumn(r[t],t)},o.prototype.parseColumn=function(r,t){var n=this.rawColumns,s=this.columns,a=r.length,l,h,d,c,f=this.firstRowAsNames,u=this.valueCount.xColumns.indexOf(t)!==-1,p,g=[],m,v=this.chartOptions,x,y=this.options.columnTypes||[],b=y[t],$=u&&(v&&v.xAxis&&splat$1(v.xAxis)[0].type==="category"||b==="string");for(n[t]||(n[t]=[]);a--;)l=g[a]||r[a],d=this.trim(l),c=this.trim(l,!0),h=parseFloat(c),typeof n[t][a]>"u"&&(n[t][a]=d),$||a===0&&f?r[a]=""+d:+c===h?(r[a]=h,h>365*24*3600*1e3&&b!=="float"?r.isDatetime=!0:r.isNumeric=!0,typeof r[a+1]<"u"&&(x=h>r[a+1])):(d&&d.length&&(p=this.parseDate(l)),u&&isNumber$8(p)&&b!=="float"?(g[a]=l,r[a]=p,r.isDatetime=!0,typeof r[a+1]<"u"&&(m=p>r[a+1],m!==x&&typeof x<"u"&&(this.alternativeFormat?(this.dateFormat=this.alternativeFormat,a=r.length,this.alternativeFormat=this.dateFormats[this.dateFormat].alternative):r.unsorted=!0),x=m)):(r[a]=d===""?null:d,a!==0&&(r.isDatetime||r.isNumeric)&&(r.mixed=!0)));if(u&&r.mixed&&(s[t]=n[t]),u&&x&&this.options.sort)for(t=0;t<s.length;t++)s[t].reverse(),f&&s[t].unshift(s[t].pop())},o.prototype.parseDate=function(r){var t=this.options.parseDate,n,s,a,l=this.options.dateFormat||this.dateFormat,h;if(t)n=t(r);else if(typeof r=="string"){if(l)a=this.dateFormats[l],a||(a=this.dateFormats["YYYY/mm/dd"]),h=r.match(a.regex),h&&(n=a.parser(h));else for(s in this.dateFormats)if(a=this.dateFormats[s],h=r.match(a.regex),h){this.dateFormat=l=s,this.alternativeFormat=a.alternative,n=a.parser(h);break}h||(r.match(/:.+(GMT|UTC|[Z+-])/)&&(r=r.replace(/\s*(?:GMT|UTC)?([+-])(\d\d)(\d\d)$/,"$1$2:$3").replace(/(?:\s+|GMT|UTC)([+-])/,"$1").replace(/(\d)\s*(?:GMT|UTC|Z)$/,"$1+00:00")),h=Date.parse(r),typeof h=="object"&&h!==null&&h.getTime?n=h.getTime()-h.getTimezoneOffset()*6e4:isNumber$8(h)&&(n=h-new Date(h).getTimezoneOffset()*6e4))}return n},o.prototype.rowsToColumns=function(r){var t,n,s,a,l;if(r)for(l=[],n=r.length,t=0;t<n;t++)for(a=r[t].length,s=0;s<a;s++)l[s]||(l[s]=[]),l[s][t]=r[t][s];return l},o.prototype.getData=function(){if(this.columns)return this.rowsToColumns(this.columns).slice(1)},o.prototype.parsed=function(){if(this.options.parsed)return this.options.parsed.call(this,this.columns)},o.prototype.getFreeIndexes=function(r,t){var n,s,a=[],l=[],h;for(s=0;s<r;s=s+1)a.push(!0);for(n=0;n<t.length;n=n+1)for(h=t[n].getReferencedColumnIndexes(),s=0;s<h.length;s=s+1)a[h[s]]=!1;for(s=0;s<a.length;s=s+1)a[s]&&l.push(s);return l},o.prototype.complete=function(){var r=this.columns,t,n=this.options,s,a,l,h,d,c,f,u=[],p,g,m,v;if(r.length,n.complete||n.afterComplete){if(this.firstRowAsNames)for(l=0;l<r.length;l++)r[l].name=r[l].shift();for(s=[],g=this.getFreeIndexes(r.length,this.valueCount.seriesBuilders),c=0;c<this.valueCount.seriesBuilders.length;c++)p=this.valueCount.seriesBuilders[c],p.populateColumns(g)&&u.push(p);for(;g.length>0;){for(p=new SeriesBuilder,p.addColumnReader(0,"x"),v=g.indexOf(0),v!==-1&&g.splice(v,1),l=0;l<this.valueCount.global;l++)p.addColumnReader(void 0,this.valueCount.globalPointArrayMap[l]);p.populateColumns(g)&&u.push(p)}if(u.length>0&&u[0].readers.length>0&&(m=r[u[0].readers[0].columnIndex],typeof m<"u"&&(m.isDatetime?t="datetime":m.isNumeric||(t="category"))),t==="category")for(c=0;c<u.length;c++)for(p=u[c],d=0;d<p.readers.length;d++)p.readers[d].configName==="x"&&(p.readers[d].configName="name");for(c=0;c<u.length;c++){for(p=u[c],a=[],h=0;h<r[0].length;h++)a[h]=p.read(r,h);s[c]={data:a},p.name&&(s[c].name=p.name),t==="category"&&(s[c].turboThreshold=0)}f={series:s},t&&(f.xAxis={type:t},t==="category"&&(f.xAxis.uniqueNames=!1)),n.complete&&n.complete(f),n.afterComplete&&n.afterComplete(f)}},o.prototype.update=function(r,t){var n=this.chart;r&&(r.afterComplete=function(s){s&&(s.xAxis&&n.xAxis[0]&&s.xAxis.type===n.xAxis[0].options.type&&delete s.xAxis,n.update(s,t,!0))},merge$h(!0,n.options.data,r),this.init(n.options.data))},o}();H.data=function(o,r,t){return new H.Data(o,r,t)};addEvent$b(Chart$1,"init",function(o){var r=this,t=o.args[0]||{},n=o.args[1];t&&t.data&&!r.hasDataDef&&(r.hasDataDef=!0,r.data=new H.Data(extend$m(t.data,{afterComplete:function(s){var a,l;if(Object.hasOwnProperty.call(t,"series"))if(typeof t.series=="object")for(a=Math.max(t.series.length,s&&s.series?s.series.length:0);a--;)l=t.series[a]||{},t.series[a]=merge$h(l,s&&s.series?s.series[a]:{});else delete t.series;t=merge$h(s,t),r.init(t,n)}}),t,r),o.preventDefault())});var SeriesBuilder=function(){function o(){this.readers=[],this.pointIsArray=!0,this.name=void 0}return o.prototype.populateColumns=function(r){var t=this,n=!0;return t.readers.forEach(function(s){typeof s.columnIndex>"u"&&(s.columnIndex=r.shift())}),t.readers.forEach(function(s){typeof s.columnIndex>"u"&&(n=!1)}),n},o.prototype.read=function(r,t){var n=this,s=n.pointIsArray,a=s?[]:{},l;return n.readers.forEach(function(h){var d=r[h.columnIndex][t];s?a.push(d):h.configName.indexOf(".")>0?Point$2.prototype.setNestedProperty(a,d,h.configName):a[h.configName]=d}),typeof this.name>"u"&&n.readers.length>=2&&(l=n.getReferencedColumnIndexes(),l.length>=2&&(l.shift(),l.sort(function(h,d){return h-d}),this.name=r[l.shift()].name)),a},o.prototype.addColumnReader=function(r,t){this.readers.push({columnIndex:r,configName:t}),t==="x"||t==="y"||typeof t>"u"||(this.pointIsArray=!1)},o.prototype.getReferencedColumnIndexes=function(){var r,t=[],n;for(r=0;r<this.readers.length;r=r+1)n=this.readers[r],typeof n.columnIndex<"u"&&t.push(n.columnIndex);return t},o.prototype.hasReader=function(r){var t,n;for(t=0;t<this.readers.length;t=t+1)if(n=this.readers[t],n.configName===r)return!0},o}();H.Data=Data;H.Data;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/data
 * @requires highcharts
 *
 * Data module
 *
 * (c) 2012-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$2=H;G$2.HttpUtilities=exports$2;G$2.ajax=exports$2.ajax;G$2.getJSON=exports$2.getJSON;G$2.post=exports$2.post;var animObject=animationExports.animObject,format=FormatUtilities.format,noop$4=H.noop,defaultOptions$2=DefaultOptions.defaultOptions,seriesTypes$1=SeriesRegistry$1.seriesTypes,addEvent$a=Utilities.addEvent,removeEvent$1=Utilities.removeEvent,extend$l=Utilities.extend,fireEvent$4=Utilities.fireEvent,merge$g=Utilities.merge,objectEach$3=Utilities.objectEach,pick$i=Utilities.pick,syncTimeout=Utilities.syncTimeout,PieSeries$1=seriesTypes$1.pie,ddSeriesId=1;extend$l(defaultOptions$2.lang,{drillUpText:"◁ Back to {series.name}"});defaultOptions$2.drilldown={activeAxisLabelStyle:{cursor:"pointer",color:palette.highlightColor100,fontWeight:"bold",textDecoration:"underline"},activeDataLabelStyle:{cursor:"pointer",color:palette.highlightColor100,fontWeight:"bold",textDecoration:"underline"},animation:{duration:500},drillUpButton:{position:{align:"right",x:-10,y:10}}};SVGRenderer.prototype.Element.prototype.fadeIn=function(o){this.attr({opacity:.1,visibility:"inherit"}).animate({opacity:pick$i(this.newOpacity,1)},o||{duration:250})};Chart$1.prototype.addSeriesAsDrilldown=function(o,r){this.addSingleSeriesAsDrilldown(o,r),this.applyDrilldown()};Chart$1.prototype.addSingleSeriesAsDrilldown=function(o,r){var t=o.series,n=t.xAxis,s=t.yAxis,a,l,h=[],d=[],c,f,u,p;p=this.styledMode?{colorIndex:pick$i(o.colorIndex,t.colorIndex)}:{color:o.color||t.color},this.drilldownLevels||(this.drilldownLevels=[]),f=t.options._levelNumber||0,u=this.drilldownLevels[this.drilldownLevels.length-1],u&&u.levelNumber!==f&&(u=void 0),r=extend$l(extend$l({_ddSeriesId:ddSeriesId++},p),r),l=t.points.indexOf(o),t.chart.series.forEach(function(g){g.xAxis===n&&!g.isDrilling&&(g.options._ddSeriesId=g.options._ddSeriesId||ddSeriesId++,g.options._colorIndex=g.userOptions._colorIndex,g.options._levelNumber=g.options._levelNumber||f,u?(h=u.levelSeries,d=u.levelSeriesOptions):(h.push(g),g.purgedOptions=merge$g({_ddSeriesId:g.options._ddSeriesId,_levelNumber:g.options._levelNumber,selected:g.options.selected},g.userOptions),d.push(g.purgedOptions)))}),c=extend$l({levelNumber:f,seriesOptions:t.options,seriesPurgedOptions:t.purgedOptions,levelSeriesOptions:d,levelSeries:h,shapeArgs:o.shapeArgs,bBox:o.graphic?o.graphic.getBBox():{},color:o.isNull?Color.parse(p.color).setOpacity(0).get():p.color,lowerSeriesOptions:r,pointOptions:t.options.data[l],pointIndex:l,oldExtremes:{xMin:n&&n.userMin,xMax:n&&n.userMax,yMin:s&&s.userMin,yMax:s&&s.userMax},resetZoomButton:this.resetZoomButton},p),this.drilldownLevels.push(c),n&&n.names&&(n.names.length=0),a=c.lowerSeries=this.addSeries(r,!1),a.options._levelNumber=f+1,n&&(n.oldPos=n.pos,n.userMin=n.userMax=null,s.userMin=s.userMax=null),t.type===a.type&&(a.animate=a.animateDrilldown||noop$4,a.options.animation=!0)};Chart$1.prototype.applyDrilldown=function(){var o=this.drilldownLevels,r;o&&o.length>0&&(r=o[o.length-1].levelNumber,this.drilldownLevels.forEach(function(t){t.levelNumber===r&&t.levelSeries.forEach(function(n){n.options&&n.options._levelNumber===r&&n.remove(!1)})})),this.resetZoomButton&&(this.resetZoomButton.hide(),delete this.resetZoomButton),this.pointer.reset(),this.redraw(),this.showDrillUpButton(),fireEvent$4(this,"afterDrilldown")};Chart$1.prototype.getDrilldownBackText=function(){var o=this.drilldownLevels,r;if(o&&o.length>0)return r=o[o.length-1],r.series=r.seriesOptions,format(this.options.lang.drillUpText||"",r)};Chart$1.prototype.showDrillUpButton=function(){var o=this,r=this.getDrilldownBackText(),t=o.options.drilldown.drillUpButton,n,s,a=t.relativeTo==="chart"||t.relativeTo==="spacingBox"?null:"scrollablePlotBox";this.drillUpButton?this.drillUpButton.attr({text:r}).align():(n=t.theme,s=n&&n.states,this.drillUpButton=this.renderer.button(r,null,null,function(){o.drillUp()},n,s&&s.hover,s&&s.select).addClass("highcharts-drillup-button").attr({align:t.position.align,zIndex:7}).add().align(t.position,!1,a))};Chart$1.prototype.drillUp=function(){if(!(!this.drilldownLevels||this.drilldownLevels.length===0)){for(var o=this,r=o.drilldownLevels,t=r[r.length-1].levelNumber,n=r.length,s=o.series,a,l,h,d,c,f=function(u){var p;s.forEach(function(g){g.options._ddSeriesId===u._ddSeriesId&&(p=g)}),p=p||o.addSeries(u,!1),p.type===h.type&&p.animateDrillupTo&&(p.animate=p.animateDrillupTo),u===l.seriesPurgedOptions&&(d=p)};n--;)if(l=r[n],l.levelNumber===t){if(r.pop(),h=l.lowerSeries,!h.chart){for(a=s.length;a--;)if(s[a].options.id===l.lowerSeriesOptions.id&&s[a].options._levelNumber===t+1){h=s[a];break}}h.xData=[],l.levelSeriesOptions.forEach(f),fireEvent$4(o,"drillup",{seriesOptions:l.seriesPurgedOptions||l.seriesOptions}),this.resetZoomButton&&this.resetZoomButton.destroy(),d.type===h.type&&(d.drilldownLevel=l,d.options.animation=o.options.drilldown.animation,h.animateDrillupFrom&&h.chart&&h.animateDrillupFrom(l)),d.options._levelNumber=t,h.remove(!1),d.xAxis&&(c=l.oldExtremes,d.xAxis.setExtremes(c.xMin,c.xMax,!1),d.yAxis.setExtremes(c.yMin,c.yMax,!1)),l.resetZoomButton&&(o.resetZoomButton=l.resetZoomButton,o.resetZoomButton.show())}this.redraw(),this.drilldownLevels.length===0?this.drillUpButton=this.drillUpButton.destroy():this.drillUpButton.attr({text:this.getDrilldownBackText()}).align(),this.ddDupes.length=[],fireEvent$4(o,"drillupall")}};addEvent$a(Chart$1,"afterInit",function(){var o=this;o.drilldown={update:function(r,t){merge$g(!0,o.options.drilldown,r),pick$i(t,!0)&&o.redraw()}}});addEvent$a(Chart$1,"afterShowResetZoom",function(){var o=this,r=o.resetZoomButton&&o.resetZoomButton.getBBox(),t=o.options.drilldown&&o.options.drilldown.drillUpButton;this.drillUpButton&&r&&t&&t.position&&t.position.x&&this.drillUpButton.align({x:t.position.x-r.width-10,y:t.position.y,align:t.position.align},!1,t.relativeTo||"plotBox")});addEvent$a(Chart$1,"render",function(){(this.xAxis||[]).forEach(function(o){o.ddPoints={},o.series.forEach(function(r){var t,n=r.xData||[],s=r.points,a;for(t=0;t<n.length;t++)if(a=r.options.data[t],typeof a!="number"&&(a=r.pointClass.prototype.optionsToObject.call({series:r},a),a.drilldown)){o.ddPoints[n[t]]||(o.ddPoints[n[t]]=[]);var l=t-(r.cropStart||0);o.ddPoints[n[t]].push(s&&l>=0&&l<s.length?s[l]:!0)}}),objectEach$3(o.ticks,Tick.prototype.drillable)})});ColumnSeries$h.prototype.animateDrillupTo=function(o){if(!o){var r=this,t=r.drilldownLevel;this.points.forEach(function(n){var s=n.dataLabel;n.graphic&&n.graphic.hide(),s&&(s.hidden=s.attr("visibility")==="hidden",s.hidden||(s.hide(),n.connector&&n.connector.hide()))}),syncTimeout(function(){if(r.points){var n=[];r.data.forEach(function(s){n.push(s)}),r.nodes&&(n=n.concat(r.nodes)),n.forEach(function(s,a){var l=a===(t&&t.pointIndex)?"show":"fadeIn",h=l==="show"?!0:void 0,d=s.dataLabel;s.graphic&&s.graphic[l](h),d&&!d.hidden&&(d.fadeIn(),s.connector&&s.connector.fadeIn())})}},Math.max(this.chart.options.drilldown.animation.duration-50,0)),delete this.animate}};ColumnSeries$h.prototype.animateDrilldown=function(o){var r=this,t=this.chart,n=t.drilldownLevels,s,a=animObject(t.options.drilldown.animation),l=this.xAxis,h=t.styledMode;o||(n.forEach(function(d){r.options._ddSeriesId===d.lowerSeriesOptions._ddSeriesId&&(s=d.shapeArgs,h||(s.fill=d.color))}),s.x+=pick$i(l.oldPos,l.pos)-l.pos,this.points.forEach(function(d){var c=d.shapeArgs;h||(c.fill=d.color),d.graphic&&d.graphic.attr(s).animate(extend$l(d.shapeArgs,{fill:d.color||r.color}),a),d.dataLabel&&d.dataLabel.fadeIn(a)}),delete this.animate)};ColumnSeries$h.prototype.animateDrillupFrom=function(o){var r=animObject(this.chart.options.drilldown.animation),t=this.group,n=t!==this.chart.columnGroup,s=this;s.trackerGroups.forEach(function(a){s[a]&&s[a].on("mouseover")}),n&&delete this.group,this.points.forEach(function(a){var l=a.graphic,h=o.shapeArgs,d=function(){l.destroy(),t&&n&&(t=t.destroy())};l&&h&&(delete a.graphic,s.chart.styledMode||(h.fill=o.color),r.duration?l.animate(h,merge$g(r,{complete:d})):(l.attr(h),d()))})};PieSeries$1&&extend$l(PieSeries$1.prototype,{animateDrillupTo:ColumnSeries$h.prototype.animateDrillupTo,animateDrillupFrom:ColumnSeries$h.prototype.animateDrillupFrom,animateDrilldown:function(o){var r=this.chart.drilldownLevels[this.chart.drilldownLevels.length-1],t=this.chart.options.drilldown.animation;if(this.is("item")&&(t.duration=0),this.center){var n=r.shapeArgs,s=n.start,a=n.end-s,l=a/this.points.length,h=this.chart.styledMode;o||(this.points.forEach(function(d,c){var f=d.shapeArgs;h||(n.fill=r.color,f.fill=d.color),d.graphic&&d.graphic.attr(merge$g(n,{start:s+c*l,end:s+(c+1)*l}))[t?"animate":"attr"](f,t)}),delete this.animate)}}});Point$2.prototype.doDrilldown=function(){this.runDrilldown()};Point$2.prototype.runDrilldown=function(o,r,t){var n=this.series,s=n.chart,a=s.options.drilldown,l=(a.series||[]).length,h;for(s.ddDupes||(s.ddDupes=[]);l--&&!h;)a.series[l].id===this.drilldown&&s.ddDupes.indexOf(this.drilldown)===-1&&(h=a.series[l],s.ddDupes.push(this.drilldown));fireEvent$4(s,"drilldown",{point:this,seriesOptions:h,category:r,originalEvent:t,points:typeof r<"u"&&this.series.xAxis.getDDPoints(r).slice(0)},function(d){var c=d.point.series&&d.point.series.chart,f=d.seriesOptions;c&&f&&(o?c.addSingleSeriesAsDrilldown(d.point,f):c.addSeriesAsDrilldown(d.point,f))})};Axis.prototype.drilldownCategory=function(o,r){this.getDDPoints(o).forEach(function(t){t&&t.series&&t.series.visible&&t.runDrilldown&&t.runDrilldown(!0,o,r)}),this.chart.applyDrilldown()};Axis.prototype.getDDPoints=function(o){return this.ddPoints&&this.ddPoints[o]||[]};Tick.prototype.drillable=function(){var o=this.pos,r=this.label,t=this.axis,n=t.coll==="xAxis"&&t.getDDPoints,s=n&&t.getDDPoints(o),a=t.chart.styledMode;n&&(r&&s&&s.length?(r.drillable=!0,!r.basicStyles&&!a&&(r.basicStyles=merge$g(r.styles)),r.addClass("highcharts-drilldown-axis-label"),r.removeOnDrillableClick&&removeEvent$1(r.element,"click"),r.removeOnDrillableClick=addEvent$a(r.element,"click",function(l){l.preventDefault(),t.drilldownCategory(o,l)}),a||r.css(t.chart.options.drilldown.activeAxisLabelStyle)):r&&r.drillable&&r.removeOnDrillableClick&&(a||(r.styles={},r.css(r.basicStyles)),r.removeOnDrillableClick(),r.removeClass("highcharts-drilldown-axis-label")))};addEvent$a(Point$2,"afterInit",function(){var o=this;return o.drilldown&&!o.unbindDrilldownClick&&(o.unbindDrilldownClick=addEvent$a(o,"click",handlePointClick)),o});addEvent$a(Point$2,"update",function(o){var r=this,t=o.options||{};t.drilldown&&!r.unbindDrilldownClick?r.unbindDrilldownClick=addEvent$a(r,"click",handlePointClick):!t.drilldown&&t.drilldown!==void 0&&r.unbindDrilldownClick&&(r.unbindDrilldownClick=r.unbindDrilldownClick())});var handlePointClick=function(o){var r=this,t=r.series;t.xAxis&&t.chart.options.drilldown.allowPointDrilldown===!1?t.xAxis.drilldownCategory(r.x,o):r.runDrilldown(void 0,void 0,o)};addEvent$a(Series$e,"afterDrawDataLabels",function(){var o=this.chart.options.drilldown.activeDataLabelStyle,r=this.chart.renderer,t=this.chart.styledMode;this.points.forEach(function(n){var s=n.options.dataLabels,a=pick$i(n.dlOptions,s&&s.style,{});n.drilldown&&n.dataLabel&&(o.color==="contrast"&&!t&&(a.color=r.getContrast(n.color||this.color)),s&&s.color&&(a.color=s.color),n.dataLabel.addClass("highcharts-drilldown-data-label"),t||n.dataLabel.css(o).css(a))},this)});var applyCursorCSS=function(o,r,t,n){o[t?"addClass":"removeClass"]("highcharts-drilldown-point"),n||o.css({cursor:r})};addEvent$a(Series$e,"afterDrawTracker",function(){var o=this.chart.styledMode;this.points.forEach(function(r){r.drilldown&&r.graphic&&applyCursorCSS(r.graphic,"pointer",!0,o)})});addEvent$a(Point$2,"afterSetState",function(){var o=this.series.chart.styledMode;this.drilldown&&this.series.halo&&this.state==="hover"?applyCursorCSS(this.series.halo,"pointer",!0,o):this.series.halo&&applyCursorCSS(this.series.halo,"auto",!1,o)});addEvent$a(Chart$1,"selection",function(o){if(o.resetSelection===!0&&this.drillUpButton){var r=this.options.drilldown&&this.options.drilldown.drillUpButton;r&&r.position&&this.drillUpButton.align({x:r.position.x,y:r.position.y,align:r.position.align},!1,r.relativeTo||"plotBox")}});addEvent$a(Chart$1,"drillup",function(){this.resetZoomButton&&(this.resetZoomButton=this.resetZoomButton.destroy())});H.doc;var addEvent$9=Utilities.addEvent,Fullscreen=function(){function o(r){this.chart=r,this.isOpen=!1;var t=r.renderTo;this.browserProps||(typeof t.requestFullscreen=="function"?this.browserProps={fullscreenChange:"fullscreenchange",requestFullscreen:"requestFullscreen",exitFullscreen:"exitFullscreen"}:t.mozRequestFullScreen?this.browserProps={fullscreenChange:"mozfullscreenchange",requestFullscreen:"mozRequestFullScreen",exitFullscreen:"mozCancelFullScreen"}:t.webkitRequestFullScreen?this.browserProps={fullscreenChange:"webkitfullscreenchange",requestFullscreen:"webkitRequestFullScreen",exitFullscreen:"webkitExitFullscreen"}:t.msRequestFullscreen&&(this.browserProps={fullscreenChange:"MSFullscreenChange",requestFullscreen:"msRequestFullscreen",exitFullscreen:"msExitFullscreen"}))}return o.prototype.close=function(){var r=this,t=r.chart,n=t.options.chart;r.isOpen&&r.browserProps&&t.container.ownerDocument instanceof Document&&t.container.ownerDocument[r.browserProps.exitFullscreen](),r.unbindFullscreenEvent&&(r.unbindFullscreenEvent=r.unbindFullscreenEvent()),t.setSize(r.origWidth,r.origHeight,!1),r.origWidth=void 0,r.origHeight=void 0,n.width=r.origWidthOption,n.height=r.origHeightOption,r.origWidthOption=void 0,r.origHeightOption=void 0,r.isOpen=!1,r.setButtonText()},o.prototype.open=function(){var r=this,t=r.chart,n=t.options.chart;if(n&&(r.origWidthOption=n.width,r.origHeightOption=n.height),r.origWidth=t.chartWidth,r.origHeight=t.chartHeight,r.browserProps){var s=addEvent$9(t.container.ownerDocument,r.browserProps.fullscreenChange,function(){r.isOpen?(r.isOpen=!1,r.close()):(t.setSize(null,null,!1),r.isOpen=!0,r.setButtonText())}),a=addEvent$9(t,"destroy",s);r.unbindFullscreenEvent=function(){s(),a()};var l=t.renderTo[r.browserProps.requestFullscreen]();l&&l.catch(function(){alert("Full screen is not supported inside a frame.")})}},o.prototype.setButtonText=function(){var r=this.chart,t=r.exportDivElements,n=r.options.exporting,s=n&&n.buttons&&n.buttons.contextButton.menuItems,a=r.options.lang;if(n&&n.menuItemDefinitions&&a&&a.exitFullscreen&&a.viewFullscreen&&s&&t){var l=t[s.indexOf("viewFullscreen")];l&&AST.setElementHTML(l,this.isOpen?a.exitFullscreen:n.menuItemDefinitions.viewFullscreen.text||a.viewFullscreen)}},o.prototype.toggle=function(){var r=this;r.isOpen?r.close():r.open()},o}();H.Fullscreen=Fullscreen;H.Fullscreen;addEvent$9(Chart$1,"beforeRender",function(){this.fullscreen=new H.Fullscreen(this)});var isTouchDevice=H.isTouchDevice,exporting={type:"image/png",url:"https://export.highcharts.com/",printMaxWidth:780,scale:2,buttons:{contextButton:{className:"highcharts-contextbutton",menuClassName:"highcharts-contextmenu",symbol:"menu",titleKey:"contextButtonTitle",menuItems:["viewFullscreen","printChart","separator","downloadPNG","downloadJPEG","downloadPDF","downloadSVG"]}},menuItemDefinitions:{viewFullscreen:{textKey:"viewFullscreen",onclick:function(){this.fullscreen.toggle()}},printChart:{textKey:"printChart",onclick:function(){this.print()}},separator:{separator:!0},downloadPNG:{textKey:"downloadPNG",onclick:function(){this.exportChart()}},downloadJPEG:{textKey:"downloadJPEG",onclick:function(){this.exportChart({type:"image/jpeg"})}},downloadPDF:{textKey:"downloadPDF",onclick:function(){this.exportChart({type:"application/pdf"})}},downloadSVG:{textKey:"downloadSVG",onclick:function(){this.exportChart({type:"image/svg+xml"})}}}},lang={viewFullscreen:"View in full screen",exitFullscreen:"Exit from full screen",printChart:"Print chart",downloadPNG:"Download PNG image",downloadJPEG:"Download JPEG image",downloadPDF:"Download PDF document",downloadSVG:"Download SVG vector image",contextButtonTitle:"Chart context menu"},navigation={buttonOptions:{symbolSize:14,symbolX:12.5,symbolY:10.5,align:"right",buttonSpacing:3,height:22,verticalAlign:"top",width:24,symbolFill:palette.neutralColor60,symbolStroke:palette.neutralColor60,symbolStrokeWidth:3,theme:{padding:5}},menuStyle:{border:"1px solid "+palette.neutralColor40,background:palette.backgroundColor,padding:"5px 0"},menuItemStyle:{padding:"0.5em 1em",color:palette.neutralColor80,background:"none",fontSize:isTouchDevice?"14px":"11px",transition:"background 250ms, color 250ms"},menuItemHoverStyle:{background:palette.highlightColor80,color:palette.backgroundColor}},ExportingDefaults={exporting,lang,navigation},ExportingSymbols;(function(o){var r=[];function t(a){if(r.indexOf(a)===-1){r.push(a);var l=a.prototype.symbols;l.menu=n,l.menuball=s.bind(l)}}o.compose=t;function n(a,l,h,d){var c=[["M",a,l+2.5],["L",a+h,l+2.5],["M",a,l+d/2+.5],["L",a+h,l+d/2+.5],["M",a,l+d-1.5],["L",a+h,l+d-1.5]];return c}function s(a,l,h,d){var c=d/3-2,f=[];return f=f.concat(this.circle(h-c,l,c,c),this.circle(h-c,l+c+4,c,c),this.circle(h-c,l+2*(c+4),c,c)),f}})(ExportingSymbols||(ExportingSymbols={}));const ExportingSymbols$1=ExportingSymbols;var defaultOptions$1=DefaultOptions.defaultOptions,doc=H.doc,win$1=H.win,addEvent$8=Utilities.addEvent,css$1=Utilities.css,createElement=Utilities.createElement,discardElement=Utilities.discardElement,extend$k=Utilities.extend,find$3=Utilities.find,fireEvent$3=Utilities.fireEvent,isObject$4=Utilities.isObject,merge$f=Utilities.merge,objectEach$2=Utilities.objectEach,pick$h=Utilities.pick,removeEvent=Utilities.removeEvent,uniqueKey=Utilities.uniqueKey,Exporting;(function(o){var r=[],t=[/-/,/^(clipPath|cssText|d|height|width)$/,/^font$/,/[lL]ogical(Width|Height)$/,/perspective/,/TapHighlightColor/,/^transition/,/^length$/],n=["fill","stroke","strokeLinecap","strokeLinejoin","strokeWidth","textAnchor","x","y"];o.inlineWhitelist=[];var s=["clipPath","defs","desc"],a;function l(M){var C=this,O=C.renderer,L=merge$f(C.options.navigation.buttonOptions,M),T=L.onclick,_=L.menuItems,D=L.symbolSize||12,N;if(C.btnCount||(C.btnCount=0),C.exportDivElements||(C.exportDivElements=[],C.exportSVGElements=[]),!(L.enabled===!1||!L.theme)){var I=L.theme,B=I.states,X=B&&B.hover,W=B&&B.select,F;C.styledMode||(I.fill=pick$h(I.fill,palette.backgroundColor),I.stroke=pick$h(I.stroke,"none")),delete I.states,T?F=function(z){z&&z.stopPropagation(),T.call(C,z)}:_&&(F=function(z){z&&z.stopPropagation(),C.contextMenu(U.menuClassName,_,U.translateX,U.translateY,U.width,U.height,U),U.setState(2)}),L.text&&L.symbol?I.paddingLeft=pick$h(I.paddingLeft,30):L.text||extend$k(I,{width:L.width,height:L.height,padding:0}),C.styledMode||(I["stroke-linecap"]="round",I.fill=pick$h(I.fill,palette.backgroundColor),I.stroke=pick$h(I.stroke,"none"));var U=O.button(L.text,0,0,F,I,X,W).addClass(M.className).attr({title:pick$h(C.options.lang[L._titleKey||L.titleKey],"")});U.menuClassName=M.menuClassName||"highcharts-menu-"+C.btnCount++,L.symbol&&(N=O.symbol(L.symbol,L.symbolX-D/2,L.symbolY-D/2,D,D,{width:D,height:D}).addClass("highcharts-button-symbol").attr({zIndex:1}).add(U),C.styledMode||N.attr({stroke:L.symbolStroke,fill:L.symbolFill,"stroke-width":L.symbolStrokeWidth||1})),U.add(C.exportingGroup).align(extend$k(L,{width:U.width,x:pick$h(L.x,C.buttonOffset)}),!0,"spacingBox"),C.buttonOffset+=(U.width+L.buttonSpacing)*(L.align==="right"?-1:1),C.exportSVGElements.push(U,N)}}function h(){var M=this;if(M.printReverseInfo){var C=M.printReverseInfo,O=C.childNodes,L=C.origDisplay,T=C.resetParams;M.moveContainers(M.renderTo),[].forEach.call(O,function(_,D){_.nodeType===1&&(_.style.display=L[D]||"")}),M.isPrinting=!1,T&&M.setSize.apply(M,T),delete M.printReverseInfo,a=void 0,fireEvent$3(M,"afterPrint")}}function d(){var M=this,C=doc.body,O=M.options.exporting.printMaxWidth,L={childNodes:C.childNodes,origDisplay:[],resetParams:void 0};M.isPrinting=!0,M.pointer.reset(null,0),fireEvent$3(M,"beforePrint");var T=O&&M.chartWidth>O;T&&(L.resetParams=[M.options.chart.width,void 0,!1],M.setSize(O,void 0,!1)),[].forEach.call(L.childNodes,function(_,D){_.nodeType===1&&(L.origDisplay[D]=_.style.display,_.style.display="none")}),M.moveContainers(C),M.printReverseInfo=L}function c(M){var C=M;C.renderExporting(),addEvent$8(M,"redraw",C.renderExporting),addEvent$8(M,"destroy",C.destroyExport)}function f(M,C){if(ExportingSymbols$1.compose(C),r.indexOf(M)===-1){r.push(M);var O=M.prototype;O.afterPrint=h,O.exportChart=g,O.inlineStyles=$,O.print=A,O.sanitizeSVG=E,O.getChartHTML=m,O.getSVG=x,O.getSVGForExport=y,O.getFilename=v,O.moveContainers=S,O.beforePrint=d,O.contextMenu=u,O.addButton=l,O.destroyExport=p,O.renderExporting=P,O.callbacks.push(c),addEvent$8(M,"init",k),H.isSafari&&H.win.matchMedia("print").addListener(function(L){a&&(L.matches?a.beforePrint():a.afterPrint())})}}o.compose=f;function u(M,C,O,L,T,_,D){var N=this,I=N.options.navigation,B=N.chartWidth,X=N.chartHeight,W="cache-"+M,F=Math.max(T,_),U,z=N[W];z||(N.exportContextMenu=N[W]=z=createElement("div",{className:M},{position:"absolute",zIndex:1e3,padding:F+"px",pointerEvents:"auto"},N.fixedDiv||N.container),U=createElement("ul",{className:"highcharts-menu"},{listStyle:"none",margin:0,padding:0},z),N.styledMode||css$1(U,extend$k({MozBoxShadow:"3px 3px 10px #888",WebkitBoxShadow:"3px 3px 10px #888",boxShadow:"3px 3px 10px #888"},I.menuStyle)),z.hideMenu=function(){css$1(z,{display:"none"}),D&&D.setState(0),N.openMenu=!1,css$1(N.renderTo,{overflow:"hidden"}),css$1(N.container,{overflow:"hidden"}),Utilities.clearTimeout(z.hideTimer),fireEvent$3(N,"exportMenuHidden")},N.exportEvents.push(addEvent$8(z,"mouseleave",function(){z.hideTimer=win$1.setTimeout(z.hideMenu,500)}),addEvent$8(z,"mouseenter",function(){Utilities.clearTimeout(z.hideTimer)}),addEvent$8(doc,"mouseup",function(j){N.pointer.inClass(j.target,M)||z.hideMenu()}),addEvent$8(z,"click",function(){N.openMenu&&z.hideMenu()})),C.forEach(function(j){if(typeof j=="string"&&(j=N.options.exporting.menuItemDefinitions[j]),isObject$4(j,!0)){var K=void 0;j.separator?K=createElement("hr",void 0,void 0,U):(j.textKey==="viewData"&&N.isDataTableVisible&&(j.textKey="hideData"),K=createElement("li",{className:"highcharts-menu-item",onclick:function(nt){nt&&nt.stopPropagation(),z.hideMenu(),j.onclick&&j.onclick.apply(N,arguments)}},void 0,U),AST.setElementHTML(K,j.text||N.options.lang[j.textKey]),N.styledMode||(K.onmouseover=function(){css$1(this,I.menuItemHoverStyle)},K.onmouseout=function(){css$1(this,I.menuItemStyle)},css$1(K,extend$k({cursor:"pointer"},I.menuItemStyle)))),N.exportDivElements.push(K)}}),N.exportDivElements.push(U,z),N.exportMenuWidth=z.offsetWidth,N.exportMenuHeight=z.offsetHeight);var V={display:"block"};O+N.exportMenuWidth>B?V.right=B-O-T-F+"px":V.left=O-F+"px",L+_+N.exportMenuHeight>X&&D.alignOptions.verticalAlign!=="top"?V.bottom=X-L-F+"px":V.top=L+_-F+"px",css$1(z,V),css$1(N.renderTo,{overflow:""}),css$1(N.container,{overflow:""}),N.openMenu=!0,fireEvent$3(N,"exportMenuShown")}function p(M){var C=M?M.target:this,O=C.exportSVGElements,L=C.exportDivElements,T=C.exportEvents,_;O&&(O.forEach(function(D,N){D&&(D.onclick=D.ontouchstart=null,_="cache-"+D.menuClassName,C[_]&&delete C[_],O[N]=D.destroy())}),O.length=0),C.exportingGroup&&(C.exportingGroup.destroy(),delete C.exportingGroup),L&&(L.forEach(function(D,N){D&&(Utilities.clearTimeout(D.hideTimer),removeEvent(D,"mouseleave"),L[N]=D.onmouseout=D.onmouseover=D.ontouchstart=D.onclick=null,discardElement(D))}),L.length=0),T&&(T.forEach(function(D){D()}),T.length=0)}function g(M,C){var O=this.getSVGForExport(M,C);M=merge$f(this.options.exporting,M),exports$2.post(M.url,{filename:M.filename?M.filename.replace(/\//g,"-"):this.getFilename(),type:M.type,width:M.width||0,scale:M.scale,svg:O},M.formAttributes)}function m(){return this.styledMode&&this.inlineStyles(),this.container.innerHTML}function v(){var M=this.userOptions.title&&this.userOptions.title.text,C=this.options.exporting.filename;return C?C.replace(/\//g,"-"):(typeof M=="string"&&(C=M.toLowerCase().replace(/<\/?[^>]+(>|$)/g,"").replace(/[\s_]+/g,"-").replace(/[^a-z0-9\-]/g,"").replace(/^[\-]+/g,"").replace(/[\-]+/g,"-").substr(0,24).replace(/[\-]+$/g,"")),(!C||C.length<5)&&(C="chart"),C)}function x(M){var C=this,O,L,T=merge$f(C.options,M);T.plotOptions=merge$f(C.userOptions.plotOptions,M&&M.plotOptions),T.time=merge$f(C.userOptions.time,M&&M.time);var _=createElement("div",null,{position:"absolute",top:"-9999em",width:C.chartWidth+"px",height:C.chartHeight+"px"},doc.body),D=C.renderTo.style.width,N=C.renderTo.style.height,I=T.exporting.sourceWidth||T.chart.width||/px$/.test(D)&&parseInt(D,10)||(T.isGantt?800:600),B=T.exporting.sourceHeight||T.chart.height||/px$/.test(N)&&parseInt(N,10)||400;extend$k(T.chart,{animation:!1,renderTo:_,forExport:!0,renderer:"SVGRenderer",width:I,height:B}),T.exporting.enabled=!1,delete T.data,T.series=[],C.series.forEach(function(F){L=merge$f(F.userOptions,{animation:!1,enableMouseTracking:!1,showCheckbox:!1,visible:F.visible}),L.isInternal||T.series.push(L)});var X={};C.axes.forEach(function(F){F.userOptions.internalKey||(F.userOptions.internalKey=uniqueKey()),F.options.isInternal||(X[F.coll]||(X[F.coll]=!0,T[F.coll]=[]),T[F.coll].push(merge$f(F.userOptions,{visible:F.visible})))});var W=new Chart$1(T,C.callback);return M&&["xAxis","yAxis","series"].forEach(function(F){var U={};M[F]&&(U[F]=M[F],W.update(U))}),C.axes.forEach(function(F){var U=find$3(W.axes,function(K){return K.options.internalKey===F.userOptions.internalKey}),z=F.getExtremes(),V=z.userMin,j=z.userMax;U&&(typeof V<"u"&&V!==U.min||typeof j<"u"&&j!==U.max)&&U.setExtremes(V,j,!0,!1)}),O=W.getChartHTML(),fireEvent$3(this,"getSVG",{chartCopy:W}),O=C.sanitizeSVG(O,T),T=null,W.destroy(),discardElement(_),O}function y(M,C){var O=this.options.exporting;return this.getSVG(merge$f({chart:{borderRadius:0}},O.chartOptions,C,{exporting:{sourceWidth:M&&M.sourceWidth||O.sourceWidth,sourceHeight:M&&M.sourceHeight||O.sourceHeight}}))}function b(M){return M.replace(/([A-Z])/g,function(C,O){return"-"+O.toLowerCase()})}function $(){var M=t,C=o.inlineWhitelist,O={},L,T=doc.createElement("iframe");css$1(T,{width:"1px",height:"1px",visibility:"hidden"}),doc.body.appendChild(T);var _=T.contentWindow.document;_.open(),_.write('<svg xmlns="http://www.w3.org/2000/svg"></svg>'),_.close();function D(I){var B,X,W="",F,U,z,V,j;function K(q,J){if(z=V=!1,C.length){for(j=C.length;j--&&!V;)V=C[j].test(J);z=!V}for(J==="transform"&&q==="none"&&(z=!0),j=M.length;j--&&!z;)z=M[j].test(J)||typeof q=="function";z||(X[J]!==q||I.nodeName==="svg")&&O[I.nodeName][J]!==q&&(!n||n.indexOf(J)!==-1?q&&I.setAttribute(b(J),q):W+=b(J)+":"+q+";")}if(I.nodeType===1&&s.indexOf(I.nodeName)===-1){if(B=win$1.getComputedStyle(I,null),X=I.nodeName==="svg"?{}:win$1.getComputedStyle(I.parentNode,null),O[I.nodeName]||(L=_.getElementsByTagName("svg")[0],F=_.createElementNS(I.namespaceURI,I.nodeName),L.appendChild(F),O[I.nodeName]=merge$f(win$1.getComputedStyle(F,null)),I.nodeName==="text"&&delete O.text.fill,L.removeChild(F)),H.isFirefox||H.isMS)for(var nt in B)K(B[nt],nt);else objectEach$2(B,K);if(W&&(U=I.getAttribute("style"),I.setAttribute("style",(U?U+";":"")+W)),I.nodeName==="svg"&&I.setAttribute("stroke-width","1px"),I.nodeName==="text")return;[].forEach.call(I.children||I.childNodes,D)}}function N(){L.parentNode.removeChild(L),T.parentNode.removeChild(T)}D(this.container.querySelector("svg")),N()}function S(M){var C=this;(C.fixedDiv?[C.fixedDiv,C.scrollingContainer]:[C.container]).forEach(function(O){M.appendChild(O)})}function k(){var M=this,C=function(O,L,T){M.isDirtyExporting=!0,merge$f(!0,M.options[O],L),pick$h(T,!0)&&M.redraw()};M.exporting={update:function(O,L){C("exporting",O,L)}},chartNavigation.addUpdate(function(O,L){C("navigation",O,L)},M)}function A(){var M=this;M.isPrinting||(a=M,H.isSafari||M.beforePrint(),setTimeout(function(){win$1.focus(),win$1.print(),H.isSafari||setTimeout(function(){M.afterPrint()},1e3)},1))}function P(){var M=this,C=M.options.exporting,O=C.buttons,L=M.isDirtyExporting||!M.exportSVGElements;M.buttonOffset=0,M.isDirtyExporting&&M.destroyExport(),L&&C.enabled!==!1&&(M.exportEvents=[],M.exportingGroup=M.exportingGroup||M.renderer.g("exporting-group").attr({zIndex:3}).add(),objectEach$2(O,function(T){M.addButton(T)}),M.isDirtyExporting=!1)}function E(M,C){var O=M.indexOf("</svg>")+6,L=M.substr(O);return M=M.substr(0,O),C&&C.exporting&&C.exporting.allowHTML&&L&&(L='<foreignObject x="0" y="0" width="'+C.chart.width+'" height="'+C.chart.height+'"><body xmlns="http://www.w3.org/1999/xhtml">'+L.replace(/(<(?:img|br).*?(?=\>))>/g,"$1 />")+"</body></foreignObject>",M=M.replace("</svg>",L+"</svg>")),M=M.replace(/zIndex="[^"]+"/g,"").replace(/symbolName="[^"]+"/g,"").replace(/jQuery[0-9]+="[^"]+"/g,"").replace(/url\(("|&quot;)(.*?)("|&quot;)\;?\)/g,"url($2)").replace(/url\([^#]+#/g,"url(#").replace(/<svg /,'<svg xmlns:xlink="http://www.w3.org/1999/xlink" ').replace(/ (|NS[0-9]+\:)href=/g," xlink:href=").replace(/\n/," ").replace(/(fill|stroke)="rgba\(([ 0-9]+,[ 0-9]+,[ 0-9]+),([ 0-9\.]+)\)"/g,'$1="rgb($2)" $1-opacity="$3"').replace(/&nbsp;/g," ").replace(/&shy;/g,"­"),this.ieSanitizeSVG&&(M=this.ieSanitizeSVG(M)),M}})(Exporting||(Exporting={}));defaultOptions$1.exporting=merge$f(ExportingDefaults.exporting,defaultOptions$1.exporting);defaultOptions$1.lang=merge$f(ExportingDefaults.lang,defaultOptions$1.lang);defaultOptions$1.navigation=merge$f(ExportingDefaults.navigation,defaultOptions$1.navigation);const Exporting$1=Exporting;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/exporting
 * @requires highcharts
 *
 * Exporting module
 *
 * (c) 2010-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$1=H;G$1.HttpUtilities=exports$2;G$1.ajax=exports$2.ajax;G$1.getJSON=exports$2.getJSON;G$1.post=exports$2.post;Exporting$1.compose(G$1.Chart,G$1.Renderer);var __extends$h=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),noop$3=H.noop,Series$7=SeriesRegistry$1.series,PieSeries=SeriesRegistry$1.seriesTypes.pie,addEvent$7=Utilities.addEvent,extend$j=Utilities.extend,fireEvent$2=Utilities.fireEvent,isArray$2=Utilities.isArray,merge$e=Utilities.merge,pick$g=Utilities.pick,FunnelSeries=function(o){__extends$h(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.alignDataLabel=function(t,n,s,a,l){var h=t.series,d=h.options.reversed,c=t.dlBox||t.shapeArgs,f=s.align,u=s.verticalAlign,p=((h.options||{}).dataLabels||{}).inside,g=h.center[1],m=d?2*g-t.plotY:t.plotY,v=h.getWidthAt(m-c.height/2+n.height),x=u==="middle"?(c.topWidth-c.bottomWidth)/4:(v-c.bottomWidth)/2,y=c.y,b=c.x;u==="middle"?y=c.y-c.height/2+n.height/2:u==="top"&&(y=c.y-c.height+n.height+s.padding),(u==="top"&&!d||u==="bottom"&&d||u==="middle")&&(f==="right"?b=c.x-s.padding+x:f==="left"&&(b=c.x+s.padding-x)),a={x:b,y:d?y-c.height:y,width:c.bottomWidth,height:c.height},s.verticalAlign="bottom",(!p||t.visible)&&Series$7.prototype.alignDataLabel.call(this,t,n,s,a,l),p&&(!t.visible&&t.dataLabel&&(t.dataLabel.placed=!1),t.contrastColor&&n.css({color:t.contrastColor}))},r.prototype.drawDataLabels=function(){var t=this,n=t.data,s=t.options.dataLabels.distance,a,l,h,d=n.length,c,f;for(t.center[2]-=2*s;d--;)h=n[d],a=h.half,l=a?1:-1,f=h.plotY,h.labelDistance=pick$g(h.options.dataLabels&&h.options.dataLabels.distance,s),t.maxLabelDistance=Math.max(h.labelDistance,t.maxLabelDistance||0),c=t.getX(f,a,h),h.labelPosition={natural:{x:0,y:f},final:{},alignment:a?"right":"left",connectorPosition:{breakAt:{x:c+(h.labelDistance-5)*l,y:f},touchingSliceAt:{x:c+h.labelDistance*l,y:f}}};SeriesRegistry$1.seriesTypes[t.options.dataLabels.inside?"column":"pie"].prototype.drawDataLabels.call(this)},r.prototype.translate=function(){var t=0,n=this,s=n.chart,a=n.options,l=a.reversed,h=a.ignoreHiddenPoint,d=s.plotWidth,c=s.plotHeight,f=0,u=a.center,p=D(u[0],d),g=D(u[1],c),m=D(a.width,d),v,x=D(a.height,c),y=D(a.neckWidth,d),b=D(a.neckHeight,c),$=g-x/2+x-b,S=n.data,k,A,P=a.dataLabels.position==="left"?1:0,E,M,C,O,L,T,_;function D(N,I){return/%$/.test(N)?I*parseInt(N,10)/100:parseInt(N,10)}n.getWidthAt=function(N){var I=g-x/2;return N>$||x===b?y:y+(m-y)*(1-(N-I)/(x-b))},n.getX=function(N,I,B){return p+(I?-1:1)*(n.getWidthAt(l?2*g-N:N)/2+B.labelDistance)},n.center=[p,g,x],n.centerX=p,S.forEach(function(N){(!h||N.visible!==!1)&&(t+=N.y)}),S.forEach(function(N){_=null,A=t?N.y/t:0,M=g-x/2+f*x,L=M+A*x,v=n.getWidthAt(M),E=p-v/2,C=E+v,v=n.getWidthAt(L),O=p-v/2,T=O+v,M>$?(E=O=p-y/2,C=T=p+y/2):L>$&&(_=L,v=n.getWidthAt($),O=p-v/2,T=O+v,L=$),l&&(M=2*g-M,L=2*g-L,_!==null&&(_=2*g-_)),k=[["M",E,M],["L",C,M],["L",T,L]],_!==null&&k.push(["L",T,_],["L",O,_]),k.push(["L",O,L],["Z"]),N.shapeType="path",N.shapeArgs={d:k},N.percentage=A*100,N.plotX=p,N.plotY=(M+(_||L))/2,N.tooltipPos=[p,N.plotY],N.dlBox={x:O,y:M,topWidth:C-E,bottomWidth:T-O,height:Math.abs(pick$g(_,L)-M),width:NaN},N.slice=noop$3,N.half=P,(!h||N.visible!==!1)&&(f+=A)}),fireEvent$2(n,"afterTranslate")},r.prototype.sortByAngle=function(t){t.sort(function(n,s){return n.plotY-s.plotY})},r.defaultOptions=merge$e(PieSeries.defaultOptions,{animation:!1,center:["50%","50%"],width:"90%",neckWidth:"30%",height:"100%",neckHeight:"25%",reversed:!1,size:!0,dataLabels:{connectorWidth:1,verticalAlign:"middle"},states:{select:{color:palette.neutralColor20,borderColor:palette.neutralColor100}}}),r}(PieSeries);extend$j(FunnelSeries.prototype,{animate:noop$3});addEvent$7(Chart$1,"afterHideAllOverlappingLabels",function(){this.series.forEach(function(o){var r=o.options&&o.options.dataLabels;isArray$2(r)&&(r=r[0]),o.is("pie")&&o.placeDataLabels&&r&&!r.inside&&o.placeDataLabels()})});SeriesRegistry$1.registerSeriesType("funnel",FunnelSeries);var __extends$g=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),merge$d=Utilities.merge,PyramidSeries=function(o){__extends$g(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.defaultOptions=merge$d(FunnelSeries.defaultOptions,{neckWidth:"0%",neckHeight:"0%",reversed:!0}),r}(FunnelSeries);SeriesRegistry$1.registerSeriesType("pyramid",PyramidSeries);var colorPointMixin$1={setVisible:function(o){var r=this,t=o?"show":"hide";r.visible=r.options.visible=!!o,["graphic","dataLabel"].forEach(function(n){r[n]&&r[n][t]()}),this.series.buildKDTree()}},colorSeriesMixin$1={optionalAxis:"colorAxis",translateColors:function(){var o=this,r=this.data.length?this.data:this.points,t=this.options.nullColor,n=this.colorAxis,s=this.colorKey;r.forEach(function(a){var l=a.getNestedProperty(s),h;h=a.options.color||(a.isNull||a.value===null?t:n&&typeof l<"u"?n.toColor(l,a):a.color||o.color),h&&a.color!==h&&(a.color=h,o.options.legendType==="point"&&a.legendItem&&o.chart.legend.colorizeItem(a,a.visible))})}},exports$1={colorPointMixin:colorPointMixin$1,colorSeriesMixin:colorSeriesMixin$1},color$4=Color.parse,colorPointMixin=exports$1.colorPointMixin,colorSeriesMixin=exports$1.colorSeriesMixin,addEvent$6=Utilities.addEvent,extend$i=Utilities.extend,merge$c=Utilities.merge,pick$f=Utilities.pick,splat=Utilities.splat,ColorAxisComposition;(function(o){var r=[],t;function n(g,m,v,x,y){if(t||(t=g),r.indexOf(m)===-1){r.push(m);var b=m.prototype;b.collectionsWithUpdate.push("colorAxis"),b.collectionsWithInit.colorAxis=[b.addColorAxis],addEvent$6(m,"afterGetAxes",s),f(m)}if(r.indexOf(v)===-1){r.push(v);var $=v.prototype;$.fillSetter=u,$.strokeSetter=p}r.indexOf(x)===-1&&(r.push(x),addEvent$6(x,"afterGetAllItems",a),addEvent$6(x,"afterColorizeItem",l),addEvent$6(x,"afterUpdate",h)),r.indexOf(y)===-1&&(r.push(y),extend$i(y.prototype,colorSeriesMixin),extend$i(y.prototype.pointClass.prototype,colorPointMixin),addEvent$6(y,"afterTranslate",d),addEvent$6(y,"bindAxes",c))}o.compose=n;function s(){var g=this,m=this.options;this.colorAxis=[],m.colorAxis&&(m.colorAxis=splat(m.colorAxis),m.colorAxis.forEach(function(v,x){v.index=x,new t(g,v)}))}function a(g){var m=this,v=this.chart.colorAxis||[],x=function(S){var k=g.allItems.indexOf(S);k!==-1&&(m.destroyItem(g.allItems[k]),g.allItems.splice(k,1))},y=[],b,$;for(v.forEach(function(S){b=S.options,b&&b.showInLegend&&(b.dataClasses&&b.visible?y=y.concat(S.getDataClassLegendSymbols()):b.visible&&y.push(S),S.series.forEach(function(k){(!k.options.showInLegend||b.dataClasses)&&(k.options.legendType==="point"?k.points.forEach(function(A){x(A)}):x(k))}))}),$=y.length;$--;)g.allItems.unshift(y[$])}function l(g){g.visible&&g.item.legendColor&&g.item.legendSymbol.attr({fill:g.item.legendColor})}function h(){var g=this.chart.colorAxis;g&&g.forEach(function(m){m.update({},arguments[2])})}function d(){(this.chart.colorAxis&&this.chart.colorAxis.length||this.colorAttribs)&&this.translateColors()}function c(){var g=this.axisTypes;g?g.indexOf("colorAxis")===-1&&g.push("colorAxis"):this.axisTypes=["colorAxis"]}function f(g){var m=g.prototype.createAxis;g.prototype.createAxis=function(v,x){if(v!=="colorAxis")return m.apply(this,arguments);var y=new t(this,merge$c(x.axis,{index:this[v].length,isX:!1}));return this.isDirtyLegend=!0,this.axes.forEach(function(b){b.series=[]}),this.series.forEach(function(b){b.bindAxes(),b.isDirtyData=!0}),pick$f(x.redraw,!0)&&this.redraw(x.animation),y}}function u(){this.elem.attr("fill",color$4(this.start).tweenTo(color$4(this.end),this.pos),void 0,!0)}function p(){this.elem.attr("stroke",color$4(this.start).tweenTo(color$4(this.end),this.pos),void 0,!0)}})(ColorAxisComposition||(ColorAxisComposition={}));const ColorAxisComposition$1=ColorAxisComposition;var colorAxisDefaults={lineWidth:0,minPadding:0,maxPadding:0,gridLineWidth:1,tickPixelInterval:72,startOnTick:!0,endOnTick:!0,offset:0,marker:{animation:{duration:50},width:.01,color:palette.neutralColor40},labels:{overflow:"justify",rotation:0},minColor:palette.highlightColor10,maxColor:palette.highlightColor100,tickLength:5,showInLegend:!0},__extends$f=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),color$3=Color.parse,noop$2=H.noop,Series$6=SeriesRegistry$1.series,extend$h=Utilities.extend,isNumber$7=Utilities.isNumber,merge$b=Utilities.merge,pick$e=Utilities.pick,ColorAxis=function(o){__extends$f(r,o);function r(t,n){var s=o.call(this,t,n)||this;return s.beforePadding=!1,s.chart=void 0,s.coll="colorAxis",s.dataClasses=void 0,s.legendItem=void 0,s.legendItems=void 0,s.name="",s.options=void 0,s.stops=void 0,s.visible=!0,s.init(t,n),s}return r.compose=function(t,n,s,a){ColorAxisComposition$1.compose(r,t,n,s,a)},r.prototype.init=function(t,n){var s=this,a=t.options.legend||{},l=n.layout?n.layout!=="vertical":a.layout!=="vertical",h=n.visible,d=merge$b(r.defaultColorAxisOptions,n,{showEmpty:!1,title:null,visible:a.enabled&&h!==!1});s.coll="colorAxis",s.side=n.side||l?2:1,s.reversed=n.reversed||!l,s.opposite=!l,o.prototype.init.call(this,t,d),s.userOptions.visible=h,n.dataClasses&&s.initDataClasses(n),s.initStops(),s.horiz=l,s.zoomEnabled=!1},r.prototype.initDataClasses=function(t){var n=this,s=n.chart,a=n.options,l=t.dataClasses.length,h,d=0,c=s.options.chart.colorCount;n.dataClasses=h=[],n.legendItems=[],(t.dataClasses||[]).forEach(function(f,u){var p;f=merge$b(f),h.push(f),!(!s.styledMode&&f.color)&&(a.dataClassColor==="category"?(s.styledMode||(p=s.options.colors,c=p.length,f.color=p[d]),f.colorIndex=d,d++,d===c&&(d=0)):f.color=color$3(a.minColor).tweenTo(color$3(a.maxColor),l<2?.5:u/(l-1)))})},r.prototype.hasData=function(){return!!(this.tickPositions||[]).length},r.prototype.setTickPositions=function(){if(!this.dataClasses)return o.prototype.setTickPositions.call(this)},r.prototype.initStops=function(){var t=this;t.stops=t.options.stops||[[0,t.options.minColor],[1,t.options.maxColor]],t.stops.forEach(function(n){n.color=color$3(n[1])})},r.prototype.setOptions=function(t){var n=this;o.prototype.setOptions.call(this,t),n.options.crosshair=n.options.marker},r.prototype.setAxisSize=function(){var t=this,n=t.legendSymbol,s=t.chart,a=s.options.legend||{},l,h,d,c;n?(this.left=l=n.attr("x"),this.top=h=n.attr("y"),this.width=d=n.attr("width"),this.height=c=n.attr("height"),this.right=s.chartWidth-l-d,this.bottom=s.chartHeight-h-c,this.len=this.horiz?d:c,this.pos=this.horiz?l:h):this.len=(this.horiz?a.symbolWidth:a.symbolHeight)||r.defaultLegendLength},r.prototype.normalizedValue=function(t){var n=this;return n.logarithmic&&(t=n.logarithmic.log2lin(t)),1-(n.max-t)/(n.max-n.min||1)},r.prototype.toColor=function(t,n){var s=this,a=s.dataClasses,l=s.stops,h,d,c,f,u,p;if(a){for(p=a.length;p--;)if(u=a[p],d=u.from,c=u.to,(typeof d>"u"||t>=d)&&(typeof c>"u"||t<=c)){f=u.color,n&&(n.dataClass=p,n.colorIndex=u.colorIndex);break}}else{for(h=s.normalizedValue(t),p=l.length;p--&&!(h>l[p][0]););d=l[p]||l[p+1],c=l[p+1]||d,h=1-(c[0]-h)/(c[0]-d[0]||1),f=d.color.tweenTo(c.color,h)}return f},r.prototype.getOffset=function(){var t=this,n=t.legendGroup,s=t.chart.axisOffset[t.side];n&&(t.axisParent=n,o.prototype.getOffset.call(this),t.added||(t.added=!0,t.labelLeft=0,t.labelRight=t.width),t.chart.axisOffset[t.side]=s)},r.prototype.setLegendColor=function(){var t=this,n=t.horiz,s=t.reversed,a=s?1:0,l=s?0:1,h=n?[a,0,l,0]:[0,l,0,a];t.legendColor={linearGradient:{x1:h[0],y1:h[1],x2:h[2],y2:h[3]},stops:t.stops}},r.prototype.drawLegendSymbol=function(t,n){var s=this,a=t.padding,l=t.options,h=s.horiz,d=pick$e(l.symbolWidth,h?r.defaultLegendLength:12),c=pick$e(l.symbolHeight,h?12:r.defaultLegendLength),f=pick$e(l.labelPadding,h?16:30),u=pick$e(l.itemDistance,10);this.setLegendColor(),n.legendSymbol=this.chart.renderer.rect(0,t.baseline-11,d,c).attr({zIndex:1}).add(n.legendGroup),s.legendItemWidth=d+a+(h?u:f),s.legendItemHeight=c+a+(h?f:0)},r.prototype.setState=function(t){this.series.forEach(function(n){n.setState(t)})},r.prototype.setVisible=function(){},r.prototype.getSeriesExtremes=function(){var t=this,n=t.series,s,a,l,h,d,c,f=n.length,u,p;for(this.dataMin=1/0,this.dataMax=-1/0;f--;){if(c=n[f],a=c.colorKey=pick$e(c.options.colorKey,c.colorKey,c.pointValKey,c.zoneAxis,"y"),h=c.pointArrayMap,d=c[a+"Min"]&&c[a+"Max"],c[a+"Data"])s=c[a+"Data"];else if(!h)s=c.yData;else if(s=[],l=h.indexOf(a),u=c.yData,l>=0&&u)for(p=0;p<u.length;p++)s.push(pick$e(u[p][l],u[p]));if(d)c.minColorValue=c[a+"Min"],c.maxColorValue=c[a+"Max"];else{var g=Series$6.prototype.getExtremes.call(c,s);c.minColorValue=g.dataMin,c.maxColorValue=g.dataMax}typeof c.minColorValue<"u"&&(this.dataMin=Math.min(this.dataMin,c.minColorValue),this.dataMax=Math.max(this.dataMax,c.maxColorValue)),d||Series$6.prototype.applyExtremes.call(c)}},r.prototype.drawCrosshair=function(t,n){var s=this,a=n&&n.plotX,l=n&&n.plotY,h=s.pos,d=s.len,c;n&&(c=s.toPixels(n.getNestedProperty(n.series.colorKey)),c<h?c=h-2:c>h+d&&(c=h+d+2),n.plotX=c,n.plotY=s.len-c,o.prototype.drawCrosshair.call(this,t,n),n.plotX=a,n.plotY=l,s.cross&&!s.cross.addedToColorAxis&&s.legendGroup&&(s.cross.addClass("highcharts-coloraxis-marker").add(s.legendGroup),s.cross.addedToColorAxis=!0,!s.chart.styledMode&&typeof s.crosshair=="object"&&s.cross.attr({fill:s.crosshair.color})))},r.prototype.getPlotLinePath=function(t){var n=this,s=n.left,a=t.translatedValue,l=n.top;return isNumber$7(a)?n.horiz?[["M",a-4,l-6],["L",a+4,l-6],["L",a,l],["Z"]]:[["M",s,a],["L",s-6,a+6],["L",s-6,a-6],["Z"]]:o.prototype.getPlotLinePath.call(this,t)},r.prototype.update=function(t,n){var s=this,a=s.chart,l=a.legend;this.series.forEach(function(h){h.isDirtyData=!0}),(t.dataClasses&&l.allItems||s.dataClasses)&&s.destroyItems(),o.prototype.update.call(this,t,n),s.legendItem&&(s.setLegendColor(),l.colorizeItem(this,!0))},r.prototype.destroyItems=function(){var t=this,n=t.chart;t.legendItem?n.legend.destroyItem(t):t.legendItems&&t.legendItems.forEach(function(s){n.legend.destroyItem(s)}),n.isDirtyLegend=!0},r.prototype.destroy=function(){this.chart.isDirtyLegend=!0,this.destroyItems(),o.prototype.destroy.apply(this,[].slice.call(arguments))},r.prototype.remove=function(t){this.destroyItems(),o.prototype.remove.call(this,t)},r.prototype.getDataClassLegendSymbols=function(){var t=this,n=t.chart,s=t.legendItems,a=n.options.legend,l=a.valueDecimals,h=a.valueSuffix||"",d;return s.length||t.dataClasses.forEach(function(c,f){var u=c.from,p=c.to,g=n.numberFormatter,m=!0;d="",typeof u>"u"?d="< ":typeof p>"u"&&(d="> "),typeof u<"u"&&(d+=g(u,l)+h),typeof u<"u"&&typeof p<"u"&&(d+=" - "),typeof p<"u"&&(d+=g(p,l)+h),s.push(extend$h({chart:n,name:d,options:{},drawLegendSymbol:LegendSymbol$1.drawRectangle,visible:!0,setState:noop$2,isDataClass:!0,setVisible:function(){m=t.visible=!m,t.series.forEach(function(v){v.points.forEach(function(x){x.dataClass===f&&x.setVisible(m)})}),n.legend.colorizeItem(this,m)}},c))}),s},r.defaultColorAxisOptions=colorAxisDefaults,r.defaultLegendLength=200,r.keepProps=["legendGroup","legendItemHeight","legendItemWidth","legendItem","legendSymbol"],r}(Axis);Array.prototype.push.apply(Axis.keepProps,ColorAxis.keepProps);var defined$7=Utilities.defined,addEvent$5=Utilities.addEvent,noop$1=H.noop,seriesTypes=H.seriesTypes;addEvent$5(Point$2,"afterSetState",function(o){var r=this;r.moveToTopOnHover&&r.graphic&&r.graphic.attr({zIndex:o&&o.state==="hover"?1:0})});var colorMapPointMixin$1={dataLabelOnNull:!0,moveToTopOnHover:!0,isValid:function(){return this.value!==null&&this.value!==1/0&&this.value!==-1/0}},colorMapSeriesMixin$2={pointArrayMap:["value"],axisTypes:["xAxis","yAxis","colorAxis"],trackerGroups:["group","markerGroup","dataLabelsGroup"],getSymbol:noop$1,parallelArrays:["x","y","value"],colorKey:"value",pointAttribs:seriesTypes.column.prototype.pointAttribs,colorAttribs:function(o){var r={};return defined$7(o.color)&&(!o.state||o.state==="normal")&&(r[this.colorProp||"fill"]=o.color),r}},exports={colorMapPointMixin:colorMapPointMixin$1,colorMapSeriesMixin:colorMapSeriesMixin$2},__extends$e=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),colorMapPointMixin=exports.colorMapPointMixin,ScatterPoint$1=SeriesRegistry$1.seriesTypes.scatter.prototype.pointClass,clamp$2=Utilities.clamp,extend$g=Utilities.extend,pick$d=Utilities.pick,HeatmapPoint=function(o){__extends$e(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t.value=void 0,t.x=void 0,t.y=void 0,t}return r.prototype.applyOptions=function(t,n){var s=o.prototype.applyOptions.call(this,t,n);return s.formatPrefix=s.isNull||s.value===null?"null":"point",s},r.prototype.getCellAttributes=function(){var t=this,n=t.series,s=n.options,a=(s.colsize||1)/2,l=(s.rowsize||1)/2,h=n.xAxis,d=n.yAxis,c=t.options.marker||n.options.marker,f=n.pointPlacementToXValue(),u=pick$d(t.pointPadding,s.pointPadding,0),p={x1:clamp$2(Math.round(h.len-(h.translate(t.x-a,!1,!0,!1,!0,-f)||0)),-h.len,2*h.len),x2:clamp$2(Math.round(h.len-(h.translate(t.x+a,!1,!0,!1,!0,-f)||0)),-h.len,2*h.len),y1:clamp$2(Math.round(d.translate(t.y-l,!1,!0,!1,!0)||0),-d.len,2*d.len),y2:clamp$2(Math.round(d.translate(t.y+l,!1,!0,!1,!0)||0),-d.len,2*d.len)};return[["width","x"],["height","y"]].forEach(function(g){var m=g[0],v=g[1],x=v+"1",y=v+"2",b=Math.abs(p[x]-p[y]),$=c&&c.lineWidth||0,S=Math.abs(p[x]+p[y])/2;c[m]&&c[m]<b&&(p[x]=S-c[m]/2-$/2,p[y]=S+c[m]/2+$/2),u&&(v==="y"&&(x=y,y=v+"1"),p[x]+=u,p[y]-=u)}),p},r.prototype.haloPath=function(t){if(!t)return[];var n=this.shapeArgs;return["M",n.x-t,n.y-t,"L",n.x-t,n.y+n.height+t,n.x+n.width+t,n.y+n.height+t,n.x+n.width+t,n.y-t,"Z"]},r.prototype.isValid=function(){return this.value!==1/0&&this.value!==-1/0},r}(ScatterPoint$1);extend$g(HeatmapPoint.prototype,{dataLabelOnNull:colorMapPointMixin.dataLabelOnNull,moveToTopOnHover:colorMapPointMixin.moveToTopOnHover});var __extends$d=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),colorMapSeriesMixin$1=exports.colorMapSeriesMixin,Series$5=SeriesRegistry$1.series,_a$5=SeriesRegistry$1.seriesTypes,ColumnSeries$7=_a$5.column,ScatterSeries$1=_a$5.scatter,symbols$1=SVGRenderer.prototype.symbols,extend$f=Utilities.extend,fireEvent$1=Utilities.fireEvent,isNumber$6=Utilities.isNumber,merge$a=Utilities.merge,pick$c=Utilities.pick,HeatmapSeries$1=function(o){__extends$d(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.colorAxis=void 0,t.data=void 0,t.options=void 0,t.points=void 0,t.valueMax=NaN,t.valueMin=NaN,t}return r.prototype.drawPoints=function(){var t=this,n=this.options.marker||{};(n.enabled||this._hasPointMarkers)&&(Series$5.prototype.drawPoints.call(this),this.points.forEach(function(s){s.graphic&&(s.graphic[t.chart.styledMode?"css":"animate"](t.colorAttribs(s)),t.options.borderRadius&&s.graphic.attr({r:t.options.borderRadius}),s.value===null&&s.graphic.addClass("highcharts-null-point"))}))},r.prototype.getExtremes=function(){var t=Series$5.prototype.getExtremes.call(this,this.valueData),n=t.dataMin,s=t.dataMax;return isNumber$6(n)&&(this.valueMin=n),isNumber$6(s)&&(this.valueMax=s),Series$5.prototype.getExtremes.call(this)},r.prototype.getValidPoints=function(t,n){return Series$5.prototype.getValidPoints.call(this,t,n,!0)},r.prototype.hasData=function(){return!!this.processedXData.length},r.prototype.init=function(){var t;Series$5.prototype.init.apply(this,arguments),t=this.options,t.pointRange=pick$c(t.pointRange,t.colsize||1),this.yAxis.axisPointRange=t.rowsize||1,symbols$1.ellipse=symbols$1.circle},r.prototype.markerAttribs=function(t,n){var s=t.marker||{},a=this.options.marker||{},l,h,d=t.shapeArgs||{},c=t.hasImage,f={};return c?{x:t.plotX,y:t.plotY}:(n&&(l=a.states[n]||{},h=s.states&&s.states[n]||{},[["width","x"],["height","y"]].forEach(function(u){f[u[0]]=(h[u[0]]||l[u[0]]||d[u[0]])+(h[u[0]+"Plus"]||l[u[0]+"Plus"]||0),f[u[1]]=d[u[1]]+(d[u[0]]-f[u[0]])/2})),n?f:d)},r.prototype.pointAttribs=function(t,n){var s=this,a=Series$5.prototype.pointAttribs.call(s,t,n),l=s.options||{},h=s.chart.options.plotOptions||{},d=h.series||{},c=h.heatmap||{},f,u,p=t&&t.options.borderColor||l.borderColor||c.borderColor||d.borderColor,g=t&&t.options.borderWidth||l.borderWidth||c.borderWidth||d.borderWidth||a["stroke-width"];return a.stroke=t&&t.marker&&t.marker.lineColor||l.marker&&l.marker.lineColor||p||this.color,a["stroke-width"]=g,n&&(f=merge$a(l.states[n],l.marker&&l.marker.states[n],t&&t.options.states&&t.options.states[n]||{}),u=f.brightness,a.fill=f.color||Color.parse(a.fill).brighten(u||0).get(),a.stroke=f.lineColor),a},r.prototype.setClip=function(t){var n=this,s=n.chart;Series$5.prototype.setClip.apply(n,arguments),(n.options.clip!==!1||t)&&n.markerGroup.clip((t||n.clipBox)&&n.sharedClipKey?s.sharedClips[n.sharedClipKey]:s.clipRect)},r.prototype.translate=function(){var t=this,n=t.options,s=n.marker&&n.marker.symbol||"rect",a=symbols$1[s]?s:"rect",l=["circle","square"].indexOf(a)!==-1;t.generatePoints(),t.points.forEach(function(h){var d,c,f,u=h.getCellAttributes(),p={};p.x=Math.min(u.x1,u.x2),p.y=Math.min(u.y1,u.y2),p.width=Math.max(Math.abs(u.x2-u.x1),0),p.height=Math.max(Math.abs(u.y2-u.y1),0),f=h.hasImage=(h.marker&&h.marker.symbol||s).indexOf("url")===0,l&&(c=Math.abs(p.width-p.height),p.x=Math.min(u.x1,u.x2)+(p.width<p.height?0:c/2),p.y=Math.min(u.y1,u.y2)+(p.width<p.height?c/2:0),p.width=p.height=Math.min(p.width,p.height)),d={plotX:(u.x1+u.x2)/2,plotY:(u.y1+u.y2)/2,clientX:(u.x1+u.x2)/2,shapeType:"path",shapeArgs:merge$a(!0,p,{d:symbols$1[a](p.x,p.y,p.width,p.height)})},f&&(h.marker={width:p.width,height:p.height}),extend$f(h,d)}),fireEvent$1(t,"afterTranslate")},r.defaultOptions=merge$a(ScatterSeries$1.defaultOptions,{animation:!1,borderRadius:0,borderWidth:0,nullColor:palette.neutralColor3,dataLabels:{formatter:function(){var t=this.series.chart.numberFormatter,n=this.point.value;return isNumber$6(n)?t(n,-1):""},inside:!0,verticalAlign:"middle",crop:!1,overflow:!1,padding:0},marker:{symbol:"rect",radius:0,lineColor:void 0,states:{hover:{lineWidthPlus:0},select:{}}},clip:!0,pointRange:null,tooltip:{pointFormat:"{point.x}, {point.y}: {point.value}<br/>"},states:{hover:{halo:!1,brightness:.2}}}),r}(ScatterSeries$1);extend$f(HeatmapSeries$1.prototype,{alignDataLabel:ColumnSeries$7.prototype.alignDataLabel,axisTypes:colorMapSeriesMixin$1.axisTypes,colorAttribs:colorMapSeriesMixin$1.colorAttribs,colorKey:colorMapSeriesMixin$1.colorKey,directTouch:!0,drawLegendSymbol:LegendSymbol$1.drawRectangle,getExtremesFromAll:!0,getSymbol:Series$5.prototype.getSymbol,parallelArrays:colorMapSeriesMixin$1.parallelArrays,pointArrayMap:["y","value"],pointClass:HeatmapPoint,trackerGroups:colorMapSeriesMixin$1.trackerGroups});SeriesRegistry$1.registerSeriesType("heatmap",HeatmapSeries$1);/**
 * @license Highmaps JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/heatmap
 * @requires highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G=H;G.ColorAxis=ColorAxis;ColorAxis.compose(G.Chart,G.Fx,G.Legend,G.Series);var color$2=Color.parse,extend$e=Utilities.extend,merge$9=Utilities.merge,SolidGaugeAxis;(function(o){var r={initDataClasses:function(n){var s=this.chart,a,l=0,h=this.options;this.dataClasses=a=[],n.dataClasses.forEach(function(d,c){var f;d=merge$9(d),a.push(d),d.color||(h.dataClassColor==="category"?(f=s.options.colors,d.color=f[l++],l===f.length&&(l=0)):d.color=color$2(h.minColor).tweenTo(color$2(h.maxColor),c/(n.dataClasses.length-1)))})},initStops:function(n){this.stops=n.stops||[[0,this.options.minColor],[1,this.options.maxColor]],this.stops.forEach(function(s){s.color=color$2(s[1])})},toColor:function(n,s){var a,l=this.stops,h,d,c,f=this.dataClasses,u,p;if(f){for(p=f.length;p--;)if(u=f[p],h=u.from,d=u.to,(typeof h>"u"||n>=h)&&(typeof d>"u"||n<=d)){c=u.color,s&&(s.dataClass=p);break}}else{for(this.logarithmic&&(n=this.val2lin(n)),a=1-(this.max-n)/(this.max-this.min),p=l.length;p--&&!(a>l[p][0]););h=l[p]||l[p+1],d=l[p+1]||h,a=1-(d[0]-a)/(d[0]-h[0]||1),c=h.color.tweenTo(d.color,a)}return c}};function t(n){extend$e(n,r)}o.init=t})(SolidGaugeAxis||(SolidGaugeAxis={}));const SolidGaugeAxis$1=SolidGaugeAxis;var _a$4=SVGRenderer.prototype,symbols=_a$4.symbols,arc=_a$4.symbols.arc;symbols.arc=function(o,r,t,n,s){var a=arc(o,r,t,n,s);if(s&&s.rounded){var l=s.r||t,h=(l-(s.innerR||0))/2,d=a[0],c=a[2];if(d[0]==="M"&&c[0]==="L"){var f=d[1],u=d[2],p=c[1],g=c[2],m=["A",h,h,0,1,1,f,u],v=["A",h,h,0,1,1,p,g];a[2]=v,a[4]=m}}return a};var __extends$c=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),_a$3=SeriesRegistry$1.seriesTypes,GaugeSeries=_a$3.gauge,pieProto=_a$3.pie.prototype,clamp$1=Utilities.clamp,extend$d=Utilities.extend,isNumber$5=Utilities.isNumber,merge$8=Utilities.merge,pick$b=Utilities.pick,pInt=Utilities.pInt,solidGaugeOptions={colorByPoint:!0,dataLabels:{y:0}},SolidGaugeSeries=function(o){__extends$c(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.points=void 0,t.options=void 0,t.axis=void 0,t.yAxis=void 0,t.startAngleRad=void 0,t.thresholdAngleRad=void 0,t}return r.prototype.translate=function(){var t=this.yAxis;SolidGaugeAxis$1.init(t),!t.dataClasses&&t.options.dataClasses&&t.initDataClasses(t.options),t.initStops(t.options),GaugeSeries.prototype.translate.call(this)},r.prototype.drawPoints=function(){var t=this,n=t.yAxis,s=n.center,a=t.options,l=t.chart.renderer,h=a.overshoot,d=isNumber$5(h)?h/180*Math.PI:0,c;isNumber$5(a.threshold)&&(c=n.startAngleRad+n.translate(a.threshold,null,null,null,!0)),this.thresholdAngleRad=pick$b(c,n.startAngleRad),t.points.forEach(function(f){if(!f.isNull){var u=f.graphic,p=n.startAngleRad+n.translate(f.y,null,null,null,!0),g=pInt(pick$b(f.options.radius,a.radius,100))*s[2]/200,m=pInt(pick$b(f.options.innerRadius,a.innerRadius,60))*s[2]/200,v=void 0,x=void 0,y=n.toColor(f.y,f),b=Math.min(n.startAngleRad,n.endAngleRad),$=Math.max(n.startAngleRad,n.endAngleRad),S=void 0,k=void 0;y==="none"&&(y=f.color||t.color||"none"),y!=="none"&&(f.color=y),p=clamp$1(p,b-d,$+d),a.wrap===!1&&(p=clamp$1(p,b,$)),S=Math.min(p,t.thresholdAngleRad),k=Math.max(p,t.thresholdAngleRad),k-S>2*Math.PI&&(k=S+2*Math.PI),f.shapeArgs=v={x:s[0],y:s[1],r:g,innerR:m,start:S,end:k,rounded:a.rounded},f.startR=g,u?(x=v.d,u.animate(extend$d({fill:y},v)),x&&(v.d=x)):f.graphic=u=l.arc(v).attr({fill:y,"sweep-flag":0}).add(t.group),t.chart.styledMode||(a.linecap!=="square"&&u.attr({"stroke-linecap":"round","stroke-linejoin":"round"}),u.attr({stroke:a.borderColor||"none","stroke-width":a.borderWidth||0})),u&&u.addClass(f.getClassName(),!0)}})},r.prototype.animate=function(t){t||(this.startAngleRad=this.thresholdAngleRad,pieProto.animate.call(this,t))},r.defaultOptions=merge$8(GaugeSeries.defaultOptions,solidGaugeOptions),r}(GaugeSeries);extend$d(SolidGaugeSeries.prototype,{drawLegendSymbol:LegendSymbol$1.drawRectangle});SeriesRegistry$1.registerSeriesType("solidgauge",SolidGaugeSeries);var TreemapAlgorithmGroup=function(){function o(r,t,n,s){this.height=r,this.width=t,this.plot=s,this.direction=n,this.startDirection=n,this.total=0,this.nW=0,this.lW=0,this.nH=0,this.lH=0,this.elArr=[],this.lP={total:0,lH:0,nH:0,lW:0,nW:0,nR:0,lR:0,aspectRatio:function(a,l){return Math.max(a/l,l/a)}}}return o.prototype.addElement=function(r){this.lP.total=this.elArr[this.elArr.length-1],this.total=this.total+r,this.direction===0?(this.lW=this.nW,this.lP.lH=this.lP.total/this.lW,this.lP.lR=this.lP.aspectRatio(this.lW,this.lP.lH),this.nW=this.total/this.height,this.lP.nH=this.lP.total/this.nW,this.lP.nR=this.lP.aspectRatio(this.nW,this.lP.nH)):(this.lH=this.nH,this.lP.lW=this.lP.total/this.lH,this.lP.lR=this.lP.aspectRatio(this.lP.lW,this.lH),this.nH=this.total/this.width,this.lP.nW=this.lP.total/this.nH,this.lP.nR=this.lP.aspectRatio(this.lP.nW,this.nH)),this.elArr.push(r)},o.prototype.reset=function(){this.nW=0,this.lW=0,this.elArr=[],this.total=0},o}(),isFn$1=function(o){return typeof o=="function"},draw=function(r){var t=this,n=r.animatableAttribs,s=r.onComplete,a=r.css,l=r.renderer,h=this.series&&this.series.chart.hasRendered?void 0:this.series&&this.series.options.animation,d=this.graphic;if(this.shouldDraw())d||(this.graphic=d=l[r.shapeType](r.shapeArgs).add(r.group)),d.css(a).attr(r.attribs).animate(n,r.isNew?!1:h,s);else if(d){var c=function(){t.graphic=d=d&&d.destroy(),isFn$1(s)&&s()};Object.keys(n).length?d.animate(n,void 0,function(){c()}):c()}},drawPoint=function(r){var t=this,n=r.attribs=r.attribs||{};n.class=t.getClassName(),draw.call(t,r)},drawPointModule={draw,drawPoint,isFn:isFn$1},__extends$b=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),Point=SeriesRegistry$1.series.prototype.pointClass,_a$2=SeriesRegistry$1.seriesTypes,PiePoint$1=_a$2.pie.prototype.pointClass,ScatterPoint=_a$2.scatter.prototype.pointClass,extend$c=Utilities.extend,isNumber$4=Utilities.isNumber,pick$a=Utilities.pick,TreemapPoint=function(o){__extends$b(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.name=void 0,t.node=void 0,t.options=void 0,t.series=void 0,t.value=void 0,t}return r.prototype.getClassName=function(){var t=Point.prototype.getClassName.call(this),n=this.series,s=n.options;return this.node.level<=n.nodeMap[n.rootNode].level?t+=" highcharts-above-level":!this.node.isLeaf&&!pick$a(s.interactByLeaf,!s.allowTraversingTree)?t+=" highcharts-internal-node-interactive":this.node.isLeaf||(t+=" highcharts-internal-node"),t},r.prototype.isValid=function(){return!!(this.id||isNumber$4(this.value))},r.prototype.setState=function(t){Point.prototype.setState.call(this,t),this.graphic&&this.graphic.attr({zIndex:t==="hover"?1:0})},r.prototype.shouldDraw=function(){return isNumber$4(this.plotY)&&this.y!==null},r}(ScatterPoint);extend$c(TreemapPoint.prototype,{draw:drawPointModule.drawPoint,setVisible:PiePoint$1.prototype.setVisible});var objectEach$1=Utilities.objectEach,TreemapUtilities;(function(o){o.AXIS_MAX=100;function r(s){return typeof s=="boolean"}o.isBoolean=r;function t(s,a,l){l=l||this,objectEach$1(s,function(h,d){a.call(l,h,d,s)})}o.eachObject=t;function n(s,a,l){l===void 0&&(l=this);var h;h=a.call(l,s),h!==!1&&n(h,a,l)}o.recursive=n})(TreemapUtilities||(TreemapUtilities={}));const TreemapUtilities$1=TreemapUtilities;var extend$b=Utilities.extend,isArray$1=Utilities.isArray,isNumber$3=Utilities.isNumber,isObject$3=Utilities.isObject,merge$7=Utilities.merge,pick$9=Utilities.pick,isBoolean=function(o){return typeof o=="boolean"},isFn=function(o){return typeof o=="function"},setTreeValues=function o(r,t){var n=t.before,s=t.idRoot,a=t.mapIdToNode,l=a[s],h=isBoolean(t.levelIsConstant)?t.levelIsConstant:!0,d=t.points,c=d[r.i],f=c&&c.options||{},u=0,p=[],g;return r.levelDynamic=r.level-(h?0:l.level),r.name=pick$9(c&&c.name,""),r.visible=s===r.id||(isBoolean(t.visible)?t.visible:!1),isFn(n)&&(r=n(r,t)),r.children.forEach(function(m,v){var x=extend$b({},t);extend$b(x,{index:v,siblings:r.children.length,visible:r.visible}),m=o(m,x),p.push(m),m.visible&&(u+=m.val)}),g=pick$9(f.value,u),r.visible=g>=0&&(u>0||r.visible),r.children=p,r.childrenTotal=u,r.isLeaf=r.visible&&!u,r.val=g,r},getColor$1=function(r,t){var n=t.index,s=t.mapOptionsToLevel,a=t.parentColor,l=t.parentColorIndex,h=t.series,d=t.colors,c=t.siblings,f=h.points,u,p=h.chart.options.chart,g,m,v,x,y,b;function $(S){var k=m&&m.colorVariation;return k&&k.key==="brightness"?Color.parse(S).brighten(k.to*(n/c)).get():S}return r&&(g=f[r.i],m=s[r.level]||{},u=g&&m.colorByPoint,u&&(x=g.index%(d?d.length:p.colorCount),v=d&&d[x]),h.chart.styledMode||(y=pick$9(g&&g.options.color,m&&m.color,v,a&&$(a),h.color)),b=pick$9(g&&g.options.colorIndex,m&&m.colorIndex,x,l,t.colorIndex)),{color:y,colorIndex:b}},getLevelOptions$2=function(r){var t=null,n,s,a,l,h,d;if(isObject$3(r))for(t={},l=isNumber$3(r.from)?r.from:1,d=r.levels,s={},n=isObject$3(r.defaults)?r.defaults:{},isArray$1(d)&&(s=d.reduce(function(c,f){var u,p,g;return isObject$3(f)&&isNumber$3(f.level)&&(g=merge$7({},f),p=isBoolean(g.levelIsConstant)?g.levelIsConstant:n.levelIsConstant,delete g.levelIsConstant,delete g.level,u=f.level+(p?0:l-1),isObject$3(c[u])?extend$b(c[u],g):c[u]=g),c},{})),h=isNumber$3(r.to)?r.to:1,a=0;a<=h;a++)t[a]=merge$7({},n,isObject$3(s[a])?s[a]:{});return t},updateRootId$1=function(o){var r,t;return isObject$3(o)&&(t=isObject$3(o.options)?o.options:{},r=pick$9(o.rootNode,t.rootId,""),isObject$3(o.userOptions)&&(o.userOptions.rootId=r),o.rootNode=r),r},result={getColor:getColor$1,getLevelOptions:getLevelOptions$2,setTreeValues,updateRootId:updateRootId$1},Series$4=SeriesRegistry$1.series,addEvent$4=Utilities.addEvent,extend$a=Utilities.extend,treemapAxisDefaultValues=!1;addEvent$4(Series$4,"afterBindAxes",function(){var o=this,r=o.xAxis,t=o.yAxis,n;r&&t&&(o.is("treemap")?(n={endOnTick:!1,gridLineWidth:0,lineWidth:0,min:0,minPadding:0,max:TreemapUtilities$1.AXIS_MAX,maxPadding:0,startOnTick:!1,title:void 0,tickPositions:[]},extend$a(t.options,n),extend$a(r.options,n),treemapAxisDefaultValues=!0):treemapAxisDefaultValues&&(t.setOptions(t.userOptions),r.setOptions(r.userOptions),treemapAxisDefaultValues=!1))});var __extends$a=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),color$1=Color.parse,colorMapSeriesMixin=exports.colorMapSeriesMixin,noop=H.noop,Series$3=SeriesRegistry$1.series,_a$1=SeriesRegistry$1.seriesTypes,ColumnSeries$6=_a$1.column,HeatmapSeries=_a$1.heatmap,ScatterSeries=_a$1.scatter,getColor=result.getColor,getLevelOptions$1=result.getLevelOptions,updateRootId=result.updateRootId,addEvent$3=Utilities.addEvent,correctFloat$1=Utilities.correctFloat,defined$6=Utilities.defined,error=Utilities.error,extend$9=Utilities.extend,fireEvent=Utilities.fireEvent,isArray=Utilities.isArray,isObject$2=Utilities.isObject,isString=Utilities.isString,merge$6=Utilities.merge,pick$8=Utilities.pick,stableSort$1=Utilities.stableSort,TreemapSeries=function(o){__extends$a(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.axisRatio=void 0,t.data=void 0,t.mapOptionsToLevel=void 0,t.nodeMap=void 0,t.options=void 0,t.points=void 0,t.rootNode=void 0,t.tree=void 0,t}return r.prototype.algorithmCalcPoints=function(t,n,s,a){var l,h,d,c,f=s.lW,u=s.lH,p=s.plot,g,m=0,v=s.elArr.length-1;n?(f=s.nW,u=s.nH):g=s.elArr[s.elArr.length-1],s.elArr.forEach(function(x){(n||m<v)&&(s.direction===0?(l=p.x,h=p.y,d=f,c=x/d):(l=p.x,h=p.y,c=u,d=x/c),a.push({x:l,y:h,width:d,height:correctFloat$1(c)}),s.direction===0?p.y=p.y+c:p.x=p.x+d),m=m+1}),s.reset(),s.direction===0?s.width=s.width-f:s.height=s.height-u,p.y=p.parent.y+(p.parent.height-s.height),p.x=p.parent.x+(p.parent.width-s.width),t&&(s.direction=1-s.direction),n||s.addElement(g)},r.prototype.algorithmFill=function(t,n,s){var a=[],l,h=n.direction,d=n.x,c=n.y,f=n.width,u=n.height,p,g,m,v;return s.forEach(function(x){l=n.width*n.height*(x.val/n.val),p=d,g=c,h===0?(v=u,m=l/v,f=f-m,d=d+m):(m=f,v=l/m,u=u-v,c=c+v),a.push({x:p,y:g,width:m,height:v}),t&&(h=1-h)}),a},r.prototype.algorithmLowAspectRatio=function(t,n,s){var a=[],l=this,h,d={x:n.x,y:n.y,parent:n},c=n.direction,f=0,u=s.length-1,p=new TreemapAlgorithmGroup(n.height,n.width,c,d);return s.forEach(function(g){h=n.width*n.height*(g.val/n.val),p.addElement(h),p.lP.nR>p.lP.lR&&l.algorithmCalcPoints(t,!1,p,a,d),f===u&&l.algorithmCalcPoints(t,!0,p,a,d),f=f+1}),a},r.prototype.alignDataLabel=function(t,n,s){var a=s.style;a&&!defined$6(a.textOverflow)&&n.text&&n.getBBox().width>n.text.textWidth&&n.css({textOverflow:"ellipsis",width:a.width+="px"}),ColumnSeries$6.prototype.alignDataLabel.apply(this,arguments),t.dataLabel&&t.dataLabel.attr({zIndex:(t.node.zIndex||0)+1})},r.prototype.buildNode=function(t,n,s,a,l){var h=this,d=[],c=h.points[n],f=0,u,p;return(a[t]||[]).forEach(function(g){p=h.buildNode(h.points[g].id,g,s+1,a,t),f=Math.max(p.height+1,f),d.push(p)}),u={id:t,i:n,children:d,height:f,level:s,parent:l,visible:!1},h.nodeMap[u.id]=u,c&&(c.node=u),u},r.prototype.calculateChildrenAreas=function(t,n){var s=this,a=s.options,l=s.mapOptionsToLevel,h=l[t.level+1],d=pick$8(s[h&&h.layoutAlgorithm]&&h.layoutAlgorithm,a.layoutAlgorithm),c=a.alternateStartingDirection,f=[],u;u=t.children.filter(function(p){return!p.ignore}),h&&h.layoutStartingDirection&&(n.direction=h.layoutStartingDirection==="vertical"?0:1),f=s[d](n,u),u.forEach(function(p,g){var m=f[g];p.values=merge$6(m,{val:p.childrenTotal,direction:c?1-n.direction:n.direction}),p.pointValues=merge$6(m,{x:m.x/s.axisRatio,y:TreemapUtilities$1.AXIS_MAX-m.y-m.height,width:m.width/s.axisRatio}),p.children.length&&s.calculateChildrenAreas(p,p.values)})},r.prototype.drawDataLabels=function(){var t=this,n=t.mapOptionsToLevel,s=t.points.filter(function(h){return h.node.visible}),a,l;s.forEach(function(h){l=n[h.node.level],a={style:{}},h.node.isLeaf||(a.enabled=!1),l&&l.dataLabels&&(a=merge$6(a,l.dataLabels),t._hasPointLabels=!0),h.shapeArgs&&(a.style.width=h.shapeArgs.width,h.dataLabel&&h.dataLabel.css({width:h.shapeArgs.width+"px"})),h.dlOptions=merge$6(a,h.options.dataLabels)}),Series$3.prototype.drawDataLabels.call(this)},r.prototype.drawPoints=function(){var t=this,n=t.chart,s=n.renderer,a=t.points,l=n.styledMode,h=t.options,d=l?{}:h.shadow,c=h.borderRadius,f=n.pointCount<h.animationLimit,u=h.allowTraversingTree;a.forEach(function(p){var g=p.node.levelDynamic,m={},v={},x={},y="level-group-"+p.node.level,b=!!p.graphic,$=f&&b,S=p.shapeArgs;p.shouldDraw()&&(p.isInside=!0,c&&(v.r=c),merge$6(!0,$?m:v,b?S:{},l?{}:t.pointAttribs(p,p.selected?"select":void 0)),t.colorAttribs&&l&&extend$9(x,t.colorAttribs(p)),t[y]||(t[y]=s.g(y).attr({zIndex:1e3-(g||0)}).add(t.group),t[y].survive=!0)),p.draw({animatableAttribs:m,attribs:v,css:x,group:t[y],renderer:s,shadow:d,shapeArgs:S,shapeType:"rect"}),u&&p.graphic&&(p.drillId=h.interactByLeaf?t.drillToByLeaf(p):t.drillToByGroup(p))})},r.prototype.drillToByGroup=function(t){var n=this,s=!1;return t.node.level-n.nodeMap[n.rootNode].level===1&&!t.node.isLeaf&&(s=t.id),s},r.prototype.drillToByLeaf=function(t){var n=this,s=!1,a;if(t.node.parent!==n.rootNode&&t.node.isLeaf)for(a=t.node;!s;)a=n.nodeMap[a.parent],a.parent===n.rootNode&&(s=a.id);return s},r.prototype.drillToNode=function(t,n){error(32,!1,void 0,{"treemap.drillToNode":"use treemap.setRootNode"}),this.setRootNode(t,n)},r.prototype.drillUp=function(){var t=this,n=t.nodeMap[t.rootNode];n&&isString(n.parent)&&t.setRootNode(n.parent,!0,{trigger:"traverseUpButton"})},r.prototype.getExtremes=function(){var t=Series$3.prototype.getExtremes.call(this,this.colorValueData),n=t.dataMin,s=t.dataMax;return this.valueMin=n,this.valueMax=s,Series$3.prototype.getExtremes.call(this)},r.prototype.getListOfParents=function(t,n){var s=isArray(t)?t:[],a=isArray(n)?n:[],l=s.reduce(function(h,d,c){var f=pick$8(d.parent,"");return typeof h[f]>"u"&&(h[f]=[]),h[f].push(c),h},{"":[]});return TreemapUtilities$1.eachObject(l,function(h,d,c){d!==""&&a.indexOf(d)===-1&&(h.forEach(function(f){c[""].push(f)}),delete c[d])}),l},r.prototype.getTree=function(){var t=this,n=this.data.map(function(a){return a.id}),s=t.getListOfParents(this.data,n);return t.nodeMap={},t.buildNode("",-1,0,s)},r.prototype.hasData=function(){return!!this.processedXData.length},r.prototype.init=function(t,n){var s=this,a;this.colorAttribs=colorMapSeriesMixin.colorAttribs,a=addEvent$3(s,"setOptions",function(l){var h=l.userOptions;defined$6(h.allowDrillToNode)&&!defined$6(h.allowTraversingTree)&&(h.allowTraversingTree=h.allowDrillToNode,delete h.allowDrillToNode),defined$6(h.drillUpButton)&&!defined$6(h.traverseUpButton)&&(h.traverseUpButton=h.drillUpButton,delete h.drillUpButton)}),Series$3.prototype.init.call(s,t,n),delete s.opacity,s.eventsToUnbind.push(a),s.options.allowTraversingTree&&s.eventsToUnbind.push(addEvent$3(s,"click",s.onClickDrillToNode))},r.prototype.onClickDrillToNode=function(t){var n=this,s=t.point,a=s&&s.drillId;isString(a)&&(s.setState(""),n.setRootNode(a,!0,{trigger:"click"}))},r.prototype.pointAttribs=function(t,n){var s=this,a=isObject$2(s.mapOptionsToLevel)?s.mapOptionsToLevel:{},l=t&&a[t.node.level]||{},h=this.options,d,c=n&&h.states[n]||{},f=t&&t.getClassName()||"",u;return d={stroke:t&&t.borderColor||l.borderColor||c.borderColor||h.borderColor,"stroke-width":pick$8(t&&t.borderWidth,l.borderWidth,c.borderWidth,h.borderWidth),dashstyle:t&&t.borderDashStyle||l.borderDashStyle||c.borderDashStyle||h.borderDashStyle,fill:t&&t.color||this.color},f.indexOf("highcharts-above-level")!==-1?(d.fill="none",d["stroke-width"]=0):f.indexOf("highcharts-internal-node-interactive")!==-1?(u=pick$8(c.opacity,h.opacity),d.fill=color$1(d.fill).setOpacity(u).get(),d.cursor="pointer"):f.indexOf("highcharts-internal-node")!==-1?d.fill="none":n&&(d.fill=color$1(d.fill).brighten(c.brightness).get()),d},r.prototype.renderTraverseUpButton=function(t){var n=this,s=n.nodeMap,a=s[t],l=a.name,h=n.options.traverseUpButton,d=pick$8(h.text,l,"◁ Back"),c,f;t===""||n.is("sunburst")&&n.tree.children.length===1&&t===n.tree.children[0].id?n.drillUpButton&&(n.drillUpButton=n.drillUpButton.destroy()):this.drillUpButton?(this.drillUpButton.placed=!1,this.drillUpButton.attr({text:d}).align()):(c=h.theme,f=c&&c.states,this.drillUpButton=this.chart.renderer.button(d,0,0,function(){n.drillUp()},c,f&&f.hover,f&&f.select).addClass("highcharts-drillup-button").attr({align:h.position.align,zIndex:7}).add().align(h.position,!1,h.relativeTo||"plotBox"))},r.prototype.setColorRecursive=function(t,n,s,a,l){var h=this,d=h&&h.chart,c=d&&d.options&&d.options.colors,f,u;t&&(f=getColor(t,{colors:c,index:a,mapOptionsToLevel:h.mapOptionsToLevel,parentColor:n,parentColorIndex:s,series:h,siblings:l}),u=h.points[t.i],u&&(u.color=f.color,u.colorIndex=f.colorIndex),(t.children||[]).forEach(function(p,g){h.setColorRecursive(p,f.color,f.colorIndex,g,t.children.length)}))},r.prototype.setPointValues=function(){var t=this,n=t.points,s=t.xAxis,a=t.yAxis,l=t.chart.styledMode,h=function(d){return l?0:(t.pointAttribs(d)["stroke-width"]||0)%2/2};n.forEach(function(d){var c=d.node,f=c.pointValues,u=c.visible;if(f&&u){var p=f.height,g=f.width,m=f.x,v=f.y,x=h(d),y=Math.round(s.toPixels(m,!0))-x,b=Math.round(s.toPixels(m+g,!0))-x,$=Math.round(a.toPixels(v,!0))-x,S=Math.round(a.toPixels(v+p,!0))-x,k={x:Math.min(y,b),y:Math.min($,S),width:Math.abs(b-y),height:Math.abs(S-$)};d.plotX=k.x+k.width/2,d.plotY=k.y+k.height/2,d.shapeArgs=k}else delete d.plotX,delete d.plotY})},r.prototype.setRootNode=function(t,n,s){var a=this,l=extend$9({newRootId:t,previousRootId:a.rootNode,redraw:pick$8(n,!0),series:a},s),h=function(d){var c=d.series;c.idPreviousRoot=d.previousRootId,c.rootNode=d.newRootId,c.isDirty=!0,d.redraw&&c.chart.redraw()};fireEvent(a,"setRootNode",l,h)},r.prototype.setState=function(t){this.options.inactiveOtherPoints=!0,Series$3.prototype.setState.call(this,t,!1),this.options.inactiveOtherPoints=!1},r.prototype.setTreeValues=function(t){var n=this,s=n.options,a=n.rootNode,l=n.nodeMap,h=l[a],d=TreemapUtilities$1.isBoolean(s.levelIsConstant)?s.levelIsConstant:!0,c=0,f=[],u,p=n.points[t.i];return t.children.forEach(function(g){g=n.setTreeValues(g),f.push(g),g.ignore||(c+=g.val)}),stableSort$1(f,function(g,m){return(g.sortIndex||0)-(m.sortIndex||0)}),u=pick$8(p&&p.options.value,c),p&&(p.value=u),extend$9(t,{children:f,childrenTotal:c,ignore:!(pick$8(p&&p.visible,!0)&&u>0),isLeaf:t.visible&&!c,levelDynamic:t.level-(d?0:h.level),name:pick$8(p&&p.name,""),sortIndex:pick$8(p&&p.sortIndex,-u),val:u}),t},r.prototype.sliceAndDice=function(t,n){return this.algorithmFill(!0,t,n)},r.prototype.squarified=function(t,n){return this.algorithmLowAspectRatio(!0,t,n)},r.prototype.strip=function(t,n){return this.algorithmLowAspectRatio(!1,t,n)},r.prototype.stripes=function(t,n){return this.algorithmFill(!1,t,n)},r.prototype.translate=function(){var t=this,n=t.options,s=updateRootId(t),a,l,h,d,c;Series$3.prototype.translate.call(t),d=t.tree=t.getTree(),a=t.nodeMap[s],s!==""&&(!a||!a.children.length)&&(t.setRootNode("",!1),s=t.rootNode,a=t.nodeMap[s]),t.renderTraverseUpButton(s),t.mapOptionsToLevel=getLevelOptions$1({from:a.level+1,levels:n.levels,to:d.height,defaults:{levelIsConstant:t.options.levelIsConstant,colorByPoint:n.colorByPoint}}),TreemapUtilities$1.recursive(t.nodeMap[t.rootNode],function(f){var u=!1,p=f.parent;return f.visible=!0,(p||p==="")&&(u=t.nodeMap[p]),u}),TreemapUtilities$1.recursive(t.nodeMap[t.rootNode].children,function(f){var u=!1;return f.forEach(function(p){p.visible=!0,p.children.length&&(u=(u||[]).concat(p.children))}),u}),t.setTreeValues(d),t.axisRatio=t.xAxis.len/t.yAxis.len,t.nodeMap[""].pointValues=l={x:0,y:0,width:TreemapUtilities$1.AXIS_MAX,height:TreemapUtilities$1.AXIS_MAX},t.nodeMap[""].values=h=merge$6(l,{width:l.width*t.axisRatio,direction:n.layoutStartingDirection==="vertical"?0:1,val:d.val}),t.calculateChildrenAreas(d,h),!t.colorAxis&&!n.colorByPoint&&t.setColorRecursive(t.tree),n.allowTraversingTree&&(c=a.pointValues,t.xAxis.setExtremes(c.x,c.x+c.width,!1),t.yAxis.setExtremes(c.y,c.y+c.height,!1),t.xAxis.setScale(),t.yAxis.setScale()),t.setPointValues()},r.defaultOptions=merge$6(ScatterSeries.defaultOptions,{allowTraversingTree:!1,animationLimit:250,borderRadius:0,showInLegend:!1,marker:void 0,colorByPoint:!1,dataLabels:{defer:!1,enabled:!0,formatter:function(){var t=this&&this.point?this.point:{},n=isString(t.name)?t.name:"";return n},inside:!0,verticalAlign:"middle"},tooltip:{headerFormat:"",pointFormat:"<b>{point.name}</b>: {point.value}<br/>"},ignoreHiddenPoint:!0,layoutAlgorithm:"sliceAndDice",layoutStartingDirection:"vertical",alternateStartingDirection:!1,levelIsConstant:!0,drillUpButton:{position:{align:"right",x:-10,y:10}},traverseUpButton:{position:{align:"right",x:-10,y:10}},borderColor:palette.neutralColor10,borderWidth:1,colorKey:"colorValue",opacity:.15,states:{hover:{borderColor:palette.neutralColor40,brightness:HeatmapSeries?0:.1,halo:!1,opacity:.75,shadow:!1}}}),r}(ScatterSeries);extend$9(TreemapSeries.prototype,{buildKDTree:noop,colorKey:"colorValue",directTouch:!0,drawLegendSymbol:LegendSymbol$1.drawRectangle,getExtremesFromAll:!0,getSymbol:noop,optionalAxis:"colorAxis",parallelArrays:["x","y","value","colorValue"],pointArrayMap:["value"],pointClass:TreemapPoint,trackerGroups:["group","dataLabelsGroup"],utils:{recursive:TreemapUtilities$1.recursive}});SeriesRegistry$1.registerSeriesType("treemap",TreemapSeries);var getOptions=DefaultOptions.getOptions,addEvent$2=Utilities.addEvent,extend$8=Utilities.extend,chartPrototype=Chart$1.prototype,defaultOptions=getOptions();extend$8(defaultOptions.lang,{noData:"No data to display"});defaultOptions.noData={attr:{zIndex:1},position:{x:0,y:0,align:"center",verticalAlign:"middle"},style:{fontWeight:"bold",fontSize:"12px",color:palette.neutralColor60}};chartPrototype.showNoData=function(o){var r=this,t=r.options,n=o||t&&t.lang.noData||"",s=t&&(t.noData||{});r.renderer&&(r.noDataLabel||(r.noDataLabel=r.renderer.label(n,0,0,void 0,void 0,void 0,s.useHTML,void 0,"no-data").add()),r.styledMode||r.noDataLabel.attr(AST.filterUserAttributes(s.attr||{})).css(s.style||{}),r.noDataLabel.align(extend$8(r.noDataLabel.getBBox(),s.position||{}),!1,"plotBox"))};chartPrototype.hideNoData=function(){var o=this;o.noDataLabel&&(o.noDataLabel=o.noDataLabel.destroy())};chartPrototype.hasData=function(){for(var o=this,r=o.series||[],t=r.length;t--;)if(r[t].hasData()&&!r[t].options.isInternal)return!0;return o.loadingShown};addEvent$2(Chart$1,"render",function(){this.hasData()?this.hideNoData():this.showNoData()});var defined$5=Utilities.defined,extend$7=Utilities.extend,find$2=Utilities.find,pick$7=Utilities.pick,NodesMixin=H.NodesMixin={createNode:function(o){function r(a,l){return find$2(a,function(h){return h.id===l})}var t=r(this.nodes,o),n=this.pointClass,s;return t||(s=this.options.nodes&&r(this.options.nodes,o),t=new n().init(this,extend$7({className:"highcharts-node",isNode:!0,id:o,y:1},s)),t.linksTo=[],t.linksFrom=[],t.formatPrefix="node",t.name=t.name||t.options.id||"",t.mass=pick$7(t.options.mass,t.options.marker&&t.options.marker.radius,this.options.marker&&this.options.marker.radius,4),t.getSum=function(){var a=0,l=0;return t.linksTo.forEach(function(h){a+=h.weight}),t.linksFrom.forEach(function(h){l+=h.weight}),Math.max(a,l)},t.offset=function(a,l){for(var h=0,d=0;d<t[l].length;d++){if(t[l][d]===a)return h;h+=t[l][d].weight}},t.hasShape=function(){var a=0;return t.linksTo.forEach(function(l){l.outgoing&&a++}),!t.linksTo.length||a!==t.linksTo.length},this.nodes.push(t)),t},generatePoints:function(){var o=this.chart,r={};Series$e.prototype.generatePoints.call(this),this.nodes||(this.nodes=[]),this.colorCounter=0,this.nodes.forEach(function(t){t.linksFrom.length=0,t.linksTo.length=0,t.level=t.options.level}),this.points.forEach(function(t){defined$5(t.from)&&(r[t.from]||(r[t.from]=this.createNode(t.from)),r[t.from].linksFrom.push(t),t.fromNode=r[t.from],o.styledMode?t.colorIndex=pick$7(t.options.colorIndex,r[t.from].colorIndex):t.color=t.options.color||r[t.from].color),defined$5(t.to)&&(r[t.to]||(r[t.to]=this.createNode(t.to)),r[t.to].linksTo.push(t),t.toNode=r[t.to]),t.name=t.name||t.id},this),this.nodeLookup=r},setData:function(){this.nodes&&(this.nodes.forEach(function(o){o.destroy()}),this.nodes.length=0),Series$e.prototype.setData.apply(this,arguments)},destroy:function(){return this.data=[].concat(this.points||[],this.nodes),Series$e.prototype.destroy.apply(this,arguments)},setNodeState:function(o){var r=arguments,t=this.isNode?this.linksTo.concat(this.linksFrom):[this.fromNode,this.toNode];o!=="select"&&t.forEach(function(n){n&&n.series&&(Point$2.prototype.setState.apply(n,r),n.isNode||(n.fromNode.graphic&&Point$2.prototype.setState.apply(n.fromNode,r),n.toNode&&n.toNode.graphic&&Point$2.prototype.setState.apply(n.toNode,r)))}),Point$2.prototype.setState.apply(this,r)}},__extends$9=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),ColumnSeries$5=SeriesRegistry$1.seriesTypes.column,defined$4=Utilities.defined,extend$6=Utilities.extend,SankeyPoint$1=function(o){__extends$9(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.className=void 0,t.fromNode=void 0,t.level=void 0,t.linkBase=void 0,t.linksFrom=void 0,t.linksTo=void 0,t.mass=void 0,t.nodeX=void 0,t.nodeY=void 0,t.options=void 0,t.series=void 0,t.toNode=void 0,t}return r.prototype.applyOptions=function(t,n){return Point$2.prototype.applyOptions.call(this,t,n),defined$4(this.options.level)&&(this.options.column=this.column=this.options.level),this},r.prototype.getClassName=function(){return(this.isNode?"highcharts-node ":"highcharts-link ")+Point$2.prototype.getClassName.call(this)},r.prototype.isValid=function(){return this.isNode||typeof this.weight=="number"},r}(ColumnSeries$5.prototype.pointClass);extend$6(SankeyPoint$1.prototype,{setState:NodesMixin.setNodeState});var __extends$8=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),Series$2=SeriesRegistry$1.series,ColumnSeries$4=SeriesRegistry$1.seriesTypes.column,getLevelOptions=result.getLevelOptions,defined$3=Utilities.defined,extend$5=Utilities.extend,find$1=Utilities.find,isObject$1=Utilities.isObject,merge$5=Utilities.merge,pick$6=Utilities.pick,relativeLength$1=Utilities.relativeLength,stableSort=Utilities.stableSort,SankeySeries$1=function(o){__extends$8(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.colDistance=void 0,t.data=void 0,t.group=void 0,t.nodeLookup=void 0,t.nodePadding=void 0,t.nodes=void 0,t.nodeWidth=void 0,t.options=void 0,t.points=void 0,t.translationFactor=void 0,t}return r.getDLOptions=function(t){var n=isObject$1(t.optionsPoint)?t.optionsPoint.dataLabels:{},s=isObject$1(t.level)?t.level.dataLabels:{},a=merge$5({style:{}},s,n);return a},r.prototype.createNodeColumn=function(){var t=this,n=this.chart,s=[];return s.sum=function(){return this.reduce(function(a,l){return a+l.getSum()},0)},s.offset=function(a,l){for(var h=0,d,c=t.nodePadding,f=0;f<s.length;f++){var u=s[f].getSum(),p=Math.max(u*l,t.options.minLinkWidth);if(u?d=p+c:d=0,s[f]===a)return{relativeTop:h+relativeLength$1(a.options.offset||0,d)};h+=d}},s.top=function(a){var l=t.nodePadding,h=this.reduce(function(d,c){d>0&&(d+=l);var f=Math.max(c.getSum()*a,t.options.minLinkWidth);return d+=f,d},0);return(n.plotSizeY-h)/2},s},r.prototype.createNodeColumns=function(){var t=[];this.nodes.forEach(function(s){var a=-1,l;if(!defined$3(s.options.column))if(s.linksTo.length===0)s.column=0;else{for(var h=0;h<s.linksTo.length;h++){var d=s.linksTo[h];d.fromNode.column>a&&d.fromNode!==s&&(l=d.fromNode,a=l.column)}if(s.column=a+1,l&&l.options.layout==="hanging"){s.hangsFrom=l;var c=-1;find$1(l.linksFrom,function(f,u){var p=f.toNode===s;return p&&(c=u),p}),s.column+=c}}t[s.column]||(t[s.column]=this.createNodeColumn()),t[s.column].push(s)},this);for(var n=0;n<t.length;n++)typeof t[n]>"u"&&(t[n]=this.createNodeColumn());return t},r.prototype.generatePoints=function(){NodesMixin.generatePoints.apply(this,arguments);function t(n,s){typeof n.level>"u"&&(n.level=s,n.linksFrom.forEach(function(a){a.toNode&&t(a.toNode,s+1)}))}this.orderNodes&&(this.nodes.filter(function(n){return n.linksTo.length===0}).forEach(function(n){t(n,0)}),stableSort(this.nodes,function(n,s){return n.level-s.level}))},r.prototype.getNodePadding=function(){var t=this.options.nodePadding||0;if(this.nodeColumns){var n=this.nodeColumns.reduce(function(s,a){return Math.max(s,a.length)},0);n*t>this.chart.plotSizeY&&(t=this.chart.plotSizeY/n)}return t},r.prototype.hasData=function(){return!!this.processedXData.length},r.prototype.pointAttribs=function(t,n){if(!t)return{};var s=this,a=t.isNode?t.level:t.fromNode.level,l=s.mapOptionsToLevel[a||0]||{},h=t.options,d=l.states&&l.states[n||""]||{},c=["colorByPoint","borderColor","borderWidth","linkOpacity"].reduce(function(u,p){return u[p]=pick$6(d[p],h[p],l[p],s.options[p]),u},{}),f=pick$6(d.color,h.color,c.colorByPoint?t.color:l.color);return t.isNode?{fill:f,stroke:c.borderColor,"stroke-width":c.borderWidth}:{fill:Color.parse(f).setOpacity(c.linkOpacity).get()}},r.prototype.render=function(){var t=this.points;this.points=this.points.concat(this.nodes||[]),ColumnSeries$4.prototype.render.call(this),this.points=t},r.prototype.translate=function(){var t=this,n=function(c){for(var f=c.slice(),u=t.options.minLinkWidth||0,p,g=0,m,v=a.plotSizeY-l.borderWidth-(c.length-1)*s.nodePadding;c.length;){for(g=v/c.sum(),p=!1,m=c.length;m--;)c[m].getSum()*g<u&&(c.splice(m,1),v-=u,p=!0);if(!p)break}return c.length=0,f.forEach(function(x){return c.push(x)}),g};this.processedXData||this.processData(),this.generatePoints(),this.nodeColumns=this.createNodeColumns(),this.nodeWidth=relativeLength$1(this.options.nodeWidth,this.chart.plotSizeX);var s=this,a=this.chart,l=this.options,h=this.nodeWidth,d=this.nodeColumns;this.nodePadding=this.getNodePadding(),this.translationFactor=d.reduce(function(c,f){return Math.min(c,n(f))},1/0),this.colDistance=(a.plotSizeX-h-l.borderWidth)/Math.max(1,d.length-1),s.mapOptionsToLevel=getLevelOptions({from:1,levels:l.levels,to:d.length-1,defaults:{borderColor:l.borderColor,borderRadius:l.borderRadius,borderWidth:l.borderWidth,color:s.color,colorByPoint:l.colorByPoint,levelIsConstant:!0,linkColor:l.linkColor,linkLineWidth:l.linkLineWidth,linkOpacity:l.linkOpacity,states:l.states}}),d.forEach(function(c){c.forEach(function(f){s.translateNode(f,c)})},this),this.nodes.forEach(function(c){c.linksFrom.forEach(function(f){(f.weight||f.isNull)&&f.to&&(s.translateLink(f),f.allowShadow=!1)})})},r.prototype.translateLink=function(t){var n=function(V,j){var K=V.offset(t,j)*h,nt=Math.min(V.nodeY+K,V.nodeY+(V.shapeArgs&&V.shapeArgs.height||0)-d);return nt},s=t.fromNode,a=t.toNode,l=this.chart,h=this.translationFactor,d=Math.max(t.weight*h,this.options.minLinkWidth),c=this.options,f=(l.inverted?-this.colDistance:this.colDistance)*c.curveFactor,u=n(s,"linksFrom"),p=n(a,"linksTo"),g=s.nodeX,m=this.nodeWidth,v=a.column*this.colDistance,x=t.outgoing,y=v>g+m;if(l.inverted&&(u=l.plotSizeY-u,p=(l.plotSizeY||0)-p,v=l.plotSizeX-v,m=-m,d=-d,y=g>v),t.shapeType="path",t.linkBase=[u,u+d,p,p+d],y&&typeof p=="number")t.shapeArgs={d:[["M",g+m,u],["C",g+m+f,u,v-f,p,v,p],["L",v+(x?m:0),p+d/2],["L",v,p+d],["C",v-f,p+d,g+m+f,u+d,g+m,u+d],["Z"]]};else if(typeof p=="number"){var b=20,$=l.plotHeight-u-d,S=v-b-d,k=v-b,A=v,P=g+m,E=P+b,M=E+d,C=u,O=u+d,L=O+b,T=L+$,_=T+b,D=_+d,N=p,I=N+d,B=I+b,X=O-d*.7,W=_+d*.7,F=I-d*.7,U=A-d*.7,z=P+d*.7;t.shapeArgs={d:[["M",P,C],["C",z,C,M,X,M,L],["L",M,T],["C",M,W,z,D,P,D],["L",A,D],["C",U,D,S,W,S,T],["L",S,B],["C",S,F,U,N,A,N],["L",A,I],["C",k,I,k,I,k,B],["L",k,T],["C",k,_,k,_,A,_],["L",P,_],["C",E,_,E,_,E,T],["L",E,L],["C",E,O,E,O,P,O],["Z"]]}}t.dlBox={x:g+(v-g+m)/2,y:u+(p-u)/2,height:d,width:0},t.tooltipPos=l.inverted?[l.plotSizeY-t.dlBox.y-d/2,l.plotSizeX-t.dlBox.x]:[t.dlBox.x,t.dlBox.y+d/2],t.y=t.plotY=1,t.color||(t.color=s.color)},r.prototype.translateNode=function(t,n){var s=this.translationFactor,a=this.chart,l=this.options,h=t.getSum(),d=Math.max(Math.round(h*s),this.options.minLinkWidth),c=Math.round(l.borderWidth)%2/2,f=n.offset(t,s),u=Math.floor(pick$6(f.absoluteTop,n.top(s)+f.relativeTop))+c,p=Math.floor(this.colDistance*t.column+l.borderWidth/2)+c,g=a.inverted?a.plotSizeX-p:p,m=Math.round(this.nodeWidth);if(t.sum=h,h){t.shapeType="rect",t.nodeX=g,t.nodeY=u;var v=g,x=u,y=t.options.width||l.width||m,b=t.options.height||l.height||d;a.inverted&&(v=g-m,x=a.plotSizeY-u-d,y=t.options.height||l.height||m,b=t.options.width||l.width||d),t.dlOptions=r.getDLOptions({level:this.mapOptionsToLevel[t.level],optionsPoint:t.options}),t.plotX=1,t.plotY=1,t.tooltipPos=a.inverted?[a.plotSizeY-x-b/2,a.plotSizeX-v-y/2]:[v+y/2,x+b/2],t.shapeArgs={x:v,y:x,width:y,height:b,display:t.hasShape()?"":"none"}}else t.dlOptions={enabled:!1}},r.defaultOptions=merge$5(ColumnSeries$4.defaultOptions,{borderWidth:0,colorByPoint:!0,curveFactor:.33,dataLabels:{enabled:!0,backgroundColor:"none",crop:!1,nodeFormat:void 0,nodeFormatter:function(){return this.point.name},format:void 0,formatter:function(){},inside:!0},inactiveOtherPoints:!0,linkOpacity:.5,minLinkWidth:0,nodeWidth:20,nodePadding:10,showInLegend:!1,states:{hover:{linkOpacity:1},inactive:{linkOpacity:.1,opacity:.1,animation:{duration:50}}},tooltip:{followPointer:!0,headerFormat:'<span style="font-size: 10px">{series.name}</span><br/>',pointFormat:"{point.fromNode.name} → {point.toNode.name}: <b>{point.weight}</b><br/>",nodeFormat:"{point.name}: <b>{point.sum}</b><br/>"}}),r}(ColumnSeries$4);extend$5(SankeySeries$1.prototype,{animate:Series$2.prototype.animate,createNode:NodesMixin.createNode,destroy:NodesMixin.destroy,forceDL:!0,invertible:!0,isCartesian:!1,orderNodes:!0,pointArrayMap:["from","to"],pointClass:SankeyPoint$1,searchPoint:H.noop,setData:NodesMixin.setData});SeriesRegistry$1.registerSeriesType("sankey",SankeySeries$1);var __extends$7=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),Series$1=SeriesRegistry$1.series,PiePoint=SeriesRegistry$1.seriesTypes.pie.prototype.pointClass,defined$2=Utilities.defined,isNumber$2=Utilities.isNumber,merge$4=Utilities.merge,objectEach=Utilities.objectEach,pick$5=Utilities.pick,TimelinePoint=function(o){__extends$7(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return r.prototype.alignConnector=function(){var t=this,n=t.series,s=t.connector,a=t.dataLabel,l=t.dataLabel.options=merge$4(n.options.dataLabels,t.options.dataLabels),h=t.series.chart,d=s.getBBox(),c={x:d.x+a.translateX,y:d.y+a.translateY},f;h.inverted?c.y-=a.options.connectorWidth/2:c.x+=a.options.connectorWidth/2,f=h.isInsidePlot(c.x,c.y),s[f?"animate":"attr"]({d:t.getConnectorPath()}),n.chart.styledMode||s.attr({stroke:l.connectorColor||t.color,"stroke-width":l.connectorWidth,opacity:a[defined$2(a.newOpacity)?"newOpacity":"opacity"]})},r.prototype.drawConnector=function(){var t=this,n=t.series;t.connector||(t.connector=n.chart.renderer.path(t.getConnectorPath()).attr({zIndex:-1}).add(t.dataLabel)),t.series.chart.isInsidePlot(t.dataLabel.x,t.dataLabel.y)&&t.alignConnector()},r.prototype.getConnectorPath=function(){var t=this,n=t.series.chart,s=t.series.xAxis.len,a=n.inverted,l=a?"x2":"y2",h=t.dataLabel,d=h.targetPosition,c={x1:t.plotX,y1:t.plotY,x2:t.plotX,y2:isNumber$2(d.y)?d.y:h.y},f=(h.alignAttr||h)[l[0]]<t.series.yAxis.len/2,u;return a&&(c={x1:t.plotY,y1:s-t.plotX,x2:d.x||h.x,y2:s-t.plotX}),f&&(c[l]+=h[a?"width":"height"]),objectEach(c,function(p,g){c[g]-=(h.alignAttr||h)[g[0]]}),u=n.renderer.crispLine([["M",c.x1,c.y1],["L",c.x2,c.y2]],h.options.connectorWidth),u},r.prototype.init=function(){var t=o.prototype.init.apply(this,arguments);return t.name=pick$5(t.name,"Event"),t.y=1,t},r.prototype.isValid=function(){return this.options.y!==null},r.prototype.setState=function(){var t=o.prototype.setState;this.isNull||t.apply(this,arguments)},r.prototype.setVisible=function(t,n){var s=this,a=s.series;n=pick$5(n,a.options.ignoreHiddenPoint),PiePoint.prototype.setVisible.call(s,t,!1),a.processData(),n&&a.chart.redraw()},r.prototype.applyOptions=function(t,n){return t=Point$2.prototype.optionsToObject.call(this,t),this.userDLOptions=merge$4(this.userDLOptions,t.dataLabels),o.prototype.applyOptions.call(this,t,n)},r}(Series$1.prototype.pointClass),__extends$6=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),_a=SeriesRegistry$1.seriesTypes,ColumnSeries$3=_a.column,LineSeries=_a.line,addEvent$1=Utilities.addEvent,arrayMax=Utilities.arrayMax,arrayMin=Utilities.arrayMin,defined$1=Utilities.defined,extend$4=Utilities.extend,merge$3=Utilities.merge,pick$4=Utilities.pick,TimelineSeries=function(o){__extends$6(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t.userOptions=void 0,t.visibilityMap=void 0,t}return r.prototype.alignDataLabel=function(t,n,s,a){var l=this,h=l.chart.inverted,d=l.visibilityMap.filter(function(S){return S}),c=l.visiblePointsCount,f=d.indexOf(t),u=!f||f===c-1,p=l.options.dataLabels,g=t.userDLOptions||{},m=p.alternate?u?1.5:2:1,v,x=Math.floor(l.xAxis.len/c),y=n.padding,b,$;t.visible&&(v=Math.abs(g.x||t.options.dataLabels.x),h?(b=(v-y)*2-t.itemHeight/2,$={width:b+"px",textOverflow:n.width/b*n.height/2>x*m?"ellipsis":"none"}):$={width:(g.width||p.width||x*m-y*2)+"px"},n.css($),l.chart.styledMode||n.shadow(p.shadow)),o.prototype.alignDataLabel.apply(l,arguments)},r.prototype.bindAxes=function(){var t=this;o.prototype.bindAxes.call(t),["xAxis","yAxis"].forEach(function(n){n==="xAxis"&&!t[n].userOptions.type&&(t[n].categories=t[n].hasNames=!0)})},r.prototype.distributeDL=function(){var t=this,n=t.options.dataLabels,s=1;if(n){var a=n.distance||0;t.points.forEach(function(l){var h;l.options.dataLabels=merge$3((h={},h[t.chart.inverted?"x":"y"]=n.alternate&&s%2?-a:a,h),l.userDLOptions),s++})}},r.prototype.generatePoints=function(){var t=this;o.prototype.generatePoints.apply(t),t.points.forEach(function(n,s){n.applyOptions({x:t.xData[s]},t.xData[s])})},r.prototype.getVisibilityMap=function(){var t=this,n=(t.data.length?t.data:t.userOptions.data).map(function(s){return s&&s.visible!==!1&&!s.isNull?s:!1});return n},r.prototype.getXExtremes=function(t){var n=this,s=t.filter(function(a,l){return n.points[l].isValid()&&n.points[l].visible});return{min:arrayMin(s),max:arrayMax(s)}},r.prototype.init=function(){var t=this;o.prototype.init.apply(t,arguments),t.eventsToUnbind.push(addEvent$1(t,"afterTranslate",function(){var n,s=Number.MAX_VALUE;t.points.forEach(function(a){a.isInside=a.isInside&&a.visible,a.visible&&!a.isNull&&(defined$1(n)&&(s=Math.min(s,Math.abs(a.plotX-n))),n=a.plotX)}),t.closestPointRangePx=s})),t.eventsToUnbind.push(addEvent$1(t,"drawDataLabels",function(){t.distributeDL()})),t.eventsToUnbind.push(addEvent$1(t,"afterDrawDataLabels",function(){var n;t.points.forEach(function(s){if(n=s.dataLabel,n)return n.animate=function(a){return this.targetPosition&&(this.targetPosition=a),SVGElement.prototype.animate.apply(this,arguments)},n.targetPosition||(n.targetPosition={}),s.drawConnector()})})),t.eventsToUnbind.push(addEvent$1(t.chart,"afterHideOverlappingLabel",function(){t.points.forEach(function(n){n.connector&&n.dataLabel&&n.dataLabel.oldOpacity!==n.dataLabel.newOpacity&&n.alignConnector()})}))},r.prototype.markerAttribs=function(t,n){var s=this,a=s.options.marker,l,h=t.marker||{},d=h.symbol||a.symbol,c,f=pick$4(h.width,a.width,s.closestPointRangePx),u=pick$4(h.height,a.height),p=0,g;return s.xAxis.dateTime?o.prototype.markerAttribs.call(this,t,n):(n&&(l=a.states[n]||{},c=h.states&&h.states[n]||{},p=pick$4(c.radius,l.radius,p+(l.radiusPlus||0))),t.hasImage=d&&d.indexOf("url")===0,g={x:Math.floor(t.plotX)-f/2-p/2,y:t.plotY-u/2-p/2,width:f+p,height:u+p},g)},r.prototype.processData=function(){var t=this,n=0,s;for(t.visibilityMap=t.getVisibilityMap(),t.visibilityMap.forEach(function(a){a&&n++}),t.visiblePointsCount=n,s=0;s<t.xData.length;s++)t.yData[s]=1;o.prototype.processData.call(this,arguments)},r.defaultOptions=merge$3(LineSeries.defaultOptions,{colorByPoint:!0,stickyTracking:!1,ignoreHiddenPoint:!0,legendType:"point",lineWidth:4,tooltip:{headerFormat:'<span style="color:{point.color}">●</span> <span style="font-size: 10px"> {point.key}</span><br/>',pointFormat:"{point.description}"},states:{hover:{lineWidthPlus:0}},dataLabels:{enabled:!0,allowOverlap:!0,alternate:!0,backgroundColor:palette.backgroundColor,borderWidth:1,borderColor:palette.neutralColor40,borderRadius:3,color:palette.neutralColor80,connectorWidth:1,distance:100,formatter:function(){var t;return this.series.chart.styledMode?t="<span>● </span>":t='<span style="color:'+this.point.color+'">● </span>',t+='<span class="highcharts-strong">'+(this.key||"")+"</span><br/>"+(this.point.label||""),t},style:{textOutline:"none",fontWeight:"normal",fontSize:"12px"},shadow:!1,verticalAlign:"middle"},marker:{enabledThreshold:0,symbol:"square",radius:6,lineWidth:2,height:15},showInLegend:!1,colorKey:"x"}),r}(LineSeries);extend$4(TimelineSeries.prototype,{drawLegendSymbol:LegendSymbol$1.drawRectangle,drawTracker:ColumnSeries$3.prototype.drawTracker,pointClass:TimelinePoint,trackerGroups:["markerGroup","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("timeline",TimelineSeries);var __extends$5=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),SankeyPoint=SeriesRegistry$1.seriesTypes.sankey.prototype.pointClass,OrganizationPoint=function(o){__extends$5(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.fromNode=void 0,t.linksFrom=void 0,t.linksTo=void 0,t.options=void 0,t.series=void 0,t.toNode=void 0,t}return r.prototype.getSum=function(){return 1},r}(SankeyPoint),__extends$4=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),SankeySeries=SeriesRegistry$1.seriesTypes.sankey,css=Utilities.css,extend$3=Utilities.extend,merge$2=Utilities.merge,pick$3=Utilities.pick,wrap=Utilities.wrap,OrganizationSeries=function(o){__extends$4(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.curvedPath=function(t,n){for(var s=[],a=0;a<t.length;a++){var l=t[a][1],h=t[a][2];if(typeof l=="number"&&typeof h=="number")if(a===0)s.push(["M",l,h]);else if(a===t.length-1)s.push(["L",l,h]);else if(n){var d=t[a-1],c=t[a+1];if(d&&c){var f=d[1],u=d[2],p=c[1],g=c[2];if(typeof f=="number"&&typeof p=="number"&&typeof u=="number"&&typeof g=="number"&&f!==p&&u!==g){var m=f<p?1:-1,v=u<g?1:-1;s.push(["L",l-m*Math.min(Math.abs(l-f),n),h-v*Math.min(Math.abs(h-u),n)],["C",l,h,l,h,l+m*Math.min(Math.abs(l-p),n),h+v*Math.min(Math.abs(h-g),n)])}}}else s.push(["L",l,h])}return s},r.prototype.alignDataLabel=function(t,n,s){if(s.useHTML){var a=t.shapeArgs.width,l=t.shapeArgs.height,h=this.options.borderWidth+2*this.options.dataLabels.padding;this.chart.inverted&&(a=l,l=t.shapeArgs.width),l-=h,a-=h;var d=n.text;d&&(css(d.element.parentNode,{width:a+"px",height:l+"px"}),css(d.element,{left:0,top:0,width:"100%",height:"100%",overflow:"hidden"})),n.getBBox=function(){return{width:a,height:l}},n.width=a,n.height=l}o.prototype.alignDataLabel.apply(this,arguments)},r.prototype.createNode=function(t){var n=o.prototype.createNode.call(this,t);return n.getSum=function(){return 1},n},r.prototype.createNodeColumn=function(){var t=o.prototype.createNodeColumn.call(this);return wrap(t,"offset",function(n,s,a){var l=n.call(this,s,a);return s.hangsFrom?{absoluteTop:s.hangsFrom.nodeY}:l}),t},r.prototype.pointAttribs=function(t,n){var s=this,a=SankeySeries.prototype.pointAttribs.call(s,t,n),l=t.isNode?t.level:t.fromNode.level,h=s.mapOptionsToLevel[l||0]||{},d=t.options,c=h.states&&h.states[n]||{},f=["borderRadius","linkColor","linkLineWidth"].reduce(function(u,p){return u[p]=pick$3(c[p],d[p],h[p],s.options[p]),u},{});return t.isNode?f.borderRadius&&(a.r=f.borderRadius):(a.stroke=f.linkColor,a["stroke-width"]=f.linkLineWidth,delete a.fill),a},r.prototype.translateLink=function(t){var n=t.fromNode,s=t.toNode,a=Math.round(this.options.linkLineWidth)%2/2,l=Math.floor(n.shapeArgs.x+n.shapeArgs.width)+a,h=Math.floor(n.shapeArgs.y+n.shapeArgs.height/2)+a,d=Math.floor(s.shapeArgs.x)+a,c=Math.floor(s.shapeArgs.y+s.shapeArgs.height/2)+a,f,u=this.options.hangingIndent,p=s.options.offset,g=/%$/.test(p)&&parseInt(p,10),m=this.chart.inverted;m&&(l-=n.shapeArgs.width,d+=s.shapeArgs.width),f=Math.floor(d+(m?1:-1)*(this.colDistance-this.nodeWidth)/2)+a,g&&(g>=50||g<=-50)&&(f=d=Math.floor(d+(m?-.5:.5)*s.shapeArgs.width)+a,c=s.shapeArgs.y,g>0&&(c+=s.shapeArgs.height)),s.hangsFrom===n&&(this.chart.inverted?(h=Math.floor(n.shapeArgs.y+n.shapeArgs.height-u/2)+a,c=s.shapeArgs.y+s.shapeArgs.height):h=Math.floor(n.shapeArgs.y+u/2)+a,f=d=Math.floor(s.shapeArgs.x+s.shapeArgs.width/2)+a),t.plotY=1,t.shapeType="path",t.shapeArgs={d:r.curvedPath([["M",l,h],["L",f,h],["L",f,c],["L",d,c]],this.options.linkRadius)}},r.prototype.translateNode=function(t,n){SankeySeries.prototype.translateNode.call(this,t,n),t.hangsFrom&&(t.shapeArgs.height-=this.options.hangingIndent,this.chart.inverted||(t.shapeArgs.y+=this.options.hangingIndent)),t.nodeHeight=this.chart.inverted?t.shapeArgs.width:t.shapeArgs.height},r.defaultOptions=merge$2(SankeySeries.defaultOptions,{borderColor:palette.neutralColor60,borderRadius:3,linkRadius:10,borderWidth:1,dataLabels:{nodeFormatter:function(){var t={width:"100%",height:"100%",display:"flex","flex-direction":"row","align-items":"center","justify-content":"center"},n={"max-height":"100%","border-radius":"50%"},s={width:"100%",padding:0,"text-align":"center","white-space":"normal"},a={margin:0},l={margin:0},h={opacity:.75,margin:"5px"};function d(f){return Object.keys(f).reduce(function(u,p){return u+p+":"+f[p]+";"},'style="')+'"'}this.point.image&&(n["max-width"]="30%",s.width="70%"),this.series.chart.renderer.forExport&&(t.display="block",s.position="absolute",s.left=this.point.image?"30%":0,s.top=0);var c="<div "+d(t)+">";return this.point.image&&(c+='<img src="'+this.point.image+'" '+d(n)+">"),c+="<div "+d(s)+">",this.point.name&&(c+="<h4 "+d(a)+">"+this.point.name+"</h4>"),this.point.title&&(c+="<p "+d(l)+">"+(this.point.title||"")+"</p>"),this.point.description&&(c+="<p "+d(h)+">"+this.point.description+"</p>"),c+="</div></div>",c},style:{fontWeight:"normal",fontSize:"13px"},useHTML:!0},hangingIndent:20,linkColor:palette.neutralColor60,linkLineWidth:1,nodeWidth:50,tooltip:{nodeFormat:"{point.name}<br>{point.title}<br>{point.description}"}}),r}(SankeySeries);extend$3(OrganizationSeries.prototype,{pointClass:OrganizationPoint});SeriesRegistry$1.registerSeriesType("organization",OrganizationSeries);var __extends$3=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),ColumnSeries$2=SeriesRegistry$1.seriesTypes.column,extend$2=Utilities.extend,XRangePoint=function(o){__extends$3(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return r.getColorByCategory=function(t,n){var s=t.options.colors||t.chart.options.colors,a=s?s.length:t.chart.options.chart.colorCount,l=n.y%a,h=s&&s[l];return{colorIndex:l,color:h}},r.prototype.resolveColor=function(){var t=this.series,n;t.options.colorByPoint&&!this.options.color?(n=r.getColorByCategory(t,this),t.chart.styledMode||(this.color=n.color),this.options.colorIndex||(this.colorIndex=n.colorIndex)):this.color||(this.color=t.color)},r.prototype.init=function(){return Point$2.prototype.init.apply(this,arguments),this.y||(this.y=0),this},r.prototype.setState=function(){Point$2.prototype.setState.apply(this,arguments),this.series.drawPoint(this,this.series.getAnimationVerb())},r.prototype.getLabelConfig=function(){var t=this,n=Point$2.prototype.getLabelConfig.call(t),s=t.series.yAxis.categories;return n.x2=t.x2,n.yCategory=t.yCategory=s&&s[t.y],n},r.prototype.isValid=function(){return typeof this.x=="number"&&typeof this.x2=="number"},r}(ColumnSeries$2.prototype.pointClass);extend$2(XRangePoint.prototype,{tooltipDateKeys:["x","x2"]});var addEvent=Utilities.addEvent,pick$2=Utilities.pick;addEvent(Axis,"afterGetSeriesExtremes",function(){var o=this,r=o.series,t,n;o.isXAxis&&(t=pick$2(o.dataMax,-Number.MAX_VALUE),r.forEach(function(s){s.x2Data&&s.x2Data.forEach(function(a){a>t&&(t=a,n=!0)})}),n&&(o.dataMax=t))});var __extends$2=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),color=Color.parse,Series=SeriesRegistry$1.series,ColumnSeries$1=SeriesRegistry$1.seriesTypes.column,columnProto=ColumnSeries$1.prototype,clamp=Utilities.clamp,correctFloat=Utilities.correctFloat,defined=Utilities.defined,extend$1=Utilities.extend,find=Utilities.find,isNumber$1=Utilities.isNumber,isObject=Utilities.isObject,merge$1=Utilities.merge,pick$1=Utilities.pick,XRangeSeries=function(o){__extends$2(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r.prototype.init=function(){ColumnSeries$1.prototype.init.apply(this,arguments),this.options.stacking=void 0},r.prototype.getColumnMetrics=function(){var t,n=this.chart;function s(){n.series.forEach(function(a){var l=a.xAxis;a.xAxis=a.yAxis,a.yAxis=l})}return s(),t=columnProto.getColumnMetrics.call(this),s(),t},r.prototype.cropData=function(t,n,s,a){var l=Series.prototype.cropData,h=l.call(this,this.x2Data,n,s,a);return h.xData=t.slice(h.start,h.end),h},r.prototype.findPointIndex=function(t){var n=this,s=n.cropped,a=n.cropStart,l=n.points,h=t.id,d;if(h){var c=find(l,function(f){return f.id===h});d=c?c.index:void 0}if(typeof d>"u"){var c=find(l,function(u){return u.x===t.x&&u.x2===t.x2&&!u.touched});d=c?c.index:void 0}return s&&isNumber$1(d)&&isNumber$1(a)&&d>=a&&(d-=a),d},r.prototype.translatePoint=function(t){var n=this,s=n.xAxis,a=n.yAxis,l=n.columnMetrics,h=n.options,d=h.minPointLength||0,c=(t.shapeArgs&&t.shapeArgs.width||0)/2,f=n.pointXOffset=l.offset,u=t.plotX,p=pick$1(t.x2,t.x+(t.len||0)),g=s.translate(p,0,0,0,1),m=Math.abs(g-u),v,x,y=this.chart.inverted,b=pick$1(h.borderWidth,1),$=b%2/2,S=l.offset,k=Math.round(l.width),A,P,E,M,C;d&&(v=d-m,v<0&&(v=0),u-=v/2,g+=v/2),u=Math.max(u,-10),g=clamp(g,-10,s.len+10),defined(t.options.pointWidth)&&(S-=(Math.ceil(t.options.pointWidth)-k)/2,k=Math.ceil(t.options.pointWidth)),h.pointPlacement&&isNumber$1(t.plotY)&&a.categories&&(t.plotY=a.translate(t.y,0,1,0,1,h.pointPlacement));var O=Math.floor(Math.min(u,g))+$,L=Math.floor(Math.max(u,g))+$,T={x:O,y:Math.floor(t.plotY+S)+$,width:L-O,height:k,r:n.options.borderRadius};t.shapeArgs=T,y?t.tooltipPos[1]+=f+c:t.tooltipPos[0]-=c+f-T.width/2,A=T.x,P=A+T.width,A<0||P>s.len?(A=clamp(A,0,s.len),P=clamp(P,0,s.len),E=P-A,t.dlBox=merge$1(T,{x:A,width:P-A,centerX:E?E/2:null})):t.dlBox=null;var _=t.tooltipPos,D=y?1:0,N=y?0:1;C=n.columnMetrics?n.columnMetrics.offset:-l.width/2,y?_[D]+=T.width/2:_[D]+=(s.reversed?-1:0)*T.width,_[N]=clamp(_[N]+(y?-1:1)*C,0,a.len-1),x=t.partialFill,x&&(isObject(x)&&(x=x.amount),isNumber$1(x)||(x=0),t.partShapeArgs=merge$1(T,{r:n.options.borderRadius}),M=Math.max(Math.round(m*x+t.plotX-u),0),t.clipRectArgs={x:s.reversed?T.x+m-M:T.x,y:T.y,width:M,height:T.height})},r.prototype.translate=function(){columnProto.translate.apply(this,arguments),this.points.forEach(function(t){this.translatePoint(t)},this)},r.prototype.drawPoint=function(t,n){var s=this,a=s.options,l=s.chart.renderer,h=t.graphic,d=t.shapeType,c=t.shapeArgs,f=t.partShapeArgs,u=t.clipRectArgs,p=t.partialFill,g=a.stacking&&!a.borderRadius,m=t.state,v=a.states[m||"normal"]||{},x=typeof m>"u"?"attr":n,y=s.pointAttribs(t,m),b=pick$1(s.chart.options.chart.animation,v.animation),$;!t.isNull&&t.visible!==!1?(h?h.rect[n](c):(t.graphic=h=l.g("point").addClass(t.getClassName()).add(t.group||s.group),h.rect=l[d](merge$1(c)).addClass(t.getClassName()).addClass("highcharts-partfill-original").add(h)),f&&(h.partRect?(h.partRect[n](merge$1(f)),h.partialClipRect[n](merge$1(u))):(h.partialClipRect=l.clipRect(u.x,u.y,u.width,u.height),h.partRect=l[d](f).addClass("highcharts-partfill-overlay").add(h).clip(h.partialClipRect))),s.chart.styledMode||(h.rect[n](y,b).shadow(a.shadow,null,g),f&&(isObject(p)||(p={}),isObject(a.partialFill)&&(p=merge$1(a.partialFill,p)),$=p.fill||color(y.fill).brighten(-.3).get()||color(t.color||s.color).brighten(-.3).get(),y.fill=$,h.partRect[x](y,b).shadow(a.shadow,null,g)))):h&&(t.graphic=h.destroy())},r.prototype.drawPoints=function(){var t=this,n=t.getAnimationVerb();t.points.forEach(function(s){t.drawPoint(s,n)})},r.prototype.getAnimationVerb=function(){return this.chart.pointCount<(this.options.animationLimit||250)?"animate":"attr"},r.prototype.isPointInside=function(t){var n=t.shapeArgs,s=t.plotX,a=t.plotY;if(!n)return o.prototype.isPointInside.apply(this,arguments);var l=typeof s<"u"&&typeof a<"u"&&a>=0&&a<=this.yAxis.len&&(n.x||0)+(n.width||0)>=0&&s<=this.xAxis.len;return l},r.defaultOptions=merge$1(ColumnSeries$1.defaultOptions,{colorByPoint:!0,dataLabels:{formatter:function(){var t=this.point,n=t.partialFill;if(isObject(n)&&(n=n.amount),isNumber$1(n)&&n>0)return correctFloat(n*100)+"%"},inside:!0,verticalAlign:"middle"},tooltip:{headerFormat:'<span style="font-size: 10px">{point.x} - {point.x2}</span><br/>',pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.yCategory}</b><br/>'},borderRadius:3,pointRange:0}),r}(ColumnSeries$1);extend$1(XRangeSeries.prototype,{type:"xrange",parallelArrays:["x","x2","y"],requireSorting:!1,animate:Series.prototype.animate,cropShoulder:1,getExtremesFromAll:!0,autoIncrement:H.noop,buildKDTree:H.noop,pointClass:XRangePoint});SeriesRegistry$1.registerSeriesType("xrange",XRangeSeries);var __extends$1=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),BulletPoint=function(o){__extends$1(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return r.prototype.destroy=function(){this.targetGraphic&&(this.targetGraphic=this.targetGraphic.destroy()),o.prototype.destroy.apply(this,arguments)},r}(ColumnSeries$h.prototype.pointClass),__extends=function(){var o=function(r,t){return o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,s){n.__proto__=s}||function(n,s){for(var a in s)s.hasOwnProperty(a)&&(n[a]=s[a])},o(r,t)};return function(r,t){o(r,t);function n(){this.constructor=r}r.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}(),ColumnSeries=SeriesRegistry$1.seriesTypes.column,extend=Utilities.extend,isNumber=Utilities.isNumber,merge=Utilities.merge,pick=Utilities.pick,relativeLength=Utilities.relativeLength,BulletSeries=function(o){__extends(r,o);function r(){var t=o!==null&&o.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t.targetData=void 0,t}return r.prototype.drawPoints=function(){var t=this,n=t.chart,s=t.options,a=s.animationLimit||250;o.prototype.drawPoints.apply(this,arguments),t.points.forEach(function(l){var h=l.options,d=l.target,c=l.y,f,u=l.targetGraphic,p,g,m,v;if(isNumber(d)&&d!==null){m=merge(s.targetOptions,h.targetOptions),g=m.height;var x=l.shapeArgs;l.dlBox&&x&&!isNumber(x.width)&&(x=l.dlBox),p=relativeLength(m.width,x.width),v=t.yAxis.translate(d,!1,!0,!1,!0)-m.height/2-.5,f=t.crispCol.apply({chart:n,borderWidth:m.borderWidth,options:{crisp:s.crisp}},[x.x+x.width/2-p/2,v,p,g]),u?(u[n.pointCount<a?"animate":"attr"](f),isNumber(c)&&c!==null?u.element.point=l:u.element.point=void 0):l.targetGraphic=u=n.renderer.rect().attr(f).add(t.group),n.styledMode||u.attr({fill:pick(m.color,h.color,t.zones.length&&(l.getZone.call({series:t,x:l.x,y:d,options:{}}).color||t.color)||void 0,l.color,t.color),stroke:pick(m.borderColor,l.borderColor,t.options.borderColor),"stroke-width":m.borderWidth,r:m.borderRadius}),isNumber(c)&&c!==null&&(u.element.point=l),u.addClass(l.getClassName()+" highcharts-bullet-target",!0)}else u&&(l.targetGraphic=u.destroy())})},r.prototype.getExtremes=function(t){var n=o.prototype.getExtremes.call(this,t),s=this,a=s.targetData;if(a&&a.length){var l=o.prototype.getExtremes.call(this,a);isNumber(l.dataMin)&&(n.dataMin=Math.min(pick(n.dataMin,1/0),l.dataMin)),isNumber(l.dataMax)&&(n.dataMax=Math.max(pick(n.dataMax,-1/0),l.dataMax))}return n},r.defaultOptions=merge(ColumnSeries.defaultOptions,{targetOptions:{width:"140%",height:3,borderWidth:0,borderRadius:0},tooltip:{pointFormat:'<span style="color:{series.color}">●</span> {series.name}: <b>{point.y}</b>. Target: <b>{point.target}</b><br/>'}}),r}(ColumnSeries);extend(BulletSeries.prototype,{parallelArrays:["x","y","target"],pointArrayMap:["y","target"]});BulletSeries.prototype.pointClass=BulletPoint;SeriesRegistry$1.registerSeriesType("bullet",BulletSeries);/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/function isSlot(o){return o.localName==="slot"}let FlattenedNodesObserver=class{static getFlattenedNodes(o){const r=wrap$e(o);return isSlot(o)?(o=o,r.assignedNodes({flatten:!0})):Array.from(r.childNodes).map(t=>isSlot(t)?(t=t,wrap$e(t).assignedNodes({flatten:!0})):[t]).reduce((t,n)=>t.concat(n),[])}constructor(o,r){this._shadyChildrenObserver=null,this._nativeChildrenObserver=null,this._connected=!1,this._target=o,this.callback=r,this._effectiveNodes=[],this._observer=null,this._scheduled=!1,this._boundSchedule=()=>{this._schedule()},this.connect(),this._schedule()}connect(){isSlot(this._target)?this._listenSlots([this._target]):wrap$e(this._target).children&&(this._listenSlots(wrap$e(this._target).children),window.ShadyDOM?this._shadyChildrenObserver=window.ShadyDOM.observeChildren(this._target,o=>{this._processMutations(o)}):(this._nativeChildrenObserver=new MutationObserver(o=>{this._processMutations(o)}),this._nativeChildrenObserver.observe(this._target,{childList:!0}))),this._connected=!0}disconnect(){isSlot(this._target)?this._unlistenSlots([this._target]):wrap$e(this._target).children&&(this._unlistenSlots(wrap$e(this._target).children),window.ShadyDOM&&this._shadyChildrenObserver?(window.ShadyDOM.unobserveChildren(this._shadyChildrenObserver),this._shadyChildrenObserver=null):this._nativeChildrenObserver&&(this._nativeChildrenObserver.disconnect(),this._nativeChildrenObserver=null)),this._connected=!1}_schedule(){this._scheduled||(this._scheduled=!0,microTask.run(()=>this.flush()))}_processMutations(o){this._processSlotMutations(o),this.flush()}_processSlotMutations(o){if(o)for(let r=0;r<o.length;r++){let t=o[r];t.addedNodes&&this._listenSlots(t.addedNodes),t.removedNodes&&this._unlistenSlots(t.removedNodes)}}flush(){if(!this._connected)return!1;window.ShadyDOM&&ShadyDOM.flush(),this._nativeChildrenObserver?this._processSlotMutations(this._nativeChildrenObserver.takeRecords()):this._shadyChildrenObserver&&this._processSlotMutations(this._shadyChildrenObserver.takeRecords()),this._scheduled=!1;let o={target:this._target,addedNodes:[],removedNodes:[]},r=this.constructor.getFlattenedNodes(this._target),t=calculateSplices(r,this._effectiveNodes);for(let s=0,a;s<t.length&&(a=t[s]);s++)for(let l=0,h;l<a.removed.length&&(h=a.removed[l]);l++)o.removedNodes.push(h);for(let s=0,a;s<t.length&&(a=t[s]);s++)for(let l=a.index;l<a.index+a.addedCount;l++)o.addedNodes.push(r[l]);this._effectiveNodes=r;let n=!1;return(o.addedNodes.length||o.removedNodes.length)&&(n=!0,this.callback.call(this._target,o)),n}_listenSlots(o){for(let r=0;r<o.length;r++){let t=o[r];isSlot(t)&&t.addEventListener("slotchange",this._boundSchedule)}}_unlistenSlots(o){for(let r=0;r<o.length;r++){let t=o[r];isSlot(t)&&t.removeEventListener("slotchange",this._boundSchedule)}}};function inflateFunctions(config){if(Array.isArray(config)){config.forEach(inflateFunctions);return}!(config instanceof Object)||config.constructor!==Object||Object.entries(config).forEach(([attr,targetProperty])=>{if(attr.startsWith("_fn_")&&(typeof targetProperty=="string"||targetProperty instanceof String)){try{config[attr.substr(4)]=eval(`(${targetProperty})`)}catch(e){config[attr.substr(4)]=eval(`(function(){${targetProperty}})`)}delete config[attr]}else targetProperty instanceof Object&&inflateFunctions(targetProperty)})}/**
 * @license
 * Copyright (c) 2000 - 2024 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */class ChartSeries extends PolymerElement{static get is(){return"vaadin-chart-series"}static get properties(){return{values:{type:Array,value:()=>[]},valueMin:{type:Number,reflectToAttribute:!0},valueMax:{type:Number,reflectToAttribute:!0},type:{type:String,reflectToAttribute:!0},title:{type:String,reflectToAttribute:!0},markers:{type:String,reflectToAttribute:!0},unit:{type:String,reflectToAttribute:!0},stack:{type:String,reflectToAttribute:!0},neckPosition:{type:String,reflectToAttribute:!0},neckWidth:{type:String,reflectToAttribute:!0},options:{type:Object},additionalOptions:{type:Object,reflectToAttribute:!0},_series:{type:Object}}}static get observers(){return["__additionalOptionsObserver(additionalOptions.*, _series)","__markersObserver(markers, _series)","__neckPositionObserver(neckPosition, _series)","__neckWidthObserver(neckWidth, _series)","__stackObserver(stack, _series)","__titleObserver(title, _series)","__typeObserver(type, _series)","__unitObserver(unit, valueMin, valueMax, _series)","__valueMinObserver(valueMin, _series)","__valueMaxObserver(valueMax, _series)","__valuesObserver(values.splices, _series)"]}get options(){const r=deepMerge({},this.additionalOptions);return this.type&&(r.type=this.type),this.title&&(r.name=this.title),this.values&&(r.data=this.values),this.markers&&(this.__isMarkersValid()||(this.markers="auto"),r.marker=this.__markersConfiguration),this.unit&&(r.yAxis=this.unit),this.stack&&(r.stack=this.stack),isFinite(this.valueMin)&&(r.yAxisValueMin=this.valueMin),isFinite(this.valueMax)&&(r.yAxisValueMax=this.valueMax),this.neckWidth&&(r.neckWidth=this.neckWidth),this.neckPosition&&(r.neckHeight=this.neckPosition),r}get __markersConfiguration(){const r={};switch(this.markers){case"shown":r.enabled=!0;break;case"hidden":r.enabled=!1;break;case"auto":default:r.enabled=null;break}return r}setSeries(r){this._series=r}__valuesObserver(r,t){t&&t.setData(this.values)}__additionalOptionsObserver(r,t){t&&r.base&&t.update(r.base)}__updateAxis(r,t,n){if(!isFinite(t)){this.__showWarn(`value-${n}`,"Numbers or null");return}r&&r.yAxis&&r.yAxis.update({[n]:t})}__valueMinObserver(r,t){r===void 0||t==null||this.__updateAxis(t,r,"min")}__valueMaxObserver(r,t){r===void 0||t==null||this.__updateAxis(t,r,"max")}__typeObserver(r,t){r&&t&&t.update({type:r})}__titleObserver(r,t){r===void 0||t==null||t.update({name:r})}__stackObserver(r,t){r===void 0||t==null||t.update({stack:r})}__neckPositionObserver(r,t){r===void 0||t==null||t.update({neckHeight:r})}__neckWidthObserver(r,t){r===void 0||t==null||t.update({neckWidth:r})}__unitObserver(r,t,n,s){if(s&&r!==this.__oldUnit){this.__oldUnit=r;const a=this.parentNode instanceof Chart&&this.parentNode;if(a&&a instanceof Chart){if(r&&!a.__getAxis(r)){const l={title:{text:r}};a.__addAxis({id:r,axisGenerated:!0,...l})}s.update({yAxis:r||0}),t!==void 0&&this.__updateAxis(s,t,"min"),n!==void 0&&this.__updateAxis(s,n,"max"),a.__removeAxisIfEmpty()}}}__isMarkersValid(){return["shown","hidden","auto"].indexOf(this.markers)===-1?(this.__showWarn("markers",'"shown", "hidden" or "auto"'),!1):!0}__markersObserver(r,t){if(!(r===void 0||t==null)){if(!this.__isMarkersValid()){this.markers="auto";return}t.update({marker:this.__markersConfiguration})}}__showWarn(r,t){console.warn(`<vaadin-chart-series> Acceptable values for "${r}" are ${t}`)}}defineCustomElement(ChartSeries);/**
 * @license
 * Copyright (c) 2000 - 2024 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */function deepMerge(o,r){const t=n=>n&&typeof n=="object"&&!Array.isArray(n);return t(r)&&t(o)&&Object.keys(r).forEach(n=>{t(r[n])?(o[n]||Object.assign(o,{[n]:{}}),deepMerge(o[n],r[n])):Object.assign(o,{[n]:r[n]})}),o}["exportChart","exportChartLocal","getSVG"].forEach(o=>{G$7.wrap(G$7.Chart.prototype,o,function(r,...t){G$7.fireEvent(this,"beforeExport");const n=r.apply(this,t);return G$7.fireEvent(this,"afterExport"),n})});Pointer.prototype.onDocumentMouseMove=function(o){const r=this.chart,t=this.chartPosition,n=this.normalize(o,t),s=r.tooltip;t&&(!s||!s.isStickyOnContact())&&!r.isInsidePlot(n.chartX-r.plotLeft,n.chartY-r.plotTop,{visiblePlotOnly:!0})&&!this.inClass(n.composedPath()[0],"highcharts-tracker")&&this.reset()};G$7.setOptions({lang:{noData:""}});class Chart extends ResizeMixin(ElementMixin(ThemableMixin(PolymerElement))){static get template(){return html`
      <style>
        :host {
          display: block;
          width: 100%;
          overflow: hidden;
        }

        :host([hidden]) {
          display: none !important;
        }
      </style>
      <div id="chart"></div>
      <slot id="slot"></slot>
    `}static get is(){return"vaadin-chart"}static get cvdlName(){return"vaadin-chart"}static get properties(){return{configuration:Object,categories:{type:Object,reflectToAttribute:!0},categoryMax:{type:Number,reflectToAttribute:!0},categoryMin:{type:Number,reflectToAttribute:!0},categoryPosition:{type:String,reflectToAttribute:!0},noLegend:{type:Boolean,reflectToAttribute:!0},stacking:{type:String,reflectToAttribute:!0},timeline:{type:Boolean,reflectToAttribute:!0},title:{type:String,reflectToAttribute:!0},tooltip:{type:Boolean,reflectToAttribute:!0},type:{type:String,reflectToAttribute:!0},subtitle:{type:String,reflectToAttribute:!0},chart3d:{type:Boolean,reflectToAttribute:!0},emptyText:{type:String,reflectToAttribute:!0},additionalOptions:{type:Object,reflectToAttribute:!0},polar:{type:Boolean,reflectToAttribute:!0}}}static get observers(){return["__chart3dObserver(chart3d, configuration)","__emptyTextObserver(emptyText, configuration)","__hideLegend(noLegend, configuration)","__polarObserver(polar, configuration)","__stackingObserver(stacking, configuration)","__tooltipObserver(tooltip, configuration)","__updateCategories(categories, configuration)","__updateCategoryMax(categoryMax, configuration)","__updateCategoryMin(categoryMin, configuration)","__updateCategoryPosition(categoryPosition, configuration)","__updateSubtitle(subtitle, configuration)","__updateTitle(title, configuration)","__updateType(type, configuration)","__updateAdditionalOptions(additionalOptions.*)"]}static __callHighchartsFunction(r,t,...n){const s=G$7[r];s&&typeof s=="function"&&(n.forEach(a=>inflateFunctions(a)),s.apply(this.configuration,n),t&&G$7.charts.forEach(a=>{a!==void 0&&a.redraw()}))}constructor(){super(),this._baseConfig={annotations:[],chart:{styledMode:!0},credits:{enabled:!1},exporting:{enabled:!1},title:{text:null},series:[],xAxis:{},yAxis:{axisGenerated:!0}},this._baseChart3d={enabled:!0,alpha:15,beta:15,depth:50}}get options(){const r={...this._baseConfig};return deepMerge(r,this.additionalOptions),this.type&&(r.chart.type=this.type),this.polar&&(r.chart.polar=!0),this.title&&(r.title={text:this.title}),r.tooltip||(r.tooltip={},this.tooltip||(r.tooltip.enabled=!1)),this.subtitle&&(r.subtitle={text:this.subtitle}),this.categories&&(Array.isArray(r.xAxis)?r.xAxis[0].categories=this.categories:r.xAxis.categories=this.categories),isFinite(this.categoryMin)&&(Array.isArray(r.xAxis)?r.xAxis[0].min=this.categoryMin:r.xAxis.min=this.categoryMin),isFinite(this.categoryMax)&&(Array.isArray(r.xAxis)?r.xAxis[0].max=this.categoryMax:r.xAxis.max=this.categoryMax),this.noLegend&&(r.legend={enabled:!1}),this.emptyText&&(r.lang||(r.lang={}),r.lang.noData=this.emptyText),this.categoryPosition&&(r.chart.inverted=this.__shouldInvert(),Array.isArray(r.xAxis)?r.xAxis.forEach(t=>{t.opposite=this.__shouldFlipOpposite()}):r.xAxis&&(r.xAxis.opposite=this.__shouldFlipOpposite())),this.stacking&&(r.plotOptions||(r.plotOptions={}),r.plotOptions.series||(r.plotOptions.series={}),r.plotOptions.series.stacking=this.stacking),this.chart3d&&(r.chart.options3d={...this._baseChart3d,...r.chart.options3d}),r}get __chartEventNames(){return{addSeries:"chart-add-series",afterExport:"chart-after-export",afterPrint:"chart-after-print",beforeExport:"chart-before-export",beforePrint:"chart-before-print",click:"chart-click",drilldown:"chart-drilldown",drillup:"chart-drillup",drillupall:"chart-drillupall",load:"chart-load",redraw:"chart-redraw",selection:"chart-selection"}}get __seriesEventNames(){return{afterAnimate:"series-after-animate",checkboxClick:"series-checkbox-click",click:"series-click",hide:"series-hide",legendItemClick:"series-legend-item-click",mouseOut:"series-mouse-out",mouseOver:"series-mouse-over",show:"series-show"}}get __pointEventNames(){return{click:"point-click",legendItemClick:"point-legend-item-click",mouseOut:"point-mouse-out",mouseOver:"point-mouse-over",remove:"point-remove",select:"point-select",unselect:"point-unselect",update:"point-update"}}get __xAxesEventNames(){return{afterSetExtremes:"xaxes-extremes-set"}}get __yAxesEventNames(){return{afterSetExtremes:"yaxes-extremes-set"}}connectedCallback(){super.connectedCallback(),this.__updateStyles(),beforeNextRender(this,()=>{if(this.configuration){this.__reflow();return}this.__resetChart(),this.__addChildObserver(),this.__checkTurboMode()})}ready(){super.ready(),this.addEventListener("chart-redraw",this.__onRedraw.bind(this))}_onResize(r){if(!this.configuration)return;const{height:t,width:n}=r,{chartHeight:s,chartWidth:a}=this.configuration;(t!==s||n!==a)&&this.__reflow()}__reflow(){this.configuration&&this.configuration.reflow()}__addChildObserver(){this._childObserver=new FlattenedNodesObserver(this.$.slot,r=>{this.__addSeries(r.addedNodes.filter(this.__filterSeriesNodes)),this.__removeSeries(r.removedNodes.filter(this.__filterSeriesNodes)),this.__cleanupAfterSeriesRemoved(r.removedNodes.filter(this.__filterSeriesNodes))})}__filterSeriesNodes(r){return r.nodeType===Node.ELEMENT_NODE&&r instanceof ChartSeries}__addSeries(r){if(this.__isSeriesEmpty(r))return;const t=Array.from(this.childNodes).filter(this.__filterSeriesNodes),n=this.configuration.yAxis.reduce((s,a,l)=>(s[a.options.id||l]=a,s),{});for(let s=0,a=r.length;s<a;s++){const l=r[s],{yAxis:h,yAxisValueMin:d,yAxisValueMax:c}=l.options,f=t.indexOf(l);!h&&!this.configuration.yAxis.some(p=>p.userOptions.id===void 0)?n[h]=this.__addAxis({axisGenerated:!0}):h&&!n[h]&&(n[h]=this.__addAxis({id:h,title:{text:h},axisGenerated:!0})),isFinite(d)&&this.__setYAxisProps(n,h,{min:d}),isFinite(c)&&this.__setYAxisProps(n,h,{max:c});const u=this.__updateOrAddSeriesInstance(l.options,f,!1);l.setSeries(u)}this.__removeAxisIfEmpty(),this.configuration.redraw()}__removeSeries(r){this.__isSeriesEmpty(r)||r.forEach(t=>{t instanceof ChartSeries&&t._series.remove()})}__setYAxisProps(r,t,n){t?r[t].update(n):this.configuration.yAxis[0].update(n)}__isSeriesEmpty(r){return r===null||r.length===0}__cleanupAfterSeriesRemoved(r){this.__isSeriesEmpty(r)||(this.__removeAxisIfEmpty(),this.__updateNoDataElement(this.configuration))}__initChart(r){this.__initEventsListeners(r),this.__updateStyledMode(r),this.timeline?this.configuration=G$7.stockChart(this.$.chart,r):this.configuration=G$7.chart(this.$.chart,r)}__updateStyledMode(r){const t=r.chart.styledMode;this.$.chart.toggleAttribute("styled-mode",!!t)}disconnectedCallback(){super.disconnectedCallback(),queueMicrotask(()=>{this.isConnected||(this.configuration&&(this.configuration.destroy(),this.configuration=void 0,Array.from(this.childNodes).filter(this.__filterSeriesNodes).forEach(t=>{t.setSeries(null)})),this._childObserver&&this._childObserver.disconnect())})}__resetChart(){const r={...this.options,...this._jsonConfigurationBuffer};this.__initChart(r),this._jsonConfigurationBuffer=null}__getAxis(r,t){if(r=Number.parseInt(r)||r,this.configuration)return(t?this.configuration.xAxis:this.configuration.yAxis).find(n=>n.options.id===r)}__addAxis(r,t){if(this.configuration)return this.__createEventListeners(t?this.__xAxesEventNames:this.__yAxesEventNames,r,"events","axis"),this.configuration.addAxis(r,t)}__removeAxisIfEmpty(r){this.configuration&&(r?this.configuration.xAxis:this.configuration.yAxis).forEach(t=>{t.userOptions.axisGenerated&&t.series.length===0&&t.remove()})}updateConfiguration(r,t){(t||!this._jsonConfigurationBuffer)&&(this._jsonConfigurationBuffer={});const n=deepMerge({},r);inflateFunctions(n),this._jsonConfigurationBuffer=this.__makeConfigurationBuffer(this._jsonConfigurationBuffer,n),beforeNextRender(this,()=>{if(!(!this.configuration||!this._jsonConfigurationBuffer)){if(t){this.__resetChart();return}this.configuration.update(this._jsonConfigurationBuffer,!1),this._jsonConfigurationBuffer.credits&&this.__updateOrAddCredits(this._jsonConfigurationBuffer.credits),this._jsonConfigurationBuffer.xAxis&&this.__updateOrAddAxes(this._jsonConfigurationBuffer.xAxis,!0,!1),this._jsonConfigurationBuffer.yAxis&&this.__updateOrAddAxes(this._jsonConfigurationBuffer.yAxis,!1,!1),this._jsonConfigurationBuffer.series&&this.__updateOrAddSeries(this._jsonConfigurationBuffer.series,!1),this._jsonConfigurationBuffer=null,this.configuration.redraw()}})}__makeConfigurationBuffer(r,t){const n=G$7.merge(t),s=G$7.merge(r);return this.__mergeConfigurationArray(s,n,"series"),this.__mergeConfigurationArray(s,n,"xAxis"),this.__mergeConfigurationArray(s,n,"yAxis"),G$7.merge(s,n)}__mergeConfigurationArray(r,t,n){if(!t||!t[n]||!Array.isArray(t[n]))return;if(!r[n]){r[n]=Array.from(t[n]);return}const s=Math.max(r[n].length,t[n].length);for(let a=0;a<s;a++)r[n][a]=G$7.merge(r[n][a],t[n][a]);delete t[n]}__initEventsListeners(r){this.__initChartEventsListeners(r),this.__initSeriesEventsListeners(r),this.__initPointsEventsListeners(r),this.__initAxisEventsListeners(r,!0),this.__initAxisEventsListeners(r,!1)}__initChartEventsListeners(r){this.__createEventListeners(this.__chartEventNames,r,"chart.events","chart")}__initSeriesEventsListeners(r){this.__createEventListeners(this.__seriesEventNames,r,"plotOptions.series.events","series")}__initPointsEventsListeners(r){this.__createEventListeners(this.__pointEventNames,r,"plotOptions.series.point.events","point")}__initAxisEventsListeners(r,t){let n,s;t?(n=this.__xAxesEventNames,s=r.xAxis):(n=this.__yAxesEventNames,s=r.yAxis),Array.isArray(s)?s.forEach(a=>this.__createEventListeners(n,a,"events","axis")):this.__createEventListeners(n,s,"events","axis")}__createEventListeners(r,t,n,s){const a=this.__ensureObjectPath(t,n);for(let l=Object.keys(r),h=0;h<l.length;h++){const d=l[h];a[d]||(a[d]=c=>{const f={bubbles:!1,composed:!0,detail:{originalEvent:c,[s]:c.target}};if(!(c.type==="afterSetExtremes"&&(c.min==null||c.max==null))){if(c.type==="selection"&&(c.xAxis&&c.xAxis[0]&&(f.detail.xAxisMin=c.xAxis[0].min,f.detail.xAxisMax=c.xAxis[0].max),c.yAxis&&c.yAxis[0]&&(f.detail.yAxisMin=c.yAxis[0].min,f.detail.yAxisMax=c.yAxis[0].max)),c.type==="click"&&(c.xAxis&&c.xAxis[0]&&(f.detail.xValue=c.xAxis[0].value),c.yAxis&&c.yAxis[0]&&(f.detail.yValue=c.yAxis[0].value)),["beforePrint","beforeExport"].indexOf(c.type)>=0&&!this.tempBodyStyle){let u="";[...this.shadowRoot.querySelectorAll("style")].forEach(p=>{u+=p.textContent}),u=u.replace(/:host\(.+?\)/gu,p=>{const g=p.substr(6,p.length-7);return this.matches(g)?"":p}),u=`${u}body {    -moz-transform: scale(0.9, 0.9);    zoom: 0.9;    zoom: 90%;}`,this.tempBodyStyle=document.createElement("style"),this.tempBodyStyle.textContent=u,document.body.appendChild(this.tempBodyStyle),this.options.chart.styledMode&&document.body.setAttribute("styled-mode","")}if(["afterPrint","afterExport"].indexOf(c.type)>=0&&this.tempBodyStyle&&(document.body.removeChild(this.tempBodyStyle),delete this.tempBodyStyle,this.options.chart.styledMode&&document.body.removeAttribute("styled-mode")),this.dispatchEvent(new CustomEvent(r[d],f)),c.type==="legendItemClick"&&this._visibilityTogglingDisabled)return!1}})}}__ensureObjectPath(r,t){if(typeof t=="string")return t=t.split("."),t.reduce((n,s)=>(n[s]||(n[s]={}),n[s]),r)}__hasConfigurationBuffer(r){return get(r,this._jsonConfigurationBuffer)!==void 0}__updateOrAddCredits(r){this.configuration.credits?this.configuration.credits.update(r):this.configuration.addCredits(r)}__updateOrAddAxes(r,t,n){Array.isArray(r)||(r=[r]);const s=t?this.configuration.xAxis:this.configuration.yAxis;for(let a=0;a<r.length;a++){const l=r[a];s[a]?s[a].update(l,n):this.configuration.addAxis(l,t,n)}}__updateOrAddSeries(r,t){if(!Array.isArray(r))throw new Error("The type of jsonConfiguration.series should be Object[]");for(let n=0;n<r.length;n++){const s=r[n];this.__updateOrAddSeriesInstance(s,n,t)}}__updateOrAddSeriesInstance(r,t,n){return this.configuration.series[t]?this.configuration.series[t].update(r,n):this.configuration.addSeries(r,n),this.configuration.series[t]}__updateCategories(r,t){r===void 0||!t||this.__hasConfigurationBuffer("xAxis.categories")||this.__updateOrAddAxes([{categories:r}],!0)}__updateCategoryMax(r,t){if(!(r===void 0||!t||this.__hasConfigurationBuffer("xAxis.max"))){if(!isFinite(r)){console.warn('<vaadin-chart> Acceptable value for "category-max" are Numbers or null');return}this.__updateOrAddAxes([{max:r}],!0)}}__updateCategoryMin(r,t){if(!(r===void 0||!t||this.__hasConfigurationBuffer("xAxis.min"))){if(!isFinite(r)){console.warn('<vaadin-chart> Acceptable value for "category-min" are Numbers or null');return}this.__updateOrAddAxes([{min:r}],!0)}}__shouldInvert(){if(this.type==="bar"&&["top","bottom"].indexOf(this.categoryPosition)>=0){console.warn(`<vaadin-chart> Acceptable "category-position" values for bar charts are
          "left" and "right". For "top" and "bottom" positions please consider using a column chart.`);return}return["left","right"].indexOf(this.categoryPosition)>=0}__shouldFlipOpposite(){const r=["top","right"],t=["right"];return(this.type==="bar"?t:r).indexOf(this.categoryPosition)>=0}__updateCategoryPosition(r,t){if(r===void 0||!t||this.__hasConfigurationBuffer("chart.inverted"))return;const n=["left","right","top","bottom"];if(n.indexOf(r)<0){console.warn(`<vaadin-chart> Acceptable "category-position" values are ${n}`);return}t.update({chart:{inverted:this.__shouldInvert()}}),t.xAxis.forEach(s=>s.update({opposite:this.__shouldFlipOpposite()}))}__hideLegend(r,t){r===void 0||!t||this.__hasConfigurationBuffer("legend")||(t.legend?t.legend.update({enabled:!r}):t.legend={enabled:!r})}__updateTitle(r,t){r===void 0||!t||this.__hasConfigurationBuffer("title")||t.title.update({text:r})}__tooltipObserver(r,t){r===void 0||!t||this.__hasConfigurationBuffer("tooltip")||t.tooltip.update({enabled:r})}__updateType(r,t){r===void 0||!t||this.__hasConfigurationBuffer("chart.type")||t.update({chart:{type:r||"line"}})}__updateSubtitle(r,t){r===void 0||!t||this.__hasConfigurationBuffer("subtitle")||(t.subtitle?t.subtitle.update({text:r}):t.setSubtitle({text:r}))}__updateAdditionalOptions(r){this.configuration&&r.base&&this.updateConfiguration(r.base)}__isStackingValid(){return["normal","percent",null].indexOf(this.stacking)===-1?(this.__showWarn("stacking",'"normal", "percent" or null'),!1):!0}__stackingObserver(r,t){if(!(r===void 0||!t||this.__hasConfigurationBuffer("plotOptions.series.stacking"))){if(!this.__isStackingValid()){this.stacking=null;return}t.update({plotOptions:{series:{stacking:r}}})}}__chart3dObserver(r,t){r===void 0||!t||this.__hasConfigurationBuffer("chart.options3d")||(r?t.update({chart:{options3d:{...this._baseChart3d,...this.additionalOptions&&this.additionalOptions.chart&&this.additionalOptions.chart.options3d,enabled:!0}}}):t.update({chart:{options3d:{enabled:!1}}}))}__polarObserver(r,t){r===void 0||!t||this.__hasConfigurationBuffer("chart.polar")||t.update({chart:{polar:r}})}__emptyTextObserver(r,t){r===void 0||!t||this.__hasConfigurationBuffer("lang.noData")||(t.update({lang:{noData:r}}),this.__updateNoDataElement(t))}__updateNoDataElement(r){r.series.every(n=>n.data.length===0)&&(r.hideNoData(),r.showNoData(this.emptyText))}__callChartFunction(r,...t){if(this.configuration){const n=this.configuration[r];n&&typeof n=="function"&&(t.forEach(s=>inflateFunctions(s)),n.apply(this.configuration,t))}}__callSeriesFunction(r,t,...n){if(this.configuration&&this.configuration.series[t]){const s=this.configuration.series[t],a=s[r];a&&typeof a=="function"&&(n.forEach(l=>inflateFunctions(l)),a.apply(s,n))}}__callAxisFunction(r,t,n,...s){if(this.configuration){let a;switch(t){case 0:a=this.configuration.xAxis;break;case 1:a=this.configuration.yAxis;break;case 2:a=this.configuration.zAxis;break;case 3:a=this.configuration.colorAxis;break}if(a&&a[n]){const l=a[n],h=l[r];h&&typeof h=="function"&&(s.forEach(d=>inflateFunctions(d)),h.apply(l,s))}}}__callPointFunction(r,t,n,...s){if(this.configuration&&this.configuration.series[t]&&this.configuration.series[t].data[n]){const a=this.configuration.series[t].data[n],l=a[r];l&&typeof l=="function"&&l.apply(a,s)}}__updateStyles(){if(getComputedStyle(this).flex!=="0 1 auto"){this.$.chart.setAttribute("style","flex: 1; ");let t="";this.hasAttribute("style")&&(t=this.getAttribute("style"),t.endsWith(";")||(t+=";")),t+="display: flex;",this.setAttribute("style",t)}else this.$.chart.setAttribute("style","height:100%; width:100%;")}__showWarn(r,t){console.warn(`<vaadin-chart> Acceptable values for "${r}" are ${t}`)}__onRedraw(){this.__checkTurboMode()}__checkTurboMode(){const r=!!window.Vaadin.developmentMode;if(!this.configuration||!r||this.__turboModeWarningAlreadyLogged)return;this.configuration.series.some(n=>{const s=n.options&&n.options.turboThreshold||0,a=n.data.length;return s>0&&a>s})&&(this.__turboModeWarningAlreadyLogged=!0,console.warn("<vaadin-chart> Turbo mode has been enabled for one or more series, because the number of data items exceeds the configured threshold. Turbo mode improves the performance of charts with lots of data, but is not compatible with every type of series. Please consult the documentation on compatibility, or how to disable turbo mode."))}}defineCustomElement(Chart)});export default pt();
