var ft=(n,e)=>()=>(e||n((e={exports:{}}).exports,e),e.exports);import{w as wrap$e,m as microTask,d as calculateSplices,b as PolymerElement,R as ResizeMixin,E as ElementMixin,h as html,e as beforeNextRender,g as get}from"./generated-flow-imports-B0_v5PM2.js";import{i,a as registerStyles,d as defineCustomElement,T as ThemableMixin}from"./indexhtml-CycHIPQ4.js";var pt=ft(exports=>{/**
 * @license
 * Copyright (c) 2000 - 2024 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */const chartBaseTheme=i`
  :host {
    font-family: -apple-system, BlinkMacSystemFont, 'Roboto', 'Segoe UI', Helvetica, Arial, sans-serif,
      'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol';
    font-size: 12px;
    line-height: normal;
  }

  .highcharts-container {
    position: relative;
    overflow: hidden;
    width: 100%;
    height: 100%;
    text-align: left;
    z-index: 0;
    /* #1072 */
    -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
  }

  :where([styled-mode]) .highcharts-root {
    display: block;
  }

  :where([styled-mode]) .highcharts-root text {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-strong {
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-emphasized {
    font-style: italic;
  }

  :where([styled-mode]) .highcharts-anchor {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-background {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-plot-border,
  :where([styled-mode]) .highcharts-plot-background {
    fill: none;
  }

  :where([styled-mode]) .highcharts-label-box {
    fill: none;
  }

  :where([styled-mode]) .highcharts-button-box {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-tracker-line {
    stroke-linejoin: round;
    stroke: rgba(192, 192, 192, 0.0001);
    stroke-width: 22;
    fill: none;
  }

  :where([styled-mode]) .highcharts-tracker-area {
    fill: rgba(192, 192, 192, 0.0001);
    stroke-width: 0;
  }

  /* Titles */
  :where([styled-mode]) .highcharts-title {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
    font-size: 1.5em;
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-subtitle {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  /* Axes */
  :where([styled-mode]) .highcharts-axis-line {
    fill: none;
    stroke: var(--vaadin-charts-axis-line, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-axis-title {
    fill: var(--vaadin-charts-axis-title, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-axis-labels {
    fill: var(--vaadin-charts-axis-label, hsla(214, 42%, 18%, 0.72));
    cursor: default;
    font-size: 0.9em;
  }

  :where([styled-mode]) .highcharts-grid-line {
    fill: none;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-xaxis-grid .highcharts-grid-line {
    stroke-width: var(--vaadin-charts-xaxis-line-width, 0px);
  }

  :where([styled-mode]) .highcharts-tick {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-tick {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-minor-grid-line {
    stroke: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-crosshair-thin {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-crosshair-category {
    stroke: var(--vaadin-charts-color-0, #5ac2f7);
    stroke-opacity: 0.25;
  }

  /* Credits */
  :where([styled-mode]) .highcharts-credits {
    cursor: pointer;
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
    font-size: 0.7em;
    transition:
      fill 250ms,
      font-size 250ms;
  }

  :where([styled-mode]) .highcharts-credits:hover {
    fill: black;
    font-size: 1em;
  }

  /* Tooltip */
  :where([styled-mode]) .highcharts-tooltip {
    cursor: default;
    pointer-events: none;
    white-space: nowrap;
    transition: stroke 150ms;
  }

  :where([styled-mode]) .highcharts-tooltip {
    filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.05)) !important;
  }

  :where([styled-mode]) .highcharts-tooltip text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-tooltip .highcharts-header {
    font-size: 0.85em;
    color: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-tooltip-box {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-tooltip-border, inherit);
    fill: var(--vaadin-charts-tooltip-background, #fff);
    fill-opacity: var(--vaadin-charts-tooltip-background-opacity, 1);
  }

  :where([styled-mode]) .highcharts-tooltip-box .highcharts-label-box {
    fill: var(--vaadin-charts-tooltip-background, #fff);
    fill-opacity: var(--vaadin-charts-tooltip-background-opacity, 1);
  }

  :where([styled-mode]) .highcharts-tooltip-header {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) div.highcharts-tooltip {
    filter: none;
  }

  :where([styled-mode]) .highcharts-selection-marker {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    fill-opacity: 0.25;
  }

  :where([styled-mode]) .highcharts-graph {
    fill: none;
    stroke-width: 2px;
    stroke-linecap: round;
    stroke-linejoin: round;
  }

  :where([styled-mode]) .highcharts-state-hover .highcharts-graph {
    stroke-width: 3;
  }

  :where([styled-mode]) .highcharts-point-inactive {
    opacity: 0.2;
    transition: opacity 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-series-inactive {
    opacity: 0.2;
    transition: opacity 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-state-hover path {
    transition: stroke-width 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-state-normal path {
    transition: stroke-width 250ms;
    /* slow out */
  }

  /* Legend hover affects points and series */
  :where([styled-mode]) g.highcharts-series,
  :where([styled-mode]) .highcharts-point,
  :where([styled-mode]) .highcharts-markers,
  :where([styled-mode]) .highcharts-data-labels {
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-legend-series-active g.highcharts-series:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-point-active .highcharts-point:not(.highcharts-point-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-markers:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-data-labels:not(.highcharts-series-hover) {
    opacity: 0.2;
  }

  /* Series options */
  /* Default colors */
  /* vaadin-charts custom properties */
  /* Use of :where() function to avoid setting classes with high specificity */
  :where([styled-mode]) .highcharts-color-0 {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    stroke: var(--vaadin-charts-color-0, #5ac2f7);
  }

  :where([styled-mode]) .highcharts-color-1 {
    fill: var(--vaadin-charts-color-1, #1676f3);
    stroke: var(--vaadin-charts-color-1, #1676f3);
  }

  :where([styled-mode]) .highcharts-color-2 {
    fill: var(--vaadin-charts-color-2, #ff7d94);
    stroke: var(--vaadin-charts-color-2, #ff7d94);
  }

  :where([styled-mode]) .highcharts-color-3 {
    fill: var(--vaadin-charts-color-3, #c5164e);
    stroke: var(--vaadin-charts-color-3, #c5164e);
  }

  :where([styled-mode]) .highcharts-color-4 {
    fill: var(--vaadin-charts-color-4, #15c15d);
    stroke: var(--vaadin-charts-color-4, #15c15d);
  }

  :where([styled-mode]) .highcharts-color-5 {
    fill: var(--vaadin-charts-color-5, #0e8151);
    stroke: var(--vaadin-charts-color-5, #0e8151);
  }

  :where([styled-mode]) .highcharts-color-6 {
    fill: var(--vaadin-charts-color-6, #c18ed2);
    stroke: var(--vaadin-charts-color-6, #c18ed2);
  }

  :where([styled-mode]) .highcharts-color-7 {
    fill: var(--vaadin-charts-color-7, #9233b3);
    stroke: var(--vaadin-charts-color-7, #9233b3);
  }

  :where([styled-mode]) .highcharts-color-8 {
    fill: var(--vaadin-charts-color-8, #fda253);
    stroke: var(--vaadin-charts-color-8, #fda253);
  }

  :where([styled-mode]) .highcharts-color-9 {
    fill: var(--vaadin-charts-color-9, #e24932);
    stroke: var(--vaadin-charts-color-9, #e24932);
  }

  /* end of vaadin-charts custom properties */

  :where([styled-mode]) .highcharts-area {
    fill-opacity: 0.5;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-markers {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode])
    .highcharts-a11y-markers-hidden
    .highcharts-point:not(.highcharts-point-hover):not(.highcharts-a11y-marker-visible),
  :where([styled-mode]) .highcharts-a11y-marker-hidden {
    opacity: 0;
  }

  :where([styled-mode]) .highcharts-point {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-dense-data .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label {
    font-size: 0.9em;
    font-weight: normal;
  }

  :where([styled-mode]) .highcharts-data-label-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label text,
  :where([styled-mode]) text.highcharts-data-label {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-data-label-connector {
    fill: none;
  }

  :where([styled-mode]) .highcharts-data-label-hidden {
    pointer-events: none;
  }

  :where([styled-mode]) .highcharts-halo {
    fill-opacity: 0.25;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-series:not(.highcharts-pie-series) .highcharts-point-select,
  :where([styled-mode]) .highcharts-markers .highcharts-point-select {
    fill: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-column-series rect.highcharts-point {
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point {
    transition: fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-solidgauge-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point {
    stroke-width: 2px;
    stroke: var(--vaadin-charts-background, #fff);
    transition:
      stroke 250ms,
      fill 250ms,
      fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point-hover {
    stroke-width: 0px;
    stroke: var(--vaadin-charts-background, #fff);
    fill-opacity: 0.75;
    transition:
      stroke 25ms,
      fill 25ms,
      fill-opacity 25ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-above-level {
    display: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node {
    fill: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive {
    fill-opacity: 0.15;
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive:hover {
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-vector-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-windbarb-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-lollipop-stem {
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-focus-border {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-legend-item-hidden .highcharts-focus-border {
    fill: none !important;
  }

  /* Legend */
  :where([styled-mode]) .highcharts-legend-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    font-weight: normal;
    font-size: 1em;
    cursor: pointer;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > .highcharts-point {
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-legend-item:hover text {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-legend-item-hidden * {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26)) !important;
    stroke: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26)) !important;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-legend-nav-active {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-legend-nav-inactive {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
  }

  :where([styled-mode]) circle.highcharts-legend-nav-active,
  :where([styled-mode]) circle.highcharts-legend-nav-inactive {
    /* tracker */
    fill: rgba(192, 192, 192, 0.0001);
  }

  :where([styled-mode]) .highcharts-legend-title-box {
    fill: none;
    stroke-width: 0;
  }

  /* Bubble legend */
  :where([styled-mode]) .highcharts-bubble-legend-symbol {
    stroke-width: 2;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-bubble-legend-connectors {
    stroke-width: 1;
  }

  :where([styled-mode]) .highcharts-bubble-legend-labels {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  /* Loading */
  :where([styled-mode]) .highcharts-loading {
    position: absolute;
    background-color: var(--vaadin-charts-background, #fff);
    opacity: 0.5;
    text-align: center;
    z-index: 10;
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-loading-hidden {
    height: 0 !important;
    opacity: 0;
    overflow: hidden;
    transition:
      opacity 250ms,
      height 250ms step-end;
  }

  :where([styled-mode]) .highcharts-loading-inner {
    font-weight: normal;
    position: relative;
    top: 45%;
  }

  /* Plot bands and polar pane backgrounds */
  :where([styled-mode]) .highcharts-plot-band,
  :where([styled-mode]) .highcharts-pane {
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-plot-line {
    fill: none;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-plot-line-label {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  /* Highcharts More and modules */
  :where([styled-mode]) .highcharts-boxplot-box {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-boxplot-median {
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-bubble-series .highcharts-point {
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-errorbar-series .highcharts-point {
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-data-label-box {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-dial {
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-polygon-series .highcharts-graph {
    fill: inherit;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-waterfall-series .highcharts-graph {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-dasharray: 1, 3;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-link {
    transition:
      fill 250ms,
      fill-opacity 250ms;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point-hover.highcharts-link {
    transition:
      fill 50ms,
      fill-opacity 50ms;
    fill-opacity: 1;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point {
    fill-opacity: 0.75;
    stroke: var(--vaadin-charts-background, #fff);
    transition:
      stroke 250ms,
      fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point-hover {
    fill-opacity: 1;
    stroke: var(--vaadin-charts-background, #fff);
  }

  /* Highstock */
  :where([styled-mode]) .highcharts-navigator-mask-outside {
    fill-opacity: 0;
  }

  :where([styled-mode]) .highcharts-navigator-mask-inside {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    /* navigator.maskFill option */
    fill-opacity: 0.2;
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-outline {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    fill: none;
  }

  :where([styled-mode]) .highcharts-navigator-handle {
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
    fill: var(--vaadin-charts-background, #fff);
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-series {
    fill: var(--vaadin-charts-color-1, #1676f3);
    stroke: var(--vaadin-charts-color-1, #1676f3);
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-graph {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-area {
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-grid-line {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-navigator-xaxis.highcharts-axis-labels {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-navigator-yaxis .highcharts-grid-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-scrollbar-thumb {
    fill: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-scrollbar-button {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-scrollbar-arrow {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-scrollbar-rifles {
    stroke: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-scrollbar-track {
    fill: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-button {
    fill: var(--vaadin-charts-button-background, hsla(214, 61%, 25%, 0.05));
    cursor: default;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-button text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-button-hover {
    transition: fill 0ms;
    fill: var(--vaadin-charts-button-hover-background, hsla(214, 90%, 52%, 0.1));
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-button-hover text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-button-pressed {
    fill: var(--vaadin-charts-button-active-background, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-button-pressed text {
    fill: var(--vaadin-charts-button-active-label, #fff);
  }

  :where([styled-mode]) .highcharts-button-disabled text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-range-selector-buttons > text {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-range-selector-buttons .highcharts-button {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-range-label rect {
    fill: none;
  }

  :where([styled-mode]) .highcharts-range-label text {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-range-input rect {
    fill: var(--vaadin-charts-contrast-10pct, hsla(214, 57%, 24%, 0.1));
    rx: 2;
    ry: 2;
  }

  :where([styled-mode]) .highcharts-range-input:hover rect {
    fill: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-range-input text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) input.highcharts-range-selector {
    position: absolute;
    border: 0;
    width: 1px;
    /* Chrome needs a pixel to see it */
    height: 1px;
    padding: 0;
    text-align: center;
    left: -9em;
    /* #4798 */
  }

  :where([styled-mode]) .highcharts-crosshair-label text {
    fill: var(--vaadin-charts-background, #fff);
    font-size: 1.1em;
  }

  :where([styled-mode]) .highcharts-crosshair-label .highcharts-label-box {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-up {
    fill: var(--vaadin-charts-color-positive, #15c15d);
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-down {
    fill: var(--vaadin-charts-color-negative, #e24932);
  }

  :where([styled-mode]) .highcharts-ohlc-series .highcharts-point-hover {
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point .highcharts-label-box {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    fill: var(--vaadin-charts-background, #fff);
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover .highcharts-label-box {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    font-size: 0.9em;
    font-weight: normal;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover text {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
  }

  /* Highmaps */
  :where([styled-mode]) .highcharts-map-series .highcharts-point {
    transition:
      fill 500ms,
      fill-opacity 500ms,
      stroke-width 250ms;
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-map-series .highcharts-point-hover {
    transition:
      fill 0ms,
      fill-opacity 0ms;
    fill-opacity: 0.5;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-mapline-series .highcharts-point {
    fill: none;
  }

  :where([styled-mode]) .highcharts-heatmap-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-map-navigation {
    font-size: 1.3em;
    font-weight: normal;
    text-align: center;
  }

  :where([styled-mode]) .highcharts-coloraxis {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-coloraxis-grid .highcharts-grid-line {
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-coloraxis-marker {
    fill: var(--vaadin-charts-axis-label, hsla(214, 42%, 18%, 0.72));
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-null-point {
    fill: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  /* 3d charts */
  :where([styled-mode]) .highcharts-3d-frame {
    fill: transparent;
  }

  /* Exporting module */
  :where([styled-mode]) .highcharts-contextbutton {
    fill: #fff;
    /* needed to capture hover */
    stroke: none;
    stroke-linecap: round;
  }

  :where([styled-mode]) .highcharts-contextbutton:hover {
    fill: #e6e6e6;
    stroke: #e6e6e6;
  }

  :where([styled-mode]) .highcharts-button-symbol {
    stroke: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-menu {
    border: 1px solid #999;
    background: #fff;
    padding: 5px 0;
    box-shadow: 3px 3px 10px #888;
  }

  :where([styled-mode]) .highcharts-menu-item {
    padding: 0.5em 1em;
    background: none;
    color: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    cursor: pointer;
    transition:
      background 250ms,
      color 250ms;
  }

  :where([styled-mode]) .highcharts-menu-item:hover {
    background: #335cad;
    color: #fff;
  }

  /* Drilldown module */
  :where([styled-mode]) .highcharts-drilldown-point {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-drilldown-data-label text,
  :where([styled-mode]) text.highcharts-drilldown-data-label,
  :where([styled-mode]) .highcharts-drilldown-axis-label {
    cursor: pointer;
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    font-weight: normal;
    text-decoration: underline;
  }

  /* No-data module */
  :where([styled-mode]) .highcharts-no-data text {
    font-weight: normal;
    font-size: 1rem;
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  /* Drag-panes module */
  :where([styled-mode]) .highcharts-axis-resizer {
    cursor: ns-resize;
    stroke: black;
    stroke-width: 2px;
  }

  /* Bullet type series */
  :where([styled-mode]) .highcharts-bullet-target {
    stroke-width: 0;
  }

  /* Lineargauge type series */
  :where([styled-mode]) .highcharts-lineargauge-target {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  :where([styled-mode]) .highcharts-lineargauge-target-line {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  /* Annotations module */
  :where([styled-mode]) .highcharts-annotation-label-box {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-annotation-label text {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
  }

  /* Gantt */
  :where([styled-mode]) .highcharts-treegrid-node-collapsed,
  :where([styled-mode]) .highcharts-treegrid-node-expanded {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-point-connecting-path {
    fill: none;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-tick {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-axis-line {
    stroke-width: 1px;
  }

  /* RTL styles */
  :host([dir='rtl']) :where([styled-mode]) .highcharts-container {
    text-align: right;
  }

  :host([dir='rtl']) :where([styled-mode]) input.highcharts-range-selector {
    left: auto;
    right: -9em;
  }

  :host([dir='rtl']) :where([styled-mode]) .highcharts-menu {
    box-shadow: -3px 3px 10px #888;
  }

  /* https://github.com/highcharts/highcharts/issues/16282 */
  /* without this the resize callback always calls __reflow */
  ul[aria-hidden='false'] {
    margin: 0px;
  }
`;registerStyles("vaadin-chart",chartBaseTheme,{moduleId:"vaadin-chart-base-theme"});const chartColors=i`
  :host {
    --vaadin-charts-color-0: #5ac2f7;
    --vaadin-charts-color-1: #1676f3;
    --vaadin-charts-color-2: #ff7d94;
    --vaadin-charts-color-3: #c5164e;
    --vaadin-charts-color-4: #15c15d;
    --vaadin-charts-color-5: #0e8151;
    --vaadin-charts-color-6: #c18ed2;
    --vaadin-charts-color-7: #9233b3;
    --vaadin-charts-color-8: #fda253;
    --vaadin-charts-color-9: #e24932;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-4, #15c15d);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-9, #e24932);
  }

  :host([theme~='gradient']) {
    --vaadin-charts-color-0: #1676f3;
    --vaadin-charts-color-1: #13bbf0;
    --vaadin-charts-color-2: #1ee;
    --vaadin-charts-color-3: #0cd9bf;
    --vaadin-charts-color-4: #06be81;
    --vaadin-charts-color-5: #00a344;
    --vaadin-charts-color-6: #41c639;
    --vaadin-charts-color-7: #8aed2c;
    --vaadin-charts-color-8: #c0e632;
    --vaadin-charts-color-9: #f6db3a;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-6);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-1);
  }

  :host([theme~='monotone']) {
    --vaadin-charts-color-0: #1676f3;
    --vaadin-charts-color-1: #4795f5;
    --vaadin-charts-color-2: #71b0f7;
    --vaadin-charts-color-3: #a0cef9;
    --vaadin-charts-color-4: #bce0fa;
    --vaadin-charts-color-5: #a8d8ed;
    --vaadin-charts-color-6: #7fc3dd;
    --vaadin-charts-color-7: #54adcc;
    --vaadin-charts-color-8: #2b99bc;
    --vaadin-charts-color-9: #0284ac;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-3);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-9);
  }

  :host([theme~='classic']) {
    --vaadin-charts-color-0: #7cb5ec;
    --vaadin-charts-color-1: #434348;
    --vaadin-charts-color-2: #90ed7d;
    --vaadin-charts-color-3: #f7a35c;
    --vaadin-charts-color-4: #8085e9;
    --vaadin-charts-color-5: #f15c80;
    --vaadin-charts-color-6: #e4d354;
    --vaadin-charts-color-7: #2b908f;
    --vaadin-charts-color-8: #f45b5b;
    --vaadin-charts-color-9: #91e8e1;
  }
`,chartTheme=i`
  :host {
    --vaadin-charts-background: var(--lumo-base-color);
    --vaadin-charts-title-label: var(--lumo-header-text-color);
    --vaadin-charts-axis-title: var(--lumo-secondary-text-color);
    --vaadin-charts-axis-label: var(--lumo-secondary-text-color);
    --vaadin-charts-data-label: var(--lumo-body-text-color);
    --vaadin-charts-secondary-label: var(--lumo-secondary-text-color);
    --vaadin-charts-axis-line: var(--lumo-contrast-5pct);
    --vaadin-charts-grid-line: var(--lumo-contrast-20pct);
    --vaadin-charts-disabled-label: var(--lumo-disabled-text-color);
    --vaadin-charts-contrast: var(--lumo-contrast);
    --vaadin-charts-contrast-5pct: var(--lumo-contrast-5pct);
    --vaadin-charts-contrast-10pct: var(--lumo-contrast-10pct);
    --vaadin-charts-contrast-20pct: var(--lumo-contrast-20pct);
    --vaadin-charts-contrast-60pct: var(--lumo-contrast-60pct);
    --vaadin-charts-tooltip-background: var(--lumo-base-color);
    --vaadin-charts-tooltip-border-color: inherit;
    --vaadin-charts-button-label: var(--lumo-primary-text-color);
    --vaadin-charts-button-background: var(--lumo-contrast-5pct);
    --vaadin-charts-button-hover-background: var(--lumo-primary-color-10pct);
    --vaadin-charts-button-active-label: var(--lumo-primary-contrast-color);
    --vaadin-charts-button-active-background: var(--lumo-primary-color);
    --vaadin-charts-xaxis-line-width: 0;
    --vaadin-charts-tooltip-background-opacity: 1;
    font-family: var(--lumo-font-family);
  }
`;registerStyles("vaadin-chart",[chartColors,chartTheme],{moduleId:"lumo-chart"});var w=typeof win<"u"?win:typeof window<"u"?window:{},Globals;(function(n){n.SVG_NS="http://www.w3.org/2000/svg",n.product="Highcharts",n.version="9.2.2",n.win=w,n.doc=n.win.document,n.svg=n.doc&&n.doc.createElementNS&&!!n.doc.createElementNS(n.SVG_NS,"svg").createSVGRect,n.userAgent=n.win.navigator&&n.win.navigator.userAgent||"",n.isChrome=n.userAgent.indexOf("Chrome")!==-1,n.isFirefox=n.userAgent.indexOf("Firefox")!==-1,n.isMS=/(edge|msie|trident)/i.test(n.userAgent)&&!n.win.opera,n.isSafari=!n.isChrome&&n.userAgent.indexOf("Safari")!==-1,n.isTouchDevice=/(Mobile|Android|Windows Phone)/.test(n.userAgent),n.isWebKit=n.userAgent.indexOf("AppleWebKit")!==-1,n.deg2rad=Math.PI*2/360,n.hasBidiBug=n.isFirefox&&parseInt(n.userAgent.split("Firefox/")[1],10)<4,n.hasTouch=!!n.win.TouchEvent,n.marginNames=["plotTop","marginRight","marginBottom","plotLeft"],n.noop=function(){},n.supportsPassiveEvents=function(){var e=!1;if(!n.isMS){var t=Object.defineProperty({},"passive",{get:function(){e=!0}});n.win.addEventListener&&n.win.removeEventListener&&(n.win.addEventListener("testPassive",n.noop,t),n.win.removeEventListener("testPassive",n.noop,t))}return e}(),n.charts=[],n.dateFormats={},n.seriesTypes={},n.symbolSizes={},n.chartCount=0})(Globals||(Globals={}));const H=Globals;var charts$5=H.charts,doc$m=H.doc,win$g=H.win;function error$a(n,e,t,r){var o=e?"Highcharts error":"Highcharts warning";n===32&&(n=o+": Deprecated member");var s=isNumber$R(n),a=s?o+" #"+n+": www.highcharts.com/errors/"+n+"/":n.toString(),l=function(){if(e)throw new Error(a);win$g.console&&error$a.messages.indexOf(a)===-1&&console.warn(a)};if(typeof r<"u"){var h="";s&&(a+="?"),objectEach$B(r,function(d,c){h+=`
 - `+c+": "+d,s&&(a+=encodeURI(c)+"="+encodeURI(d))}),a+=h}fireEvent$B(H,"displayError",{chart:t,code:n,message:a,params:r},l),error$a.messages.push(a)}(function(n){n.messages=[]})(error$a);function merge$1p(){var n,e=arguments,t={},r=function(s,a){return typeof s!="object"&&(s={}),objectEach$B(a,function(l,h){h==="__proto__"||h==="constructor"||(isObject$f(l,!0)&&!isClass(l)&&!isDOMElement(l)?s[h]=r(s[h]||{},l):s[h]=a[h])}),s};e[0]===!0&&(t=e[1],e=Array.prototype.slice.call(e,2));var o=e.length;for(n=0;n<o;n++)t=r(t,e[n]);return t}function clamp$j(n,e,t){return n>e?n<t?n:t:e}function cleanRecursively$2(n,e){var t={};return objectEach$B(n,function(r,o){var s;isObject$f(n[o],!0)&&!n.nodeType&&e[o]?(s=cleanRecursively$2(n[o],e[o]),Object.keys(s).length&&(t[o]=s)):(isObject$f(n[o])||n[o]!==e[o])&&(t[o]=n[o])}),t}function pInt$a(n,e){return parseInt(n,e||10)}function isString$c(n){return typeof n=="string"}function isArray$n(n){var e=Object.prototype.toString.call(n);return e==="[object Array]"||e==="[object Array Iterator]"}function isObject$f(n,e){return!!n&&typeof n=="object"&&(!e||!isArray$n(n))}function isDOMElement(n){return isObject$f(n)&&typeof n.nodeType=="number"}function isClass(n){var e=n&&n.constructor;return!!(isObject$f(n,!0)&&!isDOMElement(n)&&e&&e.name&&e.name!=="Object")}function isNumber$R(n){return typeof n=="number"&&!isNaN(n)&&n<1/0&&n>-1/0}function erase$9(n,e){for(var t=n.length;t--;)if(n[t]===e){n.splice(t,1);break}}function defined$W(n){return typeof n<"u"&&n!==null}function attr$8(n,e,t){var r;return isString$c(e)?defined$W(t)?n.setAttribute(e,t):n&&n.getAttribute&&(r=n.getAttribute(e),!r&&e==="class"&&(r=n.getAttribute(e+"Name"))):objectEach$B(e,function(o,s){n.setAttribute(s,o)}),r}function splat$j(n){return isArray$n(n)?n:[n]}function syncTimeout$9(n,e,t){return e>0?setTimeout(n,e,t):(n.call(0,t),-1)}function internalClearTimeout(n){defined$W(n)&&clearTimeout(n)}function extend$1q(n,e){var t;n||(n={});for(t in e)n[t]=e[t];return n}function pick$1B(){for(var n=arguments,e=n.length,t=0;t<e;t++){var r=n[t];if(typeof r<"u"&&r!==null)return r}}function css$d(n,e){H.isMS&&!H.svg&&e&&typeof e.opacity<"u"&&(e.filter="alpha(opacity="+e.opacity*100+")"),extend$1q(n.style,e)}function createElement$b(n,e,t,r,o){var s=doc$m.createElement(n);return e&&extend$1q(s,e),o&&css$d(s,{padding:"0",border:"none",margin:"0"}),t&&css$d(s,t),r&&r.appendChild(s),s}function extendClass$2(n,e){var t=function(){};return t.prototype=new n,extend$1q(t.prototype,e),t}function pad$2(n,e,t){return new Array((e||2)+1-String(n).replace("-","").length).join(t||"0")+n}function relativeLength$a(n,e,t){return/%$/.test(n)?e*parseFloat(n)/100+(t||0):parseFloat(n)}function wrap$d(n,e,t){var r=n[e];n[e]=function(){var o=Array.prototype.slice.call(arguments),s=arguments,a=this;a.proceed=function(){r.apply(a,arguments.length?arguments:s)},o.unshift(r);var l=t.apply(this,o);return a.proceed=null,l}}function getMagnitude$3(n){return Math.pow(10,Math.floor(Math.log(n)/Math.LN10))}function normalizeTickInterval$3(n,e,t,r,o){var s,a=n;t=pick$1B(t,1);var l=n/t;for(e||(e=o?[1,1.2,1.5,2,2.5,3,4,5,6,8,10]:[1,2,2.5,5,10],r===!1&&(t===1?e=e.filter(function(h){return h%1===0}):t<=.1&&(e=[1/t]))),s=0;s<e.length&&(a=e[s],!(o&&a*t>=n||!o&&l<=(e[s]+(e[s+1]||e[s]))/2));s++);return a=correctFloat$d(a*t,-Math.round(Math.log(.001)/Math.LN10)),a}function stableSort$7(n,e){var t=n.length,r,o;for(o=0;o<t;o++)n[o].safeI=o;for(n.sort(function(s,a){return r=e(s,a),r===0?s.safeI-a.safeI:r}),o=0;o<t;o++)delete n[o].safeI}function arrayMin$9(n){for(var e=n.length,t=n[0];e--;)n[e]<t&&(t=n[e]);return t}function arrayMax$a(n){for(var e=n.length,t=n[0];e--;)n[e]>t&&(t=n[e]);return t}function destroyObjectProperties$a(n,e){objectEach$B(n,function(t,r){t&&t!==e&&t.destroy&&t.destroy(),delete n[r]})}function discardElement$7(n){garbageBin||(garbageBin=createElement$b("div")),n&&garbageBin.appendChild(n),garbageBin.innerHTML=""}var garbageBin;function correctFloat$d(n,e){return parseFloat(n.toPrecision(e||14))}var timeUnits$3={millisecond:1,second:1e3,minute:6e4,hour:36e5,day:24*36e5,week:7*24*36e5,month:28*24*36e5,year:364*24*36e5};Math.easeInOutSine=function(n){return-.5*(Math.cos(Math.PI*n)-1)};function getNestedProperty$3(n,e){for(var t=n.split(".");t.length&&defined$W(e);){var r=t.shift();if(typeof r>"u"||r==="__proto__")return;var o=e[r];if(!defined$W(o)||typeof o=="function"||typeof o.nodeType=="number"||o===win$g)return;e=o}return e}function getStyle$2(n,e,t){var r=H.getStyle||getStyle$2,o;if(e==="width"){var s=Math.min(n.offsetWidth,n.scrollWidth),a=n.getBoundingClientRect&&n.getBoundingClientRect().width;return a<s&&a>=s-1&&(s=Math.floor(a)),Math.max(0,s-(r(n,"padding-left",!0)||0)-(r(n,"padding-right",!0)||0))}if(e==="height")return Math.max(0,Math.min(n.offsetHeight,n.scrollHeight)-(r(n,"padding-top",!0)||0)-(r(n,"padding-bottom",!0)||0));win$g.getComputedStyle||error$a(27,!0);var l=win$g.getComputedStyle(n,void 0);return l&&(o=l.getPropertyValue(e),pick$1B(t,e!=="opacity")&&(o=pInt$a(o))),o}function inArray(n,e,t){return error$a(32,!1,void 0,{"Highcharts.inArray":"use Array.indexOf"}),e.indexOf(n,t)}var find$j=Array.prototype.find?function(n,e){return n.find(e)}:function(n,e){var t,r=n.length;for(t=0;t<r;t++)if(e(n[t],t))return n[t]};function keys(n){return error$a(32,!1,void 0,{"Highcharts.keys":"use Object.keys"}),Object.keys(n)}function offset$1(n){var e=doc$m.documentElement,t=n.parentElement||n.parentNode?n.getBoundingClientRect():{top:0,left:0,width:0,height:0};return{top:t.top+(win$g.pageYOffset||e.scrollTop)-(e.clientTop||0),left:t.left+(win$g.pageXOffset||e.scrollLeft)-(e.clientLeft||0),width:t.width,height:t.height}}function objectEach$B(n,e,t){for(var r in n)Object.hasOwnProperty.call(n,r)&&e.call(t||n[r],n[r],r,n)}objectEach$B({map:"map",each:"forEach",grep:"filter",reduce:"reduce",some:"some"},function(n,e){H[e]=function(t){var r;return error$a(32,!1,void 0,(r={},r["Highcharts."+e]="use Array."+n,r)),Array.prototype[n].apply(t,[].slice.call(arguments,1))}});function addEvent$12(n,e,t,r){r===void 0&&(r={});var o=typeof n=="function"&&n.prototype||n;Object.hasOwnProperty.call(o,"hcEvents")||(o.hcEvents={});var s=o.hcEvents;H.Point&&n instanceof H.Point&&n.series&&n.series.chart&&(n.series.chart.runTrackerClick=!0);var a=n.addEventListener||H.addEventListenerPolyfill;a&&a.call(n,e,t,H.supportsPassiveEvents?{passive:r.passive===void 0?e.indexOf("touch")!==-1:r.passive,capture:!1}:!1),s[e]||(s[e]=[]);var l={fn:t,order:typeof r.order=="number"?r.order:1/0};return s[e].push(l),s[e].sort(function(h,d){return h.order-d.order}),function(){removeEvent$c(n,e,t)}}function removeEvent$c(n,e,t){function r(h,d){var c=n.removeEventListener||H.removeEventListenerPolyfill;c&&c.call(n,h,d,!1)}function o(h){var d,c;n.nodeName&&(e?(d={},d[e]=!0):d=h,objectEach$B(d,function(p,f){if(h[f])for(c=h[f].length;c--;)r(f,h[f][c].fn)}))}var s=typeof n=="function"&&n.prototype||n;if(Object.hasOwnProperty.call(s,"hcEvents")){var a=s.hcEvents;if(e){var l=a[e]||[];t?(a[e]=l.filter(function(h){return t!==h.fn}),r(e,t)):(o(a),a[e]=[])}else o(a),delete s.hcEvents}}function fireEvent$B(n,e,t,r){var o;if(t=t||{},doc$m.createEvent&&(n.dispatchEvent||n.fireEvent&&n!==H))o=doc$m.createEvent("Events"),o.initEvent(e,!0,!0),t=extend$1q(o,t),n.dispatchEvent?n.dispatchEvent(t):n.fireEvent(e,t);else if(n.hcEvents){t.target||extend$1q(t,{preventDefault:function(){t.defaultPrevented=!0},target:n,type:e});for(var s=[],a=n,l=!1;a.hcEvents;)Object.hasOwnProperty.call(a,"hcEvents")&&a.hcEvents[e]&&(s.length&&(l=!0),s.unshift.apply(s,a.hcEvents[e])),a=Object.getPrototypeOf(a);l&&s.sort(function(h,d){return h.order-d.order}),s.forEach(function(h){h.fn.call(n,t)===!1&&t.preventDefault()})}r&&!t.defaultPrevented&&r.call(n,t)}var serialMode,uniqueKey$8=function(){var n=Math.random().toString(36).substring(2,9)+"-",e=0;return function(){return"highcharts-"+(serialMode?"":n)+e++}}();function useSerialIds(n){return serialMode=pick$1B(n,serialMode)}function isFunction$5(n){return typeof n=="function"}win$g.jQuery&&(win$g.jQuery.fn.highcharts=function(){var n=[].slice.call(arguments);if(this[0])return n[0]?(new H[isString$c(n[0])?n.shift():"Chart"](this[0],n[0],n[1]),this):charts$5[attr$8(this[0],"data-highcharts-chart")]});var Utilities={addEvent:addEvent$12,arrayMax:arrayMax$a,arrayMin:arrayMin$9,attr:attr$8,clamp:clamp$j,cleanRecursively:cleanRecursively$2,clearTimeout:internalClearTimeout,correctFloat:correctFloat$d,createElement:createElement$b,css:css$d,defined:defined$W,destroyObjectProperties:destroyObjectProperties$a,discardElement:discardElement$7,erase:erase$9,error:error$a,extend:extend$1q,extendClass:extendClass$2,find:find$j,fireEvent:fireEvent$B,getMagnitude:getMagnitude$3,getNestedProperty:getNestedProperty$3,getStyle:getStyle$2,inArray,isArray:isArray$n,isClass,isDOMElement,isFunction:isFunction$5,isNumber:isNumber$R,isObject:isObject$f,isString:isString$c,keys,merge:merge$1p,normalizeTickInterval:normalizeTickInterval$3,objectEach:objectEach$B,offset:offset$1,pad:pad$2,pick:pick$1B,pInt:pInt$a,relativeLength:relativeLength$a,removeEvent:removeEvent$c,splat:splat$j,stableSort:stableSort$7,syncTimeout:syncTimeout$9,timeUnits:timeUnits$3,uniqueKey:uniqueKey$8,useSerialIds,wrap:wrap$d},palette={colors:["#7cb5ec","#434348","#90ed7d","#f7a35c","#8085e9","#f15c80","#e4d354","#2b908f","#f45b5b","#91e8e1"],backgroundColor:"#ffffff",neutralColor100:"#000000",neutralColor80:"#333333",neutralColor60:"#666666",neutralColor40:"#999999",neutralColor20:"#cccccc",neutralColor10:"#e6e6e6",neutralColor5:"#f2f2f2",neutralColor3:"#f7f7f7",highlightColor100:"#003399",highlightColor80:"#335cad",highlightColor60:"#6685c2",highlightColor20:"#ccd6eb",highlightColor10:"#e6ebf5",positiveColor:"#06b535",negativeColor:"#f21313"},ChartDefaults={panning:{enabled:!1,type:"x"},styledMode:!1,borderRadius:0,colorCount:10,defaultSeriesType:"line",ignoreHiddenSeries:!0,spacing:[10,10,15,10],resetZoomButton:{theme:{zIndex:6},position:{align:"right",x:-10,y:10}},zoomBySingleTouch:!1,width:null,height:null,borderColor:palette.highlightColor80,backgroundColor:palette.backgroundColor,plotBorderColor:palette.neutralColor20},isNumber$Q=Utilities.isNumber,merge$1o=Utilities.merge,pInt$9=Utilities.pInt,Color=function(){function n(e){this.rgba=[NaN,NaN,NaN,NaN],this.input=e;var t=H.Color;if(t&&t!==n)return new t(e);if(!(this instanceof n))return new n(e);this.init(e)}return n.parse=function(e){return e?new n(e):n.None},n.prototype.init=function(e){var t,r,o,s;if(typeof e=="object"&&typeof e.stops<"u")this.stops=e.stops.map(function(h){return new n(h[1])});else if(typeof e=="string"){if(this.input=e=n.names[e.toLowerCase()]||e,e.charAt(0)==="#"){var a=e.length,l=parseInt(e.substr(1),16);a===7?r=[(l&16711680)>>16,(l&65280)>>8,l&255,1]:a===4&&(r=[(l&3840)>>4|(l&3840)>>8,(l&240)>>4|l&240,(l&15)<<4|l&15,1])}if(!r)for(o=n.parsers.length;o--&&!r;)s=n.parsers[o],t=s.regex.exec(e),t&&(r=s.parse(t))}r&&(this.rgba=r)},n.prototype.get=function(e){var t=this.input,r=this.rgba;if(typeof t=="object"&&typeof this.stops<"u"){var o=merge$1o(t);return o.stops=[].slice.call(o.stops),this.stops.forEach(function(s,a){o.stops[a]=[o.stops[a][0],s.get(e)]}),o}return r&&isNumber$Q(r[0])?e==="rgb"||!e&&r[3]===1?"rgb("+r[0]+","+r[1]+","+r[2]+")":e==="a"?""+r[3]:"rgba("+r.join(",")+")":t},n.prototype.brighten=function(e){var t=this.rgba;if(this.stops)this.stops.forEach(function(o){o.brighten(e)});else if(isNumber$Q(e)&&e!==0)for(var r=0;r<3;r++)t[r]+=pInt$9(e*255),t[r]<0&&(t[r]=0),t[r]>255&&(t[r]=255);return this},n.prototype.setOpacity=function(e){return this.rgba[3]=e,this},n.prototype.tweenTo=function(e,t){var r=this.rgba,o=e.rgba;if(!isNumber$Q(r[0])||!isNumber$Q(o[0]))return e.input||"none";var s=o[3]!==1||r[3]!==1;return(s?"rgba(":"rgb(")+Math.round(o[0]+(r[0]-o[0])*(1-t))+","+Math.round(o[1]+(r[1]-o[1])*(1-t))+","+Math.round(o[2]+(r[2]-o[2])*(1-t))+(s?","+(o[3]+(r[3]-o[3])*(1-t)):"")+")"},n.names={white:"#ffffff",black:"#000000"},n.parsers=[{regex:/rgba\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]?(?:\.[0-9]+)?)\s*\)/,parse:function(e){return[pInt$9(e[1]),pInt$9(e[2]),pInt$9(e[3]),parseFloat(e[4],10)]}},{regex:/rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/,parse:function(e){return[pInt$9(e[1]),pInt$9(e[2]),pInt$9(e[3]),1]}}],n.None=new n(""),n}(),win$f=H.win,defined$V=Utilities.defined,error$9=Utilities.error,extend$1p=Utilities.extend,isObject$e=Utilities.isObject,merge$1n=Utilities.merge,objectEach$A=Utilities.objectEach,pad$1=Utilities.pad,pick$1A=Utilities.pick,splat$i=Utilities.splat,timeUnits$2=Utilities.timeUnits,hasNewSafariBug=H.isSafari&&win$f.Intl&&win$f.Intl.DateTimeFormat.prototype.formatRange,hasOldSafariBug=H.isSafari&&win$f.Intl&&!win$f.Intl.DateTimeFormat.prototype.formatRange,Time=function(){function n(e){this.options={},this.useUTC=!1,this.variableTimezone=!1,this.Date=win$f.Date,this.getTimezoneOffset=this.timezoneOffsetFunction(),this.update(e)}return n.prototype.get=function(e,t){if(this.variableTimezone||this.timezoneOffset){var r=t.getTime(),o=r-this.getTimezoneOffset(t);t.setTime(o);var s=t["getUTC"+e]();return t.setTime(r),s}return this.useUTC?t["getUTC"+e]():t["get"+e]()},n.prototype.set=function(e,t,r){if(this.variableTimezone||this.timezoneOffset){if(e==="Milliseconds"||e==="Seconds"||e==="Minutes"&&this.getTimezoneOffset(t)%36e5===0)return t["setUTC"+e](r);var o=this.getTimezoneOffset(t),s=t.getTime()-o;t.setTime(s),t["setUTC"+e](r);var a=this.getTimezoneOffset(t);return s=t.getTime()+a,t.setTime(s)}return this.useUTC||hasNewSafariBug&&e==="FullYear"?t["setUTC"+e](r):t["set"+e](r)},n.prototype.update=function(e){var t=pick$1A(e&&e.useUTC,!0);this.options=e=merge$1n(!0,this.options||{},e),this.Date=e.Date||win$f.Date||Date,this.useUTC=t,this.timezoneOffset=t&&e.timezoneOffset,this.getTimezoneOffset=this.timezoneOffsetFunction(),this.variableTimezone=t&&!!(e.getTimezoneOffset||e.timezone)},n.prototype.makeTime=function(e,t,r,o,s,a){var l,h,d;return this.useUTC?(l=this.Date.UTC.apply(0,arguments),h=this.getTimezoneOffset(l),l+=h,d=this.getTimezoneOffset(l),h!==d?l+=d-h:h-36e5===this.getTimezoneOffset(l-36e5)&&!hasOldSafariBug&&(l-=36e5)):l=new this.Date(e,t,pick$1A(r,1),pick$1A(o,0),pick$1A(s,0),pick$1A(a,0)).getTime(),l},n.prototype.timezoneOffsetFunction=function(){var e=this,t=this.options,r=t.moment||win$f.moment;if(!this.useUTC)return function(o){return new Date(o.toString()).getTimezoneOffset()*6e4};if(t.timezone)if(!r)error$9(25);else return function(o){return-r.tz(o,t.timezone).utcOffset()*6e4};return this.useUTC&&t.getTimezoneOffset?function(o){return t.getTimezoneOffset(o.valueOf())*6e4}:function(){return(e.timezoneOffset||0)*6e4}},n.prototype.dateFormat=function(e,t,r){if(!defined$V(t)||isNaN(t))return H.defaultOptions.lang&&H.defaultOptions.lang.invalidDate||"";e=pick$1A(e,"%Y-%m-%d %H:%M:%S");var o=this,s=new this.Date(t),a=this.get("Hours",s),l=this.get("Day",s),h=this.get("Date",s),d=this.get("Month",s),c=this.get("FullYear",s),p=H.defaultOptions.lang,f=p&&p.weekdays,u=p&&p.shortWeekdays,g=extend$1p({a:u?u[l]:f[l].substr(0,3),A:f[l],d:pad$1(h),e:pad$1(h,2," "),w:l,b:p.shortMonths[d],B:p.months[d],m:pad$1(d+1),o:d+1,y:c.toString().substr(2,2),Y:c,H:pad$1(a),k:a,I:pad$1(a%12||12),l:a%12||12,M:pad$1(this.get("Minutes",s)),p:a<12?"AM":"PM",P:a<12?"am":"pm",S:pad$1(s.getSeconds()),L:pad$1(Math.floor(t%1e3),3)},H.dateFormats);return objectEach$A(g,function(m,y){for(;e.indexOf("%"+y)!==-1;)e=e.replace("%"+y,typeof m=="function"?m.call(o,t):m)}),r?e.substr(0,1).toUpperCase()+e.substr(1):e},n.prototype.resolveDTLFormat=function(e){return isObject$e(e,!0)?e:(e=splat$i(e),{main:e[0],from:e[1],to:e[2]})},n.prototype.getTimeTicks=function(e,t,r,o){var s=this,a=s.Date,l=[],h={},d=new a(t),c=e.unitRange,p=e.count||1,f,u,g,m;if(o=pick$1A(o,1),defined$V(t)){s.set("Milliseconds",d,c>=timeUnits$2.second?0:p*Math.floor(s.get("Milliseconds",d)/p)),c>=timeUnits$2.second&&s.set("Seconds",d,c>=timeUnits$2.minute?0:p*Math.floor(s.get("Seconds",d)/p)),c>=timeUnits$2.minute&&s.set("Minutes",d,c>=timeUnits$2.hour?0:p*Math.floor(s.get("Minutes",d)/p)),c>=timeUnits$2.hour&&s.set("Hours",d,c>=timeUnits$2.day?0:p*Math.floor(s.get("Hours",d)/p)),c>=timeUnits$2.day&&s.set("Date",d,c>=timeUnits$2.month?1:Math.max(1,p*Math.floor(s.get("Date",d)/p))),c>=timeUnits$2.month&&(s.set("Month",d,c>=timeUnits$2.year?0:p*Math.floor(s.get("Month",d)/p)),u=s.get("FullYear",d)),c>=timeUnits$2.year&&(u-=u%p,s.set("FullYear",d,u)),c===timeUnits$2.week&&(m=s.get("Day",d),s.set("Date",d,s.get("Date",d)-m+o+(m<o?-7:0))),u=s.get("FullYear",d);var y=s.get("Month",d),v=s.get("Date",d),x=s.get("Hours",d);t=d.getTime(),(s.variableTimezone||!s.useUTC)&&defined$V(r)&&(g=r-t>4*timeUnits$2.month||s.getTimezoneOffset(t)!==s.getTimezoneOffset(r));var b=d.getTime();for(f=1;b<r;)l.push(b),c===timeUnits$2.year?b=s.makeTime(u+f*p,0):c===timeUnits$2.month?b=s.makeTime(u,y+f*p):g&&(c===timeUnits$2.day||c===timeUnits$2.week)?b=s.makeTime(u,y,v+f*p*(c===timeUnits$2.day?1:7)):g&&c===timeUnits$2.hour&&p>1?b=s.makeTime(u,y,v,x+f*p):b+=c*p,f++;l.push(b),c<=timeUnits$2.hour&&l.length<1e4&&l.forEach(function($){$%18e5===0&&s.dateFormat("%H%M%S%L",$)==="000000000"&&(h[$]="day")})}return l.info=extend$1p(e,{higherRanks:h,totalRange:c*p}),l},n.prototype.getDateFormat=function(e,t,r,o){var s=this.dateFormat("%m-%d %H:%M:%S.%L",t),a="01-01 00:00:00.000",l={millisecond:15,second:12,minute:9,hour:6,day:3},h,d,c="millisecond";for(d in timeUnits$2){if(e===timeUnits$2.week&&+this.dateFormat("%w",t)===r&&s.substr(6)===a.substr(6)){d="week";break}if(timeUnits$2[d]>e){d=c;break}if(l[d]&&s.substr(l[d])!==a.substr(l[d]))break;d!=="week"&&(c=d)}return d&&(h=this.resolveDTLFormat(o[d]).main),h},n}(),color$g=Color.parse,isTouchDevice$4=H.isTouchDevice,svg$5=H.svg,merge$1m=Utilities.merge,defaultOptions$f={colors:palette.colors,symbols:["circle","diamond","square","triangle","triangle-down"],lang:{loading:"Loading...",months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],weekdays:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],decimalPoint:".",numericSymbols:["k","M","G","T","P","E"],resetZoom:"Reset zoom",resetZoomTitle:"Reset zoom level 1:1",thousandsSep:" "},global:{},time:{Date:void 0,getTimezoneOffset:void 0,timezone:void 0,timezoneOffset:0,useUTC:!0},chart:ChartDefaults,title:{text:"Chart title",align:"center",margin:15,widthAdjust:-44},subtitle:{text:"",align:"center",widthAdjust:-44},caption:{margin:15,text:"",align:"left",verticalAlign:"bottom"},plotOptions:{},labels:{style:{position:"absolute",color:palette.neutralColor80}},legend:{enabled:!0,align:"center",alignColumns:!0,className:"highcharts-no-tooltip",layout:"horizontal",labelFormatter:function(){return this.name},borderColor:palette.neutralColor40,borderRadius:0,navigation:{activeColor:palette.highlightColor100,inactiveColor:palette.neutralColor20},itemStyle:{color:palette.neutralColor80,cursor:"pointer",fontSize:"12px",fontWeight:"bold",textOverflow:"ellipsis"},itemHoverStyle:{color:palette.neutralColor100},itemHiddenStyle:{color:palette.neutralColor20},shadow:!1,itemCheckboxStyle:{position:"absolute",width:"13px",height:"13px"},squareSymbol:!0,symbolPadding:5,verticalAlign:"bottom",x:0,y:0,title:{style:{fontWeight:"bold"}}},loading:{labelStyle:{fontWeight:"bold",position:"relative",top:"45%"},style:{position:"absolute",backgroundColor:palette.backgroundColor,opacity:.5,textAlign:"center"}},tooltip:{enabled:!0,animation:svg$5,borderRadius:3,dateTimeLabelFormats:{millisecond:"%A, %b %e, %H:%M:%S.%L",second:"%A, %b %e, %H:%M:%S",minute:"%A, %b %e, %H:%M",hour:"%A, %b %e, %H:%M",day:"%A, %b %e, %Y",week:"Week from %A, %b %e, %Y",month:"%B %Y",year:"%Y"},footerFormat:"",headerShape:"callout",hideDelay:500,padding:8,shape:"callout",shared:!1,snap:isTouchDevice$4?25:10,headerFormat:'<span style="font-size: 10px">{point.key}</span><br/>',pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.y}</b><br/>',backgroundColor:color$g(palette.neutralColor3).setOpacity(.85).get(),borderWidth:1,shadow:!0,stickOnContact:!1,style:{color:palette.neutralColor80,cursor:"default",fontSize:"12px",whiteSpace:"nowrap"},useHTML:!1},credits:{enabled:!0,href:"https://www.highcharts.com?credits",position:{align:"right",x:-10,verticalAlign:"bottom",y:-5},style:{cursor:"pointer",color:palette.neutralColor40,fontSize:"9px"},text:"Highcharts.com"}};defaultOptions$f.chart.styledMode=!1;var defaultTime$2=new Time(merge$1m(defaultOptions$f.global,defaultOptions$f.time));function getOptions$3(){return defaultOptions$f}function setOptions$2(n){return merge$1m(!0,defaultOptions$f,n),(n.time||n.global)&&(H.time?H.time.update(merge$1m(defaultOptions$f.global,defaultOptions$f.time,n.global,n.time)):H.time=defaultTime$2),defaultOptions$f}var DefaultOptions={defaultOptions:defaultOptions$f,defaultTime:defaultTime$2,getOptions:getOptions$3,setOptions:setOptions$2},color$f=Color.parse,win$e=H.win,isNumber$P=Utilities.isNumber,objectEach$z=Utilities.objectEach,Fx=function(){function n(e,t,r){this.pos=NaN,this.options=t,this.elem=e,this.prop=r}return n.prototype.dSetter=function(){var e=this.paths,t=e&&e[0],r=e&&e[1],o=this.now||0,s=[];if(o===1||!t||!r)s=this.toD||[];else if(t.length===r.length&&o<1)for(var a=0;a<r.length;a++){for(var l=t[a],h=r[a],d=[],c=0;c<h.length;c++){var p=l[c],f=h[c];isNumber$P(p)&&isNumber$P(f)&&!(h[0]==="A"&&(c===4||c===5))?d[c]=p+o*(f-p):d[c]=f}s.push(d)}else s=r;this.elem.attr("d",s,void 0,!0)},n.prototype.update=function(){var e=this.elem,t=this.prop,r=this.now,o=this.options.step;this[t+"Setter"]?this[t+"Setter"]():e.attr?e.element&&e.attr(t,r,null,!0):e.style[t]=r+this.unit,o&&o.call(e,r,this)},n.prototype.run=function(e,t,r){var o=this,s=o.options,a=function(d){return a.stopped?!1:o.step(d)},l=win$e.requestAnimationFrame||function(d){setTimeout(d,13)},h=function(){for(var d=0;d<n.timers.length;d++)n.timers[d]()||n.timers.splice(d--,1);n.timers.length&&l(h)};e===t&&!this.elem["forceAnimate:"+this.prop]?(delete s.curAnim[this.prop],s.complete&&Object.keys(s.curAnim).length===0&&s.complete.call(this.elem)):(this.startTime=+new Date,this.start=e,this.end=t,this.unit=r,this.now=this.start,this.pos=0,a.elem=this.elem,a.prop=this.prop,a()&&n.timers.push(a)===1&&l(h))},n.prototype.step=function(e){var t=+new Date,r=this.options,o=this.elem,s=r.complete,a=r.duration,l=r.curAnim,h,d;return o.attr&&!o.element?h=!1:e||t>=a+this.startTime?(this.now=this.end,this.pos=1,this.update(),l[this.prop]=!0,d=!0,objectEach$z(l,function(c){c!==!0&&(d=!1)}),d&&s&&s.call(o),h=!1):(this.pos=r.easing((t-this.startTime)/a),this.now=this.start+(this.end-this.start)*this.pos,this.update(),h=!0),h},n.prototype.initPath=function(e,t,r){var o=e.startX,s=e.endX,a=r.slice(),l=e.isArea,h=l?2:1,d,c,p,f,u=t&&t.slice();if(!u)return[a,a];function g(y,v){for(;y.length<c;){var x=y[0],b=v[c-y.length];if(b&&x[0]==="M"&&(b[0]==="C"?y[0]=["C",x[1],x[2],x[1],x[2],x[1],x[2]]:y[0]=["L",x[1],x[2]]),y.unshift(x),l){var $=y.pop();y.push(y[y.length-1],$)}}}function m(y,v){for(;y.length<c;){var x=y[Math.floor(y.length/h)-1].slice();if(x[0]==="C"&&(x[1]=x[5],x[2]=x[6]),!l)y.push(x);else{var b=y[Math.floor(y.length/h)].slice();y.splice(y.length/2,0,x,b)}}}if(o&&s&&s.length){for(p=0;p<o.length;p++)if(o[p]===s[0]){d=p;break}else if(o[0]===s[s.length-o.length+p]){d=p,f=!0;break}else if(o[o.length-1]===s[s.length-o.length+p]){d=o.length-p;break}typeof d>"u"&&(u=[])}return u.length&&isNumber$P(d)&&(c=a.length+d*h,f?(g(u,a),m(a)):(g(a,u),m(u))),[u,a]},n.prototype.fillSetter=function(){n.prototype.strokeSetter.apply(this,arguments)},n.prototype.strokeSetter=function(){this.elem.attr(this.prop,color$f(this.start).tweenTo(color$f(this.end),this.pos),null,!0)},n.timers=[],n}(),defined$U=Utilities.defined,getStyle$1=Utilities.getStyle,isArray$m=Utilities.isArray,isNumber$O=Utilities.isNumber,isObject$d=Utilities.isObject,merge$1l=Utilities.merge,objectEach$y=Utilities.objectEach,pick$1z=Utilities.pick;function setAnimation$5(n,e){e.renderer.globalAnimation=pick$1z(n,e.options.chart.animation,!0)}function animObject$c(n){return isObject$d(n)?merge$1l({duration:500,defer:0},n):{duration:n?500:0,defer:0}}function getDeferredAnimation$3(n,e,t){var r=animObject$c(e),o=t?[t]:n.series,s=0,a=0;o.forEach(function(h){var d=animObject$c(h.options.animation);s=e&&defined$U(e.defer)?r.defer:Math.max(s,d.duration+d.defer),a=Math.min(r.duration,d.duration)}),n.renderer.forExport&&(s=0);var l={defer:Math.max(0,s-a),duration:Math.min(s,a)};return l}function animate$2(n,e,t){var r,o="",s,a,l;isObject$d(t)||(l=arguments,t={duration:l[2],easing:l[3],complete:l[4]}),isNumber$O(t.duration)||(t.duration=400),t.easing=typeof t.easing=="function"?t.easing:Math[t.easing]||Math.easeInOutSine,t.curAnim=merge$1l(e),objectEach$y(e,function(h,d){stop$2(n,d),a=new Fx(n,t,d),s=void 0,d==="d"&&isArray$m(e.d)?(a.paths=a.initPath(n,n.pathArray,e.d),a.toD=e.d,r=0,s=1):n.attr?r=n.attr(d):(r=parseFloat(getStyle$1(n,d))||0,d!=="opacity"&&(o="px")),s||(s=h),typeof s=="string"&&s.match("px")&&(s=s.replace(/px/g,"")),a.run(r,s,o)})}function stop$2(n,e){for(var t=Fx.timers.length;t--;)Fx.timers[t].elem===n&&(!e||e===Fx.timers[t].prop)&&(Fx.timers[t].stopped=!0)}var animationExports={animate:animate$2,animObject:animObject$c,getDeferredAnimation:getDeferredAnimation$3,setAnimation:setAnimation$5,stop:stop$2},SVG_NS$3=H.SVG_NS,attr$7=Utilities.attr,createElement$a=Utilities.createElement,discardElement$6=Utilities.discardElement,error$8=Utilities.error,isString$b=Utilities.isString,objectEach$x=Utilities.objectEach,splat$h=Utilities.splat,hasValidDOMParser=function(){try{return!!new DOMParser().parseFromString("","text/html")}catch{return!1}}(),AST=function(){function n(e){this.nodes=typeof e=="string"?this.parseMarkup(e):e}return n.filterUserAttributes=function(e){return objectEach$x(e,function(t,r){var o=!0;n.allowedAttributes.indexOf(r)===-1&&(o=!1),["background","dynsrc","href","lowsrc","src"].indexOf(r)!==-1&&(o=isString$b(t)&&n.allowedReferences.some(function(s){return t.indexOf(s)===0})),o||(error$8("Highcharts warning: Invalid attribute '"+r+"' in config"),delete e[r])}),e},n.setElementHTML=function(e,t){if(e.innerHTML="",t){var r=new n(t);r.addToDOM(e)}},n.prototype.addToDOM=function(e){function t(r,o){var s;return splat$h(r).forEach(function(a){var l=a.tagName,h=a.textContent?H.doc.createTextNode(a.textContent):void 0,d;if(l)if(l==="#text")d=h;else if(n.allowedTags.indexOf(l)!==-1){var c=l==="svg"?SVG_NS$3:o.namespaceURI||SVG_NS$3,p=H.doc.createElementNS(c,l),f=a.attributes||{};objectEach$x(a,function(u,g){g!=="tagName"&&g!=="attributes"&&g!=="children"&&g!=="textContent"&&(f[g]=u)}),attr$7(p,n.filterUserAttributes(f)),h&&p.appendChild(h),t(a.children||[],p),d=p}else error$8("Highcharts warning: Invalid tagName '"+l+"' in config");d&&o.appendChild(d),s=d}),s}return t(this.nodes,e)},n.prototype.parseMarkup=function(e){var t=[];e=e.trim();var r,o;hasValidDOMParser?r=new DOMParser().parseFromString(e,"text/html"):(o=createElement$a("div"),o.innerHTML=e,r={body:o});var s=function(a,l){var h=a.nodeName.toLowerCase(),d={tagName:h};h==="#text"&&(d.textContent=a.textContent||"");var c=a.attributes;if(c){var p={};[].forEach.call(c,function(u){p[u.name]=u.value}),d.attributes=p}if(a.childNodes.length){var f=[];[].forEach.call(a.childNodes,function(u){s(u,f)}),f.length&&(d.children=f)}l.push(d)};return[].forEach.call(r.body.childNodes,function(a){return s(a,t)}),o&&discardElement$6(o),t},n.allowedAttributes=["aria-controls","aria-describedby","aria-expanded","aria-haspopup","aria-hidden","aria-label","aria-labelledby","aria-live","aria-pressed","aria-readonly","aria-roledescription","aria-selected","class","clip-path","color","colspan","cx","cy","d","dx","dy","disabled","fill","height","href","id","in","markerHeight","markerWidth","offset","opacity","orient","padding","paddingLeft","paddingRight","patternUnits","r","refX","refY","role","scope","slope","src","startOffset","stdDeviation","stroke","stroke-linecap","stroke-width","style","tableValues","result","rowspan","summary","target","tabindex","text-align","textAnchor","textLength","type","valign","width","x","x1","x2","y","y1","y2","zIndex"],n.allowedReferences=["https://","http://","mailto:","/","../","./","#"],n.allowedTags=["a","b","br","button","caption","circle","clipPath","code","dd","defs","div","dl","dt","em","feComponentTransfer","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feOffset","feMerge","feMergeNode","filter","h1","h2","h3","h4","h5","h6","hr","i","img","li","linearGradient","marker","ol","p","path","pattern","pre","rect","small","span","stop","strong","style","sub","sup","svg","table","text","thead","tbody","tspan","td","th","tr","u","ul","#text"],n}(),defaultOptions$e=DefaultOptions.defaultOptions,defaultTime$1=DefaultOptions.defaultTime,getNestedProperty$2=Utilities.getNestedProperty,isNumber$N=Utilities.isNumber,pick$1y=Utilities.pick,pInt$8=Utilities.pInt;function dateFormat(n,e,t){return defaultTime$1.dateFormat(n,e,t)}function format$d(n,e,t){for(var r="{",o=!1,s,a,l,h,d=/f$/,c=/\.([0-9])/,p=defaultOptions$e.lang,f=t&&t.time||defaultTime$1,u=t&&t.numberFormatter||numberFormat$2,g=[];n&&(h=n.indexOf(r),h!==-1);){if(s=n.slice(0,h),o){if(a=s.split(":"),l=getNestedProperty$2(a.shift()||"",e),a.length&&typeof l=="number")if(s=a.join(":"),d.test(s)){var m=parseInt((s.match(c)||["","-1"])[1],10);l!==null&&(l=u(l,m,p.decimalPoint,s.indexOf(",")>-1?p.thousandsSep:""))}else l=f.dateFormat(s,l);g.push(l)}else g.push(s);n=n.slice(h+1),o=!o,r=o?"}":"{"}return g.push(n),g.join("")}function numberFormat$2(n,e,t,r){n=+n||0,e=+e;var o,s,a=defaultOptions$e.lang,l=(n.toString().split(".")[1]||"").split("e")[0].length,h=n.toString().split("e"),d=e;e===-1?e=Math.min(l,20):isNumber$N(e)?e&&h[1]&&h[1]<0&&(s=e+ +h[1],s>=0?(h[0]=(+h[0]).toExponential(s).split("e")[0],e=s):(h[0]=h[0].split(".")[0]||0,e<20?n=(h[0]*Math.pow(10,h[1])).toFixed(e):n=0,h[1]=0)):e=2;var c=(Math.abs(h[1]?h[0]:n)+Math.pow(10,-Math.max(e,l)-1)).toFixed(e),p=String(pInt$8(c)),f=p.length>3?p.length%3:0;return t=pick$1y(t,a.decimalPoint),r=pick$1y(r,a.thousandsSep),o=n<0?"-":"",o+=f?p.substr(0,f)+r:"",+h[1]<0&&!d?o="0":o+=p.substr(f).replace(/(\d{3})(?=\d)/g,"$1"+r),e&&(o+=t+c.slice(-e)),h[1]&&+o!=0&&(o+="e"+h[1]),o}var FormatUtilities={dateFormat,format:format$d,numberFormat:numberFormat$2},clamp$i=Utilities.clamp,pick$1x=Utilities.pick,stableSort$6=Utilities.stableSort,RendererUtilities;(function(n){function e(t,r,o){var s=t,a=s.reducedLen||r,l=function(m,y){return(y.rank||0)-(m.rank||0)},h=function(m,y){return m.target-y.target},d,c=!0,p=[],f,u,g=0;for(d=t.length;d--;)g+=t[d].size;if(g>a){for(stableSort$6(t,l),d=0,g=0;g<=a;)g+=t[d].size,d++;p=t.splice(d-1,t.length)}for(stableSort$6(t,h),t=t.map(function(m){return{size:m.size,targets:[m.target],align:pick$1x(m.align,.5)}});c;){for(d=t.length;d--;)f=t[d],u=(Math.min.apply(0,f.targets)+Math.max.apply(0,f.targets))/2,f.pos=clamp$i(u-f.size*f.align,0,r-f.size);for(d=t.length,c=!1;d--;)d>0&&t[d-1].pos+t[d-1].size>t[d].pos&&(t[d-1].size+=t[d].size,t[d-1].targets=t[d-1].targets.concat(t[d].targets),t[d-1].align=.5,t[d-1].pos+t[d-1].size>r&&(t[d-1].pos=r-t[d-1].size),t.splice(d,1),c=!0)}return s.push.apply(s,p),d=0,t.some(function(m){var y=0;return(m.targets||[]).some(function(){return s[d].pos=m.pos+y,typeof o<"u"&&Math.abs(s[d].pos-s[d].target)>o?(s.slice(0,d+1).forEach(function(v){return delete v.pos}),s.reducedLen=(s.reducedLen||r)-r*.1,s.reducedLen>r*.1&&e(s,r,o),!0):(y+=s[d].size,d++,!1)})}),stableSort$6(s,h),s}n.distribute=e})(RendererUtilities||(RendererUtilities={}));const R=RendererUtilities;var animate$1=animationExports.animate,animObject$b=animationExports.animObject,stop$1=animationExports.stop,deg2rad$8=H.deg2rad,doc$l=H.doc,noop$l=H.noop,svg$4=H.svg,SVG_NS$2=H.SVG_NS,win$d=H.win,addEvent$11=Utilities.addEvent,attr$6=Utilities.attr,createElement$9=Utilities.createElement,css$c=Utilities.css,defined$T=Utilities.defined,erase$8=Utilities.erase,extend$1o=Utilities.extend,fireEvent$A=Utilities.fireEvent,isArray$l=Utilities.isArray,isFunction$4=Utilities.isFunction,isNumber$M=Utilities.isNumber,isString$a=Utilities.isString,merge$1k=Utilities.merge,objectEach$w=Utilities.objectEach,pick$1w=Utilities.pick,pInt$7=Utilities.pInt,syncTimeout$8=Utilities.syncTimeout,uniqueKey$7=Utilities.uniqueKey,SVGElement=function(){function n(){this.element=void 0,this.onEvents={},this.opacity=1,this.renderer=void 0,this.SVG_NS=SVG_NS$2,this.symbolCustomAttribs=["x","y","width","height","r","start","end","innerR","anchorX","anchorY","rounded"]}return n.prototype._defaultGetter=function(e){var t=pick$1w(this[e+"Value"],this[e],this.element?this.element.getAttribute(e):null,0);return/^[\-0-9\.]+$/.test(t)&&(t=parseFloat(t)),t},n.prototype._defaultSetter=function(e,t,r){r.setAttribute(t,e)},n.prototype.add=function(e){var t=this.renderer,r=this.element,o;return e&&(this.parentGroup=e),this.parentInverted=e&&e.inverted,typeof this.textStr<"u"&&this.element.nodeName==="text"&&t.buildText(this),this.added=!0,(!e||e.handleZ||this.zIndex)&&(o=this.zIndexSetter()),o||(e?e.element:t.box).appendChild(r),this.onAdd&&this.onAdd(),this},n.prototype.addClass=function(e,t){var r=t?"":this.attr("class")||"";return e=(e||"").split(/ /g).reduce(function(o,s){return r.indexOf(s)===-1&&o.push(s),o},r?[r]:[]).join(" "),e!==r&&this.attr("class",e),this},n.prototype.afterSetters=function(){this.doTransform&&(this.updateTransform(),this.doTransform=!1)},n.prototype.align=function(e,t,r){var o={},s=this.renderer,a=s.alignedObjects,l,h,d,c,p;e?(this.alignOptions=e,this.alignByTranslate=t,(!r||isString$a(r))&&(this.alignTo=d=r||"renderer",erase$8(a,this),a.push(this),r=void 0)):(e=this.alignOptions,t=this.alignByTranslate,d=this.alignTo),r=pick$1w(r,s[d],d==="scrollablePlotBox"?s.plotBox:void 0,s);var f=e.align,u=e.verticalAlign;return l=(r.x||0)+(e.x||0),h=(r.y||0)+(e.y||0),f==="right"?c=1:f==="center"&&(c=2),c&&(l+=(r.width-(e.width||0))/c),o[t?"translateX":"x"]=Math.round(l),u==="bottom"?p=1:u==="middle"&&(p=2),p&&(h+=(r.height-(e.height||0))/p),o[t?"translateY":"y"]=Math.round(h),this[this.placed?"animate":"attr"](o),this.placed=!0,this.alignAttr=o,this},n.prototype.alignSetter=function(e){var t={left:"start",center:"middle",right:"end"};t[e]&&(this.alignValue=e,this.element.setAttribute("text-anchor",t[e]))},n.prototype.animate=function(e,t,r){var o=this,s=animObject$b(pick$1w(t,this.renderer.globalAnimation,!0)),a=s.defer;return pick$1w(doc$l.hidden,doc$l.msHidden,doc$l.webkitHidden,!1)&&(s.duration=0),s.duration!==0?(r&&(s.complete=r),syncTimeout$8(function(){o.element&&animate$1(o,e,s)},a)):(this.attr(e,void 0,r),objectEach$w(e,function(l,h){s.step&&s.step.call(this,l,{prop:h,pos:1,elem:this})},this)),this},n.prototype.applyTextOutline=function(e){var t=this.element,r=e.indexOf("contrast")!==-1;r&&(e=e.replace(/contrast/g,this.renderer.getContrast(t.style.fill)));var o=e.split(" "),s=o[o.length-1],a=o[0];if(a&&a!=="none"&&H.svg){this.fakeTS=!0,this.ySetter=this.xSetter,a=a.replace(/(^[\d\.]+)(.*?)$/g,function(d,c,p){return 2*Number(c)+p}),this.removeTextOutline();var l=doc$l.createElementNS(SVG_NS$2,"tspan");attr$6(l,{class:"highcharts-text-outline",fill:s,stroke:s,"stroke-width":a,"stroke-linejoin":"round"}),[].forEach.call(t.childNodes,function(d){var c=d.cloneNode(!0);c.removeAttribute&&["fill","stroke","stroke-width","stroke"].forEach(function(p){return c.removeAttribute(p)}),l.appendChild(c)});var h=doc$l.createElementNS(SVG_NS$2,"tspan");h.textContent="​",["x","y"].forEach(function(d){var c=t.getAttribute(d);c&&h.setAttribute(d,c)}),l.appendChild(h),t.insertBefore(l,t.firstChild)}},n.prototype.attr=function(e,t,r,o){var s=this.element,a=this.symbolCustomAttribs,l,h,d=this,c,p;return typeof e=="string"&&typeof t<"u"&&(l=e,e={},e[l]=t),typeof e=="string"?d=(this[e+"Getter"]||this._defaultGetter).call(this,e,s):(objectEach$w(e,function(u,g){c=!1,o||stop$1(this,g),this.symbolName&&a.indexOf(g)!==-1&&(h||(this.symbolAttr(e),h=!0),c=!0),this.rotation&&(g==="x"||g==="y")&&(this.doTransform=!0),c||(p=this[g+"Setter"]||this._defaultSetter,p.call(this,u,g,s),!this.styledMode&&this.shadows&&/^(width|height|visibility|x|y|d|transform|cx|cy|r)$/.test(g)&&this.updateShadows(g,u,p))},this),this.afterSetters()),r&&r.call(this),d},n.prototype.clip=function(e){return this.attr("clip-path",e?"url("+this.renderer.url+"#"+e.id+")":"none")},n.prototype.crisp=function(e,t){var r=this;t=t||e.strokeWidth||0;var o=Math.round(t)%2/2;return e.x=Math.floor(e.x||r.x||0)+o,e.y=Math.floor(e.y||r.y||0)+o,e.width=Math.floor((e.width||r.width||0)-2*o),e.height=Math.floor((e.height||r.height||0)-2*o),defined$T(e.strokeWidth)&&(e.strokeWidth=t),e},n.prototype.complexColor=function(e,t,r){var o=this.renderer,s,a,l,h,d,c,p,f,u,g,m=[],y;fireEvent$A(this.renderer,"complexColor",{args:arguments},function(){if(e.radialGradient?a="radialGradient":e.linearGradient&&(a="linearGradient"),a){if(l=e[a],d=o.gradients,c=e.stops,u=r.radialReference,isArray$l(l)&&(e[a]=l={x1:l[0],y1:l[1],x2:l[2],y2:l[3],gradientUnits:"userSpaceOnUse"}),a==="radialGradient"&&u&&!defined$T(l.gradientUnits)&&(h=l,l=merge$1k(l,o.getRadialAttr(u,h),{gradientUnits:"userSpaceOnUse"})),objectEach$w(l,function(x,b){b!=="id"&&m.push(b,x)}),objectEach$w(c,function(x){m.push(x)}),m=m.join(","),d[m])g=d[m].attr("id");else{l.id=g=uniqueKey$7();var v=d[m]=o.createElement(a).attr(l).add(o.defs);v.radAttr=h,v.stops=[],c.forEach(function(x){x[1].indexOf("rgba")===0?(s=Color.parse(x[1]),p=s.get("rgb"),f=s.get("a")):(p=x[1],f=1);var b=o.createElement("stop").attr({offset:x[0],"stop-color":p,"stop-opacity":f}).add(v);v.stops.push(b)})}y="url("+o.url+"#"+g+")",r.setAttribute(t,y),r.gradient=m,e.toString=function(){return y}}})},n.prototype.css=function(e){var t=this.styles,r={},o=this.element,s=["textOutline","textOverflow","width"],a,l="",h,d=!t;return e&&e.color&&(e.fill=e.color),t&&objectEach$w(e,function(c,p){t&&t[p]!==c&&(r[p]=c,d=!0)}),d&&(t&&(e=extend$1o(t,r)),e&&(e.width===null||e.width==="auto"?delete this.textWidth:o.nodeName.toLowerCase()==="text"&&e.width&&(a=this.textWidth=pInt$7(e.width))),this.styles=e,a&&!svg$4&&this.renderer.forExport&&delete e.width,o.namespaceURI===this.SVG_NS?(h=function(c,p){return"-"+p.toLowerCase()},objectEach$w(e,function(c,p){s.indexOf(p)===-1&&(l+=p.replace(/([A-Z])/g,h)+":"+c+";")}),l&&attr$6(o,"style",l)):css$c(o,e),this.added&&(this.element.nodeName==="text"&&this.renderer.buildText(this),e&&e.textOutline&&this.applyTextOutline(e.textOutline))),this},n.prototype.dashstyleSetter=function(e){var t,r=this["stroke-width"];if(r==="inherit"&&(r=1),e=e&&e.toLowerCase(),e){var o=e.replace("shortdashdotdot","3,1,1,1,1,1,").replace("shortdashdot","3,1,1,1").replace("shortdot","1,1,").replace("shortdash","3,1,").replace("longdash","8,3,").replace(/dot/g,"1,3,").replace("dash","4,3,").replace(/,$/,"").split(",");for(t=o.length;t--;)o[t]=""+pInt$7(o[t])*pick$1w(r,NaN);e=o.join(",").replace(/NaN/g,"none"),this.element.setAttribute("stroke-dasharray",e)}},n.prototype.destroy=function(){var e=this,t=e.element||{},r=e.renderer,o=t.ownerSVGElement,s=r.isSVG&&t.nodeName==="SPAN"&&e.parentGroup||void 0,a,l;if(t.onclick=t.onmouseout=t.onmouseover=t.onmousemove=t.point=null,stop$1(e),e.clipPath&&o){var h=e.clipPath;[].forEach.call(o.querySelectorAll("[clip-path],[CLIP-PATH]"),function(d){d.getAttribute("clip-path").indexOf(h.element.id)>-1&&d.removeAttribute("clip-path")}),e.clipPath=h.destroy()}if(e.stops){for(l=0;l<e.stops.length;l++)e.stops[l].destroy();e.stops.length=0,e.stops=void 0}for(e.safeRemoveChild(t),r.styledMode||e.destroyShadows();s&&s.div&&s.div.childNodes.length===0;)a=s.parentGroup,e.safeRemoveChild(s.div),delete s.div,s=a;e.alignTo&&erase$8(r.alignedObjects,e),objectEach$w(e,function(d,c){e[c]&&e[c].parentGroup===e&&e[c].destroy&&e[c].destroy(),delete e[c]})},n.prototype.destroyShadows=function(){(this.shadows||[]).forEach(function(e){this.safeRemoveChild(e)},this),this.shadows=void 0},n.prototype.destroyTextPath=function(e,t){var r=e.getElementsByTagName("text")[0],o;if(r){if(r.removeAttribute("dx"),r.removeAttribute("dy"),t.element.setAttribute("id",""),this.textPathWrapper&&r.getElementsByTagName("textPath").length){for(o=this.textPathWrapper.element.childNodes;o.length;)r.appendChild(o[0]);r.removeChild(this.textPathWrapper.element)}}else(e.getAttribute("dx")||e.getAttribute("dy"))&&(e.removeAttribute("dx"),e.removeAttribute("dy"));this.textPathWrapper&&(this.textPathWrapper=this.textPathWrapper.destroy())},n.prototype.dSetter=function(e,t,r){isArray$l(e)&&(typeof e[0]=="string"&&(e=this.renderer.pathToSegments(e)),this.pathArray=e,e=e.reduce(function(o,s,a){return!s||!s.join?(s||"").toString():(a?o+" ":"")+s.join(" ")},"")),/(NaN| {2}|^$)/.test(e)&&(e="M 0 0"),this[t]!==e&&(r.setAttribute(t,e),this[t]=e)},n.prototype.fadeOut=function(e){var t=this;t.animate({opacity:0},{duration:pick$1w(e,150),complete:function(){t.attr({y:-9999}).hide()}})},n.prototype.fillSetter=function(e,t,r){typeof e=="string"?r.setAttribute(t,e):e&&this.complexColor(e,t,r)},n.prototype.getBBox=function(e,t){var r=this,o=r.renderer,s=r.element,a=r.styles,l=r.textStr,h=o.cache,d=o.cacheKeys,c=s.namespaceURI===r.SVG_NS,p=pick$1w(t,r.rotation,0),f=o.styledMode?s&&n.prototype.getStyle.call(s,"font-size"):a&&a.fontSize,u,g,m,y,v;if(defined$T(l)&&(v=l.toString(),v.indexOf("<")===-1&&(v=v.replace(/[0-9]/g,"0")),v+=["",p,f,r.textWidth,a&&a.textOverflow,a&&a.fontWeight].join(",")),v&&!e&&(u=h[v]),!u){if(c||o.forExport){try{y=this.fakeTS&&function(b){var $=s.querySelector(".highcharts-text-outline");$&&css$c($,{display:b})},isFunction$4(y)&&y("none"),u=s.getBBox?extend$1o({},s.getBBox()):{width:s.offsetWidth,height:s.offsetHeight},isFunction$4(y)&&y("")}catch{}(!u||u.width<0)&&(u={width:0,height:0})}else u=r.htmlGetBBox();if(o.isSVG&&(g=u.width,m=u.height,c&&(u.height=m={"11px,17":14,"13px,20":16}[a&&a.fontSize+","+Math.round(m)]||m),p)){var x=p*deg2rad$8;u.width=Math.abs(m*Math.sin(x))+Math.abs(g*Math.cos(x)),u.height=Math.abs(m*Math.cos(x))+Math.abs(g*Math.sin(x))}if(v&&(l===""||u.height>0)){for(;d.length>250;)delete h[d.shift()];h[v]||d.push(v),h[v]=u}}return u},n.prototype.getStyle=function(e){return win$d.getComputedStyle(this.element||this,"").getPropertyValue(e)},n.prototype.hasClass=function(e){return(""+this.attr("class")).split(" ").indexOf(e)!==-1},n.prototype.hide=function(e){return e?this.attr({y:-9999}):this.attr({visibility:"hidden"}),this},n.prototype.htmlGetBBox=function(){return{height:0,width:0,x:0,y:0}},n.prototype.init=function(e,t){this.element=t==="span"?createElement$9(t):doc$l.createElementNS(this.SVG_NS,t),this.renderer=e,fireEvent$A(this,"afterInit")},n.prototype.invert=function(e){return this.inverted=e,this.updateTransform(),this},n.prototype.on=function(e,t){var r=this.onEvents;return r[e]&&r[e](),r[e]=addEvent$11(this.element,e,t),this},n.prototype.opacitySetter=function(e,t,r){var o=Number(Number(e).toFixed(3));this.opacity=o,r.setAttribute(t,o)},n.prototype.removeClass=function(e){return this.attr("class",(""+this.attr("class")).replace(isString$a(e)?new RegExp("(^| )"+e+"( |$)"):e," ").replace(/ +/g," ").trim())},n.prototype.removeTextOutline=function(){var e=this.element.querySelector("tspan.highcharts-text-outline");e&&this.safeRemoveChild(e)},n.prototype.safeRemoveChild=function(e){var t=e.parentNode;t&&t.removeChild(e)},n.prototype.setRadialReference=function(e){var t=this.element.gradient&&this.renderer.gradients[this.element.gradient];return this.element.radialReference=e,t&&t.radAttr&&t.animate(this.renderer.getRadialAttr(e,t.radAttr)),this},n.prototype.setTextPath=function(e,t){var r=this.element,o=this.text?this.text.element:r,s={textAnchor:"text-anchor"},a=!1,l,h,d=this.textPathWrapper,c=!d;t=merge$1k(!0,{enabled:!0,attributes:{dy:-5,startOffset:"50%",textAnchor:"middle"}},t);var p=AST.filterUserAttributes(t.attributes);if(e&&t&&t.enabled){if(d&&d.element.parentNode===null?(c=!0,d=d.destroy()):d&&this.removeTextOutline.call(d.parentGroup),this.options&&this.options.padding&&(p.dx=-this.options.padding),d||(this.textPathWrapper=d=this.renderer.createElement("textPath"),a=!0),l=d.element,h=e.element.getAttribute("id"),h||e.element.setAttribute("id",h=uniqueKey$7()),c){o.setAttribute("y",0),isNumber$M(p.dx)&&o.setAttribute("x",-p.dx);for(var f=[].slice.call(o.childNodes),u=0;u<f.length;u++){var g=f[u];(g.nodeType===Node.TEXT_NODE||g.nodeName==="tspan")&&l.appendChild(g)}}a&&d&&d.add({element:o}),l.setAttributeNS("http://www.w3.org/1999/xlink","href",this.renderer.url+"#"+h),defined$T(p.dy)&&(l.parentNode.setAttribute("dy",p.dy),delete p.dy),defined$T(p.dx)&&(l.parentNode.setAttribute("dx",p.dx),delete p.dx),objectEach$w(p,function(m,y){l.setAttribute(s[y]||y,m)}),r.removeAttribute("transform"),this.removeTextOutline.call(d),this.text&&!this.renderer.styledMode&&this.attr({fill:"none","stroke-width":0}),this.updateTransform=noop$l,this.applyTextOutline=noop$l}else d&&(delete this.updateTransform,delete this.applyTextOutline,this.destroyTextPath(r,e),this.updateTransform(),this.options&&this.options.rotation&&this.applyTextOutline(this.options.style.textOutline));return this},n.prototype.shadow=function(e,t,r){var o=[],s=this.element,a=this.oldShadowOptions,l={color:palette.neutralColor100,offsetX:this.parentInverted?-1:1,offsetY:this.parentInverted?-1:1,opacity:.15,width:3},h,d,c,p,f=!1,u,g;if(e===!0?g=l:typeof e=="object"&&(g=extend$1o(l,e)),g&&(g&&a&&objectEach$w(g,function(m,y){m!==a[y]&&(f=!0)}),f&&this.destroyShadows(),this.oldShadowOptions=g),!g)this.destroyShadows();else if(!this.shadows){for(p=g.opacity/g.width,u=this.parentInverted?"translate("+g.offsetY+", "+g.offsetX+")":"translate("+g.offsetX+", "+g.offsetY+")",h=1;h<=g.width;h++)d=s.cloneNode(!1),c=g.width*2+1-2*h,attr$6(d,{stroke:e.color||palette.neutralColor100,"stroke-opacity":p*h,"stroke-width":c,transform:u,fill:"none"}),d.setAttribute("class",(d.getAttribute("class")||"")+" highcharts-shadow"),r&&(attr$6(d,"height",Math.max(attr$6(d,"height")-c,0)),d.cutHeight=c),t?t.element.appendChild(d):s.parentNode&&s.parentNode.insertBefore(d,s),o.push(d);this.shadows=o}return this},n.prototype.show=function(e){return this.attr({visibility:e?"inherit":"visible"})},n.prototype.strokeSetter=function(e,t,r){this[t]=e,this.stroke&&this["stroke-width"]?(n.prototype.fillSetter.call(this,this.stroke,"stroke",r),r.setAttribute("stroke-width",this["stroke-width"]),this.hasStroke=!0):t==="stroke-width"&&e===0&&this.hasStroke?(r.removeAttribute("stroke"),this.hasStroke=!1):this.renderer.styledMode&&this["stroke-width"]&&(r.setAttribute("stroke-width",this["stroke-width"]),this.hasStroke=!0)},n.prototype.strokeWidth=function(){if(!this.renderer.styledMode)return this["stroke-width"]||0;var e=this.getStyle("stroke-width"),t=0,r;return e.indexOf("px")===e.length-2?t=pInt$7(e):e!==""&&(r=doc$l.createElementNS(SVG_NS$2,"rect"),attr$6(r,{width:e,"stroke-width":0}),this.element.parentNode.appendChild(r),t=r.getBBox().width,r.parentNode.removeChild(r)),t},n.prototype.symbolAttr=function(e){var t=this;["x","y","r","start","end","width","height","innerR","anchorX","anchorY","clockwise"].forEach(function(r){t[r]=pick$1w(e[r],t[r])}),t.attr({d:t.renderer.symbols[t.symbolName](t.x,t.y,t.width,t.height,t)})},n.prototype.textSetter=function(e){e!==this.textStr&&(delete this.textPxLength,this.textStr=e,this.added&&this.renderer.buildText(this))},n.prototype.titleSetter=function(e){var t=this.element,r=t.getElementsByTagName("title")[0]||doc$l.createElementNS(this.SVG_NS,"title");t.insertBefore?t.insertBefore(r,t.firstChild):t.appendChild(r),r.textContent=String(pick$1w(e,"")).replace(/<[^>]*>/g,"").replace(/&lt;/g,"<").replace(/&gt;/g,">")},n.prototype.toFront=function(){var e=this.element;return e.parentNode.appendChild(e),this},n.prototype.translate=function(e,t){return this.attr({translateX:e,translateY:t})},n.prototype.updateShadows=function(e,t,r){var o=this.shadows;if(o)for(var s=o.length;s--;)r.call(o[s],e==="height"?Math.max(t-(o[s].cutHeight||0),0):e==="d"?this.d:t,e,o[s])},n.prototype.updateTransform=function(){var e=this,t=e.scaleX,r=e.scaleY,o=e.inverted,s=e.rotation,a=e.matrix,l=e.element,h=e.translateX||0,d=e.translateY||0;o&&(h+=e.width,d+=e.height);var c=["translate("+h+","+d+")"];defined$T(a)&&c.push("matrix("+a.join(",")+")"),o?c.push("rotate(90) scale(-1,1)"):s&&c.push("rotate("+s+" "+pick$1w(this.rotationOriginX,l.getAttribute("x"),0)+" "+pick$1w(this.rotationOriginY,l.getAttribute("y")||0)+")"),(defined$T(t)||defined$T(r))&&c.push("scale("+pick$1w(t,1)+" "+pick$1w(r,1)+")"),c.length&&l.setAttribute("transform",c.join(" "))},n.prototype.visibilitySetter=function(e,t,r){e==="inherit"?r.removeAttribute(t):this[t]!==e&&r.setAttribute(t,e),this[t]=e},n.prototype.xGetter=function(e){return this.element.nodeName==="circle"&&(e==="x"?e="cx":e==="y"&&(e="cy")),this._defaultGetter(e)},n.prototype.zIndexSetter=function(e,t){var r=this.renderer,o=this.parentGroup,s=o||r,a=s.element||r.box,l=this.element,h=a===r.box,d,c,p,f=!1,u,g=this.added,m;if(defined$T(e)?(l.setAttribute("data-z-index",e),e=+e,this[t]===e&&(g=!1)):defined$T(this[t])&&l.removeAttribute("data-z-index"),this[t]=e,g){for(e=this.zIndex,e&&o&&(o.handleZ=!0),d=a.childNodes,m=d.length-1;m>=0&&!f;m--)c=d[m],p=c.getAttribute("data-z-index"),u=!defined$T(p),c!==l&&(e<0&&u&&!h&&!m?(a.insertBefore(l,d[m]),f=!0):(pInt$7(p)<=e||u&&(!defined$T(e)||e>=0))&&(a.insertBefore(l,d[m+1]||null),f=!0));f||(a.insertBefore(l,d[h?3:0]||null),f=!0)}return f},n}();SVGElement.prototype["stroke-widthSetter"]=SVGElement.prototype.strokeSetter;SVGElement.prototype.yGetter=SVGElement.prototype.xGetter;SVGElement.prototype.matrixSetter=SVGElement.prototype.rotationOriginXSetter=SVGElement.prototype.rotationOriginYSetter=SVGElement.prototype.rotationSetter=SVGElement.prototype.scaleXSetter=SVGElement.prototype.scaleYSetter=SVGElement.prototype.translateXSetter=SVGElement.prototype.translateYSetter=SVGElement.prototype.verticalAlignSetter=function(n,e){this[e]=n,this.doTransform=!0};var RendererRegistry;(function(n){n.rendererTypes={};var e;function t(o){return o===void 0&&(o=e),n.rendererTypes[o]||n.rendererTypes[e]}n.getRendererType=t;function r(o,s,a){n.rendererTypes[o]=s,(!e||a)&&(e=o,H.Renderer=s)}n.registerRendererType=r})(RendererRegistry||(RendererRegistry={}));const RendererRegistry$1=RendererRegistry;var __extends$Y=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),defined$S=Utilities.defined,extend$1n=Utilities.extend,isNumber$L=Utilities.isNumber,merge$1j=Utilities.merge,pick$1v=Utilities.pick,removeEvent$b=Utilities.removeEvent,SVGLabel=function(n){__extends$Y(e,n);function e(t,r,o,s,a,l,h,d,c,p){var f=n.call(this)||this;f.paddingLeftSetter=f.paddingSetter,f.paddingRightSetter=f.paddingSetter,f.init(t,"g"),f.textStr=r,f.x=o,f.y=s,f.anchorX=l,f.anchorY=h,f.baseline=c,f.className=p,f.addClass(p==="button"?"highcharts-no-tooltip":"highcharts-label"),p&&f.addClass("highcharts-"+p),f.text=t.text(void 0,0,0,d).attr({zIndex:1});var u;return typeof a=="string"&&(u=/^url\((.*?)\)$/.test(a),(u||f.renderer.symbols[a])&&(f.symbolKey=a)),f.bBox=e.emptyBBox,f.padding=3,f.baselineOffset=0,f.needsBox=t.styledMode||u,f.deferredAttr={},f.alignFactor=0,f}return e.prototype.alignSetter=function(t){var r={left:0,center:.5,right:1}[t];r!==this.alignFactor&&(this.alignFactor=r,this.bBox&&isNumber$L(this.xSetting)&&this.attr({x:this.xSetting}))},e.prototype.anchorXSetter=function(t,r){this.anchorX=t,this.boxAttr(r,Math.round(t)-this.getCrispAdjust()-this.xSetting)},e.prototype.anchorYSetter=function(t,r){this.anchorY=t,this.boxAttr(r,t-this.ySetting)},e.prototype.boxAttr=function(t,r){this.box?this.box.attr(t,r):this.deferredAttr[t]=r},e.prototype.css=function(t){if(t){var r={};t=merge$1j(t),e.textProps.forEach(function(a){typeof t[a]<"u"&&(r[a]=t[a],delete t[a])}),this.text.css(r);var o="width"in r,s="fontSize"in r||"fontWeight"in r;s?this.updateTextPadding():o&&this.updateBoxSize()}return SVGElement.prototype.css.call(this,t)},e.prototype.destroy=function(){removeEvent$b(this.element,"mouseenter"),removeEvent$b(this.element,"mouseleave"),this.text&&this.text.destroy(),this.box&&(this.box=this.box.destroy()),SVGElement.prototype.destroy.call(this)},e.prototype.fillSetter=function(t,r){t&&(this.needsBox=!0),this.fill=t,this.boxAttr(r,t)},e.prototype.getBBox=function(){this.textStr&&this.bBox.width===0&&this.bBox.height===0&&this.updateBoxSize();var t=this.padding,r=pick$1v(this.paddingLeft,t);return{width:this.width,height:this.height,x:this.bBox.x-r,y:this.bBox.y-t}},e.prototype.getCrispAdjust=function(){return this.renderer.styledMode&&this.box?this.box.strokeWidth()%2/2:(this["stroke-width"]?parseInt(this["stroke-width"],10):0)%2/2},e.prototype.heightSetter=function(t){this.heightSetting=t},e.prototype.onAdd=function(){var t=this.textStr;this.text.add(this),this.attr({text:defined$S(t)?t:"",x:this.x,y:this.y}),this.box&&defined$S(this.anchorX)&&this.attr({anchorX:this.anchorX,anchorY:this.anchorY})},e.prototype.paddingSetter=function(t,r){isNumber$L(t)?t!==this[r]&&(this[r]=t,this.updateTextPadding()):this[r]=void 0},e.prototype.rSetter=function(t,r){this.boxAttr(r,t)},e.prototype.shadow=function(t){return t&&!this.renderer.styledMode&&(this.updateBoxSize(),this.box&&this.box.shadow(t)),this},e.prototype.strokeSetter=function(t,r){this.stroke=t,this.boxAttr(r,t)},e.prototype["stroke-widthSetter"]=function(t,r){t&&(this.needsBox=!0),this["stroke-width"]=t,this.boxAttr(r,t)},e.prototype["text-alignSetter"]=function(t){this.textAlign=t},e.prototype.textSetter=function(t){typeof t<"u"&&this.text.attr({text:t}),this.updateTextPadding()},e.prototype.updateBoxSize=function(){var t=this.text.element.style,r={},o=this.padding,s=this.bBox=(!isNumber$L(this.widthSetting)||!isNumber$L(this.heightSetting)||this.textAlign)&&defined$S(this.text.textStr)?this.text.getBBox():e.emptyBBox,a;this.width=this.getPaddedWidth(),this.height=(this.heightSetting||s.height||0)+2*o;var l=this.renderer.fontMetrics(t&&t.fontSize,this.text);if(this.baselineOffset=o+Math.min((this.text.firstLineMetrics||l).b,s.height||1/0),this.heightSetting&&(this.baselineOffset+=(this.heightSetting-l.h)/2),this.needsBox){if(!this.box){var h=this.box=this.symbolKey?this.renderer.symbol(this.symbolKey):this.renderer.rect();h.addClass((this.className==="button"?"":"highcharts-label-box")+(this.className?" highcharts-"+this.className+"-box":"")),h.add(this)}a=this.getCrispAdjust(),r.x=a,r.y=(this.baseline?-this.baselineOffset:0)+a,r.width=Math.round(this.width),r.height=Math.round(this.height),this.box.attr(extend$1n(r,this.deferredAttr)),this.deferredAttr={}}},e.prototype.updateTextPadding=function(){var t=this.text;this.updateBoxSize();var r=this.baseline?0:this.baselineOffset,o=pick$1v(this.paddingLeft,this.padding);defined$S(this.widthSetting)&&this.bBox&&(this.textAlign==="center"||this.textAlign==="right")&&(o+={center:.5,right:1}[this.textAlign]*(this.widthSetting-this.bBox.width)),(o!==t.x||r!==t.y)&&(t.attr("x",o),t.hasBoxWidthChanged&&(this.bBox=t.getBBox(!0)),typeof r<"u"&&t.attr("y",r)),t.x=o,t.y=r},e.prototype.widthSetter=function(t){this.widthSetting=isNumber$L(t)?t:void 0},e.prototype.getPaddedWidth=function(){var t=this.padding,r=pick$1v(this.paddingLeft,t),o=pick$1v(this.paddingRight,t);return(this.widthSetting||this.bBox.width||0)+r+o},e.prototype.xSetter=function(t){this.x=t,this.alignFactor&&(t-=this.alignFactor*this.getPaddedWidth(),this["forceAnimate:x"]=!0),this.xSetting=Math.round(t),this.attr("translateX",this.xSetting)},e.prototype.ySetter=function(t){this.ySetting=this.y=Math.round(t),this.attr("translateY",this.ySetting)},e.emptyBBox={width:0,height:0,x:0,y:0},e.textProps=["color","direction","fontFamily","fontSize","fontStyle","fontWeight","lineHeight","textAlign","textDecoration","textOutline","textOverflow","width"],e}(SVGElement),defined$R=Utilities.defined,isNumber$K=Utilities.isNumber,pick$1u=Utilities.pick;function arc$1(n,e,t,r,o){var s=[];if(o){var a=o.start||0,l=pick$1u(o.r,t),h=pick$1u(o.r,r||t),d=.001,c=Math.abs((o.end||0)-a-2*Math.PI)<d,p=(o.end||0)-d,f=o.innerR,u=pick$1u(o.open,c),g=Math.cos(a),m=Math.sin(a),y=Math.cos(p),v=Math.sin(p),x=pick$1u(o.longArc,p-a-Math.PI<d?0:1);s.push(["M",n+l*g,e+h*m],["A",l,h,0,x,pick$1u(o.clockwise,1),n+l*y,e+h*v]),defined$R(f)&&s.push(u?["M",n+f*y,e+f*v]:["L",n+f*y,e+f*v],["A",f,f,0,x,defined$R(o.clockwise)?1-o.clockwise:0,n+f*g,e+f*m]),u||s.push(["Z"])}return s}function callout(n,e,t,r,o){var s=6,a=6,l=Math.min(o&&o.r||0,t,r),h=l+a,d=o&&o.anchorX,c=o&&o.anchorY||0,p=roundedRect(n,e,t,r,{r:l});return isNumber$K(d)&&(n+d>=t?c>e+h&&c<e+r-h?p.splice(3,1,["L",n+t,c-a],["L",n+t+s,c],["L",n+t,c+a],["L",n+t,e+r-l]):p.splice(3,1,["L",n+t,r/2],["L",d,c],["L",n+t,r/2],["L",n+t,e+r-l]):n+d<=0?c>e+h&&c<e+r-h?p.splice(7,1,["L",n,c+a],["L",n-s,c],["L",n,c-a],["L",n,e+l]):p.splice(7,1,["L",n,r/2],["L",d,c],["L",n,r/2],["L",n,e+l]):c&&c>r&&d>n+h&&d<n+t-h?p.splice(5,1,["L",d+a,e+r],["L",d,e+r+s],["L",d-a,e+r],["L",n+l,e+r]):c&&c<0&&d>n+h&&d<n+t-h&&p.splice(1,1,["L",d-a,e],["L",d,e-s],["L",d+a,e],["L",t-l,e])),p}function circle(n,e,t,r){return arc$1(n+t/2,e+r/2,t/2,r/2,{start:Math.PI*.5,end:Math.PI*2.5,open:!1})}function diamond(n,e,t,r){return[["M",n+t/2,e],["L",n+t,e+r/2],["L",n+t/2,e+r],["L",n,e+r/2],["Z"]]}function rect(n,e,t,r,o){return o&&o.r?roundedRect(n,e,t,r,o):[["M",n,e],["L",n+t,e],["L",n+t,e+r],["L",n,e+r],["Z"]]}function roundedRect(n,e,t,r,o){var s=o&&o.r||0;return[["M",n+s,e],["L",n+t-s,e],["C",n+t,e,n+t,e,n+t,e+s],["L",n+t,e+r-s],["C",n+t,e+r,n+t,e+r,n+t-s,e+r],["L",n+s,e+r],["C",n,e+r,n,e+r,n,e+r-s],["L",n,e+s],["C",n,e,n,e,n+s,e]]}function triangle(n,e,t,r){return[["M",n+t/2,e],["L",n+t,e+r],["L",n,e+r],["Z"]]}function triangleDown(n,e,t,r){return[["M",n,e],["L",n+t,e],["L",n+t/2,e+r],["Z"]]}var Symbols={arc:arc$1,callout,circle,diamond,rect,roundedRect,square:rect,triangle,"triangle-down":triangleDown},doc$k=H.doc,SVG_NS$1=H.SVG_NS,attr$5=Utilities.attr,isString$9=Utilities.isString,objectEach$v=Utilities.objectEach,pick$1t=Utilities.pick,TextBuilder=function(){function n(e){var t=e.styles;this.renderer=e.renderer,this.svgElement=e,this.width=e.textWidth,this.textLineHeight=t&&t.lineHeight,this.textOutline=t&&t.textOutline,this.ellipsis=!!(t&&t.textOverflow==="ellipsis"),this.noWrap=!!(t&&t.whiteSpace==="nowrap"),this.fontSize=t&&t.fontSize}return n.prototype.buildSVG=function(){var e=this.svgElement,t=e.element,r=e.renderer,o=pick$1t(e.textStr,"").toString(),s=o.indexOf("<")!==-1,a=t.childNodes,l=this.width&&!e.added&&r.box,h=/<br.*?>/g,d=[o,this.ellipsis,this.noWrap,this.textLineHeight,this.textOutline,this.fontSize,this.width].join(",");if(d!==e.textCache){e.textCache=d,delete e.actualWidth;for(var c=a.length;c--;)t.removeChild(a[c]);if(!s&&!this.ellipsis&&!this.width&&(o.indexOf(" ")===-1||this.noWrap&&!h.test(o)))t.appendChild(doc$k.createTextNode(this.unescapeEntities(o)));else if(o!==""){l&&l.appendChild(t);var p=new AST(o);this.modifyTree(p.nodes),p.addToDOM(e.element),this.modifyDOM(),this.ellipsis&&(t.textContent||"").indexOf("…")!==-1&&e.attr("title",this.unescapeEntities(e.textStr||"",["&lt;","&gt;"])),l&&l.removeChild(t)}isString$9(this.textOutline)&&e.applyTextOutline&&e.applyTextOutline(this.textOutline)}},n.prototype.modifyDOM=function(){var e=this,t=this.svgElement,r=attr$5(t.element,"x");t.firstLineMetrics=void 0;for(var o;(o=t.element.firstChild)&&/^[\s\u200B]*$/.test(o.textContent||" ");)t.element.removeChild(o);[].forEach.call(t.element.querySelectorAll("tspan.highcharts-br"),function(h,d){h.nextSibling&&h.previousSibling&&(d===0&&h.previousSibling.nodeType===1&&(t.firstLineMetrics=t.renderer.fontMetrics(void 0,h.previousSibling)),attr$5(h,{dy:e.getLineHeight(h.nextSibling),x:r}))});var s=this.width||0;if(s){var a=function(h,d){var c=h.textContent||"",p=c.replace(/([^\^])-/g,"$1- ").split(" "),f=!e.noWrap&&(p.length>1||t.element.childNodes.length>1),u=e.getLineHeight(d),g=0,m=t.actualWidth;if(e.ellipsis)c&&e.truncate(h,c,void 0,0,Math.max(0,s-parseInt(e.fontSize||12,10)),function(x,b){return x.substring(0,b)+"…"});else if(f){for(var y=[],v=[];d.firstChild&&d.firstChild!==h;)v.push(d.firstChild),d.removeChild(d.firstChild);for(;p.length;)p.length&&!e.noWrap&&g>0&&(y.push(h.textContent||""),h.textContent=p.join(" ").replace(/- /g,"-")),e.truncate(h,void 0,p,g===0&&m||0,s,function(x,b){return p.slice(0,b).join(" ").replace(/- /g,"-")}),m=t.actualWidth,g++;v.forEach(function(x){d.insertBefore(x,h)}),y.forEach(function(x){d.insertBefore(doc$k.createTextNode(x),h);var b=doc$k.createElementNS(SVG_NS$1,"tspan");b.textContent="​",attr$5(b,{dy:u,x:r}),d.insertBefore(b,h)})}},l=function(h){var d=[].slice.call(h.childNodes);d.forEach(function(c){c.nodeType===Node.TEXT_NODE?a(c,h):(c.className.baseVal.indexOf("highcharts-br")!==-1&&(t.actualWidth=0),l(c))})};l(t.element)}},n.prototype.getLineHeight=function(e){var t,r=e.nodeType===Node.TEXT_NODE?e.parentElement:e;return this.renderer.styledMode||(t=r&&/(px|em)$/.test(r.style.fontSize)?r.style.fontSize:this.fontSize||this.renderer.style.fontSize||12),this.textLineHeight?parseInt(this.textLineHeight.toString(),10):this.renderer.fontMetrics(t,r||this.svgElement.element).h},n.prototype.modifyTree=function(e){var t=this,r=function(o,s){var a=o.tagName,l=t.renderer.styledMode,h=o.attributes||{};if(a==="b"||a==="strong"?l?h.class="highcharts-strong":h.style="font-weight:bold;"+(h.style||""):(a==="i"||a==="em")&&(l?h.class="highcharts-emphasized":h.style="font-style:italic;"+(h.style||"")),isString$9(h.style)&&(h.style=h.style.replace(/(;| |^)color([ :])/,"$1fill$2")),a==="br"){h.class="highcharts-br",o.textContent="​";var d=e[s+1];d&&d.textContent&&(d.textContent=d.textContent.replace(/^ +/gm,""))}a!=="#text"&&a!=="a"&&(o.tagName="tspan"),o.attributes=h,o.children&&o.children.filter(function(c){return c.tagName!=="#text"}).forEach(r)};e.forEach(r)},n.prototype.truncate=function(e,t,r,o,s,a){var l=this.svgElement,h=l.renderer,d=l.rotation,c=[],p=r?1:0,f=(t||r||"").length,u=f,g,m,y=function(v,x){var b=x||v,$=e.parentNode;if($&&typeof c[b]>"u")if($.getSubStringLength)try{c[b]=o+$.getSubStringLength(0,r?b+1:b)}catch{}else h.getSpanWidth&&(e.textContent=a(t||r,v),c[b]=o+h.getSpanWidth(l,e));return c[b]};if(l.rotation=0,m=y(e.textContent.length),o+m>s){for(;p<=f;)u=Math.ceil((p+f)/2),r&&(g=a(r,u)),m=y(u,g&&g.length-1),p===f?p=f+1:m>s?f=u-1:p=u;f===0?e.textContent="":t&&f===t.length-1||(e.textContent=g||a(t||r,u))}r&&r.splice(0,u),l.actualWidth=m,l.rotation=d},n.prototype.unescapeEntities=function(e,t){return objectEach$v(this.renderer.escapes,function(r,o){(!t||t.indexOf(r)===-1)&&(e=e.toString().replace(new RegExp(r,"g"),o))}),e},n}(),charts$4=H.charts,deg2rad$7=H.deg2rad,doc$j=H.doc,isFirefox$3=H.isFirefox,isMS$2=H.isMS,isWebKit$1=H.isWebKit,noop$k=H.noop,SVG_NS=H.SVG_NS,symbolSizes=H.symbolSizes,win$c=H.win,addEvent$10=Utilities.addEvent,attr$4=Utilities.attr,createElement$8=Utilities.createElement,css$b=Utilities.css,defined$Q=Utilities.defined,destroyObjectProperties$9=Utilities.destroyObjectProperties,extend$1m=Utilities.extend,isArray$k=Utilities.isArray,isNumber$J=Utilities.isNumber,isObject$c=Utilities.isObject,isString$8=Utilities.isString,merge$1i=Utilities.merge,pick$1s=Utilities.pick,pInt$6=Utilities.pInt,uniqueKey$6=Utilities.uniqueKey,hasInternalReferenceBug,SVGRenderer=function(){function n(e,t,r,o,s,a,l){this.alignedObjects=void 0,this.box=void 0,this.boxWrapper=void 0,this.cache=void 0,this.cacheKeys=void 0,this.chartIndex=void 0,this.defs=void 0,this.globalAnimation=void 0,this.gradients=void 0,this.height=void 0,this.imgCount=void 0,this.isSVG=void 0,this.style=void 0,this.url=void 0,this.width=void 0,this.init(e,t,r,o,s,a,l)}return n.prototype.init=function(e,t,r,o,s,a,l){var h=this,d=h.createElement("svg").attr({version:"1.1",class:"highcharts-root"}),c=d.element;l||d.css(this.getStyle(o)),e.appendChild(c),attr$4(e,"dir","ltr"),e.innerHTML.indexOf("xmlns")===-1&&attr$4(c,"xmlns",this.SVG_NS),h.isSVG=!0,this.box=c,this.boxWrapper=d,h.alignedObjects=[],this.url=this.getReferenceURL();var p=this.createElement("desc").add();p.element.appendChild(doc$j.createTextNode("Created with Highcharts 9.2.2")),h.defs=this.createElement("defs").add(),h.allowHTML=a,h.forExport=s,h.styledMode=l,h.gradients={},h.cache={},h.cacheKeys=[],h.imgCount=0,h.setSize(t,r,!1);var f,u;isFirefox$3&&e.getBoundingClientRect&&(f=function(){css$b(e,{left:0,top:0}),u=e.getBoundingClientRect(),css$b(e,{left:Math.ceil(u.left)-u.left+"px",top:Math.ceil(u.top)-u.top+"px"})},f(),h.unSubPixelFix=addEvent$10(win$c,"resize",f))},n.prototype.definition=function(e){var t=new AST([e]);return t.addToDOM(this.defs.element)},n.prototype.getReferenceURL=function(){if((isFirefox$3||isWebKit$1)&&doc$j.getElementsByTagName("base").length){if(!defined$Q(hasInternalReferenceBug)){var e=uniqueKey$6(),t=new AST([{tagName:"svg",attributes:{width:8,height:8},children:[{tagName:"defs",children:[{tagName:"clipPath",attributes:{id:e},children:[{tagName:"rect",attributes:{width:4,height:4}}]}]},{tagName:"rect",attributes:{id:"hitme",width:8,height:8,"clip-path":"url(#"+e+")",fill:"rgba(0,0,0,0.001)"}}]}]),r=t.addToDOM(doc$j.body);css$b(r,{position:"fixed",top:0,left:0,zIndex:9e5});var o=doc$j.elementFromPoint(6,6);hasInternalReferenceBug=(o&&o.id)==="hitme",doc$j.body.removeChild(r)}if(hasInternalReferenceBug)return win$c.location.href.split("#")[0].replace(/<[^>]*>/g,"").replace(/([\('\)])/g,"\\$1").replace(/ /g,"%20")}return""},n.prototype.getStyle=function(e){return this.style=extend$1m({fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',fontSize:"12px"},e),this.style},n.prototype.setStyle=function(e){this.boxWrapper.css(this.getStyle(e))},n.prototype.isHidden=function(){return!this.boxWrapper.getBBox().width},n.prototype.destroy=function(){var e=this,t=e.defs;return e.box=null,e.boxWrapper=e.boxWrapper.destroy(),destroyObjectProperties$9(e.gradients||{}),e.gradients=null,t&&(e.defs=t.destroy()),e.unSubPixelFix&&e.unSubPixelFix(),e.alignedObjects=null,null},n.prototype.createElement=function(e){var t=new this.Element;return t.init(this,e),t},n.prototype.getRadialAttr=function(e,t){return{cx:e[0]-e[2]/2+(t.cx||0)*e[2],cy:e[1]-e[2]/2+(t.cy||0)*e[2],r:(t.r||0)*e[2]}},n.prototype.buildText=function(e){new TextBuilder(e).buildSVG()},n.prototype.getContrast=function(e){return e=Color.parse(e).rgba,e[0]*=1,e[1]*=1.2,e[2]*=.5,e[0]+e[1]+e[2]>1.8*255?"#000000":"#FFFFFF"},n.prototype.button=function(e,t,r,o,s,a,l,h,d,c){var p=this.label(e,t,r,d,void 0,void 0,c,void 0,"button"),f=this.styledMode,u=0,g=s?merge$1i(s):{},m=g&&g.style||{};g=AST.filterUserAttributes(g),p.attr(merge$1i({padding:8,r:2},g));var y,v,x,b;return f||(g=merge$1i({fill:palette.neutralColor3,stroke:palette.neutralColor20,"stroke-width":1,style:{color:palette.neutralColor80,cursor:"pointer",fontWeight:"normal"}},{style:m},g),y=g.style,delete g.style,a=merge$1i(g,{fill:palette.neutralColor10},AST.filterUserAttributes(a||{})),v=a.style,delete a.style,l=merge$1i(g,{fill:palette.highlightColor10,style:{color:palette.neutralColor100,fontWeight:"bold"}},AST.filterUserAttributes(l||{})),x=l.style,delete l.style,h=merge$1i(g,{style:{color:palette.neutralColor20}},AST.filterUserAttributes(h||{})),b=h.style,delete h.style),addEvent$10(p.element,isMS$2?"mouseover":"mouseenter",function(){u!==3&&p.setState(1)}),addEvent$10(p.element,isMS$2?"mouseout":"mouseleave",function(){u!==3&&p.setState(u)}),p.setState=function($){$!==1&&(p.state=u=$),p.removeClass(/highcharts-button-(normal|hover|pressed|disabled)/).addClass("highcharts-button-"+["normal","hover","pressed","disabled"][$||0]),f||p.attr([g,a,l,h][$||0]).css([y,v,x,b][$||0])},f||p.attr(g).css(extend$1m({cursor:"default"},y)),p.on("touchstart",function($){return $.stopPropagation()}).on("click",function($){u!==3&&o.call(p,$)})},n.prototype.crispLine=function(e,t,r){r===void 0&&(r="round");var o=e[0],s=e[1];return defined$Q(o[1])&&o[1]===s[1]&&(o[1]=s[1]=Math[r](o[1])-t%2/2),defined$Q(o[2])&&o[2]===s[2]&&(o[2]=s[2]=Math[r](o[2])+t%2/2),e},n.prototype.path=function(e){var t=this.styledMode?{}:{fill:"none"};return isArray$k(e)?t.d=e:isObject$c(e)&&extend$1m(t,e),this.createElement("path").attr(t)},n.prototype.circle=function(e,t,r){var o=isObject$c(e)?e:typeof e>"u"?{}:{x:e,y:t,r},s=this.createElement("circle");return s.xSetter=s.ySetter=function(a,l,h){h.setAttribute("c"+l,a)},s.attr(o)},n.prototype.arc=function(e,t,r,o,s,a){var l;isObject$c(e)?(l=e,t=l.y,r=l.r,o=l.innerR,s=l.start,a=l.end,e=l.x):l={innerR:o,start:s,end:a};var h=this.symbol("arc",e,t,r,r,l);return h.r=r,h},n.prototype.rect=function(e,t,r,o,s,a){s=isObject$c(e)?e.r:s;var l=this.createElement("rect"),h=isObject$c(e)?e:typeof e>"u"?{}:{x:e,y:t,width:Math.max(r,0),height:Math.max(o,0)};return this.styledMode||(typeof a<"u"&&(h["stroke-width"]=a,h=l.crisp(h)),h.fill="none"),s&&(h.r=s),l.rSetter=function(d,c,p){l.r=d,attr$4(p,{rx:d,ry:d})},l.rGetter=function(){return l.r||0},l.attr(h)},n.prototype.setSize=function(e,t,r){var o=this;o.width=e,o.height=t,o.boxWrapper.animate({width:e,height:t},{step:function(){this.attr({viewBox:"0 0 "+this.attr("width")+" "+this.attr("height")})},duration:pick$1s(r,!0)?void 0:0}),o.alignElements()},n.prototype.g=function(e){var t=this.createElement("g");return e?t.attr({class:"highcharts-"+e}):t},n.prototype.image=function(e,t,r,o,s,a){var l={preserveAspectRatio:"none"},h=function(f,u){f.setAttributeNS?f.setAttributeNS("http://www.w3.org/1999/xlink","href",u):f.setAttribute("hc-svg-href",u)};arguments.length>1&&extend$1m(l,{x:t,y:r,width:o,height:s});var d=this.createElement("image").attr(l),c=function(f){h(d.element,e),a.call(d,f)};if(a){h(d.element,"data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==");var p=new win$c.Image;addEvent$10(p,"load",c),p.src=e,p.complete&&c({})}else h(d.element,e);return d},n.prototype.symbol=function(e,t,r,o,s,a){var l=this,h=/^url\((.*?)\)$/,d=h.test(e),c=!d&&(this.symbols[e]?e:"circle"),p=c&&this.symbols[c],f,u,g,m;if(p)typeof t=="number"&&(u=p.call(this.symbols,Math.round(t||0),Math.round(r||0),o||0,s||0,a)),f=this.path(u),l.styledMode||f.attr("fill","none"),extend$1m(f,{symbolName:c||void 0,x:t,y:r,width:o,height:s}),a&&extend$1m(f,a);else if(d){g=e.match(h)[1];var y=f=this.image(g);y.imgwidth=pick$1s(symbolSizes[g]&&symbolSizes[g].width,a&&a.width),y.imgheight=pick$1s(symbolSizes[g]&&symbolSizes[g].height,a&&a.height),m=function(v){return v.attr({width:v.width,height:v.height})},["width","height"].forEach(function(v){y[v+"Setter"]=function(x,b){var $=this["img"+b];if(this[b]=x,defined$Q($)&&(a&&a.backgroundSize==="within"&&this.width&&this.height&&($=Math.round($*Math.min(this.width/this.imgwidth,this.height/this.imgheight))),this.element&&this.element.setAttribute(b,$),!this.alignByTranslate)){var S=((this[b]||0)-$)/2,k=b==="width"?{translateX:S}:{translateY:S};this.attr(k)}}}),defined$Q(t)&&y.attr({x:t,y:r}),y.isImg=!0,defined$Q(y.imgwidth)&&defined$Q(y.imgheight)?m(y):(y.attr({width:0,height:0}),createElement$8("img",{onload:function(){var v=charts$4[l.chartIndex];this.width===0&&(css$b(this,{position:"absolute",top:"-999em"}),doc$j.body.appendChild(this)),symbolSizes[g]={width:this.width,height:this.height},y.imgwidth=this.width,y.imgheight=this.height,y.element&&m(y),this.parentNode&&this.parentNode.removeChild(this),l.imgCount--,!l.imgCount&&v&&!v.hasLoaded&&v.onload()},src:g}),this.imgCount++)}return f},n.prototype.clipRect=function(e,t,r,o){var s=uniqueKey$6()+"-",a=this.createElement("clipPath").attr({id:s}).add(this.defs),l=this.rect(e,t,r,o,0).add(a);return l.id=s,l.clipPath=a,l.count=0,l},n.prototype.text=function(e,t,r,o){var s=this,a={};if(o&&(s.allowHTML||!s.forExport))return s.html(e,t,r);a.x=Math.round(t||0),r&&(a.y=Math.round(r)),defined$Q(e)&&(a.text=e);var l=s.createElement("text").attr(a);return(!o||s.forExport&&!s.allowHTML)&&(l.xSetter=function(h,d,c){for(var p=c.getElementsByTagName("tspan"),f=c.getAttribute(d),u=0,g=void 0;u<p.length;u++)g=p[u],g.getAttribute(d)===f&&g.setAttribute(d,h);c.setAttribute(d,h)}),l},n.prototype.fontMetrics=function(e,t){(this.styledMode||!/px/.test(e))&&win$c.getComputedStyle?e=t&&SVGElement.prototype.getStyle.call(t,"font-size"):e=e||t&&t.style&&t.style.fontSize||this.style&&this.style.fontSize,/px/.test(e)?e=pInt$6(e):e=12;var r=e<24?e+3:Math.round(e*1.2),o=Math.round(r*.8);return{h:r,b:o,f:e}},n.prototype.rotCorr=function(e,t,r){var o=e;return t&&r&&(o=Math.max(o*Math.cos(t*deg2rad$7),4)),{x:-e/3*Math.sin(t*deg2rad$7),y:o}},n.prototype.pathToSegments=function(e){for(var t=[],r=[],o={A:8,C:7,H:2,L:3,M:3,Q:5,S:5,T:3,V:2},s=0;s<e.length;s++)isString$8(r[0])&&isNumber$J(e[s])&&r.length===o[r[0].toUpperCase()]&&e.splice(s,0,r[0].replace("M","L").replace("m","l")),typeof e[s]=="string"&&(r.length&&t.push(r.slice(0)),r.length=0),r.push(e[s]);return t.push(r.slice(0)),t},n.prototype.label=function(e,t,r,o,s,a,l,h,d){return new SVGLabel(this,e,t,r,o,s,a,l,h,d)},n.prototype.alignElements=function(){this.alignedObjects.forEach(function(e){return e.align()})},n}();extend$1m(SVGRenderer.prototype,{Element:SVGElement,SVG_NS,escapes:{"&":"&amp;","<":"&lt;",">":"&gt;","'":"&#39;",'"':"&quot;"},symbols:Symbols,draw:noop$k});RendererRegistry$1.registerRendererType("svg",SVGRenderer,!0);var __extends$X=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),isFirefox$2=H.isFirefox,isMS$1=H.isMS,isWebKit=H.isWebKit,win$b=H.win,css$a=Utilities.css,defined$P=Utilities.defined,extend$1l=Utilities.extend,pick$1r=Utilities.pick,pInt$5=Utilities.pInt,HTMLElement=function(n){__extends$X(e,n);function e(){return n!==null&&n.apply(this,arguments)||this}return e.compose=function(t){if(e.composedClasses.indexOf(t)===-1){e.composedClasses.push(t);var r=e.prototype,o=t.prototype;o.getSpanCorrection=r.getSpanCorrection,o.htmlCss=r.htmlCss,o.htmlGetBBox=r.htmlGetBBox,o.htmlUpdateTransform=r.htmlUpdateTransform,o.setSpanRotation=r.setSpanRotation}return t},e.prototype.getSpanCorrection=function(t,r,o){this.xCorr=-t*o,this.yCorr=-r},e.prototype.htmlCss=function(t){var r=this,o=r.element,s=o.tagName==="SPAN"&&t&&"width"in t,a=pick$1r(s&&t.width,void 0),l;return s&&(delete t.width,r.textWidth=a,l=!0),t&&t.textOverflow==="ellipsis"&&(t.whiteSpace="nowrap",t.overflow="hidden"),r.styles=extend$1l(r.styles,t),css$a(r.element,t),l&&r.htmlUpdateTransform(),r},e.prototype.htmlGetBBox=function(){var t=this,r=t.element;return{x:r.offsetLeft,y:r.offsetTop,width:r.offsetWidth,height:r.offsetHeight}},e.prototype.htmlUpdateTransform=function(){if(!this.added){this.alignOnAdd=!0;return}var t=this,r=t.renderer,o=t.element,s=t.translateX||0,a=t.translateY||0,l=t.x||0,h=t.y||0,d=t.textAlign||"left",c={left:0,center:.5,right:1}[d],p=t.styles,f=p&&p.whiteSpace;function u(){return css$a(o,{width:"",whiteSpace:f||"nowrap"}),o.offsetWidth}if(css$a(o,{marginLeft:s,marginTop:a}),!r.styledMode&&t.shadows&&t.shadows.forEach(function(x){css$a(x,{marginLeft:s+1,marginTop:a+1})}),t.inverted&&[].forEach.call(o.childNodes,function(x){r.invertChild(x,o)}),o.tagName==="SPAN"){var g=t.rotation,m=t.textWidth&&pInt$5(t.textWidth),y=[g,d,o.innerHTML,t.textWidth,t.textAlign].join(","),v=void 0;m!==t.oldTextWidth&&(m>t.oldTextWidth||(t.textPxLength||u())>m)&&(/[ \-]/.test(o.textContent||o.innerText)||o.style.textOverflow==="ellipsis")?(css$a(o,{width:m+"px",display:"block",whiteSpace:f||"normal"}),t.oldTextWidth=m,t.hasBoxWidthChanged=!0):t.hasBoxWidthChanged=!1,y!==t.cTT&&(v=r.fontMetrics(o.style.fontSize,o).b,defined$P(g)&&(g!==(t.oldRotation||0)||d!==t.oldAlign)&&t.setSpanRotation(g,c,v),t.getSpanCorrection(!defined$P(g)&&t.textPxLength||o.offsetWidth,v,c,g,d)),css$a(o,{left:l+(t.xCorr||0)+"px",top:h+(t.yCorr||0)+"px"}),t.cTT=y,t.oldRotation=g,t.oldAlign=d}},e.prototype.setSpanRotation=function(t,r,o){var s=function(){return isMS$1&&!/Edge/.test(win$b.navigator.userAgent)?"-ms-transform":isWebKit?"-webkit-transform":isFirefox$2?"MozTransform":win$b.opera?"-o-transform":void 0},a={},l=s();l&&(a[l]=a.transform="rotate("+t+"deg)",a[l+(isFirefox$2?"Origin":"-origin")]=a.transformOrigin=r*100+"% "+o+"px",css$a(this.element,a))},e.composedClasses=[],e}(SVGElement),__extends$W=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),attr$3=Utilities.attr,createElement$7=Utilities.createElement,extend$1k=Utilities.extend,pick$1q=Utilities.pick,HTMLRenderer=function(n){__extends$W(e,n);function e(){return n!==null&&n.apply(this,arguments)||this}return e.compose=function(t){if(e.composedClasses.indexOf(t)===-1){e.composedClasses.push(t);var r=e.prototype,o=t.prototype;o.html=r.html}return t},e.prototype.html=function(t,r,o){var s=this.createElement("span"),a=s.element,l=s.renderer,h=l.isSVG,d=function(c,p){["opacity","visibility"].forEach(function(f){c[f+"Setter"]=function(u,g,m){var y=c.div?c.div.style:p;SVGElement.prototype[f+"Setter"].call(this,u,g,m),y&&(y[g]=u)}}),c.addedSetters=!0};return s.textSetter=function(c){c!==this.textStr&&(delete this.bBox,delete this.oldTextWidth,AST.setElementHTML(this.element,pick$1q(c,"")),this.textStr=c,s.doTransform=!0)},h&&d(s,s.element.style),s.xSetter=s.ySetter=s.alignSetter=s.rotationSetter=function(c,p){p==="align"?s.alignValue=s.textAlign=c:s[p]=c,s.doTransform=!0},s.afterSetters=function(){this.doTransform&&(this.htmlUpdateTransform(),this.doTransform=!1)},s.attr({text:t,x:Math.round(r),y:Math.round(o)}).css({position:"absolute"}),l.styledMode||s.css({fontFamily:this.style.fontFamily,fontSize:this.style.fontSize}),a.style.whiteSpace="nowrap",s.css=s.htmlCss,h&&(s.add=function(c){var p=l.box.parentNode,f=[],u,g;if(this.parentGroup=c,c){if(u=c.div,!u){for(g=c;g;)f.push(g),g=g.parentGroup;f.reverse().forEach(function(m){var y=attr$3(m.element,"class");function v($,S){m[S]=$,S==="translateX"?b.left=$+"px":b.top=$+"px",m.doTransform=!0}var x=m.styles||{};u=m.div=m.div||createElement$7("div",y?{className:y}:void 0,{position:"absolute",left:(m.translateX||0)+"px",top:(m.translateY||0)+"px",display:m.display,opacity:m.opacity,cursor:x.cursor,pointerEvents:x.pointerEvents,visibility:m.visibility},u||p);var b=u.style;extend$1k(m,{classSetter:function($){return function(S){this.element.setAttribute("class",S),$.className=S}}(u),on:function(){return f[0].div&&s.on.apply({element:f[0].div,onEvents:m.onEvents},arguments),m},translateXSetter:v,translateYSetter:v}),m.addedSetters||d(m)})}}else u=p;return u.appendChild(a),s.added=!0,s.alignOnAdd&&s.htmlUpdateTransform(),s}),s},e.composedClasses=[],e}(SVGRenderer),AxisDefaults;(function(n){n.defaultXAxisOptions={alignTicks:!0,allowDecimals:void 0,panningEnabled:!0,zIndex:2,zoomEnabled:!0,dateTimeLabelFormats:{millisecond:{main:"%H:%M:%S.%L",range:!1},second:{main:"%H:%M:%S",range:!1},minute:{main:"%H:%M",range:!1},hour:{main:"%H:%M",range:!1},day:{main:"%e. %b"},week:{main:"%e. %b"},month:{main:"%b '%y"},year:{main:"%Y"}},endOnTick:!1,gridLineDashStyle:"Solid",gridZIndex:1,labels:{autoRotation:void 0,autoRotationLimit:80,distance:void 0,enabled:!0,indentation:10,overflow:"justify",padding:5,reserveSpace:void 0,rotation:void 0,staggerLines:0,step:0,useHTML:!1,x:0,zIndex:7,style:{color:palette.neutralColor60,cursor:"default",fontSize:"11px"}},maxPadding:.01,minorGridLineDashStyle:"Solid",minorTickLength:2,minorTickPosition:"outside",minPadding:.01,offset:void 0,opposite:!1,reversed:void 0,reversedStacks:!1,showEmpty:!0,showFirstLabel:!0,showLastLabel:!0,startOfWeek:1,startOnTick:!1,tickLength:10,tickPixelInterval:100,tickmarkPlacement:"between",tickPosition:"outside",title:{align:"middle",rotation:0,useHTML:!1,x:0,y:0,style:{color:palette.neutralColor60}},type:"linear",uniqueNames:!0,visible:!0,minorGridLineColor:palette.neutralColor5,minorGridLineWidth:1,minorTickColor:palette.neutralColor40,lineColor:palette.highlightColor20,lineWidth:1,gridLineColor:palette.neutralColor10,gridLineWidth:void 0,tickColor:palette.highlightColor20},n.defaultYAxisOptions={reversedStacks:!0,endOnTick:!0,maxPadding:.05,minPadding:.05,tickPixelInterval:72,showLastLabel:!0,labels:{x:-8},startOnTick:!0,title:{rotation:270,text:"Values"},stackLabels:{animation:{},allowOverlap:!1,enabled:!1,crop:!0,overflow:"justify",formatter:function(){var e=this.axis.chart.numberFormatter;return e(this.total,-1)},style:{color:palette.neutralColor100,fontSize:"11px",fontWeight:"bold",textOutline:"1px contrast"}},gridLineWidth:1,lineWidth:0},n.defaultLeftAxisOptions={labels:{x:-15},title:{rotation:270}},n.defaultRightAxisOptions={labels:{x:15},title:{rotation:90}},n.defaultBottomAxisOptions={labels:{autoRotation:[-45],x:0},margin:15,title:{rotation:0}},n.defaultTopAxisOptions={labels:{autoRotation:[-45],x:0},margin:15,title:{rotation:0}}})(AxisDefaults||(AxisDefaults={}));const AxisDefaults$1=AxisDefaults;var addEvent$$=Utilities.addEvent,isFunction$3=Utilities.isFunction,objectEach$u=Utilities.objectEach,removeEvent$a=Utilities.removeEvent,registerEventOptions$3=function(n,e){n.eventOptions=n.eventOptions||{},objectEach$u(e.events,function(t,r){n.eventOptions[r]!==t&&(n.eventOptions[r]&&(removeEvent$a(n,r,n.eventOptions[r]),delete n.eventOptions[r]),isFunction$3(t)&&(n.eventOptions[r]=t,addEvent$$(n,r,t)))})},exports$3={registerEventOptions:registerEventOptions$3},deg2rad$6=H.deg2rad,clamp$h=Utilities.clamp,correctFloat$c=Utilities.correctFloat,defined$O=Utilities.defined,destroyObjectProperties$8=Utilities.destroyObjectProperties,extend$1j=Utilities.extend,fireEvent$z=Utilities.fireEvent,isNumber$I=Utilities.isNumber,merge$1h=Utilities.merge,objectEach$t=Utilities.objectEach,pick$1p=Utilities.pick,Tick=function(){function n(e,t,r,o,s){this.isNew=!0,this.isNewLabel=!0,this.axis=e,this.pos=t,this.type=r||"",this.parameters=s||{},this.tickmarkOffset=this.parameters.tickmarkOffset,this.options=this.parameters.options,fireEvent$z(this,"init"),!r&&!o&&this.addLabel()}return n.prototype.addLabel=function(){var e=this,t=e.axis,r=t.options,o=t.chart,s=t.categories,a=t.logarithmic,l=t.names,h=e.pos,d=pick$1p(e.options&&e.options.labels,r.labels),c=t.tickPositions,p=h===c[0],f=h===c[c.length-1],u=(!d.step||d.step===1)&&t.tickInterval===1,g=c.info,m=e.label,y,v,x,b=this.parameters.category||(s?pick$1p(s[h],l[h],h):h);a&&isNumber$I(b)&&(b=correctFloat$c(a.lin2log(b))),t.dateTime&&(g?(v=o.time.resolveDTLFormat(r.dateTimeLabelFormats[!r.grid&&g.higherRanks[h]||g.unitName]),y=v.main):isNumber$I(b)&&(y=t.dateTime.getXDateFormat(b,r.dateTimeLabelFormats||{}))),e.isFirst=p,e.isLast=f;var $={axis:t,chart:o,dateTimeLabelFormat:y,isFirst:p,isLast:f,pos:h,tick:e,tickPositionInfo:g,value:b};fireEvent$z(this,"labelFormat",$);var S=function(M){return d.formatter?d.formatter.call(M,M):d.format?(M.text=t.defaultLabelFormatter.call(M),FormatUtilities.format(d.format,M,o)):t.defaultLabelFormatter.call(M,M)},k=S.call($,$),A=v&&v.list;A?e.shortenLabel=function(){for(x=0;x<A.length;x++)if(extend$1j($,{dateTimeLabelFormat:A[x]}),m.attr({text:S.call($,$)}),m.getBBox().width<t.getSlotWidth(e)-2*d.padding)return;m.attr({text:""})}:e.shortenLabel=void 0,u&&t._addedPlotLB&&e.moveLabel(k,d),!defined$O(m)&&!e.movedLabel?(e.label=m=e.createLabel({x:0,y:0},k,d),e.rotation=0):m&&m.textStr!==k&&!u&&(m.textWidth&&!d.style.width&&!m.styles.width&&m.css({width:null}),m.attr({text:k}),m.textPxLength=m.getBBox().width)},n.prototype.createLabel=function(e,t,r){var o=this.axis,s=o.chart,a=defined$O(t)&&r.enabled?s.renderer.text(t,e.x,e.y,r.useHTML).add(o.labelGroup):null;return a&&(s.styledMode||a.css(merge$1h(r.style)),a.textPxLength=a.getBBox().width),a},n.prototype.destroy=function(){destroyObjectProperties$8(this,this.axis)},n.prototype.getPosition=function(e,t,r,o){var s=this.axis,a=s.chart,l=o&&a.oldChartHeight||a.chartHeight,h={x:e?correctFloat$c(s.translate(t+r,null,null,o)+s.transB):s.left+s.offset+(s.opposite?(o&&a.oldChartWidth||a.chartWidth)-s.right-s.left:0),y:e?l-s.bottom+s.offset-(s.opposite?s.height:0):correctFloat$c(l-s.translate(t+r,null,null,o)-s.transB)};return h.y=clamp$h(h.y,-1e5,1e5),fireEvent$z(this,"afterGetPosition",{pos:h}),h},n.prototype.getLabelPosition=function(e,t,r,o,s,a,l,h){var d=this.axis,c=d.transA,p=d.isLinked&&d.linkedParent?d.linkedParent.reversed:d.reversed,f=d.staggerLines,u=d.tickRotCorr||{x:0,y:0},g=!o&&!d.reserveSpaceDefault?-d.labelOffset*(d.labelAlign==="center"?.5:1):0,m={},y=s.y,v;return defined$O(y)||(d.side===0?y=r.rotation?-8:-r.getBBox().height:d.side===2?y=u.y+8:y=Math.cos(r.rotation*deg2rad$6)*(u.y-r.getBBox(!1,0).height/2)),e=e+s.x+g+u.x-(a&&o?a*c*(p?-1:1):0),t=t+y-(a&&!o?a*c*(p?1:-1):0),f&&(v=l/(h||1)%f,d.opposite&&(v=f-v-1),t+=v*(d.labelOffset/f)),m.x=e,m.y=Math.round(t),fireEvent$z(this,"afterGetLabelPosition",{pos:m,tickmarkOffset:a,index:l}),m},n.prototype.getLabelSize=function(){return this.label?this.label.getBBox()[this.axis.horiz?"height":"width"]:0},n.prototype.getMarkPath=function(e,t,r,o,s,a){return a.crispLine([["M",e,t],["L",e+(s?0:-r),t+(s?r:0)]],o)},n.prototype.handleOverflow=function(e){var t=this,r=this.axis,o=r.options.labels,s=e.x,a=r.chart.chartWidth,l=r.chart.spacing,h=pick$1p(r.labelLeft,Math.min(r.pos,l[3])),d=pick$1p(r.labelRight,Math.max(r.isRadial?0:r.pos+r.len,a-l[1])),c=this.label,p=this.rotation,f={left:0,center:.5,right:1}[r.labelAlign||c.attr("align")],u=c.getBBox().width,g=r.getSlotWidth(t),m=f,y={},v=g,x=1,b,$,S;!p&&o.overflow==="justify"?(b=s-f*u,$=s+(1-f)*u,b<h?v=e.x+v*(1-f)-h:$>d&&(v=d-e.x+v*f,x=-1),v=Math.min(g,v),v<g&&r.labelAlign==="center"&&(e.x+=x*(g-v-m*(g-Math.min(u,v)))),(u>v||r.autoRotation&&(c.styles||{}).width)&&(S=v)):p<0&&s-f*u<h?S=Math.round(s/Math.cos(p*deg2rad$6)-h):p>0&&s+f*u>d&&(S=Math.round((a-s)/Math.cos(p*deg2rad$6))),S&&(t.shortenLabel?t.shortenLabel():(y.width=Math.floor(S)+"px",(o.style||{}).textOverflow||(y.textOverflow="ellipsis"),c.css(y)))},n.prototype.moveLabel=function(e,t){var r=this,o=r.label,s=r.axis,a=s.reversed,l=!1,h,d,c;o&&o.textStr===e?(r.movedLabel=o,l=!0,delete r.label):objectEach$t(s.ticks,function(p){!l&&!p.isNew&&p!==r&&p.label&&p.label.textStr===e&&(r.movedLabel=p.label,l=!0,p.labelPos=r.movedLabel.xy,delete p.label)}),!l&&(r.labelPos||o)&&(h=r.labelPos||o.xy,d=s.horiz?a?0:s.width+s.left:h.x,c=s.horiz?h.y:a?s.width+s.left:0,r.movedLabel=r.createLabel({x:d,y:c},e,t),r.movedLabel&&r.movedLabel.attr({opacity:0}))},n.prototype.render=function(e,t,r){var o=this,s=o.axis,a=s.horiz,l=o.pos,h=pick$1p(o.tickmarkOffset,s.tickmarkOffset),d=o.getPosition(a,l,h,t),c=d.x,p=d.y,f=a&&c===s.pos+s.len||!a&&p===s.pos?-1:1,u=pick$1p(r,o.label&&o.label.newOpacity,1);r=pick$1p(r,1),this.isActive=!0,this.renderGridLine(t,r,f),this.renderMark(d,r,f),this.renderLabel(d,t,u,e),o.isNew=!1,fireEvent$z(this,"afterRender")},n.prototype.renderGridLine=function(e,t,r){var o=this,s=o.axis,a=s.options,l={},h=o.pos,d=o.type,c=pick$1p(o.tickmarkOffset,s.tickmarkOffset),p=s.chart.renderer,f=o.gridLine,u,g=a.gridLineWidth,m=a.gridLineColor,y=a.gridLineDashStyle;o.type==="minor"&&(g=a.minorGridLineWidth,m=a.minorGridLineColor,y=a.minorGridLineDashStyle),f||(s.chart.styledMode||(l.stroke=m,l["stroke-width"]=g||0,l.dashstyle=y),d||(l.zIndex=1),e&&(t=0),o.gridLine=f=p.path().attr(l).addClass("highcharts-"+(d?d+"-":"")+"grid-line").add(s.gridGroup)),f&&(u=s.getPlotLinePath({value:h+c,lineWidth:f.strokeWidth()*r,force:"pass",old:e}),u&&f[e||o.isNew?"attr":"animate"]({d:u,opacity:t}))},n.prototype.renderMark=function(e,t,r){var o=this,s=o.axis,a=s.options,l=s.chart.renderer,h=o.type,d=s.tickSize(h?h+"Tick":"tick"),c=e.x,p=e.y,f=pick$1p(a[h!=="minor"?"tickWidth":"minorTickWidth"],!h&&s.isXAxis?1:0),u=a[h!=="minor"?"tickColor":"minorTickColor"],g=o.mark,m=!g;d&&(s.opposite&&(d[0]=-d[0]),g||(o.mark=g=l.path().addClass("highcharts-"+(h?h+"-":"")+"tick").add(s.axisGroup),s.chart.styledMode||g.attr({stroke:u,"stroke-width":f})),g[m?"attr":"animate"]({d:o.getMarkPath(c,p,d[0],g.strokeWidth()*r,s.horiz,l),opacity:t}))},n.prototype.renderLabel=function(e,t,r,o){var s=this,a=s.axis,l=a.horiz,h=a.options,d=s.label,c=h.labels,p=c.step,f=pick$1p(s.tickmarkOffset,a.tickmarkOffset),u=e.x,g=e.y,m=!0;d&&isNumber$I(u)&&(d.xy=e=s.getLabelPosition(u,g,d,l,c,f,o,p),s.isFirst&&!s.isLast&&!h.showFirstLabel||s.isLast&&!s.isFirst&&!h.showLastLabel?m=!1:l&&!c.step&&!c.rotation&&!t&&r!==0&&s.handleOverflow(e),p&&o%p&&(m=!1),m&&isNumber$I(e.y)?(e.opacity=r,d[s.isNewLabel?"attr":"animate"](e),s.isNewLabel=!1):(d.attr("y",-9999),s.isNewLabel=!0))},n.prototype.replaceMovedLabel=function(){var e=this,t=e.label,r=e.axis,o=r.reversed,s,a;t&&!e.isNew&&(s=r.horiz?o?r.left:r.width+r.left:t.xy.x,a=r.horiz?t.xy.y:o?r.width+r.top:r.top,t.animate({x:s,y:a,opacity:0},void 0,t.destroy),delete e.label),r.isDirty=!0,e.label=e.movedLabel,delete e.movedLabel},n}(),animObject$a=animationExports.animObject,defaultOptions$d=DefaultOptions.defaultOptions,registerEventOptions$2=exports$3.registerEventOptions,deg2rad$5=H.deg2rad,arrayMax$9=Utilities.arrayMax,arrayMin$8=Utilities.arrayMin,clamp$g=Utilities.clamp,correctFloat$b=Utilities.correctFloat,defined$N=Utilities.defined,destroyObjectProperties$7=Utilities.destroyObjectProperties,erase$7=Utilities.erase,error$7=Utilities.error,extend$1i=Utilities.extend,fireEvent$y=Utilities.fireEvent,getMagnitude$2=Utilities.getMagnitude,isArray$j=Utilities.isArray,isNumber$H=Utilities.isNumber,isString$7=Utilities.isString,merge$1g=Utilities.merge,normalizeTickInterval$2=Utilities.normalizeTickInterval,objectEach$s=Utilities.objectEach,pick$1o=Utilities.pick,relativeLength$9=Utilities.relativeLength,removeEvent$9=Utilities.removeEvent,splat$g=Utilities.splat,syncTimeout$7=Utilities.syncTimeout,Axis=function(){function n(e,t){this.alternateBands=void 0,this.bottom=void 0,this.categories=void 0,this.chart=void 0,this.closestPointRange=void 0,this.coll=void 0,this.eventOptions=void 0,this.hasNames=void 0,this.hasVisibleSeries=void 0,this.height=void 0,this.isLinked=void 0,this.labelEdge=void 0,this.labelFormatter=void 0,this.left=void 0,this.len=void 0,this.max=void 0,this.maxLabelLength=void 0,this.min=void 0,this.minorTickInterval=void 0,this.minorTicks=void 0,this.minPixelPadding=void 0,this.names=void 0,this.offset=void 0,this.options=void 0,this.overlap=void 0,this.paddedTicks=void 0,this.plotLinesAndBands=void 0,this.plotLinesAndBandsGroups=void 0,this.pointRange=void 0,this.pointRangePadding=void 0,this.pos=void 0,this.positiveValuesOnly=void 0,this.right=void 0,this.series=void 0,this.side=void 0,this.tickAmount=void 0,this.tickInterval=void 0,this.tickmarkOffset=void 0,this.tickPositions=void 0,this.tickRotCorr=void 0,this.ticks=void 0,this.top=void 0,this.transA=void 0,this.transB=void 0,this.translationSlope=void 0,this.userOptions=void 0,this.visible=void 0,this.width=void 0,this.zoomEnabled=void 0,this.init(e,t)}return n.prototype.init=function(e,t){var r=t.isX,o=this;o.chart=e,o.horiz=e.inverted&&!o.isZAxis?!r:r,o.isXAxis=r,o.coll=o.coll||(r?"xAxis":"yAxis"),fireEvent$y(this,"init",{userOptions:t}),o.opposite=pick$1o(t.opposite,o.opposite),o.side=pick$1o(t.side,o.side,o.horiz?o.opposite?0:2:o.opposite?1:3),o.setOptions(t);var s=this.options,a=s.labels,l=s.type;o.userOptions=t,o.minPixelPadding=0,o.reversed=pick$1o(s.reversed,o.reversed),o.visible=s.visible,o.zoomEnabled=s.zoomEnabled,o.hasNames=l==="category"||s.categories===!0,o.categories=s.categories||o.hasNames,o.names||(o.names=[],o.names.keys={}),o.plotLinesAndBandsGroups={},o.positiveValuesOnly=!!o.logarithmic,o.isLinked=defined$N(s.linkedTo),o.ticks={},o.labelEdge=[],o.minorTicks={},o.plotLinesAndBands=[],o.alternateBands={},o.len=0,o.minRange=o.userMinRange=s.minRange||s.maxZoom,o.range=s.range,o.offset=s.offset||0,o.max=null,o.min=null;var h=pick$1o(s.crosshair,splat$g(e.options.tooltip.crosshairs)[r?0:1]);o.crosshair=h===!0?{}:h,e.axes.indexOf(o)===-1&&(r?e.axes.splice(e.xAxis.length,0,o):e.axes.push(o),e[o.coll].push(o)),o.series=o.series||[],e.inverted&&!o.isZAxis&&r&&typeof o.reversed>"u"&&(o.reversed=!0),o.labelRotation=isNumber$H(a.rotation)?a.rotation:void 0,registerEventOptions$2(o,s),fireEvent$y(this,"afterInit")},n.prototype.setOptions=function(e){this.options=merge$1g(AxisDefaults$1.defaultXAxisOptions,this.coll==="yAxis"&&AxisDefaults$1.defaultYAxisOptions,[AxisDefaults$1.defaultTopAxisOptions,AxisDefaults$1.defaultRightAxisOptions,AxisDefaults$1.defaultBottomAxisOptions,AxisDefaults$1.defaultLeftAxisOptions][this.side],merge$1g(defaultOptions$d[this.coll],e)),fireEvent$y(this,"afterSetOptions",{userOptions:e})},n.prototype.defaultLabelFormatter=function(e){var t=this.axis,r=this.chart,o=r.numberFormatter,s=isNumber$H(this.value)?this.value:NaN,a=t.chart.time,l=t.categories,h=this.dateTimeLabelFormat,d=defaultOptions$d.lang,c=d.numericSymbols,p=d.numericSymbolMagnitude||1e3,f=t.logarithmic?Math.abs(s):t.tickInterval,u=c&&c.length,g,m;if(l)m=""+this.value;else if(h)m=a.dateFormat(h,s);else if(u&&f>=1e3)for(;u--&&typeof m>"u";)g=Math.pow(p,u+1),f>=g&&s*10%g===0&&c[u]!==null&&s!==0&&(m=o(s/g,-1)+c[u]);return typeof m>"u"&&(Math.abs(s)>=1e4?m=o(s,-1):m=o(s,-1,void 0,"")),m},n.prototype.getSeriesExtremes=function(){var e=this,t=e.chart,r;fireEvent$y(this,"getSeriesExtremes",null,function(){e.hasVisibleSeries=!1,e.dataMin=e.dataMax=e.threshold=null,e.softThreshold=!e.isXAxis,e.stacking&&e.stacking.buildStacks(),e.series.forEach(function(o){if(o.visible||!t.options.chart.ignoreHiddenSeries){var s=o.options,a=void 0,l=s.threshold,h=void 0,d=void 0;if(e.hasVisibleSeries=!0,e.positiveValuesOnly&&l<=0&&(l=null),e.isXAxis)a=o.xData,a.length&&(a=e.logarithmic?a.filter(e.validatePositiveValue):a,r=o.getXExtremes(a),h=r.min,d=r.max,!isNumber$H(h)&&!(h instanceof Date)&&(a=a.filter(isNumber$H),r=o.getXExtremes(a),h=r.min,d=r.max),a.length&&(e.dataMin=Math.min(pick$1o(e.dataMin,h),h),e.dataMax=Math.max(pick$1o(e.dataMax,d),d)));else{var c=o.applyExtremes();isNumber$H(c.dataMin)&&(h=c.dataMin,e.dataMin=Math.min(pick$1o(e.dataMin,h),h)),isNumber$H(c.dataMax)&&(d=c.dataMax,e.dataMax=Math.max(pick$1o(e.dataMax,d),d)),defined$N(l)&&(e.threshold=l),(!s.softThreshold||e.positiveValuesOnly)&&(e.softThreshold=!1)}}})}),fireEvent$y(this,"afterGetSeriesExtremes")},n.prototype.translate=function(e,t,r,o,s,a){var l=this.linkedParent||this,h=o&&l.old?l.old.min:l.min,d=l.minPixelPadding,c=(l.isOrdinal||l.brokenAxis&&l.brokenAxis.hasBreaks||l.logarithmic&&s)&&l.lin2val,p=1,f=0,u=o&&l.old?l.old.transA:l.transA,g=0;return u||(u=l.transA),r&&(p*=-1,f=l.len),l.reversed&&(p*=-1,f-=p*(l.sector||l.len)),t?(e=e*p+f,e-=d,g=e/u+h,c&&(g=l.lin2val(g))):(c&&(e=l.val2lin(e)),g=isNumber$H(h)?p*(e-h)*u+f+p*d+(isNumber$H(a)?u*a:0):void 0),g},n.prototype.toPixels=function(e,t){return this.translate(e,!1,!this.horiz,null,!0)+(t?0:this.pos)},n.prototype.toValue=function(e,t){return this.translate(e-(t?0:this.pos),!0,!this.horiz,null,!0)},n.prototype.getPlotLinePath=function(e){var t=this,r=t.chart,o=t.left,s=t.top,a=e.old,l=e.value,h=e.lineWidth,d=a&&r.oldChartHeight||r.chartHeight,c=a&&r.oldChartWidth||r.chartWidth,p=t.transB,f=e.translatedValue,u=e.force,g,m,y,v,x;function b(S,k,A){return(u!=="pass"&&S<k||S>A)&&(u?S=clamp$g(S,k,A):x=!0),S}var $={value:l,lineWidth:h,old:a,force:u,acrossPanes:e.acrossPanes,translatedValue:f};return fireEvent$y(this,"getPlotLinePath",$,function(S){f=pick$1o(f,t.translate(l,null,null,a)),f=clamp$g(f,-1e5,1e5),g=y=Math.round(f+p),m=v=Math.round(d-f-p),isNumber$H(f)?t.horiz?(m=s,v=d-t.bottom,g=y=b(g,o,o+t.width)):(g=o,y=c-t.right,m=v=b(m,s,s+t.height)):(x=!0,u=!1),S.path=x&&!u?null:r.renderer.crispLine([["M",g,m],["L",y,v]],h||1)}),$.path},n.prototype.getLinearTickPositions=function(e,t,r){var o=correctFloat$b(Math.floor(t/e)*e),s=correctFloat$b(Math.ceil(r/e)*e),a=[],l,h,d;if(correctFloat$b(o+e)===o&&(d=20),this.single)return[t];for(l=o;l<=s&&(a.push(l),l=correctFloat$b(l+e,d),l!==h);)h=l;return a},n.prototype.getMinorTickInterval=function(){var e=this.options;return e.minorTicks===!0?pick$1o(e.minorTickInterval,"auto"):e.minorTicks===!1?null:e.minorTickInterval},n.prototype.getMinorTickPositions=function(){var e=this,t=e.options,r=e.tickPositions,o=e.minorTickInterval,s=e.pointRangePadding||0,a=e.min-s,l=e.max+s,h=l-a,d=[],c;if(h&&h/o<e.len/3){var p=e.logarithmic;if(p)this.paddedTicks.forEach(function(f,u,g){u&&d.push.apply(d,p.getLogTickPositions(o,g[u-1],g[u],!0))});else if(e.dateTime&&this.getMinorTickInterval()==="auto")d=d.concat(e.getTimeTicks(e.dateTime.normalizeTimeTickInterval(o),a,l,t.startOfWeek));else for(c=a+(r[0]-a)%o;c<=l&&c!==d[0];c+=o)d.push(c)}return d.length!==0&&e.trimTicks(d),d},n.prototype.adjustForMinRange=function(){var e=this,t=e.options,r=e.logarithmic,o=e.min,s=e.max,a,l,h=0,d,c,p,f,u,g,m;e.isXAxis&&typeof e.minRange>"u"&&!r&&(defined$N(t.min)||defined$N(t.max)?e.minRange=null:(e.series.forEach(function(y){if(p=y.xData,f=y.xIncrement?1:p.length-1,p.length>1)for(d=f;d>0;d--)c=p[d]-p[d-1],(!h||c<h)&&(h=c)}),e.minRange=Math.min(h*5,e.dataMax-e.dataMin))),s-o<e.minRange&&(l=e.dataMax-e.dataMin>=e.minRange,m=e.minRange,a=(m-s+o)/2,u=[o-a,pick$1o(t.min,o-a)],l&&(u[2]=e.logarithmic?e.logarithmic.log2lin(e.dataMin):e.dataMin),o=arrayMax$9(u),g=[o+m,pick$1o(t.max,o+m)],l&&(g[2]=r?r.log2lin(e.dataMax):e.dataMax),s=arrayMin$8(g),s-o<m&&(u[0]=s-m,u[1]=pick$1o(t.min,s-m),o=arrayMax$9(u))),e.min=o,e.max=s},n.prototype.getClosest=function(){var e;return this.categories?e=1:this.series.forEach(function(t){var r=t.closestPointRange,o=t.visible||!t.chart.options.chart.ignoreHiddenSeries;!t.noSharedTooltip&&defined$N(r)&&o&&(e=defined$N(e)?Math.min(e,r):r)}),e},n.prototype.nameToX=function(e){var t=isArray$j(this.categories),r=t?this.categories:this.names,o=e.options.x,s;return e.series.requireSorting=!1,defined$N(o)||(o=this.options.uniqueNames?t?r.indexOf(e.name):pick$1o(r.keys[e.name],-1):e.series.autoIncrement()),o===-1?t||(s=r.length):s=o,typeof s<"u"&&(this.names[s]=e.name,this.names.keys[e.name]=s),s},n.prototype.updateNames=function(){var e=this,t=this.names,r=t.length;r>0&&(Object.keys(t.keys).forEach(function(o){delete t.keys[o]}),t.length=0,this.minRange=this.userMinRange,(this.series||[]).forEach(function(o){o.xIncrement=null,(!o.points||o.isDirtyData)&&(e.max=Math.max(e.max,o.xData.length-1),o.processData(),o.generatePoints()),o.data.forEach(function(s,a){var l;s&&s.options&&typeof s.name<"u"&&(l=e.nameToX(s),typeof l<"u"&&l!==s.x&&(s.x=l,o.xData[a]=l))})}))},n.prototype.setAxisTranslation=function(){var e=this,t=e.max-e.min,r=e.linkedParent,o=!!e.categories,s=e.isXAxis,a=e.axisPointRange||0,l,h=0,d=0,c,p=e.transA;(s||o||a)&&(l=e.getClosest(),r?(h=r.minPointOffset,d=r.pointRangePadding):e.series.forEach(function(f){var u=o?1:s?pick$1o(f.options.pointRange,l,0):e.axisPointRange||0,g=f.options.pointPlacement;if(a=Math.max(a,u),!e.single||o){var m=f.is("xrange")?!s:s;h=Math.max(h,m&&isString$7(g)?0:u/2),d=Math.max(d,m&&g==="on"?0:u)}}),c=e.ordinal&&e.ordinal.slope&&l?e.ordinal.slope/l:1,e.minPointOffset=h=h*c,e.pointRangePadding=d=d*c,e.pointRange=Math.min(a,e.single&&o?1:t),s&&(e.closestPointRange=l)),e.translationSlope=e.transA=p=e.staticScale||e.len/(t+d||1),e.transB=e.horiz?e.left:e.bottom,e.minPixelPadding=p*h,fireEvent$y(this,"afterSetAxisTranslation")},n.prototype.minFromRange=function(){var e=this;return e.max-e.range},n.prototype.setTickInterval=function(e){var t=this,r=t.chart,o=t.logarithmic,s=t.options,a=t.isXAxis,l=t.isLinked,h=s.tickPixelInterval,d=t.categories,c=t.softThreshold,p=s.maxPadding,f=s.minPadding,u,g,m=s.tickInterval,y=isNumber$H(t.threshold)?t.threshold:null,v,x,b,$;!t.dateTime&&!d&&!l&&this.getTickAmount(),b=pick$1o(t.userMin,s.min),$=pick$1o(t.userMax,s.max),l?(t.linkedParent=r[t.coll][s.linkedTo],g=t.linkedParent.getExtremes(),t.min=pick$1o(g.min,g.dataMin),t.max=pick$1o(g.max,g.dataMax),s.type!==t.linkedParent.options.type&&error$7(11,1,r)):(c&&defined$N(y)&&(t.dataMin>=y?(v=y,f=0):t.dataMax<=y&&(x=y,p=0)),t.min=pick$1o(b,v,t.dataMin),t.max=pick$1o($,x,t.dataMax)),o&&(t.positiveValuesOnly&&!e&&Math.min(t.min,pick$1o(t.dataMin,t.min))<=0&&error$7(10,1,r),t.min=correctFloat$b(o.log2lin(t.min),16),t.max=correctFloat$b(o.log2lin(t.max),16)),t.range&&defined$N(t.max)&&(t.userMin=t.min=b=Math.max(t.dataMin,t.minFromRange()),t.userMax=$=t.max,t.range=null),fireEvent$y(t,"foundExtremes"),t.beforePadding&&t.beforePadding(),t.adjustForMinRange(),!d&&!t.axisPointRange&&!(t.stacking&&t.stacking.usePercentage)&&!l&&defined$N(t.min)&&defined$N(t.max)&&(u=t.max-t.min,u&&(!defined$N(b)&&f&&(t.min-=u*f),!defined$N($)&&p&&(t.max+=u*p))),isNumber$H(t.userMin)||(isNumber$H(s.softMin)&&s.softMin<t.min&&(t.min=b=s.softMin),isNumber$H(s.floor)&&(t.min=Math.max(t.min,s.floor))),isNumber$H(t.userMax)||(isNumber$H(s.softMax)&&s.softMax>t.max&&(t.max=$=s.softMax),isNumber$H(s.ceiling)&&(t.max=Math.min(t.max,s.ceiling))),c&&defined$N(t.dataMin)&&(y=y||0,!defined$N(b)&&t.min<y&&t.dataMin>=y?t.min=t.options.minRange?Math.min(y,t.max-t.minRange):y:!defined$N($)&&t.max>y&&t.dataMax<=y&&(t.max=t.options.minRange?Math.max(y,t.min+t.minRange):y)),isNumber$H(t.min)&&isNumber$H(t.max)&&!this.chart.polar&&t.min>t.max&&(defined$N(t.options.min)?t.max=t.min:defined$N(t.options.max)&&(t.min=t.max)),t.min===t.max||typeof t.min>"u"||typeof t.max>"u"?t.tickInterval=1:l&&t.linkedParent&&!m&&h===t.linkedParent.options.tickPixelInterval?t.tickInterval=m=t.linkedParent.tickInterval:t.tickInterval=pick$1o(m,this.tickAmount?(t.max-t.min)/Math.max(this.tickAmount-1,1):void 0,d?1:(t.max-t.min)*h/Math.max(t.len,h)),a&&!e&&(t.series.forEach(function(k){k.forceCrop=k.forceCropping&&k.forceCropping(),k.processData(t.min!==(t.old&&t.old.min)||t.max!==(t.old&&t.old.max))}),fireEvent$y(this,"postProcessData")),t.setAxisTranslation(),fireEvent$y(this,"initialAxisTranslation"),t.pointRange&&!m&&(t.tickInterval=Math.max(t.pointRange,t.tickInterval));var S=pick$1o(s.minTickInterval,t.dateTime&&!t.series.some(function(k){return k.noSharedTooltip})?t.closestPointRange:0);!m&&t.tickInterval<S&&(t.tickInterval=S),!t.dateTime&&!t.logarithmic&&!m&&(t.tickInterval=normalizeTickInterval$2(t.tickInterval,void 0,getMagnitude$2(t.tickInterval),pick$1o(s.allowDecimals,t.tickInterval<.5||this.tickAmount!==void 0),!!this.tickAmount)),this.tickAmount||(t.tickInterval=t.unsquish()),this.setTickPositions()},n.prototype.setTickPositions=function(){var e=this,t=this.options,r=t.tickPositions,o=this.getMinorTickInterval(),s=this.hasVerticalPanning(),a=this.coll==="colorAxis",l=(a||!s)&&t.startOnTick,h=(a||!s)&&t.endOnTick,d,c=t.tickPositioner;this.tickmarkOffset=this.categories&&t.tickmarkPlacement==="between"&&this.tickInterval===1?.5:0,this.minorTickInterval=o==="auto"&&this.tickInterval?this.tickInterval/5:o,this.single=this.min===this.max&&defined$N(this.min)&&!this.tickAmount&&(parseInt(this.min,10)===this.min||t.allowDecimals!==!1),this.tickPositions=d=r&&r.slice(),d||((!e.ordinal||!e.ordinal.positions)&&(this.max-this.min)/this.tickInterval>Math.max(2*this.len,200)?(d=[this.min,this.max],error$7(19,!1,this.chart)):e.dateTime?d=e.getTimeTicks(e.dateTime.normalizeTimeTickInterval(this.tickInterval,t.units),this.min,this.max,t.startOfWeek,e.ordinal&&e.ordinal.positions,this.closestPointRange,!0):e.logarithmic?d=e.logarithmic.getLogTickPositions(this.tickInterval,this.min,this.max):d=this.getLinearTickPositions(this.tickInterval,this.min,this.max),d.length>this.len&&(d=[d[0],d.pop()],d[0]===d[1]&&(d.length=1)),this.tickPositions=d,c&&(c=c.apply(e,[this.min,this.max]),c&&(this.tickPositions=d=c))),this.paddedTicks=d.slice(0),this.trimTicks(d,l,h),this.isLinked||(this.single&&d.length<2&&!this.categories&&!this.series.some(function(p){return p.is("heatmap")&&p.options.pointPlacement==="between"})&&(this.min-=.5,this.max+=.5),!r&&!c&&this.adjustTickAmount()),fireEvent$y(this,"afterSetTickPositions")},n.prototype.trimTicks=function(e,t,r){var o=e[0],s=e[e.length-1],a=!this.isOrdinal&&this.minPointOffset||0;if(fireEvent$y(this,"trimTicks"),!this.isLinked){if(t&&o!==-1/0)this.min=o;else for(;this.min-a>e[0];)e.shift();if(r)this.max=s;else for(;this.max+a<e[e.length-1];)e.pop();e.length===0&&defined$N(o)&&!this.options.tickPositions&&e.push((s+o)/2)}},n.prototype.alignToOthers=function(){var e=this,t={},r=e.options,o;return this.chart.options.chart.alignTicks!==!1&&r.alignTicks&&r.startOnTick!==!1&&r.endOnTick!==!1&&!e.logarithmic&&this.chart[this.coll].forEach(function(s){var a=s.options,l=s.horiz,h=[l?a.left:a.top,a.width,a.height,a.pane].join(",");s.series.length&&(t[h]?o=!0:t[h]=1)}),o},n.prototype.getTickAmount=function(){var e=this,t=this.options,r=t.tickPixelInterval,o=t.tickAmount;!defined$N(t.tickInterval)&&!o&&this.len<r&&!this.isRadial&&!e.logarithmic&&t.startOnTick&&t.endOnTick&&(o=2),!o&&this.alignToOthers()&&(o=Math.ceil(this.len/r)+1),o<4&&(this.finalTickAmt=o,o=5),this.tickAmount=o},n.prototype.adjustTickAmount=function(){var e=this,t=e.options,r=e.tickInterval,o=e.tickPositions,s=e.tickAmount,a=e.finalTickAmt,l=o&&o.length,h=pick$1o(e.threshold,e.softThreshold?0:null),d,c;if(e.hasData()&&isNumber$H(e.min)&&isNumber$H(e.max)){if(l<s){for(;o.length<s;)o.length%2||e.min===h?o.push(correctFloat$b(o[o.length-1]+r)):o.unshift(correctFloat$b(o[0]-r));e.transA*=(l-1)/(s-1),e.min=t.startOnTick?o[0]:Math.min(e.min,o[0]),e.max=t.endOnTick?o[o.length-1]:Math.max(e.max,o[o.length-1])}else l>s&&(e.tickInterval*=2,e.setTickPositions());if(defined$N(a)){for(c=d=o.length;c--;)(a===3&&c%2===1||a<=2&&c>0&&c<d-1)&&o.splice(c,1);e.finalTickAmt=void 0}}},n.prototype.setScale=function(){var e=this,t=!1,r=!1;e.series.forEach(function(s){t=t||s.isDirtyData||s.isDirty,r=r||s.xAxis&&s.xAxis.isDirty||!1}),e.setAxisSize();var o=e.len!==(e.old&&e.old.len);o||t||r||e.isLinked||e.forceRedraw||e.userMin!==(e.old&&e.old.userMin)||e.userMax!==(e.old&&e.old.userMax)||e.alignToOthers()?(e.stacking&&e.stacking.resetStacks(),e.forceRedraw=!1,e.getSeriesExtremes(),e.setTickInterval(),e.isDirty||(e.isDirty=o||e.min!==(e.old&&e.old.min)||e.max!==(e.old&&e.old.max))):e.stacking&&e.stacking.cleanStacks(),t&&e.panningState&&(e.panningState.isDirty=!0),fireEvent$y(this,"afterSetScale")},n.prototype.setExtremes=function(e,t,r,o,s){var a=this,l=a.chart;r=pick$1o(r,!0),a.series.forEach(function(h){delete h.kdTree}),s=extend$1i(s,{min:e,max:t}),fireEvent$y(a,"setExtremes",s,function(){a.userMin=e,a.userMax=t,a.eventArgs=s,r&&l.redraw(o)})},n.prototype.zoom=function(e,t){var r=this,o=this.dataMin,s=this.dataMax,a=this.options,l=Math.min(o,pick$1o(a.min,o)),h=Math.max(s,pick$1o(a.max,s)),d={newMin:e,newMax:t};return fireEvent$y(this,"zoom",d,function(c){var p=c.newMin,f=c.newMax;(p!==r.min||f!==r.max)&&(r.allowZoomOutside||(defined$N(o)&&(p<l&&(p=l),p>h&&(p=h)),defined$N(s)&&(f<l&&(f=l),f>h&&(f=h))),r.displayBtn=typeof p<"u"||typeof f<"u",r.setExtremes(p,f,!1,void 0,{trigger:"zoom"})),c.zoomed=!0}),d.zoomed},n.prototype.setAxisSize=function(){var e=this.chart,t=this.options,r=t.offsets||[0,0,0,0],o=this.horiz,s=this.width=Math.round(relativeLength$9(pick$1o(t.width,e.plotWidth-r[3]+r[1]),e.plotWidth)),a=this.height=Math.round(relativeLength$9(pick$1o(t.height,e.plotHeight-r[0]+r[2]),e.plotHeight)),l=this.top=Math.round(relativeLength$9(pick$1o(t.top,e.plotTop+r[0]),e.plotHeight,e.plotTop)),h=this.left=Math.round(relativeLength$9(pick$1o(t.left,e.plotLeft+r[3]),e.plotWidth,e.plotLeft));this.bottom=e.chartHeight-a-l,this.right=e.chartWidth-s-h,this.len=Math.max(o?s:a,0),this.pos=o?h:l},n.prototype.getExtremes=function(){var e=this,t=e.logarithmic;return{min:t?correctFloat$b(t.lin2log(e.min)):e.min,max:t?correctFloat$b(t.lin2log(e.max)):e.max,dataMin:e.dataMin,dataMax:e.dataMax,userMin:e.userMin,userMax:e.userMax}},n.prototype.getThreshold=function(e){var t=this,r=t.logarithmic,o=r?r.lin2log(t.min):t.min,s=r?r.lin2log(t.max):t.max;return e===null||e===-1/0?e=o:e===1/0?e=s:o>e?e=o:s<e&&(e=s),t.translate(e,0,1,0,1)},n.prototype.autoLabelAlign=function(e){var t=(pick$1o(e,0)-this.side*90+720)%360,r={align:"center"};return fireEvent$y(this,"autoLabelAlign",r,function(o){t>15&&t<165?o.align="right":t>195&&t<345&&(o.align="left")}),r.align},n.prototype.tickSize=function(e){var t=this.options,r=pick$1o(t[e==="tick"?"tickWidth":"minorTickWidth"],e==="tick"&&this.isXAxis&&!this.categories?1:0),o=t[e==="tick"?"tickLength":"minorTickLength"],s;r&&o&&(t[e+"Position"]==="inside"&&(o=-o),s=[o,r]);var a={tickSize:s};return fireEvent$y(this,"afterTickSize",a),a.tickSize},n.prototype.labelMetrics=function(){var e=this.tickPositions&&this.tickPositions[0]||0;return this.chart.renderer.fontMetrics(this.options.labels.style.fontSize,this.ticks[e]&&this.ticks[e].label)},n.prototype.unsquish=function(){var e=this.options.labels,t=this.horiz,r=this.tickInterval,o=this.len/(((this.categories?1:0)+this.max-this.min)/r),s=e.rotation,a=this.labelMetrics(),l=Math.max(this.max-this.min,0),h=function(g){var m=g/(o||1);return m=m>1?Math.ceil(m):1,m*r>l&&g!==1/0&&o!==1/0&&l&&(m=Math.ceil(l/r)),correctFloat$b(m*r)},d=r,c,p,f=Number.MAX_VALUE,u;return t?(!e.staggerLines&&!e.step&&(isNumber$H(s)?u=[s]:o<e.autoRotationLimit&&(u=e.autoRotation)),u&&u.forEach(function(g){var m;(g===s||g&&g>=-90&&g<=90)&&(p=h(Math.abs(a.h/Math.sin(deg2rad$5*g))),m=p+Math.abs(g/360),m<f&&(f=m,c=g,d=p))})):e.step||(d=h(a.h)),this.autoRotation=u,this.labelRotation=pick$1o(c,isNumber$H(s)?s:0),d},n.prototype.getSlotWidth=function(e){var t=this.chart,r=this.horiz,o=this.options.labels,s=Math.max(this.tickPositions.length-(this.categories?0:1),1),a=t.margin[3];if(e&&isNumber$H(e.slotWidth))return e.slotWidth;if(r&&o.step<2)return o.rotation?0:(this.staggerLines||1)*this.len/s;if(!r){var l=o.style.width;if(l!==void 0)return parseInt(String(l),10);if(a)return a-t.spacing[3]}return t.chartWidth*.33},n.prototype.renderUnsquish=function(){var e=this.chart,t=e.renderer,r=this.tickPositions,o=this.ticks,s=this.options.labels,a=s.style,l=this.horiz,h=this.getSlotWidth(),d=Math.max(1,Math.round(h-2*s.padding)),c={},p=this.labelMetrics(),f=a.textOverflow,u,g,m=0,y,v,x;if(isString$7(s.rotation)||(c.rotation=s.rotation||0),r.forEach(function(b){var $=o[b];$.movedLabel&&$.replaceMovedLabel(),$&&$.label&&$.label.textPxLength>m&&(m=$.label.textPxLength)}),this.maxLabelLength=m,this.autoRotation)m>d&&m>p.h?c.rotation=this.labelRotation:this.labelRotation=0;else if(h&&(u=d,!f))for(g="clip",v=r.length;!l&&v--;)x=r[v],y=o[x].label,y&&(y.styles&&y.styles.textOverflow==="ellipsis"?y.css({textOverflow:"clip"}):y.textPxLength>h&&y.css({width:h+"px"}),y.getBBox().height>this.len/r.length-(p.h-p.f)&&(y.specificTextOverflow="ellipsis"));c.rotation&&(u=m>e.chartHeight*.5?e.chartHeight*.33:m,f||(g="ellipsis")),this.labelAlign=s.align||this.autoLabelAlign(this.labelRotation),this.labelAlign&&(c.align=this.labelAlign),r.forEach(function(b){var $=o[b],S=$&&$.label,k=a.width,A={};S&&(S.attr(c),$.shortenLabel?$.shortenLabel():u&&!k&&a.whiteSpace!=="nowrap"&&(u<S.textPxLength||S.element.tagName==="SPAN")?(A.width=u+"px",f||(A.textOverflow=S.specificTextOverflow||g),S.css(A)):S.styles&&S.styles.width&&!A.width&&!k&&S.css({width:null}),delete S.specificTextOverflow,$.rotation=c.rotation)},this),this.tickRotCorr=t.rotCorr(p.b,this.labelRotation||0,this.side!==0)},n.prototype.hasData=function(){return this.series.some(function(e){return e.hasData()})||this.options.showEmpty&&defined$N(this.min)&&defined$N(this.max)},n.prototype.addTitle=function(e){var t=this,r=t.chart.renderer,o=t.horiz,s=t.opposite,a=t.options,l=a.title,h=t.chart.styledMode,d;t.axisTitle||(d=l.textAlign,d||(d=(o?{low:"left",middle:"center",high:"right"}:{low:s?"right":"left",middle:"center",high:s?"left":"right"})[l.align]),t.axisTitle=r.text(l.text||"",0,0,l.useHTML).attr({zIndex:7,rotation:l.rotation,align:d}).addClass("highcharts-axis-title"),h||t.axisTitle.css(merge$1g(l.style)),t.axisTitle.add(t.axisGroup),t.axisTitle.isNew=!0),!h&&!l.style.width&&!t.isRadial&&t.axisTitle.css({width:t.len+"px"}),t.axisTitle[e?"show":"hide"](e)},n.prototype.generateTick=function(e){var t=this,r=t.ticks;r[e]?r[e].addLabel():r[e]=new Tick(t,e)},n.prototype.getOffset=function(){var e=this,t=this,r=t.chart,o=r.renderer,s=t.options,a=t.tickPositions,l=t.ticks,h=t.horiz,d=t.side,c=r.inverted&&!t.isZAxis?[1,0,3,2][d]:d,p=t.hasData(),f=s.title,u=s.labels,g=r.axisOffset,m=r.clipOffset,y=[-1,1,1,-1][d],v=s.className,x=t.axisParent,b,$=0,S,k=0,A=0,M,P;if(t.showAxis=b=p||s.showEmpty,t.staggerLines=t.horiz&&u.staggerLines||void 0,!t.axisGroup){var E=function(C,I,L){return o.g(C).attr({zIndex:L}).addClass("highcharts-"+e.coll.toLowerCase()+I+" "+(e.isRadial?"highcharts-radial-axis"+I+" ":"")+(v||"")).add(x)};t.gridGroup=E("grid","-grid",s.gridZIndex),t.axisGroup=E("axis","",s.zIndex),t.labelGroup=E("axis-labels","-labels",u.zIndex)}p||t.isLinked?(a.forEach(function(C){t.generateTick(C)}),t.renderUnsquish(),t.reserveSpaceDefault=d===0||d===2||{1:"left",3:"right"}[d]===t.labelAlign,pick$1o(u.reserveSpace,t.labelAlign==="center"?!0:null,t.reserveSpaceDefault)&&a.forEach(function(C){A=Math.max(l[C].getLabelSize(),A)}),t.staggerLines&&(A*=t.staggerLines),t.labelOffset=A*(t.opposite?-1:1)):objectEach$s(l,function(C,I){C.destroy(),delete l[I]}),f&&f.text&&f.enabled!==!1&&(t.addTitle(b),b&&f.reserveSpace!==!1&&(t.titleOffset=$=t.axisTitle.getBBox()[h?"height":"width"],S=f.offset,k=defined$N(S)?0:pick$1o(f.margin,h?5:10))),t.renderLine(),t.offset=y*pick$1o(s.offset,g[d]?g[d]+(s.margin||0):0),t.tickRotCorr=t.tickRotCorr||{x:0,y:0},d===0?P=-t.labelMetrics().h:d===2?P=t.tickRotCorr.y:P=0,M=Math.abs(A)+k,A&&(M-=P,M+=y*(h?pick$1o(u.y,t.tickRotCorr.y+y*8):u.x)),t.axisTitleMargin=pick$1o(S,M),t.getMaxLabelDimensions&&(t.maxLabelDimensions=t.getMaxLabelDimensions(l,a));var T=this.tickSize("tick");g[d]=Math.max(g[d],(t.axisTitleMargin||0)+$+y*t.offset,M,a&&a.length&&T?T[0]+y*t.offset:0);var O=s.offset?0:Math.floor(t.axisLine.strokeWidth()/2)*2;m[c]=Math.max(m[c],O),fireEvent$y(this,"afterGetOffset")},n.prototype.getLinePath=function(e){var t=this.chart,r=this.opposite,o=this.offset,s=this.horiz,a=this.left+(r?this.width:0)+o,l=t.chartHeight-this.bottom-(r?this.height:0)+o;return r&&(e*=-1),t.renderer.crispLine([["M",s?this.left:a,s?l:this.top],["L",s?t.chartWidth-this.right:a,s?l:t.chartHeight-this.bottom]],e)},n.prototype.renderLine=function(){this.axisLine||(this.axisLine=this.chart.renderer.path().addClass("highcharts-axis-line").add(this.axisGroup),this.chart.styledMode||this.axisLine.attr({stroke:this.options.lineColor,"stroke-width":this.options.lineWidth,zIndex:7}))},n.prototype.getTitlePosition=function(){var e=this.horiz,t=this.left,r=this.top,o=this.len,s=this.options.title,a=e?t:r,l=this.opposite,h=this.offset,d=s.x,c=s.y,p=this.axisTitle,f=this.chart.renderer.fontMetrics(s.style.fontSize,p),u=Math.max(p.getBBox(null,0).height-f.h-1,0),g={low:a+(e?0:o),middle:a+o/2,high:a+(e?o:0)}[s.align],m=(e?r+this.height:t)+(e?1:-1)*(l?-1:1)*this.axisTitleMargin+[-u,u,f.f,-u][this.side],y={x:e?g+d:m+(l?this.width:0)+h+d,y:e?m+c-(l?this.height:0)+h:g+c};return fireEvent$y(this,"afterGetTitlePosition",{titlePosition:y}),y},n.prototype.renderMinorTick=function(e,t){var r=this,o=r.minorTicks;o[e]||(o[e]=new Tick(r,e,"minor")),t&&o[e].isNew&&o[e].render(null,!0),o[e].render(null,!1,1)},n.prototype.renderTick=function(e,t,r){var o=this,s=o.isLinked,a=o.ticks;(!s||e>=o.min&&e<=o.max||o.grid&&o.grid.isColumn)&&(a[e]||(a[e]=new Tick(o,e)),r&&a[e].isNew&&a[e].render(t,!0,-1),a[e].render(t))},n.prototype.render=function(){var e=this,t=e.chart,r=e.logarithmic,o=t.renderer,s=e.options,a=e.isLinked,l=e.tickPositions,h=e.axisTitle,d=e.ticks,c=e.minorTicks,p=e.alternateBands,f=s.stackLabels,u=s.alternateGridColor,g=e.tickmarkOffset,m=e.axisLine,y=e.showAxis,v=animObject$a(o.globalAnimation),x,b;if(e.labelEdge.length=0,e.overlap=!1,[d,c,p].forEach(function(k){objectEach$s(k,function(A){A.isActive=!1})}),e.hasData()||a){var $=e.chart.hasRendered&&e.old&&isNumber$H(e.old.min);e.minorTickInterval&&!e.categories&&e.getMinorTickPositions().forEach(function(k){e.renderMinorTick(k,$)}),l.length&&(l.forEach(function(k,A){e.renderTick(k,A,$)}),g&&(e.min===0||e.single)&&(d[-1]||(d[-1]=new Tick(e,-1,null,!0)),d[-1].render(-1))),u&&l.forEach(function(k,A){b=typeof l[A+1]<"u"?l[A+1]+g:e.max-g,A%2===0&&k<e.max&&b<=e.max+(t.polar?-g:g)&&(p[k]||(p[k]=new H.PlotLineOrBand(e)),x=k+g,p[k].options={from:r?r.lin2log(x):x,to:r?r.lin2log(b):b,color:u,className:"highcharts-alternate-grid"},p[k].render(),p[k].isActive=!0)}),e._addedPlotLB||(e._addedPlotLB=!0,(s.plotLines||[]).concat(s.plotBands||[]).forEach(function(k){e.addPlotBandOrLine(k)}))}if([d,c,p].forEach(function(k){var A=[],M=v.duration,P=function(){for(var E=A.length;E--;)k[A[E]]&&!k[A[E]].isActive&&(k[A[E]].destroy(),delete k[A[E]])};objectEach$s(k,function(E,T){E.isActive||(E.render(T,!1,0),E.isActive=!1,A.push(T))}),syncTimeout$7(P,k===p||!t.hasRendered||!M?0:M)}),m&&(m[m.isPlaced?"animate":"attr"]({d:this.getLinePath(m.strokeWidth())}),m.isPlaced=!0,m[y?"show":"hide"](y)),h&&y){var S=e.getTitlePosition();isNumber$H(S.y)?(h[h.isNew?"attr":"animate"](S),h.isNew=!1):(h.attr("y",-9999),h.isNew=!0)}f&&f.enabled&&e.stacking&&e.stacking.renderStackTotals(),e.old={len:e.len,max:e.max,min:e.min,transA:e.transA,userMax:e.userMax,userMin:e.userMin},e.isDirty=!1,fireEvent$y(this,"afterRender")},n.prototype.redraw=function(){this.visible&&(this.render(),this.plotLinesAndBands.forEach(function(e){e.render()})),this.series.forEach(function(e){e.isDirty=!0})},n.prototype.getKeepProps=function(){return this.keepProps||n.keepProps},n.prototype.destroy=function(e){var t=this,r=t.plotLinesAndBands,o=this.eventOptions;if(fireEvent$y(this,"destroy",{keepEvents:e}),e||removeEvent$9(t),[t.ticks,t.minorTicks,t.alternateBands].forEach(function(l){destroyObjectProperties$7(l)}),r)for(var s=r.length;s--;)r[s].destroy();["axisLine","axisTitle","axisGroup","gridGroup","labelGroup","cross","scrollbar"].forEach(function(l){t[l]&&(t[l]=t[l].destroy())});for(var a in t.plotLinesAndBandsGroups)t.plotLinesAndBandsGroups[a]=t.plotLinesAndBandsGroups[a].destroy();objectEach$s(t,function(l,h){t.getKeepProps().indexOf(h)===-1&&delete t[h]}),this.eventOptions=o},n.prototype.drawCrosshair=function(e,t){var r=this.crosshair,o=pick$1o(r&&r.snap,!0),s=this.chart,a,l,h,d=this.cross,c;if(fireEvent$y(this,"drawCrosshair",{e,point:t}),e||(e=this.cross&&this.cross.e),!r||(defined$N(t)||!o)===!1)this.hideCrosshair();else{if(o?defined$N(t)&&(l=pick$1o(this.coll!=="colorAxis"?t.crosshairPos:null,this.isXAxis?t.plotX:this.len-t.plotY)):l=e&&(this.horiz?e.chartX-this.pos:this.len-e.chartY+this.pos),defined$N(l)&&(c={value:t&&(this.isXAxis?t.x:pick$1o(t.stackY,t.y)),translatedValue:l},s.polar&&extend$1i(c,{isCrosshair:!0,chartX:e&&e.chartX,chartY:e&&e.chartY,point:t}),a=this.getPlotLinePath(c)||null),!defined$N(a)){this.hideCrosshair();return}h=this.categories&&!this.isRadial,d||(this.cross=d=s.renderer.path().addClass("highcharts-crosshair highcharts-crosshair-"+(h?"category ":"thin ")+(r.className||"")).attr({zIndex:pick$1o(r.zIndex,2)}).add(),s.styledMode||(d.attr({stroke:r.color||(h?Color.parse(palette.highlightColor20).setOpacity(.25).get():palette.neutralColor20),"stroke-width":pick$1o(r.width,1)}).css({"pointer-events":"none"}),r.dashStyle&&d.attr({dashstyle:r.dashStyle}))),d.show().attr({d:a}),h&&!r.width&&d.attr({"stroke-width":this.transA}),this.cross.e=e}fireEvent$y(this,"afterDrawCrosshair",{e,point:t})},n.prototype.hideCrosshair=function(){this.cross&&this.cross.hide(),fireEvent$y(this,"afterHideCrosshair")},n.prototype.hasVerticalPanning=function(){var e=this.chart.options.chart.panning;return!!(e&&e.enabled&&/y/.test(e.type))},n.prototype.validatePositiveValue=function(e){return isNumber$H(e)&&e>0},n.prototype.update=function(e,t){var r=this.chart;e=merge$1g(this.userOptions,e),this.destroy(!0),this.init(r,e),r.isDirtyBox=!0,pick$1o(t,!0)&&r.redraw()},n.prototype.remove=function(e){for(var t=this.chart,r=this.coll,o=this.series,s=o.length;s--;)o[s]&&o[s].remove(!1);erase$7(t.axes,this),erase$7(t[r],this),t[r].forEach(function(a,l){a.options.index=a.userOptions.index=l}),this.destroy(),t.isDirtyBox=!0,pick$1o(e,!0)&&t.redraw()},n.prototype.setTitle=function(e,t){this.update({title:e},t)},n.prototype.setCategories=function(e,t){this.update({categories:e},t)},n.defaultOptions=AxisDefaults$1.defaultXAxisOptions,n.keepProps=["extKey","hcEvents","names","series","userMax","userMin"],n}(),addEvent$_=Utilities.addEvent,getMagnitude$1=Utilities.getMagnitude,normalizeTickInterval$1=Utilities.normalizeTickInterval,timeUnits$1=Utilities.timeUnits,DateTimeAxis;(function(n){var e=[];function t(a){if(e.indexOf(a)===-1){e.push(a),a.keepProps.push("dateTime");var l=a.prototype;l.getTimeTicks=r,addEvent$_(a,"init",o)}return a}n.compose=t;function r(){return this.chart.time.getTimeTicks.apply(this.chart.time,arguments)}function o(a){var l=this,h=a.userOptions;if(h.type!=="datetime"){l.dateTime=void 0;return}l.dateTime||(l.dateTime=new s(l))}var s=function(){function a(l){this.axis=l}return a.prototype.normalizeTimeTickInterval=function(l,h){var d=h||[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2]],["week",[1,2]],["month",[1,2,3,4,6]],["year",null]],c=d[d.length-1],p=timeUnits$1[c[0]],f=c[1],u;for(u=0;u<d.length;u++)if(c=d[u],p=timeUnits$1[c[0]],f=c[1],d[u+1]){var g=(p*f[f.length-1]+timeUnits$1[d[u+1][0]])/2;if(l<=g)break}p===timeUnits$1.year&&l<5*p&&(f=[1,2,5]);var m=normalizeTickInterval$1(l/p,f,c[0]==="year"?Math.max(getMagnitude$1(l/p),1):1);return{unitRange:p,count:m,unitName:c[0]}},a.prototype.getXDateFormat=function(l,h){var d=this.axis;return d.closestPointRange?d.chart.time.getDateFormat(d.closestPointRange,l,d.options.startOfWeek,h)||h.year:h.day},a}();n.Additions=s})(DateTimeAxis||(DateTimeAxis={}));const DateTimeAxis$1=DateTimeAxis;var addEvent$Z=Utilities.addEvent,getMagnitude=Utilities.getMagnitude,normalizeTickInterval=Utilities.normalizeTickInterval,pick$1n=Utilities.pick,LogarithmicAxis;(function(n){var e=[];function t(a){return e.indexOf(a)===-1&&(e.push(a),a.keepProps.push("logarithmic"),addEvent$Z(a,"init",r),addEvent$Z(a,"afterInit",o)),a}n.compose=t;function r(a){var l=this,h=a.userOptions,d=l.logarithmic;h.type!=="logarithmic"?l.logarithmic=void 0:d||(d=l.logarithmic=new s(l))}function o(){var a=this,l=a.logarithmic;l&&(a.lin2val=function(h){return l.lin2log(h)},a.val2lin=function(h){return l.log2lin(h)})}var s=function(){function a(l){this.axis=l}return a.prototype.getLogTickPositions=function(l,h,d,c){var p=this,f=p.axis,u=f.len,g=f.options,m=[];if(c||(p.minorAutoInterval=void 0),l>=.5)l=Math.round(l),m=f.getLinearTickPositions(l,h,d);else if(l>=.08){var y=Math.floor(h),v=void 0,x=void 0,b=void 0,$=void 0,S=void 0,k=void 0,A=void 0;for(l>.3?v=[1,2,4]:l>.15?v=[1,2,4,6,8]:v=[1,2,3,4,5,6,7,8,9],x=y;x<d+1&&!A;x++)for($=v.length,b=0;b<$&&!A;b++)S=p.log2lin(p.lin2log(x)*v[b]),S>h&&(!c||k<=d)&&typeof k<"u"&&m.push(k),k>d&&(A=!0),k=S}else{var M=p.lin2log(h),P=p.lin2log(d),E=c?f.getMinorTickInterval():g.tickInterval,T=E==="auto"?null:E,O=g.tickPixelInterval/(c?5:1),C=c?u/f.tickPositions.length:u;l=pick$1n(T,p.minorAutoInterval,(P-M)*O/(C||1)),l=normalizeTickInterval(l,void 0,getMagnitude(l)),m=f.getLinearTickPositions(l,M,P).map(p.log2lin),c||(p.minorAutoInterval=l/5)}return c||(f.tickInterval=l),m},a.prototype.lin2log=function(l){return Math.pow(10,l)},a.prototype.log2lin=function(l){return Math.log(l)/Math.LN10},a}();n.Additions=s})(LogarithmicAxis||(LogarithmicAxis={}));const LogarithmicAxis$1=LogarithmicAxis;var erase$6=Utilities.erase,extend$1h=Utilities.extend,isNumber$G=Utilities.isNumber,PlotLineOrBandAxis;(function(n){var e=[],t;function r(s,a){return t||(t=s),e.indexOf(a)===-1&&(e.push(a),extend$1h(a.prototype,o.prototype)),a}n.compose=r;var o=function(){function s(){}return s.prototype.getPlotBandPath=function(a,l,h){h===void 0&&(h=this.options);var d=this.getPlotLinePath({value:l,force:!0,acrossPanes:h.acrossPanes}),c=[],p=this.horiz,f=!isNumber$G(this.min)||!isNumber$G(this.max)||a<this.min&&l<this.min||a>this.max&&l>this.max,u=this.getPlotLinePath({value:a,force:!0,acrossPanes:h.acrossPanes}),g,m=1,y;if(u&&d)for(f&&(y=u.toString()===d.toString(),m=0),g=0;g<u.length;g+=2){var v=u[g],x=u[g+1],b=d[g],$=d[g+1];(v[0]==="M"||v[0]==="L")&&(x[0]==="M"||x[0]==="L")&&(b[0]==="M"||b[0]==="L")&&($[0]==="M"||$[0]==="L")&&(p&&b[1]===v[1]?(b[1]+=m,$[1]+=m):!p&&b[2]===v[2]&&(b[2]+=m,$[2]+=m),c.push(["M",v[1],v[2]],["L",x[1],x[2]],["L",$[1],$[2]],["L",b[1],b[2]],["Z"])),c.isFlat=y}else u=null;return c},s.prototype.addPlotBand=function(a){return this.addPlotBandOrLine(a,"plotBands")},s.prototype.addPlotLine=function(a){return this.addPlotBandOrLine(a,"plotLines")},s.prototype.addPlotBandOrLine=function(a,l){var h=this,d=this.userOptions,c=new t(this,a);if(this.visible&&(c=c.render()),c){if(this._addedPlotLB||(this._addedPlotLB=!0,(d.plotLines||[]).concat(d.plotBands||[]).forEach(function(f){h.addPlotBandOrLine(f)})),l){var p=d[l]||[];p.push(a),d[l]=p}this.plotLinesAndBands.push(c)}return c},s.prototype.removePlotBandOrLine=function(a){var l=this.plotLinesAndBands,h=this.options,d=this.userOptions;if(l){for(var c=l.length;c--;)l[c].id===a&&l[c].destroy();[h.plotLines||[],d.plotLines||[],h.plotBands||[],d.plotBands||[]].forEach(function(p){for(c=p.length;c--;)(p[c]||{}).id===a&&erase$6(p,p[c])})}},s.prototype.removePlotBand=function(a){this.removePlotBandOrLine(a)},s.prototype.removePlotLine=function(a){this.removePlotBandOrLine(a)},s}()})(PlotLineOrBandAxis||(PlotLineOrBandAxis={}));const PlotLineOrBandAxis$1=PlotLineOrBandAxis;var arrayMax$8=Utilities.arrayMax,arrayMin$7=Utilities.arrayMin,defined$M=Utilities.defined,destroyObjectProperties$6=Utilities.destroyObjectProperties,erase$5=Utilities.erase,fireEvent$x=Utilities.fireEvent,merge$1f=Utilities.merge,objectEach$r=Utilities.objectEach,pick$1m=Utilities.pick,PlotLineOrBand=function(){function n(e,t){this.axis=e,t&&(this.options=t,this.id=t.id)}return n.compose=function(e){return PlotLineOrBandAxis$1.compose(n,e)},n.prototype.render=function(){fireEvent$x(this,"render");var e=this,t=e.axis,r=t.horiz,o=t.logarithmic,s=e.options,a=s.color,l=pick$1m(s.zIndex,0),h=s.events,d={},c=t.chart.renderer,p=s.label,f=e.label,u=s.to,g=s.from,m=s.value,y=e.svgElem,v=[],x,b=defined$M(g)&&defined$M(u),$=defined$M(m),S=!y,k={class:"highcharts-plot-"+(b?"band ":"line ")+(s.className||"")},A=b?"bands":"lines";if(o&&(g=o.log2lin(g),u=o.log2lin(u),m=o.log2lin(m)),t.chart.styledMode||($?(k.stroke=a||palette.neutralColor40,k["stroke-width"]=pick$1m(s.width,1),s.dashStyle&&(k.dashstyle=s.dashStyle)):b&&(k.fill=a||palette.highlightColor10,s.borderWidth&&(k.stroke=s.borderColor,k["stroke-width"]=s.borderWidth))),d.zIndex=l,A+="-"+l,x=t.plotLinesAndBandsGroups[A],x||(t.plotLinesAndBandsGroups[A]=x=c.g("plot-"+A).attr(d).add()),S&&(e.svgElem=y=c.path().attr(k).add(x)),$)v=t.getPlotLinePath({value:m,lineWidth:y.strokeWidth(),acrossPanes:s.acrossPanes});else if(b)v=t.getPlotBandPath(g,u,s);else return;return!e.eventsAdded&&h&&(objectEach$r(h,function(M,P){y.on(P,function(E){h[P].apply(e,[E])})}),e.eventsAdded=!0),(S||!y.d)&&v&&v.length?y.attr({d:v}):y&&(v?(y.show(!0),y.animate({d:v})):y.d&&(y.hide(),f&&(e.label=f=f.destroy()))),p&&(defined$M(p.text)||defined$M(p.formatter))&&v&&v.length&&t.width>0&&t.height>0&&!v.isFlat?(p=merge$1f({align:r&&b&&"center",x:r?!b&&4:10,verticalAlign:!r&&b&&"middle",y:r?b?16:10:b?6:-4,rotation:r&&!b&&90},p),this.renderLabel(p,v,b,l)):f&&f.hide(),e},n.prototype.renderLabel=function(e,t,r,o){var s=this,a=s.axis,l=a.chart.renderer,h=s.label;h||(s.label=h=l.text(this.getLabelText(e),0,0,e.useHTML).attr({align:e.textAlign||e.align,rotation:e.rotation,class:"highcharts-plot-"+(r?"band":"line")+"-label "+(e.className||""),zIndex:o}).add(),a.chart.styledMode||h.css(merge$1f({textOverflow:"ellipsis"},e.style)));var d=t.xBounds||[t[0][1],t[1][1],r?t[2][1]:t[0][1]],c=t.yBounds||[t[0][2],t[1][2],r?t[2][2]:t[0][2]],p=arrayMin$7(d),f=arrayMin$7(c);h.align(e,!1,{x:p,y:f,width:arrayMax$8(d)-p,height:arrayMax$8(c)-f}),(!h.alignValue||h.alignValue==="left")&&h.css({width:(h.rotation===90?a.height-(h.alignAttr.y-a.top):a.width-(h.alignAttr.x-a.left))+"px"}),h.show(!0)},n.prototype.getLabelText=function(e){return defined$M(e.formatter)?e.formatter.call(this):e.text},n.prototype.destroy=function(){erase$5(this.axis.plotLinesAndBands,this),delete this.axis,destroyObjectProperties$6(this)},n}(),format$c=FormatUtilities.format,doc$i=H.doc,distribute$3=R.distribute,addEvent$Y=Utilities.addEvent,clamp$f=Utilities.clamp,css$9=Utilities.css,defined$L=Utilities.defined,discardElement$5=Utilities.discardElement,extend$1g=Utilities.extend,fireEvent$w=Utilities.fireEvent,isArray$i=Utilities.isArray,isNumber$F=Utilities.isNumber,isString$6=Utilities.isString,merge$1e=Utilities.merge,pick$1l=Utilities.pick,splat$f=Utilities.splat,syncTimeout$6=Utilities.syncTimeout,Tooltip=function(){function n(e,t){this.container=void 0,this.crosshairs=[],this.distance=0,this.isHidden=!0,this.isSticky=!1,this.now={},this.options={},this.outside=!1,this.chart=e,this.init(e,t)}return n.prototype.applyFilter=function(){var e=this.chart;e.renderer.definition({tagName:"filter",attributes:{id:"drop-shadow-"+e.index,opacity:.5},children:[{tagName:"feGaussianBlur",attributes:{in:"SourceAlpha",stdDeviation:1}},{tagName:"feOffset",attributes:{dx:1,dy:1}},{tagName:"feComponentTransfer",children:[{tagName:"feFuncA",attributes:{type:"linear",slope:.3}}]},{tagName:"feMerge",children:[{tagName:"feMergeNode"},{tagName:"feMergeNode",attributes:{in:"SourceGraphic"}}]}]})},n.prototype.bodyFormatter=function(e){return e.map(function(t){var r=t.series.tooltipOptions;return(r[(t.point.formatPrefix||"point")+"Formatter"]||t.point.tooltipFormatter).call(t.point,r[(t.point.formatPrefix||"point")+"Format"]||"")})},n.prototype.cleanSplit=function(e){this.chart.series.forEach(function(t){var r=t&&t.tt;r&&(!r.isActive||e?t.tt=r.destroy():r.isActive=!1)})},n.prototype.defaultFormatter=function(e){var t=this.points||splat$f(this),r;return r=[e.tooltipFooterHeaderFormatter(t[0])],r=r.concat(e.bodyFormatter(t)),r.push(e.tooltipFooterHeaderFormatter(t[0],!0)),r},n.prototype.destroy=function(){this.label&&(this.label=this.label.destroy()),this.split&&this.tt&&(this.cleanSplit(this.chart,!0),this.tt=this.tt.destroy()),this.renderer&&(this.renderer=this.renderer.destroy(),discardElement$5(this.container)),Utilities.clearTimeout(this.hideTimer),Utilities.clearTimeout(this.tooltipTimeout)},n.prototype.getAnchor=function(e,t){var r=this.chart,o=r.pointer,s=r.inverted,a=r.plotTop,l=r.plotLeft,h,d,c,p=0,f=0;return e=splat$f(e),this.followPointer&&t?(typeof t.chartX>"u"&&(t=o.normalize(t)),h=[t.chartX-l,t.chartY-a]):e[0].tooltipPos?h=e[0].tooltipPos:(e.forEach(function(u){d=u.series.yAxis,c=u.series.xAxis,p+=u.plotX||0,f+=u.plotLow?(u.plotLow+(u.plotHigh||0))/2:u.plotY||0,c&&d&&(s?(p+=a+r.plotHeight-c.len-c.pos,f+=l+r.plotWidth-d.len-d.pos):(p+=c.pos-l,f+=d.pos-a))}),p/=e.length,f/=e.length,h=[s?r.plotWidth-f:p,s?r.plotHeight-p:f],this.shared&&e.length>1&&t&&(s?h[0]=t.chartX-l:h[1]=t.chartY-a)),h.map(Math.round)},n.prototype.getLabel=function(){var e=this,t=this.chart.styledMode,r=this.options,o="tooltip"+(defined$L(r.className)?" "+r.className:""),s=r.style.pointerEvents||(!this.followPointer&&r.stickOnContact?"auto":"none"),a=function(){e.inContact=!0},l=function(m){var y=e.chart.hoverSeries;e.inContact=e.shouldStickOnContact()&&e.chart.pointer.inClass(m.relatedTarget,"highcharts-tooltip"),!e.inContact&&y&&y.onMouseOut&&y.onMouseOut()},h,d=this.chart.renderer;if(!this.label){if(this.outside){var c=this.chart.options.chart.style,p=RendererRegistry$1.getRendererType();this.container=h=H.doc.createElement("div"),h.className="highcharts-tooltip-container",css$9(h,{position:"absolute",top:"1px",pointerEvents:s,zIndex:Math.max(this.options.style.zIndex||0,(c&&c.zIndex||0)+3)}),addEvent$Y(h,"mouseenter",a),addEvent$Y(h,"mouseleave",l),H.doc.body.appendChild(h),this.renderer=d=new p(h,0,0,c,void 0,void 0,d.styledMode)}if(this.split?this.label=d.g(o):(this.label=d.label("",0,0,r.shape,void 0,void 0,r.useHTML,void 0,o).attr({padding:r.padding,r:r.borderRadius}),t||this.label.attr({fill:r.backgroundColor,"stroke-width":r.borderWidth}).css(r.style).css({pointerEvents:s}).shadow(r.shadow)),t&&r.shadow&&(this.applyFilter(),this.label.attr({filter:"url(#drop-shadow-"+this.chart.index+")"})),e.outside&&!e.split){var f=this.label,u=f.xSetter,g=f.ySetter;f.xSetter=function(m){u.call(f,e.distance),h.style.left=m+"px"},f.ySetter=function(m){g.call(f,e.distance),h.style.top=m+"px"}}this.label.on("mouseenter",a).on("mouseleave",l).attr({zIndex:8}).add()}return this.label},n.prototype.getPosition=function(e,t,r){var o=this.chart,s=this.distance,a={},l=o.inverted&&r.h||0,h=this.outside,d=h?doc$i.documentElement.clientWidth-2*s:o.chartWidth,c=h?Math.max(doc$i.body.scrollHeight,doc$i.documentElement.scrollHeight,doc$i.body.offsetHeight,doc$i.documentElement.offsetHeight,doc$i.documentElement.clientHeight):o.chartHeight,p=o.pointer.getChartPosition(),f=function(A){return A*p.scaleX},u=function(A){return A*p.scaleY},g=function(A){var M=A==="x";return[A,M?d:c,M?e:t].concat(h?[M?f(e):u(t),M?p.left-s+f(r.plotX+o.plotLeft):p.top-s+u(r.plotY+o.plotTop),0,M?d:c]:[M?e:t,M?r.plotX+o.plotLeft:r.plotY+o.plotTop,M?o.plotLeft:o.plotTop,M?o.plotLeft+o.plotWidth:o.plotTop+o.plotHeight])},m=g("y"),y=g("x"),v,x=!this.followPointer&&pick$1l(r.ttBelow,!o.inverted==!!r.negative),b=function(A,M,P,E,T,O,C){var I=h?A==="y"?u(s):f(s):s,L=(P-E)/2,D=E<T-s,N=T+s+E<M,B=T-I-P+L,X=T+I-L;if(x&&N)a[A]=X;else if(!x&&D)a[A]=B;else if(D)a[A]=Math.min(C-E,B-l<0?B:B-l);else if(N)a[A]=Math.max(O,X+l+P>M?X:X+l);else return!1},$=function(A,M,P,E,T){var O;return T<s||T>M-s?O=!1:T<P/2?a[A]=1:T>M-E/2?a[A]=M-E-2:a[A]=T-P/2,O},S=function(A){var M=m;m=y,y=M,v=A},k=function(){b.apply(0,m)!==!1?$.apply(0,y)===!1&&!v&&(S(!0),k()):v?a.x=a.y=0:(S(!0),k())};return(o.inverted||this.len>1)&&S(),k(),a},n.prototype.hide=function(e){var t=this;Utilities.clearTimeout(this.hideTimer),e=pick$1l(e,this.options.hideDelay),this.isHidden||(this.hideTimer=syncTimeout$6(function(){t.getLabel().fadeOut(e&&void 0),t.isHidden=!0},e))},n.prototype.init=function(e,t){this.chart=e,this.options=t,this.crosshairs=[],this.now={x:0,y:0},this.isHidden=!0,this.split=t.split&&!e.inverted&&!e.polar,this.shared=t.shared||this.split,this.outside=pick$1l(t.outside,!!(e.scrollablePixelsX||e.scrollablePixelsY))},n.prototype.shouldStickOnContact=function(){return!!(!this.followPointer&&this.options.stickOnContact)},n.prototype.isStickyOnContact=function(){return!!(this.shouldStickOnContact()&&this.inContact)},n.prototype.move=function(e,t,r,o){var s=this,a=s.now,l=s.options.animation!==!1&&!s.isHidden&&(Math.abs(e-a.x)>1||Math.abs(t-a.y)>1),h=s.followPointer||s.len>1;extend$1g(a,{x:l?(2*a.x+e)/3:e,y:l?(a.y+t)/2:t,anchorX:h?void 0:l?(2*a.anchorX+r)/3:r,anchorY:h?void 0:l?(a.anchorY+o)/2:o}),s.getLabel().attr(a),s.drawTracker(),l&&(Utilities.clearTimeout(this.tooltipTimeout),this.tooltipTimeout=setTimeout(function(){s&&s.move(e,t,r,o)},32))},n.prototype.refresh=function(e,t){var r=this,o=this.chart,s=r.options,a=splat$f(e),l=a[0],h=[],d=s.formatter||r.defaultFormatter,c=r.shared,p=o.styledMode,f={};if(s.enabled){Utilities.clearTimeout(this.hideTimer),r.followPointer=!r.split&&l.series.tooltipOptions.followPointer;var u=r.getAnchor(e,t),g=u[0],m=u[1];c&&!(!isArray$i(e)&&e.series&&e.series.noSharedTooltip)?(o.pointer.applyInactiveState(a),a.forEach(function(S){S.setState("hover"),h.push(S.getLabelConfig())}),f={x:l.category,y:l.y},f.points=h):f=l.getLabelConfig(),this.len=h.length;var y=d.call(f,r),v=l.series;if(this.distance=pick$1l(v.tooltipOptions.distance,16),y===!1)this.hide();else{if(r.split)this.renderSplit(y,a);else{var x=g,b=m;if(t&&o.pointer.isDirectTouch&&(x=t.chartX-o.plotLeft,b=t.chartY-o.plotTop),o.polar||v.options.clip===!1||v.shouldShowTooltip(x,b)){var $=r.getLabel();(!s.style.width||p)&&$.css({width:this.chart.spacingBox.width+"px"}),$.attr({text:y&&y.join?y.join(""):y}),$.removeClass(/highcharts-color-[\d]+/g).addClass("highcharts-color-"+pick$1l(l.colorIndex,v.colorIndex)),p||$.attr({stroke:s.borderColor||l.color||v.color||palette.neutralColor60}),r.updatePosition({plotX:g,plotY:m,negative:l.negative,ttBelow:l.ttBelow,h:u[2]||0})}else{r.hide();return}}r.isHidden&&r.label&&r.label.attr({opacity:1}).show(),r.isHidden=!1}fireEvent$w(this,"refresh")}},n.prototype.renderSplit=function(e,t){var r=this,o=r.chart,s=r.chart,a=s.chartWidth,l=s.chartHeight,h=s.plotHeight,d=s.plotLeft,c=s.plotTop,p=s.pointer,f=s.scrollablePixelsY,u=f===void 0?0:f,g=s.scrollablePixelsX,m=s.scrollingContainer,y=m===void 0?{scrollLeft:0,scrollTop:0}:m,v=y.scrollLeft,x=y.scrollTop,b=s.styledMode,$=r.distance,S=r.options,k=r.options.positioner,A=r.outside&&typeof g!="number"?doc$i.documentElement.getBoundingClientRect():{left:v,right:v+a,top:x,bottom:x+l},M=r.getLabel(),P=this.renderer||o.renderer,E=!!(o.xAxis[0]&&o.xAxis[0].opposite),T=p.getChartPosition(),O=T.left,C=T.top,I=c+x,L=0,D=h-u;function N(Y){var Z=Y.isHeader,et=Y.plotX,Q=et===void 0?0:et,tt=Y.plotY,rt=tt===void 0?0:tt,it=Y.series,ot,st;if(Z)ot=d+Q,st=c+h/2;else{var at=it.xAxis,lt=it.yAxis;ot=at.pos+clamp$f(Q,-$,at.len+$),it.shouldShowTooltip(0,lt.pos-c+rt,{ignoreX:!0})&&(st=lt.pos+rt)}return ot=clamp$f(ot,A.left-$,A.right+$),{anchorX:ot,anchorY:st}}function B(Y,Z,et,Q,tt){tt===void 0&&(tt=!0);var rt,it;return et?(rt=E?0:D,it=clamp$f(Y-Q/2,A.left,A.right-Q-(r.outside?O:0))):(rt=Z-I,it=tt?Y-Q-$:Y+$,it=clamp$f(it,tt?it:A.left,A.right)),{x:it,y:rt}}function X(Y,Z,et){var Q=Y,tt=Z.isHeader,rt=Z.series,it="highcharts-color-"+pick$1l(Z.colorIndex,rt.colorIndex,"none");if(!Q){var ot={padding:S.padding,r:S.borderRadius};b||(ot.fill=S.backgroundColor,ot["stroke-width"]=S.borderWidth),Q=P.label("",0,0,S[tt?"headerShape":"shape"],void 0,void 0,S.useHTML).addClass((tt?"highcharts-tooltip-header ":"")+"highcharts-tooltip-box "+it).attr(ot).add(M)}return Q.isActive=!0,Q.attr({text:et}),b||Q.css(S.style).shadow(S.shadow).attr({stroke:S.borderColor||Z.color||rt.color||palette.neutralColor80}),Q}isString$6(e)&&(e=[!1,e]);var W=e.slice(0,t.length+1).reduce(function(Y,Z,et){if(Z!==!1&&Z!==""){var Q=t[et-1]||{isHeader:!0,plotX:t[0].plotX,plotY:h,series:{}},tt=Q.isHeader,rt=tt?r:Q.series,it=rt.tt=X(rt.tt,Q,Z.toString()),ot=it.getBBox(),st=ot.width+it.strokeWidth();tt&&(L=ot.height,D+=L,E&&(I-=L));var at=N(Q),lt=at.anchorX,ht=at.anchorY;if(typeof ht=="number"){var dt=ot.height+1,ct=k?k.call(r,st,dt,Q):B(lt,ht,tt,st);Y.push({align:k?0:void 0,anchorX:lt,anchorY:ht,boxWidth:st,point:Q,rank:pick$1l(ct.rank,tt?1:0),size:dt,target:ct.y,tt:it,x:ct.x})}else it.isActive=!1}return Y},[]);!k&&W.some(function(Y){var Z=r.outside,et=(Z?O:0)+Y.anchorX;return et<A.left&&et+Y.boxWidth<A.right?!0:et<O-A.left+Y.boxWidth&&A.right-et>et})&&(W=W.map(function(Y){var Z=B(Y.anchorX,Y.anchorY,Y.point.isHeader,Y.boxWidth,!1),et=Z.x,Q=Z.y;return extend$1g(Y,{target:Q,x:et})})),r.cleanSplit(),distribute$3(W,D);var F={left:O,right:O};W.forEach(function(Y){var Z=Y.x,et=Y.boxWidth,Q=Y.isHeader;Q||(r.outside&&O+Z<F.left&&(F.left=O+Z),!Q&&r.outside&&F.left+et>F.right&&(F.right=O+Z))}),W.forEach(function(Y){var Z=Y.x,et=Y.anchorX,Q=Y.anchorY,tt=Y.pos,rt=Y.point.isHeader,it={visibility:typeof tt>"u"?"hidden":"inherit",x:Z,y:tt+I,anchorX:et,anchorY:Q};if(r.outside&&Z<et){var ot=O-F.left;ot>0&&(rt||(it.x=Z+ot,it.anchorX=et+ot),rt&&(it.x=(F.right-F.left)/2,it.anchorX=et+ot))}Y.tt.attr(it)});var U=r.container,z=r.outside,V=r.renderer;if(z&&U&&V){var j=M.getBBox(),K=j.width,nt=j.height,q=j.x,J=j.y;V.setSize(K+q,nt+J,!1),U.style.left=F.left+"px",U.style.top=C+"px"}},n.prototype.drawTracker=function(){var e=this;if(e.followPointer||!e.options.stickOnContact){e.tracker&&e.tracker.destroy();return}var t=e.chart,r=e.label,o=e.shared?t.hoverPoints:t.hoverPoint;if(!(!r||!o)){var s={x:0,y:0,width:0,height:0},a=this.getAnchor(o),l=r.getBBox();a[0]+=t.plotLeft-r.translateX,a[1]+=t.plotTop-r.translateY,s.x=Math.min(0,a[0]),s.y=Math.min(0,a[1]),s.width=a[0]<0?Math.max(Math.abs(a[0]),l.width-a[0]):Math.max(Math.abs(a[0]),l.width),s.height=a[1]<0?Math.max(Math.abs(a[1]),l.height-Math.abs(a[1])):Math.max(Math.abs(a[1]),l.height),e.tracker?e.tracker.attr(s):(e.tracker=r.renderer.rect(s).addClass("highcharts-tracker").add(r),t.styledMode||e.tracker.attr({fill:"rgba(0,0,0,0)"}))}},n.prototype.styledModeFormat=function(e){return e.replace('style="font-size: 10px"','class="highcharts-header"').replace(/style="color:{(point|series)\.color}"/g,'class="highcharts-color-{$1.colorIndex}"')},n.prototype.tooltipFooterHeaderFormatter=function(e,t){var r=e.series,o=r.tooltipOptions,s=r.xAxis,a=s&&s.dateTime,l={isFooter:t,labelConfig:e},h=o.xDateFormat,d=o[t?"footerFormat":"headerFormat"];return fireEvent$w(this,"headerFormatter",l,function(c){a&&!h&&isNumber$F(e.key)&&(h=a.getXDateFormat(e.key,o.dateTimeLabelFormats)),a&&h&&(e.point&&e.point.tooltipDateKeys||["key"]).forEach(function(p){d=d.replace("{point."+p+"}","{point."+p+":"+h+"}")}),r.chart.styledMode&&(d=this.styledModeFormat(d)),c.text=format$c(d,{point:e,series:r},this.chart)}),l.text},n.prototype.update=function(e){this.destroy(),merge$1e(!0,this.chart.options.tooltip.userOptions,e),this.init(this.chart,merge$1e(!0,this.options,e))},n.prototype.updatePosition=function(e){var t=this.chart,r=this.options,o=t.pointer,s=this.getLabel(),a=o.getChartPosition(),l=(r.positioner||this.getPosition).call(this,s.width,s.height,e),h=e.plotX+t.plotLeft,d=e.plotY+t.plotTop,c;this.outside&&(c=r.borderWidth+2*this.distance,this.renderer.setSize(s.width+c,s.height+c,!1),(a.scaleX!==1||a.scaleY!==1)&&(css$9(this.container,{transform:"scale("+a.scaleX+", "+a.scaleY+")"}),h*=a.scaleX,d*=a.scaleY),h+=a.left-l.x,d+=a.top-l.y),this.move(Math.round(l.x),Math.round(l.y||0),h,d)},n}(),animObject$9=animationExports.animObject,defaultOptions$c=DefaultOptions.defaultOptions,format$b=FormatUtilities.format,addEvent$X=Utilities.addEvent,defined$K=Utilities.defined,erase$4=Utilities.erase,extend$1f=Utilities.extend,fireEvent$v=Utilities.fireEvent,getNestedProperty$1=Utilities.getNestedProperty,isArray$h=Utilities.isArray,isFunction$2=Utilities.isFunction,isNumber$E=Utilities.isNumber,isObject$b=Utilities.isObject,merge$1d=Utilities.merge,objectEach$q=Utilities.objectEach,pick$1k=Utilities.pick,syncTimeout$5=Utilities.syncTimeout,removeEvent$8=Utilities.removeEvent,uniqueKey$5=Utilities.uniqueKey,Point$2=function(){function n(){this.category=void 0,this.colorIndex=void 0,this.formatPrefix="point",this.id=void 0,this.isNull=!1,this.name=void 0,this.options=void 0,this.percentage=void 0,this.selected=!1,this.series=void 0,this.total=void 0,this.visible=!0,this.x=void 0}return n.prototype.animateBeforeDestroy=function(){var e=this,t={x:e.startXPos,opacity:0},r=e.getGraphicalProps();r.singular.forEach(function(o){var s=o==="dataLabel";e[o]=e[o].animate(s?{x:e[o].startXPos,y:e[o].startYPos,opacity:0}:t)}),r.plural.forEach(function(o){e[o].forEach(function(s){s.element&&s.animate(extend$1f({x:e.startXPos},s.startYPos?{x:s.startXPos,y:s.startYPos}:{}))})})},n.prototype.applyOptions=function(e,t){var r=this,o=r.series,s=o.options.pointValKey||o.pointValKey;return e=n.prototype.optionsToObject.call(this,e),extend$1f(r,e),r.options=r.options?extend$1f(r.options,e):e,e.group&&delete r.group,e.dataLabels&&delete r.dataLabels,s&&(r.y=n.prototype.getNestedProperty.call(r,s)),r.isNull=pick$1k(r.isValid&&!r.isValid(),r.x===null||!isNumber$E(r.y)),r.formatPrefix=r.isNull?"null":"point",r.selected&&(r.state="select"),"name"in r&&typeof t>"u"&&o.xAxis&&o.xAxis.hasNames&&(r.x=o.xAxis.nameToX(r)),typeof r.x>"u"&&o?typeof t>"u"?r.x=o.autoIncrement():r.x=t:isNumber$E(e.x)&&o.options.relativeXValue&&(r.x=o.autoIncrement(e.x)),r},n.prototype.destroy=function(){var e=this,t=e.series,r=t.chart,o=t.options.dataSorting,s=r.hoverPoints,a=e.series.chart.renderer.globalAnimation,l=animObject$9(a),h;function d(){(e.graphic||e.dataLabel||e.dataLabels)&&(removeEvent$8(e),e.destroyElements());for(h in e)e[h]=null}e.legendItem&&r.legend.destroyItem(e),s&&(e.setState(),erase$4(s,e),s.length||(r.hoverPoints=null)),e===r.hoverPoint&&e.onMouseOut(),!o||!o.enabled?d():(this.animateBeforeDestroy(),syncTimeout$5(d,l.duration)),r.pointCount--},n.prototype.destroyElements=function(e){var t=this,r=t.getGraphicalProps(e);r.singular.forEach(function(o){t[o]=t[o].destroy()}),r.plural.forEach(function(o){t[o].forEach(function(s){s.element&&s.destroy()}),delete t[o]})},n.prototype.firePointEvent=function(e,t,r){var o=this,s=this.series,a=s.options;(a.point.events[e]||o.options&&o.options.events&&o.options.events[e])&&o.importEvents(),e==="click"&&a.allowPointSelect&&(r=function(l){o.select&&o.select(null,l.ctrlKey||l.metaKey||l.shiftKey)}),fireEvent$v(o,e,t,r)},n.prototype.getClassName=function(){var e=this;return"highcharts-point"+(e.selected?" highcharts-point-select":"")+(e.negative?" highcharts-negative":"")+(e.isNull?" highcharts-null-point":"")+(typeof e.colorIndex<"u"?" highcharts-color-"+e.colorIndex:"")+(e.options.className?" "+e.options.className:"")+(e.zone&&e.zone.className?" "+e.zone.className.replace("highcharts-negative",""):"")},n.prototype.getGraphicalProps=function(e){var t=this,r=[],o={singular:[],plural:[]},s,a;for(e=e||{graphic:1,dataLabel:1},e.graphic&&r.push("graphic","upperGraphic","shadowGroup"),e.dataLabel&&r.push("dataLabel","dataLabelUpper","connector"),a=r.length;a--;)s=r[a],t[s]&&o.singular.push(s);return["dataLabel","connector"].forEach(function(l){var h=l+"s";e[l]&&t[h]&&o.plural.push(h)}),o},n.prototype.getLabelConfig=function(){return{x:this.category,y:this.y,color:this.color,colorIndex:this.colorIndex,key:this.name||this.category,series:this.series,point:this,percentage:this.percentage,total:this.total||this.stackTotal}},n.prototype.getNestedProperty=function(e){if(e)return e.indexOf("custom.")===0?getNestedProperty$1(e,this.options):this[e]},n.prototype.getZone=function(){var e=this.series,t=e.zones,r=e.zoneAxis||"y",o,s=0;for(o=t[s];this[r]>=o.value;)o=t[++s];return this.nonZonedColor||(this.nonZonedColor=this.color),o&&o.color&&!this.options.color?this.color=o.color:this.color=this.nonZonedColor,o},n.prototype.hasNewShapeType=function(){var e=this,t=e.graphic&&(e.graphic.symbolName||e.graphic.element.nodeName);return t!==this.shapeType},n.prototype.init=function(e,t,r){return this.series=e,this.applyOptions(t,r),this.id=defined$K(this.id)?this.id:uniqueKey$5(),this.resolveColor(),e.chart.pointCount++,fireEvent$v(this,"afterInit"),this},n.prototype.optionsToObject=function(e){var t=this.series,r=t.options.keys,o=r||t.pointArrayMap||["y"],s=o.length,a={},l,h=0,d=0;if(isNumber$E(e)||e===null)a[o[0]]=e;else if(isArray$h(e))for(!r&&e.length>s&&(l=typeof e[0],l==="string"?a.name=e[0]:l==="number"&&(a.x=e[0]),h++);d<s;)(!r||typeof e[h]<"u")&&(o[d].indexOf(".")>0?n.prototype.setNestedProperty(a,e[h],o[d]):a[o[d]]=e[h]),h++,d++;else typeof e=="object"&&(a=e,e.dataLabels&&(t._hasPointLabels=!0),e.marker&&(t._hasPointMarkers=!0));return a},n.prototype.resolveColor=function(){var e=this.series,t=e.chart.options.chart,r=e.chart.styledMode,o,s,a=t.colorCount,l;delete this.nonZonedColor,e.options.colorByPoint?(r||(s=e.options.colors||e.chart.options.colors,o=s[e.colorCounter],a=s.length),l=e.colorCounter,e.colorCounter++,e.colorCounter===a&&(e.colorCounter=0)):(r||(o=e.color),l=e.colorIndex),this.colorIndex=pick$1k(this.options.colorIndex,l),this.color=pick$1k(this.options.color,o)},n.prototype.setNestedProperty=function(e,t,r){var o=r.split(".");return o.reduce(function(s,a,l,h){var d=h.length-1===l;return s[a]=d?t:isObject$b(s[a],!0)?s[a]:{},s[a]},e),e},n.prototype.tooltipFormatter=function(e){var t=this.series,r=t.tooltipOptions,o=pick$1k(r.valueDecimals,""),s=r.valuePrefix||"",a=r.valueSuffix||"";return t.chart.styledMode&&(e=t.chart.tooltip.styledModeFormat(e)),(t.pointArrayMap||["y"]).forEach(function(l){l="{point."+l,(s||a)&&(e=e.replace(RegExp(l+"}","g"),s+l+"}"+a)),e=e.replace(RegExp(l+"}","g"),l+":,."+o+"f}")}),format$b(e,{point:this,series:this.series},t.chart)},n.prototype.update=function(e,t,r,o){var s=this,a=s.series,l=s.graphic,h=a.chart,d=a.options,c;t=pick$1k(t,!0);function p(){s.applyOptions(e);var f=l&&s.hasDummyGraphic,u=s.y===null?!f:f;l&&u&&(s.graphic=l.destroy(),delete s.hasDummyGraphic),isObject$b(e,!0)&&(l&&l.element&&e&&e.marker&&typeof e.marker.symbol<"u"&&(s.graphic=l.destroy()),e&&e.dataLabels&&s.dataLabel&&(s.dataLabel=s.dataLabel.destroy()),s.connector&&(s.connector=s.connector.destroy())),c=s.index,a.updateParallelArrays(s,c),d.data[c]=isObject$b(d.data[c],!0)||isObject$b(e,!0)?s.options:pick$1k(e,d.data[c]),a.isDirty=a.isDirtyData=!0,!a.fixedBox&&a.hasCartesianSeries&&(h.isDirtyBox=!0),d.legendType==="point"&&(h.isDirtyLegend=!0),t&&h.redraw(r)}o===!1?p():s.firePointEvent("update",{options:e},p)},n.prototype.remove=function(e,t){this.series.removePoint(this.series.data.indexOf(this),e,t)},n.prototype.select=function(e,t){var r=this,o=r.series,s=o.chart;e=pick$1k(e,!r.selected),this.selectedStaging=e,r.firePointEvent(e?"select":"unselect",{accumulate:t},function(){r.selected=r.options.selected=e,o.options.data[o.data.indexOf(r)]=r.options,r.setState(e&&"select"),t||s.getSelectedPoints().forEach(function(a){var l=a.series;a.selected&&a!==r&&(a.selected=a.options.selected=!1,l.options.data[l.data.indexOf(a)]=a.options,a.setState(s.hoverPoints&&l.options.inactiveOtherPoints?"inactive":""),a.firePointEvent("unselect"))})}),delete this.selectedStaging},n.prototype.onMouseOver=function(e){var t=this,r=t.series,o=r.chart,s=o.pointer;e=e?s.normalize(e):s.getChartCoordinatesFromPoint(t,o.inverted),s.runPointActions(e,t)},n.prototype.onMouseOut=function(){var e=this,t=e.series.chart;e.firePointEvent("mouseOut"),e.series.options.inactiveOtherPoints||(t.hoverPoints||[]).forEach(function(r){r.setState()}),t.hoverPoints=t.hoverPoint=null},n.prototype.importEvents=function(){if(!this.hasImportedEvents){var e=this,t=merge$1d(e.series.options.point,e.options),r=t.events;e.events=r,objectEach$q(r,function(o,s){isFunction$2(o)&&addEvent$X(e,s,o)}),this.hasImportedEvents=!0}},n.prototype.setState=function(e,t){var r=this,o=r.series,s=r.state,a=o.options.states[e||"normal"]||{},l=defaultOptions$c.plotOptions[o.type].marker&&o.options.marker,h=l&&l.enabled===!1,d=l&&l.states&&l.states[e||"normal"]||{},c=d.enabled===!1,p=r.marker||{},f=o.chart,u=l&&o.markerAttribs,g=o.halo,m,y,v,x=o.stateMarkerGraphic,b;if(e=e||"",!(e===r.state&&!t||r.selected&&e!=="select"||a.enabled===!1||e&&(c||h&&d.enabled===!1)||e&&p.states&&p.states[e]&&p.states[e].enabled===!1)){r.state=e,u&&(m=o.markerAttribs(r,e)),r.graphic&&!r.hasDummyGraphic?(s&&r.graphic.removeClass("highcharts-point-"+s),e&&r.graphic.addClass("highcharts-point-"+e),f.styledMode||(y=o.pointAttribs(r,e),v=pick$1k(f.options.chart.animation,a.animation),o.options.inactiveOtherPoints&&isNumber$E(y.opacity)&&((r.dataLabels||[]).forEach(function(A){A&&A.animate({opacity:y.opacity},v)}),r.connector&&r.connector.animate({opacity:y.opacity},v)),r.graphic.animate(y,v)),m&&r.graphic.animate(m,pick$1k(f.options.chart.animation,d.animation,l.animation)),x&&x.hide()):(e&&d&&(b=p.symbol||o.symbol,x&&x.currentSymbol!==b&&(x=x.destroy()),m&&(x?x[t?"animate":"attr"]({x:m.x,y:m.y}):b&&(o.stateMarkerGraphic=x=f.renderer.symbol(b,m.x,m.y,m.width,m.height).add(o.markerGroup),x.currentSymbol=b)),!f.styledMode&&x&&x.attr(o.pointAttribs(r,e))),x&&(x[e&&r.isInside?"show":"hide"](),x.element.point=r,x.addClass(r.getClassName(),!0)));var $=a.halo,S=r.graphic||x,k=S&&S.visibility||"inherit";$&&$.size&&S&&k!=="hidden"&&!r.isCluster?(g||(o.halo=g=f.renderer.path().add(S.parentGroup)),g.show()[t?"animate":"attr"]({d:r.haloPath($.size)}),g.attr({class:"highcharts-halo highcharts-color-"+pick$1k(r.colorIndex,o.colorIndex)+(r.className?" "+r.className:""),visibility:k,zIndex:-1}),g.point=r,f.styledMode||g.attr(extend$1f({fill:r.color||o.color,"fill-opacity":$.opacity},AST.filterUserAttributes($.attributes||{})))):g&&g.point&&g.point.haloPath&&g.animate({d:g.point.haloPath(0)},null,g.hide),fireEvent$v(r,"afterSetState",{state:e})}},n.prototype.haloPath=function(e){var t=this.series,r=t.chart;return r.renderer.symbols.circle(Math.floor(this.plotX)-e,this.plotY-e,e*2,e*2)},n}(),color$e=Color.parse,charts$3=H.charts,noop$j=H.noop,addEvent$W=Utilities.addEvent,attr$2=Utilities.attr,css$8=Utilities.css,defined$J=Utilities.defined,extend$1e=Utilities.extend,find$i=Utilities.find,fireEvent$u=Utilities.fireEvent,isNumber$D=Utilities.isNumber,isObject$a=Utilities.isObject,objectEach$p=Utilities.objectEach,offset=Utilities.offset,pick$1j=Utilities.pick,splat$e=Utilities.splat,Pointer=function(){function n(e,t){this.lastValidTouch={},this.pinchDown=[],this.runChartClick=!1,this.eventsToUnbind=[],this.chart=e,this.hasDragged=!1,this.options=t,this.init(e,t)}return n.prototype.applyInactiveState=function(e){var t=[],r;(e||[]).forEach(function(o){r=o.series,t.push(r),r.linkedParent&&t.push(r.linkedParent),r.linkedSeries&&(t=t.concat(r.linkedSeries)),r.navigatorSeries&&t.push(r.navigatorSeries)}),this.chart.series.forEach(function(o){t.indexOf(o)===-1?o.setState("inactive",!0):o.options.inactiveOtherPoints&&o.setAllPointsToState("inactive")})},n.prototype.destroy=function(){var e=this;this.eventsToUnbind.forEach(function(t){return t()}),this.eventsToUnbind=[],H.chartCount||(n.unbindDocumentMouseUp&&(n.unbindDocumentMouseUp=n.unbindDocumentMouseUp()),n.unbindDocumentTouchEnd&&(n.unbindDocumentTouchEnd=n.unbindDocumentTouchEnd())),clearInterval(e.tooltipTimeout),objectEach$p(e,function(t,r){e[r]=void 0})},n.prototype.drag=function(e){var t=this.chart,r=t.options.chart,o=this.zoomHor,s=this.zoomVert,a=t.plotLeft,l=t.plotTop,h=t.plotWidth,d=t.plotHeight,c=this.mouseDownX||0,p=this.mouseDownY||0,f=isObject$a(r.panning)?r.panning&&r.panning.enabled:r.panning,u=r.panKey&&e[r.panKey+"Key"],g=e.chartX,m=e.chartY,y,v,x=this.selectionMarker;x&&x.touch||(g<a?g=a:g>a+h&&(g=a+h),m<l?m=l:m>l+d&&(m=l+d),this.hasDragged=Math.sqrt(Math.pow(c-g,2)+Math.pow(p-m,2)),this.hasDragged>10&&(y=t.isInsidePlot(c-a,p-l,{visiblePlotOnly:!0}),t.hasCartesianSeries&&(this.zoomX||this.zoomY)&&y&&!u&&(x||(this.selectionMarker=x=t.renderer.rect(a,l,o?1:h,s?1:d,0).attr({class:"highcharts-selection-marker",zIndex:7}).add(),t.styledMode||x.attr({fill:r.selectionMarkerFill||color$e(palette.highlightColor80).setOpacity(.25).get()}))),x&&o&&(v=g-c,x.attr({width:Math.abs(v),x:(v>0?0:v)+c})),x&&s&&(v=m-p,x.attr({height:Math.abs(v),y:(v>0?0:v)+p})),y&&!x&&f&&t.pan(e,r.panning)))},n.prototype.dragStart=function(e){var t=this.chart;t.mouseIsDown=e.type,t.cancelClick=!1,t.mouseDownX=this.mouseDownX=e.chartX,t.mouseDownY=this.mouseDownY=e.chartY},n.prototype.drop=function(e){var t=this,r=this.chart,o=this.hasPinched;if(this.selectionMarker){var s={originalEvent:e,xAxis:[],yAxis:[]},a=this.selectionMarker,l=a.attr?a.attr("x"):a.x,h=a.attr?a.attr("y"):a.y,d=a.attr?a.attr("width"):a.width,c=a.attr?a.attr("height"):a.height,p;(this.hasDragged||o)&&(r.axes.forEach(function(f){if(f.zoomEnabled&&defined$J(f.min)&&(o||t[{xAxis:"zoomX",yAxis:"zoomY"}[f.coll]])&&isNumber$D(l)&&isNumber$D(h)){var u=f.horiz,g=e.type==="touchend"?f.minPixelPadding:0,m=f.toValue((u?l:h)+g),y=f.toValue((u?l+d:h+c)-g);s[f.coll].push({axis:f,min:Math.min(m,y),max:Math.max(m,y)}),p=!0}}),p&&fireEvent$u(r,"selection",s,function(f){r.zoom(extend$1e(f,o?{animation:!1}:null))})),isNumber$D(r.index)&&(this.selectionMarker=this.selectionMarker.destroy()),o&&this.scaleGroups()}r&&isNumber$D(r.index)&&(css$8(r.container,{cursor:r._cursor}),r.cancelClick=this.hasDragged>10,r.mouseIsDown=this.hasDragged=this.hasPinched=!1,this.pinchDown=[])},n.prototype.findNearestKDPoint=function(e,t,r){var o=this.chart,s=o.hoverPoint,a=o.tooltip;if(s&&a&&a.isStickyOnContact())return s;var l;function h(d,c){var p=d.distX-c.distX,f=d.dist-c.dist,u=(c.series.group&&c.series.group.zIndex)-(d.series.group&&d.series.group.zIndex),g;return p!==0&&t?g=p:f!==0?g=f:u!==0?g=u:g=d.series.index>c.series.index?-1:1,g}return e.forEach(function(d){var c=d.noSharedTooltip&&t,p=!c&&d.options.findNearestPointBy.indexOf("y")<0,f=d.searchPoint(r,p);isObject$a(f,!0)&&f.series&&(!isObject$a(l,!0)||h(l,f)>0)&&(l=f)}),l},n.prototype.getChartCoordinatesFromPoint=function(e,t){var r=e.series,o=r.xAxis,s=r.yAxis,a=e.shapeArgs;if(o&&s){var l=pick$1j(e.clientX,e.plotX),h=e.plotY||0;return e.isNode&&a&&isNumber$D(a.x)&&isNumber$D(a.y)&&(l=a.x,h=a.y),t?{chartX:s.len+s.pos-h,chartY:o.len+o.pos-l}:{chartX:l+o.pos,chartY:h+s.pos}}if(a&&a.x&&a.y)return{chartX:a.x,chartY:a.y}},n.prototype.getChartPosition=function(){if(this.chartPosition)return this.chartPosition;var e=this.chart.container,t=offset(e);this.chartPosition={left:t.left,top:t.top,scaleX:1,scaleY:1};var r=e.offsetWidth,o=e.offsetHeight;return r>2&&o>2&&(this.chartPosition.scaleX=t.width/r,this.chartPosition.scaleY=t.height/o),this.chartPosition},n.prototype.getCoordinates=function(e){var t={xAxis:[],yAxis:[]};return this.chart.axes.forEach(function(r){t[r.isXAxis?"xAxis":"yAxis"].push({axis:r,value:r.toValue(e[r.horiz?"chartX":"chartY"])})}),t},n.prototype.getHoverData=function(e,t,r,o,s,a){var l=[],h=!!(o&&e),d=function(m){return m.visible&&!(!s&&m.directTouch)&&pick$1j(m.options.enableMouseTracking,!0)},c=t,p,f={chartX:a?a.chartX:void 0,chartY:a?a.chartY:void 0,shared:s};fireEvent$u(this,"beforeGetHoverData",f);var u=c&&!c.stickyTracking;p=u?[c]:r.filter(function(m){return f.filter?f.filter(m):d(m)&&m.stickyTracking});var g=h||!a?e:this.findNearestKDPoint(p,s,a);return c=g&&g.series,g&&(s&&!c.noSharedTooltip?(p=r.filter(function(m){return f.filter?f.filter(m):d(m)&&!m.noSharedTooltip}),p.forEach(function(m){var y=find$i(m.points,function(v){return v.x===g.x&&!v.isNull});isObject$a(y)&&(m.chart.isBoosting&&(y=m.getPoint(y)),l.push(y))})):l.push(g)),f={hoverPoint:g},fireEvent$u(this,"afterGetHoverData",f),{hoverPoint:f.hoverPoint,hoverSeries:c,hoverPoints:l}},n.prototype.getPointFromEvent=function(e){for(var t=e.target,r;t&&!r;)r=t.point,t=t.parentNode;return r},n.prototype.onTrackerMouseOut=function(e){var t=this.chart,r=e.relatedTarget||e.toElement,o=t.hoverSeries;this.isDirectTouch=!1,o&&r&&!o.stickyTracking&&!this.inClass(r,"highcharts-tooltip")&&(!this.inClass(r,"highcharts-series-"+o.index)||!this.inClass(r,"highcharts-tracker"))&&o.onMouseOut()},n.prototype.inClass=function(e,t){for(var r;e;){if(r=attr$2(e,"class"),r){if(r.indexOf(t)!==-1)return!0;if(r.indexOf("highcharts-container")!==-1)return!1}e=e.parentNode}},n.prototype.init=function(e,t){this.options=t,this.chart=e,this.runChartClick=!!(t.chart.events&&t.chart.events.click),this.pinchDown=[],this.lastValidTouch={},e.tooltip=new Tooltip(e,t.tooltip),this.followTouchMove=pick$1j(t.tooltip.followTouchMove,!0),this.setDOMEvents()},n.prototype.normalize=function(e,t){var r=e.touches,o=r?r.length?r.item(0):pick$1j(r.changedTouches,e.changedTouches)[0]:e;t||(t=this.getChartPosition());var s=o.pageX-t.left,a=o.pageY-t.top;return s/=t.scaleX,a/=t.scaleY,extend$1e(e,{chartX:Math.round(s),chartY:Math.round(a)})},n.prototype.onContainerClick=function(e){var t=this.chart,r=t.hoverPoint,o=this.normalize(e),s=t.plotLeft,a=t.plotTop;t.cancelClick||(r&&this.inClass(o.target,"highcharts-tracker")?(fireEvent$u(r.series,"click",extend$1e(o,{point:r})),t.hoverPoint&&r.firePointEvent("click",o)):(extend$1e(o,this.getCoordinates(o)),t.isInsidePlot(o.chartX-s,o.chartY-a,{visiblePlotOnly:!0})&&fireEvent$u(t,"click",o)))},n.prototype.onContainerMouseDown=function(e){var t=((e.buttons||e.button)&1)===1;e=this.normalize(e),H.isFirefox&&e.button!==0&&this.onContainerMouseMove(e),(typeof e.button>"u"||t)&&(this.zoomOption(e),t&&e.preventDefault&&e.preventDefault(),this.dragStart(e))},n.prototype.onContainerMouseLeave=function(e){var t=charts$3[pick$1j(n.hoverChartIndex,-1)],r=this.chart.tooltip;r&&r.shouldStickOnContact()&&this.inClass(e.relatedTarget,"highcharts-tooltip-container")||(e=this.normalize(e),t&&(e.relatedTarget||e.toElement)&&(t.pointer.reset(),t.pointer.chartPosition=void 0),r&&!r.isHidden&&this.reset())},n.prototype.onContainerMouseEnter=function(e){delete this.chartPosition},n.prototype.onContainerMouseMove=function(e){var t=this.chart,r=this.normalize(e);this.setHoverChartIndex(),r.preventDefault||(r.returnValue=!1),(t.mouseIsDown==="mousedown"||this.touchSelect(r))&&this.drag(r),!t.openMenu&&(this.inClass(r.target,"highcharts-tracker")||t.isInsidePlot(r.chartX-t.plotLeft,r.chartY-t.plotTop,{visiblePlotOnly:!0}))&&(this.inClass(r.target,"highcharts-no-tooltip")?this.reset(!1,0):this.runPointActions(r))},n.prototype.onDocumentTouchEnd=function(e){var t=charts$3[pick$1j(n.hoverChartIndex,-1)];t&&t.pointer.drop(e)},n.prototype.onContainerTouchMove=function(e){this.touchSelect(e)?this.onContainerMouseMove(e):this.touch(e)},n.prototype.onContainerTouchStart=function(e){this.touchSelect(e)?this.onContainerMouseDown(e):(this.zoomOption(e),this.touch(e,!0))},n.prototype.onDocumentMouseMove=function(e){var t=this.chart,r=this.chartPosition,o=this.normalize(e,r),s=t.tooltip;r&&(!s||!s.isStickyOnContact())&&!t.isInsidePlot(o.chartX-t.plotLeft,o.chartY-t.plotTop,{visiblePlotOnly:!0})&&!this.inClass(o.target,"highcharts-tracker")&&this.reset()},n.prototype.onDocumentMouseUp=function(e){var t=charts$3[pick$1j(n.hoverChartIndex,-1)];t&&t.pointer.drop(e)},n.prototype.pinch=function(e){var t=this,r=t.chart,o=t.pinchDown,s=e.touches||[],a=s.length,l=t.lastValidTouch,h=t.hasZoom,d={},c=a===1&&(t.inClass(e.target,"highcharts-tracker")&&r.runTrackerClick||t.runChartClick),p={},f=t.selectionMarker;a>1?t.initiated=!0:a===1&&this.followTouchMove&&(t.initiated=!1),h&&t.initiated&&!c&&e.cancelable!==!1&&e.preventDefault(),[].map.call(s,function(u){return t.normalize(u)}),e.type==="touchstart"?([].forEach.call(s,function(u,g){o[g]={chartX:u.chartX,chartY:u.chartY}}),l.x=[o[0].chartX,o[1]&&o[1].chartX],l.y=[o[0].chartY,o[1]&&o[1].chartY],r.axes.forEach(function(u){if(u.zoomEnabled){var g=r.bounds[u.horiz?"h":"v"],m=u.minPixelPadding,y=u.toPixels(Math.min(pick$1j(u.options.min,u.dataMin),u.dataMin)),v=u.toPixels(Math.max(pick$1j(u.options.max,u.dataMax),u.dataMax)),x=Math.min(y,v),b=Math.max(y,v);g.min=Math.min(u.pos,x-m),g.max=Math.max(u.pos+u.len,b+m)}}),t.res=!0):t.followTouchMove&&a===1?this.runPointActions(t.normalize(e)):o.length&&(f||(t.selectionMarker=f=extend$1e({destroy:noop$j,touch:!0},r.plotBox)),t.pinchTranslate(o,s,d,f,p,l),t.hasPinched=h,t.scaleGroups(d,p),t.res&&(t.res=!1,this.reset(!1,0)))},n.prototype.pinchTranslate=function(e,t,r,o,s,a){this.zoomHor&&this.pinchTranslateDirection(!0,e,t,r,o,s,a),this.zoomVert&&this.pinchTranslateDirection(!1,e,t,r,o,s,a)},n.prototype.pinchTranslateDirection=function(e,t,r,o,s,a,l,h){var d=this.chart,c=e?"x":"y",p=e?"X":"Y",f="chart"+p,u=e?"width":"height",g=d["plot"+(e?"Left":"Top")],m=d.inverted,y=d.bounds[e?"h":"v"],v=t.length===1,x=t[0][f],b=!v&&t[1][f],$=function(){typeof E=="number"&&Math.abs(x-b)>20&&(M=h||Math.abs(P-E)/Math.abs(x-b)),A=(g-P)/M+x,S=d["plot"+(e?"Width":"Height")]/M},S,k,A,M=h||1,P=r[0][f],E=!v&&r[1][f],T;$(),k=A,k<y.min?(k=y.min,T=!0):k+S>y.max&&(k=y.max-S,T=!0),T?(P-=.8*(P-l[c][0]),typeof E=="number"&&(E-=.8*(E-l[c][1])),$()):l[c]=[P,E],m||(a[c]=A-g,a[u]=S);var O=m?e?"scaleY":"scaleX":"scale"+p,C=m?1/M:M;s[u]=S,s[c]=k,o[O]=M,o["translate"+p]=C*g+(P-C*x)},n.prototype.reset=function(e,t){var r=this,o=r.chart,s=o.hoverSeries,a=o.hoverPoint,l=o.hoverPoints,h=o.tooltip,d=h&&h.shared?l:a;e&&d&&splat$e(d).forEach(function(c){c.series.isCartesian&&typeof c.plotX>"u"&&(e=!1)}),e?h&&d&&splat$e(d).length&&(h.refresh(d),h.shared&&l?l.forEach(function(c){c.setState(c.state,!0),c.series.isCartesian&&(c.series.xAxis.crosshair&&c.series.xAxis.drawCrosshair(null,c),c.series.yAxis.crosshair&&c.series.yAxis.drawCrosshair(null,c))}):a&&(a.setState(a.state,!0),o.axes.forEach(function(c){c.crosshair&&a.series[c.coll]===c&&c.drawCrosshair(null,a)}))):(a&&a.onMouseOut(),l&&l.forEach(function(c){c.setState()}),s&&s.onMouseOut(),h&&h.hide(t),r.unDocMouseMove&&(r.unDocMouseMove=r.unDocMouseMove()),o.axes.forEach(function(c){c.hideCrosshair()}),r.hoverX=o.hoverPoints=o.hoverPoint=null)},n.prototype.runPointActions=function(e,t){var r=this,o=r.chart,s=o.series,a=o.tooltip&&o.tooltip.options.enabled?o.tooltip:void 0,l=a?a.shared:!1,h=t||o.hoverPoint,d=h&&h.series||o.hoverSeries,c=(!e||e.type!=="touchmove")&&(!!t||d&&d.directTouch&&r.isDirectTouch),p=this.getHoverData(h,d,s,c,l,e);h=p.hoverPoint,d=p.hoverSeries;var f=p.hoverPoints,u=d&&d.tooltipOptions.followPointer&&!d.tooltipOptions.split,g=l&&d&&!d.noSharedTooltip;if(h&&(h!==o.hoverPoint||a&&a.isHidden)){if((o.hoverPoints||[]).forEach(function(y){f.indexOf(y)===-1&&y.setState()}),o.hoverSeries!==d&&d.onMouseOver(),r.applyInactiveState(f),(f||[]).forEach(function(y){y.setState("hover")}),o.hoverPoint&&o.hoverPoint.firePointEvent("mouseOut"),!h.series)return;o.hoverPoints=f,o.hoverPoint=h,h.firePointEvent("mouseOver"),a&&a.refresh(g?f:h,e)}else if(u&&a&&!a.isHidden){var m=a.getAnchor([{}],e);o.isInsidePlot(m[0],m[1],{visiblePlotOnly:!0})&&a.updatePosition({plotX:m[0],plotY:m[1]})}r.unDocMouseMove||(r.unDocMouseMove=addEvent$W(o.container.ownerDocument,"mousemove",function(y){var v=charts$3[n.hoverChartIndex];v&&v.pointer.onDocumentMouseMove(y)}),r.eventsToUnbind.push(r.unDocMouseMove)),o.axes.forEach(function(v){var x=pick$1j((v.crosshair||{}).snap,!0),b;x&&(b=o.hoverPoint,(!b||b.series[v.coll]!==v)&&(b=find$i(f,function($){return $.series[v.coll]===v}))),b||!x?v.drawCrosshair(e,b):v.hideCrosshair()})},n.prototype.scaleGroups=function(e,t){var r=this.chart;r.series.forEach(function(o){var s=e||o.getPlotBox();o.xAxis&&o.xAxis.zoomEnabled&&o.group&&(o.group.attr(s),o.markerGroup&&(o.markerGroup.attr(s),o.markerGroup.clip(t?r.clipRect:null)),o.dataLabelsGroup&&o.dataLabelsGroup.attr(s))}),r.clipRect.attr(t||r.clipBox)},n.prototype.setDOMEvents=function(){var e=this,t=this.chart.container,r=t.ownerDocument;t.onmousedown=this.onContainerMouseDown.bind(this),t.onmousemove=this.onContainerMouseMove.bind(this),t.onclick=this.onContainerClick.bind(this),this.eventsToUnbind.push(addEvent$W(t,"mouseenter",this.onContainerMouseEnter.bind(this))),this.eventsToUnbind.push(addEvent$W(t,"mouseleave",this.onContainerMouseLeave.bind(this))),n.unbindDocumentMouseUp||(n.unbindDocumentMouseUp=addEvent$W(r,"mouseup",this.onDocumentMouseUp.bind(this)));for(var o=this.chart.renderTo.parentElement;o&&o.tagName!=="BODY";)this.eventsToUnbind.push(addEvent$W(o,"scroll",function(){delete e.chartPosition})),o=o.parentElement;H.hasTouch&&(this.eventsToUnbind.push(addEvent$W(t,"touchstart",this.onContainerTouchStart.bind(this),{passive:!1})),this.eventsToUnbind.push(addEvent$W(t,"touchmove",this.onContainerTouchMove.bind(this),{passive:!1})),n.unbindDocumentTouchEnd||(n.unbindDocumentTouchEnd=addEvent$W(r,"touchend",this.onDocumentTouchEnd.bind(this),{passive:!1})))},n.prototype.setHoverChartIndex=function(){var e=this.chart,t=H.charts[pick$1j(n.hoverChartIndex,-1)];t&&t!==e&&t.pointer.onContainerMouseLeave({relatedTarget:!0}),(!t||!t.mouseIsDown)&&(n.hoverChartIndex=e.index)},n.prototype.touch=function(e,t){var r=this.chart,o,s,a;this.setHoverChartIndex(),e.touches.length===1?(e=this.normalize(e),a=r.isInsidePlot(e.chartX-r.plotLeft,e.chartY-r.plotTop,{visiblePlotOnly:!0}),a&&!r.openMenu?(t&&this.runPointActions(e),e.type==="touchmove"&&(s=this.pinchDown,o=s[0]?Math.sqrt(Math.pow(s[0].chartX-e.chartX,2)+Math.pow(s[0].chartY-e.chartY,2))>=4:!1),pick$1j(o,!0)&&this.pinch(e)):t&&this.reset()):e.touches.length===2&&this.pinch(e)},n.prototype.touchSelect=function(e){return!!(this.chart.options.chart.zoomBySingleTouch&&e.touches&&e.touches.length===1)},n.prototype.zoomOption=function(e){var t=this.chart,r=t.options.chart,o=t.inverted,s=r.zoomType||"",a,l;/touch/.test(e.type)&&(s=pick$1j(r.pinchType,s)),this.zoomX=a=/x/.test(s),this.zoomY=l=/y/.test(s),this.zoomHor=a&&!o||l&&o,this.zoomVert=l&&!o||a&&o,this.hasZoom=a||l},n}(),__extends$V=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),charts$2=H.charts,doc$h=H.doc,noop$i=H.noop,win$a=H.win,addEvent$V=Utilities.addEvent,css$7=Utilities.css,objectEach$o=Utilities.objectEach,removeEvent$7=Utilities.removeEvent,touches={},hasPointerEvent=!!win$a.PointerEvent;function getWebkitTouches(){var n=[];return n.item=function(e){return this[e]},objectEach$o(touches,function(e){n.push({pageX:e.pageX,pageY:e.pageY,target:e.target})}),n}function translateMSPointer(n,e,t,r){var o=charts$2[Pointer.hoverChartIndex||NaN];if((n.pointerType==="touch"||n.pointerType===n.MSPOINTER_TYPE_TOUCH)&&o){var s=o.pointer;r(n),s[e]({type:t,target:n.currentTarget,preventDefault:noop$i,touches:getWebkitTouches()})}}var MSPointer=function(n){__extends$V(e,n);function e(){return n!==null&&n.apply(this,arguments)||this}return e.isRequired=function(){return!!(!H.hasTouch&&(win$a.PointerEvent||win$a.MSPointerEvent))},e.prototype.batchMSEvents=function(t){t(this.chart.container,hasPointerEvent?"pointerdown":"MSPointerDown",this.onContainerPointerDown),t(this.chart.container,hasPointerEvent?"pointermove":"MSPointerMove",this.onContainerPointerMove),t(doc$h,hasPointerEvent?"pointerup":"MSPointerUp",this.onDocumentPointerUp)},e.prototype.destroy=function(){this.batchMSEvents(removeEvent$7),n.prototype.destroy.call(this)},e.prototype.init=function(t,r){n.prototype.init.call(this,t,r),this.hasZoom&&css$7(t.container,{"-ms-touch-action":"none","touch-action":"none"})},e.prototype.onContainerPointerDown=function(t){translateMSPointer(t,"onContainerTouchStart","touchstart",function(r){touches[r.pointerId]={pageX:r.pageX,pageY:r.pageY,target:r.currentTarget}})},e.prototype.onContainerPointerMove=function(t){translateMSPointer(t,"onContainerTouchMove","touchmove",function(r){touches[r.pointerId]={pageX:r.pageX,pageY:r.pageY},touches[r.pointerId].target||(touches[r.pointerId].target=r.currentTarget)})},e.prototype.onDocumentPointerUp=function(t){translateMSPointer(t,"onDocumentTouchEnd","touchend",function(r){delete touches[r.pointerId]})},e.prototype.setDOMEvents=function(){n.prototype.setDOMEvents.call(this),(this.hasZoom||this.followTouchMove)&&this.batchMSEvents(addEvent$V)},e}(Pointer),animObject$8=animationExports.animObject,setAnimation$4=animationExports.setAnimation,format$a=FormatUtilities.format,isFirefox$1=H.isFirefox,marginNames$1=H.marginNames,win$9=H.win,distribute$2=R.distribute,addEvent$U=Utilities.addEvent,createElement$6=Utilities.createElement,css$6=Utilities.css,defined$I=Utilities.defined,discardElement$4=Utilities.discardElement,find$h=Utilities.find,fireEvent$t=Utilities.fireEvent,isNumber$C=Utilities.isNumber,merge$1c=Utilities.merge,pick$1i=Utilities.pick,relativeLength$8=Utilities.relativeLength,stableSort$5=Utilities.stableSort,syncTimeout$4=Utilities.syncTimeout,wrap$c=Utilities.wrap,Legend=function(){function n(e,t){this.allItems=[],this.box=void 0,this.contentGroup=void 0,this.display=!1,this.group=void 0,this.initialItemY=0,this.itemHeight=0,this.itemMarginBottom=0,this.itemMarginTop=0,this.itemX=0,this.itemY=0,this.lastItemY=0,this.lastLineHeight=0,this.legendHeight=0,this.legendWidth=0,this.maxItemWidth=0,this.maxLegendWidth=0,this.offsetWidth=0,this.options={},this.padding=0,this.pages=[],this.proximate=!1,this.scrollGroup=void 0,this.symbolHeight=0,this.symbolWidth=0,this.titleHeight=0,this.totalItemWidth=0,this.widthOption=0,this.chart=e,this.init(e,t)}return n.prototype.init=function(e,t){this.chart=e,this.setOptions(t),t.enabled&&(this.render(),addEvent$U(this.chart,"endResize",function(){this.legend.positionCheckboxes()}),this.proximate?this.unchartrender=addEvent$U(this.chart,"render",function(){this.legend.proximatePositions(),this.legend.positionItems()}):this.unchartrender&&this.unchartrender())},n.prototype.setOptions=function(e){var t=pick$1i(e.padding,8);this.options=e,this.chart.styledMode||(this.itemStyle=e.itemStyle,this.itemHiddenStyle=merge$1c(this.itemStyle,e.itemHiddenStyle)),this.itemMarginTop=e.itemMarginTop||0,this.itemMarginBottom=e.itemMarginBottom||0,this.padding=t,this.initialItemY=t-5,this.symbolWidth=pick$1i(e.symbolWidth,16),this.pages=[],this.proximate=e.layout==="proximate"&&!this.chart.inverted,this.baseline=void 0},n.prototype.update=function(e,t){var r=this.chart;this.setOptions(merge$1c(!0,this.options,e)),this.destroy(),r.isDirtyLegend=r.isDirtyBox=!0,pick$1i(t,!0)&&r.redraw(),fireEvent$t(this,"afterUpdate")},n.prototype.colorizeItem=function(e,t){if(e.legendGroup[t?"removeClass":"addClass"]("highcharts-legend-item-hidden"),!this.chart.styledMode){var r=this,o=r.options,s=e.legendItem,a=e.legendLine,l=e.legendSymbol,h=r.itemHiddenStyle.color,d=t?o.itemStyle.color:h,c=t&&e.color||h,p=e.options&&e.options.marker,f={fill:c};s&&s.css({fill:d,color:d}),a&&a.attr({stroke:c}),l&&(p&&l.isMarker&&(f=e.pointAttribs(),t||(f.stroke=f.fill=h)),l.attr(f))}fireEvent$t(this,"afterColorizeItem",{item:e,visible:t})},n.prototype.positionItems=function(){this.allItems.forEach(this.positionItem,this),this.chart.isResizing||this.positionCheckboxes()},n.prototype.positionItem=function(e){var t=this,r=this,o=r.options,s=o.symbolPadding,a=!o.rtl,l=e._legendItemPos,h=l[0],d=l[1],c=e.checkbox,p=e.legendGroup;if(p&&p.element){var f={translateX:a?h:r.legendWidth-h-2*s-4,translateY:d},u=function(){fireEvent$t(t,"afterPositionItem",{item:e})};defined$I(p.translateY)?p.animate(f,void 0,u):(p.attr(f),u())}c&&(c.x=h,c.y=d)},n.prototype.destroyItem=function(e){var t=e.checkbox;["legendItem","legendLine","legendSymbol","legendGroup"].forEach(function(r){e[r]&&(e[r]=e[r].destroy())}),t&&discardElement$4(e.checkbox)},n.prototype.destroy=function(){function e(t){this[t]&&(this[t]=this[t].destroy())}this.getAllItems().forEach(function(t){["legendItem","legendGroup"].forEach(e,t)}),["clipRect","up","down","pager","nav","box","title","group"].forEach(e,this),this.display=null},n.prototype.positionCheckboxes=function(){var e=this.group&&this.group.alignAttr,t=this.clipHeight||this.legendHeight,r=this.titleHeight,o;e&&(o=e.translateY,this.allItems.forEach(function(s){var a=s.checkbox,l;a&&(l=o+r+a.y+(this.scrollOffset||0)+3,css$6(a,{left:e.translateX+s.checkboxOffset+a.x-20+"px",top:l+"px",display:this.proximate||l>o-6&&l<o+t-6?"":"none"}))},this))},n.prototype.renderTitle=function(){var e=this.options,t=this.padding,r=e.title,o,s=0;r.text&&(this.title||(this.title=this.chart.renderer.label(r.text,t-3,t-4,null,null,null,e.useHTML,null,"legend-title").attr({zIndex:1}),this.chart.styledMode||this.title.css(r.style),this.title.add(this.group)),r.width||this.title.css({width:this.maxLegendWidth+"px"}),o=this.title.getBBox(),s=o.height,this.offsetWidth=o.width,this.contentGroup.attr({translateY:s})),this.titleHeight=s},n.prototype.setText=function(e){var t=this.options;e.legendItem.attr({text:t.labelFormat?format$a(t.labelFormat,e,this.chart):t.labelFormatter.call(e)})},n.prototype.renderItem=function(e){var t=this,r=t.chart,o=r.renderer,s=t.options,a=s.layout==="horizontal",l=t.symbolWidth,h=s.symbolPadding||0,d=t.itemStyle,c=t.itemHiddenStyle,p=a?pick$1i(s.itemDistance,20):0,f=!s.rtl,u=!e.series,g=!u&&e.series.drawLegendSymbol?e.series:e,m=g.options,y=t.createCheckboxForItem&&m&&m.showCheckbox,v=s.useHTML,x=e.options.className,b=e.legendItem,$=l+h+p+(y?20:0);b||(e.legendGroup=o.g("legend-item").addClass("highcharts-"+g.type+"-series highcharts-color-"+e.colorIndex+(x?" "+x:"")+(u?" highcharts-series-"+e.index:"")).attr({zIndex:1}).add(t.scrollGroup),e.legendItem=b=o.text("",f?l+h:-h,t.baseline||0,v),r.styledMode||b.css(merge$1c(e.visible?d:c)),b.attr({align:f?"left":"right",zIndex:2}).add(e.legendGroup),t.baseline||(t.fontMetrics=o.fontMetrics(r.styledMode?12:d.fontSize,b),t.baseline=t.fontMetrics.f+3+t.itemMarginTop,b.attr("y",t.baseline),t.symbolHeight=s.symbolHeight||t.fontMetrics.f,s.squareSymbol&&(t.symbolWidth=pick$1i(s.symbolWidth,Math.max(t.symbolHeight,16)),$=t.symbolWidth+h+p+(y?20:0),f&&b.attr("x",t.symbolWidth+h))),g.drawLegendSymbol(t,e),t.setItemEvents&&t.setItemEvents(e,b,v)),y&&!e.checkbox&&t.createCheckboxForItem&&t.createCheckboxForItem(e),t.colorizeItem(e,e.visible),(r.styledMode||!d.width)&&b.css({width:(s.itemWidth||t.widthOption||r.spacingBox.width)-$+"px"}),t.setText(e);var S=b.getBBox();e.itemWidth=e.checkboxOffset=s.itemWidth||e.legendItemWidth||S.width+$,t.maxItemWidth=Math.max(t.maxItemWidth,e.itemWidth),t.totalItemWidth+=e.itemWidth,t.itemHeight=e.itemHeight=Math.round(e.legendItemHeight||S.height||t.symbolHeight)},n.prototype.layoutItem=function(e){var t=this.options,r=this.padding,o=t.layout==="horizontal",s=e.itemHeight,a=this.itemMarginBottom,l=this.itemMarginTop,h=o?pick$1i(t.itemDistance,20):0,d=this.maxLegendWidth,c=t.alignColumns&&this.totalItemWidth>d?this.maxItemWidth:e.itemWidth;o&&this.itemX-r+c>d&&(this.itemX=r,this.lastLineHeight&&(this.itemY+=l+this.lastLineHeight+a),this.lastLineHeight=0),this.lastItemY=l+this.itemY+a,this.lastLineHeight=Math.max(s,this.lastLineHeight),e._legendItemPos=[this.itemX,this.itemY],o?this.itemX+=c:(this.itemY+=l+s+a,this.lastLineHeight=s),this.offsetWidth=this.widthOption||Math.max((o?this.itemX-r-(e.checkbox?0:h):c)+r,this.offsetWidth)},n.prototype.getAllItems=function(){var e=[];return this.chart.series.forEach(function(t){var r=t&&t.options;t&&pick$1i(r.showInLegend,defined$I(r.linkedTo)?!1:void 0,!0)&&(e=e.concat(t.legendItems||(r.legendType==="point"?t.data:t)))}),fireEvent$t(this,"afterGetAllItems",{allItems:e}),e},n.prototype.getAlignment=function(){var e=this.options;return this.proximate?e.align.charAt(0)+"tv":e.floating?"":e.align.charAt(0)+e.verticalAlign.charAt(0)+e.layout.charAt(0)},n.prototype.adjustMargins=function(e,t){var r=this.chart,o=this.options,s=this.getAlignment();s&&[/(lth|ct|rth)/,/(rtv|rm|rbv)/,/(rbh|cb|lbh)/,/(lbv|lm|ltv)/].forEach(function(a,l){a.test(s)&&!defined$I(e[l])&&(r[marginNames$1[l]]=Math.max(r[marginNames$1[l]],r.legend[(l+1)%2?"legendHeight":"legendWidth"]+[1,-1,-1,1][l]*o[l%2?"x":"y"]+pick$1i(o.margin,12)+t[l]+(r.titleOffset[l]||0)))})},n.prototype.proximatePositions=function(){var e=this.chart,t=[],r=this.options.align==="left";this.allItems.forEach(function(o){var s,a,l=r,h,d;o.yAxis&&(o.xAxis.options.reversed&&(l=!l),o.points&&(s=find$h(l?o.points:o.points.slice(0).reverse(),function(c){return isNumber$C(c.plotY)})),a=this.itemMarginTop+o.legendItem.getBBox().height+this.itemMarginBottom,d=o.yAxis.top-e.plotTop,o.visible?(h=s?s.plotY:o.yAxis.height,h+=d-.3*a):h=d+o.yAxis.height,t.push({target:h,size:a,item:o}))},this),distribute$2(t,e.plotHeight).forEach(function(o){o.item._legendItemPos&&(o.item._legendItemPos[1]=e.plotTop-e.spacing[0]+o.pos)})},n.prototype.render=function(){var e=this,t=e.chart,r=t.renderer,o=e.options,s=e.padding,a=e.getAllItems(),l,h,d,c=e.group,p,f=e.box;e.itemX=s,e.itemY=e.initialItemY,e.offsetWidth=0,e.lastItemY=0,e.widthOption=relativeLength$8(o.width,t.spacingBox.width-s),p=t.spacingBox.width-2*s-o.x,["rm","lm"].indexOf(e.getAlignment().substring(0,2))>-1&&(p/=2),e.maxLegendWidth=e.widthOption||p,c||(e.group=c=r.g("legend").addClass(o.className||"").attr({zIndex:7}).add(),e.contentGroup=r.g().attr({zIndex:1}).add(c),e.scrollGroup=r.g().add(e.contentGroup)),e.renderTitle(),stableSort$5(a,function(u,g){return(u.options&&u.options.legendIndex||0)-(g.options&&g.options.legendIndex||0)}),o.reversed&&a.reverse(),e.allItems=a,e.display=l=!!a.length,e.lastLineHeight=0,e.maxItemWidth=0,e.totalItemWidth=0,e.itemHeight=0,a.forEach(e.renderItem,e),a.forEach(e.layoutItem,e),h=(e.widthOption||e.offsetWidth)+s,d=e.lastItemY+e.lastLineHeight+e.titleHeight,d=e.handleOverflow(d),d+=s,f||(e.box=f=r.rect().addClass("highcharts-legend-box").attr({r:o.borderRadius}).add(c),f.isNew=!0),t.styledMode||f.attr({stroke:o.borderColor,"stroke-width":o.borderWidth||0,fill:o.backgroundColor||"none"}).shadow(o.shadow),h>0&&d>0&&(f[f.isNew?"attr":"animate"](f.crisp.call({},{x:0,y:0,width:h,height:d},f.strokeWidth())),f.isNew=!1),f[l?"show":"hide"](),t.styledMode&&c.getStyle("display")==="none"&&(h=d=0),e.legendWidth=h,e.legendHeight=d,l&&e.align(),this.proximate||this.positionItems(),fireEvent$t(this,"afterRender")},n.prototype.align=function(e){e===void 0&&(e=this.chart.spacingBox);var t=this.chart,r=this.options,o=e.y;/(lth|ct|rth)/.test(this.getAlignment())&&t.titleOffset[0]>0?o+=t.titleOffset[0]:/(lbh|cb|rbh)/.test(this.getAlignment())&&t.titleOffset[2]>0&&(o-=t.titleOffset[2]),o!==e.y&&(e=merge$1c(e,{y:o})),this.group.align(merge$1c(r,{width:this.legendWidth,height:this.legendHeight,verticalAlign:this.proximate?"top":r.verticalAlign}),!0,e)},n.prototype.handleOverflow=function(e){var t=this,r=this.chart,o=r.renderer,s=this.options,a=s.y,l=s.verticalAlign==="top",h=this.padding,d=s.maxHeight,c=s.navigation,p=pick$1i(c.animation,!0),f=c.arrowSize||12,u=this.pages,g=this.allItems,m=function(k){typeof k=="number"?S.attr({height:k}):S&&(t.clipRect=S.destroy(),t.contentGroup.clip()),t.contentGroup.div&&(t.contentGroup.div.style.clip=k?"rect("+h+"px,9999px,"+(h+k)+"px,0)":"auto")},y=function(k){return t[k]=o.circle(0,0,f*1.3).translate(f/2,f/2).add($),r.styledMode||t[k].attr("fill","rgba(0,0,0,0.0001)"),t[k]},v,x,b=r.spacingBox.height+(l?-a:a)-h,$=this.nav,S=this.clipRect;return s.layout==="horizontal"&&s.verticalAlign!=="middle"&&!s.floating&&(b/=2),d&&(b=Math.min(b,d)),u.length=0,e&&b>0&&e>b&&c.enabled!==!1?(this.clipHeight=v=Math.max(b-20-this.titleHeight-h,0),this.currentPage=pick$1i(this.currentPage,1),this.fullHeight=e,g.forEach(function(k,A){var M=k._legendItemPos[1],P=Math.round(k.legendItem.getBBox().height),E=u.length;(!E||M-u[E-1]>v&&(x||M)!==u[E-1])&&(u.push(x||M),E++),k.pageIx=E-1,x&&(g[A-1].pageIx=E-1),A===g.length-1&&M+P-u[E-1]>v&&M!==x&&(u.push(M),k.pageIx=E),M!==x&&(x=M)}),S||(S=t.clipRect=o.clipRect(0,h,9999,0),t.contentGroup.clip(S)),m(v),$||(this.nav=$=o.g().attr({zIndex:1}).add(this.group),this.up=o.symbol("triangle",0,0,f,f).add($),y("upTracker").on("click",function(){t.scroll(-1,p)}),this.pager=o.text("",15,10).addClass("highcharts-legend-navigation"),r.styledMode||this.pager.css(c.style),this.pager.add($),this.down=o.symbol("triangle-down",0,0,f,f).add($),y("downTracker").on("click",function(){t.scroll(1,p)})),t.scroll(0),e=b):$&&(m(),this.nav=$.destroy(),this.scrollGroup.attr({translateY:1}),this.clipHeight=0),e},n.prototype.scroll=function(e,t){var r=this,o=this.chart,s=this.pages,a=s.length,l=this.clipHeight,h=this.options.navigation,d=this.pager,c=this.padding,p=this.currentPage+e;if(p>a&&(p=a),p>0){typeof t<"u"&&setAnimation$4(t,o),this.nav.attr({translateX:c,translateY:l+this.padding+7+this.titleHeight,visibility:"visible"}),[this.up,this.upTracker].forEach(function(u){u.attr({class:p===1?"highcharts-legend-nav-inactive":"highcharts-legend-nav-active"})}),d.attr({text:p+"/"+a}),[this.down,this.downTracker].forEach(function(u){u.attr({x:18+this.pager.getBBox().width,class:p===a?"highcharts-legend-nav-inactive":"highcharts-legend-nav-active"})},this),o.styledMode||(this.up.attr({fill:p===1?h.inactiveColor:h.activeColor}),this.upTracker.css({cursor:p===1?"default":"pointer"}),this.down.attr({fill:p===a?h.inactiveColor:h.activeColor}),this.downTracker.css({cursor:p===a?"default":"pointer"})),this.scrollOffset=-s[p-1]+this.initialItemY,this.scrollGroup.animate({translateY:this.scrollOffset}),this.currentPage=p,this.positionCheckboxes();var f=animObject$8(pick$1i(t,o.renderer.globalAnimation,!0));syncTimeout$4(function(){fireEvent$t(r,"afterScroll",{currentPage:p})},f.duration)}},n.prototype.setItemEvents=function(e,t,r){var o=this,s=o.chart.renderer.boxWrapper,a=e instanceof Point$2,l="highcharts-legend-"+(a?"point":"series")+"-active",h=o.chart.styledMode,d=r?[t,e.legendSymbol]:[e.legendGroup],c=function(p){o.allItems.forEach(function(f){e!==f&&[f].concat(f.linkedSeries||[]).forEach(function(u){u.setState(p,!a)})})};d.forEach(function(p){p&&p.on("mouseover",function(){e.visible&&c("inactive"),e.setState("hover"),e.visible&&s.addClass(l),h||t.css(o.options.itemHoverStyle)}).on("mouseout",function(){o.chart.styledMode||t.css(merge$1c(e.visible?o.itemStyle:o.itemHiddenStyle)),c(""),s.removeClass(l),e.setState()}).on("click",function(f){var u="legendItemClick",g=function(){e.setVisible&&e.setVisible(),c(e.visible?"inactive":"")};s.removeClass(l),f={browserEvent:f},e.firePointEvent?e.firePointEvent(u,f,g):fireEvent$t(e,u,f,g)})})},n.prototype.createCheckboxForItem=function(e){var t=this;e.checkbox=createElement$6("input",{type:"checkbox",className:"highcharts-legend-checkbox",checked:e.selected,defaultChecked:e.selected},t.options.itemCheckboxStyle,t.chart.container),addEvent$U(e.checkbox,"click",function(r){var o=r.target;fireEvent$t(e.series||e,"checkboxClick",{checked:o.checked,item:e},function(){e.select()})})},n}();(/Trident\/7\.0/.test(win$9.navigator&&win$9.navigator.userAgent)||isFirefox$1)&&wrap$c(Legend.prototype,"positionItem",function(n,e){var t=this,r=function(){e._legendItemPos&&n.call(t,e)};r(),t.bubbleLegend||setTimeout(r)});var defaultOptions$b=DefaultOptions.defaultOptions,error$6=Utilities.error,extendClass$1=Utilities.extendClass,merge$1b=Utilities.merge,SeriesRegistry;(function(n){n.seriesTypes=H.seriesTypes;function e(o,s){s===void 0&&(s={});var a=o.options.chart,l=s.type||a.type||a.defaultSeriesType||"",h=n.seriesTypes[l];n||error$6(17,!0,o,{missingModuleFor:l});var d=new h;return typeof d.init=="function"&&d.init(o,s),d}n.getSeries=e;function t(o,s){var a=defaultOptions$b.plotOptions||{},l=s.defaultOptions;s.prototype.pointClass||(s.prototype.pointClass=Point$2),s.prototype.type=o,l&&(a[o]=l),n.seriesTypes[o]=s}n.registerSeriesType=t;function r(o,s,a,l,h){var d=defaultOptions$b.plotOptions||{};return s=s||"",d[o]=merge$1b(d[s],a),t(o,extendClass$1(n.seriesTypes[s]||function(){},l)),n.seriesTypes[o].prototype.type=o,h&&(n.seriesTypes[o].prototype.pointClass=extendClass$1(Point$2,h)),n.seriesTypes[o]}n.seriesType=r})(SeriesRegistry||(SeriesRegistry={}));const SeriesRegistry$1=SeriesRegistry;var animate=animationExports.animate,animObject$7=animationExports.animObject,setAnimation$3=animationExports.setAnimation,numberFormat$1=FormatUtilities.numberFormat,registerEventOptions$1=exports$3.registerEventOptions,charts$1=H.charts,doc$g=H.doc,marginNames=H.marginNames,svg$3=H.svg,win$8=H.win,defaultOptions$a=DefaultOptions.defaultOptions,defaultTime=DefaultOptions.defaultTime,seriesTypes$7=SeriesRegistry$1.seriesTypes,addEvent$T=Utilities.addEvent,attr$1=Utilities.attr,cleanRecursively$1=Utilities.cleanRecursively,createElement$5=Utilities.createElement,css$5=Utilities.css,defined$H=Utilities.defined,discardElement$3=Utilities.discardElement,erase$3=Utilities.erase,error$5=Utilities.error,extend$1d=Utilities.extend,find$g=Utilities.find,fireEvent$s=Utilities.fireEvent,getStyle=Utilities.getStyle,isArray$g=Utilities.isArray,isNumber$B=Utilities.isNumber,isObject$9=Utilities.isObject,isString$5=Utilities.isString,merge$1a=Utilities.merge,objectEach$n=Utilities.objectEach,pick$1h=Utilities.pick,pInt$4=Utilities.pInt,relativeLength$7=Utilities.relativeLength,removeEvent$6=Utilities.removeEvent,splat$d=Utilities.splat,syncTimeout$3=Utilities.syncTimeout,uniqueKey$4=Utilities.uniqueKey,Chart$1=function(){function n(e,t,r){this.axes=void 0,this.axisOffset=void 0,this.bounds=void 0,this.chartHeight=void 0,this.chartWidth=void 0,this.clipBox=void 0,this.colorCounter=void 0,this.container=void 0,this.eventOptions=void 0,this.index=void 0,this.isResizing=void 0,this.labelCollectors=void 0,this.legend=void 0,this.margin=void 0,this.numberFormatter=void 0,this.options=void 0,this.plotBox=void 0,this.plotHeight=void 0,this.plotLeft=void 0,this.plotTop=void 0,this.plotWidth=void 0,this.pointCount=void 0,this.pointer=void 0,this.renderer=void 0,this.renderTo=void 0,this.series=void 0,this.sharedClips={},this.spacing=void 0,this.spacingBox=void 0,this.symbolCounter=void 0,this.time=void 0,this.titleOffset=void 0,this.userOptions=void 0,this.xAxis=void 0,this.yAxis=void 0,this.getArgs(e,t,r)}return n.chart=function(e,t,r){return new n(e,t,r)},n.prototype.getArgs=function(e,t,r){isString$5(e)||e.nodeName?(this.renderTo=e,this.init(t,r)):this.init(e,t)},n.prototype.init=function(e,t){var r=e.plotOptions||{};fireEvent$s(this,"init",{args:arguments},function(){var o=merge$1a(defaultOptions$a,e),s=o.chart;objectEach$n(o.plotOptions,function(l,h){isObject$9(l)&&(l.tooltip=r[h]&&merge$1a(r[h].tooltip)||void 0)}),o.tooltip.userOptions=e.chart&&e.chart.forExport&&e.tooltip.userOptions||e.tooltip,this.userOptions=e,this.margin=[],this.spacing=[],this.bounds={h:{},v:{}},this.labelCollectors=[],this.callback=t,this.isResizing=0,this.options=o,this.axes=[],this.series=[],this.time=e.time&&Object.keys(e.time).length?new Time(e.time):H.time,this.numberFormatter=s.numberFormatter||numberFormat$1,this.styledMode=s.styledMode,this.hasCartesianSeries=s.showAxes;var a=this;a.index=charts$1.length,charts$1.push(a),H.chartCount++,registerEventOptions$1(this,s),a.xAxis=[],a.yAxis=[],a.pointCount=a.colorCounter=a.symbolCounter=0,fireEvent$s(a,"afterInit"),a.firstRender()})},n.prototype.initSeries=function(e){var t=this,r=t.options.chart,o=e.type||r.type||r.defaultSeriesType,s=seriesTypes$7[o];s||error$5(17,!0,t,{missingModuleFor:o});var a=new s;return typeof a.init=="function"&&a.init(t,e),a},n.prototype.setSeriesData=function(){this.getSeriesOrderByLinks().forEach(function(e){!e.points&&!e.data&&e.enabledDataSorting&&e.setData(e.options.data,!1)})},n.prototype.getSeriesOrderByLinks=function(){return this.series.concat().sort(function(e,t){return e.linkedSeries.length||t.linkedSeries.length?t.linkedSeries.length-e.linkedSeries.length:0})},n.prototype.orderSeries=function(e){for(var t=this.series,r=e||0,o=t.length;r<o;++r)t[r]&&(t[r].index=r,t[r].name=t[r].getName())},n.prototype.isInsidePlot=function(e,t,r){var o;r===void 0&&(r={});var s=this,a=s.inverted,l=s.plotBox,h=s.plotLeft,d=s.plotTop,c=s.scrollablePlotBox,p=0,f=0;r.visiblePlotOnly&&this.scrollingContainer&&(o=this.scrollingContainer,p=o.scrollLeft,f=o.scrollTop);var u=r.series,g=r.visiblePlotOnly&&c||l,m=r.inverted?t:e,y=r.inverted?e:t,v={x:m,y,isInsidePlot:!0};if(!r.ignoreX){var x=u&&(a?u.yAxis:u.xAxis)||{pos:h,len:1/0},b=r.paneCoordinates?x.pos+m:h+m;b>=Math.max(p+h,x.pos)&&b<=Math.min(p+h+g.width,x.pos+x.len)||(v.isInsidePlot=!1)}if(!r.ignoreY&&v.isInsidePlot){var $=u&&(a?u.xAxis:u.yAxis)||{pos:d,len:1/0},S=r.paneCoordinates?$.pos+y:d+y;S>=Math.max(f+d,$.pos)&&S<=Math.min(f+d+g.height,$.pos+$.len)||(v.isInsidePlot=!1)}return fireEvent$s(this,"afterIsInsidePlot",v),v.isInsidePlot},n.prototype.redraw=function(e){fireEvent$s(this,"beforeRedraw");var t=this,r=t.hasCartesianSeries?t.axes:t.colorAxis||[],o=t.series,s=t.pointer,a=t.legend,l=t.userOptions.legend,h=t.renderer,d=h.isHidden(),c=[],p,f,u,g=t.isDirtyBox,m=t.isDirtyLegend,y;for(t.setResponsive&&t.setResponsive(!1),setAnimation$3(t.hasRendered?e:!1,t),d&&t.temporaryDisplay(),t.layOutTitles(),u=o.length;u--;)if(y=o[u],(y.options.stacking||y.options.centerInCategory)&&(f=!0,y.isDirty)){p=!0;break}if(p)for(u=o.length;u--;)y=o[u],y.options.stacking&&(y.isDirty=!0);o.forEach(function(v){v.isDirty&&(v.options.legendType==="point"?(typeof v.updateTotals=="function"&&v.updateTotals(),m=!0):l&&(l.labelFormatter||l.labelFormat)&&(m=!0)),v.isDirtyData&&fireEvent$s(v,"updatedData")}),m&&a&&a.options.enabled&&(a.render(),t.isDirtyLegend=!1),f&&t.getStacks(),r.forEach(function(v){v.updateNames(),v.setScale()}),t.getMargins(),r.forEach(function(v){v.isDirty&&(g=!0)}),r.forEach(function(v){var x=v.min+","+v.max;v.extKey!==x&&(v.extKey=x,c.push(function(){fireEvent$s(v,"afterSetExtremes",extend$1d(v.eventArgs,v.getExtremes())),delete v.eventArgs})),(g||f)&&v.redraw()}),g&&t.drawChartBox(),fireEvent$s(t,"predraw"),o.forEach(function(v){(g||v.isDirty)&&v.visible&&v.redraw(),v.isDirtyData=!1}),s&&s.reset(!0),h.draw(),fireEvent$s(t,"redraw"),fireEvent$s(t,"render"),d&&t.temporaryDisplay(!0),c.forEach(function(v){v.call()})},n.prototype.get=function(e){var t=this.series;function r(a){return a.id===e||a.options&&a.options.id===e}for(var o=find$g(this.axes,r)||find$g(this.series,r),s=0;!o&&s<t.length;s++)o=find$g(t[s].points||[],r);return o},n.prototype.getAxes=function(){var e=this,t=this.options,r=t.xAxis=splat$d(t.xAxis||{}),o=t.yAxis=splat$d(t.yAxis||{});fireEvent$s(this,"getAxes"),r.forEach(function(a,l){a.index=l,a.isX=!0}),o.forEach(function(a,l){a.index=l});var s=r.concat(o);s.forEach(function(a){new Axis(e,a)}),fireEvent$s(this,"afterGetAxes")},n.prototype.getSelectedPoints=function(){return this.series.reduce(function(e,t){return t.getPointsCollection().forEach(function(r){pick$1h(r.selectedStaging,r.selected)&&e.push(r)}),e},[])},n.prototype.getSelectedSeries=function(){return this.series.filter(function(e){return e.selected})},n.prototype.setTitle=function(e,t,r){this.applyDescription("title",e),this.applyDescription("subtitle",t),this.applyDescription("caption",void 0),this.layOutTitles(r)},n.prototype.applyDescription=function(e,t){var r=this,o=e==="title"?{color:palette.neutralColor80,fontSize:this.options.isStock?"16px":"18px"}:{color:palette.neutralColor60},s=this.options[e]=merge$1a(!this.styledMode&&{style:o},this.options[e],t),a=this[e];a&&t&&(this[e]=a=a.destroy()),s&&!a&&(a=this.renderer.text(s.text,0,0,s.useHTML).attr({align:s.align,class:"highcharts-"+e,zIndex:s.zIndex||4}).add(),a.update=function(l){var h={title:"setTitle",subtitle:"setSubtitle",caption:"setCaption"}[e];r[h](l)},this.styledMode||a.css(s.style),this[e]=a)},n.prototype.layOutTitles=function(e){var t=[0,0,0],r=this.renderer,o=this.spacingBox;["title","subtitle","caption"].forEach(function(a){var l=this[a],h=this.options[a],d=h.verticalAlign||"top",c=a==="title"?d==="top"?-3:0:d==="top"?t[0]+2:0,p,f;l&&(this.styledMode||(p=h.style&&h.style.fontSize),p=r.fontMetrics(p,l).b,l.css({width:(h.width||o.width+(h.widthAdjust||0))+"px"}),f=Math.round(l.getBBox(h.useHTML).height),l.align(extend$1d({y:d==="bottom"?p:c+p,height:f},h),!1,"spacingBox"),h.floating||(d==="top"?t[0]=Math.ceil(t[0]+f):d==="bottom"&&(t[2]=Math.ceil(t[2]+f))))},this),t[0]&&(this.options.title.verticalAlign||"top")==="top"&&(t[0]+=this.options.title.margin),t[2]&&this.options.caption.verticalAlign==="bottom"&&(t[2]+=this.options.caption.margin);var s=!this.titleOffset||this.titleOffset.join(",")!==t.join(",");this.titleOffset=t,fireEvent$s(this,"afterLayOutTitles"),!this.isDirtyBox&&s&&(this.isDirtyBox=this.isDirtyLegend=s,this.hasRendered&&pick$1h(e,!0)&&this.isDirtyBox&&this.redraw())},n.prototype.getChartSize=function(){var e=this,t=e.options.chart,r=t.width,o=t.height,s=e.renderTo;defined$H(r)||(e.containerWidth=getStyle(s,"width")),defined$H(o)||(e.containerHeight=getStyle(s,"height")),e.chartWidth=Math.max(0,r||e.containerWidth||600),e.chartHeight=Math.max(0,relativeLength$7(o,e.chartWidth)||(e.containerHeight>1?e.containerHeight:400))},n.prototype.temporaryDisplay=function(e){var t=this.renderTo,r;if(e)for(;t&&t.style;)t.hcOrigStyle&&(css$5(t,t.hcOrigStyle),delete t.hcOrigStyle),t.hcOrigDetached&&(doc$g.body.removeChild(t),t.hcOrigDetached=!1),t=t.parentNode;else for(;t&&t.style&&(!doc$g.body.contains(t)&&!t.parentNode&&(t.hcOrigDetached=!0,doc$g.body.appendChild(t)),(getStyle(t,"display",!1)==="none"||t.hcOricDetached)&&(t.hcOrigStyle={display:t.style.display,height:t.style.height,overflow:t.style.overflow},r={display:"block",overflow:"hidden"},t!==this.renderTo&&(r.height=0),css$5(t,r),t.offsetWidth||t.style.setProperty("display","block","important")),t=t.parentNode,t!==doc$g.body););},n.prototype.setClassName=function(e){this.container.className="highcharts-container "+(e||"")},n.prototype.getContainer=function(){var e=this,t=e.options,r=t.chart,o="data-highcharts-chart",s=uniqueKey$4(),a,l=e.renderTo;l||(e.renderTo=l=r.renderTo),isString$5(l)&&(e.renderTo=l=doc$g.getElementById(l)),l||error$5(13,!0,e);var h=pInt$4(attr$1(l,o));isNumber$B(h)&&charts$1[h]&&charts$1[h].hasRendered&&charts$1[h].destroy(),attr$1(l,o,e.index),l.innerHTML="",!r.skipClone&&!l.offsetWidth&&e.temporaryDisplay(),e.getChartSize();var d=e.chartWidth,c=e.chartHeight;css$5(l,{overflow:"hidden"}),e.styledMode||(a=extend$1d({position:"relative",overflow:"hidden",width:d+"px",height:c+"px",textAlign:"left",lineHeight:"normal",zIndex:0,"-webkit-tap-highlight-color":"rgba(0,0,0,0)",userSelect:"none","touch-action":"manipulation",outline:"none"},r.style||{}));var p=createElement$5("div",{id:s},a,l);e.container=p,e._cursor=p.style.cursor;var f=r.renderer||!svg$3?RendererRegistry$1.getRendererType(r.renderer):SVGRenderer;if(e.renderer=new f(p,d,c,void 0,r.forExport,t.exporting&&t.exporting.allowHTML,e.styledMode),setAnimation$3(void 0,e),e.setClassName(r.className),!e.styledMode)e.renderer.setStyle(r.style);else for(var u in t.defs)this.renderer.definition(t.defs[u]);e.renderer.chartIndex=e.index,fireEvent$s(this,"afterGetContainer")},n.prototype.getMargins=function(e){var t=this,r=t.spacing,o=t.margin,s=t.titleOffset;this.resetMargins(),s[0]&&!defined$H(o[0])&&(this.plotTop=Math.max(this.plotTop,s[0]+r[0])),s[2]&&!defined$H(o[2])&&(this.marginBottom=Math.max(this.marginBottom,s[2]+r[2])),this.legend&&this.legend.display&&this.legend.adjustMargins(o,r),fireEvent$s(this,"getMargins"),e||this.getAxisMargins()},n.prototype.getAxisMargins=function(){var e=this,t=e.axisOffset=[0,0,0,0],r=e.colorAxis,o=e.margin,s=function(a){a.forEach(function(l){l.visible&&l.getOffset()})};e.hasCartesianSeries?s(e.axes):r&&r.length&&s(r),marginNames.forEach(function(a,l){defined$H(o[l])||(e[a]+=t[l])}),e.setChartSize()},n.prototype.reflow=function(e){var t=this,r=t.options.chart,o=t.renderTo,s=defined$H(r.width)&&defined$H(r.height),a=r.width||getStyle(o,"width"),l=r.height||getStyle(o,"height"),h=e?e.target:win$8;delete t.pointer.chartPosition,!s&&!t.isPrinting&&a&&l&&(h===win$8||h===doc$g)&&((a!==t.containerWidth||l!==t.containerHeight)&&(Utilities.clearTimeout(t.reflowTimeout),t.reflowTimeout=syncTimeout$3(function(){t.container&&t.setSize(void 0,void 0,!1)},e?100:0)),t.containerWidth=a,t.containerHeight=l)},n.prototype.setReflow=function(e){var t=this;e!==!1&&!this.unbindReflow?(this.unbindReflow=addEvent$T(win$8,"resize",function(r){t.options&&t.reflow(r)}),addEvent$T(this,"destroy",this.unbindReflow)):e===!1&&this.unbindReflow&&(this.unbindReflow=this.unbindReflow())},n.prototype.setSize=function(e,t,r){var o=this,s=o.renderer;o.isResizing+=1,setAnimation$3(r,o);var a=s.globalAnimation;o.oldChartHeight=o.chartHeight,o.oldChartWidth=o.chartWidth,typeof e<"u"&&(o.options.chart.width=e),typeof t<"u"&&(o.options.chart.height=t),o.getChartSize(),o.styledMode||(a?animate:css$5)(o.container,{width:o.chartWidth+"px",height:o.chartHeight+"px"},a),o.setChartSize(!0),s.setSize(o.chartWidth,o.chartHeight,a),o.axes.forEach(function(l){l.isDirty=!0,l.setScale()}),o.isDirtyLegend=!0,o.isDirtyBox=!0,o.layOutTitles(),o.getMargins(),o.redraw(a),o.oldChartHeight=null,fireEvent$s(o,"resize"),syncTimeout$3(function(){o&&fireEvent$s(o,"endResize",null,function(){o.isResizing-=1})},animObject$7(a).duration)},n.prototype.setChartSize=function(e){var t=this,r=t.inverted,o=t.renderer,s=t.chartWidth,a=t.chartHeight,l=t.options.chart,h=t.spacing,d=t.clipOffset,c,p,f,u;t.plotLeft=c=Math.round(t.plotLeft),t.plotTop=p=Math.round(t.plotTop),t.plotWidth=f=Math.max(0,Math.round(s-c-t.marginRight)),t.plotHeight=u=Math.max(0,Math.round(a-p-t.marginBottom)),t.plotSizeX=r?u:f,t.plotSizeY=r?f:u,t.plotBorderWidth=l.plotBorderWidth||0,t.spacingBox=o.spacingBox={x:h[3],y:h[0],width:s-h[3]-h[1],height:a-h[0]-h[2]},t.plotBox=o.plotBox={x:c,y:p,width:f,height:u};var g=2*Math.floor(t.plotBorderWidth/2),m=Math.ceil(Math.max(g,d[3])/2),y=Math.ceil(Math.max(g,d[0])/2);t.clipBox={x:m,y,width:Math.floor(t.plotSizeX-Math.max(g,d[1])/2-m),height:Math.max(0,Math.floor(t.plotSizeY-Math.max(g,d[2])/2-y))},e||(t.axes.forEach(function(v){v.setAxisSize(),v.setAxisTranslation()}),o.alignElements()),fireEvent$s(t,"afterSetChartSize",{skipAxes:e})},n.prototype.resetMargins=function(){fireEvent$s(this,"resetMargins");var e=this,t=e.options.chart;["margin","spacing"].forEach(function(o){var s=t[o],a=isObject$9(s)?s:[s,s,s,s];["Top","Right","Bottom","Left"].forEach(function(l,h){e[o][h]=pick$1h(t[o+l],a[h])})}),marginNames.forEach(function(r,o){e[r]=pick$1h(e.margin[o],e.spacing[o])}),e.axisOffset=[0,0,0,0],e.clipOffset=[0,0,0,0]},n.prototype.drawChartBox=function(){var e=this,t=e.options.chart,r=e.renderer,o=e.chartWidth,s=e.chartHeight,a=e.styledMode,l=e.plotBGImage,h=t.backgroundColor,d=t.plotBackgroundColor,c=t.plotBackgroundImage,p=e.plotLeft,f=e.plotTop,u=e.plotWidth,g=e.plotHeight,m=e.plotBox,y=e.clipRect,v=e.clipBox,x=e.chartBackground,b=e.plotBackground,$=e.plotBorder,S,k,A,M="animate";x||(e.chartBackground=x=r.rect().addClass("highcharts-background").add(),M="attr"),a?S=k=x.strokeWidth():(S=t.borderWidth||0,k=S+(t.shadow?8:0),A={fill:h||"none"},(S||x["stroke-width"])&&(A.stroke=t.borderColor,A["stroke-width"]=S),x.attr(A).shadow(t.shadow)),x[M]({x:k/2,y:k/2,width:o-k-S%2,height:s-k-S%2,r:t.borderRadius}),M="animate",b||(M="attr",e.plotBackground=b=r.rect().addClass("highcharts-plot-background").add()),b[M](m),a||(b.attr({fill:d||"none"}).shadow(t.plotShadow),c&&(l?(c!==l.attr("href")&&l.attr("href",c),l.animate(m)):e.plotBGImage=r.image(c,p,f,u,g).add())),y?y.animate({width:v.width,height:v.height}):e.clipRect=r.clipRect(v),M="animate",$||(M="attr",e.plotBorder=$=r.rect().addClass("highcharts-plot-border").attr({zIndex:1}).add()),a||$.attr({stroke:t.plotBorderColor,"stroke-width":t.plotBorderWidth||0,fill:"none"}),$[M]($.crisp({x:p,y:f,width:u,height:g},-$.strokeWidth())),e.isDirtyBox=!1,fireEvent$s(this,"afterDrawChartBox")},n.prototype.propFromSeries=function(){var e=this,t=e.options.chart,r=e.options.series,o,s,a;["inverted","angular","polar"].forEach(function(l){for(s=seriesTypes$7[t.type||t.defaultSeriesType],a=t[l]||s&&s.prototype[l],o=r&&r.length;!a&&o--;)s=seriesTypes$7[r[o].type],s&&s.prototype[l]&&(a=!0);e[l]=a})},n.prototype.linkSeries=function(){var e=this,t=e.series;t.forEach(function(r){r.linkedSeries.length=0}),t.forEach(function(r){var o=r.options.linkedTo;isString$5(o)&&(o===":previous"?o=e.series[r.index-1]:o=e.get(o),o&&o.linkedParent!==r&&(o.linkedSeries.push(r),r.linkedParent=o,o.enabledDataSorting&&r.setDataSortingOptions(),r.visible=pick$1h(r.options.visible,o.options.visible,r.visible)))}),fireEvent$s(this,"afterLinkSeries")},n.prototype.renderSeries=function(){this.series.forEach(function(e){e.translate(),e.render()})},n.prototype.renderLabels=function(){var e=this,t=e.options.labels;t.items&&t.items.forEach(function(r){var o=extend$1d(t.style,r.style),s=pInt$4(o.left)+e.plotLeft,a=pInt$4(o.top)+e.plotTop+12;delete o.left,delete o.top,e.renderer.text(r.html,s,a).attr({zIndex:2}).css(o).add()})},n.prototype.render=function(){var e=this,t=e.axes,r=e.colorAxis,o=e.renderer,s=e.options,a=function(f){f.forEach(function(u){u.visible&&u.render()})},l=0;e.setTitle(),e.legend=new Legend(e,s.legend),e.getStacks&&e.getStacks(),e.getMargins(!0),e.setChartSize();var h=e.plotWidth;t.some(function(f){if(f.horiz&&f.visible&&f.options.labels.enabled&&f.series.length)return l=21,!0}),e.plotHeight=Math.max(e.plotHeight-l,0);var d=e.plotHeight;t.forEach(function(f){f.setScale()}),e.getAxisMargins();var c=h/e.plotWidth>1.1,p=d/e.plotHeight>1.05;(c||p)&&(t.forEach(function(f){(f.horiz&&c||!f.horiz&&p)&&f.setTickInterval(!0)}),e.getMargins()),e.drawChartBox(),e.hasCartesianSeries?a(t):r&&r.length&&a(r),e.seriesGroup||(e.seriesGroup=o.g("series-group").attr({zIndex:3}).add()),e.renderSeries(),e.renderLabels(),e.addCredits(),e.setResponsive&&e.setResponsive(),e.hasRendered=!0},n.prototype.addCredits=function(e){var t=this,r=merge$1a(!0,this.options.credits,e);r.enabled&&!this.credits&&(this.credits=this.renderer.text(r.text+(this.mapCredits||""),0,0).addClass("highcharts-credits").on("click",function(){r.href&&(win$8.location.href=r.href)}).attr({align:r.position.align,zIndex:8}),t.styledMode||this.credits.css(r.style),this.credits.add().align(r.position),this.credits.update=function(o){t.credits=t.credits.destroy(),t.addCredits(o)})},n.prototype.destroy=function(){var e=this,t=e.axes,r=e.series,o=e.container,s=o&&o.parentNode,a;for(fireEvent$s(e,"destroy"),e.renderer.forExport?erase$3(charts$1,e):charts$1[e.index]=void 0,H.chartCount--,e.renderTo.removeAttribute("data-highcharts-chart"),removeEvent$6(e),a=t.length;a--;)t[a]=t[a].destroy();for(this.scroller&&this.scroller.destroy&&this.scroller.destroy(),a=r.length;a--;)r[a]=r[a].destroy();["title","subtitle","chartBackground","plotBackground","plotBGImage","plotBorder","seriesGroup","clipRect","credits","pointer","rangeSelector","legend","resetZoomButton","tooltip","renderer"].forEach(function(l){var h=e[l];h&&h.destroy&&(e[l]=h.destroy())}),o&&(o.innerHTML="",removeEvent$6(o),s&&discardElement$3(o)),objectEach$n(e,function(l,h){delete e[h]})},n.prototype.firstRender=function(){var e=this,t=e.options;e.isReadyToRender&&!e.isReadyToRender()||(e.getContainer(),e.resetMargins(),e.setChartSize(),e.propFromSeries(),e.getAxes(),(isArray$g(t.series)?t.series:[]).forEach(function(r){e.initSeries(r)}),e.linkSeries(),e.setSeriesData(),fireEvent$s(e,"beforeRender"),MSPointer.isRequired()?e.pointer=new MSPointer(e,t):e.pointer=new Pointer(e,t),e.render(),e.pointer.getChartPosition(),!e.renderer.imgCount&&!e.hasLoaded&&e.onload(),e.temporaryDisplay(!0))},n.prototype.onload=function(){this.callbacks.concat([this.callback]).forEach(function(e){e&&typeof this.index<"u"&&e.apply(this,[this])},this),fireEvent$s(this,"load"),fireEvent$s(this,"render"),defined$H(this.index)&&this.setReflow(this.options.chart.reflow),this.hasLoaded=!0},n.prototype.addSeries=function(e,t,r){var o=this,s;return e&&(t=pick$1h(t,!0),fireEvent$s(o,"addSeries",{options:e},function(){s=o.initSeries(e),o.isDirtyLegend=!0,o.linkSeries(),s.enabledDataSorting&&s.setData(e.data,!1),fireEvent$s(o,"afterAddSeries",{series:s}),t&&o.redraw(r)})),s},n.prototype.addAxis=function(e,t,r,o){return this.createAxis(t?"xAxis":"yAxis",{axis:e,redraw:r,animation:o})},n.prototype.addColorAxis=function(e,t,r){return this.createAxis("colorAxis",{axis:e,redraw:t,animation:r})},n.prototype.createAxis=function(e,t){var r=new Axis(this,merge$1a(t.axis,{index:this[e].length,isX:e==="xAxis"}));return pick$1h(t.redraw,!0)&&this.redraw(t.animation),r},n.prototype.showLoading=function(e){var t=this,r=t.options,o=r.loading,s=function(){a&&css$5(a,{left:t.plotLeft+"px",top:t.plotTop+"px",width:t.plotWidth+"px",height:t.plotHeight+"px"})},a=t.loadingDiv,l=t.loadingSpan;a||(t.loadingDiv=a=createElement$5("div",{className:"highcharts-loading highcharts-loading-hidden"},null,t.container)),l||(t.loadingSpan=l=createElement$5("span",{className:"highcharts-loading-inner"},null,a),addEvent$T(t,"redraw",s)),a.className="highcharts-loading",AST.setElementHTML(l,pick$1h(e,r.lang.loading,"")),t.styledMode||(css$5(a,extend$1d(o.style,{zIndex:10})),css$5(l,o.labelStyle),t.loadingShown||(css$5(a,{opacity:0,display:""}),animate(a,{opacity:o.style.opacity||.5},{duration:o.showDuration||0}))),t.loadingShown=!0,s()},n.prototype.hideLoading=function(){var e=this.options,t=this.loadingDiv;t&&(t.className="highcharts-loading highcharts-loading-hidden",this.styledMode||animate(t,{opacity:0},{duration:e.loading.hideDuration||100,complete:function(){css$5(t,{display:"none"})}})),this.loadingShown=!1},n.prototype.update=function(e,t,r,o){var s=this,a={credits:"addCredits",title:"setTitle",subtitle:"setSubtitle",caption:"setCaption"},l=e.isResponsiveOptions,h=[],d,c,p;fireEvent$s(s,"update",{options:e}),l||s.setResponsive(!1,!0),e=cleanRecursively$1(e,s.options),s.userOptions=merge$1a(s.userOptions,e);var f=e.chart;f&&(merge$1a(!0,s.options.chart,f),"className"in f&&s.setClassName(f.className),"reflow"in f&&s.setReflow(f.reflow),("inverted"in f||"polar"in f||"type"in f)&&(s.propFromSeries(),d=!0),"alignTicks"in f&&(d=!0),"events"in f&&registerEventOptions$1(this,f),objectEach$n(f,function(m,y){s.propsRequireUpdateSeries.indexOf("chart."+y)!==-1&&(c=!0),s.propsRequireDirtyBox.indexOf(y)!==-1&&(s.isDirtyBox=!0),s.propsRequireReflow.indexOf(y)!==-1&&(l?s.isDirtyBox=!0:p=!0)}),!s.styledMode&&f.style&&s.renderer.setStyle(s.options.chart.style||{})),!s.styledMode&&e.colors&&(this.options.colors=e.colors),e.time&&(this.time===defaultTime&&(this.time=new Time(e.time)),merge$1a(!0,s.options.time,e.time)),objectEach$n(e,function(m,y){s[y]&&typeof s[y].update=="function"?s[y].update(m,!1):typeof s[a[y]]=="function"?s[a[y]](m):y!=="colors"&&s.collectionsWithUpdate.indexOf(y)===-1&&merge$1a(!0,s.options[y],e[y]),y!=="chart"&&s.propsRequireUpdateSeries.indexOf(y)!==-1&&(c=!0)}),this.collectionsWithUpdate.forEach(function(m){var y;e[m]&&(y=[],s[m].forEach(function(v,x){v.options.isInternal||y.push(pick$1h(v.options.index,x))}),splat$d(e[m]).forEach(function(v,x){var b=defined$H(v.id),$;b&&($=s.get(v.id)),!$&&s[m]&&($=s[m][y?y[x]:x],$&&b&&defined$H($.options.id)&&($=void 0)),$&&$.coll===m&&($.update(v,!1),r&&($.touched=!0)),!$&&r&&s.collectionsWithInit[m]&&(s.collectionsWithInit[m][0].apply(s,[v].concat(s.collectionsWithInit[m][1]||[]).concat([!1])).touched=!0)}),r&&s[m].forEach(function(v){!v.touched&&!v.options.isInternal?h.push(v):delete v.touched}))}),h.forEach(function(m){m.chart&&m.remove&&m.remove(!1)}),d&&s.axes.forEach(function(m){m.update({},!1)}),c&&s.getSeriesOrderByLinks().forEach(function(m){m.chart&&m.update({},!1)},this);var u=f&&f.width,g=f&&(isString$5(f.height)?relativeLength$7(f.height,u||s.chartWidth):f.height);p||isNumber$B(u)&&u!==s.chartWidth||isNumber$B(g)&&g!==s.chartHeight?s.setSize(u,g,o):pick$1h(t,!0)&&s.redraw(o),fireEvent$s(s,"afterUpdate",{options:e,redraw:t,animation:o})},n.prototype.setSubtitle=function(e,t){this.applyDescription("subtitle",e),this.layOutTitles(t)},n.prototype.setCaption=function(e,t){this.applyDescription("caption",e),this.layOutTitles(t)},n.prototype.showResetZoom=function(){var e=this,t=defaultOptions$a.lang,r=e.options.chart.resetZoomButton,o=r.theme,s=o.states,a=r.relativeTo==="chart"||r.relativeTo==="spacingBox"?null:"scrollablePlotBox";function l(){e.zoomOut()}fireEvent$s(this,"beforeShowResetZoom",null,function(){e.resetZoomButton=e.renderer.button(t.resetZoom,null,null,l,o,s&&s.hover).attr({align:r.position.align,title:t.resetZoomTitle}).addClass("highcharts-reset-zoom").add().align(r.position,!1,a)}),fireEvent$s(this,"afterShowResetZoom")},n.prototype.zoomOut=function(){fireEvent$s(this,"selection",{resetSelection:!0},this.zoom)},n.prototype.zoom=function(e){var t=this,r=t.pointer,o=t.inverted?r.mouseDownX:r.mouseDownY,s=!1,a;!e||e.resetSelection?(t.axes.forEach(function(h){a=h.zoom()}),r.initiated=!1):e.xAxis.concat(e.yAxis).forEach(function(h){var d=h.axis,c=t.inverted?d.left:d.top,p=t.inverted?c+d.width:c+d.height,f=d.isXAxis,u=!1;(!f&&o>=c&&o<=p||f||!defined$H(o))&&(u=!0),r[f?"zoomX":"zoomY"]&&u&&(a=d.zoom(h.min,h.max),d.displayBtn&&(s=!0))});var l=t.resetZoomButton;s&&!l?t.showResetZoom():!s&&isObject$9(l)&&(t.resetZoomButton=l.destroy()),a&&t.redraw(pick$1h(t.options.chart.animation,e&&e.animation,t.pointCount<100))},n.prototype.pan=function(e,t){var r=this,o=r.hoverPoints,s=typeof t=="object"?t:{enabled:t,type:"x"},a=r.options.chart,l=r.options.mapNavigation&&r.options.mapNavigation.enabled;a&&a.panning&&(a.panning=s);var h=s.type,d;fireEvent$s(this,"pan",{originalEvent:e},function(){o&&o.forEach(function(f){f.setState()});var c=r.xAxis;h==="xy"?c=c.concat(r.yAxis):h==="y"&&(c=r.yAxis);var p={};c.forEach(function(f){if(!(!f.options.panningEnabled||f.options.isInternal)){var u=f.horiz,g=e[u?"chartX":"chartY"],m=u?"mouseDownX":"mouseDownY",y=r[m],v=f.minPointOffset||0,x=f.reversed&&!r.inverted||!f.reversed&&r.inverted?-1:1,b=f.getExtremes(),$=f.toValue(y-g,!0)+v*x,S=f.toValue(y+f.len-g,!0)-(v*x||f.isXAxis&&f.pointRangePadding||0),k=S<$,A=f.hasVerticalPanning(),M=k?S:$,P=k?$:S,E=f.panningState,T;A&&!f.isXAxis&&(!E||E.isDirty)&&f.series.forEach(function(I){var L=I.getProcessedData(!0),D=I.getExtremes(L.yData,!0);E||(E={startMin:Number.MAX_VALUE,startMax:-Number.MAX_VALUE}),isNumber$B(D.dataMin)&&isNumber$B(D.dataMax)&&(E.startMin=Math.min(pick$1h(I.options.threshold,1/0),D.dataMin,E.startMin),E.startMax=Math.max(pick$1h(I.options.threshold,-1/0),D.dataMax,E.startMax))});var O=Math.min(pick$1h(E&&E.startMin,b.dataMin),v?b.min:f.toValue(f.toPixels(b.min)-f.minPixelPadding)),C=Math.max(pick$1h(E&&E.startMax,b.dataMax),v?b.max:f.toValue(f.toPixels(b.max)+f.minPixelPadding));f.panningState=E,f.isOrdinal||(T=O-M,T>0&&(P+=T,M=O),T=P-C,T>0&&(P=C,M-=T),f.series.length&&M!==b.min&&P!==b.max&&M>=O&&P<=C&&(f.setExtremes(M,P,!1,!1,{trigger:"pan"}),!r.resetZoomButton&&!l&&M!==O&&P!==C&&h.match("y")&&(r.showResetZoom(),f.displayBtn=!1),d=!0),p[m]=g)}}),objectEach$n(p,function(f,u){r[u]=f}),d&&r.redraw(!1),css$5(r.container,{cursor:"move"})})},n}();extend$1d(Chart$1.prototype,{callbacks:[],collectionsWithInit:{xAxis:[Chart$1.prototype.addAxis,[!0]],yAxis:[Chart$1.prototype.addAxis,[!1]],series:[Chart$1.prototype.addSeries]},collectionsWithUpdate:["xAxis","yAxis","series"],propsRequireDirtyBox:["backgroundColor","borderColor","borderWidth","borderRadius","plotBackgroundColor","plotBackgroundImage","plotBorderColor","plotBorderWidth","plotShadow","shadow"],propsRequireReflow:["margin","marginTop","marginRight","marginBottom","marginLeft","spacing","spacingTop","spacingRight","spacingBottom","spacingLeft"],propsRequireUpdateSeries:["chart.inverted","chart.polar","chart.ignoreHiddenSeries","chart.type","colors","plotOptions","time","tooltip"]});var merge$19=Utilities.merge,pick$1g=Utilities.pick,LegendSymbol;(function(n){function e(r){var o=this.options,s=r.symbolWidth,a=r.symbolHeight,l=a/2,h=this.chart.renderer,d=this.legendGroup,c=r.baseline-Math.round(r.fontMetrics.b*.3),p={},f,u=o.marker;if(this.chart.styledMode||(p={"stroke-width":o.lineWidth||0},o.dashStyle&&(p.dashstyle=o.dashStyle)),this.legendLine=h.path([["M",0,c],["L",s,c]]).addClass("highcharts-graph").attr(p).add(d),u&&u.enabled!==!1&&s){var g=Math.min(pick$1g(u.radius,l),l);this.symbol.indexOf("url")===0&&(u=merge$19(u,{width:a,height:a}),g=0),this.legendSymbol=f=h.symbol(this.symbol,s/2-g,c-g,2*g,2*g,u).addClass("highcharts-point").add(d),f.isMarker=!0}}n.drawLineMarker=e;function t(r,o){var s=r.options,a=r.symbolHeight,l=s.squareSymbol,h=l?a:r.symbolWidth;o.legendSymbol=this.chart.renderer.rect(l?(r.symbolWidth-a)/2:0,r.baseline-a+1,h,a,pick$1g(r.options.symbolRadius,a/2)).addClass("highcharts-point").attr({zIndex:3}).add(o.legendGroup)}n.drawRectangle=t})(LegendSymbol||(LegendSymbol={}));const LegendSymbol$1=LegendSymbol;var seriesDefaults={lineWidth:2,allowPointSelect:!1,crisp:!0,showCheckbox:!1,animation:{duration:1e3},events:{},marker:{enabledThreshold:2,lineColor:palette.backgroundColor,lineWidth:0,radius:4,states:{normal:{animation:!0},hover:{animation:{duration:50},enabled:!0,radiusPlus:2,lineWidthPlus:1},select:{fillColor:palette.neutralColor20,lineColor:palette.neutralColor100,lineWidth:2}}},point:{events:{}},dataLabels:{animation:{},align:"center",defer:!0,formatter:function(){var n=this.series.chart.numberFormatter;return typeof this.y!="number"?"":n(this.y,-1)},padding:5,style:{fontSize:"11px",fontWeight:"bold",color:"contrast",textOutline:"1px contrast"},verticalAlign:"bottom",x:0,y:0},cropThreshold:300,opacity:1,pointRange:0,softThreshold:!0,states:{normal:{animation:!0},hover:{animation:{duration:50},lineWidthPlus:1,marker:{},halo:{size:10,opacity:.25}},select:{animation:{duration:0}},inactive:{animation:{duration:50},opacity:.2}},stickyTracking:!0,turboThreshold:1e3,findNearestPointBy:"x"},animObject$6=animationExports.animObject,setAnimation$2=animationExports.setAnimation,defaultOptions$9=DefaultOptions.defaultOptions,registerEventOptions=exports$3.registerEventOptions,hasTouch$2=H.hasTouch,svg$2=H.svg,win$7=H.win,seriesTypes$6=SeriesRegistry$1.seriesTypes,addEvent$S=Utilities.addEvent,arrayMax$7=Utilities.arrayMax,arrayMin$6=Utilities.arrayMin,clamp$e=Utilities.clamp,cleanRecursively=Utilities.cleanRecursively,correctFloat$a=Utilities.correctFloat,defined$G=Utilities.defined,erase$2=Utilities.erase,error$4=Utilities.error,extend$1c=Utilities.extend,find$f=Utilities.find,fireEvent$r=Utilities.fireEvent,getNestedProperty=Utilities.getNestedProperty,isArray$f=Utilities.isArray,isNumber$A=Utilities.isNumber,isString$4=Utilities.isString,merge$18=Utilities.merge,objectEach$m=Utilities.objectEach,pick$1f=Utilities.pick,removeEvent$5=Utilities.removeEvent,splat$c=Utilities.splat,syncTimeout$2=Utilities.syncTimeout,Series$e=function(){function n(){this._i=void 0,this.chart=void 0,this.data=void 0,this.eventOptions=void 0,this.eventsToUnbind=void 0,this.index=void 0,this.linkedSeries=void 0,this.options=void 0,this.points=void 0,this.processedXData=void 0,this.processedYData=void 0,this.tooltipOptions=void 0,this.userOptions=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zones=void 0}return n.prototype.init=function(e,t){fireEvent$r(this,"init",{options:t});var r=this,o=e.series;this.eventsToUnbind=[],r.chart=e,r.options=r.setOptions(t);var s=r.options;r.linkedSeries=[],r.bindAxes(),extend$1c(r,{name:s.name,state:"",visible:s.visible!==!1,selected:s.selected===!0}),registerEventOptions(this,s);var a=s.events;(a&&a.click||s.point&&s.point.events&&s.point.events.click||s.allowPointSelect)&&(e.runTrackerClick=!0),r.getColor(),r.getSymbol(),r.parallelArrays.forEach(function(h){r[h+"Data"]||(r[h+"Data"]=[])}),r.isCartesian&&(e.hasCartesianSeries=!0);var l;o.length&&(l=o[o.length-1]),r._i=pick$1f(l&&l._i,-1)+1,r.opacity=r.options.opacity,e.orderSeries(this.insert(o)),s.dataSorting&&s.dataSorting.enabled?r.setDataSortingOptions():!r.points&&!r.data&&r.setData(s.data,!1),fireEvent$r(this,"afterInit")},n.prototype.is=function(e){return seriesTypes$6[e]&&this instanceof seriesTypes$6[e]},n.prototype.insert=function(e){var t=this.options.index,r;if(isNumber$A(t)){for(r=e.length;r--;)if(t>=pick$1f(e[r].options.index,e[r]._i)){e.splice(r+1,0,this);break}r===-1&&e.unshift(this),r=r+1}else e.push(this);return pick$1f(r,e.length-1)},n.prototype.bindAxes=function(){var e=this,t=e.options,r=e.chart,o;fireEvent$r(this,"bindAxes",null,function(){(e.axisTypes||[]).forEach(function(s){var a=0;r[s].forEach(function(l){o=l.options,(t[s]===a&&!o.isInternal||typeof t[s]<"u"&&t[s]===o.id||typeof t[s]>"u"&&o.index===0)&&(e.insert(l.series),e[s]=l,l.isDirty=!0),o.isInternal||a++}),!e[s]&&e.optionalAxis!==s&&error$4(18,!0,r)})}),fireEvent$r(this,"afterBindAxes")},n.prototype.updateParallelArrays=function(e,t){var r=e.series,o=arguments,s=isNumber$A(t)?function(a){var l=a==="y"&&r.toYData?r.toYData(e):e[a];r[a+"Data"][t]=l}:function(a){Array.prototype[t].apply(r[a+"Data"],Array.prototype.slice.call(o,2))};r.parallelArrays.forEach(s)},n.prototype.hasData=function(){return this.visible&&typeof this.dataMax<"u"&&typeof this.dataMin<"u"||this.visible&&this.yData&&this.yData.length>0},n.prototype.autoIncrement=function(e){var t=this.options,r=t.pointIntervalUnit,o=t.relativeXValue,s=this.chart.time,a=this.xIncrement,l,h;return a=pick$1f(a,t.pointStart,0),this.pointInterval=h=pick$1f(this.pointInterval,t.pointInterval,1),o&&isNumber$A(e)&&(h*=e),r&&(l=new s.Date(a),r==="day"?s.set("Date",l,s.get("Date",l)+h):r==="month"?s.set("Month",l,s.get("Month",l)+h):r==="year"&&s.set("FullYear",l,s.get("FullYear",l)+h),h=l.getTime()-a),o&&isNumber$A(e)?a+h:(this.xIncrement=a+h,a)},n.prototype.setDataSortingOptions=function(){var e=this.options;extend$1c(this,{requireSorting:!1,sorted:!1,enabledDataSorting:!0,allowDG:!1}),defined$G(e.pointRange)||(e.pointRange=1)},n.prototype.setOptions=function(e){var t=this.chart,r=t.options,o=r.plotOptions,s=t.userOptions||{},a=merge$18(e),l=t.styledMode,h={plotOptions:o,userOptions:a},d;fireEvent$r(this,"setOptions",h);var c=h.plotOptions[this.type],p=s.plotOptions||{};this.userOptions=h.userOptions;var f=merge$18(c,o.series,s.plotOptions&&s.plotOptions[this.type],a);this.tooltipOptions=merge$18(defaultOptions$9.tooltip,defaultOptions$9.plotOptions.series&&defaultOptions$9.plotOptions.series.tooltip,defaultOptions$9.plotOptions[this.type].tooltip,r.tooltip.userOptions,o.series&&o.series.tooltip,o[this.type].tooltip,a.tooltip),this.stickyTracking=pick$1f(a.stickyTracking,p[this.type]&&p[this.type].stickyTracking,p.series&&p.series.stickyTracking,this.tooltipOptions.shared&&!this.noSharedTooltip?!0:f.stickyTracking),c.marker===null&&delete f.marker,this.zoneAxis=f.zoneAxis;var u=this.zones=(f.zones||[]).slice();return(f.negativeColor||f.negativeFillColor)&&!f.zones&&(d={value:f[this.zoneAxis+"Threshold"]||f.threshold||0,className:"highcharts-negative"},l||(d.color=f.negativeColor,d.fillColor=f.negativeFillColor),u.push(d)),u.length&&defined$G(u[u.length-1].value)&&u.push(l?{}:{color:this.color,fillColor:this.fillColor}),fireEvent$r(this,"afterSetOptions",{options:f}),f},n.prototype.getName=function(){return pick$1f(this.options.name,"Series "+(this.index+1))},n.prototype.getCyclic=function(e,t,r){var o=this.chart,s=this.userOptions,a=e+"Index",l=e+"Counter",h=r?r.length:pick$1f(o.options.chart[e+"Count"],o[e+"Count"]),d,c;t||(c=pick$1f(s[a],s["_"+a]),defined$G(c)?d=c:(o.series.length||(o[l]=0),s["_"+a]=d=o[l]%h,o[l]+=1),r&&(t=r[d])),typeof d<"u"&&(this[a]=d),this[e]=t},n.prototype.getColor=function(){this.chart.styledMode?this.getCyclic("color"):this.options.colorByPoint?this.color=palette.neutralColor20:this.getCyclic("color",this.options.color||defaultOptions$9.plotOptions[this.type].color,this.chart.options.colors)},n.prototype.getPointsCollection=function(){return(this.hasGroupedData?this.points:this.data)||[]},n.prototype.getSymbol=function(){var e=this.options.marker;this.getCyclic("symbol",e.symbol,this.chart.options.symbols)},n.prototype.findPointIndex=function(e,t){var r=e.id,o=e.x,s=this.points,a=this.options.dataSorting,l,h,d;if(r){var c=this.chart.get(r);c instanceof Point$2&&(l=c)}else if(this.linkedParent||this.enabledDataSorting||this.options.relativeXValue){var p=function(f){return!f.touched&&f.index===e.index};if(a&&a.matchByName?p=function(f){return!f.touched&&f.name===e.name}:this.options.relativeXValue&&(p=function(f){return!f.touched&&f.options.x===e.x}),l=find$f(s,p),!l)return}return l&&(d=l&&l.index,typeof d<"u"&&(h=!0)),typeof d>"u"&&isNumber$A(o)&&(d=this.xData.indexOf(o,t)),d!==-1&&typeof d<"u"&&this.cropped&&(d=d>=this.cropStart?d-this.cropStart:d),!h&&isNumber$A(d)&&s[d]&&s[d].touched&&(d=void 0),d},n.prototype.updateData=function(e,t){var r=this.options,o=r.dataSorting,s=this.points,a=[],l=this.requireSorting,h=e.length===s.length,d,c,p,f,u=!0;if(this.xIncrement=null,e.forEach(function(g,m){var y=defined$G(g)&&this.pointClass.prototype.optionsToObject.call({series:this},g)||{},v,x=y.x,b=y.id;b||isNumber$A(x)?(v=this.findPointIndex(y,f),v===-1||typeof v>"u"?a.push(g):s[v]&&g!==r.data[v]?(s[v].update(g,!1,null,!1),s[v].touched=!0,l&&(f=v+1)):s[v]&&(s[v].touched=!0),(!h||m!==v||o&&o.enabled||this.hasDerivedData)&&(d=!0)):a.push(g)},this),d)for(c=s.length;c--;)p=s[c],p&&!p.touched&&p.remove&&p.remove(!1,t);else h&&(!o||!o.enabled)?(e.forEach(function(g,m){g!==s[m].y&&s[m].update&&s[m].update(g,!1,null,!1)}),a.length=0):u=!1;return s.forEach(function(g){g&&(g.touched=!1)}),u?(a.forEach(function(g){this.addPoint(g,!1,null,null,!1)},this),this.xIncrement===null&&this.xData&&this.xData.length&&(this.xIncrement=arrayMax$7(this.xData),this.autoIncrement()),!0):!1},n.prototype.setData=function(e,t,r,o){var s=this,a=s.points,l=a&&a.length||0,h=s.options,d=s.chart,c=h.dataSorting,p=s.xAxis,f=h.turboThreshold,u=this.xData,g=this.yData,m=s.pointArrayMap,y=m&&m.length,v=h.keys,x,b,$,S=0,k=1,A=null;e=e||[];var M=e.length;if(t=pick$1f(t,!0),c&&c.enabled&&(e=this.sortData(e)),o!==!1&&M&&l&&!s.cropped&&!s.hasGroupedData&&s.visible&&!s.isSeriesBoosting&&($=this.updateData(e,r)),!$){if(s.xIncrement=null,s.colorCounter=0,this.parallelArrays.forEach(function(P){s[P+"Data"].length=0}),f&&M>f)if(A=s.getFirstValidPoint(e),isNumber$A(A))for(x=0;x<M;x++)u[x]=this.autoIncrement(),g[x]=e[x];else if(isArray$f(A))if(y)for(x=0;x<M;x++)b=e[x],u[x]=b[0],g[x]=b.slice(1,y+1);else for(v&&(S=v.indexOf("x"),k=v.indexOf("y"),S=S>=0?S:0,k=k>=0?k:1),x=0;x<M;x++)b=e[x],u[x]=b[S],g[x]=b[k];else error$4(12,!1,d);else for(x=0;x<M;x++)typeof e[x]<"u"&&(b={series:s},s.pointClass.prototype.applyOptions.apply(b,[e[x]]),s.updateParallelArrays(b,x));for(g&&isString$4(g[0])&&error$4(14,!0,d),s.data=[],s.options.data=s.userOptions.data=e,x=l;x--;)a[x]&&a[x].destroy&&a[x].destroy();p&&(p.minRange=p.userMinRange),s.isDirty=d.isDirtyBox=!0,s.isDirtyData=!!a,r=!1}h.legendType==="point"&&(this.processData(),this.generatePoints()),t&&d.redraw(r)},n.prototype.sortData=function(e){var t=this,r=t.options,o=r.dataSorting,s=o.sortKey||"y",a=function(h,d){return defined$G(d)&&h.pointClass.prototype.optionsToObject.call({series:h},d)||{}};e.forEach(function(h,d){e[d]=a(t,h),e[d].index=d},this);var l=e.concat().sort(function(h,d){var c=getNestedProperty(s,h),p=getNestedProperty(s,d);return p<c?-1:p>c?1:0});return l.forEach(function(h,d){h.x=d},this),t.linkedSeries&&t.linkedSeries.forEach(function(h){var d=h.options,c=d.data;(!d.dataSorting||!d.dataSorting.enabled)&&c&&(c.forEach(function(p,f){c[f]=a(h,p),e[f]&&(c[f].x=e[f].x,c[f].index=f)}),h.setData(c,!1))}),e},n.prototype.getProcessedData=function(e){var t=this,r=t.xAxis,o=t.options,s=o.cropThreshold,a=e||t.getExtremesFromAll||o.getExtremesFromAll,l=t.isCartesian,h=r&&r.val2lin,d=!!(r&&r.logarithmic),c,p,f=0,u,g,m,y,v,x,b=t.xData,$=t.yData,S=t.requireSorting,k=!1,A=b.length;for(r&&(y=r.getExtremes(),v=y.min,x=y.max,k=r.categories&&!r.names.length),l&&t.sorted&&!a&&(!s||A>s||t.forceCrop)&&(b[A-1]<v||b[0]>x?(b=[],$=[]):t.yData&&(b[0]<v||b[A-1]>x)&&(c=this.cropData(t.xData,t.yData,v,x),b=c.xData,$=c.yData,f=c.start,p=!0)),m=b.length||1;--m;)u=d?h(b[m])-h(b[m-1]):b[m]-b[m-1],u>0&&(typeof g>"u"||u<g)?g=u:u<0&&S&&!k&&(error$4(15,!1,t.chart),S=!1);return{xData:b,yData:$,cropped:p,cropStart:f,closestPointRange:g}},n.prototype.processData=function(e){var t=this,r=t.xAxis;if(t.isCartesian&&!t.isDirty&&!r.isDirty&&!t.yAxis.isDirty&&!e)return!1;var o=t.getProcessedData();t.cropped=o.cropped,t.cropStart=o.cropStart,t.processedXData=o.xData,t.processedYData=o.yData,t.closestPointRange=t.basePointRange=o.closestPointRange},n.prototype.cropData=function(e,t,r,o,s){var a=e.length,l,h,d=0,c=a;for(s=pick$1f(s,this.cropShoulder),l=0;l<a;l++)if(e[l]>=r){d=Math.max(0,l-s);break}for(h=l;h<a;h++)if(e[h]>o){c=h+s;break}return{xData:e.slice(d,c),yData:t.slice(d,c),start:d,end:c}},n.prototype.generatePoints=function(){var e=this,t=e.options,r=t.data,o=e.processedXData,s=e.processedYData,a=e.pointClass,l=o.length,h=e.cropStart||0,d=e.hasGroupedData,c=t.keys,p=[],f=t.dataGrouping&&t.dataGrouping.groupAll?h:0,u,g,m,y,v=e.data;if(!v&&!d){var x=[];x.length=r.length,v=e.data=x}for(c&&d&&(e.options.keys=!1),y=0;y<l;y++)g=h+y,d?(m=new a().init(e,[o[y]].concat(splat$c(s[y]))),m.dataGroup=e.groupMap[f+y],m.dataGroup.options&&(m.options=m.dataGroup.options,extend$1c(m,m.dataGroup.options),delete m.dataLabels)):(m=v[g],!m&&typeof r[g]<"u"&&(v[g]=m=new a().init(e,r[g],o[y]))),m&&(m.index=d?f+y:g,p[y]=m);if(e.options.keys=c,v&&(l!==(u=v.length)||d))for(y=0;y<u;y++)y===h&&!d&&(y+=l),v[y]&&(v[y].destroyElements(),v[y].plotX=void 0);e.data=v,e.points=p,fireEvent$r(this,"afterGeneratePoints")},n.prototype.getXExtremes=function(e){return{min:arrayMin$6(e),max:arrayMax$7(e)}},n.prototype.getExtremes=function(e,t){var r=this.xAxis,o=this.yAxis,s=this.processedXData||this.xData,a=[],l=this.requireSorting?this.cropShoulder:0,h=o?o.positiveValuesOnly:!1,d,c,p,f,u,g,m,y=0,v=0,x=0;e=e||this.stackedYData||this.processedYData||[];var b=e.length;for(r&&(d=r.getExtremes(),y=d.min,v=d.max),g=0;g<b;g++)if(f=s[g],u=e[g],c=(isNumber$A(u)||isArray$f(u))&&(u.length||u>0||!h),p=t||this.getExtremesFromAll||this.options.getExtremesFromAll||this.cropped||!r||(s[g+l]||f)>=y&&(s[g-l]||f)<=v,c&&p)if(m=u.length,m)for(;m--;)isNumber$A(u[m])&&(a[x++]=u[m]);else a[x++]=u;var $={dataMin:arrayMin$6(a),dataMax:arrayMax$7(a)};return fireEvent$r(this,"afterGetExtremes",{dataExtremes:$}),$},n.prototype.applyExtremes=function(){var e=this.getExtremes();return this.dataMin=e.dataMin,this.dataMax=e.dataMax,e},n.prototype.getFirstValidPoint=function(e){for(var t=e.length,r=0,o=null;o===null&&r<t;)o=e[r],r++;return o},n.prototype.translate=function(){this.processedXData||this.processData(),this.generatePoints();var e=this,t=e.options,r=t.stacking,o=e.xAxis,s=o.categories,a=e.enabledDataSorting,l=e.yAxis,h=e.points,d=h.length,c=!!e.modifyValue,p=e.pointPlacementToXValue(),f=!!p,u=t.threshold,g=t.startFromThreshold?u:0,m=this.zoneAxis||"y",y,v,x,b,$=Number.MAX_VALUE;function S(I){return clamp$e(I,-1e5,1e5)}for(y=0;y<d;y++){var k=h[y],A=k.x,M=void 0,P=void 0,E=k.y,T=k.low,O=r&&l.stacking&&l.stacking.stacks[(e.negStacks&&E<(g?0:u)?"-":"")+e.stackKey];if((l.positiveValuesOnly&&!l.validatePositiveValue(E)||o.positiveValuesOnly&&!o.validatePositiveValue(A))&&(k.isNull=!0),k.plotX=v=correctFloat$a(S(o.translate(A,0,0,0,1,p,this.type==="flags"))),r&&e.visible&&O&&O[A]&&(b=e.getStackIndicator(b,A,e.index),k.isNull||(M=O[A],P=M.points[b.key])),isArray$f(P)&&(T=P[0],E=P[1],T===g&&b.key===O[A].base&&(T=pick$1f(isNumber$A(u)&&u,l.min)),l.positiveValuesOnly&&T<=0&&(T=null),k.total=k.stackTotal=M.total,k.percentage=M.total&&k.y/M.total*100,k.stackY=E,e.irregularWidths||M.setOffset(e.pointXOffset||0,e.barW||0)),k.yBottom=defined$G(T)?S(l.translate(T,0,1,0,1)):null,c&&(E=e.modifyValue(E,k)),k.plotY=void 0,isNumber$A(E)){var C=l.translate(E,!1,!0,!1,!0);typeof C<"u"&&(k.plotY=S(C))}k.isInside=this.isPointInside(k),k.clientX=f?correctFloat$a(o.translate(A,0,0,0,1,p)):v,k.negative=k[m]<(t[m+"Threshold"]||u||0),k.category=s&&typeof s[k.x]<"u"?s[k.x]:k.x,!k.isNull&&k.visible!==!1&&(typeof x<"u"&&($=Math.min($,Math.abs(v-x))),x=v),k.zone=this.zones.length&&k.getZone(),!k.graphic&&e.group&&a&&(k.isNew=!0)}e.closestPointRangePx=$,fireEvent$r(this,"afterTranslate")},n.prototype.getValidPoints=function(e,t,r){var o=this.chart;return(e||this.points||[]).filter(function(s){return t&&!o.isInsidePlot(s.plotX,s.plotY,{inverted:o.inverted})?!1:s.visible!==!1&&(r||!s.isNull)})},n.prototype.getClipBox=function(e,t){var r=this,o=r.options,s=r.chart,a=s.inverted,l=r.xAxis,h=l&&r.yAxis,d=s.options.chart.scrollablePlotArea||{},c;return e&&o.clip===!1&&h?c=a?{y:-s.chartWidth+h.len+h.pos,height:s.chartWidth,width:s.chartHeight,x:-s.chartHeight+l.len+l.pos}:{y:-h.pos,height:s.chartHeight,width:s.chartWidth,x:-l.pos}:(c=r.clipBox||s.clipBox,t&&(c.width=s.plotSizeX,c.x=(s.scrollablePixelsX||0)*(d.scrollPositionX||0))),t?{width:c.width,x:c.x}:c},n.prototype.getSharedClipKey=function(e){if(this.sharedClipKey)return this.sharedClipKey;var t=[e&&e.duration,e&&e.easing,e&&e.defer,this.getClipBox(e).height,this.options.xAxis,this.options.yAxis].join(",");return(this.options.clip!==!1||e)&&(this.sharedClipKey=t),t},n.prototype.setClip=function(e){var t=this.chart,r=this.options,o=t.renderer,s=t.inverted,a=this.clipBox,l=this.getClipBox(e),h=this.getSharedClipKey(e),d=t.sharedClips[h],c=t.sharedClips[h+"m"];e&&(l.width=0,s&&(l.x=t.plotHeight+(r.clip!==!1?0:t.plotTop))),d?t.hasLoaded||d.attr(l):(e&&(t.sharedClips[h+"m"]=c=o.clipRect(s?(t.plotSizeX||0)+99:-99,s?-t.plotLeft:-t.plotTop,99,s?t.chartWidth:t.chartHeight)),t.sharedClips[h]=d=o.clipRect(l),d.count={length:0}),e&&(d.count[this.index]||(d.count[this.index]=!0,d.count.length+=1)),(r.clip!==!1||e)&&(this.group.clip(e||a?d:t.clipRect),this.markerGroup.clip(c)),e||(d.count[this.index]&&(delete d.count[this.index],d.count.length-=1),d.count.length===0&&(a||(t.sharedClips[h]=d.destroy()),c&&(t.sharedClips[h+"m"]=c.destroy())))},n.prototype.animate=function(e){var t=this,r=t.chart,o=animObject$6(t.options.animation),s=this.sharedClipKey;if(e)t.setClip(o);else if(s){var a=r.sharedClips[s],l=r.sharedClips[s+"m"],h=t.getClipBox(o,!0);a&&a.animate(h,o),l&&l.animate({width:h.width+99,x:h.x-(r.inverted?0:99)},o)}},n.prototype.afterAnimate=function(){this.setClip(),fireEvent$r(this,"afterAnimate"),this.finishedAnimating=!0},n.prototype.drawPoints=function(){var e=this,t=e.points,r=e.chart,o=e.options,s=o.marker,a=e[e.specialGroup]||e.markerGroup,l=e.xAxis,h=pick$1f(s.enabled,!l||l.isRadial?!0:null,e.closestPointRangePx>=s.enabledThreshold*s.radius),d,c,p,f,u,g,m;if(s.enabled!==!1||e._hasPointMarkers)for(d=0;d<t.length;d++){c=t[d],p=c.graphic,f=p?"animate":"attr",u=c.marker||{},g=!!c.marker;var y=(h&&typeof u.enabled>"u"||u.enabled)&&!c.isNull&&c.visible!==!1;if(y){var v=pick$1f(u.symbol,e.symbol,"rect");m=e.markerAttribs(c,c.selected&&"select"),e.enabledDataSorting&&(c.startXPos=l.reversed?-(m.width||0):l.width);var x=c.isInside!==!1;p?p[x?"show":"hide"](x).animate(m):x&&((m.width||0)>0||c.hasImage)&&(c.graphic=p=r.renderer.symbol(v,m.x,m.y,m.width,m.height,g?u:s).add(a),e.enabledDataSorting&&r.hasRendered&&(p.attr({x:c.startXPos}),f="animate")),p&&f==="animate"&&p[x?"show":"hide"](x).animate(m),p&&!r.styledMode&&p[f](e.pointAttribs(c,c.selected&&"select")),p&&p.addClass(c.getClassName(),!0)}else p&&(c.graphic=p.destroy())}},n.prototype.markerAttribs=function(e,t){var r=this.options,o=r.marker,s=e.marker||{},a=s.symbol||o.symbol,l,h,d=pick$1f(s.radius,o.radius);t&&(l=o.states[t],h=s.states&&s.states[t],d=pick$1f(h&&h.radius,l&&l.radius,d+(l&&l.radiusPlus||0))),e.hasImage=a&&a.indexOf("url")===0,e.hasImage&&(d=0);var c={x:r.crisp?Math.floor(e.plotX-d):e.plotX-d,y:e.plotY-d};return d&&(c.width=c.height=2*d),c},n.prototype.pointAttribs=function(e,t){var r=this.options.marker,o=e&&e.options,s=o&&o.marker||{},a=o&&o.color,l=e&&e.color,h=e&&e.zone&&e.zone.color,d,c,p=this.color,f,u,g=pick$1f(s.lineWidth,r.lineWidth),m=1;return p=a||h||l||p,f=s.fillColor||r.fillColor||p,u=s.lineColor||r.lineColor||p,t=t||"normal",t&&(d=r.states[t],c=s.states&&s.states[t]||{},g=pick$1f(c.lineWidth,d.lineWidth,g+pick$1f(c.lineWidthPlus,d.lineWidthPlus,0)),f=c.fillColor||d.fillColor||f,u=c.lineColor||d.lineColor||u,m=pick$1f(c.opacity,d.opacity,m)),{stroke:u,"stroke-width":g,fill:f,opacity:m}},n.prototype.destroy=function(e){var t=this,r=t.chart,o=/AppleWebKit\/533/.test(win$7.navigator.userAgent),s=t.data||[],a,l,h,d;for(fireEvent$r(t,"destroy"),this.removeEvents(e),(t.axisTypes||[]).forEach(function(c){d=t[c],d&&d.series&&(erase$2(d.series,t),d.isDirty=d.forceRedraw=!0)}),t.legendItem&&t.chart.legend.destroyItem(t),l=s.length;l--;)h=s[l],h&&h.destroy&&h.destroy();t.clips&&t.clips.forEach(function(c){return c.destroy()}),Utilities.clearTimeout(t.animationTimeout),objectEach$m(t,function(c,p){c instanceof SVGElement&&!c.survive&&(a=o&&p==="group"?"hide":"destroy",c[a]())}),r.hoverSeries===t&&(r.hoverSeries=void 0),erase$2(r.series,t),r.orderSeries(),objectEach$m(t,function(c,p){(!e||p!=="hcEvents")&&delete t[p]})},n.prototype.applyZones=function(){var e=this,t=this.chart,r=t.renderer,o=this.zones,s=this.clips||[],a=this.graph,l=this.area,h=Math.max(t.chartWidth,t.chartHeight),d=this[(this.zoneAxis||"y")+"Axis"],c=t.inverted,p,f,u,g,m,y,v,x,b,$,S,k=!1;o.length&&(a||l)&&d&&typeof d.min<"u"?(m=d.reversed,y=d.horiz,a&&!this.showLine&&a.hide(),l&&l.hide(),g=d.getExtremes(),o.forEach(function(A,M){p=m?y?t.plotWidth:0:y?0:d.toPixels(g.min)||0,p=clamp$e(pick$1f(f,p),0,h),f=clamp$e(Math.round(d.toPixels(pick$1f(A.value,g.max),!0)||0),0,h),k&&(p=f=d.toPixels(g.max)),v=Math.abs(p-f),x=Math.min(p,f),b=Math.max(p,f),d.isXAxis?(u={x:c?b:x,y:0,width:v,height:h},y||(u.x=t.plotHeight-u.x)):(u={x:0,y:c?b:x,width:h,height:v},y&&(u.y=t.plotWidth-u.y)),c&&r.isVML&&(d.isXAxis?u={x:0,y:m?x:b,height:u.width,width:t.chartWidth}:u={x:u.y-t.plotLeft-t.spacingBox.x,y:0,width:u.height,height:t.chartHeight}),s[M]?s[M].animate(u):s[M]=r.clipRect(u),$=e["zone-area-"+M],S=e["zone-graph-"+M],a&&S&&S.clip(s[M]),l&&$&&$.clip(s[M]),k=A.value>g.max,e.resetZones&&f===0&&(f=void 0)}),this.clips=s):e.visible&&(a&&a.show(!0),l&&l.show(!0))},n.prototype.invertGroups=function(e){var t=this,r=t.chart;function o(){["group","markerGroup"].forEach(function(s){t[s]&&(r.renderer.isVML&&t[s].attr({width:t.yAxis.len,height:t.xAxis.len}),t[s].width=t.yAxis.len,t[s].height=t.xAxis.len,t[s].invert(t.isRadialSeries?!1:e))})}t.xAxis&&(t.eventsToUnbind.push(addEvent$S(r,"resize",o)),o(),t.invertGroups=o)},n.prototype.plotGroup=function(e,t,r,o,s){var a=this[e],l=!a,h={visibility:r,zIndex:o||.1};return typeof this.opacity<"u"&&!this.chart.styledMode&&this.state!=="inactive"&&(h.opacity=this.opacity),l&&(this[e]=a=this.chart.renderer.g().add(s)),a.addClass("highcharts-"+t+" highcharts-series-"+this.index+" highcharts-"+this.type+"-series "+(defined$G(this.colorIndex)?"highcharts-color-"+this.colorIndex+" ":"")+(this.options.className||"")+(a.hasClass("highcharts-tracker")?" highcharts-tracker":""),!0),a.attr(h)[l?"attr":"animate"](this.getPlotBox()),a},n.prototype.getPlotBox=function(){var e=this.chart,t=this.xAxis,r=this.yAxis;return e.inverted&&(t=r,r=this.xAxis),{translateX:t?t.left:e.plotLeft,translateY:r?r.top:e.plotTop,scaleX:1,scaleY:1}},n.prototype.removeEvents=function(e){var t=this;e||removeEvent$5(t),t.eventsToUnbind.length&&(t.eventsToUnbind.forEach(function(r){r()}),t.eventsToUnbind.length=0)},n.prototype.render=function(){var e=this,t=e.chart,r=e.options,o=animObject$6(r.animation),s=e.visible?"inherit":"hidden",a=r.zIndex,l=e.hasRendered,h=t.seriesGroup,d=t.inverted,c=!e.finishedAnimating&&t.renderer.isSVG&&o.duration;fireEvent$r(this,"render");var p=e.plotGroup("group","series",s,a,h);e.markerGroup=e.plotGroup("markerGroup","markers",s,a,h),c&&e.animate&&e.animate(!0),p.inverted=pick$1f(e.invertible,e.isCartesian)?d:!1,e.drawGraph&&(e.drawGraph(),e.applyZones()),e.visible&&e.drawPoints(),e.drawDataLabels&&e.drawDataLabels(),e.redrawPoints&&e.redrawPoints(),e.drawTracker&&e.options.enableMouseTracking!==!1&&e.drawTracker(),e.invertGroups(d),r.clip!==!1&&!e.sharedClipKey&&!l&&p.clip(t.clipRect),c&&e.animate&&e.animate(),l||(c&&o.defer&&(c+=o.defer),e.animationTimeout=syncTimeout$2(function(){e.afterAnimate()},c||0)),e.isDirty=!1,e.hasRendered=!0,fireEvent$r(e,"afterRender")},n.prototype.redraw=function(){var e=this,t=e.chart,r=e.isDirty||e.isDirtyData,o=e.group,s=e.xAxis,a=e.yAxis;o&&(t.inverted&&o.attr({width:t.plotWidth,height:t.plotHeight}),o.animate({translateX:pick$1f(s&&s.left,t.plotLeft),translateY:pick$1f(a&&a.top,t.plotTop)})),e.translate(),e.render(),r&&delete this.kdTree},n.prototype.searchPoint=function(e,t){var r=this,o=r.xAxis,s=r.yAxis,a=r.chart.inverted;return this.searchKDTree({clientX:a?o.len-e.chartY+o.pos:e.chartX-o.pos,plotY:a?s.len-e.chartX+s.pos:e.chartY-s.pos},t,e)},n.prototype.buildKDTree=function(e){this.buildingKdTree=!0;var t=this,r=t.options.findNearestPointBy.indexOf("y")>-1?2:1;function o(a,l,h){var d=a&&a.length,c,p;if(d)return c=t.kdAxisArray[l%h],a.sort(function(f,u){return f[c]-u[c]}),p=Math.floor(d/2),{point:a[p],left:o(a.slice(0,p),l+1,h),right:o(a.slice(p+1),l+1,h)}}function s(){t.kdTree=o(t.getValidPoints(null,!t.directTouch),r,r),t.buildingKdTree=!1}delete t.kdTree,syncTimeout$2(s,t.options.kdNow||e&&e.type==="touchstart"?0:1)},n.prototype.searchKDTree=function(e,t,r){var o=this,s=this.kdAxisArray[0],a=this.kdAxisArray[1],l=t?"distX":"dist",h=o.options.findNearestPointBy.indexOf("y")>-1?2:1;function d(p,f){var u=defined$G(p[s])&&defined$G(f[s])?Math.pow(p[s]-f[s],2):null,g=defined$G(p[a])&&defined$G(f[a])?Math.pow(p[a]-f[a],2):null,m=(u||0)+(g||0);f.dist=defined$G(m)?Math.sqrt(m):Number.MAX_VALUE,f.distX=defined$G(u)?Math.sqrt(u):Number.MAX_VALUE}function c(p,f,u,g){var m=f.point,y=o.kdAxisArray[u%g],v,x,b=m;d(p,m);var $=p[y]-m[y],S=$<0?"left":"right",k=$<0?"right":"left";return f[S]&&(v=c(p,f[S],u+1,g),b=v[l]<b[l]?v:m),f[k]&&Math.sqrt($*$)<b[l]&&(x=c(p,f[k],u+1,g),b=x[l]<b[l]?x:b),b}if(!this.kdTree&&!this.buildingKdTree&&this.buildKDTree(r),this.kdTree)return c(e,this.kdTree,h,h)},n.prototype.pointPlacementToXValue=function(){var e=this,t=e.options,r=t.pointPlacement,o=t.pointRange,s=e.xAxis,a=r;return a==="between"&&(a=s.reversed?-.5:.5),isNumber$A(a)?a*(o||s.pointRange):0},n.prototype.isPointInside=function(e){var t=typeof e.plotY<"u"&&typeof e.plotX<"u"&&e.plotY>=0&&e.plotY<=this.yAxis.len&&e.plotX>=0&&e.plotX<=this.xAxis.len;return t},n.prototype.drawTracker=function(){var e=this,t=e.options,r=t.trackByArea,o=[].concat(r?e.areaPath:e.graphPath),s=e.chart,a=s.pointer,l=s.renderer,h=s.options.tooltip.snap,d=e.tracker,c=function(f){s.hoverSeries!==e&&e.onMouseOver()},p="rgba(192,192,192,"+(svg$2?1e-4:.002)+")";d?d.attr({d:o}):e.graph&&(e.tracker=l.path(o).attr({visibility:e.visible?"visible":"hidden",zIndex:2}).addClass(r?"highcharts-tracker-area":"highcharts-tracker-line").add(e.group),s.styledMode||e.tracker.attr({"stroke-linecap":"round","stroke-linejoin":"round",stroke:p,fill:r?p:"none","stroke-width":e.graph.strokeWidth()+(r?0:2*h)}),[e.tracker,e.markerGroup,e.dataLabelsGroup].forEach(function(f){f&&(f.addClass("highcharts-tracker").on("mouseover",c).on("mouseout",function(u){a.onTrackerMouseOut(u)}),t.cursor&&!s.styledMode&&f.css({cursor:t.cursor}),hasTouch$2&&f.on("touchstart",c))})),fireEvent$r(this,"afterDrawTracker")},n.prototype.addPoint=function(e,t,r,o,s){var a=this,l=a.options,h=a.data,d=a.chart,c=a.xAxis,p=c&&c.hasNames&&c.names,f=l.data,u=a.xData,g,m;t=pick$1f(t,!0);var y={series:a};a.pointClass.prototype.applyOptions.apply(y,[e]);var v=y.x;if(m=u.length,a.requireSorting&&v<u[m-1])for(g=!0;m&&u[m-1]>v;)m--;a.updateParallelArrays(y,"splice",m,0,0),a.updateParallelArrays(y,m),p&&y.name&&(p[v]=y.name),f.splice(m,0,e),g&&(a.data.splice(m,0,null),a.processData()),l.legendType==="point"&&a.generatePoints(),r&&(h[0]&&h[0].remove?h[0].remove(!1):(h.shift(),a.updateParallelArrays(y,"shift"),f.shift())),s!==!1&&fireEvent$r(a,"addPoint",{point:y}),a.isDirty=!0,a.isDirtyData=!0,t&&d.redraw(o)},n.prototype.removePoint=function(e,t,r){var o=this,s=o.data,a=s[e],l=o.points,h=o.chart,d=function(){l&&l.length===s.length&&l.splice(e,1),s.splice(e,1),o.options.data.splice(e,1),o.updateParallelArrays(a||{series:o},"splice",e,1),a&&a.destroy(),o.isDirty=!0,o.isDirtyData=!0,t&&h.redraw()};setAnimation$2(r,h),t=pick$1f(t,!0),a?a.firePointEvent("remove",null,d):d()},n.prototype.remove=function(e,t,r,o){var s=this,a=s.chart;function l(){s.destroy(o),a.isDirtyLegend=a.isDirtyBox=!0,a.linkSeries(),pick$1f(e,!0)&&a.redraw(t)}r!==!1?fireEvent$r(s,"remove",null,l):l()},n.prototype.update=function(e,t){e=cleanRecursively(e,this.userOptions),fireEvent$r(this,"update",{options:e});var r=this,o=r.chart,s=r.userOptions,a=r.initialType||r.type,l=o.options.plotOptions,h=seriesTypes$6[a].prototype,d=["group","markerGroup","dataLabelsGroup","transformGroup"],c=r.finishedAnimating&&{animation:!1},p={},f,u,g=["eventOptions","navigatorSeries","baseSeries"],m=e.type||s.type||o.options.chart.type,y=!(this.hasDerivedData||m&&m!==this.type||typeof e.pointStart<"u"||typeof e.pointInterval<"u"||typeof e.relativeXValue<"u"||r.hasOptionChanged("dataGrouping")||r.hasOptionChanged("pointStart")||r.hasOptionChanged("pointInterval")||r.hasOptionChanged("pointIntervalUnit")||r.hasOptionChanged("keys"));m=m||a,y&&(g.push("data","isDirtyData","points","processedXData","processedYData","xIncrement","cropped","_hasPointMarkers","_hasPointLabels","clips","nodes","layout","mapMap","mapData","minY","maxY","minX","maxX"),e.visible!==!1&&g.push("area","graph"),r.parallelArrays.forEach(function(S){g.push(S+"Data")}),e.data&&(e.dataSorting&&extend$1c(r.options.dataSorting,e.dataSorting),this.setData(e.data,!1))),e=merge$18(s,c,{index:typeof s.index>"u"?r.index:s.index,pointStart:pick$1f(l&&l.series&&l.series.pointStart,s.pointStart,r.xData[0])},!y&&{data:r.options.data},e),y&&e.data&&(e.data=r.options.data),g=d.concat(g),g.forEach(function(S){g[S]=r[S],delete r[S]});var v=!1;if(seriesTypes$6[m]){if(v=m!==r.type,r.remove(!1,!1,!1,!0),v)if(Object.setPrototypeOf)Object.setPrototypeOf(r,seriesTypes$6[m].prototype);else{var x=Object.hasOwnProperty.call(r,"hcEvents")&&r.hcEvents;for(u in h)r[u]=void 0;extend$1c(r,seriesTypes$6[m].prototype),x?r.hcEvents=x:delete r.hcEvents}}else error$4(17,!0,o,{missingModuleFor:m});if(g.forEach(function(S){r[S]=g[S]}),r.init(o,e),y&&this.points){if(f=r.options,f.visible===!1)p.graphic=1,p.dataLabel=1;else if(!r._hasPointLabels){var b=f.marker,$=f.dataLabels;b&&(b.enabled===!1||(s.marker&&s.marker.symbol)!==b.symbol)&&(p.graphic=1),$&&$.enabled===!1&&(p.dataLabel=1)}this.points.forEach(function(S){S&&S.series&&(S.resolveColor(),Object.keys(p).length&&S.destroyElements(p),f.showInLegend===!1&&S.legendItem&&o.legend.destroyItem(S))},this)}r.initialType=a,o.linkSeries(),v&&r.linkedSeries.length&&(r.isDirtyData=!0),fireEvent$r(this,"afterUpdate"),pick$1f(t,!0)&&o.redraw(y?void 0:!1)},n.prototype.setName=function(e){this.name=this.options.name=this.userOptions.name=e,this.chart.isDirtyLegend=!0},n.prototype.hasOptionChanged=function(e){var t=this.chart,r=this.options[e],o=t.options.plotOptions,s=this.userOptions[e];return s?r!==s:r!==pick$1f(o&&o[this.type]&&o[this.type][e],o&&o.series&&o.series[e],r)},n.prototype.onMouseOver=function(){var e=this,t=e.chart,r=t.hoverSeries,o=t.pointer;o.setHoverChartIndex(),r&&r!==e&&r.onMouseOut(),e.options.events.mouseOver&&fireEvent$r(e,"mouseOver"),e.setState("hover"),t.hoverSeries=e},n.prototype.onMouseOut=function(){var e=this,t=e.options,r=e.chart,o=r.tooltip,s=r.hoverPoint;r.hoverSeries=null,s&&s.onMouseOut(),e&&t.events.mouseOut&&fireEvent$r(e,"mouseOut"),o&&!e.stickyTracking&&(!o.shared||e.noSharedTooltip)&&o.hide(),r.series.forEach(function(a){a.setState("",!0)})},n.prototype.setState=function(e,t){var r=this,o=r.options,s=r.graph,a=o.inactiveOtherPoints,l=o.states,h=pick$1f(l[e||"normal"]&&l[e||"normal"].animation,r.chart.options.chart.animation),d,c=o.lineWidth,p=0,f=o.opacity;if(e=e||"",r.state!==e&&([r.group,r.markerGroup,r.dataLabelsGroup].forEach(function(u){u&&(r.state&&u.removeClass("highcharts-series-"+r.state),e&&u.addClass("highcharts-series-"+e))}),r.state=e,!r.chart.styledMode)){if(l[e]&&l[e].enabled===!1)return;if(e&&(c=l[e].lineWidth||c+(l[e].lineWidthPlus||0),f=pick$1f(l[e].opacity,f)),s&&!s.dashstyle)for(d={"stroke-width":c},s.animate(d,h);r["zone-graph-"+p];)r["zone-graph-"+p].animate(d,h),p=p+1;a||[r.group,r.markerGroup,r.dataLabelsGroup,r.labelBySeries].forEach(function(u){u&&u.animate({opacity:f},h)})}t&&a&&r.points&&r.setAllPointsToState(e||void 0)},n.prototype.setAllPointsToState=function(e){this.points.forEach(function(t){t.setState&&t.setState(e)})},n.prototype.setVisible=function(e,t){var r=this,o=r.chart,s=r.legendItem,a=o.options.chart.ignoreHiddenSeries,l=r.visible;r.visible=e=r.options.visible=r.userOptions.visible=typeof e>"u"?!l:e;var h=e?"show":"hide";["group","dataLabelsGroup","markerGroup","tracker","tt"].forEach(function(d){r[d]&&r[d][h]()}),(o.hoverSeries===r||(o.hoverPoint&&o.hoverPoint.series)===r)&&r.onMouseOut(),s&&o.legend.colorizeItem(r,e),r.isDirty=!0,r.options.stacking&&o.series.forEach(function(d){d.options.stacking&&d.visible&&(d.isDirty=!0)}),r.linkedSeries.forEach(function(d){d.setVisible(e,!1)}),a&&(o.isDirtyBox=!0),fireEvent$r(r,h),t!==!1&&o.redraw()},n.prototype.show=function(){this.setVisible(!0)},n.prototype.hide=function(){this.setVisible(!1)},n.prototype.select=function(e){var t=this;t.selected=e=this.options.selected=typeof e>"u"?!t.selected:e,t.checkbox&&(t.checkbox.checked=e),fireEvent$r(t,e?"select":"unselect")},n.prototype.shouldShowTooltip=function(e,t,r){return r===void 0&&(r={}),r.series=this,r.visiblePlotOnly=!0,this.chart.isInsidePlot(e,t,r)},n.defaultOptions=seriesDefaults,n}();extend$1c(Series$e.prototype,{axisTypes:["xAxis","yAxis"],coll:"series",colorCounter:0,cropShoulder:1,directTouch:!1,drawLegendSymbol:LegendSymbol$1.drawLineMarker,isCartesian:!0,kdAxisArray:["clientX","plotY"],parallelArrays:["x","y"],pointClass:Point$2,requireSorting:!0,sorted:!0});SeriesRegistry$1.series=Series$e;var stop=animationExports.stop,addEvent$R=Utilities.addEvent,createElement$4=Utilities.createElement,merge$17=Utilities.merge,pick$1e=Utilities.pick;addEvent$R(Chart$1,"afterSetChartSize",function(n){var e=this.options.chart.scrollablePlotArea,t=e&&e.minWidth,r=e&&e.minHeight,o,s,a;this.renderer.forExport||(t?(this.scrollablePixelsX=o=Math.max(0,t-this.chartWidth),o&&(this.scrollablePlotBox=this.renderer.scrollablePlotBox=merge$17(this.plotBox),this.plotBox.width=this.plotWidth+=o,this.inverted?this.clipBox.height+=o:this.clipBox.width+=o,a={1:{name:"right",value:o}})):r&&(this.scrollablePixelsY=s=Math.max(0,r-this.chartHeight),s&&(this.scrollablePlotBox=this.renderer.scrollablePlotBox=merge$17(this.plotBox),this.plotBox.height=this.plotHeight+=s,this.inverted?this.clipBox.width+=s:this.clipBox.height+=s,a={2:{name:"bottom",value:s}})),a&&!n.skipAxes&&this.axes.forEach(function(l){a[l.side]?l.getPlotLinePath=function(){var h=a[l.side].name,d=a[l.side].value,c=this[h],p;return this[h]=c-d,p=Axis.prototype.getPlotLinePath.apply(this,arguments),this[h]=c,p}:(l.setAxisSize(),l.setAxisTranslation())}))});addEvent$R(Chart$1,"render",function(){this.scrollablePixelsX||this.scrollablePixelsY?(this.setUpScrolling&&this.setUpScrolling(),this.applyFixed()):this.fixedDiv&&this.applyFixed()});Chart$1.prototype.setUpScrolling=function(){var n=this,e={WebkitOverflowScrolling:"touch",overflowX:"hidden",overflowY:"hidden"};this.scrollablePixelsX&&(e.overflowX="auto"),this.scrollablePixelsY&&(e.overflowY="auto"),this.scrollingParent=createElement$4("div",{className:"highcharts-scrolling-parent"},{position:"relative"},this.renderTo),this.scrollingContainer=createElement$4("div",{className:"highcharts-scrolling"},e,this.scrollingParent),addEvent$R(this.scrollingContainer,"scroll",function(){n.pointer&&delete n.pointer.chartPosition}),this.innerContainer=createElement$4("div",{className:"highcharts-inner-container"},null,this.scrollingContainer),this.innerContainer.appendChild(this.container),this.setUpScrolling=null};Chart$1.prototype.moveFixedElements=function(){var n=this.container,e=this.fixedRenderer,t=[".highcharts-contextbutton",".highcharts-credits",".highcharts-legend",".highcharts-legend-checkbox",".highcharts-navigator-series",".highcharts-navigator-xaxis",".highcharts-navigator-yaxis",".highcharts-navigator",".highcharts-reset-zoom",".highcharts-drillup-button",".highcharts-scrollbar",".highcharts-subtitle",".highcharts-title"],r;this.scrollablePixelsX&&!this.inverted?r=".highcharts-yaxis":this.scrollablePixelsX&&this.inverted||this.scrollablePixelsY&&!this.inverted?r=".highcharts-xaxis":this.scrollablePixelsY&&this.inverted&&(r=".highcharts-yaxis"),r&&t.push(r+":not(.highcharts-radial-axis)",r+"-labels:not(.highcharts-radial-axis-labels)"),t.forEach(function(o){[].forEach.call(n.querySelectorAll(o),function(s){(s.namespaceURI===e.SVG_NS?e.box:e.box.parentNode).appendChild(s),s.style.pointerEvents="auto"})})};Chart$1.prototype.applyFixed=function(){var n=!this.fixedDiv,e=this.options.chart,t=e.scrollablePlotArea,r=RendererRegistry$1.getRendererType(),o,s,a;n?(this.fixedDiv=createElement$4("div",{className:"highcharts-fixed"},{position:"absolute",overflow:"hidden",pointerEvents:"none",zIndex:(e.style&&e.style.zIndex||0)+2,top:0},null,!0),this.scrollingContainer&&this.scrollingContainer.parentNode.insertBefore(this.fixedDiv,this.scrollingContainer),this.renderTo.style.overflow="visible",this.fixedRenderer=o=new r(this.fixedDiv,this.chartWidth,this.chartHeight,this.options.chart.style),this.scrollableMask=o.path().attr({fill:this.options.chart.backgroundColor||"#fff","fill-opacity":pick$1e(t.opacity,.85),zIndex:-1}).addClass("highcharts-scrollable-mask").add(),addEvent$R(this,"afterShowResetZoom",this.moveFixedElements),addEvent$R(this,"afterDrilldown",this.moveFixedElements),addEvent$R(this,"afterLayOutTitles",this.moveFixedElements)):this.fixedRenderer.setSize(this.chartWidth,this.chartHeight),(this.scrollableDirty||n)&&(this.scrollableDirty=!1,this.moveFixedElements()),s=this.chartWidth+(this.scrollablePixelsX||0),a=this.chartHeight+(this.scrollablePixelsY||0),stop(this.container),this.container.style.width=s+"px",this.container.style.height=a+"px",this.renderer.boxWrapper.attr({width:s,height:a,viewBox:[0,0,s,a].join(" ")}),this.chartBackground.attr({width:s,height:a}),this.scrollingContainer.style.height=this.chartHeight+"px",n&&(t.scrollPositionX&&(this.scrollingContainer.scrollLeft=this.scrollablePixelsX*t.scrollPositionX),t.scrollPositionY&&(this.scrollingContainer.scrollTop=this.scrollablePixelsY*t.scrollPositionY));var l=this.axisOffset,h=this.plotTop-l[0]-1,d=this.plotLeft-l[3]-1,c=this.plotTop+this.plotHeight+l[2]+1,p=this.plotLeft+this.plotWidth+l[1]+1,f=this.plotLeft+this.plotWidth-(this.scrollablePixelsX||0),u=this.plotTop+this.plotHeight-(this.scrollablePixelsY||0),g;this.scrollablePixelsX?g=[["M",0,h],["L",this.plotLeft-1,h],["L",this.plotLeft-1,c],["L",0,c],["Z"],["M",f,h],["L",this.chartWidth,h],["L",this.chartWidth,c],["L",f,c],["Z"]]:this.scrollablePixelsY?g=[["M",d,0],["L",d,this.plotTop-1],["L",p,this.plotTop-1],["L",p,0],["Z"],["M",d,u],["L",d,this.chartHeight],["L",p,this.chartHeight],["L",p,u],["Z"]]:g=[["M",0,0]],this.redrawTrigger!=="adjustHeight"&&this.scrollableMask.attr({d:g})};addEvent$R(Axis,"afterInit",function(){this.chart.scrollableDirty=!0});addEvent$R(Series$e,"show",function(){this.chart.scrollableDirty=!0});var getDeferredAnimation$2=animationExports.getDeferredAnimation,addEvent$Q=Utilities.addEvent,destroyObjectProperties$5=Utilities.destroyObjectProperties,fireEvent$q=Utilities.fireEvent,isNumber$z=Utilities.isNumber,objectEach$l=Utilities.objectEach,StackingAxis;(function(n){var e=[];function t(a){return e.indexOf(a)===-1&&(e.push(a),addEvent$Q(a,"init",o),addEvent$Q(a,"destroy",r)),a}n.compose=t;function r(){var a=this.stacking;if(a){var l=a.stacks;objectEach$l(l,function(h,d){destroyObjectProperties$5(h),l[d]=null}),a&&a.stackTotalGroup&&a.stackTotalGroup.destroy()}}function o(){var a=this;a.stacking||(a.stacking=new s(a))}var s=function(){function a(l){this.oldStacks={},this.stacks={},this.stacksTouched=0,this.axis=l}return a.prototype.buildStacks=function(){var l=this,h=l.axis,d=h.series,c=h.options.reversedStacks,p=d.length,f,u;if(!h.isXAxis){for(l.usePercentage=!1,u=p;u--;)f=d[c?u:p-u-1],f.setStackedPoints(),f.setGroupedPoints();for(u=0;u<p;u++)d[u].modifyStacks();fireEvent$q(h,"afterBuildStacks")}},a.prototype.cleanStacks=function(){var l=this,h=l.axis,d;h.isXAxis||(l.oldStacks&&(d=l.stacks=l.oldStacks),objectEach$l(d,function(c){objectEach$l(c,function(p){p.cumulative=p.total})}))},a.prototype.resetStacks=function(){var l=this,h=l.axis,d=l.stacks;h.isXAxis||objectEach$l(d,function(c){objectEach$l(c,function(p,f){isNumber$z(p.touched)&&p.touched<l.stacksTouched?(p.destroy(),delete c[f]):(p.total=null,p.cumulative=null)})})},a.prototype.renderStackTotals=function(){var l=this,h=l.axis,d=h.chart,c=d.renderer,p=l.stacks,f=h.options.stackLabels&&h.options.stackLabels.animation,u=getDeferredAnimation$2(d,f||!1),g=l.stackTotalGroup=l.stackTotalGroup||c.g("stack-labels").attr({visibility:"visible",zIndex:6,opacity:0}).add();g.translate(d.plotLeft,d.plotTop),objectEach$l(p,function(m){objectEach$l(m,function(y){y.render(g)})}),g.animate({opacity:1},u)},a}();n.Additions=s})(StackingAxis||(StackingAxis={}));const StackingAxis$1=StackingAxis;var format$9=FormatUtilities.format,correctFloat$9=Utilities.correctFloat,defined$F=Utilities.defined,destroyObjectProperties$4=Utilities.destroyObjectProperties,isArray$e=Utilities.isArray,isNumber$y=Utilities.isNumber,objectEach$k=Utilities.objectEach,pick$1d=Utilities.pick,StackItem=function(){function n(e,t,r,o,s){var a=e.chart.inverted;this.axis=e,this.isNegative=r,this.options=t=t||{},this.x=o,this.total=null,this.points={},this.hasValidPoints=!1,this.stack=s,this.leftCliff=0,this.rightCliff=0,this.alignOptions={align:t.align||(a?r?"left":"right":"center"),verticalAlign:t.verticalAlign||(a?"middle":r?"bottom":"top"),y:t.y,x:t.x},this.textAlign=t.textAlign||(a?r?"right":"left":"center")}return n.prototype.destroy=function(){destroyObjectProperties$4(this,this.axis)},n.prototype.render=function(e){var t=this.axis.chart,r=this.options,o=r.format,s={},a=o?format$9(o,this,t):r.formatter.call(this);this.label?this.label.attr({text:a,visibility:"hidden"}):(this.label=t.renderer.label(a,null,null,r.shape,null,null,r.useHTML,!1,"stack-labels"),s={r:r.borderRadius||0,text:a,rotation:r.rotation,padding:pick$1d(r.padding,5),visibility:"hidden"},t.styledMode||(s.fill=r.backgroundColor,s.stroke=r.borderColor,s["stroke-width"]=r.borderWidth,this.label.css(r.style)),this.label.attr(s),this.label.added||this.label.add(e)),this.label.labelrank=t.plotSizeY},n.prototype.setOffset=function(e,t,r,o,s){var a=this,l=a.axis,h=l.chart,d=l.translate(l.stacking.usePercentage?100:o||a.total,0,0,0,1),c=l.translate(r||0),p=defined$F(d)&&Math.abs(d-c),f=pick$1d(s,h.xAxis[0].translate(a.x))+e,u=defined$F(d)&&a.getStackBox(h,a,f,d,t,p,l),g=a.label,m=a.isNegative,y=pick$1d(a.options.overflow,"justify")==="justify",v=a.textAlign,x;if(g&&u){var b=g.getBBox(),$=g.padding,S=void 0,k=void 0;v==="left"?S=h.inverted?-$:$:v==="right"?S=b.width:h.inverted&&v==="center"?S=b.width/2:S=h.inverted?m?b.width+$:-$:b.width/2,k=h.inverted?b.height/2:m?-$:b.height,a.alignOptions.x=pick$1d(a.options.x,0),a.alignOptions.y=pick$1d(a.options.y,0),u.x-=S,u.y-=k,g.align(a.alignOptions,null,u),h.isInsidePlot(g.alignAttr.x+S-a.alignOptions.x,g.alignAttr.y+k-a.alignOptions.y)?g.show():(g.alignAttr.y=-9999,y=!1),y&&Series$e.prototype.justifyDataLabel.call(this.axis,g,a.alignOptions,g.alignAttr,b,u),g.attr({x:g.alignAttr.x,y:g.alignAttr.y}),pick$1d(!y&&a.options.crop,!0)&&(x=isNumber$y(g.x)&&isNumber$y(g.y)&&h.isInsidePlot(g.x-$+g.width,g.y)&&h.isInsidePlot(g.x+$,g.y),x||g.hide())}},n.prototype.getStackBox=function(e,t,r,o,s,a,l){var h=t.axis.reversed,d=e.inverted,c=l.height+l.pos-(d?e.plotLeft:e.plotTop),p=t.isNegative&&!h||!t.isNegative&&h;return{x:d?p?o-l.right:o-a+l.pos-e.plotLeft:r+e.xAxis[0].transB-e.plotLeft,y:d?l.height-r-s:p?c-o-a:c-o,width:d?a:s,height:d?s:a}},n}();Chart$1.prototype.getStacks=function(){var n=this,e=n.inverted;n.yAxis.forEach(function(t){t.stacking&&t.stacking.stacks&&t.hasVisibleSeries&&(t.stacking.oldStacks=t.stacking.stacks)}),n.series.forEach(function(t){var r=t.xAxis&&t.xAxis.options||{};t.options.stacking&&(t.visible===!0||n.options.chart.ignoreHiddenSeries===!1)&&(t.stackKey=[t.type,pick$1d(t.options.stack,""),e?r.top:r.left,e?r.height:r.width].join(","))})};StackingAxis$1.compose(Axis);Series$e.prototype.setGroupedPoints=function(){var n=this.yAxis.stacking;this.options.centerInCategory&&(this.is("column")||this.is("columnrange"))&&!this.options.stacking&&this.chart.series.length>1?Series$e.prototype.setStackedPoints.call(this,"group"):n&&objectEach$k(n.stacks,function(e,t){t.slice(-5)==="group"&&(objectEach$k(e,function(r){return r.destroy()}),delete n.stacks[t])})};Series$e.prototype.setStackedPoints=function(n){var e=n||this.options.stacking;if(!(!e||this.visible!==!0&&this.chart.options.chart.ignoreHiddenSeries!==!1)){var t=this,r=t.processedXData,o=t.processedYData,s=[],a=o.length,l=t.options,h=l.threshold,d=pick$1d(l.startFromThreshold&&h,0),c=l.stack,p=n?t.type+","+e:t.stackKey,f="-"+p,u=t.negStacks,g=t.yAxis,m=g.stacking.stacks,y=g.stacking.oldStacks,v,x,b,$,S,k,A,M,P;for(g.stacking.stacksTouched+=1,A=0;A<a;A++)M=r[A],P=o[A],v=t.getStackIndicator(v,M,t.index),k=v.key,x=u&&P<(d?0:h),S=x?f:p,m[S]||(m[S]={}),m[S][M]||(y[S]&&y[S][M]?(m[S][M]=y[S][M],m[S][M].total=null):m[S][M]=new StackItem(g,g.options.stackLabels,x,M,c)),b=m[S][M],P!==null?(b.points[k]=b.points[t.index]=[pick$1d(b.cumulative,d)],defined$F(b.cumulative)||(b.base=k),b.touched=g.stacking.stacksTouched,v.index>0&&t.singleStacks===!1&&(b.points[k][0]=b.points[t.index+","+M+",0"][0])):b.points[k]=b.points[t.index]=null,e==="percent"?($=x?p:f,u&&m[$]&&m[$][M]?($=m[$][M],b.total=$.total=Math.max($.total,b.total)+Math.abs(P)||0):b.total=correctFloat$9(b.total+(Math.abs(P)||0))):e==="group"?(isArray$e(P)&&(P=P[0]),P!==null&&(b.total=(b.total||0)+1)):b.total=correctFloat$9(b.total+(P||0)),e==="group"?b.cumulative=(b.total||1)-1:b.cumulative=pick$1d(b.cumulative,d)+(P||0),P!==null&&(b.points[k].push(b.cumulative),s[A]=b.cumulative,b.hasValidPoints=!0);e==="percent"&&(g.stacking.usePercentage=!0),e!=="group"&&(this.stackedYData=s),g.stacking.oldStacks={}}};Series$e.prototype.modifyStacks=function(){var n=this,e=n.yAxis,t=n.stackKey,r=e.stacking.stacks,o=n.processedXData,s,a=n.options.stacking;n[a+"Stacker"]&&[t,"-"+t].forEach(function(l){for(var h=o.length,d,c,p;h--;)d=o[h],s=n.getStackIndicator(s,d,n.index,l),c=r[l]&&r[l][d],p=c&&c.points[s.key],p&&n[a+"Stacker"](p,c,h)})};Series$e.prototype.percentStacker=function(n,e,t){var r=e.total?100/e.total:0;n[0]=correctFloat$9(n[0]*r),n[1]=correctFloat$9(n[1]*r),this.stackedYData[t]=n[1]};Series$e.prototype.getStackIndicator=function(n,e,t,r){return!defined$F(n)||n.x!==e||r&&n.key!==r?n={x:e,index:0,key:r}:n.index++,n.key=[t,e,n.index].join(","),n};H.StackItem=StackItem;const StackItem$1=H.StackItem;var __extends$U=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),defined$E=Utilities.defined,merge$16=Utilities.merge,LineSeries$5=function(n){__extends$U(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.drawGraph=function(){var t=this,r=this.options,o=(this.gappedPath||this.getGraphPath).call(this),s=this.chart.styledMode,a=[["graph","highcharts-graph"]];s||a[0].push(r.lineColor||this.color||palette.neutralColor20,r.dashStyle),a=t.getZonesGraphs(a),a.forEach(function(l,h){var d=l[0],c,p=t[d],f=p?"animate":"attr";p?(p.endX=t.preventGraphAnimation?null:o.xMap,p.animate({d:o})):o.length&&(t[d]=p=t.chart.renderer.path(o).addClass(l[1]).attr({zIndex:1}).add(t.group)),p&&!s&&(c={stroke:l[2],"stroke-width":r.lineWidth,fill:t.fillGraph&&t.color||"none"},l[3]?c.dashstyle=l[3]:r.linecap!=="square"&&(c["stroke-linecap"]=c["stroke-linejoin"]="round"),p[f](c).shadow(h<2&&r.shadow)),p&&(p.startX=o.xMap,p.isArea=o.isArea)})},e.prototype.getGraphPath=function(t,r,o){var s=this,a=s.options,l=[],h=[],d,c=a.step;t=t||s.points;var p=t.reversed;return p&&t.reverse(),c={right:1,center:2}[c]||c&&3,c&&p&&(c=4-c),t=this.getValidPoints(t,!1,!(a.connectNulls&&!r&&!o)),t.forEach(function(f,u){var g=f.plotX,m=f.plotY,y=t[u-1],v;(f.leftCliff||y&&y.rightCliff)&&!o&&(d=!0),f.isNull&&!defined$E(r)&&u>0?d=!a.connectNulls:f.isNull&&!r?d=!0:(u===0||d?v=[["M",f.plotX,f.plotY]]:s.getPointSpline?v=[s.getPointSpline(t,f,u)]:c?(c===1?v=[["L",y.plotX,m]]:c===2?v=[["L",(y.plotX+g)/2,y.plotY],["L",(y.plotX+g)/2,m]]:v=[["L",g,y.plotY]],v.push(["L",g,m])):v=[["L",g,m]],h.push(f.x),c&&(h.push(f.x),c===2&&h.push(f.x)),l.push.apply(l,v),d=!1)}),l.xMap=h,s.graphPath=l,l},e.prototype.getZonesGraphs=function(t){return this.zones.forEach(function(r,o){var s=["zone-graph-"+o,"highcharts-graph highcharts-zone-graph-"+o+" "+(r.className||"")];this.chart.styledMode||s.push(r.color||this.color,r.dashStyle||this.options.dashStyle),t.push(s)},this),t},e.defaultOptions=merge$16(Series$e.defaultOptions,{}),e}(Series$e);SeriesRegistry$1.registerSeriesType("line",LineSeries$5);var __extends$T=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),color$d=Color.parse,LineSeries$4=SeriesRegistry$1.seriesTypes.line,extend$1b=Utilities.extend,merge$15=Utilities.merge,objectEach$j=Utilities.objectEach,pick$1c=Utilities.pick,AreaSeries$1=function(n){__extends$T(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.drawGraph=function(){this.areaPath=[],n.prototype.drawGraph.apply(this);var t=this,r=this.areaPath,o=this.options,s=this.zones,a=[["area","highcharts-area",this.color,o.fillColor]];s.forEach(function(l,h){a.push(["zone-area-"+h,"highcharts-area highcharts-zone-area-"+h+" "+l.className,l.color||t.color,l.fillColor||o.fillColor])}),a.forEach(function(l){var h=l[0],d=t[h],c=d?"animate":"attr",p={};d?(d.endX=t.preventGraphAnimation?null:r.xMap,d.animate({d:r})):(p.zIndex=0,d=t[h]=t.chart.renderer.path(r).addClass(l[1]).add(t.group),d.isArea=!0),t.chart.styledMode||(p.fill=pick$1c(l[3],color$d(l[2]).setOpacity(pick$1c(o.fillOpacity,.75)).get())),d[c](p),d.startX=r.xMap,d.shiftUnit=o.step?2:1})},e.prototype.getGraphPath=function(t){var r=LineSeries$4.prototype.getGraphPath,o,s=this.options,a=s.stacking,l=this.yAxis,h,d,c=[],p=[],f=this.index,u,g,m,y=l.stacking.stacks[this.stackKey],v=s.threshold,x=Math.round(l.getThreshold(s.threshold)),b,$,S=pick$1c(s.connectNulls,a==="percent"),k=function(M,P,E){var T=t[M],O=a&&y[T.x].points[f],C=T[E+"Null"]||0,I=T[E+"Cliff"]||0,L,D,N=!0;I||C?(L=(C?O[0]:O[1])+I,D=O[0]+I,N=!!C):!a&&t[P]&&t[P].isNull&&(L=D=v),typeof L<"u"&&(p.push({plotX:m,plotY:L===null?x:l.getThreshold(L),isNull:N,isCliff:!0}),c.push({plotX:m,plotY:D===null?x:l.getThreshold(D),doCurve:!1}))};for(t=t||this.points,a&&(t=this.getStackPoints(t)),u=0;u<t.length;u++)a||(t[u].leftCliff=t[u].rightCliff=t[u].leftNull=t[u].rightNull=void 0),b=t[u].isNull,m=pick$1c(t[u].rectPlotX,t[u].plotX),$=a?pick$1c(t[u].yBottom,x):x,(!b||S)&&(S||k(u,u-1,"left"),b&&!a&&S||(p.push(t[u]),c.push({x:u,plotX:m,plotY:$})),S||k(u,u+1,"right"));h=r.call(this,p,!0,!0),c.reversed=!0,d=r.call(this,c,!0,!0);var A=d[0];return A&&A[0]==="M"&&(d[0]=["L",A[1],A[2]]),g=h.concat(d),g.length&&g.push(["Z"]),o=r.call(this,p,!1,S),g.xMap=h.xMap,this.areaPath=g,o},e.prototype.getStackPoints=function(t){var r=this,o=[],s=[],a=this.xAxis,l=this.yAxis,h=l.stacking.stacks[this.stackKey],d={},c=l.series,p=c.length,f=l.options.reversedStacks?1:-1,u=c.indexOf(r);if(t=t||this.points,this.options.stacking){for(var g=0;g<t.length;g++)t[g].leftNull=t[g].rightNull=void 0,d[t[g].x]=t[g];objectEach$j(h,function(y,v){y.total!==null&&s.push(v)}),s.sort(function(y,v){return y-v});var m=c.map(function(y){return y.visible});s.forEach(function(y,v){var x=0,b,$;if(d[y]&&!d[y].isNull)o.push(d[y]),[-1,1].forEach(function(A){var M=A===1?"rightNull":"leftNull",P=A===1?"rightCliff":"leftCliff",E=0,T=h[s[v+A]];if(T)for(var O=u;O>=0&&O<p;){var C=c[O].index;b=T.points[C],b||(C===r.index?d[y][M]=!0:m[O]&&($=h[y].points[C],$&&(E-=$[1]-$[0]))),O+=f}d[y][P]=E});else{for(var S=u;S>=0&&S<p;){var k=c[S].index;if(b=h[y].points[k],b){x=b[1];break}S+=f}x=pick$1c(x,0),x=l.translate(x,0,1,0,1),o.push({isNull:!0,plotX:a.translate(y,0,0,0,1),x:y,plotY:x,yBottom:x})}})}return o},e.defaultOptions=merge$15(LineSeries$4.defaultOptions,{threshold:0}),e}(LineSeries$4);extend$1b(AreaSeries$1.prototype,{singleStacks:!1,drawLegendSymbol:LegendSymbol$1.drawRectangle});SeriesRegistry$1.registerSeriesType("area",AreaSeries$1);var __extends$S=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),LineSeries$3=SeriesRegistry$1.seriesTypes.line,merge$14=Utilities.merge,pick$1b=Utilities.pick,SplineSeries$1=function(n){__extends$S(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.getPointSpline=function(t,r,o){var s=1.5,a=s+1,l=r.plotX||0,h=r.plotY||0,d=t[o-1],c=t[o+1],p,f,u,g,m;function y(k){return k&&!k.isNull&&k.doCurve!==!1&&!r.isCliff}if(y(d)&&y(c)){var v=d.plotX||0,x=d.plotY||0,b=c.plotX||0,$=c.plotY||0,S=0;p=(s*l+v)/a,f=(s*h+x)/a,u=(s*l+b)/a,g=(s*h+$)/a,u!==p&&(S=(g-f)*(u-l)/(u-p)+h-g),f+=S,g+=S,f>x&&f>h?(f=Math.max(x,h),g=2*h-f):f<x&&f<h&&(f=Math.min(x,h),g=2*h-f),g>$&&g>h?(g=Math.max($,h),f=2*h-g):g<$&&g<h&&(g=Math.min($,h),f=2*h-g),r.rightContX=u,r.rightContY=g}return m=["C",pick$1b(d.rightContX,d.plotX,0),pick$1b(d.rightContY,d.plotY,0),pick$1b(p,l,0),pick$1b(f,h,0),l,h],d.rightContX=d.rightContY=void 0,m},e.defaultOptions=merge$14(LineSeries$3.defaultOptions),e}(LineSeries$3);SeriesRegistry$1.registerSeriesType("spline",SplineSeries$1);var __extends$R=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),areaProto$1=AreaSeries$1.prototype,extend$1a=Utilities.extend,merge$13=Utilities.merge,AreaSplineSeries=function(n){__extends$R(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.points=void 0,t.options=void 0,t}return e.defaultOptions=merge$13(SplineSeries$1.defaultOptions,AreaSeries$1.defaultOptions),e}(SplineSeries$1);extend$1a(AreaSplineSeries.prototype,{getGraphPath:areaProto$1.getGraphPath,getStackPoints:areaProto$1.getStackPoints,drawGraph:areaProto$1.drawGraph,drawLegendSymbol:LegendSymbol$1.drawRectangle});SeriesRegistry$1.registerSeriesType("areaspline",AreaSplineSeries);var __extends$Q=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),animObject$5=animationExports.animObject,color$c=Color.parse,hasTouch$1=H.hasTouch,noop$h=H.noop,clamp$d=Utilities.clamp,css$4=Utilities.css,defined$D=Utilities.defined,extend$19=Utilities.extend,fireEvent$p=Utilities.fireEvent,isArray$d=Utilities.isArray,isNumber$x=Utilities.isNumber,merge$12=Utilities.merge,pick$1a=Utilities.pick,objectEach$i=Utilities.objectEach,ColumnSeries$h=function(n){__extends$Q(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.borderWidth=void 0,t.data=void 0,t.group=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.animate=function(t){var r=this,o=this.yAxis,s=r.options,a=this.chart.inverted,l={},h=a?"translateX":"translateY",d,c;t?(l.scaleY=.001,c=clamp$d(o.toPixels(s.threshold),o.pos,o.pos+o.len),a?l.translateX=c-o.len:l.translateY=c,r.clipBox&&r.setClip(),r.group.attr(l)):(d=Number(r.group.attr(h)),r.group.animate({scaleY:1},extend$19(animObject$5(r.options.animation),{step:function(p,f){r.group&&(l[h]=d+f.pos*(o.pos-d),r.group.attr(l))}})))},e.prototype.init=function(t,r){n.prototype.init.apply(this,arguments);var o=this;t=o.chart,t.hasRendered&&t.series.forEach(function(s){s.type===o.type&&(s.isDirty=!0)})},e.prototype.getColumnMetrics=function(){var t=this,r=t.options,o=t.xAxis,s=t.yAxis,a=o.options.reversedStacks,l=o.reversed&&!a||!o.reversed&&a,h={},d,c=0;r.grouping===!1?c=1:t.chart.series.forEach(function(b){var $=b.yAxis,S=b.options,k;b.type===t.type&&(b.visible||!t.chart.options.chart.ignoreHiddenSeries)&&s.len===$.len&&s.pos===$.pos&&(S.stacking&&S.stacking!=="group"?(d=b.stackKey,typeof h[d]>"u"&&(h[d]=c++),k=h[d]):S.grouping!==!1&&(k=c++),b.columnIndex=k)});var p=Math.min(Math.abs(o.transA)*(o.ordinal&&o.ordinal.slope||r.pointRange||o.closestPointRange||o.tickInterval||1),o.len),f=p*r.groupPadding,u=p-2*f,g=u/(c||1),m=Math.min(r.maxPointWidth||o.len,pick$1a(r.pointWidth,g*(1-2*r.pointPadding))),y=(g-m)/2,v=(t.columnIndex||0)+(l?1:0),x=y+(f+v*g-p/2)*(l?-1:1);return t.columnMetrics={width:m,offset:x,paddedWidth:g,columnCount:c},t.columnMetrics},e.prototype.crispCol=function(t,r,o,s){var a=this.chart,l=this.borderWidth,h=-(l%2?.5:0),d,c=l%2?.5:1;a.inverted&&a.renderer.isVML&&(c+=1),this.options.crisp&&(d=Math.round(t+o)+h,t=Math.round(t)+h,o=d-t);var p=Math.round(r+s)+c,f=Math.abs(r)<=.5&&p>.5;return r=Math.round(r)+c,s=p-r,f&&s&&(r-=1,s+=1),{x:t,y:r,width:o,height:s}},e.prototype.adjustForMissingColumns=function(t,r,o,s){var a=this,l=this.options.stacking;if(!o.isNull&&s.columnCount>1){var h=0,d=0;objectEach$i(this.yAxis.stacking&&this.yAxis.stacking.stacks,function(p){if(typeof o.x=="number"){var f=p[o.x.toString()];if(f){var u=f.points[a.index],g=f.total;l?(u&&(h=d),f.hasValidPoints&&d++):isArray$d(u)&&(h=u[1],d=g||0)}}});var c=(d-1)*s.paddedWidth+r;t=(o.plotX||0)+c/2-r-h*s.paddedWidth}return t},e.prototype.translate=function(){var t=this,r=t.chart,o=t.options,s=t.dense=t.closestPointRange*t.xAxis.transA<2,a=t.borderWidth=pick$1a(o.borderWidth,s?0:1),l=t.xAxis,h=t.yAxis,d=o.threshold,c=t.translatedThreshold=h.getThreshold(d),p=pick$1a(o.minPointLength,5),f=t.getColumnMetrics(),u=f.width,g=t.pointXOffset=f.offset,m=t.dataMin,y=t.dataMax,v=t.barW=Math.max(u,1+2*a);r.inverted&&(c-=.5),o.pointPadding&&(v=Math.ceil(v)),Series$e.prototype.translate.apply(t),t.points.forEach(function(x){var b=pick$1a(x.yBottom,c),$=999+Math.abs(b),S=x.plotX||0,k=clamp$d(x.plotY,-$,h.len+$),A,M=Math.min(k,b),P=Math.max(k,b)-M,E=u,T=S+g,O=v;p&&Math.abs(P)<p&&(P=p,A=!h.reversed&&!x.negative||h.reversed&&x.negative,isNumber$x(d)&&isNumber$x(y)&&x.y===d&&y<=d&&(h.min||0)<d&&(m!==y||(h.max||0)<=d)&&(A=!A),M=Math.abs(M-c)>p?b-p:c-(A?p:0)),defined$D(x.options.pointWidth)&&(E=O=Math.ceil(x.options.pointWidth),T-=Math.round((E-u)/2)),o.centerInCategory&&(T=t.adjustForMissingColumns(T,E,x,f)),x.barX=T,x.pointWidth=E,x.tooltipPos=r.inverted?[clamp$d(h.len+h.pos-r.plotLeft-k,h.pos-r.plotLeft,h.len+h.pos-r.plotLeft),l.len+l.pos-r.plotTop-T-O/2,P]:[l.left-r.plotLeft+T+O/2,clamp$d(k+h.pos-r.plotTop,h.pos-r.plotTop,h.len+h.pos-r.plotTop),P],x.shapeType=t.pointClass.prototype.shapeType||"rect",x.shapeArgs=t.crispCol.apply(t,x.isNull?[T,c,O,0]:[T,M,O,P])})},e.prototype.drawGraph=function(){this.group[this.dense?"addClass":"removeClass"]("highcharts-dense-data")},e.prototype.pointAttribs=function(t,r){var o=this.options,s=this.pointAttrToOptions||{},a=s.stroke||"borderColor",l=s["stroke-width"]||"borderWidth",h,d,c,p=t&&t.color||this.color,f=t&&t[a]||o[a]||p,u=t&&t.options.dashStyle||o.dashStyle,g=t&&t[l]||o[l]||this[l]||0,m=pick$1a(t&&t.opacity,o.opacity,1);t&&this.zones.length&&(d=t.getZone(),p=t.options.color||d&&(d.color||t.nonZonedColor)||this.color,d&&(f=d.borderColor||f,u=d.dashStyle||u,g=d.borderWidth||g)),r&&t&&(h=merge$12(o.states[r],t.options.states&&t.options.states[r]||{}),c=h.brightness,p=h.color||typeof c<"u"&&color$c(p).brighten(h.brightness).get()||p,f=h[a]||f,g=h[l]||g,u=h.dashStyle||u,m=pick$1a(h.opacity,m));var y={fill:p,stroke:f,"stroke-width":g,opacity:m};return u&&(y.dashstyle=u),y},e.prototype.drawPoints=function(){var t=this,r=this.chart,o=t.options,s=r.renderer,a=o.animationLimit||250,l;t.points.forEach(function(h){var d=h.plotY,c=h.graphic,p=!!c,f=c&&r.pointCount<a?"animate":"attr";isNumber$x(d)&&h.y!==null?(l=h.shapeArgs,c&&h.hasNewShapeType()&&(c=c.destroy()),t.enabledDataSorting&&(h.startXPos=t.xAxis.reversed?-(l&&l.width||0):t.xAxis.width),c||(h.graphic=c=s[h.shapeType](l).add(h.group||t.group),c&&t.enabledDataSorting&&r.hasRendered&&r.pointCount<a&&(c.attr({x:h.startXPos}),p=!0,f="animate")),c&&p&&c[f](merge$12(l)),o.borderRadius&&c[f]({r:o.borderRadius}),r.styledMode||c[f](t.pointAttribs(h,h.selected&&"select")).shadow(h.allowShadow!==!1&&o.shadow,null,o.stacking&&!o.borderRadius),c&&(c.addClass(h.getClassName(),!0),c.attr({visibility:h.visible?"inherit":"hidden"}))):c&&(h.graphic=c.destroy())})},e.prototype.drawTracker=function(){var t=this,r=t.chart,o=r.pointer,s=function(l){var h=o.getPointFromEvent(l);typeof h<"u"&&(o.isDirectTouch=!0,h.onMouseOver(l))},a;t.points.forEach(function(l){a=isArray$d(l.dataLabels)?l.dataLabels:l.dataLabel?[l.dataLabel]:[],l.graphic&&(l.graphic.element.point=l),a.forEach(function(h){h.div?h.div.point=l:h.element.point=l})}),t._hasTracking||(t.trackerGroups.forEach(function(l){t[l]&&(t[l].addClass("highcharts-tracker").on("mouseover",s).on("mouseout",function(h){o.onTrackerMouseOut(h)}),hasTouch$1&&t[l].on("touchstart",s),!r.styledMode&&t.options.cursor&&t[l].css(css$4).css({cursor:t.options.cursor}))}),t._hasTracking=!0),fireEvent$p(this,"afterDrawTracker")},e.prototype.remove=function(){var t=this,r=t.chart;r.hasRendered&&r.series.forEach(function(o){o.type===t.type&&(o.isDirty=!0)}),Series$e.prototype.remove.apply(t,arguments)},e.defaultOptions=merge$12(Series$e.defaultOptions,{borderRadius:0,centerInCategory:!1,groupPadding:.2,marker:null,pointPadding:.1,minPointLength:0,cropThreshold:50,pointRange:null,states:{hover:{halo:!1,brightness:.1},select:{color:palette.neutralColor20,borderColor:palette.neutralColor100}},dataLabels:{align:void 0,verticalAlign:void 0,y:void 0},startFromThreshold:!0,stickyTracking:!1,tooltip:{distance:6},threshold:0,borderColor:palette.backgroundColor}),e}(Series$e);extend$19(ColumnSeries$h.prototype,{cropShoulder:0,directTouch:!0,drawLegendSymbol:LegendSymbol$1.drawRectangle,getSymbol:noop$h,negStacks:!0,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("column",ColumnSeries$h);var getDeferredAnimation$1=animationExports.getDeferredAnimation,format$8=FormatUtilities.format,defined$C=Utilities.defined,extend$18=Utilities.extend,fireEvent$o=Utilities.fireEvent,isArray$c=Utilities.isArray,merge$11=Utilities.merge,objectEach$h=Utilities.objectEach,pick$19=Utilities.pick,splat$b=Utilities.splat,DataLabel;(function(n){var e=[];function t(d,c,p,f,u){var g=this,m=this.chart,y=this.isCartesian&&m.inverted,v=this.enabledDataSorting,x=pick$19(d.dlBox&&d.dlBox.centerX,d.plotX,-9999),b=pick$19(d.plotY,-9999),$=c.getBBox(),S=p.rotation,k=p.align,A=m.isInsidePlot(x,Math.round(b),{inverted:y,paneCoordinates:!0,series:g}),M=function(D){v&&g.xAxis&&!I&&g.setDataLabelStartPos(d,c,u,A,D)},P,E,T,O,C,I=pick$19(p.overflow,v?"none":"justify")==="justify",L=this.visible&&d.visible!==!1&&(d.series.forceDL||v&&!I||A||pick$19(p.inside,!!this.options.stacking)&&f&&m.isInsidePlot(x,y?f.x+1:f.y+f.height-1,{inverted:y,paneCoordinates:!0,series:g}));L&&(P=m.renderer.fontMetrics(m.styledMode?void 0:p.style.fontSize,c).b,f=extend$18({x:y?this.yAxis.len-b:x,y:Math.round(y?this.xAxis.len-x:b),width:0,height:0},f),extend$18(p,{width:$.width,height:$.height}),S?(I=!1,O=m.renderer.rotCorr(P,S),C={x:f.x+(p.x||0)+f.width/2+O.x,y:f.y+(p.y||0)+{top:0,middle:.5,bottom:1}[p.verticalAlign]*f.height},M(C),c[u?"attr":"animate"](C).attr({align:k}),E=(S+720)%360,T=E>180&&E<360,k==="left"?C.y-=T?$.height:0:k==="center"?(C.x-=$.width/2,C.y-=$.height/2):k==="right"&&(C.x-=$.width,C.y-=T?0:$.height),c.placed=!0,c.alignAttr=C):(M(f),c.align(p,void 0,f),C=c.alignAttr),I&&f.height>=0?this.justifyDataLabel(c,p,C,$,f,u):pick$19(p.crop,!0)&&(L=m.isInsidePlot(C.x,C.y,{paneCoordinates:!0,series:g})&&m.isInsidePlot(C.x+$.width,C.y+$.height,{paneCoordinates:!0,series:g})),p.shape&&!S&&c[u?"attr":"animate"]({anchorX:y?m.plotWidth-d.plotY:d.plotX,anchorY:y?m.plotHeight-d.plotX:d.plotY})),u&&v&&(c.placed=!1),!L&&(!v||I)&&(c.hide(!0),c.placed=!1)}function r(d,c){var p=c.filter;if(p){var f=p.operator,u=d[p.property],g=p.value;return f===">"&&u>g||f==="<"&&u<g||f===">="&&u>=g||f==="<="&&u<=g||f==="=="&&u==g||f==="==="&&u===g}return!0}function o(d){if(e.indexOf(d)===-1){var c=d.prototype;e.push(d),c.alignDataLabel=t,c.drawDataLabels=s,c.justifyDataLabel=a,c.setDataLabelStartPos=h}}n.compose=o;function s(){var d=this,c=d.chart,p=d.options,f=d.points,u=d.hasRendered||0,g=c.renderer,m=p.dataLabels,y,v,x=m.animation,b=m.defer?getDeferredAnimation$1(c,x,d):{defer:0,duration:0};if(m=l(l(c.options.plotOptions&&c.options.plotOptions.series&&c.options.plotOptions.series.dataLabels,c.options.plotOptions&&c.options.plotOptions[d.type]&&c.options.plotOptions[d.type].dataLabels),m),fireEvent$o(this,"drawDataLabels"),isArray$c(m)||m.enabled||d._hasPointLabels){if(v=d.plotGroup("dataLabelsGroup","data-labels",u?"inherit":"hidden",m.zIndex||6),v.attr({opacity:+u}),!u){var $=d.dataLabelsGroup;$&&(d.visible&&v.show(!0),$[p.animation?"animate":"attr"]({opacity:1},b))}f.forEach(function(S){y=splat$b(l(m,S.dlOptions||S.options&&S.options.dataLabels)),y.forEach(function(k,A){var M=k.enabled&&(!S.isNull||S.dataLabelOnNull)&&r(S,k),P=S.connectors?S.connectors[A]:S.connector,E,T,O,C,I,L,D=S.dataLabels?S.dataLabels[A]:S.dataLabel,N=pick$19(k.distance,S.labelDistance),B=!D;M&&(E=S.getLabelConfig(),T=pick$19(k[S.formatPrefix+"Format"],k.format),O=defined$C(T)?format$8(T,E,c):(k[S.formatPrefix+"Formatter"]||k.formatter).call(E,k),C=k.style,I=k.rotation,c.styledMode||(C.color=pick$19(k.color,C.color,d.color,palette.neutralColor100),C.color==="contrast"?(S.contrastColor=g.getContrast(S.color||d.color),C.color=!defined$C(N)&&k.inside||N<0||p.stacking?S.contrastColor:palette.neutralColor100):delete S.contrastColor,p.cursor&&(C.cursor=p.cursor)),L={r:k.borderRadius||0,rotation:I,padding:k.padding,zIndex:1},c.styledMode||(L.fill=k.backgroundColor,L.stroke=k.borderColor,L["stroke-width"]=k.borderWidth),objectEach$h(L,function(X,W){typeof X>"u"&&delete L[W]})),D&&(!M||!defined$C(O))?(S.dataLabel=S.dataLabel&&S.dataLabel.destroy(),S.dataLabels&&(S.dataLabels.length===1?delete S.dataLabels:delete S.dataLabels[A]),A||delete S.dataLabel,P&&(S.connector=S.connector.destroy(),S.connectors&&(S.connectors.length===1?delete S.connectors:delete S.connectors[A]))):M&&defined$C(O)&&(D?L.text=O:(S.dataLabels=S.dataLabels||[],D=S.dataLabels[A]=I?g.text(O,0,-9999,k.useHTML).addClass("highcharts-data-label"):g.label(O,0,-9999,k.shape,null,null,k.useHTML,null,"data-label"),A||(S.dataLabel=D),D.addClass(" highcharts-data-label-color-"+S.colorIndex+" "+(k.className||"")+(k.useHTML?" highcharts-tracker":""))),D.options=k,D.attr(L),c.styledMode||D.css(C).shadow(k.shadow),D.added||D.add(v),k.textPath&&!k.useHTML&&(D.setTextPath(S.getDataLabelPath&&S.getDataLabelPath(D)||S.graphic,k.textPath),S.dataLabelPath&&!k.textPath.enabled&&(S.dataLabelPath=S.dataLabelPath.destroy())),d.alignDataLabel(S,D,k,null,B))})})}fireEvent$o(this,"afterDrawDataLabels")}function a(d,c,p,f,u,g){var m=this.chart,y=c.align,v=c.verticalAlign,x=d.box?0:d.padding||0,b=c.x,$=b===void 0?0:b,S=c.y,k=S===void 0?0:S,A,M;return A=(p.x||0)+x,A<0&&(y==="right"&&$>=0?(c.align="left",c.inside=!0):$-=A,M=!0),A=(p.x||0)+f.width-x,A>m.plotWidth&&(y==="left"&&$<=0?(c.align="right",c.inside=!0):$+=m.plotWidth-A,M=!0),A=p.y+x,A<0&&(v==="bottom"&&k>=0?(c.verticalAlign="top",c.inside=!0):k-=A,M=!0),A=(p.y||0)+f.height-x,A>m.plotHeight&&(v==="top"&&k<=0?(c.verticalAlign="bottom",c.inside=!0):k+=m.plotHeight-A,M=!0),M&&(c.x=$,c.y=k,d.placed=!g,d.align(c,void 0,u)),M}function l(d,c){var p=[],f;if(isArray$c(d)&&!isArray$c(c))p=d.map(function(u){return merge$11(u,c)});else if(isArray$c(c)&&!isArray$c(d))p=c.map(function(u){return merge$11(d,u)});else if(!isArray$c(d)&&!isArray$c(c))p=merge$11(d,c);else for(f=Math.max(d.length,c.length);f--;)p[f]=merge$11(d[f],c[f]);return p}function h(d,c,p,f,u){var g=this.chart,m=g.inverted,y=this.xAxis,v=y.reversed,x=m?c.height/2:c.width/2,b=d.pointWidth,$=b?b/2:0;c.startXPos=m?u.x:v?-x-$:y.width-x+$,c.startYPos=m?v?this.yAxis.height-x+$:-x-$:u.y,f?c.visibility==="hidden"&&(c.show(),c.attr({opacity:0}).animate({opacity:1})):c.attr({opacity:1}).animate({opacity:0},void 0,c.hide),g.hasRendered&&(p&&c.attr({x:c.startXPos,y:c.startYPos}),c.placed=!0)}})(DataLabel||(DataLabel={}));const DataLabel$1=DataLabel;var Series$d=SeriesRegistry$1.series,merge$10=Utilities.merge,pick$18=Utilities.pick,ColumnDataLabel$1;(function(n){var e=[];function t(o,s,a,l,h){var d=this.chart.inverted,c=o.series,p=o.dlBox||o.shapeArgs,f=pick$18(o.below,o.plotY>pick$18(this.translatedThreshold,c.yAxis.len)),u=pick$18(a.inside,!!this.options.stacking),g;p&&(l=merge$10(p),l.y<0&&(l.height+=l.y,l.y=0),g=l.y+l.height-c.yAxis.len,g>0&&g<l.height&&(l.height-=g),d&&(l={x:c.yAxis.len-l.y-l.height,y:c.xAxis.len-l.x-l.width,width:l.height,height:l.width}),u||(d?(l.x+=f?0:l.width,l.width=0):(l.y+=f?l.height:0,l.height=0))),a.align=pick$18(a.align,!d||u?"center":f?"right":"left"),a.verticalAlign=pick$18(a.verticalAlign,d||u?"middle":f?"top":"bottom"),Series$d.prototype.alignDataLabel.call(this,o,s,a,l,h),a.inside&&o.contrastColor&&s.css({color:o.contrastColor})}function r(o){DataLabel$1.compose(Series$d),e.indexOf(o)===-1&&(e.push(o),o.prototype.alignDataLabel=t)}n.compose=r})(ColumnDataLabel$1||(ColumnDataLabel$1={}));const ColumnDataLabel$2=ColumnDataLabel$1;var __extends$P=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),extend$17=Utilities.extend,merge$$=Utilities.merge,BarSeries=function(n){__extends$P(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.defaultOptions=merge$$(ColumnSeries$h.defaultOptions,{}),e}(ColumnSeries$h);extend$17(BarSeries.prototype,{inverted:!0});SeriesRegistry$1.registerSeriesType("bar",BarSeries);var __extends$O=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),addEvent$P=Utilities.addEvent,extend$16=Utilities.extend,merge$_=Utilities.merge,ScatterSeries$4=function(n){__extends$O(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.applyJitter=function(){var t=this,r=this.options.jitter,o=this.points.length;function s(a){var l=Math.sin(a)*1e4;return l-Math.floor(l)}r&&this.points.forEach(function(a,l){["x","y"].forEach(function(h,d){var c,p="plot"+h.toUpperCase(),f,u,g;r[h]&&!a.isNull&&(c=t[h+"Axis"],g=r[h]*c.transA,c&&!c.isLog&&(f=Math.max(0,a[p]-g),u=Math.min(c.len,a[p]+g),a[p]=f+(u-f)*s(l+d*o),h==="x"&&(a.clientX=a.plotX)))})})},e.prototype.drawGraph=function(){this.options.lineWidth?n.prototype.drawGraph.call(this):this.graph&&(this.graph=this.graph.destroy())},e.defaultOptions=merge$_(LineSeries$5.defaultOptions,{lineWidth:0,findNearestPointBy:"xy",jitter:{x:0,y:0},marker:{enabled:!0},tooltip:{headerFormat:'<span style="color:{point.color}">●</span> <span style="font-size: 10px"> {series.name}</span><br/>',pointFormat:"x: <b>{point.x}</b><br/>y: <b>{point.y}</b><br/>"}}),e}(LineSeries$5);extend$16(ScatterSeries$4.prototype,{drawTracker:ColumnSeries$h.prototype.drawTracker,sorted:!1,requireSorting:!1,noSharedTooltip:!0,trackerGroups:["group","markerGroup","dataLabelsGroup"],takeOrdinalPosition:!1});addEvent$P(ScatterSeries$4,"afterTranslate",function(){this.applyJitter()});SeriesRegistry$1.registerSeriesType("scatter",ScatterSeries$4);var isNumber$w=Utilities.isNumber,pick$17=Utilities.pick,relativeLength$6=Utilities.relativeLength,deg2rad$4=H.deg2rad,centeredSeriesMixin=H.CenteredSeriesMixin={getCenter:function(){var n=this.options,e=this.chart,t=2*(n.slicedOffset||0),r,o=e.plotWidth-2*t,s=e.plotHeight-2*t,a=n.center,l=Math.min(o,s),h=n.size,d=n.innerSize||0,c,p,f;for(typeof h=="string"&&(h=parseFloat(h)),typeof d=="string"&&(d=parseFloat(d)),c=[pick$17(a[0],"50%"),pick$17(a[1],"50%"),pick$17(h&&h<0?void 0:n.size,"100%"),pick$17(d&&d<0?void 0:n.innerSize||0,"0%")],e.angular&&!(this instanceof Series$e)&&(c[3]=0),p=0;p<4;++p)f=c[p],r=p<2||p===2&&/%$/.test(f),c[p]=relativeLength$6(f,[o,s,l,c[2]][p])+(r?t:0);return c[3]>c[2]&&(c[3]=c[2]),c},getStartAndEndRadians:function(n,e){var t=isNumber$w(n)?n:0,r=isNumber$w(e)&&e>t&&e-t<360?e:t+360,o=-90;return{start:deg2rad$4*(t+o),end:deg2rad$4*(r+o)}}},__extends$N=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),setAnimation$1=animationExports.setAnimation,addEvent$O=Utilities.addEvent,defined$B=Utilities.defined,extend$15=Utilities.extend,isNumber$v=Utilities.isNumber,pick$16=Utilities.pick,relativeLength$5=Utilities.relativeLength,PiePoint$3=function(n){__extends$N(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.labelDistance=void 0,t.options=void 0,t.series=void 0,t}return e.prototype.getConnectorPath=function(){var t=this.labelPosition,r=this.series.options.dataLabels,o=this.connectorShapes,s=r.connectorShape;return o[s]&&(s=o[s]),s.call(this,{x:t.final.x,y:t.final.y,alignment:t.alignment},t.connectorPosition,r)},e.prototype.getTranslate=function(){return this.sliced?this.slicedTranslation:{translateX:0,translateY:0}},e.prototype.haloPath=function(t){var r=this.shapeArgs;return this.sliced||!this.visible?[]:this.series.chart.renderer.symbols.arc(r.x,r.y,r.r+t,r.r+t,{innerR:r.r-1,start:r.start,end:r.end})},e.prototype.init=function(){var t=this;n.prototype.init.apply(this,arguments),this.name=pick$16(this.name,"Slice");var r=function(o){t.slice(o.type==="select")};return addEvent$O(this,"select",r),addEvent$O(this,"unselect",r),this},e.prototype.isValid=function(){return isNumber$v(this.y)&&this.y>=0},e.prototype.setVisible=function(t,r){var o=this,s=this.series,a=s.chart,l=s.options.ignoreHiddenPoint;r=pick$16(r,l),t!==this.visible&&(this.visible=this.options.visible=t=typeof t>"u"?!this.visible:t,s.options.data[s.data.indexOf(this)]=this.options,["graphic","dataLabel","connector","shadowGroup"].forEach(function(h){o[h]&&o[h][t?"show":"hide"](t)}),this.legendItem&&a.legend.colorizeItem(this,t),!t&&this.state==="hover"&&this.setState(""),l&&(s.isDirty=!0),r&&a.redraw())},e.prototype.slice=function(t,r,o){var s=this.series,a=s.chart;setAnimation$1(o,a),r=pick$16(r,!0),this.sliced=this.options.sliced=t=defined$B(t)?t:!this.sliced,s.options.data[s.data.indexOf(this)]=this.options,this.graphic&&this.graphic.animate(this.getTranslate()),this.shadowGroup&&this.shadowGroup.animate(this.getTranslate())},e}(Point$2);extend$15(PiePoint$3.prototype,{connectorShapes:{fixedOffset:function(n,e,t){var r=e.breakAt,o=e.touchingSliceAt,s=t.softConnector?["C",n.x+(n.alignment==="left"?-5:5),n.y,2*r.x-o.x,2*r.y-o.y,r.x,r.y]:["L",r.x,r.y];return[["M",n.x,n.y],s,["L",o.x,o.y]]},straight:function(n,e){var t=e.touchingSliceAt;return[["M",n.x,n.y],["L",t.x,t.y]]},crookedLine:function(n,e,t){var r=e.touchingSliceAt,o=this.series,s=o.center[0],a=o.chart.plotWidth,l=o.chart.plotLeft,h=n.alignment,d=this.shapeArgs.r,c=relativeLength$5(t.crookDistance,1),p=h==="left"?s+d+(a+l-s-d)*(1-c):l+(s-d)*c,f=["L",p,n.y],u=!0;(h==="left"?p>n.x||p<r.x:p<n.x||p>r.x)&&(u=!1);var g=[["M",n.x,n.y]];return u&&g.push(f),g.push(["L",r.x,r.y]),g}}});var __extends$M=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),getStartAndEndRadians=centeredSeriesMixin.getStartAndEndRadians,noop$g=H.noop,clamp$c=Utilities.clamp,extend$14=Utilities.extend,fireEvent$n=Utilities.fireEvent,merge$Z=Utilities.merge,pick$15=Utilities.pick,relativeLength$4=Utilities.relativeLength,PieSeries$3=function(n){__extends$M(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.center=void 0,t.data=void 0,t.maxLabelDistance=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.animate=function(t){var r=this,o=r.points,s=r.startAngleRad;t||o.forEach(function(a){var l=a.graphic,h=a.shapeArgs;l&&h&&(l.attr({r:pick$15(a.startR,r.center&&r.center[3]/2),start:s,end:s}),l.animate({r:h.r,start:h.start,end:h.end},r.options.animation))})},e.prototype.drawEmpty=function(){var t=this.startAngleRad,r=this.endAngleRad,o=this.options,s,a;this.total===0&&this.center?(s=this.center[0],a=this.center[1],this.graph||(this.graph=this.chart.renderer.arc(s,a,this.center[1]/2,0,t,r).addClass("highcharts-empty-series").add(this.group)),this.graph.attr({d:Symbols.arc(s,a,this.center[2]/2,0,{start:t,end:r,innerR:this.center[3]/2})}),this.chart.styledMode||this.graph.attr({"stroke-width":o.borderWidth,fill:o.fillColor||"none",stroke:o.color||palette.neutralColor20})):this.graph&&(this.graph=this.graph.destroy())},e.prototype.drawPoints=function(){var t=this.chart.renderer;this.points.forEach(function(r){r.graphic&&r.hasNewShapeType()&&(r.graphic=r.graphic.destroy()),r.graphic||(r.graphic=t[r.shapeType](r.shapeArgs).add(r.series.group),r.delayedRendering=!0)})},e.prototype.generatePoints=function(){n.prototype.generatePoints.call(this),this.updateTotals()},e.prototype.getX=function(t,r,o){var s=this.center,a=this.radii?this.radii[o.index]||0:s[2]/2,l=Math.asin(clamp$c((t-s[1])/(a+o.labelDistance),-1,1)),h=s[0]+(r?-1:1)*(Math.cos(l)*(a+o.labelDistance))+(o.labelDistance>0?(r?-1:1)*this.options.dataLabels.padding:0);return h},e.prototype.hasData=function(){return!!this.processedXData.length},e.prototype.redrawPoints=function(){var t=this,r=t.chart,o=r.renderer,s=t.options.shadow,a,l,h,d;this.drawEmpty(),s&&!t.shadowGroup&&!r.styledMode&&(t.shadowGroup=o.g("shadow").attr({zIndex:-1}).add(t.group)),t.points.forEach(function(c){var p={};if(l=c.graphic,!c.isNull&&l){var f=void 0;d=c.shapeArgs,a=c.getTranslate(),r.styledMode||(f=c.shadowGroup,s&&!f&&(f=c.shadowGroup=o.g("shadow").add(t.shadowGroup)),f&&f.attr(a),h=t.pointAttribs(c,c.selected&&"select")),c.delayedRendering?(l.setRadialReference(t.center).attr(d).attr(a),r.styledMode||l.attr(h).attr({"stroke-linejoin":"round"}).shadow(s,f),c.delayedRendering=!1):(l.setRadialReference(t.center),r.styledMode||merge$Z(!0,p,h),merge$Z(!0,p,d,a),l.animate(p)),l.attr({visibility:c.visible?"inherit":"hidden"}),l.addClass(c.getClassName(),!0)}else l&&(c.graphic=l.destroy())})},e.prototype.sortByAngle=function(t,r){t.sort(function(o,s){return typeof o.angle<"u"&&(s.angle-o.angle)*r})},e.prototype.translate=function(t){this.generatePoints();var r=this,o=1e3,s=r.options,a=s.slicedOffset,l=a+(s.borderWidth||0),h=getStartAndEndRadians(s.startAngle,s.endAngle),d=r.startAngleRad=h.start,c=r.endAngleRad=h.end,p=c-d,f=r.points,u=s.dataLabels.distance,g=s.ignoreHiddenPoint,m=f.length,y,v,x,b,$,S,k,A,M=0;for(t||(r.center=t=r.getCenter()),k=0;k<m;k++){A=f[k],v=d+M*p,A.isValid()&&(!g||A.visible)&&(M+=A.percentage/100),x=d+M*p;var P={x:t[0],y:t[1],r:t[2]/2,innerR:t[3]/2,start:Math.round(v*o)/o,end:Math.round(x*o)/o};A.shapeType="arc",A.shapeArgs=P,A.labelDistance=pick$15(A.options.dataLabels&&A.options.dataLabels.distance,u),A.labelDistance=relativeLength$4(A.labelDistance,P.r),r.maxLabelDistance=Math.max(r.maxLabelDistance||0,A.labelDistance),b=(x+v)/2,b>1.5*Math.PI?b-=2*Math.PI:b<-Math.PI/2&&(b+=2*Math.PI),A.slicedTranslation={translateX:Math.round(Math.cos(b)*a),translateY:Math.round(Math.sin(b)*a)},$=Math.cos(b)*t[2]/2,S=Math.sin(b)*t[2]/2,A.tooltipPos=[t[0]+$*.7,t[1]+S*.7],A.half=b<-Math.PI/2||b>Math.PI/2?1:0,A.angle=b,y=Math.min(l,A.labelDistance/5),A.labelPosition={natural:{x:t[0]+$+Math.cos(b)*A.labelDistance,y:t[1]+S+Math.sin(b)*A.labelDistance},final:{},alignment:A.labelDistance<0?"center":A.half?"right":"left",connectorPosition:{breakAt:{x:t[0]+$+Math.cos(b)*y,y:t[1]+S+Math.sin(b)*y},touchingSliceAt:{x:t[0]+$,y:t[1]+S}}}}fireEvent$n(r,"afterTranslate")},e.prototype.updateTotals=function(){var t=this.points,r=t.length,o=this.options.ignoreHiddenPoint,s,a,l=0;for(s=0;s<r;s++)a=t[s],a.isValid()&&(!o||a.visible)&&(l+=a.y);for(this.total=l,s=0;s<r;s++)a=t[s],a.percentage=l>0&&(a.visible||!o)?a.y/l*100:0,a.total=l},e.defaultOptions=merge$Z(Series$e.defaultOptions,{center:[null,null],clip:!1,colorByPoint:!0,dataLabels:{allowOverlap:!0,connectorPadding:5,connectorShape:"fixedOffset",crookDistance:"70%",distance:30,enabled:!0,formatter:function(){return this.point.isNull?void 0:this.point.name},softConnector:!0,x:0},fillColor:void 0,ignoreHiddenPoint:!0,inactiveOtherPoints:!0,legendType:"point",marker:null,size:null,showInLegend:!1,slicedOffset:10,stickyTracking:!1,tooltip:{followPointer:!0},borderColor:palette.backgroundColor,borderWidth:1,lineWidth:void 0,states:{hover:{brightness:.1}}}),e}(Series$e);extend$14(PieSeries$3.prototype,{axisTypes:[],directTouch:!0,drawGraph:void 0,drawLegendSymbol:LegendSymbol$1.drawRectangle,drawTracker:ColumnSeries$h.prototype.drawTracker,getCenter:centeredSeriesMixin.getCenter,getSymbol:noop$g,isCartesian:!1,noSharedTooltip:!0,pointAttribs:ColumnSeries$h.prototype.pointAttribs,pointClass:PiePoint$3,requireSorting:!1,searchPoint:noop$g,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("pie",PieSeries$3);var noop$f=H.noop,distribute$1=R.distribute,Series$c=SeriesRegistry$1.series,arrayMax$6=Utilities.arrayMax,clamp$b=Utilities.clamp,defined$A=Utilities.defined,merge$Y=Utilities.merge,pick$14=Utilities.pick,relativeLength$3=Utilities.relativeLength,ColumnDataLabel;(function(n){var e=[],t={radialDistributionY:function(l){return l.top+l.distributeBox.pos},radialDistributionX:function(l,h,d,c){return l.getX(d<h.top+2||d>h.bottom-2?c:d,h.half,h)},justify:function(l,h,d){return d[0]+(l.half?-1:1)*(h+l.labelDistance)},alignToPlotEdges:function(l,h,d,c){var p=l.getBBox().width;return h?p+c:d-p-c},alignToConnectors:function(l,h,d,c){var p=0,f;return l.forEach(function(u){f=u.dataLabel.getBBox().width,f>p&&(p=f)}),h?p+c:d-p-c}};function r(l){if(DataLabel$1.compose(Series$c),e.indexOf(l)===-1){e.push(l);var h=l.prototype;h.dataLabelPositioners=t,h.alignDataLabel=noop$f,h.drawDataLabels=o,h.placeDataLabels=s,h.verifyDataLabelOverflow=a}}n.compose=r;function o(){var l=this,h=l.data,d=l.chart,c=l.options.dataLabels||{},p=c.connectorPadding,f=d.plotWidth,u=d.plotHeight,g=d.plotLeft,m=Math.round(d.chartWidth/3),y=l.center,v=y[2]/2,x=y[1],b=[[],[]],$=[0,0,0,0],S=l.dataLabelPositioners,k,A,M,P,E,T,O,C,I,L,D,N;!l.visible||!c.enabled&&!l._hasPointLabels||(h.forEach(function(B){B.dataLabel&&B.visible&&B.dataLabel.shortened&&(B.dataLabel.attr({width:"auto"}).css({width:"auto",textOverflow:"clip"}),B.dataLabel.shortened=!1)}),Series$c.prototype.drawDataLabels.apply(l),h.forEach(function(B){B.dataLabel&&(B.visible?(b[B.half].push(B),B.dataLabel._pos=null,!defined$A(c.style.width)&&!defined$A(B.options.dataLabels&&B.options.dataLabels.style&&B.options.dataLabels.style.width)&&B.dataLabel.getBBox().width>m&&(B.dataLabel.css({width:Math.round(m*.7)+"px"}),B.dataLabel.shortened=!0)):(B.dataLabel=B.dataLabel.destroy(),B.dataLabels&&B.dataLabels.length===1&&delete B.dataLabels))}),b.forEach(function(B,X){var W=B.length,F=[],U,z,V,j,K,nt;if(W)for(l.sortByAngle(B,X-.5),l.maxLabelDistance>0&&(U=Math.max(0,x-v-l.maxLabelDistance),z=Math.min(x+v+l.maxLabelDistance,d.plotHeight),B.forEach(function(q){q.labelDistance>0&&q.dataLabel&&(q.top=Math.max(0,x-v-q.labelDistance),q.bottom=Math.min(x+v+q.labelDistance,d.plotHeight),K=q.dataLabel.getBBox().height||21,q.distributeBox={target:q.labelPosition.natural.y-q.top+K/2,size:K,rank:q.y},F.push(q.distributeBox))}),nt=z+K-U,distribute$1(F,nt,nt/5)),D=0;D<W;D++){if(k=B[D],T=k.labelPosition,P=k.dataLabel,L=k.visible===!1?"hidden":"inherit",V=T.natural.y,I=V,defined$A(k.distributeBox)&&(typeof k.distributeBox.pos>"u"?L="hidden":(O=k.distributeBox.size,I=S.radialDistributionY(k))),delete k.positionIndex,c.justify)C=S.justify(k,v,y);else switch(c.alignTo){case"connectors":C=S.alignToConnectors(B,X,f,g);break;case"plotEdges":C=S.alignToPlotEdges(P,X,f,g);break;default:C=S.radialDistributionX(l,k,I,V)}P._attr={visibility:L,align:T.alignment},N=k.options.dataLabels||{},P._pos={x:C+pick$14(N.x,c.x)+({left:p,right:-p}[T.alignment]||0),y:I+pick$14(N.y,c.y)-10},T.final.x=C,T.final.y=I,pick$14(c.crop,!0)&&(E=P.getBBox().width,j=null,C-E<p&&X===1?(j=Math.round(E-C+p),$[3]=Math.max(j,$[3])):C+E>f-p&&X===0&&(j=Math.round(C+E-f+p),$[1]=Math.max(j,$[1])),I-O/2<0?$[0]=Math.max(Math.round(-I+O/2),$[0]):I+O/2>u&&($[2]=Math.max(Math.round(I+O/2-u),$[2])),P.sideOverflow=j)}}),(arrayMax$6($)===0||this.verifyDataLabelOverflow($))&&(this.placeDataLabels(),this.points.forEach(function(B){if(N=merge$Y(c,B.options.dataLabels),A=pick$14(N.connectorWidth,1),A){var X=void 0;M=B.connector,P=B.dataLabel,P&&P._pos&&B.visible&&B.labelDistance>0?(L=P._attr.visibility,X=!M,X&&(B.connector=M=d.renderer.path().addClass("highcharts-data-label-connector  highcharts-color-"+B.colorIndex+(B.className?" "+B.className:"")).add(l.dataLabelsGroup),d.styledMode||M.attr({"stroke-width":A,stroke:N.connectorColor||B.color||palette.neutralColor60})),M[X?"attr":"animate"]({d:B.getConnectorPath()}),M.attr("visibility",L)):M&&(B.connector=M.destroy())}})))}function s(){this.points.forEach(function(l){var h=l.dataLabel,d;h&&l.visible&&(d=h._pos,d?(h.sideOverflow&&(h._attr.width=Math.max(h.getBBox().width-h.sideOverflow,0),h.css({width:h._attr.width+"px",textOverflow:(this.options.dataLabels.style||{}).textOverflow||"ellipsis"}),h.shortened=!0),h.attr(h._attr),h[h.moved?"animate":"attr"](d),h.moved=!0):h&&h.attr({y:-9999})),delete l.distributeBox},this)}function a(l){var h=this.center,d=this.options,c=d.center,p=d.minSize||80,f=p,u=d.size!==null;return u||(c[0]!==null?f=Math.max(h[2]-Math.max(l[1],l[3]),p):(f=Math.max(h[2]-l[1]-l[3],p),h[0]+=(l[3]-l[1])/2),c[1]!==null?f=clamp$b(f,p,h[2]-Math.max(l[0],l[2])):(f=clamp$b(f,p,h[2]-l[0]-l[2]),h[1]+=(l[0]-l[2])/2),f<h[2]?(h[2]=f,h[3]=Math.min(relativeLength$3(d.innerSize||0,f),f),this.translate(h),this.drawDataLabels&&this.drawDataLabels()):u=!0),u}})(ColumnDataLabel||(ColumnDataLabel={}));const PieDataLabel=ColumnDataLabel;var addEvent$N=Utilities.addEvent,fireEvent$m=Utilities.fireEvent,isArray$b=Utilities.isArray,isNumber$u=Utilities.isNumber,objectEach$g=Utilities.objectEach,pick$13=Utilities.pick;addEvent$N(Chart$1,"render",function(){var e=this,t=[];(this.labelCollectors||[]).forEach(function(r){t=t.concat(r())}),(this.yAxis||[]).forEach(function(r){r.stacking&&r.options.stackLabels&&!r.options.stackLabels.allowOverlap&&objectEach$g(r.stacking.stacks,function(o){objectEach$g(o,function(s){s.label&&s.label.visibility!=="hidden"&&t.push(s.label)})})}),(this.series||[]).forEach(function(r){var o=r.options.dataLabels;if(r.visible&&!(o.enabled===!1&&!r._hasPointLabels)){var s=function(a){return a.forEach(function(l){if(l.visible){var h=isArray$b(l.dataLabels)?l.dataLabels:l.dataLabel?[l.dataLabel]:[];h.forEach(function(d){var c=d.options;d.labelrank=pick$13(c.labelrank,l.labelrank,l.shapeArgs&&l.shapeArgs.height),c.allowOverlap?(d.oldOpacity=d.opacity,d.newOpacity=1,hideOrShow(d,e)):t.push(d)})}})};s(r.nodes||[]),s(r.points)}}),this.hideOverlappingLabels(t)});Chart$1.prototype.hideOverlappingLabels=function(n){var e=this,t=n.length,r=e.renderer,o,s,a,l,h,d,c,p=!1,f=function(g,m){return!(m.x>=g.x+g.width||m.x+m.width<=g.x||m.y>=g.y+g.height||m.y+m.height<=g.y)},u=function(g){var m,y,v,x=g.box?0:g.padding||0,b=0,$=0,S,k;if(g&&(!g.alignAttr||g.placed))return m=g.alignAttr||{x:g.attr("x"),y:g.attr("y")},y=g.parentGroup,g.width||(v=g.getBBox(),g.width=v.width,g.height=v.height,b=r.fontMetrics(null,g.element).h),S=g.width-2*x,k={left:"0",center:"0.5",right:"1"}[g.alignValue],k?$=+k*S:isNumber$u(g.x)&&Math.round(g.x)!==g.translateX&&($=g.x-g.translateX),{x:m.x+(y.translateX||0)+x-($||0),y:m.y+(y.translateY||0)+x-b,width:g.width-2*x,height:g.height-2*x}};for(s=0;s<t;s++)o=n[s],o&&(o.oldOpacity=o.opacity,o.newOpacity=1,o.absoluteBox=u(o));for(n.sort(function(g,m){return(m.labelrank||0)-(g.labelrank||0)}),s=0;s<t;s++)for(l=n[s],d=l&&l.absoluteBox,a=s+1;a<t;++a)h=n[a],c=h&&h.absoluteBox,d&&c&&l!==h&&l.newOpacity!==0&&h.newOpacity!==0&&f(d,c)&&((l.labelrank<h.labelrank?l:h).newOpacity=0);n.forEach(function(g){hideOrShow(g,e)&&(p=!0)}),p&&fireEvent$m(e,"afterHideAllOverlappingLabels")};function hideOrShow(n,e){var t,r,o=!1;return n&&(r=n.newOpacity,n.oldOpacity!==r&&(n.alignAttr&&n.placed?(n[r?"removeClass":"addClass"]("highcharts-data-label-hidden"),t=function(){e.styledMode||n.css({pointerEvents:r?"auto":"none"})},o=!0,n.alignAttr.opacity=r,n[n.isOld?"animate":"attr"](n.alignAttr,null,t),fireEvent$m(e,"afterHideOverlappingLabel")):n.attr({opacity:r})),n.isOld=!0),o}var extend$13=Utilities.extend,find$e=Utilities.find,isArray$a=Utilities.isArray,isObject$8=Utilities.isObject,merge$X=Utilities.merge,objectEach$f=Utilities.objectEach,pick$12=Utilities.pick,splat$a=Utilities.splat,uniqueKey$3=Utilities.uniqueKey,Responsive;(function(n){var e=[];function t(o){return e.indexOf(o)===-1&&(e.push(o),extend$13(o.prototype,r.prototype)),o}n.compose=t;var r=function(){function o(){}return o.prototype.currentOptions=function(s){var a=this,l={};function h(d,c,p,f){var u;objectEach$f(d,function(g,m){if(!f&&a.collectionsWithUpdate.indexOf(m)>-1&&c[m])for(g=splat$a(g),p[m]=[],u=0;u<Math.max(g.length,c[m].length);u++)c[m][u]&&(g[u]===void 0?p[m][u]=c[m][u]:(p[m][u]={},h(g[u],c[m][u],p[m][u],f+1)));else isObject$8(g)?(p[m]=isArray$a(g)?[]:{},h(g,c[m]||{},p[m],f+1)):typeof c[m]>"u"?p[m]=null:p[m]=c[m]})}return h(s,this.options,l,0),l},o.prototype.matchResponsiveRule=function(s,a){var l=s.condition,h=l.callback||function(){return this.chartWidth<=pick$12(l.maxWidth,Number.MAX_VALUE)&&this.chartHeight<=pick$12(l.maxHeight,Number.MAX_VALUE)&&this.chartWidth>=pick$12(l.minWidth,0)&&this.chartHeight>=pick$12(l.minHeight,0)};h.call(this)&&a.push(s._id)},o.prototype.setResponsive=function(s,a){var l=this,h=this.options.responsive,d=this.currentResponsive,c=[],p;!a&&h&&h.rules&&h.rules.forEach(function(g){typeof g._id>"u"&&(g._id=uniqueKey$3()),l.matchResponsiveRule(g,c)},this);var f=merge$X.apply(void 0,c.map(function(g){return find$e((h||{}).rules||[],function(m){return m._id===g})}).map(function(g){return g&&g.chartOptions}));f.isResponsiveOptions=!0,c=c.toString()||void 0;var u=d&&d.ruleIds;c!==u&&(d&&this.update(d.undoOptions,s,!0),c?(p=this.currentOptions(f),p.isResponsiveOptions=!0,this.currentResponsive={ruleIds:c,mergedOptions:f,undoOptions:p},this.update(f,s,!0)):this.currentResponsive=void 0)},o}()})(Responsive||(Responsive={}));const Responsive$1=Responsive;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$7=H;G$7.animate=animationExports.animate;G$7.animObject=animationExports.animObject;G$7.getDeferredAnimation=animationExports.getDeferredAnimation;G$7.setAnimation=animationExports.setAnimation;G$7.stop=animationExports.stop;G$7.timers=Fx.timers;G$7.AST=AST;G$7.Axis=Axis;G$7.Chart=Chart$1;G$7.chart=Chart$1.chart;G$7.Fx=Fx;G$7.Legend=Legend;G$7.PlotLineOrBand=PlotLineOrBand;G$7.Point=Point$2;G$7.Pointer=MSPointer.isRequired()?MSPointer:Pointer;G$7.Series=Series$e;G$7.SVGElement=SVGElement;G$7.SVGRenderer=SVGRenderer;G$7.Tick=Tick;G$7.Time=Time;G$7.Tooltip=Tooltip;G$7.Color=Color;G$7.color=Color.parse;HTMLRenderer.compose(SVGRenderer);HTMLElement.compose(SVGElement);G$7.defaultOptions=DefaultOptions.defaultOptions;G$7.getOptions=DefaultOptions.getOptions;G$7.time=DefaultOptions.defaultTime;G$7.setOptions=DefaultOptions.setOptions;G$7.dateFormat=FormatUtilities.dateFormat;G$7.format=FormatUtilities.format;G$7.numberFormat=FormatUtilities.numberFormat;G$7.addEvent=Utilities.addEvent;G$7.arrayMax=Utilities.arrayMax;G$7.arrayMin=Utilities.arrayMin;G$7.attr=Utilities.attr;G$7.clearTimeout=Utilities.clearTimeout;G$7.correctFloat=Utilities.correctFloat;G$7.createElement=Utilities.createElement;G$7.css=Utilities.css;G$7.defined=Utilities.defined;G$7.destroyObjectProperties=Utilities.destroyObjectProperties;G$7.discardElement=Utilities.discardElement;G$7.distribute=R.distribute;G$7.erase=Utilities.erase;G$7.error=Utilities.error;G$7.extend=Utilities.extend;G$7.extendClass=Utilities.extendClass;G$7.find=Utilities.find;G$7.fireEvent=Utilities.fireEvent;G$7.getMagnitude=Utilities.getMagnitude;G$7.getStyle=Utilities.getStyle;G$7.inArray=Utilities.inArray;G$7.isArray=Utilities.isArray;G$7.isClass=Utilities.isClass;G$7.isDOMElement=Utilities.isDOMElement;G$7.isFunction=Utilities.isFunction;G$7.isNumber=Utilities.isNumber;G$7.isObject=Utilities.isObject;G$7.isString=Utilities.isString;G$7.keys=Utilities.keys;G$7.merge=Utilities.merge;G$7.normalizeTickInterval=Utilities.normalizeTickInterval;G$7.objectEach=Utilities.objectEach;G$7.offset=Utilities.offset;G$7.pad=Utilities.pad;G$7.pick=Utilities.pick;G$7.pInt=Utilities.pInt;G$7.relativeLength=Utilities.relativeLength;G$7.removeEvent=Utilities.removeEvent;G$7.seriesType=SeriesRegistry$1.seriesType;G$7.splat=Utilities.splat;G$7.stableSort=Utilities.stableSort;G$7.syncTimeout=Utilities.syncTimeout;G$7.timeUnits=Utilities.timeUnits;G$7.uniqueKey=Utilities.uniqueKey;G$7.useSerialIds=Utilities.useSerialIds;G$7.wrap=Utilities.wrap;ColumnDataLabel$2.compose(ColumnSeries$h);DataLabel$1.compose(Series$e);DateTimeAxis$1.compose(Axis);LogarithmicAxis$1.compose(Axis);PieDataLabel.compose(PieSeries$3);PlotLineOrBand.compose(Axis);Responsive$1.compose(Chart$1);var addEvent$M=Utilities.addEvent,correctFloat$8=Utilities.correctFloat,css$3=Utilities.css,defined$z=Utilities.defined,error$3=Utilities.error,pick$11=Utilities.pick,timeUnits=Utilities.timeUnits,composedClasses=[],OrdinalAxis;(function(n){function e(g,m,y){if(composedClasses.indexOf(g)===-1){composedClasses.push(g);var v=g.prototype;v.getTimeTicks=t,v.index2val=r,v.lin2val=o,v.val2lin=f,v.ordinal2lin=v.val2lin,addEvent$M(g,"afterInit",a),addEvent$M(g,"foundExtremes",l),addEvent$M(g,"afterSetScale",h),addEvent$M(g,"initialAxisTranslation",d)}return composedClasses.indexOf(y)===-1&&(composedClasses.push(y),addEvent$M(y,"pan",c)),composedClasses.indexOf(m)===-1&&(composedClasses.push(m),addEvent$M(m,"updatedData",p)),g}n.compose=e;function t(g,m,y,v,x,b,$){x===void 0&&(x=[]),b===void 0&&(b=0);var S={},k=this.options.tickPixelInterval,A=this.chart.time,M=[],P,E,T,O,C,I=0,L=[],D=-Number.MAX_VALUE;if(!this.options.ordinal&&!this.options.breaks||!x||x.length<3||typeof m>"u")return A.getTimeTicks.apply(A,arguments);var N=x.length;for(P=0;P<N;P++){if(C=P&&x[P-1]>y,x[P]<m&&(I=P),P===N-1||x[P+1]-x[P]>b*5||C){if(x[P]>D){for(E=A.getTimeTicks(g,x[I],x[P],v);E.length&&E[0]<=D;)E.shift();E.length&&(D=E[E.length-1]),M.push(L.length),L=L.concat(E)}I=P+1}if(C)break}if(E){if(O=E.info,$&&O.unitRange<=timeUnits.hour){for(P=L.length-1,I=1;I<P;I++)A.dateFormat("%d",L[I])!==A.dateFormat("%d",L[I-1])&&(S[L[I]]="day",T=!0);T&&(S[L[0]]="day"),O.higherRanks=S}O.segmentStarts=M,L.info=O}else error$3(12,!1,this.chart);if($&&defined$z(k)){for(var B=L.length,X=[],W=[],F=void 0,U=void 0,z=void 0,V=void 0,j=void 0,K=B;K--;)U=this.translate(L[K]),z&&(W[K]=z-U),X[K]=z=U;for(W.sort(),V=W[Math.floor(W.length/2)],V<k*.6&&(V=null),K=L[B-1]>y?B-1:B,z=void 0;K--;)U=X[K],j=Math.abs(z-U),z&&j<k*.8&&(V===null||j<V*.8)?(S[L[K]]&&!S[L[K+1]]?(F=K+1,z=U):F=K,L.splice(F,1)):z=U}return L}function r(g){var m=this,y=m.ordinal,v=y.positions;if(!v)return g;var x=v.length-1,b;return g<0?g=v[0]:g>x?g=v[x]:(x=Math.floor(g),b=g-x),typeof b<"u"&&typeof v[x]<"u"?v[x]+(b?b*(v[x+1]-v[x]):0):g}function o(g){var m=this,y=m.ordinal,v=m.old?m.old.min:m.min,x=m.old?m.old.transA:m.transA,b=y.positions;if(!b)return g;var $=(g-v)*x+m.minPixelPadding,S=$>0&&$<m.left+m.len;if(S||(y.extendedOrdinalPositions||(y.extendedOrdinalPositions=y.getExtendedPositions()),b=y.extendedOrdinalPositions),b&&b.length){var k=y.getIndexOfPoint($,b),A=correctFloat$8(k%1);if(k>=0&&k<b.length){var M=b[Math.floor(k)],P=b[Math.ceil(k)],E=P-M;return b[Math.floor(k)]+A*E}var T=b.length,O=b[0],C=b[T-1],I=(C-O)/(T-1);return k<0?O+I*k:C+I*(k-T)}return g}function s(g,m){var y=n.Additions.findIndexOf(g,m,!0);if(g[y]===m)return y;var v=(m-g[y])/(g[y+1]-g[y]);return y+v}function a(){var g=this;g.ordinal||(g.ordinal=new n.Additions(g))}function l(){var g=this;g.isXAxis&&defined$z(g.options.overscroll)&&g.max===g.dataMax&&(!g.chart.mouseIsDown||g.isInternal)&&(!g.eventArgs||g.eventArgs&&g.eventArgs.trigger!=="navigator")&&(g.max+=g.options.overscroll,!g.isInternal&&defined$z(g.userMin)&&(g.min+=g.options.overscroll))}function h(){var g=this;g.horiz&&!g.isDirty&&(g.isDirty=g.isOrdinal&&g.chart.navigator&&!g.chart.navigator.adaptToUpdatedData)}function d(){var g=this;g.ordinal&&(g.ordinal.beforeSetTickPositions(),g.tickInterval=g.ordinal.postProcessTickInterval(g.tickInterval))}function c(g){var m=this,y=m.xAxis[0],v=y.options.overscroll,x=g.originalEvent.chartX,b=m.options.chart.panning,$=!1;if(b&&b.type!=="y"&&y.options.ordinal&&y.series.length){var S=m.mouseDownX,k=y.getExtremes(),A=k.dataMax,M=k.min,P=k.max,E=m.hoverPoints,T=y.closestPointRange||y.ordinal&&y.ordinal.overscrollPointsRange,O=y.translationSlope*(y.ordinal.slope||T),C=(S-x)/O,I={ordinal:{positions:y.ordinal.getExtendedPositions()}},L=y.index2val,D=y.val2lin,N=void 0,B=void 0,X=void 0,W=void 0;I.ordinal.positions?Math.abs(C)>1&&(E&&E.forEach(function(F){F.setState()}),C<0?(X=I,W=y.ordinal.positions?y:I):(X=y.ordinal.positions?y:I,W=I),B=W.ordinal.positions,A>B[B.length-1]&&B.push(A),m.fixedRange=P-M,N=y.navigatorAxis.toFixedRange(null,null,L.apply(X,[D.apply(X,[M,!0])+C]),L.apply(W,[D.apply(W,[P,!0])+C])),N.min>=Math.min(k.dataMin,M)&&N.max<=Math.max(A,P)+v&&y.setExtremes(N.min,N.max,!0,!1,{trigger:"pan"}),m.mouseDownX=x,css$3(m.container,{cursor:"move"})):$=!0}else $=!0;$||b&&/y/.test(b.type)?v&&(y.max=y.dataMax+v):g.preventDefault()}function p(){var g=this.xAxis;g&&g.options.ordinal&&(delete g.ordinal.index,delete g.ordinal.extendedOrdinalPositions)}function f(g,m){var y=this,v=y.ordinal,x=v.positions,b=v.slope,$=v.extendedOrdinalPositions;if(!x)return g;var S=x.length,k;if(x[0]<=g&&x[S-1]>=g)k=s(x,g);else{if($||($=v.getExtendedPositions&&v.getExtendedPositions(),v.extendedOrdinalPositions=$),!($&&$.length))return g;var A=$.length;b||(b=($[A-1]-$[0])/A);var M=s($,x[0]);if(g>=$[0]&&g<=$[A-1])k=s($,g)-M;else if(g<$[0]){var P=$[0]-g,E=P/b;k=-M-E}else{var P=g-$[A-1],E=P/b;k=E+A-M}}return m?k:b*(k||0)+v.offset}var u=function(){function g(m){this.index={},this.axis=m}return g.prototype.beforeSetTickPositions=function(){var m=this.axis,y=m.ordinal,v=m.getExtremes(),x=v.min,b=v.max,$=m.isXAxis&&!!m.options.breaks,S=m.options.ordinal,k=m.chart.options.chart.ignoreHiddenSeries,A,M,P,E,T,O,C,I,L=[],D=Number.MAX_VALUE,N=!1;if(S||$){if(m.series.forEach(function(B,X){if(M=[],(!k||B.visible!==!1)&&(B.takeOrdinalPosition!==!1||$)&&(L=L.concat(B.processedXData),A=L.length,L.sort(function(W,F){return W-F}),D=Math.min(D,pick$11(B.closestPointRange,D)),A)){for(X=0;X<A-1;)L[X]!==L[X+1]&&M.push(L[X+1]),X++;M[0]!==L[0]&&M.unshift(L[0]),L=M}B.isSeriesBoosting&&(I=!0)}),I&&(L.length=0),A=L.length,A>2){for(P=L[1]-L[0],C=A-1;C--&&!N;)L[C+1]-L[C]!==P&&(N=!0);!m.options.keepOrdinalPadding&&(L[0]-x>P||b-L[L.length-1]>P)&&(N=!0)}else m.options.overscroll&&(A===2?D=L[1]-L[0]:A===1?(D=m.options.overscroll,L=[L[0],L[0]+D]):D=y.overscrollPointsRange);N||m.forceOrdinal?(m.options.overscroll&&(y.overscrollPointsRange=D,L=L.concat(y.getOverscrollPositions())),y.positions=L,E=m.ordinal2lin(Math.max(x,L[0]),!0),T=Math.max(m.ordinal2lin(Math.min(b,L[L.length-1]),!0),1),y.slope=O=(b-x)/(T-E),y.offset=x-E*O):(y.overscrollPointsRange=pick$11(m.closestPointRange,y.overscrollPointsRange),y.positions=m.ordinal.slope=y.offset=void 0)}m.isOrdinal=S&&N,y.groupIntervalFactor=null},g.findIndexOf=function(m,y,v){for(var x=0,b=m.length-1,$;x<b;)$=Math.ceil((x+b)/2),m[$]<=y?x=$:b=$-1;return m[x]===y||v?x:-1},g.prototype.getExtendedPositions=function(){var m=this,y=m.axis,v=y.constructor.prototype,x=y.chart,b=y.series[0].currentDataGrouping,$=b?b.count+b.unitName:"raw",S=y.options.overscroll,k=y.getExtremes(),A,M=void 0,P=m.index;return P||(P=m.index={}),P[$]||(A={series:[],chart:x,forceOrdinal:!1,getExtremes:function(){return{min:k.dataMin,max:k.dataMax+S}},getGroupPixelWidth:v.getGroupPixelWidth,getTimeTicks:v.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},ordinal2lin:v.ordinal2lin,getIndexOfPoint:v.getIndexOfPoint,val2lin:v.val2lin},A.ordinal.axis=A,y.series.forEach(function(E){M={xAxis:A,xData:E.xData.slice(),chart:x,destroyGroupedData:H.noop,getProcessedData:Series$e.prototype.getProcessedData,applyGrouping:Series$e.prototype.applyGrouping},M.xData=M.xData.concat(m.getOverscrollPositions()),M.options={dataGrouping:b?{firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",enabled:!0,forced:!0,approximation:"open",units:[[b.unitName,[b.count]]]}:{enabled:!1}},A.series.push(M),E.processData.apply(M)}),y.applyGrouping.call(A),M.closestPointRange!==M.basePointRange&&M.currentDataGrouping&&(A.forceOrdinal=!0),y.ordinal.beforeSetTickPositions.apply({axis:A}),P[$]=A.ordinal.positions),P[$]},g.prototype.getGroupIntervalFactor=function(m,y,v){var x=this;x.axis;var b=v.processedXData,$=b.length,S=[],k,A,M=x.groupIntervalFactor;if(!M){for(A=0;A<$-1;A++)S[A]=b[A+1]-b[A];S.sort(function(P,E){return P-E}),k=S[Math.floor($/2)],m=Math.max(m,b[0]),y=Math.min(y,b[$-1]),x.groupIntervalFactor=M=$*k/(y-m)}return M},g.prototype.getIndexOfPoint=function(m,y){var v=this,x=v.axis,b=v.positions?v.positions[0]:0,$=x.series[0].points&&x.series[0].points[0]&&x.series[0].points[0].plotX||x.minPixelPadding;x.series.length>1&&x.series.forEach(function(A){defined$z(A.points[0])&&defined$z(A.points[0].plotX)&&A.points[0].plotX<$&&($=A.points[0].plotX)});var S=x.translationSlope*(v.slope||x.closestPointRange||v.overscrollPointsRange),k=(m-$)/S;return g.findIndexOf(y,b)+k},g.prototype.getOverscrollPositions=function(){var m=this,y=m.axis,v=y.options.overscroll,x=m.overscrollPointsRange,b=[],$=y.dataMax;if(defined$z(x))for(;$<=y.dataMax+v;)$+=x,b.push($);return b},g.prototype.postProcessTickInterval=function(m){var y=this,v=y.axis,x=y.slope,b;return x?v.options.breaks?b=v.closestPointRange||m:b=m/(x/v.closestPointRange):b=m,b},g}();n.Additions=u})(OrdinalAxis||(OrdinalAxis={}));const OrdinalAxis$1=OrdinalAxis;var addEvent$L=Utilities.addEvent,find$d=Utilities.find,fireEvent$l=Utilities.fireEvent,isArray$9=Utilities.isArray,isNumber$t=Utilities.isNumber,pick$10=Utilities.pick,BrokenAxis;(function(n){var e=[];function t(f,u){if(e.indexOf(f)===-1&&(e.push(f),f.keepProps.push("brokenAxis"),addEvent$L(f,"init",a),addEvent$L(f,"afterInit",r),addEvent$L(f,"afterSetTickPositions",s),addEvent$L(f,"afterSetOptions",o)),e.indexOf(u)===-1){e.push(u);var g=u.prototype;g.drawBreaks=d,g.gappedPath=c,addEvent$L(u,"afterGeneratePoints",l),addEvent$L(u,"afterRender",h)}return f}n.compose=t;function r(){typeof this.brokenAxis<"u"&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function o(){var f=this;f.brokenAxis&&f.brokenAxis.hasBreaks&&(f.options.ordinal=!1)}function s(){var f=this,u=f.brokenAxis;if(u&&u.hasBreaks){for(var g=f.tickPositions,m=f.tickPositions.info,y=[],v=0;v<g.length;v++)u.isInAnyBreak(g[v])||y.push(g[v]);f.tickPositions=y,f.tickPositions.info=m}}function a(){var f=this;f.brokenAxis||(f.brokenAxis=new p(f))}function l(){var f=this,u=f.isDirty,g=f.options.connectNulls,m=f.points,y=f.xAxis,v=f.yAxis;if(u)for(var x=m.length;x--;){var b=m[x],$=b.y===null&&g===!1,S=!$&&(y&&y.brokenAxis&&y.brokenAxis.isInAnyBreak(b.x,!0)||v&&v.brokenAxis&&v.brokenAxis.isInAnyBreak(b.y,!0));b.visible=S?!1:b.options.visible!==!1}}function h(){this.drawBreaks(this.xAxis,["x"]),this.drawBreaks(this.yAxis,pick$10(this.pointArrayMap,["y"]))}function d(f,u){var g=this,m=g.points,y,v,x,b;if(f&&f.brokenAxis&&f.brokenAxis.hasBreaks){var $=f.brokenAxis;u.forEach(function(S){y=$&&$.breakArray||[],v=f.isXAxis?f.min:pick$10(g.options.threshold,f.min),m.forEach(function(k){b=pick$10(k["stack"+S.toUpperCase()],k[S]),y.forEach(function(A){isNumber$t(v)&&isNumber$t(b)&&(x=!1,v<A.from&&b>A.to||v>A.from&&b<A.from?x="pointBreak":(v<A.from&&b>A.from&&b<A.to||v>A.from&&b>A.to&&b<A.from)&&(x="pointInBreak"),x&&fireEvent$l(f,x,{point:k,brk:A}))})})})}}function c(){var f=this.currentDataGrouping,u=f&&f.gapSize,g=this.points.slice(),m=this.yAxis,y=this.options.gapSize,v=g.length-1,x;if(y&&v>0){this.options.gapUnit!=="value"&&(y*=this.basePointRange),u&&u>y&&u>=this.basePointRange&&(y=u);for(var b=void 0,$=void 0;v--;)if($&&$.visible!==!1||($=g[v+1]),b=g[v],!($.visible===!1||b.visible===!1)){if($.x-b.x>y){var S=(b.x+$.x)/2;g.splice(v+1,0,{isNull:!0,x:S}),m.stacking&&this.options.stacking&&(x=m.stacking.stacks[this.stackKey][S]=new StackItem$1(m,m.options.stackLabels,!1,S,this.stack),x.total=0)}$=b}}return this.getGraphPath(g)}var p=function(){function f(u){this.hasBreaks=!1,this.axis=u}return f.isInBreak=function(u,g){var m=u.repeat||1/0,y=u.from,v=u.to-u.from,x=g>=y?(g-y)%m:m-(y-g)%m,b;return u.inclusive?b=x<=v:b=x<v&&x!==0,b},f.lin2Val=function(u){var g=this,m=g.brokenAxis,y=m&&m.breakArray;if(!y||!isNumber$t(u))return u;var v=u,x,b;for(b=0;b<y.length&&(x=y[b],!(x.from>=v));b++)(x.to<v||f.isInBreak(x,v))&&(v+=x.len);return v},f.val2Lin=function(u){var g=this,m=g.brokenAxis,y=m&&m.breakArray;if(!y||!isNumber$t(u))return u;var v=u,x,b;for(b=0;b<y.length;b++)if(x=y[b],x.to<=u)v-=x.len;else{if(x.from>=u)break;if(f.isInBreak(x,u)){v-=u-x.from;break}}return v},f.prototype.findBreakAt=function(u,g){return find$d(g,function(m){return m.from<u&&u<m.to})},f.prototype.isInAnyBreak=function(u,g){var m=this,y=m.axis,v=y.options.breaks||[],x=v.length,b,$,S;if(x&&isNumber$t(u)){for(;x--;)f.isInBreak(v[x],u)&&(b=!0,$||($=pick$10(v[x].showPoints,!y.isXAxis)));b&&g?S=b&&!$:S=b}return S},f.prototype.setBreaks=function(u,g){var m=this,y=m.axis,v=isArray$9(u)&&!!u.length;y.isDirty=m.hasBreaks!==v,m.hasBreaks=v,y.options.breaks=y.userOptions.breaks=u,y.forceRedraw=!0,y.series.forEach(function(x){x.isDirty=!0}),!v&&y.val2lin===f.val2Lin&&(delete y.val2lin,delete y.lin2val),v&&(y.userOptions.ordinal=!1,y.lin2val=f.lin2Val,y.val2lin=f.val2Lin,y.setExtremes=function(x,b,$,S,k){if(m.hasBreaks){for(var A=this.options.breaks||[],M=void 0;M=m.findBreakAt(x,A);)x=M.to;for(;M=m.findBreakAt(b,A);)b=M.from;b<x&&(b=x)}y.constructor.prototype.setExtremes.call(this,x,b,$,S,k)},y.setAxisTranslation=function(){if(y.constructor.prototype.setAxisTranslation.call(this),m.unitLength=void 0,m.hasBreaks){var x=y.options.breaks||[],b=[],$=[],S=pick$10(y.pointRangePadding,0),k=0,A,M,P=y.userMin||y.min,E=y.userMax||y.max,T,O;x.forEach(function(C){M=C.repeat||1/0,isNumber$t(P)&&isNumber$t(E)&&(f.isInBreak(C,P)&&(P+=C.to%M-P%M),f.isInBreak(C,E)&&(E-=E%M-C.from%M))}),x.forEach(function(C){if(T=C.from,M=C.repeat||1/0,isNumber$t(P)&&isNumber$t(E)){for(;T-M>P;)T-=M;for(;T<P;)T+=M;for(O=T;O<E;O+=M)b.push({value:O,move:"in"}),b.push({value:O+C.to-C.from,move:"out",size:C.breakSize})}}),b.sort(function(C,I){return C.value===I.value?(C.move==="in"?0:1)-(I.move==="in"?0:1):C.value-I.value}),A=0,T=P,b.forEach(function(C){A+=C.move==="in"?1:-1,A===1&&C.move==="in"&&(T=C.value),A===0&&isNumber$t(T)&&($.push({from:T,to:C.value,len:C.value-T-(C.size||0)}),k+=C.value-T-(C.size||0))}),m.breakArray=$,isNumber$t(P)&&isNumber$t(E)&&isNumber$t(y.min)&&(m.unitLength=E-P-k+S,fireEvent$l(y,"afterBreaks"),y.staticScale?y.transA=y.staticScale:m.unitLength&&(y.transA*=(E-y.min+S)/m.unitLength),S&&(y.minPixelPadding=y.transA*(y.minPointOffset||0)),y.min=P,y.max=E)}}),pick$10(g,!0)&&y.chart.redraw()},f}();n.Additions=p})(BrokenAxis||(BrokenAxis={}));const BrokenAxis$1=BrokenAxis;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/broken-axis
 * @requires highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$6=H;BrokenAxis$1.compose(G$6.Axis,G$6.Series);var format$7=FormatUtilities.format,seriesProto$3=Series$e.prototype,addEvent$K=Utilities.addEvent,arrayMax$5=Utilities.arrayMax,arrayMin$5=Utilities.arrayMin,correctFloat$7=Utilities.correctFloat,defined$y=Utilities.defined,error$2=Utilities.error,extend$12=Utilities.extend,isNumber$s=Utilities.isNumber,merge$W=Utilities.merge,pick$$=Utilities.pick,approximations=H.approximations={sum:function(n){var e=n.length,t;if(!e&&n.hasNulls)t=null;else if(e)for(t=0;e--;)t+=n[e];return t},average:function(n){var e=n.length,t=approximations.sum(n);return isNumber$s(t)&&e&&(t=correctFloat$7(t/e)),t},averages:function(){var n=[];return[].forEach.call(arguments,function(e){n.push(approximations.average(e))}),typeof n[0]>"u"?void 0:n},open:function(n){return n.length?n[0]:n.hasNulls?null:void 0},high:function(n){return n.length?arrayMax$5(n):n.hasNulls?null:void 0},low:function(n){return n.length?arrayMin$5(n):n.hasNulls?null:void 0},close:function(n){return n.length?n[n.length-1]:n.hasNulls?null:void 0},ohlc:function(n,e,t,r){if(n=approximations.open(n),e=approximations.high(e),t=approximations.low(t),r=approximations.close(r),isNumber$s(n)||isNumber$s(e)||isNumber$s(t)||isNumber$s(r))return[n,e,t,r]},range:function(n,e){if(n=approximations.low(n),e=approximations.high(e),isNumber$s(n)||isNumber$s(e))return[n,e];if(n===null&&e===null)return null}},applyGrouping=function(){var n=this,e=n.chart,t=n.options,r=t.dataGrouping,o=n.allowDG!==!1&&r&&pick$$(r.enabled,e.options.isStock),s=n.visible||!e.options.chart.ignoreHiddenSeries,a,l,h=this.currentDataGrouping,d,c,p=!1;if(o&&!n.requireSorting&&(n.requireSorting=p=!0),l=skipDataGrouping(n)||!o,p&&(n.requireSorting=!1),!l){n.destroyGroupedData();var f=void 0,u=r.groupAll?n.xData:n.processedXData,g=r.groupAll?n.yData:n.processedYData,m=e.plotSizeX,y=n.xAxis,v=y.options.ordinal,x=n.groupPixelWidth;if(x&&u&&u.length){a=!0,n.isDirty=!0,n.points=null;var b=y.getExtremes(),$=b.min,S=b.max,k=v&&y.ordinal&&y.ordinal.getGroupIntervalFactor($,S,n)||1,A=x*(S-$)/m*k,M=y.getTimeTicks(DateTimeAxis$1.Additions.prototype.normalizeTimeTickInterval(A,r.units||defaultDataGroupingUnits),Math.min($,u[0]),Math.max(S,u[u.length-1]),y.options.startOfWeek,u,n.closestPointRange),P=seriesProto$3.groupData.apply(n,[u,g,M,r.approximation]),E=P.groupedXData,T=P.groupedYData,O=0;for(r&&r.smoothed&&E.length&&(r.firstAnchor="firstPoint",r.anchor="middle",r.lastAnchor="lastPoint",error$2(32,!1,e,{"dataGrouping.smoothed":"use dataGrouping.anchor"})),anchorPoints(n,E,S),f=1;f<M.length;f++)(!M.info.segmentStarts||M.info.segmentStarts.indexOf(f)===-1)&&(O=Math.max(M[f]-M[f-1],O));d=M.info,d.gapSize=O,n.closestPointRange=M.info.totalRange,n.groupMap=P.groupMap,s&&adjustExtremes(y,E),r.groupAll&&(n.allGroupedData=T,c=n.cropData(E,T,y.min,y.max,1),E=c.xData,T=c.yData,n.cropStart=c.start),n.processedXData=E,n.processedYData=T}else n.groupMap=null;n.hasGroupedData=a,n.currentDataGrouping=d,n.preventGraphAnimation=(h&&h.totalRange)!==(d&&d.totalRange)}},skipDataGrouping=function(n){if(n.isCartesian&&!n.isDirty&&!n.xAxis.isDirty&&!n.yAxis.isDirty)return!1},groupData=function(n,e,t,r){var o=this,s=o.data,a=o.options&&o.options.data,l=[],h=[],d=[],c=n.length,p,f,u,g=!!e,m=[],y,v=o.pointArrayMap,x=v&&v.length,b=["x"].concat(v||["y"]),$=this.options.dataGrouping&&this.options.dataGrouping.groupAll,S=0,k=0,A,M,P;function E(I){return typeof I=="function"?I:approximations[I]?approximations[I]:approximations[o.getDGApproximation&&o.getDGApproximation()||"average"]}for(y=E(r),x?v.forEach(function(){m.push([])}):m.push([]),A=x||1,M=0;M<=c&&!(n[M]>=t[0]);M++);for(M;M<=c;M++){for(;typeof t[S+1]<"u"&&n[M]>=t[S+1]||M===c;){for(p=t[S],o.dataGroupInfo={start:$?k:o.cropStart+k,length:m[0].length},u=y.apply(o,m),o.pointClass&&!defined$y(o.dataGroupInfo.options)&&(o.dataGroupInfo.options=merge$W(o.pointClass.prototype.optionsToObject.call({series:o},o.options.data[o.cropStart+k])),b.forEach(function(I){delete o.dataGroupInfo.options[I]})),typeof u<"u"&&(l.push(p),h.push(u),d.push(o.dataGroupInfo)),k=M,P=0;P<A;P++)m[P].length=0,m[P].hasNulls=!1;if(S+=1,M===c)break}if(M===c)break;if(v){var T=o.options.dataGrouping&&o.options.dataGrouping.groupAll?M:o.cropStart+M,O=s&&s[T]||o.pointClass.prototype.applyOptions.apply({series:o},[a[T]]),C=void 0;for(P=0;P<x;P++)C=O[v[P]],isNumber$s(C)?m[P].push(C):C===null&&(m[P].hasNulls=!0)}else f=g?e[M]:null,isNumber$s(f)?m[0].push(f):f===null&&(m[0].hasNulls=!0)}return{groupedXData:l,groupedYData:h,groupMap:d}},anchorPoints=function(n,e,t){var r=n.options,o=r.dataGrouping,s=n.currentDataGrouping&&n.currentDataGrouping.gapSize,a;if(o&&n.xData&&s&&n.groupMap){var l=e.length-1,h=o.anchor,d=pick$$(o.firstAnchor,h),c=pick$$(o.lastAnchor,h);if(h&&h!=="start"){var p=s*{middle:.5,end:1}[h];for(a=e.length-1;a--&&a>0;)e[a]+=p}if(d&&d!=="start"&&n.xData[0]>=e[0]){var f=n.groupMap[0].start,u=n.groupMap[0].length,g=void 0;isNumber$s(f)&&isNumber$s(u)&&(g=f+(u-1)),e[0]={middle:e[0]+.5*s,end:e[0]+s,firstPoint:n.xData[0],lastPoint:g&&n.xData[g]}[d]}if(c&&c!=="start"&&s&&e[l]>=t-s){var m=n.groupMap[n.groupMap.length-1].start;e[l]={middle:e[l]+.5*s,end:e[l]+s,firstPoint:m&&n.xData[m],lastPoint:n.xData[n.xData.length-1]}[c]}}},adjustExtremes=function(n,e){defined$y(e[0])&&isNumber$s(n.min)&&isNumber$s(n.dataMin)&&e[0]<n.min&&((!defined$y(n.options.min)&&n.min<=n.dataMin||n.min===n.dataMin)&&(n.min=Math.min(e[0],n.min)),n.dataMin=Math.min(e[0],n.dataMin)),defined$y(e[e.length-1])&&isNumber$s(n.max)&&isNumber$s(n.dataMax)&&e[e.length-1]>n.max&&((!defined$y(n.options.max)&&isNumber$s(n.dataMax)&&n.max>=n.dataMax||n.max===n.dataMax)&&(n.max=Math.max(e[e.length-1],n.max)),n.dataMax=Math.max(e[e.length-1],n.dataMax))},dataGrouping={approximations,groupData};seriesProto$3.processData;var baseGeneratePoints=seriesProto$3.generatePoints,commonOptions={groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S","%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},specificOptions={line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},defaultDataGroupingUnits=H.defaultDataGroupingUnits=[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]];seriesProto$3.getDGApproximation=function(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("column")?"sum":"average"};seriesProto$3.groupData=groupData;seriesProto$3.applyGrouping=applyGrouping;seriesProto$3.destroyGroupedData=function(){this.groupedData&&(this.groupedData.forEach(function(n,e){n&&(this.groupedData[e]=n.destroy?n.destroy():null)},this),this.groupedData.length=0)};seriesProto$3.generatePoints=function(){baseGeneratePoints.apply(this),this.destroyGroupedData(),this.groupedData=this.hasGroupedData?this.points:null};Axis.prototype.applyGrouping=function(){var n=this,e=n.series;e.forEach(function(t){t.groupPixelWidth=void 0,t.groupPixelWidth=n.getGroupPixelWidth&&n.getGroupPixelWidth(),t.groupPixelWidth&&(t.hasProcessed=!0),t.applyGrouping()})};Axis.prototype.getGroupPixelWidth=function(){var n=this.series,e=n.length,t,r=0,o=!1,s,a;for(t=e;t--;)a=n[t].options.dataGrouping,a&&(r=Math.max(r,pick$$(a.groupPixelWidth,commonOptions.groupPixelWidth)));for(t=e;t--;)a=n[t].options.dataGrouping,a&&(s=(n[t].processedXData||n[t].data).length,(n[t].groupPixelWidth||s>this.chart.plotSizeX/r||s&&a.forced)&&(o=!0));return o?r:0};Axis.prototype.setDataGrouping=function(n,e){var t=this,r;if(e=pick$$(e,!0),n||(n={forced:!1,units:null}),this instanceof Axis)for(r=this.series.length;r--;)this.series[r].update({dataGrouping:n},!1);else this.chart.options.series.forEach(function(o){o.dataGrouping=n},!1);t.ordinal&&(t.ordinal.slope=void 0),e&&this.chart.redraw()};addEvent$K(Axis,"postProcessData",Axis.prototype.applyGrouping);addEvent$K(Point$2,"update",function(){if(this.dataGroup)return error$2(24,!1,this.series.chart),!1});addEvent$K(Tooltip,"headerFormatter",function(n){var e=this.chart,t=e.time,r=n.labelConfig,o=r.series,s=o.options,a=o.tooltipOptions,l=s.dataGrouping,h=a.xDateFormat,d,c=o.xAxis,p,f,u,g,m=a[n.isFooter?"footerFormat":"headerFormat"];c&&c.options.type==="datetime"&&l&&isNumber$s(r.key)&&(p=o.currentDataGrouping,f=l.dateTimeLabelFormats||commonOptions.dateTimeLabelFormats,p?(u=f[p.unitName],p.count===1?h=u[0]:(h=u[1],d=u[2])):!h&&f&&c.dateTime&&(h=c.dateTime.getXDateFormat(r.x,a.dateTimeLabelFormats)),g=t.dateFormat(h,r.key),d&&(g+=t.dateFormat(d,r.key+p.totalRange-1)),o.chart.styledMode&&(m=this.styledModeFormat(m)),n.text=format$7(m,{point:extend$12(r.point,{key:g}),series:o},e),n.preventDefault())});addEvent$K(Series$e,"destroy",seriesProto$3.destroyGroupedData);addEvent$K(Series$e,"afterSetOptions",function(n){var e=n.options,t=this.type,r=this.chart.options.plotOptions,o=DefaultOptions.defaultOptions.plotOptions[t].dataGrouping,s=this.useCommonDataGrouping&&commonOptions;if(specificOptions[t]||s){o||(o=merge$W(commonOptions,specificOptions[t]));var a=this.chart.rangeSelector;e.dataGrouping=merge$W(s,o,r.series&&r.series.dataGrouping,r[t].dataGrouping,this.userOptions.dataGrouping,!e.isInternal&&a&&isNumber$s(a.selected)&&a.buttonOptions[a.selected].dataGrouping)}});addEvent$K(Axis,"afterSetScale",function(){this.series.forEach(function(n){n.hasProcessed=!1})});H.dataGrouping=dataGrouping;var __extends$L=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),ColumnSeries$g=SeriesRegistry$1.seriesTypes.column,OHLCPoint=function(n){__extends$L(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.close=void 0,t.high=void 0,t.low=void 0,t.open=void 0,t.options=void 0,t.plotClose=void 0,t.plotOpen=void 0,t.series=void 0,t}return e.prototype.getClassName=function(){return n.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")},e.prototype.resolveUpColor=function(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)},e.prototype.resolveColor=function(){n.prototype.resolveColor.call(this),this.resolveUpColor()},e.prototype.getZone=function(){var t=n.prototype.getZone.call(this);return this.resolveUpColor(),t},e.prototype.applyOptions=function(){return n.prototype.applyOptions.apply(this,arguments),this.resolveColor&&this.resolveColor(),this},e}(ColumnSeries$g.prototype.pointClass),__extends$K=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),ColumnSeries$f=SeriesRegistry$1.seriesTypes.column,extend$11=Utilities.extend,merge$V=Utilities.merge,OHLCSeries$1=function(n){__extends$K(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t.yData=void 0,t}return e.prototype.drawPoints=function(){var t=this,r=t.points,o=t.chart,s=function(a,l,h){var d=a[0],c=a[1];typeof d[2]=="number"&&(d[2]=Math.max(h+l,d[2])),typeof c[2]=="number"&&(c[2]=Math.min(h-l,c[2]))};r.forEach(function(a){var l,h,d,c,p,f=a.graphic,u,g=!f,m;typeof a.plotY<"u"&&(f||(a.graphic=f=o.renderer.path().add(t.group)),o.styledMode||f.attr(t.pointAttribs(a,a.selected&&"select")),m=f.strokeWidth(),d=m%2/2,u=Math.round(a.plotX)-d,c=Math.round(a.shapeArgs.width/2),p=[["M",u,Math.round(a.yBottom)],["L",u,Math.round(a.plotHigh)]],a.open!==null&&(l=Math.round(a.plotOpen)+d,p.push(["M",u,l],["L",u-c,l]),s(p,m/2,l)),a.close!==null&&(h=Math.round(a.plotClose)+d,p.push(["M",u,h],["L",u+c,h]),s(p,m/2,h)),f[g?"attr":"animate"]({d:p}).addClass(a.getClassName(),!0))})},e.prototype.init=function(){n.prototype.init.apply(this,arguments),this.options.stacking=void 0},e.prototype.pointAttribs=function(t,r){var o=n.prototype.pointAttribs.call(this,t,r),s=this.options;return delete o.fill,!t.options.color&&s.upColor&&t.open<t.close&&(o.stroke=s.upColor),o},e.prototype.toYData=function(t){return[t.open,t.high,t.low,t.close]},e.prototype.translate=function(){var t=this,r=t.yAxis,o=!!t.modifyValue,s=["plotOpen","plotHigh","plotLow","plotClose","yBottom"];n.prototype.translate.apply(t),t.points.forEach(function(a){[a.open,a.high,a.low,a.close,a.low].forEach(function(l,h){l!==null&&(o&&(l=t.modifyValue(l)),a[s[h]]=r.toPixels(l,!0))}),a.tooltipPos[1]=a.plotHigh+r.pos-t.chart.plotTop})},e.defaultOptions=merge$V(ColumnSeries$f.defaultOptions,{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0}),e}(ColumnSeries$f);extend$11(OHLCSeries$1.prototype,{animate:null,directTouch:!1,pointArrayMap:["open","high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"});OHLCSeries$1.prototype.pointClass=OHLCPoint;SeriesRegistry$1.registerSeriesType("ohlc",OHLCSeries$1);var __extends$J=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),defaultOptions$8=DefaultOptions.defaultOptions,_a$d=SeriesRegistry$1.seriesTypes,ColumnSeries$e=_a$d.column,OHLCSeries=_a$d.ohlc,merge$U=Utilities.merge,CandlestickSeries=function(n){__extends$J(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.pointAttribs=function(t,r){var o=ColumnSeries$e.prototype.pointAttribs.call(this,t,r),s=this.options,a=t.open<t.close,l=s.lineColor||this.color,h=t.color||this.color,d;return o["stroke-width"]=s.lineWidth,o.fill=t.options.color||a&&s.upColor||h,o.stroke=t.options.lineColor||a&&s.upLineColor||l,r&&(d=s.states[r],o.fill=d.color||o.fill,o.stroke=d.lineColor||o.stroke,o["stroke-width"]=d.lineWidth||o["stroke-width"]),o},e.prototype.drawPoints=function(){var t=this,r=t.points,o=t.chart,s=t.yAxis.reversed;r.forEach(function(a){var l=a.graphic,h,d,c,p,f,u,g,m,y,v,x=!l;typeof a.plotY<"u"&&(l||(a.graphic=l=o.renderer.path().add(t.group)),t.chart.styledMode||l.attr(t.pointAttribs(a,a.selected&&"select")).shadow(t.options.shadow),g=l.strokeWidth()%2/2,m=Math.round(a.plotX)-g,h=a.plotOpen,d=a.plotClose,c=Math.min(h,d),p=Math.max(h,d),v=Math.round(a.shapeArgs.width/2),f=s?p!==a.yBottom:Math.round(c)!==Math.round(a.plotHigh),u=s?Math.round(c)!==Math.round(a.plotHigh):p!==a.yBottom,c=Math.round(c)+g,p=Math.round(p)+g,y=[],y.push(["M",m-v,p],["L",m-v,c],["L",m+v,c],["L",m+v,p],["Z"],["M",m,c],["L",m,f?Math.round(s?a.yBottom:a.plotHigh):c],["M",m,p],["L",m,u?Math.round(s?a.plotHigh:a.yBottom):p]),l[x?"attr":"animate"]({d:y}).addClass(a.getClassName(),!0))})},e.defaultOptions=merge$U(OHLCSeries.defaultOptions,defaultOptions$8.plotOptions,{states:{hover:{lineWidth:2}},tooltip:defaultOptions$8.plotOptions.ohlc.tooltip,threshold:null,lineColor:palette.neutralColor100,lineWidth:1,upColor:palette.backgroundColor,stickyTracking:!0}),e}(OHLCSeries);SeriesRegistry$1.registerSeriesType("candlestick",CandlestickSeries);var __extends$I=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),ColumnSeries$d=SeriesRegistry$1.seriesTypes.column,isNumber$r=Utilities.isNumber,FlagsPoint=function(n){__extends$I(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return e.prototype.isValid=function(){return isNumber$r(this.y)||typeof this.y>"u"},e.prototype.hasNewShapeType=function(){var t=this.options.shape||this.series.options.shape;return this.graphic&&t&&t!==this.graphic.symbolKey},e}(ColumnSeries$d.prototype.pointClass),columnProto$5=ColumnSeries$h.prototype,seriesProto$2=Series$e.prototype,defined$x=Utilities.defined,stableSort$4=Utilities.stableSort,onSeriesMixin={getPlotBox:function(){return seriesProto$2.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this)},translate:function(){columnProto$5.translate.apply(this);var n=this,e=n.options,t=n.chart,r=n.points,o=r.length-1,s,a,l=e.onSeries,h=l&&t.get(l),d=e.onKey||"y",c=h&&h.options.step,p=h&&h.points,f=p&&p.length,u=t.inverted,g=n.xAxis,m=n.yAxis,y=0,v,x,b,$,S;if(h&&h.visible&&f)for(y=(h.pointXOffset||0)+(h.barW||0)/2,$=h.currentDataGrouping,x=p[f-1].x+($?$.totalRange:0),stableSort$4(r,function(k,A){return k.x-A.x}),d="plot"+d[0].toUpperCase()+d.substr(1);f--&&r[o]&&(v=p[f],s=r[o],s.y=v.y,!(v.x<=s.x&&typeof v[d]<"u"&&(s.x<=x&&(s.plotY=v[d],v.x<s.x&&!c&&(b=p[f+1],b&&typeof b[d]<"u"&&(S=(s.x-v.x)/(b.x-v.x),s.plotY+=S*(b[d]-v[d]),s.y+=S*(b.y-v.y)))),o--,f++,o<0))););r.forEach(function(k,A){var M;k.plotX+=y,(typeof k.plotY>"u"||u)&&(k.plotX>=0&&k.plotX<=g.len?u?(k.plotY=g.translate(k.x,0,1,0,1),k.plotX=defined$x(k.y)?m.translate(k.y,0,0,0,1):0):k.plotY=(g.opposite?0:n.yAxis.len)+g.offset:k.shapeArgs={}),a=r[A-1],a&&a.plotX===k.plotX&&(typeof a.stackIndex>"u"&&(a.stackIndex=0),M=a.stackIndex+1),k.stackIndex=M}),this.onSeries=h}},symbols$3=SVGRenderer.prototype.symbols;symbols$3.flag=function(n,e,t,r,o){var s=o&&o.anchorX||n,a=o&&o.anchorY||e,l=symbols$3.circle(s-1,a-1,2,2);return l.push(["M",s,a],["L",n,e+r],["L",n,e],["L",n+t,e],["L",n+t,e+r],["L",n,e+r],["Z"]),l};function createPinSymbol(n){symbols$3[n+"pin"]=function(e,t,r,o,s){var a=s&&s.anchorX,l=s&&s.anchorY,h;if(n==="circle"&&o>r&&(e-=Math.round((o-r)/2),r=o),h=symbols$3[n](e,t,r,o),a&&l){var d=a;if(n==="circle")d=e+r/2;else{var c=h[0],p=h[1];c[0]==="M"&&p[0]==="L"&&(d=(c[1]+p[1])/2)}var f=t>l?t:t+o;h.push(["M",d,f],["L",a,l]),h=h.concat(symbols$3.circle(a-1,l-1,2,2))}return h}}createPinSymbol("circle");createPinSymbol("square");var Renderer=RendererRegistry$1.getRendererType();Renderer!==SVGRenderer&&(Renderer.prototype.symbols.circlepin=symbols$3.circlepin,Renderer.prototype.symbols.flag=symbols$3.flag,Renderer.prototype.symbols.squarepin=symbols$3.squarepin);var __extends$H=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),noop$e=H.noop,distribute=R.distribute,Series$b=SeriesRegistry$1.series,ColumnSeries$c=SeriesRegistry$1.seriesTypes.column,addEvent$J=Utilities.addEvent,defined$w=Utilities.defined,extend$10=Utilities.extend,merge$T=Utilities.merge,objectEach$e=Utilities.objectEach,wrap$b=Utilities.wrap,FlagsSeries=function(n){__extends$H(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.animate=function(t){t&&this.setClip()},e.prototype.drawPoints=function(){var t=this,r=t.points,o=t.chart,s=o.renderer,a,l,h=o.inverted,d=t.options,c=d.y,p,f,u,g,m,y,v,x,b=t.yAxis,$={},S=[],k;for(f=r.length;f--;)u=r[f],x=(h?u.plotY:u.plotX)>t.xAxis.len,a=u.plotX,m=u.stackIndex,p=u.options.shape||d.shape,l=u.plotY,typeof l<"u"&&(l=u.plotY+c-(typeof m<"u"&&m*d.stackDistance)),u.anchorX=m?void 0:u.plotX,y=m?void 0:u.plotY,k=p!=="flag",g=u.graphic,typeof l<"u"&&a>=0&&!x?(g&&u.hasNewShapeType()&&(g=g.destroy()),g||(g=u.graphic=s.label("",null,null,p,null,null,d.useHTML).addClass("highcharts-point").add(t.markerGroup),u.graphic.div&&(u.graphic.div.point=u),g.isNew=!0),g.attr({align:k?"center":"left",width:d.width,height:d.height,"text-align":d.textAlign}),o.styledMode||g.attr(t.pointAttribs(u)).css(merge$T(d.style,u.style)).shadow(d.shadow),a>0&&(a-=g.strokeWidth()%2),v={y:l,anchorY:y},d.allowOverlapX&&(v.x=a,v.anchorX=u.anchorX),g.attr({text:u.options.title||d.title||"A"})[g.isNew?"attr":"animate"](v),d.allowOverlapX||($[u.plotX]?$[u.plotX].size=Math.max($[u.plotX].size,g.width):$[u.plotX]={align:k?.5:0,size:g.width,target:a,anchorX:a}),u.tooltipPos=[a,l+b.pos-o.plotTop]):g&&(u.graphic=g.destroy());d.allowOverlapX||(objectEach$e($,function(A){A.plotX=A.anchorX,S.push(A)}),distribute(S,h?b.len:this.xAxis.len,100),r.forEach(function(A){var M=A.graphic&&$[A.plotX];M&&(A.graphic[A.graphic.isNew?"attr":"animate"]({x:M.pos+M.align*M.size,anchorX:A.anchorX}),defined$w(M.pos)?A.graphic.isNew=!1:(A.graphic.attr({x:-9999,anchorX:-9999}),A.graphic.isNew=!0))})),d.useHTML&&wrap$b(t.markerGroup,"on",function(A){return SVGElement.prototype.on.apply(A.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})},e.prototype.drawTracker=function(){var t=this,r=t.points;n.prototype.drawTracker.call(this),r.forEach(function(o){var s=o.graphic;s&&(o.unbindMouseOver&&o.unbindMouseOver(),o.unbindMouseOver=addEvent$J(s.element,"mouseover",function(){o.stackIndex>0&&!o.raised&&(o._y=s.y,s.attr({y:o._y-8}),o.raised=!0),r.forEach(function(a){a!==o&&a.raised&&a.graphic&&(a.graphic.attr({y:a._y}),a.raised=!1)})}))})},e.prototype.pointAttribs=function(t,r){var o=this.options,s=t&&t.color||this.color,a=o.lineColor,l=t&&t.lineWidth,h=t&&t.fillColor||o.fillColor;return r&&(h=o.states[r].fillColor,a=o.states[r].lineColor,l=o.states[r].lineWidth),{fill:h||s,stroke:a||s,"stroke-width":l||o.lineWidth||0}},e.prototype.setClip=function(){Series$b.prototype.setClip.apply(this,arguments),this.options.clip!==!1&&this.sharedClipKey&&this.markerGroup&&this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])},e.defaultOptions=merge$T(ColumnSeries$c.defaultOptions,{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:palette.backgroundColor,lineWidth:1,states:{hover:{lineColor:palette.neutralColor100,fillColor:palette.highlightColor20}},style:{fontSize:"11px",fontWeight:"bold"}}),e}(ColumnSeries$c);extend$10(FlagsSeries.prototype,{allowDG:!1,buildKDTree:noop$e,forceCrop:!0,getPlotBox:onSeriesMixin.getPlotBox,init:Series$b.prototype.init,invertGroups:noop$e,invertible:!1,noSharedTooltip:!0,pointClass:FlagsPoint,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],translate:onSeriesMixin.translate});SeriesRegistry$1.registerSeriesType("flags",FlagsSeries);var addEvent$I=Utilities.addEvent,defined$v=Utilities.defined,pick$_=Utilities.pick,ScrollbarAxis=function(){function n(){}return n.compose=function(e,t){if(n.composed.indexOf(e)===-1)n.composed.push(e);else return e;var r=function(o){var s=pick$_(o.options&&o.options.min,o.min),a=pick$_(o.options&&o.options.max,o.max);return{axisMin:s,axisMax:a,scrollMin:defined$v(o.dataMin)?Math.min(s,o.min,o.dataMin,pick$_(o.threshold,1/0)):s,scrollMax:defined$v(o.dataMax)?Math.max(a,o.max,o.dataMax,pick$_(o.threshold,-1/0)):a}};return addEvent$I(e,"afterInit",function(){var o=this;o.options&&o.options.scrollbar&&o.options.scrollbar.enabled&&(o.options.scrollbar.vertical=!o.horiz,o.options.startOnTick=o.options.endOnTick=!1,o.scrollbar=new t(o.chart.renderer,o.options.scrollbar,o.chart),addEvent$I(o.scrollbar,"changed",function(s){var a=r(o),l=a.axisMin,h=a.axisMax,d=a.scrollMin,c=a.scrollMax,p=c-d,f,u;!defined$v(l)||!defined$v(h)||(o.horiz&&!o.reversed||!o.horiz&&o.reversed?(f=d+p*this.to,u=d+p*this.from):(f=d+p*(1-this.from),u=d+p*(1-this.to)),this.shouldUpdateExtremes(s.DOMType)?o.setExtremes(u,f,!0,s.DOMType!=="mousemove"&&s.DOMType!=="touchmove",s):this.setRange(this.from,this.to))}))}),addEvent$I(e,"afterRender",function(){var o=this,s=r(o),a=s.scrollMin,l=s.scrollMax,h=o.scrollbar,d=o.axisTitleMargin+(o.titleOffset||0),c=o.chart.scrollbarsOffsets,p=o.options.margin||0,f,u,g;h&&(o.horiz?(o.opposite||(c[1]+=d),h.position(o.left,o.top+o.height+2+c[1]-(o.opposite?p:0),o.width,o.height),o.opposite||(c[1]+=p),f=1):(o.opposite&&(c[0]+=d),h.position(o.left+o.width+2+c[0]-(o.opposite?0:p),o.top,o.width,o.height),o.opposite&&(c[0]+=p),f=0),c[f]+=h.size+h.options.margin,isNaN(a)||isNaN(l)||!defined$v(o.min)||!defined$v(o.max)||o.min===o.max?h.setRange(0,1):(u=(o.min-a)/(l-a),g=(o.max-a)/(l-a),o.horiz&&!o.reversed||!o.horiz&&o.reversed?h.setRange(u,g):h.setRange(1-g,1-u)))}),addEvent$I(e,"afterGetOffset",function(){var o=this,s=o.horiz?2:1,a=o.scrollbar;a&&(o.chart.scrollbarsOffsets=[0,0],o.chart.axisOffset[s]+=a.size+a.options.margin)}),e},n.composed=[],n}(),isTouchDevice$3=H.isTouchDevice,ScrollbarDefaults={height:isTouchDevice$3?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,margin:10,minWidth:6,step:.2,zIndex:3,barBackgroundColor:palette.neutralColor20,barBorderWidth:1,barBorderColor:palette.neutralColor20,buttonArrowColor:palette.neutralColor80,buttonBackgroundColor:palette.neutralColor10,buttonBorderColor:palette.neutralColor20,buttonBorderWidth:1,rifleColor:palette.neutralColor80,trackBackgroundColor:palette.neutralColor5,trackBorderColor:palette.neutralColor5,trackBorderWidth:1},defaultOptions$7=DefaultOptions.defaultOptions,addEvent$H=Utilities.addEvent,correctFloat$6=Utilities.correctFloat,defined$u=Utilities.defined,destroyObjectProperties$3=Utilities.destroyObjectProperties,fireEvent$k=Utilities.fireEvent,merge$S=Utilities.merge,pick$Z=Utilities.pick,removeEvent$4=Utilities.removeEvent,Scrollbar=function(){function n(e,t,r){this._events=[],this.chart=void 0,this.chartX=0,this.chartY=0,this.from=0,this.group=void 0,this.options=void 0,this.renderer=void 0,this.scrollbar=void 0,this.scrollbarButtons=[],this.scrollbarGroup=void 0,this.scrollbarLeft=0,this.scrollbarRifles=void 0,this.scrollbarStrokeWidth=1,this.scrollbarTop=0,this.size=0,this.to=0,this.track=void 0,this.trackBorderWidth=1,this.userOptions=void 0,this.x=0,this.y=0,this.init(e,t,r)}return n.compose=function(e){ScrollbarAxis.compose(e,n)},n.swapXY=function(e,t){return t&&e.forEach(function(r){for(var o=r.length,s,a=0;a<o;a+=2)s=r[a+1],typeof s=="number"&&(r[a+1]=r[a+2],r[a+2]=s)}),e},n.prototype.addEvents=function(){var e=this.options.inverted?[1,0]:[0,1],t=this.scrollbarButtons,r=this.scrollbarGroup.element,o=this.track.element,s=this.mouseDownHandler.bind(this),a=this.mouseMoveHandler.bind(this),l=this.mouseUpHandler.bind(this),h=[[t[e[0]].element,"click",this.buttonToMinClick.bind(this)],[t[e[1]].element,"click",this.buttonToMaxClick.bind(this)],[o,"click",this.trackClick.bind(this)],[r,"mousedown",s],[r.ownerDocument,"mousemove",a],[r.ownerDocument,"mouseup",l]];H.hasTouch&&h.push([r,"touchstart",s],[r.ownerDocument,"touchmove",a],[r.ownerDocument,"touchend",l]),h.forEach(function(d){addEvent$H.apply(null,d)}),this._events=h},n.prototype.buttonToMaxClick=function(e){var t=this,r=(t.to-t.from)*pick$Z(t.options.step,.2);t.updatePosition(t.from+r,t.to+r),fireEvent$k(t,"changed",{from:t.from,to:t.to,trigger:"scrollbar",DOMEvent:e})},n.prototype.buttonToMinClick=function(e){var t=this,r=correctFloat$6(t.to-t.from)*pick$Z(t.options.step,.2);t.updatePosition(correctFloat$6(t.from-r),correctFloat$6(t.to-r)),fireEvent$k(t,"changed",{from:t.from,to:t.to,trigger:"scrollbar",DOMEvent:e})},n.prototype.cursorToScrollbarPosition=function(e){var t=this,r=t.options,o=r.minWidth>t.calculatedWidth?r.minWidth:0;return{chartX:(e.chartX-t.x-t.xOffset)/(t.barWidth-o),chartY:(e.chartY-t.y-t.yOffset)/(t.barWidth-o)}},n.prototype.destroy=function(){var e=this,t=e.chart.scroller;e.removeEvents(),["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(r){e[r]&&e[r].destroy&&(e[r]=e[r].destroy())}),t&&e===t.scrollbar&&(t.scrollbar=null,destroyObjectProperties$3(t.scrollbarButtons))},n.prototype.drawScrollbarButton=function(e){var t=this,r=t.renderer,o=t.scrollbarButtons,s=t.options,a=t.size,l=r.g().add(t.group),h;o.push(l),h=r.rect().addClass("highcharts-scrollbar-button").add(l),t.chart.styledMode||h.attr({stroke:s.buttonBorderColor,"stroke-width":s.buttonBorderWidth,fill:s.buttonBackgroundColor}),h.attr(h.crisp({x:-.5,y:-.5,width:a+1,height:a+1,r:s.buttonBorderRadius},h.strokeWidth())),h=r.path(n.swapXY([["M",a/2+(e?-1:1),a/2-3],["L",a/2+(e?-1:1),a/2+3],["L",a/2+(e?2:-2),a/2]],s.vertical)).addClass("highcharts-scrollbar-arrow").add(o[e]),t.chart.styledMode||h.attr({fill:s.buttonArrowColor})},n.prototype.init=function(e,t,r){var o=this;o.scrollbarButtons=[],o.renderer=e,o.userOptions=t,o.options=merge$S(ScrollbarDefaults,defaultOptions$7.scrollbar,t),o.chart=r,o.size=pick$Z(o.options.size,o.options.height),t.enabled&&(o.render(),o.addEvents())},n.prototype.mouseDownHandler=function(e){var t=this,r=t.chart.pointer.normalize(e),o=t.cursorToScrollbarPosition(r);t.chartX=o.chartX,t.chartY=o.chartY,t.initPositions=[t.from,t.to],t.grabbedCenter=!0},n.prototype.mouseMoveHandler=function(e){var t=this,r=t.chart.pointer.normalize(e),o=t.options,s=o.vertical?"chartY":"chartX",a=t.initPositions||[],l,h,d;t.grabbedCenter&&(!e.touches||e.touches[0][s]!==0)&&(h=t.cursorToScrollbarPosition(r)[s],l=t[s],d=h-l,t.hasDragged=!0,t.updatePosition(a[0]+d,a[1]+d),t.hasDragged&&fireEvent$k(t,"changed",{from:t.from,to:t.to,trigger:"scrollbar",DOMType:e.type,DOMEvent:e}))},n.prototype.mouseUpHandler=function(e){var t=this;t.hasDragged&&fireEvent$k(t,"changed",{from:t.from,to:t.to,trigger:"scrollbar",DOMType:e.type,DOMEvent:e}),t.grabbedCenter=t.hasDragged=t.chartX=t.chartY=null},n.prototype.position=function(e,t,r,o){var s=this,a=s.options,l=a.vertical,h=s.rendered?"animate":"attr",d=o,c=0;s.x=e,s.y=t+this.trackBorderWidth,s.width=r,s.height=o,s.xOffset=d,s.yOffset=c,l?(s.width=s.yOffset=r=c=s.size,s.xOffset=d=0,s.barWidth=o-r*2,s.x=e=e+s.options.margin):(s.height=s.xOffset=o=d=s.size,s.barWidth=r-o*2,s.y=s.y+s.options.margin),s.group[h]({translateX:e,translateY:s.y}),s.track[h]({width:r,height:o}),s.scrollbarButtons[1][h]({translateX:l?0:r-d,translateY:l?o-c:0})},n.prototype.removeEvents=function(){this._events.forEach(function(e){removeEvent$4.apply(null,e)}),this._events.length=0},n.prototype.render=function(){var e=this,t=e.renderer,r=e.options,o=e.size,s=e.chart.styledMode,a=t.g("scrollbar").attr({zIndex:r.zIndex,translateY:-99999}).add();e.group=a,e.track=t.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:r.trackBorderRadius||0,height:o,width:o}).add(a),s||e.track.attr({fill:r.trackBackgroundColor,stroke:r.trackBorderColor,"stroke-width":r.trackBorderWidth}),e.trackBorderWidth=e.track.strokeWidth(),e.track.attr({y:-this.trackBorderWidth%2/2}),e.scrollbarGroup=t.g().add(a),e.scrollbar=t.rect().addClass("highcharts-scrollbar-thumb").attr({height:o,width:o,r:r.barBorderRadius||0}).add(e.scrollbarGroup),e.scrollbarRifles=t.path(n.swapXY([["M",-3,o/4],["L",-3,2*o/3],["M",0,o/4],["L",0,2*o/3],["M",3,o/4],["L",3,2*o/3]],r.vertical)).addClass("highcharts-scrollbar-rifles").add(e.scrollbarGroup),s||(e.scrollbar.attr({fill:r.barBackgroundColor,stroke:r.barBorderColor,"stroke-width":r.barBorderWidth}),e.scrollbarRifles.attr({stroke:r.rifleColor,"stroke-width":1})),e.scrollbarStrokeWidth=e.scrollbar.strokeWidth(),e.scrollbarGroup.translate(-e.scrollbarStrokeWidth%2/2,-e.scrollbarStrokeWidth%2/2),e.drawScrollbarButton(0),e.drawScrollbarButton(1)},n.prototype.setRange=function(e,t){var r=this,o=r.options,s=o.vertical,a=o.minWidth,l=r.barWidth,h=this.rendered&&!this.hasDragged&&!(this.chart.navigator&&this.chart.navigator.hasDragged)?"animate":"attr";if(defined$u(l)){var d=l*Math.min(t,1),c,p;e=Math.max(e,0),c=Math.ceil(l*e),r.calculatedWidth=p=correctFloat$6(d-c),p<a&&(c=(l-a+p)*e,p=a);var f=Math.floor(c+r.xOffset+r.yOffset),u=p/2-.5;r.from=e,r.to=t,s?(r.scrollbarGroup[h]({translateY:f}),r.scrollbar[h]({height:p}),r.scrollbarRifles[h]({translateY:u}),r.scrollbarTop=f,r.scrollbarLeft=0):(r.scrollbarGroup[h]({translateX:f}),r.scrollbar[h]({width:p}),r.scrollbarRifles[h]({translateX:u}),r.scrollbarLeft=f,r.scrollbarTop=0),p<=12?r.scrollbarRifles.hide():r.scrollbarRifles.show(!0),o.showFull===!1&&(e<=0&&t>=1?r.group.hide():r.group.show()),r.rendered=!0}},n.prototype.shouldUpdateExtremes=function(e){return pick$Z(this.options.liveRedraw,H.svg&&!H.isTouchDevice&&!this.chart.isBoosting)||e==="mouseup"||e==="touchend"||!defined$u(e)},n.prototype.trackClick=function(e){var t=this,r=t.chart.pointer.normalize(e),o=t.to-t.from,s=t.y+t.scrollbarTop,a=t.x+t.scrollbarLeft;t.options.vertical&&r.chartY>s||!t.options.vertical&&r.chartX>a?t.updatePosition(t.from+o,t.to+o):t.updatePosition(t.from-o,t.to-o),fireEvent$k(t,"changed",{from:t.from,to:t.to,trigger:"scrollbar",DOMEvent:e})},n.prototype.update=function(e){this.destroy(),this.init(this.chart.renderer,merge$S(!0,this.options,e),this.chart)},n.prototype.updatePosition=function(e,t){t>1&&(e=correctFloat$6(1-correctFloat$6(t-e)),t=1),e<0&&(t=correctFloat$6(t-e),e=0),this.from=e,this.to=t},n.defaultOptions=ScrollbarDefaults,n}();defaultOptions$7.scrollbar=merge$S(!0,Scrollbar.defaultOptions,defaultOptions$7.scrollbar);var isTouchDevice$2=H.isTouchDevice,addEvent$G=Utilities.addEvent,correctFloat$5=Utilities.correctFloat,defined$t=Utilities.defined,isNumber$q=Utilities.isNumber,pick$Y=Utilities.pick,NavigatorAxisAdditions=function(){function n(e){this.axis=e}return n.prototype.destroy=function(){this.axis=void 0},n.prototype.toFixedRange=function(e,t,r,o){var s=this,a=s.axis,l=a.chart,h=l&&l.fixedRange,d=(a.pointRange||0)/2,c=pick$Y(r,a.translate(e,!0,!a.horiz)),p=pick$Y(o,a.translate(t,!0,!a.horiz)),f=h&&(p-c)/h;return defined$t(r)||(c=correctFloat$5(c+d)),defined$t(o)||(p=correctFloat$5(p-d)),f>.7&&f<1.3&&(o?c=p-h:p=c+h),(!isNumber$q(c)||!isNumber$q(p))&&(c=p=void 0),{min:c,max:p}},n}(),NavigatorAxis=function(){function n(){}return n.compose=function(e){e.keepProps.push("navigatorAxis"),addEvent$G(e,"init",function(){var t=this;t.navigatorAxis||(t.navigatorAxis=new NavigatorAxisAdditions(t))}),addEvent$G(e,"zoom",function(t){var r=this,o=r.chart,s=o.options,a=s.navigator,l=r.navigatorAxis,h=s.chart.pinchType,d=s.rangeSelector,c=s.chart.zoomType,p;r.isXAxis&&(a&&a.enabled||d&&d.enabled)&&(c==="y"?t.zoomed=!1:(!isTouchDevice$2&&c==="xy"||isTouchDevice$2&&h==="xy")&&r.options.range&&(p=l.previousZoom,defined$t(t.newMin)?l.previousZoom=[r.min,r.max]:p&&(t.newMin=p[0],t.newMax=p[1],l.previousZoom=void 0))),typeof t.zoomed<"u"&&t.preventDefault()})},n.AdditionsClass=NavigatorAxisAdditions,n}(),color$b=Color.parse,hasTouch=H.hasTouch,isTouchDevice$1=H.isTouchDevice,defaultOptions$6=DefaultOptions.defaultOptions,seriesTypes$5=SeriesRegistry$1.seriesTypes,addEvent$F=Utilities.addEvent,clamp$a=Utilities.clamp,correctFloat$4=Utilities.correctFloat,defined$s=Utilities.defined,destroyObjectProperties$2=Utilities.destroyObjectProperties,erase$1=Utilities.erase,extend$$=Utilities.extend,find$c=Utilities.find,isArray$8=Utilities.isArray,isNumber$p=Utilities.isNumber,merge$R=Utilities.merge,pick$X=Utilities.pick,removeEvent$3=Utilities.removeEvent,splat$9=Utilities.splat,defaultSeriesType,numExt=function(n){for(var e=[],t=1;t<arguments.length;t++)e[t-1]=arguments[t];var r=[].filter.call(e,isNumber$p);if(r.length)return Math[n].apply(0,r)};defaultSeriesType=typeof seriesTypes$5.areaspline>"u"?"line":"areaspline";extend$$(defaultOptions$6,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:palette.neutralColor5,borderColor:palette.neutralColor40},maskFill:color$b(palette.highlightColor60).setOpacity(.3).get(),outlineColor:palette.neutralColor20,outlineWidth:1,series:{type:defaultSeriesType,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:palette.neutralColor10,gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:palette.neutralColor40},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});RendererRegistry$1.getRendererType().prototype.symbols["navigator-handle"]=function(n,e,t,r,o){var s=(o&&o.width||0)/2,a=Math.round(s/3)+.5,l=o&&o.height||0;return[["M",-s-1,.5],["L",s,.5],["L",s,l+.5],["L",-s-1,l+.5],["L",-s-1,.5],["M",-a,4],["L",-a,l-3],["M",a-1,4],["L",a-1,l-3]]};var Navigator=function(){function n(e){this.baseSeries=void 0,this.chart=void 0,this.handles=void 0,this.height=void 0,this.left=void 0,this.navigatorEnabled=void 0,this.navigatorGroup=void 0,this.navigatorOptions=void 0,this.navigatorSeries=void 0,this.navigatorSize=void 0,this.opposite=void 0,this.outline=void 0,this.outlineHeight=void 0,this.range=void 0,this.rendered=void 0,this.shades=void 0,this.size=void 0,this.top=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zoomedMax=void 0,this.zoomedMin=void 0,this.init(e)}return n.prototype.drawHandle=function(e,t,r,o){var s=this,a=s.navigatorOptions.handles.height;s.handles[t][o](r?{translateX:Math.round(s.left+s.height/2),translateY:Math.round(s.top+parseInt(e,10)+.5-a)}:{translateX:Math.round(s.left+parseInt(e,10)),translateY:Math.round(s.top+s.height/2-a/2-1)})},n.prototype.drawOutline=function(e,t,r,o){var s=this,a=s.navigatorOptions.maskInside,l=s.outline.strokeWidth(),h=l/2,d=l%2/2,c=s.outlineHeight,p=s.scrollbarHeight||0,f=s.size,u=s.left-p,g=s.top,m,y;r?(u-=h,m=g+t+d,t=g+e+d,y=[["M",u+c,g-p-d],["L",u+c,m],["L",u,m],["L",u,t],["L",u+c,t],["L",u+c,g+f+p]],a&&y.push(["M",u+c,m-h],["L",u+c,t+h])):(e+=u+p-d,t+=u+p-d,g+=h,y=[["M",u,g],["L",e,g],["L",e,g+c],["L",t,g+c],["L",t,g],["L",u+f+p*2,g]],a&&y.push(["M",e-h,g],["L",t+h,g])),s.outline[o]({d:y})},n.prototype.drawMasks=function(e,t,r,o){var s=this,a=s.left,l=s.top,h=s.height,d,c,p,f;r?(p=[a,a,a],f=[l,l+e,l+t],c=[h,h,h],d=[e,t-e,s.size-t]):(p=[a,a+e,a+t],f=[l,l,l],c=[e,t-e,s.size-t],d=[h,h,h]),s.shades.forEach(function(u,g){u[o]({x:p[g],y:f[g],width:c[g],height:d[g]})})},n.prototype.renderElements=function(){var e=this,t=e.navigatorOptions,r=t.maskInside,o=e.chart,s=o.inverted,a=o.renderer,l,h={cursor:s?"ns-resize":"ew-resize"};e.navigatorGroup=l=a.g("navigator").attr({zIndex:8,visibility:"hidden"}).add(),[!r,r,!r].forEach(function(d,c){e.shades[c]=a.rect().addClass("highcharts-navigator-mask"+(c===1?"-inside":"-outside")).add(l),o.styledMode||e.shades[c].attr({fill:d?t.maskFill:"rgba(0,0,0,0)"}).css(c===1&&h)}),e.outline=a.path().addClass("highcharts-navigator-outline").add(l),o.styledMode||e.outline.attr({"stroke-width":t.outlineWidth,stroke:t.outlineColor}),t.handles.enabled&&[0,1].forEach(function(d){if(t.handles.inverted=o.inverted,e.handles[d]=a.symbol(t.handles.symbols[d],-t.handles.width/2-1,0,t.handles.width,t.handles.height,t.handles),e.handles[d].attr({zIndex:7-d}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][d]).add(l),!o.styledMode){var c=t.handles;e.handles[d].attr({fill:c.backgroundColor,stroke:c.borderColor,"stroke-width":c.lineWidth}).css(h)}})},n.prototype.update=function(e){(this.series||[]).forEach(function(r){r.baseSeries&&delete r.baseSeries.navigatorSeries}),this.destroy();var t=this.chart.options;merge$R(!0,t.navigator,this.options,e),this.init(this.chart)},n.prototype.render=function(e,t,r,o){var s=this,a=s.chart,l,h,d,c=s.scrollbarHeight,p,f=s.xAxis,u=f.pointRange||0,g=f.navigatorAxis.fake?a.xAxis[0]:f,m=s.navigatorEnabled,y,v,x=s.rendered,b=a.inverted,$,S,k,A,M=a.xAxis[0].minRange,P=a.xAxis[0].options.maxRange;if(!(this.hasDragged&&!defined$s(r))){if(e=correctFloat$4(e-u/2),t=correctFloat$4(t+u/2),!isNumber$p(e)||!isNumber$p(t))if(x)r=0,o=pick$X(f.width,g.width);else return;s.left=pick$X(f.left,a.plotLeft+c+(b?a.plotWidth:0)),s.size=v=p=pick$X(f.len,(b?a.plotHeight:a.plotWidth)-2*c),b?l=c:l=p+2*c,r=pick$X(r,f.toPixels(e,!0)),o=pick$X(o,f.toPixels(t,!0)),(!isNumber$p(r)||Math.abs(r)===1/0)&&(r=0,o=l),S=f.toValue(r,!0),k=f.toValue(o,!0),A=Math.abs(correctFloat$4(k-S)),A<M?this.grabbedLeft?r=f.toPixels(k-M-u,!0):this.grabbedRight&&(o=f.toPixels(S+M+u,!0)):defined$s(P)&&correctFloat$4(A-u)>P&&(this.grabbedLeft?r=f.toPixels(k-P-u,!0):this.grabbedRight&&(o=f.toPixels(S+P+u,!0))),s.zoomedMax=clamp$a(Math.max(r,o),0,v),s.zoomedMin=clamp$a(s.fixedWidth?s.zoomedMax-s.fixedWidth:Math.min(r,o),0,v),s.range=s.zoomedMax-s.zoomedMin,v=Math.round(s.zoomedMax),y=Math.round(s.zoomedMin),m&&(s.navigatorGroup.attr({visibility:"visible"}),$=x&&!s.hasDragged?"animate":"attr",s.drawMasks(y,v,b,$),s.drawOutline(y,v,b,$),s.navigatorOptions.handles.enabled&&(s.drawHandle(y,0,b,$),s.drawHandle(v,1,b,$))),s.scrollbar&&(b?(d=s.top-c,h=s.left-c+(m||!g.opposite?0:(g.titleOffset||0)+g.axisTitleMargin),c=p+2*c):(d=s.top+(m?s.height:-c),h=s.left-c),s.scrollbar.position(h,d,l,c),s.scrollbar.setRange(s.zoomedMin/(p||1),s.zoomedMax/(p||1))),s.rendered=!0}},n.prototype.addMouseEvents=function(){var e=this,t=e.chart,r=t.container,o=[],s,a;e.mouseMoveHandler=s=function(l){e.onMouseMove(l)},e.mouseUpHandler=a=function(l){e.onMouseUp(l)},o=e.getPartsEvents("mousedown"),o.push(addEvent$F(t.renderTo,"mousemove",s),addEvent$F(r.ownerDocument,"mouseup",a)),hasTouch&&(o.push(addEvent$F(t.renderTo,"touchmove",s),addEvent$F(r.ownerDocument,"touchend",a)),o.concat(e.getPartsEvents("touchstart"))),e.eventsToUnbind=o,e.series&&e.series[0]&&o.push(addEvent$F(e.series[0].xAxis,"foundExtremes",function(){t.navigator.modifyNavigatorAxisExtremes()}))},n.prototype.getPartsEvents=function(e){var t=this,r=[];return["shades","handles"].forEach(function(o){t[o].forEach(function(s,a){r.push(addEvent$F(s.element,e,function(l){t[o+"Mousedown"](l,a)}))})}),r},n.prototype.shadesMousedown=function(e,t){e=this.chart.pointer.normalize(e);var r=this,o=r.chart,s=r.xAxis,a=r.zoomedMin,l=r.left,h=r.size,d=r.range,c=e.chartX,p,f,u,g;o.inverted&&(c=e.chartY,l=r.top),t===1?(r.grabbedCenter=c,r.fixedWidth=d,r.dragOffset=c-a):(g=c-l-d/2,t===0?g=Math.max(0,g):t===2&&g+d>=h&&(g=h-d,r.reversedExtremes?(g-=d,f=r.getUnionExtremes().dataMin):p=r.getUnionExtremes().dataMax),g!==a&&(r.fixedWidth=d,u=s.navigatorAxis.toFixedRange(g,g+d,f,p),defined$s(u.min)&&o.xAxis[0].setExtremes(Math.min(u.min,u.max),Math.max(u.min,u.max),!0,null,{trigger:"navigator"})))},n.prototype.handlesMousedown=function(e,t){e=this.chart.pointer.normalize(e);var r=this,o=r.chart,s=o.xAxis[0],a=r.reversedExtremes;t===0?(r.grabbedLeft=!0,r.otherHandlePos=r.zoomedMax,r.fixedExtreme=a?s.min:s.max):(r.grabbedRight=!0,r.otherHandlePos=r.zoomedMin,r.fixedExtreme=a?s.max:s.min),o.fixedRange=null},n.prototype.onMouseMove=function(e){var t=this,r=t.chart,o=t.left,s=t.navigatorSize,a=t.range,l=t.dragOffset,h=r.inverted,d;(!e.touches||e.touches[0].pageX!==0)&&(e=r.pointer.normalize(e),d=e.chartX,h&&(o=t.top,d=e.chartY),t.grabbedLeft?(t.hasDragged=!0,t.render(0,0,d-o,t.otherHandlePos)):t.grabbedRight?(t.hasDragged=!0,t.render(0,0,t.otherHandlePos,d-o)):t.grabbedCenter&&(t.hasDragged=!0,d<l?d=l:d>s+l-a&&(d=s+l-a),t.render(0,0,d-l,d-l+a)),t.hasDragged&&t.scrollbar&&pick$X(t.scrollbar.options.liveRedraw,H.svg&&!isTouchDevice$1&&!this.chart.isBoosting)&&(e.DOMType=e.type,setTimeout(function(){t.onMouseUp(e)},0)))},n.prototype.onMouseUp=function(e){var t=this,r=t.chart,o=t.xAxis,s=t.scrollbar,a=e.DOMEvent||e,l=r.inverted,h=t.rendered&&!t.hasDragged?"animate":"attr",d,c,p,f,u,g;(t.hasDragged&&(!s||!s.hasDragged)||e.trigger==="scrollbar")&&(p=t.getUnionExtremes(),t.zoomedMin===t.otherHandlePos?f=t.fixedExtreme:t.zoomedMax===t.otherHandlePos&&(u=t.fixedExtreme),t.zoomedMax===t.size&&(u=t.reversedExtremes?p.dataMin:p.dataMax),t.zoomedMin===0&&(f=t.reversedExtremes?p.dataMax:p.dataMin),g=o.navigatorAxis.toFixedRange(t.zoomedMin,t.zoomedMax,f,u),defined$s(g.min)&&r.xAxis[0].setExtremes(Math.min(g.min,g.max),Math.max(g.min,g.max),!0,t.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:a})),e.DOMType!=="mousemove"&&e.DOMType!=="touchmove"&&(t.grabbedLeft=t.grabbedRight=t.grabbedCenter=t.fixedWidth=t.fixedExtreme=t.otherHandlePos=t.hasDragged=t.dragOffset=null),t.navigatorEnabled&&isNumber$p(t.zoomedMin)&&isNumber$p(t.zoomedMax)&&(c=Math.round(t.zoomedMin),d=Math.round(t.zoomedMax),t.shades&&t.drawMasks(c,d,l,h),t.outline&&t.drawOutline(c,d,l,h),t.navigatorOptions.handles.enabled&&Object.keys(t.handles).length===t.handles.length&&(t.drawHandle(c,0,l,h),t.drawHandle(d,1,l,h)))},n.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(e){e()}),this.eventsToUnbind=void 0),this.removeBaseSeriesEvents()},n.prototype.removeBaseSeriesEvents=function(){var e=this.baseSeries||[];this.navigatorEnabled&&e[0]&&(this.navigatorOptions.adaptToUpdatedData!==!1&&e.forEach(function(t){removeEvent$3(t,"updatedData",this.updatedDataHandler)},this),e[0].xAxis&&removeEvent$3(e[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},n.prototype.init=function(e){var t=e.options,r=t.navigator,o=r.enabled,s=t.scrollbar,a=s.enabled,l=o?r.height:0,h=a?s.height:0;this.handles=[],this.shades=[],this.chart=e,this.setBaseSeries(),this.height=l,this.scrollbarHeight=h,this.scrollbarEnabled=a,this.navigatorEnabled=o,this.navigatorOptions=r,this.scrollbarOptions=s,this.outlineHeight=l+h,this.opposite=pick$X(r.opposite,!!(!o&&e.inverted));var d=this,c=d.baseSeries,p=e.xAxis.length,f=e.yAxis.length,u=c&&c[0]&&c[0].xAxis||e.xAxis[0]||{options:{}};e.isDirtyBox=!0,d.navigatorEnabled?(d.xAxis=new Axis(e,merge$R({breaks:u.options.breaks,ordinal:u.options.ordinal},r.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:p,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},e.inverted?{offsets:[h,0,-h,0],width:l}:{offsets:[0,-h,0,h],height:l})),d.yAxis=new Axis(e,merge$R(r.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:f,isInternal:!0,reversed:pick$X(r.yAxis&&r.yAxis.reversed,e.yAxis[0]&&e.yAxis[0].reversed,!1),zoomEnabled:!1},e.inverted?{width:l}:{height:l})),c||r.series.data?d.updateNavigatorSeries(!1):e.series.length===0&&(d.unbindRedraw=addEvent$F(e,"beforeRedraw",function(){e.series.length>0&&!d.series&&(d.setBaseSeries(),d.unbindRedraw())})),d.reversedExtremes=e.inverted&&!d.xAxis.reversed||!e.inverted&&d.xAxis.reversed,d.renderElements(),d.addMouseEvents()):(d.xAxis={chart:e,navigatorAxis:{fake:!0},translate:function(g,m){var y=e.xAxis[0],v=y.getExtremes(),x=y.len-2*h,b=numExt("min",y.options.min,v.dataMin),$=numExt("max",y.options.max,v.dataMax)-b;return m?g*$/x+b:x*(g-b)/$},toPixels:function(g){return this.translate(g)},toValue:function(g){return this.translate(g,!0)}},d.xAxis.navigatorAxis.axis=d.xAxis,d.xAxis.navigatorAxis.toFixedRange=NavigatorAxis.AdditionsClass.prototype.toFixedRange.bind(d.xAxis.navigatorAxis)),e.options.scrollbar.enabled&&(e.scrollbar=d.scrollbar=new Scrollbar(e.renderer,merge$R(e.options.scrollbar,{margin:d.navigatorEnabled?0:10,vertical:e.inverted}),e),addEvent$F(d.scrollbar,"changed",function(g){var m=d.size,y=m*this.to,v=m*this.from;d.hasDragged=d.scrollbar.hasDragged,d.render(0,0,v,y),this.shouldUpdateExtremes(g.DOMType)&&setTimeout(function(){d.onMouseUp(g)})})),d.addBaseSeriesEvents(),d.addChartEvents()},n.prototype.getUnionExtremes=function(e){var t=this.chart.xAxis[0],r=this.xAxis,o=r.options,s=t.options,a;return(!e||t.dataMin!==null)&&(a={dataMin:pick$X(o&&o.min,numExt("min",s.min,t.dataMin,r.dataMin,r.min)),dataMax:pick$X(o&&o.max,numExt("max",s.max,t.dataMax,r.dataMax,r.max))}),a},n.prototype.setBaseSeries=function(e,t){var r=this.chart,o=this.baseSeries=[];e=e||r.options&&r.options.navigator.baseSeries||(r.series.length?find$c(r.series,function(s){return!s.options.isInternal}).index:0),(r.series||[]).forEach(function(s,a){!s.options.isInternal&&(s.options.showInNavigator||(a===e||s.options.id===e)&&s.options.showInNavigator!==!1)&&o.push(s)}),this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,t)},n.prototype.updateNavigatorSeries=function(e,t){var r=this,o=r.chart,s=r.baseSeries,a,l,h=r.navigatorOptions.series,d,c={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},p=r.series=(r.series||[]).filter(function(f){var u=f.baseSeries;return s.indexOf(u)<0?(u&&(removeEvent$3(u,"updatedData",r.updatedDataHandler),delete u.navigatorSeries),f.chart&&f.destroy(),!1):!0});s&&s.length&&s.forEach(function(u){var g=u.navigatorSeries,m=extend$$({color:u.color,visible:u.visible},isArray$8(h)?defaultOptions$6.navigator.series:h);if(!(g&&r.navigatorOptions.adaptToUpdatedData===!1)){c.name="Navigator "+s.length,a=u.options||{},d=a.navigatorOptions||{},m.dataLabels=splat$9(m.dataLabels),l=merge$R(a,c,m,d),l.pointRange=pick$X(m.pointRange,d.pointRange,defaultOptions$6.plotOptions[l.type||"line"].pointRange);var y=d.data||m.data;r.hasNavigatorData=r.hasNavigatorData||!!y,l.data=y||a.data&&a.data.slice(0),g&&g.options?g.update(l,t):(u.navigatorSeries=o.initSeries(l),u.navigatorSeries.baseSeries=u,p.push(u.navigatorSeries))}}),(h.data&&!(s&&s.length)||isArray$8(h))&&(r.hasNavigatorData=!1,h=splat$9(h),h.forEach(function(f,u){c.name="Navigator "+(p.length+1),l=merge$R(defaultOptions$6.navigator.series,{color:o.series[u]&&!o.series[u].options.isInternal&&o.series[u].color||o.options.colors[u]||o.options.colors[0]},c,f),l.data=f.data,l.data&&(r.hasNavigatorData=!0,p.push(o.initSeries(l)))})),e&&this.addBaseSeriesEvents()},n.prototype.addBaseSeriesEvents=function(){var e=this,t=e.baseSeries||[];t[0]&&t[0].xAxis&&t[0].eventsToUnbind.push(addEvent$F(t[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes)),t.forEach(function(r){r.eventsToUnbind.push(addEvent$F(r,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)})),r.eventsToUnbind.push(addEvent$F(r,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)})),this.navigatorOptions.adaptToUpdatedData!==!1&&r.xAxis&&r.eventsToUnbind.push(addEvent$F(r,"updatedData",this.updatedDataHandler)),r.eventsToUnbind.push(addEvent$F(r,"remove",function(){this.navigatorSeries&&(erase$1(e.series,this.navigatorSeries),defined$s(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))},this)},n.prototype.getBaseSeriesMin=function(e){return this.baseSeries.reduce(function(t,r){return Math.min(t,r.xData?r.xData[0]:t)},e)},n.prototype.modifyNavigatorAxisExtremes=function(){var e=this.xAxis,t;typeof e.getExtremes<"u"&&(t=this.getUnionExtremes(!0),t&&(t.dataMin!==e.min||t.dataMax!==e.max)&&(e.min=t.dataMin,e.max=t.dataMax))},n.prototype.modifyBaseAxisExtremes=function(){var e=this,t=e.chart.navigator,r=e.getExtremes(),o=r.min,s=r.max,a=r.dataMin,l=r.dataMax,h=s-o,d=t.stickToMin,c=t.stickToMax,p=pick$X(e.options.overscroll,0),f,u,g=t.series&&t.series[0],m=!!e.setExtremes,y=e.eventArgs&&e.eventArgs.trigger==="rangeSelectorButton";y||(d&&(u=a,f=u+h),c&&(f=l+p,d||(u=Math.max(a,f-h,t.getBaseSeriesMin(g&&g.xData?g.xData[0]:-Number.MAX_VALUE)))),m&&(d||c)&&isNumber$p(u)&&(e.min=e.userMin=u,e.max=e.userMax=f)),t.stickToMin=t.stickToMax=null},n.prototype.updatedDataHandler=function(){var e=this.chart.navigator,t=this,r=this.navigatorSeries;e.stickToMax=e.reversedExtremes?Math.round(e.zoomedMin)===0:Math.round(e.zoomedMax)>=Math.round(e.size),e.stickToMin=e.shouldStickToMin(t,e),r&&!e.hasNavigatorData&&(r.options.pointStart=t.xData[0],r.setData(t.options.data,!1,null,!1))},n.prototype.shouldStickToMin=function(e,t){var r=t.getBaseSeriesMin(e.xData[0]),o=e.xAxis,s=o.max,a=o.min,l=o.options.range,h=!0;return isNumber$p(s)&&isNumber$p(a)?l&&s-r>0?h=s-r<l&&!this.chart.fixedRange:h=a<=r:h=!1,h},n.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]),this.eventsToUnbind.push(addEvent$F(this.chart,"redraw",function(){var e=this.navigator,t=e&&(e.baseSeries&&e.baseSeries[0]&&e.baseSeries[0].xAxis||this.xAxis[0]);t&&e.render(t.min,t.max)}),addEvent$F(this.chart,"getMargins",function(){var e=this,t=e.navigator,r=t.opposite?"plotTop":"marginBottom";e.inverted&&(r=t.opposite?"marginRight":"plotLeft"),e[r]=(e[r]||0)+(t.navigatorEnabled||!e.inverted?t.outlineHeight:0)+t.navigatorOptions.margin}))},n.prototype.destroy=function(){this.removeEvents(),this.xAxis&&(erase$1(this.chart.xAxis,this.xAxis),erase$1(this.chart.axes,this.xAxis)),this.yAxis&&(erase$1(this.chart.yAxis,this.yAxis),erase$1(this.chart.axes,this.yAxis)),(this.series||[]).forEach(function(e){e.destroy&&e.destroy()}),["series","xAxis","yAxis","shades","outline","scrollbarTrack","scrollbarRifles","scrollbarGroup","scrollbar","navigatorGroup","rendered"].forEach(function(e){this[e]&&this[e].destroy&&this[e].destroy(),this[e]=null},this),[this.handles].forEach(function(e){destroyObjectProperties$2(e)},this)},n}();H.Navigator||(H.Navigator=Navigator,NavigatorAxis.compose(Axis),addEvent$F(Chart$1,"beforeShowResetZoom",function(){var n=this.options,e=n.navigator,t=n.rangeSelector;if((e&&e.enabled||t&&t.enabled)&&(!isTouchDevice$1&&n.chart.zoomType==="x"||isTouchDevice$1&&n.chart.pinchType==="x"))return!1}),addEvent$F(Chart$1,"beforeRender",function(){var n=this.options;(n.navigator.enabled||n.scrollbar.enabled)&&(this.scroller=this.navigator=new Navigator(this))}),addEvent$F(Chart$1,"afterSetChartSize",function(){var n=this.legend,e=this.navigator,t,r,o,s;e&&(r=n&&n.options,o=e.xAxis,s=e.yAxis,t=e.scrollbarHeight,this.inverted?(e.left=e.opposite?this.chartWidth-t-e.height:this.spacing[3]+t,e.top=this.plotTop+t):(e.left=pick$X(o.left,this.plotLeft+t),e.top=e.navigatorOptions.top||this.chartHeight-e.height-t-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(r&&r.verticalAlign==="bottom"&&r.layout!=="proximate"&&r.enabled&&!r.floating?n.legendHeight+pick$X(r.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0)),o&&s&&(this.inverted?o.options.left=s.options.left=e.left:o.options.top=s.options.top=e.top,o.setAxisSize(),s.setAxisSize()))}),addEvent$F(Chart$1,"update",function(n){var e=n.options.navigator||{},t=n.options.scrollbar||{};!this.navigator&&!this.scroller&&(e.enabled||t.enabled)&&(merge$R(!0,this.options.navigator,e),merge$R(!0,this.options.scrollbar,t),delete n.options.navigator,delete n.options.scrollbar)}),addEvent$F(Chart$1,"afterUpdate",function(n){!this.navigator&&!this.scroller&&(this.options.navigator.enabled||this.options.scrollbar.enabled)&&(this.scroller=this.navigator=new Navigator(this),pick$X(n.redraw,!0)&&this.redraw(n.animation))}),addEvent$F(Chart$1,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),addEvent$F(Series$e,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}),Chart$1.prototype.callbacks.push(function(n){var e,t=n.navigator;t&&n.xAxis[0]&&(e=n.xAxis[0].getExtremes(),t.render(e.min,e.max))}));H.Navigator=Navigator;H.Navigator;var defaultOptions$5=DefaultOptions.defaultOptions,addEvent$E=Utilities.addEvent,createElement$3=Utilities.createElement,css$2=Utilities.css,defined$r=Utilities.defined,destroyObjectProperties$1=Utilities.destroyObjectProperties,discardElement$2=Utilities.discardElement,extend$_=Utilities.extend,find$b=Utilities.find,fireEvent$j=Utilities.fireEvent,isNumber$o=Utilities.isNumber,merge$Q=Utilities.merge,objectEach$d=Utilities.objectEach,pad=Utilities.pad,pick$W=Utilities.pick,pInt$3=Utilities.pInt,splat$8=Utilities.splat;extend$_(defaultOptions$5,{rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%b %e, %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:palette.highlightColor80,cursor:"pointer"},labelStyle:{color:palette.neutralColor60}}});extend$_(defaultOptions$5.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"→"});var RangeSelector=function(){function n(e){this.buttons=void 0,this.buttonOptions=n.prototype.defaultButtons,this.initialButtonGroupWidth=0,this.options=void 0,this.chart=e,this.init(e)}return n.prototype.clickButton=function(e,t){var r=this,o=r.chart,s=r.buttonOptions[e],a=o.xAxis[0],l=o.scroller&&o.scroller.getUnionExtremes()||a||{},h=l.dataMin,d=l.dataMax,c,p=a&&Math.round(Math.min(a.max,pick$W(d,a.max))),f=s.type,u,g=s._range,m,y,v,x,b,$=s.dataGrouping;if(!(h===null||d===null)){if(o.fixedRange=g,r.setSelected(e),$&&(this.forcedDataGrouping=!0,Axis.prototype.setDataGrouping.call(a||{chart:this.chart},$,!1),this.frozenStates=s.preserveDataGrouping),f==="month"||f==="year")a?(x={range:s,max:p,chart:o,dataMin:h,dataMax:d},c=a.minFromRange.call(x),isNumber$o(x.newMax)&&(p=x.newMax)):g=s;else if(g)c=Math.max(p-g,h),p=Math.min(c+g,d);else if(f==="ytd")if(a)typeof d>"u"&&(h=Number.MAX_VALUE,d=Number.MIN_VALUE,o.series.forEach(function(S){var k=S.xData;h=Math.min(k[0],h),d=Math.max(k[k.length-1],d)}),t=!1),b=r.getYTDExtremes(d,h,o.time.useUTC),c=m=b.min,p=b.max;else{r.deferredYTDClick=e;return}else f==="all"&&a&&(o.navigator&&o.navigator.baseSeries[0]&&(o.navigator.baseSeries[0].xAxis.options.range=void 0),c=h,p=d);defined$r(c)&&(c+=s._offsetMin),defined$r(p)&&(p+=s._offsetMax),this.dropdown&&(this.dropdown.selectedIndex=e+1),a?a.setExtremes(c,p,pick$W(t,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:s}):(u=splat$8(o.options.xAxis)[0],v=u.range,u.range=g,y=u.min,u.min=m,addEvent$E(o,"load",function(){u.range=v,u.min=y})),fireEvent$j(this,"afterBtnClick")}},n.prototype.setSelected=function(e){this.selected=this.options.selected=e},n.prototype.init=function(e){var t=this,r=e.options.rangeSelector,o=r.buttons||t.defaultButtons.slice(),s=r.selected,a=function(){var l=t.minInput,h=t.maxInput;l&&l.blur&&fireEvent$j(l,"blur"),h&&h.blur&&fireEvent$j(h,"blur")};t.chart=e,t.options=r,t.buttons=[],t.buttonOptions=o,this.eventsToUnbind=[],this.eventsToUnbind.push(addEvent$E(e.container,"mousedown",a)),this.eventsToUnbind.push(addEvent$E(e,"resize",a)),o.forEach(t.computeButtonRange),typeof s<"u"&&o[s]&&this.clickButton(s,!1),this.eventsToUnbind.push(addEvent$E(e,"load",function(){e.xAxis&&e.xAxis[0]&&addEvent$E(e.xAxis[0],"setExtremes",function(l){this.max-this.min!==e.fixedRange&&l.trigger!=="rangeSelectorButton"&&l.trigger!=="updatedData"&&t.forcedDataGrouping&&!t.frozenStates&&this.setDataGrouping(!1,!1)})}))},n.prototype.updateButtonStates=function(){var e=this,t=this.chart,r=this.dropdown,o=t.xAxis[0],s=Math.round(o.max-o.min),a=!o.hasVisibleSeries,l=24*36e5,h=t.scroller&&t.scroller.getUnionExtremes()||o,d=h.dataMin,c=h.dataMax,p=e.getYTDExtremes(c,d,t.time.useUTC),f=p.min,u=p.max,g=e.selected,m=isNumber$o(g),y=e.options.allButtonsEnabled,v=e.buttons;e.buttonOptions.forEach(function(x,b){var $=x._range,S=x.type,k=x.count||1,A=v[b],M=0,P,E,T=x._offsetMax-x._offsetMin,O=b===g,C=$>c-d,I=$<o.minRange,L=!1,D=!1,N=$===s;(S==="month"||S==="year")&&s+36e5>={month:28,year:365}[S]*l*k-T&&s-36e5<={month:31,year:366}[S]*l*k+T?N=!0:S==="ytd"?(N=u-f+T===s,L=!O):S==="all"&&(N=o.max-o.min>=c-d,D=!O&&m&&N),P=!y&&(C||I||D||a),E=O&&N||N&&!m&&!L||O&&e.frozenStates,P?M=3:E&&(m=!0,M=2),A.state!==M&&(A.setState(M),r&&(r.options[b+1].disabled=P,M===2&&(r.selectedIndex=b+1)),M===0&&g===b&&e.setSelected())})},n.prototype.computeButtonRange=function(e){var t=e.type,r=e.count||1,o={millisecond:1,second:1e3,minute:60*1e3,hour:3600*1e3,day:24*3600*1e3,week:7*24*3600*1e3};o[t]?e._range=o[t]*r:(t==="month"||t==="year")&&(e._range={month:30,year:365}[t]*24*36e5*r),e._offsetMin=pick$W(e.offsetMin,0),e._offsetMax=pick$W(e.offsetMax,0),e._range+=e._offsetMax-e._offsetMin},n.prototype.getInputValue=function(e){var t=e==="min"?this.minInput:this.maxInput,r=this.chart.options.rangeSelector,o=this.chart.time;return t?(t.type==="text"&&r.inputDateParser||this.defaultInputDateParser)(t.value,o.useUTC,o):0},n.prototype.setInputValue=function(e,t){var r=this.options,o=this.chart.time,s=e==="min"?this.minInput:this.maxInput,a=e==="min"?this.minDateBox:this.maxDateBox;if(s){var l=s.getAttribute("data-hc-time"),h=defined$r(l)?Number(l):void 0;if(defined$r(t)){var d=h;defined$r(d)&&s.setAttribute("data-hc-time-previous",d),s.setAttribute("data-hc-time",t),h=t}s.value=o.dateFormat(this.inputTypeFormats[s.type]||r.inputEditDateFormat,h),a&&a.attr({text:o.dateFormat(r.inputDateFormat,h)})}},n.prototype.setInputExtremes=function(e,t,r){var o=e==="min"?this.minInput:this.maxInput;if(o){var s=this.inputTypeFormats[o.type],a=this.chart.time;if(s){var l=a.dateFormat(s,t);o.min!==l&&(o.min=l);var h=a.dateFormat(s,r);o.max!==h&&(o.max=h)}}},n.prototype.showInput=function(e){var t=e==="min"?this.minDateBox:this.maxDateBox,r=e==="min"?this.minInput:this.maxInput;if(r&&t&&this.inputGroup){var o=r.type==="text",s=this.inputGroup,a=s.translateX,l=s.translateY,h=this.options.inputBoxWidth;css$2(r,{width:o?t.width+(h?-2:20)+"px":"auto",height:o?t.height-2+"px":"auto",border:"2px solid silver"}),o&&h?css$2(r,{left:a+t.x+"px",top:l+"px"}):css$2(r,{left:Math.min(Math.round(t.x+a-(r.offsetWidth-t.width)/2),this.chart.chartWidth-r.offsetWidth)+"px",top:l-(r.offsetHeight-t.height)/2+"px"})}},n.prototype.hideInput=function(e){var t=e==="min"?this.minInput:this.maxInput;t&&css$2(t,{top:"-9999em",border:0,width:"1px",height:"1px"})},n.prototype.defaultInputDateParser=function(e,t,r){var o=function(d){return d.length>6&&(d.lastIndexOf("-")===d.length-6||d.lastIndexOf("+")===d.length-6)},s=e.split("/").join("-").split(" ").join("T");if(s.indexOf("T")===-1&&(s+="T00:00"),t)s+="Z";else if(H.isSafari&&!o(s)){var a=new Date(s).getTimezoneOffset()/60;s+=a<=0?"+"+pad(-a)+":00":"-"+pad(a)+":00"}var l=Date.parse(s);if(!isNumber$o(l)){var h=e.split("-");l=Date.UTC(pInt$3(h[0]),pInt$3(h[1])-1,pInt$3(h[2]))}return r&&t&&isNumber$o(l)&&(l+=r.getTimezoneOffset(l)),l},n.prototype.drawInput=function(e){var t=this,r=t.chart,o=t.div,s=t.inputGroup,a=this,l=r.renderer.style||{},h=r.renderer,d=r.options.rangeSelector,c=defaultOptions$5.lang,p=e==="min";function f(){var x=a.getInputValue(e),b=r.xAxis[0],$=r.scroller&&r.scroller.xAxis?r.scroller.xAxis:b,S=$.dataMin,k=$.dataMax,A=a.maxInput,M=a.minInput;x!==Number(y.getAttribute("data-hc-time-previous"))&&isNumber$o(x)&&(y.setAttribute("data-hc-time-previous",x),p&&A&&isNumber$o(S)?x>Number(A.getAttribute("data-hc-time"))?x=void 0:x<S&&(x=S):M&&isNumber$o(k)&&(x<Number(M.getAttribute("data-hc-time"))?x=void 0:x>k&&(x=k)),typeof x<"u"&&b.setExtremes(p?x:b.min,p?b.max:x,void 0,void 0,{trigger:"rangeSelectorInput"}))}var u=c[p?"rangeSelectorFrom":"rangeSelectorTo"]||"",g=h.label(u,0).addClass("highcharts-range-label").attr({padding:u?2:0,height:u?d.inputBoxHeight:0}).add(s),m=h.label("",0).addClass("highcharts-range-input").attr({padding:2,width:d.inputBoxWidth,height:d.inputBoxHeight,"text-align":"center"}).on("click",function(){a.showInput(e),a[e+"Input"].focus()});r.styledMode||m.attr({stroke:d.inputBoxBorderColor,"stroke-width":1}),m.add(s);var y=createElement$3("input",{name:e,className:"highcharts-range-selector"},void 0,o);y.setAttribute("type",preferredInputType(d.inputDateFormat||"%b %e, %Y")),r.styledMode||(g.css(merge$Q(l,d.labelStyle)),m.css(merge$Q({color:palette.neutralColor80},l,d.inputStyle)),css$2(y,extend$_({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:l.fontSize,fontFamily:l.fontFamily,top:"-9999em"},d.inputStyle))),y.onfocus=function(){a.showInput(e)},y.onblur=function(){y===H.doc.activeElement&&f(),a.hideInput(e),a.setInputValue(e),y.blur()};var v=!1;return y.onchange=function(){v||(f(),a.hideInput(e),y.blur())},y.onkeypress=function(x){x.keyCode===13&&f()},y.onkeydown=function(x){v=!0,(x.keyCode===38||x.keyCode===40)&&f()},y.onkeyup=function(){v=!1},{dateBox:m,input:y,label:g}},n.prototype.getPosition=function(){var e=this.chart,t=e.options.rangeSelector,r=t.verticalAlign==="top"?e.plotTop-e.axisOffset[0]:0;return{buttonTop:r+t.buttonPosition.y,inputTop:r+t.inputPosition.y-10}},n.prototype.getYTDExtremes=function(e,t,r){var o=this.chart.time,s,a=new o.Date(e),l=o.get("FullYear",a),h=r?o.Date.UTC(l,0,1):+new o.Date(l,0,1);s=Math.max(t,h);var d=a.getTime();return{max:Math.min(e||d,d),min:s}},n.prototype.render=function(e,t){var r=this.chart,o=r.renderer,s=r.container,a=r.options,l=a.rangeSelector,h=pick$W(a.chart.style&&a.chart.style.zIndex,0)+1,d=l.inputEnabled,c=this.rendered;if(l.enabled!==!1){if(!c&&(this.group=o.g("range-selector-group").attr({zIndex:7}).add(),this.div=createElement$3("div",void 0,{position:"relative",height:0,zIndex:h}),this.buttonOptions.length&&this.renderButtons(),s.parentNode&&s.parentNode.insertBefore(this.div,s),d)){this.inputGroup=o.g("input-group").add(this.group);var p=this.drawInput("min");this.minDateBox=p.dateBox,this.minLabel=p.label,this.minInput=p.input;var f=this.drawInput("max");this.maxDateBox=f.dateBox,this.maxLabel=f.label,this.maxInput=f.input}if(d){this.setInputValue("min",e),this.setInputValue("max",t);var u=r.scroller&&r.scroller.getUnionExtremes()||r.xAxis[0]||{};if(defined$r(u.dataMin)&&defined$r(u.dataMax)){var g=r.xAxis[0].minRange||0;this.setInputExtremes("min",u.dataMin,Math.min(u.dataMax,this.getInputValue("max"))-g),this.setInputExtremes("max",Math.max(u.dataMin,this.getInputValue("min"))+g,u.dataMax)}if(this.inputGroup){var m=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(y){if(y){var v=y.getBBox().width;v&&(y.attr({x:m}),m+=v+l.inputSpacing)}})}}this.alignElements(),this.rendered=!0}},n.prototype.renderButtons=function(){var e=this,t=this,r=t.buttons,o=t.chart,s=t.options,a=defaultOptions$5.lang,l=o.renderer,h=merge$Q(s.buttonTheme),d=h&&h.states,c=h.width||28;delete h.width,delete h.states,this.buttonGroup=l.g("range-selector-buttons").add(this.group);var p=this.dropdown=createElement$3("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:1e-4},this.div);addEvent$E(p,"touchstart",function(){p.style.fontSize="16px"}),[[H.isMS?"mouseover":"mouseenter"],[H.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(f){var u=f[0],g=f[1];addEvent$E(p,u,function(){var m=r[e.currentButtonIndex()];m&&fireEvent$j(m.element,g||u)})}),this.zoomText=l.label(a&&a.rangeSelectorZoom||"",0).attr({padding:s.buttonTheme.padding,height:s.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup),this.chart.styledMode||(this.zoomText.css(s.labelStyle),h["stroke-width"]=pick$W(h["stroke-width"],0)),createElement$3("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,p),this.buttonOptions.forEach(function(f,u){createElement$3("option",{textContent:f.title||f.text},void 0,p),r[u]=l.button(f.text,0,0,function(g){var m=f.events&&f.events.click,y;m&&(y=m.call(f,g)),y!==!1&&e.clickButton(u),e.isActive=!0},h,d&&d.hover,d&&d.select,d&&d.disabled).attr({"text-align":"center",width:c}).add(e.buttonGroup),f.title&&r[u].attr("title",f.title)})},n.prototype.alignElements=function(){var e=this,t=this,r=t.buttonGroup,o=t.buttons,s=t.chart,a=t.group,l=t.inputGroup,h=t.options,d=t.zoomText,c=s.options,p=c.exporting&&c.exporting.enabled!==!1&&c.navigation&&c.navigation.buttonOptions,f=h.buttonPosition,u=h.inputPosition,g=h.verticalAlign,m=function(I,L){return p&&e.titleCollision(s)&&g==="top"&&L.align==="right"&&L.y-I.getBBox().height-12<(p.y||0)+(p.height||0)+s.spacing[0]?-40:0},y=s.plotLeft;if(a&&f&&u){var v=f.x-s.spacing[3];if(r){if(this.positionButtons(),!this.initialButtonGroupWidth){var x=0;d&&(x+=d.getBBox().width+5),o.forEach(function(I,L){x+=I.width,L!==o.length-1&&(x+=h.buttonSpacing)}),this.initialButtonGroupWidth=x}y-=s.spacing[3],this.updateButtonStates();var b=m(r,f);this.alignButtonGroup(b),a.placed=r.placed=s.hasLoaded}var $=0;l&&($=m(l,u),u.align==="left"?v=y:u.align==="right"&&(v=-Math.max(s.axisOffset[1],-$)),l.align({y:u.y,width:l.getBBox().width,align:u.align,x:u.x+v-2},!0,s.spacingBox),l.placed=s.hasLoaded),this.handleCollision($),a.align({verticalAlign:g},!0,s.spacingBox);var S=a.alignAttr.translateY,k=a.getBBox().height+20,A=0;if(g==="bottom"){var M=s.legend&&s.legend.options,P=M&&M.verticalAlign==="bottom"&&M.enabled&&!M.floating?s.legend.legendHeight+pick$W(M.margin,10):0;k=k+P-20,A=S-k-(h.floating?0:h.y)-(s.titleOffset?s.titleOffset[2]:0)-10}g==="top"?(h.floating&&(A=0),s.titleOffset&&s.titleOffset[0]&&(A=s.titleOffset[0]),A+=s.margin[0]-s.spacing[0]||0):g==="middle"&&(u.y===f.y?A=S:(u.y||f.y)&&(u.y<0||f.y<0?A-=Math.min(u.y,f.y):A=S-k)),a.translate(h.x,h.y+Math.floor(A));var E=this,T=E.minInput,O=E.maxInput,C=E.dropdown;h.inputEnabled&&T&&O&&(T.style.marginTop=a.translateY+"px",O.style.marginTop=a.translateY+"px"),C&&(C.style.marginTop=a.translateY+"px")}},n.prototype.alignButtonGroup=function(e,t){var r=this,o=r.chart,s=r.options,a=r.buttonGroup;r.buttons;var l=s.buttonPosition,h=o.plotLeft-o.spacing[3],d=l.x-o.spacing[3];l.align==="right"?d+=e-h:l.align==="center"&&(d-=h/2),a&&a.align({y:l.y,width:pick$W(t,this.initialButtonGroupWidth),align:l.align,x:d},!0,o.spacingBox)},n.prototype.positionButtons=function(){var e=this,t=e.buttons,r=e.chart,o=e.options,s=e.zoomText,a=r.hasLoaded?"animate":"attr",l=o.buttonPosition,h=r.plotLeft,d=h;s&&s.visibility!=="hidden"&&(s[a]({x:pick$W(h+l.x,h)}),d+=l.x+s.getBBox().width+5),this.buttonOptions.forEach(function(c,p){t[p].visibility!=="hidden"?(t[p][a]({x:d}),d+=t[p].width+o.buttonSpacing):t[p][a]({x:h})})},n.prototype.handleCollision=function(e){var t=this,r=this,o=r.chart,s=r.buttonGroup,a=r.inputGroup,l=this.options,h=l.buttonPosition,d=l.dropdown,c=l.inputPosition,p=function(){var g=0;return t.buttons.forEach(function(m){var y=m.getBBox();y.width>g&&(g=y.width)}),g},f=function(g){if(a&&s){var m=a.alignAttr.translateX+a.alignOptions.x-e+a.getBBox().x+2,y=a.alignOptions.width,v=s.alignAttr.translateX+s.getBBox().x;return v+g>m&&m+y>v&&h.y<c.y+a.getBBox().height}return!1},u=function(){a&&s&&a.attr({translateX:a.alignAttr.translateX+(o.axisOffset[1]>=-e?0:-e),translateY:a.alignAttr.translateY+s.getBBox().height+10})};if(s){if(d==="always"){this.collapseButtons(e),f(p())&&u();return}d==="never"&&this.expandButtons()}a&&s?c.align===h.align||f(this.initialButtonGroupWidth+20)?d==="responsive"?(this.collapseButtons(e),f(p())&&u()):u():d==="responsive"&&this.expandButtons():s&&d==="responsive"&&(this.initialButtonGroupWidth>o.plotWidth?this.collapseButtons(e):this.expandButtons())},n.prototype.collapseButtons=function(e){var t=this,r=t.buttons,o=t.buttonOptions,s=t.chart,a=t.dropdown,l=t.options,h=t.zoomText,d=s.userOptions.rangeSelector&&s.userOptions.rangeSelector.buttonTheme||{},c=function(u){return{text:u?u+" ▾":"▾",width:"auto",paddingLeft:pick$W(l.buttonTheme.paddingLeft,d.padding,8),paddingRight:pick$W(l.buttonTheme.paddingRight,d.padding,8)}};h&&h.hide();var p=!1;o.forEach(function(u,g){var m=r[g];m.state!==2?m.hide():(m.show(),m.attr(c(u.text)),p=!0)}),p||(a&&(a.selectedIndex=0),r[0].show(),r[0].attr(c(this.zoomText&&this.zoomText.textStr)));var f=l.buttonPosition.align;this.positionButtons(),(f==="right"||f==="center")&&this.alignButtonGroup(e,r[this.currentButtonIndex()].getBBox().width),this.showDropdown()},n.prototype.expandButtons=function(){var e=this,t=e.buttons,r=e.buttonOptions,o=e.options,s=e.zoomText;this.hideDropdown(),s&&s.show(),r.forEach(function(a,l){var h=t[l];h.show(),h.attr({text:a.text,width:o.buttonTheme.width||28,paddingLeft:pick$W(o.buttonTheme.paddingLeft,"unset"),paddingRight:pick$W(o.buttonTheme.paddingRight,"unset")}),h.state<2&&h.setState(0)}),this.positionButtons()},n.prototype.currentButtonIndex=function(){var e=this.dropdown;return e&&e.selectedIndex>0?e.selectedIndex-1:0},n.prototype.showDropdown=function(){var e=this,t=e.buttonGroup,r=e.buttons,o=e.chart,s=e.dropdown;if(t&&s){var a=t.translateX,l=t.translateY,h=r[this.currentButtonIndex()].getBBox();css$2(s,{left:o.plotLeft+a+"px",top:l+.5+"px",width:h.width+"px",height:h.height+"px"}),this.hasVisibleDropdown=!0}},n.prototype.hideDropdown=function(){var e=this.dropdown;e&&(css$2(e,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)},n.prototype.getHeight=function(){var e=this,t=e.options,r=e.group,o=t.inputPosition,s=t.buttonPosition,a=t.y,l=s.y,h=o.y,d=0,c;return t.height?t.height:(this.alignElements(),d=r?r.getBBox(!0).height+13+a:0,c=Math.min(h,l),(h<0&&l<0||h>0&&l>0)&&(d+=Math.abs(c)),d)},n.prototype.titleCollision=function(e){return!(e.options.title.text||e.options.subtitle.text)},n.prototype.update=function(e){var t=this.chart;merge$Q(!0,t.options.rangeSelector,e),this.destroy(),this.init(t),this.render()},n.prototype.destroy=function(){var e=this,t=e.minInput,r=e.maxInput;e.eventsToUnbind&&(e.eventsToUnbind.forEach(function(o){return o()}),e.eventsToUnbind=void 0),destroyObjectProperties$1(e.buttons),t&&(t.onfocus=t.onblur=t.onchange=null),r&&(r.onfocus=r.onblur=r.onchange=null),objectEach$d(e,function(o,s){o&&s!=="chart"&&(o instanceof SVGElement?o.destroy():o instanceof window.HTMLElement&&discardElement$2(o)),o!==n.prototype[s]&&(e[s]=null)},this)},n}();RangeSelector.prototype.defaultButtons=[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}];RangeSelector.prototype.inputTypeFormats={"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"};function preferredInputType(n){var e=n.indexOf("%L")!==-1;if(e)return"text";var t=["a","A","d","e","w","b","B","m","o","y","Y"].some(function(o){return n.indexOf("%"+o)!==-1}),r=["H","k","I","l","M","S"].some(function(o){return n.indexOf("%"+o)!==-1});return t&&r?"datetime-local":t?"date":r?"time":"text"}Axis.prototype.minFromRange=function(){var n=this.range,e=n.type,t,r=this.max,o,s,a=this.chart.time,l=function(h,d){var c=e==="year"?"FullYear":"Month",p=new a.Date(h),f=a.get(c,p);return a.set(c,p,f+d),f===a.get(c,p)&&a.set("Date",p,0),p.getTime()-h};return isNumber$o(n)?(t=r-n,s=n):(t=r+l(r,-n.count),this.chart&&(this.chart.fixedRange=r-t)),o=pick$W(this.dataMin,Number.MIN_VALUE),isNumber$o(t)||(t=o),t<=o&&(t=o,typeof s>"u"&&(s=l(t,n.count)),this.newMax=Math.min(t+s,this.dataMax)),isNumber$o(r)||(t=void 0),t};if(!H.RangeSelector){var chartDestroyEvents_1=[],initRangeSelector_1=function(n){var e,t=n.rangeSelector,r,o,s;function a(){t&&(e=n.xAxis[0].getExtremes(),r=n.legend,s=t&&t.options.verticalAlign,isNumber$o(e.min)&&t.render(e.min,e.max),r.display&&s==="top"&&s===r.options.verticalAlign&&(o=merge$Q(n.spacingBox),r.options.layout==="vertical"?o.y=n.plotTop:o.y+=t.getHeight(),r.group.placed=!1,r.align(o)))}if(t){var l=find$b(chartDestroyEvents_1,function(h){return h[0]===n});l||chartDestroyEvents_1.push([n,[addEvent$E(n.xAxis[0],"afterSetExtremes",function(h){t&&t.render(h.min,h.max)}),addEvent$E(n,"redraw",a)]]),a()}};addEvent$E(Chart$1,"afterGetContainer",function(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new RangeSelector(this))}),addEvent$E(Chart$1,"beforeRender",function(){var n=this,e=n.axes,t=n.rangeSelector,r;t&&(isNumber$o(t.deferredYTDClick)&&(t.clickButton(t.deferredYTDClick),delete t.deferredYTDClick),e.forEach(function(o){o.updateNames(),o.setScale()}),n.getAxisMargins(),t.render(),r=t.options.verticalAlign,t.options.floating||(r==="bottom"?this.extraBottomMargin=!0:r!=="middle"&&(this.extraTopMargin=!0)))}),addEvent$E(Chart$1,"update",function(n){var e=this,t=n.options,r=t.rangeSelector,o=e.rangeSelector,s,a=this.extraBottomMargin,l=this.extraTopMargin;r&&r.enabled&&!defined$r(o)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=o=new RangeSelector(this)),this.extraBottomMargin=!1,this.extraTopMargin=!1,o&&(initRangeSelector_1(this),s=r&&r.verticalAlign||o.options&&o.options.verticalAlign,o.options.floating||(s==="bottom"?this.extraBottomMargin=!0:s!=="middle"&&(this.extraTopMargin=!0)),(this.extraBottomMargin!==a||this.extraTopMargin!==l)&&(this.isDirtyBox=!0))}),addEvent$E(Chart$1,"render",function(){var n=this,e=n.rangeSelector,t;e&&!e.options.floating&&(e.render(),t=e.options.verticalAlign,t==="bottom"?this.extraBottomMargin=!0:t!=="middle"&&(this.extraTopMargin=!0))}),addEvent$E(Chart$1,"getMargins",function(){var n=this.rangeSelector,e;n&&(e=n.getHeight(),this.extraTopMargin&&(this.plotTop+=e),this.extraBottomMargin&&(this.marginBottom+=e))}),Chart$1.prototype.callbacks.push(initRangeSelector_1),addEvent$E(Chart$1,"destroy",function(){for(var e=0;e<chartDestroyEvents_1.length;e++){var t=chartDestroyEvents_1[e];if(t[0]===this){t[1].forEach(function(r){return r()}),chartDestroyEvents_1.splice(e,1);return}}}),H.RangeSelector=RangeSelector}var __extends$G=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),animObject$4=animationExports.animObject,format$6=FormatUtilities.format,getOptions$2=DefaultOptions.getOptions,pointTooltipFormatter=Point$2.prototype.tooltipFormatter,_a$c=Series$e.prototype,seriesInit=_a$c.init,seriesProcessData=_a$c.processData,addEvent$D=Utilities.addEvent,arrayMax$4=Utilities.arrayMax,arrayMin$4=Utilities.arrayMin,clamp$9=Utilities.clamp,defined$q=Utilities.defined,extend$Z=Utilities.extend,find$a=Utilities.find,isNumber$n=Utilities.isNumber,isString$3=Utilities.isString,merge$P=Utilities.merge,pick$V=Utilities.pick,splat$7=Utilities.splat,StockChart=function(n){__extends$G(e,n);function e(){return n!==null&&n.apply(this,arguments)||this}return e.prototype.init=function(t,r){var o=getOptions$2(),s=t.xAxis,a=t.yAxis,l=pick$V(t.navigator&&t.navigator.enabled,o.navigator.enabled,!0);t.xAxis=t.yAxis=void 0;var h=merge$P({chart:{panning:{enabled:!0,type:"x"},pinchType:"x"},navigator:{enabled:l},scrollbar:{enabled:pick$V(o.scrollbar&&o.scrollbar.enabled,!0)},rangeSelector:{enabled:pick$V(o.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:pick$V(o.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},t,{isStock:!0});t.xAxis=s,t.yAxis=a,h.xAxis=splat$7(t.xAxis||{}).map(function(d,c){return merge$P(getDefaultAxisOptions("xAxis",d),o.xAxis,o.xAxis&&o.xAxis[c],d,getForcedAxisOptions("xAxis",t))}),h.yAxis=splat$7(t.yAxis||{}).map(function(d,c){return merge$P(getDefaultAxisOptions("yAxis",d),o.yAxis,o.yAxis&&o.yAxis[c],d)}),n.prototype.init.call(this,h,r)},e.prototype.createAxis=function(t,r){return r.axis=merge$P(getDefaultAxisOptions(t,r.axis),r.axis,getForcedAxisOptions(t,this.userOptions)),n.prototype.createAxis.call(this,t,r)},e}(Chart$1);(function(n){function e(t,r,o){return new n(t,r,o)}n.stockChart=e})(StockChart);function getDefaultAxisOptions(n,e){return n==="xAxis"?{minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0}:n==="yAxis"?{labels:{y:-2},opposite:pick$V(e.opposite,!0),showLastLabel:!!(e.categories||e.type==="category"),title:{text:null}}:{}}function getForcedAxisOptions(n,e){if(n==="xAxis"){var t=getOptions$2(),r=pick$V(e.navigator&&e.navigator.enabled,t.navigator.enabled,!0),o={type:"datetime",categories:void 0};return r&&(o.startOnTick=!1,o.endOnTick=!1),o}return{}}addEvent$D(Series$e,"setOptions",function(n){var e;this.chart.options.isStock&&(this.is("column")||this.is("columnrange")?e={borderWidth:0,shadow:!1}:!this.is("scatter")&&!this.is("sma")&&(e={marker:{enabled:!1,radius:2}}),e&&(n.plotOptions[this.type]=merge$P(n.plotOptions[this.type],e)))});addEvent$D(Axis,"autoLabelAlign",function(n){var e=this.chart,t=this.options,r=e._labelPanes=e._labelPanes||{},o,s=this.options.labels;this.chart.options.isStock&&this.coll==="yAxis"&&(o=t.top+","+t.height,!r[o]&&s.enabled&&(s.x===15&&(s.x=0),typeof s.align>"u"&&(s.align="right"),r[o]=this,n.align="right",n.preventDefault()))});addEvent$D(Axis,"destroy",function(){var n=this.chart,e=this.options&&this.options.top+","+this.options.height;e&&n._labelPanes&&n._labelPanes[e]===this&&delete n._labelPanes[e]});addEvent$D(Axis,"getPlotLinePath",function(n){var e=this,t=this.isLinked&&!this.series?this.linkedParent.series:this.series,r=e.chart,o=r.renderer,s=e.left,a=e.top,l,h,d,c,p=[],f=[],u,g,m=n.translatedValue,y=n.value,v=n.force,x;function b($){var S=$==="xAxis"?"yAxis":"xAxis",k=e.options[S];return isNumber$n(k)?[r[S][k]]:isString$3(k)?[r.get(k)]:t.map(function(A){return A[S]})}(r.options.isStock&&n.acrossPanes!==!1&&e.coll==="xAxis"||e.coll==="yAxis")&&(n.preventDefault(),f=b(e.coll),u=e.isXAxis?r.yAxis:r.xAxis,u.forEach(function($){if(!defined$q($.options.id)||$.options.id.indexOf("navigator")===-1){var S=$.isXAxis?"yAxis":"xAxis",k=defined$q($.options[S])?r[S][$.options[S]]:r[S][0];e===k&&f.push($)}}),g=f.length?[]:[e.isXAxis?r.yAxis[0]:r.xAxis[0]],f.forEach(function($){g.indexOf($)===-1&&!find$a(g,function(S){return S.pos===$.pos&&S.len===$.len})&&g.push($)}),x=pick$V(m,e.translate(y,null,null,n.old)),isNumber$n(x)&&(e.horiz?g.forEach(function($){var S;h=$.pos,c=h+$.len,l=d=Math.round(x+e.transB),v!=="pass"&&(l<s||l>s+e.width)&&(v?l=d=clamp$9(l,s,s+e.width):S=!0),S||p.push(["M",l,h],["L",d,c])}):g.forEach(function($){var S;l=$.pos,d=l+$.len,h=c=Math.round(a+e.height-x),v!=="pass"&&(h<a||h>a+e.height)&&(v?h=c=clamp$9(h,a,a+e.height):S=!0),S||p.push(["M",l,h],["L",d,c])})),n.path=p.length>0?o.crispPolyLine(p,n.lineWidth||1):null)});SVGRenderer.prototype.crispPolyLine=function(n,e){for(var t=0;t<n.length;t=t+2){var r=n[t],o=n[t+1];r[1]===o[1]&&(r[1]=o[1]=Math.round(r[1])-e%2/2),r[2]===o[2]&&(r[2]=o[2]=Math.round(r[2])+e%2/2)}return n};addEvent$D(Axis,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});addEvent$D(Axis,"afterDrawCrosshair",function(n){if(!(!this.crosshair||!this.crosshair.label||!this.crosshair.label.enabled||!this.cross||!isNumber$n(this.min)||!isNumber$n(this.max))){var e=this.chart,t=this.logarithmic,r=this.crosshair.label,o=this.horiz,s=this.opposite,a=this.left,l=this.top,h=this.crossLabel,d,c,p,f=r.format,u="",g,m,y=this.options.tickPosition==="inside",v=this.crosshair.snap!==!1,x=0,b=n.e||this.cross&&this.cross.e,$=n.point,S=this.min,k=this.max;t&&(S=t.lin2log(S),k=t.lin2log(k)),m=o?"center":s?this.labelAlign==="right"?"right":"left":this.labelAlign==="left"?"left":"center",h||(h=this.crossLabel=e.renderer.label("",0,void 0,r.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+($?$.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:r.align||m,padding:pick$V(r.padding,8),r:pick$V(r.borderRadius,3),zIndex:2}).add(this.labelGroup),e.styledMode||h.attr({fill:r.backgroundColor||$&&$.series&&$.series.color||palette.neutralColor60,stroke:r.borderColor||"","stroke-width":r.borderWidth||0}).css(extend$Z({color:palette.backgroundColor,fontWeight:"normal",fontSize:"11px",textAlign:"center"},r.style||{}))),o?(d=v?($.plotX||0)+a:b.chartX,c=l+(s?0:this.height)):(d=s?this.width+a:0,c=v?($.plotY||0)+l:b.chartY),!f&&!r.formatter&&(this.dateTime&&(u="%b %d, %Y"),f="{value"+(u?":"+u:"")+"}");var A=v?this.isXAxis?$.x:$.y:this.toValue(o?b.chartX:b.chartY),M=$?$.series.isPointInside($):isNumber$n(A)&&A>S&&A<k,P="";f?P=format$6(f,{value:A},e):r.formatter&&isNumber$n(A)&&(P=r.formatter.call(this,A)),h.attr({text:P,x:d,y:c,visibility:M?"visible":"hidden"}),p=h.getBBox(),isNumber$n(h.y)&&(o?(y&&!s||!y&&s)&&(c=h.y-p.height):c=h.y-p.height/2),o?g={left:a-p.x,right:a+this.width-p.x}:g={left:this.labelAlign==="left"?a:0,right:this.labelAlign==="right"?a+this.width:e.chartWidth},h.translateX<g.left&&(x=g.left-h.translateX),h.translateX+p.width>=g.right&&(x=-(h.translateX+p.width-g.right)),h.attr({x:d+x,y:c,anchorX:o?d:this.opposite?0:e.chartWidth,anchorY:o?this.opposite?e.chartHeight:0:c+p.height/2})}});Series$e.prototype.init=function(){seriesInit.apply(this,arguments),this.initCompare(this.options.compare)};Series$e.prototype.setCompare=function(n){this.initCompare(n),this.userOptions.compare=n};Series$e.prototype.initCompare=function(n){this.modifyValue=n==="value"||n==="percent"?function(e,t){var r=this.compareValue;return typeof e<"u"&&typeof r<"u"?(n==="value"?e-=r:e=100*(e/r)-(this.options.compareBase===100?0:100),t&&(t.change=e),e):0}:null,this.chart.hasRendered&&(this.isDirty=!0)};Series$e.prototype.forceCropping=function(){var n=this.chart,e=this.options,t=e.dataGrouping,r=this.allowDG!==!1&&t&&pick$V(t.enabled,n.options.isStock);return r};Series$e.prototype.processData=function(n){var e=this,t,r=-1,o,s,a=e.options.compareStart===!0?0:1,l,h;if(seriesProcessData.apply(this,arguments),e.xAxis&&e.processedYData){for(o=e.processedXData,s=e.processedYData,l=s.length,e.pointArrayMap&&(r=e.pointArrayMap.indexOf(e.options.pointValKey||e.pointValKey||"y")),t=0;t<l-a;t++)if(h=s[t]&&r>-1?s[t][r]:s[t],isNumber$n(h)&&o[t+a]>=e.xAxis.min&&h!==0){e.compareValue=h;break}}};addEvent$D(Series$e,"afterGetExtremes",function(n){var e=n.dataExtremes;if(this.modifyValue&&e){var t=[this.modifyValue(e.dataMin),this.modifyValue(e.dataMax)];e.dataMin=arrayMin$4(t),e.dataMax=arrayMax$4(t)}});Axis.prototype.setCompare=function(n,e){this.isXAxis||(this.series.forEach(function(t){t.setCompare(n)}),pick$V(e,!0)&&this.chart.redraw())};Point$2.prototype.tooltipFormatter=function(n){var e=this,t=e.series.chart.numberFormatter;return n=n.replace("{point.change}",(e.change>0?"+":"")+t(e.change,pick$V(e.series.tooltipOptions.changeDecimals,2))),pointTooltipFormatter.apply(this,[n])};addEvent$D(Series$e,"render",function(){var n=this.chart,e;if(!(n.is3d&&n.is3d())&&!n.polar&&this.xAxis&&!this.xAxis.isRadial&&this.options.clip!==!1){if(e=this.yAxis.len,this.xAxis.axisLine){var t=n.plotTop+n.plotHeight-this.yAxis.pos-this.yAxis.len,r=Math.floor(this.xAxis.axisLine.strokeWidth()/2);t>=0&&(e-=Math.max(r-t,0))}if((!n.hasLoaded||!this.clipBox&&this.isDirty&&!this.isDirtyData)&&(this.clipBox=this.clipBox||merge$P(n.clipBox),this.clipBox.width=this.xAxis.len,this.clipBox.height=e),n.hasRendered){var o=animObject$4(this.options.animation),s=this.getSharedClipKey(o),a=n.sharedClips[s];if(a){a.animate({width:this.xAxis.len,height:e});var l=n.sharedClips[s+"m"];l&&l.animate({width:this.xAxis.len})}}}});addEvent$D(Chart$1,"update",function(n){var e=n.options;"scrollbar"in e&&this.navigator&&(merge$P(!0,this.options.scrollbar,e.scrollbar),this.navigator.update({},!1),delete e.scrollbar)});/**
 * @license Highstock JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/stock
 * @requires highcharts
 *
 * Highcharts Stock as a plugin for Highcharts
 *
 * (c) 2010-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$5=H;G$5.Scrollbar=Scrollbar;G$5.StockChart=G$5.stockChart=StockChart.stockChart;Scrollbar.compose(G$5.Axis);OrdinalAxis$1.compose(G$5.Axis,G$5.Series,G$5.Chart);/**
 * @license Highstock JS v9.2.2 (2021-08-24)
 * @module highcharts/highstock
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */G$7.product="Highstock";var doc$f=H.doc,win$6=H.win,merge$O=Utilities.merge;function addClass$1(n,e){n.classList?n.classList.add(e):n.className.indexOf(e)<0&&(n.className+=e)}function escapeStringForHTML$1(n){return n.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#x27;").replace(/\//g,"&#x2F;")}function getElement$2(n){return doc$f.getElementById(n)}function getFakeMouseEvent$2(n){if(typeof win$6.MouseEvent=="function")return new win$6.MouseEvent(n);if(doc$f.createEvent){var e=doc$f.createEvent("MouseEvent");if(e.initMouseEvent)return e.initMouseEvent(n,!0,!0,win$6,n==="click"?1:0,0,0,0,0,!1,!1,!1,!1,0,null),e}return{type:n}}function getHeadingTagNameForElement$1(n){var e=function(s){var a=parseInt(s.slice(1),10),l=Math.min(6,a+1);return"h"+l},t=function(s){return/H[1-6]/.test(s)},r=function(s){for(var a=s;a=a.previousSibling;){var l=a.tagName||"";if(t(l))return l}return""},o=function(s){var a=r(s);if(a)return e(a);var l=s.parentElement;if(!l)return"p";var h=l.tagName;return t(h)?e(h):o(l)};return o(n)}function removeElement$5(n){n&&n.parentNode&&n.parentNode.removeChild(n)}function reverseChildNodes$1(n){for(var e=n.childNodes.length;e--;)n.appendChild(n.childNodes[e])}function setElAttrs$4(n,e){Object.keys(e).forEach(function(t){var r=e[t];r===null?n.removeAttribute(t):n.setAttribute(t,r)})}function stripHTMLTagsFromString$2(n){return typeof n=="string"?n.replace(/<\/?[^>]+(>|$)/g,""):n}function visuallyHideElement$2(n){var e={position:"absolute",width:"1px",height:"1px",overflow:"hidden",whiteSpace:"nowrap",clip:"rect(1px, 1px, 1px, 1px)",marginTop:"-3px","-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity=1)",filter:"alpha(opacity=1)",opacity:"0.01"};merge$O(!0,n.style,e)}var HTMLUtilities={addClass:addClass$1,escapeStringForHTML:escapeStringForHTML$1,getElement:getElement$2,getFakeMouseEvent:getFakeMouseEvent$2,getHeadingTagNameForElement:getHeadingTagNameForElement$1,removeElement:removeElement$5,reverseChildNodes:reverseChildNodes$1,setElAttrs:setElAttrs$4,stripHTMLTagsFromString:stripHTMLTagsFromString$2,visuallyHideElement:visuallyHideElement$2},stripHTMLTags$3=HTMLUtilities.stripHTMLTagsFromString,doc$e=H.doc,defined$p=Utilities.defined,find$9=Utilities.find,fireEvent$i=Utilities.fireEvent;function getChartTitle$5(n){return stripHTMLTags$3(n.options.title.text||n.langFormat("accessibility.defaultChartTitle",{chart:n}))}function getAxisDescription$2(n){return n&&(n.userOptions&&n.userOptions.accessibility&&n.userOptions.accessibility.description||n.axisTitle&&n.axisTitle.textStr||n.options.id||n.categories&&"categories"||n.dateTime&&"Time"||"values")}function getAxisRangeDescription$2(n){var e=n.options||{};return e.accessibility&&typeof e.accessibility.rangeDescription<"u"?e.accessibility.rangeDescription:n.categories?getCategoryAxisRangeDesc(n):n.dateTime&&(n.min===0||n.dataMin===0)?getAxisTimeLengthDesc(n):getAxisFromToDescription(n)}function getCategoryAxisRangeDesc(n){var e=n.chart;return n.dataMax&&n.dataMin?e.langFormat("accessibility.axis.rangeCategories",{chart:e,axis:n,numCategories:n.dataMax-n.dataMin+1}):""}function getAxisTimeLengthDesc(n){var e=n.chart,t={},r="Seconds";t.Seconds=((n.max||0)-(n.min||0))/1e3,t.Minutes=t.Seconds/60,t.Hours=t.Minutes/60,t.Days=t.Hours/24,["Minutes","Hours","Days"].forEach(function(s){t[s]>2&&(r=s)});var o=t[r].toFixed(r!=="Seconds"&&r!=="Minutes"?1:0);return e.langFormat("accessibility.axis.timeRange"+r,{chart:e,axis:n,range:o.replace(".0","")})}function getAxisFromToDescription(n){var e=n.chart,t=e.options&&e.options.accessibility&&e.options.accessibility.screenReaderSection.axisRangeDateFormat||"",r=function(o){return n.dateTime?e.time.dateFormat(t,n[o]):n[o]};return e.langFormat("accessibility.axis.rangeFromTo",{chart:e,axis:n,rangeFrom:r("min"),rangeTo:r("max")})}function getSeriesFirstPointElement$1(n){if(n.points&&n.points.length){var e=find$9(n.points,function(t){return!!t.graphic});return e&&e.graphic&&e.graphic.element}}function getSeriesA11yElement$1(n){var e=getSeriesFirstPointElement$1(n);return e&&e.parentNode||n.graph&&n.graph.element||n.group&&n.group.element}function unhideChartElementFromAT$7(n,e){e.setAttribute("aria-hidden",!1),!(e===n.renderTo||!e.parentNode||e.parentNode===doc$e.body)&&(Array.prototype.forEach.call(e.parentNode.childNodes,function(t){t.hasAttribute("aria-hidden")||t.setAttribute("aria-hidden",!0)}),unhideChartElementFromAT$7(n,e.parentNode))}function hideSeriesFromAT$1(n){var e=getSeriesA11yElement$1(n);e&&e.setAttribute("aria-hidden",!0)}function getSeriesFromName$1(n,e){return e?(n.series||[]).filter(function(t){return t.name===e}):n.series}function getPointFromXY$1(n,e,t){for(var r=n.length,o;r--;)if(o=find$9(n[r].points||[],function(s){return s.x===e&&s.y===t}),o)return o}function getRelativePointAxisPosition(n,e){if(!defined$p(n.dataMin)||!defined$p(n.dataMax))return 0;var t=n.toPixels(n.dataMin),r=n.toPixels(n.dataMax),o=n.coll==="xAxis"?"x":"y",s=n.toPixels(e[o]||0);return(s-t)/(r-t)}function scrollToPoint$1(n){var e=n.series.xAxis,t=n.series.yAxis,r=e&&e.scrollbar?e:t,o=r&&r.scrollbar;if(o&&defined$p(o.to)&&defined$p(o.from)){var s=o.to-o.from,a=getRelativePointAxisPosition(r,n);o.updatePosition(a-s/2,a+s/2),fireEvent$i(o,"changed",{from:o.from,to:o.to,trigger:"scrollbar",DOMEvent:null})}}var ChartUtilities={getChartTitle:getChartTitle$5,getAxisDescription:getAxisDescription$2,getAxisRangeDescription:getAxisRangeDescription$2,getPointFromXY:getPointFromXY$1,getSeriesFirstPointElement:getSeriesFirstPointElement$1,getSeriesFromName:getSeriesFromName$1,getSeriesA11yElement:getSeriesA11yElement$1,unhideChartElementFromAT:unhideChartElementFromAT$7,hideSeriesFromAT:hideSeriesFromAT$1,scrollToPoint:scrollToPoint$1},find$8=Utilities.find;function KeyboardNavigationHandler(n,e){this.chart=n,this.keyCodeMap=e.keyCodeMap||[],this.validate=e.validate,this.init=e.init,this.terminate=e.terminate,this.response={success:1,prev:2,next:3,noHandler:4,fail:5}}KeyboardNavigationHandler.prototype={run:function(n){var e=n.which||n.keyCode,t=this.response.noHandler,r=find$8(this.keyCodeMap,function(o){return o[0].indexOf(e)>-1});return r?t=r[1].call(this,e,n):e===9&&(t=this.response[n.shiftKey?"prev":"next"]),t}};var doc$d=H.doc,removeElement$4=HTMLUtilities.removeElement,extend$Y=Utilities.extend,DOMElementProvider=function(){this.elements=[]};extend$Y(DOMElementProvider.prototype,{createElement:function(){var n=doc$d.createElement.apply(doc$d,arguments);return this.elements.push(n),n},destroyCreatedElements:function(){this.elements.forEach(function(n){removeElement$4(n)}),this.elements=[]}});var addEvent$C=Utilities.addEvent,extend$X=Utilities.extend,EventProvider=function(){this.eventRemovers=[]};extend$X(EventProvider.prototype,{addEvent:function(){var n=addEvent$C.apply(H,arguments);return this.eventRemovers.push(n),n},removeAddedEvents:function(){this.eventRemovers.forEach(function(n){n()}),this.eventRemovers=[]}});var unhideChartElementFromAT$6=ChartUtilities.unhideChartElementFromAT,doc$c=H.doc,win$5=H.win,removeElement$3=HTMLUtilities.removeElement,getFakeMouseEvent$1=HTMLUtilities.getFakeMouseEvent,extend$W=Utilities.extend,fireEvent$h=Utilities.fireEvent,merge$N=Utilities.merge,functionsToOverrideByDerivedClasses={init:function(){},getKeyboardNavigation:function(){},onChartUpdate:function(){},onChartRender:function(){},destroy:function(){}};function AccessibilityComponent(){}AccessibilityComponent.prototype={initBase:function(n){this.chart=n,this.eventProvider=new EventProvider,this.domElementProvider=new DOMElementProvider,this.keyCodes={left:37,right:39,up:38,down:40,enter:13,space:32,esc:27,tab:9}},addEvent:function(){return this.eventProvider.addEvent.apply(this.eventProvider,arguments)},createElement:function(){return this.domElementProvider.createElement.apply(this.domElementProvider,arguments)},fireEventOnWrappedOrUnwrappedElement:function(n,e){var t=e.type;doc$c.createEvent&&(n.dispatchEvent||n.fireEvent)?n.dispatchEvent?n.dispatchEvent(e):n.fireEvent(t,e):fireEvent$h(n,t,e)},fakeClickEvent:function(n){if(n){var e=getFakeMouseEvent$1("click");this.fireEventOnWrappedOrUnwrappedElement(n,e)}},addProxyGroup:function(n){this.createOrUpdateProxyContainer();var e=this.createElement("div");return Object.keys(n||{}).forEach(function(t){n[t]!==null&&e.setAttribute(t,n[t])}),this.chart.a11yProxyContainer.appendChild(e),e},createOrUpdateProxyContainer:function(){var n=this.chart,e=n.renderer.box;n.a11yProxyContainer=n.a11yProxyContainer||this.createProxyContainerElement(),e.nextSibling!==n.a11yProxyContainer&&n.container.insertBefore(n.a11yProxyContainer,e.nextSibling)},createProxyContainerElement:function(){var n=doc$c.createElement("div");return n.className="highcharts-a11y-proxy-container",n},createProxyButton:function(n,e,t,r,o){var s=n.element,a=this.createElement("button"),l=merge$N({"aria-label":s.getAttribute("aria-label")},t);return Object.keys(l).forEach(function(h){l[h]!==null&&a.setAttribute(h,l[h])}),a.className="highcharts-a11y-proxy-button",n.hasClass("highcharts-no-tooltip")&&(a.className+=" highcharts-no-tooltip"),o&&this.addEvent(a,"click",o),this.setProxyButtonStyle(a),this.updateProxyButtonPosition(a,r||n),this.proxyMouseEventsForButton(s,a),e.appendChild(a),l["aria-hidden"]||unhideChartElementFromAT$6(this.chart,a),a},getElementPosition:function(n){var e=n.element,t=this.chart.renderTo;if(t&&e&&e.getBoundingClientRect){var r=e.getBoundingClientRect(),o=t.getBoundingClientRect();return{x:r.left-o.left,y:r.top-o.top,width:r.right-r.left,height:r.bottom-r.top}}return{x:0,y:0,width:1,height:1}},setProxyButtonStyle:function(n){merge$N(!0,n.style,{borderWidth:"0",backgroundColor:"transparent",cursor:"pointer",outline:"none",opacity:"0.001",filter:"alpha(opacity=1)",zIndex:"999",overflow:"hidden",padding:"0",margin:"0",display:"block",position:"absolute"}),n.style["-ms-filter"]="progid:DXImageTransform.Microsoft.Alpha(Opacity=1)"},updateProxyButtonPosition:function(n,e){var t=this.getElementPosition(e);merge$N(!0,n.style,{width:(t.width||1)+"px",height:(t.height||1)+"px",left:(Math.round(t.x)||0)+"px",top:(Math.round(t.y)||0)+"px"})},proxyMouseEventsForButton:function(n,e){var t=this;["click","touchstart","touchend","touchcancel","touchmove","mouseover","mouseenter","mouseleave","mouseout"].forEach(function(r){var o=r.indexOf("touch")===0;t.addEvent(e,r,function(s){var a=o?t.cloneTouchEvent(s):t.cloneMouseEvent(s);n&&t.fireEventOnWrappedOrUnwrappedElement(n,a),s.stopPropagation(),r!=="touchstart"&&r!=="touchmove"&&r!=="touchend"&&s.preventDefault()},{passive:!1})})},cloneMouseEvent:function(n){if(typeof win$5.MouseEvent=="function")return new win$5.MouseEvent(n.type,n);if(doc$c.createEvent){var e=doc$c.createEvent("MouseEvent");if(e.initMouseEvent)return e.initMouseEvent(n.type,n.bubbles,n.cancelable,n.view||win$5,n.detail,n.screenX,n.screenY,n.clientX,n.clientY,n.ctrlKey,n.altKey,n.shiftKey,n.metaKey,n.button,n.relatedTarget),e}return getFakeMouseEvent$1(n.type)},cloneTouchEvent:function(n){var e=function(o){for(var s=[],a=0;a<o.length;++a){var l=o.item(a);l&&s.push(l)}return s};if(typeof win$5.TouchEvent=="function"){var t=new win$5.TouchEvent(n.type,{touches:e(n.touches),targetTouches:e(n.targetTouches),changedTouches:e(n.changedTouches),ctrlKey:n.ctrlKey,shiftKey:n.shiftKey,altKey:n.altKey,metaKey:n.metaKey,bubbles:n.bubbles,cancelable:n.cancelable,composed:n.composed,detail:n.detail,view:n.view});return n.defaultPrevented&&t.preventDefault(),t}var r=this.cloneMouseEvent(n);return r.touches=n.touches,r.changedTouches=n.changedTouches,r.targetTouches=n.targetTouches,r},destroyBase:function(){removeElement$3(this.chart.a11yProxyContainer),this.domElementProvider.destroyCreatedElements(),this.eventProvider.removeAddedEvents()}};extend$W(AccessibilityComponent.prototype,functionsToOverrideByDerivedClasses);var doc$b=H.doc,win$4=H.win,addEvent$B=Utilities.addEvent,fireEvent$g=Utilities.fireEvent,getElement$1=HTMLUtilities.getElement;addEvent$B(doc$b,"keydown",function(n){var e=n.which||n.keyCode,t=27;e===t&&H.charts&&H.charts.forEach(function(r){r&&r.dismissPopupContent&&r.dismissPopupContent()})});Chart$1.prototype.dismissPopupContent=function(){var n=this;fireEvent$g(this,"dismissPopupContent",{},function(){n.tooltip&&n.tooltip.hide(0),n.hideExportMenu()})};function KeyboardNavigation(n,e){this.init(n,e)}KeyboardNavigation.prototype={init:function(n,e){var t=this,r=this.eventProvider=new EventProvider;this.chart=n,this.components=e,this.modules=[],this.currentModuleIx=0,this.update(),r.addEvent(this.tabindexContainer,"keydown",function(o){return t.onKeydown(o)}),r.addEvent(this.tabindexContainer,"focus",function(o){return t.onFocus(o)}),["mouseup","touchend"].forEach(function(o){return r.addEvent(doc$b,o,function(){return t.onMouseUp()})}),["mousedown","touchstart"].forEach(function(o){return r.addEvent(n.renderTo,o,function(){t.isClickingChart=!0})}),r.addEvent(n.renderTo,"mouseover",function(){t.pointerIsOverChart=!0}),r.addEvent(n.renderTo,"mouseout",function(){t.pointerIsOverChart=!1}),this.modules.length&&this.modules[0].init(1)},update:function(n){var e=this.chart.options.accessibility,t=e&&e.keyboardNavigation,r=this.components;this.updateContainerTabindex(),t&&t.enabled&&n&&n.length?(this.modules=n.reduce(function(o,s){var a=r[s].getKeyboardNavigation();return o.concat(a)},[]),this.updateExitAnchor()):(this.modules=[],this.currentModuleIx=0,this.removeExitAnchor())},onFocus:function(n){var e=this.chart,t=n.relatedTarget&&e.container.contains(n.relatedTarget);!this.exiting&&!this.tabbingInBackwards&&!this.isClickingChart&&!t&&this.modules[0]&&this.modules[0].init(1),this.exiting=!1},onMouseUp:function(){if(delete this.isClickingChart,!this.keyboardReset&&!this.pointerIsOverChart){var n=this.chart,e=this.modules&&this.modules[this.currentModuleIx||0];e&&e.terminate&&e.terminate(),n.focusElement&&n.focusElement.removeFocusBorder(),this.currentModuleIx=0,this.keyboardReset=!0}},onKeydown:function(n){var e=n||win$4.event,t,r=this.modules&&this.modules.length&&this.modules[this.currentModuleIx];if(this.keyboardReset=!1,this.exiting=!1,r){var o=r.run(e);o===r.response.success?t=!0:o===r.response.prev?t=this.prev():o===r.response.next&&(t=this.next()),t&&(e.preventDefault(),e.stopPropagation())}},prev:function(){return this.move(-1)},next:function(){return this.move(1)},move:function(n){var e=this.modules&&this.modules[this.currentModuleIx];e&&e.terminate&&e.terminate(n),this.chart.focusElement&&this.chart.focusElement.removeFocusBorder(),this.currentModuleIx+=n;var t=this.modules&&this.modules[this.currentModuleIx];if(t){if(t.validate&&!t.validate())return this.move(n);if(t.init)return t.init(n),!0}return this.currentModuleIx=0,this.exiting=!0,n>0?this.exitAnchor.focus():this.tabindexContainer.focus(),!1},updateExitAnchor:function(){var n="highcharts-end-of-chart-marker-"+this.chart.index,e=getElement$1(n);this.removeExitAnchor(),e?(this.makeElementAnExitAnchor(e),this.exitAnchor=e):this.createExitAnchor()},updateContainerTabindex:function(){var n=this.chart.options.accessibility,e=n&&n.keyboardNavigation,t=!(e&&e.enabled===!1),r=this.chart,o=r.container,s;r.renderTo.hasAttribute("tabindex")?(o.removeAttribute("tabindex"),s=r.renderTo):s=o,this.tabindexContainer=s;var a=s.getAttribute("tabindex");t&&!a?s.setAttribute("tabindex","0"):t||r.container.removeAttribute("tabindex")},makeElementAnExitAnchor:function(n){var e=this.tabindexContainer.getAttribute("tabindex")||0;n.setAttribute("class","highcharts-exit-anchor"),n.setAttribute("tabindex",e),n.setAttribute("aria-hidden",!1),this.addExitAnchorEventsToEl(n)},createExitAnchor:function(){var n=this.chart,e=this.exitAnchor=doc$b.createElement("div");n.renderTo.appendChild(e),this.makeElementAnExitAnchor(e)},removeExitAnchor:function(){this.exitAnchor&&this.exitAnchor.parentNode&&(this.exitAnchor.parentNode.removeChild(this.exitAnchor),delete this.exitAnchor)},addExitAnchorEventsToEl:function(n){var e=this.chart,t=this;this.eventProvider.addEvent(n,"focus",function(r){var o=r||win$4.event,s,a=o.relatedTarget&&e.container.contains(o.relatedTarget),l=!(a||t.exiting);l?(t.tabbingInBackwards=!0,t.tabindexContainer.focus(),delete t.tabbingInBackwards,o.preventDefault(),t.modules&&t.modules.length&&(t.currentModuleIx=t.modules.length-1,s=t.modules[t.currentModuleIx],s&&s.validate&&!s.validate()?t.prev():s&&s.init(-1))):t.exiting=!1})},destroy:function(){this.removeExitAnchor(),this.eventProvider.removeAddedEvents(),this.chart.container.removeAttribute("tabindex")}};var animObject$3=animationExports.animObject,addEvent$A=Utilities.addEvent,extend$V=Utilities.extend,find$7=Utilities.find,fireEvent$f=Utilities.fireEvent,isNumber$m=Utilities.isNumber,pick$U=Utilities.pick,syncTimeout$1=Utilities.syncTimeout,removeElement$2=HTMLUtilities.removeElement,stripHTMLTags$2=HTMLUtilities.stripHTMLTagsFromString,getChartTitle$4=ChartUtilities.getChartTitle;function scrollLegendToItem(n,e){var t=n.allItems[e].pageIx,r=n.currentPage;typeof t<"u"&&t+1!==r&&n.scroll(1+t-r)}function shouldDoLegendA11y(n){var e=n.legend&&n.legend.allItems,t=n.options.legend.accessibility||{};return!!(e&&e.length&&!(n.colorAxis&&n.colorAxis.length)&&t.enabled!==!1)}Chart$1.prototype.highlightLegendItem=function(n){var e=this.legend.allItems,t=this.accessibility&&this.accessibility.components.legend.highlightedLegendItemIx;return e[n]?(isNumber$m(t)&&e[t]&&fireEvent$f(e[t].legendGroup.element,"mouseout"),scrollLegendToItem(this.legend,n),this.setFocusToElement(e[n].legendItem,e[n].a11yProxyElement),fireEvent$f(e[n].legendGroup.element,"mouseover"),!0):!1};addEvent$A(Legend,"afterColorizeItem",function(n){var e=this.chart,t=e.options.accessibility,r=n.item;t.enabled&&r&&r.a11yProxyElement&&r.a11yProxyElement.setAttribute("aria-pressed",n.visible?"true":"false")});var LegendComponent=function(){};LegendComponent.prototype=new AccessibilityComponent;extend$V(LegendComponent.prototype,{init:function(){var n=this;this.proxyElementsList=[],this.recreateProxies(),this.addEvent(Legend,"afterScroll",function(){this.chart===n.chart&&(n.updateProxiesPositions(),n.updateLegendItemProxyVisibility(),this.chart.highlightLegendItem(n.highlightedLegendItemIx))}),this.addEvent(Legend,"afterPositionItem",function(e){this.chart===n.chart&&this.chart.renderer&&n.updateProxyPositionForItem(e.item)}),this.addEvent(Legend,"afterRender",function(){this.chart===n.chart&&this.chart.renderer&&n.recreateProxies()&&syncTimeout$1(function(){return n.updateProxiesPositions()},animObject$3(pick$U(this.chart.renderer.globalAnimation,!0)).duration)})},updateLegendItemProxyVisibility:function(){var n=this.chart.legend,e=n.allItems||[],t=n.currentPage||1,r=n.clipHeight||0;e.forEach(function(o){var s=o.pageIx||0,a=o._legendItemPos?o._legendItemPos[1]:0,l=o.legendItem?Math.round(o.legendItem.getBBox().height):0,h=a+l-n.pages[s]>r||s!==t-1;o.a11yProxyElement&&(o.a11yProxyElement.style.visibility=h?"hidden":"visible")})},onChartRender:function(){shouldDoLegendA11y(this.chart)||this.removeProxies()},onChartUpdate:function(){this.updateLegendTitle()},updateProxiesPositions:function(){for(var n=0,e=this.proxyElementsList;n<e.length;n++){var t=e[n],r=t.element,o=t.posElement;this.updateProxyButtonPosition(r,o)}},updateProxyPositionForItem:function(n){var e=find$7(this.proxyElementsList,function(t){return t.item===n});e&&this.updateProxyButtonPosition(e.element,e.posElement)},recreateProxies:function(){return this.removeProxies(),shouldDoLegendA11y(this.chart)?(this.addLegendProxyGroup(),this.addLegendListContainer(),this.proxyLegendItems(),this.updateLegendItemProxyVisibility(),!0):!1},removeProxies:function(){removeElement$2(this.legendProxyGroup),this.proxyElementsList=[]},updateLegendTitle:function(){var n=this.chart,e=stripHTMLTags$2((n.legend&&n.legend.options.title&&n.legend.options.title.text||"").replace(/<br ?\/?>/g," ")),t=n.langFormat("accessibility.legend.legendLabel"+(e?"":"NoTitle"),{chart:n,legendTitle:e,chartTitle:getChartTitle$4(n)});this.legendProxyGroup&&this.legendProxyGroup.setAttribute("aria-label",t)},addLegendProxyGroup:function(){var n=this.chart.options.accessibility,e=n.landmarkVerbosity==="all"?"region":null;this.legendProxyGroup=this.addProxyGroup({"aria-label":"_placeholder_",role:e})},addLegendListContainer:function(){if(this.legendProxyGroup){var n=this.legendListContainer=this.createElement("ul");n.style.listStyle="none",this.legendProxyGroup.appendChild(n)}},proxyLegendItems:function(){var n=this,e=this.chart.legend&&this.chart.legend.allItems||[];e.forEach(function(t){t.legendItem&&t.legendItem.element&&n.proxyLegendItem(t)})},proxyLegendItem:function(n){if(!(!n.legendItem||!n.legendGroup||!this.legendListContainer)){var e=this.chart.langFormat("accessibility.legend.legendItem",{chart:this.chart,itemName:stripHTMLTags$2(n.name),item:n}),t={tabindex:-1,"aria-pressed":n.visible,"aria-label":e},r=n.legendGroup.div?n.legendItem:n.legendGroup,o=this.createElement("li");this.legendListContainer.appendChild(o),n.a11yProxyElement=this.createProxyButton(n.legendItem,o,t,r),this.proxyElementsList.push({item:n,element:n.a11yProxyElement,posElement:r})}},getKeyboardNavigation:function(){var n=this.keyCodes,e=this,t=this.chart;return new KeyboardNavigationHandler(t,{keyCodeMap:[[[n.left,n.right,n.up,n.down],function(r){return e.onKbdArrowKey(this,r)}],[[n.enter,n.space],function(r){return H.isFirefox&&r===n.space?this.response.success:e.onKbdClick(this)}]],validate:function(){return e.shouldHaveLegendNavigation()},init:function(r){return e.onKbdNavigationInit(r)},terminate:function(){t.legend.allItems.forEach(function(r){return r.setState("",!0)})}})},onKbdArrowKey:function(n,e){var t=this.keyCodes,r=n.response,o=this.chart,s=o.options.accessibility,a=o.legend.allItems.length,l=e===t.left||e===t.up?-1:1,h=o.highlightLegendItem(this.highlightedLegendItemIx+l);return h?(this.highlightedLegendItemIx+=l,r.success):a>1&&s.keyboardNavigation.wrapAround?(n.init(l),r.success):r[l>0?"next":"prev"]},onKbdClick:function(n){var e=this.chart.legend.allItems[this.highlightedLegendItemIx];return e&&e.a11yProxyElement&&fireEvent$f(e.a11yProxyElement,"click"),n.response.success},shouldHaveLegendNavigation:function(){var n=this.chart,e=n.options.legend||{},t=n.legend&&n.legend.allItems,r=n.colorAxis&&n.colorAxis.length,o=e.accessibility||{};return!!(t&&n.legend.display&&!r&&o.enabled&&o.keyboardNavigation&&o.keyboardNavigation.enabled)},onKbdNavigationInit:function(n){var e=this.chart,t=e.legend.allItems.length-1,r=n>0?0:t;e.highlightLegendItem(r),this.highlightedLegendItemIx=r}});var extend$U=Utilities.extend,getChartTitle$3=ChartUtilities.getChartTitle,unhideChartElementFromAT$5=ChartUtilities.unhideChartElementFromAT,removeElement$1=HTMLUtilities.removeElement,getFakeMouseEvent=HTMLUtilities.getFakeMouseEvent;function getExportMenuButtonElement(n){return n.exportSVGElements&&n.exportSVGElements[0]}Chart$1.prototype.showExportMenu=function(){var n=getExportMenuButtonElement(this);if(n){var e=n.element;e.onclick&&e.onclick(getFakeMouseEvent("click"))}};Chart$1.prototype.hideExportMenu=function(){var n=this,e=n.exportDivElements;e&&n.exportContextMenu&&(e.forEach(function(t){t&&t.className==="highcharts-menu-item"&&t.onmouseout&&t.onmouseout(getFakeMouseEvent("mouseout"))}),n.highlightedExportItemIx=0,n.exportContextMenu.hideMenu(),n.container.focus())};Chart$1.prototype.highlightExportItem=function(n){var e=this.exportDivElements&&this.exportDivElements[n],t=this.exportDivElements&&this.exportDivElements[this.highlightedExportItemIx],r;return e&&e.tagName==="LI"&&!(e.children&&e.children.length)?(r=!!(this.renderTo.getElementsByTagName("g")[0]||{}).focus,e.focus&&r&&e.focus(),t&&t.onmouseout&&t.onmouseout(getFakeMouseEvent("mouseout")),e.onmouseover&&e.onmouseover(getFakeMouseEvent("mouseover")),this.highlightedExportItemIx=n,!0):!1};Chart$1.prototype.highlightLastExportItem=function(){var n=this,e;if(n.exportDivElements){for(e=n.exportDivElements.length;e--;)if(n.highlightExportItem(e))return!0}return!1};function exportingShouldHaveA11y(n){var e=n.options.exporting,t=getExportMenuButtonElement(n);return!!(e&&e.enabled!==!1&&e.accessibility&&e.accessibility.enabled&&t&&t.element)}var MenuComponent=function(){};MenuComponent.prototype=new AccessibilityComponent;extend$U(MenuComponent.prototype,{init:function(){var n=this.chart,e=this;this.addEvent(n,"exportMenuShown",function(){e.onMenuShown()}),this.addEvent(n,"exportMenuHidden",function(){e.onMenuHidden()})},onMenuHidden:function(){var n=this.chart.exportContextMenu;n&&n.setAttribute("aria-hidden","true"),this.isExportMenuShown=!1,this.setExportButtonExpandedState("false")},onMenuShown:function(){var n=this.chart,e=n.exportContextMenu;e&&(this.addAccessibleContextMenuAttribs(),unhideChartElementFromAT$5(n,e)),this.isExportMenuShown=!0,this.setExportButtonExpandedState("true")},setExportButtonExpandedState:function(n){var e=this.exportButtonProxy;e&&e.setAttribute("aria-expanded",n)},onChartRender:function(){var n=this.chart,e=n.options.accessibility;if(removeElement$1(this.exportProxyGroup),exportingShouldHaveA11y(n)){this.exportProxyGroup=this.addProxyGroup(e.landmarkVerbosity==="all"?{"aria-label":n.langFormat("accessibility.exporting.exportRegionLabel",{chart:n,chartTitle:getChartTitle$3(n)}),role:"region"}:{});var t=getExportMenuButtonElement(this.chart);this.exportButtonProxy=this.createProxyButton(t,this.exportProxyGroup,{"aria-label":n.langFormat("accessibility.exporting.menuButtonLabel",{chart:n}),"aria-expanded":!1})}},addAccessibleContextMenuAttribs:function(){var n=this.chart,e=n.exportDivElements;if(e&&e.length){e.forEach(function(r){r&&(r.tagName==="LI"&&!(r.children&&r.children.length)?r.setAttribute("tabindex",-1):r.setAttribute("aria-hidden","true"))});var t=e[0]&&e[0].parentNode;t&&(t.removeAttribute("aria-hidden"),t.setAttribute("aria-label",n.langFormat("accessibility.exporting.chartMenuLabel",{chart:n})))}},getKeyboardNavigation:function(){var n=this.keyCodes,e=this.chart,t=this;return new KeyboardNavigationHandler(e,{keyCodeMap:[[[n.left,n.up],function(){return t.onKbdPrevious(this)}],[[n.right,n.down],function(){return t.onKbdNext(this)}],[[n.enter,n.space],function(){return t.onKbdClick(this)}]],validate:function(){return!!e.exporting&&e.options.exporting.enabled!==!1&&e.options.exporting.accessibility.enabled!==!1},init:function(){var r=t.exportButtonProxy,o=e.exportingGroup;o&&r&&e.setFocusToElement(o,r)},terminate:function(){e.hideExportMenu()}})},onKbdPrevious:function(n){for(var e=this.chart,t=e.options.accessibility,r=n.response,o=e.highlightedExportItemIx||0;o--;)if(e.highlightExportItem(o))return r.success;return t.keyboardNavigation.wrapAround?(e.highlightLastExportItem(),r.success):r.prev},onKbdNext:function(n){for(var e=this.chart,t=e.options.accessibility,r=n.response,o=(e.highlightedExportItemIx||0)+1;o<e.exportDivElements.length;++o)if(e.highlightExportItem(o))return r.success;return t.keyboardNavigation.wrapAround?(e.highlightExportItem(0),r.success):r.next},onKbdClick:function(n){var e=this.chart,t=e.exportDivElements[e.highlightedExportItemIx],r=getExportMenuButtonElement(e).element;return this.isExportMenuShown?this.fakeClickEvent(t):(this.fakeClickEvent(r),e.highlightExportItem(0)),n.response.success}});var seriesTypes$4=SeriesRegistry$1.seriesTypes,doc$a=H.doc,defined$o=Utilities.defined,extend$T=Utilities.extend,fireEvent$e=Utilities.fireEvent,getPointFromXY=ChartUtilities.getPointFromXY,getSeriesFromName=ChartUtilities.getSeriesFromName,scrollToPoint=ChartUtilities.scrollToPoint;Series$e.prototype.keyboardMoveVertical=!0;["column","pie"].forEach(function(n){seriesTypes$4[n]&&(seriesTypes$4[n].prototype.keyboardMoveVertical=!1)});function getPointIndex(n){var e=n.index,t=n.series.points,r=t.length;if(t[e]!==n){for(;r--;)if(t[r]===n)return r}else return e}function isSkipSeries(n){var e=n.chart.options.accessibility,t=e.keyboardNavigation.seriesNavigation,r=n.options.accessibility||{},o=r.keyboardNavigation;return o&&o.enabled===!1||r.enabled===!1||n.options.enableMouseTracking===!1||!n.visible||t.pointNavigationEnabledThreshold&&t.pointNavigationEnabledThreshold<=n.points.length}function isSkipPoint(n){var e=n.series.chart.options.accessibility,t=n.options.accessibility&&n.options.accessibility.enabled===!1;return n.isNull&&e.keyboardNavigation.seriesNavigation.skipNullPoints||n.visible===!1||n.isInside===!1||t||isSkipSeries(n.series)}function getClosestPoint(n,e,t,r){var o=1/0,s,a,l,h=e.points.length,d=function(c){return!(defined$o(c.plotX)&&defined$o(c.plotY))};if(!d(n)){for(;h--;)s=e.points[h],!d(s)&&(l=(n.plotX-s.plotX)*(n.plotX-s.plotX)*t+(n.plotY-s.plotY)*(n.plotY-s.plotY)*1,l<o&&(o=l,a=h));return defined$o(a)?e.points[a]:void 0}}Point$2.prototype.highlight=function(){var n=this.series.chart;return this.isNull?n.tooltip&&n.tooltip.hide(0):this.onMouseOver(),scrollToPoint(this),this.graphic&&n.setFocusToElement(this.graphic),n.highlightedPoint=this,this};Chart$1.prototype.highlightAdjacentPoint=function(n){var e=this,t=e.series,r=e.highlightedPoint,o=r&&getPointIndex(r)||0,s=r&&r.series.points,a=e.series&&e.series[e.series.length-1],l=a&&a.points&&a.points[a.points.length-1],h,d;if(!t[0]||!t[0].points)return!1;if(!r)d=n?t[0].points[0]:l;else if(h=t[r.series.index+(n?1:-1)],d=s[o+(n?1:-1)],!d&&h&&(d=h.points[n?0:h.points.length-1]),!d)return!1;return isSkipPoint(d)?(h=d.series,isSkipSeries(h)?e.highlightedPoint=n?h.points[h.points.length-1]:h.points[0]:e.highlightedPoint=d,e.highlightAdjacentPoint(n)):d.highlight()};Series$e.prototype.highlightFirstValidPoint=function(){var n=this.chart.highlightedPoint,e=(n&&n.series)===this?getPointIndex(n):0,t=this.points,r=t.length;if(t&&r){for(var o=e;o<r;++o)if(!isSkipPoint(t[o]))return t[o].highlight();for(var s=e;s>=0;--s)if(!isSkipPoint(t[s]))return t[s].highlight()}return!1};Chart$1.prototype.highlightAdjacentSeries=function(n){var e=this,t=e.highlightedPoint,r=e.series&&e.series[e.series.length-1],o=r&&r.points&&r.points[r.points.length-1],s,a,l;return e.highlightedPoint?(s=e.series[t.series.index+(n?-1:1)],!s||(a=getClosestPoint(t,s,4),!a)?!1:isSkipSeries(s)?(a.highlight(),l=e.highlightAdjacentSeries(n),l||(t.highlight(),!1)):(a.highlight(),a.series.highlightFirstValidPoint())):(s=n?e.series&&e.series[0]:r,a=n?s&&s.points&&s.points[0]:o,a?a.highlight():!1)};Chart$1.prototype.highlightAdjacentPointVertical=function(n){var e=this.highlightedPoint,t=1/0,r;return!defined$o(e.plotX)||!defined$o(e.plotY)?!1:(this.series.forEach(function(o){isSkipSeries(o)||o.points.forEach(function(s){if(!(!defined$o(s.plotY)||!defined$o(s.plotX)||s===e)){var a=s.plotY-e.plotY,l=Math.abs(s.plotX-e.plotX),h=Math.abs(a)*Math.abs(a)+l*l*4;o.yAxis&&o.yAxis.reversed&&(a*=-1),!(a<=0&&n||a>=0&&!n||h<5||isSkipPoint(s))&&h<t&&(t=h,r=s)}})}),r?r.highlight():!1)};function highlightFirstValidPointInChart(n){var e=!1;return delete n.highlightedPoint,e=n.series.reduce(function(t,r){return t||r.highlightFirstValidPoint()},!1),e}function highlightLastValidPointInChart(n){for(var e=n.series.length,t=e,r=!1;t--&&(n.highlightedPoint=n.series[t].points[n.series[t].points.length-1],r=n.series[t].highlightFirstValidPoint(),!r););return r}function updateChartFocusAfterDrilling(n){highlightFirstValidPointInChart(n),n.focusElement&&n.focusElement.removeFocusBorder()}function SeriesKeyboardNavigation(n,e){this.keyCodes=e,this.chart=n}extend$T(SeriesKeyboardNavigation.prototype,{init:function(){var n=this,e=this.chart,t=this.eventProvider=new EventProvider;t.addEvent(Series$e,"destroy",function(){return n.onSeriesDestroy(this)}),t.addEvent(e,"afterDrilldown",function(){updateChartFocusAfterDrilling(this)}),t.addEvent(e,"drilldown",function(r){var o=r.point,s=o.series;n.lastDrilledDownPoint={x:o.x,y:o.y,seriesName:s?s.name:""}}),t.addEvent(e,"drillupall",function(){setTimeout(function(){n.onDrillupAll()},10)}),t.addEvent(Point$2,"afterSetState",function(){var r=this,o=r.graphic&&r.graphic.element;e.highlightedPoint===r&&doc$a.activeElement!==o&&o&&o.focus&&o.focus()})},onDrillupAll:function(){var n=this.lastDrilledDownPoint,e=this.chart,t=n&&getSeriesFromName(e,n.seriesName),r;n&&t&&defined$o(n.x)&&defined$o(n.y)&&(r=getPointFromXY(t,n.x,n.y)),e.container&&e.container.focus(),r&&r.highlight&&r.highlight(),e.focusElement&&e.focusElement.removeFocusBorder()},getKeyboardNavigationHandler:function(){var n=this,e=this.keyCodes,t=this.chart,r=t.inverted;return new KeyboardNavigationHandler(t,{keyCodeMap:[[r?[e.up,e.down]:[e.left,e.right],function(o){return n.onKbdSideways(this,o)}],[r?[e.left,e.right]:[e.up,e.down],function(o){return n.onKbdVertical(this,o)}],[[e.enter,e.space],function(o,s){var a=t.highlightedPoint;return a&&(s.point=a,fireEvent$e(a.series,"click",s),a.firePointEvent("click")),this.response.success}]],init:function(o){return n.onHandlerInit(this,o)},terminate:function(){return n.onHandlerTerminate()}})},onKbdSideways:function(n,e){var t=this.keyCodes,r=e===t.right||e===t.down;return this.attemptHighlightAdjacentPoint(n,r)},onKbdVertical:function(n,e){var t=this.chart,r=this.keyCodes,o=e===r.down||e===r.right,s=t.options.accessibility.keyboardNavigation.seriesNavigation;if(s.mode&&s.mode==="serialize")return this.attemptHighlightAdjacentPoint(n,o);var a=t.highlightedPoint&&t.highlightedPoint.series.keyboardMoveVertical?"highlightAdjacentPointVertical":"highlightAdjacentSeries";return t[a](o),n.response.success},onHandlerInit:function(n,e){var t=this.chart;return e>0?highlightFirstValidPointInChart(t):highlightLastValidPointInChart(t),n.response.success},onHandlerTerminate:function(){var n=this.chart;n.tooltip&&n.tooltip.hide(0);var e=n.highlightedPoint&&n.highlightedPoint.series;e&&e.onMouseOut&&e.onMouseOut(),n.highlightedPoint&&n.highlightedPoint.onMouseOut&&n.highlightedPoint.onMouseOut(),delete n.highlightedPoint},attemptHighlightAdjacentPoint:function(n,e){var t=this.chart,r=t.options.accessibility.keyboardNavigation.wrapAround,o=t.highlightAdjacentPoint(e);return o?n.response.success:r?n.init(e?1:-1):n.response[e?"next":"prev"]},onSeriesDestroy:function(n){var e=this.chart,t=e.highlightedPoint&&e.highlightedPoint.series===n;t&&(delete e.highlightedPoint,e.focusElement&&e.focusElement.removeFocusBorder())},destroy:function(){this.eventProvider.removeAddedEvents()}});var escapeStringForHTML=HTMLUtilities.escapeStringForHTML,stripHTMLTagsFromString$1=HTMLUtilities.stripHTMLTagsFromString;function getChartAnnotationLabels(n){var e=n.annotations||[];return e.reduce(function(t,r){return r.options&&r.options.visible!==!1&&(t=t.concat(r.labels)),t},[])}function getLabelText(n){return n.options&&n.options.accessibility&&n.options.accessibility.description||n.graphic&&n.graphic.text&&n.graphic.text.textStr||""}function getAnnotationLabelDescription(n){var e=n.options&&n.options.accessibility&&n.options.accessibility.description;if(e)return e;var t=n.chart,r=getLabelText(n),o=n.points,s=function(f){return f.graphic&&f.graphic.element&&f.graphic.element.getAttribute("aria-label")||""},a=function(f){var u=f.accessibility&&f.accessibility.valueDescription||s(f),g=f&&f.series.name||"";return(g?g+", ":"")+"data point "+u},l=o.filter(function(f){return!!f.graphic}).map(a).filter(function(f){return!!f}),h=l.length,d=h>1?"MultiplePoints":h?"SinglePoint":"NoPoints",c="accessibility.screenReaderSection.annotations.description"+d,p={annotationText:r,annotation:n,numPoints:h,annotationPoint:l[0],additionalAnnotationPoints:l.slice(1)};return t.langFormat(c,p)}function getAnnotationListItems(n){var e=getChartAnnotationLabels(n);return e.map(function(t){var r=escapeStringForHTML(stripHTMLTagsFromString$1(getAnnotationLabelDescription(t)));return r?"<li>"+r+"</li>":""})}function getAnnotationsInfoHTML$1(n){var e=n.annotations;if(!(e&&e.length))return"";var t=getAnnotationListItems(n);return'<ul style="list-style-type: none">'+t.join(" ")+"</ul>"}function getPointAnnotationTexts$1(n){var e=getChartAnnotationLabels(n.series.chart),t=e.filter(function(r){return r.points.indexOf(n)>-1});return t.length?t.map(function(r){return""+getLabelText(r)}):[]}var AnnotationsA11y={getAnnotationsInfoHTML:getAnnotationsInfoHTML$1,getAnnotationLabelDescription,getAnnotationListItems,getPointAnnotationTexts:getPointAnnotationTexts$1},getPointAnnotationTexts=AnnotationsA11y.getPointAnnotationTexts,getAxisDescription$1=ChartUtilities.getAxisDescription,getSeriesFirstPointElement=ChartUtilities.getSeriesFirstPointElement,getSeriesA11yElement=ChartUtilities.getSeriesA11yElement,unhideChartElementFromAT$4=ChartUtilities.unhideChartElementFromAT,format$5=FormatUtilities.format,numberFormat=FormatUtilities.numberFormat,reverseChildNodes=HTMLUtilities.reverseChildNodes,stripHTMLTags$1=HTMLUtilities.stripHTMLTagsFromString,find$6=Utilities.find,isNumber$l=Utilities.isNumber,pick$T=Utilities.pick,defined$n=Utilities.defined;function findFirstPointWithGraphic(n){var e=n.index;return!n.series||!n.series.data||!defined$n(e)?null:find$6(n.series.data,function(t){return!!(t&&typeof t.index<"u"&&t.index>e&&t.graphic&&t.graphic.element)})||null}function shouldAddDummyPoint(n){var e=n.series&&n.series.is("sunburst"),t=n.isNull;return t&&!e}function makeDummyElement(n,e){var t=n.series.chart.renderer,r=t.rect(e.x,e.y,1,1);return r.attr({class:"highcharts-a11y-dummy-point",fill:"none",opacity:0,"fill-opacity":0,"stroke-opacity":0}),r}function addDummyPointElement(n){var e=n.series,t=findFirstPointWithGraphic(n),r=t&&t.graphic,o=r?r.parentGroup:e.graph||e.group,s=t?{x:pick$T(n.plotX,t.plotX,0),y:pick$T(n.plotY,t.plotY,0)}:{x:pick$T(n.plotX,0),y:pick$T(n.plotY,0)},a=makeDummyElement(n,s);if(o&&o.element)return n.graphic=a,n.hasDummyGraphic=!0,a.add(o),o.element.insertBefore(a.element,r?r.element:null),a.element}function hasMorePointsThanDescriptionThreshold(n){var e=n.chart.options.accessibility,t=e.series.pointDescriptionEnabledThreshold;return!!(t!==!1&&n.points&&n.points.length>=t)}function shouldSetScreenReaderPropsOnPoints(n){var e=n.options.accessibility||{};return!hasMorePointsThanDescriptionThreshold(n)&&!e.exposeAsGroupOnly}function shouldSetKeyboardNavPropsOnPoints(n){var e=n.chart.options.accessibility,t=e.keyboardNavigation.seriesNavigation;return!!(n.points&&(n.points.length<t.pointNavigationEnabledThreshold||t.pointNavigationEnabledThreshold===!1))}function shouldDescribeSeriesElement(n){var e=n.chart,t=e.options.chart,r=t.options3d&&t.options3d.enabled,o=e.series.length>1,s=e.options.accessibility.series.describeSingleSeries,a=(n.options.accessibility||{}).exposeAsGroupOnly,l=r&&o;return!l&&(o||s||a||hasMorePointsThanDescriptionThreshold(n))}function pointNumberToString(n,e){var t=n.series.chart,r=t.options.accessibility.point||{},o=n.series.tooltipOptions||{},s=t.options.lang;return isNumber$l(e)?numberFormat(e,r.valueDecimals||o.valueDecimals||-1,s.decimalPoint,s.accessibility.thousandsSep||s.thousandsSep):e}function getSeriesDescriptionText(n){var e=n.options.accessibility||{},t=e.description;return t&&n.chart.langFormat("accessibility.series.description",{description:t,series:n})||""}function getSeriesAxisDescriptionText(n,e){var t=n[e];return n.chart.langFormat("accessibility.series."+e+"Description",{name:getAxisDescription$1(t),series:n})}function getPointA11yTimeDescription(n){var e=n.series,t=e.chart,r=t.options.accessibility.point||{},o=e.xAxis&&e.xAxis.dateTime;if(o){var s=o.getXDateFormat(n.x||0,t.options.tooltip.dateTimeLabelFormats),a=r.dateFormatter&&r.dateFormatter(n)||r.dateFormat||s;return t.time.dateFormat(a,n.x||0,void 0)}}function getPointXDescription(n){var e=getPointA11yTimeDescription(n),t=n.series.xAxis||{},r=t.categories&&defined$n(n.category)&&(""+n.category).replace("<br/>"," "),o=n.id&&n.id.indexOf("highcharts-")<0,s="x, "+n.x;return n.name||e||r||(o?n.id:s)}function getPointArrayMapValueDescription(n,e,t){var r=e||"",o=t||"",s=function(l){var h=pointNumberToString(n,pick$T(n[l],n.options[l]));return l+": "+r+h+o},a=n.series.pointArrayMap;return a.reduce(function(l,h){return l+(l.length?", ":"")+s(h)},"")}function getPointValue(n){var e=n.series,t=e.chart.options.accessibility.point||{},r=e.tooltipOptions||{},o=t.valuePrefix||r.valuePrefix||"",s=t.valueSuffix||r.valueSuffix||"",a=typeof n.value<"u"?"value":"y",l=pointNumberToString(n,n[a]);return n.isNull?e.chart.langFormat("accessibility.series.nullPointValue",{point:n}):e.pointArrayMap?getPointArrayMapValueDescription(n,o,s):o+l+s}function getPointAnnotationDescription(n){var e=n.series.chart,t="accessibility.series.pointAnnotationsDescription",r=getPointAnnotationTexts(n),o={point:n,annotations:r};return r.length?e.langFormat(t,o):""}function getPointValueDescription(n){var e=n.series,t=e.chart,r=t.options.accessibility.point.valueDescriptionFormat,o=pick$T(e.xAxis&&e.xAxis.options.accessibility&&e.xAxis.options.accessibility.enabled,!t.angular),s=o?getPointXDescription(n):"",a={point:n,index:defined$n(n.index)?n.index+1:"",xDescription:s,value:getPointValue(n),separator:o?", ":""};return format$5(r,a,t)}function defaultPointDescriptionFormatter$1(n){var e=n.series,t=e.chart,r=getPointValueDescription(n),o=n.options&&n.options.accessibility&&n.options.accessibility.description,s=o?" "+o:"",a=t.series.length>1&&e.name?" "+e.name+".":"",l=getPointAnnotationDescription(n),h=l?" "+l:"";return n.accessibility=n.accessibility||{},n.accessibility.valueDescription=r,r+s+a+h}function setPointScreenReaderAttribs(n,e){var t=n.series,r=t.chart.options.accessibility.point||{},o=t.options.accessibility||{},s=stripHTMLTags$1(o.pointDescriptionFormatter&&o.pointDescriptionFormatter(n)||r.descriptionFormatter&&r.descriptionFormatter(n)||defaultPointDescriptionFormatter$1(n));e.setAttribute("role","img"),e.setAttribute("aria-label",s)}function describePointsInSeries(n){var e=shouldSetScreenReaderPropsOnPoints(n),t=shouldSetKeyboardNavPropsOnPoints(n);(e||t)&&n.points.forEach(function(r){var o=r.graphic&&r.graphic.element||shouldAddDummyPoint(r)&&addDummyPointElement(r),s=r.options&&r.options.accessibility&&r.options.accessibility.enabled===!1;o&&(o.setAttribute("tabindex","-1"),o.style.outline="0",e&&!s?setPointScreenReaderAttribs(r,o):o.setAttribute("aria-hidden",!0))})}function defaultSeriesDescriptionFormatter$1(n){var e=n.chart,t=e.types||[],r=getSeriesDescriptionText(n),o=function(c){return e[c]&&e[c].length>1&&n[c]},s=getSeriesAxisDescriptionText(n,"xAxis"),a=getSeriesAxisDescriptionText(n,"yAxis"),l={name:n.name||"",ix:n.index+1,numSeries:e.series&&e.series.length,numPoints:n.points&&n.points.length,series:n},h=t.length>1?"Combination":"",d=e.langFormat("accessibility.series.summary."+n.type+h,l)||e.langFormat("accessibility.series.summary.default"+h,l);return d+(r?" "+r:"")+(o("yAxis")?" "+a:"")+(o("xAxis")?" "+s:"")}function describeSeriesElement(n,e){var t=n.options.accessibility||{},r=n.chart.options.accessibility,o=r.landmarkVerbosity;t.exposeAsGroupOnly?e.setAttribute("role","img"):o==="all"&&e.setAttribute("role","region"),e.setAttribute("tabindex","-1"),e.style.outline="0",e.setAttribute("aria-label",stripHTMLTags$1(r.series.descriptionFormatter&&r.series.descriptionFormatter(n)||defaultSeriesDescriptionFormatter$1(n)))}function describeSeries$1(n){var e=n.chart,t=getSeriesFirstPointElement(n),r=getSeriesA11yElement(n),o=e.is3d&&e.is3d();r&&(r.lastChild===t&&!o&&reverseChildNodes(r),describePointsInSeries(n),unhideChartElementFromAT$4(e,r),shouldDescribeSeriesElement(n)?describeSeriesElement(n,r):r.setAttribute("aria-label",""))}var SeriesDescriber={describeSeries:describeSeries$1,defaultPointDescriptionFormatter:defaultPointDescriptionFormatter$1,defaultSeriesDescriptionFormatter:defaultSeriesDescriptionFormatter$1,getPointA11yTimeDescription,getPointXDescription,getPointValue,getPointValueDescription},doc$9=H.doc,setElAttrs$3=HTMLUtilities.setElAttrs,visuallyHideElement$1=HTMLUtilities.visuallyHideElement,Announcer=function(){function n(e,t){this.chart=e,this.domElementProvider=new DOMElementProvider,this.announceRegion=this.addAnnounceRegion(t)}return n.prototype.destroy=function(){this.domElementProvider.destroyCreatedElements()},n.prototype.announce=function(e){var t=this;AST.setElementHTML(this.announceRegion,e),this.clearAnnouncementRegionTimer&&clearTimeout(this.clearAnnouncementRegionTimer),this.clearAnnouncementRegionTimer=setTimeout(function(){t.announceRegion.innerHTML="",delete t.clearAnnouncementRegionTimer},1e3)},n.prototype.addAnnounceRegion=function(e){var t=this.chart.announcerContainer||this.createAnnouncerContainer(),r=this.domElementProvider.createElement("div");return setElAttrs$3(r,{"aria-hidden":!1,"aria-live":e}),visuallyHideElement$1(r),t.appendChild(r),r},n.prototype.createAnnouncerContainer=function(){var e=this.chart,t=doc$9.createElement("div");return setElAttrs$3(t,{"aria-hidden":!1,style:"position:relative",class:"highcharts-announcer-container"}),e.renderTo.insertBefore(t,e.renderTo.firstChild),e.announcerContainer=t,t},n}(),extend$S=Utilities.extend,defined$m=Utilities.defined,getChartTitle$2=ChartUtilities.getChartTitle,defaultPointDescriptionFormatter=SeriesDescriber.defaultPointDescriptionFormatter,defaultSeriesDescriptionFormatter=SeriesDescriber.defaultSeriesDescriptionFormatter;function chartHasAnnounceEnabled(n){return!!n.options.accessibility.announceNewData.enabled}function findPointInDataArray(n){var e=n.series.data.filter(function(t){return n.x===t.x&&n.y===t.y});return e.length===1?e[0]:n}function getUniqueSeries(n,e){var t=(n||[]).concat(e||[]).reduce(function(r,o){return r[o.name+o.index]=o,r},{});return Object.keys(t).map(function(r){return t[r]})}var NewDataAnnouncer=function(n){this.chart=n};extend$S(NewDataAnnouncer.prototype,{init:function(){var n=this.chart,e=n.options.accessibility.announceNewData,t=e.interruptUser?"assertive":"polite";this.lastAnnouncementTime=0,this.dirty={allSeries:{}},this.eventProvider=new EventProvider,this.announcer=new Announcer(n,t),this.addEventListeners()},destroy:function(){this.eventProvider.removeAddedEvents(),this.announcer.destroy()},addEventListeners:function(){var n=this,e=this.chart,t=this.eventProvider;t.addEvent(e,"afterDrilldown",function(){n.lastAnnouncementTime=0}),t.addEvent(Series$e,"updatedData",function(){n.onSeriesUpdatedData(this)}),t.addEvent(e,"afterAddSeries",function(r){n.onSeriesAdded(r.series)}),t.addEvent(Series$e,"addPoint",function(r){n.onPointAdded(r.point)}),t.addEvent(e,"redraw",function(){n.announceDirtyData()})},onSeriesUpdatedData:function(n){var e=this.chart;n.chart===e&&chartHasAnnounceEnabled(e)&&(this.dirty.hasDirty=!0,this.dirty.allSeries[n.name+n.index]=n)},onSeriesAdded:function(n){chartHasAnnounceEnabled(this.chart)&&(this.dirty.hasDirty=!0,this.dirty.allSeries[n.name+n.index]=n,this.dirty.newSeries=defined$m(this.dirty.newSeries)?void 0:n)},onPointAdded:function(n){var e=n.series.chart;this.chart===e&&chartHasAnnounceEnabled(e)&&(this.dirty.newPoint=defined$m(this.dirty.newPoint)?void 0:n)},announceDirtyData:function(){var n=this.chart,e=this;if(n.options.accessibility.announceNewData&&this.dirty.hasDirty){var t=this.dirty.newPoint;t&&(t=findPointInDataArray(t)),this.queueAnnouncement(Object.keys(this.dirty.allSeries).map(function(r){return e.dirty.allSeries[r]}),this.dirty.newSeries,t),this.dirty={allSeries:{}}}},queueAnnouncement:function(n,e,t){var r=this,o=this.chart,s=o.options.accessibility.announceNewData;if(s.enabled){var a=+new Date,l=a-this.lastAnnouncementTime,h=Math.max(0,s.minAnnounceInterval-l),d=getUniqueSeries(this.queuedAnnouncement&&this.queuedAnnouncement.series,n),c=this.buildAnnouncementMessage(d,e,t);c&&(this.queuedAnnouncement&&clearTimeout(this.queuedAnnouncementTimer),this.queuedAnnouncement={time:a,message:c,series:d},this.queuedAnnouncementTimer=setTimeout(function(){r&&r.announcer&&(r.lastAnnouncementTime=+new Date,r.announcer.announce(r.queuedAnnouncement.message),delete r.queuedAnnouncement,delete r.queuedAnnouncementTimer)},h))}},buildAnnouncementMessage:function(n,e,t){var r=this.chart,o=r.options.accessibility.announceNewData;if(o.announcementFormatter){var s=o.announcementFormatter(n,e,t);if(s!==!1)return s.length?s:null}var a=H.charts&&H.charts.length>1?"Multiple":"Single",l=e?"newSeriesAnnounce"+a:t?"newPointAnnounce"+a:"newDataAnnounce",h=getChartTitle$2(r);return r.langFormat("accessibility.announceNewData."+l,{chartTitle:h,seriesDesc:e?defaultSeriesDescriptionFormatter(e):null,pointDesc:t?defaultPointDescriptionFormatter(t):null,point:t,series:e})}});var addEvent$z=Utilities.addEvent,merge$M=Utilities.merge;function isWithinDescriptionThreshold(n){var e=n.chart.options.accessibility;return n.points.length<e.series.pointDescriptionEnabledThreshold||e.series.pointDescriptionEnabledThreshold===!1}function shouldForceMarkers(n){var e=n.chart,t=e.options.accessibility.enabled,r=(n.options.accessibility&&n.options.accessibility.enabled)!==!1;return t&&r&&isWithinDescriptionThreshold(n)}function hasIndividualPointMarkerOptions(n){return!!(n._hasPointMarkers&&n.points&&n.points.length)}function unforceSeriesMarkerOptions(n){var e=n.resetA11yMarkerOptions;e&&merge$M(!0,n.options,{marker:{enabled:e.enabled,states:{normal:{opacity:e.states&&e.states.normal&&e.states.normal.opacity}}}})}function forceZeroOpacityMarkerOptions(n){merge$M(!0,n,{marker:{enabled:!0,states:{normal:{opacity:0}}}})}function getPointMarkerOpacity(n){return n.marker.states&&n.marker.states.normal&&n.marker.states.normal.opacity||1}function unforcePointMarkerOptions(n){merge$M(!0,n.marker,{states:{normal:{opacity:getPointMarkerOpacity(n)}}})}function handleForcePointMarkers(n){for(var e=n.points.length;e--;){var t=n.points[e],r=t.options;delete t.hasForcedA11yMarker,r.marker&&(r.marker.enabled?(unforcePointMarkerOptions(r),t.hasForcedA11yMarker=!1):(forceZeroOpacityMarkerOptions(r),t.hasForcedA11yMarker=!0))}}function addForceMarkersEvents(){addEvent$z(Series$e,"render",function(){var n=this,e=n.options;shouldForceMarkers(n)?(e.marker&&e.marker.enabled===!1&&(n.a11yMarkersForced=!0,forceZeroOpacityMarkerOptions(n.options)),hasIndividualPointMarkerOptions(n)&&handleForcePointMarkers(n)):n.a11yMarkersForced&&(delete n.a11yMarkersForced,unforceSeriesMarkerOptions(n))}),addEvent$z(Series$e,"afterSetOptions",function(n){this.resetA11yMarkerOptions=merge$M(n.options.marker||{},this.userOptions.marker||{})}),addEvent$z(Series$e,"afterRender",function(){var n=this;n.chart.styledMode&&(n.markerGroup&&n.markerGroup[n.a11yMarkersForced?"addClass":"removeClass"]("highcharts-a11y-markers-hidden"),hasIndividualPointMarkerOptions(n)&&n.points.forEach(function(e){e.graphic&&(e.graphic[e.hasForcedA11yMarker?"addClass":"removeClass"]("highcharts-a11y-marker-hidden"),e.graphic[e.hasForcedA11yMarker===!1?"addClass":"removeClass"]("highcharts-a11y-marker-visible"))}))})}var extend$R=Utilities.extend,hideSeriesFromAT=ChartUtilities.hideSeriesFromAT,describeSeries=SeriesDescriber.describeSeries;H.SeriesAccessibilityDescriber=SeriesDescriber;addForceMarkersEvents();var SeriesComponent=function(){};SeriesComponent.prototype=new AccessibilityComponent;extend$R(SeriesComponent.prototype,{init:function(){this.newDataAnnouncer=new NewDataAnnouncer(this.chart),this.newDataAnnouncer.init(),this.keyboardNavigation=new SeriesKeyboardNavigation(this.chart,this.keyCodes),this.keyboardNavigation.init(),this.hideTooltipFromATWhenShown(),this.hideSeriesLabelsFromATWhenShown()},hideTooltipFromATWhenShown:function(){var n=this;this.addEvent(Tooltip,"refresh",function(){this.chart===n.chart&&this.label&&this.label.element&&this.label.element.setAttribute("aria-hidden",!0)})},hideSeriesLabelsFromATWhenShown:function(){this.addEvent(this.chart,"afterDrawSeriesLabels",function(){this.series.forEach(function(n){n.labelBySeries&&n.labelBySeries.attr("aria-hidden",!0)})})},onChartRender:function(){var n=this.chart;n.series.forEach(function(e){var t=(e.options.accessibility&&e.options.accessibility.enabled)!==!1&&e.visible;t?describeSeries(e):hideSeriesFromAT(e)})},getKeyboardNavigation:function(){return this.keyboardNavigation.getKeyboardNavigationHandler()},destroy:function(){this.newDataAnnouncer.destroy(),this.keyboardNavigation.destroy()}});var unhideChartElementFromAT$3=ChartUtilities.unhideChartElementFromAT,noop$d=H.noop,removeElement=HTMLUtilities.removeElement,setElAttrs$2=HTMLUtilities.setElAttrs,extend$Q=Utilities.extend,pick$S=Utilities.pick;function chartHasMapZoom(n){return!!(n.mapZoom&&n.mapNavButtons&&n.mapNavButtons.length)}H.Axis.prototype.panStep=function(n,e){var t=e||3,r=this.getExtremes(),o=(r.max-r.min)/t*n,s=r.max+o,a=r.min+o,l=s-a;n<0&&a<r.dataMin?(a=r.dataMin,s=a+l):n>0&&s>r.dataMax&&(s=r.dataMax,a=s-l),this.setExtremes(a,s)};var ZoomComponent=noop$d;ZoomComponent.prototype=new AccessibilityComponent;extend$Q(ZoomComponent.prototype,{init:function(){var n=this,e=this.chart;["afterShowResetZoom","afterDrilldown","drillupall"].forEach(function(t){n.addEvent(e,t,function(){n.updateProxyOverlays()})})},onChartUpdate:function(){var n=this.chart,e=this;n.mapNavButtons&&n.mapNavButtons.forEach(function(t,r){unhideChartElementFromAT$3(n,t.element),e.setMapNavButtonAttrs(t.element,"accessibility.zoom.mapZoom"+(r?"Out":"In"))})},setMapNavButtonAttrs:function(n,e){var t=this.chart,r=t.langFormat(e,{chart:t});setElAttrs$2(n,{tabindex:-1,role:"button","aria-label":r})},onChartRender:function(){this.updateProxyOverlays()},updateProxyOverlays:function(){var n=this.chart;removeElement(this.drillUpProxyGroup),removeElement(this.resetZoomProxyGroup),n.resetZoomButton&&this.recreateProxyButtonAndGroup(n.resetZoomButton,"resetZoomProxyButton","resetZoomProxyGroup",n.langFormat("accessibility.zoom.resetZoomButton",{chart:n})),n.drillUpButton&&this.recreateProxyButtonAndGroup(n.drillUpButton,"drillUpProxyButton","drillUpProxyGroup",n.langFormat("accessibility.drillUpButton",{chart:n,buttonText:n.getDrilldownBackText()}))},recreateProxyButtonAndGroup:function(n,e,t,r){removeElement(this[t]),this[t]=this.addProxyGroup(),this[e]=this.createProxyButton(n,this[t],{"aria-label":r,tabindex:-1})},getMapZoomNavigation:function(){var n=this.keyCodes,e=this.chart,t=this;return new KeyboardNavigationHandler(e,{keyCodeMap:[[[n.up,n.down,n.left,n.right],function(r){return t.onMapKbdArrow(this,r)}],[[n.tab],function(r,o){return t.onMapKbdTab(this,o)}],[[n.space,n.enter],function(){return t.onMapKbdClick(this)}]],validate:function(){return chartHasMapZoom(e)},init:function(r){return t.onMapNavInit(r)}})},onMapKbdArrow:function(n,e){var t=this.keyCodes,r=e===t.up||e===t.down?"yAxis":"xAxis",o=e===t.left||e===t.up?-1:1;return this.chart[r][0].panStep(o),n.response.success},onMapKbdTab:function(n,e){var t,r=this.chart,o=n.response,s=e.shiftKey,a=s&&!this.focusedMapNavButtonIx||!s&&this.focusedMapNavButtonIx;return r.mapNavButtons[this.focusedMapNavButtonIx].setState(0),a?(r.mapZoom(),o[s?"prev":"next"]):(this.focusedMapNavButtonIx+=s?-1:1,t=r.mapNavButtons[this.focusedMapNavButtonIx],r.setFocusToElement(t.box,t.element),t.setState(2),o.success)},onMapKbdClick:function(n){return this.fakeClickEvent(this.chart.mapNavButtons[this.focusedMapNavButtonIx].element),n.response.success},onMapNavInit:function(n){var e=this.chart,t=e.mapNavButtons[0],r=e.mapNavButtons[1],o=n>0?t:r;e.setFocusToElement(o.box,o.element),o.setState(2),this.focusedMapNavButtonIx=n>0?0:1},simpleButtonNavigation:function(n,e,t){var r=this.keyCodes,o=this,s=this.chart;return new KeyboardNavigationHandler(s,{keyCodeMap:[[[r.tab,r.up,r.down,r.left,r.right],function(a,l){var h=a===r.tab&&l.shiftKey||a===r.left||a===r.up;return this.response[h?"prev":"next"]}],[[r.space,r.enter],function(){var a=t(this,s);return pick$S(a,this.response.success)}]],validate:function(){var a=s[n]&&s[n].box&&o[e];return a},init:function(){s.setFocusToElement(s[n].box,o[e])}})},getKeyboardNavigation:function(){return[this.simpleButtonNavigation("resetZoomButton","resetZoomProxyButton",function(n,e){e.zoomOut()}),this.simpleButtonNavigation("drillUpButton","drillUpProxyButton",function(n,e){return e.drillUp(),n.response.prev}),this.getMapZoomNavigation()]}});var unhideChartElementFromAT$2=ChartUtilities.unhideChartElementFromAT,getAxisRangeDescription$1=ChartUtilities.getAxisRangeDescription,setElAttrs$1=HTMLUtilities.setElAttrs,addEvent$y=Utilities.addEvent,extend$P=Utilities.extend;function shouldRunInputNavigation(n){return!!(n.rangeSelector&&n.rangeSelector.inputGroup&&n.rangeSelector.inputGroup.element.getAttribute("visibility")!=="hidden"&&n.options.rangeSelector.inputEnabled!==!1&&n.rangeSelector.minInput&&n.rangeSelector.maxInput)}Chart$1.prototype.highlightRangeSelectorButton=function(n){var e=this.rangeSelector&&this.rangeSelector.buttons||[],t=this.highlightedRangeSelectorItemIx,r=this.rangeSelector&&this.rangeSelector.selected;return typeof t<"u"&&e[t]&&t!==r&&e[t].setState(this.oldRangeSelectorItemState||0),this.highlightedRangeSelectorItemIx=n,e[n]?(this.setFocusToElement(e[n].box,e[n].element),n!==r&&(this.oldRangeSelectorItemState=e[n].state,e[n].setState(1)),!0):!1};addEvent$y(RangeSelector,"afterBtnClick",function(){if(this.chart.accessibility&&this.chart.accessibility.components.rangeSelector)return this.chart.accessibility.components.rangeSelector.onAfterBtnClick()});var RangeSelectorComponent=function(){};RangeSelectorComponent.prototype=new AccessibilityComponent;extend$P(RangeSelectorComponent.prototype,{init:function(){var n=this.chart;this.announcer=new Announcer(n,"polite")},onChartUpdate:function(){var n=this.chart,e=this,t=n.rangeSelector;t&&(this.updateSelectorVisibility(),this.setDropdownAttrs(),t.buttons&&t.buttons.length&&t.buttons.forEach(function(r){e.setRangeButtonAttrs(r)}),t.maxInput&&t.minInput&&["minInput","maxInput"].forEach(function(r,o){var s=t[r];s&&(unhideChartElementFromAT$2(n,s),e.setRangeInputAttrs(s,"accessibility.rangeSelector."+(o?"max":"min")+"InputLabel"))}))},updateSelectorVisibility:function(){var n=this.chart,e=n.rangeSelector,t=e&&e.dropdown,r=e&&e.buttons||[],o=function(s){return s.setAttribute("aria-hidden",!0)};e&&e.hasVisibleDropdown&&t?(unhideChartElementFromAT$2(n,t),r.forEach(function(s){return o(s.element)})):(t&&o(t),r.forEach(function(s){return unhideChartElementFromAT$2(n,s.element)}))},setDropdownAttrs:function(){var n=this.chart,e=n.rangeSelector&&n.rangeSelector.dropdown;if(e){var t=n.langFormat("accessibility.rangeSelector.dropdownLabel",{rangeTitle:n.options.lang.rangeSelectorZoom});e.setAttribute("aria-label",t),e.setAttribute("tabindex",-1)}},setRangeButtonAttrs:function(n){setElAttrs$1(n.element,{tabindex:-1,role:"button"})},setRangeInputAttrs:function(n,e){var t=this.chart;setElAttrs$1(n,{tabindex:-1,"aria-label":t.langFormat(e,{chart:t})})},onButtonNavKbdArrowKey:function(n,e){var t=n.response,r=this.keyCodes,o=this.chart,s=o.options.accessibility.keyboardNavigation.wrapAround,a=e===r.left||e===r.up?-1:1,l=o.highlightRangeSelectorButton(o.highlightedRangeSelectorItemIx+a);return l?t.success:s?(n.init(a),t.success):t[a>0?"next":"prev"]},onButtonNavKbdClick:function(n){var e=n.response,t=this.chart,r=t.oldRangeSelectorItemState===3;return r||this.fakeClickEvent(t.rangeSelector.buttons[t.highlightedRangeSelectorItemIx].element),e.success},onAfterBtnClick:function(){var n=this.chart,e=getAxisRangeDescription$1(n.xAxis[0]),t=n.langFormat("accessibility.rangeSelector.clickButtonAnnouncement",{chart:n,axisRangeDescription:e});t&&this.announcer.announce(t)},onInputKbdMove:function(n){var e=this.chart,t=e.rangeSelector,r=e.highlightedInputRangeIx=(e.highlightedInputRangeIx||0)+n,o=r>1||r<0;if(o)e.accessibility&&(e.accessibility.keyboardNavigation.tabindexContainer.focus(),e.accessibility.keyboardNavigation[n<0?"prev":"next"]());else if(t){var s=t[r?"maxDateBox":"minDateBox"],a=t[r?"maxInput":"minInput"];s&&a&&e.setFocusToElement(s,a)}},onInputNavInit:function(n){var e=this,t=this,r=this.chart,o=n>0?0:1,s=r.rangeSelector,a=s&&s[o?"maxDateBox":"minDateBox"],l=s&&s.minInput,h=s&&s.maxInput,d=o?h:l;if(r.highlightedInputRangeIx=o,a&&l&&h){r.setFocusToElement(a,d),this.removeInputKeydownHandler&&this.removeInputKeydownHandler();var c=function(u){var g=(u.which||u.keyCode)===e.keyCodes.tab;g&&(u.preventDefault(),u.stopPropagation(),t.onInputKbdMove(u.shiftKey?-1:1))},p=addEvent$y(l,"keydown",c),f=addEvent$y(h,"keydown",c);this.removeInputKeydownHandler=function(){p(),f()}}},onInputNavTerminate:function(){var n=this.chart.rangeSelector||{};n.maxInput&&n.hideInput("max"),n.minInput&&n.hideInput("min"),this.removeInputKeydownHandler&&(this.removeInputKeydownHandler(),delete this.removeInputKeydownHandler)},initDropdownNav:function(){var n=this,e=this.chart,t=e.rangeSelector,r=t&&t.dropdown;t&&r&&(e.setFocusToElement(t.buttonGroup,r),this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeDropdownKeydownHandler=addEvent$y(r,"keydown",function(o){var s=(o.which||o.keyCode)===n.keyCodes.tab;s&&(o.preventDefault(),o.stopPropagation(),e.accessibility&&(e.accessibility.keyboardNavigation.tabindexContainer.focus(),e.accessibility.keyboardNavigation[o.shiftKey?"prev":"next"]()))}))},getRangeSelectorButtonNavigation:function(){var n=this.chart,e=this.keyCodes,t=this;return new KeyboardNavigationHandler(n,{keyCodeMap:[[[e.left,e.right,e.up,e.down],function(r){return t.onButtonNavKbdArrowKey(this,r)}],[[e.enter,e.space],function(){return t.onButtonNavKbdClick(this)}]],validate:function(){return!!(n.rangeSelector&&n.rangeSelector.buttons&&n.rangeSelector.buttons.length)},init:function(r){var o=n.rangeSelector;if(o&&o.hasVisibleDropdown)t.initDropdownNav();else if(o){var s=o.buttons.length-1;n.highlightRangeSelectorButton(r>0?0:s)}},terminate:function(){t.removeDropdownKeydownHandler&&(t.removeDropdownKeydownHandler(),delete t.removeDropdownKeydownHandler)}})},getRangeSelectorInputNavigation:function(){var n=this.chart,e=this;return new KeyboardNavigationHandler(n,{keyCodeMap:[],validate:function(){return shouldRunInputNavigation(n)},init:function(t){e.onInputNavInit(t)},terminate:function(){e.onInputNavTerminate()}})},getKeyboardNavigation:function(){return[this.getRangeSelectorButtonNavigation(),this.getRangeSelectorInputNavigation()]},destroy:function(){this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeInputKeydownHandler&&this.removeInputKeydownHandler(),this.announcer&&this.announcer.destroy()}});var format$4=FormatUtilities.format,doc$8=H.doc,extend$O=Utilities.extend,pick$R=Utilities.pick,getAnnotationsInfoHTML=AnnotationsA11y.getAnnotationsInfoHTML,getAxisDescription=ChartUtilities.getAxisDescription,getAxisRangeDescription=ChartUtilities.getAxisRangeDescription,getChartTitle$1=ChartUtilities.getChartTitle,unhideChartElementFromAT$1=ChartUtilities.unhideChartElementFromAT,addClass=HTMLUtilities.addClass,getElement=HTMLUtilities.getElement,getHeadingTagNameForElement=HTMLUtilities.getHeadingTagNameForElement,setElAttrs=HTMLUtilities.setElAttrs,stripHTMLTagsFromString=HTMLUtilities.stripHTMLTagsFromString,visuallyHideElement=HTMLUtilities.visuallyHideElement;function stripEmptyHTMLTags(n){return n.replace(/<(\w+)[^>]*?>\s*<\/\1>/g,"")}function getTypeDescForMapChart(n,e){return e.mapTitle?n.langFormat("accessibility.chartTypes.mapTypeDescription",e):n.langFormat("accessibility.chartTypes.unknownMap",e)}function getTypeDescForCombinationChart(n,e){return n.langFormat("accessibility.chartTypes.combinationChart",e)}function getTypeDescForEmptyChart(n,e){return n.langFormat("accessibility.chartTypes.emptyChart",e)}function buildTypeDescriptionFromSeries(n,e,t){var r=e[0],o=n.langFormat("accessibility.seriesTypeDescriptions."+r,t),s=n.series&&n.series.length<2?"Single":"Multiple";return(n.langFormat("accessibility.chartTypes."+r+s,t)||n.langFormat("accessibility.chartTypes.default"+s,t))+(o?" "+o:"")}function getTableSummary(n){return n.langFormat("accessibility.table.tableSummary",{chart:n})}Chart$1.prototype.getTypeDescription=function(n){var e=n[0],t=this.series&&this.series[0]||{},r={numSeries:this.series.length,numPoints:t.points&&t.points.length,chart:this,mapTitle:t.mapTitle};return e?e==="map"?getTypeDescForMapChart(this,r):this.types.length>1?getTypeDescForCombinationChart(this,r):buildTypeDescriptionFromSeries(this,n,r):getTypeDescForEmptyChart(this,r)};var InfoRegionsComponent=function(){};InfoRegionsComponent.prototype=new AccessibilityComponent;extend$O(InfoRegionsComponent.prototype,{init:function(){var n=this.chart,e=this;this.initRegionsDefinitions(),this.addEvent(n,"aftergetTableAST",function(t){e.onDataTableCreated(t)}),this.addEvent(n,"afterViewData",function(t){e.dataTableDiv=t,setTimeout(function(){e.focusDataTable()},300)}),this.announcer=new Announcer(n,"assertive")},initRegionsDefinitions:function(){var n=this;this.screenReaderSections={before:{element:null,buildContent:function(e){var t=e.options.accessibility.screenReaderSection.beforeChartFormatter;return t?t(e):n.defaultBeforeChartFormatter(e)},insertIntoDOM:function(e,t){t.renderTo.insertBefore(e,t.renderTo.firstChild)},afterInserted:function(){typeof n.sonifyButtonId<"u"&&n.initSonifyButton(n.sonifyButtonId),typeof n.dataTableButtonId<"u"&&n.initDataTableButton(n.dataTableButtonId)}},after:{element:null,buildContent:function(e){var t=e.options.accessibility.screenReaderSection.afterChartFormatter;return t?t(e):n.defaultAfterChartFormatter()},insertIntoDOM:function(e,t){t.renderTo.insertBefore(e,t.container.nextSibling)},afterInserted:function(){n.chart.accessibility&&n.chart.accessibility.keyboardNavigation.updateExitAnchor()}}}},onChartRender:function(){var n=this;this.linkedDescriptionElement=this.getLinkedDescriptionElement(),this.setLinkedDescriptionAttrs(),Object.keys(this.screenReaderSections).forEach(function(e){n.updateScreenReaderSection(e)})},getLinkedDescriptionElement:function(){var n=this.chart.options,e=n.accessibility.linkedDescription;if(e){if(typeof e!="string")return e;var t=format$4(e,this.chart),r=doc$8.querySelectorAll(t);if(r.length===1)return r[0]}},setLinkedDescriptionAttrs:function(){var n=this.linkedDescriptionElement;n&&(n.setAttribute("aria-hidden","true"),addClass(n,"highcharts-linked-description"))},updateScreenReaderSection:function(n){var e=this.chart,t=this.screenReaderSections[n],r=t.buildContent(e),o=t.element=t.element||this.createElement("div"),s=o.firstChild||this.createElement("div");this.setScreenReaderSectionAttribs(o,n),AST.setElementHTML(s,r),o.appendChild(s),t.insertIntoDOM(o,e),visuallyHideElement(s),unhideChartElementFromAT$1(e,s),t.afterInserted&&t.afterInserted()},setScreenReaderSectionAttribs:function(n,e){var t="accessibility.screenReaderSection."+e+"RegionLabel",r=this.chart,o=r.langFormat(t,{chart:r,chartTitle:getChartTitle$1(r)}),s="highcharts-screen-reader-region-"+e+"-"+r.index;setElAttrs(n,{id:s,"aria-label":o}),n.style.position="relative",r.options.accessibility.landmarkVerbosity==="all"&&o&&n.setAttribute("role","region")},defaultBeforeChartFormatter:function(){var n=this.chart,e=n.options.accessibility.screenReaderSection.beforeChartFormat,t=this.getAxesDescription(),r=n.sonify&&n.options.sonification&&n.options.sonification.enabled,o="highcharts-a11y-sonify-data-btn-"+n.index,s="hc-linkto-highcharts-data-table-"+n.index,a=getAnnotationsInfoHTML(n),l=n.langFormat("accessibility.screenReaderSection.annotations.heading",{chart:n}),h={headingTagName:getHeadingTagNameForElement(n.renderTo),chartTitle:getChartTitle$1(n),typeDescription:this.getTypeDescriptionText(),chartSubtitle:this.getSubtitleText(),chartLongdesc:this.getLongdescText(),xAxisDescription:t.xAxis,yAxisDescription:t.yAxis,playAsSoundButton:r?this.getSonifyButtonText(o):"",viewTableButton:n.getCSV?this.getDataTableButtonText(s):"",annotationsTitle:a?l:"",annotationsList:a},d=H.i18nFormat(e,h,n);return this.dataTableButtonId=s,this.sonifyButtonId=o,stripEmptyHTMLTags(d)},defaultAfterChartFormatter:function(){var n=this.chart,e=n.options.accessibility.screenReaderSection.afterChartFormat,t={endOfChartMarker:this.getEndOfChartMarkerText()},r=H.i18nFormat(e,t,n);return stripEmptyHTMLTags(r)},getLinkedDescription:function(){var n=this.linkedDescriptionElement,e=n&&n.innerHTML||"";return stripHTMLTagsFromString(e)},getLongdescText:function(){var n=this.chart.options,e=n.caption,t=e&&e.text,r=this.getLinkedDescription();return n.accessibility.description||r||t||""},getTypeDescriptionText:function(){var n=this.chart;return n.types?n.options.accessibility.typeDescription||n.getTypeDescription(n.types):""},getDataTableButtonText:function(n){var e=this.chart,t=e.langFormat("accessibility.table.viewAsDataTableButtonText",{chart:e,chartTitle:getChartTitle$1(e)});return'<button id="'+n+'">'+t+"</button>"},getSonifyButtonText:function(n){var e=this.chart;if(e.options.sonification&&e.options.sonification.enabled===!1)return"";var t=e.langFormat("accessibility.sonification.playAsSoundButtonText",{chart:e,chartTitle:getChartTitle$1(e)});return'<button id="'+n+'">'+t+"</button>"},getSubtitleText:function(){var n=this.chart.options.subtitle;return stripHTMLTagsFromString(n&&n.text||"")},getEndOfChartMarkerText:function(){var n=this.chart,e=n.langFormat("accessibility.screenReaderSection.endOfChartMarker",{chart:n}),t="highcharts-end-of-chart-marker-"+n.index;return'<div id="'+t+'">'+e+"</div>"},onDataTableCreated:function(n){var e=this.chart;if(e.options.accessibility.enabled){this.viewDataTableButton&&this.viewDataTableButton.setAttribute("aria-expanded","true");var t=n.tree.attributes||{};t.tabindex=-1,t.summary=getTableSummary(e),n.tree.attributes=t}},focusDataTable:function(){var n=this.dataTableDiv,e=n&&n.getElementsByTagName("table")[0];e&&e.focus&&e.focus()},initSonifyButton:function(n){var e=this,t=this.sonifyButton=getElement(n),r=this.chart,o=function(s){t&&(t.setAttribute("aria-hidden","true"),t.setAttribute("aria-label","")),s.preventDefault(),s.stopPropagation();var a=r.langFormat("accessibility.sonification.playAsSoundClickAnnouncement",{chart:r});e.announcer.announce(a),setTimeout(function(){t&&(t.removeAttribute("aria-hidden"),t.removeAttribute("aria-label")),r.sonify&&r.sonify()},1e3)};t&&r&&(setElAttrs(t,{tabindex:-1}),t.onclick=function(s){var a=r.options.accessibility&&r.options.accessibility.screenReaderSection.onPlayAsSoundClick;(a||o).call(this,s,r)})},initDataTableButton:function(n){var e=this.viewDataTableButton=getElement(n),t=this.chart,r=n.replace("hc-linkto-","");e&&(setElAttrs(e,{tabindex:-1,"aria-expanded":!!getElement(r)}),e.onclick=t.options.accessibility.screenReaderSection.onViewDataTableClick||function(){t.viewData()})},getAxesDescription:function(){var n=this.chart,e=function(l,h){var d=n[l];return d.length>1||d[0]&&pick$R(d[0].options.accessibility&&d[0].options.accessibility.enabled,h)},t=!!n.types&&n.types.indexOf("map")<0,r=!!n.hasCartesianSeries,o=e("xAxis",!n.angular&&r&&t),s=e("yAxis",r&&t),a={};return o&&(a.xAxis=this.getAxisDescriptionText("xAxis")),s&&(a.yAxis=this.getAxisDescriptionText("yAxis")),a},getAxisDescriptionText:function(n){var e=this.chart,t=e[n];return e.langFormat("accessibility.axis."+n+"Description"+(t.length>1?"Plural":"Singular"),{chart:e,names:t.map(function(r){return getAxisDescription(r)}),ranges:t.map(function(r){return getAxisRangeDescription(r)}),numAxes:t.length})},destroy:function(){this.announcer&&this.announcer.destroy()}});var unhideChartElementFromAT=ChartUtilities.unhideChartElementFromAT,getChartTitle=ChartUtilities.getChartTitle,doc$7=H.doc,stripHTMLTags=HTMLUtilities.stripHTMLTagsFromString,extend$N=Utilities.extend,ContainerComponent=function(){};ContainerComponent.prototype=new AccessibilityComponent;extend$N(ContainerComponent.prototype,{onChartUpdate:function(){this.handleSVGTitleElement(),this.setSVGContainerLabel(),this.setGraphicContainerAttrs(),this.setRenderToAttrs(),this.makeCreditsAccessible()},handleSVGTitleElement:function(){var n=this.chart,e="highcharts-title-"+n.index,t=stripHTMLTags(n.langFormat("accessibility.svgContainerTitle",{chartTitle:getChartTitle(n)}));if(t.length){var r=this.svgTitleElement=this.svgTitleElement||doc$7.createElementNS("http://www.w3.org/2000/svg","title");r.textContent=t,r.id=e,n.renderTo.insertBefore(r,n.renderTo.firstChild)}},setSVGContainerLabel:function(){var n=this.chart,e=n.langFormat("accessibility.svgContainerLabel",{chartTitle:getChartTitle(n)});n.renderer.box&&e.length&&n.renderer.box.setAttribute("aria-label",e)},setGraphicContainerAttrs:function(){var n=this.chart,e=n.langFormat("accessibility.graphicContainerLabel",{chartTitle:getChartTitle(n)});e.length&&n.container.setAttribute("aria-label",e)},setRenderToAttrs:function(){var n=this.chart;n.options.accessibility.landmarkVerbosity!=="disabled"?n.renderTo.setAttribute("role","region"):n.renderTo.removeAttribute("role"),n.renderTo.setAttribute("aria-label",n.langFormat("accessibility.chartContainerLabel",{title:getChartTitle(n),chart:n}))},makeCreditsAccessible:function(){var n=this.chart,e=n.credits;e&&(e.textStr&&e.element.setAttribute("aria-label",n.langFormat("accessibility.credits",{creditsStr:stripHTMLTags(e.textStr)})),unhideChartElementFromAT(n,e.element))},getKeyboardNavigation:function(){var n=this.chart;return new KeyboardNavigationHandler(n,{keyCodeMap:[],validate:function(){return!0},init:function(){var e=n.accessibility;e&&e.keyboardNavigation.tabindexContainer.focus()}})},destroy:function(){this.chart.renderTo.setAttribute("aria-hidden",!0)}});var doc$6=H.doc,isMS=H.isMS,win$3=H.win,whcm={isHighContrastModeActive:function(){var n=/(Edg)/.test(win$3.navigator.userAgent);if(win$3.matchMedia&&n)return win$3.matchMedia("(-ms-high-contrast: active)").matches;if(isMS&&win$3.getComputedStyle){var e=doc$6.createElement("div"),t="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==";e.style.backgroundImage="url("+t+")",doc$6.body.appendChild(e);var r=(e.currentStyle||win$3.getComputedStyle(e)).backgroundImage;return doc$6.body.removeChild(e),r==="none"}return!1},setHighContrastTheme:function(n){n.highContrastModeActive=!0;var e=n.options.accessibility.highContrastTheme;n.update(e,!1),n.series.forEach(function(t){var r=e.plotOptions[t.type]||{};t.update({color:r.color||"windowText",colors:[r.color||"windowText"],borderColor:r.borderColor||"window"}),t.points.forEach(function(o){o.options&&o.options.color&&o.update({color:r.color||"windowText",borderColor:r.borderColor||"window"},!1)})}),n.redraw()}},theme={chart:{backgroundColor:"window"},title:{style:{color:"windowText"}},subtitle:{style:{color:"windowText"}},colorAxis:{minColor:"windowText",maxColor:"windowText",stops:[]},colors:["windowText"],xAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},yAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},tooltip:{backgroundColor:"window",borderColor:"windowText",style:{color:"windowText"}},plotOptions:{series:{lineColor:"windowText",fillColor:"window",borderColor:"windowText",edgeColor:"windowText",borderWidth:1,dataLabels:{connectorColor:"windowText",color:"windowText",style:{color:"windowText",textOutline:"none"}},marker:{lineColor:"windowText",fillColor:"windowText"}},pie:{color:"window",colors:["window"],borderColor:"windowText",borderWidth:1},boxplot:{fillColor:"window"},candlestick:{lineColor:"windowText",fillColor:"window"},errorbar:{fillColor:"window"}},legend:{backgroundColor:"window",itemStyle:{color:"windowText"},itemHoverStyle:{color:"windowText"},itemHiddenStyle:{color:"#555"},title:{style:{color:"windowText"}}},credits:{style:{color:"windowText"}},labels:{style:{color:"windowText"}},drilldown:{activeAxisLabelStyle:{color:"windowText"},activeDataLabelStyle:{color:"windowText"}},navigation:{buttonOptions:{symbolStroke:"windowText",theme:{fill:"window"}}},rangeSelector:{buttonTheme:{fill:"window",stroke:"windowText",style:{color:"windowText"},states:{hover:{fill:"window",stroke:"windowText",style:{color:"windowText"}},select:{fill:"#444",stroke:"windowText",style:{color:"windowText"}}}},inputBoxBorderColor:"windowText",inputStyle:{backgroundColor:"window",color:"windowText"},labelStyle:{color:"windowText"}},navigator:{handles:{backgroundColor:"window",borderColor:"windowText"},outlineColor:"windowText",maskFill:"transparent",series:{color:"windowText",lineColor:"windowText"},xAxis:{gridLineColor:"windowText"}},scrollbar:{barBackgroundColor:"#444",barBorderColor:"windowText",buttonArrowColor:"windowText",buttonBackgroundColor:"window",buttonBorderColor:"windowText",rifleColor:"windowText",trackBackgroundColor:"window",trackBorderColor:"windowText"}},Options={accessibility:{enabled:!0,screenReaderSection:{beforeChartFormat:"<{headingTagName}>{chartTitle}</{headingTagName}><div>{typeDescription}</div><div>{chartSubtitle}</div><div>{chartLongdesc}</div><div>{playAsSoundButton}</div><div>{viewTableButton}</div><div>{xAxisDescription}</div><div>{yAxisDescription}</div><div>{annotationsTitle}{annotationsList}</div>",afterChartFormat:"{endOfChartMarker}",axisRangeDateFormat:"%Y-%m-%d %H:%M:%S"},series:{describeSingleSeries:!1,pointDescriptionEnabledThreshold:200},point:{valueDescriptionFormat:"{index}. {xDescription}{separator}{value}."},landmarkVerbosity:"all",linkedDescription:'*[data-highcharts-chart="{index}"] + .highcharts-description',keyboardNavigation:{enabled:!0,focusBorder:{enabled:!0,hideBrowserFocusOutline:!0,style:{color:palette.highlightColor80,lineWidth:2,borderRadius:3},margin:2},order:["series","zoom","rangeSelector","legend","chartMenu"],wrapAround:!0,seriesNavigation:{skipNullPoints:!0,pointNavigationEnabledThreshold:!1}},announceNewData:{enabled:!1,minAnnounceInterval:5e3,interruptUser:!1}},legend:{accessibility:{enabled:!0,keyboardNavigation:{enabled:!0}}},exporting:{accessibility:{enabled:!0}}},langOptions={accessibility:{defaultChartTitle:"Chart",chartContainerLabel:"{title}. Highcharts interactive chart.",svgContainerLabel:"Interactive chart",drillUpButton:"{buttonText}",credits:"Chart credits: {creditsStr}",thousandsSep:",",svgContainerTitle:"",graphicContainerLabel:"",screenReaderSection:{beforeRegionLabel:"Chart screen reader information, {chartTitle}.",afterRegionLabel:"",annotations:{heading:"Chart annotations summary",descriptionSinglePoint:"{annotationText}. Related to {annotationPoint}",descriptionMultiplePoints:"{annotationText}. Related to {annotationPoint}{ Also related to, #each(additionalAnnotationPoints)}",descriptionNoPoints:"{annotationText}"},endOfChartMarker:"End of interactive chart."},sonification:{playAsSoundButtonText:"Play as sound, {chartTitle}",playAsSoundClickAnnouncement:"Play"},legend:{legendLabelNoTitle:"Toggle series visibility, {chartTitle}",legendLabel:"Chart legend: {legendTitle}",legendItem:"Show {itemName}"},zoom:{mapZoomIn:"Zoom chart",mapZoomOut:"Zoom out chart",resetZoomButton:"Reset zoom"},rangeSelector:{dropdownLabel:"{rangeTitle}",minInputLabel:"Select start date.",maxInputLabel:"Select end date.",clickButtonAnnouncement:"Viewing {axisRangeDescription}"},table:{viewAsDataTableButtonText:"View as data table, {chartTitle}",tableSummary:"Table representation of chart."},announceNewData:{newDataAnnounce:"Updated data for chart {chartTitle}",newSeriesAnnounceSingle:"New data series: {seriesDesc}",newPointAnnounceSingle:"New data point: {pointDesc}",newSeriesAnnounceMultiple:"New data series in chart {chartTitle}: {seriesDesc}",newPointAnnounceMultiple:"New data point in chart {chartTitle}: {pointDesc}"},seriesTypeDescriptions:{boxplot:"Box plot charts are typically used to display groups of statistical data. Each data point in the chart can have up to 5 values: minimum, lower quartile, median, upper quartile, and maximum.",arearange:"Arearange charts are line charts displaying a range between a lower and higher value for each point.",areasplinerange:"These charts are line charts displaying a range between a lower and higher value for each point.",bubble:"Bubble charts are scatter charts where each data point also has a size value.",columnrange:"Columnrange charts are column charts displaying a range between a lower and higher value for each point.",errorbar:"Errorbar series are used to display the variability of the data.",funnel:"Funnel charts are used to display reduction of data in stages.",pyramid:"Pyramid charts consist of a single pyramid with item heights corresponding to each point value.",waterfall:"A waterfall chart is a column chart where each column contributes towards a total end value."},chartTypes:{emptyChart:"Empty chart",mapTypeDescription:"Map of {mapTitle} with {numSeries} data series.",unknownMap:"Map of unspecified region with {numSeries} data series.",combinationChart:"Combination chart with {numSeries} data series.",defaultSingle:"Chart with {numPoints} data {#plural(numPoints, points, point)}.",defaultMultiple:"Chart with {numSeries} data series.",splineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",splineMultiple:"Line chart with {numSeries} lines.",lineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",lineMultiple:"Line chart with {numSeries} lines.",columnSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",columnMultiple:"Bar chart with {numSeries} data series.",barSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",barMultiple:"Bar chart with {numSeries} data series.",pieSingle:"Pie chart with {numPoints} {#plural(numPoints, slices, slice)}.",pieMultiple:"Pie chart with {numSeries} pies.",scatterSingle:"Scatter chart with {numPoints} {#plural(numPoints, points, point)}.",scatterMultiple:"Scatter chart with {numSeries} data series.",boxplotSingle:"Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotMultiple:"Boxplot with {numSeries} data series.",bubbleSingle:"Bubble chart with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleMultiple:"Bubble chart with {numSeries} data series."},axis:{xAxisDescriptionSingular:"The chart has 1 X axis displaying {names[0]}. {ranges[0]}",xAxisDescriptionPlural:"The chart has {numAxes} X axes displaying {#each(names, -1) }and {names[-1]}.",yAxisDescriptionSingular:"The chart has 1 Y axis displaying {names[0]}. {ranges[0]}",yAxisDescriptionPlural:"The chart has {numAxes} Y axes displaying {#each(names, -1) }and {names[-1]}.",timeRangeDays:"Range: {range} days.",timeRangeHours:"Range: {range} hours.",timeRangeMinutes:"Range: {range} minutes.",timeRangeSeconds:"Range: {range} seconds.",rangeFromTo:"Range: {rangeFrom} to {rangeTo}.",rangeCategories:"Range: {numCategories} categories."},exporting:{chartMenuLabel:"Chart menu",menuButtonLabel:"View chart menu",exportRegionLabel:"Chart menu, {chartTitle}"},series:{summary:{default:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",defaultCombination:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",line:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",lineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",spline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",splineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",column:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",columnCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",bar:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",barCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",pie:"{name}, pie {ix} of {numSeries} with {numPoints} {#plural(numPoints, slices, slice)}.",pieCombination:"{name}, series {ix} of {numSeries}. Pie with {numPoints} {#plural(numPoints, slices, slice)}.",scatter:"{name}, scatter plot {ix} of {numSeries} with {numPoints} {#plural(numPoints, points, point)}.",scatterCombination:"{name}, series {ix} of {numSeries}, scatter plot with {numPoints} {#plural(numPoints, points, point)}.",boxplot:"{name}, boxplot {ix} of {numSeries} with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotCombination:"{name}, series {ix} of {numSeries}. Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",bubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}.",map:"{name}, map {ix} of {numSeries} with {numPoints} {#plural(numPoints, areas, area)}.",mapCombination:"{name}, series {ix} of {numSeries}. Map with {numPoints} {#plural(numPoints, areas, area)}.",mapline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",maplineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",mapbubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",mapbubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}."},description:"{description}",xAxisDescription:"X axis, {name}",yAxisDescription:"Y axis, {name}",nullPointValue:"No value",pointAnnotationsDescription:"{Annotation: #each(annotations). }"}}},error$1=Utilities.error,pick$Q=Utilities.pick;function traverseSetOption(n,e,t){for(var r=n,o,s=0;s<e.length-1;++s)o=e[s],r=r[o]=pick$Q(r[o],{});r[e[e.length-1]]=t}function deprecateFromOptionsMap(n,e,t,r){function o(l,h){return h.reduce(function(d,c){return d[c]},l)}var s=o(n.options,e),a=o(n.options,t);Object.keys(r).forEach(function(l){var h,d=s[l];typeof d<"u"&&(traverseSetOption(a,r[l],d),error$1(32,!1,n,(h={},h[e.join(".")+"."+l]=t.join(".")+"."+r[l].join("."),h)))})}function copyDeprecatedChartOptions(n){var e=n.options.chart,t=n.options.accessibility||{};["description","typeDescription"].forEach(function(r){var o;e[r]&&(t[r]=e[r],error$1(32,!1,n,(o={},o["chart."+r]="use accessibility."+r,o)))})}function copyDeprecatedAxisOptions(n){n.axes.forEach(function(e){var t=e.options;t&&t.description&&(t.accessibility=t.accessibility||{},t.accessibility.description=t.description,error$1(32,!1,n,{"axis.description":"use axis.accessibility.description"}))})}function copyDeprecatedSeriesOptions(n){var e={description:["accessibility","description"],exposeElementToA11y:["accessibility","exposeAsGroupOnly"],pointDescriptionFormatter:["accessibility","pointDescriptionFormatter"],skipKeyboardNavigation:["accessibility","keyboardNavigation","enabled"]};n.series.forEach(function(t){Object.keys(e).forEach(function(r){var o,s=t.options[r];typeof s<"u"&&(traverseSetOption(t.options,e[r],r==="skipKeyboardNavigation"?!s:s),error$1(32,!1,n,(o={},o["series."+r]="series."+e[r].join("."),o)))})})}function copyDeprecatedTopLevelAccessibilityOptions(n){deprecateFromOptionsMap(n,["accessibility"],["accessibility"],{pointDateFormat:["point","dateFormat"],pointDateFormatter:["point","dateFormatter"],pointDescriptionFormatter:["point","descriptionFormatter"],pointDescriptionThreshold:["series","pointDescriptionEnabledThreshold"],pointNavigationThreshold:["keyboardNavigation","seriesNavigation","pointNavigationEnabledThreshold"],pointValueDecimals:["point","valueDecimals"],pointValuePrefix:["point","valuePrefix"],pointValueSuffix:["point","valueSuffix"],screenReaderSectionFormatter:["screenReaderSection","beforeChartFormatter"],describeSingleSeries:["series","describeSingleSeries"],seriesDescriptionFormatter:["series","descriptionFormatter"],onTableAnchorClick:["screenReaderSection","onViewDataTableClick"],axisRangeDateFormat:["screenReaderSection","axisRangeDateFormat"]})}function copyDeprecatedKeyboardNavigationOptions(n){deprecateFromOptionsMap(n,["accessibility","keyboardNavigation"],["accessibility","keyboardNavigation","seriesNavigation"],{skipNullPoints:["skipNullPoints"],mode:["mode"]})}function copyDeprecatedLangOptions(n){deprecateFromOptionsMap(n,["lang","accessibility"],["lang","accessibility"],{legendItem:["legend","legendItem"],legendLabel:["legend","legendLabel"],mapZoomIn:["zoom","mapZoomIn"],mapZoomOut:["zoom","mapZoomOut"],resetZoomButton:["zoom","resetZoomButton"],screenReaderRegionLabel:["screenReaderSection","beforeRegionLabel"],rangeSelectorButton:["rangeSelector","buttonText"],rangeSelectorMaxInput:["rangeSelector","maxInputLabel"],rangeSelectorMinInput:["rangeSelector","minInputLabel"],svgContainerEnd:["screenReaderSection","endOfChartMarker"],viewAsDataTable:["table","viewAsDataTableButtonText"],tableSummary:["table","tableSummary"]})}function copyDeprecatedOptions(n){copyDeprecatedChartOptions(n),copyDeprecatedAxisOptions(n),n.series&&copyDeprecatedSeriesOptions(n),copyDeprecatedTopLevelAccessibilityOptions(n),copyDeprecatedKeyboardNavigationOptions(n),copyDeprecatedLangOptions(n)}var format$3=FormatUtilities.format,pick$P=Utilities.pick;function stringTrim(n){return n.trim&&n.trim()||n.replace(/^\s+|\s+$/g,"")}function formatExtendedStatement(n,e){var t=n.indexOf("#each("),r=n.indexOf("#plural("),o=n.indexOf("["),s=n.indexOf("]"),a,l;if(t>-1){var h=n.slice(t).indexOf(")")+t,d=n.substring(0,t),c=n.substring(h+1),p=n.substring(t+6,h),f=p.split(","),u=Number(f[1]),g=void 0;if(l="",a=e[f[0]],a){u=isNaN(u)?a.length:u,g=u<0?a.length+u:Math.min(u,a.length);for(var m=0;m<g;++m)l+=d+a[m]+c}return l.length?l:""}if(r>-1){var y=n.slice(r).indexOf(")")+r,v=n.substring(r+8,y),x=v.split(","),b=Number(e[x[0]]);switch(b){case 0:l=pick$P(x[4],x[1]);break;case 1:l=pick$P(x[2],x[1]);break;case 2:l=pick$P(x[3],x[1]);break;default:l=x[1]}return l?stringTrim(l):""}if(o>-1){var $=n.substring(0,o),S=Number(n.substring(o+1,s)),k=void 0;return a=e[$],!isNaN(S)&&a&&(S<0?(k=a[a.length+S],typeof k>"u"&&(k=a[0])):(k=a[S],typeof k>"u"&&(k=a[a.length-1]))),typeof k<"u"?k:""}return"{"+n+"}"}H.i18nFormat=function(n,e,t){var r=function(h,d){var c=h.slice(d||0),p=c.indexOf("{"),f=c.indexOf("}");if(p>-1&&f>p)return{statement:c.substring(p+1,f),begin:d+p+1,end:d+f}},o=[],s,a,l=0;do s=r(n,l),a=n.substring(l,s&&s.begin-1),a.length&&o.push({value:a,type:"constant"}),s&&o.push({value:s.statement,type:"statement"}),l=s?s.end+1:l+1;while(s);return o.forEach(function(h){h.type==="statement"&&(h.value=formatExtendedStatement(h.value,e))}),format$3(o.reduce(function(h,d){return h+d.value},""),e,t)};Chart$1.prototype.langFormat=function(n,e){for(var t=n.split("."),r=this.options.lang,o=0;o<t.length;++o)r=r&&r[t[o]];return typeof r=="string"?H.i18nFormat(r,e,this):""};var addEvent$x=Utilities.addEvent,extend$M=Utilities.extend,pick$O=Utilities.pick,svgElementBorderUpdateTriggers=["x","y","transform","width","height","r","d","stroke-width"];function addDestroyFocusBorderHook(n){if(!n.focusBorderDestroyHook){var e=n.destroy;n.destroy=function(){return n.focusBorder&&n.focusBorder.destroy&&n.focusBorder.destroy(),e.apply(n,arguments)},n.focusBorderDestroyHook=e}}function removeDestroyFocusBorderHook(n){n.focusBorderDestroyHook&&(n.destroy=n.focusBorderDestroyHook,delete n.focusBorderDestroyHook)}function addUpdateFocusBorderHooks(n){for(var e=[],t=1;t<arguments.length;t++)e[t-1]=arguments[t];n.focusBorderUpdateHooks||(n.focusBorderUpdateHooks={},svgElementBorderUpdateTriggers.forEach(function(r){var o=r+"Setter",s=n[o]||n._defaultSetter;n.focusBorderUpdateHooks[o]=s,n[o]=function(){var a=s.apply(n,arguments);return n.addFocusBorder.apply(n,e),a}}))}function removeUpdateFocusBorderHooks(n){n.focusBorderUpdateHooks&&(Object.keys(n.focusBorderUpdateHooks).forEach(function(e){var t=n.focusBorderUpdateHooks[e];t===n._defaultSetter?delete n[e]:n[e]=t}),delete n.focusBorderUpdateHooks)}extend$M(SVGElement.prototype,{addFocusBorder:function(n,e){this.focusBorder&&this.removeFocusBorder();var t=this.getBBox(),r=pick$O(n,3);t.x+=this.translateX?this.translateX:0,t.y+=this.translateY?this.translateY:0;var o=t.x-r,s=t.y-r,a=t.width+2*r,l=t.height+2*r;function h(m){var y=0,v=0;return m.attr("text-anchor")==="middle"?y=v=.5:m.rotation?y=.25:v=.75,{x:y,y:v}}var d=this instanceof SVGLabel;if(this.element.nodeName==="text"||d){var c=!!this.rotation,p=d?{x:c?1:0,y:0}:h(this),f=+this.attr("x"),u=+this.attr("y");if(isNaN(f)||(o=f-t.width*p.x-r),isNaN(u)||(s=u-t.height*p.y-r),d&&c){var g=a;a=l,l=g,isNaN(f)||(o=f-t.height*p.x-r),isNaN(u)||(s=u-t.width*p.y-r)}}this.focusBorder=this.renderer.rect(o,s,a,l,parseInt((e&&e.r||0).toString(),10)).addClass("highcharts-focus-border").attr({zIndex:99}).add(this.parentGroup),this.renderer.styledMode||this.focusBorder.attr({stroke:e&&e.stroke,"stroke-width":e&&e.strokeWidth}),addUpdateFocusBorderHooks(this,n,e),addDestroyFocusBorderHook(this)},removeFocusBorder:function(){removeUpdateFocusBorderHooks(this),removeDestroyFocusBorderHook(this),this.focusBorder&&(this.focusBorder.destroy(),delete this.focusBorder)}});Chart$1.prototype.renderFocusBorder=function(){var n=this.focusElement,e=this.options.accessibility.keyboardNavigation.focusBorder;n&&(n.removeFocusBorder(),e.enabled&&n.addFocusBorder(e.margin,{stroke:e.style.color,strokeWidth:e.style.lineWidth,r:e.style.borderRadius}))};Chart$1.prototype.setFocusToElement=function(n,e){var t=this.options.accessibility.keyboardNavigation.focusBorder,r=e||n.element;r&&r.focus&&(r.hcEvents&&r.hcEvents.focusin||addEvent$x(r,"focusin",function(){}),r.focus(),t.hideBrowserFocusOutline&&(r.style.outline="none")),this.focusElement&&this.focusElement.removeFocusBorder(),this.focusElement=n,this.renderFocusBorder()};var doc$5=H.doc,defaultOptions$4=DefaultOptions.defaultOptions,addEvent$w=Utilities.addEvent,extend$L=Utilities.extend,fireEvent$d=Utilities.fireEvent,merge$L=Utilities.merge;merge$L(!0,defaultOptions$4,Options,{accessibility:{highContrastTheme:theme},lang:langOptions});H.A11yChartUtilities=ChartUtilities;H.A11yHTMLUtilities=HTMLUtilities;H.KeyboardNavigationHandler=KeyboardNavigationHandler;H.AccessibilityComponent=AccessibilityComponent;function Accessibility(n){this.init(n)}Accessibility.prototype={init:function(n){if(this.chart=n,!doc$5.addEventListener||!n.renderer.isSVG){n.renderTo.setAttribute("aria-hidden",!0);return}copyDeprecatedOptions(n),this.initComponents(),this.keyboardNavigation=new KeyboardNavigation(n,this.components),this.update()},initComponents:function(){var n=this.chart,e=n.options.accessibility;this.components={container:new ContainerComponent,infoRegions:new InfoRegionsComponent,legend:new LegendComponent,chartMenu:new MenuComponent,rangeSelector:new RangeSelectorComponent,series:new SeriesComponent,zoom:new ZoomComponent},e.customComponents&&extend$L(this.components,e.customComponents);var t=this.components;this.getComponentOrder().forEach(function(r){t[r].initBase(n),t[r].init()})},getComponentOrder:function(){if(!this.components)return[];if(!this.components.series)return Object.keys(this.components);var n=Object.keys(this.components).filter(function(e){return e!=="series"});return["series"].concat(n)},update:function(){var n=this.components,e=this.chart,t=e.options.accessibility;fireEvent$d(e,"beforeA11yUpdate"),e.types=this.getChartTypes(),this.getComponentOrder().forEach(function(r){n[r].onChartUpdate(),fireEvent$d(e,"afterA11yComponentUpdate",{name:r,component:n[r]})}),this.keyboardNavigation.update(t.keyboardNavigation.order),!e.highContrastModeActive&&whcm.isHighContrastModeActive()&&whcm.setHighContrastTheme(e),fireEvent$d(e,"afterA11yUpdate",{accessibility:this})},destroy:function(){var n=this.chart||{},e=this.components;Object.keys(e).forEach(function(t){e[t].destroy(),e[t].destroyBase()}),this.keyboardNavigation&&this.keyboardNavigation.destroy(),n.renderTo&&n.renderTo.setAttribute("aria-hidden",!0),n.focusElement&&n.focusElement.removeFocusBorder()},getChartTypes:function(){var n={};return this.chart.series.forEach(function(e){n[e.type]=1}),Object.keys(n)}};Chart$1.prototype.updateA11yEnabled=function(){var n=this.accessibility,e=this.options.accessibility;e&&e.enabled?n?n.update():this.accessibility=n=new Accessibility(this):n?(n.destroy&&n.destroy(),delete this.accessibility):this.renderTo.setAttribute("aria-hidden",!0)};addEvent$w(Chart$1,"render",function(n){this.a11yDirty&&this.renderTo&&(delete this.a11yDirty,this.updateA11yEnabled());var e=this.accessibility;e&&e.getComponentOrder().forEach(function(t){e.components[t].onChartRender()})});addEvent$w(Chart$1,"update",function(n){var e=n.options.accessibility;e&&(e.customComponents&&(this.options.accessibility.customComponents=e.customComponents,delete e.customComponents),merge$L(!0,this.options.accessibility,e),this.accessibility&&this.accessibility.destroy&&(this.accessibility.destroy(),delete this.accessibility)),this.a11yDirty=!0});addEvent$w(Point$2,"update",function(){this.series.chart.accessibility&&(this.series.chart.a11yDirty=!0)});["addSeries","init"].forEach(function(n){addEvent$w(Chart$1,n,function(){this.a11yDirty=!0})});["update","updatedData","remove"].forEach(function(n){addEvent$w(Series$e,n,function(){this.chart.accessibility&&(this.chart.a11yDirty=!0)})});["afterDrilldown","drillupall"].forEach(function(n){addEvent$w(Chart$1,n,function(){this.accessibility&&this.accessibility.update()})});addEvent$w(Chart$1,"destroy",function(){this.accessibility&&this.accessibility.destroy()});var addEvent$v=Utilities.addEvent,fireEvent$c=Utilities.fireEvent,objectEach$c=Utilities.objectEach,pick$N=Utilities.pick,removeEvent$2=Utilities.removeEvent,eventEmitterMixin={addEvents:function(){var n=this,e=function(r){addEvent$v(r,H.isTouchDevice?"touchstart":"mousedown",function(o){n.onMouseDown(o)},{passive:!1})};if(e(this.graphic.element),(n.labels||[]).forEach(function(r){r.options.useHTML&&r.graphic.text&&e(r.graphic.text.element)}),objectEach$c(n.options.events,function(r,o){var s=function(a){(o!=="click"||!n.cancelClick)&&r.call(n,n.chart.pointer.normalize(a),n.target)};(n.nonDOMEvents||[]).indexOf(o)===-1?n.graphic.on(o,s):addEvent$v(n,o,s,{passive:!1})}),n.options.draggable&&(addEvent$v(n,"drag",n.onDrag),!n.graphic.renderer.styledMode)){var t={cursor:{x:"ew-resize",y:"ns-resize",xy:"move"}[n.options.draggable]};n.graphic.css(t),(n.labels||[]).forEach(function(r){r.options.useHTML&&r.graphic.text&&r.graphic.text.css(t)})}n.isUpdating||fireEvent$c(n,"add")},removeDocEvents:function(){this.removeDrag&&(this.removeDrag=this.removeDrag()),this.removeMouseUp&&(this.removeMouseUp=this.removeMouseUp())},onMouseDown:function(n){var e=this,t=e.chart.pointer,r,o;n.preventDefault&&n.preventDefault(),n.button!==2&&(n=t.normalize(n),r=n.chartX,o=n.chartY,e.cancelClick=!1,e.chart.hasDraggedAnnotation=!0,e.removeDrag=addEvent$v(H.doc,H.isTouchDevice?"touchmove":"mousemove",function(s){e.hasDragged=!0,s=t.normalize(s),s.prevChartX=r,s.prevChartY=o,fireEvent$c(e,"drag",s),r=s.chartX,o=s.chartY},H.isTouchDevice?{passive:!1}:void 0),e.removeMouseUp=addEvent$v(H.doc,H.isTouchDevice?"touchend":"mouseup",function(s){var a=pick$N(e.target&&e.target.annotation,e.target);a&&(a.cancelClick=e.hasDragged),e.cancelClick=e.hasDragged,e.hasDragged=!1,e.chart.hasDraggedAnnotation=!1,fireEvent$c(pick$N(a,e),"afterUpdate"),e.onMouseUp(s)},H.isTouchDevice?{passive:!1}:void 0))},onMouseUp:function(n){var e=this.chart,t=this.target||this,r=e.options.annotations,o=e.annotations.indexOf(t);this.removeDocEvents(),r[o]=t.options},onDrag:function(n){if(this.chart.isInsidePlot(n.chartX-this.chart.plotLeft,n.chartY-this.chart.plotTop,{visiblePlotOnly:!0})){var e=this.mouseMoveToTranslation(n);this.options.draggable==="x"&&(e.y=0),this.options.draggable==="y"&&(e.x=0),this.points.length?this.translate(e.x,e.y):(this.shapes.forEach(function(t){t.translate(e.x,e.y)}),this.labels.forEach(function(t){t.translate(e.x,e.y)})),this.redraw(!1)}},mouseMoveToRadians:function(n,e,t){var r=n.prevChartY-t,o=n.prevChartX-e,s=n.chartY-t,a=n.chartX-e,l;return this.chart.inverted&&(l=o,o=r,r=l,l=a,a=s,s=l),Math.atan2(s,a)-Math.atan2(r,o)},mouseMoveToTranslation:function(n){var e=n.chartX-n.prevChartX,t=n.chartY-n.prevChartY,r;return this.chart.inverted&&(r=t,t=e,e=r),{x:e,y:t}},mouseMoveToScale:function(n,e,t){var r=n.prevChartX-e,o=n.prevChartY-t,s=n.chartX-e,a=n.chartY-t,l=(s||1)/(r||1),h=(a||1)/(o||1),d;return this.chart.inverted&&(d=h,h=l,l=d),{x:l,y:h}},destroy:function(){this.removeDocEvents(),removeEvent$2(this),this.hcEvents=null}},merge$K=Utilities.merge,pick$M=Utilities.pick,ControlPoint=function(){function n(e,t,r,o){this.addEvents=eventEmitterMixin.addEvents,this.graphic=void 0,this.mouseMoveToRadians=eventEmitterMixin.mouseMoveToRadians,this.mouseMoveToScale=eventEmitterMixin.mouseMoveToScale,this.mouseMoveToTranslation=eventEmitterMixin.mouseMoveToTranslation,this.onDrag=eventEmitterMixin.onDrag,this.onMouseDown=eventEmitterMixin.onMouseDown,this.onMouseUp=eventEmitterMixin.onMouseUp,this.removeDocEvents=eventEmitterMixin.removeDocEvents,this.nonDOMEvents=["drag"],this.chart=e,this.target=t,this.options=r,this.index=pick$M(r.index,o)}return n.prototype.setVisibility=function(e){this.graphic.attr("visibility",e?"visible":"hidden"),this.options.visible=e},n.prototype.render=function(){var e=this.chart,t=this.options;this.graphic=e.renderer.symbol(t.symbol,0,0,t.width,t.height).add(e.controlPointsGroup).css(t.style),this.setVisibility(t.visible),this.addEvents()},n.prototype.redraw=function(e){this.graphic[e?"animate":"attr"](this.options.positioner.call(this,this.target))},n.prototype.destroy=function(){eventEmitterMixin.destroy.call(this),this.graphic&&(this.graphic=this.graphic.destroy()),this.chart=null,this.target=null,this.options=null},n.prototype.update=function(e){var t=this.chart,r=this.target,o=this.index,s=merge$K(!0,this.options,e);this.destroy(),this.constructor(t,r,s,o),this.render(t.controlPointsGroup),this.redraw()},n}(),defined$l=Utilities.defined,fireEvent$b=Utilities.fireEvent,MockPoint=function(){function n(e,t,r){this.isInside=void 0,this.negative=void 0,this.plotX=void 0,this.plotY=void 0,this.ttBelow=void 0,this.x=void 0,this.y=void 0,this.mock=!0,this.series={visible:!0,chart:e,getPlotBox:Series$e.prototype.getPlotBox},this.target=t||null,this.options=r,this.applyOptions(this.getOptions())}return n.fromPoint=function(e){return new n(e.series.chart,null,{x:e.x,y:e.y,xAxis:e.series.xAxis,yAxis:e.series.yAxis})},n.pointToPixels=function(e,t){var r=e.series,o=r.chart,s=e.plotX,a=e.plotY,l;return o.inverted&&(e.mock?(s=e.plotY,a=e.plotX):(s=o.plotWidth-e.plotY,a=o.plotHeight-e.plotX)),r&&!t&&(l=r.getPlotBox(),s+=l.translateX,a+=l.translateY),{x:s,y:a}},n.pointToOptions=function(e){return{x:e.x,y:e.y,xAxis:e.series.xAxis,yAxis:e.series.yAxis}},n.prototype.hasDynamicOptions=function(){return typeof this.options=="function"},n.prototype.getOptions=function(){return this.hasDynamicOptions()?this.options(this.target):this.options},n.prototype.applyOptions=function(e){this.command=e.command,this.setAxis(e,"x"),this.setAxis(e,"y"),this.refresh()},n.prototype.setAxis=function(e,t){var r=t+"Axis",o=e[r],s=this.series.chart;this.series[r]=o instanceof Axis?o:defined$l(o)?s[r][o]||s.get(o):null},n.prototype.toAnchor=function(){var e=[this.plotX,this.plotY,0,0];return this.series.chart.inverted&&(e[0]=this.plotY,e[1]=this.plotX),e},n.prototype.getLabelConfig=function(){return{x:this.x,y:this.y,point:this}},n.prototype.isInsidePlot=function(){var e=this.plotX,t=this.plotY,r=this.series.xAxis,o=this.series.yAxis,s={x:e,y:t,isInsidePlot:!0};return r&&(s.isInsidePlot=defined$l(e)&&e>=0&&e<=r.len),o&&(s.isInsidePlot=s.isInsidePlot&&defined$l(t)&&t>=0&&t<=o.len),fireEvent$b(this.series.chart,"afterIsInsidePlot",s),s.isInsidePlot},n.prototype.refresh=function(){var e=this.series,t=e.xAxis,r=e.yAxis,o=this.getOptions();t?(this.x=o.x,this.plotX=t.toPixels(o.x,!0)):(this.x=null,this.plotX=o.x),r?(this.y=o.y,this.plotY=r.toPixels(o.y,!0)):(this.y=null,this.plotY=o.y),this.isInside=this.isInsidePlot()},n.prototype.translate=function(e,t,r,o){this.hasDynamicOptions()||(this.plotX+=r,this.plotY+=o,this.refreshOptions())},n.prototype.scale=function(e,t,r,o){if(!this.hasDynamicOptions()){var s=this.plotX*r,a=this.plotY*o,l=(1-r)*e,h=(1-o)*t;this.plotX=l+s,this.plotY=h+a,this.refreshOptions()}},n.prototype.rotate=function(e,t,r){if(!this.hasDynamicOptions()){var o=Math.cos(r),s=Math.sin(r),a=this.plotX,l=this.plotY,h=void 0,d=void 0;a-=e,l-=t,h=a*o-l*s,d=a*s+l*o,this.plotX=h+e,this.plotY=d+t,this.refreshOptions()}},n.prototype.refreshOptions=function(){var e=this.series,t=e.xAxis,r=e.yAxis;this.x=this.options.x=t?this.options.x=t.toValue(this.plotX,!0):this.plotX,this.y=this.options.y=r?r.toValue(this.plotY,!0):this.plotY},n}(),isObject$7=Utilities.isObject,isString$2=Utilities.isString,merge$J=Utilities.merge,splat$6=Utilities.splat,controllableMixin={init:function(n,e,t){this.annotation=n,this.chart=n.chart,this.options=e,this.points=[],this.controlPoints=[],this.index=t,this.linkPoints(),this.addControlPoints()},attr:function(){this.graphic.attr.apply(this.graphic,arguments)},getPointsOptions:function(){var n=this.options;return n.points||n.point&&splat$6(n.point)},attrsFromOptions:function(n){var e=this.constructor.attrsMap,t={},r,o,s=this.chart.styledMode;for(r in n)o=e[r],o&&(!s||["fill","stroke","stroke-width"].indexOf(o)===-1)&&(t[o]=n[r]);return t},anchor:function(n){var e=n.series.getPlotBox(),t=n.series.chart,r=n.mock?n.toAnchor():Tooltip.prototype.getAnchor.call({chart:n.series.chart},n),o={x:r[0]+(this.options.x||0),y:r[1]+(this.options.y||0),height:r[2]||0,width:r[3]||0};return{relativePosition:o,absolutePosition:merge$J(o,{x:o.x+(n.mock?e.translateX:t.plotLeft),y:o.y+(n.mock?e.translateY:t.plotTop)})}},point:function(n,e){if(n&&n.series)return n;if(!e||e.series===null){if(isObject$7(n))e=new MockPoint(this.chart,this,n);else if(isString$2(n))e=this.chart.get(n)||null;else if(typeof n=="function"){var t=n.call(e,this);e=t.series?t:new MockPoint(this.chart,this,n)}}return e},linkPoints:function(){var n=this.getPointsOptions(),e=this.points,t=n&&n.length||0,r,o;for(r=0;r<t;r++){if(o=this.point(n[r],e[r]),!o){e.length=0;return}o.mock&&o.refresh(),e[r]=o}return e},addControlPoints:function(){var n=this.options.controlPoints;(n||[]).forEach(function(e,t){var r=merge$J(this.options.controlPointOptions,e);r.index||(r.index=t),n[t]=r,this.controlPoints.push(new ControlPoint(this.chart,this,r))},this)},shouldBeDrawn:function(){return!!this.points.length},render:function(n){this.controlPoints.forEach(function(e){e.render()})},redraw:function(n){this.controlPoints.forEach(function(e){e.redraw(n)})},transform:function(n,e,t,r,o){if(this.chart.inverted){var s=e;e=t,t=s}this.points.forEach(function(a,l){this.transformPoint(n,e,t,r,o,l)},this)},transformPoint:function(n,e,t,r,o,s){var a=this.points[s];a.mock||(a=this.points[s]=MockPoint.fromPoint(a)),a[n](e,t,r,o)},translate:function(n,e){this.transform("translate",null,null,n,e)},translatePoint:function(n,e,t){this.transformPoint("translate",null,null,n,e,t)},translateShape:function(n,e){var t=this.annotation.chart,r=this.annotation.userOptions,o=t.annotations.indexOf(this.annotation),s=t.options.annotations[o];this.translatePoint(n,e,0),s[this.collection][this.index].point=this.options.point,r[this.collection][this.index].point=this.options.point},rotate:function(n,e,t){this.transform("rotate",n,e,t)},scale:function(n,e,t,r){this.transform("scale",n,e,t,r)},setControlPointsVisibility:function(n){this.controlPoints.forEach(function(e){e.setVisibility(n)})},destroy:function(){this.graphic&&(this.graphic=this.graphic.destroy()),this.tracker&&(this.tracker=this.tracker.destroy()),this.controlPoints.forEach(function(n){n.destroy()}),this.chart=null,this.points=null,this.controlPoints=null,this.options=null,this.annotation&&(this.annotation=null)},update:function(n){var e=this.annotation,t=merge$J(!0,this.options,n),r=this.graphic.parentGroup;this.destroy(),this.constructor(e,t,this.index),this.render(r),this.redraw()}},addEvent$u=Utilities.addEvent,defined$k=Utilities.defined,merge$I=Utilities.merge,uniqueKey$2=Utilities.uniqueKey,defaultMarkers={arrow:{tagName:"marker",attributes:{id:"arrow",refY:5,refX:9,markerWidth:10,markerHeight:10},children:[{tagName:"path",attributes:{d:"M 0 0 L 10 5 L 0 10 Z","stroke-width":0}}]},"reverse-arrow":{tagName:"marker",attributes:{id:"reverse-arrow",refY:5,refX:1,markerWidth:10,markerHeight:10},children:[{tagName:"path",attributes:{d:"M 0 5 L 10 0 L 10 10 Z","stroke-width":0}}]}};SVGRenderer.prototype.addMarker=function(n,e){var t={attributes:{id:n}},r={stroke:e.color||"none",fill:e.color||"rgba(0, 0, 0, 0.75)"};t.children=e.children&&e.children.map(function(a){return merge$I(r,a)});var o=merge$I(!0,{attributes:{markerWidth:20,markerHeight:20,refX:0,refY:0,orient:"auto"}},e,t),s=this.definition(o);return s.id=n,s};function createMarkerSetter(n){return function(e){this.attr(n,"url(#"+e+")")}}var markerMixin={markerEndSetter:createMarkerSetter("marker-end"),markerStartSetter:createMarkerSetter("marker-start"),setItemMarkers:function(n){var e=n.options,t=n.chart,r=t.options.defs,o=e.fill,s=defined$k(o)&&o!=="none"?o:e.stroke,a=function(l){var h=e[l],d,c,p,f;if(h){for(p in r)if(d=r[p],(h===(d.attributes&&d.attributes.id)||h===d.id)&&d.tagName==="marker"){c=d;break}c&&(f=n[l]=t.renderer.addMarker((e.id||uniqueKey$2())+"-"+h,merge$I(c,{color:s})),n.attr(l,f.getAttribute("id")))}};["markerStart","markerEnd"].forEach(a)}};addEvent$u(Chart$1,"afterGetContainer",function(){this.options.defs=merge$I(defaultMarkers,this.options.defs||{})});var extend$K=Utilities.extend,TRACKER_FILL="rgba(192,192,192,"+(H.svg?1e-4:.002)+")",ControllablePath=function(){function n(e,t,r){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.setMarkers=markerMixin.setItemMarkers,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translate=controllableMixin.translate,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="path",this.init(e,t,r),this.collection="shapes"}return n.prototype.toD=function(){var e=this.options.d;if(e)return typeof e=="function"?e.call(this):e;var t=this.points,r=t.length,o=r,s=t[0],a=o&&this.anchor(s).absolutePosition,l=0,h,d=[];if(a)for(d.push(["M",a.x,a.y]);++l<r&&o;)s=t[l],h=s.command||"L",a=this.anchor(s).absolutePosition,h==="M"?d.push([h,a.x,a.y]):h==="L"?d.push([h,a.x,a.y]):h==="Z"&&d.push([h]),o=s.series.visible;return o?this.chart.renderer.crispLine(d,this.graphic.strokeWidth()):null},n.prototype.shouldBeDrawn=function(){return controllableMixin.shouldBeDrawn.call(this)||!!this.options.d},n.prototype.render=function(e){var t=this.options,r=this.attrsFromOptions(t);this.graphic=this.annotation.chart.renderer.path([["M",0,0]]).attr(r).add(e),t.className&&this.graphic.addClass(t.className),this.tracker=this.annotation.chart.renderer.path([["M",0,0]]).addClass("highcharts-tracker-line").attr({zIndex:2}).add(e),this.annotation.chart.styledMode||this.tracker.attr({"stroke-linejoin":"round",stroke:TRACKER_FILL,fill:TRACKER_FILL,"stroke-width":this.graphic.strokeWidth()+t.snap*2}),controllableMixin.render.call(this),extend$K(this.graphic,{markerStartSetter:markerMixin.markerStartSetter,markerEndSetter:markerMixin.markerEndSetter}),this.setMarkers(this)},n.prototype.redraw=function(e){var t=this.toD(),r=e?"animate":"attr";t?(this.graphic[r]({d:t}),this.tracker[r]({d:t})):(this.graphic.attr({d:"M 0 "+-9e9}),this.tracker.attr({d:"M 0 "+-9e9})),this.graphic.placed=this.tracker.placed=!!t,controllableMixin.redraw.call(this,e)},n.attrsMap={dashStyle:"dashstyle",strokeWidth:"stroke-width",stroke:"stroke",fill:"fill",zIndex:"zIndex"},n}(),merge$H=Utilities.merge,ControllableRect=function(){function n(e,t,r){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="rect",this.translate=controllableMixin.translateShape,this.init(e,t,r),this.collection="shapes"}return n.prototype.render=function(e){var t=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.rect(0,-9e9,0,0).attr(t).add(e),controllableMixin.render.call(this)},n.prototype.redraw=function(e){var t=this.anchor(this.points[0]).absolutePosition;t?this.graphic[e?"animate":"attr"]({x:t.x,y:t.y,width:this.options.width,height:this.options.height}):this.attr({x:0,y:-9e9}),this.graphic.placed=!!t,controllableMixin.redraw.call(this,e)},n.attrsMap=merge$H(ControllablePath.attrsMap,{width:"width",height:"height"}),n}(),merge$G=Utilities.merge,ControllableCircle=function(){function n(e,t,r){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="circle",this.translate=controllableMixin.translateShape,this.init(e,t,r),this.collection="shapes"}return n.prototype.render=function(e){var t=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.circle(0,-9e9,0).attr(t).add(e),controllableMixin.render.call(this)},n.prototype.redraw=function(e){var t=this.anchor(this.points[0]).absolutePosition;t?this.graphic[e?"animate":"attr"]({x:t.x,y:t.y,r:this.options.r}):this.graphic.attr({x:0,y:-9e9}),this.graphic.placed=!!t,controllableMixin.redraw.call(this,e)},n.prototype.setRadius=function(e){this.options.r=e},n.attrsMap=merge$G(ControllablePath.attrsMap,{r:"r"}),n}(),format$2=FormatUtilities.format,symbols$2=SVGRenderer.prototype.symbols,extend$J=Utilities.extend,isNumber$k=Utilities.isNumber,pick$L=Utilities.pick,ControllableLabel=function(){function n(e,t,r){this.addControlPoints=controllableMixin.addControlPoints,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.init(e,t,r),this.collection="labels"}return n.alignedPosition=function(e,t){var r=e.align,o=e.verticalAlign,s=(t.x||0)+(e.x||0),a=(t.y||0)+(e.y||0),l,h;return r==="right"?l=1:r==="center"&&(l=2),l&&(s+=(t.width-(e.width||0))/l),o==="bottom"?h=1:o==="middle"&&(h=2),h&&(a+=(t.height-(e.height||0))/h),{x:Math.round(s),y:Math.round(a)}},n.justifiedOptions=function(e,t,r,o){var s=r.align,a=r.verticalAlign,l=t.box?0:t.padding||0,h=t.getBBox(),d={align:s,verticalAlign:a,x:r.x,y:r.y,width:t.width,height:t.height},c=(o.x||0)-e.plotLeft,p=(o.y||0)-e.plotTop,f;return f=c+l,f<0&&(s==="right"?d.align="left":d.x=(d.x||0)-f),f=c+h.width-l,f>e.plotWidth&&(s==="left"?d.align="right":d.x=(d.x||0)+e.plotWidth-f),f=p+l,f<0&&(a==="bottom"?d.verticalAlign="top":d.y=(d.y||0)-f),f=p+h.height-l,f>e.plotHeight&&(a==="top"?d.verticalAlign="bottom":d.y=(d.y||0)+e.plotHeight-f),d},n.prototype.translatePoint=function(e,t){controllableMixin.translatePoint.call(this,e,t,0)},n.prototype.translate=function(e,t){var r=this.annotation.chart,o=this.annotation.userOptions,s=r.annotations.indexOf(this.annotation),a=r.options.annotations,l=a[s];if(r.inverted){var h=e;e=t,t=h}this.options.x+=e,this.options.y+=t,l[this.collection][this.index].x=this.options.x,l[this.collection][this.index].y=this.options.y,o[this.collection][this.index].x=this.options.x,o[this.collection][this.index].y=this.options.y},n.prototype.render=function(e){var t=this.options,r=this.attrsFromOptions(t),o=t.style;this.graphic=this.annotation.chart.renderer.label("",0,-9999,t.shape,null,null,t.useHTML,null,"annotation-label").attr(r).add(e),this.annotation.chart.styledMode||(o.color==="contrast"&&(o.color=this.annotation.chart.renderer.getContrast(n.shapesWithoutBackground.indexOf(t.shape)>-1?"#FFFFFF":t.backgroundColor)),this.graphic.css(t.style).shadow(t.shadow)),t.className&&this.graphic.addClass(t.className),this.graphic.labelrank=t.labelrank,controllableMixin.render.call(this)},n.prototype.redraw=function(e){var t=this.options,r=this.text||t.format||t.text,o=this.graphic,s=this.points[0];o.attr({text:r?format$2(r,s.getLabelConfig(),this.annotation.chart):t.formatter.call(s,this)});var a=this.anchor(s),l=this.position(a);l?(o.alignAttr=l,l.anchorX=a.absolutePosition.x,l.anchorY=a.absolutePosition.y,o[e?"animate":"attr"](l)):o.attr({x:0,y:-9999}),o.placed=!!l,controllableMixin.redraw.call(this,e)},n.prototype.anchor=function(e){var t=controllableMixin.anchor.apply(this,arguments),r=this.options.x||0,o=this.options.y||0;return t.absolutePosition.x-=r,t.absolutePosition.y-=o,t.relativePosition.x-=r,t.relativePosition.y-=o,t},n.prototype.position=function(e){var t=this.graphic,r=this.annotation.chart,o=this.points[0],s=this.options,a=e.absolutePosition,l=e.relativePosition,h,d,c,p,f=o.series.visible&&MockPoint.prototype.isInsidePlot.call(o),u=t.width,g=u===void 0?0:u,m=t.height,y=m===void 0?0:m;return f&&(s.distance?h=Tooltip.prototype.getPosition.call({chart:r,distance:pick$L(s.distance,16)},g,y,{plotX:l.x,plotY:l.y,negative:o.negative,ttBelow:o.ttBelow,h:l.height||l.width}):s.positioner?h=s.positioner.call(this):(d={x:a.x,y:a.y,width:0,height:0},h=n.alignedPosition(extend$J(s,{width:g,height:y}),d),this.options.overflow==="justify"&&(h=n.alignedPosition(n.justifiedOptions(r,t,s,h),d))),s.crop&&(c=h.x-r.plotLeft,p=h.y-r.plotTop,f=r.isInsidePlot(c,p)&&r.isInsidePlot(c+g,p+y))),f?h:null},n.attrsMap={backgroundColor:"fill",borderColor:"stroke",borderWidth:"stroke-width",zIndex:"zIndex",borderRadius:"r",padding:"padding"},n.shapesWithoutBackground=["connector"],n}();symbols$2.connector=function(n,e,t,r,o){var s=o&&o.anchorX,a=o&&o.anchorY,l,h,d=t/2;return isNumber$k(s)&&isNumber$k(a)&&(l=[["M",s,a]],h=e-a,h<0&&(h=-r-h),h<t&&(d=s<n+t/2?h:t-h),a>e+r?l.push(["L",n+d,e+r]):a<e?l.push(["L",n+d,e]):s<n?l.push(["L",n,e+r/2]):s>n+t&&l.push(["L",n+t,e+r/2])),l||[]};var ControllableImage=function(){function n(e,t,r){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="image",this.translate=controllableMixin.translateShape,this.init(e,t,r),this.collection="shapes"}return n.prototype.render=function(e){var t=this.attrsFromOptions(this.options),r=this.options;this.graphic=this.annotation.chart.renderer.image(r.src,0,-9e9,r.width,r.height).attr(t).add(e),this.graphic.width=r.width,this.graphic.height=r.height,controllableMixin.render.call(this)},n.prototype.redraw=function(e){var t=this.anchor(this.points[0]),r=ControllableLabel.prototype.position.call(this,t);r?this.graphic[e?"animate":"attr"]({x:r.x,y:r.y}):this.graphic.attr({x:0,y:-9e9}),this.graphic.placed=!!r,controllableMixin.redraw.call(this,e)},n.attrsMap={width:"width",height:"height",zIndex:"zIndex"},n}(),getDeferredAnimation=animationExports.getDeferredAnimation,chartProto=Chart$1.prototype,addEvent$t=Utilities.addEvent,defined$j=Utilities.defined,destroyObjectProperties=Utilities.destroyObjectProperties,erase=Utilities.erase,extend$I=Utilities.extend,find$5=Utilities.find,fireEvent$a=Utilities.fireEvent,merge$F=Utilities.merge,pick$K=Utilities.pick,splat$5=Utilities.splat,wrap$a=Utilities.wrap,Annotation=function(){function n(e,t){this.annotation=void 0,this.coll="annotations",this.collection=void 0,this.animationConfig=void 0,this.graphic=void 0,this.group=void 0,this.labelCollector=void 0,this.labelsGroup=void 0,this.shapesGroup=void 0;var r;this.chart=e,this.points=[],this.controlPoints=[],this.coll="annotations",this.labels=[],this.shapes=[],this.options=merge$F(this.defaultOptions,t),this.userOptions=t,r=this.getLabelsAndShapesOptions(this.options,t),this.options.labels=r.labels,this.options.shapes=r.shapes,this.init(e,this.options)}return n.prototype.init=function(){var e=this.chart,t=this.options.animation;this.linkPoints(),this.addControlPoints(),this.addShapes(),this.addLabels(),this.setLabelCollector(),this.animationConfig=getDeferredAnimation(e,t)},n.prototype.getLabelsAndShapesOptions=function(e,t){var r={};return["labels","shapes"].forEach(function(o){e[o]&&(t[o]?r[o]=splat$5(t[o]).map(function(s,a){return merge$F(e[o][a],s)}):r[o]=e[o])}),r},n.prototype.addShapes=function(){(this.options.shapes||[]).forEach(function(e,t){var r=this.initShape(e,t);merge$F(!0,this.options.shapes[t],r.options)},this)},n.prototype.addLabels=function(){(this.options.labels||[]).forEach(function(e,t){var r=this.initLabel(e,t);merge$F(!0,this.options.labels[t],r.options)},this)},n.prototype.addClipPaths=function(){this.setClipAxes(),this.clipXAxis&&this.clipYAxis&&(this.clipRect=this.chart.renderer.clipRect(this.getClipBox()))},n.prototype.setClipAxes=function(){var e=this.chart.xAxis,t=this.chart.yAxis,r=(this.options.labels||[]).concat(this.options.shapes||[]).reduce(function(o,s){var a=s&&(s.point||s.points&&s.points[0]);return[e[a&&a.xAxis]||o[0],t[a&&a.yAxis]||o[1]]},[]);this.clipXAxis=r[0],this.clipYAxis=r[1]},n.prototype.getClipBox=function(){if(this.clipXAxis&&this.clipYAxis)return{x:this.clipXAxis.left,y:this.clipYAxis.top,width:this.clipXAxis.width,height:this.clipYAxis.height}},n.prototype.setLabelCollector=function(){var e=this;e.labelCollector=function(){return e.labels.reduce(function(t,r){return r.options.allowOverlap||t.push(r.graphic),t},[])},e.chart.labelCollectors.push(e.labelCollector)},n.prototype.setOptions=function(e){this.options=merge$F(this.defaultOptions,e)},n.prototype.redraw=function(e){this.linkPoints(),this.graphic||this.render(),this.clipRect&&this.clipRect.animate(this.getClipBox()),this.redrawItems(this.shapes,e),this.redrawItems(this.labels,e),controllableMixin.redraw.call(this,e)},n.prototype.redrawItems=function(e,t){for(var r=e.length;r--;)this.redrawItem(e[r],t)},n.prototype.renderItems=function(e){for(var t=e.length;t--;)this.renderItem(e[t])},n.prototype.render=function(){var e=this.chart.renderer;this.graphic=e.g("annotation").attr({opacity:0,zIndex:this.options.zIndex,visibility:this.options.visible?"visible":"hidden"}).add(),this.shapesGroup=e.g("annotation-shapes").add(this.graphic).clip(this.chart.plotBoxClip),this.labelsGroup=e.g("annotation-labels").attr({translateX:0,translateY:0}).add(this.graphic),this.addClipPaths(),this.clipRect&&this.graphic.clip(this.clipRect),this.renderItems(this.shapes),this.renderItems(this.labels),this.addEvents(),controllableMixin.render.call(this)},n.prototype.setVisibility=function(e){var t=this.options,r=this.chart.navigationBindings,o=pick$K(e,!t.visible);this.graphic.attr("visibility",o?"visible":"hidden"),o||(this.setControlPointsVisibility(!1),r.activeAnnotation===this&&r.popup&&r.popup.formType==="annotation-toolbar"&&fireEvent$a(r,"closePopup")),t.visible=o},n.prototype.setControlPointsVisibility=function(e){var t=function(r){r.setControlPointsVisibility(e)};controllableMixin.setControlPointsVisibility.call(this,e),this.shapes.forEach(t),this.labels.forEach(t)},n.prototype.destroy=function(){var e=this.chart,t=function(r){r.destroy()};this.labels.forEach(t),this.shapes.forEach(t),this.clipXAxis=null,this.clipYAxis=null,erase(e.labelCollectors,this.labelCollector),eventEmitterMixin.destroy.call(this),controllableMixin.destroy.call(this),destroyObjectProperties(this,e)},n.prototype.remove=function(){return this.chart.removeAnnotation(this)},n.prototype.update=function(e,t){var r=this.chart,o=this.getLabelsAndShapesOptions(this.userOptions,e),s=r.annotations.indexOf(this),a=merge$F(!0,this.userOptions,e);a.labels=o.labels,a.shapes=o.shapes,this.destroy(),this.constructor(r,a),r.options.annotations[s]=a,this.isUpdating=!0,pick$K(t,!0)&&r.redraw(),fireEvent$a(this,"afterUpdate"),this.isUpdating=!1},n.prototype.initShape=function(e,t){var r=merge$F(this.options.shapeOptions,{controlPointOptions:this.options.controlPointOptions},e),o=new n.shapesMap[r.type](this,r,t);return o.itemType="shape",this.shapes.push(o),o},n.prototype.initLabel=function(e,t){var r=merge$F(this.options.labelOptions,{controlPointOptions:this.options.controlPointOptions},e),o=new ControllableLabel(this,r,t);return o.itemType="label",this.labels.push(o),o},n.prototype.redrawItem=function(e,t){e.linkPoints(),e.shouldBeDrawn()?(e.graphic||this.renderItem(e),e.redraw(pick$K(t,!0)&&e.graphic.placed),e.points.length&&this.adjustVisibility(e)):this.destroyItem(e)},n.prototype.adjustVisibility=function(e){var t=!1,r=e.graphic;e.points.forEach(function(o){o.series.visible!==!1&&o.visible!==!1&&(t=!0)}),t?r.visibility==="hidden"&&r.show():r.hide()},n.prototype.destroyItem=function(e){erase(this[e.itemType+"s"],e),e.destroy()},n.prototype.renderItem=function(e){e.render(e.itemType==="label"?this.labelsGroup:this.shapesGroup)},n.ControlPoint=ControlPoint,n.MockPoint=MockPoint,n.shapesMap={rect:ControllableRect,circle:ControllableCircle,path:ControllablePath,image:ControllableImage},n.types={},n}();merge$F(!0,Annotation.prototype,controllableMixin,eventEmitterMixin,merge$F(Annotation.prototype,{nonDOMEvents:["add","afterUpdate","drag","remove"],defaultOptions:{visible:!0,animation:{},draggable:"xy",labelOptions:{align:"center",allowOverlap:!1,backgroundColor:"rgba(0, 0, 0, 0.75)",borderColor:palette.neutralColor100,borderRadius:3,borderWidth:1,className:"highcharts-no-tooltip",crop:!1,formatter:function(){return defined$j(this.y)?this.y:"Annotation label"},includeInDataExport:!0,overflow:"justify",padding:5,shadow:!1,shape:"callout",style:{fontSize:"11px",fontWeight:"normal",color:"contrast"},useHTML:!1,verticalAlign:"bottom",x:0,y:-16},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1,fill:"rgba(0, 0, 0, 0.75)",r:0,snap:2},controlPointOptions:{symbol:"circle",width:10,height:10,style:{stroke:palette.neutralColor100,"stroke-width":2,fill:palette.backgroundColor},visible:!1,events:{}},events:{},zIndex:6}}));H.extendAnnotation=function(n,e,t,r){e=e||Annotation,extend$I(n.prototype,merge$F(e.prototype,t)),n.prototype.defaultOptions=merge$F(n.prototype.defaultOptions,r||{})};extend$I(chartProto,{initAnnotation:function(n){var e=Annotation.types[n.type]||Annotation,t=new e(this,n);return this.annotations.push(t),t},addAnnotation:function(n,e){var t=this.initAnnotation(n);return this.options.annotations.push(t.options),pick$K(e,!0)&&(t.redraw(),t.graphic.attr({opacity:1})),t},removeAnnotation:function(n){var e=this.annotations,t=n.coll==="annotations"?n:find$5(e,function(r){return r.options.id===n});t&&(fireEvent$a(t,"remove"),erase(this.options.annotations,t.options),erase(e,t),t.destroy())},drawAnnotations:function(){this.plotBoxClip.attr(this.plotBox),this.annotations.forEach(function(n){n.redraw(),n.graphic.animate({opacity:1},n.animationConfig)})}});chartProto.collectionsWithUpdate.push("annotations");chartProto.collectionsWithInit.annotations=[chartProto.addAnnotation];addEvent$t(Chart$1,"afterInit",function(){this.annotations=[],this.options.annotations||(this.options.annotations=[])});chartProto.callbacks.push(function(n){n.plotBoxClip=this.renderer.clipRect(this.plotBox),n.controlPointsGroup=n.renderer.g("control-points").attr({zIndex:99}).clip(n.plotBoxClip).add(),n.options.annotations.forEach(function(e,t){if(!n.annotations.some(function(o){return o.options===e})){var r=n.initAnnotation(e);n.options.annotations[t]=r.options}}),n.drawAnnotations(),addEvent$t(n,"redraw",n.drawAnnotations),addEvent$t(n,"destroy",function(){n.plotBoxClip.destroy(),n.controlPointsGroup.destroy()}),addEvent$t(n,"exportData",function(e){var t=n.annotations,r=(this.options.exporting&&this.options.exporting.csv||{}).columnHeaderFormatter,o=!e.dataRows[1].xValues,s=n.options.lang&&n.options.lang.exportData&&n.options.lang.exportData.annotationHeader,a=function(g){var m;return r&&(m=r(g),m!==!1)?m:(m=s+" "+g,o?{columnTitle:m,topLevelColumnTitle:m}:m)},l=e.dataRows[0].length,h=n.options.exporting&&n.options.exporting.csv&&n.options.exporting.csv.annotations&&n.options.exporting.csv.annotations.itemDelimiter,d=n.options.exporting&&n.options.exporting.csv&&n.options.exporting.csv.annotations&&n.options.exporting.csv.annotations.join;t.forEach(function(g){g.options.labelOptions.includeInDataExport&&g.labels.forEach(function(m){if(m.options.text){var y=m.options.text;m.points.forEach(function(v){var x=v.x,b=v.series.xAxis?v.series.xAxis.options.index:-1,$=!1;if(b===-1){for(var S=e.dataRows[0].length,k=new Array(S),A=0;A<S;++A)k[A]="";k.push(y),k.xValues=[],k.xValues[b]=x,e.dataRows.push(k),$=!0}if($||e.dataRows.forEach(function(M,P){!$&&M.xValues&&b!==void 0&&x===M.xValues[b]&&(d&&M.length>l?M[M.length-1]+=h+y:M.push(y),$=!0)}),!$){for(var S=e.dataRows[0].length,k=new Array(S),A=0;A<S;++A)k[A]="";k[0]=x,k.push(y),k.xValues=[],b!==void 0&&(k.xValues[b]=x),e.dataRows.push(k)}})}})});var c=0;e.dataRows.forEach(function(g){c=Math.max(c,g.length)});for(var p=c-e.dataRows[0].length,f=0;f<p;f++){var u=a(f+1);o?(e.dataRows[0].push(u.topLevelColumnTitle),e.dataRows[1].push(u.columnTitle)):e.dataRows[0].push(u)}})});wrap$a(Pointer.prototype,"onContainerMouseDown",function(n){this.chart.hasDraggedAnnotation||n.apply(this,Array.prototype.slice.call(arguments,1))});H.Annotation=Annotation;var chartNavigation={initUpdate:function(n){n.navigation||(n.navigation={updates:[],update:function(e,t){this.updates.forEach(function(r){r.update.call(r.context,e,t)})}})},addUpdate:function(n,e){e.navigation||this.initUpdate(e),e.navigation.updates.push({update:n,context:e})}},format$1=FormatUtilities.format,setOptions$1=DefaultOptions.setOptions,addEvent$s=Utilities.addEvent,attr=Utilities.attr,fireEvent$9=Utilities.fireEvent,isArray$7=Utilities.isArray,isFunction$1=Utilities.isFunction,isNumber$j=Utilities.isNumber,isObject$6=Utilities.isObject,merge$E=Utilities.merge,objectEach$b=Utilities.objectEach,pick$J=Utilities.pick,doc$4=H.doc,win$2=H.win,PREFIX$1="highcharts-";function closestPolyfill(n,e){var t=win$2.Element.prototype,r=t.matches||t.msMatchesSelector||t.webkitMatchesSelector,o=null;if(t.closest)o=t.closest.call(n,e);else do{if(r.call(n,e))return n;n=n.parentElement||n.parentNode}while(n!==null&&n.nodeType===1);return o}var bindingsUtils={getFieldType:function(n){return{string:"text",number:"number",boolean:"checkbox"}[typeof n]},updateRectSize:function(n,e){var t=e.chart,r=e.options.typeOptions,o=isNumber$j(r.xAxis)&&t.xAxis[r.xAxis],s=isNumber$j(r.yAxis)&&t.yAxis[r.yAxis];if(o&&s){var a=o.toValue(n[o.horiz?"chartX":"chartY"]),l=s.toValue(n[s.horiz?"chartX":"chartY"]),h=a-r.point.x,d=r.point.y-l;e.update({typeOptions:{background:{width:t.inverted?d:h,height:t.inverted?h:d}}})}},getAssignedAxis:function(n){return n.filter(function(e){var t=e.axis.min,r=e.axis.max,o=pick$J(e.axis.minPointOffset,0);return isNumber$j(t)&&isNumber$j(r)&&e.value>=t-o&&e.value<=r+o&&!e.axis.options.isInternal})[0]}},NavigationBindings=function(){function n(e,t){this.boundClassNames=void 0,this.selectedButton=void 0,this.chart=e,this.options=t,this.eventsToUnbind=[],this.container=doc$4.getElementsByClassName(this.options.bindingsClassName||"")}return n.prototype.initEvents=function(){var e=this,t=e.chart,r=e.container,o=e.options;e.boundClassNames={},objectEach$b(o.bindings||{},function(s){e.boundClassNames[s.className]=s}),[].forEach.call(r,function(s){e.eventsToUnbind.push(addEvent$s(s,"click",function(a){var l=e.getButtonEvents(s,a);l&&l.button.className.indexOf("highcharts-disabled-btn")===-1&&e.bindingsButtonClick(l.button,l.events,a)}))}),objectEach$b(o.events||{},function(s,a){isFunction$1(s)&&e.eventsToUnbind.push(addEvent$s(e,a,s,{passive:!1}))}),e.eventsToUnbind.push(addEvent$s(t.container,"click",function(s){!t.cancelClick&&t.isInsidePlot(s.chartX-t.plotLeft,s.chartY-t.plotTop,{visiblePlotOnly:!0})&&e.bindingsChartClick(this,s)})),e.eventsToUnbind.push(addEvent$s(t.container,H.isTouchDevice?"touchmove":"mousemove",function(s){e.bindingsContainerMouseMove(this,s)},H.isTouchDevice?{passive:!1}:void 0))},n.prototype.initUpdate=function(){var e=this;chartNavigation.addUpdate(function(t){e.update(t)},this.chart)},n.prototype.bindingsButtonClick=function(e,t,r){var o=this,s=o.chart;o.selectedButtonElement&&(fireEvent$9(o,"deselectButton",{button:o.selectedButtonElement}),o.nextEvent&&(o.currentUserDetails&&o.currentUserDetails.coll==="annotations"&&s.removeAnnotation(o.currentUserDetails),o.mouseMoveEvent=o.nextEvent=!1)),o.selectedButton=t,o.selectedButtonElement=e,fireEvent$9(o,"selectButton",{button:e}),t.init&&t.init.call(o,e,r),(t.start||t.steps)&&s.renderer.boxWrapper.addClass(PREFIX$1+"draw-mode")},n.prototype.bindingsChartClick=function(e,t){e=this.chart;var r=this,o=r.activeAnnotation,s=r.selectedButton,a=e.renderer.boxWrapper;o&&(!o.cancelClick&&!t.activeAnnotation&&t.target.parentNode&&!closestPolyfill(t.target,"."+PREFIX$1+"popup")?fireEvent$9(r,"closePopup"):o.cancelClick&&setTimeout(function(){o.cancelClick=!1},0)),!(!s||!s.start)&&(r.nextEvent?(r.nextEvent(t,r.currentUserDetails),r.steps&&(r.stepIndex++,s.steps[r.stepIndex]?r.mouseMoveEvent=r.nextEvent=s.steps[r.stepIndex]:(fireEvent$9(r,"deselectButton",{button:r.selectedButtonElement}),a.removeClass(PREFIX$1+"draw-mode"),s.end&&s.end.call(r,t,r.currentUserDetails),r.nextEvent=!1,r.mouseMoveEvent=!1,r.selectedButton=null))):(r.currentUserDetails=s.start.call(r,t),r.currentUserDetails&&s.steps?(r.stepIndex=0,r.steps=!0,r.mouseMoveEvent=r.nextEvent=s.steps[r.stepIndex]):(fireEvent$9(r,"deselectButton",{button:r.selectedButtonElement}),a.removeClass(PREFIX$1+"draw-mode"),r.steps=!1,r.selectedButton=null,s.end&&s.end.call(r,t,r.currentUserDetails))))},n.prototype.bindingsContainerMouseMove=function(e,t){this.mouseMoveEvent&&this.mouseMoveEvent(t,this.currentUserDetails)},n.prototype.fieldsToOptions=function(e,t){return objectEach$b(e,function(r,o){var s=parseFloat(r),a=o.split("."),l=t,h=a.length-1;isNumber$j(s)&&!r.match(/px/g)&&!o.match(/format/g)&&(r=s),r!==""&&r!=="undefined"&&a.forEach(function(d,c){var p=pick$J(a[c+1],"");h===c?l[d]=r:(l[d]||(l[d]=p.match(/\d/g)?[]:{}),l=l[d])})}),t},n.prototype.deselectAnnotation=function(){this.activeAnnotation&&(this.activeAnnotation.setControlPointsVisibility(!1),this.activeAnnotation=!1)},n.prototype.annotationToFields=function(e){var t=e.options,r=n.annotationsEditable,o=r.nestedOptions,s=this.utils.getFieldType,a=pick$J(t.type,t.shapes&&t.shapes[0]&&t.shapes[0].type,t.labels&&t.labels[0]&&t.labels[0].itemType,"label"),l=n.annotationsNonEditable[t.langKey]||[],h={langKey:t.langKey,type:a};function d(c,p,f,u){var g;f&&c&&l.indexOf(p)===-1&&((f.indexOf&&f.indexOf(p))>=0||f[p]||f===!0)&&(isArray$7(c)?(u[p]=[],c.forEach(function(m,y){isObject$6(m)?(u[p][y]={},objectEach$b(m,function(v,x){d(v,x,o[p],u[p][y])})):d(m,0,o[p],u[p])})):isObject$6(c)?(g={},isArray$7(u)?(u.push(g),g[p]={},g=g[p]):u[p]=g,objectEach$b(c,function(m,y){d(m,y,p===0?f:o[p],g)})):p==="format"?u[p]=[format$1(c,e.labels[0].points[0]).toString(),"text"]:isArray$7(u)?u.push([c,s(c)]):u[p]=[c,s(c)])}return objectEach$b(t,function(c,p){p==="typeOptions"?(h[p]={},objectEach$b(t[p],function(f,u){d(f,u,o,h[p])})):d(c,p,r[a],h)}),h},n.prototype.getClickedClassNames=function(e,t){for(var r=t.target,o=[],s;r;)if(s=attr(r,"class"),s&&(o=o.concat(s.split(" ").map(function(a){return[a,r]}))),r=r.parentNode,r===e)return o;return o},n.prototype.getButtonEvents=function(e,t){var r=this,o=this.getClickedClassNames(e,t),s;return o.forEach(function(a){r.boundClassNames[a[0]]&&!s&&(s={events:r.boundClassNames[a[0]],button:a[1]})}),s},n.prototype.update=function(e){this.options=merge$E(!0,this.options,e),this.removeEvents(),this.initEvents()},n.prototype.removeEvents=function(){this.eventsToUnbind.forEach(function(e){e()})},n.prototype.destroy=function(){this.removeEvents()},n.annotationsEditable={nestedOptions:{labelOptions:["style","format","backgroundColor"],labels:["style"],label:["style"],style:["fontSize","color"],background:["fill","strokeWidth","stroke"],innerBackground:["fill","strokeWidth","stroke"],outerBackground:["fill","strokeWidth","stroke"],shapeOptions:["fill","strokeWidth","stroke"],shapes:["fill","strokeWidth","stroke"],line:["strokeWidth","stroke"],backgroundColors:[!0],connector:["fill","strokeWidth","stroke"],crosshairX:["strokeWidth","stroke"],crosshairY:["strokeWidth","stroke"]},circle:["shapes"],verticalLine:[],label:["labelOptions"],measure:["background","crosshairY","crosshairX"],fibonacci:[],tunnel:["background","line","height"],pitchfork:["innerBackground","outerBackground"],rect:["shapes"],crookedLine:[],basicAnnotation:["shapes","labelOptions"]},n.annotationsNonEditable={rectangle:["crosshairX","crosshairY","label"]},n}();NavigationBindings.prototype.utils=bindingsUtils;Chart$1.prototype.initNavigationBindings=function(){var n=this,e=n.options;e&&e.navigation&&e.navigation.bindings&&(n.navigationBindings=new NavigationBindings(n,e.navigation),n.navigationBindings.initEvents(),n.navigationBindings.initUpdate())};addEvent$s(Chart$1,"load",function(){this.initNavigationBindings()});addEvent$s(Chart$1,"destroy",function(){this.navigationBindings&&this.navigationBindings.destroy()});addEvent$s(NavigationBindings,"deselectButton",function(){this.selectedButtonElement=null});addEvent$s(Annotation,"remove",function(){this.chart.navigationBindings&&this.chart.navigationBindings.deselectAnnotation()});function selectableAnnotation(n){var e=n.prototype.defaultOptions.events&&n.prototype.defaultOptions.events.click;function t(r){var o=this,s=o.chart.navigationBindings,a=s.activeAnnotation;e&&e.call(o,r),a!==o?(s.deselectAnnotation(),s.activeAnnotation=o,o.setControlPointsVisibility(!0),fireEvent$9(s,"showPopup",{annotation:o,formType:"annotation-toolbar",options:s.annotationToFields(o),onSubmit:function(l){var h={},d;l.actionType==="remove"?(s.activeAnnotation=!1,s.chart.removeAnnotation(o)):(s.fieldsToOptions(l.fields,h),s.deselectAnnotation(),d=h.typeOptions,o.options.type==="measure"&&(d.crosshairY.enabled=d.crosshairY.strokeWidth!==0,d.crosshairX.enabled=d.crosshairX.strokeWidth!==0),o.update(h))}})):fireEvent$9(s,"closePopup"),r.activeAnnotation=!0}merge$E(!0,n.prototype.defaultOptions.events,{click:t})}H.Annotation&&(selectableAnnotation(Annotation),objectEach$b(Annotation.types,function(n){selectableAnnotation(n)}));setOptions$1({lang:{navigation:{popup:{simpleShapes:"Simple shapes",lines:"Lines",circle:"Circle",rectangle:"Rectangle",label:"Label",shapeOptions:"Shape options",typeOptions:"Details",fill:"Fill",format:"Text",strokeWidth:"Line width",stroke:"Line color",title:"Title",name:"Name",labelOptions:"Label options",labels:"Labels",backgroundColor:"Background color",backgroundColors:"Background colors",borderColor:"Border color",borderRadius:"Border radius",borderWidth:"Border width",style:"Style",padding:"Padding",fontSize:"Font size",color:"Color",height:"Height",shapes:"Shape options"}}},navigation:{bindingsClassName:"highcharts-bindings-container",bindings:{circleAnnotation:{className:"highcharts-circle-annotation",start:function(n){var e=this.chart.pointer.getCoordinates(n),t=this.utils.getAssignedAxis(e.xAxis),r=this.utils.getAssignedAxis(e.yAxis),o=this.chart.options.navigation;if(!(!t||!r))return this.chart.addAnnotation(merge$E({langKey:"circle",type:"basicAnnotation",shapes:[{type:"circle",point:{x:t.value,y:r.value,xAxis:t.axis.options.index,yAxis:r.axis.options.index},r:5}]},o.annotationsOptions,o.bindings.circleAnnotation.annotationsOptions))},steps:[function(n,e){var t=e.options.shapes[0].point,r=this.chart.inverted,o,s,a;isNumber$j(t.xAxis)&&isNumber$j(t.yAxis)&&(o=this.chart.xAxis[t.xAxis].toPixels(t.x),s=this.chart.yAxis[t.yAxis].toPixels(t.y),a=Math.max(Math.sqrt(Math.pow(r?s-n.chartX:o-n.chartX,2)+Math.pow(r?o-n.chartY:s-n.chartY,2)),5)),e.update({shapes:[{r:a}]})}]},rectangleAnnotation:{className:"highcharts-rectangle-annotation",start:function(n){var e=this.chart.pointer.getCoordinates(n),t=this.utils.getAssignedAxis(e.xAxis),r=this.utils.getAssignedAxis(e.yAxis);if(!(!t||!r)){var o=t.value,s=r.value,a=t.axis.options.index,l=r.axis.options.index,h=this.chart.options.navigation;return this.chart.addAnnotation(merge$E({langKey:"rectangle",type:"basicAnnotation",shapes:[{type:"path",points:[{xAxis:a,yAxis:l,x:o,y:s},{xAxis:a,yAxis:l,x:o,y:s},{xAxis:a,yAxis:l,x:o,y:s},{xAxis:a,yAxis:l,x:o,y:s}]}]},h.annotationsOptions,h.bindings.rectangleAnnotation.annotationsOptions))}},steps:[function(n,e){var t=e.options.shapes[0].points,r=this.chart.pointer.getCoordinates(n),o=this.utils.getAssignedAxis(r.xAxis),s=this.utils.getAssignedAxis(r.yAxis),a,l;o&&s&&(a=o.value,l=s.value,t[1].x=a,t[2].x=a,t[2].y=l,t[3].y=l,e.update({shapes:[{points:t}]}))}]},labelAnnotation:{className:"highcharts-label-annotation",start:function(n){var e=this.chart.pointer.getCoordinates(n),t=this.utils.getAssignedAxis(e.xAxis),r=this.utils.getAssignedAxis(e.yAxis),o=this.chart.options.navigation;if(!(!t||!r))return this.chart.addAnnotation(merge$E({langKey:"label",type:"basicAnnotation",labelOptions:{format:"{y:.2f}"},labels:[{point:{xAxis:t.axis.options.index,yAxis:r.axis.options.index,x:t.value,y:r.value},overflow:"none",crop:!0}]},o.annotationsOptions,o.bindings.labelAnnotation.annotationsOptions))}}},events:{},annotationsOptions:{animation:{defer:0}}}});addEvent$s(Chart$1,"render",function(){var n=this,e=n.navigationBindings,t="highcharts-disabled-btn";if(n&&e){var r=!1;n.series.forEach(function(o){!o.options.isInternal&&o.visible&&(r=!0)}),objectEach$b(e.boundClassNames,function(o,s){if(n.navigationBindings&&n.navigationBindings.container&&n.navigationBindings.container[0]){var a=n.navigationBindings.container[0].querySelectorAll("."+s);if(a)for(var l=0;l<a.length;l++){var h=a[l];o.noDataState==="normal"||r?h.className.indexOf(t)!==-1&&h.classList.remove(t):h.className.indexOf(t)===-1&&(h.className+=" "+t)}}})}});addEvent$s(NavigationBindings,"closePopup",function(){this.deselectAnnotation()});var doc$3=H.doc,isFirefox=H.isFirefox,getOptions$1=DefaultOptions.getOptions,addEvent$r=Utilities.addEvent,createElement$2=Utilities.createElement,defined$i=Utilities.defined,fireEvent$8=Utilities.fireEvent,isArray$6=Utilities.isArray,isObject$5=Utilities.isObject,isString$1=Utilities.isString,objectEach$a=Utilities.objectEach,pick$I=Utilities.pick,stableSort$3=Utilities.stableSort,wrap$9=Utilities.wrap,indexFilter=/\d/g,PREFIX="highcharts-",DIV="div",INPUT="input",LABEL="label",BUTTON="button",SELECT="select",OPTION="option",SPAN="span",UL="ul",LI="li",H3="h3";wrap$9(Pointer.prototype,"onContainerMouseDown",function(n,e){var t=e.target&&e.target.className;isString$1(t)&&t.indexOf(PREFIX+"popup-field")>=0||n.apply(this,Array.prototype.slice.call(arguments,1))});H.Popup=function(n,e,t){this.init(n,e,t)};H.Popup.prototype={init:function(n,e,t){this.chart=t,this.container=createElement$2(DIV,{className:PREFIX+"popup highcharts-no-tooltip"},null,n),this.lang=this.getLangpack(),this.iconsURL=e,this.addCloseBtn()},addCloseBtn:function(){var n=this,e,t=this.iconsURL;e=createElement$2(DIV,{className:PREFIX+"popup-close"},null,this.container),e.style["background-image"]="url("+(t.match(/png|svg|jpeg|jpg|gif/ig)?t:t+"close.svg")+")",["click","touchstart"].forEach(function(r){addEvent$r(e,r,function(){n.chart?fireEvent$8(n.chart.navigationBindings,"closePopup"):n.closePopup()})})},addColsContainer:function(n){var e,t;return t=createElement$2(DIV,{className:PREFIX+"popup-lhs-col"},null,n),e=createElement$2(DIV,{className:PREFIX+"popup-rhs-col"},null,n),createElement$2(DIV,{className:PREFIX+"popup-rhs-col-wrapper"},null,e),{lhsCol:t,rhsCol:e}},addInput:function(n,e,t,r){var o=n.split("."),s=o[o.length-1],a=this.lang,l=PREFIX+e+"-"+s;l.match(indexFilter)||createElement$2(LABEL,{htmlFor:l},void 0,t).appendChild(doc$3.createTextNode(a[s]||s)),r!==""&&createElement$2(INPUT,{name:l,value:r[0],type:r[1],className:PREFIX+"popup-field"},void 0,t).setAttribute(PREFIX+"data-name",n)},addButton:function(n,e,t,r,o){var s=this,a=this.closePopup,l=this.getFields,h;return h=createElement$2(BUTTON,void 0,void 0,n),h.appendChild(doc$3.createTextNode(e)),["click","touchstart"].forEach(function(d){addEvent$r(h,d,function(){return a.call(s),r(l(o,t))})}),h},getFields:function(n,e){var t=n.querySelectorAll("input"),r="#"+PREFIX+"select-series > option:checked",o="#"+PREFIX+"select-volume > option:checked",s=n.querySelectorAll(r)[0],a=n.querySelectorAll(o)[0],l,h,d;return d={actionType:e,linkedTo:s&&s.getAttribute("value"),fields:{}},[].forEach.call(t,function(c){h=c.getAttribute(PREFIX+"data-name"),l=c.getAttribute(PREFIX+"data-series-id"),l?d.seriesId=c.value:h?d.fields[h]=c.value:d.type=c.value}),a&&(d.fields["params.volumeSeriesID"]=a.getAttribute("value")),d},showPopup:function(){var n=this.container,e=PREFIX+"annotation-toolbar",t=n.querySelectorAll("."+PREFIX+"popup-close")[0];this.formType=void 0,n.innerHTML="",n.className.indexOf(e)>=0&&(n.classList.remove(e),n.removeAttribute("style")),n.appendChild(t),n.style.display="block",n.style.height=""},closePopup:function(){var n=pick$I(this.popup&&this.popup.container,this.container);n.style.display="none"},showForm:function(n,e,t,r){e&&(this.popup=e.navigationBindings.popup,this.showPopup(),n==="indicators"&&this.indicators.addForm.call(this,e,t,r),n==="annotation-toolbar"&&this.annotations.addToolbar.call(this,e,t,r),n==="annotation-edit"&&this.annotations.addForm.call(this,e,t,r),n==="flag"&&this.annotations.addForm.call(this,e,t,r,!0),this.formType=n,this.container.style.height=this.container.offsetHeight+"px")},getLangpack:function(){return getOptions$1().lang.navigation.popup},annotations:{addToolbar:function(n,e,t){var r=this,o=this.lang,s=this.popup.container,a=this.showForm,l=PREFIX+"annotation-toolbar",h;s.className.indexOf(l)===-1&&(s.className+=" "+l),n&&(s.style.top=n.plotTop+10+"px"),createElement$2(SPAN,void 0,void 0,s).appendChild(doc$3.createTextNode(pick$I(o[e.langKey]||e.langKey,e.shapes&&e.shapes[0].type))),h=this.addButton(s,o.removeButton||"remove","remove",t,s),h.className+=" "+PREFIX+"annotation-remove-button",h.style["background-image"]="url("+this.iconsURL+"destroy.svg)",h=this.addButton(s,o.editButton||"edit","edit",function(){a.call(r,"annotation-edit",n,e,t)},s),h.className+=" "+PREFIX+"annotation-edit-button",h.style["background-image"]="url("+this.iconsURL+"edit.svg)"},addForm:function(n,e,t,r){var o=this.popup.container,s=this.lang,a,l;n&&(l=createElement$2("h2",{className:PREFIX+"popup-main-title"},void 0,o),l.appendChild(doc$3.createTextNode(s[e.langKey]||e.langKey||"")),l=createElement$2(DIV,{className:PREFIX+"popup-lhs-col "+PREFIX+"popup-lhs-full"},null,o),a=createElement$2(DIV,{className:PREFIX+"popup-bottom-row"},null,o),this.annotations.addFormFields.call(this,l,n,"",e,[],!0),this.addButton(a,r?s.addButton||"add":s.saveButton||"save",r?"add":"save",t,o))},addFormFields:function(n,e,t,r,o,s){var a=this,l=this.annotations.addFormFields,h=this.addInput,d=this.lang,c,p;e&&(objectEach$a(r,function(f,u){c=t!==""?t+"."+u:u,isObject$5(f)&&(!isArray$6(f)||isArray$6(f)&&isObject$5(f[0])?(p=d[u]||u,p.match(indexFilter)||o.push([!0,p,n]),l.call(a,n,e,c,f,o,!1)):o.push([a,c,"annotation",n,f]))}),s&&(stableSort$3(o,function(f){return f[1].match(/format/g)?-1:1}),isFirefox&&o.reverse(),o.forEach(function(f){f[0]===!0?createElement$2(SPAN,{className:PREFIX+"annotation-title"},void 0,f[2]).appendChild(doc$3.createTextNode(f[1])):h.apply(f[0],f.splice(1))})))}},indicators:{addForm:function(n,e,t){var r,o=this.indicators,s=this.lang,a;n&&(this.tabs.init.call(this,n),r=this.popup.container.querySelectorAll("."+PREFIX+"tab-item-content"),this.addColsContainer(r[0]),o.addIndicatorList.call(this,n,r[0],"add"),a=r[0].querySelectorAll("."+PREFIX+"popup-rhs-col")[0],this.addButton(a,s.addButton||"add","add",t,a),this.addColsContainer(r[1]),o.addIndicatorList.call(this,n,r[1],"edit"),a=r[1].querySelectorAll("."+PREFIX+"popup-rhs-col")[0],this.addButton(a,s.saveButton||"save","edit",t,a),this.addButton(a,s.removeButton||"remove","remove",t,a))},addIndicatorList:function(n,e,t){var r=this,o=e.querySelectorAll("."+PREFIX+"popup-lhs-col")[0],s=e.querySelectorAll("."+PREFIX+"popup-rhs-col")[0],a=t==="edit",l=a?n.series:n.options.plotOptions,h=this.indicators.addFormFields,d,c,p;n&&(c=createElement$2(UL,{className:PREFIX+"indicator-list"},null,o),d=s.querySelectorAll("."+PREFIX+"popup-rhs-col-wrapper")[0],objectEach$a(l,function(f,u){var g=f.options;if(f.params||g&&g.params){var m=r.indicators.getNameType(f,u),y=m.type;p=createElement$2(LI,{className:PREFIX+"indicator-list"},void 0,c),p.appendChild(doc$3.createTextNode(m.name)),["click","touchstart"].forEach(function(v){addEvent$r(p,v,function(){h.call(r,n,a?f:l[y],m.type,d),a&&f.options&&createElement$2(INPUT,{type:"hidden",name:PREFIX+"id-"+y,value:f.options.id},null,d).setAttribute(PREFIX+"data-series-id",f.options.id)})})}}),c.childNodes.length>0&&c.childNodes[0].click())},getNameType:function(n,e){var t=n.options,r=H.seriesTypes,o=r[e]&&r[e].prototype.nameBase||e.toUpperCase(),s=e;return t&&t.type&&(s=n.options.type,o=n.name),{name:o,type:s}},listAllSeries:function(n,e,t,r,o){var s=PREFIX+e+"-type-"+n,a=this.lang,l,h;t&&(createElement$2(LABEL,{htmlFor:s},null,r).appendChild(doc$3.createTextNode(a[e]||e)),l=createElement$2(SELECT,{name:s,className:PREFIX+"popup-field"},null,r),l.setAttribute("id",PREFIX+"select-"+e),t.series.forEach(function(d){h=d.options,!h.params&&h.id&&h.id!==PREFIX+"navigator-series"&&createElement$2(OPTION,{value:h.id},null,l).appendChild(doc$3.createTextNode(h.name||h.id))}),defined$i(o)&&(l.value=o))},addFormFields:function(n,e,t,r){var o=e.params||e.options.params,s=this.indicators.getNameType;r.innerHTML="",createElement$2(H3,{className:PREFIX+"indicator-title"},void 0,r).appendChild(doc$3.createTextNode(s(e,t).name)),createElement$2(INPUT,{type:"hidden",name:PREFIX+"type-"+t,value:t},null,r),this.indicators.listAllSeries.call(this,t,"series",n,r,e.linkedParent&&o.volumeSeriesID),o.volumeSeriesID&&this.indicators.listAllSeries.call(this,t,"volume",n,r,e.linkedParent&&e.linkedParent.options.id),this.indicators.addParamInputs.call(this,n,"params",o,t,r)},addParamInputs:function(n,e,t,r,o){var s=this,a=this.indicators.addParamInputs,l=this.addInput,h;n&&objectEach$a(t,function(d,c){h=e+"."+c,d!==void 0&&(isObject$5(d)?(l.call(s,h,r,o,""),a.call(s,n,h,d,r,o)):h!=="params.volumeSeriesID"&&l.call(s,h,r,o,[d,"text"]))})},getAmount:function(){var n=this.series,e=0;return n.forEach(function(t){var r=t.options;(t.params||r&&r.params)&&e++}),e}},tabs:{init:function(n){var e=this.tabs,t=this.indicators.getAmount.call(n),r;n&&(r=e.addMenuItem.call(this,"add"),e.addMenuItem.call(this,"edit",t),e.addContentItem.call(this,"add"),e.addContentItem.call(this,"edit"),e.switchTabs.call(this,t),e.selectTab.call(this,r,0))},addMenuItem:function(n,e){var t=this.popup.container,r=PREFIX+"tab-item",o=this.lang,s;return e===0&&(r+=" "+PREFIX+"tab-disabled"),s=createElement$2(SPAN,{className:r},void 0,t),s.appendChild(doc$3.createTextNode(o[n+"Button"]||n)),s.setAttribute(PREFIX+"data-tab-type",n),s},addContentItem:function(){var n=this.popup.container;return createElement$2(DIV,{className:PREFIX+"tab-item-content "+PREFIX+"no-mousewheel"},null,n)},switchTabs:function(n){var e=this,t=this.popup.container,r=t.querySelectorAll("."+PREFIX+"tab-item"),o;r.forEach(function(s,a){o=s.getAttribute(PREFIX+"data-tab-type"),!(o==="edit"&&n===0)&&["click","touchstart"].forEach(function(l){addEvent$r(s,l,function(){e.tabs.deselectAll.call(e),e.tabs.selectTab.call(e,this,a)})})})},selectTab:function(n,e){var t=this.popup.container.querySelectorAll("."+PREFIX+"tab-item-content");n.className+=" "+PREFIX+"tab-item-active",t[e].className+=" "+PREFIX+"tab-item-show"},deselectAll:function(){var n=this.popup.container,e=n.querySelectorAll("."+PREFIX+"tab-item"),t=n.querySelectorAll("."+PREFIX+"tab-item-content"),r;for(r=0;r<e.length;r++)e[r].classList.remove(PREFIX+"tab-item-active"),t[r].classList.remove(PREFIX+"tab-item-show")}}};addEvent$r(NavigationBindings,"showPopup",function(n){this.popup||(this.popup=new H.Popup(this.chart.container,this.chart.options.navigation.iconsURL||this.chart.options.stockTools&&this.chart.options.stockTools.gui.iconsURL||"https://code.highcharts.com/9.2.2/gfx/stock-icons/",this.chart)),this.popup.showForm(n.formType,this.chart,n.options,n.onSubmit)});addEvent$r(NavigationBindings,"closePopup",function(){this.popup&&this.popup.closePopup()});H.Popup;var addEvent$q=Utilities.addEvent,extend$H=Utilities.extend,merge$D=Utilities.merge,pick$H=Utilities.pick,splat$4=Utilities.splat;Chart$1.prototype.collectionsWithUpdate.push("pane");var Pane=function(){function n(e,t){this.background=void 0,this.center=void 0,this.chart=void 0,this.options=void 0,this.coll="pane",this.defaultOptions={center:["50%","50%"],size:"85%",innerSize:"0%",startAngle:0},this.defaultBackgroundOptions={shape:"circle",borderWidth:1,borderColor:palette.neutralColor20,backgroundColor:{linearGradient:{x1:0,y1:0,x2:0,y2:1},stops:[[0,palette.backgroundColor],[1,palette.neutralColor10]]},from:-Number.MAX_VALUE,innerRadius:0,to:Number.MAX_VALUE,outerRadius:"105%"},this.init(e,t)}return n.prototype.init=function(e,t){this.chart=t,this.background=[],t.pane.push(this),this.setOptions(e)},n.prototype.setOptions=function(e){this.options=e=merge$D(this.defaultOptions,this.chart.angular?{background:{}}:void 0,e)},n.prototype.render=function(){var e=this.options,t=this.options.background,r=this.chart.renderer,o,s;if(this.group||(this.group=r.g("pane-group").attr({zIndex:e.zIndex||0}).add()),this.updateCenter(),t)for(t=splat$4(t),o=Math.max(t.length,this.background.length||0),s=0;s<o;s++)t[s]&&this.axis?this.renderBackground(merge$D(this.defaultBackgroundOptions,t[s]),s):this.background[s]&&(this.background[s]=this.background[s].destroy(),this.background.splice(s,1))},n.prototype.renderBackground=function(e,t){var r="animate",o={class:"highcharts-pane "+(e.className||"")};this.chart.styledMode||extend$H(o,{fill:e.backgroundColor,stroke:e.borderColor,"stroke-width":e.borderWidth}),this.background[t]||(this.background[t]=this.chart.renderer.path().add(this.group),r="attr"),this.background[t][r]({d:this.axis.getPlotBandPath(e.from,e.to,e)}).attr(o)},n.prototype.updateCenter=function(e){this.center=(e||this.axis||{}).center=centeredSeriesMixin.getCenter.call(this)},n.prototype.update=function(e,t){merge$D(!0,this.options,e),this.setOptions(this.options),this.render(),this.chart.axes.forEach(function(r){r.pane===this&&(r.pane=null,r.update({},t))},this)},n}();function isInsidePane(n,e,t){return Math.sqrt(Math.pow(n-t[0],2)+Math.pow(e-t[1],2))<=t[2]/2}Chart$1.prototype.getHoverPane=function(n){var e=this,t;return n&&e.pane.forEach(function(r){var o=n.chartX-e.plotLeft,s=n.chartY-e.plotTop,a=e.inverted?s:o,l=e.inverted?o:s;isInsidePane(a,l,r.center)&&(t=r)}),t};addEvent$q(Chart$1,"afterIsInsidePlot",function(n){var e=this;e.polar&&(n.isInsidePlot=e.pane.some(function(t){return isInsidePane(n.x,n.y,t.center)}))});addEvent$q(Pointer,"beforeGetHoverData",function(n){var e=this.chart;e.polar?(e.hoverPane=e.getHoverPane(n),n.filter=function(t){return t.visible&&!(!n.shared&&t.directTouch)&&pick$H(t.options.enableMouseTracking,!0)&&(!e.hoverPane||t.xAxis.pane===e.hoverPane)}):e.hoverPane=void 0});addEvent$q(Pointer,"afterGetHoverData",function(n){var e=this.chart;n.hoverPoint&&n.hoverPoint.plotX&&n.hoverPoint.plotY&&e.hoverPane&&!isInsidePane(n.hoverPoint.plotX,n.hoverPoint.plotY,e.hoverPane.center)&&(n.hoverPoint=void 0)});H.Pane=Pane;const Pane$1=H.Pane;var defaultOptions$3=DefaultOptions.defaultOptions,noop$c=H.noop,addEvent$p=Utilities.addEvent,correctFloat$3=Utilities.correctFloat,defined$h=Utilities.defined,extend$G=Utilities.extend,fireEvent$7=Utilities.fireEvent,merge$C=Utilities.merge,pick$G=Utilities.pick,relativeLength$2=Utilities.relativeLength,wrap$8=Utilities.wrap,RadialAxis;(function(n){var e=[],t={gridLineWidth:1,labels:{align:void 0,distance:15,x:0,y:void 0,style:{textOverflow:"none"}},maxPadding:0,minPadding:0,showLastLabel:!1,tickLength:0},r={labels:{align:"center",x:0,y:void 0},minorGridLineWidth:0,minorTickInterval:"auto",minorTickLength:10,minorTickPosition:"inside",minorTickWidth:1,tickLength:10,tickPosition:"inside",tickWidth:2,title:{rotation:0},zIndex:2},o={gridLineInterpolation:"circle",gridLineWidth:1,labels:{align:"right",x:-3,y:-2},showLastLabel:!1,title:{x:4,text:null,rotation:90}};function s(){this.autoConnect=this.isCircular&&typeof pick$G(this.userMax,this.options.max)>"u"&&correctFloat$3(this.endAngleRad-this.startAngleRad)===correctFloat$3(2*Math.PI),!this.isCircular&&this.chart.inverted&&this.max++,this.autoConnect&&(this.max+=this.categories&&1||this.pointRange||this.closestPointRange||0)}function a(L,D){return e.indexOf(L)===-1&&(e.push(L),addEvent$p(L,"afterInit",x),addEvent$p(L,"autoLabelAlign",b),addEvent$p(L,"destroy",$),addEvent$p(L,"init",S),addEvent$p(L,"initialAxisTranslation",k)),e.indexOf(D)===-1&&(e.push(D),addEvent$p(D,"afterGetLabelPosition",A),addEvent$p(D,"afterGetPosition",M),wrap$8(D.prototype,"getMarkPath",I)),L}n.compose=a;function l(){var L=this;return function(){if(L.isRadial&&L.tickPositions&&L.options.labels&&L.options.labels.allowOverlap!==!0)return L.tickPositions.map(function(D){return L.ticks[D]&&L.ticks[D].label}).filter(function(D){return!!D})}}function h(){return noop$c}function d(L,D,N){var B=this.pane.center,X=L.value,W,F,U,z;return this.isCircular?(defined$h(X)?L.point&&(W=L.point.shapeArgs||{},W.start&&(X=this.chart.inverted?this.translate(L.point.rectPlotY,!0):L.point.x)):(U=L.chartX||0,z=L.chartY||0,X=this.translate(Math.atan2(z-N,U-D)-this.startAngleRad,!0)),F=this.getPosition(X),U=F.x,z=F.y):(defined$h(X)||(U=L.chartX,z=L.chartY),defined$h(U)&&defined$h(z)&&(N=B[1]+this.chart.plotTop,X=this.translate(Math.min(Math.sqrt(Math.pow(U-D,2)+Math.pow(z-N,2)),B[2]/2)-B[3]/2,!0))),[X,U||0,z||0]}function c(L,D,N){var B=this.pane.center,X=this.chart,W=this.left||0,F=this.top||0,U,z=pick$G(D,B[2]/2-this.offset),V;return typeof N>"u"&&(N=this.horiz?0:this.center&&-this.center[3]/2),N&&(z+=N),this.isCircular||typeof D<"u"?(V=this.chart.renderer.symbols.arc(W+B[0],F+B[1],z,z,{start:this.startAngleRad,end:this.endAngleRad,open:!0,innerR:0}),V.xBounds=[W+B[0]],V.yBounds=[F+B[1]-z]):(U=this.postTranslate(this.angleRad,z),V=[["M",this.center[0]+X.plotLeft,this.center[1]+X.plotTop],["L",U.x,U.y]]),V}function p(){var L=this.constructor.prototype;L.getOffset.call(this),this.chart.axisOffset[this.side]=0}function f(L,D,N){var B=this.chart,X=function(at){if(typeof at=="string"){var lt=parseInt(at,10);return K.test(at)&&(lt=lt*U/100),lt}return at},W=this.center,F=this.startAngleRad,U=W[2]/2,z=Math.min(this.offset,0),V=this.left||0,j=this.top||0,K=/%$/,nt=this.isCircular,q,J,Y,Z,et,Q,tt=pick$G(X(N.outerRadius),U),rt=X(N.innerRadius),it=pick$G(X(N.thickness),10);if(this.options.gridLineInterpolation==="polygon")Q=this.getPlotLinePath({value:L}).concat(this.getPlotLinePath({value:D,reverse:!0}));else{L=Math.max(L,this.min),D=Math.min(D,this.max);var ot=this.translate(L),st=this.translate(D);nt||(tt=ot||0,rt=st||0),N.shape==="circle"||!nt?(q=-Math.PI/2,J=Math.PI*1.5,et=!0):(q=F+(ot||0),J=F+(st||0)),tt-=z,it-=z,Q=B.renderer.symbols.arc(V+W[0],j+W[1],tt,tt,{start:Math.min(q,J),end:Math.max(q,J),innerR:pick$G(rt,tt-it),open:et}),nt&&(Y=(J+q)/2,Z=V+W[0]+W[2]/2*Math.cos(Y),Q.xBounds=Y>-Math.PI/2&&Y<Math.PI/2?[Z,B.plotWidth]:[0,Z],Q.yBounds=[j+W[1]+W[2]/2*Math.sin(Y)],Q.yBounds[0]+=Y>-Math.PI&&Y<0||Y>Math.PI?-10:10)}return Q}function u(L){var D=this,N=this.pane.center,B=this.chart,X=B.inverted,W=L.reverse,F=this.pane.options.background?this.pane.options.background[0]||this.pane.options.background:{},U=F.innerRadius||"0%",z=F.outerRadius||"100%",V=N[0]+B.plotLeft,j=N[1]+B.plotTop,K=this.height,nt=L.isCrosshair,q=N[3]/2,J=L.value,Y,Z,et,Q,tt,rt,it,ot,st,at=this.getPosition(J),lt=at.x,ht=at.y;if(nt&&(ot=this.getCrosshairPosition(L,V,j),J=ot[0],lt=ot[1],ht=ot[2]),this.isCircular)Z=Math.sqrt(Math.pow(lt-V,2)+Math.pow(ht-j,2)),et=typeof U=="string"?relativeLength$2(U,1):U/Z,Q=typeof z=="string"?relativeLength$2(z,1):z/Z,N&&q&&(Y=q/Z,et<Y&&(et=Y),Q<Y&&(Q=Y)),st=[["M",V+et*(lt-V),j-et*(j-ht)],["L",lt-(1-Q)*(lt-V),ht+(1-Q)*(j-ht)]];else if(J=this.translate(J),J&&(J<0||J>K)&&(J=0),this.options.gridLineInterpolation==="circle")st=this.getLinePath(0,J,q);else if(st=[],B[X?"yAxis":"xAxis"].forEach(function(ct){ct.pane===D.pane&&(tt=ct)}),tt){it=tt.tickPositions,tt.autoConnect&&(it=it.concat([it[0]])),W&&(it=it.slice().reverse()),J&&(J+=q);for(var dt=0;dt<it.length;dt++)rt=tt.getPosition(it[dt],J),st.push(dt?["L",rt.x,rt.y]:["M",rt.x,rt.y])}return st}function g(L,D){var N=this.translate(L);return this.postTranslate(this.isCircular?N:this.angleRad,pick$G(this.isCircular?D:N<0?0:N,this.center[2]/2)-this.offset)}function m(){var L=this.center,D=this.chart,N=this.options.title;return{x:D.plotLeft+L[0]+(N.x||0),y:D.plotTop+L[1]-{high:.5,middle:.25,low:0}[N.align]*L[2]+(N.y||0)}}function y(L){L.beforeSetTickPositions=s,L.createLabelCollector=l,L.getCrosshairPosition=d,L.getLinePath=c,L.getOffset=p,L.getPlotBandPath=f,L.getPlotLinePath=u,L.getPosition=g,L.getTitlePosition=m,L.postTranslate=P,L.setAxisSize=T,L.setAxisTranslation=O,L.setOptions=C}function v(L){L.isHidden=!0,L.createLabelCollector=h,L.getOffset=noop$c,L.redraw=E,L.render=E,L.setScale=noop$c,L.setCategories=noop$c,L.setTitle=noop$c}function x(){var L=this.chart,D=this.options,N=L.angular&&this.isXAxis,B=this.pane,X=B&&B.options;!N&&B&&(L.angular||L.polar)&&(this.angleRad=(D.angle||0)*Math.PI/180,this.startAngleRad=(X.startAngle-90)*Math.PI/180,this.endAngleRad=(pick$G(X.endAngle,X.startAngle+360)-90)*Math.PI/180,this.offset=D.offset||0)}function b(L){this.isRadial&&(L.align=void 0,L.preventDefault())}function $(){if(this.chart&&this.chart.labelCollectors){var L=this.labelCollector?this.chart.labelCollectors.indexOf(this.labelCollector):-1;L>=0&&this.chart.labelCollectors.splice(L,1)}}function S(L){var D=this.chart,N=D.inverted,B=D.angular,X=D.polar,W=this.isXAxis,F=this.coll,U=B&&W,z=D.options,V=L.userOptions.pane||0,j=this.pane=D.pane&&D.pane[V],K;if(F==="colorAxis"){this.isRadial=!1;return}B?(U?v(this):y(this),K=!W,K&&(this.defaultPolarOptions=r)):X&&(y(this),K=this.horiz,this.defaultPolarOptions=K?t:merge$C(F==="xAxis"?AxisDefaults$1.defaultXAxisOptions:AxisDefaults$1.defaultYAxisOptions,o),N&&F==="yAxis"&&(this.defaultPolarOptions.stackLabels=AxisDefaults$1.defaultYAxisOptions.stackLabels,this.defaultPolarOptions.reversedStacks=!0)),B||X?(this.isRadial=!0,z.chart.zoomType=null,this.labelCollector||(this.labelCollector=this.createLabelCollector()),this.labelCollector&&D.labelCollectors.push(this.labelCollector)):this.isRadial=!1,j&&K&&(j.axis=this),this.isCircular=K}function k(){this.isRadial&&this.beforeSetTickPositions()}function A(L){var D=this.label;if(D){var N=this.axis,B=D.getBBox(),X=N.options.labels,W=(N.translate(this.pos)+N.startAngleRad+Math.PI/2)/Math.PI*180%360,F=Math.round(W),U=defined$h(X.y)?0:-B.height*.3,z=X.y,V,j=20,K=X.align,nt="end",q=F<0?F+360:F,J=q,Y=0,Z=0;N.isRadial&&(V=N.getPosition(this.pos,N.center[2]/2+relativeLength$2(pick$G(X.distance,-25),N.center[2]/2,-N.center[2]/2)),X.rotation==="auto"?D.attr({rotation:W}):defined$h(z)||(z=N.chart.renderer.fontMetrics(D.styles&&D.styles.fontSize).b-B.height/2),defined$h(K)||(N.isCircular?(B.width>N.len*N.tickInterval/(N.max-N.min)&&(j=0),W>j&&W<180-j?K="left":W>180+j&&W<360-j?K="right":K="center"):K="center",D.attr({align:K})),K==="auto"&&N.tickPositions.length===2&&N.isCircular&&(q>90&&q<180?q=180-q:q>270&&q<=360&&(q=540-q),J>180&&J<=360&&(J=360-J),(N.pane.options.startAngle===F||N.pane.options.startAngle===F+360||N.pane.options.startAngle===F-360)&&(nt="start"),F>=-90&&F<=90||F>=-360&&F<=-270||F>=270&&F<=360?K=nt==="start"?"right":"left":K=nt==="start"?"left":"right",J>70&&J<110&&(K="center"),q<15||q>=180&&q<195?Y=B.height*.3:q>=15&&q<=35?Y=nt==="start"?0:B.height*.75:q>=195&&q<=215?Y=nt==="start"?B.height*.75:0:q>35&&q<=90?Y=nt==="start"?-B.height*.25:B.height:q>215&&q<=270&&(Y=nt==="start"?B.height:-B.height*.25),J<15?Z=nt==="start"?-B.height*.15:B.height*.15:J>165&&J<=180&&(Z=nt==="start"?B.height*.15:-B.height*.15),D.attr({align:K}),D.translate(Z,Y+U)),L.pos.x=V.x+(X.x||0),L.pos.y=V.y+(z||0))}}function M(L){this.axis.getPosition&&extend$G(L.pos,this.axis.getPosition(this.pos))}function P(L,D){var N=this.chart,B=this.center;return L=this.startAngleRad+L,{x:N.plotLeft+B[0]+Math.cos(L)*D,y:N.plotTop+B[1]+Math.sin(L)*D}}function E(){this.isDirty=!1}function T(){var L=this.constructor.prototype,D,N;L.setAxisSize.call(this),this.isRadial&&(this.pane.updateCenter(this),D=this.center=this.pane.center.slice(),this.isCircular?this.sector=this.endAngleRad-this.startAngleRad:(N=this.postTranslate(this.angleRad,D[3]/2),D[0]=N.x-this.chart.plotLeft,D[1]=N.y-this.chart.plotTop),this.len=this.width=this.height=(D[2]-D[3])*pick$G(this.sector,1)/2)}function O(){var L=this.constructor.prototype;L.setAxisTranslation.call(this),this.center&&(this.isCircular?this.transA=(this.endAngleRad-this.startAngleRad)/(this.max-this.min||1):this.transA=(this.center[2]-this.center[3])/2/(this.max-this.min||1),this.isXAxis?this.minPixelPadding=this.transA*this.minPointOffset:this.minPixelPadding=0)}function C(L){var D=this.options=merge$C(this.constructor.defaultOptions,this.defaultPolarOptions,defaultOptions$3[this.coll],L);D.plotBands||(D.plotBands=[]),fireEvent$7(this,"afterSetOptions")}function I(L,D,N,B,X,W,F){var U=this.axis,z,V;return U.isRadial?(z=U.getPosition(this.pos,U.center[2]/2+B),V=["M",D,N,"L",z.x,z.y]):V=L.call(this,D,N,B,X,W,F),V}})(RadialAxis||(RadialAxis={}));const RadialAxis$1=RadialAxis;var __extends$F=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),pointProto=Point$2.prototype,defined$g=Utilities.defined,isNumber$i=Utilities.isNumber,AreaRangePoint$1=function(n){__extends$F(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.high=void 0,t.low=void 0,t.options=void 0,t.plotHigh=void 0,t.plotLow=void 0,t.plotHighX=void 0,t.plotLowX=void 0,t.plotX=void 0,t.series=void 0,t}return e.prototype.setState=function(){var t=this.state,r=this.series,o=r.chart.polar;defined$g(this.plotHigh)||(this.plotHigh=r.yAxis.toPixels(this.high,!0)),defined$g(this.plotLow)||(this.plotLow=this.plotY=r.yAxis.toPixels(this.low,!0)),r.stateMarkerGraphic&&(r.lowerStateMarkerGraphic=r.stateMarkerGraphic,r.stateMarkerGraphic=r.upperStateMarkerGraphic),this.graphic=this.upperGraphic,this.plotY=this.plotHigh,o&&(this.plotX=this.plotHighX),pointProto.setState.apply(this,arguments),this.state=t,this.plotY=this.plotLow,this.graphic=this.lowerGraphic,o&&(this.plotX=this.plotLowX),r.stateMarkerGraphic&&(r.upperStateMarkerGraphic=r.stateMarkerGraphic,r.stateMarkerGraphic=r.lowerStateMarkerGraphic,r.lowerStateMarkerGraphic=void 0),pointProto.setState.apply(this,arguments)},e.prototype.haloPath=function(){var t=this.series.chart.polar,r=[];return this.plotY=this.plotLow,t&&(this.plotX=this.plotLowX),this.isInside&&(r=pointProto.haloPath.apply(this,arguments)),this.plotY=this.plotHigh,t&&(this.plotX=this.plotHighX),this.isTopInside&&(r=r.concat(pointProto.haloPath.apply(this,arguments))),r},e.prototype.isValid=function(){return isNumber$i(this.low)&&isNumber$i(this.high)},e}(AreaSeries$1.prototype.pointClass),__extends$E=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),areaProto=AreaSeries$1.prototype,columnProto$4=ColumnSeries$h.prototype,noop$b=H.noop,seriesProto$1=Series$e.prototype,defined$f=Utilities.defined,extend$F=Utilities.extend,isArray$5=Utilities.isArray,pick$F=Utilities.pick,merge$B=Utilities.merge,AreaRangeSeries$2=function(n){__extends$E(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t.lowerStateMarkerGraphic=void 0,t.xAxis=void 0,t}return e.prototype.toYData=function(t){return[t.low,t.high]},e.prototype.highToXY=function(t){var r=this.chart,o=this.xAxis.postTranslate(t.rectPlotX||0,this.yAxis.len-t.plotHigh);t.plotHighX=o.x-r.plotLeft,t.plotHigh=o.y-r.plotTop,t.plotLowX=t.plotX},e.prototype.translate=function(){var t=this,r=t.yAxis,o=!!t.modifyValue;areaProto.translate.apply(t),t.points.forEach(function(s){var a=s.high,l=s.plotY;s.isNull?s.plotY=null:(s.plotLow=l,s.plotHigh=r.translate(o?t.modifyValue(a,s):a,0,1,0,1),o&&(s.yBottom=s.plotHigh))}),this.chart.polar&&this.points.forEach(function(s){t.highToXY(s),s.tooltipPos=[(s.plotHighX+s.plotLowX)/2,(s.plotHigh+s.plotLow)/2]})},e.prototype.getGraphPath=function(t){var r=[],o=[],s,a=areaProto.getGraphPath,l,h,d,c,p=this.options,f=this.chart.polar,u=f&&p.connectEnds!==!1,g=p.connectNulls,m=p.step,y,v;for(t=t||this.points,s=t.length;s--;){l=t[s];var x=f?{plotX:l.rectPlotX,plotY:l.yBottom,doCurve:!1}:{plotX:l.plotX,plotY:l.plotY,doCurve:!1};!l.isNull&&!u&&!g&&(!t[s+1]||t[s+1].isNull)&&o.push(x),h={polarPlotY:l.polarPlotY,rectPlotX:l.rectPlotX,yBottom:l.yBottom,plotX:pick$F(l.plotHighX,l.plotX),plotY:l.plotHigh,isNull:l.isNull},o.push(h),r.push(h),!l.isNull&&!u&&!g&&(!t[s-1]||t[s-1].isNull)&&o.push(x)}return c=a.call(this,t),m&&(m===!0&&(m="left"),p.step={left:"right",center:"center",right:"left"}[m]),y=a.call(this,r),v=a.call(this,o),p.step=m,d=[].concat(c,y),!this.chart.polar&&v[0]&&v[0][0]==="M"&&(v[0]=["L",v[0][1],v[0][2]]),this.graphPath=d,this.areaPath=c.concat(v),d.isArea=!0,d.xMap=c.xMap,this.areaPath.xMap=c.xMap,d},e.prototype.drawDataLabels=function(){var t=this.points,r=t.length,o,s=[],a=this.options.dataLabels,l,h,d=this.chart.inverted,c,p;if(a){if(isArray$5(a)?(c=a[0]||{enabled:!1},p=a[1]||{enabled:!1}):(c=extend$F({},a),c.x=a.xHigh,c.y=a.yHigh,p=extend$F({},a),p.x=a.xLow,p.y=a.yLow),c.enabled||this._hasPointLabels){for(o=r;o--;)l=t[o],l&&(h=c.inside?l.plotHigh<l.plotLow:l.plotHigh>l.plotLow,l.y=l.high,l._plotY=l.plotY,l.plotY=l.plotHigh,s[o]=l.dataLabel,l.dataLabel=l.dataLabelUpper,l.below=h,d?c.align||(c.align=h?"right":"left"):c.verticalAlign||(c.verticalAlign=h?"top":"bottom"));for(this.options.dataLabels=c,seriesProto$1.drawDataLabels&&seriesProto$1.drawDataLabels.apply(this,arguments),o=r;o--;)l=t[o],l&&(l.dataLabelUpper=l.dataLabel,l.dataLabel=s[o],delete l.dataLabels,l.y=l.low,l.plotY=l._plotY)}if(p.enabled||this._hasPointLabels){for(o=r;o--;)l=t[o],l&&(h=p.inside?l.plotHigh<l.plotLow:l.plotHigh>l.plotLow,l.below=!h,d?p.align||(p.align=h?"left":"right"):p.verticalAlign||(p.verticalAlign=h?"bottom":"top"));this.options.dataLabels=p,seriesProto$1.drawDataLabels&&seriesProto$1.drawDataLabels.apply(this,arguments)}if(c.enabled)for(o=r;o--;)l=t[o],l&&(l.dataLabels=[l.dataLabelUpper,l.dataLabel].filter(function(f){return!!f}));this.options.dataLabels=a}},e.prototype.alignDataLabel=function(){columnProto$4.alignDataLabel.apply(this,arguments)},e.prototype.drawPoints=function(){var t=this,r=t.points.length,o,s;for(seriesProto$1.drawPoints.apply(t,arguments),s=0;s<r;)o=t.points[s],o.origProps={plotY:o.plotY,plotX:o.plotX,isInside:o.isInside,negative:o.negative,zone:o.zone,y:o.y},o.lowerGraphic=o.graphic,o.graphic=o.upperGraphic,o.plotY=o.plotHigh,defined$f(o.plotHighX)&&(o.plotX=o.plotHighX),o.y=pick$F(o.high,o.origProps.y),o.negative=o.y<(t.options.threshold||0),t.zones.length&&(o.zone=o.getZone()),t.chart.polar||(o.isInside=o.isTopInside=typeof o.plotY<"u"&&o.plotY>=0&&o.plotY<=t.yAxis.len&&o.plotX>=0&&o.plotX<=t.xAxis.len),s++;for(seriesProto$1.drawPoints.apply(t,arguments),s=0;s<r;)o=t.points[s],o.upperGraphic=o.graphic,o.graphic=o.lowerGraphic,o.origProps&&(extend$F(o,o.origProps),delete o.origProps),s++},e.defaultOptions=merge$B(AreaSeries$1.defaultOptions,{lineWidth:1,threshold:null,tooltip:{pointFormat:'<span style="color:{series.color}">●</span> {series.name}: <b>{point.low}</b> - <b>{point.high}</b><br/>'},trackByArea:!0,dataLabels:{align:void 0,verticalAlign:void 0,xLow:0,xHigh:0,yLow:0,yHigh:0}}),e}(AreaSeries$1);extend$F(AreaRangeSeries$2.prototype,{pointArrayMap:["low","high"],pointValKey:"low",deferTranslatePolar:!0,pointClass:AreaRangePoint$1,setStackedPoints:noop$b});SeriesRegistry$1.registerSeriesType("arearange",AreaRangeSeries$2);var __extends$D=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),SplineSeries=SeriesRegistry$1.seriesTypes.spline,merge$A=Utilities.merge,extend$E=Utilities.extend,AreaSplineRangeSeries=function(n){__extends$D(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.options=void 0,t.data=void 0,t.points=void 0,t}return e.defaultOptions=merge$A(AreaRangeSeries$2.defaultOptions),e}(AreaRangeSeries$2);extend$E(AreaSplineRangeSeries.prototype,{getPointSpline:SplineSeries.prototype.getPointSpline});SeriesRegistry$1.registerSeriesType("areasplinerange",AreaSplineRangeSeries);var __extends$C=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),noop$a=H.noop,extend$D=Utilities.extend,merge$z=Utilities.merge,pick$E=Utilities.pick,BoxPlotSeries=function(n){__extends$C(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.pointAttribs=function(){return{}},e.prototype.translate=function(){var t=this,r=t.yAxis,o=t.pointArrayMap;n.prototype.translate.apply(t),t.points.forEach(function(s){o.forEach(function(a){s[a]!==null&&(s[a+"Plot"]=r.translate(s[a],0,1,0,1))}),s.plotHigh=s.highPlot})},e.prototype.drawPoints=function(){var t=this,r=t.points,o=t.options,s=t.chart,a=s.renderer,l,h,d,c,p,f,u,g=0,m,y,v,x,b,$=t.doQuartiles!==!1,S,k=t.options.whiskerLength;r.forEach(function(A){var M=A.graphic,P=M?"animate":"attr",E=A.shapeArgs,T={},O={},C={},I={},L=A.color||t.color;if(typeof A.plotY<"u"){y=Math.round(E.width),v=Math.floor(E.x),x=v+y,b=Math.round(y/2),l=Math.floor($?A.q1Plot:A.lowPlot),h=Math.floor($?A.q3Plot:A.lowPlot),d=Math.floor(A.highPlot),c=Math.floor(A.lowPlot),M||(A.graphic=M=a.g("point").add(t.group),A.stem=a.path().addClass("highcharts-boxplot-stem").add(M),k&&(A.whiskers=a.path().addClass("highcharts-boxplot-whisker").add(M)),$&&(A.box=a.path(m).addClass("highcharts-boxplot-box").add(M)),A.medianShape=a.path(f).addClass("highcharts-boxplot-median").add(M)),s.styledMode||(O.stroke=A.stemColor||o.stemColor||L,O["stroke-width"]=pick$E(A.stemWidth,o.stemWidth,o.lineWidth),O.dashstyle=A.stemDashStyle||o.stemDashStyle||o.dashStyle,A.stem.attr(O),k&&(C.stroke=A.whiskerColor||o.whiskerColor||L,C["stroke-width"]=pick$E(A.whiskerWidth,o.whiskerWidth,o.lineWidth),C.dashstyle=A.whiskerDashStyle||o.whiskerDashStyle||o.dashStyle,A.whiskers.attr(C)),$&&(T.fill=A.fillColor||o.fillColor||L,T.stroke=o.lineColor||L,T["stroke-width"]=o.lineWidth||0,T.dashstyle=A.boxDashStyle||o.boxDashStyle||o.dashStyle,A.box.attr(T)),I.stroke=A.medianColor||o.medianColor||L,I["stroke-width"]=pick$E(A.medianWidth,o.medianWidth,o.lineWidth),I.dashstyle=A.medianDashStyle||o.medianDashStyle||o.dashStyle,A.medianShape.attr(I));var D=void 0;u=A.stem.strokeWidth()%2/2,g=v+b+u,D=[["M",g,h],["L",g,d],["M",g,l],["L",g,c]],A.stem[P]({d:D}),$&&(u=A.box.strokeWidth()%2/2,l=Math.floor(l)+u,h=Math.floor(h)+u,v+=u,x+=u,D=[["M",v,h],["L",v,l],["L",x,l],["L",x,h],["L",v,h],["Z"]],A.box[P]({d:D})),k&&(u=A.whiskers.strokeWidth()%2/2,d=d+u,c=c+u,S=/%$/.test(k)?b*parseFloat(k)/100:k/2,D=[["M",g-S,d],["L",g+S,d],["M",g-S,c],["L",g+S,c]],A.whiskers[P]({d:D})),p=Math.round(A.medianPlot),u=A.medianShape.strokeWidth()%2/2,p=p+u,D=[["M",v,p],["L",x,p]],A.medianShape[P]({d:D})}})},e.prototype.toYData=function(t){return[t.low,t.q1,t.median,t.q3,t.high]},e.defaultOptions=merge$z(ColumnSeries$h.defaultOptions,{threshold:null,tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Maximum: {point.high}<br/>Upper quartile: {point.q3}<br/>Median: {point.median}<br/>Lower quartile: {point.q1}<br/>Minimum: {point.low}<br/>'},whiskerLength:"50%",fillColor:palette.backgroundColor,lineWidth:1,medianWidth:2,whiskerWidth:2}),e}(ColumnSeries$h);extend$D(BoxPlotSeries.prototype,{pointArrayMap:["low","q1","median","q3","high"],pointValKey:"high",drawDataLabels:noop$a,setStackedPoints:noop$a});SeriesRegistry$1.registerSeriesType("boxplot",BoxPlotSeries);var BubbleLegendDefaults={borderColor:void 0,borderWidth:2,className:void 0,color:void 0,connectorClassName:void 0,connectorColor:void 0,connectorDistance:60,connectorWidth:1,enabled:!1,labels:{className:void 0,allowOverlap:!1,format:"",formatter:void 0,align:"right",style:{fontSize:"10px",color:palette.neutralColor100},x:0,y:0},maxSize:60,minSize:10,legendIndex:0,ranges:{value:void 0,borderColor:void 0,color:void 0,connectorColor:void 0},sizeBy:"area",sizeByAbsoluteValue:!1,zIndex:1,zThreshold:0},color$a=Color.parse,noop$9=H.noop,arrayMax$3=Utilities.arrayMax,arrayMin$3=Utilities.arrayMin,isNumber$h=Utilities.isNumber,merge$y=Utilities.merge,pick$D=Utilities.pick,stableSort$2=Utilities.stableSort,BubbleLegendItem=function(){function n(e,t){this.chart=void 0,this.fontMetrics=void 0,this.legend=void 0,this.legendGroup=void 0,this.legendItem=void 0,this.legendItemHeight=void 0,this.legendItemWidth=void 0,this.legendSymbol=void 0,this.maxLabel=void 0,this.movementX=void 0,this.ranges=void 0,this.selected=void 0,this.visible=void 0,this.symbols=void 0,this.options=void 0,this.setState=noop$9,this.init(e,t)}return n.prototype.init=function(e,t){this.options=e,this.visible=!0,this.chart=t.chart,this.legend=t},n.prototype.addToLegend=function(e){e.splice(this.options.legendIndex,0,this)},n.prototype.drawLegendSymbol=function(e){var t=this.chart,r=this.options,o=pick$D(e.options.itemDistance,20),s=r.ranges,a=r.connectorDistance,l;if(this.fontMetrics=t.renderer.fontMetrics(r.labels.style.fontSize),!s||!s.length||!isNumber$h(s[0].value)){e.options.bubbleLegend.autoRanges=!0;return}stableSort$2(s,function(p,f){return f.value-p.value}),this.ranges=s,this.setOptions(),this.render();var h=this.getMaxLabelSize(),d=this.ranges[0].radius,c=d*2;l=a-d+h.width,l=l>0?l:0,this.maxLabel=h,this.movementX=r.labels.align==="left"?l:0,this.legendItemWidth=c+l+o,this.legendItemHeight=c+this.fontMetrics.h/2},n.prototype.setOptions=function(){var e=this.ranges,t=this.options,r=this.chart.series[t.seriesIndex],o=this.legend.baseline,s={zIndex:t.zIndex,"stroke-width":t.borderWidth},a={zIndex:t.zIndex,"stroke-width":t.connectorWidth},l={align:this.legend.options.rtl||t.labels.align==="left"?"right":"left",zIndex:t.zIndex},h=r.options.marker.fillOpacity,d=this.chart.styledMode;e.forEach(function(c,p){d||(s.stroke=pick$D(c.borderColor,t.borderColor,r.color),s.fill=pick$D(c.color,t.color,h!==1?color$a(r.color).setOpacity(h).get("rgba"):r.color),a.stroke=pick$D(c.connectorColor,t.connectorColor,r.color)),e[p].radius=this.getRangeRadius(c.value),e[p]=merge$y(e[p],{center:e[0].radius-e[p].radius+o}),d||merge$y(!0,e[p],{bubbleAttribs:merge$y(s),connectorAttribs:merge$y(a),labelAttribs:l})},this)},n.prototype.getRangeRadius=function(e){var t=this.options,r=this.options.seriesIndex,o=this.chart.series[r],s=t.ranges[0].value,a=t.ranges[t.ranges.length-1].value,l=t.minSize,h=t.maxSize;return o.getRadius.call(this,a,s,l,h,e)},n.prototype.render=function(){var e=this.chart.renderer,t=this.options.zThreshold;this.symbols||(this.symbols={connectors:[],bubbleItems:[],labels:[]}),this.legendSymbol=e.g("bubble-legend"),this.legendItem=e.g("bubble-legend-item"),this.legendSymbol.translateX=0,this.legendSymbol.translateY=0,this.ranges.forEach(function(r){r.value>=t&&this.renderRange(r)},this),this.legendSymbol.add(this.legendItem),this.legendItem.add(this.legendGroup),this.hideOverlappingLabels()},n.prototype.renderRange=function(e){var t=this.ranges[0],r=this.legend,o=this.options,s=o.labels,a=this.chart,l=a.series[o.seriesIndex],h=a.renderer,d=this.symbols,c=d.labels,p=e.center,f=Math.abs(e.radius),u=o.connectorDistance||0,g=s.align,m=r.options.rtl,y=o.borderWidth,v=o.connectorWidth,x=t.radius||0,b=p-f-y/2+v/2,$=this.fontMetrics,S=$.f/2-($.h-$.f)/2,k=(b%1?1:.5)-(v%2?0:.5),A=h.styledMode,M=m||g==="left"?-u:u;g==="center"&&(M=0,o.connectorDistance=0,e.labelAttribs.align="center");var P=b+o.labels.y,E=x+M+o.labels.x;d.bubbleItems.push(h.circle(x,p+k,f).attr(A?{}:e.bubbleAttribs).addClass((A?"highcharts-color-"+l.colorIndex+" ":"")+"highcharts-bubble-legend-symbol "+(o.className||"")).add(this.legendSymbol)),d.connectors.push(h.path(h.crispLine([["M",x,b],["L",x+M,b]],o.connectorWidth)).attr(A?{}:e.connectorAttribs).addClass((A?"highcharts-color-"+this.options.seriesIndex+" ":"")+"highcharts-bubble-legend-connectors "+(o.connectorClassName||"")).add(this.legendSymbol));var T=h.text(this.formatLabel(e),E,P+S).attr(A?{}:e.labelAttribs).css(A?{}:s.style).addClass("highcharts-bubble-legend-labels "+(o.labels.className||"")).add(this.legendSymbol);c.push(T),T.placed=!0,T.alignAttr={x:E,y:P+S}},n.prototype.getMaxLabelSize=function(){var e=this.symbols.labels,t,r;return e.forEach(function(o){r=o.getBBox(!0),t?t=r.width>t.width?r:t:t=r}),t||{}},n.prototype.formatLabel=function(e){var t=this.options,r=t.labels.formatter,o=t.labels.format,s=this.chart.numberFormatter;return o?FormatUtilities.format(o,e):r?r.call(e):s(e.value,1)},n.prototype.hideOverlappingLabels=function(){var e=this.chart,t=this.options.labels.allowOverlap,r=this.symbols;!t&&r&&(e.hideOverlappingLabels(r.labels),r.labels.forEach(function(o,s){o.newOpacity?o.newOpacity!==o.oldOpacity&&r.connectors[s].show():r.connectors[s].hide()}))},n.prototype.getRanges=function(){var e=this.legend.bubbleLegend,t=e.chart.series,r=e.options.ranges,o,s,a=Number.MAX_VALUE,l=-Number.MAX_VALUE;return t.forEach(function(h){h.isBubble&&!h.ignoreSeries&&(s=h.zData.filter(isNumber$h),s.length&&(a=pick$D(h.options.zMin,Math.min(a,Math.max(arrayMin$3(s),h.options.displayNegative===!1?h.options.zThreshold:-Number.MAX_VALUE))),l=pick$D(h.options.zMax,Math.max(l,arrayMax$3(s)))))}),a===l?o=[{value:l}]:o=[{value:a},{value:(a+l)/2},{value:l,autoRanges:!0}],r.length&&r[0].radius&&o.reverse(),o.forEach(function(h,d){r&&r[d]&&(o[d]=merge$y(r[d],h))}),o},n.prototype.predictBubbleSizes=function(){var e=this.chart,t=this.fontMetrics,r=e.legend.options,o=r.floating,s=r.layout==="horizontal",a=s?e.legend.lastLineHeight:0,l=e.plotSizeX,h=e.plotSizeY,d=e.series[this.options.seriesIndex],c=Math.ceil(d.minPxSize),p=Math.ceil(d.maxPxSize),f=Math.min(h,l),u,g=d.options.maxSize;return o||!/%$/.test(g)?u=p:(g=parseFloat(g),u=(f+a-t.h/2)*g/100/(g/100+1),(s&&h-u>=l||!s&&l-u>=h)&&(u=p)),[c,Math.ceil(u)]},n.prototype.updateRanges=function(e,t){var r=this.legend.options.bubbleLegend;r.minSize=e,r.maxSize=t,r.ranges=this.getRanges()},n.prototype.correctSizes=function(){var e=this.legend,t=this.chart,r=t.series[this.options.seriesIndex],o=r.maxPxSize,s=this.options.maxSize;Math.abs(Math.ceil(o)-s)>1&&(this.updateRanges(this.options.minSize,r.maxPxSize),e.render())},n}(),setOptions=DefaultOptions.setOptions,addEvent$o=Utilities.addEvent,objectEach$9=Utilities.objectEach,wrap$7=Utilities.wrap,BubbleLegendComposition;(function(n){var e=[];function t(d,c,p){var f=this,u=f.legend,g=o(f)>=0,m,y;u&&u.options.enabled&&u.bubbleLegend&&u.options.bubbleLegend.autoRanges&&g?(m=u.bubbleLegend.options,y=u.bubbleLegend.predictBubbleSizes(),u.bubbleLegend.updateRanges(y[0],y[1]),m.placed||(u.group.placed=!1,u.allItems.forEach(function(v){v.legendGroup.translateY=null})),u.render(),f.getMargins(),f.axes.forEach(function(v){v.visible&&v.render(),m.placed||(v.setScale(),v.updateNames(),objectEach$9(v.ticks,function(x){x.isNew=!0,x.isNewLabel=!0}))}),m.placed=!0,f.getMargins(),d.call(f,c,p),u.bubbleLegend.correctSizes(),h(u,s(u))):(d.call(f,c,p),u&&u.options.enabled&&u.bubbleLegend&&(u.render(),h(u,s(u))))}function r(d,c,p){e.indexOf(d)===-1&&(e.push(d),setOptions({legend:{bubbleLegend:BubbleLegendDefaults}}),wrap$7(d.prototype,"drawChartBox",t)),e.indexOf(c)===-1&&(e.push(c),addEvent$o(c,"afterGetAllItems",a)),e.indexOf(p)===-1&&(e.push(p),addEvent$o(p,"legendItemClick",l))}n.compose=r;function o(d){for(var c=d.series,p=0;p<c.length;){if(c[p]&&c[p].isBubble&&c[p].visible&&c[p].zData.length)return p;p++}return-1}function s(d){var c=d.allItems,p=[],f=c.length,u,g=0,m=0;for(g=0;g<f;g++)if(c[g].legendItemHeight&&(c[g].itemHeight=c[g].legendItemHeight),c[g]===c[f-1]||c[g+1]&&c[g]._legendItemPos[1]!==c[g+1]._legendItemPos[1]){for(p.push({height:0}),u=p[p.length-1],m;m<=g;m++)c[m].itemHeight>u.height&&(u.height=c[m].itemHeight);u.step=g}return p}function a(d){var c=this,p=c.bubbleLegend,f=c.options,u=f.bubbleLegend,g=o(c.chart);p&&p.ranges&&p.ranges.length&&(u.ranges.length&&(u.autoRanges=!!u.ranges[0].autoRanges),c.destroyItem(p)),g>=0&&f.enabled&&u.enabled&&(u.seriesIndex=g,c.bubbleLegend=new BubbleLegendItem(u,c),c.bubbleLegend.addToLegend(d.allItems))}function l(){var d=this,c=d.chart,p=d.visible,f=d.chart.legend,u;f&&f.bubbleLegend&&(d.visible=!p,d.ignoreSeries=p,u=o(c)>=0,f.bubbleLegend.visible!==u&&(f.update({bubbleLegend:{enabled:u}}),f.bubbleLegend.visible=u),d.visible=p)}function h(d,c){var p=d.allItems,f=d.options.rtl,u,g,m,y=0;p.forEach(function(v,x){u=v.legendGroup.translateX,g=v._legendItemPos[1],m=v.movementX,(m||f&&v.ranges)&&(m=f?u-v.options.maxSize/2:u+m,v.legendGroup.attr({translateX:m})),x>c[y].step&&y++,v.legendGroup.attr({translateY:Math.round(g+c[y].height/2)}),v._legendItemPos[1]=g+c[y].height/2})}})(BubbleLegendComposition||(BubbleLegendComposition={}));const BubbleLegendComposition$1=BubbleLegendComposition;var __extends$B=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),ScatterPoint$2=SeriesRegistry$1.seriesTypes.scatter.prototype.pointClass,extend$C=Utilities.extend,BubblePoint=function(n){__extends$B(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return e.prototype.haloPath=function(t){return Point$2.prototype.haloPath.call(this,t===0?0:(this.marker&&this.marker.radius||0)+t)},e}(ScatterPoint$2);extend$C(BubblePoint.prototype,{ttBelow:!1});var __extends$A=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),color$9=Color.parse,noop$8=H.noop,_a$b=SeriesRegistry$1.seriesTypes,ColumnSeries$b=_a$b.column,ScatterSeries$3=_a$b.scatter,arrayMax$2=Utilities.arrayMax,arrayMin$2=Utilities.arrayMin,clamp$8=Utilities.clamp,extend$B=Utilities.extend,isNumber$g=Utilities.isNumber,merge$x=Utilities.merge,pick$C=Utilities.pick,pInt$2=Utilities.pInt,BubbleSeries$2=function(n){__extends$A(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.maxPxSize=void 0,t.minPxSize=void 0,t.options=void 0,t.points=void 0,t.radii=void 0,t.yData=void 0,t.zData=void 0,t}return e.prototype.animate=function(t){!t&&this.points.length<this.options.animationLimit&&this.points.forEach(function(r){var o=r.graphic;o&&o.width&&(this.hasRendered||o.attr({x:r.plotX,y:r.plotY,width:1,height:1}),o.animate(this.markerAttribs(r),this.options.animation))},this)},e.prototype.getRadii=function(t,r,o){var s,a,l=this.zData,h=this.yData,d=o.minPxSize,c=o.maxPxSize,p=[],f;for(a=0,s=l.length;a<s;a++)f=l[a],p.push(this.getRadius(t,r,d,c,f,h[a]));this.radii=p},e.prototype.getRadius=function(t,r,o,s,a,l){var h=this.options,d=h.sizeBy!=="width",c=h.zThreshold,p=r-t,f=.5;if(l===null||a===null)return null;if(isNumber$g(a)){if(h.sizeByAbsoluteValue&&(a=Math.abs(a-c),r=p=Math.max(r-c,Math.abs(t-c)),t=0),a<t)return o/2-1;p>0&&(f=(a-t)/p)}return d&&f>=0&&(f=Math.sqrt(f)),Math.ceil(o+f*(s-o))/2},e.prototype.hasData=function(){return!!this.processedXData.length},e.prototype.pointAttribs=function(t,r){var o=this.options.marker,s=o.fillOpacity,a=Series$e.prototype.pointAttribs.call(this,t,r);return s!==1&&(a.fill=color$9(a.fill).setOpacity(s).get("rgba")),a},e.prototype.translate=function(){var t,r=this.data,o,s,a=this.radii;for(n.prototype.translate.call(this),t=r.length;t--;)o=r[t],s=a?a[t]:0,isNumber$g(s)&&s>=this.minPxSize/2?(o.marker=extend$B(o.marker,{radius:s,width:2*s,height:2*s}),o.dlBox={x:o.plotX-s,y:o.plotY-s,width:2*s,height:2*s}):o.shapeArgs=o.plotY=o.dlBox=void 0},e.compose=BubbleLegendComposition$1.compose,e.defaultOptions=merge$x(ScatterSeries$3.defaultOptions,{dataLabels:{formatter:function(){var t=this.series.chart.numberFormatter,r=this.point.z;return isNumber$g(r)?t(r,-1):""},inside:!0,verticalAlign:"middle"},animationLimit:250,marker:{lineColor:null,lineWidth:1,fillOpacity:.5,radius:null,states:{hover:{radiusPlus:0}},symbol:"circle"},minSize:8,maxSize:"20%",softThreshold:!1,states:{hover:{halo:{size:5}}},tooltip:{pointFormat:"({point.x}, {point.y}), Size: {point.z}"},turboThreshold:0,zThreshold:0,zoneAxis:"z"}),e}(ScatterSeries$3);extend$B(BubbleSeries$2.prototype,{alignDataLabel:ColumnSeries$b.prototype.alignDataLabel,applyZones:noop$8,bubblePadding:!0,buildKDTree:noop$8,directTouch:!0,isBubble:!0,pointArrayMap:["y","z"],pointClass:BubblePoint,parallelArrays:["x","y","z"],trackerGroups:["group","dataLabelsGroup"],specialGroup:"group",zoneAxis:"z"});Axis.prototype.beforePadding=function(){var n=this,e=this.len,t=this.chart,r=0,o=e,s=this.isXAxis,a=s?"xData":"yData",l=this.min,h={},d=Math.min(t.plotWidth,t.plotHeight),c=Number.MAX_VALUE,p=-Number.MAX_VALUE,f=this.max-l,u=e/f,g=[];this.series.forEach(function(m){var y=m.options,v;m.bubblePadding&&(m.visible||!t.options.chart.ignoreHiddenSeries)&&(n.allowZoomOutside=!0,g.push(m),s&&(["minSize","maxSize"].forEach(function(x){var b=y[x],$=/%$/.test(b);b=pInt$2(b),h[x]=$?d*b/100:b}),m.minPxSize=h.minSize,m.maxPxSize=Math.max(h.maxSize,h.minSize),v=m.zData.filter(isNumber$g),v.length&&(c=pick$C(y.zMin,clamp$8(arrayMin$2(v),y.displayNegative===!1?y.zThreshold:-Number.MAX_VALUE,c)),p=pick$C(y.zMax,Math.max(p,arrayMax$2(v))))))}),g.forEach(function(m){var y=m[a],v=y.length,x;if(s&&m.getRadii(c,p,m),f>0)for(;v--;)isNumber$g(y[v])&&n.dataMin<=y[v]&&y[v]<=n.max&&(x=m.radii?m.radii[v]:0,r=Math.min((y[v]-l)*u-x,r),o=Math.max((y[v]-l)*u+x,o))}),g.length&&f>0&&!this.logarithmic&&(o-=e,u*=(e+Math.max(0,r)-Math.min(o,e))/e,[["min","userMin",r],["max","userMax",o]].forEach(function(m){typeof pick$C(n.options[m[0]],n[m[1]])>"u"&&(n[m[0]]+=m[2]/u)}))};SeriesRegistry$1.registerSeriesType("bubble",BubbleSeries$2);var __extends$z=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),_a$a=SeriesRegistry$1.seriesTypes,ColumnPoint=_a$a.column.prototype.pointClass,AreaRangePoint=_a$a.arearange.prototype.pointClass,extend$A=Utilities.extend,isNumber$f=Utilities.isNumber,ColumnRangePoint=function(n){__extends$z(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.series=void 0,t.options=void 0,t.barX=void 0,t.pointWidth=void 0,t.shapeType=void 0,t}return e.prototype.isValid=function(){return isNumber$f(this.low)},e}(AreaRangePoint);extend$A(ColumnRangePoint.prototype,{setState:ColumnPoint.prototype.setState});var __extends$y=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),noop$7=H.noop,_a$9=SeriesRegistry$1.seriesTypes,AreaRangeSeries$1=_a$9.arearange,ColumnSeries$a=_a$9.column,columnProto$3=ColumnSeries$a.prototype,arearangeProto$1=AreaRangeSeries$1.prototype,clamp$7=Utilities.clamp,merge$w=Utilities.merge,pick$B=Utilities.pick,extend$z=Utilities.extend,columnRangeOptions={pointRange:null,marker:null,states:{hover:{halo:!1}}},ColumnRangeSeries=function(n){__extends$y(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.points=void 0,t.options=void 0,t}return e.prototype.setOptions=function(){return merge$w(!0,arguments[0],{stacking:void 0}),arearangeProto$1.setOptions.apply(this,arguments)},e.prototype.translate=function(){var t=this,r=t.yAxis,o=t.xAxis,s=o.startAngleRad,a,l=t.chart,h=t.xAxis.isRadial,d=Math.max(l.chartWidth,l.chartHeight)+999,c;function p(f){return clamp$7(f,-d,d)}columnProto$3.translate.apply(t),t.points.forEach(function(f){var u=f.shapeArgs||{},g=t.options.minPointLength,m,y,v;if(f.plotHigh=c=p(r.translate(f.high,0,1,0,1)),f.plotLow=p(f.plotY),v=c,y=pick$B(f.rectPlotY,f.plotY)-c,Math.abs(y)<g?(m=g-y,y+=m,v-=m/2):y<0&&(y*=-1,v-=y),h)a=f.barX+s,f.shapeType="arc",f.shapeArgs=t.polarArc(v+y,v,a,a+f.pointWidth);else{u.height=y,u.y=v;var x=u.x,b=x===void 0?0:x,$=u.width,S=$===void 0?0:$;f.tooltipPos=l.inverted?[r.len+r.pos-l.plotLeft-v-y/2,o.len+o.pos-l.plotTop-b-S/2,y]:[o.left-l.plotLeft+b+S/2,r.pos-l.plotTop+v+y/2,y]}})},e.prototype.crispCol=function(){return columnProto$3.crispCol.apply(this,arguments)},e.prototype.drawPoints=function(){return columnProto$3.drawPoints.apply(this,arguments)},e.prototype.drawTracker=function(){return columnProto$3.drawTracker.apply(this,arguments)},e.prototype.getColumnMetrics=function(){return columnProto$3.getColumnMetrics.apply(this,arguments)},e.prototype.pointAttribs=function(){return columnProto$3.pointAttribs.apply(this,arguments)},e.prototype.adjustForMissingColumns=function(){return columnProto$3.adjustForMissingColumns.apply(this,arguments)},e.prototype.animate=function(){return columnProto$3.animate.apply(this,arguments)},e.prototype.translate3dPoints=function(){return columnProto$3.translate3dPoints.apply(this,arguments)},e.prototype.translate3dShapes=function(){return columnProto$3.translate3dShapes.apply(this,arguments)},e.defaultOptions=merge$w(ColumnSeries$a.defaultOptions,AreaRangeSeries$1.defaultOptions,columnRangeOptions),e}(AreaRangeSeries$1);extend$z(ColumnRangeSeries.prototype,{directTouch:!0,trackerGroups:["group","dataLabelsGroup"],drawGraph:noop$7,getSymbol:noop$7,polarArc:function(){return columnProto$3.polarArc.apply(this,arguments)},pointClass:ColumnRangePoint});SeriesRegistry$1.registerSeriesType("columnrange",ColumnRangeSeries);var __extends$x=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),colProto=ColumnSeries$h.prototype,clamp$6=Utilities.clamp,merge$v=Utilities.merge,pick$A=Utilities.pick,ColumnPyramidSeries=function(n){__extends$x(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.translate=function(){var t=this,r=t.chart,o=t.options,s=t.dense=t.closestPointRange*t.xAxis.transA<2,a=t.borderWidth=pick$A(o.borderWidth,s?0:1),l=t.yAxis,h=o.threshold,d=t.translatedThreshold=l.getThreshold(h),c=pick$A(o.minPointLength,5),p=t.getColumnMetrics(),f=p.width,u=t.barW=Math.max(f,1+2*a),g=t.pointXOffset=p.offset;r.inverted&&(d-=.5),o.pointPadding&&(u=Math.ceil(u)),colProto.translate.apply(t),t.points.forEach(function(m){var y=pick$A(m.yBottom,d),v=999+Math.abs(y),x=clamp$6(m.plotY,-v,l.len+v),b=m.plotX+g,$=u/2,S=Math.min(x,y),k=Math.max(x,y)-S,A,M,P,E,T,O,C,I,L,D,N,B;m.barX=b,m.pointWidth=f,m.tooltipPos=r.inverted?[l.len+l.pos-r.plotLeft-x,t.xAxis.len-b-$,k]:[b+$,x+l.pos-r.plotTop,k],A=h+(m.total||m.y),o.stacking==="percent"&&(A=h+(m.y<0)?-100:100),P=l.toPixels(A,!0),M=r.plotHeight-P-(r.plotHeight-d),E=M?$*(S-P)/M:0,T=M?$*(S+k-P)/M:0,C=b-E+$,I=b+E+$,L=b+T+$,D=b-T+$,N=S-c,B=S+k,m.y<0&&(N=S,B=S+k+c),r.inverted&&(O=r.plotWidth-S,M=P-(r.plotWidth-d),E=$*(P-O)/M,T=$*(P-(O-k))/M,C=b+$+E,I=C-2*E,L=b-T+$,D=b+T+$,N=S,B=S+k-c,m.y<0&&(B=S+k+c)),m.shapeType="path",m.shapeArgs={x:C,y:N,width:I-C,height:k,d:[["M",C,N],["L",I,N],["L",L,B],["L",D,B],["Z"]]}})},e.defaultOptions=merge$v(ColumnSeries$h.defaultOptions,{}),e}(ColumnSeries$h);SeriesRegistry$1.registerSeriesType("columnpyramid",ColumnPyramidSeries);var __extends$w=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),AreaRangeSeries=SeriesRegistry$1.seriesTypes.arearange,merge$u=Utilities.merge,extend$y=Utilities.extend,ErrorBarSeries=function(n){__extends$w(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.getColumnMetrics=function(){return this.linkedParent&&this.linkedParent.columnMetrics||ColumnSeries$h.prototype.getColumnMetrics.call(this)},e.prototype.drawDataLabels=function(){var t=this.pointValKey;AreaRangeSeries&&(AreaRangeSeries.prototype.drawDataLabels.call(this),this.data.forEach(function(r){r.y=r[t]}))},e.prototype.toYData=function(t){return[t.low,t.high]},e.defaultOptions=merge$u(BoxPlotSeries.defaultOptions,{color:palette.neutralColor100,grouping:!1,linkedTo:":previous",tooltip:{pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.low}</b> - <b>{point.high}</b><br/>'},whiskerWidth:null}),e}(BoxPlotSeries);extend$y(ErrorBarSeries.prototype,{pointArrayMap:["low","high"],pointValKey:"high",doQuartiles:!1});SeriesRegistry$1.registerSeriesType("errorbar",ErrorBarSeries);var __extends$v=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),Point$1=SeriesRegistry$1.series.prototype.pointClass,GaugePoint=function(n){__extends$v(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t.shapeArgs=void 0,t}return e.prototype.setState=function(t){this.state=t},e}(Point$1),__extends$u=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),noop$6=H.noop,Series$a=SeriesRegistry$1.series,ColumnSeries$9=SeriesRegistry$1.seriesTypes.column,clamp$5=Utilities.clamp,isNumber$e=Utilities.isNumber,extend$x=Utilities.extend,merge$t=Utilities.merge,pick$z=Utilities.pick,pInt$1=Utilities.pInt,GaugeSeries$1=function(n){__extends$u(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.points=void 0,t.options=void 0,t.yAxis=void 0,t}return e.prototype.translate=function(){var t=this,r=t.yAxis,o=t.options,s=r.center;t.generatePoints(),t.points.forEach(function(a){var l=merge$t(o.dial,a.dial),h=pInt$1(pick$z(l.radius,"80%"))*s[2]/200,d=pInt$1(pick$z(l.baseLength,"70%"))*h/100,c=pInt$1(pick$z(l.rearLength,"10%"))*h/100,p=l.baseWidth||3,f=l.topWidth||1,u=o.overshoot,g=r.startAngleRad+r.translate(a.y,null,null,null,!0);(isNumber$e(u)||o.wrap===!1)&&(u=isNumber$e(u)?u/180*Math.PI:0,g=clamp$5(g,r.startAngleRad-u,r.endAngleRad+u)),g=g*180/Math.PI,a.shapeType="path";var m=l.path||[["M",-c,-p/2],["L",d,-p/2],["L",h,-f/2],["L",h,f/2],["L",d,p/2],["L",-c,p/2],["Z"]];a.shapeArgs={d:m,translateX:s[0],translateY:s[1],rotation:g},a.plotX=s[0],a.plotY=s[1]})},e.prototype.drawPoints=function(){var t=this,r=t.chart,o=t.yAxis.center,s=t.pivot,a=t.options,l=a.pivot,h=r.renderer;t.points.forEach(function(d){var c=d.graphic,p=d.shapeArgs,f=p.d,u=merge$t(a.dial,d.dial);c?(c.animate(p),p.d=f):d.graphic=h[d.shapeType](p).attr({rotation:p.rotation,zIndex:1}).addClass("highcharts-dial").add(t.group),r.styledMode||d.graphic[c?"animate":"attr"]({stroke:u.borderColor||"none","stroke-width":u.borderWidth||0,fill:u.backgroundColor||palette.neutralColor100})}),s?s.animate({translateX:o[0],translateY:o[1]}):(t.pivot=h.circle(0,0,pick$z(l.radius,5)).attr({zIndex:2}).addClass("highcharts-pivot").translate(o[0],o[1]).add(t.group),r.styledMode||t.pivot.attr({"stroke-width":l.borderWidth||0,stroke:l.borderColor||palette.neutralColor20,fill:l.backgroundColor||palette.neutralColor100}))},e.prototype.animate=function(t){var r=this;t||r.points.forEach(function(o){var s=o.graphic;s&&(s.attr({rotation:r.yAxis.startAngleRad*180/Math.PI}),s.animate({rotation:o.shapeArgs.rotation},r.options.animation))})},e.prototype.render=function(){this.group=this.plotGroup("group","series",this.visible?"visible":"hidden",this.options.zIndex,this.chart.seriesGroup),Series$a.prototype.render.call(this),this.group.clip(this.chart.clipRect)},e.prototype.setData=function(t,r){Series$a.prototype.setData.call(this,t,!1),this.processData(),this.generatePoints(),pick$z(r,!0)&&this.chart.redraw()},e.prototype.hasData=function(){return!!this.points.length},e.defaultOptions=merge$t(Series$a.defaultOptions,{dataLabels:{borderColor:palette.neutralColor20,borderRadius:3,borderWidth:1,crop:!1,defer:!1,enabled:!0,verticalAlign:"top",y:15,zIndex:2},dial:{},pivot:{},tooltip:{headerFormat:""},showInLegend:!1}),e}(Series$a);extend$x(GaugeSeries$1.prototype,{angular:!0,directTouch:!0,drawGraph:noop$6,drawTracker:ColumnSeries$9.prototype.drawTracker,fixedBox:!0,forceDL:!0,noSharedTooltip:!0,pointClass:GaugePoint,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("gauge",GaugeSeries$1);var __extends$t=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),BubbleSeries$1=SeriesRegistry$1.seriesTypes.bubble,PackedBubblePoint=function(n){__extends$t(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.degree=NaN,t.mass=NaN,t.radius=NaN,t.options=void 0,t.series=void 0,t.value=null,t}return e.prototype.destroy=function(){return this.series.layout&&this.series.layout.removeElementFromCollection(this,this.series.layout.nodes),Point$2.prototype.destroy.apply(this,arguments)},e.prototype.firePointEvent=function(){var t=this.series,r=t.options;if(this.isParentNode&&r.parentNode){var o=r.allowPointSelect;r.allowPointSelect=r.parentNode.allowPointSelect,Point$2.prototype.firePointEvent.apply(this,arguments),r.allowPointSelect=o}else Point$2.prototype.firePointEvent.apply(this,arguments)},e.prototype.select=function(){var t=this,r=this.series,o=r.chart;t.isParentNode?(o.getSelectedPoints=o.getSelectedParentNodes,Point$2.prototype.select.apply(this,arguments),o.getSelectedPoints=Chart$1.prototype.getSelectedPoints):Point$2.prototype.select.apply(this,arguments)},e}(BubbleSeries$1.prototype.pointClass),addEvent$n=Utilities.addEvent;H.dragNodesMixin={onMouseDown:function(n,e){var t=this.chart.pointer.normalize(e);n.fixedPosition={chartX:t.chartX,chartY:t.chartY,plotX:n.plotX,plotY:n.plotY},n.inDragMode=!0},onMouseMove:function(n,e){if(n.fixedPosition&&n.inDragMode){var t=this,r=t.chart,o=r.pointer.normalize(e),s=n.fixedPosition.chartX-o.chartX,a=n.fixedPosition.chartY-o.chartY,l=void 0,h=void 0,d=r.graphLayoutsLookup;(Math.abs(s)>5||Math.abs(a)>5)&&(l=n.fixedPosition.plotX-s,h=n.fixedPosition.plotY-a,r.isInsidePlot(l,h)&&(n.plotX=l,n.plotY=h,n.hasDragged=!0,this.redrawHalo(n),d.forEach(function(c){c.restartSimulation()})))}},onMouseUp:function(n,e){n.fixedPosition&&(n.hasDragged&&(this.layout.enableSimulation?this.layout.start():this.chart.redraw()),n.inDragMode=n.hasDragged=!1,this.options.fixedDraggable||delete n.fixedPosition)},redrawHalo:function(n){n&&this.halo&&this.halo.attr({d:n.haloPath(this.options.states.hover.halo.size)})}};addEvent$n(Chart$1,"load",function(){var n=this,e,t,r;n.container&&(e=addEvent$n(n.container,"mousedown",function(o){var s=n.hoverPoint;s&&s.series&&s.series.hasDraggableNodes&&s.series.options.draggable&&(s.series.onMouseDown(s,o),t=addEvent$n(n.container,"mousemove",function(a){return s&&s.series&&s.series.onMouseMove(s,a)}),r=addEvent$n(n.container.ownerDocument,"mouseup",function(a){return t(),r(),s&&s.series&&s.series.onMouseUp(s,a)}))})),addEvent$n(n,"destroy",function(){e()})});H.networkgraphIntegrations={verlet:{attractiveForceFunction:function(n,e){return(e-n)/n},repulsiveForceFunction:function(n,e){return(e-n)/n*(e>n?1:0)},barycenter:function(){var n=this.options.gravitationalConstant,e=this.barycenter.xFactor,t=this.barycenter.yFactor;e=(e-(this.box.left+this.box.width)/2)*n,t=(t-(this.box.top+this.box.height)/2)*n,this.nodes.forEach(function(r){r.fixedPosition||(r.plotX-=e/r.mass/r.degree,r.plotY-=t/r.mass/r.degree)})},repulsive:function(n,e,t){var r=e*this.diffTemperature/n.mass/n.degree;n.fixedPosition||(n.plotX+=t.x*r,n.plotY+=t.y*r)},attractive:function(n,e,t){var r=n.getMass(),o=-t.x*e*this.diffTemperature,s=-t.y*e*this.diffTemperature;n.fromNode.fixedPosition||(n.fromNode.plotX-=o*r.fromNode/n.fromNode.degree,n.fromNode.plotY-=s*r.fromNode/n.fromNode.degree),n.toNode.fixedPosition||(n.toNode.plotX+=o*r.toNode/n.toNode.degree,n.toNode.plotY+=s*r.toNode/n.toNode.degree)},integrate:function(n,e){var t=-n.options.friction,r=n.options.maxSpeed,o=e.prevX,s=e.prevY,a=(e.plotX+e.dispX-o)*t,l=(e.plotY+e.dispY-s)*t,h=Math.abs,d=h(a)/(a||1),c=h(l)/(l||1);a=d*Math.min(r,Math.abs(a)),l=c*Math.min(r,Math.abs(l)),e.prevX=e.plotX+e.dispX,e.prevY=e.plotY+e.dispY,e.plotX+=a,e.plotY+=l,e.temperature=n.vectorLength({x:a,y:l})},getK:function(n){return Math.pow(n.box.width*n.box.height/n.nodes.length,.5)}},euler:{attractiveForceFunction:function(n,e){return n*n/e},repulsiveForceFunction:function(n,e){return e*e/n},barycenter:function(){var n=this.options.gravitationalConstant,e=this.barycenter.xFactor,t=this.barycenter.yFactor;this.nodes.forEach(function(r){if(!r.fixedPosition){var o=r.getDegree(),s=o*(1+o/2);r.dispX+=(e-r.plotX)*n*s/r.degree,r.dispY+=(t-r.plotY)*n*s/r.degree}})},repulsive:function(n,e,t,r){n.dispX+=t.x/r*e/n.degree,n.dispY+=t.y/r*e/n.degree},attractive:function(n,e,t,r){var o=n.getMass(),s=t.x/r*e,a=t.y/r*e;n.fromNode.fixedPosition||(n.fromNode.dispX-=s*o.fromNode/n.fromNode.degree,n.fromNode.dispY-=a*o.fromNode/n.fromNode.degree),n.toNode.fixedPosition||(n.toNode.dispX+=s*o.toNode/n.toNode.degree,n.toNode.dispY+=a*o.toNode/n.toNode.degree)},integrate:function(n,e){var t;e.dispX+=e.dispX*n.options.friction,e.dispY+=e.dispY*n.options.friction,t=e.temperature=n.vectorLength({x:e.dispX,y:e.dispY}),t!==0&&(e.plotX+=e.dispX/t*Math.min(Math.abs(e.dispX),n.temperature),e.plotY+=e.dispY/t*Math.min(Math.abs(e.dispY),n.temperature))},getK:function(n){return Math.pow(n.box.width*n.box.height/n.nodes.length,.3)}}};var extend$w=Utilities.extend,QuadTreeNode=H.QuadTreeNode=function(n){this.box=n,this.boxSize=Math.min(n.width,n.height),this.nodes=[],this.isInternal=!1,this.body=!1,this.isEmpty=!0};extend$w(QuadTreeNode.prototype,{insert:function(n,e){var t;this.isInternal?this.nodes[this.getBoxPosition(n)].insert(n,e-1):(this.isEmpty=!1,this.body?e?(this.isInternal=!0,this.divideBox(),this.body!==!0&&(this.nodes[this.getBoxPosition(this.body)].insert(this.body,e-1),this.body=!0),this.nodes[this.getBoxPosition(n)].insert(n,e-1)):(t=new QuadTreeNode({top:n.plotX,left:n.plotY,width:.1,height:.1}),t.body=n,t.isInternal=!1,this.nodes.push(t)):(this.isInternal=!1,this.body=n))},updateMassAndCenter:function(){var n=0,e=0,t=0;this.isInternal?(this.nodes.forEach(function(r){r.isEmpty||(n+=r.mass,e+=r.plotX*r.mass,t+=r.plotY*r.mass)}),e/=n,t/=n):this.body&&(n=this.body.mass,e=this.body.plotX,t=this.body.plotY),this.mass=n,this.plotX=e,this.plotY=t},divideBox:function(){var n=this.box.width/2,e=this.box.height/2;this.nodes[0]=new QuadTreeNode({left:this.box.left,top:this.box.top,width:n,height:e}),this.nodes[1]=new QuadTreeNode({left:this.box.left+n,top:this.box.top,width:n,height:e}),this.nodes[2]=new QuadTreeNode({left:this.box.left+n,top:this.box.top+e,width:n,height:e}),this.nodes[3]=new QuadTreeNode({left:this.box.left,top:this.box.top+e,width:n,height:e})},getBoxPosition:function(n){var e=n.plotX<this.box.left+this.box.width/2,t=n.plotY<this.box.top+this.box.height/2,r;return e?t?r=0:r=3:t?r=1:r=2,r}});var QuadTree=H.QuadTree=function(n,e,t,r){this.box={left:n,top:e,width:t,height:r},this.maxDepth=25,this.root=new QuadTreeNode(this.box,"0"),this.root.isInternal=!0,this.root.isRoot=!0,this.root.divideBox()};extend$w(QuadTree.prototype,{insertNodes:function(n){n.forEach(function(e){this.root.insert(e,this.maxDepth)},this)},visitNodeRecursive:function(n,e,t){var r;n||(n=this.root),n===this.root&&e&&(r=e(n)),r!==!1&&(n.nodes.forEach(function(o){if(o.isInternal){if(e&&(r=e(o)),r===!1)return;this.visitNodeRecursive(o,e,t)}else o.body&&e&&e(o.body);t&&t(o)},this),n===this.root&&t&&t(n))},calculateMassAndCenter:function(){this.visitNodeRecursive(null,null,function(n){n.updateMassAndCenter()})}});var setAnimation=animationExports.setAnimation,addEvent$m=Utilities.addEvent,clamp$4=Utilities.clamp,defined$e=Utilities.defined,extend$v=Utilities.extend,isFunction=Utilities.isFunction,pick$y=Utilities.pick;H.layouts={"reingold-fruchterman":function(){}};extend$v(H.layouts["reingold-fruchterman"].prototype,{init:function(n){this.options=n,this.nodes=[],this.links=[],this.series=[],this.box={x:0,y:0,width:0,height:0},this.setInitialRendering(!0),this.integration=H.networkgraphIntegrations[n.integration],this.enableSimulation=n.enableSimulation,this.attractiveForce=pick$y(n.attractiveForce,this.integration.attractiveForceFunction),this.repulsiveForce=pick$y(n.repulsiveForce,this.integration.repulsiveForceFunction),this.approximation=n.approximation},updateSimulation:function(n){this.enableSimulation=pick$y(n,this.options.enableSimulation)},start:function(){var n=this,e=this.series,t=this.options;n.currentStep=0,n.forces=e[0]&&e[0].forces||[],n.chart=e[0]&&e[0].chart,n.initialRendering&&(n.initPositions(),e.forEach(function(r){r.finishedAnimating=!0,r.render()})),n.setK(),n.resetSimulation(t),n.enableSimulation&&n.step()},step:function(){var n=this,e=this.series;this.options,n.currentStep++,n.approximation==="barnes-hut"&&(n.createQuadTree(),n.quadTree.calculateMassAndCenter()),n.forces.forEach(function(t){n[t+"Forces"](n.temperature)}),n.applyLimits(n.temperature),n.temperature=n.coolDown(n.startTemperature,n.diffTemperature,n.currentStep),n.prevSystemTemperature=n.systemTemperature,n.systemTemperature=n.getSystemTemperature(),n.enableSimulation&&(e.forEach(function(t){t.chart&&t.render()}),n.maxIterations--&&isFinite(n.temperature)&&!n.isStable()?(n.simulation&&H.win.cancelAnimationFrame(n.simulation),n.simulation=H.win.requestAnimationFrame(function(){n.step()})):n.simulation=!1)},stop:function(){this.simulation&&H.win.cancelAnimationFrame(this.simulation)},setArea:function(n,e,t,r){this.box={left:n,top:e,width:t,height:r}},setK:function(){this.k=this.options.linkLength||this.integration.getK(this)},addElementsToCollection:function(n,e){n.forEach(function(t){e.indexOf(t)===-1&&e.push(t)})},removeElementFromCollection:function(n,e){var t=e.indexOf(n);t!==-1&&e.splice(t,1)},clear:function(){this.nodes.length=0,this.links.length=0,this.series.length=0,this.resetSimulation()},resetSimulation:function(){this.forcedStop=!1,this.systemTemperature=0,this.setMaxIterations(),this.setTemperature(),this.setDiffTemperature()},restartSimulation:function(){this.simulation?this.resetSimulation():(this.setInitialRendering(!1),this.enableSimulation?this.start():this.setMaxIterations(1),this.chart&&this.chart.redraw(),this.setInitialRendering(!0))},setMaxIterations:function(n){this.maxIterations=pick$y(n,this.options.maxIterations)},setTemperature:function(){this.temperature=this.startTemperature=Math.sqrt(this.nodes.length)},setDiffTemperature:function(){this.diffTemperature=this.startTemperature/(this.options.maxIterations+1)},setInitialRendering:function(n){this.initialRendering=n},createQuadTree:function(){this.quadTree=new H.QuadTree(this.box.left,this.box.top,this.box.width,this.box.height),this.quadTree.insertNodes(this.nodes)},initPositions:function(){var n=this.options.initialPositions;isFunction(n)?(n.call(this),this.nodes.forEach(function(e){defined$e(e.prevX)||(e.prevX=e.plotX),defined$e(e.prevY)||(e.prevY=e.plotY),e.dispX=0,e.dispY=0})):n==="circle"?this.setCircularPositions():this.setRandomPositions()},setCircularPositions:function(){var n=this.box,e=this.nodes,t=e.length+1,r=2*Math.PI/t,o=e.filter(function(d){return d.linksTo.length===0}),s=[],a={},l=this.options.initialPositionRadius;function h(d){d.linksFrom.forEach(function(c){a[c.toNode.id]||(a[c.toNode.id]=!0,s.push(c.toNode),h(c.toNode))})}o.forEach(function(d){s.push(d),h(d)}),s.length?e.forEach(function(d){s.indexOf(d)===-1&&s.push(d)}):s=e,s.forEach(function(d,c){d.plotX=d.prevX=pick$y(d.plotX,n.width/2+l*Math.cos(c*r)),d.plotY=d.prevY=pick$y(d.plotY,n.height/2+l*Math.sin(c*r)),d.dispX=0,d.dispY=0})},setRandomPositions:function(){var n=this.box,e=this.nodes,t=e.length+1;function r(o){var s=o*o/Math.PI;return s=s-Math.floor(s),s}e.forEach(function(o,s){o.plotX=o.prevX=pick$y(o.plotX,n.width*r(s)),o.plotY=o.prevY=pick$y(o.plotY,n.height*r(t+s)),o.dispX=0,o.dispY=0})},force:function(n){this.integration[n].apply(this,Array.prototype.slice.call(arguments,1))},barycenterForces:function(){this.getBarycenter(),this.force("barycenter")},getBarycenter:function(){var n=0,e=0,t=0;return this.nodes.forEach(function(r){e+=r.plotX*r.mass,t+=r.plotY*r.mass,n+=r.mass}),this.barycenter={x:e,y:t,xFactor:e/n,yFactor:t/n},this.barycenter},barnesHutApproximation:function(n,e){var t=this,r=t.getDistXY(n,e),o=t.vectorLength(r),s,a;return n!==e&&o!==0&&(e.isInternal?e.boxSize/o<t.options.theta&&o!==0?(a=t.repulsiveForce(o,t.k),t.force("repulsive",n,a*e.mass,r,o),s=!1):s=!0:(a=t.repulsiveForce(o,t.k),t.force("repulsive",n,a*e.mass,r,o))),s},repulsiveForces:function(){var n=this;n.approximation==="barnes-hut"?n.nodes.forEach(function(e){n.quadTree.visitNodeRecursive(null,function(t){return n.barnesHutApproximation(e,t)})}):n.nodes.forEach(function(e){n.nodes.forEach(function(t){var r,o,s;e!==t&&!e.fixedPosition&&(s=n.getDistXY(e,t),o=n.vectorLength(s),o!==0&&(r=n.repulsiveForce(o,n.k),n.force("repulsive",e,r*t.mass,s,o)))})})},attractiveForces:function(){var n=this,e,t,r;n.links.forEach(function(o){o.fromNode&&o.toNode&&(e=n.getDistXY(o.fromNode,o.toNode),t=n.vectorLength(e),t!==0&&(r=n.attractiveForce(t,n.k),n.force("attractive",o,r,e,t)))})},applyLimits:function(){var n=this,e=n.nodes;e.forEach(function(t){t.fixedPosition||(n.integration.integrate(n,t),n.applyLimitBox(t,n.box),t.dispX=0,t.dispY=0)})},applyLimitBox:function(n,e){var t=n.radius;n.plotX=clamp$4(n.plotX,e.left+t,e.width-t),n.plotY=clamp$4(n.plotY,e.top+t,e.height-t)},coolDown:function(n,e,t){return n-e*t},isStable:function(){return Math.abs(this.systemTemperature-this.prevSystemTemperature)<1e-5||this.temperature<=0},getSystemTemperature:function(){return this.nodes.reduce(function(n,e){return n+e.temperature},0)},vectorLength:function(n){return Math.sqrt(n.x*n.x+n.y*n.y)},getDistR:function(n,e){var t=this.getDistXY(n,e);return this.vectorLength(t)},getDistXY:function(n,e){var t=n.plotX-e.plotX,r=n.plotY-e.plotY;return{x:t,y:r,absX:Math.abs(t),absY:Math.abs(r)}}});addEvent$m(Chart$1,"predraw",function(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(n){n.stop()})});addEvent$m(Chart$1,"render",function(){var n,e=!1;function t(r){r.maxIterations--&&isFinite(r.temperature)&&!r.isStable()&&!r.enableSimulation&&(r.beforeStep&&r.beforeStep(),r.step(),n=!1,e=!0)}if(this.graphLayoutsLookup){for(setAnimation(!1,this),this.graphLayoutsLookup.forEach(function(r){r.start()});!n;)n=!0,this.graphLayoutsLookup.forEach(t);e&&this.series.forEach(function(r){r&&r.layout&&r.render()})}});addEvent$m(Chart$1,"beforePrint",function(){this.graphLayoutsLookup&&(this.graphLayoutsLookup.forEach(function(n){n.updateSimulation(!1)}),this.redraw())});addEvent$m(Chart$1,"afterPrint",function(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(n){n.updateSimulation()}),this.redraw()});var Reingold=H.layouts["reingold-fruchterman"],addEvent$l=Utilities.addEvent,extendClass=Utilities.extendClass,pick$x=Utilities.pick;Chart$1.prototype.getSelectedParentNodes=function(){var n=this,e=n.series,t=[];return e.forEach(function(r){r.parentNode&&r.parentNode.selected&&t.push(r.parentNode)}),t};H.networkgraphIntegrations.packedbubble={repulsiveForceFunction:function(n,e,t,r){return Math.min(n,(t.marker.radius+r.marker.radius)/2)},barycenter:function(){var n=this,e=n.options.gravitationalConstant,t=n.box,r=n.nodes,o,s;r.forEach(function(a){n.options.splitSeries&&!a.isParentNode?(o=a.series.parentNode.plotX,s=a.series.parentNode.plotY):(o=t.width/2,s=t.height/2),a.fixedPosition||(a.plotX-=(a.plotX-o)*e/(a.mass*Math.sqrt(r.length)),a.plotY-=(a.plotY-s)*e/(a.mass*Math.sqrt(r.length)))})},repulsive:function(n,e,t,r){var o=e*this.diffTemperature/n.mass/n.degree,s=t.x*o,a=t.y*o;n.fixedPosition||(n.plotX+=s,n.plotY+=a),r.fixedPosition||(r.plotX-=s,r.plotY-=a)},integrate:H.networkgraphIntegrations.verlet.integrate,getK:H.noop};H.layouts.packedbubble=extendClass(Reingold,{beforeStep:function(){this.options.marker&&this.series.forEach(function(n){n&&n.calculateParentRadius()})},isStable:function(){var n=Math.abs(this.prevSystemTemperature-this.systemTemperature),e=10*this.systemTemperature/Math.sqrt(this.nodes.length);return Math.abs(e)<1&&n<1e-5||this.temperature<=0},setCircularPositions:function(){var n=this,e=n.box,t=n.nodes,r=t.length+1,o=2*Math.PI/r,s,a,l=n.options.initialPositionRadius;t.forEach(function(h,d){n.options.splitSeries&&!h.isParentNode?(s=h.series.parentNode.plotX,a=h.series.parentNode.plotY):(s=e.width/2,a=e.height/2),h.plotX=h.prevX=pick$x(h.plotX,s+l*Math.cos(h.index||d*o)),h.plotY=h.prevY=pick$x(h.plotY,a+l*Math.sin(h.index||d*o)),h.dispX=0,h.dispY=0})},repulsiveForces:function(){var n=this,e,t,r,o=n.options.bubblePadding;n.nodes.forEach(function(s){s.degree=s.mass,s.neighbours=0,n.nodes.forEach(function(a){e=0,s!==a&&!s.fixedPosition&&(n.options.seriesInteraction||s.series===a.series)&&(r=n.getDistXY(s,a),t=n.vectorLength(r)-(s.marker.radius+a.marker.radius+o),t<0&&(s.degree+=.01,s.neighbours++,e=n.repulsiveForce(-t/Math.sqrt(s.neighbours),n.k,s,a)),n.force("repulsive",s,e*a.mass,r,a,t))})})},applyLimitBox:function(n){var e=this,t,r,o=.01;e.options.splitSeries&&!n.isParentNode&&e.options.parentNodeLimit&&(t=e.getDistXY(n,n.series.parentNode),r=n.series.parentNodeRadius-n.marker.radius-e.vectorLength(t),r<0&&r>-2*n.marker.radius&&(n.plotX-=t.x*o,n.plotY-=t.y*o)),Reingold.prototype.applyLimitBox.apply(this,arguments)}});addEvent$l(Chart$1,"beforeRedraw",function(){this.allDataPoints&&delete this.allDataPoints});var __extends$s=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),color$8=Color.parse,Series$9=SeriesRegistry$1.series,BubbleSeries=SeriesRegistry$1.seriesTypes.bubble,addEvent$k=Utilities.addEvent,clamp$3=Utilities.clamp,defined$d=Utilities.defined,extend$u=Utilities.extend,fireEvent$6=Utilities.fireEvent,isArray$4=Utilities.isArray,isNumber$d=Utilities.isNumber,merge$s=Utilities.merge,pick$w=Utilities.pick,dragNodesMixin=H.dragNodesMixin,PackedBubbleSeries=function(n){__extends$s(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.chart=void 0,t.data=void 0,t.layout=void 0,t.options=void 0,t.points=void 0,t.xData=void 0,t}return e.prototype.accumulateAllPoints=function(t){var r=t.chart,o=[],s,a;for(s=0;s<r.series.length;s++)if(t=r.series[s],t.is("packedbubble")&&t.visible||!r.options.chart.ignoreHiddenSeries)for(a=0;a<t.yData.length;a++)o.push([null,null,t.yData[a],t.index,a,{id:a,marker:{radius:0}}]);return o},e.prototype.addLayout=function(){var t=this,r=t.options.layoutAlgorithm,o=t.chart.graphLayoutsStorage,s=t.chart.graphLayoutsLookup,a=t.chart.options.chart,l;o||(t.chart.graphLayoutsStorage=o={},t.chart.graphLayoutsLookup=s=[]),l=o[r.type],l||(r.enableSimulation=defined$d(a.forExport)?!a.forExport:r.enableSimulation,o[r.type]=l=new H.layouts[r.type],l.init(r),s.splice(l.index,0,l)),t.layout=l,t.points.forEach(function(h){h.mass=2,h.degree=1,h.collisionNmb=1}),l.setArea(0,0,t.chart.plotWidth,t.chart.plotHeight),l.addElementsToCollection([t],l.series),l.addElementsToCollection(t.points,l.nodes)},e.prototype.addSeriesLayout=function(){var t=this,r=t.options.layoutAlgorithm,o=t.chart.graphLayoutsStorage,s=t.chart.graphLayoutsLookup,a=merge$s(r,r.parentNodeOptions,{enableSimulation:t.layout.options.enableSimulation}),l;l=o[r.type+"-series"],l||(o[r.type+"-series"]=l=new H.layouts[r.type],l.init(a),s.splice(l.index,0,l)),t.parentNodeLayout=l,this.createParentNodes()},e.prototype.calculateParentRadius=function(){var t=this,r,o=20,s=20;r=t.seriesBox(),t.parentNodeRadius=clamp$3(Math.sqrt(2*t.parentNodeMass/Math.PI)+o,s,r?Math.max(Math.sqrt(Math.pow(r.width,2)+Math.pow(r.height,2))/2+o,s):Math.sqrt(2*t.parentNodeMass/Math.PI)+o),t.parentNode&&(t.parentNode.marker.radius=t.parentNode.radius=t.parentNodeRadius)},e.prototype.calculateZExtremes=function(){var t=this.chart,r=this.options.zMin,o=this.options.zMax,s=1/0,a=-1/0;return r&&o?[r,o]:(t.series.forEach(function(l){l.yData.forEach(function(h){defined$d(h)&&(h>a&&(a=h),h<s&&(s=h))})}),r=pick$w(r,s),o=pick$w(o,a),[r,o])},e.prototype.checkOverlap=function(t,r){var o=t[0]-r[0],s=t[1]-r[1],a=t[2]+r[2];return Math.sqrt(o*o+s*s)-Math.abs(a)<-.001},e.prototype.createParentNodes=function(){var t=this,r=t.chart,o=t.parentNodeLayout,s,a=t.parentNode,l=t.pointClass;t.parentNodeMass=0,t.points.forEach(function(h){t.parentNodeMass+=Math.PI*Math.pow(h.marker.radius,2)}),t.calculateParentRadius(),o.nodes.forEach(function(h){h.seriesIndex===t.index&&(s=!0)}),o.setArea(0,0,r.plotWidth,r.plotHeight),s||(a||(a=new l().init(this,{mass:t.parentNodeRadius/2,marker:{radius:t.parentNodeRadius},dataLabels:{inside:!1},dataLabelOnNull:!0,degree:t.parentNodeRadius,isParentNode:!0,seriesIndex:t.index})),t.parentNode&&(a.plotX=t.parentNode.plotX,a.plotY=t.parentNode.plotY),t.parentNode=a,o.addElementsToCollection([t],o.series),o.addElementsToCollection([a],o.nodes))},e.prototype.deferLayout=function(){var t=this,r=t.options.layoutAlgorithm;t.visible&&(t.addLayout(),r.splitSeries&&t.addSeriesLayout())},e.prototype.destroy=function(){this.chart.graphLayoutsLookup&&this.chart.graphLayoutsLookup.forEach(function(t){t.removeElementFromCollection(this,t.series)},this),this.parentNode&&this.parentNodeLayout&&(this.parentNodeLayout.removeElementFromCollection(this.parentNode,this.parentNodeLayout.nodes),this.parentNode.dataLabel&&(this.parentNode.dataLabel=this.parentNode.dataLabel.destroy())),Series$9.prototype.destroy.apply(this,arguments)},e.prototype.drawDataLabels=function(){var t=this.options.dataLabels.textPath,r=this.points;Series$9.prototype.drawDataLabels.apply(this,arguments),this.parentNode&&(this.parentNode.formatPrefix="parentNode",this.points=[this.parentNode],this.options.dataLabels.textPath=this.options.dataLabels.parentNodeTextPath,Series$9.prototype.drawDataLabels.apply(this,arguments),this.points=r,this.options.dataLabels.textPath=t)},e.prototype.drawGraph=function(){if(!(!this.layout||!this.layout.options.splitSeries)){var t=this,r=t.chart,o={},s=this.layout.options.parentNodeOptions.marker,a={fill:s.fillColor||color$8(t.color).brighten(.4).get(),opacity:s.fillOpacity,stroke:s.lineColor||t.color,"stroke-width":s.lineWidth};this.parentNodesGroup||(t.parentNodesGroup=t.plotGroup("parentNodesGroup","parentNode",t.visible?"inherit":"hidden",.1,r.seriesGroup),t.group.attr({zIndex:2})),this.calculateParentRadius(),o=merge$s({x:t.parentNode.plotX-t.parentNodeRadius,y:t.parentNode.plotY-t.parentNodeRadius,width:t.parentNodeRadius*2,height:t.parentNodeRadius*2},a),t.parentNode.graphic||(t.graph=t.parentNode.graphic=r.renderer.symbol(a.symbol).add(t.parentNodesGroup)),t.parentNode.graphic.attr(o)}},e.prototype.drawTracker=function(){var t=this,r=t.parentNode,o;n.prototype.drawTracker.call(this),r&&(o=isArray$4(r.dataLabels)?r.dataLabels:r.dataLabel?[r.dataLabel]:[],r.graphic&&(r.graphic.element.point=r),o.forEach(function(s){s.div?s.div.point=r:s.element.point=r}))},e.prototype.getPointRadius=function(){var t=this,r=t.chart,o=r.plotWidth,s=r.plotHeight,a=t.options,l=a.useSimulation,h=Math.min(o,s),d={},c=[],p=r.allDataPoints,f,u,g,m,y;["minSize","maxSize"].forEach(function(v){var x=parseInt(a[v],10),b=/%$/.test(a[v]);d[v]=b?h*x/100:x*Math.sqrt(p.length)}),r.minRadius=f=d.minSize/Math.sqrt(p.length),r.maxRadius=u=d.maxSize/Math.sqrt(p.length),y=l?t.calculateZExtremes():[f,u],(p||[]).forEach(function(v,x){g=l?clamp$3(v[2],y[0],y[1]):v[2],m=t.getRadius(y[0],y[1],f,u,g),m===0&&(m=null),p[x][2]=m,c.push(m)}),t.radii=c},e.prototype.init=function(){return Series$9.prototype.init.apply(this,arguments),this.eventsToUnbind.push(addEvent$k(this,"updatedData",function(){this.chart.series.forEach(function(t){t.type===this.type&&(t.isDirty=!0)},this)})),this},e.prototype.onMouseUp=function(t){if(t.fixedPosition&&!t.removed){var r,o,s=this.layout,a=this.parentNodeLayout;a&&s.options.dragBetweenSeries&&a.nodes.forEach(function(l){t&&t.marker&&l!==t.series.parentNode&&(r=s.getDistXY(t,l),o=s.vectorLength(r)-l.marker.radius-t.marker.radius,o<0&&(l.series.addPoint(merge$s(t.options,{plotX:t.plotX,plotY:t.plotY}),!1),s.removeElementFromCollection(t,s.nodes),t.remove()))}),dragNodesMixin.onMouseUp.apply(this,arguments)}},e.prototype.placeBubbles=function(t){var r=this,o=r.checkOverlap,s=r.positionBubble,a=[],l=1,h=0,d=0,c,p,f=[],u;if(p=t.sort(function(g,m){return m[2]-g[2]}),p.length){if(a.push([[0,0,p[0][2],p[0][3],p[0][4]]]),p.length>1)for(a.push([[0,0-p[1][2]-p[0][2],p[1][2],p[1][3],p[1][4]]]),u=2;u<p.length;u++)p[u][2]=p[u][2]||1,c=s(a[l][h],a[l-1][d],p[u]),o(c,a[l][0])?(a.push([]),d=0,a[l+1].push(s(a[l][h],a[l][0],p[u])),l++,h=0):l>1&&a[l-1][d+1]&&o(c,a[l-1][d+1])?(d++,a[l].push(s(a[l][h],a[l-1][d],p[u])),h++):(h++,a[l].push(c));r.chart.stages=a,r.chart.rawPositions=[].concat.apply([],a),r.resizeRadius(),f=r.chart.rawPositions}return f},e.prototype.positionBubble=function(t,r,o){var s=Math.sqrt,a=Math.asin,l=Math.acos,h=Math.pow,d=Math.abs,c=s(h(t[0]-r[0],2)+h(t[1]-r[1],2)),p=l((h(c,2)+h(o[2]+r[2],2)-h(o[2]+t[2],2))/(2*(o[2]+r[2])*c)),f=a(d(t[0]-r[0])/c),u=t[1]-r[1]<0?0:Math.PI,g=(t[0]-r[0])*(t[1]-r[1])<0?1:-1,m=u+p+f*g,y=Math.cos(m),v=Math.sin(m),x=r[0]+(r[2]+o[2])*v,b=r[1]-(r[2]+o[2])*y;return[x,b,o[2],o[3],o[4]]},e.prototype.render=function(){var t=this,r=[];Series$9.prototype.render.apply(this,arguments),t.options.dataLabels.allowOverlap||(t.data.forEach(function(o){isArray$4(o.dataLabels)&&o.dataLabels.forEach(function(s){r.push(s)})}),t.options.useSimulation&&t.chart.hideOverlappingLabels(r))},e.prototype.resizeRadius=function(){var t=this.chart,r=t.rawPositions,o=Math.min,s=Math.max,a=t.plotLeft,l=t.plotTop,h=t.plotHeight,d=t.plotWidth,c,p,f,u,g,m,y,v,x;for(c=f=Number.POSITIVE_INFINITY,p=u=Number.NEGATIVE_INFINITY,x=0;x<r.length;x++)g=r[x][2],c=o(c,r[x][0]-g),p=s(p,r[x][0]+g),f=o(f,r[x][1]-g),u=s(u,r[x][1]+g);if(m=[p-c,u-f],y=[(d-a)/m[0],(h-l)/m[1]],v=o.apply([],y),Math.abs(v-1)>1e-10){for(x=0;x<r.length;x++)r[x][2]*=v;this.placeBubbles(r)}else t.diffY=h/2+l-f-(u-f)/2,t.diffX=d/2+a-c-(p-c)/2},e.prototype.seriesBox=function(){var t=this,r=t.chart,o=t.data,s=Math.max,a=Math.min,l,h=[r.plotLeft,r.plotLeft+r.plotWidth,r.plotTop,r.plotTop+r.plotHeight];return o.forEach(function(d){defined$d(d.plotX)&&defined$d(d.plotY)&&d.marker.radius&&(l=d.marker.radius,h[0]=a(h[0],d.plotX-l),h[1]=s(h[1],d.plotX+l),h[2]=a(h[2],d.plotY-l),h[3]=s(h[3],d.plotY+l))}),isNumber$d(h.width/h.height)?h:null},e.prototype.setVisible=function(){var t=this;Series$9.prototype.setVisible.apply(t,arguments),t.parentNodeLayout&&t.graph?t.visible?(t.graph.show(),t.parentNode.dataLabel&&t.parentNode.dataLabel.show()):(t.graph.hide(),t.parentNodeLayout.removeElementFromCollection(t.parentNode,t.parentNodeLayout.nodes),t.parentNode.dataLabel&&t.parentNode.dataLabel.hide()):t.layout&&(t.visible?t.layout.addElementsToCollection(t.points,t.layout.nodes):t.points.forEach(function(r){t.layout.removeElementFromCollection(r,t.layout.nodes)}))},e.prototype.translate=function(){var t=this,r=t.chart,o=t.data,s=t.index,a,l,h,d,c=t.options.useSimulation;for(t.processedXData=t.xData,t.generatePoints(),defined$d(r.allDataPoints)||(r.allDataPoints=t.accumulateAllPoints(t),t.getPointRadius()),c?h=r.allDataPoints:(h=t.placeBubbles(r.allDataPoints),t.options.draggable=!1),d=0;d<h.length;d++)h[d][3]===s&&(a=o[h[d][4]],l=pick$w(h[d][2],void 0),c||(a.plotX=h[d][0]-r.plotLeft+r.diffX,a.plotY=h[d][1]-r.plotTop+r.diffY),isNumber$d(l)&&(a.marker=extend$u(a.marker,{radius:l,width:2*l,height:2*l}),a.radius=l));c&&t.deferLayout(),fireEvent$6(t,"afterTranslate")},e.defaultOptions=merge$s(BubbleSeries.defaultOptions,{minSize:"10%",maxSize:"50%",sizeBy:"area",zoneAxis:"y",crisp:!1,tooltip:{pointFormat:"Value: {point.value}"},draggable:!0,useSimulation:!0,parentNode:{allowPointSelect:!1},dataLabels:{formatter:function(){var t=this.series.chart.numberFormatter,r=this.point.value;return isNumber$d(r)?t(r,-1):""},parentNodeFormatter:function(){return this.name},parentNodeTextPath:{enabled:!0},padding:0,style:{transition:"opacity 2000ms"}},layoutAlgorithm:{initialPositions:"circle",initialPositionRadius:20,bubblePadding:5,parentNodeLimit:!1,seriesInteraction:!0,dragBetweenSeries:!1,parentNodeOptions:{maxIterations:400,gravitationalConstant:.03,maxSpeed:50,initialPositionRadius:100,seriesInteraction:!0,marker:{fillColor:null,fillOpacity:1,lineWidth:1,lineColor:null,symbol:"circle"}},enableSimulation:!0,type:"packedbubble",integration:"packedbubble",maxIterations:1e3,splitSeries:!1,maxSpeed:5,gravitationalConstant:.01,friction:-.981}}),e}(BubbleSeries);extend$u(PackedBubbleSeries.prototype,{alignDataLabel:Series$9.prototype.alignDataLabel,axisTypes:[],directTouch:!0,forces:["barycenter","repulsive"],hasDraggableNodes:!0,isCartesian:!1,noSharedTooltip:!0,onMouseDown:dragNodesMixin.onMouseDown,onMouseMove:dragNodesMixin.onMouseMove,pointArrayMap:["value"],pointClass:PackedBubblePoint,pointValKey:"value",redrawHalo:dragNodesMixin.redrawHalo,requireSorting:!1,searchPoint:H.noop,trackerGroups:["group","dataLabelsGroup","parentNodesGroup"]});SeriesRegistry$1.registerSeriesType("packedbubble",PackedBubbleSeries);var __extends$r=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),noop$5=H.noop,Series$8=SeriesRegistry$1.series,_a$8=SeriesRegistry$1.seriesTypes,AreaSeries=_a$8.area,LineSeries$2=_a$8.line,ScatterSeries$2=_a$8.scatter,extend$t=Utilities.extend,merge$r=Utilities.merge,PolygonSeries=function(n){__extends$r(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.getGraphPath=function(){for(var t=LineSeries$2.prototype.getGraphPath.call(this),r=t.length+1;r--;)(r===t.length||t[r][0]==="M")&&r>0&&t.splice(r,0,["Z"]);return this.areaPath=t,t},e.prototype.drawGraph=function(){this.options.fillColor=this.color,AreaSeries.prototype.drawGraph.call(this)},e.defaultOptions=merge$r(ScatterSeries$2.defaultOptions,{marker:{enabled:!1,states:{hover:{enabled:!1}}},stickyTracking:!1,tooltip:{followPointer:!0,pointFormat:""},trackByArea:!0}),e}(ScatterSeries$2);extend$t(PolygonSeries.prototype,{type:"polygon",drawLegendSymbol:LegendSymbol$1.drawRectangle,drawTracker:Series$8.prototype.drawTracker,setStackedPoints:noop$5});SeriesRegistry$1.registerSeriesType("polygon",PolygonSeries);var addEvent$j=Utilities.addEvent,objectEach$8=Utilities.objectEach,WaterfallAxis;(function(n){var e=function(){function l(h){this.axis=h,this.stacks={changed:!1}}return l.prototype.renderStackTotals=function(){var h=this.axis,d=h.waterfall.stacks,c=h.stacking&&h.stacking.stackTotalGroup,p=new StackItem$1(h,h.options.stackLabels,!1,0,void 0);this.dummyStackItem=p,objectEach$8(d,function(f){objectEach$8(f,function(u){p.total=u.stackTotal,u.label&&(p.label=u.label),StackItem$1.prototype.render.call(p,c),u.label=p.label,delete p.label})}),p.total=null},l}();n.Composition=e;function t(l,h){addEvent$j(l,"init",a),addEvent$j(l,"afterBuildStacks",r),addEvent$j(l,"afterRender",o),addEvent$j(h,"beforeRedraw",s)}n.compose=t;function r(){var l=this,h=l.waterfall.stacks;h&&(h.changed=!1,delete h.alreadyChanged)}function o(){var l=this,h=l.options.stackLabels;h&&h.enabled&&l.waterfall.stacks&&l.waterfall.renderStackTotals()}function s(){for(var l=this.axes,h=this.series,d=h.length;d--;)h[d].options.stacking&&(l.forEach(function(c){c.isXAxis||(c.waterfall.stacks.changed=!0)}),d=0)}function a(){var l=this;l.waterfall||(l.waterfall=new e(l))}})(WaterfallAxis||(WaterfallAxis={}));const WaterfallAxis$1=WaterfallAxis;var __extends$q=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),isNumber$c=Utilities.isNumber,WaterfallPoint=function(n){__extends$q(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return e.prototype.getClassName=function(){var t=Point$2.prototype.getClassName.call(this);return this.isSum?t+=" highcharts-sum":this.isIntermediateSum&&(t+=" highcharts-intermediate-sum"),t},e.prototype.isValid=function(){return isNumber$c(this.y)||this.isSum||!!this.isIntermediateSum},e}(ColumnSeries$h.prototype.pointClass),__extends$p=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),_a$7=SeriesRegistry$1.seriesTypes,ColumnSeries$8=_a$7.column,LineSeries$1=_a$7.line,arrayMax$1=Utilities.arrayMax,arrayMin$1=Utilities.arrayMin,correctFloat$2=Utilities.correctFloat,extend$s=Utilities.extend,isNumber$b=Utilities.isNumber,merge$q=Utilities.merge,objectEach$7=Utilities.objectEach,pick$v=Utilities.pick;function ownProp(n,e){return Object.hasOwnProperty.call(n,e)}var WaterfallSeries=function(n){__extends$p(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.chart=void 0,t.data=void 0,t.options=void 0,t.points=void 0,t.stackedYNeg=void 0,t.stackedYPos=void 0,t.stackKey=void 0,t.xData=void 0,t.yAxis=void 0,t.yData=void 0,t}return e.prototype.generatePoints=function(){var t,r,o,s;for(ColumnSeries$8.prototype.generatePoints.apply(this),o=0,r=this.points.length;o<r;o++)t=this.points[o],s=this.processedYData[o],(t.isIntermediateSum||t.isSum)&&(t.y=correctFloat$2(s))},e.prototype.translate=function(){var t=this,r=t.options,o=t.yAxis,s,a=pick$v(r.minPointLength,5),l=a/2,h=r.threshold||0,d=h,c=h,p=r.stacking,f=o.waterfall.stacks[t.stackKey],u,g,m;ColumnSeries$8.prototype.translate.apply(t);for(var y=t.points,v=0;v<y.length;v++){var x=y[v],b=t.processedYData[v],$=x.shapeArgs;if(!(!$||!isNumber$b(b))){var S=[0,b],k=x.y;if(p){if(f){var A=f[v];p==="overlap"?(u=A.stackState[A.stateIndex--],s=k>=0?u:u-k,ownProp(A,"absolutePos")&&delete A.absolutePos,ownProp(A,"absoluteNeg")&&delete A.absoluteNeg):(k>=0?(u=A.threshold+A.posTotal,A.posTotal-=k,s=u):(u=A.threshold+A.negTotal,A.negTotal-=k,s=u-k),A.posTotal||ownProp(A,"absolutePos")&&(A.posTotal=A.absolutePos,delete A.absolutePos),A.negTotal||ownProp(A,"absoluteNeg")&&(A.negTotal=A.absoluteNeg,delete A.absoluteNeg)),x.isSum||(A.connectorThreshold=A.threshold+A.stackTotal),o.reversed?(g=k>=0?s-k:s+k,m=s):(g=s,m=s-k),x.below=g<=h,$.y=o.translate(g,!1,!0,!1,!0)||0,$.height=Math.abs($.y-(o.translate(m,!1,!0,!1,!0)||0));var M=o.waterfall.dummyStackItem;M&&(M.x=v,M.label=f[v].label,M.setOffset(t.pointXOffset||0,t.barW||0,t.stackedYNeg[v],t.stackedYPos[v]))}}else s=Math.max(d,d+k)+S[0],$.y=o.translate(s,!1,!0,!1,!0)||0,x.isSum?($.y=o.translate(S[1],!1,!0,!1,!0)||0,$.height=Math.min(o.translate(S[0],!1,!0,!1,!0)||0,o.len)-$.y,x.below=S[1]<=h):x.isIntermediateSum?(k>=0?(g=S[1]+c,m=c):(g=c,m=S[1]+c),o.reversed&&(g^=m,m^=g,g^=m),$.y=o.translate(g,!1,!0,!1,!0)||0,$.height=Math.abs($.y-Math.min(o.translate(m,!1,!0,!1,!0)||0,o.len)),c+=S[1],x.below=g<=h):($.height=b>0?(o.translate(d,!1,!0,!1,!0)||0)-$.y:(o.translate(d,!1,!0,!1,!0)||0)-(o.translate(d-b,!1,!0,!1,!0)||0),d+=b,x.below=d<h),$.height<0&&($.y+=$.height,$.height*=-1);x.plotY=$.y=Math.round($.y||0)-t.borderWidth%2/2,$.height=Math.max(Math.round($.height||0),.001),x.yBottom=$.y+$.height,$.height<=a&&!x.isNull?($.height=a,$.y-=l,x.plotY=$.y,x.y<0?x.minPointLengthOffset=-l:x.minPointLengthOffset=l):(x.isNull&&($.width=0),x.minPointLengthOffset=0);var P=x.plotY+(x.negative?$.height:0);x.below&&(x.plotY+=$.height),x.tooltipPos&&(t.chart.inverted?x.tooltipPos[0]=o.len-P:x.tooltipPos[1]=P)}}},e.prototype.processData=function(t){var r=this,o=r.options,s=r.yData,a=o.data,l,h=s.length,d=o.threshold||0,c,p,f,u,g,m;for(p=c=f=u=0,m=0;m<h;m++)g=s[m],l=a&&a[m]?a[m]:{},g==="sum"||l.isSum?s[m]=correctFloat$2(p):g==="intermediateSum"||l.isIntermediateSum?(s[m]=correctFloat$2(c),c=0):(p+=g,c+=g),f=Math.min(p,f),u=Math.max(p,u);n.prototype.processData.call(this,t),o.stacking||(r.dataMin=f+d,r.dataMax=u)},e.prototype.toYData=function(t){return t.isSum?"sum":t.isIntermediateSum?"intermediateSum":t.y},e.prototype.updateParallelArrays=function(t,r){n.prototype.updateParallelArrays.call(this,t,r),(this.yData[0]==="sum"||this.yData[0]==="intermediateSum")&&(this.yData[0]=null)},e.prototype.pointAttribs=function(t,r){var o=this.options.upColor,s;return o&&!t.options.color&&(t.color=t.y>0?o:null),s=ColumnSeries$8.prototype.pointAttribs.call(this,t,r),delete s.dashstyle,s},e.prototype.getGraphPath=function(){return[["M",0,0]]},e.prototype.getCrispPath=function(){var t=this.data,r=this.yAxis,o=t.length,s=Math.round(this.graph.strokeWidth())%2/2,a=Math.round(this.borderWidth)%2/2,l=this.xAxis.reversed,h=this.yAxis.reversed,d=this.options.stacking,c=[],p,f,u,g,m,y,v,x,b;for(b=1;b<o;b++)if(x=t[b].shapeArgs,g=t[b-1],v=t[b-1].shapeArgs,f=r.waterfall.stacks[this.stackKey],y=g.y>0?-v.height:0,f&&v&&x&&(u=f[b-1],d?(p=u.connectorThreshold,m=Math.round(r.translate(p,0,1,0,1)+(h?y:0))-s):m=v.y+g.minPointLengthOffset+a-s,c.push(["M",(v.x||0)+(l?0:v.width||0),m],["L",(x.x||0)+(l&&x.width||0),m])),v&&c.length&&(!d&&g.y<0&&!h||g.y>0&&h)){var $=c[c.length-2];$&&typeof $[2]=="number"&&($[2]+=v.height||0);var S=c[c.length-1];S&&typeof S[2]=="number"&&(S[2]+=v.height||0)}return c},e.prototype.drawGraph=function(){LineSeries$1.prototype.drawGraph.call(this),this.graph.attr({d:this.getCrispPath()})},e.prototype.setStackedPoints=function(){var t=this,r=t.options,o=t.yAxis.waterfall.stacks,s=r.threshold,a=s||0,l=a,h=t.stackKey,d=t.xData,c=d.length,p,f,u,g,m,y,v,x,b,$,S,k,A;function M(E,T,O,C){if(!y)f.stackState[0]=E,y=f.stackState.length;else for(O;O<y;O++)f.stackState[O]+=C;f.stackState.push(f.stackState[y-1]+T)}if(t.yAxis.stacking.usePercentage=!1,u=g=m=a,t.visible||!t.chart.options.chart.ignoreHiddenSeries){A=o.changed,k=o.alreadyChanged,k&&k.indexOf(h)<0&&(A=!0),o[h]||(o[h]={}),p=o[h];for(var P=0;P<c;P++)S=d[P],(!p[S]||A)&&(p[S]={negTotal:0,posTotal:0,stackTotal:0,threshold:0,stateIndex:0,stackState:[],label:A&&p[S]?p[S].label:void 0}),f=p[S],$=t.yData[P],$>=0?f.posTotal+=$:f.negTotal+=$,b=r.data[P],v=f.absolutePos=f.posTotal,x=f.absoluteNeg=f.negTotal,f.stackTotal=v+x,y=f.stackState.length,b&&b.isIntermediateSum?(M(m,g,0,m),m=g,g=s,a^=l,l^=a,a^=l):b&&b.isSum?(M(s,u,y),a=s):(M(a,$,0,u),b&&(u+=$,g+=$)),f.stateIndex++,f.threshold=a,a+=f.stackTotal;o.changed=!1,o.alreadyChanged||(o.alreadyChanged=[]),o.alreadyChanged.push(h)}},e.prototype.getExtremes=function(){var t=this.options.stacking,r,o,s,a;return t?(r=this.yAxis,o=r.waterfall.stacks,s=this.stackedYNeg=[],a=this.stackedYPos=[],t==="overlap"?objectEach$7(o[this.stackKey],function(l){s.push(arrayMin$1(l.stackState)),a.push(arrayMax$1(l.stackState))}):objectEach$7(o[this.stackKey],function(l){s.push(l.negTotal+l.threshold),a.push(l.posTotal+l.threshold)}),{dataMin:arrayMin$1(s),dataMax:arrayMax$1(a)}):{dataMin:this.dataMin,dataMax:this.dataMax}},e.defaultOptions=merge$q(ColumnSeries$8.defaultOptions,{dataLabels:{inside:!0},lineWidth:1,lineColor:palette.neutralColor80,dashStyle:"Dot",borderColor:palette.neutralColor80,states:{hover:{lineWidthPlus:0}}}),e}(ColumnSeries$8);extend$s(WaterfallSeries.prototype,{getZonesGraphs:LineSeries$1.prototype.getZonesGraphs,pointValKey:"y",showLine:!0,pointClass:WaterfallPoint});SeriesRegistry$1.registerSeriesType("waterfall",WaterfallSeries);WaterfallAxis$1.compose(Axis,Chart$1);var animObject$2=animationExports.animObject,seriesTypes$3=SeriesRegistry$1.seriesTypes,addEvent$i=Utilities.addEvent,defined$c=Utilities.defined,find$4=Utilities.find,isNumber$a=Utilities.isNumber,pick$u=Utilities.pick,splat$3=Utilities.splat,uniqueKey$1=Utilities.uniqueKey,wrap$6=Utilities.wrap,seriesProto=Series$e.prototype,pointerProto=Pointer.prototype,columnProto$2,arearangeProto;seriesProto.searchPointByAngle=function(n){var e=this,t=e.chart,r=e.xAxis,o=r.pane.center,s=n.chartX-o[0]-t.plotLeft,a=n.chartY-o[1]-t.plotTop;return this.searchKDTree({clientX:180+Math.atan2(s,a)*(-180/Math.PI)})};seriesProto.getConnectors=function(n,e,t,r){var o,s,a,l,h,d,c,p,f,u,g,m,y=1.5,v=y+1,x,b,$,S,k,A,M,P,E,T=r?1:0;return e>=0&&e<=n.length-1?o=e:e<0?o=n.length-1+e:o=0,s=o-1<0?n.length-(1+T):o-1,a=o+1>n.length-1?T:o+1,l=n[s],h=n[a],d=l.plotX,c=l.plotY,p=h.plotX,f=h.plotY,u=n[o].plotX,g=n[o].plotY,x=(y*u+d)/v,b=(y*g+c)/v,$=(y*u+p)/v,S=(y*g+f)/v,k=Math.sqrt(Math.pow(x-u,2)+Math.pow(b-g,2)),A=Math.sqrt(Math.pow($-u,2)+Math.pow(S-g,2)),M=Math.atan2(b-g,x-u),P=Math.atan2(S-g,$-u),E=Math.PI/2+(M+P)/2,Math.abs(M-E)>Math.PI/2&&(E-=Math.PI),x=u+Math.cos(E)*k,b=g+Math.sin(E)*k,$=u+Math.cos(Math.PI+E)*A,S=g+Math.sin(Math.PI+E)*A,m={rightContX:$,rightContY:S,leftContX:x,leftContY:b,plotX:u,plotY:g},t&&(m.prevPointCont=this.getConnectors(n,s,!1,r)),m};seriesProto.toXY=function(n){var e=this.chart,t=this.xAxis,r=this.yAxis,o=n.plotX,s=n.plotY,a=n.series,l=e.inverted,h=n.y,d=l?o:r.len-s,c;if(l&&a&&!a.isRadialBar&&(n.plotY=s=typeof h=="number"&&r.translate(h)||0),n.rectPlotX=o,n.rectPlotY=s,r.center&&(d+=r.center[3]/2),isNumber$a(s)){var p=l?r.postTranslate(s,d):t.postTranslate(o,d);n.plotX=n.polarPlotX=p.x-e.plotLeft,n.plotY=n.polarPlotY=p.y-e.plotTop}this.kdByAngle?(c=(o/Math.PI*180+t.pane.options.startAngle)%360,c<0&&(c+=360),n.clientX=c):n.clientX=n.plotX};seriesTypes$3.spline&&(wrap$6(seriesTypes$3.spline.prototype,"getPointSpline",function(n,e,t,r){var o,s;if(this.chart.polar)if(!r)o=["M",t.plotX,t.plotY];else{s=this.getConnectors(e,r,!0,this.connectEnds);var a=s.prevPointCont&&s.prevPointCont.rightContX,l=s.prevPointCont&&s.prevPointCont.rightContY;o=["C",isNumber$a(a)?a:s.plotX,isNumber$a(l)?l:s.plotY,isNumber$a(s.leftContX)?s.leftContX:s.plotX,isNumber$a(s.leftContY)?s.leftContY:s.plotY,s.plotX,s.plotY]}else o=n.call(this,e,t,r);return o}),seriesTypes$3.areasplinerange&&(seriesTypes$3.areasplinerange.prototype.getPointSpline=seriesTypes$3.spline.prototype.getPointSpline));addEvent$i(Series$e,"afterTranslate",function(){var n=this,e=n.chart;if(e.polar&&n.xAxis){if(n.kdByAngle=e.tooltip&&e.tooltip.shared,n.kdByAngle?n.searchPoint=n.searchPointByAngle:n.options.findNearestPointBy="xy",!n.preventPostTranslate)for(var t=n.points,r=t.length;r--;)n.toXY(t[r]),!e.hasParallelCoordinates&&!n.yAxis.reversed&&t[r].y<n.yAxis.min&&(t[r].isNull=!0);this.hasClipCircleSetter||(this.hasClipCircleSetter=!!n.eventsToUnbind.push(addEvent$i(n,"afterRender",function(){var o;e.polar&&(o=this.yAxis.pane.center,this.clipCircle?this.clipCircle.animate({x:o[0],y:o[1],r:o[2]/2,innerR:o[3]/2}):this.clipCircle=e.renderer.clipCircle(o[0],o[1],o[2]/2,o[3]/2),this.group.clip(this.clipCircle),this.setClip=H.noop)})))}},{order:2});wrap$6(seriesTypes$3.line.prototype,"getGraphPath",function(n,e){var t=this,r,o,s;if(this.chart.polar){for(e=e||this.points,r=0;r<e.length;r++)if(!e[r].isNull){o=r;break}this.options.connectEnds!==!1&&typeof o<"u"&&(this.connectEnds=!0,e.splice(e.length,0,e[o]),s=!0),e.forEach(function(l){typeof l.polarPlotY>"u"&&t.toXY(l)})}var a=n.apply(this,[].slice.call(arguments,1));return s&&e.pop(),a});var polarAnimate=function(n,e){var t=this,r=this.chart,o=this.options.animation,s=this.group,a=this.markerGroup,l=this.xAxis.center,h=r.plotLeft,d=r.plotTop,c,p,f,u,g,m;r.polar?t.isRadialBar?e||(t.startAngleRad=pick$u(t.translatedThreshold,t.xAxis.startAngleRad),H.seriesTypes.pie.prototype.animate.call(t,e)):r.renderer.isSVG&&(o=animObject$2(o),t.is("column")?e||(p=l[3]/2,t.points.forEach(function(y){f=y.graphic,u=y.shapeArgs,g=u&&u.r,m=u&&u.innerR,f&&u&&(f.attr({r:p,innerR:p}),f.animate({r:g,innerR:m},t.options.animation))})):e?(c={translateX:l[0]+h,translateY:l[1]+d,scaleX:.001,scaleY:.001},s.attr(c),a&&a.attr(c)):(c={translateX:h,translateY:d,scaleX:1,scaleY:1},s.animate(c,o),a&&a.animate(c,o))):n.call(this,e)};wrap$6(seriesProto,"animate",polarAnimate);seriesTypes$3.column&&(arearangeProto=seriesTypes$3.arearange.prototype,columnProto$2=seriesTypes$3.column.prototype,columnProto$2.polarArc=function(n,e,t,r){var o=this.xAxis.center,s=this.yAxis.len,a=o[3]/2,l=s-e+a,h=s-pick$u(n,s)+a;return this.yAxis.reversed&&(l<0&&(l=a),h<0&&(h=a)),{x:o[0],y:o[1],r:l,innerR:h,start:t,end:r}},wrap$6(columnProto$2,"animate",polarAnimate),wrap$6(columnProto$2,"translate",function(n){var e=this,t=e.options,r=t.threshold,o=t.stacking,s=e.chart,a=e.xAxis,l=e.yAxis,h=l.reversed,d=l.center,c=a.startAngleRad,p=a.endAngleRad,f=p-c,u,g,m,y,v,x,b,$,S,k,A,M,P,E,T,O;if(e.preventPostTranslate=!0,n.call(e),a.isRadial)for(g=e.points,y=g.length,v=l.translate(l.min),x=l.translate(l.max),r=t.threshold||0,s.inverted&&isNumber$a(r)&&(u=l.translate(r),defined$c(u)&&(u<0?u=0:u>f&&(u=f),e.translatedThreshold=u+c));y--;)m=g[y],E=m.barX,k=m.x,A=m.y,m.shapeType="arc",s.inverted?(m.plotY=l.translate(A),o&&l.stacking?(P=l.stacking.stacks[(A<0?"-":"")+e.stackKey],e.visible&&P&&P[k]&&(m.isNull||(M=P[k].points[e.getStackIndicator(void 0,k,e.index).key],b=l.translate(M[0]),$=l.translate(M[1]),defined$c(b)&&(b=Utilities.clamp(b,0,f))))):(b=u,$=m.plotY),b>$&&($=[b,b=$][0]),h?$>v?$=v:b<x?b=x:(b>v||$<x)&&(b=$=f):b<v?b=v:$>x?$=x:($<v||b>x)&&(b=$=0),l.min>l.max&&(b=$=h?f:0),b+=c,$+=c,d&&(m.barX=E+=d[3]/2),T=Math.max(E,0),O=Math.max(E+m.pointWidth,0),m.shapeArgs={x:d&&d[0],y:d&&d[1],r:O,innerR:T,start:b,end:$},m.opacity=b===$?0:void 0,m.plotY=(defined$c(e.translatedThreshold)&&(b<e.translatedThreshold?b:$))-c):(b=E+c,m.shapeArgs=e.polarArc(m.yBottom,m.plotY,b,b+m.pointWidth)),e.toXY(m),s.inverted?(S=l.postTranslate(m.rectPlotY,E+m.pointWidth/2),m.tooltipPos=[S.x-s.plotLeft,S.y-s.plotTop]):m.tooltipPos=[m.plotX,m.plotY],d&&(m.ttBelow=m.plotY>d[1])}),columnProto$2.findAlignments=function(n,e){var t,r;return e.align===null&&(n>20&&n<160?t="left":n>200&&n<340?t="right":t="center",e.align=t),e.verticalAlign===null&&(n<45||n>315?r="bottom":n>135&&n<225?r="top":r="middle",e.verticalAlign=r),e},arearangeProto&&(arearangeProto.findAlignments=columnProto$2.findAlignments),wrap$6(columnProto$2,"alignDataLabel",function(n,e,t,r,o,s){var a=this.chart,l=pick$u(r.inside,!!this.options.stacking),h,d,c;a.polar?(h=e.rectPlotX/Math.PI*180,a.inverted?(this.forceDL=a.isInsidePlot(e.plotX,Math.round(e.plotY)),l&&e.shapeArgs?(d=e.shapeArgs,c=this.yAxis.postTranslate(((d.start||0)+(d.end||0))/2-this.xAxis.startAngleRad,e.barX+e.pointWidth/2),o={x:c.x-a.plotLeft,y:c.y-a.plotTop}):e.tooltipPos&&(o={x:e.tooltipPos[0],y:e.tooltipPos[1]}),r.align=pick$u(r.align,"center"),r.verticalAlign=pick$u(r.verticalAlign,"middle")):this.findAlignments&&(r=this.findAlignments(h,r)),seriesProto.alignDataLabel.call(this,e,t,r,o,s),this.isRadialBar&&e.shapeArgs&&e.shapeArgs.start===e.shapeArgs.end&&t.hide(!0)):n.call(this,e,t,r,o,s)}));wrap$6(pointerProto,"getCoordinates",function(n,e){var t=this.chart,r={xAxis:[],yAxis:[]};return t.polar?t.axes.forEach(function(o){var s=o.isXAxis,a=o.center,l,h;o.coll!=="colorAxis"&&(l=e.chartX-a[0]-t.plotLeft,h=e.chartY-a[1]-t.plotTop,r[s?"xAxis":"yAxis"].push({axis:o,value:o.translate(s?Math.PI-Math.atan2(l,h):Math.sqrt(Math.pow(l,2)+Math.pow(h,2)),!0)}))}):r=n.call(this,e),r});SVGRenderer.prototype.clipCircle=function(n,e,t,r){var o,s=uniqueKey$1(),a=this.createElement("clipPath").attr({id:s}).add(this.defs);return o=r?this.arc(n,e,t,r,0,2*Math.PI).add(a):this.circle(n,e,t).add(a),o.id=s,o.clipPath=a,o};addEvent$i(Chart$1,"getAxes",function(){this.pane||(this.pane=[]),this.options.pane=splat$3(this.options.pane),this.options.pane.forEach(function(n){new Pane$1(n,this)},this)});addEvent$i(Chart$1,"afterDrawChartBox",function(){this.pane.forEach(function(n){n.render()})});addEvent$i(Series$e,"afterInit",function(){var n=this.chart;n.inverted&&n.polar&&(this.isRadialSeries=!0,this.is("column")&&(this.isRadialBar=!0))});wrap$6(Chart$1.prototype,"get",function(n,e){return find$4(this.pane||[],function(t){return t.options.id===e})||n.call(this,e)});/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/highcharts-more
 * @requires highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$4=H;RadialAxis$1.compose(G$4.Axis,G$4.Tick);BubbleSeries$2.compose(G$4.Chart,G$4.Legend,G$4.Series);var pick$t=Utilities.pick,deg2rad$3=H.deg2rad;function rotate3D(n,e,t,r){return{x:r.cosB*n-r.sinB*t,y:-r.sinA*r.sinB*n+r.cosA*e-r.cosB*r.sinA*t,z:r.cosA*r.sinB*n+r.sinA*e+r.cosA*r.cosB*t}}function perspective3D$1(n,e,t){var r=t>0&&t<Number.POSITIVE_INFINITY?t/(n.z+e.z+t):1;return{x:n.x*r,y:n.y*r}}H.perspective3D=perspective3D$1;function perspective$6(n,e,t,r){var o=e.options.chart.options3d,s=pick$t(r,t?e.inverted:!1),a={x:e.plotWidth/2,y:e.plotHeight/2,z:o.depth/2,vd:pick$t(o.depth,1)*pick$t(o.viewDistance,0)},l=e.scale3d||1,h=deg2rad$3*o.beta*(s?-1:1),d=deg2rad$3*o.alpha*(s?-1:1),c={cosA:Math.cos(d),cosB:Math.cos(-h),sinA:Math.sin(d),sinB:Math.sin(-h)};return t||(a.x+=e.plotLeft,a.y+=e.plotTop),n.map(function(p){var f=rotate3D((s?p.y:p.x)-a.x,(s?p.x:p.y)-a.y,(p.z||0)-a.z,c),u=perspective3D$1(f,a,a.vd);return u.x=u.x*l+a.x,u.y=u.y*l+a.y,u.z=f.z*l+a.z,{x:s?u.y:u.x,y:s?u.x:u.y,z:u.z}})}H.perspective=perspective$6;function pointCameraDistance$1(n,e){var t=e.options.chart.options3d,r={x:e.plotWidth/2,y:e.plotHeight/2,z:pick$t(t.depth,1)*pick$t(t.viewDistance,0)+t.depth},o=Math.sqrt(Math.pow(r.x-pick$t(n.plotX,n.x),2)+Math.pow(r.y-pick$t(n.plotY,n.y),2)+Math.pow(r.z-pick$t(n.plotZ,n.z),2));return o}H.pointCameraDistance=pointCameraDistance$1;function shapeArea$2(n){var e=0,t,r;for(t=0;t<n.length;t++)r=(t+1)%n.length,e+=n[t].x*n[r].y-n[r].x*n[t].y;return e/2}H.shapeArea=shapeArea$2;function shapeArea3D$1(n,e,t){return shapeArea$2(perspective$6(n,e,t))}H.shapeArea3d=shapeArea3D$1;var mathModule={perspective:perspective$6,perspective3D:perspective3D$1,pointCameraDistance:pointCameraDistance$1,shapeArea:shapeArea$2,shapeArea3D:shapeArea3D$1},color$7=Color.parse,defined$b=Utilities.defined,merge$p=Utilities.merge,objectEach$6=Utilities.objectEach,pick$s=Utilities.pick,SVGElement3D={};SVGElement3D.base={initArgs:function(n){var e=this,t=e.renderer,r=t[e.pathType+"Path"](n),o=r.zIndexes;e.parts.forEach(function(s){e[s]=t.path(r[s]).attr({class:"highcharts-3d-"+s,zIndex:o[s]||0}).add(e)}),e.attr({"stroke-linejoin":"round",zIndex:o.group}),e.originalDestroy=e.destroy,e.destroy=e.destroyParts,e.forcedSides=r.forcedSides},singleSetterForParts:function(n,e,t,r,o,s){var a=this,l={},h=[null,null,r||"attr",o,s],d=t&&t.zIndexes;return t?(d&&d.group&&this.attr({zIndex:d.group}),objectEach$6(t,function(c,p){l[p]={},l[p][n]=c,d&&(l[p].zIndex=t.zIndexes[p]||0)}),h[1]=l):(l[n]=e,h[0]=l),a.processParts.apply(a,h)},processParts:function(n,e,t,r,o){var s=this;return s.parts.forEach(function(a){e&&(n=pick$s(e[a],!1)),n!==!1&&s[a][t](n,r,o)}),s},destroyParts:function(){return this.processParts(null,null,"destroy"),this.originalDestroy()}};SVGElement3D.cuboid=merge$p(SVGElement3D.base,{parts:["front","top","side"],pathType:"cuboid",attr:function(n,e,t,r){if(typeof n=="string"&&typeof e<"u"){var o=n;n={},n[o]=e}return n.shapeArgs||defined$b(n.x)?this.singleSetterForParts("d",null,this.renderer[this.pathType+"Path"](n.shapeArgs||n)):SVGElement.prototype.attr.call(this,n,void 0,t,r)},animate:function(n,e,t){if(defined$b(n.x)&&defined$b(n.y)){var r=this.renderer[this.pathType+"Path"](n),o=r.forcedSides;this.singleSetterForParts("d",null,r,"animate",e,t),this.attr({zIndex:r.zIndexes.group}),o!==this.forcedSides&&(this.forcedSides=o,SVGElement3D.cuboid.fillSetter.call(this,this.fill))}else SVGElement.prototype.animate.call(this,n,e,t);return this},fillSetter:function(n){var e=this;return e.forcedSides=e.forcedSides||[],e.singleSetterForParts("fill",null,{front:n,top:color$7(n).brighten(e.forcedSides.indexOf("top")>=0?0:.1).get(),side:color$7(n).brighten(e.forcedSides.indexOf("side")>=0?0:-.1).get()}),e.color=e.fill=n,e}});var __extends$o=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),animObject$1=animationExports.animObject,color$6=Color.parse,charts=H.charts,deg2rad$2=H.deg2rad,perspective$5=mathModule.perspective,shapeArea$1=mathModule.shapeArea,defined$a=Utilities.defined,extend$r=Utilities.extend,merge$o=Utilities.merge,pick$r=Utilities.pick,cos=Math.cos,sin=Math.sin,PI=Math.PI,dFactor=4*(Math.sqrt(2)-1)/3/(PI/2),SVGRenderer3D=function(n){__extends$o(e,n);function e(){return n!==null&&n.apply(this,arguments)||this}return e.compose=function(t){var r=t.prototype,o=e.prototype;r.elements3d=SVGElement3D,r.arc3d=o.arc3d,r.arc3dPath=o.arc3dPath,r.cuboid=o.cuboid,r.cuboidPath=o.cuboidPath,r.element3d=o.element3d,r.face3d=o.face3d,r.polyhedron=o.polyhedron,r.toLinePath=o.toLinePath,r.toLineSegments=o.toLineSegments},e.curveTo=function(t,r,o,s,a,l,h,d){var c=[],p=l-a;return l>a&&l-a>Math.PI/2+1e-4?(c=c.concat(this.curveTo(t,r,o,s,a,a+Math.PI/2,h,d)),c=c.concat(this.curveTo(t,r,o,s,a+Math.PI/2,l,h,d)),c):l<a&&a-l>Math.PI/2+1e-4?(c=c.concat(this.curveTo(t,r,o,s,a,a-Math.PI/2,h,d)),c=c.concat(this.curveTo(t,r,o,s,a-Math.PI/2,l,h,d)),c):[["C",t+o*Math.cos(a)-o*dFactor*p*Math.sin(a)+h,r+s*Math.sin(a)+s*dFactor*p*Math.cos(a)+d,t+o*Math.cos(l)+o*dFactor*p*Math.sin(l)+h,r+s*Math.sin(l)-s*dFactor*p*Math.cos(l)+d,t+o*Math.cos(l)+h,r+s*Math.sin(l)+d]]},e.prototype.toLinePath=function(t,r){var o=[];return t.forEach(function(s){o.push(["L",s.x,s.y])}),t.length&&(o[0][0]="M",r&&o.push(["Z"])),o},e.prototype.toLineSegments=function(t){var r=[],o=!0;return t.forEach(function(s){r.push(o?["M",s.x,s.y]:["L",s.x,s.y]),o=!o}),r},e.prototype.face3d=function(t){var r=this,o=this.createElement("path");return o.vertexes=[],o.insidePlotArea=!1,o.enabled=!0,o.attr=function(s){if(typeof s=="object"&&(defined$a(s.enabled)||defined$a(s.vertexes)||defined$a(s.insidePlotArea))){this.enabled=pick$r(s.enabled,this.enabled),this.vertexes=pick$r(s.vertexes,this.vertexes),this.insidePlotArea=pick$r(s.insidePlotArea,this.insidePlotArea),delete s.enabled,delete s.vertexes,delete s.insidePlotArea;var a=charts[r.chartIndex],l=perspective$5(this.vertexes,a,this.insidePlotArea),h=r.toLinePath(l,!0),d=shapeArea$1(l);s.d=h,s.visibility=this.enabled&&d>0?"visible":"hidden"}return SVGElement.prototype.attr.apply(this,arguments)},o.animate=function(s){if(typeof s=="object"&&(defined$a(s.enabled)||defined$a(s.vertexes)||defined$a(s.insidePlotArea))){this.enabled=pick$r(s.enabled,this.enabled),this.vertexes=pick$r(s.vertexes,this.vertexes),this.insidePlotArea=pick$r(s.insidePlotArea,this.insidePlotArea),delete s.enabled,delete s.vertexes,delete s.insidePlotArea;var a=charts[r.chartIndex],l=perspective$5(this.vertexes,a,this.insidePlotArea),h=r.toLinePath(l,!0),d=shapeArea$1(l),c=this.enabled&&d>0?"visible":"hidden";s.d=h,this.attr("visibility",c)}return SVGElement.prototype.animate.apply(this,arguments)},o.attr(t)},e.prototype.polyhedron=function(t){var r=this,o=this.g(),s=o.destroy;return this.styledMode||o.attr({"stroke-linejoin":"round"}),o.faces=[],o.destroy=function(){for(var a=0;a<o.faces.length;a++)o.faces[a].destroy();return s.call(this)},o.attr=function(a,l,h,d){if(typeof a=="object"&&defined$a(a.faces)){for(;o.faces.length>a.faces.length;)o.faces.pop().destroy();for(;o.faces.length<a.faces.length;)o.faces.push(r.face3d().add(o));for(var c=0;c<a.faces.length;c++)r.styledMode&&delete a.faces[c].fill,o.faces[c].attr(a.faces[c],null,h,d);delete a.faces}return SVGElement.prototype.attr.apply(this,arguments)},o.animate=function(a,l,h){if(a&&a.faces){for(;o.faces.length>a.faces.length;)o.faces.pop().destroy();for(;o.faces.length<a.faces.length;)o.faces.push(r.face3d().add(o));for(var d=0;d<a.faces.length;d++)o.faces[d].animate(a.faces[d],l,h);delete a.faces}return SVGElement.prototype.animate.apply(this,arguments)},o.attr(t)},e.prototype.element3d=function(t,r){var o=this.g();return extend$r(o,this.elements3d[t]),o.initArgs(r),o},e.prototype.cuboid=function(t){return this.element3d("cuboid",t)},e.prototype.cuboidPath=function(t){var r=t.x||0,o=t.y||0,s=t.z||0,a=t.height||0,l=t.width||0,h=t.depth||0,d=charts[this.chartIndex],c,p,f,u,g,m,y,v,x,b,$,S,k,A=d.options.chart.options3d,M=A.alpha,P=1e6,E=10,T=100,O=0,C=[{x:r,y:o,z:s},{x:r+l,y:o,z:s},{x:r+l,y:o+a,z:s},{x:r,y:o+a,z:s},{x:r,y:o+a,z:s+h},{x:r+l,y:o+a,z:s+h},{x:r+l,y:o,z:s+h},{x:r,y:o,z:s+h}],I=[],L;C=perspective$5(C,d,t.insidePlotArea);function D(B){return a===0&&B>1&&B<6?{x:C[B].x,y:C[B].y+10,z:C[B].z}:C[0].x===C[7].x&&B>=4?{x:C[B].x+10,y:C[B].y,z:C[B].z}:h===0&&B<2||B>5?{x:C[B].x,y:C[B].y,z:C[B].z+10}:C[B]}function N(B){return C[B]}return L=function(B,X,W){var F=[[],-1],U=B.map(N),z=X.map(N),V=B.map(D),j=X.map(D);return shapeArea$1(U)<0?F=[U,0]:shapeArea$1(z)<0?F=[z,1]:W&&(I.push(W),shapeArea$1(V)<0?F=[U,0]:shapeArea$1(j)<0?F=[z,1]:F=[U,0]),F},c=[3,2,1,0],p=[7,6,5,4],y=L(c,p,"front"),v=y[0],$=y[1],f=[1,6,7,0],u=[4,5,2,3],y=L(f,u,"top"),x=y[0],S=y[1],m=[1,2,5,6],g=[0,7,4,3],y=L(m,g,"side"),b=y[0],k=y[1],k===1?O+=P*(d.plotWidth-r):k||(O+=P*r),O+=E*(!S||M>=0&&M<=180||M<360&&M>357.5?d.plotHeight-o:10+o),$===1?O+=T*s:$||(O+=T*(1e3-s)),{front:this.toLinePath(v,!0),top:this.toLinePath(x,!0),side:this.toLinePath(b,!0),zIndexes:{group:Math.round(O)},forcedSides:I,isFront:$,isTop:S}},e.prototype.arc3d=function(t){var r=this.g(),o=r.renderer,s=["x","y","r","innerR","start","end","depth"];function a(l){var h=!1,d={},c;l=merge$o(l);for(c in l)s.indexOf(c)!==-1&&(d[c]=l[c],delete l[c],h=!0);return h?[d,l]:!1}return t=merge$o(t),t.alpha=(t.alpha||0)*deg2rad$2,t.beta=(t.beta||0)*deg2rad$2,r.top=o.path(),r.side1=o.path(),r.side2=o.path(),r.inn=o.path(),r.out=o.path(),r.onAdd=function(){var l=r.parentGroup,h=r.attr("class");r.top.add(r),["out","inn","side1","side2"].forEach(function(d){r[d].attr({class:h+" highcharts-3d-side"}).add(l)})},["addClass","removeClass"].forEach(function(l){r[l]=function(){var h=arguments;["top","out","inn","side1","side2"].forEach(function(d){r[d][l].apply(r[d],h)})}}),r.setPaths=function(l){var h=r.renderer.arc3dPath(l),d=h.zTop*100;r.attribs=l,r.top.attr({d:h.top,zIndex:h.zTop}),r.inn.attr({d:h.inn,zIndex:h.zInn}),r.out.attr({d:h.out,zIndex:h.zOut}),r.side1.attr({d:h.side1,zIndex:h.zSide1}),r.side2.attr({d:h.side2,zIndex:h.zSide2}),r.zIndex=d,r.attr({zIndex:d}),l.center&&(r.top.setRadialReference(l.center),delete l.center)},r.setPaths(t),r.fillSetter=function(l){var h=color$6(l).brighten(-.1).get();return this.fill=l,this.side1.attr({fill:h}),this.side2.attr({fill:h}),this.inn.attr({fill:h}),this.out.attr({fill:h}),this.top.attr({fill:l}),this},["opacity","translateX","translateY","visibility"].forEach(function(l){r[l+"Setter"]=function(h,d){r[d]=h,["out","inn","side1","side2","top"].forEach(function(c){r[c].attr(d,h)})}}),r.attr=function(l){var h,d;return typeof l=="object"&&(d=a(l),d&&(h=d[0],arguments[0]=d[1],extend$r(r.attribs,h),r.setPaths(r.attribs))),SVGElement.prototype.attr.apply(r,arguments)},r.animate=function(l,h,d){var c,p=this.attribs,f,u,g="data-"+Math.random().toString(26).substring(2,9);return delete l.center,delete l.z,delete l.alpha,delete l.beta,u=animObject$1(pick$r(h,this.renderer.globalAnimation)),u.duration&&(c=a(l),r[g]=0,l[g]=1,r[g+"Setter"]=H.noop,c&&(f=c[0],u.step=function(m,y){function v(x){return p[x]+(pick$r(f[x],p[x])-p[x])*y.pos}y.prop===g&&y.elem.setPaths(merge$o(p,{x:v("x"),y:v("y"),r:v("r"),innerR:v("innerR"),start:v("start"),end:v("end"),depth:v("depth")}))}),h=u),SVGElement.prototype.animate.call(this,l,h,d)},r.destroy=function(){return this.top.destroy(),this.out.destroy(),this.inn.destroy(),this.side1.destroy(),this.side2.destroy(),SVGElement.prototype.destroy.call(this)},r.hide=function(){this.top.hide(),this.out.hide(),this.inn.hide(),this.side1.hide(),this.side2.hide()},r.show=function(l){this.top.show(l),this.out.show(l),this.inn.show(l),this.side1.show(l),this.side2.show(l)},r},e.prototype.arc3dPath=function(t){var r=t.x||0,o=t.y||0,s=t.start||0,a=(t.end||0)-1e-5,l=t.r||0,h=t.innerR||0,d=t.depth||0,c=t.alpha||0,p=t.beta||0,f=Math.cos(s),u=Math.sin(s),g=Math.cos(a),m=Math.sin(a),y=l*Math.cos(p),v=l*Math.cos(c),x=h*Math.cos(p),b=h*Math.cos(c),$=d*Math.sin(p),S=d*Math.sin(c),k=[["M",r+y*f,o+v*u]];k=k.concat(e.curveTo(r,o,y,v,s,a,0,0)),k.push(["L",r+x*g,o+b*m]),k=k.concat(e.curveTo(r,o,x,b,a,s,0,0)),k.push(["Z"]);var A=p>0?Math.PI/2:0,M=c>0?0:Math.PI/2,P=s>-A?s:a>-A?-A:s,E=a<PI-M?a:s<PI-M?PI-M:a,T=2*PI-M,O=[["M",r+y*cos(P),o+v*sin(P)]];O=O.concat(e.curveTo(r,o,y,v,P,E,0,0)),a>T&&s<T?(O.push(["L",r+y*cos(E)+$,o+v*sin(E)+S]),O=O.concat(e.curveTo(r,o,y,v,E,T,$,S)),O.push(["L",r+y*cos(T),o+v*sin(T)]),O=O.concat(e.curveTo(r,o,y,v,T,a,0,0)),O.push(["L",r+y*cos(a)+$,o+v*sin(a)+S]),O=O.concat(e.curveTo(r,o,y,v,a,T,$,S)),O.push(["L",r+y*cos(T),o+v*sin(T)]),O=O.concat(e.curveTo(r,o,y,v,T,E,0,0))):a>PI-M&&s<PI-M&&(O.push(["L",r+y*Math.cos(E)+$,o+v*Math.sin(E)+S]),O=O.concat(e.curveTo(r,o,y,v,E,a,$,S)),O.push(["L",r+y*Math.cos(a),o+v*Math.sin(a)]),O=O.concat(e.curveTo(r,o,y,v,a,E,0,0))),O.push(["L",r+y*Math.cos(E)+$,o+v*Math.sin(E)+S]),O=O.concat(e.curveTo(r,o,y,v,E,P,$,S)),O.push(["Z"]);var C=[["M",r+x*f,o+b*u]];C=C.concat(e.curveTo(r,o,x,b,s,a,0,0)),C.push(["L",r+x*Math.cos(a)+$,o+b*Math.sin(a)+S]),C=C.concat(e.curveTo(r,o,x,b,a,s,$,S)),C.push(["Z"]);var I=[["M",r+y*f,o+v*u],["L",r+y*f+$,o+v*u+S],["L",r+x*f+$,o+b*u+S],["L",r+x*f,o+b*u],["Z"]],L=[["M",r+y*g,o+v*m],["L",r+y*g+$,o+v*m+S],["L",r+x*g+$,o+b*m+S],["L",r+x*g,o+b*m],["Z"]],D=Math.atan2(S,-$),N=Math.abs(a+D),B=Math.abs(s+D),X=Math.abs((s+a)/2+D);function W(j){return j=j%(2*Math.PI),j>Math.PI&&(j=2*Math.PI-j),j}N=W(N),B=W(B),X=W(X);var F=1e5,U=X*F,z=B*F,V=N*F;return{top:k,zTop:Math.PI*F+1,out:O,zOut:Math.max(U,z,V),inn:C,zInn:Math.max(U,z,V),side1:I,zSide1:V*.99,side2:L,zSide2:z*.99}},e}(SVGRenderer),color$5=Color.parse,perspective$4=mathModule.perspective,shapeArea3D=mathModule.shapeArea3D,genericDefaultOptions=DefaultOptions.defaultOptions,addEvent$h=Utilities.addEvent,isArray$3=Utilities.isArray,merge$n=Utilities.merge,pick$q=Utilities.pick,wrap$5=Utilities.wrap,Chart3D;(function(n){var e=function(){function g(m){this.frame3d=void 0,this.chart=m}return g.prototype.get3dFrame=function(){var m=this.chart,y=m.options.chart.options3d,v=y.frame,x=m.plotLeft,b=m.plotLeft+m.plotWidth,$=m.plotTop,S=m.plotTop+m.plotHeight,k=0,A=y.depth,M=function(Y){var Z=shapeArea3D(Y,m);return Z>.5?1:Z<-.5?-1:0},P=M([{x,y:S,z:A},{x:b,y:S,z:A},{x:b,y:S,z:k},{x,y:S,z:k}]),E=M([{x,y:$,z:k},{x:b,y:$,z:k},{x:b,y:$,z:A},{x,y:$,z:A}]),T=M([{x,y:$,z:k},{x,y:$,z:A},{x,y:S,z:A},{x,y:S,z:k}]),O=M([{x:b,y:$,z:A},{x:b,y:$,z:k},{x:b,y:S,z:k},{x:b,y:S,z:A}]),C=M([{x,y:S,z:k},{x:b,y:S,z:k},{x:b,y:$,z:k},{x,y:$,z:k}]),I=M([{x,y:$,z:A},{x:b,y:$,z:A},{x:b,y:S,z:A},{x,y:S,z:A}]),L=!1,D=!0,N=!1,B=!1,X=!1,W=!1;[].concat(m.xAxis,m.yAxis,m.zAxis).forEach(function(Y){Y&&(Y.horiz?Y.opposite?B=!0:N=!0:Y.opposite?W=!0:X=!0)});var F=function(Y,Z,et){for(var Q=["size","color","visible"],tt={},rt=0;rt<Q.length;rt++)for(var it=Q[rt],ot=0;ot<Y.length;ot++)if(typeof Y[ot]=="object"){var st=Y[ot][it];if(typeof st<"u"&&st!==null){tt[it]=st;break}}var at=et;return tt.visible===!0||tt.visible===!1?at=tt.visible:tt.visible==="auto"&&(at=Z>0),{size:pick$q(tt.size,1),color:pick$q(tt.color,"none"),frontFacing:Z>0,visible:at}},U={axes:{},bottom:F([v.bottom,v.top,v],P,N),top:F([v.top,v.bottom,v],E,B),left:F([v.left,v.right,v.side,v],T,X),right:F([v.right,v.left,v.side,v],O,W),back:F([v.back,v.front,v],I,D),front:F([v.front,v.back,v],C,L)};if(y.axisLabelPosition==="auto"){var z=function(Y,Z){return Y.visible!==Z.visible||Y.visible&&Z.visible&&Y.frontFacing!==Z.frontFacing},V=[];z(U.left,U.front)&&V.push({y:($+S)/2,x,z:k,xDir:{x:1,y:0,z:0}}),z(U.left,U.back)&&V.push({y:($+S)/2,x,z:A,xDir:{x:0,y:0,z:-1}}),z(U.right,U.front)&&V.push({y:($+S)/2,x:b,z:k,xDir:{x:0,y:0,z:1}}),z(U.right,U.back)&&V.push({y:($+S)/2,x:b,z:A,xDir:{x:-1,y:0,z:0}});var j=[];z(U.bottom,U.front)&&j.push({x:(x+b)/2,y:S,z:k,xDir:{x:1,y:0,z:0}}),z(U.bottom,U.back)&&j.push({x:(x+b)/2,y:S,z:A,xDir:{x:-1,y:0,z:0}});var K=[];z(U.top,U.front)&&K.push({x:(x+b)/2,y:$,z:k,xDir:{x:1,y:0,z:0}}),z(U.top,U.back)&&K.push({x:(x+b)/2,y:$,z:A,xDir:{x:-1,y:0,z:0}});var nt=[];z(U.bottom,U.left)&&nt.push({z:(k+A)/2,y:S,x,xDir:{x:0,y:0,z:-1}}),z(U.bottom,U.right)&&nt.push({z:(k+A)/2,y:S,x:b,xDir:{x:0,y:0,z:1}});var q=[];z(U.top,U.left)&&q.push({z:(k+A)/2,y:$,x,xDir:{x:0,y:0,z:-1}}),z(U.top,U.right)&&q.push({z:(k+A)/2,y:$,x:b,xDir:{x:0,y:0,z:1}});var J=function(Y,Z,et){if(Y.length===0)return null;if(Y.length===1)return Y[0];for(var Q=perspective$4(Y,m,!1),tt=0,rt=1;rt<Q.length;rt++)(et*Q[rt][Z]>et*Q[tt][Z]||et*Q[rt][Z]===et*Q[tt][Z]&&Q[rt].z<Q[tt].z)&&(tt=rt);return Y[tt]};U.axes={y:{left:J(V,"x",-1),right:J(V,"x",1)},x:{top:J(K,"y",-1),bottom:J(j,"y",1)},z:{top:J(q,"y",-1),bottom:J(nt,"y",1)}}}else U.axes={y:{left:{x,z:k,xDir:{x:1,y:0,z:0}},right:{x:b,z:k,xDir:{x:0,y:0,z:1}}},x:{top:{y:$,z:k,xDir:{x:1,y:0,z:0}},bottom:{y:S,z:k,xDir:{x:1,y:0,z:0}}},z:{top:{x:X?b:x,y:$,xDir:X?{x:0,y:0,z:1}:{x:0,y:0,z:-1}},bottom:{x:X?b:x,y:S,xDir:X?{x:0,y:0,z:1}:{x:0,y:0,z:-1}}}};return U},g.prototype.getScale=function(m){var y=this.chart,v=y.plotLeft,x=y.plotWidth+v,b=y.plotTop,$=y.plotHeight+b,S=v+y.plotWidth/2,k=b+y.plotHeight/2,A={minX:Number.MAX_VALUE,maxX:-Number.MAX_VALUE,minY:Number.MAX_VALUE,maxY:-Number.MAX_VALUE},M,P=1;return M=[{x:v,y:b,z:0},{x:v,y:b,z:m}],[0,1].forEach(function(E){M.push({x,y:M[E].y,z:M[E].z})}),[0,1,2,3].forEach(function(E){M.push({x:M[E].x,y:$,z:M[E].z})}),M=perspective$4(M,y,!1),M.forEach(function(E){A.minX=Math.min(A.minX,E.x),A.maxX=Math.max(A.maxX,E.x),A.minY=Math.min(A.minY,E.y),A.maxY=Math.max(A.maxY,E.y)}),v>A.minX&&(P=Math.min(P,1-Math.abs((v+S)/(A.minX+S))%1)),x<A.maxX&&(P=Math.min(P,(x-S)/(A.maxX-S))),b>A.minY&&(A.minY<0?P=Math.min(P,(b+k)/(-A.minY+b+k)):P=Math.min(P,1-(b+k)/(A.minY+k)%1)),$<A.maxY&&(P=Math.min(P,Math.abs(($-k)/(A.maxY-k)))),P},g}();n.Composition=e,n.defaultOptions={chart:{options3d:{enabled:!1,alpha:0,beta:0,depth:100,fitToPlot:!0,viewDistance:25,axisLabelPosition:null,frame:{visible:"default",size:1,bottom:{},top:{},left:{},right:{},back:{},front:{}}}}};function t(g,m){var y=g.prototype,v=m.prototype;y.is3d=function(){return!!(this.options.chart.options3d&&this.options.chart.options3d.enabled)},y.propsRequireDirtyBox.push("chart.options3d"),y.propsRequireUpdateSeries.push("chart.options3d"),v.matrixSetter=function(){var x;if(this.pos<1&&(isArray$3(this.start)||isArray$3(this.end))){var b=this.start||[1,0,0,1,0,0],$=this.end||[1,0,0,1,0,0];x=[];for(var S=0;S<6;S++)x.push(this.pos*$[S]+(1-this.pos)*b[S])}else x=this.end;this.elem.attr(this.prop,x,null,!0)},merge$n(!0,genericDefaultOptions,n.defaultOptions),addEvent$h(g,"init",c),addEvent$h(g,"addSeries",r),addEvent$h(g,"afterDrawChartBox",o),addEvent$h(g,"afterGetContainer",s),addEvent$h(g,"afterInit",a),addEvent$h(g,"afterSetChartSize",l),addEvent$h(g,"beforeRedraw",h),addEvent$h(g,"beforeRender",d),wrap$5(y,"isInsidePlot",p),wrap$5(g,"renderSeries",f),wrap$5(g,"setClassName",u)}n.compose=t;function r(g){this.is3d()&&g.options.type==="scatter"&&(g.options.type="scatter3d")}function o(){if(this.chart3d&&this.is3d()){var g=this,m=g.renderer,y=g.options.chart.options3d,v=g.chart3d.get3dFrame(),x=g.plotLeft,b=g.plotLeft+g.plotWidth,$=g.plotTop,S=g.plotTop+g.plotHeight,k=0,A=y.depth,M=x-(v.left.visible?v.left.size:0),P=b+(v.right.visible?v.right.size:0),E=$-(v.top.visible?v.top.size:0),T=S+(v.bottom.visible?v.bottom.size:0),O=k-(v.front.visible?v.front.size:0),C=A+(v.back.visible?v.back.size:0),I=g.hasRendered?"animate":"attr";g.chart3d.frame3d=v,g.frameShapes||(g.frameShapes={bottom:m.polyhedron().add(),top:m.polyhedron().add(),left:m.polyhedron().add(),right:m.polyhedron().add(),back:m.polyhedron().add(),front:m.polyhedron().add()}),g.frameShapes.bottom[I]({class:"highcharts-3d-frame highcharts-3d-frame-bottom",zIndex:v.bottom.frontFacing?-1e3:1e3,faces:[{fill:color$5(v.bottom.color).brighten(.1).get(),vertexes:[{x:M,y:T,z:O},{x:P,y:T,z:O},{x:P,y:T,z:C},{x:M,y:T,z:C}],enabled:v.bottom.visible},{fill:color$5(v.bottom.color).brighten(.1).get(),vertexes:[{x,y:S,z:A},{x:b,y:S,z:A},{x:b,y:S,z:k},{x,y:S,z:k}],enabled:v.bottom.visible},{fill:color$5(v.bottom.color).brighten(-.1).get(),vertexes:[{x:M,y:T,z:O},{x:M,y:T,z:C},{x,y:S,z:A},{x,y:S,z:k}],enabled:v.bottom.visible&&!v.left.visible},{fill:color$5(v.bottom.color).brighten(-.1).get(),vertexes:[{x:P,y:T,z:C},{x:P,y:T,z:O},{x:b,y:S,z:k},{x:b,y:S,z:A}],enabled:v.bottom.visible&&!v.right.visible},{fill:color$5(v.bottom.color).get(),vertexes:[{x:P,y:T,z:O},{x:M,y:T,z:O},{x,y:S,z:k},{x:b,y:S,z:k}],enabled:v.bottom.visible&&!v.front.visible},{fill:color$5(v.bottom.color).get(),vertexes:[{x:M,y:T,z:C},{x:P,y:T,z:C},{x:b,y:S,z:A},{x,y:S,z:A}],enabled:v.bottom.visible&&!v.back.visible}]}),g.frameShapes.top[I]({class:"highcharts-3d-frame highcharts-3d-frame-top",zIndex:v.top.frontFacing?-1e3:1e3,faces:[{fill:color$5(v.top.color).brighten(.1).get(),vertexes:[{x:M,y:E,z:C},{x:P,y:E,z:C},{x:P,y:E,z:O},{x:M,y:E,z:O}],enabled:v.top.visible},{fill:color$5(v.top.color).brighten(.1).get(),vertexes:[{x,y:$,z:k},{x:b,y:$,z:k},{x:b,y:$,z:A},{x,y:$,z:A}],enabled:v.top.visible},{fill:color$5(v.top.color).brighten(-.1).get(),vertexes:[{x:M,y:E,z:C},{x:M,y:E,z:O},{x,y:$,z:k},{x,y:$,z:A}],enabled:v.top.visible&&!v.left.visible},{fill:color$5(v.top.color).brighten(-.1).get(),vertexes:[{x:P,y:E,z:O},{x:P,y:E,z:C},{x:b,y:$,z:A},{x:b,y:$,z:k}],enabled:v.top.visible&&!v.right.visible},{fill:color$5(v.top.color).get(),vertexes:[{x:M,y:E,z:O},{x:P,y:E,z:O},{x:b,y:$,z:k},{x,y:$,z:k}],enabled:v.top.visible&&!v.front.visible},{fill:color$5(v.top.color).get(),vertexes:[{x:P,y:E,z:C},{x:M,y:E,z:C},{x,y:$,z:A},{x:b,y:$,z:A}],enabled:v.top.visible&&!v.back.visible}]}),g.frameShapes.left[I]({class:"highcharts-3d-frame highcharts-3d-frame-left",zIndex:v.left.frontFacing?-1e3:1e3,faces:[{fill:color$5(v.left.color).brighten(.1).get(),vertexes:[{x:M,y:T,z:O},{x,y:S,z:k},{x,y:S,z:A},{x:M,y:T,z:C}],enabled:v.left.visible&&!v.bottom.visible},{fill:color$5(v.left.color).brighten(.1).get(),vertexes:[{x:M,y:E,z:C},{x,y:$,z:A},{x,y:$,z:k},{x:M,y:E,z:O}],enabled:v.left.visible&&!v.top.visible},{fill:color$5(v.left.color).brighten(-.1).get(),vertexes:[{x:M,y:T,z:C},{x:M,y:E,z:C},{x:M,y:E,z:O},{x:M,y:T,z:O}],enabled:v.left.visible},{fill:color$5(v.left.color).brighten(-.1).get(),vertexes:[{x,y:$,z:A},{x,y:S,z:A},{x,y:S,z:k},{x,y:$,z:k}],enabled:v.left.visible},{fill:color$5(v.left.color).get(),vertexes:[{x:M,y:T,z:O},{x:M,y:E,z:O},{x,y:$,z:k},{x,y:S,z:k}],enabled:v.left.visible&&!v.front.visible},{fill:color$5(v.left.color).get(),vertexes:[{x:M,y:E,z:C},{x:M,y:T,z:C},{x,y:S,z:A},{x,y:$,z:A}],enabled:v.left.visible&&!v.back.visible}]}),g.frameShapes.right[I]({class:"highcharts-3d-frame highcharts-3d-frame-right",zIndex:v.right.frontFacing?-1e3:1e3,faces:[{fill:color$5(v.right.color).brighten(.1).get(),vertexes:[{x:P,y:T,z:C},{x:b,y:S,z:A},{x:b,y:S,z:k},{x:P,y:T,z:O}],enabled:v.right.visible&&!v.bottom.visible},{fill:color$5(v.right.color).brighten(.1).get(),vertexes:[{x:P,y:E,z:O},{x:b,y:$,z:k},{x:b,y:$,z:A},{x:P,y:E,z:C}],enabled:v.right.visible&&!v.top.visible},{fill:color$5(v.right.color).brighten(-.1).get(),vertexes:[{x:b,y:$,z:k},{x:b,y:S,z:k},{x:b,y:S,z:A},{x:b,y:$,z:A}],enabled:v.right.visible},{fill:color$5(v.right.color).brighten(-.1).get(),vertexes:[{x:P,y:T,z:O},{x:P,y:E,z:O},{x:P,y:E,z:C},{x:P,y:T,z:C}],enabled:v.right.visible},{fill:color$5(v.right.color).get(),vertexes:[{x:P,y:E,z:O},{x:P,y:T,z:O},{x:b,y:S,z:k},{x:b,y:$,z:k}],enabled:v.right.visible&&!v.front.visible},{fill:color$5(v.right.color).get(),vertexes:[{x:P,y:T,z:C},{x:P,y:E,z:C},{x:b,y:$,z:A},{x:b,y:S,z:A}],enabled:v.right.visible&&!v.back.visible}]}),g.frameShapes.back[I]({class:"highcharts-3d-frame highcharts-3d-frame-back",zIndex:v.back.frontFacing?-1e3:1e3,faces:[{fill:color$5(v.back.color).brighten(.1).get(),vertexes:[{x:P,y:T,z:C},{x:M,y:T,z:C},{x,y:S,z:A},{x:b,y:S,z:A}],enabled:v.back.visible&&!v.bottom.visible},{fill:color$5(v.back.color).brighten(.1).get(),vertexes:[{x:M,y:E,z:C},{x:P,y:E,z:C},{x:b,y:$,z:A},{x,y:$,z:A}],enabled:v.back.visible&&!v.top.visible},{fill:color$5(v.back.color).brighten(-.1).get(),vertexes:[{x:M,y:T,z:C},{x:M,y:E,z:C},{x,y:$,z:A},{x,y:S,z:A}],enabled:v.back.visible&&!v.left.visible},{fill:color$5(v.back.color).brighten(-.1).get(),vertexes:[{x:P,y:E,z:C},{x:P,y:T,z:C},{x:b,y:S,z:A},{x:b,y:$,z:A}],enabled:v.back.visible&&!v.right.visible},{fill:color$5(v.back.color).get(),vertexes:[{x,y:$,z:A},{x:b,y:$,z:A},{x:b,y:S,z:A},{x,y:S,z:A}],enabled:v.back.visible},{fill:color$5(v.back.color).get(),vertexes:[{x:M,y:T,z:C},{x:P,y:T,z:C},{x:P,y:E,z:C},{x:M,y:E,z:C}],enabled:v.back.visible}]}),g.frameShapes.front[I]({class:"highcharts-3d-frame highcharts-3d-frame-front",zIndex:v.front.frontFacing?-1e3:1e3,faces:[{fill:color$5(v.front.color).brighten(.1).get(),vertexes:[{x:M,y:T,z:O},{x:P,y:T,z:O},{x:b,y:S,z:k},{x,y:S,z:k}],enabled:v.front.visible&&!v.bottom.visible},{fill:color$5(v.front.color).brighten(.1).get(),vertexes:[{x:P,y:E,z:O},{x:M,y:E,z:O},{x,y:$,z:k},{x:b,y:$,z:k}],enabled:v.front.visible&&!v.top.visible},{fill:color$5(v.front.color).brighten(-.1).get(),vertexes:[{x:M,y:E,z:O},{x:M,y:T,z:O},{x,y:S,z:k},{x,y:$,z:k}],enabled:v.front.visible&&!v.left.visible},{fill:color$5(v.front.color).brighten(-.1).get(),vertexes:[{x:P,y:T,z:O},{x:P,y:E,z:O},{x:b,y:$,z:k},{x:b,y:S,z:k}],enabled:v.front.visible&&!v.right.visible},{fill:color$5(v.front.color).get(),vertexes:[{x:b,y:$,z:k},{x,y:$,z:k},{x,y:S,z:k},{x:b,y:S,z:k}],enabled:v.front.visible},{fill:color$5(v.front.color).get(),vertexes:[{x:P,y:T,z:O},{x:M,y:T,z:O},{x:M,y:E,z:O},{x:P,y:E,z:O}],enabled:v.front.visible}]})}}function s(){this.styledMode&&(this.renderer.definition({tagName:"style",textContent:`.highcharts-3d-top{filter: url(#highcharts-brighter)}
.highcharts-3d-side{filter: url(#highcharts-darker)}
`}),[{name:"darker",slope:.6},{name:"brighter",slope:1.4}].forEach(function(g){this.renderer.definition({tagName:"filter",attributes:{id:"highcharts-"+g.name},children:[{tagName:"feComponentTransfer",children:[{tagName:"feFuncR",attributes:{type:"linear",slope:g.slope}},{tagName:"feFuncG",attributes:{type:"linear",slope:g.slope}},{tagName:"feFuncB",attributes:{type:"linear",slope:g.slope}}]}]})},this))}function a(){var g=this.options;this.is3d()&&(g.series||[]).forEach(function(m){var y=m.type||g.chart.type||g.chart.defaultSeriesType;y==="scatter"&&(m.type="scatter3d")})}function l(){var g=this,m=g.options.chart.options3d;if(g.chart3d&&g.is3d()){m&&(m.alpha=m.alpha%360+(m.alpha>=0?0:360),m.beta=m.beta%360+(m.beta>=0?0:360));var y=g.inverted,v=g.clipBox,x=g.margin,b=y?"y":"x",$=y?"x":"y",S=y?"height":"width",k=y?"width":"height";v[b]=-(x[3]||0),v[$]=-(x[0]||0),v[S]=g.chartWidth+(x[3]||0)+(x[1]||0),v[k]=g.chartHeight+(x[0]||0)+(x[2]||0),g.scale3d=1,m.fitToPlot===!0&&(g.scale3d=g.chart3d.getScale(m.depth)),g.chart3d.frame3d=g.chart3d.get3dFrame()}}function h(){this.is3d()&&(this.isDirtyBox=!0)}function d(){this.chart3d&&this.is3d()&&(this.chart3d.frame3d=this.chart3d.get3dFrame())}function c(){this.chart3d||(this.chart3d=new e(this))}function p(g){return this.is3d()||g.apply(this,[].slice.call(arguments,1))}function f(g){var m,y=this.series.length;if(this.is3d())for(;y--;)m=this.series[y],m.translate(),m.render();else g.call(this)}function u(g){g.apply(this,[].slice.call(arguments,1)),this.is3d()&&(this.container.className+=" highcharts-3d-chart")}})(Chart3D||(Chart3D={}));const Chart3D$1=Chart3D;var __extends$n=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),addEvent$g=Utilities.addEvent,merge$m=Utilities.merge,pick$p=Utilities.pick,splat$2=Utilities.splat,ZChart=function(){function n(){}return n.compose=function(e){addEvent$g(e,"afterGetAxes",n.onAfterGetAxes);var t=e.prototype;t.addZAxis=n.wrapAddZAxis,t.collectionsWithInit.zAxis=[t.addZAxis],t.collectionsWithUpdate.push("zAxis")},n.onAfterGetAxes=function(){var e=this,t=this.options,r=t.zAxis=splat$2(t.zAxis||{});e.is3d()&&(e.zAxis=[],r.forEach(function(o,s){o.index=s,o.isX=!0,e.addZAxis(o).setScale()}))},n.wrapAddZAxis=function(e){return new ZAxis(this,e)},n}(),ZAxis=function(n){__extends$n(e,n);function e(t,r){var o=n.call(this,t,r)||this;return o.isZAxis=!0,o}return e.prototype.getSeriesExtremes=function(){var t=this,r=t.chart;t.hasVisibleSeries=!1,t.dataMin=t.dataMax=t.ignoreMinPadding=t.ignoreMaxPadding=void 0,t.stacking&&t.stacking.buildStacks(),t.series.forEach(function(o){if(o.visible||!r.options.chart.ignoreHiddenSeries){var s=o.options,a=void 0,l=s.threshold;t.hasVisibleSeries=!0,t.positiveValuesOnly&&l<=0&&(l=void 0),a=o.zData,a.length&&(t.dataMin=Math.min(pick$p(t.dataMin,a[0]),Math.min.apply(null,a)),t.dataMax=Math.max(pick$p(t.dataMax,a[0]),Math.max.apply(null,a)))}})},e.prototype.setAxisSize=function(){var t=this,r=t.chart;n.prototype.setAxisSize.call(this),t.width=t.len=r.options.chart.options3d&&r.options.chart.options3d.depth||0,t.right=r.chartWidth-t.width-t.left},e.prototype.setOptions=function(t){t=merge$m({offset:0,lineWidth:0},t),this.isZAxis=!0,n.prototype.setOptions.call(this,t),this.coll="zAxis"},e.ZChartComposition=ZChart,e}(Axis),addEvent$f=Utilities.addEvent,extend$q=Utilities.extend,wrap$4=Utilities.wrap,Tick3D=function(){function n(){}return n.compose=function(e){addEvent$f(e,"afterGetLabelPosition",n.onAfterGetLabelPosition);var t=e.prototype;wrap$4(t,"getMarkPath",n.wrapGetMarkPath)},n.onAfterGetLabelPosition=function(e){var t=this.axis.axis3D;t&&extend$q(e.pos,t.fix3dPosition(e.pos))},n.wrapGetMarkPath=function(e){this.axis.chart;var t=this.axis.axis3D,r=e.apply(this,[].slice.call(arguments,1));if(t){var o=r[0],s=r[1];if(o[0]==="M"&&s[0]==="L"){var a=[t.fix3dPosition({x:o[1],y:o[2],z:0}),t.fix3dPosition({x:s[1],y:s[2],z:0})];return this.axis.chart.renderer.toLineSegments(a)}}return r},n}(),deg2rad$1=H.deg2rad,perspective$3=mathModule.perspective,perspective3D=mathModule.perspective3D,shapeArea=mathModule.shapeArea,addEvent$e=Utilities.addEvent,merge$l=Utilities.merge,pick$o=Utilities.pick,wrap$3=Utilities.wrap,Axis3DAdditions=function(){function n(e){this.axis=e}return n.prototype.fix3dPosition=function(e,t){var r=this,o=r.axis,s=o.chart;if(o.coll==="colorAxis"||!s.chart3d||!s.is3d())return e;var a=deg2rad$1*s.options.chart.options3d.alpha,l=deg2rad$1*s.options.chart.options3d.beta,h=pick$o(t&&o.options.title.position3d,o.options.labels.position3d),d=pick$o(t&&o.options.title.skew3d,o.options.labels.skew3d),c=s.chart3d.frame3d,p=s.plotLeft,f=s.plotWidth+p,u=s.plotTop,g=s.plotHeight+u,m=0,y=0,v,x={x:0,y:1,z:0},b=!1;if(e=o.axis3D.swapZ({x:e.x,y:e.y,z:0}),o.isZAxis)if(o.opposite){if(c.axes.z.top===null)return{};y=e.y-u,e.x=c.axes.z.top.x,e.y=c.axes.z.top.y,v=c.axes.z.top.xDir,b=!c.top.frontFacing}else{if(c.axes.z.bottom===null)return{};y=e.y-g,e.x=c.axes.z.bottom.x,e.y=c.axes.z.bottom.y,v=c.axes.z.bottom.xDir,b=!c.bottom.frontFacing}else if(o.horiz)if(o.opposite){if(c.axes.x.top===null)return{};y=e.y-u,e.y=c.axes.x.top.y,e.z=c.axes.x.top.z,v=c.axes.x.top.xDir,b=!c.top.frontFacing}else{if(c.axes.x.bottom===null)return{};y=e.y-g,e.y=c.axes.x.bottom.y,e.z=c.axes.x.bottom.z,v=c.axes.x.bottom.xDir,b=!c.bottom.frontFacing}else if(o.opposite){if(c.axes.y.right===null)return{};m=e.x-f,e.x=c.axes.y.right.x,e.z=c.axes.y.right.z,v=c.axes.y.right.xDir,v={x:v.z,y:v.y,z:-v.x}}else{if(c.axes.y.left===null)return{};m=e.x-p,e.x=c.axes.y.left.x,e.z=c.axes.y.left.z,v=c.axes.y.left.xDir}if(h!=="chart")if(h==="flap")if(!o.horiz)v={x:Math.cos(l),y:0,z:Math.sin(l)};else{var $=Math.sin(a),S=Math.cos(a);o.opposite&&($=-$),b&&($=-$),x={x:v.z*$,y:S,z:-v.x*$}}else if(h==="ortho")if(!o.horiz)v={x:Math.cos(l),y:0,z:Math.sin(l)};else{var k=Math.sin(a),A=Math.cos(a),M=Math.sin(l),P=Math.cos(l),E={x:M*A,y:-k,z:-A*P};x={x:v.y*E.z-v.z*E.y,y:v.z*E.x-v.x*E.z,z:v.x*E.y-v.y*E.x};var T=1/Math.sqrt(x.x*x.x+x.y*x.y+x.z*x.z);b&&(T=-T),x={x:T*x.x,y:T*x.y,z:T*x.z}}else o.horiz?x={x:Math.sin(l)*Math.sin(a),y:Math.cos(a),z:-Math.cos(l)*Math.sin(a)}:v={x:Math.cos(l),y:0,z:Math.sin(l)};e.x+=m*v.x+y*x.x,e.y+=m*v.y+y*x.y,e.z+=m*v.z+y*x.z;var O=perspective$3([e],o.chart)[0];if(d){var C=shapeArea(perspective$3([e,{x:e.x+v.x,y:e.y+v.y,z:e.z+v.z},{x:e.x+x.x,y:e.y+x.y,z:e.z+x.z}],o.chart))<0;C&&(v={x:-v.x,y:-v.y,z:-v.z});var I=perspective$3([{x:e.x,y:e.y,z:e.z},{x:e.x+v.x,y:e.y+v.y,z:e.z+v.z},{x:e.x+x.x,y:e.y+x.y,z:e.z+x.z}],o.chart);O.matrix=[I[1].x-I[0].x,I[1].y-I[0].y,I[2].x-I[0].x,I[2].y-I[0].y,O.x,O.y],O.matrix[4]-=O.x*O.matrix[0]+O.y*O.matrix[2],O.matrix[5]-=O.x*O.matrix[1]+O.y*O.matrix[3]}return O},n.prototype.swapZ=function(e,t){var r=this.axis;if(r.isZAxis){var o=t?0:r.chart.plotLeft;return{x:o+e.z,y:e.y,z:e.x-o}}return e},n}(),Axis3D=function(){function n(){}return n.compose=function(e){merge$l(!0,e.defaultOptions,n.defaultOptions),e.keepProps.push("axis3D"),addEvent$e(e,"init",n.onInit),addEvent$e(e,"afterSetOptions",n.onAfterSetOptions),addEvent$e(e,"drawCrosshair",n.onDrawCrosshair);var t=e.prototype;wrap$3(t,"getLinePath",n.wrapGetLinePath),wrap$3(t,"getPlotBandPath",n.wrapGetPlotBandPath),wrap$3(t,"getPlotLinePath",n.wrapGetPlotLinePath),wrap$3(t,"getSlotWidth",n.wrapGetSlotWidth),wrap$3(t,"getTitlePosition",n.wrapGetTitlePosition),Tick3D.compose(Tick)},n.onAfterSetOptions=function(){var e=this,t=e.chart,r=e.options;t.is3d&&t.is3d()&&e.coll!=="colorAxis"&&(r.tickWidth=pick$o(r.tickWidth,0),r.gridLineWidth=pick$o(r.gridLineWidth,1))},n.onDrawCrosshair=function(e){var t=this;t.chart.is3d()&&t.coll!=="colorAxis"&&e.point&&(e.point.crosshairPos=t.isXAxis?e.point.axisXpos:t.len-e.point.axisYpos)},n.onInit=function(){var e=this;e.axis3D||(e.axis3D=new Axis3DAdditions(e))},n.wrapGetLinePath=function(e){var t=this;return!t.chart.is3d()||t.coll==="colorAxis"?e.apply(t,[].slice.call(arguments,1)):[]},n.wrapGetPlotBandPath=function(e){if(!this.chart.is3d()||this.coll==="colorAxis")return e.apply(this,[].slice.call(arguments,1));var t=arguments,r=t[1],o=t[2],s=[],a=this.getPlotLinePath({value:r}),l=this.getPlotLinePath({value:o});if(a&&l)for(var h=0;h<a.length;h+=2){var d=a[h],c=a[h+1],p=l[h],f=l[h+1];d[0]==="M"&&c[0]==="L"&&p[0]==="M"&&f[0]==="L"&&s.push(d,c,f,["L",p[1],p[2]],["Z"])}return s},n.wrapGetPlotLinePath=function(e){var t=this,r=t.axis3D,o=t.chart,s=e.apply(t,[].slice.call(arguments,1));if(t.coll==="colorAxis"||!o.chart3d||!o.is3d()||s===null)return s;var a=o.options.chart.options3d,l=t.isZAxis?o.plotWidth:a.depth,h=o.chart3d.frame3d,d=s[0],c=s[1],p,f=[];return d[0]==="M"&&c[0]==="L"&&(p=[r.swapZ({x:d[1],y:d[2],z:0}),r.swapZ({x:d[1],y:d[2],z:l}),r.swapZ({x:c[1],y:c[2],z:0}),r.swapZ({x:c[1],y:c[2],z:l})],this.horiz?this.isZAxis?(h.left.visible&&f.push(p[0],p[2]),h.right.visible&&f.push(p[1],p[3]),h.top.visible&&f.push(p[0],p[1]),h.bottom.visible&&f.push(p[2],p[3])):(h.front.visible&&f.push(p[0],p[2]),h.back.visible&&f.push(p[1],p[3]),h.top.visible&&f.push(p[0],p[1]),h.bottom.visible&&f.push(p[2],p[3])):(h.front.visible&&f.push(p[0],p[2]),h.back.visible&&f.push(p[1],p[3]),h.left.visible&&f.push(p[0],p[1]),h.right.visible&&f.push(p[2],p[3])),f=perspective$3(f,this.chart,!1)),o.renderer.toLineSegments(f)},n.wrapGetSlotWidth=function(e,t){var r=this,o=r.chart,s=r.ticks,a=r.gridGroup;if(r.categories&&o.frameShapes&&o.is3d()&&a&&t&&t.label){var l=a.element.childNodes[0].getBBox(),h=o.frameShapes.left.getBBox(),d=o.options.chart.options3d,c={x:o.plotWidth/2,y:o.plotHeight/2,z:d.depth/2,vd:pick$o(d.depth,1)*pick$o(d.viewDistance,0)},p=t.pos,f=s[p-1],u=s[p+1],g=void 0,m=void 0,y=void 0;return p!==0&&f&&f.label&&f.label.xy&&(m=perspective3D({x:f.label.xy.x,y:f.label.xy.y,z:null},c,c.vd)),u&&u.label&&u.label.xy&&(y=perspective3D({x:u.label.xy.x,y:u.label.xy.y,z:null},c,c.vd)),g={x:t.label.xy.x,y:t.label.xy.y,z:null},g=perspective3D(g,c,c.vd),Math.abs(m?g.x-m.x:y?y.x-g.x:l.x-h.x)}return e.apply(r,[].slice.call(arguments,1))},n.wrapGetTitlePosition=function(e){var t=e.apply(this,[].slice.call(arguments,1));return this.axis3D?this.axis3D.fix3dPosition(t,!0):t},n.defaultOptions={labels:{position3d:"offset",skew3d:!1},title:{position3d:null,skew3d:null}},n}(),__extends$m=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),perspective$2=mathModule.perspective,addEvent$d=Utilities.addEvent,extend$p=Utilities.extend,merge$k=Utilities.merge,pick$n=Utilities.pick,isNumber$9=Utilities.isNumber,Series3D=function(n){__extends$m(e,n);function e(){return n!==null&&n.apply(this,arguments)||this}return e.prototype.translate=function(){n.prototype.translate.apply(this,arguments),this.chart.is3d()&&this.translate3dPoints()},e.prototype.translate3dPoints=function(){var t=this,r=t.options,o=t.chart,s=pick$n(t.zAxis,o.options.zAxis[0]),a=[],l,h,d,c,p,f=[],u=r.stacking?isNumber$9(r.stack)?r.stack:0:t.index||0;for(t.zPadding=u*(r.depth||0+(r.groupZPadding||1)),p=0;p<t.data.length;p++)l=t.data[p],s&&s.translate?(c=s.logarithmic&&s.val2lin?s.val2lin(l.z):l.z,l.plotZ=s.translate(c),l.isInside=l.isInside?c>=s.min&&c<=s.max:!1):l.plotZ=t.zPadding,l.axisXpos=l.plotX,l.axisYpos=l.plotY,l.axisZpos=l.plotZ,a.push({x:l.plotX,y:l.plotY,z:l.plotZ}),f.push(l.plotX||0);for(t.rawPointsX=f,h=perspective$2(a,o,!0),p=0;p<t.data.length;p++)l=t.data[p],d=h[p],l.plotX=d.x,l.plotY=d.y,l.plotZ=d.z},e.defaultOptions=merge$k(Series$e.defaultOptions),e}(Series$e);addEvent$d(Series$e,"afterTranslate",function(){this.chart.is3d()&&this.translate3dPoints()});extend$p(Series$e.prototype,{translate3dPoints:Series3D.prototype.translate3dPoints});var columnProto$1=ColumnSeries$h.prototype,svg$1=H.svg,perspective$1=mathModule.perspective,addEvent$c=Utilities.addEvent,pick$m=Utilities.pick,wrap$2=Utilities.wrap;function retrieveStacks(n,e){var t=n.series,r={totalStacks:0},o,s=1;return t.forEach(function(a){o=pick$m(a.options.stack,e?0:t.length-1-a.index),r[o]?r[o].series.push(a):(r[o]={series:[a],position:s},s++)}),r.totalStacks=s+1,r}wrap$2(columnProto$1,"translate",function(n){n.apply(this,[].slice.call(arguments,1)),this.chart.is3d()&&this.translate3dShapes()});wrap$2(Series$e.prototype,"justifyDataLabel",function(n){return arguments[2].outside3dPlot?!1:n.apply(this,[].slice.call(arguments,1))});columnProto$1.translate3dPoints=function(){};columnProto$1.translate3dShapes=function(){var n=this,e=n.chart,t=n.options,r=t.depth,o=t.stacking?t.stack||0:n.index,s=o*(r+(t.groupZPadding||1)),a=n.borderWidth%2?.5:0,l;e.inverted&&!n.yAxis.reversed&&(a*=-1),t.grouping!==!1&&(s=0),s+=t.groupZPadding||1,n.data.forEach(function(h){if(h.outside3dPlot=null,h.y!==null){var d=h.shapeArgs,c=h.tooltipPos,p=[["x","width"],["y","height"]],f;p.forEach(function(u){if(f=d[u[0]]-a,f<0&&(d[u[1]]+=d[u[0]]+a,d[u[0]]=-a,f=0),f+d[u[1]]>n[u[0]+"Axis"].len&&d[u[1]]!==0&&(d[u[1]]=n[u[0]+"Axis"].len-d[u[0]]),d[u[1]]!==0&&(d[u[0]]>=n[u[0]+"Axis"].len||d[u[0]]+d[u[1]]<=a)){for(var g in d)d[g]=g==="y"?-9999:0;h.outside3dPlot=!0}}),h.shapeType==="rect"&&(h.shapeType="cuboid"),d.z=s,d.depth=r,d.insidePlotArea=!0,l={x:d.x+d.width/2,y:d.y,z:s+r/2},e.inverted&&(l.x=d.height,l.y=h.clientX),h.plot3d=perspective$1([l],e,!0,!1)[0],c=perspective$1([{x:c[0],y:c[1],z:s+r/2}],e,!0,!1)[0],h.tooltipPos=[c.x,c.y]}}),n.z=s};wrap$2(columnProto$1,"animate",function(n){if(!this.chart.is3d())n.apply(this,[].slice.call(arguments,1));else{var e=arguments,t=e[1],r=this.yAxis,o=this,s=this.yAxis.reversed;svg$1&&(t?o.data.forEach(function(a){a.y!==null&&(a.height=a.shapeArgs.height,a.shapey=a.shapeArgs.y,a.shapeArgs.height=1,s||(a.stackY?a.shapeArgs.y=a.plotY+r.translate(a.stackY):a.shapeArgs.y=a.plotY+(a.negative?-a.height:a.height)))}):(o.data.forEach(function(a){a.y!==null&&(a.shapeArgs.height=a.height,a.shapeArgs.y=a.shapey,a.graphic&&a.graphic[a.outside3dPlot?"attr":"animate"](a.shapeArgs,o.options.animation))}),this.drawDataLabels()))}});wrap$2(columnProto$1,"plotGroup",function(n,e,t,r,o,s){return e!=="dataLabelsGroup"&&this.chart.is3d()&&(this[e]&&delete this[e],s&&(this.chart.columnGroup||(this.chart.columnGroup=this.chart.renderer.g("columnGroup").add(s)),this[e]=this.chart.columnGroup,this.chart.columnGroup.attr(this.getPlotBox()),this[e].survive=!0,(e==="group"||e==="markerGroup")&&(arguments[3]="visible"))),n.apply(this,Array.prototype.slice.call(arguments,1))});wrap$2(columnProto$1,"setVisible",function(n,e){var t=this;t.chart.is3d()&&t.data.forEach(function(r){r.visible=r.options.visible=e=typeof e>"u"?!pick$m(t.visible,r.visible):e,t.options.data[t.data.indexOf(r)]=r.options,r.graphic&&r.graphic.attr({visibility:e?"visible":"hidden"})}),n.apply(this,Array.prototype.slice.call(arguments,1))});addEvent$c(ColumnSeries$h,"afterInit",function(){if(this.chart.is3d()){var n=this,e=this.options,t=e.grouping,r=e.stacking,o=this.yAxis.options.reversedStacks,s=0;if(!(typeof t<"u"&&!t)){var a=retrieveStacks(this.chart,r),l=e.stack||0,h=void 0;for(h=0;h<a[l].series.length&&a[l].series[h]!==this;h++);s=10*(a.totalStacks-a[l].position)+(o?h:-h),this.xAxis.reversed||(s=a.totalStacks*10-s)}e.depth=e.depth||25,n.z=n.z||0,e.zIndex=s}});function pointAttribs(n){var e=n.apply(this,[].slice.call(arguments,1));return this.chart.is3d&&this.chart.is3d()&&(e.stroke=this.options.edgeColor||e.fill,e["stroke-width"]=pick$m(this.options.edgeWidth,1)),e}function setState(n,e,t){var r=this.chart.is3d&&this.chart.is3d();r&&(this.options.inactiveOtherPoints=!0),n.call(this,e,t),r&&(this.options.inactiveOtherPoints=!1)}function hasNewShapeType(n){for(var e=[],t=1;t<arguments.length;t++)e[t-1]=arguments[t];return this.series.chart.is3d()?this.graphic&&this.graphic.element.nodeName!=="g":n.apply(this,e)}wrap$2(columnProto$1,"pointAttribs",pointAttribs);wrap$2(columnProto$1,"setState",setState);wrap$2(columnProto$1.pointClass.prototype,"hasNewShapeType",hasNewShapeType);if(SeriesRegistry$1.seriesTypes.columnRange){var columnRangeProto=SeriesRegistry$1.seriesTypes.columnrange.prototype;wrap$2(columnRangeProto,"pointAttribs",pointAttribs),wrap$2(columnRangeProto,"setState",setState),wrap$2(columnRangeProto.pointClass.prototype,"hasNewShapeType",hasNewShapeType),columnRangeProto.plotGroup=columnProto$1.plotGroup,columnRangeProto.setVisible=columnProto$1.setVisible}wrap$2(Series$e.prototype,"alignDataLabel",function(n,e,t,r,o){var s=this.chart;if(r.outside3dPlot=e.outside3dPlot,s.is3d()&&this.is("column")){var a=this,l=a.options,h=pick$m(r.inside,!!a.options.stacking),d=s.options.chart.options3d,c=e.pointWidth/2||0,p={x:o.x+c,y:o.y,z:a.z+l.depth/2};s.inverted&&(h&&(o.width=0,p.x+=e.shapeArgs.height/2),d.alpha>=90&&d.alpha<=270&&(p.y+=e.shapeArgs.width)),p=perspective$1([p],s,!0,!1)[0],o.x=p.x-c,o.y=e.outside3dPlot?-9e9:p.y}n.apply(this,[].slice.call(arguments,1))});wrap$2(StackItem$1.prototype,"getStackBox",function(n,e,t,r,o,s,a,l){var h=n.apply(this,[].slice.call(arguments,1));if(e.is3d()&&t.base){var d=+t.base.split(",")[0],c=e.series[d],p=e.options.chart.options3d;if(c&&c instanceof SeriesRegistry$1.seriesTypes.column){var f={x:h.x+(e.inverted?a:s/2),y:h.y,z:c.options.depth/2};e.inverted&&(h.width=0,p.alpha>=90&&p.alpha<=270&&(f.y+=s)),f=perspective$1([f],e,!0,!1)[0],h.x=f.x-s/2,h.y=f.y}}return h});var __extends$l=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),PiePoint$2=SeriesRegistry$1.seriesTypes.pie.prototype.pointClass,superHaloPath=PiePoint$2.prototype.haloPath,Pie3DPoint=function(n){__extends$l(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.series=void 0,t}return e.prototype.haloPath=function(){return this.series.chart.is3d()?[]:superHaloPath.apply(this,arguments)},e}(PiePoint$2),__extends$k=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),deg2rad=H.deg2rad,svg=H.svg,PieSeries$2=SeriesRegistry$1.seriesTypes.pie,extend$o=Utilities.extend,pick$l=Utilities.pick,Pie3DSeries=function(n){__extends$k(e,n);function e(){return n!==null&&n.apply(this,arguments)||this}return e.prototype.addPoint=function(){n.prototype.addPoint.apply(this,arguments),this.chart.is3d()&&this.update(this.userOptions,!0)},e.prototype.animate=function(t){if(!this.chart.is3d())n.prototype.animate.apply(this,arguments);else{var r=this.options.animation,o=void 0,s=this.center,a=this.group,l=this.markerGroup;svg&&(r===!0&&(r={}),t?(a.oldtranslateX=pick$l(a.oldtranslateX,a.translateX),a.oldtranslateY=pick$l(a.oldtranslateY,a.translateY),o={translateX:s[0],translateY:s[1],scaleX:.001,scaleY:.001},a.attr(o),l&&(l.attrSetters=a.attrSetters,l.attr(o))):(o={translateX:a.oldtranslateX,translateY:a.oldtranslateY,scaleX:1,scaleY:1},a.animate(o,r),l&&l.animate(o,r)))}},e.prototype.drawDataLabels=function(){if(this.chart.is3d()){var t=this,r=t.chart,o=r.options.chart.options3d;t.data.forEach(function(s){var a=s.shapeArgs,l=a.r,h=(a.alpha||o.alpha)*deg2rad,d=(a.beta||o.beta)*deg2rad,c=(a.start+a.end)/2,p=s.labelPosition,f=p.connectorPosition,u=-l*(1-Math.cos(h))*Math.sin(c),g=l*(Math.cos(d)-1)*Math.cos(c);[p.natural,f.breakAt,f.touchingSliceAt].forEach(function(m){m.x+=g,m.y+=u})})}n.prototype.drawDataLabels.apply(this,arguments)},e.prototype.pointAttribs=function(t){var r=n.prototype.pointAttribs.apply(this,arguments),o=this.options;return this.chart.is3d()&&!this.chart.styledMode&&(r.stroke=o.edgeColor||t.color||this.color,r["stroke-width"]=pick$l(o.edgeWidth,1)),r},e.prototype.translate=function(){if(n.prototype.translate.apply(this,arguments),!!this.chart.is3d()){var t=this,r=t.options,o=r.depth||0,s=t.chart.options.chart.options3d,a=s.alpha,l=s.beta,h=r.stacking?(r.stack||0)*o:t._i*o;h+=o/2,r.grouping!==!1&&(h=0),t.data.forEach(function(d){var c=d.shapeArgs,p;d.shapeType="arc3d",c.z=h,c.depth=o*.75,c.alpha=a,c.beta=l,c.center=t.center,p=(c.end+c.start)/2,d.slicedTranslation={translateX:Math.round(Math.cos(p)*r.slicedOffset*Math.cos(a*deg2rad)),translateY:Math.round(Math.sin(p)*r.slicedOffset*Math.cos(a*deg2rad))}})}},e}(PieSeries$2);extend$o(Pie3DSeries.prototype,{pointClass:Pie3DPoint});SeriesRegistry$1.seriesTypes.pie.prototype.pointClass.prototype.haloPath=Pie3DPoint.prototype.haloPath;SeriesRegistry$1.seriesTypes.pie=Pie3DSeries;var __extends$j=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),defined$9=Utilities.defined,Scatter3DPoint=function(n){__extends$j(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return e.prototype.applyOptions=function(){return n.prototype.applyOptions.apply(this,arguments),defined$9(this.z)||(this.z=0),this},e}(ScatterSeries$4.prototype.pointClass),__extends$i=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),pointCameraDistance=mathModule.pointCameraDistance,extend$n=Utilities.extend,merge$j=Utilities.merge,Scatter3DSeries=function(n){__extends$i(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.pointAttribs=function(t){var r=n.prototype.pointAttribs.apply(this,arguments);return this.chart.is3d()&&t&&(r.zIndex=pointCameraDistance(t,this.chart)),r},e.defaultOptions=merge$j(ScatterSeries$4.defaultOptions,{tooltip:{pointFormat:"x: <b>{point.x}</b><br/>y: <b>{point.y}</b><br/>z: <b>{point.z}</b><br/>"}}),e}(ScatterSeries$4);extend$n(Scatter3DSeries.prototype,{axisTypes:["xAxis","yAxis","zAxis"],directTouch:!0,parallelArrays:["x","y","z"],pointArrayMap:["x","y","z"],pointClass:Scatter3DPoint});SeriesRegistry$1.registerSeriesType("scatter3d",Scatter3DSeries);var perspective=mathModule.perspective,_a$6=SeriesRegistry$1.seriesTypes,AreaSeriesClass=_a$6.area,LineSeriesClass=_a$6.line,pick$k=Utilities.pick,wrap$1=Utilities.wrap;wrap$1(AreaSeriesClass.prototype,"getGraphPath",function(n){var e=this,t=n.apply(e,[].slice.call(arguments,1));if(!e.chart.is3d())return t;var r=LineSeriesClass.prototype.getGraphPath,o=e.options,s=o.stacking,a,l=[],h=[],d,c=pick$k(o.connectNulls,s==="percent"),p=Math.round(e.yAxis.getThreshold(o.threshold)),f;if(e.rawPointsX)for(var u=0;u<e.points.length;u++)l.push({x:e.rawPointsX[u],y:o.stacking?e.points[u].yBottom:p,z:e.zPadding});return f=e.chart.options.chart.options3d,l=perspective(l,e.chart,!0).map(function(g){return{plotX:g.x,plotY:g.y,plotZ:g.z}}),e.group&&f&&f.depth&&f.beta&&(e.markerGroup&&(e.markerGroup.add(e.group),e.markerGroup.attr({translateX:0,translateY:0})),e.group.attr({zIndex:Math.max(1,f.beta>270||f.beta<90?f.depth-Math.round(e.zPadding||0):Math.round(e.zPadding||0))})),l.reversed=!0,a=r.call(e,l,!0,!0),a[0]&&a[0][0]==="M"&&(a[0]=["L",a[0][1],a[0][2]]),e.areaPath&&(d=e.areaPath.splice(0,e.areaPath.length/2).concat(a),d.xMap=e.areaPath.xMap,e.areaPath=d,r.call(e,h,!1,c)),t});/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/highcharts-3d
 * @requires highcharts
 *
 * 3D features for Highcharts JS
 *
 * License: www.highcharts.com/license
 */var G$3=H;SVGRenderer3D.compose(G$3.SVGRenderer);Chart3D$1.compose(G$3.Chart,G$3.Fx);ZAxis.ZChartComposition.compose(G$3.Chart);Axis3D.compose(G$3.Axis);var doc$2=H.doc,createElement$1=Utilities.createElement,discardElement$1=Utilities.discardElement,merge$i=Utilities.merge,objectEach$5=Utilities.objectEach;function ajax$1(n){var e=merge$i(!0,{url:!1,type:"get",dataType:"json",success:!1,error:!1,data:!1,headers:{}},n),t={json:"application/json",xml:"application/xml",text:"text/plain",octet:"application/octet-stream"},r=new XMLHttpRequest;function o(s,a){e.error&&e.error(s,a)}if(!e.url)return!1;r.open(e.type.toUpperCase(),e.url,!0),e.headers["Content-Type"]||r.setRequestHeader("Content-Type",t[e.dataType]||t.text),objectEach$5(e.headers,function(s,a){r.setRequestHeader(a,s)}),r.onreadystatechange=function(){var s;if(r.readyState===4){if(r.status===200){if(s=r.responseText,e.dataType==="json")try{s=JSON.parse(s)}catch(a){return o(r,a)}return e.success&&e.success(s)}o(r,r.responseText)}};try{e.data=JSON.stringify(e.data)}catch{}r.send(e.data||!0)}function getJSON(n,e){exports$2.ajax({url:n,success:e,dataType:"json",headers:{"Content-Type":"text/plain"}})}function post(n,e,t){var r=createElement$1("form",merge$i({method:"post",action:n,enctype:"multipart/form-data"},t),{display:"none"},doc$2.body);objectEach$5(e,function(o,s){createElement$1("input",{type:"hidden",name:s,value:o},null,r)}),r.submit(),discardElement$1(r)}var exports$2={ajax:ajax$1,getJSON,post},doc$1=H.doc,ajax=exports$2.ajax,seriesTypes$2=SeriesRegistry$1.seriesTypes,addEvent$b=Utilities.addEvent,defined$8=Utilities.defined,extend$m=Utilities.extend,fireEvent$5=Utilities.fireEvent,isNumber$8=Utilities.isNumber,merge$h=Utilities.merge,objectEach$4=Utilities.objectEach,pick$j=Utilities.pick,splat$1=Utilities.splat,Data=function(){function n(e,t,r){this.chart=void 0,this.chartOptions=void 0,this.firstRowAsNames=void 0,this.rawColumns=void 0,this.options=void 0,this.dateFormats={"YYYY/mm/dd":{regex:/^([0-9]{4})[\-\/\.]([0-9]{1,2})[\-\/\.]([0-9]{1,2})$/,parser:function(o){return o?Date.UTC(+o[1],o[2]-1,+o[3]):NaN}},"dd/mm/YYYY":{regex:/^([0-9]{1,2})[\-\/\.]([0-9]{1,2})[\-\/\.]([0-9]{4})$/,parser:function(o){return o?Date.UTC(+o[3],o[2]-1,+o[1]):NaN},alternative:"mm/dd/YYYY"},"mm/dd/YYYY":{regex:/^([0-9]{1,2})[\-\/\.]([0-9]{1,2})[\-\/\.]([0-9]{4})$/,parser:function(o){return o?Date.UTC(+o[3],o[1]-1,+o[2]):NaN}},"dd/mm/YY":{regex:/^([0-9]{1,2})[\-\/\.]([0-9]{1,2})[\-\/\.]([0-9]{2})$/,parser:function(o){if(!o)return NaN;var s=+o[3],a=new Date;return s>a.getFullYear()-2e3?s+=1900:s+=2e3,Date.UTC(s,o[2]-1,+o[1])},alternative:"mm/dd/YY"},"mm/dd/YY":{regex:/^([0-9]{1,2})[\-\/\.]([0-9]{1,2})[\-\/\.]([0-9]{2})$/,parser:function(o){return o?Date.UTC(+o[3]+2e3,o[1]-1,+o[2]):NaN}}},this.init(e,t,r)}return n.prototype.init=function(e,t,r){var o=e.decimalPoint,s;t&&(this.chartOptions=t),r&&(this.chart=r),o!=="."&&o!==","&&(o=void 0),this.options=e,this.columns=e.columns||this.rowsToColumns(e.rows)||[],this.firstRowAsNames=pick$j(e.firstRowAsNames,this.firstRowAsNames,!0),this.decimalRegex=o&&new RegExp("^(-?[0-9]+)"+o+"([0-9]+)$"),this.rawColumns=[],this.columns.length&&(this.dataFound(),s=!0),this.hasURLOption(e)&&(clearTimeout(this.liveDataTimeout),s=!1),s||(s=this.fetchLiveData()),s||(s=!!this.parseCSV().length),s||(s=!!this.parseTable().length),s||(s=this.parseGoogleSpreadsheet()),!s&&e.afterComplete&&e.afterComplete()},n.prototype.hasURLOption=function(e){return!!(e&&(e.rowsURL||e.csvURL||e.columnsURL))},n.prototype.getColumnDistribution=function(){var e=this.chartOptions,t=this.options,r=[],o=function(u){return(seriesTypes$2[u||"line"].prototype.pointArrayMap||[0]).length},s=function(u){return seriesTypes$2[u||"line"].prototype.pointArrayMap},a=e&&e.chart&&e.chart.type,l=[],h=[],d=0,c=t&&t.seriesMapping||e&&e.series&&e.series.map(function(){return{x:0}})||[],p;(e&&e.series||[]).forEach(function(u){l.push(o(u.type||a))}),c.forEach(function(u){r.push(u.x||0)}),r.length===0&&r.push(0),c.forEach(function(u){var g=new SeriesBuilder,m=l[d]||o(a),y=e&&e.series||[],v=y[d]||{},x=s(v.type||a),b=x||["y"];for((defined$8(u.x)||v.isCartesian||!x)&&g.addColumnReader(u.x,"x"),objectEach$4(u,function($,S){S!=="x"&&g.addColumnReader($,S)}),p=0;p<m;p++)g.hasReader(b[p])||g.addColumnReader(void 0,b[p]);h.push(g),d++});var f=s(a);typeof f>"u"&&(f=["y"]),this.valueCount={global:o(a),xColumns:r,individual:l,seriesBuilders:h,globalPointArrayMap:f}},n.prototype.dataFound=function(){this.options.switchRowsAndColumns&&(this.columns=this.rowsToColumns(this.columns)),this.getColumnDistribution(),this.parseTypes(),this.parsed()!==!1&&this.complete()},n.prototype.parseCSV=function(e){var t=this,r=e||this.options,o=r.csv,s,a=typeof r.startRow<"u"&&r.startRow?r.startRow:0,l=r.endRow||Number.MAX_VALUE,h=typeof r.startColumn<"u"&&r.startColumn?r.startColumn:0,d=r.endColumn||Number.MAX_VALUE,c,p,f=0,u=[],g={",":0,";":0,"	":0};s=this.columns=[];function m(b,$,S,k){var A=0,M="",P="",E="",T="",O=0,C=0;function I(N){M=b[N],P=b[N-1],E=b[N+1]}function L(N){u.length<C+1&&u.push([N]),u[C][u[C].length-1]!==N&&u[C].push(N)}function D(){if(h>O||O>d){++O,T="";return}!isNaN(parseFloat(T))&&isFinite(T)?(T=parseFloat(T),L("number")):isNaN(Date.parse(T))?L("string"):(T=T.replace(/\//g,"-"),L("date")),s.length<C+1&&s.push([]),s[C][$]=T,T="",++C,++O}if(b.trim().length&&b.trim()[0]!=="#"){for(;A<b.length;A++)if(I(A),M==='"')for(I(++A);A<b.length&&!(M==='"'&&P!=='"'&&E!=='"');)(M!=='"'||M==='"'&&P!=='"')&&(T+=M),I(++A);else M===c?D():T+=M;D()}}function y(b){var $=0,S=0,k=!1;return b.some(function(A,M){var P=!1,E,T,O,C="";if(M>13)return!0;for(var I=0;I<A.length;I++){if(E=A[I],T=A[I+1],O=A[I-1],E==="#")return;if(E==='"')if(P){if(O!=='"'&&T!=='"'){for(;T===" "&&I<A.length;)T=A[++I];typeof g[T]<"u"&&g[T]++,P=!1}}else P=!0;else typeof g[E]<"u"?(C=C.trim(),isNaN(Date.parse(C))?(isNaN(C)||!isFinite(C))&&g[E]++:g[E]++,C=""):C+=E;E===","&&S++,E==="."&&$++}}),g[";"]>g[","]?k=";":(g[","]>g[";"],k=","),r.decimalPoint||($>S?r.decimalPoint=".":r.decimalPoint=",",t.decimalRegex=new RegExp("^(-?[0-9]+)"+r.decimalPoint+"([0-9]+)$")),k}function v(b,$){var S="YYYY/mm/dd",k,A=[],M,P=0,E=!1,T=[],O=[],C;for((!$||$>b.length)&&($=b.length);P<$;P++)if(typeof b[P]<"u"&&b[P]&&b[P].length)for(k=b[P].trim().replace(/\//g," ").replace(/\-/g," ").replace(/\./g," ").split(" "),A=["","",""],C=0;C<k.length;C++)C<A.length&&(k[C]=parseInt(k[C],10),k[C]&&(O[C]=!O[C]||O[C]<k[C]?k[C]:O[C],typeof T[C]<"u"?T[C]!==k[C]&&(T[C]=!1):T[C]=k[C],k[C]>31?k[C]<100?A[C]="YY":A[C]="YYYY":k[C]>12&&k[C]<=31?(A[C]="dd",E=!0):A[C].length||(A[C]="mm")));if(E){for(C=0;C<T.length;C++)T[C]!==!1?O[C]>12&&A[C]!=="YY"&&A[C]!=="YYYY"&&(A[C]="YY"):O[C]>12&&A[C]==="mm"&&(A[C]="dd");return A.length===3&&A[1]==="dd"&&A[2]==="dd"&&(A[2]="YY"),M=A.join("/"),(r.dateFormats||t.dateFormats)[M]?M:(fireEvent$5("deduceDateFailed"),S)}return S}if(o&&r.beforeParse&&(o=r.beforeParse.call(this,o)),o){p=o.replace(/\r\n/g,`
`).replace(/\r/g,`
`).split(r.lineDelimiter||`
`),(!a||a<0)&&(a=0),(!l||l>=p.length)&&(l=p.length-1),r.itemDelimiter?c=r.itemDelimiter:(c=null,c=y(p));var x=0;for(f=a;f<=l;f++)p[f][0]==="#"?x++:m(p[f],f-a-x);(!r.columnTypes||r.columnTypes.length===0)&&u.length&&u[0].length&&u[0][1]==="date"&&!r.dateFormat&&(r.dateFormat=v(s[0])),this.dataFound()}return s},n.prototype.parseTable=function(){var e=this.options,t=e.table,r=this.columns||[],o=e.startRow||0,s=e.endRow||Number.MAX_VALUE,a=e.startColumn||0,l=e.endColumn||Number.MAX_VALUE;return t&&(typeof t=="string"&&(t=doc$1.getElementById(t)),[].forEach.call(t.getElementsByTagName("tr"),function(h,d){d>=o&&d<=s&&[].forEach.call(h.children,function(c,p){var f=r[p-a],u=1;if((c.tagName==="TD"||c.tagName==="TH")&&p>=a&&p<=l)for(r[p-a]||(r[p-a]=[]),r[p-a][d-o]=c.innerHTML;d-o>=u&&f[d-o-u]===void 0;)f[d-o-u]=null,u++})}),this.dataFound()),r},n.prototype.fetchLiveData=function(){var e=this,t=this.chart,r=this.options,o=3,s=0,a=r.enablePolling,l=(r.dataRefreshRate||2)*1e3,h=merge$h(r);if(!this.hasURLOption(r))return!1;l<1e3&&(l=1e3),delete r.csvURL,delete r.rowsURL,delete r.columnsURL;function d(c){function p(f,u,g){if(!f||!/^(http|\/|\.\/|\.\.\/)/.test(f))return f&&r.error&&r.error("Invalid URL"),!1;c&&(clearTimeout(e.liveDataTimeout),t.liveDataURL=f);function m(){a&&t.liveDataURL===f&&(e.liveDataTimeout=setTimeout(d,l))}return ajax({url:f,dataType:g||"json",success:function(y){t&&t.series&&u(y),m()},error:function(y,v){return++s<o&&m(),r.error&&r.error(v,y)}}),!0}p(h.csvURL,function(f){t.update({data:{csv:f}})},"text")||p(h.rowsURL,function(f){t.update({data:{rows:f}})})||p(h.columnsURL,function(f){t.update({data:{columns:f}})})}return d(!0),this.hasURLOption(r)},n.prototype.parseGoogleSpreadsheet=function(){var e=this,t=this.options,r=t.googleSpreadsheetKey,o=this.chart,s=Math.max((t.dataRefreshRate||2)*1e3,4e3),a=function(){if(t.googleSpreadsheetRange)return t.googleSpreadsheetRange;var h="ABCDEFGHIJKLMNOPQRSTUVWXYZ",d=(h.charAt(t.startColumn||0)||"A")+((t.startRow||0)+1),c=h.charAt(pick$j(t.endColumn,-1))||"ZZ";return defined$8(t.endRow)&&(c+=t.endRow+1),d+":"+c};function l(h){var d=["https://sheets.googleapis.com/v4/spreadsheets",r,"values",a(),"?alt=json&majorDimension=COLUMNS&valueRenderOption=UNFORMATTED_VALUE&dateTimeRenderOption=FORMATTED_STRING&key="+t.googleAPIKey].join("/");ajax({url:d,dataType:"json",success:function(c){h(c),t.enablePolling&&setTimeout(function(){l(h)},s)},error:function(c,p){return t.error&&t.error(p,c)}})}return r&&(delete t.googleSpreadsheetKey,l(function(h){var d=h.values;if(!d||d.length===0)return!1;var c=d.reduce(function(p,f){return Math.max(p,f.length)},0);d.forEach(function(p){for(var f=0;f<c;f++)typeof p[f]>"u"&&(p[f]=null)}),o&&o.series?o.update({data:{columns:d}}):(e.columns=d,e.dataFound())})),!1},n.prototype.trim=function(e,t){return typeof e=="string"&&(e=e.replace(/^\s+|\s+$/g,""),t&&/^[0-9\s]+$/.test(e)&&(e=e.replace(/\s/g,"")),this.decimalRegex&&(e=e.replace(this.decimalRegex,"$1.$2"))),e},n.prototype.parseTypes=function(){for(var e=this.columns,t=e.length;t--;)this.parseColumn(e[t],t)},n.prototype.parseColumn=function(e,t){var r=this.rawColumns,o=this.columns,s=e.length,a,l,h,d,c=this.firstRowAsNames,p=this.valueCount.xColumns.indexOf(t)!==-1,f,u=[],g,m=this.chartOptions,y,v=this.options.columnTypes||[],x=v[t],b=p&&(m&&m.xAxis&&splat$1(m.xAxis)[0].type==="category"||x==="string");for(r[t]||(r[t]=[]);s--;)a=u[s]||e[s],h=this.trim(a),d=this.trim(a,!0),l=parseFloat(d),typeof r[t][s]>"u"&&(r[t][s]=h),b||s===0&&c?e[s]=""+h:+d===l?(e[s]=l,l>365*24*3600*1e3&&x!=="float"?e.isDatetime=!0:e.isNumeric=!0,typeof e[s+1]<"u"&&(y=l>e[s+1])):(h&&h.length&&(f=this.parseDate(a)),p&&isNumber$8(f)&&x!=="float"?(u[s]=a,e[s]=f,e.isDatetime=!0,typeof e[s+1]<"u"&&(g=f>e[s+1],g!==y&&typeof y<"u"&&(this.alternativeFormat?(this.dateFormat=this.alternativeFormat,s=e.length,this.alternativeFormat=this.dateFormats[this.dateFormat].alternative):e.unsorted=!0),y=g)):(e[s]=h===""?null:h,s!==0&&(e.isDatetime||e.isNumeric)&&(e.mixed=!0)));if(p&&e.mixed&&(o[t]=r[t]),p&&y&&this.options.sort)for(t=0;t<o.length;t++)o[t].reverse(),c&&o[t].unshift(o[t].pop())},n.prototype.parseDate=function(e){var t=this.options.parseDate,r,o,s,a=this.options.dateFormat||this.dateFormat,l;if(t)r=t(e);else if(typeof e=="string"){if(a)s=this.dateFormats[a],s||(s=this.dateFormats["YYYY/mm/dd"]),l=e.match(s.regex),l&&(r=s.parser(l));else for(o in this.dateFormats)if(s=this.dateFormats[o],l=e.match(s.regex),l){this.dateFormat=a=o,this.alternativeFormat=s.alternative,r=s.parser(l);break}l||(e.match(/:.+(GMT|UTC|[Z+-])/)&&(e=e.replace(/\s*(?:GMT|UTC)?([+-])(\d\d)(\d\d)$/,"$1$2:$3").replace(/(?:\s+|GMT|UTC)([+-])/,"$1").replace(/(\d)\s*(?:GMT|UTC|Z)$/,"$1+00:00")),l=Date.parse(e),typeof l=="object"&&l!==null&&l.getTime?r=l.getTime()-l.getTimezoneOffset()*6e4:isNumber$8(l)&&(r=l-new Date(l).getTimezoneOffset()*6e4))}return r},n.prototype.rowsToColumns=function(e){var t,r,o,s,a;if(e)for(a=[],r=e.length,t=0;t<r;t++)for(s=e[t].length,o=0;o<s;o++)a[o]||(a[o]=[]),a[o][t]=e[t][o];return a},n.prototype.getData=function(){if(this.columns)return this.rowsToColumns(this.columns).slice(1)},n.prototype.parsed=function(){if(this.options.parsed)return this.options.parsed.call(this,this.columns)},n.prototype.getFreeIndexes=function(e,t){var r,o,s=[],a=[],l;for(o=0;o<e;o=o+1)s.push(!0);for(r=0;r<t.length;r=r+1)for(l=t[r].getReferencedColumnIndexes(),o=0;o<l.length;o=o+1)s[l[o]]=!1;for(o=0;o<s.length;o=o+1)s[o]&&a.push(o);return a},n.prototype.complete=function(){var e=this.columns,t,r=this.options,o,s,a,l,h,d,c,p=[],f,u,g,m;if(e.length,r.complete||r.afterComplete){if(this.firstRowAsNames)for(a=0;a<e.length;a++)e[a].name=e[a].shift();for(o=[],u=this.getFreeIndexes(e.length,this.valueCount.seriesBuilders),d=0;d<this.valueCount.seriesBuilders.length;d++)f=this.valueCount.seriesBuilders[d],f.populateColumns(u)&&p.push(f);for(;u.length>0;){for(f=new SeriesBuilder,f.addColumnReader(0,"x"),m=u.indexOf(0),m!==-1&&u.splice(m,1),a=0;a<this.valueCount.global;a++)f.addColumnReader(void 0,this.valueCount.globalPointArrayMap[a]);f.populateColumns(u)&&p.push(f)}if(p.length>0&&p[0].readers.length>0&&(g=e[p[0].readers[0].columnIndex],typeof g<"u"&&(g.isDatetime?t="datetime":g.isNumeric||(t="category"))),t==="category")for(d=0;d<p.length;d++)for(f=p[d],h=0;h<f.readers.length;h++)f.readers[h].configName==="x"&&(f.readers[h].configName="name");for(d=0;d<p.length;d++){for(f=p[d],s=[],l=0;l<e[0].length;l++)s[l]=f.read(e,l);o[d]={data:s},f.name&&(o[d].name=f.name),t==="category"&&(o[d].turboThreshold=0)}c={series:o},t&&(c.xAxis={type:t},t==="category"&&(c.xAxis.uniqueNames=!1)),r.complete&&r.complete(c),r.afterComplete&&r.afterComplete(c)}},n.prototype.update=function(e,t){var r=this.chart;e&&(e.afterComplete=function(o){o&&(o.xAxis&&r.xAxis[0]&&o.xAxis.type===r.xAxis[0].options.type&&delete o.xAxis,r.update(o,t,!0))},merge$h(!0,r.options.data,e),this.init(r.options.data))},n}();H.data=function(n,e,t){return new H.Data(n,e,t)};addEvent$b(Chart$1,"init",function(n){var e=this,t=n.args[0]||{},r=n.args[1];t&&t.data&&!e.hasDataDef&&(e.hasDataDef=!0,e.data=new H.Data(extend$m(t.data,{afterComplete:function(o){var s,a;if(Object.hasOwnProperty.call(t,"series"))if(typeof t.series=="object")for(s=Math.max(t.series.length,o&&o.series?o.series.length:0);s--;)a=t.series[s]||{},t.series[s]=merge$h(a,o&&o.series?o.series[s]:{});else delete t.series;t=merge$h(o,t),e.init(t,r)}}),t,e),n.preventDefault())});var SeriesBuilder=function(){function n(){this.readers=[],this.pointIsArray=!0,this.name=void 0}return n.prototype.populateColumns=function(e){var t=this,r=!0;return t.readers.forEach(function(o){typeof o.columnIndex>"u"&&(o.columnIndex=e.shift())}),t.readers.forEach(function(o){typeof o.columnIndex>"u"&&(r=!1)}),r},n.prototype.read=function(e,t){var r=this,o=r.pointIsArray,s=o?[]:{},a;return r.readers.forEach(function(l){var h=e[l.columnIndex][t];o?s.push(h):l.configName.indexOf(".")>0?Point$2.prototype.setNestedProperty(s,h,l.configName):s[l.configName]=h}),typeof this.name>"u"&&r.readers.length>=2&&(a=r.getReferencedColumnIndexes(),a.length>=2&&(a.shift(),a.sort(function(l,h){return l-h}),this.name=e[a.shift()].name)),s},n.prototype.addColumnReader=function(e,t){this.readers.push({columnIndex:e,configName:t}),t==="x"||t==="y"||typeof t>"u"||(this.pointIsArray=!1)},n.prototype.getReferencedColumnIndexes=function(){var e,t=[],r;for(e=0;e<this.readers.length;e=e+1)r=this.readers[e],typeof r.columnIndex<"u"&&t.push(r.columnIndex);return t},n.prototype.hasReader=function(e){var t,r;for(t=0;t<this.readers.length;t=t+1)if(r=this.readers[t],r.configName===e)return!0},n}();H.Data=Data;H.Data;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/data
 * @requires highcharts
 *
 * Data module
 *
 * (c) 2012-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$2=H;G$2.HttpUtilities=exports$2;G$2.ajax=exports$2.ajax;G$2.getJSON=exports$2.getJSON;G$2.post=exports$2.post;var animObject=animationExports.animObject,format=FormatUtilities.format,noop$4=H.noop,defaultOptions$2=DefaultOptions.defaultOptions,seriesTypes$1=SeriesRegistry$1.seriesTypes,addEvent$a=Utilities.addEvent,removeEvent$1=Utilities.removeEvent,extend$l=Utilities.extend,fireEvent$4=Utilities.fireEvent,merge$g=Utilities.merge,objectEach$3=Utilities.objectEach,pick$i=Utilities.pick,syncTimeout=Utilities.syncTimeout,PieSeries$1=seriesTypes$1.pie,ddSeriesId=1;extend$l(defaultOptions$2.lang,{drillUpText:"◁ Back to {series.name}"});defaultOptions$2.drilldown={activeAxisLabelStyle:{cursor:"pointer",color:palette.highlightColor100,fontWeight:"bold",textDecoration:"underline"},activeDataLabelStyle:{cursor:"pointer",color:palette.highlightColor100,fontWeight:"bold",textDecoration:"underline"},animation:{duration:500},drillUpButton:{position:{align:"right",x:-10,y:10}}};SVGRenderer.prototype.Element.prototype.fadeIn=function(n){this.attr({opacity:.1,visibility:"inherit"}).animate({opacity:pick$i(this.newOpacity,1)},n||{duration:250})};Chart$1.prototype.addSeriesAsDrilldown=function(n,e){this.addSingleSeriesAsDrilldown(n,e),this.applyDrilldown()};Chart$1.prototype.addSingleSeriesAsDrilldown=function(n,e){var t=n.series,r=t.xAxis,o=t.yAxis,s,a,l=[],h=[],d,c,p,f;f=this.styledMode?{colorIndex:pick$i(n.colorIndex,t.colorIndex)}:{color:n.color||t.color},this.drilldownLevels||(this.drilldownLevels=[]),c=t.options._levelNumber||0,p=this.drilldownLevels[this.drilldownLevels.length-1],p&&p.levelNumber!==c&&(p=void 0),e=extend$l(extend$l({_ddSeriesId:ddSeriesId++},f),e),a=t.points.indexOf(n),t.chart.series.forEach(function(u){u.xAxis===r&&!u.isDrilling&&(u.options._ddSeriesId=u.options._ddSeriesId||ddSeriesId++,u.options._colorIndex=u.userOptions._colorIndex,u.options._levelNumber=u.options._levelNumber||c,p?(l=p.levelSeries,h=p.levelSeriesOptions):(l.push(u),u.purgedOptions=merge$g({_ddSeriesId:u.options._ddSeriesId,_levelNumber:u.options._levelNumber,selected:u.options.selected},u.userOptions),h.push(u.purgedOptions)))}),d=extend$l({levelNumber:c,seriesOptions:t.options,seriesPurgedOptions:t.purgedOptions,levelSeriesOptions:h,levelSeries:l,shapeArgs:n.shapeArgs,bBox:n.graphic?n.graphic.getBBox():{},color:n.isNull?Color.parse(f.color).setOpacity(0).get():f.color,lowerSeriesOptions:e,pointOptions:t.options.data[a],pointIndex:a,oldExtremes:{xMin:r&&r.userMin,xMax:r&&r.userMax,yMin:o&&o.userMin,yMax:o&&o.userMax},resetZoomButton:this.resetZoomButton},f),this.drilldownLevels.push(d),r&&r.names&&(r.names.length=0),s=d.lowerSeries=this.addSeries(e,!1),s.options._levelNumber=c+1,r&&(r.oldPos=r.pos,r.userMin=r.userMax=null,o.userMin=o.userMax=null),t.type===s.type&&(s.animate=s.animateDrilldown||noop$4,s.options.animation=!0)};Chart$1.prototype.applyDrilldown=function(){var n=this.drilldownLevels,e;n&&n.length>0&&(e=n[n.length-1].levelNumber,this.drilldownLevels.forEach(function(t){t.levelNumber===e&&t.levelSeries.forEach(function(r){r.options&&r.options._levelNumber===e&&r.remove(!1)})})),this.resetZoomButton&&(this.resetZoomButton.hide(),delete this.resetZoomButton),this.pointer.reset(),this.redraw(),this.showDrillUpButton(),fireEvent$4(this,"afterDrilldown")};Chart$1.prototype.getDrilldownBackText=function(){var n=this.drilldownLevels,e;if(n&&n.length>0)return e=n[n.length-1],e.series=e.seriesOptions,format(this.options.lang.drillUpText||"",e)};Chart$1.prototype.showDrillUpButton=function(){var n=this,e=this.getDrilldownBackText(),t=n.options.drilldown.drillUpButton,r,o,s=t.relativeTo==="chart"||t.relativeTo==="spacingBox"?null:"scrollablePlotBox";this.drillUpButton?this.drillUpButton.attr({text:e}).align():(r=t.theme,o=r&&r.states,this.drillUpButton=this.renderer.button(e,null,null,function(){n.drillUp()},r,o&&o.hover,o&&o.select).addClass("highcharts-drillup-button").attr({align:t.position.align,zIndex:7}).add().align(t.position,!1,s))};Chart$1.prototype.drillUp=function(){if(!(!this.drilldownLevels||this.drilldownLevels.length===0)){for(var n=this,e=n.drilldownLevels,t=e[e.length-1].levelNumber,r=e.length,o=n.series,s,a,l,h,d,c=function(p){var f;o.forEach(function(u){u.options._ddSeriesId===p._ddSeriesId&&(f=u)}),f=f||n.addSeries(p,!1),f.type===l.type&&f.animateDrillupTo&&(f.animate=f.animateDrillupTo),p===a.seriesPurgedOptions&&(h=f)};r--;)if(a=e[r],a.levelNumber===t){if(e.pop(),l=a.lowerSeries,!l.chart){for(s=o.length;s--;)if(o[s].options.id===a.lowerSeriesOptions.id&&o[s].options._levelNumber===t+1){l=o[s];break}}l.xData=[],a.levelSeriesOptions.forEach(c),fireEvent$4(n,"drillup",{seriesOptions:a.seriesPurgedOptions||a.seriesOptions}),this.resetZoomButton&&this.resetZoomButton.destroy(),h.type===l.type&&(h.drilldownLevel=a,h.options.animation=n.options.drilldown.animation,l.animateDrillupFrom&&l.chart&&l.animateDrillupFrom(a)),h.options._levelNumber=t,l.remove(!1),h.xAxis&&(d=a.oldExtremes,h.xAxis.setExtremes(d.xMin,d.xMax,!1),h.yAxis.setExtremes(d.yMin,d.yMax,!1)),a.resetZoomButton&&(n.resetZoomButton=a.resetZoomButton,n.resetZoomButton.show())}this.redraw(),this.drilldownLevels.length===0?this.drillUpButton=this.drillUpButton.destroy():this.drillUpButton.attr({text:this.getDrilldownBackText()}).align(),this.ddDupes.length=[],fireEvent$4(n,"drillupall")}};addEvent$a(Chart$1,"afterInit",function(){var n=this;n.drilldown={update:function(e,t){merge$g(!0,n.options.drilldown,e),pick$i(t,!0)&&n.redraw()}}});addEvent$a(Chart$1,"afterShowResetZoom",function(){var n=this,e=n.resetZoomButton&&n.resetZoomButton.getBBox(),t=n.options.drilldown&&n.options.drilldown.drillUpButton;this.drillUpButton&&e&&t&&t.position&&t.position.x&&this.drillUpButton.align({x:t.position.x-e.width-10,y:t.position.y,align:t.position.align},!1,t.relativeTo||"plotBox")});addEvent$a(Chart$1,"render",function(){(this.xAxis||[]).forEach(function(n){n.ddPoints={},n.series.forEach(function(e){var t,r=e.xData||[],o=e.points,s;for(t=0;t<r.length;t++)if(s=e.options.data[t],typeof s!="number"&&(s=e.pointClass.prototype.optionsToObject.call({series:e},s),s.drilldown)){n.ddPoints[r[t]]||(n.ddPoints[r[t]]=[]);var a=t-(e.cropStart||0);n.ddPoints[r[t]].push(o&&a>=0&&a<o.length?o[a]:!0)}}),objectEach$3(n.ticks,Tick.prototype.drillable)})});ColumnSeries$h.prototype.animateDrillupTo=function(n){if(!n){var e=this,t=e.drilldownLevel;this.points.forEach(function(r){var o=r.dataLabel;r.graphic&&r.graphic.hide(),o&&(o.hidden=o.attr("visibility")==="hidden",o.hidden||(o.hide(),r.connector&&r.connector.hide()))}),syncTimeout(function(){if(e.points){var r=[];e.data.forEach(function(o){r.push(o)}),e.nodes&&(r=r.concat(e.nodes)),r.forEach(function(o,s){var a=s===(t&&t.pointIndex)?"show":"fadeIn",l=a==="show"?!0:void 0,h=o.dataLabel;o.graphic&&o.graphic[a](l),h&&!h.hidden&&(h.fadeIn(),o.connector&&o.connector.fadeIn())})}},Math.max(this.chart.options.drilldown.animation.duration-50,0)),delete this.animate}};ColumnSeries$h.prototype.animateDrilldown=function(n){var e=this,t=this.chart,r=t.drilldownLevels,o,s=animObject(t.options.drilldown.animation),a=this.xAxis,l=t.styledMode;n||(r.forEach(function(h){e.options._ddSeriesId===h.lowerSeriesOptions._ddSeriesId&&(o=h.shapeArgs,l||(o.fill=h.color))}),o.x+=pick$i(a.oldPos,a.pos)-a.pos,this.points.forEach(function(h){var d=h.shapeArgs;l||(d.fill=h.color),h.graphic&&h.graphic.attr(o).animate(extend$l(h.shapeArgs,{fill:h.color||e.color}),s),h.dataLabel&&h.dataLabel.fadeIn(s)}),delete this.animate)};ColumnSeries$h.prototype.animateDrillupFrom=function(n){var e=animObject(this.chart.options.drilldown.animation),t=this.group,r=t!==this.chart.columnGroup,o=this;o.trackerGroups.forEach(function(s){o[s]&&o[s].on("mouseover")}),r&&delete this.group,this.points.forEach(function(s){var a=s.graphic,l=n.shapeArgs,h=function(){a.destroy(),t&&r&&(t=t.destroy())};a&&l&&(delete s.graphic,o.chart.styledMode||(l.fill=n.color),e.duration?a.animate(l,merge$g(e,{complete:h})):(a.attr(l),h()))})};PieSeries$1&&extend$l(PieSeries$1.prototype,{animateDrillupTo:ColumnSeries$h.prototype.animateDrillupTo,animateDrillupFrom:ColumnSeries$h.prototype.animateDrillupFrom,animateDrilldown:function(n){var e=this.chart.drilldownLevels[this.chart.drilldownLevels.length-1],t=this.chart.options.drilldown.animation;if(this.is("item")&&(t.duration=0),this.center){var r=e.shapeArgs,o=r.start,s=r.end-o,a=s/this.points.length,l=this.chart.styledMode;n||(this.points.forEach(function(h,d){var c=h.shapeArgs;l||(r.fill=e.color,c.fill=h.color),h.graphic&&h.graphic.attr(merge$g(r,{start:o+d*a,end:o+(d+1)*a}))[t?"animate":"attr"](c,t)}),delete this.animate)}}});Point$2.prototype.doDrilldown=function(){this.runDrilldown()};Point$2.prototype.runDrilldown=function(n,e,t){var r=this.series,o=r.chart,s=o.options.drilldown,a=(s.series||[]).length,l;for(o.ddDupes||(o.ddDupes=[]);a--&&!l;)s.series[a].id===this.drilldown&&o.ddDupes.indexOf(this.drilldown)===-1&&(l=s.series[a],o.ddDupes.push(this.drilldown));fireEvent$4(o,"drilldown",{point:this,seriesOptions:l,category:e,originalEvent:t,points:typeof e<"u"&&this.series.xAxis.getDDPoints(e).slice(0)},function(h){var d=h.point.series&&h.point.series.chart,c=h.seriesOptions;d&&c&&(n?d.addSingleSeriesAsDrilldown(h.point,c):d.addSeriesAsDrilldown(h.point,c))})};Axis.prototype.drilldownCategory=function(n,e){this.getDDPoints(n).forEach(function(t){t&&t.series&&t.series.visible&&t.runDrilldown&&t.runDrilldown(!0,n,e)}),this.chart.applyDrilldown()};Axis.prototype.getDDPoints=function(n){return this.ddPoints&&this.ddPoints[n]||[]};Tick.prototype.drillable=function(){var n=this.pos,e=this.label,t=this.axis,r=t.coll==="xAxis"&&t.getDDPoints,o=r&&t.getDDPoints(n),s=t.chart.styledMode;r&&(e&&o&&o.length?(e.drillable=!0,!e.basicStyles&&!s&&(e.basicStyles=merge$g(e.styles)),e.addClass("highcharts-drilldown-axis-label"),e.removeOnDrillableClick&&removeEvent$1(e.element,"click"),e.removeOnDrillableClick=addEvent$a(e.element,"click",function(a){a.preventDefault(),t.drilldownCategory(n,a)}),s||e.css(t.chart.options.drilldown.activeAxisLabelStyle)):e&&e.drillable&&e.removeOnDrillableClick&&(s||(e.styles={},e.css(e.basicStyles)),e.removeOnDrillableClick(),e.removeClass("highcharts-drilldown-axis-label")))};addEvent$a(Point$2,"afterInit",function(){var n=this;return n.drilldown&&!n.unbindDrilldownClick&&(n.unbindDrilldownClick=addEvent$a(n,"click",handlePointClick)),n});addEvent$a(Point$2,"update",function(n){var e=this,t=n.options||{};t.drilldown&&!e.unbindDrilldownClick?e.unbindDrilldownClick=addEvent$a(e,"click",handlePointClick):!t.drilldown&&t.drilldown!==void 0&&e.unbindDrilldownClick&&(e.unbindDrilldownClick=e.unbindDrilldownClick())});var handlePointClick=function(n){var e=this,t=e.series;t.xAxis&&t.chart.options.drilldown.allowPointDrilldown===!1?t.xAxis.drilldownCategory(e.x,n):e.runDrilldown(void 0,void 0,n)};addEvent$a(Series$e,"afterDrawDataLabels",function(){var n=this.chart.options.drilldown.activeDataLabelStyle,e=this.chart.renderer,t=this.chart.styledMode;this.points.forEach(function(r){var o=r.options.dataLabels,s=pick$i(r.dlOptions,o&&o.style,{});r.drilldown&&r.dataLabel&&(n.color==="contrast"&&!t&&(s.color=e.getContrast(r.color||this.color)),o&&o.color&&(s.color=o.color),r.dataLabel.addClass("highcharts-drilldown-data-label"),t||r.dataLabel.css(n).css(s))},this)});var applyCursorCSS=function(n,e,t,r){n[t?"addClass":"removeClass"]("highcharts-drilldown-point"),r||n.css({cursor:e})};addEvent$a(Series$e,"afterDrawTracker",function(){var n=this.chart.styledMode;this.points.forEach(function(e){e.drilldown&&e.graphic&&applyCursorCSS(e.graphic,"pointer",!0,n)})});addEvent$a(Point$2,"afterSetState",function(){var n=this.series.chart.styledMode;this.drilldown&&this.series.halo&&this.state==="hover"?applyCursorCSS(this.series.halo,"pointer",!0,n):this.series.halo&&applyCursorCSS(this.series.halo,"auto",!1,n)});addEvent$a(Chart$1,"selection",function(n){if(n.resetSelection===!0&&this.drillUpButton){var e=this.options.drilldown&&this.options.drilldown.drillUpButton;e&&e.position&&this.drillUpButton.align({x:e.position.x,y:e.position.y,align:e.position.align},!1,e.relativeTo||"plotBox")}});addEvent$a(Chart$1,"drillup",function(){this.resetZoomButton&&(this.resetZoomButton=this.resetZoomButton.destroy())});H.doc;var addEvent$9=Utilities.addEvent,Fullscreen=function(){function n(e){this.chart=e,this.isOpen=!1;var t=e.renderTo;this.browserProps||(typeof t.requestFullscreen=="function"?this.browserProps={fullscreenChange:"fullscreenchange",requestFullscreen:"requestFullscreen",exitFullscreen:"exitFullscreen"}:t.mozRequestFullScreen?this.browserProps={fullscreenChange:"mozfullscreenchange",requestFullscreen:"mozRequestFullScreen",exitFullscreen:"mozCancelFullScreen"}:t.webkitRequestFullScreen?this.browserProps={fullscreenChange:"webkitfullscreenchange",requestFullscreen:"webkitRequestFullScreen",exitFullscreen:"webkitExitFullscreen"}:t.msRequestFullscreen&&(this.browserProps={fullscreenChange:"MSFullscreenChange",requestFullscreen:"msRequestFullscreen",exitFullscreen:"msExitFullscreen"}))}return n.prototype.close=function(){var e=this,t=e.chart,r=t.options.chart;e.isOpen&&e.browserProps&&t.container.ownerDocument instanceof Document&&t.container.ownerDocument[e.browserProps.exitFullscreen](),e.unbindFullscreenEvent&&(e.unbindFullscreenEvent=e.unbindFullscreenEvent()),t.setSize(e.origWidth,e.origHeight,!1),e.origWidth=void 0,e.origHeight=void 0,r.width=e.origWidthOption,r.height=e.origHeightOption,e.origWidthOption=void 0,e.origHeightOption=void 0,e.isOpen=!1,e.setButtonText()},n.prototype.open=function(){var e=this,t=e.chart,r=t.options.chart;if(r&&(e.origWidthOption=r.width,e.origHeightOption=r.height),e.origWidth=t.chartWidth,e.origHeight=t.chartHeight,e.browserProps){var o=addEvent$9(t.container.ownerDocument,e.browserProps.fullscreenChange,function(){e.isOpen?(e.isOpen=!1,e.close()):(t.setSize(null,null,!1),e.isOpen=!0,e.setButtonText())}),s=addEvent$9(t,"destroy",o);e.unbindFullscreenEvent=function(){o(),s()};var a=t.renderTo[e.browserProps.requestFullscreen]();a&&a.catch(function(){alert("Full screen is not supported inside a frame.")})}},n.prototype.setButtonText=function(){var e=this.chart,t=e.exportDivElements,r=e.options.exporting,o=r&&r.buttons&&r.buttons.contextButton.menuItems,s=e.options.lang;if(r&&r.menuItemDefinitions&&s&&s.exitFullscreen&&s.viewFullscreen&&o&&t){var a=t[o.indexOf("viewFullscreen")];a&&AST.setElementHTML(a,this.isOpen?s.exitFullscreen:r.menuItemDefinitions.viewFullscreen.text||s.viewFullscreen)}},n.prototype.toggle=function(){var e=this;e.isOpen?e.close():e.open()},n}();H.Fullscreen=Fullscreen;H.Fullscreen;addEvent$9(Chart$1,"beforeRender",function(){this.fullscreen=new H.Fullscreen(this)});var isTouchDevice=H.isTouchDevice,exporting={type:"image/png",url:"https://export.highcharts.com/",printMaxWidth:780,scale:2,buttons:{contextButton:{className:"highcharts-contextbutton",menuClassName:"highcharts-contextmenu",symbol:"menu",titleKey:"contextButtonTitle",menuItems:["viewFullscreen","printChart","separator","downloadPNG","downloadJPEG","downloadPDF","downloadSVG"]}},menuItemDefinitions:{viewFullscreen:{textKey:"viewFullscreen",onclick:function(){this.fullscreen.toggle()}},printChart:{textKey:"printChart",onclick:function(){this.print()}},separator:{separator:!0},downloadPNG:{textKey:"downloadPNG",onclick:function(){this.exportChart()}},downloadJPEG:{textKey:"downloadJPEG",onclick:function(){this.exportChart({type:"image/jpeg"})}},downloadPDF:{textKey:"downloadPDF",onclick:function(){this.exportChart({type:"application/pdf"})}},downloadSVG:{textKey:"downloadSVG",onclick:function(){this.exportChart({type:"image/svg+xml"})}}}},lang={viewFullscreen:"View in full screen",exitFullscreen:"Exit from full screen",printChart:"Print chart",downloadPNG:"Download PNG image",downloadJPEG:"Download JPEG image",downloadPDF:"Download PDF document",downloadSVG:"Download SVG vector image",contextButtonTitle:"Chart context menu"},navigation={buttonOptions:{symbolSize:14,symbolX:12.5,symbolY:10.5,align:"right",buttonSpacing:3,height:22,verticalAlign:"top",width:24,symbolFill:palette.neutralColor60,symbolStroke:palette.neutralColor60,symbolStrokeWidth:3,theme:{padding:5}},menuStyle:{border:"1px solid "+palette.neutralColor40,background:palette.backgroundColor,padding:"5px 0"},menuItemStyle:{padding:"0.5em 1em",color:palette.neutralColor80,background:"none",fontSize:isTouchDevice?"14px":"11px",transition:"background 250ms, color 250ms"},menuItemHoverStyle:{background:palette.highlightColor80,color:palette.backgroundColor}},ExportingDefaults={exporting,lang,navigation},ExportingSymbols;(function(n){var e=[];function t(s){if(e.indexOf(s)===-1){e.push(s);var a=s.prototype.symbols;a.menu=r,a.menuball=o.bind(a)}}n.compose=t;function r(s,a,l,h){var d=[["M",s,a+2.5],["L",s+l,a+2.5],["M",s,a+h/2+.5],["L",s+l,a+h/2+.5],["M",s,a+h-1.5],["L",s+l,a+h-1.5]];return d}function o(s,a,l,h){var d=h/3-2,c=[];return c=c.concat(this.circle(l-d,a,d,d),this.circle(l-d,a+d+4,d,d),this.circle(l-d,a+2*(d+4),d,d)),c}})(ExportingSymbols||(ExportingSymbols={}));const ExportingSymbols$1=ExportingSymbols;var defaultOptions$1=DefaultOptions.defaultOptions,doc=H.doc,win$1=H.win,addEvent$8=Utilities.addEvent,css$1=Utilities.css,createElement=Utilities.createElement,discardElement=Utilities.discardElement,extend$k=Utilities.extend,find$3=Utilities.find,fireEvent$3=Utilities.fireEvent,isObject$4=Utilities.isObject,merge$f=Utilities.merge,objectEach$2=Utilities.objectEach,pick$h=Utilities.pick,removeEvent=Utilities.removeEvent,uniqueKey=Utilities.uniqueKey,Exporting;(function(n){var e=[],t=[/-/,/^(clipPath|cssText|d|height|width)$/,/^font$/,/[lL]ogical(Width|Height)$/,/perspective/,/TapHighlightColor/,/^transition/,/^length$/],r=["fill","stroke","strokeLinecap","strokeLinejoin","strokeWidth","textAnchor","x","y"];n.inlineWhitelist=[];var o=["clipPath","defs","desc"],s;function a(P){var E=this,T=E.renderer,O=merge$f(E.options.navigation.buttonOptions,P),C=O.onclick,I=O.menuItems,L=O.symbolSize||12,D;if(E.btnCount||(E.btnCount=0),E.exportDivElements||(E.exportDivElements=[],E.exportSVGElements=[]),!(O.enabled===!1||!O.theme)){var N=O.theme,B=N.states,X=B&&B.hover,W=B&&B.select,F;E.styledMode||(N.fill=pick$h(N.fill,palette.backgroundColor),N.stroke=pick$h(N.stroke,"none")),delete N.states,C?F=function(z){z&&z.stopPropagation(),C.call(E,z)}:I&&(F=function(z){z&&z.stopPropagation(),E.contextMenu(U.menuClassName,I,U.translateX,U.translateY,U.width,U.height,U),U.setState(2)}),O.text&&O.symbol?N.paddingLeft=pick$h(N.paddingLeft,30):O.text||extend$k(N,{width:O.width,height:O.height,padding:0}),E.styledMode||(N["stroke-linecap"]="round",N.fill=pick$h(N.fill,palette.backgroundColor),N.stroke=pick$h(N.stroke,"none"));var U=T.button(O.text,0,0,F,N,X,W).addClass(P.className).attr({title:pick$h(E.options.lang[O._titleKey||O.titleKey],"")});U.menuClassName=P.menuClassName||"highcharts-menu-"+E.btnCount++,O.symbol&&(D=T.symbol(O.symbol,O.symbolX-L/2,O.symbolY-L/2,L,L,{width:L,height:L}).addClass("highcharts-button-symbol").attr({zIndex:1}).add(U),E.styledMode||D.attr({stroke:O.symbolStroke,fill:O.symbolFill,"stroke-width":O.symbolStrokeWidth||1})),U.add(E.exportingGroup).align(extend$k(O,{width:U.width,x:pick$h(O.x,E.buttonOffset)}),!0,"spacingBox"),E.buttonOffset+=(U.width+O.buttonSpacing)*(O.align==="right"?-1:1),E.exportSVGElements.push(U,D)}}function l(){var P=this;if(P.printReverseInfo){var E=P.printReverseInfo,T=E.childNodes,O=E.origDisplay,C=E.resetParams;P.moveContainers(P.renderTo),[].forEach.call(T,function(I,L){I.nodeType===1&&(I.style.display=O[L]||"")}),P.isPrinting=!1,C&&P.setSize.apply(P,C),delete P.printReverseInfo,s=void 0,fireEvent$3(P,"afterPrint")}}function h(){var P=this,E=doc.body,T=P.options.exporting.printMaxWidth,O={childNodes:E.childNodes,origDisplay:[],resetParams:void 0};P.isPrinting=!0,P.pointer.reset(null,0),fireEvent$3(P,"beforePrint");var C=T&&P.chartWidth>T;C&&(O.resetParams=[P.options.chart.width,void 0,!1],P.setSize(T,void 0,!1)),[].forEach.call(O.childNodes,function(I,L){I.nodeType===1&&(O.origDisplay[L]=I.style.display,I.style.display="none")}),P.moveContainers(E),P.printReverseInfo=O}function d(P){var E=P;E.renderExporting(),addEvent$8(P,"redraw",E.renderExporting),addEvent$8(P,"destroy",E.destroyExport)}function c(P,E){if(ExportingSymbols$1.compose(E),e.indexOf(P)===-1){e.push(P);var T=P.prototype;T.afterPrint=l,T.exportChart=u,T.inlineStyles=b,T.print=k,T.sanitizeSVG=M,T.getChartHTML=g,T.getSVG=y,T.getSVGForExport=v,T.getFilename=m,T.moveContainers=$,T.beforePrint=h,T.contextMenu=p,T.addButton=a,T.destroyExport=f,T.renderExporting=A,T.callbacks.push(d),addEvent$8(P,"init",S),H.isSafari&&H.win.matchMedia("print").addListener(function(O){s&&(O.matches?s.beforePrint():s.afterPrint())})}}n.compose=c;function p(P,E,T,O,C,I,L){var D=this,N=D.options.navigation,B=D.chartWidth,X=D.chartHeight,W="cache-"+P,F=Math.max(C,I),U,z=D[W];z||(D.exportContextMenu=D[W]=z=createElement("div",{className:P},{position:"absolute",zIndex:1e3,padding:F+"px",pointerEvents:"auto"},D.fixedDiv||D.container),U=createElement("ul",{className:"highcharts-menu"},{listStyle:"none",margin:0,padding:0},z),D.styledMode||css$1(U,extend$k({MozBoxShadow:"3px 3px 10px #888",WebkitBoxShadow:"3px 3px 10px #888",boxShadow:"3px 3px 10px #888"},N.menuStyle)),z.hideMenu=function(){css$1(z,{display:"none"}),L&&L.setState(0),D.openMenu=!1,css$1(D.renderTo,{overflow:"hidden"}),css$1(D.container,{overflow:"hidden"}),Utilities.clearTimeout(z.hideTimer),fireEvent$3(D,"exportMenuHidden")},D.exportEvents.push(addEvent$8(z,"mouseleave",function(){z.hideTimer=win$1.setTimeout(z.hideMenu,500)}),addEvent$8(z,"mouseenter",function(){Utilities.clearTimeout(z.hideTimer)}),addEvent$8(doc,"mouseup",function(j){D.pointer.inClass(j.target,P)||z.hideMenu()}),addEvent$8(z,"click",function(){D.openMenu&&z.hideMenu()})),E.forEach(function(j){if(typeof j=="string"&&(j=D.options.exporting.menuItemDefinitions[j]),isObject$4(j,!0)){var K=void 0;j.separator?K=createElement("hr",void 0,void 0,U):(j.textKey==="viewData"&&D.isDataTableVisible&&(j.textKey="hideData"),K=createElement("li",{className:"highcharts-menu-item",onclick:function(nt){nt&&nt.stopPropagation(),z.hideMenu(),j.onclick&&j.onclick.apply(D,arguments)}},void 0,U),AST.setElementHTML(K,j.text||D.options.lang[j.textKey]),D.styledMode||(K.onmouseover=function(){css$1(this,N.menuItemHoverStyle)},K.onmouseout=function(){css$1(this,N.menuItemStyle)},css$1(K,extend$k({cursor:"pointer"},N.menuItemStyle)))),D.exportDivElements.push(K)}}),D.exportDivElements.push(U,z),D.exportMenuWidth=z.offsetWidth,D.exportMenuHeight=z.offsetHeight);var V={display:"block"};T+D.exportMenuWidth>B?V.right=B-T-C-F+"px":V.left=T-F+"px",O+I+D.exportMenuHeight>X&&L.alignOptions.verticalAlign!=="top"?V.bottom=X-O-F+"px":V.top=O+I-F+"px",css$1(z,V),css$1(D.renderTo,{overflow:""}),css$1(D.container,{overflow:""}),D.openMenu=!0,fireEvent$3(D,"exportMenuShown")}function f(P){var E=P?P.target:this,T=E.exportSVGElements,O=E.exportDivElements,C=E.exportEvents,I;T&&(T.forEach(function(L,D){L&&(L.onclick=L.ontouchstart=null,I="cache-"+L.menuClassName,E[I]&&delete E[I],T[D]=L.destroy())}),T.length=0),E.exportingGroup&&(E.exportingGroup.destroy(),delete E.exportingGroup),O&&(O.forEach(function(L,D){L&&(Utilities.clearTimeout(L.hideTimer),removeEvent(L,"mouseleave"),O[D]=L.onmouseout=L.onmouseover=L.ontouchstart=L.onclick=null,discardElement(L))}),O.length=0),C&&(C.forEach(function(L){L()}),C.length=0)}function u(P,E){var T=this.getSVGForExport(P,E);P=merge$f(this.options.exporting,P),exports$2.post(P.url,{filename:P.filename?P.filename.replace(/\//g,"-"):this.getFilename(),type:P.type,width:P.width||0,scale:P.scale,svg:T},P.formAttributes)}function g(){return this.styledMode&&this.inlineStyles(),this.container.innerHTML}function m(){var P=this.userOptions.title&&this.userOptions.title.text,E=this.options.exporting.filename;return E?E.replace(/\//g,"-"):(typeof P=="string"&&(E=P.toLowerCase().replace(/<\/?[^>]+(>|$)/g,"").replace(/[\s_]+/g,"-").replace(/[^a-z0-9\-]/g,"").replace(/^[\-]+/g,"").replace(/[\-]+/g,"-").substr(0,24).replace(/[\-]+$/g,"")),(!E||E.length<5)&&(E="chart"),E)}function y(P){var E=this,T,O,C=merge$f(E.options,P);C.plotOptions=merge$f(E.userOptions.plotOptions,P&&P.plotOptions),C.time=merge$f(E.userOptions.time,P&&P.time);var I=createElement("div",null,{position:"absolute",top:"-9999em",width:E.chartWidth+"px",height:E.chartHeight+"px"},doc.body),L=E.renderTo.style.width,D=E.renderTo.style.height,N=C.exporting.sourceWidth||C.chart.width||/px$/.test(L)&&parseInt(L,10)||(C.isGantt?800:600),B=C.exporting.sourceHeight||C.chart.height||/px$/.test(D)&&parseInt(D,10)||400;extend$k(C.chart,{animation:!1,renderTo:I,forExport:!0,renderer:"SVGRenderer",width:N,height:B}),C.exporting.enabled=!1,delete C.data,C.series=[],E.series.forEach(function(F){O=merge$f(F.userOptions,{animation:!1,enableMouseTracking:!1,showCheckbox:!1,visible:F.visible}),O.isInternal||C.series.push(O)});var X={};E.axes.forEach(function(F){F.userOptions.internalKey||(F.userOptions.internalKey=uniqueKey()),F.options.isInternal||(X[F.coll]||(X[F.coll]=!0,C[F.coll]=[]),C[F.coll].push(merge$f(F.userOptions,{visible:F.visible})))});var W=new Chart$1(C,E.callback);return P&&["xAxis","yAxis","series"].forEach(function(F){var U={};P[F]&&(U[F]=P[F],W.update(U))}),E.axes.forEach(function(F){var U=find$3(W.axes,function(K){return K.options.internalKey===F.userOptions.internalKey}),z=F.getExtremes(),V=z.userMin,j=z.userMax;U&&(typeof V<"u"&&V!==U.min||typeof j<"u"&&j!==U.max)&&U.setExtremes(V,j,!0,!1)}),T=W.getChartHTML(),fireEvent$3(this,"getSVG",{chartCopy:W}),T=E.sanitizeSVG(T,C),C=null,W.destroy(),discardElement(I),T}function v(P,E){var T=this.options.exporting;return this.getSVG(merge$f({chart:{borderRadius:0}},T.chartOptions,E,{exporting:{sourceWidth:P&&P.sourceWidth||T.sourceWidth,sourceHeight:P&&P.sourceHeight||T.sourceHeight}}))}function x(P){return P.replace(/([A-Z])/g,function(E,T){return"-"+T.toLowerCase()})}function b(){var P=t,E=n.inlineWhitelist,T={},O,C=doc.createElement("iframe");css$1(C,{width:"1px",height:"1px",visibility:"hidden"}),doc.body.appendChild(C);var I=C.contentWindow.document;I.open(),I.write('<svg xmlns="http://www.w3.org/2000/svg"></svg>'),I.close();function L(N){var B,X,W="",F,U,z,V,j;function K(q,J){if(z=V=!1,E.length){for(j=E.length;j--&&!V;)V=E[j].test(J);z=!V}for(J==="transform"&&q==="none"&&(z=!0),j=P.length;j--&&!z;)z=P[j].test(J)||typeof q=="function";z||(X[J]!==q||N.nodeName==="svg")&&T[N.nodeName][J]!==q&&(!r||r.indexOf(J)!==-1?q&&N.setAttribute(x(J),q):W+=x(J)+":"+q+";")}if(N.nodeType===1&&o.indexOf(N.nodeName)===-1){if(B=win$1.getComputedStyle(N,null),X=N.nodeName==="svg"?{}:win$1.getComputedStyle(N.parentNode,null),T[N.nodeName]||(O=I.getElementsByTagName("svg")[0],F=I.createElementNS(N.namespaceURI,N.nodeName),O.appendChild(F),T[N.nodeName]=merge$f(win$1.getComputedStyle(F,null)),N.nodeName==="text"&&delete T.text.fill,O.removeChild(F)),H.isFirefox||H.isMS)for(var nt in B)K(B[nt],nt);else objectEach$2(B,K);if(W&&(U=N.getAttribute("style"),N.setAttribute("style",(U?U+";":"")+W)),N.nodeName==="svg"&&N.setAttribute("stroke-width","1px"),N.nodeName==="text")return;[].forEach.call(N.children||N.childNodes,L)}}function D(){O.parentNode.removeChild(O),C.parentNode.removeChild(C)}L(this.container.querySelector("svg")),D()}function $(P){var E=this;(E.fixedDiv?[E.fixedDiv,E.scrollingContainer]:[E.container]).forEach(function(T){P.appendChild(T)})}function S(){var P=this,E=function(T,O,C){P.isDirtyExporting=!0,merge$f(!0,P.options[T],O),pick$h(C,!0)&&P.redraw()};P.exporting={update:function(T,O){E("exporting",T,O)}},chartNavigation.addUpdate(function(T,O){E("navigation",T,O)},P)}function k(){var P=this;P.isPrinting||(s=P,H.isSafari||P.beforePrint(),setTimeout(function(){win$1.focus(),win$1.print(),H.isSafari||setTimeout(function(){P.afterPrint()},1e3)},1))}function A(){var P=this,E=P.options.exporting,T=E.buttons,O=P.isDirtyExporting||!P.exportSVGElements;P.buttonOffset=0,P.isDirtyExporting&&P.destroyExport(),O&&E.enabled!==!1&&(P.exportEvents=[],P.exportingGroup=P.exportingGroup||P.renderer.g("exporting-group").attr({zIndex:3}).add(),objectEach$2(T,function(C){P.addButton(C)}),P.isDirtyExporting=!1)}function M(P,E){var T=P.indexOf("</svg>")+6,O=P.substr(T);return P=P.substr(0,T),E&&E.exporting&&E.exporting.allowHTML&&O&&(O='<foreignObject x="0" y="0" width="'+E.chart.width+'" height="'+E.chart.height+'"><body xmlns="http://www.w3.org/1999/xhtml">'+O.replace(/(<(?:img|br).*?(?=\>))>/g,"$1 />")+"</body></foreignObject>",P=P.replace("</svg>",O+"</svg>")),P=P.replace(/zIndex="[^"]+"/g,"").replace(/symbolName="[^"]+"/g,"").replace(/jQuery[0-9]+="[^"]+"/g,"").replace(/url\(("|&quot;)(.*?)("|&quot;)\;?\)/g,"url($2)").replace(/url\([^#]+#/g,"url(#").replace(/<svg /,'<svg xmlns:xlink="http://www.w3.org/1999/xlink" ').replace(/ (|NS[0-9]+\:)href=/g," xlink:href=").replace(/\n/," ").replace(/(fill|stroke)="rgba\(([ 0-9]+,[ 0-9]+,[ 0-9]+),([ 0-9\.]+)\)"/g,'$1="rgb($2)" $1-opacity="$3"').replace(/&nbsp;/g," ").replace(/&shy;/g,"­"),this.ieSanitizeSVG&&(P=this.ieSanitizeSVG(P)),P}})(Exporting||(Exporting={}));defaultOptions$1.exporting=merge$f(ExportingDefaults.exporting,defaultOptions$1.exporting);defaultOptions$1.lang=merge$f(ExportingDefaults.lang,defaultOptions$1.lang);defaultOptions$1.navigation=merge$f(ExportingDefaults.navigation,defaultOptions$1.navigation);const Exporting$1=Exporting;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/exporting
 * @requires highcharts
 *
 * Exporting module
 *
 * (c) 2010-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$1=H;G$1.HttpUtilities=exports$2;G$1.ajax=exports$2.ajax;G$1.getJSON=exports$2.getJSON;G$1.post=exports$2.post;Exporting$1.compose(G$1.Chart,G$1.Renderer);var __extends$h=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),noop$3=H.noop,Series$7=SeriesRegistry$1.series,PieSeries=SeriesRegistry$1.seriesTypes.pie,addEvent$7=Utilities.addEvent,extend$j=Utilities.extend,fireEvent$2=Utilities.fireEvent,isArray$2=Utilities.isArray,merge$e=Utilities.merge,pick$g=Utilities.pick,FunnelSeries=function(n){__extends$h(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.alignDataLabel=function(t,r,o,s,a){var l=t.series,h=l.options.reversed,d=t.dlBox||t.shapeArgs,c=o.align,p=o.verticalAlign,f=((l.options||{}).dataLabels||{}).inside,u=l.center[1],g=h?2*u-t.plotY:t.plotY,m=l.getWidthAt(g-d.height/2+r.height),y=p==="middle"?(d.topWidth-d.bottomWidth)/4:(m-d.bottomWidth)/2,v=d.y,x=d.x;p==="middle"?v=d.y-d.height/2+r.height/2:p==="top"&&(v=d.y-d.height+r.height+o.padding),(p==="top"&&!h||p==="bottom"&&h||p==="middle")&&(c==="right"?x=d.x-o.padding+y:c==="left"&&(x=d.x+o.padding-y)),s={x,y:h?v-d.height:v,width:d.bottomWidth,height:d.height},o.verticalAlign="bottom",(!f||t.visible)&&Series$7.prototype.alignDataLabel.call(this,t,r,o,s,a),f&&(!t.visible&&t.dataLabel&&(t.dataLabel.placed=!1),t.contrastColor&&r.css({color:t.contrastColor}))},e.prototype.drawDataLabels=function(){var t=this,r=t.data,o=t.options.dataLabels.distance,s,a,l,h=r.length,d,c;for(t.center[2]-=2*o;h--;)l=r[h],s=l.half,a=s?1:-1,c=l.plotY,l.labelDistance=pick$g(l.options.dataLabels&&l.options.dataLabels.distance,o),t.maxLabelDistance=Math.max(l.labelDistance,t.maxLabelDistance||0),d=t.getX(c,s,l),l.labelPosition={natural:{x:0,y:c},final:{},alignment:s?"right":"left",connectorPosition:{breakAt:{x:d+(l.labelDistance-5)*a,y:c},touchingSliceAt:{x:d+l.labelDistance*a,y:c}}};SeriesRegistry$1.seriesTypes[t.options.dataLabels.inside?"column":"pie"].prototype.drawDataLabels.call(this)},e.prototype.translate=function(){var t=0,r=this,o=r.chart,s=r.options,a=s.reversed,l=s.ignoreHiddenPoint,h=o.plotWidth,d=o.plotHeight,c=0,p=s.center,f=L(p[0],h),u=L(p[1],d),g=L(s.width,h),m,y=L(s.height,d),v=L(s.neckWidth,h),x=L(s.neckHeight,d),b=u-y/2+y-x,$=r.data,S,k,A=s.dataLabels.position==="left"?1:0,M,P,E,T,O,C,I;function L(D,N){return/%$/.test(D)?N*parseInt(D,10)/100:parseInt(D,10)}r.getWidthAt=function(D){var N=u-y/2;return D>b||y===x?v:v+(g-v)*(1-(D-N)/(y-x))},r.getX=function(D,N,B){return f+(N?-1:1)*(r.getWidthAt(a?2*u-D:D)/2+B.labelDistance)},r.center=[f,u,y],r.centerX=f,$.forEach(function(D){(!l||D.visible!==!1)&&(t+=D.y)}),$.forEach(function(D){I=null,k=t?D.y/t:0,P=u-y/2+c*y,O=P+k*y,m=r.getWidthAt(P),M=f-m/2,E=M+m,m=r.getWidthAt(O),T=f-m/2,C=T+m,P>b?(M=T=f-v/2,E=C=f+v/2):O>b&&(I=O,m=r.getWidthAt(b),T=f-m/2,C=T+m,O=b),a&&(P=2*u-P,O=2*u-O,I!==null&&(I=2*u-I)),S=[["M",M,P],["L",E,P],["L",C,O]],I!==null&&S.push(["L",C,I],["L",T,I]),S.push(["L",T,O],["Z"]),D.shapeType="path",D.shapeArgs={d:S},D.percentage=k*100,D.plotX=f,D.plotY=(P+(I||O))/2,D.tooltipPos=[f,D.plotY],D.dlBox={x:T,y:P,topWidth:E-M,bottomWidth:C-T,height:Math.abs(pick$g(I,O)-P),width:NaN},D.slice=noop$3,D.half=A,(!l||D.visible!==!1)&&(c+=k)}),fireEvent$2(r,"afterTranslate")},e.prototype.sortByAngle=function(t){t.sort(function(r,o){return r.plotY-o.plotY})},e.defaultOptions=merge$e(PieSeries.defaultOptions,{animation:!1,center:["50%","50%"],width:"90%",neckWidth:"30%",height:"100%",neckHeight:"25%",reversed:!1,size:!0,dataLabels:{connectorWidth:1,verticalAlign:"middle"},states:{select:{color:palette.neutralColor20,borderColor:palette.neutralColor100}}}),e}(PieSeries);extend$j(FunnelSeries.prototype,{animate:noop$3});addEvent$7(Chart$1,"afterHideAllOverlappingLabels",function(){this.series.forEach(function(n){var e=n.options&&n.options.dataLabels;isArray$2(e)&&(e=e[0]),n.is("pie")&&n.placeDataLabels&&e&&!e.inside&&n.placeDataLabels()})});SeriesRegistry$1.registerSeriesType("funnel",FunnelSeries);var __extends$g=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),merge$d=Utilities.merge,PyramidSeries=function(n){__extends$g(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.defaultOptions=merge$d(FunnelSeries.defaultOptions,{neckWidth:"0%",neckHeight:"0%",reversed:!0}),e}(FunnelSeries);SeriesRegistry$1.registerSeriesType("pyramid",PyramidSeries);var colorPointMixin$1={setVisible:function(n){var e=this,t=n?"show":"hide";e.visible=e.options.visible=!!n,["graphic","dataLabel"].forEach(function(r){e[r]&&e[r][t]()}),this.series.buildKDTree()}},colorSeriesMixin$1={optionalAxis:"colorAxis",translateColors:function(){var n=this,e=this.data.length?this.data:this.points,t=this.options.nullColor,r=this.colorAxis,o=this.colorKey;e.forEach(function(s){var a=s.getNestedProperty(o),l;l=s.options.color||(s.isNull||s.value===null?t:r&&typeof a<"u"?r.toColor(a,s):s.color||n.color),l&&s.color!==l&&(s.color=l,n.options.legendType==="point"&&s.legendItem&&n.chart.legend.colorizeItem(s,s.visible))})}},exports$1={colorPointMixin:colorPointMixin$1,colorSeriesMixin:colorSeriesMixin$1},color$4=Color.parse,colorPointMixin=exports$1.colorPointMixin,colorSeriesMixin=exports$1.colorSeriesMixin,addEvent$6=Utilities.addEvent,extend$i=Utilities.extend,merge$c=Utilities.merge,pick$f=Utilities.pick,splat=Utilities.splat,ColorAxisComposition;(function(n){var e=[],t;function r(u,g,m,y,v){if(t||(t=u),e.indexOf(g)===-1){e.push(g);var x=g.prototype;x.collectionsWithUpdate.push("colorAxis"),x.collectionsWithInit.colorAxis=[x.addColorAxis],addEvent$6(g,"afterGetAxes",o),c(g)}if(e.indexOf(m)===-1){e.push(m);var b=m.prototype;b.fillSetter=p,b.strokeSetter=f}e.indexOf(y)===-1&&(e.push(y),addEvent$6(y,"afterGetAllItems",s),addEvent$6(y,"afterColorizeItem",a),addEvent$6(y,"afterUpdate",l)),e.indexOf(v)===-1&&(e.push(v),extend$i(v.prototype,colorSeriesMixin),extend$i(v.prototype.pointClass.prototype,colorPointMixin),addEvent$6(v,"afterTranslate",h),addEvent$6(v,"bindAxes",d))}n.compose=r;function o(){var u=this,g=this.options;this.colorAxis=[],g.colorAxis&&(g.colorAxis=splat(g.colorAxis),g.colorAxis.forEach(function(m,y){m.index=y,new t(u,m)}))}function s(u){var g=this,m=this.chart.colorAxis||[],y=function($){var S=u.allItems.indexOf($);S!==-1&&(g.destroyItem(u.allItems[S]),u.allItems.splice(S,1))},v=[],x,b;for(m.forEach(function($){x=$.options,x&&x.showInLegend&&(x.dataClasses&&x.visible?v=v.concat($.getDataClassLegendSymbols()):x.visible&&v.push($),$.series.forEach(function(S){(!S.options.showInLegend||x.dataClasses)&&(S.options.legendType==="point"?S.points.forEach(function(k){y(k)}):y(S))}))}),b=v.length;b--;)u.allItems.unshift(v[b])}function a(u){u.visible&&u.item.legendColor&&u.item.legendSymbol.attr({fill:u.item.legendColor})}function l(){var u=this.chart.colorAxis;u&&u.forEach(function(g){g.update({},arguments[2])})}function h(){(this.chart.colorAxis&&this.chart.colorAxis.length||this.colorAttribs)&&this.translateColors()}function d(){var u=this.axisTypes;u?u.indexOf("colorAxis")===-1&&u.push("colorAxis"):this.axisTypes=["colorAxis"]}function c(u){var g=u.prototype.createAxis;u.prototype.createAxis=function(m,y){if(m!=="colorAxis")return g.apply(this,arguments);var v=new t(this,merge$c(y.axis,{index:this[m].length,isX:!1}));return this.isDirtyLegend=!0,this.axes.forEach(function(x){x.series=[]}),this.series.forEach(function(x){x.bindAxes(),x.isDirtyData=!0}),pick$f(y.redraw,!0)&&this.redraw(y.animation),v}}function p(){this.elem.attr("fill",color$4(this.start).tweenTo(color$4(this.end),this.pos),void 0,!0)}function f(){this.elem.attr("stroke",color$4(this.start).tweenTo(color$4(this.end),this.pos),void 0,!0)}})(ColorAxisComposition||(ColorAxisComposition={}));const ColorAxisComposition$1=ColorAxisComposition;var colorAxisDefaults={lineWidth:0,minPadding:0,maxPadding:0,gridLineWidth:1,tickPixelInterval:72,startOnTick:!0,endOnTick:!0,offset:0,marker:{animation:{duration:50},width:.01,color:palette.neutralColor40},labels:{overflow:"justify",rotation:0},minColor:palette.highlightColor10,maxColor:palette.highlightColor100,tickLength:5,showInLegend:!0},__extends$f=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),color$3=Color.parse,noop$2=H.noop,Series$6=SeriesRegistry$1.series,extend$h=Utilities.extend,isNumber$7=Utilities.isNumber,merge$b=Utilities.merge,pick$e=Utilities.pick,ColorAxis=function(n){__extends$f(e,n);function e(t,r){var o=n.call(this,t,r)||this;return o.beforePadding=!1,o.chart=void 0,o.coll="colorAxis",o.dataClasses=void 0,o.legendItem=void 0,o.legendItems=void 0,o.name="",o.options=void 0,o.stops=void 0,o.visible=!0,o.init(t,r),o}return e.compose=function(t,r,o,s){ColorAxisComposition$1.compose(e,t,r,o,s)},e.prototype.init=function(t,r){var o=this,s=t.options.legend||{},a=r.layout?r.layout!=="vertical":s.layout!=="vertical",l=r.visible,h=merge$b(e.defaultColorAxisOptions,r,{showEmpty:!1,title:null,visible:s.enabled&&l!==!1});o.coll="colorAxis",o.side=r.side||a?2:1,o.reversed=r.reversed||!a,o.opposite=!a,n.prototype.init.call(this,t,h),o.userOptions.visible=l,r.dataClasses&&o.initDataClasses(r),o.initStops(),o.horiz=a,o.zoomEnabled=!1},e.prototype.initDataClasses=function(t){var r=this,o=r.chart,s=r.options,a=t.dataClasses.length,l,h=0,d=o.options.chart.colorCount;r.dataClasses=l=[],r.legendItems=[],(t.dataClasses||[]).forEach(function(c,p){var f;c=merge$b(c),l.push(c),!(!o.styledMode&&c.color)&&(s.dataClassColor==="category"?(o.styledMode||(f=o.options.colors,d=f.length,c.color=f[h]),c.colorIndex=h,h++,h===d&&(h=0)):c.color=color$3(s.minColor).tweenTo(color$3(s.maxColor),a<2?.5:p/(a-1)))})},e.prototype.hasData=function(){return!!(this.tickPositions||[]).length},e.prototype.setTickPositions=function(){if(!this.dataClasses)return n.prototype.setTickPositions.call(this)},e.prototype.initStops=function(){var t=this;t.stops=t.options.stops||[[0,t.options.minColor],[1,t.options.maxColor]],t.stops.forEach(function(r){r.color=color$3(r[1])})},e.prototype.setOptions=function(t){var r=this;n.prototype.setOptions.call(this,t),r.options.crosshair=r.options.marker},e.prototype.setAxisSize=function(){var t=this,r=t.legendSymbol,o=t.chart,s=o.options.legend||{},a,l,h,d;r?(this.left=a=r.attr("x"),this.top=l=r.attr("y"),this.width=h=r.attr("width"),this.height=d=r.attr("height"),this.right=o.chartWidth-a-h,this.bottom=o.chartHeight-l-d,this.len=this.horiz?h:d,this.pos=this.horiz?a:l):this.len=(this.horiz?s.symbolWidth:s.symbolHeight)||e.defaultLegendLength},e.prototype.normalizedValue=function(t){var r=this;return r.logarithmic&&(t=r.logarithmic.log2lin(t)),1-(r.max-t)/(r.max-r.min||1)},e.prototype.toColor=function(t,r){var o=this,s=o.dataClasses,a=o.stops,l,h,d,c,p,f;if(s){for(f=s.length;f--;)if(p=s[f],h=p.from,d=p.to,(typeof h>"u"||t>=h)&&(typeof d>"u"||t<=d)){c=p.color,r&&(r.dataClass=f,r.colorIndex=p.colorIndex);break}}else{for(l=o.normalizedValue(t),f=a.length;f--&&!(l>a[f][0]););h=a[f]||a[f+1],d=a[f+1]||h,l=1-(d[0]-l)/(d[0]-h[0]||1),c=h.color.tweenTo(d.color,l)}return c},e.prototype.getOffset=function(){var t=this,r=t.legendGroup,o=t.chart.axisOffset[t.side];r&&(t.axisParent=r,n.prototype.getOffset.call(this),t.added||(t.added=!0,t.labelLeft=0,t.labelRight=t.width),t.chart.axisOffset[t.side]=o)},e.prototype.setLegendColor=function(){var t=this,r=t.horiz,o=t.reversed,s=o?1:0,a=o?0:1,l=r?[s,0,a,0]:[0,a,0,s];t.legendColor={linearGradient:{x1:l[0],y1:l[1],x2:l[2],y2:l[3]},stops:t.stops}},e.prototype.drawLegendSymbol=function(t,r){var o=this,s=t.padding,a=t.options,l=o.horiz,h=pick$e(a.symbolWidth,l?e.defaultLegendLength:12),d=pick$e(a.symbolHeight,l?12:e.defaultLegendLength),c=pick$e(a.labelPadding,l?16:30),p=pick$e(a.itemDistance,10);this.setLegendColor(),r.legendSymbol=this.chart.renderer.rect(0,t.baseline-11,h,d).attr({zIndex:1}).add(r.legendGroup),o.legendItemWidth=h+s+(l?p:c),o.legendItemHeight=d+s+(l?c:0)},e.prototype.setState=function(t){this.series.forEach(function(r){r.setState(t)})},e.prototype.setVisible=function(){},e.prototype.getSeriesExtremes=function(){var t=this,r=t.series,o,s,a,l,h,d,c=r.length,p,f;for(this.dataMin=1/0,this.dataMax=-1/0;c--;){if(d=r[c],s=d.colorKey=pick$e(d.options.colorKey,d.colorKey,d.pointValKey,d.zoneAxis,"y"),l=d.pointArrayMap,h=d[s+"Min"]&&d[s+"Max"],d[s+"Data"])o=d[s+"Data"];else if(!l)o=d.yData;else if(o=[],a=l.indexOf(s),p=d.yData,a>=0&&p)for(f=0;f<p.length;f++)o.push(pick$e(p[f][a],p[f]));if(h)d.minColorValue=d[s+"Min"],d.maxColorValue=d[s+"Max"];else{var u=Series$6.prototype.getExtremes.call(d,o);d.minColorValue=u.dataMin,d.maxColorValue=u.dataMax}typeof d.minColorValue<"u"&&(this.dataMin=Math.min(this.dataMin,d.minColorValue),this.dataMax=Math.max(this.dataMax,d.maxColorValue)),h||Series$6.prototype.applyExtremes.call(d)}},e.prototype.drawCrosshair=function(t,r){var o=this,s=r&&r.plotX,a=r&&r.plotY,l=o.pos,h=o.len,d;r&&(d=o.toPixels(r.getNestedProperty(r.series.colorKey)),d<l?d=l-2:d>l+h&&(d=l+h+2),r.plotX=d,r.plotY=o.len-d,n.prototype.drawCrosshair.call(this,t,r),r.plotX=s,r.plotY=a,o.cross&&!o.cross.addedToColorAxis&&o.legendGroup&&(o.cross.addClass("highcharts-coloraxis-marker").add(o.legendGroup),o.cross.addedToColorAxis=!0,!o.chart.styledMode&&typeof o.crosshair=="object"&&o.cross.attr({fill:o.crosshair.color})))},e.prototype.getPlotLinePath=function(t){var r=this,o=r.left,s=t.translatedValue,a=r.top;return isNumber$7(s)?r.horiz?[["M",s-4,a-6],["L",s+4,a-6],["L",s,a],["Z"]]:[["M",o,s],["L",o-6,s+6],["L",o-6,s-6],["Z"]]:n.prototype.getPlotLinePath.call(this,t)},e.prototype.update=function(t,r){var o=this,s=o.chart,a=s.legend;this.series.forEach(function(l){l.isDirtyData=!0}),(t.dataClasses&&a.allItems||o.dataClasses)&&o.destroyItems(),n.prototype.update.call(this,t,r),o.legendItem&&(o.setLegendColor(),a.colorizeItem(this,!0))},e.prototype.destroyItems=function(){var t=this,r=t.chart;t.legendItem?r.legend.destroyItem(t):t.legendItems&&t.legendItems.forEach(function(o){r.legend.destroyItem(o)}),r.isDirtyLegend=!0},e.prototype.destroy=function(){this.chart.isDirtyLegend=!0,this.destroyItems(),n.prototype.destroy.apply(this,[].slice.call(arguments))},e.prototype.remove=function(t){this.destroyItems(),n.prototype.remove.call(this,t)},e.prototype.getDataClassLegendSymbols=function(){var t=this,r=t.chart,o=t.legendItems,s=r.options.legend,a=s.valueDecimals,l=s.valueSuffix||"",h;return o.length||t.dataClasses.forEach(function(d,c){var p=d.from,f=d.to,u=r.numberFormatter,g=!0;h="",typeof p>"u"?h="< ":typeof f>"u"&&(h="> "),typeof p<"u"&&(h+=u(p,a)+l),typeof p<"u"&&typeof f<"u"&&(h+=" - "),typeof f<"u"&&(h+=u(f,a)+l),o.push(extend$h({chart:r,name:h,options:{},drawLegendSymbol:LegendSymbol$1.drawRectangle,visible:!0,setState:noop$2,isDataClass:!0,setVisible:function(){g=t.visible=!g,t.series.forEach(function(m){m.points.forEach(function(y){y.dataClass===c&&y.setVisible(g)})}),r.legend.colorizeItem(this,g)}},d))}),o},e.defaultColorAxisOptions=colorAxisDefaults,e.defaultLegendLength=200,e.keepProps=["legendGroup","legendItemHeight","legendItemWidth","legendItem","legendSymbol"],e}(Axis);Array.prototype.push.apply(Axis.keepProps,ColorAxis.keepProps);var defined$7=Utilities.defined,addEvent$5=Utilities.addEvent,noop$1=H.noop,seriesTypes=H.seriesTypes;addEvent$5(Point$2,"afterSetState",function(n){var e=this;e.moveToTopOnHover&&e.graphic&&e.graphic.attr({zIndex:n&&n.state==="hover"?1:0})});var colorMapPointMixin$1={dataLabelOnNull:!0,moveToTopOnHover:!0,isValid:function(){return this.value!==null&&this.value!==1/0&&this.value!==-1/0}},colorMapSeriesMixin$2={pointArrayMap:["value"],axisTypes:["xAxis","yAxis","colorAxis"],trackerGroups:["group","markerGroup","dataLabelsGroup"],getSymbol:noop$1,parallelArrays:["x","y","value"],colorKey:"value",pointAttribs:seriesTypes.column.prototype.pointAttribs,colorAttribs:function(n){var e={};return defined$7(n.color)&&(!n.state||n.state==="normal")&&(e[this.colorProp||"fill"]=n.color),e}},exports={colorMapPointMixin:colorMapPointMixin$1,colorMapSeriesMixin:colorMapSeriesMixin$2},__extends$e=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),colorMapPointMixin=exports.colorMapPointMixin,ScatterPoint$1=SeriesRegistry$1.seriesTypes.scatter.prototype.pointClass,clamp$2=Utilities.clamp,extend$g=Utilities.extend,pick$d=Utilities.pick,HeatmapPoint=function(n){__extends$e(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t.value=void 0,t.x=void 0,t.y=void 0,t}return e.prototype.applyOptions=function(t,r){var o=n.prototype.applyOptions.call(this,t,r);return o.formatPrefix=o.isNull||o.value===null?"null":"point",o},e.prototype.getCellAttributes=function(){var t=this,r=t.series,o=r.options,s=(o.colsize||1)/2,a=(o.rowsize||1)/2,l=r.xAxis,h=r.yAxis,d=t.options.marker||r.options.marker,c=r.pointPlacementToXValue(),p=pick$d(t.pointPadding,o.pointPadding,0),f={x1:clamp$2(Math.round(l.len-(l.translate(t.x-s,!1,!0,!1,!0,-c)||0)),-l.len,2*l.len),x2:clamp$2(Math.round(l.len-(l.translate(t.x+s,!1,!0,!1,!0,-c)||0)),-l.len,2*l.len),y1:clamp$2(Math.round(h.translate(t.y-a,!1,!0,!1,!0)||0),-h.len,2*h.len),y2:clamp$2(Math.round(h.translate(t.y+a,!1,!0,!1,!0)||0),-h.len,2*h.len)};return[["width","x"],["height","y"]].forEach(function(u){var g=u[0],m=u[1],y=m+"1",v=m+"2",x=Math.abs(f[y]-f[v]),b=d&&d.lineWidth||0,$=Math.abs(f[y]+f[v])/2;d[g]&&d[g]<x&&(f[y]=$-d[g]/2-b/2,f[v]=$+d[g]/2+b/2),p&&(m==="y"&&(y=v,v=m+"1"),f[y]+=p,f[v]-=p)}),f},e.prototype.haloPath=function(t){if(!t)return[];var r=this.shapeArgs;return["M",r.x-t,r.y-t,"L",r.x-t,r.y+r.height+t,r.x+r.width+t,r.y+r.height+t,r.x+r.width+t,r.y-t,"Z"]},e.prototype.isValid=function(){return this.value!==1/0&&this.value!==-1/0},e}(ScatterPoint$1);extend$g(HeatmapPoint.prototype,{dataLabelOnNull:colorMapPointMixin.dataLabelOnNull,moveToTopOnHover:colorMapPointMixin.moveToTopOnHover});var __extends$d=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),colorMapSeriesMixin$1=exports.colorMapSeriesMixin,Series$5=SeriesRegistry$1.series,_a$5=SeriesRegistry$1.seriesTypes,ColumnSeries$7=_a$5.column,ScatterSeries$1=_a$5.scatter,symbols$1=SVGRenderer.prototype.symbols,extend$f=Utilities.extend,fireEvent$1=Utilities.fireEvent,isNumber$6=Utilities.isNumber,merge$a=Utilities.merge,pick$c=Utilities.pick,HeatmapSeries$1=function(n){__extends$d(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.colorAxis=void 0,t.data=void 0,t.options=void 0,t.points=void 0,t.valueMax=NaN,t.valueMin=NaN,t}return e.prototype.drawPoints=function(){var t=this,r=this.options.marker||{};(r.enabled||this._hasPointMarkers)&&(Series$5.prototype.drawPoints.call(this),this.points.forEach(function(o){o.graphic&&(o.graphic[t.chart.styledMode?"css":"animate"](t.colorAttribs(o)),t.options.borderRadius&&o.graphic.attr({r:t.options.borderRadius}),o.value===null&&o.graphic.addClass("highcharts-null-point"))}))},e.prototype.getExtremes=function(){var t=Series$5.prototype.getExtremes.call(this,this.valueData),r=t.dataMin,o=t.dataMax;return isNumber$6(r)&&(this.valueMin=r),isNumber$6(o)&&(this.valueMax=o),Series$5.prototype.getExtremes.call(this)},e.prototype.getValidPoints=function(t,r){return Series$5.prototype.getValidPoints.call(this,t,r,!0)},e.prototype.hasData=function(){return!!this.processedXData.length},e.prototype.init=function(){var t;Series$5.prototype.init.apply(this,arguments),t=this.options,t.pointRange=pick$c(t.pointRange,t.colsize||1),this.yAxis.axisPointRange=t.rowsize||1,symbols$1.ellipse=symbols$1.circle},e.prototype.markerAttribs=function(t,r){var o=t.marker||{},s=this.options.marker||{},a,l,h=t.shapeArgs||{},d=t.hasImage,c={};return d?{x:t.plotX,y:t.plotY}:(r&&(a=s.states[r]||{},l=o.states&&o.states[r]||{},[["width","x"],["height","y"]].forEach(function(p){c[p[0]]=(l[p[0]]||a[p[0]]||h[p[0]])+(l[p[0]+"Plus"]||a[p[0]+"Plus"]||0),c[p[1]]=h[p[1]]+(h[p[0]]-c[p[0]])/2})),r?c:h)},e.prototype.pointAttribs=function(t,r){var o=this,s=Series$5.prototype.pointAttribs.call(o,t,r),a=o.options||{},l=o.chart.options.plotOptions||{},h=l.series||{},d=l.heatmap||{},c,p,f=t&&t.options.borderColor||a.borderColor||d.borderColor||h.borderColor,u=t&&t.options.borderWidth||a.borderWidth||d.borderWidth||h.borderWidth||s["stroke-width"];return s.stroke=t&&t.marker&&t.marker.lineColor||a.marker&&a.marker.lineColor||f||this.color,s["stroke-width"]=u,r&&(c=merge$a(a.states[r],a.marker&&a.marker.states[r],t&&t.options.states&&t.options.states[r]||{}),p=c.brightness,s.fill=c.color||Color.parse(s.fill).brighten(p||0).get(),s.stroke=c.lineColor),s},e.prototype.setClip=function(t){var r=this,o=r.chart;Series$5.prototype.setClip.apply(r,arguments),(r.options.clip!==!1||t)&&r.markerGroup.clip((t||r.clipBox)&&r.sharedClipKey?o.sharedClips[r.sharedClipKey]:o.clipRect)},e.prototype.translate=function(){var t=this,r=t.options,o=r.marker&&r.marker.symbol||"rect",s=symbols$1[o]?o:"rect",a=["circle","square"].indexOf(s)!==-1;t.generatePoints(),t.points.forEach(function(l){var h,d,c,p=l.getCellAttributes(),f={};f.x=Math.min(p.x1,p.x2),f.y=Math.min(p.y1,p.y2),f.width=Math.max(Math.abs(p.x2-p.x1),0),f.height=Math.max(Math.abs(p.y2-p.y1),0),c=l.hasImage=(l.marker&&l.marker.symbol||o).indexOf("url")===0,a&&(d=Math.abs(f.width-f.height),f.x=Math.min(p.x1,p.x2)+(f.width<f.height?0:d/2),f.y=Math.min(p.y1,p.y2)+(f.width<f.height?d/2:0),f.width=f.height=Math.min(f.width,f.height)),h={plotX:(p.x1+p.x2)/2,plotY:(p.y1+p.y2)/2,clientX:(p.x1+p.x2)/2,shapeType:"path",shapeArgs:merge$a(!0,f,{d:symbols$1[s](f.x,f.y,f.width,f.height)})},c&&(l.marker={width:f.width,height:f.height}),extend$f(l,h)}),fireEvent$1(t,"afterTranslate")},e.defaultOptions=merge$a(ScatterSeries$1.defaultOptions,{animation:!1,borderRadius:0,borderWidth:0,nullColor:palette.neutralColor3,dataLabels:{formatter:function(){var t=this.series.chart.numberFormatter,r=this.point.value;return isNumber$6(r)?t(r,-1):""},inside:!0,verticalAlign:"middle",crop:!1,overflow:!1,padding:0},marker:{symbol:"rect",radius:0,lineColor:void 0,states:{hover:{lineWidthPlus:0},select:{}}},clip:!0,pointRange:null,tooltip:{pointFormat:"{point.x}, {point.y}: {point.value}<br/>"},states:{hover:{halo:!1,brightness:.2}}}),e}(ScatterSeries$1);extend$f(HeatmapSeries$1.prototype,{alignDataLabel:ColumnSeries$7.prototype.alignDataLabel,axisTypes:colorMapSeriesMixin$1.axisTypes,colorAttribs:colorMapSeriesMixin$1.colorAttribs,colorKey:colorMapSeriesMixin$1.colorKey,directTouch:!0,drawLegendSymbol:LegendSymbol$1.drawRectangle,getExtremesFromAll:!0,getSymbol:Series$5.prototype.getSymbol,parallelArrays:colorMapSeriesMixin$1.parallelArrays,pointArrayMap:["y","value"],pointClass:HeatmapPoint,trackerGroups:colorMapSeriesMixin$1.trackerGroups});SeriesRegistry$1.registerSeriesType("heatmap",HeatmapSeries$1);/**
 * @license Highmaps JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/heatmap
 * @requires highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G=H;G.ColorAxis=ColorAxis;ColorAxis.compose(G.Chart,G.Fx,G.Legend,G.Series);var color$2=Color.parse,extend$e=Utilities.extend,merge$9=Utilities.merge,SolidGaugeAxis;(function(n){var e={initDataClasses:function(r){var o=this.chart,s,a=0,l=this.options;this.dataClasses=s=[],r.dataClasses.forEach(function(h,d){var c;h=merge$9(h),s.push(h),h.color||(l.dataClassColor==="category"?(c=o.options.colors,h.color=c[a++],a===c.length&&(a=0)):h.color=color$2(l.minColor).tweenTo(color$2(l.maxColor),d/(r.dataClasses.length-1)))})},initStops:function(r){this.stops=r.stops||[[0,this.options.minColor],[1,this.options.maxColor]],this.stops.forEach(function(o){o.color=color$2(o[1])})},toColor:function(r,o){var s,a=this.stops,l,h,d,c=this.dataClasses,p,f;if(c){for(f=c.length;f--;)if(p=c[f],l=p.from,h=p.to,(typeof l>"u"||r>=l)&&(typeof h>"u"||r<=h)){d=p.color,o&&(o.dataClass=f);break}}else{for(this.logarithmic&&(r=this.val2lin(r)),s=1-(this.max-r)/(this.max-this.min),f=a.length;f--&&!(s>a[f][0]););l=a[f]||a[f+1],h=a[f+1]||l,s=1-(h[0]-s)/(h[0]-l[0]||1),d=l.color.tweenTo(h.color,s)}return d}};function t(r){extend$e(r,e)}n.init=t})(SolidGaugeAxis||(SolidGaugeAxis={}));const SolidGaugeAxis$1=SolidGaugeAxis;var _a$4=SVGRenderer.prototype,symbols=_a$4.symbols,arc=_a$4.symbols.arc;symbols.arc=function(n,e,t,r,o){var s=arc(n,e,t,r,o);if(o&&o.rounded){var a=o.r||t,l=(a-(o.innerR||0))/2,h=s[0],d=s[2];if(h[0]==="M"&&d[0]==="L"){var c=h[1],p=h[2],f=d[1],u=d[2],g=["A",l,l,0,1,1,c,p],m=["A",l,l,0,1,1,f,u];s[2]=m,s[4]=g}}return s};var __extends$c=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),_a$3=SeriesRegistry$1.seriesTypes,GaugeSeries=_a$3.gauge,pieProto=_a$3.pie.prototype,clamp$1=Utilities.clamp,extend$d=Utilities.extend,isNumber$5=Utilities.isNumber,merge$8=Utilities.merge,pick$b=Utilities.pick,pInt=Utilities.pInt,solidGaugeOptions={colorByPoint:!0,dataLabels:{y:0}},SolidGaugeSeries=function(n){__extends$c(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.points=void 0,t.options=void 0,t.axis=void 0,t.yAxis=void 0,t.startAngleRad=void 0,t.thresholdAngleRad=void 0,t}return e.prototype.translate=function(){var t=this.yAxis;SolidGaugeAxis$1.init(t),!t.dataClasses&&t.options.dataClasses&&t.initDataClasses(t.options),t.initStops(t.options),GaugeSeries.prototype.translate.call(this)},e.prototype.drawPoints=function(){var t=this,r=t.yAxis,o=r.center,s=t.options,a=t.chart.renderer,l=s.overshoot,h=isNumber$5(l)?l/180*Math.PI:0,d;isNumber$5(s.threshold)&&(d=r.startAngleRad+r.translate(s.threshold,null,null,null,!0)),this.thresholdAngleRad=pick$b(d,r.startAngleRad),t.points.forEach(function(c){if(!c.isNull){var p=c.graphic,f=r.startAngleRad+r.translate(c.y,null,null,null,!0),u=pInt(pick$b(c.options.radius,s.radius,100))*o[2]/200,g=pInt(pick$b(c.options.innerRadius,s.innerRadius,60))*o[2]/200,m=void 0,y=void 0,v=r.toColor(c.y,c),x=Math.min(r.startAngleRad,r.endAngleRad),b=Math.max(r.startAngleRad,r.endAngleRad),$=void 0,S=void 0;v==="none"&&(v=c.color||t.color||"none"),v!=="none"&&(c.color=v),f=clamp$1(f,x-h,b+h),s.wrap===!1&&(f=clamp$1(f,x,b)),$=Math.min(f,t.thresholdAngleRad),S=Math.max(f,t.thresholdAngleRad),S-$>2*Math.PI&&(S=$+2*Math.PI),c.shapeArgs=m={x:o[0],y:o[1],r:u,innerR:g,start:$,end:S,rounded:s.rounded},c.startR=u,p?(y=m.d,p.animate(extend$d({fill:v},m)),y&&(m.d=y)):c.graphic=p=a.arc(m).attr({fill:v,"sweep-flag":0}).add(t.group),t.chart.styledMode||(s.linecap!=="square"&&p.attr({"stroke-linecap":"round","stroke-linejoin":"round"}),p.attr({stroke:s.borderColor||"none","stroke-width":s.borderWidth||0})),p&&p.addClass(c.getClassName(),!0)}})},e.prototype.animate=function(t){t||(this.startAngleRad=this.thresholdAngleRad,pieProto.animate.call(this,t))},e.defaultOptions=merge$8(GaugeSeries.defaultOptions,solidGaugeOptions),e}(GaugeSeries);extend$d(SolidGaugeSeries.prototype,{drawLegendSymbol:LegendSymbol$1.drawRectangle});SeriesRegistry$1.registerSeriesType("solidgauge",SolidGaugeSeries);var TreemapAlgorithmGroup=function(){function n(e,t,r,o){this.height=e,this.width=t,this.plot=o,this.direction=r,this.startDirection=r,this.total=0,this.nW=0,this.lW=0,this.nH=0,this.lH=0,this.elArr=[],this.lP={total:0,lH:0,nH:0,lW:0,nW:0,nR:0,lR:0,aspectRatio:function(s,a){return Math.max(s/a,a/s)}}}return n.prototype.addElement=function(e){this.lP.total=this.elArr[this.elArr.length-1],this.total=this.total+e,this.direction===0?(this.lW=this.nW,this.lP.lH=this.lP.total/this.lW,this.lP.lR=this.lP.aspectRatio(this.lW,this.lP.lH),this.nW=this.total/this.height,this.lP.nH=this.lP.total/this.nW,this.lP.nR=this.lP.aspectRatio(this.nW,this.lP.nH)):(this.lH=this.nH,this.lP.lW=this.lP.total/this.lH,this.lP.lR=this.lP.aspectRatio(this.lP.lW,this.lH),this.nH=this.total/this.width,this.lP.nW=this.lP.total/this.nH,this.lP.nR=this.lP.aspectRatio(this.lP.nW,this.nH)),this.elArr.push(e)},n.prototype.reset=function(){this.nW=0,this.lW=0,this.elArr=[],this.total=0},n}(),isFn$1=function(n){return typeof n=="function"},draw=function(e){var t=this,r=e.animatableAttribs,o=e.onComplete,s=e.css,a=e.renderer,l=this.series&&this.series.chart.hasRendered?void 0:this.series&&this.series.options.animation,h=this.graphic;if(this.shouldDraw())h||(this.graphic=h=a[e.shapeType](e.shapeArgs).add(e.group)),h.css(s).attr(e.attribs).animate(r,e.isNew?!1:l,o);else if(h){var d=function(){t.graphic=h=h&&h.destroy(),isFn$1(o)&&o()};Object.keys(r).length?h.animate(r,void 0,function(){d()}):d()}},drawPoint=function(e){var t=this,r=e.attribs=e.attribs||{};r.class=t.getClassName(),draw.call(t,e)},drawPointModule={draw,drawPoint,isFn:isFn$1},__extends$b=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),Point=SeriesRegistry$1.series.prototype.pointClass,_a$2=SeriesRegistry$1.seriesTypes,PiePoint$1=_a$2.pie.prototype.pointClass,ScatterPoint=_a$2.scatter.prototype.pointClass,extend$c=Utilities.extend,isNumber$4=Utilities.isNumber,pick$a=Utilities.pick,TreemapPoint=function(n){__extends$b(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.name=void 0,t.node=void 0,t.options=void 0,t.series=void 0,t.value=void 0,t}return e.prototype.getClassName=function(){var t=Point.prototype.getClassName.call(this),r=this.series,o=r.options;return this.node.level<=r.nodeMap[r.rootNode].level?t+=" highcharts-above-level":!this.node.isLeaf&&!pick$a(o.interactByLeaf,!o.allowTraversingTree)?t+=" highcharts-internal-node-interactive":this.node.isLeaf||(t+=" highcharts-internal-node"),t},e.prototype.isValid=function(){return!!(this.id||isNumber$4(this.value))},e.prototype.setState=function(t){Point.prototype.setState.call(this,t),this.graphic&&this.graphic.attr({zIndex:t==="hover"?1:0})},e.prototype.shouldDraw=function(){return isNumber$4(this.plotY)&&this.y!==null},e}(ScatterPoint);extend$c(TreemapPoint.prototype,{draw:drawPointModule.drawPoint,setVisible:PiePoint$1.prototype.setVisible});var objectEach$1=Utilities.objectEach,TreemapUtilities;(function(n){n.AXIS_MAX=100;function e(o){return typeof o=="boolean"}n.isBoolean=e;function t(o,s,a){a=a||this,objectEach$1(o,function(l,h){s.call(a,l,h,o)})}n.eachObject=t;function r(o,s,a){a===void 0&&(a=this);var l;l=s.call(a,o),l!==!1&&r(l,s,a)}n.recursive=r})(TreemapUtilities||(TreemapUtilities={}));const TreemapUtilities$1=TreemapUtilities;var extend$b=Utilities.extend,isArray$1=Utilities.isArray,isNumber$3=Utilities.isNumber,isObject$3=Utilities.isObject,merge$7=Utilities.merge,pick$9=Utilities.pick,isBoolean=function(n){return typeof n=="boolean"},isFn=function(n){return typeof n=="function"},setTreeValues=function n(e,t){var r=t.before,o=t.idRoot,s=t.mapIdToNode,a=s[o],l=isBoolean(t.levelIsConstant)?t.levelIsConstant:!0,h=t.points,d=h[e.i],c=d&&d.options||{},p=0,f=[],u;return e.levelDynamic=e.level-(l?0:a.level),e.name=pick$9(d&&d.name,""),e.visible=o===e.id||(isBoolean(t.visible)?t.visible:!1),isFn(r)&&(e=r(e,t)),e.children.forEach(function(g,m){var y=extend$b({},t);extend$b(y,{index:m,siblings:e.children.length,visible:e.visible}),g=n(g,y),f.push(g),g.visible&&(p+=g.val)}),u=pick$9(c.value,p),e.visible=u>=0&&(p>0||e.visible),e.children=f,e.childrenTotal=p,e.isLeaf=e.visible&&!p,e.val=u,e},getColor$1=function(e,t){var r=t.index,o=t.mapOptionsToLevel,s=t.parentColor,a=t.parentColorIndex,l=t.series,h=t.colors,d=t.siblings,c=l.points,p,f=l.chart.options.chart,u,g,m,y,v,x;function b($){var S=g&&g.colorVariation;return S&&S.key==="brightness"?Color.parse($).brighten(S.to*(r/d)).get():$}return e&&(u=c[e.i],g=o[e.level]||{},p=u&&g.colorByPoint,p&&(y=u.index%(h?h.length:f.colorCount),m=h&&h[y]),l.chart.styledMode||(v=pick$9(u&&u.options.color,g&&g.color,m,s&&b(s),l.color)),x=pick$9(u&&u.options.colorIndex,g&&g.colorIndex,y,a,t.colorIndex)),{color:v,colorIndex:x}},getLevelOptions$2=function(e){var t=null,r,o,s,a,l,h;if(isObject$3(e))for(t={},a=isNumber$3(e.from)?e.from:1,h=e.levels,o={},r=isObject$3(e.defaults)?e.defaults:{},isArray$1(h)&&(o=h.reduce(function(d,c){var p,f,u;return isObject$3(c)&&isNumber$3(c.level)&&(u=merge$7({},c),f=isBoolean(u.levelIsConstant)?u.levelIsConstant:r.levelIsConstant,delete u.levelIsConstant,delete u.level,p=c.level+(f?0:a-1),isObject$3(d[p])?extend$b(d[p],u):d[p]=u),d},{})),l=isNumber$3(e.to)?e.to:1,s=0;s<=l;s++)t[s]=merge$7({},r,isObject$3(o[s])?o[s]:{});return t},updateRootId$1=function(n){var e,t;return isObject$3(n)&&(t=isObject$3(n.options)?n.options:{},e=pick$9(n.rootNode,t.rootId,""),isObject$3(n.userOptions)&&(n.userOptions.rootId=e),n.rootNode=e),e},result={getColor:getColor$1,getLevelOptions:getLevelOptions$2,setTreeValues,updateRootId:updateRootId$1},Series$4=SeriesRegistry$1.series,addEvent$4=Utilities.addEvent,extend$a=Utilities.extend,treemapAxisDefaultValues=!1;addEvent$4(Series$4,"afterBindAxes",function(){var n=this,e=n.xAxis,t=n.yAxis,r;e&&t&&(n.is("treemap")?(r={endOnTick:!1,gridLineWidth:0,lineWidth:0,min:0,minPadding:0,max:TreemapUtilities$1.AXIS_MAX,maxPadding:0,startOnTick:!1,title:void 0,tickPositions:[]},extend$a(t.options,r),extend$a(e.options,r),treemapAxisDefaultValues=!0):treemapAxisDefaultValues&&(t.setOptions(t.userOptions),e.setOptions(e.userOptions),treemapAxisDefaultValues=!1))});var __extends$a=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),color$1=Color.parse,colorMapSeriesMixin=exports.colorMapSeriesMixin,noop=H.noop,Series$3=SeriesRegistry$1.series,_a$1=SeriesRegistry$1.seriesTypes,ColumnSeries$6=_a$1.column,HeatmapSeries=_a$1.heatmap,ScatterSeries=_a$1.scatter,getColor=result.getColor,getLevelOptions$1=result.getLevelOptions,updateRootId=result.updateRootId,addEvent$3=Utilities.addEvent,correctFloat$1=Utilities.correctFloat,defined$6=Utilities.defined,error=Utilities.error,extend$9=Utilities.extend,fireEvent=Utilities.fireEvent,isArray=Utilities.isArray,isObject$2=Utilities.isObject,isString=Utilities.isString,merge$6=Utilities.merge,pick$8=Utilities.pick,stableSort$1=Utilities.stableSort,TreemapSeries=function(n){__extends$a(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.axisRatio=void 0,t.data=void 0,t.mapOptionsToLevel=void 0,t.nodeMap=void 0,t.options=void 0,t.points=void 0,t.rootNode=void 0,t.tree=void 0,t}return e.prototype.algorithmCalcPoints=function(t,r,o,s){var a,l,h,d,c=o.lW,p=o.lH,f=o.plot,u,g=0,m=o.elArr.length-1;r?(c=o.nW,p=o.nH):u=o.elArr[o.elArr.length-1],o.elArr.forEach(function(y){(r||g<m)&&(o.direction===0?(a=f.x,l=f.y,h=c,d=y/h):(a=f.x,l=f.y,d=p,h=y/d),s.push({x:a,y:l,width:h,height:correctFloat$1(d)}),o.direction===0?f.y=f.y+d:f.x=f.x+h),g=g+1}),o.reset(),o.direction===0?o.width=o.width-c:o.height=o.height-p,f.y=f.parent.y+(f.parent.height-o.height),f.x=f.parent.x+(f.parent.width-o.width),t&&(o.direction=1-o.direction),r||o.addElement(u)},e.prototype.algorithmFill=function(t,r,o){var s=[],a,l=r.direction,h=r.x,d=r.y,c=r.width,p=r.height,f,u,g,m;return o.forEach(function(y){a=r.width*r.height*(y.val/r.val),f=h,u=d,l===0?(m=p,g=a/m,c=c-g,h=h+g):(g=c,m=a/g,p=p-m,d=d+m),s.push({x:f,y:u,width:g,height:m}),t&&(l=1-l)}),s},e.prototype.algorithmLowAspectRatio=function(t,r,o){var s=[],a=this,l,h={x:r.x,y:r.y,parent:r},d=r.direction,c=0,p=o.length-1,f=new TreemapAlgorithmGroup(r.height,r.width,d,h);return o.forEach(function(u){l=r.width*r.height*(u.val/r.val),f.addElement(l),f.lP.nR>f.lP.lR&&a.algorithmCalcPoints(t,!1,f,s,h),c===p&&a.algorithmCalcPoints(t,!0,f,s,h),c=c+1}),s},e.prototype.alignDataLabel=function(t,r,o){var s=o.style;s&&!defined$6(s.textOverflow)&&r.text&&r.getBBox().width>r.text.textWidth&&r.css({textOverflow:"ellipsis",width:s.width+="px"}),ColumnSeries$6.prototype.alignDataLabel.apply(this,arguments),t.dataLabel&&t.dataLabel.attr({zIndex:(t.node.zIndex||0)+1})},e.prototype.buildNode=function(t,r,o,s,a){var l=this,h=[],d=l.points[r],c=0,p,f;return(s[t]||[]).forEach(function(u){f=l.buildNode(l.points[u].id,u,o+1,s,t),c=Math.max(f.height+1,c),h.push(f)}),p={id:t,i:r,children:h,height:c,level:o,parent:a,visible:!1},l.nodeMap[p.id]=p,d&&(d.node=p),p},e.prototype.calculateChildrenAreas=function(t,r){var o=this,s=o.options,a=o.mapOptionsToLevel,l=a[t.level+1],h=pick$8(o[l&&l.layoutAlgorithm]&&l.layoutAlgorithm,s.layoutAlgorithm),d=s.alternateStartingDirection,c=[],p;p=t.children.filter(function(f){return!f.ignore}),l&&l.layoutStartingDirection&&(r.direction=l.layoutStartingDirection==="vertical"?0:1),c=o[h](r,p),p.forEach(function(f,u){var g=c[u];f.values=merge$6(g,{val:f.childrenTotal,direction:d?1-r.direction:r.direction}),f.pointValues=merge$6(g,{x:g.x/o.axisRatio,y:TreemapUtilities$1.AXIS_MAX-g.y-g.height,width:g.width/o.axisRatio}),f.children.length&&o.calculateChildrenAreas(f,f.values)})},e.prototype.drawDataLabels=function(){var t=this,r=t.mapOptionsToLevel,o=t.points.filter(function(l){return l.node.visible}),s,a;o.forEach(function(l){a=r[l.node.level],s={style:{}},l.node.isLeaf||(s.enabled=!1),a&&a.dataLabels&&(s=merge$6(s,a.dataLabels),t._hasPointLabels=!0),l.shapeArgs&&(s.style.width=l.shapeArgs.width,l.dataLabel&&l.dataLabel.css({width:l.shapeArgs.width+"px"})),l.dlOptions=merge$6(s,l.options.dataLabels)}),Series$3.prototype.drawDataLabels.call(this)},e.prototype.drawPoints=function(){var t=this,r=t.chart,o=r.renderer,s=t.points,a=r.styledMode,l=t.options,h=a?{}:l.shadow,d=l.borderRadius,c=r.pointCount<l.animationLimit,p=l.allowTraversingTree;s.forEach(function(f){var u=f.node.levelDynamic,g={},m={},y={},v="level-group-"+f.node.level,x=!!f.graphic,b=c&&x,$=f.shapeArgs;f.shouldDraw()&&(f.isInside=!0,d&&(m.r=d),merge$6(!0,b?g:m,x?$:{},a?{}:t.pointAttribs(f,f.selected?"select":void 0)),t.colorAttribs&&a&&extend$9(y,t.colorAttribs(f)),t[v]||(t[v]=o.g(v).attr({zIndex:1e3-(u||0)}).add(t.group),t[v].survive=!0)),f.draw({animatableAttribs:g,attribs:m,css:y,group:t[v],renderer:o,shadow:h,shapeArgs:$,shapeType:"rect"}),p&&f.graphic&&(f.drillId=l.interactByLeaf?t.drillToByLeaf(f):t.drillToByGroup(f))})},e.prototype.drillToByGroup=function(t){var r=this,o=!1;return t.node.level-r.nodeMap[r.rootNode].level===1&&!t.node.isLeaf&&(o=t.id),o},e.prototype.drillToByLeaf=function(t){var r=this,o=!1,s;if(t.node.parent!==r.rootNode&&t.node.isLeaf)for(s=t.node;!o;)s=r.nodeMap[s.parent],s.parent===r.rootNode&&(o=s.id);return o},e.prototype.drillToNode=function(t,r){error(32,!1,void 0,{"treemap.drillToNode":"use treemap.setRootNode"}),this.setRootNode(t,r)},e.prototype.drillUp=function(){var t=this,r=t.nodeMap[t.rootNode];r&&isString(r.parent)&&t.setRootNode(r.parent,!0,{trigger:"traverseUpButton"})},e.prototype.getExtremes=function(){var t=Series$3.prototype.getExtremes.call(this,this.colorValueData),r=t.dataMin,o=t.dataMax;return this.valueMin=r,this.valueMax=o,Series$3.prototype.getExtremes.call(this)},e.prototype.getListOfParents=function(t,r){var o=isArray(t)?t:[],s=isArray(r)?r:[],a=o.reduce(function(l,h,d){var c=pick$8(h.parent,"");return typeof l[c]>"u"&&(l[c]=[]),l[c].push(d),l},{"":[]});return TreemapUtilities$1.eachObject(a,function(l,h,d){h!==""&&s.indexOf(h)===-1&&(l.forEach(function(c){d[""].push(c)}),delete d[h])}),a},e.prototype.getTree=function(){var t=this,r=this.data.map(function(s){return s.id}),o=t.getListOfParents(this.data,r);return t.nodeMap={},t.buildNode("",-1,0,o)},e.prototype.hasData=function(){return!!this.processedXData.length},e.prototype.init=function(t,r){var o=this,s;this.colorAttribs=colorMapSeriesMixin.colorAttribs,s=addEvent$3(o,"setOptions",function(a){var l=a.userOptions;defined$6(l.allowDrillToNode)&&!defined$6(l.allowTraversingTree)&&(l.allowTraversingTree=l.allowDrillToNode,delete l.allowDrillToNode),defined$6(l.drillUpButton)&&!defined$6(l.traverseUpButton)&&(l.traverseUpButton=l.drillUpButton,delete l.drillUpButton)}),Series$3.prototype.init.call(o,t,r),delete o.opacity,o.eventsToUnbind.push(s),o.options.allowTraversingTree&&o.eventsToUnbind.push(addEvent$3(o,"click",o.onClickDrillToNode))},e.prototype.onClickDrillToNode=function(t){var r=this,o=t.point,s=o&&o.drillId;isString(s)&&(o.setState(""),r.setRootNode(s,!0,{trigger:"click"}))},e.prototype.pointAttribs=function(t,r){var o=this,s=isObject$2(o.mapOptionsToLevel)?o.mapOptionsToLevel:{},a=t&&s[t.node.level]||{},l=this.options,h,d=r&&l.states[r]||{},c=t&&t.getClassName()||"",p;return h={stroke:t&&t.borderColor||a.borderColor||d.borderColor||l.borderColor,"stroke-width":pick$8(t&&t.borderWidth,a.borderWidth,d.borderWidth,l.borderWidth),dashstyle:t&&t.borderDashStyle||a.borderDashStyle||d.borderDashStyle||l.borderDashStyle,fill:t&&t.color||this.color},c.indexOf("highcharts-above-level")!==-1?(h.fill="none",h["stroke-width"]=0):c.indexOf("highcharts-internal-node-interactive")!==-1?(p=pick$8(d.opacity,l.opacity),h.fill=color$1(h.fill).setOpacity(p).get(),h.cursor="pointer"):c.indexOf("highcharts-internal-node")!==-1?h.fill="none":r&&(h.fill=color$1(h.fill).brighten(d.brightness).get()),h},e.prototype.renderTraverseUpButton=function(t){var r=this,o=r.nodeMap,s=o[t],a=s.name,l=r.options.traverseUpButton,h=pick$8(l.text,a,"◁ Back"),d,c;t===""||r.is("sunburst")&&r.tree.children.length===1&&t===r.tree.children[0].id?r.drillUpButton&&(r.drillUpButton=r.drillUpButton.destroy()):this.drillUpButton?(this.drillUpButton.placed=!1,this.drillUpButton.attr({text:h}).align()):(d=l.theme,c=d&&d.states,this.drillUpButton=this.chart.renderer.button(h,0,0,function(){r.drillUp()},d,c&&c.hover,c&&c.select).addClass("highcharts-drillup-button").attr({align:l.position.align,zIndex:7}).add().align(l.position,!1,l.relativeTo||"plotBox"))},e.prototype.setColorRecursive=function(t,r,o,s,a){var l=this,h=l&&l.chart,d=h&&h.options&&h.options.colors,c,p;t&&(c=getColor(t,{colors:d,index:s,mapOptionsToLevel:l.mapOptionsToLevel,parentColor:r,parentColorIndex:o,series:l,siblings:a}),p=l.points[t.i],p&&(p.color=c.color,p.colorIndex=c.colorIndex),(t.children||[]).forEach(function(f,u){l.setColorRecursive(f,c.color,c.colorIndex,u,t.children.length)}))},e.prototype.setPointValues=function(){var t=this,r=t.points,o=t.xAxis,s=t.yAxis,a=t.chart.styledMode,l=function(h){return a?0:(t.pointAttribs(h)["stroke-width"]||0)%2/2};r.forEach(function(h){var d=h.node,c=d.pointValues,p=d.visible;if(c&&p){var f=c.height,u=c.width,g=c.x,m=c.y,y=l(h),v=Math.round(o.toPixels(g,!0))-y,x=Math.round(o.toPixels(g+u,!0))-y,b=Math.round(s.toPixels(m,!0))-y,$=Math.round(s.toPixels(m+f,!0))-y,S={x:Math.min(v,x),y:Math.min(b,$),width:Math.abs(x-v),height:Math.abs($-b)};h.plotX=S.x+S.width/2,h.plotY=S.y+S.height/2,h.shapeArgs=S}else delete h.plotX,delete h.plotY})},e.prototype.setRootNode=function(t,r,o){var s=this,a=extend$9({newRootId:t,previousRootId:s.rootNode,redraw:pick$8(r,!0),series:s},o),l=function(h){var d=h.series;d.idPreviousRoot=h.previousRootId,d.rootNode=h.newRootId,d.isDirty=!0,h.redraw&&d.chart.redraw()};fireEvent(s,"setRootNode",a,l)},e.prototype.setState=function(t){this.options.inactiveOtherPoints=!0,Series$3.prototype.setState.call(this,t,!1),this.options.inactiveOtherPoints=!1},e.prototype.setTreeValues=function(t){var r=this,o=r.options,s=r.rootNode,a=r.nodeMap,l=a[s],h=TreemapUtilities$1.isBoolean(o.levelIsConstant)?o.levelIsConstant:!0,d=0,c=[],p,f=r.points[t.i];return t.children.forEach(function(u){u=r.setTreeValues(u),c.push(u),u.ignore||(d+=u.val)}),stableSort$1(c,function(u,g){return(u.sortIndex||0)-(g.sortIndex||0)}),p=pick$8(f&&f.options.value,d),f&&(f.value=p),extend$9(t,{children:c,childrenTotal:d,ignore:!(pick$8(f&&f.visible,!0)&&p>0),isLeaf:t.visible&&!d,levelDynamic:t.level-(h?0:l.level),name:pick$8(f&&f.name,""),sortIndex:pick$8(f&&f.sortIndex,-p),val:p}),t},e.prototype.sliceAndDice=function(t,r){return this.algorithmFill(!0,t,r)},e.prototype.squarified=function(t,r){return this.algorithmLowAspectRatio(!0,t,r)},e.prototype.strip=function(t,r){return this.algorithmLowAspectRatio(!1,t,r)},e.prototype.stripes=function(t,r){return this.algorithmFill(!1,t,r)},e.prototype.translate=function(){var t=this,r=t.options,o=updateRootId(t),s,a,l,h,d;Series$3.prototype.translate.call(t),h=t.tree=t.getTree(),s=t.nodeMap[o],o!==""&&(!s||!s.children.length)&&(t.setRootNode("",!1),o=t.rootNode,s=t.nodeMap[o]),t.renderTraverseUpButton(o),t.mapOptionsToLevel=getLevelOptions$1({from:s.level+1,levels:r.levels,to:h.height,defaults:{levelIsConstant:t.options.levelIsConstant,colorByPoint:r.colorByPoint}}),TreemapUtilities$1.recursive(t.nodeMap[t.rootNode],function(c){var p=!1,f=c.parent;return c.visible=!0,(f||f==="")&&(p=t.nodeMap[f]),p}),TreemapUtilities$1.recursive(t.nodeMap[t.rootNode].children,function(c){var p=!1;return c.forEach(function(f){f.visible=!0,f.children.length&&(p=(p||[]).concat(f.children))}),p}),t.setTreeValues(h),t.axisRatio=t.xAxis.len/t.yAxis.len,t.nodeMap[""].pointValues=a={x:0,y:0,width:TreemapUtilities$1.AXIS_MAX,height:TreemapUtilities$1.AXIS_MAX},t.nodeMap[""].values=l=merge$6(a,{width:a.width*t.axisRatio,direction:r.layoutStartingDirection==="vertical"?0:1,val:h.val}),t.calculateChildrenAreas(h,l),!t.colorAxis&&!r.colorByPoint&&t.setColorRecursive(t.tree),r.allowTraversingTree&&(d=s.pointValues,t.xAxis.setExtremes(d.x,d.x+d.width,!1),t.yAxis.setExtremes(d.y,d.y+d.height,!1),t.xAxis.setScale(),t.yAxis.setScale()),t.setPointValues()},e.defaultOptions=merge$6(ScatterSeries.defaultOptions,{allowTraversingTree:!1,animationLimit:250,borderRadius:0,showInLegend:!1,marker:void 0,colorByPoint:!1,dataLabels:{defer:!1,enabled:!0,formatter:function(){var t=this&&this.point?this.point:{},r=isString(t.name)?t.name:"";return r},inside:!0,verticalAlign:"middle"},tooltip:{headerFormat:"",pointFormat:"<b>{point.name}</b>: {point.value}<br/>"},ignoreHiddenPoint:!0,layoutAlgorithm:"sliceAndDice",layoutStartingDirection:"vertical",alternateStartingDirection:!1,levelIsConstant:!0,drillUpButton:{position:{align:"right",x:-10,y:10}},traverseUpButton:{position:{align:"right",x:-10,y:10}},borderColor:palette.neutralColor10,borderWidth:1,colorKey:"colorValue",opacity:.15,states:{hover:{borderColor:palette.neutralColor40,brightness:HeatmapSeries?0:.1,halo:!1,opacity:.75,shadow:!1}}}),e}(ScatterSeries);extend$9(TreemapSeries.prototype,{buildKDTree:noop,colorKey:"colorValue",directTouch:!0,drawLegendSymbol:LegendSymbol$1.drawRectangle,getExtremesFromAll:!0,getSymbol:noop,optionalAxis:"colorAxis",parallelArrays:["x","y","value","colorValue"],pointArrayMap:["value"],pointClass:TreemapPoint,trackerGroups:["group","dataLabelsGroup"],utils:{recursive:TreemapUtilities$1.recursive}});SeriesRegistry$1.registerSeriesType("treemap",TreemapSeries);var getOptions=DefaultOptions.getOptions,addEvent$2=Utilities.addEvent,extend$8=Utilities.extend,chartPrototype=Chart$1.prototype,defaultOptions=getOptions();extend$8(defaultOptions.lang,{noData:"No data to display"});defaultOptions.noData={attr:{zIndex:1},position:{x:0,y:0,align:"center",verticalAlign:"middle"},style:{fontWeight:"bold",fontSize:"12px",color:palette.neutralColor60}};chartPrototype.showNoData=function(n){var e=this,t=e.options,r=n||t&&t.lang.noData||"",o=t&&(t.noData||{});e.renderer&&(e.noDataLabel||(e.noDataLabel=e.renderer.label(r,0,0,void 0,void 0,void 0,o.useHTML,void 0,"no-data").add()),e.styledMode||e.noDataLabel.attr(AST.filterUserAttributes(o.attr||{})).css(o.style||{}),e.noDataLabel.align(extend$8(e.noDataLabel.getBBox(),o.position||{}),!1,"plotBox"))};chartPrototype.hideNoData=function(){var n=this;n.noDataLabel&&(n.noDataLabel=n.noDataLabel.destroy())};chartPrototype.hasData=function(){for(var n=this,e=n.series||[],t=e.length;t--;)if(e[t].hasData()&&!e[t].options.isInternal)return!0;return n.loadingShown};addEvent$2(Chart$1,"render",function(){this.hasData()?this.hideNoData():this.showNoData()});var defined$5=Utilities.defined,extend$7=Utilities.extend,find$2=Utilities.find,pick$7=Utilities.pick,NodesMixin=H.NodesMixin={createNode:function(n){function e(s,a){return find$2(s,function(l){return l.id===a})}var t=e(this.nodes,n),r=this.pointClass,o;return t||(o=this.options.nodes&&e(this.options.nodes,n),t=new r().init(this,extend$7({className:"highcharts-node",isNode:!0,id:n,y:1},o)),t.linksTo=[],t.linksFrom=[],t.formatPrefix="node",t.name=t.name||t.options.id||"",t.mass=pick$7(t.options.mass,t.options.marker&&t.options.marker.radius,this.options.marker&&this.options.marker.radius,4),t.getSum=function(){var s=0,a=0;return t.linksTo.forEach(function(l){s+=l.weight}),t.linksFrom.forEach(function(l){a+=l.weight}),Math.max(s,a)},t.offset=function(s,a){for(var l=0,h=0;h<t[a].length;h++){if(t[a][h]===s)return l;l+=t[a][h].weight}},t.hasShape=function(){var s=0;return t.linksTo.forEach(function(a){a.outgoing&&s++}),!t.linksTo.length||s!==t.linksTo.length},this.nodes.push(t)),t},generatePoints:function(){var n=this.chart,e={};Series$e.prototype.generatePoints.call(this),this.nodes||(this.nodes=[]),this.colorCounter=0,this.nodes.forEach(function(t){t.linksFrom.length=0,t.linksTo.length=0,t.level=t.options.level}),this.points.forEach(function(t){defined$5(t.from)&&(e[t.from]||(e[t.from]=this.createNode(t.from)),e[t.from].linksFrom.push(t),t.fromNode=e[t.from],n.styledMode?t.colorIndex=pick$7(t.options.colorIndex,e[t.from].colorIndex):t.color=t.options.color||e[t.from].color),defined$5(t.to)&&(e[t.to]||(e[t.to]=this.createNode(t.to)),e[t.to].linksTo.push(t),t.toNode=e[t.to]),t.name=t.name||t.id},this),this.nodeLookup=e},setData:function(){this.nodes&&(this.nodes.forEach(function(n){n.destroy()}),this.nodes.length=0),Series$e.prototype.setData.apply(this,arguments)},destroy:function(){return this.data=[].concat(this.points||[],this.nodes),Series$e.prototype.destroy.apply(this,arguments)},setNodeState:function(n){var e=arguments,t=this.isNode?this.linksTo.concat(this.linksFrom):[this.fromNode,this.toNode];n!=="select"&&t.forEach(function(r){r&&r.series&&(Point$2.prototype.setState.apply(r,e),r.isNode||(r.fromNode.graphic&&Point$2.prototype.setState.apply(r.fromNode,e),r.toNode&&r.toNode.graphic&&Point$2.prototype.setState.apply(r.toNode,e)))}),Point$2.prototype.setState.apply(this,e)}},__extends$9=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),ColumnSeries$5=SeriesRegistry$1.seriesTypes.column,defined$4=Utilities.defined,extend$6=Utilities.extend,SankeyPoint$1=function(n){__extends$9(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.className=void 0,t.fromNode=void 0,t.level=void 0,t.linkBase=void 0,t.linksFrom=void 0,t.linksTo=void 0,t.mass=void 0,t.nodeX=void 0,t.nodeY=void 0,t.options=void 0,t.series=void 0,t.toNode=void 0,t}return e.prototype.applyOptions=function(t,r){return Point$2.prototype.applyOptions.call(this,t,r),defined$4(this.options.level)&&(this.options.column=this.column=this.options.level),this},e.prototype.getClassName=function(){return(this.isNode?"highcharts-node ":"highcharts-link ")+Point$2.prototype.getClassName.call(this)},e.prototype.isValid=function(){return this.isNode||typeof this.weight=="number"},e}(ColumnSeries$5.prototype.pointClass);extend$6(SankeyPoint$1.prototype,{setState:NodesMixin.setNodeState});var __extends$8=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),Series$2=SeriesRegistry$1.series,ColumnSeries$4=SeriesRegistry$1.seriesTypes.column,getLevelOptions=result.getLevelOptions,defined$3=Utilities.defined,extend$5=Utilities.extend,find$1=Utilities.find,isObject$1=Utilities.isObject,merge$5=Utilities.merge,pick$6=Utilities.pick,relativeLength$1=Utilities.relativeLength,stableSort=Utilities.stableSort,SankeySeries$1=function(n){__extends$8(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.colDistance=void 0,t.data=void 0,t.group=void 0,t.nodeLookup=void 0,t.nodePadding=void 0,t.nodes=void 0,t.nodeWidth=void 0,t.options=void 0,t.points=void 0,t.translationFactor=void 0,t}return e.getDLOptions=function(t){var r=isObject$1(t.optionsPoint)?t.optionsPoint.dataLabels:{},o=isObject$1(t.level)?t.level.dataLabels:{},s=merge$5({style:{}},o,r);return s},e.prototype.createNodeColumn=function(){var t=this,r=this.chart,o=[];return o.sum=function(){return this.reduce(function(s,a){return s+a.getSum()},0)},o.offset=function(s,a){for(var l=0,h,d=t.nodePadding,c=0;c<o.length;c++){var p=o[c].getSum(),f=Math.max(p*a,t.options.minLinkWidth);if(p?h=f+d:h=0,o[c]===s)return{relativeTop:l+relativeLength$1(s.options.offset||0,h)};l+=h}},o.top=function(s){var a=t.nodePadding,l=this.reduce(function(h,d){h>0&&(h+=a);var c=Math.max(d.getSum()*s,t.options.minLinkWidth);return h+=c,h},0);return(r.plotSizeY-l)/2},o},e.prototype.createNodeColumns=function(){var t=[];this.nodes.forEach(function(o){var s=-1,a;if(!defined$3(o.options.column))if(o.linksTo.length===0)o.column=0;else{for(var l=0;l<o.linksTo.length;l++){var h=o.linksTo[l];h.fromNode.column>s&&h.fromNode!==o&&(a=h.fromNode,s=a.column)}if(o.column=s+1,a&&a.options.layout==="hanging"){o.hangsFrom=a;var d=-1;find$1(a.linksFrom,function(c,p){var f=c.toNode===o;return f&&(d=p),f}),o.column+=d}}t[o.column]||(t[o.column]=this.createNodeColumn()),t[o.column].push(o)},this);for(var r=0;r<t.length;r++)typeof t[r]>"u"&&(t[r]=this.createNodeColumn());return t},e.prototype.generatePoints=function(){NodesMixin.generatePoints.apply(this,arguments);function t(r,o){typeof r.level>"u"&&(r.level=o,r.linksFrom.forEach(function(s){s.toNode&&t(s.toNode,o+1)}))}this.orderNodes&&(this.nodes.filter(function(r){return r.linksTo.length===0}).forEach(function(r){t(r,0)}),stableSort(this.nodes,function(r,o){return r.level-o.level}))},e.prototype.getNodePadding=function(){var t=this.options.nodePadding||0;if(this.nodeColumns){var r=this.nodeColumns.reduce(function(o,s){return Math.max(o,s.length)},0);r*t>this.chart.plotSizeY&&(t=this.chart.plotSizeY/r)}return t},e.prototype.hasData=function(){return!!this.processedXData.length},e.prototype.pointAttribs=function(t,r){if(!t)return{};var o=this,s=t.isNode?t.level:t.fromNode.level,a=o.mapOptionsToLevel[s||0]||{},l=t.options,h=a.states&&a.states[r||""]||{},d=["colorByPoint","borderColor","borderWidth","linkOpacity"].reduce(function(p,f){return p[f]=pick$6(h[f],l[f],a[f],o.options[f]),p},{}),c=pick$6(h.color,l.color,d.colorByPoint?t.color:a.color);return t.isNode?{fill:c,stroke:d.borderColor,"stroke-width":d.borderWidth}:{fill:Color.parse(c).setOpacity(d.linkOpacity).get()}},e.prototype.render=function(){var t=this.points;this.points=this.points.concat(this.nodes||[]),ColumnSeries$4.prototype.render.call(this),this.points=t},e.prototype.translate=function(){var t=this,r=function(d){for(var c=d.slice(),p=t.options.minLinkWidth||0,f,u=0,g,m=s.plotSizeY-a.borderWidth-(d.length-1)*o.nodePadding;d.length;){for(u=m/d.sum(),f=!1,g=d.length;g--;)d[g].getSum()*u<p&&(d.splice(g,1),m-=p,f=!0);if(!f)break}return d.length=0,c.forEach(function(y){return d.push(y)}),u};this.processedXData||this.processData(),this.generatePoints(),this.nodeColumns=this.createNodeColumns(),this.nodeWidth=relativeLength$1(this.options.nodeWidth,this.chart.plotSizeX);var o=this,s=this.chart,a=this.options,l=this.nodeWidth,h=this.nodeColumns;this.nodePadding=this.getNodePadding(),this.translationFactor=h.reduce(function(d,c){return Math.min(d,r(c))},1/0),this.colDistance=(s.plotSizeX-l-a.borderWidth)/Math.max(1,h.length-1),o.mapOptionsToLevel=getLevelOptions({from:1,levels:a.levels,to:h.length-1,defaults:{borderColor:a.borderColor,borderRadius:a.borderRadius,borderWidth:a.borderWidth,color:o.color,colorByPoint:a.colorByPoint,levelIsConstant:!0,linkColor:a.linkColor,linkLineWidth:a.linkLineWidth,linkOpacity:a.linkOpacity,states:a.states}}),h.forEach(function(d){d.forEach(function(c){o.translateNode(c,d)})},this),this.nodes.forEach(function(d){d.linksFrom.forEach(function(c){(c.weight||c.isNull)&&c.to&&(o.translateLink(c),c.allowShadow=!1)})})},e.prototype.translateLink=function(t){var r=function(V,j){var K=V.offset(t,j)*l,nt=Math.min(V.nodeY+K,V.nodeY+(V.shapeArgs&&V.shapeArgs.height||0)-h);return nt},o=t.fromNode,s=t.toNode,a=this.chart,l=this.translationFactor,h=Math.max(t.weight*l,this.options.minLinkWidth),d=this.options,c=(a.inverted?-this.colDistance:this.colDistance)*d.curveFactor,p=r(o,"linksFrom"),f=r(s,"linksTo"),u=o.nodeX,g=this.nodeWidth,m=s.column*this.colDistance,y=t.outgoing,v=m>u+g;if(a.inverted&&(p=a.plotSizeY-p,f=(a.plotSizeY||0)-f,m=a.plotSizeX-m,g=-g,h=-h,v=u>m),t.shapeType="path",t.linkBase=[p,p+h,f,f+h],v&&typeof f=="number")t.shapeArgs={d:[["M",u+g,p],["C",u+g+c,p,m-c,f,m,f],["L",m+(y?g:0),f+h/2],["L",m,f+h],["C",m-c,f+h,u+g+c,p+h,u+g,p+h],["Z"]]};else if(typeof f=="number"){var x=20,b=a.plotHeight-p-h,$=m-x-h,S=m-x,k=m,A=u+g,M=A+x,P=M+h,E=p,T=p+h,O=T+x,C=O+b,I=C+x,L=I+h,D=f,N=D+h,B=N+x,X=T-h*.7,W=I+h*.7,F=N-h*.7,U=k-h*.7,z=A+h*.7;t.shapeArgs={d:[["M",A,E],["C",z,E,P,X,P,O],["L",P,C],["C",P,W,z,L,A,L],["L",k,L],["C",U,L,$,W,$,C],["L",$,B],["C",$,F,U,D,k,D],["L",k,N],["C",S,N,S,N,S,B],["L",S,C],["C",S,I,S,I,k,I],["L",A,I],["C",M,I,M,I,M,C],["L",M,O],["C",M,T,M,T,A,T],["Z"]]}}t.dlBox={x:u+(m-u+g)/2,y:p+(f-p)/2,height:h,width:0},t.tooltipPos=a.inverted?[a.plotSizeY-t.dlBox.y-h/2,a.plotSizeX-t.dlBox.x]:[t.dlBox.x,t.dlBox.y+h/2],t.y=t.plotY=1,t.color||(t.color=o.color)},e.prototype.translateNode=function(t,r){var o=this.translationFactor,s=this.chart,a=this.options,l=t.getSum(),h=Math.max(Math.round(l*o),this.options.minLinkWidth),d=Math.round(a.borderWidth)%2/2,c=r.offset(t,o),p=Math.floor(pick$6(c.absoluteTop,r.top(o)+c.relativeTop))+d,f=Math.floor(this.colDistance*t.column+a.borderWidth/2)+d,u=s.inverted?s.plotSizeX-f:f,g=Math.round(this.nodeWidth);if(t.sum=l,l){t.shapeType="rect",t.nodeX=u,t.nodeY=p;var m=u,y=p,v=t.options.width||a.width||g,x=t.options.height||a.height||h;s.inverted&&(m=u-g,y=s.plotSizeY-p-h,v=t.options.height||a.height||g,x=t.options.width||a.width||h),t.dlOptions=e.getDLOptions({level:this.mapOptionsToLevel[t.level],optionsPoint:t.options}),t.plotX=1,t.plotY=1,t.tooltipPos=s.inverted?[s.plotSizeY-y-x/2,s.plotSizeX-m-v/2]:[m+v/2,y+x/2],t.shapeArgs={x:m,y,width:v,height:x,display:t.hasShape()?"":"none"}}else t.dlOptions={enabled:!1}},e.defaultOptions=merge$5(ColumnSeries$4.defaultOptions,{borderWidth:0,colorByPoint:!0,curveFactor:.33,dataLabels:{enabled:!0,backgroundColor:"none",crop:!1,nodeFormat:void 0,nodeFormatter:function(){return this.point.name},format:void 0,formatter:function(){},inside:!0},inactiveOtherPoints:!0,linkOpacity:.5,minLinkWidth:0,nodeWidth:20,nodePadding:10,showInLegend:!1,states:{hover:{linkOpacity:1},inactive:{linkOpacity:.1,opacity:.1,animation:{duration:50}}},tooltip:{followPointer:!0,headerFormat:'<span style="font-size: 10px">{series.name}</span><br/>',pointFormat:"{point.fromNode.name} → {point.toNode.name}: <b>{point.weight}</b><br/>",nodeFormat:"{point.name}: <b>{point.sum}</b><br/>"}}),e}(ColumnSeries$4);extend$5(SankeySeries$1.prototype,{animate:Series$2.prototype.animate,createNode:NodesMixin.createNode,destroy:NodesMixin.destroy,forceDL:!0,invertible:!0,isCartesian:!1,orderNodes:!0,pointArrayMap:["from","to"],pointClass:SankeyPoint$1,searchPoint:H.noop,setData:NodesMixin.setData});SeriesRegistry$1.registerSeriesType("sankey",SankeySeries$1);var __extends$7=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),Series$1=SeriesRegistry$1.series,PiePoint=SeriesRegistry$1.seriesTypes.pie.prototype.pointClass,defined$2=Utilities.defined,isNumber$2=Utilities.isNumber,merge$4=Utilities.merge,objectEach=Utilities.objectEach,pick$5=Utilities.pick,TimelinePoint=function(n){__extends$7(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return e.prototype.alignConnector=function(){var t=this,r=t.series,o=t.connector,s=t.dataLabel,a=t.dataLabel.options=merge$4(r.options.dataLabels,t.options.dataLabels),l=t.series.chart,h=o.getBBox(),d={x:h.x+s.translateX,y:h.y+s.translateY},c;l.inverted?d.y-=s.options.connectorWidth/2:d.x+=s.options.connectorWidth/2,c=l.isInsidePlot(d.x,d.y),o[c?"animate":"attr"]({d:t.getConnectorPath()}),r.chart.styledMode||o.attr({stroke:a.connectorColor||t.color,"stroke-width":a.connectorWidth,opacity:s[defined$2(s.newOpacity)?"newOpacity":"opacity"]})},e.prototype.drawConnector=function(){var t=this,r=t.series;t.connector||(t.connector=r.chart.renderer.path(t.getConnectorPath()).attr({zIndex:-1}).add(t.dataLabel)),t.series.chart.isInsidePlot(t.dataLabel.x,t.dataLabel.y)&&t.alignConnector()},e.prototype.getConnectorPath=function(){var t=this,r=t.series.chart,o=t.series.xAxis.len,s=r.inverted,a=s?"x2":"y2",l=t.dataLabel,h=l.targetPosition,d={x1:t.plotX,y1:t.plotY,x2:t.plotX,y2:isNumber$2(h.y)?h.y:l.y},c=(l.alignAttr||l)[a[0]]<t.series.yAxis.len/2,p;return s&&(d={x1:t.plotY,y1:o-t.plotX,x2:h.x||l.x,y2:o-t.plotX}),c&&(d[a]+=l[s?"width":"height"]),objectEach(d,function(f,u){d[u]-=(l.alignAttr||l)[u[0]]}),p=r.renderer.crispLine([["M",d.x1,d.y1],["L",d.x2,d.y2]],l.options.connectorWidth),p},e.prototype.init=function(){var t=n.prototype.init.apply(this,arguments);return t.name=pick$5(t.name,"Event"),t.y=1,t},e.prototype.isValid=function(){return this.options.y!==null},e.prototype.setState=function(){var t=n.prototype.setState;this.isNull||t.apply(this,arguments)},e.prototype.setVisible=function(t,r){var o=this,s=o.series;r=pick$5(r,s.options.ignoreHiddenPoint),PiePoint.prototype.setVisible.call(o,t,!1),s.processData(),r&&s.chart.redraw()},e.prototype.applyOptions=function(t,r){return t=Point$2.prototype.optionsToObject.call(this,t),this.userDLOptions=merge$4(this.userDLOptions,t.dataLabels),n.prototype.applyOptions.call(this,t,r)},e}(Series$1.prototype.pointClass),__extends$6=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),_a=SeriesRegistry$1.seriesTypes,ColumnSeries$3=_a.column,LineSeries=_a.line,addEvent$1=Utilities.addEvent,arrayMax=Utilities.arrayMax,arrayMin=Utilities.arrayMin,defined$1=Utilities.defined,extend$4=Utilities.extend,merge$3=Utilities.merge,pick$4=Utilities.pick,TimelineSeries=function(n){__extends$6(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t.userOptions=void 0,t.visibilityMap=void 0,t}return e.prototype.alignDataLabel=function(t,r,o,s){var a=this,l=a.chart.inverted,h=a.visibilityMap.filter(function($){return $}),d=a.visiblePointsCount,c=h.indexOf(t),p=!c||c===d-1,f=a.options.dataLabels,u=t.userDLOptions||{},g=f.alternate?p?1.5:2:1,m,y=Math.floor(a.xAxis.len/d),v=r.padding,x,b;t.visible&&(m=Math.abs(u.x||t.options.dataLabels.x),l?(x=(m-v)*2-t.itemHeight/2,b={width:x+"px",textOverflow:r.width/x*r.height/2>y*g?"ellipsis":"none"}):b={width:(u.width||f.width||y*g-v*2)+"px"},r.css(b),a.chart.styledMode||r.shadow(f.shadow)),n.prototype.alignDataLabel.apply(a,arguments)},e.prototype.bindAxes=function(){var t=this;n.prototype.bindAxes.call(t),["xAxis","yAxis"].forEach(function(r){r==="xAxis"&&!t[r].userOptions.type&&(t[r].categories=t[r].hasNames=!0)})},e.prototype.distributeDL=function(){var t=this,r=t.options.dataLabels,o=1;if(r){var s=r.distance||0;t.points.forEach(function(a){var l;a.options.dataLabels=merge$3((l={},l[t.chart.inverted?"x":"y"]=r.alternate&&o%2?-s:s,l),a.userDLOptions),o++})}},e.prototype.generatePoints=function(){var t=this;n.prototype.generatePoints.apply(t),t.points.forEach(function(r,o){r.applyOptions({x:t.xData[o]},t.xData[o])})},e.prototype.getVisibilityMap=function(){var t=this,r=(t.data.length?t.data:t.userOptions.data).map(function(o){return o&&o.visible!==!1&&!o.isNull?o:!1});return r},e.prototype.getXExtremes=function(t){var r=this,o=t.filter(function(s,a){return r.points[a].isValid()&&r.points[a].visible});return{min:arrayMin(o),max:arrayMax(o)}},e.prototype.init=function(){var t=this;n.prototype.init.apply(t,arguments),t.eventsToUnbind.push(addEvent$1(t,"afterTranslate",function(){var r,o=Number.MAX_VALUE;t.points.forEach(function(s){s.isInside=s.isInside&&s.visible,s.visible&&!s.isNull&&(defined$1(r)&&(o=Math.min(o,Math.abs(s.plotX-r))),r=s.plotX)}),t.closestPointRangePx=o})),t.eventsToUnbind.push(addEvent$1(t,"drawDataLabels",function(){t.distributeDL()})),t.eventsToUnbind.push(addEvent$1(t,"afterDrawDataLabels",function(){var r;t.points.forEach(function(o){if(r=o.dataLabel,r)return r.animate=function(s){return this.targetPosition&&(this.targetPosition=s),SVGElement.prototype.animate.apply(this,arguments)},r.targetPosition||(r.targetPosition={}),o.drawConnector()})})),t.eventsToUnbind.push(addEvent$1(t.chart,"afterHideOverlappingLabel",function(){t.points.forEach(function(r){r.connector&&r.dataLabel&&r.dataLabel.oldOpacity!==r.dataLabel.newOpacity&&r.alignConnector()})}))},e.prototype.markerAttribs=function(t,r){var o=this,s=o.options.marker,a,l=t.marker||{},h=l.symbol||s.symbol,d,c=pick$4(l.width,s.width,o.closestPointRangePx),p=pick$4(l.height,s.height),f=0,u;return o.xAxis.dateTime?n.prototype.markerAttribs.call(this,t,r):(r&&(a=s.states[r]||{},d=l.states&&l.states[r]||{},f=pick$4(d.radius,a.radius,f+(a.radiusPlus||0))),t.hasImage=h&&h.indexOf("url")===0,u={x:Math.floor(t.plotX)-c/2-f/2,y:t.plotY-p/2-f/2,width:c+f,height:p+f},u)},e.prototype.processData=function(){var t=this,r=0,o;for(t.visibilityMap=t.getVisibilityMap(),t.visibilityMap.forEach(function(s){s&&r++}),t.visiblePointsCount=r,o=0;o<t.xData.length;o++)t.yData[o]=1;n.prototype.processData.call(this,arguments)},e.defaultOptions=merge$3(LineSeries.defaultOptions,{colorByPoint:!0,stickyTracking:!1,ignoreHiddenPoint:!0,legendType:"point",lineWidth:4,tooltip:{headerFormat:'<span style="color:{point.color}">●</span> <span style="font-size: 10px"> {point.key}</span><br/>',pointFormat:"{point.description}"},states:{hover:{lineWidthPlus:0}},dataLabels:{enabled:!0,allowOverlap:!0,alternate:!0,backgroundColor:palette.backgroundColor,borderWidth:1,borderColor:palette.neutralColor40,borderRadius:3,color:palette.neutralColor80,connectorWidth:1,distance:100,formatter:function(){var t;return this.series.chart.styledMode?t="<span>● </span>":t='<span style="color:'+this.point.color+'">● </span>',t+='<span class="highcharts-strong">'+(this.key||"")+"</span><br/>"+(this.point.label||""),t},style:{textOutline:"none",fontWeight:"normal",fontSize:"12px"},shadow:!1,verticalAlign:"middle"},marker:{enabledThreshold:0,symbol:"square",radius:6,lineWidth:2,height:15},showInLegend:!1,colorKey:"x"}),e}(LineSeries);extend$4(TimelineSeries.prototype,{drawLegendSymbol:LegendSymbol$1.drawRectangle,drawTracker:ColumnSeries$3.prototype.drawTracker,pointClass:TimelinePoint,trackerGroups:["markerGroup","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("timeline",TimelineSeries);var __extends$5=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),SankeyPoint=SeriesRegistry$1.seriesTypes.sankey.prototype.pointClass,OrganizationPoint=function(n){__extends$5(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.fromNode=void 0,t.linksFrom=void 0,t.linksTo=void 0,t.options=void 0,t.series=void 0,t.toNode=void 0,t}return e.prototype.getSum=function(){return 1},e}(SankeyPoint),__extends$4=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),SankeySeries=SeriesRegistry$1.seriesTypes.sankey,css=Utilities.css,extend$3=Utilities.extend,merge$2=Utilities.merge,pick$3=Utilities.pick,wrap=Utilities.wrap,OrganizationSeries=function(n){__extends$4(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.curvedPath=function(t,r){for(var o=[],s=0;s<t.length;s++){var a=t[s][1],l=t[s][2];if(typeof a=="number"&&typeof l=="number")if(s===0)o.push(["M",a,l]);else if(s===t.length-1)o.push(["L",a,l]);else if(r){var h=t[s-1],d=t[s+1];if(h&&d){var c=h[1],p=h[2],f=d[1],u=d[2];if(typeof c=="number"&&typeof f=="number"&&typeof p=="number"&&typeof u=="number"&&c!==f&&p!==u){var g=c<f?1:-1,m=p<u?1:-1;o.push(["L",a-g*Math.min(Math.abs(a-c),r),l-m*Math.min(Math.abs(l-p),r)],["C",a,l,a,l,a+g*Math.min(Math.abs(a-f),r),l+m*Math.min(Math.abs(l-u),r)])}}}else o.push(["L",a,l])}return o},e.prototype.alignDataLabel=function(t,r,o){if(o.useHTML){var s=t.shapeArgs.width,a=t.shapeArgs.height,l=this.options.borderWidth+2*this.options.dataLabels.padding;this.chart.inverted&&(s=a,a=t.shapeArgs.width),a-=l,s-=l;var h=r.text;h&&(css(h.element.parentNode,{width:s+"px",height:a+"px"}),css(h.element,{left:0,top:0,width:"100%",height:"100%",overflow:"hidden"})),r.getBBox=function(){return{width:s,height:a}},r.width=s,r.height=a}n.prototype.alignDataLabel.apply(this,arguments)},e.prototype.createNode=function(t){var r=n.prototype.createNode.call(this,t);return r.getSum=function(){return 1},r},e.prototype.createNodeColumn=function(){var t=n.prototype.createNodeColumn.call(this);return wrap(t,"offset",function(r,o,s){var a=r.call(this,o,s);return o.hangsFrom?{absoluteTop:o.hangsFrom.nodeY}:a}),t},e.prototype.pointAttribs=function(t,r){var o=this,s=SankeySeries.prototype.pointAttribs.call(o,t,r),a=t.isNode?t.level:t.fromNode.level,l=o.mapOptionsToLevel[a||0]||{},h=t.options,d=l.states&&l.states[r]||{},c=["borderRadius","linkColor","linkLineWidth"].reduce(function(p,f){return p[f]=pick$3(d[f],h[f],l[f],o.options[f]),p},{});return t.isNode?c.borderRadius&&(s.r=c.borderRadius):(s.stroke=c.linkColor,s["stroke-width"]=c.linkLineWidth,delete s.fill),s},e.prototype.translateLink=function(t){var r=t.fromNode,o=t.toNode,s=Math.round(this.options.linkLineWidth)%2/2,a=Math.floor(r.shapeArgs.x+r.shapeArgs.width)+s,l=Math.floor(r.shapeArgs.y+r.shapeArgs.height/2)+s,h=Math.floor(o.shapeArgs.x)+s,d=Math.floor(o.shapeArgs.y+o.shapeArgs.height/2)+s,c,p=this.options.hangingIndent,f=o.options.offset,u=/%$/.test(f)&&parseInt(f,10),g=this.chart.inverted;g&&(a-=r.shapeArgs.width,h+=o.shapeArgs.width),c=Math.floor(h+(g?1:-1)*(this.colDistance-this.nodeWidth)/2)+s,u&&(u>=50||u<=-50)&&(c=h=Math.floor(h+(g?-.5:.5)*o.shapeArgs.width)+s,d=o.shapeArgs.y,u>0&&(d+=o.shapeArgs.height)),o.hangsFrom===r&&(this.chart.inverted?(l=Math.floor(r.shapeArgs.y+r.shapeArgs.height-p/2)+s,d=o.shapeArgs.y+o.shapeArgs.height):l=Math.floor(r.shapeArgs.y+p/2)+s,c=h=Math.floor(o.shapeArgs.x+o.shapeArgs.width/2)+s),t.plotY=1,t.shapeType="path",t.shapeArgs={d:e.curvedPath([["M",a,l],["L",c,l],["L",c,d],["L",h,d]],this.options.linkRadius)}},e.prototype.translateNode=function(t,r){SankeySeries.prototype.translateNode.call(this,t,r),t.hangsFrom&&(t.shapeArgs.height-=this.options.hangingIndent,this.chart.inverted||(t.shapeArgs.y+=this.options.hangingIndent)),t.nodeHeight=this.chart.inverted?t.shapeArgs.width:t.shapeArgs.height},e.defaultOptions=merge$2(SankeySeries.defaultOptions,{borderColor:palette.neutralColor60,borderRadius:3,linkRadius:10,borderWidth:1,dataLabels:{nodeFormatter:function(){var t={width:"100%",height:"100%",display:"flex","flex-direction":"row","align-items":"center","justify-content":"center"},r={"max-height":"100%","border-radius":"50%"},o={width:"100%",padding:0,"text-align":"center","white-space":"normal"},s={margin:0},a={margin:0},l={opacity:.75,margin:"5px"};function h(c){return Object.keys(c).reduce(function(p,f){return p+f+":"+c[f]+";"},'style="')+'"'}this.point.image&&(r["max-width"]="30%",o.width="70%"),this.series.chart.renderer.forExport&&(t.display="block",o.position="absolute",o.left=this.point.image?"30%":0,o.top=0);var d="<div "+h(t)+">";return this.point.image&&(d+='<img src="'+this.point.image+'" '+h(r)+">"),d+="<div "+h(o)+">",this.point.name&&(d+="<h4 "+h(s)+">"+this.point.name+"</h4>"),this.point.title&&(d+="<p "+h(a)+">"+(this.point.title||"")+"</p>"),this.point.description&&(d+="<p "+h(l)+">"+this.point.description+"</p>"),d+="</div></div>",d},style:{fontWeight:"normal",fontSize:"13px"},useHTML:!0},hangingIndent:20,linkColor:palette.neutralColor60,linkLineWidth:1,nodeWidth:50,tooltip:{nodeFormat:"{point.name}<br>{point.title}<br>{point.description}"}}),e}(SankeySeries);extend$3(OrganizationSeries.prototype,{pointClass:OrganizationPoint});SeriesRegistry$1.registerSeriesType("organization",OrganizationSeries);var __extends$3=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),ColumnSeries$2=SeriesRegistry$1.seriesTypes.column,extend$2=Utilities.extend,XRangePoint=function(n){__extends$3(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return e.getColorByCategory=function(t,r){var o=t.options.colors||t.chart.options.colors,s=o?o.length:t.chart.options.chart.colorCount,a=r.y%s,l=o&&o[a];return{colorIndex:a,color:l}},e.prototype.resolveColor=function(){var t=this.series,r;t.options.colorByPoint&&!this.options.color?(r=e.getColorByCategory(t,this),t.chart.styledMode||(this.color=r.color),this.options.colorIndex||(this.colorIndex=r.colorIndex)):this.color||(this.color=t.color)},e.prototype.init=function(){return Point$2.prototype.init.apply(this,arguments),this.y||(this.y=0),this},e.prototype.setState=function(){Point$2.prototype.setState.apply(this,arguments),this.series.drawPoint(this,this.series.getAnimationVerb())},e.prototype.getLabelConfig=function(){var t=this,r=Point$2.prototype.getLabelConfig.call(t),o=t.series.yAxis.categories;return r.x2=t.x2,r.yCategory=t.yCategory=o&&o[t.y],r},e.prototype.isValid=function(){return typeof this.x=="number"&&typeof this.x2=="number"},e}(ColumnSeries$2.prototype.pointClass);extend$2(XRangePoint.prototype,{tooltipDateKeys:["x","x2"]});var addEvent=Utilities.addEvent,pick$2=Utilities.pick;addEvent(Axis,"afterGetSeriesExtremes",function(){var n=this,e=n.series,t,r;n.isXAxis&&(t=pick$2(n.dataMax,-Number.MAX_VALUE),e.forEach(function(o){o.x2Data&&o.x2Data.forEach(function(s){s>t&&(t=s,r=!0)})}),r&&(n.dataMax=t))});var __extends$2=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),color=Color.parse,Series=SeriesRegistry$1.series,ColumnSeries$1=SeriesRegistry$1.seriesTypes.column,columnProto=ColumnSeries$1.prototype,clamp=Utilities.clamp,correctFloat=Utilities.correctFloat,defined=Utilities.defined,extend$1=Utilities.extend,find=Utilities.find,isNumber$1=Utilities.isNumber,isObject=Utilities.isObject,merge$1=Utilities.merge,pick$1=Utilities.pick,XRangeSeries=function(n){__extends$2(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return e.prototype.init=function(){ColumnSeries$1.prototype.init.apply(this,arguments),this.options.stacking=void 0},e.prototype.getColumnMetrics=function(){var t,r=this.chart;function o(){r.series.forEach(function(s){var a=s.xAxis;s.xAxis=s.yAxis,s.yAxis=a})}return o(),t=columnProto.getColumnMetrics.call(this),o(),t},e.prototype.cropData=function(t,r,o,s){var a=Series.prototype.cropData,l=a.call(this,this.x2Data,r,o,s);return l.xData=t.slice(l.start,l.end),l},e.prototype.findPointIndex=function(t){var r=this,o=r.cropped,s=r.cropStart,a=r.points,l=t.id,h;if(l){var d=find(a,function(c){return c.id===l});h=d?d.index:void 0}if(typeof h>"u"){var d=find(a,function(p){return p.x===t.x&&p.x2===t.x2&&!p.touched});h=d?d.index:void 0}return o&&isNumber$1(h)&&isNumber$1(s)&&h>=s&&(h-=s),h},e.prototype.translatePoint=function(t){var r=this,o=r.xAxis,s=r.yAxis,a=r.columnMetrics,l=r.options,h=l.minPointLength||0,d=(t.shapeArgs&&t.shapeArgs.width||0)/2,c=r.pointXOffset=a.offset,p=t.plotX,f=pick$1(t.x2,t.x+(t.len||0)),u=o.translate(f,0,0,0,1),g=Math.abs(u-p),m,y,v=this.chart.inverted,x=pick$1(l.borderWidth,1),b=x%2/2,$=a.offset,S=Math.round(a.width),k,A,M,P,E;h&&(m=h-g,m<0&&(m=0),p-=m/2,u+=m/2),p=Math.max(p,-10),u=clamp(u,-10,o.len+10),defined(t.options.pointWidth)&&($-=(Math.ceil(t.options.pointWidth)-S)/2,S=Math.ceil(t.options.pointWidth)),l.pointPlacement&&isNumber$1(t.plotY)&&s.categories&&(t.plotY=s.translate(t.y,0,1,0,1,l.pointPlacement));var T=Math.floor(Math.min(p,u))+b,O=Math.floor(Math.max(p,u))+b,C={x:T,y:Math.floor(t.plotY+$)+b,width:O-T,height:S,r:r.options.borderRadius};t.shapeArgs=C,v?t.tooltipPos[1]+=c+d:t.tooltipPos[0]-=d+c-C.width/2,k=C.x,A=k+C.width,k<0||A>o.len?(k=clamp(k,0,o.len),A=clamp(A,0,o.len),M=A-k,t.dlBox=merge$1(C,{x:k,width:A-k,centerX:M?M/2:null})):t.dlBox=null;var I=t.tooltipPos,L=v?1:0,D=v?0:1;E=r.columnMetrics?r.columnMetrics.offset:-a.width/2,v?I[L]+=C.width/2:I[L]+=(o.reversed?-1:0)*C.width,I[D]=clamp(I[D]+(v?-1:1)*E,0,s.len-1),y=t.partialFill,y&&(isObject(y)&&(y=y.amount),isNumber$1(y)||(y=0),t.partShapeArgs=merge$1(C,{r:r.options.borderRadius}),P=Math.max(Math.round(g*y+t.plotX-p),0),t.clipRectArgs={x:o.reversed?C.x+g-P:C.x,y:C.y,width:P,height:C.height})},e.prototype.translate=function(){columnProto.translate.apply(this,arguments),this.points.forEach(function(t){this.translatePoint(t)},this)},e.prototype.drawPoint=function(t,r){var o=this,s=o.options,a=o.chart.renderer,l=t.graphic,h=t.shapeType,d=t.shapeArgs,c=t.partShapeArgs,p=t.clipRectArgs,f=t.partialFill,u=s.stacking&&!s.borderRadius,g=t.state,m=s.states[g||"normal"]||{},y=typeof g>"u"?"attr":r,v=o.pointAttribs(t,g),x=pick$1(o.chart.options.chart.animation,m.animation),b;!t.isNull&&t.visible!==!1?(l?l.rect[r](d):(t.graphic=l=a.g("point").addClass(t.getClassName()).add(t.group||o.group),l.rect=a[h](merge$1(d)).addClass(t.getClassName()).addClass("highcharts-partfill-original").add(l)),c&&(l.partRect?(l.partRect[r](merge$1(c)),l.partialClipRect[r](merge$1(p))):(l.partialClipRect=a.clipRect(p.x,p.y,p.width,p.height),l.partRect=a[h](c).addClass("highcharts-partfill-overlay").add(l).clip(l.partialClipRect))),o.chart.styledMode||(l.rect[r](v,x).shadow(s.shadow,null,u),c&&(isObject(f)||(f={}),isObject(s.partialFill)&&(f=merge$1(s.partialFill,f)),b=f.fill||color(v.fill).brighten(-.3).get()||color(t.color||o.color).brighten(-.3).get(),v.fill=b,l.partRect[y](v,x).shadow(s.shadow,null,u)))):l&&(t.graphic=l.destroy())},e.prototype.drawPoints=function(){var t=this,r=t.getAnimationVerb();t.points.forEach(function(o){t.drawPoint(o,r)})},e.prototype.getAnimationVerb=function(){return this.chart.pointCount<(this.options.animationLimit||250)?"animate":"attr"},e.prototype.isPointInside=function(t){var r=t.shapeArgs,o=t.plotX,s=t.plotY;if(!r)return n.prototype.isPointInside.apply(this,arguments);var a=typeof o<"u"&&typeof s<"u"&&s>=0&&s<=this.yAxis.len&&(r.x||0)+(r.width||0)>=0&&o<=this.xAxis.len;return a},e.defaultOptions=merge$1(ColumnSeries$1.defaultOptions,{colorByPoint:!0,dataLabels:{formatter:function(){var t=this.point,r=t.partialFill;if(isObject(r)&&(r=r.amount),isNumber$1(r)&&r>0)return correctFloat(r*100)+"%"},inside:!0,verticalAlign:"middle"},tooltip:{headerFormat:'<span style="font-size: 10px">{point.x} - {point.x2}</span><br/>',pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.yCategory}</b><br/>'},borderRadius:3,pointRange:0}),e}(ColumnSeries$1);extend$1(XRangeSeries.prototype,{type:"xrange",parallelArrays:["x","x2","y"],requireSorting:!1,animate:Series.prototype.animate,cropShoulder:1,getExtremesFromAll:!0,autoIncrement:H.noop,buildKDTree:H.noop,pointClass:XRangePoint});SeriesRegistry$1.registerSeriesType("xrange",XRangeSeries);var __extends$1=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),BulletPoint=function(n){__extends$1(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.options=void 0,t.series=void 0,t}return e.prototype.destroy=function(){this.targetGraphic&&(this.targetGraphic=this.targetGraphic.destroy()),n.prototype.destroy.apply(this,arguments)},e}(ColumnSeries$h.prototype.pointClass),__extends=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,o){r.__proto__=o}||function(r,o){for(var s in o)o.hasOwnProperty(s)&&(r[s]=o[s])},n(e,t)};return function(e,t){n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),ColumnSeries=SeriesRegistry$1.seriesTypes.column,extend=Utilities.extend,isNumber=Utilities.isNumber,merge=Utilities.merge,pick=Utilities.pick,relativeLength=Utilities.relativeLength,BulletSeries=function(n){__extends(e,n);function e(){var t=n!==null&&n.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t.targetData=void 0,t}return e.prototype.drawPoints=function(){var t=this,r=t.chart,o=t.options,s=o.animationLimit||250;n.prototype.drawPoints.apply(this,arguments),t.points.forEach(function(a){var l=a.options,h=a.target,d=a.y,c,p=a.targetGraphic,f,u,g,m;if(isNumber(h)&&h!==null){g=merge(o.targetOptions,l.targetOptions),u=g.height;var y=a.shapeArgs;a.dlBox&&y&&!isNumber(y.width)&&(y=a.dlBox),f=relativeLength(g.width,y.width),m=t.yAxis.translate(h,!1,!0,!1,!0)-g.height/2-.5,c=t.crispCol.apply({chart:r,borderWidth:g.borderWidth,options:{crisp:o.crisp}},[y.x+y.width/2-f/2,m,f,u]),p?(p[r.pointCount<s?"animate":"attr"](c),isNumber(d)&&d!==null?p.element.point=a:p.element.point=void 0):a.targetGraphic=p=r.renderer.rect().attr(c).add(t.group),r.styledMode||p.attr({fill:pick(g.color,l.color,t.zones.length&&(a.getZone.call({series:t,x:a.x,y:h,options:{}}).color||t.color)||void 0,a.color,t.color),stroke:pick(g.borderColor,a.borderColor,t.options.borderColor),"stroke-width":g.borderWidth,r:g.borderRadius}),isNumber(d)&&d!==null&&(p.element.point=a),p.addClass(a.getClassName()+" highcharts-bullet-target",!0)}else p&&(a.targetGraphic=p.destroy())})},e.prototype.getExtremes=function(t){var r=n.prototype.getExtremes.call(this,t),o=this,s=o.targetData;if(s&&s.length){var a=n.prototype.getExtremes.call(this,s);isNumber(a.dataMin)&&(r.dataMin=Math.min(pick(r.dataMin,1/0),a.dataMin)),isNumber(a.dataMax)&&(r.dataMax=Math.max(pick(r.dataMax,-1/0),a.dataMax))}return r},e.defaultOptions=merge(ColumnSeries.defaultOptions,{targetOptions:{width:"140%",height:3,borderWidth:0,borderRadius:0},tooltip:{pointFormat:'<span style="color:{series.color}">●</span> {series.name}: <b>{point.y}</b>. Target: <b>{point.target}</b><br/>'}}),e}(ColumnSeries);extend(BulletSeries.prototype,{parallelArrays:["x","y","target"],pointArrayMap:["y","target"]});BulletSeries.prototype.pointClass=BulletPoint;SeriesRegistry$1.registerSeriesType("bullet",BulletSeries);/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/function isSlot(n){return n.localName==="slot"}let FlattenedNodesObserver=class{static getFlattenedNodes(n){const e=wrap$e(n);if(isSlot(n))return n=n,e.assignedNodes({flatten:!0});{const t=[];for(let r=0;r<e.childNodes.length;r++){const o=e.childNodes[r];if(isSlot(o)){const s=o;t.push(...wrap$e(s).assignedNodes({flatten:!0}))}else t.push(o)}return t}}constructor(n,e){this._shadyChildrenObserver=null,this._nativeChildrenObserver=null,this._connected=!1,this._target=n,this.callback=e,this._effectiveNodes=[],this._observer=null,this._scheduled=!1,this._boundSchedule=()=>{this._schedule()},this.connect(),this._schedule()}connect(){isSlot(this._target)?this._listenSlots([this._target]):wrap$e(this._target).children&&(this._listenSlots(wrap$e(this._target).children),window.ShadyDOM?this._shadyChildrenObserver=window.ShadyDOM.observeChildren(this._target,n=>{this._processMutations(n)}):(this._nativeChildrenObserver=new MutationObserver(n=>{this._processMutations(n)}),this._nativeChildrenObserver.observe(this._target,{childList:!0}))),this._connected=!0}disconnect(){isSlot(this._target)?this._unlistenSlots([this._target]):wrap$e(this._target).children&&(this._unlistenSlots(wrap$e(this._target).children),window.ShadyDOM&&this._shadyChildrenObserver?(window.ShadyDOM.unobserveChildren(this._shadyChildrenObserver),this._shadyChildrenObserver=null):this._nativeChildrenObserver&&(this._nativeChildrenObserver.disconnect(),this._nativeChildrenObserver=null)),this._connected=!1}_schedule(){this._scheduled||(this._scheduled=!0,microTask.run(()=>this.flush()))}_processMutations(n){this._processSlotMutations(n),this.flush()}_processSlotMutations(n){if(n)for(let e=0;e<n.length;e++){let t=n[e];t.addedNodes&&this._listenSlots(t.addedNodes),t.removedNodes&&this._unlistenSlots(t.removedNodes)}}flush(){if(!this._connected)return!1;window.ShadyDOM&&ShadyDOM.flush(),this._nativeChildrenObserver?this._processSlotMutations(this._nativeChildrenObserver.takeRecords()):this._shadyChildrenObserver&&this._processSlotMutations(this._shadyChildrenObserver.takeRecords()),this._scheduled=!1;let n={target:this._target,addedNodes:[],removedNodes:[]},e=this.constructor.getFlattenedNodes(this._target),t=calculateSplices(e,this._effectiveNodes);for(let o=0,s;o<t.length&&(s=t[o]);o++)for(let a=0,l;a<s.removed.length&&(l=s.removed[a]);a++)n.removedNodes.push(l);for(let o=0,s;o<t.length&&(s=t[o]);o++)for(let a=s.index;a<s.index+s.addedCount;a++)n.addedNodes.push(e[a]);this._effectiveNodes=e;let r=!1;return(n.addedNodes.length||n.removedNodes.length)&&(r=!0,this.callback.call(this._target,n)),r}_listenSlots(n){for(let e=0;e<n.length;e++){let t=n[e];isSlot(t)&&t.addEventListener("slotchange",this._boundSchedule)}}_unlistenSlots(n){for(let e=0;e<n.length;e++){let t=n[e];isSlot(t)&&t.removeEventListener("slotchange",this._boundSchedule)}}};function inflateFunctions(config){if(Array.isArray(config)){config.forEach(inflateFunctions);return}!(config instanceof Object)||config.constructor!==Object||Object.entries(config).forEach(([attr,targetProperty])=>{if(attr.startsWith("_fn_")&&(typeof targetProperty=="string"||targetProperty instanceof String)){try{config[attr.substr(4)]=eval(`(${targetProperty})`)}catch(_){config[attr.substr(4)]=eval(`(function(){${targetProperty}})`)}delete config[attr]}else targetProperty instanceof Object&&inflateFunctions(targetProperty)})}/**
 * @license
 * Copyright (c) 2000 - 2024 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */class ChartSeries extends PolymerElement{static get is(){return"vaadin-chart-series"}static get properties(){return{values:{type:Array,value:()=>[]},valueMin:{type:Number,reflectToAttribute:!0},valueMax:{type:Number,reflectToAttribute:!0},type:{type:String,reflectToAttribute:!0},title:{type:String,reflectToAttribute:!0},markers:{type:String,reflectToAttribute:!0},unit:{type:String,reflectToAttribute:!0},stack:{type:String,reflectToAttribute:!0},neckPosition:{type:String,reflectToAttribute:!0},neckWidth:{type:String,reflectToAttribute:!0},options:{type:Object},additionalOptions:{type:Object,reflectToAttribute:!0},_series:{type:Object}}}static get observers(){return["__additionalOptionsObserver(additionalOptions.*, _series)","__markersObserver(markers, _series)","__neckPositionObserver(neckPosition, _series)","__neckWidthObserver(neckWidth, _series)","__stackObserver(stack, _series)","__titleObserver(title, _series)","__typeObserver(type, _series)","__unitObserver(unit, valueMin, valueMax, _series)","__valueMinObserver(valueMin, _series)","__valueMaxObserver(valueMax, _series)","__valuesObserver(values.splices, _series)"]}get options(){const e=deepMerge({},this.additionalOptions);return this.type&&(e.type=this.type),this.title&&(e.name=this.title),this.values&&(e.data=this.values),this.markers&&(this.__isMarkersValid()||(this.markers="auto"),e.marker=this.__markersConfiguration),this.unit&&(e.yAxis=this.unit),this.stack&&(e.stack=this.stack),isFinite(this.valueMin)&&(e.yAxisValueMin=this.valueMin),isFinite(this.valueMax)&&(e.yAxisValueMax=this.valueMax),this.neckWidth&&(e.neckWidth=this.neckWidth),this.neckPosition&&(e.neckHeight=this.neckPosition),e}get __markersConfiguration(){const e={};switch(this.markers){case"shown":e.enabled=!0;break;case"hidden":e.enabled=!1;break;case"auto":default:e.enabled=null;break}return e}setSeries(e){this._series=e}__valuesObserver(e,t){t&&t.setData(this.values)}__additionalOptionsObserver(e,t){t&&e.base&&t.update(e.base)}__updateAxis(e,t,r){if(!isFinite(t)){this.__showWarn(`value-${r}`,"Numbers or null");return}e&&e.yAxis&&e.yAxis.update({[r]:t})}__valueMinObserver(e,t){e===void 0||t==null||this.__updateAxis(t,e,"min")}__valueMaxObserver(e,t){e===void 0||t==null||this.__updateAxis(t,e,"max")}__typeObserver(e,t){e&&t&&t.update({type:e})}__titleObserver(e,t){e===void 0||t==null||t.update({name:e})}__stackObserver(e,t){e===void 0||t==null||t.update({stack:e})}__neckPositionObserver(e,t){e===void 0||t==null||t.update({neckHeight:e})}__neckWidthObserver(e,t){e===void 0||t==null||t.update({neckWidth:e})}__unitObserver(e,t,r,o){if(o&&e!==this.__oldUnit){this.__oldUnit=e;const s=this.parentNode instanceof Chart&&this.parentNode;if(s&&s instanceof Chart){if(e&&!s.__getAxis(e)){const a={title:{text:e}};s.__addAxis({id:e,axisGenerated:!0,...a})}o.update({yAxis:e||0}),t!==void 0&&this.__updateAxis(o,t,"min"),r!==void 0&&this.__updateAxis(o,r,"max"),s.__removeAxisIfEmpty()}}}__isMarkersValid(){return["shown","hidden","auto"].indexOf(this.markers)===-1?(this.__showWarn("markers",'"shown", "hidden" or "auto"'),!1):!0}__markersObserver(e,t){if(!(e===void 0||t==null)){if(!this.__isMarkersValid()){this.markers="auto";return}t.update({marker:this.__markersConfiguration})}}__showWarn(e,t){console.warn(`<vaadin-chart-series> Acceptable values for "${e}" are ${t}`)}}defineCustomElement(ChartSeries);/**
 * @license
 * Copyright (c) 2000 - 2024 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */function deepMerge(n,e){const t=r=>r&&typeof r=="object"&&!Array.isArray(r);return t(e)&&t(n)&&Object.keys(e).forEach(r=>{t(e[r])?(n[r]||Object.assign(n,{[r]:{}}),deepMerge(n[r],e[r])):Object.assign(n,{[r]:e[r]})}),n}["exportChart","exportChartLocal","getSVG"].forEach(n=>{G$7.wrap(G$7.Chart.prototype,n,function(e,...t){G$7.fireEvent(this,"beforeExport");const r=e.apply(this,t);return G$7.fireEvent(this,"afterExport"),r})});Pointer.prototype.onDocumentMouseMove=function(n){const e=this.chart,t=this.chartPosition,r=this.normalize(n,t),o=e.tooltip;t&&(!o||!o.isStickyOnContact())&&!e.isInsidePlot(r.chartX-e.plotLeft,r.chartY-e.plotTop,{visiblePlotOnly:!0})&&!this.inClass(r.composedPath()[0],"highcharts-tracker")&&this.reset()};G$7.setOptions({lang:{noData:""}});class Chart extends ResizeMixin(ElementMixin(ThemableMixin(PolymerElement))){static get template(){return html`
      <style>
        :host {
          display: block;
          width: 100%;
          overflow: hidden;
        }

        :host([hidden]) {
          display: none !important;
        }
      </style>
      <div id="chart"></div>
      <slot id="slot"></slot>
    `}static get is(){return"vaadin-chart"}static get cvdlName(){return"vaadin-chart"}static get properties(){return{configuration:Object,categories:{type:Object,reflectToAttribute:!0},categoryMax:{type:Number,reflectToAttribute:!0},categoryMin:{type:Number,reflectToAttribute:!0},categoryPosition:{type:String,reflectToAttribute:!0},noLegend:{type:Boolean,reflectToAttribute:!0},stacking:{type:String,reflectToAttribute:!0},timeline:{type:Boolean,reflectToAttribute:!0},title:{type:String,reflectToAttribute:!0},tooltip:{type:Boolean,reflectToAttribute:!0},type:{type:String,reflectToAttribute:!0},subtitle:{type:String,reflectToAttribute:!0},chart3d:{type:Boolean,reflectToAttribute:!0},emptyText:{type:String,reflectToAttribute:!0},additionalOptions:{type:Object,reflectToAttribute:!0},polar:{type:Boolean,reflectToAttribute:!0}}}static get observers(){return["__chart3dObserver(chart3d, configuration)","__emptyTextObserver(emptyText, configuration)","__hideLegend(noLegend, configuration)","__polarObserver(polar, configuration)","__stackingObserver(stacking, configuration)","__tooltipObserver(tooltip, configuration)","__updateCategories(categories, configuration)","__updateCategoryMax(categoryMax, configuration)","__updateCategoryMin(categoryMin, configuration)","__updateCategoryPosition(categoryPosition, configuration)","__updateSubtitle(subtitle, configuration)","__updateTitle(title, configuration)","__updateType(type, configuration)","__updateAdditionalOptions(additionalOptions.*)"]}static __callHighchartsFunction(e,t,...r){const o=G$7[e];o&&typeof o=="function"&&(r.forEach(s=>inflateFunctions(s)),o.apply(this.configuration,r),t&&G$7.charts.forEach(s=>{s!==void 0&&s.redraw()}))}constructor(){super(),this._baseConfig={annotations:[],chart:{styledMode:!0},credits:{enabled:!1},exporting:{enabled:!1},title:{text:null},series:[],xAxis:{},yAxis:{axisGenerated:!0}},this._baseChart3d={enabled:!0,alpha:15,beta:15,depth:50}}get options(){const e={...this._baseConfig};return deepMerge(e,this.additionalOptions),this.type&&(e.chart.type=this.type),this.polar&&(e.chart.polar=!0),this.title&&(e.title={text:this.title}),e.tooltip||(e.tooltip={},this.tooltip||(e.tooltip.enabled=!1)),this.subtitle&&(e.subtitle={text:this.subtitle}),this.categories&&(Array.isArray(e.xAxis)?e.xAxis[0].categories=this.categories:e.xAxis.categories=this.categories),isFinite(this.categoryMin)&&(Array.isArray(e.xAxis)?e.xAxis[0].min=this.categoryMin:e.xAxis.min=this.categoryMin),isFinite(this.categoryMax)&&(Array.isArray(e.xAxis)?e.xAxis[0].max=this.categoryMax:e.xAxis.max=this.categoryMax),this.noLegend&&(e.legend={enabled:!1}),this.emptyText&&(e.lang||(e.lang={}),e.lang.noData=this.emptyText),this.categoryPosition&&(e.chart.inverted=this.__shouldInvert(),Array.isArray(e.xAxis)?e.xAxis.forEach(t=>{t.opposite=this.__shouldFlipOpposite()}):e.xAxis&&(e.xAxis.opposite=this.__shouldFlipOpposite())),this.stacking&&(e.plotOptions||(e.plotOptions={}),e.plotOptions.series||(e.plotOptions.series={}),e.plotOptions.series.stacking=this.stacking),this.chart3d&&(e.chart.options3d={...this._baseChart3d,...e.chart.options3d}),e}get __chartEventNames(){return{addSeries:"chart-add-series",afterExport:"chart-after-export",afterPrint:"chart-after-print",beforeExport:"chart-before-export",beforePrint:"chart-before-print",click:"chart-click",drilldown:"chart-drilldown",drillup:"chart-drillup",drillupall:"chart-drillupall",load:"chart-load",redraw:"chart-redraw",selection:"chart-selection"}}get __seriesEventNames(){return{afterAnimate:"series-after-animate",checkboxClick:"series-checkbox-click",click:"series-click",hide:"series-hide",legendItemClick:"series-legend-item-click",mouseOut:"series-mouse-out",mouseOver:"series-mouse-over",show:"series-show"}}get __pointEventNames(){return{click:"point-click",legendItemClick:"point-legend-item-click",mouseOut:"point-mouse-out",mouseOver:"point-mouse-over",remove:"point-remove",select:"point-select",unselect:"point-unselect",update:"point-update"}}get __xAxesEventNames(){return{afterSetExtremes:"xaxes-extremes-set"}}get __yAxesEventNames(){return{afterSetExtremes:"yaxes-extremes-set"}}connectedCallback(){super.connectedCallback(),this.__updateStyles(),beforeNextRender(this,()=>{if(this.configuration){this.__reflow();return}this.__resetChart(),this.__addChildObserver(),this.__checkTurboMode()})}ready(){super.ready(),this.addEventListener("chart-redraw",this.__onRedraw.bind(this))}_onResize(e){if(!this.configuration)return;const{height:t,width:r}=e,{chartHeight:o,chartWidth:s}=this.configuration;(t!==o||r!==s)&&this.__reflow()}__reflow(){this.configuration&&this.configuration.reflow()}__addChildObserver(){this._childObserver=new FlattenedNodesObserver(this.$.slot,e=>{this.__addSeries(e.addedNodes.filter(this.__filterSeriesNodes)),this.__removeSeries(e.removedNodes.filter(this.__filterSeriesNodes)),this.__cleanupAfterSeriesRemoved(e.removedNodes.filter(this.__filterSeriesNodes))})}__filterSeriesNodes(e){return e.nodeType===Node.ELEMENT_NODE&&e instanceof ChartSeries}__addSeries(e){if(this.__isSeriesEmpty(e))return;const t=Array.from(this.childNodes).filter(this.__filterSeriesNodes),r=this.configuration.yAxis.reduce((o,s,a)=>(o[s.options.id||a]=s,o),{});for(let o=0,s=e.length;o<s;o++){const a=e[o],{yAxis:l,yAxisValueMin:h,yAxisValueMax:d}=a.options,c=t.indexOf(a);!l&&!this.configuration.yAxis.some(f=>f.userOptions.id===void 0)?r[l]=this.__addAxis({axisGenerated:!0}):l&&!r[l]&&(r[l]=this.__addAxis({id:l,title:{text:l},axisGenerated:!0})),isFinite(h)&&this.__setYAxisProps(r,l,{min:h}),isFinite(d)&&this.__setYAxisProps(r,l,{max:d});const p=this.__updateOrAddSeriesInstance(a.options,c,!1);a.setSeries(p)}this.__removeAxisIfEmpty(),this.configuration.redraw()}__removeSeries(e){this.__isSeriesEmpty(e)||e.forEach(t=>{t instanceof ChartSeries&&t._series.remove()})}__setYAxisProps(e,t,r){t?e[t].update(r):this.configuration.yAxis[0].update(r)}__isSeriesEmpty(e){return e===null||e.length===0}__cleanupAfterSeriesRemoved(e){this.__isSeriesEmpty(e)||(this.__removeAxisIfEmpty(),this.__updateNoDataElement(this.configuration))}__initChart(e){this.__initEventsListeners(e),this.__updateStyledMode(e),this.timeline?this.configuration=G$7.stockChart(this.$.chart,e):this.configuration=G$7.chart(this.$.chart,e)}__updateStyledMode(e){const t=e.chart.styledMode;this.$.chart.toggleAttribute("styled-mode",!!t)}disconnectedCallback(){super.disconnectedCallback(),this.configuration&&(this._jsonConfigurationBuffer=this.configuration.userOptions),queueMicrotask(()=>{this.isConnected||(this.configuration&&(this.configuration.destroy(),this.configuration=void 0,Array.from(this.childNodes).filter(this.__filterSeriesNodes).forEach(t=>{t.setSeries(null)})),this._childObserver&&this._childObserver.disconnect())})}__resetChart(){const e={...this.options,...this._jsonConfigurationBuffer};this.__initChart(e),this._jsonConfigurationBuffer=null}__getAxis(e,t){if(e=Number.parseInt(e)||e,this.configuration)return(t?this.configuration.xAxis:this.configuration.yAxis).find(r=>r.options.id===e)}__addAxis(e,t){if(this.configuration)return this.__createEventListeners(t?this.__xAxesEventNames:this.__yAxesEventNames,e,"events","axis"),this.configuration.addAxis(e,t)}__removeAxisIfEmpty(e){this.configuration&&(e?this.configuration.xAxis:this.configuration.yAxis).forEach(t=>{t.userOptions.axisGenerated&&t.series.length===0&&t.remove()})}updateConfiguration(e,t){(t||!this._jsonConfigurationBuffer)&&(this._jsonConfigurationBuffer={});const r=deepMerge({},e);inflateFunctions(r),this._jsonConfigurationBuffer=this.__makeConfigurationBuffer(this._jsonConfigurationBuffer,r),beforeNextRender(this,()=>{if(!(!this.configuration||!this._jsonConfigurationBuffer)){if(t){this.__resetChart();return}this.configuration.update(this._jsonConfigurationBuffer,!1),this._jsonConfigurationBuffer.credits&&this.__updateOrAddCredits(this._jsonConfigurationBuffer.credits),this._jsonConfigurationBuffer.xAxis&&this.__updateOrAddAxes(this._jsonConfigurationBuffer.xAxis,!0,!1),this._jsonConfigurationBuffer.yAxis&&this.__updateOrAddAxes(this._jsonConfigurationBuffer.yAxis,!1,!1),this._jsonConfigurationBuffer.series&&this.__updateOrAddSeries(this._jsonConfigurationBuffer.series,!1),this._jsonConfigurationBuffer=null,this.configuration.redraw()}})}__makeConfigurationBuffer(e,t){const r=G$7.merge(t),o=G$7.merge(e);return this.__mergeConfigurationArray(o,r,"series"),this.__mergeConfigurationArray(o,r,"xAxis"),this.__mergeConfigurationArray(o,r,"yAxis"),G$7.merge(o,r)}__mergeConfigurationArray(e,t,r){if(!t||!t[r]||!Array.isArray(t[r]))return;if(!e[r]){e[r]=Array.from(t[r]);return}const o=Math.max(e[r].length,t[r].length);for(let s=0;s<o;s++)e[r][s]=G$7.merge(e[r][s],t[r][s]);delete t[r]}__initEventsListeners(e){this.__initChartEventsListeners(e),this.__initSeriesEventsListeners(e),this.__initPointsEventsListeners(e),this.__initAxisEventsListeners(e,!0),this.__initAxisEventsListeners(e,!1)}__initChartEventsListeners(e){this.__createEventListeners(this.__chartEventNames,e,"chart.events","chart")}__initSeriesEventsListeners(e){this.__createEventListeners(this.__seriesEventNames,e,"plotOptions.series.events","series")}__initPointsEventsListeners(e){this.__createEventListeners(this.__pointEventNames,e,"plotOptions.series.point.events","point")}__initAxisEventsListeners(e,t){let r,o;t?(r=this.__xAxesEventNames,o=e.xAxis):(r=this.__yAxesEventNames,o=e.yAxis),Array.isArray(o)?o.forEach(s=>this.__createEventListeners(r,s,"events","axis")):this.__createEventListeners(r,o,"events","axis")}__createEventListeners(e,t,r,o){const s=this.__ensureObjectPath(t,r);for(let a=Object.keys(e),l=0;l<a.length;l++){const h=a[l];s[h]||(s[h]=d=>{const c={bubbles:!1,composed:!0,detail:{originalEvent:d,[o]:d.target}};if(!(d.type==="afterSetExtremes"&&(d.min==null||d.max==null))){if(d.type==="selection"&&(d.xAxis&&d.xAxis[0]&&(c.detail.xAxisMin=d.xAxis[0].min,c.detail.xAxisMax=d.xAxis[0].max),d.yAxis&&d.yAxis[0]&&(c.detail.yAxisMin=d.yAxis[0].min,c.detail.yAxisMax=d.yAxis[0].max)),d.type==="click"&&(d.xAxis&&d.xAxis[0]&&(c.detail.xValue=d.xAxis[0].value),d.yAxis&&d.yAxis[0]&&(c.detail.yValue=d.yAxis[0].value)),["beforePrint","beforeExport"].indexOf(d.type)>=0&&!this.tempBodyStyle){let p="";[...this.shadowRoot.querySelectorAll("style")].forEach(f=>{p+=f.textContent}),p=p.replace(/:host\(.+?\)/gu,f=>{const u=f.substr(6,f.length-7);return this.matches(u)?"":f}),p=`${p}body {    -moz-transform: scale(0.9, 0.9);    zoom: 0.9;    zoom: 90%;}`,this.tempBodyStyle=document.createElement("style"),this.tempBodyStyle.textContent=p,document.body.appendChild(this.tempBodyStyle),this.options.chart.styledMode&&document.body.setAttribute("styled-mode","")}if(["afterPrint","afterExport"].indexOf(d.type)>=0&&this.tempBodyStyle&&(document.body.removeChild(this.tempBodyStyle),delete this.tempBodyStyle,this.options.chart.styledMode&&document.body.removeAttribute("styled-mode")),this.dispatchEvent(new CustomEvent(e[h],c)),d.type==="legendItemClick"&&this._visibilityTogglingDisabled)return!1}})}}__ensureObjectPath(e,t){if(typeof t=="string")return t=t.split("."),t.reduce((r,o)=>(r[o]||(r[o]={}),r[o]),e)}__hasConfigurationBuffer(e){return get(e,this._jsonConfigurationBuffer)!==void 0}__updateOrAddCredits(e){this.configuration.credits?this.configuration.credits.update(e):this.configuration.addCredits(e)}__updateOrAddAxes(e,t,r){Array.isArray(e)||(e=[e]);const o=t?this.configuration.xAxis:this.configuration.yAxis;for(let s=0;s<e.length;s++){const a=e[s];o[s]?o[s].update(a,r):this.configuration.addAxis(a,t,r)}}__updateOrAddSeries(e,t){if(!Array.isArray(e))throw new Error("The type of jsonConfiguration.series should be Object[]");for(let r=0;r<e.length;r++){const o=e[r];this.__updateOrAddSeriesInstance(o,r,t)}}__updateOrAddSeriesInstance(e,t,r){return this.configuration.series[t]?this.configuration.series[t].update(e,r):this.configuration.addSeries(e,r),this.configuration.series[t]}__updateCategories(e,t){e===void 0||!t||this.__hasConfigurationBuffer("xAxis.categories")||this.__updateOrAddAxes([{categories:e}],!0)}__updateCategoryMax(e,t){if(!(e===void 0||!t||this.__hasConfigurationBuffer("xAxis.max"))){if(!isFinite(e)){console.warn('<vaadin-chart> Acceptable value for "category-max" are Numbers or null');return}this.__updateOrAddAxes([{max:e}],!0)}}__updateCategoryMin(e,t){if(!(e===void 0||!t||this.__hasConfigurationBuffer("xAxis.min"))){if(!isFinite(e)){console.warn('<vaadin-chart> Acceptable value for "category-min" are Numbers or null');return}this.__updateOrAddAxes([{min:e}],!0)}}__shouldInvert(){if(this.type==="bar"&&["top","bottom"].indexOf(this.categoryPosition)>=0){console.warn(`<vaadin-chart> Acceptable "category-position" values for bar charts are
          "left" and "right". For "top" and "bottom" positions please consider using a column chart.`);return}return["left","right"].indexOf(this.categoryPosition)>=0}__shouldFlipOpposite(){const e=["top","right"],t=["right"];return(this.type==="bar"?t:e).indexOf(this.categoryPosition)>=0}__updateCategoryPosition(e,t){if(e===void 0||!t||this.__hasConfigurationBuffer("chart.inverted"))return;const r=["left","right","top","bottom"];if(r.indexOf(e)<0){console.warn(`<vaadin-chart> Acceptable "category-position" values are ${r}`);return}t.update({chart:{inverted:this.__shouldInvert()}}),t.xAxis.forEach(o=>o.update({opposite:this.__shouldFlipOpposite()}))}__hideLegend(e,t){e===void 0||!t||this.__hasConfigurationBuffer("legend")||(t.legend?t.legend.update({enabled:!e}):t.legend={enabled:!e})}__updateTitle(e,t){e===void 0||!t||this.__hasConfigurationBuffer("title")||t.title.update({text:e})}__tooltipObserver(e,t){e===void 0||!t||this.__hasConfigurationBuffer("tooltip")||t.tooltip.update({enabled:e})}__updateType(e,t){e===void 0||!t||this.__hasConfigurationBuffer("chart.type")||t.update({chart:{type:e||"line"}})}__updateSubtitle(e,t){e===void 0||!t||this.__hasConfigurationBuffer("subtitle")||(t.subtitle?t.subtitle.update({text:e}):t.setSubtitle({text:e}))}__updateAdditionalOptions(e){this.configuration&&e.base&&this.updateConfiguration(e.base)}__isStackingValid(){return["normal","percent",null].indexOf(this.stacking)===-1?(this.__showWarn("stacking",'"normal", "percent" or null'),!1):!0}__stackingObserver(e,t){if(!(e===void 0||!t||this.__hasConfigurationBuffer("plotOptions.series.stacking"))){if(!this.__isStackingValid()){this.stacking=null;return}t.update({plotOptions:{series:{stacking:e}}})}}__chart3dObserver(e,t){e===void 0||!t||this.__hasConfigurationBuffer("chart.options3d")||(e?t.update({chart:{options3d:{...this._baseChart3d,...this.additionalOptions&&this.additionalOptions.chart&&this.additionalOptions.chart.options3d,enabled:!0}}}):t.update({chart:{options3d:{enabled:!1}}}))}__polarObserver(e,t){e===void 0||!t||this.__hasConfigurationBuffer("chart.polar")||t.update({chart:{polar:e}})}__emptyTextObserver(e,t){e===void 0||!t||this.__hasConfigurationBuffer("lang.noData")||(t.update({lang:{noData:e}}),this.__updateNoDataElement(t))}__updateNoDataElement(e){e.series.every(r=>r.data.length===0)&&(e.hideNoData(),e.showNoData(this.emptyText))}__callChartFunction(e,...t){if(this.configuration){const r=this.configuration[e];r&&typeof r=="function"&&(t.forEach(o=>inflateFunctions(o)),r.apply(this.configuration,t))}}__callSeriesFunction(e,t,...r){if(this.configuration&&this.configuration.series[t]){const o=this.configuration.series[t],s=o[e];s&&typeof s=="function"&&(r.forEach(a=>inflateFunctions(a)),s.apply(o,r))}}__callAxisFunction(e,t,r,...o){if(this.configuration){let s;switch(t){case 0:s=this.configuration.xAxis;break;case 1:s=this.configuration.yAxis;break;case 2:s=this.configuration.zAxis;break;case 3:s=this.configuration.colorAxis;break}if(s&&s[r]){const a=s[r],l=a[e];l&&typeof l=="function"&&(o.forEach(h=>inflateFunctions(h)),l.apply(a,o))}}}__callPointFunction(e,t,r,...o){if(this.configuration&&this.configuration.series[t]&&this.configuration.series[t].data[r]){const s=this.configuration.series[t].data[r],a=s[e];a&&typeof a=="function"&&a.apply(s,o)}}__updateStyles(){if(getComputedStyle(this).flex!=="0 1 auto"){this.$.chart.setAttribute("style","flex: 1; ");let t="";this.hasAttribute("style")&&(t=this.getAttribute("style"),t.endsWith(";")||(t+=";")),t+="display: flex;",this.setAttribute("style",t)}else this.$.chart.setAttribute("style","height:100%; width:100%;")}__showWarn(e,t){console.warn(`<vaadin-chart> Acceptable values for "${e}" are ${t}`)}__onRedraw(){this.__checkTurboMode()}__checkTurboMode(){const e=!!window.Vaadin.developmentMode;if(!this.configuration||!e||this.__turboModeWarningAlreadyLogged)return;this.configuration.series.some(r=>{const o=r.options&&r.options.turboThreshold||0,s=r.data.length;return o>0&&s>o})&&(this.__turboModeWarningAlreadyLogged=!0,console.warn("<vaadin-chart> Turbo mode has been enabled for one or more series, because the number of data items exceeds the configured threshold. Turbo mode improves the performance of charts with lots of data, but is not compatible with every type of series. Please consult the documentation on compatibility, or how to disable turbo mode."))}}defineCustomElement(Chart)});export default pt();
