import{i,a as addLumoGlobalStyles,r as registerStyles$1,f as f$2,T as ThemableMixin,b as i$1,x,d as defineCustomElement,t as themeRegistry,c as r$1,e as ThemePropertyMixin,E,B,g as addGlobalThemeStyles,h as i$2,j as t$1,k as e$2,l as T,m as b,n as color$h,o as typography,_ as __vitePreload,p as reactExports,q as clientExports,s as jsxRuntimeExports,O as Outlet}from"./indexhtml-BJHf-YlN.js";/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const userColors=i`
  :host {
    --vaadin-user-color-0: #df0b92;
    --vaadin-user-color-1: #650acc;
    --vaadin-user-color-2: #097faa;
    --vaadin-user-color-3: #ad6200;
    --vaadin-user-color-4: #bf16f3;
    --vaadin-user-color-5: #084391;
    --vaadin-user-color-6: #078836;
  }

  [theme~='dark'] {
    --vaadin-user-color-0: #ff66c7;
    --vaadin-user-color-1: #9d8aff;
    --vaadin-user-color-2: #8aff66;
    --vaadin-user-color-3: #ffbd66;
    --vaadin-user-color-4: #dc6bff;
    --vaadin-user-color-5: #66fffa;
    --vaadin-user-color-6: #e6ff66;
  }
`;addLumoGlobalStyles("user-color-props",userColors);/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-field-outline",i`
    :host {
      transition: opacity 0.3s;
      -webkit-mask-image: none !important;
      mask-image: none !important;
    }

    :host::before {
      content: '';
      position: absolute;
      inset: 0;
      box-shadow: 0 0 0 2px var(--_active-user-color);
      border-radius: var(--lumo-border-radius-s);
      transition: box-shadow 0.3s;
    }

    :host([context$='checkbox'])::before {
      box-shadow:
        0 0 0 2px var(--lumo-base-color),
        0 0 0 4px var(--_active-user-color);
    }

    :host([context$='radio-button'])::before {
      border-radius: 50%;
      box-shadow:
        0 0 0 3px var(--lumo-base-color),
        0 0 0 5px var(--_active-user-color);
    }

    :host([context$='item'])::before {
      box-shadow: inset 0 0 0 2px var(--_active-user-color);
    }
  `,{moduleId:"lumo-field-outline"});/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const overlay=i`
  :host {
    top: var(--lumo-space-m);
    right: var(--lumo-space-m);
    bottom: var(--lumo-space-m);
    left: var(--lumo-space-m);
    /* Workaround for Edge issue (only on Surface), where an overflowing vaadin-list-box inside vaadin-select-overlay makes the overlay transparent */
    /* stylelint-disable-next-line */
    outline: 0px solid transparent;
  }

  [part='overlay'] {
    background-color: var(--lumo-base-color);
    background-image: linear-gradient(var(--lumo-tint-5pct), var(--lumo-tint-5pct));
    border-radius: var(--lumo-border-radius-m);
    box-shadow:
      0 0 0 1px var(--lumo-shade-5pct),
      var(--lumo-box-shadow-m);
    color: var(--lumo-body-text-color);
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    font-weight: 400;
    line-height: var(--lumo-line-height-m);
    letter-spacing: 0;
    text-transform: none;
    -webkit-text-size-adjust: 100%;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
  }

  [part='content'] {
    padding: var(--lumo-space-xs);
  }

  [part='backdrop'] {
    background-color: var(--lumo-shade-20pct);
    animation: 0.2s lumo-overlay-backdrop-enter both;
    will-change: opacity;
  }

  @keyframes lumo-overlay-backdrop-enter {
    0% {
      opacity: 0;
    }
  }

  :host([closing]) [part='backdrop'] {
    animation: 0.2s lumo-overlay-backdrop-exit both;
  }

  @keyframes lumo-overlay-backdrop-exit {
    100% {
      opacity: 0;
    }
  }

  @keyframes lumo-overlay-dummy-animation {
    0% {
      opacity: 1;
    }

    100% {
      opacity: 1;
    }
  }
`;registerStyles$1("",overlay,{moduleId:"lumo-overlay"});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-user-tags-overlay",[overlay,i`
      [part='overlay'] {
        box-shadow: none;
        background: transparent;
        will-change: opacity, transform;
      }

      [part='content'] {
        padding: 0;
      }

      :host([opening]) [part='overlay'] {
        animation: 0.1s lumo-user-tags-enter ease-out both;
      }

      @keyframes lumo-user-tags-enter {
        0% {
          opacity: 0;
        }
      }

      :host([closing]) [part='overlay'] {
        animation: 0.1s lumo-user-tags-exit both;
      }

      @keyframes lumo-user-tags-exit {
        100% {
          opacity: 0;
        }
      }
    `],{moduleId:"lumo-user-tags-overlay"});registerStyles$1("vaadin-user-tag",i`
    :host {
      font-family: var(--lumo-font-family);
      font-size: var(--lumo-font-size-xxs);
      border-radius: var(--lumo-border-radius-s);
      box-shadow: var(--lumo-box-shadow-xs);
      --vaadin-user-tag-offset: var(--lumo-space-xs);
    }

    [part='name'] {
      color: var(--lumo-primary-contrast-color);
      padding: 0.3em calc(0.3em + var(--lumo-border-radius-s) / 4);
      line-height: 1;
      font-weight: 500;
      min-width: calc(var(--lumo-line-height-xs) * 1em + 0.45em);
    }
  `,{moduleId:"lumo-user-tag"});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const directionSubscribers=[];function alignDirs(z,y,a=z.getAttribute("dir")){y?z.setAttribute("dir",y):a!=null&&z.removeAttribute("dir")}function getDocumentDir(){return document.documentElement.getAttribute("dir")}function directionUpdater(){const z=getDocumentDir();directionSubscribers.forEach(y=>{alignDirs(y,z)})}const directionObserver=new MutationObserver(directionUpdater);directionObserver.observe(document.documentElement,{attributes:!0,attributeFilter:["dir"]});const DirMixin=z=>class extends z{static get properties(){return{dir:{type:String,value:"",reflectToAttribute:!0,converter:{fromAttribute:a=>a||"",toAttribute:a=>a===""?null:a}}}}get __isRTL(){return this.getAttribute("dir")==="rtl"}connectedCallback(){super.connectedCallback(),(!this.hasAttribute("dir")||this.__restoreSubscription)&&(this.__subscribe(),alignDirs(this,getDocumentDir(),null))}attributeChangedCallback(a,k,j){if(super.attributeChangedCallback(a,k,j),a!=="dir")return;const et=getDocumentDir(),it=j===et&&directionSubscribers.indexOf(this)===-1,nt=!j&&k&&directionSubscribers.indexOf(this)===-1;it||nt?(this.__subscribe(),alignDirs(this,et,j)):j!==et&&k===et&&this.__unsubscribe()}disconnectedCallback(){super.disconnectedCallback(),this.__restoreSubscription=directionSubscribers.includes(this),this.__unsubscribe()}_valueToNodeAttribute(a,k,j){j==="dir"&&k===""&&!a.hasAttribute("dir")||super._valueToNodeAttribute(a,k,j)}_attributeToProperty(a,k,j){a==="dir"&&!k?this.dir="":super._attributeToProperty(a,k,j)}__subscribe(){directionSubscribers.includes(this)||directionSubscribers.push(this)}__unsubscribe(){directionSubscribers.includes(this)&&directionSubscribers.splice(directionSubscribers.indexOf(this),1)}},appliedClassMixins=new WeakMap;function wasMixinPreviouslyApplied(z,y){let a=y;for(;a;){if(appliedClassMixins.get(a)===z)return!0;a=Object.getPrototypeOf(a)}return!1}function dedupeMixin(z){return y=>{if(wasMixinPreviouslyApplied(z,y))return y;const a=z(y);return appliedClassMixins.set(a,z),a}}/**
 * @license
 * Copyright (c) 2023 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function get$7(z,y){return z.split(".").reduce((a,k)=>a?a[k]:void 0,y)}function set$2(z,y,a){const k=z.split("."),j=k.pop(),et=k.reduce((it,nt)=>it[nt],a);et[j]=y}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const caseMap$1={},CAMEL_TO_DASH$1=/([A-Z])/gu;function camelToDash(z){return caseMap$1[z]||(caseMap$1[z]=z.replace(CAMEL_TO_DASH$1,"-$1").toLowerCase()),caseMap$1[z]}function upper$1(z){return z[0].toUpperCase()+z.substring(1)}function parseObserver(z){const[y,a]=z.split("("),k=a.replace(")","").split(",").map(j=>j.trim());return{method:y,observerProps:k}}function getOrCreateMap(z,y){return Object.prototype.hasOwnProperty.call(z,y)||(z[y]=new Map(z[y])),z[y]}const PolylitMixinImplementation=z=>{class y extends z{static enabledWarnings=[];static createProperty(k,j){[String,Boolean,Number,Array].includes(j)&&(j={type:j}),j&&j.reflectToAttribute&&(j.reflect=!0),super.createProperty(k,j)}static getOrCreateMap(k){return getOrCreateMap(this,k)}static finalize(){if(window.litIssuedWarnings&&(window.litIssuedWarnings.add("no-override-create-property"),window.litIssuedWarnings.add("no-override-get-property-descriptor")),super.finalize(),Array.isArray(this.observers)){const k=this.getOrCreateMap("__complexObservers");this.observers.forEach(j=>{const{method:et,observerProps:it}=parseObserver(j);k.set(et,it)})}}static addCheckedInitializer(k){super.addInitializer(j=>{j instanceof this&&k(j)})}static getPropertyDescriptor(k,j,et){const it=super.getPropertyDescriptor(k,j,et);let nt=it;if(this.getOrCreateMap("__propKeys").set(k,j),et.sync&&(nt={get:it.get,set(ot){const at=this[k];f$2(ot,at)&&(this[j]=ot,this.requestUpdate(k,at,et),this.hasUpdated&&this.performUpdate())},configurable:!0,enumerable:!0}),et.readOnly){const ot=nt.set;this.addCheckedInitializer(at=>{at[`_set${upper$1(k)}`]=function(lt){ot.call(at,lt)}}),nt={get:nt.get,set(){},configurable:!0,enumerable:!0}}if("value"in et&&this.addCheckedInitializer(ot=>{const at=typeof et.value=="function"?et.value.call(ot):et.value;et.readOnly?ot[`_set${upper$1(k)}`](at):ot[k]=at}),et.observer){const ot=et.observer;this.getOrCreateMap("__observers").set(k,ot),this.addCheckedInitializer(at=>{at[ot]||console.warn(`observer method ${ot} not defined`)})}if(et.notify){if(!this.__notifyProps)this.__notifyProps=new Set;else if(!this.hasOwnProperty("__notifyProps")){const ot=this.__notifyProps;this.__notifyProps=new Set(ot)}this.__notifyProps.add(k)}if(et.computed){const ot=`__assignComputed${k}`,at=parseObserver(et.computed);this.prototype[ot]=function(...lt){this[k]=this[at.method](...lt)},this.getOrCreateMap("__computedObservers").set(ot,at.observerProps)}return et.attribute||(et.attribute=camelToDash(k)),nt}static get polylitConfig(){return{asyncFirstRender:!1}}constructor(){super(),this.__hasPolylitMixin=!0}connectedCallback(){super.connectedCallback();const k=this.getRootNode().host;k&&k.__hasPolylitMixin&&this.id&&(k.$||={},k.$[this.id]=this);const{polylitConfig:j}=this.constructor;!this.hasUpdated&&!j.asyncFirstRender&&this.performUpdate()}firstUpdated(){super.firstUpdated(),this.$||(this.$={}),[...Object.values(this.$),this.renderRoot].forEach(k=>{k.querySelectorAll("[id]").forEach(j=>{this.$[j.id]=j})})}ready(){}willUpdate(k){this.constructor.__computedObservers&&this.__runComplexObservers(k,this.constructor.__computedObservers)}updated(k){const j=this.__isReadyInvoked;this.__isReadyInvoked=!0,this.constructor.__observers&&this.__runObservers(k,this.constructor.__observers),this.constructor.__complexObservers&&this.__runComplexObservers(k,this.constructor.__complexObservers),this.__dynamicPropertyObservers&&this.__runDynamicObservers(k,this.__dynamicPropertyObservers),this.__dynamicMethodObservers&&this.__runComplexObservers(k,this.__dynamicMethodObservers),this.constructor.__notifyProps&&this.__runNotifyProps(k,this.constructor.__notifyProps),j||this.ready()}setProperties(k){Object.entries(k).forEach(([j,et])=>{const it=this.constructor.__propKeys.get(j),nt=this[it];this[it]=et,this.requestUpdate(j,nt)}),this.hasUpdated&&this.performUpdate()}_createMethodObserver(k){const j=getOrCreateMap(this,"__dynamicMethodObservers"),{method:et,observerProps:it}=parseObserver(k);j.set(et,it)}_createPropertyObserver(k,j){getOrCreateMap(this,"__dynamicPropertyObservers").set(j,k)}__runComplexObservers(k,j){j.forEach((et,it)=>{et.some(nt=>k.has(nt))&&(this[it]?this[it](...et.map(nt=>this[nt])):console.warn(`observer method ${it} not defined`))})}__runDynamicObservers(k,j){j.forEach((et,it)=>{k.has(et)&&this[it]&&this[it](this[et],k.get(et))})}__runObservers(k,j){k.forEach((et,it)=>{const nt=j.get(it);nt!==void 0&&this[nt]&&this[nt](this[it],et)})}__runNotifyProps(k,j){k.forEach((et,it)=>{j.has(it)&&this.dispatchEvent(new CustomEvent(`${camelToDash(it)}-changed`,{detail:{value:this[it]}}))})}_get(k,j){return get$7(k,j)}_set(k,j,et){set$2(k,j,et)}}return y},PolylitMixin=dedupeMixin(PolylitMixinImplementation);/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const fieldOutlineStyles=i`
  :host {
    display: block;
    box-sizing: border-box;
    position: absolute;
    inset: 0;
    width: 100%;
    height: 100%;
    pointer-events: none;
    user-select: none;
    opacity: 0;
    --_active-user-color: transparent;
  }

  :host([has-active-user]) {
    opacity: 1;
  }
`,userTagStyles=i`
  :host {
    display: block;
    box-sizing: border-box;
    margin: 0 0 var(--vaadin-user-tag-offset);
    opacity: 0;
    height: 1.3rem;
    transition: opacity 0.2s ease-in-out;
    background-color: var(--vaadin-user-tag-color);
    color: #fff;
    cursor: default;
    -webkit-user-select: none;
    user-select: none;
    --vaadin-user-tag-offset: 4px;
  }

  :host(.show) {
    opacity: 1;
  }

  :host(:last-of-type) {
    margin-bottom: 0;
  }

  [part='name'] {
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
    box-sizing: border-box;
    padding: 2px 4px;
    height: 1.3rem;
    font-size: 13px;
  }
`,userTagsOverlayStyles=i`
  [part='overlay'] {
    position: relative;
    left: -4px;
    padding: 4px;
    outline: none;
    overflow: visible;
  }

  ::slotted([part='tags']) {
    display: flex;
    flex-direction: column;
    align-items: flex-start;
  }

  :host([dir='rtl']) [part='overlay'] {
    left: auto;
    right: -4px;
  }

  :host([opening]),
  :host([closing]) {
    animation: 0.14s user-tags-overlay-dummy-animation;
  }

  @keyframes user-tags-overlay-dummy-animation {
    0% {
      opacity: 1;
    }

    100% {
      opacity: 1;
    }
  }
`;/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class UserTag extends ThemableMixin(DirMixin(PolylitMixin(i$1))){static get is(){return"vaadin-user-tag"}static get styles(){return userTagStyles}render(){return x`<div part="name">${this.name}</div>`}static get properties(){return{name:{type:String},uid:{type:String},colorIndex:{type:Number,observer:"_colorIndexChanged"}}}ready(){super.ready(),this.addEventListener("mousedown",this._onClick.bind(this),!0)}_colorIndexChanged(y){y!=null&&this.style.setProperty("--vaadin-user-tag-color",`var(--vaadin-user-color-${y})`)}_onClick(y){y.preventDefault(),this.dispatchEvent(new CustomEvent("user-tag-click",{bubbles:!0,composed:!0,detail:{name:this.name}}))}}defineCustomElement(UserTag);/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const testUserAgent=z=>z.test(navigator.userAgent),testPlatform=z=>z.test(navigator.platform),testVendor=z=>z.test(navigator.vendor),isAndroid=testUserAgent(/Android/u),isChrome=testUserAgent(/Chrome/u)&&testVendor(/Google Inc/u),isFirefox$4=testUserAgent(/Firefox/u),isIPad=testPlatform(/^iPad/u)||testPlatform(/^Mac/u)&&navigator.maxTouchPoints>1,isIPhone=testPlatform(/^iPhone/u),isIOS=isIPhone||isIPad,isSafari=testUserAgent(/^((?!chrome|android).)*safari/iu),isTouch=(()=>{try{return document.createEvent("TouchEvent"),!0}catch{return!1}})(),supportsAdoptingStyleSheets$1=window.ShadowRoot&&"adoptedStyleSheets"in Document.prototype&&"replace"in CSSStyleSheet.prototype;/**
 * @license
 * Copyright (c) 2017 Anton Korzunov
 * SPDX-License-Identifier: MIT
 */let counterMap=new WeakMap,uncontrolledNodes=new WeakMap,markerMap={},lockCount=0;const isElement=z=>z&&z.nodeType===Node.ELEMENT_NODE,logError=(...z)=>{console.error(`Error: ${z.join(" ")}. Skip setting aria-hidden.`)},correctTargets=(z,y)=>isElement(z)?y.map(a=>{if(!isElement(a))return logError(a,"is not a valid element"),null;let k=a;for(;k&&k!==z;){if(z.contains(k))return a;k=k.getRootNode().host}return logError(a,"is not contained inside",z),null}).filter(a=>!!a):(logError(z,"is not a valid element"),[]),applyAttributeToOthers=(z,y,a,k)=>{const j=correctTargets(y,Array.isArray(z)?z:[z]);markerMap[a]||(markerMap[a]=new WeakMap);const et=markerMap[a],it=[],nt=new Set,ot=new Set(j),at=ct=>{if(!ct||nt.has(ct))return;nt.add(ct);const ht=ct.assignedSlot;ht&&at(ht),at(ct.parentNode||ct.host)};j.forEach(at);const lt=ct=>{if(!ct||ot.has(ct))return;const ht=ct.shadowRoot;(ht?[...ct.children,...ht.children]:[...ct.children]).forEach(ft=>{if(!["template","script","style"].includes(ft.localName))if(nt.has(ft))lt(ft);else{const vt=ft.getAttribute(k),gt=vt!==null&&vt!=="false",mt=(counterMap.get(ft)||0)+1,bt=(et.get(ft)||0)+1;counterMap.set(ft,mt),et.set(ft,bt),it.push(ft),mt===1&&gt&&uncontrolledNodes.set(ft,!0),bt===1&&ft.setAttribute(a,"true"),gt||ft.setAttribute(k,"true")}})};return lt(y),nt.clear(),lockCount+=1,()=>{it.forEach(ct=>{const ht=counterMap.get(ct)-1,ut=et.get(ct)-1;counterMap.set(ct,ht),et.set(ct,ut),ht||(uncontrolledNodes.has(ct)?uncontrolledNodes.delete(ct):ct.removeAttribute(k)),ut||ct.removeAttribute(a)}),lockCount-=1,lockCount||(counterMap=new WeakMap,counterMap=new WeakMap,uncontrolledNodes=new WeakMap,markerMap={})}},hideOthers=(z,y=document.body,a="data-aria-hidden")=>{const k=Array.from(Array.isArray(z)?z:[z]);return y&&k.push(...Array.from(y.querySelectorAll("[aria-live]"))),applyAttributeToOthers(k,y,a,"aria-hidden")};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AriaModalController{constructor(y,a){this.host=y,this.callback=typeof a=="function"?a:()=>y}showModal(){const y=this.callback();this.__showOthers=hideOthers(y)}close(){this.__showOthers&&(this.__showOthers(),this.__showOthers=null)}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */let keyboardActive=!1;window.addEventListener("keydown",()=>{keyboardActive=!0},{capture:!0});window.addEventListener("mousedown",()=>{keyboardActive=!1},{capture:!0});function getDeepActiveElement(){let z=document.activeElement||document.body;for(;z.shadowRoot&&z.shadowRoot.activeElement;)z=z.shadowRoot.activeElement;return z}function isKeyboardActive(){return keyboardActive}function isElementHiddenDirectly(z){const y=z.style;if(y.visibility==="hidden"||y.display==="none")return!0;const a=window.getComputedStyle(z);return a.visibility==="hidden"||a.display==="none"}function hasLowerTabOrder(z,y){const a=Math.max(z.tabIndex,0),k=Math.max(y.tabIndex,0);return a===0||k===0?k>a:a>k}function mergeSortByTabIndex(z,y){const a=[];for(;z.length>0&&y.length>0;)hasLowerTabOrder(z[0],y[0])?a.push(y.shift()):a.push(z.shift());return a.concat(z,y)}function sortElementsByTabIndex(z){const y=z.length;if(y<2)return z;const a=Math.ceil(y/2),k=sortElementsByTabIndex(z.slice(0,a)),j=sortElementsByTabIndex(z.slice(a));return mergeSortByTabIndex(k,j)}function isElementHidden(z){return z.checkVisibility?!z.checkVisibility({visibilityProperty:!0}):z.offsetParent===null&&z.clientWidth===0&&z.clientHeight===0?!0:isElementHiddenDirectly(z)}function isElementFocusable(z){return z.matches('[tabindex="-1"]')?!1:z.matches("input, select, textarea, button, object")?z.matches(":not([disabled])"):z.matches("a[href], area[href], iframe, [tabindex], [contentEditable]")}function isElementFocused(z){return z.getRootNode().activeElement===z}function normalizeTabIndex(z){if(!isElementFocusable(z))return-1;const y=z.getAttribute("tabindex")||0;return Number(y)}function collectFocusableNodes(z,y){if(z.nodeType!==Node.ELEMENT_NODE||isElementHiddenDirectly(z))return!1;const a=z,k=normalizeTabIndex(a);let j=k>0;k>=0&&y.push(a);let et=[];return a.localName==="slot"?et=a.assignedNodes({flatten:!0}):et=(a.shadowRoot||a).children,[...et].forEach(it=>{j=collectFocusableNodes(it,y)||j}),j}function getFocusableElements(z){const y=[];return collectFocusableNodes(z,y)?sortElementsByTabIndex(y):y}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class FocusRestorationController{saveFocus(y){this.focusNode=y||getDeepActiveElement()}restoreFocus(y){const a=this.focusNode;if(!a)return;const k={preventScroll:y?y.preventScroll:!1,focusVisible:y?y.focusVisible:!1};getDeepActiveElement()===document.body?setTimeout(()=>a.focus(k)):a.focus(k),this.focusNode=null}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const instances=[];class FocusTrapController{constructor(y){this.host=y,this.__trapNode=null,this.__onKeyDown=this.__onKeyDown.bind(this)}get __focusableElements(){return getFocusableElements(this.__trapNode)}get __focusedElementIndex(){const y=this.__focusableElements;return y.indexOf(y.filter(isElementFocused).pop())}hostConnected(){document.addEventListener("keydown",this.__onKeyDown)}hostDisconnected(){document.removeEventListener("keydown",this.__onKeyDown)}trapFocus(y){if(this.__trapNode=y,this.__focusableElements.length===0)throw this.__trapNode=null,new Error("The trap node should have at least one focusable descendant or be focusable itself.");instances.push(this),this.__focusedElementIndex===-1&&this.__focusableElements[0].focus({focusVisible:isKeyboardActive()})}releaseFocus(){this.__trapNode=null,instances.pop()}__onKeyDown(y){if(this.__trapNode&&this===Array.from(instances).pop()&&y.key==="Tab"){y.preventDefault();const a=y.shiftKey;this.__focusNextElement(a)}}__focusNextElement(y=!1){const a=this.__focusableElements,k=y?-1:1,j=this.__focusedElementIndex,et=(a.length+j+k)%a.length,it=a[et];it.focus({focusVisible:!0}),it.localName==="input"&&it.select()}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ControllerMixin=dedupeMixin(z=>typeof z.prototype.addController=="function"?z:class extends z{constructor(){super(),this.__controllers=new Set}connectedCallback(){super.connectedCallback(),this.__controllers.forEach(a=>{a.hostConnected&&a.hostConnected()})}disconnectedCallback(){super.disconnectedCallback(),this.__controllers.forEach(a=>{a.hostDisconnected&&a.hostDisconnected()})}addController(a){this.__controllers.add(a),this.$!==void 0&&this.isConnected&&a.hostConnected&&a.hostConnected()}removeController(a){this.__controllers.delete(a)}});/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const OverlayFocusMixin=z=>class extends ControllerMixin(z){static get properties(){return{focusTrap:{type:Boolean,value:!1},restoreFocusOnClose:{type:Boolean,value:!1},restoreFocusNode:{type:HTMLElement}}}constructor(){super(),this.__ariaModalController=new AriaModalController(this),this.__focusTrapController=new FocusTrapController(this),this.__focusRestorationController=new FocusRestorationController}ready(){super.ready(),this.addController(this.__ariaModalController),this.addController(this.__focusTrapController),this.addController(this.__focusRestorationController)}_resetFocus(){if(this.focusTrap&&(this.__ariaModalController.close(),this.__focusTrapController.releaseFocus()),this.restoreFocusOnClose&&this._shouldRestoreFocus()){const a=isKeyboardActive(),k=!a;this.__focusRestorationController.restoreFocus({preventScroll:k,focusVisible:a})}}_saveFocus(){this.restoreFocusOnClose&&this.__focusRestorationController.saveFocus(this.restoreFocusNode)}_trapFocus(){this.focusTrap&&(this.__ariaModalController.showModal(),this.__focusTrapController.trapFocus(this.$.overlay))}_shouldRestoreFocus(){const a=getDeepActiveElement();return a===document.body||this._deepContains(a)}_deepContains(a){if(this.contains(a))return!0;let k=a;const j=a.ownerDocument;for(;k&&k!==j&&k!==this;)k=k.parentNode||k.host;return k===this}};/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const getAttachedInstances=()=>Array.from(document.body.children).filter(z=>z instanceof HTMLElement&&z._hasOverlayStackMixin&&!z.hasAttribute("closing")).sort((z,y)=>z.__zIndex-y.__zIndex||0),getOverlayInstances=()=>getAttachedInstances().filter(z=>z.$.overlay),isLastOverlay$1=(z,y=a=>!0)=>{const a=getOverlayInstances().filter(y);return z===a.pop()},overlayMap=new WeakMap,setNestedOverlay=(z,y)=>{y!=null?overlayMap.set(z,y):overlayMap.delete(z)},OverlayStackMixin=z=>class extends z{constructor(){super(),this._hasOverlayStackMixin=!0}get _last(){return isLastOverlay$1(this)}bringToFront(){let a="";const k=getAttachedInstances().filter(j=>j!==this).pop();k&&(a=k.__zIndex+1),this.style.zIndex=a,this.__zIndex=a||parseFloat(getComputedStyle(this).zIndex),overlayMap.has(this)&&overlayMap.get(this).bringToFront()}_enterModalState(){document.body.style.pointerEvents!=="none"&&(this._previousDocumentPointerEvents=document.body.style.pointerEvents,document.body.style.pointerEvents="none"),getOverlayInstances().forEach(a=>{a!==this&&(a.$.overlay.style.pointerEvents="none")})}_exitModalState(){this._previousDocumentPointerEvents!==void 0&&(document.body.style.pointerEvents=this._previousDocumentPointerEvents,delete this._previousDocumentPointerEvents);const a=getOverlayInstances();let k;for(;(k=a.pop())&&!(k!==this&&(k.$.overlay.style.removeProperty("pointer-events"),!k.modeless)););}};/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const OverlayMixin=z=>class extends OverlayFocusMixin(OverlayStackMixin(z)){static get properties(){return{opened:{type:Boolean,notify:!0,observer:"_openedChanged",reflectToAttribute:!0,sync:!0},owner:{type:Object,sync:!0},model:{type:Object,sync:!0},renderer:{type:Object,sync:!0},modeless:{type:Boolean,value:!1,reflectToAttribute:!0,observer:"_modelessChanged",sync:!0},hidden:{type:Boolean,reflectToAttribute:!0,observer:"_hiddenChanged",sync:!0},withBackdrop:{type:Boolean,value:!1,reflectToAttribute:!0,sync:!0}}}static get observers(){return["_rendererOrDataChanged(renderer, owner, model, opened)"]}constructor(){super(),this._boundMouseDownListener=this._mouseDownListener.bind(this),this._boundMouseUpListener=this._mouseUpListener.bind(this),this._boundOutsideClickListener=this._outsideClickListener.bind(this),this._boundKeydownListener=this._keydownListener.bind(this),isIOS&&(this._boundIosResizeListener=()=>this._detectIosNavbar())}ready(){super.ready(),this.addEventListener("click",()=>{}),this.$.backdrop.addEventListener("click",()=>{}),this.addEventListener("mouseup",()=>{document.activeElement===document.body&&this.$.overlay.getAttribute("tabindex")==="0"&&this.$.overlay.focus()})}connectedCallback(){super.connectedCallback(),this._boundIosResizeListener&&(this._detectIosNavbar(),window.addEventListener("resize",this._boundIosResizeListener))}disconnectedCallback(){super.disconnectedCallback(),this._boundIosResizeListener&&window.removeEventListener("resize",this._boundIosResizeListener)}requestContentUpdate(){this.renderer&&this.renderer.call(this.owner,this,this.owner,this.model)}close(a){const k=new CustomEvent("vaadin-overlay-close",{bubbles:!0,cancelable:!0,detail:{sourceEvent:a}});this.dispatchEvent(k),k.defaultPrevented||(this.opened=!1)}_detectIosNavbar(){if(!this.opened)return;const a=window.innerHeight,j=window.innerWidth>a,et=document.documentElement.clientHeight;j&&et>a?this.style.setProperty("--vaadin-overlay-viewport-bottom",`${et-a}px`):this.style.setProperty("--vaadin-overlay-viewport-bottom","0")}_addGlobalListeners(){document.addEventListener("mousedown",this._boundMouseDownListener),document.addEventListener("mouseup",this._boundMouseUpListener),document.documentElement.addEventListener("click",this._boundOutsideClickListener,!0)}_removeGlobalListeners(){document.removeEventListener("mousedown",this._boundMouseDownListener),document.removeEventListener("mouseup",this._boundMouseUpListener),document.documentElement.removeEventListener("click",this._boundOutsideClickListener,!0)}_rendererOrDataChanged(a,k,j,et){const it=this._oldOwner!==k||this._oldModel!==j;this._oldModel=j,this._oldOwner=k;const nt=this._oldRenderer!==a,ot=this._oldRenderer!==void 0;this._oldRenderer=a;const at=this._oldOpened!==et;this._oldOpened=et,nt&&ot&&(this.innerHTML="",delete this._$litPart$),et&&a&&(nt||at||it)&&this.requestContentUpdate()}_modelessChanged(a){a?(this._removeGlobalListeners(),this._exitModalState()):this.opened&&(this._addGlobalListeners(),this._enterModalState())}_openedChanged(a,k){a?(this._saveFocus(),this._animatedOpening(),this.__scheduledOpen=requestAnimationFrame(()=>{setTimeout(()=>{this._trapFocus(),this.dispatchEvent(new CustomEvent("vaadin-overlay-open",{bubbles:!0}))})}),document.addEventListener("keydown",this._boundKeydownListener),this.modeless||this._addGlobalListeners()):k&&(this.__scheduledOpen&&(cancelAnimationFrame(this.__scheduledOpen),this.__scheduledOpen=null),this._resetFocus(),this._animatedClosing(),document.removeEventListener("keydown",this._boundKeydownListener),this.modeless||this._removeGlobalListeners())}_hiddenChanged(a){a&&this.hasAttribute("closing")&&this._flushAnimation("closing")}_shouldAnimate(){const a=getComputedStyle(this),k=a.getPropertyValue("animation-name");return!(a.getPropertyValue("display")==="none")&&k&&k!=="none"}_enqueueAnimation(a,k){const j=`__${a}Handler`,et=it=>{it&&it.target!==this||(k(),this.removeEventListener("animationend",et),delete this[j])};this[j]=et,this.addEventListener("animationend",et)}_flushAnimation(a){const k=`__${a}Handler`;typeof this[k]=="function"&&this[k]()}_animatedOpening(){this.parentNode===document.body&&this.hasAttribute("closing")&&this._flushAnimation("closing"),this._attachOverlay(),this.modeless||this._enterModalState(),this.setAttribute("opening",""),this._shouldAnimate()?this._enqueueAnimation("opening",()=>{this._finishOpening()}):this._finishOpening()}_attachOverlay(){this._placeholder=document.createComment("vaadin-overlay-placeholder"),this.parentNode.insertBefore(this._placeholder,this),document.body.appendChild(this),this.bringToFront()}_finishOpening(){this.removeAttribute("opening")}_finishClosing(){this._detachOverlay(),this.$.overlay.style.removeProperty("pointer-events"),this.removeAttribute("closing"),this.dispatchEvent(new CustomEvent("vaadin-overlay-closed"))}_animatedClosing(){this.hasAttribute("opening")&&this._flushAnimation("opening"),this._placeholder&&(this._exitModalState(),this.setAttribute("closing",""),this.dispatchEvent(new CustomEvent("vaadin-overlay-closing")),this._shouldAnimate()?this._enqueueAnimation("closing",()=>{this._finishClosing()}):this._finishClosing())}_detachOverlay(){this._placeholder.parentNode.insertBefore(this,this._placeholder),this._placeholder.parentNode.removeChild(this._placeholder)}_mouseDownListener(a){this._mouseDownInside=a.composedPath().indexOf(this.$.overlay)>=0}_mouseUpListener(a){this._mouseUpInside=a.composedPath().indexOf(this.$.overlay)>=0}_shouldCloseOnOutsideClick(a){return this._last}_outsideClickListener(a){if(a.composedPath().includes(this.$.overlay)||this._mouseDownInside||this._mouseUpInside){this._mouseDownInside=!1,this._mouseUpInside=!1;return}if(!this._shouldCloseOnOutsideClick(a))return;const k=new CustomEvent("vaadin-overlay-outside-click",{bubbles:!0,cancelable:!0,detail:{sourceEvent:a}});this.dispatchEvent(k),this.opened&&!k.defaultPrevented&&this.close(a)}_keydownListener(a){if(this._last&&!(this.modeless&&!a.composedPath().includes(this.$.overlay))&&a.key==="Escape"){const k=new CustomEvent("vaadin-overlay-escape-press",{bubbles:!0,cancelable:!0,detail:{sourceEvent:a}});this.dispatchEvent(k),this.opened&&!k.defaultPrevented&&this.close(a)}}};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function getAncestorRootNodes(z){const y=[];for(;z;){if(z.nodeType===Node.DOCUMENT_NODE){y.push(z);break}if(z.nodeType===Node.DOCUMENT_FRAGMENT_NODE){y.push(z),z=z.host;continue}if(z.assignedSlot){z=z.assignedSlot;continue}z=z.parentNode}return y}function getFlattenedElements(z){const y=[];let a;return z.localName==="slot"?a=z.assignedElements():(y.push(z),a=[...z.children]),a.forEach(k=>y.push(...getFlattenedElements(k))),y}function getClosestElement(z,y){return y?y.closest(z)||getClosestElement(z,y.getRootNode().host):null}function deserializeAttributeValue(z){return z?new Set(z.split(" ")):new Set}function serializeAttributeValue(z){return z?[...z].join(" "):""}function addValueToAttribute(z,y,a){const k=deserializeAttributeValue(z.getAttribute(y));k.add(a),z.setAttribute(y,serializeAttributeValue(k))}function removeValueFromAttribute(z,y,a){const k=deserializeAttributeValue(z.getAttribute(y));if(k.delete(a),k.size===0){z.removeAttribute(y);return}z.setAttribute(y,serializeAttributeValue(k))}function isEmptyTextNode(z){return z.nodeType===Node.TEXT_NODE&&z.textContent.trim()===""}/**
 * @license
 * Copyright (c) 2024 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function observeMove(z,y){let a=null,k;const j=document.documentElement;function et(){k&&clearTimeout(k),a&&a.disconnect(),a=null}function it(nt=!1,ot=1){et();const{left:at,top:lt,width:ct,height:ht}=z.getBoundingClientRect();if(nt||y(),!ct||!ht)return;const ut=Math.floor(lt),ft=Math.floor(j.clientWidth-(at+ct)),vt=Math.floor(j.clientHeight-(lt+ht)),gt=Math.floor(at),bt={rootMargin:`${-ut}px ${-ft}px ${-vt}px ${-gt}px`,threshold:Math.max(0,Math.min(1,ot))||1};let xt=!0;function wt(Mt){const Et=Mt[0].intersectionRatio;if(Et!==ot){if(!xt)return it();Et?it(!1,Et):k=setTimeout(()=>{it(!1,1e-7)},1e3)}xt=!1}a=new IntersectionObserver(wt,bt),a.observe(z)}return it(!0),et}/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const PROP_NAMES_VERTICAL={start:"top",end:"bottom"},PROP_NAMES_HORIZONTAL={start:"left",end:"right"},targetResizeObserver=new ResizeObserver(z=>{setTimeout(()=>{z.forEach(y=>{y.target.__overlay&&y.target.__overlay._updatePosition()})})}),PositionMixin=z=>class extends z{static get properties(){return{positionTarget:{type:Object,value:null,sync:!0},horizontalAlign:{type:String,value:"start",sync:!0},verticalAlign:{type:String,value:"top",sync:!0},noHorizontalOverlap:{type:Boolean,value:!1,sync:!0},noVerticalOverlap:{type:Boolean,value:!1,sync:!0},requiredVerticalSpace:{type:Number,value:0,sync:!0}}}static get observers(){return["__positionSettingsChanged(horizontalAlign, verticalAlign, noHorizontalOverlap, noVerticalOverlap, requiredVerticalSpace)","__overlayOpenedChanged(opened, positionTarget)"]}constructor(){super(),this.__onScroll=this.__onScroll.bind(this),this._updatePosition=this._updatePosition.bind(this)}connectedCallback(){super.connectedCallback(),this.opened&&this.__addUpdatePositionEventListeners()}disconnectedCallback(){super.disconnectedCallback(),this.__removeUpdatePositionEventListeners()}__addUpdatePositionEventListeners(){window.visualViewport.addEventListener("resize",this._updatePosition),window.visualViewport.addEventListener("scroll",this.__onScroll,!0),this.__positionTargetAncestorRootNodes=getAncestorRootNodes(this.positionTarget),this.__positionTargetAncestorRootNodes.forEach(a=>{a.addEventListener("scroll",this.__onScroll,!0)}),this.positionTarget&&(this.__observePositionTargetMove=observeMove(this.positionTarget,()=>{this._updatePosition()}))}__removeUpdatePositionEventListeners(){window.visualViewport.removeEventListener("resize",this._updatePosition),window.visualViewport.removeEventListener("scroll",this.__onScroll,!0),this.__positionTargetAncestorRootNodes&&(this.__positionTargetAncestorRootNodes.forEach(a=>{a.removeEventListener("scroll",this.__onScroll,!0)}),this.__positionTargetAncestorRootNodes=null),this.__observePositionTargetMove&&(this.__observePositionTargetMove(),this.__observePositionTargetMove=null)}__overlayOpenedChanged(a,k){if(this.__removeUpdatePositionEventListeners(),k&&(k.__overlay=null,targetResizeObserver.unobserve(k),a&&(this.__addUpdatePositionEventListeners(),k.__overlay=this,targetResizeObserver.observe(k))),a){const j=getComputedStyle(this);this.__margins||(this.__margins={},["top","bottom","left","right"].forEach(et=>{this.__margins[et]=parseInt(j[et],10)})),this._updatePosition(),requestAnimationFrame(()=>this._updatePosition())}}__positionSettingsChanged(){this._updatePosition()}__onScroll(a){a.target instanceof Node&&this.contains(a.target)||this._updatePosition()}_updatePosition(){if(!this.positionTarget||!this.opened||!this.__margins)return;const a=this.positionTarget.getBoundingClientRect();if(a.width===0&&a.height===0&&this.opened){this.opened=!1;return}const k=this.__shouldAlignStartVertically(a);this.style.justifyContent=k?"flex-start":"flex-end";const j=this.__isRTL,et=this.__shouldAlignStartHorizontally(a,j),it=!j&&et||j&&!et;this.style.alignItems=it?"flex-start":"flex-end";const nt=this.getBoundingClientRect(),ot=this.__calculatePositionInOneDimension(a,nt,this.noVerticalOverlap,PROP_NAMES_VERTICAL,this,k),at=this.__calculatePositionInOneDimension(a,nt,this.noHorizontalOverlap,PROP_NAMES_HORIZONTAL,this,et);Object.assign(this.style,ot,at),this.toggleAttribute("bottom-aligned",!k),this.toggleAttribute("top-aligned",k),this.toggleAttribute("end-aligned",!it),this.toggleAttribute("start-aligned",it)}__shouldAlignStartHorizontally(a,k){const j=Math.max(this.__oldContentWidth||0,this.$.overlay.offsetWidth);this.__oldContentWidth=this.$.overlay.offsetWidth;const et=Math.min(window.innerWidth,document.documentElement.clientWidth),it=!k&&this.horizontalAlign==="start"||k&&this.horizontalAlign==="end";return this.__shouldAlignStart(a,j,et,this.__margins,it,this.noHorizontalOverlap,PROP_NAMES_HORIZONTAL)}__shouldAlignStartVertically(a){const k=this.requiredVerticalSpace||Math.max(this.__oldContentHeight||0,this.$.overlay.offsetHeight);this.__oldContentHeight=this.$.overlay.offsetHeight;const j=Math.min(window.innerHeight,document.documentElement.clientHeight),et=this.verticalAlign==="top";return this.__shouldAlignStart(a,k,j,this.__margins,et,this.noVerticalOverlap,PROP_NAMES_VERTICAL)}__shouldAlignStart(a,k,j,et,it,nt,ot){const at=j-a[nt?ot.end:ot.start]-et[ot.end],lt=a[nt?ot.start:ot.end]-et[ot.start],ct=it?at:lt,ut=ct>(it?lt:at)||ct>k;return it===ut}__adjustBottomProperty(a,k,j){let et;if(a===k.end){if(k.end===PROP_NAMES_VERTICAL.end){const it=Math.min(window.innerHeight,document.documentElement.clientHeight);if(j>it&&this.__oldViewportHeight){const nt=this.__oldViewportHeight-it;et=j-nt}this.__oldViewportHeight=it}if(k.end===PROP_NAMES_HORIZONTAL.end){const it=Math.min(window.innerWidth,document.documentElement.clientWidth);if(j>it&&this.__oldViewportWidth){const nt=this.__oldViewportWidth-it;et=j-nt}this.__oldViewportWidth=it}}return et}__calculatePositionInOneDimension(a,k,j,et,it,nt){const ot=nt?et.start:et.end,at=nt?et.end:et.start,lt=parseFloat(it.style[ot]||getComputedStyle(it)[ot]),ct=this.__adjustBottomProperty(ot,et,lt),ht=k[nt?et.start:et.end]-a[j===nt?et.end:et.start],ut=ct?`${ct}px`:`${lt+ht*(nt?-1:1)}px`;return{[ot]:ut,[at]:""}}};/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const overlayStyles$1=i`
  :host {
    z-index: 200;
    position: fixed;

    /* Despite of what the names say, <vaadin-overlay> is just a container
          for position/sizing/alignment. The actual overlay is the overlay part. */

    /* Default position constraints: the entire viewport. Note: themes can
          override this to introduce gaps between the overlay and the viewport. */
    inset: 0;
    bottom: var(--vaadin-overlay-viewport-bottom);

    /* Use flexbox alignment for the overlay part. */
    display: flex;
    flex-direction: column; /* makes dropdowns sizing easier */
    /* Align to center by default. */
    align-items: center;
    justify-content: center;

    /* Allow centering when max-width/max-height applies. */
    margin: auto;

    /* The host is not clickable, only the overlay part is. */
    pointer-events: none;

    /* Remove tap highlight on touch devices. */
    -webkit-tap-highlight-color: transparent;

    /* CSS API for host */
    --vaadin-overlay-viewport-bottom: 0;
  }

  :host([hidden]),
  :host(:not([opened]):not([closing])),
  :host(:not([opened]):not([closing])) [part='overlay'] {
    display: none !important;
  }

  [part='overlay'] {
    -webkit-overflow-scrolling: touch;
    overflow: auto;
    pointer-events: auto;

    /* Prevent overflowing the host */
    max-width: 100%;
    box-sizing: border-box;

    -webkit-tap-highlight-color: initial; /* reenable tap highlight inside */
  }

  [part='backdrop'] {
    z-index: -1;
    content: '';
    background: rgba(0, 0, 0, 0.5);
    position: fixed;
    inset: 0;
    pointer-events: auto;
  }
`;/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class UserTagsOverlay extends PositionMixin(OverlayMixin(DirMixin(ThemableMixin(PolylitMixin(i$1))))){static get is(){return"vaadin-user-tags-overlay"}static get styles(){return[overlayStyles$1,userTagsOverlayStyles]}render(){return x`
      <div id="backdrop" part="backdrop" ?hidden="${!this.withBackdrop}"></div>
      <div part="overlay" id="overlay">
        <div part="content" id="content">
          <slot></slot>
        </div>
      </div>
    `}}defineCustomElement(UserTagsOverlay);/**
 * @license
 * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
 * The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
 * The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
 * Code distributed by Google as part of the polymer project is also
 * subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
 */let microtaskCurrHandle$1=0,microtaskLastHandle$1=0;const microtaskCallbacks$1=[];let microtaskScheduled$1=!1;function microtaskFlush$1(){microtaskScheduled$1=!1;const z=microtaskCallbacks$1.length;for(let y=0;y<z;y++){const a=microtaskCallbacks$1[y];if(a)try{a()}catch(k){setTimeout(()=>{throw k})}}microtaskCallbacks$1.splice(0,z),microtaskLastHandle$1+=z}const timeOut$1={after(z){return{run(y){return window.setTimeout(y,z)},cancel(y){window.clearTimeout(y)}}},run(z,y){return window.setTimeout(z,y)},cancel(z){window.clearTimeout(z)}},animationFrame={run(z){return window.requestAnimationFrame(z)},cancel(z){window.cancelAnimationFrame(z)}},idlePeriod$1={run(z){return window.requestIdleCallback?window.requestIdleCallback(z):window.setTimeout(z,16)},cancel(z){window.cancelIdleCallback?window.cancelIdleCallback(z):window.clearTimeout(z)}},microTask$1={run(z){microtaskScheduled$1||(microtaskScheduled$1=!0,queueMicrotask(()=>microtaskFlush$1())),microtaskCallbacks$1.push(z);const y=microtaskCurrHandle$1;return microtaskCurrHandle$1+=1,y},cancel(z){const y=z-microtaskLastHandle$1;if(y>=0){if(!microtaskCallbacks$1[y])throw new Error(`invalid async handle: ${z}`);microtaskCallbacks$1[y]=null}}};/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const debouncerQueue$1=new Set;let Debouncer$1=class WC{static debounce(y,a,k){return y instanceof WC?y._cancelAsync():y=new WC,y.setConfig(a,k),y}constructor(){this._asyncModule=null,this._callback=null,this._timer=null}setConfig(y,a){this._asyncModule=y,this._callback=a,this._timer=this._asyncModule.run(()=>{this._timer=null,debouncerQueue$1.delete(this),this._callback()})}cancel(){this.isActive()&&(this._cancelAsync(),debouncerQueue$1.delete(this))}_cancelAsync(){this.isActive()&&(this._asyncModule.cancel(this._timer),this._timer=null)}flush(){this.isActive()&&(this.cancel(),this._callback())}isActive(){return this._timer!=null}};function enqueueDebouncer$1(z){debouncerQueue$1.add(z)}function flushDebouncers$1(){const z=!!debouncerQueue$1.size;return debouncerQueue$1.forEach(y=>{try{y.flush()}catch(a){setTimeout(()=>{throw a})}}),z}const flush$1=()=>{let z;do z=flushDebouncers$1();while(z)};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const listenOnce$1=(z,y)=>new Promise(a=>{const k=()=>{z.removeEventListener(y,k),a()};z.addEventListener(y,k)});class UserTags extends PolylitMixin(i$1){static get is(){return"vaadin-user-tags"}static get styles(){return i`
      :host {
        position: absolute;
      }
    `}render(){return x`
      <vaadin-user-tags-overlay
        id="overlay"
        modeless
        .opened="${this.opened}"
        no-vertical-overlap
        @vaadin-overlay-open="${this._onOverlayOpen}"
      ></vaadin-user-tags-overlay>
    `}static get properties(){return{hasFocus:{type:Boolean,value:!1,observer:"_hasFocusChanged"},opened:{type:Boolean,value:!1,sync:!0},flashing:{type:Boolean,value:!1},target:{type:Object,observer:"__targetChanged"},users:{type:Array,value:()=>[]},duration:{type:Number,value:200},delay:{type:Number,value:2e3},__flashQueue:{type:Array,value:()=>[]},__isTargetVisible:{type:Boolean,value:!1}}}constructor(){super(),this.__targetVisibilityObserver=new IntersectionObserver(([y])=>{this.__onTargetVisibilityChange(y.isIntersecting)},{threshold:1})}get wrapper(){return this.$.overlay.querySelector('[part="tags"]')}connectedCallback(){super.connectedCallback(),this.target&&this.__targetVisibilityObserver.observe(this.target)}disconnectedCallback(){super.disconnectedCallback(),this.opened=!1,this.target&&this.__targetVisibilityObserver.unobserve(this.target)}ready(){super.ready(),this.$.overlay.renderer=y=>{if(!y.firstChild){const a=document.createElement("div");a.setAttribute("part","tags"),y.appendChild(a)}},this.$.overlay.requestContentUpdate()}__onTargetVisibilityChange(y){if(this.__isTargetVisible=y,y&&this.__flashQueue.length>0&&!this.flashing){this.flashTags(this.__flashQueue.shift());return}if(y&&this.hasFocus){this.opened=!0;return}!y&&this.opened&&(this.opened=!1)}__targetChanged(y,a){this.$.overlay.positionTarget=y,a&&this.__targetVisibilityObserver.unobserve(a),y&&this.__targetVisibilityObserver.observe(y)}_hasFocusChanged(y){y&&this.flashing&&this.stopFlash()}createUserTag(y){const a=document.createElement("vaadin-user-tag");return a.name=y.name,a.uid=y.id,a.colorIndex=y.colorIndex,a}getTagForUser(y){return Array.from(this.wrapper.children).find(a=>a.uid===y.id)}getChangedTags(y,a){const k=a.map(et=>this.getTagForUser(et));return{added:y.map(et=>this.getTagForUser(et)||this.createUserTag(et)),removed:k}}applyTagsStart({added:y,removed:a}){const k=this.wrapper;a.forEach(j=>{j&&(j.classList.add("removing"),j.classList.remove("show"))}),y.forEach(j=>k.insertBefore(j,k.firstChild))}applyTagsEnd({added:y,removed:a}){const k=this.wrapper;a.forEach(j=>{j&&j.parentNode===k&&k.removeChild(j)}),y.forEach(j=>j&&j.classList.add("show"))}setUsers(y){this.requestContentUpdate();let a=[],k=[];const j=Array.isArray(y);if(Array.isArray(this.users)){const nt=(y||[]).map(ot=>ot.id);k=this.users.filter(ot=>!nt.includes(ot.id))}if(j){const nt=(this.users||[]).map(ot=>ot.id);a=y.filter(ot=>!nt.includes(ot.id)).reverse()}if(a.length===0&&k.length===0)return;const it=this.getChangedTags(a,k);if(this.__flashQueue.length>0&&k.forEach((nt,ot)=>{it.removed[ot]!==null&&this.__flashQueue.forEach(at=>{at.some(lt=>lt.uid===nt.id)&&(this.__flashQueue=this.__flashQueue.filter((lt,ct)=>ct!==ot))})}),this.opened&&this.hasFocus)this.updateTags(y,it);else if(a.length>0&&document.visibilityState!=="hidden"){const nt=it.added,ot=it.removed;this.updateTagsSync(y,{added:[],removed:ot}),this.flashing||!this.__isTargetVisible?this.__flashQueue=[...this.__flashQueue,nt]:this.flashTags(nt)}else this.updateTagsSync(y,it)}_onOverlayOpen(){Array.from(this.wrapper.children).forEach(y=>{y.classList.contains("removing")||y.classList.add("show")})}flashTags(y){this.flashing=!0;const a=this.wrapper,k=Array.from(a.children);k.forEach(j=>{j.style.display="none"}),y.forEach(j=>{a.insertBefore(j,a.firstChild)}),this.flashPromise=new Promise(j=>{listenOnce$1(this.$.overlay,"vaadin-overlay-open").then(()=>{this._debounceFlashStart=Debouncer$1.debounce(this._debounceFlashStart,timeOut$1.after(this.duration+this.delay),()=>{this.hasFocus||y.forEach(et=>et.classList.remove("show")),this._debounceFlashEnd=Debouncer$1.debounce(this._debounceFlashEnd,timeOut$1.after(this.duration),()=>{const et=()=>{k.forEach(it=>{it.style.display="block"}),this.flashing=!1,j()};this.hasFocus?et():(listenOnce$1(this.$.overlay,"animationend").then(()=>{et()}),this.opened=!1)})})})}).then(()=>{if(this.__flashQueue.length>0){const j=this.__flashQueue[0];this.__flashQueue=[...this.__flashQueue].slice(1),this.flashTags(j)}}),this.opened=!0}stopFlash(){this._debounceFlashStart&&this._debounceFlashStart.flush(),this._debounceFlashEnd&&this._debounceFlashEnd.flush(),this.$.overlay._flushAnimation("closing")}updateTags(y,a){this.applyTagsStart(a),this._debounceRender=Debouncer$1.debounce(this._debounceRender,timeOut$1.after(this.duration),()=>{this.users=y,this.applyTagsEnd(a),y.length===0&&this.opened&&(this.opened=!1)})}updateTagsSync(y,a){this.applyTagsStart(a),this.users=y,this.applyTagsEnd(a)}show(){this.hasFocus=!0,this.__isTargetVisible&&(this.opened=!0)}hide(){this.hasFocus=!1,this.opened=!1}requestContentUpdate(){this._debounceRender&&this._debounceRender.isActive()&&this._debounceRender.flush()}}defineCustomElement(UserTags);/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-field-outline",fieldOutlineStyles,{moduleId:"vaadin-field-outline-styles"});class FieldOutline extends ThemableMixin(DirMixin(PolylitMixin(i$1))){static get is(){return"vaadin-field-outline"}static get properties(){return{user:{type:Object,value:null,observer:"_userChanged",sync:!0}}}render(){return x``}ready(){super.ready(),this.setAttribute("part","outline"),this._field=this.getRootNode().host}_userChanged(y){this.toggleAttribute("has-active-user",!!y);const a=y?`var(--vaadin-user-color-${y.colorIndex})`:"transparent",k="--_active-user-color";this.style.setProperty(k,a),this._field&&this._field.style.setProperty(k,a)}}defineCustomElement(FieldOutline);/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const region=document.createElement("div");region.style.position="fixed";region.style.clip="rect(0px, 0px, 0px, 0px)";region.setAttribute("aria-live","polite");document.body.appendChild(region);let alertDebouncer;function announce(z,y={}){const a=y.mode||"polite",k=y.timeout===void 0?150:y.timeout;a==="alert"?(region.removeAttribute("aria-live"),region.removeAttribute("role"),alertDebouncer=Debouncer$1.debounce(alertDebouncer,animationFrame,()=>{region.setAttribute("role","alert")})):(alertDebouncer&&alertDebouncer.cancel(),region.removeAttribute("role"),region.setAttribute("aria-live",a)),region.textContent="",setTimeout(()=>{region.textContent=z},k)}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const getOutlineTarget=(z,y)=>{switch(y){case"vaadin-big-decimal-field":case"vaadin-combo-box":case"vaadin-date-picker":case"vaadin-email-field":case"vaadin-integer-field":case"vaadin-number-field":case"vaadin-password-field":case"vaadin-select":case"vaadin-text-area":case"vaadin-text-field":case"vaadin-time-picker":return z.shadowRoot.querySelector('[part="input-field"]');case"vaadin-checkbox":return z.shadowRoot.querySelector('[part="checkbox"]');case"vaadin-radio-button":return z.shadowRoot.querySelector('[part="radio"]');default:return z}},fields=new WeakMap,initOutline=z=>{if(!fields.has(z)){const y=z.tagName.toLowerCase(),a=getOutlineTarget(z,y);a.style.position="relative",y.endsWith("text-area")&&(a.style.overflow="visible");const k=document.createElement("style");k.textContent=`
      :host([focused]) [part="outline"] {
        opacity: calc(1 - var(--lumo-input-field-pointer-focus-visible, 0));
      }

      :host([active]) [part="outline"],
      :host([focus-ring]) [part="outline"] {
        display: none;
      }
    `,z.shadowRoot.appendChild(k);const j=document.createElement("vaadin-field-outline");(a===z?z.shadowRoot:a).appendChild(j),j.setAttribute("context",y),fields.set(z,{root:z,target:a,outline:j})}return fields.get(z)};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class ComponentObserver{constructor(y){this.component=y,this.initTags(y)}getFields(){return[this.component]}getFieldIndex(y){return this.getFields().indexOf(y)}getFocusTarget(y){return this.component}initTags(y){const a=document.createElement("vaadin-user-tags");y.shadowRoot.appendChild(a),a.target=y,this._tags=a,y.addEventListener("mouseenter",k=>{k.relatedTarget!==this._tags.$.overlay&&(this._mouse=!0,this._mouseDebouncer=Debouncer$1.debounce(this._mouseDebouncer,timeOut$1.after(200),()=>{this._mouse&&this._tags.show()}))}),y.addEventListener("mouseleave",k=>{k.relatedTarget!==this._tags.$.overlay&&(this._mouse=!1,this._hasFocus||this._tags.hide())}),y.addEventListener("vaadin-highlight-show",k=>{this._hasFocus=!0,this._debouncer&&this._debouncer.isActive()?this._debouncer.cancel():this._tags.show()}),y.addEventListener("vaadin-highlight-hide",k=>{this._hasFocus=!1,this._mouse||(this._debouncer=Debouncer$1.debounce(this._debouncer,timeOut$1.after(1),()=>{this._tags.hide()}))}),this._tags.$.overlay.addEventListener("mouseleave",k=>{k.relatedTarget!==y&&(this._mouse=!1,y.hasAttribute("focused")||this._tags.hide())})}setOutlines(y){const a=this.getFields();a.forEach((k,j)=>{const{outline:et}=initOutline(k),it=a.length===1?0:y.map(nt=>nt.fieldIndex).indexOf(j);et.user=y[it]})}showOutline(y){this.fire("show",y)}hideOutline(y){this.fire("hide",y)}fire(y,a){this.component.dispatchEvent(new CustomEvent(`vaadin-highlight-${y}`,{bubbles:!0,composed:!0,detail:{fieldIndex:this.getFieldIndex(a)}}))}redraw(y){this._tags.setUsers(y),this.setOutlines(y)}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class FieldObserver extends ComponentObserver{constructor(y){super(y),this.addListeners(y)}addListeners(y){y.addEventListener("focusin",a=>this.onFocusIn(a)),y.addEventListener("focusout",a=>this.onFocusOut(a))}onFocusIn(y){const a=this.getFocusTarget(y);this.showOutline(a)}onFocusOut(y){const a=this.getFocusTarget(y);this.hideOutline(a)}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class CheckboxGroupObserver extends FieldObserver{getFields(){return this.component.__checkboxes}getFocusTarget(y){const a=this.getFields();return Array.from(y.composedPath()).find(k=>a.includes(k))}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class DatePickerObserver extends ComponentObserver{constructor(y){super(y),this.datePicker=y,this.blurWhileOpened=!1,this.addListeners(y)}addListeners(y){this.overlay=y.$.overlay,y.addEventListener("opened-changed",a=>this.onOpenedChanged(a)),this.overlay.addEventListener("focusout",a=>this.onOverlayFocusOut(a)),y.addEventListener("focusin",a=>this.onFocusIn(a)),y.addEventListener("focusout",a=>this.onFocusOut(a))}isEventInOverlay(y){return this.datePicker._overlayContent&&this.datePicker._overlayContent.contains(y)}isFullscreen(){return this.datePicker._noInput&&!isKeyboardActive()}onFocusIn(y){if(!this.isEventInOverlay(y.relatedTarget)){if(this.blurWhileOpened){this.blurWhileOpened=!1;return}this.showOutline(this.datePicker)}}onFocusOut(y){this.isEventInOverlay(y.relatedTarget)||(this.datePicker.opened?this.blurWhileOpened=!0:this.hideOutline(this.datePicker))}onOverlayFocusOut(y){this.datePicker.contains(y.relatedTarget)||(this.blurWhileOpened=!0)}onOpenedChanged(y){y.detail.value===!0&&this.isFullscreen()&&this.showOutline(this.datePicker),y.detail.value===!1&&this.blurWhileOpened&&(this.blurWhileOpened=!1,this.hideOutline(this.datePicker))}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class DateObserver extends DatePickerObserver{constructor(y,a){super(y),this.component=a}getFieldIndex(){return 0}}class TimeObserver extends FieldObserver{constructor(y,a){super(y),this.component=a,this.timePicker=y}getFocusTarget(y){return this.timePicker}getFieldIndex(){return 1}}class DateTimePickerObserver extends ComponentObserver{constructor(y){super(y);const[a,k]=this.getFields();this.dateObserver=new DateObserver(a,y),this.timeObserver=new TimeObserver(k,y)}getFields(){return[this.component.querySelector("[slot=date-picker]"),this.component.querySelector("[slot=time-picker]")]}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class ListBoxObserver extends FieldObserver{getFields(){return this.component.items||[]}getFocusTarget(y){const a=this.getFields();return Array.from(y.composedPath()).find(k=>a.includes(k))}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class RadioGroupObserver extends FieldObserver{getFields(){return this.component.__radioButtons}getFocusTarget(y){const a=this.getFields();return Array.from(y.composedPath()).find(k=>a.includes(k))}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SelectObserver extends FieldObserver{constructor(y){super(y),this.blurWhileOpened=!1,this.overlay=y._overlayElement}addListeners(y){super.addListeners(y),y.addEventListener("opened-changed",a=>{y._phone&&a.detail.value===!1&&this.hideOutline(y)})}onFocusIn(y){this.overlay.contains(y.relatedTarget)||!this.component._phone&&this.overlay.hasAttribute("closing")||super.onFocusIn(y)}onFocusOut(y){this.overlay.contains(y.relatedTarget)||super.onFocusOut(y)}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const initFieldObserver=z=>{let y;switch(z.tagName.toLowerCase()){case"vaadin-date-picker":y=new DatePickerObserver(z);break;case"vaadin-date-time-picker":y=new DateTimePickerObserver(z);break;case"vaadin-select":y=new SelectObserver(z);break;case"vaadin-checkbox-group":y=new CheckboxGroupObserver(z);break;case"vaadin-radio-group":y=new RadioGroupObserver(z);break;case"vaadin-list-box":y=new ListBoxObserver(z);break;default:y=new FieldObserver(z)}return y};class FieldHighlighterController{constructor(y){this.host=y,this.user=null,this.users=[]}get user(){return this._user}set user(y){if(this._user=y,y){const a=`${y.name} started editing`,{label:k}=this.host;announce(k?`${a} ${k}`:a)}}hostConnected(){this.redraw()}addUser(y){y&&(this.users.push(y),this.redraw(),this.user=y)}setUsers(y){Array.isArray(y)&&(this.users=y,this.redraw(),this.user=y[y.length-1]||null)}removeUser(y){if(y&&y.id!==void 0){let a;for(let k=0;k<this.users.length;k++)if(this.users[k].id===y.id){a=k;break}a!==void 0&&(this.users.splice(a,1),this.redraw(),this.users.length>0?this.user=this.users[this.users.length-1]:this.user=null)}}redraw(){this.observer.redraw([...this.users].reverse())}}class FieldHighlighter extends HTMLElement{static get is(){return"vaadin-field-highlighter"}static init(y){if(!y._highlighterController){const a=new FieldHighlighterController(y);y.setAttribute("has-highlighter",""),a.observer=initFieldObserver(y),y.addController(a),y._highlighterController=a}return y._highlighterController}static addUser(y,a){this.init(y).addUser(a)}static removeUser(y,a){this.init(y).removeUser(a)}static setUsers(y,a){this.init(y).setUsers(a)}}defineCustomElement(FieldHighlighter);/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/window.JSCompiler_renameProperty=function(z,y){return z};/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/let CSS_URL_RX=/(url\()([^)]*)(\))/g,ABS_URL=/(^\/[^\/])|(^#)|(^[\w-\d]*:)/,workingURL,resolveDoc;function resolveUrl(z,y){if(z&&ABS_URL.test(z)||z==="//")return z;if(workingURL===void 0){workingURL=!1;try{const a=new URL("b","http://a");a.pathname="c%20d",workingURL=a.href==="http://a/c%20d"}catch{}}if(y||(y=document.baseURI||window.location.href),workingURL)try{return new URL(z,y).href}catch{return z}return resolveDoc||(resolveDoc=document.implementation.createHTMLDocument("temp"),resolveDoc.base=resolveDoc.createElement("base"),resolveDoc.head.appendChild(resolveDoc.base),resolveDoc.anchor=resolveDoc.createElement("a"),resolveDoc.body.appendChild(resolveDoc.anchor)),resolveDoc.base.href=y,resolveDoc.anchor.href=z,resolveDoc.anchor.href||z}function resolveCss(z,y){return z.replace(CSS_URL_RX,function(a,k,j,et){return k+"'"+resolveUrl(j.replace(/["']/g,""),y)+"'"+et})}function pathFromUrl(z){return z.substring(0,z.lastIndexOf("/")+1)}/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const useShadow=!window.ShadyDOM||!window.ShadyDOM.inUse;!window.ShadyCSS||window.ShadyCSS.nativeCss;const supportsAdoptingStyleSheets=useShadow&&"adoptedStyleSheets"in Document.prototype&&"replaceSync"in CSSStyleSheet.prototype&&(()=>{try{const z=new CSSStyleSheet;z.replaceSync("");const y=document.createElement("div");return y.attachShadow({mode:"open"}),y.shadowRoot.adoptedStyleSheets=[z],y.shadowRoot.adoptedStyleSheets[0]===z}catch{return!1}})();let rootPath=window.Polymer&&window.Polymer.rootPath||pathFromUrl(document.baseURI||window.location.href),sanitizeDOMValue=window.Polymer&&window.Polymer.sanitizeDOMValue||void 0;window.Polymer&&window.Polymer.setPassiveTouchGestures;let strictTemplatePolicy=window.Polymer&&window.Polymer.strictTemplatePolicy||!1,allowTemplateFromDomModule=window.Polymer&&window.Polymer.allowTemplateFromDomModule||!1,legacyOptimizations=window.Polymer&&window.Polymer.legacyOptimizations||!1,legacyWarnings=window.Polymer&&window.Polymer.legacyWarnings||!1,syncInitialRender=window.Polymer&&window.Polymer.syncInitialRender||!1,legacyUndefined=window.Polymer&&window.Polymer.legacyUndefined||!1,orderedComputed=window.Polymer&&window.Polymer.orderedComputed||!1,removeNestedTemplates=window.Polymer&&window.Polymer.removeNestedTemplates||!1,fastDomIf=window.Polymer&&window.Polymer.fastDomIf||!1,suppressTemplateNotifications=window.Polymer&&window.Polymer.suppressTemplateNotifications||!1;window.Polymer&&window.Polymer.legacyNoObservedAttributes;let useAdoptedStyleSheetsWithBuiltCSS=window.Polymer&&window.Polymer.useAdoptedStyleSheetsWithBuiltCSS||!1;/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/let modules={},lcModules={};function setModule(z,y){modules[z]=lcModules[z.toLowerCase()]=y}function findModule(z){return modules[z]||lcModules[z.toLowerCase()]}function styleOutsideTemplateCheck(z){z.querySelector("style")&&console.warn("dom-module %s has style outside template",z.id)}class DomModule extends HTMLElement{static get observedAttributes(){return["id"]}static import(y,a){if(y){let k=findModule(y);return k&&a?k.querySelector(a):k}return null}attributeChangedCallback(y,a,k,j){a!==k&&this.register()}get assetpath(){if(!this.__assetpath){const y=window.HTMLImports&&HTMLImports.importForElement?HTMLImports.importForElement(this)||document:this.ownerDocument,a=resolveUrl(this.getAttribute("assetpath")||"",y.baseURI);this.__assetpath=pathFromUrl(a)}return this.__assetpath}register(y){if(y=y||this.id,y){if(strictTemplatePolicy&&findModule(y)!==void 0)throw setModule(y,null),new Error(`strictTemplatePolicy: dom-module ${y} re-registered`);this.id=y,setModule(y,this),styleOutsideTemplateCheck(this)}}}DomModule.prototype.modules=modules;customElements.define("dom-module",DomModule);/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const MODULE_STYLE_LINK_SELECTOR="link[rel=import][type~=css]",INCLUDE_ATTR="include",SHADY_UNSCOPED_ATTR="shady-unscoped";function importModule(z){return DomModule.import(z)}function styleForImport(z){let y=z.body?z.body:z;const a=resolveCss(y.textContent,z.baseURI),k=document.createElement("style");return k.textContent=a,k}function stylesFromModules(z){const y=z.trim().split(/\s+/),a=[];for(let k=0;k<y.length;k++)a.push(...stylesFromModule(y[k]));return a}function stylesFromModule(z){const y=importModule(z);if(!y)return console.warn("Could not find style data in module named",z),[];if(y._styles===void 0){const a=[];a.push(..._stylesFromModuleImports(y));const k=y.querySelector("template");k&&a.push(...stylesFromTemplate(k,y.assetpath)),y._styles=a}return y._styles}function stylesFromTemplate(z,y){if(!z._styles){const a=[],k=z.content.querySelectorAll("style");for(let j=0;j<k.length;j++){let et=k[j],it=et.getAttribute(INCLUDE_ATTR);it&&a.push(...stylesFromModules(it).filter(function(nt,ot,at){return at.indexOf(nt)===ot})),y&&(et.textContent=resolveCss(et.textContent,y)),a.push(et)}z._styles=a}return z._styles}function stylesFromModuleImports(z){let y=importModule(z);return y?_stylesFromModuleImports(y):[]}function _stylesFromModuleImports(z){const y=[],a=z.querySelectorAll(MODULE_STYLE_LINK_SELECTOR);for(let k=0;k<a.length;k++){let j=a[k];if(j.import){const et=j.import,it=j.hasAttribute(SHADY_UNSCOPED_ATTR);if(it&&!et._unscopedStyle){const nt=styleForImport(et);nt.setAttribute(SHADY_UNSCOPED_ATTR,""),et._unscopedStyle=nt}else et._style||(et._style=styleForImport(et));y.push(it?et._unscopedStyle:et._style)}}return y}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */let moduleIdIndex=0;function registerStyles(z,y=[],a={}){const k=a.moduleId||`custom-style-module-${moduleIdIndex}`;moduleIdIndex+=1;const j=document.createElement("dom-module");z&&j.setAttribute("theme-for",z);const et=!!(y.length&&a.moduleId),it=[].concat(a.include||[]);it.length===0?j.__allStyles=y:et||(j.__partialStyles=y),j.innerHTML=`
    <template>
      ${it.map(nt=>`<style include=${nt}></style>`)}
      ${et?`<style>${y.map(nt=>nt.cssText).join(`
`)}</style>`:""}
    </template>
  `,j.register(k)}function getModuleStyles(z){return stylesFromTemplate(z.querySelector("template")).map(y=>r$1(y.textContent))}function getAllThemes(){const y=DomModule.prototype.modules;return Object.keys(y).map(a=>{const k=y[a],j=k.getAttribute("theme-for");return k.__allStyles||(k.__allStyles=getModuleStyles(k).concat(k.__partialStyles||[])),{themeFor:j,moduleId:a,styles:k.__allStyles}})}window.Vaadin||(window.Vaadin={});window.Vaadin.styleModules={getAllThemes,registerStyles};themeRegistry&&themeRegistry.length>0&&(themeRegistry.forEach(z=>{registerStyles(z.themeFor,z.styles,{moduleId:z.moduleId,include:z.include})}),themeRegistry.length=0);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const fontIcons=i`
  @font-face {
    font-family: 'lumo-icons';
    src: url(data:application/font-woff;charset=utf-8;base64,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)
      format('woff');
    font-weight: normal;
    font-style: normal;
  }

  html {
    --lumo-icons-align-center: '\\ea01';
    --lumo-icons-align-left: '\\ea02';
    --lumo-icons-align-right: '\\ea03';
    --lumo-icons-angle-down: '\\ea04';
    --lumo-icons-angle-left: '\\ea05';
    --lumo-icons-angle-right: '\\ea06';
    --lumo-icons-angle-up: '\\ea07';
    --lumo-icons-arrow-down: '\\ea08';
    --lumo-icons-arrow-left: '\\ea09';
    --lumo-icons-arrow-right: '\\ea0a';
    --lumo-icons-arrow-up: '\\ea0b';
    --lumo-icons-bar-chart: '\\ea0c';
    --lumo-icons-bell: '\\ea0d';
    --lumo-icons-calendar: '\\ea0e';
    --lumo-icons-checkmark: '\\ea0f';
    --lumo-icons-chevron-down: '\\ea10';
    --lumo-icons-chevron-left: '\\ea11';
    --lumo-icons-chevron-right: '\\ea12';
    --lumo-icons-chevron-up: '\\ea13';
    --lumo-icons-clock: '\\ea14';
    --lumo-icons-cog: '\\ea15';
    --lumo-icons-cross: '\\ea16';
    --lumo-icons-download: '\\ea17';
    --lumo-icons-drag-handle: '\\ea18';
    --lumo-icons-dropdown: '\\ea19';
    --lumo-icons-edit: '\\ea1a';
    --lumo-icons-error: '\\ea1b';
    --lumo-icons-eye: '\\ea1c';
    --lumo-icons-eye-disabled: '\\ea1d';
    --lumo-icons-menu: '\\ea1e';
    --lumo-icons-minus: '\\ea1f';
    --lumo-icons-ordered-list: '\\ea20';
    --lumo-icons-phone: '\\ea21';
    --lumo-icons-photo: '\\ea22';
    --lumo-icons-play: '\\ea23';
    --lumo-icons-plus: '\\ea24';
    --lumo-icons-redo: '\\ea25';
    --lumo-icons-reload: '\\ea26';
    --lumo-icons-resize-handle: '\\ea27';
    --lumo-icons-search: '\\ea28';
    --lumo-icons-undo: '\\ea29';
    --lumo-icons-unordered-list: '\\ea2a';
    --lumo-icons-upload: '\\ea2b';
    --lumo-icons-user: '\\ea2c';
  }
`;addLumoGlobalStyles("font-icons",fontIcons);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const sizing=i`
  :host {
    --lumo-size-xs: 1.625rem;
    --lumo-size-s: 1.875rem;
    --lumo-size-m: 2.25rem;
    --lumo-size-l: 2.75rem;
    --lumo-size-xl: 3.5rem;

    /* Icons */
    --lumo-icon-size-s: 1.25em;
    --lumo-icon-size-m: 1.5em;
    --lumo-icon-size-l: 2.25em;
    /* For backwards compatibility */
    --lumo-icon-size: var(--lumo-icon-size-m);
  }
`;addLumoGlobalStyles("sizing-props",sizing);const detailsSummary$1=i`
  :host {
    display: flex;
    align-items: center;
    width: 100%;
    outline: none;
    padding: var(--lumo-space-s) 0;
    box-sizing: border-box;
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    font-weight: 500;
    line-height: var(--lumo-line-height-xs);
    color: var(--lumo-secondary-text-color);
    background-color: inherit;
    border-radius: var(--lumo-border-radius-m);
    cursor: var(--lumo-clickable-cursor);
    -webkit-tap-highlight-color: transparent;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
  }

  :host([disabled]),
  :host([disabled]) [part='toggle'] {
    color: var(--lumo-disabled-text-color);
    cursor: default;
  }

  @media (hover: hover) {
    :host(:hover:not([disabled])),
    :host(:hover:not([disabled])) [part='toggle'] {
      color: var(--lumo-contrast-80pct);
    }
  }

  [part='toggle'] {
    display: block;
    width: 1em;
    height: 1em;
    margin-left: calc(var(--lumo-space-xs) * -1);
    margin-right: var(--lumo-space-xs);
    font-size: var(--lumo-icon-size-s);
    line-height: 1;
    color: var(--lumo-contrast-60pct);
    font-family: 'lumo-icons';
    cursor: var(--lumo-clickable-cursor);
  }

  [part='toggle']::before {
    content: var(--lumo-icons-angle-right);
  }

  :host([opened]) [part='toggle'] {
    transform: rotate(90deg);
  }

  [part='content'] {
    flex-grow: 1;
  }

  /* RTL styles */
  :host([dir='rtl']) [part='toggle'] {
    margin-left: var(--lumo-space-xs);
    margin-right: calc(var(--lumo-space-xs) * -1);
  }

  :host([dir='rtl']) [part='toggle']::before {
    content: var(--lumo-icons-angle-left);
  }

  :host([opened][dir='rtl']) [part='toggle'] {
    transform: rotate(-90deg);
  }

  /* Small */
  :host([theme~='small']) {
    padding-top: var(--lumo-space-xs);
    padding-bottom: var(--lumo-space-xs);
  }

  :host([theme~='small']) [part='toggle'] {
    margin-right: calc(var(--lumo-space-xs) / 2);
  }

  :host([theme~='small'][dir='rtl']) [part='toggle'] {
    margin-left: calc(var(--lumo-space-xs) / 2);
  }

  /* Filled */
  :host([theme~='filled']) {
    padding: var(--lumo-space-s) calc(var(--lumo-space-s) + var(--lumo-space-xs) / 2);
  }

  /* Reverse */
  :host([theme~='reverse']) {
    justify-content: space-between;
  }

  :host([theme~='reverse']) [part='toggle'] {
    order: 1;
    margin-right: 0;
  }

  :host([theme~='reverse'][dir='rtl']) [part='toggle'] {
    margin-left: 0;
  }

  /* Filled reverse */
  :host([theme~='reverse'][theme~='filled']) {
    padding-left: var(--lumo-space-m);
  }

  :host([theme~='reverse'][theme~='filled'][dir='rtl']) {
    padding-right: var(--lumo-space-m);
  }
`;registerStyles$1("vaadin-details-summary",detailsSummary$1,{moduleId:"lumo-details-summary"});const accordionHeading$1=i`
  :host {
    padding: 0;
  }

  [part='content'] {
    padding: var(--lumo-space-s) 0;
  }

  :host([theme~='filled']) {
    padding-top: 0;
    padding-bottom: 0;
  }
`;registerStyles$1("vaadin-accordion-heading",[detailsSummary$1,accordionHeading$1],{moduleId:"lumo-accordion-heading"});/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/let dedupeId$1=0;const dedupingMixin=function(z){let y=z.__mixinApplications;y||(y=new WeakMap,z.__mixinApplications=y);let a=dedupeId$1++;function k(j){let et=j.__mixinSet;if(et&&et[a])return j;let it=y,nt=it.get(j);if(!nt){nt=z(j),it.set(j,nt);let ot=Object.create(nt.__mixinSet||et||null);ot[a]=!0,nt.__mixinSet=ot}return nt}return k};/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const wrap$j=window.ShadyDOM&&window.ShadyDOM.noPatch&&window.ShadyDOM.wrap?window.ShadyDOM.wrap:window.ShadyDOM?z=>ShadyDOM.patch(z):z=>z;/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/function isPath(z){return z.indexOf(".")>=0}function root(z){let y=z.indexOf(".");return y===-1?z:z.slice(0,y)}function isAncestor(z,y){return z.indexOf(y+".")===0}function isDescendant(z,y){return y.indexOf(z+".")===0}function translate$1(z,y,a){return y+a.slice(z.length)}function matches(z,y){return z===y||isAncestor(z,y)||isDescendant(z,y)}function normalize$1(z){if(Array.isArray(z)){let y=[];for(let a=0;a<z.length;a++){let k=z[a].toString().split(".");for(let j=0;j<k.length;j++)y.push(k[j])}return y.join(".")}else return z}function split(z){return Array.isArray(z)?normalize$1(z).split("."):z.toString().split(".")}function get$6(z,y,a){let k=z,j=split(y);for(let et=0;et<j.length;et++){if(!k)return;let it=j[et];k=k[it]}return a&&(a.path=j.join(".")),k}function set$1(z,y,a){let k=z,j=split(y),et=j[j.length-1];if(j.length>1){for(let it=0;it<j.length-1;it++){let nt=j[it];if(k=k[nt],!k)return}k[et]=a}else k[y]=a;return j.join(".")}/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const caseMap={},DASH_TO_CAMEL=/-[a-z]/g,CAMEL_TO_DASH=/([A-Z])/g;function dashToCamelCase(z){return caseMap[z]||(caseMap[z]=z.indexOf("-")<0?z:z.replace(DASH_TO_CAMEL,y=>y[1].toUpperCase()))}function camelToDashCase(z){return caseMap[z]||(caseMap[z]=z.replace(CAMEL_TO_DASH,"-$1").toLowerCase())}/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/let microtaskCurrHandle=0,microtaskLastHandle=0,microtaskCallbacks=[],microtaskNodeContent=0,microtaskScheduled=!1,microtaskNode=document.createTextNode("");new window.MutationObserver(microtaskFlush).observe(microtaskNode,{characterData:!0});function microtaskFlush(){microtaskScheduled=!1;const z=microtaskCallbacks.length;for(let y=0;y<z;y++){let a=microtaskCallbacks[y];if(a)try{a()}catch(k){setTimeout(()=>{throw k})}}microtaskCallbacks.splice(0,z),microtaskLastHandle+=z}const timeOut={after(z){return{run(y){return window.setTimeout(y,z)},cancel(y){window.clearTimeout(y)}}},run(z,y){return window.setTimeout(z,y)},cancel(z){window.clearTimeout(z)}},idlePeriod={run(z){return window.requestIdleCallback?window.requestIdleCallback(z):window.setTimeout(z,16)},cancel(z){window.cancelIdleCallback?window.cancelIdleCallback(z):window.clearTimeout(z)}},microTask={run(z){return microtaskScheduled||(microtaskScheduled=!0,microtaskNode.textContent=microtaskNodeContent++),microtaskCallbacks.push(z),microtaskCurrHandle++},cancel(z){const y=z-microtaskLastHandle;if(y>=0){if(!microtaskCallbacks[y])throw new Error("invalid async handle: "+z);microtaskCallbacks[y]=null}}};/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const microtask=microTask,PropertiesChanged=dedupingMixin(z=>{class y extends z{static createProperties(k){const j=this.prototype;for(let et in k)et in j||j._createPropertyAccessor(et)}static attributeNameForProperty(k){return k.toLowerCase()}static typeForProperty(k){}_createPropertyAccessor(k,j){this._addPropertyToAttributeMap(k),this.hasOwnProperty(JSCompiler_renameProperty("__dataHasAccessor",this))||(this.__dataHasAccessor=Object.assign({},this.__dataHasAccessor)),this.__dataHasAccessor[k]||(this.__dataHasAccessor[k]=!0,this._definePropertyAccessor(k,j))}_addPropertyToAttributeMap(k){this.hasOwnProperty(JSCompiler_renameProperty("__dataAttributes",this))||(this.__dataAttributes=Object.assign({},this.__dataAttributes));let j=this.__dataAttributes[k];return j||(j=this.constructor.attributeNameForProperty(k),this.__dataAttributes[j]=k),j}_definePropertyAccessor(k,j){Object.defineProperty(this,k,{get(){return this.__data[k]},set:j?function(){}:function(et){this._setPendingProperty(k,et,!0)&&this._invalidateProperties()}})}constructor(){super(),this.__dataEnabled=!1,this.__dataReady=!1,this.__dataInvalid=!1,this.__data={},this.__dataPending=null,this.__dataOld=null,this.__dataInstanceProps=null,this.__dataCounter=0,this.__serializing=!1,this._initializeProperties()}ready(){this.__dataReady=!0,this._flushProperties()}_initializeProperties(){for(let k in this.__dataHasAccessor)this.hasOwnProperty(k)&&(this.__dataInstanceProps=this.__dataInstanceProps||{},this.__dataInstanceProps[k]=this[k],delete this[k])}_initializeInstanceProperties(k){Object.assign(this,k)}_setProperty(k,j){this._setPendingProperty(k,j)&&this._invalidateProperties()}_getProperty(k){return this.__data[k]}_setPendingProperty(k,j,et){let it=this.__data[k],nt=this._shouldPropertyChange(k,j,it);return nt&&(this.__dataPending||(this.__dataPending={},this.__dataOld={}),this.__dataOld&&!(k in this.__dataOld)&&(this.__dataOld[k]=it),this.__data[k]=j,this.__dataPending[k]=j),nt}_isPropertyPending(k){return!!(this.__dataPending&&this.__dataPending.hasOwnProperty(k))}_invalidateProperties(){!this.__dataInvalid&&this.__dataReady&&(this.__dataInvalid=!0,microtask.run(()=>{this.__dataInvalid&&(this.__dataInvalid=!1,this._flushProperties())}))}_enableProperties(){this.__dataEnabled||(this.__dataEnabled=!0,this.__dataInstanceProps&&(this._initializeInstanceProperties(this.__dataInstanceProps),this.__dataInstanceProps=null),this.ready())}_flushProperties(){this.__dataCounter++;const k=this.__data,j=this.__dataPending,et=this.__dataOld;this._shouldPropertiesChange(k,j,et)&&(this.__dataPending=null,this.__dataOld=null,this._propertiesChanged(k,j,et)),this.__dataCounter--}_shouldPropertiesChange(k,j,et){return!!j}_propertiesChanged(k,j,et){}_shouldPropertyChange(k,j,et){return et!==j&&(et===et||j===j)}attributeChangedCallback(k,j,et,it){j!==et&&this._attributeToProperty(k,et),super.attributeChangedCallback&&super.attributeChangedCallback(k,j,et,it)}_attributeToProperty(k,j,et){if(!this.__serializing){const it=this.__dataAttributes,nt=it&&it[k]||k;this[nt]=this._deserializeValue(j,et||this.constructor.typeForProperty(nt))}}_propertyToAttribute(k,j,et){this.__serializing=!0,et=arguments.length<3?this[k]:et,this._valueToNodeAttribute(this,et,j||this.constructor.attributeNameForProperty(k)),this.__serializing=!1}_valueToNodeAttribute(k,j,et){const it=this._serializeValue(j);(et==="class"||et==="name"||et==="slot")&&(k=wrap$j(k)),it===void 0?k.removeAttribute(et):k.setAttribute(et,it===""&&window.trustedTypes?window.trustedTypes.emptyScript:it)}_serializeValue(k){switch(typeof k){case"boolean":return k?"":void 0;default:return k?.toString()}}_deserializeValue(k,j){switch(j){case Boolean:return k!==null;case Number:return Number(k);default:return k}}}return y});/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const nativeProperties={};let proto=HTMLElement.prototype;for(;proto;){let z=Object.getOwnPropertyNames(proto);for(let y=0;y<z.length;y++)nativeProperties[z[y]]=!0;proto=Object.getPrototypeOf(proto)}const isTrustedType=window.trustedTypes?z=>trustedTypes.isHTML(z)||trustedTypes.isScript(z)||trustedTypes.isScriptURL(z):()=>!1;function saveAccessorValue(z,y){if(!nativeProperties[y]){let a=z[y];a!==void 0&&(z.__data?z._setPendingProperty(y,a):(z.__dataProto?z.hasOwnProperty(JSCompiler_renameProperty("__dataProto",z))||(z.__dataProto=Object.create(z.__dataProto)):z.__dataProto={},z.__dataProto[y]=a))}}const PropertyAccessors=dedupingMixin(z=>{const y=PropertiesChanged(z);class a extends y{static createPropertiesForAttributes(){let j=this.observedAttributes;for(let et=0;et<j.length;et++)this.prototype._createPropertyAccessor(dashToCamelCase(j[et]))}static attributeNameForProperty(j){return camelToDashCase(j)}_initializeProperties(){this.__dataProto&&(this._initializeProtoProperties(this.__dataProto),this.__dataProto=null),super._initializeProperties()}_initializeProtoProperties(j){for(let et in j)this._setProperty(et,j[et])}_ensureAttribute(j,et){const it=this;it.hasAttribute(j)||this._valueToNodeAttribute(it,et,j)}_serializeValue(j){switch(typeof j){case"object":if(j instanceof Date)return j.toString();if(j){if(isTrustedType(j))return j;try{return JSON.stringify(j)}catch{return""}}default:return super._serializeValue(j)}}_deserializeValue(j,et){let it;switch(et){case Object:try{it=JSON.parse(j)}catch{it=j}break;case Array:try{it=JSON.parse(j)}catch{it=null,console.warn(`Polymer::Attributes: couldn't decode Array as JSON: ${j}`)}break;case Date:it=isNaN(j)?String(j):Number(j),it=new Date(it);break;default:it=super._deserializeValue(j,et);break}return it}_definePropertyAccessor(j,et){saveAccessorValue(this,j),super._definePropertyAccessor(j,et)}_hasAccessor(j){return this.__dataHasAccessor&&this.__dataHasAccessor[j]}_isPropertyPending(j){return!!(this.__dataPending&&j in this.__dataPending)}}return a});/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const templateExtensions={"dom-if":!0,"dom-repeat":!0};let placeholderBugDetect=!1,placeholderBug=!1;function hasPlaceholderBug(){if(!placeholderBugDetect){placeholderBugDetect=!0;const z=document.createElement("textarea");z.placeholder="a",placeholderBug=z.placeholder===z.textContent}return placeholderBug}function fixPlaceholder(z){hasPlaceholderBug()&&z.localName==="textarea"&&z.placeholder&&z.placeholder===z.textContent&&(z.textContent=null)}const copyAttributeWithTemplateEventPolicy=(()=>{const z=window.trustedTypes&&window.trustedTypes.createPolicy("polymer-template-event-attribute-policy",{createScript:y=>y});return(y,a,k)=>{const j=a.getAttribute(k);if(z&&k.startsWith("on-")){y.setAttribute(k,z.createScript(j,k));return}y.setAttribute(k,j)}})();function wrapTemplateExtension(z){let y=z.getAttribute("is");if(y&&templateExtensions[y]){let a=z;for(a.removeAttribute("is"),z=a.ownerDocument.createElement(y),a.parentNode.replaceChild(z,a),z.appendChild(a);a.attributes.length;){const{name:k}=a.attributes[0];copyAttributeWithTemplateEventPolicy(z,a,k),a.removeAttribute(k)}}return z}function findTemplateNode(z,y){let a=y.parentInfo&&findTemplateNode(z,y.parentInfo);if(a){for(let k=a.firstChild,j=0;k;k=k.nextSibling)if(y.parentIndex===j++)return k}else return z}function applyIdToMap(z,y,a,k){k.id&&(y[k.id]=a)}function applyEventListener(z,y,a){if(a.events&&a.events.length)for(let k=0,j=a.events,et;k<j.length&&(et=j[k]);k++)z._addMethodEventListenerToNode(y,et.name,et.value,z)}function applyTemplateInfo(z,y,a,k){a.templateInfo&&(y._templateInfo=a.templateInfo,y._parentTemplateInfo=k)}function createNodeEventHandler(z,y,a){return z=z._methodHost||z,function(j){z[a]?z[a](j,j.detail):console.warn("listener method `"+a+"` not defined")}}const TemplateStamp=dedupingMixin(z=>{class y extends z{static _parseTemplate(k,j){if(!k._templateInfo){let et=k._templateInfo={};et.nodeInfoList=[],et.nestedTemplate=!!j,et.stripWhiteSpace=j&&j.stripWhiteSpace||k.hasAttribute&&k.hasAttribute("strip-whitespace"),this._parseTemplateContent(k,et,{parent:null})}return k._templateInfo}static _parseTemplateContent(k,j,et){return this._parseTemplateNode(k.content,j,et)}static _parseTemplateNode(k,j,et){let it=!1,nt=k;return nt.localName=="template"&&!nt.hasAttribute("preserve-content")?it=this._parseTemplateNestedTemplate(nt,j,et)||it:nt.localName==="slot"&&(j.hasInsertionPoint=!0),fixPlaceholder(nt),nt.firstChild&&this._parseTemplateChildNodes(nt,j,et),nt.hasAttributes&&nt.hasAttributes()&&(it=this._parseTemplateNodeAttributes(nt,j,et)||it),it||et.noted}static _parseTemplateChildNodes(k,j,et){if(!(k.localName==="script"||k.localName==="style"))for(let it=k.firstChild,nt=0,ot;it;it=ot){if(it.localName=="template"&&(it=wrapTemplateExtension(it)),ot=it.nextSibling,it.nodeType===Node.TEXT_NODE){let lt=ot;for(;lt&&lt.nodeType===Node.TEXT_NODE;)it.textContent+=lt.textContent,ot=lt.nextSibling,k.removeChild(lt),lt=ot;if(j.stripWhiteSpace&&!it.textContent.trim()){k.removeChild(it);continue}}let at={parentIndex:nt,parentInfo:et};this._parseTemplateNode(it,j,at)&&(at.infoIndex=j.nodeInfoList.push(at)-1),it.parentNode&&nt++}}static _parseTemplateNestedTemplate(k,j,et){let it=k,nt=this._parseTemplate(it,j);return(nt.content=it.content.ownerDocument.createDocumentFragment()).appendChild(it.content),et.templateInfo=nt,!0}static _parseTemplateNodeAttributes(k,j,et){let it=!1,nt=Array.from(k.attributes);for(let ot=nt.length-1,at;at=nt[ot];ot--)it=this._parseTemplateNodeAttribute(k,j,et,at.name,at.value)||it;return it}static _parseTemplateNodeAttribute(k,j,et,it,nt){return it.slice(0,3)==="on-"?(k.removeAttribute(it),et.events=et.events||[],et.events.push({name:it.slice(3),value:nt}),!0):it==="id"?(et.id=nt,!0):!1}static _contentForTemplate(k){let j=k._templateInfo;return j&&j.content||k.content}_stampTemplate(k,j){k&&!k.content&&window.HTMLTemplateElement&&HTMLTemplateElement.decorate&&HTMLTemplateElement.decorate(k),j=j||this.constructor._parseTemplate(k);let et=j.nodeInfoList,it=j.content||k.content,nt=document.importNode(it,!0);nt.__noInsertionPoint=!j.hasInsertionPoint;let ot=nt.nodeList=new Array(et.length);nt.$={};for(let at=0,lt=et.length,ct;at<lt&&(ct=et[at]);at++){let ht=ot[at]=findTemplateNode(nt,ct);applyIdToMap(this,nt.$,ht,ct),applyTemplateInfo(this,ht,ct,j),applyEventListener(this,ht,ct)}return nt=nt,nt}_addMethodEventListenerToNode(k,j,et,it){it=it||k;let nt=createNodeEventHandler(it,j,et);return this._addEventListenerToNode(k,j,nt),nt}_addEventListenerToNode(k,j,et){k.addEventListener(j,et)}_removeEventListenerFromNode(k,j,et){k.removeEventListener(j,et)}}return y});/**
 * @fileoverview
 * @suppress {checkPrototypalTypes}
 * @license Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at
 * http://polymer.github.io/LICENSE.txt The complete set of authors may be found
 * at http://polymer.github.io/AUTHORS.txt The complete set of contributors may
 * be found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by
 * Google as part of the polymer project is also subject to an additional IP
 * rights grant found at http://polymer.github.io/PATENTS.txt
 */let dedupeId=0;const NOOP=[],TYPES={COMPUTE:"__computeEffects",REFLECT:"__reflectEffects",NOTIFY:"__notifyEffects",PROPAGATE:"__propagateEffects",OBSERVE:"__observeEffects",READ_ONLY:"__readOnly"},COMPUTE_INFO="__computeInfo",capitalAttributeRegex=/[A-Z]/;function ensureOwnEffectMap(z,y,a){let k=z[y];if(!k)k=z[y]={};else if(!z.hasOwnProperty(y)&&(k=z[y]=Object.create(z[y]),a))for(let j in k){let et=k[j],it=k[j]=Array(et.length);for(let nt=0;nt<et.length;nt++)it[nt]=et[nt]}return k}function runEffects(z,y,a,k,j,et){if(y){let it=!1;const nt=dedupeId++;for(let ot in a){let at=j?root(ot):ot,lt=y[at];if(lt)for(let ct=0,ht=lt.length,ut;ct<ht&&(ut=lt[ct]);ct++)(!ut.info||ut.info.lastRun!==nt)&&(!j||pathMatchesTrigger(ot,ut.trigger))&&(ut.info&&(ut.info.lastRun=nt),ut.fn(z,ot,a,k,ut.info,j,et),it=!0)}return it}return!1}function runEffectsForProperty(z,y,a,k,j,et,it,nt){let ot=!1,at=it?root(k):k,lt=y[at];if(lt)for(let ct=0,ht=lt.length,ut;ct<ht&&(ut=lt[ct]);ct++)(!ut.info||ut.info.lastRun!==a)&&(!it||pathMatchesTrigger(k,ut.trigger))&&(ut.info&&(ut.info.lastRun=a),ut.fn(z,k,j,et,ut.info,it,nt),ot=!0);return ot}function pathMatchesTrigger(z,y){if(y){let a=y.name;return a==z||!!(y.structured&&isAncestor(a,z))||!!(y.wildcard&&isDescendant(a,z))}else return!0}function runObserverEffect(z,y,a,k,j){let et=typeof j.method=="string"?z[j.method]:j.method,it=j.property;et?et.call(z,z.__data[it],k[it]):j.dynamicFn||console.warn("observer method `"+j.method+"` not defined")}function runNotifyEffects(z,y,a,k,j){let et=z[TYPES.NOTIFY],it,nt=dedupeId++;for(let at in y)y[at]&&(et&&runEffectsForProperty(z,et,nt,at,a,k,j)||j&&notifyPath(z,at,a))&&(it=!0);let ot;it&&(ot=z.__dataHost)&&ot._invalidateProperties&&ot._invalidateProperties()}function notifyPath(z,y,a){let k=root(y);if(k!==y){let j=camelToDashCase(k)+"-changed";return dispatchNotifyEvent(z,j,a[y],y),!0}return!1}function dispatchNotifyEvent(z,y,a,k){let j={value:a,queueProperty:!0};k&&(j.path=k),wrap$j(z).dispatchEvent(new CustomEvent(y,{detail:j}))}function runNotifyEffect(z,y,a,k,j,et){let nt=(et?root(y):y)!=y?y:null,ot=nt?get$6(z,nt):z.__data[y];nt&&ot===void 0&&(ot=a[y]),dispatchNotifyEvent(z,j.eventName,ot,nt)}function handleNotification(z,y,a,k,j){let et,it=z.detail,nt=it&&it.path;nt?(k=translate$1(a,k,nt),et=it&&it.value):et=z.currentTarget[a],et=j?!et:et,(!y[TYPES.READ_ONLY]||!y[TYPES.READ_ONLY][k])&&y._setPendingPropertyOrPath(k,et,!0,!!nt)&&(!it||!it.queueProperty)&&y._invalidateProperties()}function runReflectEffect(z,y,a,k,j){let et=z.__data[y];sanitizeDOMValue&&(et=sanitizeDOMValue(et,j.attrName,"attribute",z)),z._propertyToAttribute(y,j.attrName,et)}function runComputedEffects(z,y,a,k){let j=z[TYPES.COMPUTE];if(j)if(orderedComputed){dedupeId++;const et=getComputedOrder(z),it=[];for(let ot in y)enqueueEffectsFor(ot,j,it,et,k);let nt;for(;nt=it.shift();)runComputedEffect(z,"",y,a,nt)&&enqueueEffectsFor(nt.methodInfo,j,it,et,k);Object.assign(a,z.__dataOld),Object.assign(y,z.__dataPending),z.__dataPending=null}else{let et=y;for(;runEffects(z,j,et,a,k);)Object.assign(a,z.__dataOld),Object.assign(y,z.__dataPending),et=z.__dataPending,z.__dataPending=null}}const insertEffect=(z,y,a)=>{let k=0,j=y.length-1,et=-1;for(;k<=j;){const it=k+j>>1,nt=a.get(y[it].methodInfo)-a.get(z.methodInfo);if(nt<0)k=it+1;else if(nt>0)j=it-1;else{et=it;break}}et<0&&(et=j+1),y.splice(et,0,z)},enqueueEffectsFor=(z,y,a,k,j)=>{const et=j?root(z):z,it=y[et];if(it)for(let nt=0;nt<it.length;nt++){const ot=it[nt];ot.info.lastRun!==dedupeId&&(!j||pathMatchesTrigger(z,ot.trigger))&&(ot.info.lastRun=dedupeId,insertEffect(ot.info,a,k))}};function getComputedOrder(z){let y=z.constructor.__orderedComputedDeps;if(!y){y=new Map;const a=z[TYPES.COMPUTE];let{counts:k,ready:j,total:et}=dependencyCounts(z),it;for(;it=j.shift();){y.set(it,y.size);const nt=a[it];nt&&nt.forEach(ot=>{const at=ot.info.methodInfo;--et,--k[at]===0&&j.push(at)})}et!==0&&console.warn(`Computed graph for ${z.localName} incomplete; circular?`),z.constructor.__orderedComputedDeps=y}return y}function dependencyCounts(z){const y=z[COMPUTE_INFO],a={},k=z[TYPES.COMPUTE],j=[];let et=0;for(let it in y){const nt=y[it];et+=a[it]=nt.args.filter(ot=>!ot.literal).length+(nt.dynamicFn?1:0)}for(let it in k)y[it]||j.push(it);return{counts:a,ready:j,total:et}}function runComputedEffect(z,y,a,k,j){let et=runMethodEffect(z,y,a,k,j);if(et===NOOP)return!1;let it=j.methodInfo;return z.__dataHasAccessor&&z.__dataHasAccessor[it]?z._setPendingProperty(it,et,!0):(z[it]=et,!1)}function computeLinkedPaths(z,y,a){let k=z.__dataLinkedPaths;if(k){let j;for(let et in k){let it=k[et];isDescendant(et,y)?(j=translate$1(et,it,y),z._setPendingPropertyOrPath(j,a,!0,!0)):isDescendant(it,y)&&(j=translate$1(it,et,y),z._setPendingPropertyOrPath(j,a,!0,!0))}}}function addBinding(z,y,a,k,j,et,it){a.bindings=a.bindings||[];let nt={kind:k,target:j,parts:et,literal:it,isCompound:et.length!==1};if(a.bindings.push(nt),shouldAddListener(nt)){let{event:at,negate:lt}=nt.parts[0];nt.listenerEvent=at||camelToDashCase(j)+"-changed",nt.listenerNegate=lt}let ot=y.nodeInfoList.length;for(let at=0;at<nt.parts.length;at++){let lt=nt.parts[at];lt.compoundIndex=at,addEffectForBindingPart(z,y,nt,lt,ot)}}function addEffectForBindingPart(z,y,a,k,j){if(!k.literal)if(a.kind==="attribute"&&a.target[0]==="-")console.warn("Cannot set attribute "+a.target+' because "-" is not a valid attribute starting character');else{let et=k.dependencies,it={index:j,binding:a,part:k,evaluator:z};for(let nt=0;nt<et.length;nt++){let ot=et[nt];typeof ot=="string"&&(ot=parseArg(ot),ot.wildcard=!0),z._addTemplatePropertyEffect(y,ot.rootProperty,{fn:runBindingEffect,info:it,trigger:ot})}}}function runBindingEffect(z,y,a,k,j,et,it){let nt=it[j.index],ot=j.binding,at=j.part;if(et&&at.source&&y.length>at.source.length&&ot.kind=="property"&&!ot.isCompound&&nt.__isPropertyEffectsClient&&nt.__dataHasAccessor&&nt.__dataHasAccessor[ot.target]){let lt=a[y];y=translate$1(at.source,ot.target,y),nt._setPendingPropertyOrPath(y,lt,!1,!0)&&z._enqueueClient(nt)}else{let lt=j.evaluator._evaluateBinding(z,at,y,a,k,et);lt!==NOOP&&applyBindingValue(z,nt,ot,at,lt)}}function applyBindingValue(z,y,a,k,j){if(j=computeBindingValue(y,j,a,k),sanitizeDOMValue&&(j=sanitizeDOMValue(j,a.target,a.kind,y)),a.kind=="attribute")z._valueToNodeAttribute(y,j,a.target);else{let et=a.target;y.__isPropertyEffectsClient&&y.__dataHasAccessor&&y.__dataHasAccessor[et]?(!y[TYPES.READ_ONLY]||!y[TYPES.READ_ONLY][et])&&y._setPendingProperty(et,j)&&z._enqueueClient(y):z._setUnmanagedPropertyToNode(y,et,j)}}function computeBindingValue(z,y,a,k){if(a.isCompound){let j=z.__dataCompoundStorage[a.target];j[k.compoundIndex]=y,y=j.join("")}return a.kind!=="attribute"&&(a.target==="textContent"||a.target==="value"&&(z.localName==="input"||z.localName==="textarea"))&&(y=y??""),y}function shouldAddListener(z){return!!z.target&&z.kind!="attribute"&&z.kind!="text"&&!z.isCompound&&z.parts[0].mode==="{"}function setupBindings(z,y){let{nodeList:a,nodeInfoList:k}=y;if(k.length)for(let j=0;j<k.length;j++){let et=k[j],it=a[j],nt=et.bindings;if(nt)for(let ot=0;ot<nt.length;ot++){let at=nt[ot];setupCompoundStorage(it,at),addNotifyListener(it,z,at)}it.__dataHost=z}}function setupCompoundStorage(z,y){if(y.isCompound){let a=z.__dataCompoundStorage||(z.__dataCompoundStorage={}),k=y.parts,j=new Array(k.length);for(let it=0;it<k.length;it++)j[it]=k[it].literal;let et=y.target;a[et]=j,y.literal&&y.kind=="property"&&(et==="className"&&(z=wrap$j(z)),z[et]=y.literal)}}function addNotifyListener(z,y,a){if(a.listenerEvent){let k=a.parts[0];z.addEventListener(a.listenerEvent,function(j){handleNotification(j,y,a.target,k.source,k.negate)})}}function createMethodEffect(z,y,a,k,j,et){et=y.static||et&&(typeof et!="object"||et[y.methodName]);let it={methodName:y.methodName,args:y.args,methodInfo:j,dynamicFn:et};for(let nt=0,ot;nt<y.args.length&&(ot=y.args[nt]);nt++)ot.literal||z._addPropertyEffect(ot.rootProperty,a,{fn:k,info:it,trigger:ot});return et&&z._addPropertyEffect(y.methodName,a,{fn:k,info:it}),it}function runMethodEffect(z,y,a,k,j){let et=z._methodHost||z,it=et[j.methodName];if(it){let nt=z._marshalArgs(j.args,y,a);return nt===NOOP?NOOP:it.apply(et,nt)}else j.dynamicFn||console.warn("method `"+j.methodName+"` not defined")}const emptyArray=[],IDENT="(?:[a-zA-Z_$][\\w.:$\\-*]*)",NUMBER$1="(?:[-+]?[0-9]*\\.?[0-9]+(?:[eE][-+]?[0-9]+)?)",SQUOTE_STRING="(?:'(?:[^'\\\\]|\\\\.)*')",DQUOTE_STRING='(?:"(?:[^"\\\\]|\\\\.)*")',STRING="(?:"+SQUOTE_STRING+"|"+DQUOTE_STRING+")",ARGUMENT="(?:("+IDENT+"|"+NUMBER$1+"|"+STRING+")\\s*)",ARGUMENTS="(?:"+ARGUMENT+"(?:,\\s*"+ARGUMENT+")*)",ARGUMENT_LIST="(?:\\(\\s*(?:"+ARGUMENTS+"?)\\)\\s*)",BINDING="("+IDENT+"\\s*"+ARGUMENT_LIST+"?)",OPEN_BRACKET="(\\[\\[|{{)\\s*",CLOSE_BRACKET="(?:]]|}})",NEGATE="(?:(!)\\s*)?",EXPRESSION=OPEN_BRACKET+NEGATE+BINDING+CLOSE_BRACKET,bindingRegex=new RegExp(EXPRESSION,"g");function literalFromParts(z){let y="";for(let a=0;a<z.length;a++){let k=z[a].literal;y+=k||""}return y}function parseMethod(z){let y=z.match(/([^\s]+?)\(([\s\S]*)\)/);if(y){let k={methodName:y[1],static:!0,args:emptyArray};if(y[2].trim()){let j=y[2].replace(/\\,/g,"&comma;").split(",");return parseArgs(j,k)}else return k}return null}function parseArgs(z,y){return y.args=z.map(function(a){let k=parseArg(a);return k.literal||(y.static=!1),k},this),y}function parseArg(z){let y=z.trim().replace(/&comma;/g,",").replace(/\\(.)/g,"$1"),a={name:y,value:"",literal:!1},k=y[0];switch(k==="-"&&(k=y[1]),k>="0"&&k<="9"&&(k="#"),k){case"'":case'"':a.value=y.slice(1,-1),a.literal=!0;break;case"#":a.value=Number(y),a.literal=!0;break}return a.literal||(a.rootProperty=root(y),a.structured=isPath(y),a.structured&&(a.wildcard=y.slice(-2)==".*",a.wildcard&&(a.name=y.slice(0,-2)))),a}function getArgValue(z,y,a){let k=get$6(z,a);return k===void 0&&(k=y[a]),k}function notifySplices(z,y,a,k){const j={indexSplices:k};legacyUndefined&&!z._overrideLegacyUndefined&&(y.splices=j),z.notifyPath(a+".splices",j),z.notifyPath(a+".length",y.length),legacyUndefined&&!z._overrideLegacyUndefined&&(j.indexSplices=[])}function notifySplice(z,y,a,k,j,et){notifySplices(z,y,a,[{index:k,addedCount:j,removed:et,object:y,type:"splice"}])}function upper(z){return z[0].toUpperCase()+z.substring(1)}const PropertyEffects=dedupingMixin(z=>{const y=TemplateStamp(PropertyAccessors(z));class a extends y{constructor(){super(),this.__isPropertyEffectsClient=!0,this.__dataClientsReady,this.__dataPendingClients,this.__dataToNotify,this.__dataLinkedPaths,this.__dataHasPaths,this.__dataCompoundStorage,this.__dataHost,this.__dataTemp,this.__dataClientsInitialized,this.__data,this.__dataPending,this.__dataOld,this.__computeEffects,this.__computeInfo,this.__reflectEffects,this.__notifyEffects,this.__propagateEffects,this.__observeEffects,this.__readOnly,this.__templateInfo,this._overrideLegacyUndefined}get PROPERTY_EFFECT_TYPES(){return TYPES}_initializeProperties(){super._initializeProperties(),this._registerHost(),this.__dataClientsReady=!1,this.__dataPendingClients=null,this.__dataToNotify=null,this.__dataLinkedPaths=null,this.__dataHasPaths=!1,this.__dataCompoundStorage=this.__dataCompoundStorage||null,this.__dataHost=this.__dataHost||null,this.__dataTemp={},this.__dataClientsInitialized=!1}_registerHost(){if(hostStack.length){let j=hostStack[hostStack.length-1];j._enqueueClient(this),this.__dataHost=j}}_initializeProtoProperties(j){this.__data=Object.create(j),this.__dataPending=Object.create(j),this.__dataOld={}}_initializeInstanceProperties(j){let et=this[TYPES.READ_ONLY];for(let it in j)(!et||!et[it])&&(this.__dataPending=this.__dataPending||{},this.__dataOld=this.__dataOld||{},this.__data[it]=this.__dataPending[it]=j[it])}_addPropertyEffect(j,et,it){this._createPropertyAccessor(j,et==TYPES.READ_ONLY);let nt=ensureOwnEffectMap(this,et,!0)[j];nt||(nt=this[et][j]=[]),nt.push(it)}_removePropertyEffect(j,et,it){let nt=ensureOwnEffectMap(this,et,!0)[j],ot=nt.indexOf(it);ot>=0&&nt.splice(ot,1)}_hasPropertyEffect(j,et){let it=this[et];return!!(it&&it[j])}_hasReadOnlyEffect(j){return this._hasPropertyEffect(j,TYPES.READ_ONLY)}_hasNotifyEffect(j){return this._hasPropertyEffect(j,TYPES.NOTIFY)}_hasReflectEffect(j){return this._hasPropertyEffect(j,TYPES.REFLECT)}_hasComputedEffect(j){return this._hasPropertyEffect(j,TYPES.COMPUTE)}_setPendingPropertyOrPath(j,et,it,nt){if(nt||root(Array.isArray(j)?j[0]:j)!==j){if(!nt){let ot=get$6(this,j);if(j=set$1(this,j,et),!j||!super._shouldPropertyChange(j,et,ot))return!1}if(this.__dataHasPaths=!0,this._setPendingProperty(j,et,it))return computeLinkedPaths(this,j,et),!0}else{if(this.__dataHasAccessor&&this.__dataHasAccessor[j])return this._setPendingProperty(j,et,it);this[j]=et}return!1}_setUnmanagedPropertyToNode(j,et,it){(it!==j[et]||typeof it=="object")&&(et==="className"&&(j=wrap$j(j)),j[et]=it)}_setPendingProperty(j,et,it){let nt=this.__dataHasPaths&&isPath(j),ot=nt?this.__dataTemp:this.__data;return this._shouldPropertyChange(j,et,ot[j])?(this.__dataPending||(this.__dataPending={},this.__dataOld={}),j in this.__dataOld||(this.__dataOld[j]=this.__data[j]),nt?this.__dataTemp[j]=et:this.__data[j]=et,this.__dataPending[j]=et,(nt||this[TYPES.NOTIFY]&&this[TYPES.NOTIFY][j])&&(this.__dataToNotify=this.__dataToNotify||{},this.__dataToNotify[j]=it),!0):!1}_setProperty(j,et){this._setPendingProperty(j,et,!0)&&this._invalidateProperties()}_invalidateProperties(){this.__dataReady&&this._flushProperties()}_enqueueClient(j){this.__dataPendingClients=this.__dataPendingClients||[],j!==this&&this.__dataPendingClients.push(j)}_flushClients(){this.__dataClientsReady?this.__enableOrFlushClients():(this.__dataClientsReady=!0,this._readyClients(),this.__dataReady=!0)}__enableOrFlushClients(){let j=this.__dataPendingClients;if(j){this.__dataPendingClients=null;for(let et=0;et<j.length;et++){let it=j[et];it.__dataEnabled?it.__dataPending&&it._flushProperties():it._enableProperties()}}}_readyClients(){this.__enableOrFlushClients()}setProperties(j,et){for(let it in j)(et||!this[TYPES.READ_ONLY]||!this[TYPES.READ_ONLY][it])&&this._setPendingPropertyOrPath(it,j[it],!0);this._invalidateProperties()}ready(){this._flushProperties(),this.__dataClientsReady||this._flushClients(),this.__dataPending&&this._flushProperties()}_propertiesChanged(j,et,it){let nt=this.__dataHasPaths;this.__dataHasPaths=!1;let ot;runComputedEffects(this,et,it,nt),ot=this.__dataToNotify,this.__dataToNotify=null,this._propagatePropertyChanges(et,it,nt),this._flushClients(),runEffects(this,this[TYPES.REFLECT],et,it,nt),runEffects(this,this[TYPES.OBSERVE],et,it,nt),ot&&runNotifyEffects(this,ot,et,it,nt),this.__dataCounter==1&&(this.__dataTemp={})}_propagatePropertyChanges(j,et,it){this[TYPES.PROPAGATE]&&runEffects(this,this[TYPES.PROPAGATE],j,et,it),this.__templateInfo&&this._runEffectsForTemplate(this.__templateInfo,j,et,it)}_runEffectsForTemplate(j,et,it,nt){const ot=(at,lt)=>{runEffects(this,j.propertyEffects,at,it,lt,j.nodeList);for(let ct=j.firstChild;ct;ct=ct.nextSibling)this._runEffectsForTemplate(ct,at,it,lt)};j.runEffects?j.runEffects(ot,et,nt):ot(et,nt)}linkPaths(j,et){j=normalize$1(j),et=normalize$1(et),this.__dataLinkedPaths=this.__dataLinkedPaths||{},this.__dataLinkedPaths[j]=et}unlinkPaths(j){j=normalize$1(j),this.__dataLinkedPaths&&delete this.__dataLinkedPaths[j]}notifySplices(j,et){let it={path:""},nt=get$6(this,j,it);notifySplices(this,nt,it.path,et)}get(j,et){return get$6(et||this,j)}set(j,et,it){it?set$1(it,j,et):(!this[TYPES.READ_ONLY]||!this[TYPES.READ_ONLY][j])&&this._setPendingPropertyOrPath(j,et,!0)&&this._invalidateProperties()}push(j,...et){let it={path:""},nt=get$6(this,j,it),ot=nt.length,at=nt.push(...et);return et.length&&notifySplice(this,nt,it.path,ot,et.length,[]),at}pop(j){let et={path:""},it=get$6(this,j,et),nt=!!it.length,ot=it.pop();return nt&&notifySplice(this,it,et.path,it.length,0,[ot]),ot}splice(j,et,it,...nt){let ot={path:""},at=get$6(this,j,ot);et<0?et=at.length-Math.floor(-et):et&&(et=Math.floor(et));let lt;return arguments.length===2?lt=at.splice(et):lt=at.splice(et,it,...nt),(nt.length||lt.length)&&notifySplice(this,at,ot.path,et,nt.length,lt),lt}shift(j){let et={path:""},it=get$6(this,j,et),nt=!!it.length,ot=it.shift();return nt&&notifySplice(this,it,et.path,0,0,[ot]),ot}unshift(j,...et){let it={path:""},nt=get$6(this,j,it),ot=nt.unshift(...et);return et.length&&notifySplice(this,nt,it.path,0,et.length,[]),ot}notifyPath(j,et){let it;if(arguments.length==1){let nt={path:""};et=get$6(this,j,nt),it=nt.path}else Array.isArray(j)?it=normalize$1(j):it=j;this._setPendingPropertyOrPath(it,et,!0,!0)&&this._invalidateProperties()}_createReadOnlyProperty(j,et){this._addPropertyEffect(j,TYPES.READ_ONLY),et&&(this["_set"+upper(j)]=function(it){this._setProperty(j,it)})}_createPropertyObserver(j,et,it){let nt={property:j,method:et,dynamicFn:!!it};this._addPropertyEffect(j,TYPES.OBSERVE,{fn:runObserverEffect,info:nt,trigger:{name:j}}),it&&this._addPropertyEffect(et,TYPES.OBSERVE,{fn:runObserverEffect,info:nt,trigger:{name:et}})}_createMethodObserver(j,et){let it=parseMethod(j);if(!it)throw new Error("Malformed observer expression '"+j+"'");createMethodEffect(this,it,TYPES.OBSERVE,runMethodEffect,null,et)}_createNotifyingProperty(j){this._addPropertyEffect(j,TYPES.NOTIFY,{fn:runNotifyEffect,info:{eventName:camelToDashCase(j)+"-changed",property:j}})}_createReflectedProperty(j){let et=this.constructor.attributeNameForProperty(j);et[0]==="-"?console.warn("Property "+j+" cannot be reflected to attribute "+et+' because "-" is not a valid starting attribute name. Use a lowercase first letter for the property instead.'):this._addPropertyEffect(j,TYPES.REFLECT,{fn:runReflectEffect,info:{attrName:et}})}_createComputedProperty(j,et,it){let nt=parseMethod(et);if(!nt)throw new Error("Malformed computed expression '"+et+"'");const ot=createMethodEffect(this,nt,TYPES.COMPUTE,runComputedEffect,j,it);ensureOwnEffectMap(this,COMPUTE_INFO)[j]=ot}_marshalArgs(j,et,it){const nt=this.__data,ot=[];for(let at=0,lt=j.length;at<lt;at++){let{name:ct,structured:ht,wildcard:ut,value:ft,literal:vt}=j[at];if(!vt)if(ut){const gt=isDescendant(ct,et),mt=getArgValue(nt,it,gt?et:ct);ft={path:gt?et:ct,value:mt,base:gt?get$6(nt,ct):mt}}else ft=ht?getArgValue(nt,it,ct):nt[ct];if(legacyUndefined&&!this._overrideLegacyUndefined&&ft===void 0&&j.length>1)return NOOP;ot[at]=ft}return ot}static addPropertyEffect(j,et,it){this.prototype._addPropertyEffect(j,et,it)}static createPropertyObserver(j,et,it){this.prototype._createPropertyObserver(j,et,it)}static createMethodObserver(j,et){this.prototype._createMethodObserver(j,et)}static createNotifyingProperty(j){this.prototype._createNotifyingProperty(j)}static createReadOnlyProperty(j,et){this.prototype._createReadOnlyProperty(j,et)}static createReflectedProperty(j){this.prototype._createReflectedProperty(j)}static createComputedProperty(j,et,it){this.prototype._createComputedProperty(j,et,it)}static bindTemplate(j){return this.prototype._bindTemplate(j)}_bindTemplate(j,et){let it=this.constructor._parseTemplate(j),nt=this.__preBoundTemplateInfo==it;if(!nt)for(let ot in it.propertyEffects)this._createPropertyAccessor(ot);if(et)if(it=Object.create(it),it.wasPreBound=nt,!this.__templateInfo)this.__templateInfo=it;else{const ot=j._parentTemplateInfo||this.__templateInfo,at=ot.lastChild;it.parent=ot,ot.lastChild=it,it.previousSibling=at,at?at.nextSibling=it:ot.firstChild=it}else this.__preBoundTemplateInfo=it;return it}static _addTemplatePropertyEffect(j,et,it){let nt=j.hostProps=j.hostProps||{};nt[et]=!0;let ot=j.propertyEffects=j.propertyEffects||{};(ot[et]=ot[et]||[]).push(it)}_stampTemplate(j,et){et=et||this._bindTemplate(j,!0),hostStack.push(this);let it=super._stampTemplate(j,et);if(hostStack.pop(),et.nodeList=it.nodeList,!et.wasPreBound){let nt=et.childNodes=[];for(let ot=it.firstChild;ot;ot=ot.nextSibling)nt.push(ot)}return it.templateInfo=et,setupBindings(this,et),this.__dataClientsReady&&(this._runEffectsForTemplate(et,this.__data,null,!1),this._flushClients()),it}_removeBoundDom(j){const et=j.templateInfo,{previousSibling:it,nextSibling:nt,parent:ot}=et;it?it.nextSibling=nt:ot&&(ot.firstChild=nt),nt?nt.previousSibling=it:ot&&(ot.lastChild=it),et.nextSibling=et.previousSibling=null;let at=et.childNodes;for(let lt=0;lt<at.length;lt++){let ct=at[lt];wrap$j(wrap$j(ct).parentNode).removeChild(ct)}}static _parseTemplateNode(j,et,it){let nt=y._parseTemplateNode.call(this,j,et,it);if(j.nodeType===Node.TEXT_NODE){let ot=this._parseBindings(j.textContent,et);ot&&(j.textContent=literalFromParts(ot)||" ",addBinding(this,et,it,"text","textContent",ot),nt=!0)}return nt}static _parseTemplateNodeAttribute(j,et,it,nt,ot){let at=this._parseBindings(ot,et);if(at){let lt=nt,ct="property";capitalAttributeRegex.test(nt)?ct="attribute":nt[nt.length-1]=="$"&&(nt=nt.slice(0,-1),ct="attribute");let ht=literalFromParts(at);return ht&&ct=="attribute"&&(nt=="class"&&j.hasAttribute("class")&&(ht+=" "+j.getAttribute(nt)),j.setAttribute(nt,ht)),ct=="attribute"&&lt=="disable-upgrade$"&&j.setAttribute(nt,""),j.localName==="input"&&lt==="value"&&j.setAttribute(lt,""),j.removeAttribute(lt),ct==="property"&&(nt=dashToCamelCase(nt)),addBinding(this,et,it,ct,nt,at,ht),!0}else return y._parseTemplateNodeAttribute.call(this,j,et,it,nt,ot)}static _parseTemplateNestedTemplate(j,et,it){let nt=y._parseTemplateNestedTemplate.call(this,j,et,it);const ot=j.parentNode,at=it.templateInfo,lt=ot.localName==="dom-if",ct=ot.localName==="dom-repeat";removeNestedTemplates&&(lt||ct)&&(ot.removeChild(j),it=it.parentInfo,it.templateInfo=at,it.noted=!0,nt=!1);let ht=at.hostProps;if(fastDomIf&&lt)ht&&(et.hostProps=Object.assign(et.hostProps||{},ht),removeNestedTemplates||(it.parentInfo.noted=!0));else{let ut="{";for(let ft in ht){let vt=[{mode:ut,source:ft,dependencies:[ft],hostProp:!0}];addBinding(this,et,it,"property","_host_"+ft,vt)}}return nt}static _parseBindings(j,et){let it=[],nt=0,ot;for(;(ot=bindingRegex.exec(j))!==null;){ot.index>nt&&it.push({literal:j.slice(nt,ot.index)});let at=ot[1][0],lt=!!ot[2],ct=ot[3].trim(),ht=!1,ut="",ft=-1;at=="{"&&(ft=ct.indexOf("::"))>0&&(ut=ct.substring(ft+2),ct=ct.substring(0,ft),ht=!0);let vt=parseMethod(ct),gt=[];if(vt){let{args:mt,methodName:bt}=vt;for(let wt=0;wt<mt.length;wt++){let Mt=mt[wt];Mt.literal||gt.push(Mt)}let xt=et.dynamicFns;(xt&&xt[bt]||vt.static)&&(gt.push(bt),vt.dynamicFn=!0)}else gt.push(ct);it.push({source:ct,mode:at,negate:lt,customEvent:ht,signature:vt,dependencies:gt,event:ut}),nt=bindingRegex.lastIndex}if(nt&&nt<j.length){let at=j.substring(nt);at&&it.push({literal:at})}return it.length?it:null}static _evaluateBinding(j,et,it,nt,ot,at){let lt;return et.signature?lt=runMethodEffect(j,it,nt,ot,et.signature):it!=et.source?lt=get$6(j,et.source):at&&isPath(it)?lt=get$6(j,it):lt=j.__data[it],et.negate&&(lt=!lt),lt}}return a}),hostStack=[];/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/function register$2(z){}/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/function normalizeProperties(z){const y={};for(let a in z){const k=z[a];y[a]=typeof k=="function"?{type:k}:k}return y}const PropertiesMixin=dedupingMixin(z=>{const y=PropertiesChanged(z);function a(et){const it=Object.getPrototypeOf(et);return it.prototype instanceof j?it:null}function k(et){if(!et.hasOwnProperty(JSCompiler_renameProperty("__ownProperties",et))){let it=null;if(et.hasOwnProperty(JSCompiler_renameProperty("properties",et))){const nt=et.properties;nt&&(it=normalizeProperties(nt))}et.__ownProperties=it}return et.__ownProperties}class j extends y{static get observedAttributes(){if(!this.hasOwnProperty(JSCompiler_renameProperty("__observedAttributes",this))){this.prototype;const it=this._properties;this.__observedAttributes=it?Object.keys(it).map(nt=>this.prototype._addPropertyToAttributeMap(nt)):[]}return this.__observedAttributes}static finalize(){if(!this.hasOwnProperty(JSCompiler_renameProperty("__finalized",this))){const it=a(this);it&&it.finalize(),this.__finalized=!0,this._finalizeClass()}}static _finalizeClass(){const it=k(this);it&&this.createProperties(it)}static get _properties(){if(!this.hasOwnProperty(JSCompiler_renameProperty("__properties",this))){const it=a(this);this.__properties=Object.assign({},it&&it._properties,k(this))}return this.__properties}static typeForProperty(it){const nt=this._properties[it];return nt&&nt.type}_initializeProperties(){this.constructor.finalize(),super._initializeProperties()}connectedCallback(){super.connectedCallback&&super.connectedCallback(),this._enableProperties()}disconnectedCallback(){super.disconnectedCallback&&super.disconnectedCallback()}}return j});/**
 * @fileoverview
 * @suppress {checkPrototypalTypes}
 * @license Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at
 * http://polymer.github.io/LICENSE.txt The complete set of authors may be found
 * at http://polymer.github.io/AUTHORS.txt The complete set of contributors may
 * be found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by
 * Google as part of the polymer project is also subject to an additional IP
 * rights grant found at http://polymer.github.io/PATENTS.txt
 */const version="3.5.2",builtCSS=window.ShadyCSS&&window.ShadyCSS.cssBuild,ElementMixin$1=dedupingMixin(z=>{const y=PropertiesMixin(PropertyEffects(z));function a(ot){if(!ot.hasOwnProperty(JSCompiler_renameProperty("__propertyDefaults",ot))){ot.__propertyDefaults=null;let at=ot._properties;for(let lt in at){let ct=at[lt];"value"in ct&&(ot.__propertyDefaults=ot.__propertyDefaults||{},ot.__propertyDefaults[lt]=ct)}}return ot.__propertyDefaults}function k(ot){return ot.hasOwnProperty(JSCompiler_renameProperty("__ownObservers",ot))||(ot.__ownObservers=ot.hasOwnProperty(JSCompiler_renameProperty("observers",ot))?ot.observers:null),ot.__ownObservers}function j(ot,at,lt,ct){lt.computed&&(lt.readOnly=!0),lt.computed&&(ot._hasReadOnlyEffect(at)?console.warn(`Cannot redefine computed property '${at}'.`):ot._createComputedProperty(at,lt.computed,ct)),lt.readOnly&&!ot._hasReadOnlyEffect(at)?ot._createReadOnlyProperty(at,!lt.computed):lt.readOnly===!1&&ot._hasReadOnlyEffect(at)&&console.warn(`Cannot make readOnly property '${at}' non-readOnly.`),lt.reflectToAttribute&&!ot._hasReflectEffect(at)?ot._createReflectedProperty(at):lt.reflectToAttribute===!1&&ot._hasReflectEffect(at)&&console.warn(`Cannot make reflected property '${at}' non-reflected.`),lt.notify&&!ot._hasNotifyEffect(at)?ot._createNotifyingProperty(at):lt.notify===!1&&ot._hasNotifyEffect(at)&&console.warn(`Cannot make notify property '${at}' non-notify.`),lt.observer&&ot._createPropertyObserver(at,lt.observer,ct[lt.observer]),ot._addPropertyToAttributeMap(at)}function et(ot,at,lt,ct){if(!builtCSS){const ht=at.content.querySelectorAll("style"),ut=stylesFromTemplate(at),ft=stylesFromModuleImports(lt),vt=at.content.firstElementChild;for(let mt=0;mt<ft.length;mt++){let bt=ft[mt];bt.textContent=ot._processStyleText(bt.textContent,ct),at.content.insertBefore(bt,vt)}let gt=0;for(let mt=0;mt<ut.length;mt++){let bt=ut[mt],xt=ht[gt];xt!==bt?(bt=bt.cloneNode(!0),xt.parentNode.insertBefore(bt,xt)):gt++,bt.textContent=ot._processStyleText(bt.textContent,ct)}}if(window.ShadyCSS&&window.ShadyCSS.prepareTemplate(at,lt),useAdoptedStyleSheetsWithBuiltCSS&&builtCSS&&supportsAdoptingStyleSheets){const ht=at.content.querySelectorAll("style");if(ht){let ut="";Array.from(ht).forEach(ft=>{ut+=ft.textContent,ft.parentNode.removeChild(ft)}),ot._styleSheet=new CSSStyleSheet,ot._styleSheet.replaceSync(ut)}}}function it(ot){let at=null;if(ot&&(!strictTemplatePolicy||allowTemplateFromDomModule)&&(at=DomModule.import(ot,"template"),strictTemplatePolicy&&!at))throw new Error(`strictTemplatePolicy: expecting dom-module or null template for ${ot}`);return at}class nt extends y{static get polymerElementVersion(){return version}static _finalizeClass(){y._finalizeClass.call(this);const at=k(this);at&&this.createObservers(at,this._properties),this._prepareTemplate()}static _prepareTemplate(){let at=this.template;at&&(typeof at=="string"?(console.error("template getter must return HTMLTemplateElement"),at=null):legacyOptimizations||(at=at.cloneNode(!0))),this.prototype._template=at}static createProperties(at){for(let lt in at)j(this.prototype,lt,at[lt],at)}static createObservers(at,lt){const ct=this.prototype;for(let ht=0;ht<at.length;ht++)ct._createMethodObserver(at[ht],lt)}static get template(){if(!this.hasOwnProperty(JSCompiler_renameProperty("_template",this))){let at=this.prototype.hasOwnProperty(JSCompiler_renameProperty("_template",this.prototype))?this.prototype._template:void 0;typeof at=="function"&&(at=at()),this._template=at!==void 0?at:this.hasOwnProperty(JSCompiler_renameProperty("is",this))&&it(this.is)||Object.getPrototypeOf(this.prototype).constructor.template}return this._template}static set template(at){this._template=at}static get importPath(){if(!this.hasOwnProperty(JSCompiler_renameProperty("_importPath",this))){const at=this.importMeta;if(at)this._importPath=pathFromUrl(at.url);else{const lt=DomModule.import(this.is);this._importPath=lt&&lt.assetpath||Object.getPrototypeOf(this.prototype).constructor.importPath}}return this._importPath}constructor(){super(),this._template,this._importPath,this.rootPath,this.importPath,this.root,this.$}_initializeProperties(){this.constructor.finalize(),this.constructor._finalizeTemplate(this.localName),super._initializeProperties(),this.rootPath=rootPath,this.importPath=this.constructor.importPath;let at=a(this.constructor);if(at)for(let lt in at){let ct=at[lt];if(this._canApplyPropertyDefault(lt)){let ht=typeof ct.value=="function"?ct.value.call(this):ct.value;this._hasAccessor(lt)?this._setPendingProperty(lt,ht,!0):this[lt]=ht}}}_canApplyPropertyDefault(at){return!this.hasOwnProperty(at)}static _processStyleText(at,lt){return resolveCss(at,lt)}static _finalizeTemplate(at){const lt=this.prototype._template;if(lt&&!lt.__polymerFinalized){lt.__polymerFinalized=!0;const ct=this.importPath,ht=ct?resolveUrl(ct):"";et(this,lt,at,ht),this.prototype._bindTemplate(lt)}}connectedCallback(){window.ShadyCSS&&this._template&&window.ShadyCSS.styleElement(this),super.connectedCallback()}ready(){this._template&&(this.root=this._stampTemplate(this._template),this.$=this.root.$),super.ready()}_readyClients(){this._template&&(this.root=this._attachDom(this.root)),super._readyClients()}_attachDom(at){const lt=wrap$j(this);if(lt.attachShadow)return at?(lt.shadowRoot||(lt.attachShadow({mode:"open",shadyUpgradeFragment:at}),lt.shadowRoot.appendChild(at),this.constructor._styleSheet&&(lt.shadowRoot.adoptedStyleSheets=[this.constructor._styleSheet])),syncInitialRender&&window.ShadyDOM&&window.ShadyDOM.flushInitial(lt.shadowRoot),lt.shadowRoot):null;throw new Error("ShadowDOM not available. PolymerElement can create dom as children instead of in ShadowDOM by setting `this.root = this;` before `ready`.")}updateStyles(at){window.ShadyCSS&&window.ShadyCSS.styleSubtree(this,at)}resolveUrl(at,lt){return!lt&&this.importPath&&(lt=resolveUrl(this.importPath)),resolveUrl(at,lt)}static _parseTemplateContent(at,lt,ct){return lt.dynamicFns=lt.dynamicFns||this._properties,y._parseTemplateContent.call(this,at,lt,ct)}static _addTemplatePropertyEffect(at,lt,ct){return legacyWarnings&&!(lt in this._properties)&&!(ct.info.part.signature&&ct.info.part.signature.static)&&!ct.info.part.hostProp&&!at.nestedTemplate&&console.warn(`Property '${lt}' used in template but not declared in 'properties'; attribute will not be observed.`),y._addTemplatePropertyEffect.call(this,at,lt,ct)}}return nt});/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const policy=window.trustedTypes&&trustedTypes.createPolicy("polymer-html-literal",{createHTML:z=>z});class LiteralString{constructor(y,a){assertValidTemplateStringParameters(y,a);const k=a.reduce((j,et,it)=>j+literalValue(et)+y[it+1],y[0]);this.value=k.toString()}toString(){return this.value}}function literalValue(z){if(z instanceof LiteralString)return z.value;throw new Error(`non-literal value passed to Polymer's htmlLiteral function: ${z}`)}function htmlValue(z){if(z instanceof HTMLTemplateElement)return z.innerHTML;if(z instanceof LiteralString)return literalValue(z);throw new Error(`non-template value passed to Polymer's html function: ${z}`)}const html$3=function(y,...a){assertValidTemplateStringParameters(y,a);const k=document.createElement("template");let j=a.reduce((et,it,nt)=>et+htmlValue(it)+y[nt+1],y[0]);return policy&&(j=policy.createHTML(j)),k.innerHTML=j,k},assertValidTemplateStringParameters=(z,y)=>{if(!Array.isArray(z)||!Array.isArray(z.raw)||y.length!==z.length-1)throw new TypeError("Invalid call to the html template tag")};/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const PolymerElement=ElementMixin$1(HTMLElement);/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const wrap$i=z=>z,HAS_NATIVE_TA=typeof document.head.style.touchAction=="string",GESTURE_KEY="__polymerGestures",HANDLED_OBJ="__polymerGesturesHandled",TOUCH_ACTION="__polymerGesturesTouchAction",TAP_DISTANCE=25,TRACK_DISTANCE=5,TRACK_LENGTH=2,MOUSE_EVENTS=["mousedown","mousemove","mouseup","click"],MOUSE_WHICH_TO_BUTTONS=[0,1,4,2],MOUSE_HAS_BUTTONS=(function(){try{return new MouseEvent("test",{buttons:1}).buttons===1}catch{return!1}})();function isMouseEvent(z){return MOUSE_EVENTS.indexOf(z)>-1}let supportsPassive=!1;(function(){try{const z=Object.defineProperty({},"passive",{get(){supportsPassive=!0}});window.addEventListener("test",null,z),window.removeEventListener("test",null,z)}catch{}})();function PASSIVE_TOUCH(z){isMouseEvent(z)}const IS_TOUCH_ONLY=navigator.userAgent.match(/iP(?:[oa]d|hone)|Android/u),canBeDisabled={button:!0,command:!0,fieldset:!0,input:!0,keygen:!0,optgroup:!0,option:!0,select:!0,textarea:!0};function hasLeftMouseButton(z){const y=z.type;if(!isMouseEvent(y))return!1;if(y==="mousemove"){let k=z.buttons===void 0?1:z.buttons;return z instanceof window.MouseEvent&&!MOUSE_HAS_BUTTONS&&(k=MOUSE_WHICH_TO_BUTTONS[z.which]||0),!!(k&1)}return(z.button===void 0?0:z.button)===0}function isSyntheticClick(z){if(z.type==="click"){if(z.detail===0)return!0;const y=_findOriginalTarget(z);if(!y.nodeType||y.nodeType!==Node.ELEMENT_NODE)return!0;const a=y.getBoundingClientRect(),k=z.pageX,j=z.pageY;return!(k>=a.left&&k<=a.right&&j>=a.top&&j<=a.bottom)}return!1}const POINTERSTATE={touch:{x:0,y:0,id:-1,scrollDecided:!1}};function firstTouchAction(z){let y="auto";const a=getComposedPath(z);for(let k=0,j;k<a.length;k++)if(j=a[k],j[TOUCH_ACTION]){y=j[TOUCH_ACTION];break}return y}function trackDocument(z,y,a){z.movefn=y,z.upfn=a,document.addEventListener("mousemove",y),document.addEventListener("mouseup",a)}function untrackDocument(z){document.removeEventListener("mousemove",z.movefn),document.removeEventListener("mouseup",z.upfn),z.movefn=null,z.upfn=null}const getComposedPath=window.ShadyDOM&&window.ShadyDOM.noPatch?window.ShadyDOM.composedPath:z=>z.composedPath&&z.composedPath()||[],gestures={},recognizers=[];function deepTargetFind(z,y){let a=document.elementFromPoint(z,y),k=a;for(;k&&k.shadowRoot&&!window.ShadyDOM;){const j=k;if(k=k.shadowRoot.elementFromPoint(z,y),j===k)break;k&&(a=k)}return a}function _findOriginalTarget(z){const y=getComposedPath(z);return y.length>0?y[0]:z.target}function _handleNative(z){const y=z.type,k=z.currentTarget[GESTURE_KEY];if(!k)return;const j=k[y];if(!j)return;if(!z[HANDLED_OBJ]&&(z[HANDLED_OBJ]={},y.startsWith("touch"))){const it=z.changedTouches[0];if(y==="touchstart"&&z.touches.length===1&&(POINTERSTATE.touch.id=it.identifier),POINTERSTATE.touch.id!==it.identifier)return;HAS_NATIVE_TA||(y==="touchstart"||y==="touchmove")&&_handleTouchAction(z)}const et=z[HANDLED_OBJ];if(!et.skip){for(let it=0,nt;it<recognizers.length;it++)nt=recognizers[it],j[nt.name]&&!et[nt.name]&&nt.flow&&nt.flow.start.indexOf(z.type)>-1&&nt.reset&&nt.reset();for(let it=0,nt;it<recognizers.length;it++)nt=recognizers[it],j[nt.name]&&!et[nt.name]&&(et[nt.name]=!0,nt[y](z))}}function _handleTouchAction(z){const y=z.changedTouches[0],a=z.type;if(a==="touchstart")POINTERSTATE.touch.x=y.clientX,POINTERSTATE.touch.y=y.clientY,POINTERSTATE.touch.scrollDecided=!1;else if(a==="touchmove"){if(POINTERSTATE.touch.scrollDecided)return;POINTERSTATE.touch.scrollDecided=!0;const k=firstTouchAction(z);let j=!1;const et=Math.abs(POINTERSTATE.touch.x-y.clientX),it=Math.abs(POINTERSTATE.touch.y-y.clientY);z.cancelable&&(k==="none"?j=!0:k==="pan-x"?j=it>et:k==="pan-y"&&(j=et>it)),j?z.preventDefault():prevent("track")}}function addListener(z,y,a){return gestures[y]?(_add(z,y,a),!0):!1}function removeListener(z,y,a){return gestures[y]?(_remove(z,y,a),!0):!1}function _add(z,y,a){const k=gestures[y],j=k.deps,et=k.name;let it=z[GESTURE_KEY];it||(z[GESTURE_KEY]=it={});for(let nt=0,ot,at;nt<j.length;nt++)ot=j[nt],!(IS_TOUCH_ONLY&&isMouseEvent(ot)&&ot!=="click")&&(at=it[ot],at||(it[ot]=at={_count:0}),at._count===0&&z.addEventListener(ot,_handleNative,PASSIVE_TOUCH(ot)),at[et]=(at[et]||0)+1,at._count=(at._count||0)+1);z.addEventListener(y,a),k.touchAction&&setTouchAction(z,k.touchAction)}function _remove(z,y,a){const k=gestures[y],j=k.deps,et=k.name,it=z[GESTURE_KEY];if(it)for(let nt=0,ot,at;nt<j.length;nt++)ot=j[nt],at=it[ot],at&&at[et]&&(at[et]=(at[et]||1)-1,at._count=(at._count||1)-1,at._count===0&&z.removeEventListener(ot,_handleNative,PASSIVE_TOUCH(ot)));z.removeEventListener(y,a)}function register$1(z){recognizers.push(z),z.emits.forEach(y=>{gestures[y]=z})}function _findRecognizerByEvent(z){for(let y=0,a;y<recognizers.length;y++){a=recognizers[y];for(let k=0,j;k<a.emits.length;k++)if(j=a.emits[k],j===z)return a}return null}function setTouchAction(z,y){HAS_NATIVE_TA&&z instanceof HTMLElement&&microTask$1.run(()=>{z.style.touchAction=y}),z[TOUCH_ACTION]=y}function _fire(z,y,a){const k=new Event(y,{bubbles:!0,cancelable:!0,composed:!0});if(k.detail=a,wrap$i(z).dispatchEvent(k),k.defaultPrevented){const j=a.preventer||a.sourceEvent;j&&j.preventDefault&&j.preventDefault()}}function prevent(z){const y=_findRecognizerByEvent(z);y.info&&(y.info.prevent=!0)}register$1({name:"downup",deps:["mousedown","touchstart","touchend"],flow:{start:["mousedown","touchstart"],end:["mouseup","touchend"]},emits:["down","up"],info:{movefn:null,upfn:null},reset(){untrackDocument(this.info)},mousedown(z){if(!hasLeftMouseButton(z))return;const y=_findOriginalTarget(z),a=this,k=et=>{hasLeftMouseButton(et)||(downupFire("up",y,et),untrackDocument(a.info))},j=et=>{hasLeftMouseButton(et)&&downupFire("up",y,et),untrackDocument(a.info)};trackDocument(this.info,k,j),downupFire("down",y,z)},touchstart(z){downupFire("down",_findOriginalTarget(z),z.changedTouches[0],z)},touchend(z){downupFire("up",_findOriginalTarget(z),z.changedTouches[0],z)}});function downupFire(z,y,a,k){y&&_fire(y,z,{x:a.clientX,y:a.clientY,sourceEvent:a,preventer:k,prevent(j){return prevent(j)}})}register$1({name:"track",touchAction:"none",deps:["mousedown","touchstart","touchmove","touchend"],flow:{start:["mousedown","touchstart"],end:["mouseup","touchend"]},emits:["track"],info:{x:0,y:0,state:"start",started:!1,moves:[],addMove(z){this.moves.length>TRACK_LENGTH&&this.moves.shift(),this.moves.push(z)},movefn:null,upfn:null,prevent:!1},reset(){this.info.state="start",this.info.started=!1,this.info.moves=[],this.info.x=0,this.info.y=0,this.info.prevent=!1,untrackDocument(this.info)},mousedown(z){if(!hasLeftMouseButton(z))return;const y=_findOriginalTarget(z),a=this,k=et=>{const it=et.clientX,nt=et.clientY;trackHasMovedEnough(a.info,it,nt)&&(a.info.state=a.info.started?et.type==="mouseup"?"end":"track":"start",a.info.state==="start"&&prevent("tap"),a.info.addMove({x:it,y:nt}),hasLeftMouseButton(et)||(a.info.state="end",untrackDocument(a.info)),y&&trackFire(a.info,y,et),a.info.started=!0)},j=et=>{a.info.started&&k(et),untrackDocument(a.info)};trackDocument(this.info,k,j),this.info.x=z.clientX,this.info.y=z.clientY},touchstart(z){const y=z.changedTouches[0];this.info.x=y.clientX,this.info.y=y.clientY},touchmove(z){const y=_findOriginalTarget(z),a=z.changedTouches[0],k=a.clientX,j=a.clientY;trackHasMovedEnough(this.info,k,j)&&(this.info.state==="start"&&prevent("tap"),this.info.addMove({x:k,y:j}),trackFire(this.info,y,a),this.info.state="track",this.info.started=!0)},touchend(z){const y=_findOriginalTarget(z),a=z.changedTouches[0];this.info.started&&(this.info.state="end",this.info.addMove({x:a.clientX,y:a.clientY}),trackFire(this.info,y,a))}});function trackHasMovedEnough(z,y,a){if(z.prevent)return!1;if(z.started)return!0;const k=Math.abs(z.x-y),j=Math.abs(z.y-a);return k>=TRACK_DISTANCE||j>=TRACK_DISTANCE}function trackFire(z,y,a){if(!y)return;const k=z.moves[z.moves.length-2],j=z.moves[z.moves.length-1],et=j.x-z.x,it=j.y-z.y;let nt,ot=0;k&&(nt=j.x-k.x,ot=j.y-k.y),_fire(y,"track",{state:z.state,x:a.clientX,y:a.clientY,dx:et,dy:it,ddx:nt,ddy:ot,sourceEvent:a,hover(){return deepTargetFind(a.clientX,a.clientY)}})}register$1({name:"tap",deps:["mousedown","click","touchstart","touchend"],flow:{start:["mousedown","touchstart"],end:["click","touchend"]},emits:["tap"],info:{x:NaN,y:NaN,prevent:!1},reset(){this.info.x=NaN,this.info.y=NaN,this.info.prevent=!1},mousedown(z){hasLeftMouseButton(z)&&(this.info.x=z.clientX,this.info.y=z.clientY)},click(z){hasLeftMouseButton(z)&&trackForward(this.info,z)},touchstart(z){const y=z.changedTouches[0];this.info.x=y.clientX,this.info.y=y.clientY},touchend(z){trackForward(this.info,z.changedTouches[0],z)}});function trackForward(z,y,a){const k=Math.abs(y.clientX-z.x),j=Math.abs(y.clientY-z.y),et=_findOriginalTarget(a||y);!et||canBeDisabled[et.localName]&&et.hasAttribute("disabled")||(isNaN(k)||isNaN(j)||k<=TAP_DISTANCE&&j<=TAP_DISTANCE||isSyntheticClick(y))&&(z.prevent||_fire(et,"tap",{x:y.clientX,y:y.clientY,sourceEvent:y,preventer:a}))}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DisabledMixin=dedupeMixin(z=>class extends z{static get properties(){return{disabled:{type:Boolean,value:!1,observer:"_disabledChanged",reflectToAttribute:!0,sync:!0}}}_disabledChanged(a){this._setAriaDisabled(a)}_setAriaDisabled(a){a?this.setAttribute("aria-disabled","true"):this.removeAttribute("aria-disabled")}click(){this.disabled||super.click()}});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const KeyboardMixin=dedupeMixin(z=>class extends z{ready(){super.ready(),this.addEventListener("keydown",a=>{this._onKeyDown(a)}),this.addEventListener("keyup",a=>{this._onKeyUp(a)})}_onKeyDown(a){switch(a.key){case"Enter":this._onEnter(a);break;case"Escape":this._onEscape(a);break}}_onKeyUp(a){}_onEnter(a){}_onEscape(a){}});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ActiveMixin=z=>class extends DisabledMixin(KeyboardMixin(z)){get _activeKeys(){return[" "]}ready(){super.ready(),addListener(this,"down",a=>{this._shouldSetActive(a)&&this._setActive(!0)}),addListener(this,"up",()=>{this._setActive(!1)})}disconnectedCallback(){super.disconnectedCallback(),this._setActive(!1)}_shouldSetActive(a){return!this.disabled}_onKeyDown(a){super._onKeyDown(a),this._shouldSetActive(a)&&this._activeKeys.includes(a.key)&&(this._setActive(!0),document.addEventListener("keyup",k=>{this._activeKeys.includes(k.key)&&this._setActive(!1)},{once:!0}))}_setActive(a){this.toggleAttribute("active",a)}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const accordionHeading=i`
  :host {
    display: block;
    outline: none;
    -webkit-user-select: none;
    user-select: none;
  }

  :host([hidden]) {
    display: none !important;
  }

  button {
    display: flex;
    align-items: center;
    justify-content: inherit;
    width: 100%;
    margin: 0;
    padding: 0;
    background-color: initial;
    color: inherit;
    border: initial;
    outline: none;
    font: inherit;
    text-align: inherit;
  }
`;/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-accordion-heading",accordionHeading,{moduleId:"vaadin-accordion-heading-styles"});class AccordionHeading extends ActiveMixin(DirMixin(ThemableMixin(PolymerElement))){static get is(){return"vaadin-accordion-heading"}static get template(){return html$3`
      <button id="button" part="content" disabled$="[[disabled]]" aria-expanded$="[[__updateAriaExpanded(opened)]]">
        <span part="toggle" aria-hidden="true"></span>
        <slot></slot>
      </button>
    `}static get properties(){return{opened:{type:Boolean,reflectToAttribute:!0,value:!1}}}_attachDom(y){const a=this.attachShadow({mode:"open",delegatesFocus:!0});return a.appendChild(y),a}ready(){super.ready(),this.hasAttribute("role")||this.setAttribute("role","heading")}__updateAriaExpanded(y){return y?"true":"false"}}defineCustomElement(AccordionHeading);const details=i`
  :host {
    margin: var(--lumo-space-xs) 0;
    outline: none;
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
  }

  :host([focus-ring]) ::slotted([slot='summary']) {
    box-shadow: 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }

  [part='content'] {
    padding: var(--lumo-space-xs) 0 var(--lumo-space-s);
    font-size: var(--lumo-font-size-m);
    line-height: var(--lumo-line-height-m);
  }

  :host([theme~='filled']) {
    background-color: var(--lumo-contrast-5pct);
    border-radius: var(--lumo-border-radius-m);
  }

  :host([theme~='filled']) [part='content'] {
    padding-left: var(--lumo-space-m);
    padding-right: var(--lumo-space-m);
  }

  :host([theme~='small']) [part$='content'] {
    font-size: var(--lumo-font-size-s);
  }
`;registerStyles$1("vaadin-details",details,{moduleId:"lumo-details"});const accordionPanel$1=i`
  :host {
    margin: 0;
    border-bottom: solid 1px var(--lumo-contrast-10pct);
  }

  :host(:last-child) {
    border-bottom: none;
  }

  :host([theme~='filled']) {
    border-bottom: none;
  }

  :host([theme~='filled']:not(:last-child)) {
    margin-bottom: 2px;
  }
`;registerStyles$1("vaadin-accordion-panel",[details,accordionPanel$1],{moduleId:"lumo-accordion-panel"});/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const accordionPanel=i`
  :host {
    display: block;
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='content'] {
    display: none;
    overflow: hidden;
  }

  :host([opened]) [part='content'] {
    display: block;
    overflow: visible;
  }
`;/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const FocusMixin=dedupeMixin(z=>class extends z{get _keyboardActive(){return isKeyboardActive()}ready(){this.addEventListener("focusin",a=>{this._shouldSetFocus(a)&&this._setFocused(!0)}),this.addEventListener("focusout",a=>{this._shouldRemoveFocus(a)&&this._setFocused(!1)}),super.ready()}disconnectedCallback(){super.disconnectedCallback(),this.hasAttribute("focused")&&this._setFocused(!1)}focus(a){super.focus(a),a&&a.focusVisible===!1||this.setAttribute("focus-ring","")}_setFocused(a){this.toggleAttribute("focused",a),this.toggleAttribute("focus-ring",a&&this._keyboardActive)}_shouldSetFocus(a){return!0}_shouldRemoveFocus(a){return!0}});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const TabindexMixin=z=>class extends DisabledMixin(z){static get properties(){return{tabindex:{type:Number,reflectToAttribute:!0,observer:"_tabindexChanged",sync:!0},_lastTabIndex:{type:Number}}}_disabledChanged(a,k){super._disabledChanged(a,k),!this.__shouldAllowFocusWhenDisabled()&&(a?(this.tabindex!==void 0&&(this._lastTabIndex=this.tabindex),this.setAttribute("tabindex","-1")):k&&(this._lastTabIndex!==void 0?this.setAttribute("tabindex",this._lastTabIndex):this.tabindex=void 0))}_tabindexChanged(a){this.__shouldAllowFocusWhenDisabled()||this.disabled&&a!==-1&&(this._lastTabIndex=a,this.setAttribute("tabindex","-1"))}focus(a){(!this.disabled||this.__shouldAllowFocusWhenDisabled())&&super.focus(a)}__shouldAllowFocusWhenDisabled(){return!1}};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DelegateFocusMixin=dedupeMixin(z=>class extends FocusMixin(TabindexMixin(z)){static get properties(){return{autofocus:{type:Boolean},focusElement:{type:Object,readOnly:!0,observer:"_focusElementChanged",sync:!0},_lastTabIndex:{value:0}}}constructor(){super(),this._boundOnBlur=this._onBlur.bind(this),this._boundOnFocus=this._onFocus.bind(this)}ready(){super.ready(),this.autofocus&&!this.disabled&&requestAnimationFrame(()=>{this.focus()})}focus(a){this.focusElement&&!this.disabled&&(this.focusElement.focus(),a&&a.focusVisible===!1||this.setAttribute("focus-ring",""))}blur(){this.focusElement&&this.focusElement.blur()}click(){this.focusElement&&!this.disabled&&this.focusElement.click()}_focusElementChanged(a,k){a?(a.disabled=this.disabled,this._addFocusListeners(a),this.__forwardTabIndex(this.tabindex)):k&&this._removeFocusListeners(k)}_addFocusListeners(a){a.addEventListener("blur",this._boundOnBlur),a.addEventListener("focus",this._boundOnFocus)}_removeFocusListeners(a){a.removeEventListener("blur",this._boundOnBlur),a.removeEventListener("focus",this._boundOnFocus)}_onFocus(a){a.stopPropagation(),this.dispatchEvent(new Event("focus"))}_onBlur(a){a.stopPropagation(),this.dispatchEvent(new Event("blur"))}_shouldSetFocus(a){return a.target===this.focusElement}_shouldRemoveFocus(a){return a.target===this.focusElement}_disabledChanged(a,k){super._disabledChanged(a,k),this.focusElement&&(this.focusElement.disabled=a),a&&this.blur()}_tabindexChanged(a){this.__forwardTabIndex(a)}__forwardTabIndex(a){a!==void 0&&this.focusElement&&(this.focusElement.tabIndex=a,a!==-1&&(this.tabindex=void 0)),this.disabled&&a&&(a!==-1&&(this._lastTabIndex=a),this.tabindex=void 0),a===void 0&&this.hasAttribute("tabindex")&&this.removeAttribute("tabindex")}});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DelegateStateMixin=dedupeMixin(z=>class extends z{static get properties(){return{stateTarget:{type:Object,observer:"_stateTargetChanged"}}}static get delegateAttrs(){return[]}static get delegateProps(){return[]}ready(){super.ready(),this._createDelegateAttrsObserver(),this._createDelegatePropsObserver()}_stateTargetChanged(a){a&&(this._ensureAttrsDelegated(),this._ensurePropsDelegated())}_createDelegateAttrsObserver(){this._createMethodObserver(`_delegateAttrsChanged(${this.constructor.delegateAttrs.join(", ")})`)}_createDelegatePropsObserver(){this._createMethodObserver(`_delegatePropsChanged(${this.constructor.delegateProps.join(", ")})`)}_ensureAttrsDelegated(){this.constructor.delegateAttrs.forEach(a=>{this._delegateAttribute(a,this[a])})}_ensurePropsDelegated(){this.constructor.delegateProps.forEach(a=>{this._delegateProperty(a,this[a])})}_delegateAttrsChanged(...a){this.constructor.delegateAttrs.forEach((k,j)=>{this._delegateAttribute(k,a[j])})}_delegatePropsChanged(...a){this.constructor.delegateProps.forEach((k,j)=>{this._delegateProperty(k,a[j])})}_delegateAttribute(a,k){this.stateTarget&&(a==="invalid"&&this._delegateAttribute("aria-invalid",k?"true":!1),typeof k=="boolean"?this.stateTarget.toggleAttribute(a,k):k?this.stateTarget.setAttribute(a,k):this.stateTarget.removeAttribute(a))}_delegateProperty(a,k){this.stateTarget&&(this.stateTarget[a]=k)}});/**
 * @license
 * Copyright (c) 2023 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SlotObserver{constructor(y,a){this.slot=y,this.callback=a,this._storedNodes=[],this._connected=!1,this._scheduled=!1,this._boundSchedule=()=>{this._schedule()},this.connect(),this._schedule()}connect(){this.slot.addEventListener("slotchange",this._boundSchedule),this._connected=!0}disconnect(){this.slot.removeEventListener("slotchange",this._boundSchedule),this._connected=!1}_schedule(){this._scheduled||(this._scheduled=!0,queueMicrotask(()=>{this.flush()}))}flush(){this._connected&&(this._scheduled=!1,this._processNodes())}_processNodes(){const y=this.slot.assignedNodes({flatten:!0});let a=[];const k=[],j=[];y.length&&(a=y.filter(et=>!this._storedNodes.includes(et))),this._storedNodes.length&&this._storedNodes.forEach((et,it)=>{const nt=y.indexOf(et);nt===-1?k.push(et):nt!==it&&j.push(et)}),(a.length||k.length||j.length)&&this.callback({addedNodes:a,currentNodes:y,movedNodes:j,removedNodes:k}),this._storedNodes=y}}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */let uniqueId=0;function generateUniqueId(){return uniqueId++}/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SlotController extends EventTarget{static generateId(y,a="default"){return`${a}-${y.localName}-${generateUniqueId()}`}constructor(y,a,k,j={}){super();const{initializer:et,multiple:it,observe:nt,useUniqueId:ot,uniqueIdPrefix:at}=j;this.host=y,this.slotName=a,this.tagName=k,this.observe=typeof nt=="boolean"?nt:!0,this.multiple=typeof it=="boolean"?it:!1,this.slotInitializer=et,it&&(this.nodes=[]),ot&&(this.defaultId=this.constructor.generateId(y,at||a))}hostConnected(){this.initialized||(this.multiple?this.initMultiple():this.initSingle(),this.observe&&this.observeSlot(),this.initialized=!0)}initSingle(){let y=this.getSlotChild();y?(this.node=y,this.initAddedNode(y)):(y=this.attachDefaultNode(),this.initNode(y))}initMultiple(){const y=this.getSlotChildren();if(y.length===0){const a=this.attachDefaultNode();a&&(this.nodes=[a],this.initNode(a))}else this.nodes=y,y.forEach(a=>{this.initAddedNode(a)})}attachDefaultNode(){const{host:y,slotName:a,tagName:k}=this;let j=this.defaultNode;return!j&&k&&(j=document.createElement(k),j instanceof Element&&(a!==""&&j.setAttribute("slot",a),this.defaultNode=j)),j&&(this.node=j,y.appendChild(j)),j}getSlotChildren(){const{slotName:y}=this;return Array.from(this.host.childNodes).filter(a=>a.nodeType===Node.ELEMENT_NODE&&a.slot===y||a.nodeType===Node.TEXT_NODE&&a.textContent.trim()&&y==="")}getSlotChild(){return this.getSlotChildren()[0]}initNode(y){const{slotInitializer:a}=this;a&&a(y,this.host)}initCustomNode(y){}teardownNode(y){}initAddedNode(y){y!==this.defaultNode&&(this.initCustomNode(y),this.initNode(y))}observeSlot(){const{slotName:y}=this,a=y===""?"slot:not([name])":`slot[name=${y}]`,k=this.host.shadowRoot.querySelector(a);this.__slotObserver=new SlotObserver(k,({addedNodes:j,removedNodes:et})=>{const it=this.multiple?this.nodes:[this.node],nt=j.filter(ot=>!isEmptyTextNode(ot)&&!it.includes(ot));et.length&&(this.nodes=it.filter(ot=>!et.includes(ot)),et.forEach(ot=>{this.teardownNode(ot)})),nt&&nt.length>0&&(this.multiple?(this.defaultNode&&this.defaultNode.remove(),this.nodes=[...it,...nt].filter(ot=>ot!==this.defaultNode),nt.forEach(ot=>{this.initAddedNode(ot)})):(this.node&&this.node.remove(),this.node=nt[0],this.initAddedNode(this.node)))})}}/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class TooltipController extends SlotController{constructor(y){super(y,"tooltip"),this.setTarget(y),this.__onContentChange=this.__onContentChange.bind(this)}initCustomNode(y){y.target=this.target,this.ariaTarget!==void 0&&(y.ariaTarget=this.ariaTarget),this.context!==void 0&&(y.context=this.context),this.manual!==void 0&&(y.manual=this.manual),this.opened!==void 0&&(y.opened=this.opened),this.position!==void 0&&(y._position=this.position),this.shouldShow!==void 0&&(y.shouldShow=this.shouldShow),this.manual||this.host.setAttribute("has-tooltip",""),this.__notifyChange(y),y.addEventListener("content-changed",this.__onContentChange)}teardownNode(y){this.manual||this.host.removeAttribute("has-tooltip"),y.removeEventListener("content-changed",this.__onContentChange),this.__notifyChange(null)}setAriaTarget(y){this.ariaTarget=y;const a=this.node;a&&(a.ariaTarget=y)}setContext(y){this.context=y;const a=this.node;a&&(a.context=y)}setManual(y){this.manual=y;const a=this.node;a&&(a.manual=y)}setOpened(y){this.opened=y;const a=this.node;a&&(a.opened=y)}setPosition(y){this.position=y;const a=this.node;a&&(a._position=y)}setShouldShow(y){this.shouldShow=y;const a=this.node;a&&(a.shouldShow=y)}setTarget(y){this.target=y;const a=this.node;a&&(a.target=y)}__onContentChange(y){this.__notifyChange(y.target)}__notifyChange(y){this.dispatchEvent(new CustomEvent("tooltip-changed",{detail:{node:y}}))}}/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SlotChildObserveController extends SlotController{constructor(y,a,k,j={}){super(y,a,k,{...j,useUniqueId:!0})}initCustomNode(y){this.__updateNodeId(y),this.__notifyChange(y)}teardownNode(y){const a=this.getSlotChild();a&&a!==this.defaultNode?this.__notifyChange(a):(this.restoreDefaultNode(),this.updateDefaultNode(this.node))}attachDefaultNode(){const y=super.attachDefaultNode();return y&&this.__updateNodeId(y),y}restoreDefaultNode(){}updateDefaultNode(y){this.__notifyChange(y)}observeNode(y){this.__nodeObserver&&this.__nodeObserver.disconnect(),this.__nodeObserver=new MutationObserver(a=>{a.forEach(k=>{const j=k.target,et=j===this.node;k.type==="attributes"?et&&this.__updateNodeId(j):(et||j.parentElement===this.node)&&this.__notifyChange(this.node)})}),this.__nodeObserver.observe(y,{attributes:!0,attributeFilter:["id"],childList:!0,subtree:!0,characterData:!0})}__hasContent(y){return y?y.nodeType===Node.ELEMENT_NODE&&(customElements.get(y.localName)||y.children.length>0)||y.textContent&&y.textContent.trim()!=="":!1}__notifyChange(y){this.dispatchEvent(new CustomEvent("slot-content-changed",{detail:{hasContent:this.__hasContent(y),node:y}}))}__updateNodeId(y){const a=!this.nodes||y===this.nodes[0];y.nodeType===Node.ELEMENT_NODE&&(!this.multiple||a)&&!y.id&&(y.id=this.defaultId)}}/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class ContentController extends SlotChildObserveController{static generateId(y){return super.generateId(y,"content")}constructor(y){super(y,"",null,{multiple:!0})}}/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const CollapsibleMixin=z=>class extends z{static get properties(){return{opened:{type:Boolean,value:!1,reflectToAttribute:!0,notify:!0},_contentElements:{type:Array}}}static get observers(){return["_openedOrContentChanged(opened, _contentElements)"]}constructor(){super(),this._contentController=new ContentController(this),this._contentController.addEventListener("slot-content-changed",a=>{const k=a.target.nodes||[];this._contentElements=k.filter(j=>j.parentNode===this)})}ready(){super.ready(),this.addController(this._contentController),this.addEventListener("click",({target:a})=>{if(this.disabled||a.localName==="a")return;const k=this.focusElement;k&&(a===k||k.contains(a))&&(this.opened=!this.opened)})}_openedOrContentChanged(a,k){k&&k.forEach(j=>{j.setAttribute("aria-hidden",a?"false":"true")})}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SummaryController extends SlotChildObserveController{constructor(y,a){super(y,"summary",a)}setSummary(y){this.summary=y,this.getSlotChild()||this.restoreDefaultNode(),this.node===this.defaultNode&&this.updateDefaultNode(this.node)}restoreDefaultNode(){const{summary:y}=this;y&&y.trim()!==""&&this.attachDefaultNode()}updateDefaultNode(y){y&&(y.textContent=this.summary),super.updateDefaultNode(y)}}/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const AccordionPanelMixin=z=>class extends CollapsibleMixin(DelegateFocusMixin(DelegateStateMixin(z))){static get properties(){return{summary:{type:String,observer:"_summaryChanged"}}}static get observers(){return["__updateAriaAttributes(focusElement, _contentElements)"]}static get delegateProps(){return["disabled","opened","_theme"]}constructor(){super(),this._summaryController=new SummaryController(this,"vaadin-accordion-heading"),this._summaryController.addEventListener("slot-content-changed",a=>{const{node:k}=a.target;this._setFocusElement(k),this.stateTarget=k,this._tooltipController.setTarget(k)}),this._tooltipController=new TooltipController(this),this._tooltipController.setPosition("bottom-start")}__forwardTabIndex(a){super.__forwardTabIndex(a),a!==void 0&&this.focusElement&&(this.focusElement.$.button.tabIndex=a,this.focusElement.tabIndex=-1)}ready(){super.ready(),this.addController(this._summaryController),this.addController(this._tooltipController)}_delegateProperty(a,k){if(this.stateTarget){if(a==="_theme"){this._delegateAttribute("theme",k);return}super._delegateProperty(a,k)}}_setAriaDisabled(){}_summaryChanged(a){this._summaryController.setSummary(a)}__updateAriaAttributes(a,k){if(a&&k){const j=k[0];j&&(j.setAttribute("role","region"),j.setAttribute("aria-labelledby",a.id)),j&&j.id?a.setAttribute("aria-controls",j.id):a.removeAttribute("aria-controls")}}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-accordion-panel",accordionPanel,{moduleId:"vaadin-accordion-panel-styles"});class AccordionPanel extends AccordionPanelMixin(ThemableMixin(ControllerMixin(PolymerElement))){static get is(){return"vaadin-accordion-panel"}static get template(){return html$3`
      <slot name="summary"></slot>

      <div part="content">
        <slot></slot>
      </div>

      <slot name="tooltip"></slot>
    `}}defineCustomElement(AccordionPanel);const DEV_MODE_CODE_REGEXP=/\/\*[\*!]\s+vaadin-dev-mode:start([\s\S]*)vaadin-dev-mode:end\s+\*\*\//i,FlowClients=window.Vaadin&&window.Vaadin.Flow&&window.Vaadin.Flow.clients;function isMinified(){function z(){return!0}return uncommentAndRun(z)}function isDevelopmentMode(){try{return isForcedDevelopmentMode()?!0:isLocalhost()?FlowClients?!isFlowProductionMode():!isMinified():!1}catch{return!1}}function isForcedDevelopmentMode(){return localStorage.getItem("vaadin.developmentmode.force")}function isLocalhost(){return["localhost","127.0.0.1"].indexOf(window.location.hostname)>=0}function isFlowProductionMode(){return!!(FlowClients&&Object.keys(FlowClients).map(y=>FlowClients[y]).filter(y=>y.productionMode).length>0)}function uncommentAndRun(z,y){if(typeof z!="function")return;const a=DEV_MODE_CODE_REGEXP.exec(z.toString());if(a)try{z=new Function(a[1])}catch(k){console.log("vaadin-development-mode-detector: uncommentAndRun() failed",k)}return z(y)}window.Vaadin=window.Vaadin||{};const runIfDevelopmentMode=function(z,y){if(window.Vaadin.developmentMode)return uncommentAndRun(z,y)};window.Vaadin.developmentMode===void 0&&(window.Vaadin.developmentMode=isDevelopmentMode());function maybeGatherAndSendStats(){/*! vaadin-dev-mode:start
  (function () {
'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
  return typeof obj;
} : function (obj) {
  return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
};

var classCallCheck = function (instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
};

var createClass = function () {
  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  return function (Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);
    if (staticProps) defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();

var getPolymerVersion = function getPolymerVersion() {
  return window.Polymer && window.Polymer.version;
};

var StatisticsGatherer = function () {
  function StatisticsGatherer(logger) {
    classCallCheck(this, StatisticsGatherer);

    this.now = new Date().getTime();
    this.logger = logger;
  }

  createClass(StatisticsGatherer, [{
    key: 'frameworkVersionDetectors',
    value: function frameworkVersionDetectors() {
      return {
        'Flow': function Flow() {
          if (window.Vaadin && window.Vaadin.Flow && window.Vaadin.Flow.clients) {
            var flowVersions = Object.keys(window.Vaadin.Flow.clients).map(function (key) {
              return window.Vaadin.Flow.clients[key];
            }).filter(function (client) {
              return client.getVersionInfo;
            }).map(function (client) {
              return client.getVersionInfo().flow;
            });
            if (flowVersions.length > 0) {
              return flowVersions[0];
            }
          }
        },
        'Vaadin Framework': function VaadinFramework() {
          if (window.vaadin && window.vaadin.clients) {
            var frameworkVersions = Object.values(window.vaadin.clients).filter(function (client) {
              return client.getVersionInfo;
            }).map(function (client) {
              return client.getVersionInfo().vaadinVersion;
            });
            if (frameworkVersions.length > 0) {
              return frameworkVersions[0];
            }
          }
        },
        'AngularJs': function AngularJs() {
          if (window.angular && window.angular.version && window.angular.version) {
            return window.angular.version.full;
          }
        },
        'Angular': function Angular() {
          if (window.ng) {
            var tags = document.querySelectorAll("[ng-version]");
            if (tags.length > 0) {
              return tags[0].getAttribute("ng-version");
            }
            return "Unknown";
          }
        },
        'Backbone.js': function BackboneJs() {
          if (window.Backbone) {
            return window.Backbone.VERSION;
          }
        },
        'React': function React() {
          var reactSelector = '[data-reactroot], [data-reactid]';
          if (!!document.querySelector(reactSelector)) {
            // React does not publish the version by default
            return "unknown";
          }
        },
        'Ember': function Ember() {
          if (window.Em && window.Em.VERSION) {
            return window.Em.VERSION;
          } else if (window.Ember && window.Ember.VERSION) {
            return window.Ember.VERSION;
          }
        },
        'jQuery': function (_jQuery) {
          function jQuery() {
            return _jQuery.apply(this, arguments);
          }

          jQuery.toString = function () {
            return _jQuery.toString();
          };

          return jQuery;
        }(function () {
          if (typeof jQuery === 'function' && jQuery.prototype.jquery !== undefined) {
            return jQuery.prototype.jquery;
          }
        }),
        'Polymer': function Polymer() {
          var version = getPolymerVersion();
          if (version) {
            return version;
          }
        },
        'LitElement': function LitElement() {
          var version = window.litElementVersions && window.litElementVersions[0];
          if (version) {
            return version;
          }
        },
        'LitHtml': function LitHtml() {
          var version = window.litHtmlVersions && window.litHtmlVersions[0];
          if (version) {
            return version;
          }
        },
        'Vue.js': function VueJs() {
          if (window.Vue) {
            return window.Vue.version;
          }
        }
      };
    }
  }, {
    key: 'getUsedVaadinElements',
    value: function getUsedVaadinElements(elements) {
      var version = getPolymerVersion();
      var elementClasses = void 0;
      // NOTE: In case you edit the code here, YOU MUST UPDATE any statistics reporting code in Flow.
      // Check all locations calling the method getEntries() in
      // https://github.com/vaadin/flow/blob/master/flow-server/src/main/java/com/vaadin/flow/internal/UsageStatistics.java#L106
      // Currently it is only used by BootstrapHandler.
      if (version && version.indexOf('2') === 0) {
        // Polymer 2: components classes are stored in window.Vaadin
        elementClasses = Object.keys(window.Vaadin).map(function (c) {
          return window.Vaadin[c];
        }).filter(function (c) {
          return c.is;
        });
      } else {
        // Polymer 3: components classes are stored in window.Vaadin.registrations
        elementClasses = window.Vaadin.registrations || [];
      }
      elementClasses.forEach(function (klass) {
        var version = klass.version ? klass.version : "0.0.0";
        elements[klass.is] = { version: version };
      });
    }
  }, {
    key: 'getUsedVaadinThemes',
    value: function getUsedVaadinThemes(themes) {
      ['Lumo', 'Material'].forEach(function (themeName) {
        var theme;
        var version = getPolymerVersion();
        if (version && version.indexOf('2') === 0) {
          // Polymer 2: themes are stored in window.Vaadin
          theme = window.Vaadin[themeName];
        } else {
          // Polymer 3: themes are stored in custom element registry
          theme = customElements.get('vaadin-' + themeName.toLowerCase() + '-styles');
        }
        if (theme && theme.version) {
          themes[themeName] = { version: theme.version };
        }
      });
    }
  }, {
    key: 'getFrameworks',
    value: function getFrameworks(frameworks) {
      var detectors = this.frameworkVersionDetectors();
      Object.keys(detectors).forEach(function (framework) {
        var detector = detectors[framework];
        try {
          var version = detector();
          if (version) {
            frameworks[framework] = { version: version };
          }
        } catch (e) {}
      });
    }
  }, {
    key: 'gather',
    value: function gather(storage) {
      var storedStats = storage.read();
      var gatheredStats = {};
      var types = ["elements", "frameworks", "themes"];

      types.forEach(function (type) {
        gatheredStats[type] = {};
        if (!storedStats[type]) {
          storedStats[type] = {};
        }
      });

      var previousStats = JSON.stringify(storedStats);

      this.getUsedVaadinElements(gatheredStats.elements);
      this.getFrameworks(gatheredStats.frameworks);
      this.getUsedVaadinThemes(gatheredStats.themes);

      var now = this.now;
      types.forEach(function (type) {
        var keys = Object.keys(gatheredStats[type]);
        keys.forEach(function (key) {
          if (!storedStats[type][key] || _typeof(storedStats[type][key]) != _typeof({})) {
            storedStats[type][key] = { firstUsed: now };
          }
          // Discards any previously logged version number
          storedStats[type][key].version = gatheredStats[type][key].version;
          storedStats[type][key].lastUsed = now;
        });
      });

      var newStats = JSON.stringify(storedStats);
      storage.write(newStats);
      if (newStats != previousStats && Object.keys(storedStats).length > 0) {
        this.logger.debug("New stats: " + newStats);
      }
    }
  }]);
  return StatisticsGatherer;
}();

var StatisticsStorage = function () {
  function StatisticsStorage(key) {
    classCallCheck(this, StatisticsStorage);

    this.key = key;
  }

  createClass(StatisticsStorage, [{
    key: 'read',
    value: function read() {
      var localStorageStatsString = localStorage.getItem(this.key);
      try {
        return JSON.parse(localStorageStatsString ? localStorageStatsString : '{}');
      } catch (e) {
        return {};
      }
    }
  }, {
    key: 'write',
    value: function write(data) {
      localStorage.setItem(this.key, data);
    }
  }, {
    key: 'clear',
    value: function clear() {
      localStorage.removeItem(this.key);
    }
  }, {
    key: 'isEmpty',
    value: function isEmpty() {
      var storedStats = this.read();
      var empty = true;
      Object.keys(storedStats).forEach(function (key) {
        if (Object.keys(storedStats[key]).length > 0) {
          empty = false;
        }
      });

      return empty;
    }
  }]);
  return StatisticsStorage;
}();

var StatisticsSender = function () {
  function StatisticsSender(url, logger) {
    classCallCheck(this, StatisticsSender);

    this.url = url;
    this.logger = logger;
  }

  createClass(StatisticsSender, [{
    key: 'send',
    value: function send(data, errorHandler) {
      var logger = this.logger;

      if (navigator.onLine === false) {
        logger.debug("Offline, can't send");
        errorHandler();
        return;
      }
      logger.debug("Sending data to " + this.url);

      var req = new XMLHttpRequest();
      req.withCredentials = true;
      req.addEventListener("load", function () {
        // Stats sent, nothing more to do
        logger.debug("Response: " + req.responseText);
      });
      req.addEventListener("error", function () {
        logger.debug("Send failed");
        errorHandler();
      });
      req.addEventListener("abort", function () {
        logger.debug("Send aborted");
        errorHandler();
      });
      req.open("POST", this.url);
      req.setRequestHeader("Content-Type", "application/json");
      req.send(data);
    }
  }]);
  return StatisticsSender;
}();

var StatisticsLogger = function () {
  function StatisticsLogger(id) {
    classCallCheck(this, StatisticsLogger);

    this.id = id;
  }

  createClass(StatisticsLogger, [{
    key: '_isDebug',
    value: function _isDebug() {
      return localStorage.getItem("vaadin." + this.id + ".debug");
    }
  }, {
    key: 'debug',
    value: function debug(msg) {
      if (this._isDebug()) {
        console.info(this.id + ": " + msg);
      }
    }
  }]);
  return StatisticsLogger;
}();

var UsageStatistics = function () {
  function UsageStatistics() {
    classCallCheck(this, UsageStatistics);

    this.now = new Date();
    this.timeNow = this.now.getTime();
    this.gatherDelay = 10; // Delay between loading this file and gathering stats
    this.initialDelay = 24 * 60 * 60;

    this.logger = new StatisticsLogger("statistics");
    this.storage = new StatisticsStorage("vaadin.statistics.basket");
    this.gatherer = new StatisticsGatherer(this.logger);
    this.sender = new StatisticsSender("https://tools.vaadin.com/usage-stats/submit", this.logger);
  }

  createClass(UsageStatistics, [{
    key: 'maybeGatherAndSend',
    value: function maybeGatherAndSend() {
      var _this = this;

      if (localStorage.getItem(UsageStatistics.optOutKey)) {
        return;
      }
      this.gatherer.gather(this.storage);
      setTimeout(function () {
        _this.maybeSend();
      }, this.gatherDelay * 1000);
    }
  }, {
    key: 'lottery',
    value: function lottery() {
      return true;
    }
  }, {
    key: 'currentMonth',
    value: function currentMonth() {
      return this.now.getYear() * 12 + this.now.getMonth();
    }
  }, {
    key: 'maybeSend',
    value: function maybeSend() {
      var firstUse = Number(localStorage.getItem(UsageStatistics.firstUseKey));
      var monthProcessed = Number(localStorage.getItem(UsageStatistics.monthProcessedKey));

      if (!firstUse) {
        // Use a grace period to avoid interfering with tests, incognito mode etc
        firstUse = this.timeNow;
        localStorage.setItem(UsageStatistics.firstUseKey, firstUse);
      }

      if (this.timeNow < firstUse + this.initialDelay * 1000) {
        this.logger.debug("No statistics will be sent until the initial delay of " + this.initialDelay + "s has passed");
        return;
      }
      if (this.currentMonth() <= monthProcessed) {
        this.logger.debug("This month has already been processed");
        return;
      }
      localStorage.setItem(UsageStatistics.monthProcessedKey, this.currentMonth());
      // Use random sampling
      if (this.lottery()) {
        this.logger.debug("Congratulations, we have a winner!");
      } else {
        this.logger.debug("Sorry, no stats from you this time");
        return;
      }

      this.send();
    }
  }, {
    key: 'send',
    value: function send() {
      // Ensure we have the latest data
      this.gatherer.gather(this.storage);

      // Read, send and clean up
      var data = this.storage.read();
      data["firstUse"] = Number(localStorage.getItem(UsageStatistics.firstUseKey));
      data["usageStatisticsVersion"] = UsageStatistics.version;
      var info = 'This request contains usage statistics gathered from the application running in development mode. \n\nStatistics gathering is automatically disabled and excluded from production builds.\n\nFor details and to opt-out, see https://github.com/vaadin/vaadin-usage-statistics.\n\n\n\n';
      var self = this;
      this.sender.send(info + JSON.stringify(data), function () {
        // Revert the 'month processed' flag
        localStorage.setItem(UsageStatistics.monthProcessedKey, self.currentMonth() - 1);
      });
    }
  }], [{
    key: 'version',
    get: function get$1() {
      return '2.1.2';
    }
  }, {
    key: 'firstUseKey',
    get: function get$1() {
      return 'vaadin.statistics.firstuse';
    }
  }, {
    key: 'monthProcessedKey',
    get: function get$1() {
      return 'vaadin.statistics.monthProcessed';
    }
  }, {
    key: 'optOutKey',
    get: function get$1() {
      return 'vaadin.statistics.optout';
    }
  }]);
  return UsageStatistics;
}();

try {
  window.Vaadin = window.Vaadin || {};
  window.Vaadin.usageStatsChecker = window.Vaadin.usageStatsChecker || new UsageStatistics();
  window.Vaadin.usageStatsChecker.maybeGatherAndSend();
} catch (e) {
  // Intentionally ignored as this is not a problem in the app being developed
}

}());

  vaadin-dev-mode:end **/}const usageStatistics=function(){if(typeof runIfDevelopmentMode=="function")return runIfDevelopmentMode(maybeGatherAndSendStats)};/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */window.Vaadin||(window.Vaadin={});window.Vaadin.registrations||(window.Vaadin.registrations=[]);window.Vaadin.developmentModeCallback||(window.Vaadin.developmentModeCallback={});window.Vaadin.developmentModeCallback["vaadin-usage-statistics"]=function(){usageStatistics()};let statsJob;const registered=new Set,ElementMixin=z=>class extends DirMixin(z){static finalize(){super.finalize();const{is:a}=this;a&&!registered.has(a)&&(window.Vaadin.registrations.push(this),registered.add(a),window.Vaadin.developmentModeCallback&&(statsJob=Debouncer$1.debounce(statsJob,idlePeriod$1,()=>{window.Vaadin.developmentModeCallback["vaadin-usage-statistics"]()}),enqueueDebouncer$1(statsJob)))}constructor(){super(),document.doctype===null&&console.warn('Vaadin components require the "standards mode" declaration. Please add <!DOCTYPE html> to the HTML document.')}};/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const KeyboardDirectionMixin=z=>class extends KeyboardMixin(z){get focused(){return(this._getItems()||[]).find(isElementFocused)}get _vertical(){return!0}get _tabNavigation(){return!1}focus(a){const k=this._getItems();if(Array.isArray(k)){const j=this._getAvailableIndex(k,0,null,et=>!isElementHidden(et));j>=0&&this._focus(j,a)}}_getItems(){return Array.from(this.children)}_onKeyDown(a){if(super._onKeyDown(a),a.metaKey||a.ctrlKey)return;const{key:k,shiftKey:j}=a,et=this._getItems()||[],it=et.indexOf(this.focused);let nt,ot;const lt=!this._vertical&&this.getAttribute("dir")==="rtl"?-1:1;this.__isPrevKeyPressed(k,j)?(ot=-lt,nt=it-lt):this.__isNextKeyPressed(k,j)?(ot=lt,nt=it+lt):k==="Home"?(ot=1,nt=0):k==="End"&&(ot=-1,nt=et.length-1),nt=this._getAvailableIndex(et,nt,ot,ct=>!isElementHidden(ct)),!(this._tabNavigation&&k==="Tab"&&(nt>it&&a.shiftKey||nt<it&&!a.shiftKey||nt===it))&&nt>=0&&(a.preventDefault(),this._focus(nt,{focusVisible:!0},!0))}__isPrevKeyPressed(a,k){return this._vertical?a==="ArrowUp":a==="ArrowLeft"||this._tabNavigation&&a==="Tab"&&k}__isNextKeyPressed(a,k){return this._vertical?a==="ArrowDown":a==="ArrowRight"||this._tabNavigation&&a==="Tab"&&!k}_focus(a,k,j=!1){const et=this._getItems();this._focusItem(et[a],k,j)}_focusItem(a,k){a&&a.focus(k)}_getAvailableIndex(a,k,j,et){const it=a.length;let nt=k;for(let ot=0;typeof nt=="number"&&ot<it;ot+=1,nt+=j||1){nt<0?nt=it-1:nt>=it&&(nt=0);const at=a[nt];if(this._isItemFocusable(at)&&this.__isMatchingItem(at,et))return nt}return-1}__isMatchingItem(a,k){return typeof k=="function"?k(a):!0}_isItemFocusable(a){return!a.hasAttribute("disabled")}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const AccordionMixin=z=>class extends KeyboardDirectionMixin(z){static get properties(){return{opened:{type:Number,value:0,notify:!0,reflectToAttribute:!0},items:{type:Array,readOnly:!0,notify:!0}}}static get observers(){return["_updateItems(items, opened)"]}constructor(){super(),this._boundUpdateOpened=this._updateOpened.bind(this)}get focused(){return(this._getItems()||[]).find(a=>isElementFocused(a.focusElement))}focus(a){this._observer&&this._observer.flush(),super.focus(a)}ready(){super.ready();const a=this.shadowRoot.querySelector("slot");this._observer=new SlotObserver(a,k=>{this._setItems(this._filterItems(Array.from(this.children))),this._filterItems(k.addedNodes).forEach(j=>{j.addEventListener("opened-changed",this._boundUpdateOpened)})})}_getItems(){return this.items}_filterItems(a){return a.filter(k=>k instanceof customElements.get("vaadin-accordion-panel"))}_updateItems(a,k){if(a){this.__itemsSync=!0;const j=a[k];a.forEach(et=>{et.opened=et===j}),this.__itemsSync=!1}}_onKeyDown(a){this.items.some(k=>k.focusElement===a.target)&&super._onKeyDown(a)}_updateOpened(a){if(this.__itemsSync)return;const k=this._filterItems(a.composedPath())[0],j=this.items.indexOf(k);if(a.detail.value){if(k.disabled||j===-1)return;this.opened=j}else this.items.some(et=>et.opened)||(this.opened=null)}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class Accordion extends AccordionMixin(ThemableMixin(ElementMixin(PolymerElement))){static get template(){return html$3`
      <style>
        :host {
          display: block;
        }

        :host([hidden]) {
          display: none !important;
        }
      </style>
      <slot></slot>
    `}static get is(){return"vaadin-accordion"}}defineCustomElement(Accordion);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const INTERACTION_EVENTS=["mousedown","mouseup","click","dblclick","keypress","keydown","keyup"],ButtonMixin=z=>class extends ActiveMixin(TabindexMixin(FocusMixin(z))){constructor(){super(),this.__onInteractionEvent=this.__onInteractionEvent.bind(this),INTERACTION_EVENTS.forEach(a=>{this.addEventListener(a,this.__onInteractionEvent,!0)}),this.tabindex=0}get _activeKeys(){return["Enter"," "]}ready(){super.ready(),this.hasAttribute("role")||this.setAttribute("role","button"),this.__shouldAllowFocusWhenDisabled()&&this.style.setProperty("--_vaadin-button-disabled-pointer-events","auto")}_onKeyDown(a){super._onKeyDown(a),!(a.altKey||a.shiftKey||a.ctrlKey||a.metaKey)&&this._activeKeys.includes(a.key)&&(a.preventDefault(),this.click())}__onInteractionEvent(a){this.__shouldSuppressInteractionEvent(a)&&a.stopImmediatePropagation()}__shouldSuppressInteractionEvent(a){return this.disabled}};/**
 * @license
 * Copyright (c) 2025 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const detailsSummary=()=>i`
  :host {
    display: block;
    outline: none;
    white-space: nowrap;
    -webkit-user-select: none;
    user-select: none;
  }

  :host([hidden]) {
    display: none !important;
  }

  :host([disabled]) {
    pointer-events: none;
  }
`;/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-details-summary",detailsSummary(),{moduleId:"vaadin-details-summary-styles"});class DetailsSummary extends ButtonMixin(DirMixin(ThemableMixin(PolymerElement))){static get is(){return"vaadin-details-summary"}static get template(){return html$3`
      <span part="toggle" aria-hidden="true"></span>
      <div part="content"><slot></slot></div>
    `}static get properties(){return{opened:{type:Boolean,reflectToAttribute:!0}}}}defineCustomElement(DetailsSummary);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DetailsBaseMixin=z=>class extends CollapsibleMixin(DelegateFocusMixin(DelegateStateMixin(z))){static get properties(){return{summary:{type:String,observer:"_summaryChanged"}}}static get observers(){return["__updateAriaControls(focusElement, _contentElements)","__updateAriaExpanded(focusElement, opened)"]}static get delegateProps(){return["disabled","opened","_theme"]}constructor(){super(),this._summaryController=new SummaryController(this,"vaadin-details-summary"),this._summaryController.addEventListener("slot-content-changed",a=>{const{node:k}=a.target;this._setFocusElement(k),this.stateTarget=k,this._tooltipController.setTarget(k)}),this._tooltipController=new TooltipController(this),this._tooltipController.setPosition("bottom-start")}ready(){super.ready(),this.addController(this._summaryController),this.addController(this._tooltipController)}_delegateProperty(a,k){if(this.stateTarget){if(a==="_theme"){this._delegateAttribute("theme",k);return}super._delegateProperty(a,k)}}_setAriaDisabled(){}_summaryChanged(a){this._summaryController.setSummary(a)}__updateAriaControls(a,k){if(a&&k){const j=k[0];j&&j.id?a.setAttribute("aria-controls",j.id):a.removeAttribute("aria-controls")}}__updateAriaExpanded(a,k){a&&a.setAttribute("aria-expanded",k?"true":"false")}};/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class Details extends DetailsBaseMixin(ElementMixin(ThemableMixin(ControllerMixin(PolymerElement)))){static get template(){return html$3`
      <style>
        :host {
          display: block;
        }

        :host([hidden]) {
          display: none !important;
        }

        [part='content'] {
          display: none;
        }

        :host([opened]) [part='content'] {
          display: block;
        }
      </style>

      <slot name="summary"></slot>

      <div part="content">
        <slot></slot>
      </div>

      <slot name="tooltip"></slot>
    `}static get is(){return"vaadin-details"}}defineCustomElement(Details);registerStyles$1("vaadin-app-layout",i`
    [part='navbar'],
    [part='drawer'] {
      background-color: var(--lumo-base-color);
      background-clip: padding-box;
    }

    [part='navbar'] {
      min-height: var(--lumo-size-xl);
      border-bottom: 1px solid var(--lumo-contrast-10pct);
    }

    [part='navbar'][bottom] {
      border-bottom: none;
      border-top: 1px solid var(--lumo-contrast-10pct);
    }

    [part='drawer'] {
      border-inline-end: 1px solid var(--lumo-contrast-10pct);
    }

    :host([overlay]) [part='drawer'] {
      border-inline-end: none;
      box-shadow: var(--lumo-box-shadow-s);
    }

    :host([primary-section='navbar']) [part='navbar'] {
      border: none;
      background-image: linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct));
    }

    :host([primary-section='drawer']:not([overlay])) [part='drawer'] {
      background-image: linear-gradient(var(--lumo-shade-5pct), var(--lumo-shade-5pct));
    }

    [part='backdrop'] {
      background-color: var(--lumo-shade-20pct);
      opacity: 1;
    }

    [part] ::slotted(h2),
    [part] ::slotted(h3),
    [part] ::slotted(h4) {
      margin-top: var(--lumo-space-xs) !important;
      margin-bottom: var(--lumo-space-xs) !important;
    }
  `,{moduleId:"lumo-app-layout"});/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function _detectIosNavbar(){if(isIOS){const z=window.innerHeight,a=window.innerWidth>z,k=document.documentElement.clientHeight;a&&k>z?document.documentElement.style.setProperty("--vaadin-viewport-offset-bottom",`${k-z}px`):document.documentElement.style.setProperty("--vaadin-viewport-offset-bottom","")}}_detectIosNavbar();window.addEventListener("resize",_detectIosNavbar);const template$8=document.createElement("template");template$8.innerHTML=`
  <style>
    /* Use units so that the values can be used in calc() */
    html {
      --safe-area-inset-top: env(safe-area-inset-top, 0px);
      --safe-area-inset-right: env(safe-area-inset-right, 0px);
      --safe-area-inset-bottom: env(safe-area-inset-bottom, 0px);
      --safe-area-inset-left: env(safe-area-inset-left, 0px);
    }
  </style>
`;document.head.appendChild(template$8.content);/**
 * @license
 * Copyright (c) 2025 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function deepMerge$1(z,...y){const a=et=>Array.isArray(et),k=et=>et&&typeof et=="object"&&!a(et),j=(et,it)=>{k(it)&&k(et)&&Object.keys(it).forEach(nt=>{const ot=it[nt];k(ot)?(et[nt]||(et[nt]={}),j(et[nt],ot)):a(ot)?et[nt]=[...ot]:ot!=null&&(et[nt]=ot)})};return y.forEach(et=>{j(z,et)}),z}const I18nMixin=(z,y)=>class extends y{static get properties(){return{i18n:{type:Object},__effectiveI18n:{type:Object,sync:!0}}}constructor(){super(),this.i18n=deepMerge$1({},z)}get i18n(){return this.__customI18n}set i18n(k){k!==this.__customI18n&&(this.__customI18n=k,this.__effectiveI18n=deepMerge$1({},z,this.__customI18n))}};/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DEFAULT_I18N$a={drawer:"Drawer"},AppLayoutMixin=z=>class extends I18nMixin(DEFAULT_I18N$a,z){static get properties(){return{primarySection:{type:String,value:"navbar",notify:!0,reflectToAttribute:!0,observer:"__primarySectionChanged",sync:!0},drawerOpened:{type:Boolean,notify:!0,value:!0,reflectToAttribute:!0,observer:"__drawerOpenedChanged",sync:!0},overlay:{type:Boolean,notify:!0,readOnly:!0,value:!1,reflectToAttribute:!0,observer:"__overlayChanged",sync:!0},closeDrawerOn:{type:String,value:"vaadin-router-location-changed",observer:"_closeDrawerOnChanged"}}}static get observers(){return["__i18nChanged(__effectiveI18n)"]}static dispatchCloseOverlayDrawerEvent(){window.dispatchEvent(new CustomEvent("close-overlay-drawer"))}get i18n(){return super.i18n}set i18n(a){super.i18n=a}constructor(){super(),this.__boundResizeListener=this._resize.bind(this),this.__drawerToggleClickListener=this._drawerToggleClick.bind(this),this.__onDrawerKeyDown=this.__onDrawerKeyDown.bind(this),this.__closeOverlayDrawerListener=this.__closeOverlayDrawer.bind(this),this.__trapFocusInDrawer=this.__trapFocusInDrawer.bind(this),this.__releaseFocusFromDrawer=this.__releaseFocusFromDrawer.bind(this),this.__ariaModalController=new AriaModalController(this,()=>[...this.querySelectorAll('vaadin-drawer-toggle, [slot="drawer"]')]),this.__focusTrapController=new FocusTrapController(this)}connectedCallback(){super.connectedCallback(),this._blockAnimationUntilAfterNextRender(),window.addEventListener("resize",this.__boundResizeListener),this.addEventListener("drawer-toggle-click",this.__drawerToggleClickListener),requestAnimationFrame(()=>{this._updateOffsetSize()}),this._updateTouchOptimizedMode(),this._updateDrawerSize(),this._updateOverlayMode(),this._navbarSizeObserver=new ResizeObserver(()=>{requestAnimationFrame(()=>{this.__isDrawerAnimating?this.__updateOffsetSizePending=!0:this._updateOffsetSize()})}),this._navbarSizeObserver.observe(this.$.navbarTop),this._navbarSizeObserver.observe(this.$.navbarBottom),this._navbarSizeObserver.observe(this.$.drawer),window.addEventListener("close-overlay-drawer",this.__closeOverlayDrawerListener),window.addEventListener("keydown",this.__onDrawerKeyDown)}ready(){super.ready(),this.addController(this.__focusTrapController),this.__setAriaExpanded(),this.$.drawer.addEventListener("transitionstart",()=>{this.__isDrawerAnimating=!0}),this.$.drawer.addEventListener("transitionend",()=>{this.__updateOffsetSizePending&&(this.__updateOffsetSizePending=!1,this._updateOffsetSize()),requestAnimationFrame(()=>{this.__isDrawerAnimating=!1})})}disconnectedCallback(){super.disconnectedCallback(),window.removeEventListener("resize",this.__boundResizeListener),this.removeEventListener("drawer-toggle-click",this.__drawerToggleClickListener),window.removeEventListener("close-overlay-drawer",this.__drawerToggleClickListener),window.removeEventListener("keydown",this.__onDrawerKeyDown)}__primarySectionChanged(a){["navbar","drawer"].includes(a)||(this.primarySection="navbar")}__drawerOpenedChanged(a,k){this.overlay&&(a?this.__trapFocusInDrawer():k&&this.__releaseFocusFromDrawer()),this.__setAriaExpanded()}__overlayChanged(a,k){k&&this.__restoreFocus()}__i18nChanged(){this.__updateDrawerAriaAttributes()}_drawerToggleClick(a){a.stopPropagation(),this.drawerOpened=!this.drawerOpened}__closeOverlayDrawer(){this.overlay&&(this.drawerOpened=!1)}__setAriaExpanded(){const a=this.querySelector("vaadin-drawer-toggle");a&&a.setAttribute("aria-expanded",this.drawerOpened)}_updateDrawerSize(){const a=this.querySelectorAll("[slot=drawer]").length,k=this.$.drawer;a===0?(k.setAttribute("hidden",""),this.style.setProperty("--_vaadin-app-layout-drawer-width",0)):(k.removeAttribute("hidden"),this.style.removeProperty("--_vaadin-app-layout-drawer-width")),this._updateOffsetSize()}_resize(){this._blockAnimationUntilAfterNextRender(),this._updateTouchOptimizedMode(),this._updateOverlayMode()}_updateOffsetSize(){const k=this.$.navbarTop.getBoundingClientRect(),et=this.$.navbarBottom.getBoundingClientRect(),nt=this.$.drawer.getBoundingClientRect();this.style.setProperty("--_vaadin-app-layout-navbar-offset-size",`${k.height}px`),this.style.setProperty("--_vaadin-app-layout-navbar-offset-size-bottom",`${et.height}px`),this.style.setProperty("--_vaadin-app-layout-drawer-offset-size",`${nt.width}px`)}_updateOverlayMode(){const a=this._getCustomPropertyValue("--vaadin-app-layout-drawer-overlay")==="true";!this.overlay&&a&&(this._drawerStateSaved=this.drawerOpened,this.drawerOpened=!1),this._setOverlay(a),!this.overlay&&this._drawerStateSaved&&(this.drawerOpened=this._drawerStateSaved,this._drawerStateSaved=null),this.__updateDrawerAriaAttributes()}__updateDrawerAriaAttributes(){const a=this.$.drawer;this.overlay?(a.setAttribute("role","dialog"),a.setAttribute("aria-modal","true"),a.setAttribute("aria-label",this.__effectiveI18n.drawer)):(a.removeAttribute("role"),a.removeAttribute("aria-modal"),a.removeAttribute("aria-label"))}__drawerTransitionComplete(){return new Promise(a=>{if(this._getCustomPropertyValue("--vaadin-app-layout-transition")==="none"){a();return}this.$.drawer.addEventListener("transitionend",a,{once:!0})})}async __trapFocusInDrawer(){await this.__drawerTransitionComplete(),this.drawerOpened&&(this.$.drawer.setAttribute("tabindex","0"),this.__ariaModalController.showModal(),this.__focusTrapController.trapFocus(this.$.drawer))}async __releaseFocusFromDrawer(){if(await this.__drawerTransitionComplete(),this.drawerOpened)return;this.__restoreFocus();const a=this.querySelector("vaadin-drawer-toggle");a&&a.focus()}__restoreFocus(){this.__ariaModalController.close(),this.__focusTrapController.releaseFocus(),this.$.drawer.removeAttribute("tabindex")}__onDrawerKeyDown(a){a.key==="Escape"&&this.overlay&&(this.drawerOpened=!1)}_closeDrawerOnChanged(a,k){k&&window.removeEventListener(k,this.__closeOverlayDrawerListener),a&&window.addEventListener(a,this.__closeOverlayDrawerListener)}_onBackdropClick(){this._close()}_onBackdropTouchend(a){a.preventDefault(),this._close()}_close(){this.drawerOpened=!1}_getCustomPropertyValue(a){return(getComputedStyle(this).getPropertyValue(a)||"").trim().toLowerCase()}_updateTouchOptimizedMode(){const a=this._getCustomPropertyValue("--vaadin-app-layout-touch-optimized")==="true",k=this.querySelectorAll('[slot*="navbar"]');k.length>0&&Array.from(k).forEach(j=>{j.getAttribute("slot").indexOf("touch-optimized")>-1&&(j.__touchOptimized=!0),a&&j.__touchOptimized?j.setAttribute("slot","navbar-bottom"):j.setAttribute("slot","navbar")}),this.$.navbarTop.querySelector("[name=navbar]").assignedNodes().length===0?this.$.navbarTop.setAttribute("hidden",""):this.$.navbarTop.removeAttribute("hidden"),this.$.navbarBottom.querySelector("[name=navbar-bottom]").assignedNodes().length===0?this.$.navbarBottom.setAttribute("hidden",""):this.$.navbarBottom.removeAttribute("hidden"),this._updateOffsetSize()}_blockAnimationUntilAfterNextRender(){this.setAttribute("no-anim",""),this.__debounceAnimation=Debouncer$1.debounce(this.__debounceAnimation,animationFrame,()=>{setTimeout(()=>{this.removeAttribute("no-anim")})})}};/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const appLayoutStyles=i`
  :host {
    display: block;
    box-sizing: border-box;
    height: 100%;
    --vaadin-app-layout-transition: 200ms;
    transition: padding var(--vaadin-app-layout-transition);
    --_vaadin-app-layout-drawer-width: var(--vaadin-app-layout-drawer-width, 16em);
    --vaadin-app-layout-touch-optimized: false;
    --vaadin-app-layout-navbar-offset-top: var(--_vaadin-app-layout-navbar-offset-size);
    --vaadin-app-layout-navbar-offset-bottom: var(--_vaadin-app-layout-navbar-offset-size-bottom);
    padding-block: var(--vaadin-app-layout-navbar-offset-top) var(--vaadin-app-layout-navbar-offset-bottom);
    padding-inline-start: var(--vaadin-app-layout-navbar-offset-left);
  }

  :host([hidden]),
  [hidden] {
    display: none !important;
  }

  :host([no-anim]) {
    --vaadin-app-layout-transition: none !important;
  }

  :host([drawer-opened]) {
    --vaadin-app-layout-drawer-offset-left: var(--_vaadin-app-layout-drawer-offset-size);
  }

  :host([overlay]) {
    --vaadin-app-layout-drawer-offset-left: 0;
    --vaadin-app-layout-navbar-offset-left: 0;
  }

  :host(:not([no-scroll])) [content] {
    overflow: auto;
  }

  [content] {
    height: 100%;
  }

  @media (pointer: coarse) and (max-width: 800px) and (min-height: 500px) {
    :host {
      --vaadin-app-layout-touch-optimized: true;
    }
  }

  [part='navbar'] {
    position: fixed;
    display: flex;
    align-items: center;
    top: 0;
    inset-inline: 0;
    transition: inset-inline-start var(--vaadin-app-layout-transition);
    padding-top: var(--safe-area-inset-top);
    padding-left: var(--safe-area-inset-left);
    padding-right: var(--safe-area-inset-right);
    z-index: 1;
  }

  :host([primary-section='drawer'][drawer-opened]:not([overlay])) [part='navbar'] {
    inset-inline-start: var(--vaadin-app-layout-drawer-offset-left, 0);
  }

  :host([primary-section='drawer']) [part='drawer'] {
    top: 0;
  }

  [part='navbar'][bottom] {
    top: auto;
    bottom: 0;
    padding-bottom: var(--safe-area-inset-bottom);
  }

  [part='drawer'] {
    overflow: auto;
    position: fixed;
    top: var(--vaadin-app-layout-navbar-offset-top, 0);
    bottom: var(--vaadin-app-layout-navbar-offset-bottom, var(--vaadin-viewport-offset-bottom, 0));
    inset-inline: var(--vaadin-app-layout-navbar-offset-left, 0) auto;
    transition:
      transform var(--vaadin-app-layout-transition),
      visibility var(--vaadin-app-layout-transition);
    transform: translateX(-100%);
    max-width: 90%;
    width: var(--_vaadin-app-layout-drawer-width);
    box-sizing: border-box;
    padding: var(--safe-area-inset-top) 0 var(--safe-area-inset-bottom) var(--safe-area-inset-left);
    outline: none;
    /* The drawer should be inaccessible by the tabbing navigation when it is closed. */
    visibility: hidden;
    display: flex;
    flex-direction: column;
  }

  :host([drawer-opened]) [part='drawer'] {
    /* The drawer should be accessible by the tabbing navigation when it is opened. */
    visibility: visible;
    transform: translateX(0%);
    touch-action: manipulation;
  }

  [part='backdrop'] {
    background-color: #000;
    opacity: 0.3;
  }

  :host(:not([drawer-opened])) [part='backdrop'] {
    opacity: 0;
  }

  :host([overlay]) [part='backdrop'] {
    position: fixed;
    inset: 0;
    pointer-events: none;
    transition: opacity var(--vaadin-app-layout-transition);
    -webkit-tap-highlight-color: transparent;
  }

  :host([overlay]) [part='drawer'] {
    top: 0;
    bottom: 0;
  }

  :host([overlay]) [part='drawer'],
  :host([overlay]) [part='backdrop'] {
    z-index: 2;
  }

  :host([drawer-opened][overlay]) [part='backdrop'] {
    pointer-events: auto;
    touch-action: manipulation;
  }

  :host([dir='rtl']) [part='drawer'] {
    transform: translateX(100%);
  }

  :host([dir='rtl'][drawer-opened]) [part='drawer'] {
    transform: translateX(0%);
  }

  :host([drawer-opened]:not([overlay])) {
    padding-inline-start: var(--vaadin-app-layout-drawer-offset-left);
  }

  @media (max-width: 800px), (max-height: 600px) {
    :host {
      --vaadin-app-layout-drawer-overlay: true;
      --_vaadin-app-layout-drawer-width: var(--vaadin-app-layout-drawer-width, 20em);
    }
  }

  /* If a vaadin-scroller is used in the drawer, allow it to take all remaining space and contain scrolling */
  [part='drawer'] ::slotted(vaadin-scroller) {
    flex: 1;
    overscroll-behavior: contain;
  }
`;/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-app-layout",appLayoutStyles,{moduleId:"vaadin-app-layout-styles"});class AppLayout extends AppLayoutMixin(ElementMixin(ThemableMixin(ControllerMixin(PolymerElement)))){static get template(){return html$3`
      <div part="navbar" id="navbarTop">
        <slot name="navbar" on-slotchange="_updateTouchOptimizedMode"></slot>
      </div>
      <div part="backdrop" on-click="_onBackdropClick" on-touchend="_onBackdropTouchend"></div>
      <div part="drawer" id="drawer">
        <slot name="drawer" id="drawerSlot" on-slotchange="_updateDrawerSize"></slot>
      </div>
      <div content>
        <slot></slot>
      </div>
      <div part="navbar" id="navbarBottom" bottom hidden>
        <slot name="navbar-bottom"></slot>
      </div>
      <div hidden>
        <slot id="touchSlot" name="navbar touch-optimized" on-slotchange="_updateTouchOptimizedMode"></slot>
      </div>
    `}static get is(){return"vaadin-app-layout"}}defineCustomElement(AppLayout);const button$1=i`
  :host {
    /* Sizing */
    --lumo-button-size: var(--lumo-size-m);
    min-width: var(--vaadin-button-min-width, calc(var(--_button-size) * 2));
    height: var(--_button-size);
    padding: var(--vaadin-button-padding, 0 calc(var(--_button-size) / 3 + var(--lumo-border-radius-m) / 2));
    margin: var(--vaadin-button-margin, var(--lumo-space-xs) 0);
    box-sizing: border-box;
    /* Style */
    font-family: var(--lumo-font-family);
    font-size: var(--vaadin-button-font-size, var(--lumo-font-size-m));
    font-weight: var(--vaadin-button-font-weight, 500);
    color: var(--_lumo-button-text-color);
    background: var(--_lumo-button-background);
    border: var(--vaadin-button-border, none);
    border-radius: var(--vaadin-button-border-radius, var(--lumo-border-radius-m));
    cursor: var(--lumo-clickable-cursor);
    -webkit-tap-highlight-color: transparent;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    flex-shrink: 0;
    --_button-size: var(--vaadin-button-height, var(--lumo-button-size));
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
    /* Used by notification */
    --_lumo-button-background: var(--vaadin-button-background, var(--lumo-contrast-5pct));
    --_lumo-button-text-color: var(--vaadin-button-text-color, var(--lumo-primary-text-color));
    --_lumo-button-primary-background: var(--vaadin-button-primary-background, var(--lumo-primary-color));
    --_lumo-button-primary-text-color: var(--vaadin-button-primary-text-color, var(--lumo-primary-contrast-color));
  }

  /* Set only for the internal parts so we don't affect the host vertical alignment */
  [part='label'],
  [part='prefix'],
  [part='suffix'] {
    line-height: var(--lumo-line-height-xs);
  }

  [part='label'] {
    padding: calc(var(--lumo-button-size) / 6) 0;
  }

  :host([theme~='small']) {
    font-size: var(--lumo-font-size-s);
    --lumo-button-size: var(--lumo-size-s);
  }

  :host([theme~='large']) {
    font-size: var(--lumo-font-size-l);
    --lumo-button-size: var(--lumo-size-l);
  }

  /* For interaction states */
  :host::before,
  :host::after {
    content: '';
    /* We rely on the host always being relative */
    position: absolute;
    z-index: 1;
    inset: 0;
    background-color: currentColor;
    border-radius: inherit;
    opacity: 0;
    pointer-events: none;
  }

  /* Hover */

  @media (any-hover: hover) {
    :host(:not([disabled]):hover)::before {
      opacity: 0.02;
    }
  }

  /* Active */

  :host::after {
    transition:
      opacity 1.4s,
      transform 0.1s;
    filter: blur(8px);
  }

  :host([active])::before {
    opacity: 0.05;
    transition-duration: 0s;
  }

  :host([active])::after {
    opacity: 0.1;
    transition-duration: 0s, 0s;
    transform: scale(0);
  }

  /* Keyboard focus */

  :host([focus-ring]) {
    box-shadow:
      0 0 0 calc(1px * var(--_focus-ring-gap-on, 0)) var(--_focus-ring-gap-color, var(--lumo-base-color)),
      0 0 0 calc(var(--_focus-ring-width) + 1px * var(--_focus-ring-gap-on, 0)) var(--_focus-ring-color);
  }

  :host([theme~='primary'][focus-ring]) {
    --_focus-ring-gap-on: 1;
  }

  /* Types (primary, tertiary, tertiary-inline */

  :host([theme~='tertiary']),
  :host([theme~='tertiary-inline']) {
    --_background: transparent !important;
    background: var(--vaadin-button-tertiary-background, var(--_background));
    min-width: 0;
  }

  :host([theme~='tertiary']) {
    border: var(--vaadin-button-tertiary-border, none);
    color: var(--vaadin-button-tertiary-text-color, var(--lumo-primary-text-color));
    font-weight: var(--vaadin-button-tertiary-font-weight, 500);
    padding: var(--vaadin-button-tertiary-padding, 0 calc(var(--_button-size) / 6));
  }

  :host([theme~='tertiary-inline'])::before {
    display: none;
  }

  :host([theme~='tertiary-inline']) {
    margin: 0;
    height: auto;
    padding: 0;
    line-height: inherit;
    font-size: inherit;
  }

  :host([theme~='tertiary-inline']) [part='label'] {
    padding: 0;
    overflow: visible;
    line-height: inherit;
  }

  :host([theme~='primary']) {
    background: var(--_lumo-button-primary-background);
    border: var(--vaadin-button-primary-border, none);
    color: var(--_lumo-button-primary-text-color);
    font-weight: var(--vaadin-button-primary-font-weight, 600);
    min-width: calc(var(--lumo-button-size) * 2.5);
  }

  :host([theme~='primary'])::before {
    background-color: black;
  }

  @media (any-hover: hover) {
    :host([theme~='primary']:not([disabled]):hover)::before {
      opacity: 0.05;
    }
  }

  :host([theme~='primary'][active])::before {
    opacity: 0.1;
  }

  :host([theme~='primary'][active])::after {
    opacity: 0.2;
  }

  /* Colors (success, warning, error, contrast) */

  :host([theme~='success']) {
    color: var(--lumo-success-text-color);
  }

  :host([theme~='success'][theme~='primary']) {
    background-color: var(--lumo-success-color);
    color: var(--lumo-success-contrast-color);
  }

  :host([theme~='warning']) {
    color: var(--lumo-warning-text-color);
  }

  :host([theme~='warning'][theme~='primary']) {
    background-color: var(--lumo-warning-color);
    color: var(--lumo-warning-contrast-color);
  }

  :host([theme~='error']) {
    color: var(--lumo-error-text-color);
  }

  :host([theme~='error'][theme~='primary']) {
    background-color: var(--lumo-error-color);
    color: var(--lumo-error-contrast-color);
  }

  :host([theme~='contrast']) {
    color: var(--lumo-contrast);
  }

  :host([theme~='contrast'][theme~='primary']) {
    background-color: var(--lumo-contrast);
    color: var(--lumo-base-color);
  }

  /* Disabled state. Keep selectors after other color variants. */

  :host([disabled]) {
    color: var(--lumo-disabled-text-color);
  }

  :host([theme~='primary'][disabled]) {
    background-color: var(--lumo-contrast-30pct);
    color: var(--lumo-base-color);
  }

  :host([theme~='primary'][disabled]) [part] {
    opacity: 0.7;
  }

  /* Icons */

  [part] ::slotted(vaadin-icon) {
    display: inline-block;
    width: var(--lumo-icon-size-m);
    height: var(--lumo-icon-size-m);
  }

  /* Vaadin icons are based on a 16x16 grid (unlike Lumo and Material icons with 24x24), so they look too big by default */
  [part] ::slotted(vaadin-icon[icon^='vaadin:']) {
    padding: 0.25em;
    box-sizing: border-box !important;
  }

  [part='prefix'] {
    margin-left: -0.25em;
    margin-right: 0.25em;
  }

  [part='suffix'] {
    margin-left: 0.25em;
    margin-right: -0.25em;
  }

  /* Icon-only */

  :host([theme~='icon']:not([theme~='tertiary-inline'])) {
    min-width: var(--lumo-button-size);
    padding-left: calc(var(--lumo-button-size) / 4);
    padding-right: calc(var(--lumo-button-size) / 4);
  }

  :host([theme~='icon']) [part='prefix'],
  :host([theme~='icon']) [part='suffix'] {
    margin-left: 0;
    margin-right: 0;
  }

  /* RTL specific styles */

  :host([dir='rtl']) [part='prefix'] {
    margin-left: 0.25em;
    margin-right: -0.25em;
  }

  :host([dir='rtl']) [part='suffix'] {
    margin-left: -0.25em;
    margin-right: 0.25em;
  }

  :host([dir='rtl'][theme~='icon']) [part='prefix'],
  :host([dir='rtl'][theme~='icon']) [part='suffix'] {
    margin-left: 0;
    margin-right: 0;
  }
`;registerStyles$1("vaadin-button",button$1,{moduleId:"lumo-button"});/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const buttonStyles=i`
  :host {
    display: inline-block;
    position: relative;
    outline: none;
    white-space: nowrap;
    -webkit-user-select: none;
    user-select: none;
  }

  :host([hidden]) {
    display: none !important;
  }

  :host([disabled]) {
    pointer-events: var(--_vaadin-button-disabled-pointer-events, none);
    cursor: not-allowed;
  }

  /* Aligns the button with form fields when placed on the same line.
  Note, to make it work, the form fields should have the same "::before" pseudo-element. */
  .vaadin-button-container::before {
    content: '\\2003';
    display: inline-block;
    width: 0;
    max-height: 100%;
  }

  .vaadin-button-container {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    text-align: center;
    width: 100%;
    height: 100%;
    min-height: inherit;
    text-shadow: inherit;
  }

  [part='prefix'],
  [part='suffix'] {
    flex: none;
  }

  [part='label'] {
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
  }

  @media (forced-colors: active) {
    :host {
      outline: 1px solid;
      outline-offset: -1px;
    }

    :host([focused]) {
      outline-width: 2px;
    }

    :host([disabled]) {
      outline-color: GrayText;
    }
  }
`;/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-button",buttonStyles,{moduleId:"vaadin-button-styles"});class Button extends ButtonMixin(ElementMixin(ThemableMixin(ControllerMixin(PolymerElement)))){static get properties(){return{disabled:{type:Boolean,value:!1}}}static get is(){return"vaadin-button"}static get template(){return html$3`
      <div class="vaadin-button-container">
        <span part="prefix" aria-hidden="true">
          <slot name="prefix"></slot>
        </span>
        <span part="label">
          <slot></slot>
        </span>
        <span part="suffix" aria-hidden="true">
          <slot name="suffix"></slot>
        </span>
      </div>
      <slot name="tooltip"></slot>
    `}ready(){super.ready(),this._tooltipController=new TooltipController(this),this.addController(this._tooltipController)}__shouldAllowFocusWhenDisabled(){return window.Vaadin.featureFlags.accessibleDisabledButtons}}defineCustomElement(Button);const drawerToggle$1=i`
  :host {
    width: var(--lumo-size-l);
    height: var(--lumo-size-l);
    min-width: auto;
    margin: 0 var(--lumo-space-s);
    padding: 0;
    background: transparent;
  }

  [part='icon'],
  [part='icon']::after,
  [part='icon']::before {
    position: inherit;
    height: auto;
    width: auto;
    background: transparent;
    top: auto;
  }

  [part='icon']::before {
    font-family: lumo-icons;
    font-size: var(--lumo-icon-size-m);
    content: var(--lumo-icons-menu);
  }

  :host([slot~='navbar']) {
    color: var(--lumo-secondary-text-color);
  }
`;registerStyles$1("vaadin-drawer-toggle",[button$1,drawerToggle$1],{moduleId:"lumo-drawer-toggle"});/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const drawerToggle=i`
  :host {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    cursor: default;
    position: relative;
    outline: none;
    height: 24px;
    width: 24px;
    padding: 4px;
  }

  [part='icon'],
  [part='icon']::after,
  [part='icon']::before {
    position: absolute;
    top: 8px;
    height: 3px;
    width: 24px;
    background-color: #000;
  }

  [part='icon']::after,
  [part='icon']::before {
    content: '';
  }

  [part='icon']::after {
    top: 6px;
  }

  [part='icon']::before {
    top: 12px;
  }
`;/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-drawer-toggle",[buttonStyles,drawerToggle],{moduleId:"vaadin-drawer-toggle-styles"});class DrawerToggle extends ButtonMixin(DirMixin(ThemableMixin(PolymerElement))){static get template(){return html$3`
      <slot id="slot">
        <div part="icon"></div>
      </slot>
      <div part="icon" hidden$="[[!_showFallbackIcon]]"></div>
    `}static get is(){return"vaadin-drawer-toggle"}static get properties(){return{ariaLabel:{type:String,value:"Toggle navigation panel",reflectToAttribute:!0},_showFallbackIcon:{type:Boolean,value:!1}}}constructor(){super(),this.addEventListener("click",()=>{this.dispatchEvent(new CustomEvent("drawer-toggle-click",{bubbles:!0,composed:!0}))})}ready(){super.ready(),this._toggleFallbackIcon(),this.$.slot.addEventListener("slotchange",()=>{this._toggleFallbackIcon()})}_toggleFallbackIcon(){const y=this.$.slot.assignedNodes();this._showFallbackIcon=y.length>0&&y.every(a=>isEmptyTextNode(a))}}defineCustomElement(DrawerToggle);const tooltipOverlay=i`
  :host {
    --vaadin-tooltip-offset-top: var(--lumo-space-xs);
    --vaadin-tooltip-offset-bottom: var(--lumo-space-xs);
    --vaadin-tooltip-offset-start: var(--lumo-space-xs);
    --vaadin-tooltip-offset-end: var(--lumo-space-xs);
  }

  [part='overlay'] {
    background: var(--lumo-base-color) linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct));
    color: var(--lumo-body-text-color);
    font-size: var(--lumo-font-size-xs);
    line-height: var(--lumo-line-height-s);
  }

  [part='content'] {
    padding: var(--lumo-space-xs) var(--lumo-space-s);
  }
`;registerStyles$1("vaadin-tooltip-overlay",[overlay,tooltipOverlay],{moduleId:"lumo-tooltip-overlay"});/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const getClosestOverlay=z=>{let y=z;for(;y&&y!==z.ownerDocument;)if(y=y.parentNode||y.host,y&&y._hasOverlayStackMixin)return y;return null},PopoverOverlayMixin=z=>class extends PositionMixin(OverlayMixin(z)){static get properties(){return{position:{type:String,reflectToAttribute:!0}}}static get observers(){return["__openedOrTargetChanged(opened, positionTarget)"]}get _tagNamePrefix(){return"vaadin-popover"}_updatePosition(){if(super._updatePosition(),!(!this.positionTarget||!this.opened)){if(this.owner){const a=getComputedStyle(this.owner);["top","bottom","start","end"].forEach(k=>{const j=`--${this._tagNamePrefix}-offset-${k}`;this.style.setProperty(j,a.getPropertyValue(j))})}if(this.removeAttribute("arrow-centered"),this.position==="bottom"||this.position==="top"){const a=this.positionTarget.getBoundingClientRect(),k=this.$.overlay.getBoundingClientRect(),j=a.width/2-k.width/2;if(this.style.left){const et=k.left+j;et>0&&(this.style.left=`${et}px`,this.setAttribute("arrow-centered",""))}if(this.style.right){const et=parseFloat(this.style.right)+j;et>0&&(this.style.right=`${et}px`,this.setAttribute("arrow-centered",""))}}if(this.position==="start"||this.position==="end"){const a=this.positionTarget.getBoundingClientRect(),k=this.$.overlay.getBoundingClientRect(),j=a.height/2-k.height/2;this.style.top=`${k.top+j}px`}}}__openedOrTargetChanged(a,k){if(k){const j=getClosestOverlay(k);j&&setNestedOverlay(j,a?this:null)}}};/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const tooltipOverlayStyles=i`
  [part='overlay'] {
    max-width: 40ch;
  }

  [part='content'] {
    white-space: pre-wrap;
  }

  :host([position^='top'][top-aligned]) [part='overlay'],
  :host([position^='bottom'][top-aligned]) [part='overlay'] {
    margin-top: var(--vaadin-tooltip-offset-top, 0);
  }

  :host([position^='top'][bottom-aligned]) [part='overlay'],
  :host([position^='bottom'][bottom-aligned]) [part='overlay'] {
    margin-bottom: var(--vaadin-tooltip-offset-bottom, 0);
  }

  :host([position^='start'][start-aligned]) [part='overlay'],
  :host([position^='end'][start-aligned]) [part='overlay'] {
    margin-inline-start: var(--vaadin-tooltip-offset-start, 0);
  }

  :host([position^='start'][end-aligned]) [part='overlay'],
  :host([position^='end'][end-aligned]) [part='overlay'] {
    margin-inline-end: var(--vaadin-tooltip-offset-end, 0);
  }

  @media (forced-colors: active) {
    [part='overlay'] {
      outline: 1px dashed;
    }
  }
`;/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-tooltip-overlay",[overlayStyles$1,tooltipOverlayStyles],{moduleId:"vaadin-tooltip-overlay-styles"});class TooltipOverlay extends PopoverOverlayMixin(DirMixin(ThemableMixin(PolymerElement))){static get is(){return"vaadin-tooltip-overlay"}static get template(){return html$3`
      <div id="backdrop" part="backdrop" hidden></div>
      <div part="overlay" id="overlay">
        <div part="content" id="content"><slot></slot></div>
      </div>
    `}get _tagNamePrefix(){return"vaadin-tooltip"}requestContentUpdate(){super.requestContentUpdate(),this.toggleAttribute("hidden",this.textContent.trim()==="")}}defineCustomElement(TooltipOverlay);/**
 * @license
 * Copyright (c) 2023 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const OverlayClassMixin=z=>class extends z{static get properties(){return{overlayClass:{type:String},_overlayElement:{type:Object}}}static get observers(){return["__updateOverlayClassNames(overlayClass, _overlayElement)"]}__updateOverlayClassNames(a,k){if(!k||a===void 0)return;const{classList:j}=k;if(this.__initialClasses||(this.__initialClasses=new Set(j)),Array.isArray(this.__previousClasses)){const it=this.__previousClasses.filter(nt=>!this.__initialClasses.has(nt));it.length>0&&j.remove(...it)}const et=typeof a=="string"?a.split(" ").filter(Boolean):[];et.length>0&&j.add(...et),this.__previousClasses=et}};/**
 * @license
 * Copyright (c) 2024 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const PopoverPositionMixin=z=>class extends z{static get properties(){return{position:{type:String},_position:{type:String,value:"bottom"},__effectivePosition:{type:String,computed:"__computePosition(position, _position)"}}}__computeHorizontalAlign(a){return["top-end","bottom-end","start-top","start","start-bottom"].includes(a)?"end":"start"}__computeNoHorizontalOverlap(a){return["start-top","start","start-bottom","end-top","end","end-bottom"].includes(a)}__computeNoVerticalOverlap(a){return["top-start","top-end","top","bottom-start","bottom","bottom-end"].includes(a)}__computeVerticalAlign(a){return["top-start","top-end","top","start-bottom","end-bottom"].includes(a)?"bottom":"top"}__computePosition(a,k){return a||k}};/**
 * @license
 * Copyright (c) 2024 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const PopoverTargetMixin=z=>class extends z{static get properties(){return{for:{type:String,observer:"__forChanged"},target:{type:Object},__isConnected:{type:Boolean,sync:!0}}}static get observers(){return["__targetOrConnectedChanged(target, __isConnected)"]}connectedCallback(){super.connectedCallback(),this.__isConnected=!0}disconnectedCallback(){super.disconnectedCallback(),this.__isConnected=!1}__forChanged(a){a&&(this.__setTargetByIdDebouncer=Debouncer$1.debounce(this.__setTargetByIdDebouncer,microTask$1,()=>this.__setTargetById(a)))}__setTargetById(a){if(!this.isConnected)return;const k=this.getRootNode().getElementById(a);k?this.target=k:console.warn(`No element with id="${a}" set via "for" property found on the page.`)}__targetOrConnectedChanged(a,k){this.__previousTarget&&(this.__previousTarget!==a||!k)&&this._removeTargetListeners(this.__previousTarget),a&&k&&this._addTargetListeners(a),this.__previousTarget=a}_addTargetListeners(a){}_removeTargetListeners(a){}};/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DEFAULT_DELAY$1=500;let defaultFocusDelay$3=DEFAULT_DELAY$1,defaultHoverDelay$3=DEFAULT_DELAY$1,defaultHideDelay$3=DEFAULT_DELAY$1;const closing=new Set;let warmedUp=!1,warmUpTimeout=null,cooldownTimeout=null;class TooltipStateController{constructor(y){this.host=y}get openedProp(){return this.host.manual?"opened":"_autoOpened"}get focusDelay(){const y=this.host;return y.focusDelay!=null&&y.focusDelay>=0?y.focusDelay:defaultFocusDelay$3}get hoverDelay(){const y=this.host;return y.hoverDelay!=null&&y.hoverDelay>=0?y.hoverDelay:defaultHoverDelay$3}get hideDelay(){const y=this.host;return y.hideDelay!=null&&y.hideDelay>=0?y.hideDelay:defaultHideDelay$3}get isClosing(){return closing.has(this.host)}open(y={immediate:!1}){const{immediate:a,hover:k,focus:j}=y,et=k&&this.hoverDelay>0,it=j&&this.focusDelay>0;!a&&(et||it)&&!this.__closeTimeout?this.__warmupTooltip(it):this.__showTooltip()}close(y){!y&&this.hideDelay>0?this.__scheduleClose():(this.__abortClose(),this._setOpened(!1)),this.__abortWarmUp(),warmedUp&&(this.__abortCooldown(),this.__scheduleCooldown())}_isOpened(){return this.host[this.openedProp]}_setOpened(y){this.host[this.openedProp]=y}__flushClosingTooltips(){closing.forEach(y=>{y._stateController.close(!0),closing.delete(y)})}__showTooltip(){this.__abortClose(),this.__flushClosingTooltips(),this._setOpened(!0),warmedUp=!0,this.__abortWarmUp(),this.__abortCooldown()}__warmupTooltip(y){this._isOpened()||(warmedUp?this.__showTooltip():warmUpTimeout==null&&this.__scheduleWarmUp(y))}__abortClose(){this.__closeTimeout&&(clearTimeout(this.__closeTimeout),this.__closeTimeout=null),this.isClosing&&closing.delete(this.host)}__abortCooldown(){cooldownTimeout&&(clearTimeout(cooldownTimeout),cooldownTimeout=null)}__abortWarmUp(){warmUpTimeout&&(clearTimeout(warmUpTimeout),warmUpTimeout=null)}__scheduleClose(){this._isOpened()&&!this.isClosing&&(closing.add(this.host),this.__closeTimeout=setTimeout(()=>{closing.delete(this.host),this.__closeTimeout=null,this._setOpened(!1)},this.hideDelay))}__scheduleCooldown(){cooldownTimeout=setTimeout(()=>{cooldownTimeout=null,warmedUp=!1},this.hideDelay)}__scheduleWarmUp(y){const a=y?this.focusDelay:this.hoverDelay;warmUpTimeout=setTimeout(()=>{warmUpTimeout=null,warmedUp=!0,this.__showTooltip()},a)}}const TooltipMixin=z=>class extends PopoverPositionMixin(PopoverTargetMixin(OverlayClassMixin(z))){static get properties(){return{ariaTarget:{type:Object},context:{type:Object,value:()=>({})},focusDelay:{type:Number},generator:{type:Object},hideDelay:{type:Number},hoverDelay:{type:Number},manual:{type:Boolean,value:!1,sync:!0},opened:{type:Boolean,value:!1,sync:!0},shouldShow:{type:Object,value:()=>(a,k)=>!0},text:{type:String,observer:"__textChanged"},_autoOpened:{type:Boolean,observer:"__autoOpenedChanged",sync:!0},_effectiveAriaTarget:{type:Object,computed:"__computeAriaTarget(ariaTarget, target)",observer:"__effectiveAriaTargetChanged"},__isTargetHidden:{type:Boolean,value:!1},_isConnected:{type:Boolean,sync:!0},_srLabel:{type:Object},_overlayContent:{type:String}}}static get observers(){return["__generatorChanged(_overlayElement, generator, context)","__updateSrLabelText(_srLabel, _overlayContent)"]}static setDefaultFocusDelay(a){defaultFocusDelay$3=a!=null&&a>=0?a:DEFAULT_DELAY$1}static setDefaultHideDelay(a){defaultHideDelay$3=a!=null&&a>=0?a:DEFAULT_DELAY$1}static setDefaultHoverDelay(a){defaultHoverDelay$3=a!=null&&a>=0?a:DEFAULT_DELAY$1}constructor(){super(),this._uniqueId=`vaadin-tooltip-${generateUniqueId()}`,this._renderer=this.__tooltipRenderer.bind(this),this.__onFocusin=this.__onFocusin.bind(this),this.__onFocusout=this.__onFocusout.bind(this),this.__onMouseDown=this.__onMouseDown.bind(this),this.__onMouseEnter=this.__onMouseEnter.bind(this),this.__onMouseLeave=this.__onMouseLeave.bind(this),this.__onKeyDown=this.__onKeyDown.bind(this),this.__onOverlayOpen=this.__onOverlayOpen.bind(this),this.__targetVisibilityObserver=new IntersectionObserver(a=>{a.forEach(k=>this.__onTargetVisibilityChange(k.isIntersecting))},{threshold:0}),this._stateController=new TooltipStateController(this)}connectedCallback(){super.connectedCallback(),this._isConnected=!0,document.body.addEventListener("vaadin-overlay-open",this.__onOverlayOpen)}disconnectedCallback(){super.disconnectedCallback(),this._autoOpened&&this._stateController.close(!0),this._isConnected=!1,document.body.removeEventListener("vaadin-overlay-open",this.__onOverlayOpen)}ready(){super.ready(),this._overlayElement=this.$.overlay,this._srLabelController=new SlotController(this,"sr-label","div",{initializer:a=>{a.id=this._uniqueId,a.setAttribute("role","tooltip"),this._srLabel=a}}),this.addController(this._srLabelController)}__computeOpened(a,k,j,et){return et&&(a?k:j)}__autoOpenedChanged(a,k){a?document.addEventListener("keydown",this.__onKeyDown,!0):k&&document.removeEventListener("keydown",this.__onKeyDown,!0)}_addTargetListeners(a){a.addEventListener("mouseenter",this.__onMouseEnter),a.addEventListener("mouseleave",this.__onMouseLeave),a.addEventListener("focusin",this.__onFocusin),a.addEventListener("focusout",this.__onFocusout),a.addEventListener("mousedown",this.__onMouseDown),requestAnimationFrame(()=>{this.__targetVisibilityObserver.observe(a)})}_removeTargetListeners(a){a.removeEventListener("mouseenter",this.__onMouseEnter),a.removeEventListener("mouseleave",this.__onMouseLeave),a.removeEventListener("focusin",this.__onFocusin),a.removeEventListener("focusout",this.__onFocusout),a.removeEventListener("mousedown",this.__onMouseDown),this.__targetVisibilityObserver.unobserve(a)}__onFocusin(a){this.manual||isKeyboardActive()&&(this.target.contains(a.relatedTarget)||this.__isShouldShow()&&(this.__focusInside=!0,!this.__isTargetHidden&&(!this.__hoverInside||!this._autoOpened)&&this._stateController.open({focus:!0})))}__onFocusout(a){this.manual||this.target.contains(a.relatedTarget)||(this.__focusInside=!1,this.__hoverInside||this._stateController.close(!0))}__onKeyDown(a){a.key==="Escape"&&(a.stopPropagation(),this._stateController.close(!0))}__onMouseDown(){this.manual||this._stateController.close(!0)}__onMouseEnter(){this.manual||this.__isShouldShow()&&(this.__hoverInside||(this.__hoverInside=!0,!this.__isTargetHidden&&(!this.__focusInside||!this._autoOpened)&&this._stateController.open({hover:!0})))}__onMouseLeave(a){a.relatedTarget!==this._overlayElement&&this.__handleMouseLeave()}__onOverlayMouseEnter(){this.manual||this._stateController.isClosing&&this._stateController.open({immediate:!0})}__onOverlayMouseLeave(a){a.relatedTarget!==this.target&&this.__handleMouseLeave()}__handleMouseLeave(){this.manual||(this.__hoverInside=!1,this.__focusInside||this._stateController.close())}__onOverlayOpen(){this.manual||this._overlayElement.opened&&!this._overlayElement._last&&this._stateController.close(!0)}__onTargetVisibilityChange(a){const k=this.__isTargetHidden;if(this.__isTargetHidden=!a,k&&a&&(this.__focusInside||this.__hoverInside)){this._stateController.open({immediate:!0});return}!a&&this._autoOpened&&this._stateController.close(!0)}__isShouldShow(){return!(typeof this.shouldShow=="function"&&this.shouldShow(this.target,this.context)!==!0)}__textChanged(a,k){this._overlayElement&&(a||k)&&this._overlayElement.requestContentUpdate()}__tooltipRenderer(a){a.textContent=typeof this.generator=="function"?this.generator(this.context):this.text,this._overlayContent=a.textContent,this.dispatchEvent(new CustomEvent("content-changed",{detail:{content:a.textContent}}))}__computeAriaTarget(a,k){const j=it=>it&&it.nodeType===Node.ELEMENT_NODE;return(Array.isArray(a)?a.some(j):a)?a:k}__effectiveAriaTargetChanged(a,k){k&&[k].flat().forEach(j=>{removeValueFromAttribute(j,"aria-describedby",this._uniqueId)}),a&&[a].flat().forEach(j=>{addValueToAttribute(j,"aria-describedby",this._uniqueId)})}__generatorChanged(a,k,j){a&&((k!==this.__oldTextGenerator||j!==this.__oldContext)&&a.requestContentUpdate(),this.__oldTextGenerator=k,this.__oldContext=j)}__updateSrLabelText(a,k){a&&(a.textContent=k)}};/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */let Tooltip$1=class extends TooltipMixin(ThemePropertyMixin(ElementMixin(ControllerMixin(PolymerElement)))){static get is(){return"vaadin-tooltip"}static get template(){return html$3`
      <style>
        :host {
          display: none;
        }
      </style>
      <vaadin-tooltip-overlay
        id="overlay"
        owner="[[__overlayOwner]]"
        renderer="[[_renderer]]"
        theme$="[[_theme]]"
        opened="[[__computeOpened(manual, opened, _autoOpened, _isConnected)]]"
        position-target="[[target]]"
        position="[[__effectivePosition]]"
        no-horizontal-overlap$="[[__computeNoHorizontalOverlap(__effectivePosition)]]"
        no-vertical-overlap$="[[__computeNoVerticalOverlap(__effectivePosition)]]"
        horizontal-align="[[__computeHorizontalAlign(__effectivePosition)]]"
        vertical-align="[[__computeVerticalAlign(__effectivePosition)]]"
        on-mouseenter="__onOverlayMouseEnter"
        on-mouseleave="__onOverlayMouseLeave"
        modeless
      ></vaadin-tooltip-overlay>

      <slot name="sr-label"></slot>
    `}static get properties(){return{__overlayOwner:{value(){return this}}}}};defineCustomElement(Tooltip$1);const globalStyle=document.createElement("style");globalStyle.textContent="html { --vaadin-avatar-size: var(--lumo-size-m); }";document.head.appendChild(globalStyle);registerStyles$1("vaadin-avatar",i`
    :host {
      color: var(--lumo-secondary-text-color);
      background-color: var(--lumo-contrast-10pct);
      border-radius: 50%;
      outline: none;
      cursor: default;
      user-select: none;
      -webkit-tap-highlight-color: transparent;
      -webkit-font-smoothing: antialiased;
      -moz-osx-font-smoothing: grayscale;
    }

    :host([has-color-index]) {
      color: var(--lumo-base-color);
    }

    :host([focus-ring]) {
      border-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    }

    [part='icon'],
    [part='abbr'] {
      fill: currentColor;
    }

    [part='abbr'] {
      font-family: var(--lumo-font-family);
      font-size: 2.4375em;
      font-weight: 500;
    }

    :host([theme~='xlarge']) [part='abbr'] {
      font-size: 2.5em;
    }

    :host([theme~='large']) [part='abbr'] {
      font-size: 2.375em;
    }

    :host([theme~='small']) [part='abbr'] {
      font-size: 2.75em;
    }

    :host([theme~='xsmall']) [part='abbr'] {
      font-size: 3em;
    }

    :host([theme~='xlarge']) {
      --vaadin-avatar-size: var(--lumo-size-xl);
    }

    :host([theme~='large']) {
      --vaadin-avatar-size: var(--lumo-size-l);
    }

    :host([theme~='small']) {
      --vaadin-avatar-size: var(--lumo-size-s);
    }

    :host([theme~='xsmall']) {
      --vaadin-avatar-size: var(--lumo-size-xs);
    }
  `,{moduleId:"lumo-avatar"});/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const template$7=document.createElement("template");template$7.innerHTML=`
  <style>
    @font-face {
      font-family: 'vaadin-avatar-icons';
      src: url(data:application/font-woff;charset=utf-8;base64,d09GRgABAAAAAAQAAAsAAAAABnwAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAABHU1VCAAABCAAAADsAAABUIIslek9TLzIAAAFEAAAAQwAAAFZAIUmEY21hcAAAAYgAAABLAAABcOspwa1nbHlmAAAB1AAAAEUAAABMYO4o1WhlYWQAAAIcAAAALgAAADYYaAmGaGhlYQAAAkwAAAAdAAAAJAZsA1VobXR4AAACbAAAAAgAAAAIA+gAAGxvY2EAAAJ0AAAABgAAAAYAJgAAbWF4cAAAAnwAAAAeAAAAIAEOACFuYW1lAAACnAAAAUIAAAKavFDYrHBvc3QAAAPgAAAAHQAAAC52hGZ4eJxjYGRgYOBiMGCwY2BycfMJYeDLSSzJY5BiYGGAAJA8MpsxJzM9kYEDxgPKsYBpDiBmg4gCACY7BUgAeJxjYGT8wjiBgZWBgamKaQ8DA0MPhGZ8wGDIyAQUZWBlZsAKAtJcUxgcXjG+YmQO+p/FEMUcxDANKMwIkgMADiUMJQB4nGNgYGBlYGBgBmIdIGZhYGAMYWBkAAE/oCgjWJyZgQsszsKgBFbDAhJ/xfj/P4wE8lnAJAMjG8Mo4AGTMlAeOKwgmIERADU0CX0AeJxjYGIAAmYJpkgGHgYRBgZGJT1GEztGIzlGET5GKEuU8YuSpZKSpQuI+LfLv21emz9jHJQPJP7dsUywsEiwBACG8g9CAAAAeJxjYGRgYADicIOnh+P5bb4ycDO/AIow3JZ4rIJMM0swRQIpDgYmEA8AKwgJOwAAeJxjYGRgYA76nwUkXzAAAbMEAyMDKmACAE2GAskAAAAAAAAAA+gAAAAAAAAAJgAAeJxjYGRgYGBiEAViBjCLgYELCBkY/oP5DAAKuwEwAAB4nI2Qu07DMBSG//SGaCWEhMSAGDx1QU0vYyemdmDrUDEhuamTpkriyHEj9RF4B56Bh2Bg5mmY+8d4Qh3qo9jf+c45thQAt/hGgGYFuHN7s1q4YvbHbdKD5w555LmLAZ499+hfPPfxhDfPA/p33hB0rmmG+PDcwg2+PLfpfzx3yL+eu7gPHj33MAxmnvtYB6+eB/SftZTbtBjJWlppRmmki2qlkkMmzZnKGbVWpkp1Iabh5Ex1qQplpFVbsTmKqk5m1sYiNjoXC11YlWValEbvVWTDnbXlfDyOvQ8jnaOGZGyRouCfky63/AyzFBE0fYUVFBIckLnKZTOXda15s+GZulxgihCTC2eXnC3cfFNV7BfY4Mi9eT3BjNYiZh6zRyMnLdxs050xNE3panuaiD7Ezk2VmGPMiP/1h+71/ATcWYAhAAB4nGNgYoAALgbsgImRiZGZgaW0OLWIgQEACl4B2QAAAA==) format('woff');
      font-weight: normal;
      font-style: normal;
    }
  </style>
`;document.head.appendChild(template$7.content);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DEFAULT_I18N$9={anonymous:"anonymous"},AvatarMixin=z=>class extends I18nMixin(DEFAULT_I18N$9,FocusMixin(z)){static get properties(){return{img:{type:String,reflectToAttribute:!0,observer:"__imgChanged"},abbr:{type:String,reflectToAttribute:!0},name:{type:String,reflectToAttribute:!0},colorIndex:{type:Number,observer:"__colorIndexChanged"},withTooltip:{type:Boolean,value:!1,observer:"__withTooltipChanged"},__imgVisible:Boolean,__iconVisible:Boolean,__abbrVisible:Boolean,__tooltipNode:Object}}static get observers(){return["__imgOrAbbrOrNameChanged(img, abbr, name)","__i18nChanged(__effectiveI18n)","__tooltipChanged(__tooltipNode, name, abbr)"]}get i18n(){return super.i18n}set i18n(a){super.i18n=a}ready(){super.ready(),this.__updateVisibility(),this.hasAttribute("role")||this.setAttribute("role","img"),this.hasAttribute("tabindex")||this.setAttribute("tabindex","0"),!this.name&&!this.abbr&&this.__setTooltip()}__colorIndexChanged(a){if(a!=null){const k=`--vaadin-user-color-${a}`;!!getComputedStyle(document.documentElement).getPropertyValue(k)?(this.setAttribute("has-color-index",""),this.style.setProperty("--vaadin-avatar-user-color",`var(${k})`)):(this.removeAttribute("has-color-index"),console.warn(`The CSS property --vaadin-user-color-${a} is not defined`))}else this.removeAttribute("has-color-index")}__imgChanged(){this.__imgFailedToLoad=!1}__imgOrAbbrOrNameChanged(a,k,j){this.__updateVisibility(),!(k&&k!==this.__generatedAbbr)&&(j?this.abbr=this.__generatedAbbr=j.split(" ").map(et=>et.charAt(0)).join(""):this.abbr=void 0)}__tooltipChanged(a,k,j){a&&(j&&j!==this.__generatedAbbr?this.__setTooltip(k?`${k} (${j})`:j):this.__setTooltip(k)),j?this.setAttribute("aria-label",!a&&k?`${k} (${j})`:j):this.removeAttribute("aria-label")}__withTooltipChanged(a,k){if(this.toggleAttribute("has-tooltip",a),a){const j=document.createElement("vaadin-tooltip");j.setAttribute("slot","tooltip"),this.appendChild(j),this.__tooltipNode=j}else k&&(this.__tooltipNode.target=null,this.__tooltipNode.remove(),this.__tooltipNode=null)}__i18nChanged(a){a&&a.anonymous&&(this.__oldAnonymous&&this.__tooltipNode&&this.__tooltipNode.text===this.__oldAnonymous&&this.__setTooltip(),this.__oldAnonymous=a.anonymous)}__updateVisibility(){this.__imgVisible=!!this.img&&!this.__imgFailedToLoad,this.__abbrVisible=!this.__imgVisible&&!!this.abbr,this.__iconVisible=!this.__imgVisible&&!this.abbr}__setTooltip(a){const k=this.__tooltipNode;k&&(k.text=a||this.__effectiveI18n.anonymous)}__onImageLoadError(){this.img&&(console.warn(`<vaadin-avatar> The specified image could not be loaded: ${this.img}`),this.__imgFailedToLoad=!0,this.__updateVisibility())}};/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const avatarStyles=i`
  :host {
    display: inline-block;
    flex: none;
    border-radius: 50%;
    overflow: hidden;
    height: var(--vaadin-avatar-size, 64px);
    width: var(--vaadin-avatar-size, 64px);
    border: var(--vaadin-avatar-outline-width) solid transparent;
    margin: calc(var(--vaadin-avatar-outline-width) * -1);
    background-clip: content-box;
    --vaadin-avatar-outline-width: var(--vaadin-focus-ring-width, 2px);
  }

  img {
    height: 100%;
    width: 100%;
    object-fit: cover;
  }

  [part='icon'] {
    font-size: 5.6em;
  }

  [part='abbr'] {
    font-size: 2.2em;
  }

  [part='icon'] > text {
    font-family: 'vaadin-avatar-icons';
  }

  :host([hidden]) {
    display: none !important;
  }

  svg[hidden] {
    display: none !important;
  }

  :host([has-color-index]) {
    position: relative;
    background-color: var(--vaadin-avatar-user-color);
  }

  :host([has-color-index])::before {
    position: absolute;
    content: '';
    inset: 0;
    border-radius: inherit;
    box-shadow: inset 0 0 0 2px var(--vaadin-avatar-user-color);
  }
`;/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-avatar",avatarStyles,{moduleId:"vaadin-avatar-styles"});class Avatar extends AvatarMixin(ElementMixin(ThemableMixin(ControllerMixin(PolymerElement)))){static get template(){return html$3`
      <img
        hidden$="[[!__imgVisible]]"
        src$="[[img]]"
        aria-hidden="true"
        on-error="__onImageLoadError"
        draggable="false"
      />
      <svg
        part="icon"
        hidden$="[[!__iconVisible]]"
        id="avatar-icon"
        viewBox="-50 -50 100 100"
        preserveAspectRatio="xMidYMid meet"
        aria-hidden="true"
      >
        <text dy=".35em" text-anchor="middle">&#xea01;</text>
      </svg>
      <svg
        part="abbr"
        hidden$="[[!__abbrVisible]]"
        id="avatar-abbr"
        viewBox="-50 -50 100 100"
        preserveAspectRatio="xMidYMid meet"
        aria-hidden="true"
      >
        <text dy=".35em" text-anchor="middle">[[abbr]]</text>
      </svg>

      <slot name="tooltip"></slot>
    `}static get is(){return"vaadin-avatar"}ready(){super.ready(),this._tooltipController=new TooltipController(this),this.addController(this._tooltipController)}}defineCustomElement(Avatar);const item=i`
  :host {
    display: flex;
    align-items: center;
    box-sizing: border-box;
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    line-height: var(--lumo-line-height-xs);
    padding: 0.5em calc(var(--lumo-space-l) + var(--lumo-border-radius-m) / 4) 0.5em
      var(--_lumo-list-box-item-padding-left, calc(var(--lumo-border-radius-m) / 4));
    min-height: var(--lumo-size-m);
    outline: none;
    border-radius: var(--lumo-border-radius-m);
    cursor: var(--lumo-clickable-cursor);
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    -webkit-tap-highlight-color: var(--lumo-primary-color-10pct);
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
    --_selection-color-text: var(--vaadin-selection-color-text, var(--lumo-primary-text-color));
  }

  /* Checkmark */
  [part='checkmark']::before {
    display: var(--_lumo-item-selected-icon-display, none);
    content: var(--lumo-icons-checkmark);
    font-family: lumo-icons;
    font-size: var(--lumo-icon-size-m);
    line-height: 1;
    font-weight: normal;
    width: 1em;
    height: 1em;
    margin: calc((1 - var(--lumo-line-height-xs)) * var(--lumo-font-size-m) / 2) 0;
    color: var(--_selection-color-text);
    flex: none;
    opacity: 0;
    transition:
      transform 0.2s cubic-bezier(0.12, 0.32, 0.54, 2),
      opacity 0.1s;
  }

  :host([selected]) [part='checkmark']::before {
    opacity: 1;
  }

  :host([active]:not([selected])) [part='checkmark']::before {
    transform: scale(0.8);
    opacity: 0;
    transition-duration: 0s;
  }

  [part='content'] {
    flex: auto;
  }

  /* Disabled */
  :host([disabled]) {
    color: var(--lumo-disabled-text-color);
    cursor: default;
    pointer-events: none;
  }

  /* TODO a workaround until we have "focus-follows-mouse". After that, use the hover style for focus-ring as well */
  @media (any-hover: hover) {
    :host(:hover:not([disabled])) {
      background-color: var(--lumo-primary-color-10pct);
    }
  }

  :host([focus-ring]:not([disabled])) {
    box-shadow: inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }

  /* RTL specific styles */
  :host([dir='rtl']) {
    padding-left: calc(var(--lumo-space-l) + var(--lumo-border-radius-m) / 4);
    padding-right: var(--_lumo-list-box-item-padding-left, calc(var(--lumo-border-radius-m) / 4));
  }

  /* Slotted icons */
  :host ::slotted(vaadin-icon) {
    width: var(--lumo-icon-size-m);
    height: var(--lumo-icon-size-m);
  }
`;registerStyles$1("vaadin-item",item,{moduleId:"lumo-item"});const listBox=i`
  :host {
    -webkit-tap-highlight-color: transparent;
    --_lumo-item-selected-icon-display: var(--_lumo-list-box-item-selected-icon-display, block);
  }

  /* Dividers */
  [part='items'] ::slotted(hr) {
    height: 1px;
    border: 0;
    padding: 0;
    margin: var(--lumo-space-s) var(--lumo-border-radius-m);
    background-color: var(--lumo-contrast-10pct);
  }
`;registerStyles$1("vaadin-list-box",listBox,{moduleId:"lumo-list-box"});/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const menuOverlayCore=i`
  :host([opening]),
  :host([closing]) {
    animation: 0.14s lumo-overlay-dummy-animation;
  }

  [part='overlay'] {
    will-change: opacity, transform;
  }

  :host([opening]) [part='overlay'] {
    animation: 0.1s lumo-menu-overlay-enter ease-out both;
  }

  @keyframes lumo-menu-overlay-enter {
    0% {
      opacity: 0;
      transform: translateY(-4px);
    }
  }

  :host([closing]) [part='overlay'] {
    animation: 0.1s lumo-menu-overlay-exit both;
  }

  @keyframes lumo-menu-overlay-exit {
    100% {
      opacity: 0;
    }
  }
`;registerStyles$1("",menuOverlayCore,{moduleId:"lumo-menu-overlay-core"});const menuOverlayExt=i`
  /* Small viewport (bottom sheet) styles */
  /* Use direct media queries instead of the state attributes ([phone] and [fullscreen]) provided by the elements */
  @media (max-width: 450px), (max-height: 450px) {
    :host {
      top: 0 !important;
      right: 0 !important;
      bottom: var(--vaadin-overlay-viewport-bottom, 0) !important;
      left: 0 !important;
      align-items: stretch !important;
      justify-content: flex-end !important;
    }

    [part='overlay'] {
      max-height: 50vh;
      width: 100vw;
      border-radius: 0;
      box-shadow: var(--lumo-box-shadow-xl);
    }

    /* The content part scrolls instead of the overlay part, because of the gradient fade-out */
    [part='content'] {
      padding: 30px var(--lumo-space-m);
      max-height: inherit;
      box-sizing: border-box;
      -webkit-overflow-scrolling: touch;
      overflow: auto;
      -webkit-mask-image: linear-gradient(transparent, #000 40px, #000 calc(100% - 40px), transparent);
      mask-image: linear-gradient(transparent, #000 40px, #000 calc(100% - 40px), transparent);
    }

    [part='backdrop'] {
      display: block;
    }

    /* Animations */

    :host([opening]) [part='overlay'] {
      animation: 0.2s lumo-mobile-menu-overlay-enter cubic-bezier(0.215, 0.61, 0.355, 1) both;
    }

    :host([closing]),
    :host([closing]) [part='backdrop'] {
      animation-delay: 0.14s;
    }

    :host([closing]) [part='overlay'] {
      animation: 0.14s 0.14s lumo-mobile-menu-overlay-exit cubic-bezier(0.55, 0.055, 0.675, 0.19) both;
    }
  }

  @keyframes lumo-mobile-menu-overlay-enter {
    0% {
      transform: translateY(150%);
    }
  }

  @keyframes lumo-mobile-menu-overlay-exit {
    100% {
      transform: translateY(150%);
    }
  }
`,menuOverlay=[overlay,menuOverlayCore,menuOverlayExt];registerStyles$1("",menuOverlay,{moduleId:"lumo-menu-overlay"});registerStyles$1("vaadin-avatar-group",i`
    :host {
      --vaadin-avatar-size: var(--lumo-size-m);
    }

    :host([theme~='xlarge']) {
      --vaadin-avatar-group-overlap: 12px;
      --vaadin-avatar-group-overlap-border: 3px;
      --vaadin-avatar-size: var(--lumo-size-xl);
    }

    :host([theme~='large']) {
      --vaadin-avatar-group-overlap: 10px;
      --vaadin-avatar-group-overlap-border: 3px;
      --vaadin-avatar-size: var(--lumo-size-l);
    }

    :host([theme~='small']) {
      --vaadin-avatar-group-overlap: 6px;
      --vaadin-avatar-group-overlap-border: 2px;
      --vaadin-avatar-size: var(--lumo-size-s);
    }

    :host([theme~='xsmall']) {
      --vaadin-avatar-group-overlap: 4px;
      --vaadin-avatar-group-overlap-border: 2px;
      --vaadin-avatar-size: var(--lumo-size-xs);
    }
  `,{moduleId:"lumo-avatar-group"});const avatarGroupOverlay=i`
  :host {
    --_lumo-list-box-item-selected-icon-display: none;
    --_lumo-list-box-item-padding-left: calc(var(--lumo-space-m) + var(--lumo-border-radius-m) / 4);
  }

  [part='overlay'] {
    outline: none;
  }
`;registerStyles$1("vaadin-avatar-group-overlay",[overlay,menuOverlayCore,avatarGroupOverlay],{moduleId:"lumo-avatar-group-overlay"});registerStyles$1("vaadin-avatar-group-menu",listBox,{moduleId:"lumo-avatar-group-menu"});registerStyles$1("vaadin-avatar-group-menu-item",[item,i`
      :host {
        padding: var(--lumo-space-xs);
        padding-inline-end: var(--lumo-space-m);
      }

      [part='content'] {
        display: flex;
        align-items: center;
      }

      [part='content'] ::slotted(vaadin-avatar) {
        width: var(--lumo-size-xs);
        height: var(--lumo-size-xs);
        margin-inline-end: var(--lumo-space-s);
      }
    `],{moduleId:"lumo-avatar-group-menu-item"});/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function getNormalizedScrollLeft(z,y){const{scrollLeft:a}=z;return y!=="rtl"?a:z.scrollWidth-z.clientWidth+a}function setNormalizedScrollLeft(z,y,a){y!=="rtl"?z.scrollLeft=a:z.scrollLeft=z.clientWidth-z.scrollWidth+a}/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ListMixin=z=>class extends KeyboardDirectionMixin(z){static get properties(){return{disabled:{type:Boolean,value:!1,reflectToAttribute:!0},selected:{type:Number,reflectToAttribute:!0,notify:!0,sync:!0},orientation:{type:String,reflectToAttribute:!0,value:""},items:{type:Array,readOnly:!0,notify:!0},_searchBuf:{type:String,value:""}}}static get observers(){return["_enhanceItems(items, orientation, selected, disabled)"]}get _isRTL(){return!this._vertical&&this.getAttribute("dir")==="rtl"}get _scrollerElement(){return console.warn(`Please implement the '_scrollerElement' property in <${this.localName}>`),this}get _vertical(){return this.orientation!=="horizontal"}focus(a){this._observer&&this._observer.flush();const k=Array.isArray(this.items)?this.items:[],j=this._getAvailableIndex(k,0,null,et=>et.tabIndex===0&&!isElementHidden(et));j>=0?this._focus(j,a):super.focus(a)}ready(){super.ready(),this.addEventListener("click",k=>this._onClick(k));const a=this.shadowRoot.querySelector("slot:not([name])");this._observer=new SlotObserver(a,()=>{this._setItems(this._filterItems([...this.children]))})}_getItems(){return this.items}_enhanceItems(a,k,j,et){if(!et&&a){this.setAttribute("aria-orientation",k||"vertical"),a.forEach(nt=>{k?nt.setAttribute("orientation",k):nt.removeAttribute("orientation")}),this._setFocusable(j<0||!j?0:j);const it=a[j];a.forEach(nt=>{nt.selected=nt===it}),it&&!it.disabled&&this._scrollToItem(j)}}_filterItems(a){return a.filter(k=>k._hasVaadinItemMixin)}_onClick(a){if(a.metaKey||a.shiftKey||a.ctrlKey||a.defaultPrevented)return;const k=this._filterItems(a.composedPath())[0];let j;k&&!k.disabled&&(j=this.items.indexOf(k))>=0&&(this.selected=j)}_searchKey(a,k){this._searchReset=Debouncer$1.debounce(this._searchReset,timeOut$1.after(500),()=>{this._searchBuf=""}),this._searchBuf+=k.toLowerCase(),this.items.some(et=>this.__isMatchingKey(et))||(this._searchBuf=k.toLowerCase());const j=this._searchBuf.length===1?a+1:a;return this._getAvailableIndex(this.items,j,1,et=>this.__isMatchingKey(et)&&getComputedStyle(et).display!=="none")}__isMatchingKey(a){return a.textContent.replace(/[^\p{L}\p{Nd}]/gu,"").toLowerCase().startsWith(this._searchBuf)}_onKeyDown(a){if(a.metaKey||a.ctrlKey)return;const k=a.key,j=this.items.indexOf(this.focused);if(/[\p{L}\p{Nd}]/u.test(k)&&k.length===1){const et=this._searchKey(j,k);et>=0&&this._focus(et);return}super._onKeyDown(a)}_setFocusable(a){a=this._getAvailableIndex(this.items,a,1);const k=this.items[a];this.items.forEach(j=>{j.tabIndex=j===k?0:-1})}_focus(a,k){this.items.forEach((j,et)=>{j.focused=et===a}),this._setFocusable(a),this._scrollToItem(a),super._focus(a,k)}_scrollToItem(a){const k=this.items[a];if(!k)return;const j=this._vertical?["top","bottom"]:this._isRTL?["right","left"]:["left","right"],et=this._scrollerElement.getBoundingClientRect(),it=(this.items[a+1]||k).getBoundingClientRect(),nt=(this.items[a-1]||k).getBoundingClientRect();let ot=0;!this._isRTL&&it[j[1]]>=et[j[1]]||this._isRTL&&it[j[1]]<=et[j[1]]?ot=it[j[1]]-et[j[1]]:(!this._isRTL&&nt[j[0]]<=et[j[0]]||this._isRTL&&nt[j[0]]>=et[j[0]])&&(ot=nt[j[0]]-et[j[0]]),this._scroll(ot)}_scroll(a){if(this._vertical)this._scrollerElement.scrollTop+=a;else{const k=this.getAttribute("dir")||"ltr",j=getNormalizedScrollLeft(this._scrollerElement,k)+a;setNormalizedScrollLeft(this._scrollerElement,k,j)}}};/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AvatarGroupMenu extends ListMixin(ThemableMixin(DirMixin(ControllerMixin(PolymerElement)))){static get is(){return"vaadin-avatar-group-menu"}static get template(){return html$3`
      <style>
        :host {
          display: flex;
        }

        :host([hidden]) {
          display: none !important;
        }

        [part='items'] {
          height: 100%;
          width: 100%;
          overflow-y: auto;
          -webkit-overflow-scrolling: touch;
        }
      </style>
      <div part="items">
        <slot></slot>
      </div>
    `}static get properties(){return{orientation:{readOnly:!0}}}get _scrollerElement(){return this.shadowRoot.querySelector('[part="items"]')}ready(){super.ready(),this.setAttribute("role","menu")}}defineCustomElement(AvatarGroupMenu);/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ItemMixin=z=>class extends ActiveMixin(FocusMixin(z)){static get properties(){return{_hasVaadinItemMixin:{value:!0},selected:{type:Boolean,value:!1,reflectToAttribute:!0,observer:"_selectedChanged",sync:!0},_value:String}}get _activeKeys(){return["Enter"," "]}get value(){return this._value!==void 0?this._value:this.textContent.trim()}set value(a){this._value=a}ready(){super.ready();const a=this.getAttribute("value");a!==null&&(this.value=a)}focus(a){this.disabled||super.focus(a)}_shouldSetActive(a){return!this.disabled&&!(a.type==="keydown"&&a.defaultPrevented)}_selectedChanged(a){this.setAttribute("aria-selected",a)}_disabledChanged(a){super._disabledChanged(a),a&&(this.selected=!1,this.blur())}_onKeyDown(a){super._onKeyDown(a),this._activeKeys.includes(a.key)&&!a.defaultPrevented&&(a.preventDefault(),this.click())}};/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AvatarGroupMenuItem extends ItemMixin(ThemableMixin(DirMixin(PolymerElement))){static get is(){return"vaadin-avatar-group-menu-item"}static get template(){return html$3`
      <style>
        :host {
          display: inline-block;
        }

        :host([hidden]) {
          display: none !important;
        }
      </style>
      <span part="checkmark" aria-hidden="true"></span>
      <div part="content">
        <slot></slot>
      </div>
    `}ready(){super.ready(),this.setAttribute("role","menuitem")}}defineCustomElement(AvatarGroupMenuItem);/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-avatar-group-overlay",[overlayStyles$1],{moduleId:"vaadin-avatar-group-overlay-styles"});class AvatarGroupOverlay extends PositionMixin(OverlayMixin(DirMixin(ThemableMixin(PolymerElement)))){static get is(){return"vaadin-avatar-group-overlay"}static get template(){return html$3`
      <div id="backdrop" part="backdrop" hidden$="[[!withBackdrop]]"></div>
      <div part="overlay" id="overlay" tabindex="0">
        <div part="content" id="content">
          <slot></slot>
        </div>
      </div>
    `}}defineCustomElement(AvatarGroupOverlay);/**
 * @license
 * Copyright 2018 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */const o$2=z=>z??E;/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const observer$1=new ResizeObserver(z=>{setTimeout(()=>{z.forEach(y=>{y.target.isConnected&&(y.target.resizables?y.target.resizables.forEach(a=>{a._onResize(y.contentRect)}):y.target._onResize(y.contentRect))})})}),ResizeMixin=dedupeMixin(z=>class extends z{get _observeParent(){return!1}connectedCallback(){if(super.connectedCallback(),observer$1.observe(this),this._observeParent){const a=this.parentNode instanceof ShadowRoot?this.parentNode.host:this.parentNode;a.resizables||(a.resizables=new Set,observer$1.observe(a)),a.resizables.add(this),this.__parent=a}}disconnectedCallback(){super.disconnectedCallback(),observer$1.unobserve(this);const a=this.__parent;if(this._observeParent&&a){const k=a.resizables;k&&(k.delete(this),k.size===0&&observer$1.unobserve(a)),this.__parent=null}}_onResize(a){}});/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const MINIMUM_DISPLAYED_AVATARS=2,DEFAULT_I18N$8={anonymous:"anonymous",activeUsers:{one:"Currently one active user",many:"Currently {count} active users"},joined:"{user} joined",left:"{user} left"},AvatarGroupMixin=z=>class extends I18nMixin(DEFAULT_I18N$8,ResizeMixin(OverlayClassMixin(z))){static get properties(){return{items:{type:Array,observer:"__itemsChanged",sync:!0},maxItemsVisible:{type:Number,sync:!0},_avatars:{type:Array,value:()=>[],sync:!0},__itemsInView:{type:Number,value:null,sync:!0},_overflow:{type:Object,sync:!0},_overflowItems:{type:Array,observer:"__overflowItemsChanged",computed:"__computeOverflowItems(items, __itemsInView, maxItemsVisible)"},_overflowTooltip:{type:Object,sync:!0},_opened:{type:Boolean,sync:!0}}}static get observers(){return["__i18nItemsChanged(__effectiveI18n, items)","__openedChanged(_opened, _overflow)","__updateAvatarsTheme(_overflow, _avatars, _theme)","__updateAvatars(items, __itemsInView, maxItemsVisible, _overflow, __effectiveI18n)","__updateOverflowAvatar(_overflow, items, __itemsInView, maxItemsVisible)","__updateOverflowTooltip(_overflowTooltip, items, __itemsInView, maxItemsVisible)"]}get i18n(){return super.i18n}set i18n(a){super.i18n=a}ready(){super.ready(),this._overflowController=new SlotController(this,"overflow","vaadin-avatar",{initializer:k=>{k.setAttribute("role","button"),k.setAttribute("aria-haspopup","menu"),k.setAttribute("aria-expanded","false"),k.addEventListener("click",et=>this._onOverflowClick(et)),k.addEventListener("keydown",et=>this._onOverflowKeyDown(et));const j=document.createElement("vaadin-tooltip");j.setAttribute("slot","tooltip"),k.appendChild(j),this._overflow=k,this._overflowTooltip=j}}),this.addController(this._overflowController);const a=this.$.overlay;a.renderer=this.__overlayRenderer.bind(this),this._overlayElement=a}disconnectedCallback(){super.disconnectedCallback(),this._opened=!1}__getMessage(a,k){return k.replace("{user}",a.name||a.abbr||this.__effectiveI18n.anonymous)}__overlayRenderer(a){let k=a.firstElementChild;k||(k=document.createElement("vaadin-avatar-group-menu"),k.addEventListener("keydown",j=>this._onListKeyDown(j)),a.appendChild(k)),k.textContent="",this._overflowItems&&this._overflowItems.forEach(j=>{k.appendChild(this.__createItemElement(j))})}__createItemElement(a){const k=document.createElement("vaadin-avatar-group-menu-item"),j=document.createElement("vaadin-avatar");if(k.appendChild(j),j.setAttribute("aria-hidden","true"),j.setAttribute("tabindex","-1"),j.i18n=this.__effectiveI18n,this._theme&&j.setAttribute("theme",this._theme),j.name=a.name,j.abbr=a.abbr,j.img=a.img,j.colorIndex=a.colorIndex,a.className&&(j.className=a.className),a.name){const et=document.createTextNode(a.name);k.appendChild(et)}return k}_onOverflowClick(a){a.stopPropagation(),this._opened?this.$.overlay.close():a.defaultPrevented||(this._opened=!0)}_onOverflowKeyDown(a){this._opened||/^(Enter|SpaceBar|\s)$/u.test(a.key)&&(a.preventDefault(),this._opened=!0)}_onListKeyDown(a){(a.key==="Escape"||a.key==="Tab")&&(this._opened=!1)}_onResize(){this.__setItemsInView()}_onVaadinOverlayClose(a){a.detail.sourceEvent&&a.detail.sourceEvent.composedPath().includes(this)&&a.preventDefault()}_onVaadinOverlayOpen(){this._menuElement&&this._menuElement.focus()}__renderAvatars(a){B(x`
          ${a.map(k=>x`
              <vaadin-avatar
                .name="${k.name}"
                .abbr="${k.abbr}"
                .img="${k.img}"
                .colorIndex="${k.colorIndex}"
                .i18n="${this.__effectiveI18n}"
                class="${o$2(k.className)}"
                with-tooltip
              ></vaadin-avatar>
            `)}
        `,this,{renderBefore:this._overflow})}__updateAvatars(a,k,j,et){if(!et||!Array.isArray(a))return;const it=this.__getLimit(a.length,k,j);this.__renderAvatars(it?a.slice(0,it):a),this._avatars=[...this.querySelectorAll("vaadin-avatar")]}__computeOverflowItems(a,k,j){const et=Array.isArray(a)?a.length:0,it=this.__getLimit(et,k,j);return it?a.slice(it):[]}__updateOverflowAvatar(a,k,j,et){if(a){const it=Array.isArray(k)?k.length:0,nt=et!=null&&it>this.__getMax(et);a.abbr=`+${it-this.__getLimit(it,j,et)}`,a.toggleAttribute("hidden",!nt&&!(j&&j<it))}}__updateAvatarsTheme(a,k,j){a&&[a,...k].forEach(et=>{j?et.setAttribute("theme",j):et.removeAttribute("theme")})}__updateOverflowTooltip(a,k,j,et){if(!a||!Array.isArray(k))return;const it=this.__getLimit(k.length,j,et);if(it==null)return;const nt=[];for(let ot=it;ot<k.length;ot++){const at=k[ot];at&&nt.push(at.name||at.abbr||"anonymous")}a.text=nt.join(`
`)}__getLimit(a,k,j){let et=null;const it=this.__getMax(j);return j!=null&&it<a?et=it-1:k&&k<a&&(et=k),Math.min(et,this.__calculateAvatarsFitWidth())}__getMax(a){return Math.max(a,MINIMUM_DISPLAYED_AVATARS)}__itemsChanged(a,k){this.__setItemsInView();let j=[],et=[];const it=Array.isArray(a),nt=Array.isArray(k);nt&&(et=k.filter(ot=>it&&!a.includes(ot))),it&&(j=a.filter(ot=>nt&&!k.includes(ot))),this.__announceItemsChange(j,et)}__announceItemsChange(a,k){let j=[],et=[];a&&(j=a.map(nt=>this.__getMessage(nt,this.__effectiveI18n.joined||"{user} joined"))),k&&(et=k.map(nt=>this.__getMessage(nt,this.__effectiveI18n.left||"{user} left")));const it=et.concat(j);it.length>0&&announce(it.join(", "))}__i18nItemsChanged(a,k){if(a&&a.activeUsers){const j=Array.isArray(k)?k.length:0,et=j===1?"one":"many";a.activeUsers[et]&&this.setAttribute("aria-label",a.activeUsers[et].replace("{count}",j||0)),this._avatars.forEach(it=>{it.i18n=a})}}__openedChanged(a,k){k&&(a?(this._menuElement||(this._menuElement=this.$.overlay.querySelector("vaadin-avatar-group-menu")),this._openedWithFocusRing=k.hasAttribute("focus-ring")):this.__oldOpened&&k.focus({focusVisible:this._openedWithFocusRing}),k.setAttribute("aria-expanded",a===!0),this.__oldOpened=a)}__overflowItemsChanged(a,k){(a||k)&&this.$.overlay.requestContentUpdate()}__setItemsInView(){const a=this._avatars,k=this.items;if(!k||!a||a.length<3)return;let j=this.__calculateAvatarsFitWidth();j===k.length-1&&(j=k.length),j>=k.length&&this._opened&&(this.$.overlay.close(),this.$.overlay._flushAnimation("closing")),this.__itemsInView=j}__calculateAvatarsFitWidth(){if(!this.shadowRoot||this._avatars.length<MINIMUM_DISPLAYED_AVATARS)return MINIMUM_DISPLAYED_AVATARS;const a=this._avatars,k=a[0].clientWidth,{marginLeft:j,marginRight:et}=getComputedStyle(a[1]),it=this.__isRTL?parseInt(et,0)-parseInt(j,0):parseInt(j,0)-parseInt(et,0);return Math.floor((this.$.container.offsetWidth-k)/(k+it))}};/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const avatarGroupStyles=i`
  :host {
    display: block;
    width: 100%; /* prevent collapsing inside non-stretching column flex */
    --vaadin-avatar-group-overlap: 8px;
    --vaadin-avatar-group-overlap-border: 2px;
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='container'] {
    display: flex;
    position: relative;
    width: 100%;
    flex-wrap: nowrap;
  }

  ::slotted(vaadin-avatar:not(:first-child)) {
    -webkit-mask-image: url('data:image/svg+xml;utf8,<svg viewBox=%220 0 300 300%22 fill=%22none%22 xmlns=%22http://www.w3.org/2000/svg%22><path fill-rule=%22evenodd%22 clip-rule=%22evenodd%22 d=%22M300 0H0V300H300V0ZM150 200C177.614 200 200 177.614 200 150C200 122.386 177.614 100 150 100C122.386 100 100 122.386 100 150C100 177.614 122.386 200 150 200Z%22 fill=%22black%22/></svg>');
    mask-image: url('data:image/svg+xml;utf8,<svg viewBox=%220 0 300 300%22 fill=%22none%22 xmlns=%22http://www.w3.org/2000/svg%22><path fill-rule=%22evenodd%22 clip-rule=%22evenodd%22 d=%22M300 0H0V300H300V0ZM150 200C177.614 200 200 177.614 200 150C200 122.386 177.614 100 150 100C122.386 100 100 122.386 100 150C100 177.614 122.386 200 150 200Z%22 fill=%22black%22/></svg>');
    -webkit-mask-size: calc(
      300% + var(--vaadin-avatar-group-overlap-border) * 6 - var(--vaadin-avatar-outline-width) * 6
    );
    mask-size: calc(300% + var(--vaadin-avatar-group-overlap-border) * 6 - var(--vaadin-avatar-outline-width) * 6);
  }

  ::slotted(vaadin-avatar:not([dir='rtl']):not(:first-child)) {
    margin-left: calc(var(--vaadin-avatar-group-overlap) * -1 - var(--vaadin-avatar-outline-width));
    -webkit-mask-position: calc(50% - var(--vaadin-avatar-size) + var(--vaadin-avatar-group-overlap));
    mask-position: calc(50% - var(--vaadin-avatar-size) + var(--vaadin-avatar-group-overlap));
  }

  ::slotted(vaadin-avatar[dir='rtl']:not(:first-child)) {
    margin-right: calc(var(--vaadin-avatar-group-overlap) * -1);
    -webkit-mask-position: calc(
      50% + var(--vaadin-avatar-size) - var(--vaadin-avatar-group-overlap) + var(--vaadin-avatar-outline-width)
    );
    mask-position: calc(
      50% + var(--vaadin-avatar-size) - var(--vaadin-avatar-group-overlap) + var(--vaadin-avatar-outline-width)
    );
  }
`;/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-avatar-group",avatarGroupStyles,{moduleId:"vaadin-avatar-group-styles"});class AvatarGroup extends AvatarGroupMixin(ElementMixin(ThemableMixin(ControllerMixin(PolymerElement)))){static get template(){return html$3`
      <div id="container" part="container">
        <slot></slot>
        <slot name="overflow"></slot>
      </div>
      <vaadin-avatar-group-overlay
        id="overlay"
        opened="{{_opened}}"
        position-target="[[_overflow]]"
        no-vertical-overlap
        on-vaadin-overlay-close="_onVaadinOverlayClose"
        on-vaadin-overlay-open="_onVaadinOverlayOpen"
      ></vaadin-avatar-group-overlay>
    `}static get is(){return"vaadin-avatar-group"}}defineCustomElement(AvatarGroup);/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */const CLASSES={SMALL:"small",MEDIUM:"medium",LARGE:"large"},BoardRowMixin=z=>class extends ResizeMixin(z){constructor(){super(),this._oldWidth=0,this._oldBreakpoints={smallSize:600,mediumSize:960},this._oldFlexBasis=[]}ready(){super.ready(),this.$.insertionPoint.addEventListener("slotchange",()=>this.redraw())}connectedCallback(){super.connectedCallback(),this._onResize()}_addStyleNames(a,k){a<k.smallSize?(this.classList.add(CLASSES.SMALL),this.classList.remove(CLASSES.MEDIUM),this.classList.remove(CLASSES.LARGE)):a<k.mediumSize?(this.classList.remove(CLASSES.SMALL),this.classList.add(CLASSES.MEDIUM),this.classList.remove(CLASSES.LARGE)):(this.classList.remove(CLASSES.SMALL),this.classList.remove(CLASSES.MEDIUM),this.classList.add(CLASSES.LARGE))}_calculateFlexBasis(a,k,j,et){k<et.smallSize?j=1:k<et.mediumSize&&j===4&&(j=2);let it=a/j*100;return it=it>100?100:it,`${it}%`}_reportError(){console.warn("The column configuration is not valid; column count should add up to 3 or 4.",`check: \r
${this.outerHTML}`)}_parseBoardCols(a){const k=a.map(it=>it.getAttribute("board-cols")?parseInt(it.getAttribute("board-cols")):1);let j=4,et=[];return a.forEach((it,nt)=>{j-=k[nt]}),j<0?(this._reportError(),k.forEach((it,nt)=>{et[nt]=1})):et=k.slice(0),et}_removeExtraNodesFromDOM(a,k){let j=!1,et=4;const it=[];return k.forEach((nt,ot)=>{et-=a[ot],et<0?(j||(j=!0,this._reportError()),this.removeChild(nt)):it[ot]=nt}),it}redraw(){this._recalculateFlexBasis(!0)}_onResize(){this._recalculateFlexBasis(!1)}_recalculateFlexBasis(a){const k=this.getBoundingClientRect().width,j=this._measureBreakpointsInPx();if(a||this._shouldRecalculate(k,j)){const it=this.$.insertionPoint.assignedNodes({flatten:!0}).filter(at=>at.nodeType===Node.ELEMENT_NODE);this._addStyleNames(k,j);const nt=this._parseBoardCols(it),ot=nt.reduce((at,lt)=>at+lt,0);this._removeExtraNodesFromDOM(nt,it).forEach((at,lt)=>{const ct=this._calculateFlexBasis(nt[lt],k,ot,j);(a||!this._oldFlexBasis[lt]||this._oldFlexBasis[lt]!==ct)&&(this._oldFlexBasis[lt]=ct,at.style.flexBasis=ct)}),this._oldWidth=k,this._oldBreakpoints=j}}_shouldRecalculate(a,k){return isElementHidden(this)?!1:a!==this._oldWidth||k.smallSize!==this._oldBreakpoints.smallSize||k.mediumSize!==this._oldBreakpoints.mediumSize}_measureBreakpointsInPx(){const a={},k="background-position",j=getComputedStyle(this).getPropertyValue("--small-size"),et=getComputedStyle(this).getPropertyValue("--medium-size");return this.style.setProperty(k,j),a.smallSize=parseFloat(getComputedStyle(this).getPropertyValue(k)),this.style.setProperty(k,et),a.mediumSize=parseFloat(getComputedStyle(this).getPropertyValue(k)),this.style.removeProperty(k),a}};/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */class BoardRow extends BoardRowMixin(ElementMixin(PolymerElement)){static get template(){return html$3`
      <style>
        :host {
          display: flex;
          flex-flow: row wrap;
          align-items: stretch;
          --small-size: var(--vaadin-board-width-small, 600px);
          --medium-size: var(--vaadin-board-width-medium, 960px);
        }

        :host([hidden]) {
          display: none !important;
        }

        :host ::slotted(*) {
          box-sizing: border-box;
          flex-grow: 1;
          overflow: hidden;
        }
      </style>
      <slot id="insertionPoint"></slot>
    `}static get is(){return"vaadin-board-row"}}defineCustomElement(BoardRow);/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */class Board extends ElementMixin(PolymerElement){static get template(){return html$3`
      <style>
        :host {
          display: block;
        }

        :host([hidden]) {
          display: none !important;
        }
      </style>
      <slot></slot>
    `}static get is(){return"vaadin-board"}static get cvdlName(){return"vaadin-board"}redraw(){[...this.querySelectorAll("*")].filter(y=>y instanceof BoardRow).forEach(y=>y.redraw())}}defineCustomElement(Board);const cardProps=i`
  html {
    --vaadin-card-background: var(--lumo-contrast-5pct);
    --vaadin-card-border-radius: var(--lumo-border-radius-l);
    --vaadin-card-border-width: 0;
    --vaadin-card-border-color: var(--lumo-contrast-20pct);
    --vaadin-card-padding: var(--lumo-space-m);
    --vaadin-card-gap: var(--lumo-space-m);
    --vaadin-card-shadow: none;
  }
`;addGlobalThemeStyles("card-props",cardProps);const card=i`
  :host {
    background: var(--vaadin-card-background);
    border-radius: var(--vaadin-card-border-radius);
    box-shadow: var(--vaadin-card-shadow);
    position: relative;
  }

  /* Could be an inset outline on the host as well, but rounded outlines only work since Safari 16.4 */
  :host::before {
    content: '';
    position: absolute;
    inset: var(--_card-border-inset, 0);
    border-radius: var(--_card-border-pseudo-radius, inherit);
    border: var(--vaadin-card-border, var(--vaadin-card-border-width) solid var(--vaadin-card-border-color));
    pointer-events: none;
  }

  :host([theme~='outlined']) {
    --vaadin-card-border-width: 1px;
    --vaadin-card-background: var(--lumo-base-color);
  }

  :host([theme~='elevated']) {
    --vaadin-card-background: linear-gradient(var(--lumo-tint-5pct), var(--lumo-tint-5pct)) var(--lumo-base-color);
    --vaadin-card-shadow: var(--lumo-box-shadow-xs);
    --vaadin-card-border-width: 1px;
    --_card-border-inset: calc(-1 * var(--vaadin-card-border-width));
    --_card-border-pseudo-radius: calc(var(--vaadin-card-border-radius) + var(--vaadin-card-border-width));
  }

  :host([theme~='elevated']:not([theme~='outlined'])) {
    --vaadin-card-border-color: var(--lumo-contrast-10pct);
  }

  :host(:where([theme~='stretch-media'])) ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
    border-radius: var(--lumo-border-radius-m);
  }

  ::slotted([slot='title']) {
    font-size: var(--lumo-font-size-l);
    line-height: var(--lumo-line-height-xs);
    font-weight: 600;
    color: var(--lumo-header-text-color);
  }

  ::slotted([slot='subtitle']) {
    font-size: var(--lumo-font-size-m);
    line-height: var(--lumo-line-height-xs);
    color: var(--lumo-secondary-text-color);
  }
`;registerStyles$1("vaadin-card",card,{moduleId:"lumo-card"});/**
 * @license
 * Copyright (c) 2024 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class Card extends ElementMixin(ThemableMixin(PolylitMixin(i$1))){static get is(){return"vaadin-card"}static get styles(){return i`
      :host {
        display: flex;
        flex-direction: column;
        box-sizing: border-box;
        padding: var(--_padding);
        gap: var(--_gap);
        --_padding: var(--vaadin-card-padding, 1em);
        --_gap: var(--vaadin-card-gap, 1em);
        --_media: 0;
        --_title: 0;
        --_subtitle: 0;
        --_header: max(var(--_header-prefix), var(--_title), var(--_subtitle), var(--_header-suffix));
        --_header-prefix: 0;
        --_header-suffix: 0;
        --_content: 0;
        --_footer: 0;
      }

      :host([hidden]) {
        display: none !important;
      }

      :host(:not([theme~='horizontal'])) {
        justify-content: space-between;
      }

      :host([_m]) {
        --_media: 1;
      }

      :host([_t]) {
        --_title: 1;
      }

      :host([_st]) {
        --_subtitle: 1;
      }

      :host([_h]) {
        --_header: 1;
        --_title: 0;
        --_subtitle: 0;
      }

      :host([_hp]) {
        --_header-prefix: 1;
      }

      :host([_hs]) {
        --_header-suffix: 1;
      }

      :host([_c]) {
        --_content: 1;
      }

      :host([_f]) {
        --_footer: 1;
      }

      [part='media'],
      [part='header'],
      [part='content'],
      [part='footer'] {
        display: none;
      }

      :host([_m]) [part='media'],
      :host([_c]) [part='content'] {
        display: block;
      }

      :host([_f]) [part='footer'] {
        display: flex;
        gap: var(--_gap);
      }

      :host(:is([_h], [_t], [_st], [_hp], [_hs])) [part='header'] {
        display: grid;
        align-items: center;
        gap: var(--_gap);
        row-gap: 0;
      }

      [part='header'] {
        margin-bottom: auto;
      }

      :host([_hs]) [part='header'] {
        grid-template-columns: 1fr auto;
      }

      :host([_hp]) [part='header'] {
        grid-template-columns: repeat(var(--_header-prefix), auto) 1fr;
      }

      slot {
        border-radius: inherit;
      }

      ::slotted([slot='header-prefix']) {
        grid-column: 1;
        grid-row: 1 / span calc(var(--_title) + var(--_subtitle));
      }

      ::slotted([slot='header']),
      ::slotted([slot='title']) {
        grid-column: calc(1 + var(--_header-prefix));
        grid-row: 1;
      }

      ::slotted([slot='subtitle']) {
        grid-column: calc(1 + var(--_header-prefix));
        grid-row: calc(1 + var(--_title));
      }

      ::slotted([slot='header-suffix']) {
        grid-column: calc(2 + var(--_header-prefix));
        grid-row: 1 / span calc(var(--_title) + var(--_subtitle));
      }

      /* Horizontal */
      :host([theme~='horizontal']) {
        display: grid;
        grid-template-columns: repeat(var(--_media), minmax(auto, max-content)) 1fr;
        align-items: start;
      }

      :host([theme~='horizontal'][_f]) {
        grid-template-rows: 1fr auto;
      }

      :host([theme~='horizontal'][_c]) {
        grid-template-rows: repeat(var(--_header), auto) 1fr;
      }

      [part='media'] {
        grid-column: 1;
        grid-row: 1 / span calc(var(--_header) + var(--_content) + var(--_footer));
        align-self: stretch;
        border-radius: inherit;
      }

      [part='header'] {
        grid-column: calc(1 + var(--_media));
        grid-row: 1;
      }

      [part='content'] {
        grid-column: calc(1 + var(--_media));
        grid-row: calc(1 + var(--_header));
        flex: auto;
        min-height: 0;
      }

      [part='footer'] {
        grid-column: calc(1 + var(--_media));
        grid-row: calc(1 + var(--_header) + var(--_content));
        border-radius: inherit;
      }

      :host([theme~='horizontal']) [part='footer'] {
        align-self: end;
      }

      :host(:not([theme~='horizontal'])) ::slotted([slot='media']:is(img, video, svg)) {
        max-width: 100%;
      }

      ::slotted([slot='media']) {
        vertical-align: middle;
      }

      :host(:is([theme~='cover-media'], [theme~='stretch-media']))
        ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
        width: 100%;
        height: auto;
        aspect-ratio: var(--vaadin-card-media-aspect-ratio, 16/9);
        object-fit: cover;
        /* Fixes an issue where an icon overflows the card boundaries on Firefox: https://github.com/vaadin/web-components/issues/8641 */
        overflow: hidden;
      }

      :host([theme~='horizontal']:is([theme~='cover-media'], [theme~='stretch-media'])) {
        grid-template-columns: repeat(var(--_media), minmax(auto, 0.5fr)) 1fr;
      }

      :host([theme~='horizontal']:is([theme~='cover-media'], [theme~='stretch-media']))
        ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
        height: 100%;
        aspect-ratio: auto;
      }

      :host([theme~='cover-media']) ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
        margin-top: calc(var(--_padding) * -1);
        margin-inline: calc(var(--_padding) * -1);
        width: calc(100% + var(--_padding) * 2);
        max-width: none;
        border-radius: inherit;
        border-end-end-radius: 0;
        border-end-start-radius: 0;
      }

      :host([theme~='horizontal'][theme~='cover-media']) ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
        margin-inline-end: 0;
        width: calc(100% + var(--_padding));
        height: calc(100% + var(--_padding) * 2);
        border-radius: inherit;
        border-start-end-radius: 0;
        border-end-end-radius: 0;
      }

      /* Scroller in content */
      [part='content'] ::slotted(vaadin-scroller) {
        margin-inline: calc(var(--_padding) * -1);
        padding-inline: var(--_padding);
      }

      [part='content'] ::slotted(vaadin-scroller)::before,
      [part='content'] ::slotted(vaadin-scroller)::after {
        margin-inline: calc(var(--_padding) * -1);
      }
    `}static get properties(){return{cardTitle:{type:String,observer:"__cardTitleChanged"},titleHeadingLevel:{type:Number,reflectToAttribute:!0,observer:"__titleHeadingLevelChanged"}}}ready(){super.ready(),this.hasAttribute("role")||this.setAttribute("role","region")}render(){return x`
      <div part="media">
        <slot name="media"></slot>
      </div>
      <div part="header">
        <slot name="header-prefix"></slot>
        <slot name="header">
          <slot name="title"></slot>
          <slot name="subtitle"></slot>
        </slot>
        <slot name="header-suffix"></slot>
      </div>
      <div part="content">
        <slot></slot>
      </div>
      <div part="footer">
        <slot name="footer"></slot>
      </div>
    `}_onSlotChange(){this.toggleAttribute("_m",this.querySelector(':scope > [slot="media"]')),this.toggleAttribute("_h",this.querySelector(':scope > [slot="header"]')),this.toggleAttribute("_t",this.querySelector(':scope > [slot="title"]')&&!this.querySelector(':scope > [slot="header"]')),this.toggleAttribute("_st",this.querySelector(':scope > [slot="subtitle"]')&&!this.querySelector(':scope > [slot="header"]')),this.toggleAttribute("_hp",this.querySelector(':scope > [slot="header-prefix"]')),this.toggleAttribute("_hs",this.querySelector(':scope > [slot="header-suffix"]')),this.toggleAttribute("_c",this.querySelector(":scope > :not([slot])")),this.toggleAttribute("_f",this.querySelector(':scope > [slot="footer"]')),this.__getCustomTitleElement()&&this.__clearStringTitle()}__clearStringTitle(){const y=this.__getStringTitleElement();y&&this.removeChild(y);const a=this.getAttribute("aria-labelledby");a&&a.startsWith("card-title-")&&this.removeAttribute("aria-labelledby"),this.cardTitle&&(this.cardTitle="")}__getCustomTitleElement(){return Array.from(this.querySelectorAll('[slot="title"]')).find(y=>!y.hasAttribute("card-string-title"))}__cardTitleChanged(y){if(!y){this.__clearStringTitle();return}const a=this.__getCustomTitleElement();a&&this.removeChild(a);let k=this.__getStringTitleElement();k||(k=this.__createStringTitleElement(),this.appendChild(k),this.setAttribute("aria-labelledby",k.id)),k.textContent=y}__createStringTitleElement(){const y=document.createElement("div");return y.setAttribute("slot","title"),y.setAttribute("role","heading"),this.__setTitleHeadingLevel(y,this.titleHeadingLevel),y.setAttribute("card-string-title",""),y.id=`card-title-${generateUniqueId()}`,y}__titleHeadingLevelChanged(y){const a=this.__getStringTitleElement();a&&this.__setTitleHeadingLevel(a,y)}__setTitleHeadingLevel(y,a){y.setAttribute("aria-level",a||2)}__getStringTitleElement(){return this.querySelector('[slot="title"][card-string-title]')}createRenderRoot(){const y=super.createRenderRoot();return y.addEventListener("slotchange",()=>this._onSlotChange()),y}}defineCustomElement(Card);/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */const chartBaseTheme=i`
  :host {
    font-family: -apple-system, BlinkMacSystemFont, 'Roboto', 'Segoe UI', Helvetica, Arial, sans-serif,
      'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol';
    font-size: 12px;
    line-height: normal;
  }

  .highcharts-container {
    position: relative;
    overflow: hidden;
    width: 100%;
    height: 100%;
    text-align: left;
    z-index: 0;
    /* #1072 */
    -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
  }

  :where([styled-mode]) .highcharts-root {
    display: block;
  }

  :where([styled-mode]) .highcharts-root text {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-strong {
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-emphasized {
    font-style: italic;
  }

  :where([styled-mode]) .highcharts-anchor {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-background {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-plot-border,
  :where([styled-mode]) .highcharts-plot-background {
    fill: none;
  }

  :where([styled-mode]) .highcharts-label-box {
    fill: none;
  }

  :where([styled-mode]) .highcharts-button-box {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-tracker-line {
    stroke-linejoin: round;
    stroke: rgba(192, 192, 192, 0.0001);
    stroke-width: 22;
    fill: none;
  }

  :where([styled-mode]) .highcharts-tracker-area {
    fill: rgba(192, 192, 192, 0.0001);
    stroke-width: 0;
  }

  /* Titles */
  :where([styled-mode]) .highcharts-title {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
    font-size: 1.5em;
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-subtitle {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  /* Axes */
  :where([styled-mode]) .highcharts-axis-line {
    fill: none;
    stroke: var(--vaadin-charts-axis-line, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-axis-title {
    fill: var(--vaadin-charts-axis-title, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-axis-labels {
    fill: var(--vaadin-charts-axis-label, hsla(214, 42%, 18%, 0.72));
    cursor: default;
    font-size: 0.9em;
  }

  :where([styled-mode]) .highcharts-grid-line {
    fill: none;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-xaxis-grid .highcharts-grid-line {
    stroke-width: var(--vaadin-charts-xaxis-line-width, 0px);
  }

  :where([styled-mode]) .highcharts-tick {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-tick {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-minor-grid-line {
    stroke: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-crosshair-thin {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-crosshair-category {
    stroke: var(--vaadin-charts-color-0, #5ac2f7);
    stroke-opacity: 0.25;
  }

  /* Credits */
  :where([styled-mode]) .highcharts-credits {
    cursor: pointer;
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
    font-size: 0.7em;
    transition:
      fill 250ms,
      font-size 250ms;
  }

  :where([styled-mode]) .highcharts-credits:hover {
    fill: black;
    font-size: 1em;
  }

  /* Tooltip */
  :where([styled-mode]) .highcharts-tooltip {
    cursor: default;
    pointer-events: none;
    white-space: nowrap;
    transition: stroke 150ms;
  }

  :where([styled-mode]) .highcharts-tooltip {
    filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.05)) !important;
  }

  :where([styled-mode]) .highcharts-tooltip text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-tooltip .highcharts-header {
    font-size: 0.85em;
    color: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-tooltip-box {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-tooltip-border, inherit);
    fill: var(--vaadin-charts-tooltip-background, #fff);
    fill-opacity: var(--vaadin-charts-tooltip-background-opacity, 1);
  }

  :where([styled-mode]) .highcharts-tooltip-box .highcharts-label-box {
    fill: var(--vaadin-charts-tooltip-background, #fff);
    fill-opacity: var(--vaadin-charts-tooltip-background-opacity, 1);
  }

  :where([styled-mode]) .highcharts-tooltip-header {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) div.highcharts-tooltip {
    filter: none;
  }

  :where([styled-mode]) .highcharts-selection-marker {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    fill-opacity: 0.25;
  }

  :where([styled-mode]) .highcharts-graph {
    fill: none;
    stroke-width: 2px;
    stroke-linecap: round;
    stroke-linejoin: round;
  }

  :where([styled-mode]) .highcharts-state-hover .highcharts-graph {
    stroke-width: 3;
  }

  :where([styled-mode]) .highcharts-point-inactive {
    opacity: 0.2;
    transition: opacity 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-series-inactive {
    opacity: 0.2;
    transition: opacity 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-state-hover path {
    transition: stroke-width 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-state-normal path {
    transition: stroke-width 250ms;
    /* slow out */
  }

  /* Legend hover affects points and series */
  :where([styled-mode]) g.highcharts-series,
  :where([styled-mode]) .highcharts-point,
  :where([styled-mode]) .highcharts-markers,
  :where([styled-mode]) .highcharts-data-labels {
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-legend-series-active g.highcharts-series:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-point-active .highcharts-point:not(.highcharts-point-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-markers:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-data-labels:not(.highcharts-series-hover) {
    opacity: 0.2;
  }

  /* Series options */
  /* Default colors */
  /* vaadin-charts custom properties */
  /* Use of :where() function to avoid setting classes with high specificity */
  :where([styled-mode]) .highcharts-color-0 {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    stroke: var(--vaadin-charts-color-0, #5ac2f7);
  }

  :where([styled-mode]) .highcharts-color-1 {
    fill: var(--vaadin-charts-color-1, #1676f3);
    stroke: var(--vaadin-charts-color-1, #1676f3);
  }

  :where([styled-mode]) .highcharts-color-2 {
    fill: var(--vaadin-charts-color-2, #ff7d94);
    stroke: var(--vaadin-charts-color-2, #ff7d94);
  }

  :where([styled-mode]) .highcharts-color-3 {
    fill: var(--vaadin-charts-color-3, #c5164e);
    stroke: var(--vaadin-charts-color-3, #c5164e);
  }

  :where([styled-mode]) .highcharts-color-4 {
    fill: var(--vaadin-charts-color-4, #15c15d);
    stroke: var(--vaadin-charts-color-4, #15c15d);
  }

  :where([styled-mode]) .highcharts-color-5 {
    fill: var(--vaadin-charts-color-5, #0e8151);
    stroke: var(--vaadin-charts-color-5, #0e8151);
  }

  :where([styled-mode]) .highcharts-color-6 {
    fill: var(--vaadin-charts-color-6, #c18ed2);
    stroke: var(--vaadin-charts-color-6, #c18ed2);
  }

  :where([styled-mode]) .highcharts-color-7 {
    fill: var(--vaadin-charts-color-7, #9233b3);
    stroke: var(--vaadin-charts-color-7, #9233b3);
  }

  :where([styled-mode]) .highcharts-color-8 {
    fill: var(--vaadin-charts-color-8, #fda253);
    stroke: var(--vaadin-charts-color-8, #fda253);
  }

  :where([styled-mode]) .highcharts-color-9 {
    fill: var(--vaadin-charts-color-9, #e24932);
    stroke: var(--vaadin-charts-color-9, #e24932);
  }

  /* end of vaadin-charts custom properties */

  :where([styled-mode]) .highcharts-area {
    fill-opacity: 0.5;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-markers {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode])
    .highcharts-a11y-markers-hidden
    .highcharts-point:not(.highcharts-point-hover):not(.highcharts-a11y-marker-visible),
  :where([styled-mode]) .highcharts-a11y-marker-hidden {
    opacity: 0;
  }

  :where([styled-mode]) .highcharts-point {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-dense-data .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label {
    font-size: 0.9em;
    font-weight: normal;
  }

  :where([styled-mode]) .highcharts-data-label-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label text,
  :where([styled-mode]) text.highcharts-data-label {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-data-label-connector {
    fill: none;
  }

  :where([styled-mode]) .highcharts-data-label-hidden {
    pointer-events: none;
  }

  :where([styled-mode]) .highcharts-halo {
    fill-opacity: 0.25;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-series:not(.highcharts-pie-series) .highcharts-point-select,
  :where([styled-mode]) .highcharts-markers .highcharts-point-select {
    fill: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-column-series rect.highcharts-point {
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point {
    transition: fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-solidgauge-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point {
    stroke-width: 2px;
    stroke: var(--vaadin-charts-background, #fff);
    transition:
      stroke 250ms,
      fill 250ms,
      fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point-hover {
    stroke-width: 0px;
    stroke: var(--vaadin-charts-background, #fff);
    fill-opacity: 0.75;
    transition:
      stroke 25ms,
      fill 25ms,
      fill-opacity 25ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-above-level {
    display: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node {
    fill: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive {
    fill-opacity: 0.15;
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive:hover {
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-vector-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-windbarb-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-lollipop-stem {
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-focus-border {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-legend-item-hidden .highcharts-focus-border {
    fill: none !important;
  }

  /* Legend */
  :where([styled-mode]) .highcharts-legend-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    font-weight: normal;
    font-size: 1em;
    cursor: pointer;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > .highcharts-point {
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-legend-item:hover text {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-legend-item-hidden * {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26)) !important;
    stroke: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26)) !important;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-legend-nav-active {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-legend-nav-inactive {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
  }

  :where([styled-mode]) circle.highcharts-legend-nav-active,
  :where([styled-mode]) circle.highcharts-legend-nav-inactive {
    /* tracker */
    fill: rgba(192, 192, 192, 0.0001);
  }

  :where([styled-mode]) .highcharts-legend-title-box {
    fill: none;
    stroke-width: 0;
  }

  /* Bubble legend */
  :where([styled-mode]) .highcharts-bubble-legend-symbol {
    stroke-width: 2;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-bubble-legend-connectors {
    stroke-width: 1;
  }

  :where([styled-mode]) .highcharts-bubble-legend-labels {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  /* Loading */
  :where([styled-mode]) .highcharts-loading {
    position: absolute;
    background-color: var(--vaadin-charts-background, #fff);
    opacity: 0.5;
    text-align: center;
    z-index: 10;
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-loading-hidden {
    height: 0 !important;
    opacity: 0;
    overflow: hidden;
    transition:
      opacity 250ms,
      height 250ms step-end;
  }

  :where([styled-mode]) .highcharts-loading-inner {
    font-weight: normal;
    position: relative;
    top: 45%;
  }

  /* Plot bands and polar pane backgrounds */
  :where([styled-mode]) .highcharts-plot-band,
  :where([styled-mode]) .highcharts-pane {
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-plot-line {
    fill: none;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-plot-line-label {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  /* Highcharts More and modules */
  :where([styled-mode]) .highcharts-boxplot-box {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-boxplot-median {
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-bubble-series .highcharts-point {
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-errorbar-series .highcharts-point {
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-data-label-box {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-dial {
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-polygon-series .highcharts-graph {
    fill: inherit;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-waterfall-series .highcharts-graph {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-dasharray: 1, 3;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-link {
    transition:
      fill 250ms,
      fill-opacity 250ms;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point-hover.highcharts-link {
    transition:
      fill 50ms,
      fill-opacity 50ms;
    fill-opacity: 1;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point {
    fill-opacity: 0.75;
    stroke: var(--vaadin-charts-background, #fff);
    transition:
      stroke 250ms,
      fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point-hover {
    fill-opacity: 1;
    stroke: var(--vaadin-charts-background, #fff);
  }

  /* Highstock */
  :where([styled-mode]) .highcharts-navigator-mask-outside {
    fill-opacity: 0;
  }

  :where([styled-mode]) .highcharts-navigator-mask-inside {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    /* navigator.maskFill option */
    fill-opacity: 0.2;
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-outline {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    fill: none;
  }

  :where([styled-mode]) .highcharts-navigator-handle {
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
    fill: var(--vaadin-charts-background, #fff);
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-series {
    fill: var(--vaadin-charts-color-1, #1676f3);
    stroke: var(--vaadin-charts-color-1, #1676f3);
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-graph {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-area {
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-grid-line {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-navigator-xaxis.highcharts-axis-labels {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-navigator-yaxis .highcharts-grid-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-scrollbar-thumb {
    fill: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-scrollbar-button {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-scrollbar-arrow {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-scrollbar-rifles {
    stroke: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-scrollbar-track {
    fill: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-button {
    fill: var(--vaadin-charts-button-background, hsla(214, 61%, 25%, 0.05));
    cursor: default;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-button text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-button-hover {
    transition: fill 0ms;
    fill: var(--vaadin-charts-button-hover-background, hsla(214, 90%, 52%, 0.1));
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-button-hover text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-button-pressed {
    fill: var(--vaadin-charts-button-active-background, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-button-pressed text {
    fill: var(--vaadin-charts-button-active-label, #fff);
  }

  :where([styled-mode]) .highcharts-button-disabled text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-range-selector-buttons > text {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-range-selector-buttons .highcharts-button {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-range-label rect {
    fill: none;
  }

  :where([styled-mode]) .highcharts-range-label text {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-range-input rect {
    fill: var(--vaadin-charts-contrast-10pct, hsla(214, 57%, 24%, 0.1));
    rx: 2;
    ry: 2;
  }

  :where([styled-mode]) .highcharts-range-input:hover rect {
    fill: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-range-input text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) input.highcharts-range-selector {
    position: absolute;
    border: 0;
    width: 1px;
    /* Chrome needs a pixel to see it */
    height: 1px;
    padding: 0;
    text-align: center;
    left: -9em;
    /* #4798 */
  }

  :where([styled-mode]) .highcharts-crosshair-label text {
    fill: var(--vaadin-charts-background, #fff);
    font-size: 1.1em;
  }

  :where([styled-mode]) .highcharts-crosshair-label .highcharts-label-box {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-up {
    fill: var(--vaadin-charts-color-positive, #15c15d);
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-down {
    fill: var(--vaadin-charts-color-negative, #e24932);
  }

  :where([styled-mode]) .highcharts-ohlc-series .highcharts-point-hover {
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point .highcharts-label-box {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    fill: var(--vaadin-charts-background, #fff);
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover .highcharts-label-box {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    font-size: 0.9em;
    font-weight: normal;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover text {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
  }

  /* Highmaps */
  :where([styled-mode]) .highcharts-map-series .highcharts-point {
    transition:
      fill 500ms,
      fill-opacity 500ms,
      stroke-width 250ms;
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-map-series .highcharts-point-hover {
    transition:
      fill 0ms,
      fill-opacity 0ms;
    fill-opacity: 0.5;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-mapline-series .highcharts-point {
    fill: none;
  }

  :where([styled-mode]) .highcharts-heatmap-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-map-navigation {
    font-size: 1.3em;
    font-weight: normal;
    text-align: center;
  }

  :where([styled-mode]) .highcharts-coloraxis {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-coloraxis-grid .highcharts-grid-line {
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-coloraxis-marker {
    fill: var(--vaadin-charts-axis-label, hsla(214, 42%, 18%, 0.72));
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-null-point {
    fill: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  /* 3d charts */
  :where([styled-mode]) .highcharts-3d-frame {
    fill: transparent;
  }

  /* Exporting module */
  :where([styled-mode]) .highcharts-contextbutton {
    fill: #fff;
    /* needed to capture hover */
    stroke: none;
    stroke-linecap: round;
  }

  :where([styled-mode]) .highcharts-contextbutton:hover {
    fill: #e6e6e6;
    stroke: #e6e6e6;
  }

  :where([styled-mode]) .highcharts-button-symbol {
    stroke: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-menu {
    border: 1px solid #999;
    background: #fff;
    padding: 5px 0;
    box-shadow: 3px 3px 10px #888;
  }

  :where([styled-mode]) .highcharts-menu-item {
    padding: 0.5em 1em;
    background: none;
    color: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    cursor: pointer;
    transition:
      background 250ms,
      color 250ms;
  }

  :where([styled-mode]) .highcharts-menu-item:hover {
    background: #335cad;
    color: #fff;
  }

  /* Drilldown module */
  :where([styled-mode]) .highcharts-drilldown-point {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-drilldown-data-label text,
  :where([styled-mode]) text.highcharts-drilldown-data-label,
  :where([styled-mode]) .highcharts-drilldown-axis-label {
    cursor: pointer;
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    font-weight: normal;
    text-decoration: underline;
  }

  /* No-data module */
  :where([styled-mode]) .highcharts-no-data text {
    font-weight: normal;
    font-size: 1rem;
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  /* Drag-panes module */
  :where([styled-mode]) .highcharts-axis-resizer {
    cursor: ns-resize;
    stroke: black;
    stroke-width: 2px;
  }

  /* Bullet type series */
  :where([styled-mode]) .highcharts-bullet-target {
    stroke-width: 0;
  }

  /* Lineargauge type series */
  :where([styled-mode]) .highcharts-lineargauge-target {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  :where([styled-mode]) .highcharts-lineargauge-target-line {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  /* Annotations module */
  :where([styled-mode]) .highcharts-annotation-label-box {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-annotation-label text {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
  }

  /* Gantt */
  :where([styled-mode]) .highcharts-treegrid-node-collapsed,
  :where([styled-mode]) .highcharts-treegrid-node-expanded {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-point-connecting-path {
    fill: none;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-tick {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-axis-line {
    stroke-width: 1px;
  }

  /* Workaround for https://github.com/highcharts/highcharts/issues/22490 */
  :where([styled-mode]) .highcharts-gantt-series .highcharts-partfill-overlay {
    fill: hsla(0, 0%, 0%, 0.3);
    stroke: hsla(0, 0%, 0%, 0.3);
  }

  /* RTL styles */
  :host([dir='rtl']) :where([styled-mode]) .highcharts-container {
    text-align: right;
  }

  :host([dir='rtl']) :where([styled-mode]) input.highcharts-range-selector {
    left: auto;
    right: -9em;
  }

  :host([dir='rtl']) :where([styled-mode]) .highcharts-menu {
    box-shadow: -3px 3px 10px #888;
  }

  /* https://github.com/highcharts/highcharts/issues/16282 */
  /* without this the resize callback always calls __reflow */
  ul[aria-hidden='false'] {
    margin: 0px;
  }
`;registerStyles$1("vaadin-chart",chartBaseTheme,{moduleId:"vaadin-chart-base-theme"});const chartColors=i`
  :host {
    --vaadin-charts-color-0: #5ac2f7;
    --vaadin-charts-color-1: #1676f3;
    --vaadin-charts-color-2: #ff7d94;
    --vaadin-charts-color-3: #c5164e;
    --vaadin-charts-color-4: #15c15d;
    --vaadin-charts-color-5: #0e8151;
    --vaadin-charts-color-6: #c18ed2;
    --vaadin-charts-color-7: #9233b3;
    --vaadin-charts-color-8: #fda253;
    --vaadin-charts-color-9: #e24932;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-4, #15c15d);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-9, #e24932);
  }

  :host([theme~='gradient']) {
    --vaadin-charts-color-0: #1676f3;
    --vaadin-charts-color-1: #13bbf0;
    --vaadin-charts-color-2: #1ee;
    --vaadin-charts-color-3: #0cd9bf;
    --vaadin-charts-color-4: #06be81;
    --vaadin-charts-color-5: #00a344;
    --vaadin-charts-color-6: #41c639;
    --vaadin-charts-color-7: #8aed2c;
    --vaadin-charts-color-8: #c0e632;
    --vaadin-charts-color-9: #f6db3a;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-6);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-1);
  }

  :host([theme~='monotone']) {
    --vaadin-charts-color-0: #1676f3;
    --vaadin-charts-color-1: #4795f5;
    --vaadin-charts-color-2: #71b0f7;
    --vaadin-charts-color-3: #a0cef9;
    --vaadin-charts-color-4: #bce0fa;
    --vaadin-charts-color-5: #a8d8ed;
    --vaadin-charts-color-6: #7fc3dd;
    --vaadin-charts-color-7: #54adcc;
    --vaadin-charts-color-8: #2b99bc;
    --vaadin-charts-color-9: #0284ac;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-3);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-9);
  }

  :host([theme~='classic']) {
    --vaadin-charts-color-0: #7cb5ec;
    --vaadin-charts-color-1: #434348;
    --vaadin-charts-color-2: #90ed7d;
    --vaadin-charts-color-3: #f7a35c;
    --vaadin-charts-color-4: #8085e9;
    --vaadin-charts-color-5: #f15c80;
    --vaadin-charts-color-6: #e4d354;
    --vaadin-charts-color-7: #2b908f;
    --vaadin-charts-color-8: #f45b5b;
    --vaadin-charts-color-9: #91e8e1;
  }
`,chartTheme=i`
  :host {
    --vaadin-charts-background: var(--lumo-base-color);
    --vaadin-charts-title-label: var(--lumo-header-text-color);
    --vaadin-charts-axis-title: var(--lumo-secondary-text-color);
    --vaadin-charts-axis-label: var(--lumo-secondary-text-color);
    --vaadin-charts-data-label: var(--lumo-body-text-color);
    --vaadin-charts-secondary-label: var(--lumo-secondary-text-color);
    --vaadin-charts-axis-line: var(--lumo-contrast-5pct);
    --vaadin-charts-grid-line: var(--lumo-contrast-20pct);
    --vaadin-charts-disabled-label: var(--lumo-disabled-text-color);
    --vaadin-charts-contrast: var(--lumo-contrast);
    --vaadin-charts-contrast-5pct: var(--lumo-contrast-5pct);
    --vaadin-charts-contrast-10pct: var(--lumo-contrast-10pct);
    --vaadin-charts-contrast-20pct: var(--lumo-contrast-20pct);
    --vaadin-charts-contrast-60pct: var(--lumo-contrast-60pct);
    --vaadin-charts-tooltip-background: var(--lumo-base-color);
    --vaadin-charts-tooltip-border-color: inherit;
    --vaadin-charts-button-label: var(--lumo-primary-text-color);
    --vaadin-charts-button-background: var(--lumo-contrast-5pct);
    --vaadin-charts-button-hover-background: var(--lumo-primary-color-10pct);
    --vaadin-charts-button-active-label: var(--lumo-primary-contrast-color);
    --vaadin-charts-button-active-background: var(--lumo-primary-color);
    --vaadin-charts-xaxis-line-width: 0;
    --vaadin-charts-tooltip-background-opacity: 1;
    font-family: var(--lumo-font-family);
  }
`;registerStyles$1("vaadin-chart",[chartColors,chartTheme],{moduleId:"lumo-chart"});function inflateFunctions(config){if(Array.isArray(config)){config.forEach(inflateFunctions);return}!(config instanceof Object)||config.constructor!==Object||Object.entries(config).forEach(([attr,targetProperty])=>{if(attr.startsWith("_fn_")&&(typeof targetProperty=="string"||targetProperty instanceof String)){try{config[attr.substr(4)]=eval(`(${targetProperty})`)}catch(_){config[attr.substr(4)]=eval(`(function(){${targetProperty}})`)}delete config[attr]}else targetProperty instanceof Object&&inflateFunctions(targetProperty)})}function deepMerge(z,y){const a=k=>k&&typeof k=="object"&&!Array.isArray(k);return a(y)&&a(z)&&Object.keys(y).forEach(k=>{a(y[k])?(z[k]||Object.assign(z,{[k]:{}}),deepMerge(z[k],y[k])):Object.assign(z,{[k]:y[k]})}),z}/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */const ChartSeriesMixin=z=>class extends z{static get properties(){return{values:{type:Array,value:()=>[],sync:!0},valueMin:{type:Number,reflectToAttribute:!0,sync:!0},valueMax:{type:Number,reflectToAttribute:!0,sync:!0},type:{type:String,reflectToAttribute:!0,sync:!0},title:{type:String,reflectToAttribute:!0,sync:!0},markers:{type:String,reflectToAttribute:!0,sync:!0},unit:{type:String,reflectToAttribute:!0,sync:!0},stack:{type:String,reflectToAttribute:!0,sync:!0},neckPosition:{type:String,reflectToAttribute:!0,sync:!0},neckWidth:{type:String,reflectToAttribute:!0,sync:!0},options:{type:Object,sync:!0},additionalOptions:{type:Object,reflectToAttribute:!0,sync:!0},_series:{type:Object,sync:!0}}}static get observers(){return["__additionalOptionsObserver(additionalOptions, _series)","__markersObserver(markers, _series)","__neckPositionObserver(neckPosition, _series)","__neckWidthObserver(neckWidth, _series)","__stackObserver(stack, _series)","__titleObserver(title, _series)","__typeObserver(type, _series)","__unitObserver(unit, valueMin, valueMax, _series)","__valueMinObserver(valueMin, _series)","__valueMaxObserver(valueMax, _series)","__valuesObserver(values, _series)"]}get options(){const y=deepMerge({},this.additionalOptions);return this.type&&(y.type=this.type),this.title&&(y.name=this.title),this.values&&(y.data=this.values),this.markers&&(this.__isMarkersValid()||(this.markers="auto"),y.marker=this.__markersConfiguration),this.unit&&(y.yAxis=this.unit),this.stack&&(y.stack=this.stack),isFinite(this.valueMin)&&(y.yAxisValueMin=this.valueMin),isFinite(this.valueMax)&&(y.yAxisValueMax=this.valueMax),this.neckWidth&&(y.neckWidth=this.neckWidth),this.neckPosition&&(y.neckHeight=this.neckPosition),y}get __markersConfiguration(){const y={};switch(this.markers){case"shown":y.enabled=!0;break;case"hidden":y.enabled=!1;break;case"auto":default:y.enabled=null;break}return y}setSeries(y){this._series=y}__valuesObserver(y,a){a&&a.setData(y)}__additionalOptionsObserver(y,a){a&&y&&a.update(y)}__updateAxis(y,a,k){if(!isFinite(a)){this.__showWarn(`value-${k}`,"Numbers or null");return}y&&y.yAxis&&y.yAxis.update({[k]:a})}__valueMinObserver(y,a){y===void 0||a==null||this.__updateAxis(a,y,"min")}__valueMaxObserver(y,a){y===void 0||a==null||this.__updateAxis(a,y,"max")}__typeObserver(y,a){y&&a&&a.update({type:y})}__titleObserver(y,a){y===void 0||a==null||a.update({name:y})}__stackObserver(y,a){y===void 0||a==null||a.update({stack:y})}__neckPositionObserver(y,a){y===void 0||a==null||a.update({neckHeight:y})}__neckWidthObserver(y,a){y===void 0||a==null||a.update({neckWidth:y})}__unitObserver(y,a,k,j){if(j&&y!==this.__oldUnit){const et=customElements.get("vaadin-chart");this.__oldUnit=y;const it=this.parentNode instanceof et&&this.parentNode;if(it&&it instanceof et){if(y&&!it.__getAxis(y)){const nt={title:{text:y}};it.__addAxis({id:y,axisGenerated:!0,...nt})}j.update({yAxis:y||0}),a!==void 0&&this.__updateAxis(j,a,"min"),k!==void 0&&this.__updateAxis(j,k,"max"),it.__removeAxisIfEmpty()}}}__isMarkersValid(){return["shown","hidden","auto"].indexOf(this.markers)===-1?(this.__showWarn("markers",'"shown", "hidden" or "auto"'),!1):!0}__markersObserver(y,a){if(!(y===void 0||a==null)){if(!this.__isMarkersValid()){this.markers="auto";return}a.update({marker:this.__markersConfiguration})}}__showWarn(y,a){console.warn(`<vaadin-chart-series> Acceptable values for "${y}" are ${a}`)}};/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */class ChartSeries extends ChartSeriesMixin(PolymerElement){static get is(){return"vaadin-chart-series"}}defineCustomElement(ChartSeries);var w=typeof win<"u"?win:typeof window<"u"?window:{},Globals;(function(z){z.SVG_NS="http://www.w3.org/2000/svg",z.product="Highcharts",z.version="9.2.2",z.win=w,z.doc=z.win.document,z.svg=z.doc&&z.doc.createElementNS&&!!z.doc.createElementNS(z.SVG_NS,"svg").createSVGRect,z.userAgent=z.win.navigator&&z.win.navigator.userAgent||"",z.isChrome=z.userAgent.indexOf("Chrome")!==-1,z.isFirefox=z.userAgent.indexOf("Firefox")!==-1,z.isMS=/(edge|msie|trident)/i.test(z.userAgent)&&!z.win.opera,z.isSafari=!z.isChrome&&z.userAgent.indexOf("Safari")!==-1,z.isTouchDevice=/(Mobile|Android|Windows Phone)/.test(z.userAgent),z.isWebKit=z.userAgent.indexOf("AppleWebKit")!==-1,z.deg2rad=Math.PI*2/360,z.hasBidiBug=z.isFirefox&&parseInt(z.userAgent.split("Firefox/")[1],10)<4,z.hasTouch=!!z.win.TouchEvent,z.marginNames=["plotTop","marginRight","marginBottom","plotLeft"],z.noop=function(){},z.supportsPassiveEvents=(function(){var y=!1;if(!z.isMS){var a=Object.defineProperty({},"passive",{get:function(){y=!0}});z.win.addEventListener&&z.win.removeEventListener&&(z.win.addEventListener("testPassive",z.noop,a),z.win.removeEventListener("testPassive",z.noop,a))}return y})(),z.charts=[],z.dateFormats={},z.seriesTypes={},z.symbolSizes={},z.chartCount=0})(Globals||(Globals={}));const H=Globals;var charts$5=H.charts,doc$m=H.doc,win$g=H.win;function error$c(z,y,a,k){var j=y?"Highcharts error":"Highcharts warning";z===32&&(z=j+": Deprecated member");var et=isNumber$X(z),it=et?j+" #"+z+": www.highcharts.com/errors/"+z+"/":z.toString(),nt=function(){if(y)throw new Error(it);win$g.console&&error$c.messages.indexOf(it)===-1&&console.warn(it)};if(typeof k<"u"){var ot="";et&&(it+="?"),objectEach$D(k,function(at,lt){ot+=`
 - `+lt+": "+at,et&&(it+=encodeURI(lt)+"="+encodeURI(at))}),it+=ot}fireEvent$C(H,"displayError",{chart:a,code:z,message:it,params:k},nt),error$c.messages.push(it)}(function(z){z.messages=[]})(error$c||(error$c={}));function merge$1x(){var z,y=arguments,a={},k=function(et,it){return typeof et!="object"&&(et={}),objectEach$D(it,function(nt,ot){ot==="__proto__"||ot==="constructor"||(isObject$i(nt,!0)&&!isClass(nt)&&!isDOMElement(nt)?et[ot]=k(et[ot]||{},nt):et[ot]=it[ot])}),et};y[0]===!0&&(a=y[1],y=Array.prototype.slice.call(y,2));var j=y.length;for(z=0;z<j;z++)a=k(a,y[z]);return a}function clamp$l(z,y,a){return z>y?z<a?z:a:y}function cleanRecursively$2(z,y){var a={};return objectEach$D(z,function(k,j){var et;isObject$i(z[j],!0)&&!z.nodeType&&y[j]?(et=cleanRecursively$2(z[j],y[j]),Object.keys(et).length&&(a[j]=et)):(isObject$i(z[j])||z[j]!==y[j])&&(a[j]=z[j])}),a}function pInt$a(z,y){return parseInt(z,y||10)}function isString$d(z){return typeof z=="string"}function isArray$q(z){var y=Object.prototype.toString.call(z);return y==="[object Array]"||y==="[object Array Iterator]"}function isObject$i(z,y){return!!z&&typeof z=="object"&&(!y||!isArray$q(z))}function isDOMElement(z){return isObject$i(z)&&typeof z.nodeType=="number"}function isClass(z){var y=z&&z.constructor;return!!(isObject$i(z,!0)&&!isDOMElement(z)&&y&&y.name&&y.name!=="Object")}function isNumber$X(z){return typeof z=="number"&&!isNaN(z)&&z<1/0&&z>-1/0}function erase$a(z,y){for(var a=z.length;a--;)if(z[a]===y){z.splice(a,1);break}}function defined$_(z){return typeof z<"u"&&z!==null}function attr$8(z,y,a){var k;return isString$d(y)?defined$_(a)?z.setAttribute(y,a):z&&z.getAttribute&&(k=z.getAttribute(y),!k&&y==="class"&&(k=z.getAttribute(y+"Name"))):objectEach$D(y,function(j,et){z.setAttribute(et,j)}),k}function splat$l(z){return isArray$q(z)?z:[z]}function syncTimeout$9(z,y,a){return y>0?setTimeout(z,y,a):(z.call(0,a),-1)}function internalClearTimeout(z){defined$_(z)&&clearTimeout(z)}function extend$1y(z,y){var a;z||(z={});for(a in y)z[a]=y[a];return z}function pick$1K(){for(var z=arguments,y=z.length,a=0;a<y;a++){var k=z[a];if(typeof k<"u"&&k!==null)return k}}function css$d(z,y){H.isMS&&!H.svg&&y&&typeof y.opacity<"u"&&(y.filter="alpha(opacity="+y.opacity*100+")"),extend$1y(z.style,y)}function createElement$b(z,y,a,k,j){var et=doc$m.createElement(z);return y&&extend$1y(et,y),j&&css$d(et,{padding:"0",border:"none",margin:"0"}),a&&css$d(et,a),k&&k.appendChild(et),et}function extendClass$2(z,y){var a=(function(){});return a.prototype=new z,extend$1y(a.prototype,y),a}function pad$2(z,y,a){return new Array((y||2)+1-String(z).replace("-","").length).join(a||"0")+z}function relativeLength$a(z,y,a){return/%$/.test(z)?y*parseFloat(z)/100+(a||0):parseFloat(z)}function wrap$h(z,y,a){var k=z[y];z[y]=function(){var j=Array.prototype.slice.call(arguments),et=arguments,it=this;it.proceed=function(){k.apply(it,arguments.length?arguments:et)},j.unshift(k);var nt=a.apply(this,j);return it.proceed=null,nt}}function getMagnitude$3(z){return Math.pow(10,Math.floor(Math.log(z)/Math.LN10))}function normalizeTickInterval$3(z,y,a,k,j){var et,it=z;a=pick$1K(a,1);var nt=z/a;for(y||(y=j?[1,1.2,1.5,2,2.5,3,4,5,6,8,10]:[1,2,2.5,5,10],k===!1&&(a===1?y=y.filter(function(ot){return ot%1===0}):a<=.1&&(y=[1/a]))),et=0;et<y.length&&(it=y[et],!(j&&it*a>=z||!j&&nt<=(y[et]+(y[et+1]||y[et]))/2));et++);return it=correctFloat$d(it*a,-Math.round(Math.log(.001)/Math.LN10)),it}function stableSort$7(z,y){var a=z.length,k,j;for(j=0;j<a;j++)z[j].safeI=j;for(z.sort(function(et,it){return k=y(et,it),k===0?et.safeI-it.safeI:k}),j=0;j<a;j++)delete z[j].safeI}function arrayMin$9(z){for(var y=z.length,a=z[0];y--;)z[y]<a&&(a=z[y]);return a}function arrayMax$a(z){for(var y=z.length,a=z[0];y--;)z[y]>a&&(a=z[y]);return a}function destroyObjectProperties$a(z,y){objectEach$D(z,function(a,k){a&&a!==y&&a.destroy&&a.destroy(),delete z[k]})}function discardElement$7(z){garbageBin||(garbageBin=createElement$b("div")),z&&garbageBin.appendChild(z),garbageBin.innerHTML=""}var garbageBin;function correctFloat$d(z,y){return parseFloat(z.toPrecision(y||14))}var timeUnits$4={millisecond:1,second:1e3,minute:6e4,hour:36e5,day:24*36e5,week:168*36e5,month:672*36e5,year:364*24*36e5};Math.easeInOutSine=function(z){return-.5*(Math.cos(Math.PI*z)-1)};function getNestedProperty$3(z,y){for(var a=z.split(".");a.length&&defined$_(y);){var k=a.shift();if(typeof k>"u"||k==="__proto__")return;var j=y[k];if(!defined$_(j)||typeof j=="function"||typeof j.nodeType=="number"||j===win$g)return;y=j}return y}function getStyle$2(z,y,a){var k=H.getStyle||getStyle$2,j;if(y==="width"){var et=Math.min(z.offsetWidth,z.scrollWidth),it=z.getBoundingClientRect&&z.getBoundingClientRect().width;return it<et&&it>=et-1&&(et=Math.floor(it)),Math.max(0,et-(k(z,"padding-left",!0)||0)-(k(z,"padding-right",!0)||0))}if(y==="height")return Math.max(0,Math.min(z.offsetHeight,z.scrollHeight)-(k(z,"padding-top",!0)||0)-(k(z,"padding-bottom",!0)||0));win$g.getComputedStyle||error$c(27,!0);var nt=win$g.getComputedStyle(z,void 0);return nt&&(j=nt.getPropertyValue(y),pick$1K(a,y!=="opacity")&&(j=pInt$a(j))),j}function inArray(z,y,a){return error$c(32,!1,void 0,{"Highcharts.inArray":"use Array.indexOf"}),y.indexOf(z,a)}var find$l=Array.prototype.find?function(z,y){return z.find(y)}:(function(z,y){var a,k=z.length;for(a=0;a<k;a++)if(y(z[a],a))return z[a]});function keys(z){return error$c(32,!1,void 0,{"Highcharts.keys":"use Object.keys"}),Object.keys(z)}function offset$1(z){var y=doc$m.documentElement,a=z.parentElement||z.parentNode?z.getBoundingClientRect():{top:0,left:0,width:0,height:0};return{top:a.top+(win$g.pageYOffset||y.scrollTop)-(y.clientTop||0),left:a.left+(win$g.pageXOffset||y.scrollLeft)-(y.clientLeft||0),width:a.width,height:a.height}}function objectEach$D(z,y,a){for(var k in z)Object.hasOwnProperty.call(z,k)&&y.call(a||z[k],z[k],k,z)}objectEach$D({map:"map",each:"forEach",grep:"filter",reduce:"reduce",some:"some"},function(z,y){H[y]=function(a){var k;return error$c(32,!1,void 0,(k={},k["Highcharts."+y]="use Array."+z,k)),Array.prototype[z].apply(a,[].slice.call(arguments,1))}});function addEvent$19(z,y,a,k){k===void 0&&(k={});var j=typeof z=="function"&&z.prototype||z;Object.hasOwnProperty.call(j,"hcEvents")||(j.hcEvents={});var et=j.hcEvents;H.Point&&z instanceof H.Point&&z.series&&z.series.chart&&(z.series.chart.runTrackerClick=!0);var it=z.addEventListener||H.addEventListenerPolyfill;it&&it.call(z,y,a,H.supportsPassiveEvents?{passive:k.passive===void 0?y.indexOf("touch")!==-1:k.passive,capture:!1}:!1),et[y]||(et[y]=[]);var nt={fn:a,order:typeof k.order=="number"?k.order:1/0};return et[y].push(nt),et[y].sort(function(ot,at){return ot.order-at.order}),function(){removeEvent$c(z,y,a)}}function removeEvent$c(z,y,a){function k(ot,at){var lt=z.removeEventListener||H.removeEventListenerPolyfill;lt&&lt.call(z,ot,at,!1)}function j(ot){var at,lt;z.nodeName&&(y?(at={},at[y]=!0):at=ot,objectEach$D(at,function(ct,ht){if(ot[ht])for(lt=ot[ht].length;lt--;)k(ht,ot[ht][lt].fn)}))}var et=typeof z=="function"&&z.prototype||z;if(Object.hasOwnProperty.call(et,"hcEvents")){var it=et.hcEvents;if(y){var nt=it[y]||[];a?(it[y]=nt.filter(function(ot){return a!==ot.fn}),k(y,a)):(j(it),it[y]=[])}else j(it),delete et.hcEvents}}function fireEvent$C(z,y,a,k){var j;if(a=a||{},doc$m.createEvent&&(z.dispatchEvent||z.fireEvent&&z!==H))j=doc$m.createEvent("Events"),j.initEvent(y,!0,!0),a=extend$1y(j,a),z.dispatchEvent?z.dispatchEvent(a):z.fireEvent(y,a);else if(z.hcEvents){a.target||extend$1y(a,{preventDefault:function(){a.defaultPrevented=!0},target:z,type:y});for(var et=[],it=z,nt=!1;it.hcEvents;)Object.hasOwnProperty.call(it,"hcEvents")&&it.hcEvents[y]&&(et.length&&(nt=!0),et.unshift.apply(et,it.hcEvents[y])),it=Object.getPrototypeOf(it);nt&&et.sort(function(ot,at){return ot.order-at.order}),et.forEach(function(ot){ot.fn.call(z,a)===!1&&a.preventDefault()})}k&&!a.defaultPrevented&&k.call(z,a)}var serialMode,uniqueKey$8=(function(){var z=Math.random().toString(36).substring(2,9)+"-",y=0;return function(){return"highcharts-"+(serialMode?"":z)+y++}})();function useSerialIds(z){return serialMode=pick$1K(z,serialMode)}function isFunction$5(z){return typeof z=="function"}win$g.jQuery&&(win$g.jQuery.fn.highcharts=function(){var z=[].slice.call(arguments);if(this[0])return z[0]?(new H[isString$d(z[0])?z.shift():"Chart"](this[0],z[0],z[1]),this):charts$5[attr$8(this[0],"data-highcharts-chart")]});var Utilities={addEvent:addEvent$19,arrayMax:arrayMax$a,arrayMin:arrayMin$9,attr:attr$8,clamp:clamp$l,cleanRecursively:cleanRecursively$2,clearTimeout:internalClearTimeout,correctFloat:correctFloat$d,createElement:createElement$b,css:css$d,defined:defined$_,destroyObjectProperties:destroyObjectProperties$a,discardElement:discardElement$7,erase:erase$a,error:error$c,extend:extend$1y,extendClass:extendClass$2,find:find$l,fireEvent:fireEvent$C,getMagnitude:getMagnitude$3,getNestedProperty:getNestedProperty$3,getStyle:getStyle$2,inArray,isArray:isArray$q,isClass,isDOMElement,isFunction:isFunction$5,isNumber:isNumber$X,isObject:isObject$i,isString:isString$d,keys,merge:merge$1x,normalizeTickInterval:normalizeTickInterval$3,objectEach:objectEach$D,offset:offset$1,pad:pad$2,pick:pick$1K,pInt:pInt$a,relativeLength:relativeLength$a,removeEvent:removeEvent$c,splat:splat$l,stableSort:stableSort$7,syncTimeout:syncTimeout$9,timeUnits:timeUnits$4,uniqueKey:uniqueKey$8,useSerialIds,wrap:wrap$h},palette={colors:["#7cb5ec","#434348","#90ed7d","#f7a35c","#8085e9","#f15c80","#e4d354","#2b908f","#f45b5b","#91e8e1"],backgroundColor:"#ffffff",neutralColor100:"#000000",neutralColor80:"#333333",neutralColor60:"#666666",neutralColor40:"#999999",neutralColor20:"#cccccc",neutralColor10:"#e6e6e6",neutralColor5:"#f2f2f2",neutralColor3:"#f7f7f7",highlightColor100:"#003399",highlightColor80:"#335cad",highlightColor60:"#6685c2",highlightColor20:"#ccd6eb",highlightColor10:"#e6ebf5"},ChartDefaults={panning:{enabled:!1,type:"x"},styledMode:!1,borderRadius:0,colorCount:10,defaultSeriesType:"line",ignoreHiddenSeries:!0,spacing:[10,10,15,10],resetZoomButton:{theme:{zIndex:6},position:{align:"right",x:-10,y:10}},zoomBySingleTouch:!1,width:null,height:null,borderColor:palette.highlightColor80,backgroundColor:palette.backgroundColor,plotBorderColor:palette.neutralColor20},isNumber$W=Utilities.isNumber,merge$1w=Utilities.merge,pInt$9=Utilities.pInt,Color=(function(){function z(y){this.rgba=[NaN,NaN,NaN,NaN],this.input=y;var a=H.Color;if(a&&a!==z)return new a(y);if(!(this instanceof z))return new z(y);this.init(y)}return z.parse=function(y){return y?new z(y):z.None},z.prototype.init=function(y){var a,k,j,et;if(typeof y=="object"&&typeof y.stops<"u")this.stops=y.stops.map(function(ot){return new z(ot[1])});else if(typeof y=="string"){if(this.input=y=z.names[y.toLowerCase()]||y,y.charAt(0)==="#"){var it=y.length,nt=parseInt(y.substr(1),16);it===7?k=[(nt&16711680)>>16,(nt&65280)>>8,nt&255,1]:it===4&&(k=[(nt&3840)>>4|(nt&3840)>>8,(nt&240)>>4|nt&240,(nt&15)<<4|nt&15,1])}if(!k)for(j=z.parsers.length;j--&&!k;)et=z.parsers[j],a=et.regex.exec(y),a&&(k=et.parse(a))}k&&(this.rgba=k)},z.prototype.get=function(y){var a=this.input,k=this.rgba;if(typeof a=="object"&&typeof this.stops<"u"){var j=merge$1w(a);return j.stops=[].slice.call(j.stops),this.stops.forEach(function(et,it){j.stops[it]=[j.stops[it][0],et.get(y)]}),j}return k&&isNumber$W(k[0])?y==="rgb"||!y&&k[3]===1?"rgb("+k[0]+","+k[1]+","+k[2]+")":y==="a"?""+k[3]:"rgba("+k.join(",")+")":a},z.prototype.brighten=function(y){var a=this.rgba;if(this.stops)this.stops.forEach(function(j){j.brighten(y)});else if(isNumber$W(y)&&y!==0)for(var k=0;k<3;k++)a[k]+=pInt$9(y*255),a[k]<0&&(a[k]=0),a[k]>255&&(a[k]=255);return this},z.prototype.setOpacity=function(y){return this.rgba[3]=y,this},z.prototype.tweenTo=function(y,a){var k=this.rgba,j=y.rgba;if(!isNumber$W(k[0])||!isNumber$W(j[0]))return y.input||"none";var et=j[3]!==1||k[3]!==1;return(et?"rgba(":"rgb(")+Math.round(j[0]+(k[0]-j[0])*(1-a))+","+Math.round(j[1]+(k[1]-j[1])*(1-a))+","+Math.round(j[2]+(k[2]-j[2])*(1-a))+(et?","+(j[3]+(k[3]-j[3])*(1-a)):"")+")"},z.names={white:"#ffffff",black:"#000000"},z.parsers=[{regex:/rgba\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]?(?:\.[0-9]+)?)\s*\)/,parse:function(y){return[pInt$9(y[1]),pInt$9(y[2]),pInt$9(y[3]),parseFloat(y[4],10)]}},{regex:/rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/,parse:function(y){return[pInt$9(y[1]),pInt$9(y[2]),pInt$9(y[3]),1]}}],z.None=new z(""),z})(),win$f=H.win,defined$Z=Utilities.defined,error$b=Utilities.error,extend$1x=Utilities.extend,isObject$h=Utilities.isObject,merge$1v=Utilities.merge,objectEach$C=Utilities.objectEach,pad$1=Utilities.pad,pick$1J=Utilities.pick,splat$k=Utilities.splat,timeUnits$3=Utilities.timeUnits,hasNewSafariBug=H.isSafari&&win$f.Intl&&win$f.Intl.DateTimeFormat.prototype.formatRange,hasOldSafariBug=H.isSafari&&win$f.Intl&&!win$f.Intl.DateTimeFormat.prototype.formatRange,Time=(function(){function z(y){this.options={},this.useUTC=!1,this.variableTimezone=!1,this.Date=win$f.Date,this.getTimezoneOffset=this.timezoneOffsetFunction(),this.update(y)}return z.prototype.get=function(y,a){if(this.variableTimezone||this.timezoneOffset){var k=a.getTime(),j=k-this.getTimezoneOffset(a);a.setTime(j);var et=a["getUTC"+y]();return a.setTime(k),et}return this.useUTC?a["getUTC"+y]():a["get"+y]()},z.prototype.set=function(y,a,k){if(this.variableTimezone||this.timezoneOffset){if(y==="Milliseconds"||y==="Seconds"||y==="Minutes"&&this.getTimezoneOffset(a)%36e5===0)return a["setUTC"+y](k);var j=this.getTimezoneOffset(a),et=a.getTime()-j;a.setTime(et),a["setUTC"+y](k);var it=this.getTimezoneOffset(a);return et=a.getTime()+it,a.setTime(et)}return this.useUTC||hasNewSafariBug&&y==="FullYear"?a["setUTC"+y](k):a["set"+y](k)},z.prototype.update=function(y){var a=pick$1J(y&&y.useUTC,!0);this.options=y=merge$1v(!0,this.options||{},y),this.Date=y.Date||win$f.Date||Date,this.useUTC=a,this.timezoneOffset=a&&y.timezoneOffset,this.getTimezoneOffset=this.timezoneOffsetFunction(),this.variableTimezone=a&&!!(y.getTimezoneOffset||y.timezone)},z.prototype.makeTime=function(y,a,k,j,et,it){var nt,ot,at;return this.useUTC?(nt=this.Date.UTC.apply(0,arguments),ot=this.getTimezoneOffset(nt),nt+=ot,at=this.getTimezoneOffset(nt),ot!==at?nt+=at-ot:ot-36e5===this.getTimezoneOffset(nt-36e5)&&!hasOldSafariBug&&(nt-=36e5)):nt=new this.Date(y,a,pick$1J(k,1),pick$1J(j,0),pick$1J(et,0),pick$1J(it,0)).getTime(),nt},z.prototype.timezoneOffsetFunction=function(){var y=this,a=this.options,k=a.moment||win$f.moment;if(!this.useUTC)return function(j){return new Date(j.toString()).getTimezoneOffset()*6e4};if(a.timezone)if(!k)error$b(25);else return function(j){return-k.tz(j,a.timezone).utcOffset()*6e4};return this.useUTC&&a.getTimezoneOffset?function(j){return a.getTimezoneOffset(j.valueOf())*6e4}:function(){return(y.timezoneOffset||0)*6e4}},z.prototype.dateFormat=function(y,a,k){if(!defined$Z(a)||isNaN(a))return H.defaultOptions.lang&&H.defaultOptions.lang.invalidDate||"";y=pick$1J(y,"%Y-%m-%d %H:%M:%S");var j=this,et=new this.Date(a),it=this.get("Hours",et),nt=this.get("Day",et),ot=this.get("Date",et),at=this.get("Month",et),lt=this.get("FullYear",et),ct=H.defaultOptions.lang,ht=ct&&ct.weekdays,ut=ct&&ct.shortWeekdays,ft=extend$1x({a:ut?ut[nt]:ht[nt].substr(0,3),A:ht[nt],d:pad$1(ot),e:pad$1(ot,2," "),w:nt,b:ct.shortMonths[at],B:ct.months[at],m:pad$1(at+1),o:at+1,y:lt.toString().substr(2,2),Y:lt,H:pad$1(it),k:it,I:pad$1(it%12||12),l:it%12||12,M:pad$1(this.get("Minutes",et)),p:it<12?"AM":"PM",P:it<12?"am":"pm",S:pad$1(et.getSeconds()),L:pad$1(Math.floor(a%1e3),3)},H.dateFormats);return objectEach$C(ft,function(vt,gt){for(;y.indexOf("%"+gt)!==-1;)y=y.replace("%"+gt,typeof vt=="function"?vt.call(j,a):vt)}),k?y.substr(0,1).toUpperCase()+y.substr(1):y},z.prototype.resolveDTLFormat=function(y){return isObject$h(y,!0)?y:(y=splat$k(y),{main:y[0],from:y[1],to:y[2]})},z.prototype.getTimeTicks=function(y,a,k,j){var et=this,it=et.Date,nt=[],ot={},at=new it(a),lt=y.unitRange,ct=y.count||1,ht,ut,ft,vt;if(j=pick$1J(j,1),defined$Z(a)){et.set("Milliseconds",at,lt>=timeUnits$3.second?0:ct*Math.floor(et.get("Milliseconds",at)/ct)),lt>=timeUnits$3.second&&et.set("Seconds",at,lt>=timeUnits$3.minute?0:ct*Math.floor(et.get("Seconds",at)/ct)),lt>=timeUnits$3.minute&&et.set("Minutes",at,lt>=timeUnits$3.hour?0:ct*Math.floor(et.get("Minutes",at)/ct)),lt>=timeUnits$3.hour&&et.set("Hours",at,lt>=timeUnits$3.day?0:ct*Math.floor(et.get("Hours",at)/ct)),lt>=timeUnits$3.day&&et.set("Date",at,lt>=timeUnits$3.month?1:Math.max(1,ct*Math.floor(et.get("Date",at)/ct))),lt>=timeUnits$3.month&&(et.set("Month",at,lt>=timeUnits$3.year?0:ct*Math.floor(et.get("Month",at)/ct)),ut=et.get("FullYear",at)),lt>=timeUnits$3.year&&(ut-=ut%ct,et.set("FullYear",at,ut)),lt===timeUnits$3.week&&(vt=et.get("Day",at),et.set("Date",at,et.get("Date",at)-vt+j+(vt<j?-7:0))),ut=et.get("FullYear",at);var gt=et.get("Month",at),mt=et.get("Date",at),bt=et.get("Hours",at);a=at.getTime(),(et.variableTimezone||!et.useUTC)&&defined$Z(k)&&(ft=k-a>4*timeUnits$3.month||et.getTimezoneOffset(a)!==et.getTimezoneOffset(k));var xt=at.getTime();for(ht=1;xt<k;)nt.push(xt),lt===timeUnits$3.year?xt=et.makeTime(ut+ht*ct,0):lt===timeUnits$3.month?xt=et.makeTime(ut,gt+ht*ct):ft&&(lt===timeUnits$3.day||lt===timeUnits$3.week)?xt=et.makeTime(ut,gt,mt+ht*ct*(lt===timeUnits$3.day?1:7)):ft&&lt===timeUnits$3.hour&&ct>1?xt=et.makeTime(ut,gt,mt,bt+ht*ct):xt+=lt*ct,ht++;nt.push(xt),lt<=timeUnits$3.hour&&nt.length<1e4&&nt.forEach(function(wt){wt%18e5===0&&et.dateFormat("%H%M%S%L",wt)==="000000000"&&(ot[wt]="day")})}return nt.info=extend$1x(y,{higherRanks:ot,totalRange:lt*ct}),nt},z.prototype.getDateFormat=function(y,a,k,j){var et=this.dateFormat("%m-%d %H:%M:%S.%L",a),it="01-01 00:00:00.000",nt={millisecond:15,second:12,minute:9,hour:6,day:3},ot,at,lt="millisecond";for(at in timeUnits$3){if(y===timeUnits$3.week&&+this.dateFormat("%w",a)===k&&et.substr(6)===it.substr(6)){at="week";break}if(timeUnits$3[at]>y){at=lt;break}if(nt[at]&&et.substr(nt[at])!==it.substr(nt[at]))break;at!=="week"&&(lt=at)}return at&&(ot=this.resolveDTLFormat(j[at]).main),ot},z})(),color$g=Color.parse,isTouchDevice$4=H.isTouchDevice,svg$7=H.svg,merge$1u=Utilities.merge,defaultOptions$j={colors:palette.colors,symbols:["circle","diamond","square","triangle","triangle-down"],lang:{loading:"Loading...",months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],weekdays:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],decimalPoint:".",numericSymbols:["k","M","G","T","P","E"],resetZoom:"Reset zoom",resetZoomTitle:"Reset zoom level 1:1",thousandsSep:" "},global:{},time:{Date:void 0,getTimezoneOffset:void 0,timezone:void 0,timezoneOffset:0,useUTC:!0},chart:ChartDefaults,title:{text:"Chart title",align:"center",margin:15,widthAdjust:-44},subtitle:{text:"",align:"center",widthAdjust:-44},caption:{margin:15,text:"",align:"left",verticalAlign:"bottom"},plotOptions:{},labels:{style:{position:"absolute",color:palette.neutralColor80}},legend:{enabled:!0,align:"center",alignColumns:!0,className:"highcharts-no-tooltip",layout:"horizontal",labelFormatter:function(){return this.name},borderColor:palette.neutralColor40,borderRadius:0,navigation:{activeColor:palette.highlightColor100,inactiveColor:palette.neutralColor20},itemStyle:{color:palette.neutralColor80,cursor:"pointer",fontSize:"12px",fontWeight:"bold",textOverflow:"ellipsis"},itemHoverStyle:{color:palette.neutralColor100},itemHiddenStyle:{color:palette.neutralColor20},shadow:!1,itemCheckboxStyle:{position:"absolute",width:"13px",height:"13px"},squareSymbol:!0,symbolPadding:5,verticalAlign:"bottom",x:0,y:0,title:{style:{fontWeight:"bold"}}},loading:{labelStyle:{fontWeight:"bold",position:"relative",top:"45%"},style:{position:"absolute",backgroundColor:palette.backgroundColor,opacity:.5,textAlign:"center"}},tooltip:{enabled:!0,animation:svg$7,borderRadius:3,dateTimeLabelFormats:{millisecond:"%A, %b %e, %H:%M:%S.%L",second:"%A, %b %e, %H:%M:%S",minute:"%A, %b %e, %H:%M",hour:"%A, %b %e, %H:%M",day:"%A, %b %e, %Y",week:"Week from %A, %b %e, %Y",month:"%B %Y",year:"%Y"},footerFormat:"",headerShape:"callout",hideDelay:500,padding:8,shape:"callout",shared:!1,snap:isTouchDevice$4?25:10,headerFormat:'<span style="font-size: 10px">{point.key}</span><br/>',pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.y}</b><br/>',backgroundColor:color$g(palette.neutralColor3).setOpacity(.85).get(),borderWidth:1,shadow:!0,stickOnContact:!1,style:{color:palette.neutralColor80,cursor:"default",fontSize:"12px",whiteSpace:"nowrap"},useHTML:!1},credits:{enabled:!0,href:"https://www.highcharts.com?credits",position:{align:"right",x:-10,verticalAlign:"bottom",y:-5},style:{cursor:"pointer",color:palette.neutralColor40,fontSize:"9px"},text:"Highcharts.com"}};defaultOptions$j.chart.styledMode=!1;var defaultTime$2=new Time(merge$1u(defaultOptions$j.global,defaultOptions$j.time));function getOptions$4(){return defaultOptions$j}function setOptions$2(z){return merge$1u(!0,defaultOptions$j,z),(z.time||z.global)&&(H.time?H.time.update(merge$1u(defaultOptions$j.global,defaultOptions$j.time,z.global,z.time)):H.time=defaultTime$2),defaultOptions$j}var DefaultOptions={defaultOptions:defaultOptions$j,defaultTime:defaultTime$2,getOptions:getOptions$4,setOptions:setOptions$2},color$f=Color.parse,win$e=H.win,isNumber$V=Utilities.isNumber,objectEach$B=Utilities.objectEach,Fx=(function(){function z(y,a,k){this.pos=NaN,this.options=a,this.elem=y,this.prop=k}return z.prototype.dSetter=function(){var y=this.paths,a=y&&y[0],k=y&&y[1],j=this.now||0,et=[];if(j===1||!a||!k)et=this.toD||[];else if(a.length===k.length&&j<1)for(var it=0;it<k.length;it++){for(var nt=a[it],ot=k[it],at=[],lt=0;lt<ot.length;lt++){var ct=nt[lt],ht=ot[lt];isNumber$V(ct)&&isNumber$V(ht)&&!(ot[0]==="A"&&(lt===4||lt===5))?at[lt]=ct+j*(ht-ct):at[lt]=ht}et.push(at)}else et=k;this.elem.attr("d",et,void 0,!0)},z.prototype.update=function(){var y=this.elem,a=this.prop,k=this.now,j=this.options.step;this[a+"Setter"]?this[a+"Setter"]():y.attr?y.element&&y.attr(a,k,null,!0):y.style[a]=k+this.unit,j&&j.call(y,k,this)},z.prototype.run=function(y,a,k){var j=this,et=j.options,it=function(at){return it.stopped?!1:j.step(at)},nt=win$e.requestAnimationFrame||function(at){setTimeout(at,13)},ot=function(){for(var at=0;at<z.timers.length;at++)z.timers[at]()||z.timers.splice(at--,1);z.timers.length&&nt(ot)};y===a&&!this.elem["forceAnimate:"+this.prop]?(delete et.curAnim[this.prop],et.complete&&Object.keys(et.curAnim).length===0&&et.complete.call(this.elem)):(this.startTime=+new Date,this.start=y,this.end=a,this.unit=k,this.now=this.start,this.pos=0,it.elem=this.elem,it.prop=this.prop,it()&&z.timers.push(it)===1&&nt(ot))},z.prototype.step=function(y){var a=+new Date,k=this.options,j=this.elem,et=k.complete,it=k.duration,nt=k.curAnim,ot,at;return j.attr&&!j.element?ot=!1:y||a>=it+this.startTime?(this.now=this.end,this.pos=1,this.update(),nt[this.prop]=!0,at=!0,objectEach$B(nt,function(lt){lt!==!0&&(at=!1)}),at&&et&&et.call(j),ot=!1):(this.pos=k.easing((a-this.startTime)/it),this.now=this.start+(this.end-this.start)*this.pos,this.update(),ot=!0),ot},z.prototype.initPath=function(y,a,k){var j=y.startX,et=y.endX,it=k.slice(),nt=y.isArea,ot=nt?2:1,at,lt,ct,ht,ut=a&&a.slice();if(!ut)return[it,it];function ft(gt,mt){for(;gt.length<lt;){var bt=gt[0],xt=mt[lt-gt.length];if(xt&&bt[0]==="M"&&(xt[0]==="C"?gt[0]=["C",bt[1],bt[2],bt[1],bt[2],bt[1],bt[2]]:gt[0]=["L",bt[1],bt[2]]),gt.unshift(bt),nt){var wt=gt.pop();gt.push(gt[gt.length-1],wt)}}}function vt(gt,mt){for(;gt.length<lt;){var bt=gt[Math.floor(gt.length/ot)-1].slice();if(bt[0]==="C"&&(bt[1]=bt[5],bt[2]=bt[6]),!nt)gt.push(bt);else{var xt=gt[Math.floor(gt.length/ot)].slice();gt.splice(gt.length/2,0,bt,xt)}}}if(j&&et&&et.length){for(ct=0;ct<j.length;ct++)if(j[ct]===et[0]){at=ct;break}else if(j[0]===et[et.length-j.length+ct]){at=ct,ht=!0;break}else if(j[j.length-1]===et[et.length-j.length+ct]){at=j.length-ct;break}typeof at>"u"&&(ut=[])}return ut.length&&isNumber$V(at)&&(lt=it.length+at*ot,ht?(ft(ut,it),vt(it)):(ft(it,ut),vt(ut))),[ut,it]},z.prototype.fillSetter=function(){z.prototype.strokeSetter.apply(this,arguments)},z.prototype.strokeSetter=function(){this.elem.attr(this.prop,color$f(this.start).tweenTo(color$f(this.end),this.pos),null,!0)},z.timers=[],z})(),defined$Y=Utilities.defined,getStyle$1=Utilities.getStyle,isArray$p=Utilities.isArray,isNumber$U=Utilities.isNumber,isObject$g=Utilities.isObject,merge$1t=Utilities.merge,objectEach$A=Utilities.objectEach,pick$1I=Utilities.pick;function setAnimation$5(z,y){y.renderer.globalAnimation=pick$1I(z,y.options.chart.animation,!0)}function animObject$d(z){return isObject$g(z)?merge$1t({duration:500,defer:0},z):{duration:z?500:0,defer:0}}function getDeferredAnimation$3(z,y,a){var k=animObject$d(y),j=a?[a]:z.series,et=0,it=0;j.forEach(function(ot){var at=animObject$d(ot.options.animation);et=y&&defined$Y(y.defer)?k.defer:Math.max(et,at.duration+at.defer),it=Math.min(k.duration,at.duration)}),z.renderer.forExport&&(et=0);var nt={defer:Math.max(0,et-it),duration:Math.min(et,it)};return nt}function animate$2(z,y,a){var k,j="",et,it,nt;isObject$g(a)||(nt=arguments,a={duration:nt[2],easing:nt[3],complete:nt[4]}),isNumber$U(a.duration)||(a.duration=400),a.easing=typeof a.easing=="function"?a.easing:Math[a.easing]||Math.easeInOutSine,a.curAnim=merge$1t(y),objectEach$A(y,function(ot,at){stop$2(z,at),it=new Fx(z,a,at),et=void 0,at==="d"&&isArray$p(y.d)?(it.paths=it.initPath(z,z.pathArray,y.d),it.toD=y.d,k=0,et=1):z.attr?k=z.attr(at):(k=parseFloat(getStyle$1(z,at))||0,at!=="opacity"&&(j="px")),et||(et=ot),typeof et=="string"&&et.match("px")&&(et=et.replace(/px/g,"")),it.run(k,et,j)})}function stop$2(z,y){for(var a=Fx.timers.length;a--;)Fx.timers[a].elem===z&&(!y||y===Fx.timers[a].prop)&&(Fx.timers[a].stopped=!0)}var animationExports={animate:animate$2,animObject:animObject$d,getDeferredAnimation:getDeferredAnimation$3,setAnimation:setAnimation$5,stop:stop$2},SVG_NS$3=H.SVG_NS,attr$7=Utilities.attr,createElement$a=Utilities.createElement,discardElement$6=Utilities.discardElement,error$a=Utilities.error,isString$c=Utilities.isString,objectEach$z=Utilities.objectEach,splat$j=Utilities.splat,hasValidDOMParser=(function(){try{return!!new DOMParser().parseFromString("","text/html")}catch{return!1}})(),AST=(function(){function z(y){this.nodes=typeof y=="string"?this.parseMarkup(y):y}return z.filterUserAttributes=function(y){return objectEach$z(y,function(a,k){var j=!0;z.allowedAttributes.indexOf(k)===-1&&(j=!1),["background","dynsrc","href","lowsrc","src"].indexOf(k)!==-1&&(j=isString$c(a)&&z.allowedReferences.some(function(et){return a.indexOf(et)===0})),j||(error$a("Highcharts warning: Invalid attribute '"+k+"' in config"),delete y[k])}),y},z.setElementHTML=function(y,a){if(y.innerHTML="",a){var k=new z(a);k.addToDOM(y)}},z.prototype.addToDOM=function(y){function a(k,j){var et;return splat$j(k).forEach(function(it){var nt=it.tagName,ot=it.textContent?H.doc.createTextNode(it.textContent):void 0,at;if(nt)if(nt==="#text")at=ot;else if(z.allowedTags.indexOf(nt)!==-1){var lt=nt==="svg"?SVG_NS$3:j.namespaceURI||SVG_NS$3,ct=H.doc.createElementNS(lt,nt),ht=it.attributes||{};objectEach$z(it,function(ut,ft){ft!=="tagName"&&ft!=="attributes"&&ft!=="children"&&ft!=="textContent"&&(ht[ft]=ut)}),attr$7(ct,z.filterUserAttributes(ht)),ot&&ct.appendChild(ot),a(it.children||[],ct),at=ct}else error$a("Highcharts warning: Invalid tagName '"+nt+"' in config");at&&j.appendChild(at),et=at}),et}return a(this.nodes,y)},z.prototype.parseMarkup=function(y){var a=[];y=y.trim();var k,j;hasValidDOMParser?k=new DOMParser().parseFromString(y,"text/html"):(j=createElement$a("div"),j.innerHTML=y,k={body:j});var et=function(it,nt){var ot=it.nodeName.toLowerCase(),at={tagName:ot};ot==="#text"&&(at.textContent=it.textContent||"");var lt=it.attributes;if(lt){var ct={};[].forEach.call(lt,function(ut){ct[ut.name]=ut.value}),at.attributes=ct}if(it.childNodes.length){var ht=[];[].forEach.call(it.childNodes,function(ut){et(ut,ht)}),ht.length&&(at.children=ht)}nt.push(at)};return[].forEach.call(k.body.childNodes,function(it){return et(it,a)}),j&&discardElement$6(j),a},z.allowedAttributes=["aria-controls","aria-describedby","aria-expanded","aria-haspopup","aria-hidden","aria-label","aria-labelledby","aria-live","aria-pressed","aria-readonly","aria-roledescription","aria-selected","class","clip-path","color","colspan","cx","cy","d","dx","dy","disabled","fill","height","href","id","in","markerHeight","markerWidth","offset","opacity","orient","padding","paddingLeft","paddingRight","patternUnits","r","refX","refY","role","scope","slope","src","startOffset","stdDeviation","stroke","stroke-linecap","stroke-width","style","tableValues","result","rowspan","summary","target","tabindex","text-align","textAnchor","textLength","type","valign","width","x","x1","x2","y","y1","y2","zIndex"],z.allowedReferences=["https://","http://","mailto:","/","../","./","#"],z.allowedTags=["a","b","br","button","caption","circle","clipPath","code","dd","defs","div","dl","dt","em","feComponentTransfer","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feOffset","feMerge","feMergeNode","filter","h1","h2","h3","h4","h5","h6","hr","i","img","li","linearGradient","marker","ol","p","path","pattern","pre","rect","small","span","stop","strong","style","sub","sup","svg","table","text","thead","tbody","tspan","td","th","tr","u","ul","#text"],z})(),defaultOptions$i=DefaultOptions.defaultOptions,defaultTime$1=DefaultOptions.defaultTime,getNestedProperty$2=Utilities.getNestedProperty,isNumber$T=Utilities.isNumber,pick$1H=Utilities.pick,pInt$8=Utilities.pInt;function dateFormat(z,y,a){return defaultTime$1.dateFormat(z,y,a)}function format$e(z,y,a){for(var k="{",j=!1,et,it,nt,ot,at=/f$/,lt=/\.([0-9])/,ct=defaultOptions$i.lang,ht=a&&a.time||defaultTime$1,ut=a&&a.numberFormatter||numberFormat$2,ft=[];z&&(ot=z.indexOf(k),ot!==-1);){if(et=z.slice(0,ot),j){if(it=et.split(":"),nt=getNestedProperty$2(it.shift()||"",y),it.length&&typeof nt=="number")if(et=it.join(":"),at.test(et)){var vt=parseInt((et.match(lt)||["","-1"])[1],10);nt!==null&&(nt=ut(nt,vt,ct.decimalPoint,et.indexOf(",")>-1?ct.thousandsSep:""))}else nt=ht.dateFormat(et,nt);ft.push(nt)}else ft.push(et);z=z.slice(ot+1),j=!j,k=j?"}":"{"}return ft.push(z),ft.join("")}function numberFormat$2(z,y,a,k){z=+z||0,y=+y;var j,et,it=defaultOptions$i.lang,nt=(z.toString().split(".")[1]||"").split("e")[0].length,ot=z.toString().split("e"),at=y;y===-1?y=Math.min(nt,20):isNumber$T(y)?y&&ot[1]&&ot[1]<0&&(et=y+ +ot[1],et>=0?(ot[0]=(+ot[0]).toExponential(et).split("e")[0],y=et):(ot[0]=ot[0].split(".")[0]||0,y<20?z=(ot[0]*Math.pow(10,ot[1])).toFixed(y):z=0,ot[1]=0)):y=2;var lt=(Math.abs(ot[1]?ot[0]:z)+Math.pow(10,-Math.max(y,nt)-1)).toFixed(y),ct=String(pInt$8(lt)),ht=ct.length>3?ct.length%3:0;return a=pick$1H(a,it.decimalPoint),k=pick$1H(k,it.thousandsSep),j=z<0?"-":"",j+=ht?ct.substr(0,ht)+k:"",+ot[1]<0&&!at?j="0":j+=ct.substr(ht).replace(/(\d{3})(?=\d)/g,"$1"+k),y&&(j+=a+lt.slice(-y)),ot[1]&&+j!=0&&(j+="e"+ot[1]),j}var FormatUtilities={dateFormat,format:format$e,numberFormat:numberFormat$2},clamp$k=Utilities.clamp,pick$1G=Utilities.pick,stableSort$6=Utilities.stableSort,RendererUtilities;(function(z){function y(a,k,j){var et=a,it=et.reducedLen||k,nt=function(vt,gt){return(gt.rank||0)-(vt.rank||0)},ot=function(vt,gt){return vt.target-gt.target},at,lt=!0,ct=[],ht,ut,ft=0;for(at=a.length;at--;)ft+=a[at].size;if(ft>it){for(stableSort$6(a,nt),at=0,ft=0;ft<=it;)ft+=a[at].size,at++;ct=a.splice(at-1,a.length)}for(stableSort$6(a,ot),a=a.map(function(vt){return{size:vt.size,targets:[vt.target],align:pick$1G(vt.align,.5)}});lt;){for(at=a.length;at--;)ht=a[at],ut=(Math.min.apply(0,ht.targets)+Math.max.apply(0,ht.targets))/2,ht.pos=clamp$k(ut-ht.size*ht.align,0,k-ht.size);for(at=a.length,lt=!1;at--;)at>0&&a[at-1].pos+a[at-1].size>a[at].pos&&(a[at-1].size+=a[at].size,a[at-1].targets=a[at-1].targets.concat(a[at].targets),a[at-1].align=.5,a[at-1].pos+a[at-1].size>k&&(a[at-1].pos=k-a[at-1].size),a.splice(at,1),lt=!0)}return et.push.apply(et,ct),at=0,a.some(function(vt){var gt=0;return(vt.targets||[]).some(function(){return et[at].pos=vt.pos+gt,typeof j<"u"&&Math.abs(et[at].pos-et[at].target)>j?(et.slice(0,at+1).forEach(function(mt){return delete mt.pos}),et.reducedLen=(et.reducedLen||k)-k*.1,et.reducedLen>k*.1&&y(et,k,j),!0):(gt+=et[at].size,at++,!1)})}),stableSort$6(et,ot),et}z.distribute=y})(RendererUtilities||(RendererUtilities={}));const R=RendererUtilities;var animate$1=animationExports.animate,animObject$c=animationExports.animObject,stop$1=animationExports.stop,deg2rad$9=H.deg2rad,doc$l=H.doc,noop$k=H.noop,svg$6=H.svg,SVG_NS$2=H.SVG_NS,win$d=H.win,addEvent$18=Utilities.addEvent,attr$6=Utilities.attr,createElement$9=Utilities.createElement,css$c=Utilities.css,defined$X=Utilities.defined,erase$9=Utilities.erase,extend$1w=Utilities.extend,fireEvent$B=Utilities.fireEvent,isArray$o=Utilities.isArray,isFunction$4=Utilities.isFunction,isNumber$S=Utilities.isNumber,isString$b=Utilities.isString,merge$1s=Utilities.merge,objectEach$y=Utilities.objectEach,pick$1F=Utilities.pick,pInt$7=Utilities.pInt,syncTimeout$8=Utilities.syncTimeout,uniqueKey$7=Utilities.uniqueKey,SVGElement=(function(){function z(){this.element=void 0,this.onEvents={},this.opacity=1,this.renderer=void 0,this.SVG_NS=SVG_NS$2,this.symbolCustomAttribs=["x","y","width","height","r","start","end","innerR","anchorX","anchorY","rounded"]}return z.prototype._defaultGetter=function(y){var a=pick$1F(this[y+"Value"],this[y],this.element?this.element.getAttribute(y):null,0);return/^[\-0-9\.]+$/.test(a)&&(a=parseFloat(a)),a},z.prototype._defaultSetter=function(y,a,k){k.setAttribute(a,y)},z.prototype.add=function(y){var a=this.renderer,k=this.element,j;return y&&(this.parentGroup=y),this.parentInverted=y&&y.inverted,typeof this.textStr<"u"&&this.element.nodeName==="text"&&a.buildText(this),this.added=!0,(!y||y.handleZ||this.zIndex)&&(j=this.zIndexSetter()),j||(y?y.element:a.box).appendChild(k),this.onAdd&&this.onAdd(),this},z.prototype.addClass=function(y,a){var k=a?"":this.attr("class")||"";return y=(y||"").split(/ /g).reduce(function(j,et){return k.indexOf(et)===-1&&j.push(et),j},k?[k]:[]).join(" "),y!==k&&this.attr("class",y),this},z.prototype.afterSetters=function(){this.doTransform&&(this.updateTransform(),this.doTransform=!1)},z.prototype.align=function(y,a,k){var j={},et=this.renderer,it=et.alignedObjects,nt,ot,at,lt,ct;y?(this.alignOptions=y,this.alignByTranslate=a,(!k||isString$b(k))&&(this.alignTo=at=k||"renderer",erase$9(it,this),it.push(this),k=void 0)):(y=this.alignOptions,a=this.alignByTranslate,at=this.alignTo),k=pick$1F(k,et[at],at==="scrollablePlotBox"?et.plotBox:void 0,et);var ht=y.align,ut=y.verticalAlign;return nt=(k.x||0)+(y.x||0),ot=(k.y||0)+(y.y||0),ht==="right"?lt=1:ht==="center"&&(lt=2),lt&&(nt+=(k.width-(y.width||0))/lt),j[a?"translateX":"x"]=Math.round(nt),ut==="bottom"?ct=1:ut==="middle"&&(ct=2),ct&&(ot+=(k.height-(y.height||0))/ct),j[a?"translateY":"y"]=Math.round(ot),this[this.placed?"animate":"attr"](j),this.placed=!0,this.alignAttr=j,this},z.prototype.alignSetter=function(y){var a={left:"start",center:"middle",right:"end"};a[y]&&(this.alignValue=y,this.element.setAttribute("text-anchor",a[y]))},z.prototype.animate=function(y,a,k){var j=this,et=animObject$c(pick$1F(a,this.renderer.globalAnimation,!0)),it=et.defer;return pick$1F(doc$l.hidden,doc$l.msHidden,doc$l.webkitHidden,!1)&&(et.duration=0),et.duration!==0?(k&&(et.complete=k),syncTimeout$8(function(){j.element&&animate$1(j,y,et)},it)):(this.attr(y,void 0,k),objectEach$y(y,function(nt,ot){et.step&&et.step.call(this,nt,{prop:ot,pos:1,elem:this})},this)),this},z.prototype.applyTextOutline=function(y){var a=this.element,k=y.indexOf("contrast")!==-1;k&&(y=y.replace(/contrast/g,this.renderer.getContrast(a.style.fill)));var j=y.split(" "),et=j[j.length-1],it=j[0];if(it&&it!=="none"&&H.svg){this.fakeTS=!0,this.ySetter=this.xSetter,it=it.replace(/(^[\d\.]+)(.*?)$/g,function(at,lt,ct){return 2*Number(lt)+ct}),this.removeTextOutline();var nt=doc$l.createElementNS(SVG_NS$2,"tspan");attr$6(nt,{class:"highcharts-text-outline",fill:et,stroke:et,"stroke-width":it,"stroke-linejoin":"round"}),[].forEach.call(a.childNodes,function(at){var lt=at.cloneNode(!0);lt.removeAttribute&&["fill","stroke","stroke-width","stroke"].forEach(function(ct){return lt.removeAttribute(ct)}),nt.appendChild(lt)});var ot=doc$l.createElementNS(SVG_NS$2,"tspan");ot.textContent="​",["x","y"].forEach(function(at){var lt=a.getAttribute(at);lt&&ot.setAttribute(at,lt)}),nt.appendChild(ot),a.insertBefore(nt,a.firstChild)}},z.prototype.attr=function(y,a,k,j){var et=this.element,it=this.symbolCustomAttribs,nt,ot,at=this,lt,ct;return typeof y=="string"&&typeof a<"u"&&(nt=y,y={},y[nt]=a),typeof y=="string"?at=(this[y+"Getter"]||this._defaultGetter).call(this,y,et):(objectEach$y(y,function(ut,ft){lt=!1,j||stop$1(this,ft),this.symbolName&&it.indexOf(ft)!==-1&&(ot||(this.symbolAttr(y),ot=!0),lt=!0),this.rotation&&(ft==="x"||ft==="y")&&(this.doTransform=!0),lt||(ct=this[ft+"Setter"]||this._defaultSetter,ct.call(this,ut,ft,et),!this.styledMode&&this.shadows&&/^(width|height|visibility|x|y|d|transform|cx|cy|r)$/.test(ft)&&this.updateShadows(ft,ut,ct))},this),this.afterSetters()),k&&k.call(this),at},z.prototype.clip=function(y){return this.attr("clip-path",y?"url("+this.renderer.url+"#"+y.id+")":"none")},z.prototype.crisp=function(y,a){var k=this;a=a||y.strokeWidth||0;var j=Math.round(a)%2/2;return y.x=Math.floor(y.x||k.x||0)+j,y.y=Math.floor(y.y||k.y||0)+j,y.width=Math.floor((y.width||k.width||0)-2*j),y.height=Math.floor((y.height||k.height||0)-2*j),defined$X(y.strokeWidth)&&(y.strokeWidth=a),y},z.prototype.complexColor=function(y,a,k){var j=this.renderer,et,it,nt,ot,at,lt,ct,ht,ut,ft,vt=[],gt;fireEvent$B(this.renderer,"complexColor",{args:arguments},function(){if(y.radialGradient?it="radialGradient":y.linearGradient&&(it="linearGradient"),it){if(nt=y[it],at=j.gradients,lt=y.stops,ut=k.radialReference,isArray$o(nt)&&(y[it]=nt={x1:nt[0],y1:nt[1],x2:nt[2],y2:nt[3],gradientUnits:"userSpaceOnUse"}),it==="radialGradient"&&ut&&!defined$X(nt.gradientUnits)&&(ot=nt,nt=merge$1s(nt,j.getRadialAttr(ut,ot),{gradientUnits:"userSpaceOnUse"})),objectEach$y(nt,function(bt,xt){xt!=="id"&&vt.push(xt,bt)}),objectEach$y(lt,function(bt){vt.push(bt)}),vt=vt.join(","),at[vt])ft=at[vt].attr("id");else{nt.id=ft=uniqueKey$7();var mt=at[vt]=j.createElement(it).attr(nt).add(j.defs);mt.radAttr=ot,mt.stops=[],lt.forEach(function(bt){bt[1].indexOf("rgba")===0?(et=Color.parse(bt[1]),ct=et.get("rgb"),ht=et.get("a")):(ct=bt[1],ht=1);var xt=j.createElement("stop").attr({offset:bt[0],"stop-color":ct,"stop-opacity":ht}).add(mt);mt.stops.push(xt)})}gt="url("+j.url+"#"+ft+")",k.setAttribute(a,gt),k.gradient=vt,y.toString=function(){return gt}}})},z.prototype.css=function(y){var a=this.styles,k={},j=this.element,et=["textOutline","textOverflow","width"],it,nt="",ot,at=!a;return y&&y.color&&(y.fill=y.color),a&&objectEach$y(y,function(lt,ct){a&&a[ct]!==lt&&(k[ct]=lt,at=!0)}),at&&(a&&(y=extend$1w(a,k)),y&&(y.width===null||y.width==="auto"?delete this.textWidth:j.nodeName.toLowerCase()==="text"&&y.width&&(it=this.textWidth=pInt$7(y.width))),this.styles=y,it&&!svg$6&&this.renderer.forExport&&delete y.width,j.namespaceURI===this.SVG_NS?(ot=function(lt,ct){return"-"+ct.toLowerCase()},objectEach$y(y,function(lt,ct){et.indexOf(ct)===-1&&(nt+=ct.replace(/([A-Z])/g,ot)+":"+lt+";")}),nt&&attr$6(j,"style",nt)):css$c(j,y),this.added&&(this.element.nodeName==="text"&&this.renderer.buildText(this),y&&y.textOutline&&this.applyTextOutline(y.textOutline))),this},z.prototype.dashstyleSetter=function(y){var a,k=this["stroke-width"];if(k==="inherit"&&(k=1),y=y&&y.toLowerCase(),y){var j=y.replace("shortdashdotdot","3,1,1,1,1,1,").replace("shortdashdot","3,1,1,1").replace("shortdot","1,1,").replace("shortdash","3,1,").replace("longdash","8,3,").replace(/dot/g,"1,3,").replace("dash","4,3,").replace(/,$/,"").split(",");for(a=j.length;a--;)j[a]=""+pInt$7(j[a])*pick$1F(k,NaN);y=j.join(",").replace(/NaN/g,"none"),this.element.setAttribute("stroke-dasharray",y)}},z.prototype.destroy=function(){var y=this,a=y.element||{},k=y.renderer,j=a.ownerSVGElement,et=k.isSVG&&a.nodeName==="SPAN"&&y.parentGroup||void 0,it,nt;if(a.onclick=a.onmouseout=a.onmouseover=a.onmousemove=a.point=null,stop$1(y),y.clipPath&&j){var ot=y.clipPath;[].forEach.call(j.querySelectorAll("[clip-path],[CLIP-PATH]"),function(at){at.getAttribute("clip-path").indexOf(ot.element.id)>-1&&at.removeAttribute("clip-path")}),y.clipPath=ot.destroy()}if(y.stops){for(nt=0;nt<y.stops.length;nt++)y.stops[nt].destroy();y.stops.length=0,y.stops=void 0}for(y.safeRemoveChild(a),k.styledMode||y.destroyShadows();et&&et.div&&et.div.childNodes.length===0;)it=et.parentGroup,y.safeRemoveChild(et.div),delete et.div,et=it;y.alignTo&&erase$9(k.alignedObjects,y),objectEach$y(y,function(at,lt){y[lt]&&y[lt].parentGroup===y&&y[lt].destroy&&y[lt].destroy(),delete y[lt]})},z.prototype.destroyShadows=function(){(this.shadows||[]).forEach(function(y){this.safeRemoveChild(y)},this),this.shadows=void 0},z.prototype.destroyTextPath=function(y,a){var k=y.getElementsByTagName("text")[0],j;if(k){if(k.removeAttribute("dx"),k.removeAttribute("dy"),a.element.setAttribute("id",""),this.textPathWrapper&&k.getElementsByTagName("textPath").length){for(j=this.textPathWrapper.element.childNodes;j.length;)k.appendChild(j[0]);k.removeChild(this.textPathWrapper.element)}}else(y.getAttribute("dx")||y.getAttribute("dy"))&&(y.removeAttribute("dx"),y.removeAttribute("dy"));this.textPathWrapper&&(this.textPathWrapper=this.textPathWrapper.destroy())},z.prototype.dSetter=function(y,a,k){isArray$o(y)&&(typeof y[0]=="string"&&(y=this.renderer.pathToSegments(y)),this.pathArray=y,y=y.reduce(function(j,et,it){return!et||!et.join?(et||"").toString():(it?j+" ":"")+et.join(" ")},"")),/(NaN| {2}|^$)/.test(y)&&(y="M 0 0"),this[a]!==y&&(k.setAttribute(a,y),this[a]=y)},z.prototype.fadeOut=function(y){var a=this;a.animate({opacity:0},{duration:pick$1F(y,150),complete:function(){a.attr({y:-9999}).hide()}})},z.prototype.fillSetter=function(y,a,k){typeof y=="string"?k.setAttribute(a,y):y&&this.complexColor(y,a,k)},z.prototype.getBBox=function(y,a){var k=this,j=k.renderer,et=k.element,it=k.styles,nt=k.textStr,ot=j.cache,at=j.cacheKeys,lt=et.namespaceURI===k.SVG_NS,ct=pick$1F(a,k.rotation,0),ht=j.styledMode?et&&z.prototype.getStyle.call(et,"font-size"):it&&it.fontSize,ut,ft,vt,gt,mt;if(defined$X(nt)&&(mt=nt.toString(),mt.indexOf("<")===-1&&(mt=mt.replace(/[0-9]/g,"0")),mt+=["",ct,ht,k.textWidth,it&&it.textOverflow,it&&it.fontWeight].join(",")),mt&&!y&&(ut=ot[mt]),!ut){if(lt||j.forExport){try{gt=this.fakeTS&&function(xt){var wt=et.querySelector(".highcharts-text-outline");wt&&css$c(wt,{display:xt})},isFunction$4(gt)&&gt("none"),ut=et.getBBox?extend$1w({},et.getBBox()):{width:et.offsetWidth,height:et.offsetHeight},isFunction$4(gt)&&gt("")}catch{}(!ut||ut.width<0)&&(ut={width:0,height:0})}else ut=k.htmlGetBBox();if(j.isSVG&&(ft=ut.width,vt=ut.height,lt&&(ut.height=vt={"11px,17":14,"13px,20":16}[it&&it.fontSize+","+Math.round(vt)]||vt),ct)){var bt=ct*deg2rad$9;ut.width=Math.abs(vt*Math.sin(bt))+Math.abs(ft*Math.cos(bt)),ut.height=Math.abs(vt*Math.cos(bt))+Math.abs(ft*Math.sin(bt))}if(mt&&(nt===""||ut.height>0)){for(;at.length>250;)delete ot[at.shift()];ot[mt]||at.push(mt),ot[mt]=ut}}return ut},z.prototype.getStyle=function(y){return win$d.getComputedStyle(this.element||this,"").getPropertyValue(y)},z.prototype.hasClass=function(y){return(""+this.attr("class")).split(" ").indexOf(y)!==-1},z.prototype.hide=function(y){return y?this.attr({y:-9999}):this.attr({visibility:"hidden"}),this},z.prototype.htmlGetBBox=function(){return{height:0,width:0,x:0,y:0}},z.prototype.init=function(y,a){this.element=a==="span"?createElement$9(a):doc$l.createElementNS(this.SVG_NS,a),this.renderer=y,fireEvent$B(this,"afterInit")},z.prototype.invert=function(y){return this.inverted=y,this.updateTransform(),this},z.prototype.on=function(y,a){var k=this.onEvents;return k[y]&&k[y](),k[y]=addEvent$18(this.element,y,a),this},z.prototype.opacitySetter=function(y,a,k){var j=Number(Number(y).toFixed(3));this.opacity=j,k.setAttribute(a,j)},z.prototype.removeClass=function(y){return this.attr("class",(""+this.attr("class")).replace(isString$b(y)?new RegExp("(^| )"+y+"( |$)"):y," ").replace(/ +/g," ").trim())},z.prototype.removeTextOutline=function(){var y=this.element.querySelector("tspan.highcharts-text-outline");y&&this.safeRemoveChild(y)},z.prototype.safeRemoveChild=function(y){var a=y.parentNode;a&&a.removeChild(y)},z.prototype.setRadialReference=function(y){var a=this.element.gradient&&this.renderer.gradients[this.element.gradient];return this.element.radialReference=y,a&&a.radAttr&&a.animate(this.renderer.getRadialAttr(y,a.radAttr)),this},z.prototype.setTextPath=function(y,a){var k=this.element,j=this.text?this.text.element:k,et={textAnchor:"text-anchor"},it=!1,nt,ot,at=this.textPathWrapper,lt=!at;a=merge$1s(!0,{enabled:!0,attributes:{dy:-5,startOffset:"50%",textAnchor:"middle"}},a);var ct=AST.filterUserAttributes(a.attributes);if(y&&a&&a.enabled){if(at&&at.element.parentNode===null?(lt=!0,at=at.destroy()):at&&this.removeTextOutline.call(at.parentGroup),this.options&&this.options.padding&&(ct.dx=-this.options.padding),at||(this.textPathWrapper=at=this.renderer.createElement("textPath"),it=!0),nt=at.element,ot=y.element.getAttribute("id"),ot||y.element.setAttribute("id",ot=uniqueKey$7()),lt){j.setAttribute("y",0),isNumber$S(ct.dx)&&j.setAttribute("x",-ct.dx);for(var ht=[].slice.call(j.childNodes),ut=0;ut<ht.length;ut++){var ft=ht[ut];(ft.nodeType===Node.TEXT_NODE||ft.nodeName==="tspan")&&nt.appendChild(ft)}}it&&at&&at.add({element:j}),nt.setAttributeNS("http://www.w3.org/1999/xlink","href",this.renderer.url+"#"+ot),defined$X(ct.dy)&&(nt.parentNode.setAttribute("dy",ct.dy),delete ct.dy),defined$X(ct.dx)&&(nt.parentNode.setAttribute("dx",ct.dx),delete ct.dx),objectEach$y(ct,function(vt,gt){nt.setAttribute(et[gt]||gt,vt)}),k.removeAttribute("transform"),this.removeTextOutline.call(at),this.text&&!this.renderer.styledMode&&this.attr({fill:"none","stroke-width":0}),this.updateTransform=noop$k,this.applyTextOutline=noop$k}else at&&(delete this.updateTransform,delete this.applyTextOutline,this.destroyTextPath(k,y),this.updateTransform(),this.options&&this.options.rotation&&this.applyTextOutline(this.options.style.textOutline));return this},z.prototype.shadow=function(y,a,k){var j=[],et=this.element,it=this.oldShadowOptions,nt={color:palette.neutralColor100,offsetX:this.parentInverted?-1:1,offsetY:this.parentInverted?-1:1,opacity:.15,width:3},ot,at,lt,ct,ht=!1,ut,ft;if(y===!0?ft=nt:typeof y=="object"&&(ft=extend$1w(nt,y)),ft&&(ft&&it&&objectEach$y(ft,function(vt,gt){vt!==it[gt]&&(ht=!0)}),ht&&this.destroyShadows(),this.oldShadowOptions=ft),!ft)this.destroyShadows();else if(!this.shadows){for(ct=ft.opacity/ft.width,ut=this.parentInverted?"translate("+ft.offsetY+", "+ft.offsetX+")":"translate("+ft.offsetX+", "+ft.offsetY+")",ot=1;ot<=ft.width;ot++)at=et.cloneNode(!1),lt=ft.width*2+1-2*ot,attr$6(at,{stroke:y.color||palette.neutralColor100,"stroke-opacity":ct*ot,"stroke-width":lt,transform:ut,fill:"none"}),at.setAttribute("class",(at.getAttribute("class")||"")+" highcharts-shadow"),k&&(attr$6(at,"height",Math.max(attr$6(at,"height")-lt,0)),at.cutHeight=lt),a?a.element.appendChild(at):et.parentNode&&et.parentNode.insertBefore(at,et),j.push(at);this.shadows=j}return this},z.prototype.show=function(y){return this.attr({visibility:y?"inherit":"visible"})},z.prototype.strokeSetter=function(y,a,k){this[a]=y,this.stroke&&this["stroke-width"]?(z.prototype.fillSetter.call(this,this.stroke,"stroke",k),k.setAttribute("stroke-width",this["stroke-width"]),this.hasStroke=!0):a==="stroke-width"&&y===0&&this.hasStroke?(k.removeAttribute("stroke"),this.hasStroke=!1):this.renderer.styledMode&&this["stroke-width"]&&(k.setAttribute("stroke-width",this["stroke-width"]),this.hasStroke=!0)},z.prototype.strokeWidth=function(){if(!this.renderer.styledMode)return this["stroke-width"]||0;var y=this.getStyle("stroke-width"),a=0,k;return y.indexOf("px")===y.length-2?a=pInt$7(y):y!==""&&(k=doc$l.createElementNS(SVG_NS$2,"rect"),attr$6(k,{width:y,"stroke-width":0}),this.element.parentNode.appendChild(k),a=k.getBBox().width,k.parentNode.removeChild(k)),a},z.prototype.symbolAttr=function(y){var a=this;["x","y","r","start","end","width","height","innerR","anchorX","anchorY","clockwise"].forEach(function(k){a[k]=pick$1F(y[k],a[k])}),a.attr({d:a.renderer.symbols[a.symbolName](a.x,a.y,a.width,a.height,a)})},z.prototype.textSetter=function(y){y!==this.textStr&&(delete this.textPxLength,this.textStr=y,this.added&&this.renderer.buildText(this))},z.prototype.titleSetter=function(y){var a=this.element,k=a.getElementsByTagName("title")[0]||doc$l.createElementNS(this.SVG_NS,"title");a.insertBefore?a.insertBefore(k,a.firstChild):a.appendChild(k),k.textContent=String(pick$1F(y,"")).replace(/<[^>]*>/g,"").replace(/&lt;/g,"<").replace(/&gt;/g,">")},z.prototype.toFront=function(){var y=this.element;return y.parentNode.appendChild(y),this},z.prototype.translate=function(y,a){return this.attr({translateX:y,translateY:a})},z.prototype.updateShadows=function(y,a,k){var j=this.shadows;if(j)for(var et=j.length;et--;)k.call(j[et],y==="height"?Math.max(a-(j[et].cutHeight||0),0):y==="d"?this.d:a,y,j[et])},z.prototype.updateTransform=function(){var y=this,a=y.scaleX,k=y.scaleY,j=y.inverted,et=y.rotation,it=y.matrix,nt=y.element,ot=y.translateX||0,at=y.translateY||0;j&&(ot+=y.width,at+=y.height);var lt=["translate("+ot+","+at+")"];defined$X(it)&&lt.push("matrix("+it.join(",")+")"),j?lt.push("rotate(90) scale(-1,1)"):et&&lt.push("rotate("+et+" "+pick$1F(this.rotationOriginX,nt.getAttribute("x"),0)+" "+pick$1F(this.rotationOriginY,nt.getAttribute("y")||0)+")"),(defined$X(a)||defined$X(k))&&lt.push("scale("+pick$1F(a,1)+" "+pick$1F(k,1)+")"),lt.length&&nt.setAttribute("transform",lt.join(" "))},z.prototype.visibilitySetter=function(y,a,k){y==="inherit"?k.removeAttribute(a):this[a]!==y&&k.setAttribute(a,y),this[a]=y},z.prototype.xGetter=function(y){return this.element.nodeName==="circle"&&(y==="x"?y="cx":y==="y"&&(y="cy")),this._defaultGetter(y)},z.prototype.zIndexSetter=function(y,a){var k=this.renderer,j=this.parentGroup,et=j||k,it=et.element||k.box,nt=this.element,ot=it===k.box,at,lt,ct,ht=!1,ut,ft=this.added,vt;if(defined$X(y)?(nt.setAttribute("data-z-index",y),y=+y,this[a]===y&&(ft=!1)):defined$X(this[a])&&nt.removeAttribute("data-z-index"),this[a]=y,ft){for(y=this.zIndex,y&&j&&(j.handleZ=!0),at=it.childNodes,vt=at.length-1;vt>=0&&!ht;vt--)lt=at[vt],ct=lt.getAttribute("data-z-index"),ut=!defined$X(ct),lt!==nt&&(y<0&&ut&&!ot&&!vt?(it.insertBefore(nt,at[vt]),ht=!0):(pInt$7(ct)<=y||ut&&(!defined$X(y)||y>=0))&&(it.insertBefore(nt,at[vt+1]||null),ht=!0));ht||(it.insertBefore(nt,at[ot?3:0]||null),ht=!0)}return ht},z})();SVGElement.prototype["stroke-widthSetter"]=SVGElement.prototype.strokeSetter;SVGElement.prototype.yGetter=SVGElement.prototype.xGetter;SVGElement.prototype.matrixSetter=SVGElement.prototype.rotationOriginXSetter=SVGElement.prototype.rotationOriginYSetter=SVGElement.prototype.rotationSetter=SVGElement.prototype.scaleXSetter=SVGElement.prototype.scaleYSetter=SVGElement.prototype.translateXSetter=SVGElement.prototype.translateYSetter=SVGElement.prototype.verticalAlignSetter=function(z,y){this[y]=z,this.doTransform=!0};var RendererRegistry;(function(z){z.rendererTypes={};var y;function a(j){return j===void 0&&(j=y),z.rendererTypes[j]||z.rendererTypes[y]}z.getRendererType=a;function k(j,et,it){z.rendererTypes[j]=et,(!y||it)&&(y=j,H.Renderer=et)}z.registerRendererType=k})(RendererRegistry||(RendererRegistry={}));const RendererRegistry$1=RendererRegistry;var __extends$2h=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),defined$W=Utilities.defined,extend$1v=Utilities.extend,isNumber$R=Utilities.isNumber,merge$1r=Utilities.merge,pick$1E=Utilities.pick,removeEvent$b=Utilities.removeEvent,SVGLabel=(function(z){__extends$2h(y,z);function y(a,k,j,et,it,nt,ot,at,lt,ct){var ht=z.call(this)||this;ht.paddingLeftSetter=ht.paddingSetter,ht.paddingRightSetter=ht.paddingSetter,ht.init(a,"g"),ht.textStr=k,ht.x=j,ht.y=et,ht.anchorX=nt,ht.anchorY=ot,ht.baseline=lt,ht.className=ct,ht.addClass(ct==="button"?"highcharts-no-tooltip":"highcharts-label"),ct&&ht.addClass("highcharts-"+ct),ht.text=a.text(void 0,0,0,at).attr({zIndex:1});var ut;return typeof it=="string"&&(ut=/^url\((.*?)\)$/.test(it),(ut||ht.renderer.symbols[it])&&(ht.symbolKey=it)),ht.bBox=y.emptyBBox,ht.padding=3,ht.baselineOffset=0,ht.needsBox=a.styledMode||ut,ht.deferredAttr={},ht.alignFactor=0,ht}return y.prototype.alignSetter=function(a){var k={left:0,center:.5,right:1}[a];k!==this.alignFactor&&(this.alignFactor=k,this.bBox&&isNumber$R(this.xSetting)&&this.attr({x:this.xSetting}))},y.prototype.anchorXSetter=function(a,k){this.anchorX=a,this.boxAttr(k,Math.round(a)-this.getCrispAdjust()-this.xSetting)},y.prototype.anchorYSetter=function(a,k){this.anchorY=a,this.boxAttr(k,a-this.ySetting)},y.prototype.boxAttr=function(a,k){this.box?this.box.attr(a,k):this.deferredAttr[a]=k},y.prototype.css=function(a){if(a){var k={};a=merge$1r(a),y.textProps.forEach(function(it){typeof a[it]<"u"&&(k[it]=a[it],delete a[it])}),this.text.css(k);var j="width"in k,et="fontSize"in k||"fontWeight"in k;et?this.updateTextPadding():j&&this.updateBoxSize()}return SVGElement.prototype.css.call(this,a)},y.prototype.destroy=function(){removeEvent$b(this.element,"mouseenter"),removeEvent$b(this.element,"mouseleave"),this.text&&this.text.destroy(),this.box&&(this.box=this.box.destroy()),SVGElement.prototype.destroy.call(this)},y.prototype.fillSetter=function(a,k){a&&(this.needsBox=!0),this.fill=a,this.boxAttr(k,a)},y.prototype.getBBox=function(){this.textStr&&this.bBox.width===0&&this.bBox.height===0&&this.updateBoxSize();var a=this.padding,k=pick$1E(this.paddingLeft,a);return{width:this.width,height:this.height,x:this.bBox.x-k,y:this.bBox.y-a}},y.prototype.getCrispAdjust=function(){return this.renderer.styledMode&&this.box?this.box.strokeWidth()%2/2:(this["stroke-width"]?parseInt(this["stroke-width"],10):0)%2/2},y.prototype.heightSetter=function(a){this.heightSetting=a},y.prototype.onAdd=function(){var a=this.textStr;this.text.add(this),this.attr({text:defined$W(a)?a:"",x:this.x,y:this.y}),this.box&&defined$W(this.anchorX)&&this.attr({anchorX:this.anchorX,anchorY:this.anchorY})},y.prototype.paddingSetter=function(a,k){isNumber$R(a)?a!==this[k]&&(this[k]=a,this.updateTextPadding()):this[k]=void 0},y.prototype.rSetter=function(a,k){this.boxAttr(k,a)},y.prototype.shadow=function(a){return a&&!this.renderer.styledMode&&(this.updateBoxSize(),this.box&&this.box.shadow(a)),this},y.prototype.strokeSetter=function(a,k){this.stroke=a,this.boxAttr(k,a)},y.prototype["stroke-widthSetter"]=function(a,k){a&&(this.needsBox=!0),this["stroke-width"]=a,this.boxAttr(k,a)},y.prototype["text-alignSetter"]=function(a){this.textAlign=a},y.prototype.textSetter=function(a){typeof a<"u"&&this.text.attr({text:a}),this.updateTextPadding()},y.prototype.updateBoxSize=function(){var a=this.text.element.style,k={},j=this.padding,et=this.bBox=(!isNumber$R(this.widthSetting)||!isNumber$R(this.heightSetting)||this.textAlign)&&defined$W(this.text.textStr)?this.text.getBBox():y.emptyBBox,it;this.width=this.getPaddedWidth(),this.height=(this.heightSetting||et.height||0)+2*j;var nt=this.renderer.fontMetrics(a&&a.fontSize,this.text);if(this.baselineOffset=j+Math.min((this.text.firstLineMetrics||nt).b,et.height||1/0),this.heightSetting&&(this.baselineOffset+=(this.heightSetting-nt.h)/2),this.needsBox){if(!this.box){var ot=this.box=this.symbolKey?this.renderer.symbol(this.symbolKey):this.renderer.rect();ot.addClass((this.className==="button"?"":"highcharts-label-box")+(this.className?" highcharts-"+this.className+"-box":"")),ot.add(this)}it=this.getCrispAdjust(),k.x=it,k.y=(this.baseline?-this.baselineOffset:0)+it,k.width=Math.round(this.width),k.height=Math.round(this.height),this.box.attr(extend$1v(k,this.deferredAttr)),this.deferredAttr={}}},y.prototype.updateTextPadding=function(){var a=this.text;this.updateBoxSize();var k=this.baseline?0:this.baselineOffset,j=pick$1E(this.paddingLeft,this.padding);defined$W(this.widthSetting)&&this.bBox&&(this.textAlign==="center"||this.textAlign==="right")&&(j+={center:.5,right:1}[this.textAlign]*(this.widthSetting-this.bBox.width)),(j!==a.x||k!==a.y)&&(a.attr("x",j),a.hasBoxWidthChanged&&(this.bBox=a.getBBox(!0)),typeof k<"u"&&a.attr("y",k)),a.x=j,a.y=k},y.prototype.widthSetter=function(a){this.widthSetting=isNumber$R(a)?a:void 0},y.prototype.getPaddedWidth=function(){var a=this.padding,k=pick$1E(this.paddingLeft,a),j=pick$1E(this.paddingRight,a);return(this.widthSetting||this.bBox.width||0)+k+j},y.prototype.xSetter=function(a){this.x=a,this.alignFactor&&(a-=this.alignFactor*this.getPaddedWidth(),this["forceAnimate:x"]=!0),this.xSetting=Math.round(a),this.attr("translateX",this.xSetting)},y.prototype.ySetter=function(a){this.ySetting=this.y=Math.round(a),this.attr("translateY",this.ySetting)},y.emptyBBox={width:0,height:0,x:0,y:0},y.textProps=["color","direction","fontFamily","fontSize","fontStyle","fontWeight","lineHeight","textAlign","textDecoration","textOutline","textOverflow","width"],y})(SVGElement),defined$V=Utilities.defined,isNumber$Q=Utilities.isNumber,pick$1D=Utilities.pick;function arc$1(z,y,a,k,j){var et=[];if(j){var it=j.start||0,nt=pick$1D(j.r,a),ot=pick$1D(j.r,k||a),at=.001,lt=Math.abs((j.end||0)-it-2*Math.PI)<at,ct=(j.end||0)-at,ht=j.innerR,ut=pick$1D(j.open,lt),ft=Math.cos(it),vt=Math.sin(it),gt=Math.cos(ct),mt=Math.sin(ct),bt=pick$1D(j.longArc,ct-it-Math.PI<at?0:1);et.push(["M",z+nt*ft,y+ot*vt],["A",nt,ot,0,bt,pick$1D(j.clockwise,1),z+nt*gt,y+ot*mt]),defined$V(ht)&&et.push(ut?["M",z+ht*gt,y+ht*mt]:["L",z+ht*gt,y+ht*mt],["A",ht,ht,0,bt,defined$V(j.clockwise)?1-j.clockwise:0,z+ht*ft,y+ht*vt]),ut||et.push(["Z"])}return et}function callout(z,y,a,k,j){var et=6,it=6,nt=Math.min(j&&j.r||0,a,k),ot=nt+it,at=j&&j.anchorX,lt=j&&j.anchorY||0,ct=roundedRect(z,y,a,k,{r:nt});return isNumber$Q(at)&&(z+at>=a?lt>y+ot&&lt<y+k-ot?ct.splice(3,1,["L",z+a,lt-it],["L",z+a+et,lt],["L",z+a,lt+it],["L",z+a,y+k-nt]):ct.splice(3,1,["L",z+a,k/2],["L",at,lt],["L",z+a,k/2],["L",z+a,y+k-nt]):z+at<=0?lt>y+ot&&lt<y+k-ot?ct.splice(7,1,["L",z,lt+it],["L",z-et,lt],["L",z,lt-it],["L",z,y+nt]):ct.splice(7,1,["L",z,k/2],["L",at,lt],["L",z,k/2],["L",z,y+nt]):lt&&lt>k&&at>z+ot&&at<z+a-ot?ct.splice(5,1,["L",at+it,y+k],["L",at,y+k+et],["L",at-it,y+k],["L",z+nt,y+k]):lt&&lt<0&&at>z+ot&&at<z+a-ot&&ct.splice(1,1,["L",at-it,y],["L",at,y-et],["L",at+it,y],["L",a-nt,y])),ct}function circle(z,y,a,k){return arc$1(z+a/2,y+k/2,a/2,k/2,{start:Math.PI*.5,end:Math.PI*2.5,open:!1})}function diamond(z,y,a,k){return[["M",z+a/2,y],["L",z+a,y+k/2],["L",z+a/2,y+k],["L",z,y+k/2],["Z"]]}function rect(z,y,a,k,j){return j&&j.r?roundedRect(z,y,a,k,j):[["M",z,y],["L",z+a,y],["L",z+a,y+k],["L",z,y+k],["Z"]]}function roundedRect(z,y,a,k,j){var et=j&&j.r||0;return[["M",z+et,y],["L",z+a-et,y],["C",z+a,y,z+a,y,z+a,y+et],["L",z+a,y+k-et],["C",z+a,y+k,z+a,y+k,z+a-et,y+k],["L",z+et,y+k],["C",z,y+k,z,y+k,z,y+k-et],["L",z,y+et],["C",z,y,z,y,z+et,y]]}function triangle(z,y,a,k){return[["M",z+a/2,y],["L",z+a,y+k],["L",z,y+k],["Z"]]}function triangleDown(z,y,a,k){return[["M",z,y],["L",z+a,y],["L",z+a/2,y+k],["Z"]]}var Symbols={arc:arc$1,callout,circle,diamond,rect,roundedRect,square:rect,triangle,"triangle-down":triangleDown},doc$k=H.doc,SVG_NS$1=H.SVG_NS,attr$5=Utilities.attr,isString$a=Utilities.isString,objectEach$x=Utilities.objectEach,pick$1C=Utilities.pick,TextBuilder=(function(){function z(y){var a=y.styles;this.renderer=y.renderer,this.svgElement=y,this.width=y.textWidth,this.textLineHeight=a&&a.lineHeight,this.textOutline=a&&a.textOutline,this.ellipsis=!!(a&&a.textOverflow==="ellipsis"),this.noWrap=!!(a&&a.whiteSpace==="nowrap"),this.fontSize=a&&a.fontSize}return z.prototype.buildSVG=function(){var y=this.svgElement,a=y.element,k=y.renderer,j=pick$1C(y.textStr,"").toString(),et=j.indexOf("<")!==-1,it=a.childNodes,nt=this.width&&!y.added&&k.box,ot=/<br.*?>/g,at=[j,this.ellipsis,this.noWrap,this.textLineHeight,this.textOutline,this.fontSize,this.width].join(",");if(at!==y.textCache){y.textCache=at,delete y.actualWidth;for(var lt=it.length;lt--;)a.removeChild(it[lt]);if(!et&&!this.ellipsis&&!this.width&&(j.indexOf(" ")===-1||this.noWrap&&!ot.test(j)))a.appendChild(doc$k.createTextNode(this.unescapeEntities(j)));else if(j!==""){nt&&nt.appendChild(a);var ct=new AST(j);this.modifyTree(ct.nodes),ct.addToDOM(y.element),this.modifyDOM(),this.ellipsis&&(a.textContent||"").indexOf("…")!==-1&&y.attr("title",this.unescapeEntities(y.textStr||"",["&lt;","&gt;"])),nt&&nt.removeChild(a)}isString$a(this.textOutline)&&y.applyTextOutline&&y.applyTextOutline(this.textOutline)}},z.prototype.modifyDOM=function(){var y=this,a=this.svgElement,k=attr$5(a.element,"x");a.firstLineMetrics=void 0;for(var j;(j=a.element.firstChild)&&/^[\s\u200B]*$/.test(j.textContent||" ");)a.element.removeChild(j);[].forEach.call(a.element.querySelectorAll("tspan.highcharts-br"),function(ot,at){ot.nextSibling&&ot.previousSibling&&(at===0&&ot.previousSibling.nodeType===1&&(a.firstLineMetrics=a.renderer.fontMetrics(void 0,ot.previousSibling)),attr$5(ot,{dy:y.getLineHeight(ot.nextSibling),x:k}))});var et=this.width||0;if(et){var it=function(ot,at){var lt=ot.textContent||"",ct=lt.replace(/([^\^])-/g,"$1- ").split(" "),ht=!y.noWrap&&(ct.length>1||a.element.childNodes.length>1),ut=y.getLineHeight(at),ft=0,vt=a.actualWidth;if(y.ellipsis)lt&&y.truncate(ot,lt,void 0,0,Math.max(0,et-parseInt(y.fontSize||12,10)),function(bt,xt){return bt.substring(0,xt)+"…"});else if(ht){for(var gt=[],mt=[];at.firstChild&&at.firstChild!==ot;)mt.push(at.firstChild),at.removeChild(at.firstChild);for(;ct.length;)ct.length&&!y.noWrap&&ft>0&&(gt.push(ot.textContent||""),ot.textContent=ct.join(" ").replace(/- /g,"-")),y.truncate(ot,void 0,ct,ft===0&&vt||0,et,function(bt,xt){return ct.slice(0,xt).join(" ").replace(/- /g,"-")}),vt=a.actualWidth,ft++;mt.forEach(function(bt){at.insertBefore(bt,ot)}),gt.forEach(function(bt){at.insertBefore(doc$k.createTextNode(bt),ot);var xt=doc$k.createElementNS(SVG_NS$1,"tspan");xt.textContent="​",attr$5(xt,{dy:ut,x:k}),at.insertBefore(xt,ot)})}},nt=(function(ot){var at=[].slice.call(ot.childNodes);at.forEach(function(lt){lt.nodeType===Node.TEXT_NODE?it(lt,ot):(lt.className.baseVal.indexOf("highcharts-br")!==-1&&(a.actualWidth=0),nt(lt))})});nt(a.element)}},z.prototype.getLineHeight=function(y){var a,k=y.nodeType===Node.TEXT_NODE?y.parentElement:y;return this.renderer.styledMode||(a=k&&/(px|em)$/.test(k.style.fontSize)?k.style.fontSize:this.fontSize||this.renderer.style.fontSize||12),this.textLineHeight?parseInt(this.textLineHeight.toString(),10):this.renderer.fontMetrics(a,k||this.svgElement.element).h},z.prototype.modifyTree=function(y){var a=this,k=function(j,et){var it=j.tagName,nt=a.renderer.styledMode,ot=j.attributes||{};if(it==="b"||it==="strong"?nt?ot.class="highcharts-strong":ot.style="font-weight:bold;"+(ot.style||""):(it==="i"||it==="em")&&(nt?ot.class="highcharts-emphasized":ot.style="font-style:italic;"+(ot.style||"")),isString$a(ot.style)&&(ot.style=ot.style.replace(/(;| |^)color([ :])/,"$1fill$2")),it==="br"){ot.class="highcharts-br",j.textContent="​";var at=y[et+1];at&&at.textContent&&(at.textContent=at.textContent.replace(/^ +/gm,""))}it!=="#text"&&it!=="a"&&(j.tagName="tspan"),j.attributes=ot,j.children&&j.children.filter(function(lt){return lt.tagName!=="#text"}).forEach(k)};y.forEach(k)},z.prototype.truncate=function(y,a,k,j,et,it){var nt=this.svgElement,ot=nt.renderer,at=nt.rotation,lt=[],ct=k?1:0,ht=(a||k||"").length,ut=ht,ft,vt,gt=function(mt,bt){var xt=bt||mt,wt=y.parentNode;if(wt&&typeof lt[xt]>"u")if(wt.getSubStringLength)try{lt[xt]=j+wt.getSubStringLength(0,k?xt+1:xt)}catch{}else ot.getSpanWidth&&(y.textContent=it(a||k,mt),lt[xt]=j+ot.getSpanWidth(nt,y));return lt[xt]};if(nt.rotation=0,vt=gt(y.textContent.length),j+vt>et){for(;ct<=ht;)ut=Math.ceil((ct+ht)/2),k&&(ft=it(k,ut)),vt=gt(ut,ft&&ft.length-1),ct===ht?ct=ht+1:vt>et?ht=ut-1:ct=ut;ht===0?y.textContent="":a&&ht===a.length-1||(y.textContent=ft||it(a||k,ut))}k&&k.splice(0,ut),nt.actualWidth=vt,nt.rotation=at},z.prototype.unescapeEntities=function(y,a){return objectEach$x(this.renderer.escapes,function(k,j){(!a||a.indexOf(k)===-1)&&(y=y.toString().replace(new RegExp(k,"g"),j))}),y},z})(),charts$4=H.charts,deg2rad$8=H.deg2rad,doc$j=H.doc,isFirefox$3=H.isFirefox,isMS$2=H.isMS,isWebKit$1=H.isWebKit,noop$j=H.noop,SVG_NS=H.SVG_NS,symbolSizes=H.symbolSizes,win$c=H.win,addEvent$17=Utilities.addEvent,attr$4=Utilities.attr,createElement$8=Utilities.createElement,css$b=Utilities.css,defined$U=Utilities.defined,destroyObjectProperties$9=Utilities.destroyObjectProperties,extend$1u=Utilities.extend,isArray$n=Utilities.isArray,isNumber$P=Utilities.isNumber,isObject$f=Utilities.isObject,isString$9=Utilities.isString,merge$1q=Utilities.merge,pick$1B=Utilities.pick,pInt$6=Utilities.pInt,uniqueKey$6=Utilities.uniqueKey,hasInternalReferenceBug,SVGRenderer=(function(){function z(y,a,k,j,et,it,nt){this.alignedObjects=void 0,this.box=void 0,this.boxWrapper=void 0,this.cache=void 0,this.cacheKeys=void 0,this.chartIndex=void 0,this.defs=void 0,this.globalAnimation=void 0,this.gradients=void 0,this.height=void 0,this.imgCount=void 0,this.isSVG=void 0,this.style=void 0,this.url=void 0,this.width=void 0,this.init(y,a,k,j,et,it,nt)}return z.prototype.init=function(y,a,k,j,et,it,nt){var ot=this,at=ot.createElement("svg").attr({version:"1.1",class:"highcharts-root"}),lt=at.element;nt||at.css(this.getStyle(j)),y.appendChild(lt),attr$4(y,"dir","ltr"),y.innerHTML.indexOf("xmlns")===-1&&attr$4(lt,"xmlns",this.SVG_NS),ot.isSVG=!0,this.box=lt,this.boxWrapper=at,ot.alignedObjects=[],this.url=this.getReferenceURL();var ct=this.createElement("desc").add();ct.element.appendChild(doc$j.createTextNode("Created with Highcharts 9.2.2")),ot.defs=this.createElement("defs").add(),ot.allowHTML=it,ot.forExport=et,ot.styledMode=nt,ot.gradients={},ot.cache={},ot.cacheKeys=[],ot.imgCount=0,ot.setSize(a,k,!1);var ht,ut;isFirefox$3&&y.getBoundingClientRect&&(ht=function(){css$b(y,{left:0,top:0}),ut=y.getBoundingClientRect(),css$b(y,{left:Math.ceil(ut.left)-ut.left+"px",top:Math.ceil(ut.top)-ut.top+"px"})},ht(),ot.unSubPixelFix=addEvent$17(win$c,"resize",ht))},z.prototype.definition=function(y){var a=new AST([y]);return a.addToDOM(this.defs.element)},z.prototype.getReferenceURL=function(){if((isFirefox$3||isWebKit$1)&&doc$j.getElementsByTagName("base").length){if(!defined$U(hasInternalReferenceBug)){var y=uniqueKey$6(),a=new AST([{tagName:"svg",attributes:{width:8,height:8},children:[{tagName:"defs",children:[{tagName:"clipPath",attributes:{id:y},children:[{tagName:"rect",attributes:{width:4,height:4}}]}]},{tagName:"rect",attributes:{id:"hitme",width:8,height:8,"clip-path":"url(#"+y+")",fill:"rgba(0,0,0,0.001)"}}]}]),k=a.addToDOM(doc$j.body);css$b(k,{position:"fixed",top:0,left:0,zIndex:9e5});var j=doc$j.elementFromPoint(6,6);hasInternalReferenceBug=(j&&j.id)==="hitme",doc$j.body.removeChild(k)}if(hasInternalReferenceBug)return win$c.location.href.split("#")[0].replace(/<[^>]*>/g,"").replace(/([\('\)])/g,"\\$1").replace(/ /g,"%20")}return""},z.prototype.getStyle=function(y){return this.style=extend$1u({fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',fontSize:"12px"},y),this.style},z.prototype.setStyle=function(y){this.boxWrapper.css(this.getStyle(y))},z.prototype.isHidden=function(){return!this.boxWrapper.getBBox().width},z.prototype.destroy=function(){var y=this,a=y.defs;return y.box=null,y.boxWrapper=y.boxWrapper.destroy(),destroyObjectProperties$9(y.gradients||{}),y.gradients=null,a&&(y.defs=a.destroy()),y.unSubPixelFix&&y.unSubPixelFix(),y.alignedObjects=null,null},z.prototype.createElement=function(y){var a=new this.Element;return a.init(this,y),a},z.prototype.getRadialAttr=function(y,a){return{cx:y[0]-y[2]/2+(a.cx||0)*y[2],cy:y[1]-y[2]/2+(a.cy||0)*y[2],r:(a.r||0)*y[2]}},z.prototype.buildText=function(y){new TextBuilder(y).buildSVG()},z.prototype.getContrast=function(y){return y=Color.parse(y).rgba,y[0]*=1,y[1]*=1.2,y[2]*=.5,y[0]+y[1]+y[2]>1.8*255?"#000000":"#FFFFFF"},z.prototype.button=function(y,a,k,j,et,it,nt,ot,at,lt){var ct=this.label(y,a,k,at,void 0,void 0,lt,void 0,"button"),ht=this.styledMode,ut=0,ft=et?merge$1q(et):{},vt=ft&&ft.style||{};ft=AST.filterUserAttributes(ft),ct.attr(merge$1q({padding:8,r:2},ft));var gt,mt,bt,xt;return ht||(ft=merge$1q({fill:palette.neutralColor3,stroke:palette.neutralColor20,"stroke-width":1,style:{color:palette.neutralColor80,cursor:"pointer",fontWeight:"normal"}},{style:vt},ft),gt=ft.style,delete ft.style,it=merge$1q(ft,{fill:palette.neutralColor10},AST.filterUserAttributes(it||{})),mt=it.style,delete it.style,nt=merge$1q(ft,{fill:palette.highlightColor10,style:{color:palette.neutralColor100,fontWeight:"bold"}},AST.filterUserAttributes(nt||{})),bt=nt.style,delete nt.style,ot=merge$1q(ft,{style:{color:palette.neutralColor20}},AST.filterUserAttributes(ot||{})),xt=ot.style,delete ot.style),addEvent$17(ct.element,isMS$2?"mouseover":"mouseenter",function(){ut!==3&&ct.setState(1)}),addEvent$17(ct.element,isMS$2?"mouseout":"mouseleave",function(){ut!==3&&ct.setState(ut)}),ct.setState=function(wt){wt!==1&&(ct.state=ut=wt),ct.removeClass(/highcharts-button-(normal|hover|pressed|disabled)/).addClass("highcharts-button-"+["normal","hover","pressed","disabled"][wt||0]),ht||ct.attr([ft,it,nt,ot][wt||0]).css([gt,mt,bt,xt][wt||0])},ht||ct.attr(ft).css(extend$1u({cursor:"default"},gt)),ct.on("touchstart",function(wt){return wt.stopPropagation()}).on("click",function(wt){ut!==3&&j.call(ct,wt)})},z.prototype.crispLine=function(y,a,k){k===void 0&&(k="round");var j=y[0],et=y[1];return defined$U(j[1])&&j[1]===et[1]&&(j[1]=et[1]=Math[k](j[1])-a%2/2),defined$U(j[2])&&j[2]===et[2]&&(j[2]=et[2]=Math[k](j[2])+a%2/2),y},z.prototype.path=function(y){var a=this.styledMode?{}:{fill:"none"};return isArray$n(y)?a.d=y:isObject$f(y)&&extend$1u(a,y),this.createElement("path").attr(a)},z.prototype.circle=function(y,a,k){var j=isObject$f(y)?y:typeof y>"u"?{}:{x:y,y:a,r:k},et=this.createElement("circle");return et.xSetter=et.ySetter=function(it,nt,ot){ot.setAttribute("c"+nt,it)},et.attr(j)},z.prototype.arc=function(y,a,k,j,et,it){var nt;isObject$f(y)?(nt=y,a=nt.y,k=nt.r,j=nt.innerR,et=nt.start,it=nt.end,y=nt.x):nt={innerR:j,start:et,end:it};var ot=this.symbol("arc",y,a,k,k,nt);return ot.r=k,ot},z.prototype.rect=function(y,a,k,j,et,it){et=isObject$f(y)?y.r:et;var nt=this.createElement("rect"),ot=isObject$f(y)?y:typeof y>"u"?{}:{x:y,y:a,width:Math.max(k,0),height:Math.max(j,0)};return this.styledMode||(typeof it<"u"&&(ot["stroke-width"]=it,ot=nt.crisp(ot)),ot.fill="none"),et&&(ot.r=et),nt.rSetter=function(at,lt,ct){nt.r=at,attr$4(ct,{rx:at,ry:at})},nt.rGetter=function(){return nt.r||0},nt.attr(ot)},z.prototype.setSize=function(y,a,k){var j=this;j.width=y,j.height=a,j.boxWrapper.animate({width:y,height:a},{step:function(){this.attr({viewBox:"0 0 "+this.attr("width")+" "+this.attr("height")})},duration:pick$1B(k,!0)?void 0:0}),j.alignElements()},z.prototype.g=function(y){var a=this.createElement("g");return y?a.attr({class:"highcharts-"+y}):a},z.prototype.image=function(y,a,k,j,et,it){var nt={preserveAspectRatio:"none"},ot=function(ht,ut){ht.setAttributeNS?ht.setAttributeNS("http://www.w3.org/1999/xlink","href",ut):ht.setAttribute("hc-svg-href",ut)};arguments.length>1&&extend$1u(nt,{x:a,y:k,width:j,height:et});var at=this.createElement("image").attr(nt),lt=function(ht){ot(at.element,y),it.call(at,ht)};if(it){ot(at.element,"data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==");var ct=new win$c.Image;addEvent$17(ct,"load",lt),ct.src=y,ct.complete&&lt({})}else ot(at.element,y);return at},z.prototype.symbol=function(y,a,k,j,et,it){var nt=this,ot=/^url\((.*?)\)$/,at=ot.test(y),lt=!at&&(this.symbols[y]?y:"circle"),ct=lt&&this.symbols[lt],ht,ut,ft,vt;if(ct)typeof a=="number"&&(ut=ct.call(this.symbols,Math.round(a||0),Math.round(k||0),j||0,et||0,it)),ht=this.path(ut),nt.styledMode||ht.attr("fill","none"),extend$1u(ht,{symbolName:lt||void 0,x:a,y:k,width:j,height:et}),it&&extend$1u(ht,it);else if(at){ft=y.match(ot)[1];var gt=ht=this.image(ft);gt.imgwidth=pick$1B(symbolSizes[ft]&&symbolSizes[ft].width,it&&it.width),gt.imgheight=pick$1B(symbolSizes[ft]&&symbolSizes[ft].height,it&&it.height),vt=function(mt){return mt.attr({width:mt.width,height:mt.height})},["width","height"].forEach(function(mt){gt[mt+"Setter"]=function(bt,xt){var wt=this["img"+xt];if(this[xt]=bt,defined$U(wt)&&(it&&it.backgroundSize==="within"&&this.width&&this.height&&(wt=Math.round(wt*Math.min(this.width/this.imgwidth,this.height/this.imgheight))),this.element&&this.element.setAttribute(xt,wt),!this.alignByTranslate)){var Mt=((this[xt]||0)-wt)/2,Et=xt==="width"?{translateX:Mt}:{translateY:Mt};this.attr(Et)}}}),defined$U(a)&&gt.attr({x:a,y:k}),gt.isImg=!0,defined$U(gt.imgwidth)&&defined$U(gt.imgheight)?vt(gt):(gt.attr({width:0,height:0}),createElement$8("img",{onload:function(){var mt=charts$4[nt.chartIndex];this.width===0&&(css$b(this,{position:"absolute",top:"-999em"}),doc$j.body.appendChild(this)),symbolSizes[ft]={width:this.width,height:this.height},gt.imgwidth=this.width,gt.imgheight=this.height,gt.element&&vt(gt),this.parentNode&&this.parentNode.removeChild(this),nt.imgCount--,!nt.imgCount&&mt&&!mt.hasLoaded&&mt.onload()},src:ft}),this.imgCount++)}return ht},z.prototype.clipRect=function(y,a,k,j){var et=uniqueKey$6()+"-",it=this.createElement("clipPath").attr({id:et}).add(this.defs),nt=this.rect(y,a,k,j,0).add(it);return nt.id=et,nt.clipPath=it,nt.count=0,nt},z.prototype.text=function(y,a,k,j){var et=this,it={};if(j&&(et.allowHTML||!et.forExport))return et.html(y,a,k);it.x=Math.round(a||0),k&&(it.y=Math.round(k)),defined$U(y)&&(it.text=y);var nt=et.createElement("text").attr(it);return(!j||et.forExport&&!et.allowHTML)&&(nt.xSetter=function(ot,at,lt){for(var ct=lt.getElementsByTagName("tspan"),ht=lt.getAttribute(at),ut=0,ft=void 0;ut<ct.length;ut++)ft=ct[ut],ft.getAttribute(at)===ht&&ft.setAttribute(at,ot);lt.setAttribute(at,ot)}),nt},z.prototype.fontMetrics=function(y,a){(this.styledMode||!/px/.test(y))&&win$c.getComputedStyle?y=a&&SVGElement.prototype.getStyle.call(a,"font-size"):y=y||a&&a.style&&a.style.fontSize||this.style&&this.style.fontSize,/px/.test(y)?y=pInt$6(y):y=12;var k=y<24?y+3:Math.round(y*1.2),j=Math.round(k*.8);return{h:k,b:j,f:y}},z.prototype.rotCorr=function(y,a,k){var j=y;return a&&k&&(j=Math.max(j*Math.cos(a*deg2rad$8),4)),{x:-y/3*Math.sin(a*deg2rad$8),y:j}},z.prototype.pathToSegments=function(y){for(var a=[],k=[],j={A:8,C:7,H:2,L:3,M:3,Q:5,S:5,T:3,V:2},et=0;et<y.length;et++)isString$9(k[0])&&isNumber$P(y[et])&&k.length===j[k[0].toUpperCase()]&&y.splice(et,0,k[0].replace("M","L").replace("m","l")),typeof y[et]=="string"&&(k.length&&a.push(k.slice(0)),k.length=0),k.push(y[et]);return a.push(k.slice(0)),a},z.prototype.label=function(y,a,k,j,et,it,nt,ot,at){return new SVGLabel(this,y,a,k,j,et,it,nt,ot,at)},z.prototype.alignElements=function(){this.alignedObjects.forEach(function(y){return y.align()})},z})();extend$1u(SVGRenderer.prototype,{Element:SVGElement,SVG_NS,escapes:{"&":"&amp;","<":"&lt;",">":"&gt;","'":"&#39;",'"':"&quot;"},symbols:Symbols,draw:noop$j});RendererRegistry$1.registerRendererType("svg",SVGRenderer,!0);var __extends$2g=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),isFirefox$2=H.isFirefox,isMS$1=H.isMS,isWebKit=H.isWebKit,win$b=H.win,css$a=Utilities.css,defined$T=Utilities.defined,extend$1t=Utilities.extend,pick$1A=Utilities.pick,pInt$5=Utilities.pInt,HTMLElement$1=(function(z){__extends$2g(y,z);function y(){return z!==null&&z.apply(this,arguments)||this}return y.compose=function(a){if(y.composedClasses.indexOf(a)===-1){y.composedClasses.push(a);var k=y.prototype,j=a.prototype;j.getSpanCorrection=k.getSpanCorrection,j.htmlCss=k.htmlCss,j.htmlGetBBox=k.htmlGetBBox,j.htmlUpdateTransform=k.htmlUpdateTransform,j.setSpanRotation=k.setSpanRotation}return a},y.prototype.getSpanCorrection=function(a,k,j){this.xCorr=-a*j,this.yCorr=-k},y.prototype.htmlCss=function(a){var k=this,j=k.element,et=j.tagName==="SPAN"&&a&&"width"in a,it=pick$1A(et&&a.width,void 0),nt;return et&&(delete a.width,k.textWidth=it,nt=!0),a&&a.textOverflow==="ellipsis"&&(a.whiteSpace="nowrap",a.overflow="hidden"),k.styles=extend$1t(k.styles,a),css$a(k.element,a),nt&&k.htmlUpdateTransform(),k},y.prototype.htmlGetBBox=function(){var a=this,k=a.element;return{x:k.offsetLeft,y:k.offsetTop,width:k.offsetWidth,height:k.offsetHeight}},y.prototype.htmlUpdateTransform=function(){if(!this.added){this.alignOnAdd=!0;return}var a=this,k=a.renderer,j=a.element,et=a.translateX||0,it=a.translateY||0,nt=a.x||0,ot=a.y||0,at=a.textAlign||"left",lt={left:0,center:.5,right:1}[at],ct=a.styles,ht=ct&&ct.whiteSpace;function ut(){return css$a(j,{width:"",whiteSpace:ht||"nowrap"}),j.offsetWidth}if(css$a(j,{marginLeft:et,marginTop:it}),!k.styledMode&&a.shadows&&a.shadows.forEach(function(bt){css$a(bt,{marginLeft:et+1,marginTop:it+1})}),a.inverted&&[].forEach.call(j.childNodes,function(bt){k.invertChild(bt,j)}),j.tagName==="SPAN"){var ft=a.rotation,vt=a.textWidth&&pInt$5(a.textWidth),gt=[ft,at,j.innerHTML,a.textWidth,a.textAlign].join(","),mt=void 0;vt!==a.oldTextWidth&&(vt>a.oldTextWidth||(a.textPxLength||ut())>vt)&&(/[ \-]/.test(j.textContent||j.innerText)||j.style.textOverflow==="ellipsis")?(css$a(j,{width:vt+"px",display:"block",whiteSpace:ht||"normal"}),a.oldTextWidth=vt,a.hasBoxWidthChanged=!0):a.hasBoxWidthChanged=!1,gt!==a.cTT&&(mt=k.fontMetrics(j.style.fontSize,j).b,defined$T(ft)&&(ft!==(a.oldRotation||0)||at!==a.oldAlign)&&a.setSpanRotation(ft,lt,mt),a.getSpanCorrection(!defined$T(ft)&&a.textPxLength||j.offsetWidth,mt,lt,ft,at)),css$a(j,{left:nt+(a.xCorr||0)+"px",top:ot+(a.yCorr||0)+"px"}),a.cTT=gt,a.oldRotation=ft,a.oldAlign=at}},y.prototype.setSpanRotation=function(a,k,j){var et=function(){return isMS$1&&!/Edge/.test(win$b.navigator.userAgent)?"-ms-transform":isWebKit?"-webkit-transform":isFirefox$2?"MozTransform":win$b.opera?"-o-transform":void 0},it={},nt=et();nt&&(it[nt]=it.transform="rotate("+a+"deg)",it[nt+(isFirefox$2?"Origin":"-origin")]=it.transformOrigin=k*100+"% "+j+"px",css$a(this.element,it))},y.composedClasses=[],y})(SVGElement),__extends$2f=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),attr$3=Utilities.attr,createElement$7=Utilities.createElement,extend$1s=Utilities.extend,pick$1z=Utilities.pick,HTMLRenderer=(function(z){__extends$2f(y,z);function y(){return z!==null&&z.apply(this,arguments)||this}return y.compose=function(a){if(y.composedClasses.indexOf(a)===-1){y.composedClasses.push(a);var k=y.prototype,j=a.prototype;j.html=k.html}return a},y.prototype.html=function(a,k,j){var et=this.createElement("span"),it=et.element,nt=et.renderer,ot=nt.isSVG,at=function(lt,ct){["opacity","visibility"].forEach(function(ht){lt[ht+"Setter"]=function(ut,ft,vt){var gt=lt.div?lt.div.style:ct;SVGElement.prototype[ht+"Setter"].call(this,ut,ft,vt),gt&&(gt[ft]=ut)}}),lt.addedSetters=!0};return et.textSetter=function(lt){lt!==this.textStr&&(delete this.bBox,delete this.oldTextWidth,AST.setElementHTML(this.element,pick$1z(lt,"")),this.textStr=lt,et.doTransform=!0)},ot&&at(et,et.element.style),et.xSetter=et.ySetter=et.alignSetter=et.rotationSetter=function(lt,ct){ct==="align"?et.alignValue=et.textAlign=lt:et[ct]=lt,et.doTransform=!0},et.afterSetters=function(){this.doTransform&&(this.htmlUpdateTransform(),this.doTransform=!1)},et.attr({text:a,x:Math.round(k),y:Math.round(j)}).css({position:"absolute"}),nt.styledMode||et.css({fontFamily:this.style.fontFamily,fontSize:this.style.fontSize}),it.style.whiteSpace="nowrap",et.css=et.htmlCss,ot&&(et.add=function(lt){var ct=nt.box.parentNode,ht=[],ut,ft;if(this.parentGroup=lt,lt){if(ut=lt.div,!ut){for(ft=lt;ft;)ht.push(ft),ft=ft.parentGroup;ht.reverse().forEach(function(vt){var gt=attr$3(vt.element,"class");function mt(wt,Mt){vt[Mt]=wt,Mt==="translateX"?xt.left=wt+"px":xt.top=wt+"px",vt.doTransform=!0}var bt=vt.styles||{};ut=vt.div=vt.div||createElement$7("div",gt?{className:gt}:void 0,{position:"absolute",left:(vt.translateX||0)+"px",top:(vt.translateY||0)+"px",display:vt.display,opacity:vt.opacity,cursor:bt.cursor,pointerEvents:bt.pointerEvents,visibility:vt.visibility},ut||ct);var xt=ut.style;extend$1s(vt,{classSetter:(function(wt){return function(Mt){this.element.setAttribute("class",Mt),wt.className=Mt}})(ut),on:function(){return ht[0].div&&et.on.apply({element:ht[0].div,onEvents:vt.onEvents},arguments),vt},translateXSetter:mt,translateYSetter:mt}),vt.addedSetters||at(vt)})}}else ut=ct;return ut.appendChild(it),et.added=!0,et.alignOnAdd&&et.htmlUpdateTransform(),et}),et},y.composedClasses=[],y})(SVGRenderer),AxisDefaults;(function(z){z.defaultXAxisOptions={alignTicks:!0,allowDecimals:void 0,panningEnabled:!0,zIndex:2,zoomEnabled:!0,dateTimeLabelFormats:{millisecond:{main:"%H:%M:%S.%L",range:!1},second:{main:"%H:%M:%S",range:!1},minute:{main:"%H:%M",range:!1},hour:{main:"%H:%M",range:!1},day:{main:"%e. %b"},week:{main:"%e. %b"},month:{main:"%b '%y"},year:{main:"%Y"}},endOnTick:!1,gridLineDashStyle:"Solid",gridZIndex:1,labels:{autoRotation:void 0,autoRotationLimit:80,distance:void 0,enabled:!0,indentation:10,overflow:"justify",padding:5,reserveSpace:void 0,rotation:void 0,staggerLines:0,step:0,useHTML:!1,x:0,zIndex:7,style:{color:palette.neutralColor60,cursor:"default",fontSize:"11px"}},maxPadding:.01,minorGridLineDashStyle:"Solid",minorTickLength:2,minorTickPosition:"outside",minPadding:.01,offset:void 0,opposite:!1,reversed:void 0,reversedStacks:!1,showEmpty:!0,showFirstLabel:!0,showLastLabel:!0,startOfWeek:1,startOnTick:!1,tickLength:10,tickPixelInterval:100,tickmarkPlacement:"between",tickPosition:"outside",title:{align:"middle",rotation:0,useHTML:!1,x:0,y:0,style:{color:palette.neutralColor60}},type:"linear",uniqueNames:!0,visible:!0,minorGridLineColor:palette.neutralColor5,minorGridLineWidth:1,minorTickColor:palette.neutralColor40,lineColor:palette.highlightColor20,lineWidth:1,gridLineColor:palette.neutralColor10,gridLineWidth:void 0,tickColor:palette.highlightColor20},z.defaultYAxisOptions={reversedStacks:!0,endOnTick:!0,maxPadding:.05,minPadding:.05,tickPixelInterval:72,showLastLabel:!0,labels:{x:-8},startOnTick:!0,title:{rotation:270,text:"Values"},stackLabels:{animation:{},allowOverlap:!1,enabled:!1,crop:!0,overflow:"justify",formatter:function(){var y=this.axis.chart.numberFormatter;return y(this.total,-1)},style:{color:palette.neutralColor100,fontSize:"11px",fontWeight:"bold",textOutline:"1px contrast"}},gridLineWidth:1,lineWidth:0},z.defaultLeftAxisOptions={labels:{x:-15},title:{rotation:270}},z.defaultRightAxisOptions={labels:{x:15},title:{rotation:90}},z.defaultBottomAxisOptions={labels:{autoRotation:[-45],x:0},margin:15,title:{rotation:0}},z.defaultTopAxisOptions={labels:{autoRotation:[-45],x:0},margin:15,title:{rotation:0}}})(AxisDefaults||(AxisDefaults={}));const AxisDefaults$1=AxisDefaults;var addEvent$16=Utilities.addEvent,isFunction$3=Utilities.isFunction,objectEach$w=Utilities.objectEach,removeEvent$a=Utilities.removeEvent,registerEventOptions$3=function(z,y){z.eventOptions=z.eventOptions||{},objectEach$w(y.events,function(a,k){z.eventOptions[k]!==a&&(z.eventOptions[k]&&(removeEvent$a(z,k,z.eventOptions[k]),delete z.eventOptions[k]),isFunction$3(a)&&(z.eventOptions[k]=a,addEvent$16(z,k,a)))})},exports$5={registerEventOptions:registerEventOptions$3},deg2rad$7=H.deg2rad,clamp$j=Utilities.clamp,correctFloat$c=Utilities.correctFloat,defined$S=Utilities.defined,destroyObjectProperties$8=Utilities.destroyObjectProperties,extend$1r=Utilities.extend,fireEvent$A=Utilities.fireEvent,isNumber$O=Utilities.isNumber,merge$1p=Utilities.merge,objectEach$v=Utilities.objectEach,pick$1y=Utilities.pick,Tick=(function(){function z(y,a,k,j,et){this.isNew=!0,this.isNewLabel=!0,this.axis=y,this.pos=a,this.type=k||"",this.parameters=et||{},this.tickmarkOffset=this.parameters.tickmarkOffset,this.options=this.parameters.options,fireEvent$A(this,"init"),!k&&!j&&this.addLabel()}return z.prototype.addLabel=function(){var y=this,a=y.axis,k=a.options,j=a.chart,et=a.categories,it=a.logarithmic,nt=a.names,ot=y.pos,at=pick$1y(y.options&&y.options.labels,k.labels),lt=a.tickPositions,ct=ot===lt[0],ht=ot===lt[lt.length-1],ut=(!at.step||at.step===1)&&a.tickInterval===1,ft=lt.info,vt=y.label,gt,mt,bt,xt=this.parameters.category||(et?pick$1y(et[ot],nt[ot],ot):ot);it&&isNumber$O(xt)&&(xt=correctFloat$c(it.lin2log(xt))),a.dateTime&&(ft?(mt=j.time.resolveDTLFormat(k.dateTimeLabelFormats[!k.grid&&ft.higherRanks[ot]||ft.unitName]),gt=mt.main):isNumber$O(xt)&&(gt=a.dateTime.getXDateFormat(xt,k.dateTimeLabelFormats||{}))),y.isFirst=ct,y.isLast=ht;var wt={axis:a,chart:j,dateTimeLabelFormat:gt,isFirst:ct,isLast:ht,pos:ot,tick:y,tickPositionInfo:ft,value:xt};fireEvent$A(this,"labelFormat",wt);var Mt=function(kt){return at.formatter?at.formatter.call(kt,kt):at.format?(kt.text=a.defaultLabelFormatter.call(kt),FormatUtilities.format(at.format,kt,j)):a.defaultLabelFormatter.call(kt,kt)},Et=Mt.call(wt,wt),St=mt&&mt.list;St?y.shortenLabel=function(){for(bt=0;bt<St.length;bt++)if(extend$1r(wt,{dateTimeLabelFormat:St[bt]}),vt.attr({text:Mt.call(wt,wt)}),vt.getBBox().width<a.getSlotWidth(y)-2*at.padding)return;vt.attr({text:""})}:y.shortenLabel=void 0,ut&&a._addedPlotLB&&y.moveLabel(Et,at),!defined$S(vt)&&!y.movedLabel?(y.label=vt=y.createLabel({x:0,y:0},Et,at),y.rotation=0):vt&&vt.textStr!==Et&&!ut&&(vt.textWidth&&!at.style.width&&!vt.styles.width&&vt.css({width:null}),vt.attr({text:Et}),vt.textPxLength=vt.getBBox().width)},z.prototype.createLabel=function(y,a,k){var j=this.axis,et=j.chart,it=defined$S(a)&&k.enabled?et.renderer.text(a,y.x,y.y,k.useHTML).add(j.labelGroup):null;return it&&(et.styledMode||it.css(merge$1p(k.style)),it.textPxLength=it.getBBox().width),it},z.prototype.destroy=function(){destroyObjectProperties$8(this,this.axis)},z.prototype.getPosition=function(y,a,k,j){var et=this.axis,it=et.chart,nt=j&&it.oldChartHeight||it.chartHeight,ot={x:y?correctFloat$c(et.translate(a+k,null,null,j)+et.transB):et.left+et.offset+(et.opposite?(j&&it.oldChartWidth||it.chartWidth)-et.right-et.left:0),y:y?nt-et.bottom+et.offset-(et.opposite?et.height:0):correctFloat$c(nt-et.translate(a+k,null,null,j)-et.transB)};return ot.y=clamp$j(ot.y,-1e5,1e5),fireEvent$A(this,"afterGetPosition",{pos:ot}),ot},z.prototype.getLabelPosition=function(y,a,k,j,et,it,nt,ot){var at=this.axis,lt=at.transA,ct=at.isLinked&&at.linkedParent?at.linkedParent.reversed:at.reversed,ht=at.staggerLines,ut=at.tickRotCorr||{x:0,y:0},ft=!j&&!at.reserveSpaceDefault?-at.labelOffset*(at.labelAlign==="center"?.5:1):0,vt={},gt=et.y,mt;return defined$S(gt)||(at.side===0?gt=k.rotation?-8:-k.getBBox().height:at.side===2?gt=ut.y+8:gt=Math.cos(k.rotation*deg2rad$7)*(ut.y-k.getBBox(!1,0).height/2)),y=y+et.x+ft+ut.x-(it&&j?it*lt*(ct?-1:1):0),a=a+gt-(it&&!j?it*lt*(ct?1:-1):0),ht&&(mt=nt/(ot||1)%ht,at.opposite&&(mt=ht-mt-1),a+=mt*(at.labelOffset/ht)),vt.x=y,vt.y=Math.round(a),fireEvent$A(this,"afterGetLabelPosition",{pos:vt,tickmarkOffset:it,index:nt}),vt},z.prototype.getLabelSize=function(){return this.label?this.label.getBBox()[this.axis.horiz?"height":"width"]:0},z.prototype.getMarkPath=function(y,a,k,j,et,it){return it.crispLine([["M",y,a],["L",y+(et?0:-k),a+(et?k:0)]],j)},z.prototype.handleOverflow=function(y){var a=this,k=this.axis,j=k.options.labels,et=y.x,it=k.chart.chartWidth,nt=k.chart.spacing,ot=pick$1y(k.labelLeft,Math.min(k.pos,nt[3])),at=pick$1y(k.labelRight,Math.max(k.isRadial?0:k.pos+k.len,it-nt[1])),lt=this.label,ct=this.rotation,ht={left:0,center:.5,right:1}[k.labelAlign||lt.attr("align")],ut=lt.getBBox().width,ft=k.getSlotWidth(a),vt=ht,gt={},mt=ft,bt=1,xt,wt,Mt;!ct&&j.overflow==="justify"?(xt=et-ht*ut,wt=et+(1-ht)*ut,xt<ot?mt=y.x+mt*(1-ht)-ot:wt>at&&(mt=at-y.x+mt*ht,bt=-1),mt=Math.min(ft,mt),mt<ft&&k.labelAlign==="center"&&(y.x+=bt*(ft-mt-vt*(ft-Math.min(ut,mt)))),(ut>mt||k.autoRotation&&(lt.styles||{}).width)&&(Mt=mt)):ct<0&&et-ht*ut<ot?Mt=Math.round(et/Math.cos(ct*deg2rad$7)-ot):ct>0&&et+ht*ut>at&&(Mt=Math.round((it-et)/Math.cos(ct*deg2rad$7))),Mt&&(a.shortenLabel?a.shortenLabel():(gt.width=Math.floor(Mt)+"px",(j.style||{}).textOverflow||(gt.textOverflow="ellipsis"),lt.css(gt)))},z.prototype.moveLabel=function(y,a){var k=this,j=k.label,et=k.axis,it=et.reversed,nt=!1,ot,at,lt;j&&j.textStr===y?(k.movedLabel=j,nt=!0,delete k.label):objectEach$v(et.ticks,function(ct){!nt&&!ct.isNew&&ct!==k&&ct.label&&ct.label.textStr===y&&(k.movedLabel=ct.label,nt=!0,ct.labelPos=k.movedLabel.xy,delete ct.label)}),!nt&&(k.labelPos||j)&&(ot=k.labelPos||j.xy,at=et.horiz?it?0:et.width+et.left:ot.x,lt=et.horiz?ot.y:it?et.width+et.left:0,k.movedLabel=k.createLabel({x:at,y:lt},y,a),k.movedLabel&&k.movedLabel.attr({opacity:0}))},z.prototype.render=function(y,a,k){var j=this,et=j.axis,it=et.horiz,nt=j.pos,ot=pick$1y(j.tickmarkOffset,et.tickmarkOffset),at=j.getPosition(it,nt,ot,a),lt=at.x,ct=at.y,ht=it&&lt===et.pos+et.len||!it&&ct===et.pos?-1:1,ut=pick$1y(k,j.label&&j.label.newOpacity,1);k=pick$1y(k,1),this.isActive=!0,this.renderGridLine(a,k,ht),this.renderMark(at,k,ht),this.renderLabel(at,a,ut,y),j.isNew=!1,fireEvent$A(this,"afterRender")},z.prototype.renderGridLine=function(y,a,k){var j=this,et=j.axis,it=et.options,nt={},ot=j.pos,at=j.type,lt=pick$1y(j.tickmarkOffset,et.tickmarkOffset),ct=et.chart.renderer,ht=j.gridLine,ut,ft=it.gridLineWidth,vt=it.gridLineColor,gt=it.gridLineDashStyle;j.type==="minor"&&(ft=it.minorGridLineWidth,vt=it.minorGridLineColor,gt=it.minorGridLineDashStyle),ht||(et.chart.styledMode||(nt.stroke=vt,nt["stroke-width"]=ft||0,nt.dashstyle=gt),at||(nt.zIndex=1),y&&(a=0),j.gridLine=ht=ct.path().attr(nt).addClass("highcharts-"+(at?at+"-":"")+"grid-line").add(et.gridGroup)),ht&&(ut=et.getPlotLinePath({value:ot+lt,lineWidth:ht.strokeWidth()*k,force:"pass",old:y}),ut&&ht[y||j.isNew?"attr":"animate"]({d:ut,opacity:a}))},z.prototype.renderMark=function(y,a,k){var j=this,et=j.axis,it=et.options,nt=et.chart.renderer,ot=j.type,at=et.tickSize(ot?ot+"Tick":"tick"),lt=y.x,ct=y.y,ht=pick$1y(it[ot!=="minor"?"tickWidth":"minorTickWidth"],!ot&&et.isXAxis?1:0),ut=it[ot!=="minor"?"tickColor":"minorTickColor"],ft=j.mark,vt=!ft;at&&(et.opposite&&(at[0]=-at[0]),ft||(j.mark=ft=nt.path().addClass("highcharts-"+(ot?ot+"-":"")+"tick").add(et.axisGroup),et.chart.styledMode||ft.attr({stroke:ut,"stroke-width":ht})),ft[vt?"attr":"animate"]({d:j.getMarkPath(lt,ct,at[0],ft.strokeWidth()*k,et.horiz,nt),opacity:a}))},z.prototype.renderLabel=function(y,a,k,j){var et=this,it=et.axis,nt=it.horiz,ot=it.options,at=et.label,lt=ot.labels,ct=lt.step,ht=pick$1y(et.tickmarkOffset,it.tickmarkOffset),ut=y.x,ft=y.y,vt=!0;at&&isNumber$O(ut)&&(at.xy=y=et.getLabelPosition(ut,ft,at,nt,lt,ht,j,ct),et.isFirst&&!et.isLast&&!ot.showFirstLabel||et.isLast&&!et.isFirst&&!ot.showLastLabel?vt=!1:nt&&!lt.step&&!lt.rotation&&!a&&k!==0&&et.handleOverflow(y),ct&&j%ct&&(vt=!1),vt&&isNumber$O(y.y)?(y.opacity=k,at[et.isNewLabel?"attr":"animate"](y),et.isNewLabel=!1):(at.attr("y",-9999),et.isNewLabel=!0))},z.prototype.replaceMovedLabel=function(){var y=this,a=y.label,k=y.axis,j=k.reversed,et,it;a&&!y.isNew&&(et=k.horiz?j?k.left:k.width+k.left:a.xy.x,it=k.horiz?a.xy.y:j?k.width+k.top:k.top,a.animate({x:et,y:it,opacity:0},void 0,a.destroy),delete y.label),k.isDirty=!0,y.label=y.movedLabel,delete y.movedLabel},z})(),animObject$b=animationExports.animObject,defaultOptions$h=DefaultOptions.defaultOptions,registerEventOptions$2=exports$5.registerEventOptions,deg2rad$6=H.deg2rad,arrayMax$9=Utilities.arrayMax,arrayMin$8=Utilities.arrayMin,clamp$i=Utilities.clamp,correctFloat$b=Utilities.correctFloat,defined$R=Utilities.defined,destroyObjectProperties$7=Utilities.destroyObjectProperties,erase$8=Utilities.erase,error$9=Utilities.error,extend$1q=Utilities.extend,fireEvent$z=Utilities.fireEvent,getMagnitude$2=Utilities.getMagnitude,isArray$m=Utilities.isArray,isNumber$N=Utilities.isNumber,isString$8=Utilities.isString,merge$1o=Utilities.merge,normalizeTickInterval$2=Utilities.normalizeTickInterval,objectEach$u=Utilities.objectEach,pick$1x=Utilities.pick,relativeLength$9=Utilities.relativeLength,removeEvent$9=Utilities.removeEvent,splat$i=Utilities.splat,syncTimeout$7=Utilities.syncTimeout,Axis=(function(){function z(y,a){this.alternateBands=void 0,this.bottom=void 0,this.categories=void 0,this.chart=void 0,this.closestPointRange=void 0,this.coll=void 0,this.eventOptions=void 0,this.hasNames=void 0,this.hasVisibleSeries=void 0,this.height=void 0,this.isLinked=void 0,this.labelEdge=void 0,this.labelFormatter=void 0,this.left=void 0,this.len=void 0,this.max=void 0,this.maxLabelLength=void 0,this.min=void 0,this.minorTickInterval=void 0,this.minorTicks=void 0,this.minPixelPadding=void 0,this.names=void 0,this.offset=void 0,this.options=void 0,this.overlap=void 0,this.paddedTicks=void 0,this.plotLinesAndBands=void 0,this.plotLinesAndBandsGroups=void 0,this.pointRange=void 0,this.pointRangePadding=void 0,this.pos=void 0,this.positiveValuesOnly=void 0,this.right=void 0,this.series=void 0,this.side=void 0,this.tickAmount=void 0,this.tickInterval=void 0,this.tickmarkOffset=void 0,this.tickPositions=void 0,this.tickRotCorr=void 0,this.ticks=void 0,this.top=void 0,this.transA=void 0,this.transB=void 0,this.translationSlope=void 0,this.userOptions=void 0,this.visible=void 0,this.width=void 0,this.zoomEnabled=void 0,this.init(y,a)}return z.prototype.init=function(y,a){var k=a.isX,j=this;j.chart=y,j.horiz=y.inverted&&!j.isZAxis?!k:k,j.isXAxis=k,j.coll=j.coll||(k?"xAxis":"yAxis"),fireEvent$z(this,"init",{userOptions:a}),j.opposite=pick$1x(a.opposite,j.opposite),j.side=pick$1x(a.side,j.side,j.horiz?j.opposite?0:2:j.opposite?1:3),j.setOptions(a);var et=this.options,it=et.labels,nt=et.type;j.userOptions=a,j.minPixelPadding=0,j.reversed=pick$1x(et.reversed,j.reversed),j.visible=et.visible,j.zoomEnabled=et.zoomEnabled,j.hasNames=nt==="category"||et.categories===!0,j.categories=et.categories||j.hasNames,j.names||(j.names=[],j.names.keys={}),j.plotLinesAndBandsGroups={},j.positiveValuesOnly=!!j.logarithmic,j.isLinked=defined$R(et.linkedTo),j.ticks={},j.labelEdge=[],j.minorTicks={},j.plotLinesAndBands=[],j.alternateBands={},j.len=0,j.minRange=j.userMinRange=et.minRange||et.maxZoom,j.range=et.range,j.offset=et.offset||0,j.max=null,j.min=null;var ot=pick$1x(et.crosshair,splat$i(y.options.tooltip.crosshairs)[k?0:1]);j.crosshair=ot===!0?{}:ot,y.axes.indexOf(j)===-1&&(k?y.axes.splice(y.xAxis.length,0,j):y.axes.push(j),y[j.coll].push(j)),j.series=j.series||[],y.inverted&&!j.isZAxis&&k&&typeof j.reversed>"u"&&(j.reversed=!0),j.labelRotation=isNumber$N(it.rotation)?it.rotation:void 0,registerEventOptions$2(j,et),fireEvent$z(this,"afterInit")},z.prototype.setOptions=function(y){this.options=merge$1o(AxisDefaults$1.defaultXAxisOptions,this.coll==="yAxis"&&AxisDefaults$1.defaultYAxisOptions,[AxisDefaults$1.defaultTopAxisOptions,AxisDefaults$1.defaultRightAxisOptions,AxisDefaults$1.defaultBottomAxisOptions,AxisDefaults$1.defaultLeftAxisOptions][this.side],merge$1o(defaultOptions$h[this.coll],y)),fireEvent$z(this,"afterSetOptions",{userOptions:y})},z.prototype.defaultLabelFormatter=function(y){var a=this.axis,k=this.chart,j=k.numberFormatter,et=isNumber$N(this.value)?this.value:NaN,it=a.chart.time,nt=a.categories,ot=this.dateTimeLabelFormat,at=defaultOptions$h.lang,lt=at.numericSymbols,ct=at.numericSymbolMagnitude||1e3,ht=a.logarithmic?Math.abs(et):a.tickInterval,ut=lt&&lt.length,ft,vt;if(nt)vt=""+this.value;else if(ot)vt=it.dateFormat(ot,et);else if(ut&&ht>=1e3)for(;ut--&&typeof vt>"u";)ft=Math.pow(ct,ut+1),ht>=ft&&et*10%ft===0&&lt[ut]!==null&&et!==0&&(vt=j(et/ft,-1)+lt[ut]);return typeof vt>"u"&&(Math.abs(et)>=1e4?vt=j(et,-1):vt=j(et,-1,void 0,"")),vt},z.prototype.getSeriesExtremes=function(){var y=this,a=y.chart,k;fireEvent$z(this,"getSeriesExtremes",null,function(){y.hasVisibleSeries=!1,y.dataMin=y.dataMax=y.threshold=null,y.softThreshold=!y.isXAxis,y.stacking&&y.stacking.buildStacks(),y.series.forEach(function(j){if(j.visible||!a.options.chart.ignoreHiddenSeries){var et=j.options,it=void 0,nt=et.threshold,ot=void 0,at=void 0;if(y.hasVisibleSeries=!0,y.positiveValuesOnly&&nt<=0&&(nt=null),y.isXAxis)it=j.xData,it.length&&(it=y.logarithmic?it.filter(y.validatePositiveValue):it,k=j.getXExtremes(it),ot=k.min,at=k.max,!isNumber$N(ot)&&!(ot instanceof Date)&&(it=it.filter(isNumber$N),k=j.getXExtremes(it),ot=k.min,at=k.max),it.length&&(y.dataMin=Math.min(pick$1x(y.dataMin,ot),ot),y.dataMax=Math.max(pick$1x(y.dataMax,at),at)));else{var lt=j.applyExtremes();isNumber$N(lt.dataMin)&&(ot=lt.dataMin,y.dataMin=Math.min(pick$1x(y.dataMin,ot),ot)),isNumber$N(lt.dataMax)&&(at=lt.dataMax,y.dataMax=Math.max(pick$1x(y.dataMax,at),at)),defined$R(nt)&&(y.threshold=nt),(!et.softThreshold||y.positiveValuesOnly)&&(y.softThreshold=!1)}}})}),fireEvent$z(this,"afterGetSeriesExtremes")},z.prototype.translate=function(y,a,k,j,et,it){var nt=this.linkedParent||this,ot=j&&nt.old?nt.old.min:nt.min,at=nt.minPixelPadding,lt=(nt.isOrdinal||nt.brokenAxis&&nt.brokenAxis.hasBreaks||nt.logarithmic&&et)&&nt.lin2val,ct=1,ht=0,ut=j&&nt.old?nt.old.transA:nt.transA,ft=0;return ut||(ut=nt.transA),k&&(ct*=-1,ht=nt.len),nt.reversed&&(ct*=-1,ht-=ct*(nt.sector||nt.len)),a?(y=y*ct+ht,y-=at,ft=y/ut+ot,lt&&(ft=nt.lin2val(ft))):(lt&&(y=nt.val2lin(y)),ft=isNumber$N(ot)?ct*(y-ot)*ut+ht+ct*at+(isNumber$N(it)?ut*it:0):void 0),ft},z.prototype.toPixels=function(y,a){return this.translate(y,!1,!this.horiz,null,!0)+(a?0:this.pos)},z.prototype.toValue=function(y,a){return this.translate(y-(a?0:this.pos),!0,!this.horiz,null,!0)},z.prototype.getPlotLinePath=function(y){var a=this,k=a.chart,j=a.left,et=a.top,it=y.old,nt=y.value,ot=y.lineWidth,at=it&&k.oldChartHeight||k.chartHeight,lt=it&&k.oldChartWidth||k.chartWidth,ct=a.transB,ht=y.translatedValue,ut=y.force,ft,vt,gt,mt,bt;function xt(Mt,Et,St){return(ut!=="pass"&&Mt<Et||Mt>St)&&(ut?Mt=clamp$i(Mt,Et,St):bt=!0),Mt}var wt={value:nt,lineWidth:ot,old:it,force:ut,acrossPanes:y.acrossPanes,translatedValue:ht};return fireEvent$z(this,"getPlotLinePath",wt,function(Mt){ht=pick$1x(ht,a.translate(nt,null,null,it)),ht=clamp$i(ht,-1e5,1e5),ft=gt=Math.round(ht+ct),vt=mt=Math.round(at-ht-ct),isNumber$N(ht)?a.horiz?(vt=et,mt=at-a.bottom,ft=gt=xt(ft,j,j+a.width)):(ft=j,gt=lt-a.right,vt=mt=xt(vt,et,et+a.height)):(bt=!0,ut=!1),Mt.path=bt&&!ut?null:k.renderer.crispLine([["M",ft,vt],["L",gt,mt]],ot||1)}),wt.path},z.prototype.getLinearTickPositions=function(y,a,k){var j=correctFloat$b(Math.floor(a/y)*y),et=correctFloat$b(Math.ceil(k/y)*y),it=[],nt,ot,at;if(correctFloat$b(j+y)===j&&(at=20),this.single)return[a];for(nt=j;nt<=et&&(it.push(nt),nt=correctFloat$b(nt+y,at),nt!==ot);)ot=nt;return it},z.prototype.getMinorTickInterval=function(){var y=this.options;return y.minorTicks===!0?pick$1x(y.minorTickInterval,"auto"):y.minorTicks===!1?null:y.minorTickInterval},z.prototype.getMinorTickPositions=function(){var y=this,a=y.options,k=y.tickPositions,j=y.minorTickInterval,et=y.pointRangePadding||0,it=y.min-et,nt=y.max+et,ot=nt-it,at=[],lt;if(ot&&ot/j<y.len/3){var ct=y.logarithmic;if(ct)this.paddedTicks.forEach(function(ht,ut,ft){ut&&at.push.apply(at,ct.getLogTickPositions(j,ft[ut-1],ft[ut],!0))});else if(y.dateTime&&this.getMinorTickInterval()==="auto")at=at.concat(y.getTimeTicks(y.dateTime.normalizeTimeTickInterval(j),it,nt,a.startOfWeek));else for(lt=it+(k[0]-it)%j;lt<=nt&&lt!==at[0];lt+=j)at.push(lt)}return at.length!==0&&y.trimTicks(at),at},z.prototype.adjustForMinRange=function(){var y=this,a=y.options,k=y.logarithmic,j=y.min,et=y.max,it,nt,ot=0,at,lt,ct,ht,ut,ft,vt;y.isXAxis&&typeof y.minRange>"u"&&!k&&(defined$R(a.min)||defined$R(a.max)?y.minRange=null:(y.series.forEach(function(gt){if(ct=gt.xData,ht=gt.xIncrement?1:ct.length-1,ct.length>1)for(at=ht;at>0;at--)lt=ct[at]-ct[at-1],(!ot||lt<ot)&&(ot=lt)}),y.minRange=Math.min(ot*5,y.dataMax-y.dataMin))),et-j<y.minRange&&(nt=y.dataMax-y.dataMin>=y.minRange,vt=y.minRange,it=(vt-et+j)/2,ut=[j-it,pick$1x(a.min,j-it)],nt&&(ut[2]=y.logarithmic?y.logarithmic.log2lin(y.dataMin):y.dataMin),j=arrayMax$9(ut),ft=[j+vt,pick$1x(a.max,j+vt)],nt&&(ft[2]=k?k.log2lin(y.dataMax):y.dataMax),et=arrayMin$8(ft),et-j<vt&&(ut[0]=et-vt,ut[1]=pick$1x(a.min,et-vt),j=arrayMax$9(ut))),y.min=j,y.max=et},z.prototype.getClosest=function(){var y;return this.categories?y=1:this.series.forEach(function(a){var k=a.closestPointRange,j=a.visible||!a.chart.options.chart.ignoreHiddenSeries;!a.noSharedTooltip&&defined$R(k)&&j&&(y=defined$R(y)?Math.min(y,k):k)}),y},z.prototype.nameToX=function(y){var a=isArray$m(this.categories),k=a?this.categories:this.names,j=y.options.x,et;return y.series.requireSorting=!1,defined$R(j)||(j=this.options.uniqueNames?a?k.indexOf(y.name):pick$1x(k.keys[y.name],-1):y.series.autoIncrement()),j===-1?a||(et=k.length):et=j,typeof et<"u"&&(this.names[et]=y.name,this.names.keys[y.name]=et),et},z.prototype.updateNames=function(){var y=this,a=this.names,k=a.length;k>0&&(Object.keys(a.keys).forEach(function(j){delete a.keys[j]}),a.length=0,this.minRange=this.userMinRange,(this.series||[]).forEach(function(j){j.xIncrement=null,(!j.points||j.isDirtyData)&&(y.max=Math.max(y.max,j.xData.length-1),j.processData(),j.generatePoints()),j.data.forEach(function(et,it){var nt;et&&et.options&&typeof et.name<"u"&&(nt=y.nameToX(et),typeof nt<"u"&&nt!==et.x&&(et.x=nt,j.xData[it]=nt))})}))},z.prototype.setAxisTranslation=function(){var y=this,a=y.max-y.min,k=y.linkedParent,j=!!y.categories,et=y.isXAxis,it=y.axisPointRange||0,nt,ot=0,at=0,lt,ct=y.transA;(et||j||it)&&(nt=y.getClosest(),k?(ot=k.minPointOffset,at=k.pointRangePadding):y.series.forEach(function(ht){var ut=j?1:et?pick$1x(ht.options.pointRange,nt,0):y.axisPointRange||0,ft=ht.options.pointPlacement;if(it=Math.max(it,ut),!y.single||j){var vt=ht.is("xrange")?!et:et;ot=Math.max(ot,vt&&isString$8(ft)?0:ut/2),at=Math.max(at,vt&&ft==="on"?0:ut)}}),lt=y.ordinal&&y.ordinal.slope&&nt?y.ordinal.slope/nt:1,y.minPointOffset=ot=ot*lt,y.pointRangePadding=at=at*lt,y.pointRange=Math.min(it,y.single&&j?1:a),et&&(y.closestPointRange=nt)),y.translationSlope=y.transA=ct=y.staticScale||y.len/(a+at||1),y.transB=y.horiz?y.left:y.bottom,y.minPixelPadding=ct*ot,fireEvent$z(this,"afterSetAxisTranslation")},z.prototype.minFromRange=function(){var y=this;return y.max-y.range},z.prototype.setTickInterval=function(y){var a=this,k=a.chart,j=a.logarithmic,et=a.options,it=a.isXAxis,nt=a.isLinked,ot=et.tickPixelInterval,at=a.categories,lt=a.softThreshold,ct=et.maxPadding,ht=et.minPadding,ut,ft,vt=et.tickInterval,gt=isNumber$N(a.threshold)?a.threshold:null,mt,bt,xt,wt;!a.dateTime&&!at&&!nt&&this.getTickAmount(),xt=pick$1x(a.userMin,et.min),wt=pick$1x(a.userMax,et.max),nt?(a.linkedParent=k[a.coll][et.linkedTo],ft=a.linkedParent.getExtremes(),a.min=pick$1x(ft.min,ft.dataMin),a.max=pick$1x(ft.max,ft.dataMax),et.type!==a.linkedParent.options.type&&error$9(11,1,k)):(lt&&defined$R(gt)&&(a.dataMin>=gt?(mt=gt,ht=0):a.dataMax<=gt&&(bt=gt,ct=0)),a.min=pick$1x(xt,mt,a.dataMin),a.max=pick$1x(wt,bt,a.dataMax)),j&&(a.positiveValuesOnly&&!y&&Math.min(a.min,pick$1x(a.dataMin,a.min))<=0&&error$9(10,1,k),a.min=correctFloat$b(j.log2lin(a.min),16),a.max=correctFloat$b(j.log2lin(a.max),16)),a.range&&defined$R(a.max)&&(a.userMin=a.min=xt=Math.max(a.dataMin,a.minFromRange()),a.userMax=wt=a.max,a.range=null),fireEvent$z(a,"foundExtremes"),a.beforePadding&&a.beforePadding(),a.adjustForMinRange(),!at&&!a.axisPointRange&&!(a.stacking&&a.stacking.usePercentage)&&!nt&&defined$R(a.min)&&defined$R(a.max)&&(ut=a.max-a.min,ut&&(!defined$R(xt)&&ht&&(a.min-=ut*ht),!defined$R(wt)&&ct&&(a.max+=ut*ct))),isNumber$N(a.userMin)||(isNumber$N(et.softMin)&&et.softMin<a.min&&(a.min=xt=et.softMin),isNumber$N(et.floor)&&(a.min=Math.max(a.min,et.floor))),isNumber$N(a.userMax)||(isNumber$N(et.softMax)&&et.softMax>a.max&&(a.max=wt=et.softMax),isNumber$N(et.ceiling)&&(a.max=Math.min(a.max,et.ceiling))),lt&&defined$R(a.dataMin)&&(gt=gt||0,!defined$R(xt)&&a.min<gt&&a.dataMin>=gt?a.min=a.options.minRange?Math.min(gt,a.max-a.minRange):gt:!defined$R(wt)&&a.max>gt&&a.dataMax<=gt&&(a.max=a.options.minRange?Math.max(gt,a.min+a.minRange):gt)),isNumber$N(a.min)&&isNumber$N(a.max)&&!this.chart.polar&&a.min>a.max&&(defined$R(a.options.min)?a.max=a.min:defined$R(a.options.max)&&(a.min=a.max)),a.min===a.max||typeof a.min>"u"||typeof a.max>"u"?a.tickInterval=1:nt&&a.linkedParent&&!vt&&ot===a.linkedParent.options.tickPixelInterval?a.tickInterval=vt=a.linkedParent.tickInterval:a.tickInterval=pick$1x(vt,this.tickAmount?(a.max-a.min)/Math.max(this.tickAmount-1,1):void 0,at?1:(a.max-a.min)*ot/Math.max(a.len,ot)),it&&!y&&(a.series.forEach(function(Et){Et.forceCrop=Et.forceCropping&&Et.forceCropping(),Et.processData(a.min!==(a.old&&a.old.min)||a.max!==(a.old&&a.old.max))}),fireEvent$z(this,"postProcessData")),a.setAxisTranslation(),fireEvent$z(this,"initialAxisTranslation"),a.pointRange&&!vt&&(a.tickInterval=Math.max(a.pointRange,a.tickInterval));var Mt=pick$1x(et.minTickInterval,a.dateTime&&!a.series.some(function(Et){return Et.noSharedTooltip})?a.closestPointRange:0);!vt&&a.tickInterval<Mt&&(a.tickInterval=Mt),!a.dateTime&&!a.logarithmic&&!vt&&(a.tickInterval=normalizeTickInterval$2(a.tickInterval,void 0,getMagnitude$2(a.tickInterval),pick$1x(et.allowDecimals,a.tickInterval<.5||this.tickAmount!==void 0),!!this.tickAmount)),this.tickAmount||(a.tickInterval=a.unsquish()),this.setTickPositions()},z.prototype.setTickPositions=function(){var y=this,a=this.options,k=a.tickPositions,j=this.getMinorTickInterval(),et=this.hasVerticalPanning(),it=this.coll==="colorAxis",nt=(it||!et)&&a.startOnTick,ot=(it||!et)&&a.endOnTick,at,lt=a.tickPositioner;this.tickmarkOffset=this.categories&&a.tickmarkPlacement==="between"&&this.tickInterval===1?.5:0,this.minorTickInterval=j==="auto"&&this.tickInterval?this.tickInterval/5:j,this.single=this.min===this.max&&defined$R(this.min)&&!this.tickAmount&&(parseInt(this.min,10)===this.min||a.allowDecimals!==!1),this.tickPositions=at=k&&k.slice(),at||((!y.ordinal||!y.ordinal.positions)&&(this.max-this.min)/this.tickInterval>Math.max(2*this.len,200)?(at=[this.min,this.max],error$9(19,!1,this.chart)):y.dateTime?at=y.getTimeTicks(y.dateTime.normalizeTimeTickInterval(this.tickInterval,a.units),this.min,this.max,a.startOfWeek,y.ordinal&&y.ordinal.positions,this.closestPointRange,!0):y.logarithmic?at=y.logarithmic.getLogTickPositions(this.tickInterval,this.min,this.max):at=this.getLinearTickPositions(this.tickInterval,this.min,this.max),at.length>this.len&&(at=[at[0],at.pop()],at[0]===at[1]&&(at.length=1)),this.tickPositions=at,lt&&(lt=lt.apply(y,[this.min,this.max]),lt&&(this.tickPositions=at=lt))),this.paddedTicks=at.slice(0),this.trimTicks(at,nt,ot),this.isLinked||(this.single&&at.length<2&&!this.categories&&!this.series.some(function(ct){return ct.is("heatmap")&&ct.options.pointPlacement==="between"})&&(this.min-=.5,this.max+=.5),!k&&!lt&&this.adjustTickAmount()),fireEvent$z(this,"afterSetTickPositions")},z.prototype.trimTicks=function(y,a,k){var j=y[0],et=y[y.length-1],it=!this.isOrdinal&&this.minPointOffset||0;if(fireEvent$z(this,"trimTicks"),!this.isLinked){if(a&&j!==-1/0)this.min=j;else for(;this.min-it>y[0];)y.shift();if(k)this.max=et;else for(;this.max+it<y[y.length-1];)y.pop();y.length===0&&defined$R(j)&&!this.options.tickPositions&&y.push((et+j)/2)}},z.prototype.alignToOthers=function(){var y=this,a={},k=y.options,j;return this.chart.options.chart.alignTicks!==!1&&k.alignTicks&&k.startOnTick!==!1&&k.endOnTick!==!1&&!y.logarithmic&&this.chart[this.coll].forEach(function(et){var it=et.options,nt=et.horiz,ot=[nt?it.left:it.top,it.width,it.height,it.pane].join(",");et.series.length&&(a[ot]?j=!0:a[ot]=1)}),j},z.prototype.getTickAmount=function(){var y=this,a=this.options,k=a.tickPixelInterval,j=a.tickAmount;!defined$R(a.tickInterval)&&!j&&this.len<k&&!this.isRadial&&!y.logarithmic&&a.startOnTick&&a.endOnTick&&(j=2),!j&&this.alignToOthers()&&(j=Math.ceil(this.len/k)+1),j<4&&(this.finalTickAmt=j,j=5),this.tickAmount=j},z.prototype.adjustTickAmount=function(){var y=this,a=y.options,k=y.tickInterval,j=y.tickPositions,et=y.tickAmount,it=y.finalTickAmt,nt=j&&j.length,ot=pick$1x(y.threshold,y.softThreshold?0:null),at,lt;if(y.hasData()&&isNumber$N(y.min)&&isNumber$N(y.max)){if(nt<et){for(;j.length<et;)j.length%2||y.min===ot?j.push(correctFloat$b(j[j.length-1]+k)):j.unshift(correctFloat$b(j[0]-k));y.transA*=(nt-1)/(et-1),y.min=a.startOnTick?j[0]:Math.min(y.min,j[0]),y.max=a.endOnTick?j[j.length-1]:Math.max(y.max,j[j.length-1])}else nt>et&&(y.tickInterval*=2,y.setTickPositions());if(defined$R(it)){for(lt=at=j.length;lt--;)(it===3&&lt%2===1||it<=2&&lt>0&&lt<at-1)&&j.splice(lt,1);y.finalTickAmt=void 0}}},z.prototype.setScale=function(){var y=this,a=!1,k=!1;y.series.forEach(function(et){a=a||et.isDirtyData||et.isDirty,k=k||et.xAxis&&et.xAxis.isDirty||!1}),y.setAxisSize();var j=y.len!==(y.old&&y.old.len);j||a||k||y.isLinked||y.forceRedraw||y.userMin!==(y.old&&y.old.userMin)||y.userMax!==(y.old&&y.old.userMax)||y.alignToOthers()?(y.stacking&&y.stacking.resetStacks(),y.forceRedraw=!1,y.getSeriesExtremes(),y.setTickInterval(),y.isDirty||(y.isDirty=j||y.min!==(y.old&&y.old.min)||y.max!==(y.old&&y.old.max))):y.stacking&&y.stacking.cleanStacks(),a&&y.panningState&&(y.panningState.isDirty=!0),fireEvent$z(this,"afterSetScale")},z.prototype.setExtremes=function(y,a,k,j,et){var it=this,nt=it.chart;k=pick$1x(k,!0),it.series.forEach(function(ot){delete ot.kdTree}),et=extend$1q(et,{min:y,max:a}),fireEvent$z(it,"setExtremes",et,function(){it.userMin=y,it.userMax=a,it.eventArgs=et,k&&nt.redraw(j)})},z.prototype.zoom=function(y,a){var k=this,j=this.dataMin,et=this.dataMax,it=this.options,nt=Math.min(j,pick$1x(it.min,j)),ot=Math.max(et,pick$1x(it.max,et)),at={newMin:y,newMax:a};return fireEvent$z(this,"zoom",at,function(lt){var ct=lt.newMin,ht=lt.newMax;(ct!==k.min||ht!==k.max)&&(k.allowZoomOutside||(defined$R(j)&&(ct<nt&&(ct=nt),ct>ot&&(ct=ot)),defined$R(et)&&(ht<nt&&(ht=nt),ht>ot&&(ht=ot))),k.displayBtn=typeof ct<"u"||typeof ht<"u",k.setExtremes(ct,ht,!1,void 0,{trigger:"zoom"})),lt.zoomed=!0}),at.zoomed},z.prototype.setAxisSize=function(){var y=this.chart,a=this.options,k=a.offsets||[0,0,0,0],j=this.horiz,et=this.width=Math.round(relativeLength$9(pick$1x(a.width,y.plotWidth-k[3]+k[1]),y.plotWidth)),it=this.height=Math.round(relativeLength$9(pick$1x(a.height,y.plotHeight-k[0]+k[2]),y.plotHeight)),nt=this.top=Math.round(relativeLength$9(pick$1x(a.top,y.plotTop+k[0]),y.plotHeight,y.plotTop)),ot=this.left=Math.round(relativeLength$9(pick$1x(a.left,y.plotLeft+k[3]),y.plotWidth,y.plotLeft));this.bottom=y.chartHeight-it-nt,this.right=y.chartWidth-et-ot,this.len=Math.max(j?et:it,0),this.pos=j?ot:nt},z.prototype.getExtremes=function(){var y=this,a=y.logarithmic;return{min:a?correctFloat$b(a.lin2log(y.min)):y.min,max:a?correctFloat$b(a.lin2log(y.max)):y.max,dataMin:y.dataMin,dataMax:y.dataMax,userMin:y.userMin,userMax:y.userMax}},z.prototype.getThreshold=function(y){var a=this,k=a.logarithmic,j=k?k.lin2log(a.min):a.min,et=k?k.lin2log(a.max):a.max;return y===null||y===-1/0?y=j:y===1/0?y=et:j>y?y=j:et<y&&(y=et),a.translate(y,0,1,0,1)},z.prototype.autoLabelAlign=function(y){var a=(pick$1x(y,0)-this.side*90+720)%360,k={align:"center"};return fireEvent$z(this,"autoLabelAlign",k,function(j){a>15&&a<165?j.align="right":a>195&&a<345&&(j.align="left")}),k.align},z.prototype.tickSize=function(y){var a=this.options,k=pick$1x(a[y==="tick"?"tickWidth":"minorTickWidth"],y==="tick"&&this.isXAxis&&!this.categories?1:0),j=a[y==="tick"?"tickLength":"minorTickLength"],et;k&&j&&(a[y+"Position"]==="inside"&&(j=-j),et=[j,k]);var it={tickSize:et};return fireEvent$z(this,"afterTickSize",it),it.tickSize},z.prototype.labelMetrics=function(){var y=this.tickPositions&&this.tickPositions[0]||0;return this.chart.renderer.fontMetrics(this.options.labels.style.fontSize,this.ticks[y]&&this.ticks[y].label)},z.prototype.unsquish=function(){var y=this.options.labels,a=this.horiz,k=this.tickInterval,j=this.len/(((this.categories?1:0)+this.max-this.min)/k),et=y.rotation,it=this.labelMetrics(),nt=Math.max(this.max-this.min,0),ot=function(ft){var vt=ft/(j||1);return vt=vt>1?Math.ceil(vt):1,vt*k>nt&&ft!==1/0&&j!==1/0&&nt&&(vt=Math.ceil(nt/k)),correctFloat$b(vt*k)},at=k,lt,ct,ht=Number.MAX_VALUE,ut;return a?(!y.staggerLines&&!y.step&&(isNumber$N(et)?ut=[et]:j<y.autoRotationLimit&&(ut=y.autoRotation)),ut&&ut.forEach(function(ft){var vt;(ft===et||ft&&ft>=-90&&ft<=90)&&(ct=ot(Math.abs(it.h/Math.sin(deg2rad$6*ft))),vt=ct+Math.abs(ft/360),vt<ht&&(ht=vt,lt=ft,at=ct))})):y.step||(at=ot(it.h)),this.autoRotation=ut,this.labelRotation=pick$1x(lt,isNumber$N(et)?et:0),at},z.prototype.getSlotWidth=function(y){var a=this.chart,k=this.horiz,j=this.options.labels,et=Math.max(this.tickPositions.length-(this.categories?0:1),1),it=a.margin[3];if(y&&isNumber$N(y.slotWidth))return y.slotWidth;if(k&&j.step<2)return j.rotation?0:(this.staggerLines||1)*this.len/et;if(!k){var nt=j.style.width;if(nt!==void 0)return parseInt(String(nt),10);if(it)return it-a.spacing[3]}return a.chartWidth*.33},z.prototype.renderUnsquish=function(){var y=this.chart,a=y.renderer,k=this.tickPositions,j=this.ticks,et=this.options.labels,it=et.style,nt=this.horiz,ot=this.getSlotWidth(),at=Math.max(1,Math.round(ot-2*et.padding)),lt={},ct=this.labelMetrics(),ht=it.textOverflow,ut,ft,vt=0,gt,mt,bt;if(isString$8(et.rotation)||(lt.rotation=et.rotation||0),k.forEach(function(xt){var wt=j[xt];wt.movedLabel&&wt.replaceMovedLabel(),wt&&wt.label&&wt.label.textPxLength>vt&&(vt=wt.label.textPxLength)}),this.maxLabelLength=vt,this.autoRotation)vt>at&&vt>ct.h?lt.rotation=this.labelRotation:this.labelRotation=0;else if(ot&&(ut=at,!ht))for(ft="clip",mt=k.length;!nt&&mt--;)bt=k[mt],gt=j[bt].label,gt&&(gt.styles&&gt.styles.textOverflow==="ellipsis"?gt.css({textOverflow:"clip"}):gt.textPxLength>ot&&gt.css({width:ot+"px"}),gt.getBBox().height>this.len/k.length-(ct.h-ct.f)&&(gt.specificTextOverflow="ellipsis"));lt.rotation&&(ut=vt>y.chartHeight*.5?y.chartHeight*.33:vt,ht||(ft="ellipsis")),this.labelAlign=et.align||this.autoLabelAlign(this.labelRotation),this.labelAlign&&(lt.align=this.labelAlign),k.forEach(function(xt){var wt=j[xt],Mt=wt&&wt.label,Et=it.width,St={};Mt&&(Mt.attr(lt),wt.shortenLabel?wt.shortenLabel():ut&&!Et&&it.whiteSpace!=="nowrap"&&(ut<Mt.textPxLength||Mt.element.tagName==="SPAN")?(St.width=ut+"px",ht||(St.textOverflow=Mt.specificTextOverflow||ft),Mt.css(St)):Mt.styles&&Mt.styles.width&&!St.width&&!Et&&Mt.css({width:null}),delete Mt.specificTextOverflow,wt.rotation=lt.rotation)},this),this.tickRotCorr=a.rotCorr(ct.b,this.labelRotation||0,this.side!==0)},z.prototype.hasData=function(){return this.series.some(function(y){return y.hasData()})||this.options.showEmpty&&defined$R(this.min)&&defined$R(this.max)},z.prototype.addTitle=function(y){var a=this,k=a.chart.renderer,j=a.horiz,et=a.opposite,it=a.options,nt=it.title,ot=a.chart.styledMode,at;a.axisTitle||(at=nt.textAlign,at||(at=(j?{low:"left",middle:"center",high:"right"}:{low:et?"right":"left",middle:"center",high:et?"left":"right"})[nt.align]),a.axisTitle=k.text(nt.text||"",0,0,nt.useHTML).attr({zIndex:7,rotation:nt.rotation,align:at}).addClass("highcharts-axis-title"),ot||a.axisTitle.css(merge$1o(nt.style)),a.axisTitle.add(a.axisGroup),a.axisTitle.isNew=!0),!ot&&!nt.style.width&&!a.isRadial&&a.axisTitle.css({width:a.len+"px"}),a.axisTitle[y?"show":"hide"](y)},z.prototype.generateTick=function(y){var a=this,k=a.ticks;k[y]?k[y].addLabel():k[y]=new Tick(a,y)},z.prototype.getOffset=function(){var y=this,a=this,k=a.chart,j=k.renderer,et=a.options,it=a.tickPositions,nt=a.ticks,ot=a.horiz,at=a.side,lt=k.inverted&&!a.isZAxis?[1,0,3,2][at]:at,ct=a.hasData(),ht=et.title,ut=et.labels,ft=k.axisOffset,vt=k.clipOffset,gt=[-1,1,1,-1][at],mt=et.className,bt=a.axisParent,xt,wt=0,Mt,Et=0,St=0,kt,Pt;if(a.showAxis=xt=ct||et.showEmpty,a.staggerLines=a.horiz&&ut.staggerLines||void 0,!a.axisGroup){var It=function(Rt,Ft,Dt){return j.g(Rt).attr({zIndex:Dt}).addClass("highcharts-"+y.coll.toLowerCase()+Ft+" "+(y.isRadial?"highcharts-radial-axis"+Ft+" ":"")+(mt||"")).add(bt)};a.gridGroup=It("grid","-grid",et.gridZIndex),a.axisGroup=It("axis","",et.zIndex),a.labelGroup=It("axis-labels","-labels",ut.zIndex)}ct||a.isLinked?(it.forEach(function(Rt){a.generateTick(Rt)}),a.renderUnsquish(),a.reserveSpaceDefault=at===0||at===2||{1:"left",3:"right"}[at]===a.labelAlign,pick$1x(ut.reserveSpace,a.labelAlign==="center"?!0:null,a.reserveSpaceDefault)&&it.forEach(function(Rt){St=Math.max(nt[Rt].getLabelSize(),St)}),a.staggerLines&&(St*=a.staggerLines),a.labelOffset=St*(a.opposite?-1:1)):objectEach$u(nt,function(Rt,Ft){Rt.destroy(),delete nt[Ft]}),ht&&ht.text&&ht.enabled!==!1&&(a.addTitle(xt),xt&&ht.reserveSpace!==!1&&(a.titleOffset=wt=a.axisTitle.getBBox()[ot?"height":"width"],Mt=ht.offset,Et=defined$R(Mt)?0:pick$1x(ht.margin,ot?5:10))),a.renderLine(),a.offset=gt*pick$1x(et.offset,ft[at]?ft[at]+(et.margin||0):0),a.tickRotCorr=a.tickRotCorr||{x:0,y:0},at===0?Pt=-a.labelMetrics().h:at===2?Pt=a.tickRotCorr.y:Pt=0,kt=Math.abs(St)+Et,St&&(kt-=Pt,kt+=gt*(ot?pick$1x(ut.y,a.tickRotCorr.y+gt*8):ut.x)),a.axisTitleMargin=pick$1x(Mt,kt),a.getMaxLabelDimensions&&(a.maxLabelDimensions=a.getMaxLabelDimensions(nt,it));var Nt=this.tickSize("tick");ft[at]=Math.max(ft[at],(a.axisTitleMargin||0)+wt+gt*a.offset,kt,it&&it.length&&Nt?Nt[0]+gt*a.offset:0);var Ut=et.offset?0:Math.floor(a.axisLine.strokeWidth()/2)*2;vt[lt]=Math.max(vt[lt],Ut),fireEvent$z(this,"afterGetOffset")},z.prototype.getLinePath=function(y){var a=this.chart,k=this.opposite,j=this.offset,et=this.horiz,it=this.left+(k?this.width:0)+j,nt=a.chartHeight-this.bottom-(k?this.height:0)+j;return k&&(y*=-1),a.renderer.crispLine([["M",et?this.left:it,et?nt:this.top],["L",et?a.chartWidth-this.right:it,et?nt:a.chartHeight-this.bottom]],y)},z.prototype.renderLine=function(){this.axisLine||(this.axisLine=this.chart.renderer.path().addClass("highcharts-axis-line").add(this.axisGroup),this.chart.styledMode||this.axisLine.attr({stroke:this.options.lineColor,"stroke-width":this.options.lineWidth,zIndex:7}))},z.prototype.getTitlePosition=function(){var y=this.horiz,a=this.left,k=this.top,j=this.len,et=this.options.title,it=y?a:k,nt=this.opposite,ot=this.offset,at=et.x,lt=et.y,ct=this.axisTitle,ht=this.chart.renderer.fontMetrics(et.style.fontSize,ct),ut=Math.max(ct.getBBox(null,0).height-ht.h-1,0),ft={low:it+(y?0:j),middle:it+j/2,high:it+(y?j:0)}[et.align],vt=(y?k+this.height:a)+(y?1:-1)*(nt?-1:1)*this.axisTitleMargin+[-ut,ut,ht.f,-ut][this.side],gt={x:y?ft+at:vt+(nt?this.width:0)+ot+at,y:y?vt+lt-(nt?this.height:0)+ot:ft+lt};return fireEvent$z(this,"afterGetTitlePosition",{titlePosition:gt}),gt},z.prototype.renderMinorTick=function(y,a){var k=this,j=k.minorTicks;j[y]||(j[y]=new Tick(k,y,"minor")),a&&j[y].isNew&&j[y].render(null,!0),j[y].render(null,!1,1)},z.prototype.renderTick=function(y,a,k){var j=this,et=j.isLinked,it=j.ticks;(!et||y>=j.min&&y<=j.max||j.grid&&j.grid.isColumn)&&(it[y]||(it[y]=new Tick(j,y)),k&&it[y].isNew&&it[y].render(a,!0,-1),it[y].render(a))},z.prototype.render=function(){var y=this,a=y.chart,k=y.logarithmic,j=a.renderer,et=y.options,it=y.isLinked,nt=y.tickPositions,ot=y.axisTitle,at=y.ticks,lt=y.minorTicks,ct=y.alternateBands,ht=et.stackLabels,ut=et.alternateGridColor,ft=y.tickmarkOffset,vt=y.axisLine,gt=y.showAxis,mt=animObject$b(j.globalAnimation),bt,xt;if(y.labelEdge.length=0,y.overlap=!1,[at,lt,ct].forEach(function(Et){objectEach$u(Et,function(St){St.isActive=!1})}),y.hasData()||it){var wt=y.chart.hasRendered&&y.old&&isNumber$N(y.old.min);y.minorTickInterval&&!y.categories&&y.getMinorTickPositions().forEach(function(Et){y.renderMinorTick(Et,wt)}),nt.length&&(nt.forEach(function(Et,St){y.renderTick(Et,St,wt)}),ft&&(y.min===0||y.single)&&(at[-1]||(at[-1]=new Tick(y,-1,null,!0)),at[-1].render(-1))),ut&&nt.forEach(function(Et,St){xt=typeof nt[St+1]<"u"?nt[St+1]+ft:y.max-ft,St%2===0&&Et<y.max&&xt<=y.max+(a.polar?-ft:ft)&&(ct[Et]||(ct[Et]=new H.PlotLineOrBand(y)),bt=Et+ft,ct[Et].options={from:k?k.lin2log(bt):bt,to:k?k.lin2log(xt):xt,color:ut,className:"highcharts-alternate-grid"},ct[Et].render(),ct[Et].isActive=!0)}),y._addedPlotLB||(y._addedPlotLB=!0,(et.plotLines||[]).concat(et.plotBands||[]).forEach(function(Et){y.addPlotBandOrLine(Et)}))}if([at,lt,ct].forEach(function(Et){var St=[],kt=mt.duration,Pt=function(){for(var It=St.length;It--;)Et[St[It]]&&!Et[St[It]].isActive&&(Et[St[It]].destroy(),delete Et[St[It]])};objectEach$u(Et,function(It,Nt){It.isActive||(It.render(Nt,!1,0),It.isActive=!1,St.push(Nt))}),syncTimeout$7(Pt,Et===ct||!a.hasRendered||!kt?0:kt)}),vt&&(vt[vt.isPlaced?"animate":"attr"]({d:this.getLinePath(vt.strokeWidth())}),vt.isPlaced=!0,vt[gt?"show":"hide"](gt)),ot&&gt){var Mt=y.getTitlePosition();isNumber$N(Mt.y)?(ot[ot.isNew?"attr":"animate"](Mt),ot.isNew=!1):(ot.attr("y",-9999),ot.isNew=!0)}ht&&ht.enabled&&y.stacking&&y.stacking.renderStackTotals(),y.old={len:y.len,max:y.max,min:y.min,transA:y.transA,userMax:y.userMax,userMin:y.userMin},y.isDirty=!1,fireEvent$z(this,"afterRender")},z.prototype.redraw=function(){this.visible&&(this.render(),this.plotLinesAndBands.forEach(function(y){y.render()})),this.series.forEach(function(y){y.isDirty=!0})},z.prototype.getKeepProps=function(){return this.keepProps||z.keepProps},z.prototype.destroy=function(y){var a=this,k=a.plotLinesAndBands,j=this.eventOptions;if(fireEvent$z(this,"destroy",{keepEvents:y}),y||removeEvent$9(a),[a.ticks,a.minorTicks,a.alternateBands].forEach(function(nt){destroyObjectProperties$7(nt)}),k)for(var et=k.length;et--;)k[et].destroy();["axisLine","axisTitle","axisGroup","gridGroup","labelGroup","cross","scrollbar"].forEach(function(nt){a[nt]&&(a[nt]=a[nt].destroy())});for(var it in a.plotLinesAndBandsGroups)a.plotLinesAndBandsGroups[it]=a.plotLinesAndBandsGroups[it].destroy();objectEach$u(a,function(nt,ot){a.getKeepProps().indexOf(ot)===-1&&delete a[ot]}),this.eventOptions=j},z.prototype.drawCrosshair=function(y,a){var k=this.crosshair,j=pick$1x(k&&k.snap,!0),et=this.chart,it,nt,ot,at=this.cross,lt;if(fireEvent$z(this,"drawCrosshair",{e:y,point:a}),y||(y=this.cross&&this.cross.e),!k||(defined$R(a)||!j)===!1)this.hideCrosshair();else{if(j?defined$R(a)&&(nt=pick$1x(this.coll!=="colorAxis"?a.crosshairPos:null,this.isXAxis?a.plotX:this.len-a.plotY)):nt=y&&(this.horiz?y.chartX-this.pos:this.len-y.chartY+this.pos),defined$R(nt)&&(lt={value:a&&(this.isXAxis?a.x:pick$1x(a.stackY,a.y)),translatedValue:nt},et.polar&&extend$1q(lt,{isCrosshair:!0,chartX:y&&y.chartX,chartY:y&&y.chartY,point:a}),it=this.getPlotLinePath(lt)||null),!defined$R(it)){this.hideCrosshair();return}ot=this.categories&&!this.isRadial,at||(this.cross=at=et.renderer.path().addClass("highcharts-crosshair highcharts-crosshair-"+(ot?"category ":"thin ")+(k.className||"")).attr({zIndex:pick$1x(k.zIndex,2)}).add(),et.styledMode||(at.attr({stroke:k.color||(ot?Color.parse(palette.highlightColor20).setOpacity(.25).get():palette.neutralColor20),"stroke-width":pick$1x(k.width,1)}).css({"pointer-events":"none"}),k.dashStyle&&at.attr({dashstyle:k.dashStyle}))),at.show().attr({d:it}),ot&&!k.width&&at.attr({"stroke-width":this.transA}),this.cross.e=y}fireEvent$z(this,"afterDrawCrosshair",{e:y,point:a})},z.prototype.hideCrosshair=function(){this.cross&&this.cross.hide(),fireEvent$z(this,"afterHideCrosshair")},z.prototype.hasVerticalPanning=function(){var y=this.chart.options.chart.panning;return!!(y&&y.enabled&&/y/.test(y.type))},z.prototype.validatePositiveValue=function(y){return isNumber$N(y)&&y>0},z.prototype.update=function(y,a){var k=this.chart;y=merge$1o(this.userOptions,y),this.destroy(!0),this.init(k,y),k.isDirtyBox=!0,pick$1x(a,!0)&&k.redraw()},z.prototype.remove=function(y){for(var a=this.chart,k=this.coll,j=this.series,et=j.length;et--;)j[et]&&j[et].remove(!1);erase$8(a.axes,this),erase$8(a[k],this),a[k].forEach(function(it,nt){it.options.index=it.userOptions.index=nt}),this.destroy(),a.isDirtyBox=!0,pick$1x(y,!0)&&a.redraw()},z.prototype.setTitle=function(y,a){this.update({title:y},a)},z.prototype.setCategories=function(y,a){this.update({categories:y},a)},z.defaultOptions=AxisDefaults$1.defaultXAxisOptions,z.keepProps=["extKey","hcEvents","names","series","userMax","userMin"],z})(),addEvent$15=Utilities.addEvent,getMagnitude$1=Utilities.getMagnitude,normalizeTickInterval$1=Utilities.normalizeTickInterval,timeUnits$2=Utilities.timeUnits,DateTimeAxis;(function(z){var y=[];function a(it){if(y.indexOf(it)===-1){y.push(it),it.keepProps.push("dateTime");var nt=it.prototype;nt.getTimeTicks=k,addEvent$15(it,"init",j)}return it}z.compose=a;function k(){return this.chart.time.getTimeTicks.apply(this.chart.time,arguments)}function j(it){var nt=this,ot=it.userOptions;if(ot.type!=="datetime"){nt.dateTime=void 0;return}nt.dateTime||(nt.dateTime=new et(nt))}var et=(function(){function it(nt){this.axis=nt}return it.prototype.normalizeTimeTickInterval=function(nt,ot){var at=ot||[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2]],["week",[1,2]],["month",[1,2,3,4,6]],["year",null]],lt=at[at.length-1],ct=timeUnits$2[lt[0]],ht=lt[1],ut;for(ut=0;ut<at.length;ut++)if(lt=at[ut],ct=timeUnits$2[lt[0]],ht=lt[1],at[ut+1]){var ft=(ct*ht[ht.length-1]+timeUnits$2[at[ut+1][0]])/2;if(nt<=ft)break}ct===timeUnits$2.year&&nt<5*ct&&(ht=[1,2,5]);var vt=normalizeTickInterval$1(nt/ct,ht,lt[0]==="year"?Math.max(getMagnitude$1(nt/ct),1):1);return{unitRange:ct,count:vt,unitName:lt[0]}},it.prototype.getXDateFormat=function(nt,ot){var at=this.axis;return at.closestPointRange?at.chart.time.getDateFormat(at.closestPointRange,nt,at.options.startOfWeek,ot)||ot.year:ot.day},it})();z.Additions=et})(DateTimeAxis||(DateTimeAxis={}));const DateTimeAxis$1=DateTimeAxis;var addEvent$14=Utilities.addEvent,getMagnitude=Utilities.getMagnitude,normalizeTickInterval=Utilities.normalizeTickInterval,pick$1w=Utilities.pick,LogarithmicAxis;(function(z){var y=[];function a(it){return y.indexOf(it)===-1&&(y.push(it),it.keepProps.push("logarithmic"),addEvent$14(it,"init",k),addEvent$14(it,"afterInit",j)),it}z.compose=a;function k(it){var nt=this,ot=it.userOptions,at=nt.logarithmic;ot.type!=="logarithmic"?nt.logarithmic=void 0:at||(at=nt.logarithmic=new et(nt))}function j(){var it=this,nt=it.logarithmic;nt&&(it.lin2val=function(ot){return nt.lin2log(ot)},it.val2lin=function(ot){return nt.log2lin(ot)})}var et=(function(){function it(nt){this.axis=nt}return it.prototype.getLogTickPositions=function(nt,ot,at,lt){var ct=this,ht=ct.axis,ut=ht.len,ft=ht.options,vt=[];if(lt||(ct.minorAutoInterval=void 0),nt>=.5)nt=Math.round(nt),vt=ht.getLinearTickPositions(nt,ot,at);else if(nt>=.08){var gt=Math.floor(ot),mt=void 0,bt=void 0,xt=void 0,wt=void 0,Mt=void 0,Et=void 0,St=void 0;for(nt>.3?mt=[1,2,4]:nt>.15?mt=[1,2,4,6,8]:mt=[1,2,3,4,5,6,7,8,9],bt=gt;bt<at+1&&!St;bt++)for(wt=mt.length,xt=0;xt<wt&&!St;xt++)Mt=ct.log2lin(ct.lin2log(bt)*mt[xt]),Mt>ot&&(!lt||Et<=at)&&typeof Et<"u"&&vt.push(Et),Et>at&&(St=!0),Et=Mt}else{var kt=ct.lin2log(ot),Pt=ct.lin2log(at),It=lt?ht.getMinorTickInterval():ft.tickInterval,Nt=It==="auto"?null:It,Ut=ft.tickPixelInterval/(lt?5:1),Rt=lt?ut/ht.tickPositions.length:ut;nt=pick$1w(Nt,ct.minorAutoInterval,(Pt-kt)*Ut/(Rt||1)),nt=normalizeTickInterval(nt,void 0,getMagnitude(nt)),vt=ht.getLinearTickPositions(nt,kt,Pt).map(ct.log2lin),lt||(ct.minorAutoInterval=nt/5)}return lt||(ht.tickInterval=nt),vt},it.prototype.lin2log=function(nt){return Math.pow(10,nt)},it.prototype.log2lin=function(nt){return Math.log(nt)/Math.LN10},it})();z.Additions=et})(LogarithmicAxis||(LogarithmicAxis={}));const LogarithmicAxis$1=LogarithmicAxis;var erase$7=Utilities.erase,extend$1p=Utilities.extend,isNumber$M=Utilities.isNumber,PlotLineOrBandAxis;(function(z){var y=[],a;function k(et,it){return a||(a=et),y.indexOf(it)===-1&&(y.push(it),extend$1p(it.prototype,j.prototype)),it}z.compose=k;var j=(function(){function et(){}return et.prototype.getPlotBandPath=function(it,nt,ot){ot===void 0&&(ot=this.options);var at=this.getPlotLinePath({value:nt,force:!0,acrossPanes:ot.acrossPanes}),lt=[],ct=this.horiz,ht=!isNumber$M(this.min)||!isNumber$M(this.max)||it<this.min&&nt<this.min||it>this.max&&nt>this.max,ut=this.getPlotLinePath({value:it,force:!0,acrossPanes:ot.acrossPanes}),ft,vt=1,gt;if(ut&&at)for(ht&&(gt=ut.toString()===at.toString(),vt=0),ft=0;ft<ut.length;ft+=2){var mt=ut[ft],bt=ut[ft+1],xt=at[ft],wt=at[ft+1];(mt[0]==="M"||mt[0]==="L")&&(bt[0]==="M"||bt[0]==="L")&&(xt[0]==="M"||xt[0]==="L")&&(wt[0]==="M"||wt[0]==="L")&&(ct&&xt[1]===mt[1]?(xt[1]+=vt,wt[1]+=vt):!ct&&xt[2]===mt[2]&&(xt[2]+=vt,wt[2]+=vt),lt.push(["M",mt[1],mt[2]],["L",bt[1],bt[2]],["L",wt[1],wt[2]],["L",xt[1],xt[2]],["Z"])),lt.isFlat=gt}else ut=null;return lt},et.prototype.addPlotBand=function(it){return this.addPlotBandOrLine(it,"plotBands")},et.prototype.addPlotLine=function(it){return this.addPlotBandOrLine(it,"plotLines")},et.prototype.addPlotBandOrLine=function(it,nt){var ot=this,at=this.userOptions,lt=new a(this,it);if(this.visible&&(lt=lt.render()),lt){if(this._addedPlotLB||(this._addedPlotLB=!0,(at.plotLines||[]).concat(at.plotBands||[]).forEach(function(ht){ot.addPlotBandOrLine(ht)})),nt){var ct=at[nt]||[];ct.push(it),at[nt]=ct}this.plotLinesAndBands.push(lt)}return lt},et.prototype.removePlotBandOrLine=function(it){var nt=this.plotLinesAndBands,ot=this.options,at=this.userOptions;if(nt){for(var lt=nt.length;lt--;)nt[lt].id===it&&nt[lt].destroy();[ot.plotLines||[],at.plotLines||[],ot.plotBands||[],at.plotBands||[]].forEach(function(ct){for(lt=ct.length;lt--;)(ct[lt]||{}).id===it&&erase$7(ct,ct[lt])})}},et.prototype.removePlotBand=function(it){this.removePlotBandOrLine(it)},et.prototype.removePlotLine=function(it){this.removePlotBandOrLine(it)},et})()})(PlotLineOrBandAxis||(PlotLineOrBandAxis={}));const PlotLineOrBandAxis$1=PlotLineOrBandAxis;var arrayMax$8=Utilities.arrayMax,arrayMin$7=Utilities.arrayMin,defined$Q=Utilities.defined,destroyObjectProperties$6=Utilities.destroyObjectProperties,erase$6=Utilities.erase,fireEvent$y=Utilities.fireEvent,merge$1n=Utilities.merge,objectEach$t=Utilities.objectEach,pick$1v=Utilities.pick,PlotLineOrBand=(function(){function z(y,a){this.axis=y,a&&(this.options=a,this.id=a.id)}return z.compose=function(y){return PlotLineOrBandAxis$1.compose(z,y)},z.prototype.render=function(){fireEvent$y(this,"render");var y=this,a=y.axis,k=a.horiz,j=a.logarithmic,et=y.options,it=et.color,nt=pick$1v(et.zIndex,0),ot=et.events,at={},lt=a.chart.renderer,ct=et.label,ht=y.label,ut=et.to,ft=et.from,vt=et.value,gt=y.svgElem,mt=[],bt,xt=defined$Q(ft)&&defined$Q(ut),wt=defined$Q(vt),Mt=!gt,Et={class:"highcharts-plot-"+(xt?"band ":"line ")+(et.className||"")},St=xt?"bands":"lines";if(j&&(ft=j.log2lin(ft),ut=j.log2lin(ut),vt=j.log2lin(vt)),a.chart.styledMode||(wt?(Et.stroke=it||palette.neutralColor40,Et["stroke-width"]=pick$1v(et.width,1),et.dashStyle&&(Et.dashstyle=et.dashStyle)):xt&&(Et.fill=it||palette.highlightColor10,et.borderWidth&&(Et.stroke=et.borderColor,Et["stroke-width"]=et.borderWidth))),at.zIndex=nt,St+="-"+nt,bt=a.plotLinesAndBandsGroups[St],bt||(a.plotLinesAndBandsGroups[St]=bt=lt.g("plot-"+St).attr(at).add()),Mt&&(y.svgElem=gt=lt.path().attr(Et).add(bt)),wt)mt=a.getPlotLinePath({value:vt,lineWidth:gt.strokeWidth(),acrossPanes:et.acrossPanes});else if(xt)mt=a.getPlotBandPath(ft,ut,et);else return;return!y.eventsAdded&&ot&&(objectEach$t(ot,function(kt,Pt){gt.on(Pt,function(It){ot[Pt].apply(y,[It])})}),y.eventsAdded=!0),(Mt||!gt.d)&&mt&&mt.length?gt.attr({d:mt}):gt&&(mt?(gt.show(!0),gt.animate({d:mt})):gt.d&&(gt.hide(),ht&&(y.label=ht=ht.destroy()))),ct&&(defined$Q(ct.text)||defined$Q(ct.formatter))&&mt&&mt.length&&a.width>0&&a.height>0&&!mt.isFlat?(ct=merge$1n({align:k&&xt&&"center",x:k?!xt&&4:10,verticalAlign:!k&&xt&&"middle",y:k?xt?16:10:xt?6:-4,rotation:k&&!xt&&90},ct),this.renderLabel(ct,mt,xt,nt)):ht&&ht.hide(),y},z.prototype.renderLabel=function(y,a,k,j){var et=this,it=et.axis,nt=it.chart.renderer,ot=et.label;ot||(et.label=ot=nt.text(this.getLabelText(y),0,0,y.useHTML).attr({align:y.textAlign||y.align,rotation:y.rotation,class:"highcharts-plot-"+(k?"band":"line")+"-label "+(y.className||""),zIndex:j}).add(),it.chart.styledMode||ot.css(merge$1n({textOverflow:"ellipsis"},y.style)));var at=a.xBounds||[a[0][1],a[1][1],k?a[2][1]:a[0][1]],lt=a.yBounds||[a[0][2],a[1][2],k?a[2][2]:a[0][2]],ct=arrayMin$7(at),ht=arrayMin$7(lt);ot.align(y,!1,{x:ct,y:ht,width:arrayMax$8(at)-ct,height:arrayMax$8(lt)-ht}),(!ot.alignValue||ot.alignValue==="left")&&ot.css({width:(ot.rotation===90?it.height-(ot.alignAttr.y-it.top):it.width-(ot.alignAttr.x-it.left))+"px"}),ot.show(!0)},z.prototype.getLabelText=function(y){return defined$Q(y.formatter)?y.formatter.call(this):y.text},z.prototype.destroy=function(){erase$6(this.axis.plotLinesAndBands,this),delete this.axis,destroyObjectProperties$6(this)},z})(),format$d=FormatUtilities.format,doc$i=H.doc,distribute$3=R.distribute,addEvent$13=Utilities.addEvent,clamp$h=Utilities.clamp,css$9=Utilities.css,defined$P=Utilities.defined,discardElement$5=Utilities.discardElement,extend$1o=Utilities.extend,fireEvent$x=Utilities.fireEvent,isArray$l=Utilities.isArray,isNumber$L=Utilities.isNumber,isString$7=Utilities.isString,merge$1m=Utilities.merge,pick$1u=Utilities.pick,splat$h=Utilities.splat,syncTimeout$6=Utilities.syncTimeout,Tooltip=(function(){function z(y,a){this.container=void 0,this.crosshairs=[],this.distance=0,this.isHidden=!0,this.isSticky=!1,this.now={},this.options={},this.outside=!1,this.chart=y,this.init(y,a)}return z.prototype.applyFilter=function(){var y=this.chart;y.renderer.definition({tagName:"filter",attributes:{id:"drop-shadow-"+y.index,opacity:.5},children:[{tagName:"feGaussianBlur",attributes:{in:"SourceAlpha",stdDeviation:1}},{tagName:"feOffset",attributes:{dx:1,dy:1}},{tagName:"feComponentTransfer",children:[{tagName:"feFuncA",attributes:{type:"linear",slope:.3}}]},{tagName:"feMerge",children:[{tagName:"feMergeNode"},{tagName:"feMergeNode",attributes:{in:"SourceGraphic"}}]}]})},z.prototype.bodyFormatter=function(y){return y.map(function(a){var k=a.series.tooltipOptions;return(k[(a.point.formatPrefix||"point")+"Formatter"]||a.point.tooltipFormatter).call(a.point,k[(a.point.formatPrefix||"point")+"Format"]||"")})},z.prototype.cleanSplit=function(y){this.chart.series.forEach(function(a){var k=a&&a.tt;k&&(!k.isActive||y?a.tt=k.destroy():k.isActive=!1)})},z.prototype.defaultFormatter=function(y){var a=this.points||splat$h(this),k;return k=[y.tooltipFooterHeaderFormatter(a[0])],k=k.concat(y.bodyFormatter(a)),k.push(y.tooltipFooterHeaderFormatter(a[0],!0)),k},z.prototype.destroy=function(){this.label&&(this.label=this.label.destroy()),this.split&&this.tt&&(this.cleanSplit(this.chart,!0),this.tt=this.tt.destroy()),this.renderer&&(this.renderer=this.renderer.destroy(),discardElement$5(this.container)),Utilities.clearTimeout(this.hideTimer),Utilities.clearTimeout(this.tooltipTimeout)},z.prototype.getAnchor=function(y,a){var k=this.chart,j=k.pointer,et=k.inverted,it=k.plotTop,nt=k.plotLeft,ot,at,lt,ct=0,ht=0;return y=splat$h(y),this.followPointer&&a?(typeof a.chartX>"u"&&(a=j.normalize(a)),ot=[a.chartX-nt,a.chartY-it]):y[0].tooltipPos?ot=y[0].tooltipPos:(y.forEach(function(ut){at=ut.series.yAxis,lt=ut.series.xAxis,ct+=ut.plotX||0,ht+=ut.plotLow?(ut.plotLow+(ut.plotHigh||0))/2:ut.plotY||0,lt&&at&&(et?(ct+=it+k.plotHeight-lt.len-lt.pos,ht+=nt+k.plotWidth-at.len-at.pos):(ct+=lt.pos-nt,ht+=at.pos-it))}),ct/=y.length,ht/=y.length,ot=[et?k.plotWidth-ht:ct,et?k.plotHeight-ct:ht],this.shared&&y.length>1&&a&&(et?ot[0]=a.chartX-nt:ot[1]=a.chartY-it)),ot.map(Math.round)},z.prototype.getLabel=function(){var y=this,a=this.chart.styledMode,k=this.options,j="tooltip"+(defined$P(k.className)?" "+k.className:""),et=k.style.pointerEvents||(!this.followPointer&&k.stickOnContact?"auto":"none"),it=function(){y.inContact=!0},nt=function(vt){var gt=y.chart.hoverSeries;y.inContact=y.shouldStickOnContact()&&y.chart.pointer.inClass(vt.relatedTarget,"highcharts-tooltip"),!y.inContact&&gt&&gt.onMouseOut&&gt.onMouseOut()},ot,at=this.chart.renderer;if(!this.label){if(this.outside){var lt=this.chart.options.chart.style,ct=RendererRegistry$1.getRendererType();this.container=ot=H.doc.createElement("div"),ot.className="highcharts-tooltip-container",css$9(ot,{position:"absolute",top:"1px",pointerEvents:et,zIndex:Math.max(this.options.style.zIndex||0,(lt&&lt.zIndex||0)+3)}),addEvent$13(ot,"mouseenter",it),addEvent$13(ot,"mouseleave",nt),H.doc.body.appendChild(ot),this.renderer=at=new ct(ot,0,0,lt,void 0,void 0,at.styledMode)}if(this.split?this.label=at.g(j):(this.label=at.label("",0,0,k.shape,void 0,void 0,k.useHTML,void 0,j).attr({padding:k.padding,r:k.borderRadius}),a||this.label.attr({fill:k.backgroundColor,"stroke-width":k.borderWidth}).css(k.style).css({pointerEvents:et}).shadow(k.shadow)),a&&k.shadow&&(this.applyFilter(),this.label.attr({filter:"url(#drop-shadow-"+this.chart.index+")"})),y.outside&&!y.split){var ht=this.label,ut=ht.xSetter,ft=ht.ySetter;ht.xSetter=function(vt){ut.call(ht,y.distance),ot.style.left=vt+"px"},ht.ySetter=function(vt){ft.call(ht,y.distance),ot.style.top=vt+"px"}}this.label.on("mouseenter",it).on("mouseleave",nt).attr({zIndex:8}).add()}return this.label},z.prototype.getPosition=function(y,a,k){var j=this.chart,et=this.distance,it={},nt=j.inverted&&k.h||0,ot=this.outside,at=ot?doc$i.documentElement.clientWidth-2*et:j.chartWidth,lt=ot?Math.max(doc$i.body.scrollHeight,doc$i.documentElement.scrollHeight,doc$i.body.offsetHeight,doc$i.documentElement.offsetHeight,doc$i.documentElement.clientHeight):j.chartHeight,ct=j.pointer.getChartPosition(),ht=function(St){return St*ct.scaleX},ut=function(St){return St*ct.scaleY},ft=function(St){var kt=St==="x";return[St,kt?at:lt,kt?y:a].concat(ot?[kt?ht(y):ut(a),kt?ct.left-et+ht(k.plotX+j.plotLeft):ct.top-et+ut(k.plotY+j.plotTop),0,kt?at:lt]:[kt?y:a,kt?k.plotX+j.plotLeft:k.plotY+j.plotTop,kt?j.plotLeft:j.plotTop,kt?j.plotLeft+j.plotWidth:j.plotTop+j.plotHeight])},vt=ft("y"),gt=ft("x"),mt,bt=!this.followPointer&&pick$1u(k.ttBelow,!j.inverted==!!k.negative),xt=function(St,kt,Pt,It,Nt,Ut,Rt){var Ft=ot?St==="y"?ut(et):ht(et):et,Dt=(Pt-It)/2,Ht=It<Nt-et,Gt=Nt+et+It<kt,Yt=Nt-Ft-Pt+Dt,te=Nt+Ft-Dt;if(bt&&Gt)it[St]=te;else if(!bt&&Ht)it[St]=Yt;else if(Ht)it[St]=Math.min(Rt-It,Yt-nt<0?Yt:Yt-nt);else if(Gt)it[St]=Math.max(Ut,te+nt+Pt>kt?te:te+nt);else return!1},wt=function(St,kt,Pt,It,Nt){var Ut;return Nt<et||Nt>kt-et?Ut=!1:Nt<Pt/2?it[St]=1:Nt>kt-It/2?it[St]=kt-It-2:it[St]=Nt-Pt/2,Ut},Mt=function(St){var kt=vt;vt=gt,gt=kt,mt=St},Et=function(){xt.apply(0,vt)!==!1?wt.apply(0,gt)===!1&&!mt&&(Mt(!0),Et()):mt?it.x=it.y=0:(Mt(!0),Et())};return(j.inverted||this.len>1)&&Mt(),Et(),it},z.prototype.hide=function(y){var a=this;Utilities.clearTimeout(this.hideTimer),y=pick$1u(y,this.options.hideDelay),this.isHidden||(this.hideTimer=syncTimeout$6(function(){a.getLabel().fadeOut(y&&void 0),a.isHidden=!0},y))},z.prototype.init=function(y,a){this.chart=y,this.options=a,this.crosshairs=[],this.now={x:0,y:0},this.isHidden=!0,this.split=a.split&&!y.inverted&&!y.polar,this.shared=a.shared||this.split,this.outside=pick$1u(a.outside,!!(y.scrollablePixelsX||y.scrollablePixelsY))},z.prototype.shouldStickOnContact=function(){return!!(!this.followPointer&&this.options.stickOnContact)},z.prototype.isStickyOnContact=function(){return!!(this.shouldStickOnContact()&&this.inContact)},z.prototype.move=function(y,a,k,j){var et=this,it=et.now,nt=et.options.animation!==!1&&!et.isHidden&&(Math.abs(y-it.x)>1||Math.abs(a-it.y)>1),ot=et.followPointer||et.len>1;extend$1o(it,{x:nt?(2*it.x+y)/3:y,y:nt?(it.y+a)/2:a,anchorX:ot?void 0:nt?(2*it.anchorX+k)/3:k,anchorY:ot?void 0:nt?(it.anchorY+j)/2:j}),et.getLabel().attr(it),et.drawTracker(),nt&&(Utilities.clearTimeout(this.tooltipTimeout),this.tooltipTimeout=setTimeout(function(){et&&et.move(y,a,k,j)},32))},z.prototype.refresh=function(y,a){var k=this,j=this.chart,et=k.options,it=splat$h(y),nt=it[0],ot=[],at=et.formatter||k.defaultFormatter,lt=k.shared,ct=j.styledMode,ht={};if(et.enabled){Utilities.clearTimeout(this.hideTimer),k.followPointer=!k.split&&nt.series.tooltipOptions.followPointer;var ut=k.getAnchor(y,a),ft=ut[0],vt=ut[1];lt&&!(!isArray$l(y)&&y.series&&y.series.noSharedTooltip)?(j.pointer.applyInactiveState(it),it.forEach(function(Mt){Mt.setState("hover"),ot.push(Mt.getLabelConfig())}),ht={x:nt.category,y:nt.y},ht.points=ot):ht=nt.getLabelConfig(),this.len=ot.length;var gt=at.call(ht,k),mt=nt.series;if(this.distance=pick$1u(mt.tooltipOptions.distance,16),gt===!1)this.hide();else{if(k.split)this.renderSplit(gt,it);else{var bt=ft,xt=vt;if(a&&j.pointer.isDirectTouch&&(bt=a.chartX-j.plotLeft,xt=a.chartY-j.plotTop),j.polar||mt.options.clip===!1||mt.shouldShowTooltip(bt,xt)){var wt=k.getLabel();(!et.style.width||ct)&&wt.css({width:this.chart.spacingBox.width+"px"}),wt.attr({text:gt&&gt.join?gt.join(""):gt}),wt.removeClass(/highcharts-color-[\d]+/g).addClass("highcharts-color-"+pick$1u(nt.colorIndex,mt.colorIndex)),ct||wt.attr({stroke:et.borderColor||nt.color||mt.color||palette.neutralColor60}),k.updatePosition({plotX:ft,plotY:vt,negative:nt.negative,ttBelow:nt.ttBelow,h:ut[2]||0})}else{k.hide();return}}k.isHidden&&k.label&&k.label.attr({opacity:1}).show(),k.isHidden=!1}fireEvent$x(this,"refresh")}},z.prototype.renderSplit=function(y,a){var k=this,j=k.chart,et=k.chart,it=et.chartWidth;et.chartHeight;var nt=et.plotHeight,ot=et.plotLeft,at=et.plotTop,lt=et.pointer,ct=et.scrollablePixelsY,ht=ct===void 0?0:ct,ut=et.scrollablePixelsX,ft=et.scrollingContainer,vt=ft===void 0?{scrollLeft:0,scrollTop:0}:ft,gt=vt.scrollLeft,mt=vt.scrollTop,bt=et.styledMode,xt=k.distance,wt=k.options,Mt=k.options.positioner,Et=k.outside&&typeof ut!="number"?doc$i.documentElement.getBoundingClientRect():{left:gt,right:gt+it},St=k.getLabel(),kt=this.renderer||j.renderer,Pt=!!(j.xAxis[0]&&j.xAxis[0].opposite),It=lt.getChartPosition(),Nt=It.left,Ut=It.top,Rt=at+mt,Ft=0,Dt=nt-ht;function Ht(Se){var Le=Se.isHeader,Ne=Se.plotX,Je=Ne===void 0?0:Ne,Ue=Se.plotY,Ve=Ue===void 0?0:Ue,Ye=Se.series,li,Li;if(Le)li=ot+Je,Li=at+nt/2;else{var Pi=Ye.xAxis,_i=Ye.yAxis;li=Pi.pos+clamp$h(Je,-xt,Pi.len+xt),Ye.shouldShowTooltip(0,_i.pos-at+Ve,{ignoreX:!0})&&(Li=_i.pos+Ve)}return li=clamp$h(li,Et.left-xt,Et.right+xt),{anchorX:li,anchorY:Li}}function Gt(Se,Le,Ne,Je,Ue){Ue===void 0&&(Ue=!0);var Ve,Ye;return Ne?(Ve=Pt?0:Dt,Ye=clamp$h(Se-Je/2,Et.left,Et.right-Je-(k.outside?Nt:0))):(Ve=Le-Rt,Ye=Ue?Se-Je-xt:Se+xt,Ye=clamp$h(Ye,Ue?Ye:Et.left,Et.right)),{x:Ye,y:Ve}}function Yt(Se,Le,Ne){var Je=Se,Ue=Le.isHeader,Ve=Le.series,Ye="highcharts-color-"+pick$1u(Le.colorIndex,Ve.colorIndex,"none");if(!Je){var li={padding:wt.padding,r:wt.borderRadius};bt||(li.fill=wt.backgroundColor,li["stroke-width"]=wt.borderWidth),Je=kt.label("",0,0,wt[Ue?"headerShape":"shape"],void 0,void 0,wt.useHTML).addClass((Ue?"highcharts-tooltip-header ":"")+"highcharts-tooltip-box "+Ye).attr(li).add(St)}return Je.isActive=!0,Je.attr({text:Ne}),bt||Je.css(wt.style).shadow(wt.shadow).attr({stroke:wt.borderColor||Le.color||Ve.color||palette.neutralColor80}),Je}isString$7(y)&&(y=[!1,y]);var te=y.slice(0,a.length+1).reduce(function(Se,Le,Ne){if(Le!==!1&&Le!==""){var Je=a[Ne-1]||{isHeader:!0,plotX:a[0].plotX,plotY:nt,series:{}},Ue=Je.isHeader,Ve=Ue?k:Je.series,Ye=Ve.tt=Yt(Ve.tt,Je,Le.toString()),li=Ye.getBBox(),Li=li.width+Ye.strokeWidth();Ue&&(Ft=li.height,Dt+=Ft,Pt&&(Rt-=Ft));var Pi=Ht(Je),_i=Pi.anchorX,$i=Pi.anchorY;if(typeof $i=="number"){var Hi=li.height+1,Ae=Mt?Mt.call(k,Li,Hi,Je):Gt(_i,$i,Ue,Li);Se.push({align:Mt?0:void 0,anchorX:_i,anchorY:$i,boxWidth:Li,point:Je,rank:pick$1u(Ae.rank,Ue?1:0),size:Hi,target:Ae.y,tt:Ye,x:Ae.x})}else Ye.isActive=!1}return Se},[]);!Mt&&te.some(function(Se){var Le=k.outside,Ne=(Le?Nt:0)+Se.anchorX;return Ne<Et.left&&Ne+Se.boxWidth<Et.right?!0:Ne<Nt-Et.left+Se.boxWidth&&Et.right-Ne>Ne})&&(te=te.map(function(Se){var Le=Gt(Se.anchorX,Se.anchorY,Se.point.isHeader,Se.boxWidth,!1),Ne=Le.x,Je=Le.y;return extend$1o(Se,{target:Je,x:Ne})})),k.cleanSplit(),distribute$3(te,Dt);var he={left:Nt,right:Nt};te.forEach(function(Se){var Le=Se.x,Ne=Se.boxWidth,Je=Se.isHeader;Je||(k.outside&&Nt+Le<he.left&&(he.left=Nt+Le),!Je&&k.outside&&he.left+Ne>he.right&&(he.right=Nt+Le))}),te.forEach(function(Se){var Le=Se.x,Ne=Se.anchorX,Je=Se.anchorY,Ue=Se.pos,Ve=Se.point.isHeader,Ye={visibility:typeof Ue>"u"?"hidden":"inherit",x:Le,y:Ue+Rt,anchorX:Ne,anchorY:Je};if(k.outside&&Le<Ne){var li=Nt-he.left;li>0&&(Ve||(Ye.x=Le+li,Ye.anchorX=Ne+li),Ve&&(Ye.x=(he.right-he.left)/2,Ye.anchorX=Ne+li))}Se.tt.attr(Ye)});var ee=k.container,Xt=k.outside,oe=k.renderer;if(Xt&&ee&&oe){var le=St.getBBox(),ie=le.width,_e=le.height,Re=le.x,Ee=le.y;oe.setSize(ie+Re,_e+Ee,!1),ee.style.left=he.left+"px",ee.style.top=Ut+"px"}},z.prototype.drawTracker=function(){var y=this;if(y.followPointer||!y.options.stickOnContact){y.tracker&&y.tracker.destroy();return}var a=y.chart,k=y.label,j=y.shared?a.hoverPoints:a.hoverPoint;if(!(!k||!j)){var et={x:0,y:0,width:0,height:0},it=this.getAnchor(j),nt=k.getBBox();it[0]+=a.plotLeft-k.translateX,it[1]+=a.plotTop-k.translateY,et.x=Math.min(0,it[0]),et.y=Math.min(0,it[1]),et.width=it[0]<0?Math.max(Math.abs(it[0]),nt.width-it[0]):Math.max(Math.abs(it[0]),nt.width),et.height=it[1]<0?Math.max(Math.abs(it[1]),nt.height-Math.abs(it[1])):Math.max(Math.abs(it[1]),nt.height),y.tracker?y.tracker.attr(et):(y.tracker=k.renderer.rect(et).addClass("highcharts-tracker").add(k),a.styledMode||y.tracker.attr({fill:"rgba(0,0,0,0)"}))}},z.prototype.styledModeFormat=function(y){return y.replace('style="font-size: 10px"','class="highcharts-header"').replace(/style="color:{(point|series)\.color}"/g,'class="highcharts-color-{$1.colorIndex}"')},z.prototype.tooltipFooterHeaderFormatter=function(y,a){var k=y.series,j=k.tooltipOptions,et=k.xAxis,it=et&&et.dateTime,nt={isFooter:a,labelConfig:y},ot=j.xDateFormat,at=j[a?"footerFormat":"headerFormat"];return fireEvent$x(this,"headerFormatter",nt,function(lt){it&&!ot&&isNumber$L(y.key)&&(ot=it.getXDateFormat(y.key,j.dateTimeLabelFormats)),it&&ot&&(y.point&&y.point.tooltipDateKeys||["key"]).forEach(function(ct){at=at.replace("{point."+ct+"}","{point."+ct+":"+ot+"}")}),k.chart.styledMode&&(at=this.styledModeFormat(at)),lt.text=format$d(at,{point:y,series:k},this.chart)}),nt.text},z.prototype.update=function(y){this.destroy(),merge$1m(!0,this.chart.options.tooltip.userOptions,y),this.init(this.chart,merge$1m(!0,this.options,y))},z.prototype.updatePosition=function(y){var a=this.chart,k=this.options,j=a.pointer,et=this.getLabel(),it=j.getChartPosition(),nt=(k.positioner||this.getPosition).call(this,et.width,et.height,y),ot=y.plotX+a.plotLeft,at=y.plotY+a.plotTop,lt;this.outside&&(lt=k.borderWidth+2*this.distance,this.renderer.setSize(et.width+lt,et.height+lt,!1),(it.scaleX!==1||it.scaleY!==1)&&(css$9(this.container,{transform:"scale("+it.scaleX+", "+it.scaleY+")"}),ot*=it.scaleX,at*=it.scaleY),ot+=it.left-nt.x,at+=it.top-nt.y),this.move(Math.round(nt.x),Math.round(nt.y||0),ot,at)},z})(),animObject$a=animationExports.animObject,defaultOptions$g=DefaultOptions.defaultOptions,format$c=FormatUtilities.format,addEvent$12=Utilities.addEvent,defined$O=Utilities.defined,erase$5=Utilities.erase,extend$1n=Utilities.extend,fireEvent$w=Utilities.fireEvent,getNestedProperty$1=Utilities.getNestedProperty,isArray$k=Utilities.isArray,isFunction$2=Utilities.isFunction,isNumber$K=Utilities.isNumber,isObject$e=Utilities.isObject,merge$1l=Utilities.merge,objectEach$s=Utilities.objectEach,pick$1t=Utilities.pick,syncTimeout$5=Utilities.syncTimeout,removeEvent$8=Utilities.removeEvent,uniqueKey$5=Utilities.uniqueKey,Point$4=(function(){function z(){this.category=void 0,this.colorIndex=void 0,this.formatPrefix="point",this.id=void 0,this.isNull=!1,this.name=void 0,this.options=void 0,this.percentage=void 0,this.selected=!1,this.series=void 0,this.total=void 0,this.visible=!0,this.x=void 0}return z.prototype.animateBeforeDestroy=function(){var y=this,a={x:y.startXPos,opacity:0},k=y.getGraphicalProps();k.singular.forEach(function(j){var et=j==="dataLabel";y[j]=y[j].animate(et?{x:y[j].startXPos,y:y[j].startYPos,opacity:0}:a)}),k.plural.forEach(function(j){y[j].forEach(function(et){et.element&&et.animate(extend$1n({x:y.startXPos},et.startYPos?{x:et.startXPos,y:et.startYPos}:{}))})})},z.prototype.applyOptions=function(y,a){var k=this,j=k.series,et=j.options.pointValKey||j.pointValKey;return y=z.prototype.optionsToObject.call(this,y),extend$1n(k,y),k.options=k.options?extend$1n(k.options,y):y,y.group&&delete k.group,y.dataLabels&&delete k.dataLabels,et&&(k.y=z.prototype.getNestedProperty.call(k,et)),k.isNull=pick$1t(k.isValid&&!k.isValid(),k.x===null||!isNumber$K(k.y)),k.formatPrefix=k.isNull?"null":"point",k.selected&&(k.state="select"),"name"in k&&typeof a>"u"&&j.xAxis&&j.xAxis.hasNames&&(k.x=j.xAxis.nameToX(k)),typeof k.x>"u"&&j?typeof a>"u"?k.x=j.autoIncrement():k.x=a:isNumber$K(y.x)&&j.options.relativeXValue&&(k.x=j.autoIncrement(y.x)),k},z.prototype.destroy=function(){var y=this,a=y.series,k=a.chart,j=a.options.dataSorting,et=k.hoverPoints,it=y.series.chart.renderer.globalAnimation,nt=animObject$a(it),ot;function at(){(y.graphic||y.dataLabel||y.dataLabels)&&(removeEvent$8(y),y.destroyElements());for(ot in y)y[ot]=null}y.legendItem&&k.legend.destroyItem(y),et&&(y.setState(),erase$5(et,y),et.length||(k.hoverPoints=null)),y===k.hoverPoint&&y.onMouseOut(),!j||!j.enabled?at():(this.animateBeforeDestroy(),syncTimeout$5(at,nt.duration)),k.pointCount--},z.prototype.destroyElements=function(y){var a=this,k=a.getGraphicalProps(y);k.singular.forEach(function(j){a[j]=a[j].destroy()}),k.plural.forEach(function(j){a[j].forEach(function(et){et.element&&et.destroy()}),delete a[j]})},z.prototype.firePointEvent=function(y,a,k){var j=this,et=this.series,it=et.options;(it.point.events[y]||j.options&&j.options.events&&j.options.events[y])&&j.importEvents(),y==="click"&&it.allowPointSelect&&(k=function(nt){j.select&&j.select(null,nt.ctrlKey||nt.metaKey||nt.shiftKey)}),fireEvent$w(j,y,a,k)},z.prototype.getClassName=function(){var y=this;return"highcharts-point"+(y.selected?" highcharts-point-select":"")+(y.negative?" highcharts-negative":"")+(y.isNull?" highcharts-null-point":"")+(typeof y.colorIndex<"u"?" highcharts-color-"+y.colorIndex:"")+(y.options.className?" "+y.options.className:"")+(y.zone&&y.zone.className?" "+y.zone.className.replace("highcharts-negative",""):"")},z.prototype.getGraphicalProps=function(y){var a=this,k=[],j={singular:[],plural:[]},et,it;for(y=y||{graphic:1,dataLabel:1},y.graphic&&k.push("graphic","upperGraphic","shadowGroup"),y.dataLabel&&k.push("dataLabel","dataLabelUpper","connector"),it=k.length;it--;)et=k[it],a[et]&&j.singular.push(et);return["dataLabel","connector"].forEach(function(nt){var ot=nt+"s";y[nt]&&a[ot]&&j.plural.push(ot)}),j},z.prototype.getLabelConfig=function(){return{x:this.category,y:this.y,color:this.color,colorIndex:this.colorIndex,key:this.name||this.category,series:this.series,point:this,percentage:this.percentage,total:this.total||this.stackTotal}},z.prototype.getNestedProperty=function(y){if(y)return y.indexOf("custom.")===0?getNestedProperty$1(y,this.options):this[y]},z.prototype.getZone=function(){var y=this.series,a=y.zones,k=y.zoneAxis||"y",j,et=0;for(j=a[et];this[k]>=j.value;)j=a[++et];return this.nonZonedColor||(this.nonZonedColor=this.color),j&&j.color&&!this.options.color?this.color=j.color:this.color=this.nonZonedColor,j},z.prototype.hasNewShapeType=function(){var y=this,a=y.graphic&&(y.graphic.symbolName||y.graphic.element.nodeName);return a!==this.shapeType},z.prototype.init=function(y,a,k){return this.series=y,this.applyOptions(a,k),this.id=defined$O(this.id)?this.id:uniqueKey$5(),this.resolveColor(),y.chart.pointCount++,fireEvent$w(this,"afterInit"),this},z.prototype.optionsToObject=function(y){var a=this.series,k=a.options.keys,j=k||a.pointArrayMap||["y"],et=j.length,it={},nt,ot=0,at=0;if(isNumber$K(y)||y===null)it[j[0]]=y;else if(isArray$k(y))for(!k&&y.length>et&&(nt=typeof y[0],nt==="string"?it.name=y[0]:nt==="number"&&(it.x=y[0]),ot++);at<et;)(!k||typeof y[ot]<"u")&&(j[at].indexOf(".")>0?z.prototype.setNestedProperty(it,y[ot],j[at]):it[j[at]]=y[ot]),ot++,at++;else typeof y=="object"&&(it=y,y.dataLabels&&(a._hasPointLabels=!0),y.marker&&(a._hasPointMarkers=!0));return it},z.prototype.resolveColor=function(){var y=this.series,a=y.chart.options.chart,k=y.chart.styledMode,j,et,it=a.colorCount,nt;delete this.nonZonedColor,y.options.colorByPoint?(k||(et=y.options.colors||y.chart.options.colors,j=et[y.colorCounter],it=et.length),nt=y.colorCounter,y.colorCounter++,y.colorCounter===it&&(y.colorCounter=0)):(k||(j=y.color),nt=y.colorIndex),this.colorIndex=pick$1t(this.options.colorIndex,nt),this.color=pick$1t(this.options.color,j)},z.prototype.setNestedProperty=function(y,a,k){var j=k.split(".");return j.reduce(function(et,it,nt,ot){var at=ot.length-1===nt;return et[it]=at?a:isObject$e(et[it],!0)?et[it]:{},et[it]},y),y},z.prototype.tooltipFormatter=function(y){var a=this.series,k=a.tooltipOptions,j=pick$1t(k.valueDecimals,""),et=k.valuePrefix||"",it=k.valueSuffix||"";return a.chart.styledMode&&(y=a.chart.tooltip.styledModeFormat(y)),(a.pointArrayMap||["y"]).forEach(function(nt){nt="{point."+nt,(et||it)&&(y=y.replace(RegExp(nt+"}","g"),et+nt+"}"+it)),y=y.replace(RegExp(nt+"}","g"),nt+":,."+j+"f}")}),format$c(y,{point:this,series:this.series},a.chart)},z.prototype.update=function(y,a,k,j){var et=this,it=et.series,nt=et.graphic,ot=it.chart,at=it.options,lt;a=pick$1t(a,!0);function ct(){et.applyOptions(y);var ht=nt&&et.hasDummyGraphic,ut=et.y===null?!ht:ht;nt&&ut&&(et.graphic=nt.destroy(),delete et.hasDummyGraphic),isObject$e(y,!0)&&(nt&&nt.element&&y&&y.marker&&typeof y.marker.symbol<"u"&&(et.graphic=nt.destroy()),y&&y.dataLabels&&et.dataLabel&&(et.dataLabel=et.dataLabel.destroy()),et.connector&&(et.connector=et.connector.destroy())),lt=et.index,it.updateParallelArrays(et,lt),at.data[lt]=isObject$e(at.data[lt],!0)||isObject$e(y,!0)?et.options:pick$1t(y,at.data[lt]),it.isDirty=it.isDirtyData=!0,!it.fixedBox&&it.hasCartesianSeries&&(ot.isDirtyBox=!0),at.legendType==="point"&&(ot.isDirtyLegend=!0),a&&ot.redraw(k)}j===!1?ct():et.firePointEvent("update",{options:y},ct)},z.prototype.remove=function(y,a){this.series.removePoint(this.series.data.indexOf(this),y,a)},z.prototype.select=function(y,a){var k=this,j=k.series,et=j.chart;y=pick$1t(y,!k.selected),this.selectedStaging=y,k.firePointEvent(y?"select":"unselect",{accumulate:a},function(){k.selected=k.options.selected=y,j.options.data[j.data.indexOf(k)]=k.options,k.setState(y&&"select"),a||et.getSelectedPoints().forEach(function(it){var nt=it.series;it.selected&&it!==k&&(it.selected=it.options.selected=!1,nt.options.data[nt.data.indexOf(it)]=it.options,it.setState(et.hoverPoints&&nt.options.inactiveOtherPoints?"inactive":""),it.firePointEvent("unselect"))})}),delete this.selectedStaging},z.prototype.onMouseOver=function(y){var a=this,k=a.series,j=k.chart,et=j.pointer;y=y?et.normalize(y):et.getChartCoordinatesFromPoint(a,j.inverted),et.runPointActions(y,a)},z.prototype.onMouseOut=function(){var y=this,a=y.series.chart;y.firePointEvent("mouseOut"),y.series.options.inactiveOtherPoints||(a.hoverPoints||[]).forEach(function(k){k.setState()}),a.hoverPoints=a.hoverPoint=null},z.prototype.importEvents=function(){if(!this.hasImportedEvents){var y=this,a=merge$1l(y.series.options.point,y.options),k=a.events;y.events=k,objectEach$s(k,function(j,et){isFunction$2(j)&&addEvent$12(y,et,j)}),this.hasImportedEvents=!0}},z.prototype.setState=function(y,a){var k=this,j=k.series,et=k.state,it=j.options.states[y||"normal"]||{},nt=defaultOptions$g.plotOptions[j.type].marker&&j.options.marker,ot=nt&&nt.enabled===!1,at=nt&&nt.states&&nt.states[y||"normal"]||{},lt=at.enabled===!1,ct=k.marker||{},ht=j.chart,ut=nt&&j.markerAttribs,ft=j.halo,vt,gt,mt,bt=j.stateMarkerGraphic,xt;if(y=y||"",!(y===k.state&&!a||k.selected&&y!=="select"||it.enabled===!1||y&&(lt||ot&&at.enabled===!1)||y&&ct.states&&ct.states[y]&&ct.states[y].enabled===!1)){k.state=y,ut&&(vt=j.markerAttribs(k,y)),k.graphic&&!k.hasDummyGraphic?(et&&k.graphic.removeClass("highcharts-point-"+et),y&&k.graphic.addClass("highcharts-point-"+y),ht.styledMode||(gt=j.pointAttribs(k,y),mt=pick$1t(ht.options.chart.animation,it.animation),j.options.inactiveOtherPoints&&isNumber$K(gt.opacity)&&((k.dataLabels||[]).forEach(function(St){St&&St.animate({opacity:gt.opacity},mt)}),k.connector&&k.connector.animate({opacity:gt.opacity},mt)),k.graphic.animate(gt,mt)),vt&&k.graphic.animate(vt,pick$1t(ht.options.chart.animation,at.animation,nt.animation)),bt&&bt.hide()):(y&&at&&(xt=ct.symbol||j.symbol,bt&&bt.currentSymbol!==xt&&(bt=bt.destroy()),vt&&(bt?bt[a?"animate":"attr"]({x:vt.x,y:vt.y}):xt&&(j.stateMarkerGraphic=bt=ht.renderer.symbol(xt,vt.x,vt.y,vt.width,vt.height).add(j.markerGroup),bt.currentSymbol=xt)),!ht.styledMode&&bt&&bt.attr(j.pointAttribs(k,y))),bt&&(bt[y&&k.isInside?"show":"hide"](),bt.element.point=k,bt.addClass(k.getClassName(),!0)));var wt=it.halo,Mt=k.graphic||bt,Et=Mt&&Mt.visibility||"inherit";wt&&wt.size&&Mt&&Et!=="hidden"&&!k.isCluster?(ft||(j.halo=ft=ht.renderer.path().add(Mt.parentGroup)),ft.show()[a?"animate":"attr"]({d:k.haloPath(wt.size)}),ft.attr({class:"highcharts-halo highcharts-color-"+pick$1t(k.colorIndex,j.colorIndex)+(k.className?" "+k.className:""),visibility:Et,zIndex:-1}),ft.point=k,ht.styledMode||ft.attr(extend$1n({fill:k.color||j.color,"fill-opacity":wt.opacity},AST.filterUserAttributes(wt.attributes||{})))):ft&&ft.point&&ft.point.haloPath&&ft.animate({d:ft.point.haloPath(0)},null,ft.hide),fireEvent$w(k,"afterSetState",{state:y})}},z.prototype.haloPath=function(y){var a=this.series,k=a.chart;return k.renderer.symbols.circle(Math.floor(this.plotX)-y,this.plotY-y,y*2,y*2)},z})(),color$e=Color.parse,charts$3=H.charts,noop$i=H.noop,addEvent$11=Utilities.addEvent,attr$2=Utilities.attr,css$8=Utilities.css,defined$N=Utilities.defined,extend$1m=Utilities.extend,find$k=Utilities.find,fireEvent$v=Utilities.fireEvent,isNumber$J=Utilities.isNumber,isObject$d=Utilities.isObject,objectEach$r=Utilities.objectEach,offset=Utilities.offset,pick$1s=Utilities.pick,splat$g=Utilities.splat,Pointer=(function(){function z(y,a){this.lastValidTouch={},this.pinchDown=[],this.runChartClick=!1,this.eventsToUnbind=[],this.chart=y,this.hasDragged=!1,this.options=a,this.init(y,a)}return z.prototype.applyInactiveState=function(y){var a=[],k;(y||[]).forEach(function(j){k=j.series,a.push(k),k.linkedParent&&a.push(k.linkedParent),k.linkedSeries&&(a=a.concat(k.linkedSeries)),k.navigatorSeries&&a.push(k.navigatorSeries)}),this.chart.series.forEach(function(j){a.indexOf(j)===-1?j.setState("inactive",!0):j.options.inactiveOtherPoints&&j.setAllPointsToState("inactive")})},z.prototype.destroy=function(){var y=this;this.eventsToUnbind.forEach(function(a){return a()}),this.eventsToUnbind=[],H.chartCount||(z.unbindDocumentMouseUp&&(z.unbindDocumentMouseUp=z.unbindDocumentMouseUp()),z.unbindDocumentTouchEnd&&(z.unbindDocumentTouchEnd=z.unbindDocumentTouchEnd())),clearInterval(y.tooltipTimeout),objectEach$r(y,function(a,k){y[k]=void 0})},z.prototype.drag=function(y){var a=this.chart,k=a.options.chart,j=this.zoomHor,et=this.zoomVert,it=a.plotLeft,nt=a.plotTop,ot=a.plotWidth,at=a.plotHeight,lt=this.mouseDownX||0,ct=this.mouseDownY||0,ht=isObject$d(k.panning)?k.panning&&k.panning.enabled:k.panning,ut=k.panKey&&y[k.panKey+"Key"],ft=y.chartX,vt=y.chartY,gt,mt,bt=this.selectionMarker;bt&&bt.touch||(ft<it?ft=it:ft>it+ot&&(ft=it+ot),vt<nt?vt=nt:vt>nt+at&&(vt=nt+at),this.hasDragged=Math.sqrt(Math.pow(lt-ft,2)+Math.pow(ct-vt,2)),this.hasDragged>10&&(gt=a.isInsidePlot(lt-it,ct-nt,{visiblePlotOnly:!0}),a.hasCartesianSeries&&(this.zoomX||this.zoomY)&&gt&&!ut&&(bt||(this.selectionMarker=bt=a.renderer.rect(it,nt,j?1:ot,et?1:at,0).attr({class:"highcharts-selection-marker",zIndex:7}).add(),a.styledMode||bt.attr({fill:k.selectionMarkerFill||color$e(palette.highlightColor80).setOpacity(.25).get()}))),bt&&j&&(mt=ft-lt,bt.attr({width:Math.abs(mt),x:(mt>0?0:mt)+lt})),bt&&et&&(mt=vt-ct,bt.attr({height:Math.abs(mt),y:(mt>0?0:mt)+ct})),gt&&!bt&&ht&&a.pan(y,k.panning)))},z.prototype.dragStart=function(y){var a=this.chart;a.mouseIsDown=y.type,a.cancelClick=!1,a.mouseDownX=this.mouseDownX=y.chartX,a.mouseDownY=this.mouseDownY=y.chartY},z.prototype.drop=function(y){var a=this,k=this.chart,j=this.hasPinched;if(this.selectionMarker){var et={originalEvent:y,xAxis:[],yAxis:[]},it=this.selectionMarker,nt=it.attr?it.attr("x"):it.x,ot=it.attr?it.attr("y"):it.y,at=it.attr?it.attr("width"):it.width,lt=it.attr?it.attr("height"):it.height,ct;(this.hasDragged||j)&&(k.axes.forEach(function(ht){if(ht.zoomEnabled&&defined$N(ht.min)&&(j||a[{xAxis:"zoomX",yAxis:"zoomY"}[ht.coll]])&&isNumber$J(nt)&&isNumber$J(ot)){var ut=ht.horiz,ft=y.type==="touchend"?ht.minPixelPadding:0,vt=ht.toValue((ut?nt:ot)+ft),gt=ht.toValue((ut?nt+at:ot+lt)-ft);et[ht.coll].push({axis:ht,min:Math.min(vt,gt),max:Math.max(vt,gt)}),ct=!0}}),ct&&fireEvent$v(k,"selection",et,function(ht){k.zoom(extend$1m(ht,j?{animation:!1}:null))})),isNumber$J(k.index)&&(this.selectionMarker=this.selectionMarker.destroy()),j&&this.scaleGroups()}k&&isNumber$J(k.index)&&(css$8(k.container,{cursor:k._cursor}),k.cancelClick=this.hasDragged>10,k.mouseIsDown=this.hasDragged=this.hasPinched=!1,this.pinchDown=[])},z.prototype.findNearestKDPoint=function(y,a,k){var j=this.chart,et=j.hoverPoint,it=j.tooltip;if(et&&it&&it.isStickyOnContact())return et;var nt;function ot(at,lt){var ct=at.distX-lt.distX,ht=at.dist-lt.dist,ut=(lt.series.group&&lt.series.group.zIndex)-(at.series.group&&at.series.group.zIndex),ft;return ct!==0&&a?ft=ct:ht!==0?ft=ht:ut!==0?ft=ut:ft=at.series.index>lt.series.index?-1:1,ft}return y.forEach(function(at){var lt=at.noSharedTooltip&&a,ct=!lt&&at.options.findNearestPointBy.indexOf("y")<0,ht=at.searchPoint(k,ct);isObject$d(ht,!0)&&ht.series&&(!isObject$d(nt,!0)||ot(nt,ht)>0)&&(nt=ht)}),nt},z.prototype.getChartCoordinatesFromPoint=function(y,a){var k=y.series,j=k.xAxis,et=k.yAxis,it=y.shapeArgs;if(j&&et){var nt=pick$1s(y.clientX,y.plotX),ot=y.plotY||0;return y.isNode&&it&&isNumber$J(it.x)&&isNumber$J(it.y)&&(nt=it.x,ot=it.y),a?{chartX:et.len+et.pos-ot,chartY:j.len+j.pos-nt}:{chartX:nt+j.pos,chartY:ot+et.pos}}if(it&&it.x&&it.y)return{chartX:it.x,chartY:it.y}},z.prototype.getChartPosition=function(){if(this.chartPosition)return this.chartPosition;var y=this.chart.container,a=offset(y);this.chartPosition={left:a.left,top:a.top,scaleX:1,scaleY:1};var k=y.offsetWidth,j=y.offsetHeight;return k>2&&j>2&&(this.chartPosition.scaleX=a.width/k,this.chartPosition.scaleY=a.height/j),this.chartPosition},z.prototype.getCoordinates=function(y){var a={xAxis:[],yAxis:[]};return this.chart.axes.forEach(function(k){a[k.isXAxis?"xAxis":"yAxis"].push({axis:k,value:k.toValue(y[k.horiz?"chartX":"chartY"])})}),a},z.prototype.getHoverData=function(y,a,k,j,et,it){var nt=[],ot=!!(j&&y),at=function(vt){return vt.visible&&!(!et&&vt.directTouch)&&pick$1s(vt.options.enableMouseTracking,!0)},lt=a,ct,ht={chartX:it?it.chartX:void 0,chartY:it?it.chartY:void 0,shared:et};fireEvent$v(this,"beforeGetHoverData",ht);var ut=lt&&!lt.stickyTracking;ct=ut?[lt]:k.filter(function(vt){return ht.filter?ht.filter(vt):at(vt)&&vt.stickyTracking});var ft=ot||!it?y:this.findNearestKDPoint(ct,et,it);return lt=ft&&ft.series,ft&&(et&&!lt.noSharedTooltip?(ct=k.filter(function(vt){return ht.filter?ht.filter(vt):at(vt)&&!vt.noSharedTooltip}),ct.forEach(function(vt){var gt=find$k(vt.points,function(mt){return mt.x===ft.x&&!mt.isNull});isObject$d(gt)&&(vt.chart.isBoosting&&(gt=vt.getPoint(gt)),nt.push(gt))})):nt.push(ft)),ht={hoverPoint:ft},fireEvent$v(this,"afterGetHoverData",ht),{hoverPoint:ht.hoverPoint,hoverSeries:lt,hoverPoints:nt}},z.prototype.getPointFromEvent=function(y){for(var a=y.target,k;a&&!k;)k=a.point,a=a.parentNode;return k},z.prototype.onTrackerMouseOut=function(y){var a=this.chart,k=y.relatedTarget||y.toElement,j=a.hoverSeries;this.isDirectTouch=!1,j&&k&&!j.stickyTracking&&!this.inClass(k,"highcharts-tooltip")&&(!this.inClass(k,"highcharts-series-"+j.index)||!this.inClass(k,"highcharts-tracker"))&&j.onMouseOut()},z.prototype.inClass=function(y,a){for(var k;y;){if(k=attr$2(y,"class"),k){if(k.indexOf(a)!==-1)return!0;if(k.indexOf("highcharts-container")!==-1)return!1}y=y.parentNode}},z.prototype.init=function(y,a){this.options=a,this.chart=y,this.runChartClick=!!(a.chart.events&&a.chart.events.click),this.pinchDown=[],this.lastValidTouch={},Tooltip&&(y.tooltip=new Tooltip(y,a.tooltip),this.followTouchMove=pick$1s(a.tooltip.followTouchMove,!0)),this.setDOMEvents()},z.prototype.normalize=function(y,a){var k=y.touches,j=k?k.length?k.item(0):pick$1s(k.changedTouches,y.changedTouches)[0]:y;a||(a=this.getChartPosition());var et=j.pageX-a.left,it=j.pageY-a.top;return et/=a.scaleX,it/=a.scaleY,extend$1m(y,{chartX:Math.round(et),chartY:Math.round(it)})},z.prototype.onContainerClick=function(y){var a=this.chart,k=a.hoverPoint,j=this.normalize(y),et=a.plotLeft,it=a.plotTop;a.cancelClick||(k&&this.inClass(j.target,"highcharts-tracker")?(fireEvent$v(k.series,"click",extend$1m(j,{point:k})),a.hoverPoint&&k.firePointEvent("click",j)):(extend$1m(j,this.getCoordinates(j)),a.isInsidePlot(j.chartX-et,j.chartY-it,{visiblePlotOnly:!0})&&fireEvent$v(a,"click",j)))},z.prototype.onContainerMouseDown=function(y){var a=((y.buttons||y.button)&1)===1;y=this.normalize(y),H.isFirefox&&y.button!==0&&this.onContainerMouseMove(y),(typeof y.button>"u"||a)&&(this.zoomOption(y),a&&y.preventDefault&&y.preventDefault(),this.dragStart(y))},z.prototype.onContainerMouseLeave=function(y){var a=charts$3[pick$1s(z.hoverChartIndex,-1)],k=this.chart.tooltip;k&&k.shouldStickOnContact()&&this.inClass(y.relatedTarget,"highcharts-tooltip-container")||(y=this.normalize(y),a&&(y.relatedTarget||y.toElement)&&(a.pointer.reset(),a.pointer.chartPosition=void 0),k&&!k.isHidden&&this.reset())},z.prototype.onContainerMouseEnter=function(y){delete this.chartPosition},z.prototype.onContainerMouseMove=function(y){var a=this.chart,k=this.normalize(y);this.setHoverChartIndex(),k.preventDefault||(k.returnValue=!1),(a.mouseIsDown==="mousedown"||this.touchSelect(k))&&this.drag(k),!a.openMenu&&(this.inClass(k.target,"highcharts-tracker")||a.isInsidePlot(k.chartX-a.plotLeft,k.chartY-a.plotTop,{visiblePlotOnly:!0}))&&(this.inClass(k.target,"highcharts-no-tooltip")?this.reset(!1,0):this.runPointActions(k))},z.prototype.onDocumentTouchEnd=function(y){var a=charts$3[pick$1s(z.hoverChartIndex,-1)];a&&a.pointer.drop(y)},z.prototype.onContainerTouchMove=function(y){this.touchSelect(y)?this.onContainerMouseMove(y):this.touch(y)},z.prototype.onContainerTouchStart=function(y){this.touchSelect(y)?this.onContainerMouseDown(y):(this.zoomOption(y),this.touch(y,!0))},z.prototype.onDocumentMouseMove=function(y){var a=this.chart,k=this.chartPosition,j=this.normalize(y,k),et=a.tooltip;k&&(!et||!et.isStickyOnContact())&&!a.isInsidePlot(j.chartX-a.plotLeft,j.chartY-a.plotTop,{visiblePlotOnly:!0})&&!this.inClass(j.target,"highcharts-tracker")&&this.reset()},z.prototype.onDocumentMouseUp=function(y){var a=charts$3[pick$1s(z.hoverChartIndex,-1)];a&&a.pointer.drop(y)},z.prototype.pinch=function(y){var a=this,k=a.chart,j=a.pinchDown,et=y.touches||[],it=et.length,nt=a.lastValidTouch,ot=a.hasZoom,at={},lt=it===1&&(a.inClass(y.target,"highcharts-tracker")&&k.runTrackerClick||a.runChartClick),ct={},ht=a.selectionMarker;it>1?a.initiated=!0:it===1&&this.followTouchMove&&(a.initiated=!1),ot&&a.initiated&&!lt&&y.cancelable!==!1&&y.preventDefault(),[].map.call(et,function(ut){return a.normalize(ut)}),y.type==="touchstart"?([].forEach.call(et,function(ut,ft){j[ft]={chartX:ut.chartX,chartY:ut.chartY}}),nt.x=[j[0].chartX,j[1]&&j[1].chartX],nt.y=[j[0].chartY,j[1]&&j[1].chartY],k.axes.forEach(function(ut){if(ut.zoomEnabled){var ft=k.bounds[ut.horiz?"h":"v"],vt=ut.minPixelPadding,gt=ut.toPixels(Math.min(pick$1s(ut.options.min,ut.dataMin),ut.dataMin)),mt=ut.toPixels(Math.max(pick$1s(ut.options.max,ut.dataMax),ut.dataMax)),bt=Math.min(gt,mt),xt=Math.max(gt,mt);ft.min=Math.min(ut.pos,bt-vt),ft.max=Math.max(ut.pos+ut.len,xt+vt)}}),a.res=!0):a.followTouchMove&&it===1?this.runPointActions(a.normalize(y)):j.length&&(ht||(a.selectionMarker=ht=extend$1m({destroy:noop$i,touch:!0},k.plotBox)),a.pinchTranslate(j,et,at,ht,ct,nt),a.hasPinched=ot,a.scaleGroups(at,ct),a.res&&(a.res=!1,this.reset(!1,0)))},z.prototype.pinchTranslate=function(y,a,k,j,et,it){this.zoomHor&&this.pinchTranslateDirection(!0,y,a,k,j,et,it),this.zoomVert&&this.pinchTranslateDirection(!1,y,a,k,j,et,it)},z.prototype.pinchTranslateDirection=function(y,a,k,j,et,it,nt,ot){var at=this.chart,lt=y?"x":"y",ct=y?"X":"Y",ht="chart"+ct,ut=y?"width":"height",ft=at["plot"+(y?"Left":"Top")],vt=at.inverted,gt=at.bounds[y?"h":"v"],mt=a.length===1,bt=a[0][ht],xt=!mt&&a[1][ht],wt=function(){typeof It=="number"&&Math.abs(bt-xt)>20&&(kt=ot||Math.abs(Pt-It)/Math.abs(bt-xt)),St=(ft-Pt)/kt+bt,Mt=at["plot"+(y?"Width":"Height")]/kt},Mt,Et,St,kt=ot||1,Pt=k[0][ht],It=!mt&&k[1][ht],Nt;wt(),Et=St,Et<gt.min?(Et=gt.min,Nt=!0):Et+Mt>gt.max&&(Et=gt.max-Mt,Nt=!0),Nt?(Pt-=.8*(Pt-nt[lt][0]),typeof It=="number"&&(It-=.8*(It-nt[lt][1])),wt()):nt[lt]=[Pt,It],vt||(it[lt]=St-ft,it[ut]=Mt);var Ut=vt?y?"scaleY":"scaleX":"scale"+ct,Rt=vt?1/kt:kt;et[ut]=Mt,et[lt]=Et,j[Ut]=kt,j["translate"+ct]=Rt*ft+(Pt-Rt*bt)},z.prototype.reset=function(y,a){var k=this,j=k.chart,et=j.hoverSeries,it=j.hoverPoint,nt=j.hoverPoints,ot=j.tooltip,at=ot&&ot.shared?nt:it;y&&at&&splat$g(at).forEach(function(lt){lt.series.isCartesian&&typeof lt.plotX>"u"&&(y=!1)}),y?ot&&at&&splat$g(at).length&&(ot.refresh(at),ot.shared&&nt?nt.forEach(function(lt){lt.setState(lt.state,!0),lt.series.isCartesian&&(lt.series.xAxis.crosshair&&lt.series.xAxis.drawCrosshair(null,lt),lt.series.yAxis.crosshair&&lt.series.yAxis.drawCrosshair(null,lt))}):it&&(it.setState(it.state,!0),j.axes.forEach(function(lt){lt.crosshair&&it.series[lt.coll]===lt&&lt.drawCrosshair(null,it)}))):(it&&it.onMouseOut(),nt&&nt.forEach(function(lt){lt.setState()}),et&&et.onMouseOut(),ot&&ot.hide(a),k.unDocMouseMove&&(k.unDocMouseMove=k.unDocMouseMove()),j.axes.forEach(function(lt){lt.hideCrosshair()}),k.hoverX=j.hoverPoints=j.hoverPoint=null)},z.prototype.runPointActions=function(y,a){var k=this,j=k.chart,et=j.series,it=j.tooltip&&j.tooltip.options.enabled?j.tooltip:void 0,nt=it?it.shared:!1,ot=a||j.hoverPoint,at=ot&&ot.series||j.hoverSeries,lt=(!y||y.type!=="touchmove")&&(!!a||at&&at.directTouch&&k.isDirectTouch),ct=this.getHoverData(ot,at,et,lt,nt,y);ot=ct.hoverPoint,at=ct.hoverSeries;var ht=ct.hoverPoints,ut=at&&at.tooltipOptions.followPointer&&!at.tooltipOptions.split,ft=nt&&at&&!at.noSharedTooltip;if(ot&&(ot!==j.hoverPoint||it&&it.isHidden)){if((j.hoverPoints||[]).forEach(function(gt){ht.indexOf(gt)===-1&&gt.setState()}),j.hoverSeries!==at&&at.onMouseOver(),k.applyInactiveState(ht),(ht||[]).forEach(function(gt){gt.setState("hover")}),j.hoverPoint&&j.hoverPoint.firePointEvent("mouseOut"),!ot.series)return;j.hoverPoints=ht,j.hoverPoint=ot,ot.firePointEvent("mouseOver"),it&&it.refresh(ft?ht:ot,y)}else if(ut&&it&&!it.isHidden){var vt=it.getAnchor([{}],y);j.isInsidePlot(vt[0],vt[1],{visiblePlotOnly:!0})&&it.updatePosition({plotX:vt[0],plotY:vt[1]})}k.unDocMouseMove||(k.unDocMouseMove=addEvent$11(j.container.ownerDocument,"mousemove",function(gt){var mt=charts$3[z.hoverChartIndex];mt&&mt.pointer.onDocumentMouseMove(gt)}),k.eventsToUnbind.push(k.unDocMouseMove)),j.axes.forEach(function(mt){var bt=pick$1s((mt.crosshair||{}).snap,!0),xt;bt&&(xt=j.hoverPoint,(!xt||xt.series[mt.coll]!==mt)&&(xt=find$k(ht,function(wt){return wt.series[mt.coll]===mt}))),xt||!bt?mt.drawCrosshair(y,xt):mt.hideCrosshair()})},z.prototype.scaleGroups=function(y,a){var k=this.chart;k.series.forEach(function(j){var et=y||j.getPlotBox();j.xAxis&&j.xAxis.zoomEnabled&&j.group&&(j.group.attr(et),j.markerGroup&&(j.markerGroup.attr(et),j.markerGroup.clip(a?k.clipRect:null)),j.dataLabelsGroup&&j.dataLabelsGroup.attr(et))}),k.clipRect.attr(a||k.clipBox)},z.prototype.setDOMEvents=function(){var y=this,a=this.chart.container,k=a.ownerDocument;a.onmousedown=this.onContainerMouseDown.bind(this),a.onmousemove=this.onContainerMouseMove.bind(this),a.onclick=this.onContainerClick.bind(this),this.eventsToUnbind.push(addEvent$11(a,"mouseenter",this.onContainerMouseEnter.bind(this))),this.eventsToUnbind.push(addEvent$11(a,"mouseleave",this.onContainerMouseLeave.bind(this))),z.unbindDocumentMouseUp||(z.unbindDocumentMouseUp=addEvent$11(k,"mouseup",this.onDocumentMouseUp.bind(this)));for(var j=this.chart.renderTo.parentElement;j&&j.tagName!=="BODY";)this.eventsToUnbind.push(addEvent$11(j,"scroll",function(){delete y.chartPosition})),j=j.parentElement;H.hasTouch&&(this.eventsToUnbind.push(addEvent$11(a,"touchstart",this.onContainerTouchStart.bind(this),{passive:!1})),this.eventsToUnbind.push(addEvent$11(a,"touchmove",this.onContainerTouchMove.bind(this),{passive:!1})),z.unbindDocumentTouchEnd||(z.unbindDocumentTouchEnd=addEvent$11(k,"touchend",this.onDocumentTouchEnd.bind(this),{passive:!1})))},z.prototype.setHoverChartIndex=function(){var y=this.chart,a=H.charts[pick$1s(z.hoverChartIndex,-1)];a&&a!==y&&a.pointer.onContainerMouseLeave({relatedTarget:!0}),(!a||!a.mouseIsDown)&&(z.hoverChartIndex=y.index)},z.prototype.touch=function(y,a){var k=this.chart,j,et,it;this.setHoverChartIndex(),y.touches.length===1?(y=this.normalize(y),it=k.isInsidePlot(y.chartX-k.plotLeft,y.chartY-k.plotTop,{visiblePlotOnly:!0}),it&&!k.openMenu?(a&&this.runPointActions(y),y.type==="touchmove"&&(et=this.pinchDown,j=et[0]?Math.sqrt(Math.pow(et[0].chartX-y.chartX,2)+Math.pow(et[0].chartY-y.chartY,2))>=4:!1),pick$1s(j,!0)&&this.pinch(y)):a&&this.reset()):y.touches.length===2&&this.pinch(y)},z.prototype.touchSelect=function(y){return!!(this.chart.options.chart.zoomBySingleTouch&&y.touches&&y.touches.length===1)},z.prototype.zoomOption=function(y){var a=this.chart,k=a.options.chart,j=a.inverted,et=k.zoomType||"",it,nt;/touch/.test(y.type)&&(et=pick$1s(k.pinchType,et)),this.zoomX=it=/x/.test(et),this.zoomY=nt=/y/.test(et),this.zoomHor=it&&!j||nt&&j,this.zoomVert=nt&&!j||it&&j,this.hasZoom=it||nt},z})(),__extends$2e=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),charts$2=H.charts,doc$h=H.doc,noop$h=H.noop,win$a=H.win,addEvent$10=Utilities.addEvent,css$7=Utilities.css,objectEach$q=Utilities.objectEach,removeEvent$7=Utilities.removeEvent,touches={},hasPointerEvent=!!win$a.PointerEvent;function getWebkitTouches(){var z=[];return z.item=function(y){return this[y]},objectEach$q(touches,function(y){z.push({pageX:y.pageX,pageY:y.pageY,target:y.target})}),z}function translateMSPointer(z,y,a,k){var j=charts$2[Pointer.hoverChartIndex||NaN];if((z.pointerType==="touch"||z.pointerType===z.MSPOINTER_TYPE_TOUCH)&&j){var et=j.pointer;k(z),et[y]({type:a,target:z.currentTarget,preventDefault:noop$h,touches:getWebkitTouches()})}}var MSPointer=(function(z){__extends$2e(y,z);function y(){return z!==null&&z.apply(this,arguments)||this}return y.isRequired=function(){return!!(!H.hasTouch&&(win$a.PointerEvent||win$a.MSPointerEvent))},y.prototype.batchMSEvents=function(a){a(this.chart.container,hasPointerEvent?"pointerdown":"MSPointerDown",this.onContainerPointerDown),a(this.chart.container,hasPointerEvent?"pointermove":"MSPointerMove",this.onContainerPointerMove),a(doc$h,hasPointerEvent?"pointerup":"MSPointerUp",this.onDocumentPointerUp)},y.prototype.destroy=function(){this.batchMSEvents(removeEvent$7),z.prototype.destroy.call(this)},y.prototype.init=function(a,k){z.prototype.init.call(this,a,k),this.hasZoom&&css$7(a.container,{"-ms-touch-action":"none","touch-action":"none"})},y.prototype.onContainerPointerDown=function(a){translateMSPointer(a,"onContainerTouchStart","touchstart",function(k){touches[k.pointerId]={pageX:k.pageX,pageY:k.pageY,target:k.currentTarget}})},y.prototype.onContainerPointerMove=function(a){translateMSPointer(a,"onContainerTouchMove","touchmove",function(k){touches[k.pointerId]={pageX:k.pageX,pageY:k.pageY},touches[k.pointerId].target||(touches[k.pointerId].target=k.currentTarget)})},y.prototype.onDocumentPointerUp=function(a){translateMSPointer(a,"onDocumentTouchEnd","touchend",function(k){delete touches[k.pointerId]})},y.prototype.setDOMEvents=function(){z.prototype.setDOMEvents.call(this),(this.hasZoom||this.followTouchMove)&&this.batchMSEvents(addEvent$10)},y})(Pointer),animObject$9=animationExports.animObject,setAnimation$4=animationExports.setAnimation,format$b=FormatUtilities.format,isFirefox$1=H.isFirefox,marginNames$1=H.marginNames,win$9=H.win,distribute$2=R.distribute,addEvent$$=Utilities.addEvent,createElement$6=Utilities.createElement,css$6=Utilities.css,defined$M=Utilities.defined,discardElement$4=Utilities.discardElement,find$j=Utilities.find,fireEvent$u=Utilities.fireEvent,isNumber$I=Utilities.isNumber,merge$1k=Utilities.merge,pick$1r=Utilities.pick,relativeLength$8=Utilities.relativeLength,stableSort$5=Utilities.stableSort,syncTimeout$4=Utilities.syncTimeout,wrap$g=Utilities.wrap,Legend=(function(){function z(y,a){this.allItems=[],this.box=void 0,this.contentGroup=void 0,this.display=!1,this.group=void 0,this.initialItemY=0,this.itemHeight=0,this.itemMarginBottom=0,this.itemMarginTop=0,this.itemX=0,this.itemY=0,this.lastItemY=0,this.lastLineHeight=0,this.legendHeight=0,this.legendWidth=0,this.maxItemWidth=0,this.maxLegendWidth=0,this.offsetWidth=0,this.options={},this.padding=0,this.pages=[],this.proximate=!1,this.scrollGroup=void 0,this.symbolHeight=0,this.symbolWidth=0,this.titleHeight=0,this.totalItemWidth=0,this.widthOption=0,this.chart=y,this.init(y,a)}return z.prototype.init=function(y,a){this.chart=y,this.setOptions(a),a.enabled&&(this.render(),addEvent$$(this.chart,"endResize",function(){this.legend.positionCheckboxes()}),this.proximate?this.unchartrender=addEvent$$(this.chart,"render",function(){this.legend.proximatePositions(),this.legend.positionItems()}):this.unchartrender&&this.unchartrender())},z.prototype.setOptions=function(y){var a=pick$1r(y.padding,8);this.options=y,this.chart.styledMode||(this.itemStyle=y.itemStyle,this.itemHiddenStyle=merge$1k(this.itemStyle,y.itemHiddenStyle)),this.itemMarginTop=y.itemMarginTop||0,this.itemMarginBottom=y.itemMarginBottom||0,this.padding=a,this.initialItemY=a-5,this.symbolWidth=pick$1r(y.symbolWidth,16),this.pages=[],this.proximate=y.layout==="proximate"&&!this.chart.inverted,this.baseline=void 0},z.prototype.update=function(y,a){var k=this.chart;this.setOptions(merge$1k(!0,this.options,y)),this.destroy(),k.isDirtyLegend=k.isDirtyBox=!0,pick$1r(a,!0)&&k.redraw(),fireEvent$u(this,"afterUpdate")},z.prototype.colorizeItem=function(y,a){if(y.legendGroup[a?"removeClass":"addClass"]("highcharts-legend-item-hidden"),!this.chart.styledMode){var k=this,j=k.options,et=y.legendItem,it=y.legendLine,nt=y.legendSymbol,ot=k.itemHiddenStyle.color,at=a?j.itemStyle.color:ot,lt=a&&y.color||ot,ct=y.options&&y.options.marker,ht={fill:lt};et&&et.css({fill:at,color:at}),it&&it.attr({stroke:lt}),nt&&(ct&&nt.isMarker&&(ht=y.pointAttribs(),a||(ht.stroke=ht.fill=ot)),nt.attr(ht))}fireEvent$u(this,"afterColorizeItem",{item:y,visible:a})},z.prototype.positionItems=function(){this.allItems.forEach(this.positionItem,this),this.chart.isResizing||this.positionCheckboxes()},z.prototype.positionItem=function(y){var a=this,k=this,j=k.options,et=j.symbolPadding,it=!j.rtl,nt=y._legendItemPos,ot=nt[0],at=nt[1],lt=y.checkbox,ct=y.legendGroup;if(ct&&ct.element){var ht={translateX:it?ot:k.legendWidth-ot-2*et-4,translateY:at},ut=function(){fireEvent$u(a,"afterPositionItem",{item:y})};defined$M(ct.translateY)?ct.animate(ht,void 0,ut):(ct.attr(ht),ut())}lt&&(lt.x=ot,lt.y=at)},z.prototype.destroyItem=function(y){var a=y.checkbox;["legendItem","legendLine","legendSymbol","legendGroup"].forEach(function(k){y[k]&&(y[k]=y[k].destroy())}),a&&discardElement$4(y.checkbox)},z.prototype.destroy=function(){function y(a){this[a]&&(this[a]=this[a].destroy())}this.getAllItems().forEach(function(a){["legendItem","legendGroup"].forEach(y,a)}),["clipRect","up","down","pager","nav","box","title","group"].forEach(y,this),this.display=null},z.prototype.positionCheckboxes=function(){var y=this.group&&this.group.alignAttr,a=this.clipHeight||this.legendHeight,k=this.titleHeight,j;y&&(j=y.translateY,this.allItems.forEach(function(et){var it=et.checkbox,nt;it&&(nt=j+k+it.y+(this.scrollOffset||0)+3,css$6(it,{left:y.translateX+et.checkboxOffset+it.x-20+"px",top:nt+"px",display:this.proximate||nt>j-6&&nt<j+a-6?"":"none"}))},this))},z.prototype.renderTitle=function(){var y=this.options,a=this.padding,k=y.title,j,et=0;k.text&&(this.title||(this.title=this.chart.renderer.label(k.text,a-3,a-4,null,null,null,y.useHTML,null,"legend-title").attr({zIndex:1}),this.chart.styledMode||this.title.css(k.style),this.title.add(this.group)),k.width||this.title.css({width:this.maxLegendWidth+"px"}),j=this.title.getBBox(),et=j.height,this.offsetWidth=j.width,this.contentGroup.attr({translateY:et})),this.titleHeight=et},z.prototype.setText=function(y){var a=this.options;y.legendItem.attr({text:a.labelFormat?format$b(a.labelFormat,y,this.chart):a.labelFormatter.call(y)})},z.prototype.renderItem=function(y){var a=this,k=a.chart,j=k.renderer,et=a.options,it=et.layout==="horizontal",nt=a.symbolWidth,ot=et.symbolPadding||0,at=a.itemStyle,lt=a.itemHiddenStyle,ct=it?pick$1r(et.itemDistance,20):0,ht=!et.rtl,ut=!y.series,ft=!ut&&y.series.drawLegendSymbol?y.series:y,vt=ft.options,gt=a.createCheckboxForItem&&vt&&vt.showCheckbox,mt=et.useHTML,bt=y.options.className,xt=y.legendItem,wt=nt+ot+ct+(gt?20:0);xt||(y.legendGroup=j.g("legend-item").addClass("highcharts-"+ft.type+"-series highcharts-color-"+y.colorIndex+(bt?" "+bt:"")+(ut?" highcharts-series-"+y.index:"")).attr({zIndex:1}).add(a.scrollGroup),y.legendItem=xt=j.text("",ht?nt+ot:-ot,a.baseline||0,mt),k.styledMode||xt.css(merge$1k(y.visible?at:lt)),xt.attr({align:ht?"left":"right",zIndex:2}).add(y.legendGroup),a.baseline||(a.fontMetrics=j.fontMetrics(k.styledMode?12:at.fontSize,xt),a.baseline=a.fontMetrics.f+3+a.itemMarginTop,xt.attr("y",a.baseline),a.symbolHeight=et.symbolHeight||a.fontMetrics.f,et.squareSymbol&&(a.symbolWidth=pick$1r(et.symbolWidth,Math.max(a.symbolHeight,16)),wt=a.symbolWidth+ot+ct+(gt?20:0),ht&&xt.attr("x",a.symbolWidth+ot))),ft.drawLegendSymbol(a,y),a.setItemEvents&&a.setItemEvents(y,xt,mt)),gt&&!y.checkbox&&a.createCheckboxForItem&&a.createCheckboxForItem(y),a.colorizeItem(y,y.visible),(k.styledMode||!at.width)&&xt.css({width:(et.itemWidth||a.widthOption||k.spacingBox.width)-wt+"px"}),a.setText(y);var Mt=xt.getBBox();y.itemWidth=y.checkboxOffset=et.itemWidth||y.legendItemWidth||Mt.width+wt,a.maxItemWidth=Math.max(a.maxItemWidth,y.itemWidth),a.totalItemWidth+=y.itemWidth,a.itemHeight=y.itemHeight=Math.round(y.legendItemHeight||Mt.height||a.symbolHeight)},z.prototype.layoutItem=function(y){var a=this.options,k=this.padding,j=a.layout==="horizontal",et=y.itemHeight,it=this.itemMarginBottom,nt=this.itemMarginTop,ot=j?pick$1r(a.itemDistance,20):0,at=this.maxLegendWidth,lt=a.alignColumns&&this.totalItemWidth>at?this.maxItemWidth:y.itemWidth;j&&this.itemX-k+lt>at&&(this.itemX=k,this.lastLineHeight&&(this.itemY+=nt+this.lastLineHeight+it),this.lastLineHeight=0),this.lastItemY=nt+this.itemY+it,this.lastLineHeight=Math.max(et,this.lastLineHeight),y._legendItemPos=[this.itemX,this.itemY],j?this.itemX+=lt:(this.itemY+=nt+et+it,this.lastLineHeight=et),this.offsetWidth=this.widthOption||Math.max((j?this.itemX-k-(y.checkbox?0:ot):lt)+k,this.offsetWidth)},z.prototype.getAllItems=function(){var y=[];return this.chart.series.forEach(function(a){var k=a&&a.options;a&&pick$1r(k.showInLegend,defined$M(k.linkedTo)?!1:void 0,!0)&&(y=y.concat(a.legendItems||(k.legendType==="point"?a.data:a)))}),fireEvent$u(this,"afterGetAllItems",{allItems:y}),y},z.prototype.getAlignment=function(){var y=this.options;return this.proximate?y.align.charAt(0)+"tv":y.floating?"":y.align.charAt(0)+y.verticalAlign.charAt(0)+y.layout.charAt(0)},z.prototype.adjustMargins=function(y,a){var k=this.chart,j=this.options,et=this.getAlignment();et&&[/(lth|ct|rth)/,/(rtv|rm|rbv)/,/(rbh|cb|lbh)/,/(lbv|lm|ltv)/].forEach(function(it,nt){it.test(et)&&!defined$M(y[nt])&&(k[marginNames$1[nt]]=Math.max(k[marginNames$1[nt]],k.legend[(nt+1)%2?"legendHeight":"legendWidth"]+[1,-1,-1,1][nt]*j[nt%2?"x":"y"]+pick$1r(j.margin,12)+a[nt]+(k.titleOffset[nt]||0)))})},z.prototype.proximatePositions=function(){var y=this.chart,a=[],k=this.options.align==="left";this.allItems.forEach(function(j){var et,it,nt=k,ot,at;j.yAxis&&(j.xAxis.options.reversed&&(nt=!nt),j.points&&(et=find$j(nt?j.points:j.points.slice(0).reverse(),function(lt){return isNumber$I(lt.plotY)})),it=this.itemMarginTop+j.legendItem.getBBox().height+this.itemMarginBottom,at=j.yAxis.top-y.plotTop,j.visible?(ot=et?et.plotY:j.yAxis.height,ot+=at-.3*it):ot=at+j.yAxis.height,a.push({target:ot,size:it,item:j}))},this),distribute$2(a,y.plotHeight).forEach(function(j){j.item._legendItemPos&&(j.item._legendItemPos[1]=y.plotTop-y.spacing[0]+j.pos)})},z.prototype.render=function(){var y=this,a=y.chart,k=a.renderer,j=y.options,et=y.padding,it=y.getAllItems(),nt,ot,at,lt=y.group,ct,ht=y.box;y.itemX=et,y.itemY=y.initialItemY,y.offsetWidth=0,y.lastItemY=0,y.widthOption=relativeLength$8(j.width,a.spacingBox.width-et),ct=a.spacingBox.width-2*et-j.x,["rm","lm"].indexOf(y.getAlignment().substring(0,2))>-1&&(ct/=2),y.maxLegendWidth=y.widthOption||ct,lt||(y.group=lt=k.g("legend").addClass(j.className||"").attr({zIndex:7}).add(),y.contentGroup=k.g().attr({zIndex:1}).add(lt),y.scrollGroup=k.g().add(y.contentGroup)),y.renderTitle(),stableSort$5(it,function(ut,ft){return(ut.options&&ut.options.legendIndex||0)-(ft.options&&ft.options.legendIndex||0)}),j.reversed&&it.reverse(),y.allItems=it,y.display=nt=!!it.length,y.lastLineHeight=0,y.maxItemWidth=0,y.totalItemWidth=0,y.itemHeight=0,it.forEach(y.renderItem,y),it.forEach(y.layoutItem,y),ot=(y.widthOption||y.offsetWidth)+et,at=y.lastItemY+y.lastLineHeight+y.titleHeight,at=y.handleOverflow(at),at+=et,ht||(y.box=ht=k.rect().addClass("highcharts-legend-box").attr({r:j.borderRadius}).add(lt),ht.isNew=!0),a.styledMode||ht.attr({stroke:j.borderColor,"stroke-width":j.borderWidth||0,fill:j.backgroundColor||"none"}).shadow(j.shadow),ot>0&&at>0&&(ht[ht.isNew?"attr":"animate"](ht.crisp.call({},{x:0,y:0,width:ot,height:at},ht.strokeWidth())),ht.isNew=!1),ht[nt?"show":"hide"](),a.styledMode&&lt.getStyle("display")==="none"&&(ot=at=0),y.legendWidth=ot,y.legendHeight=at,nt&&y.align(),this.proximate||this.positionItems(),fireEvent$u(this,"afterRender")},z.prototype.align=function(y){y===void 0&&(y=this.chart.spacingBox);var a=this.chart,k=this.options,j=y.y;/(lth|ct|rth)/.test(this.getAlignment())&&a.titleOffset[0]>0?j+=a.titleOffset[0]:/(lbh|cb|rbh)/.test(this.getAlignment())&&a.titleOffset[2]>0&&(j-=a.titleOffset[2]),j!==y.y&&(y=merge$1k(y,{y:j})),this.group.align(merge$1k(k,{width:this.legendWidth,height:this.legendHeight,verticalAlign:this.proximate?"top":k.verticalAlign}),!0,y)},z.prototype.handleOverflow=function(y){var a=this,k=this.chart,j=k.renderer,et=this.options,it=et.y,nt=et.verticalAlign==="top",ot=this.padding,at=et.maxHeight,lt=et.navigation,ct=pick$1r(lt.animation,!0),ht=lt.arrowSize||12,ut=this.pages,ft=this.allItems,vt=function(Et){typeof Et=="number"?Mt.attr({height:Et}):Mt&&(a.clipRect=Mt.destroy(),a.contentGroup.clip()),a.contentGroup.div&&(a.contentGroup.div.style.clip=Et?"rect("+ot+"px,9999px,"+(ot+Et)+"px,0)":"auto")},gt=function(Et){return a[Et]=j.circle(0,0,ht*1.3).translate(ht/2,ht/2).add(wt),k.styledMode||a[Et].attr("fill","rgba(0,0,0,0.0001)"),a[Et]},mt,bt,xt=k.spacingBox.height+(nt?-it:it)-ot,wt=this.nav,Mt=this.clipRect;return et.layout==="horizontal"&&et.verticalAlign!=="middle"&&!et.floating&&(xt/=2),at&&(xt=Math.min(xt,at)),ut.length=0,y&&xt>0&&y>xt&&lt.enabled!==!1?(this.clipHeight=mt=Math.max(xt-20-this.titleHeight-ot,0),this.currentPage=pick$1r(this.currentPage,1),this.fullHeight=y,ft.forEach(function(Et,St){var kt=Et._legendItemPos[1],Pt=Math.round(Et.legendItem.getBBox().height),It=ut.length;(!It||kt-ut[It-1]>mt&&(bt||kt)!==ut[It-1])&&(ut.push(bt||kt),It++),Et.pageIx=It-1,bt&&(ft[St-1].pageIx=It-1),St===ft.length-1&&kt+Pt-ut[It-1]>mt&&kt!==bt&&(ut.push(kt),Et.pageIx=It),kt!==bt&&(bt=kt)}),Mt||(Mt=a.clipRect=j.clipRect(0,ot,9999,0),a.contentGroup.clip(Mt)),vt(mt),wt||(this.nav=wt=j.g().attr({zIndex:1}).add(this.group),this.up=j.symbol("triangle",0,0,ht,ht).add(wt),gt("upTracker").on("click",function(){a.scroll(-1,ct)}),this.pager=j.text("",15,10).addClass("highcharts-legend-navigation"),k.styledMode||this.pager.css(lt.style),this.pager.add(wt),this.down=j.symbol("triangle-down",0,0,ht,ht).add(wt),gt("downTracker").on("click",function(){a.scroll(1,ct)})),a.scroll(0),y=xt):wt&&(vt(),this.nav=wt.destroy(),this.scrollGroup.attr({translateY:1}),this.clipHeight=0),y},z.prototype.scroll=function(y,a){var k=this,j=this.chart,et=this.pages,it=et.length,nt=this.clipHeight,ot=this.options.navigation,at=this.pager,lt=this.padding,ct=this.currentPage+y;if(ct>it&&(ct=it),ct>0){typeof a<"u"&&setAnimation$4(a,j),this.nav.attr({translateX:lt,translateY:nt+this.padding+7+this.titleHeight,visibility:"visible"}),[this.up,this.upTracker].forEach(function(ut){ut.attr({class:ct===1?"highcharts-legend-nav-inactive":"highcharts-legend-nav-active"})}),at.attr({text:ct+"/"+it}),[this.down,this.downTracker].forEach(function(ut){ut.attr({x:18+this.pager.getBBox().width,class:ct===it?"highcharts-legend-nav-inactive":"highcharts-legend-nav-active"})},this),j.styledMode||(this.up.attr({fill:ct===1?ot.inactiveColor:ot.activeColor}),this.upTracker.css({cursor:ct===1?"default":"pointer"}),this.down.attr({fill:ct===it?ot.inactiveColor:ot.activeColor}),this.downTracker.css({cursor:ct===it?"default":"pointer"})),this.scrollOffset=-et[ct-1]+this.initialItemY,this.scrollGroup.animate({translateY:this.scrollOffset}),this.currentPage=ct,this.positionCheckboxes();var ht=animObject$9(pick$1r(a,j.renderer.globalAnimation,!0));syncTimeout$4(function(){fireEvent$u(k,"afterScroll",{currentPage:ct})},ht.duration)}},z.prototype.setItemEvents=function(y,a,k){var j=this,et=j.chart.renderer.boxWrapper,it=y instanceof Point$4,nt="highcharts-legend-"+(it?"point":"series")+"-active",ot=j.chart.styledMode,at=k?[a,y.legendSymbol]:[y.legendGroup],lt=function(ct){j.allItems.forEach(function(ht){y!==ht&&[ht].concat(ht.linkedSeries||[]).forEach(function(ut){ut.setState(ct,!it)})})};at.forEach(function(ct){ct&&ct.on("mouseover",function(){y.visible&&lt("inactive"),y.setState("hover"),y.visible&&et.addClass(nt),ot||a.css(j.options.itemHoverStyle)}).on("mouseout",function(){j.chart.styledMode||a.css(merge$1k(y.visible?j.itemStyle:j.itemHiddenStyle)),lt(""),et.removeClass(nt),y.setState()}).on("click",function(ht){var ut="legendItemClick",ft=function(){y.setVisible&&y.setVisible(),lt(y.visible?"inactive":"")};et.removeClass(nt),ht={browserEvent:ht},y.firePointEvent?y.firePointEvent(ut,ht,ft):fireEvent$u(y,ut,ht,ft)})})},z.prototype.createCheckboxForItem=function(y){var a=this;y.checkbox=createElement$6("input",{type:"checkbox",className:"highcharts-legend-checkbox",checked:y.selected,defaultChecked:y.selected},a.options.itemCheckboxStyle,a.chart.container),addEvent$$(y.checkbox,"click",function(k){var j=k.target;fireEvent$u(y.series||y,"checkboxClick",{checked:j.checked,item:y},function(){y.select()})})},z})();(/Trident\/7\.0/.test(win$9.navigator&&win$9.navigator.userAgent)||isFirefox$1)&&wrap$g(Legend.prototype,"positionItem",function(z,y){var a=this,k=function(){y._legendItemPos&&z.call(a,y)};k(),a.bubbleLegend||setTimeout(k)});var defaultOptions$f=DefaultOptions.defaultOptions,error$8=Utilities.error,extendClass$1=Utilities.extendClass,merge$1j=Utilities.merge,SeriesRegistry;(function(z){z.seriesTypes=H.seriesTypes;function y(j,et){et===void 0&&(et={});var it=j.options.chart,nt=et.type||it.type||it.defaultSeriesType||"",ot=z.seriesTypes[nt];z||error$8(17,!0,j,{missingModuleFor:nt});var at=new ot;return typeof at.init=="function"&&at.init(j,et),at}z.getSeries=y;function a(j,et){var it=defaultOptions$f.plotOptions||{},nt=et.defaultOptions;et.prototype.pointClass||(et.prototype.pointClass=Point$4),et.prototype.type=j,nt&&(it[j]=nt),z.seriesTypes[j]=et}z.registerSeriesType=a;function k(j,et,it,nt,ot){var at=defaultOptions$f.plotOptions||{};return et=et||"",at[j]=merge$1j(at[et],it),a(j,extendClass$1(z.seriesTypes[et]||function(){},nt)),z.seriesTypes[j].prototype.type=j,ot&&(z.seriesTypes[j].prototype.pointClass=extendClass$1(Point$4,ot)),z.seriesTypes[j]}z.seriesType=k})(SeriesRegistry||(SeriesRegistry={}));const SeriesRegistry$1=SeriesRegistry;var animate=animationExports.animate,animObject$8=animationExports.animObject,setAnimation$3=animationExports.setAnimation,numberFormat$1=FormatUtilities.numberFormat,registerEventOptions$1=exports$5.registerEventOptions,charts$1=H.charts,doc$g=H.doc,marginNames=H.marginNames,svg$5=H.svg,win$8=H.win,defaultOptions$e=DefaultOptions.defaultOptions,defaultTime=DefaultOptions.defaultTime,seriesTypes$8=SeriesRegistry$1.seriesTypes,addEvent$_=Utilities.addEvent,attr$1=Utilities.attr,cleanRecursively$1=Utilities.cleanRecursively,createElement$5=Utilities.createElement,css$5=Utilities.css,defined$L=Utilities.defined,discardElement$3=Utilities.discardElement,erase$4=Utilities.erase,error$7=Utilities.error,extend$1l=Utilities.extend,find$i=Utilities.find,fireEvent$t=Utilities.fireEvent,getStyle=Utilities.getStyle,isArray$j=Utilities.isArray,isNumber$H=Utilities.isNumber,isObject$c=Utilities.isObject,isString$6=Utilities.isString,merge$1i=Utilities.merge,objectEach$p=Utilities.objectEach,pick$1q=Utilities.pick,pInt$4=Utilities.pInt,relativeLength$7=Utilities.relativeLength,removeEvent$6=Utilities.removeEvent,splat$f=Utilities.splat,syncTimeout$3=Utilities.syncTimeout,uniqueKey$4=Utilities.uniqueKey,Chart$1=(function(){function z(y,a,k){this.axes=void 0,this.axisOffset=void 0,this.bounds=void 0,this.chartHeight=void 0,this.chartWidth=void 0,this.clipBox=void 0,this.colorCounter=void 0,this.container=void 0,this.eventOptions=void 0,this.index=void 0,this.isResizing=void 0,this.labelCollectors=void 0,this.legend=void 0,this.margin=void 0,this.numberFormatter=void 0,this.options=void 0,this.plotBox=void 0,this.plotHeight=void 0,this.plotLeft=void 0,this.plotTop=void 0,this.plotWidth=void 0,this.pointCount=void 0,this.pointer=void 0,this.renderer=void 0,this.renderTo=void 0,this.series=void 0,this.sharedClips={},this.spacing=void 0,this.spacingBox=void 0,this.symbolCounter=void 0,this.time=void 0,this.titleOffset=void 0,this.userOptions=void 0,this.xAxis=void 0,this.yAxis=void 0,this.getArgs(y,a,k)}return z.chart=function(y,a,k){return new z(y,a,k)},z.prototype.getArgs=function(y,a,k){isString$6(y)||y.nodeName?(this.renderTo=y,this.init(a,k)):this.init(y,a)},z.prototype.init=function(y,a){var k=y.plotOptions||{};fireEvent$t(this,"init",{args:arguments},function(){var j=merge$1i(defaultOptions$e,y),et=j.chart;objectEach$p(j.plotOptions,function(nt,ot){isObject$c(nt)&&(nt.tooltip=k[ot]&&merge$1i(k[ot].tooltip)||void 0)}),j.tooltip.userOptions=y.chart&&y.chart.forExport&&y.tooltip.userOptions||y.tooltip,this.userOptions=y,this.margin=[],this.spacing=[],this.bounds={h:{},v:{}},this.labelCollectors=[],this.callback=a,this.isResizing=0,this.options=j,this.axes=[],this.series=[],this.time=y.time&&Object.keys(y.time).length?new Time(y.time):H.time,this.numberFormatter=et.numberFormatter||numberFormat$1,this.styledMode=et.styledMode,this.hasCartesianSeries=et.showAxes;var it=this;it.index=charts$1.length,charts$1.push(it),H.chartCount++,registerEventOptions$1(this,et),it.xAxis=[],it.yAxis=[],it.pointCount=it.colorCounter=it.symbolCounter=0,fireEvent$t(it,"afterInit"),it.firstRender()})},z.prototype.initSeries=function(y){var a=this,k=a.options.chart,j=y.type||k.type||k.defaultSeriesType,et=seriesTypes$8[j];et||error$7(17,!0,a,{missingModuleFor:j});var it=new et;return typeof it.init=="function"&&it.init(a,y),it},z.prototype.setSeriesData=function(){this.getSeriesOrderByLinks().forEach(function(y){!y.points&&!y.data&&y.enabledDataSorting&&y.setData(y.options.data,!1)})},z.prototype.getSeriesOrderByLinks=function(){return this.series.concat().sort(function(y,a){return y.linkedSeries.length||a.linkedSeries.length?a.linkedSeries.length-y.linkedSeries.length:0})},z.prototype.orderSeries=function(y){for(var a=this.series,k=y||0,j=a.length;k<j;++k)a[k]&&(a[k].index=k,a[k].name=a[k].getName())},z.prototype.isInsidePlot=function(y,a,k){var j;k===void 0&&(k={});var et=this,it=et.inverted,nt=et.plotBox,ot=et.plotLeft,at=et.plotTop,lt=et.scrollablePlotBox,ct=0,ht=0;k.visiblePlotOnly&&this.scrollingContainer&&(j=this.scrollingContainer,ct=j.scrollLeft,ht=j.scrollTop);var ut=k.series,ft=k.visiblePlotOnly&&lt||nt,vt=k.inverted?a:y,gt=k.inverted?y:a,mt={x:vt,y:gt,isInsidePlot:!0};if(!k.ignoreX){var bt=ut&&(it?ut.yAxis:ut.xAxis)||{pos:ot,len:1/0},xt=k.paneCoordinates?bt.pos+vt:ot+vt;xt>=Math.max(ct+ot,bt.pos)&&xt<=Math.min(ct+ot+ft.width,bt.pos+bt.len)||(mt.isInsidePlot=!1)}if(!k.ignoreY&&mt.isInsidePlot){var wt=ut&&(it?ut.xAxis:ut.yAxis)||{pos:at,len:1/0},Mt=k.paneCoordinates?wt.pos+gt:at+gt;Mt>=Math.max(ht+at,wt.pos)&&Mt<=Math.min(ht+at+ft.height,wt.pos+wt.len)||(mt.isInsidePlot=!1)}return fireEvent$t(this,"afterIsInsidePlot",mt),mt.isInsidePlot},z.prototype.redraw=function(y){fireEvent$t(this,"beforeRedraw");var a=this,k=a.hasCartesianSeries?a.axes:a.colorAxis||[],j=a.series,et=a.pointer,it=a.legend,nt=a.userOptions.legend,ot=a.renderer,at=ot.isHidden(),lt=[],ct,ht,ut,ft=a.isDirtyBox,vt=a.isDirtyLegend,gt;for(a.setResponsive&&a.setResponsive(!1),setAnimation$3(a.hasRendered?y:!1,a),at&&a.temporaryDisplay(),a.layOutTitles(),ut=j.length;ut--;)if(gt=j[ut],(gt.options.stacking||gt.options.centerInCategory)&&(ht=!0,gt.isDirty)){ct=!0;break}if(ct)for(ut=j.length;ut--;)gt=j[ut],gt.options.stacking&&(gt.isDirty=!0);j.forEach(function(mt){mt.isDirty&&(mt.options.legendType==="point"?(typeof mt.updateTotals=="function"&&mt.updateTotals(),vt=!0):nt&&(nt.labelFormatter||nt.labelFormat)&&(vt=!0)),mt.isDirtyData&&fireEvent$t(mt,"updatedData")}),vt&&it&&it.options.enabled&&(it.render(),a.isDirtyLegend=!1),ht&&a.getStacks(),k.forEach(function(mt){mt.updateNames(),mt.setScale()}),a.getMargins(),k.forEach(function(mt){mt.isDirty&&(ft=!0)}),k.forEach(function(mt){var bt=mt.min+","+mt.max;mt.extKey!==bt&&(mt.extKey=bt,lt.push(function(){fireEvent$t(mt,"afterSetExtremes",extend$1l(mt.eventArgs,mt.getExtremes())),delete mt.eventArgs})),(ft||ht)&&mt.redraw()}),ft&&a.drawChartBox(),fireEvent$t(a,"predraw"),j.forEach(function(mt){(ft||mt.isDirty)&&mt.visible&&mt.redraw(),mt.isDirtyData=!1}),et&&et.reset(!0),ot.draw(),fireEvent$t(a,"redraw"),fireEvent$t(a,"render"),at&&a.temporaryDisplay(!0),lt.forEach(function(mt){mt.call()})},z.prototype.get=function(y){var a=this.series;function k(it){return it.id===y||it.options&&it.options.id===y}for(var j=find$i(this.axes,k)||find$i(this.series,k),et=0;!j&&et<a.length;et++)j=find$i(a[et].points||[],k);return j},z.prototype.getAxes=function(){var y=this,a=this.options,k=a.xAxis=splat$f(a.xAxis||{}),j=a.yAxis=splat$f(a.yAxis||{});fireEvent$t(this,"getAxes"),k.forEach(function(it,nt){it.index=nt,it.isX=!0}),j.forEach(function(it,nt){it.index=nt});var et=k.concat(j);et.forEach(function(it){new Axis(y,it)}),fireEvent$t(this,"afterGetAxes")},z.prototype.getSelectedPoints=function(){return this.series.reduce(function(y,a){return a.getPointsCollection().forEach(function(k){pick$1q(k.selectedStaging,k.selected)&&y.push(k)}),y},[])},z.prototype.getSelectedSeries=function(){return this.series.filter(function(y){return y.selected})},z.prototype.setTitle=function(y,a,k){this.applyDescription("title",y),this.applyDescription("subtitle",a),this.applyDescription("caption",void 0),this.layOutTitles(k)},z.prototype.applyDescription=function(y,a){var k=this,j=y==="title"?{color:palette.neutralColor80,fontSize:this.options.isStock?"16px":"18px"}:{color:palette.neutralColor60},et=this.options[y]=merge$1i(!this.styledMode&&{style:j},this.options[y],a),it=this[y];it&&a&&(this[y]=it=it.destroy()),et&&!it&&(it=this.renderer.text(et.text,0,0,et.useHTML).attr({align:et.align,class:"highcharts-"+y,zIndex:et.zIndex||4}).add(),it.update=function(nt){var ot={title:"setTitle",subtitle:"setSubtitle",caption:"setCaption"}[y];k[ot](nt)},this.styledMode||it.css(et.style),this[y]=it)},z.prototype.layOutTitles=function(y){var a=[0,0,0],k=this.renderer,j=this.spacingBox;["title","subtitle","caption"].forEach(function(it){var nt=this[it],ot=this.options[it],at=ot.verticalAlign||"top",lt=it==="title"?at==="top"?-3:0:at==="top"?a[0]+2:0,ct,ht;nt&&(this.styledMode||(ct=ot.style&&ot.style.fontSize),ct=k.fontMetrics(ct,nt).b,nt.css({width:(ot.width||j.width+(ot.widthAdjust||0))+"px"}),ht=Math.round(nt.getBBox(ot.useHTML).height),nt.align(extend$1l({y:at==="bottom"?ct:lt+ct,height:ht},ot),!1,"spacingBox"),ot.floating||(at==="top"?a[0]=Math.ceil(a[0]+ht):at==="bottom"&&(a[2]=Math.ceil(a[2]+ht))))},this),a[0]&&(this.options.title.verticalAlign||"top")==="top"&&(a[0]+=this.options.title.margin),a[2]&&this.options.caption.verticalAlign==="bottom"&&(a[2]+=this.options.caption.margin);var et=!this.titleOffset||this.titleOffset.join(",")!==a.join(",");this.titleOffset=a,fireEvent$t(this,"afterLayOutTitles"),!this.isDirtyBox&&et&&(this.isDirtyBox=this.isDirtyLegend=et,this.hasRendered&&pick$1q(y,!0)&&this.isDirtyBox&&this.redraw())},z.prototype.getChartSize=function(){var y=this,a=y.options.chart,k=a.width,j=a.height,et=y.renderTo;defined$L(k)||(y.containerWidth=getStyle(et,"width")),defined$L(j)||(y.containerHeight=getStyle(et,"height")),y.chartWidth=Math.max(0,k||y.containerWidth||600),y.chartHeight=Math.max(0,relativeLength$7(j,y.chartWidth)||(y.containerHeight>1?y.containerHeight:400))},z.prototype.temporaryDisplay=function(y){var a=this.renderTo,k;if(y)for(;a&&a.style;)a.hcOrigStyle&&(css$5(a,a.hcOrigStyle),delete a.hcOrigStyle),a.hcOrigDetached&&(doc$g.body.removeChild(a),a.hcOrigDetached=!1),a=a.parentNode;else for(;a&&a.style&&(!doc$g.body.contains(a)&&!a.parentNode&&(a.hcOrigDetached=!0,doc$g.body.appendChild(a)),(getStyle(a,"display",!1)==="none"||a.hcOricDetached)&&(a.hcOrigStyle={display:a.style.display,height:a.style.height,overflow:a.style.overflow},k={display:"block",overflow:"hidden"},a!==this.renderTo&&(k.height=0),css$5(a,k),a.offsetWidth||a.style.setProperty("display","block","important")),a=a.parentNode,a!==doc$g.body););},z.prototype.setClassName=function(y){this.container.className="highcharts-container "+(y||"")},z.prototype.getContainer=function(){var y=this,a=y.options,k=a.chart,j="data-highcharts-chart",et=uniqueKey$4(),it,nt=y.renderTo;nt||(y.renderTo=nt=k.renderTo),isString$6(nt)&&(y.renderTo=nt=doc$g.getElementById(nt)),nt||error$7(13,!0,y);var ot=pInt$4(attr$1(nt,j));isNumber$H(ot)&&charts$1[ot]&&charts$1[ot].hasRendered&&charts$1[ot].destroy(),attr$1(nt,j,y.index),nt.innerHTML="",!k.skipClone&&!nt.offsetWidth&&y.temporaryDisplay(),y.getChartSize();var at=y.chartWidth,lt=y.chartHeight;css$5(nt,{overflow:"hidden"}),y.styledMode||(it=extend$1l({position:"relative",overflow:"hidden",width:at+"px",height:lt+"px",textAlign:"left",lineHeight:"normal",zIndex:0,"-webkit-tap-highlight-color":"rgba(0,0,0,0)",userSelect:"none","touch-action":"manipulation",outline:"none"},k.style||{}));var ct=createElement$5("div",{id:et},it,nt);y.container=ct,y._cursor=ct.style.cursor;var ht=k.renderer||!svg$5?RendererRegistry$1.getRendererType(k.renderer):SVGRenderer;if(y.renderer=new ht(ct,at,lt,void 0,k.forExport,a.exporting&&a.exporting.allowHTML,y.styledMode),setAnimation$3(void 0,y),y.setClassName(k.className),!y.styledMode)y.renderer.setStyle(k.style);else for(var ut in a.defs)this.renderer.definition(a.defs[ut]);y.renderer.chartIndex=y.index,fireEvent$t(this,"afterGetContainer")},z.prototype.getMargins=function(y){var a=this,k=a.spacing,j=a.margin,et=a.titleOffset;this.resetMargins(),et[0]&&!defined$L(j[0])&&(this.plotTop=Math.max(this.plotTop,et[0]+k[0])),et[2]&&!defined$L(j[2])&&(this.marginBottom=Math.max(this.marginBottom,et[2]+k[2])),this.legend&&this.legend.display&&this.legend.adjustMargins(j,k),fireEvent$t(this,"getMargins"),y||this.getAxisMargins()},z.prototype.getAxisMargins=function(){var y=this,a=y.axisOffset=[0,0,0,0],k=y.colorAxis,j=y.margin,et=function(it){it.forEach(function(nt){nt.visible&&nt.getOffset()})};y.hasCartesianSeries?et(y.axes):k&&k.length&&et(k),marginNames.forEach(function(it,nt){defined$L(j[nt])||(y[it]+=a[nt])}),y.setChartSize()},z.prototype.reflow=function(y){var a=this,k=a.options.chart,j=a.renderTo,et=defined$L(k.width)&&defined$L(k.height),it=k.width||getStyle(j,"width"),nt=k.height||getStyle(j,"height"),ot=y?y.target:win$8;delete a.pointer.chartPosition,!et&&!a.isPrinting&&it&&nt&&(ot===win$8||ot===doc$g)&&((it!==a.containerWidth||nt!==a.containerHeight)&&(Utilities.clearTimeout(a.reflowTimeout),a.reflowTimeout=syncTimeout$3(function(){a.container&&a.setSize(void 0,void 0,!1)},y?100:0)),a.containerWidth=it,a.containerHeight=nt)},z.prototype.setReflow=function(y){var a=this;y!==!1&&!this.unbindReflow?(this.unbindReflow=addEvent$_(win$8,"resize",function(k){a.options&&a.reflow(k)}),addEvent$_(this,"destroy",this.unbindReflow)):y===!1&&this.unbindReflow&&(this.unbindReflow=this.unbindReflow())},z.prototype.setSize=function(y,a,k){var j=this,et=j.renderer;j.isResizing+=1,setAnimation$3(k,j);var it=et.globalAnimation;j.oldChartHeight=j.chartHeight,j.oldChartWidth=j.chartWidth,typeof y<"u"&&(j.options.chart.width=y),typeof a<"u"&&(j.options.chart.height=a),j.getChartSize(),j.styledMode||(it?animate:css$5)(j.container,{width:j.chartWidth+"px",height:j.chartHeight+"px"},it),j.setChartSize(!0),et.setSize(j.chartWidth,j.chartHeight,it),j.axes.forEach(function(nt){nt.isDirty=!0,nt.setScale()}),j.isDirtyLegend=!0,j.isDirtyBox=!0,j.layOutTitles(),j.getMargins(),j.redraw(it),j.oldChartHeight=null,fireEvent$t(j,"resize"),syncTimeout$3(function(){j&&fireEvent$t(j,"endResize",null,function(){j.isResizing-=1})},animObject$8(it).duration)},z.prototype.setChartSize=function(y){var a=this,k=a.inverted,j=a.renderer,et=a.chartWidth,it=a.chartHeight,nt=a.options.chart,ot=a.spacing,at=a.clipOffset,lt,ct,ht,ut;a.plotLeft=lt=Math.round(a.plotLeft),a.plotTop=ct=Math.round(a.plotTop),a.plotWidth=ht=Math.max(0,Math.round(et-lt-a.marginRight)),a.plotHeight=ut=Math.max(0,Math.round(it-ct-a.marginBottom)),a.plotSizeX=k?ut:ht,a.plotSizeY=k?ht:ut,a.plotBorderWidth=nt.plotBorderWidth||0,a.spacingBox=j.spacingBox={x:ot[3],y:ot[0],width:et-ot[3]-ot[1],height:it-ot[0]-ot[2]},a.plotBox=j.plotBox={x:lt,y:ct,width:ht,height:ut};var ft=2*Math.floor(a.plotBorderWidth/2),vt=Math.ceil(Math.max(ft,at[3])/2),gt=Math.ceil(Math.max(ft,at[0])/2);a.clipBox={x:vt,y:gt,width:Math.floor(a.plotSizeX-Math.max(ft,at[1])/2-vt),height:Math.max(0,Math.floor(a.plotSizeY-Math.max(ft,at[2])/2-gt))},y||(a.axes.forEach(function(mt){mt.setAxisSize(),mt.setAxisTranslation()}),j.alignElements()),fireEvent$t(a,"afterSetChartSize",{skipAxes:y})},z.prototype.resetMargins=function(){fireEvent$t(this,"resetMargins");var y=this,a=y.options.chart;["margin","spacing"].forEach(function(j){var et=a[j],it=isObject$c(et)?et:[et,et,et,et];["Top","Right","Bottom","Left"].forEach(function(nt,ot){y[j][ot]=pick$1q(a[j+nt],it[ot])})}),marginNames.forEach(function(k,j){y[k]=pick$1q(y.margin[j],y.spacing[j])}),y.axisOffset=[0,0,0,0],y.clipOffset=[0,0,0,0]},z.prototype.drawChartBox=function(){var y=this,a=y.options.chart,k=y.renderer,j=y.chartWidth,et=y.chartHeight,it=y.styledMode,nt=y.plotBGImage,ot=a.backgroundColor,at=a.plotBackgroundColor,lt=a.plotBackgroundImage,ct=y.plotLeft,ht=y.plotTop,ut=y.plotWidth,ft=y.plotHeight,vt=y.plotBox,gt=y.clipRect,mt=y.clipBox,bt=y.chartBackground,xt=y.plotBackground,wt=y.plotBorder,Mt,Et,St,kt="animate";bt||(y.chartBackground=bt=k.rect().addClass("highcharts-background").add(),kt="attr"),it?Mt=Et=bt.strokeWidth():(Mt=a.borderWidth||0,Et=Mt+(a.shadow?8:0),St={fill:ot||"none"},(Mt||bt["stroke-width"])&&(St.stroke=a.borderColor,St["stroke-width"]=Mt),bt.attr(St).shadow(a.shadow)),bt[kt]({x:Et/2,y:Et/2,width:j-Et-Mt%2,height:et-Et-Mt%2,r:a.borderRadius}),kt="animate",xt||(kt="attr",y.plotBackground=xt=k.rect().addClass("highcharts-plot-background").add()),xt[kt](vt),it||(xt.attr({fill:at||"none"}).shadow(a.plotShadow),lt&&(nt?(lt!==nt.attr("href")&&nt.attr("href",lt),nt.animate(vt)):y.plotBGImage=k.image(lt,ct,ht,ut,ft).add())),gt?gt.animate({width:mt.width,height:mt.height}):y.clipRect=k.clipRect(mt),kt="animate",wt||(kt="attr",y.plotBorder=wt=k.rect().addClass("highcharts-plot-border").attr({zIndex:1}).add()),it||wt.attr({stroke:a.plotBorderColor,"stroke-width":a.plotBorderWidth||0,fill:"none"}),wt[kt](wt.crisp({x:ct,y:ht,width:ut,height:ft},-wt.strokeWidth())),y.isDirtyBox=!1,fireEvent$t(this,"afterDrawChartBox")},z.prototype.propFromSeries=function(){var y=this,a=y.options.chart,k=y.options.series,j,et,it;["inverted","angular","polar"].forEach(function(nt){for(et=seriesTypes$8[a.type||a.defaultSeriesType],it=a[nt]||et&&et.prototype[nt],j=k&&k.length;!it&&j--;)et=seriesTypes$8[k[j].type],et&&et.prototype[nt]&&(it=!0);y[nt]=it})},z.prototype.linkSeries=function(){var y=this,a=y.series;a.forEach(function(k){k.linkedSeries.length=0}),a.forEach(function(k){var j=k.options.linkedTo;isString$6(j)&&(j===":previous"?j=y.series[k.index-1]:j=y.get(j),j&&j.linkedParent!==k&&(j.linkedSeries.push(k),k.linkedParent=j,j.enabledDataSorting&&k.setDataSortingOptions(),k.visible=pick$1q(k.options.visible,j.options.visible,k.visible)))}),fireEvent$t(this,"afterLinkSeries")},z.prototype.renderSeries=function(){this.series.forEach(function(y){y.translate(),y.render()})},z.prototype.renderLabels=function(){var y=this,a=y.options.labels;a.items&&a.items.forEach(function(k){var j=extend$1l(a.style,k.style),et=pInt$4(j.left)+y.plotLeft,it=pInt$4(j.top)+y.plotTop+12;delete j.left,delete j.top,y.renderer.text(k.html,et,it).attr({zIndex:2}).css(j).add()})},z.prototype.render=function(){var y=this,a=y.axes,k=y.colorAxis,j=y.renderer,et=y.options,it=function(ht){ht.forEach(function(ut){ut.visible&&ut.render()})},nt=0;y.setTitle(),y.legend=new Legend(y,et.legend),y.getStacks&&y.getStacks(),y.getMargins(!0),y.setChartSize();var ot=y.plotWidth;a.some(function(ht){if(ht.horiz&&ht.visible&&ht.options.labels.enabled&&ht.series.length)return nt=21,!0}),y.plotHeight=Math.max(y.plotHeight-nt,0);var at=y.plotHeight;a.forEach(function(ht){ht.setScale()}),y.getAxisMargins();var lt=ot/y.plotWidth>1.1,ct=at/y.plotHeight>1.05;(lt||ct)&&(a.forEach(function(ht){(ht.horiz&&lt||!ht.horiz&&ct)&&ht.setTickInterval(!0)}),y.getMargins()),y.drawChartBox(),y.hasCartesianSeries?it(a):k&&k.length&&it(k),y.seriesGroup||(y.seriesGroup=j.g("series-group").attr({zIndex:3}).add()),y.renderSeries(),y.renderLabels(),y.addCredits(),y.setResponsive&&y.setResponsive(),y.hasRendered=!0},z.prototype.addCredits=function(y){var a=this,k=merge$1i(!0,this.options.credits,y);k.enabled&&!this.credits&&(this.credits=this.renderer.text(k.text+(this.mapCredits||""),0,0).addClass("highcharts-credits").on("click",function(){k.href&&(win$8.location.href=k.href)}).attr({align:k.position.align,zIndex:8}),a.styledMode||this.credits.css(k.style),this.credits.add().align(k.position),this.credits.update=function(j){a.credits=a.credits.destroy(),a.addCredits(j)})},z.prototype.destroy=function(){var y=this,a=y.axes,k=y.series,j=y.container,et=j&&j.parentNode,it;for(fireEvent$t(y,"destroy"),y.renderer.forExport?erase$4(charts$1,y):charts$1[y.index]=void 0,H.chartCount--,y.renderTo.removeAttribute("data-highcharts-chart"),removeEvent$6(y),it=a.length;it--;)a[it]=a[it].destroy();for(this.scroller&&this.scroller.destroy&&this.scroller.destroy(),it=k.length;it--;)k[it]=k[it].destroy();["title","subtitle","chartBackground","plotBackground","plotBGImage","plotBorder","seriesGroup","clipRect","credits","pointer","rangeSelector","legend","resetZoomButton","tooltip","renderer"].forEach(function(nt){var ot=y[nt];ot&&ot.destroy&&(y[nt]=ot.destroy())}),j&&(j.innerHTML="",removeEvent$6(j),et&&discardElement$3(j)),objectEach$p(y,function(nt,ot){delete y[ot]})},z.prototype.firstRender=function(){var y=this,a=y.options;y.isReadyToRender&&!y.isReadyToRender()||(y.getContainer(),y.resetMargins(),y.setChartSize(),y.propFromSeries(),y.getAxes(),(isArray$j(a.series)?a.series:[]).forEach(function(k){y.initSeries(k)}),y.linkSeries(),y.setSeriesData(),fireEvent$t(y,"beforeRender"),Pointer&&(MSPointer.isRequired()?y.pointer=new MSPointer(y,a):y.pointer=new Pointer(y,a)),y.render(),y.pointer.getChartPosition(),!y.renderer.imgCount&&!y.hasLoaded&&y.onload(),y.temporaryDisplay(!0))},z.prototype.onload=function(){this.callbacks.concat([this.callback]).forEach(function(y){y&&typeof this.index<"u"&&y.apply(this,[this])},this),fireEvent$t(this,"load"),fireEvent$t(this,"render"),defined$L(this.index)&&this.setReflow(this.options.chart.reflow),this.hasLoaded=!0},z.prototype.addSeries=function(y,a,k){var j=this,et;return y&&(a=pick$1q(a,!0),fireEvent$t(j,"addSeries",{options:y},function(){et=j.initSeries(y),j.isDirtyLegend=!0,j.linkSeries(),et.enabledDataSorting&&et.setData(y.data,!1),fireEvent$t(j,"afterAddSeries",{series:et}),a&&j.redraw(k)})),et},z.prototype.addAxis=function(y,a,k,j){return this.createAxis(a?"xAxis":"yAxis",{axis:y,redraw:k,animation:j})},z.prototype.addColorAxis=function(y,a,k){return this.createAxis("colorAxis",{axis:y,redraw:a,animation:k})},z.prototype.createAxis=function(y,a){var k=new Axis(this,merge$1i(a.axis,{index:this[y].length,isX:y==="xAxis"}));return pick$1q(a.redraw,!0)&&this.redraw(a.animation),k},z.prototype.showLoading=function(y){var a=this,k=a.options,j=k.loading,et=function(){it&&css$5(it,{left:a.plotLeft+"px",top:a.plotTop+"px",width:a.plotWidth+"px",height:a.plotHeight+"px"})},it=a.loadingDiv,nt=a.loadingSpan;it||(a.loadingDiv=it=createElement$5("div",{className:"highcharts-loading highcharts-loading-hidden"},null,a.container)),nt||(a.loadingSpan=nt=createElement$5("span",{className:"highcharts-loading-inner"},null,it),addEvent$_(a,"redraw",et)),it.className="highcharts-loading",AST.setElementHTML(nt,pick$1q(y,k.lang.loading,"")),a.styledMode||(css$5(it,extend$1l(j.style,{zIndex:10})),css$5(nt,j.labelStyle),a.loadingShown||(css$5(it,{opacity:0,display:""}),animate(it,{opacity:j.style.opacity||.5},{duration:j.showDuration||0}))),a.loadingShown=!0,et()},z.prototype.hideLoading=function(){var y=this.options,a=this.loadingDiv;a&&(a.className="highcharts-loading highcharts-loading-hidden",this.styledMode||animate(a,{opacity:0},{duration:y.loading.hideDuration||100,complete:function(){css$5(a,{display:"none"})}})),this.loadingShown=!1},z.prototype.update=function(y,a,k,j){var et=this,it={credits:"addCredits",title:"setTitle",subtitle:"setSubtitle",caption:"setCaption"},nt=y.isResponsiveOptions,ot=[],at,lt,ct;fireEvent$t(et,"update",{options:y}),nt||et.setResponsive(!1,!0),y=cleanRecursively$1(y,et.options),et.userOptions=merge$1i(et.userOptions,y);var ht=y.chart;ht&&(merge$1i(!0,et.options.chart,ht),"className"in ht&&et.setClassName(ht.className),"reflow"in ht&&et.setReflow(ht.reflow),("inverted"in ht||"polar"in ht||"type"in ht)&&(et.propFromSeries(),at=!0),"alignTicks"in ht&&(at=!0),"events"in ht&&registerEventOptions$1(this,ht),objectEach$p(ht,function(vt,gt){et.propsRequireUpdateSeries.indexOf("chart."+gt)!==-1&&(lt=!0),et.propsRequireDirtyBox.indexOf(gt)!==-1&&(et.isDirtyBox=!0),et.propsRequireReflow.indexOf(gt)!==-1&&(nt?et.isDirtyBox=!0:ct=!0)}),!et.styledMode&&ht.style&&et.renderer.setStyle(et.options.chart.style||{})),!et.styledMode&&y.colors&&(this.options.colors=y.colors),y.time&&(this.time===defaultTime&&(this.time=new Time(y.time)),merge$1i(!0,et.options.time,y.time)),objectEach$p(y,function(vt,gt){et[gt]&&typeof et[gt].update=="function"?et[gt].update(vt,!1):typeof et[it[gt]]=="function"?et[it[gt]](vt):gt!=="colors"&&et.collectionsWithUpdate.indexOf(gt)===-1&&merge$1i(!0,et.options[gt],y[gt]),gt!=="chart"&&et.propsRequireUpdateSeries.indexOf(gt)!==-1&&(lt=!0)}),this.collectionsWithUpdate.forEach(function(vt){var gt;y[vt]&&(gt=[],et[vt].forEach(function(mt,bt){mt.options.isInternal||gt.push(pick$1q(mt.options.index,bt))}),splat$f(y[vt]).forEach(function(mt,bt){var xt=defined$L(mt.id),wt;xt&&(wt=et.get(mt.id)),!wt&&et[vt]&&(wt=et[vt][gt?gt[bt]:bt],wt&&xt&&defined$L(wt.options.id)&&(wt=void 0)),wt&&wt.coll===vt&&(wt.update(mt,!1),k&&(wt.touched=!0)),!wt&&k&&et.collectionsWithInit[vt]&&(et.collectionsWithInit[vt][0].apply(et,[mt].concat(et.collectionsWithInit[vt][1]||[]).concat([!1])).touched=!0)}),k&&et[vt].forEach(function(mt){!mt.touched&&!mt.options.isInternal?ot.push(mt):delete mt.touched}))}),ot.forEach(function(vt){vt.chart&&vt.remove&&vt.remove(!1)}),at&&et.axes.forEach(function(vt){vt.update({},!1)}),lt&&et.getSeriesOrderByLinks().forEach(function(vt){vt.chart&&vt.update({},!1)},this);var ut=ht&&ht.width,ft=ht&&(isString$6(ht.height)?relativeLength$7(ht.height,ut||et.chartWidth):ht.height);ct||isNumber$H(ut)&&ut!==et.chartWidth||isNumber$H(ft)&&ft!==et.chartHeight?et.setSize(ut,ft,j):pick$1q(a,!0)&&et.redraw(j),fireEvent$t(et,"afterUpdate",{options:y,redraw:a,animation:j})},z.prototype.setSubtitle=function(y,a){this.applyDescription("subtitle",y),this.layOutTitles(a)},z.prototype.setCaption=function(y,a){this.applyDescription("caption",y),this.layOutTitles(a)},z.prototype.showResetZoom=function(){var y=this,a=defaultOptions$e.lang,k=y.options.chart.resetZoomButton,j=k.theme,et=j.states,it=k.relativeTo==="chart"||k.relativeTo==="spacingBox"?null:"scrollablePlotBox";function nt(){y.zoomOut()}fireEvent$t(this,"beforeShowResetZoom",null,function(){y.resetZoomButton=y.renderer.button(a.resetZoom,null,null,nt,j,et&&et.hover).attr({align:k.position.align,title:a.resetZoomTitle}).addClass("highcharts-reset-zoom").add().align(k.position,!1,it)}),fireEvent$t(this,"afterShowResetZoom")},z.prototype.zoomOut=function(){fireEvent$t(this,"selection",{resetSelection:!0},this.zoom)},z.prototype.zoom=function(y){var a=this,k=a.pointer,j=a.inverted?k.mouseDownX:k.mouseDownY,et=!1,it;!y||y.resetSelection?(a.axes.forEach(function(ot){it=ot.zoom()}),k.initiated=!1):y.xAxis.concat(y.yAxis).forEach(function(ot){var at=ot.axis,lt=a.inverted?at.left:at.top,ct=a.inverted?lt+at.width:lt+at.height,ht=at.isXAxis,ut=!1;(!ht&&j>=lt&&j<=ct||ht||!defined$L(j))&&(ut=!0),k[ht?"zoomX":"zoomY"]&&ut&&(it=at.zoom(ot.min,ot.max),at.displayBtn&&(et=!0))});var nt=a.resetZoomButton;et&&!nt?a.showResetZoom():!et&&isObject$c(nt)&&(a.resetZoomButton=nt.destroy()),it&&a.redraw(pick$1q(a.options.chart.animation,y&&y.animation,a.pointCount<100))},z.prototype.pan=function(y,a){var k=this,j=k.hoverPoints,et=typeof a=="object"?a:{enabled:a,type:"x"},it=k.options.chart,nt=k.options.mapNavigation&&k.options.mapNavigation.enabled;it&&it.panning&&(it.panning=et);var ot=et.type,at;fireEvent$t(this,"pan",{originalEvent:y},function(){j&&j.forEach(function(ht){ht.setState()});var lt=k.xAxis;ot==="xy"?lt=lt.concat(k.yAxis):ot==="y"&&(lt=k.yAxis);var ct={};lt.forEach(function(ht){if(!(!ht.options.panningEnabled||ht.options.isInternal)){var ut=ht.horiz,ft=y[ut?"chartX":"chartY"],vt=ut?"mouseDownX":"mouseDownY",gt=k[vt],mt=ht.minPointOffset||0,bt=ht.reversed&&!k.inverted||!ht.reversed&&k.inverted?-1:1,xt=ht.getExtremes(),wt=ht.toValue(gt-ft,!0)+mt*bt,Mt=ht.toValue(gt+ht.len-ft,!0)-(mt*bt||ht.isXAxis&&ht.pointRangePadding||0),Et=Mt<wt,St=ht.hasVerticalPanning(),kt=Et?Mt:wt,Pt=Et?wt:Mt,It=ht.panningState,Nt;St&&!ht.isXAxis&&(!It||It.isDirty)&&ht.series.forEach(function(Ft){var Dt=Ft.getProcessedData(!0),Ht=Ft.getExtremes(Dt.yData,!0);It||(It={startMin:Number.MAX_VALUE,startMax:-Number.MAX_VALUE}),isNumber$H(Ht.dataMin)&&isNumber$H(Ht.dataMax)&&(It.startMin=Math.min(pick$1q(Ft.options.threshold,1/0),Ht.dataMin,It.startMin),It.startMax=Math.max(pick$1q(Ft.options.threshold,-1/0),Ht.dataMax,It.startMax))});var Ut=Math.min(pick$1q(It&&It.startMin,xt.dataMin),mt?xt.min:ht.toValue(ht.toPixels(xt.min)-ht.minPixelPadding)),Rt=Math.max(pick$1q(It&&It.startMax,xt.dataMax),mt?xt.max:ht.toValue(ht.toPixels(xt.max)+ht.minPixelPadding));ht.panningState=It,ht.isOrdinal||(Nt=Ut-kt,Nt>0&&(Pt+=Nt,kt=Ut),Nt=Pt-Rt,Nt>0&&(Pt=Rt,kt-=Nt),ht.series.length&&kt!==xt.min&&Pt!==xt.max&&kt>=Ut&&Pt<=Rt&&(ht.setExtremes(kt,Pt,!1,!1,{trigger:"pan"}),!k.resetZoomButton&&!nt&&kt!==Ut&&Pt!==Rt&&ot.match("y")&&(k.showResetZoom(),ht.displayBtn=!1),at=!0),ct[vt]=ft)}}),objectEach$p(ct,function(ht,ut){k[ut]=ht}),at&&k.redraw(!1),css$5(k.container,{cursor:"move"})})},z})();extend$1l(Chart$1.prototype,{callbacks:[],collectionsWithInit:{xAxis:[Chart$1.prototype.addAxis,[!0]],yAxis:[Chart$1.prototype.addAxis,[!1]],series:[Chart$1.prototype.addSeries]},collectionsWithUpdate:["xAxis","yAxis","series"],propsRequireDirtyBox:["backgroundColor","borderColor","borderWidth","borderRadius","plotBackgroundColor","plotBackgroundImage","plotBorderColor","plotBorderWidth","plotShadow","shadow"],propsRequireReflow:["margin","marginTop","marginRight","marginBottom","marginLeft","spacing","spacingTop","spacingRight","spacingBottom","spacingLeft"],propsRequireUpdateSeries:["chart.inverted","chart.polar","chart.ignoreHiddenSeries","chart.type","colors","plotOptions","time","tooltip"]});var merge$1h=Utilities.merge,pick$1p=Utilities.pick,LegendSymbol;(function(z){function y(k){var j=this.options,et=k.symbolWidth,it=k.symbolHeight,nt=it/2,ot=this.chart.renderer,at=this.legendGroup,lt=k.baseline-Math.round(k.fontMetrics.b*.3),ct={},ht,ut=j.marker;if(this.chart.styledMode||(ct={"stroke-width":j.lineWidth||0},j.dashStyle&&(ct.dashstyle=j.dashStyle)),this.legendLine=ot.path([["M",0,lt],["L",et,lt]]).addClass("highcharts-graph").attr(ct).add(at),ut&&ut.enabled!==!1&&et){var ft=Math.min(pick$1p(ut.radius,nt),nt);this.symbol.indexOf("url")===0&&(ut=merge$1h(ut,{width:it,height:it}),ft=0),this.legendSymbol=ht=ot.symbol(this.symbol,et/2-ft,lt-ft,2*ft,2*ft,ut).addClass("highcharts-point").add(at),ht.isMarker=!0}}z.drawLineMarker=y;function a(k,j){var et=k.options,it=k.symbolHeight,nt=et.squareSymbol,ot=nt?it:k.symbolWidth;j.legendSymbol=this.chart.renderer.rect(nt?(k.symbolWidth-it)/2:0,k.baseline-it+1,ot,it,pick$1p(k.options.symbolRadius,it/2)).addClass("highcharts-point").attr({zIndex:3}).add(j.legendGroup)}z.drawRectangle=a})(LegendSymbol||(LegendSymbol={}));const LegendSymbol$1=LegendSymbol;var seriesDefaults={lineWidth:2,allowPointSelect:!1,crisp:!0,showCheckbox:!1,animation:{duration:1e3},events:{},marker:{enabledThreshold:2,lineColor:palette.backgroundColor,lineWidth:0,radius:4,states:{normal:{animation:!0},hover:{animation:{duration:50},enabled:!0,radiusPlus:2,lineWidthPlus:1},select:{fillColor:palette.neutralColor20,lineColor:palette.neutralColor100,lineWidth:2}}},point:{events:{}},dataLabels:{animation:{},align:"center",defer:!0,formatter:function(){var z=this.series.chart.numberFormatter;return typeof this.y!="number"?"":z(this.y,-1)},padding:5,style:{fontSize:"11px",fontWeight:"bold",color:"contrast",textOutline:"1px contrast"},verticalAlign:"bottom",x:0,y:0},cropThreshold:300,opacity:1,pointRange:0,softThreshold:!0,states:{normal:{animation:!0},hover:{animation:{duration:50},lineWidthPlus:1,marker:{},halo:{size:10,opacity:.25}},select:{animation:{duration:0}},inactive:{animation:{duration:50},opacity:.2}},stickyTracking:!0,turboThreshold:1e3,findNearestPointBy:"x"},animObject$7=animationExports.animObject,setAnimation$2=animationExports.setAnimation,defaultOptions$d=DefaultOptions.defaultOptions,registerEventOptions=exports$5.registerEventOptions,hasTouch$2=H.hasTouch,svg$4=H.svg,win$7=H.win,seriesTypes$7=SeriesRegistry$1.seriesTypes,addEvent$Z=Utilities.addEvent,arrayMax$7=Utilities.arrayMax,arrayMin$6=Utilities.arrayMin,clamp$g=Utilities.clamp,cleanRecursively=Utilities.cleanRecursively,correctFloat$a=Utilities.correctFloat,defined$K=Utilities.defined,erase$3=Utilities.erase,error$6=Utilities.error,extend$1k=Utilities.extend,find$h=Utilities.find,fireEvent$s=Utilities.fireEvent,getNestedProperty=Utilities.getNestedProperty,isArray$i=Utilities.isArray,isNumber$G=Utilities.isNumber,isString$5=Utilities.isString,merge$1g=Utilities.merge,objectEach$o=Utilities.objectEach,pick$1o=Utilities.pick,removeEvent$5=Utilities.removeEvent,splat$e=Utilities.splat,syncTimeout$2=Utilities.syncTimeout,Series$f=(function(){function z(){this._i=void 0,this.chart=void 0,this.data=void 0,this.eventOptions=void 0,this.eventsToUnbind=void 0,this.index=void 0,this.linkedSeries=void 0,this.options=void 0,this.points=void 0,this.processedXData=void 0,this.processedYData=void 0,this.tooltipOptions=void 0,this.userOptions=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zones=void 0}return z.prototype.init=function(y,a){fireEvent$s(this,"init",{options:a});var k=this,j=y.series;this.eventsToUnbind=[],k.chart=y,k.options=k.setOptions(a);var et=k.options;k.linkedSeries=[],k.bindAxes(),extend$1k(k,{name:et.name,state:"",visible:et.visible!==!1,selected:et.selected===!0}),registerEventOptions(this,et);var it=et.events;(it&&it.click||et.point&&et.point.events&&et.point.events.click||et.allowPointSelect)&&(y.runTrackerClick=!0),k.getColor(),k.getSymbol(),k.parallelArrays.forEach(function(ot){k[ot+"Data"]||(k[ot+"Data"]=[])}),k.isCartesian&&(y.hasCartesianSeries=!0);var nt;j.length&&(nt=j[j.length-1]),k._i=pick$1o(nt&&nt._i,-1)+1,k.opacity=k.options.opacity,y.orderSeries(this.insert(j)),et.dataSorting&&et.dataSorting.enabled?k.setDataSortingOptions():!k.points&&!k.data&&k.setData(et.data,!1),fireEvent$s(this,"afterInit")},z.prototype.is=function(y){return seriesTypes$7[y]&&this instanceof seriesTypes$7[y]},z.prototype.insert=function(y){var a=this.options.index,k;if(isNumber$G(a)){for(k=y.length;k--;)if(a>=pick$1o(y[k].options.index,y[k]._i)){y.splice(k+1,0,this);break}k===-1&&y.unshift(this),k=k+1}else y.push(this);return pick$1o(k,y.length-1)},z.prototype.bindAxes=function(){var y=this,a=y.options,k=y.chart,j;fireEvent$s(this,"bindAxes",null,function(){(y.axisTypes||[]).forEach(function(et){var it=0;k[et].forEach(function(nt){j=nt.options,(a[et]===it&&!j.isInternal||typeof a[et]<"u"&&a[et]===j.id||typeof a[et]>"u"&&j.index===0)&&(y.insert(nt.series),y[et]=nt,nt.isDirty=!0),j.isInternal||it++}),!y[et]&&y.optionalAxis!==et&&error$6(18,!0,k)})}),fireEvent$s(this,"afterBindAxes")},z.prototype.updateParallelArrays=function(y,a){var k=y.series,j=arguments,et=isNumber$G(a)?function(it){var nt=it==="y"&&k.toYData?k.toYData(y):y[it];k[it+"Data"][a]=nt}:function(it){Array.prototype[a].apply(k[it+"Data"],Array.prototype.slice.call(j,2))};k.parallelArrays.forEach(et)},z.prototype.hasData=function(){return this.visible&&typeof this.dataMax<"u"&&typeof this.dataMin<"u"||this.visible&&this.yData&&this.yData.length>0},z.prototype.autoIncrement=function(y){var a=this.options,k=a.pointIntervalUnit,j=a.relativeXValue,et=this.chart.time,it=this.xIncrement,nt,ot;return it=pick$1o(it,a.pointStart,0),this.pointInterval=ot=pick$1o(this.pointInterval,a.pointInterval,1),j&&isNumber$G(y)&&(ot*=y),k&&(nt=new et.Date(it),k==="day"?et.set("Date",nt,et.get("Date",nt)+ot):k==="month"?et.set("Month",nt,et.get("Month",nt)+ot):k==="year"&&et.set("FullYear",nt,et.get("FullYear",nt)+ot),ot=nt.getTime()-it),j&&isNumber$G(y)?it+ot:(this.xIncrement=it+ot,it)},z.prototype.setDataSortingOptions=function(){var y=this.options;extend$1k(this,{requireSorting:!1,sorted:!1,enabledDataSorting:!0,allowDG:!1}),defined$K(y.pointRange)||(y.pointRange=1)},z.prototype.setOptions=function(y){var a=this.chart,k=a.options,j=k.plotOptions,et=a.userOptions||{},it=merge$1g(y),nt=a.styledMode,ot={plotOptions:j,userOptions:it},at;fireEvent$s(this,"setOptions",ot);var lt=ot.plotOptions[this.type],ct=et.plotOptions||{};this.userOptions=ot.userOptions;var ht=merge$1g(lt,j.series,et.plotOptions&&et.plotOptions[this.type],it);this.tooltipOptions=merge$1g(defaultOptions$d.tooltip,defaultOptions$d.plotOptions.series&&defaultOptions$d.plotOptions.series.tooltip,defaultOptions$d.plotOptions[this.type].tooltip,k.tooltip.userOptions,j.series&&j.series.tooltip,j[this.type].tooltip,it.tooltip),this.stickyTracking=pick$1o(it.stickyTracking,ct[this.type]&&ct[this.type].stickyTracking,ct.series&&ct.series.stickyTracking,this.tooltipOptions.shared&&!this.noSharedTooltip?!0:ht.stickyTracking),lt.marker===null&&delete ht.marker,this.zoneAxis=ht.zoneAxis;var ut=this.zones=(ht.zones||[]).slice();return(ht.negativeColor||ht.negativeFillColor)&&!ht.zones&&(at={value:ht[this.zoneAxis+"Threshold"]||ht.threshold||0,className:"highcharts-negative"},nt||(at.color=ht.negativeColor,at.fillColor=ht.negativeFillColor),ut.push(at)),ut.length&&defined$K(ut[ut.length-1].value)&&ut.push(nt?{}:{color:this.color,fillColor:this.fillColor}),fireEvent$s(this,"afterSetOptions",{options:ht}),ht},z.prototype.getName=function(){return pick$1o(this.options.name,"Series "+(this.index+1))},z.prototype.getCyclic=function(y,a,k){var j=this.chart,et=this.userOptions,it=y+"Index",nt=y+"Counter",ot=k?k.length:pick$1o(j.options.chart[y+"Count"],j[y+"Count"]),at,lt;a||(lt=pick$1o(et[it],et["_"+it]),defined$K(lt)?at=lt:(j.series.length||(j[nt]=0),et["_"+it]=at=j[nt]%ot,j[nt]+=1),k&&(a=k[at])),typeof at<"u"&&(this[it]=at),this[y]=a},z.prototype.getColor=function(){this.chart.styledMode?this.getCyclic("color"):this.options.colorByPoint?this.color=palette.neutralColor20:this.getCyclic("color",this.options.color||defaultOptions$d.plotOptions[this.type].color,this.chart.options.colors)},z.prototype.getPointsCollection=function(){return(this.hasGroupedData?this.points:this.data)||[]},z.prototype.getSymbol=function(){var y=this.options.marker;this.getCyclic("symbol",y.symbol,this.chart.options.symbols)},z.prototype.findPointIndex=function(y,a){var k=y.id,j=y.x,et=this.points,it=this.options.dataSorting,nt,ot,at;if(k){var lt=this.chart.get(k);lt instanceof Point$4&&(nt=lt)}else if(this.linkedParent||this.enabledDataSorting||this.options.relativeXValue){var ct=function(ht){return!ht.touched&&ht.index===y.index};if(it&&it.matchByName?ct=function(ht){return!ht.touched&&ht.name===y.name}:this.options.relativeXValue&&(ct=function(ht){return!ht.touched&&ht.options.x===y.x}),nt=find$h(et,ct),!nt)return}return nt&&(at=nt&&nt.index,typeof at<"u"&&(ot=!0)),typeof at>"u"&&isNumber$G(j)&&(at=this.xData.indexOf(j,a)),at!==-1&&typeof at<"u"&&this.cropped&&(at=at>=this.cropStart?at-this.cropStart:at),!ot&&isNumber$G(at)&&et[at]&&et[at].touched&&(at=void 0),at},z.prototype.updateData=function(y,a){var k=this.options,j=k.dataSorting,et=this.points,it=[],nt=this.requireSorting,ot=y.length===et.length,at,lt,ct,ht,ut=!0;if(this.xIncrement=null,y.forEach(function(ft,vt){var gt=defined$K(ft)&&this.pointClass.prototype.optionsToObject.call({series:this},ft)||{},mt,bt=gt.x,xt=gt.id;xt||isNumber$G(bt)?(mt=this.findPointIndex(gt,ht),mt===-1||typeof mt>"u"?it.push(ft):et[mt]&&ft!==k.data[mt]?(et[mt].update(ft,!1,null,!1),et[mt].touched=!0,nt&&(ht=mt+1)):et[mt]&&(et[mt].touched=!0),(!ot||vt!==mt||j&&j.enabled||this.hasDerivedData)&&(at=!0)):it.push(ft)},this),at)for(lt=et.length;lt--;)ct=et[lt],ct&&!ct.touched&&ct.remove&&ct.remove(!1,a);else ot&&(!j||!j.enabled)?(y.forEach(function(ft,vt){ft!==et[vt].y&&et[vt].update&&et[vt].update(ft,!1,null,!1)}),it.length=0):ut=!1;return et.forEach(function(ft){ft&&(ft.touched=!1)}),ut?(it.forEach(function(ft){this.addPoint(ft,!1,null,null,!1)},this),this.xIncrement===null&&this.xData&&this.xData.length&&(this.xIncrement=arrayMax$7(this.xData),this.autoIncrement()),!0):!1},z.prototype.setData=function(y,a,k,j){var et=this,it=et.points,nt=it&&it.length||0,ot=et.options,at=et.chart,lt=ot.dataSorting,ct=et.xAxis,ht=ot.turboThreshold,ut=this.xData,ft=this.yData,vt=et.pointArrayMap,gt=vt&&vt.length,mt=ot.keys,bt,xt,wt,Mt=0,Et=1,St=null;y=y||[];var kt=y.length;if(a=pick$1o(a,!0),lt&&lt.enabled&&(y=this.sortData(y)),j!==!1&&kt&&nt&&!et.cropped&&!et.hasGroupedData&&et.visible&&!et.isSeriesBoosting&&(wt=this.updateData(y,k)),!wt){if(et.xIncrement=null,et.colorCounter=0,this.parallelArrays.forEach(function(Pt){et[Pt+"Data"].length=0}),ht&&kt>ht)if(St=et.getFirstValidPoint(y),isNumber$G(St))for(bt=0;bt<kt;bt++)ut[bt]=this.autoIncrement(),ft[bt]=y[bt];else if(isArray$i(St))if(gt)for(bt=0;bt<kt;bt++)xt=y[bt],ut[bt]=xt[0],ft[bt]=xt.slice(1,gt+1);else for(mt&&(Mt=mt.indexOf("x"),Et=mt.indexOf("y"),Mt=Mt>=0?Mt:0,Et=Et>=0?Et:1),bt=0;bt<kt;bt++)xt=y[bt],ut[bt]=xt[Mt],ft[bt]=xt[Et];else error$6(12,!1,at);else for(bt=0;bt<kt;bt++)typeof y[bt]<"u"&&(xt={series:et},et.pointClass.prototype.applyOptions.apply(xt,[y[bt]]),et.updateParallelArrays(xt,bt));for(ft&&isString$5(ft[0])&&error$6(14,!0,at),et.data=[],et.options.data=et.userOptions.data=y,bt=nt;bt--;)it[bt]&&it[bt].destroy&&it[bt].destroy();ct&&(ct.minRange=ct.userMinRange),et.isDirty=at.isDirtyBox=!0,et.isDirtyData=!!it,k=!1}ot.legendType==="point"&&(this.processData(),this.generatePoints()),a&&at.redraw(k)},z.prototype.sortData=function(y){var a=this,k=a.options,j=k.dataSorting,et=j.sortKey||"y",it=function(ot,at){return defined$K(at)&&ot.pointClass.prototype.optionsToObject.call({series:ot},at)||{}};y.forEach(function(ot,at){y[at]=it(a,ot),y[at].index=at},this);var nt=y.concat().sort(function(ot,at){var lt=getNestedProperty(et,ot),ct=getNestedProperty(et,at);return ct<lt?-1:ct>lt?1:0});return nt.forEach(function(ot,at){ot.x=at},this),a.linkedSeries&&a.linkedSeries.forEach(function(ot){var at=ot.options,lt=at.data;(!at.dataSorting||!at.dataSorting.enabled)&&lt&&(lt.forEach(function(ct,ht){lt[ht]=it(ot,ct),y[ht]&&(lt[ht].x=y[ht].x,lt[ht].index=ht)}),ot.setData(lt,!1))}),y},z.prototype.getProcessedData=function(y){var a=this,k=a.xAxis,j=a.options,et=j.cropThreshold,it=y||a.getExtremesFromAll||j.getExtremesFromAll,nt=a.isCartesian,ot=k&&k.val2lin,at=!!(k&&k.logarithmic),lt,ct,ht=0,ut,ft,vt,gt,mt,bt,xt=a.xData,wt=a.yData,Mt=a.requireSorting,Et=!1,St=xt.length;for(k&&(gt=k.getExtremes(),mt=gt.min,bt=gt.max,Et=k.categories&&!k.names.length),nt&&a.sorted&&!it&&(!et||St>et||a.forceCrop)&&(xt[St-1]<mt||xt[0]>bt?(xt=[],wt=[]):a.yData&&(xt[0]<mt||xt[St-1]>bt)&&(lt=this.cropData(a.xData,a.yData,mt,bt),xt=lt.xData,wt=lt.yData,ht=lt.start,ct=!0)),vt=xt.length||1;--vt;)ut=at?ot(xt[vt])-ot(xt[vt-1]):xt[vt]-xt[vt-1],ut>0&&(typeof ft>"u"||ut<ft)?ft=ut:ut<0&&Mt&&!Et&&(error$6(15,!1,a.chart),Mt=!1);return{xData:xt,yData:wt,cropped:ct,cropStart:ht,closestPointRange:ft}},z.prototype.processData=function(y){var a=this,k=a.xAxis;if(a.isCartesian&&!a.isDirty&&!k.isDirty&&!a.yAxis.isDirty&&!y)return!1;var j=a.getProcessedData();a.cropped=j.cropped,a.cropStart=j.cropStart,a.processedXData=j.xData,a.processedYData=j.yData,a.closestPointRange=a.basePointRange=j.closestPointRange},z.prototype.cropData=function(y,a,k,j,et){var it=y.length,nt,ot,at=0,lt=it;for(et=pick$1o(et,this.cropShoulder),nt=0;nt<it;nt++)if(y[nt]>=k){at=Math.max(0,nt-et);break}for(ot=nt;ot<it;ot++)if(y[ot]>j){lt=ot+et;break}return{xData:y.slice(at,lt),yData:a.slice(at,lt),start:at,end:lt}},z.prototype.generatePoints=function(){var y=this,a=y.options,k=a.data,j=y.processedXData,et=y.processedYData,it=y.pointClass,nt=j.length,ot=y.cropStart||0,at=y.hasGroupedData,lt=a.keys,ct=[],ht=a.dataGrouping&&a.dataGrouping.groupAll?ot:0,ut,ft,vt,gt,mt=y.data;if(!mt&&!at){var bt=[];bt.length=k.length,mt=y.data=bt}for(lt&&at&&(y.options.keys=!1),gt=0;gt<nt;gt++)ft=ot+gt,at?(vt=new it().init(y,[j[gt]].concat(splat$e(et[gt]))),vt.dataGroup=y.groupMap[ht+gt],vt.dataGroup.options&&(vt.options=vt.dataGroup.options,extend$1k(vt,vt.dataGroup.options),delete vt.dataLabels)):(vt=mt[ft],!vt&&typeof k[ft]<"u"&&(mt[ft]=vt=new it().init(y,k[ft],j[gt]))),vt&&(vt.index=at?ht+gt:ft,ct[gt]=vt);if(y.options.keys=lt,mt&&(nt!==(ut=mt.length)||at))for(gt=0;gt<ut;gt++)gt===ot&&!at&&(gt+=nt),mt[gt]&&(mt[gt].destroyElements(),mt[gt].plotX=void 0);y.data=mt,y.points=ct,fireEvent$s(this,"afterGeneratePoints")},z.prototype.getXExtremes=function(y){return{min:arrayMin$6(y),max:arrayMax$7(y)}},z.prototype.getExtremes=function(y,a){var k=this.xAxis,j=this.yAxis,et=this.processedXData||this.xData,it=[],nt=this.requireSorting?this.cropShoulder:0,ot=j?j.positiveValuesOnly:!1,at,lt,ct,ht,ut,ft,vt,gt=0,mt=0,bt=0;y=y||this.stackedYData||this.processedYData||[];var xt=y.length;for(k&&(at=k.getExtremes(),gt=at.min,mt=at.max),ft=0;ft<xt;ft++)if(ht=et[ft],ut=y[ft],lt=(isNumber$G(ut)||isArray$i(ut))&&(ut.length||ut>0||!ot),ct=a||this.getExtremesFromAll||this.options.getExtremesFromAll||this.cropped||!k||(et[ft+nt]||ht)>=gt&&(et[ft-nt]||ht)<=mt,lt&&ct)if(vt=ut.length,vt)for(;vt--;)isNumber$G(ut[vt])&&(it[bt++]=ut[vt]);else it[bt++]=ut;var wt={dataMin:arrayMin$6(it),dataMax:arrayMax$7(it)};return fireEvent$s(this,"afterGetExtremes",{dataExtremes:wt}),wt},z.prototype.applyExtremes=function(){var y=this.getExtremes();return this.dataMin=y.dataMin,this.dataMax=y.dataMax,y},z.prototype.getFirstValidPoint=function(y){for(var a=y.length,k=0,j=null;j===null&&k<a;)j=y[k],k++;return j},z.prototype.translate=function(){this.processedXData||this.processData(),this.generatePoints();var y=this,a=y.options,k=a.stacking,j=y.xAxis,et=j.categories,it=y.enabledDataSorting,nt=y.yAxis,ot=y.points,at=ot.length,lt=!!y.modifyValue,ct=y.pointPlacementToXValue(),ht=!!ct,ut=a.threshold,ft=a.startFromThreshold?ut:0,vt=this.zoneAxis||"y",gt,mt,bt,xt,wt=Number.MAX_VALUE;function Mt(Ft){return clamp$g(Ft,-1e5,1e5)}for(gt=0;gt<at;gt++){var Et=ot[gt],St=Et.x,kt=void 0,Pt=void 0,It=Et.y,Nt=Et.low,Ut=k&&nt.stacking&&nt.stacking.stacks[(y.negStacks&&It<(ft?0:ut)?"-":"")+y.stackKey];if((nt.positiveValuesOnly&&!nt.validatePositiveValue(It)||j.positiveValuesOnly&&!j.validatePositiveValue(St))&&(Et.isNull=!0),Et.plotX=mt=correctFloat$a(Mt(j.translate(St,0,0,0,1,ct,this.type==="flags"))),k&&y.visible&&Ut&&Ut[St]&&(xt=y.getStackIndicator(xt,St,y.index),Et.isNull||(kt=Ut[St],Pt=kt.points[xt.key])),isArray$i(Pt)&&(Nt=Pt[0],It=Pt[1],Nt===ft&&xt.key===Ut[St].base&&(Nt=pick$1o(isNumber$G(ut)&&ut,nt.min)),nt.positiveValuesOnly&&Nt<=0&&(Nt=null),Et.total=Et.stackTotal=kt.total,Et.percentage=kt.total&&Et.y/kt.total*100,Et.stackY=It,y.irregularWidths||kt.setOffset(y.pointXOffset||0,y.barW||0)),Et.yBottom=defined$K(Nt)?Mt(nt.translate(Nt,0,1,0,1)):null,lt&&(It=y.modifyValue(It,Et)),Et.plotY=void 0,isNumber$G(It)){var Rt=nt.translate(It,!1,!0,!1,!0);typeof Rt<"u"&&(Et.plotY=Mt(Rt))}Et.isInside=this.isPointInside(Et),Et.clientX=ht?correctFloat$a(j.translate(St,0,0,0,1,ct)):mt,Et.negative=Et[vt]<(a[vt+"Threshold"]||ut||0),Et.category=et&&typeof et[Et.x]<"u"?et[Et.x]:Et.x,!Et.isNull&&Et.visible!==!1&&(typeof bt<"u"&&(wt=Math.min(wt,Math.abs(mt-bt))),bt=mt),Et.zone=this.zones.length&&Et.getZone(),!Et.graphic&&y.group&&it&&(Et.isNew=!0)}y.closestPointRangePx=wt,fireEvent$s(this,"afterTranslate")},z.prototype.getValidPoints=function(y,a,k){var j=this.chart;return(y||this.points||[]).filter(function(et){return a&&!j.isInsidePlot(et.plotX,et.plotY,{inverted:j.inverted})?!1:et.visible!==!1&&(k||!et.isNull)})},z.prototype.getClipBox=function(y,a){var k=this,j=k.options,et=k.chart,it=et.inverted,nt=k.xAxis,ot=nt&&k.yAxis,at=et.options.chart.scrollablePlotArea||{},lt;return y&&j.clip===!1&&ot?lt=it?{y:-et.chartWidth+ot.len+ot.pos,height:et.chartWidth,width:et.chartHeight,x:-et.chartHeight+nt.len+nt.pos}:{y:-ot.pos,height:et.chartHeight,width:et.chartWidth,x:-nt.pos}:(lt=k.clipBox||et.clipBox,a&&(lt.width=et.plotSizeX,lt.x=(et.scrollablePixelsX||0)*(at.scrollPositionX||0))),a?{width:lt.width,x:lt.x}:lt},z.prototype.getSharedClipKey=function(y){if(this.sharedClipKey)return this.sharedClipKey;var a=[y&&y.duration,y&&y.easing,y&&y.defer,this.getClipBox(y).height,this.options.xAxis,this.options.yAxis].join(",");return(this.options.clip!==!1||y)&&(this.sharedClipKey=a),a},z.prototype.setClip=function(y){var a=this.chart,k=this.options,j=a.renderer,et=a.inverted,it=this.clipBox,nt=this.getClipBox(y),ot=this.getSharedClipKey(y),at=a.sharedClips[ot],lt=a.sharedClips[ot+"m"];y&&(nt.width=0,et&&(nt.x=a.plotHeight+(k.clip!==!1?0:a.plotTop))),at?a.hasLoaded||at.attr(nt):(y&&(a.sharedClips[ot+"m"]=lt=j.clipRect(et?(a.plotSizeX||0)+99:-99,et?-a.plotLeft:-a.plotTop,99,et?a.chartWidth:a.chartHeight)),a.sharedClips[ot]=at=j.clipRect(nt),at.count={length:0}),y&&(at.count[this.index]||(at.count[this.index]=!0,at.count.length+=1)),(k.clip!==!1||y)&&(this.group.clip(y||it?at:a.clipRect),this.markerGroup.clip(lt)),y||(at.count[this.index]&&(delete at.count[this.index],at.count.length-=1),at.count.length===0&&(it||(a.sharedClips[ot]=at.destroy()),lt&&(a.sharedClips[ot+"m"]=lt.destroy())))},z.prototype.animate=function(y){var a=this,k=a.chart,j=animObject$7(a.options.animation),et=this.sharedClipKey;if(y)a.setClip(j);else if(et){var it=k.sharedClips[et],nt=k.sharedClips[et+"m"],ot=a.getClipBox(j,!0);it&&it.animate(ot,j),nt&&nt.animate({width:ot.width+99,x:ot.x-(k.inverted?0:99)},j)}},z.prototype.afterAnimate=function(){this.setClip(),fireEvent$s(this,"afterAnimate"),this.finishedAnimating=!0},z.prototype.drawPoints=function(){var y=this,a=y.points,k=y.chart,j=y.options,et=j.marker,it=y[y.specialGroup]||y.markerGroup,nt=y.xAxis,ot=pick$1o(et.enabled,!nt||nt.isRadial?!0:null,y.closestPointRangePx>=et.enabledThreshold*et.radius),at,lt,ct,ht,ut,ft,vt;if(et.enabled!==!1||y._hasPointMarkers)for(at=0;at<a.length;at++){lt=a[at],ct=lt.graphic,ht=ct?"animate":"attr",ut=lt.marker||{},ft=!!lt.marker;var gt=(ot&&typeof ut.enabled>"u"||ut.enabled)&&!lt.isNull&&lt.visible!==!1;if(gt){var mt=pick$1o(ut.symbol,y.symbol,"rect");vt=y.markerAttribs(lt,lt.selected&&"select"),y.enabledDataSorting&&(lt.startXPos=nt.reversed?-(vt.width||0):nt.width);var bt=lt.isInside!==!1;ct?ct[bt?"show":"hide"](bt).animate(vt):bt&&((vt.width||0)>0||lt.hasImage)&&(lt.graphic=ct=k.renderer.symbol(mt,vt.x,vt.y,vt.width,vt.height,ft?ut:et).add(it),y.enabledDataSorting&&k.hasRendered&&(ct.attr({x:lt.startXPos}),ht="animate")),ct&&ht==="animate"&&ct[bt?"show":"hide"](bt).animate(vt),ct&&!k.styledMode&&ct[ht](y.pointAttribs(lt,lt.selected&&"select")),ct&&ct.addClass(lt.getClassName(),!0)}else ct&&(lt.graphic=ct.destroy())}},z.prototype.markerAttribs=function(y,a){var k=this.options,j=k.marker,et=y.marker||{},it=et.symbol||j.symbol,nt,ot,at=pick$1o(et.radius,j.radius);a&&(nt=j.states[a],ot=et.states&&et.states[a],at=pick$1o(ot&&ot.radius,nt&&nt.radius,at+(nt&&nt.radiusPlus||0))),y.hasImage=it&&it.indexOf("url")===0,y.hasImage&&(at=0);var lt={x:k.crisp?Math.floor(y.plotX-at):y.plotX-at,y:y.plotY-at};return at&&(lt.width=lt.height=2*at),lt},z.prototype.pointAttribs=function(y,a){var k=this.options.marker,j=y&&y.options,et=j&&j.marker||{},it=j&&j.color,nt=y&&y.color,ot=y&&y.zone&&y.zone.color,at,lt,ct=this.color,ht,ut,ft=pick$1o(et.lineWidth,k.lineWidth),vt=1;return ct=it||ot||nt||ct,ht=et.fillColor||k.fillColor||ct,ut=et.lineColor||k.lineColor||ct,a=a||"normal",a&&(at=k.states[a],lt=et.states&&et.states[a]||{},ft=pick$1o(lt.lineWidth,at.lineWidth,ft+pick$1o(lt.lineWidthPlus,at.lineWidthPlus,0)),ht=lt.fillColor||at.fillColor||ht,ut=lt.lineColor||at.lineColor||ut,vt=pick$1o(lt.opacity,at.opacity,vt)),{stroke:ut,"stroke-width":ft,fill:ht,opacity:vt}},z.prototype.destroy=function(y){var a=this,k=a.chart,j=/AppleWebKit\/533/.test(win$7.navigator.userAgent),et=a.data||[],it,nt,ot,at;for(fireEvent$s(a,"destroy"),this.removeEvents(y),(a.axisTypes||[]).forEach(function(lt){at=a[lt],at&&at.series&&(erase$3(at.series,a),at.isDirty=at.forceRedraw=!0)}),a.legendItem&&a.chart.legend.destroyItem(a),nt=et.length;nt--;)ot=et[nt],ot&&ot.destroy&&ot.destroy();a.clips&&a.clips.forEach(function(lt){return lt.destroy()}),Utilities.clearTimeout(a.animationTimeout),objectEach$o(a,function(lt,ct){lt instanceof SVGElement&&!lt.survive&&(it=j&&ct==="group"?"hide":"destroy",lt[it]())}),k.hoverSeries===a&&(k.hoverSeries=void 0),erase$3(k.series,a),k.orderSeries(),objectEach$o(a,function(lt,ct){(!y||ct!=="hcEvents")&&delete a[ct]})},z.prototype.applyZones=function(){var y=this,a=this.chart,k=a.renderer,j=this.zones,et=this.clips||[],it=this.graph,nt=this.area,ot=Math.max(a.chartWidth,a.chartHeight),at=this[(this.zoneAxis||"y")+"Axis"],lt=a.inverted,ct,ht,ut,ft,vt,gt,mt,bt,xt,wt,Mt,Et=!1;j.length&&(it||nt)&&at&&typeof at.min<"u"?(vt=at.reversed,gt=at.horiz,it&&!this.showLine&&it.hide(),nt&&nt.hide(),ft=at.getExtremes(),j.forEach(function(St,kt){ct=vt?gt?a.plotWidth:0:gt?0:at.toPixels(ft.min)||0,ct=clamp$g(pick$1o(ht,ct),0,ot),ht=clamp$g(Math.round(at.toPixels(pick$1o(St.value,ft.max),!0)||0),0,ot),Et&&(ct=ht=at.toPixels(ft.max)),mt=Math.abs(ct-ht),bt=Math.min(ct,ht),xt=Math.max(ct,ht),at.isXAxis?(ut={x:lt?xt:bt,y:0,width:mt,height:ot},gt||(ut.x=a.plotHeight-ut.x)):(ut={x:0,y:lt?xt:bt,width:ot,height:mt},gt&&(ut.y=a.plotWidth-ut.y)),lt&&k.isVML&&(at.isXAxis?ut={x:0,y:vt?bt:xt,height:ut.width,width:a.chartWidth}:ut={x:ut.y-a.plotLeft-a.spacingBox.x,y:0,width:ut.height,height:a.chartHeight}),et[kt]?et[kt].animate(ut):et[kt]=k.clipRect(ut),wt=y["zone-area-"+kt],Mt=y["zone-graph-"+kt],it&&Mt&&Mt.clip(et[kt]),nt&&wt&&wt.clip(et[kt]),Et=St.value>ft.max,y.resetZones&&ht===0&&(ht=void 0)}),this.clips=et):y.visible&&(it&&it.show(!0),nt&&nt.show(!0))},z.prototype.invertGroups=function(y){var a=this,k=a.chart;function j(){["group","markerGroup"].forEach(function(et){a[et]&&(k.renderer.isVML&&a[et].attr({width:a.yAxis.len,height:a.xAxis.len}),a[et].width=a.yAxis.len,a[et].height=a.xAxis.len,a[et].invert(a.isRadialSeries?!1:y))})}a.xAxis&&(a.eventsToUnbind.push(addEvent$Z(k,"resize",j)),j(),a.invertGroups=j)},z.prototype.plotGroup=function(y,a,k,j,et){var it=this[y],nt=!it,ot={visibility:k,zIndex:j||.1};return typeof this.opacity<"u"&&!this.chart.styledMode&&this.state!=="inactive"&&(ot.opacity=this.opacity),nt&&(this[y]=it=this.chart.renderer.g().add(et)),it.addClass("highcharts-"+a+" highcharts-series-"+this.index+" highcharts-"+this.type+"-series "+(defined$K(this.colorIndex)?"highcharts-color-"+this.colorIndex+" ":"")+(this.options.className||"")+(it.hasClass("highcharts-tracker")?" highcharts-tracker":""),!0),it.attr(ot)[nt?"attr":"animate"](this.getPlotBox()),it},z.prototype.getPlotBox=function(){var y=this.chart,a=this.xAxis,k=this.yAxis;return y.inverted&&(a=k,k=this.xAxis),{translateX:a?a.left:y.plotLeft,translateY:k?k.top:y.plotTop,scaleX:1,scaleY:1}},z.prototype.removeEvents=function(y){var a=this;y||removeEvent$5(a),a.eventsToUnbind.length&&(a.eventsToUnbind.forEach(function(k){k()}),a.eventsToUnbind.length=0)},z.prototype.render=function(){var y=this,a=y.chart,k=y.options,j=animObject$7(k.animation),et=y.visible?"inherit":"hidden",it=k.zIndex,nt=y.hasRendered,ot=a.seriesGroup,at=a.inverted,lt=!y.finishedAnimating&&a.renderer.isSVG&&j.duration;fireEvent$s(this,"render");var ct=y.plotGroup("group","series",et,it,ot);y.markerGroup=y.plotGroup("markerGroup","markers",et,it,ot),lt&&y.animate&&y.animate(!0),ct.inverted=pick$1o(y.invertible,y.isCartesian)?at:!1,y.drawGraph&&(y.drawGraph(),y.applyZones()),y.visible&&y.drawPoints(),y.drawDataLabels&&y.drawDataLabels(),y.redrawPoints&&y.redrawPoints(),y.drawTracker&&y.options.enableMouseTracking!==!1&&y.drawTracker(),y.invertGroups(at),k.clip!==!1&&!y.sharedClipKey&&!nt&&ct.clip(a.clipRect),lt&&y.animate&&y.animate(),nt||(lt&&j.defer&&(lt+=j.defer),y.animationTimeout=syncTimeout$2(function(){y.afterAnimate()},lt||0)),y.isDirty=!1,y.hasRendered=!0,fireEvent$s(y,"afterRender")},z.prototype.redraw=function(){var y=this,a=y.chart,k=y.isDirty||y.isDirtyData,j=y.group,et=y.xAxis,it=y.yAxis;j&&(a.inverted&&j.attr({width:a.plotWidth,height:a.plotHeight}),j.animate({translateX:pick$1o(et&&et.left,a.plotLeft),translateY:pick$1o(it&&it.top,a.plotTop)})),y.translate(),y.render(),k&&delete this.kdTree},z.prototype.searchPoint=function(y,a){var k=this,j=k.xAxis,et=k.yAxis,it=k.chart.inverted;return this.searchKDTree({clientX:it?j.len-y.chartY+j.pos:y.chartX-j.pos,plotY:it?et.len-y.chartX+et.pos:y.chartY-et.pos},a,y)},z.prototype.buildKDTree=function(y){this.buildingKdTree=!0;var a=this,k=a.options.findNearestPointBy.indexOf("y")>-1?2:1;function j(it,nt,ot){var at=it&&it.length,lt,ct;if(at)return lt=a.kdAxisArray[nt%ot],it.sort(function(ht,ut){return ht[lt]-ut[lt]}),ct=Math.floor(at/2),{point:it[ct],left:j(it.slice(0,ct),nt+1,ot),right:j(it.slice(ct+1),nt+1,ot)}}function et(){a.kdTree=j(a.getValidPoints(null,!a.directTouch),k,k),a.buildingKdTree=!1}delete a.kdTree,syncTimeout$2(et,a.options.kdNow||y&&y.type==="touchstart"?0:1)},z.prototype.searchKDTree=function(y,a,k){var j=this,et=this.kdAxisArray[0],it=this.kdAxisArray[1],nt=a?"distX":"dist",ot=j.options.findNearestPointBy.indexOf("y")>-1?2:1;function at(ct,ht){var ut=defined$K(ct[et])&&defined$K(ht[et])?Math.pow(ct[et]-ht[et],2):null,ft=defined$K(ct[it])&&defined$K(ht[it])?Math.pow(ct[it]-ht[it],2):null,vt=(ut||0)+(ft||0);ht.dist=defined$K(vt)?Math.sqrt(vt):Number.MAX_VALUE,ht.distX=defined$K(ut)?Math.sqrt(ut):Number.MAX_VALUE}function lt(ct,ht,ut,ft){var vt=ht.point,gt=j.kdAxisArray[ut%ft],mt,bt,xt=vt;at(ct,vt);var wt=ct[gt]-vt[gt],Mt=wt<0?"left":"right",Et=wt<0?"right":"left";return ht[Mt]&&(mt=lt(ct,ht[Mt],ut+1,ft),xt=mt[nt]<xt[nt]?mt:vt),ht[Et]&&Math.sqrt(wt*wt)<xt[nt]&&(bt=lt(ct,ht[Et],ut+1,ft),xt=bt[nt]<xt[nt]?bt:xt),xt}if(!this.kdTree&&!this.buildingKdTree&&this.buildKDTree(k),this.kdTree)return lt(y,this.kdTree,ot,ot)},z.prototype.pointPlacementToXValue=function(){var y=this,a=y.options,k=a.pointPlacement,j=a.pointRange,et=y.xAxis,it=k;return it==="between"&&(it=et.reversed?-.5:.5),isNumber$G(it)?it*(j||et.pointRange):0},z.prototype.isPointInside=function(y){var a=typeof y.plotY<"u"&&typeof y.plotX<"u"&&y.plotY>=0&&y.plotY<=this.yAxis.len&&y.plotX>=0&&y.plotX<=this.xAxis.len;return a},z.prototype.drawTracker=function(){var y=this,a=y.options,k=a.trackByArea,j=[].concat(k?y.areaPath:y.graphPath),et=y.chart,it=et.pointer,nt=et.renderer,ot=et.options.tooltip.snap,at=y.tracker,lt=function(ht){et.hoverSeries!==y&&y.onMouseOver()},ct="rgba(192,192,192,"+(svg$4?1e-4:.002)+")";at?at.attr({d:j}):y.graph&&(y.tracker=nt.path(j).attr({visibility:y.visible?"visible":"hidden",zIndex:2}).addClass(k?"highcharts-tracker-area":"highcharts-tracker-line").add(y.group),et.styledMode||y.tracker.attr({"stroke-linecap":"round","stroke-linejoin":"round",stroke:ct,fill:k?ct:"none","stroke-width":y.graph.strokeWidth()+(k?0:2*ot)}),[y.tracker,y.markerGroup,y.dataLabelsGroup].forEach(function(ht){ht&&(ht.addClass("highcharts-tracker").on("mouseover",lt).on("mouseout",function(ut){it.onTrackerMouseOut(ut)}),a.cursor&&!et.styledMode&&ht.css({cursor:a.cursor}),hasTouch$2&&ht.on("touchstart",lt))})),fireEvent$s(this,"afterDrawTracker")},z.prototype.addPoint=function(y,a,k,j,et){var it=this,nt=it.options,ot=it.data,at=it.chart,lt=it.xAxis,ct=lt&&lt.hasNames&&lt.names,ht=nt.data,ut=it.xData,ft,vt;a=pick$1o(a,!0);var gt={series:it};it.pointClass.prototype.applyOptions.apply(gt,[y]);var mt=gt.x;if(vt=ut.length,it.requireSorting&&mt<ut[vt-1])for(ft=!0;vt&&ut[vt-1]>mt;)vt--;it.updateParallelArrays(gt,"splice",vt,0,0),it.updateParallelArrays(gt,vt),ct&&gt.name&&(ct[mt]=gt.name),ht.splice(vt,0,y),ft&&(it.data.splice(vt,0,null),it.processData()),nt.legendType==="point"&&it.generatePoints(),k&&(ot[0]&&ot[0].remove?ot[0].remove(!1):(ot.shift(),it.updateParallelArrays(gt,"shift"),ht.shift())),et!==!1&&fireEvent$s(it,"addPoint",{point:gt}),it.isDirty=!0,it.isDirtyData=!0,a&&at.redraw(j)},z.prototype.removePoint=function(y,a,k){var j=this,et=j.data,it=et[y],nt=j.points,ot=j.chart,at=function(){nt&&nt.length===et.length&&nt.splice(y,1),et.splice(y,1),j.options.data.splice(y,1),j.updateParallelArrays(it||{series:j},"splice",y,1),it&&it.destroy(),j.isDirty=!0,j.isDirtyData=!0,a&&ot.redraw()};setAnimation$2(k,ot),a=pick$1o(a,!0),it?it.firePointEvent("remove",null,at):at()},z.prototype.remove=function(y,a,k,j){var et=this,it=et.chart;function nt(){et.destroy(j),it.isDirtyLegend=it.isDirtyBox=!0,it.linkSeries(),pick$1o(y,!0)&&it.redraw(a)}k!==!1?fireEvent$s(et,"remove",null,nt):nt()},z.prototype.update=function(y,a){y=cleanRecursively(y,this.userOptions),fireEvent$s(this,"update",{options:y});var k=this,j=k.chart,et=k.userOptions,it=k.initialType||k.type,nt=j.options.plotOptions,ot=seriesTypes$7[it].prototype,at=["group","markerGroup","dataLabelsGroup","transformGroup"],lt=k.finishedAnimating&&{animation:!1},ct={},ht,ut,ft=["eventOptions","navigatorSeries","baseSeries"],vt=y.type||et.type||j.options.chart.type,gt=!(this.hasDerivedData||vt&&vt!==this.type||typeof y.pointStart<"u"||typeof y.pointInterval<"u"||typeof y.relativeXValue<"u"||k.hasOptionChanged("dataGrouping")||k.hasOptionChanged("pointStart")||k.hasOptionChanged("pointInterval")||k.hasOptionChanged("pointIntervalUnit")||k.hasOptionChanged("keys"));vt=vt||it,gt&&(ft.push("data","isDirtyData","points","processedXData","processedYData","xIncrement","cropped","_hasPointMarkers","_hasPointLabels","clips","nodes","layout","mapMap","mapData","minY","maxY","minX","maxX"),y.visible!==!1&&ft.push("area","graph"),k.parallelArrays.forEach(function(Mt){ft.push(Mt+"Data")}),y.data&&(y.dataSorting&&extend$1k(k.options.dataSorting,y.dataSorting),this.setData(y.data,!1))),y=merge$1g(et,lt,{index:typeof et.index>"u"?k.index:et.index,pointStart:pick$1o(nt&&nt.series&&nt.series.pointStart,et.pointStart,k.xData[0])},!gt&&{data:k.options.data},y),gt&&y.data&&(y.data=k.options.data),ft=at.concat(ft),ft.forEach(function(Mt){ft[Mt]=k[Mt],delete k[Mt]});var mt=!1;if(seriesTypes$7[vt]){if(mt=vt!==k.type,k.remove(!1,!1,!1,!0),mt)if(Object.setPrototypeOf)Object.setPrototypeOf(k,seriesTypes$7[vt].prototype);else{var bt=Object.hasOwnProperty.call(k,"hcEvents")&&k.hcEvents;for(ut in ot)k[ut]=void 0;extend$1k(k,seriesTypes$7[vt].prototype),bt?k.hcEvents=bt:delete k.hcEvents}}else error$6(17,!0,j,{missingModuleFor:vt});if(ft.forEach(function(Mt){k[Mt]=ft[Mt]}),k.init(j,y),gt&&this.points){if(ht=k.options,ht.visible===!1)ct.graphic=1,ct.dataLabel=1;else if(!k._hasPointLabels){var xt=ht.marker,wt=ht.dataLabels;xt&&(xt.enabled===!1||(et.marker&&et.marker.symbol)!==xt.symbol)&&(ct.graphic=1),wt&&wt.enabled===!1&&(ct.dataLabel=1)}this.points.forEach(function(Mt){Mt&&Mt.series&&(Mt.resolveColor(),Object.keys(ct).length&&Mt.destroyElements(ct),ht.showInLegend===!1&&Mt.legendItem&&j.legend.destroyItem(Mt))},this)}k.initialType=it,j.linkSeries(),mt&&k.linkedSeries.length&&(k.isDirtyData=!0),fireEvent$s(this,"afterUpdate"),pick$1o(a,!0)&&j.redraw(gt?void 0:!1)},z.prototype.setName=function(y){this.name=this.options.name=this.userOptions.name=y,this.chart.isDirtyLegend=!0},z.prototype.hasOptionChanged=function(y){var a=this.chart,k=this.options[y],j=a.options.plotOptions,et=this.userOptions[y];return et?k!==et:k!==pick$1o(j&&j[this.type]&&j[this.type][y],j&&j.series&&j.series[y],k)},z.prototype.onMouseOver=function(){var y=this,a=y.chart,k=a.hoverSeries,j=a.pointer;j.setHoverChartIndex(),k&&k!==y&&k.onMouseOut(),y.options.events.mouseOver&&fireEvent$s(y,"mouseOver"),y.setState("hover"),a.hoverSeries=y},z.prototype.onMouseOut=function(){var y=this,a=y.options,k=y.chart,j=k.tooltip,et=k.hoverPoint;k.hoverSeries=null,et&&et.onMouseOut(),y&&a.events.mouseOut&&fireEvent$s(y,"mouseOut"),j&&!y.stickyTracking&&(!j.shared||y.noSharedTooltip)&&j.hide(),k.series.forEach(function(it){it.setState("",!0)})},z.prototype.setState=function(y,a){var k=this,j=k.options,et=k.graph,it=j.inactiveOtherPoints,nt=j.states,ot=pick$1o(nt[y||"normal"]&&nt[y||"normal"].animation,k.chart.options.chart.animation),at,lt=j.lineWidth,ct=0,ht=j.opacity;if(y=y||"",k.state!==y&&([k.group,k.markerGroup,k.dataLabelsGroup].forEach(function(ut){ut&&(k.state&&ut.removeClass("highcharts-series-"+k.state),y&&ut.addClass("highcharts-series-"+y))}),k.state=y,!k.chart.styledMode)){if(nt[y]&&nt[y].enabled===!1)return;if(y&&(lt=nt[y].lineWidth||lt+(nt[y].lineWidthPlus||0),ht=pick$1o(nt[y].opacity,ht)),et&&!et.dashstyle)for(at={"stroke-width":lt},et.animate(at,ot);k["zone-graph-"+ct];)k["zone-graph-"+ct].animate(at,ot),ct=ct+1;it||[k.group,k.markerGroup,k.dataLabelsGroup,k.labelBySeries].forEach(function(ut){ut&&ut.animate({opacity:ht},ot)})}a&&it&&k.points&&k.setAllPointsToState(y||void 0)},z.prototype.setAllPointsToState=function(y){this.points.forEach(function(a){a.setState&&a.setState(y)})},z.prototype.setVisible=function(y,a){var k=this,j=k.chart,et=k.legendItem,it=j.options.chart.ignoreHiddenSeries,nt=k.visible;k.visible=y=k.options.visible=k.userOptions.visible=typeof y>"u"?!nt:y;var ot=y?"show":"hide";["group","dataLabelsGroup","markerGroup","tracker","tt"].forEach(function(at){k[at]&&k[at][ot]()}),(j.hoverSeries===k||(j.hoverPoint&&j.hoverPoint.series)===k)&&k.onMouseOut(),et&&j.legend.colorizeItem(k,y),k.isDirty=!0,k.options.stacking&&j.series.forEach(function(at){at.options.stacking&&at.visible&&(at.isDirty=!0)}),k.linkedSeries.forEach(function(at){at.setVisible(y,!1)}),it&&(j.isDirtyBox=!0),fireEvent$s(k,ot),a!==!1&&j.redraw()},z.prototype.show=function(){this.setVisible(!0)},z.prototype.hide=function(){this.setVisible(!1)},z.prototype.select=function(y){var a=this;a.selected=y=this.options.selected=typeof y>"u"?!a.selected:y,a.checkbox&&(a.checkbox.checked=y),fireEvent$s(a,y?"select":"unselect")},z.prototype.shouldShowTooltip=function(y,a,k){return k===void 0&&(k={}),k.series=this,k.visiblePlotOnly=!0,this.chart.isInsidePlot(y,a,k)},z.defaultOptions=seriesDefaults,z})();extend$1k(Series$f.prototype,{axisTypes:["xAxis","yAxis"],coll:"series",colorCounter:0,cropShoulder:1,directTouch:!1,drawLegendSymbol:LegendSymbol$1.drawLineMarker,isCartesian:!0,kdAxisArray:["clientX","plotY"],parallelArrays:["x","y"],pointClass:Point$4,requireSorting:!0,sorted:!0});SeriesRegistry$1.series=Series$f;var stop=animationExports.stop,addEvent$Y=Utilities.addEvent,createElement$4=Utilities.createElement,merge$1f=Utilities.merge,pick$1n=Utilities.pick;addEvent$Y(Chart$1,"afterSetChartSize",function(z){var y=this.options.chart.scrollablePlotArea,a=y&&y.minWidth,k=y&&y.minHeight,j,et,it;this.renderer.forExport||(a?(this.scrollablePixelsX=j=Math.max(0,a-this.chartWidth),j&&(this.scrollablePlotBox=this.renderer.scrollablePlotBox=merge$1f(this.plotBox),this.plotBox.width=this.plotWidth+=j,this.inverted?this.clipBox.height+=j:this.clipBox.width+=j,it={1:{name:"right",value:j}})):k&&(this.scrollablePixelsY=et=Math.max(0,k-this.chartHeight),et&&(this.scrollablePlotBox=this.renderer.scrollablePlotBox=merge$1f(this.plotBox),this.plotBox.height=this.plotHeight+=et,this.inverted?this.clipBox.width+=et:this.clipBox.height+=et,it={2:{name:"bottom",value:et}})),it&&!z.skipAxes&&this.axes.forEach(function(nt){it[nt.side]?nt.getPlotLinePath=function(){var ot=it[nt.side].name,at=it[nt.side].value,lt=this[ot],ct;return this[ot]=lt-at,ct=Axis.prototype.getPlotLinePath.apply(this,arguments),this[ot]=lt,ct}:(nt.setAxisSize(),nt.setAxisTranslation())}))});addEvent$Y(Chart$1,"render",function(){this.scrollablePixelsX||this.scrollablePixelsY?(this.setUpScrolling&&this.setUpScrolling(),this.applyFixed()):this.fixedDiv&&this.applyFixed()});Chart$1.prototype.setUpScrolling=function(){var z=this,y={WebkitOverflowScrolling:"touch",overflowX:"hidden",overflowY:"hidden"};this.scrollablePixelsX&&(y.overflowX="auto"),this.scrollablePixelsY&&(y.overflowY="auto"),this.scrollingParent=createElement$4("div",{className:"highcharts-scrolling-parent"},{position:"relative"},this.renderTo),this.scrollingContainer=createElement$4("div",{className:"highcharts-scrolling"},y,this.scrollingParent),addEvent$Y(this.scrollingContainer,"scroll",function(){z.pointer&&delete z.pointer.chartPosition}),this.innerContainer=createElement$4("div",{className:"highcharts-inner-container"},null,this.scrollingContainer),this.innerContainer.appendChild(this.container),this.setUpScrolling=null};Chart$1.prototype.moveFixedElements=function(){var z=this.container,y=this.fixedRenderer,a=[".highcharts-contextbutton",".highcharts-credits",".highcharts-legend",".highcharts-legend-checkbox",".highcharts-navigator-series",".highcharts-navigator-xaxis",".highcharts-navigator-yaxis",".highcharts-navigator",".highcharts-reset-zoom",".highcharts-drillup-button",".highcharts-scrollbar",".highcharts-subtitle",".highcharts-title"],k;this.scrollablePixelsX&&!this.inverted?k=".highcharts-yaxis":this.scrollablePixelsX&&this.inverted||this.scrollablePixelsY&&!this.inverted?k=".highcharts-xaxis":this.scrollablePixelsY&&this.inverted&&(k=".highcharts-yaxis"),k&&a.push(k+":not(.highcharts-radial-axis)",k+"-labels:not(.highcharts-radial-axis-labels)"),a.forEach(function(j){[].forEach.call(z.querySelectorAll(j),function(et){(et.namespaceURI===y.SVG_NS?y.box:y.box.parentNode).appendChild(et),et.style.pointerEvents="auto"})})};Chart$1.prototype.applyFixed=function(){var z=!this.fixedDiv,y=this.options.chart,a=y.scrollablePlotArea,k=RendererRegistry$1.getRendererType(),j,et,it;z?(this.fixedDiv=createElement$4("div",{className:"highcharts-fixed"},{position:"absolute",overflow:"hidden",pointerEvents:"none",zIndex:(y.style&&y.style.zIndex||0)+2,top:0},null,!0),this.scrollingContainer&&this.scrollingContainer.parentNode.insertBefore(this.fixedDiv,this.scrollingContainer),this.renderTo.style.overflow="visible",this.fixedRenderer=j=new k(this.fixedDiv,this.chartWidth,this.chartHeight,this.options.chart.style),this.scrollableMask=j.path().attr({fill:this.options.chart.backgroundColor||"#fff","fill-opacity":pick$1n(a.opacity,.85),zIndex:-1}).addClass("highcharts-scrollable-mask").add(),addEvent$Y(this,"afterShowResetZoom",this.moveFixedElements),addEvent$Y(this,"afterDrilldown",this.moveFixedElements),addEvent$Y(this,"afterLayOutTitles",this.moveFixedElements)):this.fixedRenderer.setSize(this.chartWidth,this.chartHeight),(this.scrollableDirty||z)&&(this.scrollableDirty=!1,this.moveFixedElements()),et=this.chartWidth+(this.scrollablePixelsX||0),it=this.chartHeight+(this.scrollablePixelsY||0),stop(this.container),this.container.style.width=et+"px",this.container.style.height=it+"px",this.renderer.boxWrapper.attr({width:et,height:it,viewBox:[0,0,et,it].join(" ")}),this.chartBackground.attr({width:et,height:it}),this.scrollingContainer.style.height=this.chartHeight+"px",z&&(a.scrollPositionX&&(this.scrollingContainer.scrollLeft=this.scrollablePixelsX*a.scrollPositionX),a.scrollPositionY&&(this.scrollingContainer.scrollTop=this.scrollablePixelsY*a.scrollPositionY));var nt=this.axisOffset,ot=this.plotTop-nt[0]-1,at=this.plotLeft-nt[3]-1,lt=this.plotTop+this.plotHeight+nt[2]+1,ct=this.plotLeft+this.plotWidth+nt[1]+1,ht=this.plotLeft+this.plotWidth-(this.scrollablePixelsX||0),ut=this.plotTop+this.plotHeight-(this.scrollablePixelsY||0),ft;this.scrollablePixelsX?ft=[["M",0,ot],["L",this.plotLeft-1,ot],["L",this.plotLeft-1,lt],["L",0,lt],["Z"],["M",ht,ot],["L",this.chartWidth,ot],["L",this.chartWidth,lt],["L",ht,lt],["Z"]]:this.scrollablePixelsY?ft=[["M",at,0],["L",at,this.plotTop-1],["L",ct,this.plotTop-1],["L",ct,0],["Z"],["M",at,ut],["L",at,this.chartHeight],["L",ct,this.chartHeight],["L",ct,ut],["Z"]]:ft=[["M",0,0]],this.redrawTrigger!=="adjustHeight"&&this.scrollableMask.attr({d:ft})};addEvent$Y(Axis,"afterInit",function(){this.chart.scrollableDirty=!0});addEvent$Y(Series$f,"show",function(){this.chart.scrollableDirty=!0});var getDeferredAnimation$2=animationExports.getDeferredAnimation,addEvent$X=Utilities.addEvent,destroyObjectProperties$5=Utilities.destroyObjectProperties,fireEvent$r=Utilities.fireEvent,isNumber$F=Utilities.isNumber,objectEach$n=Utilities.objectEach,StackingAxis;(function(z){var y=[];function a(it){return y.indexOf(it)===-1&&(y.push(it),addEvent$X(it,"init",j),addEvent$X(it,"destroy",k)),it}z.compose=a;function k(){var it=this.stacking;if(it){var nt=it.stacks;objectEach$n(nt,function(ot,at){destroyObjectProperties$5(ot),nt[at]=null}),it&&it.stackTotalGroup&&it.stackTotalGroup.destroy()}}function j(){var it=this;it.stacking||(it.stacking=new et(it))}var et=(function(){function it(nt){this.oldStacks={},this.stacks={},this.stacksTouched=0,this.axis=nt}return it.prototype.buildStacks=function(){var nt=this,ot=nt.axis,at=ot.series,lt=ot.options.reversedStacks,ct=at.length,ht,ut;if(!ot.isXAxis){for(nt.usePercentage=!1,ut=ct;ut--;)ht=at[lt?ut:ct-ut-1],ht.setStackedPoints(),ht.setGroupedPoints();for(ut=0;ut<ct;ut++)at[ut].modifyStacks();fireEvent$r(ot,"afterBuildStacks")}},it.prototype.cleanStacks=function(){var nt=this,ot=nt.axis,at;ot.isXAxis||(nt.oldStacks&&(at=nt.stacks=nt.oldStacks),objectEach$n(at,function(lt){objectEach$n(lt,function(ct){ct.cumulative=ct.total})}))},it.prototype.resetStacks=function(){var nt=this,ot=nt.axis,at=nt.stacks;ot.isXAxis||objectEach$n(at,function(lt){objectEach$n(lt,function(ct,ht){isNumber$F(ct.touched)&&ct.touched<nt.stacksTouched?(ct.destroy(),delete lt[ht]):(ct.total=null,ct.cumulative=null)})})},it.prototype.renderStackTotals=function(){var nt=this,ot=nt.axis,at=ot.chart,lt=at.renderer,ct=nt.stacks,ht=ot.options.stackLabels&&ot.options.stackLabels.animation,ut=getDeferredAnimation$2(at,ht||!1),ft=nt.stackTotalGroup=nt.stackTotalGroup||lt.g("stack-labels").attr({visibility:"visible",zIndex:6,opacity:0}).add();ft.translate(at.plotLeft,at.plotTop),objectEach$n(ct,function(vt){objectEach$n(vt,function(gt){gt.render(ft)})}),ft.animate({opacity:1},ut)},it})();z.Additions=et})(StackingAxis||(StackingAxis={}));const StackingAxis$1=StackingAxis;var format$a=FormatUtilities.format,correctFloat$9=Utilities.correctFloat,defined$J=Utilities.defined,destroyObjectProperties$4=Utilities.destroyObjectProperties,isArray$h=Utilities.isArray,isNumber$E=Utilities.isNumber,objectEach$m=Utilities.objectEach,pick$1m=Utilities.pick,StackItem=(function(){function z(y,a,k,j,et){var it=y.chart.inverted;this.axis=y,this.isNegative=k,this.options=a=a||{},this.x=j,this.total=null,this.points={},this.hasValidPoints=!1,this.stack=et,this.leftCliff=0,this.rightCliff=0,this.alignOptions={align:a.align||(it?k?"left":"right":"center"),verticalAlign:a.verticalAlign||(it?"middle":k?"bottom":"top"),y:a.y,x:a.x},this.textAlign=a.textAlign||(it?k?"right":"left":"center")}return z.prototype.destroy=function(){destroyObjectProperties$4(this,this.axis)},z.prototype.render=function(y){var a=this.axis.chart,k=this.options,j=k.format,et={},it=j?format$a(j,this,a):k.formatter.call(this);this.label?this.label.attr({text:it,visibility:"hidden"}):(this.label=a.renderer.label(it,null,null,k.shape,null,null,k.useHTML,!1,"stack-labels"),et={r:k.borderRadius||0,text:it,rotation:k.rotation,padding:pick$1m(k.padding,5),visibility:"hidden"},a.styledMode||(et.fill=k.backgroundColor,et.stroke=k.borderColor,et["stroke-width"]=k.borderWidth,this.label.css(k.style)),this.label.attr(et),this.label.added||this.label.add(y)),this.label.labelrank=a.plotSizeY},z.prototype.setOffset=function(y,a,k,j,et){var it=this,nt=it.axis,ot=nt.chart,at=nt.translate(nt.stacking.usePercentage?100:j||it.total,0,0,0,1),lt=nt.translate(k||0),ct=defined$J(at)&&Math.abs(at-lt),ht=pick$1m(et,ot.xAxis[0].translate(it.x))+y,ut=defined$J(at)&&it.getStackBox(ot,it,ht,at,a,ct,nt),ft=it.label,vt=it.isNegative,gt=pick$1m(it.options.overflow,"justify")==="justify",mt=it.textAlign,bt;if(ft&&ut){var xt=ft.getBBox(),wt=ft.padding,Mt=void 0,Et=void 0;mt==="left"?Mt=ot.inverted?-wt:wt:mt==="right"?Mt=xt.width:ot.inverted&&mt==="center"?Mt=xt.width/2:Mt=ot.inverted?vt?xt.width+wt:-wt:xt.width/2,Et=ot.inverted?xt.height/2:vt?-wt:xt.height,it.alignOptions.x=pick$1m(it.options.x,0),it.alignOptions.y=pick$1m(it.options.y,0),ut.x-=Mt,ut.y-=Et,ft.align(it.alignOptions,null,ut),ot.isInsidePlot(ft.alignAttr.x+Mt-it.alignOptions.x,ft.alignAttr.y+Et-it.alignOptions.y)?ft.show():(ft.alignAttr.y=-9999,gt=!1),gt&&Series$f.prototype.justifyDataLabel.call(this.axis,ft,it.alignOptions,ft.alignAttr,xt,ut),ft.attr({x:ft.alignAttr.x,y:ft.alignAttr.y}),pick$1m(!gt&&it.options.crop,!0)&&(bt=isNumber$E(ft.x)&&isNumber$E(ft.y)&&ot.isInsidePlot(ft.x-wt+ft.width,ft.y)&&ot.isInsidePlot(ft.x+wt,ft.y),bt||ft.hide())}},z.prototype.getStackBox=function(y,a,k,j,et,it,nt){var ot=a.axis.reversed,at=y.inverted,lt=nt.height+nt.pos-(at?y.plotLeft:y.plotTop),ct=a.isNegative&&!ot||!a.isNegative&&ot;return{x:at?ct?j-nt.right:j-it+nt.pos-y.plotLeft:k+y.xAxis[0].transB-y.plotLeft,y:at?nt.height-k-et:ct?lt-j-it:lt-j,width:at?it:et,height:at?et:it}},z})();Chart$1.prototype.getStacks=function(){var z=this,y=z.inverted;z.yAxis.forEach(function(a){a.stacking&&a.stacking.stacks&&a.hasVisibleSeries&&(a.stacking.oldStacks=a.stacking.stacks)}),z.series.forEach(function(a){var k=a.xAxis&&a.xAxis.options||{};a.options.stacking&&(a.visible===!0||z.options.chart.ignoreHiddenSeries===!1)&&(a.stackKey=[a.type,pick$1m(a.options.stack,""),y?k.top:k.left,y?k.height:k.width].join(","))})};StackingAxis$1.compose(Axis);Series$f.prototype.setGroupedPoints=function(){var z=this.yAxis.stacking;this.options.centerInCategory&&(this.is("column")||this.is("columnrange"))&&!this.options.stacking&&this.chart.series.length>1?Series$f.prototype.setStackedPoints.call(this,"group"):z&&objectEach$m(z.stacks,function(y,a){a.slice(-5)==="group"&&(objectEach$m(y,function(k){return k.destroy()}),delete z.stacks[a])})};Series$f.prototype.setStackedPoints=function(z){var y=z||this.options.stacking;if(!(!y||this.visible!==!0&&this.chart.options.chart.ignoreHiddenSeries!==!1)){var a=this,k=a.processedXData,j=a.processedYData,et=[],it=j.length,nt=a.options,ot=nt.threshold,at=pick$1m(nt.startFromThreshold&&ot,0),lt=nt.stack,ct=z?a.type+","+y:a.stackKey,ht="-"+ct,ut=a.negStacks,ft=a.yAxis,vt=ft.stacking.stacks,gt=ft.stacking.oldStacks,mt,bt,xt,wt,Mt,Et,St,kt,Pt;for(ft.stacking.stacksTouched+=1,St=0;St<it;St++)kt=k[St],Pt=j[St],mt=a.getStackIndicator(mt,kt,a.index),Et=mt.key,bt=ut&&Pt<(at?0:ot),Mt=bt?ht:ct,vt[Mt]||(vt[Mt]={}),vt[Mt][kt]||(gt[Mt]&&gt[Mt][kt]?(vt[Mt][kt]=gt[Mt][kt],vt[Mt][kt].total=null):vt[Mt][kt]=new StackItem(ft,ft.options.stackLabels,bt,kt,lt)),xt=vt[Mt][kt],Pt!==null?(xt.points[Et]=xt.points[a.index]=[pick$1m(xt.cumulative,at)],defined$J(xt.cumulative)||(xt.base=Et),xt.touched=ft.stacking.stacksTouched,mt.index>0&&a.singleStacks===!1&&(xt.points[Et][0]=xt.points[a.index+","+kt+",0"][0])):xt.points[Et]=xt.points[a.index]=null,y==="percent"?(wt=bt?ct:ht,ut&&vt[wt]&&vt[wt][kt]?(wt=vt[wt][kt],xt.total=wt.total=Math.max(wt.total,xt.total)+Math.abs(Pt)||0):xt.total=correctFloat$9(xt.total+(Math.abs(Pt)||0))):y==="group"?(isArray$h(Pt)&&(Pt=Pt[0]),Pt!==null&&(xt.total=(xt.total||0)+1)):xt.total=correctFloat$9(xt.total+(Pt||0)),y==="group"?xt.cumulative=(xt.total||1)-1:xt.cumulative=pick$1m(xt.cumulative,at)+(Pt||0),Pt!==null&&(xt.points[Et].push(xt.cumulative),et[St]=xt.cumulative,xt.hasValidPoints=!0);y==="percent"&&(ft.stacking.usePercentage=!0),y!=="group"&&(this.stackedYData=et),ft.stacking.oldStacks={}}};Series$f.prototype.modifyStacks=function(){var z=this,y=z.yAxis,a=z.stackKey,k=y.stacking.stacks,j=z.processedXData,et,it=z.options.stacking;z[it+"Stacker"]&&[a,"-"+a].forEach(function(nt){for(var ot=j.length,at,lt,ct;ot--;)at=j[ot],et=z.getStackIndicator(et,at,z.index,nt),lt=k[nt]&&k[nt][at],ct=lt&&lt.points[et.key],ct&&z[it+"Stacker"](ct,lt,ot)})};Series$f.prototype.percentStacker=function(z,y,a){var k=y.total?100/y.total:0;z[0]=correctFloat$9(z[0]*k),z[1]=correctFloat$9(z[1]*k),this.stackedYData[a]=z[1]};Series$f.prototype.getStackIndicator=function(z,y,a,k){return!defined$J(z)||z.x!==y||k&&z.key!==k?z={x:y,index:0,key:k}:z.index++,z.key=[a,y,z.index].join(","),z};H.StackItem=StackItem;const StackItem$1=H.StackItem;var __extends$2d=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),defined$I=Utilities.defined,merge$1e=Utilities.merge,LineSeries$5=(function(z){__extends$2d(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return y.prototype.drawGraph=function(){var a=this,k=this.options,j=(this.gappedPath||this.getGraphPath).call(this),et=this.chart.styledMode,it=[["graph","highcharts-graph"]];et||it[0].push(k.lineColor||this.color||palette.neutralColor20,k.dashStyle),it=a.getZonesGraphs(it),it.forEach(function(nt,ot){var at=nt[0],lt,ct=a[at],ht=ct?"animate":"attr";ct?(ct.endX=a.preventGraphAnimation?null:j.xMap,ct.animate({d:j})):j.length&&(a[at]=ct=a.chart.renderer.path(j).addClass(nt[1]).attr({zIndex:1}).add(a.group)),ct&&!et&&(lt={stroke:nt[2],"stroke-width":k.lineWidth,fill:a.fillGraph&&a.color||"none"},nt[3]?lt.dashstyle=nt[3]:k.linecap!=="square"&&(lt["stroke-linecap"]=lt["stroke-linejoin"]="round"),ct[ht](lt).shadow(ot<2&&k.shadow)),ct&&(ct.startX=j.xMap,ct.isArea=j.isArea)})},y.prototype.getGraphPath=function(a,k,j){var et=this,it=et.options,nt=[],ot=[],at,lt=it.step;a=a||et.points;var ct=a.reversed;return ct&&a.reverse(),lt={right:1,center:2}[lt]||lt&&3,lt&&ct&&(lt=4-lt),a=this.getValidPoints(a,!1,!(it.connectNulls&&!k&&!j)),a.forEach(function(ht,ut){var ft=ht.plotX,vt=ht.plotY,gt=a[ut-1],mt;(ht.leftCliff||gt&&gt.rightCliff)&&!j&&(at=!0),ht.isNull&&!defined$I(k)&&ut>0?at=!it.connectNulls:ht.isNull&&!k?at=!0:(ut===0||at?mt=[["M",ht.plotX,ht.plotY]]:et.getPointSpline?mt=[et.getPointSpline(a,ht,ut)]:lt?(lt===1?mt=[["L",gt.plotX,vt]]:lt===2?mt=[["L",(gt.plotX+ft)/2,gt.plotY],["L",(gt.plotX+ft)/2,vt]]:mt=[["L",ft,gt.plotY]],mt.push(["L",ft,vt])):mt=[["L",ft,vt]],ot.push(ht.x),lt&&(ot.push(ht.x),lt===2&&ot.push(ht.x)),nt.push.apply(nt,mt),at=!1)}),nt.xMap=ot,et.graphPath=nt,nt},y.prototype.getZonesGraphs=function(a){return this.zones.forEach(function(k,j){var et=["zone-graph-"+j,"highcharts-graph highcharts-zone-graph-"+j+" "+(k.className||"")];this.chart.styledMode||et.push(k.color||this.color,k.dashStyle||this.options.dashStyle),a.push(et)},this),a},y.defaultOptions=merge$1e(Series$f.defaultOptions,{}),y})(Series$f);SeriesRegistry$1.registerSeriesType("line",LineSeries$5);var __extends$2c=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),color$d=Color.parse,LineSeries$4=SeriesRegistry$1.seriesTypes.line,extend$1j=Utilities.extend,merge$1d=Utilities.merge,objectEach$l=Utilities.objectEach,pick$1l=Utilities.pick,AreaSeries$1=(function(z){__extends$2c(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return y.prototype.drawGraph=function(){this.areaPath=[],z.prototype.drawGraph.apply(this);var a=this,k=this.areaPath,j=this.options,et=this.zones,it=[["area","highcharts-area",this.color,j.fillColor]];et.forEach(function(nt,ot){it.push(["zone-area-"+ot,"highcharts-area highcharts-zone-area-"+ot+" "+nt.className,nt.color||a.color,nt.fillColor||j.fillColor])}),it.forEach(function(nt){var ot=nt[0],at=a[ot],lt=at?"animate":"attr",ct={};at?(at.endX=a.preventGraphAnimation?null:k.xMap,at.animate({d:k})):(ct.zIndex=0,at=a[ot]=a.chart.renderer.path(k).addClass(nt[1]).add(a.group),at.isArea=!0),a.chart.styledMode||(ct.fill=pick$1l(nt[3],color$d(nt[2]).setOpacity(pick$1l(j.fillOpacity,.75)).get())),at[lt](ct),at.startX=k.xMap,at.shiftUnit=j.step?2:1})},y.prototype.getGraphPath=function(a){var k=LineSeries$4.prototype.getGraphPath,j,et=this.options,it=et.stacking,nt=this.yAxis,ot,at,lt=[],ct=[],ht=this.index,ut,ft,vt,gt=nt.stacking.stacks[this.stackKey],mt=et.threshold,bt=Math.round(nt.getThreshold(et.threshold)),xt,wt,Mt=pick$1l(et.connectNulls,it==="percent"),Et=function(kt,Pt,It){var Nt=a[kt],Ut=it&&gt[Nt.x].points[ht],Rt=Nt[It+"Null"]||0,Ft=Nt[It+"Cliff"]||0,Dt,Ht,Gt=!0;Ft||Rt?(Dt=(Rt?Ut[0]:Ut[1])+Ft,Ht=Ut[0]+Ft,Gt=!!Rt):!it&&a[Pt]&&a[Pt].isNull&&(Dt=Ht=mt),typeof Dt<"u"&&(ct.push({plotX:vt,plotY:Dt===null?bt:nt.getThreshold(Dt),isNull:Gt,isCliff:!0}),lt.push({plotX:vt,plotY:Ht===null?bt:nt.getThreshold(Ht),doCurve:!1}))};for(a=a||this.points,it&&(a=this.getStackPoints(a)),ut=0;ut<a.length;ut++)it||(a[ut].leftCliff=a[ut].rightCliff=a[ut].leftNull=a[ut].rightNull=void 0),xt=a[ut].isNull,vt=pick$1l(a[ut].rectPlotX,a[ut].plotX),wt=it?pick$1l(a[ut].yBottom,bt):bt,(!xt||Mt)&&(Mt||Et(ut,ut-1,"left"),xt&&!it&&Mt||(ct.push(a[ut]),lt.push({x:ut,plotX:vt,plotY:wt})),Mt||Et(ut,ut+1,"right"));ot=k.call(this,ct,!0,!0),lt.reversed=!0,at=k.call(this,lt,!0,!0);var St=at[0];return St&&St[0]==="M"&&(at[0]=["L",St[1],St[2]]),ft=ot.concat(at),ft.length&&ft.push(["Z"]),j=k.call(this,ct,!1,Mt),ft.xMap=ot.xMap,this.areaPath=ft,j},y.prototype.getStackPoints=function(a){var k=this,j=[],et=[],it=this.xAxis,nt=this.yAxis,ot=nt.stacking.stacks[this.stackKey],at={},lt=nt.series,ct=lt.length,ht=nt.options.reversedStacks?1:-1,ut=lt.indexOf(k);if(a=a||this.points,this.options.stacking){for(var ft=0;ft<a.length;ft++)a[ft].leftNull=a[ft].rightNull=void 0,at[a[ft].x]=a[ft];objectEach$l(ot,function(gt,mt){gt.total!==null&&et.push(mt)}),et.sort(function(gt,mt){return gt-mt});var vt=lt.map(function(gt){return gt.visible});et.forEach(function(gt,mt){var bt=0,xt,wt;if(at[gt]&&!at[gt].isNull)j.push(at[gt]),[-1,1].forEach(function(St){var kt=St===1?"rightNull":"leftNull",Pt=St===1?"rightCliff":"leftCliff",It=0,Nt=ot[et[mt+St]];if(Nt)for(var Ut=ut;Ut>=0&&Ut<ct;){var Rt=lt[Ut].index;xt=Nt.points[Rt],xt||(Rt===k.index?at[gt][kt]=!0:vt[Ut]&&(wt=ot[gt].points[Rt],wt&&(It-=wt[1]-wt[0]))),Ut+=ht}at[gt][Pt]=It});else{for(var Mt=ut;Mt>=0&&Mt<ct;){var Et=lt[Mt].index;if(xt=ot[gt].points[Et],xt){bt=xt[1];break}Mt+=ht}bt=pick$1l(bt,0),bt=nt.translate(bt,0,1,0,1),j.push({isNull:!0,plotX:it.translate(gt,0,0,0,1),x:gt,plotY:bt,yBottom:bt})}})}return j},y.defaultOptions=merge$1d(LineSeries$4.defaultOptions,{threshold:0}),y})(LineSeries$4);extend$1j(AreaSeries$1.prototype,{singleStacks:!1,drawLegendSymbol:LegendSymbol$1.drawRectangle});SeriesRegistry$1.registerSeriesType("area",AreaSeries$1);var __extends$2b=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),LineSeries$3=SeriesRegistry$1.seriesTypes.line,merge$1c=Utilities.merge,pick$1k=Utilities.pick,SplineSeries$1=(function(z){__extends$2b(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return y.prototype.getPointSpline=function(a,k,j){var et=1.5,it=et+1,nt=k.plotX||0,ot=k.plotY||0,at=a[j-1],lt=a[j+1],ct,ht,ut,ft,vt;function gt(Et){return Et&&!Et.isNull&&Et.doCurve!==!1&&!k.isCliff}if(gt(at)&&gt(lt)){var mt=at.plotX||0,bt=at.plotY||0,xt=lt.plotX||0,wt=lt.plotY||0,Mt=0;ct=(et*nt+mt)/it,ht=(et*ot+bt)/it,ut=(et*nt+xt)/it,ft=(et*ot+wt)/it,ut!==ct&&(Mt=(ft-ht)*(ut-nt)/(ut-ct)+ot-ft),ht+=Mt,ft+=Mt,ht>bt&&ht>ot?(ht=Math.max(bt,ot),ft=2*ot-ht):ht<bt&&ht<ot&&(ht=Math.min(bt,ot),ft=2*ot-ht),ft>wt&&ft>ot?(ft=Math.max(wt,ot),ht=2*ot-ft):ft<wt&&ft<ot&&(ft=Math.min(wt,ot),ht=2*ot-ft),k.rightContX=ut,k.rightContY=ft}return vt=["C",pick$1k(at.rightContX,at.plotX,0),pick$1k(at.rightContY,at.plotY,0),pick$1k(ct,nt,0),pick$1k(ht,ot,0),nt,ot],at.rightContX=at.rightContY=void 0,vt},y.defaultOptions=merge$1c(LineSeries$3.defaultOptions),y})(LineSeries$3);SeriesRegistry$1.registerSeriesType("spline",SplineSeries$1);var __extends$2a=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),areaProto$1=AreaSeries$1.prototype,extend$1i=Utilities.extend,merge$1b=Utilities.merge,AreaSplineSeries=(function(z){__extends$2a(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.data=void 0,a.points=void 0,a.options=void 0,a}return y.defaultOptions=merge$1b(SplineSeries$1.defaultOptions,AreaSeries$1.defaultOptions),y})(SplineSeries$1);extend$1i(AreaSplineSeries.prototype,{getGraphPath:areaProto$1.getGraphPath,getStackPoints:areaProto$1.getStackPoints,drawGraph:areaProto$1.drawGraph,drawLegendSymbol:LegendSymbol$1.drawRectangle});SeriesRegistry$1.registerSeriesType("areaspline",AreaSplineSeries);var __extends$29=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),animObject$6=animationExports.animObject,color$c=Color.parse,hasTouch$1=H.hasTouch,noop$g=H.noop,clamp$f=Utilities.clamp,css$4=Utilities.css,defined$H=Utilities.defined,extend$1h=Utilities.extend,fireEvent$q=Utilities.fireEvent,isArray$g=Utilities.isArray,isNumber$D=Utilities.isNumber,merge$1a=Utilities.merge,pick$1j=Utilities.pick,objectEach$k=Utilities.objectEach,ColumnSeries$h=(function(z){__extends$29(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.borderWidth=void 0,a.data=void 0,a.group=void 0,a.options=void 0,a.points=void 0,a}return y.prototype.animate=function(a){var k=this,j=this.yAxis,et=k.options,it=this.chart.inverted,nt={},ot=it?"translateX":"translateY",at,lt;a?(nt.scaleY=.001,lt=clamp$f(j.toPixels(et.threshold),j.pos,j.pos+j.len),it?nt.translateX=lt-j.len:nt.translateY=lt,k.clipBox&&k.setClip(),k.group.attr(nt)):(at=Number(k.group.attr(ot)),k.group.animate({scaleY:1},extend$1h(animObject$6(k.options.animation),{step:function(ct,ht){k.group&&(nt[ot]=at+ht.pos*(j.pos-at),k.group.attr(nt))}})))},y.prototype.init=function(a,k){z.prototype.init.apply(this,arguments);var j=this;a=j.chart,a.hasRendered&&a.series.forEach(function(et){et.type===j.type&&(et.isDirty=!0)})},y.prototype.getColumnMetrics=function(){var a=this,k=a.options,j=a.xAxis,et=a.yAxis,it=j.options.reversedStacks,nt=j.reversed&&!it||!j.reversed&&it,ot={},at,lt=0;k.grouping===!1?lt=1:a.chart.series.forEach(function(xt){var wt=xt.yAxis,Mt=xt.options,Et;xt.type===a.type&&(xt.visible||!a.chart.options.chart.ignoreHiddenSeries)&&et.len===wt.len&&et.pos===wt.pos&&(Mt.stacking&&Mt.stacking!=="group"?(at=xt.stackKey,typeof ot[at]>"u"&&(ot[at]=lt++),Et=ot[at]):Mt.grouping!==!1&&(Et=lt++),xt.columnIndex=Et)});var ct=Math.min(Math.abs(j.transA)*(j.ordinal&&j.ordinal.slope||k.pointRange||j.closestPointRange||j.tickInterval||1),j.len),ht=ct*k.groupPadding,ut=ct-2*ht,ft=ut/(lt||1),vt=Math.min(k.maxPointWidth||j.len,pick$1j(k.pointWidth,ft*(1-2*k.pointPadding))),gt=(ft-vt)/2,mt=(a.columnIndex||0)+(nt?1:0),bt=gt+(ht+mt*ft-ct/2)*(nt?-1:1);return a.columnMetrics={width:vt,offset:bt,paddedWidth:ft,columnCount:lt},a.columnMetrics},y.prototype.crispCol=function(a,k,j,et){var it=this.chart,nt=this.borderWidth,ot=-(nt%2?.5:0),at,lt=nt%2?.5:1;it.inverted&&it.renderer.isVML&&(lt+=1),this.options.crisp&&(at=Math.round(a+j)+ot,a=Math.round(a)+ot,j=at-a);var ct=Math.round(k+et)+lt,ht=Math.abs(k)<=.5&&ct>.5;return k=Math.round(k)+lt,et=ct-k,ht&&et&&(k-=1,et+=1),{x:a,y:k,width:j,height:et}},y.prototype.adjustForMissingColumns=function(a,k,j,et){var it=this,nt=this.options.stacking;if(!j.isNull&&et.columnCount>1){var ot=0,at=0;objectEach$k(this.yAxis.stacking&&this.yAxis.stacking.stacks,function(ct){if(typeof j.x=="number"){var ht=ct[j.x.toString()];if(ht){var ut=ht.points[it.index],ft=ht.total;nt?(ut&&(ot=at),ht.hasValidPoints&&at++):isArray$g(ut)&&(ot=ut[1],at=ft||0)}}});var lt=(at-1)*et.paddedWidth+k;a=(j.plotX||0)+lt/2-k-ot*et.paddedWidth}return a},y.prototype.translate=function(){var a=this,k=a.chart,j=a.options,et=a.dense=a.closestPointRange*a.xAxis.transA<2,it=a.borderWidth=pick$1j(j.borderWidth,et?0:1),nt=a.xAxis,ot=a.yAxis,at=j.threshold,lt=a.translatedThreshold=ot.getThreshold(at),ct=pick$1j(j.minPointLength,5),ht=a.getColumnMetrics(),ut=ht.width,ft=a.pointXOffset=ht.offset,vt=a.dataMin,gt=a.dataMax,mt=a.barW=Math.max(ut,1+2*it);k.inverted&&(lt-=.5),j.pointPadding&&(mt=Math.ceil(mt)),Series$f.prototype.translate.apply(a),a.points.forEach(function(bt){var xt=pick$1j(bt.yBottom,lt),wt=999+Math.abs(xt),Mt=bt.plotX||0,Et=clamp$f(bt.plotY,-wt,ot.len+wt),St,kt=Math.min(Et,xt),Pt=Math.max(Et,xt)-kt,It=ut,Nt=Mt+ft,Ut=mt;ct&&Math.abs(Pt)<ct&&(Pt=ct,St=!ot.reversed&&!bt.negative||ot.reversed&&bt.negative,isNumber$D(at)&&isNumber$D(gt)&&bt.y===at&&gt<=at&&(ot.min||0)<at&&(vt!==gt||(ot.max||0)<=at)&&(St=!St),kt=Math.abs(kt-lt)>ct?xt-ct:lt-(St?ct:0)),defined$H(bt.options.pointWidth)&&(It=Ut=Math.ceil(bt.options.pointWidth),Nt-=Math.round((It-ut)/2)),j.centerInCategory&&(Nt=a.adjustForMissingColumns(Nt,It,bt,ht)),bt.barX=Nt,bt.pointWidth=It,bt.tooltipPos=k.inverted?[clamp$f(ot.len+ot.pos-k.plotLeft-Et,ot.pos-k.plotLeft,ot.len+ot.pos-k.plotLeft),nt.len+nt.pos-k.plotTop-Nt-Ut/2,Pt]:[nt.left-k.plotLeft+Nt+Ut/2,clamp$f(Et+ot.pos-k.plotTop,ot.pos-k.plotTop,ot.len+ot.pos-k.plotTop),Pt],bt.shapeType=a.pointClass.prototype.shapeType||"rect",bt.shapeArgs=a.crispCol.apply(a,bt.isNull?[Nt,lt,Ut,0]:[Nt,kt,Ut,Pt])})},y.prototype.drawGraph=function(){this.group[this.dense?"addClass":"removeClass"]("highcharts-dense-data")},y.prototype.pointAttribs=function(a,k){var j=this.options,et=this.pointAttrToOptions||{},it=et.stroke||"borderColor",nt=et["stroke-width"]||"borderWidth",ot,at,lt,ct=a&&a.color||this.color,ht=a&&a[it]||j[it]||ct,ut=a&&a.options.dashStyle||j.dashStyle,ft=a&&a[nt]||j[nt]||this[nt]||0,vt=pick$1j(a&&a.opacity,j.opacity,1);a&&this.zones.length&&(at=a.getZone(),ct=a.options.color||at&&(at.color||a.nonZonedColor)||this.color,at&&(ht=at.borderColor||ht,ut=at.dashStyle||ut,ft=at.borderWidth||ft)),k&&a&&(ot=merge$1a(j.states[k],a.options.states&&a.options.states[k]||{}),lt=ot.brightness,ct=ot.color||typeof lt<"u"&&color$c(ct).brighten(ot.brightness).get()||ct,ht=ot[it]||ht,ft=ot[nt]||ft,ut=ot.dashStyle||ut,vt=pick$1j(ot.opacity,vt));var gt={fill:ct,stroke:ht,"stroke-width":ft,opacity:vt};return ut&&(gt.dashstyle=ut),gt},y.prototype.drawPoints=function(){var a=this,k=this.chart,j=a.options,et=k.renderer,it=j.animationLimit||250,nt;a.points.forEach(function(ot){var at=ot.plotY,lt=ot.graphic,ct=!!lt,ht=lt&&k.pointCount<it?"animate":"attr";isNumber$D(at)&&ot.y!==null?(nt=ot.shapeArgs,lt&&ot.hasNewShapeType()&&(lt=lt.destroy()),a.enabledDataSorting&&(ot.startXPos=a.xAxis.reversed?-(nt&&nt.width||0):a.xAxis.width),lt||(ot.graphic=lt=et[ot.shapeType](nt).add(ot.group||a.group),lt&&a.enabledDataSorting&&k.hasRendered&&k.pointCount<it&&(lt.attr({x:ot.startXPos}),ct=!0,ht="animate")),lt&&ct&&lt[ht](merge$1a(nt)),j.borderRadius&&lt[ht]({r:j.borderRadius}),k.styledMode||lt[ht](a.pointAttribs(ot,ot.selected&&"select")).shadow(ot.allowShadow!==!1&&j.shadow,null,j.stacking&&!j.borderRadius),lt&&(lt.addClass(ot.getClassName(),!0),lt.attr({visibility:ot.visible?"inherit":"hidden"}))):lt&&(ot.graphic=lt.destroy())})},y.prototype.drawTracker=function(){var a=this,k=a.chart,j=k.pointer,et=function(nt){var ot=j.getPointFromEvent(nt);typeof ot<"u"&&(j.isDirectTouch=!0,ot.onMouseOver(nt))},it;a.points.forEach(function(nt){it=isArray$g(nt.dataLabels)?nt.dataLabels:nt.dataLabel?[nt.dataLabel]:[],nt.graphic&&(nt.graphic.element.point=nt),it.forEach(function(ot){ot.div?ot.div.point=nt:ot.element.point=nt})}),a._hasTracking||(a.trackerGroups.forEach(function(nt){a[nt]&&(a[nt].addClass("highcharts-tracker").on("mouseover",et).on("mouseout",function(ot){j.onTrackerMouseOut(ot)}),hasTouch$1&&a[nt].on("touchstart",et),!k.styledMode&&a.options.cursor&&a[nt].css(css$4).css({cursor:a.options.cursor}))}),a._hasTracking=!0),fireEvent$q(this,"afterDrawTracker")},y.prototype.remove=function(){var a=this,k=a.chart;k.hasRendered&&k.series.forEach(function(j){j.type===a.type&&(j.isDirty=!0)}),Series$f.prototype.remove.apply(a,arguments)},y.defaultOptions=merge$1a(Series$f.defaultOptions,{borderRadius:0,centerInCategory:!1,groupPadding:.2,marker:null,pointPadding:.1,minPointLength:0,cropThreshold:50,pointRange:null,states:{hover:{halo:!1,brightness:.1},select:{color:palette.neutralColor20,borderColor:palette.neutralColor100}},dataLabels:{align:void 0,verticalAlign:void 0,y:void 0},startFromThreshold:!0,stickyTracking:!1,tooltip:{distance:6},threshold:0,borderColor:palette.backgroundColor}),y})(Series$f);extend$1h(ColumnSeries$h.prototype,{cropShoulder:0,directTouch:!0,drawLegendSymbol:LegendSymbol$1.drawRectangle,getSymbol:noop$g,negStacks:!0,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("column",ColumnSeries$h);var getDeferredAnimation$1=animationExports.getDeferredAnimation,format$9=FormatUtilities.format,defined$G=Utilities.defined,extend$1g=Utilities.extend,fireEvent$p=Utilities.fireEvent,isArray$f=Utilities.isArray,merge$19=Utilities.merge,objectEach$j=Utilities.objectEach,pick$1i=Utilities.pick,splat$d=Utilities.splat,DataLabel;(function(z){var y=[];function a(at,lt,ct,ht,ut){var ft=this,vt=this.chart,gt=this.isCartesian&&vt.inverted,mt=this.enabledDataSorting,bt=pick$1i(at.dlBox&&at.dlBox.centerX,at.plotX,-9999),xt=pick$1i(at.plotY,-9999),wt=lt.getBBox(),Mt=ct.rotation,Et=ct.align,St=vt.isInsidePlot(bt,Math.round(xt),{inverted:gt,paneCoordinates:!0,series:ft}),kt=function(Ht){mt&&ft.xAxis&&!Ft&&ft.setDataLabelStartPos(at,lt,ut,St,Ht)},Pt,It,Nt,Ut,Rt,Ft=pick$1i(ct.overflow,mt?"none":"justify")==="justify",Dt=this.visible&&at.visible!==!1&&(at.series.forceDL||mt&&!Ft||St||pick$1i(ct.inside,!!this.options.stacking)&&ht&&vt.isInsidePlot(bt,gt?ht.x+1:ht.y+ht.height-1,{inverted:gt,paneCoordinates:!0,series:ft}));Dt&&(Pt=vt.renderer.fontMetrics(vt.styledMode?void 0:ct.style.fontSize,lt).b,ht=extend$1g({x:gt?this.yAxis.len-xt:bt,y:Math.round(gt?this.xAxis.len-bt:xt),width:0,height:0},ht),extend$1g(ct,{width:wt.width,height:wt.height}),Mt?(Ft=!1,Ut=vt.renderer.rotCorr(Pt,Mt),Rt={x:ht.x+(ct.x||0)+ht.width/2+Ut.x,y:ht.y+(ct.y||0)+{top:0,middle:.5,bottom:1}[ct.verticalAlign]*ht.height},kt(Rt),lt[ut?"attr":"animate"](Rt).attr({align:Et}),It=(Mt+720)%360,Nt=It>180&&It<360,Et==="left"?Rt.y-=Nt?wt.height:0:Et==="center"?(Rt.x-=wt.width/2,Rt.y-=wt.height/2):Et==="right"&&(Rt.x-=wt.width,Rt.y-=Nt?0:wt.height),lt.placed=!0,lt.alignAttr=Rt):(kt(ht),lt.align(ct,void 0,ht),Rt=lt.alignAttr),Ft&&ht.height>=0?this.justifyDataLabel(lt,ct,Rt,wt,ht,ut):pick$1i(ct.crop,!0)&&(Dt=vt.isInsidePlot(Rt.x,Rt.y,{paneCoordinates:!0,series:ft})&&vt.isInsidePlot(Rt.x+wt.width,Rt.y+wt.height,{paneCoordinates:!0,series:ft})),ct.shape&&!Mt&&lt[ut?"attr":"animate"]({anchorX:gt?vt.plotWidth-at.plotY:at.plotX,anchorY:gt?vt.plotHeight-at.plotX:at.plotY})),ut&&mt&&(lt.placed=!1),!Dt&&(!mt||Ft)&&(lt.hide(!0),lt.placed=!1)}function k(at,lt){var ct=lt.filter;if(ct){var ht=ct.operator,ut=at[ct.property],ft=ct.value;return ht===">"&&ut>ft||ht==="<"&&ut<ft||ht===">="&&ut>=ft||ht==="<="&&ut<=ft||ht==="=="&&ut==ft||ht==="==="&&ut===ft}return!0}function j(at){if(y.indexOf(at)===-1){var lt=at.prototype;y.push(at),lt.alignDataLabel=a,lt.drawDataLabels=et,lt.justifyDataLabel=it,lt.setDataLabelStartPos=ot}}z.compose=j;function et(){var at=this,lt=at.chart,ct=at.options,ht=at.points,ut=at.hasRendered||0,ft=lt.renderer,vt=ct.dataLabels,gt,mt,bt=vt.animation,xt=vt.defer?getDeferredAnimation$1(lt,bt,at):{defer:0,duration:0};if(vt=nt(nt(lt.options.plotOptions&&lt.options.plotOptions.series&&lt.options.plotOptions.series.dataLabels,lt.options.plotOptions&&lt.options.plotOptions[at.type]&&lt.options.plotOptions[at.type].dataLabels),vt),fireEvent$p(this,"drawDataLabels"),isArray$f(vt)||vt.enabled||at._hasPointLabels){if(mt=at.plotGroup("dataLabelsGroup","data-labels",ut?"inherit":"hidden",vt.zIndex||6),mt.attr({opacity:+ut}),!ut){var wt=at.dataLabelsGroup;wt&&(at.visible&&mt.show(!0),wt[ct.animation?"animate":"attr"]({opacity:1},xt))}ht.forEach(function(Mt){gt=splat$d(nt(vt,Mt.dlOptions||Mt.options&&Mt.options.dataLabels)),gt.forEach(function(Et,St){var kt=Et.enabled&&(!Mt.isNull||Mt.dataLabelOnNull)&&k(Mt,Et),Pt=Mt.connectors?Mt.connectors[St]:Mt.connector,It,Nt,Ut,Rt,Ft,Dt,Ht=Mt.dataLabels?Mt.dataLabels[St]:Mt.dataLabel,Gt=pick$1i(Et.distance,Mt.labelDistance),Yt=!Ht;kt&&(It=Mt.getLabelConfig(),Nt=pick$1i(Et[Mt.formatPrefix+"Format"],Et.format),Ut=defined$G(Nt)?format$9(Nt,It,lt):(Et[Mt.formatPrefix+"Formatter"]||Et.formatter).call(It,Et),Rt=Et.style,Ft=Et.rotation,lt.styledMode||(Rt.color=pick$1i(Et.color,Rt.color,at.color,palette.neutralColor100),Rt.color==="contrast"?(Mt.contrastColor=ft.getContrast(Mt.color||at.color),Rt.color=!defined$G(Gt)&&Et.inside||Gt<0||ct.stacking?Mt.contrastColor:palette.neutralColor100):delete Mt.contrastColor,ct.cursor&&(Rt.cursor=ct.cursor)),Dt={r:Et.borderRadius||0,rotation:Ft,padding:Et.padding,zIndex:1},lt.styledMode||(Dt.fill=Et.backgroundColor,Dt.stroke=Et.borderColor,Dt["stroke-width"]=Et.borderWidth),objectEach$j(Dt,function(te,he){typeof te>"u"&&delete Dt[he]})),Ht&&(!kt||!defined$G(Ut))?(Mt.dataLabel=Mt.dataLabel&&Mt.dataLabel.destroy(),Mt.dataLabels&&(Mt.dataLabels.length===1?delete Mt.dataLabels:delete Mt.dataLabels[St]),St||delete Mt.dataLabel,Pt&&(Mt.connector=Mt.connector.destroy(),Mt.connectors&&(Mt.connectors.length===1?delete Mt.connectors:delete Mt.connectors[St]))):kt&&defined$G(Ut)&&(Ht?Dt.text=Ut:(Mt.dataLabels=Mt.dataLabels||[],Ht=Mt.dataLabels[St]=Ft?ft.text(Ut,0,-9999,Et.useHTML).addClass("highcharts-data-label"):ft.label(Ut,0,-9999,Et.shape,null,null,Et.useHTML,null,"data-label"),St||(Mt.dataLabel=Ht),Ht.addClass(" highcharts-data-label-color-"+Mt.colorIndex+" "+(Et.className||"")+(Et.useHTML?" highcharts-tracker":""))),Ht.options=Et,Ht.attr(Dt),lt.styledMode||Ht.css(Rt).shadow(Et.shadow),Ht.added||Ht.add(mt),Et.textPath&&!Et.useHTML&&(Ht.setTextPath(Mt.getDataLabelPath&&Mt.getDataLabelPath(Ht)||Mt.graphic,Et.textPath),Mt.dataLabelPath&&!Et.textPath.enabled&&(Mt.dataLabelPath=Mt.dataLabelPath.destroy())),at.alignDataLabel(Mt,Ht,Et,null,Yt))})})}fireEvent$p(this,"afterDrawDataLabels")}function it(at,lt,ct,ht,ut,ft){var vt=this.chart,gt=lt.align,mt=lt.verticalAlign,bt=at.box?0:at.padding||0,xt=lt.x,wt=xt===void 0?0:xt,Mt=lt.y,Et=Mt===void 0?0:Mt,St,kt;return St=(ct.x||0)+bt,St<0&&(gt==="right"&&wt>=0?(lt.align="left",lt.inside=!0):wt-=St,kt=!0),St=(ct.x||0)+ht.width-bt,St>vt.plotWidth&&(gt==="left"&&wt<=0?(lt.align="right",lt.inside=!0):wt+=vt.plotWidth-St,kt=!0),St=ct.y+bt,St<0&&(mt==="bottom"&&Et>=0?(lt.verticalAlign="top",lt.inside=!0):Et-=St,kt=!0),St=(ct.y||0)+ht.height-bt,St>vt.plotHeight&&(mt==="top"&&Et<=0?(lt.verticalAlign="bottom",lt.inside=!0):Et+=vt.plotHeight-St,kt=!0),kt&&(lt.x=wt,lt.y=Et,at.placed=!ft,at.align(lt,void 0,ut)),kt}function nt(at,lt){var ct=[],ht;if(isArray$f(at)&&!isArray$f(lt))ct=at.map(function(ut){return merge$19(ut,lt)});else if(isArray$f(lt)&&!isArray$f(at))ct=lt.map(function(ut){return merge$19(at,ut)});else if(!isArray$f(at)&&!isArray$f(lt))ct=merge$19(at,lt);else for(ht=Math.max(at.length,lt.length);ht--;)ct[ht]=merge$19(at[ht],lt[ht]);return ct}function ot(at,lt,ct,ht,ut){var ft=this.chart,vt=ft.inverted,gt=this.xAxis,mt=gt.reversed,bt=vt?lt.height/2:lt.width/2,xt=at.pointWidth,wt=xt?xt/2:0;lt.startXPos=vt?ut.x:mt?-bt-wt:gt.width-bt+wt,lt.startYPos=vt?mt?this.yAxis.height-bt+wt:-bt-wt:ut.y,ht?lt.visibility==="hidden"&&(lt.show(),lt.attr({opacity:0}).animate({opacity:1})):lt.attr({opacity:1}).animate({opacity:0},void 0,lt.hide),ft.hasRendered&&(ct&&lt.attr({x:lt.startXPos,y:lt.startYPos}),lt.placed=!0)}})(DataLabel||(DataLabel={}));const DataLabel$1=DataLabel;var Series$e=SeriesRegistry$1.series,merge$18=Utilities.merge,pick$1h=Utilities.pick,ColumnDataLabel$1;(function(z){var y=[];function a(j,et,it,nt,ot){var at=this.chart.inverted,lt=j.series,ct=j.dlBox||j.shapeArgs,ht=pick$1h(j.below,j.plotY>pick$1h(this.translatedThreshold,lt.yAxis.len)),ut=pick$1h(it.inside,!!this.options.stacking),ft;ct&&(nt=merge$18(ct),nt.y<0&&(nt.height+=nt.y,nt.y=0),ft=nt.y+nt.height-lt.yAxis.len,ft>0&&ft<nt.height&&(nt.height-=ft),at&&(nt={x:lt.yAxis.len-nt.y-nt.height,y:lt.xAxis.len-nt.x-nt.width,width:nt.height,height:nt.width}),ut||(at?(nt.x+=ht?0:nt.width,nt.width=0):(nt.y+=ht?nt.height:0,nt.height=0))),it.align=pick$1h(it.align,!at||ut?"center":ht?"right":"left"),it.verticalAlign=pick$1h(it.verticalAlign,at||ut?"middle":ht?"top":"bottom"),Series$e.prototype.alignDataLabel.call(this,j,et,it,nt,ot),it.inside&&j.contrastColor&&et.css({color:j.contrastColor})}function k(j){DataLabel$1.compose(Series$e),y.indexOf(j)===-1&&(y.push(j),j.prototype.alignDataLabel=a)}z.compose=k})(ColumnDataLabel$1||(ColumnDataLabel$1={}));const ColumnDataLabel$2=ColumnDataLabel$1;var __extends$28=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),extend$1f=Utilities.extend,merge$17=Utilities.merge,BarSeries=(function(z){__extends$28(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return y.defaultOptions=merge$17(ColumnSeries$h.defaultOptions,{}),y})(ColumnSeries$h);extend$1f(BarSeries.prototype,{inverted:!0});SeriesRegistry$1.registerSeriesType("bar",BarSeries);var __extends$27=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),addEvent$W=Utilities.addEvent,extend$1e=Utilities.extend,merge$16=Utilities.merge,ScatterSeries$4=(function(z){__extends$27(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return y.prototype.applyJitter=function(){var a=this,k=this.options.jitter,j=this.points.length;function et(it){var nt=Math.sin(it)*1e4;return nt-Math.floor(nt)}k&&this.points.forEach(function(it,nt){["x","y"].forEach(function(ot,at){var lt,ct="plot"+ot.toUpperCase(),ht,ut,ft;k[ot]&&!it.isNull&&(lt=a[ot+"Axis"],ft=k[ot]*lt.transA,lt&&!lt.isLog&&(ht=Math.max(0,it[ct]-ft),ut=Math.min(lt.len,it[ct]+ft),it[ct]=ht+(ut-ht)*et(nt+at*j),ot==="x"&&(it.clientX=it.plotX)))})})},y.prototype.drawGraph=function(){this.options.lineWidth?z.prototype.drawGraph.call(this):this.graph&&(this.graph=this.graph.destroy())},y.defaultOptions=merge$16(LineSeries$5.defaultOptions,{lineWidth:0,findNearestPointBy:"xy",jitter:{x:0,y:0},marker:{enabled:!0},tooltip:{headerFormat:'<span style="color:{point.color}">●</span> <span style="font-size: 10px"> {series.name}</span><br/>',pointFormat:"x: <b>{point.x}</b><br/>y: <b>{point.y}</b><br/>"}}),y})(LineSeries$5);extend$1e(ScatterSeries$4.prototype,{drawTracker:ColumnSeries$h.prototype.drawTracker,sorted:!1,requireSorting:!1,noSharedTooltip:!0,trackerGroups:["group","markerGroup","dataLabelsGroup"],takeOrdinalPosition:!1});addEvent$W(ScatterSeries$4,"afterTranslate",function(){this.applyJitter()});SeriesRegistry$1.registerSeriesType("scatter",ScatterSeries$4);var isNumber$C=Utilities.isNumber,pick$1g=Utilities.pick,relativeLength$6=Utilities.relativeLength,deg2rad$5=H.deg2rad,centeredSeriesMixin=H.CenteredSeriesMixin={getCenter:function(){var z=this.options,y=this.chart,a=2*(z.slicedOffset||0),k,j=y.plotWidth-2*a,et=y.plotHeight-2*a,it=z.center,nt=Math.min(j,et),ot=z.size,at=z.innerSize||0,lt,ct,ht;for(typeof ot=="string"&&(ot=parseFloat(ot)),typeof at=="string"&&(at=parseFloat(at)),lt=[pick$1g(it[0],"50%"),pick$1g(it[1],"50%"),pick$1g(ot&&ot<0?void 0:z.size,"100%"),pick$1g(at&&at<0?void 0:z.innerSize||0,"0%")],y.angular&&!(this instanceof Series$f)&&(lt[3]=0),ct=0;ct<4;++ct)ht=lt[ct],k=ct<2||ct===2&&/%$/.test(ht),lt[ct]=relativeLength$6(ht,[j,et,nt,lt[2]][ct])+(k?a:0);return lt[3]>lt[2]&&(lt[3]=lt[2]),lt},getStartAndEndRadians:function(z,y){var a=isNumber$C(z)?z:0,k=isNumber$C(y)&&y>a&&y-a<360?y:a+360,j=-90;return{start:deg2rad$5*(a+j),end:deg2rad$5*(k+j)}}},__extends$26=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),setAnimation$1=animationExports.setAnimation,addEvent$V=Utilities.addEvent,defined$F=Utilities.defined,extend$1d=Utilities.extend,isNumber$B=Utilities.isNumber,pick$1f=Utilities.pick,relativeLength$5=Utilities.relativeLength,PiePoint$3=(function(z){__extends$26(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.labelDistance=void 0,a.options=void 0,a.series=void 0,a}return y.prototype.getConnectorPath=function(){var a=this.labelPosition,k=this.series.options.dataLabels,j=this.connectorShapes,et=k.connectorShape;return j[et]&&(et=j[et]),et.call(this,{x:a.final.x,y:a.final.y,alignment:a.alignment},a.connectorPosition,k)},y.prototype.getTranslate=function(){return this.sliced?this.slicedTranslation:{translateX:0,translateY:0}},y.prototype.haloPath=function(a){var k=this.shapeArgs;return this.sliced||!this.visible?[]:this.series.chart.renderer.symbols.arc(k.x,k.y,k.r+a,k.r+a,{innerR:k.r-1,start:k.start,end:k.end})},y.prototype.init=function(){var a=this;z.prototype.init.apply(this,arguments),this.name=pick$1f(this.name,"Slice");var k=function(j){a.slice(j.type==="select")};return addEvent$V(this,"select",k),addEvent$V(this,"unselect",k),this},y.prototype.isValid=function(){return isNumber$B(this.y)&&this.y>=0},y.prototype.setVisible=function(a,k){var j=this,et=this.series,it=et.chart,nt=et.options.ignoreHiddenPoint;k=pick$1f(k,nt),a!==this.visible&&(this.visible=this.options.visible=a=typeof a>"u"?!this.visible:a,et.options.data[et.data.indexOf(this)]=this.options,["graphic","dataLabel","connector","shadowGroup"].forEach(function(ot){j[ot]&&j[ot][a?"show":"hide"](a)}),this.legendItem&&it.legend.colorizeItem(this,a),!a&&this.state==="hover"&&this.setState(""),nt&&(et.isDirty=!0),k&&it.redraw())},y.prototype.slice=function(a,k,j){var et=this.series,it=et.chart;setAnimation$1(j,it),k=pick$1f(k,!0),this.sliced=this.options.sliced=a=defined$F(a)?a:!this.sliced,et.options.data[et.data.indexOf(this)]=this.options,this.graphic&&this.graphic.animate(this.getTranslate()),this.shadowGroup&&this.shadowGroup.animate(this.getTranslate())},y})(Point$4);extend$1d(PiePoint$3.prototype,{connectorShapes:{fixedOffset:function(z,y,a){var k=y.breakAt,j=y.touchingSliceAt,et=a.softConnector?["C",z.x+(z.alignment==="left"?-5:5),z.y,2*k.x-j.x,2*k.y-j.y,k.x,k.y]:["L",k.x,k.y];return[["M",z.x,z.y],et,["L",j.x,j.y]]},straight:function(z,y){var a=y.touchingSliceAt;return[["M",z.x,z.y],["L",a.x,a.y]]},crookedLine:function(z,y,a){var k=y.touchingSliceAt,j=this.series,et=j.center[0],it=j.chart.plotWidth,nt=j.chart.plotLeft,ot=z.alignment,at=this.shapeArgs.r,lt=relativeLength$5(a.crookDistance,1),ct=ot==="left"?et+at+(it+nt-et-at)*(1-lt):nt+(et-at)*lt,ht=["L",ct,z.y],ut=!0;(ot==="left"?ct>z.x||ct<k.x:ct<z.x||ct>k.x)&&(ut=!1);var ft=[["M",z.x,z.y]];return ut&&ft.push(ht),ft.push(["L",k.x,k.y]),ft}}});var __extends$25=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),getStartAndEndRadians=centeredSeriesMixin.getStartAndEndRadians,noop$f=H.noop,clamp$e=Utilities.clamp,extend$1c=Utilities.extend,fireEvent$o=Utilities.fireEvent,merge$15=Utilities.merge,pick$1e=Utilities.pick,relativeLength$4=Utilities.relativeLength,PieSeries$3=(function(z){__extends$25(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.center=void 0,a.data=void 0,a.maxLabelDistance=void 0,a.options=void 0,a.points=void 0,a}return y.prototype.animate=function(a){var k=this,j=k.points,et=k.startAngleRad;a||j.forEach(function(it){var nt=it.graphic,ot=it.shapeArgs;nt&&ot&&(nt.attr({r:pick$1e(it.startR,k.center&&k.center[3]/2),start:et,end:et}),nt.animate({r:ot.r,start:ot.start,end:ot.end},k.options.animation))})},y.prototype.drawEmpty=function(){var a=this.startAngleRad,k=this.endAngleRad,j=this.options,et,it;this.total===0&&this.center?(et=this.center[0],it=this.center[1],this.graph||(this.graph=this.chart.renderer.arc(et,it,this.center[1]/2,0,a,k).addClass("highcharts-empty-series").add(this.group)),this.graph.attr({d:Symbols.arc(et,it,this.center[2]/2,0,{start:a,end:k,innerR:this.center[3]/2})}),this.chart.styledMode||this.graph.attr({"stroke-width":j.borderWidth,fill:j.fillColor||"none",stroke:j.color||palette.neutralColor20})):this.graph&&(this.graph=this.graph.destroy())},y.prototype.drawPoints=function(){var a=this.chart.renderer;this.points.forEach(function(k){k.graphic&&k.hasNewShapeType()&&(k.graphic=k.graphic.destroy()),k.graphic||(k.graphic=a[k.shapeType](k.shapeArgs).add(k.series.group),k.delayedRendering=!0)})},y.prototype.generatePoints=function(){z.prototype.generatePoints.call(this),this.updateTotals()},y.prototype.getX=function(a,k,j){var et=this.center,it=this.radii?this.radii[j.index]||0:et[2]/2,nt=Math.asin(clamp$e((a-et[1])/(it+j.labelDistance),-1,1)),ot=et[0]+(k?-1:1)*(Math.cos(nt)*(it+j.labelDistance))+(j.labelDistance>0?(k?-1:1)*this.options.dataLabels.padding:0);return ot},y.prototype.hasData=function(){return!!this.processedXData.length},y.prototype.redrawPoints=function(){var a=this,k=a.chart,j=k.renderer,et=a.options.shadow,it,nt,ot,at;this.drawEmpty(),et&&!a.shadowGroup&&!k.styledMode&&(a.shadowGroup=j.g("shadow").attr({zIndex:-1}).add(a.group)),a.points.forEach(function(lt){var ct={};if(nt=lt.graphic,!lt.isNull&&nt){var ht=void 0;at=lt.shapeArgs,it=lt.getTranslate(),k.styledMode||(ht=lt.shadowGroup,et&&!ht&&(ht=lt.shadowGroup=j.g("shadow").add(a.shadowGroup)),ht&&ht.attr(it),ot=a.pointAttribs(lt,lt.selected&&"select")),lt.delayedRendering?(nt.setRadialReference(a.center).attr(at).attr(it),k.styledMode||nt.attr(ot).attr({"stroke-linejoin":"round"}).shadow(et,ht),lt.delayedRendering=!1):(nt.setRadialReference(a.center),k.styledMode||merge$15(!0,ct,ot),merge$15(!0,ct,at,it),nt.animate(ct)),nt.attr({visibility:lt.visible?"inherit":"hidden"}),nt.addClass(lt.getClassName(),!0)}else nt&&(lt.graphic=nt.destroy())})},y.prototype.sortByAngle=function(a,k){a.sort(function(j,et){return typeof j.angle<"u"&&(et.angle-j.angle)*k})},y.prototype.translate=function(a){this.generatePoints();var k=this,j=1e3,et=k.options,it=et.slicedOffset,nt=it+(et.borderWidth||0),ot=getStartAndEndRadians(et.startAngle,et.endAngle),at=k.startAngleRad=ot.start,lt=k.endAngleRad=ot.end,ct=lt-at,ht=k.points,ut=et.dataLabels.distance,ft=et.ignoreHiddenPoint,vt=ht.length,gt,mt,bt,xt,wt,Mt,Et,St,kt=0;for(a||(k.center=a=k.getCenter()),Et=0;Et<vt;Et++){St=ht[Et],mt=at+kt*ct,St.isValid()&&(!ft||St.visible)&&(kt+=St.percentage/100),bt=at+kt*ct;var Pt={x:a[0],y:a[1],r:a[2]/2,innerR:a[3]/2,start:Math.round(mt*j)/j,end:Math.round(bt*j)/j};St.shapeType="arc",St.shapeArgs=Pt,St.labelDistance=pick$1e(St.options.dataLabels&&St.options.dataLabels.distance,ut),St.labelDistance=relativeLength$4(St.labelDistance,Pt.r),k.maxLabelDistance=Math.max(k.maxLabelDistance||0,St.labelDistance),xt=(bt+mt)/2,xt>1.5*Math.PI?xt-=2*Math.PI:xt<-Math.PI/2&&(xt+=2*Math.PI),St.slicedTranslation={translateX:Math.round(Math.cos(xt)*it),translateY:Math.round(Math.sin(xt)*it)},wt=Math.cos(xt)*a[2]/2,Mt=Math.sin(xt)*a[2]/2,St.tooltipPos=[a[0]+wt*.7,a[1]+Mt*.7],St.half=xt<-Math.PI/2||xt>Math.PI/2?1:0,St.angle=xt,gt=Math.min(nt,St.labelDistance/5),St.labelPosition={natural:{x:a[0]+wt+Math.cos(xt)*St.labelDistance,y:a[1]+Mt+Math.sin(xt)*St.labelDistance},final:{},alignment:St.labelDistance<0?"center":St.half?"right":"left",connectorPosition:{breakAt:{x:a[0]+wt+Math.cos(xt)*gt,y:a[1]+Mt+Math.sin(xt)*gt},touchingSliceAt:{x:a[0]+wt,y:a[1]+Mt}}}}fireEvent$o(k,"afterTranslate")},y.prototype.updateTotals=function(){var a=this.points,k=a.length,j=this.options.ignoreHiddenPoint,et,it,nt=0;for(et=0;et<k;et++)it=a[et],it.isValid()&&(!j||it.visible)&&(nt+=it.y);for(this.total=nt,et=0;et<k;et++)it=a[et],it.percentage=nt>0&&(it.visible||!j)?it.y/nt*100:0,it.total=nt},y.defaultOptions=merge$15(Series$f.defaultOptions,{center:[null,null],clip:!1,colorByPoint:!0,dataLabels:{allowOverlap:!0,connectorPadding:5,connectorShape:"fixedOffset",crookDistance:"70%",distance:30,enabled:!0,formatter:function(){return this.point.isNull?void 0:this.point.name},softConnector:!0,x:0},fillColor:void 0,ignoreHiddenPoint:!0,inactiveOtherPoints:!0,legendType:"point",marker:null,size:null,showInLegend:!1,slicedOffset:10,stickyTracking:!1,tooltip:{followPointer:!0},borderColor:palette.backgroundColor,borderWidth:1,lineWidth:void 0,states:{hover:{brightness:.1}}}),y})(Series$f);extend$1c(PieSeries$3.prototype,{axisTypes:[],directTouch:!0,drawGraph:void 0,drawLegendSymbol:LegendSymbol$1.drawRectangle,drawTracker:ColumnSeries$h.prototype.drawTracker,getCenter:centeredSeriesMixin.getCenter,getSymbol:noop$f,isCartesian:!1,noSharedTooltip:!0,pointAttribs:ColumnSeries$h.prototype.pointAttribs,pointClass:PiePoint$3,requireSorting:!1,searchPoint:noop$f,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("pie",PieSeries$3);var noop$e=H.noop,distribute$1=R.distribute,Series$d=SeriesRegistry$1.series,arrayMax$6=Utilities.arrayMax,clamp$d=Utilities.clamp,defined$E=Utilities.defined,merge$14=Utilities.merge,pick$1d=Utilities.pick,relativeLength$3=Utilities.relativeLength,ColumnDataLabel;(function(z){var y=[],a={radialDistributionY:function(nt){return nt.top+nt.distributeBox.pos},radialDistributionX:function(nt,ot,at,lt){return nt.getX(at<ot.top+2||at>ot.bottom-2?lt:at,ot.half,ot)},justify:function(nt,ot,at){return at[0]+(nt.half?-1:1)*(ot+nt.labelDistance)},alignToPlotEdges:function(nt,ot,at,lt){var ct=nt.getBBox().width;return ot?ct+lt:at-ct-lt},alignToConnectors:function(nt,ot,at,lt){var ct=0,ht;return nt.forEach(function(ut){ht=ut.dataLabel.getBBox().width,ht>ct&&(ct=ht)}),ot?ct+lt:at-ct-lt}};function k(nt){if(DataLabel$1.compose(Series$d),y.indexOf(nt)===-1){y.push(nt);var ot=nt.prototype;ot.dataLabelPositioners=a,ot.alignDataLabel=noop$e,ot.drawDataLabels=j,ot.placeDataLabels=et,ot.verifyDataLabelOverflow=it}}z.compose=k;function j(){var nt=this,ot=nt.data,at=nt.chart,lt=nt.options.dataLabels||{},ct=lt.connectorPadding,ht=at.plotWidth,ut=at.plotHeight,ft=at.plotLeft,vt=Math.round(at.chartWidth/3),gt=nt.center,mt=gt[2]/2,bt=gt[1],xt=[[],[]],wt=[0,0,0,0],Mt=nt.dataLabelPositioners,Et,St,kt,Pt,It,Nt,Ut,Rt,Ft,Dt,Ht,Gt;!nt.visible||!lt.enabled&&!nt._hasPointLabels||(ot.forEach(function(Yt){Yt.dataLabel&&Yt.visible&&Yt.dataLabel.shortened&&(Yt.dataLabel.attr({width:"auto"}).css({width:"auto",textOverflow:"clip"}),Yt.dataLabel.shortened=!1)}),Series$d.prototype.drawDataLabels.apply(nt),ot.forEach(function(Yt){Yt.dataLabel&&(Yt.visible?(xt[Yt.half].push(Yt),Yt.dataLabel._pos=null,!defined$E(lt.style.width)&&!defined$E(Yt.options.dataLabels&&Yt.options.dataLabels.style&&Yt.options.dataLabels.style.width)&&Yt.dataLabel.getBBox().width>vt&&(Yt.dataLabel.css({width:Math.round(vt*.7)+"px"}),Yt.dataLabel.shortened=!0)):(Yt.dataLabel=Yt.dataLabel.destroy(),Yt.dataLabels&&Yt.dataLabels.length===1&&delete Yt.dataLabels))}),xt.forEach(function(Yt,te){var he=Yt.length,ee=[],Xt,oe,le,ie,_e,Re;if(he)for(nt.sortByAngle(Yt,te-.5),nt.maxLabelDistance>0&&(Xt=Math.max(0,bt-mt-nt.maxLabelDistance),oe=Math.min(bt+mt+nt.maxLabelDistance,at.plotHeight),Yt.forEach(function(Ee){Ee.labelDistance>0&&Ee.dataLabel&&(Ee.top=Math.max(0,bt-mt-Ee.labelDistance),Ee.bottom=Math.min(bt+mt+Ee.labelDistance,at.plotHeight),_e=Ee.dataLabel.getBBox().height||21,Ee.distributeBox={target:Ee.labelPosition.natural.y-Ee.top+_e/2,size:_e,rank:Ee.y},ee.push(Ee.distributeBox))}),Re=oe+_e-Xt,distribute$1(ee,Re,Re/5)),Ht=0;Ht<he;Ht++){if(Et=Yt[Ht],Nt=Et.labelPosition,Pt=Et.dataLabel,Dt=Et.visible===!1?"hidden":"inherit",le=Nt.natural.y,Ft=le,ee&&defined$E(Et.distributeBox)&&(typeof Et.distributeBox.pos>"u"?Dt="hidden":(Ut=Et.distributeBox.size,Ft=Mt.radialDistributionY(Et))),delete Et.positionIndex,lt.justify)Rt=Mt.justify(Et,mt,gt);else switch(lt.alignTo){case"connectors":Rt=Mt.alignToConnectors(Yt,te,ht,ft);break;case"plotEdges":Rt=Mt.alignToPlotEdges(Pt,te,ht,ft);break;default:Rt=Mt.radialDistributionX(nt,Et,Ft,le)}Pt._attr={visibility:Dt,align:Nt.alignment},Gt=Et.options.dataLabels||{},Pt._pos={x:Rt+pick$1d(Gt.x,lt.x)+({left:ct,right:-ct}[Nt.alignment]||0),y:Ft+pick$1d(Gt.y,lt.y)-10},Nt.final.x=Rt,Nt.final.y=Ft,pick$1d(lt.crop,!0)&&(It=Pt.getBBox().width,ie=null,Rt-It<ct&&te===1?(ie=Math.round(It-Rt+ct),wt[3]=Math.max(ie,wt[3])):Rt+It>ht-ct&&te===0&&(ie=Math.round(Rt+It-ht+ct),wt[1]=Math.max(ie,wt[1])),Ft-Ut/2<0?wt[0]=Math.max(Math.round(-Ft+Ut/2),wt[0]):Ft+Ut/2>ut&&(wt[2]=Math.max(Math.round(Ft+Ut/2-ut),wt[2])),Pt.sideOverflow=ie)}}),(arrayMax$6(wt)===0||this.verifyDataLabelOverflow(wt))&&(this.placeDataLabels(),this.points.forEach(function(Yt){if(Gt=merge$14(lt,Yt.options.dataLabels),St=pick$1d(Gt.connectorWidth,1),St){var te=void 0;kt=Yt.connector,Pt=Yt.dataLabel,Pt&&Pt._pos&&Yt.visible&&Yt.labelDistance>0?(Dt=Pt._attr.visibility,te=!kt,te&&(Yt.connector=kt=at.renderer.path().addClass("highcharts-data-label-connector  highcharts-color-"+Yt.colorIndex+(Yt.className?" "+Yt.className:"")).add(nt.dataLabelsGroup),at.styledMode||kt.attr({"stroke-width":St,stroke:Gt.connectorColor||Yt.color||palette.neutralColor60})),kt[te?"attr":"animate"]({d:Yt.getConnectorPath()}),kt.attr("visibility",Dt)):kt&&(Yt.connector=kt.destroy())}})))}function et(){this.points.forEach(function(nt){var ot=nt.dataLabel,at;ot&&nt.visible&&(at=ot._pos,at?(ot.sideOverflow&&(ot._attr.width=Math.max(ot.getBBox().width-ot.sideOverflow,0),ot.css({width:ot._attr.width+"px",textOverflow:(this.options.dataLabels.style||{}).textOverflow||"ellipsis"}),ot.shortened=!0),ot.attr(ot._attr),ot[ot.moved?"animate":"attr"](at),ot.moved=!0):ot&&ot.attr({y:-9999})),delete nt.distributeBox},this)}function it(nt){var ot=this.center,at=this.options,lt=at.center,ct=at.minSize||80,ht=ct,ut=at.size!==null;return ut||(lt[0]!==null?ht=Math.max(ot[2]-Math.max(nt[1],nt[3]),ct):(ht=Math.max(ot[2]-nt[1]-nt[3],ct),ot[0]+=(nt[3]-nt[1])/2),lt[1]!==null?ht=clamp$d(ht,ct,ot[2]-Math.max(nt[0],nt[2])):(ht=clamp$d(ht,ct,ot[2]-nt[0]-nt[2]),ot[1]+=(nt[0]-nt[2])/2),ht<ot[2]?(ot[2]=ht,ot[3]=Math.min(relativeLength$3(at.innerSize||0,ht),ht),this.translate(ot),this.drawDataLabels&&this.drawDataLabels()):ut=!0),ut}})(ColumnDataLabel||(ColumnDataLabel={}));const PieDataLabel=ColumnDataLabel;var addEvent$U=Utilities.addEvent,fireEvent$n=Utilities.fireEvent,isArray$e=Utilities.isArray,isNumber$A=Utilities.isNumber,objectEach$i=Utilities.objectEach,pick$1c=Utilities.pick;addEvent$U(Chart$1,"render",function z(){var y=this,a=[];(this.labelCollectors||[]).forEach(function(k){a=a.concat(k())}),(this.yAxis||[]).forEach(function(k){k.stacking&&k.options.stackLabels&&!k.options.stackLabels.allowOverlap&&objectEach$i(k.stacking.stacks,function(j){objectEach$i(j,function(et){et.label&&et.label.visibility!=="hidden"&&a.push(et.label)})})}),(this.series||[]).forEach(function(k){var j=k.options.dataLabels;if(k.visible&&!(j.enabled===!1&&!k._hasPointLabels)){var et=function(it){return it.forEach(function(nt){if(nt.visible){var ot=isArray$e(nt.dataLabels)?nt.dataLabels:nt.dataLabel?[nt.dataLabel]:[];ot.forEach(function(at){var lt=at.options;at.labelrank=pick$1c(lt.labelrank,nt.labelrank,nt.shapeArgs&&nt.shapeArgs.height),lt.allowOverlap?(at.oldOpacity=at.opacity,at.newOpacity=1,hideOrShow(at,y)):a.push(at)})}})};et(k.nodes||[]),et(k.points)}}),this.hideOverlappingLabels(a)});Chart$1.prototype.hideOverlappingLabels=function(z){var y=this,a=z.length,k=y.renderer,j,et,it,nt,ot,at,lt,ct=!1,ht=function(ft,vt){return!(vt.x>=ft.x+ft.width||vt.x+vt.width<=ft.x||vt.y>=ft.y+ft.height||vt.y+vt.height<=ft.y)},ut=function(ft){var vt,gt,mt,bt=ft.box?0:ft.padding||0,xt=0,wt=0,Mt,Et;if(ft&&(!ft.alignAttr||ft.placed))return vt=ft.alignAttr||{x:ft.attr("x"),y:ft.attr("y")},gt=ft.parentGroup,ft.width||(mt=ft.getBBox(),ft.width=mt.width,ft.height=mt.height,xt=k.fontMetrics(null,ft.element).h),Mt=ft.width-2*bt,Et={left:"0",center:"0.5",right:"1"}[ft.alignValue],Et?wt=+Et*Mt:isNumber$A(ft.x)&&Math.round(ft.x)!==ft.translateX&&(wt=ft.x-ft.translateX),{x:vt.x+(gt.translateX||0)+bt-(wt||0),y:vt.y+(gt.translateY||0)+bt-xt,width:ft.width-2*bt,height:ft.height-2*bt}};for(et=0;et<a;et++)j=z[et],j&&(j.oldOpacity=j.opacity,j.newOpacity=1,j.absoluteBox=ut(j));for(z.sort(function(ft,vt){return(vt.labelrank||0)-(ft.labelrank||0)}),et=0;et<a;et++)for(nt=z[et],at=nt&&nt.absoluteBox,it=et+1;it<a;++it)ot=z[it],lt=ot&&ot.absoluteBox,at&&lt&&nt!==ot&&nt.newOpacity!==0&&ot.newOpacity!==0&&ht(at,lt)&&((nt.labelrank<ot.labelrank?nt:ot).newOpacity=0);z.forEach(function(ft){hideOrShow(ft,y)&&(ct=!0)}),ct&&fireEvent$n(y,"afterHideAllOverlappingLabels")};function hideOrShow(z,y){var a,k,j=!1;return z&&(k=z.newOpacity,z.oldOpacity!==k&&(z.alignAttr&&z.placed?(z[k?"removeClass":"addClass"]("highcharts-data-label-hidden"),a=function(){y.styledMode||z.css({pointerEvents:k?"auto":"none"})},j=!0,z.alignAttr.opacity=k,z[z.isOld?"animate":"attr"](z.alignAttr,null,a),fireEvent$n(y,"afterHideOverlappingLabel")):z.attr({opacity:k})),z.isOld=!0),j}var extend$1b=Utilities.extend,find$g=Utilities.find,isArray$d=Utilities.isArray,isObject$b=Utilities.isObject,merge$13=Utilities.merge,objectEach$h=Utilities.objectEach,pick$1b=Utilities.pick,splat$c=Utilities.splat,uniqueKey$3=Utilities.uniqueKey,Responsive;(function(z){var y=[];function a(j){return y.indexOf(j)===-1&&(y.push(j),extend$1b(j.prototype,k.prototype)),j}z.compose=a;var k=(function(){function j(){}return j.prototype.currentOptions=function(et){var it=this,nt={};function ot(at,lt,ct,ht){var ut;objectEach$h(at,function(ft,vt){if(!ht&&it.collectionsWithUpdate.indexOf(vt)>-1&&lt[vt])for(ft=splat$c(ft),ct[vt]=[],ut=0;ut<Math.max(ft.length,lt[vt].length);ut++)lt[vt][ut]&&(ft[ut]===void 0?ct[vt][ut]=lt[vt][ut]:(ct[vt][ut]={},ot(ft[ut],lt[vt][ut],ct[vt][ut],ht+1)));else isObject$b(ft)?(ct[vt]=isArray$d(ft)?[]:{},ot(ft,lt[vt]||{},ct[vt],ht+1)):typeof lt[vt]>"u"?ct[vt]=null:ct[vt]=lt[vt]})}return ot(et,this.options,nt,0),nt},j.prototype.matchResponsiveRule=function(et,it){var nt=et.condition,ot=nt.callback||function(){return this.chartWidth<=pick$1b(nt.maxWidth,Number.MAX_VALUE)&&this.chartHeight<=pick$1b(nt.maxHeight,Number.MAX_VALUE)&&this.chartWidth>=pick$1b(nt.minWidth,0)&&this.chartHeight>=pick$1b(nt.minHeight,0)};ot.call(this)&&it.push(et._id)},j.prototype.setResponsive=function(et,it){var nt=this,ot=this.options.responsive,at=this.currentResponsive,lt=[],ct;!it&&ot&&ot.rules&&ot.rules.forEach(function(ft){typeof ft._id>"u"&&(ft._id=uniqueKey$3()),nt.matchResponsiveRule(ft,lt)},this);var ht=merge$13.apply(void 0,lt.map(function(ft){return find$g((ot||{}).rules||[],function(vt){return vt._id===ft})}).map(function(ft){return ft&&ft.chartOptions}));ht.isResponsiveOptions=!0,lt=lt.toString()||void 0;var ut=at&&at.ruleIds;lt!==ut&&(at&&this.update(at.undoOptions,et,!0),lt?(ct=this.currentOptions(ht),ct.isResponsiveOptions=!0,this.currentResponsive={ruleIds:lt,mergedOptions:ht,undoOptions:ct},this.update(ht,et,!0)):this.currentResponsive=void 0)},j})()})(Responsive||(Responsive={}));const Responsive$1=Responsive;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$8=H;G$8.animate=animationExports.animate;G$8.animObject=animationExports.animObject;G$8.getDeferredAnimation=animationExports.getDeferredAnimation;G$8.setAnimation=animationExports.setAnimation;G$8.stop=animationExports.stop;G$8.timers=Fx.timers;G$8.AST=AST;G$8.Axis=Axis;G$8.Chart=Chart$1;G$8.chart=Chart$1.chart;G$8.Fx=Fx;G$8.Legend=Legend;G$8.PlotLineOrBand=PlotLineOrBand;G$8.Point=Point$4;G$8.Pointer=MSPointer.isRequired()?MSPointer:Pointer;G$8.Series=Series$f;G$8.SVGElement=SVGElement;G$8.SVGRenderer=SVGRenderer;G$8.Tick=Tick;G$8.Time=Time;G$8.Tooltip=Tooltip;G$8.Color=Color;G$8.color=Color.parse;HTMLRenderer.compose(SVGRenderer);HTMLElement$1.compose(SVGElement);G$8.defaultOptions=DefaultOptions.defaultOptions;G$8.getOptions=DefaultOptions.getOptions;G$8.time=DefaultOptions.defaultTime;G$8.setOptions=DefaultOptions.setOptions;G$8.dateFormat=FormatUtilities.dateFormat;G$8.format=FormatUtilities.format;G$8.numberFormat=FormatUtilities.numberFormat;G$8.addEvent=Utilities.addEvent;G$8.arrayMax=Utilities.arrayMax;G$8.arrayMin=Utilities.arrayMin;G$8.attr=Utilities.attr;G$8.clearTimeout=Utilities.clearTimeout;G$8.correctFloat=Utilities.correctFloat;G$8.createElement=Utilities.createElement;G$8.css=Utilities.css;G$8.defined=Utilities.defined;G$8.destroyObjectProperties=Utilities.destroyObjectProperties;G$8.discardElement=Utilities.discardElement;G$8.distribute=R.distribute;G$8.erase=Utilities.erase;G$8.error=Utilities.error;G$8.extend=Utilities.extend;G$8.extendClass=Utilities.extendClass;G$8.find=Utilities.find;G$8.fireEvent=Utilities.fireEvent;G$8.getMagnitude=Utilities.getMagnitude;G$8.getStyle=Utilities.getStyle;G$8.inArray=Utilities.inArray;G$8.isArray=Utilities.isArray;G$8.isClass=Utilities.isClass;G$8.isDOMElement=Utilities.isDOMElement;G$8.isFunction=Utilities.isFunction;G$8.isNumber=Utilities.isNumber;G$8.isObject=Utilities.isObject;G$8.isString=Utilities.isString;G$8.keys=Utilities.keys;G$8.merge=Utilities.merge;G$8.normalizeTickInterval=Utilities.normalizeTickInterval;G$8.objectEach=Utilities.objectEach;G$8.offset=Utilities.offset;G$8.pad=Utilities.pad;G$8.pick=Utilities.pick;G$8.pInt=Utilities.pInt;G$8.relativeLength=Utilities.relativeLength;G$8.removeEvent=Utilities.removeEvent;G$8.seriesType=SeriesRegistry$1.seriesType;G$8.splat=Utilities.splat;G$8.stableSort=Utilities.stableSort;G$8.syncTimeout=Utilities.syncTimeout;G$8.timeUnits=Utilities.timeUnits;G$8.uniqueKey=Utilities.uniqueKey;G$8.useSerialIds=Utilities.useSerialIds;G$8.wrap=Utilities.wrap;ColumnDataLabel$2.compose(ColumnSeries$h);DataLabel$1.compose(Series$f);DateTimeAxis$1.compose(Axis);LogarithmicAxis$1.compose(Axis);PieDataLabel.compose(PieSeries$3);PlotLineOrBand.compose(Axis);Responsive$1.compose(Chart$1);var addEvent$T=Utilities.addEvent,correctFloat$8=Utilities.correctFloat,css$3=Utilities.css,defined$D=Utilities.defined,error$5=Utilities.error,pick$1a=Utilities.pick,timeUnits$1=Utilities.timeUnits,composedClasses=[],OrdinalAxis;(function(z){function y(ft,vt,gt){if(composedClasses.indexOf(ft)===-1){composedClasses.push(ft);var mt=ft.prototype;mt.getTimeTicks=a,mt.index2val=k,mt.lin2val=j,mt.val2lin=ht,mt.ordinal2lin=mt.val2lin,addEvent$T(ft,"afterInit",it),addEvent$T(ft,"foundExtremes",nt),addEvent$T(ft,"afterSetScale",ot),addEvent$T(ft,"initialAxisTranslation",at)}return composedClasses.indexOf(gt)===-1&&(composedClasses.push(gt),addEvent$T(gt,"pan",lt)),composedClasses.indexOf(vt)===-1&&(composedClasses.push(vt),addEvent$T(vt,"updatedData",ct)),ft}z.compose=y;function a(ft,vt,gt,mt,bt,xt,wt){bt===void 0&&(bt=[]),xt===void 0&&(xt=0);var Mt={},Et=this.options.tickPixelInterval,St=this.chart.time,kt=[],Pt,It,Nt,Ut,Rt,Ft=0,Dt=[],Ht=-Number.MAX_VALUE;if(!this.options.ordinal&&!this.options.breaks||!bt||bt.length<3||typeof vt>"u")return St.getTimeTicks.apply(St,arguments);var Gt=bt.length;for(Pt=0;Pt<Gt;Pt++){if(Rt=Pt&&bt[Pt-1]>gt,bt[Pt]<vt&&(Ft=Pt),Pt===Gt-1||bt[Pt+1]-bt[Pt]>xt*5||Rt){if(bt[Pt]>Ht){for(It=St.getTimeTicks(ft,bt[Ft],bt[Pt],mt);It.length&&It[0]<=Ht;)It.shift();It.length&&(Ht=It[It.length-1]),kt.push(Dt.length),Dt=Dt.concat(It)}Ft=Pt+1}if(Rt)break}if(It){if(Ut=It.info,wt&&Ut.unitRange<=timeUnits$1.hour){for(Pt=Dt.length-1,Ft=1;Ft<Pt;Ft++)St.dateFormat("%d",Dt[Ft])!==St.dateFormat("%d",Dt[Ft-1])&&(Mt[Dt[Ft]]="day",Nt=!0);Nt&&(Mt[Dt[0]]="day"),Ut.higherRanks=Mt}Ut.segmentStarts=kt,Dt.info=Ut}else error$5(12,!1,this.chart);if(wt&&defined$D(Et)){for(var Yt=Dt.length,te=[],he=[],ee=void 0,Xt=void 0,oe=void 0,le=void 0,ie=void 0,_e=Yt;_e--;)Xt=this.translate(Dt[_e]),oe&&(he[_e]=oe-Xt),te[_e]=oe=Xt;for(he.sort(),le=he[Math.floor(he.length/2)],le<Et*.6&&(le=null),_e=Dt[Yt-1]>gt?Yt-1:Yt,oe=void 0;_e--;)Xt=te[_e],ie=Math.abs(oe-Xt),oe&&ie<Et*.8&&(le===null||ie<le*.8)?(Mt[Dt[_e]]&&!Mt[Dt[_e+1]]?(ee=_e+1,oe=Xt):ee=_e,Dt.splice(ee,1)):oe=Xt}return Dt}function k(ft){var vt=this,gt=vt.ordinal,mt=gt.positions;if(!mt)return ft;var bt=mt.length-1,xt;return ft<0?ft=mt[0]:ft>bt?ft=mt[bt]:(bt=Math.floor(ft),xt=ft-bt),typeof xt<"u"&&typeof mt[bt]<"u"?mt[bt]+(xt?xt*(mt[bt+1]-mt[bt]):0):ft}function j(ft){var vt=this,gt=vt.ordinal,mt=vt.old?vt.old.min:vt.min,bt=vt.old?vt.old.transA:vt.transA,xt=gt.positions;if(!xt)return ft;var wt=(ft-mt)*bt+vt.minPixelPadding,Mt=wt>0&&wt<vt.left+vt.len;if(Mt||(gt.extendedOrdinalPositions||(gt.extendedOrdinalPositions=gt.getExtendedPositions()),xt=gt.extendedOrdinalPositions),xt&&xt.length){var Et=gt.getIndexOfPoint(wt,xt),St=correctFloat$8(Et%1);if(Et>=0&&Et<xt.length){var kt=xt[Math.floor(Et)],Pt=xt[Math.ceil(Et)],It=Pt-kt;return xt[Math.floor(Et)]+St*It}var Nt=xt.length,Ut=xt[0],Rt=xt[Nt-1],Ft=(Rt-Ut)/(Nt-1);return Et<0?Ut+Ft*Et:Rt+Ft*(Et-Nt)}return ft}function et(ft,vt){var gt=z.Additions.findIndexOf(ft,vt,!0);if(ft[gt]===vt)return gt;var mt=(vt-ft[gt])/(ft[gt+1]-ft[gt]);return gt+mt}function it(){var ft=this;ft.ordinal||(ft.ordinal=new z.Additions(ft))}function nt(){var ft=this;ft.isXAxis&&defined$D(ft.options.overscroll)&&ft.max===ft.dataMax&&(!ft.chart.mouseIsDown||ft.isInternal)&&(!ft.eventArgs||ft.eventArgs&&ft.eventArgs.trigger!=="navigator")&&(ft.max+=ft.options.overscroll,!ft.isInternal&&defined$D(ft.userMin)&&(ft.min+=ft.options.overscroll))}function ot(){var ft=this;ft.horiz&&!ft.isDirty&&(ft.isDirty=ft.isOrdinal&&ft.chart.navigator&&!ft.chart.navigator.adaptToUpdatedData)}function at(){var ft=this;ft.ordinal&&(ft.ordinal.beforeSetTickPositions(),ft.tickInterval=ft.ordinal.postProcessTickInterval(ft.tickInterval))}function lt(ft){var vt=this,gt=vt.xAxis[0],mt=gt.options.overscroll,bt=ft.originalEvent.chartX,xt=vt.options.chart.panning,wt=!1;if(xt&&xt.type!=="y"&&gt.options.ordinal&&gt.series.length){var Mt=vt.mouseDownX,Et=gt.getExtremes(),St=Et.dataMax,kt=Et.min,Pt=Et.max,It=vt.hoverPoints,Nt=gt.closestPointRange||gt.ordinal&&gt.ordinal.overscrollPointsRange,Ut=gt.translationSlope*(gt.ordinal.slope||Nt),Rt=(Mt-bt)/Ut,Ft={ordinal:{positions:gt.ordinal.getExtendedPositions()}},Dt=gt.index2val,Ht=gt.val2lin,Gt=void 0,Yt=void 0,te=void 0,he=void 0;Ft.ordinal.positions?Math.abs(Rt)>1&&(It&&It.forEach(function(ee){ee.setState()}),Rt<0?(te=Ft,he=gt.ordinal.positions?gt:Ft):(te=gt.ordinal.positions?gt:Ft,he=Ft),Yt=he.ordinal.positions,St>Yt[Yt.length-1]&&Yt.push(St),vt.fixedRange=Pt-kt,Gt=gt.navigatorAxis.toFixedRange(null,null,Dt.apply(te,[Ht.apply(te,[kt,!0])+Rt]),Dt.apply(he,[Ht.apply(he,[Pt,!0])+Rt])),Gt.min>=Math.min(Et.dataMin,kt)&&Gt.max<=Math.max(St,Pt)+mt&&gt.setExtremes(Gt.min,Gt.max,!0,!1,{trigger:"pan"}),vt.mouseDownX=bt,css$3(vt.container,{cursor:"move"})):wt=!0}else wt=!0;wt||xt&&/y/.test(xt.type)?mt&&(gt.max=gt.dataMax+mt):ft.preventDefault()}function ct(){var ft=this.xAxis;ft&&ft.options.ordinal&&(delete ft.ordinal.index,delete ft.ordinal.extendedOrdinalPositions)}function ht(ft,vt){var gt=this,mt=gt.ordinal,bt=mt.positions,xt=mt.slope,wt=mt.extendedOrdinalPositions;if(!bt)return ft;var Mt=bt.length,Et;if(bt[0]<=ft&&bt[Mt-1]>=ft)Et=et(bt,ft);else{if(wt||(wt=mt.getExtendedPositions&&mt.getExtendedPositions(),mt.extendedOrdinalPositions=wt),!(wt&&wt.length))return ft;var St=wt.length;xt||(xt=(wt[St-1]-wt[0])/St);var kt=et(wt,bt[0]);if(ft>=wt[0]&&ft<=wt[St-1])Et=et(wt,ft)-kt;else if(ft<wt[0]){var Pt=wt[0]-ft,It=Pt/xt;Et=-kt-It}else{var Pt=ft-wt[St-1],It=Pt/xt;Et=It+St-kt}}return vt?Et:xt*(Et||0)+mt.offset}var ut=(function(){function ft(vt){this.index={},this.axis=vt}return ft.prototype.beforeSetTickPositions=function(){var vt=this.axis,gt=vt.ordinal,mt=vt.getExtremes(),bt=mt.min,xt=mt.max,wt=vt.isXAxis&&!!vt.options.breaks,Mt=vt.options.ordinal,Et=vt.chart.options.chart.ignoreHiddenSeries,St,kt,Pt,It,Nt,Ut,Rt,Ft,Dt=[],Ht=Number.MAX_VALUE,Gt=!1;if(Mt||wt){if(vt.series.forEach(function(Yt,te){if(kt=[],(!Et||Yt.visible!==!1)&&(Yt.takeOrdinalPosition!==!1||wt)&&(Dt=Dt.concat(Yt.processedXData),St=Dt.length,Dt.sort(function(he,ee){return he-ee}),Ht=Math.min(Ht,pick$1a(Yt.closestPointRange,Ht)),St)){for(te=0;te<St-1;)Dt[te]!==Dt[te+1]&&kt.push(Dt[te+1]),te++;kt[0]!==Dt[0]&&kt.unshift(Dt[0]),Dt=kt}Yt.isSeriesBoosting&&(Ft=!0)}),Ft&&(Dt.length=0),St=Dt.length,St>2){for(Pt=Dt[1]-Dt[0],Rt=St-1;Rt--&&!Gt;)Dt[Rt+1]-Dt[Rt]!==Pt&&(Gt=!0);!vt.options.keepOrdinalPadding&&(Dt[0]-bt>Pt||xt-Dt[Dt.length-1]>Pt)&&(Gt=!0)}else vt.options.overscroll&&(St===2?Ht=Dt[1]-Dt[0]:St===1?(Ht=vt.options.overscroll,Dt=[Dt[0],Dt[0]+Ht]):Ht=gt.overscrollPointsRange);Gt||vt.forceOrdinal?(vt.options.overscroll&&(gt.overscrollPointsRange=Ht,Dt=Dt.concat(gt.getOverscrollPositions())),gt.positions=Dt,It=vt.ordinal2lin(Math.max(bt,Dt[0]),!0),Nt=Math.max(vt.ordinal2lin(Math.min(xt,Dt[Dt.length-1]),!0),1),gt.slope=Ut=(xt-bt)/(Nt-It),gt.offset=bt-It*Ut):(gt.overscrollPointsRange=pick$1a(vt.closestPointRange,gt.overscrollPointsRange),gt.positions=vt.ordinal.slope=gt.offset=void 0)}vt.isOrdinal=Mt&&Gt,gt.groupIntervalFactor=null},ft.findIndexOf=function(vt,gt,mt){for(var bt=0,xt=vt.length-1,wt;bt<xt;)wt=Math.ceil((bt+xt)/2),vt[wt]<=gt?bt=wt:xt=wt-1;return vt[bt]===gt||mt?bt:-1},ft.prototype.getExtendedPositions=function(){var vt=this,gt=vt.axis,mt=gt.constructor.prototype,bt=gt.chart,xt=gt.series[0].currentDataGrouping,wt=xt?xt.count+xt.unitName:"raw",Mt=gt.options.overscroll,Et=gt.getExtremes(),St,kt=void 0,Pt=vt.index;return Pt||(Pt=vt.index={}),Pt[wt]||(St={series:[],chart:bt,forceOrdinal:!1,getExtremes:function(){return{min:Et.dataMin,max:Et.dataMax+Mt}},getGroupPixelWidth:mt.getGroupPixelWidth,getTimeTicks:mt.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},ordinal2lin:mt.ordinal2lin,getIndexOfPoint:mt.getIndexOfPoint,val2lin:mt.val2lin},St.ordinal.axis=St,gt.series.forEach(function(It){kt={xAxis:St,xData:It.xData.slice(),chart:bt,destroyGroupedData:H.noop,getProcessedData:Series$f.prototype.getProcessedData,applyGrouping:Series$f.prototype.applyGrouping},kt.xData=kt.xData.concat(vt.getOverscrollPositions()),kt.options={dataGrouping:xt?{firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",enabled:!0,forced:!0,approximation:"open",units:[[xt.unitName,[xt.count]]]}:{enabled:!1}},St.series.push(kt),It.processData.apply(kt)}),gt.applyGrouping.call(St),kt.closestPointRange!==kt.basePointRange&&kt.currentDataGrouping&&(St.forceOrdinal=!0),gt.ordinal.beforeSetTickPositions.apply({axis:St}),Pt[wt]=St.ordinal.positions),Pt[wt]},ft.prototype.getGroupIntervalFactor=function(vt,gt,mt){var bt=this;bt.axis;var xt=mt.processedXData,wt=xt.length,Mt=[],Et,St,kt=bt.groupIntervalFactor;if(!kt){for(St=0;St<wt-1;St++)Mt[St]=xt[St+1]-xt[St];Mt.sort(function(Pt,It){return Pt-It}),Et=Mt[Math.floor(wt/2)],vt=Math.max(vt,xt[0]),gt=Math.min(gt,xt[wt-1]),bt.groupIntervalFactor=kt=wt*Et/(gt-vt)}return kt},ft.prototype.getIndexOfPoint=function(vt,gt){var mt=this,bt=mt.axis,xt=mt.positions?mt.positions[0]:0,wt=bt.series[0].points&&bt.series[0].points[0]&&bt.series[0].points[0].plotX||bt.minPixelPadding;bt.series.length>1&&bt.series.forEach(function(St){defined$D(St.points[0])&&defined$D(St.points[0].plotX)&&St.points[0].plotX<wt&&(wt=St.points[0].plotX)});var Mt=bt.translationSlope*(mt.slope||bt.closestPointRange||mt.overscrollPointsRange),Et=(vt-wt)/Mt;return ft.findIndexOf(gt,xt)+Et},ft.prototype.getOverscrollPositions=function(){var vt=this,gt=vt.axis,mt=gt.options.overscroll,bt=vt.overscrollPointsRange,xt=[],wt=gt.dataMax;if(defined$D(bt))for(;wt<=gt.dataMax+mt;)wt+=bt,xt.push(wt);return xt},ft.prototype.postProcessTickInterval=function(vt){var gt=this,mt=gt.axis,bt=gt.slope,xt;return bt?mt.options.breaks?xt=mt.closestPointRange||vt:xt=vt/(bt/mt.closestPointRange):xt=vt,xt},ft})();z.Additions=ut})(OrdinalAxis||(OrdinalAxis={}));const OrdinalAxis$1=OrdinalAxis;var addEvent$S=Utilities.addEvent,find$f=Utilities.find,fireEvent$m=Utilities.fireEvent,isArray$c=Utilities.isArray,isNumber$z=Utilities.isNumber,pick$19=Utilities.pick,BrokenAxis;(function(z){var y=[];function a(ht,ut){if(y.indexOf(ht)===-1&&(y.push(ht),ht.keepProps.push("brokenAxis"),addEvent$S(ht,"init",it),addEvent$S(ht,"afterInit",k),addEvent$S(ht,"afterSetTickPositions",et),addEvent$S(ht,"afterSetOptions",j)),y.indexOf(ut)===-1){y.push(ut);var ft=ut.prototype;ft.drawBreaks=at,ft.gappedPath=lt,addEvent$S(ut,"afterGeneratePoints",nt),addEvent$S(ut,"afterRender",ot)}return ht}z.compose=a;function k(){typeof this.brokenAxis<"u"&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function j(){var ht=this;ht.brokenAxis&&ht.brokenAxis.hasBreaks&&(ht.options.ordinal=!1)}function et(){var ht=this,ut=ht.brokenAxis;if(ut&&ut.hasBreaks){for(var ft=ht.tickPositions,vt=ht.tickPositions.info,gt=[],mt=0;mt<ft.length;mt++)ut.isInAnyBreak(ft[mt])||gt.push(ft[mt]);ht.tickPositions=gt,ht.tickPositions.info=vt}}function it(){var ht=this;ht.brokenAxis||(ht.brokenAxis=new ct(ht))}function nt(){var ht=this,ut=ht.isDirty,ft=ht.options.connectNulls,vt=ht.points,gt=ht.xAxis,mt=ht.yAxis;if(ut)for(var bt=vt.length;bt--;){var xt=vt[bt],wt=xt.y===null&&ft===!1,Mt=!wt&&(gt&&gt.brokenAxis&&gt.brokenAxis.isInAnyBreak(xt.x,!0)||mt&&mt.brokenAxis&&mt.brokenAxis.isInAnyBreak(xt.y,!0));xt.visible=Mt?!1:xt.options.visible!==!1}}function ot(){this.drawBreaks(this.xAxis,["x"]),this.drawBreaks(this.yAxis,pick$19(this.pointArrayMap,["y"]))}function at(ht,ut){var ft=this,vt=ft.points,gt,mt,bt,xt;if(ht&&ht.brokenAxis&&ht.brokenAxis.hasBreaks){var wt=ht.brokenAxis;ut.forEach(function(Mt){gt=wt&&wt.breakArray||[],mt=ht.isXAxis?ht.min:pick$19(ft.options.threshold,ht.min),vt.forEach(function(Et){xt=pick$19(Et["stack"+Mt.toUpperCase()],Et[Mt]),gt.forEach(function(St){isNumber$z(mt)&&isNumber$z(xt)&&(bt=!1,mt<St.from&&xt>St.to||mt>St.from&&xt<St.from?bt="pointBreak":(mt<St.from&&xt>St.from&&xt<St.to||mt>St.from&&xt>St.to&&xt<St.from)&&(bt="pointInBreak"),bt&&fireEvent$m(ht,bt,{point:Et,brk:St}))})})})}}function lt(){var ht=this.currentDataGrouping,ut=ht&&ht.gapSize,ft=this.points.slice(),vt=this.yAxis,gt=this.options.gapSize,mt=ft.length-1,bt;if(gt&&mt>0){this.options.gapUnit!=="value"&&(gt*=this.basePointRange),ut&&ut>gt&&ut>=this.basePointRange&&(gt=ut);for(var xt=void 0,wt=void 0;mt--;)if(wt&&wt.visible!==!1||(wt=ft[mt+1]),xt=ft[mt],!(wt.visible===!1||xt.visible===!1)){if(wt.x-xt.x>gt){var Mt=(xt.x+wt.x)/2;ft.splice(mt+1,0,{isNull:!0,x:Mt}),vt.stacking&&this.options.stacking&&(bt=vt.stacking.stacks[this.stackKey][Mt]=new StackItem$1(vt,vt.options.stackLabels,!1,Mt,this.stack),bt.total=0)}wt=xt}}return this.getGraphPath(ft)}var ct=(function(){function ht(ut){this.hasBreaks=!1,this.axis=ut}return ht.isInBreak=function(ut,ft){var vt=ut.repeat||1/0,gt=ut.from,mt=ut.to-ut.from,bt=ft>=gt?(ft-gt)%vt:vt-(gt-ft)%vt,xt;return ut.inclusive?xt=bt<=mt:xt=bt<mt&&bt!==0,xt},ht.lin2Val=function(ut){var ft=this,vt=ft.brokenAxis,gt=vt&&vt.breakArray;if(!gt||!isNumber$z(ut))return ut;var mt=ut,bt,xt;for(xt=0;xt<gt.length&&(bt=gt[xt],!(bt.from>=mt));xt++)(bt.to<mt||ht.isInBreak(bt,mt))&&(mt+=bt.len);return mt},ht.val2Lin=function(ut){var ft=this,vt=ft.brokenAxis,gt=vt&&vt.breakArray;if(!gt||!isNumber$z(ut))return ut;var mt=ut,bt,xt;for(xt=0;xt<gt.length;xt++)if(bt=gt[xt],bt.to<=ut)mt-=bt.len;else{if(bt.from>=ut)break;if(ht.isInBreak(bt,ut)){mt-=ut-bt.from;break}}return mt},ht.prototype.findBreakAt=function(ut,ft){return find$f(ft,function(vt){return vt.from<ut&&ut<vt.to})},ht.prototype.isInAnyBreak=function(ut,ft){var vt=this,gt=vt.axis,mt=gt.options.breaks||[],bt=mt.length,xt,wt,Mt;if(bt&&isNumber$z(ut)){for(;bt--;)ht.isInBreak(mt[bt],ut)&&(xt=!0,wt||(wt=pick$19(mt[bt].showPoints,!gt.isXAxis)));xt&&ft?Mt=xt&&!wt:Mt=xt}return Mt},ht.prototype.setBreaks=function(ut,ft){var vt=this,gt=vt.axis,mt=isArray$c(ut)&&!!ut.length;gt.isDirty=vt.hasBreaks!==mt,vt.hasBreaks=mt,gt.options.breaks=gt.userOptions.breaks=ut,gt.forceRedraw=!0,gt.series.forEach(function(bt){bt.isDirty=!0}),!mt&&gt.val2lin===ht.val2Lin&&(delete gt.val2lin,delete gt.lin2val),mt&&(gt.userOptions.ordinal=!1,gt.lin2val=ht.lin2Val,gt.val2lin=ht.val2Lin,gt.setExtremes=function(bt,xt,wt,Mt,Et){if(vt.hasBreaks){for(var St=this.options.breaks||[],kt=void 0;kt=vt.findBreakAt(bt,St);)bt=kt.to;for(;kt=vt.findBreakAt(xt,St);)xt=kt.from;xt<bt&&(xt=bt)}gt.constructor.prototype.setExtremes.call(this,bt,xt,wt,Mt,Et)},gt.setAxisTranslation=function(){if(gt.constructor.prototype.setAxisTranslation.call(this),vt.unitLength=void 0,vt.hasBreaks){var bt=gt.options.breaks||[],xt=[],wt=[],Mt=pick$19(gt.pointRangePadding,0),Et=0,St,kt,Pt=gt.userMin||gt.min,It=gt.userMax||gt.max,Nt,Ut;bt.forEach(function(Rt){kt=Rt.repeat||1/0,isNumber$z(Pt)&&isNumber$z(It)&&(ht.isInBreak(Rt,Pt)&&(Pt+=Rt.to%kt-Pt%kt),ht.isInBreak(Rt,It)&&(It-=It%kt-Rt.from%kt))}),bt.forEach(function(Rt){if(Nt=Rt.from,kt=Rt.repeat||1/0,isNumber$z(Pt)&&isNumber$z(It)){for(;Nt-kt>Pt;)Nt-=kt;for(;Nt<Pt;)Nt+=kt;for(Ut=Nt;Ut<It;Ut+=kt)xt.push({value:Ut,move:"in"}),xt.push({value:Ut+Rt.to-Rt.from,move:"out",size:Rt.breakSize})}}),xt.sort(function(Rt,Ft){return Rt.value===Ft.value?(Rt.move==="in"?0:1)-(Ft.move==="in"?0:1):Rt.value-Ft.value}),St=0,Nt=Pt,xt.forEach(function(Rt){St+=Rt.move==="in"?1:-1,St===1&&Rt.move==="in"&&(Nt=Rt.value),St===0&&isNumber$z(Nt)&&(wt.push({from:Nt,to:Rt.value,len:Rt.value-Nt-(Rt.size||0)}),Et+=Rt.value-Nt-(Rt.size||0))}),vt.breakArray=wt,isNumber$z(Pt)&&isNumber$z(It)&&isNumber$z(gt.min)&&(vt.unitLength=It-Pt-Et+Mt,fireEvent$m(gt,"afterBreaks"),gt.staticScale?gt.transA=gt.staticScale:vt.unitLength&&(gt.transA*=(It-gt.min+Mt)/vt.unitLength),Mt&&(gt.minPixelPadding=gt.transA*(gt.minPointOffset||0)),gt.min=Pt,gt.max=It)}}),pick$19(ft,!0)&&gt.chart.redraw()},ht})();z.Additions=ct})(BrokenAxis||(BrokenAxis={}));const BrokenAxis$1=BrokenAxis;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/broken-axis
 * @requires highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$7=H;BrokenAxis$1.compose(G$7.Axis,G$7.Series);var format$8=FormatUtilities.format,seriesProto$3=Series$f.prototype,addEvent$R=Utilities.addEvent,arrayMax$5=Utilities.arrayMax,arrayMin$5=Utilities.arrayMin,correctFloat$7=Utilities.correctFloat,defined$C=Utilities.defined,error$4=Utilities.error,extend$1a=Utilities.extend,isNumber$y=Utilities.isNumber,merge$12=Utilities.merge,pick$18=Utilities.pick,approximations=H.approximations={sum:function(z){var y=z.length,a;if(!y&&z.hasNulls)a=null;else if(y)for(a=0;y--;)a+=z[y];return a},average:function(z){var y=z.length,a=approximations.sum(z);return isNumber$y(a)&&y&&(a=correctFloat$7(a/y)),a},averages:function(){var z=[];return[].forEach.call(arguments,function(y){z.push(approximations.average(y))}),typeof z[0]>"u"?void 0:z},open:function(z){return z.length?z[0]:z.hasNulls?null:void 0},high:function(z){return z.length?arrayMax$5(z):z.hasNulls?null:void 0},low:function(z){return z.length?arrayMin$5(z):z.hasNulls?null:void 0},close:function(z){return z.length?z[z.length-1]:z.hasNulls?null:void 0},ohlc:function(z,y,a,k){if(z=approximations.open(z),y=approximations.high(y),a=approximations.low(a),k=approximations.close(k),isNumber$y(z)||isNumber$y(y)||isNumber$y(a)||isNumber$y(k))return[z,y,a,k]},range:function(z,y){if(z=approximations.low(z),y=approximations.high(y),isNumber$y(z)||isNumber$y(y))return[z,y];if(z===null&&y===null)return null}},applyGrouping=function(){var z=this,y=z.chart,a=z.options,k=a.dataGrouping,j=z.allowDG!==!1&&k&&pick$18(k.enabled,y.options.isStock),et=z.visible||!y.options.chart.ignoreHiddenSeries,it,nt,ot=this.currentDataGrouping,at,lt,ct=!1;if(j&&!z.requireSorting&&(z.requireSorting=ct=!0),nt=skipDataGrouping(z)||!j,ct&&(z.requireSorting=!1),!nt){z.destroyGroupedData();var ht=void 0,ut=k.groupAll?z.xData:z.processedXData,ft=k.groupAll?z.yData:z.processedYData,vt=y.plotSizeX,gt=z.xAxis,mt=gt.options.ordinal,bt=z.groupPixelWidth;if(bt&&ut&&ut.length){it=!0,z.isDirty=!0,z.points=null;var xt=gt.getExtremes(),wt=xt.min,Mt=xt.max,Et=mt&&gt.ordinal&&gt.ordinal.getGroupIntervalFactor(wt,Mt,z)||1,St=bt*(Mt-wt)/vt*Et,kt=gt.getTimeTicks(DateTimeAxis$1.Additions.prototype.normalizeTimeTickInterval(St,k.units||defaultDataGroupingUnits),Math.min(wt,ut[0]),Math.max(Mt,ut[ut.length-1]),gt.options.startOfWeek,ut,z.closestPointRange),Pt=seriesProto$3.groupData.apply(z,[ut,ft,kt,k.approximation]),It=Pt.groupedXData,Nt=Pt.groupedYData,Ut=0;for(k&&k.smoothed&&It.length&&(k.firstAnchor="firstPoint",k.anchor="middle",k.lastAnchor="lastPoint",error$4(32,!1,y,{"dataGrouping.smoothed":"use dataGrouping.anchor"})),anchorPoints(z,It,Mt),ht=1;ht<kt.length;ht++)(!kt.info.segmentStarts||kt.info.segmentStarts.indexOf(ht)===-1)&&(Ut=Math.max(kt[ht]-kt[ht-1],Ut));at=kt.info,at.gapSize=Ut,z.closestPointRange=kt.info.totalRange,z.groupMap=Pt.groupMap,et&&adjustExtremes(gt,It),k.groupAll&&(z.allGroupedData=Nt,lt=z.cropData(It,Nt,gt.min,gt.max,1),It=lt.xData,Nt=lt.yData,z.cropStart=lt.start),z.processedXData=It,z.processedYData=Nt}else z.groupMap=null;z.hasGroupedData=it,z.currentDataGrouping=at,z.preventGraphAnimation=(ot&&ot.totalRange)!==(at&&at.totalRange)}},skipDataGrouping=function(z){if(z.isCartesian&&!z.isDirty&&!z.xAxis.isDirty&&!z.yAxis.isDirty)return!1},groupData=function(z,y,a,k){var j=this,et=j.data,it=j.options&&j.options.data,nt=[],ot=[],at=[],lt=z.length,ct,ht,ut,ft=!!y,vt=[],gt,mt=j.pointArrayMap,bt=mt&&mt.length,xt=["x"].concat(mt||["y"]),wt=this.options.dataGrouping&&this.options.dataGrouping.groupAll,Mt=0,Et=0,St,kt,Pt;function It(Ft){return typeof Ft=="function"?Ft:approximations[Ft]?approximations[Ft]:approximations[j.getDGApproximation&&j.getDGApproximation()||"average"]}for(gt=It(k),bt?mt.forEach(function(){vt.push([])}):vt.push([]),St=bt||1,kt=0;kt<=lt&&!(z[kt]>=a[0]);kt++);for(kt;kt<=lt;kt++){for(;typeof a[Mt+1]<"u"&&z[kt]>=a[Mt+1]||kt===lt;){for(ct=a[Mt],j.dataGroupInfo={start:wt?Et:j.cropStart+Et,length:vt[0].length},ut=gt.apply(j,vt),j.pointClass&&!defined$C(j.dataGroupInfo.options)&&(j.dataGroupInfo.options=merge$12(j.pointClass.prototype.optionsToObject.call({series:j},j.options.data[j.cropStart+Et])),xt.forEach(function(Ft){delete j.dataGroupInfo.options[Ft]})),typeof ut<"u"&&(nt.push(ct),ot.push(ut),at.push(j.dataGroupInfo)),Et=kt,Pt=0;Pt<St;Pt++)vt[Pt].length=0,vt[Pt].hasNulls=!1;if(Mt+=1,kt===lt)break}if(kt===lt)break;if(mt){var Nt=j.options.dataGrouping&&j.options.dataGrouping.groupAll?kt:j.cropStart+kt,Ut=et&&et[Nt]||j.pointClass.prototype.applyOptions.apply({series:j},[it[Nt]]),Rt=void 0;for(Pt=0;Pt<bt;Pt++)Rt=Ut[mt[Pt]],isNumber$y(Rt)?vt[Pt].push(Rt):Rt===null&&(vt[Pt].hasNulls=!0)}else ht=ft?y[kt]:null,isNumber$y(ht)?vt[0].push(ht):ht===null&&(vt[0].hasNulls=!0)}return{groupedXData:nt,groupedYData:ot,groupMap:at}},anchorPoints=function(z,y,a){var k=z.options,j=k.dataGrouping,et=z.currentDataGrouping&&z.currentDataGrouping.gapSize,it;if(j&&z.xData&&et&&z.groupMap){var nt=y.length-1,ot=j.anchor,at=pick$18(j.firstAnchor,ot),lt=pick$18(j.lastAnchor,ot);if(ot&&ot!=="start"){var ct=et*{middle:.5,end:1}[ot];for(it=y.length-1;it--&&it>0;)y[it]+=ct}if(at&&at!=="start"&&z.xData[0]>=y[0]){var ht=z.groupMap[0].start,ut=z.groupMap[0].length,ft=void 0;isNumber$y(ht)&&isNumber$y(ut)&&(ft=ht+(ut-1)),y[0]={middle:y[0]+.5*et,end:y[0]+et,firstPoint:z.xData[0],lastPoint:ft&&z.xData[ft]}[at]}if(lt&&lt!=="start"&&et&&y[nt]>=a-et){var vt=z.groupMap[z.groupMap.length-1].start;y[nt]={middle:y[nt]+.5*et,end:y[nt]+et,firstPoint:vt&&z.xData[vt],lastPoint:z.xData[z.xData.length-1]}[lt]}}},adjustExtremes=function(z,y){defined$C(y[0])&&isNumber$y(z.min)&&isNumber$y(z.dataMin)&&y[0]<z.min&&((!defined$C(z.options.min)&&z.min<=z.dataMin||z.min===z.dataMin)&&(z.min=Math.min(y[0],z.min)),z.dataMin=Math.min(y[0],z.dataMin)),defined$C(y[y.length-1])&&isNumber$y(z.max)&&isNumber$y(z.dataMax)&&y[y.length-1]>z.max&&((!defined$C(z.options.max)&&isNumber$y(z.dataMax)&&z.max>=z.dataMax||z.max===z.dataMax)&&(z.max=Math.max(y[y.length-1],z.max)),z.dataMax=Math.max(y[y.length-1],z.dataMax))},dataGrouping={approximations,groupData};seriesProto$3.processData;var baseGeneratePoints=seriesProto$3.generatePoints,commonOptions={groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S","%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},specificOptions={line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},defaultDataGroupingUnits=H.defaultDataGroupingUnits=[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]];seriesProto$3.getDGApproximation=function(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("column")?"sum":"average"};seriesProto$3.groupData=groupData;seriesProto$3.applyGrouping=applyGrouping;seriesProto$3.destroyGroupedData=function(){this.groupedData&&(this.groupedData.forEach(function(z,y){z&&(this.groupedData[y]=z.destroy?z.destroy():null)},this),this.groupedData.length=0)};seriesProto$3.generatePoints=function(){baseGeneratePoints.apply(this),this.destroyGroupedData(),this.groupedData=this.hasGroupedData?this.points:null};Axis.prototype.applyGrouping=function(){var z=this,y=z.series;y.forEach(function(a){a.groupPixelWidth=void 0,a.groupPixelWidth=z.getGroupPixelWidth&&z.getGroupPixelWidth(),a.groupPixelWidth&&(a.hasProcessed=!0),a.applyGrouping()})};Axis.prototype.getGroupPixelWidth=function(){var z=this.series,y=z.length,a,k=0,j=!1,et,it;for(a=y;a--;)it=z[a].options.dataGrouping,it&&(k=Math.max(k,pick$18(it.groupPixelWidth,commonOptions.groupPixelWidth)));for(a=y;a--;)it=z[a].options.dataGrouping,it&&(et=(z[a].processedXData||z[a].data).length,(z[a].groupPixelWidth||et>this.chart.plotSizeX/k||et&&it.forced)&&(j=!0));return j?k:0};Axis.prototype.setDataGrouping=function(z,y){var a=this,k;if(y=pick$18(y,!0),z||(z={forced:!1,units:null}),this instanceof Axis)for(k=this.series.length;k--;)this.series[k].update({dataGrouping:z},!1);else this.chart.options.series.forEach(function(j){j.dataGrouping=z},!1);a.ordinal&&(a.ordinal.slope=void 0),y&&this.chart.redraw()};addEvent$R(Axis,"postProcessData",Axis.prototype.applyGrouping);addEvent$R(Point$4,"update",function(){if(this.dataGroup)return error$4(24,!1,this.series.chart),!1});addEvent$R(Tooltip,"headerFormatter",function(z){var y=this.chart,a=y.time,k=z.labelConfig,j=k.series,et=j.options,it=j.tooltipOptions,nt=et.dataGrouping,ot=it.xDateFormat,at,lt=j.xAxis,ct,ht,ut,ft,vt=it[z.isFooter?"footerFormat":"headerFormat"];lt&&lt.options.type==="datetime"&&nt&&isNumber$y(k.key)&&(ct=j.currentDataGrouping,ht=nt.dateTimeLabelFormats||commonOptions.dateTimeLabelFormats,ct?(ut=ht[ct.unitName],ct.count===1?ot=ut[0]:(ot=ut[1],at=ut[2])):!ot&&ht&&lt.dateTime&&(ot=lt.dateTime.getXDateFormat(k.x,it.dateTimeLabelFormats)),ft=a.dateFormat(ot,k.key),at&&(ft+=a.dateFormat(at,k.key+ct.totalRange-1)),j.chart.styledMode&&(vt=this.styledModeFormat(vt)),z.text=format$8(vt,{point:extend$1a(k.point,{key:ft}),series:j},y),z.preventDefault())});addEvent$R(Series$f,"destroy",seriesProto$3.destroyGroupedData);addEvent$R(Series$f,"afterSetOptions",function(z){var y=z.options,a=this.type,k=this.chart.options.plotOptions,j=DefaultOptions.defaultOptions.plotOptions[a].dataGrouping,et=this.useCommonDataGrouping&&commonOptions;if(specificOptions[a]||et){j||(j=merge$12(commonOptions,specificOptions[a]));var it=this.chart.rangeSelector;y.dataGrouping=merge$12(et,j,k.series&&k.series.dataGrouping,k[a].dataGrouping,this.userOptions.dataGrouping,!y.isInternal&&it&&isNumber$y(it.selected)&&it.buttonOptions[it.selected].dataGrouping)}});addEvent$R(Axis,"afterSetScale",function(){this.series.forEach(function(z){z.hasProcessed=!1})});H.dataGrouping=dataGrouping;var __extends$24=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),ColumnSeries$g=SeriesRegistry$1.seriesTypes.column,OHLCPoint=(function(z){__extends$24(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.close=void 0,a.high=void 0,a.low=void 0,a.open=void 0,a.options=void 0,a.plotClose=void 0,a.plotOpen=void 0,a.series=void 0,a}return y.prototype.getClassName=function(){return z.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")},y.prototype.resolveUpColor=function(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)},y.prototype.resolveColor=function(){z.prototype.resolveColor.call(this),this.resolveUpColor()},y.prototype.getZone=function(){var a=z.prototype.getZone.call(this);return this.resolveUpColor(),a},y.prototype.applyOptions=function(){return z.prototype.applyOptions.apply(this,arguments),this.resolveColor&&this.resolveColor(),this},y})(ColumnSeries$g.prototype.pointClass),__extends$23=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),ColumnSeries$f=SeriesRegistry$1.seriesTypes.column,extend$19=Utilities.extend,merge$11=Utilities.merge,OHLCSeries$1=(function(z){__extends$23(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a.yData=void 0,a}return y.prototype.drawPoints=function(){var a=this,k=a.points,j=a.chart,et=function(it,nt,ot){var at=it[0],lt=it[1];typeof at[2]=="number"&&(at[2]=Math.max(ot+nt,at[2])),typeof lt[2]=="number"&&(lt[2]=Math.min(ot-nt,lt[2]))};k.forEach(function(it){var nt,ot,at,lt,ct,ht=it.graphic,ut,ft=!ht,vt;typeof it.plotY<"u"&&(ht||(it.graphic=ht=j.renderer.path().add(a.group)),j.styledMode||ht.attr(a.pointAttribs(it,it.selected&&"select")),vt=ht.strokeWidth(),at=vt%2/2,ut=Math.round(it.plotX)-at,lt=Math.round(it.shapeArgs.width/2),ct=[["M",ut,Math.round(it.yBottom)],["L",ut,Math.round(it.plotHigh)]],it.open!==null&&(nt=Math.round(it.plotOpen)+at,ct.push(["M",ut,nt],["L",ut-lt,nt]),et(ct,vt/2,nt)),it.close!==null&&(ot=Math.round(it.plotClose)+at,ct.push(["M",ut,ot],["L",ut+lt,ot]),et(ct,vt/2,ot)),ht[ft?"attr":"animate"]({d:ct}).addClass(it.getClassName(),!0))})},y.prototype.init=function(){z.prototype.init.apply(this,arguments),this.options.stacking=void 0},y.prototype.pointAttribs=function(a,k){var j=z.prototype.pointAttribs.call(this,a,k),et=this.options;return delete j.fill,!a.options.color&&et.upColor&&a.open<a.close&&(j.stroke=et.upColor),j},y.prototype.toYData=function(a){return[a.open,a.high,a.low,a.close]},y.prototype.translate=function(){var a=this,k=a.yAxis,j=!!a.modifyValue,et=["plotOpen","plotHigh","plotLow","plotClose","yBottom"];z.prototype.translate.apply(a),a.points.forEach(function(it){[it.open,it.high,it.low,it.close,it.low].forEach(function(nt,ot){nt!==null&&(j&&(nt=a.modifyValue(nt)),it[et[ot]]=k.toPixels(nt,!0))}),it.tooltipPos[1]=it.plotHigh+k.pos-a.chart.plotTop})},y.defaultOptions=merge$11(ColumnSeries$f.defaultOptions,{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0}),y})(ColumnSeries$f);extend$19(OHLCSeries$1.prototype,{animate:null,directTouch:!1,pointArrayMap:["open","high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"});OHLCSeries$1.prototype.pointClass=OHLCPoint;SeriesRegistry$1.registerSeriesType("ohlc",OHLCSeries$1);var __extends$22=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),defaultOptions$c=DefaultOptions.defaultOptions,_a$d=SeriesRegistry$1.seriesTypes,ColumnSeries$e=_a$d.column,OHLCSeries=_a$d.ohlc,merge$10=Utilities.merge,CandlestickSeries=(function(z){__extends$22(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return y.prototype.pointAttribs=function(a,k){var j=ColumnSeries$e.prototype.pointAttribs.call(this,a,k),et=this.options,it=a.open<a.close,nt=et.lineColor||this.color,ot=a.color||this.color,at;return j["stroke-width"]=et.lineWidth,j.fill=a.options.color||it&&et.upColor||ot,j.stroke=a.options.lineColor||it&&et.upLineColor||nt,k&&(at=et.states[k],j.fill=at.color||j.fill,j.stroke=at.lineColor||j.stroke,j["stroke-width"]=at.lineWidth||j["stroke-width"]),j},y.prototype.drawPoints=function(){var a=this,k=a.points,j=a.chart,et=a.yAxis.reversed;k.forEach(function(it){var nt=it.graphic,ot,at,lt,ct,ht,ut,ft,vt,gt,mt,bt=!nt;typeof it.plotY<"u"&&(nt||(it.graphic=nt=j.renderer.path().add(a.group)),a.chart.styledMode||nt.attr(a.pointAttribs(it,it.selected&&"select")).shadow(a.options.shadow),ft=nt.strokeWidth()%2/2,vt=Math.round(it.plotX)-ft,ot=it.plotOpen,at=it.plotClose,lt=Math.min(ot,at),ct=Math.max(ot,at),mt=Math.round(it.shapeArgs.width/2),ht=et?ct!==it.yBottom:Math.round(lt)!==Math.round(it.plotHigh),ut=et?Math.round(lt)!==Math.round(it.plotHigh):ct!==it.yBottom,lt=Math.round(lt)+ft,ct=Math.round(ct)+ft,gt=[],gt.push(["M",vt-mt,ct],["L",vt-mt,lt],["L",vt+mt,lt],["L",vt+mt,ct],["Z"],["M",vt,lt],["L",vt,ht?Math.round(et?it.yBottom:it.plotHigh):lt],["M",vt,ct],["L",vt,ut?Math.round(et?it.plotHigh:it.yBottom):ct]),nt[bt?"attr":"animate"]({d:gt}).addClass(it.getClassName(),!0))})},y.defaultOptions=merge$10(OHLCSeries.defaultOptions,defaultOptions$c.plotOptions,{states:{hover:{lineWidth:2}},tooltip:defaultOptions$c.plotOptions.ohlc.tooltip,threshold:null,lineColor:palette.neutralColor100,lineWidth:1,upColor:palette.backgroundColor,stickyTracking:!0}),y})(OHLCSeries);SeriesRegistry$1.registerSeriesType("candlestick",CandlestickSeries);var __extends$21=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),ColumnSeries$d=SeriesRegistry$1.seriesTypes.column,isNumber$x=Utilities.isNumber,FlagsPoint=(function(z){__extends$21(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.options=void 0,a.series=void 0,a}return y.prototype.isValid=function(){return isNumber$x(this.y)||typeof this.y>"u"},y.prototype.hasNewShapeType=function(){var a=this.options.shape||this.series.options.shape;return this.graphic&&a&&a!==this.graphic.symbolKey},y})(ColumnSeries$d.prototype.pointClass),columnProto$5=ColumnSeries$h.prototype,seriesProto$2=Series$f.prototype,defined$B=Utilities.defined,stableSort$4=Utilities.stableSort,onSeriesMixin={getPlotBox:function(){return seriesProto$2.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this)},translate:function(){columnProto$5.translate.apply(this);var z=this,y=z.options,a=z.chart,k=z.points,j=k.length-1,et,it,nt=y.onSeries,ot=nt&&a.get(nt),at=y.onKey||"y",lt=ot&&ot.options.step,ct=ot&&ot.points,ht=ct&&ct.length,ut=a.inverted,ft=z.xAxis,vt=z.yAxis,gt=0,mt,bt,xt,wt,Mt;if(ot&&ot.visible&&ht)for(gt=(ot.pointXOffset||0)+(ot.barW||0)/2,wt=ot.currentDataGrouping,bt=ct[ht-1].x+(wt?wt.totalRange:0),stableSort$4(k,function(Et,St){return Et.x-St.x}),at="plot"+at[0].toUpperCase()+at.substr(1);ht--&&k[j]&&(mt=ct[ht],et=k[j],et.y=mt.y,!(mt.x<=et.x&&typeof mt[at]<"u"&&(et.x<=bt&&(et.plotY=mt[at],mt.x<et.x&&!lt&&(xt=ct[ht+1],xt&&typeof xt[at]<"u"&&(Mt=(et.x-mt.x)/(xt.x-mt.x),et.plotY+=Mt*(xt[at]-mt[at]),et.y+=Mt*(xt.y-mt.y)))),j--,ht++,j<0))););k.forEach(function(Et,St){var kt;Et.plotX+=gt,(typeof Et.plotY>"u"||ut)&&(Et.plotX>=0&&Et.plotX<=ft.len?ut?(Et.plotY=ft.translate(Et.x,0,1,0,1),Et.plotX=defined$B(Et.y)?vt.translate(Et.y,0,0,0,1):0):Et.plotY=(ft.opposite?0:z.yAxis.len)+ft.offset:Et.shapeArgs={}),it=k[St-1],it&&it.plotX===Et.plotX&&(typeof it.stackIndex>"u"&&(it.stackIndex=0),kt=it.stackIndex+1),Et.stackIndex=kt}),this.onSeries=ot}},symbols$4=SVGRenderer.prototype.symbols;symbols$4.flag=function(z,y,a,k,j){var et=j&&j.anchorX||z,it=j&&j.anchorY||y,nt=symbols$4.circle(et-1,it-1,2,2);return nt.push(["M",et,it],["L",z,y+k],["L",z,y],["L",z+a,y],["L",z+a,y+k],["L",z,y+k],["Z"]),nt};function createPinSymbol(z){symbols$4[z+"pin"]=function(y,a,k,j,et){var it=et&&et.anchorX,nt=et&&et.anchorY,ot;if(z==="circle"&&j>k&&(y-=Math.round((j-k)/2),k=j),ot=symbols$4[z](y,a,k,j),it&&nt){var at=it;if(z==="circle")at=y+k/2;else{var lt=ot[0],ct=ot[1];lt[0]==="M"&&ct[0]==="L"&&(at=(lt[1]+ct[1])/2)}var ht=a>nt?a:a+j;ot.push(["M",at,ht],["L",it,nt]),ot=ot.concat(symbols$4.circle(it-1,nt-1,2,2))}return ot}}createPinSymbol("circle");createPinSymbol("square");var Renderer=RendererRegistry$1.getRendererType();Renderer!==SVGRenderer&&(Renderer.prototype.symbols.circlepin=symbols$4.circlepin,Renderer.prototype.symbols.flag=symbols$4.flag,Renderer.prototype.symbols.squarepin=symbols$4.squarepin);var __extends$20=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),noop$d=H.noop,distribute=R.distribute,Series$c=SeriesRegistry$1.series,ColumnSeries$c=SeriesRegistry$1.seriesTypes.column,addEvent$Q=Utilities.addEvent,defined$A=Utilities.defined,extend$18=Utilities.extend,merge$$=Utilities.merge,objectEach$g=Utilities.objectEach,wrap$f=Utilities.wrap,FlagsSeries=(function(z){__extends$20(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return y.prototype.animate=function(a){a&&this.setClip()},y.prototype.drawPoints=function(){var a=this,k=a.points,j=a.chart,et=j.renderer,it,nt,ot=j.inverted,at=a.options,lt=at.y,ct,ht,ut,ft,vt,gt,mt,bt,xt=a.yAxis,wt={},Mt=[],Et;for(ht=k.length;ht--;)ut=k[ht],bt=(ot?ut.plotY:ut.plotX)>a.xAxis.len,it=ut.plotX,vt=ut.stackIndex,ct=ut.options.shape||at.shape,nt=ut.plotY,typeof nt<"u"&&(nt=ut.plotY+lt-(typeof vt<"u"&&vt*at.stackDistance)),ut.anchorX=vt?void 0:ut.plotX,gt=vt?void 0:ut.plotY,Et=ct!=="flag",ft=ut.graphic,typeof nt<"u"&&it>=0&&!bt?(ft&&ut.hasNewShapeType()&&(ft=ft.destroy()),ft||(ft=ut.graphic=et.label("",null,null,ct,null,null,at.useHTML).addClass("highcharts-point").add(a.markerGroup),ut.graphic.div&&(ut.graphic.div.point=ut),ft.isNew=!0),ft.attr({align:Et?"center":"left",width:at.width,height:at.height,"text-align":at.textAlign}),j.styledMode||ft.attr(a.pointAttribs(ut)).css(merge$$(at.style,ut.style)).shadow(at.shadow),it>0&&(it-=ft.strokeWidth()%2),mt={y:nt,anchorY:gt},at.allowOverlapX&&(mt.x=it,mt.anchorX=ut.anchorX),ft.attr({text:ut.options.title||at.title||"A"})[ft.isNew?"attr":"animate"](mt),at.allowOverlapX||(wt[ut.plotX]?wt[ut.plotX].size=Math.max(wt[ut.plotX].size,ft.width):wt[ut.plotX]={align:Et?.5:0,size:ft.width,target:it,anchorX:it}),ut.tooltipPos=[it,nt+xt.pos-j.plotTop]):ft&&(ut.graphic=ft.destroy());at.allowOverlapX||(objectEach$g(wt,function(St){St.plotX=St.anchorX,Mt.push(St)}),distribute(Mt,ot?xt.len:this.xAxis.len,100),k.forEach(function(St){var kt=St.graphic&&wt[St.plotX];kt&&(St.graphic[St.graphic.isNew?"attr":"animate"]({x:kt.pos+kt.align*kt.size,anchorX:St.anchorX}),defined$A(kt.pos)?St.graphic.isNew=!1:(St.graphic.attr({x:-9999,anchorX:-9999}),St.graphic.isNew=!0))})),at.useHTML&&wrap$f(a.markerGroup,"on",function(St){return SVGElement.prototype.on.apply(St.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})},y.prototype.drawTracker=function(){var a=this,k=a.points;z.prototype.drawTracker.call(this),k.forEach(function(j){var et=j.graphic;et&&(j.unbindMouseOver&&j.unbindMouseOver(),j.unbindMouseOver=addEvent$Q(et.element,"mouseover",function(){j.stackIndex>0&&!j.raised&&(j._y=et.y,et.attr({y:j._y-8}),j.raised=!0),k.forEach(function(it){it!==j&&it.raised&&it.graphic&&(it.graphic.attr({y:it._y}),it.raised=!1)})}))})},y.prototype.pointAttribs=function(a,k){var j=this.options,et=a&&a.color||this.color,it=j.lineColor,nt=a&&a.lineWidth,ot=a&&a.fillColor||j.fillColor;return k&&(ot=j.states[k].fillColor,it=j.states[k].lineColor,nt=j.states[k].lineWidth),{fill:ot||et,stroke:it||et,"stroke-width":nt||j.lineWidth||0}},y.prototype.setClip=function(){Series$c.prototype.setClip.apply(this,arguments),this.options.clip!==!1&&this.sharedClipKey&&this.markerGroup&&this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])},y.defaultOptions=merge$$(ColumnSeries$c.defaultOptions,{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:palette.backgroundColor,lineWidth:1,states:{hover:{lineColor:palette.neutralColor100,fillColor:palette.highlightColor20}},style:{fontSize:"11px",fontWeight:"bold"}}),y})(ColumnSeries$c);extend$18(FlagsSeries.prototype,{allowDG:!1,buildKDTree:noop$d,forceCrop:!0,getPlotBox:onSeriesMixin.getPlotBox,init:Series$c.prototype.init,invertGroups:noop$d,invertible:!1,noSharedTooltip:!0,pointClass:FlagsPoint,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],translate:onSeriesMixin.translate});SeriesRegistry$1.registerSeriesType("flags",FlagsSeries);var addEvent$P=Utilities.addEvent,defined$z=Utilities.defined,pick$17=Utilities.pick,ScrollbarAxis=(function(){function z(){}return z.compose=function(y,a){if(z.composed.indexOf(y)===-1)z.composed.push(y);else return y;var k=function(j){var et=pick$17(j.options&&j.options.min,j.min),it=pick$17(j.options&&j.options.max,j.max);return{axisMin:et,axisMax:it,scrollMin:defined$z(j.dataMin)?Math.min(et,j.min,j.dataMin,pick$17(j.threshold,1/0)):et,scrollMax:defined$z(j.dataMax)?Math.max(it,j.max,j.dataMax,pick$17(j.threshold,-1/0)):it}};return addEvent$P(y,"afterInit",function(){var j=this;j.options&&j.options.scrollbar&&j.options.scrollbar.enabled&&(j.options.scrollbar.vertical=!j.horiz,j.options.startOnTick=j.options.endOnTick=!1,j.scrollbar=new a(j.chart.renderer,j.options.scrollbar,j.chart),addEvent$P(j.scrollbar,"changed",function(et){var it=k(j),nt=it.axisMin,ot=it.axisMax,at=it.scrollMin,lt=it.scrollMax,ct=lt-at,ht,ut;!defined$z(nt)||!defined$z(ot)||(j.horiz&&!j.reversed||!j.horiz&&j.reversed?(ht=at+ct*this.to,ut=at+ct*this.from):(ht=at+ct*(1-this.from),ut=at+ct*(1-this.to)),this.shouldUpdateExtremes(et.DOMType)?j.setExtremes(ut,ht,!0,et.DOMType!=="mousemove"&&et.DOMType!=="touchmove",et):this.setRange(this.from,this.to))}))}),addEvent$P(y,"afterRender",function(){var j=this,et=k(j),it=et.scrollMin,nt=et.scrollMax,ot=j.scrollbar,at=j.axisTitleMargin+(j.titleOffset||0),lt=j.chart.scrollbarsOffsets,ct=j.options.margin||0,ht,ut,ft;ot&&(j.horiz?(j.opposite||(lt[1]+=at),ot.position(j.left,j.top+j.height+2+lt[1]-(j.opposite?ct:0),j.width,j.height),j.opposite||(lt[1]+=ct),ht=1):(j.opposite&&(lt[0]+=at),ot.position(j.left+j.width+2+lt[0]-(j.opposite?0:ct),j.top,j.width,j.height),j.opposite&&(lt[0]+=ct),ht=0),lt[ht]+=ot.size+ot.options.margin,isNaN(it)||isNaN(nt)||!defined$z(j.min)||!defined$z(j.max)||j.min===j.max?ot.setRange(0,1):(ut=(j.min-it)/(nt-it),ft=(j.max-it)/(nt-it),j.horiz&&!j.reversed||!j.horiz&&j.reversed?ot.setRange(ut,ft):ot.setRange(1-ft,1-ut)))}),addEvent$P(y,"afterGetOffset",function(){var j=this,et=j.horiz?2:1,it=j.scrollbar;it&&(j.chart.scrollbarsOffsets=[0,0],j.chart.axisOffset[et]+=it.size+it.options.margin)}),y},z.composed=[],z})(),isTouchDevice$3=H.isTouchDevice,ScrollbarDefaults={height:isTouchDevice$3?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,margin:10,minWidth:6,step:.2,zIndex:3,barBackgroundColor:palette.neutralColor20,barBorderWidth:1,barBorderColor:palette.neutralColor20,buttonArrowColor:palette.neutralColor80,buttonBackgroundColor:palette.neutralColor10,buttonBorderColor:palette.neutralColor20,buttonBorderWidth:1,rifleColor:palette.neutralColor80,trackBackgroundColor:palette.neutralColor5,trackBorderColor:palette.neutralColor5,trackBorderWidth:1},defaultOptions$b=DefaultOptions.defaultOptions,addEvent$O=Utilities.addEvent,correctFloat$6=Utilities.correctFloat,defined$y=Utilities.defined,destroyObjectProperties$3=Utilities.destroyObjectProperties,fireEvent$l=Utilities.fireEvent,merge$_=Utilities.merge,pick$16=Utilities.pick,removeEvent$4=Utilities.removeEvent,Scrollbar=(function(){function z(y,a,k){this._events=[],this.chart=void 0,this.chartX=0,this.chartY=0,this.from=0,this.group=void 0,this.options=void 0,this.renderer=void 0,this.scrollbar=void 0,this.scrollbarButtons=[],this.scrollbarGroup=void 0,this.scrollbarLeft=0,this.scrollbarRifles=void 0,this.scrollbarStrokeWidth=1,this.scrollbarTop=0,this.size=0,this.to=0,this.track=void 0,this.trackBorderWidth=1,this.userOptions=void 0,this.x=0,this.y=0,this.init(y,a,k)}return z.compose=function(y){ScrollbarAxis.compose(y,z)},z.swapXY=function(y,a){return a&&y.forEach(function(k){for(var j=k.length,et,it=0;it<j;it+=2)et=k[it+1],typeof et=="number"&&(k[it+1]=k[it+2],k[it+2]=et)}),y},z.prototype.addEvents=function(){var y=this.options.inverted?[1,0]:[0,1],a=this.scrollbarButtons,k=this.scrollbarGroup.element,j=this.track.element,et=this.mouseDownHandler.bind(this),it=this.mouseMoveHandler.bind(this),nt=this.mouseUpHandler.bind(this),ot=[[a[y[0]].element,"click",this.buttonToMinClick.bind(this)],[a[y[1]].element,"click",this.buttonToMaxClick.bind(this)],[j,"click",this.trackClick.bind(this)],[k,"mousedown",et],[k.ownerDocument,"mousemove",it],[k.ownerDocument,"mouseup",nt]];H.hasTouch&&ot.push([k,"touchstart",et],[k.ownerDocument,"touchmove",it],[k.ownerDocument,"touchend",nt]),ot.forEach(function(at){addEvent$O.apply(null,at)}),this._events=ot},z.prototype.buttonToMaxClick=function(y){var a=this,k=(a.to-a.from)*pick$16(a.options.step,.2);a.updatePosition(a.from+k,a.to+k),fireEvent$l(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMEvent:y})},z.prototype.buttonToMinClick=function(y){var a=this,k=correctFloat$6(a.to-a.from)*pick$16(a.options.step,.2);a.updatePosition(correctFloat$6(a.from-k),correctFloat$6(a.to-k)),fireEvent$l(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMEvent:y})},z.prototype.cursorToScrollbarPosition=function(y){var a=this,k=a.options,j=k.minWidth>a.calculatedWidth?k.minWidth:0;return{chartX:(y.chartX-a.x-a.xOffset)/(a.barWidth-j),chartY:(y.chartY-a.y-a.yOffset)/(a.barWidth-j)}},z.prototype.destroy=function(){var y=this,a=y.chart.scroller;y.removeEvents(),["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(k){y[k]&&y[k].destroy&&(y[k]=y[k].destroy())}),a&&y===a.scrollbar&&(a.scrollbar=null,destroyObjectProperties$3(a.scrollbarButtons))},z.prototype.drawScrollbarButton=function(y){var a=this,k=a.renderer,j=a.scrollbarButtons,et=a.options,it=a.size,nt=k.g().add(a.group),ot;j.push(nt),ot=k.rect().addClass("highcharts-scrollbar-button").add(nt),a.chart.styledMode||ot.attr({stroke:et.buttonBorderColor,"stroke-width":et.buttonBorderWidth,fill:et.buttonBackgroundColor}),ot.attr(ot.crisp({x:-.5,y:-.5,width:it+1,height:it+1,r:et.buttonBorderRadius},ot.strokeWidth())),ot=k.path(z.swapXY([["M",it/2+(y?-1:1),it/2-3],["L",it/2+(y?-1:1),it/2+3],["L",it/2+(y?2:-2),it/2]],et.vertical)).addClass("highcharts-scrollbar-arrow").add(j[y]),a.chart.styledMode||ot.attr({fill:et.buttonArrowColor})},z.prototype.init=function(y,a,k){var j=this;j.scrollbarButtons=[],j.renderer=y,j.userOptions=a,j.options=merge$_(ScrollbarDefaults,defaultOptions$b.scrollbar,a),j.chart=k,j.size=pick$16(j.options.size,j.options.height),a.enabled&&(j.render(),j.addEvents())},z.prototype.mouseDownHandler=function(y){var a=this,k=a.chart.pointer.normalize(y),j=a.cursorToScrollbarPosition(k);a.chartX=j.chartX,a.chartY=j.chartY,a.initPositions=[a.from,a.to],a.grabbedCenter=!0},z.prototype.mouseMoveHandler=function(y){var a=this,k=a.chart.pointer.normalize(y),j=a.options,et=j.vertical?"chartY":"chartX",it=a.initPositions||[],nt,ot,at;a.grabbedCenter&&(!y.touches||y.touches[0][et]!==0)&&(ot=a.cursorToScrollbarPosition(k)[et],nt=a[et],at=ot-nt,a.hasDragged=!0,a.updatePosition(it[0]+at,it[1]+at),a.hasDragged&&fireEvent$l(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMType:y.type,DOMEvent:y}))},z.prototype.mouseUpHandler=function(y){var a=this;a.hasDragged&&fireEvent$l(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMType:y.type,DOMEvent:y}),a.grabbedCenter=a.hasDragged=a.chartX=a.chartY=null},z.prototype.position=function(y,a,k,j){var et=this,it=et.options,nt=it.vertical,ot=et.rendered?"animate":"attr",at=j,lt=0;et.x=y,et.y=a+this.trackBorderWidth,et.width=k,et.height=j,et.xOffset=at,et.yOffset=lt,nt?(et.width=et.yOffset=k=lt=et.size,et.xOffset=at=0,et.barWidth=j-k*2,et.x=y=y+et.options.margin):(et.height=et.xOffset=j=at=et.size,et.barWidth=k-j*2,et.y=et.y+et.options.margin),et.group[ot]({translateX:y,translateY:et.y}),et.track[ot]({width:k,height:j}),et.scrollbarButtons[1][ot]({translateX:nt?0:k-at,translateY:nt?j-lt:0})},z.prototype.removeEvents=function(){this._events.forEach(function(y){removeEvent$4.apply(null,y)}),this._events.length=0},z.prototype.render=function(){var y=this,a=y.renderer,k=y.options,j=y.size,et=y.chart.styledMode,it=a.g("scrollbar").attr({zIndex:k.zIndex,translateY:-99999}).add();y.group=it,y.track=a.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:k.trackBorderRadius||0,height:j,width:j}).add(it),et||y.track.attr({fill:k.trackBackgroundColor,stroke:k.trackBorderColor,"stroke-width":k.trackBorderWidth}),y.trackBorderWidth=y.track.strokeWidth(),y.track.attr({y:-this.trackBorderWidth%2/2}),y.scrollbarGroup=a.g().add(it),y.scrollbar=a.rect().addClass("highcharts-scrollbar-thumb").attr({height:j,width:j,r:k.barBorderRadius||0}).add(y.scrollbarGroup),y.scrollbarRifles=a.path(z.swapXY([["M",-3,j/4],["L",-3,2*j/3],["M",0,j/4],["L",0,2*j/3],["M",3,j/4],["L",3,2*j/3]],k.vertical)).addClass("highcharts-scrollbar-rifles").add(y.scrollbarGroup),et||(y.scrollbar.attr({fill:k.barBackgroundColor,stroke:k.barBorderColor,"stroke-width":k.barBorderWidth}),y.scrollbarRifles.attr({stroke:k.rifleColor,"stroke-width":1})),y.scrollbarStrokeWidth=y.scrollbar.strokeWidth(),y.scrollbarGroup.translate(-y.scrollbarStrokeWidth%2/2,-y.scrollbarStrokeWidth%2/2),y.drawScrollbarButton(0),y.drawScrollbarButton(1)},z.prototype.setRange=function(y,a){var k=this,j=k.options,et=j.vertical,it=j.minWidth,nt=k.barWidth,ot=this.rendered&&!this.hasDragged&&!(this.chart.navigator&&this.chart.navigator.hasDragged)?"animate":"attr";if(defined$y(nt)){var at=nt*Math.min(a,1),lt,ct;y=Math.max(y,0),lt=Math.ceil(nt*y),k.calculatedWidth=ct=correctFloat$6(at-lt),ct<it&&(lt=(nt-it+ct)*y,ct=it);var ht=Math.floor(lt+k.xOffset+k.yOffset),ut=ct/2-.5;k.from=y,k.to=a,et?(k.scrollbarGroup[ot]({translateY:ht}),k.scrollbar[ot]({height:ct}),k.scrollbarRifles[ot]({translateY:ut}),k.scrollbarTop=ht,k.scrollbarLeft=0):(k.scrollbarGroup[ot]({translateX:ht}),k.scrollbar[ot]({width:ct}),k.scrollbarRifles[ot]({translateX:ut}),k.scrollbarLeft=ht,k.scrollbarTop=0),ct<=12?k.scrollbarRifles.hide():k.scrollbarRifles.show(!0),j.showFull===!1&&(y<=0&&a>=1?k.group.hide():k.group.show()),k.rendered=!0}},z.prototype.shouldUpdateExtremes=function(y){return pick$16(this.options.liveRedraw,H.svg&&!H.isTouchDevice&&!this.chart.isBoosting)||y==="mouseup"||y==="touchend"||!defined$y(y)},z.prototype.trackClick=function(y){var a=this,k=a.chart.pointer.normalize(y),j=a.to-a.from,et=a.y+a.scrollbarTop,it=a.x+a.scrollbarLeft;a.options.vertical&&k.chartY>et||!a.options.vertical&&k.chartX>it?a.updatePosition(a.from+j,a.to+j):a.updatePosition(a.from-j,a.to-j),fireEvent$l(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMEvent:y})},z.prototype.update=function(y){this.destroy(),this.init(this.chart.renderer,merge$_(!0,this.options,y),this.chart)},z.prototype.updatePosition=function(y,a){a>1&&(y=correctFloat$6(1-correctFloat$6(a-y)),a=1),y<0&&(a=correctFloat$6(a-y),y=0),this.from=y,this.to=a},z.defaultOptions=ScrollbarDefaults,z})();defaultOptions$b.scrollbar=merge$_(!0,Scrollbar.defaultOptions,defaultOptions$b.scrollbar);var isTouchDevice$2=H.isTouchDevice,addEvent$N=Utilities.addEvent,correctFloat$5=Utilities.correctFloat,defined$x=Utilities.defined,isNumber$w=Utilities.isNumber,pick$15=Utilities.pick,NavigatorAxisAdditions=(function(){function z(y){this.axis=y}return z.prototype.destroy=function(){this.axis=void 0},z.prototype.toFixedRange=function(y,a,k,j){var et=this,it=et.axis,nt=it.chart,ot=nt&&nt.fixedRange,at=(it.pointRange||0)/2,lt=pick$15(k,it.translate(y,!0,!it.horiz)),ct=pick$15(j,it.translate(a,!0,!it.horiz)),ht=ot&&(ct-lt)/ot;return defined$x(k)||(lt=correctFloat$5(lt+at)),defined$x(j)||(ct=correctFloat$5(ct-at)),ht>.7&&ht<1.3&&(j?lt=ct-ot:ct=lt+ot),(!isNumber$w(lt)||!isNumber$w(ct))&&(lt=ct=void 0),{min:lt,max:ct}},z})(),NavigatorAxis=(function(){function z(){}return z.compose=function(y){y.keepProps.push("navigatorAxis"),addEvent$N(y,"init",function(){var a=this;a.navigatorAxis||(a.navigatorAxis=new NavigatorAxisAdditions(a))}),addEvent$N(y,"zoom",function(a){var k=this,j=k.chart,et=j.options,it=et.navigator,nt=k.navigatorAxis,ot=et.chart.pinchType,at=et.rangeSelector,lt=et.chart.zoomType,ct;k.isXAxis&&(it&&it.enabled||at&&at.enabled)&&(lt==="y"?a.zoomed=!1:(!isTouchDevice$2&&lt==="xy"||isTouchDevice$2&&ot==="xy")&&k.options.range&&(ct=nt.previousZoom,defined$x(a.newMin)?nt.previousZoom=[k.min,k.max]:ct&&(a.newMin=ct[0],a.newMax=ct[1],nt.previousZoom=void 0))),typeof a.zoomed<"u"&&a.preventDefault()})},z.AdditionsClass=NavigatorAxisAdditions,z})(),color$b=Color.parse,hasTouch=H.hasTouch,isTouchDevice$1=H.isTouchDevice,defaultOptions$a=DefaultOptions.defaultOptions,seriesTypes$6=SeriesRegistry$1.seriesTypes,addEvent$M=Utilities.addEvent,clamp$c=Utilities.clamp,correctFloat$4=Utilities.correctFloat,defined$w=Utilities.defined,destroyObjectProperties$2=Utilities.destroyObjectProperties,erase$2=Utilities.erase,extend$17=Utilities.extend,find$e=Utilities.find,isArray$b=Utilities.isArray,isNumber$v=Utilities.isNumber,merge$Z=Utilities.merge,pick$14=Utilities.pick,removeEvent$3=Utilities.removeEvent,splat$b=Utilities.splat,defaultSeriesType,numExt=function(z){for(var y=[],a=1;a<arguments.length;a++)y[a-1]=arguments[a];var k=[].filter.call(y,isNumber$v);if(k.length)return Math[z].apply(0,k)};defaultSeriesType=typeof seriesTypes$6.areaspline>"u"?"line":"areaspline";extend$17(defaultOptions$a,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:palette.neutralColor5,borderColor:palette.neutralColor40},maskFill:color$b(palette.highlightColor60).setOpacity(.3).get(),outlineColor:palette.neutralColor20,outlineWidth:1,series:{type:defaultSeriesType,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:palette.neutralColor10,gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:palette.neutralColor40},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});RendererRegistry$1.getRendererType().prototype.symbols["navigator-handle"]=function(z,y,a,k,j){var et=(j&&j.width||0)/2,it=Math.round(et/3)+.5,nt=j&&j.height||0;return[["M",-et-1,.5],["L",et,.5],["L",et,nt+.5],["L",-et-1,nt+.5],["L",-et-1,.5],["M",-it,4],["L",-it,nt-3],["M",it-1,4],["L",it-1,nt-3]]};var Navigator=(function(){function z(y){this.baseSeries=void 0,this.chart=void 0,this.handles=void 0,this.height=void 0,this.left=void 0,this.navigatorEnabled=void 0,this.navigatorGroup=void 0,this.navigatorOptions=void 0,this.navigatorSeries=void 0,this.navigatorSize=void 0,this.opposite=void 0,this.outline=void 0,this.outlineHeight=void 0,this.range=void 0,this.rendered=void 0,this.shades=void 0,this.size=void 0,this.top=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zoomedMax=void 0,this.zoomedMin=void 0,this.init(y)}return z.prototype.drawHandle=function(y,a,k,j){var et=this,it=et.navigatorOptions.handles.height;et.handles[a][j](k?{translateX:Math.round(et.left+et.height/2),translateY:Math.round(et.top+parseInt(y,10)+.5-it)}:{translateX:Math.round(et.left+parseInt(y,10)),translateY:Math.round(et.top+et.height/2-it/2-1)})},z.prototype.drawOutline=function(y,a,k,j){var et=this,it=et.navigatorOptions.maskInside,nt=et.outline.strokeWidth(),ot=nt/2,at=nt%2/2,lt=et.outlineHeight,ct=et.scrollbarHeight||0,ht=et.size,ut=et.left-ct,ft=et.top,vt,gt;k?(ut-=ot,vt=ft+a+at,a=ft+y+at,gt=[["M",ut+lt,ft-ct-at],["L",ut+lt,vt],["L",ut,vt],["L",ut,a],["L",ut+lt,a],["L",ut+lt,ft+ht+ct]],it&&gt.push(["M",ut+lt,vt-ot],["L",ut+lt,a+ot])):(y+=ut+ct-at,a+=ut+ct-at,ft+=ot,gt=[["M",ut,ft],["L",y,ft],["L",y,ft+lt],["L",a,ft+lt],["L",a,ft],["L",ut+ht+ct*2,ft]],it&&gt.push(["M",y-ot,ft],["L",a+ot,ft])),et.outline[j]({d:gt})},z.prototype.drawMasks=function(y,a,k,j){var et=this,it=et.left,nt=et.top,ot=et.height,at,lt,ct,ht;k?(ct=[it,it,it],ht=[nt,nt+y,nt+a],lt=[ot,ot,ot],at=[y,a-y,et.size-a]):(ct=[it,it+y,it+a],ht=[nt,nt,nt],lt=[y,a-y,et.size-a],at=[ot,ot,ot]),et.shades.forEach(function(ut,ft){ut[j]({x:ct[ft],y:ht[ft],width:lt[ft],height:at[ft]})})},z.prototype.renderElements=function(){var y=this,a=y.navigatorOptions,k=a.maskInside,j=y.chart,et=j.inverted,it=j.renderer,nt,ot={cursor:et?"ns-resize":"ew-resize"};y.navigatorGroup=nt=it.g("navigator").attr({zIndex:8,visibility:"hidden"}).add(),[!k,k,!k].forEach(function(at,lt){y.shades[lt]=it.rect().addClass("highcharts-navigator-mask"+(lt===1?"-inside":"-outside")).add(nt),j.styledMode||y.shades[lt].attr({fill:at?a.maskFill:"rgba(0,0,0,0)"}).css(lt===1&&ot)}),y.outline=it.path().addClass("highcharts-navigator-outline").add(nt),j.styledMode||y.outline.attr({"stroke-width":a.outlineWidth,stroke:a.outlineColor}),a.handles.enabled&&[0,1].forEach(function(at){if(a.handles.inverted=j.inverted,y.handles[at]=it.symbol(a.handles.symbols[at],-a.handles.width/2-1,0,a.handles.width,a.handles.height,a.handles),y.handles[at].attr({zIndex:7-at}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][at]).add(nt),!j.styledMode){var lt=a.handles;y.handles[at].attr({fill:lt.backgroundColor,stroke:lt.borderColor,"stroke-width":lt.lineWidth}).css(ot)}})},z.prototype.update=function(y){(this.series||[]).forEach(function(k){k.baseSeries&&delete k.baseSeries.navigatorSeries}),this.destroy();var a=this.chart.options;merge$Z(!0,a.navigator,this.options,y),this.init(this.chart)},z.prototype.render=function(y,a,k,j){var et=this,it=et.chart,nt,ot,at,lt=et.scrollbarHeight,ct,ht=et.xAxis,ut=ht.pointRange||0,ft=ht.navigatorAxis.fake?it.xAxis[0]:ht,vt=et.navigatorEnabled,gt,mt,bt=et.rendered,xt=it.inverted,wt,Mt,Et,St,kt=it.xAxis[0].minRange,Pt=it.xAxis[0].options.maxRange;if(!(this.hasDragged&&!defined$w(k))){if(y=correctFloat$4(y-ut/2),a=correctFloat$4(a+ut/2),!isNumber$v(y)||!isNumber$v(a))if(bt)k=0,j=pick$14(ht.width,ft.width);else return;et.left=pick$14(ht.left,it.plotLeft+lt+(xt?it.plotWidth:0)),et.size=mt=ct=pick$14(ht.len,(xt?it.plotHeight:it.plotWidth)-2*lt),xt?nt=lt:nt=ct+2*lt,k=pick$14(k,ht.toPixels(y,!0)),j=pick$14(j,ht.toPixels(a,!0)),(!isNumber$v(k)||Math.abs(k)===1/0)&&(k=0,j=nt),Mt=ht.toValue(k,!0),Et=ht.toValue(j,!0),St=Math.abs(correctFloat$4(Et-Mt)),St<kt?this.grabbedLeft?k=ht.toPixels(Et-kt-ut,!0):this.grabbedRight&&(j=ht.toPixels(Mt+kt+ut,!0)):defined$w(Pt)&&correctFloat$4(St-ut)>Pt&&(this.grabbedLeft?k=ht.toPixels(Et-Pt-ut,!0):this.grabbedRight&&(j=ht.toPixels(Mt+Pt+ut,!0))),et.zoomedMax=clamp$c(Math.max(k,j),0,mt),et.zoomedMin=clamp$c(et.fixedWidth?et.zoomedMax-et.fixedWidth:Math.min(k,j),0,mt),et.range=et.zoomedMax-et.zoomedMin,mt=Math.round(et.zoomedMax),gt=Math.round(et.zoomedMin),vt&&(et.navigatorGroup.attr({visibility:"visible"}),wt=bt&&!et.hasDragged?"animate":"attr",et.drawMasks(gt,mt,xt,wt),et.drawOutline(gt,mt,xt,wt),et.navigatorOptions.handles.enabled&&(et.drawHandle(gt,0,xt,wt),et.drawHandle(mt,1,xt,wt))),et.scrollbar&&(xt?(at=et.top-lt,ot=et.left-lt+(vt||!ft.opposite?0:(ft.titleOffset||0)+ft.axisTitleMargin),lt=ct+2*lt):(at=et.top+(vt?et.height:-lt),ot=et.left-lt),et.scrollbar.position(ot,at,nt,lt),et.scrollbar.setRange(et.zoomedMin/(ct||1),et.zoomedMax/(ct||1))),et.rendered=!0}},z.prototype.addMouseEvents=function(){var y=this,a=y.chart,k=a.container,j=[],et,it;y.mouseMoveHandler=et=function(nt){y.onMouseMove(nt)},y.mouseUpHandler=it=function(nt){y.onMouseUp(nt)},j=y.getPartsEvents("mousedown"),j.push(addEvent$M(a.renderTo,"mousemove",et),addEvent$M(k.ownerDocument,"mouseup",it)),hasTouch&&(j.push(addEvent$M(a.renderTo,"touchmove",et),addEvent$M(k.ownerDocument,"touchend",it)),j.concat(y.getPartsEvents("touchstart"))),y.eventsToUnbind=j,y.series&&y.series[0]&&j.push(addEvent$M(y.series[0].xAxis,"foundExtremes",function(){a.navigator.modifyNavigatorAxisExtremes()}))},z.prototype.getPartsEvents=function(y){var a=this,k=[];return["shades","handles"].forEach(function(j){a[j].forEach(function(et,it){k.push(addEvent$M(et.element,y,function(nt){a[j+"Mousedown"](nt,it)}))})}),k},z.prototype.shadesMousedown=function(y,a){y=this.chart.pointer.normalize(y);var k=this,j=k.chart,et=k.xAxis,it=k.zoomedMin,nt=k.left,ot=k.size,at=k.range,lt=y.chartX,ct,ht,ut,ft;j.inverted&&(lt=y.chartY,nt=k.top),a===1?(k.grabbedCenter=lt,k.fixedWidth=at,k.dragOffset=lt-it):(ft=lt-nt-at/2,a===0?ft=Math.max(0,ft):a===2&&ft+at>=ot&&(ft=ot-at,k.reversedExtremes?(ft-=at,ht=k.getUnionExtremes().dataMin):ct=k.getUnionExtremes().dataMax),ft!==it&&(k.fixedWidth=at,ut=et.navigatorAxis.toFixedRange(ft,ft+at,ht,ct),defined$w(ut.min)&&j.xAxis[0].setExtremes(Math.min(ut.min,ut.max),Math.max(ut.min,ut.max),!0,null,{trigger:"navigator"})))},z.prototype.handlesMousedown=function(y,a){y=this.chart.pointer.normalize(y);var k=this,j=k.chart,et=j.xAxis[0],it=k.reversedExtremes;a===0?(k.grabbedLeft=!0,k.otherHandlePos=k.zoomedMax,k.fixedExtreme=it?et.min:et.max):(k.grabbedRight=!0,k.otherHandlePos=k.zoomedMin,k.fixedExtreme=it?et.max:et.min),j.fixedRange=null},z.prototype.onMouseMove=function(y){var a=this,k=a.chart,j=a.left,et=a.navigatorSize,it=a.range,nt=a.dragOffset,ot=k.inverted,at;(!y.touches||y.touches[0].pageX!==0)&&(y=k.pointer.normalize(y),at=y.chartX,ot&&(j=a.top,at=y.chartY),a.grabbedLeft?(a.hasDragged=!0,a.render(0,0,at-j,a.otherHandlePos)):a.grabbedRight?(a.hasDragged=!0,a.render(0,0,a.otherHandlePos,at-j)):a.grabbedCenter&&(a.hasDragged=!0,at<nt?at=nt:at>et+nt-it&&(at=et+nt-it),a.render(0,0,at-nt,at-nt+it)),a.hasDragged&&a.scrollbar&&pick$14(a.scrollbar.options.liveRedraw,H.svg&&!isTouchDevice$1&&!this.chart.isBoosting)&&(y.DOMType=y.type,setTimeout(function(){a.onMouseUp(y)},0)))},z.prototype.onMouseUp=function(y){var a=this,k=a.chart,j=a.xAxis,et=a.scrollbar,it=y.DOMEvent||y,nt=k.inverted,ot=a.rendered&&!a.hasDragged?"animate":"attr",at,lt,ct,ht,ut,ft;(a.hasDragged&&(!et||!et.hasDragged)||y.trigger==="scrollbar")&&(ct=a.getUnionExtremes(),a.zoomedMin===a.otherHandlePos?ht=a.fixedExtreme:a.zoomedMax===a.otherHandlePos&&(ut=a.fixedExtreme),a.zoomedMax===a.size&&(ut=a.reversedExtremes?ct.dataMin:ct.dataMax),a.zoomedMin===0&&(ht=a.reversedExtremes?ct.dataMax:ct.dataMin),ft=j.navigatorAxis.toFixedRange(a.zoomedMin,a.zoomedMax,ht,ut),defined$w(ft.min)&&k.xAxis[0].setExtremes(Math.min(ft.min,ft.max),Math.max(ft.min,ft.max),!0,a.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:it})),y.DOMType!=="mousemove"&&y.DOMType!=="touchmove"&&(a.grabbedLeft=a.grabbedRight=a.grabbedCenter=a.fixedWidth=a.fixedExtreme=a.otherHandlePos=a.hasDragged=a.dragOffset=null),a.navigatorEnabled&&isNumber$v(a.zoomedMin)&&isNumber$v(a.zoomedMax)&&(lt=Math.round(a.zoomedMin),at=Math.round(a.zoomedMax),a.shades&&a.drawMasks(lt,at,nt,ot),a.outline&&a.drawOutline(lt,at,nt,ot),a.navigatorOptions.handles.enabled&&Object.keys(a.handles).length===a.handles.length&&(a.drawHandle(lt,0,nt,ot),a.drawHandle(at,1,nt,ot)))},z.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(y){y()}),this.eventsToUnbind=void 0),this.removeBaseSeriesEvents()},z.prototype.removeBaseSeriesEvents=function(){var y=this.baseSeries||[];this.navigatorEnabled&&y[0]&&(this.navigatorOptions.adaptToUpdatedData!==!1&&y.forEach(function(a){removeEvent$3(a,"updatedData",this.updatedDataHandler)},this),y[0].xAxis&&removeEvent$3(y[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},z.prototype.init=function(y){var a=y.options,k=a.navigator,j=k.enabled,et=a.scrollbar,it=et.enabled,nt=j?k.height:0,ot=it?et.height:0;this.handles=[],this.shades=[],this.chart=y,this.setBaseSeries(),this.height=nt,this.scrollbarHeight=ot,this.scrollbarEnabled=it,this.navigatorEnabled=j,this.navigatorOptions=k,this.scrollbarOptions=et,this.outlineHeight=nt+ot,this.opposite=pick$14(k.opposite,!!(!j&&y.inverted));var at=this,lt=at.baseSeries,ct=y.xAxis.length,ht=y.yAxis.length,ut=lt&&lt[0]&&lt[0].xAxis||y.xAxis[0]||{options:{}};y.isDirtyBox=!0,at.navigatorEnabled?(at.xAxis=new Axis(y,merge$Z({breaks:ut.options.breaks,ordinal:ut.options.ordinal},k.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:ct,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},y.inverted?{offsets:[ot,0,-ot,0],width:nt}:{offsets:[0,-ot,0,ot],height:nt})),at.yAxis=new Axis(y,merge$Z(k.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:ht,isInternal:!0,reversed:pick$14(k.yAxis&&k.yAxis.reversed,y.yAxis[0]&&y.yAxis[0].reversed,!1),zoomEnabled:!1},y.inverted?{width:nt}:{height:nt})),lt||k.series.data?at.updateNavigatorSeries(!1):y.series.length===0&&(at.unbindRedraw=addEvent$M(y,"beforeRedraw",function(){y.series.length>0&&!at.series&&(at.setBaseSeries(),at.unbindRedraw())})),at.reversedExtremes=y.inverted&&!at.xAxis.reversed||!y.inverted&&at.xAxis.reversed,at.renderElements(),at.addMouseEvents()):(at.xAxis={chart:y,navigatorAxis:{fake:!0},translate:function(ft,vt){var gt=y.xAxis[0],mt=gt.getExtremes(),bt=gt.len-2*ot,xt=numExt("min",gt.options.min,mt.dataMin),wt=numExt("max",gt.options.max,mt.dataMax)-xt;return vt?ft*wt/bt+xt:bt*(ft-xt)/wt},toPixels:function(ft){return this.translate(ft)},toValue:function(ft){return this.translate(ft,!0)}},at.xAxis.navigatorAxis.axis=at.xAxis,at.xAxis.navigatorAxis.toFixedRange=NavigatorAxis.AdditionsClass.prototype.toFixedRange.bind(at.xAxis.navigatorAxis)),y.options.scrollbar.enabled&&(y.scrollbar=at.scrollbar=new Scrollbar(y.renderer,merge$Z(y.options.scrollbar,{margin:at.navigatorEnabled?0:10,vertical:y.inverted}),y),addEvent$M(at.scrollbar,"changed",function(ft){var vt=at.size,gt=vt*this.to,mt=vt*this.from;at.hasDragged=at.scrollbar.hasDragged,at.render(0,0,mt,gt),this.shouldUpdateExtremes(ft.DOMType)&&setTimeout(function(){at.onMouseUp(ft)})})),at.addBaseSeriesEvents(),at.addChartEvents()},z.prototype.getUnionExtremes=function(y){var a=this.chart.xAxis[0],k=this.xAxis,j=k.options,et=a.options,it;return(!y||a.dataMin!==null)&&(it={dataMin:pick$14(j&&j.min,numExt("min",et.min,a.dataMin,k.dataMin,k.min)),dataMax:pick$14(j&&j.max,numExt("max",et.max,a.dataMax,k.dataMax,k.max))}),it},z.prototype.setBaseSeries=function(y,a){var k=this.chart,j=this.baseSeries=[];y=y||k.options&&k.options.navigator.baseSeries||(k.series.length?find$e(k.series,function(et){return!et.options.isInternal}).index:0),(k.series||[]).forEach(function(et,it){!et.options.isInternal&&(et.options.showInNavigator||(it===y||et.options.id===y)&&et.options.showInNavigator!==!1)&&j.push(et)}),this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,a)},z.prototype.updateNavigatorSeries=function(y,a){var k=this,j=k.chart,et=k.baseSeries,it,nt,ot=k.navigatorOptions.series,at,lt={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},ct=k.series=(k.series||[]).filter(function(ht){var ut=ht.baseSeries;return et.indexOf(ut)<0?(ut&&(removeEvent$3(ut,"updatedData",k.updatedDataHandler),delete ut.navigatorSeries),ht.chart&&ht.destroy(),!1):!0});et&&et.length&&et.forEach(function(ut){var ft=ut.navigatorSeries,vt=extend$17({color:ut.color,visible:ut.visible},isArray$b(ot)?defaultOptions$a.navigator.series:ot);if(!(ft&&k.navigatorOptions.adaptToUpdatedData===!1)){lt.name="Navigator "+et.length,it=ut.options||{},at=it.navigatorOptions||{},vt.dataLabels=splat$b(vt.dataLabels),nt=merge$Z(it,lt,vt,at),nt.pointRange=pick$14(vt.pointRange,at.pointRange,defaultOptions$a.plotOptions[nt.type||"line"].pointRange);var gt=at.data||vt.data;k.hasNavigatorData=k.hasNavigatorData||!!gt,nt.data=gt||it.data&&it.data.slice(0),ft&&ft.options?ft.update(nt,a):(ut.navigatorSeries=j.initSeries(nt),ut.navigatorSeries.baseSeries=ut,ct.push(ut.navigatorSeries))}}),(ot.data&&!(et&&et.length)||isArray$b(ot))&&(k.hasNavigatorData=!1,ot=splat$b(ot),ot.forEach(function(ht,ut){lt.name="Navigator "+(ct.length+1),nt=merge$Z(defaultOptions$a.navigator.series,{color:j.series[ut]&&!j.series[ut].options.isInternal&&j.series[ut].color||j.options.colors[ut]||j.options.colors[0]},lt,ht),nt.data=ht.data,nt.data&&(k.hasNavigatorData=!0,ct.push(j.initSeries(nt)))})),y&&this.addBaseSeriesEvents()},z.prototype.addBaseSeriesEvents=function(){var y=this,a=y.baseSeries||[];a[0]&&a[0].xAxis&&a[0].eventsToUnbind.push(addEvent$M(a[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes)),a.forEach(function(k){k.eventsToUnbind.push(addEvent$M(k,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)})),k.eventsToUnbind.push(addEvent$M(k,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)})),this.navigatorOptions.adaptToUpdatedData!==!1&&k.xAxis&&k.eventsToUnbind.push(addEvent$M(k,"updatedData",this.updatedDataHandler)),k.eventsToUnbind.push(addEvent$M(k,"remove",function(){this.navigatorSeries&&(erase$2(y.series,this.navigatorSeries),defined$w(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))},this)},z.prototype.getBaseSeriesMin=function(y){return this.baseSeries.reduce(function(a,k){return Math.min(a,k.xData?k.xData[0]:a)},y)},z.prototype.modifyNavigatorAxisExtremes=function(){var y=this.xAxis,a;typeof y.getExtremes<"u"&&(a=this.getUnionExtremes(!0),a&&(a.dataMin!==y.min||a.dataMax!==y.max)&&(y.min=a.dataMin,y.max=a.dataMax))},z.prototype.modifyBaseAxisExtremes=function(){var y=this,a=y.chart.navigator,k=y.getExtremes(),j=k.min,et=k.max,it=k.dataMin,nt=k.dataMax,ot=et-j,at=a.stickToMin,lt=a.stickToMax,ct=pick$14(y.options.overscroll,0),ht,ut,ft=a.series&&a.series[0],vt=!!y.setExtremes,gt=y.eventArgs&&y.eventArgs.trigger==="rangeSelectorButton";gt||(at&&(ut=it,ht=ut+ot),lt&&(ht=nt+ct,at||(ut=Math.max(it,ht-ot,a.getBaseSeriesMin(ft&&ft.xData?ft.xData[0]:-Number.MAX_VALUE)))),vt&&(at||lt)&&isNumber$v(ut)&&(y.min=y.userMin=ut,y.max=y.userMax=ht)),a.stickToMin=a.stickToMax=null},z.prototype.updatedDataHandler=function(){var y=this.chart.navigator,a=this,k=this.navigatorSeries;y.stickToMax=y.reversedExtremes?Math.round(y.zoomedMin)===0:Math.round(y.zoomedMax)>=Math.round(y.size),y.stickToMin=y.shouldStickToMin(a,y),k&&!y.hasNavigatorData&&(k.options.pointStart=a.xData[0],k.setData(a.options.data,!1,null,!1))},z.prototype.shouldStickToMin=function(y,a){var k=a.getBaseSeriesMin(y.xData[0]),j=y.xAxis,et=j.max,it=j.min,nt=j.options.range,ot=!0;return isNumber$v(et)&&isNumber$v(it)?nt&&et-k>0?ot=et-k<nt&&!this.chart.fixedRange:ot=it<=k:ot=!1,ot},z.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]),this.eventsToUnbind.push(addEvent$M(this.chart,"redraw",function(){var y=this.navigator,a=y&&(y.baseSeries&&y.baseSeries[0]&&y.baseSeries[0].xAxis||this.xAxis[0]);a&&y.render(a.min,a.max)}),addEvent$M(this.chart,"getMargins",function(){var y=this,a=y.navigator,k=a.opposite?"plotTop":"marginBottom";y.inverted&&(k=a.opposite?"marginRight":"plotLeft"),y[k]=(y[k]||0)+(a.navigatorEnabled||!y.inverted?a.outlineHeight:0)+a.navigatorOptions.margin}))},z.prototype.destroy=function(){this.removeEvents(),this.xAxis&&(erase$2(this.chart.xAxis,this.xAxis),erase$2(this.chart.axes,this.xAxis)),this.yAxis&&(erase$2(this.chart.yAxis,this.yAxis),erase$2(this.chart.axes,this.yAxis)),(this.series||[]).forEach(function(y){y.destroy&&y.destroy()}),["series","xAxis","yAxis","shades","outline","scrollbarTrack","scrollbarRifles","scrollbarGroup","scrollbar","navigatorGroup","rendered"].forEach(function(y){this[y]&&this[y].destroy&&this[y].destroy(),this[y]=null},this),[this.handles].forEach(function(y){destroyObjectProperties$2(y)},this)},z})();H.Navigator||(H.Navigator=Navigator,NavigatorAxis.compose(Axis),addEvent$M(Chart$1,"beforeShowResetZoom",function(){var z=this.options,y=z.navigator,a=z.rangeSelector;if((y&&y.enabled||a&&a.enabled)&&(!isTouchDevice$1&&z.chart.zoomType==="x"||isTouchDevice$1&&z.chart.pinchType==="x"))return!1}),addEvent$M(Chart$1,"beforeRender",function(){var z=this.options;(z.navigator.enabled||z.scrollbar.enabled)&&(this.scroller=this.navigator=new Navigator(this))}),addEvent$M(Chart$1,"afterSetChartSize",function(){var z=this.legend,y=this.navigator,a,k,j,et;y&&(k=z&&z.options,j=y.xAxis,et=y.yAxis,a=y.scrollbarHeight,this.inverted?(y.left=y.opposite?this.chartWidth-a-y.height:this.spacing[3]+a,y.top=this.plotTop+a):(y.left=pick$14(j.left,this.plotLeft+a),y.top=y.navigatorOptions.top||this.chartHeight-y.height-a-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(k&&k.verticalAlign==="bottom"&&k.layout!=="proximate"&&k.enabled&&!k.floating?z.legendHeight+pick$14(k.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0)),j&&et&&(this.inverted?j.options.left=et.options.left=y.left:j.options.top=et.options.top=y.top,j.setAxisSize(),et.setAxisSize()))}),addEvent$M(Chart$1,"update",function(z){var y=z.options.navigator||{},a=z.options.scrollbar||{};!this.navigator&&!this.scroller&&(y.enabled||a.enabled)&&(merge$Z(!0,this.options.navigator,y),merge$Z(!0,this.options.scrollbar,a),delete z.options.navigator,delete z.options.scrollbar)}),addEvent$M(Chart$1,"afterUpdate",function(z){!this.navigator&&!this.scroller&&(this.options.navigator.enabled||this.options.scrollbar.enabled)&&(this.scroller=this.navigator=new Navigator(this),pick$14(z.redraw,!0)&&this.redraw(z.animation))}),addEvent$M(Chart$1,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),addEvent$M(Series$f,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}),Chart$1.prototype.callbacks.push(function(z){var y,a=z.navigator;a&&z.xAxis[0]&&(y=z.xAxis[0].getExtremes(),a.render(y.min,y.max))}));H.Navigator=Navigator;H.Navigator;var defaultOptions$9=DefaultOptions.defaultOptions,addEvent$L=Utilities.addEvent,createElement$3=Utilities.createElement,css$2=Utilities.css,defined$v=Utilities.defined,destroyObjectProperties$1=Utilities.destroyObjectProperties,discardElement$2=Utilities.discardElement,extend$16=Utilities.extend,find$d=Utilities.find,fireEvent$k=Utilities.fireEvent,isNumber$u=Utilities.isNumber,merge$Y=Utilities.merge,objectEach$f=Utilities.objectEach,pad=Utilities.pad,pick$13=Utilities.pick,pInt$3=Utilities.pInt,splat$a=Utilities.splat;extend$16(defaultOptions$9,{rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%b %e, %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:palette.highlightColor80,cursor:"pointer"},labelStyle:{color:palette.neutralColor60}}});extend$16(defaultOptions$9.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"→"});var RangeSelector=(function(){function z(y){this.buttons=void 0,this.buttonOptions=z.prototype.defaultButtons,this.initialButtonGroupWidth=0,this.options=void 0,this.chart=y,this.init(y)}return z.prototype.clickButton=function(y,a){var k=this,j=k.chart,et=k.buttonOptions[y],it=j.xAxis[0],nt=j.scroller&&j.scroller.getUnionExtremes()||it||{},ot=nt.dataMin,at=nt.dataMax,lt,ct=it&&Math.round(Math.min(it.max,pick$13(at,it.max))),ht=et.type,ut,ft=et._range,vt,gt,mt,bt,xt,wt=et.dataGrouping;if(!(ot===null||at===null)){if(j.fixedRange=ft,k.setSelected(y),wt&&(this.forcedDataGrouping=!0,Axis.prototype.setDataGrouping.call(it||{chart:this.chart},wt,!1),this.frozenStates=et.preserveDataGrouping),ht==="month"||ht==="year")it?(bt={range:et,max:ct,chart:j,dataMin:ot,dataMax:at},lt=it.minFromRange.call(bt),isNumber$u(bt.newMax)&&(ct=bt.newMax)):ft=et;else if(ft)lt=Math.max(ct-ft,ot),ct=Math.min(lt+ft,at);else if(ht==="ytd")if(it)typeof at>"u"&&(ot=Number.MAX_VALUE,at=Number.MIN_VALUE,j.series.forEach(function(Mt){var Et=Mt.xData;ot=Math.min(Et[0],ot),at=Math.max(Et[Et.length-1],at)}),a=!1),xt=k.getYTDExtremes(at,ot,j.time.useUTC),lt=vt=xt.min,ct=xt.max;else{k.deferredYTDClick=y;return}else ht==="all"&&it&&(j.navigator&&j.navigator.baseSeries[0]&&(j.navigator.baseSeries[0].xAxis.options.range=void 0),lt=ot,ct=at);defined$v(lt)&&(lt+=et._offsetMin),defined$v(ct)&&(ct+=et._offsetMax),this.dropdown&&(this.dropdown.selectedIndex=y+1),it?it.setExtremes(lt,ct,pick$13(a,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:et}):(ut=splat$a(j.options.xAxis)[0],mt=ut.range,ut.range=ft,gt=ut.min,ut.min=vt,addEvent$L(j,"load",function(){ut.range=mt,ut.min=gt})),fireEvent$k(this,"afterBtnClick")}},z.prototype.setSelected=function(y){this.selected=this.options.selected=y},z.prototype.init=function(y){var a=this,k=y.options.rangeSelector,j=k.buttons||a.defaultButtons.slice(),et=k.selected,it=function(){var nt=a.minInput,ot=a.maxInput;nt&&nt.blur&&fireEvent$k(nt,"blur"),ot&&ot.blur&&fireEvent$k(ot,"blur")};a.chart=y,a.options=k,a.buttons=[],a.buttonOptions=j,this.eventsToUnbind=[],this.eventsToUnbind.push(addEvent$L(y.container,"mousedown",it)),this.eventsToUnbind.push(addEvent$L(y,"resize",it)),j.forEach(a.computeButtonRange),typeof et<"u"&&j[et]&&this.clickButton(et,!1),this.eventsToUnbind.push(addEvent$L(y,"load",function(){y.xAxis&&y.xAxis[0]&&addEvent$L(y.xAxis[0],"setExtremes",function(nt){this.max-this.min!==y.fixedRange&&nt.trigger!=="rangeSelectorButton"&&nt.trigger!=="updatedData"&&a.forcedDataGrouping&&!a.frozenStates&&this.setDataGrouping(!1,!1)})}))},z.prototype.updateButtonStates=function(){var y=this,a=this.chart,k=this.dropdown,j=a.xAxis[0],et=Math.round(j.max-j.min),it=!j.hasVisibleSeries,nt=24*36e5,ot=a.scroller&&a.scroller.getUnionExtremes()||j,at=ot.dataMin,lt=ot.dataMax,ct=y.getYTDExtremes(lt,at,a.time.useUTC),ht=ct.min,ut=ct.max,ft=y.selected,vt=isNumber$u(ft),gt=y.options.allButtonsEnabled,mt=y.buttons;y.buttonOptions.forEach(function(bt,xt){var wt=bt._range,Mt=bt.type,Et=bt.count||1,St=mt[xt],kt=0,Pt,It,Nt=bt._offsetMax-bt._offsetMin,Ut=xt===ft,Rt=wt>lt-at,Ft=wt<j.minRange,Dt=!1,Ht=!1,Gt=wt===et;(Mt==="month"||Mt==="year")&&et+36e5>={month:28,year:365}[Mt]*nt*Et-Nt&&et-36e5<={month:31,year:366}[Mt]*nt*Et+Nt?Gt=!0:Mt==="ytd"?(Gt=ut-ht+Nt===et,Dt=!Ut):Mt==="all"&&(Gt=j.max-j.min>=lt-at,Ht=!Ut&&vt&&Gt),Pt=!gt&&(Rt||Ft||Ht||it),It=Ut&&Gt||Gt&&!vt&&!Dt||Ut&&y.frozenStates,Pt?kt=3:It&&(vt=!0,kt=2),St.state!==kt&&(St.setState(kt),k&&(k.options[xt+1].disabled=Pt,kt===2&&(k.selectedIndex=xt+1)),kt===0&&ft===xt&&y.setSelected())})},z.prototype.computeButtonRange=function(y){var a=y.type,k=y.count||1,j={millisecond:1,second:1e3,minute:60*1e3,hour:3600*1e3,day:24*3600*1e3,week:168*3600*1e3};j[a]?y._range=j[a]*k:(a==="month"||a==="year")&&(y._range={month:30,year:365}[a]*24*36e5*k),y._offsetMin=pick$13(y.offsetMin,0),y._offsetMax=pick$13(y.offsetMax,0),y._range+=y._offsetMax-y._offsetMin},z.prototype.getInputValue=function(y){var a=y==="min"?this.minInput:this.maxInput,k=this.chart.options.rangeSelector,j=this.chart.time;return a?(a.type==="text"&&k.inputDateParser||this.defaultInputDateParser)(a.value,j.useUTC,j):0},z.prototype.setInputValue=function(y,a){var k=this.options,j=this.chart.time,et=y==="min"?this.minInput:this.maxInput,it=y==="min"?this.minDateBox:this.maxDateBox;if(et){var nt=et.getAttribute("data-hc-time"),ot=defined$v(nt)?Number(nt):void 0;if(defined$v(a)){var at=ot;defined$v(at)&&et.setAttribute("data-hc-time-previous",at),et.setAttribute("data-hc-time",a),ot=a}et.value=j.dateFormat(this.inputTypeFormats[et.type]||k.inputEditDateFormat,ot),it&&it.attr({text:j.dateFormat(k.inputDateFormat,ot)})}},z.prototype.setInputExtremes=function(y,a,k){var j=y==="min"?this.minInput:this.maxInput;if(j){var et=this.inputTypeFormats[j.type],it=this.chart.time;if(et){var nt=it.dateFormat(et,a);j.min!==nt&&(j.min=nt);var ot=it.dateFormat(et,k);j.max!==ot&&(j.max=ot)}}},z.prototype.showInput=function(y){var a=y==="min"?this.minDateBox:this.maxDateBox,k=y==="min"?this.minInput:this.maxInput;if(k&&a&&this.inputGroup){var j=k.type==="text",et=this.inputGroup,it=et.translateX,nt=et.translateY,ot=this.options.inputBoxWidth;css$2(k,{width:j?a.width+(ot?-2:20)+"px":"auto",height:j?a.height-2+"px":"auto",border:"2px solid silver"}),j&&ot?css$2(k,{left:it+a.x+"px",top:nt+"px"}):css$2(k,{left:Math.min(Math.round(a.x+it-(k.offsetWidth-a.width)/2),this.chart.chartWidth-k.offsetWidth)+"px",top:nt-(k.offsetHeight-a.height)/2+"px"})}},z.prototype.hideInput=function(y){var a=y==="min"?this.minInput:this.maxInput;a&&css$2(a,{top:"-9999em",border:0,width:"1px",height:"1px"})},z.prototype.defaultInputDateParser=function(y,a,k){var j=function(at){return at.length>6&&(at.lastIndexOf("-")===at.length-6||at.lastIndexOf("+")===at.length-6)},et=y.split("/").join("-").split(" ").join("T");if(et.indexOf("T")===-1&&(et+="T00:00"),a)et+="Z";else if(H.isSafari&&!j(et)){var it=new Date(et).getTimezoneOffset()/60;et+=it<=0?"+"+pad(-it)+":00":"-"+pad(it)+":00"}var nt=Date.parse(et);if(!isNumber$u(nt)){var ot=y.split("-");nt=Date.UTC(pInt$3(ot[0]),pInt$3(ot[1])-1,pInt$3(ot[2]))}return k&&a&&isNumber$u(nt)&&(nt+=k.getTimezoneOffset(nt)),nt},z.prototype.drawInput=function(y){var a=this,k=a.chart,j=a.div,et=a.inputGroup,it=this,nt=k.renderer.style||{},ot=k.renderer,at=k.options.rangeSelector,lt=defaultOptions$9.lang,ct=y==="min";function ht(){var bt=it.getInputValue(y),xt=k.xAxis[0],wt=k.scroller&&k.scroller.xAxis?k.scroller.xAxis:xt,Mt=wt.dataMin,Et=wt.dataMax,St=it.maxInput,kt=it.minInput;bt!==Number(gt.getAttribute("data-hc-time-previous"))&&isNumber$u(bt)&&(gt.setAttribute("data-hc-time-previous",bt),ct&&St&&isNumber$u(Mt)?bt>Number(St.getAttribute("data-hc-time"))?bt=void 0:bt<Mt&&(bt=Mt):kt&&isNumber$u(Et)&&(bt<Number(kt.getAttribute("data-hc-time"))?bt=void 0:bt>Et&&(bt=Et)),typeof bt<"u"&&xt.setExtremes(ct?bt:xt.min,ct?xt.max:bt,void 0,void 0,{trigger:"rangeSelectorInput"}))}var ut=lt[ct?"rangeSelectorFrom":"rangeSelectorTo"]||"",ft=ot.label(ut,0).addClass("highcharts-range-label").attr({padding:ut?2:0,height:ut?at.inputBoxHeight:0}).add(et),vt=ot.label("",0).addClass("highcharts-range-input").attr({padding:2,width:at.inputBoxWidth,height:at.inputBoxHeight,"text-align":"center"}).on("click",function(){it.showInput(y),it[y+"Input"].focus()});k.styledMode||vt.attr({stroke:at.inputBoxBorderColor,"stroke-width":1}),vt.add(et);var gt=createElement$3("input",{name:y,className:"highcharts-range-selector"},void 0,j);gt.setAttribute("type",preferredInputType(at.inputDateFormat||"%b %e, %Y")),k.styledMode||(ft.css(merge$Y(nt,at.labelStyle)),vt.css(merge$Y({color:palette.neutralColor80},nt,at.inputStyle)),css$2(gt,extend$16({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:nt.fontSize,fontFamily:nt.fontFamily,top:"-9999em"},at.inputStyle))),gt.onfocus=function(){it.showInput(y)},gt.onblur=function(){gt===H.doc.activeElement&&ht(),it.hideInput(y),it.setInputValue(y),gt.blur()};var mt=!1;return gt.onchange=function(){mt||(ht(),it.hideInput(y),gt.blur())},gt.onkeypress=function(bt){bt.keyCode===13&&ht()},gt.onkeydown=function(bt){mt=!0,(bt.keyCode===38||bt.keyCode===40)&&ht()},gt.onkeyup=function(){mt=!1},{dateBox:vt,input:gt,label:ft}},z.prototype.getPosition=function(){var y=this.chart,a=y.options.rangeSelector,k=a.verticalAlign==="top"?y.plotTop-y.axisOffset[0]:0;return{buttonTop:k+a.buttonPosition.y,inputTop:k+a.inputPosition.y-10}},z.prototype.getYTDExtremes=function(y,a,k){var j=this.chart.time,et,it=new j.Date(y),nt=j.get("FullYear",it),ot=k?j.Date.UTC(nt,0,1):+new j.Date(nt,0,1);et=Math.max(a,ot);var at=it.getTime();return{max:Math.min(y||at,at),min:et}},z.prototype.render=function(y,a){var k=this.chart,j=k.renderer,et=k.container,it=k.options,nt=it.rangeSelector,ot=pick$13(it.chart.style&&it.chart.style.zIndex,0)+1,at=nt.inputEnabled,lt=this.rendered;if(nt.enabled!==!1){if(!lt&&(this.group=j.g("range-selector-group").attr({zIndex:7}).add(),this.div=createElement$3("div",void 0,{position:"relative",height:0,zIndex:ot}),this.buttonOptions.length&&this.renderButtons(),et.parentNode&&et.parentNode.insertBefore(this.div,et),at)){this.inputGroup=j.g("input-group").add(this.group);var ct=this.drawInput("min");this.minDateBox=ct.dateBox,this.minLabel=ct.label,this.minInput=ct.input;var ht=this.drawInput("max");this.maxDateBox=ht.dateBox,this.maxLabel=ht.label,this.maxInput=ht.input}if(at){this.setInputValue("min",y),this.setInputValue("max",a);var ut=k.scroller&&k.scroller.getUnionExtremes()||k.xAxis[0]||{};if(defined$v(ut.dataMin)&&defined$v(ut.dataMax)){var ft=k.xAxis[0].minRange||0;this.setInputExtremes("min",ut.dataMin,Math.min(ut.dataMax,this.getInputValue("max"))-ft),this.setInputExtremes("max",Math.max(ut.dataMin,this.getInputValue("min"))+ft,ut.dataMax)}if(this.inputGroup){var vt=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(gt){if(gt){var mt=gt.getBBox().width;mt&&(gt.attr({x:vt}),vt+=mt+nt.inputSpacing)}})}}this.alignElements(),this.rendered=!0}},z.prototype.renderButtons=function(){var y=this,a=this,k=a.buttons,j=a.chart,et=a.options,it=defaultOptions$9.lang,nt=j.renderer,ot=merge$Y(et.buttonTheme),at=ot&&ot.states,lt=ot.width||28;delete ot.width,delete ot.states,this.buttonGroup=nt.g("range-selector-buttons").add(this.group);var ct=this.dropdown=createElement$3("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:1e-4},this.div);addEvent$L(ct,"touchstart",function(){ct.style.fontSize="16px"}),[[H.isMS?"mouseover":"mouseenter"],[H.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(ht){var ut=ht[0],ft=ht[1];addEvent$L(ct,ut,function(){var vt=k[y.currentButtonIndex()];vt&&fireEvent$k(vt.element,ft||ut)})}),this.zoomText=nt.label(it&&it.rangeSelectorZoom||"",0).attr({padding:et.buttonTheme.padding,height:et.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup),this.chart.styledMode||(this.zoomText.css(et.labelStyle),ot["stroke-width"]=pick$13(ot["stroke-width"],0)),createElement$3("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,ct),this.buttonOptions.forEach(function(ht,ut){createElement$3("option",{textContent:ht.title||ht.text},void 0,ct),k[ut]=nt.button(ht.text,0,0,function(ft){var vt=ht.events&&ht.events.click,gt;vt&&(gt=vt.call(ht,ft)),gt!==!1&&y.clickButton(ut),y.isActive=!0},ot,at&&at.hover,at&&at.select,at&&at.disabled).attr({"text-align":"center",width:lt}).add(y.buttonGroup),ht.title&&k[ut].attr("title",ht.title)})},z.prototype.alignElements=function(){var y=this,a=this,k=a.buttonGroup,j=a.buttons,et=a.chart,it=a.group,nt=a.inputGroup,ot=a.options,at=a.zoomText,lt=et.options,ct=lt.exporting&&lt.exporting.enabled!==!1&&lt.navigation&&lt.navigation.buttonOptions,ht=ot.buttonPosition,ut=ot.inputPosition,ft=ot.verticalAlign,vt=function(Ft,Dt){return ct&&y.titleCollision(et)&&ft==="top"&&Dt.align==="right"&&Dt.y-Ft.getBBox().height-12<(ct.y||0)+(ct.height||0)+et.spacing[0]?-40:0},gt=et.plotLeft;if(it&&ht&&ut){var mt=ht.x-et.spacing[3];if(k){if(this.positionButtons(),!this.initialButtonGroupWidth){var bt=0;at&&(bt+=at.getBBox().width+5),j.forEach(function(Ft,Dt){bt+=Ft.width,Dt!==j.length-1&&(bt+=ot.buttonSpacing)}),this.initialButtonGroupWidth=bt}gt-=et.spacing[3],this.updateButtonStates();var xt=vt(k,ht);this.alignButtonGroup(xt),it.placed=k.placed=et.hasLoaded}var wt=0;nt&&(wt=vt(nt,ut),ut.align==="left"?mt=gt:ut.align==="right"&&(mt=-Math.max(et.axisOffset[1],-wt)),nt.align({y:ut.y,width:nt.getBBox().width,align:ut.align,x:ut.x+mt-2},!0,et.spacingBox),nt.placed=et.hasLoaded),this.handleCollision(wt),it.align({verticalAlign:ft},!0,et.spacingBox);var Mt=it.alignAttr.translateY,Et=it.getBBox().height+20,St=0;if(ft==="bottom"){var kt=et.legend&&et.legend.options,Pt=kt&&kt.verticalAlign==="bottom"&&kt.enabled&&!kt.floating?et.legend.legendHeight+pick$13(kt.margin,10):0;Et=Et+Pt-20,St=Mt-Et-(ot.floating?0:ot.y)-(et.titleOffset?et.titleOffset[2]:0)-10}ft==="top"?(ot.floating&&(St=0),et.titleOffset&&et.titleOffset[0]&&(St=et.titleOffset[0]),St+=et.margin[0]-et.spacing[0]||0):ft==="middle"&&(ut.y===ht.y?St=Mt:(ut.y||ht.y)&&(ut.y<0||ht.y<0?St-=Math.min(ut.y,ht.y):St=Mt-Et)),it.translate(ot.x,ot.y+Math.floor(St));var It=this,Nt=It.minInput,Ut=It.maxInput,Rt=It.dropdown;ot.inputEnabled&&Nt&&Ut&&(Nt.style.marginTop=it.translateY+"px",Ut.style.marginTop=it.translateY+"px"),Rt&&(Rt.style.marginTop=it.translateY+"px")}},z.prototype.alignButtonGroup=function(y,a){var k=this,j=k.chart,et=k.options,it=k.buttonGroup;k.buttons;var nt=et.buttonPosition,ot=j.plotLeft-j.spacing[3],at=nt.x-j.spacing[3];nt.align==="right"?at+=y-ot:nt.align==="center"&&(at-=ot/2),it&&it.align({y:nt.y,width:pick$13(a,this.initialButtonGroupWidth),align:nt.align,x:at},!0,j.spacingBox)},z.prototype.positionButtons=function(){var y=this,a=y.buttons,k=y.chart,j=y.options,et=y.zoomText,it=k.hasLoaded?"animate":"attr",nt=j.buttonPosition,ot=k.plotLeft,at=ot;et&&et.visibility!=="hidden"&&(et[it]({x:pick$13(ot+nt.x,ot)}),at+=nt.x+et.getBBox().width+5),this.buttonOptions.forEach(function(lt,ct){a[ct].visibility!=="hidden"?(a[ct][it]({x:at}),at+=a[ct].width+j.buttonSpacing):a[ct][it]({x:ot})})},z.prototype.handleCollision=function(y){var a=this,k=this,j=k.chart,et=k.buttonGroup,it=k.inputGroup,nt=this.options,ot=nt.buttonPosition,at=nt.dropdown,lt=nt.inputPosition,ct=function(){var ft=0;return a.buttons.forEach(function(vt){var gt=vt.getBBox();gt.width>ft&&(ft=gt.width)}),ft},ht=function(ft){if(it&&et){var vt=it.alignAttr.translateX+it.alignOptions.x-y+it.getBBox().x+2,gt=it.alignOptions.width,mt=et.alignAttr.translateX+et.getBBox().x;return mt+ft>vt&&vt+gt>mt&&ot.y<lt.y+it.getBBox().height}return!1},ut=function(){it&&et&&it.attr({translateX:it.alignAttr.translateX+(j.axisOffset[1]>=-y?0:-y),translateY:it.alignAttr.translateY+et.getBBox().height+10})};if(et){if(at==="always"){this.collapseButtons(y),ht(ct())&&ut();return}at==="never"&&this.expandButtons()}it&&et?lt.align===ot.align||ht(this.initialButtonGroupWidth+20)?at==="responsive"?(this.collapseButtons(y),ht(ct())&&ut()):ut():at==="responsive"&&this.expandButtons():et&&at==="responsive"&&(this.initialButtonGroupWidth>j.plotWidth?this.collapseButtons(y):this.expandButtons())},z.prototype.collapseButtons=function(y){var a=this,k=a.buttons,j=a.buttonOptions,et=a.chart,it=a.dropdown,nt=a.options,ot=a.zoomText,at=et.userOptions.rangeSelector&&et.userOptions.rangeSelector.buttonTheme||{},lt=function(ut){return{text:ut?ut+" ▾":"▾",width:"auto",paddingLeft:pick$13(nt.buttonTheme.paddingLeft,at.padding,8),paddingRight:pick$13(nt.buttonTheme.paddingRight,at.padding,8)}};ot&&ot.hide();var ct=!1;j.forEach(function(ut,ft){var vt=k[ft];vt.state!==2?vt.hide():(vt.show(),vt.attr(lt(ut.text)),ct=!0)}),ct||(it&&(it.selectedIndex=0),k[0].show(),k[0].attr(lt(this.zoomText&&this.zoomText.textStr)));var ht=nt.buttonPosition.align;this.positionButtons(),(ht==="right"||ht==="center")&&this.alignButtonGroup(y,k[this.currentButtonIndex()].getBBox().width),this.showDropdown()},z.prototype.expandButtons=function(){var y=this,a=y.buttons,k=y.buttonOptions,j=y.options,et=y.zoomText;this.hideDropdown(),et&&et.show(),k.forEach(function(it,nt){var ot=a[nt];ot.show(),ot.attr({text:it.text,width:j.buttonTheme.width||28,paddingLeft:pick$13(j.buttonTheme.paddingLeft,"unset"),paddingRight:pick$13(j.buttonTheme.paddingRight,"unset")}),ot.state<2&&ot.setState(0)}),this.positionButtons()},z.prototype.currentButtonIndex=function(){var y=this.dropdown;return y&&y.selectedIndex>0?y.selectedIndex-1:0},z.prototype.showDropdown=function(){var y=this,a=y.buttonGroup,k=y.buttons,j=y.chart,et=y.dropdown;if(a&&et){var it=a.translateX,nt=a.translateY,ot=k[this.currentButtonIndex()].getBBox();css$2(et,{left:j.plotLeft+it+"px",top:nt+.5+"px",width:ot.width+"px",height:ot.height+"px"}),this.hasVisibleDropdown=!0}},z.prototype.hideDropdown=function(){var y=this.dropdown;y&&(css$2(y,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)},z.prototype.getHeight=function(){var y=this,a=y.options,k=y.group,j=a.inputPosition,et=a.buttonPosition,it=a.y,nt=et.y,ot=j.y,at=0,lt;return a.height?a.height:(this.alignElements(),at=k?k.getBBox(!0).height+13+it:0,lt=Math.min(ot,nt),(ot<0&&nt<0||ot>0&&nt>0)&&(at+=Math.abs(lt)),at)},z.prototype.titleCollision=function(y){return!(y.options.title.text||y.options.subtitle.text)},z.prototype.update=function(y){var a=this.chart;merge$Y(!0,a.options.rangeSelector,y),this.destroy(),this.init(a),this.render()},z.prototype.destroy=function(){var y=this,a=y.minInput,k=y.maxInput;y.eventsToUnbind&&(y.eventsToUnbind.forEach(function(j){return j()}),y.eventsToUnbind=void 0),destroyObjectProperties$1(y.buttons),a&&(a.onfocus=a.onblur=a.onchange=null),k&&(k.onfocus=k.onblur=k.onchange=null),objectEach$f(y,function(j,et){j&&et!=="chart"&&(j instanceof SVGElement?j.destroy():j instanceof window.HTMLElement&&discardElement$2(j)),j!==z.prototype[et]&&(y[et]=null)},this)},z})();RangeSelector.prototype.defaultButtons=[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}];RangeSelector.prototype.inputTypeFormats={"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"};function preferredInputType(z){var y=z.indexOf("%L")!==-1;if(y)return"text";var a=["a","A","d","e","w","b","B","m","o","y","Y"].some(function(j){return z.indexOf("%"+j)!==-1}),k=["H","k","I","l","M","S"].some(function(j){return z.indexOf("%"+j)!==-1});return a&&k?"datetime-local":a?"date":k?"time":"text"}Axis.prototype.minFromRange=function(){var z=this.range,y=z.type,a,k=this.max,j,et,it=this.chart.time,nt=function(ot,at){var lt=y==="year"?"FullYear":"Month",ct=new it.Date(ot),ht=it.get(lt,ct);return it.set(lt,ct,ht+at),ht===it.get(lt,ct)&&it.set("Date",ct,0),ct.getTime()-ot};return isNumber$u(z)?(a=k-z,et=z):(a=k+nt(k,-z.count),this.chart&&(this.chart.fixedRange=k-a)),j=pick$13(this.dataMin,Number.MIN_VALUE),isNumber$u(a)||(a=j),a<=j&&(a=j,typeof et>"u"&&(et=nt(a,z.count)),this.newMax=Math.min(a+et,this.dataMax)),isNumber$u(k)||(a=void 0),a};if(!H.RangeSelector){var chartDestroyEvents_1=[],initRangeSelector_1=function(z){var y,a=z.rangeSelector,k,j,et;function it(){a&&(y=z.xAxis[0].getExtremes(),k=z.legend,et=a&&a.options.verticalAlign,isNumber$u(y.min)&&a.render(y.min,y.max),k.display&&et==="top"&&et===k.options.verticalAlign&&(j=merge$Y(z.spacingBox),k.options.layout==="vertical"?j.y=z.plotTop:j.y+=a.getHeight(),k.group.placed=!1,k.align(j)))}if(a){var nt=find$d(chartDestroyEvents_1,function(ot){return ot[0]===z});nt||chartDestroyEvents_1.push([z,[addEvent$L(z.xAxis[0],"afterSetExtremes",function(ot){a&&a.render(ot.min,ot.max)}),addEvent$L(z,"redraw",it)]]),it()}};addEvent$L(Chart$1,"afterGetContainer",function(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new RangeSelector(this))}),addEvent$L(Chart$1,"beforeRender",function(){var z=this,y=z.axes,a=z.rangeSelector,k;a&&(isNumber$u(a.deferredYTDClick)&&(a.clickButton(a.deferredYTDClick),delete a.deferredYTDClick),y.forEach(function(j){j.updateNames(),j.setScale()}),z.getAxisMargins(),a.render(),k=a.options.verticalAlign,a.options.floating||(k==="bottom"?this.extraBottomMargin=!0:k!=="middle"&&(this.extraTopMargin=!0)))}),addEvent$L(Chart$1,"update",function(z){var y=this,a=z.options,k=a.rangeSelector,j=y.rangeSelector,et,it=this.extraBottomMargin,nt=this.extraTopMargin;k&&k.enabled&&!defined$v(j)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=j=new RangeSelector(this)),this.extraBottomMargin=!1,this.extraTopMargin=!1,j&&(initRangeSelector_1(this),et=k&&k.verticalAlign||j.options&&j.options.verticalAlign,j.options.floating||(et==="bottom"?this.extraBottomMargin=!0:et!=="middle"&&(this.extraTopMargin=!0)),(this.extraBottomMargin!==it||this.extraTopMargin!==nt)&&(this.isDirtyBox=!0))}),addEvent$L(Chart$1,"render",function(){var z=this,y=z.rangeSelector,a;y&&!y.options.floating&&(y.render(),a=y.options.verticalAlign,a==="bottom"?this.extraBottomMargin=!0:a!=="middle"&&(this.extraTopMargin=!0))}),addEvent$L(Chart$1,"getMargins",function(){var z=this.rangeSelector,y;z&&(y=z.getHeight(),this.extraTopMargin&&(this.plotTop+=y),this.extraBottomMargin&&(this.marginBottom+=y))}),Chart$1.prototype.callbacks.push(initRangeSelector_1),addEvent$L(Chart$1,"destroy",function(){for(var y=0;y<chartDestroyEvents_1.length;y++){var a=chartDestroyEvents_1[y];if(a[0]===this){a[1].forEach(function(k){return k()}),chartDestroyEvents_1.splice(y,1);return}}}),H.RangeSelector=RangeSelector}var __extends$1$=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),animObject$5=animationExports.animObject,format$7=FormatUtilities.format,getOptions$3=DefaultOptions.getOptions,pointTooltipFormatter=Point$4.prototype.tooltipFormatter,_a$c=Series$f.prototype,seriesInit=_a$c.init,seriesProcessData=_a$c.processData,addEvent$K=Utilities.addEvent,arrayMax$4=Utilities.arrayMax,arrayMin$4=Utilities.arrayMin,clamp$b=Utilities.clamp,defined$u=Utilities.defined,extend$15=Utilities.extend,find$c=Utilities.find,isNumber$t=Utilities.isNumber,isString$4=Utilities.isString,merge$X=Utilities.merge,pick$12=Utilities.pick,splat$9=Utilities.splat,StockChart=(function(z){__extends$1$(y,z);function y(){return z!==null&&z.apply(this,arguments)||this}return y.prototype.init=function(a,k){var j=getOptions$3(),et=a.xAxis,it=a.yAxis,nt=pick$12(a.navigator&&a.navigator.enabled,j.navigator.enabled,!0);a.xAxis=a.yAxis=void 0;var ot=merge$X({chart:{panning:{enabled:!0,type:"x"},pinchType:"x"},navigator:{enabled:nt},scrollbar:{enabled:pick$12(j.scrollbar&&j.scrollbar.enabled,!0)},rangeSelector:{enabled:pick$12(j.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:pick$12(j.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},a,{isStock:!0});a.xAxis=et,a.yAxis=it,ot.xAxis=splat$9(a.xAxis||{}).map(function(at,lt){return merge$X(getDefaultAxisOptions("xAxis",at),j.xAxis,j.xAxis&&j.xAxis[lt],at,getForcedAxisOptions("xAxis",a))}),ot.yAxis=splat$9(a.yAxis||{}).map(function(at,lt){return merge$X(getDefaultAxisOptions("yAxis",at),j.yAxis,j.yAxis&&j.yAxis[lt],at)}),z.prototype.init.call(this,ot,k)},y.prototype.createAxis=function(a,k){return k.axis=merge$X(getDefaultAxisOptions(a,k.axis),k.axis,getForcedAxisOptions(a,this.userOptions)),z.prototype.createAxis.call(this,a,k)},y})(Chart$1);(function(z){function y(a,k,j){return new z(a,k,j)}z.stockChart=y})(StockChart||(StockChart={}));function getDefaultAxisOptions(z,y){return z==="xAxis"?{minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0}:z==="yAxis"?{labels:{y:-2},opposite:pick$12(y.opposite,!0),showLastLabel:!!(y.categories||y.type==="category"),title:{text:null}}:{}}function getForcedAxisOptions(z,y){if(z==="xAxis"){var a=getOptions$3(),k=pick$12(y.navigator&&y.navigator.enabled,a.navigator.enabled,!0),j={type:"datetime",categories:void 0};return k&&(j.startOnTick=!1,j.endOnTick=!1),j}return{}}addEvent$K(Series$f,"setOptions",function(z){var y;this.chart.options.isStock&&(this.is("column")||this.is("columnrange")?y={borderWidth:0,shadow:!1}:!this.is("scatter")&&!this.is("sma")&&(y={marker:{enabled:!1,radius:2}}),y&&(z.plotOptions[this.type]=merge$X(z.plotOptions[this.type],y)))});addEvent$K(Axis,"autoLabelAlign",function(z){var y=this.chart,a=this.options,k=y._labelPanes=y._labelPanes||{},j,et=this.options.labels;this.chart.options.isStock&&this.coll==="yAxis"&&(j=a.top+","+a.height,!k[j]&&et.enabled&&(et.x===15&&(et.x=0),typeof et.align>"u"&&(et.align="right"),k[j]=this,z.align="right",z.preventDefault()))});addEvent$K(Axis,"destroy",function(){var z=this.chart,y=this.options&&this.options.top+","+this.options.height;y&&z._labelPanes&&z._labelPanes[y]===this&&delete z._labelPanes[y]});addEvent$K(Axis,"getPlotLinePath",function(z){var y=this,a=this.isLinked&&!this.series?this.linkedParent.series:this.series,k=y.chart,j=k.renderer,et=y.left,it=y.top,nt,ot,at,lt,ct=[],ht=[],ut,ft,vt=z.translatedValue,gt=z.value,mt=z.force,bt;function xt(wt){var Mt=wt==="xAxis"?"yAxis":"xAxis",Et=y.options[Mt];return isNumber$t(Et)?[k[Mt][Et]]:isString$4(Et)?[k.get(Et)]:a.map(function(St){return St[Mt]})}(k.options.isStock&&z.acrossPanes!==!1&&y.coll==="xAxis"||y.coll==="yAxis")&&(z.preventDefault(),ht=xt(y.coll),ut=y.isXAxis?k.yAxis:k.xAxis,ut.forEach(function(wt){if(!defined$u(wt.options.id)||wt.options.id.indexOf("navigator")===-1){var Mt=wt.isXAxis?"yAxis":"xAxis",Et=defined$u(wt.options[Mt])?k[Mt][wt.options[Mt]]:k[Mt][0];y===Et&&ht.push(wt)}}),ft=ht.length?[]:[y.isXAxis?k.yAxis[0]:k.xAxis[0]],ht.forEach(function(wt){ft.indexOf(wt)===-1&&!find$c(ft,function(Mt){return Mt.pos===wt.pos&&Mt.len===wt.len})&&ft.push(wt)}),bt=pick$12(vt,y.translate(gt,null,null,z.old)),isNumber$t(bt)&&(y.horiz?ft.forEach(function(wt){var Mt;ot=wt.pos,lt=ot+wt.len,nt=at=Math.round(bt+y.transB),mt!=="pass"&&(nt<et||nt>et+y.width)&&(mt?nt=at=clamp$b(nt,et,et+y.width):Mt=!0),Mt||ct.push(["M",nt,ot],["L",at,lt])}):ft.forEach(function(wt){var Mt;nt=wt.pos,at=nt+wt.len,ot=lt=Math.round(it+y.height-bt),mt!=="pass"&&(ot<it||ot>it+y.height)&&(mt?ot=lt=clamp$b(ot,it,it+y.height):Mt=!0),Mt||ct.push(["M",nt,ot],["L",at,lt])})),z.path=ct.length>0?j.crispPolyLine(ct,z.lineWidth||1):null)});SVGRenderer.prototype.crispPolyLine=function(z,y){for(var a=0;a<z.length;a=a+2){var k=z[a],j=z[a+1];k[1]===j[1]&&(k[1]=j[1]=Math.round(k[1])-y%2/2),k[2]===j[2]&&(k[2]=j[2]=Math.round(k[2])+y%2/2)}return z};addEvent$K(Axis,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});addEvent$K(Axis,"afterDrawCrosshair",function(z){if(!(!this.crosshair||!this.crosshair.label||!this.crosshair.label.enabled||!this.cross||!isNumber$t(this.min)||!isNumber$t(this.max))){var y=this.chart,a=this.logarithmic,k=this.crosshair.label,j=this.horiz,et=this.opposite,it=this.left,nt=this.top,ot=this.crossLabel,at,lt,ct,ht=k.format,ut="",ft,vt,gt=this.options.tickPosition==="inside",mt=this.crosshair.snap!==!1,bt=0,xt=z.e||this.cross&&this.cross.e,wt=z.point,Mt=this.min,Et=this.max;a&&(Mt=a.lin2log(Mt),Et=a.lin2log(Et)),vt=j?"center":et?this.labelAlign==="right"?"right":"left":this.labelAlign==="left"?"left":"center",ot||(ot=this.crossLabel=y.renderer.label("",0,void 0,k.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+(wt?wt.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:k.align||vt,padding:pick$12(k.padding,8),r:pick$12(k.borderRadius,3),zIndex:2}).add(this.labelGroup),y.styledMode||ot.attr({fill:k.backgroundColor||wt&&wt.series&&wt.series.color||palette.neutralColor60,stroke:k.borderColor||"","stroke-width":k.borderWidth||0}).css(extend$15({color:palette.backgroundColor,fontWeight:"normal",fontSize:"11px",textAlign:"center"},k.style||{}))),j?(at=mt?(wt.plotX||0)+it:xt.chartX,lt=nt+(et?0:this.height)):(at=et?this.width+it:0,lt=mt?(wt.plotY||0)+nt:xt.chartY),!ht&&!k.formatter&&(this.dateTime&&(ut="%b %d, %Y"),ht="{value"+(ut?":"+ut:"")+"}");var St=mt?this.isXAxis?wt.x:wt.y:this.toValue(j?xt.chartX:xt.chartY),kt=wt?wt.series.isPointInside(wt):isNumber$t(St)&&St>Mt&&St<Et,Pt="";ht?Pt=format$7(ht,{value:St},y):k.formatter&&isNumber$t(St)&&(Pt=k.formatter.call(this,St)),ot.attr({text:Pt,x:at,y:lt,visibility:kt?"visible":"hidden"}),ct=ot.getBBox(),isNumber$t(ot.y)&&(j?(gt&&!et||!gt&&et)&&(lt=ot.y-ct.height):lt=ot.y-ct.height/2),j?ft={left:it-ct.x,right:it+this.width-ct.x}:ft={left:this.labelAlign==="left"?it:0,right:this.labelAlign==="right"?it+this.width:y.chartWidth},ot.translateX<ft.left&&(bt=ft.left-ot.translateX),ot.translateX+ct.width>=ft.right&&(bt=-(ot.translateX+ct.width-ft.right)),ot.attr({x:at+bt,y:lt,anchorX:j?at:this.opposite?0:y.chartWidth,anchorY:j?this.opposite?y.chartHeight:0:lt+ct.height/2})}});Series$f.prototype.init=function(){seriesInit.apply(this,arguments),this.initCompare(this.options.compare)};Series$f.prototype.setCompare=function(z){this.initCompare(z),this.userOptions.compare=z};Series$f.prototype.initCompare=function(z){this.modifyValue=z==="value"||z==="percent"?function(y,a){var k=this.compareValue;return typeof y<"u"&&typeof k<"u"?(z==="value"?y-=k:y=100*(y/k)-(this.options.compareBase===100?0:100),a&&(a.change=y),y):0}:null,this.chart.hasRendered&&(this.isDirty=!0)};Series$f.prototype.forceCropping=function(){var z=this.chart,y=this.options,a=y.dataGrouping,k=this.allowDG!==!1&&a&&pick$12(a.enabled,z.options.isStock);return k};Series$f.prototype.processData=function(z){var y=this,a,k=-1,j,et,it=y.options.compareStart===!0?0:1,nt,ot;if(seriesProcessData.apply(this,arguments),y.xAxis&&y.processedYData){for(j=y.processedXData,et=y.processedYData,nt=et.length,y.pointArrayMap&&(k=y.pointArrayMap.indexOf(y.options.pointValKey||y.pointValKey||"y")),a=0;a<nt-it;a++)if(ot=et[a]&&k>-1?et[a][k]:et[a],isNumber$t(ot)&&j[a+it]>=y.xAxis.min&&ot!==0){y.compareValue=ot;break}}};addEvent$K(Series$f,"afterGetExtremes",function(z){var y=z.dataExtremes;if(this.modifyValue&&y){var a=[this.modifyValue(y.dataMin),this.modifyValue(y.dataMax)];y.dataMin=arrayMin$4(a),y.dataMax=arrayMax$4(a)}});Axis.prototype.setCompare=function(z,y){this.isXAxis||(this.series.forEach(function(a){a.setCompare(z)}),pick$12(y,!0)&&this.chart.redraw())};Point$4.prototype.tooltipFormatter=function(z){var y=this,a=y.series.chart.numberFormatter;return z=z.replace("{point.change}",(y.change>0?"+":"")+a(y.change,pick$12(y.series.tooltipOptions.changeDecimals,2))),pointTooltipFormatter.apply(this,[z])};addEvent$K(Series$f,"render",function(){var z=this.chart,y;if(!(z.is3d&&z.is3d())&&!z.polar&&this.xAxis&&!this.xAxis.isRadial&&this.options.clip!==!1){if(y=this.yAxis.len,this.xAxis.axisLine){var a=z.plotTop+z.plotHeight-this.yAxis.pos-this.yAxis.len,k=Math.floor(this.xAxis.axisLine.strokeWidth()/2);a>=0&&(y-=Math.max(k-a,0))}if((!z.hasLoaded||!this.clipBox&&this.isDirty&&!this.isDirtyData)&&(this.clipBox=this.clipBox||merge$X(z.clipBox),this.clipBox.width=this.xAxis.len,this.clipBox.height=y),z.hasRendered){var j=animObject$5(this.options.animation),et=this.getSharedClipKey(j),it=z.sharedClips[et];if(it){it.animate({width:this.xAxis.len,height:y});var nt=z.sharedClips[et+"m"];nt&&nt.animate({width:this.xAxis.len})}}}});addEvent$K(Chart$1,"update",function(z){var y=z.options;"scrollbar"in y&&this.navigator&&(merge$X(!0,this.options.scrollbar,y.scrollbar),this.navigator.update({},!1),delete y.scrollbar)});const StockChart$1=StockChart;/**
 * @license Highstock JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/stock
 * @requires highcharts
 *
 * Highcharts Stock as a plugin for Highcharts
 *
 * (c) 2010-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$6=H;G$6.Scrollbar=Scrollbar;G$6.StockChart=G$6.stockChart=StockChart$1.stockChart;Scrollbar.compose(G$6.Axis);OrdinalAxis$1.compose(G$6.Axis,G$6.Series,G$6.Chart);/**
 * @license Highstock JS v9.2.2 (2021-08-24)
 * @module highcharts/highstock
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */G$8.product="Highstock";var doc$f=H.doc,win$6=H.win,merge$W=Utilities.merge;function addClass$1(z,y){z.classList?z.classList.add(y):z.className.indexOf(y)<0&&(z.className+=y)}function escapeStringForHTML$1(z){return z.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#x27;").replace(/\//g,"&#x2F;")}function getElement$2(z){return doc$f.getElementById(z)}function getFakeMouseEvent$2(z){if(typeof win$6.MouseEvent=="function")return new win$6.MouseEvent(z);if(doc$f.createEvent){var y=doc$f.createEvent("MouseEvent");if(y.initMouseEvent)return y.initMouseEvent(z,!0,!0,win$6,z==="click"?1:0,0,0,0,0,!1,!1,!1,!1,0,null),y}return{type:z}}function getHeadingTagNameForElement$1(z){var y=function(et){var it=parseInt(et.slice(1),10),nt=Math.min(6,it+1);return"h"+nt},a=function(et){return/H[1-6]/.test(et)},k=function(et){for(var it=et;it=it.previousSibling;){var nt=it.tagName||"";if(a(nt))return nt}return""},j=function(et){var it=k(et);if(it)return y(it);var nt=et.parentElement;if(!nt)return"p";var ot=nt.tagName;return a(ot)?y(ot):j(nt)};return j(z)}function removeElement$5(z){z&&z.parentNode&&z.parentNode.removeChild(z)}function reverseChildNodes$1(z){for(var y=z.childNodes.length;y--;)z.appendChild(z.childNodes[y])}function setElAttrs$4(z,y){Object.keys(y).forEach(function(a){var k=y[a];k===null?z.removeAttribute(a):z.setAttribute(a,k)})}function stripHTMLTagsFromString$2(z){return typeof z=="string"?z.replace(/<\/?[^>]+(>|$)/g,""):z}function visuallyHideElement$2(z){var y={position:"absolute",width:"1px",height:"1px",overflow:"hidden",whiteSpace:"nowrap",clip:"rect(1px, 1px, 1px, 1px)",marginTop:"-3px","-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity=1)",filter:"alpha(opacity=1)",opacity:"0.01"};merge$W(!0,z.style,y)}var HTMLUtilities={addClass:addClass$1,escapeStringForHTML:escapeStringForHTML$1,getElement:getElement$2,getFakeMouseEvent:getFakeMouseEvent$2,getHeadingTagNameForElement:getHeadingTagNameForElement$1,removeElement:removeElement$5,reverseChildNodes:reverseChildNodes$1,setElAttrs:setElAttrs$4,stripHTMLTagsFromString:stripHTMLTagsFromString$2,visuallyHideElement:visuallyHideElement$2},stripHTMLTags$3=HTMLUtilities.stripHTMLTagsFromString,doc$e=H.doc,defined$t=Utilities.defined,find$b=Utilities.find,fireEvent$j=Utilities.fireEvent;function getChartTitle$5(z){return stripHTMLTags$3(z.options.title.text||z.langFormat("accessibility.defaultChartTitle",{chart:z}))}function getAxisDescription$2(z){return z&&(z.userOptions&&z.userOptions.accessibility&&z.userOptions.accessibility.description||z.axisTitle&&z.axisTitle.textStr||z.options.id||z.categories&&"categories"||z.dateTime&&"Time"||"values")}function getAxisRangeDescription$2(z){var y=z.options||{};return y.accessibility&&typeof y.accessibility.rangeDescription<"u"?y.accessibility.rangeDescription:z.categories?getCategoryAxisRangeDesc(z):z.dateTime&&(z.min===0||z.dataMin===0)?getAxisTimeLengthDesc(z):getAxisFromToDescription(z)}function getCategoryAxisRangeDesc(z){var y=z.chart;return z.dataMax&&z.dataMin?y.langFormat("accessibility.axis.rangeCategories",{chart:y,axis:z,numCategories:z.dataMax-z.dataMin+1}):""}function getAxisTimeLengthDesc(z){var y=z.chart,a={},k="Seconds";a.Seconds=((z.max||0)-(z.min||0))/1e3,a.Minutes=a.Seconds/60,a.Hours=a.Minutes/60,a.Days=a.Hours/24,["Minutes","Hours","Days"].forEach(function(et){a[et]>2&&(k=et)});var j=a[k].toFixed(k!=="Seconds"&&k!=="Minutes"?1:0);return y.langFormat("accessibility.axis.timeRange"+k,{chart:y,axis:z,range:j.replace(".0","")})}function getAxisFromToDescription(z){var y=z.chart,a=y.options&&y.options.accessibility&&y.options.accessibility.screenReaderSection.axisRangeDateFormat||"",k=function(j){return z.dateTime?y.time.dateFormat(a,z[j]):z[j]};return y.langFormat("accessibility.axis.rangeFromTo",{chart:y,axis:z,rangeFrom:k("min"),rangeTo:k("max")})}function getSeriesFirstPointElement$1(z){if(z.points&&z.points.length){var y=find$b(z.points,function(a){return!!a.graphic});return y&&y.graphic&&y.graphic.element}}function getSeriesA11yElement$1(z){var y=getSeriesFirstPointElement$1(z);return y&&y.parentNode||z.graph&&z.graph.element||z.group&&z.group.element}function unhideChartElementFromAT$7(z,y){y.setAttribute("aria-hidden",!1),!(y===z.renderTo||!y.parentNode||y.parentNode===doc$e.body)&&(Array.prototype.forEach.call(y.parentNode.childNodes,function(a){a.hasAttribute("aria-hidden")||a.setAttribute("aria-hidden",!0)}),unhideChartElementFromAT$7(z,y.parentNode))}function hideSeriesFromAT$1(z){var y=getSeriesA11yElement$1(z);y&&y.setAttribute("aria-hidden",!0)}function getSeriesFromName$1(z,y){return y?(z.series||[]).filter(function(a){return a.name===y}):z.series}function getPointFromXY$1(z,y,a){for(var k=z.length,j;k--;)if(j=find$b(z[k].points||[],function(et){return et.x===y&&et.y===a}),j)return j}function getRelativePointAxisPosition(z,y){if(!defined$t(z.dataMin)||!defined$t(z.dataMax))return 0;var a=z.toPixels(z.dataMin),k=z.toPixels(z.dataMax),j=z.coll==="xAxis"?"x":"y",et=z.toPixels(y[j]||0);return(et-a)/(k-a)}function scrollToPoint$1(z){var y=z.series.xAxis,a=z.series.yAxis,k=y&&y.scrollbar?y:a,j=k&&k.scrollbar;if(j&&defined$t(j.to)&&defined$t(j.from)){var et=j.to-j.from,it=getRelativePointAxisPosition(k,z);j.updatePosition(it-et/2,it+et/2),fireEvent$j(j,"changed",{from:j.from,to:j.to,trigger:"scrollbar",DOMEvent:null})}}var ChartUtilities={getChartTitle:getChartTitle$5,getAxisDescription:getAxisDescription$2,getAxisRangeDescription:getAxisRangeDescription$2,getPointFromXY:getPointFromXY$1,getSeriesFirstPointElement:getSeriesFirstPointElement$1,getSeriesFromName:getSeriesFromName$1,getSeriesA11yElement:getSeriesA11yElement$1,unhideChartElementFromAT:unhideChartElementFromAT$7,hideSeriesFromAT:hideSeriesFromAT$1,scrollToPoint:scrollToPoint$1},find$a=Utilities.find;function KeyboardNavigationHandler(z,y){this.chart=z,this.keyCodeMap=y.keyCodeMap||[],this.validate=y.validate,this.init=y.init,this.terminate=y.terminate,this.response={success:1,prev:2,next:3,noHandler:4,fail:5}}KeyboardNavigationHandler.prototype={run:function(z){var y=z.which||z.keyCode,a=this.response.noHandler,k=find$a(this.keyCodeMap,function(j){return j[0].indexOf(y)>-1});return k?a=k[1].call(this,y,z):y===9&&(a=this.response[z.shiftKey?"prev":"next"]),a}};var doc$d=H.doc,removeElement$4=HTMLUtilities.removeElement,extend$14=Utilities.extend,DOMElementProvider=function(){this.elements=[]};extend$14(DOMElementProvider.prototype,{createElement:function(){var z=doc$d.createElement.apply(doc$d,arguments);return this.elements.push(z),z},destroyCreatedElements:function(){this.elements.forEach(function(z){removeElement$4(z)}),this.elements=[]}});var addEvent$J=Utilities.addEvent,extend$13=Utilities.extend,EventProvider=function(){this.eventRemovers=[]};extend$13(EventProvider.prototype,{addEvent:function(){var z=addEvent$J.apply(H,arguments);return this.eventRemovers.push(z),z},removeAddedEvents:function(){this.eventRemovers.forEach(function(z){z()}),this.eventRemovers=[]}});var unhideChartElementFromAT$6=ChartUtilities.unhideChartElementFromAT,doc$c=H.doc,win$5=H.win,removeElement$3=HTMLUtilities.removeElement,getFakeMouseEvent$1=HTMLUtilities.getFakeMouseEvent,extend$12=Utilities.extend,fireEvent$i=Utilities.fireEvent,merge$V=Utilities.merge,functionsToOverrideByDerivedClasses={init:function(){},getKeyboardNavigation:function(){},onChartUpdate:function(){},onChartRender:function(){},destroy:function(){}};function AccessibilityComponent(){}AccessibilityComponent.prototype={initBase:function(z){this.chart=z,this.eventProvider=new EventProvider,this.domElementProvider=new DOMElementProvider,this.keyCodes={left:37,right:39,up:38,down:40,enter:13,space:32,esc:27,tab:9}},addEvent:function(){return this.eventProvider.addEvent.apply(this.eventProvider,arguments)},createElement:function(){return this.domElementProvider.createElement.apply(this.domElementProvider,arguments)},fireEventOnWrappedOrUnwrappedElement:function(z,y){var a=y.type;doc$c.createEvent&&(z.dispatchEvent||z.fireEvent)?z.dispatchEvent?z.dispatchEvent(y):z.fireEvent(a,y):fireEvent$i(z,a,y)},fakeClickEvent:function(z){if(z){var y=getFakeMouseEvent$1("click");this.fireEventOnWrappedOrUnwrappedElement(z,y)}},addProxyGroup:function(z){this.createOrUpdateProxyContainer();var y=this.createElement("div");return Object.keys(z||{}).forEach(function(a){z[a]!==null&&y.setAttribute(a,z[a])}),this.chart.a11yProxyContainer.appendChild(y),y},createOrUpdateProxyContainer:function(){var z=this.chart,y=z.renderer.box;z.a11yProxyContainer=z.a11yProxyContainer||this.createProxyContainerElement(),y.nextSibling!==z.a11yProxyContainer&&z.container.insertBefore(z.a11yProxyContainer,y.nextSibling)},createProxyContainerElement:function(){var z=doc$c.createElement("div");return z.className="highcharts-a11y-proxy-container",z},createProxyButton:function(z,y,a,k,j){var et=z.element,it=this.createElement("button"),nt=merge$V({"aria-label":et.getAttribute("aria-label")},a);return Object.keys(nt).forEach(function(ot){nt[ot]!==null&&it.setAttribute(ot,nt[ot])}),it.className="highcharts-a11y-proxy-button",z.hasClass("highcharts-no-tooltip")&&(it.className+=" highcharts-no-tooltip"),j&&this.addEvent(it,"click",j),this.setProxyButtonStyle(it),this.updateProxyButtonPosition(it,k||z),this.proxyMouseEventsForButton(et,it),y.appendChild(it),nt["aria-hidden"]||unhideChartElementFromAT$6(this.chart,it),it},getElementPosition:function(z){var y=z.element,a=this.chart.renderTo;if(a&&y&&y.getBoundingClientRect){var k=y.getBoundingClientRect(),j=a.getBoundingClientRect();return{x:k.left-j.left,y:k.top-j.top,width:k.right-k.left,height:k.bottom-k.top}}return{x:0,y:0,width:1,height:1}},setProxyButtonStyle:function(z){merge$V(!0,z.style,{borderWidth:"0",backgroundColor:"transparent",cursor:"pointer",outline:"none",opacity:"0.001",filter:"alpha(opacity=1)",zIndex:"999",overflow:"hidden",padding:"0",margin:"0",display:"block",position:"absolute"}),z.style["-ms-filter"]="progid:DXImageTransform.Microsoft.Alpha(Opacity=1)"},updateProxyButtonPosition:function(z,y){var a=this.getElementPosition(y);merge$V(!0,z.style,{width:(a.width||1)+"px",height:(a.height||1)+"px",left:(Math.round(a.x)||0)+"px",top:(Math.round(a.y)||0)+"px"})},proxyMouseEventsForButton:function(z,y){var a=this;["click","touchstart","touchend","touchcancel","touchmove","mouseover","mouseenter","mouseleave","mouseout"].forEach(function(k){var j=k.indexOf("touch")===0;a.addEvent(y,k,function(et){var it=j?a.cloneTouchEvent(et):a.cloneMouseEvent(et);z&&a.fireEventOnWrappedOrUnwrappedElement(z,it),et.stopPropagation(),k!=="touchstart"&&k!=="touchmove"&&k!=="touchend"&&et.preventDefault()},{passive:!1})})},cloneMouseEvent:function(z){if(typeof win$5.MouseEvent=="function")return new win$5.MouseEvent(z.type,z);if(doc$c.createEvent){var y=doc$c.createEvent("MouseEvent");if(y.initMouseEvent)return y.initMouseEvent(z.type,z.bubbles,z.cancelable,z.view||win$5,z.detail,z.screenX,z.screenY,z.clientX,z.clientY,z.ctrlKey,z.altKey,z.shiftKey,z.metaKey,z.button,z.relatedTarget),y}return getFakeMouseEvent$1(z.type)},cloneTouchEvent:function(z){var y=function(j){for(var et=[],it=0;it<j.length;++it){var nt=j.item(it);nt&&et.push(nt)}return et};if(typeof win$5.TouchEvent=="function"){var a=new win$5.TouchEvent(z.type,{touches:y(z.touches),targetTouches:y(z.targetTouches),changedTouches:y(z.changedTouches),ctrlKey:z.ctrlKey,shiftKey:z.shiftKey,altKey:z.altKey,metaKey:z.metaKey,bubbles:z.bubbles,cancelable:z.cancelable,composed:z.composed,detail:z.detail,view:z.view});return z.defaultPrevented&&a.preventDefault(),a}var k=this.cloneMouseEvent(z);return k.touches=z.touches,k.changedTouches=z.changedTouches,k.targetTouches=z.targetTouches,k},destroyBase:function(){removeElement$3(this.chart.a11yProxyContainer),this.domElementProvider.destroyCreatedElements(),this.eventProvider.removeAddedEvents()}};extend$12(AccessibilityComponent.prototype,functionsToOverrideByDerivedClasses);var doc$b=H.doc,win$4=H.win,addEvent$I=Utilities.addEvent,fireEvent$h=Utilities.fireEvent,getElement$1=HTMLUtilities.getElement;addEvent$I(doc$b,"keydown",function(z){var y=z.which||z.keyCode,a=27;y===a&&H.charts&&H.charts.forEach(function(k){k&&k.dismissPopupContent&&k.dismissPopupContent()})});Chart$1.prototype.dismissPopupContent=function(){var z=this;fireEvent$h(this,"dismissPopupContent",{},function(){z.tooltip&&z.tooltip.hide(0),z.hideExportMenu()})};function KeyboardNavigation(z,y){this.init(z,y)}KeyboardNavigation.prototype={init:function(z,y){var a=this,k=this.eventProvider=new EventProvider;this.chart=z,this.components=y,this.modules=[],this.currentModuleIx=0,this.update(),k.addEvent(this.tabindexContainer,"keydown",function(j){return a.onKeydown(j)}),k.addEvent(this.tabindexContainer,"focus",function(j){return a.onFocus(j)}),["mouseup","touchend"].forEach(function(j){return k.addEvent(doc$b,j,function(){return a.onMouseUp()})}),["mousedown","touchstart"].forEach(function(j){return k.addEvent(z.renderTo,j,function(){a.isClickingChart=!0})}),k.addEvent(z.renderTo,"mouseover",function(){a.pointerIsOverChart=!0}),k.addEvent(z.renderTo,"mouseout",function(){a.pointerIsOverChart=!1}),this.modules.length&&this.modules[0].init(1)},update:function(z){var y=this.chart.options.accessibility,a=y&&y.keyboardNavigation,k=this.components;this.updateContainerTabindex(),a&&a.enabled&&z&&z.length?(this.modules=z.reduce(function(j,et){var it=k[et].getKeyboardNavigation();return j.concat(it)},[]),this.updateExitAnchor()):(this.modules=[],this.currentModuleIx=0,this.removeExitAnchor())},onFocus:function(z){var y=this.chart,a=z.relatedTarget&&y.container.contains(z.relatedTarget);!this.exiting&&!this.tabbingInBackwards&&!this.isClickingChart&&!a&&this.modules[0]&&this.modules[0].init(1),this.exiting=!1},onMouseUp:function(){if(delete this.isClickingChart,!this.keyboardReset&&!this.pointerIsOverChart){var z=this.chart,y=this.modules&&this.modules[this.currentModuleIx||0];y&&y.terminate&&y.terminate(),z.focusElement&&z.focusElement.removeFocusBorder(),this.currentModuleIx=0,this.keyboardReset=!0}},onKeydown:function(z){var y=z||win$4.event,a,k=this.modules&&this.modules.length&&this.modules[this.currentModuleIx];if(this.keyboardReset=!1,this.exiting=!1,k){var j=k.run(y);j===k.response.success?a=!0:j===k.response.prev?a=this.prev():j===k.response.next&&(a=this.next()),a&&(y.preventDefault(),y.stopPropagation())}},prev:function(){return this.move(-1)},next:function(){return this.move(1)},move:function(z){var y=this.modules&&this.modules[this.currentModuleIx];y&&y.terminate&&y.terminate(z),this.chart.focusElement&&this.chart.focusElement.removeFocusBorder(),this.currentModuleIx+=z;var a=this.modules&&this.modules[this.currentModuleIx];if(a){if(a.validate&&!a.validate())return this.move(z);if(a.init)return a.init(z),!0}return this.currentModuleIx=0,this.exiting=!0,z>0?this.exitAnchor.focus():this.tabindexContainer.focus(),!1},updateExitAnchor:function(){var z="highcharts-end-of-chart-marker-"+this.chart.index,y=getElement$1(z);this.removeExitAnchor(),y?(this.makeElementAnExitAnchor(y),this.exitAnchor=y):this.createExitAnchor()},updateContainerTabindex:function(){var z=this.chart.options.accessibility,y=z&&z.keyboardNavigation,a=!(y&&y.enabled===!1),k=this.chart,j=k.container,et;k.renderTo.hasAttribute("tabindex")?(j.removeAttribute("tabindex"),et=k.renderTo):et=j,this.tabindexContainer=et;var it=et.getAttribute("tabindex");a&&!it?et.setAttribute("tabindex","0"):a||k.container.removeAttribute("tabindex")},makeElementAnExitAnchor:function(z){var y=this.tabindexContainer.getAttribute("tabindex")||0;z.setAttribute("class","highcharts-exit-anchor"),z.setAttribute("tabindex",y),z.setAttribute("aria-hidden",!1),this.addExitAnchorEventsToEl(z)},createExitAnchor:function(){var z=this.chart,y=this.exitAnchor=doc$b.createElement("div");z.renderTo.appendChild(y),this.makeElementAnExitAnchor(y)},removeExitAnchor:function(){this.exitAnchor&&this.exitAnchor.parentNode&&(this.exitAnchor.parentNode.removeChild(this.exitAnchor),delete this.exitAnchor)},addExitAnchorEventsToEl:function(z){var y=this.chart,a=this;this.eventProvider.addEvent(z,"focus",function(k){var j=k||win$4.event,et,it=j.relatedTarget&&y.container.contains(j.relatedTarget),nt=!(it||a.exiting);nt?(a.tabbingInBackwards=!0,a.tabindexContainer.focus(),delete a.tabbingInBackwards,j.preventDefault(),a.modules&&a.modules.length&&(a.currentModuleIx=a.modules.length-1,et=a.modules[a.currentModuleIx],et&&et.validate&&!et.validate()?a.prev():et&&et.init(-1))):a.exiting=!1})},destroy:function(){this.removeExitAnchor(),this.eventProvider.removeAddedEvents(),this.chart.container.removeAttribute("tabindex")}};var animObject$4=animationExports.animObject,addEvent$H=Utilities.addEvent,extend$11=Utilities.extend,find$9=Utilities.find,fireEvent$g=Utilities.fireEvent,isNumber$s=Utilities.isNumber,pick$11=Utilities.pick,syncTimeout$1=Utilities.syncTimeout,removeElement$2=HTMLUtilities.removeElement,stripHTMLTags$2=HTMLUtilities.stripHTMLTagsFromString,getChartTitle$4=ChartUtilities.getChartTitle;function scrollLegendToItem(z,y){var a=z.allItems[y].pageIx,k=z.currentPage;typeof a<"u"&&a+1!==k&&z.scroll(1+a-k)}function shouldDoLegendA11y(z){var y=z.legend&&z.legend.allItems,a=z.options.legend.accessibility||{};return!!(y&&y.length&&!(z.colorAxis&&z.colorAxis.length)&&a.enabled!==!1)}Chart$1.prototype.highlightLegendItem=function(z){var y=this.legend.allItems,a=this.accessibility&&this.accessibility.components.legend.highlightedLegendItemIx;return y[z]?(isNumber$s(a)&&y[a]&&fireEvent$g(y[a].legendGroup.element,"mouseout"),scrollLegendToItem(this.legend,z),this.setFocusToElement(y[z].legendItem,y[z].a11yProxyElement),fireEvent$g(y[z].legendGroup.element,"mouseover"),!0):!1};addEvent$H(Legend,"afterColorizeItem",function(z){var y=this.chart,a=y.options.accessibility,k=z.item;a.enabled&&k&&k.a11yProxyElement&&k.a11yProxyElement.setAttribute("aria-pressed",z.visible?"true":"false")});var LegendComponent=function(){};LegendComponent.prototype=new AccessibilityComponent;extend$11(LegendComponent.prototype,{init:function(){var z=this;this.proxyElementsList=[],this.recreateProxies(),this.addEvent(Legend,"afterScroll",function(){this.chart===z.chart&&(z.updateProxiesPositions(),z.updateLegendItemProxyVisibility(),this.chart.highlightLegendItem(z.highlightedLegendItemIx))}),this.addEvent(Legend,"afterPositionItem",function(y){this.chart===z.chart&&this.chart.renderer&&z.updateProxyPositionForItem(y.item)}),this.addEvent(Legend,"afterRender",function(){this.chart===z.chart&&this.chart.renderer&&z.recreateProxies()&&syncTimeout$1(function(){return z.updateProxiesPositions()},animObject$4(pick$11(this.chart.renderer.globalAnimation,!0)).duration)})},updateLegendItemProxyVisibility:function(){var z=this.chart.legend,y=z.allItems||[],a=z.currentPage||1,k=z.clipHeight||0;y.forEach(function(j){var et=j.pageIx||0,it=j._legendItemPos?j._legendItemPos[1]:0,nt=j.legendItem?Math.round(j.legendItem.getBBox().height):0,ot=it+nt-z.pages[et]>k||et!==a-1;j.a11yProxyElement&&(j.a11yProxyElement.style.visibility=ot?"hidden":"visible")})},onChartRender:function(){shouldDoLegendA11y(this.chart)||this.removeProxies()},onChartUpdate:function(){this.updateLegendTitle()},updateProxiesPositions:function(){for(var z=0,y=this.proxyElementsList;z<y.length;z++){var a=y[z],k=a.element,j=a.posElement;this.updateProxyButtonPosition(k,j)}},updateProxyPositionForItem:function(z){var y=find$9(this.proxyElementsList,function(a){return a.item===z});y&&this.updateProxyButtonPosition(y.element,y.posElement)},recreateProxies:function(){return this.removeProxies(),shouldDoLegendA11y(this.chart)?(this.addLegendProxyGroup(),this.addLegendListContainer(),this.proxyLegendItems(),this.updateLegendItemProxyVisibility(),!0):!1},removeProxies:function(){removeElement$2(this.legendProxyGroup),this.proxyElementsList=[]},updateLegendTitle:function(){var z=this.chart,y=stripHTMLTags$2((z.legend&&z.legend.options.title&&z.legend.options.title.text||"").replace(/<br ?\/?>/g," ")),a=z.langFormat("accessibility.legend.legendLabel"+(y?"":"NoTitle"),{chart:z,legendTitle:y,chartTitle:getChartTitle$4(z)});this.legendProxyGroup&&this.legendProxyGroup.setAttribute("aria-label",a)},addLegendProxyGroup:function(){var z=this.chart.options.accessibility,y=z.landmarkVerbosity==="all"?"region":null;this.legendProxyGroup=this.addProxyGroup({"aria-label":"_placeholder_",role:y})},addLegendListContainer:function(){if(this.legendProxyGroup){var z=this.legendListContainer=this.createElement("ul");z.style.listStyle="none",this.legendProxyGroup.appendChild(z)}},proxyLegendItems:function(){var z=this,y=this.chart.legend&&this.chart.legend.allItems||[];y.forEach(function(a){a.legendItem&&a.legendItem.element&&z.proxyLegendItem(a)})},proxyLegendItem:function(z){if(!(!z.legendItem||!z.legendGroup||!this.legendListContainer)){var y=this.chart.langFormat("accessibility.legend.legendItem",{chart:this.chart,itemName:stripHTMLTags$2(z.name),item:z}),a={tabindex:-1,"aria-pressed":z.visible,"aria-label":y},k=z.legendGroup.div?z.legendItem:z.legendGroup,j=this.createElement("li");this.legendListContainer.appendChild(j),z.a11yProxyElement=this.createProxyButton(z.legendItem,j,a,k),this.proxyElementsList.push({item:z,element:z.a11yProxyElement,posElement:k})}},getKeyboardNavigation:function(){var z=this.keyCodes,y=this,a=this.chart;return new KeyboardNavigationHandler(a,{keyCodeMap:[[[z.left,z.right,z.up,z.down],function(k){return y.onKbdArrowKey(this,k)}],[[z.enter,z.space],function(k){return H.isFirefox&&k===z.space?this.response.success:y.onKbdClick(this)}]],validate:function(){return y.shouldHaveLegendNavigation()},init:function(k){return y.onKbdNavigationInit(k)},terminate:function(){a.legend.allItems.forEach(function(k){return k.setState("",!0)})}})},onKbdArrowKey:function(z,y){var a=this.keyCodes,k=z.response,j=this.chart,et=j.options.accessibility,it=j.legend.allItems.length,nt=y===a.left||y===a.up?-1:1,ot=j.highlightLegendItem(this.highlightedLegendItemIx+nt);return ot?(this.highlightedLegendItemIx+=nt,k.success):it>1&&et.keyboardNavigation.wrapAround?(z.init(nt),k.success):k[nt>0?"next":"prev"]},onKbdClick:function(z){var y=this.chart.legend.allItems[this.highlightedLegendItemIx];return y&&y.a11yProxyElement&&fireEvent$g(y.a11yProxyElement,"click"),z.response.success},shouldHaveLegendNavigation:function(){var z=this.chart,y=z.options.legend||{},a=z.legend&&z.legend.allItems,k=z.colorAxis&&z.colorAxis.length,j=y.accessibility||{};return!!(a&&z.legend.display&&!k&&j.enabled&&j.keyboardNavigation&&j.keyboardNavigation.enabled)},onKbdNavigationInit:function(z){var y=this.chart,a=y.legend.allItems.length-1,k=z>0?0:a;y.highlightLegendItem(k),this.highlightedLegendItemIx=k}});var extend$10=Utilities.extend,getChartTitle$3=ChartUtilities.getChartTitle,unhideChartElementFromAT$5=ChartUtilities.unhideChartElementFromAT,removeElement$1=HTMLUtilities.removeElement,getFakeMouseEvent=HTMLUtilities.getFakeMouseEvent;function getExportMenuButtonElement(z){return z.exportSVGElements&&z.exportSVGElements[0]}Chart$1.prototype.showExportMenu=function(){var z=getExportMenuButtonElement(this);if(z){var y=z.element;y.onclick&&y.onclick(getFakeMouseEvent("click"))}};Chart$1.prototype.hideExportMenu=function(){var z=this,y=z.exportDivElements;y&&z.exportContextMenu&&(y.forEach(function(a){a&&a.className==="highcharts-menu-item"&&a.onmouseout&&a.onmouseout(getFakeMouseEvent("mouseout"))}),z.highlightedExportItemIx=0,z.exportContextMenu.hideMenu(),z.container.focus())};Chart$1.prototype.highlightExportItem=function(z){var y=this.exportDivElements&&this.exportDivElements[z],a=this.exportDivElements&&this.exportDivElements[this.highlightedExportItemIx],k;return y&&y.tagName==="LI"&&!(y.children&&y.children.length)?(k=!!(this.renderTo.getElementsByTagName("g")[0]||{}).focus,y.focus&&k&&y.focus(),a&&a.onmouseout&&a.onmouseout(getFakeMouseEvent("mouseout")),y.onmouseover&&y.onmouseover(getFakeMouseEvent("mouseover")),this.highlightedExportItemIx=z,!0):!1};Chart$1.prototype.highlightLastExportItem=function(){var z=this,y;if(z.exportDivElements){for(y=z.exportDivElements.length;y--;)if(z.highlightExportItem(y))return!0}return!1};function exportingShouldHaveA11y(z){var y=z.options.exporting,a=getExportMenuButtonElement(z);return!!(y&&y.enabled!==!1&&y.accessibility&&y.accessibility.enabled&&a&&a.element)}var MenuComponent=function(){};MenuComponent.prototype=new AccessibilityComponent;extend$10(MenuComponent.prototype,{init:function(){var z=this.chart,y=this;this.addEvent(z,"exportMenuShown",function(){y.onMenuShown()}),this.addEvent(z,"exportMenuHidden",function(){y.onMenuHidden()})},onMenuHidden:function(){var z=this.chart.exportContextMenu;z&&z.setAttribute("aria-hidden","true"),this.isExportMenuShown=!1,this.setExportButtonExpandedState("false")},onMenuShown:function(){var z=this.chart,y=z.exportContextMenu;y&&(this.addAccessibleContextMenuAttribs(),unhideChartElementFromAT$5(z,y)),this.isExportMenuShown=!0,this.setExportButtonExpandedState("true")},setExportButtonExpandedState:function(z){var y=this.exportButtonProxy;y&&y.setAttribute("aria-expanded",z)},onChartRender:function(){var z=this.chart,y=z.options.accessibility;if(removeElement$1(this.exportProxyGroup),exportingShouldHaveA11y(z)){this.exportProxyGroup=this.addProxyGroup(y.landmarkVerbosity==="all"?{"aria-label":z.langFormat("accessibility.exporting.exportRegionLabel",{chart:z,chartTitle:getChartTitle$3(z)}),role:"region"}:{});var a=getExportMenuButtonElement(this.chart);this.exportButtonProxy=this.createProxyButton(a,this.exportProxyGroup,{"aria-label":z.langFormat("accessibility.exporting.menuButtonLabel",{chart:z}),"aria-expanded":!1})}},addAccessibleContextMenuAttribs:function(){var z=this.chart,y=z.exportDivElements;if(y&&y.length){y.forEach(function(k){k&&(k.tagName==="LI"&&!(k.children&&k.children.length)?k.setAttribute("tabindex",-1):k.setAttribute("aria-hidden","true"))});var a=y[0]&&y[0].parentNode;a&&(a.removeAttribute("aria-hidden"),a.setAttribute("aria-label",z.langFormat("accessibility.exporting.chartMenuLabel",{chart:z})))}},getKeyboardNavigation:function(){var z=this.keyCodes,y=this.chart,a=this;return new KeyboardNavigationHandler(y,{keyCodeMap:[[[z.left,z.up],function(){return a.onKbdPrevious(this)}],[[z.right,z.down],function(){return a.onKbdNext(this)}],[[z.enter,z.space],function(){return a.onKbdClick(this)}]],validate:function(){return!!y.exporting&&y.options.exporting.enabled!==!1&&y.options.exporting.accessibility.enabled!==!1},init:function(){var k=a.exportButtonProxy,j=y.exportingGroup;j&&k&&y.setFocusToElement(j,k)},terminate:function(){y.hideExportMenu()}})},onKbdPrevious:function(z){for(var y=this.chart,a=y.options.accessibility,k=z.response,j=y.highlightedExportItemIx||0;j--;)if(y.highlightExportItem(j))return k.success;return a.keyboardNavigation.wrapAround?(y.highlightLastExportItem(),k.success):k.prev},onKbdNext:function(z){for(var y=this.chart,a=y.options.accessibility,k=z.response,j=(y.highlightedExportItemIx||0)+1;j<y.exportDivElements.length;++j)if(y.highlightExportItem(j))return k.success;return a.keyboardNavigation.wrapAround?(y.highlightExportItem(0),k.success):k.next},onKbdClick:function(z){var y=this.chart,a=y.exportDivElements[y.highlightedExportItemIx],k=getExportMenuButtonElement(y).element;return this.isExportMenuShown?this.fakeClickEvent(a):(this.fakeClickEvent(k),y.highlightExportItem(0)),z.response.success}});var seriesTypes$5=SeriesRegistry$1.seriesTypes,doc$a=H.doc,defined$s=Utilities.defined,extend$$=Utilities.extend,fireEvent$f=Utilities.fireEvent,getPointFromXY=ChartUtilities.getPointFromXY,getSeriesFromName=ChartUtilities.getSeriesFromName,scrollToPoint=ChartUtilities.scrollToPoint;Series$f.prototype.keyboardMoveVertical=!0;["column","pie"].forEach(function(z){seriesTypes$5[z]&&(seriesTypes$5[z].prototype.keyboardMoveVertical=!1)});function getPointIndex(z){var y=z.index,a=z.series.points,k=a.length;if(a[y]!==z){for(;k--;)if(a[k]===z)return k}else return y}function isSkipSeries(z){var y=z.chart.options.accessibility,a=y.keyboardNavigation.seriesNavigation,k=z.options.accessibility||{},j=k.keyboardNavigation;return j&&j.enabled===!1||k.enabled===!1||z.options.enableMouseTracking===!1||!z.visible||a.pointNavigationEnabledThreshold&&a.pointNavigationEnabledThreshold<=z.points.length}function isSkipPoint(z){var y=z.series.chart.options.accessibility,a=z.options.accessibility&&z.options.accessibility.enabled===!1;return z.isNull&&y.keyboardNavigation.seriesNavigation.skipNullPoints||z.visible===!1||z.isInside===!1||a||isSkipSeries(z.series)}function getClosestPoint(z,y,a,k){var j=1/0,et,it,nt,ot=y.points.length,at=function(lt){return!(defined$s(lt.plotX)&&defined$s(lt.plotY))};if(!at(z)){for(;ot--;)et=y.points[ot],!at(et)&&(nt=(z.plotX-et.plotX)*(z.plotX-et.plotX)*a+(z.plotY-et.plotY)*(z.plotY-et.plotY)*1,nt<j&&(j=nt,it=ot));return defined$s(it)?y.points[it]:void 0}}Point$4.prototype.highlight=function(){var z=this.series.chart;return this.isNull?z.tooltip&&z.tooltip.hide(0):this.onMouseOver(),scrollToPoint(this),this.graphic&&z.setFocusToElement(this.graphic),z.highlightedPoint=this,this};Chart$1.prototype.highlightAdjacentPoint=function(z){var y=this,a=y.series,k=y.highlightedPoint,j=k&&getPointIndex(k)||0,et=k&&k.series.points,it=y.series&&y.series[y.series.length-1],nt=it&&it.points&&it.points[it.points.length-1],ot,at;if(!a[0]||!a[0].points)return!1;if(!k)at=z?a[0].points[0]:nt;else if(ot=a[k.series.index+(z?1:-1)],at=et[j+(z?1:-1)],!at&&ot&&(at=ot.points[z?0:ot.points.length-1]),!at)return!1;return isSkipPoint(at)?(ot=at.series,isSkipSeries(ot)?y.highlightedPoint=z?ot.points[ot.points.length-1]:ot.points[0]:y.highlightedPoint=at,y.highlightAdjacentPoint(z)):at.highlight()};Series$f.prototype.highlightFirstValidPoint=function(){var z=this.chart.highlightedPoint,y=(z&&z.series)===this?getPointIndex(z):0,a=this.points,k=a.length;if(a&&k){for(var j=y;j<k;++j)if(!isSkipPoint(a[j]))return a[j].highlight();for(var et=y;et>=0;--et)if(!isSkipPoint(a[et]))return a[et].highlight()}return!1};Chart$1.prototype.highlightAdjacentSeries=function(z){var y=this,a=y.highlightedPoint,k=y.series&&y.series[y.series.length-1],j=k&&k.points&&k.points[k.points.length-1],et,it,nt;return y.highlightedPoint?(et=y.series[a.series.index+(z?-1:1)],!et||(it=getClosestPoint(a,et,4),!it)?!1:isSkipSeries(et)?(it.highlight(),nt=y.highlightAdjacentSeries(z),nt||(a.highlight(),!1)):(it.highlight(),it.series.highlightFirstValidPoint())):(et=z?y.series&&y.series[0]:k,it=z?et&&et.points&&et.points[0]:j,it?it.highlight():!1)};Chart$1.prototype.highlightAdjacentPointVertical=function(z){var y=this.highlightedPoint,a=1/0,k;return!defined$s(y.plotX)||!defined$s(y.plotY)?!1:(this.series.forEach(function(j){isSkipSeries(j)||j.points.forEach(function(et){if(!(!defined$s(et.plotY)||!defined$s(et.plotX)||et===y)){var it=et.plotY-y.plotY,nt=Math.abs(et.plotX-y.plotX),ot=Math.abs(it)*Math.abs(it)+nt*nt*4;j.yAxis&&j.yAxis.reversed&&(it*=-1),!(it<=0&&z||it>=0&&!z||ot<5||isSkipPoint(et))&&ot<a&&(a=ot,k=et)}})}),k?k.highlight():!1)};function highlightFirstValidPointInChart(z){var y=!1;return delete z.highlightedPoint,y=z.series.reduce(function(a,k){return a||k.highlightFirstValidPoint()},!1),y}function highlightLastValidPointInChart(z){for(var y=z.series.length,a=y,k=!1;a--&&(z.highlightedPoint=z.series[a].points[z.series[a].points.length-1],k=z.series[a].highlightFirstValidPoint(),!k););return k}function updateChartFocusAfterDrilling(z){highlightFirstValidPointInChart(z),z.focusElement&&z.focusElement.removeFocusBorder()}function SeriesKeyboardNavigation(z,y){this.keyCodes=y,this.chart=z}extend$$(SeriesKeyboardNavigation.prototype,{init:function(){var z=this,y=this.chart,a=this.eventProvider=new EventProvider;a.addEvent(Series$f,"destroy",function(){return z.onSeriesDestroy(this)}),a.addEvent(y,"afterDrilldown",function(){updateChartFocusAfterDrilling(this)}),a.addEvent(y,"drilldown",function(k){var j=k.point,et=j.series;z.lastDrilledDownPoint={x:j.x,y:j.y,seriesName:et?et.name:""}}),a.addEvent(y,"drillupall",function(){setTimeout(function(){z.onDrillupAll()},10)}),a.addEvent(Point$4,"afterSetState",function(){var k=this,j=k.graphic&&k.graphic.element;y.highlightedPoint===k&&doc$a.activeElement!==j&&j&&j.focus&&j.focus()})},onDrillupAll:function(){var z=this.lastDrilledDownPoint,y=this.chart,a=z&&getSeriesFromName(y,z.seriesName),k;z&&a&&defined$s(z.x)&&defined$s(z.y)&&(k=getPointFromXY(a,z.x,z.y)),y.container&&y.container.focus(),k&&k.highlight&&k.highlight(),y.focusElement&&y.focusElement.removeFocusBorder()},getKeyboardNavigationHandler:function(){var z=this,y=this.keyCodes,a=this.chart,k=a.inverted;return new KeyboardNavigationHandler(a,{keyCodeMap:[[k?[y.up,y.down]:[y.left,y.right],function(j){return z.onKbdSideways(this,j)}],[k?[y.left,y.right]:[y.up,y.down],function(j){return z.onKbdVertical(this,j)}],[[y.enter,y.space],function(j,et){var it=a.highlightedPoint;return it&&(et.point=it,fireEvent$f(it.series,"click",et),it.firePointEvent("click")),this.response.success}]],init:function(j){return z.onHandlerInit(this,j)},terminate:function(){return z.onHandlerTerminate()}})},onKbdSideways:function(z,y){var a=this.keyCodes,k=y===a.right||y===a.down;return this.attemptHighlightAdjacentPoint(z,k)},onKbdVertical:function(z,y){var a=this.chart,k=this.keyCodes,j=y===k.down||y===k.right,et=a.options.accessibility.keyboardNavigation.seriesNavigation;if(et.mode&&et.mode==="serialize")return this.attemptHighlightAdjacentPoint(z,j);var it=a.highlightedPoint&&a.highlightedPoint.series.keyboardMoveVertical?"highlightAdjacentPointVertical":"highlightAdjacentSeries";return a[it](j),z.response.success},onHandlerInit:function(z,y){var a=this.chart;return y>0?highlightFirstValidPointInChart(a):highlightLastValidPointInChart(a),z.response.success},onHandlerTerminate:function(){var z=this.chart;z.tooltip&&z.tooltip.hide(0);var y=z.highlightedPoint&&z.highlightedPoint.series;y&&y.onMouseOut&&y.onMouseOut(),z.highlightedPoint&&z.highlightedPoint.onMouseOut&&z.highlightedPoint.onMouseOut(),delete z.highlightedPoint},attemptHighlightAdjacentPoint:function(z,y){var a=this.chart,k=a.options.accessibility.keyboardNavigation.wrapAround,j=a.highlightAdjacentPoint(y);return j?z.response.success:k?z.init(y?1:-1):z.response[y?"next":"prev"]},onSeriesDestroy:function(z){var y=this.chart,a=y.highlightedPoint&&y.highlightedPoint.series===z;a&&(delete y.highlightedPoint,y.focusElement&&y.focusElement.removeFocusBorder())},destroy:function(){this.eventProvider.removeAddedEvents()}});var escapeStringForHTML=HTMLUtilities.escapeStringForHTML,stripHTMLTagsFromString$1=HTMLUtilities.stripHTMLTagsFromString;function getChartAnnotationLabels(z){var y=z.annotations||[];return y.reduce(function(a,k){return k.options&&k.options.visible!==!1&&(a=a.concat(k.labels)),a},[])}function getLabelText(z){return z.options&&z.options.accessibility&&z.options.accessibility.description||z.graphic&&z.graphic.text&&z.graphic.text.textStr||""}function getAnnotationLabelDescription(z){var y=z.options&&z.options.accessibility&&z.options.accessibility.description;if(y)return y;var a=z.chart,k=getLabelText(z),j=z.points,et=function(ht){return ht.graphic&&ht.graphic.element&&ht.graphic.element.getAttribute("aria-label")||""},it=function(ht){var ut=ht.accessibility&&ht.accessibility.valueDescription||et(ht),ft=ht&&ht.series.name||"";return(ft?ft+", ":"")+"data point "+ut},nt=j.filter(function(ht){return!!ht.graphic}).map(it).filter(function(ht){return!!ht}),ot=nt.length,at=ot>1?"MultiplePoints":ot?"SinglePoint":"NoPoints",lt="accessibility.screenReaderSection.annotations.description"+at,ct={annotationText:k,annotation:z,numPoints:ot,annotationPoint:nt[0],additionalAnnotationPoints:nt.slice(1)};return a.langFormat(lt,ct)}function getAnnotationListItems(z){var y=getChartAnnotationLabels(z);return y.map(function(a){var k=escapeStringForHTML(stripHTMLTagsFromString$1(getAnnotationLabelDescription(a)));return k?"<li>"+k+"</li>":""})}function getAnnotationsInfoHTML$1(z){var y=z.annotations;if(!(y&&y.length))return"";var a=getAnnotationListItems(z);return'<ul style="list-style-type: none">'+a.join(" ")+"</ul>"}function getPointAnnotationTexts$1(z){var y=getChartAnnotationLabels(z.series.chart),a=y.filter(function(k){return k.points.indexOf(z)>-1});return a.length?a.map(function(k){return""+getLabelText(k)}):[]}var AnnotationsA11y={getAnnotationsInfoHTML:getAnnotationsInfoHTML$1,getPointAnnotationTexts:getPointAnnotationTexts$1},getPointAnnotationTexts=AnnotationsA11y.getPointAnnotationTexts,getAxisDescription$1=ChartUtilities.getAxisDescription,getSeriesFirstPointElement=ChartUtilities.getSeriesFirstPointElement,getSeriesA11yElement=ChartUtilities.getSeriesA11yElement,unhideChartElementFromAT$4=ChartUtilities.unhideChartElementFromAT,format$6=FormatUtilities.format,numberFormat=FormatUtilities.numberFormat,reverseChildNodes=HTMLUtilities.reverseChildNodes,stripHTMLTags$1=HTMLUtilities.stripHTMLTagsFromString,find$8=Utilities.find,isNumber$r=Utilities.isNumber,pick$10=Utilities.pick,defined$r=Utilities.defined;function findFirstPointWithGraphic(z){var y=z.index;return!z.series||!z.series.data||!defined$r(y)?null:find$8(z.series.data,function(a){return!!(a&&typeof a.index<"u"&&a.index>y&&a.graphic&&a.graphic.element)})||null}function shouldAddDummyPoint(z){var y=z.series&&z.series.is("sunburst"),a=z.isNull;return a&&!y}function makeDummyElement(z,y){var a=z.series.chart.renderer,k=a.rect(y.x,y.y,1,1);return k.attr({class:"highcharts-a11y-dummy-point",fill:"none",opacity:0,"fill-opacity":0,"stroke-opacity":0}),k}function addDummyPointElement(z){var y=z.series,a=findFirstPointWithGraphic(z),k=a&&a.graphic,j=k?k.parentGroup:y.graph||y.group,et=a?{x:pick$10(z.plotX,a.plotX,0),y:pick$10(z.plotY,a.plotY,0)}:{x:pick$10(z.plotX,0),y:pick$10(z.plotY,0)},it=makeDummyElement(z,et);if(j&&j.element)return z.graphic=it,z.hasDummyGraphic=!0,it.add(j),j.element.insertBefore(it.element,k?k.element:null),it.element}function hasMorePointsThanDescriptionThreshold(z){var y=z.chart.options.accessibility,a=y.series.pointDescriptionEnabledThreshold;return!!(a!==!1&&z.points&&z.points.length>=a)}function shouldSetScreenReaderPropsOnPoints(z){var y=z.options.accessibility||{};return!hasMorePointsThanDescriptionThreshold(z)&&!y.exposeAsGroupOnly}function shouldSetKeyboardNavPropsOnPoints(z){var y=z.chart.options.accessibility,a=y.keyboardNavigation.seriesNavigation;return!!(z.points&&(z.points.length<a.pointNavigationEnabledThreshold||a.pointNavigationEnabledThreshold===!1))}function shouldDescribeSeriesElement(z){var y=z.chart,a=y.options.chart,k=a.options3d&&a.options3d.enabled,j=y.series.length>1,et=y.options.accessibility.series.describeSingleSeries,it=(z.options.accessibility||{}).exposeAsGroupOnly,nt=k&&j;return!nt&&(j||et||it||hasMorePointsThanDescriptionThreshold(z))}function pointNumberToString(z,y){var a=z.series.chart,k=a.options.accessibility.point||{},j=z.series.tooltipOptions||{},et=a.options.lang;return isNumber$r(y)?numberFormat(y,k.valueDecimals||j.valueDecimals||-1,et.decimalPoint,et.accessibility.thousandsSep||et.thousandsSep):y}function getSeriesDescriptionText(z){var y=z.options.accessibility||{},a=y.description;return a&&z.chart.langFormat("accessibility.series.description",{description:a,series:z})||""}function getSeriesAxisDescriptionText(z,y){var a=z[y];return z.chart.langFormat("accessibility.series."+y+"Description",{name:getAxisDescription$1(a),series:z})}function getPointA11yTimeDescription(z){var y=z.series,a=y.chart,k=a.options.accessibility.point||{},j=y.xAxis&&y.xAxis.dateTime;if(j){var et=j.getXDateFormat(z.x||0,a.options.tooltip.dateTimeLabelFormats),it=k.dateFormatter&&k.dateFormatter(z)||k.dateFormat||et;return a.time.dateFormat(it,z.x||0,void 0)}}function getPointXDescription(z){var y=getPointA11yTimeDescription(z),a=z.series.xAxis||{},k=a.categories&&defined$r(z.category)&&(""+z.category).replace("<br/>"," "),j=z.id&&z.id.indexOf("highcharts-")<0,et="x, "+z.x;return z.name||y||k||(j?z.id:et)}function getPointArrayMapValueDescription(z,y,a){var k=y||"",j=a||"",et=function(nt){var ot=pointNumberToString(z,pick$10(z[nt],z.options[nt]));return nt+": "+k+ot+j},it=z.series.pointArrayMap;return it.reduce(function(nt,ot){return nt+(nt.length?", ":"")+et(ot)},"")}function getPointValue(z){var y=z.series,a=y.chart.options.accessibility.point||{},k=y.tooltipOptions||{},j=a.valuePrefix||k.valuePrefix||"",et=a.valueSuffix||k.valueSuffix||"",it=typeof z.value<"u"?"value":"y",nt=pointNumberToString(z,z[it]);return z.isNull?y.chart.langFormat("accessibility.series.nullPointValue",{point:z}):y.pointArrayMap?getPointArrayMapValueDescription(z,j,et):j+nt+et}function getPointAnnotationDescription(z){var y=z.series.chart,a="accessibility.series.pointAnnotationsDescription",k=getPointAnnotationTexts(z),j={point:z,annotations:k};return k.length?y.langFormat(a,j):""}function getPointValueDescription(z){var y=z.series,a=y.chart,k=a.options.accessibility.point.valueDescriptionFormat,j=pick$10(y.xAxis&&y.xAxis.options.accessibility&&y.xAxis.options.accessibility.enabled,!a.angular),et=j?getPointXDescription(z):"",it={point:z,index:defined$r(z.index)?z.index+1:"",xDescription:et,value:getPointValue(z),separator:j?", ":""};return format$6(k,it,a)}function defaultPointDescriptionFormatter$1(z){var y=z.series,a=y.chart,k=getPointValueDescription(z),j=z.options&&z.options.accessibility&&z.options.accessibility.description,et=j?" "+j:"",it=a.series.length>1&&y.name?" "+y.name+".":"",nt=getPointAnnotationDescription(z),ot=nt?" "+nt:"";return z.accessibility=z.accessibility||{},z.accessibility.valueDescription=k,k+et+it+ot}function setPointScreenReaderAttribs(z,y){var a=z.series,k=a.chart.options.accessibility.point||{},j=a.options.accessibility||{},et=stripHTMLTags$1(j.pointDescriptionFormatter&&j.pointDescriptionFormatter(z)||k.descriptionFormatter&&k.descriptionFormatter(z)||defaultPointDescriptionFormatter$1(z));y.setAttribute("role","img"),y.setAttribute("aria-label",et)}function describePointsInSeries(z){var y=shouldSetScreenReaderPropsOnPoints(z),a=shouldSetKeyboardNavPropsOnPoints(z);(y||a)&&z.points.forEach(function(k){var j=k.graphic&&k.graphic.element||shouldAddDummyPoint(k)&&addDummyPointElement(k),et=k.options&&k.options.accessibility&&k.options.accessibility.enabled===!1;j&&(j.setAttribute("tabindex","-1"),j.style.outline="0",y&&!et?setPointScreenReaderAttribs(k,j):j.setAttribute("aria-hidden",!0))})}function defaultSeriesDescriptionFormatter$1(z){var y=z.chart,a=y.types||[],k=getSeriesDescriptionText(z),j=function(lt){return y[lt]&&y[lt].length>1&&z[lt]},et=getSeriesAxisDescriptionText(z,"xAxis"),it=getSeriesAxisDescriptionText(z,"yAxis"),nt={name:z.name||"",ix:z.index+1,numSeries:y.series&&y.series.length,numPoints:z.points&&z.points.length,series:z},ot=a.length>1?"Combination":"",at=y.langFormat("accessibility.series.summary."+z.type+ot,nt)||y.langFormat("accessibility.series.summary.default"+ot,nt);return at+(k?" "+k:"")+(j("yAxis")?" "+it:"")+(j("xAxis")?" "+et:"")}function describeSeriesElement(z,y){var a=z.options.accessibility||{},k=z.chart.options.accessibility,j=k.landmarkVerbosity;a.exposeAsGroupOnly?y.setAttribute("role","img"):j==="all"&&y.setAttribute("role","region"),y.setAttribute("tabindex","-1"),y.style.outline="0",y.setAttribute("aria-label",stripHTMLTags$1(k.series.descriptionFormatter&&k.series.descriptionFormatter(z)||defaultSeriesDescriptionFormatter$1(z)))}function describeSeries$1(z){var y=z.chart,a=getSeriesFirstPointElement(z),k=getSeriesA11yElement(z),j=y.is3d&&y.is3d();k&&(k.lastChild===a&&!j&&reverseChildNodes(k),describePointsInSeries(z),unhideChartElementFromAT$4(y,k),shouldDescribeSeriesElement(z)?describeSeriesElement(z,k):k.setAttribute("aria-label",""))}var SeriesDescriber={describeSeries:describeSeries$1,defaultPointDescriptionFormatter:defaultPointDescriptionFormatter$1,defaultSeriesDescriptionFormatter:defaultSeriesDescriptionFormatter$1,getPointA11yTimeDescription,getPointXDescription,getPointValue,getPointValueDescription},doc$9=H.doc,setElAttrs$3=HTMLUtilities.setElAttrs,visuallyHideElement$1=HTMLUtilities.visuallyHideElement,Announcer=(function(){function z(y,a){this.chart=y,this.domElementProvider=new DOMElementProvider,this.announceRegion=this.addAnnounceRegion(a)}return z.prototype.destroy=function(){this.domElementProvider.destroyCreatedElements()},z.prototype.announce=function(y){var a=this;AST.setElementHTML(this.announceRegion,y),this.clearAnnouncementRegionTimer&&clearTimeout(this.clearAnnouncementRegionTimer),this.clearAnnouncementRegionTimer=setTimeout(function(){a.announceRegion.innerHTML="",delete a.clearAnnouncementRegionTimer},1e3)},z.prototype.addAnnounceRegion=function(y){var a=this.chart.announcerContainer||this.createAnnouncerContainer(),k=this.domElementProvider.createElement("div");return setElAttrs$3(k,{"aria-hidden":!1,"aria-live":y}),visuallyHideElement$1(k),a.appendChild(k),k},z.prototype.createAnnouncerContainer=function(){var y=this.chart,a=doc$9.createElement("div");return setElAttrs$3(a,{"aria-hidden":!1,style:"position:relative",class:"highcharts-announcer-container"}),y.renderTo.insertBefore(a,y.renderTo.firstChild),y.announcerContainer=a,a},z})(),extend$_=Utilities.extend,defined$q=Utilities.defined,getChartTitle$2=ChartUtilities.getChartTitle,defaultPointDescriptionFormatter=SeriesDescriber.defaultPointDescriptionFormatter,defaultSeriesDescriptionFormatter=SeriesDescriber.defaultSeriesDescriptionFormatter;function chartHasAnnounceEnabled(z){return!!z.options.accessibility.announceNewData.enabled}function findPointInDataArray(z){var y=z.series.data.filter(function(a){return z.x===a.x&&z.y===a.y});return y.length===1?y[0]:z}function getUniqueSeries(z,y){var a=(z||[]).concat(y||[]).reduce(function(k,j){return k[j.name+j.index]=j,k},{});return Object.keys(a).map(function(k){return a[k]})}var NewDataAnnouncer=function(z){this.chart=z};extend$_(NewDataAnnouncer.prototype,{init:function(){var z=this.chart,y=z.options.accessibility.announceNewData,a=y.interruptUser?"assertive":"polite";this.lastAnnouncementTime=0,this.dirty={allSeries:{}},this.eventProvider=new EventProvider,this.announcer=new Announcer(z,a),this.addEventListeners()},destroy:function(){this.eventProvider.removeAddedEvents(),this.announcer.destroy()},addEventListeners:function(){var z=this,y=this.chart,a=this.eventProvider;a.addEvent(y,"afterDrilldown",function(){z.lastAnnouncementTime=0}),a.addEvent(Series$f,"updatedData",function(){z.onSeriesUpdatedData(this)}),a.addEvent(y,"afterAddSeries",function(k){z.onSeriesAdded(k.series)}),a.addEvent(Series$f,"addPoint",function(k){z.onPointAdded(k.point)}),a.addEvent(y,"redraw",function(){z.announceDirtyData()})},onSeriesUpdatedData:function(z){var y=this.chart;z.chart===y&&chartHasAnnounceEnabled(y)&&(this.dirty.hasDirty=!0,this.dirty.allSeries[z.name+z.index]=z)},onSeriesAdded:function(z){chartHasAnnounceEnabled(this.chart)&&(this.dirty.hasDirty=!0,this.dirty.allSeries[z.name+z.index]=z,this.dirty.newSeries=defined$q(this.dirty.newSeries)?void 0:z)},onPointAdded:function(z){var y=z.series.chart;this.chart===y&&chartHasAnnounceEnabled(y)&&(this.dirty.newPoint=defined$q(this.dirty.newPoint)?void 0:z)},announceDirtyData:function(){var z=this.chart,y=this;if(z.options.accessibility.announceNewData&&this.dirty.hasDirty){var a=this.dirty.newPoint;a&&(a=findPointInDataArray(a)),this.queueAnnouncement(Object.keys(this.dirty.allSeries).map(function(k){return y.dirty.allSeries[k]}),this.dirty.newSeries,a),this.dirty={allSeries:{}}}},queueAnnouncement:function(z,y,a){var k=this,j=this.chart,et=j.options.accessibility.announceNewData;if(et.enabled){var it=+new Date,nt=it-this.lastAnnouncementTime,ot=Math.max(0,et.minAnnounceInterval-nt),at=getUniqueSeries(this.queuedAnnouncement&&this.queuedAnnouncement.series,z),lt=this.buildAnnouncementMessage(at,y,a);lt&&(this.queuedAnnouncement&&clearTimeout(this.queuedAnnouncementTimer),this.queuedAnnouncement={time:it,message:lt,series:at},this.queuedAnnouncementTimer=setTimeout(function(){k&&k.announcer&&(k.lastAnnouncementTime=+new Date,k.announcer.announce(k.queuedAnnouncement.message),delete k.queuedAnnouncement,delete k.queuedAnnouncementTimer)},ot))}},buildAnnouncementMessage:function(z,y,a){var k=this.chart,j=k.options.accessibility.announceNewData;if(j.announcementFormatter){var et=j.announcementFormatter(z,y,a);if(et!==!1)return et.length?et:null}var it=H.charts&&H.charts.length>1?"Multiple":"Single",nt=y?"newSeriesAnnounce"+it:a?"newPointAnnounce"+it:"newDataAnnounce",ot=getChartTitle$2(k);return k.langFormat("accessibility.announceNewData."+nt,{chartTitle:ot,seriesDesc:y?defaultSeriesDescriptionFormatter(y):null,pointDesc:a?defaultPointDescriptionFormatter(a):null,point:a,series:y})}});var addEvent$G=Utilities.addEvent,merge$U=Utilities.merge;function isWithinDescriptionThreshold(z){var y=z.chart.options.accessibility;return z.points.length<y.series.pointDescriptionEnabledThreshold||y.series.pointDescriptionEnabledThreshold===!1}function shouldForceMarkers(z){var y=z.chart,a=y.options.accessibility.enabled,k=(z.options.accessibility&&z.options.accessibility.enabled)!==!1;return a&&k&&isWithinDescriptionThreshold(z)}function hasIndividualPointMarkerOptions(z){return!!(z._hasPointMarkers&&z.points&&z.points.length)}function unforceSeriesMarkerOptions(z){var y=z.resetA11yMarkerOptions;y&&merge$U(!0,z.options,{marker:{enabled:y.enabled,states:{normal:{opacity:y.states&&y.states.normal&&y.states.normal.opacity}}}})}function forceZeroOpacityMarkerOptions(z){merge$U(!0,z,{marker:{enabled:!0,states:{normal:{opacity:0}}}})}function getPointMarkerOpacity(z){return z.marker.states&&z.marker.states.normal&&z.marker.states.normal.opacity||1}function unforcePointMarkerOptions(z){merge$U(!0,z.marker,{states:{normal:{opacity:getPointMarkerOpacity(z)}}})}function handleForcePointMarkers(z){for(var y=z.points.length;y--;){var a=z.points[y],k=a.options;delete a.hasForcedA11yMarker,k.marker&&(k.marker.enabled?(unforcePointMarkerOptions(k),a.hasForcedA11yMarker=!1):(forceZeroOpacityMarkerOptions(k),a.hasForcedA11yMarker=!0))}}function addForceMarkersEvents(){addEvent$G(Series$f,"render",function(){var z=this,y=z.options;shouldForceMarkers(z)?(y.marker&&y.marker.enabled===!1&&(z.a11yMarkersForced=!0,forceZeroOpacityMarkerOptions(z.options)),hasIndividualPointMarkerOptions(z)&&handleForcePointMarkers(z)):z.a11yMarkersForced&&(delete z.a11yMarkersForced,unforceSeriesMarkerOptions(z))}),addEvent$G(Series$f,"afterSetOptions",function(z){this.resetA11yMarkerOptions=merge$U(z.options.marker||{},this.userOptions.marker||{})}),addEvent$G(Series$f,"afterRender",function(){var z=this;z.chart.styledMode&&(z.markerGroup&&z.markerGroup[z.a11yMarkersForced?"addClass":"removeClass"]("highcharts-a11y-markers-hidden"),hasIndividualPointMarkerOptions(z)&&z.points.forEach(function(y){y.graphic&&(y.graphic[y.hasForcedA11yMarker?"addClass":"removeClass"]("highcharts-a11y-marker-hidden"),y.graphic[y.hasForcedA11yMarker===!1?"addClass":"removeClass"]("highcharts-a11y-marker-visible"))}))})}var extend$Z=Utilities.extend,hideSeriesFromAT=ChartUtilities.hideSeriesFromAT,describeSeries=SeriesDescriber.describeSeries;H.SeriesAccessibilityDescriber=SeriesDescriber;addForceMarkersEvents();var SeriesComponent=function(){};SeriesComponent.prototype=new AccessibilityComponent;extend$Z(SeriesComponent.prototype,{init:function(){this.newDataAnnouncer=new NewDataAnnouncer(this.chart),this.newDataAnnouncer.init(),this.keyboardNavigation=new SeriesKeyboardNavigation(this.chart,this.keyCodes),this.keyboardNavigation.init(),this.hideTooltipFromATWhenShown(),this.hideSeriesLabelsFromATWhenShown()},hideTooltipFromATWhenShown:function(){var z=this;this.addEvent(Tooltip,"refresh",function(){this.chart===z.chart&&this.label&&this.label.element&&this.label.element.setAttribute("aria-hidden",!0)})},hideSeriesLabelsFromATWhenShown:function(){this.addEvent(this.chart,"afterDrawSeriesLabels",function(){this.series.forEach(function(z){z.labelBySeries&&z.labelBySeries.attr("aria-hidden",!0)})})},onChartRender:function(){var z=this.chart;z.series.forEach(function(y){var a=(y.options.accessibility&&y.options.accessibility.enabled)!==!1&&y.visible;a?describeSeries(y):hideSeriesFromAT(y)})},getKeyboardNavigation:function(){return this.keyboardNavigation.getKeyboardNavigationHandler()},destroy:function(){this.newDataAnnouncer.destroy(),this.keyboardNavigation.destroy()}});var unhideChartElementFromAT$3=ChartUtilities.unhideChartElementFromAT,noop$c=H.noop,removeElement=HTMLUtilities.removeElement,setElAttrs$2=HTMLUtilities.setElAttrs,extend$Y=Utilities.extend,pick$$=Utilities.pick;function chartHasMapZoom(z){return!!(z.mapZoom&&z.mapNavButtons&&z.mapNavButtons.length)}H.Axis.prototype.panStep=function(z,y){var a=y||3,k=this.getExtremes(),j=(k.max-k.min)/a*z,et=k.max+j,it=k.min+j,nt=et-it;z<0&&it<k.dataMin?(it=k.dataMin,et=it+nt):z>0&&et>k.dataMax&&(et=k.dataMax,it=et-nt),this.setExtremes(it,et)};var ZoomComponent=noop$c;ZoomComponent.prototype=new AccessibilityComponent;extend$Y(ZoomComponent.prototype,{init:function(){var z=this,y=this.chart;["afterShowResetZoom","afterDrilldown","drillupall"].forEach(function(a){z.addEvent(y,a,function(){z.updateProxyOverlays()})})},onChartUpdate:function(){var z=this.chart,y=this;z.mapNavButtons&&z.mapNavButtons.forEach(function(a,k){unhideChartElementFromAT$3(z,a.element),y.setMapNavButtonAttrs(a.element,"accessibility.zoom.mapZoom"+(k?"Out":"In"))})},setMapNavButtonAttrs:function(z,y){var a=this.chart,k=a.langFormat(y,{chart:a});setElAttrs$2(z,{tabindex:-1,role:"button","aria-label":k})},onChartRender:function(){this.updateProxyOverlays()},updateProxyOverlays:function(){var z=this.chart;removeElement(this.drillUpProxyGroup),removeElement(this.resetZoomProxyGroup),z.resetZoomButton&&this.recreateProxyButtonAndGroup(z.resetZoomButton,"resetZoomProxyButton","resetZoomProxyGroup",z.langFormat("accessibility.zoom.resetZoomButton",{chart:z})),z.drillUpButton&&this.recreateProxyButtonAndGroup(z.drillUpButton,"drillUpProxyButton","drillUpProxyGroup",z.langFormat("accessibility.drillUpButton",{chart:z,buttonText:z.getDrilldownBackText()}))},recreateProxyButtonAndGroup:function(z,y,a,k){removeElement(this[a]),this[a]=this.addProxyGroup(),this[y]=this.createProxyButton(z,this[a],{"aria-label":k,tabindex:-1})},getMapZoomNavigation:function(){var z=this.keyCodes,y=this.chart,a=this;return new KeyboardNavigationHandler(y,{keyCodeMap:[[[z.up,z.down,z.left,z.right],function(k){return a.onMapKbdArrow(this,k)}],[[z.tab],function(k,j){return a.onMapKbdTab(this,j)}],[[z.space,z.enter],function(){return a.onMapKbdClick(this)}]],validate:function(){return chartHasMapZoom(y)},init:function(k){return a.onMapNavInit(k)}})},onMapKbdArrow:function(z,y){var a=this.keyCodes,k=y===a.up||y===a.down?"yAxis":"xAxis",j=y===a.left||y===a.up?-1:1;return this.chart[k][0].panStep(j),z.response.success},onMapKbdTab:function(z,y){var a,k=this.chart,j=z.response,et=y.shiftKey,it=et&&!this.focusedMapNavButtonIx||!et&&this.focusedMapNavButtonIx;return k.mapNavButtons[this.focusedMapNavButtonIx].setState(0),it?(k.mapZoom(),j[et?"prev":"next"]):(this.focusedMapNavButtonIx+=et?-1:1,a=k.mapNavButtons[this.focusedMapNavButtonIx],k.setFocusToElement(a.box,a.element),a.setState(2),j.success)},onMapKbdClick:function(z){return this.fakeClickEvent(this.chart.mapNavButtons[this.focusedMapNavButtonIx].element),z.response.success},onMapNavInit:function(z){var y=this.chart,a=y.mapNavButtons[0],k=y.mapNavButtons[1],j=z>0?a:k;y.setFocusToElement(j.box,j.element),j.setState(2),this.focusedMapNavButtonIx=z>0?0:1},simpleButtonNavigation:function(z,y,a){var k=this.keyCodes,j=this,et=this.chart;return new KeyboardNavigationHandler(et,{keyCodeMap:[[[k.tab,k.up,k.down,k.left,k.right],function(it,nt){var ot=it===k.tab&&nt.shiftKey||it===k.left||it===k.up;return this.response[ot?"prev":"next"]}],[[k.space,k.enter],function(){var it=a(this,et);return pick$$(it,this.response.success)}]],validate:function(){var it=et[z]&&et[z].box&&j[y];return it},init:function(){et.setFocusToElement(et[z].box,j[y])}})},getKeyboardNavigation:function(){return[this.simpleButtonNavigation("resetZoomButton","resetZoomProxyButton",function(z,y){y.zoomOut()}),this.simpleButtonNavigation("drillUpButton","drillUpProxyButton",function(z,y){return y.drillUp(),z.response.prev}),this.getMapZoomNavigation()]}});var unhideChartElementFromAT$2=ChartUtilities.unhideChartElementFromAT,getAxisRangeDescription$1=ChartUtilities.getAxisRangeDescription,setElAttrs$1=HTMLUtilities.setElAttrs,addEvent$F=Utilities.addEvent,extend$X=Utilities.extend;function shouldRunInputNavigation(z){return!!(z.rangeSelector&&z.rangeSelector.inputGroup&&z.rangeSelector.inputGroup.element.getAttribute("visibility")!=="hidden"&&z.options.rangeSelector.inputEnabled!==!1&&z.rangeSelector.minInput&&z.rangeSelector.maxInput)}Chart$1.prototype.highlightRangeSelectorButton=function(z){var y=this.rangeSelector&&this.rangeSelector.buttons||[],a=this.highlightedRangeSelectorItemIx,k=this.rangeSelector&&this.rangeSelector.selected;return typeof a<"u"&&y[a]&&a!==k&&y[a].setState(this.oldRangeSelectorItemState||0),this.highlightedRangeSelectorItemIx=z,y[z]?(this.setFocusToElement(y[z].box,y[z].element),z!==k&&(this.oldRangeSelectorItemState=y[z].state,y[z].setState(1)),!0):!1};addEvent$F(RangeSelector,"afterBtnClick",function(){if(this.chart.accessibility&&this.chart.accessibility.components.rangeSelector)return this.chart.accessibility.components.rangeSelector.onAfterBtnClick()});var RangeSelectorComponent=function(){};RangeSelectorComponent.prototype=new AccessibilityComponent;extend$X(RangeSelectorComponent.prototype,{init:function(){var z=this.chart;this.announcer=new Announcer(z,"polite")},onChartUpdate:function(){var z=this.chart,y=this,a=z.rangeSelector;a&&(this.updateSelectorVisibility(),this.setDropdownAttrs(),a.buttons&&a.buttons.length&&a.buttons.forEach(function(k){y.setRangeButtonAttrs(k)}),a.maxInput&&a.minInput&&["minInput","maxInput"].forEach(function(k,j){var et=a[k];et&&(unhideChartElementFromAT$2(z,et),y.setRangeInputAttrs(et,"accessibility.rangeSelector."+(j?"max":"min")+"InputLabel"))}))},updateSelectorVisibility:function(){var z=this.chart,y=z.rangeSelector,a=y&&y.dropdown,k=y&&y.buttons||[],j=function(et){return et.setAttribute("aria-hidden",!0)};y&&y.hasVisibleDropdown&&a?(unhideChartElementFromAT$2(z,a),k.forEach(function(et){return j(et.element)})):(a&&j(a),k.forEach(function(et){return unhideChartElementFromAT$2(z,et.element)}))},setDropdownAttrs:function(){var z=this.chart,y=z.rangeSelector&&z.rangeSelector.dropdown;if(y){var a=z.langFormat("accessibility.rangeSelector.dropdownLabel",{rangeTitle:z.options.lang.rangeSelectorZoom});y.setAttribute("aria-label",a),y.setAttribute("tabindex",-1)}},setRangeButtonAttrs:function(z){setElAttrs$1(z.element,{tabindex:-1,role:"button"})},setRangeInputAttrs:function(z,y){var a=this.chart;setElAttrs$1(z,{tabindex:-1,"aria-label":a.langFormat(y,{chart:a})})},onButtonNavKbdArrowKey:function(z,y){var a=z.response,k=this.keyCodes,j=this.chart,et=j.options.accessibility.keyboardNavigation.wrapAround,it=y===k.left||y===k.up?-1:1,nt=j.highlightRangeSelectorButton(j.highlightedRangeSelectorItemIx+it);return nt?a.success:et?(z.init(it),a.success):a[it>0?"next":"prev"]},onButtonNavKbdClick:function(z){var y=z.response,a=this.chart,k=a.oldRangeSelectorItemState===3;return k||this.fakeClickEvent(a.rangeSelector.buttons[a.highlightedRangeSelectorItemIx].element),y.success},onAfterBtnClick:function(){var z=this.chart,y=getAxisRangeDescription$1(z.xAxis[0]),a=z.langFormat("accessibility.rangeSelector.clickButtonAnnouncement",{chart:z,axisRangeDescription:y});a&&this.announcer.announce(a)},onInputKbdMove:function(z){var y=this.chart,a=y.rangeSelector,k=y.highlightedInputRangeIx=(y.highlightedInputRangeIx||0)+z,j=k>1||k<0;if(j)y.accessibility&&(y.accessibility.keyboardNavigation.tabindexContainer.focus(),y.accessibility.keyboardNavigation[z<0?"prev":"next"]());else if(a){var et=a[k?"maxDateBox":"minDateBox"],it=a[k?"maxInput":"minInput"];et&&it&&y.setFocusToElement(et,it)}},onInputNavInit:function(z){var y=this,a=this,k=this.chart,j=z>0?0:1,et=k.rangeSelector,it=et&&et[j?"maxDateBox":"minDateBox"],nt=et&&et.minInput,ot=et&&et.maxInput,at=j?ot:nt;if(k.highlightedInputRangeIx=j,it&&nt&&ot){k.setFocusToElement(it,at),this.removeInputKeydownHandler&&this.removeInputKeydownHandler();var lt=function(ut){var ft=(ut.which||ut.keyCode)===y.keyCodes.tab;ft&&(ut.preventDefault(),ut.stopPropagation(),a.onInputKbdMove(ut.shiftKey?-1:1))},ct=addEvent$F(nt,"keydown",lt),ht=addEvent$F(ot,"keydown",lt);this.removeInputKeydownHandler=function(){ct(),ht()}}},onInputNavTerminate:function(){var z=this.chart.rangeSelector||{};z.maxInput&&z.hideInput("max"),z.minInput&&z.hideInput("min"),this.removeInputKeydownHandler&&(this.removeInputKeydownHandler(),delete this.removeInputKeydownHandler)},initDropdownNav:function(){var z=this,y=this.chart,a=y.rangeSelector,k=a&&a.dropdown;a&&k&&(y.setFocusToElement(a.buttonGroup,k),this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeDropdownKeydownHandler=addEvent$F(k,"keydown",function(j){var et=(j.which||j.keyCode)===z.keyCodes.tab;et&&(j.preventDefault(),j.stopPropagation(),y.accessibility&&(y.accessibility.keyboardNavigation.tabindexContainer.focus(),y.accessibility.keyboardNavigation[j.shiftKey?"prev":"next"]()))}))},getRangeSelectorButtonNavigation:function(){var z=this.chart,y=this.keyCodes,a=this;return new KeyboardNavigationHandler(z,{keyCodeMap:[[[y.left,y.right,y.up,y.down],function(k){return a.onButtonNavKbdArrowKey(this,k)}],[[y.enter,y.space],function(){return a.onButtonNavKbdClick(this)}]],validate:function(){return!!(z.rangeSelector&&z.rangeSelector.buttons&&z.rangeSelector.buttons.length)},init:function(k){var j=z.rangeSelector;if(j&&j.hasVisibleDropdown)a.initDropdownNav();else if(j){var et=j.buttons.length-1;z.highlightRangeSelectorButton(k>0?0:et)}},terminate:function(){a.removeDropdownKeydownHandler&&(a.removeDropdownKeydownHandler(),delete a.removeDropdownKeydownHandler)}})},getRangeSelectorInputNavigation:function(){var z=this.chart,y=this;return new KeyboardNavigationHandler(z,{keyCodeMap:[],validate:function(){return shouldRunInputNavigation(z)},init:function(a){y.onInputNavInit(a)},terminate:function(){y.onInputNavTerminate()}})},getKeyboardNavigation:function(){return[this.getRangeSelectorButtonNavigation(),this.getRangeSelectorInputNavigation()]},destroy:function(){this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeInputKeydownHandler&&this.removeInputKeydownHandler(),this.announcer&&this.announcer.destroy()}});var format$5=FormatUtilities.format,doc$8=H.doc,extend$W=Utilities.extend,pick$_=Utilities.pick,getAnnotationsInfoHTML=AnnotationsA11y.getAnnotationsInfoHTML,getAxisDescription=ChartUtilities.getAxisDescription,getAxisRangeDescription=ChartUtilities.getAxisRangeDescription,getChartTitle$1=ChartUtilities.getChartTitle,unhideChartElementFromAT$1=ChartUtilities.unhideChartElementFromAT,addClass=HTMLUtilities.addClass,getElement=HTMLUtilities.getElement,getHeadingTagNameForElement=HTMLUtilities.getHeadingTagNameForElement,setElAttrs=HTMLUtilities.setElAttrs,stripHTMLTagsFromString=HTMLUtilities.stripHTMLTagsFromString,visuallyHideElement=HTMLUtilities.visuallyHideElement;function stripEmptyHTMLTags(z){return z.replace(/<(\w+)[^>]*?>\s*<\/\1>/g,"")}function getTypeDescForMapChart(z,y){return y.mapTitle?z.langFormat("accessibility.chartTypes.mapTypeDescription",y):z.langFormat("accessibility.chartTypes.unknownMap",y)}function getTypeDescForCombinationChart(z,y){return z.langFormat("accessibility.chartTypes.combinationChart",y)}function getTypeDescForEmptyChart(z,y){return z.langFormat("accessibility.chartTypes.emptyChart",y)}function buildTypeDescriptionFromSeries(z,y,a){var k=y[0],j=z.langFormat("accessibility.seriesTypeDescriptions."+k,a),et=z.series&&z.series.length<2?"Single":"Multiple";return(z.langFormat("accessibility.chartTypes."+k+et,a)||z.langFormat("accessibility.chartTypes.default"+et,a))+(j?" "+j:"")}function getTableSummary(z){return z.langFormat("accessibility.table.tableSummary",{chart:z})}Chart$1.prototype.getTypeDescription=function(z){var y=z[0],a=this.series&&this.series[0]||{},k={numSeries:this.series.length,numPoints:a.points&&a.points.length,chart:this,mapTitle:a.mapTitle};return y?y==="map"?getTypeDescForMapChart(this,k):this.types.length>1?getTypeDescForCombinationChart(this,k):buildTypeDescriptionFromSeries(this,z,k):getTypeDescForEmptyChart(this,k)};var InfoRegionsComponent=function(){};InfoRegionsComponent.prototype=new AccessibilityComponent;extend$W(InfoRegionsComponent.prototype,{init:function(){var z=this.chart,y=this;this.initRegionsDefinitions(),this.addEvent(z,"aftergetTableAST",function(a){y.onDataTableCreated(a)}),this.addEvent(z,"afterViewData",function(a){y.dataTableDiv=a,setTimeout(function(){y.focusDataTable()},300)}),this.announcer=new Announcer(z,"assertive")},initRegionsDefinitions:function(){var z=this;this.screenReaderSections={before:{element:null,buildContent:function(y){var a=y.options.accessibility.screenReaderSection.beforeChartFormatter;return a?a(y):z.defaultBeforeChartFormatter(y)},insertIntoDOM:function(y,a){a.renderTo.insertBefore(y,a.renderTo.firstChild)},afterInserted:function(){typeof z.sonifyButtonId<"u"&&z.initSonifyButton(z.sonifyButtonId),typeof z.dataTableButtonId<"u"&&z.initDataTableButton(z.dataTableButtonId)}},after:{element:null,buildContent:function(y){var a=y.options.accessibility.screenReaderSection.afterChartFormatter;return a?a(y):z.defaultAfterChartFormatter()},insertIntoDOM:function(y,a){a.renderTo.insertBefore(y,a.container.nextSibling)},afterInserted:function(){z.chart.accessibility&&z.chart.accessibility.keyboardNavigation.updateExitAnchor()}}}},onChartRender:function(){var z=this;this.linkedDescriptionElement=this.getLinkedDescriptionElement(),this.setLinkedDescriptionAttrs(),Object.keys(this.screenReaderSections).forEach(function(y){z.updateScreenReaderSection(y)})},getLinkedDescriptionElement:function(){var z=this.chart.options,y=z.accessibility.linkedDescription;if(y){if(typeof y!="string")return y;var a=format$5(y,this.chart),k=doc$8.querySelectorAll(a);if(k.length===1)return k[0]}},setLinkedDescriptionAttrs:function(){var z=this.linkedDescriptionElement;z&&(z.setAttribute("aria-hidden","true"),addClass(z,"highcharts-linked-description"))},updateScreenReaderSection:function(z){var y=this.chart,a=this.screenReaderSections[z],k=a.buildContent(y),j=a.element=a.element||this.createElement("div"),et=j.firstChild||this.createElement("div");this.setScreenReaderSectionAttribs(j,z),AST.setElementHTML(et,k),j.appendChild(et),a.insertIntoDOM(j,y),visuallyHideElement(et),unhideChartElementFromAT$1(y,et),a.afterInserted&&a.afterInserted()},setScreenReaderSectionAttribs:function(z,y){var a="accessibility.screenReaderSection."+y+"RegionLabel",k=this.chart,j=k.langFormat(a,{chart:k,chartTitle:getChartTitle$1(k)}),et="highcharts-screen-reader-region-"+y+"-"+k.index;setElAttrs(z,{id:et,"aria-label":j}),z.style.position="relative",k.options.accessibility.landmarkVerbosity==="all"&&j&&z.setAttribute("role","region")},defaultBeforeChartFormatter:function(){var z=this.chart,y=z.options.accessibility.screenReaderSection.beforeChartFormat,a=this.getAxesDescription(),k=z.sonify&&z.options.sonification&&z.options.sonification.enabled,j="highcharts-a11y-sonify-data-btn-"+z.index,et="hc-linkto-highcharts-data-table-"+z.index,it=getAnnotationsInfoHTML(z),nt=z.langFormat("accessibility.screenReaderSection.annotations.heading",{chart:z}),ot={headingTagName:getHeadingTagNameForElement(z.renderTo),chartTitle:getChartTitle$1(z),typeDescription:this.getTypeDescriptionText(),chartSubtitle:this.getSubtitleText(),chartLongdesc:this.getLongdescText(),xAxisDescription:a.xAxis,yAxisDescription:a.yAxis,playAsSoundButton:k?this.getSonifyButtonText(j):"",viewTableButton:z.getCSV?this.getDataTableButtonText(et):"",annotationsTitle:it?nt:"",annotationsList:it},at=H.i18nFormat(y,ot,z);return this.dataTableButtonId=et,this.sonifyButtonId=j,stripEmptyHTMLTags(at)},defaultAfterChartFormatter:function(){var z=this.chart,y=z.options.accessibility.screenReaderSection.afterChartFormat,a={endOfChartMarker:this.getEndOfChartMarkerText()},k=H.i18nFormat(y,a,z);return stripEmptyHTMLTags(k)},getLinkedDescription:function(){var z=this.linkedDescriptionElement,y=z&&z.innerHTML||"";return stripHTMLTagsFromString(y)},getLongdescText:function(){var z=this.chart.options,y=z.caption,a=y&&y.text,k=this.getLinkedDescription();return z.accessibility.description||k||a||""},getTypeDescriptionText:function(){var z=this.chart;return z.types?z.options.accessibility.typeDescription||z.getTypeDescription(z.types):""},getDataTableButtonText:function(z){var y=this.chart,a=y.langFormat("accessibility.table.viewAsDataTableButtonText",{chart:y,chartTitle:getChartTitle$1(y)});return'<button id="'+z+'">'+a+"</button>"},getSonifyButtonText:function(z){var y=this.chart;if(y.options.sonification&&y.options.sonification.enabled===!1)return"";var a=y.langFormat("accessibility.sonification.playAsSoundButtonText",{chart:y,chartTitle:getChartTitle$1(y)});return'<button id="'+z+'">'+a+"</button>"},getSubtitleText:function(){var z=this.chart.options.subtitle;return stripHTMLTagsFromString(z&&z.text||"")},getEndOfChartMarkerText:function(){var z=this.chart,y=z.langFormat("accessibility.screenReaderSection.endOfChartMarker",{chart:z}),a="highcharts-end-of-chart-marker-"+z.index;return'<div id="'+a+'">'+y+"</div>"},onDataTableCreated:function(z){var y=this.chart;if(y.options.accessibility.enabled){this.viewDataTableButton&&this.viewDataTableButton.setAttribute("aria-expanded","true");var a=z.tree.attributes||{};a.tabindex=-1,a.summary=getTableSummary(y),z.tree.attributes=a}},focusDataTable:function(){var z=this.dataTableDiv,y=z&&z.getElementsByTagName("table")[0];y&&y.focus&&y.focus()},initSonifyButton:function(z){var y=this,a=this.sonifyButton=getElement(z),k=this.chart,j=function(et){a&&(a.setAttribute("aria-hidden","true"),a.setAttribute("aria-label","")),et.preventDefault(),et.stopPropagation();var it=k.langFormat("accessibility.sonification.playAsSoundClickAnnouncement",{chart:k});y.announcer.announce(it),setTimeout(function(){a&&(a.removeAttribute("aria-hidden"),a.removeAttribute("aria-label")),k.sonify&&k.sonify()},1e3)};a&&k&&(setElAttrs(a,{tabindex:-1}),a.onclick=function(et){var it=k.options.accessibility&&k.options.accessibility.screenReaderSection.onPlayAsSoundClick;(it||j).call(this,et,k)})},initDataTableButton:function(z){var y=this.viewDataTableButton=getElement(z),a=this.chart,k=z.replace("hc-linkto-","");y&&(setElAttrs(y,{tabindex:-1,"aria-expanded":!!getElement(k)}),y.onclick=a.options.accessibility.screenReaderSection.onViewDataTableClick||function(){a.viewData()})},getAxesDescription:function(){var z=this.chart,y=function(nt,ot){var at=z[nt];return at.length>1||at[0]&&pick$_(at[0].options.accessibility&&at[0].options.accessibility.enabled,ot)},a=!!z.types&&z.types.indexOf("map")<0,k=!!z.hasCartesianSeries,j=y("xAxis",!z.angular&&k&&a),et=y("yAxis",k&&a),it={};return j&&(it.xAxis=this.getAxisDescriptionText("xAxis")),et&&(it.yAxis=this.getAxisDescriptionText("yAxis")),it},getAxisDescriptionText:function(z){var y=this.chart,a=y[z];return y.langFormat("accessibility.axis."+z+"Description"+(a.length>1?"Plural":"Singular"),{chart:y,names:a.map(function(k){return getAxisDescription(k)}),ranges:a.map(function(k){return getAxisRangeDescription(k)}),numAxes:a.length})},destroy:function(){this.announcer&&this.announcer.destroy()}});var unhideChartElementFromAT=ChartUtilities.unhideChartElementFromAT,getChartTitle=ChartUtilities.getChartTitle,doc$7=H.doc,stripHTMLTags=HTMLUtilities.stripHTMLTagsFromString,extend$V=Utilities.extend,ContainerComponent=function(){};ContainerComponent.prototype=new AccessibilityComponent;extend$V(ContainerComponent.prototype,{onChartUpdate:function(){this.handleSVGTitleElement(),this.setSVGContainerLabel(),this.setGraphicContainerAttrs(),this.setRenderToAttrs(),this.makeCreditsAccessible()},handleSVGTitleElement:function(){var z=this.chart,y="highcharts-title-"+z.index,a=stripHTMLTags(z.langFormat("accessibility.svgContainerTitle",{chartTitle:getChartTitle(z)}));if(a.length){var k=this.svgTitleElement=this.svgTitleElement||doc$7.createElementNS("http://www.w3.org/2000/svg","title");k.textContent=a,k.id=y,z.renderTo.insertBefore(k,z.renderTo.firstChild)}},setSVGContainerLabel:function(){var z=this.chart,y=z.langFormat("accessibility.svgContainerLabel",{chartTitle:getChartTitle(z)});z.renderer.box&&y.length&&z.renderer.box.setAttribute("aria-label",y)},setGraphicContainerAttrs:function(){var z=this.chart,y=z.langFormat("accessibility.graphicContainerLabel",{chartTitle:getChartTitle(z)});y.length&&z.container.setAttribute("aria-label",y)},setRenderToAttrs:function(){var z=this.chart;z.options.accessibility.landmarkVerbosity!=="disabled"?z.renderTo.setAttribute("role","region"):z.renderTo.removeAttribute("role"),z.renderTo.setAttribute("aria-label",z.langFormat("accessibility.chartContainerLabel",{title:getChartTitle(z),chart:z}))},makeCreditsAccessible:function(){var z=this.chart,y=z.credits;y&&(y.textStr&&y.element.setAttribute("aria-label",z.langFormat("accessibility.credits",{creditsStr:stripHTMLTags(y.textStr)})),unhideChartElementFromAT(z,y.element))},getKeyboardNavigation:function(){var z=this.chart;return new KeyboardNavigationHandler(z,{keyCodeMap:[],validate:function(){return!0},init:function(){var y=z.accessibility;y&&y.keyboardNavigation.tabindexContainer.focus()}})},destroy:function(){this.chart.renderTo.setAttribute("aria-hidden",!0)}});var doc$6=H.doc,isMS=H.isMS,win$3=H.win,whcm={isHighContrastModeActive:function(){var z=/(Edg)/.test(win$3.navigator.userAgent);if(win$3.matchMedia&&z)return win$3.matchMedia("(-ms-high-contrast: active)").matches;if(isMS&&win$3.getComputedStyle){var y=doc$6.createElement("div"),a="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==";y.style.backgroundImage="url("+a+")",doc$6.body.appendChild(y);var k=(y.currentStyle||win$3.getComputedStyle(y)).backgroundImage;return doc$6.body.removeChild(y),k==="none"}return!1},setHighContrastTheme:function(z){z.highContrastModeActive=!0;var y=z.options.accessibility.highContrastTheme;z.update(y,!1),z.series.forEach(function(a){var k=y.plotOptions[a.type]||{};a.update({color:k.color||"windowText",colors:[k.color||"windowText"],borderColor:k.borderColor||"window"}),a.points.forEach(function(j){j.options&&j.options.color&&j.update({color:k.color||"windowText",borderColor:k.borderColor||"window"},!1)})}),z.redraw()}},theme={chart:{backgroundColor:"window"},title:{style:{color:"windowText"}},subtitle:{style:{color:"windowText"}},colorAxis:{minColor:"windowText",maxColor:"windowText",stops:[]},colors:["windowText"],xAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},yAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},tooltip:{backgroundColor:"window",borderColor:"windowText",style:{color:"windowText"}},plotOptions:{series:{lineColor:"windowText",fillColor:"window",borderColor:"windowText",edgeColor:"windowText",borderWidth:1,dataLabels:{connectorColor:"windowText",color:"windowText",style:{color:"windowText",textOutline:"none"}},marker:{lineColor:"windowText",fillColor:"windowText"}},pie:{color:"window",colors:["window"],borderColor:"windowText",borderWidth:1},boxplot:{fillColor:"window"},candlestick:{lineColor:"windowText",fillColor:"window"},errorbar:{fillColor:"window"}},legend:{backgroundColor:"window",itemStyle:{color:"windowText"},itemHoverStyle:{color:"windowText"},itemHiddenStyle:{color:"#555"},title:{style:{color:"windowText"}}},credits:{style:{color:"windowText"}},labels:{style:{color:"windowText"}},drilldown:{activeAxisLabelStyle:{color:"windowText"},activeDataLabelStyle:{color:"windowText"}},navigation:{buttonOptions:{symbolStroke:"windowText",theme:{fill:"window"}}},rangeSelector:{buttonTheme:{fill:"window",stroke:"windowText",style:{color:"windowText"},states:{hover:{fill:"window",stroke:"windowText",style:{color:"windowText"}},select:{fill:"#444",stroke:"windowText",style:{color:"windowText"}}}},inputBoxBorderColor:"windowText",inputStyle:{backgroundColor:"window",color:"windowText"},labelStyle:{color:"windowText"}},navigator:{handles:{backgroundColor:"window",borderColor:"windowText"},outlineColor:"windowText",maskFill:"transparent",series:{color:"windowText",lineColor:"windowText"},xAxis:{gridLineColor:"windowText"}},scrollbar:{barBackgroundColor:"#444",barBorderColor:"windowText",buttonArrowColor:"windowText",buttonBackgroundColor:"window",buttonBorderColor:"windowText",rifleColor:"windowText",trackBackgroundColor:"window",trackBorderColor:"windowText"}},Options={accessibility:{enabled:!0,screenReaderSection:{beforeChartFormat:"<{headingTagName}>{chartTitle}</{headingTagName}><div>{typeDescription}</div><div>{chartSubtitle}</div><div>{chartLongdesc}</div><div>{playAsSoundButton}</div><div>{viewTableButton}</div><div>{xAxisDescription}</div><div>{yAxisDescription}</div><div>{annotationsTitle}{annotationsList}</div>",afterChartFormat:"{endOfChartMarker}",axisRangeDateFormat:"%Y-%m-%d %H:%M:%S"},series:{describeSingleSeries:!1,pointDescriptionEnabledThreshold:200},point:{valueDescriptionFormat:"{index}. {xDescription}{separator}{value}."},landmarkVerbosity:"all",linkedDescription:'*[data-highcharts-chart="{index}"] + .highcharts-description',keyboardNavigation:{enabled:!0,focusBorder:{enabled:!0,hideBrowserFocusOutline:!0,style:{color:palette.highlightColor80,lineWidth:2,borderRadius:3},margin:2},order:["series","zoom","rangeSelector","legend","chartMenu"],wrapAround:!0,seriesNavigation:{skipNullPoints:!0,pointNavigationEnabledThreshold:!1}},announceNewData:{enabled:!1,minAnnounceInterval:5e3,interruptUser:!1}},legend:{accessibility:{enabled:!0,keyboardNavigation:{enabled:!0}}},exporting:{accessibility:{enabled:!0}}},langOptions={accessibility:{defaultChartTitle:"Chart",chartContainerLabel:"{title}. Highcharts interactive chart.",svgContainerLabel:"Interactive chart",drillUpButton:"{buttonText}",credits:"Chart credits: {creditsStr}",thousandsSep:",",svgContainerTitle:"",graphicContainerLabel:"",screenReaderSection:{beforeRegionLabel:"Chart screen reader information, {chartTitle}.",afterRegionLabel:"",annotations:{heading:"Chart annotations summary",descriptionSinglePoint:"{annotationText}. Related to {annotationPoint}",descriptionMultiplePoints:"{annotationText}. Related to {annotationPoint}{ Also related to, #each(additionalAnnotationPoints)}",descriptionNoPoints:"{annotationText}"},endOfChartMarker:"End of interactive chart."},sonification:{playAsSoundButtonText:"Play as sound, {chartTitle}",playAsSoundClickAnnouncement:"Play"},legend:{legendLabelNoTitle:"Toggle series visibility, {chartTitle}",legendLabel:"Chart legend: {legendTitle}",legendItem:"Show {itemName}"},zoom:{mapZoomIn:"Zoom chart",mapZoomOut:"Zoom out chart",resetZoomButton:"Reset zoom"},rangeSelector:{dropdownLabel:"{rangeTitle}",minInputLabel:"Select start date.",maxInputLabel:"Select end date.",clickButtonAnnouncement:"Viewing {axisRangeDescription}"},table:{viewAsDataTableButtonText:"View as data table, {chartTitle}",tableSummary:"Table representation of chart."},announceNewData:{newDataAnnounce:"Updated data for chart {chartTitle}",newSeriesAnnounceSingle:"New data series: {seriesDesc}",newPointAnnounceSingle:"New data point: {pointDesc}",newSeriesAnnounceMultiple:"New data series in chart {chartTitle}: {seriesDesc}",newPointAnnounceMultiple:"New data point in chart {chartTitle}: {pointDesc}"},seriesTypeDescriptions:{boxplot:"Box plot charts are typically used to display groups of statistical data. Each data point in the chart can have up to 5 values: minimum, lower quartile, median, upper quartile, and maximum.",arearange:"Arearange charts are line charts displaying a range between a lower and higher value for each point.",areasplinerange:"These charts are line charts displaying a range between a lower and higher value for each point.",bubble:"Bubble charts are scatter charts where each data point also has a size value.",columnrange:"Columnrange charts are column charts displaying a range between a lower and higher value for each point.",errorbar:"Errorbar series are used to display the variability of the data.",funnel:"Funnel charts are used to display reduction of data in stages.",pyramid:"Pyramid charts consist of a single pyramid with item heights corresponding to each point value.",waterfall:"A waterfall chart is a column chart where each column contributes towards a total end value."},chartTypes:{emptyChart:"Empty chart",mapTypeDescription:"Map of {mapTitle} with {numSeries} data series.",unknownMap:"Map of unspecified region with {numSeries} data series.",combinationChart:"Combination chart with {numSeries} data series.",defaultSingle:"Chart with {numPoints} data {#plural(numPoints, points, point)}.",defaultMultiple:"Chart with {numSeries} data series.",splineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",splineMultiple:"Line chart with {numSeries} lines.",lineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",lineMultiple:"Line chart with {numSeries} lines.",columnSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",columnMultiple:"Bar chart with {numSeries} data series.",barSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",barMultiple:"Bar chart with {numSeries} data series.",pieSingle:"Pie chart with {numPoints} {#plural(numPoints, slices, slice)}.",pieMultiple:"Pie chart with {numSeries} pies.",scatterSingle:"Scatter chart with {numPoints} {#plural(numPoints, points, point)}.",scatterMultiple:"Scatter chart with {numSeries} data series.",boxplotSingle:"Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotMultiple:"Boxplot with {numSeries} data series.",bubbleSingle:"Bubble chart with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleMultiple:"Bubble chart with {numSeries} data series."},axis:{xAxisDescriptionSingular:"The chart has 1 X axis displaying {names[0]}. {ranges[0]}",xAxisDescriptionPlural:"The chart has {numAxes} X axes displaying {#each(names, -1) }and {names[-1]}.",yAxisDescriptionSingular:"The chart has 1 Y axis displaying {names[0]}. {ranges[0]}",yAxisDescriptionPlural:"The chart has {numAxes} Y axes displaying {#each(names, -1) }and {names[-1]}.",timeRangeDays:"Range: {range} days.",timeRangeHours:"Range: {range} hours.",timeRangeMinutes:"Range: {range} minutes.",timeRangeSeconds:"Range: {range} seconds.",rangeFromTo:"Range: {rangeFrom} to {rangeTo}.",rangeCategories:"Range: {numCategories} categories."},exporting:{chartMenuLabel:"Chart menu",menuButtonLabel:"View chart menu",exportRegionLabel:"Chart menu, {chartTitle}"},series:{summary:{default:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",defaultCombination:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",line:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",lineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",spline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",splineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",column:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",columnCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",bar:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",barCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",pie:"{name}, pie {ix} of {numSeries} with {numPoints} {#plural(numPoints, slices, slice)}.",pieCombination:"{name}, series {ix} of {numSeries}. Pie with {numPoints} {#plural(numPoints, slices, slice)}.",scatter:"{name}, scatter plot {ix} of {numSeries} with {numPoints} {#plural(numPoints, points, point)}.",scatterCombination:"{name}, series {ix} of {numSeries}, scatter plot with {numPoints} {#plural(numPoints, points, point)}.",boxplot:"{name}, boxplot {ix} of {numSeries} with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotCombination:"{name}, series {ix} of {numSeries}. Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",bubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}.",map:"{name}, map {ix} of {numSeries} with {numPoints} {#plural(numPoints, areas, area)}.",mapCombination:"{name}, series {ix} of {numSeries}. Map with {numPoints} {#plural(numPoints, areas, area)}.",mapline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",maplineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",mapbubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",mapbubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}."},description:"{description}",xAxisDescription:"X axis, {name}",yAxisDescription:"Y axis, {name}",nullPointValue:"No value",pointAnnotationsDescription:"{Annotation: #each(annotations). }"}}},error$3=Utilities.error,pick$Z=Utilities.pick;function traverseSetOption(z,y,a){for(var k=z,j,et=0;et<y.length-1;++et)j=y[et],k=k[j]=pick$Z(k[j],{});k[y[y.length-1]]=a}function deprecateFromOptionsMap(z,y,a,k){function j(nt,ot){return ot.reduce(function(at,lt){return at[lt]},nt)}var et=j(z.options,y),it=j(z.options,a);Object.keys(k).forEach(function(nt){var ot,at=et[nt];typeof at<"u"&&(traverseSetOption(it,k[nt],at),error$3(32,!1,z,(ot={},ot[y.join(".")+"."+nt]=a.join(".")+"."+k[nt].join("."),ot)))})}function copyDeprecatedChartOptions(z){var y=z.options.chart,a=z.options.accessibility||{};["description","typeDescription"].forEach(function(k){var j;y[k]&&(a[k]=y[k],error$3(32,!1,z,(j={},j["chart."+k]="use accessibility."+k,j)))})}function copyDeprecatedAxisOptions(z){z.axes.forEach(function(y){var a=y.options;a&&a.description&&(a.accessibility=a.accessibility||{},a.accessibility.description=a.description,error$3(32,!1,z,{"axis.description":"use axis.accessibility.description"}))})}function copyDeprecatedSeriesOptions(z){var y={description:["accessibility","description"],exposeElementToA11y:["accessibility","exposeAsGroupOnly"],pointDescriptionFormatter:["accessibility","pointDescriptionFormatter"],skipKeyboardNavigation:["accessibility","keyboardNavigation","enabled"]};z.series.forEach(function(a){Object.keys(y).forEach(function(k){var j,et=a.options[k];typeof et<"u"&&(traverseSetOption(a.options,y[k],k==="skipKeyboardNavigation"?!et:et),error$3(32,!1,z,(j={},j["series."+k]="series."+y[k].join("."),j)))})})}function copyDeprecatedTopLevelAccessibilityOptions(z){deprecateFromOptionsMap(z,["accessibility"],["accessibility"],{pointDateFormat:["point","dateFormat"],pointDateFormatter:["point","dateFormatter"],pointDescriptionFormatter:["point","descriptionFormatter"],pointDescriptionThreshold:["series","pointDescriptionEnabledThreshold"],pointNavigationThreshold:["keyboardNavigation","seriesNavigation","pointNavigationEnabledThreshold"],pointValueDecimals:["point","valueDecimals"],pointValuePrefix:["point","valuePrefix"],pointValueSuffix:["point","valueSuffix"],screenReaderSectionFormatter:["screenReaderSection","beforeChartFormatter"],describeSingleSeries:["series","describeSingleSeries"],seriesDescriptionFormatter:["series","descriptionFormatter"],onTableAnchorClick:["screenReaderSection","onViewDataTableClick"],axisRangeDateFormat:["screenReaderSection","axisRangeDateFormat"]})}function copyDeprecatedKeyboardNavigationOptions(z){deprecateFromOptionsMap(z,["accessibility","keyboardNavigation"],["accessibility","keyboardNavigation","seriesNavigation"],{skipNullPoints:["skipNullPoints"],mode:["mode"]})}function copyDeprecatedLangOptions(z){deprecateFromOptionsMap(z,["lang","accessibility"],["lang","accessibility"],{legendItem:["legend","legendItem"],legendLabel:["legend","legendLabel"],mapZoomIn:["zoom","mapZoomIn"],mapZoomOut:["zoom","mapZoomOut"],resetZoomButton:["zoom","resetZoomButton"],screenReaderRegionLabel:["screenReaderSection","beforeRegionLabel"],rangeSelectorButton:["rangeSelector","buttonText"],rangeSelectorMaxInput:["rangeSelector","maxInputLabel"],rangeSelectorMinInput:["rangeSelector","minInputLabel"],svgContainerEnd:["screenReaderSection","endOfChartMarker"],viewAsDataTable:["table","viewAsDataTableButtonText"],tableSummary:["table","tableSummary"]})}function copyDeprecatedOptions(z){copyDeprecatedChartOptions(z),copyDeprecatedAxisOptions(z),z.series&&copyDeprecatedSeriesOptions(z),copyDeprecatedTopLevelAccessibilityOptions(z),copyDeprecatedKeyboardNavigationOptions(z),copyDeprecatedLangOptions(z)}var format$4=FormatUtilities.format,pick$Y=Utilities.pick;function stringTrim$1(z){return z.trim&&z.trim()||z.replace(/^\s+|\s+$/g,"")}function formatExtendedStatement(z,y){var a=z.indexOf("#each("),k=z.indexOf("#plural("),j=z.indexOf("["),et=z.indexOf("]"),it,nt;if(a>-1){var ot=z.slice(a).indexOf(")")+a,at=z.substring(0,a),lt=z.substring(ot+1),ct=z.substring(a+6,ot),ht=ct.split(","),ut=Number(ht[1]),ft=void 0;if(nt="",it=y[ht[0]],it){ut=isNaN(ut)?it.length:ut,ft=ut<0?it.length+ut:Math.min(ut,it.length);for(var vt=0;vt<ft;++vt)nt+=at+it[vt]+lt}return nt.length?nt:""}if(k>-1){var gt=z.slice(k).indexOf(")")+k,mt=z.substring(k+8,gt),bt=mt.split(","),xt=Number(y[bt[0]]);switch(xt){case 0:nt=pick$Y(bt[4],bt[1]);break;case 1:nt=pick$Y(bt[2],bt[1]);break;case 2:nt=pick$Y(bt[3],bt[1]);break;default:nt=bt[1]}return nt?stringTrim$1(nt):""}if(j>-1){var wt=z.substring(0,j),Mt=Number(z.substring(j+1,et)),Et=void 0;return it=y[wt],!isNaN(Mt)&&it&&(Mt<0?(Et=it[it.length+Mt],typeof Et>"u"&&(Et=it[0])):(Et=it[Mt],typeof Et>"u"&&(Et=it[it.length-1]))),typeof Et<"u"?Et:""}return"{"+z+"}"}H.i18nFormat=function(z,y,a){var k=function(ot,at){var lt=ot.slice(at||0),ct=lt.indexOf("{"),ht=lt.indexOf("}");if(ct>-1&&ht>ct)return{statement:lt.substring(ct+1,ht),begin:at+ct+1,end:at+ht}},j=[],et,it,nt=0;do et=k(z,nt),it=z.substring(nt,et&&et.begin-1),it.length&&j.push({value:it,type:"constant"}),et&&j.push({value:et.statement,type:"statement"}),nt=et?et.end+1:nt+1;while(et);return j.forEach(function(ot){ot.type==="statement"&&(ot.value=formatExtendedStatement(ot.value,y))}),format$4(j.reduce(function(ot,at){return ot+at.value},""),y,a)};Chart$1.prototype.langFormat=function(z,y){for(var a=z.split("."),k=this.options.lang,j=0;j<a.length;++j)k=k&&k[a[j]];return typeof k=="string"?H.i18nFormat(k,y,this):""};var addEvent$E=Utilities.addEvent,extend$U=Utilities.extend,pick$X=Utilities.pick,svgElementBorderUpdateTriggers=["x","y","transform","width","height","r","d","stroke-width"];function addDestroyFocusBorderHook(z){if(!z.focusBorderDestroyHook){var y=z.destroy;z.destroy=function(){return z.focusBorder&&z.focusBorder.destroy&&z.focusBorder.destroy(),y.apply(z,arguments)},z.focusBorderDestroyHook=y}}function removeDestroyFocusBorderHook(z){z.focusBorderDestroyHook&&(z.destroy=z.focusBorderDestroyHook,delete z.focusBorderDestroyHook)}function addUpdateFocusBorderHooks(z){for(var y=[],a=1;a<arguments.length;a++)y[a-1]=arguments[a];z.focusBorderUpdateHooks||(z.focusBorderUpdateHooks={},svgElementBorderUpdateTriggers.forEach(function(k){var j=k+"Setter",et=z[j]||z._defaultSetter;z.focusBorderUpdateHooks[j]=et,z[j]=function(){var it=et.apply(z,arguments);return z.addFocusBorder.apply(z,y),it}}))}function removeUpdateFocusBorderHooks(z){z.focusBorderUpdateHooks&&(Object.keys(z.focusBorderUpdateHooks).forEach(function(y){var a=z.focusBorderUpdateHooks[y];a===z._defaultSetter?delete z[y]:z[y]=a}),delete z.focusBorderUpdateHooks)}extend$U(SVGElement.prototype,{addFocusBorder:function(z,y){this.focusBorder&&this.removeFocusBorder();var a=this.getBBox(),k=pick$X(z,3);a.x+=this.translateX?this.translateX:0,a.y+=this.translateY?this.translateY:0;var j=a.x-k,et=a.y-k,it=a.width+2*k,nt=a.height+2*k;function ot(vt){var gt=0,mt=0;return vt.attr("text-anchor")==="middle"?gt=mt=.5:vt.rotation?gt=.25:mt=.75,{x:gt,y:mt}}var at=this instanceof SVGLabel;if(this.element.nodeName==="text"||at){var lt=!!this.rotation,ct=at?{x:lt?1:0,y:0}:ot(this),ht=+this.attr("x"),ut=+this.attr("y");if(isNaN(ht)||(j=ht-a.width*ct.x-k),isNaN(ut)||(et=ut-a.height*ct.y-k),at&&lt){var ft=it;it=nt,nt=ft,isNaN(ht)||(j=ht-a.height*ct.x-k),isNaN(ut)||(et=ut-a.width*ct.y-k)}}this.focusBorder=this.renderer.rect(j,et,it,nt,parseInt((y&&y.r||0).toString(),10)).addClass("highcharts-focus-border").attr({zIndex:99}).add(this.parentGroup),this.renderer.styledMode||this.focusBorder.attr({stroke:y&&y.stroke,"stroke-width":y&&y.strokeWidth}),addUpdateFocusBorderHooks(this,z,y),addDestroyFocusBorderHook(this)},removeFocusBorder:function(){removeUpdateFocusBorderHooks(this),removeDestroyFocusBorderHook(this),this.focusBorder&&(this.focusBorder.destroy(),delete this.focusBorder)}});Chart$1.prototype.renderFocusBorder=function(){var z=this.focusElement,y=this.options.accessibility.keyboardNavigation.focusBorder;z&&(z.removeFocusBorder(),y.enabled&&z.addFocusBorder(y.margin,{stroke:y.style.color,strokeWidth:y.style.lineWidth,r:y.style.borderRadius}))};Chart$1.prototype.setFocusToElement=function(z,y){var a=this.options.accessibility.keyboardNavigation.focusBorder,k=y||z.element;k&&k.focus&&(k.hcEvents&&k.hcEvents.focusin||addEvent$E(k,"focusin",function(){}),k.focus(),a.hideBrowserFocusOutline&&(k.style.outline="none")),this.focusElement&&this.focusElement.removeFocusBorder(),this.focusElement=z,this.renderFocusBorder()};var doc$5=H.doc,defaultOptions$8=DefaultOptions.defaultOptions,addEvent$D=Utilities.addEvent,extend$T=Utilities.extend,fireEvent$e=Utilities.fireEvent,merge$T=Utilities.merge;merge$T(!0,defaultOptions$8,Options,{accessibility:{highContrastTheme:theme},lang:langOptions});H.A11yChartUtilities=ChartUtilities;H.A11yHTMLUtilities=HTMLUtilities;H.KeyboardNavigationHandler=KeyboardNavigationHandler;H.AccessibilityComponent=AccessibilityComponent;function Accessibility(z){this.init(z)}Accessibility.prototype={init:function(z){if(this.chart=z,!doc$5.addEventListener||!z.renderer.isSVG){z.renderTo.setAttribute("aria-hidden",!0);return}copyDeprecatedOptions(z),this.initComponents(),this.keyboardNavigation=new KeyboardNavigation(z,this.components),this.update()},initComponents:function(){var z=this.chart,y=z.options.accessibility;this.components={container:new ContainerComponent,infoRegions:new InfoRegionsComponent,legend:new LegendComponent,chartMenu:new MenuComponent,rangeSelector:new RangeSelectorComponent,series:new SeriesComponent,zoom:new ZoomComponent},y.customComponents&&extend$T(this.components,y.customComponents);var a=this.components;this.getComponentOrder().forEach(function(k){a[k].initBase(z),a[k].init()})},getComponentOrder:function(){if(!this.components)return[];if(!this.components.series)return Object.keys(this.components);var z=Object.keys(this.components).filter(function(y){return y!=="series"});return["series"].concat(z)},update:function(){var z=this.components,y=this.chart,a=y.options.accessibility;fireEvent$e(y,"beforeA11yUpdate"),y.types=this.getChartTypes(),this.getComponentOrder().forEach(function(k){z[k].onChartUpdate(),fireEvent$e(y,"afterA11yComponentUpdate",{name:k,component:z[k]})}),this.keyboardNavigation.update(a.keyboardNavigation.order),!y.highContrastModeActive&&whcm.isHighContrastModeActive()&&whcm.setHighContrastTheme(y),fireEvent$e(y,"afterA11yUpdate",{accessibility:this})},destroy:function(){var z=this.chart||{},y=this.components;Object.keys(y).forEach(function(a){y[a].destroy(),y[a].destroyBase()}),this.keyboardNavigation&&this.keyboardNavigation.destroy(),z.renderTo&&z.renderTo.setAttribute("aria-hidden",!0),z.focusElement&&z.focusElement.removeFocusBorder()},getChartTypes:function(){var z={};return this.chart.series.forEach(function(y){z[y.type]=1}),Object.keys(z)}};Chart$1.prototype.updateA11yEnabled=function(){var z=this.accessibility,y=this.options.accessibility;y&&y.enabled?z?z.update():this.accessibility=z=new Accessibility(this):z?(z.destroy&&z.destroy(),delete this.accessibility):this.renderTo.setAttribute("aria-hidden",!0)};addEvent$D(Chart$1,"render",function(z){this.a11yDirty&&this.renderTo&&(delete this.a11yDirty,this.updateA11yEnabled());var y=this.accessibility;y&&y.getComponentOrder().forEach(function(a){y.components[a].onChartRender()})});addEvent$D(Chart$1,"update",function(z){var y=z.options.accessibility;y&&(y.customComponents&&(this.options.accessibility.customComponents=y.customComponents,delete y.customComponents),merge$T(!0,this.options.accessibility,y),this.accessibility&&this.accessibility.destroy&&(this.accessibility.destroy(),delete this.accessibility)),this.a11yDirty=!0});addEvent$D(Point$4,"update",function(){this.series.chart.accessibility&&(this.series.chart.a11yDirty=!0)});["addSeries","init"].forEach(function(z){addEvent$D(Chart$1,z,function(){this.a11yDirty=!0})});["update","updatedData","remove"].forEach(function(z){addEvent$D(Series$f,z,function(){this.chart.accessibility&&(this.chart.a11yDirty=!0)})});["afterDrilldown","drillupall"].forEach(function(z){addEvent$D(Chart$1,z,function(){this.accessibility&&this.accessibility.update()})});addEvent$D(Chart$1,"destroy",function(){this.accessibility&&this.accessibility.destroy()});var addEvent$C=Utilities.addEvent,fireEvent$d=Utilities.fireEvent,objectEach$e=Utilities.objectEach,pick$W=Utilities.pick,removeEvent$2=Utilities.removeEvent,eventEmitterMixin={addEvents:function(){var z=this,y=function(k){addEvent$C(k,H.isTouchDevice?"touchstart":"mousedown",function(j){z.onMouseDown(j)},{passive:!1})};if(y(this.graphic.element),(z.labels||[]).forEach(function(k){k.options.useHTML&&k.graphic.text&&y(k.graphic.text.element)}),objectEach$e(z.options.events,function(k,j){var et=function(it){(j!=="click"||!z.cancelClick)&&k.call(z,z.chart.pointer.normalize(it),z.target)};(z.nonDOMEvents||[]).indexOf(j)===-1?z.graphic.on(j,et):addEvent$C(z,j,et,{passive:!1})}),z.options.draggable&&(addEvent$C(z,"drag",z.onDrag),!z.graphic.renderer.styledMode)){var a={cursor:{x:"ew-resize",y:"ns-resize",xy:"move"}[z.options.draggable]};z.graphic.css(a),(z.labels||[]).forEach(function(k){k.options.useHTML&&k.graphic.text&&k.graphic.text.css(a)})}z.isUpdating||fireEvent$d(z,"add")},removeDocEvents:function(){this.removeDrag&&(this.removeDrag=this.removeDrag()),this.removeMouseUp&&(this.removeMouseUp=this.removeMouseUp())},onMouseDown:function(z){var y=this,a=y.chart.pointer,k,j;z.preventDefault&&z.preventDefault(),z.button!==2&&(z=a.normalize(z),k=z.chartX,j=z.chartY,y.cancelClick=!1,y.chart.hasDraggedAnnotation=!0,y.removeDrag=addEvent$C(H.doc,H.isTouchDevice?"touchmove":"mousemove",function(et){y.hasDragged=!0,et=a.normalize(et),et.prevChartX=k,et.prevChartY=j,fireEvent$d(y,"drag",et),k=et.chartX,j=et.chartY},H.isTouchDevice?{passive:!1}:void 0),y.removeMouseUp=addEvent$C(H.doc,H.isTouchDevice?"touchend":"mouseup",function(et){var it=pick$W(y.target&&y.target.annotation,y.target);it&&(it.cancelClick=y.hasDragged),y.cancelClick=y.hasDragged,y.hasDragged=!1,y.chart.hasDraggedAnnotation=!1,fireEvent$d(pick$W(it,y),"afterUpdate"),y.onMouseUp(et)},H.isTouchDevice?{passive:!1}:void 0))},onMouseUp:function(z){var y=this.chart,a=this.target||this,k=y.options.annotations,j=y.annotations.indexOf(a);this.removeDocEvents(),k[j]=a.options},onDrag:function(z){if(this.chart.isInsidePlot(z.chartX-this.chart.plotLeft,z.chartY-this.chart.plotTop,{visiblePlotOnly:!0})){var y=this.mouseMoveToTranslation(z);this.options.draggable==="x"&&(y.y=0),this.options.draggable==="y"&&(y.x=0),this.points.length?this.translate(y.x,y.y):(this.shapes.forEach(function(a){a.translate(y.x,y.y)}),this.labels.forEach(function(a){a.translate(y.x,y.y)})),this.redraw(!1)}},mouseMoveToRadians:function(z,y,a){var k=z.prevChartY-a,j=z.prevChartX-y,et=z.chartY-a,it=z.chartX-y,nt;return this.chart.inverted&&(nt=j,j=k,k=nt,nt=it,it=et,et=nt),Math.atan2(et,it)-Math.atan2(k,j)},mouseMoveToTranslation:function(z){var y=z.chartX-z.prevChartX,a=z.chartY-z.prevChartY,k;return this.chart.inverted&&(k=a,a=y,y=k),{x:y,y:a}},mouseMoveToScale:function(z,y,a){var k=z.prevChartX-y,j=z.prevChartY-a,et=z.chartX-y,it=z.chartY-a,nt=(et||1)/(k||1),ot=(it||1)/(j||1),at;return this.chart.inverted&&(at=ot,ot=nt,nt=at),{x:nt,y:ot}},destroy:function(){this.removeDocEvents(),removeEvent$2(this),this.hcEvents=null}},merge$S=Utilities.merge,pick$V=Utilities.pick,ControlPoint=(function(){function z(y,a,k,j){this.addEvents=eventEmitterMixin.addEvents,this.graphic=void 0,this.mouseMoveToRadians=eventEmitterMixin.mouseMoveToRadians,this.mouseMoveToScale=eventEmitterMixin.mouseMoveToScale,this.mouseMoveToTranslation=eventEmitterMixin.mouseMoveToTranslation,this.onDrag=eventEmitterMixin.onDrag,this.onMouseDown=eventEmitterMixin.onMouseDown,this.onMouseUp=eventEmitterMixin.onMouseUp,this.removeDocEvents=eventEmitterMixin.removeDocEvents,this.nonDOMEvents=["drag"],this.chart=y,this.target=a,this.options=k,this.index=pick$V(k.index,j)}return z.prototype.setVisibility=function(y){this.graphic.attr("visibility",y?"visible":"hidden"),this.options.visible=y},z.prototype.render=function(){var y=this.chart,a=this.options;this.graphic=y.renderer.symbol(a.symbol,0,0,a.width,a.height).add(y.controlPointsGroup).css(a.style),this.setVisibility(a.visible),this.addEvents()},z.prototype.redraw=function(y){this.graphic[y?"animate":"attr"](this.options.positioner.call(this,this.target))},z.prototype.destroy=function(){eventEmitterMixin.destroy.call(this),this.graphic&&(this.graphic=this.graphic.destroy()),this.chart=null,this.target=null,this.options=null},z.prototype.update=function(y){var a=this.chart,k=this.target,j=this.index,et=merge$S(!0,this.options,y);this.destroy(),this.constructor(a,k,et,j),this.render(a.controlPointsGroup),this.redraw()},z})(),defined$p=Utilities.defined,fireEvent$c=Utilities.fireEvent,MockPoint=(function(){function z(y,a,k){this.isInside=void 0,this.negative=void 0,this.plotX=void 0,this.plotY=void 0,this.ttBelow=void 0,this.x=void 0,this.y=void 0,this.mock=!0,this.series={visible:!0,chart:y,getPlotBox:Series$f.prototype.getPlotBox},this.target=a||null,this.options=k,this.applyOptions(this.getOptions())}return z.fromPoint=function(y){return new z(y.series.chart,null,{x:y.x,y:y.y,xAxis:y.series.xAxis,yAxis:y.series.yAxis})},z.pointToPixels=function(y,a){var k=y.series,j=k.chart,et=y.plotX,it=y.plotY,nt;return j.inverted&&(y.mock?(et=y.plotY,it=y.plotX):(et=j.plotWidth-y.plotY,it=j.plotHeight-y.plotX)),k&&!a&&(nt=k.getPlotBox(),et+=nt.translateX,it+=nt.translateY),{x:et,y:it}},z.pointToOptions=function(y){return{x:y.x,y:y.y,xAxis:y.series.xAxis,yAxis:y.series.yAxis}},z.prototype.hasDynamicOptions=function(){return typeof this.options=="function"},z.prototype.getOptions=function(){return this.hasDynamicOptions()?this.options(this.target):this.options},z.prototype.applyOptions=function(y){this.command=y.command,this.setAxis(y,"x"),this.setAxis(y,"y"),this.refresh()},z.prototype.setAxis=function(y,a){var k=a+"Axis",j=y[k],et=this.series.chart;this.series[k]=j instanceof Axis?j:defined$p(j)?et[k][j]||et.get(j):null},z.prototype.toAnchor=function(){var y=[this.plotX,this.plotY,0,0];return this.series.chart.inverted&&(y[0]=this.plotY,y[1]=this.plotX),y},z.prototype.getLabelConfig=function(){return{x:this.x,y:this.y,point:this}},z.prototype.isInsidePlot=function(){var y=this.plotX,a=this.plotY,k=this.series.xAxis,j=this.series.yAxis,et={x:y,y:a,isInsidePlot:!0};return k&&(et.isInsidePlot=defined$p(y)&&y>=0&&y<=k.len),j&&(et.isInsidePlot=et.isInsidePlot&&defined$p(a)&&a>=0&&a<=j.len),fireEvent$c(this.series.chart,"afterIsInsidePlot",et),et.isInsidePlot},z.prototype.refresh=function(){var y=this.series,a=y.xAxis,k=y.yAxis,j=this.getOptions();a?(this.x=j.x,this.plotX=a.toPixels(j.x,!0)):(this.x=null,this.plotX=j.x),k?(this.y=j.y,this.plotY=k.toPixels(j.y,!0)):(this.y=null,this.plotY=j.y),this.isInside=this.isInsidePlot()},z.prototype.translate=function(y,a,k,j){this.hasDynamicOptions()||(this.plotX+=k,this.plotY+=j,this.refreshOptions())},z.prototype.scale=function(y,a,k,j){if(!this.hasDynamicOptions()){var et=this.plotX*k,it=this.plotY*j,nt=(1-k)*y,ot=(1-j)*a;this.plotX=nt+et,this.plotY=ot+it,this.refreshOptions()}},z.prototype.rotate=function(y,a,k){if(!this.hasDynamicOptions()){var j=Math.cos(k),et=Math.sin(k),it=this.plotX,nt=this.plotY,ot=void 0,at=void 0;it-=y,nt-=a,ot=it*j-nt*et,at=it*et+nt*j,this.plotX=ot+y,this.plotY=at+a,this.refreshOptions()}},z.prototype.refreshOptions=function(){var y=this.series,a=y.xAxis,k=y.yAxis;this.x=this.options.x=a?this.options.x=a.toValue(this.plotX,!0):this.plotX,this.y=this.options.y=k?k.toValue(this.plotY,!0):this.plotY},z})(),isObject$a=Utilities.isObject,isString$3=Utilities.isString,merge$R=Utilities.merge,splat$8=Utilities.splat,controllableMixin={init:function(z,y,a){this.annotation=z,this.chart=z.chart,this.options=y,this.points=[],this.controlPoints=[],this.index=a,this.linkPoints(),this.addControlPoints()},attr:function(){this.graphic.attr.apply(this.graphic,arguments)},getPointsOptions:function(){var z=this.options;return z.points||z.point&&splat$8(z.point)},attrsFromOptions:function(z){var y=this.constructor.attrsMap,a={},k,j,et=this.chart.styledMode;for(k in z)j=y[k],j&&(!et||["fill","stroke","stroke-width"].indexOf(j)===-1)&&(a[j]=z[k]);return a},anchor:function(z){var y=z.series.getPlotBox(),a=z.series.chart,k=z.mock?z.toAnchor():Tooltip.prototype.getAnchor.call({chart:z.series.chart},z),j={x:k[0]+(this.options.x||0),y:k[1]+(this.options.y||0),height:k[2]||0,width:k[3]||0};return{relativePosition:j,absolutePosition:merge$R(j,{x:j.x+(z.mock?y.translateX:a.plotLeft),y:j.y+(z.mock?y.translateY:a.plotTop)})}},point:function(z,y){if(z&&z.series)return z;if(!y||y.series===null){if(isObject$a(z))y=new MockPoint(this.chart,this,z);else if(isString$3(z))y=this.chart.get(z)||null;else if(typeof z=="function"){var a=z.call(y,this);y=a.series?a:new MockPoint(this.chart,this,z)}}return y},linkPoints:function(){var z=this.getPointsOptions(),y=this.points,a=z&&z.length||0,k,j;for(k=0;k<a;k++){if(j=this.point(z[k],y[k]),!j){y.length=0;return}j.mock&&j.refresh(),y[k]=j}return y},addControlPoints:function(){var z=this.options.controlPoints;(z||[]).forEach(function(y,a){var k=merge$R(this.options.controlPointOptions,y);k.index||(k.index=a),z[a]=k,this.controlPoints.push(new ControlPoint(this.chart,this,k))},this)},shouldBeDrawn:function(){return!!this.points.length},render:function(z){this.controlPoints.forEach(function(y){y.render()})},redraw:function(z){this.controlPoints.forEach(function(y){y.redraw(z)})},transform:function(z,y,a,k,j){if(this.chart.inverted){var et=y;y=a,a=et}this.points.forEach(function(it,nt){this.transformPoint(z,y,a,k,j,nt)},this)},transformPoint:function(z,y,a,k,j,et){var it=this.points[et];it.mock||(it=this.points[et]=MockPoint.fromPoint(it)),it[z](y,a,k,j)},translate:function(z,y){this.transform("translate",null,null,z,y)},translatePoint:function(z,y,a){this.transformPoint("translate",null,null,z,y,a)},translateShape:function(z,y){var a=this.annotation.chart,k=this.annotation.userOptions,j=a.annotations.indexOf(this.annotation),et=a.options.annotations[j];this.translatePoint(z,y,0),et[this.collection][this.index].point=this.options.point,k[this.collection][this.index].point=this.options.point},rotate:function(z,y,a){this.transform("rotate",z,y,a)},scale:function(z,y,a,k){this.transform("scale",z,y,a,k)},setControlPointsVisibility:function(z){this.controlPoints.forEach(function(y){y.setVisibility(z)})},destroy:function(){this.graphic&&(this.graphic=this.graphic.destroy()),this.tracker&&(this.tracker=this.tracker.destroy()),this.controlPoints.forEach(function(z){z.destroy()}),this.chart=null,this.points=null,this.controlPoints=null,this.options=null,this.annotation&&(this.annotation=null)},update:function(z){var y=this.annotation,a=merge$R(!0,this.options,z),k=this.graphic.parentGroup;this.destroy(),this.constructor(y,a,this.index),this.render(k),this.redraw()}},addEvent$B=Utilities.addEvent,defined$o=Utilities.defined,merge$Q=Utilities.merge,uniqueKey$2=Utilities.uniqueKey,defaultMarkers={arrow:{tagName:"marker",attributes:{id:"arrow",refY:5,refX:9,markerWidth:10,markerHeight:10},children:[{tagName:"path",attributes:{d:"M 0 0 L 10 5 L 0 10 Z","stroke-width":0}}]},"reverse-arrow":{tagName:"marker",attributes:{id:"reverse-arrow",refY:5,refX:1,markerWidth:10,markerHeight:10},children:[{tagName:"path",attributes:{d:"M 0 5 L 10 0 L 10 10 Z","stroke-width":0}}]}};SVGRenderer.prototype.addMarker=function(z,y){var a={attributes:{id:z}},k={stroke:y.color||"none",fill:y.color||"rgba(0, 0, 0, 0.75)"};a.children=y.children&&y.children.map(function(it){return merge$Q(k,it)});var j=merge$Q(!0,{attributes:{markerWidth:20,markerHeight:20,refX:0,refY:0,orient:"auto"}},y,a),et=this.definition(j);return et.id=z,et};function createMarkerSetter(z){return function(y){this.attr(z,"url(#"+y+")")}}var markerMixin={markerEndSetter:createMarkerSetter("marker-end"),markerStartSetter:createMarkerSetter("marker-start"),setItemMarkers:function(z){var y=z.options,a=z.chart,k=a.options.defs,j=y.fill,et=defined$o(j)&&j!=="none"?j:y.stroke,it=function(nt){var ot=y[nt],at,lt,ct,ht;if(ot){for(ct in k)if(at=k[ct],(ot===(at.attributes&&at.attributes.id)||ot===at.id)&&at.tagName==="marker"){lt=at;break}lt&&(ht=z[nt]=a.renderer.addMarker((y.id||uniqueKey$2())+"-"+ot,merge$Q(lt,{color:et})),z.attr(nt,ht.getAttribute("id")))}};["markerStart","markerEnd"].forEach(it)}};addEvent$B(Chart$1,"afterGetContainer",function(){this.options.defs=merge$Q(defaultMarkers,this.options.defs||{})});var extend$S=Utilities.extend,TRACKER_FILL="rgba(192,192,192,"+(H.svg?1e-4:.002)+")",ControllablePath=(function(){function z(y,a,k){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.setMarkers=markerMixin.setItemMarkers,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translate=controllableMixin.translate,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="path",this.init(y,a,k),this.collection="shapes"}return z.prototype.toD=function(){var y=this.options.d;if(y)return typeof y=="function"?y.call(this):y;var a=this.points,k=a.length,j=k,et=a[0],it=j&&this.anchor(et).absolutePosition,nt=0,ot,at=[];if(it)for(at.push(["M",it.x,it.y]);++nt<k&&j;)et=a[nt],ot=et.command||"L",it=this.anchor(et).absolutePosition,ot==="M"?at.push([ot,it.x,it.y]):ot==="L"?at.push([ot,it.x,it.y]):ot==="Z"&&at.push([ot]),j=et.series.visible;return j?this.chart.renderer.crispLine(at,this.graphic.strokeWidth()):null},z.prototype.shouldBeDrawn=function(){return controllableMixin.shouldBeDrawn.call(this)||!!this.options.d},z.prototype.render=function(y){var a=this.options,k=this.attrsFromOptions(a);this.graphic=this.annotation.chart.renderer.path([["M",0,0]]).attr(k).add(y),a.className&&this.graphic.addClass(a.className),this.tracker=this.annotation.chart.renderer.path([["M",0,0]]).addClass("highcharts-tracker-line").attr({zIndex:2}).add(y),this.annotation.chart.styledMode||this.tracker.attr({"stroke-linejoin":"round",stroke:TRACKER_FILL,fill:TRACKER_FILL,"stroke-width":this.graphic.strokeWidth()+a.snap*2}),controllableMixin.render.call(this),extend$S(this.graphic,{markerStartSetter:markerMixin.markerStartSetter,markerEndSetter:markerMixin.markerEndSetter}),this.setMarkers(this)},z.prototype.redraw=function(y){var a=this.toD(),k=y?"animate":"attr";a?(this.graphic[k]({d:a}),this.tracker[k]({d:a})):(this.graphic.attr({d:"M 0 "+-9e9}),this.tracker.attr({d:"M 0 "+-9e9})),this.graphic.placed=this.tracker.placed=!!a,controllableMixin.redraw.call(this,y)},z.attrsMap={dashStyle:"dashstyle",strokeWidth:"stroke-width",stroke:"stroke",fill:"fill",zIndex:"zIndex"},z})(),merge$P=Utilities.merge,ControllableRect=(function(){function z(y,a,k){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="rect",this.translate=controllableMixin.translateShape,this.init(y,a,k),this.collection="shapes"}return z.prototype.render=function(y){var a=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.rect(0,-9e9,0,0).attr(a).add(y),controllableMixin.render.call(this)},z.prototype.redraw=function(y){var a=this.anchor(this.points[0]).absolutePosition;a?this.graphic[y?"animate":"attr"]({x:a.x,y:a.y,width:this.options.width,height:this.options.height}):this.attr({x:0,y:-9e9}),this.graphic.placed=!!a,controllableMixin.redraw.call(this,y)},z.attrsMap=merge$P(ControllablePath.attrsMap,{width:"width",height:"height"}),z})(),merge$O=Utilities.merge,ControllableCircle=(function(){function z(y,a,k){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="circle",this.translate=controllableMixin.translateShape,this.init(y,a,k),this.collection="shapes"}return z.prototype.render=function(y){var a=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.circle(0,-9e9,0).attr(a).add(y),controllableMixin.render.call(this)},z.prototype.redraw=function(y){var a=this.anchor(this.points[0]).absolutePosition;a?this.graphic[y?"animate":"attr"]({x:a.x,y:a.y,r:this.options.r}):this.graphic.attr({x:0,y:-9e9}),this.graphic.placed=!!a,controllableMixin.redraw.call(this,y)},z.prototype.setRadius=function(y){this.options.r=y},z.attrsMap=merge$O(ControllablePath.attrsMap,{r:"r"}),z})(),format$3=FormatUtilities.format,symbols$3=SVGRenderer.prototype.symbols,extend$R=Utilities.extend,isNumber$q=Utilities.isNumber,pick$U=Utilities.pick,ControllableLabel=(function(){function z(y,a,k){this.addControlPoints=controllableMixin.addControlPoints,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.init(y,a,k),this.collection="labels"}return z.alignedPosition=function(y,a){var k=y.align,j=y.verticalAlign,et=(a.x||0)+(y.x||0),it=(a.y||0)+(y.y||0),nt,ot;return k==="right"?nt=1:k==="center"&&(nt=2),nt&&(et+=(a.width-(y.width||0))/nt),j==="bottom"?ot=1:j==="middle"&&(ot=2),ot&&(it+=(a.height-(y.height||0))/ot),{x:Math.round(et),y:Math.round(it)}},z.justifiedOptions=function(y,a,k,j){var et=k.align,it=k.verticalAlign,nt=a.box?0:a.padding||0,ot=a.getBBox(),at={align:et,verticalAlign:it,x:k.x,y:k.y,width:a.width,height:a.height},lt=(j.x||0)-y.plotLeft,ct=(j.y||0)-y.plotTop,ht;return ht=lt+nt,ht<0&&(et==="right"?at.align="left":at.x=(at.x||0)-ht),ht=lt+ot.width-nt,ht>y.plotWidth&&(et==="left"?at.align="right":at.x=(at.x||0)+y.plotWidth-ht),ht=ct+nt,ht<0&&(it==="bottom"?at.verticalAlign="top":at.y=(at.y||0)-ht),ht=ct+ot.height-nt,ht>y.plotHeight&&(it==="top"?at.verticalAlign="bottom":at.y=(at.y||0)+y.plotHeight-ht),at},z.prototype.translatePoint=function(y,a){controllableMixin.translatePoint.call(this,y,a,0)},z.prototype.translate=function(y,a){var k=this.annotation.chart,j=this.annotation.userOptions,et=k.annotations.indexOf(this.annotation),it=k.options.annotations,nt=it[et];if(k.inverted){var ot=y;y=a,a=ot}this.options.x+=y,this.options.y+=a,nt[this.collection][this.index].x=this.options.x,nt[this.collection][this.index].y=this.options.y,j[this.collection][this.index].x=this.options.x,j[this.collection][this.index].y=this.options.y},z.prototype.render=function(y){var a=this.options,k=this.attrsFromOptions(a),j=a.style;this.graphic=this.annotation.chart.renderer.label("",0,-9999,a.shape,null,null,a.useHTML,null,"annotation-label").attr(k).add(y),this.annotation.chart.styledMode||(j.color==="contrast"&&(j.color=this.annotation.chart.renderer.getContrast(z.shapesWithoutBackground.indexOf(a.shape)>-1?"#FFFFFF":a.backgroundColor)),this.graphic.css(a.style).shadow(a.shadow)),a.className&&this.graphic.addClass(a.className),this.graphic.labelrank=a.labelrank,controllableMixin.render.call(this)},z.prototype.redraw=function(y){var a=this.options,k=this.text||a.format||a.text,j=this.graphic,et=this.points[0];j.attr({text:k?format$3(k,et.getLabelConfig(),this.annotation.chart):a.formatter.call(et,this)});var it=this.anchor(et),nt=this.position(it);nt?(j.alignAttr=nt,nt.anchorX=it.absolutePosition.x,nt.anchorY=it.absolutePosition.y,j[y?"animate":"attr"](nt)):j.attr({x:0,y:-9999}),j.placed=!!nt,controllableMixin.redraw.call(this,y)},z.prototype.anchor=function(y){var a=controllableMixin.anchor.apply(this,arguments),k=this.options.x||0,j=this.options.y||0;return a.absolutePosition.x-=k,a.absolutePosition.y-=j,a.relativePosition.x-=k,a.relativePosition.y-=j,a},z.prototype.position=function(y){var a=this.graphic,k=this.annotation.chart,j=this.points[0],et=this.options,it=y.absolutePosition,nt=y.relativePosition,ot,at,lt,ct,ht=j.series.visible&&MockPoint.prototype.isInsidePlot.call(j),ut=a.width,ft=ut===void 0?0:ut,vt=a.height,gt=vt===void 0?0:vt;return ht&&(et.distance?ot=Tooltip.prototype.getPosition.call({chart:k,distance:pick$U(et.distance,16)},ft,gt,{plotX:nt.x,plotY:nt.y,negative:j.negative,ttBelow:j.ttBelow,h:nt.height||nt.width}):et.positioner?ot=et.positioner.call(this):(at={x:it.x,y:it.y,width:0,height:0},ot=z.alignedPosition(extend$R(et,{width:ft,height:gt}),at),this.options.overflow==="justify"&&(ot=z.alignedPosition(z.justifiedOptions(k,a,et,ot),at))),et.crop&&(lt=ot.x-k.plotLeft,ct=ot.y-k.plotTop,ht=k.isInsidePlot(lt,ct)&&k.isInsidePlot(lt+ft,ct+gt))),ht?ot:null},z.attrsMap={backgroundColor:"fill",borderColor:"stroke",borderWidth:"stroke-width",zIndex:"zIndex",borderRadius:"r",padding:"padding"},z.shapesWithoutBackground=["connector"],z})();symbols$3.connector=function(z,y,a,k,j){var et=j&&j.anchorX,it=j&&j.anchorY,nt,ot,at=a/2;return isNumber$q(et)&&isNumber$q(it)&&(nt=[["M",et,it]],ot=y-it,ot<0&&(ot=-k-ot),ot<a&&(at=et<z+a/2?ot:a-ot),it>y+k?nt.push(["L",z+at,y+k]):it<y?nt.push(["L",z+at,y]):et<z?nt.push(["L",z,y+k/2]):et>z+a&&nt.push(["L",z+a,y+k/2])),nt||[]};var ControllableImage=(function(){function z(y,a,k){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="image",this.translate=controllableMixin.translateShape,this.init(y,a,k),this.collection="shapes"}return z.prototype.render=function(y){var a=this.attrsFromOptions(this.options),k=this.options;this.graphic=this.annotation.chart.renderer.image(k.src,0,-9e9,k.width,k.height).attr(a).add(y),this.graphic.width=k.width,this.graphic.height=k.height,controllableMixin.render.call(this)},z.prototype.redraw=function(y){var a=this.anchor(this.points[0]),k=ControllableLabel.prototype.position.call(this,a);k?this.graphic[y?"animate":"attr"]({x:k.x,y:k.y}):this.graphic.attr({x:0,y:-9e9}),this.graphic.placed=!!k,controllableMixin.redraw.call(this,y)},z.attrsMap={width:"width",height:"height",zIndex:"zIndex"},z})(),getDeferredAnimation=animationExports.getDeferredAnimation,chartProto=Chart$1.prototype,addEvent$A=Utilities.addEvent,defined$n=Utilities.defined,destroyObjectProperties=Utilities.destroyObjectProperties,erase$1=Utilities.erase,extend$Q=Utilities.extend,find$7=Utilities.find,fireEvent$b=Utilities.fireEvent,merge$N=Utilities.merge,pick$T=Utilities.pick,splat$7=Utilities.splat,wrap$e=Utilities.wrap,Annotation=(function(){function z(y,a){this.annotation=void 0,this.coll="annotations",this.collection=void 0,this.animationConfig=void 0,this.graphic=void 0,this.group=void 0,this.labelCollector=void 0,this.labelsGroup=void 0,this.shapesGroup=void 0;var k;this.chart=y,this.points=[],this.controlPoints=[],this.coll="annotations",this.labels=[],this.shapes=[],this.options=merge$N(this.defaultOptions,a),this.userOptions=a,k=this.getLabelsAndShapesOptions(this.options,a),this.options.labels=k.labels,this.options.shapes=k.shapes,this.init(y,this.options)}return z.prototype.init=function(){var y=this.chart,a=this.options.animation;this.linkPoints(),this.addControlPoints(),this.addShapes(),this.addLabels(),this.setLabelCollector(),this.animationConfig=getDeferredAnimation(y,a)},z.prototype.getLabelsAndShapesOptions=function(y,a){var k={};return["labels","shapes"].forEach(function(j){y[j]&&(a[j]?k[j]=splat$7(a[j]).map(function(et,it){return merge$N(y[j][it],et)}):k[j]=y[j])}),k},z.prototype.addShapes=function(){(this.options.shapes||[]).forEach(function(y,a){var k=this.initShape(y,a);merge$N(!0,this.options.shapes[a],k.options)},this)},z.prototype.addLabels=function(){(this.options.labels||[]).forEach(function(y,a){var k=this.initLabel(y,a);merge$N(!0,this.options.labels[a],k.options)},this)},z.prototype.addClipPaths=function(){this.setClipAxes(),this.clipXAxis&&this.clipYAxis&&(this.clipRect=this.chart.renderer.clipRect(this.getClipBox()))},z.prototype.setClipAxes=function(){var y=this.chart.xAxis,a=this.chart.yAxis,k=(this.options.labels||[]).concat(this.options.shapes||[]).reduce(function(j,et){var it=et&&(et.point||et.points&&et.points[0]);return[y[it&&it.xAxis]||j[0],a[it&&it.yAxis]||j[1]]},[]);this.clipXAxis=k[0],this.clipYAxis=k[1]},z.prototype.getClipBox=function(){if(this.clipXAxis&&this.clipYAxis)return{x:this.clipXAxis.left,y:this.clipYAxis.top,width:this.clipXAxis.width,height:this.clipYAxis.height}},z.prototype.setLabelCollector=function(){var y=this;y.labelCollector=function(){return y.labels.reduce(function(a,k){return k.options.allowOverlap||a.push(k.graphic),a},[])},y.chart.labelCollectors.push(y.labelCollector)},z.prototype.setOptions=function(y){this.options=merge$N(this.defaultOptions,y)},z.prototype.redraw=function(y){this.linkPoints(),this.graphic||this.render(),this.clipRect&&this.clipRect.animate(this.getClipBox()),this.redrawItems(this.shapes,y),this.redrawItems(this.labels,y),controllableMixin.redraw.call(this,y)},z.prototype.redrawItems=function(y,a){for(var k=y.length;k--;)this.redrawItem(y[k],a)},z.prototype.renderItems=function(y){for(var a=y.length;a--;)this.renderItem(y[a])},z.prototype.render=function(){var y=this.chart.renderer;this.graphic=y.g("annotation").attr({opacity:0,zIndex:this.options.zIndex,visibility:this.options.visible?"visible":"hidden"}).add(),this.shapesGroup=y.g("annotation-shapes").add(this.graphic).clip(this.chart.plotBoxClip),this.labelsGroup=y.g("annotation-labels").attr({translateX:0,translateY:0}).add(this.graphic),this.addClipPaths(),this.clipRect&&this.graphic.clip(this.clipRect),this.renderItems(this.shapes),this.renderItems(this.labels),this.addEvents(),controllableMixin.render.call(this)},z.prototype.setVisibility=function(y){var a=this.options,k=this.chart.navigationBindings,j=pick$T(y,!a.visible);this.graphic.attr("visibility",j?"visible":"hidden"),j||(this.setControlPointsVisibility(!1),k.activeAnnotation===this&&k.popup&&k.popup.formType==="annotation-toolbar"&&fireEvent$b(k,"closePopup")),a.visible=j},z.prototype.setControlPointsVisibility=function(y){var a=function(k){k.setControlPointsVisibility(y)};controllableMixin.setControlPointsVisibility.call(this,y),this.shapes.forEach(a),this.labels.forEach(a)},z.prototype.destroy=function(){var y=this.chart,a=function(k){k.destroy()};this.labels.forEach(a),this.shapes.forEach(a),this.clipXAxis=null,this.clipYAxis=null,erase$1(y.labelCollectors,this.labelCollector),eventEmitterMixin.destroy.call(this),controllableMixin.destroy.call(this),destroyObjectProperties(this,y)},z.prototype.remove=function(){return this.chart.removeAnnotation(this)},z.prototype.update=function(y,a){var k=this.chart,j=this.getLabelsAndShapesOptions(this.userOptions,y),et=k.annotations.indexOf(this),it=merge$N(!0,this.userOptions,y);it.labels=j.labels,it.shapes=j.shapes,this.destroy(),this.constructor(k,it),k.options.annotations[et]=it,this.isUpdating=!0,pick$T(a,!0)&&k.redraw(),fireEvent$b(this,"afterUpdate"),this.isUpdating=!1},z.prototype.initShape=function(y,a){var k=merge$N(this.options.shapeOptions,{controlPointOptions:this.options.controlPointOptions},y),j=new z.shapesMap[k.type](this,k,a);return j.itemType="shape",this.shapes.push(j),j},z.prototype.initLabel=function(y,a){var k=merge$N(this.options.labelOptions,{controlPointOptions:this.options.controlPointOptions},y),j=new ControllableLabel(this,k,a);return j.itemType="label",this.labels.push(j),j},z.prototype.redrawItem=function(y,a){y.linkPoints(),y.shouldBeDrawn()?(y.graphic||this.renderItem(y),y.redraw(pick$T(a,!0)&&y.graphic.placed),y.points.length&&this.adjustVisibility(y)):this.destroyItem(y)},z.prototype.adjustVisibility=function(y){var a=!1,k=y.graphic;y.points.forEach(function(j){j.series.visible!==!1&&j.visible!==!1&&(a=!0)}),a?k.visibility==="hidden"&&k.show():k.hide()},z.prototype.destroyItem=function(y){erase$1(this[y.itemType+"s"],y),y.destroy()},z.prototype.renderItem=function(y){y.render(y.itemType==="label"?this.labelsGroup:this.shapesGroup)},z.ControlPoint=ControlPoint,z.MockPoint=MockPoint,z.shapesMap={rect:ControllableRect,circle:ControllableCircle,path:ControllablePath,image:ControllableImage},z.types={},z})();merge$N(!0,Annotation.prototype,controllableMixin,eventEmitterMixin,merge$N(Annotation.prototype,{nonDOMEvents:["add","afterUpdate","drag","remove"],defaultOptions:{visible:!0,animation:{},draggable:"xy",labelOptions:{align:"center",allowOverlap:!1,backgroundColor:"rgba(0, 0, 0, 0.75)",borderColor:palette.neutralColor100,borderRadius:3,borderWidth:1,className:"highcharts-no-tooltip",crop:!1,formatter:function(){return defined$n(this.y)?this.y:"Annotation label"},includeInDataExport:!0,overflow:"justify",padding:5,shadow:!1,shape:"callout",style:{fontSize:"11px",fontWeight:"normal",color:"contrast"},useHTML:!1,verticalAlign:"bottom",x:0,y:-16},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1,fill:"rgba(0, 0, 0, 0.75)",r:0,snap:2},controlPointOptions:{symbol:"circle",width:10,height:10,style:{stroke:palette.neutralColor100,"stroke-width":2,fill:palette.backgroundColor},visible:!1,events:{}},events:{},zIndex:6}}));H.extendAnnotation=function(z,y,a,k){y=y||Annotation,extend$Q(z.prototype,merge$N(y.prototype,a)),z.prototype.defaultOptions=merge$N(z.prototype.defaultOptions,k||{})};extend$Q(chartProto,{initAnnotation:function(z){var y=Annotation.types[z.type]||Annotation,a=new y(this,z);return this.annotations.push(a),a},addAnnotation:function(z,y){var a=this.initAnnotation(z);return this.options.annotations.push(a.options),pick$T(y,!0)&&(a.redraw(),a.graphic.attr({opacity:1})),a},removeAnnotation:function(z){var y=this.annotations,a=z.coll==="annotations"?z:find$7(y,function(k){return k.options.id===z});a&&(fireEvent$b(a,"remove"),erase$1(this.options.annotations,a.options),erase$1(y,a),a.destroy())},drawAnnotations:function(){this.plotBoxClip.attr(this.plotBox),this.annotations.forEach(function(z){z.redraw(),z.graphic.animate({opacity:1},z.animationConfig)})}});chartProto.collectionsWithUpdate.push("annotations");chartProto.collectionsWithInit.annotations=[chartProto.addAnnotation];addEvent$A(Chart$1,"afterInit",function(){this.annotations=[],this.options.annotations||(this.options.annotations=[])});chartProto.callbacks.push(function(z){z.plotBoxClip=this.renderer.clipRect(this.plotBox),z.controlPointsGroup=z.renderer.g("control-points").attr({zIndex:99}).clip(z.plotBoxClip).add(),z.options.annotations.forEach(function(y,a){if(!z.annotations.some(function(j){return j.options===y})){var k=z.initAnnotation(y);z.options.annotations[a]=k.options}}),z.drawAnnotations(),addEvent$A(z,"redraw",z.drawAnnotations),addEvent$A(z,"destroy",function(){z.plotBoxClip.destroy(),z.controlPointsGroup.destroy()}),addEvent$A(z,"exportData",function(y){var a=z.annotations,k=(this.options.exporting&&this.options.exporting.csv||{}).columnHeaderFormatter,j=!y.dataRows[1].xValues,et=z.options.lang&&z.options.lang.exportData&&z.options.lang.exportData.annotationHeader,it=function(ft){var vt;return k&&(vt=k(ft),vt!==!1)?vt:(vt=et+" "+ft,j?{columnTitle:vt,topLevelColumnTitle:vt}:vt)},nt=y.dataRows[0].length,ot=z.options.exporting&&z.options.exporting.csv&&z.options.exporting.csv.annotations&&z.options.exporting.csv.annotations.itemDelimiter,at=z.options.exporting&&z.options.exporting.csv&&z.options.exporting.csv.annotations&&z.options.exporting.csv.annotations.join;a.forEach(function(ft){ft.options.labelOptions.includeInDataExport&&ft.labels.forEach(function(vt){if(vt.options.text){var gt=vt.options.text;vt.points.forEach(function(mt){var bt=mt.x,xt=mt.series.xAxis?mt.series.xAxis.options.index:-1,wt=!1;if(xt===-1){for(var Mt=y.dataRows[0].length,Et=new Array(Mt),St=0;St<Mt;++St)Et[St]="";Et.push(gt),Et.xValues=[],Et.xValues[xt]=bt,y.dataRows.push(Et),wt=!0}if(wt||y.dataRows.forEach(function(kt,Pt){!wt&&kt.xValues&&xt!==void 0&&bt===kt.xValues[xt]&&(at&&kt.length>nt?kt[kt.length-1]+=ot+gt:kt.push(gt),wt=!0)}),!wt){for(var Mt=y.dataRows[0].length,Et=new Array(Mt),St=0;St<Mt;++St)Et[St]="";Et[0]=bt,Et.push(gt),Et.xValues=[],xt!==void 0&&(Et.xValues[xt]=bt),y.dataRows.push(Et)}})}})});var lt=0;y.dataRows.forEach(function(ft){lt=Math.max(lt,ft.length)});for(var ct=lt-y.dataRows[0].length,ht=0;ht<ct;ht++){var ut=it(ht+1);j?(y.dataRows[0].push(ut.topLevelColumnTitle),y.dataRows[1].push(ut.columnTitle)):y.dataRows[0].push(ut)}})});wrap$e(Pointer.prototype,"onContainerMouseDown",function(z){this.chart.hasDraggedAnnotation||z.apply(this,Array.prototype.slice.call(arguments,1))});H.Annotation=Annotation;var chartNavigation={initUpdate:function(z){z.navigation||(z.navigation={updates:[],update:function(y,a){this.updates.forEach(function(k){k.update.call(k.context,y,a)})}})},addUpdate:function(z,y){y.navigation||this.initUpdate(y),y.navigation.updates.push({update:z,context:y})}},format$2=FormatUtilities.format,setOptions$1=DefaultOptions.setOptions,addEvent$z=Utilities.addEvent,attr=Utilities.attr,fireEvent$a=Utilities.fireEvent,isArray$a=Utilities.isArray,isFunction$1=Utilities.isFunction,isNumber$p=Utilities.isNumber,isObject$9=Utilities.isObject,merge$M=Utilities.merge,objectEach$d=Utilities.objectEach,pick$S=Utilities.pick,doc$4=H.doc,win$2=H.win,PREFIX$1="highcharts-";function closestPolyfill(z,y){var a=win$2.Element.prototype,k=a.matches||a.msMatchesSelector||a.webkitMatchesSelector,j=null;if(a.closest)j=a.closest.call(z,y);else do{if(k.call(z,y))return z;z=z.parentElement||z.parentNode}while(z!==null&&z.nodeType===1);return j}var bindingsUtils={getFieldType:function(z){return{string:"text",number:"number",boolean:"checkbox"}[typeof z]},updateRectSize:function(z,y){var a=y.chart,k=y.options.typeOptions,j=isNumber$p(k.xAxis)&&a.xAxis[k.xAxis],et=isNumber$p(k.yAxis)&&a.yAxis[k.yAxis];if(j&&et){var it=j.toValue(z[j.horiz?"chartX":"chartY"]),nt=et.toValue(z[et.horiz?"chartX":"chartY"]),ot=it-k.point.x,at=k.point.y-nt;y.update({typeOptions:{background:{width:a.inverted?at:ot,height:a.inverted?ot:at}}})}},getAssignedAxis:function(z){return z.filter(function(y){var a=y.axis.min,k=y.axis.max,j=pick$S(y.axis.minPointOffset,0);return isNumber$p(a)&&isNumber$p(k)&&y.value>=a-j&&y.value<=k+j&&!y.axis.options.isInternal})[0]}},NavigationBindings=(function(){function z(y,a){this.boundClassNames=void 0,this.selectedButton=void 0,this.chart=y,this.options=a,this.eventsToUnbind=[],this.container=doc$4.getElementsByClassName(this.options.bindingsClassName||"")}return z.prototype.initEvents=function(){var y=this,a=y.chart,k=y.container,j=y.options;y.boundClassNames={},objectEach$d(j.bindings||{},function(et){y.boundClassNames[et.className]=et}),[].forEach.call(k,function(et){y.eventsToUnbind.push(addEvent$z(et,"click",function(it){var nt=y.getButtonEvents(et,it);nt&&nt.button.className.indexOf("highcharts-disabled-btn")===-1&&y.bindingsButtonClick(nt.button,nt.events,it)}))}),objectEach$d(j.events||{},function(et,it){isFunction$1(et)&&y.eventsToUnbind.push(addEvent$z(y,it,et,{passive:!1}))}),y.eventsToUnbind.push(addEvent$z(a.container,"click",function(et){!a.cancelClick&&a.isInsidePlot(et.chartX-a.plotLeft,et.chartY-a.plotTop,{visiblePlotOnly:!0})&&y.bindingsChartClick(this,et)})),y.eventsToUnbind.push(addEvent$z(a.container,H.isTouchDevice?"touchmove":"mousemove",function(et){y.bindingsContainerMouseMove(this,et)},H.isTouchDevice?{passive:!1}:void 0))},z.prototype.initUpdate=function(){var y=this;chartNavigation.addUpdate(function(a){y.update(a)},this.chart)},z.prototype.bindingsButtonClick=function(y,a,k){var j=this,et=j.chart;j.selectedButtonElement&&(fireEvent$a(j,"deselectButton",{button:j.selectedButtonElement}),j.nextEvent&&(j.currentUserDetails&&j.currentUserDetails.coll==="annotations"&&et.removeAnnotation(j.currentUserDetails),j.mouseMoveEvent=j.nextEvent=!1)),j.selectedButton=a,j.selectedButtonElement=y,fireEvent$a(j,"selectButton",{button:y}),a.init&&a.init.call(j,y,k),(a.start||a.steps)&&et.renderer.boxWrapper.addClass(PREFIX$1+"draw-mode")},z.prototype.bindingsChartClick=function(y,a){y=this.chart;var k=this,j=k.activeAnnotation,et=k.selectedButton,it=y.renderer.boxWrapper;j&&(!j.cancelClick&&!a.activeAnnotation&&a.target.parentNode&&!closestPolyfill(a.target,"."+PREFIX$1+"popup")?fireEvent$a(k,"closePopup"):j.cancelClick&&setTimeout(function(){j.cancelClick=!1},0)),!(!et||!et.start)&&(k.nextEvent?(k.nextEvent(a,k.currentUserDetails),k.steps&&(k.stepIndex++,et.steps[k.stepIndex]?k.mouseMoveEvent=k.nextEvent=et.steps[k.stepIndex]:(fireEvent$a(k,"deselectButton",{button:k.selectedButtonElement}),it.removeClass(PREFIX$1+"draw-mode"),et.end&&et.end.call(k,a,k.currentUserDetails),k.nextEvent=!1,k.mouseMoveEvent=!1,k.selectedButton=null))):(k.currentUserDetails=et.start.call(k,a),k.currentUserDetails&&et.steps?(k.stepIndex=0,k.steps=!0,k.mouseMoveEvent=k.nextEvent=et.steps[k.stepIndex]):(fireEvent$a(k,"deselectButton",{button:k.selectedButtonElement}),it.removeClass(PREFIX$1+"draw-mode"),k.steps=!1,k.selectedButton=null,et.end&&et.end.call(k,a,k.currentUserDetails))))},z.prototype.bindingsContainerMouseMove=function(y,a){this.mouseMoveEvent&&this.mouseMoveEvent(a,this.currentUserDetails)},z.prototype.fieldsToOptions=function(y,a){return objectEach$d(y,function(k,j){var et=parseFloat(k),it=j.split("."),nt=a,ot=it.length-1;isNumber$p(et)&&!k.match(/px/g)&&!j.match(/format/g)&&(k=et),k!==""&&k!=="undefined"&&it.forEach(function(at,lt){var ct=pick$S(it[lt+1],"");ot===lt?nt[at]=k:(nt[at]||(nt[at]=ct.match(/\d/g)?[]:{}),nt=nt[at])})}),a},z.prototype.deselectAnnotation=function(){this.activeAnnotation&&(this.activeAnnotation.setControlPointsVisibility(!1),this.activeAnnotation=!1)},z.prototype.annotationToFields=function(y){var a=y.options,k=z.annotationsEditable,j=k.nestedOptions,et=this.utils.getFieldType,it=pick$S(a.type,a.shapes&&a.shapes[0]&&a.shapes[0].type,a.labels&&a.labels[0]&&a.labels[0].itemType,"label"),nt=z.annotationsNonEditable[a.langKey]||[],ot={langKey:a.langKey,type:it};function at(lt,ct,ht,ut){var ft;ht&&lt&&nt.indexOf(ct)===-1&&((ht.indexOf&&ht.indexOf(ct))>=0||ht[ct]||ht===!0)&&(isArray$a(lt)?(ut[ct]=[],lt.forEach(function(vt,gt){isObject$9(vt)?(ut[ct][gt]={},objectEach$d(vt,function(mt,bt){at(mt,bt,j[ct],ut[ct][gt])})):at(vt,0,j[ct],ut[ct])})):isObject$9(lt)?(ft={},isArray$a(ut)?(ut.push(ft),ft[ct]={},ft=ft[ct]):ut[ct]=ft,objectEach$d(lt,function(vt,gt){at(vt,gt,ct===0?ht:j[ct],ft)})):ct==="format"?ut[ct]=[format$2(lt,y.labels[0].points[0]).toString(),"text"]:isArray$a(ut)?ut.push([lt,et(lt)]):ut[ct]=[lt,et(lt)])}return objectEach$d(a,function(lt,ct){ct==="typeOptions"?(ot[ct]={},objectEach$d(a[ct],function(ht,ut){at(ht,ut,j,ot[ct])})):at(lt,ct,k[it],ot)}),ot},z.prototype.getClickedClassNames=function(y,a){for(var k=a.target,j=[],et;k;)if(et=attr(k,"class"),et&&(j=j.concat(et.split(" ").map(function(it){return[it,k]}))),k=k.parentNode,k===y)return j;return j},z.prototype.getButtonEvents=function(y,a){var k=this,j=this.getClickedClassNames(y,a),et;return j.forEach(function(it){k.boundClassNames[it[0]]&&!et&&(et={events:k.boundClassNames[it[0]],button:it[1]})}),et},z.prototype.update=function(y){this.options=merge$M(!0,this.options,y),this.removeEvents(),this.initEvents()},z.prototype.removeEvents=function(){this.eventsToUnbind.forEach(function(y){y()})},z.prototype.destroy=function(){this.removeEvents()},z.annotationsEditable={nestedOptions:{labelOptions:["style","format","backgroundColor"],labels:["style"],label:["style"],style:["fontSize","color"],background:["fill","strokeWidth","stroke"],innerBackground:["fill","strokeWidth","stroke"],outerBackground:["fill","strokeWidth","stroke"],shapeOptions:["fill","strokeWidth","stroke"],shapes:["fill","strokeWidth","stroke"],line:["strokeWidth","stroke"],backgroundColors:[!0],connector:["fill","strokeWidth","stroke"],crosshairX:["strokeWidth","stroke"],crosshairY:["strokeWidth","stroke"]},circle:["shapes"],verticalLine:[],label:["labelOptions"],measure:["background","crosshairY","crosshairX"],fibonacci:[],tunnel:["background","line","height"],pitchfork:["innerBackground","outerBackground"],rect:["shapes"],crookedLine:[],basicAnnotation:["shapes","labelOptions"]},z.annotationsNonEditable={rectangle:["crosshairX","crosshairY","label"]},z})();NavigationBindings.prototype.utils=bindingsUtils;Chart$1.prototype.initNavigationBindings=function(){var z=this,y=z.options;y&&y.navigation&&y.navigation.bindings&&(z.navigationBindings=new NavigationBindings(z,y.navigation),z.navigationBindings.initEvents(),z.navigationBindings.initUpdate())};addEvent$z(Chart$1,"load",function(){this.initNavigationBindings()});addEvent$z(Chart$1,"destroy",function(){this.navigationBindings&&this.navigationBindings.destroy()});addEvent$z(NavigationBindings,"deselectButton",function(){this.selectedButtonElement=null});addEvent$z(Annotation,"remove",function(){this.chart.navigationBindings&&this.chart.navigationBindings.deselectAnnotation()});function selectableAnnotation(z){var y=z.prototype.defaultOptions.events&&z.prototype.defaultOptions.events.click;function a(k){var j=this,et=j.chart.navigationBindings,it=et.activeAnnotation;y&&y.call(j,k),it!==j?(et.deselectAnnotation(),et.activeAnnotation=j,j.setControlPointsVisibility(!0),fireEvent$a(et,"showPopup",{annotation:j,formType:"annotation-toolbar",options:et.annotationToFields(j),onSubmit:function(nt){var ot={},at;nt.actionType==="remove"?(et.activeAnnotation=!1,et.chart.removeAnnotation(j)):(et.fieldsToOptions(nt.fields,ot),et.deselectAnnotation(),at=ot.typeOptions,j.options.type==="measure"&&(at.crosshairY.enabled=at.crosshairY.strokeWidth!==0,at.crosshairX.enabled=at.crosshairX.strokeWidth!==0),j.update(ot))}})):fireEvent$a(et,"closePopup"),k.activeAnnotation=!0}merge$M(!0,z.prototype.defaultOptions.events,{click:a})}H.Annotation&&(selectableAnnotation(Annotation),objectEach$d(Annotation.types,function(z){selectableAnnotation(z)}));setOptions$1({lang:{navigation:{popup:{simpleShapes:"Simple shapes",lines:"Lines",circle:"Circle",rectangle:"Rectangle",label:"Label",shapeOptions:"Shape options",typeOptions:"Details",fill:"Fill",format:"Text",strokeWidth:"Line width",stroke:"Line color",title:"Title",name:"Name",labelOptions:"Label options",labels:"Labels",backgroundColor:"Background color",backgroundColors:"Background colors",borderColor:"Border color",borderRadius:"Border radius",borderWidth:"Border width",style:"Style",padding:"Padding",fontSize:"Font size",color:"Color",height:"Height",shapes:"Shape options"}}},navigation:{bindingsClassName:"highcharts-bindings-container",bindings:{circleAnnotation:{className:"highcharts-circle-annotation",start:function(z){var y=this.chart.pointer.getCoordinates(z),a=this.utils.getAssignedAxis(y.xAxis),k=this.utils.getAssignedAxis(y.yAxis),j=this.chart.options.navigation;if(!(!a||!k))return this.chart.addAnnotation(merge$M({langKey:"circle",type:"basicAnnotation",shapes:[{type:"circle",point:{x:a.value,y:k.value,xAxis:a.axis.options.index,yAxis:k.axis.options.index},r:5}]},j.annotationsOptions,j.bindings.circleAnnotation.annotationsOptions))},steps:[function(z,y){var a=y.options.shapes[0].point,k=this.chart.inverted,j,et,it;isNumber$p(a.xAxis)&&isNumber$p(a.yAxis)&&(j=this.chart.xAxis[a.xAxis].toPixels(a.x),et=this.chart.yAxis[a.yAxis].toPixels(a.y),it=Math.max(Math.sqrt(Math.pow(k?et-z.chartX:j-z.chartX,2)+Math.pow(k?j-z.chartY:et-z.chartY,2)),5)),y.update({shapes:[{r:it}]})}]},rectangleAnnotation:{className:"highcharts-rectangle-annotation",start:function(z){var y=this.chart.pointer.getCoordinates(z),a=this.utils.getAssignedAxis(y.xAxis),k=this.utils.getAssignedAxis(y.yAxis);if(!(!a||!k)){var j=a.value,et=k.value,it=a.axis.options.index,nt=k.axis.options.index,ot=this.chart.options.navigation;return this.chart.addAnnotation(merge$M({langKey:"rectangle",type:"basicAnnotation",shapes:[{type:"path",points:[{xAxis:it,yAxis:nt,x:j,y:et},{xAxis:it,yAxis:nt,x:j,y:et},{xAxis:it,yAxis:nt,x:j,y:et},{xAxis:it,yAxis:nt,x:j,y:et}]}]},ot.annotationsOptions,ot.bindings.rectangleAnnotation.annotationsOptions))}},steps:[function(z,y){var a=y.options.shapes[0].points,k=this.chart.pointer.getCoordinates(z),j=this.utils.getAssignedAxis(k.xAxis),et=this.utils.getAssignedAxis(k.yAxis),it,nt;j&&et&&(it=j.value,nt=et.value,a[1].x=it,a[2].x=it,a[2].y=nt,a[3].y=nt,y.update({shapes:[{points:a}]}))}]},labelAnnotation:{className:"highcharts-label-annotation",start:function(z){var y=this.chart.pointer.getCoordinates(z),a=this.utils.getAssignedAxis(y.xAxis),k=this.utils.getAssignedAxis(y.yAxis),j=this.chart.options.navigation;if(!(!a||!k))return this.chart.addAnnotation(merge$M({langKey:"label",type:"basicAnnotation",labelOptions:{format:"{y:.2f}"},labels:[{point:{xAxis:a.axis.options.index,yAxis:k.axis.options.index,x:a.value,y:k.value},overflow:"none",crop:!0}]},j.annotationsOptions,j.bindings.labelAnnotation.annotationsOptions))}}},events:{},annotationsOptions:{animation:{defer:0}}}});addEvent$z(Chart$1,"render",function(){var z=this,y=z.navigationBindings,a="highcharts-disabled-btn";if(z&&y){var k=!1;z.series.forEach(function(j){!j.options.isInternal&&j.visible&&(k=!0)}),objectEach$d(y.boundClassNames,function(j,et){if(z.navigationBindings&&z.navigationBindings.container&&z.navigationBindings.container[0]){var it=z.navigationBindings.container[0].querySelectorAll("."+et);if(it)for(var nt=0;nt<it.length;nt++){var ot=it[nt];j.noDataState==="normal"||k?ot.className.indexOf(a)!==-1&&ot.classList.remove(a):ot.className.indexOf(a)===-1&&(ot.className+=" "+a)}}})}});addEvent$z(NavigationBindings,"closePopup",function(){this.deselectAnnotation()});var doc$3=H.doc,isFirefox=H.isFirefox,getOptions$2=DefaultOptions.getOptions,addEvent$y=Utilities.addEvent,createElement$2=Utilities.createElement,defined$m=Utilities.defined,fireEvent$9=Utilities.fireEvent,isArray$9=Utilities.isArray,isObject$8=Utilities.isObject,isString$2=Utilities.isString,objectEach$c=Utilities.objectEach,pick$R=Utilities.pick,stableSort$3=Utilities.stableSort,wrap$d=Utilities.wrap,indexFilter=/\d/g,PREFIX="highcharts-",DIV="div",INPUT="input",LABEL="label",BUTTON="button",SELECT="select",OPTION="option",SPAN="span",UL="ul",LI="li",H3="h3";wrap$d(Pointer.prototype,"onContainerMouseDown",function(z,y){var a=y.target&&y.target.className;isString$2(a)&&a.indexOf(PREFIX+"popup-field")>=0||z.apply(this,Array.prototype.slice.call(arguments,1))});H.Popup=function(z,y,a){this.init(z,y,a)};H.Popup.prototype={init:function(z,y,a){this.chart=a,this.container=createElement$2(DIV,{className:PREFIX+"popup highcharts-no-tooltip"},null,z),this.lang=this.getLangpack(),this.iconsURL=y,this.addCloseBtn()},addCloseBtn:function(){var z=this,y,a=this.iconsURL;y=createElement$2(DIV,{className:PREFIX+"popup-close"},null,this.container),y.style["background-image"]="url("+(a.match(/png|svg|jpeg|jpg|gif/ig)?a:a+"close.svg")+")",["click","touchstart"].forEach(function(k){addEvent$y(y,k,function(){z.chart?fireEvent$9(z.chart.navigationBindings,"closePopup"):z.closePopup()})})},addColsContainer:function(z){var y,a;return a=createElement$2(DIV,{className:PREFIX+"popup-lhs-col"},null,z),y=createElement$2(DIV,{className:PREFIX+"popup-rhs-col"},null,z),createElement$2(DIV,{className:PREFIX+"popup-rhs-col-wrapper"},null,y),{lhsCol:a,rhsCol:y}},addInput:function(z,y,a,k){var j=z.split("."),et=j[j.length-1],it=this.lang,nt=PREFIX+y+"-"+et;nt.match(indexFilter)||createElement$2(LABEL,{htmlFor:nt},void 0,a).appendChild(doc$3.createTextNode(it[et]||et)),k!==""&&createElement$2(INPUT,{name:nt,value:k[0],type:k[1],className:PREFIX+"popup-field"},void 0,a).setAttribute(PREFIX+"data-name",z)},addButton:function(z,y,a,k,j){var et=this,it=this.closePopup,nt=this.getFields,ot;return ot=createElement$2(BUTTON,void 0,void 0,z),ot.appendChild(doc$3.createTextNode(y)),["click","touchstart"].forEach(function(at){addEvent$y(ot,at,function(){return it.call(et),k(nt(j,a))})}),ot},getFields:function(z,y){var a=z.querySelectorAll("input"),k="#"+PREFIX+"select-series > option:checked",j="#"+PREFIX+"select-volume > option:checked",et=z.querySelectorAll(k)[0],it=z.querySelectorAll(j)[0],nt,ot,at;return at={actionType:y,linkedTo:et&&et.getAttribute("value"),fields:{}},[].forEach.call(a,function(lt){ot=lt.getAttribute(PREFIX+"data-name"),nt=lt.getAttribute(PREFIX+"data-series-id"),nt?at.seriesId=lt.value:ot?at.fields[ot]=lt.value:at.type=lt.value}),it&&(at.fields["params.volumeSeriesID"]=it.getAttribute("value")),at},showPopup:function(){var z=this.container,y=PREFIX+"annotation-toolbar",a=z.querySelectorAll("."+PREFIX+"popup-close")[0];this.formType=void 0,z.innerHTML="",z.className.indexOf(y)>=0&&(z.classList.remove(y),z.removeAttribute("style")),z.appendChild(a),z.style.display="block",z.style.height=""},closePopup:function(){var z=pick$R(this.popup&&this.popup.container,this.container);z.style.display="none"},showForm:function(z,y,a,k){y&&(this.popup=y.navigationBindings.popup,this.showPopup(),z==="indicators"&&this.indicators.addForm.call(this,y,a,k),z==="annotation-toolbar"&&this.annotations.addToolbar.call(this,y,a,k),z==="annotation-edit"&&this.annotations.addForm.call(this,y,a,k),z==="flag"&&this.annotations.addForm.call(this,y,a,k,!0),this.formType=z,this.container.style.height=this.container.offsetHeight+"px")},getLangpack:function(){return getOptions$2().lang.navigation.popup},annotations:{addToolbar:function(z,y,a){var k=this,j=this.lang,et=this.popup.container,it=this.showForm,nt=PREFIX+"annotation-toolbar",ot;et.className.indexOf(nt)===-1&&(et.className+=" "+nt),z&&(et.style.top=z.plotTop+10+"px"),createElement$2(SPAN,void 0,void 0,et).appendChild(doc$3.createTextNode(pick$R(j[y.langKey]||y.langKey,y.shapes&&y.shapes[0].type))),ot=this.addButton(et,j.removeButton||"remove","remove",a,et),ot.className+=" "+PREFIX+"annotation-remove-button",ot.style["background-image"]="url("+this.iconsURL+"destroy.svg)",ot=this.addButton(et,j.editButton||"edit","edit",function(){it.call(k,"annotation-edit",z,y,a)},et),ot.className+=" "+PREFIX+"annotation-edit-button",ot.style["background-image"]="url("+this.iconsURL+"edit.svg)"},addForm:function(z,y,a,k){var j=this.popup.container,et=this.lang,it,nt;z&&(nt=createElement$2("h2",{className:PREFIX+"popup-main-title"},void 0,j),nt.appendChild(doc$3.createTextNode(et[y.langKey]||y.langKey||"")),nt=createElement$2(DIV,{className:PREFIX+"popup-lhs-col "+PREFIX+"popup-lhs-full"},null,j),it=createElement$2(DIV,{className:PREFIX+"popup-bottom-row"},null,j),this.annotations.addFormFields.call(this,nt,z,"",y,[],!0),this.addButton(it,k?et.addButton||"add":et.saveButton||"save",k?"add":"save",a,j))},addFormFields:function(z,y,a,k,j,et){var it=this,nt=this.annotations.addFormFields,ot=this.addInput,at=this.lang,lt,ct;y&&(objectEach$c(k,function(ht,ut){lt=a!==""?a+"."+ut:ut,isObject$8(ht)&&(!isArray$9(ht)||isArray$9(ht)&&isObject$8(ht[0])?(ct=at[ut]||ut,ct.match(indexFilter)||j.push([!0,ct,z]),nt.call(it,z,y,lt,ht,j,!1)):j.push([it,lt,"annotation",z,ht]))}),et&&(stableSort$3(j,function(ht){return ht[1].match(/format/g)?-1:1}),isFirefox&&j.reverse(),j.forEach(function(ht){ht[0]===!0?createElement$2(SPAN,{className:PREFIX+"annotation-title"},void 0,ht[2]).appendChild(doc$3.createTextNode(ht[1])):ot.apply(ht[0],ht.splice(1))})))}},indicators:{addForm:function(z,y,a){var k,j=this.indicators,et=this.lang,it;z&&(this.tabs.init.call(this,z),k=this.popup.container.querySelectorAll("."+PREFIX+"tab-item-content"),this.addColsContainer(k[0]),j.addIndicatorList.call(this,z,k[0],"add"),it=k[0].querySelectorAll("."+PREFIX+"popup-rhs-col")[0],this.addButton(it,et.addButton||"add","add",a,it),this.addColsContainer(k[1]),j.addIndicatorList.call(this,z,k[1],"edit"),it=k[1].querySelectorAll("."+PREFIX+"popup-rhs-col")[0],this.addButton(it,et.saveButton||"save","edit",a,it),this.addButton(it,et.removeButton||"remove","remove",a,it))},addIndicatorList:function(z,y,a){var k=this,j=y.querySelectorAll("."+PREFIX+"popup-lhs-col")[0],et=y.querySelectorAll("."+PREFIX+"popup-rhs-col")[0],it=a==="edit",nt=it?z.series:z.options.plotOptions,ot=this.indicators.addFormFields,at,lt,ct;z&&(lt=createElement$2(UL,{className:PREFIX+"indicator-list"},null,j),at=et.querySelectorAll("."+PREFIX+"popup-rhs-col-wrapper")[0],objectEach$c(nt,function(ht,ut){var ft=ht.options;if(ht.params||ft&&ft.params){var vt=k.indicators.getNameType(ht,ut),gt=vt.type;ct=createElement$2(LI,{className:PREFIX+"indicator-list"},void 0,lt),ct.appendChild(doc$3.createTextNode(vt.name)),["click","touchstart"].forEach(function(mt){addEvent$y(ct,mt,function(){ot.call(k,z,it?ht:nt[gt],vt.type,at),it&&ht.options&&createElement$2(INPUT,{type:"hidden",name:PREFIX+"id-"+gt,value:ht.options.id},null,at).setAttribute(PREFIX+"data-series-id",ht.options.id)})})}}),lt.childNodes.length>0&&lt.childNodes[0].click())},getNameType:function(z,y){var a=z.options,k=H.seriesTypes,j=k[y]&&k[y].prototype.nameBase||y.toUpperCase(),et=y;return a&&a.type&&(et=z.options.type,j=z.name),{name:j,type:et}},listAllSeries:function(z,y,a,k,j){var et=PREFIX+y+"-type-"+z,it=this.lang,nt,ot;a&&(createElement$2(LABEL,{htmlFor:et},null,k).appendChild(doc$3.createTextNode(it[y]||y)),nt=createElement$2(SELECT,{name:et,className:PREFIX+"popup-field"},null,k),nt.setAttribute("id",PREFIX+"select-"+y),a.series.forEach(function(at){ot=at.options,!ot.params&&ot.id&&ot.id!==PREFIX+"navigator-series"&&createElement$2(OPTION,{value:ot.id},null,nt).appendChild(doc$3.createTextNode(ot.name||ot.id))}),defined$m(j)&&(nt.value=j))},addFormFields:function(z,y,a,k){var j=y.params||y.options.params,et=this.indicators.getNameType;k.innerHTML="",createElement$2(H3,{className:PREFIX+"indicator-title"},void 0,k).appendChild(doc$3.createTextNode(et(y,a).name)),createElement$2(INPUT,{type:"hidden",name:PREFIX+"type-"+a,value:a},null,k),this.indicators.listAllSeries.call(this,a,"series",z,k,y.linkedParent&&j.volumeSeriesID),j.volumeSeriesID&&this.indicators.listAllSeries.call(this,a,"volume",z,k,y.linkedParent&&y.linkedParent.options.id),this.indicators.addParamInputs.call(this,z,"params",j,a,k)},addParamInputs:function(z,y,a,k,j){var et=this,it=this.indicators.addParamInputs,nt=this.addInput,ot;z&&objectEach$c(a,function(at,lt){ot=y+"."+lt,at!==void 0&&(isObject$8(at)?(nt.call(et,ot,k,j,""),it.call(et,z,ot,at,k,j)):ot!=="params.volumeSeriesID"&&nt.call(et,ot,k,j,[at,"text"]))})},getAmount:function(){var z=this.series,y=0;return z.forEach(function(a){var k=a.options;(a.params||k&&k.params)&&y++}),y}},tabs:{init:function(z){var y=this.tabs,a=this.indicators.getAmount.call(z),k;z&&(k=y.addMenuItem.call(this,"add"),y.addMenuItem.call(this,"edit",a),y.addContentItem.call(this,"add"),y.addContentItem.call(this,"edit"),y.switchTabs.call(this,a),y.selectTab.call(this,k,0))},addMenuItem:function(z,y){var a=this.popup.container,k=PREFIX+"tab-item",j=this.lang,et;return y===0&&(k+=" "+PREFIX+"tab-disabled"),et=createElement$2(SPAN,{className:k},void 0,a),et.appendChild(doc$3.createTextNode(j[z+"Button"]||z)),et.setAttribute(PREFIX+"data-tab-type",z),et},addContentItem:function(){var z=this.popup.container;return createElement$2(DIV,{className:PREFIX+"tab-item-content "+PREFIX+"no-mousewheel"},null,z)},switchTabs:function(z){var y=this,a=this.popup.container,k=a.querySelectorAll("."+PREFIX+"tab-item"),j;k.forEach(function(et,it){j=et.getAttribute(PREFIX+"data-tab-type"),!(j==="edit"&&z===0)&&["click","touchstart"].forEach(function(nt){addEvent$y(et,nt,function(){y.tabs.deselectAll.call(y),y.tabs.selectTab.call(y,this,it)})})})},selectTab:function(z,y){var a=this.popup.container.querySelectorAll("."+PREFIX+"tab-item-content");z.className+=" "+PREFIX+"tab-item-active",a[y].className+=" "+PREFIX+"tab-item-show"},deselectAll:function(){var z=this.popup.container,y=z.querySelectorAll("."+PREFIX+"tab-item"),a=z.querySelectorAll("."+PREFIX+"tab-item-content"),k;for(k=0;k<y.length;k++)y[k].classList.remove(PREFIX+"tab-item-active"),a[k].classList.remove(PREFIX+"tab-item-show")}}};addEvent$y(NavigationBindings,"showPopup",function(z){this.popup||(this.popup=new H.Popup(this.chart.container,this.chart.options.navigation.iconsURL||this.chart.options.stockTools&&this.chart.options.stockTools.gui.iconsURL||"https://code.highcharts.com/9.2.2/gfx/stock-icons/",this.chart)),this.popup.showForm(z.formType,this.chart,z.options,z.onSubmit)});addEvent$y(NavigationBindings,"closePopup",function(){this.popup&&this.popup.closePopup()});H.Popup;var addEvent$x=Utilities.addEvent,extend$P=Utilities.extend,merge$L=Utilities.merge,pick$Q=Utilities.pick,splat$6=Utilities.splat;Chart$1.prototype.collectionsWithUpdate.push("pane");var Pane=(function(){function z(y,a){this.background=void 0,this.center=void 0,this.chart=void 0,this.options=void 0,this.coll="pane",this.defaultOptions={center:["50%","50%"],size:"85%",innerSize:"0%",startAngle:0},this.defaultBackgroundOptions={shape:"circle",borderWidth:1,borderColor:palette.neutralColor20,backgroundColor:{linearGradient:{x1:0,y1:0,x2:0,y2:1},stops:[[0,palette.backgroundColor],[1,palette.neutralColor10]]},from:-Number.MAX_VALUE,innerRadius:0,to:Number.MAX_VALUE,outerRadius:"105%"},this.init(y,a)}return z.prototype.init=function(y,a){this.chart=a,this.background=[],a.pane.push(this),this.setOptions(y)},z.prototype.setOptions=function(y){this.options=y=merge$L(this.defaultOptions,this.chart.angular?{background:{}}:void 0,y)},z.prototype.render=function(){var y=this.options,a=this.options.background,k=this.chart.renderer,j,et;if(this.group||(this.group=k.g("pane-group").attr({zIndex:y.zIndex||0}).add()),this.updateCenter(),a)for(a=splat$6(a),j=Math.max(a.length,this.background.length||0),et=0;et<j;et++)a[et]&&this.axis?this.renderBackground(merge$L(this.defaultBackgroundOptions,a[et]),et):this.background[et]&&(this.background[et]=this.background[et].destroy(),this.background.splice(et,1))},z.prototype.renderBackground=function(y,a){var k="animate",j={class:"highcharts-pane "+(y.className||"")};this.chart.styledMode||extend$P(j,{fill:y.backgroundColor,stroke:y.borderColor,"stroke-width":y.borderWidth}),this.background[a]||(this.background[a]=this.chart.renderer.path().add(this.group),k="attr"),this.background[a][k]({d:this.axis.getPlotBandPath(y.from,y.to,y)}).attr(j)},z.prototype.updateCenter=function(y){this.center=(y||this.axis||{}).center=centeredSeriesMixin.getCenter.call(this)},z.prototype.update=function(y,a){merge$L(!0,this.options,y),this.setOptions(this.options),this.render(),this.chart.axes.forEach(function(k){k.pane===this&&(k.pane=null,k.update({},a))},this)},z})();function isInsidePane(z,y,a){return Math.sqrt(Math.pow(z-a[0],2)+Math.pow(y-a[1],2))<=a[2]/2}Chart$1.prototype.getHoverPane=function(z){var y=this,a;return z&&y.pane.forEach(function(k){var j=z.chartX-y.plotLeft,et=z.chartY-y.plotTop,it=y.inverted?et:j,nt=y.inverted?j:et;isInsidePane(it,nt,k.center)&&(a=k)}),a};addEvent$x(Chart$1,"afterIsInsidePlot",function(z){var y=this;y.polar&&(z.isInsidePlot=y.pane.some(function(a){return isInsidePane(z.x,z.y,a.center)}))});addEvent$x(Pointer,"beforeGetHoverData",function(z){var y=this.chart;y.polar?(y.hoverPane=y.getHoverPane(z),z.filter=function(a){return a.visible&&!(!z.shared&&a.directTouch)&&pick$Q(a.options.enableMouseTracking,!0)&&(!y.hoverPane||a.xAxis.pane===y.hoverPane)}):y.hoverPane=void 0});addEvent$x(Pointer,"afterGetHoverData",function(z){var y=this.chart;z.hoverPoint&&z.hoverPoint.plotX&&z.hoverPoint.plotY&&y.hoverPane&&!isInsidePane(z.hoverPoint.plotX,z.hoverPoint.plotY,y.hoverPane.center)&&(z.hoverPoint=void 0)});H.Pane=Pane;const Pane$1=H.Pane;var defaultOptions$7=DefaultOptions.defaultOptions,noop$b=H.noop,addEvent$w=Utilities.addEvent,correctFloat$3=Utilities.correctFloat,defined$l=Utilities.defined,extend$O=Utilities.extend,fireEvent$8=Utilities.fireEvent,merge$K=Utilities.merge,pick$P=Utilities.pick,relativeLength$2=Utilities.relativeLength,wrap$c=Utilities.wrap,RadialAxis;(function(z){var y=[],a={gridLineWidth:1,labels:{align:void 0,distance:15,x:0,y:void 0,style:{textOverflow:"none"}},maxPadding:0,minPadding:0,showLastLabel:!1,tickLength:0},k={labels:{align:"center",x:0,y:void 0},minorGridLineWidth:0,minorTickInterval:"auto",minorTickLength:10,minorTickPosition:"inside",minorTickWidth:1,tickLength:10,tickPosition:"inside",tickWidth:2,title:{rotation:0},zIndex:2},j={gridLineInterpolation:"circle",gridLineWidth:1,labels:{align:"right",x:-3,y:-2},showLastLabel:!1,title:{x:4,text:null,rotation:90}};function et(){this.autoConnect=this.isCircular&&typeof pick$P(this.userMax,this.options.max)>"u"&&correctFloat$3(this.endAngleRad-this.startAngleRad)===correctFloat$3(2*Math.PI),!this.isCircular&&this.chart.inverted&&this.max++,this.autoConnect&&(this.max+=this.categories&&1||this.pointRange||this.closestPointRange||0)}function it(Dt,Ht){return y.indexOf(Dt)===-1&&(y.push(Dt),addEvent$w(Dt,"afterInit",bt),addEvent$w(Dt,"autoLabelAlign",xt),addEvent$w(Dt,"destroy",wt),addEvent$w(Dt,"init",Mt),addEvent$w(Dt,"initialAxisTranslation",Et)),y.indexOf(Ht)===-1&&(y.push(Ht),addEvent$w(Ht,"afterGetLabelPosition",St),addEvent$w(Ht,"afterGetPosition",kt),wrap$c(Ht.prototype,"getMarkPath",Ft)),Dt}z.compose=it;function nt(){var Dt=this;return function(){if(Dt.isRadial&&Dt.tickPositions&&Dt.options.labels&&Dt.options.labels.allowOverlap!==!0)return Dt.tickPositions.map(function(Ht){return Dt.ticks[Ht]&&Dt.ticks[Ht].label}).filter(function(Ht){return!!Ht})}}function ot(){return noop$b}function at(Dt,Ht,Gt){var Yt=this.pane.center,te=Dt.value,he,ee,Xt,oe;return this.isCircular?(defined$l(te)?Dt.point&&(he=Dt.point.shapeArgs||{},he.start&&(te=this.chart.inverted?this.translate(Dt.point.rectPlotY,!0):Dt.point.x)):(Xt=Dt.chartX||0,oe=Dt.chartY||0,te=this.translate(Math.atan2(oe-Gt,Xt-Ht)-this.startAngleRad,!0)),ee=this.getPosition(te),Xt=ee.x,oe=ee.y):(defined$l(te)||(Xt=Dt.chartX,oe=Dt.chartY),defined$l(Xt)&&defined$l(oe)&&(Gt=Yt[1]+this.chart.plotTop,te=this.translate(Math.min(Math.sqrt(Math.pow(Xt-Ht,2)+Math.pow(oe-Gt,2)),Yt[2]/2)-Yt[3]/2,!0))),[te,Xt||0,oe||0]}function lt(Dt,Ht,Gt){var Yt=this.pane.center,te=this.chart,he=this.left||0,ee=this.top||0,Xt,oe=pick$P(Ht,Yt[2]/2-this.offset),le;return typeof Gt>"u"&&(Gt=this.horiz?0:this.center&&-this.center[3]/2),Gt&&(oe+=Gt),this.isCircular||typeof Ht<"u"?(le=this.chart.renderer.symbols.arc(he+Yt[0],ee+Yt[1],oe,oe,{start:this.startAngleRad,end:this.endAngleRad,open:!0,innerR:0}),le.xBounds=[he+Yt[0]],le.yBounds=[ee+Yt[1]-oe]):(Xt=this.postTranslate(this.angleRad,oe),le=[["M",this.center[0]+te.plotLeft,this.center[1]+te.plotTop],["L",Xt.x,Xt.y]]),le}function ct(){var Dt=this.constructor.prototype;Dt.getOffset.call(this),this.chart.axisOffset[this.side]=0}function ht(Dt,Ht,Gt){var Yt=this.chart,te=function(_i){if(typeof _i=="string"){var $i=parseInt(_i,10);return _e.test(_i)&&($i=$i*Xt/100),$i}return _i},he=this.center,ee=this.startAngleRad,Xt=he[2]/2,oe=Math.min(this.offset,0),le=this.left||0,ie=this.top||0,_e=/%$/,Re=this.isCircular,Ee,Se,Le,Ne,Je,Ue,Ve=pick$P(te(Gt.outerRadius),Xt),Ye=te(Gt.innerRadius),li=pick$P(te(Gt.thickness),10);if(this.options.gridLineInterpolation==="polygon")Ue=this.getPlotLinePath({value:Dt}).concat(this.getPlotLinePath({value:Ht,reverse:!0}));else{Dt=Math.max(Dt,this.min),Ht=Math.min(Ht,this.max);var Li=this.translate(Dt),Pi=this.translate(Ht);Re||(Ve=Li||0,Ye=Pi||0),Gt.shape==="circle"||!Re?(Ee=-Math.PI/2,Se=Math.PI*1.5,Je=!0):(Ee=ee+(Li||0),Se=ee+(Pi||0)),Ve-=oe,li-=oe,Ue=Yt.renderer.symbols.arc(le+he[0],ie+he[1],Ve,Ve,{start:Math.min(Ee,Se),end:Math.max(Ee,Se),innerR:pick$P(Ye,Ve-li),open:Je}),Re&&(Le=(Se+Ee)/2,Ne=le+he[0]+he[2]/2*Math.cos(Le),Ue.xBounds=Le>-Math.PI/2&&Le<Math.PI/2?[Ne,Yt.plotWidth]:[0,Ne],Ue.yBounds=[ie+he[1]+he[2]/2*Math.sin(Le)],Ue.yBounds[0]+=Le>-Math.PI&&Le<0||Le>Math.PI?-10:10)}return Ue}function ut(Dt){var Ht=this,Gt=this.pane.center,Yt=this.chart,te=Yt.inverted,he=Dt.reverse,ee=this.pane.options.background?this.pane.options.background[0]||this.pane.options.background:{},Xt=ee.innerRadius||"0%",oe=ee.outerRadius||"100%",le=Gt[0]+Yt.plotLeft,ie=Gt[1]+Yt.plotTop,_e=this.height,Re=Dt.isCrosshair,Ee=Gt[3]/2,Se=Dt.value,Le,Ne,Je,Ue,Ve,Ye,li,Li,Pi,_i=this.getPosition(Se),$i=_i.x,Hi=_i.y;if(Re&&(Li=this.getCrosshairPosition(Dt,le,ie),Se=Li[0],$i=Li[1],Hi=Li[2]),this.isCircular)Ne=Math.sqrt(Math.pow($i-le,2)+Math.pow(Hi-ie,2)),Je=typeof Xt=="string"?relativeLength$2(Xt,1):Xt/Ne,Ue=typeof oe=="string"?relativeLength$2(oe,1):oe/Ne,Gt&&Ee&&(Le=Ee/Ne,Je<Le&&(Je=Le),Ue<Le&&(Ue=Le)),Pi=[["M",le+Je*($i-le),ie-Je*(ie-Hi)],["L",$i-(1-Ue)*($i-le),Hi+(1-Ue)*(ie-Hi)]];else if(Se=this.translate(Se),Se&&(Se<0||Se>_e)&&(Se=0),this.options.gridLineInterpolation==="circle")Pi=this.getLinePath(0,Se,Ee);else if(Pi=[],Yt[te?"yAxis":"xAxis"].forEach(function(Di){Di.pane===Ht.pane&&(Ve=Di)}),Ve){li=Ve.tickPositions,Ve.autoConnect&&(li=li.concat([li[0]])),he&&(li=li.slice().reverse()),Se&&(Se+=Ee);for(var Ae=0;Ae<li.length;Ae++)Ye=Ve.getPosition(li[Ae],Se),Pi.push(Ae?["L",Ye.x,Ye.y]:["M",Ye.x,Ye.y])}return Pi}function ft(Dt,Ht){var Gt=this.translate(Dt);return this.postTranslate(this.isCircular?Gt:this.angleRad,pick$P(this.isCircular?Ht:Gt<0?0:Gt,this.center[2]/2)-this.offset)}function vt(){var Dt=this.center,Ht=this.chart,Gt=this.options.title;return{x:Ht.plotLeft+Dt[0]+(Gt.x||0),y:Ht.plotTop+Dt[1]-{high:.5,middle:.25,low:0}[Gt.align]*Dt[2]+(Gt.y||0)}}function gt(Dt){Dt.beforeSetTickPositions=et,Dt.createLabelCollector=nt,Dt.getCrosshairPosition=at,Dt.getLinePath=lt,Dt.getOffset=ct,Dt.getPlotBandPath=ht,Dt.getPlotLinePath=ut,Dt.getPosition=ft,Dt.getTitlePosition=vt,Dt.postTranslate=Pt,Dt.setAxisSize=Nt,Dt.setAxisTranslation=Ut,Dt.setOptions=Rt}function mt(Dt){Dt.isHidden=!0,Dt.createLabelCollector=ot,Dt.getOffset=noop$b,Dt.redraw=It,Dt.render=It,Dt.setScale=noop$b,Dt.setCategories=noop$b,Dt.setTitle=noop$b}function bt(){var Dt=this.chart,Ht=this.options,Gt=Dt.angular&&this.isXAxis,Yt=this.pane,te=Yt&&Yt.options;!Gt&&Yt&&(Dt.angular||Dt.polar)&&(this.angleRad=(Ht.angle||0)*Math.PI/180,this.startAngleRad=(te.startAngle-90)*Math.PI/180,this.endAngleRad=(pick$P(te.endAngle,te.startAngle+360)-90)*Math.PI/180,this.offset=Ht.offset||0)}function xt(Dt){this.isRadial&&(Dt.align=void 0,Dt.preventDefault())}function wt(){if(this.chart&&this.chart.labelCollectors){var Dt=this.labelCollector?this.chart.labelCollectors.indexOf(this.labelCollector):-1;Dt>=0&&this.chart.labelCollectors.splice(Dt,1)}}function Mt(Dt){var Ht=this.chart,Gt=Ht.inverted,Yt=Ht.angular,te=Ht.polar,he=this.isXAxis,ee=this.coll,Xt=Yt&&he,oe=Ht.options,le=Dt.userOptions.pane||0,ie=this.pane=Ht.pane&&Ht.pane[le],_e;if(ee==="colorAxis"){this.isRadial=!1;return}Yt?(Xt?mt(this):gt(this),_e=!he,_e&&(this.defaultPolarOptions=k)):te&&(gt(this),_e=this.horiz,this.defaultPolarOptions=_e?a:merge$K(ee==="xAxis"?AxisDefaults$1.defaultXAxisOptions:AxisDefaults$1.defaultYAxisOptions,j),Gt&&ee==="yAxis"&&(this.defaultPolarOptions.stackLabels=AxisDefaults$1.defaultYAxisOptions.stackLabels,this.defaultPolarOptions.reversedStacks=!0)),Yt||te?(this.isRadial=!0,oe.chart.zoomType=null,this.labelCollector||(this.labelCollector=this.createLabelCollector()),this.labelCollector&&Ht.labelCollectors.push(this.labelCollector)):this.isRadial=!1,ie&&_e&&(ie.axis=this),this.isCircular=_e}function Et(){this.isRadial&&this.beforeSetTickPositions()}function St(Dt){var Ht=this.label;if(Ht){var Gt=this.axis,Yt=Ht.getBBox(),te=Gt.options.labels,he=(Gt.translate(this.pos)+Gt.startAngleRad+Math.PI/2)/Math.PI*180%360,ee=Math.round(he),Xt=defined$l(te.y)?0:-Yt.height*.3,oe=te.y,le,ie=20,_e=te.align,Re="end",Ee=ee<0?ee+360:ee,Se=Ee,Le=0,Ne=0;Gt.isRadial&&(le=Gt.getPosition(this.pos,Gt.center[2]/2+relativeLength$2(pick$P(te.distance,-25),Gt.center[2]/2,-Gt.center[2]/2)),te.rotation==="auto"?Ht.attr({rotation:he}):defined$l(oe)||(oe=Gt.chart.renderer.fontMetrics(Ht.styles&&Ht.styles.fontSize).b-Yt.height/2),defined$l(_e)||(Gt.isCircular?(Yt.width>Gt.len*Gt.tickInterval/(Gt.max-Gt.min)&&(ie=0),he>ie&&he<180-ie?_e="left":he>180+ie&&he<360-ie?_e="right":_e="center"):_e="center",Ht.attr({align:_e})),_e==="auto"&&Gt.tickPositions.length===2&&Gt.isCircular&&(Ee>90&&Ee<180?Ee=180-Ee:Ee>270&&Ee<=360&&(Ee=540-Ee),Se>180&&Se<=360&&(Se=360-Se),(Gt.pane.options.startAngle===ee||Gt.pane.options.startAngle===ee+360||Gt.pane.options.startAngle===ee-360)&&(Re="start"),ee>=-90&&ee<=90||ee>=-360&&ee<=-270||ee>=270&&ee<=360?_e=Re==="start"?"right":"left":_e=Re==="start"?"left":"right",Se>70&&Se<110&&(_e="center"),Ee<15||Ee>=180&&Ee<195?Le=Yt.height*.3:Ee>=15&&Ee<=35?Le=Re==="start"?0:Yt.height*.75:Ee>=195&&Ee<=215?Le=Re==="start"?Yt.height*.75:0:Ee>35&&Ee<=90?Le=Re==="start"?-Yt.height*.25:Yt.height:Ee>215&&Ee<=270&&(Le=Re==="start"?Yt.height:-Yt.height*.25),Se<15?Ne=Re==="start"?-Yt.height*.15:Yt.height*.15:Se>165&&Se<=180&&(Ne=Re==="start"?Yt.height*.15:-Yt.height*.15),Ht.attr({align:_e}),Ht.translate(Ne,Le+Xt)),Dt.pos.x=le.x+(te.x||0),Dt.pos.y=le.y+(oe||0))}}function kt(Dt){this.axis.getPosition&&extend$O(Dt.pos,this.axis.getPosition(this.pos))}function Pt(Dt,Ht){var Gt=this.chart,Yt=this.center;return Dt=this.startAngleRad+Dt,{x:Gt.plotLeft+Yt[0]+Math.cos(Dt)*Ht,y:Gt.plotTop+Yt[1]+Math.sin(Dt)*Ht}}function It(){this.isDirty=!1}function Nt(){var Dt=this.constructor.prototype,Ht,Gt;Dt.setAxisSize.call(this),this.isRadial&&(this.pane.updateCenter(this),Ht=this.center=this.pane.center.slice(),this.isCircular?this.sector=this.endAngleRad-this.startAngleRad:(Gt=this.postTranslate(this.angleRad,Ht[3]/2),Ht[0]=Gt.x-this.chart.plotLeft,Ht[1]=Gt.y-this.chart.plotTop),this.len=this.width=this.height=(Ht[2]-Ht[3])*pick$P(this.sector,1)/2)}function Ut(){var Dt=this.constructor.prototype;Dt.setAxisTranslation.call(this),this.center&&(this.isCircular?this.transA=(this.endAngleRad-this.startAngleRad)/(this.max-this.min||1):this.transA=(this.center[2]-this.center[3])/2/(this.max-this.min||1),this.isXAxis?this.minPixelPadding=this.transA*this.minPointOffset:this.minPixelPadding=0)}function Rt(Dt){var Ht=this.options=merge$K(this.constructor.defaultOptions,this.defaultPolarOptions,defaultOptions$7[this.coll],Dt);Ht.plotBands||(Ht.plotBands=[]),fireEvent$8(this,"afterSetOptions")}function Ft(Dt,Ht,Gt,Yt,te,he,ee){var Xt=this.axis,oe,le;return Xt.isRadial?(oe=Xt.getPosition(this.pos,Xt.center[2]/2+Yt),le=["M",Ht,Gt,"L",oe.x,oe.y]):le=Dt.call(this,Ht,Gt,Yt,te,he,ee),le}})(RadialAxis||(RadialAxis={}));const RadialAxis$1=RadialAxis;var __extends$1_=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),pointProto=Point$4.prototype,defined$k=Utilities.defined,isNumber$o=Utilities.isNumber,AreaRangePoint$1=(function(z){__extends$1_(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.high=void 0,a.low=void 0,a.options=void 0,a.plotHigh=void 0,a.plotLow=void 0,a.plotHighX=void 0,a.plotLowX=void 0,a.plotX=void 0,a.series=void 0,a}return y.prototype.setState=function(){var a=this.state,k=this.series,j=k.chart.polar;defined$k(this.plotHigh)||(this.plotHigh=k.yAxis.toPixels(this.high,!0)),defined$k(this.plotLow)||(this.plotLow=this.plotY=k.yAxis.toPixels(this.low,!0)),k.stateMarkerGraphic&&(k.lowerStateMarkerGraphic=k.stateMarkerGraphic,k.stateMarkerGraphic=k.upperStateMarkerGraphic),this.graphic=this.upperGraphic,this.plotY=this.plotHigh,j&&(this.plotX=this.plotHighX),pointProto.setState.apply(this,arguments),this.state=a,this.plotY=this.plotLow,this.graphic=this.lowerGraphic,j&&(this.plotX=this.plotLowX),k.stateMarkerGraphic&&(k.upperStateMarkerGraphic=k.stateMarkerGraphic,k.stateMarkerGraphic=k.lowerStateMarkerGraphic,k.lowerStateMarkerGraphic=void 0),pointProto.setState.apply(this,arguments)},y.prototype.haloPath=function(){var a=this.series.chart.polar,k=[];return this.plotY=this.plotLow,a&&(this.plotX=this.plotLowX),this.isInside&&(k=pointProto.haloPath.apply(this,arguments)),this.plotY=this.plotHigh,a&&(this.plotX=this.plotHighX),this.isTopInside&&(k=k.concat(pointProto.haloPath.apply(this,arguments))),k},y.prototype.isValid=function(){return isNumber$o(this.low)&&isNumber$o(this.high)},y})(AreaSeries$1.prototype.pointClass),__extends$1Z=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),areaProto=AreaSeries$1.prototype,columnProto$4=ColumnSeries$h.prototype,noop$a=H.noop,seriesProto$1=Series$f.prototype,defined$j=Utilities.defined,extend$N=Utilities.extend,isArray$8=Utilities.isArray,pick$O=Utilities.pick,merge$J=Utilities.merge,AreaRangeSeries$2=(function(z){__extends$1Z(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a.lowerStateMarkerGraphic=void 0,a.xAxis=void 0,a}return y.prototype.toYData=function(a){return[a.low,a.high]},y.prototype.highToXY=function(a){var k=this.chart,j=this.xAxis.postTranslate(a.rectPlotX||0,this.yAxis.len-a.plotHigh);a.plotHighX=j.x-k.plotLeft,a.plotHigh=j.y-k.plotTop,a.plotLowX=a.plotX},y.prototype.translate=function(){var a=this,k=a.yAxis,j=!!a.modifyValue;areaProto.translate.apply(a),a.points.forEach(function(et){var it=et.high,nt=et.plotY;et.isNull?et.plotY=null:(et.plotLow=nt,et.plotHigh=k.translate(j?a.modifyValue(it,et):it,0,1,0,1),j&&(et.yBottom=et.plotHigh))}),this.chart.polar&&this.points.forEach(function(et){a.highToXY(et),et.tooltipPos=[(et.plotHighX+et.plotLowX)/2,(et.plotHigh+et.plotLow)/2]})},y.prototype.getGraphPath=function(a){var k=[],j=[],et,it=areaProto.getGraphPath,nt,ot,at,lt,ct=this.options,ht=this.chart.polar,ut=ht&&ct.connectEnds!==!1,ft=ct.connectNulls,vt=ct.step,gt,mt;for(a=a||this.points,et=a.length;et--;){nt=a[et];var bt=ht?{plotX:nt.rectPlotX,plotY:nt.yBottom,doCurve:!1}:{plotX:nt.plotX,plotY:nt.plotY,doCurve:!1};!nt.isNull&&!ut&&!ft&&(!a[et+1]||a[et+1].isNull)&&j.push(bt),ot={polarPlotY:nt.polarPlotY,rectPlotX:nt.rectPlotX,yBottom:nt.yBottom,plotX:pick$O(nt.plotHighX,nt.plotX),plotY:nt.plotHigh,isNull:nt.isNull},j.push(ot),k.push(ot),!nt.isNull&&!ut&&!ft&&(!a[et-1]||a[et-1].isNull)&&j.push(bt)}return lt=it.call(this,a),vt&&(vt===!0&&(vt="left"),ct.step={left:"right",center:"center",right:"left"}[vt]),gt=it.call(this,k),mt=it.call(this,j),ct.step=vt,at=[].concat(lt,gt),!this.chart.polar&&mt[0]&&mt[0][0]==="M"&&(mt[0]=["L",mt[0][1],mt[0][2]]),this.graphPath=at,this.areaPath=lt.concat(mt),at.isArea=!0,at.xMap=lt.xMap,this.areaPath.xMap=lt.xMap,at},y.prototype.drawDataLabels=function(){var a=this.points,k=a.length,j,et=[],it=this.options.dataLabels,nt,ot,at=this.chart.inverted,lt,ct;if(it){if(isArray$8(it)?(lt=it[0]||{enabled:!1},ct=it[1]||{enabled:!1}):(lt=extend$N({},it),lt.x=it.xHigh,lt.y=it.yHigh,ct=extend$N({},it),ct.x=it.xLow,ct.y=it.yLow),lt.enabled||this._hasPointLabels){for(j=k;j--;)nt=a[j],nt&&(ot=lt.inside?nt.plotHigh<nt.plotLow:nt.plotHigh>nt.plotLow,nt.y=nt.high,nt._plotY=nt.plotY,nt.plotY=nt.plotHigh,et[j]=nt.dataLabel,nt.dataLabel=nt.dataLabelUpper,nt.below=ot,at?lt.align||(lt.align=ot?"right":"left"):lt.verticalAlign||(lt.verticalAlign=ot?"top":"bottom"));for(this.options.dataLabels=lt,seriesProto$1.drawDataLabels&&seriesProto$1.drawDataLabels.apply(this,arguments),j=k;j--;)nt=a[j],nt&&(nt.dataLabelUpper=nt.dataLabel,nt.dataLabel=et[j],delete nt.dataLabels,nt.y=nt.low,nt.plotY=nt._plotY)}if(ct.enabled||this._hasPointLabels){for(j=k;j--;)nt=a[j],nt&&(ot=ct.inside?nt.plotHigh<nt.plotLow:nt.plotHigh>nt.plotLow,nt.below=!ot,at?ct.align||(ct.align=ot?"left":"right"):ct.verticalAlign||(ct.verticalAlign=ot?"bottom":"top"));this.options.dataLabels=ct,seriesProto$1.drawDataLabels&&seriesProto$1.drawDataLabels.apply(this,arguments)}if(lt.enabled)for(j=k;j--;)nt=a[j],nt&&(nt.dataLabels=[nt.dataLabelUpper,nt.dataLabel].filter(function(ht){return!!ht}));this.options.dataLabels=it}},y.prototype.alignDataLabel=function(){columnProto$4.alignDataLabel.apply(this,arguments)},y.prototype.drawPoints=function(){var a=this,k=a.points.length,j,et;for(seriesProto$1.drawPoints.apply(a,arguments),et=0;et<k;)j=a.points[et],j.origProps={plotY:j.plotY,plotX:j.plotX,isInside:j.isInside,negative:j.negative,zone:j.zone,y:j.y},j.lowerGraphic=j.graphic,j.graphic=j.upperGraphic,j.plotY=j.plotHigh,defined$j(j.plotHighX)&&(j.plotX=j.plotHighX),j.y=pick$O(j.high,j.origProps.y),j.negative=j.y<(a.options.threshold||0),a.zones.length&&(j.zone=j.getZone()),a.chart.polar||(j.isInside=j.isTopInside=typeof j.plotY<"u"&&j.plotY>=0&&j.plotY<=a.yAxis.len&&j.plotX>=0&&j.plotX<=a.xAxis.len),et++;for(seriesProto$1.drawPoints.apply(a,arguments),et=0;et<k;)j=a.points[et],j.upperGraphic=j.graphic,j.graphic=j.lowerGraphic,j.origProps&&(extend$N(j,j.origProps),delete j.origProps),et++},y.defaultOptions=merge$J(AreaSeries$1.defaultOptions,{lineWidth:1,threshold:null,tooltip:{pointFormat:'<span style="color:{series.color}">●</span> {series.name}: <b>{point.low}</b> - <b>{point.high}</b><br/>'},trackByArea:!0,dataLabels:{align:void 0,verticalAlign:void 0,xLow:0,xHigh:0,yLow:0,yHigh:0}}),y})(AreaSeries$1);extend$N(AreaRangeSeries$2.prototype,{pointArrayMap:["low","high"],pointValKey:"low",deferTranslatePolar:!0,pointClass:AreaRangePoint$1,setStackedPoints:noop$a});SeriesRegistry$1.registerSeriesType("arearange",AreaRangeSeries$2);var __extends$1Y=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),SplineSeries=SeriesRegistry$1.seriesTypes.spline,merge$I=Utilities.merge,extend$M=Utilities.extend,AreaSplineRangeSeries=(function(z){__extends$1Y(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.options=void 0,a.data=void 0,a.points=void 0,a}return y.defaultOptions=merge$I(AreaRangeSeries$2.defaultOptions),y})(AreaRangeSeries$2);extend$M(AreaSplineRangeSeries.prototype,{getPointSpline:SplineSeries.prototype.getPointSpline});SeriesRegistry$1.registerSeriesType("areasplinerange",AreaSplineRangeSeries);var __extends$1X=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),noop$9=H.noop,extend$L=Utilities.extend,merge$H=Utilities.merge,pick$N=Utilities.pick,BoxPlotSeries=(function(z){__extends$1X(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return y.prototype.pointAttribs=function(){return{}},y.prototype.translate=function(){var a=this,k=a.yAxis,j=a.pointArrayMap;z.prototype.translate.apply(a),a.points.forEach(function(et){j.forEach(function(it){et[it]!==null&&(et[it+"Plot"]=k.translate(et[it],0,1,0,1))}),et.plotHigh=et.highPlot})},y.prototype.drawPoints=function(){var a=this,k=a.points,j=a.options,et=a.chart,it=et.renderer,nt,ot,at,lt,ct,ht,ut,ft=0,vt,gt,mt,bt,xt,wt=a.doQuartiles!==!1,Mt,Et=a.options.whiskerLength;k.forEach(function(St){var kt=St.graphic,Pt=kt?"animate":"attr",It=St.shapeArgs,Nt={},Ut={},Rt={},Ft={},Dt=St.color||a.color;if(typeof St.plotY<"u"){gt=Math.round(It.width),mt=Math.floor(It.x),bt=mt+gt,xt=Math.round(gt/2),nt=Math.floor(wt?St.q1Plot:St.lowPlot),ot=Math.floor(wt?St.q3Plot:St.lowPlot),at=Math.floor(St.highPlot),lt=Math.floor(St.lowPlot),kt||(St.graphic=kt=it.g("point").add(a.group),St.stem=it.path().addClass("highcharts-boxplot-stem").add(kt),Et&&(St.whiskers=it.path().addClass("highcharts-boxplot-whisker").add(kt)),wt&&(St.box=it.path(vt).addClass("highcharts-boxplot-box").add(kt)),St.medianShape=it.path(ht).addClass("highcharts-boxplot-median").add(kt)),et.styledMode||(Ut.stroke=St.stemColor||j.stemColor||Dt,Ut["stroke-width"]=pick$N(St.stemWidth,j.stemWidth,j.lineWidth),Ut.dashstyle=St.stemDashStyle||j.stemDashStyle||j.dashStyle,St.stem.attr(Ut),Et&&(Rt.stroke=St.whiskerColor||j.whiskerColor||Dt,Rt["stroke-width"]=pick$N(St.whiskerWidth,j.whiskerWidth,j.lineWidth),Rt.dashstyle=St.whiskerDashStyle||j.whiskerDashStyle||j.dashStyle,St.whiskers.attr(Rt)),wt&&(Nt.fill=St.fillColor||j.fillColor||Dt,Nt.stroke=j.lineColor||Dt,Nt["stroke-width"]=j.lineWidth||0,Nt.dashstyle=St.boxDashStyle||j.boxDashStyle||j.dashStyle,St.box.attr(Nt)),Ft.stroke=St.medianColor||j.medianColor||Dt,Ft["stroke-width"]=pick$N(St.medianWidth,j.medianWidth,j.lineWidth),Ft.dashstyle=St.medianDashStyle||j.medianDashStyle||j.dashStyle,St.medianShape.attr(Ft));var Ht=void 0;ut=St.stem.strokeWidth()%2/2,ft=mt+xt+ut,Ht=[["M",ft,ot],["L",ft,at],["M",ft,nt],["L",ft,lt]],St.stem[Pt]({d:Ht}),wt&&(ut=St.box.strokeWidth()%2/2,nt=Math.floor(nt)+ut,ot=Math.floor(ot)+ut,mt+=ut,bt+=ut,Ht=[["M",mt,ot],["L",mt,nt],["L",bt,nt],["L",bt,ot],["L",mt,ot],["Z"]],St.box[Pt]({d:Ht})),Et&&(ut=St.whiskers.strokeWidth()%2/2,at=at+ut,lt=lt+ut,Mt=/%$/.test(Et)?xt*parseFloat(Et)/100:Et/2,Ht=[["M",ft-Mt,at],["L",ft+Mt,at],["M",ft-Mt,lt],["L",ft+Mt,lt]],St.whiskers[Pt]({d:Ht})),ct=Math.round(St.medianPlot),ut=St.medianShape.strokeWidth()%2/2,ct=ct+ut,Ht=[["M",mt,ct],["L",bt,ct]],St.medianShape[Pt]({d:Ht})}})},y.prototype.toYData=function(a){return[a.low,a.q1,a.median,a.q3,a.high]},y.defaultOptions=merge$H(ColumnSeries$h.defaultOptions,{threshold:null,tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Maximum: {point.high}<br/>Upper quartile: {point.q3}<br/>Median: {point.median}<br/>Lower quartile: {point.q1}<br/>Minimum: {point.low}<br/>'},whiskerLength:"50%",fillColor:palette.backgroundColor,lineWidth:1,medianWidth:2,whiskerWidth:2}),y})(ColumnSeries$h);extend$L(BoxPlotSeries.prototype,{pointArrayMap:["low","q1","median","q3","high"],pointValKey:"high",drawDataLabels:noop$9,setStackedPoints:noop$9});SeriesRegistry$1.registerSeriesType("boxplot",BoxPlotSeries);var BubbleLegendDefaults={borderColor:void 0,borderWidth:2,className:void 0,color:void 0,connectorClassName:void 0,connectorColor:void 0,connectorDistance:60,connectorWidth:1,enabled:!1,labels:{className:void 0,allowOverlap:!1,format:"",formatter:void 0,align:"right",style:{fontSize:"10px",color:palette.neutralColor100},x:0,y:0},maxSize:60,minSize:10,legendIndex:0,ranges:{value:void 0,borderColor:void 0,color:void 0,connectorColor:void 0},sizeBy:"area",sizeByAbsoluteValue:!1,zIndex:1,zThreshold:0},color$a=Color.parse,noop$8=H.noop,arrayMax$3=Utilities.arrayMax,arrayMin$3=Utilities.arrayMin,isNumber$n=Utilities.isNumber,merge$G=Utilities.merge,pick$M=Utilities.pick,stableSort$2=Utilities.stableSort,BubbleLegendItem=(function(){function z(y,a){this.chart=void 0,this.fontMetrics=void 0,this.legend=void 0,this.legendGroup=void 0,this.legendItem=void 0,this.legendItemHeight=void 0,this.legendItemWidth=void 0,this.legendSymbol=void 0,this.maxLabel=void 0,this.movementX=void 0,this.ranges=void 0,this.selected=void 0,this.visible=void 0,this.symbols=void 0,this.options=void 0,this.setState=noop$8,this.init(y,a)}return z.prototype.init=function(y,a){this.options=y,this.visible=!0,this.chart=a.chart,this.legend=a},z.prototype.addToLegend=function(y){y.splice(this.options.legendIndex,0,this)},z.prototype.drawLegendSymbol=function(y){var a=this.chart,k=this.options,j=pick$M(y.options.itemDistance,20),et=k.ranges,it=k.connectorDistance,nt;if(this.fontMetrics=a.renderer.fontMetrics(k.labels.style.fontSize),!et||!et.length||!isNumber$n(et[0].value)){y.options.bubbleLegend.autoRanges=!0;return}stableSort$2(et,function(ct,ht){return ht.value-ct.value}),this.ranges=et,this.setOptions(),this.render();var ot=this.getMaxLabelSize(),at=this.ranges[0].radius,lt=at*2;nt=it-at+ot.width,nt=nt>0?nt:0,this.maxLabel=ot,this.movementX=k.labels.align==="left"?nt:0,this.legendItemWidth=lt+nt+j,this.legendItemHeight=lt+this.fontMetrics.h/2},z.prototype.setOptions=function(){var y=this.ranges,a=this.options,k=this.chart.series[a.seriesIndex],j=this.legend.baseline,et={zIndex:a.zIndex,"stroke-width":a.borderWidth},it={zIndex:a.zIndex,"stroke-width":a.connectorWidth},nt={align:this.legend.options.rtl||a.labels.align==="left"?"right":"left",zIndex:a.zIndex},ot=k.options.marker.fillOpacity,at=this.chart.styledMode;y.forEach(function(lt,ct){at||(et.stroke=pick$M(lt.borderColor,a.borderColor,k.color),et.fill=pick$M(lt.color,a.color,ot!==1?color$a(k.color).setOpacity(ot).get("rgba"):k.color),it.stroke=pick$M(lt.connectorColor,a.connectorColor,k.color)),y[ct].radius=this.getRangeRadius(lt.value),y[ct]=merge$G(y[ct],{center:y[0].radius-y[ct].radius+j}),at||merge$G(!0,y[ct],{bubbleAttribs:merge$G(et),connectorAttribs:merge$G(it),labelAttribs:nt})},this)},z.prototype.getRangeRadius=function(y){var a=this.options,k=this.options.seriesIndex,j=this.chart.series[k],et=a.ranges[0].value,it=a.ranges[a.ranges.length-1].value,nt=a.minSize,ot=a.maxSize;return j.getRadius.call(this,it,et,nt,ot,y)},z.prototype.render=function(){var y=this.chart.renderer,a=this.options.zThreshold;this.symbols||(this.symbols={connectors:[],bubbleItems:[],labels:[]}),this.legendSymbol=y.g("bubble-legend"),this.legendItem=y.g("bubble-legend-item"),this.legendSymbol.translateX=0,this.legendSymbol.translateY=0,this.ranges.forEach(function(k){k.value>=a&&this.renderRange(k)},this),this.legendSymbol.add(this.legendItem),this.legendItem.add(this.legendGroup),this.hideOverlappingLabels()},z.prototype.renderRange=function(y){var a=this.ranges[0],k=this.legend,j=this.options,et=j.labels,it=this.chart,nt=it.series[j.seriesIndex],ot=it.renderer,at=this.symbols,lt=at.labels,ct=y.center,ht=Math.abs(y.radius),ut=j.connectorDistance||0,ft=et.align,vt=k.options.rtl,gt=j.borderWidth,mt=j.connectorWidth,bt=a.radius||0,xt=ct-ht-gt/2+mt/2,wt=this.fontMetrics,Mt=wt.f/2-(wt.h-wt.f)/2,Et=(xt%1?1:.5)-(mt%2?0:.5),St=ot.styledMode,kt=vt||ft==="left"?-ut:ut;ft==="center"&&(kt=0,j.connectorDistance=0,y.labelAttribs.align="center");var Pt=xt+j.labels.y,It=bt+kt+j.labels.x;at.bubbleItems.push(ot.circle(bt,ct+Et,ht).attr(St?{}:y.bubbleAttribs).addClass((St?"highcharts-color-"+nt.colorIndex+" ":"")+"highcharts-bubble-legend-symbol "+(j.className||"")).add(this.legendSymbol)),at.connectors.push(ot.path(ot.crispLine([["M",bt,xt],["L",bt+kt,xt]],j.connectorWidth)).attr(St?{}:y.connectorAttribs).addClass((St?"highcharts-color-"+this.options.seriesIndex+" ":"")+"highcharts-bubble-legend-connectors "+(j.connectorClassName||"")).add(this.legendSymbol));var Nt=ot.text(this.formatLabel(y),It,Pt+Mt).attr(St?{}:y.labelAttribs).css(St?{}:et.style).addClass("highcharts-bubble-legend-labels "+(j.labels.className||"")).add(this.legendSymbol);lt.push(Nt),Nt.placed=!0,Nt.alignAttr={x:It,y:Pt+Mt}},z.prototype.getMaxLabelSize=function(){var y=this.symbols.labels,a,k;return y.forEach(function(j){k=j.getBBox(!0),a?a=k.width>a.width?k:a:a=k}),a||{}},z.prototype.formatLabel=function(y){var a=this.options,k=a.labels.formatter,j=a.labels.format,et=this.chart.numberFormatter;return j?FormatUtilities.format(j,y):k?k.call(y):et(y.value,1)},z.prototype.hideOverlappingLabels=function(){var y=this.chart,a=this.options.labels.allowOverlap,k=this.symbols;!a&&k&&(y.hideOverlappingLabels(k.labels),k.labels.forEach(function(j,et){j.newOpacity?j.newOpacity!==j.oldOpacity&&k.connectors[et].show():k.connectors[et].hide()}))},z.prototype.getRanges=function(){var y=this.legend.bubbleLegend,a=y.chart.series,k=y.options.ranges,j,et,it=Number.MAX_VALUE,nt=-Number.MAX_VALUE;return a.forEach(function(ot){ot.isBubble&&!ot.ignoreSeries&&(et=ot.zData.filter(isNumber$n),et.length&&(it=pick$M(ot.options.zMin,Math.min(it,Math.max(arrayMin$3(et),ot.options.displayNegative===!1?ot.options.zThreshold:-Number.MAX_VALUE))),nt=pick$M(ot.options.zMax,Math.max(nt,arrayMax$3(et)))))}),it===nt?j=[{value:nt}]:j=[{value:it},{value:(it+nt)/2},{value:nt,autoRanges:!0}],k.length&&k[0].radius&&j.reverse(),j.forEach(function(ot,at){k&&k[at]&&(j[at]=merge$G(k[at],ot))}),j},z.prototype.predictBubbleSizes=function(){var y=this.chart,a=this.fontMetrics,k=y.legend.options,j=k.floating,et=k.layout==="horizontal",it=et?y.legend.lastLineHeight:0,nt=y.plotSizeX,ot=y.plotSizeY,at=y.series[this.options.seriesIndex],lt=Math.ceil(at.minPxSize),ct=Math.ceil(at.maxPxSize),ht=Math.min(ot,nt),ut,ft=at.options.maxSize;return j||!/%$/.test(ft)?ut=ct:(ft=parseFloat(ft),ut=(ht+it-a.h/2)*ft/100/(ft/100+1),(et&&ot-ut>=nt||!et&&nt-ut>=ot)&&(ut=ct)),[lt,Math.ceil(ut)]},z.prototype.updateRanges=function(y,a){var k=this.legend.options.bubbleLegend;k.minSize=y,k.maxSize=a,k.ranges=this.getRanges()},z.prototype.correctSizes=function(){var y=this.legend,a=this.chart,k=a.series[this.options.seriesIndex],j=k.maxPxSize,et=this.options.maxSize;Math.abs(Math.ceil(j)-et)>1&&(this.updateRanges(this.options.minSize,k.maxPxSize),y.render())},z})(),setOptions=DefaultOptions.setOptions,addEvent$v=Utilities.addEvent,objectEach$b=Utilities.objectEach,wrap$b=Utilities.wrap,BubbleLegendComposition;(function(z){var y=[];function a(at,lt,ct){var ht=this,ut=ht.legend,ft=j(ht)>=0,vt,gt;ut&&ut.options.enabled&&ut.bubbleLegend&&ut.options.bubbleLegend.autoRanges&&ft?(vt=ut.bubbleLegend.options,gt=ut.bubbleLegend.predictBubbleSizes(),ut.bubbleLegend.updateRanges(gt[0],gt[1]),vt.placed||(ut.group.placed=!1,ut.allItems.forEach(function(mt){mt.legendGroup.translateY=null})),ut.render(),ht.getMargins(),ht.axes.forEach(function(mt){mt.visible&&mt.render(),vt.placed||(mt.setScale(),mt.updateNames(),objectEach$b(mt.ticks,function(bt){bt.isNew=!0,bt.isNewLabel=!0}))}),vt.placed=!0,ht.getMargins(),at.call(ht,lt,ct),ut.bubbleLegend.correctSizes(),ot(ut,et(ut))):(at.call(ht,lt,ct),ut&&ut.options.enabled&&ut.bubbleLegend&&(ut.render(),ot(ut,et(ut))))}function k(at,lt,ct){y.indexOf(at)===-1&&(y.push(at),setOptions({legend:{bubbleLegend:BubbleLegendDefaults}}),wrap$b(at.prototype,"drawChartBox",a)),y.indexOf(lt)===-1&&(y.push(lt),addEvent$v(lt,"afterGetAllItems",it)),y.indexOf(ct)===-1&&(y.push(ct),addEvent$v(ct,"legendItemClick",nt))}z.compose=k;function j(at){for(var lt=at.series,ct=0;ct<lt.length;){if(lt[ct]&&lt[ct].isBubble&&lt[ct].visible&&lt[ct].zData.length)return ct;ct++}return-1}function et(at){var lt=at.allItems,ct=[],ht=lt.length,ut,ft=0,vt=0;for(ft=0;ft<ht;ft++)if(lt[ft].legendItemHeight&&(lt[ft].itemHeight=lt[ft].legendItemHeight),lt[ft]===lt[ht-1]||lt[ft+1]&&lt[ft]._legendItemPos[1]!==lt[ft+1]._legendItemPos[1]){for(ct.push({height:0}),ut=ct[ct.length-1],vt;vt<=ft;vt++)lt[vt].itemHeight>ut.height&&(ut.height=lt[vt].itemHeight);ut.step=ft}return ct}function it(at){var lt=this,ct=lt.bubbleLegend,ht=lt.options,ut=ht.bubbleLegend,ft=j(lt.chart);ct&&ct.ranges&&ct.ranges.length&&(ut.ranges.length&&(ut.autoRanges=!!ut.ranges[0].autoRanges),lt.destroyItem(ct)),ft>=0&&ht.enabled&&ut.enabled&&(ut.seriesIndex=ft,lt.bubbleLegend=new BubbleLegendItem(ut,lt),lt.bubbleLegend.addToLegend(at.allItems))}function nt(){var at=this,lt=at.chart,ct=at.visible,ht=at.chart.legend,ut;ht&&ht.bubbleLegend&&(at.visible=!ct,at.ignoreSeries=ct,ut=j(lt)>=0,ht.bubbleLegend.visible!==ut&&(ht.update({bubbleLegend:{enabled:ut}}),ht.bubbleLegend.visible=ut),at.visible=ct)}function ot(at,lt){var ct=at.allItems,ht=at.options.rtl,ut,ft,vt,gt=0;ct.forEach(function(mt,bt){ut=mt.legendGroup.translateX,ft=mt._legendItemPos[1],vt=mt.movementX,(vt||ht&&mt.ranges)&&(vt=ht?ut-mt.options.maxSize/2:ut+vt,mt.legendGroup.attr({translateX:vt})),bt>lt[gt].step&&gt++,mt.legendGroup.attr({translateY:Math.round(ft+lt[gt].height/2)}),mt._legendItemPos[1]=ft+lt[gt].height/2})}})(BubbleLegendComposition||(BubbleLegendComposition={}));const BubbleLegendComposition$1=BubbleLegendComposition;var __extends$1W=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),ScatterPoint$2=SeriesRegistry$1.seriesTypes.scatter.prototype.pointClass,extend$K=Utilities.extend,BubblePoint=(function(z){__extends$1W(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.options=void 0,a.series=void 0,a}return y.prototype.haloPath=function(a){return Point$4.prototype.haloPath.call(this,a===0?0:(this.marker&&this.marker.radius||0)+a)},y})(ScatterPoint$2);extend$K(BubblePoint.prototype,{ttBelow:!1});var __extends$1V=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),color$9=Color.parse,noop$7=H.noop,_a$b=SeriesRegistry$1.seriesTypes,ColumnSeries$b=_a$b.column,ScatterSeries$3=_a$b.scatter,arrayMax$2=Utilities.arrayMax,arrayMin$2=Utilities.arrayMin,clamp$a=Utilities.clamp,extend$J=Utilities.extend,isNumber$m=Utilities.isNumber,merge$F=Utilities.merge,pick$L=Utilities.pick,pInt$2=Utilities.pInt,BubbleSeries$2=(function(z){__extends$1V(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.data=void 0,a.maxPxSize=void 0,a.minPxSize=void 0,a.options=void 0,a.points=void 0,a.radii=void 0,a.yData=void 0,a.zData=void 0,a}return y.prototype.animate=function(a){!a&&this.points.length<this.options.animationLimit&&this.points.forEach(function(k){var j=k.graphic;j&&j.width&&(this.hasRendered||j.attr({x:k.plotX,y:k.plotY,width:1,height:1}),j.animate(this.markerAttribs(k),this.options.animation))},this)},y.prototype.getRadii=function(a,k,j){var et,it,nt=this.zData,ot=this.yData,at=j.minPxSize,lt=j.maxPxSize,ct=[],ht;for(it=0,et=nt.length;it<et;it++)ht=nt[it],ct.push(this.getRadius(a,k,at,lt,ht,ot[it]));this.radii=ct},y.prototype.getRadius=function(a,k,j,et,it,nt){var ot=this.options,at=ot.sizeBy!=="width",lt=ot.zThreshold,ct=k-a,ht=.5;if(nt===null||it===null)return null;if(isNumber$m(it)){if(ot.sizeByAbsoluteValue&&(it=Math.abs(it-lt),k=ct=Math.max(k-lt,Math.abs(a-lt)),a=0),it<a)return j/2-1;ct>0&&(ht=(it-a)/ct)}return at&&ht>=0&&(ht=Math.sqrt(ht)),Math.ceil(j+ht*(et-j))/2},y.prototype.hasData=function(){return!!this.processedXData.length},y.prototype.pointAttribs=function(a,k){var j=this.options.marker,et=j.fillOpacity,it=Series$f.prototype.pointAttribs.call(this,a,k);return et!==1&&(it.fill=color$9(it.fill).setOpacity(et).get("rgba")),it},y.prototype.translate=function(){var a,k=this.data,j,et,it=this.radii;for(z.prototype.translate.call(this),a=k.length;a--;)j=k[a],et=it?it[a]:0,isNumber$m(et)&&et>=this.minPxSize/2?(j.marker=extend$J(j.marker,{radius:et,width:2*et,height:2*et}),j.dlBox={x:j.plotX-et,y:j.plotY-et,width:2*et,height:2*et}):j.shapeArgs=j.plotY=j.dlBox=void 0},y.compose=BubbleLegendComposition$1.compose,y.defaultOptions=merge$F(ScatterSeries$3.defaultOptions,{dataLabels:{formatter:function(){var a=this.series.chart.numberFormatter,k=this.point.z;return isNumber$m(k)?a(k,-1):""},inside:!0,verticalAlign:"middle"},animationLimit:250,marker:{lineColor:null,lineWidth:1,fillOpacity:.5,radius:null,states:{hover:{radiusPlus:0}},symbol:"circle"},minSize:8,maxSize:"20%",softThreshold:!1,states:{hover:{halo:{size:5}}},tooltip:{pointFormat:"({point.x}, {point.y}), Size: {point.z}"},turboThreshold:0,zThreshold:0,zoneAxis:"z"}),y})(ScatterSeries$3);extend$J(BubbleSeries$2.prototype,{alignDataLabel:ColumnSeries$b.prototype.alignDataLabel,applyZones:noop$7,bubblePadding:!0,buildKDTree:noop$7,directTouch:!0,isBubble:!0,pointArrayMap:["y","z"],pointClass:BubblePoint,parallelArrays:["x","y","z"],trackerGroups:["group","dataLabelsGroup"],specialGroup:"group",zoneAxis:"z"});Axis.prototype.beforePadding=function(){var z=this,y=this.len,a=this.chart,k=0,j=y,et=this.isXAxis,it=et?"xData":"yData",nt=this.min,ot={},at=Math.min(a.plotWidth,a.plotHeight),lt=Number.MAX_VALUE,ct=-Number.MAX_VALUE,ht=this.max-nt,ut=y/ht,ft=[];this.series.forEach(function(vt){var gt=vt.options,mt;vt.bubblePadding&&(vt.visible||!a.options.chart.ignoreHiddenSeries)&&(z.allowZoomOutside=!0,ft.push(vt),et&&(["minSize","maxSize"].forEach(function(bt){var xt=gt[bt],wt=/%$/.test(xt);xt=pInt$2(xt),ot[bt]=wt?at*xt/100:xt}),vt.minPxSize=ot.minSize,vt.maxPxSize=Math.max(ot.maxSize,ot.minSize),mt=vt.zData.filter(isNumber$m),mt.length&&(lt=pick$L(gt.zMin,clamp$a(arrayMin$2(mt),gt.displayNegative===!1?gt.zThreshold:-Number.MAX_VALUE,lt)),ct=pick$L(gt.zMax,Math.max(ct,arrayMax$2(mt))))))}),ft.forEach(function(vt){var gt=vt[it],mt=gt.length,bt;if(et&&vt.getRadii(lt,ct,vt),ht>0)for(;mt--;)isNumber$m(gt[mt])&&z.dataMin<=gt[mt]&&gt[mt]<=z.max&&(bt=vt.radii?vt.radii[mt]:0,k=Math.min((gt[mt]-nt)*ut-bt,k),j=Math.max((gt[mt]-nt)*ut+bt,j))}),ft.length&&ht>0&&!this.logarithmic&&(j-=y,ut*=(y+Math.max(0,k)-Math.min(j,y))/y,[["min","userMin",k],["max","userMax",j]].forEach(function(vt){typeof pick$L(z.options[vt[0]],z[vt[1]])>"u"&&(z[vt[0]]+=vt[2]/ut)}))};SeriesRegistry$1.registerSeriesType("bubble",BubbleSeries$2);var __extends$1U=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),_a$a=SeriesRegistry$1.seriesTypes,ColumnPoint=_a$a.column.prototype.pointClass,AreaRangePoint=_a$a.arearange.prototype.pointClass,extend$I=Utilities.extend,isNumber$l=Utilities.isNumber,ColumnRangePoint=(function(z){__extends$1U(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.series=void 0,a.options=void 0,a.barX=void 0,a.pointWidth=void 0,a.shapeType=void 0,a}return y.prototype.isValid=function(){return isNumber$l(this.low)},y})(AreaRangePoint);extend$I(ColumnRangePoint.prototype,{setState:ColumnPoint.prototype.setState});var __extends$1T=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),noop$6=H.noop,_a$9=SeriesRegistry$1.seriesTypes,AreaRangeSeries$1=_a$9.arearange,ColumnSeries$a=_a$9.column,columnProto$3=ColumnSeries$a.prototype,arearangeProto$1=AreaRangeSeries$1.prototype,clamp$9=Utilities.clamp,merge$E=Utilities.merge,pick$K=Utilities.pick,extend$H=Utilities.extend,columnRangeOptions={pointRange:null,marker:null,states:{hover:{halo:!1}}},ColumnRangeSeries=(function(z){__extends$1T(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.data=void 0,a.points=void 0,a.options=void 0,a}return y.prototype.setOptions=function(){return merge$E(!0,arguments[0],{stacking:void 0}),arearangeProto$1.setOptions.apply(this,arguments)},y.prototype.translate=function(){var a=this,k=a.yAxis,j=a.xAxis,et=j.startAngleRad,it,nt=a.chart,ot=a.xAxis.isRadial,at=Math.max(nt.chartWidth,nt.chartHeight)+999,lt;function ct(ht){return clamp$9(ht,-at,at)}columnProto$3.translate.apply(a),a.points.forEach(function(ht){var ut=ht.shapeArgs||{},ft=a.options.minPointLength,vt,gt,mt;if(ht.plotHigh=lt=ct(k.translate(ht.high,0,1,0,1)),ht.plotLow=ct(ht.plotY),mt=lt,gt=pick$K(ht.rectPlotY,ht.plotY)-lt,Math.abs(gt)<ft?(vt=ft-gt,gt+=vt,mt-=vt/2):gt<0&&(gt*=-1,mt-=gt),ot)it=ht.barX+et,ht.shapeType="arc",ht.shapeArgs=a.polarArc(mt+gt,mt,it,it+ht.pointWidth);else{ut.height=gt,ut.y=mt;var bt=ut.x,xt=bt===void 0?0:bt,wt=ut.width,Mt=wt===void 0?0:wt;ht.tooltipPos=nt.inverted?[k.len+k.pos-nt.plotLeft-mt-gt/2,j.len+j.pos-nt.plotTop-xt-Mt/2,gt]:[j.left-nt.plotLeft+xt+Mt/2,k.pos-nt.plotTop+mt+gt/2,gt]}})},y.prototype.crispCol=function(){return columnProto$3.crispCol.apply(this,arguments)},y.prototype.drawPoints=function(){return columnProto$3.drawPoints.apply(this,arguments)},y.prototype.drawTracker=function(){return columnProto$3.drawTracker.apply(this,arguments)},y.prototype.getColumnMetrics=function(){return columnProto$3.getColumnMetrics.apply(this,arguments)},y.prototype.pointAttribs=function(){return columnProto$3.pointAttribs.apply(this,arguments)},y.prototype.adjustForMissingColumns=function(){return columnProto$3.adjustForMissingColumns.apply(this,arguments)},y.prototype.animate=function(){return columnProto$3.animate.apply(this,arguments)},y.prototype.translate3dPoints=function(){return columnProto$3.translate3dPoints.apply(this,arguments)},y.prototype.translate3dShapes=function(){return columnProto$3.translate3dShapes.apply(this,arguments)},y.defaultOptions=merge$E(ColumnSeries$a.defaultOptions,AreaRangeSeries$1.defaultOptions,columnRangeOptions),y})(AreaRangeSeries$1);extend$H(ColumnRangeSeries.prototype,{directTouch:!0,trackerGroups:["group","dataLabelsGroup"],drawGraph:noop$6,getSymbol:noop$6,polarArc:function(){return columnProto$3.polarArc.apply(this,arguments)},pointClass:ColumnRangePoint});SeriesRegistry$1.registerSeriesType("columnrange",ColumnRangeSeries);var __extends$1S=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),colProto=ColumnSeries$h.prototype,clamp$8=Utilities.clamp,merge$D=Utilities.merge,pick$J=Utilities.pick,ColumnPyramidSeries=(function(z){__extends$1S(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return y.prototype.translate=function(){var a=this,k=a.chart,j=a.options,et=a.dense=a.closestPointRange*a.xAxis.transA<2,it=a.borderWidth=pick$J(j.borderWidth,et?0:1),nt=a.yAxis,ot=j.threshold,at=a.translatedThreshold=nt.getThreshold(ot),lt=pick$J(j.minPointLength,5),ct=a.getColumnMetrics(),ht=ct.width,ut=a.barW=Math.max(ht,1+2*it),ft=a.pointXOffset=ct.offset;k.inverted&&(at-=.5),j.pointPadding&&(ut=Math.ceil(ut)),colProto.translate.apply(a),a.points.forEach(function(vt){var gt=pick$J(vt.yBottom,at),mt=999+Math.abs(gt),bt=clamp$8(vt.plotY,-mt,nt.len+mt),xt=vt.plotX+ft,wt=ut/2,Mt=Math.min(bt,gt),Et=Math.max(bt,gt)-Mt,St,kt,Pt,It,Nt,Ut,Rt,Ft,Dt,Ht,Gt,Yt;vt.barX=xt,vt.pointWidth=ht,vt.tooltipPos=k.inverted?[nt.len+nt.pos-k.plotLeft-bt,a.xAxis.len-xt-wt,Et]:[xt+wt,bt+nt.pos-k.plotTop,Et],St=ot+(vt.total||vt.y),j.stacking==="percent"&&(St=ot+(vt.y<0)?-100:100),Pt=nt.toPixels(St,!0),kt=k.plotHeight-Pt-(k.plotHeight-at),It=kt?wt*(Mt-Pt)/kt:0,Nt=kt?wt*(Mt+Et-Pt)/kt:0,Rt=xt-It+wt,Ft=xt+It+wt,Dt=xt+Nt+wt,Ht=xt-Nt+wt,Gt=Mt-lt,Yt=Mt+Et,vt.y<0&&(Gt=Mt,Yt=Mt+Et+lt),k.inverted&&(Ut=k.plotWidth-Mt,kt=Pt-(k.plotWidth-at),It=wt*(Pt-Ut)/kt,Nt=wt*(Pt-(Ut-Et))/kt,Rt=xt+wt+It,Ft=Rt-2*It,Dt=xt-Nt+wt,Ht=xt+Nt+wt,Gt=Mt,Yt=Mt+Et-lt,vt.y<0&&(Yt=Mt+Et+lt)),vt.shapeType="path",vt.shapeArgs={x:Rt,y:Gt,width:Ft-Rt,height:Et,d:[["M",Rt,Gt],["L",Ft,Gt],["L",Dt,Yt],["L",Ht,Yt],["Z"]]}})},y.defaultOptions=merge$D(ColumnSeries$h.defaultOptions,{}),y})(ColumnSeries$h);SeriesRegistry$1.registerSeriesType("columnpyramid",ColumnPyramidSeries);var __extends$1R=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),AreaRangeSeries=SeriesRegistry$1.seriesTypes.arearange,merge$C=Utilities.merge,extend$G=Utilities.extend,ErrorBarSeries=(function(z){__extends$1R(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return y.prototype.getColumnMetrics=function(){return this.linkedParent&&this.linkedParent.columnMetrics||ColumnSeries$h.prototype.getColumnMetrics.call(this)},y.prototype.drawDataLabels=function(){var a=this.pointValKey;AreaRangeSeries&&(AreaRangeSeries.prototype.drawDataLabels.call(this),this.data.forEach(function(k){k.y=k[a]}))},y.prototype.toYData=function(a){return[a.low,a.high]},y.defaultOptions=merge$C(BoxPlotSeries.defaultOptions,{color:palette.neutralColor100,grouping:!1,linkedTo:":previous",tooltip:{pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.low}</b> - <b>{point.high}</b><br/>'},whiskerWidth:null}),y})(BoxPlotSeries);extend$G(ErrorBarSeries.prototype,{pointArrayMap:["low","high"],pointValKey:"high",doQuartiles:!1});SeriesRegistry$1.registerSeriesType("errorbar",ErrorBarSeries);var __extends$1Q=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),Point$3=SeriesRegistry$1.series.prototype.pointClass,GaugePoint=(function(z){__extends$1Q(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.options=void 0,a.series=void 0,a.shapeArgs=void 0,a}return y.prototype.setState=function(a){this.state=a},y})(Point$3),__extends$1P=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),noop$5=H.noop,Series$b=SeriesRegistry$1.series,ColumnSeries$9=SeriesRegistry$1.seriesTypes.column,clamp$7=Utilities.clamp,isNumber$k=Utilities.isNumber,extend$F=Utilities.extend,merge$B=Utilities.merge,pick$I=Utilities.pick,pInt$1=Utilities.pInt,GaugeSeries$1=(function(z){__extends$1P(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.data=void 0,a.points=void 0,a.options=void 0,a.yAxis=void 0,a}return y.prototype.translate=function(){var a=this,k=a.yAxis,j=a.options,et=k.center;a.generatePoints(),a.points.forEach(function(it){var nt=merge$B(j.dial,it.dial),ot=pInt$1(pick$I(nt.radius,"80%"))*et[2]/200,at=pInt$1(pick$I(nt.baseLength,"70%"))*ot/100,lt=pInt$1(pick$I(nt.rearLength,"10%"))*ot/100,ct=nt.baseWidth||3,ht=nt.topWidth||1,ut=j.overshoot,ft=k.startAngleRad+k.translate(it.y,null,null,null,!0);(isNumber$k(ut)||j.wrap===!1)&&(ut=isNumber$k(ut)?ut/180*Math.PI:0,ft=clamp$7(ft,k.startAngleRad-ut,k.endAngleRad+ut)),ft=ft*180/Math.PI,it.shapeType="path";var vt=nt.path||[["M",-lt,-ct/2],["L",at,-ct/2],["L",ot,-ht/2],["L",ot,ht/2],["L",at,ct/2],["L",-lt,ct/2],["Z"]];it.shapeArgs={d:vt,translateX:et[0],translateY:et[1],rotation:ft},it.plotX=et[0],it.plotY=et[1]})},y.prototype.drawPoints=function(){var a=this,k=a.chart,j=a.yAxis.center,et=a.pivot,it=a.options,nt=it.pivot,ot=k.renderer;a.points.forEach(function(at){var lt=at.graphic,ct=at.shapeArgs,ht=ct.d,ut=merge$B(it.dial,at.dial);lt?(lt.animate(ct),ct.d=ht):at.graphic=ot[at.shapeType](ct).attr({rotation:ct.rotation,zIndex:1}).addClass("highcharts-dial").add(a.group),k.styledMode||at.graphic[lt?"animate":"attr"]({stroke:ut.borderColor||"none","stroke-width":ut.borderWidth||0,fill:ut.backgroundColor||palette.neutralColor100})}),et?et.animate({translateX:j[0],translateY:j[1]}):(a.pivot=ot.circle(0,0,pick$I(nt.radius,5)).attr({zIndex:2}).addClass("highcharts-pivot").translate(j[0],j[1]).add(a.group),k.styledMode||a.pivot.attr({"stroke-width":nt.borderWidth||0,stroke:nt.borderColor||palette.neutralColor20,fill:nt.backgroundColor||palette.neutralColor100}))},y.prototype.animate=function(a){var k=this;a||k.points.forEach(function(j){var et=j.graphic;et&&(et.attr({rotation:k.yAxis.startAngleRad*180/Math.PI}),et.animate({rotation:j.shapeArgs.rotation},k.options.animation))})},y.prototype.render=function(){this.group=this.plotGroup("group","series",this.visible?"visible":"hidden",this.options.zIndex,this.chart.seriesGroup),Series$b.prototype.render.call(this),this.group.clip(this.chart.clipRect)},y.prototype.setData=function(a,k){Series$b.prototype.setData.call(this,a,!1),this.processData(),this.generatePoints(),pick$I(k,!0)&&this.chart.redraw()},y.prototype.hasData=function(){return!!this.points.length},y.defaultOptions=merge$B(Series$b.defaultOptions,{dataLabels:{borderColor:palette.neutralColor20,borderRadius:3,borderWidth:1,crop:!1,defer:!1,enabled:!0,verticalAlign:"top",y:15,zIndex:2},dial:{},pivot:{},tooltip:{headerFormat:""},showInLegend:!1}),y})(Series$b);extend$F(GaugeSeries$1.prototype,{angular:!0,directTouch:!0,drawGraph:noop$5,drawTracker:ColumnSeries$9.prototype.drawTracker,fixedBox:!0,forceDL:!0,noSharedTooltip:!0,pointClass:GaugePoint,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("gauge",GaugeSeries$1);var __extends$1O=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),BubbleSeries$1=SeriesRegistry$1.seriesTypes.bubble,PackedBubblePoint=(function(z){__extends$1O(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.degree=NaN,a.mass=NaN,a.radius=NaN,a.options=void 0,a.series=void 0,a.value=null,a}return y.prototype.destroy=function(){return this.series.layout&&this.series.layout.removeElementFromCollection(this,this.series.layout.nodes),Point$4.prototype.destroy.apply(this,arguments)},y.prototype.firePointEvent=function(){var a=this.series,k=a.options;if(this.isParentNode&&k.parentNode){var j=k.allowPointSelect;k.allowPointSelect=k.parentNode.allowPointSelect,Point$4.prototype.firePointEvent.apply(this,arguments),k.allowPointSelect=j}else Point$4.prototype.firePointEvent.apply(this,arguments)},y.prototype.select=function(){var a=this,k=this.series,j=k.chart;a.isParentNode?(j.getSelectedPoints=j.getSelectedParentNodes,Point$4.prototype.select.apply(this,arguments),j.getSelectedPoints=Chart$1.prototype.getSelectedPoints):Point$4.prototype.select.apply(this,arguments)},y})(BubbleSeries$1.prototype.pointClass),addEvent$u=Utilities.addEvent;H.dragNodesMixin={onMouseDown:function(z,y){var a=this.chart.pointer.normalize(y);z.fixedPosition={chartX:a.chartX,chartY:a.chartY,plotX:z.plotX,plotY:z.plotY},z.inDragMode=!0},onMouseMove:function(z,y){if(z.fixedPosition&&z.inDragMode){var a=this,k=a.chart,j=k.pointer.normalize(y),et=z.fixedPosition.chartX-j.chartX,it=z.fixedPosition.chartY-j.chartY,nt=void 0,ot=void 0,at=k.graphLayoutsLookup;(Math.abs(et)>5||Math.abs(it)>5)&&(nt=z.fixedPosition.plotX-et,ot=z.fixedPosition.plotY-it,k.isInsidePlot(nt,ot)&&(z.plotX=nt,z.plotY=ot,z.hasDragged=!0,this.redrawHalo(z),at.forEach(function(lt){lt.restartSimulation()})))}},onMouseUp:function(z,y){z.fixedPosition&&(z.hasDragged&&(this.layout.enableSimulation?this.layout.start():this.chart.redraw()),z.inDragMode=z.hasDragged=!1,this.options.fixedDraggable||delete z.fixedPosition)},redrawHalo:function(z){z&&this.halo&&this.halo.attr({d:z.haloPath(this.options.states.hover.halo.size)})}};addEvent$u(Chart$1,"load",function(){var z=this,y,a,k;z.container&&(y=addEvent$u(z.container,"mousedown",function(j){var et=z.hoverPoint;et&&et.series&&et.series.hasDraggableNodes&&et.series.options.draggable&&(et.series.onMouseDown(et,j),a=addEvent$u(z.container,"mousemove",function(it){return et&&et.series&&et.series.onMouseMove(et,it)}),k=addEvent$u(z.container.ownerDocument,"mouseup",function(it){return a(),k(),et&&et.series&&et.series.onMouseUp(et,it)}))})),addEvent$u(z,"destroy",function(){y()})});H.networkgraphIntegrations={verlet:{attractiveForceFunction:function(z,y){return(y-z)/z},repulsiveForceFunction:function(z,y){return(y-z)/z*(y>z?1:0)},barycenter:function(){var z=this.options.gravitationalConstant,y=this.barycenter.xFactor,a=this.barycenter.yFactor;y=(y-(this.box.left+this.box.width)/2)*z,a=(a-(this.box.top+this.box.height)/2)*z,this.nodes.forEach(function(k){k.fixedPosition||(k.plotX-=y/k.mass/k.degree,k.plotY-=a/k.mass/k.degree)})},repulsive:function(z,y,a){var k=y*this.diffTemperature/z.mass/z.degree;z.fixedPosition||(z.plotX+=a.x*k,z.plotY+=a.y*k)},attractive:function(z,y,a){var k=z.getMass(),j=-a.x*y*this.diffTemperature,et=-a.y*y*this.diffTemperature;z.fromNode.fixedPosition||(z.fromNode.plotX-=j*k.fromNode/z.fromNode.degree,z.fromNode.plotY-=et*k.fromNode/z.fromNode.degree),z.toNode.fixedPosition||(z.toNode.plotX+=j*k.toNode/z.toNode.degree,z.toNode.plotY+=et*k.toNode/z.toNode.degree)},integrate:function(z,y){var a=-z.options.friction,k=z.options.maxSpeed,j=y.prevX,et=y.prevY,it=(y.plotX+y.dispX-j)*a,nt=(y.plotY+y.dispY-et)*a,ot=Math.abs,at=ot(it)/(it||1),lt=ot(nt)/(nt||1);it=at*Math.min(k,Math.abs(it)),nt=lt*Math.min(k,Math.abs(nt)),y.prevX=y.plotX+y.dispX,y.prevY=y.plotY+y.dispY,y.plotX+=it,y.plotY+=nt,y.temperature=z.vectorLength({x:it,y:nt})},getK:function(z){return Math.pow(z.box.width*z.box.height/z.nodes.length,.5)}},euler:{attractiveForceFunction:function(z,y){return z*z/y},repulsiveForceFunction:function(z,y){return y*y/z},barycenter:function(){var z=this.options.gravitationalConstant,y=this.barycenter.xFactor,a=this.barycenter.yFactor;this.nodes.forEach(function(k){if(!k.fixedPosition){var j=k.getDegree(),et=j*(1+j/2);k.dispX+=(y-k.plotX)*z*et/k.degree,k.dispY+=(a-k.plotY)*z*et/k.degree}})},repulsive:function(z,y,a,k){z.dispX+=a.x/k*y/z.degree,z.dispY+=a.y/k*y/z.degree},attractive:function(z,y,a,k){var j=z.getMass(),et=a.x/k*y,it=a.y/k*y;z.fromNode.fixedPosition||(z.fromNode.dispX-=et*j.fromNode/z.fromNode.degree,z.fromNode.dispY-=it*j.fromNode/z.fromNode.degree),z.toNode.fixedPosition||(z.toNode.dispX+=et*j.toNode/z.toNode.degree,z.toNode.dispY+=it*j.toNode/z.toNode.degree)},integrate:function(z,y){var a;y.dispX+=y.dispX*z.options.friction,y.dispY+=y.dispY*z.options.friction,a=y.temperature=z.vectorLength({x:y.dispX,y:y.dispY}),a!==0&&(y.plotX+=y.dispX/a*Math.min(Math.abs(y.dispX),z.temperature),y.plotY+=y.dispY/a*Math.min(Math.abs(y.dispY),z.temperature))},getK:function(z){return Math.pow(z.box.width*z.box.height/z.nodes.length,.3)}}};var extend$E=Utilities.extend,QuadTreeNode=H.QuadTreeNode=function(z){this.box=z,this.boxSize=Math.min(z.width,z.height),this.nodes=[],this.isInternal=!1,this.body=!1,this.isEmpty=!0};extend$E(QuadTreeNode.prototype,{insert:function(z,y){var a;this.isInternal?this.nodes[this.getBoxPosition(z)].insert(z,y-1):(this.isEmpty=!1,this.body?y?(this.isInternal=!0,this.divideBox(),this.body!==!0&&(this.nodes[this.getBoxPosition(this.body)].insert(this.body,y-1),this.body=!0),this.nodes[this.getBoxPosition(z)].insert(z,y-1)):(a=new QuadTreeNode({top:z.plotX,left:z.plotY,width:.1,height:.1}),a.body=z,a.isInternal=!1,this.nodes.push(a)):(this.isInternal=!1,this.body=z))},updateMassAndCenter:function(){var z=0,y=0,a=0;this.isInternal?(this.nodes.forEach(function(k){k.isEmpty||(z+=k.mass,y+=k.plotX*k.mass,a+=k.plotY*k.mass)}),y/=z,a/=z):this.body&&(z=this.body.mass,y=this.body.plotX,a=this.body.plotY),this.mass=z,this.plotX=y,this.plotY=a},divideBox:function(){var z=this.box.width/2,y=this.box.height/2;this.nodes[0]=new QuadTreeNode({left:this.box.left,top:this.box.top,width:z,height:y}),this.nodes[1]=new QuadTreeNode({left:this.box.left+z,top:this.box.top,width:z,height:y}),this.nodes[2]=new QuadTreeNode({left:this.box.left+z,top:this.box.top+y,width:z,height:y}),this.nodes[3]=new QuadTreeNode({left:this.box.left,top:this.box.top+y,width:z,height:y})},getBoxPosition:function(z){var y=z.plotX<this.box.left+this.box.width/2,a=z.plotY<this.box.top+this.box.height/2,k;return y?a?k=0:k=3:a?k=1:k=2,k}});var QuadTree=H.QuadTree=function(z,y,a,k){this.box={left:z,top:y,width:a,height:k},this.maxDepth=25,this.root=new QuadTreeNode(this.box,"0"),this.root.isInternal=!0,this.root.isRoot=!0,this.root.divideBox()};extend$E(QuadTree.prototype,{insertNodes:function(z){z.forEach(function(y){this.root.insert(y,this.maxDepth)},this)},visitNodeRecursive:function(z,y,a){var k;z||(z=this.root),z===this.root&&y&&(k=y(z)),k!==!1&&(z.nodes.forEach(function(j){if(j.isInternal){if(y&&(k=y(j)),k===!1)return;this.visitNodeRecursive(j,y,a)}else j.body&&y&&y(j.body);a&&a(j)},this),z===this.root&&a&&a(z))},calculateMassAndCenter:function(){this.visitNodeRecursive(null,null,function(z){z.updateMassAndCenter()})}});var setAnimation=animationExports.setAnimation,addEvent$t=Utilities.addEvent,clamp$6=Utilities.clamp,defined$i=Utilities.defined,extend$D=Utilities.extend,isFunction=Utilities.isFunction,pick$H=Utilities.pick;H.layouts={"reingold-fruchterman":function(){}};extend$D(H.layouts["reingold-fruchterman"].prototype,{init:function(z){this.options=z,this.nodes=[],this.links=[],this.series=[],this.box={x:0,y:0,width:0,height:0},this.setInitialRendering(!0),this.integration=H.networkgraphIntegrations[z.integration],this.enableSimulation=z.enableSimulation,this.attractiveForce=pick$H(z.attractiveForce,this.integration.attractiveForceFunction),this.repulsiveForce=pick$H(z.repulsiveForce,this.integration.repulsiveForceFunction),this.approximation=z.approximation},updateSimulation:function(z){this.enableSimulation=pick$H(z,this.options.enableSimulation)},start:function(){var z=this,y=this.series,a=this.options;z.currentStep=0,z.forces=y[0]&&y[0].forces||[],z.chart=y[0]&&y[0].chart,z.initialRendering&&(z.initPositions(),y.forEach(function(k){k.finishedAnimating=!0,k.render()})),z.setK(),z.resetSimulation(a),z.enableSimulation&&z.step()},step:function(){var z=this,y=this.series;this.options,z.currentStep++,z.approximation==="barnes-hut"&&(z.createQuadTree(),z.quadTree.calculateMassAndCenter()),z.forces.forEach(function(a){z[a+"Forces"](z.temperature)}),z.applyLimits(z.temperature),z.temperature=z.coolDown(z.startTemperature,z.diffTemperature,z.currentStep),z.prevSystemTemperature=z.systemTemperature,z.systemTemperature=z.getSystemTemperature(),z.enableSimulation&&(y.forEach(function(a){a.chart&&a.render()}),z.maxIterations--&&isFinite(z.temperature)&&!z.isStable()?(z.simulation&&H.win.cancelAnimationFrame(z.simulation),z.simulation=H.win.requestAnimationFrame(function(){z.step()})):z.simulation=!1)},stop:function(){this.simulation&&H.win.cancelAnimationFrame(this.simulation)},setArea:function(z,y,a,k){this.box={left:z,top:y,width:a,height:k}},setK:function(){this.k=this.options.linkLength||this.integration.getK(this)},addElementsToCollection:function(z,y){z.forEach(function(a){y.indexOf(a)===-1&&y.push(a)})},removeElementFromCollection:function(z,y){var a=y.indexOf(z);a!==-1&&y.splice(a,1)},clear:function(){this.nodes.length=0,this.links.length=0,this.series.length=0,this.resetSimulation()},resetSimulation:function(){this.forcedStop=!1,this.systemTemperature=0,this.setMaxIterations(),this.setTemperature(),this.setDiffTemperature()},restartSimulation:function(){this.simulation?this.resetSimulation():(this.setInitialRendering(!1),this.enableSimulation?this.start():this.setMaxIterations(1),this.chart&&this.chart.redraw(),this.setInitialRendering(!0))},setMaxIterations:function(z){this.maxIterations=pick$H(z,this.options.maxIterations)},setTemperature:function(){this.temperature=this.startTemperature=Math.sqrt(this.nodes.length)},setDiffTemperature:function(){this.diffTemperature=this.startTemperature/(this.options.maxIterations+1)},setInitialRendering:function(z){this.initialRendering=z},createQuadTree:function(){this.quadTree=new H.QuadTree(this.box.left,this.box.top,this.box.width,this.box.height),this.quadTree.insertNodes(this.nodes)},initPositions:function(){var z=this.options.initialPositions;isFunction(z)?(z.call(this),this.nodes.forEach(function(y){defined$i(y.prevX)||(y.prevX=y.plotX),defined$i(y.prevY)||(y.prevY=y.plotY),y.dispX=0,y.dispY=0})):z==="circle"?this.setCircularPositions():this.setRandomPositions()},setCircularPositions:function(){var z=this.box,y=this.nodes,a=y.length+1,k=2*Math.PI/a,j=y.filter(function(at){return at.linksTo.length===0}),et=[],it={},nt=this.options.initialPositionRadius;function ot(at){at.linksFrom.forEach(function(lt){it[lt.toNode.id]||(it[lt.toNode.id]=!0,et.push(lt.toNode),ot(lt.toNode))})}j.forEach(function(at){et.push(at),ot(at)}),et.length?y.forEach(function(at){et.indexOf(at)===-1&&et.push(at)}):et=y,et.forEach(function(at,lt){at.plotX=at.prevX=pick$H(at.plotX,z.width/2+nt*Math.cos(lt*k)),at.plotY=at.prevY=pick$H(at.plotY,z.height/2+nt*Math.sin(lt*k)),at.dispX=0,at.dispY=0})},setRandomPositions:function(){var z=this.box,y=this.nodes,a=y.length+1;function k(j){var et=j*j/Math.PI;return et=et-Math.floor(et),et}y.forEach(function(j,et){j.plotX=j.prevX=pick$H(j.plotX,z.width*k(et)),j.plotY=j.prevY=pick$H(j.plotY,z.height*k(a+et)),j.dispX=0,j.dispY=0})},force:function(z){this.integration[z].apply(this,Array.prototype.slice.call(arguments,1))},barycenterForces:function(){this.getBarycenter(),this.force("barycenter")},getBarycenter:function(){var z=0,y=0,a=0;return this.nodes.forEach(function(k){y+=k.plotX*k.mass,a+=k.plotY*k.mass,z+=k.mass}),this.barycenter={x:y,y:a,xFactor:y/z,yFactor:a/z},this.barycenter},barnesHutApproximation:function(z,y){var a=this,k=a.getDistXY(z,y),j=a.vectorLength(k),et,it;return z!==y&&j!==0&&(y.isInternal?y.boxSize/j<a.options.theta&&j!==0?(it=a.repulsiveForce(j,a.k),a.force("repulsive",z,it*y.mass,k,j),et=!1):et=!0:(it=a.repulsiveForce(j,a.k),a.force("repulsive",z,it*y.mass,k,j))),et},repulsiveForces:function(){var z=this;z.approximation==="barnes-hut"?z.nodes.forEach(function(y){z.quadTree.visitNodeRecursive(null,function(a){return z.barnesHutApproximation(y,a)})}):z.nodes.forEach(function(y){z.nodes.forEach(function(a){var k,j,et;y!==a&&!y.fixedPosition&&(et=z.getDistXY(y,a),j=z.vectorLength(et),j!==0&&(k=z.repulsiveForce(j,z.k),z.force("repulsive",y,k*a.mass,et,j)))})})},attractiveForces:function(){var z=this,y,a,k;z.links.forEach(function(j){j.fromNode&&j.toNode&&(y=z.getDistXY(j.fromNode,j.toNode),a=z.vectorLength(y),a!==0&&(k=z.attractiveForce(a,z.k),z.force("attractive",j,k,y,a)))})},applyLimits:function(){var z=this,y=z.nodes;y.forEach(function(a){a.fixedPosition||(z.integration.integrate(z,a),z.applyLimitBox(a,z.box),a.dispX=0,a.dispY=0)})},applyLimitBox:function(z,y){var a=z.radius;z.plotX=clamp$6(z.plotX,y.left+a,y.width-a),z.plotY=clamp$6(z.plotY,y.top+a,y.height-a)},coolDown:function(z,y,a){return z-y*a},isStable:function(){return Math.abs(this.systemTemperature-this.prevSystemTemperature)<1e-5||this.temperature<=0},getSystemTemperature:function(){return this.nodes.reduce(function(z,y){return z+y.temperature},0)},vectorLength:function(z){return Math.sqrt(z.x*z.x+z.y*z.y)},getDistR:function(z,y){var a=this.getDistXY(z,y);return this.vectorLength(a)},getDistXY:function(z,y){var a=z.plotX-y.plotX,k=z.plotY-y.plotY;return{x:a,y:k,absX:Math.abs(a),absY:Math.abs(k)}}});addEvent$t(Chart$1,"predraw",function(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(z){z.stop()})});addEvent$t(Chart$1,"render",function(){var z,y=!1;function a(k){k.maxIterations--&&isFinite(k.temperature)&&!k.isStable()&&!k.enableSimulation&&(k.beforeStep&&k.beforeStep(),k.step(),z=!1,y=!0)}if(this.graphLayoutsLookup){for(setAnimation(!1,this),this.graphLayoutsLookup.forEach(function(k){k.start()});!z;)z=!0,this.graphLayoutsLookup.forEach(a);y&&this.series.forEach(function(k){k&&k.layout&&k.render()})}});addEvent$t(Chart$1,"beforePrint",function(){this.graphLayoutsLookup&&(this.graphLayoutsLookup.forEach(function(z){z.updateSimulation(!1)}),this.redraw())});addEvent$t(Chart$1,"afterPrint",function(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(z){z.updateSimulation()}),this.redraw()});var Reingold=H.layouts["reingold-fruchterman"],addEvent$s=Utilities.addEvent,extendClass=Utilities.extendClass,pick$G=Utilities.pick;Chart$1.prototype.getSelectedParentNodes=function(){var z=this,y=z.series,a=[];return y.forEach(function(k){k.parentNode&&k.parentNode.selected&&a.push(k.parentNode)}),a};H.networkgraphIntegrations.packedbubble={repulsiveForceFunction:function(z,y,a,k){return Math.min(z,(a.marker.radius+k.marker.radius)/2)},barycenter:function(){var z=this,y=z.options.gravitationalConstant,a=z.box,k=z.nodes,j,et;k.forEach(function(it){z.options.splitSeries&&!it.isParentNode?(j=it.series.parentNode.plotX,et=it.series.parentNode.plotY):(j=a.width/2,et=a.height/2),it.fixedPosition||(it.plotX-=(it.plotX-j)*y/(it.mass*Math.sqrt(k.length)),it.plotY-=(it.plotY-et)*y/(it.mass*Math.sqrt(k.length)))})},repulsive:function(z,y,a,k){var j=y*this.diffTemperature/z.mass/z.degree,et=a.x*j,it=a.y*j;z.fixedPosition||(z.plotX+=et,z.plotY+=it),k.fixedPosition||(k.plotX-=et,k.plotY-=it)},integrate:H.networkgraphIntegrations.verlet.integrate,getK:H.noop};H.layouts.packedbubble=extendClass(Reingold,{beforeStep:function(){this.options.marker&&this.series.forEach(function(z){z&&z.calculateParentRadius()})},isStable:function(){var z=Math.abs(this.prevSystemTemperature-this.systemTemperature),y=10*this.systemTemperature/Math.sqrt(this.nodes.length);return Math.abs(y)<1&&z<1e-5||this.temperature<=0},setCircularPositions:function(){var z=this,y=z.box,a=z.nodes,k=a.length+1,j=2*Math.PI/k,et,it,nt=z.options.initialPositionRadius;a.forEach(function(ot,at){z.options.splitSeries&&!ot.isParentNode?(et=ot.series.parentNode.plotX,it=ot.series.parentNode.plotY):(et=y.width/2,it=y.height/2),ot.plotX=ot.prevX=pick$G(ot.plotX,et+nt*Math.cos(ot.index||at*j)),ot.plotY=ot.prevY=pick$G(ot.plotY,it+nt*Math.sin(ot.index||at*j)),ot.dispX=0,ot.dispY=0})},repulsiveForces:function(){var z=this,y,a,k,j=z.options.bubblePadding;z.nodes.forEach(function(et){et.degree=et.mass,et.neighbours=0,z.nodes.forEach(function(it){y=0,et!==it&&!et.fixedPosition&&(z.options.seriesInteraction||et.series===it.series)&&(k=z.getDistXY(et,it),a=z.vectorLength(k)-(et.marker.radius+it.marker.radius+j),a<0&&(et.degree+=.01,et.neighbours++,y=z.repulsiveForce(-a/Math.sqrt(et.neighbours),z.k,et,it)),z.force("repulsive",et,y*it.mass,k,it,a))})})},applyLimitBox:function(z){var y=this,a,k,j=.01;y.options.splitSeries&&!z.isParentNode&&y.options.parentNodeLimit&&(a=y.getDistXY(z,z.series.parentNode),k=z.series.parentNodeRadius-z.marker.radius-y.vectorLength(a),k<0&&k>-2*z.marker.radius&&(z.plotX-=a.x*j,z.plotY-=a.y*j)),Reingold.prototype.applyLimitBox.apply(this,arguments)}});addEvent$s(Chart$1,"beforeRedraw",function(){this.allDataPoints&&delete this.allDataPoints});var __extends$1N=(function(){var z=function(y,a){return z=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,j){k.__proto__=j}||function(k,j){for(var et in j)j.hasOwnProperty(et)&&(k[et]=j[et])},z(y,a)};return function(y,a){z(y,a);function k(){this.constructor=y}y.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}})(),color$8=Color.parse,Series$a=SeriesRegistry$1.series,BubbleSeries=SeriesRegistry$1.seriesTypes.bubble,addEvent$r=Utilities.addEvent,clamp$5=Utilities.clamp,defined$h=Utilities.defined,extend$C=Utilities.extend,fireEvent$7=Utilities.fireEvent,isArray$7=Utilities.isArray,isNumber$j=Utilities.isNumber,merge$A=Utilities.merge,pick$F=Utilities.pick,dragNodesMixin=H.dragNodesMixin,PackedBubbleSeries=(function(z){__extends$1N(y,z);function y(){var a=z!==null&&z.apply(this,arguments)||this;return a.chart=void 0,a.data=void 0,a.layout=void 0,a.options=void 0,a.points=void 0,a.xData=void 0,a}return y.prototype.accumulateAllPoints=function(a){var k=a.chart,j=[],et,it;for(et=0;et<k.series.length;et++)if(a=k.series[et],a.is("packedbubble")&&a.visible||!k.options.chart.ignoreHiddenSeries)for(it=0;it<a.yData.length;it++)j.push([null,null,a.yData[it],a.index,it,{id:it,marker:{radius:0}}]);return j},y.prototype.addLayout=function(){var a=this,k=a.options.layoutAlgorithm,j=a.chart.graphLayoutsStorage,et=a.chart.graphLayoutsLookup,it=a.chart.options.chart,nt;j||(a.chart.graphLayoutsStorage=j={},a.chart.graphLayoutsLookup=et=[]),nt=j[k.type],nt||(k.enableSimulation=defined$h(it.forExport)?!it.forExport:k.enableSimulation,j[k.type]=nt=new H.layouts[k.type],nt.init(k),et.splice(nt.index,0,nt)),a.layout=nt,a.points.forEach(function(ot){ot.mass=2,ot.degree=1,ot.collisionNmb=1}),nt.setArea(0,0,a.chart.plotWidth,a.chart.plotHeight),nt.addElementsToCollection([a],nt.series),nt.addElementsToCollection(a.points,nt.nodes)},y.prototype.addSeriesLayout=function(){var a=this,k=a.options.layoutAlgorithm,j=a.chart.graphLayoutsStorage,et=a.chart.graphLayoutsLookup,it=merge$A(k,k.parentNodeOptions,{enableSimulation:a.layout.options.enableSimulation}),nt;nt=j[k.type+"-series"],nt||(j[k.type+"-series"]=nt=new H.layouts[k.type],nt.init(it),et.splice(nt.index,0,nt)),a.parentNodeLayout=nt,this.createParentNodes()},y.prototype.calculateParentRadius=function(){var a=this,k,j=20,et=20;k=a.seriesBox(),a.parentNodeRadius=clamp$5(Math.sqrt(2*a.parentNodeMass/Math.PI)+j,et,k?Math.max(Math.sqrt(Math.pow(k.width,2)+Math.pow(k.height,2))/2+j,et):Math.sqrt(2*a.parentNodeMass/Math.PI)+j),a.parentNode&&(a.parentNode.marker.radius=a.parentNode.radius=a.parentNodeRadius)},y.prototype.calculateZExtremes=function(){var a=this.chart,k=this.options.zMin,j=this.options.zMax,et=1/0,it=-1/0;return k&&j?[k,j]:(a.series.forEach(function(nt){nt.yData.forEach(function(ot){defined$h(ot)&&(ot>it&&(it=ot),ot<et&&(et=ot))})}),k=pick$F(k,et),j=pick$F(j,it),[k,j])},y.prototype.checkOverlap=function(a,k){var j=a[0]-k[0],et=a[1]-k[1],it=a[2]+k[2];return Math.sqrt(j*j+et*et)-Math.abs(it)<-.001},y.prototype.createParentNodes=function(){var a=this,k=a.chart,j=a.parentNodeLayout,et,it=a.parentNode,nt=a.pointClass;a.parentNodeMass=0,a.points.forEach(function(ot){a.parentNodeMass+=Math.PI*Math.pow(ot.marker.radius,2)}),a.calculateParentRadius(),j.nodes.forEach(function(ot){ot.seriesIndex===a.index&&(et=!0)}),j.setArea(0,0,k.plotWidth,k.plotHeight),et||(it||(it=new nt().init(this,{mass:a.parentNodeRadius/2,marker:{radius:a.parentNodeRadius},dataLabels:{inside:!1},dataLabelOnNull:!0,degree:a.parentNodeRadius,isParentNode:!0,seriesIndex:a.index})),a.parentNode&&(it.plotX=a.parentNode.plotX,it.plotY=a.parentNode.plotY),a.parentNode=it,j.addElementsToCollection([a],j.series),j.addElementsToCollection([it],j.nodes))},y.prototype.deferLayout=function(){var a=this,k=a.options.layoutAlgorithm;a.visible&&(a.addLayout(),k.splitSeries&&a.addSeriesLayout())},y.prototype.destroy=function(){this.chart.graphLayoutsLookup&&this.chart.graphLayoutsLookup.forEach(function(a){a.removeElementFromCollection(this,a.series)},this),this.parentNode&&this.parentNodeLayout&&(this.parentNodeLayout.removeElementFromCollection(this.parentNode,this.parentNodeLayout.nodes),this.parentNode.dataLabel&&(this.parentNode.dataLabel=this.parentNode.dataLabel.destroy())),Series$a.prototype.destroy.apply(this,arguments)},y.prototype.drawDataLabels=function(){var a=this.options.dataLabels.textPath,k=this.points;Series$a.prototype.drawDataLabels.apply(this,arguments),this.parentNode&&(this.parentNode.formatPrefix="parentNode",this.points=[this.parentNode],this.options.dataLabels.textPath=this.options.dataLabels.parentNodeTextPath,Series$a.prototype.drawDataLabels.apply(this,arguments),this.points=k,this.options.dataLabels.textPath=a)},y.prototype.drawGraph=function(){if(!(!this.layout||!this.layout.options.splitSeries)){var a=this,k=a.chart,j={},et=this.layout.options.parentNodeOptions.marker,it={fill:et.fillColor||color$8(a.color).brighten(.4).get(),opacity:et.fillOpacity,stroke:et.lineColor||a.color,"stroke-width":et.lineWidth};this.parentNodesGroup||(a.parentNodesGroup=a.plotGroup("parentNodesGroup","parentNode",a.visible?"inherit":"hidden",.1,k.seriesGroup),a.group.attr({zIndex:2})),this.calculateParentRadius(),j=merge$A({x:a.parentNode.plotX-a.parentNodeRadius,y:a.parentNode.plotY-a.parentNodeRadius,width:a.parentNodeRadius*2,height:a.parentNodeRadius*2},it),a.parentNode.graphic||(a.graph=a.parentNode.graphic=k.renderer.symbol(it.symbol).add(a.parentNodesGroup)),a.parentNode.graphic.attr(j)}},y.prototype.drawTracker=function(){var a=this,k=a.parentNode,j;z.prototype.drawTracker.call(this),k&&(j=isArray$7(k.dataLabels)?k.dataLabels:k.dataLabel?[k.dataLabel]:[],k.graphic&&(k.graphic.element.point=k),j.forEach(function(et){et.div?et.div.point=k:et.element.point=k}))},y.prototype.getPointRadius=function(){var a=this,k=a.chart,j=k.plotWidth,et=k.plotHeight,it=a.options,nt=it.useSimulation,ot=Math.min(j,et),at={},lt=[],ct=k.allDataPoints,ht,ut,ft,vt,gt;["minSize","maxSize"].forEach(function(mt){var bt=parseInt(it[mt],10),xt=/%$/.test(it[mt]);at[mt]=xt?ot*bt/100:bt*Math.sqrt(ct.length)}),k.minRadius=ht=at.minSize/Math.sqrt(ct.length),k.maxRadius=ut=at.maxSize/Math.sqrt(ct.length),gt=nt?a.calculateZExtremes():[ht,ut],(ct||[]).forEach(function(mt,bt){ft=nt?clamp$5(mt[2],gt[0],gt[1]):mt[2],vt=a.getRadius(gt[0],gt[1],ht,ut,ft),vt===0&&(vt=null),ct[bt][2]=vt,lt.push(vt)}),a.radii=lt},y.prototype.init=function(){return Series$a.prototype.init.apply(this,arguments),this.eventsToUnbind.push(addEvent$r(this,"updatedData",function(){this.chart.series.forEach(function(a){a.type===this.type&&(a.isDirty=!0)},this)})),this},y.prototype.onMouseUp=function(a){if(a.fixedPosition&&!a.removed){var k,j,et=this.layout,it=this.parentNodeLayout;it&&et.options.dragBetweenSeries&&it.nodes.forEach(function(nt){a&&a.marker&&nt!==a.series.parentNode&&(k=et.getDistXY(a,nt),j=et.vectorLength(k)-nt.marker.radius-a.marker.radius,j<0&&(nt.series.addPoint(merge$A(a.options,{plotX:a.plotX,plotY:a.plotY}),!1),et.removeElementFromCollection(a,et.nodes),a.remove()))}),dragNodesMixin.onMouseUp.apply(this,arguments)}},y.prototype.placeBubbles=function(a){var k=this,j=k.checkOverlap,et=k.positionBubble,it=[],nt=1,ot=0,at=0,lt,ct,ht=[],ut;if(ct=a.sort(function(ft,vt){return vt[2]-ft[2]}),ct.length){if(it.push([[0,0,ct[0][2],ct[0][3],ct[0][4]]]),ct.length>1)for(it.push([[0,0-ct[1][2]-ct[0][2],ct[1][2],ct[1][3],ct[1][4]]]),ut=2;ut<ct.length;ut++)ct[ut][2]=ct[ut][2]||1,lt=et(it[nt][ot],it[nt-1][at],ct[ut]),j(lt,it[nt][0])?(it.push([]),at=0,it[nt+1].push(et(it[nt][ot],it[nt][0],ct[ut])),nt++,ot=0):nt>1&&it[nt-1][at+1]&&j(lt,it[nt-1][at+1])?(at++,it[nt].push(et(it[nt][ot],it[nt-1][at],ct[ut])),ot++):(ot++,it[nt].push(lt));k.chart.stages=it,k.chart.rawPositions=[].concat.apply([],it),k.resizeRadius(),ht=k.chart.rawPositions}return ht},y.prototype.positionBubble=function(a,k,j){var et=Math.sqrt,it=Math.asin,nt=Math.acos,ot=Math.pow,at=Math.abs,lt=et(ot(a[0]-k[0],2)+ot(a[1]-k[1],2)),ct=nt((ot(lt,2)+ot(j[2]+k[2],2)-ot(j[2]+a[2],2))/(2*(j[2]+k[2])*lt)),ht=it(at(a[0]-k[0])/lt),ut=a[1]-k[1]<0?0:Math.PI,ft=(a[0]-k[0])*(a[1]-k[1])<0?1:-1,vt=ut+ct+ht*ft,gt=Math.cos(vt),mt=Math.sin(vt),bt=k[0]+(k[2]+j[2])*mt,xt=k[1]-(k[2]+j[2])*gt;return[bt,xt,j[2],j[3],j[4]]},y.prototype.render=function(){var a=this,k=[];Series$a.prototype.render.apply(this,arguments),a.options.dataLabels.allowOverlap||(a.data.forEach(function(j){isArray$7(j.dataLabels)&&j.dataLabels.forEach(function(et){k.push(et)})}),a.options.useSimulation&&a.chart.hideOverlappingLabels(k))},y.prototype.resizeRadius=function(){var a=this.chart,k=a.rawPositions,j=Math.min,et=Math.max,it=a.plotLeft,nt=a.plotTop,ot=a.plotHeight,at=a.plotWidth,lt,ct,ht,ut,ft,vt,gt,mt,bt;for(lt=ht=Number.POSITIVE_INFINITY,ct=ut=Number.NEGATIVE_INFINITY,bt=0;bt<k.length;bt++)ft=k[bt][2],lt=j(lt,k[bt][0]-ft),ct=et(ct,k[bt][0]+ft),ht=j(ht,k[bt][1]-ft),ut=et(ut,k[bt][1]+ft);if(vt=[ct-lt,ut-ht],gt=[(at-it)/vt[0],(ot-nt)/vt[1]],mt=j.apply([],gt),Math.abs(mt-1)>1e-10){for(bt=0;bt<k.length;bt++)k[bt][2]*=mt;this.placeBubbles(k)}else a.diffY=ot/2+nt-ht-(ut-ht)/2,a.diffX=at/2+it-lt-(ct-lt)/2},y.prototype.seriesBox=function(){var a=this,k=a.chart,j=a.data,et=Math.max,it=Math.min,nt,ot=[k.plotLeft,k.plotLeft+k.plotWidth,k.plotTop,k.plotTop+k.plotHeight];return j.forEach(function(at){defined$h(at.plotX)&&defined$h(at.plotY)&&at.marker.radius&&(nt=at.marker.radius,ot[0]=it(ot[0],at.plotX-nt),ot[1]=et(ot[1],at.plotX+nt),ot[2]=it(ot[2],at.plotY-nt),ot[3]=et(ot[3],at.plotY+nt))}),isNumber$j(ot.width/ot.height)?ot:null},y.prototype.setVisible=function(){var a=this;Series$a.prototype.setVisible.apply(a,arguments),a.parentNodeLayout&&a.graph?a.visible?(a.graph.show(),a.parentNode.dataLabel&&a.parentNode.dataLabel.show()):(a.graph.hide(),a.parentNodeLayout.removeElementFromCollection(a.parentNode,a.parentNodeLayout.nodes),a.parentNode.dataLabel&&a.parentNode.dataLabel.hide()):a.layout&&(a.visible?a.layout.addElementsToCollection(a.points,a.layout.nodes):a.points.forEach(function(k){a.layout.removeElementFromCollection(k,a.layout.nodes)}))},y.prototype.translate=function(){var a=this,k=a.chart,j=a.data,et=a.index,it,nt,ot,at,lt=a.options.useSimulation;for(a.processedXData=a.xData,a.generatePoints(),defined$h(k.allDataPoints)||(k.allDataPoints=a.accumulateAllPoints(a),a.getPointRadius()),lt?ot=k.allDataPoints:(ot=a.placeBubbles(k.allDataPoints),a.options.draggable=!1),at=0;at<ot.length;at++)ot[at][3]===et&&(it=j[ot[at][4]],nt=pick$F(ot[at][2],void 0),lt||(it.plotX=ot[at][0]-k.plotLeft+k.diffX,it.plotY=ot[at][1]-k.plotTop+k.diffY),isNumber$j(nt)&&(it.marker=extend$C(it.marker,{radius:nt,width:2*nt,height:2*nt}),it.radius=nt));lt&&a.deferLayout(),fireEvent$7(a,"afterTranslate")},y.defaultOptions=merge$A(BubbleSeries.defaultOptions,{minSize:"10%",maxSize:"50%",sizeBy:"area",zoneAxis:"y",crisp:!1,tooltip:{pointFormat:"Value: {point.value}"},draggable:!0,useSimulation:!0,parentNode:{allo