/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.osgi.push;

import java.util.ArrayList;
import java.util.List;

import org.osgi.service.component.annotations.Component;

import com.vaadin.osgi.resources.OsgiVaadinContributor;
import com.vaadin.osgi.resources.OsgiVaadinResource;

@Component
public class PushResourcesContribution implements OsgiVaadinContributor {
    private static final String[] RESOURCES = { "vaadinPush.js",
            "vaadinPush.js.gz", "vaadinPush.debug.js",
            "vaadinPush.debug.js.gz", "vaadinPush-min.js",
            "vaadinPush-min.js.gz" };

    @Override
    public List<OsgiVaadinResource> getContributions() {
        final List<OsgiVaadinResource> contributions = new ArrayList<>(
                RESOURCES.length);
        for (final String theme : RESOURCES) {
            contributions.add(OsgiVaadinResource.create(theme));
        }
        return contributions;
    }
}
