/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus.deployment;

import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.quarkus.QuarkusVaadinServlet;
import com.vaadin.quarkus.WebsocketHttpSessionAttachRecorder;
import com.vaadin.quarkus.annotation.NormalRouteScoped;
import com.vaadin.quarkus.annotation.NormalUIScoped;
import com.vaadin.quarkus.annotation.RouteScoped;
import com.vaadin.quarkus.annotation.UIScoped;
import com.vaadin.quarkus.annotation.VaadinServiceScoped;
import com.vaadin.quarkus.annotation.VaadinSessionScoped;
import com.vaadin.quarkus.context.RouteContextWrapper;
import com.vaadin.quarkus.context.RouteScopedContext;
import com.vaadin.quarkus.context.UIContextWrapper;
import com.vaadin.quarkus.context.UIScopedContext;
import com.vaadin.quarkus.context.VaadinServiceScopedContext;
import com.vaadin.quarkus.context.VaadinSessionScopedContext;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.ContextRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.CustomScopeBuildItem;
import io.quarkus.arc.deployment.IgnoreSplitPackageBuildItem;
import io.quarkus.arc.processor.ContextConfigurator;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.RemovedResourceBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.undertow.deployment.ServletBuildItem;
import io.quarkus.undertow.deployment.ServletDeploymentManagerBuildItem;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import io.quarkus.websockets.client.deployment.ServerWebSocketContainerBuildItem;
import io.quarkus.websockets.client.deployment.WebSocketDeploymentInfoBuildItem;
import jakarta.servlet.annotation.WebServlet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VaadinQuarkusProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(VaadinQuarkusProcessor.class);
    private static final String FEATURE = "vaadin-quarkus";
    private static final DotName ROUTE_ANNOTATION = DotName.createSimple((String)Route.class.getName());

    VaadinQuarkusProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void indexOptionalVaadinDependencies(BuildProducer<IndexDependencyBuildItem> producer) {
        producer.produce((BuildItem)new IndexDependencyBuildItem("com.vaadin", "flow-react"));
        producer.produce((BuildItem)new IndexDependencyBuildItem("com.vaadin", "flow-polymer-template"));
        producer.produce((BuildItem)new IndexDependencyBuildItem("com.vaadin", "vaadin-dev-server"));
        producer.produce((BuildItem)new IndexDependencyBuildItem("com.vaadin", "copilot"));
        producer.produce((BuildItem)new IndexDependencyBuildItem("com.vaadin", "ui-tests"));
    }

    @BuildStep
    void removeUnusedJandexIndex(CurateOutcomeBuildItem curateOutcome, BuildProducer<RemovedResourceBuildItem> removedResourceProducer, BuildProducer<IgnoreSplitPackageBuildItem> ignoreSplitPackage) {
        Predicate<String> isVaadinJandex = Pattern.compile("vaadin(-core)?-jandex").asMatchPredicate();
        ApplicationModel applicationModel = curateOutcome.getApplicationModel();
        Set vaadinIndexes = applicationModel.getDependencies().stream().filter(archive -> "com.vaadin".equals(archive.getKey().getGroupId()) && isVaadinJandex.test(archive.getKey().getArtifactId())).map(archive -> archive.getKey().toGacString()).collect(Collectors.toSet());
        if (vaadinIndexes.size() > 1) {
            ArtifactKey artifactKey = ArtifactKey.of((String)"com.vaadin", (String)"vaadin-core-jandex", null, (String)"jar");
            try {
                applicationModel.getRemovedResources().put(artifactKey, Set.of());
            }
            catch (Exception ex) {
                removedResourceProducer.produce((BuildItem)new RemovedResourceBuildItem(artifactKey, Set.of()));
                ignoreSplitPackage.produce((BuildItem)new IgnoreSplitPackageBuildItem(Set.of("com.vaadin.*")));
            }
        }
    }

    @BuildStep
    public void build(BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer, BuildProducer<BeanDefiningAnnotationBuildItem> additionalBeanDefiningAnnotationRegistry) {
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(QuarkusVaadinServlet.class));
        additionalBeanDefiningAnnotationRegistry.produce((BuildItem)new BeanDefiningAnnotationBuildItem(ROUTE_ANNOTATION));
    }

    @BuildStep
    public void specifyRouterLayoutBeans(CombinedIndexBuildItem item, BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer) {
        Collection layouts = item.getComputingIndex().getAllKnownImplementors(DotName.createSimple((String)RouterLayout.class.getName()));
        for (ClassInfo layoutInfo : layouts) {
            additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((String)layoutInfo.name().toString()));
        }
    }

    @BuildStep
    public void specifyErrorViewsBeans(CombinedIndexBuildItem item, BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer) {
        Collection errors = item.getComputingIndex().getAllKnownImplementors(DotName.createSimple((String)HasErrorParameter.class.getName()));
        for (ClassInfo errorInfo : errors) {
            additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((String)errorInfo.name().toString()));
        }
    }

    @BuildStep
    void mapVaadinServletPaths(BeanArchiveIndexBuildItem beanArchiveIndex, BuildProducer<ServletBuildItem> servletProducer) {
        IndexView indexView = beanArchiveIndex.getIndex();
        Collection<ClassInfo> vaadinServlets = indexView.getAllKnownSubclasses(DotName.createSimple((String)VaadinServlet.class.getName())).stream().filter(servlet -> !servlet.name().toString().equals(QuarkusVaadinServlet.class.getName()) && !servlet.name().toString().equals(VaadinServlet.class.getName())).collect(Collectors.toList());
        if ((vaadinServlets = this.registerUserServlets(servletProducer, vaadinServlets)).isEmpty()) {
            servletProducer.produce((BuildItem)ServletBuildItem.builder((String)QuarkusVaadinServlet.class.getName(), (String)QuarkusVaadinServlet.class.getName()).addMapping("/*").setAsyncSupported(true).setLoadOnStartup(1).build());
        }
    }

    @BuildStep
    ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem registerVaadinServiceScopedContext(ContextRegistrationPhaseBuildItem phase) {
        return new ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem(new ContextConfigurator[]{phase.getContext().configure(VaadinServiceScoped.class).normal().contextClass(VaadinServiceScopedContext.class)});
    }

    @BuildStep
    CustomScopeBuildItem serviceScope() {
        return new CustomScopeBuildItem(VaadinServiceScoped.class);
    }

    @BuildStep
    ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem registerVaadinSessionScopedContext(ContextRegistrationPhaseBuildItem phase) {
        return new ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem(new ContextConfigurator[]{phase.getContext().configure(VaadinSessionScoped.class).normal().contextClass(VaadinSessionScopedContext.class)});
    }

    @BuildStep
    CustomScopeBuildItem sessionScope() {
        return new CustomScopeBuildItem(VaadinSessionScoped.class);
    }

    @BuildStep
    ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem registerUIScopedContext(ContextRegistrationPhaseBuildItem phase) {
        return new ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem(new ContextConfigurator[]{phase.getContext().configure(NormalUIScoped.class).normal().contextClass(UIScopedContext.class)});
    }

    @BuildStep
    ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem registerPseudoUIScopedContext(ContextRegistrationPhaseBuildItem phase) {
        return new ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem(new ContextConfigurator[]{phase.getContext().configure(UIScoped.class).contextClass(UIContextWrapper.class)});
    }

    @BuildStep
    CustomScopeBuildItem normalUiScope() {
        return new CustomScopeBuildItem(NormalUIScoped.class);
    }

    @BuildStep
    CustomScopeBuildItem uiScope() {
        return new CustomScopeBuildItem(UIScoped.class);
    }

    @BuildStep
    ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem registerRouteScopedContext(ContextRegistrationPhaseBuildItem phase) {
        return new ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem(new ContextConfigurator[]{phase.getContext().configure(NormalRouteScoped.class).normal().contextClass(RouteScopedContext.class)});
    }

    @BuildStep
    ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem registerPseudoRouteScopedContext(ContextRegistrationPhaseBuildItem phase) {
        return new ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem(new ContextConfigurator[]{phase.getContext().configure(RouteScoped.class).contextClass(RouteContextWrapper.class)});
    }

    @BuildStep
    CustomScopeBuildItem normalRouteScope() {
        return new CustomScopeBuildItem(NormalRouteScoped.class);
    }

    @BuildStep
    CustomScopeBuildItem rRouteScope() {
        return new CustomScopeBuildItem(RouteScoped.class);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupPush(ServletDeploymentManagerBuildItem deployment, WebSocketDeploymentInfoBuildItem webSocketDeploymentInfoBuildItem, ServerWebSocketContainerBuildItem serverWebSocketContainerBuildItem, BuildProducer<FilterBuildItem> filterProd, WebsocketHttpSessionAttachRecorder recorder) {
        filterProd.produce((BuildItem)new FilterBuildItem(recorder.createWebSocketHandler(webSocketDeploymentInfoBuildItem.getInfo(), serverWebSocketContainerBuildItem.getContainer(), deployment.getDeploymentManager()), 120));
    }

    private Collection<ClassInfo> registerUserServlets(BuildProducer<ServletBuildItem> servletProducer, Collection<ClassInfo> vaadinServlets) {
        ArrayList<ClassInfo> registeredServlets = new ArrayList<ClassInfo>(vaadinServlets);
        for (ClassInfo info : vaadinServlets) {
            AnnotationInstance webServletInstance = info.classAnnotation(DotName.createSimple((String)WebServlet.class.getName()));
            if (webServletInstance == null) {
                LOG.warn("Found unexpected {} extends VaadinServlet without @WebServlet, skipping", (Object)info.name());
                registeredServlets.remove(info);
                continue;
            }
            String servletName = Optional.ofNullable(webServletInstance.value("name")).map(AnnotationValue::asString).orElse(info.name().toString());
            int loadOnStartup = Optional.ofNullable(webServletInstance.value("loadOnStartup")).map(AnnotationValue::asInt).orElse(-1);
            ServletBuildItem.Builder servletBuildItem = ServletBuildItem.builder((String)servletName, (String)info.name().toString());
            Stream.of(webServletInstance.value("value"), webServletInstance.value("urlPatterns")).filter(Objects::nonNull).flatMap(value -> Stream.of(value.asStringArray())).forEach(arg_0 -> ((ServletBuildItem.Builder)servletBuildItem).addMapping(arg_0));
            this.addWebInitParameters(webServletInstance, servletBuildItem);
            this.setAsyncSupportedIfDefined(webServletInstance, servletBuildItem);
            servletBuildItem.setLoadOnStartup(loadOnStartup > 0 ? loadOnStartup : 1);
            if (loadOnStartup < 1) {
                LOG.warn("Vaadin Servlet needs to be eagerly loaded by setting load-on-startup to be greater than 0. Current value for '{}' is '{}', so it will be forced to '1'. Please set 'loadOnStartup' attribute on @WebServlet annotation to a value greater than 0.", (Object)servletName, (Object)loadOnStartup);
            }
            servletProducer.produce((BuildItem)servletBuildItem.build());
        }
        return registeredServlets;
    }

    private void addWebInitParameters(AnnotationInstance webServletInstance, ServletBuildItem.Builder servletBuildItem) {
        AnnotationValue initParams = webServletInstance.value("initParams");
        if (initParams != null) {
            for (AnnotationInstance initParam : initParams.asNestedArray()) {
                servletBuildItem.addInitParam(initParam.value("name").asString(), initParam.value().asString());
            }
        }
    }

    private void setAsyncSupportedIfDefined(AnnotationInstance webServletInstance, ServletBuildItem.Builder servletBuildItem) {
        AnnotationValue asyncSupported = webServletInstance.value("asyncSupported");
        if (asyncSupported != null) {
            servletBuildItem.setAsyncSupported(asyncSupported.asBoolean());
        }
    }
}

