/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.quarkus.context;

import io.quarkus.arc.Arc;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;

@Typed
public abstract class ContextUtils {
    private ContextUtils() {
    }

    public static boolean isContextActive(Class<? extends Annotation> scopeAnnotationClass) {
        return ContextUtils.isContextActive(scopeAnnotationClass, Arc.container().beanManager());
    }

    public static boolean isContextActive(Class<? extends Annotation> scopeAnnotationClass, BeanManager beanManager) {
        try {
            if (beanManager.getContext(scopeAnnotationClass) == null || !beanManager.getContext(scopeAnnotationClass).isActive()) {
                return false;
            }
        }
        catch (ContextNotActiveException e) {
            return false;
        }
        return true;
    }
}

