/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.radiobutton;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.radiobutton.FieldValidationUtil;
import com.vaadin.flow.component.radiobutton.GeneratedVaadinRadioGroup;
import com.vaadin.flow.component.radiobutton.RadioButton;
import com.vaadin.flow.component.radiobutton.dataview.RadioButtonGroupDataView;
import com.vaadin.flow.component.radiobutton.dataview.RadioButtonGroupListDataView;
import com.vaadin.flow.data.binder.HasItemComponents;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.DataProviderWrapper;
import com.vaadin.flow.data.provider.DataViewUtils;
import com.vaadin.flow.data.provider.HasDataView;
import com.vaadin.flow.data.provider.HasListDataView;
import com.vaadin.flow.data.provider.IdentifierProvider;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.ItemCountChangeEvent;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.data.selection.SingleSelect;
import com.vaadin.flow.dom.PropertyChangeEvent;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;

@NpmPackage.Container(value={@NpmPackage(value="@vaadin/radio-group", version="22.0.4"), @NpmPackage(value="@vaadin/vaadin-radio-button", version="22.0.4")})
public class RadioButtonGroup<T>
extends GeneratedVaadinRadioGroup<RadioButtonGroup<T>, T>
implements HasItemComponents<T>,
SingleSelect<RadioButtonGroup<T>, T>,
HasListDataView<T, RadioButtonGroupListDataView<T>>,
HasDataView<T, Void, RadioButtonGroupDataView<T>>,
HasValidation,
HasHelper,
HasSize {
    private final KeyMapper<T> keyMapper = new KeyMapper();
    private final AtomicReference<DataProvider<T, ?>> dataProvider = new AtomicReference<ListDataProvider>(DataProvider.ofItems((Object[])new Object[0]));
    private SerializablePredicate<T> itemEnabledProvider = (SerializablePredicate & Serializable)item -> this.isEnabled();
    private ComponentRenderer<? extends Component, T> itemRenderer = new TextRenderer();
    private boolean isReadOnly;
    private final PropertyChangeListener validationListener = this::validateSelectionEnabledState;
    private Registration validationRegistration;
    private Registration dataProviderListenerRegistration;
    private int lastNotifiedDataSize = -1;
    private volatile int lastFetchedDataSize = -1;
    private SerializableConsumer<UI> sizeRequest;

    private static <T> T presentationToModel(RadioButtonGroup<T> radioButtonGroup, String presentation) {
        if (!radioButtonGroup.keyMapper.containsKey(presentation)) {
            return null;
        }
        return (T)radioButtonGroup.keyMapper.get(presentation);
    }

    private static <T> String modelToPresentation(RadioButtonGroup<T> radioButtonGroup, T model) {
        if (!radioButtonGroup.keyMapper.has(model)) {
            return null;
        }
        return radioButtonGroup.keyMapper.key(model);
    }

    public RadioButtonGroup() {
        super(null, null, String.class, RadioButtonGroup::presentationToModel, RadioButtonGroup::modelToPresentation, true);
        this.registerValidation();
    }

    public RadioButtonGroupDataView<T> setItems(DataProvider<T, Void> dataProvider) {
        this.setDataProvider(dataProvider);
        return this.getGenericDataView();
    }

    public RadioButtonGroupDataView<T> setItems(InMemoryDataProvider<T> inMemoryDataProvider) {
        DataProviderWrapper convertedDataProvider = new DataProviderWrapper<T, Void, SerializablePredicate<T>>((DataProvider)inMemoryDataProvider, (InMemoryDataProvider)inMemoryDataProvider){
            final /* synthetic */ InMemoryDataProvider val$inMemoryDataProvider;
            {
                this.val$inMemoryDataProvider = inMemoryDataProvider;
                super(x0);
            }

            protected SerializablePredicate<T> getFilter(Query<T, Void> query) {
                return Optional.ofNullable(this.val$inMemoryDataProvider.getFilter()).orElse((SerializablePredicate & Serializable)item -> true);
            }
        };
        return this.setItems((DataProvider<T, Void>)convertedDataProvider);
    }

    public RadioButtonGroupListDataView<T> setItems(ListDataProvider<T> dataProvider) {
        this.setDataProvider((DataProvider<T, ?>)dataProvider);
        return this.getListDataView();
    }

    @Deprecated
    public void setItems(Stream<T> streamOfItems) {
        this.setItems((ListDataProvider<T>)DataProvider.fromStream(streamOfItems));
    }

    public RadioButtonGroupListDataView<T> getListDataView() {
        return new RadioButtonGroupListDataView(this::getDataProvider, this, this::identifierProviderChanged, (SerializableBiConsumer & Serializable)(filter, sorting) -> this.reset());
    }

    public RadioButtonGroupDataView<T> getGenericDataView() {
        return new RadioButtonGroupDataView(this::getDataProvider, this, this::identifierProviderChanged);
    }

    protected boolean hasValidValue() {
        String selectedKey = this.getElement().getProperty("value");
        return this.itemEnabledProvider.test(this.keyMapper.get(selectedKey));
    }

    @Deprecated
    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        this.dataProvider.set(dataProvider);
        DataViewUtils.removeComponentFilterAndSortComparator((Component)this);
        this.reset();
        this.setupDataProviderListener(dataProvider);
    }

    private void setupDataProviderListener(DataProvider<T, ?> dataProvider) {
        if (this.dataProviderListenerRegistration != null) {
            this.dataProviderListenerRegistration.remove();
        }
        this.dataProviderListenerRegistration = dataProvider.addDataProviderListener((DataProviderListener & Serializable)event -> {
            if (event instanceof DataChangeEvent.DataRefreshEvent) {
                this.resetRadioButton(((DataChangeEvent.DataRefreshEvent)event).getItem());
            } else {
                this.reset();
            }
        });
    }

    public void setValue(T value) {
        super.setValue(value);
        this.getRadioButtons().forEach(rb -> rb.setChecked(Objects.equals(rb.getItem(), value)));
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.getDataProvider() != null) {
            this.setupDataProviderListener(this.getDataProvider());
        }
        FieldValidationUtil.disableClientValidation(this);
    }

    protected void onDetach(DetachEvent detachEvent) {
        if (this.dataProviderListenerRegistration != null) {
            this.dataProviderListenerRegistration.remove();
            this.dataProviderListenerRegistration = null;
        }
        super.onDetach(detachEvent);
    }

    @Deprecated
    public DataProvider<T, ?> getDataProvider() {
        return Optional.ofNullable(this.dataProvider).map(AtomicReference::get).orElse(null);
    }

    public SerializablePredicate<T> getItemEnabledProvider() {
        return this.itemEnabledProvider;
    }

    public void setItemEnabledProvider(SerializablePredicate<T> itemEnabledProvider) {
        this.itemEnabledProvider = Objects.requireNonNull(itemEnabledProvider);
        this.refreshButtons();
    }

    public ComponentRenderer<? extends Component, T> getItemRenderer() {
        return this.itemRenderer;
    }

    public void setRenderer(ComponentRenderer<? extends Component, T> renderer) {
        this.itemRenderer = Objects.requireNonNull(renderer);
        this.refreshButtons();
    }

    public void onEnabledStateChanged(boolean enabled) {
        if (this.isReadOnly()) {
            this.setDisabled(true);
        } else {
            this.setDisabled(!enabled);
        }
        this.refreshButtons();
    }

    public void setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
        if (this.isEnabled()) {
            this.setDisabled(readOnly);
            this.refreshButtons();
        }
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public void setRequired(boolean required) {
        super.setRequired(required);
    }

    public boolean isRequired() {
        return super.isRequiredBoolean();
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public String getErrorMessage() {
        return super.getErrorMessageString();
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    public String getLabel() {
        return super.getLabelString();
    }

    public boolean isInvalid() {
        return this.isInvalidBoolean();
    }

    @Override
    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        this.keyMapper.removeAll();
        this.clear();
        AtomicReference<DataProvider<T, ?>> atomicReference = this.dataProvider;
        synchronized (atomicReference) {
            Component helperComponent = this.getHelperComponent();
            this.getChildren().forEach(xva$0 -> this.remove(new Component[]{xva$0}));
            this.setHelperComponent(helperComponent);
            AtomicInteger itemCounter = new AtomicInteger(0);
            this.getDataProvider().fetch(DataViewUtils.getQuery((Component)this)).map(item -> this.createRadioButton(item)).forEach(component -> {
                this.add(new Component[]{(Component)component});
                itemCounter.incrementAndGet();
            });
            this.lastFetchedDataSize = itemCounter.get();
            if (this.sizeRequest == null) {
                this.sizeRequest = (SerializableConsumer & Serializable)ui -> {
                    this.fireSizeEvent();
                    this.sizeRequest = null;
                };
                this.runBeforeClientResponse(this.sizeRequest);
            }
        }
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    private void fireSizeEvent() {
        int newSize = this.lastFetchedDataSize;
        if (this.lastNotifiedDataSize != newSize) {
            this.lastNotifiedDataSize = newSize;
            this.fireEvent((ComponentEvent)new ItemCountChangeEvent((Component)this, newSize, false));
        }
    }

    private void resetRadioButton(T item) {
        this.getRadioButtons().filter(radioButton -> this.getItemId(radioButton.getItem()).equals(this.getItemId(item))).findFirst().ifPresent(this::updateButton);
    }

    private Object getItemId(T item) {
        return this.getIdentifierProvider().apply(item);
    }

    private IdentifierProvider<T> getIdentifierProvider() {
        IdentifierProvider identifierProviderObject = (IdentifierProvider)ComponentUtil.getData((Component)this, IdentifierProvider.class);
        if (identifierProviderObject == null) {
            DataProvider<T, ?> dataProvider = this.getDataProvider();
            if (dataProvider != null) {
                return arg_0 -> dataProvider.getId(arg_0);
            }
            return IdentifierProvider.identity();
        }
        return identifierProviderObject;
    }

    private Component createRadioButton(T item) {
        RadioButton<T> button = new RadioButton<T>(this.keyMapper.key(item), item);
        this.updateButton(button);
        return button;
    }

    private void refreshButtons() {
        this.getRadioButtons().forEach(this::updateButton);
    }

    private Stream<RadioButton<T>> getRadioButtons() {
        return this.getChildren().filter(RadioButton.class::isInstance).map(child -> (RadioButton)((Object)child));
    }

    private void updateButton(RadioButton<T> button) {
        this.updateEnabled(button);
        Component labelComponent = this.getItemRenderer().createComponent(button.getItem());
        button.setLabelComponent(labelComponent);
    }

    private void validateSelectionEnabledState(PropertyChangeEvent event) {
        if (!this.hasValidValue()) {
            T oldValue = this.getValue(event.getOldValue());
            try {
                this.validationRegistration.remove();
                this.getElement().setProperty("value", this.keyMapper.key(oldValue));
            }
            finally {
                this.registerValidation();
            }
            Optional<RadioButton> selectedButton = this.getRadioButtons().filter(button -> button.getItem() == this.getValue(event.getValue())).findFirst();
            selectedButton.ifPresent(this::updateEnabled);
        }
    }

    protected boolean valueEquals(T value1, T value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return this.getItemId(value1).equals(this.getItemId(value2));
    }

    private void updateEnabled(RadioButton<T> button) {
        boolean disabled = this.isDisabledBoolean() || !this.getItemEnabledProvider().test(button.getItem());
        button.setEnabled(!disabled);
        button.setDisabled(disabled);
        button.getElement().executeJs("this.disabled = $0", new Serializable[]{Boolean.valueOf(disabled)});
    }

    private T getValue(Serializable key) {
        if (key == null) {
            return null;
        }
        return (T)this.keyMapper.get(key.toString());
    }

    private void registerValidation() {
        if (this.validationRegistration != null) {
            this.validationRegistration.remove();
        }
        this.validationRegistration = this.getElement().addPropertyChangeListener("value", this.validationListener);
    }

    private void identifierProviderChanged(IdentifierProvider<T> identifierProvider) {
        this.keyMapper.setIdentifierGetter(identifierProvider);
    }
}

