/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.radiobutton;

import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.NotSupported;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.radiobutton.RadioGroupVariant;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(value="vaadin-radio-group")
@JsModule(value="@vaadin/vaadin-radio-button/src/vaadin-radio-group.js")
public abstract class GeneratedVaadinRadioGroup<R extends GeneratedVaadinRadioGroup<R, T>, T>
extends AbstractSinglePropertyField<R, T>
implements HasStyle,
HasTheme {
    public void addThemeVariants(RadioGroupVariant ... variants) {
        this.getThemeNames().addAll((Collection)Stream.of(variants).map(RadioGroupVariant::getVariantName).collect(Collectors.toList()));
    }

    public void removeThemeVariants(RadioGroupVariant ... variants) {
        this.getThemeNames().removeAll((Collection)Stream.of(variants).map(RadioGroupVariant::getVariantName).collect(Collectors.toList()));
    }

    protected boolean isDisabledBoolean() {
        return this.getElement().getProperty("disabled", false);
    }

    protected void setDisabled(boolean disabled) {
        this.getElement().setProperty("disabled", disabled);
    }

    protected boolean isReadonlyBoolean() {
        return this.getElement().getProperty("readonly", false);
    }

    protected void setReadonly(boolean readonly) {
        this.getElement().setProperty("readonly", readonly);
    }

    @Synchronize(property="invalid", value={"invalid-changed"})
    protected boolean isInvalidBoolean() {
        return this.getElement().getProperty("invalid", false);
    }

    protected void setInvalid(boolean invalid) {
        this.getElement().setProperty("invalid", invalid);
    }

    protected boolean isRequiredBoolean() {
        return this.getElement().getProperty("required", false);
    }

    protected void setRequired(boolean required) {
        this.getElement().setProperty("required", required);
    }

    protected String getErrorMessageString() {
        return this.getElement().getProperty("errorMessage");
    }

    protected void setErrorMessage(String errorMessage) {
        this.getElement().setProperty("errorMessage", errorMessage == null ? "" : errorMessage);
    }

    protected String getLabelString() {
        return this.getElement().getProperty("label");
    }

    protected void setLabel(String label) {
        this.getElement().setProperty("label", label == null ? "" : label);
    }

    @NotSupported
    protected void validate() {
    }

    @NotSupported
    protected void checkValidity() {
    }

    protected Registration addInvalidChangeListener(ComponentEventListener<InvalidChangeEvent<R>> listener) {
        return this.getElement().addPropertyChangeListener("invalid", (PropertyChangeListener & Serializable)event -> listener.onComponentEvent(new InvalidChangeEvent<GeneratedVaadinRadioGroup>(this, event.isUserOriginated())));
    }

    public <P> GeneratedVaadinRadioGroup(T initialValue, T defaultValue, Class<P> elementPropertyType, SerializableFunction<P, T> presentationToModel, SerializableFunction<T, P> modelToPresentation) {
        super("value", defaultValue, elementPropertyType, presentationToModel, modelToPresentation);
        if (initialValue != null) {
            this.setModelValue(initialValue, false);
            this.setPresentationValue(initialValue);
        }
    }

    public GeneratedVaadinRadioGroup(T initialValue, T defaultValue, boolean acceptNullValues) {
        super("value", defaultValue, acceptNullValues);
        if (initialValue != null) {
            this.setModelValue(initialValue, false);
            this.setPresentationValue(initialValue);
        }
    }

    public <P> GeneratedVaadinRadioGroup(T initialValue, T defaultValue, Class<P> elementPropertyType, SerializableBiFunction<R, P, T> presentationToModel, SerializableBiFunction<R, T, P> modelToPresentation) {
        super("value", defaultValue, elementPropertyType, presentationToModel, modelToPresentation);
        if (initialValue != null) {
            this.setModelValue(initialValue, false);
            this.setPresentationValue(initialValue);
        }
    }

    public GeneratedVaadinRadioGroup() {
        this(null, null, null, (SerializableFunction)null, (SerializableFunction)null);
    }

    public static class InvalidChangeEvent<R extends GeneratedVaadinRadioGroup<R, ?>>
    extends ComponentEvent<R> {
        private final boolean invalid;

        public InvalidChangeEvent(R source, boolean fromClient) {
            super(source, fromClient);
            this.invalid = ((GeneratedVaadinRadioGroup)((Object)source)).isInvalidBoolean();
        }

        public boolean isInvalid() {
            return this.invalid;
        }
    }
}

