/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.radiobutton.testbench;

import com.vaadin.flow.component.radiobutton.testbench.RadioButtonElement;
import com.vaadin.testbench.HasSelectByText;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;

@Element(value="vaadin-radio-group")
public class RadioButtonGroupElement
extends TestBenchElement
implements HasSelectByText {
    public List<String> getOptions() {
        return this.getRadioButtons().stream().map(RadioButtonElement::getItem).collect(Collectors.toList());
    }

    private List<RadioButtonElement> getRadioButtons() {
        return this.$(RadioButtonElement.class).all();
    }

    public void selectByText(String text) {
        Optional<RadioButtonElement> radioButton = this.getRadioButtonByText(text);
        if (!radioButton.isPresent()) {
            throw new NoSuchElementException("No item with text '" + text + "' found");
        }
        radioButton.get().setChecked(true);
    }

    public String getSelectedText() {
        Optional<RadioButtonElement> button = this.getSelectedRadioButton();
        return button.map(RadioButtonElement::getItem).orElse(null);
    }

    private Optional<RadioButtonElement> getSelectedRadioButton() {
        return this.getRadioButtonByValue(this.getValue());
    }

    private Optional<RadioButtonElement> getRadioButtonByText(String text) {
        if (text == null) {
            return Optional.empty();
        }
        return this.getRadioButtons().stream().filter(radioButton -> text.equals(radioButton.getItem())).findFirst();
    }

    private Optional<RadioButtonElement> getRadioButtonByValue(String value) {
        if (value == null) {
            return Optional.empty();
        }
        return this.getRadioButtons().stream().filter(radioButton -> value.equals(radioButton.getValue())).findFirst();
    }

    private String getValue() {
        return this.getPropertyString(new String[]{"value"});
    }
}

