/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.renderer.RendererUtil;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.JsonSerializer;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Renderer<SOURCE>
implements Serializable {
    private String template;
    private Map<String, ValueProvider<SOURCE, ?>> valueProviders;
    private Map<String, SerializableConsumer<SOURCE>> eventHandlers;

    protected Renderer() {
    }

    @Deprecated
    protected Renderer(String template) {
        this.template = template;
    }

    @Deprecated
    protected void setProperty(String property, ValueProvider<SOURCE, ?> provider) {
        Objects.requireNonNull(property, "The property must not be null");
        Objects.requireNonNull(provider, "The value provider must not be null");
        if (this.valueProviders == null) {
            this.valueProviders = new HashMap();
        }
        this.valueProviders.put(property, provider);
    }

    @Deprecated
    protected void setEventHandler(String handlerName, SerializableConsumer<SOURCE> handler) {
        Objects.requireNonNull(handlerName, "The handlerName must not be null");
        Objects.requireNonNull(handler, "The event handler must not be null");
        if (this.eventHandlers == null) {
            this.eventHandlers = new HashMap<String, SerializableConsumer<SOURCE>>();
        }
        this.eventHandlers.put(handlerName, handler);
    }

    public Rendering<SOURCE> render(Element container, DataKeyMapper<SOURCE> keyMapper) {
        return this.render(container, keyMapper, new Element("template"));
    }

    @Deprecated
    public Rendering<SOURCE> render(Element container, DataKeyMapper<SOURCE> keyMapper, Element contentTemplate) {
        Objects.requireNonNull(this.template, "The template string is null. Either build the Renderer by using the 'Renderer(String)' constructor or override the 'render' method to provide custom behavior");
        contentTemplate.setProperty("innerHTML", this.template);
        if (contentTemplate.getParent() != container) {
            container.appendChild(new Element[]{contentTemplate});
        }
        if (keyMapper != null) {
            RendererUtil.registerEventHandlers(this, contentTemplate, container, arg_0 -> keyMapper.get(arg_0));
        }
        return new TemplateRendering(contentTemplate);
    }

    public Map<String, ValueProvider<SOURCE, ?>> getValueProviders() {
        return this.valueProviders == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.valueProviders);
    }

    @Deprecated
    public Map<String, SerializableConsumer<SOURCE>> getEventHandlers() {
        return this.eventHandlers == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.eventHandlers);
    }

    @Deprecated
    private class TemplateRendering
    implements Rendering<SOURCE> {
        private final Element templateElement;

        public TemplateRendering(Element templateElement) {
            this.templateElement = templateElement;
        }

        @Override
        public Optional<DataGenerator<SOURCE>> getDataGenerator() {
            if (Renderer.this.valueProviders == null || Renderer.this.valueProviders.isEmpty()) {
                return Optional.empty();
            }
            CompositeDataGenerator composite = new CompositeDataGenerator();
            Renderer.this.valueProviders.forEach((key, provider) -> composite.addDataGenerator((DataGenerator & Serializable)(item, jsonObject) -> jsonObject.put(key, JsonSerializer.toJson((Object)provider.apply(item)))));
            return Optional.of(composite);
        }

        @Override
        public Element getTemplateElement() {
            return this.templateElement;
        }
    }
}

