/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.richtexteditor;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.CompositionNotifier;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.InputNotifier;
import com.vaadin.flow.component.KeyNotifier;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.richtexteditor.GeneratedVaadinRichTextEditor;
import com.vaadin.flow.data.value.HasValueChangeMode;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.Objects;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;

@Tag(value="vaadin-rich-text-editor")
@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="22.0.16")
@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js")
public class RichTextEditor
extends GeneratedVaadinRichTextEditor<RichTextEditor, String>
implements HasSize,
HasValueChangeMode,
InputNotifier,
KeyNotifier,
CompositionNotifier {
    private ValueChangeMode currentMode;
    private RichTextEditorI18n i18n;
    private AsHtml asHtml;
    private HtmlSetRequest htmlSetRequest;

    public RichTextEditorI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(RichTextEditorI18n i18n) {
        Objects.requireNonNull(i18n, "The I18N properties object should not be null");
        this.i18n = i18n;
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            if (i18n == this.i18n) {
                JsonObject i18nObject = (JsonObject)JsonSerializer.toJson((Object)this.i18n);
                for (String key : i18nObject.keys()) {
                    this.getElement().executeJs("this.set('i18n." + key + "', $0)", new Serializable[]{i18nObject.get(key)});
                }
            }
        });
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public RichTextEditor() {
        super("", "", false, true);
        this.setValueChangeMode(ValueChangeMode.ON_CHANGE);
    }

    public RichTextEditor(String initialValue) {
        this();
        this.setValue(initialValue);
    }

    public RichTextEditor(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<RichTextEditor, String>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public RichTextEditor(String initialValue, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<RichTextEditor, String>> listener) {
        this();
        this.setValue(initialValue);
        this.addValueChangeListener(listener);
    }

    public ValueChangeMode getValueChangeMode() {
        return this.currentMode;
    }

    public void setValueChangeMode(ValueChangeMode valueChangeMode) {
        this.currentMode = valueChangeMode;
        this.setSynchronizedEvent(ValueChangeMode.eventForMode((ValueChangeMode)valueChangeMode, (String)"value-changed"));
    }

    public void setValue(String value) {
        super.setValue((Object)value);
    }

    @ClientCallable
    private void updateValue(String value) {
        this.setValue(value);
        if (this.asHtml != null) {
            this.asHtml.value.clear();
        }
    }

    public String getValue() {
        return (String)super.getValue();
    }

    public String getHtmlValue() {
        String htmlValueString = this.getHtmlValueString();
        if (htmlValueString == null) {
            return null;
        }
        return this.sanitize(htmlValueString);
    }

    String sanitize(String html) {
        return Jsoup.clean((String)html, (Whitelist)Whitelist.basic().addTags(new String[]{"img", "h1", "h2", "h3", "s"}).addAttributes("img", new String[]{"align", "alt", "height", "src", "title", "width"}).addAttributes(":all", new String[]{"style"}).addProtocols("img", "src", new String[]{"data"}));
    }

    public HasValue<HasValue.ValueChangeEvent<String>, String> asHtml() {
        if (this.asHtml == null) {
            this.asHtml = new AsHtml();
        }
        return this.asHtml;
    }

    private class AsHtml
    implements HasValue<HasValue.ValueChangeEvent<String>, String> {
        private String oldValue;
        private final HtmlValue value = new HtmlValue();

        AsHtml() {
            RichTextEditor.this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.value.clear());
        }

        public void setValue(String value) {
            this.oldValue = this.getValue();
            this.value.setValue(value);
            this.setHtmlValueAsynchronously(value);
        }

        private void setHtmlValueAsynchronously(String htmlValueString) {
            if (RichTextEditor.this.htmlSetRequest == null) {
                RichTextEditor.this.htmlSetRequest = new HtmlSetRequest();
            }
            RichTextEditor.this.htmlSetRequest.requestUpdate(htmlValueString);
        }

        public String getValue() {
            return this.value.getValue();
        }

        public Registration addValueChangeListener(HasValue.ValueChangeListener listener) {
            return RichTextEditor.this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)originalEvent -> listener.valueChanged(this.createNewEvent((HasValue.ValueChangeEvent<String>)originalEvent)));
        }

        private HasValue.ValueChangeEvent createNewEvent(final HasValue.ValueChangeEvent<String> originalEvent) {
            return new HasValue.ValueChangeEvent<String>(){

                public HasValue<HasValue.ValueChangeEvent<String>, String> getHasValue() {
                    return AsHtml.this;
                }

                public boolean isFromClient() {
                    return originalEvent.isFromClient();
                }

                public String getOldValue() {
                    return AsHtml.this.oldValue;
                }

                public String getValue() {
                    return AsHtml.this.getValue();
                }
            };
        }

        public void setReadOnly(boolean readOnly) {
            RichTextEditor.this.setReadOnly(readOnly);
        }

        public boolean isReadOnly() {
            return RichTextEditor.this.isReadOnly();
        }

        public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
            RichTextEditor.this.setRequiredIndicatorVisible(requiredIndicatorVisible);
        }

        public boolean isRequiredIndicatorVisible() {
            return RichTextEditor.this.isRequiredIndicatorVisible();
        }

        private class HtmlValue
        implements Serializable {
            private String value;
            private boolean present;

            private HtmlValue() {
            }

            private String getValue() {
                if (!this.present) {
                    this.value = this.generateHtmlValue();
                    this.present = true;
                }
                return this.value;
            }

            private void setValue(String value) {
                this.value = value;
                this.present = true;
            }

            private void clear() {
                this.value = null;
                this.present = false;
            }

            private String generateHtmlValue() {
                if (RichTextEditor.this.isEmpty()) {
                    return null;
                }
                return RichTextEditor.this.getHtmlValue();
            }
        }
    }

    public static class RichTextEditorI18n
    implements Serializable {
        private String undo;
        private String redo;
        private String bold;
        private String italic;
        private String underline;
        private String strike;
        private String h1;
        private String h2;
        private String h3;
        private String subscript;
        private String superscript;
        private String listOrdered;
        private String listBullet;
        private String alignLeft;
        private String alignCenter;
        private String alignRight;
        private String image;
        private String link;
        private String blockquote;
        private String codeBlock;
        private String clean;

        public String getUndo() {
            return this.undo;
        }

        public RichTextEditorI18n setUndo(String undo) {
            this.undo = undo;
            return this;
        }

        public String getRedo() {
            return this.redo;
        }

        public RichTextEditorI18n setRedo(String redo) {
            this.redo = redo;
            return this;
        }

        public String getBold() {
            return this.bold;
        }

        public RichTextEditorI18n setBold(String bold) {
            this.bold = bold;
            return this;
        }

        public String getItalic() {
            return this.italic;
        }

        public RichTextEditorI18n setItalic(String italic) {
            this.italic = italic;
            return this;
        }

        public String getUnderline() {
            return this.underline;
        }

        public RichTextEditorI18n setUnderline(String underline) {
            this.underline = underline;
            return this;
        }

        public String getStrike() {
            return this.strike;
        }

        public RichTextEditorI18n setStrike(String strike) {
            this.strike = strike;
            return this;
        }

        public String getH1() {
            return this.h1;
        }

        public RichTextEditorI18n setH1(String h1) {
            this.h1 = h1;
            return this;
        }

        public String getH2() {
            return this.h2;
        }

        public RichTextEditorI18n setH2(String h2) {
            this.h2 = h2;
            return this;
        }

        public String getH3() {
            return this.h3;
        }

        public RichTextEditorI18n setH3(String h3) {
            this.h3 = h3;
            return this;
        }

        public String getSubscript() {
            return this.subscript;
        }

        public RichTextEditorI18n setSubscript(String subscript) {
            this.subscript = subscript;
            return this;
        }

        public String getSuperscript() {
            return this.superscript;
        }

        public RichTextEditorI18n setSuperscript(String superscript) {
            this.superscript = superscript;
            return this;
        }

        public String getListOrdered() {
            return this.listOrdered;
        }

        public RichTextEditorI18n setListOrdered(String listOrdered) {
            this.listOrdered = listOrdered;
            return this;
        }

        public String getListBullet() {
            return this.listBullet;
        }

        public RichTextEditorI18n setListBullet(String listBullet) {
            this.listBullet = listBullet;
            return this;
        }

        public String getAlignLeft() {
            return this.alignLeft;
        }

        public RichTextEditorI18n setAlignLeft(String alignLeft) {
            this.alignLeft = alignLeft;
            return this;
        }

        public String getAlignCenter() {
            return this.alignCenter;
        }

        public RichTextEditorI18n setAlignCenter(String alignCenter) {
            this.alignCenter = alignCenter;
            return this;
        }

        public String getAlignRight() {
            return this.alignRight;
        }

        public RichTextEditorI18n setAlignRight(String alignRight) {
            this.alignRight = alignRight;
            return this;
        }

        public String getImage() {
            return this.image;
        }

        public RichTextEditorI18n setImage(String image) {
            this.image = image;
            return this;
        }

        public String getLink() {
            return this.link;
        }

        public RichTextEditorI18n setLink(String link) {
            this.link = link;
            return this;
        }

        public String getBlockquote() {
            return this.blockquote;
        }

        public RichTextEditorI18n setBlockquote(String blockquote) {
            this.blockquote = blockquote;
            return this;
        }

        public String getCodeBlock() {
            return this.codeBlock;
        }

        public RichTextEditorI18n setCodeBlock(String codeBlock) {
            this.codeBlock = codeBlock;
            return this;
        }

        public String getClean() {
            return this.clean;
        }

        public RichTextEditorI18n setClean(String clean) {
            this.clean = clean;
            return this;
        }

        public String toString() {
            return "[" + this.undo + ", " + this.redo + ", " + this.bold + ", " + this.italic + ", " + this.underline + ", " + this.strike + ", " + this.h1 + ", " + this.h2 + ", " + this.h3 + ", " + this.subscript + ", " + this.superscript + ", " + this.listOrdered + ", " + this.listBullet + ", " + this.alignLeft + ", " + this.alignCenter + ", " + this.alignRight + ", " + this.image + ", " + this.link + ", " + this.blockquote + ", " + this.codeBlock + ", " + this.clean + "]";
        }
    }

    private class HtmlSetRequest
    implements Serializable {
        private String html;
        private boolean pending;

        private HtmlSetRequest() {
        }

        void requestUpdate(String htmlValueString) {
            String string = this.html = htmlValueString != null ? RichTextEditor.this.sanitize(htmlValueString) : null;
            if (!this.pending) {
                RichTextEditor.this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.execute());
                this.pending = true;
            }
        }

        void execute() {
            if (RichTextEditor.this.getValueChangeMode() != ValueChangeMode.EAGER) {
                String JS = "var listener = e => {  this.$server.updateValue(e.detail.value);  this.removeEventListener('value-changed', listener);  listener = null; };this.addEventListener('value-changed', listener);";
                RichTextEditor.this.getElement().executeJs("var listener = e => {  this.$server.updateValue(e.detail.value);  this.removeEventListener('value-changed', listener);  listener = null; };this.addEventListener('value-changed', listener);", new Serializable[0]);
            }
            RichTextEditor.this.getElement().callJsFunction("dangerouslySetHtmlValue", new Serializable[]{this.html});
            this.pending = false;
        }
    }
}

