/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.richtexteditor;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.CompositionNotifier;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.InputNotifier;
import com.vaadin.flow.component.KeyNotifier;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.richtexteditor.RichTextEditorVariant;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.data.value.HasValueChangeMode;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.Objects;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;

@Tag(value="vaadin-rich-text-editor")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.1.2"), @NpmPackage(value="@vaadin/rich-text-editor", version="24.1.2")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/rich-text-editor/src/vaadin-rich-text-editor.js")})
public class RichTextEditor
extends AbstractSinglePropertyField<RichTextEditor, String>
implements CompositionNotifier,
InputNotifier,
KeyNotifier,
HasSize,
HasStyle,
HasValueChangeMode,
HasThemeVariant<RichTextEditorVariant> {
    private ValueChangeMode currentMode;
    private RichTextEditorI18n i18n;
    private AsHtml asHtml;
    private AsDelta asDelta;

    public RichTextEditorI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(RichTextEditorI18n i18n) {
        Objects.requireNonNull(i18n, "The I18N properties object should not be null");
        this.i18n = i18n;
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            if (i18n == this.i18n) {
                JsonObject i18nObject = (JsonObject)JsonSerializer.toJson((Object)this.i18n);
                for (String key : i18nObject.keys()) {
                    this.getElement().executeJs("this.set('i18n." + key + "', $0)", new Serializable[]{i18nObject.get(key)});
                }
            }
        });
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public RichTextEditor() {
        super("htmlValue", (Object)"", String.class, RichTextEditor::presentationToModel, RichTextEditor::modelToPresentation);
        this.setPresentationValue("");
        this.setValueChangeMode(ValueChangeMode.ON_CHANGE);
    }

    public RichTextEditor(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<RichTextEditor, String>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    protected void onAttach(AttachEvent attachEvent) {
        this.setPresentationValue(this.getValue());
    }

    public ValueChangeMode getValueChangeMode() {
        return this.currentMode;
    }

    public void setValueChangeMode(ValueChangeMode valueChangeMode) {
        this.currentMode = valueChangeMode;
        this.setSynchronizedEvent(ValueChangeMode.eventForMode((ValueChangeMode)valueChangeMode, (String)"html-value-changed"));
    }

    public void setValue(String value) {
        this.doSetValue(value, true);
    }

    private void doSetValue(String value, boolean withDeltaCheck) {
        Objects.requireNonNull(value, "Null value is not supported");
        if (withDeltaCheck) {
            this.checkForDeltaValue(value);
        }
        super.setValue((Object)value);
    }

    private void checkForDeltaValue(String value) {
        if ((value = value.trim()).startsWith("[") || value.startsWith("{")) {
            throw new IllegalArgumentException("The value starts with either '[' or '{' which indicates that this might be a value in the Delta format. Since v24, RichTextEditor.setValue only accepts values in the HTML format. Please check the JavaDoc for RichTextEditor.setValue for more information.");
        }
    }

    protected void setPresentationValue(String newPresentationValue) {
        String presentationValue = RichTextEditor.modelToPresentation(newPresentationValue);
        this.getElement().setProperty("htmlValue", presentationValue);
        this.getElement().callJsFunction("dangerouslySetHtmlValue", new Serializable[]{presentationValue});
    }

    private static String presentationToModel(String htmlValue) {
        return RichTextEditor.sanitize(htmlValue);
    }

    private static String modelToPresentation(String htmlValue) {
        return RichTextEditor.sanitize(htmlValue);
    }

    public String getValue() {
        return (String)super.getValue();
    }

    @Deprecated
    public String getHtmlValue() {
        return this.getValue();
    }

    @Synchronize(property="value", value={"value-changed"})
    private String getDeltaValue() {
        return this.getElement().getProperty("value");
    }

    static String sanitize(String html) {
        return Jsoup.clean((String)html, (Safelist)Safelist.basic().addTags(new String[]{"img", "h1", "h2", "h3", "s"}).addAttributes("img", new String[]{"align", "alt", "height", "src", "title", "width"}).addAttributes(":all", new String[]{"style"}).addProtocols("img", "src", new String[]{"data"}));
    }

    public HasValue<HasValue.ValueChangeEvent<String>, String> asHtml() {
        if (this.asHtml == null) {
            this.asHtml = new AsHtml();
        }
        return this.asHtml;
    }

    public HasValue<HasValue.ValueChangeEvent<String>, String> asDelta() {
        if (this.asDelta == null) {
            this.asDelta = new AsDelta();
        }
        return this.asDelta;
    }

    public static class RichTextEditorI18n
    implements Serializable {
        private String undo;
        private String redo;
        private String bold;
        private String italic;
        private String underline;
        private String strike;
        private String h1;
        private String h2;
        private String h3;
        private String subscript;
        private String superscript;
        private String listOrdered;
        private String listBullet;
        private String alignLeft;
        private String alignCenter;
        private String alignRight;
        private String image;
        private String link;
        private String blockquote;
        private String codeBlock;
        private String clean;

        public String getUndo() {
            return this.undo;
        }

        public RichTextEditorI18n setUndo(String undo) {
            this.undo = undo;
            return this;
        }

        public String getRedo() {
            return this.redo;
        }

        public RichTextEditorI18n setRedo(String redo) {
            this.redo = redo;
            return this;
        }

        public String getBold() {
            return this.bold;
        }

        public RichTextEditorI18n setBold(String bold) {
            this.bold = bold;
            return this;
        }

        public String getItalic() {
            return this.italic;
        }

        public RichTextEditorI18n setItalic(String italic) {
            this.italic = italic;
            return this;
        }

        public String getUnderline() {
            return this.underline;
        }

        public RichTextEditorI18n setUnderline(String underline) {
            this.underline = underline;
            return this;
        }

        public String getStrike() {
            return this.strike;
        }

        public RichTextEditorI18n setStrike(String strike) {
            this.strike = strike;
            return this;
        }

        public String getH1() {
            return this.h1;
        }

        public RichTextEditorI18n setH1(String h1) {
            this.h1 = h1;
            return this;
        }

        public String getH2() {
            return this.h2;
        }

        public RichTextEditorI18n setH2(String h2) {
            this.h2 = h2;
            return this;
        }

        public String getH3() {
            return this.h3;
        }

        public RichTextEditorI18n setH3(String h3) {
            this.h3 = h3;
            return this;
        }

        public String getSubscript() {
            return this.subscript;
        }

        public RichTextEditorI18n setSubscript(String subscript) {
            this.subscript = subscript;
            return this;
        }

        public String getSuperscript() {
            return this.superscript;
        }

        public RichTextEditorI18n setSuperscript(String superscript) {
            this.superscript = superscript;
            return this;
        }

        public String getListOrdered() {
            return this.listOrdered;
        }

        public RichTextEditorI18n setListOrdered(String listOrdered) {
            this.listOrdered = listOrdered;
            return this;
        }

        public String getListBullet() {
            return this.listBullet;
        }

        public RichTextEditorI18n setListBullet(String listBullet) {
            this.listBullet = listBullet;
            return this;
        }

        public String getAlignLeft() {
            return this.alignLeft;
        }

        public RichTextEditorI18n setAlignLeft(String alignLeft) {
            this.alignLeft = alignLeft;
            return this;
        }

        public String getAlignCenter() {
            return this.alignCenter;
        }

        public RichTextEditorI18n setAlignCenter(String alignCenter) {
            this.alignCenter = alignCenter;
            return this;
        }

        public String getAlignRight() {
            return this.alignRight;
        }

        public RichTextEditorI18n setAlignRight(String alignRight) {
            this.alignRight = alignRight;
            return this;
        }

        public String getImage() {
            return this.image;
        }

        public RichTextEditorI18n setImage(String image) {
            this.image = image;
            return this;
        }

        public String getLink() {
            return this.link;
        }

        public RichTextEditorI18n setLink(String link) {
            this.link = link;
            return this;
        }

        public String getBlockquote() {
            return this.blockquote;
        }

        public RichTextEditorI18n setBlockquote(String blockquote) {
            this.blockquote = blockquote;
            return this;
        }

        public String getCodeBlock() {
            return this.codeBlock;
        }

        public RichTextEditorI18n setCodeBlock(String codeBlock) {
            this.codeBlock = codeBlock;
            return this;
        }

        public String getClean() {
            return this.clean;
        }

        public RichTextEditorI18n setClean(String clean) {
            this.clean = clean;
            return this;
        }

        public String toString() {
            return "[" + this.undo + ", " + this.redo + ", " + this.bold + ", " + this.italic + ", " + this.underline + ", " + this.strike + ", " + this.h1 + ", " + this.h2 + ", " + this.h3 + ", " + this.subscript + ", " + this.superscript + ", " + this.listOrdered + ", " + this.listBullet + ", " + this.alignLeft + ", " + this.alignCenter + ", " + this.alignRight + ", " + this.image + ", " + this.link + ", " + this.blockquote + ", " + this.codeBlock + ", " + this.clean + "]";
        }
    }

    private class AsHtml
    implements HasValue<HasValue.ValueChangeEvent<String>, String> {
        private AsHtml() {
        }

        public void setValue(String value) {
            RichTextEditor.this.doSetValue(value, false);
        }

        public String getValue() {
            return RichTextEditor.this.getValue();
        }

        public Registration addValueChangeListener(HasValue.ValueChangeListener listener) {
            return RichTextEditor.this.addValueChangeListener(listener);
        }

        public void setReadOnly(boolean readOnly) {
            RichTextEditor.this.setReadOnly(readOnly);
        }

        public boolean isReadOnly() {
            return RichTextEditor.this.isReadOnly();
        }

        public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
            RichTextEditor.this.setRequiredIndicatorVisible(requiredIndicatorVisible);
        }

        public boolean isRequiredIndicatorVisible() {
            return RichTextEditor.this.isRequiredIndicatorVisible();
        }

        public String getEmptyValue() {
            return "";
        }
    }

    private class AsDelta
    implements HasValue<HasValue.ValueChangeEvent<String>, String> {
        private boolean isHtmlValueSync;
        private Registration deltaValueSyncRegistration;
        private String oldValue = "";

        public AsDelta() {
            RichTextEditor.this.getElement().setProperty("value", "");
            RichTextEditor.this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                if (this.isHtmlValueSync) {
                    return;
                }
                if (!event.isFromClient()) {
                    if (this.deltaValueSyncRegistration != null) {
                        this.deltaValueSyncRegistration.remove();
                    }
                    PropertyChangeListener & Serializable valueChangeListener = (PropertyChangeListener & Serializable)syncEvent -> {
                        if (syncEvent.isUserOriginated()) {
                            this.deltaValueSyncRegistration.remove();
                            this.fireChangeEvent(false);
                            this.oldValue = this.getValue();
                        }
                    };
                    this.deltaValueSyncRegistration = RichTextEditor.this.getElement().addPropertyChangeListener("value", "value-changed", (PropertyChangeListener)valueChangeListener);
                } else {
                    this.fireChangeEvent(event.isFromClient());
                    this.oldValue = this.getValue();
                }
            });
        }

        public void setValue(String value) {
            Objects.requireNonNull(value, "Delta value must not be null");
            if (!Objects.equals(value, this.getValue())) {
                RichTextEditor.this.getElement().setProperty("value", value);
                RichTextEditor.this.getElement().executeJs("return this.htmlValue", new Serializable[0]).then((SerializableConsumer & Serializable)jsonValue -> {
                    this.isHtmlValueSync = true;
                    RichTextEditor.this.setValue(jsonValue.asString());
                    this.isHtmlValueSync = false;
                });
                this.fireChangeEvent(false);
                this.oldValue = value;
            }
        }

        public String getValue() {
            return RichTextEditor.this.getElement().getProperty("value");
        }

        public Registration addValueChangeListener(HasValue.ValueChangeListener<? super HasValue.ValueChangeEvent<String>> valueChangeListener) {
            return ComponentUtil.addListener((Component)RichTextEditor.this, DeltaValueChangeEvent.class, arg_0 -> valueChangeListener.valueChanged(arg_0));
        }

        private void fireChangeEvent(boolean isFromClient) {
            DeltaValueChangeEvent changeEvent = new DeltaValueChangeEvent(RichTextEditor.this, this, this.oldValue, isFromClient);
            ComponentUtil.fireEvent((Component)RichTextEditor.this, (ComponentEvent)changeEvent);
        }

        public void setReadOnly(boolean readOnly) {
            RichTextEditor.this.setReadOnly(readOnly);
        }

        public boolean isReadOnly() {
            return RichTextEditor.this.isReadOnly();
        }

        public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
            RichTextEditor.this.setRequiredIndicatorVisible(requiredIndicatorVisible);
        }

        public boolean isRequiredIndicatorVisible() {
            return RichTextEditor.this.isRequiredIndicatorVisible();
        }

        public String getEmptyValue() {
            return "";
        }

        public void clear() {
            RichTextEditor.this.clear();
        }

        private static class DeltaValueChangeEvent
        extends ComponentEvent<RichTextEditor>
        implements HasValue.ValueChangeEvent<String> {
            private final HasValue<?, String> hasValue;
            private final String oldValue;

            public DeltaValueChangeEvent(RichTextEditor source, HasValue<?, String> hasValue, String oldValue, boolean fromClient) {
                super((Component)source, fromClient);
                this.hasValue = hasValue;
                this.oldValue = oldValue;
            }

            public HasValue<?, String> getHasValue() {
                return this.hasValue;
            }

            public boolean isFromClient() {
                return super.isFromClient();
            }

            public String getOldValue() {
                return this.oldValue;
            }

            public String getValue() {
                return (String)this.hasValue.getValue();
            }
        }
    }
}

