/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.select;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HasPlaceholder;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.select.SelectVariant;
import com.vaadin.flow.component.select.VaadinItem;
import com.vaadin.flow.component.select.data.SelectDataView;
import com.vaadin.flow.component.select.data.SelectListDataView;
import com.vaadin.flow.component.shared.ClientValidationUtil;
import com.vaadin.flow.component.shared.HasClientValidation;
import com.vaadin.flow.component.shared.HasOverlayClassName;
import com.vaadin.flow.component.shared.HasPrefix;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.HasValidationProperties;
import com.vaadin.flow.component.shared.InputField;
import com.vaadin.flow.component.shared.ValidationUtil;
import com.vaadin.flow.component.shared.internal.ValidationController;
import com.vaadin.flow.data.binder.HasItemComponents;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderWrapper;
import com.vaadin.flow.data.provider.DataViewUtils;
import com.vaadin.flow.data.provider.HasDataView;
import com.vaadin.flow.data.provider.HasListDataView;
import com.vaadin.flow.data.provider.IdentifierProvider;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.ItemCountChangeEvent;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.data.selection.SingleSelect;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Stream;

@Tag(value="vaadin-select")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.6.2"), @NpmPackage(value="@vaadin/select", version="24.6.2")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/select/src/vaadin-select.js"), @JsModule(value="./selectConnector.js")})
public class Select<T>
extends AbstractSinglePropertyField<Select<T>, T>
implements Focusable<Select<T>>,
HasAriaLabel,
HasClientValidation,
HasDataView<T, Void, SelectDataView<T>>,
HasItemComponents<T>,
InputField<AbstractField.ComponentValueChangeEvent<Select<T>, T>, T>,
HasListDataView<T, SelectListDataView<T>>,
HasOverlayClassName,
HasPrefix,
HasThemeVariant<SelectVariant>,
HasValidationProperties,
HasValidator<T>,
SingleSelect<Select<T>, T>,
HasPlaceholder {
    public static final String LABEL_ATTRIBUTE = "label";
    private static final String VALUE_PROPERTY_NAME = "value";
    private final InternalListBox listBox = new InternalListBox();
    private final AtomicReference<DataProvider<T, ?>> dataProvider = new AtomicReference<ListDataProvider>(DataProvider.ofItems((Object[])new Object[0]));
    private ComponentRenderer<? extends Component, T> itemRenderer;
    private SerializablePredicate<T> itemEnabledProvider = null;
    private ItemLabelGenerator<T> itemLabelGenerator = null;
    private Registration dataProviderListenerRegistration;
    private boolean resetPending = true;
    private boolean emptySelectionAllowed;
    private String emptySelectionCaption;
    private VaadinItem<T> emptySelectionItem;
    private final KeyMapper<T> keyMapper = new KeyMapper();
    private int lastNotifiedDataSize = -1;
    private volatile int lastFetchedDataSize = -1;
    private SerializableConsumer<UI> sizeRequest;
    private SelectI18n i18n;
    private Validator<T> defaultValidator = (Validator & Serializable)(value, context) -> {
        boolean fromComponent = context == null;
        boolean isRequired = fromComponent && this.isRequiredIndicatorVisible();
        return ValidationUtil.validateRequiredConstraint((String)this.getI18nErrorMessage(SelectI18n::getRequiredErrorMessage), (boolean)isRequired, (Object)this.getValue(), (Object)this.getEmptyValue());
    };
    private ValidationController<Select<T>, T> validationController = new ValidationController((Component)this);

    public Select() {
        super(VALUE_PROPERTY_NAME, null, String.class, Select::presentationToModel, Select::modelToPresentation);
        this.setInvalid(false);
        this.setOpened(false);
        this.setPresentationValue(null);
        this.getElement().appendChild(new Element[]{this.listBox.getElement()});
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        this.getElement().addPropertyChangeListener("opened", (PropertyChangeListener & Serializable)event -> this.fireEvent(new OpenedChangeEvent(this, event.isUserOriginated())));
        this.getElement().addPropertyChangeListener("invalid", (PropertyChangeListener & Serializable)event -> this.fireEvent(new InvalidChangeEvent(this, event.isUserOriginated())));
    }

    public Select(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<Select<T>, T>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public Select(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<Select<T>, T>> listener) {
        this();
        this.setLabel(label);
        this.addValueChangeListener(listener);
    }

    @SafeVarargs
    public Select(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<Select<T>, T>> listener, T ... items) {
        this(label, listener);
        this.setItems(items);
    }

    private static <T> T presentationToModel(Select<T> select, String presentation) {
        if (select.keyMapper == null) {
            return null;
        }
        if (!select.keyMapper.containsKey(presentation)) {
            return null;
        }
        return (T)select.keyMapper.get(presentation);
    }

    private static <T> String modelToPresentation(Select<T> select, T model) {
        if (model == null) {
            return "";
        }
        if (!select.keyMapper.has(model)) {
            return null;
        }
        return select.keyMapper.key(model);
    }

    public ComponentRenderer<? extends Component, T> getItemRenderer() {
        return this.itemRenderer;
    }

    public void setRenderer(ComponentRenderer<? extends Component, T> renderer) {
        this.itemRenderer = renderer;
        this.refreshItems();
    }

    public void setTextRenderer(ItemLabelGenerator<T> itemLabelGenerator) {
        Objects.requireNonNull(itemLabelGenerator);
        this.setRenderer((ComponentRenderer<? extends Component, T>)new TextRenderer(itemLabelGenerator));
    }

    public void setEmptySelectionAllowed(boolean emptySelectionAllowed) {
        if (this.isEmptySelectionAllowed() == emptySelectionAllowed) {
            return;
        }
        if (this.isEmptySelectionAllowed()) {
            this.removeEmptySelectionItem();
        } else {
            this.addEmptySelectionItem();
        }
        this.emptySelectionAllowed = emptySelectionAllowed;
    }

    public boolean isEmptySelectionAllowed() {
        return this.emptySelectionAllowed;
    }

    public void setEmptySelectionCaption(String emptySelectionCaption) {
        Objects.requireNonNull(emptySelectionCaption, "Empty selection caption must not be null");
        this.emptySelectionCaption = emptySelectionCaption;
        if (this.emptySelectionItem != null) {
            this.updateItem(this.emptySelectionItem);
        }
    }

    public String getEmptySelectionCaption() {
        return this.emptySelectionCaption == null ? "" : this.emptySelectionCaption;
    }

    public SerializablePredicate<T> getItemEnabledProvider() {
        return this.itemEnabledProvider;
    }

    public void setItemEnabledProvider(SerializablePredicate<T> itemEnabledProvider) {
        this.itemEnabledProvider = itemEnabledProvider;
        this.refreshItems();
    }

    public ItemLabelGenerator<T> getItemLabelGenerator() {
        return this.itemLabelGenerator;
    }

    public void setItemLabelGenerator(ItemLabelGenerator<T> itemLabelGenerator) {
        this.itemLabelGenerator = itemLabelGenerator;
        this.refreshItems();
    }

    public void setPlaceholder(String placeholder) {
        super.setPlaceholder(placeholder);
    }

    public void setLabel(String label) {
        this.getElement().setProperty(LABEL_ATTRIBUTE, label == null ? "" : label);
    }

    public String getLabel() {
        return this.getElement().getProperty(LABEL_ATTRIBUTE);
    }

    public void setAriaLabel(String ariaLabel) {
        this.getElement().setProperty("accessibleName", ariaLabel);
    }

    public Optional<String> getAriaLabel() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleName"));
    }

    public void setAriaLabelledBy(String ariaLabelledBy) {
        this.getElement().setProperty("accessibleNameRef", ariaLabelledBy);
    }

    public Optional<String> getAriaLabelledBy() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleNameRef"));
    }

    public void setAutofocus(boolean autofocus) {
        this.getElement().setProperty("autofocus", autofocus);
    }

    public boolean isAutofocus() {
        return this.getElement().getProperty("autofocus", false);
    }

    public void setNoVerticalOverlap(boolean noVerticalOverlap) {
        this.getElement().setProperty("noVerticalOverlap", noVerticalOverlap);
    }

    public boolean isNoVerticalOverlap() {
        return this.getElement().getProperty("noVerticalOverlap", false);
    }

    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        this.dataProvider.set(dataProvider);
        DataViewUtils.removeComponentFilterAndSortComparator((Component)this);
        this.reset();
        if (this.dataProviderListenerRegistration != null) {
            this.dataProviderListenerRegistration.remove();
        }
        this.dataProviderListenerRegistration = dataProvider.addDataProviderListener(this::onDataChange);
    }

    public DataProvider<T, ?> getDataProvider() {
        return this.dataProvider.get();
    }

    public SelectDataView<T> setItems(DataProvider<T, Void> dataProvider) {
        this.setDataProvider(dataProvider);
        return this.getGenericDataView();
    }

    public SelectDataView<T> setItems(InMemoryDataProvider<T> inMemoryDataProvider) {
        DataProviderWrapper convertedDataProvider = new DataProviderWrapper<T, Void, SerializablePredicate<T>>((DataProvider)inMemoryDataProvider, (InMemoryDataProvider)inMemoryDataProvider){
            final /* synthetic */ InMemoryDataProvider val$inMemoryDataProvider;
            {
                this.val$inMemoryDataProvider = inMemoryDataProvider;
                super(arg0);
            }

            protected SerializablePredicate<T> getFilter(Query<T, Void> query) {
                return Optional.ofNullable(this.val$inMemoryDataProvider.getFilter()).orElse((SerializablePredicate & Serializable)item -> true);
            }
        };
        return this.setItems((DataProvider<T, Void>)convertedDataProvider);
    }

    public SelectListDataView<T> setItems(ListDataProvider<T> dataProvider) {
        this.setDataProvider((DataProvider<T, ?>)dataProvider);
        return this.getListDataView();
    }

    public SelectDataView<T> getGenericDataView() {
        return new SelectDataView(this::getDataProvider, this, this::identifierProviderChanged);
    }

    public SelectListDataView<T> getListDataView() {
        return new SelectListDataView(this::getDataProvider, this, this::identifierProviderChanged, (SerializableBiConsumer & Serializable)(filter, sorting) -> this.reset());
    }

    public void onEnabledStateChanged(boolean enabled) {
        this.getElement().setProperty("disabled", !enabled);
        this.getItems().forEach(this::updateItemEnabled);
    }

    public void setRequiredIndicatorVisible(boolean required) {
        super.setRequiredIndicatorVisible(required);
    }

    public boolean isRequiredIndicatorVisible() {
        return super.isRequiredIndicatorVisible();
    }

    public void add(Component ... components) {
        Objects.requireNonNull(components, "Components should not be null");
        for (Component component : components) {
            if (component.getElement().hasAttribute("slot")) {
                super.add(new Component[]{component});
                continue;
            }
            this.listBox.add(new Component[]{component});
        }
    }

    public void addComponents(T afterItem, Component ... components) {
        this.listBox.addComponents(afterItem, components);
    }

    public void prependComponents(T beforeItem, Component ... components) {
        this.listBox.prependComponents(beforeItem, components);
    }

    public int getItemPosition(T item) {
        return this.listBox.getItemPosition(item);
    }

    public void addComponentAtIndex(int index, Component component) {
        Objects.requireNonNull(component, "Component should not be null");
        if (component.getElement().hasAttribute("slot")) {
            super.addComponentAtIndex(index, component);
        } else {
            this.listBox.addComponentAtIndex(index, component);
        }
    }

    public void addComponentAsFirst(Component component) {
        Objects.requireNonNull(component, "Component should not be null");
        if (component.getElement().hasAttribute("slot")) {
            super.addComponentAsFirst(component);
        } else {
            this.listBox.addComponentAsFirst(component);
        }
    }

    public Stream<Component> getChildren() {
        return Stream.concat(super.getChildren().filter(component -> component != this.listBox), this.listBox.getChildren().filter(component -> !(component instanceof VaadinItem)));
    }

    public void remove(Component ... components) {
        Objects.requireNonNull(components, "Components should not be null");
        for (Component component : components) {
            if (component.getElement().hasAttribute("slot")) {
                if (!this.getElement().equals((Object)component.getElement().getParent())) continue;
                component.getElement().removeAttribute("slot");
                this.getElement().removeChild(new Element[]{component.getElement()});
                continue;
            }
            this.listBox.remove(components);
        }
    }

    public void removeAll() {
        this.getChildren().forEach(xva$0 -> this.remove((Component)xva$0));
    }

    public void setOverlayWidth(String width) {
        this.getStyle().set("--vaadin-select-overlay-width", width);
    }

    public void setOverlayWidth(float width, Unit unit) {
        Objects.requireNonNull(unit, "Unit can not be null");
        this.setOverlayWidth(HasSize.getCssSize((float)width, (Unit)unit));
    }

    protected void setOpened(boolean opened) {
        this.getElement().setProperty("opened", opened);
    }

    @Synchronize(property="opened", value={"opened-changed"})
    protected boolean isOpened() {
        return this.getElement().getProperty("opened", false);
    }

    protected boolean hasValidValue() {
        String selectedKey = this.getElement().getProperty(VALUE_PROPERTY_NAME);
        Object item = this.keyMapper.get(selectedKey);
        if (item == null) {
            return this.isEmptySelectionAllowed() && this.isItemEnabled(item);
        }
        return this.isItemEnabled(item);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.initConnector();
        ClientValidationUtil.preventWebComponentFromModifyingInvalidState((Component)this);
    }

    protected boolean valueEquals(T value1, T value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return this.getItemId(value1).equals(this.getItemId(value2));
    }

    private void initConnector() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            ui.getPage().executeJs("window.Vaadin.Flow.selectConnector.initLazy($0)", new Serializable[]{this.getElement()});
            this.resetPending = false;
        });
    }

    private boolean isItemEnabled(T item) {
        return this.itemEnabledProvider == null || this.itemEnabledProvider.test(item);
    }

    private Component createItem(T bean) {
        VaadinItem<T> item = new VaadinItem<T>(this.keyMapper.key(bean), bean);
        this.updateItem(item);
        return item;
    }

    private void updateItem(VaadinItem<T> vaadinItem) {
        vaadinItem.removeAll();
        T item = vaadinItem.getItem();
        if (vaadinItem == this.emptySelectionItem) {
            vaadinItem.setText(this.emptySelectionCaption);
        } else if (this.getItemRenderer() != null) {
            vaadinItem.add(new Component[]{this.getItemRenderer().createComponent(item)});
        } else if (this.getItemLabelGenerator() != null) {
            vaadinItem.setText(this.getItemLabelGenerator().apply(item));
        } else {
            vaadinItem.setText(item.toString());
        }
        if (this.getItemLabelGenerator() != null) {
            vaadinItem.getElement().setAttribute(LABEL_ATTRIBUTE, this.getItemLabelGenerator().apply(item));
        } else if (item == this.emptySelectionItem) {
            vaadinItem.getElement().setAttribute(LABEL_ATTRIBUTE, "");
        } else {
            vaadinItem.getElement().removeAttribute(LABEL_ATTRIBUTE);
        }
        this.updateItemEnabled(vaadinItem);
        this.requestClientSideContentUpdateIfNotPending();
    }

    private void updateItemEnabled(VaadinItem<T> item) {
        boolean itemEnabled = this.isItemEnabled(item.getItem());
        boolean isDisabled = this.getElement().getProperty("disabled", false);
        boolean disabled = isDisabled || !itemEnabled;
        item.getElement().setEnabled(!disabled);
        item.getElement().setAttribute("disabled", !itemEnabled);
    }

    private void refreshItems() {
        this.getItems().forEach(this::updateItem);
    }

    private Stream<VaadinItem<T>> getItems() {
        return this.listBox.getChildren().filter(component -> component instanceof VaadinItem).map(child -> (VaadinItem)((Object)child));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        this.keyMapper.removeAll();
        this.listBox.removeAll();
        this.clear();
        this.requestClientSideContentUpdateIfNotPending();
        if (this.isEmptySelectionAllowed()) {
            this.addEmptySelectionItem();
        }
        AtomicReference<DataProvider<T, ?>> atomicReference = this.dataProvider;
        synchronized (atomicReference) {
            AtomicInteger itemCounter = new AtomicInteger(0);
            this.getDataProvider().fetch(DataViewUtils.getQuery((Component)this)).map(item -> this.createItem(item)).forEach(component -> {
                this.add((Component)component);
                itemCounter.incrementAndGet();
            });
            this.lastFetchedDataSize = itemCounter.get();
            if (this.sizeRequest == null) {
                this.sizeRequest = (SerializableConsumer & Serializable)ui -> {
                    this.fireSizeEvent();
                    this.sizeRequest = null;
                };
                this.runBeforeClientResponse(this.sizeRequest);
            }
        }
    }

    private void requestClientSideContentUpdateIfNotPending() {
        if (!this.resetPending) {
            this.resetPending = true;
            this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
                ui.getPage().executeJs("$0.requestContentUpdate();", new Serializable[]{this.getElement()});
                this.resetPending = false;
            });
        }
    }

    private void onDataChange(DataChangeEvent<T> event) {
        if (event instanceof DataChangeEvent.DataRefreshEvent) {
            Object updatedItem = ((DataChangeEvent.DataRefreshEvent)event).getItem();
            IdentifierProvider identifierProvider = this.getIdentifierProvider();
            Object updatedItemId = identifierProvider.apply(updatedItem);
            this.keyMapper.refresh(updatedItem);
            this.getItems().filter(vaadinItem -> updatedItemId.equals(identifierProvider.apply(vaadinItem.getItem()))).findAny().ifPresent(item -> {
                item.setItem(updatedItem);
                this.updateItem((VaadinItem<T>)((Object)item));
            });
        } else {
            this.reset();
        }
    }

    private void addEmptySelectionItem() {
        if (this.emptySelectionItem == null) {
            this.emptySelectionItem = new VaadinItem<Object>("", null);
        }
        this.updateItem(this.emptySelectionItem);
        this.addComponentAsFirst(this.emptySelectionItem);
        if (this.getValue() == null) {
            this.setValue(null);
        }
    }

    private void removeEmptySelectionItem() {
        if (this.emptySelectionItem != null) {
            this.listBox.remove(new Component[]{this.emptySelectionItem});
        }
        this.emptySelectionItem = null;
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    private void fireSizeEvent() {
        int newSize = this.lastFetchedDataSize;
        if (this.lastNotifiedDataSize != newSize) {
            this.lastNotifiedDataSize = newSize;
            this.fireEvent((ComponentEvent)new ItemCountChangeEvent((Component)this, newSize, false));
        }
    }

    private IdentifierProvider<T> getIdentifierProvider() {
        IdentifierProvider identifierProviderObject = (IdentifierProvider)ComponentUtil.getData((Component)this, IdentifierProvider.class);
        if (identifierProviderObject == null) {
            DataProvider<T, ?> dataProvider = this.getDataProvider();
            if (dataProvider != null) {
                return arg_0 -> dataProvider.getId(arg_0);
            }
            return IdentifierProvider.identity();
        }
        return identifierProviderObject;
    }

    private Object getItemId(T item) {
        return this.getIdentifierProvider().apply(item);
    }

    private void identifierProviderChanged(IdentifierProvider<T> identifierProvider) {
        this.keyMapper.setIdentifierGetter(identifierProvider);
    }

    public void setManualValidation(boolean enabled) {
        this.validationController.setManualValidation(enabled);
    }

    public Validator<T> getDefaultValidator() {
        return this.defaultValidator;
    }

    protected void validate() {
        this.validationController.validate(this.getValue());
    }

    protected Registration addOpenedChangeListener(ComponentEventListener<OpenedChangeEvent> listener) {
        return this.addListener(OpenedChangeEvent.class, listener);
    }

    protected Registration addInvalidChangeListener(ComponentEventListener<InvalidChangeEvent> listener) {
        return this.addListener(InvalidChangeEvent.class, listener);
    }

    public SelectI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(SelectI18n i18n) {
        this.i18n = Objects.requireNonNull(i18n, "The i18n properties object should not be null");
    }

    private String getI18nErrorMessage(Function<SelectI18n, String> getter) {
        return Optional.ofNullable(this.i18n).map(getter).orElse("");
    }

    @Tag(value="vaadin-select-list-box")
    @NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.6.2")
    @JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js")
    private class InternalListBox
    extends Component
    implements HasItemComponents<T> {
        private InternalListBox() {
        }

        public int getItemPosition(T item) {
            if (item == null && Select.this.isEmptySelectionAllowed()) {
                return 0;
            }
            return super.getItemPosition(item);
        }
    }

    public static class OpenedChangeEvent
    extends ComponentEvent<Select> {
        private final boolean opened;

        public OpenedChangeEvent(Select source, boolean fromClient) {
            super((Component)source, fromClient);
            this.opened = source.isOpened();
        }

        public boolean isOpened() {
            return this.opened;
        }
    }

    public static class InvalidChangeEvent
    extends ComponentEvent<Select> {
        private final boolean invalid;

        public InvalidChangeEvent(Select source, boolean fromClient) {
            super((Component)source, fromClient);
            this.invalid = source.isInvalid();
        }

        public boolean isInvalid() {
            return this.invalid;
        }
    }

    public static class SelectI18n
    implements Serializable {
        private String requiredErrorMessage;

        public String getRequiredErrorMessage() {
            return this.requiredErrorMessage;
        }

        public SelectI18n setRequiredErrorMessage(String errorMessage) {
            this.requiredErrorMessage = errorMessage;
            return this;
        }
    }
}

