/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.components.grid;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;

import com.vaadin.event.selection.SelectionListener;
import com.vaadin.server.AbstractExtension;
import com.vaadin.shared.Registration;

/**
 * Selection model that doesn't allow selecting anything from the grid.
 *
 * @author Vaadin Ltd
 *
 * @since 8.0
 *
 * @param <T>
 *            the type of items in the grid
 */
public class NoSelectionModel<T> extends AbstractExtension
        implements GridSelectionModel<T> {

    @Override
    public Set<T> getSelectedItems() {
        return Collections.emptySet();
    }

    @Override
    public Optional<T> getFirstSelectedItem() {
        return Optional.empty();
    }

    @Override
    public void select(T item) {
    }

    @Override
    public void deselect(T item) {
    }

    @Override
    public void deselectAll() {
    }

    @Override
    public Registration addSelectionListener(SelectionListener<T> listener) {
        throw new UnsupportedOperationException(
                "This selection model doesn't allow selection, cannot add selection listeners to it");
    }

    @Override
    public void setUserSelectionAllowed(boolean allowed) {
    }

    @Override
    public boolean isUserSelectionAllowed() {
        return false;
    }

}
