/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui;

import com.vaadin.server.SerializableFunction;

/**
 * A callback interface for generating description texts for an item.
 *
 * @author Vaadin Ltd
 * @since 8.2
 *
 * @param <T>
 *            the item type
 */
@FunctionalInterface
public interface DescriptionGenerator<T>
        extends SerializableFunction<T, String> {
}
