/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.dnd.event;

import com.vaadin.shared.ui.dnd.EffectAllowed;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.ui.dnd.DragSourceExtension;

/**
 * HTML5 drag start event.
 *
 * @param <T>
 *            Type of the component that is dragged.
 * @author Vaadin Ltd
 * @see DragSourceExtension#addDragStartListener(DragStartListener)
 * @since 8.1
 */
public class DragStartEvent<T extends AbstractComponent>
        extends Component.Event {
    private final EffectAllowed effectAllowed;

    /**
     * Creates a drag start event.
     *
     * @param source
     *            Component that is dragged.
     * @param effectAllowed
     *            Allowed effects from {@code DataTransfer.effectAllowed}
     *            object.
     */
    public DragStartEvent(T source, EffectAllowed effectAllowed) {
        super(source);

        this.effectAllowed = effectAllowed;
    }

    /**
     * Returns the {@code effectAllowed} parameter of this event.
     *
     * @return This event's {@code effectAllowed} parameter.
     */
    public EffectAllowed getEffectAllowed() {
        return effectAllowed;
    }

    /**
     * Returns the drag source component where the dragstart event occurred.
     *
     * @return Component which is dragged.
     */
    @Override
    @SuppressWarnings("unchecked")
    public T getComponent() {
        return (T) super.getComponent();
    }
}
