/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.event.dd;

import java.io.Serializable;

import com.vaadin.event.Transferable;
import com.vaadin.event.dd.acceptcriteria.AcceptCriterion;

/**
 * DragAndDropEvent wraps information related to drag and drop operation. It is
 * passed by terminal implementation for
 * {@link DropHandler#drop(DragAndDropEvent)} and
 * {@link AcceptCriterion#accept(DragAndDropEvent)} methods.
 * <p>
 * DragAndDropEvent instances contains both the dragged data in
 * {@link Transferable} (generated by {@link DragSource} and details about the
 * current drop event in {@link TargetDetails} (generated by {@link DropTarget}.
 *
 * @since 6.3
 *
 */
public class DragAndDropEvent implements Serializable {
    private Transferable transferable;
    private TargetDetails dropTargetDetails;

    public DragAndDropEvent(Transferable transferable,
            TargetDetails dropTargetDetails) {
        this.transferable = transferable;
        this.dropTargetDetails = dropTargetDetails;
    }

    /**
     * @return the Transferable instance representing the data dragged in this
     *         drag and drop event
     */
    public Transferable getTransferable() {
        return transferable;
    }

    /**
     * @return the TargetDetails containing drop target related details of drag
     *         and drop operation
     */
    public TargetDetails getTargetDetails() {
        return dropTargetDetails;
    }

}
