/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.server;

import java.io.Serializable;
import java.util.function.ToIntFunction;

/**
 * A {@link ToIntFunction} that is also {@link Serializable}.
 *
 * @see ToIntFunction
 * @author Vaadin Ltd
 * @since 8.0
 *
 * @param <T>
 *            the type of the input for this function
 */
@FunctionalInterface
public interface SerializableToIntFunction<T>
        extends ToIntFunction<T>, Serializable {
    // Only method inherited from ToIntFunction
}
