/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.data;

import com.vaadin.server.SerializableFunction;

/**
 * Provider interface for generating localizable error messages using
 * {@link ValueContext}.
 *
 * @since 8.0
 * @author Vaadin Ltd.
 */
@FunctionalInterface
public interface ErrorMessageProvider
        extends SerializableFunction<ValueContext, String> {

    /**
     * Returns a generated error message for given {@code ValueContext}.
     *
     * @param context
     *            the value context
     *
     * @return generated error message
     */
    @Override
    public String apply(ValueContext context);
}
