/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.dnd.event;

import java.lang.reflect.Method;

import com.vaadin.event.ConnectorEventListener;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.dnd.DropTargetExtension;
import com.vaadin.util.ReflectTools;

/**
 * Interface to be implemented when creating a drop listener on a drop target
 * for HTML5 drag and drop.
 *
 * @param <T>
 *            Type of the drop target component.
 * @author Vaadin Ltd
 * @see DropTargetExtension#addDropListener(DropListener)
 * @since 8.1
 */
@FunctionalInterface
public interface DropListener<T extends AbstractComponent>
        extends ConnectorEventListener {
    static final Method DROP_METHOD = ReflectTools
            .getMethod(DropListener.class);

    /**
     * Called when drop event is fired.
     *
     * @param event
     *            Server side drop event.
     */
    void drop(DropEvent<T> event);
}
