/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.data.provider;

/**
 * A data provider that lazy loads items from a back end containing hierarchical
 * data.
 *
 * @author Vaadin Ltd
 * @since 8.1
 *
 * @param <T>
 *            data provider data type
 * @param <F>
 *            data provider filter type
 */
public interface BackEndHierarchicalDataProvider<T, F>
        extends HierarchicalDataProvider<T, F>, BackEndDataProvider<T, F> {

}
