/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.server.osgi;

import java.util.ArrayList;
import java.util.List;

import org.osgi.service.component.annotations.Component;

import com.vaadin.osgi.resources.OsgiVaadinContributor;
import com.vaadin.osgi.resources.OsgiVaadinResource;

/**
 * OSGi service component registering bootstrap JS as published resources in
 * OSGi environments.
 *
 * @author Vaadin Ltd
 * @since 8.1
 */
@Component
public class BootstrapContribution implements OsgiVaadinContributor {
    private static final String[] RESOURCES = { "vaadinBootstrap.js",
            "vaadinBootstrap.js.gz" };

    @Override
    public List<OsgiVaadinResource> getContributions() {
        final List<OsgiVaadinResource> contributions = new ArrayList<>(
                RESOURCES.length);
        for (final String resource : RESOURCES) {
            contributions.add(OsgiVaadinResource.create(resource));
        }
        return contributions;
    }
}
