/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.event.selection;

import com.vaadin.event.SerializableEventListener;

/**
 * A listener for {@code SelectionEvent}.
 * <p>
 * This is a generic listener for both type of selections, single and
 * multiselect.
 *
 * @author Vaadin Ltd.
 *
 * @param <T>
 *            the type of the selected item
 *
 * @see SelectionEvent
 *
 * @since 8.0
 */
@FunctionalInterface
public interface SelectionListener<T> extends SerializableEventListener {

    /**
     * Invoked when the selection has changed by user or programmatically.
     *
     * @param event
     *            the selection event
     */
    public void selectionChange(SelectionEvent<T> event);

}
