/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui;

import java.util.IdentityHashMap;
import java.util.Map;

import com.vaadin.data.ValueProvider;

/**
 * Value provider class for declarative support.
 * <p>
 * Provides a straightforward mapping between an item and its value.
 *
 * @param <T>
 *            item type
 */
class DeclarativeValueProvider<T> implements ValueProvider<T, String> {

    private final Map<T, String> values = new IdentityHashMap<>();

    @Override
    public String apply(T t) {
        return values.get(t);
    }

    /**
     * Sets a {@code value} for the item {@code t}.
     *
     * @param t
     *            a data item
     * @param value
     *            a value for the item {@code t}
     */
    void addValue(T t, String value) {
        values.put(t, value);
    }

}
