/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.components.grid;

import com.vaadin.event.SerializableEventListener;
import com.vaadin.ui.Grid;

/**
 * An event listener for column visibility change events in the Grid.
 *
 * @author Vaadin Ltd
 * @since 8.0
 */
@FunctionalInterface
public interface ColumnVisibilityChangeListener extends SerializableEventListener {

    /**
     * Called when a column has become hidden or unhidden.
     *
     * @param event
     *            the event
     */
    void columnVisibilityChanged(Grid.ColumnVisibilityChangeEvent event);
}
