/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.components.grid;

import com.vaadin.event.SerializableEventListener;
import com.vaadin.ui.Grid;

/**
 * An event listener for a {@link Grid} editor cancel events.
 *
 * @author Vaadin Ltd
 * @since 8.0
 *
 * @see EditorCancelEvent
 * @see Editor#addCancelListener(EditorCancelListener)
 *
 * @param <T>
 *            the bean type
 */
@FunctionalInterface
public interface EditorCancelListener<T> extends SerializableEventListener {

    /**
     * Called when the editor is cancelled.
     *
     * @param event
     *            cancel event
     */
    public void onEditorCancel(EditorCancelEvent<T> event);
}
